国土交通省 水管理国土保全局 河川砂防技術基準の概要

2025年3月11日

# 河川砂防技術基準の概要

> 国土交通省水管理・国土保全局では、河川・砂防・地すべり・急傾斜地・雪崩及び海岸（以下「河川等」という）行政の技術的分野に関する基準として「河川砂防技術基準（以下「技術基準」という）」を昭和３３年に制定し、各地方整備局と都道府県等に通知しているところである。技術基準は数度の改定を経て、調査編・計画編・設計編・維持管理編の４編から構成されている。（なお、後段に述べるように、計画編については、基本計画編と施設配置等計画編の二編で構成され、維持管理編については維持管理編（河川編）、維持管理編（砂防編）、維持管理編（ダム編）の三編で構成されている。）
>
> 技術基準の内容は、河川等に係る技術についての日々の技術研究開発による技術の進展等を盛り込む形で更新されていくことが、河川等に関する調査、計画、設計及び維持管理を実施する上で重要である。

# 技術基準の制定主旨

技術基準の制定主旨は、「淀川計画高水論」を著した米田正文博士による技術基準（1958（昭和33）年）の序文に示されている。米田博士の序文の中から技術基準の制定主旨及び理念について重要な箇所を抜粋して次に示す。

（前略）

河川に関する技術は、わが国において、最も早くより発達したにもかかわらず、これに関する技術基準がほとんどなかったといっても過言でないと思う。そのため新進の学究者は先輩のたどった道を操返すことが多かった。成功の場合でも失敗の場合でも、これは改めるべきである。新進者は少なくとも先輩の築き上げた技術の水準を基礎として、それよりの進歩に努めなければならない。かくて技術は段階的に進歩をするものである。この段階を示すのがこの技術基準である。すなわち、今日の段階における建設省の河川に関する技術水準はこの基準書に示す通りであるが、来年の技術水準はこの基準書よりもさらに進歩すべきものであって、できれば毎年この基準書は改訂を加えてゆくべき性格のものである。かようにすることによって建設省の技術基準は毎年進歩し、しかもその進歩の跡が明らかになり、新進者の研究を促進することになる。かくて河川に関する技術は秩序よく、能率的に、加速度的に前進するであろうと思う。これが私のこの技術基準書を制定しようとした動機であるが、この基準が将来の河川技術の基礎となってけんらんたる技術の殿堂が築かれることを固く信じている。

（後略）

# 技術基準の目的

## 技術基準の目的

河川砂防技術基準は、国土の重要な構成要素である土地・水を流域の視点を含めて適正に管理するため、河川、砂防、地すべり、急傾斜地、雪崩及び海岸（以下「河川等」という。）に関する調査、計画、設計及び維持管理を実施するために必要な技術的事項について定めるもので、これによって河川等に係わる技術の体系化を図り、もってその水準の維持と向上に資することを目的とする。

## 技術基準の構成

「調査編」「計画編」「設計編」「維持管理編」の４編で構成されている。なお、計画編については、基本計画編と施設配置等計画編の二編で構成され、維持管理編については維持管理編（河川編）、維持管理編（砂防編）、維持管理編（ダム編）の三編で構成されている。

河川等の計画、設計及び維持管理等の適正な実施のために、「計画編」、「設計編」、「維持管理編」を用いて検討や業務を実施し、その検討目的や業務遂行に必要な調査手法等については、調査編が適切な手法を提示するものである。そのほか、他編を介さず、調査編が直接的に手法を提示する場合もある。

![図 1　各編の関係](media/image1.emf){width="3.451388888888889in"
height="3.378701881014873in"}

## 技術基準の適用

河川砂防技術基準は、各種法に基づいて管理される河川等に対して適用されるほか、それ以外の河川等についても、法及び本基準の主旨を鑑み、調査、計画、設計及び維持管理等を適切に実施するものとする。

技術基準は、その適用上の位置付けを明確化するために、各節の各項において＜必須＞、＜標準＞となる事項（技術基準）を明記している。

また、技術基準の理解を深めるために、各項に関連した＜考え方＞、＜推奨＞、＜例示＞、参考となる関連する通知、手引き、マニュアル等の＜関連通知等＞＜参考となる資料＞を、技術資料としてとりまとめている。

上述のように適用上の位置づけは、考え方、必須、標準、推奨、例示の5分類であり、その内容は次に示すとおりである。

1.  「考え方」\
    「考え方」の適用上の位置づけの分類は、技術資料である。技術資料として目的や概念、考え方を記述した事項を示す。

2.  「必須」\
    「必須」の適用上の位置づけの分類は、技術基準である。法令による規定や技術的観点から実施すべきであることが明確であり遵守すべき事項を示す。

3.  「標準」\
    「標準」の適用上の位置づけの分類は、技術基準である。状況や条件によって一律に規制することはできないが、特段の事情がない限り記述に従い実施すべき事項を示す。

4.  「推奨」\
    「推奨」の適用上の位置づけの分類は、技術資料である。状況や条件によって実施することが良い事項を示す。

5.  「例示」\
    「例示」の適用上の位置づけは、技術資料である。適用条件や実施効果について確定している段階ではないが、状況や条件によっては導入することが可能な新技術等の例示、状況や条件によって限定的に実施できる技術等の例示、具体的に例示することにより、技術的な理解を助ける事項を示す。

## 技術基準類の体系

河川砂防技術基準を適切に運用するため、河川砂防技術基準を含む技術基準類は３層から構成されており、＜必須＞＜標準＞となる技術的事項のみを局長通達としている。

技術基準類の１層目は、河川砂防技術基を準指し、河川砂防技術基準の技術資料は１層目の説明資料となる。技術基準類の２層目は指針・ガイドラインを指し、「指針・ガイドライン等」（水管理・国土保全局のHP
）に公開された関連資料（河川堤防設計指針、中小河川に関する河道計画の技術基準、治水経済調査マニュアル　等）が該当する。技術基準類の３層目は、参考図書類であり、財団が発行した手引き類（河道計画検討の手引き、多自然川づくりポイントブックⅢ、河川堤防の構造検討の手引き、中小河川計画の手引き等）や土木学会の水理公式集、論文等が該当する。技術基準類の３層構造とは次を示す。（併せて図
2参照）

- １層目：河川砂防技術基準

  - 河川砂防技術基準＜必須＞＜標準＞である技術的事項

- １層目の説明資料：河川砂防技術基準の技術資料

  - 河川砂防技術基準の技術資料は技術的事項について体系的整理された資料であり、＜考え方＞＜推奨＞＜例示＞＜関連通知等＞＜参考となる資料＞を加えた資料

- ２層目：指針・ガイドライン等

  - 一定の検討の枠組みを示す必要がある技術的事項（場合により手法も含む）をとりまとめたもの。

  - 技術の熟度が高まった段階で、その技術的内容が、＜必須＞または＜標準＞に取り入れられる。

  - 「指針・ガイドライン等」（水管理・国土保全局のHP
    ）に公開された関連資料（河川堤防設計指針、中小河川に関する河道計画の技術基準、治水経済調査マニュアル　等）が該当する。

- ３層目：参考図書類（手法等）

  - 技術的事項に関する具体的な検討手法が記載されたもの。技術的拘束力は無い。

  - 財団が発行した手引き類（河道計画検討の手引き、多自然川づくりポイントブックⅢ、河川堤防の構造検討の手引き、中小河川計画の手引き等）や土木学会の水理公式集、論文等が該当する。

![図
2　技術基準類の３層構造](media/image2.emf){width="6.298611111111111in"
height="4.373611111111111in"}

# 技術基準の各編の目的と内容

## 調査編

河川等の計画、設計及び維持管理等の適正な実施に資することを目的として、現状の技術水準に照らし合わせて基準となる調査手法等を規定している。

水文・水理現象に関する調査など、個々の現象に関する調査の考え方に加え、調査により得られた観測結果及び分析・検討結果等が有効に活用されるよう、適切に保存・管理するための各編に共通する基本的な考え方を記載している。

## 計画編

### 計画編 基本計画編

災害の防止・軽減、河川等の適正な利用、流水の正常な機能の維持及び河川環境等の整備と保全を行ううえで、河川等の諸計画の立案や見直しにあたっての基本的な方針、計画策定の手法・検討すべき視点を記載している。

河川管理者等は、諸計画に基づき実施する対策に加え、流域の関係者と緊密に連携した効果的な防災・減災対策を進めることが重要であるため、流域における連携と情報を共有する取組について記載している。

### 計画編 施設配置等計画編

河川等の諸計画に基づき、施設配置計画（河道の平面形や縦横断形の設定、構造物の配置検討等）を行う際に必要な技術的事項を記載している。

河川環境等の整備と保全及び総合的な土砂管理に関する計画を策定するにあたり、検討すべき基本的な事項を示している。

河川等の管理者や自治体・住民らが調査結果等を活用できるようにするための情報システムのあり方について記載している。

## 設計編

河川等の諸計画及び施設配置計画に基づき構造物を設計するにあたっての基本的な方針、適切な機能や安全性についての一般的かつ基本的な規定を示している。

## 維持管理編

### 維持管理編（河川編）

適正な河川管理のため、河川維持管理に必要とされる主な事項をとりまとめ、河川維持管理に関する計画、河川維持管理目標、河川の状態把握、維持管理対策及び水防等のための対策について定めている。

### 維持管理編（ダム編）

適切なダムの維持管理のため、ダムの維持管理における標準的な技術を体系化し、ダム施設及び貯水池の維持管理（計画的な維持管理、状況把握、維持管理の評価と対策）、流水管理、ダムの管理に係るフォローアップについて定めている。

### 維持管理編（砂防編）

適切な砂防関係施設の維持管理のために、各々の砂防関係施設について機能及び性能を明示し、点検、評価方法等の維持管理を計画的に実施するために必要な事項を定めている。

# 

# 各編の目次構成

各編の目次構成を示す。

## 調査編の目次構成

調査編の目次構成を以下に示す。

第１章　総論

　第１節 総説

　第２節 河川砂防技術基準の調査編と他編の関係

　第３節 調査編の構成

　第４節 内容の更新

第２章　水文・水理観測

　第１節 総説

　第２節 降水量等観測

　第３節 水位観測

　第４節 流量観測

　第５節 水文資料の整理・保存と品質管理

　第６節 地下水観測

　第７節 河川の流れの総合的把握

　第８節 河川・流域の水循環の観測

第３章　水文解析

　第１節 水文統計解析

　第２節 流出解析

　第３節 地下水解析

第４章　河道特性調査

　第１節 総説

　第２節 河道特性調査に際しての基本的な捉え方

　第３節 各時点の河道状況

　第４節 河道状況の時間的変化

　第５節 洪水の作用

　第６節 土砂流送特性

　第７節 河道を取り巻く諸状況

　第８節 調査結果のとりまとめ及び包括分析

第５章　河川における洪水流の水理解析

　第１節　総説

　第２節　洪水流解析の目的

　第３節　目的に応じた洪水流解析手法の選定

　第４節　計算手法の説明

　第５節　パラメータの設定

第６章　河床変動、河床材料変化及び土砂流送の解析

　第１節　総説

　第２節　目的に応じた解析レベルの選定

　第３節　計算法の設定

　第４節　各種条件等の設定

　第５節　解析の実施と検証・調整

第７章　氾濫解析

　第１節　総説

　第２節　氾濫域調査

　第３節　外水氾濫解析

　第４節　内水氾濫解析

　第５節　氾濫解析結果の活用

第８章　河川経済調査

　第１節　総説

　第２節　治水経済調査

　第３節　河川環境経済調査

第９章　水害リスク評価

　第１節　総説

　第２節　水害リスク評価の枠組みと手順

第１０章　災害調査

　第１節　総説

　第２節　対象とする区域等に応じた災害調査

　第３節　災害調査成果の蓄積と共有化

第１１章　河川環境調査

　第１節　総説

　第２節　河川における環境調査の手法について

　第３節　河川流量調査

　第４節　河道形状調査

　第５節　河道構成材料調査

　第６節　河川水質

　第７節　植物調査

　第８節　付着藻類調査

　第９節　魚類調査

　第１０節　底生動物調査

　第１１節　鳥類調査

　第１２節　両生類・爬虫類・哺乳類調査

　第１３節　陸上昆虫類等調査

　第１４節　河川空間利用実態調査

　第１５節　河川景観調査

　第１６節　河川環境の総合的な分析

　第１７節　新しい技術の活用

　第１８節　環境影響評価

　第１９節　戦略的環境アセスメント

第１２章　水質・底質調査

　第１節　総説

　第２節　水質調査

　第３節　底質調査

　第４節　汚濁負荷量調査及び水質汚濁予測調査

第５節　水質事故時の水質調査

　第６節　流域圏スケールの物質動態把握

第１３章　湖沼・ダム貯水池の環境調査

　第１節　総説

　第２節　湖沼・ダム貯水池の物理環境調査

　第３節　湖沼・ダム貯水池の水質特性調査

　第４節　湖沼における生物調査

　第５節　ダム貯水池における生物調査等

第１４章　汽水域・河口域の環境調査

　第１節　総説

　第２節　汽水域・河口域の環境調査

　第３節　人為的改変による物理・化学的現象の調査・分析方法

第１５章　土質地質調査

　第１節　総説

　第２節　河川堤防の土質地質調査

　第３節　河川構造物の土質・地質調査

　第４節　ダムの地質調査

第１６章　総合的な土砂管理のための調査

　第１節　総説

　第２節　調査の基本的組立て方

　第３節　調査結果の蓄積・共有化

第１７章　砂防調査

　第１節　総説

　第２節　基礎的な調査

　第３節　短期（一連の降雨継続期）土砂・流木流出対策のための調査

　第４節　中期（土砂流出活発期）土砂流出対策のための調査

　第５節　長期（土砂流出継続期）土砂流出対策のための調査

　第６節　火山砂防のための調査

　第７節　深層崩壊・天然ダム等異常土砂災害対策のための調査

　第８節　土砂災害に対するソフト対策のための調査

　第９節　環境調査

　第１０節　砂防経済調査

第１８章　地すべり調査

　第１節　総説

　第２節　地すべり防止のための調査

　第３節　緊急時の調査

　第４節　地すべり防止施設の効果評価

　第５節　地すべり経済調査

第１９章　急傾斜地調査

　第１節　総説

　第２節　急傾斜地の崩壊防止のための調査

　第３節　環境調査

　第４節　崩壊斜面等調査

　第５節　急傾斜地経済調査

第２０章　雪崩調査

　第１節　総説

　第２節　雪崩対策のための調査

　第３節　環境調査

第２１章　海岸調査

　第１節　総説

　第２節　海岸概況調査

　第３節　気象調査

　第４節　海面変動調査

　第５節　波浪調査

　第６節　流れの調査

　第７節　漂砂調査

　第８節　海岸測量

　第９節　海岸環境調査

　第１０節　海岸利用調査

　第１１節　海岸漂着物調査

　第１２節　海岸災害調査

　第１３節　高潮浸水解析

　第１４節　津波浸水解析

　第１５節　海岸事業の費用便益分析

第２２章　測量・計測

　第１節　総説

　第２節　河川等に関する測量

　第３節　様々な計測技術の活用

第２３章　調査結果の保存

　第１節　総説

## 計画編

### 計画編 基本計画編の目次構成

計画編 基本計画編の目次構成を以下に示す。

第１章　基本方針

　第１節　総説

　第２節　災害の防止・軽減

　第３節　河川等の適正な利用及び流水の正常な機能の維持並びに河川環境等の整備と保全

　第４節　総合的な土砂管理

　第５節　モニタリング

第２章　河川計画

　第１節　河川計画に関する基本的な事項

　第２節　洪水防御に関する計画の基本的な事項

　第３節　河川の適正な利用及び流水の正常な機能の維持に関する基本的な事項

　第４節　河川環境の整備と保全に関する基本的な事項

第３章　砂防(土砂災害等対策)計画

　第１節　総説

　第２節　砂防基本計画に関する基本的な事項

　第３節　地すべり防止計画に関する基本的な事項

　第４節　急傾斜地崩壊対策計画に関する基本的な事項

　第５節　雪崩対策計画に関する基本的な事項

　第６節　自然環境への配慮等

　第７章　土砂災害のソフト対策に関する基本的な事項

第４章　海岸保全計画

　第１節　総説

　第２節　海岸防護に関する基本的な事項

第３節　海岸環境の整備と保全に関する基本的な事項

　第４節　海岸利用に関する基本的な事項

第５章　流域における連携と情報の共有

　第１節　総説

　第２節　災害の防止・軽減に関する連携

　第３節　河川等の適正な利用及び流水の正常な機能の維持並びに河川環境等の整備と保全に関する連携

　第４節　河川とまちづくりの連携

### 計画編 施設配置等計画編の目次構成

計画編 施設配置等計画編の目次構成を以下に示す。

総説

第１章　河川環境等の整備と保全及び総合的な土砂管理

　第１節　河川環境等の整備と保全

　第２節　総合的な土砂管理

第２章　河川管理施設配置計画

第２－１章　河道並びに河川構造物

　第１節　河道計画

　第２節　捷水路及び放水路

　第３節　貯水池(ダム)

　第４節　遊水地等

　第５節　堰,水門,樋門

　第６節　流況調整河川計画

　第７節　高規格堤防

第２－２章　内水処理施設

　第１節　総説

　第２節　内水処理方式の検討

　第３節　検討対象内水の選定

　第４節　確率評価手法の検討

　第５節　内水処理施設規模の決定

第２－３章　多目的施設

　第１節　総説

　第２節　施設基本計画

第２－４章　水質保全施設

　第１節　総説

　第２節　河川における水質保全対策

　第３節　貯水池・湖沼等における水質保全対策

第３章　砂防等施設配置計画

第３－１章　総説

第３－２章　砂防施設配置計画

　第１節　総説

　第２節　短期（一連の降雨継続期）土砂・流木流出対策施設配置計画

　第３節　中期（土砂流出活発期）土砂流出対策施設配置計画

　第４節　長期（土砂流出活発期）土砂流出対策施設配置計画

　第５節　火山砂防施設配置計画

　第６節　深層崩壊・天然ダム等異常土砂災害対策施設配置計画

　第７節　地すべり防止施設配置計画

　第８節　急傾斜地崩壊対策施設配置計画

　第９節　雪崩対策施設配置計画

　第１０節　都市山麓グリーンベルト施設配置計画の基本

第４章　海岸保全施設配置計画

　第１節　総説

　第２節　侵食対策施設等

　第３節　高潮対策施設

　第４節　津波対策施設

第５章　情報システムの整備

　第１節　総説

## 設計編の目次構成

設計編の目次構成を以下に示す。

第１章　河川構造物の設計

　第１節　総説

　第２節　堤防

　第３節　高規格堤防

　第４節　護岸

　第５節　水制

　第６節　床止め

　第７節　堰

　第８節　樋門

　第９節　水門

　第１０節　トンネル構造による河川

　第１１節　排水機場

第２章　ダムの設計

　第１節　総説

　第２節　ダムの基本形状、型式及び位置の決定

　第３節　ダム設計の基本条件

　第４節　コンクリートダムの設計

　第５節　フィルダムの設計

　第６節　ダムの基礎地盤の設計

　第７節　洪水吐き及びその他の放流設備の設計

　第８節　ゲートの設計

　第９節　管理設備の設計

　第１０節　試験湛水

　第１１節　ダム再生

　第１２節　ダムの耐震性能照査

　第１３節　台形CSGダム

第３章　砂防施設の設計

　第１節　総則

　第２節　砂防ダム

　第３節　床固工

第４節　護岸

　第５節　水制工

　第６節　流路工

　第７節　山腹工

　第８節　その他の施設

第４章　地すべり防止施設の設計

　第１節　総説

　第２節　抑制工の設計

　第３節　抑止工の設計

第５章　急傾斜地崩壊防止施設の設計

　第１節　総説

　第２節　各施設の設計

第６章　雪崩対策施設の設計

　第１節　総説

　第２節　予防工の設計

　第３節　防護工の設計

第７章　海岸保全施設の設計

　第１節　総説

　第２節　設計基礎条件

　第３節　堤防および護岸

　第４節　突堤

　第５節　離岸堤

　第６節　消波堤

　第７節　リーフ工法

　第８節　養浜

　第９節　高潮・津波防波堤

　第１０節　附帯施設

## 維持管理編

### 維持管理編（河川編）の目次構成

維持管理編（河川編）の目次構成を以下に示す。

第１章　総説

　第１節　目的

　　１．１　本基準の目的

　　１．２　河川維持管理の技術的基準を定める際の基本的な考え方

　　１．３　本基準の位置付け

　第２節　河川維持管理の基本方針

　第３節　適用範囲

第２章　河川維持管理に関する計画

　第１節　河川維持管理計画

　　１．１　一般

　　１．２　計画に定める事項

　第２節　サイクル型維持管理

　　２．１　サイクル型維持管理体系の構築

　　２．２　河道計画等との関係

第３章　河川維持管理目標

　第１節　一般

　第２節　河道流下能力の維持に係る目標設定

　第３節　施設の機能維持に係る目標設定

　　３．１　基本

　　３．２　河道（河床低下・洗堀の対策）に係る目標

　　３．３　堤防に係る目標

　　３．４　護岸、根固め工、水制工に係る目標

　　３．５　床止め（落差工、帯工含む。）に係る目標

　　３．６　堰、水門、樋門、排水機場等に係る目標

　　３．７　水文・水理観測施設に係る目標

　第４節　河川区域等の適正な利用に係る目標

　第５節　河川環境の整備と保全に係る目標

第４章　河川の状態把握

　第１節　一般

　第２節　基本データの収集

　　２．１　水文・水理等観測

　　２．２　測量

　　　２．２．１　縦横断測量

　　　２．２．２　地形測量

　　２．３　河道の基本データ

　　２．４　河川環境の基本データ

　　２．５　観測施設、機器の点検

　第３節　堤防点検等のための環境整備

　第４節　河川巡視

　　４．１　一般

　　４．２　平常時の河川巡視

　　４．３　出水時の河川巡視

　第５節　点検

　　５．１　出水期前、台風期、出水後等の点検

　　　５．１．１　出水期前、台風期の点検

　　　５．１．２　出水後等の点検

　　５．２　地震後の点検

　　５．３　親水施設等の点検

　　５．４　機械設備を伴う河川管理施設の点検

　　５．５　許可工作物の点検

　第６節　河川カルテ

　第７節　河川の状態把握の分析、評価

第５章　河道流下能力の維持管理のための対策

　第１節　河道流下能力の維持・河床低下対策

　第２節　河岸の対策

　第３節　樹木の対策

　第４節　河口部の対策

第６章　施設の維持及び修繕・対策

　第１節　河川管理施設一般

　　１．１　土木施設

　　１．２　機械設備・電気通信施設

　第２節　堤防

　　２．１　土堤

　　　２．１．１　堤体

　　　２．１．２　除草

　　　２．１．３　天端

　　　２．１．４　坂路・階段工

　　　２．１．５　堤脚保護工

　　　２．１．６　堤脚水路

　　　２．１．７　側帯

　　２．２　特殊堤

　　　２．２．１　胸壁構造の特殊堤

　　　２．２．２　自立式構造の特殊堤

　　２．３　霞堤

　　２．４　越流堤、導流堤、背割堤、二線堤

　第３節　護岸

　　３．１　護岸一般（コンクリート擁壁、矢板護岸以外）

　　３．２　コンクリート擁壁

　　３．３　矢板護岸

　第４節　根固工

　第５節　水制工

　第６節　樋門・水門

　　６．１　本体

　　６．２　ゲート設備

　　６．３　電気通信施設、付属施設

　第７節　床止め・堰

　　７．１　本体及び水叩き

　　７．２　護床工

　７．３　護岸、取付擁壁及び高水敷保護工

　　７．４　魚道

　　７．５　ゲート設備

　　７．６　電気通信施設

　　７．７　付属施設

　第８節　排水機場

　　８．１　土木施設

　　８．２　ポンプ設備

　　８．３　電気通信施設

　　８．４　機場上屋

　第９節　陸閘

　第１０節　河川管理施設の操作

　第１１節　許可工作物

　　１１．１　基本

　　１１．２　伏せ越し

　　１１．３　取水施設

　　１１．４　橋梁

　　　１１．４．１　橋台

　　　１１．４．２　橋脚

　　　１１．４．３　取付道路

　　１１．５　堤外・堤内水路

第７章　河川区域等の維持管理対策

　第１節　一般

　第２節　不法行為への対策

　　２．１　基本

　　２．２　ゴミ、土砂、車両等の不法投棄

　　２．３　不法占用（不法係留船を除く。）への対策

　　２．４　不法係留船（放置艇）への対策

　　２．５　不法な砂利採取への対策

　第３節　河川の適正な利用

　　３．１　基本

　　３．２　河川の安全な利用

　　３．３　水面利用

第８章　河川環境の維持管理対策

第９章　水防等のための対策

　第１節　水防のための対策

　　１．１　水防活動等への対応

　　１．２　水位情報等の提供

　第２節　水質事故対策

### 維持管理編（ダム編）の目次構成

維持管理編（ダム編）の目次構成を以下に示す。

第１章　総説

　第１節　目的

　第２節　基本方針

　　２．１　維持管理の基本方針

　　２．２　ダム施設及び貯水池の維持管理

　　２．３　流水管理

　　２．４　ダムの管理に係るフォローアップ

　第３節　適用範囲

第２章　ダム施設及び貯水池の維持管理

　第１節　ダム施設及び貯水池の計画的な維持管理

　　１．１　総説

　　１．２　ダム施設の維持管理

　　　１．２．１　ダム点検整備基準

　　　１．２．２　ダムの長寿命化計画

　　１．３　貯水池の維持管理

　第２節　ダム施設及び貯水池の状態把握

　　２．１　総説

　　２．２　点検等

　　　２．２．１　巡視・日常点検

　　　２．２．２　臨時点検

　　　２．２．３　ダム総合点検

　　　２．２．４　定期検査

　　２．３　観測・調査等

　　　２．３．１　水文・水理観測及び気象情報の収集

　　　２．３．２　堆砂調査

　　　２．３．３　水質調査

　　　２．３．４　環境調査

　　２．４　点検・観測等の記録

　第３節　ダム施設の維持管理の評価と対策

　　３．１　総説

　　３．２　土木構造物

　　　３．２．１　評価

　　　３．２．２　対策

　　３．３　機械設備

　　　３．３．１　評価

　　　３．３．２　対策

　　３．４　電気通信施設

　　　３．４．１　評価

　　　３．４．２　対策

　　３．５　ダム管理用水力発電設備

　　３．６　貯水池周辺斜面

　　　３．６．１　評価

　　　３．６．２　対策

　　３．７　観測・計測設備

　　３．８　維持・修繕等の記録

　第４節　貯水池の維持管理対策

　　４．１　総説

　　４．２　堆砂対策

　　４．３　水質保全対策

　　４．４　流木対策

　　４．５　不法行為への対策

　　４．６　貯水池の適正な利用・水源地域の活性化

　　４．７　貯水池及びその周辺の環境保全対策

　　４．８　水質事故対策

　第５節　許可工作物

第３章　流水管理

　第１節　総説

　　１．１　総説

　　１．２　操作規則等

　　１．３　水文・水理観測及び気象情報の収集

　第２節　運用操作

　　２．１　ダムの操作

　　２．２　ダムの弾力的な管理・運用

　　　２．２．１　事前放流

　　　２．２．２　特別防災操作\<ただし書き操作\>

　　　２．２．３　環境保全を目的とした弾力的管理

　第３節　渇水対策

　第４節　管理情報の記録

　第５節　管理情報の提供

第４章　ダムの管理に係るフォローアップ

### 維持管理編（砂防編）の目次構成

維持管理編（砂防編）の目次構成を以下に示す。

第１章　総説

　第１節　目的

　第２節　適用範囲

　第３節　維持管理の基本方針

第２章　砂防関係施設の長寿命化計画

　第１節　一般

　第２節　計画に定める事項

第３章　砂防関係施設の点検及び健全度評価

　第１節　砂防関係施設の点検

　第２節　点検時期と点検頻度

　第３節　基本データの収集

　第４節　点検の方法

　第５節　砂防関係施設の健全度評価

　第６節　点検結果の保存

第４章　砂防設備及びその周辺の状態把握

　第１節　一般

　第２節　砂防設備及びその周辺の基本データ

　第３節　砂防設備の健全度評価

第５章　地すべり防止施設及びその周辺の状態把握

　第１節　一般

　第２節　地すべり防止施設及びその周辺の基本データ

　第３節　地すべり防止施設の健全度評価

第６章　急傾斜地崩壊防止施設及びその周辺の状態把握

　第１節　一般

　第２節　急傾斜地崩壊防止施設及びその周辺の基本データ

　第３節　急傾斜地崩壊防止施設の健全度評価

第７章　雪崩対策施設及びその周辺の状態把握

　第１節　一般

　第２節　雪崩対策施設及びその周辺の基本データ

　第３節　雪崩対策施設の健全度評価

第８章　砂防関係施設の維持・修繕等

　第１節　一般

　第２節　対策の優先順位の検討と年次計画（中期、短期）の策定

第９章　砂防設備の維持・修繕等

　第１節　一般

　第２節　砂防堰堤、床固工、帯工、遊砂地工

　　２．１　施設本体

　　２．２　除石

　第３節　渓流保全工

　第４節　護岸、水制工、導流工

　第５節　山腹工

　第６節　管理用道路

　第７節　魚道

第１０章　地すべり防止施設の維持・修繕等

　第１節　一般

　第２節　地表排水工

　第３節　横ボーリング工

　第４節　集水井工

　第５節　排水トンネル工

　第６節　排土工

　第７節　押え盛土工

　第８節　侵食防止工

　第９節　杭工、シャフト工

　第１０節　アンカー工

第１１章　急傾斜地崩壊防止施設の維持・修繕等

　第１節　一般

　第２節　排水工

　第３節　のり面保護工

　第４節　押さ盛土工

　第５節　切土工

　第６節　擁壁工

　第７節　アンカー工、地山補強土工

　第８節　杭工

　第９節　待受工

　第１０節　落石対策工

第１２章　雪崩対策施設の維持・修繕等

　第１節　一般

　第２節　予防工

　第３節　防護工

第１３章　観測機器等の維持管理

　第１節　一般
