**調査編**

1.  **総論**

**目　次**

[第1節 総説 1](#_Toc167445772)

> [1．1 基準の目的 1](#_Toc167445773)
>
> [1．2 基本的な考え方 1](#_Toc167445774)
>
> [1．3 改定の要点 1](#_Toc167445775)
>
> [1．4 河川等の調査に係る技術基準の体系化 2](#_Toc167445776)
>
> [1．5 国際貢献 2](#_Toc167445777)
>
> [1．6 資料等の整理・活用 2](#_Toc167445778)
>
> [1．7 調査結果等の活用 2](#_Toc167445779)

[第2節 河川砂防技術基準の調査編と他編の関係 4](#_Toc167445780)

[第3節 調査編の構成 4](#_Toc167445781)

> [3．1 全体構成 4](#_Toc167445782)
>
> [3．2 横断的な内容の充実 4](#_Toc167445783)
>
> [3．3 激甚化する災害への対応 5](#_Toc167445784)
>
> [3．4 調査目的と各章の相互関係 6](#_Toc167445785)

[第4節 内容の更新 6](#_Toc167445786)

令和６年５月　版

適用上の位置付け

> 河川砂防技術基準調査編は、基準の適用上の位置付けを明確にするために、下表に示すように適用上の位置付けを分類している。

+--------+------------------+------------------+------------------+
| 分　類 | 適用上の位置付け | 末尾の字句例     |                  |
+--------+------------------+------------------+------------------+
| 考え方 | 技術資料         | ●目              | 「･･･ある。      |
|        |                  | 的や概念、考え方 | 」「･･･いる。」  |
|        |                  | を記述した事項。 |                  |
|        |                  |                  | 「･･･なる。      |
|        |                  |                  | 」「･･･れる。」  |
+--------+------------------+------------------+------------------+
| 必　須 | 技術基準         | ●法令による規定  | 「･･･なければ    |
|        |                  | や技術的観点から | ならない。」「･  |
|        |                  | 実施すべきである | ･･ものとする。」 |
|        |                  | ことが明確であり |                  |
|        |                  | 遵守すべき事項。 |                  |
+--------+------------------+------------------+------------------+
| 標　準 | 技術基準         | ●特              | 「･･･            |
|        |                  | 段の事情がない限 | を標準とする。」 |
|        |                  | り記述に従い実施 |                  |
|        |                  | すべきだが、状況 | 「･･･            |
|        |                  | や条件によって一 | を基本とする。」 |
|        |                  | 律に適用すること |                  |
|        |                  | はできない事項。 | 「･･･による。」  |
+--------+------------------+------------------+------------------+
| 推　奨 | 技術資料         | ●状況や条件      | 「               |
|        |                  | によって実施する | ･･･望ましい。」  |
|        |                  | ことが良い事項。 |                  |
|        |                  |                  | 「               |
|        |                  |                  | ･･･推奨する。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･努める。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･必要に応    |
|        |                  |                  | じて･･･する。」  |
+--------+------------------+------------------+------------------+
| 例　示 | 技術資料         | ●適用条件や実施  | 「               |
|        |                  | 効果について確定 | ･･･などの手法（  |
|        |                  | している段階では | 事例）がある。」 |
|        |                  | ないが、状況や条 |                  |
|        |                  | 件によっては導入 | 「･･･など        |
|        |                  | することが可能な | の場合がある。」 |
|        |                  | 新技術等の例示。 |                  |
|        |                  |                  | 「･･･など        |
|        |                  | ●状              | が考えられる。」 |
|        |                  | 況や条件によって |                  |
|        |                  | 限定的に実施でき | 「               |
|        |                  | る技術等の例示。 | ･･･の場合には･･･ |
|        |                  |                  | ことができる。」 |
|        |                  | ●具体的          |                  |
|        |                  | に例示することに | 「               |
|        |                  | より、技術的な理 | ･･･例示する。」  |
|        |                  | 解を助ける事項。 |                  |
|        |                  |                  | 「例えば･･･。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･事例もある  |
|        |                  |                  | 。･･･もよい。」  |
+--------+------------------+------------------+------------------+

  関連通知等       関連する通知やそれを理解する上で参考となる資料
  ---------------- ------------------------------------------------------
  参考となる資料   例示等に示した手法・内容を理解する上で参考となる資料

1.  総論

    1.  []{#_Toc167445772 .anchor}総説

        1.  []{#_Toc167445773 .anchor}基準の目的

＜考え方＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  河川砂防技術基準調査編（以下「調査編」という）は、河川、砂防、地すべり、急傾斜地、雪崩及び海岸（以下「河川等」という）の計画、設計及び維持管理等の適正な実施に資することを目的として、現状の技術水準に照らし合わせて基準となる調査手法等を規定したものである。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

2.  []{#_Toc167445774 .anchor}基本的な考え方

＜考え方＞

+----------------------------------------------------------------------+
| 河川等の計画、設                                                     |
| 計及び維持管理等の実施に当たっては、河川砂防技術基準計画編に示してい |
| るように「災害の防止・軽減、河川等の適正な利用、流水の正常な機能の維 |
| 持及び河川環境等の整備と保全の推進にあたっては、全国的バランス及び水 |
| 系全体のバランスを踏まえる」という視点が重要であり、河川そのものだけ |
| でなく流域全体を理解するとともに、流域の過去から現在に至るまでの変遷 |
| について理解し、空間的、時間的に広い視野で取り組むことが必要である。 |
|                                                                      |
| また、今後は高度成長期に整備された多くの河川管理施設等が老朽化により |
| 更新時期を迎えるとともに、既存施設の長寿命化や効果的、効率的な運用等 |
| が必要となるなど、河川等の適切な維持管理の視点がますます重要となる。 |
|                                                                      |
| 本調査編を活用し河川等の調査を実                                     |
| 施するに当たっては、上記の視点に常に留意して進めることが必要である。 |
|                                                                      |
| さらに、これまで実施してきた施策の評価や、気候変化に対する           |
| 適応策の検討、大規模・広域災害への対応など、調査の目的も複雑かつ多様 |
| になってきている。限られた予算の中で必要な調査を効率的に実施するため |
| には、調査目的を明確に設定し、その目的に応じて必要な精度を有する調査 |
| 手法を適切に選択し、組み合わせることにより調査を実施する必要がある。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  河川砂防技術基準計画編,令和4年6月9日,国水情第9号,国土交通省水管理・国土保全局.計画編　基本計画編
    第1章 第1節 総説.

    1.  []{#_Toc167445775 .anchor}改定の要点

＜考え方＞

+----------------------------------------------------------------------+
| 本調査編                                                             |
| においては、個々の調査手法の説明だけでなく、調査編の全体像やその中で |
| の各項目の位置付けおよび本編各章間の、さらには他編との関係もわかるよ |
| うにすることを重視している。また、対象とする調査目的に応じて手法を選 |
| 択できるようにすること、調査に求められる精度等に関する記載を充実させ |
| 、できるだけ実務との関連が分かるようにすることにも重点を置いている。 |
|                                                                      |
| 第1章                                                                |
| 総論では、調査に当たっての基本的な考え方                             |
| 、調査編の特徴、河川砂防技術基準計画編等の他編との関係、調査編全体の |
| 構成、更新の方針など調査編全体の概要と基本的な考え方を記載している。 |
|                                                                      |
| 第2章以降では、                                                      |
| 横断的な記載を充実させ、各章で記載されている調査により得られた成果を |
| 活用して総合的に河川等が理解できるように工夫している。例えば、第2章  |
| 水文・水理観測 第1節 総説 などがそれに当たる。                       |
|                                                                      |
| また、施策の                                                         |
| 進展を的確に反映させて内容を逐次拡充させることを方針として掲げている |
| 。例えば、平成24年改定において、激甚化する災害への対応として、第9章  |
| 水害リスク評価 、第10章                                              |
| 災害調査を設けたことは、この方針に基づくもの                         |
| である。技術的知見の蓄積も踏まえつつ、今後も内容の充実を図っていく。 |
+----------------------------------------------------------------------+

2.  []{#_Toc167445776 .anchor}河川等の調査に係る技術基準の体系化

＜考え方＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  これまで、様々な技術的な通知や手引・マニュアルが作成されているが、調査編とこれら通知等の関係を整理し、技術基準類の体系を明らかにするために、調査編に関連する細目、運用等に関する通知、手引、マニュアル等は関連通知等として記載し、調査編と関連通知等の関連が分かるようにしている。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

3.  []{#_Toc167445777 .anchor}国際貢献

＜考え方＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------
  調査編の検討に当たっては、国際的な技術基準との整合性に配慮するとともに、国際的な技術水準の向上に資するために日本の技術が国際的に活用されるよう努力することとする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------

4.  []{#_Toc167445778 .anchor}資料等の整理・活用

＜考え方＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  適切な調査を実施するためには、河川等を含む流域全体を理解し、調査を行うことが必要である。そのためには、過去の調査結果、関連する書籍・研究論文等や流域の基本的な資料を収集し、整理・活用することが重要である。過去の報告書類や関連する書籍・研究論文等に加えて、基本的な資料として流域の地質図、地形図、治水地形分類図、空中写真等のほか、過去の環境理解に役立つ迅速測図等を収集し、時間的・空間的に調査対象とする河川流域等を理解しておくことが重要である。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

5.  []{#_Toc167445779 .anchor}調査結果等の活用

＜考え方＞

+----------------------------------------------------------------------+
| 調査により得られた成果及び分析・検                                   |
| 討結果等（調査結果等）については、適切に活用されることが重要である。 |
|                                                                      |
| 特に、河川等の管理者は、調査・計画・設計・施                         |
| 工・維持管理の各段階において、調査結果等を適切に活用して、分析・判断 |
| 等を行い、課題解決や政策目標遂行のために諸施策を実施することとなる。 |
|                                                                      |
| また、河川等の管理者以外                                             |
| にも調査結果等が広く活用されるよう、適切に公開することも重要である。 |
|                                                                      |
| 河川砂防技術基準における調査                                         |
| 結果等の活用の流れを整理するため、"データ"や"情報"を"知恵"として活用 |
| する流れを体系化したData-Information-Knowledge-Wisdomモデル（以下「  |
| DIKWモデル」※という）に仮に当てはめると、図1-1-1のとおり整理される。 |
|                                                                      |
| なお、データや情報の分類には様々な定義がある。                       |
| そのうち、ここで取り上げたDIKWモデルでは、"データ"が                 |
| "知恵"へ変化するまでの流れとして、生の"データ"、意味を持つようにデー |
| タを整理した"情報"、解釈や傾向を捉えられるよう情報を普遍化・体系化し |
| た"知識"、知識から得る判断や問題解決力としての"知恵"に区分している。 |
|                                                                      |
| 本モデルの一番下の階層に位置する"データ"は通常、河川等の管理者が収   |
| 集するものである。これについては、各編各章に「必要データの明示」がさ |
| れており、「データの取得」のための調査に関する具体的手法は調査編各章 |
| 各節に記載されている。それら"データ"は各編各章に記載がある「データの |
| 整理・処理」により意味を持った"情報"となる（一つ上の階層）。調査編第 |
| 23章はこれら「データ・情報の保存」の考え方を、施設配置等計画編第5章  |
| は「情報の伝達」に必要となる情報システムの基本的考え方を示している。 |
|                                                                      |
| また、DIKWモ                                                         |
| デルにおけるもう一つ上の階層である"知識"に関しては、河川等の管理者の |
| 役割として「調査結果等の分析・評価」がある。この内容は、基本計画編第 |
| 2章や維持管理編（河川編）第4章等に記載されている。さらに、一番上の階 |
| 層である"知恵"に関しては、「整備計画・管理計画への反映」があり、これ |
| については基本計画編第1章や維持管理編（河川編）第2章等に記載がある。 |
|                                                                      |
| 以上を、例えば河川整備計画を策定する状況を想定して説明すると次の     |
| ようになる。まず、降雨量、流量、水位、洪水痕跡、潮位、標高データ等の |
| 実測に基づくデータが必要になり、この取得方法については調査編第2,4,2  |
| 2章等に記載がある。水文解析等のデータ処理については調査編第3,5,7章等 |
| に記載がある。災害の防止・軽減等のために必要な分析の観点や流域も含む |
| 対策については、基本計画編第2,5章等に記載があり、これらの分析・評価  |
| を元に整備計画を策定することについて基本計画編第1章等に記載がある。  |
|                                                                      |
| このような、河川等の管理者が全階層について一貫して役割を担うケース   |
| に対し、河川等の管理者以外が役割を持つケースもある。例えば、浸水想定 |
| 区域図は河川等の管理者が収集した"データ"を自らが整理・処理して作り公 |
| 開する"情報"である。これを"知識"として活用出来るように水害ハザードマ |
| ップを作成するのは市町村であり、この水害ハザードマップは、自治体の防 |
| 災計画の作成、実際の防災対応という"知恵"の創出に使われていると整理で |
| きる。以上は、図1-1-1の「法令に基づく水防活動等」のゾーンに当たる。  |
|                                                                      |
| さらに、その右の「公開され                                           |
| た情報の活用等」のゾーンにあるように、"データ"から"知恵"までの流れの |
| 中で、様々な担い手が携わることにより活用が広がっていく可能性がある。 |
|                                                                      |
| なお、図1-1-1の左端に上                                              |
| 向きと下向きの両方向の矢印が示されている。これは、避難を判断する際に |
| 不足していた情報がある場合には、判断（"知恵"）を補強する新たな"知識  |
| "・"情報"・"データ"が必要となってくるように、情報の流れには双方向の  |
| 流れがあり、それぞれで補完していくことが重要であることを示している。 |
|                                                                      |
| ![](media/image1.png){width="5.865741469816273in"                    |
| height="2.949717847769029in"}                                        |
|                                                                      |
| 図1                                                                  |
| -1-1　技術基準における調査結果等の活用の流れのDIKWモデルへの当てはめ |
|                                                                      |
| -   サービス・業務の遂                                               |
| 行に必要となるData（データ）、Information（情報）、Knowledge（知識） |
| 、Wisdom（知恵）の関係性を示した思考モデル。このモデルは1980年代に検 |
| 討された思考モデルであり、その後改良され多くの分野で定義されている。 |
+----------------------------------------------------------------------+

1.  []{#_Toc167445780 .anchor}河川砂防技術基準の調査編と他編の関係

＜考え方＞

+----------------------------------------------------------------------+
| 調査編と河川砂防技                                                   |
| 術基準の他編（計画編、設計編、維持管理編）の関係は、図1-2-1　のよう  |
| に示される。つまり、「河川等の計画、設計及び維持管理等の適正な実施」 |
| のために、計画編など他編を用いて検討や業務を実施し、その検討目的や業 |
| 務遂行に必要な調査手法等については、調査編が適切な手法を提示するもの |
| である。そのほか、他編を介さず、「河川等の計画、設計及び維持管理等の |
| 適正な実施」の目的のために調査編が直接的に手法を提示する場合もある。 |
|                                                                      |
| ![](media/image2.emf){width="5.9375in" height="2.28125in"}           |
|                                                                      |
| 図1-2-1　調査編と他編の関係                                          |
+----------------------------------------------------------------------+

2.  []{#_Toc167445781 .anchor}調査編の構成

    1.  []{#_Toc167445782 .anchor}全体構成

＜考え方＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  調査編は、多岐にわたる調査を対象とし、水文・水理現象に関する調査（第2章、第3章）、河道における現象に関する調査（第4章～第6章）、流域に関する調査（第7章～第9章）、災害調査（第10章）、水質・環境に関する調査（第11章～第14章）、土質地質調査（第15章）、総合的な土砂管理に関する調査（第16章）、砂防に関連する調査（第17章～20章）、海岸に関する調査（第21章）に加え、全体に係る測量・計測（第22章）、調査結果等の保存（第23章）の全23章から構成される。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

2.  []{#_Toc167445783 .anchor}横断的な内容の充実

＜考え方＞

+----------------------------------------------------------------------+
| 本調査編では、個々の調査手法の説明だ                                 |
| けでなく、調査の全体像やその中での各項目の位置付けなど、調査を実施す |
| るに当たって理解しておくべき基本的な考え方を記載するよう努めており、 |
| そのような意図で主に以下の章（あるいは節）で横断的な記載をしている。 |
|                                                                      |
| 第1章                                                                |
| 総論では、                                                           |
| 調査編の考え方や全体構成、各章の関係について分かるよう記載している。 |
|                                                                      |
| 第2章 水文・水理観測では、個々の観測手法に関する内容の他、第1節      |
| 総説に、水文・水理観測の全体                                         |
| 像や個々の観測手法の位置付けが分かるように記載している。また、第7節  |
| 河川の流れの総合的把握 、第8節                                       |
| 河川・流域の水循環の観測に、河川の流れや流域を含む水循環全体の把握な |
| ど、個々の調査結果から総合的に読み解くべき情報について整理している。 |
|                                                                      |
| 第4章 河道特性調査では、個々の調査手法に関する内容の他、第1節        |
| 総説に、河                                                           |
| 道特性調査の全体構成及び各章との関係について分かるよう記載している。 |
|                                                                      |
| 第16章                                                               |
| 総合的な土砂管理のための調査では、山間部、平                         |
| 野部、河口・海岸部までを含む土砂の動態を把握する観点、つまり総合的な |
| 土砂管理を具体化するという観点から、調査の基本的事項を記載している。 |
|                                                                      |
| 第22章 測量・計測では、個々の測量・計測に関する内容の他、第2節       |
| 河川等に関する測量に、河川等                                         |
| の調査、計画、施工、維持管理の目的に合わせた測量手法を記載している。 |
|                                                                      |
| 第23章                                                               |
| 調査結果等の保存では、調査結果等は河川等の計画、                     |
| 設計及び維持管理等のための基本的情報であるとともに、国民共有の財産で |
| あることから、適正な精度を有した調査結果等が有効に活用されるよう、適 |
| 切に保存・管理するための各編に共通する基本的な考え方を記載している。 |
+----------------------------------------------------------------------+

3.  []{#_Toc167445784 .anchor}激甚化する災害への対応

＜考え方＞

+----------------------------------------------------------------------+
| 本調査                                                               |
| 編では、水災害を激甚化・局所化させるおそれのある気候変動の影響や大規 |
| 模災害への備えなどを踏まえ、以下のように関連する章を充実させている。 |
|                                                                      |
| 第2章                                                                |
| 水文・水理観測では、降水                                             |
| 量、水位、流量など日々蓄積し様々な目的に活用される基盤的な情報の観測 |
| に加え、洪水時の的確な予警報や早期避難に役立てることを目的とした簡易 |
| 水位観測の考え方、水文・水理観測の新たな技術の記載を充実させている。 |
|                                                                      |
| 第7章                                                                |
| 氾濫解析では、中小河川のリスク                                       |
| 情報空白域解消などに向けた水害リスク情報の作成手法を充実させている。 |
|                                                                      |
| 第9章                                                                |
| 水害リスク評                                                         |
| 価では、流域における水害リスク評価の基本的な考え方を充実させている。 |
|                                                                      |
| 第10章                                                               |
| 災害調査では、災害調査に当たっての基本的な考え方や留意               |
| 点を記載し、災害から得られる技術的・社会的知見を今後の社会資本の整備 |
| や維持管理の高度化に活かすことの重要性に関する記載を充実させている。 |
|                                                                      |
| 第17章                                                               |
| 砂防調査では                                                         |
| 、深層崩壊や火山噴火など大規模土砂災害に対する調査を充実させている。 |
|                                                                      |
| 第21章 海岸調査では、津波浸水解析に関する記載を充実させている。      |
+----------------------------------------------------------------------+

4.  []{#_Toc167445785 .anchor}調査目的と各章の相互関係

＜例　示＞

+----------------------------------------------------------------------+
| 河川等の計画、設計、維                                               |
| 持管理等を適切に実施するためには、調査目的に応じて適切な調査手法を選 |
| 択する必要がある。調査の目的と各章の相互関係を表1-3-1　に例示する。  |
|                                                                      |
| 表1-3-1　調査目的と各章の相互関係                                    |
|                                                                      |
| ![](media/image3.jpeg){width="6.141732283464567in"                   |
| height="6.377950568678915in"}                                        |
|                                                                      |
| ○直接的に関連する項目　　△間接的に関連する項目                       |
+----------------------------------------------------------------------+

3.  []{#_Toc167445786 .anchor}内容の更新

＜考え方＞

+----------------------------------------------------------------------+
| 河川等に係る調査手法等については多くの関係者により、日々、技術研究開 |
| 発が行われており、技術の進展等に伴い調査編の内容を見直す必要がある。 |
|                                                                      |
| 調査編に記載されている調査方法等につい                               |
| ては、現地における適用実績等を勘案し、適宜、「必須」、「標準」、「推 |
| 奨」、「例示」といった「適用上の位置付け」を見直すことが重要である。 |
|                                                                      |
| また、新たに開発された調査手法等についても、現地にお                 |
| ける適用性等について十分検討し、その採用について判断する必要がある。 |
|                                                                      |
| 「適用上の位置付け」の見直しや、新たな調査手法等の採用に当たっ       |
| ては、国土技術政策総合研究所等による関連情報の収集・調査等によるほか |
| 、学識者や関係者等の意見を聞くことにより最新の調査手法、技術的知見、 |
| 課題等を把握する作業を定期的に行い、調査編の内容を見直すこととする。 |
|                                                                      |
| ![](media/image4.emf){width="5.885416666666667in"                    |
| height="3.2543667979002624in"}                                       |
|                                                                      |
| 図1-4-1　内容の更新                                                  |
+----------------------------------------------------------------------+

**調査編**

2.  **水文・水理観測**

**第1節　総説**

**目　次**

[第1節 総説 1](#_Toc101360901)

令和４年６月　版

適用上の位置付け

　河川砂防技術基準調査編は、基準の適用上の位置付けを明確にするために、下表に示すように適用上の位置付けを分類している。

+--------+------------------+------------------+------------------+
| 分　類 | 適用上の位置付け | 末尾の字句例     |                  |
+--------+------------------+------------------+------------------+
| 考え方 | 技術資料         | ●目              | 「･･･ある。      |
|        |                  | 的や概念、考え方 | 」「･･･いる。」  |
|        |                  | を記述した事項。 |                  |
|        |                  |                  | 「･･･なる。      |
|        |                  |                  | 」「･･･れる。」  |
+--------+------------------+------------------+------------------+
| 必　須 | 技術基準         | ●法令による規定  | 「･･･なければ    |
|        |                  | や技術的観点から | ならない。」「･  |
|        |                  | 実施すべきである | ･･ものとする。」 |
|        |                  | ことが明確であり |                  |
|        |                  | 遵守すべき事項。 |                  |
+--------+------------------+------------------+------------------+
| 標　準 | 技術基準         | ●特              | 「･･･            |
|        |                  | 段の事情がない限 | を標準とする。」 |
|        |                  | り記述に従い実施 |                  |
|        |                  | すべきだが、状況 | 「･･･            |
|        |                  | や条件によって一 | を基本とする。」 |
|        |                  | 律に適用すること |                  |
|        |                  | はできない事項。 | 「･･･による。」  |
+--------+------------------+------------------+------------------+
| 推　奨 | 技術資料         | ●状況や条件      | 「               |
|        |                  | によって実施する | ･･･望ましい。」  |
|        |                  | ことが良い事項。 |                  |
|        |                  |                  | 「               |
|        |                  |                  | ･･･推奨する。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･務める。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･必要に応    |
|        |                  |                  | じて･･･する。」  |
+--------+------------------+------------------+------------------+
| 例　示 | 技術資料         | ●適用条件や実施  | 「               |
|        |                  | 効果について確定 | ･･･などの手法（  |
|        |                  | している段階では | 事例）がある。」 |
|        |                  | ないが、状況や条 |                  |
|        |                  | 件によっては導入 | 「･･･など        |
|        |                  | することが可能な | の場合がある。」 |
|        |                  | 新技術等の例示。 |                  |
|        |                  |                  | 「･･･など        |
|        |                  | ●状              | が考えられる。」 |
|        |                  | 況や条件によって |                  |
|        |                  | 限定的に実施でき | 「               |
|        |                  | る技術等の例示。 | ･･･の場合には･･･ |
|        |                  |                  | ことができる。」 |
|        |                  | ●具体的          |                  |
|        |                  | に例示することに | 「               |
|        |                  | より、技術的な理 | ･･･例示する。」  |
|        |                  | 解を助ける事項。 |                  |
|        |                  |                  | 「例えば･･･。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･事例もある  |
|        |                  |                  | 。･･･もよい。」  |
+--------+------------------+------------------+------------------+

  関連通知等       関連する通知やそれを理解する上で参考となる資料
  ---------------- ------------------------------------------------------
  参考となる資料   例示等に示した手法・内容を理解する上で参考となる資料

2.  水文・水理観測

    1.  []{#_Toc101360901 .anchor}総説

＜考え方＞

+----------------------------------------------------------------------+
| 本章は、河川・砂防に関わる計画と管理等のためのデータ                 |
| を得ることを目的とした、降水量、水位、流量、地下水及び関連水文気象要 |
| 素等の観測と、結果の整理・分析に必要な技術的事項を定めるものである。 |
|                                                                      |
| 本章で扱う水文・水理観測については、以下の３                         |
| つのカテゴリーに分けることができる。本章各節とこれら３つのカテゴリー |
| （サブカテゴリーまで含めると４つ）との関係については、３）で述べる。 |
|                                                                      |
| > ・ カテゴリー１：基盤・汎用観測                                    |
| >                                                                    |
| > ・ カテゴリー２：特定目的観測                                      |
| >                                                                    |
| > ・ カテゴリー３：総合観測 3.1　河川の流れの総合的把握              |
| >                                                                    |
| > 3.2　河川・流域の水循環把握                                        |
|                                                                      |
| なお、調査編                                                         |
| において、このカテゴリー分けは、観測が重要な位置を占める本章と第21章 |
| 海岸調査                                                             |
| の２つの章に用いる。また、このカテゴリー分けは観測に対してのも       |
| のであり、１つの観測所において複数のカテゴリーにまたがる観測が行われ |
| る場合もあり、観測所を無理に１つのカテゴリーに当てはめる必要はない。 |
|                                                                      |
| １）３つのカテゴリーの説明                                           |
|                                                                      |
| > a） カテゴリー１：基盤・汎用観測                                   |
| >                                                                    |
| > 水文・水理量に関する基盤的な情                                     |
| 報を汎用目的に蓄積するための観測である。その特徴は次のとおりである。 |
| >                                                                    |
| > ・                                                                 |
| > 降水量、水位、流量など、個                                         |
| 々の水文・水理量を対象とし、それ自体の把握が観測の第一の目的となる。 |
| >                                                                    |
| > ・                                                                 |
| > 当該水文                                                           |
| ・水理量に対応した観測法単独で所要の精度を確保することが基本となる。 |
| >                                                                    |
| > ・ 基盤的情報として、汎用的に活用できるように蓄積される。          |
| >                                                                    |
| > ・                                                                 |
| > 代表的な活用として統計資料用のデータ蓄積があることなどから、       |
| 長期にわたる継続的な実施、手法の一貫性、全国的な網羅性が重視される。 |
| >                                                                    |
| > ・                                                                 |
| > 精度や信頼性について一定の条件を満足する均                         |
| 質な情報が蓄積されるよう、一律な精度管理がなされることが基本となる。 |
| >                                                                    |
| > ・ 観測法については信頼性・確実性・堅牢性が重視される。            |
| >                                                                    |
| > ・                                                                 |
| > 観測手法の技術的改良は、                                           |
| 慎重な検証を伴い、段階的な改善を通じて逐次行われることが基本となる。 |
| >                                                                    |
| > ・                                                                 |
| > 観測の実施方法等に関して、法律や業務規程（国土                     |
| 調査法、気象業務法、水文観測業務規程等）により定められる部分が多い。 |
| >                                                                    |
| > b） カテゴリー２：特定目的観測                                     |
| >                                                                    |
| > 特定の目的のために水文・水理量を把握する観測である。目的としては   |
| 、「ある個別の技術判断を行うこと」や「ある個別の技術情報を得ること」 |
| などがある。たとえば、水防活動等において、的確な予警報や早期避難など |
| の実施に役立てるため、特定の場所の降水量や流速、洪水位、氾濫水位など |
| を把握すること、河道内の洪水流や洪水氾濫流、浸水、津波、土石流等の痕 |
| 跡高の空間分布を測定することなどがある。その特徴は次のとおりである。 |
| >                                                                    |
| > ・                                                                 |
| > 汎用                                                               |
| 的な活用が主目的ではないことから、目的に応じて行うことが基本になる。 |
| >                                                                    |
| > ・                                                                 |
| > 個々の目的に応じて、最適な観測                                     |
| 手法を柔軟に採用し、観測の実施方法についても機動的となることがある。 |
| >                                                                    |
| > ・                                                                 |
| > 観測                                                               |
| 手法あるいは観測結果の利用方法について、先導的取組となる場合がある。 |
| >                                                                    |
| > ・                                                                 |
| > 観                                                                 |
| 測データの蓄積方法については、個々の目的に応じて適宜行うことになる。 |
| >                                                                    |
| > c） カテゴリー３：総合観測                                         |
| >                                                                    |
| > 単一箇所の一種類の水文・水理量ではな                               |
| く、一定期間、一定範囲において多点かつ複数種類の水文・水理量を対象と |
| して、水理現象等の全体状況やシステム、相互関係等を明らかにすることを |
| 目的として、総合的あるいは統合的な観点から組み立てられた観測である。 |
| >                                                                    |
| > 本                                                                 |
| 章で扱う水文・水理観測については、以下の２つのサブカテゴリーがある。 |
| >                                                                    |
| > ① カテゴリー３.１：河川の流れの総合的把握                          |
| >                                                                    |
| > 観測データと水理的考                                               |
| 察に基づく解析等を行うことにより、一定範囲の河川の流れを水理システム |
| として把握することを主たる目的とするものである。水位、流速、流量を一 |
| 括して観測対象とすることが一般的である。その特徴は次のとおりである。 |
| >                                                                    |
| > ・                                                                 |
| > 水位や流量という一種類の水文・水理量を観                           |
| 測するのではなく、対象とする流れを特徴づける複数種類の水文・水理量を |
| 複数地点で同時に観測し、更にこれを一定時間内の多時点で行い、得られた |
| 水文・水理量データの相互関係を把握できるようにすることが基本となる。 |
| >                                                                    |
| > ・                                                                 |
| > 観測対象となる水                                                   |
| 理量は、対象とする流れ及びそれを支配する水理システムから決められる。 |
| >                                                                    |
| > ・                                                                 |
| > 観測及び解析等の結果として、個々の水理量を、                       |
| カテゴリー１などにより直接観測するよりも高い頻度で求める場合がある。 |
| >                                                                    |
| > ・                                                                 |
| > カテゴリー３.１は、観測と                                          |
| 水理解析を一体的あるいは双方向的に捉えるものである。カテゴリー３.１  |
| の観測が適用される場については、多くの場合、総合的な流れの特徴の把握 |
| を必要とする課題を有する河川区間という観点から決められることになる。 |
| >                                                                    |
| > ・                                                                 |
| > 水位や流量との水理システムを介しての相互作                         |
| 用関係がない降水量は、通常、カテゴリー３.１の観測対象とはならない。  |
| >                                                                    |
| > ・                                                                 |
| > 水理システムの構成要素                                             |
| に河床変動や流砂量まで組み込み、観測をデザインするという方法もある。 |
| >                                                                    |
| > カテゴリー３.１の具体の説明は、本章の第7節 河川の流れの総合的把握  |
| > によるものとする。                                                 |
| >                                                                    |
| > ② カテゴリー３.２：河川・流域の水循環把握                          |
| >                                                                    |
| > カテゴリー３.２の観測は、降水、蒸発散、地中への浸                  |
| 透、地下水流動、流域から河川への降雨流出、河川における流れ、河川水と |
| 地下水との出入り、といった自然系の水循環を基本に、必要に応じて上水道 |
| 、工業用水道、下水道、農業用排水路等を経由して流れる人工系の水循環を |
| 組み込み、対象とする河川流域内に存在するこれらの水循環過程を総体的に |
| 把握することを主眼に行われるものである。把握対象には、必要に応じ、適 |
| 切な時間スケールでの水収支の観点も含める。カテゴリー３.１の観測と同  |
| 様に、個々の水文・水理量の観測は、水循環の状況を把握するという全体目 |
| 的の中で位置付けられ、相互の関係把握が重視される。ここで、カテゴリー |
| ３.１では対象河川区間の水理システムが観測をデザインする際の基軸にな  |
| るのに対し、カテゴリー３.２では、対象河川流域の水循環が基軸になる。  |
| >                                                                    |
| > カテゴリー３.２の具体の説明は、本章の第8節                         |
| > 河川・流域の水循環の観測 によるものとする。                        |
|                                                                      |
| ２）水文・水理観測における各カテゴリーの位置付け及び相互関係         |
|                                                                      |
| 水文・水理観測において、カテゴリー１は、国土管理全般に資する基盤     |
| 的データを整備するために、カテゴリー２は特定の目的を達成するために、 |
| カテゴリー３.１と３.２はそれぞれ対象エリアにおける水理システムあるい |
| は水循環状況を把握するために用いる。ただし、これらのカテゴリーは、図 |
| 2-1-1に示すように、互いに重複する部分を持ち、また、相互補完的な関係  |
| をなす。たとえば、カテゴリー１の観測結果が、カテゴリー２、３.１、３. |
| ２の観測に活用されることがあり、また、カテゴリー２の観測を通じて得ら |
| れた新しい観測手法がカテゴリー１の観測手法の改善に最終的に反映される |
| こともある。カテゴリー２の結果がカテゴリー３.１や３.２の観測に組み込 |
| まれることもあろう。さらに、カテゴリー３.１の観測結果がカテゴリー１  |
| のそれを補完する情報として役立てられることも考えられる。こうしたこと |
| から、水文・水理観測に当たっては、当該観測がどのカテゴリーに属するか |
| を意識し、カテゴリーの違いによる基本的な性格の差異を踏まえ、更にカテ |
| ゴリー間の相互補完関係に留意して他カテゴリーへの活用を考慮することで |
| 、当該観測の位置付けについての理解を高め、もって観測とその結果の活用 |
| がより適切かつ効率的で有効なものとなるよう工夫することが重要である。 |
|                                                                      |
| ![テキスト                                                           |
| 自                                                                   |
| 動的に生成された説明](media/image5.png){width="4.308020559930009in"  |
| height="2.315507436570429in"}                                        |
|                                                                      |
| 図2-1-1　3つのカテゴリー間の相互関係                                 |
|                                                                      |
| ３）本章各節と各カテゴリーとの関係                                   |
|                                                                      |
| 表2-1-1に、本章各節と                                                |
| 水文・水理観測の各カテゴリーとの関係を示す。なお、カテゴリー２の特定 |
| 目的観測については、個々の目的に応じて観測法が設定され、目的をあらか |
| じめ設定することができないことから、それを主に扱う節を定めていない。 |
|                                                                      |
| 表2-1-1　水文・水理観測の各カテゴリーと第２章各節との関係            |
|                                                                      |
| +-------+---------+---------+---------+---------+---------+          |
| | 節    | 節のタ  | カテゴ  | カテゴ  | カテゴ  |         |          |
| |       | イトル  | リー１  | リー２  | リー３  |         |          |
| |       |         |         |         |         |         |          |
| |       |         | 【基盤  | 【特    | 【総合  |         |          |
| |       |         | ・汎用  | 定目的  | 観測】  |         |          |
| |       |         | 観測】  | 観測】  |         |         |          |
| +=======+=========+=========+=========+=========+=========+          |
| |       |         |         |         | カ      | カ      |          |
| |       |         |         |         | テゴリ  | テゴリ  |          |
| |       |         |         |         | ー３.1  | ー３.２ |          |
| |       |         |         |         |         |         |          |
| |       |         |         |         | 【      | 【      |          |
| |       |         |         |         | 河川の  | 河川・  |          |
| |       |         |         |         | 流れの  | 流域の  |          |
| |       |         |         |         | 総合的  |         |          |
| |       |         |         |         | 把握】  | 水循環  |          |
| |       |         |         |         |         | 把握】  |          |
| +-------+---------+---------+---------+---------+---------+          |
| | 第2節 | 降水    | ◎       | ※       |         | ※       |          |
| |       | 量観測  |         |         |         |         |          |
| +-------+---------+---------+---------+---------+---------+          |
| | 第3節 | 水      | ◎       | ○、※    | ※       | ※       |          |
| |       | 位観測  |         |         |         |         |          |
| +-------+---------+---------+---------+---------+---------+          |
| | 第4節 | 流      | ◎       | ※       | ※       | ※       |          |
| |       | 量観測  |         |         |         |         |          |
| +-------+---------+---------+---------+---------+---------+          |
| | 第5節 | 水文資  | ◎       | ※       |         |         |          |
| |       | 料の整  |         |         |         |         |          |
| |       | 理・保  |         |         |         |         |          |
| |       | 存と品  |         |         |         |         |          |
| |       | 質管理  |         |         |         |         |          |
| +-------+---------+---------+---------+---------+---------+          |
| | 第6節 | 地下    | ○       | ○       |         | ○、※    |          |
| |       | 水観測  |         |         |         |         |          |
| +-------+---------+---------+---------+---------+---------+          |
| | 第7節 | 河川    | □       |         | ◎       |         |          |
| |       | の流れ  |         |         |         |         |          |
| |       | の総合  |         |         |         |         |          |
| |       | 的把握  |         |         |         |         |          |
| +-------+---------+---------+---------+---------+---------+          |
| | 第8節 | 河川・  | □       |         |         | ◎       |          |
| |       | 流域の  |         |         |         |         |          |
| |       | 水循環  |         |         |         |         |          |
| |       | の観測  |         |         |         |         |          |
| +-------+---------+---------+---------+---------+---------+          |
|                                                                      |
| > （凡例）                                                           |
| >                                                                    |
| > ◎：その節で主に扱うカテゴリー                                      |
| >                                                                    |
| > ○：その節の一部で扱うカテゴリー                                    |
| >                                                                    |
| > ※：その節に、当該カ                                                |
| テゴリーで活用できる観測手法、解析法、整理法等が含まれる場合がある。 |
| >                                                                    |
| > □：精度向上など観測充実のための補完情報となる場合がある。          |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 水文・水理観測は、そ                                                 |
| の目的等に応じ、カテゴリー１（基盤・汎用観測）、カテゴリー２（特定目 |
| 的観測）、カテゴリー３（総合観測）のカテゴリーに分けることができる。 |
|                                                                      |
| なお、カテゴリー分けは観測に                                         |
| 対してのものであり、観測所を１つのカテゴリーに当てはめる必要はない。 |
+----------------------------------------------------------------------+

**調査編**

3.  **水文・水理観測**

**第2節　降水量観測**

**目　次**

[第2節 降水量等観測 1](#_Toc101463120)

> [2．1 総説 1](#_Toc101463121)
>
> [2．2 降水量等観測の方法 3](#_Toc90152597)
>
> [2．3 自記雨量計による観測 3](#_Toc101463123)
>
> [2．3．1 地上雨量観測所の配置 3](#_Toc90152599)
>
> [2．3．2 地上雨量観測所の設置場所の選定 5](#_Toc90152600)
>
> [2．3．3 地上雨量観測所が備えるべき設備 5](#_Toc90152601)
>
> [2．3．4 観測所台帳 7](#_Toc90152602)
>
> [2．3．5 観測の実施と観測所の維持管理 7](#_Toc90152603)
>
> [2．4 レーダ雨量計による観測 8](#_Toc101463129)
>
> [2．4．1 レーダ雨量観測所の配置及び設置場所の選定 9](#_Toc90152605)
>
> [2．4．2 レーダ雨量観測所が備えるべき設備 9](#_Toc90152606)
>
> [2．4．3 観測所台帳 10](#_Toc90152607)
>
> [2．4．4 観測の実施 10](#_Toc90152608)
>
> [2．4．5 レーダ雨量観測所の維持及び管理 14](#_Toc90152609)
>
> [2．4．6 レーダ観測降雨の補完 15](#_Toc90152610)
>
> [2．5 関連気象水文要素の観測 15](#_Toc90152611)
>
> [2．5．1 関連水文要素観測所の配置及び設置場所の選定 15](#_Toc90152612)
>
> [2．5．2 関連水文要素観測所が備えるべき設備 16](#_Toc90152613)
>
> [2．5．3 関連水文要素観測の実施と観測所の維持管理 16](#_Toc90152614)

令和４年６月　版

適用上の位置付け

　河川砂防技術基準調査編は、基準の適用上の位置付けを明確にするために、下表に示すように適用上の位置付けを分類している。

+--------+------------------+------------------+------------------+
| 分　類 | 適用上の位置付け | 末尾の字句例     |                  |
+--------+------------------+------------------+------------------+
| 考え方 | 技術資料         | ●目              | 「･･･ある。      |
|        |                  | 的や概念、考え方 | 」「･･･いる。」  |
|        |                  | を記述した事項。 |                  |
|        |                  |                  | 「･･･なる。      |
|        |                  |                  | 」「･･･れる。」  |
+--------+------------------+------------------+------------------+
| 必　須 | 技術基準         | ●法令による規定  | 「･･･なければ    |
|        |                  | や技術的観点から | ならない。」「･  |
|        |                  | 実施すべきである | ･･ものとする。」 |
|        |                  | ことが明確であり |                  |
|        |                  | 遵守すべき事項。 |                  |
+--------+------------------+------------------+------------------+
| 標　準 | 技術基準         | ●特              | 「･･･            |
|        |                  | 段の事情がない限 | を標準とする。」 |
|        |                  | り記述に従い実施 |                  |
|        |                  | すべきだが、状況 | 「･･･            |
|        |                  | や条件によって一 | を基本とする。」 |
|        |                  | 律に適用すること |                  |
|        |                  | はできない事項。 | 「･･･による。」  |
+--------+------------------+------------------+------------------+
| 推　奨 | 技術資料         | ●状況や条件      | 「               |
|        |                  | によって実施する | ･･･望ましい。」  |
|        |                  | ことが良い事項。 |                  |
|        |                  |                  | 「               |
|        |                  |                  | ･･･推奨する。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･務める。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･必要に応    |
|        |                  |                  | じて･･･する。」  |
+--------+------------------+------------------+------------------+
| 例　示 | 技術資料         | ●適用条件や実施  | 「               |
|        |                  | 効果について確定 | ･･･などの手法（  |
|        |                  | している段階では | 事例）がある。」 |
|        |                  | ないが、状況や条 |                  |
|        |                  | 件によっては導入 | 「･･･など        |
|        |                  | することが可能な | の場合がある。」 |
|        |                  | 新技術等の例示。 |                  |
|        |                  |                  | 「･･･など        |
|        |                  | ●状              | が考えられる。」 |
|        |                  | 況や条件によって |                  |
|        |                  | 限定的に実施でき | 「               |
|        |                  | る技術等の例示。 | ･･･の場合には･･･ |
|        |                  |                  | ことができる。」 |
|        |                  | ●具体的          |                  |
|        |                  | に例示することに | 「               |
|        |                  | より、技術的な理 | ･･･例示する。」  |
|        |                  | 解を助ける事項。 |                  |
|        |                  |                  | 「例えば･･･。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･事例もある  |
|        |                  |                  | 。･･･もよい。」  |
+--------+------------------+------------------+------------------+

  関連通知等       関連する通知やそれを理解する上で参考となる資料
  ---------------- ------------------------------------------------------
  参考となる資料   例示等に示した手法・内容を理解する上で参考となる資料

1.  []{#_Toc101463120 .anchor}降水量等観測

    1.  []{#_Toc101463121 .anchor}総説

＜考え方＞

+----------------------------------------------------------------------+
| 本節は、降水量及び関連気                                             |
| 象水文要素の観測を実施するために必要な技術的事項を定めるものである。 |
|                                                                      |
| 降水は、大                                                           |
| 気から地面に降下する水のことである。一般に、降雨と降雪に大別される。 |
|                                                                      |
| 降水量は、ある時                                                     |
| 間内に地表の水平面（又は地表の水平投影面）に達した降水の量であり、降 |
| 水が平面上にたまったと仮定した場合の深さで表す。測定単位はmmである。 |
|                                                                      |
| 降雨強度は、ある定められた時刻間に測                                 |
| 定された降水量を１時間あたりに換算したものであり、単位はmm/hである。 |
|                                                                      |
| 降水量観測は、河川･砂防に関する計画の立                              |
| 案、工事の実施、施設の維持管理、環境の整備及び保全、洪水や渇水等によ |
| る水災害への対応等を実施するための最も基本的な調査項目の一つである。 |
|                                                                      |
| 関連気象水文要素は、降雪深、積雪量、気温                             |
| 、湿度等をいい、河川流域の水循環や水資源の調査のため観測が行われる。 |
|                                                                      |
| これらの観測により得ら                                               |
| れるデータは、近年、地球温暖化の進行に伴う気候変化による洪水や渇水等 |
| に与える影響が懸念されており、温暖化に伴う様々な影響への「適応策」を |
| 講じるためにも、長期にわたる同一品質の観測データの確保が必要である。 |
|                                                                      |
| そのため、本節で主に扱うのは、本章 第1節 総説                        |
| で                                                                   |
| 説明した３つのカテゴリーのうちのカテゴリー１である（表2-1-1参照）。  |
|                                                                      |
| また、得られた降水量観測値の照査やデータ整理・保存については、本章   |
| 第5節 水文資料の整理・保存と品質管理 によるものとする。              |
+----------------------------------------------------------------------+

＜標　準＞

  ----------------------------------------------------------------
  降水量及び関連気象水文要素の観測は、関連通知等に従い実施する。
  ----------------------------------------------------------------

＜関連通知等＞

1.  国土調査法，昭和26年6月1日，法律第180号，最終改正：令和7年6月1日法律第68号.

```{=html}
<!-- -->
```
2.  気象業務法，昭和27年6月2日，法律第165号，最終改正：令和7年6月1日法律第68号.

3.  水文観測業務規程，平成29年3月31日，国水情第44号，国土交通事務次官通達.

4.  水文観測業務規程細則，平成29年3月31日，国水情第45号，国土交通省水管理・国土保全局通達.

5.  河川砂防技術基準計画編，令和3年4月28日，国水情52号，国土交通省水管理・国土保全局.

    （最新版）河川砂防技術基準計画編，令和7年6月，国土交通省水管理・国土保全局.

6.  河川砂防技術基準維持管理編（河川編），平成27年3月3日，国水情20号，国土交通省水管理・国土保全局.

    （最新版）河川砂防技術基準維持管理編（河川編），令和3年10月，国土交通省水管理・国土保全局.

7.  地上気象観測指針，平成14年，気象庁，気象業務支援センター，第7章
    降水量及び積雪・降雪の深さの観測 7･2･3 観測条件 p.53.

＜参考となる資料＞

本節に規定していない降水量観測の詳細な要領については、下記の資料が参考となる。

1.  国土交通省監修，(独)土木研究所編著：水文観測，第2章
    降水量観測，全日本建設技術協会，2002.

    1.  []{#_Toc90152597 .anchor}降水量等観測の方法

＜標　準＞

+----------------------------------------------------------------------+
| 降水量観測は、自記雨                                                 |
| 量計（自動記録装置を備えた雨量計）を用いた地上雨量観測を標準とする。 |
|                                                                      |
| レーダ雨量計による観測は、空間的な網羅性等、面的な降水量分布を的     |
| 確に評価するために必要であり、自記雨量計による観測に加えて実施する。 |
|                                                                      |
| また                                                                 |
| 、関連気象水文要素観測は、対象観測要素に対応した計器により実施する。 |
+----------------------------------------------------------------------+

2.  []{#_Toc101463123 .anchor}自記雨量計による観測

＜考え方＞

+----------------------------------------------------------------------+
| 降水量観測は、河川･砂防に関する計画の立案、工事の実施                |
| 、施設の維持管理、環境の整備及び保全、洪水や渇水等による水災害への対 |
| 応等を実施のため重要である。また、地上雨量計観測は、面的な降水量分布 |
| の把握を補完するレーダ雨量観測の精度管理を行う観点からも重要である。 |
|                                                                      |
| そのため、適切に配置、必要な機能を備え、適切に維持管理された         |
| 自記雨量計等からなる地上雨量観測所により適切に観測を行う必要である。 |
|                                                                      |
| また、降水量観測結果が既                                             |
| 往の河川計画の基本資料として利用され、今後も継続して用いられることが |
| 想定される観測所については、優先して観測を継続することが重要である。 |
|                                                                      |
| なお、降水量観測は、気象業務法に基づき実施しなければならない。       |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  気象業務法，昭和27年6月2日，法律第165号，最終改正：令和7年6月1日法律第68号.

```{=html}
<!-- -->
```
8.  水文観測業務規程，平成29年3月31日，国水情第44号，国土交通事務次官通達，第3章
    観測.

9.  水文観測業務規程細則，平成29年3月31日，国水情第45号，国土交通省水管理・国土保全局通達，第3章
    観測の実施.

    1.  []{#_Toc90152599 .anchor}地上雨量観測所の配置

＜必　須＞

  --------------------------------------------------------------------------------------------------------------
  自記雨量計を設置する地上雨量観測所は、河川等の計画・管理上、適正な観測網となるように配置しなければならない。
  --------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 自記雨量計は、以下の基準に従い、設置することを標準とする。           |
|                                                                      |
| １)                                                                  |
| 観測対象区域をおおむね均一の                                         |
| 降水状況を示す地域に区分して、各地域に１観測所を配置するものとする。 |
|                                                                      |
| ２)                                                                  |
| ただし、おおむね均一の降水状                                         |
| 況を示す地域に区分することが困難であるときは、観測対象区域をおおむね |
| 50km^2^ごとの地域に区分して、各地域に１観測所を設置するものとする。  |
|                                                                      |
| ３)                                                                  |
| 河川構造                                                             |
| 物等の管理や急傾斜地の安全確保等のための降水量観測については、上記基 |
| 準に捉われず、必要に応じて個別に自記雨量観測所を設置することとする。 |
|                                                                      |
| ４)                                                                  |
| 気象庁による観測データ等                                             |
| 、河川計画・管理上の目的に適合した属性・品質の降水量観測データが別途 |
| 得られる場合には、それも考慮に入れた上で観測網を検討するものとする。 |
+----------------------------------------------------------------------+

＜例　示＞

+----------------------------------------------------------------------+
| 流出解析を行う観点から、その計算単位                                 |
| となる流域の平均降水量（面積雨量）を精度よく把握することが重要である |
| 。当該流域の面的な降水量分布特性をレーダや密な地上雨量計による観測等 |
| から把握し、流域平均としての降水量を精度よく把握できる観測網を設定す |
| ることが望ましい。面的降水量分布特性が把握できる資料が存在しない場合 |
| 、ある流域面積と地上雨量計設置密度に対して、把握できる面積雨量として |
| の観測精度を簡易的に推定する手法として、橋本(1977)の研究事例がある。 |
|                                                                      |
| それによると、面積雨量としての降水量観測の誤差は、次式で表される。   |
|                                                                      |
| 　　　 （2-2-1）                                                     |
|                                                                      |
| ここに，σ　：　ｎ個の観測所で得られた観測値の標準偏差                |
|                                                                      |
| 　　　　μ　：　　　　　　〃　　　　　　　　　平均値                  |
|                                                                      |
| 　　　　ｅ~s~　：　標準誤差（＝σ／√ｎ）                              |
|                                                                      |
| 　　　　Ｃ~v~　：　変動係数（＝σ／μ）                                |
|                                                                      |
| 　　　　Ｅ~s~　：　標準相対誤差                                      |
|                                                                      |
| 変動係数Ｃ~v~は、降雨特性や流域特性（大きさ、地形）によって異なる。  |
|                                                                      |
| 上式と利根川流域等における一雨連続雨量でのＣ~v~の実                  |
| 測値から、雨量観測所数と観測誤差の関係を図2-2-1に示す。この図から、  |
| 50km^2^に1台程度の雨量計の設置密度で一雨連続雨量の面積雨量誤差を10%  |
| 程度以内に抑えることができるのは、流域面積が1,000km^2^程度以上の場合 |
| であることが読み取れる。流域内の降水分布に関する知見がなく雨量計をお |
| おむね均一に配置しているなどの前提条件の下での結果であるが、支川や中 |
| 小河川の河川管理におけるレーダ雨量による補完の必要性を示唆している。 |
|                                                                      |
| ![説明:                                                              |
| 雨量観                                                               |
| 測所数と観測誤差精度](media/image7.png){width="2.4895833333333335in" |
| height="2.4895833333333335in"}                                       |
|                                                                      |
| 1.  雨量観測所数と観測誤差精度の関係                                 |
|                                                                      |
| 出典：橋本健，佐藤一郎：面積雨量                                     |
| の精度と雨量観測所数，土木技術資料，Vol.16，No.12，pp.631-637，1974. |
+----------------------------------------------------------------------+

＜参考となる資料＞

自記雨量計の設置密度と面積雨量としての精度・信頼度との関係については、下記の資料が参考となる。

2.  橋本健：標本計画法による面積雨量の精度及び信頼度の評価に関する研究，土木研究所報告，No149，1977.

    1.  []{#_Toc90152600 .anchor}地上雨量観測所の設置場所の選定

＜標　準＞

+----------------------------------------------------------------------+
| 地                                                                   |
| 上雨量観測所は、その観測所が代表することを期待される当該地点並びにそ |
| の周辺領域の降水量を適正に計測できる場所に設置することを基本とする。 |
|                                                                      |
| 原則として、以下の事項に掲げる条件に適合することを基本とする。       |
|                                                                      |
| １)                                                                  |
| 地形の狭窄や急                                                       |
| 変等により気流や降水が特殊な値を示すようなことがない地点であること。 |
|                                                                      |
| ２)                                                                  |
| おおむね10ｍ四方                                                     |
| 以上の広さの開放された土地であって、局所的な気流の変化が少ないこと。 |
|                                                                      |
| ３) 豪雨時に浸水や崖崩れのおそれがないこと。                         |
|                                                                      |
| ４) 観測や巡回点検に便利であること。                                 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  地上気象観測指針，平成14年，気象庁，気象業務支援センター，第7章
    降水量及び積雪・降雪の深さの観測 7･2･3 観測条件 p.53.

＜参考となる資料＞

本項に規定していない詳細な要領については、下記の資料が参考となる。

1.  国土交通省監修，(独)土木研究所編著：水文観測，第2章 降水量観測 2･2･2
    観測所の位置選定，全日本建設技術協会，2002.

    1.  []{#_Toc90152601 .anchor}地上雨量観測所が備えるべき設備

```{=html}
<!-- -->
```
1.  自記雨量計

＜必　須＞

+----------------------------------------------------------------------+
| 降水量観測用の自記雨量計は、                                         |
| 求められる時間の降水量を的確に無人・自動で観測でき、「気象業務法」及 |
| びこれに基づく「気象測器検定規則」に適合したものでなければならない。 |
|                                                                      |
| また、雨量計は、以下の事項に対応しなければならない。                 |
|                                                                      |
| １)                                                                  |
| 雨量計の受水口は水平に設置するとともに                               |
| 、風の影響が著しいと思われる観測所では、受水口に風よけを付けること。 |
|                                                                      |
| ２)                                                                  |
| 凍結が生じるおそれのある地点では、凍結防止機能の付                   |
| いた雨量計（たとえば、温水式雨量計、ヒータ付雨量計等）を用いること。 |
|                                                                      |
| ３)                                                                  |
| 降                                                                   |
| 雪による降水量を観測する観測所では、温水式雨量計若しくは溢水式雨量計 |
| を用いるとともに、常に積雪面上に受水口が出ているように設置すること。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 雨量計の受水口の直径は20cmを標準とする。                             |
|                                                                      |
| 設置地点の制約により観測局                                           |
| 舎の屋上等に雨量計を設置する場合には、たとえば屋上の中央部に雨量計を |
| 設置するなど、局所的な気流の影響を受けないように配慮するものとする。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  地上気象観測指針，平成14年，気象庁，気象業務支援センター，第7章
    降水量及び積雪・降雪の深さの観測 7･3 転倒ます型雨量計による観測
    pp.53-55.

＜参考となる資料＞

雨量計の詳細については、下記の資料が参考となる。

1.  国土交通省監修，(独)土木研究所編著：水文観測，第2章 降水量観測 2･3
    雨量観測器械，全日本建設技術協会，2002.

```{=html}
<!-- -->
```
2.  **自動記録装置**

＜標　準＞

+----------------------------------------------------------------------+
| 地上雨量観測所に                                                     |
| は、自記紙やデータロガー等の自記記録装置を設置することを標準とする。 |
|                                                                      |
| 自動記録装置は、無人・自動での確実な観測データ                       |
| 記録と定期的なデータ収集に支障のないように設置することを標準とする。 |
+----------------------------------------------------------------------+

3.  自動データ伝送装置

＜必　須＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------
  河川管理・施設管理上、リアルタイム観測が必要な自動雨量観測所は、求められる時間の降水量を的確に伝送できる自動データ伝送装置（テレメータ等）を備えなければならない。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 自動                                                                 |
| データ伝送装置は、10分以下の観測間隔の機能を有するものを標準とする。 |
|                                                                      |
| 自動データ伝送装置は、「電気通                                       |
| 信施設設計要領（案）（通信編）」に基づき設計されたものを標準とする。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  電気通信施設設計要領（通信編），令和4年3月30日，国技電第90号，国土交通省大臣官房技術調査課電気通信室長通知.

```{=html}
<!-- -->
```
4.  標識

＜必　須＞

+----------------------------------------------------------------------+
| 地上雨量観測所には標識を設置しなければならない。                     |
|                                                                      |
| 標識には、観測所名、水系・河川名、設置者名、設置年月日、             |
| 観測所所在地、緯度・経度（世界測地系）、標高、観測所記号を記載する。 |
+----------------------------------------------------------------------+

5.  観測小屋

＜必　須＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  地上雨量観測所には、観測小屋、柵を設置することとし、観測小屋は雨量計による観測の障害物とならないように設置しなければならない。ただし、設備の特性や設置条件等により、不要と判断できる場合は設置しなくてもよい。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------
  観測小屋は、地震等の自然災害時や停電時における機能確保を考慮して設計し、非常用発電設備など必要な設備を設置することを標準とする。
  ----------------------------------------------------------------------------------------------------------------------------------

1.  []{#_Toc90152602 .anchor}観測所台帳

＜必　須＞

+----------------------------------------------------------------------+
| 地上雨量観測所                                                       |
| を設置した場合には、雨量観測所台帳及び付図を作成しなければならない。 |
|                                                                      |
| 台帳には、雨量観測所の位置や施設構造等に関する諸元を                 |
| 記載する。雨量計等の移設や交換等の変更が生じた場合には、気象業務法上 |
| の届け出とともに、台帳への記載加筆を速やかに実施しなければならない。 |
|                                                                      |
| 様式については「水文観測業務規程細則」に従わなければならない。       |
|                                                                      |
| 地上雨量観測所には、雨量観測所台帳及び付図の写しを備え付けなけれ     |
| ばならない。ただし、観測小屋を設置していない場合はその限りではない。 |
|                                                                      |
| 雨量観測所を新設・変更・廃止する場合は、気象業務法上の届け出を行う。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  水文観測業務規程，平成29年3月31日，国水情第44号，国土交通事務次官通達，第2章
    観測所の配置及び設置.

```{=html}
<!-- -->
```
10. 水文観測業務規程細則，平成29年3月31日，国水情第45号，国土交通省水管理・国土保全局通達，第2章
    観測所.

＜参考となる資料＞

標識・観測小屋・観測所台帳の詳細については、下記の資料が参考となる。

1.  国土交通省監修，(独)土木研究所編著：水文観測，第2章 降水量観測 2・4
    観測施設，全日本建設技術協会，2002.

＜標　準＞

  ----------------------------------------------------------------------------------------------------
  観測所台帳及び付図は電子的に保管、編集が可能なものとし、電子的方法により管理することを標準とする。
  ----------------------------------------------------------------------------------------------------

1.  []{#_Toc90152603 .anchor}観測の実施と観測所の維持管理

```{=html}
<!-- -->
```
1.  観測の実施

＜必　須＞

  ----------------------------------------------------------------------------------------------------------------
  降水量の観測の実施に当たっては、「水文観測業務規程」及び「水文観測業務規程細則」の定めに従わなければならない。
  ----------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1.  水文観測業務規程，平成29年3月31日，国水情第44号，国土交通事務次官通達，第2章
    観測所の配置及び設置.

```{=html}
<!-- -->
```
11. 水文観測業務規程細則，平成29年3月31日，国水情第45号，国土交通省水管理・国土保全局通達，第2章
    観測所.

＜参考となる資料＞

本項に規定していない観測の実施の詳細については、下記の資料が参考となる。

1.  国土交通省監修，(独)土木研究所編著：水文観測，第2章 降水量観測 2･5
    観測，全日本建設技術協会，2002.

```{=html}
<!-- -->
```
6.  地上雨量観測所の維持及び管理

＜必　須＞

+----------------------------------------------------------------------+
| 地上                                                                 |
| 雨量観測所の維持及び管理の実施に際しては、「水文観測業務規程」第8章  |
| 観測所の維持及び管理、「水文観測業務規程細則」第8章                  |
| 観測所の維持管理等                                                   |
| の定めに従わなければならない。自動データ伝送装置は、                 |
| 「電気通信施設点検基準（案）」に基づき点検を実施しなければならない。 |
|                                                                      |
| また、観測所ご                                                       |
| とに維持管理上必要な事項を記入した点検記録簿を備えなければならない。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 観測所                                                               |
| の点検は、観測所の維持管理において最も重要である。点検については、以 |
| 下に示す総合点検及び定期点検を組み合わせて実施することを基本とする。 |
|                                                                      |
| １)                                                                  |
| 総合点検は、年１回以上（出水期前等。必要に応じ                       |
| て回数を増やす。）とし、対象とする施設・設備において特に器械類の内部 |
| に対して詳細点検を実施し、擬似テスト等による点検を含めた総合的な保守 |
| 及び校正を行う。この点検は、測定部（受水部）、記録部、器械類の故障の |
| 有無を確認し、観測データの精度向上を図ることを主たる目的としている。 |
|                                                                      |
| ２)                                                                  |
| 定期点検は、月１回以上（総合点検を除いた月）とし、対象とする施設・   |
| 設備において特に器械類の外部に対して目視による点検を中心に行う。この |
| 点検は、測定部（受水部）、記録部、器械類の機能障害等の異常を早期に発 |
| 見し、観測データの欠測や異常値を生じさせないことを主たる目的とする。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  水文観測業務規程，平成29年3月31日，国水情第44号，国土交通事務次官通達，第8章
    観測所の維持及び管理.

```{=html}
<!-- -->
```
12. 水文観測業務規程細則，平成29年3月31日，国水情第45号，国土交通省水管理・国土保全局通達，第8章
    観測所の維持管理等.

13. 電気通信施設点検基準（案）の一部改定について，平成21年12月18日，国技電第26号，国土交通省大臣官房技術調査課長通知.\
    （最新版）電気通信施設点検基準（案）（令和７年３月）

    　・電気通信施設点検基準（案）【総合点検】

    　・電気通信施設点検基準（案）【個別点検】

    　・電気通信施設点検基準（案）【巡回点検】

    　・【新旧表】電気通信施設点検基準（案）【総合点検】

    　・【新旧表】電気通信施設点検基準（案）【個別点検】

＜参考となる資料＞

本項に規定していない観測所の維持管理の詳細については、下記の資料が参考となる。

1.  国土交通省監修，(独)土木研究所編著：水文観測，第2章 降水量観測 2・6
    観測所の維持管理，全日本建設技術協会，2002.

    1.  []{#_Toc101463129 .anchor}レーダ雨量計による観測

＜考え方＞

+----------------------------------------------------------------------+
| レーダ雨量計は、                                                     |
| 即時性や空間的な網羅性等、降水量の時空間的な把握が容易であるなどの特 |
| 長を有しており、面的な降水量分布や面積雨量を把握するのに重要である。 |
|                                                                      |
| そのため、適切に配置、必要な機能を備え                               |
| 、適切に維持管理されたレーダ雨量計により適切に観測を行う必要である。 |
|                                                                      |
| ただし、レーダ雨量計は、数百mから数km程度上空にある雨滴を計測対      |
| 象としており、地上雨量計と観測対象が異なることに留意する必要がある。 |
+----------------------------------------------------------------------+

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------
  レーダ雨量観測は、適切に配置、必要な機能を備え、適切に維持管理されたレーダ雨量計システムにより適切に観測を行う。
  ------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1.  水文観測業務規程，平成29年3月31日，国水情第44号，国土交通事務次官通達.

```{=html}
<!-- -->
```
14. 水文観測業務規程細則，平成29年3月31日，国水情第45号，国土交通省水管理・国土保全局通達.

＜参考となる資料＞

レーダ雨量計による降水量観測の特徴と、地上雨量計観測値との関係・差異に関する議論については、下記の資料が参考となる。

1.  深見和彦：レーダ雨量計利活用の前提となる観測精度の実態と今後の研究課題，河川，No716，pp.40-46，2006.

    1.  []{#_Toc90152605
        .anchor}レーダ雨量観測所の配置及び設置場所の選定

＜標　準＞

+----------------------------------------------------------------------+
| Ｃバンド（ＭＰ）レーダ雨量計                                         |
| においては、半径120km、ＸバンドＭＰレーダ雨量計については、半径60km  |
| を目安に定量観測範囲として設定する。                                 |
|                                                                      |
| レーダ雨量計の特長を考慮し、対象地域の降水量を精度よく把握す         |
| ることが可能となるように、Ｃバンド（ＭＰ）レーダ雨量計により全国を監 |
| 視し、特に高度な監視が必要な場合にＸバンドＭＰレーダ雨量計により当該 |
| 範囲を監視できるよう、適切にレーダ雨量計を配置することを標準とする。 |
|                                                                      |
| レーダ雨量計                                                         |
| は電波を活用した計測器械であるため、以下の事項を考慮する必要がある。 |
|                                                                      |
| １) 既設の他の無線局との電波干渉を可能な限り避けるように配置する。   |
|                                                                      |
| ２)                                                                  |
| レーダの観測距離、レーダビームの減衰や遮蔽並びに観測高度、グランド   |
| クラッタ等（大地や海面等からの不要反射）を総合的に考慮して配置する。 |
|                                                                      |
| ３)                                                                  |
| Ｘ                                                                   |
| バンドＭＰレーダ雨量計については、降雨による電波の減衰（降雨減衰）が |
| 大きいため、対象地域を複数のレーダによりカバーすることにも留意する。 |
+----------------------------------------------------------------------+

2.  []{#_Toc90152606 .anchor}レーダ雨量観測所が備えるべき設備

```{=html}
<!-- -->
```
1.  総説

＜必　須＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  レーダ雨量計のシステム一式は、空中線装置、空中線制御装置、マイクロ波送受信装置、信号・データ処理・表示装置、データ記録装置、付属装置（レドーム、導波管、避雷器、電源等）から成る。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1.  電気通信施設設計要領（情報通信システム編），令和3年3月30日，国技電第89号，国土交通省大臣官房技術調査課電気通信室長通知.

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  レーダ雨量観測所を設置する場合、周辺の無線局に与える電波干渉を防止する対策、並びに、ほかの無線局からの混入電波による観測精度低下を防止する被干渉対策を行うことを標準とする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

7.  標識

＜必　須＞

+----------------------------------------------------------------------+
| レーダ雨量観測所には、標識を設置しなければならない。                 |
|                                                                      |
| 標識には、観測所名、設置者名、設置年月日、観測所所在                 |
| 地、緯度・経度（世界測地系）、レーダ設置標高、観測所記号を記載する。 |
+----------------------------------------------------------------------+

8.  付帯施設

＜必　須＞

  --------------------------------------------------------------------
  レーダ雨量観測所には、安全施設として柵等を設置しなければならない。
  --------------------------------------------------------------------

1.  []{#_Toc90152607 .anchor}観測所台帳

＜必　須＞

+----------------------------------------------------------------------+
| レーダ雨量観測所を設置                                               |
| した場合には、レーダ雨量観測所台帳及び付図を作成しなければならない。 |
|                                                                      |
| レーダ雨量観測所台帳には、雨量観測                                   |
| 所の位置や施設構造等に関する諸元を記載する。雨量計等の移設や交換等の |
| 変更が生じた場合には、台帳への記載を速やかに実施しなければならない。 |
|                                                                      |
| 様式については「水文観測業務規程細則」に従わなければならない。       |
|                                                                      |
| レーダ雨量観測所                                                     |
| には、レーダ雨量観測所台帳及び付図の写しを備え付けなければならない。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  水文観測業務規程，平成29年3月31日，国水情第44号，国土交通事務次官通達，第2章
    観測所の配置及び設置.

```{=html}
<!-- -->
```
15. 水文観測業務規程細則，平成29年3月31日，国水情第45号，国土交通省水管理・国土保全局通達，第2章
    観測所.

＜標　準＞

  ----------------------------------------------------------------------------------------------------
  観測所台帳及び付図は電子的に保管、編集が可能なものとし、電子的方法により管理することを標準とする。
  ----------------------------------------------------------------------------------------------------

1.  []{#_Toc90152608 .anchor}観測の実施

```{=html}
<!-- -->
```
1.  レーダ雨量計の分類

＜考え方＞

+----------------------------------------------------------------------+
| レ                                                                   |
| ーダ雨量計は、以下に示すような幾つかの観点から分類されることが多い。 |
|                                                                      |
| １)用いる電波（マイクロ波）の周波数                                  |
|                                                                      |
| 我が国では、Ｃバンド（5GHz帯）若しくはＸバンド（10GHz                |
| 帯）が一般に用いられる。Ｃバンドは、波長が長く降雨減衰の影響が比較的 |
| 少ないため、広域観測に適している。一方、Ｘバンドは、波長が短く降雨減 |
| 衰の影響が大きいため広域観測には適さないが、降水量観測の感度が高く、 |
| 空中線等のサイズが小さくシステム全体を小型化できるなどの利点がある。 |
|                                                                      |
| ２)単一の偏波または複数の偏波による測定                              |
|                                                                      |
| 我が国では、水平若しく                                               |
| は垂直偏波のみの送信・受信を行う単偏波レーダ、複数の偏波（水平及び垂 |
| 直偏波）での送信・受信を行う二重偏波レーダが用いられている。単偏波レ |
| ーダでは、通常、偏波面に対して雨滴の後方散乱断面積が大きくなる水平偏 |
| 波が採用される。二重偏波レーダは、それぞれの偏波からのパラメータに加 |
| え、偏波間の関係性に関するパラメータを測定可能であり、多数の計測パラ |
| メータが得られることからＭＰ（マルチパラメータ）レーダと呼ばれる。19 |
| 90年代前半までは、全てのＣバンドレーダ雨量計は単偏波レーダであったが |
| 、現在、Ｃバンドレーダ雨量計の二重偏波レーダへ更新が進められている。 |
|                                                                      |
| ３)測定可能なパラメータ                                              |
|                                                                      |
| a）強度を測定する機能                                                |
|                                                                      |
| > 全てのレーダ雨量計は、雨滴の後方散乱に                             |
| よる受信電力値を計測する機能を有する。単偏波レーダでは水平若しくは垂 |
| 直偏波のみの受信電力値を計測する。二重偏波レーダでは、水平及び垂直の |
| それぞれの偏波に対する受信電力値を計測する。受信電力値からレーダ方程 |
| 式によりレーダ反射因子を求め、Z-R関係式により降水強度が算出される。  |
| >                                                                    |
| > b） 位相を測定する機能                                             |
| >                                                                    |
| > ①　ドップラー速度を測定する機能                                    |
| >                                                                    |
| > ドップラー速度を測定する機能とは、風に流され                       |
| る雨滴からの反射波の周波数がドップラー効果により変化することから、送 |
| 信電波と受信電波の位相差を計測し雨滴のビーム方向における移動速度成分 |
| （ドップラー速度）を測定する機能である。ドップラー速度を測定する機能 |
| を有するレーダは、ドップラーレーダと呼ばれる。一部のＣバンドレーダ雨 |
| 量計、全てのＸバンドＭＰレーダ雨量計はドップラー速度を測定する機能を |
| 有している。ドップラー速度は、大気の流れ（風）の１成分を表現している |
| とも考えられ、これまでに様々な大気の流れの解析手法が開発されている。 |
| >                                                                    |
| > ② 偏波間位相差を測定する機能                                       |
| >                                                                    |
| > 偏波間位相差を測定する機能とは、落下に伴う空気抵抗により扁平し     |
| た雨滴群の中を電波が伝搬する際に、水平、垂直偏波で伝搬経路に差がある |
| ために生じる位相差（偏波間位相差）を測定する機能である。偏波間位相差 |
| のビーム方向における距離微分は偏波間位相差変化率と呼ばれ、実際の降雨 |
| 強度と変換式を介して良い対応を示す。一部のＣバンドレーダ雨量計、全て |
| のＸバンドＭＰレーダ雨量計は偏波間位相差を測定する機能を有している。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

レーダ雨量計による降水量観測の原理や用語の詳細及び国内外における最新の技術開発研究の動向については、下記の資料が参考となる。

1.  中北英一：レーダーによる降雨観測と予測の最新動向について，河川，No762，pp.20-27，2010.

```{=html}
<!-- -->
```
16. 吉野文雄著：レーダ水文学，p.175，森北出版，2002.

17. 深尾昌一郎，浜津亨助著：気象と大気のレーダーリモートセンシング，p.491，京都大学学術出版会，2005.

> ドップラーレーダによる大気の流れの解析法に関しては、下記の資料が参考となる。

18. 石原正仁編：ドップラー気象レーダ，日本気象学会　気象研究ノート，第200号，2001.

```{=html}
<!-- -->
```
9.  観測・運用モードの設定

＜必　須＞

+----------------------------------------------------------------------+
| 観測・運用に当たっては、以下の事項を考                               |
| 慮して、仰角、仰角変更、アンテナ回転速度等を設定しなければならない。 |
|                                                                      |
| > １)                                                                |
| > 降水量                                                             |
| 観測の時間分解能を考慮した仰角変更、アンテナ回転速度を設定すること。 |
| >                                                                    |
| > ２) 広い観測範囲を確保した仰角を設定すること。                     |
| >                                                                    |
| > ３) 山岳等による遮蔽率が小さくなるように仰角を設定すること。       |
| >                                                                    |
| > ４)                                                                |
| > 大地や海面                                                         |
| 等からの不要反射（グランドクラッタ等）を抑制した仰角を設定すること。 |
| >                                                                    |
| > ５) 低い観測高度となる仰角を設定すること。                         |
| >                                                                    |
| > ６)                                                                |
| > 複数                                                               |
| のレーダ雨量計の情報を合成する際の降水強度の不連続性を抑制すること。 |
+----------------------------------------------------------------------+

＜推　奨＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  上記の条件を満たすために、必要に応じて複数の仰角による観測を行う。一般に低い仰角による観測は精度が高い一方、山岳等による遮蔽により観測範囲が狭くなるというトレードオフの関係にあり、上述の条件を同時に満たすことが困難な場合、必要に応じて複数の仰角による観測を行い、観測値の平均等による降水強度の算出、遮蔽領域の補間をすることが望ましい。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜参考となる資料＞

レーダ雨量計による降水量観測の原理や用語の詳細及び国内外における最新の技術開発研究の動向については、下記の資料が参考となる。

1.  中北英一：レーダーによる降雨観測と予測の最新動向について，河川，No762，pp.20-27，2010.

```{=html}
<!-- -->
```
19. 吉野文雄著：レーダ水文学，p.175，森北出版，2002.

20. 深尾昌一郎，浜津亨助著：気象と大気のレーダーリモートセンシング，p.491，京都大学学術出版会，2005.

```{=html}
<!-- -->
```
10. **レーダ雨量の算出**

＜必　須＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  レーダ雨量計から得られる情報を降水強度に変換する方法については、レーダ雨量計の種類によって幾つかの方法が存在する。いずれの方法を採用する場合も、その方法で必要とされる諸定数については、地上降水量観測値との比較分析をとおして、観測対象としている降水現象の平均的な特性を代表できるように適切に設定しなければならない。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| Ｃバンドレーダ雨量計の場合は、受信電力値からレーダ方程式によ         |
| り求められる反射因子Zと降水強度Rとの関係（Z-R関係）を経験的なべき乗  |
| 式で関係づけるBβ法により、降水強度の初期算出を行うことを標準とする。 |
|                                                                      |
| Z-R関係式の定数B、βは、Z-R関係両対数図において、あ                   |
| るZ値レベル（層）ごとにR平均値を算出した上で、そのプロット群を最適に |
| 表現する直線式の傾きから求める層別平均値法を用いることを標準とする。 |
|                                                                      |
| ＸバンドMPレー                                                       |
| ダ雨量計の場合は、Z-R関係に加え、偏波間位相差変化率（K~dp~）と降水強 |
| 度の関係（K~dp~-R関係）により降水強度の算出を行うことを標準とする。  |
+----------------------------------------------------------------------+

＜参考となる資料＞

レーダ雨量計による降水量観測の原理や用語の詳細及び国内外における最新の技術開発研究の動向については、下記の資料が参考となる。

1.  中北英一：レーダーによる降雨観測と予測の最新動向について，河川，No762，pp.20-27，2010.

```{=html}
<!-- -->
```
21. 吉野文雄著：レーダ水文学，p.175，森北出版，2002.

22. 深尾昌一郎，浜津亨助著：気象と大気のレーダーリモートセンシング，p.491，京都大学学術出版会，2005.

```{=html}
<!-- -->
```
11. 合成雨量の作成

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------
  降水の状況を的確に把握できる降水情報を提供するために、複数のレーダ雨量から合成雨量を作成することを標準とする。
  ----------------------------------------------------------------------------------------------------------------

＜例　示＞

  -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  合成雨量の作成方法として、全国合成テーブルに基づく方法、重み付き平均による方法がある。Ｃバンドレーダ雨量計では個々のレーダ雨量を均質化補正した後に、全国合成テーブルに基づく方法により1kmメッシュの直交格子の合成雨量が作成される。ＸバンドＭＰレーダ雨量計では、内挿距離、観測高度、レーダからの距離、レーダ雨量の算出方法を考慮した重み付き平均による方法により250mメッシュの直交格子の合成雨量が作成される。
  -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

12. 観測精度の確保

＜標　準＞

+----------------------------------------------------------------------+
| レ                                                                   |
| ーダ雨量計から得られる情報を降水強度に変換する方法に必要とされる諸定 |
| 数の妥当性については、原則として年１回は再確認し、必要に応じて見直し |
| を行うことを標準とする。レーダ雨量計の更新を行った場合も同様である。 |
|                                                                      |
| また、レーダ雨                                                       |
| 量計周辺への高層ビル、風力発電設備等の構築物の設置など周辺状況の変化 |
| について、構造物の設置計画段階等から影響に留意することが重要である。 |
+----------------------------------------------------------------------+

＜推　奨＞

+----------------------------------------------------------------------+
| Z-R関係式は、降水粒子の形態の粒径分布等の変動等によって              |
| 定数B、βが変動し、降水量観測の誤差要因となるため、Z-R関係式のみで降  |
| 水強度を算出する場合は、それを抑制するために自動データ転送装置（テレ |
| メータ）による地上雨量計データを用いた補正処理を行うことが望ましい。 |
|                                                                      |
| その場                                                               |
| 合、レーダ雨量計が直接の計測対象としている空間の平均降水量を評価する |
| 観点からは、レーダ雨量計観測値だけでなく、地上雨量計観測値にも面積雨 |
| 量評価値として不確かさが含まれていること（2.3.1地上雨量観測所の配置  |
| の＜例示＞を参照）を踏まえた上で、複数                               |
| の地上雨量計データに適切な重みを加えた補正処理を行うことが望ましい。 |
+----------------------------------------------------------------------+

＜例　示＞

+----------------------------------------------------------------------+
| 地上雨量計データを用いたレーダ雨量の補正処理においては、速報性を     |
| 重視し、それぞれのレーダ雨量の観測時刻において得られる最新の地上雨量 |
| 計データを用いて補正するオンライン補正と、精度を重視し、レーダ雨量の |
| 観測時刻と同時刻の地上雨量計データを用いて補正する同時刻補正がある。 |
|                                                                      |
| Ｃバンドレー                                                         |
| ダ雨量計では、補正処理手法としてダイナミックウィンドウ法を用い、オン |
| ライン補正を配信データに、同時刻補正を保存用のデータに適用している。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

レーダ雨量計による降水量観測の原理や用語の詳細及び国内外における最新の技術開発研究の動向については、下記の資料が参考となる。

1.  中北英一：レーダーによる降雨観測と予測の最新動向について，河川，No762，pp.20-27，2010.

```{=html}
<!-- -->
```
23. 吉野文雄著：レーダ水文学，p.175，森北出版，2002.

24. 深尾昌一郎，浜津亨助著：気象と大気のレーダーリモートセンシング，p.491，京都大学学術出版会，2005.

ダイナミックウィンドウ法の詳細については、下記の資料が参考となる。

25. 河川情報センター：レーダ雨量補正・配信システム，特開2002-350560，2002-12-4.

26. （風力発電施設が気象観測レーダーに及ぼす影響

> https://www.jma.go.jp/jma/kishou/know/radar/windturbine.html\#consid）

5.  []{#_Toc90152609 .anchor}レーダ雨量観測所の維持及び管理

＜必　須＞

+----------------------------------------------------------------------+
| レーダ                                                               |
| 雨量観測所の維持及び管理の実施に際しては、「水文観測業務規程」第8章  |
| 観測所の維持及び管理、「水文観測業務規程細則」第8章                  |
| 観測所の維持管理等、電気通信施設点検基準（案）                       |
| の定めに従わなければならない。                                       |
|                                                                      |
| また、観測所ごとに点                                                 |
| 検や維持管理上必要な事項を記入した点検記録簿を備えなければならない。 |
|                                                                      |
| また、レーダ雨量計システム                                           |
| を構成するレーダ雨量観測所、解析処理装置等の構成要素ごとに点検を実施 |
| し、維持管理上必要な事項を記入した点検記録簿を備えなければならない。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  水文観測業務規程，平成29年3月31日，国水情第44号，国土交通事務次官通達，第8章
    観測所の維持及び管理.

```{=html}
<!-- -->
```
27. 水文観測業務規程細則，平成29年3月31日，国水情第45号，国土交通省水管理・国土保全局通達，第8章
    観測所の維持管理等.

28. 電気通信施設点検基準（案）の一部改定について，平成21年12月18日，国技電第26号，国土交通省大臣官房技術調査課長通知.\
    （最新版）電気通信施設点検基準（案）（令和７年３月）

    　　・電気通信施設点検基準（案）【総合点検】

    　　・電気通信施設点検基準（案）【個別点検】

    　　・電気通信施設点検基準（案）【巡回点検】

    　　・【新旧表】電気通信施設点検基準（案）【総合点検】

    　　・【新旧表】電気通信施設点検基準（案）【個別点検】

    1.  []{#_Toc90152610 .anchor}レーダ観測降雨の補完

＜考え方＞

  ----------------------------------------------------------------------------------------------------------------------------------
  レーダ雨量計により観測が不足する地域においては、気象レーダや衛星による降雨観測なども活用して、データを補完することが考えられる。
  ----------------------------------------------------------------------------------------------------------------------------------

＜例　示＞

  -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  降雨観測網から外れた離島や海上の降雨量が必要となる場合、主に地上雨量計の観測網が不十分な発展途上国等での利用向けに研究開発されている人工衛星に搭載されたレーダやマイクロ波放射計の観測に基づく衛星雨量データを利用することで、部分的補完が可能な場合がある。衛星雨量は、一般に複数の衛星により観測されたデータを一定時間ごとに集計した複合プロダクトとして提供されている。たとえば、JAXA（宇宙航空研究開発機構）のGSMaPやNASA（米国航空宇宙局）の3B42RTがある。自記雨量計による地上雨量データと異なる特性を十分理解した上で用いる必要がある。
  -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜参考となる資料＞

衛星雨量の特徴と利用に当たっての課題の詳細については、下記の資料が参考となる。

1.  深見和彦，小澤剛，猪俣広典：日本の河川情報技術による国際貢献　衛星観測雨量を用いた洪水予測技術の現状と課題，河川，pp.63-68，2010.

    1.  []{#_Toc90152611 .anchor}関連気象水文要素の観測

＜考え方＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  降水量観測所においては，降水量とともに，その他の水文気象要素を観測することがある。この場合には観測要素毎に観測方法や観測器械が異なるので，観測要素に対応した施設を設置して観測する。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 降水量・水位や流量のほか、以下に挙げるような関連する                 |
| 気象水文要素について、必要に応じて選択して観測することを標準とする。 |
|                                                                      |
| > １) 降雪深、積雪量                                                 |
| >                                                                    |
| > ２) 降水のπΗ、溶存成分等                                           |
| >                                                                    |
| > ３) 蒸発量、蒸発散量                                               |
| >                                                                    |
| > ４) 気温、湿度                                                     |
| >                                                                    |
| > ５) 風向・風速                                                     |
| >                                                                    |
| > ６) 日射量                                                         |
| >                                                                    |
| > ７) 気圧                                                           |
+----------------------------------------------------------------------+

1.  []{#_Toc90152612 .anchor}関連水文要素観測所の配置及び設置場所の選定

＜考え方＞

  ------------------------------------------------------------------------------------------------------------------
  関連水文要素観測の観測所の配置及び設置場所の選定は、気象官署観測業務規程や地上気象観測指針等を参照して検討する。
  ------------------------------------------------------------------------------------------------------------------

2.  []{#_Toc90152613 .anchor}関連水文要素観測所が備えるべき設備

＜標　準＞

+----------------------------------------------------------------------+
| 関連気                                                               |
| 象水文要素の観測を行う場合においても、無人での連続的な観測を可能とす |
| るために、自動記録装置（データロガー等）を併置することを標準とする。 |
|                                                                      |
| 観測器械や自動記                                                     |
| 録装置等の収納や標識の設置、観測所台帳・点検記録簿等については、本節 |
| 2.3.3 (5) 観測小屋 及び2.3.4 観測所台帳                              |
| と同様に行うことを標準とする。                                       |
|                                                                      |
| また、点検及び維持管理については、本節 2.3.5(2)                      |
| 地上雨量観測所の維持及び管理 と同様に行うことを標準とする。          |
+----------------------------------------------------------------------+

1.  自動データ伝送装置

＜必　須＞

  ----------------------------------------------------------------------------------------------------------------------------------------------
  河川管理・施設管理上、リアルタイム観測が必要な観測所は、必要な観測結果を伝送できる自動データ伝送装置（テレメータ等）を備えなければならない。
  ----------------------------------------------------------------------------------------------------------------------------------------------

1.  []{#_Toc90152614 .anchor}関連水文要素観測の実施と観測所の維持管理

＜必　須＞

  --------------------------------------------------------------------------------------------------------------------------------------
  関連水文要素の観測の実施に当たっては、「気象業務法」、「水文観測業務規程」及び「水文観測業務規程細則」の定めに従わなければならない。
  --------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  観測方法については、「地上気象観測指針」に準じることを標準とする。ただし、降雪深、積雪量、蒸発量、蒸発散量については、気象学的な厳密な観測手法だけではなく、水文学的な評価手法（たとえば、蒸発散量を水収支法により推定する方法等）もあり、観測値に求められる精度と利用できるリソースを総合的に判断することで評価手法を選定するものとする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1.  地上気象観測指針，平成14年，気象庁，気象業務支援センター，第7章
    降水量及び積雪・降雪の深さの観測 7･2･3 観測条件 p.53.

```{=html}
<!-- -->
```
29. 気象観測の手引き，平成10年，気象庁.

＜参考となる資料＞

本項に規定していない関連気象水文要素の観測方法の詳細については、下記の資料が参考となる。

1.  国土交通省監修，(独)土木研究所編著：水文観測，第2章 降水量観測 2･7
    降雪量の観測 2･9
    その他の水文気象要素の観測，全日本建設技術協会，2002.

**調査編**

4.  **水文・水理観測**

**第3節　水位観測**

**目　次**

[第3節 水位観測 1](#_Toc97231213)

> [3．1 総説 1](#_Toc97231214)
>
> [3．2 水位の基準面の取り方 2](#_Toc101464343)
>
> [3．3 水位観測の方法 2](#_Toc97231216)
>
> [3．4 水位観測所の配置と設置 3](#_Toc97231217)
>
> [3．4．1 水位観測所の配置 3](#_Toc97231218)
>
> [3．4．2 水位観測所の設置場所の選定 4](#_Toc97231219)
>
> [3．5 水位観測所が備えるべき設備 4](#_Toc97231220)
>
> [3．5．1 総説 4](#_Toc97231221)
>
> [3．5．2 自記水位計 5](#_Toc97231222)
>
> [3．5．3 水位標 7](#_Toc97231223)
>
> [3．5．4 水準基標 8](#_Toc97231224)
>
> [3．5．5 標識 8](#_Toc97231225)
>
> [3．6 観測所台帳 8](#_Toc97231226)
>
> [3．7 水位観測 9](#_Toc97231227)
>
> [3．7．1 自記水位計による観測 9](#_Toc97231228)
>
> [3．7．2 水位観測システムの二重化等 9](#_Toc97231229)
>
> [3．8 水位観測所の維持及び管理 10](#_Toc97231230)
>
> [3．9 簡易観測等 11](#_Toc97231231)
>
> [3．9．1 洪水痕跡水位調査 11](#_Toc97231232)
>
> [3．9．2 簡易水位観測 12](#_Toc97231233)

令和４年６月　版

適用上の位置付け

　河川砂防技術基準調査編は、基準の適用上の位置付けを明確にするために、下表に示すように適用上の位置付けを分類している。

+--------+------------------+------------------+------------------+
| 分　類 | 適用上の位置付け | 末尾の字句例     |                  |
+--------+------------------+------------------+------------------+
| 考え方 | 技術資料         | ●目              | 「･･･ある。      |
|        |                  | 的や概念、考え方 | 」「･･･いる。」  |
|        |                  | を記述した事項。 |                  |
|        |                  |                  | 「･･･なる。      |
|        |                  |                  | 」「･･･れる。」  |
+--------+------------------+------------------+------------------+
| 必　須 | 技術基準         | ●法令による規定  | 「･･･なければ    |
|        |                  | や技術的観点から | ならない。」「･  |
|        |                  | 実施すべきである | ･･ものとする。」 |
|        |                  | ことが明確であり |                  |
|        |                  | 遵守すべき事項。 |                  |
+--------+------------------+------------------+------------------+
| 標　準 | 技術基準         | ●特              | 「･･･            |
|        |                  | 段の事情がない限 | を標準とする。」 |
|        |                  | り記述に従い実施 |                  |
|        |                  | すべきだが、状況 | 「･･･            |
|        |                  | や条件によって一 | を基本とする。」 |
|        |                  | 律に適用すること |                  |
|        |                  | はできない事項。 | 「･･･による。」  |
+--------+------------------+------------------+------------------+
| 推　奨 | 技術資料         | ●状況や条件      | 「               |
|        |                  | によって実施する | ･･･望ましい。」  |
|        |                  | ことが良い事項。 |                  |
|        |                  |                  | 「               |
|        |                  |                  | ･･･推奨する。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･務める。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･必要に応    |
|        |                  |                  | じて･･･する。」  |
+--------+------------------+------------------+------------------+
| 例　示 | 技術資料         | ●適用条件や実施  | 「               |
|        |                  | 効果について確定 | ･･･などの手法（  |
|        |                  | している段階では | 事例）がある。」 |
|        |                  | ないが、状況や条 |                  |
|        |                  | 件によっては導入 | 「･･･など        |
|        |                  | することが可能な | の場合がある。」 |
|        |                  | 新技術等の例示。 |                  |
|        |                  |                  | 「･･･など        |
|        |                  | ●状              | が考えられる。」 |
|        |                  | 況や条件によって |                  |
|        |                  | 限定的に実施でき | 「               |
|        |                  | る技術等の例示。 | ･･･の場合には･･･ |
|        |                  |                  | ことができる。」 |
|        |                  | ●具体的          |                  |
|        |                  | に例示することに | 「               |
|        |                  | より、技術的な理 | ･･･例示する。」  |
|        |                  | 解を助ける事項。 |                  |
|        |                  |                  | 「例えば･･･。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･事例もある  |
|        |                  |                  | 。･･･もよい。」  |
+--------+------------------+------------------+------------------+

  関連通知等       関連する通知やそれを理解する上で参考となる資料
  ---------------- ------------------------------------------------------
  参考となる資料   例示等に示した手法・内容を理解する上で参考となる資料

1.  []{#_Toc97231213 .anchor}水位観測

    1.  []{#_Toc97231214 .anchor}総説

＜考え方＞

+----------------------------------------------------------------------+
| 本節は、水位観測を実施するために必要な技術的事項を定めるものである。 |
|                                                                      |
| 水位とは、ある                                                       |
| 基準面からの水面の高さであり、河川、湖沼、貯水池、遊水地、内水、河口 |
| 、及び、地下水等の水文・水理現象を把握することを目的として観測を行う |
| 。その観測結果は、当該地点における水位の把握のほか、個別地点の水深や |
| ほかの地点との関係の中での水位差・水面形・水面勾配に換算したり、本章 |
| 第4節 流量観測                                                       |
| で記述する流量や流速に変換したりすることで活用される。               |
|                                                                      |
| 水位観測は、河川・砂防に関する計画の                                 |
| 立案、工事の実施、施設の維持管理、環境の整備及び保全、洪水や渇水等の |
| 水災害への対応等を実施するための、最も基本的な調査項目の一つである。 |
|                                                                      |
| 本節で主に扱うのは、本章第1節 総説                                   |
| で説明した3つ                                                        |
| のカテゴリーのうちのカテゴリー１である（表2-1-1参照）。ただし本節3.  |
| 9では、実務上の重要性に鑑み、カテゴリー2に属する簡易観測や洪水痕跡水 |
| 位調査を記載している。地下水の観測については、本章第6節に記載する。  |
|                                                                      |
| 得られた水位観測値の照査やデータ整理・保存については、本章           |
| 第5節水文資料の整理・保存と品質管理 によるものとする。               |
+----------------------------------------------------------------------+

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------
  水位観測は、河川、湖沼、貯水池等における、ある基準面からの水面の高さの観測であり、これらは関連通知等に従い実施する。
  ----------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1.  国土調査法，昭和26年6月1日，法律第180号，最終改正：令和7年6月1日法律第68号.

```{=html}
<!-- -->
```
30. 気象業務法，昭和27年6月2日，法律第165号，最終改正：令和7年6月1日法律第68号.

31. 水文観測業務規程，平成29年3月31日，国水情第44号，国土交通事務次官通達.

32. 水文観測業務規程細則，平成29年3月31日，国水情第45号，国土交通省水管理・国土保全局通達.

33. 河川砂防技術基準計画編，令和3年4月28日，国水情52号，国土交通省水管理・国土保全局.

    （最新版）河川砂防技術基準計画編，令和7年6月，国土交通省水管理・国土保全局.

34. 河川砂防技術基準維持管理編（河川編），平成27年3月3日，国水情20号，国土交通省水管理・国土保全局.

    （最新版）河川砂防技術基準維持管理編（河川編），令和3年10月，国土交通省水管理・国土保全局.

＜参考となる資料＞

水位観測の詳細な要領については、下記の資料が参考となる。

1.  国土交通省監修，(独)土木研究所編著：水文観測，第3章
    水位観測，全日本建設技術協会，2002.

**\
**

2.  []{#_Toc101464343 .anchor}水位の基準面の取り方

＜考え方＞

+----------------------------------------------------------------------+
| 水位の測定表示単位は、mとし、読み取り最小単位は、1/100 mとする。     |
|                                                                      |
| 水位の基準面の取り方には、主に以下の3種類がある。                    |
|                                                                      |
| １)                                                                  |
| 水位観測地点にお                                                     |
| いて、当該地点独自の基準面を設定し、そこからの水面の高さとする方法。 |
|                                                                      |
| ２)                                                                  |
| あ                                                                   |
| る水系内の上流から下流に至る観測所間での水位の相互関係を明らかにする |
| ため、当該水系独自の基準面を設定し、そこからの水面の高さとする方法。 |
|                                                                      |
| ３)                                                                  |
| 東京湾平均海面（T.P.）を基準面とし、そこからの水面の高さとする方法。 |
|                                                                      |
| 上記                                                                 |
| １）の基準面の取り                                                   |
| 方は、水位観測の目的（水防活動の基準等）や河川断面・堤内地標高等の特 |
| 性を考慮して最も適切な基準面（零点高）を地先ごとに定める方法である。 |
|                                                                      |
| しかし、それだけでは、複数地点の水位を比較する                       |
| ことができないことから、水系一貫の河川計画・管理を行う場合には、上記 |
| ２）、３）のように当該水                                             |
| 系における統一基準面を設定した上での基準面の取り方が有効となる。上記 |
| ３）の基準面の取り方は、水面の標高表示といえるものであ               |
| り、水系をまたがる全国統一基準面での水位となる。水系内の統一基準面を |
| T.P.とすることが多いが、水系により独自の統一基準面を設定している例（ |
| 利根川水系：Y.P.、荒川・多摩川水系：A.P.、淀川水系：O.P.等）もある。 |
|                                                                      |
| また                                                                 |
| 、水位は、河川・湖沼等における流れ、貯留量等を把握するための基本量で |
| あることから、一般には波浪の影響を受けない平均的な水面の高さを測定す |
| る必要がある。このことから、水位は、波浪の影響を受ける瞬時値ではなく |
| 、当該地点の水理特性を表す時間平均値として計測することが必要である。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 水位の測定表示単位は、mとし、読み取り最小単位は、1/100 mとする。     |
|                                                                      |
| 水位の基準面の取り方は、以下の3種類を基本とする。                    |
|                                                                      |
| １)                                                                  |
| 水位観測地点にお                                                     |
| いて、当該地点独自の基準面を設定し、そこからの水面の高さとする方法。 |
|                                                                      |
| ２)                                                                  |
| あ                                                                   |
| る水系内の上流から下流に至る観測所間での水位の相互関係を明らかにする |
| ため、当該水系独自の基準面を設定し、そこからの水面の高さとする方法。 |
|                                                                      |
| ３)                                                                  |
| 東京湾平均海面（T.P.）を基準面とし、そこからの水面の高さとする方法。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

水位観測の基準面や表示の概念の詳細については、下記の資料が参考となる。

1.  国土交通省監修，(独)土木研究所編著：水文観測，第3章
    水位観測3･1概説，全日本建設技術協会，2002.

    2.  []{#_Toc97231216 .anchor}水位観測の方法

＜考え方＞

+----------------------------------------------------------------------+
| 水位観測は自                                                         |
| 記水位計または水位標によって実施する。通常の観測は、自記水位計により |
| 実施し、自記水位計の故障や水位計の校正のため、近傍の水位標を用いる。 |
|                                                                      |
| また、水位計には接                                                   |
| 触型、非接触型とも様々な種類があり、観測目的や環境に応じて選定する。 |
+----------------------------------------------------------------------+

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  水位観測は自記水位計または水位標を用いた観測を標準とする。なお、自記水位計による水位観測値は、同一横断面内に設置した水位標による水位観測値と一致していることが原則であり、必要に応じて水位標による観測によって校正もしくは補完するものとする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜例　示＞

+------------------------------------------------------------------------+
| 河川等の調査でよく使われている水位計には次のようなものがある。         |
|                                                                        |
| 1.  主な水位計の種類                                                   |
|                                                                        |
| +------------+------------------+------------------------------------+ |
| | 検出方式   |                  | 説　明                             | |
| +------------+------------------+------------------------------------+ |
| | 接触型     | フロート式水位計 | > 水面に浮かべたフロートと         | |
| |            |                  | 錘とをワイヤーで結び、そのワイヤー | |
| | フロート式 |                  | を滑車にかけて、回転量を記録する。 | |
| |            |                  | 設置については観測井が必要である。 | |
| +------------+------------------+------------------------------------+ |
| |            | ﾘｰﾄﾞｽｲｯﾁ式水位計 | > 水中に測定柱を立て、             | |
| |            |                  | その中に磁石の付いたフロートと一定 | |
| |            |                  | 間隔に並んだリードスイッチを配置し | |
| |            |                  | 、フロートの上下によるスイッチのON | |
| |            |                  | /OFFにより水位を測定する。設置のた | |
| |            |                  | めにＨ鋼杭などの支柱が必要である。 | |
| +------------+------------------+------------------------------------+ |
| | 接触型     | 気泡式水位計     | >                                  | |
| |            |                  | 水深と水圧が比例することから、水中 | |
| | 圧力式     |                  | に開口した管から気泡を出すときに必 | |
| |            |                  | 要な圧力を測定し、機械的または電気 | |
| |            |                  | 的な変換により水位を測定する。気泡 | |
| |            |                  | 管を水中に固定するだけで設置は簡易 | |
| |            |                  | である。気泡発生装置が必要である。 | |
| +------------+------------------+------------------------------------+ |
| |            | 水圧式水位計     | > 水中に設置された圧力センサーの   | |
| |            |                  | 信号を電気的に変換して水位を測定す | |
| |            |                  | る。センサーには半導体式や水晶式な | |
| |            |                  | どの種類がある。電池で長時間作動し | |
| |            |                  | 、データを記録するロガー付きの小型 | |
| |            |                  | タイプのものであれば、現場に機器を | |
| |            |                  | 取り付けるだけで、比較的簡単に水位 | |
| |            |                  | の時間変化測定を行うことができる。 | |
| +------------+------------------+------------------------------------+ |
| | 非接触型   | 超音波式水位計   | > 超音波又は電波送受               | |
| |            |                  | 波器を水面の鉛直上方に取り付け、超 | |
| |            | 電波式水位計     | 音波または電波が水面に当たって戻っ | |
| |            |                  | てくるまでの時間を測定することによ | |
| |            |                  | り、水位を測定する。非接触型である | |
| |            |                  | ため、流路の変動時に対処しやすい。 | |
| +------------+------------------+------------------------------------+ |
| |            | ＣＣＴＶカメラ   | > 水位標                           | |
| |            |                  | または橋脚や護岸など水面輝度の違い | |
| |            |                  | を認識できる場所を利用して、CCTVカ | |
| |            |                  | メラから水面位置を認識し、水位標や | |
| |            |                  | 事前測量データと組み合わせることで | |
| |            |                  | 水位を観測する。CCTVカメラによる水 | |
| |            |                  | 位標等を利用した水位観測は、状況に | |
| |            |                  | よっては自記水位計による水位観測値 | |
| |            |                  | の校正もしくは補完に利用できる。一 | |
| |            |                  | 般に継続的な観測には適していない。 | |
| +------------+------------------+------------------------------------+ |
+------------------------------------------------------------------------+

1.  []{#_Toc97231217 .anchor}水位観測所の配置と設置

    1.  []{#_Toc97231218 .anchor}水位観測所の配置

＜必　須＞

  ----------------------------------------------------------------------------------------------------------------------------
  水位観測所あるいは観測地点は、観測の目的に応じて、河川等の計画、管理上などの重要な地点にその配置を検討しなければならない。
  ----------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

+----------------------------------------------------------------------+
| 水系全体から見た適正な観測                                           |
| 網を構成する重要な地点としては、以下の地点を選定することが望ましい。 |
|                                                                      |
| １) 重要支派川の分合流前後、堰・水門等の上下流                       |
|                                                                      |
| ２) 流量を観測する地点                                               |
|                                                                      |
| ３)                                                                  |
| 狭窄部、                                                             |
| 遊水地、湖沼、貯水池、内水及び河口等の水理状況を知るために必要な地点 |
|                                                                      |
| なお、洪水時に水位流量曲線がループを描く流量観測所                   |
| では、近隣の水位観測所との水位差（水面勾配）を考慮に入れた水位流量曲 |
| 線を導入することにより、流量観測精度が高くなる場合がある。その場合は |
| 、当該観測所の上下流地点にも水位観測所を別途設置することが望ましい。 |
|                                                                      |
| 一方、近                                                             |
| 年、中小河川や河川上流部・支川における水害発生が顕著となっており、従 |
| 来よりもきめ細かな観測網による水位予測の精度の向上をとおして早期避難 |
| や的確な水防活動を実施するなどの危機管理体制の強化が必要となってきて |
| いる。このような場合は、3.9に示す簡易観測を実施することが望ましい。  |
+----------------------------------------------------------------------+

2.  []{#_Toc97231219 .anchor}水位観測所の設置場所の選定

＜標　準＞

+----------------------------------------------------------------------+
| 水位観測所は次の各項に掲げる条件を                                   |
| 考慮し、要求される精度の観測が行える場所に設置することを標準とする。 |
|                                                                      |
| １) 水流の乱れが少なく、流心が安定している場所                       |
|                                                                      |
| ２) 流路や河床の変動が少ない場所                                     |
|                                                                      |
| ３) 観測所の維持管理が容易な場所                                     |
|                                                                      |
| ４)                                                                  |
| 観                                                                   |
| 測所に設置すべき自記水位計のデータ表示・記録等を担う自動記録装置や自 |
| 動データ転送装置等に関しては、洪水時を含めてその設置場所へのアクセス |
| が可能であり、観測作業を実施するに当たって危険が少なく安全である場所 |
+----------------------------------------------------------------------+

＜推　奨＞

+----------------------------------------------------------------------+
| 水位観測所の具体的な位置設定に                                       |
| 当たっては、上記のほか、以下のような事項にも留意することが望ましい。 |
|                                                                      |
| １)                                                                  |
| 湖沼・貯水池、場合によっては河川においても水面の振動現               |
| 象（セイシュ）が発生して水位観測の精度が低下する場合がある。そのため |
| 、事前に調査を実施し、水面の振動現象が発生しない場所に設置する、又は |
| 振動の静止点（節ともよぶ）に観測所を設置するなどの対応が必要である。 |
|                                                                      |
| ２)                                                                  |
| 内水水位観測                                                         |
| の場合には付近の地形・地物を考慮して代表性のある所を選ぶ必要がある。 |
|                                                                      |
| ３)                                                                  |
| 感                                                                   |
| 潮河川の感潮区間上流で、感潮区間内ではないとされている地点においても |
| 、近時の河床低下等で潮汐の影響を受けていることがあるので、非感潮区間 |
| で観測する場合には、特に渇水期の大潮時に調査を行っておく必要がある。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

観測設備の配置・設置の詳細については、下記の資料が参考となる。

1.  国土交通省監修，(独)土木研究所編著：水文観測，第3章
    水位観測3・2観測所の配置と位置選定，全日本建設技術協会，2002.

    1.  []{#_Toc97231220 .anchor}水位観測所が備えるべき設備

        1.  []{#_Toc97231221 .anchor}総説

＜標　準＞

+----------------------------------------------------------------------+
| 水位観測所は、以下の設備等を備えることを標準とする。                 |
|                                                                      |
| １) 自記水位計（自動記録装置、自動データ転送装置を含む。）           |
|                                                                      |
| ２) 水位標（量水標）及び水準基標                                     |
|                                                                      |
| ３) 標識                                                             |
|                                                                      |
| ４）電源装置（非常用発電設備含む）                                   |
|                                                                      |
| 河川における自記水位計および水位標については、以下                   |
| に示す水位の範囲を精度良く計測できるように設置することを標準とする。 |
|                                                                      |
| 　計                                                                 |
| 測下限：水位標については、既往の最低水位より1m以上低い水位。自記水位 |
| 計については、既往の最低水位より0.5m以上低い水位または、現況河床高。 |
|                                                                      |
| 　計測上限：無堤区間の場合、計画高水位又は既往最高                   |
| 水位より1m以上高い水位。有堤区間では、堤防天端より0.5m以上高い水位。 |
|                                                                      |
| 河川以外に設置する水位計についても、その目的に照ら                   |
| して計測しておくべき範囲の水位を欠測しないように設置するものとする。 |
|                                                                      |
| 目的を低水計画・                                                     |
| 管理若しくは、高水計画・管理に明確に区別して絞り込むことができる場合 |
| は、いずれかの目的に対応する水位範囲のみを観測する設備としてもよい。 |
|                                                                      |
| なお、カテゴリー２やカテゴリー３等で行う観測の                       |
| 設備は、観測目的に応じ、水位標・水準基標・標識を設置しなくてもよい。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

水位観測所の詳細については、下記の資料が参考となる。

1.  国土交通省監修，(独)土木研究所編著：水文観測，第3章
    水位観測3・4観測施設，全日本建設技術協会，2002.

    1.  []{#_Toc97231222 .anchor}自記水位計

```{=html}
<!-- -->
```
1.  自記水位計が満たすべき要件

＜必　須＞

+----------------------------------------------------------------------+
| 自記水位計は、水位の時間平均値を記録・出力することができなければな   |
| らない。ただし、自動記録装置として自記紙のみを採用し、かつ、自動デー |
| タ伝送装置を備える必要のない自記水位計については、その限りではない。 |
|                                                                      |
| デー                                                                 |
| タ表示・記録等を担う自動記録装置や自動データ転送装置等に関しては、堅 |
| 固な基礎の上に、洪水時にも冠水しない高さに据え付けなければならない。 |
|                                                                      |
| 水位の最小読み取り単位は1/100                                        |
| mを原則とする。高い精度を                                            |
| 要求される場合には、必要に応じて最小読取単位を小さくするものとする。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| データ表示・                                                         |
| 記録等を担う自動記録装置や自動データ転送装置等に関しては、洪水時を含 |
| めてその設置場所へのアクセスが可能な場所に設置することを標準とする。 |
|                                                                      |
| また、水位計としての必要な性能を満たすこ                             |
| とを証明する試験成績書が添付された水位計を使用することを標準とする。 |
+----------------------------------------------------------------------+

13. 自記水位計の選定・設置

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  自記水位計の機種の選定及び設置に当たっては、水位計設置場所の水理特性や地形等に適合していること、目的に応じ洪水や渇水のような異常時も含めて計測すべき最低水位から最高水位まで継続的に安定したデータが取れること、必要精度を満足すること、設置地点の条件下において維持管理が容易であり、設置も含めた経費が適正であること等を総合的に判断して、機種と設置位置を選定するものとする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜例　示＞

+-------------------------------------------------------------------------+
| 主要な自記水位計について、選定に当たっての参考事項を以下に例示する。    |
|                                                                         |
| 表2-3-2　主な自記水位計の比較選定時における参考事項                     |
|                                                                         |
| +----------------------------------+----------------------------------+ |
| | 水位計の種類                     | 選定における参考事項             | |
| +==================================+==================================+ |
| | (1)フロート式水位計              | センサ本体                       | |
| |                                  | には電子部品がないため、電源異常 | |
| |                                  | や中断時の対応が容易であり、長期 | |
| |                                  | にわたる水位観測データの収集・蓄 | |
| |                                  | 積において歴史的に大きな役割を果 | |
| |                                  | たしてきた実績がある。しかし、観 | |
| |                                  | 測井・導水路（導水管）を伴う施設 | |
| |                                  | 整備が必要であり、河床変動・土砂 | |
| |                                  | 輸送が激しい河川では、導水路（導 | |
| |                                  | 水管）の水流からの隔絶や土砂堆積 | |
| |                                  | による閉塞への対策が必要である。 | |
| +----------------------------------+----------------------------------+ |
| | (2)リードスイッチ式水位計        | 観測井が不                       | |
| |                                  | 要でH型鋼を利用して比較的容易に  | |
| |                                  | 設置ができ、中下流部での観測に多 | |
| |                                  | く用いられる。低水から高水までの | |
| |                                  | 観測を確保するために、一般に同一 | |
| |                                  | 横断面に複数のセンサを設置する必 | |
| |                                  | 要がある。流下物の影響を小さくす | |
| |                                  | るゴミよけ等の対策が必要である。 | |
| +----------------------------------+----------------------------------+ |
| | (3)気泡式水位計                  | 気                               | |
| |                                  | 泡が送気管から出るときの圧力を測 | |
| |                                  | る水位計である。以前に比べてシス | |
| |                                  | テム全体が小型化されており、海外 | |
| |                                  | では、適用事例は少なくない。動水 | |
| |                                  | 圧や、水温・濁度等による水の密度 | |
| |                                  | 変化の影響には注意が必要である。 | |
| +----------------------------------+----------------------------------+ |
| | (4)水圧式水位計                  | 水中にセンサ部を固定すればよく   | |
| |                                  | 、設置が容易である。しかし、動水 | |
| |                                  | 圧の影響や、高速流・転石等による | |
| |                                  | センサ流出・ケーブル破断、および | |
| |                                  | 、水温・濁度等による水の密度変化 | |
| |                                  | の影響には注意が必要である。セン | |
| |                                  | サ部が大気圧との差圧検知型でない | |
| |                                  | 場合は、大気圧補正が必要である。 | |
| +----------------------------------+----------------------------------+ |
| | >                                | 水面と全                         | |
| |  (5)超音波式水位計、電波式水位計 | く接触せずに計測でき、観測断面内 | |
| |                                  | におけるセンサの設置位置の自由度 | |
| |                                  | が高いことから、高流速の地点や河 | |
| |                                  | 床変動が激しく川筋が大きく変動す | |
| |                                  | る場所での設置に適している。セン | |
| |                                  | サ本体を空中に設置することから、 | |
| |                                  | 風による振動や、設置土台の振動を | |
| |                                  | 抑制する必要がある。また、超音波 | |
| |                                  | 式の場合、気温補正が必要である。 | |
| +----------------------------------+----------------------------------+ |
| | (6)CCTVカメラ                    | CCTVを活用し                     | |
| |                                  | て水位標または、橋脚等での水面を | |
| |                                  | 抽出することにより、水位の計測が | |
| |                                  | 可能であり、危機管理目的やより高 | |
| |                                  | 度な河道管理への情報収集等を目的 | |
| |                                  | とした水位計測に用いることができ | |
| |                                  | る。橋脚を水面抽出の対象とする場 | |
| |                                  | 合、橋脚による水位の乱れ（せき上 | |
| |                                  | げ等）の影響に注意が必要である。 | |
| +----------------------------------+----------------------------------+ |
+-------------------------------------------------------------------------+

＜参考となる資料＞

自記水位計の種類ごとの特徴や留意事項については、下記の資料が参考となる。

1.  国土交通省監修，(独)土木研究所編著：水文観測，第3章
    水位観測3・3水位観測器械，全日本建設技術協会，2002.

```{=html}
<!-- -->
```
14. 自動記録装置

＜必　須＞

+----------------------------------------------------------------------+
| 水位観測所                                                           |
| には、自記紙やデータロガー等の自動記録装置を設置しなければならない。 |
|                                                                      |
| 自動記録装置は、関連機材を収納することのでき                         |
| る観測小屋又は観測ボックス等の内部に設置し、無人・自動での確実な観測 |
| データ記録と定期的なデータ収集に支障のないようにしなければならない。 |
|                                                                      |
| ただし、カテゴリー                                                   |
| ２やカテゴリー３等の観測を目的とした水位計の場合はその限りではない。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 自記水位計のうち、デジタル的に水位を表示・記録する装置の場合は、     |
| 1秒以下の時間間隔で水位の瞬時計測値を得ることができ、それらのある一  |
| 定時間内で平均した値（波浪等の影響を除いた水位の観測値）について、10 |
| 分以下の時間間隔で表示・記録できる機能を有していることを標準とする。 |
|                                                                      |
| な                                                                   |
| お、水位瞬時計測値を水位観測値とするためのサンプリング間隔（瞬時計測 |
| の時間間隔）とその平均時間については、本節3.7.1自記水位計による観測  |
| によるものとする。                                                   |
+----------------------------------------------------------------------+

15. 自動データ転送装置

＜必　須＞

  --------------------------------------------------------------------------------------------------
  リアルタイム観測が必要な水位観測所は、自動データ伝送装置（テレメータ等）を備えなければならない。
  --------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 自動データ伝送装置は、                                               |
| 10分以下の時間間隔でデータを転送できる機能を有するものを標準とする。 |
|                                                                      |
| 自動データ伝送装置は、「電気通                                       |
| 信施設設計要領（案）（通信編）」に基づき設計されたものを標準とする。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  電気通信施設設計要領（通信編），令和4年3月30日，国技電第90号，国土交通省大臣官房技術調査課電気通信室長通知.

    1.  []{#_Toc97231223 .anchor}水位標

＜必　須＞

+----------------------------------------------------------------------+
| 水位標は、量水板を用いて水位を目視観測するための設備であ             |
| り、自記水位計の水位観測値を校正もしくは補完するためにも用いられる。 |
|                                                                      |
| 量水板の最小目盛の単位は原則として1/100 mとしなければならない。      |
|                                                                      |
| ただし、高い精度が                                                   |
| 要求される場合には、必要に応じて最小読取単位を小さくするものとする。 |
|                                                                      |
| 水位標の零点の標高（零点高）は、水準基標を基準として測量してお       |
| かなければならない。これにより、本節3.2に述べた各種の水位表示法につ  |
| いて、目的に応じていつでも相互に変換できるようにしておくものとする。 |
|                                                                      |
| 水位標の零点                                                         |
| 高は原則として既往最低水位以下としなければならない。ただし、上下流の |
| 近接する既設水位標の零点高との関連も考慮して定めるものとする。また、 |
| 河床掘削計画等がある場合には、その影響を見込んで設定するものとする。 |
|                                                                      |
| 夜間や出水時の場合でも、目                                           |
| 盛を正確に読み取ることができる箇所に水位標を設置しなければならない。 |
|                                                                      |
| 水位計測範囲を大きくとる必要がある川では                             |
| 、2m程度の支柱を護岸や堤防のり面に複数本設置し、水位上昇時においても |
| 、順次上位の水位標に読取を安全に引き継げるようにしなければならない。 |
|                                                                      |
| その際、上位・下位の水位標目盛の重複は0.5m以上とする。               |
|                                                                      |
| 水位標の設置後においても、その零点高は少なくとも年１回は             |
| 測定しなければならない。その場合、水準器の読取の単位は1mmを用いる。  |
+----------------------------------------------------------------------+

＜標　準＞

  ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  零点高の変化が見られた場合、零点高の変化時点（洪水、地震等）が分かる場合にはその時点より、分からない場合は前年の測定時点より、水位観測値を補正することを原則とする。ただし、補正の単位は1/100 mとする。
  ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

2.  []{#_Toc97231224 .anchor}水準基標

＜必　須＞

+----------------------------------------------------------------------+
| 水準基標（                                                           |
| 水準拠標）は、水位観測所（水位標）の零点高と東京湾平均海面（T.P.）及 |
| び当該水系における独自の統一基準面がある場合にはその基準面との関係を |
| 定義するために、水位観測の近くに水準点に準じて必ず設置するものとする |
| 。やむを得ず距離標等で代用する場合は堅固な構造としなければならない。 |
|                                                                      |
| 定期                                                                 |
| 的な水準測量により、その標高を常に明らかにしておかなければならない。 |
|                                                                      |
| 地盤沈下・隆起のある地域では、地盤変動                               |
| していないと推定される水準点を基準として水準測量しなければならない。 |
+----------------------------------------------------------------------+

＜標　準＞

  -------------------------------------------
  水準基標の測量精度は、2級水準測量とする。
  -------------------------------------------

3.  []{#_Toc97231225 .anchor}標識

＜必　須＞

+----------------------------------------------------------------------+
| 水位観測所                                                           |
| には、標識を設置し、必要に応じ観測小屋、柵を設置しなければならない。 |
|                                                                      |
| 標識には、観測所名、水系・河川名、                                   |
| 設置者名、設置年月日、観測所所在地、緯度・経度、標高（水位標零点高） |
| 、河口又は合流点からの距離、水防団待機水位、氾濫注意水位を記載する。 |
|                                                                      |
| また、必要に応じて、既往最高                                         |
| 水位、計画高水位、観測所番号等、参考となる事項を記載するものとする。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

標識に関わる詳細な内容については、下記の資料が参考となる。

1.  国土交通省監修，(独)土木研究所編著：水文観測，第3章
    水位観測，全日本建設技術協会，2002.

    1.  []{#_Toc97231226 .anchor}観測所台帳

＜必　須＞

+----------------------------------------------------------------------+
| 水位観測所を設置し                                                   |
| 水位観測を行う者は、水位観測所台帳及び付図を作成しなければならない。 |
|                                                                      |
| 台帳には、観測所の位置や施設構造等に関する諸元のほか、水防団待機水   |
| 位、氾濫注意水位及び氾濫危険水位並びに水位標位置、零点高及び観測機器 |
| の変化等を記載し、観測条件の変遷を明らかにしておかなければならない。 |
|                                                                      |
| 水位                                                                 |
| 観測所には、水位観測所台帳及び付図の写しを備え付けなければならない。 |
|                                                                      |
| 様式については「水文観測業務規程細則」に従わなければならない。       |
+----------------------------------------------------------------------+

＜参考となる資料＞

観測所台帳に関する詳細な内容については、下記の資料が参考となる。

1.  国土交通省監修，(独)土木研究所編著：水文観測，第3章
    水位観測，全日本建設技術協会，2002.

    1.  []{#_Toc97231227 .anchor}水位観測

        1.  []{#_Toc97231228 .anchor}自記水位計による観測

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  自記水位計により計測した水位は、波浪の影響を排除するために、ある一定時間にサンプリングされた水位瞬時計測値群を対象として、その一定時間で平均した値を水位観測値として記録するものとする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

+----------------------------------------------------------------------+
| 自記水位計のうち、デジタルに水                                       |
| 位を表示・記録する装置の場合、瞬時の水位観測値のサンプリング間隔や平 |
| 均値を算定するための観測対象時間は、出水特性を考慮した上で波浪等の周 |
| 期性を排除できるサンプリング間隔・平均手法を検討することが望ましい。 |
|                                                                      |
| ただし、その検討が行われていない段階では、瞬時の水位観測値の         |
| サンプリング間隔を1秒、平均時間を全体で20秒以上、と設定してもよい。  |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  水文観測業務規程，平成29年3月31日，国水情第44号，国土交通事務次官通達，第3章
    観測.

```{=html}
<!-- -->
```
35. 水文観測業務規程細則，平成29年3月31日，国水情第45号，国土交通省水管理・国土保全局通達，第3章
    観測の実施.

＜参考となる資料＞

自記水位計による観測に関わる詳細な内容については、下記の資料が参考となる。

1.  国土交通省監修，(独)土木研究所編著：水文観測，第3章 水位観測 3･5
    観測，全日本建設技術協会，2002.

    1.  []{#_Toc97231229 .anchor}水位観測システムの二重化等

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------
  水位観測所は、地震等の自然災害時や停電時における機能確保を考慮して設計し、非常用発電設備など必要な設備を設置することを標準とする。
  ------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

+----------------------------------------------------------------------+
| 河川計画・管理、危機管理上重要な水位観測所においては、データの欠     |
| 測を極力防止し、整合性のあるデータを極力継続して取得するため、必要に |
| 応じて観測システム（センサ及び記録部）の二重化を図ることが望ましい。 |
|                                                                      |
| センサの二重化を図る場合には、設置地点は、同一地点、少な             |
| くとも同一横断面内を原則とする。やむを得ず、縦断方向に位置がずれる場 |
| 合には、相互の水位関係を把握し、水位の相関を確認しておくこととする。 |
|                                                                      |
| また、自記水位計の機種は異機種とすることが望ましい。                 |
|                                                                      |
| なお、主水位計と副水位計の切り替えは遠隔で可能とし                   |
| 、切り替えを行う場合には、切り替えの基準を明確にしておくこととする。 |
+----------------------------------------------------------------------+

＜例　示＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------
  観測システムのうち、観測データの伝送路についても二重化（無線テレメータと光ファイバ網の両者の活用等）を図ることで、データ欠測のリスクをさらに減らすことができる。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------

1.  []{#_Toc97231230 .anchor}水位観測所の維持及び管理

＜必　須＞

+----------------------------------------------------------------------+
| 観測設備の維持及び管理の実施に際しては、「水文観測業務規程」第8章    |
| 観測所の維持及び管理、「水文観測業務規程細則」の第8章                |
| 観測所の維持管理等 の定めに従わなければならない。                    |
|                                                                      |
| また、観測設備ごとに点                                               |
| 検や維持管理上必要な事項を記入した点検記録簿を備えなければならない。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 観                                                                   |
| 測設備の点検は、観測設備の維持管理において最も重要である。点検は、以 |
| 下に示す総合点検及び定期点検を組み合わせて実施することを基本とする。 |
| それぞれにおいて点検すべき主要な事項は以下を標準とする。なお、これら |
| の点検においては、水位標による水位観測値と自記水位計による水位観測値 |
| を必ず記録・比較し、自記水位計の校正をその都度図ることを原則とする。 |
|                                                                      |
| １)                                                                  |
| 総合点検は、年1回以上（出水期前等。必要に応じて回数を増やす。）とし  |
| 、対象とする施設・設備において特に器械類の内部に対して詳細点検を実施 |
| し、擬似テスト等による点検を含めた総合的な保守及び校正を行う。この点 |
| 検は、測定部（センサ）、記録部、器械類の故障の有無を確認し、観測デー |
| タの精度向上が図られるよう保守及び校正を行うことを主たる目的とする。 |
|                                                                      |
| ２)                                                                  |
| 定                                                                   |
| 期点検は、月1回以上（総合点検を除いた月）とし、対象とする施設・設備  |
| において特に器械類の外部（表示値を含む）から判断できる点検を中心に行 |
| う。この点検は、測定部（センサ）、記録部、器械類の機能障害等の異常を |
| 早期に発見し、観測データの欠測や異常値を生じさせないことを主たる目的 |
| とする。なお、これらの点検においては、水位標読取値と自記水位計記録値 |
| を必ず記録・比較し、自記水位計の校正をその都度図ることを原則とする。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  水文観測業務規程，平成29年3月31日，国水情第44号，国土交通事務次官通達，第8章
    観測所の維持及び管理.

```{=html}
<!-- -->
```
36. 水文観測業務規程細則，平成29年3月31日，国水情第45号，国土交通省水管理・国土保全局通達，第8章
    観測所の維持管理等.

＜参考となる資料＞

水位観測所の維持管理・点検の詳細については、下記の資料が参考となる。

1.  国土交通省監修，(独)土木研究所編著：水文観測，第3章
    水位観測3･6観測所の維持管理，全日本建設技術協会，2002.

    1.  []{#_Toc97231231 .anchor}簡易観測等

        1.  []{#_Toc97231232 .anchor}洪水痕跡水位調査

＜考え方＞

+----------------------------------------------------------------------+
| 洪水痕跡とは、堤防のり面等に繁茂する植生に付着した泥やゴミ等         |
| 、当該洪水時に冠水したことを示す跡である。洪水痕跡水位は、任意の河道 |
| 横断測線上において洪水痕跡が認められる最高地点の標高として測定するも |
| のである。多数の河道横断測線において痕跡水位を得ることで、当該出水時 |
| の左右岸に沿った最高水位の詳細な縦断分布を知ることができ、洪水流下の |
| ネック部（せき上げ）、河道の湾曲や砂州による左右岸の水位差、粗度係数 |
| 等といった洪水の流下特性を調査するための基礎的データとして活用する。 |
|                                                                      |
| 本調査で得られる水位の精度は、本節3.9.2に後述するように、カテゴリー  |
| 1の水位観測に比較して低いことが一般的である。また、痕跡であることか  |
| ら、その地点の最高水位を表すものであり、その生起時刻や水位の時間変化 |
| に関する情報は得られない。洪水痕跡水位調査にはこのような短所がある一 |
| 方、縦断方向に密な測定が可能で、縦断的な水位分布に関する詳細な情報を |
| 得られる可能性が高く、洪水時の観測の困難さから考えて、洪水痕跡調査を |
| 行うことが洪水流の特性を知る上で非常に重要と認識され、実施されてきた |
| ところである。こうした観点から、カテゴリー２の具体例として記載する。 |
|                                                                      |
| なお、表2-3-1に簡易観測として示したように、水位の時間変化を測定す    |
| ることが技術的にもコスト面でも容易になってきたことから、縦断方向に密 |
| で、かつ時間変化の情報まで得られる水位測定が可能となってきている。し |
| たがって、こうした水位測定方法を洪水痕跡水位測定の代わりに採用する、 |
| あるいは併用するという選択肢があることを考慮しておくことが望ましい。 |
+----------------------------------------------------------------------+

＜推　奨＞

+----------------------------------------------------------------------+
| 痕跡水位の測定については、以下により実施することが望ましい。         |
|                                                                      |
| １)                                                                  |
| ピーク水位発生後、なるべく早く痕跡の位                               |
| 置を測定すること。又は杭・マーカー等で印を付けて、後日測定すること。 |
|                                                                      |
| ２)                                                                  |
| 痕跡の判定は、河                                                     |
| 岸・高水敷・堤防のり面の植生に付着する泥によるものを基本とする。ただ |
| し、樹木や茎の固い草本植物では、洪水流中では倒伏していたものが出水後 |
| に立ち上がり、そのため痕跡による水位が実際より高い位置になる場合があ |
| るため、その採用に当たっては、他の植物種の痕跡と比較するなど注意を要 |
| する。また、高水護岸上では一般に泥の付着による痕跡の判定が困難であり |
| 、確実な痕跡水位を得ることができない。そうした区間が左右岸とも連続す |
| る河道区間では、最高水位のみを記録する簡易な水位計等を設置すること。 |
|                                                                      |
| ３)                                                                  |
| 泥が見られずゴミで判定する場合                                       |
| には、測定対象地点周辺の痕跡をできるだけ多く観察し、低いものを除外し |
| 、高さがおおむね一致するほぼ直線上に位置する痕跡群を採用すること。た |
| だし、護岸の設置された堤防や河岸のり面上には、最高水位の位置にゴミが |
| 残らず、小段等平坦面上に集積する場合がある。それらのゴミも上記のよう |
| に観察した結果、痕跡群として採用される場合がある。このような護岸上（ |
| 特に小段等平坦面上）における痕跡は精度が低い可能性があるので、測定す |
| る際にその旨を記録しておくこと。また、そうした区間が左右岸とも連続す |
| る河道区間では、最高水位のみを記録する簡易な水位計等を設置すること。 |
|                                                                      |
| ４)                                                                  |
| 以上に基づき、左右岸で洪水痕跡水位を得る。洪                         |
| 水痕跡水位は少なくとも定期横断測線上で測定することとするが、低水路幅 |
| に比較して定期横断測線の間隔が大きい河川では、低水路幅と同程度の縦断 |
| 間隔で少なくとも1個以上の洪水痕跡水位が得られるように測定すること。  |
+======================================================================+
| 洪水痕跡水位は、流量データと並んで粗度係数の逆                       |
| 算等、出水に関する水理検討の結果を大きく左右するので、その水位の精度 |
| についてより精度の高い水位測定値との比較から確認することを推奨する。 |
|                                                                      |
| 図2-3-1は、全国の河川を対象に、洪                                    |
| 水痕跡水位に含まれる誤差と河床勾配との関係を示したものである。なお、 |
| 誤差は、洪水痕跡水位の測定を行った断面（地点）内に設置してある自記水 |
| 位計、普通水位計等により得られた水位を真値と仮定し次式により求めた。 |
|                                                                      |
| > 誤差＝（洪水痕跡水位）－（水位計、普通水位計等により測定した水位） |
| > （2-3-1）                                                          |
|                                                                      |
| 図2-3-1によると、河床勾配が大きいほどばらつきが大き                  |
| く、またほぼ同一勾配の河川の誤差の分布特性に注目すると、零を中心にし |
| て、正負同様にばらつく傾向となった。ただし、誤差の原因についてはまだ |
| 十分には把握されていないことから、図2-3-1はあくまで参考とされたい。  |
|                                                                      |
| 上記を踏まえて、急勾配河川等痕跡のばらつきが大きい河川               |
| では、縦断間隔を短く、多地点で洪水痕跡水位を測定することが望ましい。 |
|                                                                      |
| ![説明: 図6-24](media/image8.png){width="2.6770833333333335in"       |
| height="3.71875in"}                                                  |
|                                                                      |
| 2.  洪水痕跡水位に含まれる誤差と河床勾配との関係                     |
|                                                                      |
| 出典：河道特性に関する研究                                           |
| ，建設省河川局治水課・土木研究所，第42回建設省技術研究会報告，1988.  |
+----------------------------------------------------------------------+

1.  []{#_Toc97231233 .anchor}簡易水位観測

＜考え方＞

  -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  簡易水位観測は、精度を確保した長期的な統計資料として活用することを主目的とせず、概略的、緊急的、若しくは臨時的に、洪水時の特定の水理・水文状況等について個別具体に設定し、それに適した簡易的な方法・センサ等で観測することを指す。本章の第1節 総論 カテゴリー２やカテゴリー３の観測において有効となる。洪水時の避難判断等のために設置する危機管理型水位計や重要区間等で水位を密に把握するために設置するデータ発信機能付きのアドホック型水位計による観測は、その具体例である。
  -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

+----------------------------------------------------------------------+
| 河川におけ                                                           |
| る水位等の水文観測は、従来は主にカテゴリー１の用途で実施されてきた。 |
|                                                                      |
| これに対し、例えば危機管理型水                                       |
| 位計は、警戒避難体制の確保等の危機管理にも有効な洪水時の的確な予警報 |
| や早期避難に役立てることを目的としたカテゴリー２に属する水位観測であ |
| り、またその観測結果はカテゴリー３の観測に組み込むことも可能である。 |
|                                                                      |
| カテゴリー２や３の観測によって得られた水文資料について               |
| は、第２章５節「水文資料の整理・保存と品質管理」にあるとおり、出水を |
| 捉えたデータなど各種検討解析の必要に応じて、保存することが望ましい。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  危機管理型水位計設置の手引き（案），平成31年3月，国土交通省水管理・国土保全局
    河川計画課 河川情報企画室.

＜参考となる資料＞

カテゴリー２の活用事例として、流量の検討に当たって、危機管理型水位計やカメラ映像等を活用し、氾濫の影響を評価した例がある。

1.  第２回　令和２年７月球磨川豪雨検証委員　説明資料，令和2年10月6日，国土交通省九州地方整備局・熊本県．

**調査編**

5.  **水文・水理観測**

**第4節　流量観測**

**目　次**

[第4節 流量観測 1](#_Toc96357416)

> [4．1 総説 1](#_Toc96357417)
>
> [4．2 流量観測の方法 2](#_Toc96357418)
>
> [4．2．1 流量観測手法の分類 2](#_Toc96357419)
>
> [4．2．2 流量観測手法の選定 4](#_Toc96357420)
>
> [4．3 流量観測所の配置と設置 4](#_Toc96357421)
>
> [4．3．1 流量観測所の配置 4](#_Toc96357422)
>
> [4．3．2 流量観測所の設置場所の選定 5](#_Toc96357423)
>
> [4．3．3 観測施設が備えるべき設備 6](#_Toc96357424)
>
> [4．3．4 観測所の維持及び管理 9](#_Toc96357425)
>
> [4．4 観測 9](#_Toc96357426)
>
> [4．4．1 総説 9](#_Toc96357427)
>
> [4．4．2 観測回数 9](#_Toc96357428)
>
> [4．4．3 器材の管理 10](#_Toc96357429)
>
> [4．4．4 流速計の検定 10](#_Toc96357430)
>
> [4．4．5 観測心得の交付 11](#_Toc96357431)
>
> [4．4．6 精度確保のための留意事項 11](#_Toc96357432)
>
> [4．4．7 安全確保のための留意事項 12](#_Toc96357433)
>
> [4．4．8 野帳への記録と保管 12](#_Toc96357434)
>
> [4．5 可搬式流速計による流速計測法 12](#_Toc96357435)
>
> [4．5．1 総説 12](#_Toc96357436)
>
> [4．5．2 水理条件に対応した流速計の選定に当たっての留意事項
> 13](#_Toc96357437)
>
> [4．5．3 測定回数、測線と測点（標準法） 13](#_Toc96357438)
>
> [4．5．4 測定回数、測線と測点（精密法） 15](#_Toc96357439)
>
> [4．5．5 流量算出の手順 16](#_Toc96357440)
>
> [4．6 浮子による流速計測法（浮子測法） 17](#_Toc96357441)
>
> [4．6．1 総説 17](#_Toc96357442)
>
> [4．6．2 付帯施設 18](#_Toc96357443)
>
> [4．6．3 流速測線 18](#_Toc96357444)
>
> [4．6．4 浮子の種類 19](#_Toc96357445)
>
> [4．6．5 浮子による流速の測定 20](#_Toc96357446)
>
> [4．6．6 浮子測法による流量の算出 21](#_Toc96357447)
>
> [4．7 舟に搭載したADCP（超音波ドップラー流向流速計）による流速計測法
> 21](#_Toc96357448)
>
> [4．7．1 総説 21](#_Toc96357449)
>
> [4．7．2 流速分布計測の方法 22](#_Toc96357450)
>
> [4．7．3 流量の算出 24](#_Toc96357451)
>
> [4．8 非接触型流速計測法 24](#_Toc96357452)
>
> [4．8．1 総説 24](#_Toc96357453)
>
> [4．8．2 流速計の設置及び付帯施設 25](#_Toc96357454)
>
> [4．8．3 流量の算出 27](#_Toc96357455)
>
> [4．8．4 維持管理 28](#_Toc96357456)
>
> [4．9 超音波流速計測法（パルス伝播時間差法） 28](#_Toc96357457)
>
> [4．9．1 総説 28](#_Toc96357458)
>
> [4．9．2 超音波流速計測法による流速の測定 28](#_Toc96357459)
>
> [4．9．3 超音波流速計測法による流量の算出 29](#_Toc96357460)
>
> [4．9．4 維持管理 30](#_Toc96357461)
>
> [4．10 水理構造物を用いる方法 30](#_Toc96357462)
>
> [4．10．1 総説 30](#_Toc96357463)
>
> [4．10．2 堰測法の種類と配慮事項 31](#_Toc96357464)
>
> [4．10．3 可動ゲートを有する堰における要件 31](#_Toc96357465)
>
> [4．10．4 越流水深の測定 31](#_Toc96357466)
>
> [4．10．5 堰測法による流量の算出 32](#_Toc96357467)
>
> [4．11 流量の連続データの算出 32](#_Toc96357468)
>
> [4．11．1 総説 32](#_Toc96357469)
>
> [4．11．2 水位流量曲線の作成手法の基本 33](#_Toc96357470)
>
> [4．11．3 水位流量曲線の更新 34](#_Toc96357471)
>
> [4．11．4 曲線分離 35](#_Toc96357472)
>
> [4．12 特殊な場所における流量観測 35](#_Toc96357473)
>
> [4．12．1 結氷河川における留意事項 35](#_Toc96357474)
>
> [4．12．2 河口感潮域における留意事項 36](#_Toc96357475)

令和４年６月　版

適用上の位置付け

　河川砂防技術基準調査編は、基準の適用上の位置付けを明確にするために、下表に示すように適用上の位置付けを分類している。

+--------+------------------+------------------+------------------+
| 分　類 | 適用上の位置付け | 末尾の字句例     |                  |
+--------+------------------+------------------+------------------+
| 考え方 | 技術資料         | ●目              | 「･･･ある。      |
|        |                  | 的や概念、考え方 | 」「･･･いる。」  |
|        |                  | を記述した事項。 |                  |
|        |                  |                  | 「･･･なる。      |
|        |                  |                  | 」「･･･れる。」  |
+--------+------------------+------------------+------------------+
| 必　須 | 技術基準         | ●法令による規定  | 「･･･なければ    |
|        |                  | や技術的観点から | ならない。」「･  |
|        |                  | 実施すべきである | ･･ものとする。」 |
|        |                  | ことが明確であり |                  |
|        |                  | 遵守すべき事項。 |                  |
+--------+------------------+------------------+------------------+
| 標　準 | 技術基準         | ●特              | 「･･･            |
|        |                  | 段の事情がない限 | を標準とする。」 |
|        |                  | り記述に従い実施 |                  |
|        |                  | すべきだが、状況 | 「･･･            |
|        |                  | や条件によって一 | を基本とする。」 |
|        |                  | 律に適用すること |                  |
|        |                  | はできない事項。 | 「･･･による。」  |
+--------+------------------+------------------+------------------+
| 推　奨 | 技術資料         | ●状況や条件      | 「               |
|        |                  | によって実施する | ･･･望ましい。」  |
|        |                  | ことが良い事項。 |                  |
|        |                  |                  | 「               |
|        |                  |                  | ･･･推奨する。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･務める。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･必要に応    |
|        |                  |                  | じて･･･する。」  |
+--------+------------------+------------------+------------------+
| 例　示 | 技術資料         | ●適用条件や実施  | 「               |
|        |                  | 効果について確定 | ･･･などの手法（  |
|        |                  | している段階では | 事例）がある。」 |
|        |                  | ないが、状況や条 |                  |
|        |                  | 件によっては導入 | 「･･･など        |
|        |                  | することが可能な | の場合がある。」 |
|        |                  | 新技術等の例示。 |                  |
|        |                  |                  | 「･･･など        |
|        |                  | ●状              | が考えられる。」 |
|        |                  | 況や条件によって |                  |
|        |                  | 限定的に実施でき | 「               |
|        |                  | る技術等の例示。 | ･･･の場合には･･･ |
|        |                  |                  | ことができる。」 |
|        |                  | ●具体的          |                  |
|        |                  | に例示することに | 「               |
|        |                  | より、技術的な理 | ･･･例示する。」  |
|        |                  | 解を助ける事項。 |                  |
|        |                  |                  | 「例えば･･･。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･事例もある  |
|        |                  |                  | 。･･･もよい。」  |
+--------+------------------+------------------+------------------+

  関連通知等       関連する通知やそれを理解する上で参考となる資料
  ---------------- ------------------------------------------------------
  参考となる資料   例示等に示した手法・内容を理解する上で参考となる資料

1.  []{#_Toc96357416 .anchor}流量観測

    1.  []{#_Toc96357417 .anchor}総説

＜考え方＞

+----------------------------------------------------------------------+
| 本節は、                                                             |
| 河川での流量観測を実施するために必要な技術的事項を定めるものである。 |
|                                                                      |
| 河川流量は単位時間に河川のある横断                                   |
| 面を通過する水の量である（土砂の流送量については、第6章で扱う。）。  |
|                                                                      |
| 流量観測は、河                                                       |
| 川の計画・管理を適切に行うために、流域から河道への流出過程及び河道内 |
| の流下過程を把握することを目的としており、河川･砂防に関する計画の立  |
| 案、工事の実施、施設の維持管理、環境の整備及び保全、洪水や渇水等によ |
| る水災害への対応等を実施するための最も基本的な調査項目の一つである。 |
|                                                                      |
| 流量観測データの具体的な活用事例としては以下が挙げられる。           |
|                                                                      |
| > １）流域の主要な地点の流量の時間的変化を正確に把握し、実現象を精度 |
| よく再現できる水文流出モデル、並びに河道流下モデルの構築に活用する。 |
| >                                                                    |
| > ２）河道内の流れの状況を把握し、河床変動の傾向を把握し、           |
| 河床の局所洗掘や堆積を予測し、被災予防等効率的な河川管理に活用する。 |
| >                                                                    |
| > ３）水利権の見直し、正常流量の設定に活用する。                     |
| >                                                                    |
| > ４）ダム・堰等の流水制御施設の計画、施設の運用管理に活用する。     |
|                                                                      |
| 本節で主に扱うのは、本章の第1節 総説                                 |
| で説明した３つのカテゴリーのうちのカテゴリー１であり（表             |
| 2-1-1参照）、特に断らない限り、本節ではカテゴリー１の流量観測につい  |
| て述べている。このことから、本節で記述する基準は、特に断らない限り、 |
| 水文観測業務規程に基づき定常業務として実施する観測を前提としている。 |
|                                                                      |
| また流量は、カテゴリー                                               |
| ３.１、３.２にとって基本となる量であり、カテゴリー２においても対象と |
| なる可能性が高い。本節の内容は、それらのカテゴリーの観測手法の検討に |
| も役立つ情報を含むので、カテゴリー１に限定せず適宜参考にすると良い。 |
|                                                                      |
| 得られた流量観測値の照査やデータ整理・保存については、本章 第5節     |
| 水文資料の整理保存と品質管理 によるものとする。                      |
+----------------------------------------------------------------------+

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------
  河川・砂防に関する計画の立案、工事の実施、施設の維持管理、環境の整備及び保全、洪水や渇水等の水災害への対応等を実施するため、流量を観測することを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1.  水文観測業務規程，平成29年3月31日，国水情第44号，国土交通事務次官通達.

```{=html}
<!-- -->
```
37. 水文観測業務規程細則，平成29年3月31日，国水情第45号，国土交通省水管理・国土保全局通達.

＜参考となる資料＞

得られた流量観測値の照査やデータ整理・保存については、本章 第5節
水文資料の整理・保存と品質管理 を参照のこと。
本節に規定していない流量観測の詳細な要領及び国際的な流量観測技術基準との関係については、下記の資料が参考となる。

1.  国土交通省監修，(独)土木研究所編著：水文観測，全日本建設技術協会，2002.

```{=html}
<!-- -->
```
38. 国土交通省中部地方建設局河川部河川調整課：絵で見る水文観測，(一社)中部地域づくり協会，2001.

39. WMO：Guide to Hydrological Practice，2008.

40. ISO748 Hydrometry---Measurement of liquid flow in open channels
    using current- meters or floats，2007.

    1.  []{#_Toc96357418 .anchor}流量観測の方法

        1.  []{#_Toc96357419 .anchor}流量観測手法の分類

＜考え方＞

+----------------------------------------------------------------------+
| 流量観測手法は、次の３つの方法に大別される。                         |
|                                                                      |
| > １）河                                                             |
| 川横断面において、流速計測値と、水位観測等により求めた断面積値から、 |
| （流速）×（面積）の計算を行って流量を算出する方法（流速断面積法）。  |
| >                                                                    |
| > ２）                                                               |
| 堰等の水理構造物において、適切な位置において水深を計測（若しくは水位 |
| 観測結果より算定）し、越流公式等から流量を求める方法（水理構造物法） |
| >                                                                    |
| > ３）洪水痕跡水位等を含む水位観測結果を利用し、開                   |
| 水路流れとしての水理学的知見に基づき流量を算出する方法（間接計測法） |
|                                                                      |
| 本節では、主に、上記のうち、１）と２）による観測法を取り上げる。     |
|                                                                      |
| ３）の水位観測結果を利用した流量を求める方法は、本章 第1節 総説      |
| で説明したカテゴリー３.１（表2-1                                     |
| -1参照）の観測から流量の解析を行う方法に属する。これについては、本章 |
| 第7節 河川の流れの総合的把握 によるものとする。                      |
|                                                                      |
| なお、洪水時の流量観測は１）の手法のうち                             |
| 人力による浮子測法を用いる事が一般的だが、大規模洪水時等には様々な制 |
| 約により観測できない場合があることから、センサや非接触型を用いた無人 |
| 観測や、３）の間接計測法の活用に向けた取組を進めることが重要である。 |
+----------------------------------------------------------------------+

＜例　示＞

+----------------------------------------------------------------------+
| 国内外で提案されている流量観測手法の主                               |
| な例を表2-4-1に例示する。手法の特性を踏まえて、また、当該観測が本章  |
| 第1節 総説                                                           |
| に述べた３つの                                                       |
| カテゴリーのどれに当たるかに応じて、観測手法の選定を行う必要がある。 |
|                                                                      |
| なお、ここで固定式観測法とは、一定地点に無人・自動での連続観測       |
| が可能なセンサを流量観測地点のしかるべき場所に固定設置して観測する設 |
| 置型の観測手法を指す。一方、非固定式観測法とは、観測作業を実施する日 |
| 時に、個別に流量観測地点にて可搬型のセンサ等を活用して随時に観測する |
| 手法を指している。我が国における流量観測手法として広く知られている、 |
| 低水時の可搬型流速計を用いた流速計測法や、高水時の浮子測法は、後者の |
| 非固定式観測法に分類される。したがって、非固定式流量観測法を用いる場 |
| 合は、得られる流量観測データは、その観測作業を現地において実施した日 |
| 時の値のみである。水文統計資料として任意の日時における連続的な流量観 |
| 測データを収集する必要がある場合は、固定式流量観測法を用いるか、水位 |
| 流量曲線法と組み合わせるかのいずれかの方法を一般に用いる必要がある。 |
|                                                                      |
| 2.  主要な流量観測手法の種類                                         |
|                                                                      |
| +--------+--------+--------+--------+--------+--------+--------+     |
| | 分類   | 名称   | 直接   | 説明   |        |        |        |     |
| |        |        | の　測 |        |        |        |        |     |
| |        |        | 定対象 |        |        |        |        |     |
| +========+========+========+========+========+========+========+     |
| | 流速断 | トレー | > 非   | 浮     | 吃水   | 直     |        |     |
| | 面積法 | サによ | 固定式 | 子測法 | 部平均 | 線上に |        |     |
| |        | る流速 | 観測法 |        | 　流速 | 一定の |        |     |
| |        | 計測法 |        |        |        | 区間を |        |     |
| |        |        |        |        |        | 定め、 |        |     |
| |        |        |        |        |        | 浮子を |        |     |
| |        |        |        |        |        | その区 |        |     |
| |        |        |        |        |        | 間の上 |        |     |
| |        |        |        |        |        | 流から |        |     |
| |        |        |        |        |        | 流し、 |        |     |
| |        |        |        |        |        | その下 |        |     |
| |        |        |        |        |        | 流まで |        |     |
| |        |        |        |        |        | の距離 |        |     |
| |        |        |        |        |        | を流下 |        |     |
| |        |        |        |        |        | 時間で |        |     |
| |        |        |        |        |        | 除して |        |     |
| |        |        |        |        |        | 流速を |        |     |
| |        |        |        |        |        | 求める |        |     |
| |        |        |        |        |        | 方法で |        |     |
| |        |        |        |        |        | ある。 |        |     |
| +--------+--------+--------+--------+--------+--------+--------+     |
| |        |        |        | 色     | ある　 | 水深   |        |     |
| |        |        |        | 素投入 | 代表的 | が浅く |        |     |
| |        |        |        | 法・希 | な流速 | 表面浮 |        |     |
| |        |        |        | 釈法等 |        | 子が使 |        |     |
| |        |        |        |        |        | 用でき |        |     |
| |        |        |        |        |        | ない場 |        |     |
| |        |        |        |        |        | 合等に |        |     |
| |        |        |        |        |        | 、フル |        |     |
| |        |        |        |        |        | オレッ |        |     |
| |        |        |        |        |        | セン等 |        |     |
| |        |        |        |        |        | の色素 |        |     |
| |        |        |        |        |        | や化学 |        |     |
| |        |        |        |        |        | 物質を |        |     |
| |        |        |        |        |        | 投入し |        |     |
| |        |        |        |        |        | て代表 |        |     |
| |        |        |        |        |        | 的な流 |        |     |
| |        |        |        |        |        | 速を測 |        |     |
| |        |        |        |        |        | 定する |        |     |
| |        |        |        |        |        | 方法で |        |     |
| |        |        |        |        |        | ある。 |        |     |
| +--------+--------+--------+--------+--------+--------+--------+     |
| |        | 流水   | 可搬式 |        | 回転   | 横断面 | 回転   |     |
| |        | にセン | 流速計 |        | 式流速 | 内点流 | する測 |     |
| |        | サを接 |        |        | 計測法 | 速分布 | 定部を |     |
| |        | 触させ |        |        |        |        | 流水中 |     |
| |        | る流速 |        |        |        |        | に水没 |     |
| |        | 計測法 |        |        |        |        | させ、 |     |
| |        |        |        |        |        |        | その回 |     |
| |        |        |        |        |        |        | 転数か |     |
| |        |        |        |        |        |        | ら流速 |     |
| |        |        |        |        |        |        | を測定 |     |
| |        |        |        |        |        |        | する方 |     |
| |        |        |        |        |        |        | 法であ |     |
| |        |        |        |        |        |        | る。水 |     |
| |        |        |        |        |        |        | 車やプ |     |
| |        |        |        |        |        |        | ロペラ |     |
| |        |        |        |        |        |        | を回転 |     |
| |        |        |        |        |        |        | 部に持 |     |
| |        |        |        |        |        |        | つ横軸 |     |
| |        |        |        |        |        |        | 型(広  |     |
| |        |        |        |        |        |        | 井式流 |     |
| |        |        |        |        |        |        | 速計等 |     |
| |        |        |        |        |        |        | )と円  |     |
| |        |        |        |        |        |        | すい型 |     |
| |        |        |        |        |        |        | のカッ |     |
| |        |        |        |        |        |        | プを回 |     |
| |        |        |        |        |        |        | 転部に |     |
| |        |        |        |        |        |        | 持つ縦 |     |
| |        |        |        |        |        |        | 軸型(  |     |
| |        |        |        |        |        |        | プライ |     |
| |        |        |        |        |        |        | ス流速 |     |
| |        |        |        |        |        |        | 計)に  |     |
| |        |        |        |        |        |        | 分類さ |     |
| |        |        |        |        |        |        | れる。 |     |
| +--------+--------+--------+--------+--------+--------+--------+     |
| |        |        |        |        | 可     |        | 水     |     |
| |        |        |        |        | 搬式電 |        | 中に電 |     |
| |        |        |        |        | 磁流速 |        | 磁式の |     |
| |        |        |        |        | 計測法 |        | 測定部 |     |
| |        |        |        |        |        |        | を持つ |     |
| |        |        |        |        |        |        | 流速計 |     |
| |        |        |        |        |        |        | で、人 |     |
| |        |        |        |        |        |        | 工的に |     |
| |        |        |        |        |        |        | 発生さ |     |
| |        |        |        |        |        |        | せた磁 |     |
| |        |        |        |        |        |        | 界の中 |     |
| |        |        |        |        |        |        | を水が |     |
| |        |        |        |        |        |        | 動くと |     |
| |        |        |        |        |        |        | きに生 |     |
| |        |        |        |        |        |        | じる起 |     |
| |        |        |        |        |        |        | 電圧か |     |
| |        |        |        |        |        |        | ら流速 |     |
| |        |        |        |        |        |        | を測定 |     |
| |        |        |        |        |        |        | する。 |     |
| +--------+--------+--------+--------+--------+--------+--------+     |
| |        |        | 船搭載 |        | ADC    | 横断   | 超音   |     |
| |        |        |        |        | P(超音 | 面内流 | 波のド |     |
| |        |        |        |        | 波ドッ | 速分布 | ップラ |     |
| |        |        |        |        | プラー |        | ー効果 |     |
| |        |        |        |        | 流向流 |        | を応用 |     |
| |        |        |        |        | 速計)  |        | するこ |     |
| |        |        |        |        | 計測法 |        | とによ |     |
| |        |        |        |        |        |        | って、 |     |
| |        |        |        |        |        |        | 断面内 |     |
| |        |        |        |        |        |        | の三次 |     |
| |        |        |        |        |        |        | 元流向 |     |
| |        |        |        |        |        |        | ・流速 |     |
| |        |        |        |        |        |        | 分布を |     |
| |        |        |        |        |        |        | 測定す |     |
| |        |        |        |        |        |        | る機器 |     |
| |        |        |        |        |        |        | である |     |
| |        |        |        |        |        |        | 。この |     |
| |        |        |        |        |        |        | 測定器 |     |
| |        |        |        |        |        |        | を橋上 |     |
| |        |        |        |        |        |        | 係留船 |     |
| |        |        |        |        |        |        | 等に搭 |     |
| |        |        |        |        |        |        | 載し、 |     |
| |        |        |        |        |        |        | 移動し |     |
| |        |        |        |        |        |        | ながら |     |
| |        |        |        |        |        |        | 測定す |     |
| |        |        |        |        |        |        | ること |     |
| |        |        |        |        |        |        | によっ |     |
| |        |        |        |        |        |        | て大水 |     |
| |        |        |        |        |        |        | 面、大 |     |
| |        |        |        |        |        |        | 水深領 |     |
| |        |        |        |        |        |        | 域の通 |     |
| |        |        |        |        |        |        | 過断面 |     |
| |        |        |        |        |        |        | 内流量 |     |
| |        |        |        |        |        |        | を短時 |     |
| |        |        |        |        |        |        | 間で測 |     |
| |        |        |        |        |        |        | 定でき |     |
| |        |        |        |        |        |        | る。ま |     |
| |        |        |        |        |        |        | た、河 |     |
| |        |        |        |        |        |        | 床等に |     |
| |        |        |        |        |        |        | 固定し |     |
| |        |        |        |        |        |        | た場合 |     |
| |        |        |        |        |        |        | は、流 |     |
| |        |        |        |        |        |        | 速分布 |     |
| |        |        |        |        |        |        | の時間 |     |
| |        |        |        |        |        |        | 変化を |     |
| |        |        |        |        |        |        | 測定で |     |
| |        |        |        |        |        |        | きる。 |     |
| +--------+--------+--------+--------+--------+--------+--------+     |
| |        |        | 水中   | >      | 超     | 代表深 | 超音波 |     |
| |        |        | 　固定 | 固定式 | 音波流 | さにお | の伝播 |     |
| |        |        |        | 観測法 | 速計測 | ける平 | 速度が |     |
| |        |        |        | >      | 法(パ  | 均流速 | 流れの |     |
| |        |        |        | >      | ルス伝 |        | 方向で |     |
| |        |        |        | 連続観 | 播時間 |        | は増加 |     |
| |        |        |        | 測可能 | 差法)  |        | し、流 |     |
| |        |        |        |        |        |        | れと逆 |     |
| |        |        |        |        |        |        | 方向に |     |
| |        |        |        |        |        |        | は減少 |     |
| |        |        |        |        |        |        | するこ |     |
| |        |        |        |        |        |        | とを利 |     |
| |        |        |        |        |        |        | 用して |     |
| |        |        |        |        |        |        | 、その |     |
| |        |        |        |        |        |        | 差を測 |     |
| |        |        |        |        |        |        | 定して |     |
| |        |        |        |        |        |        | 流速を |     |
| |        |        |        |        |        |        | 求める |     |
| |        |        |        |        |        |        | もので |     |
| |        |        |        |        |        |        | ある。 |     |
| |        |        |        |        |        |        | 送受信 |     |
| |        |        |        |        |        |        | 装置を |     |
| |        |        |        |        |        |        | 測定箇 |     |
| |        |        |        |        |        |        | 所の両 |     |
| |        |        |        |        |        |        | 岸に設 |     |
| |        |        |        |        |        |        | 置し、 |     |
| |        |        |        |        |        |        | 水中に |     |
| |        |        |        |        |        |        | 送波し |     |
| |        |        |        |        |        |        | て測定 |     |
| |        |        |        |        |        |        | する。 |     |
| +--------+--------+--------+--------+--------+--------+--------+     |
| |        |        |        |        | H-     |        | AD     |     |
| |        |        |        |        | ADCP法 |        | CPを水 |     |
| |        |        |        |        |        |        | 平方向 |     |
| |        |        |        |        |        |        | に設置 |     |
| |        |        |        |        |        |        | し、横 |     |
| |        |        |        |        |        |        | 断方向 |     |
| |        |        |        |        |        |        | の流速 |     |
| |        |        |        |        |        |        | 分布を |     |
| |        |        |        |        |        |        | 超音波 |     |
| |        |        |        |        |        |        | の反射 |     |
| |        |        |        |        |        |        | 波にお |     |
| |        |        |        |        |        |        | けるド |     |
| |        |        |        |        |        |        | ップラ |     |
| |        |        |        |        |        |        | ー効果 |     |
| |        |        |        |        |        |        | から測 |     |
| |        |        |        |        |        |        | 定する |     |
| |        |        |        |        |        |        | 。中小 |     |
| |        |        |        |        |        |        | 河川で |     |
| |        |        |        |        |        |        | あれば |     |
| |        |        |        |        |        |        | 、片岸 |     |
| |        |        |        |        |        |        | のセン |     |
| |        |        |        |        |        |        | サだけ |     |
| |        |        |        |        |        |        | で測定 |     |
| |        |        |        |        |        |        | システ |     |
| |        |        |        |        |        |        | ムを構 |     |
| |        |        |        |        |        |        | 成する |     |
| |        |        |        |        |        |        | ことが |     |
| |        |        |        |        |        |        | 可能。 |     |
| +--------+--------+--------+--------+--------+--------+--------+     |
| |        |        |        |        | 開     | 断面平 | 両     |     |
| |        |        |        |        | 水路電 | 均流速 | 岸に設 |     |
| |        |        |        |        | 磁流量 |        | 置した |     |
| |        |        |        |        | 計測法 |        | 電極間 |     |
| |        |        |        |        |        |        | に生じ |     |
| |        |        |        |        |        |        | る起電 |     |
| |        |        |        |        |        |        | 力が断 |     |
| |        |        |        |        |        |        | 面平均 |     |
| |        |        |        |        |        |        | 流速に |     |
| |        |        |        |        |        |        | 比例す |     |
| |        |        |        |        |        |        | る原理 |     |
| |        |        |        |        |        |        | により |     |
| |        |        |        |        |        |        | 流量を |     |
| |        |        |        |        |        |        | 算出す |     |
| |        |        |        |        |        |        | るシス |     |
| |        |        |        |        |        |        | テムで |     |
| |        |        |        |        |        |        | ある。 |     |
| +--------+--------+--------+--------+--------+--------+--------+     |
| |        | 非     |        | ド     | 表面   | 流     |        |     |
| |        | 接触型 |        | ップラ | 　流速 | れの表 |        |     |
| |        | 　流速 |        | ー型(  |        | 面に橋 |        |     |
| |        | 計測法 |        | 電波式 |        | 桁等に |        |     |
| |        |        |        | 、超音 |        | 設置し |        |     |
| |        |        |        | 波式)  |        | たセン |        |     |
| |        |        |        |        |        | サから |        |     |
| |        |        |        |        |        | 電波も |        |     |
| |        |        |        |        |        | しくは |        |     |
| |        |        |        |        |        | 超音波 |        |     |
| |        |        |        |        |        | をある |        |     |
| |        |        |        |        |        | 俯角を |        |     |
| |        |        |        |        |        | もって |        |     |
| |        |        |        |        |        | 水面に |        |     |
| |        |        |        |        |        | 向けて |        |     |
| |        |        |        |        |        | 発射し |        |     |
| |        |        |        |        |        | 、その |        |     |
| |        |        |        |        |        | 反射波 |        |     |
| |        |        |        |        |        | の周波 |        |     |
| |        |        |        |        |        | 数変化 |        |     |
| |        |        |        |        |        | から表 |        |     |
| |        |        |        |        |        | 面流速 |        |     |
| |        |        |        |        |        | を測定 |        |     |
| |        |        |        |        |        | するシ |        |     |
| |        |        |        |        |        | ステム |        |     |
| |        |        |        |        |        | である |        |     |
| |        |        |        |        |        | 。現状 |        |     |
| |        |        |        |        |        | では、 |        |     |
| |        |        |        |        |        | 流速が |        |     |
| |        |        |        |        |        | 約0.5m |        |     |
| |        |        |        |        |        | /s以上 |        |     |
| |        |        |        |        |        | の流量 |        |     |
| |        |        |        |        |        | 観測の |        |     |
| |        |        |        |        |        | みに利 |        |     |
| |        |        |        |        |        | 用可能 |        |     |
| +--------+--------+--------+--------+--------+--------+--------+     |
| |        |        |        | 画像   |        | 洪     |        |     |
| |        |        |        | 処理型 |        | 水時に |        |     |
| |        |        |        | (PIV法 |        | 流況を |        |     |
| |        |        |        | 、STI  |        | ビデオ |        |     |
| |        |        |        | V法等) |        | カメラ |        |     |
| |        |        |        |        |        | 等で撮 |        |     |
| |        |        |        |        |        | 影した |        |     |
| |        |        |        |        |        | 映像を |        |     |
| |        |        |        |        |        | 用いて |        |     |
| |        |        |        |        |        | 、画像 |        |     |
| |        |        |        |        |        | 解析手 |        |     |
| |        |        |        |        |        | 法によ |        |     |
| |        |        |        |        |        | り流速 |        |     |
| |        |        |        |        |        | を計測 |        |     |
| |        |        |        |        |        | する手 |        |     |
| |        |        |        |        |        | 法であ |        |     |
| |        |        |        |        |        | る。流 |        |     |
| |        |        |        |        |        | 下する |        |     |
| |        |        |        |        |        | ゴミ、 |        |     |
| |        |        |        |        |        | 波紋等 |        |     |
| |        |        |        |        |        | を河岸 |        |     |
| |        |        |        |        |        | から撮 |        |     |
| |        |        |        |        |        | 影、画 |        |     |
| |        |        |        |        |        | 像解析 |        |     |
| |        |        |        |        |        | するP  |        |     |
| |        |        |        |        |        | IV法や |        |     |
| |        |        |        |        |        | 、動画 |        |     |
| |        |        |        |        |        | から得 |        |     |
| |        |        |        |        |        | られる |        |     |
| |        |        |        |        |        | 連続し |        |     |
| |        |        |        |        |        | た静止 |        |     |
| |        |        |        |        |        | 画を用 |        |     |
| |        |        |        |        |        | いて輝 |        |     |
| |        |        |        |        |        | 度値等 |        |     |
| |        |        |        |        |        | を時間 |        |     |
| |        |        |        |        |        | 軸方向 |        |     |
| |        |        |        |        |        | に積み |        |     |
| |        |        |        |        |        | 重ねた |        |     |
| |        |        |        |        |        | 時空間 |        |     |
| |        |        |        |        |        | 画像に |        |     |
| |        |        |        |        |        | 生じる |        |     |
| |        |        |        |        |        | 縞パタ |        |     |
| |        |        |        |        |        | ーンか |        |     |
| |        |        |        |        |        | ら水表 |        |     |
| |        |        |        |        |        | 面流速 |        |     |
| |        |        |        |        |        | を求め |        |     |
| |        |        |        |        |        | るSTIV |        |     |
| |        |        |        |        |        | 法等が |        |     |
| |        |        |        |        |        | ある。 |        |     |
| +--------+--------+--------+--------+--------+--------+--------+     |
| | 水理構 |        | 堰     | 水深   | 三     |        |        |     |
| | 造物法 |        | 測法等 |        | 角堰や |        |        |     |
| |        |        |        |        | 台形堰 |        |        |     |
| |        |        |        |        | を自由 |        |        |     |
| |        |        |        |        | 越流す |        |        |     |
| |        |        |        |        | る際の |        |        |     |
| |        |        |        |        | 越流水 |        |        |     |
| |        |        |        |        | 深を測 |        |        |     |
| |        |        |        |        | 定し、 |        |        |     |
| |        |        |        |        | 実験等 |        |        |     |
| |        |        |        |        | により |        |        |     |
| |        |        |        |        | 求めら |        |        |     |
| |        |        |        |        | れた流 |        |        |     |
| |        |        |        |        | 量公式 |        |        |     |
| |        |        |        |        | により |        |        |     |
| |        |        |        |        | 流量換 |        |        |     |
| |        |        |        |        | 算する |        |        |     |
| |        |        |        |        | 方法で |        |        |     |
| |        |        |        |        | ある。 |        |        |     |
| +--------+--------+--------+--------+--------+--------+--------+     |
| | 間接   | > 非   | 水面   | 水位   | 河川   |        |        |     |
| | 計測法 | 固定式 | 勾配断 |        | 断面の |        |        |     |
| |        | 観測法 | 面積法 |        | 粗度を |        |        |     |
| |        |        |        |        | 仮定し |        |        |     |
| |        |        |        |        | 、洪水 |        |        |     |
| |        |        |        |        | 痕跡等 |        |        |     |
| |        |        |        |        | から推 |        |        |     |
| |        |        |        |        | 定され |        |        |     |
| |        |        |        |        | る水位 |        |        |     |
| |        |        |        |        | 、水面 |        |        |     |
| |        |        |        |        | 勾配か |        |        |     |
| |        |        |        |        | ら流量 |        |        |     |
| |        |        |        |        | を算出 |        |        |     |
| |        |        |        |        | する方 |        |        |     |
| |        |        |        |        | 法であ |        |        |     |
| |        |        |        |        | る。洪 |        |        |     |
| |        |        |        |        | 水痕跡 |        |        |     |
| |        |        |        |        | 水位に |        |        |     |
| |        |        |        |        | ついて |        |        |     |
| |        |        |        |        | は本章 |        |        |     |
| |        |        |        |        | 第3節  |        |        |     |
| |        |        |        |        | 水     |        |        |     |
| |        |        |        |        | 位観測 |        |        |     |
| |        |        |        |        | 3.9が  |        |        |     |
| |        |        |        |        | 参考に |        |        |     |
| |        |        |        |        | なる。 |        |        |     |
| +--------+--------+--------+--------+--------+--------+--------+     |
|                                                                      |
| ※                                                                    |
| 観測                                                                 |
| 中や観測現場への移動中の観測員の安全確保など、浮子測法の適用に課題を |
| 抱えた観測所で、改善のために非接触型流速計測法が用いられた例がある。 |
|                                                                      |
| ※                                                                    |
| 非接触型流速計測法は、センサを橋桁等に固                             |
| 定設置することで固定式流量観測法として利用するのが一般的であるが、可 |
| 搬型の非接触型センサ（小型電波流速計やビデオカメラ）を橋上等に仮設置 |
| して用いる場合は、非固定式流量観測法として利用することも可能である。 |
|                                                                      |
| ※                                                                    |
| 表2-4                                                                |
| -1に記載していない水位流量曲線法は、様々な水位における上記の手法によ |
| る流量観測値を収集することで、流量の連続評価を行うための関係式を作成 |
| するものであり、上記に挙げた流量観測法（特に非固定式観測法）に依存し |
| て成立する方法である。このことから、流量観測法としては挙げていない。 |
|                                                                      |
| ※                                                                    |
| 間接計測法の一つである                                               |
| 「水面勾配断面積法」は、最も単純な手法として例示している。なお、本章 |
| 第1節 総説                                                           |
| で説明したカテゴリー                                                 |
| ３.１（表2-1-1参照）の観測の中で、多地点の水位連続観測による対象河川 |
| 区間の水理システムの把握により、流量の他、河床の変動等の洪水中の河道 |
| の諸元など、より多くの情報を得ることも行われる。これについては、本章 |
| 第7節 河川の流れの総合的把握 によるものとする。                      |
|                                                                      |
| ※                                                                    |
| 各点の流速計測値に代表させる区分断面ごとの区分流量                   |
| を単純にそのまま足し合わせるのではなく、それらの計測値群が満足すべき |
| 水理学的条件を同時に考慮して流量を算出する方法も近年提案されている。 |
|                                                                      |
| ※                                                                    |
| 表面流速を測定対象とする手法として、洪水時航空測量により、計測原     |
| 理としてカメロン効果を用いるなどしてスナップショット的に表面流速を計 |
| 測する技術がある。洪水流の特性を面的に広域に把握する上で有用である。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

ここに紹介した各種の観測・解析手法の概要については、下記の資料が参考となる。

1.  国土交通省監修，(独)土木研究所編著：水文観測，pp.376 第4章
    流量観測，全日本建設技術協会，2002.

```{=html}
<!-- -->
```
41. Herschy：Hydrometry -- Principles and Practices (2nd ed.)，John
    Wiley & Sons，p.376 ，1999.

42. 木下良作：航空写真による洪水流解析の現状と今後の課題，土木学会論文集，No.345
    II-1，pp.1-19，1984.

43. 二瓶泰雄，木水啓：H-ADCP観測と河川流計算を融合した新しい河川流量モニタリングシステムの構築，土木学会論文集B，Vol.63
    No.4，pp.295-310，2007.

44. 非接触型流速計測法の手引き（試行版），平成30年3月，国土交通省水管理・国土保全局
    河川計画課河川情報企画室．

    （最新版）非接触型流速計測法の手引き（案），令和5年3月，国土交通省水管理・国土保全局
    河川計画課河川情報企画室．

    1.  []{#_Toc96357420 .anchor}流量観測手法の選定

＜必　須＞

  -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  流量観測手法を選定するに当たっては、流量観測所の設置目的、設置条件、流量規模、必要精度、観測頻度を勘案して、前項に挙げた各種方法の現時点での精度・信頼性・適用範囲・労力やコスト等の特性を踏まえ適切な手法を選択若しくは組み合わせることで流量観測を実施するものとする（本章 第4節 流量観測 4.5～4.10も参照）。
  -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

1.  []{#_Toc96357421 .anchor}流量観測所の配置と設置

    1.  []{#_Toc96357422 .anchor}流量観測所の配置

＜必　須＞

  -----------------------------------------------------------------------------------------------------------------
  河川等の計画・管理上重要な地点に、必要に応じて、カテゴリー1の流量観測のための流量観測所を設けなければならない。
  -----------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 流量観測所は、低水から高                                             |
| 水に至るまで連続的に流量を把握できる地点に設置することを標準とする。 |
|                                                                      |
| しかし、流量観測所の設置目的を                                       |
| 低水計画・管理又は高水計画・管理に特化する場合は、その限りではない。 |
+----------------------------------------------------------------------+

＜例　示＞

+----------------------------------------------------------------------+
| 流量観測を行う地点には、以下に示すような地点が考えられる。           |
|                                                                      |
| > １）管理区間最上流端付近（本川・支川）                             |
| >                                                                    |
| > ２）重要支川の合流後及び同支川の下流端（背水区間を除く）           |
| >                                                                    |
| > ３）重要派川の分流前後                                             |
| >                                                                    |
| > ４）遊水地、湖沼、貯水池の流出口、若しくはその下流地点             |
| >                                                                    |
| > ５）流水制御施設の上下流、伏没・還元                               |
| 、適正な取水の把握、正常流量の設定等、水収支を把握する必要のある地点 |
| >                                                                    |
| > ６）水面勾配や河道幅・セグメント等の河道条件が変化する地点の前後   |
+----------------------------------------------------------------------+

2.  []{#_Toc96357423 .anchor}流量観測所の設置場所の選定

＜標　準＞

+----------------------------------------------------------------------+
| 観測                                                                 |
| 所は、次の１）～５）の条件を満足する場所に設置することを標準とする。 |
|                                                                      |
| １) 水位観測施設が設置できる場所                                     |
|                                                                      |
| ２) 流量観測を安定して行うことができる以下の場所                     |
|                                                                      |
| > a） 流路や河床の変動が少ない場所                                   |
| >                                                                    |
| > b） 流れに瀬や淵の部分がなく、みお筋が安定している場所             |
| >                                                                    |
| > c） 対岸及び観測断面周辺の見通しが良い場所                         |
| >                                                                    |
| > d）                                                                |
| >                                                                    |
| 低水流量観測及び高水流量観測が同一場所若しくはなるべく近い場所で実施 |
| できる場所（低水又は高水のいずれかの観測目的に特化した観測所を除く） |
|                                                                      |
| 浮子測法を用いる観測所では、更に以下の                               |
| e）～h）の条件を満たす場所とする。                                   |
|                                                                      |
| > e） 浮子の流下時間を測定する直線区間が必要な距離以上確保できる場所 |
| >                                                                    |
| > f） 洪水中の水平方向・鉛直方向の流速分布に大きな変化がない場所     |
| >                                                                    |
| > g）                                                                |
| > 浮子投下施設を設置で                                               |
| きる場所。又は、浮子を必要な測線に安全・確実に投下できる橋がある場所 |
| >                                                                    |
| > h） 流れを阻害する立木・構造物等がない場所                         |
| >                                                                    |
| > 電波流速計を用いる観測所では、以下の                               |
| > i)～l)の条件を満たす場所とする。                                   |
| >                                                                    |
| > i）                                                                |
| > センサ                                                             |
| 面からの対水面間距離、対象洪水時の水表面流速等が機器の仕様、計測範囲 |
| 内であり、水面が波立つ等電波が確実にセンサに反射され測定できること。 |
| >                                                                    |
| > j）                                                                |
| > 電波流速計の                                                       |
| 電波照射範囲に護岸、岩、河床、樹木やその枝葉等、流水以外がないこと。 |
| >                                                                    |
| > k）                                                                |
| > 河道の湾曲や橋脚などの影響により大                                 |
| きく流速が異なる水域や渦を巻くような流れ等にならない場所であること。 |
| >                                                                    |
| > l） 流速計測箇所の横断形状と当該箇所の水位観測値を得られること。   |
| >                                                                    |
| > 画像処理型流速測定法を用いる観測所では、以下                       |
| > m）からo）の条件を満たす場所とする。                               |
| >                                                                    |
| > m）                                                                |
| > 流速計測箇                                                         |
| 所近傍の水位（洪水時）や横断測量（洪水前後）成果が取得しやすいこと。 |
| >                                                                    |
| > n）                                                                |
| > 流速計測範囲において画像解析に必要                                 |
| となる情報（STIV法における水表面の波紋、Float-PTV法におけるトレーサ  |
| の視認、標定点など）を撮影できる画角が設定可能な撮影箇所であること。 |
| >                                                                    |
| > o）                                                                |
| >                                                                    |
| 渦を巻くような流れや偏流、橋脚等の構造物の影響がない位置であること。 |
|                                                                      |
| ３) 観測所の維持管理がしやすい場所                                   |
|                                                                      |
| ４) 観測作業を実施するに当たって危険が少なく安全である場所           |
|                                                                      |
| ５) その他                                                           |
|                                                                      |
| > a）                                                                |
| > 水位流量曲線法により流量の                                         |
| 連続評価を行う観測所の場合は、大河川との合流点や堰等の水位制御施設の |
| 直上流点や感潮区間等、下流水位の影響を受ける地点は避けるべきである。 |
| >                                                                    |
| > b）                                                                |
| > 固定式観測法（水理構造物による方                                   |
| 法を除く）を採用する観測所においては、非固定式観測法による観測値との |
| 同時刻流量の比較を実施することによる校正・検証作業が一般に必要となる |
| ことから、固定式観測法（水理構造物による方法を除く）を採用する場所は |
| 、原則として、校正用に観測する非固定式観測法が適用可能な場所とする。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

流量観測所の配置・設置の詳細については、下記の資料が参考となる。

1.  国土交通省監修，(独)土木研究所編著：水文観測，第4章 流量観測 4・2
    観測所の配置と位置選定，全日本建設技術協会，2002.

```{=html}
<!-- -->
```
45. 非接触型流速計測法の手引き（試行版），平成30年3月，国土交通省水管理・国土保全局
    河川計画課河川情報企画室．

    （最新版）非接触型流速計測法の手引き（案），令和5年3月，国土交通省水管理・国土保全局
    河川計画課河川情報企画室．

    1.  []{#_Toc96357424 .anchor}観測施設が備えるべき設備

```{=html}
<!-- -->
```
1.  総説

＜必　須＞

+----------------------------------------------------+
| 流量観測所には以下の設備を設置しなければならない。 |
|                                                    |
| > １) 水位観測施設                                 |
| >                                                  |
| > ２) 観測断面を指定する流量観測所横断線拠標       |
| >                                                  |
| > ３) 標識                                         |
| >                                                  |
| > ４) 流量観測に必要となる観測装置及び付帯設備     |
+----------------------------------------------------+

＜必　須＞

+----------------------------------------------------------------------+
| 流量観測に影響を与える                                               |
| 河川区間内では、整正な水流を確保することを目的として、立木伐採、除草 |
| 、障害物の除去、断面の保全等、必要な維持管理に努めなければならない。 |
|                                                                      |
| 浮子測法による場合、上記の区間は浮子投下断面                         |
| より50m程度上流から、第２見通し断面より50m程度下流までの範囲とする。 |
+----------------------------------------------------------------------+

16. 各観測方法における留意事項

＜必　須＞

+----------------------------------------------------------------------+
| 観測                                                                 |
| 方法によっては、以下の事項について、留意して設置しなければならない。 |
|                                                                      |
| > １）水位観測施設については、本章 第3節 水位観測 3.5                |
| > 水位観測所が備えるべき設備                                         |
| > に記載されている設備を設置しなければならない。                     |
| >                                                                    |
| > ２）                                                               |
| 流量観測所横断線拠標については、浮子測法による計測において、夜間でも |
| 照明等により見通すことのできる見通し杭として設置しなければならない。 |
| >                                                                    |
| > ３）                                                               |
| 固定式観測法を用いる場合には、観測装置を現地に設置する。恒久設置をす |
| る場合だけでなく、観測期間中のみの一時的な暫定設置をする場合もある。 |
| >                                                                    |
| > ４）非接触型流速計                                                 |
| 測法の場合には、付帯設備として、風向風速計も設置しなければならない。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

流量観測所の観測設備の詳細については、下記の資料が参考となる。

1.  国土交通省監修，(独)土木研究所編著：水文観測，第4章 流量観測 4･3
    可搬式流速計による流量観測（流速計測法） 4･4
    浮子による流量観測，全日本建設技術協会，2002.

```{=html}
<!-- -->
```
17. 流量観測所横断線

＜必　須＞

  ------------------------------------------------------------------------------------------------------------------------------
  流量観測所には、流心に直角の方向に流量観測所横断線を設定し、当該横断線の位置を示すために横断線拠標を設置しなければならない。
  ------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 横断線の数                                                           |
| 及び間隔は、観測の方法に応じて、次の表2-4-2によることを標準とする。  |
|                                                                      |
| 3.  横断線の数及び間隔と観測の方法                                   |
|                                                                      |
| ![](media/image9.emf){width="6.022916666666666in"                    |
| height="3.1037740594925634in"}                                       |
+----------------------------------------------------------------------+

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------
  流量観測所に設置する水位観測施設は、流量観測所横断線（２か所の場合は、流心に直角方向の測線のうちいずれか１か所の横断線）上に設置することを標準とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------

＜参考となる資料＞

流量観測所における横断線の設置に関する詳細については、下記の資料が参考となる。

1.  国土交通省監修，(独)土木研究所編著：水文観測，第4章 流量観測 4･3
    可搬式流速計による流量観測（流速計測法） 4･4
    浮子による流量観測，全日本建設技術協会，2002.

```{=html}
<!-- -->
```
18. 流量観測所横断線の横断測量

＜必　須＞

  ------------------------------------------------------------------------------------------------------------
  流量観測所横断線については、横断線ごとに横断測量を行い、流量観測所横断図面を作成しておかなければならない。
  ------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 流量観測所の                                                         |
| 横断図面は、出水期の前に行う横断測量により修正することを標準とする。 |
|                                                                      |
| 洪水等によって河床が変化したと認められる                             |
| 場合には、その都度速やかに横断測量を行い、同様に修正するものとする。 |
|                                                                      |
| 水理構造物を用いる方法の場合には、構造物                             |
| の変形や堆砂がない限り測量し直す必要はない。ただし、可動ゲートが設置 |
| された堰については、ゲートの開度を常に記録しておくことが必要である。 |
|                                                                      |
| なお、河川横断面の深浅測量の一般的な方法は、第22章 測量・計測        |
| によるものとする。                                                   |
+----------------------------------------------------------------------+

19. 標　識

＜必　須＞

+----------------------------------------------------------------------+
| 流量観測所の付近には観測所名、水系・                                 |
| 河川名、設置者名、設置年月日、観測所所在地、標高（水位標・零点高）、 |
| 河口からの距離又は支川おいては合流点よりの距離及び観測所番号を記した |
| 標識を立て、必要な場合には周囲に防護のための柵等を設けるものとする。 |
|                                                                      |
| 標識は水位流量観測所とし、水位観測所と分ける必要はない。             |
|                                                                      |
| 本章 第3節 水位観測 3.5.5 標識 を併せて参照するものとする。          |
+----------------------------------------------------------------------+

20. 台　帳

＜必　須＞

+----------------------------------------------------------------------+
| 流量観測所を設置し流量観測を行う者は、流量観測所台帳及び付図（流量観 |
| 測所横断線の断面における横断測量図を含む）を作成しなければならない。 |
|                                                                      |
| 流量観測所台                                                         |
| 帳には観測所の位置や施設構造等に関する諸元を記載しなければならない。 |
|                                                                      |
| 既存の流量観測所に流量観測を委嘱した場合にも同様とする。             |
|                                                                      |
| 流量                                                                 |
| 観測所には、流量観測所台帳及び付図の写しを備えつけなければならない。 |
|                                                                      |
| 本章 第3節 水位観測 3.6 観測所台帳 を併せて参照するものとする。      |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  水文観測業務規程細則，平成29年3月31日，国水情第45号，国土交通省水管理・国土保全局通達.

    1.  []{#_Toc96357425 .anchor}観測所の維持及び管理

＜必　須＞

+----------------------------------------------------------------------+
| 河川管                                                               |
| 理者は、観測所の維持及び管理の実施に際して「水文観測業務規程」第８章 |
| 観測所の維持及び管理、「水文観測業務規程細則」第８章                 |
| 観測所の維持管理等 に従わなければならない。                          |
|                                                                      |
| また、観測所ごとに点                                                 |
| 検や維持管理上必要な事項を記入した点検記録簿を備えなければならない。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  水文観測業務規程，平成29年3月31日，国水情第44号，国土交通事務次官通達，第8章
    観測所の維持及び管理.

```{=html}
<!-- -->
```
46. 水文観測業務規程細則，平成29年3月31日，国水情第45号，国土交通省水管理・国土保全局通達，第8章
    観測所の維持管理等.

47. 河川砂防技術基準維持管理編（河川編），平成27年3月3日，国水情20号，国土交通省水管理・国土保全局.

    （最新版）河川砂防技術基準維持管理編（河川編），令和3年10月，国土交通省水管理・国土保全局.

    1.  []{#_Toc96357426 .anchor}観測

        1.  []{#_Toc96357427 .anchor}総説

＜考え方＞

  ---------------------------------------------------------------------------------
  本節4.4では、カテゴリー１の流量観測の実施について共通となる事項について述べる。
  ---------------------------------------------------------------------------------

2.  []{#_Toc96357428 .anchor}観測回数

＜必　須＞

+----------------------------------------------------------------------+
| 低水流                                                               |
| 量観測は、種々の水位に対してできるだけ数多く観測しなければならない。 |
|                                                                      |
| 高                                                                   |
| 水流量観測は、観測値の流量規模に偏りがないように大規模のみならず、中 |
| 規模の洪水も含めて、できるだけ数多くの洪水を観測しなければならない。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 低水流量観測は、年間36回以上実施することを標準とする。               |
|                                                                      |
| 流量の連続評価が可能な固定式観測法に                                 |
| ついては、観測が可能な流況の範囲において、低水時には毎正時、高水時に |
| は10分以下の間隔で連続観測を実施し、これを保存することを標準とする。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 高                                                                   |
| 水流量観測は、洪水の上昇期のみならず下降期にも行うことを標準とする。 |
|                                                                      |
| 洪水ピーク流量を水位流量曲線を介した外挿で推定する必要が             |
| ないように、適切なタイミングで観測するように努力しなければならない。 |
|                                                                      |
| 非固定式観測法では、ピーク流量観測以外の観測間隔は、毎時実           |
| 施することを標準とするが、観測所の出水特性、出水状況により判断する。 |
+----------------------------------------------------------------------+

＜推　奨＞

  --------------------------------------------------------------------------------------------------------------------
  非固定式観測法により急激な増減水を伴う洪水の観測を行う場合は、１時間ごとより短い観測間隔で観測することが望ましい。
  --------------------------------------------------------------------------------------------------------------------

＜推　奨＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------
  渇水時に、前年度の水位流量曲線の適用外（外挿）となるところまで水位が低下した場合は、観測頻度の確保や精密流量観測の実施等により観測精度の確保に努めることが望ましい。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜参考となる資料＞

観測回数・頻度に関する判断については、下記の資料が参考となる。

1.  国土交通省監修，(独)土木研究所編著：水文観測，第4章 流量観測 4･4
    浮子による流量観測(pp.147-148) 5･6
    水位流量曲線，全日本建設技術協会，2002.

    1.  []{#_Toc96357429 .anchor}器材の管理

＜必　須＞

  ----------------------------------------------------------------------------------------------------------
  流量観測に使用する器材は、求められる所定の機能が常に発揮・保持できるように適切に管理しなければならない。
  ----------------------------------------------------------------------------------------------------------

＜参考となる資料＞

観測手法ごとに必要となる器材の詳細については、下記の資料が参考となる。

1.  国土交通省監修，(独)土木研究所編著：水文観測，第4章
    流量観測，全日本建設技術協会，2002.

    1.  []{#_Toc96357430 .anchor}流速計の検定

＜必　須＞

+----------------------------------------------------------------------+
| 流速計は、流速計が必要とする精度を確保しているかを                   |
| 確認するための検定（係数試験）又はそれに準じる精度検証を行い、必要な |
| 精度の確保が確認できた流速範囲のみにおいて、流速計測に使用しなければ |
| ならない。検定（係数試験）結果の有効期間は１年を超えないものとする。 |
|                                                                      |
| 回転式流速計や電磁流速計等の可搬式流速計は、流速                     |
| 計検定所(係数試験所)において検定（係数試験）を行わなければならない。 |
|                                                                      |
| なお                                                                 |
| 、ADCPや電波流速計等のドップラー効果を原理とする流速計については、超 |
| 音波や電波の送受信性能の確認をもって、上記の精度検証に代えてもよい。 |
|                                                                      |
| 流速センサが必要とする精度は、河川流量観測の目的を踏まえ、測定対象   |
| とする流速範囲において、少なくとも5％以内を確保しなければならない。  |
+----------------------------------------------------------------------+

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------
  流速計の計測特性に変化が生じたおそれのある場合は、その都度速やかに検定（係数試験）若しくはそれに準じる精度検証を受けることを標準とする。
  ------------------------------------------------------------------------------------------------------------------------------------------

2.  []{#_Toc96357431 .anchor}観測心得の交付

＜必　須＞

  ----------------------------------------------------------------------------------------------------------------------
  流量観測責任者は、現地で流量観測作業に従事する観測員に対して、観測心得を定め、これを観測員に交付しなければならない。
  ----------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 観測心得には次に掲げる事項を定めることとする。                       |
|                                                                      |
| １）観測の目的と意義                                                 |
|                                                                      |
| ２）観測施設の使用方法                                               |
|                                                                      |
| ３）観測機器の取扱方法                                               |
|                                                                      |
| ４）観測記録の整理方法                                               |
|                                                                      |
| ５）観測の実施に際して必要な注意事項                                 |
|                                                                      |
| ６）臨時観測の基準                                                   |
|                                                                      |
| ７）その他必要な事項                                                 |
|                                                                      |
| なお、５）観測の実施に際して必要な注意事項                           |
| には、器材の故                                                       |
| 障時の対処方法と連絡先、異常値が観測された場合の通報先等が含まれる。 |
|                                                                      |
| また、７）その他必要な事項 として、作業の安全対策を含めて記述する。  |
+----------------------------------------------------------------------+

3.  []{#_Toc96357432 .anchor}精度確保のための留意事項

＜必　須＞

+----------------------------------------------------------------------+
| カテゴリー1の主要な流量観測法に                                      |
| ついては、観測地点の水理・水文特性を十分把握した上で、断面全体での流 |
| 量観測値の精度を確保する必要がある。したがって、それぞれの流量観測法 |
| の原理と運用実態、並びに、観測地点の水理・水文現象の実態の両者を踏ま |
| え、観測精度が低下するおそれのある条件下においては、基準を柔軟に運用 |
| するなどにより流量観測値の精度を確保するように努めなければならない。 |
|                                                                      |
| 特に、洪水時に実施する高水流量観測では、                             |
| 急激な増減水を伴う中で、緊急かつ迅速に流量観測を行わなければならない |
| ことから、急激な水位上昇等により一連の観測作業が間に合わない等の理由 |
| で必要な流速測線数を確保することが困難と判断される場合がある。このよ |
| うな条件下においては、観測作業の迅速性に配慮しつつ、流量観測の時系列 |
| データをより多く取得することを優先して流量観測を実施するものとする。 |
|                                                                      |
| また、観測地点の水理・水文特性及び周辺状況の変化に                   |
| より非固定式流量観測手法で観測できなくなる事態が想定される場合は、固 |
| 定式流量観測機器の併設を行うなど、欠測の防止に努めなければならない。 |
+----------------------------------------------------------------------+

＜例　示＞

+----------------------------------------------------------------------+
| 流                                                                   |
| 量値の観測精度が低下するおそれのある事例としては、以下が挙げられる。 |
|                                                                      |
| > １）可搬式流                                                       |
| 速計や浮子測法による流量観測において、洪水時等水位変動が大きい場合に |
| は、測線間隔を細かくし過ぎることにより測定に要する時間が長くなり、そ |
| の間の水位の変動によって、全体としての流量観測の精度が低下する場合が |
| ある。これらの場合、複数のグループで観測作業を並行させる、橋上操作艇 |
| 搭載ADCP法や非接触型流量計測法を有効に活用するなどの対応方法がある。 |
| >                                                                    |
| > ２）高水敷の広い複断面での浮子                                     |
| 測法の適用において、測線間隔を等間隔におくことを優先することにより、 |
| 洪水の主流部となる低水路部での流速分布を的確に再現することが困難とな |
| り、断面全体での洪水流量観測精度を低下させてしまう場合がある。この場 |
| 合、過去の観測実績も踏まえた上で区分流量が区分断面ごとにほぼ等しい値 |
| になるように測線位置を変更する、区分流量が相対的に大きい場所で密に測 |
| 線を設定する、橋上操作艇搭載ADCP法を有効に活用するなどの手法がある。 |
+----------------------------------------------------------------------+

[]{#_Toc96357433 .anchor}

4.  安全確保のための留意事項

＜必　須＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  現地観測員は、救命具を着用するほか、低水路満杯付近から高水敷に流水が乗る状況へ急速に変化する場合を想定し、水位の急激な上昇に備えた観測・退避体制の確保に万全を期するなど、観測時に発生する危険な状況を事前に想定し、観測員が現地で実施する作業の安全確保のための対策に万全を期さなければならない。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

5.  []{#_Toc96357434 .anchor}野帳への記録と保管

＜必　須＞

+----------------------------------------------------------------------+
| 現地観測員は、観測の都度、観測年月                                   |
| 日、時刻、観測流量、観測の方法、当該流量の算出方法等を野帳に記録しな |
| ければならない。野帳の様式は、各観測手法ごとに定めておくものとする。 |
|                                                                      |
| これらの現地での計測                                                 |
| データ等を記録した野帳は確実に保管しなければならない。野帳の保存期間 |
| 等の詳細については、「水文観測業務規程細則」に従わなければならない。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  水文観測業務規程細則，平成29年3月31日，国水情第45号，国土交通省水管理・国土保全局通達，第3章
    観測の実施.

＜参考となる資料＞

観測心得としての流量観測における様々な留意事項や野帳記入の詳細については、下記の資料が参考となる。

1.  国土交通省監修，(独)土木研究所編著：水文観測，第4章
    流量観測，全日本建設技術協会，2002.

    1.  []{#_Toc96357435 .anchor}可搬式流速計による流速計測法

        1.  []{#_Toc96357436 .anchor}総説

＜考え方＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  可搬式流速計による流量計測法は、河川の水面幅及び水深に応じて事前に設定した測点において流速を計測し、その流速とそれが代表する区分断面積を乗じて、区分断面ごとの流量を算定し、それらを全断面で加算することにより流量を求めるものである。したがって、１回の観測において水深測定と流速測定を組み合わせて実施する。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜参考となる資料＞

可搬式流速計による流速計測法の詳細については、下記の資料が参考となる。

1.  国土交通省監修，(独)土木研究所編著：水文観測，第4章 流量観測 4･3
    可搬式流速計による流量観測（流速計測法），全日本建設技術協会，2002.

    1.  []{#_Toc96357437
        .anchor}水理条件に対応した流速計の選定に当たっての留意事項

＜標　準＞

+----------------------------------------------------------------------+
| 感潮河川、                                                           |
| 河口付近、河川の分合流部付近での観測や、低水位時に河床地形等に起因し |
| た廻り込み流れが無視できない場合等、逆流・斜流が生じたり、水流が乱れ |
| るなどして、流速の方向が横断線に対して垂直にならない場合がある。この |
| ような条件下において観測しなければならないときは、横断線に対して水流 |
| の流向のなす角（方位角）を測定できる流速計を用いることを標準とする。 |
|                                                                      |
| ま                                                                   |
| た、可搬式流速計は、一般に、必要な精度を確保できる水深範囲（表面から |
| の深さ及び河床からの距離）に関する制約があることに注意が必要である。 |
| 計測すべき測点での計測に対応できる流速計を選定することを標準とする。 |
+----------------------------------------------------------------------+

2.  []{#_Toc96357438 .anchor}測定回数、測線と測点（標準法）

```{=html}
<!-- -->
```
1.  測定回数

＜標　準＞

+----------------------------------------------------------------------+
| 水深測定につ                                                         |
| いては、同一横断線上を往路と復路で１回ずつ計２回実施するものとする。 |
|                                                                      |
| 流速測定については、上記の水深測定のいずれかの観測に合わ             |
| せて、水深測定と同じ横断線上の各測点において実施するものとする。ただ |
| し、出水時のように、水位、流速の変化が大きいときはこの限りではない。 |
+----------------------------------------------------------------------+

21. 測線

＜標　準＞

+----------------------------------------------------------------------+
| 水深測線及び流速測線は                                               |
| 、横断方向に以下の表に示す間隔になるように設定することを標準とする。 |
|                                                                      |
| 4.  水面幅と水深測線間隔、流速測線間隔                               |
|                                                                      |
| ![](media/image10.emf){width="6.197222222222222in"                   |
| height="2.5833333333333335in"}                                       |
+----------------------------------------------------------------------+

＜標　準＞

  -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  水深測線は、横断線を含む鉛直面内で流速測線上及び互いに隣り合う流速測線の中央に設けることを標準とする（図2-4-1）。なお、両岸側においては、流速測線の外側の死水域との境界にもそれぞれ１つの水深測線を設けるものとする。
  -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

  ------------------------------------------------------------------------------------------
  横断面の形状や流速分布が複雑なときは、測線間隔を短縮し、より密に設定することが望ましい。
  ------------------------------------------------------------------------------------------

22. 測点

＜標　準＞

+----------------------------------------------------------------------+
| 流速測点は、流速測線上鉛直方向に水深                                 |
| の２割、８割の位置の流速を測定する２点法を採用することを標準とする。 |
|                                                                      |
| なお、流速計（及び錘）のサイズによっては                             |
| 、水深が小さい場合に２割水深において流速計感部が水面上にはみ出す、８ |
| 割水深で必要位置に測点を設定できない等により２点法をとることが困難な |
| 場合がある。２点法をとるために必要となる水深は以下により算定できるこ |
| とから、その必要水深以下の場合は水深６割における１点法を基本とする。 |
|                                                                      |
| １) ロッドにより測定を行う場合                                       |
|                                                                      |
| ２点法の必要水深＝（ロッドの最下端と流速計の中心の間の距離）×５      |
|                                                                      |
| ２) 流速計に錘をつけて測定する場合                                   |
|                                                                      |
| ２点法の必要水深＝（錘の最下端と流速計の中心の間の距離）×５          |
+----------------------------------------------------------------------+

＜参考となる資料＞

上記の測線・測点に関する基準の妥当性の検証事例としては、下記の資料が参考となる。

1.  今村仁紀，深見和彦，天羽淳：河川における低水流量観測技術基準の再評価，土木技術資料，vol.48
    No.1，pp.66-71,2006.

```{=html}
<!-- -->
```
23. 各測点における流速計測

＜必　須＞

+----------------------------------------------------------------------+
| 流速計測に当たっては、流速計感部が所定の器深                         |
| に正しく保持されていることを確認の上、計測を開始しなければならない。 |
|                                                                      |
| 各測点では、20秒以上の有効測定時間を確保した計                       |
| 測を少なくとも２回繰り返さなければならない。両者に著しい相違(10%以上 |
| を目安)があった場合は、計測を１回追加し、相違の少ない２回の計測値を  |
| 確保した上で、それらの平均値を算出し、当該測点における流速値とする。 |
|                                                                      |
| なお、所定の器深とは、本節4.5.3(3)測点                               |
| に定める深                                                           |
| さをいう。正しく保持するとは、流速計の方向が流速方向に合致しているこ |
| と、ワイヤが傾いていても器深が正しい測点位置に達していることをいう。 |
+----------------------------------------------------------------------+

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  流量観測値を算出するのに必要な各測点での流速は、測線に鉛直方向の流速成分である。したがって、流向が観測断面に対する垂直方向から大きくずれる場合は、垂直方向からずれた角度を同時に計測した上で、鉛直方向に通過する流速成分に換算することを標準とする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜参考となる資料＞

流速計測における留意事項の詳細については、下記の資料が参考となる。

1.  国土交通省監修，(独)土木研究所編著：水文観測，第4章 流量観測 4･3
    可搬式流速計による流量観測（流速計測法），全日本建設技術協会，2002.

    1.  []{#_Toc96357439 .anchor}測定回数、測線と測点（精密法）

＜必　須＞

+----------------------------------------------------------------------+
| 流速分布の不規則な乱れ等の観測地                                     |
| 点の水理条件により、標準法では必要な精度が確保できない場合には、精密 |
| 法による測定を行い、測定の精度を保持するように努めなければならない。 |
|                                                                      |
| 特に感潮区間、河口付近等で塩水浸入等の密度成層の見られる地           |
| 点や、低水位時等の河床地形による廻り込み等による流速分布の不規則な乱 |
| れが無視できない条件下での流量観測は、精密法によらなければならない。 |
|                                                                      |
| 精密法                                                               |
| による流量観測と同時に行った他の観測法による流量値との差異は、野帳、 |
| 観測流量表及び水位流量曲線図にそれぞれ記入しておかなければならない。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 精密法による測定は、以下のとおり実施することを標準とする。           |
|                                                                      |
| １) 測線                                                             |
|                                                                      |
| 水深測線・流速測線の間隔について、ともに標準法の1/2とする。          |
|                                                                      |
| ２) 測点                                                             |
|                                                                      |
| 水面から河床までの間に等間隔に10点の測点をとることとする。           |
|                                                                      |
| なお、水深2m未満の条                                                 |
| 件下で精密測定を実施する場合は、測定間隔を20cmとした上で、可能な範囲 |
| で測点数を確保することとする（鉛直方向の測点数は10点以下となる。）。 |
|                                                                      |
| ３) 各測点における流速計測                                           |
|                                                                      |
| 各測点において、60秒以上の有効測定時間を確保                         |
| した計測を少なくとも２回繰り返すものとする。両者に著しい相違(10%以上 |
| を目安)があった場合は、計測を１回追加し、相違の少ない２回の計測値を  |
| 確保した上で、それらの平均値を算出し、当該測点における流速値とする。 |
+----------------------------------------------------------------------+

＜推　奨＞

+----------------------------------------------------------------------+
| 誤差の原因が流速分布の乱れによるものと想定され、                     |
| 精密法を実施する場合は、以下の測点の設定で計測を行うことが望ましい。 |
|                                                                      |
| > １)                                                                |
| > 水深2m以上の条件                                                   |
| 下では、20cmの測定間隔を下限値として、10点以上の測点を確保すること。 |
| >                                                                    |
| > ２)                                                                |
| > 水深2m未満の条件下では、小型の流速計を活用する                     |
| などして、10点以内を目安としてできるかぎり多くの測点を確保すること。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

上記による精密法の適用事例として、下記の資料が参考となる。

1.  今村仁紀，深見和彦，天羽淳：河川における低水流量観測技術基準の再評価，土木技術資料，vol.48
    No.1，pp.66-71,2006.

    1.  []{#_Toc96357440 .anchor}流量算出の手順

＜標　準＞

+----------------------------------------------------------------------+
| 可搬式流速計による流速計                                             |
| 測値から流量を算出する作業は、次の各項に従って行うことを標準とする。 |
|                                                                      |
| １) 流量観測の開始時に、水位を測定する。                             |
|                                                                      |
| ２) 水深は、各水深測線において往復２回測定した値を平均する。         |
|                                                                      |
| ３)                                                                  |
| 水深の往路（もしくは復路）測定時に、各流速測線                       |
| において、水深値に応じて鉛直方向の測点を決め、各測点毎に２回ずつ流速 |
| を測定する。鉛直方向の平均流速値は、同一測点で2回ずつ測定した流速を  |
| 平均して求め、これを用いて各流速測線ごとに次のいずれかにより求める。 |
|                                                                      |
| > a） ２点法にあってはそれぞれの測点の平均流速値を平均した値         |
| >                                                                    |
| > b） １点法にあっては１点での測点の平均流速値                       |
| >                                                                    |
| > c）                                                                |
| > 精密法にあっては、各測点の流                                       |
| 速を直線で結んだ鉛直方向の流速分布曲線を描き、曲線内の面積を台形の面 |
| 積計算法により計算した上で、水深値で除した値（図2-4-2参照）。水面の  |
| 流速は水面に最も近い測点での流速値、河床の流速はゼロとおいてもよい。 |
|                                                                      |
| ４）流量観測の終了時に                                               |
| 再度水位を測定し、開始時の水位との平均値を、流量観測時の水位とする。 |
|                                                                      |
| ５)                                                                  |
| 横断面中において1つの流速測線の鉛直方向の平均流                      |
| 速値が代表する区分断面積は、これと互いに隣り合う流速測線の中央までと |
| する。互いに隣り合う水深測線間の区分断面積は、台形近似により求めても |
| よい（図2-4-1参照）。なお、水面幅10m以下にあっては、水深測線と流速測 |
| 線が一致している（表2-4-3参照）ことから、隣り合う２つの水深（流速）  |
| 測線の中間点に仮想的な水深測線を配置し、両隣の水深測線における水深値 |
| の平均水深を与えることで、当該流速測線に対応する区分断面積を求める。 |
|                                                                      |
| ６)                                                                  |
| 流量は、１つの流速測線における鉛直方向の平均流速値と、対応する区分断 |
| 面積との積を全測線（全区分断面）について合計することによって求める。 |
|                                                                      |
| ７) なお、両岸に死水域があれば、その区分断面積の流量はゼロとする。   |
|                                                                      |
| ８)                                                                  |
| 算出した流量値は直ちに前年                                           |
| の最終の水位流量曲線図に記入し、水位流量関係に変化があるかを確認する |
| 。固定式流量観測法によるリアルタイムの流量観測値がある場合は、その値 |
| との比較も行う。前年の水位流量関係や、固定式流量観測法によるリアルタ |
| イムの流量観測値との間に10％程度以上の大きな差異がある場合には、原因 |
| を究明する。原因が明らかにならない場合には、確認のため再測定を行う。 |
|                                                                      |
| 3.  ![](media/image11.emf){width="3.1534722222222222in"              |
|     height="1.8138888888888889in"}                                   |
|                                                                      |
|   標準法（２点法）における河川横断面内での測線・測点・区分断面の設定 |
|                                                                      |
| ![](media/image12.emf){width="3.40625in"                             |
| height="3.0854166666666667in"}                                       |
|                                                                      |
| 4.                                                                   |
|   精密法における河川鉛直断面内各測点の設定例と鉛直方向平均流速の算出 |
+----------------------------------------------------------------------+

＜参考となる資料＞

流量算出の詳細については、下記の資料が参考となる。

1.  国土交通省監修，(独)土木研究所編著：水文観測，第4章 流量観測 4･3
    可搬式流速計による流量観測（流速計測法），全日本建設技術協会，2002.

    1.  []{#_Toc96357441 .anchor}浮子による流速計測法（浮子測法）

        1.  []{#_Toc96357442 .anchor}総説

＜考え方＞

+----------------------------------------------------------------------+
| 浮                                                                   |
| 子測法は、浮子を投下して、ある区間を流下する時間を計測し、その区間の |
| 平均流速を求める方法である。急峻な日本の河川は、洪水時の流速が速く、 |
| ゴミや流木等の流下物も多い。浮子測法は、このような洪水時の厳しい条件 |
| 下においても河川の流速を確実に計測することができるという特長がある。 |
|                                                                      |
| 本項では浮子測法の標準的な手法を示すが、洪水時                       |
| の水理条件の変動が特に大きい地点や橋脚やその周辺の構造物等の影響によ |
| る流れの乱れ（橋脚後流）の影響が無視できないと想定される場合は、浮子 |
| の流下状態に注意し、適切な観測値が得られるように実施する必要がある。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

浮子測法の詳細については、下記の資料が参考となる。

1.  国土交通省監修，(独)土木研究所編著：水文観測，第4章 流量観測 4･4
    浮子による流量観測，全日本建設技術協会，2002.

    1.  []{#_Toc96357443 .anchor}付帯施設

＜必　須＞

+----------------------------------------------------------------------+
| 浮子測法による流量観測                                               |
| を行うためには、浮子のほか、次の付帯設備を備えなければならない。本節 |
| 4.3.3 観測施設が備えるべき設備 も参照すること。                      |
|                                                                      |
| １) 浮子投下施設                                                     |
|                                                                      |
| 橋梁を利用する場合と、                                               |
| 橋梁が利用できないところでは、専用の浮子投下施設を設ける場合がある。 |
|                                                                      |
| ２) 見通し杭                                                         |
|                                                                      |
| 見通し杭（横                                                         |
| 断線拠標）は、第１見通し横断面及び第２見通し横断面に設置する。併せて |
| 、夜間でも照明等で見通すことのできる見通し杭を備えなければならない。 |
|                                                                      |
| また、浮子投下施設として橋梁を利用する場合は、橋脚後流の影響が及ば   |
| ないように第１見通し横断面及び第２見通し横断面を設置する必要がある。 |
|                                                                      |
| ３) 水位標                                                           |
|                                                                      |
| 水位標は、第１見通し横断面及び第２見通し横断面に設置する。           |
+----------------------------------------------------------------------+

2.  []{#_Toc96357444 .anchor}流速測線

＜標　準＞

+----------------------------------------------------------------------+
| 流速測線は、第１                                                     |
| 見通し横断面と第２見通し横断面の間で流れに沿うよう設けるものとする。 |
|                                                                      |
| 測線間隔については、第１見通し横断面の                               |
| 水面幅に応じて、表2-4-4に示す測線数以上を確保することを標準とする。  |
|                                                                      |
| 5.  水面幅に対応した浮子流速測線の目標数                             |
|                                                                      |
| ![](media/image13.emf){width="5.969444444444444in"                   |
| height="0.5986111111111111in"}                                       |
|                                                                      |
| 浮子流速測線数の                                                     |
| 出典：水位及び流量調査作業規程準則（昭和29年10月9日総理府令第75号）  |
|                                                                      |
| 一方、                                                               |
| 急激な増減水を伴う中で、緊急かつ迅速に流量観測を行わなければならない |
| 場合には、水面幅に応じて次の表2-4-5に示す測線数を下限数とし、表2-4-4 |
| にある測線数を目標にして、その間の測線数を確保することを標準とする。 |
|                                                                      |
| 6.  やむを得ず流量観測を緊急かつ迅速に行わなければならない場合の\    |
|     水面幅と最小浮子流速測線数の関係                                 |
|                                                                      |
| ![](media/image14.emf){width="5.75in" height="0.8638888888888889in"} |
|                                                                      |
| 浮子流速測線数の                                                     |
| 出典：水位及び流量調査作業規程準則（昭和29年10月9日総理府令第75号）  |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 測線の配置については、観測誤差をできるだけ                           |
| 小さくするため、区分流量が大きい部分に密に配置することを標準とする。 |
|                                                                      |
| なお、流線が流下方向に平行でな                                       |
| いため、各測線上に投下した浮子が流下するにつれて左右にふれる場合にお |
| いても、第１見通し横断面を基準として測線を設定することを標準とする。 |
+----------------------------------------------------------------------+

＜例　示＞

  --------------------------------------------------------------------------------------------------------
  測線の具体的な位置について、流速分布が未知の場合は、想定される水深分布を参考として設定する方法がある。
  --------------------------------------------------------------------------------------------------------

＜例　示＞

  -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  測線の位置を適切に設定するために、観測地点付近の洪水流の特性を事前に把握する調査を行う場合がある。そのための方法としては、1) 表2-4-4に示す間隔よりも密に設定した測線において浮子により計測する方法、2) 他の流速分布を密に把握できる観測手法を用いる方法等が考えられる。
  -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1.  水位及び流量調査作業規程準則，昭和29年10月9日，総理府令第
    75号，総理府

    （最新版）水位及び流量調査作業規程準則，昭和29年10月9日，総理府令第
    75号，総理府,令和1年5月7日.

    1.  []{#_Toc96357445 .anchor}浮子の種類

＜必　須＞

+----------------------------------------------------------------------+
| 浮子測法に使用する浮子は、桿浮子（棒浮子）又は表面浮子とし、         |
| 水深に応じた浮子を用いなければならない。なお、夜間も確実に浮子の位置 |
| を確認できるよう発光体を付けるなど工夫された浮子を用いるものとする。 |
|                                                                      |
| 浮子の流下速度は、水面から浮子                                       |
| の吃水深までの間の平均流速であることから、水面から河床までの間の鉛直 |
| 方向全体での平均流速に変換するために更正係数を乗じなければならない。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 観測                                                                 |
| に用いる浮子は、水深に応じて、水位及び流量調査作業規程準則に与えられ |
| ている表2-4-6に示すとおり、表面浮子、0.5m吃水の浮子、1.0m吃水の浮子  |
| 、2.0m吃水の浮子、4.0m吃水の浮子のいずれかを用いることを標準とする。 |
|                                                                      |
| 7.  浮子番号と水深、吃水の適用範囲                                   |
|                                                                      |
|   浮子番号     １         ２         ３         ４         ５        |
|   ------------ ---------- ---------- ---------- ---------- --------- |
|   水深（ｍ）   0.7以下    0.7～1.3   1.3～2.6   2.6～5.2   5.2以上   |
|   吃水（ｍ）   表面浮子   0.5        1.0        2.0        4.0       |
|                                                                      |
| 出典：水位及び流量調査作業規程準則（昭和29年10月9日総理府令第75号）  |
+----------------------------------------------------------------------+

＜例　示＞

  -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  植生が繁茂している等により、観測に用いる浮子について表2-4-6に依ることが不適切な測線においては、１段階短い浮子を用いることで、当該測線の観測データを確保する手段が有効となる場合がある。
  -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜例　示＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  高水敷が冠水した時には、水深に応じた適切な浮子を使用するほか、可搬式流速計を用いて高水敷上の観測を行う場合がある。また、必要に応じて非接触型流量計測法による観測を行う場合がある。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

1.  []{#_Toc96357446 .anchor}浮子による流速の測定

＜標　準＞

+----------------------------------------------------------------------+
| 浮子による流速測定作業は、次の各項に従って実施することを標準とする。 |
|                                                                      |
| > １)                                                                |
| > 浮子は、                                                           |
| 浮子投下施設や橋梁を使って、定められた測線位置において順次投下する。 |
| >                                                                    |
| > ２)                                                                |
| > 測線                                                               |
| ごとに、水位と横断面図とから水深を求め、適切な吃水の浮子を投入する。 |
| >                                                                    |
| > ３)                                                                |
| > 第１見通し横断面通過から第２見通                                   |
| し横断面通過までの時間ｔを測定し、両横断面間の距離Ｌをｔで割って浮子 |
| 流下速度ｖ~o~とする。第１、第２見通し横断面間の距離については、本節  |
| > 4.3.3(3) 流量観測所横断線                                          |
| > を                                                                 |
| 参照する。また、浮子が異常流下していないことを後から確認できるように |
| 、浮子の流下状況の記録（ポンチ絵、写真、ビデオ等）を残すものとする。 |
| >                                                                    |
| > ４)                                                                |
| > ｖ~o~に更正係数を掛けて測線ごとの深さ方向平均流速ｖを算出する。    |
| >                                                                    |
| > ５) 浮子の更正係数については、次表の値を標準とする。               |
|                                                                      |
| 8.  浮子番号と水深、更正係数の関係                                   |
|                                                                      |
| ![](media/image15.emf){width="5.127777777777778in"                   |
| height="0.8368055555555556in"}                                       |
|                                                                      |
| 出典：水位及び流量調査作業規程準則（昭和29年10月9日総理府令第75号）  |
|                                                                      |
| > 但し、4.6.4の例示に基づき、１段階短い                              |
| 浮子を用いる場合には、水深と浮子の吃水深に応じて更正係数値の修正を行 |
| う必要がある。その場合の修正更正係数は、流速分布式に基づき浮子吃水部 |
| の平均流速に対する全水深平均流速の比により設定することを基本とする。 |
| >                                                                    |
| > ６)                                                                |
| > 流速測定の開始時と終了時とにおい                                   |
| て、第１見通し横断面及び第２見通し横断面でそれぞれの水位を観測する。 |
+----------------------------------------------------------------------+

＜推　奨＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  水深が10m程度を超える場合は、浮子の吃水比が0.4以下となり、上表の更正係数の設定条件からのずれが大きくなることから、流速分布式やADCPによる流速分布実測値に基礎を置いた、更正係数の再設定を行うことが望ましい。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1.  水位及び流量調査作業規程準則，昭和29年10月9日，総理府令第
    75号，総理府

    （最新版）水位及び流量調査作業規程準則，昭和29年10月9日，総理府令第
    75号，総理府,令和1年5月7日.

＜参考となる資料＞

浮子測法における諸基準、流速分布式・更正係数の設定根拠・手法については、下記の資料が参考となる。

1.  江川太朗，竹内俊雄：浮子の更生係数，土木技術資料，vol.5
    No.1，pp.18-21，1963.

```{=html}
<!-- -->
```
48. 国土交通省監修，(独)土木研究所編著：水文観測，第4章 流量観測 4･4
    浮子による流量観測，全日本建設技術協会，2002.

    1.  []{#_Toc96357447 .anchor}浮子測法による流量の算出

＜標　準＞

+----------------------------------------------------------------------+
| 浮子測法による流量の算出は、次の事項に従って行うことを標準とする。   |
|                                                                      |
| > １）流量算出に用いる断面は、横断面ごとに                           |
| 、洪水前後の横断測量の結果から求められる洪水前及び洪水後の全断面積（ |
| 洪水期間中の最高水位時）を比較して、いずれか大きい方の断面を用いる。 |
| >                                                                    |
| > ２）上記の断面積算出に用いる水位は、横断面ごとに、本               |
| 節4.6.5に定めた流速計測の開始時と終了時における水位の平均値とする。  |
| >                                                                    |
| > ３）１つの流速測線の深さ方向平均流速が代表する区                   |
| 分断面は、これと相隣り合っている流速測線との中央線までの領域とする。 |
| >                                                                    |
| > ４）第１見通し横断面と                                             |
| 第２見通し横断面において、１つの流速測線それぞれに対応した区分断面の |
| 面積を求め、両者の算術平均をその流速測線の受け持つ区分断面積とする。 |
| >                                                                    |
| > ５）流量は、測線ごとの深さ方向平均流速とその                       |
| 平均流速が受け持つ区分断面積との積を全測線について合計して算出する。 |
| >                                                                    |
| > ６）測定精度のチェックのために、算出した流量値は現場で             |
| 速やかに前年の水位流量曲線図に記入し、水位流量関係を確認するとともに |
| 、固定式観測法による洪水流量観測データが存在する場合には、そのリアル |
| タイム観測データとの比較を行う。水位流量曲線図において、水位～流量の |
| 点を時系列的につないで、観測値が反時計回り又は、時計回りのループを描 |
| いているかを確かめ、実況の水理状況に合致しているかどうかを確認する。 |
+----------------------------------------------------------------------+

1.  []{#_Toc96357448
    .anchor}舟に搭載したADCP（超音波ドップラー流向流速計）による流速計測法

    1.  []{#_Toc96357449 .anchor}総説

＜考え方＞

+----------------------------------------------------------------------+
| ADCPは水中に発射する超音波が、流水に乗って移                         |
| 動する細粒土砂やプランクトン等に当たって反射する際に生じるドップラー |
| 効果を利用して、河道断面内の３次元的な流速分布を計測する測器である。 |
|                                                                      |
| ADCPを活用した流量計測法としては                                     |
| 、舟に搭載して水面から流速分布を計測する非固定式の方法をとる場合、舟 |
| が有人か無人かにかかわらず、必ず人が現場で舟を操作する必要があるが、 |
| 舟を水面上で横断方向に移動させながら観測することにより、河川流水断面 |
| 内の流速分布と断面積を同時に計測できること、観測原理上水面及び川底の |
| 付近に一部の観測不能域が生じるものの、流水内の流速分布について他の手 |
| 法よりも少ない仮定で積分的に流量を計測できることといった特長がある。 |
|                                                                      |
| 水面波浪が大きく、ADCPを搭載した舟                                   |
| の揺動が激しくなる（20度以上が目安）場合や、流木・ゴミの流下が特に多 |
| い場合には、安全で安定した計測ができなくなることに注意が必要である。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

本節に記載ないADCPによる流速計測法の詳細については、下記の資料が参考となる。

1.  国土交通省監修，(独)土木研究所編著：水文観測，第4章 流量観測 4・7
    新しい流量・流速の観測法，全日本建設技術協会，2002.

    1.  []{#_Toc96357450 .anchor}流速分布計測の方法

```{=html}
<!-- -->
```
1.  基本事項

＜標　準＞

+----------------------------------------------------------------------+
| 洪水時のADCPによる非固定式の流量観測は、橋上                         |
| 操作艇にADCPを搭載し、橋上からの曳航操作による横断計測を標準とする。 |
|                                                                      |
| 低水時のADCPによる非固定式の流量観測は、有人艇・無                   |
| 人艇（橋上操作艇若しくはラジコン艇）のいずれに搭載する方法でもよい。 |
|                                                                      |
| いずれの場合においても、観測中は上流からのゴミや流木の監視を行       |
| い、それらを迅速に回避する体制をとるものとし、安全管理を十分に行う。 |
|                                                                      |
| また、ADCPによる流量観測については、観測地点において                 |
| 以下のような水理・水文現象が生じている場合には実施しないものとする。 |
|                                                                      |
| > １)                                                                |
| > （波浪の波長が舟の長さよりも十分長い場合を除き）水面の波           |
| 高が50cmを超え、舟を浮かべたときに揺動が激しく転覆のおそれがある場合 |
| >                                                                    |
| > ２)                                                                |
| > 洪水時の流木が舟に頻繁に引っかかるなどにより観測に危険が生じる場合 |
|                                                                      |
| 上                                                                   |
| 記の場合は浮子による観測等を含め、観測方法を別途検討する必要がある。 |
+----------------------------------------------------------------------+

24. 使用する計測機器等

＜標　準＞

+------------------------------------------------------------------+
| 計測機器等は、下記のものを用いることを標準とする。               |
|                                                                  |
| > １) ADCP                                                       |
| >                                                                |
| > ２) 高精度位置標定装置（RTK (Real Time Kinematic)-GNSS等）     |
| >                                                                |
| > ３) ADCPを搭載する舟                                           |
| >                                                                |
| > ４) 遠隔操作装置（無人艇の場合）                               |
| >                                                                |
| > ５) 橋上から舟を安全に係留操作するための架台（曳航観測の場合） |
+------------------------------------------------------------------+

＜推　奨＞

+----------------------------------------------------------------------+
| １)                                                                  |
| 観測所の状況                                                         |
| に応じて下記の機能を有する計測機器を使用又は併用することが望ましい。 |
|                                                                      |
| > a） 音響測深器（高濁度下での観測や河床の凹凸が複雑かつ顕著な場合） |
| >                                                                    |
| > b） VTG（進行方向対地移動速度）情報を取得できる（RTK-              |
| > GNSS）の使用、又は、トータルステーション                           |
| >                                                                    |
| > c）                                                                |
| > 磁                                                                 |
| 場の影響を受けない外部コンパス（GNSSコンパス）（観測断面周辺の鋼構造 |
| 物等による磁場の変化を受けて流向流速ベクトルの算出に影響が及ぶ場合） |
|                                                                      |
| ２)                                                                  |
| 洪水時の計測に使用する舟は高速流に                                   |
| 対応できるトリマラン型（三胴艇）の橋上操作艇を用いることが望ましい。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

ADCPに併せて用いる計測機器の利用目的・原理・留意事項の詳細については、下記の資料が参考となる。

1.  菅野裕也，萬矢敦啓，橘田隆史，井上拓也，深見和彦：外部コンパスを併用したADCP観測に関する提案，河川技術論文集，vol.17，pp.35-40，2011.

```{=html}
<!-- -->
```
49. 萬矢敦啓，岡田将治，橘田隆史，菅野裕也，深見和彦：高速流におけるADCP観測のための橋上操作艇に関する提案，河川技術論文集，vol.16，pp.59-64，2010.

50. 萬矢敦啓，菅野裕也，深見和彦：河川実務者の観点から見たADCPによる流量観測技術開発の論点，河川流量観測の新時代，第1巻，p.46，2010.

```{=html}
<!-- -->
```
25. 計測機器等の点検準備

＜必　須＞

+----------------------------------------------------------------------+
| 使用する計測機器等は、舟への固定方法、ケーブル類の配線               |
| 方法等を検討するとともに、計測前に十分な点検を行わなければならない。 |
|                                                                      |
| 計測時は、ADCPのほかに観測所の状況に応                               |
| じた計測機器等が必要となる。計測機器等のトラブルは、洪水時の流量観測 |
| データを取り逃すことにつながるため、舟への搭載に当たっては、各機器の |
| 固定方法やケーブル類の配線方法を検討し、計測時の揺動においても機器の |
| 脱落、ケーブルの切断等が生じないようにしなければならない。また、観測 |
| 時に必要となる発電機等も含め、観測前には十分な点検を行うものとし、特 |
| に機器のバッテリーや発電機の燃料等は十分な予備を携帯する必要がある。 |
+----------------------------------------------------------------------+

26. 横断計測の範囲

＜標　準＞

+----------------------------------------------------------------------+
| 横断計測の範囲は、水際部を除き、河道断面内の流速                     |
| 分布（死水域を含む）について可能な限り計測できる範囲とし、水際部は計 |
| 測範囲内の流速分布データにより適正な補間処理を行うことを標準とする。 |
|                                                                      |
| また、横断計測では、水際部に近づくにつれて水深が浅くな               |
| るため、近づきすぎると波の影響等で舟が河岸や河床に接触して破損する危 |
| 険が伴う。このため、水際付近の計測には十分注意するとともに、リアルタ |
| イムの計測データにより水深を確認しながら計測を行うことを標準とする。 |
+----------------------------------------------------------------------+

＜例　示＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  高水敷における計測では、樹木等の影響や地形により、横断計測の途中で橋上操作艇の曳航ができなくなる場合がある。地形により曳航が不可能となった場合は、一度、舟を水面から撤去し、再び観測可能な箇所へ着水させることで、横断計測を継続することが可能となる。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

27. 横断計測の速度

＜推　奨＞

+----------------------------------------------------------------------+
| 横断計測の速                                                         |
| 度については、計測原理上は遅い方が望ましいが、出水時に特に急激な水位 |
| 変動が見られる場合には、流況の変化に影響がない時間内での観測が望まれ |
| る。観測データの精度を安定させるためには両者のバランスが必要となる。 |
|                                                                      |
| 低水流量観測においては、流速                                         |
| が舟の横断速度に比べて極端に遅い場合に、RTK-GNSS等から得られる横断計 |
| 測の速度が流速値に与える影響が大きくなるため、計測に使用する舟の制御 |
| 可能な範囲において、できるだけ舟の横断速度を遅くすることが望ましい。 |
|                                                                      |
| 高水流量観測において橋上操                                           |
| 作艇を使用する場合は、横断計測の速度を1m/s程度とすることが望ましい。 |
+----------------------------------------------------------------------+

28. 計測状況の記録

＜必　須＞

+----------------------------------------------------------------------+
| 現地計測の状                                                         |
| 況に係る下記の項目は、必ず現地において野帳に記録しなければならない。 |
|                                                                      |
| > １) 計測年月日                                                     |
| >                                                                    |
| > ２) 観測開始時刻と終了時刻                                         |
| >                                                                    |
| > ３) 舟と左右岸の水際線までの距離（データ補間処理が必要な距離）     |
| >                                                                    |
| > ４) 計測を開始した河岸（左岸または右岸）                           |
| >                                                                    |
| > ５) その他、ADCP観測時の河道状況等で明記すべき事項（浅瀬の存在等） |
+----------------------------------------------------------------------+

1.  []{#_Toc96357451 .anchor}流量の算出

＜標　準＞

+----------------------------------------------------------------------+
| 流量の算出は下記の手順によることを標準とする。                       |
|                                                                      |
| な                                                                   |
| お、低水路、高水敷を分けて算出するとともに、それぞれ直接計測部と観測 |
| 不可能領域での補完部の流量も更に分けて算出しておくことを標準とする。 |
|                                                                      |
| > １)                                                                |
| > 各セル（流速分布                                                   |
| 計測単位）の流速に各セルの面積を乗じて各セルにおける流量を算出する。 |
| >                                                                    |
| > ２)                                                                |
| > 各セルの流量を                                                     |
| 合計し、横断計測における各細分化区分断面ごとの計測部流量を算出する。 |
| >                                                                    |
| > ３)                                                                |
| > 観測不可能領域の流量については、直接計測部より得られる鉛直方       |
| 向若しくは横断方向の流速分布を適切に活用しながら補完するものとする。 |
| >                                                                    |
| > ４)                                                                |
| > 各細分化区                                                         |
| 分断面の流量及び観測不可能領域の全合計値を全断面流量として算出する。 |
| >                                                                    |
| > ５) 全断面平均流速の算出は、全断面流量を全断面積で除して算出する。 |
+----------------------------------------------------------------------+

1.  []{#_Toc96357452 .anchor}非接触型流速計測法

    1.  []{#_Toc96357453 .anchor}総説

＜考え方＞

+----------------------------------------------------------------------+
| 非                                                                   |
| 接触型流速計は、流水に直接触れることなく河川の表面流速を計測する器械 |
| である。このことから、非接触型流速計を活用することで、洪水時の河川の |
| 流量を無人で安全かつ自動的に連続観測するシステムの構築が可能である。 |
|                                                                      |
| ここでは、非接触型流速計の中でも適用事例の多いドップラー型           |
| の電波流速計と画像処理型流速測定法を対象として、適用手法を記述する。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

非接触型流速計による流量観測システムの詳細については、下記の資料が参考となる。

1.  国土交通省監修，(独)土木研究所編著：水文観測，第4章 流量観測 4・7
    新しい流量・流速観測法，全日本建設技術協会，2002.

```{=html}
<!-- -->
```
51. 非接触型流速計測法の手引き（試行版），平成30年3月，国土交通省水管理・国土保全局
    河川計画課河川情報企画室．

    （最新版）非接触型流速計測法の手引き（案），令和5年3月，国土交通省水管理・国土保全局
    河川計画課河川情報企画室．

    1.  []{#_Toc96357454 .anchor}流速計の設置及び付帯施設

```{=html}
<!-- -->
```
1.  電波流速計

＜標　準＞

+----------------------------------------------------------------------+
| 電波流速計は                                                         |
| 、可搬型流速計による流速計測法や浮子測法と同様に、複数測線（複数区分 |
| 断面）を設定し、その区分断面ごとの表面流速代表値を計測できるように、 |
| 電波流速計を橋桁等に設置する。測線の設定に当たっては、橋上操作艇に搭 |
| 載したADCPや浮子測法等による現地観測結果等により、洪水時の横断方向流 |
| 速分布を事前に把握した上で、それぞれの区分流量がほぼ均一になるように |
| 設定する。必要測線数は、浮子測法の基準に準じる(4.6.3参照)。ただし、  |
| 急激な増減水や固定式電波流速計の適用時の経済性、機器同士の電波の干渉 |
| などやむを得ない場合は、最小浮子流速測線数を適用できる(4.6.3参照)。  |
|                                                                      |
| 横断方向流速分布から流量演算処理を行うた                             |
| めには、事前に区分断面ごとの水深－断面積（H-A）の関係を算出しておく  |
| 必要がある。このため、流速観測を開始する前に電波照射域を設定し、その |
| 中に流量観測断面を設定する。電波流速計は、その流量観測断面に垂直な方 |
| 向に向けて計測を実施するものとし、同断面における水位も流速と同時に計 |
| 測するものとする。また、流量観測断面の横断測量を実施して、区分断面ご |
| との水深－断面積（H-A）の関係を事前に把握しておくことを標準とする。  |
|                                                                      |
| また、出水時には河床が変化する場合があることから、流量観測断面の横   |
| 断測量を洪水前後に実施し、流量演算処理に反映させることを標準とする。 |
|                                                                      |
| 電波流速計が計測する表面                                             |
| 流速は、風による吹送流の影響を受けるため、観測所の近傍に併せて設置す |
| る風向風速計のデータを用いて吹送流の影響を除去することを標準とする。 |
|                                                                      |
| 固定式電波                                                           |
| 流速計では安定性や保守点検を考慮し、設置場所の状況に応じて、保守点検 |
| 足場、観測局舎、振動対策設備等の周辺設備を設置することを標準とする。 |
+----------------------------------------------------------------------+

29. 画像処理型流速測定法

＜考え方＞

+----------------------------------------------------------------------+
| 画像処理型流速測定法とは                                             |
| 、洪水流を撮影した映像を解析することで流速を計測する手法である。主に |
| LSPIV（あるいはPIV） （ Large-Scale Particle Image Velocimetry ）、  |
| STIV （Space-Time ImageVelocimetry）、 Float-PTV（Particle Tracking  |
| Velocimetry）の 3 手法がある。LSPIV は平面 2                         |
| 次元的な流況                                                         |
| を捉えるには有効な手法であるが、高水流量観測事例は少ない。一方、STIV |
| と Float-PTV は観測事例が比較的多く高水流量観測に適している。        |
|                                                                      |
| STIV：                                                               |
|                                                                      |
| ・STIV 法は水面の波紋の移動速度から水表面流速を計測する手法である。  |
|                                                                      |
| ・STIV で得られるのは、（検査線上の）水表面流速の 1                  |
| 方向成分のみである。                                                 |
|                                                                      |
| Float-PTV：                                                          |
|                                                                      |
| ・Float-PTV                                                          |
| は、原則、浮子の流下速度の計測や流下軌跡を追跡する手法である。       |
|                                                                      |
| > ・浮子以外にも、浮子の替わりになるような"Float（流                 |
| 木等）"の流下状況を追跡することで流速等を把握することが可能である。  |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 画像処理型流速測定法を用いた高水流量観測では、録画画像を用いた画     |
| 像解析手法に適した撮影機材を用いて観測、記録を行うことを基本とする。 |
|                                                                      |
| STIVやFloat-PTVといった                                              |
| 画像処理型流速測定法を実施する上での画角設定方法は以下を標準とする。 |
|                                                                      |
| > ・計測範囲及び両                                                   |
| 岸の標定点や標定点として使用可能な既設構造物等をカメラ画角内に収める |
| >                                                                    |
| > ・ズーム機能も用いて、空                                           |
| やその他の流速・流量算出に係わらない部分はできるだけ画角内に入れない |
|                                                                      |
| カメ                                                                 |
| ラ映像を用いるにあたり、画像上での位置の移動を実空間での位置の移動に |
| 変換する必要があるため、必要に応じ標定点を設置することを標準とする。 |
|                                                                      |
| 画像処理型流速測定法のうち STIV                                      |
| を採用する場合、その検査線の位置、長さ、時間は以下を標準とする。     |
|                                                                      |
| > １）検査線の位置と検査線の本数                                     |
| >                                                                    |
| > 検査線の位置は、検査線の中心が流量を算出す                         |
| る横断面上になり、かつ、流量を算出する横断面に対し直交するように配置 |
| する。検査線の本数は、浮子測法における標準法（表2-4-4）以上とする。  |
| >                                                                    |
| > ２）検査線の長さ                                                   |
| >                                                                    |
| > 検査時間は検                                                       |
| 査線の長さと流速に依存する。可能な限り、検査線の長さと検査時間はSTI  |
| > がほぼ正方形になるよう                                             |
| に設定する。検査線の長さは、現地の河道特性・流況に合わせて設定する。 |
| >                                                                    |
| > ３）解析時間                                                       |
| >                                                                    |
| > 解析時間は検                                                       |
| 査線の長さと流速に依存する。可能な限り、検査線の長さと解析時間はSTI  |
| > がほぼ正方形になるように設定する                                   |
| ことが望ましい。解析時間は、現地の稼働特性・流況に合わせて設定する。 |
|                                                                      |
| また、出水時には河床が変化する場合があることから、流量観測断面の横   |
| 断測量を洪水前後に実施し、流量演算処理に反映させることを標準とする。 |
|                                                                      |
| 表面                                                                 |
| 流速は、風による吹送流の影響を受けるため、観測所の近傍に併せて設置す |
| る風向風速計のデータを用いて吹送流の影響を除去することを標準とする。 |
+----------------------------------------------------------------------+

＜例　示＞

+----------------------------------------------------------------------+
| STIVにより流速を算出する場合、検査                                   |
| 線の設定する位置、検査線の長さ、時間は流速の算出精度の影響を及ぼす。 |
|                                                                      |
| > １）検査線の本数                                                   |
| >                                                                    |
| > 検査線の本数が増えることで、詳細な水                               |
| 表面流速の横断分布が把握可能となり、流量算出精度の向上が期待できる。 |
| >                                                                    |
| > ２）検査線の長さ                                                   |
| >                                                                    |
| > できる限りSTI画像自体が正方形であることが望ましい。なお、10～15m   |
| > 程度が適切であるという実証例がある。併せて、STI                    |
| > 中に現れる波紋の縞模様の傾きが 30～60                              |
| > 度以内になるようにし、40～45度程度が最適である。                   |
| >                                                                    |
| > ３）解析時間                                                       |
| >                                                                    |
| > 可能な限り、検査線の長さと解析時間はSTI                            |
| > が                                                                 |
| ほぼ正方形になるように設定することが望ましい。なお、特に大きな流況の |
| 変化等がない場合、15秒程度で問題ないという実証例がある。併せて、STI  |
| > 中に現れる波紋の縞模様の傾きが 30～60                              |
| > 度以内になるようにし、40～45度程度が最適である。                   |
| >                                                                    |
| > 検査                                                               |
| 線長が10mの場合、解析時間が15秒程度でSTI画像が正方形に近い形になる。 |
+----------------------------------------------------------------------+

1.  []{#_Toc96357455 .anchor}流量の算出

＜標　準＞

+----------------------------------------------------------------------+
| 流量は、区分断面ごとの平均流速を算定し、それに区分断面               |
| 積を乗じて区分断面ごとの流量を算出し、全断面での総和により算出する。 |
|                                                                      |
| 区分断面の平均流速は、区分断                                         |
| 面ごとの風補正をした水表面流速に流速補正係数を乗じることで算出する。 |
|                                                                      |
| 流速補正係数は、各観測所における適切な値を使用することを基本とする。 |
|                                                                      |
| 非接触型                                                             |
| 流速計測法による流量の算出は、次の事項に従って行うことを標準とする。 |
|                                                                      |
| > １）流量算出に用いる断面は、横断面ごとに                           |
| 、洪水前後の横断測量の結果から求められる洪水前及び洪水後の全断面積（ |
| 洪水期間中の最高水位時）を比較して、いずれか大きい方の断面を用いる。 |
| >                                                                    |
| > ２）上記の断面積算出に用いる水位                                   |
| は、流速計測の開始時と終了時における対象横断面の水位の平均値とする。 |
| >                                                                    |
| > ３）１つの流速測線の深さ方向平均流速が代表する区                   |
| 分断面は、これと相隣り合っている流速測線との中央線までの領域とする。 |
| >                                                                    |
| > ４）非接触型流速計測法により流量を算出する断                       |
| 面において、１つの流速測線それぞれに対応した区分断面の面積を求める。 |
| >                                                                    |
| > ５）測線ごとの深                                                   |
| さ方向平均流速は、非接触型流速計測法で得られた水表面流速に対し、風の |
| 影響による補正をし、その補正された水表面流速に流速補正係数を乗じる。 |
| >                                                                    |
| > ６）流量は、測線ごとの深さ方向平均流速とその                       |
| 平均流速が受け持つ区分断面積との積を全測線について合計して算出する。 |
| >                                                                    |
| > ７）測定精度のチェックのために、算出した流量値は                   |
| 現場で速やかに前年の水位流量曲線図に記入し、水位流量関係を確認する。 |
+----------------------------------------------------------------------+

＜例　示＞

+----------------------------------------------------------------------+
| 流速補正係数は、各観測所における適切な値を使用する                   |
| ことが望ましいが、検証が出来ない場合、暫定的に0.85を使用しても良い。 |
|                                                                      |
| 今後、ADCPによる様々な規模の洪水時の鉛直方向の流速分布に関           |
| する観測結果から係数の妥当性を検証し、必要に応じて更新・修正を行う。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

非接触型流速計による流量観測システムの詳細については、下記の資料が参考となる。

1.  非接触型流速計測法の手引き（試行版），平成30年3月，国土交通省水管理・国土保全局
    河川計画課河川情報企画室．

    （最新版）非接触型流速計測法の手引き（案），令和5年3月，国土交通省水管理・国土保全局
    河川計画課河川情報企画室．

電波流速計による流量観測システムの詳細や適用事例については、下記の資料が参考となる。

3.  萬矢敦啓，菅野裕也，深見和彦，葭澤広好，宮本孝行：流量観測高度化に関する富士川南部観測所における取組，土木技術資料，vol.52
    No.3，pp.40-43，2010.

```{=html}
<!-- -->
```
52. 深見和彦，今村仁紀，田代洋一，児玉勇人，中島洋一，後藤啓介：ドップラー式非接触型流速計（電波・超音波）を用いた洪水流量の連続観測手法の現地検証～浮子測法との比較～，河川技術論文集，vol.14，pp.307-312，2008.

53. 土木研究所，土木研究センター，アジア航測，小糸工業，拓和，横河電子機器，東京建設コンサルタント：非接触型流速計を用いた開水路流量観測方法及びその装置，特開2004-219179，2004-8-5.

    1.  []{#_Toc96357456 .anchor}維持管理

＜必　須＞

  ------------------------------------------------------------------------------------------------------------------------------------------------
  非接触型流速計測の計測断面では、流下断面の変化を反映させて計測精度を確保するため、設置後においても出水期前に横断測量を実施しなければならない。
  ------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 電波流速計は、現地への設置の前に、流速検定施設において               |
| 検定を行い、設置後は現地において観測精度を確認することを標準とする。 |
|                                                                      |
| 設置後、観測機器の劣化や不備                                         |
| による欠測を未然に防ぐため、定期的に保守管理を行うことを標準とする。 |
+----------------------------------------------------------------------+

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  非接触型流速計測の計測断面にH-A関係、H-V関係に影響を与えるような変化が生じた場合には、計測結果をADCP等による観測結果と比較し、演算処理装置内の係数（流速補正係数）を更新することを標準とする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

1.  []{#_Toc96357457 .anchor}超音波流速計測法（パルス伝播時間差法）

    1.  []{#_Toc96357458 .anchor}総説

＜考え方＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  超音波流速計測法（パルス伝播時間差法）は、対となる超音波送受波器を河川の水中両岸に斜めに対向して設置し、上流側から下流側へ超音波が伝播するのに要する時間と、反対に下流側から上流側へ伝播するのに要する時間の差が、超音波伝播線上の平均流速に比例することを利用した流速計測法である。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜参考となる資料＞

超音波流速計測法の詳細については、下記の資料が参考となる。

1.  国土交通省監修，(独)土木研究所編著：水文観測，第4章 流量観測 4・6
    超音波流速計による流量観測，全日本建設技術協会，2002.

    1.  []{#_Toc96357459 .anchor}超音波流速計測法による流速の測定

＜標　準＞

+----------------------------------------------------------------------+
| 超音波                                                               |
| 流速計測法による流速の測定は、次の各項に従って行うことを標準とする。 |
|                                                                      |
| > １) 適切な観測位置とシステムを選定する。                           |
| >                                                                    |
| > ２)                                                                |
| > 流量を観測する位置に、流向に                                       |
| 対して斜めにかつ水平に流速測線を設け、その両端（水中）に対向させて超 |
| 音波送受波器を設置する。あわせて断面積算定のための水位計も設置する。 |
| >                                                                    |
| > ３)                                                                |
| >                                                                    |
| 送受波器は、流速測線上にある堅固な杭又は護岸等の水中部に取り付ける。 |
| >                                                                    |
| > ４)                                                                |
| > 横断面の形状・河川の水理・水質特性に応じて、流速測線は             |
| １本又は複数設置し、それに応じた超音波制御・処理システムを選定する。 |
| >                                                                    |
| > ５) 測定・演算等のため超音波機器設備は陸上に局舎を設け、設置する。 |
|                                                                      |
| なお、観測位置については本節4.3 流量観測所の配置と設置               |
| に従うものとするが、位置の選定とシステムの選定                       |
| は相互関連があるので、下記の点にも留意して位置を設定する必要がある。 |
|                                                                      |
| > １)                                                                |
| > 川幅：標準的には、100～200m程度まで対応が可能であり、それより川幅  |
| が広い場合、断面を分割して計測する方法をとるなどの工夫が必要である。 |
| >                                                                    |
| > ２)                                                                |
| > 水深：水深が浅いと、超音波が水面・底面に当たり多重                 |
| 反射を起こす場合があるので注意が必要である。中州がある地点は避ける。 |
| >                                                                    |
| > ３)                                                                |
| > 流速：高流速時の気泡、乱流等によるノイズや                         |
| 、洪水時の濁度上昇による減衰の影響を受けることに注意する必要がある。 |
| >                                                                    |
| > ４)                                                                |
| > 流向：流向の変化の影響は、送受波器をV字型に配置する                |
| ことで解決できるが、著しい流況の変化があるところは避ける必要がある。 |
| >                                                                    |
| > ５)                                                                |
| > 水温・塩分の鉛直分布：躍層は、超音波屈折の原                       |
| 因となるので、多層での計測や断面分割等の対策が必要となる場合がある。 |
| >                                                                    |
| > ６)                                                                |
| > 水温・塩分の時間変動：速い変動により流速計測に影響                 |
| を与える場合には、上流方向と下流方向の超音波の同時送波が必要である。 |
+----------------------------------------------------------------------+

＜推　奨＞

  --------------------------------------------------------------------------------------------------------------------------------------------------
  水温変化や塩分変化が流速計測に影響を与えていると想定される場合には、水温計・塩分計を設置することで水温・塩分の鉛直分布を監視することが望ましい。
  --------------------------------------------------------------------------------------------------------------------------------------------------

2.  []{#_Toc96357460 .anchor}超音波流速計測法による流量の算出

＜標　準＞

+----------------------------------------------------------------------+
| 複数の流速                                                           |
| 測線を持つ場合の流量の算出は、次の各項に従って行うことを標準とする。 |
|                                                                      |
| > １)                                                                |
| > 流量を測定する横断面において１つの流速                             |
| 測線の受け持つ区分横断面積は、上下の流速測線との中間までとする（流速 |
| 測線が一つの場合は、全横断面を受け持つことになる。）。なお、横断面は |
| 、超音波送受波器の方向にかかわらず、流水に直角方向の横断面を用いる。 |
| >                                                                    |
| > ２)                                                                |
| > 最上段及び最下段に設定された流速測線の                             |
| 受け持つ区分横断面の最上限及び最下限は、それぞれ水面及び底面とする。 |
| >                                                                    |
| > ３)                                                                |
| > 流量は、平均流                                                     |
| 速とそれの受け持つ区分横断面積との積を全測線について合計して求める。 |
|                                                                      |
| なお、非固定式観測法やADCPの計測結果との比較により、流速補正係数を用 |
| いる必要が明らかになれば、その流速補正係数を用いることを標準とする。 |
|                                                                      |
| ３測線の場合を数式に表わすと、                                       |
|                                                                      |
| *Q = a~1~･v~1~ +a~2~･v~2~ + a~3~(H)･v~3~* (2-4-1)                    |
|                                                                      |
| Q ：求められる流量                                                   |
|                                                                      |
| v~1~, v~2~, v~3~ ：超音波による平均流速（3測線）                     |
|                                                                      |
| a~1~, a~2~ ：断面積（一定）                                          |
|                                                                      |
| a~3~(H) ：断面積（水位の関数）                                       |
|                                                                      |
| である。                                                             |
|                                                                      |
| ![図3-2](media/image16.png){width="3.035416666666667in"              |
| height="1.9895833333333333in"}                                       |
|                                                                      |
| 図2-4-3　パルス伝播時間差法における測線・区間横断断面積の考え方      |
|                                                                      |
| > ４)                                                                |
| > 超音波機器                                                         |
| 設備としては、この流量観測システムに要求される目標、たとえば流量管理 |
| に適した情報が表示されるように測定・演算・表示することを標準とする。 |
+----------------------------------------------------------------------+

＜推　奨＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  観測データについては、水位流量曲線を介さずに直ちに流量を算出・表示できるメリットを最大限生かすため、テレメータ設備を用いて、事務所、管理所等で即時利用できる自動演算処理・表示システムを導入することが望ましい。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

3.  []{#_Toc96357461 .anchor}維持管理

＜必　須＞

  --------------------------------------------------------------------------------------------------------------
  超音波の伝播経路となる斜め横断面内に、超音波伝播の障害物が生じないように、河道の維持管理に努めるものとする。
  --------------------------------------------------------------------------------------------------------------

1.  []{#_Toc96357462 .anchor}水理構造物を用いる方法

    1.  []{#_Toc96357463 .anchor}総説

＜考え方＞

+----------------------------------------------------------------------+
| 堰や限界流フリュームは、常                                           |
| 流から射流に遷移する流れを発生させることにより支配断面を形成すること |
| で、水位（越流水深）と流量との間に１対１の関係をつくり、水位から流量 |
| を換算することのできる水理構造物である。比較的小流量の河川（小規模な |
| 渓流等）における流量観測に用いられる。また、ダムや水門等の構造物につ |
| いても、流れを拘束するなどして水位と流量との関係を単純化し、水理実験 |
| によって通過流量を把握するための流量換算式を作成することが行われる。 |
|                                                                      |
| 本節では、流量観測を目的とした水理構                                 |
| 造物として代表的な堰を活用した流量計測法（堰測法）を中心に記載する。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

本節に記載ない水理構造物を用いる方法の詳細については、下記の資料が参考となる。

1.  国土交通省監修，(独)土木研究所編著：水文観測，第4章 流量観測 4・5
    堰等による流量観測，全日本建設技術協会，2002.

    1.  []{#_Toc96357464 .anchor}堰測法の種類と配慮事項

＜考え方＞

+----------------------------------------------------------------------+
| 流量観測が可能な堰は、堰の形状によって次の３種に分類される。         |
|                                                                      |
| > １) 刃型堰：精度が良い。小規模な河川で一般に利用される。           |
| >                                                                    |
| > ２)                                                                |
| > 越流頂：ダムの                                                     |
| 余水吐等で自由ナップの形状が採り入れてあれば、大流量でも利用できる。 |
| >                                                                    |
| > ３)                                                                |
| > 広頂堰：一般の落                                                   |
| 差工等を利用した流量観測所に見られる。ただし、流量係数は複雑である。 |
+----------------------------------------------------------------------+

＜必　須＞

+----------------------------------------------------------------------+
| 堰によって流量を観測する場合には、堰上流の                           |
| 堆砂及び堰下流の洗掘に対して十分な対策を立てておかなければならない。 |
|                                                                      |
| また、特に刃型堰では、流木、ゴミ等により観測の精度が著               |
| しく低下することがあるので、これに対する対策を講じなければならない。 |
|                                                                      |
| 堰測法においては、いずれも越流深を測定するのであるが                 |
| 、堰上流側の堆砂は、上流側の堆砂ポケットの大きいダム等を除いては問題 |
| となる。堆砂は堰測法の精度に影響するため、堆砂が問題となる場所に設置 |
| した場合には、排砂装置をつけて精度確保に努めておかなければならない。 |
|                                                                      |
| また、下流側の洗                                                     |
| 掘に対しては、河床保護工を行うなど対策を立てておかなければならない。 |
+----------------------------------------------------------------------+

＜例　示＞

  ----------------------------------------------------------------------------------------------------------------------------------
  一般の落差工を用いる堰測法では、低水時には越流水深が極めて小さくなることがあるので、精度を上げるために複断面の堰とする例がある。
  ----------------------------------------------------------------------------------------------------------------------------------

2.  []{#_Toc96357465 .anchor}可動ゲートを有する堰における要件

＜必　須＞

  ------------------------------------------------------------------------------------------------------------
  可動ゲートを有する堰に流量観測所を設ける場合には、ゲートの開度を水位と同時に記録しておかなければならない。
  ------------------------------------------------------------------------------------------------------------

3.  []{#_Toc96357466 .anchor}越流水深の測定

＜標　準＞

+----------------------------------------------------------------------+
| 堰測法によって流量を観測する場合には、堰に近く、流速の小さい位置に   |
| 水位観測施設を設置し、これにより越流水深を観測することを標準とする。 |
|                                                                      |
| 水位観測については、本章 第3節 水位観測 によるものとする。           |
+----------------------------------------------------------------------+

4.  []{#_Toc96357467 .anchor}堰測法による流量の算出

＜標　準＞

+----------------------------------------------------------------------+
| 堰測法において、完全越流                                             |
| の矩形堰の場合には、次の公式を用いて流量を算出することを標準とする。 |
|                                                                      |
| *Q = CBH*^3/2^ (2-4-2)                                               |
|                                                                      |
| 　　　　 　Q：流　量（ｍ^3^/s）                                      |
|                                                                      |
| 　　　　　　　　C：堰の越流係数                                      |
|                                                                      |
| 　　　　　　　　B：堰　幅（ｍ）                                      |
|                                                                      |
| 　　　　　　　　H：越流水深（ｍ）　である。                          |
|                                                                      |
| 越流係数については、堰形状・適用範                                   |
| 囲が、堰に関する公式（石原・井田の式、板谷・手島の式等）の適用条件を |
| 満たすものであれば、それらの公式をそのまま用いることができる。そうで |
| ない場合は、模型実験による越流水深と流量の関係式を求める必要がある。 |
|                                                                      |
| その他の形状の堰、不完全越流又は、潜り越流の堰及び可動               |
| ゲートを有する堰については、その形状等に最も適した公式を用いるか、又 |
| は観測、模型実験等により水位と流量との関係を求めることを標準とする。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

越流係数の求め方を含む越流公式の詳細については、下記の資料が参考となる。

1.  土木学会水理委員会：水理公式集［2018年版］，第3編
    ダム，第2章せきと越流頂，丸善，2019.

    1.  []{#_Toc96357468 .anchor}流量の連続データの算出

        1.  []{#_Toc96357469 .anchor}総説

＜考え方＞

+----------------------------------------------------------------------+
| 観測された水位(H)と流量(Q)と                                         |
| の関係を示す曲線を水位流量曲線（H-Q曲線）と呼ぶ。連続的に得られてい  |
| る水位観測値から365日24時間の連続した流量を算出できることから、長年  |
| にわたり、流量を連続的に算出する手法として幅広く用いられてきている。 |
|                                                                      |
| ここで、水位から流量が１対１に求まる条件は、エネル                   |
| ギー勾配（又は河床勾配）に対して水面勾配の変化の影響を無視できる場合 |
| であり、ある程度以上の河床勾配を有し、かつ、ゆっくりとした水位変動の |
| 場合には、水位と流量はほぼ１対１に対応する。ただし、当該流量観測地点 |
| を含む河道区間が、河積や粗度（特に樹木群の繁茂状況）の縦断方向の急変 |
| 等により、河床勾配が急な割に一ハイドログラフ内での水面勾配の変化の影 |
| 響が出やすい条件を有している場合にはこの限りではない。ここでは、流量 |
| 観測所が本節4.3.2に示された条件を満足することが標準であり、また本節  |
| 4.3.3(1)に記した維持管理が流量観測所においてなされていることを前提に |
| 、水位と流量がほぼ１対１に対応するための条件を広目に記述している。こ |
| うしたことから、当該流量観測所が、河積や粗度の縦断方向の急変等の特性 |
| を有していないかをチェックすることは、水位と流量がほぼ１対１の関係を |
| 持つことを前提にデータの処理を行って良いかを確認する上で重要である。 |
|                                                                      |
| 本節では、この原理を活用                                             |
| した水位流量曲線による連続的な流量データの算出手法について規定する。 |
|                                                                      |
| なお、本節                                                           |
| 4.8～4.10で解説した                                                  |
| 固定式流量観測手法を用いることにより、水面勾配の変化にかかわらず、あ |
| る範囲の河川流量において、流量の連続データの算出を行うこともできる。 |
+----------------------------------------------------------------------+

＜必　須＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  本節で用いる流量の観測資料は、後述の第2章水文・水理観測 第5節 水文資料の整理・保存と品質管理 5.3 照査 5.3.2異常値補正 に述べる現地補正を済ませた後の観測資料を用いなければならない。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

+----------------------------------------------------------------------+
| 緩流河川においては、下流側における潮汐や合流、堰操作等による背水     |
| の影響による水面勾配の変化の影響が無視できないため、水位流量曲線を水 |
| 位のみの一価関数として表現することはできない。したがって、このような |
| 地点においては水位流量曲線法を用いないことが望ましい。緩流河川でなく |
| とも、上述のように、河積や粗度（特に樹木群の繁茂状況）の縦断方向の急 |
| 変が見られる場合も、水位流量曲線法の採用を再検討することが望ましい． |
|                                                                      |
| このような地点で流量の連続評価を行う場合は、こういった               |
| 水理条件下でも利用可能な固定式流量観測手法を活用することが望ましい。 |
|                                                                      |
| 固定式観測手法を適用し                                               |
| 、必ずしも水位流量曲線を作成する必要のない流量観測所においても、本章 |
| 第5節 水文資料の整理・保存と品質管理 5.3 照査 5.3.2 異常値照査 (2)   |
| 流量の                                                               |
| 異常値補正（流量の現地照査）及び水位流量曲線の作成、ならびに、5.3.3  |
| 標準照査 (3) その他                                                  |
| に記述する水位流量関係の照査を併せて行うことが望ましい。             |
+----------------------------------------------------------------------+

＜例　示＞

  --------------------------------------------------------------------------------------------------------
  河川の合流点付近の流量観測所では、近傍の流量観測所のデータに基づく水収支より連続評価を行う事例もある。
  --------------------------------------------------------------------------------------------------------

＜参考となる資料＞

水位流量曲線法の詳細については、下記の資料が参考となる。

1.  国土交通省監修，(独)土木研究所編著：水文観測，第5章
    観測記録の整理と保存 5･6 水位流量曲線，全日本建設技術協会，2002.

    1.  []{#_Toc96357470 .anchor}水位流量曲線の作成手法の基本

＜標　準＞

+----------------------------------------------------------------------+
| 水位流量曲線                                                         |
| 式の作成は、水位を縦軸として流量を横軸とする座標上に、水位及び流量の |
| 値をプロットし、最小二乗法等によって関係式を求めることを標準とする。 |
|                                                                      |
| 水位流量曲線式には、２次式を用いることを標準とする。２次式の場       |
| 合、曲線式は、水位をH(m)、流量をQ(m^3^/s)として、以下のようになる。  |
|                                                                      |
| *Q = a* (*H + b* )^2^ (2-4-3)                                        |
|                                                                      |
| a, b：観測断面、作成対象となる期間・水位範囲によって決まる定数       |
|                                                                      |
| 水位流量曲線を用いて流量の算出を行う場合、当該期間中                 |
| の流量観測値の範囲内において流量を算出することとし、当該期間中の流量 |
| 観測範囲を超えた外挿領域への曲線式の適用は行わないことを標準とする。 |
|                                                                      |
| また、水位流量曲線式の定数を求める際には、低水位部                   |
| 分で流量値がマイナスとならない制限を設けて同定することを標準とする。 |
|                                                                      |
| 縦断勾配が緩や                                                       |
| かな河川では、水位流量曲線は、洪水時（特にハイドログラフが急激に変化 |
| し非定常効果が大きくなる洪水時）に水面勾配の変化等の影響を受けて、単 |
| 純な一価関数とならずに、時系列的に反時計回りのループを描く場合がある |
| 。緩流河川でなくても、縦断方向の河積の急変等により、場合によっては同 |
| 様の特性が出現する可能性がある。この場合、近隣の水位観測所との水位差 |
| （水面勾配）を考慮した水位流量曲線の導入を検討することを標準とする。 |
| これは、表2-4-1に示した水面勾配断面積法の原理を応用するものである。  |
+----------------------------------------------------------------------+

＜推　奨＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  水位及び水面勾配から流量を得ようとしても、必要な精度が満足されない場合も考えられる。その原因としては、当該河川区間の流れが、水位流量曲線はもちろん水面勾配断面積法を採用しても適切に再現できない水理的特性を本来的に有していることが考えられる。そうした状況においては、流量と相関の高い水理量の組合せを形式上見いだそうと、更に作業を進めるのではなく、本章の第1節 総論 に述べたカテゴリー３.１の観測を通じて（その内容は本章 第7節 河川の流れの総合的把握 に記述している）、当該区間の流れの総合的把握を行い、そこでの流れを支配する水理システムを理解し、流量を算出する合理的な方法を個々に見いだしていくことが望ましい。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

  ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  自記水位計の記録から得られる当該地点での最高水位・最低水位において、現地での流量観測が行われていなかったり、前年のH-Q式をベースにした洪水予測等の日々の河川管理の目的のために、水位流量曲線をその流量観測範囲を超えて左下方（渇水）と右上方（洪水）にやむを得ず外挿して適用しなければならない場合も想定される。その場合は、観測範囲の水位流量曲線を単純に延長するのではなく、マニング式等を活用し断面特性を加味した水理学的な水位流量曲線とする方法をとることが望ましい。
  ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜例　示＞

  -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  水位流量曲線式として２次式により精度を確保できない場合は、べき乗値を2と固定しない一般のn次式を用いてもよい。この場合、未知定数が３つとなるが、特にnの同定値について、一般に見られる開水路の断面形状においてマニング式から理論的に想定される1～3の範囲を超えるような不合理な値をとることのないように注意する必要がある。
  -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜参考となる資料＞

水面勾配による水位流量曲線の補正や、マニング式を用いた水位流量曲線の作成、ｎ次式におけるｎの取り得る範囲、等の詳細については、下記の資料が参考となる。

1.  国土交通省監修，(独)土木研究所編著：水文観測，第5章
    観測記録の整理と保存 5･6･4
    水位流量曲線式の選定，全日本建設技術協会，2002.

```{=html}
<!-- -->
```
54. ISO 1100-2 Hydrometry - Determination of the stage-discharge
    relationship，2012.

    （最新版）ISO18320 Hydrometry-Measurement of liquid flow in open
    channels-Determination of the stage-discharge relationship，2020.

    1.  []{#_Toc96357471 .anchor}水位流量曲線の更新

＜標　準＞

+----------------------------------------------------------------------+
| 水位流量曲線は一水文年をひとつの有効期間として曲線                   |
| 式を作成するのが一般的であるが、洪水による河床変動等を契機として水位 |
| 流量関係が変化した場合は、その変化時を区切りとして曲線式を更新する。 |
|                                                                      |
| 一つの水位流量曲線                                                   |
| について有効な期間から、別の異なる水位流量曲線について有効な期間に移 |
| 行する境界（有効期間を一水文年とする場合は、年界）において、同じ水位 |
| に対する流量算出値が極力不連続にならないようにすることを標準とする。 |
+----------------------------------------------------------------------+

2.  []{#_Toc96357472 .anchor}曲線分離

＜標　準＞

+----------------------------------------------------------------------+
| 複断面等の複雑な断面                                                 |
| 形状を有する河川では、低水から高水までを一つの曲線式で表すことができ |
| ないことが多い。この場合、一つの曲線式で回帰できる水位区間群に分割し |
| 、水位区間ごとの水位流量曲線式を求めることを標準とする（曲線分離）。 |
|                                                                      |
| これらの                                                             |
| 曲線分離においては、分離して同定された水位流量曲線同士の境界周辺の日 |
| 時若しくは水位において、流量が不連続にならないようにするものとする。 |
+----------------------------------------------------------------------+

＜推　奨＞

+----------------------------------------------------------------------+
| 水位流量曲線の作成に当たっては、以下のことに注意することが望ましい。 |
|                                                                      |
| > １)                                                                |
| > 高水部分を曲線分離す                                               |
| る水位は、断面形状（又はH－A関係）の変曲点等を参照しながら設定する。 |
| >                                                                    |
| > ２)                                                                |
| > 高水流量観測においては、一連の観測値を時刻順に                     |
| 結ぶことによって、水面勾配等の影響による水深－流量関係のループ効果を |
| H－Q関係のばらつきや観測誤差と区別しながら水位流量曲線の検討を行う。 |
+----------------------------------------------------------------------+

1.  []{#_Toc96357473 .anchor}特殊な場所における流量観測

＜考え方＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  流量観測手法に関する事項は、結氷することがなく、かつ、上流から下流に向かって全断面で常に順流状態で流水が流れる地点での流量観測手法を基本に記述したものである。このため、寒冷地における結氷時の流量観測や、河口感潮域等の全断面で順流状態が確保されるとは限らない地点での流量観測においては、別途留意が必要となる。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

[]{#_Toc96357474 .anchor}

1.  結氷河川における留意事項

＜考え方＞

  ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  結氷河川での流量観測は、厳しい気象条件下での作業であるとともに、流水が氷で覆われていることから観測自体も困難となる。このため、本節4.5以下に述べた観測手法を結氷河川に適用する場合、非結氷河川における流量観測と比べると観測機材や観測方法等に別途留意が必要となる。
  ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜参考となる資料＞

結氷河川における留意事項の詳細、河川結氷時の連続的な流量評価の新しい手法の研究開発成果、結氷河川の感潮域での流量観測の事例、及び、海外における検討事例については、下記の資料が参考となる。

1.  国土交通省監修，(独)土木研究所編著：水文観測，第4章 流量観測 4･8
    特殊な場所での流量観測，全日本建設技術協会，2002.

```{=html}
<!-- -->
```
55. 吉川泰弘，渡邊康玄，早川博，平井康幸：河川結氷時の観測流量影響要因と新たな流量推定手法，水工学論文集，第54巻，pp.1075-1080，2010.

56. 吉川泰弘，平井康幸：結氷河川における感潮域の流量観測手法に関する検討－常呂川河口観測所における結氷時と開水時の流量観測－，北海道開発局技術研究発表会，第54回
    技18，2010年度.

57. ISO 9196 Hydrometry - Flow measurement under ice conditions，1992.

    （最新版）現在は廃止。

＜標　準＞

+----------------------------------------------------------------------+
| 結                                                                   |
| 氷河川での流量観測は、以下の事項に留意して実施することを標準とする。 |
|                                                                      |
| > １)                                                                |
| > 降雪、降雨、暴風、気温等の天候の変化に留意して観測計画を立てる。   |
| >                                                                    |
| > ２)                                                                |
| >                                                                    |
| 氷上作業を行う際は、事前に氷板の厚さを確認し、特に水際部分の氷板は不 |
| 安定であるため氷上に乗る際は十分に注意するなどの安全対策に配慮する。 |
| >                                                                    |
| > ３)                                                                |
| > 流速計の凍結防止対策                                               |
| として、できる限り空気中に出さないなどの対策を行い、凍結した場合には |
| 固形燃料等を用いて、流速計に着氷した氷を融解させる対策も必要である。 |
| >                                                                    |
| > ４)                                                                |
| > 水位標に着氷している氷                                             |
| を除去する場合は、水位標の目盛板の損傷に十分に留意して氷を除去する。 |
| >                                                                    |
| > ５)                                                                |
| > 結氷時は                                                           |
| 氷板や晶氷（モロミ）により流積が変化するため、流速分布が複雑となる場 |
| 合や流量が偏在している場合は、標準よりも密に測線を設ける必要がある。 |
| >                                                                    |
| > ６)                                                                |
| > 結                                                                 |
| 氷下の断面における流積、積雪面積、氷板面積及び晶氷面積を的確に把握す |
| るために、各測線で水深測定を行う場合、以下の事項についても測定する。 |
| >                                                                    |
| > a） 氷板（結氷）上の積雪の厚さ                                     |
| >                                                                    |
| > b） 氷板の厚さ                                                     |
| >                                                                    |
| > c） 氷板下に滞留する晶氷（モロミ）の厚さ                           |
| >                                                                    |
| > d） 実質的な流積を形成する河床から流水上面までの厚さ               |
+----------------------------------------------------------------------+

1.  []{#_Toc96357475 .anchor}河口感潮域における留意事項

＜考え方＞

  -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  河口感潮域における低水時の調査については、本節4.5以下に詳述した流量観測手法が原則的に用いられる。しかし、潮汐の影響で時々刻々水位と流量が変動するので、特に可搬式流速計による流速計測法の適用に当たっては、特別な配慮が必要となる。また、本節4.11に記述するような、水位から一意的に流量を連続的に評価する水位流量曲線法が使えないことに注意が必要である。さらに、複雑な流動を示すことが多い河口感潮域において、流動に関わるどのような水理量の継続観測が必要か、それと流量との関係はどうかに留意し、目的と当該区間の流動の特徴を踏まえた上で観測内容を定めていくことが重要である。
  -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜参考となる資料＞

河口感潮域における流量観測での留意事項の詳細については、下記の資料が参考となる。

1.  国土交通省監修，(独)土木研究所編著：水文観測，第4章 流量観測 4･8
    特殊な場所での流量観測 4･8･2
    河口感潮部における流量観測，全日本建設技術協会，2002.

```{=html}
<!-- -->
```
58. ISO2425 Hydrometry-Measurement of liquid flow in open channels under
    tidal conditons，2010.

＜標　準＞

+----------------------------------------------------------------------+
| 河口感潮域で                                                         |
| の低水時の流量観測は、以下の事項に留意して実施することを標準とする。 |
|                                                                      |
| > １) 潮汐等対象区間の流動特性をよく考慮して観測計画を立てる。       |
| >                                                                    |
| > ２)                                                                |
| > 水位・流速の変動                                                   |
| があるため、観測の同時性確保の必要性に応じて、迅速に計測作業を行う。 |
| >                                                                    |
| > ３)                                                                |
| > 順流・逆                                                           |
| 流が入れ替わる前後の時間帯等、流水内の流速分布が複雑となるため、代表 |
| 的な流速値を適切に把握できるように流速計測を行う。可搬式流速計による |
| 流速計測法においては、流向を測定できる流速計を用いるとともに、必要に |
| 応じて、精密法等により多くの測点での流速計測を行うことを標準とする。 |
+----------------------------------------------------------------------+

＜推　奨＞

  ------------------------------------------------------------------------------------------------------------------------
  流況が時々刻々変動するため、固定式観測法を採用することで、流速・流量を連続的に観測できる手法を導入することが望ましい。
  ------------------------------------------------------------------------------------------------------------------------

＜例　示＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  可搬式流速計による流速計測法の適用に当たっては、代表的な潮汐条件のときに精密法で流速分布を把握しておき、いかなる深さでその測線上の平均流速を把握できるかを事前に調べておくことで、一般的な方法からの流速測点数の増加を抑制することができる場合がある。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

**調査編**

6.  **水文・水理観測**

**第5節　水文資料の整理・保存と品質管理**

**目　次**

[第5節 水文資料の整理・保存と品質管理 1](#_Toc80951507)

> [5．1 総説 1](#_Toc80951508)
>
> [5．2 データ整理 1](#_Toc80951509)
>
> [5．3 照査 2](#_Toc80951510)
>
> [5．3．1 総説 2](#_Toc80951511)
>
> [5．3．2 異常値補正 3](#_Toc80951512)
>
> [5．3．3 標準照査 9](#_Toc80951513)
>
> [5．3．4 高度照査 10](#_Toc80951514)
>
> [5．4 保存 13](#_Toc80951515)

令和４年６月　版

適用上の位置付け

　河川砂防技術基準調査編は、基準の適用上の位置付けを明確にするために、下表に示すように適用上の位置付けを分類している。

+--------+------------------+------------------+------------------+
| 分　類 | 適用上の位置付け | 末尾の字句例     |                  |
+--------+------------------+------------------+------------------+
| 考え方 | 技術資料         | ●目              | 「･･･ある。      |
|        |                  | 的や概念、考え方 | 」「･･･いる。」  |
|        |                  | を記述した事項。 |                  |
|        |                  |                  | 「･･･なる。      |
|        |                  |                  | 」「･･･れる。」  |
+--------+------------------+------------------+------------------+
| 必　須 | 技術基準         | ●法令による規定  | 「･･･なければ    |
|        |                  | や技術的観点から | ならない。」「･  |
|        |                  | 実施すべきである | ･･ものとする。」 |
|        |                  | ことが明確であり |                  |
|        |                  | 遵守すべき事項。 |                  |
+--------+------------------+------------------+------------------+
| 標　準 | 技術基準         | ●特              | 「･･･            |
|        |                  | 段の事情がない限 | を標準とする。」 |
|        |                  | り記述に従い実施 |                  |
|        |                  | すべきだが、状況 | 「･･･            |
|        |                  | や条件によって一 | を基本とする。」 |
|        |                  | 律に適用すること |                  |
|        |                  | はできない事項。 | 「･･･による。」  |
+--------+------------------+------------------+------------------+
| 推　奨 | 技術資料         | ●状況や条件      | 「               |
|        |                  | によって実施する | ･･･望ましい。」  |
|        |                  | ことが良い事項。 |                  |
|        |                  |                  | 「               |
|        |                  |                  | ･･･推奨する。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･務める。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･必要に応    |
|        |                  |                  | じて･･･する。」  |
+--------+------------------+------------------+------------------+
| 例　示 | 技術資料         | ●適用条件や実施  | 「               |
|        |                  | 効果について確定 | ･･･などの手法（  |
|        |                  | している段階では | 事例）がある。」 |
|        |                  | ないが、状況や条 |                  |
|        |                  | 件によっては導入 | 「･･･など        |
|        |                  | することが可能な | の場合がある。」 |
|        |                  | 新技術等の例示。 |                  |
|        |                  |                  | 「･･･など        |
|        |                  | ●状              | が考えられる。」 |
|        |                  | 況や条件によって |                  |
|        |                  | 限定的に実施でき | 「               |
|        |                  | る技術等の例示。 | ･･･の場合には･･･ |
|        |                  |                  | ことができる。」 |
|        |                  | ●具体的          |                  |
|        |                  | に例示することに | 「               |
|        |                  | より、技術的な理 | ･･･例示する。」  |
|        |                  | 解を助ける事項。 |                  |
|        |                  |                  | 「例えば･･･。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･事例もある  |
|        |                  |                  | 。･･･もよい。」  |
+--------+------------------+------------------+------------------+

  関連通知等       関連する通知やそれを理解する上で参考となる資料
  ---------------- ------------------------------------------------------
  参考となる資料   例示等に示した手法・内容を理解する上で参考となる資料

1.  []{#_Toc80951507 .anchor}水文資料の整理・保存と品質管理

    1.  []{#_Toc80951508 .anchor}総説

＜考え方＞

+----------------------------------------------------------------------+
| 本節では、カテゴリー1の観測によって得られた                          |
| 水文資料の整理・保存と品質管理の内容について定めるものである。第2節  |
| 降水量観測、第3節 水位観測、第4節 流量観測                           |
| で述べた方法により得られた、カテゴリー１に属する水文観測データ       |
| は、長期にわたる安定した品質を保証した上で、所定の様式によりデータベ |
| ース化され、いつでも必要に応じて参照することができる状況を確保するこ |
| とにより基礎データ（水文資料）として有効に活用することが可能となる。 |
|                                                                      |
| また、カテゴリー２、３の観測についても観測されたデータ               |
| の内容を鑑み、整理・保存することで、将来の有効な活用の可能性がある。 |
+----------------------------------------------------------------------+

＜必　須＞

+----------------------------------------------------------------------+
| 取得された水文観                                                     |
| 測データは、以下の水文観測業務規程及び同細則に定められた手続・作業分 |
| 担によって十分な照査を行うことにより、品質を管理しなければならない。 |
|                                                                      |
| また                                                                 |
| 、照査を完了した水文観測データは、水文観測業務規程及び同細則に定めら |
| れた手続・様式により整理・保存し、水文資料としてデータベース化を実施 |
| しなければならない。その際、水文資料の確実な保存や、水文資料の参照・ |
| 利用・公開のための作業の効率化について、特に配慮しなければならない。 |
+----------------------------------------------------------------------+

＜必　須＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  現地における観測作業から、水文観測データの整理・照査・保存に至る一連の作業は、極めて多岐にわたる作業を伴う。これらの作業の分担は、水文資料整理の一連の作業が円滑にできるように、事前に関係者間（地方整備局等、河川事務所）で定めておかなければならない。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1.  水文観測業務規程，平成29年3月31日，国水情第44号，国土交通事務次官通達.

```{=html}
<!-- -->
```
59. 水文観測業務規程細則，平成29年3月31日，国水情第45号，国土交通省水管理・国土保全局通達.

60. 水文観測データ品質照査要領，平成26年3月20日，国水情第
    46号，国土交通省水管理・国土保全局河川計画課長通知

    （最新版）水文観測データ品質照査要領，令和5年3月29日，国水情第
    42号，国土交通省水管理・国土保全局河川計画課長通知.

61. 水文観測データ統計処理要領，平成26年3月20日，国水情第47号，国土交通省水管理・国土保全局河川計画課長通知.

＜参考となる資料＞

水文資料の整理・保存・品質管理の詳細については、下記の資料が参考となる。

1.  国土交通省監修，(独)土木研究所編著：水文観測，第5章
    観測記録の整理と保存，全日本建設技術協会，2002.

    1.  []{#_Toc80951509 .anchor}データ整理

＜必　須＞

  ------------------------------------------------------------------------------------------------------------
  水文観測データの整理は、水文観測業務規程及び同細則に定められた手続・様式に従って、実施しなければならない。
  ------------------------------------------------------------------------------------------------------------

[]{#_Toc80951510 .anchor}

2.  照査

    1.  []{#_Toc80951511 .anchor}総説

＜必　須＞

+----------------------------------------------------------------------+
| 水文観測データの照査は、観測データの異常値の検出、正常値、仮値及び   |
| 欠測の処理並びに水位観測データの流量換算方法の妥当性の評価及び修正を |
| 行うものであり、水文資料の品質を確保するために重要なプロセスである。 |
|                                                                      |
| 水文観測の実施責                                                     |
| 任者は、品質管理するための組織を設置するなど照査の体制を確保し、以下 |
| に示す段階に従って照査を行い、品質確保に万全を期さなければならない。 |
|                                                                      |
| 照査の結                                                             |
| 果、誤りを見いだした場合は、所定の手続を経て修正しなければならない。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 水文観測データの照査は、一般に以下の３つの段階から成る。             |
|                                                                      |
| １）異常値補正（流量資料については、「現地照査」と呼ぶ。）           |
|                                                                      |
| 観                                                                   |
| 測機器を設置・計測値の回収等を行う事務所等が、観測機器の点検報告やデ |
| ータ回収の整理結果を受けて、異常値の検出と修正を随時行うものである。 |
|                                                                      |
| ２）標準照査                                                         |
|                                                                      |
| 観測機器を設置・計測値の回収等を行う事務所                           |
| 等が、対象とする当該水文観測所ごとの水文観測データを用いて行う照査で |
| あり、異常値補正では検知できない異常値を検出し、修正するものである。 |
|                                                                      |
| ３）高度照査                                                         |
|                                                                      |
| 高度照査は、原則として、地方整備局等、広域の水文観測                 |
| 資料を取りまとめる立場の組織が、当該水文観測所の観測データを対象に、 |
| 周辺近傍の複数の水文観測所の観測データを用いて行う照査である。高度照 |
| 査は、水文資料を河川の計画・管理に具体的に活用する観点から、水文資料 |
| （雨量・水位・流量）が相互に大きな矛盾がなく、河川流域全体の降雨～流 |
| 出現象を精度よく把握し、信頼性の高い資料となっていることを確認する。 |
|                                                                      |
| これらの照査の作業分担と方法については、事前に定めておくものとする。 |
|                                                                      |
| なお、流量観測データの照査につ                                       |
| いては、流量観測時に観測の錯誤の可能性を検出し適切なデータを取り直す |
| 現地照査が異常値補正に相当する。水位流量曲線等を用いて連続的な流量資 |
| 料を得る段階で実施すべき流量観測データの照査が、高度照査に相当する。 |
|                                                                      |
| ![](media/image17.wmf){width="6.152083333333334in"                   |
| height="6.333333333333333in"}                                        |
|                                                                      |
| 5.  水文観測データの現行の照査フロー                                 |
+----------------------------------------------------------------------+

1.  []{#_Toc80951512 .anchor}異常値補正

＜標　準＞

+----------------------------------------------------------------------+
| 異常値の補正は、観測機器の点検報告、電子ロガーによる記録や自動記     |
| 録紙の回収結果の整理報告を受けて、定期的に実施することを標準とする。 |
|                                                                      |
| また、テレメータの水文観測データを監視する上で、リアルタイム         |
| で異常値が確認された場合も、異常値の補正を実施することを標準とする。 |
+----------------------------------------------------------------------+

1.  雨量の異常値補正

＜必　須＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  降水量の観測値は、観測機器の点検結果により、受水器や転倒マスの変形、ゴミの堆積、自動記録装置内の内蔵時計のずれ等が確認された場合には、各器械と観測値の異常に応じて観測値の補正を行わなければならない。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1.  水文観測データ品質照査の手引き（案），平成26年3月20日，国土交通省水管理・国土保全局河川計画課課長補佐事務連絡

    （最新版）水文観測データ品質照査の手引き（改定案），令和5年3月29日，国土交通省水管理・国土保全局河川計画課課長補佐事務連絡.

```{=html}
<!-- -->
```
30. 水位の異常値補正

＜必　須＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  水位の観測値は、観測機器の点検結果により、水位計の動作エラー等のセンサー異常、水位標読み値とセンサー値のズレ、地盤沈下等による零点高の変化、自動記録装置内の内蔵時計のズレ、伝送経路（テレメータ）の異常等が確認された場合には、各器械と観測値の異常に応じて観測値の補正を行わなければならない。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1.  水文観測データ品質照査の手引き（案），平成26年3月20日，国土交通省水管理・国土保全局河川計画課課長補佐事務連絡

    （最新版）水文観測データ品質照査の手引き（改定案），令和5年3月29日，国土交通省水管理・国土保全局河川計画課課長補佐事務連絡.

```{=html}
<!-- -->
```
31. 流量の異常値補正（流量の現地照査）及び水位流量曲線の作成

＜必　須＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  現地において観測された個別の流量観測値は、水位・水深や流速分布等の計測値を基に算出される。このため、それらの計測値に誤りや異常がないか、流量の算出過程に誤りがないか、その観測の都度速やかに異常値補正（以下、流量においては、"現地照査"という。）を行い、品質の確保・向上に努めなければならない。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜必　須＞

+----------------------------------------------------------------------+
| 流量の現地照査により                                                 |
| 、現地観測の時点で誤りや異常が疑われる観測値が含まれていることが判明 |
| した場合には、その観測値について現地にて再測定をしなければならない。 |
|                                                                      |
| ただし、観測手法の適用等における明らかな誤りを除き、個別の流量       |
| 観測の時点で誤りや異常が疑われた場合には、その観測値を簡単に除外せず |
| 、必ず再測定値と併せて観測野帳に記録し保存しておかなければならない。 |
|                                                                      |
| 異常値かどうかの判断                                                 |
| については、その後の断面再測量結果や低水・高水の流量観測結果、水位流 |
| 量曲線作成過程等を併せて参照し、最終的に総合判断しなければならない。 |
+----------------------------------------------------------------------+

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------
  流量の現地照査は、現地における流量観測作業の終了直後（高水流量観測に当たっては、その作業中又は作業終了直後）に行うことを標準とする。
  --------------------------------------------------------------------------------------------------------------------------------------

1.  準備

＜標　準＞

+----------------------------------------------------------------------+
| 流量の現地照査に当たっては、以下の資                                 |
| 料（写しでもよい）を事前に収集し、照査作業に備えることを標準とする。 |
|                                                                      |
| 観測流量表、流量観測野帳、流量計算書、断面計算書、横断面図           |
|                                                                      |
| 水位流量（H-Q                                                        |
| ）関係資料、水位断面積（H-A）関係資料、及び、水位流速（H-V）関係資料 |
+----------------------------------------------------------------------+

**\
**

2.  照査方法

＜必　須＞

+----------------------------------------------------------------------+
| 流量の現地照査は、下記の４つの照査図を用いて行わなければならない。   |
|                                                                      |
| > １) 「横断図～流速・流量図」                                       |
| >                                                                    |
| > ２) 「観測水位流量図（Ｈ－Ｑ図若しくはＨ－√Ｑ図）」                |
| >                                                                    |
| > ３) Ｈ－Ａ図                                                       |
| >                                                                    |
| > ４) Ｈ－Ｖ図                                                       |
|                                                                      |
| これらの当該照査図上に、観測値を速やかに                             |
| プロットし、大きな外れがないかどうか、前回までの観測時に作成した照査 |
| 図との変化がないかどうかを確認し、観測時点における水理水文条件に照ら |
| し、誤りや異常が含まれるかどうかを迅速に総合判断しなければならない。 |
|                                                                      |
| 本照査作業によ                                                       |
| り、当該時点の水理水文条件によるものとは確定できず、流量観測の誤りや |
| 異常による可能性を否定できない観測値が含まれていることを確認した場合 |
| は、速やかに異常が疑われる観測値の再測定作業を行わなければならない。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 固定式流量観測手法による流量観測値に                                 |
| ついては、主要な洪水発生の直後に現地照査作業を行うことを標準とする。 |
|                                                                      |
| > １) 流量算出に影響を与える河床変動等が生じたことが本章の第4節      |
| > 4.3.3                                                              |
| > 流量観測所横断線に定める観測断面の横断測量の結果明らかになっ       |
| た場合には、流速補正係数の見直しや断面積情報の更新を迅速に行い、リア |
| ルタイムでの連続的な流量観測値の品質の確保・向上に努める必要がある。 |
+----------------------------------------------------------------------+

3.  「横断図～流速・流量図」による照査図の作成

＜必　須＞

+----------------------------------------------------------------------+
| 流速測定                                                             |
| における誤りや異常の有無を確認するため、流量観測作業のたびに、最新の |
| 横断測量成果を描いた横断図の上半部の縦軸に、流量観測作業による各測線 |
| の流速値（測定値及び測線の平均流速値）をプロットしてこれを線で結ぶも |
| のとする（図2-5-2参照）。水深分布と流速分布との関係に不自然な部分が  |
| ある場合は、その測線における観測の異常によるものである可能性がある。 |
|                                                                      |
| ![](media/image18.png){width="5.006944444444445in"                   |
| height="3.292361111111111in"}                                        |
|                                                                      |
| 6.  横断図～流速・流量図                                             |
+----------------------------------------------------------------------+

4.  「観測水位流量図（Ｈ－Ｑ図若しくはＨ－√Ｑ図）」による照査図の作成

＜必　須＞

+----------------------------------------------------------------------+
| 流量観測                                                             |
| や流量算出過程における誤りや異常の有無を確認するため、観測水位と計算 |
| 流量を前年の水位流量曲線図（水位流量曲線を作成していない場合は前年の |
| 水位流量関係をプロットした図）にプロットするものとする（図2-5-3）。  |
|                                                                      |
| 高水流量観測に当たっては、更に一連のイベントにおける観測値群のプロ   |
| ットを時刻順に線で結ぶものとする。Ｑの代わりに√Ｑ（２次式の場合。図  |
| 2-5-4）若しくはＱ^１／ｎ^（ｎ次式の場合）を横軸にとった図でもよい。  |
|                                                                      |
| これらの観測                                                         |
| 水位流量図上にプロットされた新しい流量観測値が、既往の水位流量関係か |
| ら大きく外れる場合は、河床変動や下流水位条件等の水理条件の変化の可能 |
| 性とともに、観測又は流量算出過程の異常によるものである可能性がある。 |
|                                                                      |
| ![](media/image19.png){width="5.645833333333333in"                   |
| height="3.9895833333333335in"}                                       |
|                                                                      |
| 7.  観測水位流量図（Ｈ－Ｑ図）                                       |
|                                                                      |
| ![](media/image20.png){width="5.708333333333333in"                   |
| height="4.427083333333333in"}                                        |
|                                                                      |
| 8.  観測                                                             |
| 水位流量図（Ｈ－![](media/image21.wmf){width="0.2708333333333333in"  |
|     height="0.20833333333333334in"}図）                              |
+----------------------------------------------------------------------+

5.  Ｈ－Ａ図、Ｈ－Ｖ図による照査図の作成

＜必　須＞

+----------------------------------------------------------------------+
| 流量観測や流量算出過程における誤りや異常の有無を確認するため、直近   |
| の横断測量結果に基づくＨ－Ａ図（水位断面積関係図）、及び、直近の流量 |
| 観測におけるＨ－Ｖ図（水位流速関係図）に対して、現地での水位や水深観 |
| 測結果に基づく断面積算出結果や、現地での流速観測結果をプロットする。 |
|                                                                      |
| これらの図上にプロットされた新しい流量観測値が、既往の関係から大きく |
| 外れる場合は、河床変動や下流水位条件等の水理条件の変化の可能性ととも |
| に、観測又は流速・断面積算出過程の異常によるものである可能性がある。 |
|                                                                      |
| ![](media/image22.png){width="4.770833333333333in"                   |
| height="3.6458333333333335in"}                                       |
|                                                                      |
| 9.  水位断面積関係図（Ｈ－Ａ図）の例                                 |
|                                                                      |
| ![](media/image23.wmf){width="4.84375in"                             |
| height="2.6770833333333335in"}                                       |
|                                                                      |
| 10. 水位流速関係図（Ｈ－Ｖ図）の例                                   |
+----------------------------------------------------------------------+

＜推　奨＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  なお、Ｈ－Ｖ図において、Ｖとしては全断面での平均流速について作成するだけではなく、測線ごと（区分断面ごと）の平均流速についても作成することが望ましい。この図を活用することで、具体的にどの測線（区分断面）の水理条件の変化又は観測・算出の異常によるものであるかを特定することができる。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜参考となる資料＞

その他、水位流量曲線の精度に影響を与える要素の確認手法については、下記の資料が参考となる。

1.  国土交通省監修，(独)土木研究所編著：水文観測，第5章
    観測記録の整理と保存 5･6 水位流量曲線，全日本建設技術協会，2002.

    1.  []{#_Toc80951513 .anchor}標準照査

＜標　準＞

+----------------------------------------------------------------------+
| 標準照査は、観測機器を設置・計測値の回                               |
| 収等を行う事務所等が、照査の対象とする当該水文観測所ごとの水文観測デ |
| ータを用いて行う照査であり、「水文観測データ品質照査要領」に基づき、 |
| 異常値補正では検知できない異常値を検出し、修正することを標準とする。 |
|                                                                      |
| 標準照査によって正常値と                                             |
| 判断された観測値及び修正を実施した観測値については、「水文観測業務規 |
| 程」第14条の各事務所長が地方整備局長に報告する水文観測データとなる。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  水文観測データ品質照査要領，平成26年3月20日，国水情第46号，国土交通省水管理・国土保全局河川計画課長通知

    （最新版）水文観測データ品質照査要領，令和5年3月29日，国水情第42号，国土交通省水管理・国土保全局河川計画課長通知.

```{=html}
<!-- -->
```
1.  雨量の標準照査

＜必　須＞

+----------------------------------------------------------------------+
| 雨量について、以                                                     |
| 下のような極端な値が観測されていないか、照査を行わなければならない。 |
|                                                                      |
| > １)                                                                |
| > 雨量観測                                                           |
| 所ごとに時間雨量上限値を定め、それを超過する時間雨量記録を検出する。 |
| >                                                                    |
| > ２)                                                                |
| > 雨量観測所ごとに月ごとの最大時間雨量                               |
| の平均と標準偏差を求め、統計的に極端に大きい時間雨量記録を検出する。 |
| >                                                                    |
| > ３)                                                                |
| > 雨量                                                               |
| 観測所ごとに日雨量上限値を定め、それを超過する日雨量記録を検出する。 |
| >                                                                    |
| > ４)                                                                |
| > 雨量観測所ごとに月ごとの最大日雨                                   |
| 量の平均と標準偏差を求め、統計的に極端に大きい日雨量記録を検出する。 |
|                                                                      |
| 上記により抽出された極端に大きい観測値について、正常値か異           |
| 常値かを判断する。異常値の場合は、欠測とするか仮値で補填するかを判断 |
| する。これらの判断基準・方法については、関連通知等によるものとする。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  水文観測データ品質照査要領，平成26年3月20日，国水情第46号，国土交通省水管理・国土保全局河川計画課長通知

    （最新版）水文観測データ品質照査要領，令和5年3月29日，国水情第42号，国土交通省水管理・国土保全局河川計画課長通知.

```{=html}
<!-- -->
```
62. 水文観測データ品質照査の手引き（案），平成26年3月20日，国土交通省水管理・国土保全局河川計画課課長補佐事務連絡

    （最新版）水文観測データ品質照査の手引き（改定案），令和5年3月29日，国土交通省水管理・国土保全局河川計画課課長補佐事務連絡.

**（２） 水位の標準照査**

＜必　須＞

+----------------------------------------------------------------------+
| 水位について、以                                                     |
| 下のような極端な値が観測されていないか、照査を行わなければならない。 |
|                                                                      |
| > １)                                                                |
| > 水位観測設備ごとにその観測所でとり得                               |
| る値の上・下限値を設定しておき、それらを超過する水位記録を検出する。 |
| >                                                                    |
| > ２)                                                                |
| > 水位観測設備ごとに1時間当たりの水位変動                            |
| 量の上・下限値を定めておき、それらを超過する水位変動記録を検出する。 |
| >                                                                    |
| > ３)                                                                |
| > 水位観測設備ごとに同じ水位が継続する時間                           |
| の上限値を定めておき、それを超過する同一水位継続時間記録を検出する。 |
|                                                                      |
| 上記により抽出された極端な観測値について、正常値か異                 |
| 常値かを判断する。異常値の場合は、欠測とするか仮値で補填するかを判断 |
| する。これらの判断基準・方法については、関連通知等によるものとする。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  水文観測データ品質照査要領，平成26年3月20日，国水情第46号，国土交通省水管理・国土保全局河川計画課長通知

    （最新版）水文観測データ品質照査要領，令和5年3月29日，国水情第42号，国土交通省水管理・国土保全局河川計画課長通知.

```{=html}
<!-- -->
```
63. 水文観測データ品質照査の手引き（案），平成26年3月20日，国土交通省水管理・国土保全局河川計画課課長補佐事務連絡

    （最新版）水文観測データ品質照査の手引き（改定案），令和5年3月29日，国土交通省水管理・国土保全局河川計画課課長補佐事務連絡.

**（３） その他**

＜推　奨＞

+----------------------------------------------------------------------+
| 流量観測データにつ                                                   |
| いても、観測機器を設置・計測値の回収等を行う事務所等が、当該流量観測 |
| 所ごとの水文観測データを用いて、水位流量曲線式の水理水文学的な妥当性 |
| について照査を行い、その品質の確保・向上に万全を期すことが望ましい。 |
|                                                                      |
| 具体的には、水位流量曲線の基となった                                 |
| 水文観測データや流量算出過程等の妥当性（現地照査で異常可能性を指摘さ |
| れたデータの扱いの最終判定を含む）、水位流量曲線式の更新・分離・選定 |
| ・作成過程の妥当性について再確認を行う。その際、5.3.2(3)に紹介した図 |
| 群に加えて、年間横断面図や水位流量曲線～横断面図を活用する。これによ |
| り水位流量曲線の作成過程全般を照査し、不適切な計測値や算定値の採用、 |
| 不適切な作成過程がある場合には、それらを除き適切に作成し直すことで、 |
| 水位流量曲線の補正を図り、流量算出値の精度確保を図ることが望ましい。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

水位流量曲線の精度改善方策の詳細については、下記の資料が参考となる。

1.  国土交通省監修，(独)土木研究所編著：水文観測，第5章
    観測記録の整理と保存 5･6 水位流量曲線，全日本建設技術協会，2002.

    1.  []{#_Toc80951514 .anchor}高度照査

＜標　準＞

+----------------------------------------------------------------------+
| 高度照査は、原則として、地方整備局等、広域の水                       |
| 文観測資料を取りまとめる立場の組織が、当該水文観測所の観測データを対 |
| 象に、周辺近傍の複数の水文観測所の観測データを用いて行う照査である。 |
|                                                                      |
| 高度照査は、水文観測データ品質照査要領に基づき、標                   |
| 準照査を経ても検知できない異常値を検出し、修正することを標準とする。 |
+----------------------------------------------------------------------+

1.  雨量の高度照査

＜必　須＞

+----------------------------------------------------------------------+
| 雨量について、以下                                                   |
| の観点から異常な値が観測されていないか、照査を行わなければならない。 |
|                                                                      |
| > １) 近隣雨量の相関（日雨量）                                       |
| >                                                                    |
| > ２) 近隣雨量の相関（総雨量）\                                      |
| > 総雨量をとる期間は、１か月とする。                                 |
|                                                                      |
| 詳細は関連通知等によるものとする。                                   |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  水文観測データ品質照査要領，平成26年3月20日，国水情第46号，国土交通省水管理・国土保全局河川計画課長通知

    （最新版）水文観測データ品質照査要領，令和5年3月29日，国水情第42号，国土交通省水管理・国土保全局河川計画課長通知.

```{=html}
<!-- -->
```
64. 水文観測データ品質照査の手引き（案），平成26年3月20日，国土交通省水管理・国土保全局河川計画課課長補佐事務連絡

    （最新版）水文観測データ品質照査の手引き（改定案），令和5年3月29日，国土交通省水管理・国土保全局河川計画課課長補佐事務連絡.

```{=html}
<!-- -->
```
32. 水位の高度照査

＜必　須＞

+----------------------------------------------------------------------+
| 水位について、以下                                                   |
| の観点から異常な値が観測されていないか、照査を行わなければならない。 |
|                                                                      |
| > １）水位の上下流相関\                                              |
| > 上下流２地点の水位観測設備について、時差を考慮した相関を確認する。 |
| >                                                                    |
| > ２）水位の急激な増減\                                              |
| > 上流域の雨量との関係で、水位の増減が異常でないかを確認する。       |
| >                                                                    |
| > ３）ピーク水位の発生順序\                                          |
| > 上                                                                 |
| 下流の水位を比較して、ピークが妥当な順序で生起しているかを確認する。 |
|                                                                      |
| 詳細は関連通知等によるものとする。                                   |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  水文観測データ品質照査要領，平成26年3月20日，国水情第46号，国土交通省水管理・国土保全局河川計画課長通知

    （最新版）水文観測データ品質照査要領，令和5年3月29日，国水情第42号，国土交通省水管理・国土保全局河川計画課長通知.

```{=html}
<!-- -->
```
65. 水文観測データ品質照査の手引き（案），平成26年3月20日，国土交通省水管理・国土保全局河川計画課課長補佐事務連絡

    （最新版）水文観測データ品質照査の手引き（改定案），令和5年3月29日，国土交通省水管理・国土保全局河川計画課課長補佐事務連絡.

```{=html}
<!-- -->
```
33. 流量の高度照査

＜標　準＞

+----------------------------------------------------------------------+
| 流量について、以下                                                   |
| の観点から異常な値が観測されていないか、照査を行わなければならない。 |
|                                                                      |
| > １）ピーク流量の発生順序\                                          |
| > 上                                                                 |
| 下流の流量を比較して、ピークが妥当な順序で生起しているかを確認する。 |
| >                                                                    |
| > ２）水位流量曲線の妥当性\                                          |
| > 水位流量曲線の水理水文学的な妥当性を判定する。                     |
| >                                                                    |
| > 詳細は関連通知等によるものとする。                                 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  水文観測データ品質照査要領，平成26年3月20日，国水情第46号，国土交通省水管理・国土保全局河川計画課長通知

    （最新版）水文観測データ品質照査要領，令和5年3月29日，国水情第42号，国土交通省水管理・国土保全局河川計画課長通知.

```{=html}
<!-- -->
```
66. 水文観測データ品質照査の手引き（案），平成26年3月20日，国土交通省水管理・国土保全局河川計画課課長補佐事務連絡

    （最新版）水文観測データ品質照査の手引き（改定案），令和5年3月29日，国土交通省水管理・国土保全局河川計画課課長補佐事務連絡.

＜推　奨＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  高度照査は、得られた水文資料を河川の計画・管理に幅広く活用する観点から、水文資料（雨量・水位・流量）が相互に大きな矛盾がなく、河川流域全体の降雨～流出現象を精度良く把握し、信頼性の高い資料となっていることを確認する水文資料の相互比較照査も含めて実施しておくことが望ましい。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜例　示＞

+------------------------------------------------------------------------+
| 水文資料の相互比較による照査は、以下に示す照査項目を参考に実施する。   |
|                                                                        |
| > １) 降雨・流出ハイドログラフの時系列の関係                           |
| >                                                                      |
| > ２) 短時間降雨強度と流出ピーク流量の関係                             |
| >                                                                      |
| > ３) 降雨（流域平均累加雨量）と流出高（累加流出高）の関係             |
| >                                                                      |
| > ４) 同一河川の上下流にある複数の流量観測所の年間総流量・比流量の比較 |
| >                                                                      |
| > ５) 水収支解析や流出解析による照査                                   |
+------------------------------------------------------------------------+

＜例　示＞

+----------------------------------------------------------------------+
| 下記に示す                                                           |
| 水系時間流量図（図2-5-7）は、流量における高度照査の一つの例である。  |
|                                                                      |
| 同一グラフ上に水系の上                                               |
| 流～中流～下流に存する複数の流量観測所の洪水流量ハイドログラフを描い |
| て、各流量観測所の流量ハイドログラフを相互に比較対照する。これにより |
| 、ピーク流量の発生順序だけではなく、その形状・変化や総流量等が水収支 |
| を含めた総合的な観点から不合理でないかを概観し、各流量観測所の流量を |
| 算出したそれぞれの水位流量曲線の良否、その不具合いな部分を点検する。 |
|                                                                      |
| ![](media/image24.png){width="5.479166666666667in"                   |
| height="3.5416666666666665in"}                                       |
|                                                                      |
| 11. 水系時間流量図                                                   |
+----------------------------------------------------------------------+

1.  []{#_Toc80951515 .anchor}保存

＜必　須＞

  --------------------------------------------------------------------------------------------------------------------
  観測され、照査を経た水文資料は、水文観測業務規程及び同細則に定められた様式に基づき整理し、保存しなければならない。
  --------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1.  水文観測業務規程，平成29年3月31日，国水情第44号，国土交通事務次官通達，第4章
    観測成果の整理，報告，保存及び公表.

```{=html}
<!-- -->
```
67. 水文観測業務規程細則，平成29年3月31日，国水情第45号，国土交通省水管理・国土保全局通達，第4章
    観測成果.

＜推　奨＞

+----------------------------------------------------------------------+
| カテゴリー２や３                                                     |
| の観測によって得られた水文資料についても、洪水の把握などに資するもの |
| であり、観測されたデータについては、一定期間保存することが望ましい。 |
|                                                                      |
| な                                                                   |
| お、カテゴリー２や３における観測の性質上、保存されたデータは照査を実 |
| 施していないことがあるため、利用に当たっては十分留意する必要がある。 |
+----------------------------------------------------------------------+

**調査編**

7.  **水文・水理観測**

**第6節　地下水観測**

**目　次**

[第6節 地下水観測 1](#_Toc80951951)

> [6．1 総説 1](#_Toc80951952)
>
> [6．2 地下水調査の目的 2](#_Toc80951953)
>
> [6．3 予備調査項目 3](#_Toc80951954)
>
> [6．3．1 予備調査項目 3](#_Toc80951955)
>
> [6．3．2 地形・土地利用調査 4](#_Toc80951956)
>
> [6．3．3 地下水利用実態調査 4](#_Toc80951957)
>
> [6．3．4 水文調査 4](#_Toc80951958)
>
> [6．4 本調査項目 5](#_Toc80951959)
>
> [6．4．1 地下水位調査 5](#_Toc80951960)
>
> [6．4．2 地質調査 6](#_Toc80951961)
>
> [6．4．3 地下水水質調査 6](#_Toc80951962)
>
> [6．4．4 地下水流動調査 7](#_Toc80951963)
>
> [6．4．5 地下水涵養量調査 7](#_Toc80951964)
>
> [6．4．6 地盤沈下量調査 8](#_Toc80951965)

令和４年６月　版

適用上の位置付け

　河川砂防技術基準調査編は、基準の適用上の位置付けを明確にするために、下表に示すように適用上の位置付けを分類している。

+--------+------------------+------------------+------------------+
| 分　類 | 適用上の位置付け | 末尾の字句例     |                  |
+--------+------------------+------------------+------------------+
| 考え方 | 技術資料         | ●目              | 「･･･ある。      |
|        |                  | 的や概念、考え方 | 」「･･･いる。」  |
|        |                  | を記述した事項。 |                  |
|        |                  |                  | 「･･･なる。      |
|        |                  |                  | 」「･･･れる。」  |
+--------+------------------+------------------+------------------+
| 必　須 | 技術基準         | ●法令による規定  | 「･･･なければ    |
|        |                  | や技術的観点から | ならない。」「･  |
|        |                  | 実施すべきである | ･･ものとする。」 |
|        |                  | ことが明確であり |                  |
|        |                  | 遵守すべき事項。 |                  |
+--------+------------------+------------------+------------------+
| 標　準 | 技術基準         | ●特              | 「･･･            |
|        |                  | 段の事情がない限 | を標準とする。」 |
|        |                  | り記述に従い実施 |                  |
|        |                  | すべきだが、状況 | 「･･･            |
|        |                  | や条件によって一 | を基本とする。」 |
|        |                  | 律に適用すること |                  |
|        |                  | はできない事項。 | 「･･･による。」  |
+--------+------------------+------------------+------------------+
| 推　奨 | 技術資料         | ●状況や条件      | 「               |
|        |                  | によって実施する | ･･･望ましい。」  |
|        |                  | ことが良い事項。 |                  |
|        |                  |                  | 「               |
|        |                  |                  | ･･･推奨する。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･務める。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･必要に応    |
|        |                  |                  | じて･･･する。」  |
+--------+------------------+------------------+------------------+
| 例　示 | 技術資料         | ●適用条件や実施  | 「               |
|        |                  | 効果について確定 | ･･･などの手法（  |
|        |                  | している段階では | 事例）がある。」 |
|        |                  | ないが、状況や条 |                  |
|        |                  | 件によっては導入 | 「･･･など        |
|        |                  | することが可能な | の場合がある。」 |
|        |                  | 新技術等の例示。 |                  |
|        |                  |                  | 「･･･など        |
|        |                  | ●状              | が考えられる。」 |
|        |                  | 況や条件によって |                  |
|        |                  | 限定的に実施でき | 「               |
|        |                  | る技術等の例示。 | ･･･の場合には･･･ |
|        |                  |                  | ことができる。」 |
|        |                  | ●具体的          |                  |
|        |                  | に例示することに | 「               |
|        |                  | より、技術的な理 | ･･･例示する。」  |
|        |                  | 解を助ける事項。 |                  |
|        |                  |                  | 「例えば･･･。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･事例もある  |
|        |                  |                  | 。･･･もよい。」  |
+--------+------------------+------------------+------------------+

  関連通知等       関連する通知やそれを理解する上で参考となる資料
  ---------------- ------------------------------------------------------
  参考となる資料   例示等に示した手法・内容を理解する上で参考となる資料

1.  []{#_Toc80951951 .anchor}地下水観測

    1.  []{#_Toc80951952 .anchor}総説

＜考え方＞

  ----------------------------------------------------------------------------------------------
  本節では、地下水に関連した調査に必要な基礎的事項と現地調査の標準的な手法を定めるものである。
  ----------------------------------------------------------------------------------------------

＜必　須＞

  ------------------------------------------------------------------------------------------------------------------------
  地下水調査は、対象地域の特性を十分把握した上で、所期の目的が達成できるよう、系統的かつ効率的に実施しなければならない。
  ------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1.  水文観測業務規程，平成29年3月31日，国水情第44号，国土交通事務次官通達.

```{=html}
<!-- -->
```
68. 水文観測業務規程細則，平成29年3月31日，国水情第45号，国土交通省水管理・国土保全局通達.

＜参考となる資料＞

地下水調査を実施する際には、下記の法規・図書類がある。地盤沈下対策としての地下水揚水規制については、以下の法律に規定されている。

1.  工業用水法，昭和31年6月11日，法律第146号，最終改正：令和4年6月17日法律第68号.

```{=html}
<!-- -->
```
69. 建築物用地下水の採取の規制に関する法律，昭和37年5月1日，法律第
    100号，最終改正：令和4年6月17日法律第68号.

地下水汚染、土壌汚染に関する有害物質の基準値については、以下の法律に規定されている。

70. 環境基本法，平成5年11月19日，法律第91号，最終改正：令和3年5月19日法律第36号.

71. 土壌汚染対策法，平成14年5月29日，法律第53号，最終改正：令和4年6月17日法律第68号.

地下水の適正な保全及び利用については、以下の法律に規定されている。

72. 水循環基本法，平成 26 年 4 月 2 日,法律第 16 号,最終改正：令和 3 年
    9 月 1 日法律第 36号.

上記のほか、わが国における地下水に関する規制としては、以下のものがある。

73. 地盤沈下防止等対策要綱.

> 濃尾平野地盤沈下防止等対策要綱，昭和60年4月26日，最終改正：平成7年9月5日.
>
> 筑後・佐賀平野地盤沈下防止等対策要綱，昭和60年4月26日，最終改正：平成7年9月5日.
>
> 関東平野北部地盤沈下防止等対策要綱，平成3年11月29日.

74. 調査対象地域の地方自治体が定める条例・要綱等（地下水の採取の適正化に関する条例，地下水保全条例等）.

詳細な調査方法については、下記の資料が参考となる。

75. 建設省河川局監修，(財)国土開発技術研究センター編集：地下水調査および観測指針（案），山海堂，1993.

＜例　示＞

+--------------------------------------------------------+
| 地下水調査を行うに当たっての一般的な手順を以下に示す。 |
|                                                        |
| 12. 地下水調査の一般的な手順                           |
|                                                        |
| （「地下水調査及び観測指針（案）」に加筆）             |
+--------------------------------------------------------+

1.  []{#_Toc80951953 .anchor}地下水調査の目的

＜考え方＞

+----------------------------------------------------------------------+
| 過去多く実施されてきた地下水調査は、以下のとおりである。             |
|                                                                      |
| １）地下水賦存量の把握                                               |
|                                                                      |
| 地下水賦存量の把握は、地下水の資源としての量と質を評価し             |
| 、開発可能量を把握するために実施する。特に、地下水枯渇といった障害を |
| 発生させずに持続的に地下水を利用するために、地下水の適正採取量を把握 |
| し、地下水の保全・利用に関する計画を策定・運用することが重要である。 |
|                                                                      |
| ２）河川水と地下水の関係把握                                         |
|                                                                      |
| 河川水と地下水の関係把握は                                           |
| 、両者の定量的な相互関係を把握し、河川のある区間、地下空間又は河川流 |
| 域での水収支を検討することを主な目的として実施する。なお、正常流量の |
| 設定においても、地下水への影響を考慮して検討を行うことが必要である。 |
|                                                                      |
| ３）地盤沈下の実態把握                                               |
|                                                                      |
| 地盤沈下の実態の把握、原因の追求、沈下                               |
| 量の予測及び地盤沈下による障害の防止対策の検討を目的として実施する。 |
|                                                                      |
| ４）地下水汚染状況の把握                                             |
|                                                                      |
| 地下水汚染の実態の把握、汚染原因の特                                 |
| 定、汚染防止対策・汚染地下水の浄化方法の検討等を目的として実施する。 |
|                                                                      |
| ５）地下掘削工事に関わる影響評価                                     |
|                                                                      |
| 遮水                                                                 |
| 構造物の設置など、その規模が長大で地下水流動の大半を遮断するおそれが |
| ある場合、上流側で地下水位の上昇、下流側で地下水位の低下が生じるおそ |
| れがある場合などに構造物による地下水障害の防止を目的として実施する。 |
|                                                                      |
| ６）河川堤防及び周辺基礎地盤の地下水状況の把握                       |
|                                                                      |
| 堤防の                                                               |
| 安全性評価、被災原因等の解明とその対策工の検討を目的として実施する。 |
|                                                                      |
| ７）斜面の地下水状況の把握                                           |
|                                                                      |
| 地すべりあるいは斜面崩                                               |
| 壊の原因を特定し、対策工法並びに予測方法の検討を目的として実施する。 |
|                                                                      |
| ８）ダム周辺の地下水調査                                             |
|                                                                      |
| ダム基礎地盤及び貯水池周辺地山                                       |
| の遮水性や浸透破壊抵抗性等の水理地質構造の把握を目的として実施する。 |
|                                                                      |
| 各種地下水調査の目的に応じて、予備調                                 |
| 査項目(6.3)、本調査項目(6.4)の中から必要な項目を選定し、実施する。事 |
| 業の環境影響評価においても、必要に応じて地下水調査を行う必要がある。 |
|                                                                      |
| なお、「6)河川堤防及び周辺基礎地盤                                   |
| の地下水状況の把握」及び「8)ダム周辺の地下水調査」については、第15章 |
| 土質地質調査、「7)斜面の地下水状況の把握」については、第18章         |
| 地すべり調査 及び 第19章 急傾斜地調査 によるものとする。             |
+----------------------------------------------------------------------+

2.  []{#_Toc80951954 .anchor}予備調査項目

    1.  []{#_Toc80951955 .anchor}予備調査項目

＜考え方＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  予備調査は、本調査を効率的に遂行するために実施するものであり、調査地域周辺の地形地質、土地利用・植生、気象・水文、地下水利用実態等の情報を収集・整理し、本調査の効率的遂行に資することを目的とする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

  -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  本調査に先立ち、予備調査を実施することを標準とする。予備調査は大きく資料調査と現地予察調査に分類される。資料調査で収集・整理する資料は、①地形図・地形分類図、②地質図・表層地質図・水文地質図、③周辺地盤情報（ボーリングデータなど）、④土壌図、⑤空中写真、⑥衛星画像、⑦土地利用、⑧気象・水文、⑨地下水とその利用状況、⑩地下水障害、⑪地下水質などが挙げられる。また、現地予察調査は、資料調査の成果を確認・吟味・補完することを目的として実施する。
  -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜参考となる資料＞

予備調査の詳細については、下記の資料が参考となる。

1.  建設省河川局監修，(財)国土開発技術研究センター編集：地下水調査および観測指針（案），pp.59-72，山海堂，1993.

```{=html}
<!-- -->
```
76. 地下水ハンドブック編集委員会：地下水ハンドブック，pp.223-387，建設産業調査会，1998.

    1.  []{#_Toc80951956 .anchor}地形・土地利用調査

＜考え方＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  地形・土地利用調査は、地形から地下水流動系あるいは地下水の湧出の状況を推定するとともに、土地利用の実態から水の利用、表流水の浸透・涵養を把握し、地下水と表流水との関係を検討するために実施する。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------
  地下水面は、地形と密接な関係を持つため、既存資料の利用、空中写真、現地調査等を通じて実施することを標準とする。
  ----------------------------------------------------------------------------------------------------------------

＜参考となる資料＞

地形・土地利用調査の詳細については、下記の資料が参考となる。

1.  建設省河川局監修，(財)国土開発技術研究センター編集：地下水調査および観測指針（案），pp.73-84，山海堂，1993.

```{=html}
<!-- -->
```
77. 地下水ハンドブック編集委員会：地下水ハンドブック，pp.223-387，建設産業調査会，1998.

    1.  []{#_Toc80951957 .anchor}地下水利用実態調査

＜考え方＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  地下水利用実態調査は、地下水利用施設の分布、規模、取水量実績を把握することにより、地下水賦存量や流動、水収支、地下水の開発・保全策等の検討に利用することを目的として実施する。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 地下水は、井戸をはじめとした揚水施設に                               |
| より利用され、また、自然的に流出し形成されている湧水池等においても利 |
| 用される。対象地域の地下水賦存・流動状況は、これらの地下水利用の影響 |
| を受けるため、地下水の適切な管理を実施するためにはその対象地域の取水 |
| 位置分布や地下水取水量の把握が重要である。地下水利用実態調査は、既存 |
| 資料調査、アンケート調査・訪問調査などを通じて行うことを標準とする。 |
|                                                                      |
| 資料調査では、条例によっ                                             |
| て地下水利用の届出義務が制定されている自治体では地下水利用の実態に関 |
| する報告書が作成されており、これにより地下水利用の現状が把握できる。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

1.  建設省河川局監修，(財)国土開発技術研究センター編集：地下水調査および観測指針（案），pp.85-93，山海堂，1993.

    1.  []{#_Toc80951958 .anchor}水文調査

＜考え方＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------
  水文調査は、水循環の量的把握に必要な資料を得ることを目的とし、必要に応じて、水文気象、表流水・伏流水流量、蒸発散量、土壌水分量、浸透量等の項目について実施する。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  地下水は河川水、湖沼等の表流水及び不飽和帯に存在する水としての土壌水とは相互依存関係にあるため、水循環を量的に把握するためには地下水そのもののを把握するだけでなく、降水量、蒸発散量、表流水流量、土壌水分等の水文要素を把握することも重要である。水文調査は、水文気象調査、表流水流量調査、蒸発散量調査、土壌水分調査等の実施を標準とする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜参考となる資料＞

調査方法の詳細については、下記の資料が参考となる。

1.  建設省河川局監修，(財)国土開発技術研究センター編集：地下水調査および観測指針（案），pp.95-119，山海堂，1993.

    1.  []{#_Toc80951959 .anchor}本調査項目

        1.  []{#_Toc80951960 .anchor}地下水位調査

＜考え方＞

  ----------------------------------------------------------------------------------------------------------------------------------------
  地下水位調査は、地下水調査の基礎として、地下水位の空間的分布及び経時変化を把握し、地下水の賦存量や流動系を明らかにするために実施する。
  ----------------------------------------------------------------------------------------------------------------------------------------

1.  観測所と観測井

＜必　須＞

  --------------------------------------------------------------------------------------------------------------
  地下水位観測所は、観測対象地下水域の特性を考慮し、所期の目的が達成できるように適切に配置しなければならない。
  --------------------------------------------------------------------------------------------------------------

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  地下水流動系の範囲や地質条件は、調査対象地域によって異なり、また、調査の目的によって明らかにすべき地下水現象の内容や精度も大きく異なってくる。よって、地下水位調査における観測所の配置計画に当たっては、このような条件の違いを考慮して適切な数や配置を決定することを標準とする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

34. 一斉観測と長期観測

＜考え方＞

+----------------------------------------------------------------------+
| 地下水位調査には、大きく分けて一斉                                   |
| 観測と長期観測の二つの種類があり、この違いにより調査の方法が異なる。 |
|                                                                      |
| 一斉観                                                               |
| 測は一般に、地下水流動系の動水勾配を求めるために、観測所をできるだけ |
| 密な間隔で配置し、主に可搬式の水位測定器を用いて短期間に一斉に水位観 |
| 測を行うことにより、その地域の地下水体の賦存状況や地下水流動を知ろう |
| とするものである。特定の地域の地下水収支の把握、建設工事の地下水への |
| 影響の予測、地下水汚染の経路の追跡等、種々の目的のために実施される。 |
|                                                                      |
| 長期観測では、原則                                                   |
| 的に1年以上の観測を専用の観測井で自記水位計により行うのが一般的であ  |
| る。この結果は、地下水位変動曲線等の形式で整理され、建設工事の影響調 |
| 査、地盤沈下調査をはじめとした地下水変動要因の解析等に役立てられる。 |
+----------------------------------------------------------------------+

35. 地下水位等高線図、地下水位変動図等の作成

＜標　準＞

  -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  観測データは、地下水解析の用に供されるほか、必要に応じて予備調査項目(6.3)で述べた地形・土地利用あるいは水文調査等のデータを加えて、地下水位等高線図、地下水位変動図等を作成し、変動原因の分析等に利用することを標準とする。
  -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜参考となる資料＞

地下水位調査に関する詳細については、下記の資料が参考となる。

1.  建設省河川局監修，(財)国土開発技術研究センター編集：地下水調査および観測指針（案），pp.121-138，山海堂，1993.

```{=html}
<!-- -->
```
78. 地下水ハンドブック編集委員会：地下水ハンドブック，pp.223-387，建設産業調査会，1998.

    1.  []{#_Toc80951961 .anchor}地質調査

＜考え方＞

+----------------------------------------------------------------------+
| 地質調査は、地層の空間的分布とその水理特性を把握し、地               |
| 下水の賦存状況、流動状況等を明らかにすることを目的とするものである。 |
|                                                                      |
| リモートセンシングは、広域の水文地質構                               |
| 造調査や水資源調査及び、土地利用状況などの変化を把握するものである。 |
|                                                                      |
| 物理探査は、地盤の物理特性を利用して地質状況を把握するものである。   |
|                                                                      |
| ボーリングは、水理地質構造や地質を直接的に確認するものである。       |
|                                                                      |
| 現場透水試験は、地層の透水係数を原位置で把握するものである。         |
|                                                                      |
| 揚水試験（帯水層試験）は地下水調査において帯水層の水理定数（透水係   |
| 数、貯留係数）あるいは揚水井の性能（適正揚水量）を求めるものである。 |
|                                                                      |
| 土質試験は帯水層の物性値（透水性等）を把握するものである。           |
|                                                                      |
| 地質調査については、第15章 土質地質調査 によるものとする。           |
+----------------------------------------------------------------------+

＜必　須＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  現地踏査、リモートセンシング、物理探査、ボーリング、現場透水試験、揚水試験（帯水層試験）及び土質試験等から、現場の状況に応じて適切な調査項目を選択して実施しなければならない。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

2.  []{#_Toc80951962 .anchor}地下水水質調査

＜考え方＞

+----------------------------------------------------------------------+
| 地下水水質調査は、                                                   |
| 特定の汚染源による地下水汚染状況調査、長期的な水質変                 |
| 化を調べるための調査、地下水流動調査に伴う水質調査などに分けられる。 |
|                                                                      |
| 地下水水質調査については、第12章 水質・底質調査 によるものとする。   |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 水質型の                                                             |
| 分類、基準との照合、その他調査目的の達成に必要な項目を選び、試験目的 |
| に応じてそれぞれ定められた基準等に準拠して実施することを標準とする。 |
|                                                                      |
| 地下水水質調査のうち地下水汚染状況調査については、予備               |
| 調査・現地踏査により、地形・土地利用及び地下水利用実態を把握する。地 |
| 下水汚染源になり得る土地利用及び活用可能な既設井戸の位置等の情報を基 |
| に、詳細な地下水汚染状況の調査計画を立案、実施することを標準とする。 |
|                                                                      |
| 帯水層別に調査を実施する必要がある場合は、既存資料や必               |
| 要に応じて実施する地質調査の結果を利用し、水理地質構造を十分把握する |
| 。なお、水質調査のための井戸を新たに掘削する場合には、掘削によって未 |
| 汚染の帯水層を汚染することがないよう、十分留意することを標準とする。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

地下水汚染は土壌汚染と密接な関係があるので、地下水汚染調査を実施する場合は**、**下記の資料が参考となる。

1.  土木研究所編集：建設工事で遭遇する地盤汚染対応マニュアル（改訂版），鹿島出版会，2012.

```{=html}
<!-- -->
```
79. 建設工事における自然由来重金属等含有岩石・土壌への対応マニュアル（暫定版），平成22年3月，国土交通省，建設工事における自然由来重金属等含有土砂への対応マニュアル検討委員会.

    （最新版）建設工事における自然由来重金属等含有岩石・土壌への対応マニュアル（2023年版），令和5年3月，国土交通省，建設工事における自然由来重金属等含有土砂への対応マニュアル検討委員会.

    1.  []{#_Toc80951963 .anchor}地下水流動調査

＜考え方＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  地下水流動調査は、地下水の流れを水循環の一環として捉え、空間的な広がりを持つ連続した系として認識し、地下水流動の実態を解明することを目的として実施する。**地下水流動系調査においては、直接計測だけで流動系を推定することは困難であるため、直接計測と併せて地下水流動方程式に基づく解析的な手法が適用される。**
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜必　須＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  地下水の流動は、涵養－流動－流出が一つの流動系として三次元的な広がりを持って生じるものである。よって調査はこの一つの流動系の規模を勘案し、その他の現地の条件等も考慮しながら所期の目的が達成できるように適切な方法で実施しなければならない。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  対象地域の三次元的な地下水流動系の実態を明らかにする方法としては、(1)私有の井戸を含めた既存の井戸やピエゾメータ群によって地下水のポテンシャル分布を直接測定する方法、(2)数値シミュレーションによって地下水の流動方程式を境界値問題として解き、地下水のポテンシャル分布を得る方法、(3)同位体や水温・水質をトレーサとして地下水の流れを推定する方法などが挙げられる。しかし、広域にわたる解析においては、解析に必要な十分な基礎的データを得ることが困難である場合が多いので、どれか一つの方法だけで広域地下水流動の実態を明らかにすることは難しい。したがって、(1)と(2)による調査を基本とし、場合によって(3)を実施するなど、複数の方法を併用し、結果を相互にクロスチェックすることによってより正確な地下水流動系の実態を把握することを標準とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜参考となる資料＞

地下水ポテンシャルの概念、ダルシーの法則、地下水流動系の概念及び地下水流動の調査方法の詳細については、下記の資料が参考となる。

1.  建設省河川局監修，(財)国土開発技術研究センター編集：地下水調査および観測指針（案），pp.215-238，山海堂，1993.

    1.  []{#_Toc80951964 .anchor}地下水涵養量調査

＜考え方＞

  --------------------------------------------------------------------------------------------------
  地下水涵養量調査は、気象条件、地盤条件等から、地下水涵養の機構と涵養量を把握するために実施する。
  --------------------------------------------------------------------------------------------------

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  地下水の涵養量調査は、水収支による方法を標準とし、調査対象地域の規模、目的、現場条件等に応じて、土壌水分フラックスを測定する方法、ライシメータによる方法、土壌水をトレーサで追跡する方法などを必要に応じて実施することを標準とする。これらの調査は、比較的時間を費やすため、事前に調査対象地域の既存の調査結果や研究例を十分に調べることが必要である。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜参考となる資料＞

参考となる資料には、下記の資料が参考となる。

1.  建設省河川局監修，(財)国土開発技術研究センター編集：地下水調査および観測指針（案），pp.239-245，山海堂，1993.

    1.  []{#_Toc80951965 .anchor}地盤沈下量調査

＜考え方＞

+----------------------------------------------------------------------+
| 地盤沈下量調査は、地盤沈                                             |
| 下地域及び地盤沈下が予想される地域における沈下動向を把握することを目 |
| 的に実施する。地盤沈下量調査には、地下水揚水等を主因とする広域な地盤 |
| 沈下と堤防新設や拡築などに伴う地盤沈下を対象としたものに分けられる。 |
| ここでの地盤沈下とは、地下水揚水等を主因とする広域な地盤沈下を指す。 |
|                                                                      |
| なお堤防新設や拡築などに伴う地盤沈下については、第15章 土質地質調査  |
| による。                                                             |
+----------------------------------------------------------------------+

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  原則として、地下水揚水等を主因とする広域な地盤沈下の状況については、資料調査を行い把握する。また、現地における調査が必要な場合は、沈下観測井あるいは一級水準測量による観測を標準とする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

1.  沈下観測井による観測

＜標　準＞

+----------------------------------------------------------------------+
| 地盤沈下観測井は、原則として一等水準測線の近くに配置し、地域を代表   |
| する地点を選定することを標準とする。観測は、効果的かつ経済的な配置計 |
| 画の下で、所期の目的が達成できる構造と性能を有することを標準とする。 |
|                                                                      |
| 観測は原則として自記記録計により連続的に行い                         |
| 、観測値は必要な補正を行い累加沈下量として整理することを標準とする。 |
+----------------------------------------------------------------------+

36. 測量による観測

＜標　準＞

+----------------------------------------------------------------------+
| 水準点は、沈下区域又は、沈下が予想さ                                 |
| れる区域の周辺部を含む調査地域に、原則として1kmメッシュの密度で設け  |
| るものとし、沈下の状況や土質・地質、土地利用状況等の地域特性等に配慮 |
| して配置の増減を図ることを標準とする。観測は、効果的かつ経済的な観測 |
| 計画の下で、所定の精度を期待できる機器と方法とすることを標準とする。 |
|                                                                      |
| 測量                                                                 |
| 結果は、必要な補正・計算を施し、標高として整理することを標準とする。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

地盤沈下量調査の詳細については、下記の資料が参考となる。

1.  全国の地盤沈下地域の概況，環境省.

```{=html}
<!-- -->
```
80. 地盤沈下監視ガイドラインについて，平成17年6月29日，環水土発第050629007号，環境省環境管理局水環境部長通知.

81. 2)に基づく各自治体のガイドライン.

82. 全国地盤環境情報ディレクトリ，令和元年度版，環境省.

    （最新版）全国地盤環境情報ディレクトリ，令和5年度版，環境省.

83. 大西博文，山田俊哉，江橋英治，大野順通，脇坂安彦，佐々木靖人，三木博史，小橋秀俊，近藤升，他５名：道路環境影響評価の技術手法（その３），土木研究所資料，第3744号，10.地盤，2000.

**調査編**

8.  **水文・水理観測**

**第7節　河川の流れの総合的把握**

**目　次**

[第7節 河川の流れの総合的把握 1](#_Toc80953449)

> [7．1 総説 1](#_Toc80953450)
>
> [7．2 流れの総合的把握の実施例 2](#_Toc80953451)

令和４年６月　版

適用上の位置付け

　河川砂防技術基準調査編は、基準の適用上の位置付けを明確にするために、下表に示すように適用上の位置付けを分類している。

+--------+------------------+------------------+------------------+
| 分　類 | 適用上の位置付け | 末尾の字句例     |                  |
+--------+------------------+------------------+------------------+
| 考え方 | 技術資料         | ●目              | 「･･･ある。      |
|        |                  | 的や概念、考え方 | 」「･･･いる。」  |
|        |                  | を記述した事項。 |                  |
|        |                  |                  | 「･･･なる。      |
|        |                  |                  | 」「･･･れる。」  |
+--------+------------------+------------------+------------------+
| 必　須 | 技術基準         | ●法令による規定  | 「･･･なければ    |
|        |                  | や技術的観点から | ならない。」「･  |
|        |                  | 実施すべきである | ･･ものとする。」 |
|        |                  | ことが明確であり |                  |
|        |                  | 遵守すべき事項。 |                  |
+--------+------------------+------------------+------------------+
| 標　準 | 技術基準         | ●特              | 「･･･            |
|        |                  | 段の事情がない限 | を標準とする。」 |
|        |                  | り記述に従い実施 |                  |
|        |                  | すべきだが、状況 | 「･･･            |
|        |                  | や条件によって一 | を基本とする。」 |
|        |                  | 律に適用すること |                  |
|        |                  | はできない事項。 | 「･･･による。」  |
+--------+------------------+------------------+------------------+
| 推　奨 | 技術資料         | ●状況や条件      | 「               |
|        |                  | によって実施する | ･･･望ましい。」  |
|        |                  | ことが良い事項。 |                  |
|        |                  |                  | 「               |
|        |                  |                  | ･･･推奨する。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･務める。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･必要に応    |
|        |                  |                  | じて･･･する。」  |
+--------+------------------+------------------+------------------+
| 例　示 | 技術資料         | ●適用条件や実施  | 「               |
|        |                  | 効果について確定 | ･･･などの手法（  |
|        |                  | している段階では | 事例）がある。」 |
|        |                  | ないが、状況や条 |                  |
|        |                  | 件によっては導入 | 「･･･など        |
|        |                  | することが可能な | の場合がある。」 |
|        |                  | 新技術等の例示。 |                  |
|        |                  |                  | 「･･･など        |
|        |                  | ●状              | が考えられる。」 |
|        |                  | 況や条件によって |                  |
|        |                  | 限定的に実施でき | 「               |
|        |                  | る技術等の例示。 | ･･･の場合には･･･ |
|        |                  |                  | ことができる。」 |
|        |                  | ●具体的          |                  |
|        |                  | に例示することに | 「               |
|        |                  | より、技術的な理 | ･･･例示する。」  |
|        |                  | 解を助ける事項。 |                  |
|        |                  |                  | 「例えば･･･。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･事例もある  |
|        |                  |                  | 。･･･もよい。」  |
+--------+------------------+------------------+------------------+

  関連通知等       関連する通知やそれを理解する上で参考となる資料
  ---------------- ------------------------------------------------------
  参考となる資料   例示等に示した手法・内容を理解する上で参考となる資料

1.  []{#_Toc80953449 .anchor}河川の流れの総合的把握

    1.  []{#_Toc80953450 .anchor}総説

＜考え方＞

+----------------------------------------------------------------------+
| 本節では、本章 第1節で述べたカテゴリー３.１の観測について概説する。  |
|                                                                      |
| 流れの                                                               |
| 総合的把握とは、水位、流量など個別単独での観測ではその一部しか捉えら |
| れない洪水流の挙動を、それらを連携させた観測と解析により全体像を捉え |
| 、そこから必要な情報や知見を得ることを目的として実施するものである。 |
|                                                                      |
| 以下、その要諦を段階を追って説明する。                               |
|                                                                      |
| １）水理システムへの力学的な理解に基づく柔軟な未知数設定             |
|                                                                      |
| 次に示す                                                             |
| 最も単純な流れの抵抗則を用いて、このことを説明する。なお実際は、必要 |
| なレベルの（状況によってはより高度の）流れの基礎方程式が用いられる。 |
|                                                                      |
| $q = \frac{1}{n}\left( H - z \right)^                                |
| {\frac{5}{3}} \bullet \sqrt{\frac{H_{1} - H_{2}}{\mathrm{\Delta}x}}$ |
| （2-7-1）                                                            |
|                                                                      |
| ここで、q：単位幅当たりの流量、                                      |
| H：水位、z：河床高、n：マニングの粗度係数、H~1~：地点1（上流側）の水 |
| 位、H~2~：地点2（下流側）の水位、Δx：地点1、2間の縦断距離、である。  |
|                                                                      |
| > a）                                                                |
| > 上式で、河床高z、粗度係数nが既知で、ある時刻の水位（               |
| H，H~1~，H~2~）が観測されれば、流量qを得ることができる。これは、本章 |
| > 第4節 流量観測 の表2-4-1 に示した水面勾配断面積法の原理である。    |
| >                                                                    |
| > b）                                                                |
| > 河床高zが既知で、ある時刻の水位（H，H~1~，H~2                      |
| ~）と流量qが観測されれば、粗度係数nを得ることができる。これが、第5章 |
| > 河川における洪水流の水理解析 第5節 パラメータの設定                |
| > 5.2に示されている粗度係数の逆算（同定）法の原理である。            |
| >                                                                    |
| > c）                                                                |
| > 粗度係数nが既知で、ある時刻の水位（H，H~1~，                       |
| H~2~）と流量qが観測されれば、河床高zに関する情報を得ることができる。 |
| >                                                                    |
| > d）                                                                |
| > このようにして、水理システムの解析と観測項                         |
| 目との組合せの中で、目的や状況に応じ、得たい水理量を柔軟に設定する。 |
|                                                                      |
| ２）水理量による観測精度の違いを踏まえた戦略                         |
|                                                                      |
| 観測精度は水理量                                                     |
| によって異なり、一般に、水位（水深）の測定精度は流量観測精度に比べて |
| 高い。このことから、zとnが既知とできる条件では、流量の直接観測の精度 |
| 向上を目指すこととは別に、相対的に精度の高い水位測定結果を用いて、上 |
| 記１）a)のアプローチで流量を求めるという考え方が出てくる。また、やは |
| り測定が容易ではない洪水中の河床高について、それを直接測定する努力と |
| は別に、qとnを既知とできる条件で、水位測定結果から上記１）c)のアプロ |
| ーチで河床高の情報を得ようとする考え方が出てくる。このように、得たい |
| 水理量の直接観測だけにこだわらず、水理システムと関連付けられ、相対的 |
| に高い精度での測定が可能な水理量及び設定しやすい水理量を経由して、最 |
| 終的に求めたい水理量を得るという方法を、必要に応じ積極的に採用する。 |
|                                                                      |
| ３）水位の縦断方向多点観測及びその繰り返し実施                       |
|                                                                      |
| 縦断方向に細かいピッチで水                                           |
| 位の同時観測を行えば、式(2-7-1)を河川縦断方向についての流れの運動方  |
| 程式などに置き換えることで、未知とおいた水理量の縦断分布に関する情報 |
| を得ることができる。たとえば、粗度係数（より一般的には抵抗特性）の縦 |
| 断的な変化が明らかになれば、その原因を河道状況（河道形状や樹木群など |
| ）から特定することで、河道状況の管理に資する個別具体の情報を得ること |
| ができる。また、非定常流れに対して、こうした観測を繰り返し連続的に行 |
| い、非定常流れの基礎方程式を導入することで、流量の縦断分布とその時間 |
| 変化が、粗度係数あるいは河床高の時空間変化に関する一定の情報とともに |
| 得られると期待できる。こうして得られる情報は、河道内の洪水流量の下流 |
| への伝播特性などについて、直接流量観測だけによるよりも多くの情報を相 |
| 対的に高い精度で示すものと期待できる。さらに、こうした観測を、（自然 |
| ）分流地点や遊水地等を含む河川区間などに適用することで、分流特性や洪 |
| 水流量の縦断方向変化などについて詳細かつ精度の高い情報が得られると期 |
| 待される。こうした手法は、一種の同化手法の適用と位置付けられ、河川の |
| 流れの総合的把握においては、水位測定データを充実させることで、得られ |
| る情報量が大幅に増えるという以上の特性を、必要に応じ積極的に活かす。 |
|                                                                      |
| ４）河床変動や流砂量に関する情報把握への展開                         |
|                                                                      |
| 上                                                                   |
| 記３）までの積み上げを前提に、流れの計算に加えて河床変動計算（第6章  |
| 河床変動、河床材料変化及び土砂流送の解析                             |
| に記述）を組み合わせて実施するなどし                                 |
| て、実測値を説明できるための水理量算出というアプローチを流砂量にまで |
| 展開して、洪水中の流砂量に関する情報を得ようとする方法があり、第16章 |
| 総合的な土砂管理のための調査 第2節 調査の基本的組立て方              |
| 2                                                                    |
| .3.6(1）4)で紹介し、またこの方法の土砂流送特性把握における位置付けを |
| 第4章 河道特性調査 第6節 土砂流送特性 6.5                            |
| で説明している。こうした観測と解析の組                               |
| 合せは、洪水中に有意な河床変動が起こると考えられる河川区間（たとえば |
| 砂床の河口付近、分合流地点など）において、特にその意義が大きくなると |
| 期待される。このように、必要に応じて、「水理システム」に流砂と河床変 |
| 動に関するシステムも取り込み、獲得する情報、知見の範囲を広げていく。 |
|                                                                      |
| 「河川の流れの総合的把握」においては、水理システムを具体的に         |
| 表現する流れに関するモデル（場合によっては流砂と河床変動も合わせて） |
| のレベルと実測対象となる水理量の種類・量・質とのバランス及び適合性が |
| 重要となる。モデルのレベルには幅があるので、このバランスと適合性が取 |
| れている限り、目的や状況に応じた柔軟な実施法が選択できるとも言える。 |
|                                                                      |
| 以上に説                                                             |
| 明した「河川の流れの総合的把握」は、河川の流れ（必要に応じて流砂と河 |
| 床変動を含む）のシステムに関する理解や技術の進展の成果を円滑に実務に |
| 反映させる上での、また多くの扱うべき水理量がある中で総合的・戦略的視 |
| 点からより合理的な観測を実施する手法を見いだす上での基本フレームとな |
| るものであり、カテゴリー１、２の観測との相互補完性（図2-1-1参照）も  |
| 意識しつつ、必要な局面での積極的な実施を図っていくことが大事である。 |
+----------------------------------------------------------------------+

2.  []{#_Toc80953451 .anchor}流れの総合的把握の実施例

＜例　示＞

+----------------------------------------------------------------------+
| １）水位多点連続観測と非定常流解析による洪水伝播特性の把握           |
|                                                                      |
| 簡易自記式水位計を含む多数の水位観測値を用いて水                     |
| 位縦断分布の時間変化を観測し、水位観測結果を境界条件として与えた非定 |
| 常準二次元流解析又は非定常平面流解析を実施する。相対的に観測精度の高 |
| い水位縦断分布と一致させることを優先しつつ、かつ基準点における流量観 |
| 測結果と大きく乖離することなくかつその変化特性を再現できるように粗度 |
| 係数を設定する。以上の結果から、最大流量の流れ方向の変化や基準点にお |
| ける洪水流量の時間変化（ハイドログラフ）等の洪水伝播特性を把握する。 |
|                                                                      |
| ２）流速観測と抵抗則式による粗度係数の時空間的変化特性の把握         |
|                                                                      |
| 航空写真やビデオなどの画像解析により洪水流の平面                     |
| 流速分布を測定し、流速と水位の観測結果を抵抗則式（求められる精度に応 |
| じて、一次元又は平面流解析を使用してもよい）に与えて粗度係数を逆算す |
| る。逆算粗度を得た地点における地被（植生など）の抵抗特性を把握する。 |
|                                                                      |
| ３）山地河川における支川合流を取り込んだ洪水伝播特性の把握           |
|                                                                      |
| 本川に設置された複数の                                               |
| 水位観測所データを用いて支川合流点や本川上下流端において近接する水位 |
| 観測所の水位との関係式として流量を与える境界条件式を設定し、本節7.1  |
| 1)                                                                   |
| a)と同様に一次元非定常                                               |
| 流解析を実施する。以上の結果から、基準点における洪水流量の時間変化（ |
| ハイドログラフ）等の洪水伝播特性を把握する。なお、この手法は河川の横 |
| 流入出量の境界条件として応用でき、支川からの合流量、派川への分派量、 |
| 遊水地への流入量、破堤点における氾濫流量を把握する上でも活用できる。 |
|                                                                      |
| ４）洪水流と河床変動の一体解析による洪水中の河床変動の把握           |
|                                                                      |
| 多点に設置された水位計を用いて洪水中の水面縦断形の時間変化を         |
| 記録するとともに、流量ハイドログラフ、洪水前後の河床高を測定し、洪水 |
| 中はほぼ一定の粗度係数及び樹木群透過係数を用いて、洪水流と河床変動を |
| 支配する二つの基礎方程式を同時に解いて、流量、水面縦断形及び洪水後の |
| 河床高が一致するように洪水中の河床高を算定する。以上の結果から、流量 |
| ピーク時の河床高、洪水中の最大洗掘深等の洪水中の河床変動を把握する。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

下記の資料が参考となる。

1.  土木学会水工学委員会：水理公式集［2018 年版］，第2編
    河川・砂防，第2章 河道内洪水流の水理と解析p.224，丸善，2019.

```{=html}
<!-- -->
```
84. 福岡捷二，渡辺明英，原俊彦，秋山正人：水面形の時間変化と非定常二次元解析を用いた洪水流量ハイドログラフと貯留量の高精度推算，土木学会論文集，No.761
    Ⅱ-67，pp.45-56，2004.

85. 福岡捷二，佐藤宏明，出口桂輔：洪水流の非定常準二次元解析法の研究，土木学会論文集B，Vol.65
    No.2，pp. 95-105，2009.

86. 内田龍彦，福岡捷二，工藤美紀男：河川上流域における本川・支川流量ハイドログラフの合理的推定法，河川技術論文集，第15巻，pp.309-314，2009.

87. 福岡捷二，永井慎也，佐藤宏明：河川合流部を含む本・支川の流量ハイドログラフ貯留量の評価―利根川・渡良瀬川の平成13年9月洪水を例として―，水工学論文集，第49巻，pp.625-630，2005.

88. 福岡捷二，渡邊明英，田端幸輔，風間聡，牛膓宏：利根川・江戸川分派点を含む区間における流量ハイドログラフと粗度係数・樹木群透過係数の評価，水工学論文集，第50巻，pp.1165-1170，2006.

89. 福岡捷二，昆敏之，岡村誠司：鶴見川多目的遊水地の洪水調節効果の評価―河道の水面形の時間変化を考慮した非定常二次元解析法の適用―，土木学会論文集，pp.238-248，2007.

90. 安倍友則，福岡捷二，塚本洋祐：破堤による氾濫流量ハイドログラフ計算法の構築と河川への適用方法の研究，土木学会論文集B，第65巻
    No.3，pp.166-178，2009.

91. 岡村誠司，岡部和憲，福岡捷二：洪水流の縦断水面形変化と準三次流解析法を用いた石狩川河口部の洪水中の河床変動解析，河川技術論文集，第16巻，pp.125-130，2010.

92. 岡村誠司，福岡捷二，竹本隆之：利根川河口部の河床形状と洪水中の河床変動，水工学論文集，第54巻，pp.751-756，2010.

93. 鈴木健太，島元尚徳，久保世紀，福岡捷二：筑後川感潮域の洪水中の河床変動解析，水工学論文集，第55巻，pp.877-882，2011.

94. 福岡捷二：河道設計のための基本は何か－水面形時系列観測値と洪水流－土砂流の解析を組み合わせた河道水理システムとその見える化，河川技術論文集，第17巻，pp.83-88，2011.

95. 福岡捷二：洪水流の水位と流量の今日的考え方―多点で観測された洪水水位と水面形から河道の水理システムを見える化する―，土木学会論文集B1(水工学)，Vol.73
    No.4,Ⅰ\_355-360，2017.

第2章　水文・水理観測　第8節　河川・流域の水循環の観測 {#第2章-水文水理観測-第8節-河川流域の水循環の観測 .TOC-Heading}
======================================================

目　次 {#目-次 .TOC-Heading}
======

[第8節 河川・流域の水循環の観測 1](#_Toc315780132)

> [8．1 総説 1](#_Toc315780133)
>
> [8．2 健全な水循環の維持又は回復の観点からみた流域水循環の観測
> 1](#_Toc67643301)
>
> [8．3 気候変動による気象・水文データの変化の検知・把握
> 4](#_Toc315780135)
>
> [8．3．1 モニタリングによる検知・把握 4](#_Toc67643303)
>
> [8．3．2 気候変動予測モデルの予測結果の利用による将来気候の把握
> 6](#_Toc67643304)

令和３年４月　版

2.  水文・水理観測

    8.  []{#_Toc315780132 .anchor}河川・流域の水循環の観測

        1.  []{#_Toc315780133 .anchor}総説

＜考え方＞

+----------------------------------------------------------------------+
| 水は、生命の                                                         |
| 源であり、絶えず地球上を循環し、大気、土壌等の他の環境の自然的構成要 |
| 素と相互に作用しながら、人を含む多様な生態系に多大な恩恵を与えるとと |
| もに、循環する過程において、人の生活に潤いを与え、産業や文化の発展に |
| 重要な役割を果たしている。水がもたらす様々な恩恵を将来にわたり享受し |
| ていくためには、水循環（水が蒸発、効果、流下、又は浸透により、海域に |
| 至る過程で、地表水又は地下水として河川の流域を中心に循環すること）の |
| 状態を把握し、健全な水循環（人の活動及び環境保全に果たす水の機能が適 |
| 切に保たれた状態での水循環）を維持又は回復させることが重要となる。河 |
| 川水や地下水はこの水循環の一部であり、我々はこれを継続的に利用するこ |
| とができる。河川・水資源の計画・管理にとって、水のストックの把握だけ |
| では不十分であり、水循環のフローを把握しなければならない。また、現代 |
| においては、農業用水・都市用水・発電用水等の取水や下水、農業排水等の |
| 排水による人工の水循環も、流域水循環において大きな影響を与えており、 |
| それらの把握も重要となる。また、流域内の個々の水循環過程は、上流域か |
| らのゆっくりとした地下水流出が間欠的に降雨を貯留して水資源の重要な要 |
| 素を構成する一方で、地下水の過剰な汲み上げが地盤沈下や治水・利水・環 |
| 境面での様々な弊害をもたらすなど、自然的側面のみならず社会的側面も含 |
| めて深く互いに密接に関連しあっていることを理解することが重要である。 |
|                                                                      |
| 流域水循環の把握は、カテゴリー１の既存の観測網                       |
| のみから行うのは事実上不可能であるため、必要に応じてカテゴリー２およ |
| び３．２の追加的な観測を行い、最終的にはこれら全ての観測値を用いた解 |
| 析（水収支解析や水循環シミュレーション等）により推定するのが一般的手 |
| 法である。したがって、追加観測の対象（浸透能力、地下水位等）や観測場 |
| 所、観測時期等は、既存の観測網と用いる解析手法を考慮して決められる。 |
|                                                                      |
| 本節は、河川・流域での水循環を総合的に把握する典型的な事             |
| 例として、健全な水循環の維持又は回復のための調査及び気候変化の影響調 |
| 査で必要となる観測を取り上げて、その目的に応じた留意事項を記述する。 |
+----------------------------------------------------------------------+

2.  []{#_Toc67643301
    .anchor}健全な水循環の維持又は回復の観点からみた流域水循環の観測

＜考え方＞

+----------------------------------------------------------------------+
| 1960年代後半以降急速                                                 |
| に進んだ都市への人口や産業の集中、都市域の拡大、産業構造の変化、その |
| 一方での中山間地や農村での過疎化、高齢化等の進行、更に近年の気候変化 |
| 等を背景に、平常時の河川流量の減少、湧水の枯渇、各種排水による水質汚 |
| 濁、不浸透面積の拡大による都市型水害等の問題が顕著となってきている。 |
|                                                                      |
| これらの問題は、保水・遊水機能の                                     |
| 低下、地表水と地下水の連続性の阻害等に起因しており、流域全体を視野に |
| 入れた水循環の健全化への早急な対応が求められる事例が増えてきている。 |
|                                                                      |
| 上記の背景の下で、健全な水循環、すなわち、「人                       |
| の生活や産業活動等に果たす水の役割と自然環境に果たす水の役割が適切な |
| バランスで保たれている状態」を維持又は回復していくための流域マネジメ |
| ントが、都市河川流域を中心として必要となる場合がある。流域マネジメン |
| トには、水循環に関係する様々な主体（住民、NPO、事業者、国や地方自治  |
| 体の関係行政機関等）が参画することが望まれ、流域水循環の把握はここで |
| の共通認識・目標を醸成し共有するための基礎的情報として必要とされる。 |
|                                                                      |
| 流域水循環は、降水、蒸発散                                           |
| 、浸透、地下水流動、河川流出といった過程から成る自然の水循環と、上水 |
| 道、工業用水道、下水道、農業用用排水路等を経由して流れる人の生活や産 |
| 業活動等による水循環に大きく分けることができる。対象とする河川流域内 |
| に存在するこれらの水循環過程やそれら相互の関連性について、過去から現 |
| 在に至る変化の実態や経緯及び将来動向の把握が求められることが多い(図  |
| 2-8-1)。たとえば、自然                                               |
| の水循環に着目した場合、都市化等の流域の改変以前に流域に備わっていた |
| 保水・遊水機能の把握は流域マネジメントにおいて重要な基礎情報となる。 |
|                                                                      |
| ![](media/image25.png){width="6.298611111111111in"                   |
| height="5.2875in"}                                                   |
|                                                                      |
| 図2-8-1　流域水循環系を構成する水循環要素の分類例                    |
|                                                                      |
| 出典：健全な水循環系構築に関する関係省庁連絡会議：                   |
|                                                                      |
| 健全な水循環系構築のための計画づくりに向けて、2003.                  |
+----------------------------------------------------------------------+

＜標　準＞

  -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  保水・遊水機能等の流域規模での直接的な観測が困難な機能の把握を含めて、水循環を総合的かつ客観的に把握するための手段としては、既存の気象水文観測、地形・地質、土壌等の資料を用いた年間水収支法、若しくは、水循環シミュレーション（第3章 第2節 流出解析 参照）により総合的に把握し分析することを標準とする。
  -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  雨水浸透施設による流域での平均浸透強度を精度よく設定する必要があるときは、現地浸透試験(カテゴリー２：特定目的観測)を実施し、得られた結果から平均浸透強度を設定することが望ましい。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜例　示＞

+----------------------------------------------------------------------+
| 対象とする河川流域内に存在するこれ                                   |
| らの水循環の過程やそれら相互の関連性を示すことを目的として、年間水収 |
| 支法若しくは水循環シミュレーションによる解析結果について、図2-8-2に  |
| 示すように、各構成要素の定量的な年間水収支関係を図示する方法がある。 |
|                                                                      |
| この水収支の関係図                                                   |
| について、過去から現在、将来にわたって変化する状況を示すことで、健全 |
| な水循環の維持又は回復における課題を把握する手段とすることができる。 |
|                                                                      |
| ![](media/image26.png){width="6.304225721784777in"                   |
| height="3.0632906824146984in"}                                       |
|                                                                      |
| 図2-8-2　水循環解析による水の収支の例                                |
|                                                                      |
| 出典：「水循環解析に関する技術資料」：                               |
|                                                                      |
| 国土技術政策総合研究所2016.                                          |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  特定都市河川浸水被害対策法，平成 15 年 6 月 11 日，法律第 77
    号，最終改正：令和 4 年 6 月 17 日法律第 68 号.

```{=html}
<!-- -->
```
96. 健全な水循環系構築のための計画づくりに向けて，平成15年10月，健全な水循環系構築に関する関係省庁連絡会議.

97. 水循環基本法,平成 26 年 4 月 2 日,法律第 16 号,最終改正：令和 3 年 9
    月 1 日法律第 36号.

98. 雨水の利用の推進に関する法律，平成26年4月2日法律第17号,最終改正：令和3年5月19日法律第36号.

99. 雨水の利用の推進に関する基本方針，平成27年3月10日国土交通省告示第311号

100. 水循環基本計画，令和 2 年 6 月 16 日閣議決定.

     （最新版）水循環基本計画，令和 4 年 6 月 21 日閣議決定.

＜参考となる資料＞

特に都市域における健全な水循環系の確保に資する具体的な技術の詳細、たとえば、雨水貯留浸透施設の設計のための詳細な調査手法、浸透能力やその効果（平均浸透強度）を概算する簡便法、並びに、都市域における流域水循環系のシミュレーション手法については、下記の資料が参考となる。

1.  (社)雨水貯留浸透技術協会：増補改訂雨水浸透施設技術指針（案）調査・計画編，2006.

```{=html}
<!-- -->
```
101. 雨水浸透施設の整備促進に関する手引き（案）～浸透能力の低減を見込んだ効果把握及び維持管理の考え方について～，平成22年4月，国土交通省都市・地域整備局下水道部，同河川局治水課.

102. 「都市小流域における雨水浸透，流出機構の定量的解明」研究会：都市域における水循環系の定量化手法:
     水環境系の再生に向けて，(社）雨水貯留浸透技術協会，2000.

日本の水需給や水資源開発の現状、および水循環系構成要素の水利用量等といった水資源利用状況に関するデータ等について取りまとめた情報として、下記の資料が参考となる。

103. 日本の水資源の現況，国土交通省水管理・国土保全局水資源部.

104. 雨水の利用の推進に関するガイドライン（案），平成30年6月，国土交通省水管理・国土保全局水資源部.

     （最新版）雨水の利用の推進に関するガイドライン，平成28年7月（令和7年3月（改訂版）），国土交通省水管理・国土保全局水資源部.

105. 流域マネジメントの手引き,平成30年7月,内閣官房水循環政策本部事務局.

106. 水循環解析に関する技術資料,平成30年3月, 国土技術政策総合研究所.

     1.  []{#_Toc315780135
         .anchor}気候変動による気象・水文データの変化の検知・把握

＜考え方＞

+----------------------------------------------------------------------+
| 気候変化には、数年スケールで発生を繰り返しているエルニーニョ・ラニ   |
| ーニャ現象や北極振動等、様々な自然的要因によるものが含まれる一方、ヒ |
| ートアイランドや地球温暖化等、人為的要因による影響が大きいものも存在 |
| する。特に、地球温暖化は不可逆性と予想される影響の大きさ・深刻さから |
| 、地球規模で人間社会・経済にも大きな影響を与える重要な課題である。沿 |
| 岸域や洪水氾濫原、急傾斜地は、海面水位の上昇、大雨の頻度増加、台風の |
| 激化等により、水害、土砂災害、高潮災害等が頻発・激甚化するとともに、 |
| 降雨の変動幅が拡大することに伴う渇水の頻発や深刻化が懸念されている。 |
|                                                                      |
| 気候変動に関する政府間パ                                             |
| ネル（IPCC）の第５次評価報告書では、気候変動の影響は、たとえ温室効果 |
| ガスの人為的な排出が停止したとしても、何世紀にもわたって持続するだろ |
| う、とされており、多くの適応及び緩和の選択肢は気候変動への対処に役立 |
| ちうるが、単一の選択肢だけでは十分ではないと指摘されている。一方、緩 |
| 和策への取組や社会条件の変化等不確実性がある中で、外力変化の予測値に |
| も大きな幅が存在する。このように、気候変化の予測等に不確実性がある中 |
| で適応策を検討するためには、今後の観測データや知見の蓄積に応じて適応 |
| 策の内容や組合せを適切に見直していく順応的な対応が必要不可欠である。 |
|                                                                      |
| 気候変動に                                                           |
| よる気象・水文データの変化を検知・把握するためには、モニタリングによ |
| る手法と、気候変動予測モデルの予測結果を利用する手法等が考えられる。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

1.  気候変動に関する政府間パネル（IPCC）第５次評価報告書統合報告書　政策決定者向け要約，平成26年，UNEP，
    WMO.

```{=html}
<!-- -->
```
107. 洪水に関する気候変化の適応策検討ガイドライン【日本語版】，平成22年，国土交通省河川局.

     1.  []{#_Toc67643303 .anchor}モニタリングによる検知・把握

```{=html}
<!-- -->
```
1.  モニタリングする気象・水文データの項目

＜標　準＞

+----------------------------------------------------------------------+
| モニタリングは、観測値を用いることを原則とし、対象とする気象・水文   |
| データの項目は、気温、降水量、降雪量・積雪量、河川流量、潮位、蒸発散 |
| 量等より、流域特性や観測状況に応じて適切に選択することを基本とする。 |
|                                                                      |
| これらの項目をモ                                                     |
| ニタリングするに当たっては、カテゴリー１に求められる観測データの長期 |
| にわたる一定レベル以上の品質の確保を標準とする。これらの項目の観測手 |
| 法や最低限確保すべき品質とそのためのデータ照査の手法については、本章 |
| 第2節～第5節に詳                                                     |
| 述されているので、その基準に従って観測・照査を行うことを標準とする。 |
+----------------------------------------------------------------------+

＜例　示＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  積雪・融雪変化のモニタリングは、ダム管理用観測等、カテゴリー2特定目的観測に分類される積雪深・密度観測や衛星リモートセンシングによる積雪域変化図等を用いることができる。精度の高い観測値が得られない場合は、地上気温の観測値と現在気候条件下での大気大循環モデル（以下、GCMという。）出力値から第3章 水文解析 第2節 2.3.4 積雪・融雪量の推定 に記載した手法で計算することで仮想的な観測値を得た上で、将来気候条件下での計算結果と比較することにより、積雪・融雪変化を評価したり、長期流出への影響を予測する手法が用いられることがある。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

37. モニタリング検討地点の選定

＜標　準＞

+----------------------------------------------------------------------+
| モニタリング検討地点は、次の各項を考慮して選定することを標準とする。 |
|                                                                      |
| 1)  解析による変化の有無の検知のため、極力、長期間の観測             |
| 資料があり、かつデータの品質が高いと考えられる観測所を選定すること。 |
|                                                                      |
| 2)  人為的影響ができるだけ少ない観測所を選定すること。\              |
|     例えば河川流量については、取排水、流況調節、土地                 |
| 利用・植被変化等の人為的影響ができるだけ少ない上流域での観測所を含め |
| て選定しておくことで、気候変化の影響を検知しやすくすることができる。 |
+----------------------------------------------------------------------+

38. モニタリングした気象・水文データの分析

＜標　準＞

+----------------------------------------------------------------------+
| モニタリングした気象・水文データ                                     |
| の分析に当たっては、一般に次の事項について検討することを標準とする。 |
|                                                                      |
| 1)  時系列の傾向（経年変化）                                         |
|                                                                      |
| ```{=html}                                                           |
| <!-- -->                                                             |
| ```                                                                  |
| 3)  ある閾値以上の生起回数                                           |
|                                                                      |
| １）、２）の検討を行う際                                             |
| には、統計処理に十分なサンプル数を確保した上で、統計的な有意性を検定 |
| することを標準とする。なお、統計学的な分析を行うに当たっては、第3章  |
| 水文解析 第1節 水文統計解析 の基準に従うものとする。                 |
+----------------------------------------------------------------------+

＜例　示＞

+----------------------------------------------------------------------+
| 年最大流量等の極値の経年変化を分析                                   |
| する場合において、統計的に有意な関係を把握するための工夫を例示する。 |
|                                                                      |
| 単独の観測点における年最大流量のみを分析対象としてしまうと、仮に温   |
| 暖化により年最大流量が増加傾向にあったとしても、温暖化による増加傾向 |
| が、年最大流量の年ごとの変動に対して極めて微小であることと観測年数の |
| 少なさから、統計的には有意性が検出されないことが想定される。このよう |
| な事態を避けるため、複数の観測点を対象にすることでサンプル数を増やし |
| たり、観測期間を分割しその期間内で一定以上の流量が発生した年数を分析 |
| したり、年最大流量の順位を分析したりする等の工夫を用いることが多い。 |
|                                                                      |
| 年最大流量等の極値以外の統計値を分析する場合においても、統計的に有意 |
| な経年変化を把握するために、その特性に応じた工夫を用いることが多い。 |
|                                                                      |
| な                                                                   |
| お、短期間でのデータによる統計解析結果の信頼性に限界があることを考慮 |
| し、その解析結果の定量的な評価については十分慎重に吟味するのがよい。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  洪水に関する気候変化の適応策検討ガイドライン【日本語版】，平成22年，国土交通省河川局.

＜参考となる資料＞

具体的な河川流域における気候変化影響の検知・把握の検討事例として、下記の資料が参考となる。

1.  四国地方の気候変動レポート2010，平成23年9月，国土交通省四国地方整備局，p.42.

```{=html}
<!-- -->
```
108. 国土交通省国土技術政策総合研究所気候変動適応研究本部：[気候変動適応策に関する研究（中間報告）](http://www.nilim.go.jp/lab/bcg/siryou/tnn/tnn0749.htm)，国土技術政策総合研究所資料，第749号，2013.

109. 国土交通省国土技術政策総合研究所気候変動適応研究本部：気候変動適応策に関する研究－「気候変動下での大規模水災害に対する施策群の設定・選択を支援する基盤技術の開発」の成果をコアとして－，国土技術政策総合研究所プロジェクト研究報告書，第56号，2017.

110. 文部科学省・気象庁：気候変動観測・予測評価レポート，2020.\
     （最新版）日本の気候変動2025
     大気と陸・海洋に関する観測・予測評価報告書，2025年3月，文部科学省・気象庁.

     1.  []{#_Toc67643304
         .anchor}気候変動予測モデルの予測結果の利用による将来気候の把握

＜考え方＞

+----------------------------------------------------------------------+
| 気候予測は、物理法則を                                               |
| 定式化した気候変動予測モデルを用いて、空気中の温室効果ガスやエアロゾ |
| ルなどの濃度が今後どのように変化するかというシナリオを基に数値シミュ |
| レーションを行うことが一般的である。気候変動予測モデルの予測結果の利 |
| 用にあたっては不確実性が大きいことに留意して取り扱う必要がある。特に |
| 、大雨や渇水等の極端現象を取り扱う場合には、現況再現性がより低くなる |
| ことから、不確実性がさらに大きくなることを踏まえた分析が必要となる。 |
|                                                                      |
| これらの気候変動予測モデルの予測結果の利用に当たっては、気候変動     |
| 予測モデルの開発状況や、温暖化に関連する将来のシナリオの想定について |
| 最新の動向に留意する必要がある。また、単一の気候変動予測モデルの予測 |
| 結果のみを用いるのではなく、複数の異なる気候変動予測モデルの予測結果 |
| を用いたり、同一気候変動予測モデルでも条件を変えて計算した複数の予測 |
| 結果を用いたりする等、予測結果の不確実性を評価することが必要である。 |
|                                                                      |
| 将来の降雨の予測を行うためにはシナリオの特徴を把握しておくことが     |
| 重要であり、温暖化に関連するシナリオは、予測の不確実性が大きなことや |
| 、今後の温室効果ガスの排出量の動向に依存することに留意が必要である。 |
+----------------------------------------------------------------------+

＜例　示＞

+----------------------------------------------------------------------+
| １）気候変動予測モデル                                               |
|                                                                      |
| 気候変動予測モデルには、全                                           |
| 球を対象として計算する大気大循環モデル（GCM）がある。現状では、気候  |
| 変動予測モデルの空間分解能は、気象研究所が開発した最も緻密なモデル（ |
| 気象研究所　MRI-AGCM3.2S）であっても、20km四方の分解能となっている。 |
|                                                                      |
| 河川流域スケ                                                         |
| ールにおける予測では細かな空間分解能が必要となるため、力学的ダウンス |
| ケールとバイアス補正を行い、河川流域の影響予測を実施する場合もある。 |
|                                                                      |
| GCMの粗い空間分解能で表された予測結果                                |
| から、特定の地域を対象とし、地形や土地利用などの地域特性を詳細に考慮 |
| し、より細かい空間分解能の予測結果を求める「ダウンスケーリング」が行 |
| われている。ダウンスケールした予測結果として既に一般に公開されている |
| ものには、日本付近の領域を対象とし、5km四方・2km四方の分解能を有する |
| 気象庁気象研究所が開発した非静力学地域気候モデルによる事例等がある。 |
|                                                                      |
| 大型計                                                               |
| 算機の発展や数値計算アルゴリズムの進化によってモデルの不完全性や初期 |
| 値の不確実性を考慮した複数のモデルを使ったマルチモデルアンサンブル予 |
| 測が行われており、さらにこれまでにない多数のアンサンブル実験が行われ |
| ている。その結果極端現象の再現と変化について議論が可能となっている。 |
|                                                                      |
| 気候変動                                                             |
| 予測モデルの予測結果には、現在気候（地球温暖化の影響なしの気候）を再 |
| 現したときに見られる系統誤差（バイアス）の存在がある。このバイアスの |
| 影響を少なくするため、現在気候の再現結果と観測値との相違から系統誤差 |
| を分析し、その結果をもって将来気候の予測値の補正（バイアス補正）を実 |
| 施することや、バイアスを打ち消すため気候変動予測モデルによる現在気候 |
| と将来気候の計算結果の比較し、その比較結果から得られた降雨量の変化倍 |
| 率等を現在の観測値に乗ずることで将来気候の状況を想定する事例もある。 |
|                                                                      |
| 河川流域での大雨を対象とした                                         |
| 将来気候の予測では、気候変動予測モデルによる予測と過去水文資料から求 |
| めた現在気候の流域平均降雨発生頻度から系統誤差を求める場合がある。こ |
| のとき用いる観測資料は、一般にカテゴリー１の観測資料を用いればよい。 |
|                                                                      |
| ２）温暖化に関するシナリオ                                           |
|                                                                      |
| 温室効果ガスの排出量の予測には社会的・経済的                         |
| な側面の将来予測が必要であり、将来社会についていくつかの典型的なパタ |
| ーンを想定した上でシナリオが定められている。気候変動に関する政府間パ |
| ネル（IPCC）が平成25年に発表したIPCC第5次評価報告書第1作業部会報告書 |
| では、SRESシナリオに変わる気候変化の予測のための新たなシナリオとして |
| 、RCP（代表的濃度経路）シナリオを用いた予測結果が示された。RCPシナリ |
| オは4つの温室効果ガス濃度に対応したシナリオで、それぞれRCP8.5、RCP6  |
| .0、RCP4.5、RCP2.6と呼ばれる。複数のモデルによる産業革命前と比較した |
| 2100年時点での全球平均気温の上昇予測によると、最も上昇が大きいRCP8.5 |
| シナリオで2.6℃～4.8℃の範囲に入る可能性が高いという結果になっている。 |
|                                                                      |
| また、令和元年9月に                                                  |
| IPCC総会で受諾された海洋・雪氷圏特別報告書では、2100年までの1986年～ |
| 2005年に対する平均海面水位の予測上昇範囲は、RCP8.5では0.61～1.10m、R |
| CP2.6では0.29～0.59mとされ、これまでの報告書から上方修正されている。 |
|                                                                      |
| ３）シナリオに基づく将来気候予測                                     |
|                                                                      |
| 地球温暖化の影響を評価し、                                           |
| 適応策を策定するには、気候変動予測とそれに伴う不確実性の定量評価が不 |
| 可欠である。文科省・気候変動リスク情報創生プログラムにおいて、高解像 |
| 度全球大気モデル及び高解像度領域大気モデルを用い、これまでにない多数 |
| (最大100メンバ)                                                      |
| のアンサンブル実験を行うことによって、確率                           |
| 密度分布の裾野にあたる極端気象の再現と変化について、十分な議論ができ |
| る「地球温暖化対策に資するアンサンブル気候予測データベース、database |
| for Policy Decision making for Future climate change                 |
| (以下、「d4PDF」という。)」が整備、公表された。d4P                   |
| DFの結果を用いることで気候変化よる自然災害がもたらす未来社会への影響 |
| についても確度の高い結論を導くことが可能となる。防災、都市計画、環境 |
| 保全等に関わる様々な地球温暖化対策のために、その基礎となる気候予測デ |
| ータとなる。共通の予測データを用いることで、諸問題間および地域間で整 |
| 合した温暖化対策の実現が期待できる。d4PDFの仕様は次のとおりである。  |
|                                                                      |
| -   水                                                               |
| 平解像度約60kmの気象研究所全球大気候モデルMRI-AGCM3.2を用いた全球気  |
| 候実験は過去実験、4℃上昇実験、2℃上昇実験、非温暖化実験の4種類行われ  |
| ており、全球気候実験を水平解像度20kmで日本域を対象とする気象研究所領 |
| 域気候モデルNHRCMを用いた領域ダウンスケールも行われている。水平解像  |
| 度20kmの領域ダウンスケール実験におけるメンバ数は以下の通りである。\  |
|     　過去実験：1950年～2011年×50メンバ（合計3,000年）\              |
|     　4℃上昇実験：2050年～2111年×90メンバ（合計5,400年）\            |
|     　2℃上昇実験：2030年～2091年×54メンバ（合計3,240年）             |
|                                                                      |
| -   4℃上昇実験はRCP8.5シナリオの21世紀末相当の予測結果であ           |
| り、1850年の産業革命前の気温と比較して4℃上昇した場合を計算している。 |
|                                                                      |
| -   2℃上昇実験はRCP8.5シナリオの2040年相当の予測結果であ             |
| り、1850年の産業革命前の気温と比較して2℃上昇した場合を計算している。 |
|                                                                      |
| -   さら                                                             |
| に、水平解像度20kmのダウンスケーリング実験を水平解像度5kmで気象研究  |
| 所領域気候モデルNHRCMを用いた領域ダウンスケール実験も行われている。  |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  洪水に関する気候変化の適応策検討ガイドライン【日本語版】，平成22年，国土交通省河川局.

```{=html}
<!-- -->
```
111. 気候変動に関する政府間パネル（IPCC）第5次評価報告書第1作業部会報告書，平成25年，UNEP，
     WMO.

112. 海洋・雪氷圏に関する特別報告書　政府決定者向け要約，2019，IPCC.

     （最新版）変化する気候下での海洋・雪氷圏に関するIPCC特別報告書，2019，IPCC.

＜参考となる資料＞

d4PDFの結果を用いて力学的ダウンスケールとバイアス補正を行い降雨水量の将来予測を行い、洪水流量予測に活用した事例として下記資料が参考となる。

1.  北海道地方における気候変動を踏まえた治水対策技術検討会　中間とりまとめ　令和2年6月　国土交通省北海道開発局.

d4PDFは文部科学省による複数の学術研究プログラム（「創生」、「統合」、SI-CAT、DIAS）間連携および地球シミュレーターにより作成されたものであり、その実験デザイン等の詳細は以下のサイトが参考となる。

113. [地球温暖化対策に資するアンサンブル気候予測データベース、database
     for Policy Decision making for Future climate change
     (d4PDF)](http://www.miroc-gcm.jp/~pub/d4PDF/index.html) .

d4PDFの力学的ダウンスケーリング実験デザイン等の詳細および実験結果を用いて全国の降雨量変化倍率の将来予測を行った事例は、下記資料が参考となる。

114. 気候変動を踏まえた治水計画のあり方 提言，令和元年 10
     月，気候変動を踏まえた治水計画に係る技術検討会（国土交通省水管理・国土保全局）.

     （最新版）気候変動を踏まえた治水計画のあり方 提言，令和 3 年 4
     月改訂，気候変動を踏まえた治水計画に係る技術検討会（気候変動を踏まえた治水計画に係る技術検討会）.

第3章　水文解析　第1節　水文統計解析 {#第3章-水文解析-第1節-水文統計解析 .TOC-Heading}
====================================

目　次 {#目-次-1 .TOC-Heading}
======

[第1節 水文統計解析 1](#_Toc308536261)

> [1．1 総説 1](#_Toc383525403)
>
> [1．2 資料の収集及び解析手法の前提条件の検討 1](#_Toc308536263)
>
> [1．2．1 水文資料の周期性の検討 2](#_Toc308536264)
>
> [1．2．2 水文資料のジャンプの検討 2](#_Toc308536265)
>
> [1．2．3 水文資料のトレンドの検討 3](#_Toc326591105)
>
> [1．3 定常な水文量の頻度解析 4](#_Toc308536267)
>
> [1．3．1 候補確率分布モデルの列挙 4](#_Toc316205590)
>
> [1．3．2 確率分布モデルの母数推定 6](#_Toc308536269)
>
> [1．3．3 候補確率分布モデルのスクリーニング 9](#_Toc308536270)
>
> [1．3．4 確率水文量のバイアス補正と安定性の評価 10](#_Toc308536271)
>
> [1．3．5 確率分布モデルの決定 11](#_Toc308536272)
>
> [1．3．6 確率分布モデルの決定に関する補足事項 13](#_Toc308536274)
>
> [1．4 非定常な水文量の頻度解析 13](#_Toc308536275)
>
> [1．5 時系列変化特性の解析 14](#_Toc308536276)

平成26年4月　版

3.  

4.  水文解析

    1.  []{#_Toc308536261 .anchor}水文統計解析

        1.  []{#_Toc383525403 .anchor}総説

＜考え方＞

+----------------------------------------------------------------------+
| 本節は、第2章 水文・水理観測 [第2節](http://www.yahoo.co.jp)         |
| 降水量観測、[第3節](http://www.yahoo.co.jp)                          |
| 水位観測、[第4節](http://www.yahoo.co.jp)                            |
| 流量観測                                                             |
| で規定されている方法等により得られ、[第5節](http://www.yahoo.co.jp)  |
| 水文資料の整理・保存と品質管理で規定されている方法により             |
| 蓄積・管理された水文資料等の統計的解析についての技術的事項を定める。 |
|                                                                      |
| 一般                                                                 |
| に河川計画及びそれを実現するための河川管理施設等の設計や管理のよりど |
| ころとなる目標としては、既往の事象の中で厳しいもの又は既往の事象の頻 |
| 度解析によって計画規模若しくは目標とする規模の値を推定したものが選ば |
| れる。本節で規定する水文頻度解析手法は、計画規模の頻度で生起すると想 |
| 定される事象を既往の水文資料から推定する際に用いられ、また、あわせて |
| 、任意の事象の発生頻度を既往の水文資料から推定する際にも用いられる。 |
|                                                                      |
| 従来、水文頻度解析においては、水文資料の定常性等を仮定す             |
| ることが多かったが、地球温暖化に伴う気候変化が予測されており、その吟 |
| 味も重要となってきているので解析の前提条件の確認手法について述べる。 |
|                                                                      |
| 水文統計解析には、資料の収集及び解析手                               |
| 法の前提条件の検討、水文頻度解析、時系列変化特性の解析等が含まれる。 |
|                                                                      |
| 資料の収集及び解析手法の前提条件の検討では、水文統計解析             |
| を行うに当たり基本的な事項を述べるとともに、水文頻度解析の前提条件を |
| 満たしているかどうかの検討の方法について述べる。また、水文頻度解析に |
| おいて、次に述べる定常解析又は非定常解析のどちらを適用すべきかを選択 |
| する際のよりどころとなる水文資料の定常性の検討の方法について述べる。 |
|                                                                      |
| 水文頻度解析は、水文諸量の規模とその発生頻度の関係を統計的な方法に   |
| より推定するものであり、前述の定常性の検討結果に応じて、定常な水文量 |
| の頻度解析又は非定常な水文量の頻度解析を適用する方法について述べる。 |
|                                                                      |
| 時系列変化特性の                                                     |
| 解析において、周期性等の時間変化特性の解析を行う方法について述べる。 |
+----------------------------------------------------------------------+

2.  []{#_Toc308536263 .anchor}資料の収集及び解析手法の前提条件の検討

＜考え方＞

+----------------------------------------------------------------------+
| 水文統計解析の基となる水文資料                                       |
| は、解析の目的、解析方法、資料収集・整理の難易等を考慮して選定する。 |
| 水文資料の選定、収集に当たっては次の各項目について調査・検討を行う。 |
|                                                                      |
| 1.  水文資料の存在状態                                               |
|                                                                      |
| 2.  観測又は記録の方法、水文資料の精度、代表性等の特性               |
|                                                                      |
| 3.  水文資料収集に関する時間、費用等の作業の程度                     |
|                                                                      |
| 4.  他の調査成果資料                                                 |
|                                                                      |
| 年最大値資料はその変動が大きいので水文                               |
| 資料の特性から吟味することは容易ではないが、平均値に比べ異常に大きい |
| ものや小さいもの等を見つけた場合は、その年の気象条件を吟味し、水文資 |
| 料の妥当性を調べ、測定時の野帳等に戻って観測値の徹底的な吟味を行う。 |
|                                                                      |
| また、水文資料を水文頻度解析に用いる際の検討項目とし                 |
| て、１）ランダム性、２）独立性、３）均質性、４）定常性が考えられる。 |
|                                                                      |
| 1.  ランダム性(Randomness)                                           |
|                                                                      |
| ランダムとは                                                         |
| 、標本の変動が自然由来であることである。例えば、人為的に調節された流 |
| 量データはランダムとはみなされないので調節効果を除去する必要がある。 |
|                                                                      |
| 2.  独立性(Independence)                                             |
|                                                                      |
| 独立とは、標本の                                                     |
| 各データがそれぞれ他のデータの影響を受けていないことである。例えば、 |
| 本日の流量は昨日の流量の影響を受けている（昨日の流量が大きければ、本 |
| 日の流量も大きい）ので独立とはいえず、双方を水文資料に含めることはで |
| きない。通常、データのサンプリング間隔を大きくすれば独立とみなせる。 |
|                                                                      |
| 3.  均質性(Homogeneity)                                              |
|                                                                      |
| > 均質とは、標本が一つの母集団からのものとみなせることである。       |
|                                                                      |
| 4.  定常性(Stationarity)                                             |
|                                                                      |
| 定常とは、標本からランダムな変動を除いた後の成分が時間的             |
| に変化していないことである。非定常なデータは、トレンド（長期的傾向変 |
| 化）、ジャンプ（急激な変化）又は周期を持つ。例えば、トレンドは徐々に |
| 進む流域の改変等、ジャンプは自然的、人為的な条件の急変等と関係する。 |
|                                                                      |
| 定常性が満たされない場合は、水文資料から周期成分やジャンプ           |
| の影響を排除した資料についてトレンドの有意性について検討し、有意と認 |
| められない場合は周期成分やジャンプの影響を排除した資料について定常性 |
| を前提とした水文頻度解析を適用する。そうでない場合は水文頻度解析にト |
| レンド成分を内包する非定常な水文量の頻度解析を行う方法が考えられる。 |
+----------------------------------------------------------------------+

1.  []{#_Toc308536264 .anchor}水文資料の周期性の検討

＜例　示＞

  -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  水文資料の周期性の有無は、標本自己相関係数を用いたコレログラム（時系列相関図）で評価することができる。水文資料が独立同一分布からの標本かどうかを検定する手法として、有意水準を5％とするとき、標本$\left\{ X_{1},X_{2},\cdots,X_{n} \right\}$ の自己相関係数が信頼限界$\pm \frac{1.96}{\sqrt{n}}\ $の範囲に入るかどうかで判断できる。もし、想定される周期の2～3倍程度（または40タイムステップ程度）までの標本自己相関係数を求めて、そのうち2、3個以上が信頼限界外となるか、1個が信頼限界のはるか外になれば、独立同一分布であるという仮説を棄却する。棄却された場合、調和解析等により周期成分を除去して水文頻度解析を行う必要がある。
  -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

[]{#_Toc308536265 .anchor}

2.  水文資料のジャンプの検討

＜例　示＞

+----------------------------------------------------------------------+
| 水文時系列資料がジャンプを有するかどうかの判断                       |
| には、t-検定やMann-Whitney検定を用いることができる。なお、ジャンプは |
| 観測期間の長短により検出されなかったり、検出されたりするので、水文資 |
| 料が十分な観測期間を有しているかどうかも併せて検討する必要がある。十 |
| 分な観測期間の長さについては、水文資料の特性により異なる。水文資料が |
| 十分な観測期間を有していない場合は、ジャンプを有していないとみなす。 |
| また、ジャンプの原因が明確な場合、観測期間を分けた検討が必要である。 |
|                                                                      |
| 例えば、年降水量                                                     |
| 、洪水期降水量、月降水量、年最大日雨量、年最大時間雨量等の水文時系列 |
| 資料を収集した場合、これらのうち最も安定的と考えられるのは年降水量で |
| ある。日降水量や時間降水量等の年最大値は変動が激しく、ジャンプを検出 |
| することが難しい。このため、たとえ年最大値の解析が目的とするところで |
| あっても年降水量等の平均的特性を表すものによる検討を行うことが望まし |
| く、そこで有意なジャンプが検出されれば、観測期間を分けた検討を行う。 |
+----------------------------------------------------------------------+

3.  []{#_Toc326591105 .anchor}水文資料のトレンドの検討

＜例　示＞

+----------------------------------------------------------------------+
| 水文時系列資料がトレンドを有するかどうかの判断に                     |
| 使える手法として、Mann-Kendall検定や新記録数検定等がある。ただし、検 |
| 出力がそれぞれ異なり、必ずしも水文資料が単調なトレンドを有しているこ |
| とは少ないことから、複数の方法や対象期間等により評価する必要がある。 |
|                                                                      |
| 1.  Mann-Kendall検定                                                 |
|                                                                      |
| Mann-Kendall検定は、トレンドが線形か非線形かを問                     |
| わずに水文時系列資料のトレンドを検定するノンパラメトリックな手法であ |
| る。本検定の帰無仮説H~0~と、対立仮説H~1~は、以下に示すとおりである。 |
|                                                                      |
| H~0~ : $n$ 個のデータ                                                |
| $\left\                                                              |
| { X_{1},X_{2},\cdots,X_{n} \right\}\ $が独立で同一の確率分布に従う。 |
|                                                                      |
| H~1~ : $n$ 個のデータ                                                |
| $\lef                                                                |
| t\{ X_{1},X_{2},\cdots,X_{n} \right\}\ $が同一の確率分布に従わない。 |
|                                                                      |
| Mann                                                                 |
| -Kendall検定においては、式（3-1-4）で与えられる統計量*Z*を定義する。 |
|                                                                      |
|   $$S = \sum_{k = 1}^{n - 1}{\sum_{j = k + 1}^{n}{\text              |
| {sign}\left( X_{j} - X_{k} \right)}\text{\ \ }}\text{\ \ }$$         |
|                                                              (3-1-1) |
|   -------------------------------------------------------            |
| -------------------------------------------------------------------- |
| ---------------------------------------------------------- --------- |
|   $$\text{sign}\left( \theta \right) = \left\{ \begin{m              |
| atrix}                                                               |
|                                                              (3-1-2) |
|   \ \ \ 1\ \ \ \theta > 0 \\                                         |
|                                                                      |
|                                                                      |
|   \ \ \ 0\ \ \ \theta = 0 \\                                         |
|                                                                      |
|                                                                      |
|    - 1\ \ \theta < 0 \\                                              |
|                                                                      |
|                                                                      |
|   \end{matrix} \right.\ $$                                           |
|                                                                      |
|                                                                      |
|   $$\text{Var}\left( S \right) = \frac{1}{18}\left( n\l              |
| eft( n - 1 \right)\left( 2n + 5 \right) - \sum_{i = 1}^{n}{e_{i}\lef |
| t( e_{i} - 1 \right)\left( {2e}_{i} + 5 \right)} \right)$$   (3-1-3) |
|   $$Z = \left\{ \begin{matrix}                                       |
|                                                                      |
|                                                              (3-1-4) |
|   \frac{S - 1}{\sqrt{Var(s)}}\text{\ \ \ }S > 0                      |
| \\                                                                   |
|                                                                      |
|   0\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ S = 0 \\                            |
|                                                                      |
|                                                                      |
|   \frac{S + 1}{\sqrt{Var(s)}}\text{\ \ \ \ }S <                      |
| 0 \\                                                                 |
|                                                                      |
|   \end{matrix} \right.\ $$                                           |
|                                                                      |
|                                                                      |
|                                                                      |
| ここに、$e_{i}$ はデータ                                             |
| $\left\{ X_{1},X_{2},\cdots,X_{n} \right\}\ $                        |
| を昇順に並べたとき、同じ値が連続して出現する個数を表し、$n$          |
| はそ                                                                 |
| の組数を表す。ここで、有意水準を$\alpha$としたとき、標準正規変量$Z$  |
| が $\left| Z \right| > z_{1 - \frac{\alpha}{2}}$                     |
| のとき仮説H~0~は棄却される。ここに、$z_{1 - \frac{\alpha}{2}}$       |
| は標準正規分布の超                                                   |
| 過確率$\frac{\alpha}{2}\ $に相当するクォンタイルである。また、$S >   |
| 0\ $のとき、水文時系列資料$X_{i}$は上昇傾向であることを示し、$S < 0$ |
| のときは下降傾向であることを示す。                                   |
|                                                                      |
| 5.  新記録数検定                                                     |
|                                                                      |
| 水文時系列資料                                                       |
| が定常で独立同一分布に従う場合、最初の記録を新記録として、以降この新 |
| 記録が更新される回数を数える。この数は理論的に次式で表されるので、観 |
| 測値から得られる新記録の回数と比較することにより定常性を評価できる。 |
|                                                                      |
|   -- ---------                                                       |
|      (3-1-5)                                                         |
|   -- ---------                                                       |
|                                                                      |
| ここに$n$                                                            |
| は観測回数（年最大値を対象とする場                                   |
| 合観測年数）、$\gamma\ $はオイラー定数であり、約0.577216である。時系 |
| 列が増加傾向であれば、観測値から得られる新記録の数は理論値を上回り、 |
| 減少傾向であれば逆に下回ることになる。例えば、有意水準5％のとき、$n  |
| \ $=25、50、100に対する新記録の個数の上限値はそれぞれ7、8、9である。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

水文時系列資料の定常性の解析の詳細については、下記の資料が参考となる。

1.  徐宗学，竹内邦良，石平博：日本の平均気温・降水量時系列におけるジャンプ及びトレンドに関する研究，水工学論文集，第46巻，pp.121-126，2002.

```{=html}
<!-- -->
```
115. Salas, Jose R.：Analysis and Modeling of Hydrologic Time
     > Series，Chap. 19, Handbook of Hydrology, (Ed.) D. R. Maidment,
     > McGraw-Hill, New York，pp.19.1-19.72，1993.

116. 飯山由利子，西村和夫，渋谷政昭：新記録数検定の検出力，応用統計学，Vol.24
     > No.1，pp.13-26，1995.

117. 関静香，加藤琢朗，志村光一，山田正：荒川水系の新記録出現理論に基づく大雨と洪水の発生頻度に関する研究，土木学会第55回年次学術講演会，Ⅱ-155，2000.

118. 竹内啓，藤野和建：スポーツの数理科学―もっと楽しむための数字の読み方
     > (応用統計数学シリーズ)，p.181，共立出版，1988.

119. P.J. Blockwell・R. A.
     > Davis著者，逸見功・田中稔・宇佐美嘉弘・渡辺則生訳：入門　時系列解析と予測，p.431，シーエーピー出版，2004.

     1.  []{#_Toc308536267 .anchor}定常な水文量の頻度解析

＜標　準＞

+--------------------------------------------------------------+
| 定常性を前提とした水文量の生起頻度の解析は以下の手順による。 |
|                                                              |
| 候補確率分布モデルの列挙                                     |
|                                                              |
| 5.  確率分布モデルの母数推定                                 |
|                                                              |
| 6.  候補モデルのスクリーニング                               |
|                                                              |
| 7.  確率水文量のバイアス補正と安定性の評価                   |
|                                                              |
| 8.  確率分布モデルの決定                                     |
+--------------------------------------------------------------+

1.  []{#_Toc316205590 .anchor}候補確率分布モデルの列挙

＜例　示＞

  --------------------------------------------------------------------------------
  水文頻度解析に用いるモデルの候補を解析対象水文資料に応じて列挙する方法がある。
  --------------------------------------------------------------------------------

＜例　示＞

+----------------------------------------------------------------------+
| 水文時系                                                             |
| 列資料を一定の区間に分割し、それぞれの区間に含まれる最大値を収集した |
| 水文資料を区分最大値という。一般に極値資料とも呼ばれる。極値資料は3  |
| つの型の極値分布で表されることが証明されており、これらを一つの式で表 |
| したものが一般極値分布（GEV）である。一般極値分布の形状母数が0の場合 |
| がGumbel分布であり、$x\ $を変量とするときそれぞれ確率密度関数$f\lef  |
| t( x \right)$、確率分布関数$F\left( x \right)$は次のように表される。 |
|                                                                      |
| 1.  Gumbel分布                                                       |
|                                                                      |
|   $$f\left( x \right) = \frac{\exp\le                                |
| ft\{ - \frac{x - \xi}{\alpha} \right\}}{\alpha}\exp\left\lbrack - ex |
| p\left\{ - \frac{x - \xi}{\alpha} \right\} \right\rbrack$$   (3-1-6) |
|   -------------------------------------                              |
| -------------------------------------------------------------------- |
| ---------------------------------------------------------- --------- |
|   $$F\left( x \right) = exp\left\lbra                                |
| ck - \exp\left\{ - \frac{x - \xi}{\alpha} \right\} \right\rbrack$$   |
|                                                              (3-1-7) |
|                                                                      |
| 2.  一般極値分布                                                     |
|                                                                      |
|   $$f\left                                                           |
| ( x \right) = \frac{1}{\alpha}\left\{ 1 - \frac{k(x - \xi)}{\alpha}  |
| \right\}^{\frac{1}{k} - 1}\exp\left\lbrack - \left\{ 1 - \frac{k\lef |
| t( x - \xi \right)}{\alpha} \right\}^{1/k} \right\rbrack$$   (3-1-8) |
|   ----------                                                         |
| -------------------------------------------------------------------- |
| -------------------------------------------------------------------- |
| ---------------------------------------------------------- --------- |
|   $$F\left                                                           |
| ( x \right) = exp\left\lbrack - \left( 1 - k\frac{x - \xi}{\alpha} \ |
| right)^{1/k} \right\rbrack$$                                         |
|                                                              (3-1-9) |
|                                                                      |
| > ここに$\ \xi$：位置母数、$\alp                                     |
| ha$：尺度母数、$k$：形状母数であり、$\text{k\ }$=0の場合がGumbel分布 |
| である。なお、一般極値分布は$\text{k\ }$＞0の場合、上限値を有する。  |
|                                                                      |
|   --------------------------- ----------                             |
|   $$x \leq \xi + \alpha/k$$   (3-1-10)                               |
|   --------------------------- ----------                             |
|                                                                      |
| 9.  閾値超過資料（POT：peaks over                                    |
|     t                                                                |
| hreshold）は、閾値を超過する独立なピーク値を全て取り出した資料である |
| 。年最大値資料が他の年の年最大値より大きな年間第2位や3位などのデータ |
| を使わず、また、年によっては洪水とみなせないような事象を含むのに対し |
| 、適切に閾値を選べばこのように特性の異なる水文資料を含むことを回避で |
| きる利点がある。閾値の選定によく用いられる手法としては、標本平均超過 |
| 関数を用いる手法がある。以下に指数分布、一般Pareto分布を例示する。\  |
|     一般Pareto分布の形状母数が0の場合                                |
| が指数分布であり、$x\ $を変量とするとき、それぞれ確率密度関数$f\lef  |
| t( x \right)$、確率分布関数$F\left( x \right)$は次のように表される。 |
|                                                                      |
| ```{=html}                                                           |
| <!-- -->                                                             |
| ```                                                                  |
| 1.  指数分布                                                         |
|                                                                      |
|   $$f\left( x \right) = \frac                                        |
| {\exp\left\{ - \frac{x - \xi}{\alpha} \right\}}{\alpha}$$   (3-1-11) |
|   -----------------------------                                      |
| --------------------------------------------------------- ---------- |
|   $$F\left( x \right) = 1 - \                                        |
| exp\left\{ - \frac{x - \xi}{\alpha} \right\}$$              (3-1-12) |
|                                                                      |
| 3.  一般Pareto分布                                                   |
|                                                                      |
|   $$f\left( x \right) = \frac{1}{\alpha}\left\{                      |
|  1 - k\frac{x - \xi}{\alpha} \right\}^{\frac{1}{k} - 1}$$   (3-1-13) |
|   -----------------------------------------------                    |
| --------------------------------------------------------- ---------- |
|   $$F\left( x \right) = 1 - \left( 1 - k\frac{x                      |
|  - \xi}{\alpha} \right)^{1/k}$$                             (3-1-14) |
|                                                                      |
| > ここに、$\xi$：位置母数、$\alpha$：尺                              |
| 度母数、$k$：形状母数であり、$\text{k\ }$=0の場合が指数分布である。  |
| >                                                                    |
| > なお、一般Pareto分布は$\text{k\ }$＞0の場合、上限値を有する。      |
|                                                                      |
|   --------------------------- ----------                             |
|   $$x \leq \xi + \alpha/k$$   (3-1-15)                               |
|   --------------------------- ----------                             |
|                                                                      |
| 10. よく知られているように、誤差は正規分布                           |
| に従う。また、一定期間内の日降水量等の短時間降水量は指数分布で表され |
| る場合が多い。指数分布に従う二つの変量の和はガンマ分布で表される。こ |
| のように各分布の特徴や既往の事例などを踏まえ、対象とする水文資料の解 |
| 析においては適切と考えられる分布を列挙する。以下に正規分布、Pearson  |
|     Ⅲ型分布の確率密度                                                |
| 関数$f\left( x \right)$、確率分布関数$F\left( x \right)$を例示する。 |
|                                                                      |
| ```{=html}                                                           |
| <!-- -->                                                             |
| ```                                                                  |
| 1.  正規分布                                                         |
|                                                                      |
|   $$f\left( x \right) = \frac{1}                                     |
| {\sqrt{2\pi}\sigma}\exp\left\{ - \frac{1}{2}\left( \frac{x - \mu}{\s |
| igma} \right)^{2} \right\}$$                                (3-1-16) |
|   --------------------------------                                   |
| -------------------------------------------------------------------- |
| --------------------------------------------------------- ---------- |
|   $$F\left( x \right) = \frac{1}                                     |
| {\sqrt{2\pi}\sigma}\int_{- \infty}^{x}{exp\left\{ - \frac{1}{2}\left |
| ( \frac{t - \mu}{\sigma} \right)^{2} \right\}}\text{dt}$$   (3-1-17) |
|                                                                      |
| > ここに$\mu$：平均、$\si                                            |
| gma$：標準偏差である。特に、$\text{μ\ }$＝0、$\text{σ\ }$＝1の場合を |
| 標準正規分布と呼び、これに対する確率分布関数の数表が用意されている。 |
|                                                                      |
| 4.  Pearson Ⅲ型分布                                                  |
|                                                                      |
| > 形状母数 $\gamma$が0でなければ次の変数変換を行うと、               |
|                                                                      |
|   ------------------                                                 |
| -------------------------------------------------------------------- |
| --------------------------------------------------------- ---------- |
|   $$\alpha = \frac                                                   |
| {4}{\gamma^{2}},\ \ \beta = \frac{1}{2}\sigma\left| \gamma \right|,\ |
|  \ \xi = \mu - \frac{2\sigma}{\gamma},\ \ \gamma \neq 0$$   (3-1-18) |
|   ------------------                                                 |
| -------------------------------------------------------------------- |
| --------------------------------------------------------- ---------- |
|                                                                      |
| > $\gamma$の正負ごとに$x$                                            |
| > の分布範囲，確率密度関数$f\left( x                                 |
|  \right)$及び確率分布関数$F\left( x \right)$が以下のように表される。 |
| >                                                                    |
| > $\text{γ\ }$＞0 の場合、$x$の分布範囲： $\xi \leq x < \infty$      |
|                                                                      |
|   $$f\left(                                                          |
|  x \right) = \frac{\left( x - \xi \right)^{\alpha - 1}\exp\left\{ -  |
| (x - \xi)/\beta \right\}}{\beta^{\alpha}\Gamma(\alpha)}$$   (3-1-19) |
|   -----------                                                        |
| -------------------------------------------------------------------- |
| --------------------------------------------------------- ---------- |
|   $$F\left(                                                          |
|  x \right) = \frac{G\left( \alpha,\frac{x - \xi}{\beta} \right)}{\Ga |
| mma(\alpha)}$$                                              (3-1-20) |
|                                                                      |
| > $\text{γ\ }$＜0の場合、$x$ の分布範囲：$- \infty < x < \xi$        |
|                                                                      |
|   $$f\left(                                                          |
|  x \right) = \frac{\left( \xi - x \right)^{\alpha - 1}\exp\left\{ -  |
| (\xi - x)/\beta \right\}}{\beta^{\alpha}\Gamma(\alpha)}$$   (3-1-21) |
|   -----------                                                        |
| -------------------------------------------------------------------- |
| --------------------------------------------------------- ---------- |
|   $$F\left(                                                          |
|  x \right) = \frac{1 - G\left( \alpha,\frac{\xi - x}{\beta} \right)} |
| {\Gamma(\alpha)}$$                                          (3-1-22) |
|                                                                      |
| > ここに、$G\left( \alpha\ ,z\  \right)$ は不完全ガンマ関数          |
|                                                                      |
|   -----------------------------------                                |
| --------------------------------------------------------- ---------- |
|   $$G\left( \alpha,z \right) = \int                                  |
| _{0}^{z}{t^{\alpha - 1}\exp\left( - t \right)\text{dt}}$$   (3-1-23) |
|   -----------------------------------                                |
| --------------------------------------------------------- ---------- |
|                                                                      |
| > である。                                                           |
| >                                                                    |
| > Pearson                                                            |
| > Ⅲ型                                                                |
| 分布は$\text{γ\ }$が0に近づくとき、正規分布に漸近し、$\text{γ\ }$=2  |
| > の場合、指数分布となる。                                           |
+----------------------------------------------------------------------+

1.  []{#_Toc308536269 .anchor}確率分布モデルの母数推定

＜例　示＞

+----------------------------------------------------------------------+
| 解析対象水文資料を用いて候補モデ                                     |
| ルの母数を求める際には、標本の大きさに応じて適切な推定法を用いるなど |
| の手法があり、積率法、L積率法、最尤法等の手法が用いられている。なお  |
| 、小標本（標本サイズ＜30）については、L積率法がよく用いられている。  |
|                                                                      |
| １）積率法                                                           |
|                                                                      |
| 従来、確率分布モデルの母数推定に当たっては                           |
| その原点及び平均値まわりの積率、すなわち、平均値、分散、歪みをそれぞ |
| れ標本から得られる標本平均、不偏分散、不偏歪み等に等しいとおいて分布 |
| モデルの母数を推定する積率法を用いて、分布モデルの母数を求めてきた。 |
|                                                                      |
| 確率分布モデルの確率密度関数を$f\left( x \right)$とす                |
| るとき、この平均$\mu$、分散$\sigma^{2}$及び歪み$\gamma$はそれぞれ、  |
|                                                                      |
|   $$\mu = \int_{- \infty}^{\infty}                                   |
| {xf\left( x \right)\text{dx}}$$                             (3-1-24) |
|   ----------------------------------                                 |
| --------------------------------------------------------- ---------- |
|   $$\sigma^{2} = \int_{- \infty}^{                                   |
| \infty}{x^{2}f\left( x \right)\text{dx}} - \mu^{2}$$        (3-1-25) |
|   $$\gamma = \frac{\int_{- \infty}                                   |
| ^{\infty}{x^{3}f\left( x \right)\text{dx}}}{\sigma^{3}}$$   (3-1-26) |
|                                                                      |
| と表される。一方、標本$\left\{ X_{1},X_{2},\cdot                     |
| s,X_{n} \right\}$から得られる標本平均${\widehat{\mu}}_{X}$、不偏分散 |
| ${{\widehat{\sigma}}_{X}}^{2}$、不偏歪み${\widehat{\gamma}}_{X}$は、 |
|                                                                      |
|   $${\widehat{\mu}}_{x} = \frac{1}{n}\s                              |
| um_{i = 1}^{n}X_{i}$$                                                |
|                                                             (3-1-27) |
|   ---------------------------------------                            |
| -------------------------------------------------------------------- |
| --------------------------------------------------------- ---------- |
|   $${{\widehat{\sigma}}_{X}}^{2} = \fra                              |
| c{1}{n - 1}\sum_{i = 1}^{n}\left( X_{i} - \overline{X} \right)^{2}$$ |
|                                                             (3-1-28) |
|   $${\widehat{\gamma}}_{X} = \frac{n}{\                              |
| left( n - 1 \right)\left( n - 2 \right){{\widehat{\sigma}}_{X}}^{3}} |
| \sum_{i = 1}^{n}\left( X_{i} - \overline{X} \right)^{3}$$   (3-1-29) |
|                                                                      |
| と表される。$f\lef                                                   |
| t( x \right)$が2母数の場合、(3-1-24)と(3-1-25)の左辺を(3-1-27)と(3-1 |
| -28)に置き換えて連立方程式を解くことにより、母数を求めることができる |
| 。3母数の場合、(3-1-24)、(3-1-25)及び(3-1-26)の左辺を(3-1-27)、(3-1  |
| -28)及び(3-1-29)に置き換えて連立方程式を解くことにより、母数を求める |
| ことができる。なお、3母数の場合、種々の歪みの補正が提案されている。  |
|                                                                      |
| ２）L積率法                                                          |
|                                                                      |
| 大きく外れたデータが含まれ歪                                         |
| んだ水文資料に対処するために考案された手法がPWM(probability-weighted |
| moments)やL積率（L                                                   |
| Moments）を用いる                                                    |
| 手法である。L積率は順序統計量の線形和で表される特徴を持つ(Lはlinear  |
| combinationsに由来する)。                                            |
|                                                                      |
| $X_{j}\left( j = 1,2,\cdots,n \                                      |
| right)\ $を標本から得られた順序統計量$\left( X_{1} \geq X_{2} \geq X |
| _{3},\cdots,{\geq X}_{n} \right)$とするとき、PWMは次式で定義される。 |
|                                                                      |
|   -----------------------------------------------                    |
| --------------------------------------------------------- ---------- |
|   $$\beta_{r} = E\left\{ X\left\lbrack F(X) \ri                      |
| ght\rbrack^{r} \right\} = \int_{0}^{1}{xF^{r}\text{dt}}$$   (3-1-30) |
|   -----------------------------------------------                    |
| --------------------------------------------------------- ---------- |
|                                                                      |
| PWMの                                                                |
| 標本推定値を算定するには2つの方法がある。最も単純な方法は確率分布関  |
| 数$F\left( x \right)$にプロッティング・ポジションを使う方法である。  |
|                                                                      |
|   -------------------------------------------------------            |
| --------------------------------------------------------- ---------- |
|   $${\widehat{\beta}}_{r} = \frac{1}{n}\sum_{j = 1}^{n}              |
| {X_{j}\left\lbrack 1 - \frac{j -}{n} \right\rbrack^{r}}$$   (3-1-31) |
|   -------------------------------------------------------            |
| --------------------------------------------------------- ---------- |
|                                                                      |
| もう一つの方法は不偏推定値を求める方法であり、次式で表される。       |
|                                                                      |
|   ------------------------                                           |
| --------------------------------------------------------- ---------- |
|   $${\widehat{\beta}}_{r                                             |
| } = \frac{1}{n}\sum_{j = 1}^{n - r}{\frac{\begin{pmatrix}   (3-1-32) |
|   n - j \\                                                           |
|                                                                      |
|   r \\                                                               |
|                                                                      |
|   \end{pmatrix}X                                                     |
| _{j}}{\begin{pmatrix}                                                |
|   n - 1 \\                                                           |
|                                                                      |
|   r \\                                                               |
|                                                                      |
|   \end{pmatrix}}                                                     |
|  =}\frac{1}{r + 1}\sum_{j = 1}^{n - r}\frac{\begin{pmatrix}          |
|   n - j \\                                                           |
|                                                                      |
|   r \\                                                               |
|                                                                      |
|   \end{pmatrix}X                                                     |
| _{j}}{\begin{pmatrix}                                                |
|   n \\                                                               |
|                                                                      |
|   r + 1 \\                                                           |
|                                                                      |
|   \end{pmatrix}}                                                     |
| $$                                                                   |
|   ------------------------                                           |
| --------------------------------------------------------- ---------- |
|                                                                      |
| こ                                                                   |
| の式を$\text{r\ }$＝0、1、2、3について具体的に書くと次のようになる。 |
|                                                                      |
|   $${\widehat{\beta}}_{0} = \overline{X}$$                           |
|                                                                      |
|                                                             (3-1-33) |
|   -----------------------------------------------------------        |
| -------------------------------------------------------------------- |
| --------------------------------------------------------- ---------- |
|   $${\widehat{\beta}}_{1} = \sum_{j = 1}^{n - 1}\frac{(n -           |
| j)X_{j}}{n(n - 1)}\text{\ \ \ \ \ }$$                                |
|                                                             (3-1-34) |
|   $${\widehat{\beta}}_{2} = \sum_{j = 1}^{n - 2}\frac{\left          |
| ( n - j \right)\left( n - j - 1 \right)X_{j}}{n\left( n - 1 \right)\ |
| left( n - 2 \right)}\text{\ \ \ \ \ }$$                     (3-1-35) |
|   $${\widehat{\beta}}_{3} = \sum_{j = 1}^{n - 3}\frac{\left          |
| ( n - j \right)\left( n - j - 1 \right)(n - j - 2)X_{j}}{n\left( n - |
|  1 \right)\left( n - 2 \right)(n - 3)}\text{\ \ \ \ \ }$$   (3-1-36) |
|                                                                      |
| このようにして求めたPWMを用いてL積率は、次式で求めることができる。   |
|                                                                      |
|   $$\lambda_{1} = \beta_{0}$$                                        |
|                                                             (3-1-37) |
|   ------------------------------------------------------------------ |
| --------------------------------------------------------- ---------- |
|   $$\lambda_{2} = 2\beta_{1} - \beta_{0}$$                           |
|                                                             (3-1-38) |
|   $$\lambda_{3} = 6\beta_{2} - 6\beta_{1} + \beta_{0}$$              |
|                                                             (3-1-39) |
|   $$\lambda_{4} = 20\beta_{3} - 30\beta_{2} + 12\beta_{1} - \beta_   |
| {0}$$                                                       (3-1-40) |
|   $$\tau_{2} = \frac{\lambda_{2}}{\lambda_{1}}\text{\ \ \ \ \ \ }\   |
| left( L - CV \right)\text{\ \ \ \ \ \ \ \ \ \ \ \ \ \ }$$   (3-1-41) |
|   $$\tau_{3} = \frac{\lambda_{3}}{\lambda_{2}}\text{\ \ \ \ \ \ }(   |
| L - skewness)$$                                             (3-1-42) |
|   $$\tau_{4} = \frac{\lambda_{4}}{\lambda_{2}}\text{\ \ \ \ \ \ }\   |
| left( L - kurtosis \right)\text{\ \ \ }$$                   (3-1-43) |
|                                                                      |
| これらのL積率を各確率分布モデルの母数とL積率の関係を表す連立方       |
| 程式に代入することにより各確率分布モデルの母数を求めることができる。 |
|                                                                      |
| 1.  Gumbel分布                                                       |
|                                                                      |
|   --------------------------------                                   |
| --------------------------------------------------------- ---------- |
|   $$\alpha = \frac{\lambda_{2}}{                                     |
| \log 2\ \ \ ,\ \ \ \ \ \ \xi = \lambda_{1} - \text{αγ}}$$   (3-1-44) |
|   --------------------------------                                   |
| --------------------------------------------------------- ---------- |
|                                                                      |
| ここに$\gamma$：オイラーの定数であり、約0.577216である。             |
|                                                                      |
| 5.  一般極値分布（GEV）                                              |
|                                                                      |
|   $$k \approx 7.8590c + 2.9554c^{2}\ \ ,\ \ \                        |
|  \ \ c = \frac{2}{3 + \tau_{3}} - \frac{\log 2}{\log 3}$$   (3-1-45) |
|   ---------------------------------------------                      |
| --------------------------------------------------------- ---------- |
|   $$\alpha = \frac{\lambda_{2}k}{\left( 1 - 2                        |
| ^{- k} \right)\Gamma(1 + k)}$$                              (3-1-46) |
|   $$\xi = \lambda_{1} - \alpha\frac{\left\{ 1                        |
|  - \Gamma(1 + k) \right\}}{k}$$                             (3-1-47) |
|                                                                      |
| 6.  指数分布                                                         |
|                                                                      |
|   -------------                                                      |
| --------------------------------------------------------- ---------- |
|   $$\alpha =                                                         |
| 2\lambda_{2}\ \ ,\ \ \ \ \ \ \xi = \lambda_{1} - \alpha$$   (3-1-48) |
|   -------------                                                      |
| --------------------------------------------------------- ---------- |
|                                                                      |
| 下限値$\xi\ $が既知の場合                                            |
|                                                                      |
|   -------------------------------- ----------                        |
|   $$\alpha = \lambda_{1} - \xi$$   (3-1-49)                          |
|   -------------------------------- ----------                        |
|                                                                      |
| 7.  一般Pareto分布                                                   |
|                                                                      |
|   $$k = \frac{1 - 3\tau_{3}}{1 + \tau_{3}}$$            (3-1-50)     |
|   ----------------------------------------------------- ----------   |
|   $$\alpha = \left( 1 + k \right)(2 + k)\lambda_{2}$$   (3-1-51)     |
|   $$\xi = \lambda_{1} - (2 + k)\lambda_{2}$$            (3-1-52)     |
|                                                                      |
| 下限値$\text{ξ\ }$が既知の場合                                       |
|                                                                      |
|   $$k = \frac{(\lambda_{1} - \xi)}{\lambda_{2}} - 2$$    (3-1-53)    |
|   ------------------------------------------------------ ----------  |
|   $$\alpha = \left( 1 + k \right)(\lambda_{1} - \xi)$$   (3-1-54)    |
|                                                                      |
| 8.  正規分布                                                         |
|                                                                      |
|   -----------                                                        |
| --------------------------------------------------------- ---------- |
|   $$\mu = \                                                          |
| lambda_{1}\ \ ,\ \ \ \ \ \sigma = \sqrt{\pi}\lambda_{2}$$   (3-1-55) |
|   -----------                                                        |
| --------------------------------------------------------- ---------- |
|                                                                      |
| 9.  Pearson Ⅲ型分布                                                  |
|                                                                      |
|   $$\alph                                                            |
| a \approx \frac{1 + 0.2906z}{z + 0.1882z^{2} + 0.0442z^{3}},z = 3\pi |
| {\tau_{3}}^{2},\ \text{for}\ 0 < \ \left| \tau_{3} \right| < \ \frac |
| {1}{3}$$                                                    (3-1-56) |
|   ---------                                                          |
| -------------------------------------------------------------------- |
| -------------------------------------------------------------------- |
| --------------------------------------------------------- ---------- |
|   $$\alph                                                            |
| a \approx \frac{0.36067z - 0.59567z^{2} + 0.25361z^{3}}{1 - 2.78861z |
|  + 2.56096z^{2} - 0.77045z^{3}},z = 1 - \left| \tau_{3} \right|\ ,\  |
| \text{for}\ \frac{1}{3} < \ \left| \tau_{3} \right| < 1$$   (3-1-57) |
|                                                                      |
| $\alpha$ が与えられる場合には次式の方がよい。                        |
|                                                                      |
|   ---------------                                                    |
| -------------------------------------------------------------------- |
| -------------------------------------------------------------------- |
| --------------------------------------------------------- ---------- |
|   $$\gamma = \f                                                      |
| rac{2}{\sqrt{\alpha}}\text{sign}(\tau_{3})\lambda_{1}\ \ ,\ \ \ \ \  |
| \sigma = \frac{\lambda_{2}\sqrt{\alpha\pi}\Gamma(\alpha)}{\Gamma\lef |
| t( \alpha + \frac{1}{2} \right),\ \ \ \mu =}\lambda_{1}$$   (3-1-58) |
|   ---------------                                                    |
| -------------------------------------------------------------------- |
| -------------------------------------------------------------------- |
| --------------------------------------------------------- ---------- |
|                                                                      |
| ３）最尤法                                                           |
|                                                                      |
| 確率密度関数が$f\left( x \right) = f\left( x;\theta \right)$         |
| で与えられ、母数ベクトルを$\theta$とするとき、次式で表される尤度関数 |
|                                                                      |
|   ----------------------------------------------------------         |
| --------------------------------------------------------- ---------- |
|   $$L\left( \theta \right) = L\left( \theta,X_{1},X_{2},\c           |
| dots,X_{n} \right) = \prod_{j = 1}^{n}{f(X_{j},\theta)}$$   (3-1-59) |
|   ----------------------------------------------------------         |
| --------------------------------------------------------- ---------- |
|                                                                      |
| を最大にする母数ベクトル                                             |
|                                                                      |
|   ---------------------                                              |
| --------------------------------------------------------- ---------- |
|   $$L\left( \widehat{                                                |
| \theta} \right) = \max_{\theta}{L\left( \theta \right)}$$   (3-1-60) |
|   ---------------------                                              |
| --------------------------------------------------------- ---------- |
|                                                                      |
| を推定値とする手法が最尤法である。通常は尤度関数の自                 |
| 然対数をとった対数尤度関数を最大にすることにより最尤推定量を求める。 |
+----------------------------------------------------------------------+

1.  []{#_Toc308536270 .anchor}候補確率分布モデルのスクリーニング

＜例　示＞

+----------------------------------------------------------------------+
| 候補                                                                 |
| モデルの解析対象水文資料への適合度を評価する手法としてSLSC(Standard  |
| Least Square                                                         |
| Criterion)が用いられてきている。SLSCは次式で定義される。             |
|                                                                      |
|   -------------------------                                          |
| -------------------------------------------------------------------- |
| --------------------------------------------------------- ---------- |
|   $$\text{SLSC} = \frac{\                                            |
| sqrt{\xi^{2}}}{\left| S_{99} - S_{01} \right|}\ \ \ ,\ \ \ \xi^{2} = |
|  \frac{1}{n}\sum_{i = 1}^{n}{(s_{i} - {s_{i}}^{*})}^{2}$$   (3-1-61) |
|   -------------------------                                          |
| -------------------------------------------------------------------- |
| --------------------------------------------------------- ---------- |
|                                                                      |
| ここに、$s_{99}\ $及び$s_{01}$                                       |
| はそれぞれ非超過確率0.99と0.01に対する当該確率分布の                 |
| 標準変量、$n$：標本の大きさ、$s_{i}$：順序統計量を推定母数で変換した |
| 標準変量、$s_{i}^{*}$：確率分布モデルで求めたプロッティング・ポジシ  |
| ョンに対応するクォンタイルを推定母数によって変換した標準変量である。 |
|                                                                      |
| SLSCは値が小さいほど適合度が良いと判断される規準であ                 |
| り、これが一定の水準を満たすことによりスクリーニングを行なう。SLSCは |
| 0.04以下であれば適合度を満足するとして用いられてきている場合が多い。 |
|                                                                      |
| プロッティング・ポジションとしてはこれま                             |
| でにいろいろな式が提案されている。水文資料から得られた順序統計量$\le |
| ft( X_{1} \geq X_{2} \geq X_{3},\cdots,{\geq X}_{n} \right)$の$\ i\  |
| $番目の値の超過確率$p_{i}\ $は次式により、統一的に表すことができる。 |
|                                                                      |
|   ------------------------------------------------ ----------        |
|   $$p_{i} = \frac{i - \alpha}{n - 2\alpha + 1}$$   (3-1-62)          |
|   ------------------------------------------------ ----------        |
|                                                                      |
| ここに、$n$：標本サイズ、$\alpha$：プ                                |
| ロッティング・ポジションを決める定数であり、提案者により異なる。Weib |
| ull:0、Blom:0.375、Cunnane:0.4、Gringorten:0.44、Hazen:0.5等がある。 |
|                                                                      |
| SLSCを求める際にはプロッティング・                                   |
| ポジションとして多くの分布によく適合するCunnaneプロットがよく用いら  |
| れている。なお、小標本の場合は、Weibullプロットを用いる手法がある。  |
|                                                                      |
| なお、SLSCによる適合度の評価と併せて適切                             |
| な確率紙にプロットしてモデルの適合度を確認する手法が用いられている。 |
+----------------------------------------------------------------------+

＜例　示＞

+----------------------------------------------------------------------+
| 確率分布モデルの適合                                                 |
| 度を確認する手法として、Gumbel確率紙及び指数確率紙を用いた例を示す。 |
|                                                                      |
| ![](media/image28.png){width="5.588236001749781in"                   |
| height="3.2521008311461066in"}                                       |
|                                                                      |
| +-------------------------+-----------------------+                  |
| | 1.  Gumbel確率紙の事例\ | 2.  指数確率紙の事例\ |                  |
| |     （極値資料）        |     （POT資料）       |                  |
| +-------------------------+-----------------------+                  |
|                                                                      |
| 　　                                                                 |
+----------------------------------------------------------------------+

1.  []{#_Toc308536271 .anchor}確率水文量のバイアス補正と安定性の評価

＜例　示＞

+----------------------------------------------------------------------+
| 一定レベルの適                                                       |
| 合度を満足する確率分布モデルを対象に、必要に応じてリサンプリング手法 |
| を用いることにより、確率分布モデルの確率水文量のバイアスを補正すると |
| ともにその安定性を評価する手法としてjackknife法やbootstrap法がある。 |
|                                                                      |
| jackknife法                                                          |
| は大きさ$\text{n\ }$個の標本のうち$\ \text{i\ }$番目の１データのみを |
| 欠いたデータ数$n - 1$個の標本を全ての$\text{i\ }$について作成し（$n$ |
| セット作成することになる）、これらの標本から求めた統                 |
| 計量をもとに不偏推定値及びそのまわりの推定誤差を算定する手法である。 |
|                                                                      |
| 一方、bootstrap法は大きさ$n$                                         |
| 個の標本から重複を許して任                                           |
| 意に$\text{n\ }$個取り出した標本を複数作成し、これらの標本から求めた |
| 統計量を基に不偏推定値及びそのまわりの推定誤差を算定する手法である。 |
|                                                                      |
| jackknife法は計算回数が少なく、作成する標本数、不偏                  |
| 推定値及び推定誤差が一意的に定まるのに対し、bootstrap法は作成する標  |
| 本数が任意に設定でき、作成する標本数によって不偏推定値や推定誤差が異 |
| なる。両手法によるバイアス（偏倚）補正量は、bootstrap法のバイアス補  |
| 正量がjackknife法のバイアス補正量の$\frac{\left( n - 1 \right)}{n}$  |
| となるが、$n$ が極端に小さくなければこの差は小さい。                 |
|                                                                      |
| jackknife法の具体的手順は以                                          |
| 下のとおりである。大きさ$\text{n\ }$の標本の各データを$X_{1},X_{2},\ |
| cdots,X_{n}$とする。これを用いて求める母集団の特性を推定する統計量を |
|                                                                      |
|   ---------                                                          |
| --------------------------------------------------------- ---------- |
|   $$\wide                                                            |
| hat{\psi} = \psi\left( X_{1},X_{2},\cdots,X_{n} \right)$$   (3-1-63) |
|   ---------                                                          |
| --------------------------------------------------------- ---------- |
|                                                                      |
| とする。大きさ$\text{n\ }$個の標本のうち$\text{i\                    |
|  }$番目の１データのみを欠いたデータ数$n - 1$個の標本を用いた統計量を |
|                                                                      |
|   -----------------------------------------------------------        |
| --------------------------------------------------------- ---------- |
|   $${\widehat{\psi}}_{\left( i \right)} = \psi\left( X_{1},          |
| X_{2},\cdots,{X_{i - 1},X_{i + 1},\cdots,X}_{n} \right)$$   (3-1-64) |
|   -----------------------------------------------------------        |
| --------------------------------------------------------- ---------- |
|                                                                      |
| とする。${\widehat{\psi}}_{\left( i \right)}                         |
| $は$\ i = 1,2,\cdots n\ $に対して求まるので$n\ $個求まることになる。 |
|                                                                      |
| ${\widehat{\psi}}_{\left( i \right)}$の平均値を                      |
|                                                                      |
|   -------------------------------------------------------            |
| --------------------------------------------------------- ---------- |
|   $${\widehat{\psi}}_{\left( \bullet \right)} = \frac{1              |
| }{n}\sum_{i = 1}^{n}{\widehat{\psi}}_{\left( i \right)}$$   (3-1-65) |
|   -------------------------------------------------------            |
| --------------------------------------------------------- ---------- |
|                                                                      |
| により求める。バイアス推定値は次式で与えられる。                     |
|                                                                      |
|   ------------------------------------------------------------------ |
| --------------------------------------------------------- ---------- |
|   $$\widehat{\text{BIAS}} = \left( n - 1 \right)\left( {\widehat{\   |
| psi}}_{\left( \bullet \right)} - \widehat{\psi} \right)$$   (3-1-66) |
|   ------------------------------------------------------------------ |
| --------------------------------------------------------- ---------- |
|                                                                      |
| これを                                                               |
| 用いて統計量のバイアスを補正したjackknife推定値は次式で与えられる。  |
|                                                                      |
|   --------------------                                               |
| -------------------------------------------------------------------- |
| --------------------------------------------------------- ---------- |
|   $$\widetilde{\psi}                                                 |
|  = \widehat{\psi} - \widehat{\text{BIAS}} = n\widehat{\psi} - \left( |
|  n - 1 \right){\widehat{\psi}}_{\left( \bullet \right)}$$   (3-1-67) |
|   --------------------                                               |
| -------------------------------------------------------------------- |
| --------------------------------------------------------- ---------- |
|                                                                      |
| また、jackknife法による推定誤差分散は、                              |
|                                                                      |
|   ---------------------------------                                  |
| -------------------------------------------------------------------- |
| --------------------------------------------------------- ---------- |
|   $$\widehat{\text{VAR}} = \frac{                                    |
| n - 1}{n}\sum_{i = 1}^{n}\left( {\widehat{\psi}}_{\left( i \right)}  |
| - {\widehat{\psi}}_{\left( \bullet \right)} \right)^{2}$$   (3-1-68) |
|   ---------------------------------                                  |
| -------------------------------------------------------------------- |
| --------------------------------------------------------- ---------- |
|                                                                      |
| で求められる。                                                       |
|                                                                      |
| jackknife法を適用し                                                  |
| ない場合の統計量が$\frac{1}{n}\ $のオーダーのバイアスを有しているの  |
| に対し、(3-1-67)で示されるjackknife推定値のバイアスは$\frac{1}{n^{2  |
| }}\ $のオーダーであり、jackknife法によるバイアスの補正が有効である。 |
+----------------------------------------------------------------------+

2.  []{#_Toc308536272 .anchor}確率分布モデルの決定

＜例　示＞

+----------------------------------------------------------------------+
| 適合度の基準を満足する確率分布モデルを用いる方法がある。             |
|                                                                      |
| 確率分布モデルを選択する場                                           |
| 合には、適合度の基準を満足するものの中から安定性の良好な確率分布モデ |
| ルを採用する方法がある。この場合、本節の[1.3.4](http://www.yahoo.co  |
| .jp)で求められた確率水文量の推定誤差分散の平方根である推定誤差を指標 |
| とし、相対的にこれが小さい確率分布モデルを選択する方法が考えられる。 |
|                                                                      |
| 超過確率若しく                                                       |
| は非超過確率に対応する確率水文量又は任意の規模の変量に対応する超過確 |
| 率若しくは非超過確率は、用いることとした確率分布モデルから推定する。 |
|                                                                      |
| 任意の規                                                             |
| 模の変量$\text{x\ }$に対応する非超過確率$\text{F\ }$を求めるには確率 |
| 分布関数$F\left( x \right)$の$\text{x\ }$に単に代入すればよい。超過  |
| 確率は$1 - F$で求めることができる。超過確率の逆数が再現期間（return  |
| period）である。                                                     |
|                                                                      |
|   ---------------------------------------------------- ----------    |
|   $$\text{Retu}rn\ \text{Period} = \frac{1}{1 - F}$$   (3-1-69)      |
|   ---------------------------------------------------- ----------    |
|                                                                      |
| 確率水文量を求めるには、用いることとした分                           |
| 布の確率分布関数$F\left( x \right)$を変量$\text{x\ }$について解いた  |
| 式に、非超過確率$\text{F\ }$を代入して確率水文量を求める。年最大値等 |
| の極値資料を対象とする分布の確率水文量を求めるための例を以下に示す。 |
|                                                                      |
| Gumbel分布                                                           |
|                                                                      |
|   ------                                                             |
| --------------------------------------------------------- ---------- |
|   $$x\                                                               |
| left( F \right) = \xi - \alpha \bullet \log( - \log(F))$$   (3-1-70) |
|   ------                                                             |
| --------------------------------------------------------- ---------- |
|                                                                      |
| 11. 一般極値分布                                                     |
|                                                                      |
|   ----------------------------------------------------------         |
| --------------------------------------------------------- ---------- |
|   $$x\left( F \right) = \xi + \frac{\alpha\left\{ 1 - {( -           |
|  \log(F))}^{k} \right\}}{k}\ \ \ \ \ \ \ \ \ (k \neq 0)$$   (3-1-71) |
|   ----------------------------------------------------------         |
| --------------------------------------------------------- ---------- |
|                                                                      |
| POTの閾値を超え                                                      |
| る変量、その非超過確率を表す確率分布関数$G\left( x \right)$及び年最  |
| 大値資料の確率分布関数$F\left( x \right)$の間には次式の関係がある。  |
|                                                                      |
|   ---------                                                          |
| --------------------------------------------------------- ---------- |
|   $$F\lef                                                            |
| t( x \right) = \exp\left\{ - \lambda(1 - G(x)) \right\}$$   (3-1-72) |
|   ---------                                                          |
| --------------------------------------------------------- ---------- |
|                                                                      |
| ここに、$\la                                                         |
| mbda$は閾値を超える事象の年間発生率である。この式を$G\left( x \right |
| )$について解き、年最大値資料の非超過確率$F$に対応する非超過確率$G$を |
| 次式で求め、これを(3-1-12)や(3-1-14)の$F\left( x \right)$の代わりに  |
| 置き換えて$\text{x\ }$ついて解けば、(3-1-74)や(3-1-75)になり、年最大 |
| 値資料を対象とした再現期間に対応する確率水文量を求めることができる。 |
|                                                                      |
|   ------------------------------------- ----------                   |
|   $$G = 1 + \frac{\log(F)}{\lambda}$$   (3-1-73)                     |
|   ------------------------------------- ----------                   |
|                                                                      |
| 12. 指数分布                                                         |
|                                                                      |
|   --------------------------------                                   |
| --------------------------------------------------------- ---------- |
|   $$x\left( F \right) = \xi - \a                                     |
| lpha \cdot \log\left( - \frac{\log(F)}{\lambda} \right)$$   (3-1-74) |
|   --------------------------------                                   |
| --------------------------------------------------------- ---------- |
|                                                                      |
| 13. 一般Pareto分布                                                   |
|                                                                      |
|   --------------------                                               |
| -------------------------------------------------------------------- |
| --------------------------------------------------------- ---------- |
|   $$x\left( F \right                                                 |
| ) = \xi + \alpha\frac{\left\{ 1 - \left( - \frac{\log(F)}{\lambda} \ |
| right)^{k} \right\}}{k\ \ \ \ \ \ \ \ \ \ \ (k \neq 0)}$$   (3-1-75) |
|   --------------------                                               |
| -------------------------------------------------------------------- |
| --------------------------------------------------------- ---------- |
|                                                                      |
| 14. 正規分布                                                         |
|                                                                      |
| 正規分布の確率分布関数の逆関数は陽には表せないので、標準正規分       |
| 布表を用いるか、誤差関数の逆関数を用いるなどして確率水文量を求める。 |
+----------------------------------------------------------------------+

[]{#_Toc308536274 .anchor}

1.  確率分布モデルの決定に関する補足事項

＜例　示＞

+----------------------------------------------------------------------+
| 本節の[1.3.5]                                                        |
| (http://www.yahoo.co.jp)の確率分布モデル選定において判断が難しい場合 |
| は、赤池の情報量基準(AIC)による評価も併せて用いる手法が考えられる。  |
|                                                                      |
| AICは次式で定義される。                                              |
|                                                                      |
|   ----------------------------------- ----------                     |
|   $$\text{AIC} = 2m - 2\text{MLL}$$   (3-1-76)                       |
|   ----------------------------------- ----------                     |
|                                                                      |
| ここに$\t                                                            |
| ext{m\ }$は母数ベクトルの次元数（母数の数）である。MLLは最大対数尤度 |
|                                                                      |
|   -------------------------------------------------                  |
| --------------------------------------------------------- ---------- |
|   $$\text{MLL} = \sum_{i = 1}^{n}{\log\left\lbrac                    |
| k f\left( X_{i},\widehat{\theta} \right) \right\rbrack}$$   (3-1-77) |
|   -------------------------------------------------                  |
| --------------------------------------------------------- ---------- |
|                                                                      |
| であり、母数ベクトル$\widehat{\theta}\ $は最尤推定量であるが、       |
| L積率を用いて母数推定した場合にはその母数ベクトルを代わりに用いる。  |
|                                                                      |
| 一般に母数の数が多くなると分布の適合度                               |
| はよくなる。AICは母数の数を考慮していることが適合度のみを評価する他  |
| の規準とは異なる。AICの値が小さいほどよいモデルであると判断される。  |
+----------------------------------------------------------------------+

＜参考となる資料＞

本基準に従い水文頻度解析を実施する際には、下記の資料が参考となる。

岩井重久，石黒政儀：応用水文統計学，森北出版，1970.

1.  角屋睦：水文統計論，土木学会水理委員会
    水工学シリーズ，64-02，p.59，1964.

```{=html}
<!-- -->
```
120. 高橋倫也：極値統計学，統計数理研究所公開講座，p.57，2008.

121. 宝馨：水文頻度解析の進歩と将来展望，水文・水資源学会誌，Vol.11
     > No.7，pp.740-756，1998.

122. 水文・水資源学会編集：水文・水資源ハンドブック，pp.238-248
     > 7.3　水文頻度解析，朝倉書店，1997.

123. Stedinger, J.R., R.M. Vogel, and E. Foufoula-Georgiou：Frequency
     > Analysis of Extreme Events，Chap. 18, Handbook of Hydrology,
     > (Ed.) D. R. Maidment, McGraw-Hill, New York，pp.18.1-18.66，1993.

124. 林敬大，立川康人，椎葉充晴，萬和明，Kim
     > Sunmin：SLSCによる水文頻度解析モデル適合度評価への統計的仮説検定の導入，土木学会論文集B1(水工学)，Vol.68
     > No.4，pp.1381-1386，2012.

125. 葛葉泰久：治水計画策定における統計的手法－SLSC及び費用便益分析に関する考察－，土木学会論文集，Vol.66
     > No.1，pp.66-75，2010.

     1.  []{#_Toc308536275 .anchor}非定常な水文量の頻度解析

＜例　示＞

+----------------------------------------------------------------------+
| 定常とみなせ                                                         |
| ない場合の水文量の頻度解析として、以下の手順による方法が考えられる。 |
|                                                                      |
| 1.  水文資                                                           |
| 料の周期性やジャンプの有無を検討し、これらを含まない水文資料とする。 |
|                                                                      |
| 2.  水文時系列資料の統計特性の時間的変化がモデ                       |
| ルの中に組み込まれた確率分布モデルの母数を推定し、確率評価を行う。例 |
| えば、年最大値等の極値資料を扱う一般極値分布の場合やPOT資料を扱う一  |
| 般Pareto分布の場合、位置母数、尺度母数及び形状母数の3母数で表される  |
| が、そのうち、位置母数及び尺度母数が時間的に変化するモデルを考える。 |
|                                                                      |
|   $\xi\left( t \right) = \beta_{0} + \beta_{1}t　$又は　$\xi\l       |
| eft( t \right) = \beta_{0} + \beta_{1}t + \beta_{2}t^{2}$   (3-1-78) |
|   --------------------------------------------------------------     |
| --------------------------------------------------------- ---------- |
|   $$\alpha\left( t \right) = \exp(\beta_{3} + \beta_{4}t)$$          |
|                                                             (3-1-79) |
|                                                                      |
| このような母数の中のパラメータ                                       |
| を最尤法で解くことにより、時系列変化を表す確率分布モデルを推定する。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

時系列資料の統計特性の時間的変化をモデルの中に組み込んだ確率分布モデルの詳細については、下記の資料が参考となる。

Coles, S.：An Introduction to Statistical Modeling of Extreme
Values，Springer，p.208，2001.

1.  高橋倫也：極値統計学，統計数理研究所公開講座，p.57，2008.

    1.  []{#_Toc308536276 .anchor}時系列変化特性の解析

＜考え方＞

+----------------------------------------------------------------------+
| 水文現象には時間的にある程度                                         |
| 規則性を持ちつつかつ徐々に平均や分散等の統計的特性が変化すると考えら |
| れるものが多い。時系列解析はこの時間変化の特性を定量的に明らかにする |
| ことを目的とした解析法を総称したものであり、以下の方法が考えられる。 |
|                                                                      |
| 時系列現象の変化状態を大別すると、一般に長期的傾向変化（トレンド）、 |
| 周期性変化、持続性変化及び偶然性の変化に分けられる。これらの特性を定 |
| 量的に明らかにする場合には、それぞれに対応した解析方法が必要である。 |
|                                                                      |
| 気候変化等の影響を受け解析対象水文資料の                             |
| 統計的特性が経年的に変化していると判断される場合の水文頻度解析には、 |
| 本節の[1.4](http://www.yahoo.co.jp)の非定常性を考慮した検討を行う。  |
|                                                                      |
| な                                                                   |
| お、水文資料の統計的特性は観測期間により経年的な変化の有意性が異なる |
| ため、観測期間の取り方を変えた評価を行うなど慎重な検討が必要である。 |
+----------------------------------------------------------------------+

＜例　示＞

+----------------------------------------------------------------------+
| 水文時系列資料の時間経過に対する状態の傾向を把握する方法として、次   |
| に示す事項のいずれかの方法又はこれらを組み合わせた方法が考えられる。 |
|                                                                      |
| 1.  経過時間と、対応                                                 |
| する水文資料の値を図化整理（時系列図）して、直接その変化状態を見る。 |
|                                                                      |
| 2.  資料の値について移動平均値を求め、その時間的な変化傾向を見る。   |
|                                                                      |
| 3.  任意の時間区分によって資料を数群に分け、                         |
| それぞれの群についての観測値の平均値、分散、系列相関係数等の統計量を |
| 求め、それから推定される母集団の特性値について、各群の値を比較する。 |
|                                                                      |
| 4.  コレログラム（時                                                 |
| 系列相関図）を作成して、周期性変化及び持続性変化の傾向の有無を見る。 |
|                                                                      |
| 図                                                                   |
| 3-1-3に1876年                                                        |
| から2010年までの東京の年降水量とこれを11年で移動平均したものを示す。 |
|                                                                      |
| この事例について全期間を対象にMann                                   |
| -Kendall検定を行うと$\text{Z\ }$=-0.36となり、定常であるという仮説は |
| 有意水準5％で判断すると棄却されないので有意な減少傾向とはいえない。  |
|                                                                      |
| 図 3-1-4は同期間の年最大日雨量の推移を示したものである。             |
|                                                                      |
| 図                                                                   |
| 3-1-4の水文資料について観測開始から25年                              |
| 経過した1900年から2010年までを対象にMann-Kendall検定を行った結果を図 |
| 3-1-5に示す。                                                        |
|                                                                      |
| この図から横軸が1950年付近に$Z$＞1.                                  |
| 96となっている部分が見られる。この部分は1876年から1950年ごろまでのデ |
| ータで判断すると有意水準5％で判断すると定常であるという仮説は棄却さ  |
| れることを示している。しかし、その後のデータの蓄積で、2010年までの全 |
| てのデータを用いると$\text{Z\ }$=1.18となり、同仮説は棄却されない。  |
|                                                                      |
| ![](media/image29.png){width="4.888199912510936in"                   |
| height="2.592292213473316in"}                                        |
|                                                                      |
| 3.  東京の1876−2010の年降水量と11年の移動平均（太線）                |
|                                                                      |
| ![                                                                   |
| PastedGraphic-1.jpg](media/image30.jpeg){width="4.727799650043744in" |
| height="2.6641994750656166in"}                                       |
|                                                                      |
| 4.  東京の1876−2010の年最大日降水量                                  |
|                                                                      |
| ![](media/image31.png){width="4.068718285214349in"                   |
| height="2.611940069991251in"}                                        |
|                                                                      |
| 5.  東京の1876−2010の年最大日降水量のトレンド評価                    |
|                                                                      |
| 図                                                                   |
| 3-1-6は東京の1876年から2010年までの月降水量のコレログラ              |
| ムを示したものであり、12か月の周期性がはっきり現れているのが分かる。 |
|                                                                      |
| ![](media/image32.emf){width="3.41875in"                             |
| height="2.423513779527559in"}                                        |
|                                                                      |
| 6.  東京の1876−2010の月降水量のコレログラム                          |
|                                                                      |
| コ                                                                   |
| レログラムのパターン形状の特徴、すなわち時系列変化の特徴はおおよそ図 |
| 3-1-7のように分類することができる。                                  |
|                                                                      |
| ![図1.gif](media/image33.gif){width="4.3275in" height="3.0225in"}    |
|                                                                      |
| 7.  時系列変化のパターン                                             |
|                                                                      |
| ①　ほとんど完全な周期性（a） ②　持続性（減衰傾向）（c）              |
|                                                                      |
| 　　周期性と偶発性の混合型（a'） ③　純偶発性（d）                    |
|                                                                      |
| 　　周期性と持続性の混合型（b）                                      |
|                                                                      |
| なお、周期性の理由が明                                               |
| 確でない場合、コレログラムによる完全な周期性の判断基準としては、水文 |
| 資料全期間の中に数サイクル以上周期が含まれていること等が考えられる。 |
|                                                                      |
| 更                                                                   |
| に、詳細に時系列変化の特性を求める場合には、おおよそ以下に示す方法の |
| 1つ又はそれらを組み合わせた方法によって基本的な解析を行ってもよい。  |
|                                                                      |
| 1.  時間に関する1次式又は多                                          |
| 次式をあてはめた回帰分析によって傾向変化曲線（トレンド）を推定する。 |
|                                                                      |
| 2.  周期解析（又                                                     |
| はピリオドグラム解析）等の方法によって、周期変化成分の特性を求める。 |
|                                                                      |
| 3.  コレログラム解                                                   |
| 析その他の方法によって、周期成分の変化及び持続性変化の特性を求める。 |
|                                                                      |
| 4.  もとの時系列変化を上                                             |
| 記１）ないし３）で求められる規則的変化成分と残りの不確定な変化成分に |
| 分ける。後者についてはその分布特性及び生起特性についての解析を行う。 |
+----------------------------------------------------------------------+

第3章　水文解析　第2節　流出解析 {#第3章-水文解析-第2節-流出解析 .TOC-Heading}
================================

目　次 {#目-次-2 .TOC-Heading}
======

[第2節 流出解析 1](#_Toc382986733)

> [2．1 総説 1](#_Toc382986734)
>
> [2．1．1 流出解析の目的 1](#_Toc382986735)
>
> [2．1．2 流出モデルの種類と特徴 1](#_Toc382986736)
>
> [2．2 洪水流出計算 2](#_Toc382986737)
>
> [2．2．1 総説 2](#_Toc382986738)
>
> [2．2．2 洪水流出モデルの選定 3](#_Toc325456591)
>
> [2．2．3 水文資料及び流域特性資料の収集と整理 3](#_Toc318909193)
>
> [2．2．4 洪水流出モデル構造の決定と入力する降雨の算出
> 4](#_Toc318909195)
>
> [2．2．5 洪水流出モデルの定数解析と検証 6](#_Toc318909197)
>
> [2．2．6 洪水流量の計算 7](#_Toc308639635)
>
> [2．3 低水流出計算 7](#_Toc308597531)
>
> [2．3．1 総説 7](#_Toc382986745)
>
> [2．3．2 蒸発散量の計算 7](#_Toc308597597)
>
> [2．3．3 取水・還元量等の推定 8](#_Toc382986747)
>
> [2．3．4 積雪・融雪量の推定 9](#_Toc309643883)
>
> [2．4 主要な流出モデルの事例 10](#_Toc382986749)

平成26年4月　版

5.  水文解析

    []{#_Toc382986733 .anchor}流出解析

＜考え方＞

+----------------------------------------------------------------------+
| 本節                                                                 |
| は、河川等の調査で行う流出解析に必要な技術的事項を定めるものである。 |
|                                                                      |
| 流出解析に用いる流出モデルは多種多様であり、                         |
| また、次々と新たな流出モデルや解析手法が考案されている。そのため、本 |
| 節は、河川等の調査で行う流出解析に共通する技術的事項について記載する |
| とともに、河川等の調査で適用実績のある代表的な流出モデルを例示する。 |
+----------------------------------------------------------------------+

1.  []{#_Toc382986734 .anchor}総説

    1.  []{#_Toc382986735 .anchor}流出解析の目的

＜考え方＞

+----------------------------------------------------------------------+
| 河川等の調査で行う流出解析の目的は、一般に、以下のように大別できる。 |
|                                                                      |
| 1)  河川等の計画や河川管理施設等の設計のための河川流量の計算         |
|                                                                      |
| 2)  実時間での河川流量（特に洪水時の流量）の予測                     |
|                                                                      |
| 3)  長期の河川流量の計算                                             |
|                                                                      |
| 4)  流域や気候の変化に伴う水循環の変化の予測                         |
|                                                                      |
| 5)  水文観測が十分でない流域の長期又は洪水時の河川流量の計算         |
|                                                                      |
| 6)  流出現象のより深い理解のための解析                               |
|                                                                      |
| 本節では、特に断りの                                                 |
| ない限り、１）河川等の計画や河川管理施設等の設計のための河川流量の計 |
| 算、又は３）長期の河川流量の計算の目的での流出解析について記述する。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

流出解析の目的分類とその解説の詳細については、下記の資料が参考となる。

1.  池淵周一，椎葉充晴，宝馨，立川康人：エース 水文学
    (エース土木工学シリーズ)，pp.125-126，朝倉書店，2006.

```{=html}
<!-- -->
```
126. 日本学術会議：回答　河川流出モデル・基本高水の検証に関する学術的な評価，p.3，2010.

＜必　須＞

  ------------------------------------------------------------------------------------------------
  流出解析の方法・手順は、流出解析の目的や利用可能な資料等に応じて適切に設定しなければならない。
  ------------------------------------------------------------------------------------------------

1.  []{#_Toc382986736 .anchor}流出モデルの種類と特徴

＜例　示＞

+----------------------------------------------------------------------+
| 流出モデルは視点ごとにさま                                           |
| ざまな分類が可能である。代表的な分類例とそれぞれの特徴を以下に示す。 |
|                                                                      |
| 15. 予測期間からみた分類                                             |
|                                                                      |
| > 短期流出モデル                                                     |
| >                                                                    |
| > 長期流出モデル                                                     |
|                                                                      |
| 短期流出モデルは、洪水流出モデルとも呼ばれ、数時間か                 |
| ら数日の流出現象を計算するモデルである。数日の河川流量を1時間単位又  |
| はそれよりも短い時間単位で計算する。この場合の流出モデルは、斜面流出 |
| 過程と河道網での流れのモデル化が流出モデルの主要部分となり、蒸発散過 |
| 程は短期流出モデルに導入しないことが多い。一方、長期流出モデルでは、 |
| 積雪・融雪や蒸発散の過程を適切にモデルに反映させることが重要となる。 |
|                                                                      |
| 16. 降雨―流出の応答の考え方からみた分類                              |
|                                                                      |
| > 応答モデル                                                         |
| >                                                                    |
| > 概念モデル                                                         |
| >                                                                    |
| > 物理モデル                                                         |
|                                                                      |
| 応答モ                                                               |
| デルは、入出力の応答関係から降雨流出の関係式を構成するモデルである。 |
|                                                                      |
| 概念モデルは、現象を概念的                                           |
| に捉え降雨流出の関係式を構成するモデルである。過去の長期間の降雨と河 |
| 川流量の水文資料が存在し適切にモデルの定数を設定できれば、比較的精度 |
| よく河川流量を予測できる。また、計算負荷が小さいという特徴を有する。 |
|                                                                      |
| 物理モデ                                                             |
| ルは、物理的な法則性に基づいた基礎式から降雨流出の関係式を構成するモ |
| デルである。土地利用や流域環境の変化をモデルに表現することができる。 |
|                                                                      |
| 17. モデルの空間的な構成方法からみた分類                             |
|                                                                      |
| > 集中定数系モデル（集中型モデル）                                   |
| >                                                                    |
| > 分布定数系モデル（分布型モデル）                                   |
|                                                                      |
| 集中定数系モデルは、ある対象地点の流量の計算を行うとき、対象地点     |
| 上流の流域を単位としての流出過程を流域全体で平均化するモデルである。 |
|                                                                      |
| 分布定数系モデルは、                                                 |
| 降雨時の時空間観測データを取り込み、地形・地質・地被等の地域情報の分 |
| 布を考慮し、水文量の時空間分布を計算できるような構造のモデルである。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

流出モデルの分類と特徴の詳細については、下記の資料が参考となる。

1.  池淵周一，椎葉充晴，宝馨，立川康人：エース 水文学
    (エース土木工学シリーズ)，pp.188-191，朝倉書店，2006.

```{=html}
<!-- -->
```
127. 日本学術会議：回答　河川流出モデル・基本高水の検証に関する学術的な評価，p.3，2010.

     1.  []{#_Toc382986737 .anchor}洪水流出計算

         1.  []{#_Toc382986738 .anchor}総説

＜考え方＞

+----------------------------------------------------------------------+
| 洪水流出計算は、一般的に以下の手順で実施される。                     |
|                                                                      |
| 1)  流出モデルの選定                                                 |
|                                                                      |
| 2)  水文資料及び流域特性資料の収集と整理                             |
|                                                                      |
| 3)  流出モデル構造の決定及び入力する降雨の算出                       |
|                                                                      |
| 4)  流出モデルの定数解析と検証                                       |
|                                                                      |
| 5)  流量の計算                                                       |
|                                                                      |
| ただし、洪水流出解析の目的や利用できる水文観測                       |
| 資料の制約、用いる流出モデル等により、この手順は簡略化される場合もあ |
| る。例えば、合理式を用いる場合は、３）、４）が省略されることがある。 |
+----------------------------------------------------------------------+

[]{#_Toc325456591 .anchor}

1.  洪水流出モデルの選定

＜標　準＞

+----------------------------------------------------------------------+
| 洪水流出                                                             |
| モデルは、洪水流出解析の目的や必要とされる水文資料の有無等に応じて、 |
| 適切な流出モデルを選定し、必要に応じて改良を加えることを標準とする。 |
|                                                                      |
| 例                                                                   |
| えば、水循環健全化の検討で流域の都市化が流量に与える影響の予測が必要 |
| となる場合、流域変化前後の流出特性を表現できる流出モデルを選定する。 |
+----------------------------------------------------------------------+

＜例　示＞

+----------------------------------------------------------------------+
| 洪水流出モデルの選定に当たり、モデルの頑健性（異なる洪水             |
| 事象におけるモデルの適用性）や十分な適用実績を考慮している例が多い。 |
|                                                                      |
| 合理式は、土地利                                                     |
| 用に応じた定数の標準値の調査事例が豊富であり、過去の流量資料がない小 |
| さな流域での洪水のピーク流量の計算手法として長年の適用実績を有する。 |
|                                                                      |
| 貯留関数法は                                                         |
| 、我が国における洪水流出に対し高い再現性を有し、広く利用されている。 |
|                                                                      |
| タンクモデルは、世界の多                                             |
| 様な気候条件や流域特性を持つ流域での流出予測に適用された実績を有する |
| 一方、多くの定数を過去の水文資料から試行錯誤で求めなければならない。 |
|                                                                      |
| 一般的に、モデル定数の数が多いと再現性は高まる一方で                 |
| 、頑健性が低下する。数多く開発されている分布定数系モデルは、運動方程 |
| 式に物理式を適用することにより頑健性を損なわない工夫がなされている。 |
+----------------------------------------------------------------------+

2.  []{#_Toc318909193 .anchor}水文資料及び流域特性資料の収集と整理

＜考え方＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  洪水を対象とする水文資料及び流域特性資料は、流出解析の精度を高める観点から、できる限り収集する。また、収集した資料の整理は、用いる流出モデルの構造に適合するように行う。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 解析対象地域内とその近傍の雨量、水位、流量観測記録                   |
| をできる限り収集し、洪水ごとに資料の存否を整理することを基本とする。 |
|                                                                      |
| 雨量資料については、対象河川流域内の雨量資料だけでは雨量の時空間分   |
| 布を適切に再現できない場合もあり得ることから、その周辺近傍地域におい |
| て得られる全ての雨量資料を降雨原因を含めて収集することを基本とする。 |
|                                                                      |
| 流量資料については、流量の観測方法を明示するものとする。             |
+----------------------------------------------------------------------+

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------
  観測流量が貯水池での調節等の人為的影響や洪水時の外水氾濫等の偶発的影響を受ける場合、流出解析の目的に応じた適切な方法でこれらの影響を考慮することを標準とする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------

＜例　示＞

  --------------------------------------------------------------------------------------------------------------------
  流域平均雨量と観測流出高の時系列変化図を作成することで、洪水事象ごとの降雨と流出の関係の特徴を把握する方法がある。
  --------------------------------------------------------------------------------------------------------------------

＜推　奨＞

+----------------------------------------------------------------------+
| 必要に応じ、水文資料の照査に利用可能な関連資料を整理する。           |
|                                                                      |
| 天気                                                                 |
| 図等の気象情報、レーダ雨量、浸水被害や土砂災害等の災害記録は雨量資料 |
| の精度の把握に、また、観測所以外の地点で特定の期間に調査された水位、 |
| 流量、水位痕跡等は観測所での流量資料の精度の把握に役立つことが多い。 |
+----------------------------------------------------------------------+

＜推　奨＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  必要に応じ、当該流域の地形、地質、土地利用、土地被覆等の資料を収集、整理し、流域分割の妥当性の検討や流出モデルの定数解析、流出計算結果の分析等に活用することを推奨する。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------

3.  []{#_Toc318909195
    .anchor}洪水流出モデル構造の決定と入力する降雨の算出

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  洪水流出計算では、当該河川流域を流出計算の基本単位（小流域や小区画など）に分割し、河道モデルにより連結し計算することを基本とする。その際には、洪水流の伝播や河道貯留の影響等の取扱いに留意しなければならない。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  洪水流出計算における河道の洪水波を追跡する場合の河道計算方法は、流域の基本単位の流出モデルの精度と整合のとれた手法を、河川における洪水波の伝播に伴う水理量の変化を知ることを目的とした一次元の解析手法から選定することを標準とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜例　示＞

+----------------------------------------------------------------------+
| 洪水流出計算                                                         |
| における河道計算方法は、水理学的追跡法と水文学的追跡法に大別できる。 |
|                                                                      |
| 水理学                                                               |
| 的追跡法は、一次元開水路流れの運動方程式を、差分法や特性曲線法などの |
| 数値計算法により数値解を得る手法であり、河川の断面の水理学的特性に関 |
| する情報が必要となる。開水路流れの運動方程式においてどの項まで考慮す |
| るかによって、いわゆる不定流計算であるダイナミック・ウェーブモデルか |
| ら、拡散波モデル、キネマティック・ウェーブモデルまでの選択肢がある。 |
|                                                                      |
| 水文学的追跡方法は、河道区間への流入                                 |
| と流出の応答関係を数式化する手法であり、更に以下のように分類できる。 |
|                                                                      |
| 1)                                                                   |
| ある河道区間内の水体の連続方程式と運動方程式（貯留関数）を用いる方法 |
|                                                                      |
| 2)  洪水波の伝播速度（遅れ時間）を設定する方法                       |
|                                                                      |
| 3)  洪水流の水位の相関を利用する方法                                 |
|                                                                      |
| １)の方法としては、貯留関数法、Mus                                   |
| kingum法等がある。貯水池内の洪水追跡法として、河道区間の水体の水面が |
| 一様に昇降する場合の貯留関数法に相当する貯水池モデルがある。これらの |
| 定数は、河道区間の横断面形状等の水理学的情報から求めることができる。 |
|                                                                      |
| ２)の方法としては、Manning式やChezy式とい                            |
| った等流式を用いる方法、合理式の洪水到達時間を求める式を用いる方法、 |
| 貯水池などにおける長波の伝播速度を用いる方法がある。水理・水文学的情 |
| 報が限定された条件下において簡易的に計算を行いたい場合に有用である。 |
|                                                                      |
| ３)は、洪水流出計算の対象地点以外の                                  |
| 地点で水位予測を行う場合や、実時間洪水予測等で用いられる方法である。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

集中定数系モデルによる洪水流出計算での河道計算方法は、下記の資料が参考となる。

1.  土木学会水理委員会：水理公式集［平成11
    年版］，pp.119-125，丸善，1999.

    （最新版）土木学会水理委員会：水理公式集［2018年版］，pp.65-76,
    丸善出版、2019.

貯留関数法及びMuskingum法による河道計算における定数の水理学的推定法は、下記の資料が参考となる。

4.  橋本宏，藤田光一：洪水追跡法（その２）―洪水追跡モデルの適用限界と未知パラメータの推定法―，土木技術資料，28-8，pp.442-448，1986.

河道計算方法の詳細については、下記の資料が参考となる。

128. 池淵周一，椎葉充晴，宝馨，立川康人：エース 水文学
     (エース土木工学シリーズ)，pp.125-126，朝倉書店，2006.

＜必　須＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  流出モデルに入力する雨量は、流出モデルの流域の基本単位ごとの面積平均雨量とする。面積平均雨量の算出に当たっては、流域内の地形性降雨の地域分布特性、年代により異なる降雨観測所網、欠測状況等を考慮し、最も適切と考えられる方法により行うものとする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜例　示＞

  ------------------------------------------------------------------------------------------------------------------
  面積平均雨量を算出する方法としては、等雨量線法、ティーセン法、算術平均法、支配圏法、高度法、代表係数法等がある。
  ------------------------------------------------------------------------------------------------------------------

＜参考となる資料＞

> 等雨量線法、ティーセン法、算術平均法、支配圏法、高度法については、下記の資料が参考となる。

1.  日本学術会議：回答　河川流出モデル・基本高水の検証に関する学術的な評価，pp.27-28，2010.

代表係数法については、下記の資料が参考となる。

5.  木村俊晃：相関関係の解析を基礎とした流域平均雨量の算定法，土木技術資料，2-5，pp.173-179，1960.

＜例　示＞

+----------------------------------------------------------------------+
| レー                                                                 |
| ダ雨量計解析処理データが地上雨量計による観測雨量から算出される雨量よ |
| り高精度と判断できる場合、これを幾何補正して入力値とする方法がある。 |
|                                                                      |
| また、過去観測された気象情                                           |
| 報と気象数値モデルを用いて過去の気象を詳しく解析する同化解析の結果で |
| ある「再解析データ」から降雨量を抽出し利用する方法も研究されている。 |
+----------------------------------------------------------------------+

＜例　示＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------
  実時間洪水予測において流出モデルに入力する予測雨量が必要な場合、地点での降雨予測値から面積平均雨量を算出し入力する方法や気象数値予測結果を入力する方法がある。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------

＜参考となる資料＞

実時間洪水予測については、下記の資料が参考となる。

1.  (財)河川情報センター：中小河川における洪水予測の手引き，2002.

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  洪水流出計算では、流域での雨水の損失・保留機能を内蔵するものは別として、直接流出（表面流出＋中間流出）成分を計算対象とすることを標準とする。一つの洪水事象での総有効降雨量は、直接流出成分の総量に等しくなる。直接流出成分は、観測ハイドログラフの基底流出成分の分離により求めることを標準とする。流出成分の分離方法として、洪水立ち上り点で水平に分離する方法、ハイドログラフ逓減部の折曲点と洪水立ち上り点を結んだ線で分離する方法等がある。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜参考となる資料＞

流出成分の分離の詳細については、下記の資料が参考となる。

1\) 土木学会水理委員会：水理公式集［平成11 年版］，p.36，丸善，1999.

（最新版）土木学会水理委員会：水理公式集［2018年版］，pp.66,
丸善出版、2019.

＜例　示＞

+----------------------------------------------------------------------+
| 有効降雨に関する定数                                                 |
| は、観測資料から得られる洪水期間の水収支に基づき求めることができる。 |
|                                                                      |
| また、降雨の初期に凹地等に貯留される効果が水収支等から認められ       |
| る場合、これを有効降雨の算出に組み入れた計算法を用いることができる。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

有効降雨の算出手順の考え方については、下記の資料が参考となる。

1.  日本学術会議：回答　河川流出モデル・基本高水の検証に関する学術的な評価，pp.5-6，2010.

    1.  []{#_Toc318909197 .anchor}洪水流出モデルの定数解析と検証

＜考え方＞

+----------------------------------------------------------------------+
| 洪水流出モデルの定数解析、検証のための洪水事象は、過去の記録         |
| を超える洪水のピーク流量の予測、大洪水から中小洪水までのハイドログラ |
| フの再現等の流出計算の目的や利用できる観測資料等を勘案して選定する。 |
|                                                                      |
| 定数解析                                                             |
| が適切に行われたことは、観測流量と計算流量を比較することで確認する。 |
|                                                                      |
| 検証用の洪水事象は、定数解析用と異なる洪水事象を選定する             |
| ことが望ましいが、大洪水等の事象数が限られる場合、当該流出モデルが様 |
| 々な流域で検証された実績を有することをもって検証を省略し、より多くの |
| 洪水事象を定数解析に用いることによりその精度を向上させるものとする。 |
+----------------------------------------------------------------------+

＜必　須＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  洪水流出モデルの定数解析は、観測資料の精度に大きく依存するので、流域平均雨量等の入力値又は観測流量の精度が著しく低いと判断される場合、定数解析対象から除外するものとする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  洪水流出モデルの定数解析に当たっては、例えば大洪水のピーク流量の再現といった流出計算で再現しようとする事象について、複数の洪水事象のピーク流量を適切に再現できるよう対象洪水を選定することを標準とする。ただし、個別の洪水事象の現象の理解など特定の目的の場合はその限りではない。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

  --------------------------------------------------------------------------------------------
  洪水流出モデルの定数解析に当たっては、できるだけ多くの洪水事象を対象とすることが望ましい。
  --------------------------------------------------------------------------------------------

＜例　示＞

  -----------------------------------------------------------------------------------------------------------------------------------------------------------
  計算流量と観測流量との適合度を定量的に示す数値指標としては、ピーク流量付近の誤差に重みをおく評価基準、相対基準、相対2乗基準、Nash-Sutcliffe効率等がある。
  -----------------------------------------------------------------------------------------------------------------------------------------------------------

＜参考となる資料＞

適合度を示す各数値指標については、下記の資料が参考となる。

1.  望月邦夫：淀川の治水計画とそのシステム工学的研究，京都大学博士論文，1970.

```{=html}
<!-- -->
```
129. 角屋睦，永井明博：流出解析手法（その11），農業土木学会誌，第48巻
     第11号，pp.851-856，1980.

130. Nash J. E. and Sutcliffe, J. V.：River Flow Forecasting Through
     Conceptual Models Part I - A Discussion of Principles，Journal of
     Hydrology，10，pp. 282-290，1970.

     1.  []{#_Toc308639635 .anchor}洪水流量の計算

＜考え方＞

  ----------------------------------------------------------
  流量の計算は、同定された流出モデルに降雨を入力して行う。
  ----------------------------------------------------------

[]{#_Toc308597531 .anchor}

1.  低水流出計算

    1.  []{#_Toc382986745 .anchor}総説

＜考え方＞

  ------------------------------------------------------------------------------------------------------------------------
  低水流出解析の一般的手順は、基本的に洪水流出解析の手順と同じである。以下、洪水流出解析とは異なる項目について記述する。
  ------------------------------------------------------------------------------------------------------------------------

＜考え方＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------
  流量は1950年代以降の記録が多いが、雨量の記録は相当長期にわたって存在する。低水流出計算は、流量未観測期間の流量資料の補完（復元）の目的で利用されることが多い。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

  ----------------------------------------------------------------------
  低水流出解析は、通常、日単位あるいは半旬単位で行うことを標準とする。
  ----------------------------------------------------------------------

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  日平均流量(m^3^/s)を流出高(mm/day)に変換する際、日雨量、日流量の日界を把握し、流出計算時の留意事項として記録する。例えば、日流量は、自記水位記録の観測所の場合は1時から24時までの毎正時の流量の平均、水位標の観測所の場合は通常6時及び18時の流量の平均である。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

2.  []{#_Toc308597597 .anchor}蒸発散量の計算

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  低水流出計算では、降雨及び融雪を入力し、これから損失を差し引いた量が時間をかけて流出すると考え、これを追跡計算するのが一般的である。損失は、蒸発散による大気への水移動、流域貯留量変化、深層地下水帯水層を通した流域外への流失である。河川流域を対象とする場合は、通常、最後の流失は無視できると考えるのが一般的である。また、1水文年の始まりと終りでは、流域貯留量変化は無視できると考え、この間の損失はすべて蒸発散であるとし、1水文年の水収支に合うように蒸発散量を推定する方法を基本とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 蒸発散量は、可能蒸発散量又                                           |
| は観測蒸発量に水収支から求めた係数を掛けて算出することを基本とする。 |
|                                                                      |
| 水収支が不明な場合は、過                                             |
| 去の調査事例から、当該流域への適用が妥当と考えられる係数を適用する。 |
|                                                                      |
| ただし、上記                                                         |
| より精度が高いと考えられる観測が行われている場合は、これも利用する。 |
+----------------------------------------------------------------------+

＜例　示＞

+----------------------------------------------------------------------+
| 地表への水分の供                                                     |
| 給が十分になされると仮定した場合の可能蒸発散量を推定する方法として、 |
| 多くの式が提案されている。気温と緯度で決まる日照量から推定するHamon  |
| 公式、Thornthwaite公式といった経験的な公式や、より詳しい微気象観測情 |
| 報を必要とするPenman公式、Penman-Monteith公式などが提案されている。  |
|                                                                      |
| 観測蒸発量は、気象庁等が観測するパン蒸発量が利用できる。             |
+----------------------------------------------------------------------+

＜参考となる資料＞

可能蒸発散量の推定法の詳細については、下記の資料が参考となる。

1.  土木学会水理委員会：水理公式集［平成11 年版］，pp.16-18，丸善，1999.

    （最新版）土木学会水理委員会：水理公式集［2018年版］，pp.32-33,
    丸善出版、2019.

＜例　示＞

  -----------------------------------------------------------------------------------------------------------------------------------------------------------
  河川流域の水収支から求めた日本の平均的な年降雨損失量は、全国平均で約500mm、北海道で約400mm、瀬戸内・九州で約600mm程度という調査結果が得られた事例がある。
  -----------------------------------------------------------------------------------------------------------------------------------------------------------

＜参考となる資料＞

河川流域の水収支から求めた全国の平均的な年降雨損失量の詳細については、下記の資料が参考となる。

1.  建設省技術研究会（編集）：利水計画における流況把握の研究，第23回建設省技術研究会報告，p.4，1970.

    1.  []{#_Toc382986747 .anchor}取水・還元量等の推定

＜考え方＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  利水計算目的での低水流出計算を行う際には、貯水池による調節や上流での取水・還元等の人為的影響がない場合の自然流量をあらかじめ算出し、この自然流量を予測する流出モデルを構築する。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 貯水池による調節、取水・還元量は観測値を利用することを基本とする。   |
|                                                                      |
| 観測資料がない                                                       |
| 場合は、許可水利権量や河川区域での水収支等の情報から推定するものとす |
| る。その情報も利用できない場合は、他河川での調査事例の準用等を行う。 |
+----------------------------------------------------------------------+

＜推　奨＞

+----------------------------------------------------------------------+
| 農業用水の取水量の実                                                 |
| 測値がない場合、以下に挙げる方法等で取水量を推定することが望ましい。 |
|                                                                      |
| 1.  水収支法                                                         |
|                                                                      |
| 農                                                                   |
| 業用水取水がないと仮定し計算した河川流量と同一地点での観測流量の差を |
| 正味の農業用水取水量（＝農業用水取水量－還元水量）として求める方法。 |
|                                                                      |
| 18. 減水深法                                                         |
|                                                                      |
| 水田その他の農耕地                                                   |
| の減水深にその面積を乗じて農業用水量を求め、これを取水量とする方法。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

土地改良事業における減水深の計画値に関しては、下記の資料が参考となる。

1.  土地改良事業計画設計基準「計画　農業用水(水田)」，平成5年5月，農林水産省構造改善局，pp.33-56.

    （最新版）土地改良事業計画設計基準「計画農業用水(水田)」，平成22年7月，農林水産省構造改善局.

    1.  []{#_Toc309643883 .anchor}積雪・融雪量の推定

＜考え方＞

  ------------------------------------------------------------------------------------------------------------------------------
  融雪流出が認められる河川流域では、降雪・積雪・融雪量を推定し、融雪が降雨に加算されると考え、流出計算を行うのが一般的である。
  ------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 降水観測は、一般には、降                                             |
| 雪・降雨を区別せずに観測されているため、降水時の地上気温観測値から当 |
| 該地点での地上気温を推定し、降雪・降雨の判別を行うことを基本とする。 |
|                                                                      |
| 積雪量は、降雪量から融雪量を差し引いた量を積算して求める。           |
|                                                                      |
| 融雪量は、気温のみ                                                   |
| から融雪量を推定する簡易的な方法である積算暖度法（degree-day法）で求 |
| める。より精度を求める場合は、積雪量の熱収支から求める方法等がある。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

積算暖度法の詳細については，下記の資料が参考となる。

1.  土木学会水理委員会：水理公式集［平成11 年版］，p.27，丸善，1999.

    （最新版）土木学会水理委員会：水理公式集［2018年版］，pp.44-45,
    丸善出版、2019.

＜例　示＞

+----------------------------------------------------------------------+
| 積雪量分布は                                                         |
| 、衛星や航空機等からのリモートセンシング情報から積雪域を推定し、推定 |
| 積雪密度から積雪量を推定方法もある。この方法は、降水量から計算した積 |
| 雪量分布・融雪量推定の妥当性を検証する手段として用いることができる。 |
|                                                                      |
| 積雪                                                                 |
| 層の熱収支から推定される融雪量は、積雪表面での放射収支、顕熱・潜熱収 |
| 支、降雨により与えられる熱量、積雪底面での土壌からの熱伝導から算出さ |
| れる。これらを気象庁アメダス等の気象観測値から推定する簡易的な熱収支 |
| 法である「日射量・気温・降水量を用いた融雪モデル」も提案されている。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

「日射量・気温・降水量を用いた融雪モデル」の詳細については、下記の資料が参考となる。

1.  土木学会水理委員会：水理公式集［平成11 年版］，pp.27-28，丸善，1999.

    （最新版）土木学会水理委員会：水理公式集［2018年版］，pp.44,
    丸善出版、2019.

    1.  []{#_Toc382986749 .anchor}主要な流出モデルの事例

＜例　示＞

+----------------------------------------------------------------------+
| 流出モデルは利用者により適宜改良されることが多くあり、同一名称の流出 |
| モデルであっても異なる計算方法をとることもあるため、ここでは河川等の |
| 調査で利用実績のある流出モデルについて例示する。さらに、近年開発が進 |
| められ実用例も増えつつある分布定数系モデルの一つを例示する。ここに例 |
| 示した流出モデル以外にも、国内外で多くの流出モデルが提案されている。 |
|                                                                      |
| 1.  合理式                                                           |
|                                                                      |
| 合理式は洪水のピーク流量を推算するための簡便な方法であって、         |
| 貯留現象を考慮する必要のない河川でピーク流量のみが必要とされる場合に |
| 広く用いられている。ピーク流量を推定する諸公式は、一般に流域面積の関 |
| 数としたものが多い。比流量法のCreager曲線もその一つであるが、最大流  |
| 量はもとより流域面積のみの関数ではないから、他のいろいろな要素、例え |
| ば降雨強度や流域の植生、傾斜の度合いなどを考慮した流出計算法が必要と |
| され、また、洪水頻度をも要因の中に入れられれば河川等の計画に当たって |
| 更に有用となる。このような点を考慮した簡単な流出計算式として合理式が |
| 提案された。これは流域の形を河道に対して対称な長方形と考え、雨水は流 |
| 域斜面を一定速度で流下し、河道に入るものと考える。そして流域の最遠点 |
| に降った雨が流域の出口に達するまでの時間を洪水到達時間と呼び、時間内 |
| の降雨強度に流域の土地利用に応じた流出係数を乗じて流出量を計算する。 |
|                                                                      |
| 合理式によるピーク流量は次式で与えられる。                           |
|                                                                      |
| (3-2-1)                                                              |
|                                                                      |
| ここに、*Q~p~*はピーク流量(m^3^/s)、*f*は流出係数                    |
| 、*R*は洪水到達時間内の雨量強度(mm/h)、*A*は流域面積(km^2^)である。  |
|                                                                      |
| 合理式は、次の仮                                                     |
| 定の上に作成されたものであるので、適用に当たっては、これらの仮定にで |
| きるだけ近い流出特性を示す流域に用いるように注意しなければならない。 |
|                                                                      |
| a.  ある降雨強度*R*の降雨による流出量*Q*は、                         |
| その強度の降雨が洪水到達時間かそれ以上の時間継続するとき最大になる。 |
|                                                                      |
| b.  降雨の継続時間が洪水到達時間に等しいか、それ以上長い、ある       |
| 降雨強度*R*による最大流出量*Q~p~*はその降雨強度*R*と直線関係にある。 |
|                                                                      |
| c.  最大流出量*Q~p~*の生起確                                         |
| 率は、与えられた洪水到達時間に対する降雨強度*R*の生起確率に等しい。  |
|                                                                      |
| d.  流出係数*f*はどの確率の降雨に対しても同じである。                |
|                                                                      |
| e.  流出係数*f*は与えられた流域に降る全ての降雨に対して同じである。  |
|                                                                      |
| これまでの試験地などにおける調査結果によれば、これ                   |
| らの前提条件に比較的近い流出特性を示す流域として、降雨の浸透や貯留の |
| 少ない市街化された流域が挙げられる。一般に流域面積が大きくなると貯留 |
| 効果が大きくなり、合理式の線形仮定が成立しなくなるので注意しなければ |
| ならない。適用すべき流域の大きさは100km^2^程度以下であることが多い。 |
|                                                                      |
| 当該流域特有の流出係数及び洪水到達時間は、過去                       |
| の水文観測資料から求めることができる。洪水到達時間は降雨強度が最大と |
| なる時刻と流出が最大となる時刻の時間差の２倍として求める場合がある。 |
|                                                                      |
| 過去の水文資料がな                                                   |
| い流域では、流出係数と洪水到達時間を流域の地被、植生、形状、開発状況 |
| などを勘案して決定する必要がある。流出係数と洪水到達時間についてはい |
| ろいろな値が提案されているが、その一部を示すと次のようである。なお、 |
| 計画に用いられる流出係数の値については、[計画編](http://www.mlit.go. |
| jp/river/shishin_guideline/gijutsu/gijutsukijunn/keikaku/index.html) |
| 第2章も参照することができる。                                        |
|                                                                      |
| a.  物部による日本河川の流出係数(物部、1933)                         |
|                                                                      |
| ```{=html}                                                           |
| <!-- -->                                                             |
| ```                                                                  |
| 1.  日本内地河川の流出係数                                           |
|                                                                      |
| +------------------------------------+--------------+                |
| | > 地形の状態                       | > Fp         |                |
| +====================================+==============+                |
| | > 急しゅんな山地                   | > 0.75～0.90 |                |
| | >                                  | >            |                |
| | > 三紀層山地                       | > 0.70～0.80 |                |
| | >                                  | >            |                |
| | > 起伏のある土地および樹林地       | > 0.50～0.75 |                |
| | >                                  | >            |                |
| | > 平らな耕地                       | > 0.45～0.60 |                |
| | >                                  | >            |                |
| | > 灌漑中の水田                     | > 0.70～0.80 |                |
| | >                                  | >            |                |
| | > 山地河川                         | > 0.75～0.85 |                |
| | >                                  | >            |                |
| | > 平地小河川                       | > 0.45～0.75 |                |
| | >                                  | >            |                |
| | > 流域の半ば以上が平地である大河川 | > 0.50～0.75 |                |
| +------------------------------------+--------------+                |
|                                                                      |
| b.  「下水道施設計画・設計指針と解説」の流出係数                     |
|                                                                      |
| ```{=html}                                                           |
| <!-- -->                                                             |
| ```                                                                  |
| 2.  工種別基礎流出係数の標準値（日本下水道協会、2009）               |
|                                                                      |
|   工種                 流出係数                                      |
|   -------------------- -----------                                   |
|   屋根                 0.85-0.95                                     |
|   道路                 0.80-0.90                                     |
|   その他の不透面       0.75-0.85                                     |
|   水面                 1.00                                          |
|   間地                 0.10-0.30                                     |
|   芝，樹木の多い公園   0.05-0.25                                     |
|   こう配の緩い山地     0.20-0.40                                     |
|   こう配の急な山地     0.40-0.60                                     |
|                                                                      |
| 基礎流出係数：細分化された基礎工種ごとの流出係数                     |
|                                                                      |
| 3.  用途別総括流出係数の標準値（日本下水道協会、2009）               |
|                                                                      |
|   用途                                                               |
|                                                         総括流出係数 |
|   ---------------                                                    |
| ----------------------------------------------------- -------------- |
|   敷地内                                                             |
| に間地が非常に少ない商業地域及び類似の住宅地域                 0.80  |
|   浸透面                                                             |
| の屋外作業等の間地を若干もつ工場地域及び若干庭がある住宅地域   0.65  |
|   住宅公                                                             |
| 団団地等の中層住宅団地及び1戸建て住宅の多い地域                0.50  |
|   庭園を                                                             |
| 多くもつ高級住宅地域及び畑地等が割合残っている郊外地域         0.35  |
|                                                                      |
| 総括流出                                                             |
| 係数：工種ごとの基礎流出係数を工種面積比で重付けして平均した流出係数 |
|                                                                      |
| c.  アメリカ土木学会の流出係数（ASCE、1993）                         |
|                                                                      |
| ```{=html}                                                           |
| <!-- -->                                                             |
| ```                                                                  |
| 4.  アメリカ土木学会の流出係数                                       |
|                                                                      |
| 土地利用別の総括流出係数\*　　　　　　　 流出係数の一般的範囲\*      |
|                                                                      |
| +----------------+--------------+----------------+--------------+    |
| | > 地域の記述   | > 流出係数   | > 地表面の特徴 | > 流出係数   |    |
| +================+==============+================+==============+    |
| | > 商業地       | > 0.70～0.95 | > 舗装         | > 0.70～0.95 |    |
| | >              | >            | >              | >            |    |
| | > 　商業区域   | > 0.50～0.70 | >              | > 0.70～0.85 |    |
| | >              | >            | 　アスファルト | >            |    |
| | > 　           | > 0.30～0.50 | とコンクリート | > 0.75～0.95 |    |
| | 商業地区の近隣 | >            | >              | >            |    |
| | >              | > 0.40～0.60 | > レンガ       | > 0.05～0.10 |    |
| | > 住居地域     | >            | >              | >            |    |
| | >              | > 0.60～0.75 | > 屋根         | > 0.10～0.15 |    |
| | > 　１家族住宅 | >            | >              | >            |    |
| | >              | > 0.25～0.40 | > 砂質土の芝生 | > 0.15～0.20 |    |
| | > 　複合       | >            | >              | >            |    |
| | 住宅、一戸建て | > 0.50～0.70 | > 　平坦（2%） | > 0.13～0.17 |    |
| | >              | >            | >              | >            |    |
| | > 　           | > 0.50～0.80 | >              | > 0.18～0.22 |    |
| | 複合住宅、連棟 | >            | 　標準（2-7%） | >            |    |
| | >              | > 0.60～0.90 | >              | > 0.25～0.35 |    |
| | > 住居（郊外） | >            | > 急こう       |              |    |
| | >              | > 0.10～0.25 | 配（7%より大） |              |    |
| | > アパート     | >            | >              |              |    |
| | >              | > 0.20～0.35 | > 重粘土の芝生 |              |    |
| | > 工業区域     | >            | >              |              |    |
| | >              | > 0.20～0.35 | > 　平坦（2%） |              |    |
| | > 　准工業地域 | >            | >              |              |    |
| | >              | > 0.10～0.30 | >              |              |    |
| | > 　重工業地域 |              | 　標準（2-7%） |              |    |
| | >              |              | >              |              |    |
| | > 公園、墓地   |              | > 急こう       |              |    |
| | >              |              | 配（7%より大） |              |    |
| | >              |              |                |              |    |
| | プレイグランド |              |                |              |    |
| | >              |              |                |              |    |
| | > 鉄道駅構内   |              |                |              |    |
| | >              |              |                |              |    |
| | > 未改良地域   |              |                |              |    |
| +----------------+--------------+----------------+--------------+    |
|                                                                      |
| \*ここに示                                                           |
| す流出係数の値の範囲は、リターンピリオド2-10年に対して典型的である。 |
|                                                                      |
| 大きい側の数値は、より大きな設計降雨に適用される。                   |
|                                                                      |
| d.  特定都市河川浸水被害対策法施行規則で規定                         |
| する流出雨水量の最大値を算定する際に用いる土地利用形態ごとの流出係数 |
|                                                                      |
| ```{=html}                                                           |
| <!-- -->                                                             |
| ```                                                                  |
| 5.  特                                                               |
| 定都市河川浸水被害対策法（平成15年法律第77号。以下「法」という。）\  |
|     第2条第9項に規定する「宅地等」に該当する土地（法第9条第1号関係） |
|                                                                      |
| ![](media/image35.emf){width="5.167303149606299in"                   |
| height="2.719825021872266in"}                                        |
|                                                                      |
| 6.  舗装された土地（法第9条第2号関係）                               |
|                                                                      |
| ![](media/image36.emf){width="5.111111111111111in"                   |
| height="0.6666666666666666in"}                                       |
|                                                                      |
| 7                                                                    |
| .  その他土地からの流出雨水量を増加させるおそれのある行為に係る土地\ |
|     （法第9条第3号関係）                                             |
|                                                                      |
| ![](media/image37.emf){width="5.535416666666666in"                   |
| height="0.8888888888888888in"}                                       |
|                                                                      |
| 8.  表3-2-5から表3-2-7までに掲げる土地以外の土地                     |
|                                                                      |
| ![](media/image38.emf){width="5.141666666666667in"                   |
| height="0.9493055555555555in"}                                       |
|                                                                      |
| 合                                                                   |
| 理式に用いられる洪水到達時間は、流域の最遠点に降った雨がその流域の出 |
| 口に達するまでに要する時間として定義される。洪水到達時間は当該流域の |
| 特性を調査して決定する定数であるが、通常次の2方法で求められている。  |
|                                                                      |
| a.  降雨が水路に入るまでの時間(流入時間)                             |
|     と水                                                             |
| 路の中を下流端に達するまでに要する時間(流下時間)の和として求める方法 |
|                                                                      |
| > これは、都市下水                                                   |
| 道の設計に用いられてきた方法で、山地や小河川で準用されることもある。 |
|                                                                      |
| 1.  流入時間                                                         |
|                                                                      |
| > 流入時間は流路に達するまでの排水区の形状や面積の大                 |
| 小、地表面勾配、地被状態、流下距離、降雨強度など多くの要素に支配され |
| る。現在、下水道の設計には一般に表3-2-9のような値が用いられている。  |
|                                                                      |
| 9.  日本とアメリカの流入時間（土木学会、1968）                       |
|                                                                      |
| ![](media/image39.emf){width="5.555555555555555in"                   |
| height="0.9694444444444444in"}                                       |
|                                                                      |
| 2.  流下時間                                                         |
|                                                                      |
| >                                                                    |
| 雨水が流路上流端に流入し、流量算出地点まで達するに要する時間が流下時 |
| 間である。河道においては通常Manningの平均流速公式が流下速度を与える  |
| と仮定して計算されている。下水道においては、管内の平均流速が用いられ |
| るが、平坦地では0.9～1.0m/s、勾配のとれる地域では1.15～1.26m/s、枝線 |
| では0.6～0.9m/sが一応の目安として用いられている（土木学会、1968）。  |
|                                                                      |
| b.  経験式を用いる方法                                               |
|                                                                      |
| > 洪水到達時間を求める経験式は、いろいろ提                           |
| 案されてきているが、その多くは流路長と勾配を用いた表現となっている。 |
|                                                                      |
| 1.  洪水到達時間*T*を、流路長*L*と洪水流出速度*W*から求める方法      |
|                                                                      |
| *T=L/W* (3-2-2)                                                      |
|                                                                      |
| > ここで、                                                           |
| >                                                                    |
| > *L*：流路長(m)                                                     |
| >                                                                    |
| > *T*：洪水到達時間 (s)                                              |
| >                                                                    |
| >                                                                    |
| *W*:洪水流出速度(m/s)であり、表3-2-10や式（3-2-3）等から求められる。 |
|                                                                      |
| ・河谷を流れ下る水の速度（井口，1957）                               |
|                                                                      |
| 10. 河谷を流れ下る水の速度の表                                       |
|                                                                      |
| ![](media/image40.emf){width="3.4444444444444446in"                  |
| height="0.5555555555555556in"}                                       |
|                                                                      |
| > ここで、*I*は流路勾配である。                                      |
|                                                                      |
| ・バイエルン地方で使い慣らされた式（井口，1957）                     |
|                                                                      |
| *W=*20*(h/L)*^0.6^ (3-2-3)                                           |
|                                                                      |
| > ここで、                                                           |
| >                                                                    |
| > *h*：落差 (m)                                                      |
|                                                                      |
| 3.  土木研究所での調査による洪水到達時間の式（吉野・米田，1973）     |
|                                                                      |
|     都市流域では、                                                   |
|                                                                      |
| (3-2-4)                                                              |
|                                                                      |
| > 自然流域では、                                                     |
|                                                                      |
| (3-2-5)                                                              |
|                                                                      |
| > で表されると報告されてい                                           |
| る。ここで、*T*：洪水到達時間(h)、*L*：流域最遠点から流量計算地点ま  |
| での流路長(m)、*S*：流域最遠点から流量計算地点までの平均勾配である。 |
| >                                                                    |
| > この公式の適用範囲は都市流域で流域面積*A*\<10km^2^ 、*S* \>1/300   |
| > 、自然流域で*A*\<50km^2^ 、*S* \>1/500 である。                    |
|                                                                      |
| 19. 貯留関数法                                                       |
|                                                                      |
| 貯留関数法は流域ないし河道をひとつの貯水池と考え、貯                 |
| 留量と流出量の関係（貯留関数）を運動方程式とし、これを連続方程式と組 |
| み合わせて、流出量を追跡する方法である。我が国では、1961年木村によっ |
| て提案された、浸透域と流出域に分割し流出計算を行う貯留関数法（木村,  |
| 1961；木村1975；建設省水文研究会編,                                  |
| 1962）が広く                                                         |
| 利用されている。また、浸透域と流出域に分割せず有効降雨を設定して流出 |
| 計算を行う貯留関数法も用いられている。以上のとおり、貯留関数法は我が |
| 国でこれまで多数の流域で適用実績を持っていて信頼性がある方法である。 |
|                                                                      |
| まず、木村の貯留関数法を説明する。                                   |
|                                                                      |
| 流域の貯留関数及び連続方程式は、それぞれ下式で表される。             |
|                                                                      |
| (3-2-6)                                                              |
|                                                                      |
| > (3-2-7)                                                            |
|                                                                      |
| ここで、                                                             |
|                                                                      |
| > ：みかけの流域貯留高(mm)                                           |
| >                                                                    |
| > ：遅滞時間を考慮した流域からの直接流出高(mm/h)                     |
| >                                                                    |
| > ：流域平均降雨強度(mm/h)                                           |
| >                                                                    |
| > *k、p* ：流域による定数                                            |
|                                                                      |
| を表す。                                                             |
|                                                                      |
| 河道区間の貯留関数及び連続方程式は、それぞれ下式で表される。         |
|                                                                      |
| 又は (3-2-8)                                                         |
|                                                                      |
| (3-2-9)                                                              |
|                                                                      |
| ここで、                                                             |
|                                                                      |
| > ：みかけの河道貯留量((m^3^/s)h)                                    |
| >                                                                    |
| > ：遅滞時間を考慮した河道区間下流端流量(m^3^/s)                     |
| >                                                                    |
| > ：遅滞時間（h）                                                    |
| >                                                                    |
| > ：流入量群(m^3                                                     |
| ^/s)、流域、支川等から対象河道区間に流入する量又は河道区間上流端流量 |
| >                                                                    |
| > *K、P* ：河道による定数                                            |
| >                                                                    |
| > ：流入係数                                                         |
|                                                                      |
| を表す。                                                             |
|                                                                      |
| 式(3-2-7)の貯留高*s*と流出高*q*と                                    |
| の関係は既往の洪水流出資料から求められる。一般に流出ハイドログラフの |
| 増水部と減水部では*ｓ*と*q*の関係は異なるが、遅滞時間を導入してこれ  |
| を一価関数に近似できるように修正するところに貯留関数法の特色がある。 |
|                                                                      |
| 貯留関数法では流域に対する一つ                                       |
| の貯留関数の適用限界で流域面積が決定される。木村は流域面積10～1,000  |
| km^2^、流路長で10～100km程度ならば十分な精度が得られるとしている。こ |
| れまでの実例ではおおむね300km^2^以下の小流域に分割して計算を行ってい |
| る例が多い。小流域が大きすぎると流域内の地形や地質に相違が生じたり、 |
| 河道が長くなることによる河道流下の影響が現れるので、流域での貯留関数 |
| の適用に無理が生じる。したがって、対象とする流域面積としては100km^2^ |
| 前後のものが望ましい。なお、流                                       |
| 量検証地点が多く望めない流域では分割を多くすると変動要素を増やすこと |
| になるので、結果の妥当性の検証が難しい場合もあることに注意を要する。 |
|                                                                      |
| 木村の貯留関数法では、*f*は降雨量*r~ave~*                            |
| に係る係数で                                                         |
| はなく、流域面積*A*に係る係数であると考える。すなわち、降雨初期には  |
| *f=f~1~* (1次流出率という)として*f~1~A*                              |
| の面積(流出域という)だけで流出が発生するとし、累加雨量が*R~sa        |
| ~*(飽和雨量)を超えると*f*=1(飽和流出率)となって残りの(1-*f~1~*)*A*の |
| 部分(浸透域)からも流出が発生すると考える。ただし、流出域と浸透域とは |
| 洪水の終わりまで別個に流出計算を行うものとし、流出域からの流出量と浸 |
| 透域からの流出量の和に基底流量を加えた値をもって流域流出量とする。流 |
| 域からの計算流出量*Q*(m^3^/s)は基底流量を加えて次の式で与えられる。  |
|                                                                      |
| (3-2-10)                                                             |
|                                                                      |
| ここで、                                                             |
|                                                                      |
| > *f~1\ ~*：1次流出率                                                |
| >                                                                    |
| > *A* ：流域面積 (km^2^)                                             |
| >                                                                    |
| > *q~1\ ~*：全降雨による流出高(mm/h)                                 |
| >                                                                    |
| > ：飽和点以後の降雨による流出高 (mm/h)                              |
| >                                                                    |
| > *Q~i\ ~*：基底流量 (m^3^/s)                                        |
|                                                                      |
| である。                                                             |
|                                                                      |
| 浸透域と流出域に分割せず有効降雨を設定                               |
| する貯留関数法の計算式は次のとおりである（角屋・永井、1980）。流域の |
| 貯留関数は(3-2-6)と同じ式である一方、流域の連続方程式は下式となる。  |
|                                                                      |
| (3-2-11)                                                             |
|                                                                      |
| ここで、                                                             |
|                                                                      |
| > ：みかけの流域貯留高(mm)                                           |
| >                                                                    |
| > *r~e~* ：流域平均有効降雨強度 (mm/h)                               |
| >                                                                    |
| > ：遅滞時間を考慮した流域からの直接流出高(mm/h)                     |
|                                                                      |
| 有効降雨の算出はいかなる手法の適用も可能で                           |
| あるが、木村の貯留関数法における一次流出率と飽和雨量の考え方を踏襲し |
| 、累加雨量が*R~sa~*(mm)に達するまでは流出率を*f~1~*として、それを超  |
| えると流出率は1として、*r~e~*を算出する計算方法をとる場合が多い。流  |
| 域からの計算流出量*Q*(m^3^/s)は基底流量を加えて次の式で与えられる。  |
|                                                                      |
| (3-2-12)                                                             |
|                                                                      |
| ここで、                                                             |
|                                                                      |
| > *q* ：計算流出高 (mm/h)                                            |
| >                                                                    |
| > *Q~i\ ~*：基底流量 (m^3^/s)                                        |
|                                                                      |
| 20. 等価粗度法(Kinematic Wave法)                                     |
|                                                                      |
| Kinematic Wave法                                                     |
| (キネマティック・ウェーブモデル)（末石、                             |
| 1955）とは、河川流路における洪水流下現象を水流の運動法則と連続の関係 |
| を用いて水理学的に追跡するものである。この手法を流域斜面における雨水 |
| 流下現象にも適用したものが、ここで説明する等価粗度法である。すなわち |
| 、流域をいくつかの矩形斜面と流路が組み合わされたものとみなし、これら |
| の斜面からの流出現象をManning型の平均流速公式で表現し、この斜面と流  |
| 路を組み合わせた流域からの流出ハイドログラフが実測ハイドログラフに近 |
| づくように粗度係数を決定する。このことから、流域に適用したKinematic  |
| Wave法は等価粗度法とも呼ばれる。                                     |
|                                                                      |
| 複雑な流                                                             |
| 域斜面からの流出現象はモデル化して取り扱えるが、等価粗度法(Kinematic |
| Wave法)を実河川に適用するには、対象とする河川が比較的急勾配で、か    |
| つ、降雨強度が大きく流出現象が洪水流出により生じていることが必要であ |
| る。中間流や地下水流出が支配的な洪水では、逓減特性を近似することが難 |
| しく、妥当な結果を得られない場合がある。また、支川の合流点その他で河 |
| 道をある区間ごとに分割したとき、その区間内では横断面、勾配、粗度、横 |
| からの流入量などが流路に沿って一様に近いものと仮定できる必要がある。 |
|                                                                      |
| 以下、等価粗度法による流出計算の基本式について簡単に紹介しておく。   |
|                                                                      |
| 山腹斜面に降った雨の一部は浸                                         |
| 透し、一部は地表を流れて小さな水路からやがては大きな水路へと集められ |
| ていく。この過程を模式的に図示したものが図3-2-1である。流出計算は有  |
| 効降雨による斜面からの流出量*q*を求め、これを横流入量とする河道内の  |
| 流量*Q*を計算することにより行われる。考えている流域外から水路上流端  |
| へ供給される水量、あるいは降雨の始まる前から河道に既に流れていた流量 |
| などがある場合には、それぞれ境界条件及び初期条件として考慮に入れる。 |
|                                                                      |
| ![](media/image63.emf){width="4.532234251968504in"                   |
| height="2.9591076115485566in"}                                       |
|                                                                      |
| 1.  等価粗度法における流域斜面及び河道のモデル                       |
|                                                                      |
| いま、図3-2-1のように斜面から河道へ時                                |
| 間的に変動する横流入量*q(t)*がある場合、流れが定常に近いものと仮定す |
| れば、河道内の運動方程式と連続方程式はそれぞれ次のように表現される。 |
|                                                                      |
| (3-2-13)                                                             |
|                                                                      |
| (3-2-14)                                                             |
|                                                                      |
| ここで、*i*は水面勾配、*i~f~*は摩擦勾配、*A*は流水断面積、*Q*は断面  |
| 平均流量、*x*は河道の流下方向の位置である。運動方程式の解として定常  |
| 等流における抵抗法則、例えばManningの式を代用すれば式(3-2-13)から、  |
|                                                                      |
| (3-2-15)                                                             |
|                                                                      |
| が得られる。                                                         |
|                                                                      |
| 流路における径深*R*と断面積*Aと*の関係が、、*Z*を定数として、        |
|                                                                      |
| (3-2-16)                                                             |
|                                                                      |
| と表されると仮定すれば、式(3-2-15)は次のように書き換えられる。       |
|                                                                      |
| (3-2-17)                                                             |
|                                                                      |
| ここに、                                                             |
|                                                                      |
| 、 (3-2-18)                                                          |
|                                                                      |
| である。                                                             |
|                                                                      |
| このように河道内の流れをモデル化すれば、式(3-2-1                     |
| 4)と式(3-2-17)を適当な境界条件、初期条件の下に解けばよいことになる。 |
|                                                                      |
| これと同様な考えをモデル化                                           |
| された流域斜面にも適用すれば、その流れは次式で表現できることになる。 |
|                                                                      |
| (3-2-19)                                                             |
|                                                                      |
| 　 (3-2-20)                                                          |
|                                                                      |
| こ                                                                   |
| こに、*h*は水深、*q*は単位幅当たりの流量、*y*は斜面の流下方向の位置  |
| 、*r~1~*は有効降雨強度、*α*は単位変換定数で*r~1~*をmm/h、*q*をm^2^/s |
| とすると                                                             |
| 、*α*＝(1/3.                                                         |
| 6)×10^-6^、*p*と*k*は定数で、流れに対してManning則が成立するときは、 |
|                                                                      |
| *、p=3/5* (3-2-21)                                                   |
|                                                                      |
| ここに、*N*は等価粗度、は斜面傾斜角である。式(3-2-19)、式(3-2        |
| -20)は式(3-2-17)、式(3-2-14)と同じ式形であって、これをこのままの形で |
| 差分化して数値計算するか、特性方程式上で数値積分すれば解が得られる。 |
|                                                                      |
| 実際の計算に際しては、斜                                             |
| 面の粗度係数*N*を変化させて計算を行い、実測と計算値がよく一致すると  |
| みなされるときの*N*値をその流域の等価粗度係数とする。等価粗度係数は  |
| 流域の分割の仕方によるが10^0^～10^-2^の値(m^-1/3^s)をとるものが多い  |
| 。流域の特性による等価粗度の値としては表3-2-11の値が挙げられている。 |
|                                                                      |
| 11. 流域特性と等価粗度（田岡・日野、1965）                           |
|                                                                      |
| ![](media/image76.emf){width="5.11224956255468in"                    |
| height="1.6905227471566053in"}                                       |
|                                                                      |
| 等価粗度法は、流域を複数の矩形斜面に区分することから、               |
| 斜面要素型の分布モデルとみなすことができる。また、上記のとおり、降雨 |
| 時に生じる表面流出又は早い中間流出を含む直接流出の流れを追跡すること |
| が基本である。しかしながら、最近では、山地森林土壌中への浸透に起因し |
| た降雨損失や、中間流出や基底流出を含む、様々な遅い流出成分を考慮でき |
| るように改良したキネマティック・ウェーブモデルが開発されてきている。 |
|                                                                      |
| 21. 準線形貯留型モデル（土研、1979）                                 |
|                                                                      |
| 都市化等による土地利用の変化が流出にどのような変化を                 |
| もたらすかという観点から検討された初期の流出モデルとして準線形貯留型 |
| モデルがある。準線形貯留型モデルは、有効降雨モデル、斜面モデル(準線  |
| 形貯留型モデル)及び河道モデル(貯留関数法等)の3つより構成されている。 |
|                                                                      |
| 有効降雨モデルとしては、1次流出率（*f~1~*）～飽和雨量                |
| (*R~sa\ ~*)～飽和流出率（*ｆ~sa~*）モデル等がある。有効降雨モデルで  |
| は、損失雨量が土地利用状況ごと(山林、水田、畑、市街地)に異なることを |
| 想定し、それぞれ対象流域においてあらかじめ最適化しておく必要がある。 |
|                                                                      |
| 斜面モデルの基本式は、次のように表される。                           |
|                                                                      |
| (3-2-22)                                                             |
|                                                                      |
| (3-2-23)                                                             |
|                                                                      |
| ただし、 (3-2-24)                                                    |
|                                                                      |
| ここで、*S*：貯留高(mm)、*q*：流出高(mm/h)、                         |
| *t~c~*：洪水到達時間(h)である。                                      |
| *t~c~*は、角屋                                                       |
| らによる洪水到達時間の経験式と実績の有効降雨強度曲線から決定される。 |
|                                                                      |
| (3-2-25)                                                             |
|                                                                      |
| ここで、*t~p~*:式(3-2-24)の*t~c~*を分で表示                          |
| した洪水到達時間、*r~e~*：降雨継続時間内の最大平均有効降雨強度(mm/h  |
| )、*A*：流域面積(km^2^)、*C*：土地利用形態によって定まる定数である。 |
|                                                                      |
| このよう                                                             |
| なモデル構成により、1)*t~c~*を通じて斜面上の流れの非線形性が表現でき |
| る、2)土地利用形態の差異による流出の差異を表現できる、3)当該河川流域 |
| 内の他の排水計画(下水道、中小河川等)に使われるモデル（合理式）と共通 |
| 性がある、という特徴がある。ただし、土地利用形態の差異による流出の差 |
| 異をよりよくしていくためには、土地利用別の有効降雨及び洪水到達時間の |
| 評価に係わる資料を蓄積し、それぞれのモデルを改良していく必要がある。 |
|                                                                      |
| 22. タンクモデル                                                     |
|                                                                      |
| タンクモデル                                                         |
| は図3-2-2に示すように、流域を側面にいくつかの流出孔を持つ容器で置き  |
| 換えて考える流出計算法である（菅原、1972；菅原、1979）。世界気象機関 |
| の概念モデルの比較プロジェクトで、世界の多様な気候下でも高い適用性が |
| ある流出モデルと評価され、世界的に多く用いられている（木下、2001）。 |
|                                                                      |
| ![](media/image81.emf){width="0.8083333333333333in"                  |
| height="3.2527777777777778in"}                                       |
|                                                                      |
| 2.  一般的なタンクモデルの構造                                       |
|                                                                      |
| 雨はタンクモデルの最上段の容器に注入                                 |
| される。2段目以下の容器は、1段上の容器の底面の孔から水を受ける。各容 |
| 器内の一部の水は側面の孔から外部に流出し、一部は底面の孔から直下の容 |
| 器に移行する。各段の容器の側面の孔からの流出の和が河川の流量となる。 |
|                                                                      |
| 一般的なタンクモデルの構造は                                         |
| 直列４段の容器から成り、各段の容器からの流出は、最上段が洪水の表面流 |
| 出、第2段が表層浸透流出、第3～4段が地下水流出に対応すると概念的に考  |
| えられている。融雪がある又は乾季が続くといった地域特性を、容器を増や |
| したりその配置を変更することにより、高い再現性を有する（WMO、1975）  |
|                                                                      |
| しかし、斜面や河道                                                   |
| を通して水が集水する過程を、横方向に一つの容器の構造を持ち、河道モデ |
| ルを有しないタンクモデルでは表現できないので、各流出孔の定数は、河道 |
| における洪水の伝播を含めた当該流域の集中過程等の様々な影響を含んだ定 |
| 数で、物理モデルと異なり流域の物理特性と関連付けられるものではない。 |
|                                                                      |
| したがって、タンクモデルの定数（各孔の大きさ及び側面の孔の           |
| 高さ）は、過去の水文資料を用いて、試行錯誤で求めることが必要となる。 |
|                                                                      |
| タンクモデル法の特徴を要約すると次のとおりである。                   |
|                                                                      |
| a.  初期損失とその損失雨                                             |
| 量が降雨履歴によって変化する現象を自動的にモデル中に含んでいること。 |
|                                                                      |
| b.  大洪水と小洪水とで、流出の仕方が自動                             |
| 的に切り換わる構造（非線形性をモデル中に含んでいる構造）であること。 |
|                                                                      |
| c.  洪水と小洪水とで、流出率が自動的に切り換わる構造であること。     |
|                                                                      |
| d.  各段のタンクからの流出は、それぞれ固有の逓減曲線を示す           |
| ので、流出量が固有の逓減を持ついくつかの流出成分の和で表されること。 |
|                                                                      |
| e.  水が                                                             |
| タンクを通過して下方に移行する間に自動的に時間遅れが与えられること。 |
|                                                                      |
| f.  洪水                                                             |
| 流出にも低水流出にも用いることができること。ただし、一般には、それぞ |
| れの目的に最適化したモデル構造と定数により使い分けられることが多い。 |
|                                                                      |
| ```{=html}                                                           |
| <!-- -->                                                             |
| ```                                                                  |
| 23. 土研分布モデル                                                   |
|                                                                      |
| 1980年代にヨーロッパでSHEモデル                                      |
| やIHDMモデルといった分布定数系モデルが相次いで開発されたが、当時はモ |
| デル化の手間や計算時間の制約から流域面積10km^2^程度までの適用が限界  |
| とされ、またヨーロッパ特有の流域以外への適用性に疑問が持たれていた。 |
| このことから、我が国の河川流域で主要な流出の水文過程を組み込み、それ |
| 以外をある程度簡略化し、大流域にも適用できる実用的なグリッド型の分布 |
| 定数系モデルである「土研分布モデル」を土木研究所が開発した。長期・短 |
| 期流出解析両用のVer.1、短期流出解析用にモデルを簡略化したVer.2、長期 |
| 流出解析用に蒸発散等の地表面水文過程を高度化したVer.3の3種類がある。 |
| 以下、最も広く用いられているVer.2について解説する（鈴木ら、1996）。  |
|                                                                      |
| 土研分                                                               |
| 布モデルVer.2の河川流域での基本構成は図3-2-3のとおりであり、流域をグ |
| リッドで分割し、それぞれの小区画からの流出を連結する構造としている。 |
|                                                                      |
| ![](media/image82.emf){width="5.413888888888889in"                   |
| height="2.454861111111111in"}                                        |
|                                                                      |
| 3.  土研分布モデルVer.2の構成図                                      |
|                                                                      |
| それぞれの小区画に2                                                  |
| 段のタンク（表層モデル、地下水モデル）を設定し、それぞれらからの流出 |
| を、その小区画における土壌の透水係数等の物理特性を考慮して計算する。 |
| 各小区画からの流出は、落水線網に従って、隣接する小区画に流入させる。 |
|                                                                      |
| 表層モデルの構造を図3-2-4に示す。                                    |
|                                                                      |
| ![](media/image83.wmf){width="3.9706397637795274in"                  |
| height="1.9598425196850393in"}                                       |
|                                                                      |
| 4.  各小区画の表層モデルの構造                                       |
|                                                                      |
| ここに、*S~f2~*：表面流の発生する高さ(m)、*S~f1~*                    |
| ：中間流の発生する高さ(m)、*S~f0~*：地下浸透の発生する高さ(m)、*h*： |
| 貯留高(m)、*L*：グリッド長(m)、*N*：粗度係数(m^-1/3^/s)、*i*：落水線 |
| 勾配(無次元)、*α~ri~*：地下浸透に対する横方向浸透能の比（無次元）、  |
| *A*:小区画の面積(m^2^)、*f~0~*：最終浸透能(cm/s)である。地形、土地利 |
| 用、土壌の違いや土壌水分量の多寡による表面流や浸透、中間流、降下浸透 |
| の発生の変化を物理定数や内部貯留高を通して表現できるようにしている。 |
|                                                                      |
| 地下水モデルの構造は、図3-2-5のとおりである。                        |
|                                                                      |
| ![](media/image84.wmf){width="3.100787401574803in"                   |
| height="1.4083945756780403in"}                                       |
|                                                                      |
| 5.  各小区画の地下水モデルの構造                                     |
|                                                                      |
| ここに、*S~g~*：不圧                                                 |
| 地下水流出が発生する高さ(m)、*A~u~*：不圧地下水位流出量に係る係数((  |
| 1/mm/day)^1/2^)、*A~g~*：被圧地下水位流出量に係る係数(1/day)である。 |
|                                                                      |
| 表面流、早い中間流、不圧地下水流、                                   |
| 被圧地下水流の合計が斜面からの流出量であり、河道モデルに入力される。 |
|                                                                      |
| 河道モデルは、ある閾                                                 |
| 値（上流側の小区画数）を超えて真に河道が形成されていると考えられる小 |
| 区画から下流に設定し、キネマティック・ウェーブモデルにより洪水追跡を |
| 行う。下流部の緩流河道区間のために不定流モジュールも準備されている。 |
|                                                                      |
| 本モデル                                                             |
| は、CommonMPに標準搭載されている。また、発展途上国での水文資料が乏し |
| い河川流域での洪水予測への適用を主目的として開発された、グラフィカル |
| なユーザーインターフェースを搭載する総合洪水解析システム(Integrated  |
| Flood Analysis System:                                               |
| IFAS)のコアとなる流出モデルとしても活用されている（土研、2009）。    |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  (財)河川情報センター：中小河川における洪水予測の手引き，2002.

```{=html}
<!-- -->
```
131. 流出雨水量の最大値を算定する際に用いる土地利用形態ごとの流出係数を定める告示，平成16年，告示第521号，国土交通省.

＜参考となる資料＞

下記の資料が参考となる。

1.  物部長穂：水理学，p.350，岩波書店，1933.

```{=html}
<!-- -->
```
132. 日本下水道協会：下水道施設計画・設計指針と解説　前編　-2009年度版-，p.71，2009.

133. Task Committee of the Urban Water Resources Research Council of
     ASCE：Design and Construction of Urban Stormwater Management
     Systems (ASCE)，ASCE Manuals and Reports of Engineering
     Practice，No.77 (MOP77)，pp.91-92，1993.

134. 土木学会：下水道雨水流出量に関する研究報告書，昭和４２年度巻，p.84，1968.

135. 井口昌平：コウ水の到達速度に関するいわゆるRzihaの公式とKravenの表の由来について，土木学会誌，42-1，pp.25-27，1957.

136. 吉野文雄，米田耕蔵：合理式の洪水到達時間と流出係数，土木技術資料，第15巻
     第8巻，pp.3-6，1973.

137. 木村俊晃：貯留関数法による洪水流出追跡法，建設省土木研究所，1961.

138. 木村俊晃：貯留関数法，河鍋書店，1975.

139. 建設省水文研究会編集：流出計算例題集II，(社)全日本建設技術協会，1962.

140. 角屋睦，永井明博：流出解析手法（その10），農業土木学会誌，第48巻
     第10号，4. 貯留法ー貯留関数法による洪水流出解析，1980.

141. 日本学術会議：回答　河川流出モデル・基本高水の検証に関する学術的な評価，p.11，2010.

142. 末石冨太郎：特性曲線法による出水解析について，土木学会論文集，第29号，pp.74-87，1955.

143. 田岡穣，日野峻栄：特性曲線法による山科川内水調査について，第19回建設省技術研究会報告，pp.585-588，1965.

144. 石崎勝義，佐合純造，他１名：土地利用変化を評価する流出モデル，土木研究所資料，第1499号，1979.

145. 菅原正巳：水文学講座 7 流出解析法，共立出版，1972.

146. 菅原正巳：水文学講座 別巻 続・流出解析法，共立出版，1979.

147. 木下武雄：水害の日本で生まれ世界に広まったタンクモデル，土木学会誌，第86巻第5号，pp.69-73，2001.

148. World Meteorological Organization (WMO)：Intercomparison of
     conceptual models used in operational hydrological
     forecasting，WMO-No.429，1975.

149. 鈴木俊朗，寺川陽，松浦達郎：実時間洪水予測のための分布型流出モデルの開発（特集　水は巡る），土木技術資料，38-10，1996.

150. 深見和彦，杉浦友宣，馬籠純，川上貴宏 ：総合洪水解析システム(IFAS
     Version[1.2](http://www.yahoo.co.jp))ユーザーズマニュアル，土木研究所資料，第4149号，2009.

第3章　水文解析　第3節　地下水解析 {#第3章-水文解析-第3節-地下水解析 .TOC-Heading}
==================================

目　次 {#目-次-3 .TOC-Heading}
======

[第3節 地下水解析 1](#_Toc296373845)

> [3．1 総説 1](#_Toc296614230)
>
> [3．2 水収支解析 1](#_Toc296614231)
>
> [3．3 地下水流動解析 3](#_Toc296614232)
>
> [3．4 地下水汚染解析 8](#_Toc296614233)
>
> [3．5 地盤沈下解析 9](#_Toc296614234)

平成26年4月　版

6.  水文解析

    3.  []{#_Toc296373845 .anchor}地下水解析

        1.  []{#_Toc296614230 .anchor}総説

＜考え方＞

+----------------------------------------------------------------------+
| 地下水解析は、対象地域における地下水の状                             |
| 態や予測を、調査・観測データを用いた数値解析等により行うものである。 |
|                                                                      |
| 数値解析の一般的な手法は、目的や取り扱う検討項目によって、①水収支    |
| 解析、②地下水流動解析、③地下水汚染解析、④地盤沈下解析に区分される。  |
+----------------------------------------------------------------------+

＜必　須＞

  --------------------------------------------------------------------------------------
  地下水解析は、目的や取り扱う検討項目に応じた解析手法により、実施しなければならない。
  --------------------------------------------------------------------------------------

＜標　準＞

  -------------------------------------------------------------------------------------------------------------------------------------------
  低水流出解析、河川と地下水の関係を解析する場合については、第3章 第2節[2.3](http://www.yahoo.co.jp/) 低水流出計算 によることを標準とする。
  -------------------------------------------------------------------------------------------------------------------------------------------

＜参考となる資料＞

地下水解析の詳細については、下記の資料が参考となる。

1.  建設省河川局監修，(財)国土開発技術研究センター編集：[地下水調査および観測指針（案）](http://www.jice.or.jp/tosho/pdf/chikasui.pdf)，pp.257-289，山海堂，1993.

```{=html}
<!-- -->
```
6.  日本地下水学会
    > 地下水流動解析基礎理論のとりまとめに関する研究グループ編集：地下水シミュレーション，技報堂出版，2010.

7.  地下水ハンドブック編集委員会：地下水ハンドブック，pp.980-994，建設産業調査会，1998.

    1.  []{#_Toc296614231 .anchor}水収支解析

＜考え方＞

  ----------------------------------------------------------------------------------------------------
  水収支解析は、広域における水循環の主として地下水に関わる問題を、検討することを目的として実施する。
  ----------------------------------------------------------------------------------------------------

＜必　須＞

  ------------------------------------------------------------------------------------------------------------------------------------------
  対象領域、対象期間は、対象地域の特性、利用可能なデータ等を考慮して、所期の目的が達成できるように、それぞれ適切に選定しなければならない。
  ------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

  --------------------------------------------------------------------------------------
  水収支解析は、水収支モデルによる解析方法と、タンクモデルによる解析方法を標準とする。
  --------------------------------------------------------------------------------------

＜例　示＞

+----------------------------------------------------------------------+
| 1.  水収支モデルによる解析                                           |
|                                                                      |
| 地下水の水収支式は、不圧地下水と                                     |
| 被圧地下水の別等により異なる。以下に不圧地下水の水収支式の例を示す。 |
+----------------------------------------------------------------------+

+----------------------------------------------------------------------+
| ![](media/image85.emf){width="3.7145669291338583in"                  |
| height="2.2437007874015746in"}                                       |
|                                                                      |
| 8.  不圧地下水の水収支概念図                                         |
|                                                                      |
| （「地下水調査及び観測指針（案）」に加筆）                           |
|                                                                      |
| ・水収支式                                                           |
|                                                                      |
| 地表水　　　 (3-3-1)                                                 |
|                                                                      |
| 地下水　　　 (3-3-2)                                                 |
|                                                                      |
| ここに、                                                             |
|                                                                      |
| 　　　　　 ：降雨量　                                                |
|                                                                      |
| 　　　　　                                                           |
| ：表流水流入量（上流域からの地表水、かんがい水等の流入量）           |
|                                                                      |
| 　　　　　 ：表流水流出量（下流域への地表水、かんがい水等の流出量）  |
|                                                                      |
| 　　　　　                                                           |
| ：地下水流入量（上流域からの地下水、異なる帯水層等からの流入量）     |
|                                                                      |
| 　　　　　                                                           |
| ：地下水流出量（下流域への地下水、異なる帯水層等への流出量）         |
|                                                                      |
| 　　　　　 ：蒸発散量                                                |
|                                                                      |
| 　　　　　 ：地表における貯留量変化（表流水の水位変化等）            |
|                                                                      |
| 　　　　　 ：地下水揚水量・地下水湧水量                              |
|                                                                      |
| 　　　　　 ：不飽和帯の土壌水分量変化                                |
|                                                                      |
| （地表から帯水層上端までの土壌中の水分量の変化）                     |
|                                                                      |
| 　　　　　 ：地下水位変化量（対象領域の面積×貯留係数×地下水位変化）  |
|                                                                      |
| 　　　　　 ：地下水かん養量（地表から浸透する水量）                  |
|                                                                      |
| である。                                                             |
|                                                                      |
| 対象期間を長期（たとえば１水文年）とすること                         |
| により、地表における貯留量変化や、不飽和帯の土壌水分量変化をゼロとみ |
| なせる場合がある。短い時間単位や対象領域を細分化した水収支解析は多く |
| のデータを要し、水収支解析は困難になることが多い。その場合、地下水流 |
| 動解析を行い、その計算結果を集約し水収支を推定することが可能である。 |
|                                                                      |
| 24. タンクモデルによる方法                                           |
|                                                                      |
| 地下水涵養量の算                                                     |
| 出や中小河川流域を対象とする水収支の検討のため、河川の流出解析法とし |
| て開発されたタンクモデルを地下水に適用する。全域を１か所のタンクモデ |
| ルで表現する場合や、流出特性に応じてタンクを連結する場合などがある。 |
+----------------------------------------------------------------------+

1.  []{#_Toc296614232 .anchor}地下水流動解析

＜考え方＞

  --------------------------------------------------------------------------------------------
  地下水流動解析は、広域的又は局所的な地下水流動状況の把握あるいは予測を目的として実施する。
  --------------------------------------------------------------------------------------------

＜必　須＞

  ----------------------------------------------------------------------------------------------------------
  地下水流動解析の手法は、目的、対象地域の特性、利用可能なデータ等を考慮して適切に選定しなければならない。
  ----------------------------------------------------------------------------------------------------------

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  解析結果は、調査対象域の地下水状況が把握できるように、調査目的に応じてデータの整理を行い、地下水位等高線図、地下水位変動図等、適切な図表等を用いてわかりやすく表現することを基本とする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜例　示＞

+----------------------------------------------------------------------+
| 地下水流                                                             |
| 動解析の一般的な手順としては、図3-3-2　に示すように、目的に応じた解  |
| 析対象地域を設定し、解析モデルを作成する。モデルは、各種条件の下で検 |
| 証を行い、妥当性を検討した上で、将来計画の条件による予測計算を行う。 |
|                                                                      |
| ![](media/image99.emf){width="3.4448818897637796in"                  |
| height="6.833464566929134in"}                                        |
|                                                                      |
| 10. 地下水流動解析の流れ                                             |
|                                                                      |
| （「地下水調査及び観測指針（案）」に加筆）                           |
|                                                                      |
| 飽和層中の地下水の流動は                                             |
| 、ダルシー則と連続式を組み合わせて、次の地下水流動方程式で示される。 |
|                                                                      |
| (3-3-3)                                                              |
|                                                                      |
| ここに、                                                             |
|                                                                      |
| ：*x*、*y*、又は*z*方向（*i*=1、2、3）                               |
|                                                                      |
| 　　　 ：*x~i~*方向の透水係数〔〕                                    |
|                                                                      |
| 　　　 ：水頭〔〕                                                    |
|                                                                      |
| 　　　 ：比貯留係数〔〕                                              |
|                                                                      |
| 　　　 ：単位体積あたりの吸い込み、注水〔〕                          |
|                                                                      |
| 　　　 ：空間座標〔〕                                                |
|                                                                      |
| 　　　 ：時間〔〕                                                    |
|                                                                      |
| > である。                                                           |
|                                                                      |
| 上記で示した地下水流動方程式は三                                     |
| 次元であるが、対象とする流域の特性や目的によって次元を下げることが可 |
| 能である。地下水流動解析の手法には、表3-3-1　に示されるものがある。  |
+======================================================================+
| 1.  地下水流動解析モデルの特性と適用条件                             |
|                                                                      |
| （「地下水調査及び観測指針（案）」に加筆）                           |
+----------------------------------------------------------------------+
| ![](media/image114.emf){width="5.9375in"                             |
| height="2.3854166666666665in"}                                       |
|                                                                      |
| a　三次元モデル                                                      |
|                                                                      |
| ![](media/image115.emf){width="5.979166666666667in"                  |
| height="3.2708333333333335in"}                                       |
|                                                                      |
| b　準三次元モデル①                                                   |
|                                                                      |
| ![](media/image116.emf){width="6.010416666666667in"                  |
| height="3.0520833333333335in"}                                       |
|                                                                      |
| c　準三次元モデル②                                                   |
|                                                                      |
| ![](media/image117.emf){width="6.083333333333333in"                  |
| height="2.8125in"}                                                   |
|                                                                      |
| d　準三次元モデル③                                                   |
|                                                                      |
| ![](media/image118.emf){width="6.020833333333333in"                  |
| height="1.9895833333333333in"}                                       |
|                                                                      |
| e　断面二次元モデル                                                  |
|                                                                      |
| ![](media/image119.emf){width="5.479166666666667in" height="2.25in"} |
|                                                                      |
| f　平面二次元モデル                                                  |
|                                                                      |
| ![](media/image120.emf){width="2.9375in"                             |
| height="2.1458333333333335in"}                                       |
|                                                                      |
| g　一次元モデル                                                      |
|                                                                      |
| 9.  各地下水流動解析モデルの概念図                                   |
+----------------------------------------------------------------------+

＜例　示＞

+----------------------------------------------------------------------+
| 近年は、地下水流                                                     |
| 動や地下水汚染の問題を解析するためのプログラムが多く公表されている。 |
|                                                                      |
| 解析に用いるプログラムの選                                           |
| 定に当たっては、対象とする地域あるいは目的に合致するかどうかはもちろ |
| んのこと、経済性、解析に要する時間効率等も勘案することが重要である。 |
|                                                                      |
| 以下に公開されている主なプログラムの一部を参考として示す。           |
|                                                                      |
| 2.  地下水解析プログラムの事例                                       |
+----------------------------------------------------------------------+

＜参考となる資料＞

各プログラムについては、下記のサイトが参考となる。

1.  GWAP，UNSAF，Dtransu.\
    <http://gw.civil.okayama-u.ac.jp/gel_home/download/index.html>

```{=html}
<!-- -->
```
8.  MODFLOW.\
    > <http://water.usgs.gov/nrp/gwsoftware/modflow.html>

    1.  []{#_Toc296614233 .anchor}地下水汚染解析

＜標　準＞

  -----------------------------------------------------------------------------------------------------------------------
  地下水汚染解析については、第12章 水質・底質調査 第2節 水質調査 [2.13](http://www.yahoo.co.jp)によることを標準とする。
  -----------------------------------------------------------------------------------------------------------------------

2.  []{#_Toc296614234 .anchor}地盤沈下解析

＜考え方＞

+----------------------------------------------------------------------+
| 地盤沈下解析は、地盤沈下が進行するあるいは予想される地域において     |
| 、地盤沈下量の予測及び沈下量と揚水量との関係の把握のために実施する。 |
|                                                                      |
| 地下水の揚水に伴う広域的な地盤沈下は、粘性土                         |
| の圧縮により発生するものと、砂層や礫層などの弾性変形によって生じるも |
| のとがあり、前者の方が沈下量は大きい。帯水層中の水圧が低下すると、粘 |
| 性土中の水圧も徐々に低下し、土粒子構造が収縮する、いわゆる脱水圧密現 |
| 象が生じる。各地層の収縮量が地表に累積され、地盤沈下となって現れる。 |
|                                                                      |
| ![](media/image122.emf){width="3.78125in" height="2.15625in"}        |
|                                                                      |
| 11. 粘土層の圧密収縮                                                 |
|                                                                      |
| （佐藤、岩佐「地下水理学」（2002）、丸善による）                     |
|                                                                      |
| 地盤沈下解析の手法には、時系列的な予測手法、圧                       |
| 密理論による予測手法及び地盤沈下シミュレーション等が用いられている。 |
+----------------------------------------------------------------------+

＜必　須＞

  --------------------------------------------------------------------------------
  解析の手法は、目的、対象地域の特性などを考慮して適切に選定しなければならない。
  --------------------------------------------------------------------------------

＜例　示＞

+----------------------------------------------------------------------+
| 時系列的な予測手法                                                   |
|                                                                      |
| １地点における地盤沈下の観測結果を時系列に整理し、直                 |
| 線あるいは曲線で近似させて、沈下量及び沈下時間を予測する方法である。 |
|                                                                      |
| 1.  圧密理論による予測手法                                           |
|                                                                      |
| 盛土の載荷によ                                                       |
| って生じる地盤の形状変化にともなう沈下及びゆるい砂層に生じる沈下を無 |
| 視し、盛土中央下の軟弱層の一次元圧密沈下のみを求めて全沈下量とする。 |
|                                                                      |
| すなわち、層区分された圧密層ごとに次式から一次圧                     |
| 密沈下量〔cm〕を求めた後、軟弱層全体について合計して全沈下量とする。 |
|                                                                      |
| (3-3-4)                                                              |
|                                                                      |
| ここに、                                                             |
|                                                                      |
| 　　　 ：一次圧密沈下量〔cm〕                                        |
|                                                                      |
| 　　　 ：圧密層の初期間隙比                                          |
|                                                                      |
| > 　　　                                                             |
| > ：圧密層の圧密後間隙比で、e-logP曲線に層中央                       |
| 深度のP0+ΔPを適用して求める。この場合、現場におけるe-logP曲線の推定  |
| は一般に困難なので、試験によるe-logP曲線から求めた値を用いてもよい。 |
|                                                                      |
| 　　　H ：圧密層の層厚〔cm〕                                         |
|                                                                      |
| である。                                                             |
|                                                                      |
| なお、正規圧密土からなる軟弱層の場合で、区分された圧密層ごとに圧     |
| 縮指数Cc又は体積圧縮係数*m~v~*〔m^2^/kN〕が求められている場合には、  |
| それぞれ次式によって圧密層毎の一次元圧密沈下量を求めることができる。 |
|                                                                      |
| (3-3-5)                                                              |
|                                                                      |
| (3-3-6)                                                              |
|                                                                      |
| ここに，                                                             |
|                                                                      |
| 　　　 ：一次圧密沈下量〔cm〕                                        |
|                                                                      |
| 　　　 ：盛土前土かぶり応力〔kN/m^2^〕                               |
|                                                                      |
| 　　　 ：盛土荷重による増加応力〔kN/m^2^〕                           |
|                                                                      |
| 　　　*H* ：圧密層の層厚〔cm〕                                       |
|                                                                      |
| である。                                                             |
|                                                                      |
| 25. 地盤沈下シミュレーション                                         |
|                                                                      |
| 平                                                                   |
| 面的な地盤沈下量の分布、あるいは、断面線上の地盤沈下量を予測する方法 |
| である。地下水流動解析モデルでは帯水層内の地下水頭変化量が算出される |
| 。また、断面二次元モデルあるいは三次元モデルを用いることで、粘土層内 |
| の水圧が計算される。帯水層の水頭変化量、あるいは、粘土層内の水圧（間 |
| 隙水圧）変化量より、圧密理論により地盤沈下量を解析することができる。 |
+----------------------------------------------------------------------+

第4章　河道特性調査 {#第4章-河道特性調査 .目次の見出し1}
===================

目　次 {#目-次-4 .目次の見出し1}
======

[第1節 総説 1](#_Toc382986756)

> [1．1 河道特性調査の目的と位置付け 1](#_Toc382986757)
>
> [1．2 河道特性調査の全体構成と本章の構成 2](#_Toc382986758)
>
> [1．3 河道特性調査の意義と活用 3](#_Toc317186242)
>
> [1．4 河道を構成する河川堤防に関わる各調査の相互関係
> 3](#_Toc382986760)

[第2節 河道特性調査に際しての基本的捉え方 6](#_Toc382986761)

> [2．1 河道の階層構造と類型区分 6](#_Toc382986762)
>
> [2．1．1 河道の階層構造 6](#_Toc382986763)
>
> [2．1．2 河道の類型区分 7](#_Toc382986764)
>
> [2．1．3 沖積河道のセグメント区分とセグメントの類型 9](#_Toc382986765)
>
> [2．2 河道構成材料の粒径分類と呼称 10](#_Toc382986766)
>
> [2．3 粒径集団に着目した土砂動態の捉え方 12](#_Toc382986767)
>
> [2．4 沖積河川の河床材料の捉え方 12](#_Toc382986768)
>
> [2．4．1 河道構成材料の大局的分類 12](#_Toc382986769)
>
> [2．4．2 代表粒径の設定 13](#_Toc382986770)
>
> [2．4．3 混合粒径河床材料の整理・分析について 15](#_Toc382986771)

[第3節 各時点の河道状況 16](#_Toc382986772)

> [3．1 河道の形状 16](#_Toc382986773)
>
> [3．1．1 河川の地形測量 16](#_Toc382986774)
>
> [3．1．2 河口における地形測量 17](#_Toc382986775)
>
> [3．2 構造物の設置状況 17](#_Toc382986776)
>
> [3．3 河床形態 17](#_Toc382986777)
>
> [3．3．1 中規模河床形態 17](#_Toc382986778)
>
> [3．3．2 小規模河床形態 19](#_Toc382986779)
>
> [3．3．3 局所洗掘 19](#_Toc382986780)
>
> [3．4 表面・表層の状態 19](#_Toc382986781)
>
> [3．4．1 総説 19](#_Toc382986782)
>
> [3．4．2 河床材料の調査 20](#_Toc382986783)
>
> [3．4．3 河岸・高水敷の構成材料調査 21](#_Toc318238908)
>
> [3．4．4 岩盤、軟岩など固結物・半固結物の調査 21](#_Toc382986785)
>
> [3．4．5 粘着性を有する材料の調査 21](#_Toc382986786)
>
> [3．4．6 河口の河床材料調査 22](#_Toc382986787)
>
> [3．4．7 植物繁茂状況の調査 23](#_Toc382986788)
>
> [3．4．8 その他堆積物等の調査 23](#_Toc382986789)
>
> [3．5 平常時の水理環境 23](#_Toc382986790)

[第4節 河道状況の時間的変化 24](#_Toc382986791)

> [4．1 時間的変化の捉え方 24](#_Toc382986792)
>
> [4．2 基本的な調査の進め方 25](#_Toc382986793)
>
> [4．3 着目する河道変化を起点にした調査の拡充 26](#_Toc382986794)
>
> [4．4 経年変化の整理 28](#_Toc382986795)
>
> [4．5 洪水による変化の調査 28](#_Toc382986796)
>
> [4．5．1 洪水前後の河道状況の比較による場合 28](#_Toc382986797)
>
> [4．5．2 洪水中の河床変化等の追跡による場合 29](#_Toc382986798)

[第5節 洪水の作用 30](#_Toc382986799)

> [5．1 基本水理量の整理 30](#_Toc382986800)
>
> [5．2 洪水流観測による特性把握 31](#_Toc382986801)

[第6節 土砂流送特性 32](#_Toc326048138)

> [6．1 調査の組立ての基本 32](#_Toc382986803)
>
> [6．2 基本水理量に基づく土砂流送形態の分析 33](#_Toc382986804)
>
> [6．3 土砂流送観測 34](#_Toc382986805)
>
> [6．3．1 総論 34](#_Toc382986806)
>
> [6．3．2 掃流土砂量調査 34](#_Toc382986807)
>
> [6．3．3 浮遊土砂量調査 35](#_Toc382986808)
>
> [6．3．4 水理量と土砂流送量観測結果の関係の整理 36](#_Toc382986809)
>
> [6．4 土砂収支による調査 36](#_Toc318238939)
>
> [6．5 総合観測による調査 36](#_Toc382986811)

[第7節 河道を取り巻く諸状況 37](#_Toc382986812)

> [7．1 流域・水系環境及びその変遷の整理 37](#_Toc382986813)
>
> [7．1．1 流域の概要 37](#_Toc382986814)
>
> [7．1．2 流域平面図と主要諸元 37](#_Toc382986815)
>
> [7．1．3 流域の地形･地質 37](#_Toc382986816)
>
> [7．1．4 水文特性 38](#_Toc382986817)
>
> [7．1．5 ダム・砂防堰堤等の整備状況 38](#_Toc382986818)
>
> [7．2 河川整備及びその他の河道状況の整理 39](#_Toc382986819)
>
> [7．2．1 主たる出水と河道計画・河川改修履歴 39](#_Toc382986820)
>
> [7．2．2 河道変遷 39](#_Toc382986821)
>
> [7．2．3 河道掘削・砂利採取 40](#_Toc382986822)
>
> [7．2．4 河道表層下の土層構造調査 40](#_Toc323196195)

[第8節 調査結果の取りまとめ及び包括分析 40](#_Toc382986824)

> [8．1 河道特性調査結果の整理 40](#_Toc382986825)
>
> [8．2 河道特性調査結果の包括分析 42](#_Toc318630902)

平成26年4月　版

7.  河道特性調査

    1.  []{#_Toc382986756 .anchor}総説

        1.  []{#_Toc382986757 .anchor}河道特性調査の目的と位置付け

＜考え方＞

+----------------------------------------------------------------------+
| 本章は、河道特性を                                                   |
| 構成する個々の要素の調査法と、それらの調査結果を組み合わせて対象河道 |
| の特性を総体的に理解するための枠組みについて述べる。ここで河道特性と |
| は、河川等の計画、設計及び維持管理等の適正な実施を図る上で把握してお |
| くべき「沖積河川の種々の姿の全体像」を指す。河道特性調査の全体構成と |
| その活用については本節の[1.2](http://www.yahoo.co.jp)に示している。  |
|                                                                      |
| 沖積河川の姿には多くの側面があり、河道特性を構                       |
| 成する諸要素は、個々にばらばらに存在しているのではなく、相互に密接に |
| 関連し合って河道という１つのシステムを形成している。このため、計画、 |
| 設計、維持管理等の検討を通じて河川へ様々な働きかけを行う際には、当該 |
| 目的に直接関係する機能や特性、場所に限定して河川を調べることに加えて |
| 、あらかじめ対象河川の河道特性を把握し理解しておくことが重要である。 |
|                                                                      |
| 通常、河道特性の構成要素としては、                                   |
| 河道自体及びそれと直接的関わりを持つ事象等が対象となる。本章において |
| は、河道特性調査を幅広く捉え、流域や水系環境など沖積河川を取り巻く諸 |
| 状況とその変遷も調査対象に含めて考えていく。また、河道形状や河床材料 |
| など河道に関する基本事項の調査手法についても本章で一体的に説明する。 |
|                                                                      |
| 上述の河道特性調査の性格から明らかなように、本章で記述する調査       |
| は対象河川の状況に関する基盤的な情報を得るものであり、その内容は、図 |
| 4-1-1に示すとおり、他章の調査と密接な関係を持つ。本章の調査内容を起  |
| 点とした調査体系の全体像も考慮しつつ、調査編で扱う河道に関わる諸調査 |
| を有機的に連携させながら適切かつ効率的に進めていくことが重要である。 |
|                                                                      |
| ※矢印は各章間での情報の受け渡しを表す                                |
|                                                                      |
| 1.  河道特性調査と調査編各章との関係の俯瞰図                         |
+----------------------------------------------------------------------+

＜参考となる資料＞

河道特性の概念、その河川技術への体系的展開及び河道特性調査の基本論については、下記の資料が参考となる。

1.  山本晃一，(財)河川環境管理財団企画：沖積河川－構造と動態－，技報堂出版，2010.

    1.  []{#_Toc382986758 .anchor}河道特性調査の全体構成と本章の構成

＜考え方＞

+----------------------------------------------------------------------+
| 図4-1-2に、河道特性調査の全体構成と本章の構成を示す。                |
|                                                                      |
| まず[第2節](h                                                        |
| ttp://www.yahoo.co.jp)において、本章の調査に際して押さえておくべき共 |
| 通的事項を述べる。この節は、たとえば「[2.1](http://www.yahoo.co.jp)  |
| 河道の階層構造と類型区分」が、[第11章](http://www.yahoo.co.jp)       |
| 河川環境調査                                                         |
| における河道形状に関わる河川環境要素                                 |
| の抽出にも適用されるなど、他章の調査における道具ともなる内容を持つ。 |
|                                                                      |
| 第3～7節が河道                                                       |
| 特性調査を構成する個々の事項の説明であり、したがって、この部分が河道 |
| 特性調査の全体構成に当たる。その内容は、各時点の河道状況に関する調査 |
| （[第3節](http://www.yahoo.co.jp)）、河道状況の時間的変化に関する調  |
| 査（[第4節](http://www.yahoo.co.jp)）、河道の形成や変化の営力である  |
| 洪水の作用に関わる調査（[第5節](http://www.yahoo.co.jp)）、河道のシ  |
| ステムにおいて重要な役割を担う土砂流送特性に関する調査（[第6節](http |
| ://www.yahoo.co.jp)）、河道を取り巻く諸状況に関する調査（[第7節](htt |
| p://www.yahoo.co.jp)）からなる。これらの節は、調査内容という面で相互 |
| に密接な関係を持ち、また互いの調査結果を利用する関係ともなっている。 |
|                                                                      |
| [第8節](http://www.yahoo.co.jp)は、第3～7節に述べた調査の            |
| 結果を河道に関する基盤的情報としての取りまとめと蓄積について述べ、ま |
| た得られた調査結果の横断的、包括的な分析について記述したものである。 |
|                                                                      |
| 2.  河道特性調査の全体構成と本章の構成                               |
+----------------------------------------------------------------------+

1.  []{#_Toc317186242 .anchor}河道特性調査の意義と活用

＜考え方＞

+----------------------------------------------------------------------+
| 河道特性調査は、河道                                                 |
| の基本的な性質と特性を様々な側面について総体的に把握するものであり、 |
|                                                                      |
| 1)  流下能力確保などのための河道計画、                               |
|                                                                      |
| 2)  洪水流に対する氾濫の危険性や堤防の安全性の評価、                 |
|                                                                      |
| 3)  洪水を受けた際の河道の挙動と安定性の評価、                       |
|                                                                      |
| 4)  種々の河道変化を見据えた河道管理の検討、                         |
|                                                                      |
| 5)                                                                   |
|   河道の動きや土砂流送と関わりの深い河川構造物の設計とその維持管理、 |
|                                                                      |
| 6)  河道の物理環境や土砂流送の制御を基軸にした河川環境の保全と管理、 |
|                                                                      |
| 7)  流域・水系環境の変化を踏まえた河道管理、                         |
|                                                                      |
| 8)  これらの検討を包括した治水                                       |
| ･利水・環境保全・維持管理にわたる統合的視点からの河道の在り方の検討  |
|                                                                      |
| など、河                                                             |
| 川等の計画、設計及び維持管理等の適正な実施を図るための種々の技術検討 |
| を行う際に用意しておくべき共通的、基盤的な情報を提供するものである。 |
|                                                                      |
| それだけに、河道特性調査の実施と、取りま                             |
| とめは、一貫した方針の下、管理対象とする河川についてできるかぎり悉皆 |
| 的に実施し、統一的な方式で取りまとめ、蓄積していくことが重要であり、 |
| そのために必要な事項を本章の[8.1](http://www.yahoo.co.jp)に述べる。  |
+----------------------------------------------------------------------+

1.  []{#_Toc382986760
    .anchor}河道を構成する河川堤防に関わる各調査の相互関係

＜考え方＞

+----------------------------------------------------------------------+
| 河川堤防は、河川に関わる多くの事象に関わりを有                       |
| しており、調査編における位置付けを理解しておくことは重要である。そこ |
| で、河川堤防に関わる各調査の相互関係についてここでまとめて記載する。 |
|                                                                      |
| 1.  河川堤防に関わる諸調査間の相互関係を理解することの重要性         |
|                                                                      |
| 河川堤防は河道を構成する主構成要素の1つ                              |
| ではあるものの、原則として盛土により築造され、通常、維持管理が高頻度 |
| でなされる構造物であり、営力により変動することが常態である河床や河岸 |
| とは性質を異にする。このため、本章の[第3節](http://www.yahoo.co.jp)  |
| 各時点の河道状況                                                     |
| 以降において河川堤防を直                                             |
| 接的に取り上げることはしていない。しかし、河川堤防は、河道を構成し、 |
| 洪水氾濫からの堤内地防御において直接的な役割を担う河川構造物であり、 |
| その本来的成り立ちから、河川に関わる多くの事象に関わりを有している。 |
|                                                                      |
| このため、河川砂防技術基準全般（計画編、調査編、設計編、維持         |
| 管理編）において河川堤防に関係する多くの調査・検討事項が存在し、調査 |
| 編も、直接・間接を含めると数多くの河川堤防に関係する調査内容を含む。 |
|                                                                      |
| このような河川堤防の技術的特徴を踏まえる                             |
| と、河川堤防に関係する個々の、あるいは各分野（地盤工学、水工学、地形 |
| 学など）の調査結果の活用を図ることはもちろん、各調査の位置付けや相互 |
| 関係をよく理解し、それらを有機的につなげ、河川堤防の本来的、総体的役 |
| 割に立脚した総合技術判断に結び付けるという基本スタンスが重要となる。 |
|                                                                      |
| 調査編は、[第1章](http://www.yahoo.co.jp) 総論                       |
| に                                                                   |
| 記述しているとおり、「河川等の計画、設計及び維持管理等の適正な実施」 |
| のために、他編（計画編、設計編、維持管理編）を介して、あるいは直接的 |
| に生じる必要性に応じて、適切な技術手法等を提供する役割を負っており、 |
| 河川堤防に関係する多様な内容を含む（[第1章](http://www.yahoo.co.jp)  |
| 総論 の表1-3-1 参照）。                                              |
|                                                                      |
| こうしたことから、河川堤                                             |
| 防に関して、ここで、調査内容の相互関係について述べておくものである。 |
|                                                                      |
| 2.  河川堤防に関わる諸事象                                           |
|                                                                      |
| 河川堤防は                                                           |
| 、堤体と基盤を主構成要素とし、堤防近くの河道、堤防と一体的に設置され |
| る構造物（護岸、水制、水門、樋門・樋管など）も構成要素となる。また、 |
| 基盤と空間的に連続する堤内地も、必要に応じて関連要素に含めて考える。 |
|                                                                      |
| 河川堤防は、場合によっては堤体－基盤－河道の相互作用も内包           |
| しつつ、種々の機構及びプロセスの下、所定の機能を発揮し、また変化・変 |
| 状を起こし、更に過度の外力を受けた場合に破壊に至ることもある。機構及 |
| びプロセスの代表的類型としては、地盤工学、水工学それぞれにより分析さ |
| れるものがあり、一般に、浸透や地震動による変化・変状・破壊は前者によ |
| り、浸食による変化・変状・破壊は後者により扱われる。ただし、このよう |
| な類型ごとのアプローチだけでは実現象を十分には分析できず、学際的なア |
| プローチの充実が望まれる境界領域的現象が重要となる場合も考えられる。 |
|                                                                      |
| 河川堤防の機能発揮にしても、変化･変状・破壊に                        |
| しても、それらは堤防自体の状況と堤防に対する諸作用等との関わりの中で |
| 決まってくる。したがって、調査の主なターゲットもそれに対応したものと |
| なる。堤防の状況は諸元、特性、構造、状態（表面、内部）などで表される |
| 。堤防の状況に加えて、河道（堤外地）や周辺の堤内地の状況が関係してく |
| る場合がある。一方、堤防に関わる作用や事象等には、以下に示すように様 |
| 々な種類のものがあり、中には堤防と双方向作用の関係を持つものもある。 |
|                                                                      |
| a.  洪水                                                             |
|                                                                      |
| > 洪水は、水位、流速、流水によるせん断力、水圧などの形               |
| で、堤防に対する外力として作用し、作用継続時間と相まって、場合によっ |
| ては変更、更には破壊の原因となる。所定の洪水の作用に耐えることが、堤 |
| 防が持つべき最も重要な機能である（河川管理施設等構造令第18条参照）。 |
| >                                                                    |
| > 一方、堤防は、堤内地を洪水氾濫から防ぐという本来的機能ゆえに、     |
| 堤防がない場合に比較して洪水流を制御する。この制御の強さが大きくなれ |
| ば、一般に、堤防に作用する洪水の作用も大きくなる。この点において、洪 |
| 水と堤防は双方向的に作用し合う関係にある。このことは、たとえば、堤間 |
| 幅と洪水時の水理量との関係という「川幅」の切り口から、更には堤防法線 |
| と洪水流との関係という「平面形」の切り口からの検討につながっていく。 |
|                                                                      |
| b.  地下水の流れ                                                     |
|                                                                      |
| > 周辺の地下水の流れが、堤防の水分                                   |
| 条件を規定する1要素になる可能性がある。逆に、地盤対策などが施された  |
| 場合、対策工法によっては堤防が地下水の流れに影響を与えることもある。 |
|                                                                      |
| c.  地震動、地殻変動                                                 |
|                                                                      |
| > 外的作用として堤防に影響する。地震動に                             |
| 対する安全性は、条件によって、堤防が持つべき重要な機能の１つとなる。 |
|                                                                      |
| d.  河床変動                                                         |
|                                                                      |
| > 洪水流や氾濫流を介して土砂流送が起こり、それがしば                 |
| しば地形変化を生じさせる。その地形変化が堤防の近傍に生じる場合には、 |
| 堤防に対する外的作用となる。上記ａ）と合わせると、ここにおいて、堤防 |
| →洪水流→土砂流送→地形変化→堤防への外的作用という一連の相互作用系とい |
| う視点の必要性が示唆される。そして、この視点は、河川堤防が洪水の作用 |
| を介して河道形成を一定程度支配し、そのことがひいては、物理環境形成を |
| 通じて河川環境形成とも関わりを持つという捉え方につながり得る（第11章 |
| > 河川環境調査 の[1.4](http://www.yahoo.co.jp) を参照）。            |
|                                                                      |
| e.  時間の経過                                                       |
|                                                                      |
| > 外的作用には当たらないが、種々の堤防に内包されている変化・変状     |
| 等の機構のうち、多くのものは、時間の経過に従って発揮される。代表的な |
| 事例として、堤体の荷重による沈下及びそれに付随する事象が挙げられる。 |
|                                                                      |
| f.  生物的作用                                                       |
|                                                                      |
| > 堤防表面に生育する植物は、葉茎や根毛による被覆作                   |
| 用により降雨や流水による表面浸食からの防護機能をもたらす一方、時間経 |
| 過とともに増大すると考えられる根毛層の状態によっては、堤防機能の減耗 |
| につながるとの懸念も考えられる。動物については、モグラが代表的な考慮 |
| 対象となる。これら生物的作用は、逆に、堤体の土質等の影響を受けると考 |
| えられ、この点で、生物的作用と堤防は双方向的関係にあると考えられる。 |
|                                                                      |
| g.  気象など                                                         |
|                                                                      |
| > 降水、日射、気温などの気象条件、河口近くの堤防には影響する潮       |
| 位などの海象条件、平水位の状況、更に広域地盤沈下などは、堤防に対して |
| の外的作用あるいは環境条件と捉えることができる。このうち、たとえば、 |
| 降水や平水位、潮位は通常時の堤防内の水分状況を規定し、洪水発生と同期 |
| した降雨は、浸透に起因する堤防破壊や変状を引き起こす外力を規定する有 |
| 力なファクターとなる。日射の状況はｆ）における植物の生育に影響する。 |
|                                                                      |
| h.  堤内地の状況                                                     |
|                                                                      |
| > 堤内地の内水や流下してきた洪水氾濫流が、たと                       |
| えば支川や本川の堤防に遮られる状況となり、堤内地側からの浸透や浸食作 |
| 用が生じることも考えられる。そのような場合には、堤内地に生じる浸水、 |
| 氾濫の状況は堤防の安定に直接関連する検討事項になる。また、堤内地の土 |
| 地利用の状況は、パイピングや浸透に直接的に影響を及ぼすことがある。堤 |
| 内地の状況は、堤防の機能の様々な面に関係を持つので留意が必要である。 |
|                                                                      |
| i.  人間活動、社会的インパクト                                       |
|                                                                      |
| > 河川の利用は、その形態によっては堤防に影響を及ぼすことがある。     |
|                                                                      |
| これらの作用等は互いに独立                                           |
| しているとは限らず、ｄ）についてａ）との関連を説明したように、相互に |
| 関連しながら作用することがあり、更には堤防との相互作用も交えつつ、堤 |
| 防の機能発揮や変化･変状・破壊に関わる様々な現象が生じることがある。  |
|                                                                      |
| 堤防は、堤防の強化、補修、維持管理等によっても直接改変を受           |
| け、河川改修等の堤防周辺の改変からも影響を受ける。これらは、河川等の |
| 計画、設計及び維持管理等の適正な実施という目的に従って必要な技術的検 |
| 討を経て実施されるものであり、上記のａ）～ｉ）とは「作用」の性格が根 |
| 本的に異なるが、その履歴を把握しておくべきことについては同様である。 |
|                                                                      |
| 3.  調査編の各調査との関係                                           |
|                                                                      |
| [第1章](http://www.yahoo.co.jp) 総論 表1-3-1の堤防の欄及び上記       |
| ２）より、河川堤防に関連する調査が、                                 |
| 調査編においても多岐に及んでいることが理解される。堤防の諸元、特性、 |
| 構造、状態（表面、内部）については、土質・地質的側面での調査を中心に |
| 第15章 土質地質調査の[第2節](http://www.yahoo.co.jp)                 |
| 河川堤防の土質地質調査、[第3節](http://www.yahoo.co.jp)              |
| 河川構造物の土質・地質調査                                           |
| に詳述されており、諸元（形状）の調査は本章の                         |
| [第3節](http://www.yahoo.co.jp) 各時点の河道状況 や                  |
| [第22章](http://www.yahoo.co.jp) 測量・計測                          |
| で触れられている。基盤及び周辺の                                     |
| 堤内地（氾濫原）や河道（堤外地）の地形・地質的特性については、第15章 |
| 土質地調査 [第2節](http://www.yahoo.co.jp) 河川堤防の土質地質調査    |
| と本章 [第2節](http://www.yahoo.co.jp)                               |
| 河道特性調査に際しての基本的捉え方 、[第3節](http://www.yahoo.co.jp) |
| 各時点の河道状況 で、その捉え方や調査法が述べられている。            |
|                                                                      |
| 上記のａ）～ｉ）の中で、ｂ）は第2章                                  |
| 水文・水理観測の[第6節](http://www.yahoo.co.jp) 地下水観測、第3章    |
| 水文解析の[第3節](http://www.yahoo.co.jp)                            |
| 地下水解析と関連性を持ち、ａ）とｄ）には、豪雨からの洪水生起と河道を |
| 流下する洪水流に関する調査手法を示す[第2章](http://www.yahoo.co.jp)  |
| 水文・水理観測、[第3章](http://www.yahoo.co.jp)                      |
| 水文解析、[第5章](http://www.yahoo.co.jp)                            |
| 河川に                                                               |
| おける洪水流の水理解析が、また、洪水流による土砂流送と河床変動を扱う |
| [第6章](http://www.yahoo.co.jp)                                      |
| 河床変動、河床材料変化及び土砂流送の解析 が密接に関係する。          |
|                                                                      |
| 洪水流の作用を含む河道特性と堤防との間の                             |
| 相互作用を検討するに際しては、本章の[第5節](http://www.yahoo.co.jp)  |
| 洪水の作用、[第6節](http://www.yahoo.co.jp) 土砂流送特性             |
| の内容が役立つ。                                                     |
|                                                                      |
| h）に関しては [第7章](http://www.yahoo.co.jp) 浸水解析 が関係する。  |
|                                                                      |
| さらにg）に関係する調査の多くには [第2章](http://www.yahoo.co.jp)    |
| 水文・水理観測 の内容が役立つ。                                      |
|                                                                      |
| i）は 第11章 河川環境調査 [第14節](http://www.yahoo.co.jp/)          |
| 河川空間利用実態調査 と関わりを持つ。                                |
|                                                                      |
| 堤防の強化、補修、維                                                 |
| 持管理等については、既往の履歴を把握し蓄積保存するという点で、本章の |
| [第7節](http://www.yahoo.co.jp) 河道を取り巻く諸状況 と              |
| [第23章](http://www.yahoo.co.jp) 調査結果の保存・活用 が関係する。   |
|                                                                      |
| 災害調査は河川堤防の技術に関しても重要な知見を                       |
| 提供し、また河川堤防の復旧等は重要な技術的判断の場であるので、第10章 |
| 災害調査の[2.1](http://www.yahoo.co.jp)と                            |
| [第15章](http://www.yahoo.co.jp)                                     |
| 土質地質調査の[2.3](http://www.yahoo.co.jp)                          |
| は河川堤防とも密接に関係する。                                       |
|                                                                      |
| 調査編以外に、河                                                     |
| 川砂防技術基準維持管理編においては、基本データの収集、河川巡視、点検 |
| 等による状態把握の内容が示されている。こうした調査の結果を踏まえ、必 |
| 要に応じて、堤防の機能発揮に関わる診断、評価、照査、起こり得る事象の |
| 想定を所定の手法に基づき行い、技術的吟味を経て判断し、計画、設計、維 |
| 持管理、水防・危機管理等の適正な実施につなげていくことが重要である。 |
|                                                                      |
| 以上に示してきたように、河川堤防に関する調査は多                     |
| 岐にわたり、それらが適切に組み合わされて、河川堤防に関する総体的な技 |
| 術的判断につながっていく。したがって、個別分野の調査を適切に実施し積 |
| み上げることはもちろん、河川堤防に関わる各調査の位置付けと相互の関係 |
| を理解しながら、各調査を有機的に連携させること、こうしたことの前提と |
| して、河川堤防に関係する調査を十分幅広く捉えておくことが重要である。 |
|                                                                      |
| その際には、種々の事象及び要素が相互に影響し合い、堤防と双方         |
| 向的に影響し合う関係を持つ場合もあることから、河川堤防に関わる技術体 |
| 系を、河道特性を扱う場合と同様にシステム的に捉えることが重要である。 |
+----------------------------------------------------------------------+

1.  []{#_Toc382986761 .anchor}河道特性調査に際しての基本的捉え方

    1.  []{#_Toc382986762 .anchor}河道の階層構造と類型区分

        1.  []{#_Toc382986763 .anchor}河道の階層構造

＜考え方＞

+----------------------------------------------------------------------+
| 河道は、以下の階層構造を持つとする考え方がある。                     |
|                                                                      |
| -   河道を空間的スケール及び形成・変化に要する時間スケールが         |
| 異なる種々の構成要素（たとえば表4-2-1の類型）の集合体として捉える。  |
|                                                                      |
| -   その集合体は代表スケールがオーダー単位で異なる階層に区分される。 |
|                                                                      |
| -   下位階層の構                                                     |
| 成要素群の形成・変化に対して、上位階層は所与の条件として取り扱える。 |
|                                                                      |
| 調査                                                                 |
| 編では、この考えに基づいて、種々の類型をこの階層構造の下に設定する。 |
|                                                                      |
| 河川に関す                                                           |
| る調査の中でも、「場」に着目した調査を行う際には、様々な調査結果を共 |
| 通的に活用できるようにするため、あるいは当該調査の位置付けが容易に理 |
| 解されるように、対象とする場の類型を明確にしておくことが有用である。 |
|                                                                      |
| 一                                                                   |
| 般に場の類型は、階層が異なれば、また、それが属する1つ上位の階層の類  |
| 型によって、類型区分の構成も異なってくる。このことから、場の類型区分 |
| に際しては、河道の階層構造をあらかじめ考慮しておくことが必要である。 |
|                                                                      |
| なお、同一階層の場であっても、                                       |
| 着目した代表的事象により類型の呼称が異なる場合がある（たとえば、本節 |
| [2.1.2](http://www.yahoo.co.jp)に後述する河口域と汽水域）。          |
| 同様に、着目した事象によってそれを捉えるのに適した代表長が異なるため |
| 、同一階層内でも異なる類型区分が採用される場合がある（たとえば、本節 |
| [2.1.                                                                |
| 2](http://www.yahoo.co.jp)に後述する沖積河道区間とセグメント区分）。 |
|                                                                      |
| 3.  河道の階層構造の説明                                             |
|                                                                      |
| ![](media/image134.emf)                                              |
+----------------------------------------------------------------------+

1.  []{#_Toc382986764 .anchor}河道の類型区分

＜標　準＞

+----------------------------------------------------------------------+
| 調査編では、河道の階層（表4-2-1参照）のうち大規模スケールにつ        |
| いて、以下の類型区分を設定し、これを共通して用いることを標準とする。 |
|                                                                      |
| 1.  渓流区間                                                         |
|                                                                      |
|     山地河道区間                                                     |
|                                                                      |
|     沖積河道区間（更にセグメント区分を行う）                         |
|                                                                      |
|     河口域                                                           |
|                                                                      |
|     汽水域                                                           |
|                                                                      |
| なお３）の沖積河道区間については、同一階層の区分                     |
| との位置付けで、さらにセグメント区分を行う。セグメント区分については |
| 本節                                                                 |
| [2.1.3](http:                                                        |
| //www.yahoo.co.jp)に記載する。１）～５）の定義等は次のとおりである。 |
|                                                                      |
| 1.  渓流区間                                                         |
|                                                                      |
| 山地部を流下する河川で、生                                           |
| 産され当該区間に供給された土砂が土石流など高濃度・集合的な形態で移動 |
| が生じ得る河床縦断勾配が大きい区間である。あるいは、土石流区域と、掃 |
| 流区域のうち山腹・沢からの土砂供給の影響が卓越する区間の河川である。 |
|                                                                      |
| 4.  山地河道区間                                                     |
|                                                                      |
| 山地部を流下する河川で、生産され当該区間に供給された土砂が、土石流な |
| ど高濃度・集合的な移動によってではなく、出水時に掃流・浮遊形態で流送 |
| される場であり、それが河床に堆積する状況となる。河岸の一定割合が山体 |
| を構成する岩により、又は支渓流や斜面崩壊により供給された巨岩によって |
| 構成され、それによって河岸位置や川幅が規定されている区間である。本節 |
| [2.1.3](http://www.yahoo.co.jp)で述べる                              |
| ように、山地河道区間と渓流区間とを併せてセグメント分類Mと総称する。  |
|                                                                      |
| 5.  沖積河道区間                                                     |
|                                                                      |
| 沖積平野、谷底平野、盆地を貫流する河道区間である。ここで、谷底平野   |
| とは、河川の流路幅に比べて数倍以上の幅を有する谷間に河川の運搬した砂 |
| 礫で形成された低地である。これらの河道区間は、堤防や谷壁による洪水流 |
| の流下幅の制約や狭窄部での水位せき上げによる湛水など洪水流の流下特性 |
| には差異があるが、河岸が河成の堆積物で構成されており、河岸位置や川幅 |
| がその浸食・堆積作用のバランスの下で変動・調節される区間である。本節 |
| [2.1.3](http://www.                                                  |
| yahoo.co.jp)で述べるように、セグメント区分に応じて、河床勾配、河床材 |
| 料、川幅などの河道諸量が同様の幾つかのグループに分けることができる。 |
|                                                                      |
| 6.  河口域                                                           |
|                                                                      |
| 地                                                                   |
| 形形成に波浪、潮位、河川流の相互作用が卓越する河道～海岸領域である。 |
| 河口域のうち河道側は、河口砂州のフラッシュ又は潮位変動に応じて出水時 |
| の河川水位にせき上げ・低下背水が現れる区間まで、海岸側は、岸沖方向で |
| は河口テラスの舌状に伸びた最遠点（移動限界水深に相当する等高線が目安 |
| ）まで、汀線方向には河口テラスの幅、また、河口砂州がある場合には砂州 |
| のフラッシュ後、砂州再形成のための底質供給源となる範囲を目安とする。 |
|                                                                      |
| 7.  汽水域                                                           |
|                                                                      |
| 潮位変動に                                                           |
| よる塩水浸入によって塩分濃度の変化が生じる河道区間、及び河口からの淡 |
| 水の流出によって塩分濃度の変化が顕在化している海岸側の領域である。４ |
| ）の河口域や感潮区間と範囲が重なる場合が多いが、平時における水位変動 |
| 、主に塩分濃度などの水質及び生物生息環境の観点を重視した区分である。 |
|                                                                      |
| 本章では、これらのうち主として３）                                   |
| 、４）を扱い、一部２）もカバーする。５）は３）、４）に含まれ、本章で |
| は汽水環境を取り上げることはしないので、５）を直接の対象とはしていな |
| い。調査編の各章とこの類型区分との関係はおおむね以下のとおりである。 |
|                                                                      |
| 1.  渓流区間：[第17章](http://www.yahoo.co.jp)                       |
|                                                                      |
|     山地河道区間：[第4章](http://www.yahoo.co.j                      |
| p)、[第5章](http://www.yahoo.co.jp)、[第6章](http://www.yahoo.co.jp) |
| 、[第11章](http://www.yahoo.co.jp)、[第17章](http://www.yahoo.co.jp) |
|                                                                      |
|     沖積河                                                           |
| 道：[第4章](http://www.yahoo.co.jp)、[第5章](http://www.yahoo.co.jp  |
| )、[第6章](http://www.yahoo.co.jp)、[第11章](http://www.yahoo.co.jp) |
|                                                                      |
|     河口域：[第4章](http://www.yahoo.co.jp)                          |
| 、[第14章](http://www.yahoo.co.jp)、[第21章](http://www.yahoo.co.jp) |
|                                                                      |
|     汽水域：[第14章](http://www.yahoo.co.jp)                         |
|                                                                      |
| ※な                                                                  |
| お、[第16章](http://www.yahoo.co.jp)では、１）～４）を包含している。 |
+----------------------------------------------------------------------+

＜推　奨＞

+----------------------------------------------------------------------+
| 以上に示した大規模スケールで区分されたそれぞれの類型の               |
| 下に、中規模、更には小規模、微小規模の類型区分がなされることになる。 |
|                                                                      |
| 河道に関わる調査を行う際には、河川環                                 |
| 境が主対象となる場合も含め、表4-2-1に示す階層構造を考慮しつつ、中規  |
| 模以下の類型区分についても必要な共通化を図れるよう、場の類型の記述を |
| 適切に行い、蓄積する情報に一貫した方法で表記していくことが望ましい。 |
+----------------------------------------------------------------------+

1.  []{#_Toc382986765 .anchor}沖積河道のセグメント区分とセグメントの類型

＜標　準＞

+----------------------------------------------------------------------+
| 河道特性調査に際しては、                                             |
| 本節の[2.1.2](http://www.yahoo.co.jp)に示した沖積河道区間について、  |
|                                                                      |
| 1)  河床勾配がほ                                                     |
| ぼ同じで、似たような特徴を持つ区間ごとに河道を縦断的に区分すること、 |
|                                                                      |
| 2)  この区分をセグメント区分と呼び、区分された各河道区間に「セグ     |
| メント－◎△」のようにセグメントを冠した識別のための呼称を与えること、 |
|                                                                      |
| 3)  この区分を整理･分析において活用すること                          |
|                                                                      |
| を標準とする。                                                       |
|                                                                      |
| なお、セグメント区分は、地形                                         |
| 区分のために行うのではなく、あくまで、河川等の計画・設計・維持管理等 |
| を目的とした河道特性把握のための合理的な整理法として行うものである。 |
+----------------------------------------------------------------------+

＜推　奨＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------
  複数の河川を横断する視点から吟味するため、河川ごとに区分された各セグメントについて類型化を行い、各セグメントが有する一般的特徴と個別性を整理しておくことが望ましい。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜例　示＞

+----------------------------------------------------------------------+
| 区                                                                   |
| 分された各セグメントの類型化については、以下に示す代表的手法がある。 |
|                                                                      |
| 河川におけるセグメントの数は、河川によって、また、河川をセグメント区 |
| 分する目的（河道特性の違いを細かく見れば見るほどセグメントの数は多く |
| なる）によって異なるが、比較的単純な河川の場合（山間部から堆積空間に |
| 出て、そのまま海に流れる河川で、大きな支川が入り込まない河川）には、 |
| 山間部を出てからは、次の３つの類型のセグメントに分かれることが多い。 |
|                                                                      |
| 扇状地を持つ河川の場合は、扇状地を流                                 |
| 下する河道区間に当たるセグメント類型１、その下流で粗砂あるいは中砂を |
| 河床材料に持つ自然堤防帯あるいはデルタに相当するセグメント類型２－２ |
| 、その下流で細砂～シルトを河床材料に持つセグメント３類型に分かれる。 |
|                                                                      |
| 扇状地を持たない河川では、山                                         |
| 間部から出た河川は、直接自然堤防帯に入るが、河床材料が砂利であるセグ |
| メント類型2-1、その下流で粗砂・中砂を河床材料に持つセグメント類型2-  |
| 2、その下流で細砂～シルトを河床材料に持つセグメント類型3に分かれる。 |
|                                                                      |
| なお、扇状地を持たない河川の中には、粒径が1cm以下の河床              |
| 材料からなるセグメントが優占的に存在する場合がある（風化花崗岩を流域 |
| に持つ河川など）。これはセグメント類型2-2の中に含まれるものとする。  |
|                                                                      |
| また、下                                                             |
| 流における堆積空間の有無や大きさによって、セグメント類型1で終わる（  |
| 海に到達する）、セグメント類型2-1で終わる河川もあることに留意する。  |
|                                                                      |
| 表4-2-2には上記のセグメント類型と地形区分との関                      |
| 係、また各セグメント類型と河床材料、河岸の構成材料、勾配、蛇行速度、 |
| 河岸侵食程度、水路の深さとの概略の関係を示す。なお、本表では、セグメ |
| ント類型1、2-1、2-2、3に加えて、渓流区間と山地河道区間を包含する区間 |
| をセグメント類型Ｍと総称し、河川水系全体を俯瞰できるようにしている。 |
|                                                                      |
| 対象とする河川につ                                                   |
| いてセグメント区分を行った結果、得られた各セグメントが上記の類型のい |
| ずれかに当てはまる場合は、類型名をそのまま当該セグメントの呼称に用い |
| 、セグメント区分とその類型化の結果が一括して把握できる方式としてもよ |
| い。たとえば、あるセグメントがセグメント類型2-2に属すると判断できる  |
| 場合、そのセグメントを「セグメント2-2」と呼称するという方式である。  |
|                                                                      |
| 区分されたセグメントは、表4-2-2に示すように、地形区分と良い          |
| 対応を示す場合が多い。ただし、セグメント区分は、前述のように、地形区 |
| 分のために行うのではなく、あくまで、河川整備や管理を目的とした河道特 |
| 性把握のための合理的な整理法として行うことが本旨である。このことから |
| 、必要に応じて、地形区分にこだわらず、適切な区分を行う。たとえば、扇 |
| 状地河川において、セグメント1の類型を持つセグメントを２つあるいは３  |
| つの小セグメントに分けることが必要な場合もある。また、セグメントＭに |
| ついては、その中を複数のセグメントに区分すべき場合がほとんどである。 |
|                                                                      |
| 4.  沖積河道区間についての代表的なセグメント類型とその特徴           |
|                                                                      |
| ![](media/image135.emf){width="6.063888888888889in"                  |
| height="4.228472222222222in"}                                        |
|                                                                      |
| > ※                                                                  |
| セグメントＭは、沖積河道区間には当たらず、渓流区間と山地河道区間を包 |
| 含するものであるが、河川水系全の状況を俯瞰するため、付け加えている。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

沖積河道区間のセグメント区分及び表4-2-2の詳細については、下記の資料が参考となる。

1.  山本晃一，(財)河川環境管理財団企画：沖積河川－構造と動態－，技報堂出版，2010.

    1.  []{#_Toc382986766 .anchor}河道構成材料の粒径分類と呼称

＜標　準＞

+----------------------------------------------------------------------+
| 調査編においては、河道                                               |
| 構成材料の粒径分類と呼称については、表4-2-3に従うことを標準とする。  |
|                                                                      |
| 表中で、左から二列目における中礫と細礫の境界                         |
| （4mm）と三列目における中礫と小礫の境界（16mm）だけがずれている。こ  |
| のため、中礫の定義を厳密にする必要がある場合は、どちらに従った中礫の |
| 定義かが判別できるように「中礫（□mm～）」と記すことを、標準とする。  |
|                                                                      |
| また、幾つかの粒径分類を束ねて表現する呼                             |
| 称のうち、表4-2-3にないものについては、以下に従うことを標準とする。  |
|                                                                      |
| > 「礫」                                                             |
| > ：粒径が2mm以上の材料の総称。し                                    |
| たがって、「礫」という場合、細礫あるいは小礫から巨礫までを含み得る。 |
| >                                                                    |
| > 「石礫」：上記に定義される「                                       |
| 礫」の範疇にあり、かつ、大礫以上の粒径分類を有意に含む幅広い粒径で構 |
| 成される材料。特に、大礫以上の粒径範囲の存在が河床変動に支配的な影響 |
| を及ぼし得る粒径分類であることを明示する場合に用いられる呼称である。 |
| >                                                                    |
| > 「砂礫」：上記に定義される「礫」と砂からなる材料                   |
| 。ただし実質上、砂から中礫までを含む材料の総称に使われることが多い。 |
|                                                                      |
| 5.  粒径の分類と呼称                                                 |
|                                                                      |
| ![](media/image136.png){width="5.947916666666667in"                  |
| height="3.8625in"}                                                   |
+----------------------------------------------------------------------+

＜参考となる資料＞

表4-2-3の作成に当たっての参考文献は下記のとおりである。

1.  河村三郎：土砂水理学１，p.3，森北出版，1982.

```{=html}
<!-- -->
```
151. Cummins, K．W．：An evaluation of some techniques for the
     collection and analysis of benthic samples with special emphasis on
     lotic water，American Midnald Naturalist，67，pp.477-504，1962.

＜推　奨＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  河道を、河川工学的視点から調査する場合と、生物の生息・生育場の物理環境という視点から調べる場合とで、異なる粒径分類・呼称が用いられてしまうと、同じ河道を調査したにもかかわらず、互いの結果の比較や統合が困難になり、河道特性の解釈や分析に不効率を招くおそれがあるので、極力同じ粒径分類・呼称を採用することが望ましい。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

1.  []{#_Toc382986767 .anchor}粒径集団に着目した土砂動態の捉え方

＜推　奨＞

+----------------------------------------------------------------------+
| 河道特性調査においては、広域的に土砂動態を捉える                     |
| ための技術的枠組みの１つである「粒径集団」、「有効粒径集団」、「混合 |
| 型」、「通過型」の概念を必要に応じて具体化して用いることが望ましい。 |
|                                                                      |
| これらの定義と技術的意味については、第16章                           |
| 総合的な土砂管理のための調査 第2節 調査の基本的組立て方              |
| [2.2.1](http://www.yahoo.co.jp/)土砂動態の捉え方                     |
| の沖積河川についての例示の記述内容を参照のこと。                     |
+----------------------------------------------------------------------+

2.  []{#_Toc382986768 .anchor}沖積河川の河床材料の捉え方

    1.  []{#_Toc382986769 .anchor}河道構成材料の大局的分類

＜推　奨＞

+----------------------------------------------------------------------+
| 河道構成材                                                           |
| 料の調査や整理・分析は、対象とする河道を構成する材料の大局的分類であ |
| る材料m、s、tのいずれに当たるかを明確にした上で行うことを推奨する。  |
|                                                                      |
| それぞれの定義は以下のとおりである。併せて、図4-2-1が参考となる。    |
|                                                                      |
| 1.  材料m（main）                                                    |
|                                                                      |
| 洪水営力を頻繁に                                                     |
| 受ける、主流路で相対的に低い河床領域を構成する材料である。通常、低水 |
| 路の河床材料がこれに当たり、特に断りなく「河床材料」と言うときは一般 |
| に材料mを指す。材料mは、本節[2.4.2](http://www.yahoo.co.jp)、[2.4.3  |
| ](http://www.yahoo.co.jp)に述べるように粒度範囲を大きく３つに区分（A |
| ,B,C集団）して、移動しやすさや流送形態について分析することができる。 |
|                                                                      |
| 8.  材料s（sub）                                                     |
|                                                                      |
| 材料mが存在する主流路の脇                                            |
| の高い河床部分に存在する材料であり、その粒径範囲は材料mの粒径範囲と  |
| 重なる部分がないか又は小さく、材料mの平均粒径より１オーダー以上小さ  |
| い成分を多く含む。主流路内では浮遊形態で流送されるのが一般的である。 |
|                                                                      |
| 材料sは、本節の[2.1.3](http://www.yahoo.co.jp)で述べたセグメント     |
| 類型2と3では高水敷の本体を構成する。その材料がシルト・粘土を含み粘着 |
| 力を発揮する場合には、河床材料とは異なる流送特性を示す。そのため材料 |
| ｓに関する情報は、低水路河岸の浸食形態・速度の予測や護岸の必要性の判 |
| 断、低水路川幅拡幅後の土砂堆積による川幅縮小の推定などに必要となる。 |
|                                                                      |
| セグメント類型1での材料sの堆積は、あっても一般に薄い。しかしそ       |
| こでは、材料mである礫が露出している場所に比べ植物がより生育しやすい  |
| ので、植物の状況などを分析する際にも材料sに関する情報が重要となる。  |
|                                                                      |
| 9.  材料t（transient）                                               |
|                                                                      |
| 平水時に水面下となる河床部分（材料m）の上に（多                      |
| くの場合薄く）乗った材料であり、その粒径範囲は材料s程度あるいは更に  |
| 細かい成分を含むことさえある。材料tは、一時的で不安定なことが多く、  |
| ごく小規模の出水があるとフラッシュされ、あるいは増減する性質を持つ。 |
|                                                                      |
| 材料mが一時的にせよ部分的にせよ材料tに覆われることは、微小規模のハ   |
| ビタット構造の変化として重要となる場合があり、平水状況が長く続くとき |
| の物質循環にも影響を与え得る。粒状有機物の堆積も材料tに分類される。  |
|                                                                      |
| ![](media/image137.emf){width="2.5076388888888888in"                 |
| height="3.64375in"}                                                  |
|                                                                      |
| 6.  各セグメント類型における材料m、s、tの典型的な存在状況            |
|                                                                      |
| 以上のように、材料m、s                                               |
| 、tの基本的性格や河道特性との関わりは大きく異なるので、調査や整理･分 |
| 析の対象が、これらのうちどれに分類されるかを把握することが望ましい。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

河道構成材料の大局的分類（材料ｍ、ｓ、ｔ）の詳細については、下記の資料が参考となる。

1.  国土技術政策総合研究所環境研究部，(独)土木研究所水環境研究グループ自然共生センター：[ダムと下流河川の物理環境との関係についての捉え方](http://www.nilim.go.jp/lab/bcg/siryou/tnn/tnn0521.htm)，国土技術政策総合研究所資料，第521号，土木研究所資料，第4140号，第2章2節，2009.

    1.  []{#_Toc382986770 .anchor}代表粒径の設定

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  河道特性の整理・分析においては、材料mを対象とした河床材料調査の結果に基づき、河床材料の動きやすさや流送される量を規定する河床材料粒径の代表値として、代表粒径ｄ~R~をセグメントごとに設定することを標準とする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜例　示＞

+----------------------------------------------------------------------+
| 代表粒径ｄ~R~は、以下の手法により設定することができる。              |
|                                                                      |
| 材料mが砂主体であるセ                                                |
| グメントの場合には、代表粒径に河床材料のｄ~60~を用いることができる。 |
|                                                                      |
| 材料mが砂礫や石礫であるセグメントの場合には、                        |
| 河床材料を以下の手順によりＡ、Ｂ、Ｃ集団に区分した上で、代表粒径を設 |
| 定することができる。河床材料の区分については、図4-2-2が参考となる。  |
|                                                                      |
| 1)  容積法による河                                                   |
| 床材料の調査（本章[3.4.2](http://www.yahoo.co.jp)参照）によって得た  |
| 当該セグメントの粒径分布を、横軸に粒径を対数表示し、縦軸に通過重量又 |
| は体積百分率を取った図面に、粒径加積曲線として描く（図4-2-2参照）。  |
|                                                                      |
| 2)  粒径2mmを区分粒径とし、粒径2                                     |
| mm以下の砂成分をＢ集団とする。ただし、この付近の粒径加積曲線上に勾配 |
| の急変点が生じていれば（通常1.0～2.0mm辺り）、それを区分粒径とする。 |
|                                                                      |
| 3)  粒径加積                                                         |
| 曲線上で、もっとも大粒径よりの直線状（勾配一定）部分をＣ集団とする。 |
|                                                                      |
| 4)  Ｂ集団とＣ集団の間をＡ'集団と仮置きする。Ｂ集団とＡ' 集団、 Ａ'  |
|     集団と                                                           |
| Ｃ集団は、通常、粒径加積曲線の勾配急変点を隔てて接続することになる。 |
|                                                                      |
| 5)  Ａ'                                                              |
|                                                                      |
|  集団の粒径加積曲線の中に勾配急変点が存在する場合には、仮置きしたＡ' |
|     集団を、そこでＡ' 集団とＡ''                                     |
|     集                                                               |
| 団に分割する。場合によっては、この勾配急変点が明確でないことがある。 |
| この場合は、当該セグメントの澪筋部の表層材料の粒度分布（Ｃ集団とＡ'  |
|     集団からなることが多い）により判断するか、Ｃ集団とＡ'            |
|     集団の区分粒径の8分の1程度の粒径をＡ' 集団とＡ''                 |
|     集団の区分粒径として、仮置きしたＡ' 集団をＡ' 集団とＡ''         |
|     集団に分割する。更に、新設したＡ''                               |
|     集団の最大・最小粒径比が15を超える場合は、                       |
| 下流のセグメントの粒度分布形も参考にしながら、Ｂ集団と隣接するＡ'''  |
|     集団を新たに挿入し、粒径の大きな順にＡ'、Ａ''、Ａ'''             |
|     集団とする。                                                     |
|                                                                      |
| 6)  最後に対象河川の各小                                             |
| セグメントの区分粒径が、上下流で一致するように区分粒径を微調整する。 |
|                                                                      |
| 7)  こうして得られた河床材料区分に基づき、Ｃ集団とＡ'                |
|     集団のみから成る粒径加積曲線を新                                 |
| たに作成し、その60％通過粒径ｄ~60~を求め、これを代表粒径d~R~とする。 |
|                                                                      |
| Ａ''                                                                 |
| 集団以下の含有率が20～30%以下の場合には、河床材                      |
| 料調査によって得た粒径分布のd~60~とその粒度分布に上記手順を適用して  |
| Ａ'、Ｃ集団から求めた代表粒径との差違が一般に小さい。そのため、Ａ''  |
| 集団以下の含有率が20～30%以下の場合には、河床材料調査によって得      |
| た粒径分布のｄ~60~を代表粒径とすることができる（すなわち、材料mが砂  |
| 主体であるセグメントの場合と同様に代表粒径の設定を行うこととなる）。 |
|                                                                      |
| 線格子法・面格子法による河床材料の調                                 |
| 査（本章[3.4.2](http://www.yahoo.co.jp)参照）を行った場合には、Ａ''  |
| 集団以下                                                             |
| の含有率が20～30%以下となる場合が多く、そのため上記手順を踏まずに河  |
| 床材料の調査によって得た粒径分布のｄ~60~として代表粒径を求めてよい。 |
|                                                                      |
| なお                                                                 |
| 、河口や堰の上流等の中小出水では掃流力が相対的に小さい箇所では、Ａ'  |
| 、Ｃ集団より細粒の材料が多く堆積し、その箇所を含むセ                 |
| グメント内の他箇所に比べて細粒化している場合がある。そうした箇所を含 |
| むセグメントの代表粒径の設定においては、細粒化した箇所における河床材 |
| 料の調査のデータは参考程度にとどめ、他箇所でのデータをより重視する。 |
|                                                                      |
| ![](media/image138.png){width="5.053472222222222in"                  |
| height="2.042361111111111in"}                                        |
|                                                                      |
| 7.  粒径加積曲線に基づく河床材料の区分の例                           |
+----------------------------------------------------------------------+

＜参考となる資料＞

河床材料のＡ、Ｂ、Ｃ集団への区分の手法及び代表粒径の設定については、下記の資料が参考となる。

1.  山本晃一，(財)河川環境管理財団企画：沖積河川－構造と動態－，技報堂出版，2010.

    1.  []{#_Toc382986771 .anchor}混合粒径河床材料の整理・分析について

＜考え方＞

+----------------------------------------------------------------------+
| 本節の[2.4.2](http://www.yahoo.co.jp)に示した代表粒径の設定手順      |
| で用いている材料mのＡ、Ｂ、Ｃ集団への区分という手法は、以下に示す    |
| ように、混合粒径河床材料の捉え方にも資するものである。すなわち、Ａ'  |
| 集団は河床材                                                         |
| 料の主モード（主構成材料）であり、それより粒径の大きいＣ集団は、Ａ'  |
| 集団に比べ移動速度が遅く、河床に取り残されて                         |
| いるような状況を呈するものである。河床変動に関係するのは主にＣとＡ'  |
| 集団であり、材料m全体の動きやすさ                                    |
| を規定する主材料であることが一般的である。一方、Ｂ集団やＡ'''、Ａ''  |
| 集団は、大粒径間に存在す                                             |
| るマトリクス集団で、河床変動にはあまり寄与しないことが一般的である。 |
|                                                                      |
| 以上から、                                                           |
| 本節の[2.4.2](http://www.yahoo.co.jp)において代表粒径ｄ~R~をＣとＡ'  |
| 集団から算出することとしている。                                     |
|                                                                      |
| 各集団は、それぞれ異なる流送形態又は移                               |
| 動速度を持っている可能性が高く、したがって、集団ごとに移動性や移動量 |
| を評価することを通じて、当該セグメントの土砂動態や河床変動の特性につ |
| いての理解を深めることにつながると期待される（本章[6.3](http://www.y |
| ahoo.co.jp)参照）。代表粒径ｄ~R~設定の手順もこの考え方の一環である。 |
|                                                                      |
| また、近年は、比較的粒径分布の狭い十分混合された混合粒径             |
| 材料に対して、砂礫から石礫までを含む材料で構成される河川については、 |
| 掃流力によって流砂や河床変動を記述する従来の枠組みを修正・改良する必 |
| 要があるという観点からの知見の蓄積が活発になっている。粒径分布の幅が |
| 広い、更には、その平面的不均一性も高いような河床材料については、従来 |
| の整理・分析・解析法の有効性が、比較的粒径分布の幅が狭い十分混合され |
| た材料を対象にする場合と異なり得ることに配慮しておくことが望まれる。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

河床材料の各集団の流送形態については、下記の資料が参考となる。

1.  山本晃一，(財)河川環境管理財団企画：沖積河川－構造と動態－，技報堂出版，2010.

粒径分布の幅が広く、その平面的不均一性も高いような砂礫から石礫にわたる河床材料の流送については、下記の資料が参考となる。

152. 福岡捷二：石礫河川の移動床水理の諸問題と解決への道筋，土木学会水工学委員会・海岸工学委員会
     水工学シリーズ，08-A-1，2008.

153. 藤田正治，Sulaiman M. ，Ikhsan J.
     ，堤大三：河床材料の空隙率の変化を考慮した河床変動モデルとその適用，河川技術論文集，第14巻，pp.13-18，2008.

154. 長田健吾，福岡捷二：石礫河川の土砂移動機構に着目した1次元河床変動解析法の開発，水工学論文集，第52巻，pp.625-630，2008.

     河床の主構成材が礫であり、礫が移動しない状況下での礫間からの微細土砂の抜けだし・充填については、下記の資料が参考となる。

155. 芦田和男，藤田正治：平衡及び非平衡浮遊砂量算定の確率モデル，土木学会論文集，第375号
     Ⅱ-6 ，pp.107-116，1986.

     1.  []{#_Toc382986772 .anchor}各時点の河道状況

         1.  []{#_Toc382986773 .anchor}河道の形状

             1.  []{#_Toc382986774 .anchor}河川の地形測量

＜標　準＞

+----------------------------------------------------------------------+
| 河道形状の測量は、河川定期                                           |
| 縦横断測量と空中写真測量により行い、[第22章](http://www.yahoo.co.jp) |
| 測量・計測 に基づいて実施することを標準とする。                      |
|                                                                      |
| 定期横断測線は河川ごとにある一定間隔で配置                           |
| されており、この既定の測線に沿って河道横断測量を行うのを標準とする。 |
|                                                                      |
| 河川定期縦横断測量から以下を把握することを標準とする。               |
|                                                                      |
| > 平均河床縦断形                                                     |
| >                                                                    |
| > 最深河床縦断形                                                     |
| >                                                                    |
| > 河川縦断沿い各地点の河床横断形                                     |
| >                                                                    |
| > 横断面内での最深河床の相対位置に関する縦断分布                     |
| >                                                                    |
| > 低水路川幅、堤間幅の縦断変化                                       |
|                                                                      |
| また、空中写真測量から以下の図・写真を得ることを標準とする。         |
|                                                                      |
| > 河道平面図                                                         |
| >                                                                    |
| > 河川垂直空中写真                                                   |
+----------------------------------------------------------------------+

＜推　奨＞

+----------------------------------------------------------------------+
| 測線間                                                               |
| 隔が低水路幅に比較して大きくなるほど、縦断方向変化の測定密度が相対的 |
| に小さくなるために解像度が低くなる。特に、局所洗掘域などのスケールの |
| 小さい河道地形については、その発生範囲に掛かる測線本数が少なくなる。 |
|                                                                      |
| このような場合には、測量の目的・用途に応じて横断測                   |
| 線の適宜追加など面的に河道形状を把握できる測量を行うことを推奨する。 |
+----------------------------------------------------------------------+

＜例　示＞

+----------------------------------------------------------------------+
| 河床高を面的に把握する測量手法として、サイドスキャンソ               |
| ナーなど高解像度で河床面の凹凸が捉えられる一部の水中計測技術（第22章 |
| 測量・計測 [3.5](http://www.yahoo.co.jp)                             |
| 参照）を利用することができる。                                       |
|                                                                      |
| サイドスキャンソナーでは、小規模河床波、難侵食層                     |
| の侵食に伴う特異な形状、乱積みされた根固ブロックなどをおおむね識別す |
| ることができ、地形とともに河床表面の構成材の推定も可能な場合がある。 |
|                                                                      |
| また、過去に測量実績がないか不足していて、定期横断測量の新規の実     |
| 施が難しい河川では、航空レーザ測量（[第22章](http://www.yahoo.co.jp) |
| 測量・計測                                                           |
| [3.2](http://www.yahoo.co.jp)参照）を用いた河川測量が用いら          |
| れる場合がある。この方法は、地上部に計測範囲が限られるが、調査が定期 |
| 測量に比べ安価で早いことから、一部の平地河川において採用されている。 |
|                                                                      |
| なお、航空レーザ測量は以下の点で課題が残されている。                 |
|                                                                      |
| -   樹林が繁茂する山間渓谷部の横断形状把握が難しいこと。             |
|                                                                      |
| -   水面下の形状が把握できないこと（た                               |
| だし、山地河道では水深がさほど大きくないので、その点では有利である） |
|                                                                      |
| -   河道内植生をある程度認識できるが、その精度にばらつきがあること   |
|                                                                      |
| これらについては、今後一層の技術開発が必要となる。                   |
+----------------------------------------------------------------------+

＜参考となる資料＞

航空レーザ測量の河川測量への適用例として、下記の資料が参考となる。

1.  白井正孝，藤田光一：LP計測データによる中小河川の河道特性把握，年次学術講演会講演概要集第2部，第64巻，pp.401-402，2009.

    1.  []{#_Toc382986775 .anchor}河口における地形測量

＜考え方＞

+----------------------------------------------------------------------+
| 河口部の地形測量は、河道縦横断測量、深浅測量、海浜測                 |
| 量、低潮線測量、河口部縦横断測量などにより構成される。深浅測量は汀線 |
| より沖側の海底地形の測量、海浜測量はほぼ平均干潮面汀線から後浜の範囲 |
| の地形測量、汀線測量は平均潮位における汀線位置の測量、河口部縦断測量 |
| は河口砂州の変動範囲における河床、海底、砂州の変化状況の測量である。 |
|                                                                      |
| 深浅測量、海浜測量、低潮線測量については                             |
| [第21章](http://www.yahoo.co.jp)                                     |
| 海岸調査、[第22章](http://www.yahoo.co.jp) 測量・計測                |
| に基づいて実施する。                                                 |
|                                                                      |
| 河口部縦横断測量によって出水その他に                                 |
| よる河口砂州流失直後の測量を行う場合、流失した砂州の回復が早い場合が |
| あるため、回復する前のできるだけ早い時期に実施することが重要である。 |
|                                                                      |
| 航空レーザ測量による河口砂州                                         |
| の測量は、データが得られる範囲が水面上に限られる反面、空間的な解像度 |
| の高さと迅速性において優れているため、特に流下能力の評価に関わる砂州 |
| 高や洪水によるフラッシュの発生頻度の把握を目的とした適用事例が多い。 |
|                                                                      |
| なお、河川                                                           |
| からの土砂供給量の把握を目的とした河口テラスの測量については、第21章 |
| 海岸調査の[7.5.3](http://www.yahoo.co.jp)に基づいて実施する。        |
+----------------------------------------------------------------------+

1.  []{#_Toc382986776 .anchor}構造物の設置状況

＜標　準＞

+----------------------------------------------------------------------+
| 護岸、水制、堰、床固工、落差工、帯工、及び河川堤防等について、河川管 |
| 理施設台帳などに基づいて以下の事項について整理することを標準とする。 |
|                                                                      |
| > 各種構造物の設置位置と構造諸元                                     |
| >                                                                    |
| > 堤防の整備状況（完成・                                             |
| 暫定・無堤等に区分して）と点検結果（浸透に対する安全性の照査結果等） |
+----------------------------------------------------------------------+

1.  []{#_Toc382986777 .anchor}河床形態

    1.  []{#_Toc382986778 .anchor}中規模河床形態

＜考え方＞

+----------------------------------------------------------------------+
| 中規模河床波（砂州）の調査においては、                               |
| 局所洗掘の形成と河岸浸食の発生との関連性を把握することが重要である。 |
| また、瀬淵は砂州の形態・形状と密接に関係していることが多く、そのため |
| 第11章 河川環境調査 [4.2](http://www.yahoo.co.jp)水域調査            |
| で述べる瀬淵に関する調査において、以下に示す砂州調査と関連づけて整理 |
| することが、瀬淵の形成・変化について理解を深める上で効果的である。そ |
| れらの実施に当たって踏まえるべき基本的観点として、以下が挙げられる。 |
|                                                                      |
| 1.  砂州形態の変化                                                   |
|                                                                      |
| 交互                                                                 |
| 、複列、多列及び非発生等に区分できる砂州形態は、出水規模や河道形状に |
| 応じて経時的に変化する場合がある。たとえば、大出水時には、多列・複列 |
| であった砂州の前縁線を包絡するように複列・交互砂州が共存するようにな |
| る場合がある。さらには、複列・交互砂州に移行することもある。その逆に |
| 、元々川幅水深比の小さい単断面の河道区間では、水深の増加に伴って交互 |
| 砂州が不明瞭となる場合がある。また、複断面の場合には、高水敷を冠水さ |
| せて堤間幅にわたって洪水が流下する場合には、低水路満杯規模の洪水時と |
| は流況が異なるなどのために砂州形態・形状に変化が現れるとも考え得る。 |
|                                                                      |
| 10. 砂州の下流への移動に伴う局所洗掘・河岸浸食の位置の変化           |
|                                                                      |
| 砂州上での洪                                                         |
| 水時の平面的流況の特徴として、砂州形状の高低に応じた流れの集散が挙げ |
| られる。流れの集まる箇所が河岸際に形成されると、そこが水衝部となり、 |
| その付近において局所洗掘や河岸浸食が生じる。砂州の下流への移動に伴う |
| 水衝部の位置の変化に応じて、これまで局所洗掘や河岸侵食が生じていなか |
| った、又は顕著でなかった箇所でそれらが顕在化し、進行する場合がある。 |
|                                                                      |
| 11. 流量の時間的変化に対する砂州の応答                               |
|                                                                      |
| 上記した変化の現れ方は、河床材料の動きやすさや砂州スケー             |
| ルによって異なる。一般に、砂州の長さ、高さが大きく、又流砂量（又は掃 |
| 流力）が小さい出水時ほど、砂州の形態・形状の変化や移動が緩慢となる。 |
|                                                                      |
| 礫床区間では、砂州の流量に追随した変化が一般に緩慢である。その       |
| ため、砂州が最大流量時の水理量に応じた砂州形態・形状まで十分に発達せ |
| ず、また、減水期において流量の減少に砂州の変化が完全には追随しない。 |
|                                                                      |
| 砂床区間では、礫床区間に比較して流量変                               |
| 化に応じた砂州変化が一般により生じやすく、洪水流量変化に対する砂州の |
| 追随性が高い。特に、河床勾配が比較的大きい砂床区間では、出水後の砂州 |
| 形状は減水期の影響を受けて変化しており、出水中の形状を保っていない。 |
+----------------------------------------------------------------------+

＜標　準＞

  ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  砂州形状とその配置を本節の[3.1.1](http://www.yahoo.co.jp)で取得した河川垂直空中写真から判読し、砂州前縁の平面分布を得るのを標準とする。砂州形態の判読に当たっては、砂州平面分布のみでなく河床横断形状を併せて参照するなど総合的に判別する。
  ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

+----------------------------------------------------------------------+
| 上記で得た各時点で                                                   |
| の砂州の平面形状・配置を時系列に沿ってつなぎ合わせて、時間変化につい |
| て分析することが望ましい。なお、その際には次のことに留意するとよい。 |
|                                                                      |
| 砂州が同一の形態のまま                                               |
| 、形状を大きく変えずに下流方向に徐々に進行する場合には、各時点での砂 |
| 州の平面形状・配置には時間的対応関係（時間を隔てていても同一の砂州を |
| 見ているという意味）があると捉えることができる。この場合、たとえば、 |
| 対応する二時点の砂州前縁線の位置を比較することによって砂州の移動速度 |
| を見積もることができ、その間に発生した出水状況と比較することで、砂州 |
| の移動速度と洪水流量・継続時間との関係性などを検討することができる。 |
|                                                                      |
| 一方、二時点間                                                       |
| で、砂州形態の遷移や砂州形状の大きな変化が生じている場合には、両時点 |
| での砂州の平面形状・配置に時間的対応関係が存在しなくなる。たとえば二 |
| 時点で複列砂州が交互砂州に変化している場合、あるいは、同じ複列砂州で |
| あるが途中で交互砂州への遷移が起こっており、両時点の複列砂州の配置に |
| 直接的なつながりがない場合などが、こうしたケースに該当する。このよう |
| に砂州形態の遷移あるいは大きな形状変化を起こす出水等のイベント（本章 |
| [4.1](http://www.yaho                                                |
| o.co.jp)参照）が生じた場合には、出水中の河床変動を追跡する調査（本章 |
| [4.5.2](http://www.yahoo.co.jp)参照）等を通じ                        |
| て、出水が砂州形態・形状に与えた影響を直接的に把握する必要性が増す。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

中規模河床波の挙動と局所洗掘・河岸浸食の関係については、下記の資料が参考となる。

1.  山本晃一，(財)河川環境管理財団企画：沖積河川－構造と動態－，技報堂出版，2010.

    1.  []{#_Toc382986779 .anchor}小規模河床形態

＜例　示＞

+----------------------------------------------------------------------+
| 小規模河床波は、基本的に出水期                                       |
| 間中の発達・変形が重要であり、その挙動と粗度係数や深掘れ（特に砂堆の |
| 発達に伴うもの）との関係把握を目的とした出水中観測（本章[4.5.2](htt  |
| p://www.yahoo.co.jp)の＜例示＞参照）を積極的に行うことが重要である。 |
|                                                                      |
| 出水後に残存した河床波は、必ずしも出水中の                           |
| 形状を表していないため、それを推測するための補助的な情報にとどまる。 |
|                                                                      |
| ただし                                                               |
| 、礫床河川では比較的大きな出水後に砂堆が残存する場合があり、砂堆発達 |
| に伴う粗度係数の増加について検討する上で有効な情報となる場合がある。 |
|                                                                      |
| また、山地河川では階段状河床                                         |
| 波が形成される場合があり、その波長や段差について計測した事例がある。 |
|                                                                      |
| 砂床河川では、河口部近く                                             |
| の勾配の小さい河道区間等では、水位のせき上げによって減水期における小 |
| 規模河床波の変形が比較的抑えられる場合がある。その場合には、出水によ |
| り形成される小規模河床波の形態・形状に関する情報を得ることができる。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

小規模河床波の挙動と粗度係数及び深掘れの関係については、下記の資料が参考となる。

1.  山本晃一，(財)河川環境管理財団企画：沖積河川－構造と動態－，技報堂出版，2010.

小規模河床波の発達に伴う粗度係数の変化、階段状河床に関する調査研究論文は、下記の資料が参考となる。

156. 芦田和男，道上正規：移動床流れの抵抗と掃流砂量に関する基礎的研究，土木学会論文集，第206号，pp.59-69，1972.

157. 長谷川和義，藤田睦博：ステップ・プールに視点をおいた山地河川の流れの抵抗，第30回水理講演会論文集，pp.79-84，1986.

158. 長谷川和義：河川上流域の河道地形，日本流体力学会誌｢ながれ｣，第24巻，pp.15-26，2005.

     1.  []{#_Toc382986780 .anchor}局所洗掘

＜標　準＞

+----------------------------------------------------------------------+
| 局所洗掘は、                                                         |
| 最深河床高の縦断分布において部分的に下に凸となる河床低下箇所として把 |
| 握し、その箇所を中心とした上下流を含む一連の河道横断図を併せて用いて |
| 、局所洗掘の位置と深さに関する以下について把握することを標準とする。 |
|                                                                      |
| > 局所洗掘位置の平面分布                                             |
| >                                                                    |
| > 洗掘深（平均河床高と最深河床高の差）の縦断分布                     |
+----------------------------------------------------------------------+

＜推　奨＞

  ------------------------------------------------------------------------------------------------------------------------------------------
  堰、床止工、水制、橋脚等の構造物周辺の局所洗掘については、洗掘の位置と深さの平面分布、河床の縦横断形状等について把握することが望ましい。
  ------------------------------------------------------------------------------------------------------------------------------------------

1.  []{#_Toc382986781 .anchor}表面・表層の状態

    1.  []{#_Toc382986782 .anchor}総説

＜考え方＞

+----------------------------------------------------------------------+
| 表面・表層の状態の                                                   |
| 調査は、河床表面の構成材料（[3.4.2](http://www.yahoo.co.jp)～[3.4.6] |
| (http://www.yahoo.co.jp)）、植物の繁茂状況（[3.4.7](http://www.yahoo |
| .co.jp)）及びその他堆積物等（[3.4.8](http://www.yahoo.co.jp)）により |
| 構成される。河床表面の構成材料については、以下の３種類の調査がある。 |
|                                                                      |
| >                                                                    |
| 非粘着性の材料：粒度分布によってその流送特性が表される非粘着性の材料 |
| >                                                                    |
| > 粘着性を有                                                         |
| する材料：粒度分布も関係するがそれのみでは流送特性を評価できない材料 |
| >                                                                    |
| > 岩盤、                                                             |
| 軟岩など難侵食性の材料：土粒子単位への分離が困難な固結・半固結堆積物 |
+----------------------------------------------------------------------+

2.  []{#_Toc382986783 .anchor}河床材料の調査

＜標　準＞

+----------------------------------------------------------------------+
| 主に材料ｍを対象とする                                               |
| 河床材料調査は、以下の方法で粒度分布調査を実施することを標準とする。 |
|                                                                      |
| 1.  試験方法                                                         |
|                                                                      |
| 河床表面の材料を対象として、材料mが砂の場合には容積法、礫の          |
| 場合には線格子法又は面格子法により粒度分布調査を行うのを標準とする。 |
|                                                                      |
| ただし、必要に応じて河床表面を対象とした線格子法又は面格子           |
| 法による粒度分布に加えて、表層を取り除いた下層を対象とした容積法によ |
| る粒度分布調査を行う。そうした調査を行う場合として以下が挙げられる。 |
|                                                                      |
| > 過去に河床材料調査を行っていて、その調査方法が容積法に             |
| よる調査であり、その調査結果と比較して経年的な変化等を把握したい場合 |
| >                                                                    |
| > アーマリングの                                                     |
| 進行度合いなどを把握するため、表層とその下の粒度分布を比較したい場合 |
| >                                                                    |
| > 礫床                                                               |
| 河道区間を対象とした河床変動等解析（[第6章](http://www.yahoo.co.jp)  |
| > 河床変動、河床材料変化及び土砂流送の                               |
| 解析）を行うに際して、表面に加えてその下の粒度分布の情報も必要な場合 |
|                                                                      |
| なお、100mm以上の粒径を含有する河床材料を対象とした                  |
| 試料採取の場合には、大礫を含む容積法により実施することを標準とする。 |
|                                                                      |
| 河床材料に                                                           |
| 含まれる大粒径成分は、その含有率が小さい場合であっても、粒度分布調査 |
| の対象とすることを標準とする。ただし、大礫を含めた調査が著しく困難な |
| 場合には、調査地点の大礫の分布状況を写真などにおいて記録した資料と大 |
| 粒径成分を除いた調査である旨を調査結果に必ず併記しなければならない。 |
|                                                                      |
| 12. 調査地点の選定                                                   |
|                                                                      |
| 測定地点は、河床変動と関連させて粒径変                               |
| 化等についての検討を行えるように、河道定期横断測量測線上に設定するこ |
| とを標準とする。既往調査結果や現地概査により河道縦横断方向の分級など |
| について把握し、その状況を捉えられるように河道縦横断方向の測点間隔を |
| 設定する。一般的には、縦断方向1km間隔、横断方向に３箇所を目安とする  |
| 。低水路幅が比較的狭い場合やセグメント長が短い場合、ダムの堆砂区域、 |
| 支川の合流点など、局部的に河床材料                                   |
| の変化の激しい所では状況に応じて測定地点間隔（地点数）を増減させる。 |
|                                                                      |
| 13. 河床材料調査の整理                                               |
|                                                                      |
| 代表粒径の                                                           |
| 縦断分布及び試料採取地点ごとの粒径分布等を整理することを標準とする。 |
+----------------------------------------------------------------------+

＜関連通知等＞

・容積法による粒度調査手法

1.  JIS A 1204 土の粒度試験方法.

＜参考となる資料＞

各種の粒度分布試験については、下記の資料が参考となる。

・線格子・面格子法による粒度調査手法

1.  (財)国土技術研究センター：[河道計画検討の手引き](http://www.jice.or.jp/tosho/pdf/kadoukeikaku.pdf)，山海堂，2002.

    ・大礫を含む場合の容積法による粒度調査手法

```{=html}
<!-- -->
```
159. 山本晃一，高橋晃
     ：扇状地河川の河道特性と河道処理，土木研究所資料，第3159号，pp.27-31，1993.

＜推　奨＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  河床材料の平面分布について更に詳細な情報が必要となる場合には、例えば対象地域にメッシュ状に河床縦横断測線を設定し、それに沿って地形測量と河道構成材料調査を行うなど、平面的にきめ細かな調査を行うことが望ましい。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜参考となる資料＞

平面的な河床材料調査については、下記の資料が参考となる。

1.  国土技術政策総合研究所環境研究部，(独)土木研究所水環境研究グループ自然共生センター：[ダムと下流河川の物理環境との関係についての捉え方](http://www.nilim.go.jp/lab/bcg/siryou/tnn/tnn0521.htm)，国土技術政策総合研究所資料，第521号，土木研究所資料，第4140号，第5章3節，2009.

    1.  []{#_Toc318238908 .anchor}河岸・高水敷の構成材料調査

＜推　奨＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------
  主に材料sを対象とする河岸・高水敷の構成材料調査は、本節[3.4.2](http://www.yahoo.co.jp)の河床材料の調査の手法に準じて粒度分布調査を実施することを推奨する。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------

2.  []{#_Toc382986785 .anchor}岩盤、軟岩など固結物・半固結物の調査

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  河床材料調査やその他現地踏査によって確認した河床、河岸、高水敷の表面に岩盤、固結・半固結物が露出している範囲について、河道平面図、平均・最深河床高縦断図、河床横断形状図に整理することを標準とする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜参考となる資料＞

調査成果の整理については、下記の資料が参考となる。

1.  (財)河川環境管理財団河川環境総合研究所：河道特性に及ぼす粘性土・軟岩の影響と河川技術，河川環境総合研究所資料，第29号，p.489，2010.

    1.  []{#_Toc382986786 .anchor}粘着性を有する材料の調査

＜例　示＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  セグメント類型２、３の河岸や高水敷を構成する粘着性土、また河口域やセグメント類型３の河床に堆積している場合がある高含水の粘着性土について、その耐浸食性（浸食限界流速、浸食速度と掃流力の関係等）を把握する場合には、それぞれの土質に適した種々の耐浸食性の調査手法を用いた試験を行うことができる。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜参考となる資料＞

粘性土の耐浸食性の調査手法については、下記の資料が参考となる。

高含水比の底泥の耐浸食性

1.  大坪国順，村岡浩爾：流れによる底泥の飛び出し率，土木学会論文集，第375号
    Ⅱ-6 ，pp.43-52，1985.

```{=html}
<!-- -->
```
160. 関根正人，西森研一郎，藤尾健太，片桐康博：粘着性土の浸食進行過程と浸食速度式に関する考察，水工学論文集，第47巻，pp.541-546，2003.

161. 西森研一郎，関根正人：粘着性土の浸食過程と浸食速度式に関する研究，土木学会論文集B，Vol.65
     No.2，pp.127-140，2009.

礫間土砂が粘着力を有する場合の砂礫の耐浸食性

162. 澤井健二，芦田和男：粘着性流路の浸食と横断形状に関する研究，土木学会論文報告集，第266号，pp.73-86，1977.

高水敷・河岸を構成する粘着性土の耐浸食性

163. 福岡捷二：洪水の水理と河道の設計法，pp.195-220，森北出版，2005.

164. 宇多高明，望月達也，藤田光一，平林桂，佐々木克也，服部敦，藤井政人，深谷渉，平舘治
     ：洪水流を受けた時の多自然型河岸防御工・粘性土・植生の挙動　－流水に対する安定性・耐侵食性を判断するために－，土木研究所資料，第3489号，1997.

     1.  []{#_Toc382986787 .anchor}河口の河床材料調査

```{=html}
<!-- -->
```
1.  河口砂州部の粒度分布調査

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  河口砂州部においては、採取地点として汀線付近、波の打上げ部、砂州頂部、川側の4点を選ぶものとし、断面数は砂州の大きさに応じて決めるが少なくとも3断面以上とする。また深さ方向に分級が生じている場合には、表面と表面下とを対象とする二層の調査を行うことを標準とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  砂州部において砂州が季節的に大きく変動する場合には、年に数回程度行うことが望ましい。また、河道内においても、洪水などによって状況が変化した場合には洪水後に調査を行うことが望ましい。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

39. 河口テラスの底質材料調査

＜推　奨＞

+----------------------------------------------------------------------+
| 河口テラスの底質材料調査は、砂州の形成要因を把握し、                 |
| また、流出土砂量の算定のための基礎資料とするものである。底質材料調査 |
| の調査範囲は、河口中央を中心に左右岸方向にそれぞれ河幅程度の距離をと |
| った範囲を、沖方向には水深10ｍ程度までの範囲を含めることを推奨する。 |
|                                                                      |
| 海域では底質採取が容易でないが、波による砂移動に関す                 |
| る多くの有効な情報を知る上で重要である。底質は表層のものを採取すれば |
| よいが、引き上げるときに採取器からの流失を防除することに努める。なお |
| 、底質粒径の水深方向分布を求めると、移動限界水深の推定などに役立つ。 |
+----------------------------------------------------------------------+

1.  []{#_Toc382986788 .anchor}植物繁茂状況の調査

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------
  第11章 河川環境調査の[第7節](http://www.yahoo.co.jp) 植物調査 による植生図を用いて、植物群落及び樹木群の平面分布を得ることを標準とする。
  ------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------
  その際、河道横断図や平面図と重ね合わせるための各群落の位置情報と、粗度特性に関わる樹高、草丈、繁茂密度に関する情報を併せて整理することを推奨する。
  ----------------------------------------------------------------------------------------------------------------------------------------------------

2.  []{#_Toc382986789 .anchor}その他堆積物等の調査

＜例　示＞

+----------------------------------------------------------------------+
| 有機性の堆積物、礫面上への砂堆                                       |
| 積等、以下に例示する種々の堆積物、堆積状況の重要性を明らかにする知見 |
| が近年蓄積されつつあるので、必要に応じて調査を実施することができる。 |
|                                                                      |
| -   デブリ、流木などの固形有機物                                     |
|                                                                      |
| -   表面細粒土層（材料mの礫を覆う材料s、tの土砂で構成される表層）    |
|                                                                      |
| -   浮石、はまり石等の河床礫の状態                                   |
+----------------------------------------------------------------------+

1.  []{#_Toc382986790 .anchor}平常時の水理環境

＜考え方＞

+----------------------------------------------------------------------+
| 平常時の水位、流速等の水理環境は、砂州上への植物群落の形成、堰       |
| 等の湛水範囲での土砂の挙動、河口域での潮位変化に伴う入退潮による土砂 |
| 流送と細粒土砂の堆積、河口砂州を有する河口の開口幅、波浪による河口砂 |
| 州の再形成等を調査する上で、物理的環境を表す基本的項目の一つである。 |
|                                                                      |
| 植生調査、河床材料                                                   |
| 調査、河口域の調査においては、本章の[第5節](http://www.yahoo.co.jp)  |
| 洪水の作用                                                           |
| で述べる出水時の営力や基本条件と併せて、平                           |
| 常時の水理環境に関わる基本的な水理量を整理しておくことは重要である。 |
+----------------------------------------------------------------------+

＜例　示＞

+----------------------------------------------------------------------+
| 河川域と河口域において以下に例示する事項について整理する場合がある。 |
|                                                                      |
| 1.  河川域                                                           |
|                                                                      |
| > 河状係数（年最大流量と年最小流量の比）                             |
| >                                                                    |
| > 水位観測所地点における位況                                         |
| >                                                                    |
| > 平水時の代表的流量での水際線位置及び流量変化に応じた変動幅         |
| >                                                                    |
| > 瀬淵や湛水範囲等での流速、水深（1次元、平面）                      |
|                                                                      |
| 14. 河口域                                                           |
|                                                                      |
| ```{=html}                                                           |
| <!-- -->                                                             |
| ```                                                                  |
| a.  波浪及び潮位                                                     |
|                                                                      |
| > 当該河口付                                                         |
| 近における海岸において波高、周期、波向、潮位について調査する。第21章 |
| > [第4節](http://www.yahoo.co.jp) 海面変動調査 により実施する。      |
|                                                                      |
| j.  水位                                                             |
|                                                                      |
| > 大潮、中潮、小潮時等の潮汐による水位変動や出水                     |
| 時水位等について調査する。自記水位計による通年観測については、第2章  |
| > 水文・水理観測の[第3節](http://www.yahoo.co.jp) 水位観測           |
| > によるものとする。                                                 |
|                                                                      |
| k.  流量                                                             |
|                                                                      |
| > 河口域の流量                                                       |
| は、河口域に流入する河川流量と河口からの入退潮量の影響を受けて時間的 |
| に変動している。河口域における流量調査についての一般的方法は、第2章  |
| > 水文・水理観測の[第4節](http://www.yahoo.co.jp) 流量観測           |
| > によるものとする。                                                 |
|                                                                      |
| l.  砂州や干潟等での流速、水深（1次元、平面）                        |
|                                                                      |
| 河口域での調査項目や手法等の選定において、第14章                     |
| 汽水域・河口域の環境調査 の[第2節](http://www.yahoo.co.jp)           |
| 汽水域・河口域の環境調査 を参考にすることができる。                  |
+----------------------------------------------------------------------+

1.  []{#_Toc382986791 .anchor}河道状況の時間的変化

    1.  []{#_Toc382986792 .anchor}時間的変化の捉え方

＜考え方＞

+----------------------------------------------------------------------+
| 沖積河                                                               |
| 川の本質的特徴の１つは河道状況が変化することであり、その実態把握は河 |
| 道特性調査の根幹の１つをなす。本章の[第3節](http://www.yahoo.co.jp)  |
| 各時点の河道状況                                                     |
| に関する調査結果に基づき、また、必要                                 |
| な調査を加えながら、河道の時間変化を適切に把握することが重要である。 |
|                                                                      |
| 図4-4-1に示すように、河道状況の変化には複数のパターンがあり、        |
| 対象とする変化のパターンを考慮して調査を組み立てることが求められる。 |
|                                                                      |
| たとえば、同図のa)のように、変化が持続的に起こる場合は、一定         |
| 時間間隔での河道状況把握に基づき経時変化を追跡することが基本となる。 |
|                                                                      |
| b)のように、洪水などのイベント                                       |
| 時に変化が進行する場合は、イベント前後の河道状況把握と比較が重要にな |
| る。ここでいうイベントとは、洪水のほか高潮・高波浪などの自然事象のほ |
| か、河道の掘削、維持浚渫や構造物の設置・改築などの人為的作用を含む。 |
|                                                                      |
| c)のように、イベントに応答するタイプを扱う場合には、経               |
| 時的追跡とイベント前後の河道状況把握・比較を組み合わせる必要がある。 |
|                                                                      |
| d)のように、洪水中に変化が生じ、しかもその変化の大部分が洪水中に完   |
| 結する（元に戻る）場合には、変化を洪水中に追跡することが求められる。 |
|                                                                      |
| 実際には                                                             |
| 、図4-4-1に示したパターンの幾つかが共存したり、パターンが時期により  |
| 入れ替わるなど、典型的なパターンとはならない場合も考えられる。特に堰 |
| ・床固工等の構造物の周辺では、周囲の河道状況の変化やそれに応じた補強 |
| の履歴によって、パターンの共存や入れ替わりが起こり得ると考えられる。 |
|                                                                      |
| また、同じセグメントであって                                         |
| も、着目する項目によって変化パターンが異なることも考えられる。さらに |
| 、同一のパターンであっても、イベントの大きさやその発生からの経過時間 |
| によってある一定期間内での変化進行の度合いが異なることも考えられる。 |
|                                                                      |
| こうしたことも踏まえつつ、対象とする河                               |
| 道区間及び項目が示し得る変化の特徴を適切に想定し、それに見合った頻度 |
| ・タイミング等での調査実施により時間変化把握を行うことが重要である。 |
|                                                                      |
| ![](media/image139.emf){width="5.572916666666667in"                  |
| height="3.467361111111111in"}                                        |
|                                                                      |
| ※縦軸の状態とは、たとえば河床                                        |
| 高、川幅、河床材料粒径等といった河道状況を表す状態量と解釈されたい。 |
|                                                                      |
| 1.  河道状況の変化パターンの代表例                                   |
+----------------------------------------------------------------------+

1.  []{#_Toc382986793 .anchor}基本的な調査の進め方

＜標　準＞

+----------------------------------------------------------------------+
| 河道状況の時間的変化の調査は、以下によることを標準とする。           |
|                                                                      |
| 1)  調査対象                                                         |
| とする河道区間及び項目について、起こり得る河道状況変化パターンを踏ま |
| えつつ、ア)適切な時間間隔で把握した河道状況の比較、イ)洪水等のイベン |
| トの前後で把握された河道状況の比較、ウ)洪水等イベント生起中の変化等  |
| の追跡、のいずれか、あるいは、これらを必要に応じて組み合わせて行う。 |
|                                                                      |
| 2)  上記の基となる各時点の河道状況の把握は 本章                      |
|     [第3節](http://www.yahoo.co.jp) 各時点の河道状況                 |
|     の内容による。比較対象とする項目については、本章                 |
|     [第3節](http://www.yahoo.co.jp) 各時点の河道状況                 |
|     の内容に従い以下に関するものとする。                             |
|                                                                      |
| > 河道の形状                                                         |
| >                                                                    |
| > 構造物の設置状況                                                   |
| >                                                                    |
| > 河床形態                                                           |
| >                                                                    |
| > 表面・表層の状態                                                   |
| >                                                                    |
| > 平常時の水理環境                                                   |
| >                                                                    |
| > 比較対象項目につ                                                   |
| いての各時点の調査法には、比較が適切に行える手法を一貫して選択する。 |
|                                                                      |
| 3)  上記のうち                                                       |
| ア)にある「適切な時間間隔」については、年単位を標準として変化進行の  |
| 度合いに応じて適切に設定する。また、イ)にある「洪水等のイベント」に  |
| ついては、対象としている項目について有意な変化を生じさせる規模のもの |
| を取り上げる。これらに併せて、本章の[第3節](http://www.yahoo.co.jp)  |
|     各時点の河道状況                                                 |
|     の内容による河道状況把握の調査のタイミングを適切に設定する。     |
|                                                                      |
| 4)  洪水等のイベントがもたらす河道状況変化に着目する場合には、当該   |
| イベントの特性（洪水については、洪水の状況を表す基本的な水理・水文諸 |
| 量）の把握を併せて行い、変化とそれを起こしたイベントとの関係を分析で |
| きるようにする。この把握に際しては、[第2章](http://www.yahoo.co.jp)  |
|     水文・水理観測 及び本節                                          |
|     [5.2](http://www.yahoo.co.jp)の内容を必要に応じ用いる。          |
|                                                                      |
| 5)  上記イ                                                           |
| )に関して、当該イベントで災害が発生した場合には、必要に応じ、第10章  |
|     災害調査の [第2節](http://www.yahoo.co.jp)                       |
|     対象とする区域等に応じた災害調査                                 |
|     に記述されている災害調査と連携させる。                           |
|                                                                      |
| 6)  各時点の河道                                                     |
| 状況の比較は、図化等を含む適切な整理・分析・表示法によるものとし、必 |
| 要に応じて、洪水等のイベントの諸特性との関係を吟味できるようにする。 |
+----------------------------------------------------------------------+

1.  []{#_Toc382986794 .anchor}着目する河道変化を起点にした調査の拡充

＜推　奨＞

+----------------------------------------------------------------------+
| 本節の[4.2](http://www.yahoo.co.jp)に従い、時間を隔                  |
| てた河道状況比較の対象項目は、本章の[第3節](http://www.yahoo.co.jp)  |
| 各時点の河道状況                                                     |
| の内容により調査された河道状況の項目に対応させることが基本となる。   |
|                                                                      |
| ただし、河道状況の時間的変化を把握するという観点から、逆に、各       |
| 時点の河道状況の中でも特に着目・重視すべき事項が出てくる場合もある。 |
|                                                                      |
| したがって、本章の[第3節](http://www.yahoo.co.jp) 各時点の河道状況   |
| による河道状況の把握結果から変化を整理・分析するという一方向的手     |
| 順だけでなく、実際に起こった河道変化の観察などを通じて把握すべき重要 |
| な変化項目を見いだし、それを、河道状況の把握やその結果の整理・分析の |
| 方法に反映させるという手順も必要に応じて採用していくことが望ましい。 |
|                                                                      |
| こうした意味で、河道に変化を起こす最も重要なイベントである洪水等によ |
| って生じた状況変化を掴むための現地調査等を適切に行うことが望ましい。 |
+----------------------------------------------------------------------+

＜例　示＞

+----------------------------------------------------------------------+
| 上記の観点を理解する助けとなるように                                 |
| 、以下に、河道変化を起点にした河道状況把握という手順の具体例を示す。 |
|                                                                      |
| 1.  河岸浸食、河岸線の移動状況                                       |
|                                                                      |
| 低水路河岸などの浸食は、重要な河道特性の１つである。出水前後の定期横 |
| 断測量や空中写真から低水路河岸の位置を読み取って、河岸浸食の生じた区 |
| 間長、及び最大浸食幅について整理することなどが必要になる場合がある。 |
|                                                                      |
| 河岸浸食は、大出水時に                                               |
| 大きくなるという関係性が必ずしも認められないので、様々な洪水規模につ |
| いて整理をすることが望ましい。また、定期横断測線が必ずしも最大浸食幅 |
| が生じる断面に位置しないことから、空中写真を併用することが望ましい。 |
|                                                                      |
| 15. 川幅の変化                                                       |
|                                                                      |
| 上記の河岸線                                                         |
| 移動は、浸食（後退）だけでなく堆積（前進）も起こり得る。また、低水路 |
| 川幅の変化（拡大、縮小）と捉えられる系統性を持って生じることもある。 |
|                                                                      |
| 川幅変化も把握すべ                                                   |
| き重要な項目であり、対象河道区間において川幅変化が有意に生じている場 |
| 合には、その変化が適切に把握できるような河道状況把握（たとえば、低水 |
| 路川幅を規定する河岸線位置の特性など）と時間的比較を行うことになる。 |
|                                                                      |
| 16. 河床材料の粒径変化及び置き換わり                                 |
|                                                                      |
| 河床材料の経年的変化は、以下の例のように河道の地形変化を規定         |
| し得るため、地形の経年的変化と対応させて把握すべき重要な項目である。 |
|                                                                      |
| > 供                                                                 |
| 給土砂量の減少による礫床河道での河床低下に伴う粗粒化（アーマリング） |
| >                                                                    |
| > 局所洗掘や河床低下の進行に伴う岩盤や固結物・半固結物の露出         |
| >                                                                    |
| > 礫床河道区間におけ                                                 |
| る局所洗掘の進行に伴う礫層の喪失、砂層への置き換わりによる洗掘の進行 |
|                                                                      |
| 対象河道区間において河床材料変化が有意に                             |
| 生じている場合には、経時的追跡調査とイベント前後での調査とを組み合わ |
| せて、その変化が適切に把握できるような河床材料調査を行うことになる。 |
|                                                                      |
| 17. 洪水流に対する植生等の変化                                       |
|                                                                      |
| 洪水時の河床材料の移動や                                             |
| 植物体に作用する流体力による植物の破壊・流失、樹木の倒伏・流失等、そ |
| れによる群落の流失や縮小は、場合によって把握すべき重要な項目となる。 |
|                                                                      |
| 流木に代表される                                                     |
| 植物体の集積なども同様である。出水前後の空中写真や河道内植物群落調査 |
| 等から、植物群落の流失や変状の実態を整理することが基本になるが、実際 |
| に生じた変化と課題・目的を踏まえ、より詳細な変化状況を関連事象と併せ |
| て把握できるように、調査法を工夫・拡充する必要が出てくる場合もある。 |
|                                                                      |
| これには、たとえば、個々の樹木等の変化まで追跡でき                   |
| るような調査の詳細度、位置精度の向上、洪水中の変状を探知する工夫、こ |
| れらを含め、洪水生起前からの調査及び機器設置等の工夫・充実等がある。 |
|                                                                      |
| 18. 河口砂州のフラッシュ及びその後の回復                             |
|                                                                      |
| 河口砂州については、洪水によるフラッシュの                           |
| 度合いと洪水規模等との関連性を把握すること、また、フラッシュ後の河口 |
| 砂州の回復状況と海象や周辺初期地形を含む諸条件との関係を掴むことが重 |
| 要であり、これらを各時点の砂州状況調査にも反映することが重要である。 |
|                                                                      |
| これには、たとえば、形状把握の詳細度、形状調査の頻度と               |
| タイミング、河口テラスなど周辺地形の測量の範囲や詳細度の設定がある。 |
|                                                                      |
| 19. 河口開口部の変化・河口閉塞                                       |
|                                                                      |
| 河口砂州による開口部の縮小や河口閉塞は、平時                         |
| ・洪水時における水位のせき上げや汽水域の水質等の環境変化等に関連し、 |
| これらの観点から河道特性として把握すべき重要な事項となる場合がある。 |
|                                                                      |
| 平常時における河口開口幅（又は河口の最狭                             |
| 部断面の面積）については、河口部における河川の固有流量と入退潮量（潮 |
| 汐プリズム）を合わせた河口流量（又は開口部の流速）、河口域の波浪等と |
| いった平常時の水理環境（本章[3.5](http://www.yahoo.co.jp)）との関係  |
| が把握できるように、調査法を工夫・拡充する必要が出てくる場合もある。 |
|                                                                      |
| これには、たとえば、平常時の水理環境に関わる各観測と合わせ           |
| た河口部地形測量等の実施、その頻度と調査の範囲・詳細度の設定がある。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

上記に例示した具体例については、下記の資料が参考となる。

1.  末次忠司，藤田光一，服部敦，瀬崎智之，伊藤政彦，榎本真二
    ：[礫床河川に繁茂する植生の洪水撹乱に対する応答・遷移及び群落拡大の特性-多摩川と千曲川の礫河原を対象として-](http://www.nilim.go.jp/lab/bcg/siryou/tnn/tnn0161.htm)，国土技術政策総合研究所資料，第161号，2004.

```{=html}
<!-- -->
```
165. 山本晃一，藤田光一，佐々木克也，有澤俊治：低水路川幅変化における土砂と植生の役割，河道の水理と河川環境シンポジウム論文集，第1回，pp.233-238，1993.

166. 山本晃一：河口処理論〔Ｉ〕－主に河口砂州を持つ河川の場合－，土木研究所資料，第1394号，1978.

167. 田中仁：河口域のながれと地形，日本流体力学会誌｢ながれ｣，第24巻，pp.37-46，2005.

     1.  []{#_Toc382986795 .anchor}経年変化の整理

＜標　準＞

+----------------------------------------------------------------------+
| 河道状況の経年変化の整理は、当該河道の変化の特徴を把握する           |
| ための土台となるものである。以下の基本項目について、各時点のデータを |
| 図化し、経年変化が把握しやすい表示法を採用して重ね書きするなどして、 |
| 河道状況の経年変化を容易に把握できるようにしておくことを標準とする。 |
|                                                                      |
| > 平均河床縦断形                                                     |
| >                                                                    |
| > 最深河床縦断形                                                     |
| >                                                                    |
| > 河川縦断沿い各地点の河床横断形                                     |
| >                                                                    |
| > 横断面内での最深河床の相対位置に関する縦断分布                     |
| >                                                                    |
| > 垂直空中写真                                                       |
| >                                                                    |
| > 河道平面形状                                                       |
| >                                                                    |
| > 代表粒径d~R~の縦断分布（河床材料）                                 |
| >                                                                    |
| > 各調査地点の粒径分布（河床材料）                                   |
| >                                                                    |
| > 低水路川幅、堤間幅の縦断分布                                       |
| >                                                                    |
| > 砂州前縁の平面分布                                                 |
| >                                                                    |
| > 局所洗掘位置の平面分布                                             |
| >                                                                    |
| > 洗掘深の縦断分布                                                   |
| >                                                                    |
| > 植物群落の平面分布                                                 |
| >                                                                    |
| > 樹木群の平面分布                                                   |
| >                                                                    |
| > 構造物の設置位置                                                   |
|                                                                      |
| 以上は、当該河川の河道変化に関する基本的な整理                       |
| の段階に当たる。これに他の調査結果を加え、整理・分析を拡充して行うこ |
| とにより、把握すべき河道変化の全体状況を明らかにしていくことになる。 |
+----------------------------------------------------------------------+

＜例　示＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  上記の整理結果を複数の項目について適切に組み合わせて表示することで、河道変化に関わる河道管理上の課題を比較的簡便かつ俯瞰的に把握できる道具として役立てることができる。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜参考となる資料＞

調査結果の組合せとそれに基づく河道管理については、下記の資料が参考となる。

1.  藤田光一，田上敏博，天野邦彦，服部敦，浦山洋一，大沼克弘，武内慶了：現場での実践を通して河道管理技術を向上させる先駆的取り組み，河川技術論文集，第17巻，pp.539-544，2011.

    1.  []{#_Toc382986796 .anchor}洪水による変化の調査

        1.  []{#_Toc382986797 .anchor}洪水前後の河道状況の比較による場合

＜標　準＞

+----------------------------------------------------------------------+
| 図4-4-1のb)、                                                        |
| c)に当たるような場合は、洪水前後の河道状況の比較によって、洪水によっ |
| て生じた変化についての基本的な情報を得ることができる。このような河道 |
| 変化について概括的情報を得る際には、本節の[4.4](http://www.yahoo.co  |
| .jp)に示した内容を、当該洪水の前後の比較に適用することを標準とする。 |
|                                                                      |
| ただし、この方法では、変化の過程を                                   |
| 把握することはできず、それも知る必要がある場合には、次項[4.5.2](htt  |
| p://www.yahoo.co.jp)の方法を取り入れるなどの検討が必要になってくる。 |
+----------------------------------------------------------------------+

2.  []{#_Toc382986798 .anchor}洪水中の河床変化等の追跡による場合

＜推　奨＞

+----------------------------------------------------------------------+
| 対象とする河道変                                                     |
| 化が図4-4-1のd)のような特性を一定程度以上有している場合には、本節の  |
| [4.5.1](http://www.yahoo.co.jp)に示した方法によっては河道変化を把握  |
| することができず、洪水中の河道変化を追跡する調査が必要となってくる。 |
|                                                                      |
| このような河道変化を特に起こしやすい条件としては、                   |
|                                                                      |
| > 洪水流量が増大すると、土砂流送を起こす掃流                         |
| 力等の空間的不均衡が急激に出現し、その度合いが急増あるいは急変する。 |
| >                                                                    |
| > 洪水流量の増大                                                     |
| に伴い、河床波（中規模河床形態、小規模河床形態）のモードが急変する。 |
|                                                                      |
| のいずれかの条件を満たし、かつ、                                     |
|                                                                      |
| > 洪水流量の変化に対する河床形状変化の追随性が高く、洪水流量         |
| が比較的小さい場合にも一定の土砂流送とそれに伴う河床地形形成が起こる |
|                                                                      |
| という条件を満たすことが挙げられる。                                 |
|                                                                      |
| 具体的には、1番目の観点からは、橋脚、水                              |
| 制、堰、水門などの河川構造物の周りや水衝部など洪水中に局所洗掘が発達 |
| しやすい場所あるいは河口部付近で洪水時だけに低下背水が強く出現するよ |
| うな状況又は河口砂州のある河口部、更には分・合流地点などが、2番目の  |
| 観点からは、洪水の発生に伴い複列砂州から単列砂州へ中規模河床形態のモ |
| ード変化が起こるような河道区間が、こうした特性を持ちやすいと言える。 |
|                                                                      |
| また、3点目の観点からは、洪水流量ハイドロが緩やかであること、河床材  |
| 料（材料ｍ）が砂である河道区間（セグメント類型で言うと2-2や3）である |
| ことが、そうでない場合よりも図4-4-1のd)の特性を持ちやすいと言える。  |
|                                                                      |
| たとえば、洪水中においてのみ局所洗掘が進                             |
| 行し、洪水後にはそれが元に戻ってしまう場合、その実態を把握していない |
| と、構造物の安定性に関する判断が危険側になることも考えられる。こうし |
| たことから、対象とする河道区間が起こし得る洪水中の河床変化の特性が、 |
| 河道管理等にとってどのような意味を持つかを判断することが重要である。 |
|                                                                      |
| 洪                                                                   |
| 水中の河道変化を追跡する調査は必ずしも容易なものではないが、それを把 |
| 握する重要度が高いと判断される場合には、以下に示すような調査手法を活 |
| 用するなどして、洪水中の河道変化を把握するよう努めることが望ましい。 |
+----------------------------------------------------------------------+

＜例　示＞

+----------------------------------------------------------------------+
| 洪水中の河床変動を測定する方法としては、河床にマーカーや計           |
| 測器を埋め込むタイプ、音響測深機などの河床高計を用いるタイプがある。 |
|                                                                      |
| 最大洗掘深と埋め戻り深さは                                           |
| 、リング法、埋設法などのマーカーを埋め込むタイプで調査できる。洗掘の |
| 時間的進行を調べる場合には、埋め込んだセンサーが洗掘深の増加に伴い反 |
| 応する計測器を用いて調査できる。更に埋め戻りも含めた洗掘の時間的変化 |
| についても調べる場合には、音響測深機など河床高計を用いて調査できる。 |
|                                                                      |
| いずれのタイプとも計測位置を                                         |
| 固定する場合には、測定対象位置が明確である反面、その地点での変動調査 |
| にとどまる。したがって、調査対象地点を特定できる場合には有効である。 |
|                                                                      |
| 洗掘域が移動する                                                     |
| など、それに併せて調査対象地点を柔軟に変えていく必要がある調査や、面 |
| 的に広い範囲で洗掘域の挙動を観測するためには、水面から計測する河床高 |
| 計をラジコン船やフロートに搭載して水面を移動させる手法が有効である。 |
|                                                                      |
| この場合、作業員の安全性確保や送受波器をのせるフロート               |
| の操作などに熟練を要し、その適用に当たっては十分な検討が必要である。 |
|                                                                      |
| これらの方法の適用に当たっては、近年蓄積が進んできている調査         |
| ・観測事例を踏まえつつ、当該河道の状況を考慮しながら、目的に応じて適 |
| 切な手法を選択し、調査・観測の内容を組み立てていくことが重要である。 |
|                                                                      |
| なお、洪水中の河床変                                                 |
| 動の把握については、ここで取り上げている直接的な観測法だけでなく、本 |
| 章の[6.5](http://www.yahoo.co.jp)や[第16章](http://www.yahoo.co.jp)  |
| 総合的な土砂管理のための調査 の[2.3.6(1)                             |
| の４）](http://ww                                                    |
| w.yahoo.co.jp)で述べている「一定区間の水理量の詳細な時間・空間変化デ |
| ータと河床変動に関する情報を活用するアプローチ」の活用も考えられる。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

洪水中の河床変化の調査・観測手法については、下記の資料が参考となる。

1.  土木学会水理委員会：水理公式集［平成11 年版］，第2 編河川編第1
    章1.2.4 洪水中の河床高変化pp.78-80，丸善，1999.

    （最新版）土木学会水理委員会：水理公式集［2018年版］，pp.223,
    丸善出版、2019.

    1.  []{#_Toc382986799 .anchor}洪水の作用

        1.  []{#_Toc382986800 .anchor}基本水理量の整理

＜標　準＞

+----------------------------------------------------------------------+
| 河道に変化を引き起こす、また、河道を形成する営力として、洪水の作用に |
| 関わる基本的な水理量を整理しておくことは重要である。ここでは、以下に |
| 示す方法に従って、洪水に関する基本水理量を整理することを標準とする。 |
|                                                                      |
| 1.  対象区間                                                         |
|                                                                      |
| 沖積河道区間～河口                                                   |
| 域を対象とする。必要に応じて、山地河道区間あるいはその一部を含める。 |
|                                                                      |
| 20. 整理対象の洪水規模                                               |
|                                                                      |
| 平均年最大流量を対象とすることを標準とする                           |
| 。その上で、計画高水流量に対応する洪水流量を対象に加え、また、必要に |
| 応じ、この洪水流量と平均年最大流量との間の洪水規模を数段階設定する。 |
|                                                                      |
| さらに、平均年最大流量より小さい規模の出水の影響を考慮す             |
| べき場合には、平均年最大流量より小さい出水規模を１～２段階設定する。 |
|                                                                      |
| ここで、平均年最大流量の下での水理量は、いわゆる                     |
| 河道形成代表流量時の状況把握に、計画高水流量に対応する洪水流量の下で |
| の水理量は、河川整備で対象とする洪水発生時の状況把握に、平均年最大流 |
| 量より小さな規模の出水流量の下での水理量は、主として、平常時から洪水 |
| 時にかけての河床形態のモード変化特性などの把握に、役立つものである。 |
|                                                                      |
| 21. 算出する水理量                                                   |
|                                                                      |
| 以下の項目を、河道縦断方向の各点で算出することを標準とする。         |
|                                                                      |
| > 低水路内平                                                         |
| 均水深h：複断面流れとなっている場合、必要に応じて高水敷平均水深h~fp~ |
| >                                                                    |
| > 低水路内平                                                         |
| 均流速v：複断面流れとなっている場合、必要に応じて高水敷平均流速v~fp~ |
| >                                                                    |
| > 低水路内の流れについてのフルード数F~r~                             |
| >                                                                    |
| > 低水路に関する摩擦速度u~\*                                         |
| ~：複断面流れとなっている場合、必要に応じて高水敷での摩擦速度u~\*fp~ |
| >                                                                    |
| > 低水路                                                             |
| に関する無次元掃流力τ~\*R~：算出の際、粒径には代表粒径d~R~を用いる。 |
| >                                                                    |
| > 低水路幅をBとしたとき、                                            |
| B/h：複断面流れの場合、B~T~/hも必要に応じ算出。ここでB~T~は堤間幅。  |
| >                                                                    |
| > B/B~T~（複断面流れの場合、必要に応じ算出）                         |
| >                                                                    |
| > h/d~R~                                                             |
| >                                                                    |
| > 相対水深Dr                                                         |
| =h~fp~/h（複断面でありかつ蛇行する河道区間の場合、必要に応じて算出） |
|                                                                      |
| 22. 算出法                                                           |
|                                                                      |
| 基本水理量の算出には、[第5章](http://www.yahoo.co.jp)                |
| 河川における洪水流の水理解析                                         |
| の表5-3-1に示した河道特性の把握のた                                  |
| めの水理環境・水理条件の算定を目的とした計算手法を用いるものとする。 |
|                                                                      |
| 23. 整理法                                                           |
|                                                                      |
| 算出した水理量は                                                     |
| 、本章の[2.1.3](http://www.yahoo.co.jp)で説明しているセグメント区分  |
| を示す形で、河川沿いの縦断分布として整理・図化することを標準とする。 |
|                                                                      |
| また、セグメント区分ごとに各諸                                       |
| 量の平均値を整理する。複数の基本水理量を適切に組み合わせて図化するな |
| どして、目的にあった分析が行えるように、更に整理を進めるものとする。 |
|                                                                      |
| 24. 特定の場所についての留意事項                                     |
|                                                                      |
| 河口部や分合流地点、河川構造物等による堰上げ                         |
| の影響が及ぶ区間及びその周辺においては、水理量が洪水流量と一意の関係 |
| を持たず、同じ流量の下でも他の条件によって水理量が有意に変わり得る。 |
|                                                                      |
| このこ                                                               |
| とが、河道特性に与える洪水の作用の分析において重要となる場合がある。 |
|                                                                      |
| このため、上記のような場所を対象にする                               |
| 場合には、水理量に影響を与える洪水流量以外の他の条件を複数設定するな |
| どして、起こり得る洪水の作用を適切に検討できるようにするものとする。 |
|                                                                      |
| この例として、河口部付近の水理量算定において潮位変動幅に応じて       |
| 河口出発水位を複数設定する、合流地点において流量合流パターンを複数設 |
| 定する、水門等の操作のパターンを加味した水理量算定を行うなどがある。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

基本水理量のそれぞれの技術的意味等については、下記の資料が参考となる。

1.  (財)国土技術研究センター：[河道計画検討の手引き](http://www.jice.or.jp/tosho/pdf/kadoukeikaku.pdf)，山海堂，2002.

```{=html}
<!-- -->
```
168. 土木学会水理委員会：水理公式集［平成11 年版］，丸善，1999.

     （最新版）土木学会水理委員会：水理公式集［2018年版］，丸善出版、2019.

169. 山本晃一，(財)河川環境管理財団企画：沖積河川－構造と動態－，技報堂出版，2010.

     1.  []{#_Toc382986801 .anchor}洪水流観測による特性把握

＜考え方＞

+----------------------------------------------------------------------+
| 洪水流の観測については、[第2章](http://www.yahoo.co.jp)              |
| 水文・水理観測の[第3節](http://www.yahoo.co.jp)                      |
| 水位観測及び[第4節](http://www.yahoo.co.jp)                          |
| 流量観測で                                                           |
| 述べているカテゴリー１（基盤・汎用観測）として行われる流量及び水位に |
| ついての種々の観測と、同章の[3.9](http://www.yahoo.co.jp)で述べてい  |
| るカテゴリー２（特定目的観測）として行われる洪水痕跡水位調査が、河道 |
| 特性調査において洪水の作用を把握するための基盤となる情報を提供する。 |
|                                                                      |
| 本節の[5.1](http://www.yahoo.co.jp)に述べてい                        |
| る基本水理量の整理は、これらの情報と[第5章](http://www.yahoo.co.jp)  |
| 河川における洪水流の水理                                             |
| 解析に記述されている洪水流の水理解析手法によって成されるものである。 |
|                                                                      |
| したがって、河道特性調査を適切に行うという観点                       |
| からは、まず、上記のような洪水流に関する基本的情報が提供される状況に |
| あることを確認する、あるいはそうした状況を確保することが必要となる。 |
|                                                                      |
| その上で、基本的な情報だけ                                           |
| では不十分と判断される場合には、河道特性を適切に把握するという目的で |
| 、洪水流に関して行うべき観測を能動的に組み立て実施することも求められ |
| る。そのようなことが生じる場合の代表として、以下の２つが考えられる。 |
|                                                                      |
| 第一は、水位観測を時間・空間の両面で短い間                           |
| 隔で行うことが必要となる場合である。[第2章](http://www.yahoo.co.jp)  |
| 水文・                                                               |
| 水理観測でカテゴリー１として記述している水位観測は、時間変化は細かい |
| ピッチで追うものの、その設置間隔は数km以上と一般に大きい。洪水痕跡水 |
| 位は、縦断方向ピッチは数百mと細かいものの、高い精度は期待できない場  |
| 合があり、また、最高水位の情報しか得られないという大きな制約がある。 |
|                                                                      |
| したがって、水位観測について、これらが提供する基本的情報             |
| だけでは不十分と判断される場合には、[第2章](http://www.yahoo.co.jp)  |
| 水文・水理観測の[第7節](http://www.yahoo.co.jp)                      |
| 河川の流れの総合的把握                                               |
| で記述しているカテゴリー３（総合観測）の「河川の                     |
| 流れの総合的把握」のための洪水観測を適切に実施することが必要となる。 |
|                                                                      |
| つまり、ここにおいて、河                                             |
| 川の流れの総合的把握の実施が、河道特性調査から必要となる場合があると |
| 理解される。こうした検討が必要となる可能性がある場所として、本章の[4 |
| .5.2](http://www.yahoo.co.jp)で例示した、また、本節の[5.1](http://ww |
| w.yahoo.co.jp)で「特定の場所」として例示した河道区間等が挙げられる。 |
|                                                                      |
| 第二は、水位や流量観測以外の水理量を詳細に把握すべ                   |
| き場合であり、その代表的事例として、表面流速の平面分布が挙げられる。 |
|                                                                      |
| 水位の縦断分布とともに表面流速の平面分布は、洪水流を                 |
| 介して、その時点の河道の諸状況を直接的、包括的に反映するものであり、 |
| 河道特性に関わる諸事項を検討する上で有用な情報である。表面流速の平面 |
| 分布の観測については、必要に応じて適切な手法を用いて実施するとよい。 |
|                                                                      |
| 以上のように、通常の洪水観測実施体系で得ら                           |
| れる情報が、対象とする河川の河道特性の調査にとって十分かどうかを吟味 |
| し、不十分な場合には、河道特性調査という観点から付加すべき洪水流観測 |
| 内容を見いだし、適切な手法で実施していくというスタンスが重要である。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

洪水流の表面流速の平面分布の観測手法については、下記の資料が参考となる。

1.  土木学会水理委員会：水理公式集［平成11 年版］，第2 編河川編第1 章4
    節高度画像解析技術を用いた洪水流況の分析，丸善，1999.

    （最新版）土木学会水理委員会：水理公式集［2018年版］，pp.221-224,
    丸善出版、2019.

```{=html}
<!-- -->
```
170. 藤田一郎，河村三郎：ビデオ画像解析による河川表面流計測の試み，水工学論文集，第38巻，pp.733-738，1994.

171. 藤田一郎：実河川を対象とした画像計測技術，2003年度（第39回）水工学に関する夏期研修会講義集，Aコース，pp.A-2-1
     -- A-2-20，2003.

172. 木下良作，宇民正，上野鉄男：画像処理による洪水流解析-阿賀野川における並列らせん流について-，水工学論文集，第36巻，pp.181-186，1992.

173. 宇民正，上野鉄男：複断面蛇行河道における洪水流況と土砂輸送，水工学論文集，第40巻，pp.933-940，1996.

     1.  []{#_Toc326048138 .anchor}土砂流送特性

         1.  []{#_Toc382986803 .anchor}調査の組立ての基本

＜考え方＞

+----------------------------------------------------------------------+
| 土砂流送特性に関する調査として、河                                   |
| 道における土砂収支や上流からの流入土砂量、基準点など代表地点における |
| 通過土砂量等の把握のために、必要に応じて以下の調査を行うものとする。 |
|                                                                      |
| 1.  基本水理量に基づく土砂流送形態の分析                             |
|                                                                      |
|     流砂量観測による調査                                             |
|                                                                      |
|     土砂収支による調査                                               |
|                                                                      |
|     総合観測による調査                                               |
|                                                                      |
| １）は                                                               |
| 河床材料の移動が生じる流量規模と流送形態（掃流・浮遊等）を基本水理量 |
| から推定し、出水時における河床材料の動き方の特徴を捉えるものである。 |
|                                                                      |
| ２）                                                                 |
| は出水時に流送土砂を捕捉することで単位時間あたりの流送量（流砂量）を |
| 観測するものであり、観測時の水理量との関係として整理するものである。 |
|                                                                      |
| ３）はある調査対象                                                   |
| とした河道区間における、所定の期間内における河床変動、掘削などによる |
| 河道外搬出、土砂流入など各量の収支を計算するものであり、年当たりの平 |
| 均的な土砂移動量や河床変動を引き起こした要因の把握を行うものである。 |
|                                                                      |
| ４）は出水期間中における水位の時間                                   |
| 変化の観測を河道縦断方向の複数点で実施し、これら水位の経時変化を河床 |
| 変動の影響も考慮して一致するように実施した河床変動等解析法（[第6章]  |
| (http://www.yahoo.co.jp)）により土砂移動量を明らかにするものである。 |
|                                                                      |
| １）は、図4-4-1に示し                                                |
| た各変化パターンに共通して適用される基礎的情報として用いられる。２） |
| 、４）は、変化パターンｂ）～ｄ）の出水等イベント単位での変化に関する |
| 調査として用いられる。また、３）は変化パターンａ）～ｃ）の中～長期的 |
| な変化に関する調査として用いられる。なお、２）、４）において土砂流送 |
| 量と流量等の洪水時における水理量との関係が得られた場合（[6.3.4](htt  |
| p://www.yahoo.co.jp)参照）には、３）と同様にある一定期間における土砂 |
| 量を算出できるため、中～長期的な変化に関する調査としても用いられる。 |
|                                                                      |
| 上記の各種方法は、得られる情報の質と実施に当たっての労力             |
| が異なる。流送土砂量調査は、必ずしも現地観測に限定することはなく、目 |
| 的に応じて上記方法から選択又は組み合わせて実施することが重要である。 |
+----------------------------------------------------------------------+

1.  []{#_Toc382986804 .anchor}基本水理量に基づく土砂流送形態の分析

＜標　準＞

+----------------------------------------------------------------------+
| 河床材料（材料m）を対象に、Ａ、Ｂ、Ｃ集団（本章                      |
| [2.4.2](http://www.yahoo.co.                                         |
| jp)、[2.4.3](http://www.yahoo.co.jp)参照）ごとに出水時における流送形 |
| 態を推定するものである。その手順としては以下に示すものを標準とする。 |
|                                                                      |
| 1.  対象区間                                                         |
|                                                                      |
| 各セグメント区分を対象とする。                                       |
|                                                                      |
| 25. 整理対象の洪水規模                                               |
|                                                                      |
| 平均年最大流量を対象とする                                           |
| 。その上で、計画高水流量に対応する洪水流量を対象に加え、また、必要に |
| 応じ、この洪水流量と平均年最大流量との間の洪水規模を数段階設定する。 |
|                                                                      |
| 26. 推定対象とする流送形態                                           |
|                                                                      |
| > 移動の有無（Ａ、Ｃ集団のみ）                                       |
|                                                                      |
| 掃流・浮遊（濃度分布あり、一様）の判別                               |
|                                                                      |
| 27. 推定法                                                           |
|                                                                      |
| > 本章[5.1](http://www.yahoo.co.jp)により基本水理量を算出する。      |
| >                                                                    |
| > 材料ｍを本章の[2.                                                  |
| 4.2](http://www.yahoo.co.jp)に述べた方法でＡ、Ｂ、Ｃ集団に区分する。 |
| >                                                                    |
| > 各集団の粒径範囲                                                   |
| が100%となるように粒度分布を引き延ばし、d~60~に相当する粒径を得る。  |
| >                                                                    |
| > 各集団のd~60~相当粒径を用いて、各出水                              |
| 規模における基本水理量から各集団の流送形態を以下に基づいて推定する。 |
|                                                                      |
| 移動の有無の判定（Ａ、Ｃ集団のみ）                                   |
|                                                                      |
| > Ａ（又はＡ′）集団：一様粒径の場合には岩                            |
| 垣式（[第6章](http://www.yahoo.co.jp)の式(6-3-15)）により評価した限  |
| 界掃流力と基本水理量として算定した掃流力を比較して、移動の有無を判定 |
| >                                                                    |
| > Ｃ集団：修正Egiazarof                                              |
| f式（[第6章](http://www.yahoo.co.jp)の式(6-3-25)）により評価した限界 |
| 掃流力と基本水理量として算定した掃流力とを比較して、移動の有無を判定 |
|                                                                      |
| 掃流・浮遊（濃度分布あり、一様）の判定                               |
|                                                                      |
| > 各                                                                 |
| 集団のd~60~相当粒径の沈降速度w~0~をRubey式（[第6章](http://www.yaho  |
| o.co.jp)の式(6-3-33)）又は鶴見式（同じく式(6-3-34)）により評価し、基 |
| 本水理量として算定した摩擦速度と比較して、以下のように流送形態を判定 |
|                                                                      |
| 掃流のみ ：u~\*~/w~0~＜1                                             |
|                                                                      |
| 掃流と浮遊（水深方向濃度分布あり） ：u~\*~/w~0~＜15                  |
|                                                                      |
| 掃流と浮遊（水深方向の浮遊土砂濃度分布がほぼ一様） ：u~\*~/w~0~≧15   |
|                                                                      |
| 28. 整理法                                                           |
|                                                                      |
| 評価した移動の有無、流送形態は、各流量に対                           |
| して算定した掃流力（摩擦速度）の縦断分布に移動判定に用いた限界掃流力 |
| 及び掃流・浮遊の判定に用いた沈降速度を重ね書きした図として整理する。 |
|                                                                      |
| なお、d~84~/d~16~が大きいなど粒径範囲が広い河床材料、二峰性の粒度分  |
| 布を有する河床材料、及び石礫で構成される河床材料などへの修正Egiazaro |
| ff式の適用性について知見が蓄積されてきている。このような知見も適宜参 |
| 考として、各セグメント区分に適した判定手法を用いることが重要である。 |
+----------------------------------------------------------------------+

1.  []{#_Toc382986805 .anchor}土砂流送観測

    1.  []{#_Toc382986806 .anchor}総論

＜考え方＞

+----------------------------------------------------------------------+
| 土砂流送観測は、洪水時に洪水流によって流送                           |
| されている土砂を直接採取し、代表的な試料を選定して粒度分析を行い、そ |
| の結果から洪水時に流送される土砂量を粒径集団別に推定するものである。 |
|                                                                      |
| この調査の位置付け、基本的考え方、調査の組立てについては 第16章      |
| 総合的な土砂管理のための調査                                         |
| の[2.3.6](http:                                                      |
| //www.yahoo.co.jp)に記載されており、これらを踏まえて調査を実施する。 |
|                                                                      |
| ここでは、調査に用いる観測機器とそれを用いた観測の                   |
| 方法、及び水理量と土砂流送量観測結果の関係の整理の仕方について示す。 |
+----------------------------------------------------------------------+

2.  []{#_Toc382986807 .anchor}掃流土砂量調査

＜推　奨＞

+----------------------------------------------------------------------+
| 掃                                                                   |
| 流土砂量調査は、掃流土砂量を観測して、掃流砂量と掃流力との関係を把握 |
| することを目的とするものであり、以下に基づき実施することが望ましい。 |
|                                                                      |
| 掃流採砂器は、掃流土砂量の観測目的に応じて適当なも                   |
| のを使用するものとし、また、掃流砂量と掃流力との関係を求めるため、水 |
| 深、水面勾配、流速、流量、横断面形状等の測定及び河床材料調査を行う。 |
|                                                                      |
| 採砂器の具備すべき条件は、                                           |
| 流れを乱さずに掃流砂の移                                             |
| 動状況を変えないで採砂できることであり、このためには、流入口でできる |
| だけ抵抗の小さいことと採取口が河床にうまく接地することが重要である。 |
|                                                                      |
| 観測記録より単位時間当たりの土砂流送量                               |
| （掃流砂量）などについて整理するものとする。また、採取した試料を乾燥 |
| 器で乾燥させた後秤量し、更に、代表的な試料を選定して粒度分析を行う。 |
|                                                                      |
| > 掃流土砂量調査の観測回数、 調査断面                                |
|                                                                      |
| 平水時には、同一流量同一地点で原則として10回以上、洪水時には横断     |
| 方向に２点以上の測点を設けて、できる限り多数回、それぞれ採取を行う。 |
|                                                                      |
| 調査断面の選定においては、採砂器の操作が容                           |
| 易なことや、水理量の観測も同時に行える地点であることなども考慮する。 |
+----------------------------------------------------------------------+

3.  []{#_Toc382986808 .anchor}浮遊土砂量調査

＜推　奨＞

+----------------------------------------------------------------------+
| 浮遊土砂量調査は、浮遊砂量を観測して浮遊砂量と掃流力や流量との関     |
| 係を把握しようとするものであり、以下に基づき実施することが望ましい。 |
|                                                                      |
| 浮遊土砂量の観測に当たっては、適当な採水器を使用する                 |
| 。また、浮遊砂量と掃流力や流量との関係を求めるため、水深、水面勾配、 |
| 流速分布、流量、横断面形状等を測定する。                             |
|                                                                      |
| 採                                                                   |
| 水器の具備すべき条件は、乱されない資料が採取できること、流れの乱れの |
| 規模に応じ、ある程度平均的な土砂濃度で採取できるように採水時間の長い |
| こと、採取口径は浮遊土砂最大粒径の少なくとも５倍以上であることなどで |
| ある。また、資料を資料ビンに移すときに採砂器内に砂粒が残らないように |
| する必要があり、資料ビンから取り出すときにも同様な注意が必要である。 |
|                                                                      |
| 浮遊土砂の観測は、                                                   |
| 採水器による鉛直方向の濃度分布の測定により行                         |
| うものとし、同時に鉛直方向の流速分布を測定しておくものとする。なお、 |
| 水深方向の濃度分布が一様とみなせる水理量（本節[6.2](http://www.yaho  |
| o.co.jp)参照）の下では、水深方向分布の測定を簡略化することができる。 |
|                                                                      |
| > 浮遊土砂の観測、 調査断面                                          |
|                                                                      |
| 横断方向の測線数は、                                                 |
| 河川の状況に応じて選定するものとするが、原則として３測線以上とする。 |
|                                                                      |
| 観測に当たって、流砂                                                 |
| の濃度が大きくなる河床付近の測定は、河床からの高さ、流速測定とともに |
| 特に精度の確保に努める。なお、測定においては、採水時刻、採水量、採水 |
| 時間、採水点の流速、水深、水面勾配、水温等を記録し、採取した資料を全 |
| 量採水ビンに移しかえる。調査地点においては、河床材料調査を実施する。 |
|                                                                      |
| 観測記録から単位幅当たりの浮遊土砂量（浮遊砂量）を整理する。まず     |
| 、採水した資料からその含砂率を測定する。含砂率を求めるには、たとえば |
| 、採取した水の重量を測定し、水が澄むまで最小限24時間静置し、次に上澄 |
| 液を排除し、後に残った沈澱物を乾燥し秤量する。浮遊土砂量は、各点にお |
| ける含砂率と流速の積を算定し、それを水深方向に積分することで求める。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

流砂量観測を実施する際には、下記の資料が参考となる。

1.  国土技術政策総合研究所環境研究部，(独)土木研究所水環境研究グループ自然共生センター：[ダムと下流河川の物理環境との関係についての捉え方](http://www.nilim.go.jp/lab/bcg/siryou/tnn/tnn0521.htm)，国土技術政策総合研究所資料，第521号，土木研究所資料，第4140号，第5章
    調査・分析に関する事項 pp.5-50－5-53，2009.

    1.  []{#_Toc382986809 .anchor}水理量と土砂流送量観測結果の関係の整理

＜例　示＞

+----------------------------------------------------------------------+
| 各観測地点にお                                                       |
| ける水理量（掃流力、摩擦速度）と掃流砂量及び浮遊砂量との関係を第6章  |
| 河床変動、河床材料変化及び土砂流送の解析の[3.5](http://www.y         |
| ahoo.co.jp)、[3.7](http://www.yahoo.co.jp)に例示した式から算定される |
| 掃流砂量及び浮遊砂量と比較できるように整理し、流砂量の直接観測結果の |
| 補完を行うための流砂量式の設定のための参考データとすることができる。 |
|                                                                      |
| なお、通過型の土砂を扱う場合、その場所の河床に作用                   |
| する力に関わる水理量及び河床材料と土砂流送量との対応関係は薄くなるの |
| で、上記の関係整理に代えて流量と土砂流送量の関係として整理する**。** |
+----------------------------------------------------------------------+

1.  []{#_Toc318238939 .anchor}土砂収支による調査

＜例　示＞

+----------------------------------------------------------------------+
| 土砂収支による調査は、セグメントスケールの一連の河道                 |
| 区間を対象として、その区間への流入土砂量、区間内での河床変動量及び河 |
| 道掘削等による土砂の河道内外への搬入・搬出量について収支を計算し、そ |
| の差分として区間下流への粒径集団別の土砂流送量を推算するものである。 |
|                                                                      |
| 本調査では、セグメントスケールで                                     |
| の地形変化が有意に生じると期待される10年オーダーの期間にわたる河床変 |
| 動等に関するデータを用いて、その期間内の平均的な年当たり土砂流送量を |
| 粒径集団別に推算するのが一般的である。ただし、大規模出水によりセグメ |
| ントスケールで顕著な河床変動が生じた場合には、その出水前後の河床形状 |
| 等データから当該出水による土砂流送状況を推定することにも適用できる。 |
|                                                                      |
| 流入土砂量は、たとえば当該区間の上流域に                             |
| 設置されたダム貯水池などへの土砂堆積量に、その施設上流の流域面積と残 |
| 流域の面積の比を乗じることにより推定することができる。施設などへの土 |
| 砂堆積量、区間内の河床変動量、河道内外への搬入・搬出量といった各項目 |
| の調査の基本的な考え方等については、[第16章](http://www.yahoo.co.jp) |
| 総合的な土砂管理のための調査                                         |
| の[2.3.2](http://www.yahoo.co.jp)、[2.3.3](http                      |
| ://www.yahoo.co.jp)、[2.3.5](http://www.yahoo.co.jp)に記載している。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

大規模出水による土砂流送状況の推定の事例として下記の資料が参考となる。

1.  高橋邦治，服部敦，藤田光一，宇多高明：大規模洪水による粒径集団別の水系内土砂移動，土木学会第51回年次講演会，pp.624-625，1996.

    1.  []{#_Toc382986811 .anchor}総合観測による調査

＜考え方＞

+----------------------------------------------------------------------+
| カテゴリ-3.1「河川の流れの総合的把握」（第2章 水文・水理観測         |
| [第1節](http://www.yahoo.co.jp) 総説                                 |
| 参照                                                                 |
| ）に属する調査であり、水位の簡易観測([第2章](http://www.yahoo.co.jp) |
| [第3節](http://www.yahoo.co.jp) 水位観測                             |
| 参照)により得た多点での水位連                                        |
| 続観測データと河床変動等の解析手法（[第6章](http://www.yahoo.co.jp)  |
| 河床変動、河床材料変化及び土砂流送の解析                             |
| 参照）とを組み合わせて流                                             |
| 送土砂量の推定を行うものである。その手法の概略は以下のとおりである。 |
|                                                                      |
| 使用する現地観測データは、多点に設置された水位計                     |
| による水位縦断分布の時間変化、その観測区間内又は近傍において同期間に |
| 観測した流量の時間変化、及び出水前後の河床形状である。そのほかに必要 |
| な情報として、流れの解析に用いる粗度係数及び樹木群等の配置等、及び河 |
| 床変動等の解析に用いる河床材料等の各解析に入力するデータ一式である。 |
|                                                                      |
| これらデータ・情報に基づいて、対象河道の河床変動特性に応じた適切な河 |
| 床変動等の解析手法を選定し、出水前の河床形状を初期河床形状として、水 |
| 位・流量の観測データを境界条件として河床変動等の計算を実施する。また |
| 、出水中の各時点における水位縦断分布と出水後の河床形状とを比較し、十 |
| 分な再現性が得られるよう、必要に応じて河床変動等の解析の較正を行う。 |
|                                                                      |
| これら手順を経た解                                                   |
| 析結果は、出水中の河床変動、土砂流送についてもある一定の水準で再現し |
| ているとの考え方に基づいて、解析結果として得た流送土砂量を整理する。 |
|                                                                      |
| この手法から                                                         |
| 推定される土砂流送量は、混合型（河床材料起源の流送土砂）のみである。 |
|                                                                      |
| 本手法                                                               |
| は主に水位縦断分布の時間変化を介して河床状況を推定するものであるため |
| 、流れの解析においては特に粗度係数を適切に設定することが重要である。 |
|                                                                      |
| また、河床変動等の解析について直接的に                               |
| 再現性を検証しているのは出水後の河床形状のみであるため、必要に応じて |
| 出水中の河床変動及び土砂流送量を観測して検証に加えることで、土砂流送 |
| 量の推定精度を確認し、さらに向上につなげていくことが望ましい（第6章  |
| 河床変動、河床材料変化及び土砂流送の解析                             |
| [5.3](http://www.yahoo.co.jp) 参照）。                               |
+----------------------------------------------------------------------+

1.  []{#_Toc382986812 .anchor}河道を取り巻く諸状況

    1.  []{#_Toc382986813 .anchor}流域・水系環境及びその変遷の整理

        1.  []{#_Toc382986814 .anchor}流域の概要

＜考え方＞

+----------------------------------------------------------------------+
| 調査対象とする河川の                                                 |
| 全体像を俯瞰的に把握するためには、その流域に関する基礎情報を収集・整 |
| 理することが有用である。そのような情報として以下の項目が挙げられる。 |
|                                                                      |
| 1.  流域平面図と主要諸元                                             |
|                                                                      |
|     流域の地形・地質                                                 |
|                                                                      |
|     水文特性                                                         |
|                                                                      |
|     ダム・砂防堰堤等の整備状況                                       |
+----------------------------------------------------------------------+

1.  []{#_Toc382986815 .anchor}流域平面図と主要諸元

＜標　準＞

+----------------------------------------------------------------------+
| 調査対象とする河道区間の流域全体の河道網におけ                       |
| る位置とその区間に接続する支川を把握するために流域平面図を活用すると |
| ともに、各川からの降雨流出や土砂供給に関わる影響の大きさを推定するに |
| 当たっての基礎情報となる以下の事項について整理することを標準とする。 |
|                                                                      |
| 1.  本支川の流域面積と山地が占める割合（又は面積）・幹線流路延長     |
|                                                                      |
|     想定氾濫区域の面積と人口                                         |
|                                                                      |
|     既設ダムの流域面積とそれが各川の山地面積に占める割合             |
|                                                                      |
|     流域の土地利用状況                                               |
+----------------------------------------------------------------------+

1.  []{#_Toc382986816 .anchor}流域の地形･地質

＜標　準＞

+----------------------------------------------------------------------+
| 流域の山地部からの降雨流出及び土砂供給の相対的な大きさについ         |
| て定性的に把握するために以下の事項について整理することを標準とする。 |
|                                                                      |
| 1.  地盤高                                                           |
|                                                                      |
|     表層地質（地質分類）                                             |
|                                                                      |
| また、平野部については、洪水氾濫特性や河道変遷に伴う微地形           |
| 等を把握するために有用な以下の事項について整理することを標準とする。 |
|                                                                      |
| 1.  治水地形分類                                                     |
|                                                                      |
| 2.  推定氾濫域                                                       |
+----------------------------------------------------------------------+

＜参考となる資料＞

流域の地形・地質等の把握には、下記の資料が参考となる。

・国土地理院監修：地形図，メッシュ情報（国土細密数値情報）.

・経済企画庁監修：土木地質図（各都道府県）.

　（最新版）国土数値情報ダウンロードサイト，土地分類調査・水調査，表層地質図.

・経済企画庁監修：表層地質図（各都道府県）.

　（最新版）国土数値情報ダウンロードサイト，土地分類調査・水調査，表層地質図.

・国土地理院：[治水地形分類図](http://disapotal.gsi.go.jp/tisuitikei/index.html).

1.  []{#_Toc382986817 .anchor}水文特性

＜推　奨＞

+----------------------------------------------------------------------+
| 調査対象とした河道区間に接続する各流域からの                         |
| 出水をもたらした既往の降雨イベントごとの寄与の大きさについて大まかに |
| 把握するための基礎情報として、既往最大の流量・降水量を記録した出水等 |
| の主たる出水を対象として、以下の事項について整理することを推奨する。 |
|                                                                      |
| > 各降雨イベントの総雨量等の平面分布図                               |
| >                                                                    |
| > 主要基準点やダム流域等のハイエトグラフ                             |
|                                                                      |
| また、各河川の流量観測地点の年最大流量の経年変化について整理する。   |
|                                                                      |
| 以上の整理に当たっては、第2章                                        |
| 水文・水理観測の[第2節](http://www.yahoo.co.jp)                      |
| 降水量観測によるデータを用いる。なお、流量観測データが存在しな       |
| い場合は、流出計算に基づき算出した値をもって整理することが望ましい。 |
+----------------------------------------------------------------------+

2.  []{#_Toc382986818 .anchor}ダム・砂防堰堤等の整備状況

＜推　奨＞

+----------------------------------------------------------------------+
| ダム、砂防堰堤の整備進捗に                                           |
| 伴って山地部からの土砂供給量や出水規模による土砂供給量の変動を平準化 |
| するなどの供給パターンの変化に対して河道が応答することも考えられる。 |
|                                                                      |
| これらに対する                                                       |
| 検討のための基礎情報として以下の事項について整理することを推奨する。 |
|                                                                      |
| > 砂防堰堤（不透過型、透過型）                                       |
| >                                                                    |
| > 既設ダム（貯留型ダム、流水型ダム）                                 |
| >                                                                    |
| > 利水用取水施設（農・工・上水用、発電用）                           |
+----------------------------------------------------------------------+

1.  砂防堰堤（不透過型・透過型）

＜推　奨＞

+----------------------------------------------------------------------+
| 調査対象区間の河道                                                   |
| 区間上流等に設置されている砂防堰堤は、現在の土砂供給特性を把握するた |
| めに重要な情報であることから、以下について調査を行うことが望ましい。 |
|                                                                      |
| > 堰堤の構造                                                         |
| >                                                                    |
| > 堆砂の状況（堆積する土砂粒径、堆砂形状、堆砂量）                   |
| >                                                                    |
| > 堰堤上下流（いずれも流水区間）の河床材料                           |
| >                                                                    |
| > 砂防指定区域の状況                                                 |
+----------------------------------------------------------------------+

40. 既設ダム（貯留型ダム、流水型ダム）

＜推　奨＞

+----------------------------------------------------------------------+
| 調査対象の河道区間上流にダムが存在する場合、ダム供用年数にもよる     |
| が、既にその河道区間は既設ダムの影響を受けた区間である場合が考えられ |
| る。既設ダムが存在する場合は、以下について調査を行うことが望ましい。 |
|                                                                      |
| > 既設ダムの建設年、供用期間                                         |
| >                                                                    |
| > 既設ダムの洪水調節方式（計画）及び流量調節実績                     |
| >                                                                    |
| > 既設ダムの平常時放流量及び減水区間の有無とその延長                 |
| >                                                                    |
| > 既設ダムの堆砂状況                                                 |
+----------------------------------------------------------------------+

41. 利水用取水施設

＜推　奨＞

+----------------------------------------------------------------------+
| 利水用取水施設は、大きく「                                           |
| ダム型」と「堰堤型」に分けられる。このうちダム型は、主に農業用ダムや |
| 水力発電用ダムとして供用されており、堤高15m以上の貯留型構造である。  |
|                                                                      |
| ダム型は土砂を止めるという観点で見れば、基本的に前出の (2) 既設ダム  |
| と同じインパクトであることから、 (2) 既設ダム                        |
| と同様に調査を                                                       |
| 行うことが望ましい。「堰堤型」については、以下では「利水堰」と呼ぶこ |
| ととし、存在する場合には、以下の状況について調査することが望ましい。 |
|                                                                      |
| > 利水堰の建設年、使用期間                                           |
| >                                                                    |
| > 利水堰の構造(ゲート敷高と河床高の関係)                             |
| >                                                                    |
| > 利水堰の運用方法（開閉操作規定）                                   |
| >                                                                    |
| > 湛水池の堆砂状況（湛水池河床高、堆砂量と経年変化）                 |
| >                                                                    |
| > 湛水池の河床材料                                                   |
| >                                                                    |
| > 湛水池上下流（いずれも流水区間）の河床材料                         |
+----------------------------------------------------------------------+

1.  []{#_Toc382986819 .anchor}河川整備及びその他の河道状況の整理

    1.  []{#_Toc382986820 .anchor}主たる出水と河道計画・河川改修履歴

＜推　奨＞

+----------------------------------------------------------------------+
| 河川等の計画の改定の契                                               |
| 機となった出水、浸水被害の大きな出水等と河道計画・河川改修に関する基 |
| 礎情報として、以下の事項について年表形式等で整理することを推奨する。 |
|                                                                      |
| > 主たる出水の最大                                                   |
| 流量、被害の概略（[7.2.2](http://www.yahoo.co.jp)に述べる主たる出水  |
| 時の破堤地点と氾濫浸水域に関する情報と併せて整理することが望ましい） |
| >                                                                    |
| > 河道計画の変遷史（計画改定の時期と概要）                           |
| >                                                                    |
| > 河川改修履歴（ダム竣工や河道改修の竣工年）                         |
+----------------------------------------------------------------------+

2.  []{#_Toc382986821 .anchor}河道変遷

＜推　奨＞

+----------------------------------------------------------------------+
| 現況河道に至るまでの河                                               |
| 道の幅や平面形状の人的改変の度合いや、河道の位置が長期間にわたって動 |
| きが少なく安定している箇所等について河道変遷を把握するための基礎情報 |
| として、地形発達史、歴史的記録、治水地形分類図、迅速図や空中写真など |
| に基づいて河道平面形状の変遷について図化して整理することを推奨する。 |
|                                                                      |
| また、歴史的大出水について歴史的記録を収集                           |
| し、被害の状況や破堤地点及び氾濫範囲等について整理するのが望ましい。 |
+----------------------------------------------------------------------+

3.  []{#_Toc382986822 .anchor}河道掘削・砂利採取

＜推　奨＞

+----------------------------------------------------------------------+
| 河道掘削、砂利採取などの影                                           |
| 響について把握することを目的として、以下の調査を行うことが望ましい。 |
|                                                                      |
| > 工事範囲及びその工法（仮設工法を含む）                             |
| >                                                                    |
| > 過去（近年）の工事実施の有無                                       |
| >                                                                    |
| > 土砂掘削位置及びその期間                                           |
| >                                                                    |
| > 土砂掘削量及びその時期                                             |
| >                                                                    |
| > 掘削した材料の粒径                                                 |
+----------------------------------------------------------------------+

4.  []{#_Toc323196195 .anchor}河道表層下の土層構造調査

＜推　奨＞

+----------------------------------------------------------------------+
| 表層の河床材料の層                                                   |
| 厚、及び表層下の岩盤、軟岩など固結物・半固結物、粘性土、砂層など表層 |
| とは異なる材料で構成される層の上面の深さと層厚について河道縦断方向の |
| 分布を把握するため、表層下の土層構造について調査することを推奨する。 |
|                                                                      |
| 一般的には、河川堤防の基礎地盤ボーリング調査結果など                 |
| 既存資料を活用して地質縦断分布を左右岸に分けて整理するのが望ましい。 |
| その際、岩盤等の露出箇所（本章の[3.4.4](http://www.yahoo.co.jp)参照  |
| ）を地質縦断分布図に記載し、露出している層を特定することを推奨する。 |
+----------------------------------------------------------------------+

1.  []{#_Toc382986824 .anchor}調査結果の取りまとめ及び包括分析

    1.  []{#_Toc382986825 .anchor}河道特性調査結果の整理

＜標　準＞

  ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  河道特性調査の結果は調査項目ごとに整理し、各種調査の実施に併せて適宜更新することを標準とする。その書式については統一しておき、空間的変化（縦断方向の変化）・時間的変化の分析が容易なように整理する。それらの実施に当たっては [第23章](http://www.yahoo.co.jp) 調査結果の保存・活用 に基づくことを標準とする。
  ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜例　示＞

+----------------------------------------------------------------------+
| 河道特性調査の整理項目を以下に例示する。                             |
|                                                                      |
| ①河道状況に関する基礎データ（測量・調査データの蓄積）                |
|                                                                      |
| > 河道形状（横断測量、平面測量、空中写真）                           |
| >                                                                    |
| > 河口部の地形（深浅測量、海浜測量、汀線測量、河口部縦横断測量）     |
| >                                                                    |
| > 河床材料                                                           |
| >                                                                    |
| > 河岸・高水敷材料                                                   |
| >                                                                    |
| > 岩盤・軟岸など固形物・半固形物、粘着性材料調査                     |
| >                                                                    |
| > 河口の河床・底質材料                                               |
| >                                                                    |
| > 植生繁茂状況                                                       |
| >                                                                    |
| > 平常時の水理環境                                                   |
| >                                                                    |
| > 土砂流送（土砂流送観測、土砂収支調査、総合観測調査）               |
| >                                                                    |
| > 河道表層下の土層構造                                               |
| >                                                                    |
| > 構造物の設置状況                                                   |
| >                                                                    |
| > その他                                                             |
|                                                                      |
| ②河道の現況と経年変化に関する情報（基礎データの整理）                |
|                                                                      |
| > 河床高縦断形（平均・最深）                                         |
| >                                                                    |
| > 各地点の河道横断形状                                               |
| >                                                                    |
| > 最深河床の位置を示した平面分布                                     |
| >                                                                    |
| > 低水路川幅、堤間幅の縦断変化                                       |
| >                                                                    |
| > 河道平面図                                                         |
| >                                                                    |
| > 河川垂直空中写真                                                   |
| >                                                                    |
| > 河口砂州の平面形状                                                 |
| >                                                                    |
| > 河口砂州の最高部に沿った横断形状                                   |
| >                                                                    |
| > 中規模河床波の平面分布                                             |
| >                                                                    |
| > 局所洗掘位置の平面分布                                             |
| >                                                                    |
| > 洗掘深（平均と最深の差）の縦断分布                                 |
| >                                                                    |
| > 河床材料の代表粒径縦断分布・各地点の粒度分布                       |
| >                                                                    |
| > 河口砂州・河口テラスの粒度分布                                     |
| >                                                                    |
| > 河口砂州のフラッシュ                                               |
| >                                                                    |
| > 河口開口幅（河口閉塞）                                             |
| >                                                                    |
| > その他                                                             |
|                                                                      |
| ③洪水の営力・土砂流送に関する情報                                    |
|                                                                      |
| > 平均水深h（低水路・高水敷）                                        |
| >                                                                    |
| > 平均流速v（低水路・高水敷）                                        |
| >                                                                    |
| > フルード数F~r~（低水路）                                           |
| >                                                                    |
| > 摩擦速度u~\*~（低水路・高水敷）                                    |
| >                                                                    |
| > 河床代表粒径に対する無次元掃流力τ~\*R~                             |
| >                                                                    |
| > エネルギー勾配I~e~                                                 |
| >                                                                    |
| > 低水路の幅と平均水深の比、堤間の幅と堤間平均水深の比               |
| >                                                                    |
| > 水深と代表粒径の比（低水路）                                       |
| >                                                                    |
| > 相対水深Dr（複断面でありかつ蛇行する河道区間が対象）               |
| >                                                                    |
| > 掃流力（摩擦速度）に河床材料の限界掃流力及び沈降速度の比較図       |
| >                                                                    |
| > その他                                                             |
|                                                                      |
| ④流域・河道の変遷・水文特性に関する情報                              |
|                                                                      |
| > 流域概要（流域の主要諸元、地形・地質、ダム・砂防堰堤の整備状況等） |
| >                                                                    |
| > 水文特性（主たる出水の降水量、流量と水位等）                       |
| >                                                                    |
| > 河川整備及び河道状況（主たる出水及び河道計画・河川改修             |
| の履歴、河道変遷、河道掘削・砂利採取、堤防・河川構造物の整備状況等） |
| >                                                                    |
| > その他                                                             |
+----------------------------------------------------------------------+

＜参考となる資料＞

河道特性調査の整理については、下記の資料が参考となる。

1.  (財)河川環境管理財団河川環境総合研究所：河川環境特性情報情報編集とその展開，河川環境総合研究所資料，第22号，2007.

    1.  []{#_Toc318630902 .anchor}河道特性調査結果の包括分析

＜考え方＞

+----------------------------------------------------------------------+
| 河道特性に関する第3～7節の調査結果を総合して、以下の包括分析を行う。 |
|                                                                      |
| １）現況河道に関する分析                                             |
|                                                                      |
| 現況の河道を対象として、河道の各構成                                 |
| 要素の諸元（本節[8.1](http://www.yahoo.co.jp/)の①、②）と基本水理量（ |
| 同じく③）との関連性について分析する。この場合、基本水理量としては、  |
| いわゆる河道形成に関わる代表値として、平均年最大流量時の値を用いてよ |
| い。なお、多様な流量規模の影響については、２）において別途検討する。 |
|                                                                      |
| 関連性の把握は、河道の階層構造の考え方（本章[2.1.1](htt              |
| p://www.yahoo.co.jp)参照）に基づいて階層単位で行うこととする。すなわ |
| ち、同一階層に属する構成要素を一つのグループとして、それら相互作用も |
| 考慮して、各要素と基本水理量との関係について調べる。その際、より上位 |
| 階層に属する構成要素の諸元については所与の条件として取り扱ってよい。 |
|                                                                      |
| ２）出水の規模・履歴に応じた河道変化に関する分析                     |
|                                                                      |
| 洪水に起因する河道の変化に関する調査結果（たとえば本章[4.3](http://  |
| www.yahoo.co.jp)の調査）を対象として、出水前後の各諸元と当該出水時の |
| 基本水理量との関係について分析する。その際、１）の関係と重ね合わせて |
| 、各諸元が現況での関係からどのような方向・大きさで変化が生じるのか、 |
| 出水の大きさに応じて把握することが重要である。さらに、その変化を既往 |
| 出水の履歴に沿って追跡することで、どのような経路で現況の関係に到達し |
| たのか理解することは、今後の中長期の河道応答を予測する上で役に立つ。 |
|                                                                      |
| ３）河道の経年変化に関する分析                                       |
|                                                                      |
| 流域の変遷や河川整備等（本節[8.1](h                                  |
| ttp://www.yahoo.co.jp/)の③）に付随して河道特性に経年的な変化が生じて |
| いる。まず、その実態を明らかにする目的で、河床高、河床材料、川幅、河 |
| 道平面形状、砂州等の個々の経年変化と、それらを組み合わせた河道の全体 |
| 的な変化履歴を整理することが重要である。さらに、この変化履歴に関する |
| 情報を用いて、２）の出水規模・履歴に応じた河道変化の分析において、流 |
| 域の変遷や河川整備等の影響についても一体的に検討することが望ましい。 |
|                                                                      |
| ４）他河川との比較                                                   |
|                                                                      |
| こうし                                                               |
| て得た情報について、他河川の同一セグメント類型に属する河道区間と比較 |
| することにより、複数河川で共通する特性と当該河川のみに見られる個別の |
| 特性に区分することができる。共通する特性について複数河川の情報と総合 |
| することは、より普遍的な特性把握とそれに基づくより確度の高い技術的判 |
| 断に繋がるため、積極的に実施することが重要である。また、個別の特性に |
| ついては、それを生じせしめる原因や規定している要因を見いだすことが、 |
| 当該河川に適合した計画・設計・維持管理等を行っていく上で重要である。 |
|                                                                      |
| 上記の包括分析の具体の手法に                                         |
| ついては、各河川の河道特性や既得の情報レベルに応じて変化するので、定 |
| 型的な手法の整理には馴染まず、それらに応じて分析手法を適宜設定する。 |
|                                                                      |
| 包括分析によって得た情                                               |
| 報について、洪水流・流砂に関する水理的知見に基づいて解釈を深めて普遍 |
| 性を高めること、さらに解析モデル化して定量的に再現・予測を行うことが |
| 必要とされる場合がある。その際には、[第6章](http://www.yahoo.co.jp)  |
| 河床変動、河床材料変化及び土砂流送の解析 に基づいて検討するとよい。  |
+----------------------------------------------------------------------+

＜参考となる資料＞

河道特性調査の包括的分析については、下記の資料が参考となる。

1.  山本晃一，(財)河川環境管理財団企画：沖積河川－構造と動態－，技報堂出版，2010.

```{=html}
<!-- -->
```
174. 福岡捷二：治水と環境の調和した治水適用策としての河幅,断面形の検討方法，河川技術論文集，第16巻，pp.5-10，2010.

175. Biedenharn, D.S., Watson, C.C. and Thorne, C.R. ：Fundamentals of
     Fluvial Geomorphology，Sedimentation Engineering，No.110，Chapter6
     ASCE Manuals and Reports on Engineering Practice pp.355-386 ，2007.

第5章　河川における洪水流の水理解析 {#第5章-河川における洪水流の水理解析 .目次の見出し1}
===================================

目　次 {#目-次-5 .目次の見出し1}
======

[第1節 総説 1](#_Toc298430651)

[第2節 洪水流解析の目的 1](#_Toc288729662)

[第3節 目的に応じた洪水流解析手法の選定 3](#_Toc288729663)

> [3．1 目的に応じた選定 3](#_Toc382986830)
>
> [3．2 最高水位の算定における定常・非定常流解析の使い分け
> 4](#_Toc382986831)

[第4節 計算手法の説明 6](#_Toc382986832)

> [4．1 一次元不等流計算 6](#_Toc288729665)
>
> [4．1．1 定義 6](#_Toc288729666)
>
> [4．1．2 計算方法 7](#_Toc288729667)
>
> [4．2 一次元不定流計算 9](#_Toc288729668)
>
> [4．2．1 定義 9](#_Toc288729669)
>
> [4．2．2 計算方法 9](#_Ref288655019)
>
> [4．2．3 一次元不定流計算の近似解法 10](#_Toc382986839)
>
> [4．3 準二次元不等流計算 10](#_Toc288729671)
>
> [4．3．1 定義 10](#_Toc288729672)
>
> [4．3．2 計算方法 11](#_Toc288729673)
>
> [4．4 準二次元不定流計算 12](#_Toc288729674)
>
> [4．4．1 定義 12](#_Toc288729675)
>
> [4．4．2 計算方法 12](#_Ref288654968)
>
> [4．5 平面二次元流解析 12](#_Toc382986846)
>
> [4．5．1 定義 12](#_Toc288729678)
>
> [4．5．2 計算方法 13](#_Ref288587622)
>
> [4．6 準三次元流解析 14](#_Toc382986849)
>
> [4．6．1 定義 14](#_Toc288729681)
>
> [4．6．2 計算方法 15](#_Toc288729682)
>
> [4．7 三次元流解析 16](#_Toc382986852)
>
> [4．7．1 定義 16](#_Toc288729684)
>
> [4．7．2 計算方法 16](#_Toc288729685)

[第5節 パラメータの設定 18](#_Toc382986855)

> [5．1 パラメータの種類と設定の基本的な考え方 18](#_Toc382986856)
>
> [5．2 粗度係数の設定 18](#_Toc317586149)
>
> [5．3 逆算による同定の方法 19](#_Toc288729688)
>
> [5．3．1 逆算に用いるデータセットの種類 19](#_Toc382986859)
>
> [5．3．2 データセットに応じた同定 19](#_Ref288660429)
>
> [5．4 粗度状況による推定の方法 21](#_Toc288729692)
>
> [5．4．1 推定の基本的な考え方 21](#_Toc382986862)
>
> [5．4．2 出水中の河床変化が顕著でない場合の粗度係数の推定法
> 21](#_Toc382986863)
>
> [5．4．3 小規模河床波の発生を伴う場合の粗度係数の推定法
> 22](#_Toc288729694)
>
> [5．4．4 河川構造物の流体力の推定法 22](#_Toc288729695)

平成26年4月　版

5.  河川における洪水流の水理解析

    1.  []{#_Toc298430651 .anchor}総説

＜考え方＞

+----------------------------------------------------------------------+
| 洪水流の水理解析は                                                   |
| 、所定の流下能力や侵食・洗掘に対する安全性を確保するための河道設計、 |
| 流下能力を維持するための樹木群管理や河積の確保等の維持管理、遊水地の |
| 施設計画等、河川等の計画・設計・維持管理のために実施するものである。 |
|                                                                      |
| 洪水流の水理解析とは、ある形状及び粗                                 |
| 度状況を持つ河道に、上流端において流量又は水位を、下流端において水位 |
| を設定し、その河道内で生じる水位・流量・流速などの水理量の空間的な分 |
| 布及びその時間変化を算定するものである。ここで、粗度状況は、河床表層 |
| の凹凸の状態のことであり、高水敷の地被状況、低水路の河床材料の粒径、 |
| 河床波の形状等がその一例である。なお、背の高い植物の倒伏や河床波の消 |
| 長などに見られるように、流水の作用を受けて粗度状況が変化することもあ |
| り、検討対象とする流量時の粗度状況を的確に表現することが重要である。 |
|                                                                      |
| 解析手法の選定に当                                                   |
| たっては、各種解析手法の原理と特徴、その適用限界などを理解した上で、 |
| 目的を達成するための適切な解析手法を選択する。また、計算を実施するに |
| 当たって、必要となる各種パラメータ、初期条件及び境界条件を設定する。 |
|                                                                      |
| なお、洪水流の水理解析は、実河川で生じ                               |
| る現象を対象としているため、一般的に以下のような制約の下で行われる。 |
|                                                                      |
| 1)  計算に用いる初期条件                                             |
| 及び境界条件が必要な時空間解像度及び精度で得られていない場合がある。 |
|                                                                      |
| 2)                                                                   |
|   洪水流の発生頻度が高くないため、解析結果を検証する機会が限られる。 |
|                                                                      |
| 3)  洪水流の作用により粗度状況（河床波、植生の倒伏・破壊             |
| 状況等）や河道形状が変化し、またその影響が洪水流に及ぶことについて、 |
| 今後とも知見を拡充し、解析の信頼性をより高めていくことが必要である。 |
|                                                                      |
|     本章では、洪水流解析の目的及び目的に応じた洪水流解析手法の選     |
| 定、各解析手法、及びパラメータの設定手法について標準的な方法を示す。 |
+----------------------------------------------------------------------+

1.  []{#_Toc288729662 .anchor}洪水流解析の目的

＜考え方＞

+----------------------------------------------------------------------+
| 河川計画・設計                                                       |
| ・維持管理における洪水流の解析の主な目的は、以下のように整理される。 |
|                                                                      |
| 1)  所与の出水条件の下での最高水位等の洪水位の算定                   |
|                                                                      |
| ```{=html}                                                           |
| <!-- -->                                                             |
| ```                                                                  |
| 4)  構造物等（河岸や樹木を含む）に作用する外力の算定                 |
|                                                                      |
| 5)  水防関係水位の算定                                               |
|                                                                      |
| 6)  河道特性                                                         |
| の把握・河川環境管理・河川利用空間管理のための水理量・水理環境の算定 |
|                                                                      |
| 7)  氾濫計算のための外水氾濫条件の算定                               |
|                                                                      |
| 8)  水位・流量の伝播特性の把握                                       |
|                                                                      |
| 9)  河道変化予測のための水理量の算定                                 |
|                                                                      |
| ```{=html}                                                           |
| <!-- -->                                                             |
| ```                                                                  |
| 1.  所与の出水条件の下での最高水位等の洪水位の算定                   |
|                                                                      |
| 堤防又は河岸（掘込                                                   |
| 河道の場合）近傍の最高水位は、流下能力に直接に関わるため重要である。 |
|                                                                      |
| 最高水位は、一般に流出解析や流量観測等に                             |
| よって得た最大流量を与えた定常流解析により算定する。ただし、対象河川 |
| の洪水伝播に関わる本来的特性や、下流端水位の時間変化特性、分合流ある |
| いは遊水地等による対象河道区間での流量の出入りの状況等によっては、最 |
| 高水位に与える非定常的特性の影響が無視できなくなる場合がある。このよ |
| うな場合には、非定常流解析を用いる。その具体的な判断法については本章 |
| 第3節 目的に応じた洪水流解析手法の選定 [3.2](http://www.yahoo.co.jp) |
| を参照のこと。                                                       |
|                                                                      |
| 26. 構造物等（河岸や樹木を含む）に作用する外力の算定                 |
|                                                                      |
| 流れによって生じる抗力・揚力・せん断                                 |
| 力といった外力の算定に当たっては、構造物の表面に作用する応力分布を定 |
| 常流解析によって算定し、その分布を構造物表面にわたって積分することに |
| より求める方法や抗力係数又は揚力係数を用いた経験式を用いて構造物近傍 |
| の代表流速から求める方法等を用いる。この定常流解析から得られる外力は |
| 、流れ場の時間変動を均した平均値である。目的によっては外力の時間変動 |
| （又は変動の最大値）が必要であり、その場合には非定常流解析を用いる。 |
|                                                                      |
| 27. 水防関係水位の算定                                               |
|                                                                      |
| 水防関係水位とは、                                                   |
| 氾濫危険水位、避難判断水位、氾濫注意水位、水防団待機水位の総称とする |
| 。これらの水位は、築堤状況や堤内地盤高と計画高水位の関係等によって地 |
| 先ごとに設定される値である。水防関係水位の算定とは、地先で設定された |
| 値と洪水予報観測所での水位を対応付けることであり、具体の方法は「危険 |
| 水位の設定要領について」、「特別警戒水位の設定要領について」による。 |
|                                                                      |
| 水防関係水位の算定のためには等流計算、不等                           |
| 流計算、不定流計算等、各河川の状況に応じた適正な計算手法により行う。 |
|                                                                      |
| 28. 河道                                                             |
| 特性の把握、河川環境管理、河川空間管理のための水理量・水理環境の算定 |
|                                                                      |
| 河道特性の把握のための水理量として、河道地形の形成・変               |
| 化特性を考察する上で重要な指標である摩擦速度、川幅水深比など水理量の |
| 縦断分布を算定する。それら算定結果を用いた分析の詳細については第4章  |
| 河道特性調査 第5節 洪水の作用 [5.1](http://www.yahoo.co.jp)          |
| 基本水理量の整理を参照のこと。                                       |
|                                                                      |
| 河川環境管理、河川空間管理のための水理環境として、たとえば動植       |
| 物にとってのハビタット、景観等の形成、変化に関わる水理量を算定する。 |
|                                                                      |
| たとえば植物群落の冠                                                 |
| 水頻度や河床の攪乱頻度については、生起確率が異なる複数の流量に対する |
| 水位や掃流力等が挙げられる。算定する水理量の選定に当たっては、第11章 |
| 河川環境調査 [第2節](http://www.yahoo.co.jp)                         |
| 河川                                                                 |
| における環境調査の手法について、及び[第16節](http://www.yahoo.co.jp) |
| 河川環境の総合的な分析を参照のこと。                                 |
|                                                                      |
| 29. 氾濫計算のための外水氾濫条件（氾濫の生じる流量）の算定           |
|                                                                      |
| 氾濫計算のための                                                     |
| 外水氾濫条件として、越流地点や堤防の決壊点における氾濫流量の算定に用 |
| いる河道内水位等を算定する。その際、[第7章](http://www.yahoo.co.jp)  |
| 浸水解析                                                             |
| 浸水解析における堤内地の浸水解析と連動させ                           |
| て洪水流の解析を行うことで、氾濫に伴う河川流量の増減を考慮できる。こ |
| こで、浸水解析に必要とされる水理量は浸水解析の手法によって異なるため |
| 、洪水流の解析手法の選定に当たっては[第7章](http://www.yahoo.co.jp)  |
| 浸水解析 を参照のこと。                                              |
|                                                                      |
| 30. 水位・流量の伝播特性の把握                                       |
|                                                                      |
| 水位・流量の伝播特性の把握とは、河道の上流端で                       |
| 与えられた水位ハイドロや流量ハイドロが洪水流の流下に伴って変形する過 |
| 程を再現するものである。洪水流は、河道内に存在する狭窄部、樹木群など |
| の影響を受けて、流量に比べて水位の伝播が遅れる場合がある。このような |
| 水位と流量の伝播特性の違いを表現するためには、非定常流解析を用いる。 |
|                                                                      |
| 31. 河道変化予測のための水理量の算定                                 |
|                                                                      |
| 流砂量の算定に必要な掃流力など水理量を算定するもので                 |
| ある。河床変動計算の詳細については、[第6章](http://www.yahoo.co.jp)  |
| 河床変動、河床材料変化及び土砂流送の解析を参照のこと。               |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  危険水位の設定要領について（通知），平成17年5月，国河都第3号，国土交通省河川局治水課都市河川室長.

```{=html}
<!-- -->
```
176. 特別警戒水位の設定要領について（通知），平成17年5月，国河都第4号，国土交通省河川局治水課都市河川室長.

177. 洪水予報河川における避難判断水位の設定要領について，平成18年12月，国河都第4号，国土交通省河川局治水課都市河川室長.

178. 浸水想定区域図作成マニュアル（改訂版），平成 26 年 3
     月，国土交通省水管理・国土保全局河川環境課水防企画室，国土技術政策総合研究所危機管理技術研究センター水害研究室.

     （最新版）国土交通省水管理・国土保全局河川環境課水防企画室，国土技術政策総合研究所河川研究部水害研究室：洪水浸水想定区域図作成マニュアル（第４版），2015（2017年10月部分改定）.

     1.  []{#_Toc288729663 .anchor}目的に応じた洪水流解析手法の選定

         1.  []{#_Toc382986830 .anchor}目的に応じた選定

＜考え方＞

+----------------------------------------------------------------------+
| 洪水流解析として、表5-3-1に示す計算手法を用いる。                    |
|                                                                      |
| 一次元解析\[1DF\]とは、河道横断面内で平均した水                      |
| 理量（水深、流速、河床せん断力など）の縦断分布を算定するものである。 |
|                                                                      |
| 準二次元解析\[2DF\'\]とは、河道横断面を粗度状況や水                  |
| 深等が同一と見なせる区間ごとに分割して等流近似の下で横断方向流速分布 |
| を算定し、この分布を反映した運動量補正係数とせん断力の算定式を一次元 |
| 解析に組み込んで断面平均流速や水位等の縦断分布を算定するものである。 |
|                                                                      |
| 二次元解析\[2DF\]とは、水深方向                                      |
| に平均した水理量を対象として、水理量の平面分布を算定するものである。 |
|                                                                      |
| 準三次元解析\[3DF\'                                                  |
| \]とは、二次元解析を拡張して水深方向に平均した水理量のほか、静水圧分 |
| 布の仮定の下で二次流を含めた水深方向の流速分布を算定するものである。 |
|                                                                      |
| 三次元解析\[3DF\]と                                                  |
| は、非静水圧分布となる流れ場にも適用でき、流水中の任意の位置における |
| 水理量を対象として、その平面及び水深方向の分布を算定するものである。 |
|                                                                      |
| 各解析には、流れ場の空間的分布を算                                   |
| 定する定常計算とさらにその時間変化も計算対象とする非定常計算がある。 |
|                                                                      |
| 洪水流解析の目的 １）～６）に応じて、表5-3-2                         |
| に従って計算手法を選定する。なお、                                   |
| 目的７）の計算手法の選定については、[第6章](http://www.yahoo.co.jp)  |
| 河床変動、河床材料変化及び土砂流送の解析で述べる。                   |
|                                                                      |
| 表5-3-2において＜推奨＞とした計算                                    |
| 手法は、＜標準＞として示す手法では解析対象とした事象を十分に再現する |
| ことができず、＜推奨＞として示す高度な手法を採用する必要がある場合に |
| 選定する。また＜例示＞とした計算手法は、＜標準＞として示す手法より流 |
| れ場の記述レベルが低い手法でも目的を十分に満たす再現性が得られ、＜例 |
| 示＞として示す比較的簡便な手法を採用することができる場合に選定する。 |
|                                                                      |
| 計算手法の選定に当たっては、計算に必要とされる情報の取得             |
| 可能性についても併せて検討することが重要である。なお、目的１)～７）  |
| 以外の目的で洪水流解析を活用する場合でも、表5-3-2の「目的に対して必  |
| 要となる物理量」を参考にして適切な解析手法を目的に合わせて選定する。 |
|                                                                      |
| 1.  洪水流解析に用いる計算手法の一覧（記号は表5-3-2の凡例参照）      |
|                                                                      |
| ![](media/image140.emf){width="4.895833333333333in"                  |
| height="1.6458333333333333in"}                                       |
|                                                                      |
| 2.  目的に対して必要となる物理量と洪水流解析手法の選定               |
|                                                                      |
| ![](media/image141.emf){width="6.208333333333333in"                  |
| height="4.114583333333333in"}                                        |
+----------------------------------------------------------------------+

1.  []{#_Toc382986831
    .anchor}最高水位の算定における定常・非定常流解析の使い分け

＜考え方＞

+----------------------------------------------------------------------+
| 下                                                                   |
| 記１）～４）のいずれにも当たらない場合には、流出解析や流量観測等によ |
| り得た最大流量をあらかじめ与えた定常流解析を用いることが基本となる。 |
| 下記１）～４）のいずれかに該当する場合は、非定常流的特性を解析におい |
| て考慮する必要性が高まるので、非定常流解析を用いることが基本となる。 |
|                                                                      |
| 1)  分合流や遊水地等による流量の出入りの影響がないとできる河道       |
| 区間において、最大流量と最高水位時の流量に有意な差（ズレ）が生じる。 |
|                                                                      |
| 2)  分合流や遊水地                                                   |
| 等による流量の出入りの影響がないとできる河道区間において、各地点の最 |
| 大流量が河川沿いに有意に変化し、それをあらかじめ与えることが難しい。 |
|                                                                      |
| 3)  対象とする河道に、分合流や遊水地等                               |
| による流量の出入りが存在する区間が含まれ、その出入りの量をあらかじめ |
| 与えることができず、非定常流解析によって一体的に計算する必要がある。 |
|                                                                      |
| 4)  対象とする河道に、                                               |
| 分合流や遊水地等による流量の出入りが存在する区間が含まれ、その出入り |
| の流量をあらかじめ与えることができる場合において、その流量の出入りが |
| 、最大流量と最高水位発生のタイミングに有意な差（ズレ）を生じさせる。 |
|                                                                      |
| １）については、河口付近での潮位変化、支                             |
| 川を対象とする場合の本川との合流点付近での水位変化、水門操作による水 |
| 位制御の影響を受ける場合など、解析の境界条件である下流端水位の時間変 |
| 化に起因する場合と、対象河川の洪水伝播に関わる本来的特性による場合が |
| ある。このうち後者に該当するかどうかを判別する考え方について及び２） |
| （これも洪水伝播にかかわる本来的特性                                 |
| に起因する）に該当するかどうかを判別する考え方について以下に述べる。 |
|                                                                      |
| 一様の川幅、勾配の単断面河道を対象とした一波の洪水波の流下に伴う水位 |
| ・流量変化に関する水理特性（非定常性）の要点は、下記のとおりである。 |
|                                                                      |
| -   流下距離の増加に伴って最大水深は                                 |
| 低減するが、水深の増大が生じている期間は長くなる（洪水波形の偏平化） |
|                                                                      |
| -   最大水深の低減は、流下距離が大きくなるほど                       |
| 、水深の時間変化を表す曲線のピーク部形状が尖鋭であるほど、また、河床 |
| 勾配及び断面平均流速（又は洪水波の伝播速度）が小さいほど顕著となる。 |
|                                                                      |
| 　実河川では、上記特性に河道横断形状（複断                           |
| 面）や粗度・河積の縦断的な変化（たとえば樹木群や狭窄部等）等の影響が |
| 加わる。非定常性が顕在化すると、任意の河道断面においては、流量と水深 |
| の関係が図5-3-1a)に一例を示すように明瞭なループを描くようになり、流  |
| 量と水深のピークが現れる時間差が大きくなる。また、流下方向には、図5  |
| -3-2に示すように、洪水流の流下に伴って水深・流量の低減が顕著となる。 |
| こうした特性を踏まえて、洪水伝播にかかわる本来的特性のために非定常流 |
| 解析を使う必要があるかどうかの判断の材料は、以下の2点に集約される。  |
|                                                                      |
| 1.  最                                                               |
| 大流量と最高水位時の流量との差（ズレ）の大きさ（図5-3-1a),b）参照）  |
|                                                                      |
| 2.  河道内流量の出入りのな                                           |
| い一連区間の上下流端での最大流量の差（ズレ）の大きさ（図5-3-2参照）  |
|                                                                      |
| 　流量の差（ズレ）は[第2章](http://www.yahoo.co.jp)                  |
| 水文・水理観測に基づく水位・流量観測結果（カテゴリー1の観            |
| 測等）を用いて評価することができる。①②のいずれかに有意な差（ズレ）が |
| ある場合には、最大流量を与えた定常流解析による最高水位の算定に一定の |
| 誤差が含まれる。その場合、同一の粗度係数を用いた非定常流解析に比べて |
| 最高水位が大きめに算定される傾向を示す。こうした傾向を加味した上で、 |
| 解析の目的を満たす精度で最高水位を得るため、非定常流解析の適用の必要 |
| 性について検討する。なお、②の差（ズレ）については、図5-3-2に示すよう |
| に一連区間を更に細分し、各区間ごとに最大流量を適切に与えることで小さ |
| くすることができる。こうした区間割と最大流量の再設定が可能な場合には |
| 、①の観点から非定常流解析の適用の必要性について検討することでよい。  |
|                                                                      |
| ![](media/image142.emf){width="5.11967738407699in"                   |
| height="2.7291666666666665in"}                                       |
|                                                                      |
| 12. 水位流量曲線図の例                                               |
|                                                                      |
| ![図5-3-2](media/image143.emf){width="3.0in"                         |
| height="2.7083333333333335in"}                                       |
|                                                                      |
| 13. 流下方向への最大流量の低減と区間別の最大流量設定例               |
+----------------------------------------------------------------------+

1.  []{#_Toc382986832 .anchor}計算手法の説明

    1.  []{#_Toc288729665 .anchor}一次元不等流計算

        1.  []{#_Toc288729666 .anchor}定義

＜考え方＞

+----------------------------------------------------------------------+
| 一次元不等流計算\[1DF不等流\]は、流量*Q*を一定とし、基礎式と         |
| して運動方程式に基づく漸変開水路流れを対象とした式(5-4-1)を用いる。  |
|                                                                      |
| > (5-4-1)                                                            |
|                                                                      |
| ここで、*A*は流れの断面積、*x*は流下方向に沿った                     |
| 座標、*H*は水位、*T~r~*は単位長さの河道の河床に作用する力、*u*はある |
| 点での流速、*ρ*は水の密度、*g*は重力加速度である。ここで、左辺第1項  |
| の括弧内は運動量補正係数*β*を用いて式(5-4-2)のように置き換えられる。 |
|                                                                      |
| > ![](media/image145.wmf){width="1.0833333333333333in"               |
| > height="0.2708333333333333in"} (5-4-2)                             |
|                                                                      |
| ここで、*U*は断面平均流速である。                                    |
|                                                                      |
| 一次元不等流計算は、                                                 |
| 断面内の粗度状況が一様及び変化する単断面河道に適用するのを標準とする |
| 。この場合、*β*は一定値（1.0～1.1程度）とする近似的な取扱いを行う。  |
|                                                                      |
| *T~r~*の算定に当たっ                                                 |
| ては、式(5-4-3)に示すManningの平均流速公式を適用するのを標準とする。 |
|                                                                      |
| > (5-4-3)                                                            |
|                                                                      |
| ここで、*I~b~*は河床勾配、*R*                                        |
| (＝*A*/*S*)は径深である。平均流速公式とは                            |
| 、縦断方向に一様な河道断面における等流を想定し、河道断面形と河床勾配 |
| が与えられたときに、平均流速を粗度係数及び径深と関係づける式である。 |
|                                                                      |
| 断面内の粗度状況が一様又は図5-4-1                                    |
| に示すように変化する場合、*T~r~*は式(5-4-4)、(5-4-5)により算定する。 |
|                                                                      |
| > (5-4-4)                                                            |
| >                                                                    |
| > (5-4-5)                                                            |
|                                                                      |
| ここで、*S~i~*は同一の粗度を                                         |
| 有する*i*番目の潤辺部の長さ、*n~i~*はその潤辺部での粗度係数である。  |
|                                                                      |
| ![](media/image149.emf){width="1.96875in"                            |
| height="0.9895833333333334in"}                                       |
|                                                                      |
| 2.  複数の粗度係数を有する河道横断面                                 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  土木学会水理委員会：水理公式集［平成11
    年版］，pp.111-114，丸善，1999.

    （最新版）土木学会水理委員会：水理公式集［2018年版］，pp.199-204,
    丸善出版、2019.

    1.  []{#_Toc288729667 .anchor}計算方法

＜標　準＞

+----------------------------------------------------------------------+
| 式(5-4-1)を差分化し、河道形状、粗度係数、境界                        |
| 条件を適切に与え、標準逐次計算法により数値計算を行うのを標準とする。 |
|                                                                      |
| 計算断面については、距離標ごとに設定するのを標準とする。             |
|                                                                      |
| 支配断面が現れる断面の近傍あるいは大きなエネルギー勾配が             |
| 現れる断面の近傍では、必要に応じて内挿断面を挿入するのを標準とする。 |
|                                                                      |
| 河道形状、河川構造物や樹木群繁茂領域等については、河川               |
| 定期横断測量、河道平面図、航空写真、植生図、樹木群調査の結果（第4章  |
| 河道特性調査 [第3節](http://www.yahoo.co.jp) 各時点の河道状況        |
| 参照）を用いて設定するのを標準とする。                               |
|                                                                      |
| 樹木群                                                               |
| 、河道の急拡・急縮等により死水域が形成される場合には、該当する計算断 |
| 面において死水域に相当する部分を河積から除く。以上の設定手法について |
| は、河道計画の検討の手引き、及び河川における樹木管理の手引きによる。 |
|                                                                      |
| 粗度係数については、本章 [第5節](http://www.yahoo.co.jp/)            |
| に基づいて適切に設定する。                                           |
|                                                                      |
| 分合流点、跳水発生地点、段落ち部及                                   |
| び橋脚設置地点を含む河道区間においては、式(5-4-1)に代えて、これら地  |
| 点を間に挟む上下流の計算断面間をコントロールボリュームとしてこれら事 |
| 象に即した運動量式（又はエネルギー方程式）に基づいて水位を算定する。 |
|                                                                      |
| また、河道湾                                                         |
| 曲区間や砂州の発達する区間における左右岸水際部の水位は、河道形状や水 |
| 理量等に基づいて横断方向偏差*ΔH*の算定式を別途用意し、これにより算定 |
| した*ΔH*を式(5-4-1)により算定した平均水位に付加することにより得る。  |
|                                                                      |
| 以上の算定手法については、水理公式集\[平成11                         |
| 年版\]および河道計画検討の手引きによる。                             |
|                                                                      |
| 河口部において下流端境界条件を与える場合には、潮位、                 |
| 河川水と塩水との密度差、河口砂州などを考慮し、下流端水位を設定する。 |
+----------------------------------------------------------------------+

＜推　奨＞

+----------------------------------------------------------------------+
| 解析の精度・解像度の向上の観点から                                   |
| 、航空レーザ測量やサイドスキャンソナーを用いた音響測深等による高解像 |
| 度の連続的な河道地形測量成果を用いて河道形状を設定するのを推奨する。 |
|                                                                      |
| 常流と射流が混在した流れ場                                           |
| を対象とする場合には、本節[4.2.2](http://www.yahoo.co.jp)＜推奨＞に  |
| 記載する一次元不定流計算を流量及び水位一定の境界条件の下で実施し、水 |
| 位や流速等の水理量が時間的に安定した定常状態の解を得るのが望ましい。 |
+----------------------------------------------------------------------+

＜例　示＞

+----------------------------------------------------------------------+
| 標準                                                                 |
| 逐次計算法により常流と射流が混在した流れ場の計算を行う場合には、支配 |
| 断面の位置を予測して常流と射流の発生区間を判別する方法が適用できる。 |
|                                                                      |
| また、河川水と海水の密度差を考慮                                     |
| した下流端水位の簡易的な設定法として、潮位から求めた河口部水深*h~0~* |
| と（*ρ~2\ ~*/*ρ~1\ ~*―１）（ここで*ρ~2~*、*ρ~1~*は海水と河川水の密度 |
| ）の積として求めた値を河口部の潮位に加える方法を用いることができる。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  土木学会水理委員会：水理公式集［平成11 年版］，pp.93-98，丸善，1999.

    （最新版）土木学会水理委員会：水理公式集［2018年版］，pp.200-208,
    丸善出版、2019.

```{=html}
<!-- -->
```
179. (財)国土技術研究センター：[河道計画検討の手引き](http://www.yahoo.co.jp)，pp.84-97，pp.109-114，pp.119-124，pp.142-144，山海堂，2002.

180. (財)リバーフロント整備センター：河川における樹木管理の手引き，pp.93-96，山海堂，1999.

＜参考となる資料＞

支配断面の位置を予測する手法については下記の資料が参考となる。

1.  石川忠晴，林正男：常流・射流が混在する区間の不等流計算法，土木技術資料，Vol.25
    No.3，pp.39-44，1983.

    1.  []{#_Toc288729668 .anchor}一次元不定流計算

        1.  []{#_Toc288729669 .anchor}定義

＜考え方＞

+----------------------------------------------------------------------+
| 一                                                                   |
| 次元不定流計算\[1DF不定流\]は、基礎方程式として連続方程式及び運動方  |
| 程式に基づく漸変開水路流れを対象とした式(5-4-6)、式(5-4-7)を用いる。 |
|                                                                      |
| > (5-4-6)                                                            |
| >                                                                    |
| > (5-4-7)                                                            |
|                                                                      |
| ここで、*t*は時間で                                                  |
| ある。一次元不定流計算は、断面内の粗度状況が一様及び変化する単断面河 |
| 道に適用することを標準とする。式(5-4-7)の左辺第2項及び第4項は、本節  |
| [4.1.1](http://www.yahoo.co.jp)に示した                              |
| 一次元不等流計算と同様に式(5-4-2)、(5-4-4)、(5-4-5)により算定する。  |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  土木学会水理委員会：水理公式集［平成11 年版］，p.120，丸善，1999.

    （最新版）土木学会水理委員会：水理公式集［2018年版］，pp.216,
    丸善出版、2019.

    1.  []{#_Ref288655019 .anchor}計算方法

＜標　準＞

+----------------------------------------------------------------------+
| 式(5-4-6)、式(5-4-7)を差分化し、河道                                 |
| 形状、粗度係数、境界条件を適切に与え、数値計算を行うのを標準とする。 |
|                                                                      |
| 計算時間間隔については、計算が安定的に進めら                         |
| れ、かつ所定の精度及び解像度が得られるように設定するのを標準とする。 |
|                                                                      |
| 計算断面、河道形状、粗度                                             |
| 係数、樹木群や死水域、河口部における下流端境界条件等については、本節 |
| [4.1.2](http://www.yahoo.co.jp)と同様に設定する。                    |
|                                                                      |
| 河道湾曲部、砂州の発達する区間における左右岸水際部の水位は、本節     |
| [4.1.2](http://www.yahoo.co.jp)と同様に算定する。                    |
+----------------------------------------------------------------------+

＜推　奨＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------
  常流と射流が混在する流れ場を対象とする場合には、跳水や段波などの不連続的な流れや常流から射流への遷移流れといった急変流に適応した計算手法を用いることが望ましい。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜参考となる資料＞

常流と射流が混在した流れ場に適応した計算手法の一例として流束差分離法（FDS法）が挙げられ、下記の資料が参考となる。

1.  西本直史，森明巨，板倉忠興，金澤克己：FDS法による1次元開水路流れの数値解析，土木学会論文集，No.670
    Ⅱ-54，pp.25-36，2001.

```{=html}
<!-- -->
```
9.  秋山壽一郎，浦勝，重枝未玲，アキレス K.
    ジャ：1次元浅水流方程式のFDSに基づく数値解析法，水工学論文集，第44巻，pp.473-478，2000.

    1.  []{#_Toc382986839 .anchor}一次元不定流計算の近似解法

＜考え方＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  一次元不定流計算の近似解法とは、運動方程式の運動量の時間変化に関する項、運動量や水深の縦断方向変化に関する項の全て又は一部を省略した近似式を用いて解析を行うものである。このような近似解法として、Kinematic waveモデル、Diffusion waveモデル等があり、本節[4.2.1](http://www.yahoo.co.jp)に示した計算法と併せて水理学的追跡法と呼ばれる（第3章 水文解析 [2.2.4](http://www.yahoo.co.jp)参照）。計算方法については、本節[4.2.2](http://www.yahoo.co.jp)に準ずる。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1.  土木学会水理委員会：水理公式集［平成11
    年版］，pp.120-125，丸善，1999.

    （最新版）土木学会水理委員会：水理公式集［2018年版］，pp.215-220,
    丸善出版、2019.

    1.  []{#_Toc288729671 .anchor}準二次元不等流計算

        1.  []{#_Toc288729672 .anchor}定義

＜考え方＞

+----------------------------------------------------------------------+
| 準二次元不等流計算\[2DF'不等流\]は、流量*Q*を一定とし、基礎式として  |
| 式(5-4-1)と*β*及び*T~r~*の算定式である式(5-4-8)～(5-4-13)を用いる。  |
|                                                                      |
| > (5-4-8)                                                            |
| >                                                                    |
| > (5-4-9)                                                            |
| >                                                                    |
| > (5-4-10)                                                           |
| >                                                                    |
| > (5-4-11)                                                           |
| >                                                                    |
| > (5-4-12)                                                           |
| >                                                                    |
| > (5-4-13)                                                           |
|                                                                      |
| ここで、*S~b~*は壁面せん断力が働く潤辺長、                           |
| *S~w~*は樹木群境界の潤辺長、*S'~w~*は分割断面境界の潤辺長、*τ*と*τ'* |
| は樹木群境界及び分割断面境界に作用するせん                           |
| 断力、Δ*U~j~*は境界面を介して隣り合う分割断面間での断面平均流速差、  |
| *f*は境界混合係数、β~1~は各分割断面内の運動量補正係数（1.1又は１が標 |
| 準）である。なお、添え字*i*は*i*番目の分割断面についての量であること |
| を、添え字*j*は*j*番目の分割断面境界あるいは樹木群境界についての量で |
| あることを表す（ただし、*i*番目の分割断面に関わる境界のみが対象）。  |
|                                                                      |
| 準二次元不等流計算は、断面                                           |
| 内の粗度状況が一様又は変化する複断面河道に適用することを標準とする。 |
|                                                                      |
| 式(5-4-8)～(5-4-13)は、*f*を導                                       |
| 入して隣り合う断面間での干渉効果を考慮したものである。ここで、干渉効 |
| 果とは河道横断方向に急な流速変化が生じ、そこで生じる横断方向の組織的 |
| 流体混合・運動量輸送により流れ全体の抵抗が増大する効果のことである。 |
|                                                                      |
| 断面                                                                 |
| 分割と境界混合係数の設定に当たっては、一般に急な流速変化をもたらす地 |
| 形・粗度状況の条件に基づいて行う。河道断面形状及び粗度状況（一般的に |
| は樹木群境界）の急変点において分割断面境界を設定する。また、境界混合 |
| 係数についても、断面急変部と樹木群境界に分けて設定手法を使い分ける。 |
|                                                                      |
| ![](media/image158.emf){width="2.84375in"                            |
| height="2.7083333333333335in"}                                       |
|                                                                      |
| 3.  準二次元不等流計算での断面分割の一例                             |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  土木学会水理委員会：水理公式集［平成11
    年版］，pp.111-116，丸善，1999.

    （最新版）土木学会水理委員会：水理公式集［2018年版］，pp.199-205,
    丸善出版、2019.

```{=html}
<!-- -->
```
181. (財)国土技術研究センター：[河道計画検討の手引き](http://www.jice.or.jp/tosho/pdf/kadoukeikaku.pdf)，pp.79-81，山海堂，2002.

     1.  []{#_Toc288729673 .anchor}計算方法

＜標　準＞

+----------------------------------------------------------------------+
| 本節[4.1.2](http://www.yah                                           |
| oo.co.jp)と同様に式(5-4-1)を差分化し、数値計算を行うのを標準とする。 |
|                                                                      |
| 境界混合係数については、水理公式集\[平成11年版\]、河道計画の検討     |
| の手引き及び河川における樹木管理の手引きを参考にして適切に設定する。 |
|                                                                      |
| 計算断面、河道形状、粗度                                             |
| 係数、樹木群や死水域、河口部における下流端境界条件等については、本節 |
| [4.1.2](http://www.yahoo.co.jp)と同様に設定する。                    |
|                                                                      |
| 分合流点、跳水発生地点、段落ち部、橋脚設置                           |
| 地点、河道湾曲部、砂州の発達する区間における水位変化については、本節 |
| [4.1.2](http://www.yahoo.co.jp)と同様に算定する。                    |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  土木学会水理委員会：水理公式集［平成11
    年版］，pp.98-106，丸善，1999.

    （最新版）土木学会水理委員会：水理公式集［2018年版］，pp.194-197,
    丸善出版、2019.

```{=html}
<!-- -->
```
182. (財)国土技術研究センター：河道計画検討の手引き，pp.81-84，山海堂，2002.

183. (財)リバーフロント整備センター：河川における樹木管理の手引き，pp.104-108，山海堂，1999.

     1.  []{#_Toc288729674 .anchor}準二次元不定流計算

         1.  []{#_Toc288729675 .anchor}定義

＜考え方＞

+----------------------------------------------------------------------+
| 準二次元不定流計算\[2DF'                                             |
| 不定流\]は、基礎式として式(5-4-6),(5-4-7)を用い、*β*及び*T~r~*は本節 |
| [4.3.1](http://www.yahoo.co.jp)に                                    |
| 示した準二次元不等流計算と同様に式(5-4-8)～(5-4-13)により算定する。  |
|                                                                      |
| 準二次元不定流計算は、断                                             |
| 面内の粗度状況が一様又は変化する複断面河道に適用するのを標準とする。 |
+----------------------------------------------------------------------+

2.  []{#_Ref288654968 .anchor}計算方法

＜標　準＞

+----------------------------------------------------------------------+
| 本節[4.2.2](http://www.yahoo.co.jp)                                  |
| と同様に式(5-4-6)、式(5-4-7)について数値計算を行うことを標準とする。 |
|                                                                      |
| 計算断面、断面分割、河道形状、粗度係数、樹木群や死水域               |
| の配置、境界混合係数、河口部における下流端境界条件等については、本節 |
| [4.3.2](http://www.yahoo.co.jp)と同様に設定する。                    |
|                                                                      |
| また、河道湾曲部、砂州の発達する区間における水位変化については、本節 |
| [4.1.2](http://www.yahoo.co.jp)と同様に算定する。                    |
+----------------------------------------------------------------------+

＜参考となる資料＞

準二次元不定流計算の計算方法の詳細については、下記の資料が参考となる。

1.  福岡捷二，佐藤宏明，出口桂輔：[洪水流の非定常準二次元解析法の研究](http://c-faculty.chuo-u.ac.jp/~sfuku/sfuku/03_paper/paper/doron2009.5.pdf)，土木学会論文集B，Vol.65
    No.2，pp. 95-105，2009.

    1.  []{#_Toc382986846 .anchor}平面二次元流解析

        1.  []{#_Toc288729678 .anchor}定義

＜考え方＞

+----------------------------------------------------------------------+
| 平面二次元流解析\[2DF\]は、基礎式として連続方程式及び運動方          |
| 程式に基づく漸変開水路流れを対象とした式(5-4-14)～(5-4-17)を用いる。 |
|                                                                      |
| > (5-4-14)                                                           |
| >                                                                    |
| > (5-4-15)                                                           |
| >                                                                    |
| > (5-4-16)                                                           |
| >                                                                    |
| > (5-4-17)                                                           |
|                                                                      |
| ここで、*x*,*y*は水平面又は河床面に平行な直交                        |
| 座標軸、*u*､*v*はある点での各座標軸方向の流速（乱れ成分を平均化した  |
| もの）、*F~x~*,*F~y~*は外力（質量力）、*H*は水位、は水深平均の*u*、  |
| *v*、*ｈ*は水深、*τ~b~*は河床せん断力、*ν~t~*は渦動粘性係数、*K*は乱 |
| れエネルギーである。添え字*x*、*y*はそれぞれ作用方向の座標軸を表す。 |
|                                                                      |
| 平面二次元流                                                         |
| 解析は、静水圧分布の近似が成り立つ流れ場に適用するのを標準とする。た |
| だし、曲率半径の小さい湾曲流れ、構造物近傍の局所的な流れ等といった二 |
| 次流による運動量輸送が卓越する場合や非静水圧分布となる場合には、本節 |
| [4.6](http://www.yahoo.co.jp)、[4.7](h                               |
| ttp://www.yahoo.co.jp)に示す準三次元流解析、三次元流解析を適用する。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  土木学会水理委員会：水理公式集［平成11
    年版］，pp.118-119，丸善，1999.

    （最新版）土木学会水理委員会：水理公式集［2018年版］，pp.208-210・pp.210-211,
    丸善出版、2019.

    1.  []{#_Ref288587622 .anchor}計算方法

＜標　準＞

+----------------------------------------------------------------------+
| 式(5-4-14)～式(5-4-17)を差分化し、河道形                             |
| 状、粗度状況、境界条件を適切に設定し、数値計算を行うのを標準とする。 |
|                                                                      |
| 計算格子の設定に当たっては一般座標系を用い、河岸法線形状、堤防       |
| 法線形状、定期横断測線の位置を考慮して座標を設定するのを標準とする。 |
|                                                                      |
| 河道形状、河川構造物や樹木群繁茂領域等については                     |
| 本節[4.1.2](http://www.yahoo.co.jp)に示した資料に基づいて設定する。  |
|                                                                      |
| 計算時間間隔については、計算が安定的に進められること                 |
| はもちろんのこと、所定の精度及び空間解像度が得られるように設定する。 |
|                                                                      |
| 河床せん断力については、Manningの式若しく                            |
| は対数則などを用いて算定するのを標準とする。粗度係数については、本章 |
| 第5 節に基づいて適切に設定する。                                     |
|                                                                      |
| 式([5.4.1](http://www.yahoo.co.jp)7)には、式([5.4.1](htt             |
| p://www.yahoo.co.jp)8)に示す渦動粘性モデルを適用するのを標準とする。 |
|                                                                      |
| > (5-4-18)                                                           |
|                                                                      |
| ここで、*u~\*~*は摩擦速度、*a*は定数である。                         |
|                                                                      |
| 式(5-4-18)は、水深ス                                                 |
| ケールの乱れが卓越する流れ場での平面的な流体混合のモデルであり、水深 |
| や粗度が空間的に漸変する河道の場合、*a*は0.13～0.15程度の値をとる。  |
+----------------------------------------------------------------------+

＜推　奨＞

+----------------------------------------------------------------------+
| 高水敷・低水路間等での河道横断形状の急変                             |
| 部や樹木群等の植物群落を含む流れ場であり、かつ平面せん断流に伴う大規 |
| 模平面渦など組織的流体混合による河道平面方向の運動量輸送が卓越して発 |
| 生する場合には、以下の二通りのアプローチで解析を行うことが望ましい。 |
|                                                                      |
| 1.  平面せん断流の平均的な効果を渦動粘性係数により評価するアプローチ |
|                                                                      |
| 2.  平面スケー                                                       |
| ルの組織的流体混合現象を平面二次元流解析の直接の対象とするアプローチ |
|                                                                      |
| > （本アプローチでは、渦の動きを表す流速の時空間的な変化を計算結     |
| 果として得る。実務上は、こうした流速の変動を直接必要とすることは少な |
| く、渦による混合の効果を受けた平均的な流速（例えば断面平均流速、横断 |
| 方向流速分布等）に関する情報を用いるのが一般的である。平均的な流速は |
| 、本アプローチで得た流速の変動を時空間的に平均することで得られる。） |
|                                                                      |
| １）のアプローチでは、平面せん                                       |
| 断流に関する水理量、河道形状、植物群落の粗度・形状等に基づいて、組織 |
| 的流体混合現象に即した渦動粘性係数を設定する。２）では、解析によって |
| 平面渦に伴う流れが直接計算されるので、渦動粘性係数については、大規模 |
| 平面渦よりスケールが小さく、直接の解析対象外となる流体混合に即した値 |
| を設定する。そのような設定の一例として、水深スケール以下の流体混合を |
| 式(5-4-18)と同様に摩擦速度と水深の関数として与えることが挙げられる。 |
|                                                                      |
| また、解析の精度及び空間解像度の向上の観点から、                     |
| 航空レーザ測量やサイドスキャンソナーを用いた音響測深等による高解像度 |
| の連続的な河道地形測量成果を用いて河道形状を設定することを推奨する。 |
+----------------------------------------------------------------------+

＜例　示＞

  ----------------------------------------------------------------------------------------------------------------------------------------
  渦動粘性係数*ν~t~*と乱れエネルギー*K*の算定方法として、*k*-*ε*モデル等の乱流モデルの方程式に基づいて計算する方法を用いることができる。
  ----------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1.  土木学会水理委員会：水理公式集［平成11
    年版］，pp.98-99・pp.106-107，丸善，1999.

    （最新版）土木学会水理委員会：水理公式集［2018年版］，pp.194・pp.199,
    丸善出版、2019.

＜参考となる資料＞

一般座標系については下記の資料1)，2)、同様に乱流モデルについては資料3）が参考となる。

1.  [[長田信寿，細田尚，村本嘉雄，Md Munsur
    Rahman：移動一般座標系による側岸侵食を伴う河床変動の数値解析，水工学論文集，第40巻，pp.927-932，1996.]{.underline}]{.smallcaps}

```{=html}
<!-- -->
```
184. [[細田尚，長田信寿，村本嘉雄：移動一般座標による開水路非定常流の数値解析，土木学会論文集，No.533
     Ⅱ-34，pp.267-272，1996.]{.underline}]{.smallcaps}

185. [[灘岡和夫，八木宏：SDS＆2DHモデルを用いた開水路水平せん断乱流の数値シミュレーション，土木学会論文集，No.273
     Ⅱ-24，pp.35-44，1993.]{.underline}]{.smallcaps}

     1.  []{#_Toc382986849 .anchor}準三次元流解析

         1.  []{#_Toc288729681 .anchor}定義

＜考え方＞

+----------------------------------------------------------------------+
| 準三次元流解析\[3DF'\]は、基礎式として連続方程式及び運動方           |
| 程式に基づく漸変開水路流れを対象とした式(5-4-19)～(5-4-23)を用いる。 |
|                                                                      |
| > (5-4-19)                                                           |
| >                                                                    |
| > (5-4-20)                                                           |
| >                                                                    |
| > (5-4-21)                                                           |
| >                                                                    |
| > (5-4-22)                                                           |
| >                                                                    |
| > (5-4-23)                                                           |
|                                                                      |
| ここで、*z*は*                                                       |
| xy*平面に対して垂直上向きの直交座標軸、*w*はある点での*ｚ*座標軸方向 |
| の流速（乱れ成分を平均化したもの）、*z~b~*は河床面の*ｚ*座標である。 |
|                                                                      |
| 準三次元流解析は                                                     |
| 、*w*≪であり静水圧分布の近似が成立する場合に適用するのを標準とする。 |
+----------------------------------------------------------------------+

＜関連通知等＞

土木学会水理委員会：水理公式集［平成11 年版］，pp.118-119，丸善，1999.

（最新版）土木学会水理委員会：水理公式集［2018年版］，pp.208-210・pp.211-214,
丸善出版、2019.

＜参考となる資料＞

準三次元流解析については、下記の資料が参考となる。

1.  石川忠晴，鈴木研二，田中昌宏：開水路流の準三次元計算法に関する基礎的研究，土木学会論文集，第375号
    Ⅱ-6 ，pp.181-189，1986.

    1.  []{#_Toc288729682 .anchor}計算方法

＜例　示＞

+----------------------------------------------------------------------+
| 式(5-4-19)～(5-4-23)を差                                             |
| 分化し、河道形状、粗度係数、境界条件を適切に設定し、数値計算を行う。 |
|                                                                      |
| 計算格子、河道形状、粗度係数、河川構造物や樹木群繁茂                 |
| 領域等や河床せん断力については、本節[4.5.2](http://www.yahoo.co.jp)  |
| と同様に設定できる。                                                 |
+----------------------------------------------------------------------+

＜参考となる資料＞

準三次元不定流計算を実施するに当たって、鉛直方向の流速分布式を与えて2次流による運動量輸送を算定する方法は資料1)～4）、渦度方程式を用いた方法については資料5)が参考となる。また、大規模平面渦の算定については資料6)が参考となる。

1.  福岡捷二，五十嵐崇博，西村達也，宮崎節夫：河川合流部の洪水流と河床変動の非定常三次元解析，水工学論文集，第39巻，pp.435-440，1995.

```{=html}
<!-- -->
```
186. 細田尚，長田信寿，岩田通明，木村一郎：一般座標系での主流と２次流の遅れを考慮した平面2次元流モデル，水工学論文集，第44巻，pp.587-592，2000.

187. 音田慎一郎，細田尚，木村一郎：一般座標系での湾曲流の水深積分モデルの改良とその検証について，水工学論文集，第50巻，pp.769-774，2006.

188. 吉田圭介，石川忠晴：円筒座標CIP-Soroban法と境界適合座標法を組み合わせた蛇行河川の準3次元計算法，水工学論文集，第52巻，pp.997-1002，2008.

189. 内田龍彦，福岡捷二：浅水流方程式と渦度方程式を連立した準三次元モデルの提案と開水路合流部への適用，水工学論文集，第53巻，pp.1081-1086，2009.

190. 吉田圭介，石川忠晴，箕浦靖久：準3次元CIP-Sorobanモデルによる利根川洪水流の大規模数値計算，水工学論文集，第53巻，pp.877-882，2009.

     1.  []{#_Toc382986852 .anchor}三次元流解析

         1.  []{#_Toc288729684 .anchor}定義

＜考え方＞

+----------------------------------------------------------------------+
| 三次元流解析\[3DF\]は、基礎式として式(5-4-24)～(5-4-28)を用いる。    |
|                                                                      |
| > (5-4-24)                                                           |
| >                                                                    |
| > (5-4-25)                                                           |
| >                                                                    |
| > (5-4-26)                                                           |
| >                                                                    |
| > (5-4-27)                                                           |
| >                                                                    |
| > (5-4-28)                                                           |
|                                                                      |
| ここで                                                               |
| 、*F~z~*は外力（質量力）である。添え字*z*は作用方向の座標軸を表す。  |
|                                                                      |
| 三次元流解析は計算負荷が大き                                         |
| く、そのため広範囲にわたる実河川での適用事例が少ない。三次元流解析の |
| 適用に当たっては、水制等の構造物周辺の流況を再現する場合など局所的か |
| つ非静水圧分布となる流れ場であるか、かつ解析の目的に照らし合わせて三 |
| 次元流解析の必要性が高いか、前もって十分に吟味することが重要である。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  土木学会水理委員会：水理公式集［平成11
    年版］，pp.118-119，丸善，1999.

    （最新版）土木学会水理委員会：水理公式集［2018年版］，pp.208-210・pp.214-215,
    丸善出版、2019.

    1.  []{#_Toc288729685 .anchor}計算方法

＜例　示＞

+----------------------------------------------------------------------+
| 式(5-4-24)～式(5-4-28)を差分化し、河道形状                           |
| 、粗度係数、境界条件を適切に設定し、数値計算を行うことを標準とする。 |
|                                                                      |
| 河道形状、粗度係数、河川構造物や樹木群繁茂                           |
| 領域等や河床せん断力については、本節[4.5.2](http://www.yahoo.co.jp)  |
| と同様に設定できる。                                                 |
+----------------------------------------------------------------------+

＜参考となる資料＞

乱流モデルについては、下記の資料が参考となる。

1.  [[河原能久，彭静，藤井和之：越流型水制工を有する河道内の流れの３次元数値解析，河川技術論文集，第3巻，pp.17-22，1997.]{.underline}]{.smallcaps}

```{=html}
<!-- -->
```
191. [[長田信寿，細田尚，村本嘉雄，中藤達昭：3次元移動座標系・非平衡流砂モデルによる水制周辺の河床変動解析，土木学会論文集，No.684
     Ⅱ-56，pp.21-34，2001.]{.underline}]{.smallcaps}

1.  []{#_Toc382986855 .anchor}パラメータの設定

    1.  []{#_Toc382986856 .anchor}パラメータの種類と設定の基本的な考え方

＜考え方＞

+----------------------------------------------------------------------+
| 水理解析におけるパラメータとしては、各解析法                         |
| に内在したパラメータと河道の粗度状況に依存したパラメータが存在する。 |
|                                                                      |
| 前者は、準                                                           |
| 二次元流解析の境界混合係数、平面二次元流解析の渦動粘性係数等である。 |
| 一方、後者の粗度状況に依存したパラメータとは基本的に粗度係数を指す。 |
|                                                                      |
| 計算手法に内在したパラメータは、既往                                 |
| の知見から水理条件等に応じて設定されることが多く、その設定方法を本章 |
| [第4節](http://www.yahoo.co.jp) 計算手法の説明                       |
| に記載している。したがって、本節では粗度係数の設定法について述べる。 |
|                                                                      |
| なお、計算手法に内在したパラメータについては、実洪水の観測結果か     |
| ら逆算等によって検証されることが少なからず行われてきたが、観測技術の |
| 進歩に伴ってデータの空間分解能や時間分解能が向上してきたことも考慮し |
| て、今後とも積極的に検証を試みることが重要である。[]{#_Toc317586149  |
| .anchor}                                                             |
+----------------------------------------------------------------------+

2.  粗度係数の設定

＜考え方＞

+----------------------------------------------------------------------+
| 粗度係                                                               |
| 数の設定方法としては、逆算によって粗度係数を同定する方法、河道の粗度 |
| 状況から物理的に粗度係数を推定する方法の大きく分けて二つが存在する。 |
|                                                                      |
| 粗度係数の逆算による同定法とは、適切な平均流速公式を用いた洪水流の   |
| 計算手法に実測の河道形状、水位、流量あるいは流速を与えて、粗度係数を |
| 算定することである。逆算粗度係数には、その洪水発生時の種々の情報が集 |
| 約されており、実績と言う意味で重みがある。設定対象とする粗度状況、河 |
| 道形状、洪水規模が、粗度係数逆算対象のそれらと余り変わらない場合には |
| 、妥当な設定を行うことができる。逆にそうでない場合、この設定が妥当で |
| はなくなる可能性がある。質が良く十分な数の粗度係数逆算が行われている |
| ことが前提となり、また、設定結果の成否が洪水データの精度に依存する。 |
|                                                                      |
| 物理的な推定による方                                                 |
| 法とは、推定法の原理、特徴、適用範囲を理解した上で、対象となる場の特 |
| 性を踏まえた適切な推定法に基づき粗度係数を算定するものである。粗度状 |
| 況による粗度係数の推定は、一般性、応用性が高く、原理的には任意の断面 |
| 形状、洪水規模及び粗度状況に適用できる。したがって、任意の粗度状況、 |
| 河道形状、洪水規模を想定した粗度係数設定を行うことができる。その一方 |
| で、粗度係数の物理性が保たれるような平均流速公式の使用が前提となる。 |
| また、粗度係数の推定精度や推定法の適用範囲に限界や不確定要素が残る。 |
|                                                                      |
| 粗度係数の設定に当たっては、逆算に                                   |
| よる同定法と粗度状況による推定法の弱点を補完するように、両方の設定法 |
| を併用することが現実的な選択である。すなわち、河道の粗度状況から物理 |
| 的に粗度係数を設定し、その一方で、その設定により既往代表洪水の逆算粗 |
| 度係数あるいは洪水位を再現できるかを確認し、必要に応じて、逆算粗度係 |
| 数値を踏まえて粗度係数を修正するというものである。あるいは、逆算粗度 |
| 係数に基づき粗度係数を設定することを試み、その一方で、逆算対象の洪水 |
| 規模・河道状況と粗度係数設定対象のそれらとの違いを踏まえ、物理的な粗 |
| 度係数推定法を加味して、最終的に粗度係数を設定するというものである。 |
|                                                                      |
| なお、物理的な粗度係数推                                             |
| 定法の適用が難しい河道については、粗度係数逆算結果を重視した粗度係数 |
| 設定を行うこととなる。この例として、岩河道、土丹が露出した河道などが |
| 挙げられる。逆に、逆算のためのデータが存在しないまま設定せざるを得な |
| い場合は、物理的な推定法のみの適用や、それが難しい場合には、類似の河 |
| 川の粗度係数を十分に吟味した上で適用することも現実的な選択肢となる。 |
|                                                                      |
| 粗度係数                                                             |
| を支配する要因とその影響度が複雑で、精度の良い洪水観測が必ずしも容易 |
| でない実河川を対象としていることから、適切な粗度係数設定を行った場合 |
| でも、種々の誤差、不明確な要素を粗度係数から完全に除去することは困難 |
| と考えるべきであり、一般的には粗度係数の有効数字は２桁が限度である。 |
| 粗度係数の設定や設定した流れ場の解析結果の解釈と利用においては、粗度 |
| 係数が含みうるこのような誤差、不確実性を十分考慮しなければならない。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  土木学会水理委員会：水理公式集［平成11
    年版］，pp.87-92・p.117・pp.182-184・pp.206-209,・pp.212-218，丸善，1999.

    （最新版）土木学会水理委員会：水理公式集［2018年版］，pp.190-193・pp.224-225・pp.311-315・pp.353-356・pp.356-361,
    丸善出版、2019.

```{=html}
<!-- -->
```
192. (財)国土技術研究センター：[河道計画検討の手引き](http://www.jice.or.jp/tosho/pdf/kadoukeikaku.pdf)，pp.97-118，山海堂，2002.

193. (財)リバーフロント整備センター：河川における樹木管理の手引き，pp.98-103，pp.118-120，山海堂，1999.

     1.  []{#_Toc288729688 .anchor}逆算による同定の方法

         1.  []{#_Toc382986859 .anchor}逆算に用いるデータセットの種類

＜考え方＞

+----------------------------------------------------------------------+
| 粗度係数の逆算に用いるデー                                           |
| タセットとして、以下の３種類を用いる。データセット１)、２）は、第2章 |
| 水文・水理観測 [第1節](http://www.yahoo.co.jp) 総説                  |
| で述べたカテ                                                         |
| ゴリー１.２による観測データ群であり、３）はカテゴリー[３.１](http:// |
| www.yahoo.co.jp)の河川の流れの総合的把握のための観測データ群である。 |
|                                                                      |
| 1.  時間的には疎であるが、空間的に密に計測された水位データ           |
|                                                                      |
| 代表的なデータとしては、第2章 水文・水理観測 第3節 水位観測          |
| [3.9](http://www.yahoo.co.jp)に示す洪水痕跡水位が挙げられる。        |
|                                                                      |
| 32. 空間的には疎であるが、時間的には密に計測された水位データ         |
|                                                                      |
| 代表的なデータとしては、第2章 水文・水理観測 第3節 水位観測          |
| [3.                                                                  |
| 4](http://www.yahoo.co.jp)に示す水位観測所の水位データが挙げられる。 |
|                                                                      |
| 33. 時間的・空間的に密に計測された水位データ                         |
|                                                                      |
| 代表的なデータとしては、第2章 水文・水理観測                         |
| [第7節](http://www.yahoo.co.jp) 河川の流れの総合的把握               |
| に示す水位時間変化の縦断方向多点観測結果が挙げられる。               |
+----------------------------------------------------------------------+

1.  []{#_Ref288660429 .anchor}データセットに応じた同定

＜標　準＞

+----------------------------------------------------------------------+
| 1.  共通事項                                                         |
|                                                                      |
| １断面内に複数の粗度係数（低水路と高水敷など）                       |
| を設定する場合には、１回の逆算で１断面内の全ての粗度係数を逆算するこ |
| とはできない。そのような場合には、次のように算定するのを標準とする。 |
|                                                                      |
| 種々の規模の洪水について逆算を行い、実測値に                         |
| 合う粗度係数の組合せを見いだす。たとえば、低水路満杯時の洪水で低水路 |
| 粗度係数を逆算し、それよりも高い水位の洪水から高水敷上の樹木や草本植 |
| 物の粗度係数を求める。この場合は、洪水規模による粗度係数の変化、対象 |
| とした各洪水発生時の粗度状況の違いを無視できることが適用条件となる。 |
|                                                                      |
| また、水位に対する影響が支配的でなく、粗度状況からの物理的推         |
| 定の信頼性が比較的高い粗度係数の値を逆算時に既知として与え、この条件 |
| に該当せず逆算する必要性が高い１つの粗度係数だけを対象に逆算を行う。 |
| たとえば、高水敷の粗度係数値を植生地被からの推定により与え、低水路粗 |
| 度係数だけを逆算の対象とする場合等がこれに当たる。この場合は、既知と |
| して与える粗度係数値の誤差によって、逆算した粗度係数の精度が決まる。 |
|                                                                      |
| 34. データセット１を用いた同定法                                     |
|                                                                      |
| この同定法では、河道の長                                             |
| い区間の平均的な粗度係数が得られる。「河道の長い区間」の一つの目安と |
| しては河道特性が同一と見なせる単位であるセグメント区間が挙げられる。 |
| 逆算においては、平均的な粗度係数を算定する本同定法が用いられることが |
| 多いが、これは対象区間の平均的な粗度係数を設定することにより、河道計 |
| 画の策定などに使用できる精度で水位計算を行うことができるからである。 |
|                                                                      |
| 長い河道区間                                                         |
| の平均的な粗度係数を逆算する場合、河道及び洪水流の特徴に応じて、本章 |
| 第3節                                                                |
| [3.2](http://www.yahoo.co.jp/)に述べたように不                       |
| 定流計算と不等流計算を使い分ける。なお、一次元・準二次元流解析によっ |
| て逆算する場合には、左右岸の痕跡水位の平均値と水位計算値を比較する。 |
|                                                                      |
| 35. データセット２を用いた同定法                                     |
|                                                                      |
| この同定法では、水位観測所の水位データを用いるのが一                 |
| 般的であり、その場合、水位観測所地点間の平均的な粗度係数が得られる。 |
|                                                                      |
| 河道の長い区間内に                                                   |
| 多地点の水位観測所が設置されている場合には、各観測所の最高水位に対し |
| て、上記2)で述べた痕跡水位に対する手法によって粗度係数の逆算を行う。 |
|                                                                      |
| また、同一のセグメント区間内に近接した2地点で水位観                  |
| 測所等により水位データが得られる場合には、等流計算又は不等流計算によ |
| って粗度係数を逆算できる。「近接した2地点」の一つの目安としては2地点 |
| 間の流量が同一と見なせることが挙げられる。この場合、最高水位のみなら |
| ず水位の時間変化にも適用できるため、粗度係数の時間変化が把握できる。 |
|                                                                      |
| この逆算において                                                     |
| 、大きな誤差をもたらす可能性が高いのは水面勾配である。水位測定精度（ |
| 又は誤差）に比べて2地点間の水位差を十分に大きくとれない場合には、水  |
| 面勾配の精度を確保することが難しく、逆算粗度係数の誤差が大きくなる。 |
|                                                                      |
| 上記の観点からは、水位差を大きくするために                           |
| より離れた水位観測所間で粗度係数の逆算を行うことが望ましい。ただし、 |
| 2地点間の距離を増すと粗度状況や河道形状の一様性が保ち難くなり、等流  |
| 計算では逆算粗度係数の精度が低下する場合がある。その際には、不等流計 |
| 算を適用することで原理的には精度低下が抑えられるが、距離を増すことで |
| 2地点間の流量が同一とはみなせなくなった場合には、その限りではない。  |
|                                                                      |
| 一般に上記した要件を全て満たすのは、特に河床勾                       |
| 配の緩い河道区間において困難であり、そのため一定の誤差が含まれ得る。 |
|                                                                      |
| なお、本手法で同定した                                               |
| 粗度係数をより長い区間の平均的な粗度係数として用いる場合、上下流の長 |
| い区間をも代表し得るか十分に吟味し、その適用を慎重に行う必要がある。 |
+----------------------------------------------------------------------+

＜例　示＞

+----------------------------------------------------------------------+
| 1.  データセット３を用いた同定法                                     |
|                                                                      |
| この同定法では、解析の対象                                           |
| とする洪水時の水面形を不定流計算によって再現計算し、水面形の時空間的 |
| な変化を多地点かつ高頻度の水位観測結果とできるだけ一致するように粗度 |
| 係数を逆算することで、粗度状況別に粗度係数の同定を行うことができる。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  土木学会水理委員会：水理公式集［平成11 年版］，p.117，丸善，1999.

    （最新版）土木学会水理委員会：水理公式集［2018年版］，pp.224-227,
    丸善出版、2019.

```{=html}
<!-- -->
```
10. (財)国土技術研究センター：[河道計画検討の手引き](http://www.jice.or.jp/tosho/pdf/kadoukeikaku.pdf)，pp.97-118，山海堂，2002.

＜参考となる資料＞

データセット１、２を用いた粗度係数の逆算については資料1)が、データセット３）を用いた解析事例については資料2)が参考となる。

1.  建設省河川局治水課，建設省土木研究所：河道特性に関する研究，第42回建設省技術研究会報告，pp.761-791，1988.

```{=html}
<!-- -->
```
11. 福岡捷二，渡邊明英，田端幸輔，風間聡，牛膓宏：[利根川・江戸川分派点を含む区間における流量ハイドログラフと粗度係数・樹木群透過係数の評価](http://c-faculty.chuo-u.ac.jp/~sfuku/sfuku/03_paper/paper/suiko50_1165.pdf)，水工学論文集，第50巻，pp.1165-1170，2006.

    1.  []{#_Toc288729692 .anchor}粗度状況による推定の方法

        1.  []{#_Toc382986862 .anchor}推定の基本的な考え方

＜考え方＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  移動床に洪水が作用すると、小規模河床波の消長により粗度係数が大きく変化することがある。この傾向は砂床河川で顕著であるが、礫床河川でも無視できない場合がある。以下では、出水中の河床変化が顕著でない場合の粗度係数の推定法と小規模河床波の発生を伴う場合の粗度係数の推定法に分けて記述する。また、河川構造物の抵抗の推定法についても併せて記載する。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

2.  []{#_Toc382986863
    .anchor}出水中の河床変化が顕著でない場合の粗度係数の推定法

＜標　準＞

+----------------------------------------------------------------------+
| 1.  河床等の裸地面における粗度係数                                   |
|                                                                      |
|     河床材料の移動が生じず平坦な固定床として取り扱える場合には、河   |
| 床材料の粒径、水深等に基づいて粗度係数を推定するのを標準とする。固定 |
| 床として扱える場合の粗度係数の推定は水理公式集\[平成11年版\]による。 |
|                                                                      |
| ```{=html}                                                           |
| <!-- -->                                                             |
| ```                                                                  |
| 36. 人工水路等の粗度係数                                             |
|                                                                      |
| 人                                                                   |
| 工水路においては、固定床面の凹凸等の粗度状況に応じて粗度係数を推定す |
| るのを標準とする。推定に当たっては、水理公式集\[平成11年版\]による。 |
|                                                                      |
| 37. 草本植物・樹木の粗度係数                                         |
|                                                                      |
| 河床                                                                 |
| や高水敷が草本植物・樹木により覆われている場合、草丈等の繁茂状況と水 |
| 深等の水理量に基づいて粗度係数を推定するのを標準とする。推定に当たっ |
| ては、河道計画の検討の手引き及び河川における樹木管理の手引きによる。 |
|                                                                      |
| 38. 護岸等の粗度係数                                                 |
|                                                                      |
| のり覆工、根固工の主                                                 |
| 構成材料（ブロック、礫等）の相当粗度等の粗度状況に基づいて、粗度係数 |
| を推定するのを標準とする。推定に当たっては、護岸の力学設計法による。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  土木学会水理委員会：水理公式集［平成11
    年版］，pp.87-91・pp.206-209・pp.214-215，丸善，1999.

    （最新版）土木学会水理委員会：水理公式集［2018年版］，pp.190-193・pp.353-356・pp.357,
    丸善出版、2019.

```{=html}
<!-- -->
```
194. (財)国土技術研究センター：[河道計画検討の手引き](http://www.jice.or.jp/tosho/pdf/kadoukeikaku.pdf)，pp.114-118，山海堂，2002.

195. (財)リバーフロント整備センター：河川における樹木管理の手引き，pp.99-100，pp.118-120，山海堂，1999.

196. (財)国土技術研究センター：護岸の力学設計法，pp132-133，山海堂，1999

     （最新版）（財）国土技術研究センター：改訂 護岸の力学設計法，2023.

[]{#_Toc288729694 .anchor}

1.  小規模河床波の発生を伴う場合の粗度係数の推定法

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  小規模河床波（平坦河床を含む）を伴う河床の粗度係数の推定には、実用的な観点からは、次元解析や土砂水理学の知見を用いつつ、実験や観測結果から何らかの法則性を導き出すというアプローチが主流である。これには主として実験結果に基づき小規模河床形態の領域区分ごとに抵抗則を示した方法、実験結果に河川の観測データを加え、河川に生じ得る幅広い水理条件、河床材料の粒径範囲について流速係数、無次元掃流力、水深粒径比の関係を示した方法がある。小規模河床波を伴う河床の粗度係数の推定は、これら方法を用いるのを標準とする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1.  土木学会水理委員会：水理公式集［平成11
    年版］，pp.91-92・pp.182-184，丸善，1999.

    （最新版）土木学会水理委員会：水理公式集［2018年版］，pp.192,
    丸善出版、2019.

```{=html}
<!-- -->
```
197. (財)国土技術研究センター：[河道計画検討の手引き](http://www.jice.or.jp/tosho/pdf/kadoukeikaku.pdf)，pp.97-109，山海堂，2002.

[]{#_Toc288729695 .anchor}

1.  河川構造物の流体力の推定法

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  水制や橋脚等の河川構造物が河道縦横断方向の水位・流速分布に与える影響を評価する場合、洪水流の解析においては河川構造物の具体の形状は与えずに流体力としてのみ反映する手法を用いる（たとえば、式(5-4-15)、(5-4-16)、(5-4-21)、(5-4-22)の*Fx*、*Fy*がこれに該当）。その際、各種構造物の諸元に応じた適切な抗力係数、揚力係数を用いた経験則に基づいて推定するのを標準とする。推定に当たっては、水理公式集\[平成11年版\]による。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1)  土木学会水理委員会：水理公式集［平成11
    年版］，pp.212-218，丸善，1999.

    （最新版）土木学会水理委員会：水理公式集［2018年版］，pp.353-361,
    丸善出版、2019.

第6章　河床変動、河床材料変化及び土砂流送の解析 {#第6章-河床変動河床材料変化及び土砂流送の解析 .目次の見出し1}
===============================================

目　次 {#目-次-6 .目次の見出し1}
======

[第1節 総説 1](#_Toc382986866)

> [1．1 位置付けと目的 1](#_Toc382986867)
>
> [1．2 解析法の基本フレーム 1](#_Toc382986868)
>
> [1．3 解析レベル 2](#_Toc382986869)
>
> [1．4 解析の実施手順 3](#_Toc382986870)

[第2節 目的に応じた解析レベルの設定 4](#_Toc382986871)

[第3節 計算法の設定 7](#_Toc382986872)

> [3．1 解析レベルに応じた計算法の選定 7](#_Toc382986873)
>
> [3．2 流れの計算法の設定 7](#_Toc382986874)
>
> [3．3 河床形状の計算法の設定 7](#_Toc382986875)
>
> [3．4 粒度分布の計算法の設定 8](#_Toc382986876)
>
> [3．5 掃流砂の計算法の設定 10](#_Toc382986877)
>
> [3．5．1 一様粒径の掃流砂 10](#_Toc382986878)
>
> [3．5．2 混合粒径の掃流砂 14](#_Toc382986879)
>
> [3．6 巻き上げ量（又は基準面濃度）の計算法の設定 15](#_Toc382986880)
>
> [3．7 土砂濃度分布の計算法の設定 17](#_Toc382986881)

[第4節 各種条件等の設定 19](#_Toc298428038)

> [4．1 解析レベルに応じた条件等の設定 19](#_Toc382986883)
>
> [4．2 河岸・高水敷・堤防等の河道地形の設定 20](#_Toc382986884)
>
> [4．3 植物・構造物等の水理作用の設定 20](#_Toc382986885)
>
> [4．4 構造物や河岸等での流砂の計算条件の設定 21](#_Toc318548306)
>
> [4．5 水位・流量に関する境界条件の設定 22](#_Toc382986887)
>
> [4．6 供給土砂と河道外搬出・搬入の条件設定 22](#_Toc382986888)
>
> [4．6．1 供給土砂の設定 22](#_Toc382986889)
>
> [4．6．2 河道外搬出・搬入の設定 24](#_Toc382986890)
>
> [4．7 河床高・河床材料の初期条件の設定 25](#_Toc298428041)

[第5節 解析の実施と検証・調整 25](#_Toc298428042)

> [5．1 解析の実施 25](#_Toc382986893)
>
> [5．2 解析の検証・調整 25](#_Toc382986894)
>
> [5．3 解析と調査を並行して実施する場合の検証・調整 26](#_Toc382986895)

平成26年4月　版

8.  河床変動、河床材料変化及び土砂流送の解析

    1.  []{#_Toc382986866 .anchor}総説

        1.  []{#_Toc382986867 .anchor}位置付けと目的

＜考え方＞

+----------------------------------------------------------------------+
| 本章                                                                 |
| は、沖積河川（セグメント1、2、3）を主対象として、河川等の計画・設計  |
| ・維持管理、河川環境の保全、総合的な土砂管理などのために必要となる河 |
| 床形状や河床材料の変化及び土砂流送の解析に関する基本的な事項を示す。 |
|                                                                      |
| 解析対象であるこれ                                                   |
| らの事象の実態を把握するための調査は[第4章](http://www.yahoo.co.jp)  |
| 河道特性調査に記述されている。本章では、[第4章](http://w             |
| ww.yahoo.co.jp)に示した調査の成果及び[第5章](http://www.yahoo.co.jp) |
| 河川における洪水流の水理解析に示した水理解析手法を利用しつつ         |
| 、実態把握では得られない将来の事象、河川等の計画・設計・維持管理等の |
| 種々の案の下での事象、更にデータや情報が不足し必要なレベルの実態把握 |
| ができていない既往の事象について、予測、シナリオ・感度分析、現象の再 |
| 現、観測及び調査情報の補完等を行うための解析法を提示するものである。 |
|                                                                      |
| 解析対象のうち、河床形状の                                           |
| 変化は、流下能力の把握や河川構造物の管理に必須であり、河床材料（特に |
| 表層）の変化は、河川における生物の生息・生育状況の検討の際に役立つ。 |
|                                                                      |
| また、土砂流送は、河床変動及び河床材                                 |
| 料変化とともに一連の河道形成システムを構成する主たる要素であり、解析 |
| に際して、これら3つの要素と変化を起こす主な要因である洪水の状況に着  |
| 目しておくことが、解析の実施と結果の活用を適切に行う上で重要である。 |
+----------------------------------------------------------------------+

2.  []{#_Toc382986868 .anchor}解析法の基本フレーム

＜考え方＞

+----------------------------------------------------------------------+
| 図6-1-1に解析法の基本フレームを示す。                                |
|                                                                      |
| ![](media/image175.emf){width="5.906944444444444in"                  |
| height="3.970138888888889in"}                                        |
|                                                                      |
| 3.  河床変動、河床材料変化及び土砂流送の解析法の基本フレーム         |
|                                                                      |
| 解析                                                                 |
| においては、まず河道特性調査（[第4章](http://www.yahoo.co.jp)）等に  |
| よる調査結果を用いて解析の対象とする河床部の川幅や平面形状とそれを取 |
| り囲む高水敷等の形状を設定し、河床部に初期条件に従って河床状況を組み |
| 込んで、与えられた流量、水位に関する境界条件の下で流れの計算を行う。 |
|                                                                      |
| 流れや土砂流送に影響を与える構造物や植物等を考慮する必要がある場合   |
| には、その作用を流れ、掃流砂、浮遊砂、河床の各計算において考慮する。 |
|                                                                      |
| また、流砂と流れの相互作用により形成される小規模河床波（第4章        |
| 河道特性調査 [3.3.2](http://www.yahoo.co.jp)、本章                   |
| [3.5](h                                                              |
| ttp://www.yahoo.co.jp)参照）が流砂量や粗度等に与える影響を考慮する。 |
|                                                                      |
| こうして得られた                                                     |
| 流れの状況と河床の状況から、掃流砂と浮遊砂の計算を行う。ここで、供給 |
| 土砂や河道への土砂搬出・搬入等の流砂に関する境界条件等を反映させる。 |
|                                                                      |
| なお、河床面の粗度設定は、特に掃流砂量の計算におい                   |
| て有意な影響を与える（本章の[3.5](http://www.yahoo.co.jp)で後述）。  |
|                                                                      |
| それぞれの計算から得                                                 |
| られる掃流砂と浮遊砂の状況に基づき、それらがもたらす河床形状の変化や |
| 河床材料の粒度分布等の変化を計算する。この際、河床形状や河床材料粒径 |
| の変化を規定する構造物や河床等の条件がある場合には、それを組み込む。 |
|                                                                      |
| 以上により、流砂現象を一定時間経験した後の新た                       |
| な河床の状況が得られる。こうしたプロセスを、現象を支配する基本方程式 |
| 群に基づく数値計算手法を用いて必要時間分たどっていくことにより、流れ |
| 、掃流砂、浮遊砂、河床の各状況の時間変化を連続的に得ることができる。 |
|                                                                      |
| 河床の状況について計算対象となる項目は河床形状と粒度                 |
| 分布である。また、初期条件で与えられる又は堆積過程で計算される（本章 |
| [3.4](h                                                              |
| ttp://www.yahoo.co.jp)で後述）粒度分布の鉛直変化は、河床の状況につい |
| てのもう一つの計算対象である「堆積構造」の定量的解析法の1つとなる。  |
|                                                                      |
| これらの計算結果に対して検証を行い、必要に応じて各設定の調整を行う。 |
|                                                                      |
| 以                                                                   |
| 上の全体像を「解析法」と呼び、その内、基本方程式群とそれによる出力で |
| 構成されるいわゆる数値計算モデルの部分を「計算法」と呼び、区別する。 |
|                                                                      |
| 本章は、計算法のみでなく、初期                                       |
| ・境界条件等の設定及び検証・調整を含めた解析法を取り扱うものである。 |
+----------------------------------------------------------------------+

1.  []{#_Toc382986869 .anchor}解析レベル

＜考え方＞

+----------------------------------------------------------------------+
| 解析レベルとは、流れ、流砂（掃流・浮遊）、                           |
| 河床の形状・粒径変化といった各事象を記述する解像度又は範囲であり、以 |
| 下の4項目のレベルの組合せとして解析法のカテゴリーを表すのに用いる。  |
|                                                                      |
| 1.  河床高の解析レベル                                               |
|                                                                      |
| 河床形状に関する解析レベルは、1次元／2次元の2レベルで設定する。      |
|                                                                      |
| 1次元は、平均河床高の河道縦断方向分布の時間変化を得るものである。2   |
| 次元は、河道縦横断方向の河床高の平面分布の時間変化を得るものである。 |
|                                                                      |
| 39. 粒径の解析レベル                                                 |
|                                                                      |
| 河床材料の粒                                                         |
| 度分布に関する解析レベルは、一様粒径／混合粒径の2レベルで設定する。  |
|                                                                      |
| 一様粒径は、河床材料を単一粒径で構成す                               |
| るとして、場所的・時間的に粒径が一定として解析するものである。混合粒 |
| 径は、河床材料を別途設定するある一定の粒径範囲内の粒径成分で構成され |
| るとして、場所的・時間的な粒度分布の変化について解析するものである。 |
|                                                                      |
| 40. 流砂の解析レベル                                                 |
|                                                                      |
| 流砂の流送形態に関する解析レベルは                                   |
| 、掃流砂のみ／掃流砂と浮遊砂（混合型・通過型）の2レベルで設定する。  |
|                                                                      |
| 掃流砂のみは、流砂量として掃流形態のみを取り扱うも                   |
| のである。掃流砂と浮遊砂は、掃流・浮遊の両形態を取り扱うものである。 |
|                                                                      |
| なお、浮遊形態                                                       |
| の流砂を混合型と通過型（いわゆるウォッシュロード）に区分したが(第4章 |
| 河道特性調査の[2.3](http://www.yahoo.co.jp)参照)、ここでのレベル     |
| 設定では、それらの内の一つ、又は両方を含むものを総じて浮遊砂とする。 |
|                                                                      |
| 41. 流れ場の解析レベル                                               |
|                                                                      |
| 流れ場の空間的な解像度に関する解析レベルの区分は、第5章              |
| 河川における洪水流の水理解析 の[第4節](http://www.yahoo.co.jp)       |
| 計算手法の説明                                                       |
| に示した解析手法の分類である1次元、準2次元、2次                      |
| 元、準3次元、3次元に、2次元（2次流付加）を加えた6レベルで設定する。  |
|                                                                      |
| ここで、2次元（2次流付加）は、第5章 河川における洪水流の水理解析     |
| [4.5](http://www.yahoo.co.jp)に示した2次元流れ                       |
| の運動方程式・連続方程式に基づいて算定した流速を主流として、別途用意 |
| した式により2次流成分の流速を算定し、主流に付加する解析手法である。  |
|                                                                      |
| 以後、説明を簡潔に行うため、表6-1-1のように略記する。                |
|                                                                      |
| 6.  各解析レベルの略記号                                             |
|                                                                      |
| ![](media/image176.emf){width="2.997916666666667in"                  |
| height="2.357638888888889in"}                                        |
+----------------------------------------------------------------------+

1.  []{#_Toc382986870 .anchor}解析の実施手順

＜考え方＞

+----------------------------------------------------------------------+
| 本章の構成と解析の手順を図6-1-2に示す。                              |
|                                                                      |
| まず、解析                                                           |
| レベルの設定として、本節の[1.3](http://www.yahoo.co.jp)に記述した河  |
| 床高、粒径、流送形態、流れ場の解析レベルを設定する。その際に踏まえて |
| おくべき事項について本章の[第2節](http://www.yahoo.co.jp)に述べる。  |
|                                                                      |
| 次の解析法の設定では、計算法と各種条件等の                           |
| 設定を行う。計算法の設定では、流れ、河床形状、粒度分布、掃流砂、浮遊 |
| 砂（巻き上げ量と土砂濃度分布）の計算に用いる基礎方程式の設定を行う。 |
|                                                                      |
| 本章の[第3節](http://www.yahoo.co.jp)では、各計算に用いる            |
| 基礎方程式を事象の記述レベルが異なる種別に区分して示すとともに([3.2] |
| (http://www.yahoo.co.jp)～[3.7](http://www.yahoo.co.jp))、解析レベル |
| に応じた種別の選定について述べる（[3.1](http://www.yahoo.co.jp)）。  |
|                                                                      |
| 各種条件等の設定では、計算法に与える境界条                           |
| 件や初期条件等の設定を行う。その内容は本章の[第4節](http://www.yaho  |
| o.co.jp)に示すように、解析対象の河床部を取り囲む河岸・高水敷・堤防等 |
| の形状の設定（[4.2](http://www.yahoo.co.jp)）、構造物や植生等の地被  |
| ・地物の粗度や抵抗等としての流れ場の計算への組込み（[4.3](http://ww  |
| w.yahoo.co.jp)）、床止工、根固工等の構造物や露岩部といった河床の固定 |
| 箇所及び河岸侵食箇所における流砂・河床の計算法での取扱い([4.4](http  |
| ://www.yahoo.co.jp))、計算対象区間の上下流端における水位・流量及び土 |
| 砂の供給と搬入・搬出（量と粒度分布）の時系列変化の設定([4.5](http:// |
| www.yahoo.co.jp)、[4.6](http://www.yahoo.co.jp))、そして計算開始時点 |
| の河床の形状・粒径の設定（[4.7](http://www.yahoo.co.jp)）から成る。  |
|                                                                      |
| また、土砂供給と河床の形状・粒径について                             |
| は、解析レベルに応じて設定を行う（[4.1](http://www.yahoo.co.jp)）。  |
|                                                                      |
| 最後に、解析の実施と検証・調整を行う。本章の[第5節](http://www.yaho  |
| o.co.jp)では、数値計算による解析([5.1](http://www.yahoo.co.jp))と、[ |
| 第4章](http://www.yahoo.co.jp)の河道特性調査等により得た河道状況デー |
| タ（[第4章](http://www.yahoo.co.jp)の[第3節](http://www.yahoo.co.jp  |
| )）を用いた検証・調整([5.2](http://www.yahoo.co.jp))について述べる。 |
|                                                                      |
| また解析に用いるデータを                                             |
| 得るための調査という一方向的な関係でなく、調査内容の吟味に解析を利用 |
| して効率的、効果的に検証・調整を行うといったように、調査と解析を有機 |
| 的に組み合わせた検討について述べる([5.3](http://www.yahoo.co.jp))。  |
|                                                                      |
| 4.  本章の構成と解析の実施手順                                       |
+----------------------------------------------------------------------+

1.  []{#_Toc382986871 .anchor}目的に応じた解析レベルの設定

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  本章の[1.1](http://www.yahoo.co.jp) 位置付けと目的 で述べた解析の目的・用途と解析対象とする河道区間の河道特性等について、本章の[1.3](http://www.yahoo.co.jp) 解析レベル に示した流れ、流砂（掃流・浮遊）、河床高・粒径変化を記述する解像度又は範囲の観点から整理するなどにより、目的等に応じて解析レベルを適切に設定することを標準とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜例　示＞

+----------------------------------------------------------------------+
| 河                                                                   |
| 床高の解析レベルは、目的・用途を満たす観点から設定することができる。 |
|                                                                      |
| たとえば、流下能力の評                                               |
| 価の目的では、平均河床高が得られるレベル\[1DB\]、また局所洗掘深の予  |
| 測の用途では、河床高の平面分布が得られるレベル\[2DB\]と設定できる。  |
|                                                                      |
| ただし、直接必要とする情報が平均河床高（又は河積）である目的         |
| ・用途の場合でも、たとえば河口砂州のフラッシュのように河床形状の平面 |
| 的変動が卓越する事象を対象とする場合には\[2DB\]として設定してよい。  |
|                                                                      |
| また、全体的には平均河床高                                           |
| が得られるレベル\[1DB\]で十分であるが、一部に平面的変動が卓越する事  |
| 象が含まれている場合には、その事象を特に重視する目的・用途の場合を除 |
| いて、その部分に適した流れ・流砂・河床高の計算法を組み込むなど（本章 |
| の[4.3](http://www.yahoo.co.jp)､[4.4](http://www.yahoo.co.jp)参照）  |
| の適切な対応を行った上で、レベル\[1DB\]として設定することができる。  |
|                                                                      |
| 粒径の解析レベルは、対象河道区間の河床材料粒径、すなわち材料m（第4章 |
| 河道特性調査 [2.4](http://www.yahoo.co.jp)                           |
| 参照）に関する以下の観点を踏まえた設定とすることができる。           |
|                                                                      |
| 1.  空間的な構成材料の一様性                                         |
|                                                                      |
| 対象区間の全域で材料mの粒径範囲が同一であり、                        |
| 場所により材料mの粒径範囲に相違が認められない場合は、一様性が高い。  |
|                                                                      |
| 42. 粒径の均一性                                                     |
|                                                                      |
| 材料mの粒度分布の淘                                                  |
| 汰がよく（たとえば*d*~84~/*d*~16~が小さい）、ある特定の粒径を中心に  |
| 粒径範囲が狭い範囲に集中している場合は均一性が高く、淘汰が悪く、広い |
| 粒径範囲にわたって偏りない粒度分布となっている場合は、均一性が低い。 |
|                                                                      |
| 一様性と均一性が共に高い場合には一様粒径として扱うレベ               |
| ル\[U\]、それ以外を混合粒径として扱うレベル\[M\]とすることができる。 |
|                                                                      |
| 流砂                                                                 |
| の解析レベルは、以下の観点等を踏まえて総合的に設定することができる。 |
|                                                                      |
| a)  解析条件とした水理量の下で浮遊                                   |
| 形態となる粒径成分の有無（第4章の[6.2](http://www.yahoo.co.jp)参照） |
|                                                                      |
| b)  掃                                                               |
| 流砂との対比として浮遊砂が河床の形状・粒径の変化に及ぼす影響の大きさ |
|                                                                      |
| c)  目的・用途において（た                                           |
| とえば総合的な土砂管理等）浮遊砂量が直接的に必要とされる情報であるか |
|                                                                      |
| セグ                                                                 |
| メント類型が適用できる沖積河川の場合では、礫を対象とする場合には\[B  |
| L\]を、砂又は砂礫を対象とする場合には\[BSL\]と設定することができる。 |
|                                                                      |
| 流れ場の解析レベ                                                     |
| ルは、河床高の解析レベルと対応させて、\[1DB\]では流れ場のレベル\[1D  |
| F\]と\[2DF'\]、\[2DB\]では\[2DF\]～\[3DF\]から設定することができる。 |
|                                                                      |
| 更にレベルを絞り込むに当たっては、着目した河                         |
| 床変動に深く関わる流速分布を適切に算定する視点から行うことができる。 |
|                                                                      |
| まず\[1DB\]について                                                  |
| は、河道横断方向の流速分布に着目し、単断面河道のように一様流速として |
| 取り扱える流れ場は\[1DF\]、複断面河道のように河床部と高水敷等で断面  |
| 平均流速に有意な差がある流れ場は\[2DF'\]として設定することができる。 |
|                                                                      |
| \[2DB\]では平面・水深                                                |
| 方向の流速分布に着目して設定することができる。その際、非静水圧分布と |
| なるなど\[3DF'\]では取り扱えない強い3次元性を示す流れ場に用いる3次元 |
| 解析\[3DF\]は、河川管理の実務における実用性を高めていく段階である。  |
|                                                                      |
| こうした状況                                                         |
| を踏まえ、平面的流速分布を主要因とする場合には\[2DF\]、それに加えて2 |
| 次流を含む水深方向の流速分布も考慮する必要がある場合には\[2DF+\]又は |
| \[3DF'\]として設定することができる。\[2DF+\]として設定               |
| する際には、別途用意する2次流成分の算定式の適用性について吟味する。  |
|                                                                      |
| \[3DF\]については、水理模型実験と一体的に                            |
| 実施するなど、対象とした事象への適用性について吟味するためのデータ取 |
| 得の見込みも併せて検討した上で、設定の適否について判断するのがよい。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

レベル\[3DF\]の3
次元性の強い流れであり、かつ砂礫粒子の運動の非平衡性を考慮して河床変動計算を行った事例として、下記の資料が参考となる。

1.  長田信寿，細田尚，村本嘉雄，中藤達昭：3次元移動座標系・非平衡流砂モデルによる水制周辺の河床変動解析，土木学会論文集，No.684
    Ⅱ-56，pp.21-34，2001.

```{=html}
<!-- -->
```
198. 福岡捷二，富田邦裕，掘田哲夫，宮川朝浩：橋脚まわりの局所洗掘推定のための実用的数値シミュレーションの開発，土木学会論文集，No.497Ⅱ-28，pp.71-79，1994.

     1.  []{#_Toc382986872 .anchor}計算法の設定

         1.  []{#_Toc382986873 .anchor}解析レベルに応じた計算法の選定

＜考え方＞

+----------------------------------------------------------------------+
| 計算法の設定項目は、表6-3-1に示す河床形状、粒度                      |
| 分布、掃流砂、巻き上げ量（基準面濃度）、土砂濃度分布として構成する。 |
|                                                                      |
| 表                                                                   |
| 中の英数字記号は、計算法の【種別】を表しており、その内容について本節 |
| の[3.2](http://www.yahoo.co.jp)～[3.7](http://www.yahoo.co.jp)におい |
| て説明している。各計算法の種別は、[第2節](http://www.yahoo.co.jp)で  |
| 設定した解析レベルに応じて表6-3-1に基づいて選定するのを標準とする。  |
|                                                                      |
| 表中の各欄は、各レベルにおいて＜標準＞とする計算法                   |
| である。一部の欄には括弧書きとして＜推奨＞とする計算法を示している。 |
|                                                                      |
| ここで＜推奨＞は、                                                   |
| 標準として示す計算法では解析対象とした事象を十分に再現することができ |
| ず、＜推奨＞として示す高度な計算法を用いる必要がある場合に選定する。 |
|                                                                      |
| 表6-3-1　解析レベルに応じた計算法の選定（標準：種別について          |
| は[3.3](http://www.yahoo.co.jp)～[3.7](http://www.yahoo.co.jp)参照） |
|                                                                      |
| ![](media/image178.emf){width="4.845833333333333in"                  |
| height="3.997916666666667in"}                                        |
+----------------------------------------------------------------------+

2.  []{#_Toc382986874 .anchor}流れの計算法の設定

＜標　準＞

+----------------------------------------------------------------------+
| 流れの計算法のレベル\[1DF\]\[2DF'\]\[2DF\]\[3DF'\]については、第5章  |
| 河川における洪水流の水理解析                                         |
| の[4.1](http://www                                                   |
| .yahoo.co.jp)と[4.2](http://www.yahoo.co.jp)、[4.3](http://www.yahoo |
| .co.jp)と[4.4](http://www.yahoo.co.jp)、[4.5](http://www.yahoo.co.jp |
| )、[4.6](http://www.yahoo.co.jp)に基づいて設定することを標準とする。 |
|                                                                      |
| \[2DF+\]は\[                                                         |
| 2DF\]と別途用意する2次流の算定式を組み合わせた流れ場の計算法である。 |
+----------------------------------------------------------------------+

3.  []{#_Toc382986875 .anchor}河床形状の計算法の設定

＜標　準＞

+----------------------------------------------------------------------+
| 河床形状*ｚ~B~*は流砂の連続方程式により算定する。                    |
|                                                                      |
| 種別【1B】【2B                                                       |
| 】【1BS】【2BS】の流砂の連続方程式は式(6-3-1)～(6-3-4)を標準とする。 |
|                                                                      |
| 1.  種別【1B】の計算法（一次元・掃流のみ）                           |
|                                                                      |
| > (6-3-1）                                                           |
| >                                                                    |
| > 種別【2B】の計算法（二次元・掃流のみ）                             |
| >                                                                    |
| > (6-3-2）                                                           |
|                                                                      |
| 43. 種別【1BS】の計算法（一次元・掃流と浮遊）                        |
|                                                                      |
| > 　 (6-3-3）                                                        |
|                                                                      |
| 44. 種別【2BS】の計算法（二次元・掃流と浮遊）                        |
|                                                                      |
| > (6-3-4）                                                           |
|                                                                      |
| ここに、*z~B~*は河床高、*q~Bx~*、*q~By~*は河                         |
| 道縦横断方向の掃流砂量、*q~su~*は浮遊土砂の巻き上げ量、*c~0~*は浮遊  |
| 土砂の底面濃度、λは河床構成材料の空隙率、w~0~は浮遊土砂の沈降速度、  |
| *B*は河床部の幅、*x*、*y*は河道縦横断方向の座標軸、*t*は時刻である。 |
|                                                                      |
| また、記号「」は河床の幅*B*にわ                                      |
| たっての平均値を表し、たとえばは平均河床高である。式(6-3-1)～(6-3-4  |
| )を混合粒径に適用する場合の*q~B~、q~su~、c~0~、w~0~*の計算法は本節の |
| [3.5](http://www.yahoo.co.jp)～[3.7](http://www.yahoo.co.jp)に示す。 |
|                                                                      |
| 式(6-3-1)～(6-3-4)に各時点の掃流                                     |
| 砂量、巻き上げ量、底面濃度を与えて時間積分することにより、任意の時刻 |
| *t*における河床高を算定する。その際、*λ*は定数とするのを標準とする。 |
+----------------------------------------------------------------------+

1.  []{#_Toc382986876 .anchor}粒度分布の計算法の設定

＜考え方＞

+----------------------------------------------------------------------+
| 混合粒径の粒度分布の算定手法とし                                     |
| て、沖積河川での適用事例が多い交換層の枠組みを用いるのを標準とする。 |
|                                                                      |
| この枠組みに基づく粒度分布・流砂量の計算の概要は以下のとおりである。 |
|                                                                      |
| -   河床材料の粒度分布を、*n*種類の一様粒径*d~i~*                    |
|     を含有率*f~i~*で混合した                                         |
| 混合粒径材料として近似する。以下、粒径の種類を粒径階*d~i~*と呼ぶ。こ |
| こに、*n*は整数であり*i*は1から*n*までの整数値をとる。各粒径階*d~i~* |
| の間隔は、第4章[2.4.3](http://www.yahoo.co.jp)に述べた各ポピューショ |
| ンの移動性や流送量が適切に評価されるように設定することが重要である。 |
|                                                                      |
| -   混合粒径の流砂量式を用いて、                                     |
| 各粒径階の流砂量を算定する（本節の[3.5.2](http://www.yahoo.co.jp)、  |
| [3.6](http://www.yahoo.co.jp)、[3.7](http://www.yahoo.co.jp)参照）。 |
|                                                                      |
| -   各                                                               |
| 粒径階の連続方程式を用いて*f~i~*を算定する(式(6-3-5)～(6-3-8)参照)。 |
|                                                                      |
| -   河床高は式(6-3-1)～(6-3-4)の流砂の連続方程式によ                 |
| り算定するが、その際、*q~B~、q~su~、c~0~w~o~*には各粒径階*q~Bi~、q~s |
| ui~、c~0i~w~0i~*の合算した値*Σq~Bi~、Σq~sui~、Σc~0i~w~0i~*を用いる。 |
|                                                                      |
| 交換層の枠組みを用い                                                 |
| た計算法（各種の流砂量式を含む）については、*d*~84~/*d*~16~が大きい  |
| など粒径範囲が広い河床材料、2峰性の粒度分布を有する河床材料、及び石  |
| 礫で構成される河床材料等への適用性について知見が蓄積されてきている。 |
|                                                                      |
| 蓄積されつつある知見も適宜                                           |
| 参考として、本枠組みの適用性について検証・吟味することが重要である。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

交換層の枠組みに関する基本的考え方については資料1)が参考となる。その修正の一例として資料2)が参考となる。流送形態が異なる2つの粒径集団の取り扱う場合及び礫間への砂の堆積・抜け出しについては資料3)～5)が参考となる。大礫等が流れ場や砂礫の流送に支配的な影響を及ぼす場合については資料6)～9)が参考となる。

1.  平野宗夫：Armoringをともなう河床低下について，土木学会論文報告集，第195号，pp.55-65，1971.

```{=html}
<!-- -->
```
199. 芦田和男，江頭進治，劉柄義：二層モデルによる複断面河道の流れ及び河床変動の数値解析，京都大学防災研究所年報，第35号B-2，pp.42-62，1992.

200. 芦田和男，藤田正治：平衡及び非平衡浮遊砂量算定の確率モデル，土木学会論文集，第375号
     Ⅱ-6 ，pp.107-116，1986.

201. 藤田光一，山原康嗣，富田陽子，伊藤嘉奈子，小路剛志：大礫床表面における砂の堆積状況と浮遊砂量との関係についての実験的研究，水工学論文集，第52巻，pp.547-552，2008.

202. 関根正人，林将宏：礫・シルト充填河床モデルを用いた礫河道の準二次元河床変動解析，水工学論文集，第51巻，pp.973-978，2007.

203. 辻本哲郎，細川迭男：急勾配水路のおける礫の限界掃流力と流砂量，土木学会論文集，No.411
     Ⅱ-12，pp.127-134，2007.

204. 芦田和男，大同淳之，高橋保，水山高久：急勾配流れの抵抗と限界掃流力に関する研究，京都大学防災研究所年報，16(B)，pp.481-494，1973.

205. 岡部健士，肥本一郎：大径礫を伴う山地河川における流砂の有効掃流力に関する研究，第30回水理講演会論文集，pp.247-252，1986.

206. 長田健吾，福岡捷二：石礫河川の土砂移動機構に着目した1次元河床変動解析法の開発，水工学論文集，第52巻，pp.625-630，2008.

＜標　準＞

+----------------------------------------------------------------------+
| 河床の各粒径階の含有率                                               |
| *f~bi~*は、各粒径階の連続方程式により算定する。種別【1fB】【2fB】【  |
| 1fBS】【2fBS】の*f~i~*の連続方程式は式(6-3-5)～(6-3-8)を標準とする。 |
|                                                                      |
| 1.  種別【1fB】の計算法（一次元・掃流のみ）                          |
|                                                                      |
| > (6-3-5）                                                           |
|                                                                      |
| 45. 種別【2fB】の計算法（二次元・掃流のみ）                          |
|                                                                      |
| > (6-3-6）                                                           |
|                                                                      |
| 46. 種別【1fBS】の計算法（一次元・掃流と浮遊）                       |
|                                                                      |
| > (6-3-7）                                                           |
|                                                                      |
| 47. 種別【2fBS】の計算法（二次元・掃流と浮遊）                       |
|                                                                      |
| > (6-3-8）                                                           |
|                                                                      |
| ここに、*z~B~*は河床高、*q~Bx~、q~By~*は河道縦横断方向の掃           |
| 流砂量、*λ*は河床構成材料の空隙率、*a*は交換層厚、*f~bi~*、*f~b0i~*~ |
| 、~*f~Bi~*はそれぞれ河床表面の交換層、交換層の下部の河床及び掃流砂に |
| おける粒径階d~i~の含有率、*q~sui~*､*c~0i~*､*w~0i~*は粒径階*d~i~*の浮 |
| 遊土砂の巻き上げ量、底面濃度、沈降速度*x*、*y*は河道縦横断方向の座標 |
| 軸、*t*は時刻である。*f~Bi~*~、~*c~0i~*の算定手法については本節の[3  |
| .5.2](http://www.yahoo.co.jp)、[3.7](http://www.yahoo.co.jp)に示す。 |
|                                                                      |
| 式(6-3-5)～(6-3-8)に各時点の掃流砂量、巻き上げ量、                   |
| 底面濃度、掃流砂の含有率を与えて時間積分することにより、任意の時刻*t |
| *における含有率を算定する。その際、*a*､λは定数とするのを標準とする。 |
|                                                                      |
| *a*は、平坦河床では最大粒径程度、小                                  |
| 規模河床波が形成される場合には河床波の波高程度を目安として設定する。 |
+----------------------------------------------------------------------+

1.  []{#_Toc382986877 .anchor}掃流砂の計算法の設定

    1.  []{#_Toc382986878 .anchor}一様粒径の掃流砂

```{=html}
<!-- -->
```
1.  一次元解析の掃流砂量式

＜標　準＞

+----------------------------------------------------------------------+
| 掃流砂量*q~B                                                         |
| ~*は、ある単位幅の断面を単位時間当たりに通過する砂礫粒子群の総体積と |
| して算定する。種別【BaBL】（一次元・一様粒径）の掃流砂量式としては、 |
| 粒径*d*、掃流力*τ*、限界掃流力*τ~c~*、水の密度*ρ*、砂礫粒子の密度*σ* |
| 、重力加速度gを必ず含む関数である式(6-3-9)を用いることを標準とする。 |
|                                                                      |
| > *q~B~＝f（d,τ,τ~c~,ρ,σ,g,etc）* (6-3-9）                           |
|                                                                      |
| ここに、*etc*は*q~B~*の関数に必                                      |
| ずしも含まれない上記以外の水理量や小規模河床波に関わる特性量である。 |
|                                                                      |
| 式(6-3-9)は、河                                                      |
| 床波の形態や流水に対する抵抗（粗度）などの小規模河床波の諸特性を用い |
| て、掃流砂量に小規模河床波が及ぼす影響を評価できるものを標準とする。 |
+----------------------------------------------------------------------+

＜例　示＞

+----------------------------------------------------------------------+
| 種別【                                                               |
| BaBL】の掃流砂量式として、以下の分類に属する式を用いることができる。 |
|                                                                      |
| 1.  掃流力*τ*を小規模河床波の形状抵抗と河床表面                      |
| との摩擦力による成分に分割し、後者の摩擦が掃流砂の営力としての有効成 |
| 分である有効掃流力*τ~e~*とする考え方を採用した式。この場合、式(6-3-  |
| 9)のほかにτ~e~の算定式を別途用意し、式(6-3-9)のτとしてτ~e~を用いる。 |
|                                                                      |
| ```{=html}                                                           |
| <!-- -->                                                             |
| ```                                                                  |
| 48. 粗度係数など小規模河床波に関                                     |
| わる特性量を、式(6-3-9)のetcとした変数として関数に組み込んだ式。この |
| 場合、粒径や水理量から用いた特性量を算定するための式を別途用意する。 |
|                                                                      |
| 49. 小規模河床波の形態に応じて適用範囲が定められた式。この場合、     |
| 小規模河床波の形態区分を定義し、各形態が生じる条件を粒径や水理量によ |
| り判定できる手法を別途用意し、形態区分に応じて掃流砂量式を選定する。 |
|                                                                      |
| 種                                                                   |
| 別【BaBL】の掃流砂量式として、１）の分類である芦田・道上の式とMeyer･ |
| Peter-Müller式、２）の分類である佐藤・吉川・芦田の式を用いてもよい。 |
|                                                                      |
| ・芦田・道上の式                                                     |
|                                                                      |
| > (6-3-10)                                                           |
| >                                                                    |
| > (6-3-11)                                                           |
|                                                                      |
| ・Meyer･Peter-Müller式                                               |
|                                                                      |
| > (6-3-12)                                                           |
| >                                                                    |
| > 　　　(d~90~はcm単位) (6-3-13)                                     |
|                                                                      |
| ここに*、q~B\*~*は無次元化した掃流砂量、*τ~\*~*は無                  |
| 次元掃流力、*τ~\*c~*は無次元限界掃流力、u~\*~(=(τ/ρ)^0.5^)は摩擦速度 |
| 、u~\*e~(=(τ~e~/ρ)^0.5^)は有効摩擦速度、Rは径深、ρは水の密度である。 |
|                                                                      |
| ・佐藤・吉川・芦田の式                                               |
|                                                                      |
| > (6-3-14)                                                           |
| >                                                                    |
| > ｎ≧0.025でψ＝0.623                                                 |
| >                                                                    |
| > ｎ＜0.025でψ＝0.623(40ｎ)^-3.5^                                    |
|                                                                      |
| ここに、ｎはマニングの粗度係数、Ｆは図6-3-1に示すの関数である。      |
|                                                                      |
| ![](media/image198.png){width="2.4375in" height="2.28125in"}         |
|                                                                      |
| 14. 佐藤, 吉川, 芦田の式におけるＦとτ~０~/ τ~ｃ~ との関係            |
|                                                                      |
| 無次元限界                                                           |
| 掃流力*τ~\*c~*は、式(6-3-15)に示す岩垣式により算定することができる。 |
|                                                                      |
| > (6-3-15)                                                           |
| >                                                                    |
| > （水温20℃の場合）（dはcm単位）                                     |
+----------------------------------------------------------------------+

＜考え方＞

+----------------------------------------------------------------------+
| 掃流砂の計算法設定の位置付けを図                                     |
| 6-1-1の基本フレームに立ち返って俯瞰すると、小規模河床波を起点として  |
| 流砂量式を設定するが、その他に粗度係数、更にレベル\[M\]の場合には交  |
| 換層厚の設定を行い、流れ、流砂、河床状況の各計算を繰り返し行う中で、 |
| それら設定の影響が合わさった形で計算結果である河床状況に反映される。 |
|                                                                      |
| したがって、河床状況の再現性を向上                                   |
| するに当たっては、流砂量式の選定は全体の一部であり、粗度係数等のパラ |
| メータの設定や他の計算法の設定と併せて総合的に行うことが重要である。 |
|                                                                      |
| 以上の設定は、図6-1-2に示した作業手順の「検証・調整」段              |
| 階における調整項目の一つであり、その他に各種条件等も調整項目となる。 |
|                                                                      |
| これらの調整は、図6-1-1に矢印で示したように計算法の内側と外          |
| 側に分かれているが、流れ、流砂、河床の状況の計算に受け渡され、最終的 |
| にそれらが合わさって流れ、流砂、河床の状況として調整の結果が現れる。 |
|                                                                      |
| したがっ                                                             |
| て、流砂量式の調整のみにこだわらず、各々の調整が各状況にどのように現 |
| れ、相互にどのように関係しているかをよく理解し、その知見と調整の根拠 |
| を固める上で利用できる検証データの質・量とを対置させて、各調整項目の |
| 合理的な再設定に結び付けるというスタンスで取り組むことが重要である。 |
+----------------------------------------------------------------------+

42. 二次元解析の掃流砂量式

＜標　準＞

+----------------------------------------------------------------------+
| 二次元解析で用いる掃流砂量は、掃流砂量の大きさとそ                   |
| の流送方向の組合せである流砂量ベクトル=(q~Bx~,q~By~)として算定する。 |
|                                                                      |
| 種別【2BL】（二次元・一様粒径）の掃流砂量式としては、粒径d、掃流力   |
| ベクトル=(τ~x~,τ~y~)、限界掃流力*τ~c~*、水の密度*ρ*、砂礫粒子の密度  |
| *σ*、重力加速度*g*、河床の最急勾配の大きさとその方向を表すベクトル＝ |
| (i~bx~,i~by~)を必ず含む関数である式(6-3-16)を用いるのを標準とする。  |
|                                                                      |
| > (6-3-16)                                                           |
|                                                                      |
| ここに、*i~bx~、i~by~*は河道縦横断方向の勾配、*etc*はの関数に        |
| 必ずしも含まれない上記以外の水理量や小規模河床波に関わる特性量である |
| 。式(6-3-16)は、式(6-3-9)と同様に小規模河床波の諸特性を用いて掃流砂  |
| 量ベクトルに小規模河床波が及ぼす影響を評価できる式であるものとする。 |
|                                                                      |
| 種別【2'BL】（二次元・一様粒径・線型近似）                           |
| の掃流砂量式としては、河床近傍の主流の流速成分に比べて二次流成分が十 |
| 分に小さく、かつ河床勾配が安息角に比べて十分に小さいという条件の下で |
| 式(6-3-16)の近似式として適用できる式(6-3-17)を用いるのを標準とする。 |
|                                                                      |
| > (6-3-17)                                                           |
|                                                                      |
| ここで、*α、m*は定数である。                                         |
+----------------------------------------------------------------------+

＜例　示＞

+----------------------------------------------------------------------+
| 種別【2BL】の掃流砂量式は、河床勾配が砂礫の水中安息角と同程度と      |
| なる河岸や砂州前縁部等の地形変化を取り扱う場合に用いることができる。 |
|                                                                      |
| 種別【2'BL】の掃流砂量式として、以下を適用することができる。         |
|                                                                      |
| 1.  掃流砂量の大きさ                                                 |
|                                                                      |
| 種別                                                                 |
| 【BaBL】の掃流砂量式である式(6-3-10)～(6-3-14)より算定する。ただし、 |
| *τ~\*C~*として式(6-3-18)の斜面上の無次元限界掃流力τ~\*cθ~を用いる。  |
|                                                                      |
| > (6-3-18)                                                           |
|                                                                      |
| こ                                                                   |
| こに、tanθは河床勾配の大きさ（＝）、φは河床材料の水中安息角である。  |
|                                                                      |
| 50. 掃流力ベクトルを用いた掃流砂量ベクトルの計算手法                 |
|                                                                      |
| > (6-3-19)                                                           |
|                                                                      |
| ここで、μ~d~,μ~f~は砂                                                |
| 礫粒子の動摩擦係数と静止摩擦係数で0.4程度、0.8～1.0程度の値をとる。  |
|                                                                      |
| 51. 河床近傍流速ベクトルを用いた掃流砂量ベクトルの計算手法           |
|                                                                      |
| 流                                                                   |
| れの運動方程式・連続方程式に基づいて主流u~s~（=(u^2^+v^2^)^0.5^）を  |
| 算定し、別途用意した式により2次流u~bn~を算定する流れの解析レベル【2D |
| F+】に適用する手法である。式(6-3-19)を用いる手法の傍流として位置付け |
| られ、を主流、2次流方向成分q~bs~、q~bn~に振り分ける式として河床近傍  |
| の主流速成分u~sb~と二次流成分u~nb~から成る河床近傍流速ベクトル(u~sb~ |
| ,u~nb~)を用いる。                                                    |
|                                                                      |
| > (6-3-20)                                                           |
|                                                                      |
| ここに、                                                             |
| q~Bs~=であり、上記した式(6-3-10)～(6-3-14)より算定することができる。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

種別【2BL】の流砂量ベクトルの計算については、下記の資料が参考となる。

1.  Kovacs, A., Parker, G.：A new vectorial bedload formulation and its
    application to the time evolution of straight river，Journal of
    Fluid Mechanics，Vol.267，pp.153-183，1994.

    1.  []{#_Toc382986879 .anchor}混合粒径の掃流砂

＜標　準＞

+----------------------------------------------------------------------+
| 混合粒径の掃流                                                       |
| 砂量は、各粒径階*d~i~*に分けて掃流砂量*q~Bi~*を算定するものである。  |
|                                                                      |
| 種別【BaBLM】（一次元・混合粒径）の掃流砂式としては、式(6-3-9)       |
| の*d*を粒径*d~i~*に、*τ~c~*を粒径*d~i~*の限界掃流力*τ~ci~*に置き換え |
| た上で、粒径階*d~ｉ~*が河床面に占める割合、すなわち交換層における粒  |
| 径階*d~i~*の含有率*f~bi~*を乗じた式(6-3-21)を用いるのを標準とする。  |
|                                                                      |
| > (6-3-21)                                                           |
|                                                                      |
| ここに、*etc*は*q~Bi~*の関数に必                                     |
| ずしも含まれない上記以外の水理量や小規模河床波に関わる特性量である。 |
|                                                                      |
| 種別【2BLM】（二次元・混                                             |
| 合粒径）【2'BLM】（二次元・混合粒径・線形近似）の掃流砂式としては、  |
| 式(6-3-16),(6-3-17)について上記の種別【BaBLM】と同様に置き換えとｆ~  |
| bi~を乗じることで得られる式(6-3-22),(6-3-23)を用いるのを標準とする。 |
|                                                                      |
| > (6-3-22)                                                           |
| >                                                                    |
| > (6-3-23)                                                           |
|                                                                      |
| なお、*etc*として表                                                  |
| した特性量で粒径に応じて変化するものは、上記と同様な置き換えを行う。 |
|                                                                      |
| 掃                                                                   |
| 流砂量における各粒径階の含有率*f~Bi~*は、式(6-3-24)により算定する。  |
|                                                                      |
| > (6-3-24)                                                           |
|                                                                      |
| ここに、*Σq~Bi~*は*                                                  |
| q~Bi~*の全粒径階にわたる総和として算定する掃流砂量（*q~B~*）である。 |
+----------------------------------------------------------------------+

＜例　示＞

+----------------------------------------------------------------------+
| 種別【BaBLM】【2'BLM】の掃流砂量式として、式(6-3-10)                 |
| ～(6-3-14)及び式(6-3-19)、(6-3-20)に上記＜標準＞に示したように置き換 |
| えを行った上で*f~bi~*を乗じた式を用いることができる。その際、各粒径  |
| 階の無次元限界掃流力*τ~\*ci~*として式(6-3-25)を用いることができる。  |
|                                                                      |
| ・芦田・道上による修正Egiazaroff式                                   |
|                                                                      |
| > (6-3-25)                                                           |
|                                                                      |
| ここに、*d~m~*は交換層の平均粒径、τ~ci、~τ~cm~は粒径*d~i~*、*d~m~*の |
| 限界掃流力である。τ~cm~は、式(6-3-15)に示した岩垣式から算定できる。  |
|                                                                      |
| なお、d~84~/d~16~が大きいなど粒径範囲が広い河床材料、2               |
| 峰性の粒度分布を有する河床材料、及び石礫で構成される河床材料等への式 |
| (6-3-25)の適用性について知見が蓄積されてきており、このような知見も適 |
| 宜参考として、それぞれの河床材料に適した式を用いることが重要である。 |
+----------------------------------------------------------------------+

1.  []{#_Toc382986880 .anchor}巻き上げ量（又は基準面濃度）の計算法の設定

＜標　準＞

+----------------------------------------------------------------------+
| 巻き上げ量*q~su~*は、単位面積当たりの河                              |
| 床面から単位時間当たりに浮上する砂など非粘着性の粒子群の総体積として |
| 算定する。巻き上げ量は、式(6-3-26)により基準面濃度*Ca*から算定する。 |
|                                                                      |
| > (6-3-26)                                                           |
|                                                                      |
| *C~a~*は基準面高さ                                                   |
| *a*（河床面からの高さ）における見かけの濃度である。ただし、平衡状態  |
| (*q~su~*‐*c~0~w~0~*)=0では、底面濃度*c~0~*が基準面濃度と同値となる。 |
|                                                                      |
| 種別【BaE】（一様粒径）の基準面濃度式としては、沈降速度*w~0~*、摩    |
| 擦速度*u~\*~*を必ず含む関数である式(6-3-27)を用いるのを標準とする。  |
|                                                                      |
| > (6-3-27)                                                           |
|                                                                      |
| ここに、*etc*は*C~a~*                                                |
| の関数に必ずしも含まれない上記以外の水理量や土砂粒子の特性量である。 |
|                                                                      |
| 混合粒径の基準面濃度                                                 |
| 式は、各粒径階*d~i~*に分けて基準面濃度*C~ai~*を算定するものである。  |
|                                                                      |
| 種別【BaEM】（混合粒径）の基準面濃度                                 |
| 式としては、式(6-3-27)の*w~0~*を粒径*d~i~*の沈降速度*w~0i~*に置き換  |
| えた上で、粒径階d~ｉ~が河床面に占める割合、すなわち交換層における粒  |
| 径階*d~i~*の含有率*f~bi~*を乗じた式(6-3-28)を用いるのを標準とする。  |
|                                                                      |
| > (6-3-28)                                                           |
|                                                                      |
| なお、*etc*として表                                                  |
| した特性量で粒径に応じて変化するものは、上記と同様な置き換えを行う。 |
+----------------------------------------------------------------------+

＜例　示＞

+----------------------------------------------------------------------+
| 種別【B                                                              |
| aE】の基準面濃度式として、式(6-3-29)～(6-3-31)を用いることができる。 |
|                                                                      |
| ・ Lane-Kalinske式                                                   |
|                                                                      |
| > (6-3-29)                                                           |
|                                                                      |
| ここに，*C~ｂ~*は河床面における基準面濃度である。                    |
|                                                                      |
| ・ 板倉・岸の式                                                      |
|                                                                      |
| > (6-3-30)                                                           |
| >                                                                    |
| > 　　 (6-3-31)                                                      |
| >                                                                    |
| > 　　（τ\*\>10^-1^） (6-3-32)                                       |
|                                                                      |
| ここに、                                                             |
| *C~ａ~*は基準面高さ*a*＝0.05hにおける基準面濃度、α~\*~=0.14、*K*=0.  |
| 008、*B~\*~*=0.143、η~0~=0.5、*σ*は砂礫の密度、*ρ*は水の密度である。 |
|                                                                      |
| 式(6-3-32）は                                                        |
| τ\*\>10^-1^において式(6-3-31）のΩの近似式として用いることができる。  |
|                                                                      |
| 沈降速度*w~0~*は、式(6-                                              |
| 3-33)、(6-3-34)に示すRubeyの式及び鶴見式により算定することができる。 |
|                                                                      |
| > 　 (6-3-33)                                                        |
| >                                                                    |
| > (6-3-34)                                                           |
|                                                                      |
| ここに、*d*は粒径、*σ*は砂礫の密度、*ρ*は水の密度、*g*は重力加速     |
| 度、*ν*は水の動粘性係数である。式(6-3-34)に示した鶴見公式はσ＝2.65,  |
| 水温25℃に対して求めたものである                                      |
|                                                                      |
| 種別【                                                               |
| BaEM】の基準面濃度式として、式(6-3-29)～(6-3-32)に上記＜標準＞に示し |
| たように置き換えを行った上で*f~bi~*を乗じた式を用いることができる。  |
+----------------------------------------------------------------------+

＜参考となる資料＞

微細粒子の沈降における凝集や巻き上げにおける粘着力の影響については、下記の資料が参考となる。

1.  鈴木健太，島元尚徳，久保世紀，福岡捷二：筑後川感潮域の洪水中の河床変動解析，水工学論文集，第55巻，pp.877-882，2011.

```{=html}
<!-- -->
```
207. 山本晃一，長沼宏一，渡邊明英，大森徹治：鶴見川河口部の土砂堆積と浚渫計画‐細粒物質を河床材料に持つ河川の河床変動モデルの開発‐，建設省関東地方建設局京浜工事事務所，1993.

208. 角哲也，井口真生子：貯水池に堆積した微細粒土砂の浸食特性に関する研究，水工学論文集，第51巻，pp.871-876，2007.

209. 小暮和史，首藤伸夫：貯水池における濁質物質の堆積と洗掘，第24回水理講演会論文集，pp.265-270，1980.

210. 海田輝之，楠田哲也，二渡了，粟谷陽一：柔らかい底泥の巻き上げ過程に関する研究，土木学会論文集，第393号
     Ⅱ-9，pp.33-42，1988.

     1.  []{#_Toc382986881 .anchor}土砂濃度分布の計算法の設定

＜標　準＞

+----------------------------------------------------------------------+
| 土砂濃度分布*C*は浮遊土砂の移流拡散方程式により算定する。            |
|                                                                      |
| 種別【1DC                                                            |
| 】【2DC】【3DC】の移流拡散方程式は式(6-3-35)～(6-3-37)を標準とする。 |
|                                                                      |
| 1.  種別【1DC】の計算法（一次元）                                    |
|                                                                      |
| > (6-3-35)                                                           |
|                                                                      |
| こ                                                                   |
| こに、*A*は流れの断面積、*Q*は流量、は浮遊砂濃度の流下断面平均値、、 |
| は巻き上げ量と                                                       |
| 底面濃度の川幅*B*にわたる平均値、は一次元の土砂濃度拡散係数である。  |
|                                                                      |
| 52. 種別【2DC】の計算法（二次元）                                    |
|                                                                      |
| > (6-3-36)                                                           |
|                                                                      |
| ここ                                                                 |
| に、､は別途、洪水流の解析により算定する*x、y*軸方向の水深平均流速、  |
| は水深方向の平均土砂濃度、は二次元の土砂濃度拡散係数である。         |
|                                                                      |
| 53. 種別【3DC】の計算法（三次元）                                    |
|                                                                      |
| > (6-3-37)                                                           |
|                                                                      |
| ここに、*u､v､w*は別途、洪水流の解析により算定する*x、y、             |
| z*軸方向の流速、*ε*は土砂濃度拡散係数、*z*は鉛直方向の座標軸である。 |
|                                                                      |
| 式(6-3-35)～(6-3-37)に各時点の流速・水深等と巻き上げ量（又           |
| は基準面濃度と沈降速度の積）を与えて時間積分することにより、任意の時 |
| 刻*t*における底面濃度*c~0~*を算定する。その際、式(6-3-35)、(6-3-36)  |
| では、と及びと*c*~0~の関係を定めるため、濃度*c*の*z*軸方向分布式を別 |
| 途与える。この濃度分布式として、式(6-3-38)に示す関数形の式を用いる。 |
|                                                                      |
| > (6-3-38)                                                           |
|                                                                      |
| ここに、*Z'*                                                         |
| は河床面を基準とした水深方向の座標軸、*a*は土砂濃度が底              |
| 面濃度*c~0~*をとる高さである。式（6-3-38）の水深方向に平均することで |
| と*c~0~*の関係を与える。なおとの                                     |
| 関係を定める際には、式(6-3-38)右辺の変数に川幅方向の平均値を用いる。 |
|                                                                      |
| 混合粒径の浮遊土砂の移流拡散方程式は、各粒径階*d~i~*に分けて濃度     |
| *c~i~*を算定するものである。種別【1DCM】【2DCM】【3DCM】の移流拡散方 |
| 程式としては、式(6-3-35)～(6-3-38)の*c~0~、w~0~、q~su~*を各粒径*d~i  |
| ~*の*c~0i~*、*w~0i~*、*q~usi~*に置き換えた式を用いるのを標準とする。 |
+----------------------------------------------------------------------+

＜例　示＞

+----------------------------------------------------------------------+
| 式(6                                                                 |
| -3-38)の濃度分布式として、式(6-3-39)、(6-3-40)を用いることができる。 |
|                                                                      |
| ・Rouse式                                                            |
|                                                                      |
| > （6-3-39）                                                         |
|                                                                      |
| ・Lane-Kalinske式                                                    |
|                                                                      |
| > （6-3-40）                                                         |
|                                                                      |
| ここに、κはカルマン定数、βは砂の                                     |
| 拡散係数と渦動粘性係数との比である。βは、既往の実験との比較から1.2程 |
| 度とするが、式(6-3-41)に示す*w~0~/u~\*~*の関数も用いることができる。 |
|                                                                      |
| > （6-3-41）                                                         |
|                                                                      |
| ここに、*k~1~、k~2~*は定数であり1.56、2.0である。                    |
+----------------------------------------------------------------------+

＜例　示＞

+----------------------------------------------------------------------+
| 種別【1BS】において、河床縦断形状の長期変化等の土砂濃度分布          |
| の非平衡性が無視できる事象を対象とした場合には、土砂濃度分布Cを式(6  |
| -3-35)により計算するのに換えて、を式(6-3-42)により算定し、これを式（ |
| 6-3-3）、(6-3-7)に代入して河床高及び粒度分布を計算することができる。 |
|                                                                      |
| > (6-3-42)                                                           |
|                                                                      |
| こ                                                                   |
| こでq~s~は浮遊砂量であり、ある単位幅の断面を単位時間当たりに通過する |
| 浮遊粒子群の総体積である。はq~s~の河床幅Bにわたっての平均値である。  |
|                                                                      |
| 浮遊砂量q~s~は、鉛直                                                 |
| 方向の流速分布u(z)、式(6-3-27),(6-3-28)の基準面濃度c~a~、及び式(6-3- |
| 38）の鉛直方向の濃度分布C(z)を用いて、式（6-3-43）により算定できる。 |
|                                                                      |
| > (6-3-43)                                                           |
|                                                                      |
| なお                                                                 |
| 、を算定する際には、式(6-3-43)右辺の変数に川幅方向の平均値を用いる。 |
+----------------------------------------------------------------------+

1.  []{#_Toc298428038 .anchor}各種条件等の設定

    1.  []{#_Toc382986883 .anchor}解析レベルに応じた条件等の設定

＜考え方＞

+----------------------------------------------------------------------+
| 各種条件などの設定項目は、表6-4-1に示すよう                          |
| に、河岸・高水敷・堤防等の河道地形([4.2](http://www.yahoo.co.jp))、  |
|                                                                      |
| 植物・構造物の水理作用([4.3](ht                                      |
| tp://www.yahoo.co.jp))、構造物や河岸等での流砂の計算条件([4.4](http: |
| //www.yahoo.co.jp))、水位・流量に関する境界条件([4.5](http://www.yah |
| oo.co.jp))、供給土砂・河道外搬出等の条件([4.6](http://www.yahoo.co.j |
| p))、河床に関する初期条件([4.7](http://www.yahoo.co.jp))で構成する。 |
|                                                                      |
| 表中の英数字記号は、設定の【種別】を表しており、その内容に           |
| ついて本節の[4.6](http://www.yahoo.co.jp)、[4.7](http://www.yahoo.c  |
| o.jp)に示す。各設定の種別は、本章の[第2節](http://www.yahoo.co.jp)で |
| 設定した解析レベルに応じて表6-3-1に基づいて選定するのを標準とする。  |
|                                                                      |
| なお、表                                                             |
| 中の「○」は、種別はない設定項目であり、[4.2](http://www.yahoo.co.jp  |
| )～[4.5](http://www.yahoo.co.jp)に示す各レベル共通の方法で設定する。 |
|                                                                      |
| 表6-4-1　解析レベルに応じた各種条件の設定（種別について              |
| は[4.6](http://www.yahoo.co.jp)、[4.7](http://www.yahoo.co.jp)参照） |
|                                                                      |
| ![](media/image250.emf){width="5.698611111111111in"                  |
| height="3.9145833333333333in"}                                       |
+----------------------------------------------------------------------+

2.  []{#_Toc382986884 .anchor}河岸・高水敷・堤防等の河道地形の設定

＜標　準＞

+----------------------------------------------------------------------+
| 解析の対象である河床部を                                             |
| 取り囲む河岸・高水敷・堤防・分合流部等の河道地形は、レベル\[1DB\]で  |
| は河道横断方向の地形、\[2DB\]では河道横断方向及び平面の地形について  |
| 定期横断測量及び河道平面測量の成果等を用いて設定するのを標準とする。 |
|                                                                      |
| また、レベル\[2DB\]では一般座標系を用い、河岸法線形状、堤防          |
| 法線形状、定期横断測線の位置を考慮して座標を設定するのを標準とする。 |
+----------------------------------------------------------------------+

＜推　奨＞

  -----------------------------------------------------------------------------------------------------------------------------------------------------------------
  レベル【2DB】の解析では、解析の精度・解像度の向上の観点から、航空レーザ測量等による高解像度の連続的な河道地形測量成果を用いて河道形状を設定することを推奨する。
  -----------------------------------------------------------------------------------------------------------------------------------------------------------------

3.  []{#_Toc382986885 .anchor}植物・構造物等の水理作用の設定

＜標　準＞

+----------------------------------------------------------------------+
| 解                                                                   |
| 析対象区間における植生繁茂等の表面状況に応じた粗度、河川管理施設など |
| 構造物の水理作用について設定するものとする。植生等の表面状況に応じた |
| 粗度については、表面状況を草丈など粗度の大きさに関わる諸元に基づいて |
| 種別し、各種別の河道上での配置を植生図等により与え、配置ごとに第5章  |
| 河川における洪水流の水理解析                                         |
| の[第5節]                                                            |
| (http://www.yahoo.co.jp)に基づいて粗度係数を設定するのを標準とする。 |
|                                                                      |
| 河川管理施設等構造物の水理作用については、                           |
| 河川構造物台帳や河道平面測量等に基づいて配置するとともに、個々の構造 |
| 諸元と流れ場の解析レベル\[1DF\]\[2DF'\]\[2DF\]\[3DF'\]を考慮して各構 |
| 造物に適用する水理作用の設定法を適切に選定・設定するのを標準とする。 |
+----------------------------------------------------------------------+

＜例　示＞

+----------------------------------------------------------------------+
| 水理作用の設定法としては、                                           |
|                                                                      |
| 1)  河床面を覆うタイプの構造物を主対象として粗度要素                 |
| と見立てて粗度係数として与える方式（例：のり覆工、根固工、護床工等） |
|                                                                      |
| 2)  個々の構造物を粗度要                                             |
| 素と見立てて抗力係数を用いた抵抗則を適用する方式（橋脚、ベーン工等） |
|                                                                      |
| 3)  一連の構造物を多孔質の透水性粗度要素と見                         |
| 立てて透過係数を用いた抵抗則を適用する方式（透過式水制群、樹木群等） |
|                                                                      |
| 4)  構造物周辺の水位と流量の関係を別                                 |
| 途定めた式（たとえば堰の越流量式）を適用する方式（各種横断構造物等） |
|                                                                      |
| 5)  構造物本体の形状を計算格子に組み込んで流れ場の解析を行う方式     |
|                                                                      |
| 等があ                                                               |
| り、構造物の構造や流れ場の解析の種別に応じて使い分けることができる。 |
+----------------------------------------------------------------------+

＜推　奨＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  各種構造物及び植物群落を含む流れ場における境界混合係数や渦動粘性係数等については、解析対象とする水理量や構造物と植物群落の粗度・形状等に応じて設定することが望ましい。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------

1.  []{#_Toc318548306 .anchor}構造物や河岸等での流砂の計算条件の設定

＜標　準＞

+----------------------------------------------------------------------+
| 床止工、置換工、護岸、根固工、分流堰等は、特に掃流砂の挙             |
| 動に直接・間接に作用を及ぼして河床高・河床材料粒度を変化させ得るので |
| 、その作用を流砂量や河床高等の計算に適切に組み込むことを標準とする。 |
|                                                                      |
| 床止工や置換工等                                                     |
| の河床面をコンクリートや礫で被覆する構造物や岩盤が露出した河床面では |
| 、その表面位置より河床高は低下しないが、砂礫の堆積による河床上昇は生 |
| じ得る条件を付与して、流砂量及び河床高の計算を行うことを標準とする。 |
|                                                                      |
| また、半固結堆積物                                                   |
| や粘性土等が露出した河床面でありその場の水理量や掃流砂量に応じて侵食 |
| が生じる場合には、侵食の進行に伴って表面位置を低下させ、かつ砂礫の堆 |
| 積による河床上昇は生じ得る条件を付与して計算を行うことを標準とする。 |
|                                                                      |
| 護岸工、根固工を設けた河岸及び                                       |
| 侵食が非発生と設定した河岸では、その高さや法線形状により流れ場に制約 |
| を与え、それに応じた応答が河岸近傍の局所洗掘や砂州形状等として現れる |
| ため、特にレベル\[2DB\]では河岸法線形状・高水敷高の設定に当たり本節  |
| の[4.1](http://www.yahoo.co.jp)に従って適切に行うことを標準とする。  |
+----------------------------------------------------------------------+

＜推　奨＞

+----------------------------------------------------------------------+
| 河岸侵食によって河岸が後退する場合には、河                           |
| 岸近傍の流況変化、侵食された土砂の河床部への供給等により河岸の位置を |
| 固定した場合と局所洗掘等の河床高・河床材料粒径の応答が一般に異なる。 |
|                                                                      |
| これら応答を解析対象に加える必要がある場合には                       |
| 、目的に応じたレベルで河岸侵食を計算に適切に組み込むことを推奨する。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

非粘着性土砂の河岸侵食については資料1)が参考となる。粘性土河岸の侵食については資料2)～4)が参考となる。軟岸の侵食については資料5)が参考となる。

1.  長谷川和義：非平衡性を考慮した側岸侵食量式に関する研究，土木学会論文集，No.316，pp.37-50，1981.

```{=html}
<!-- -->
```
211. Darby, S.E. and Thorne, C.R. ：Numerical Simulation of Widening and
     Bed Deformation of Straight Sand-Bed Rivers. Ⅰ:Model Development,
     Journal of Hydraulics Engineering，ASCE，pp.184-193，1996.

212. 服部敦，藤田光一，平舘治，赤川正一，湯川茂夫：粘性土からなる自然河岸の侵食に関する現地観測とその予測計算について，水工論文集，第43号，pp.713-718，1999.

213. 宇多高明，望月達也，藤田光一，平林桂，佐々木克也，服部敦，藤井政人，深谷渉，平舘治
     ：洪水流を受けた時の多自然型河岸防御工・粘性土・植生の挙動　－流水に対する安定性・耐侵食性を判断するために－，土木研究所資料，第3489号，1997.

214. 井上卓也，泉典洋，米元光明，旭一岳：軟岩上の限界掃流力と軟岩の洗掘速度に関する実験，河川技術論文集，第17巻，pp.77-82，2011.

     1.  []{#_Toc382986887 .anchor}水位・流量に関する境界条件の設定

＜標　準＞

+----------------------------------------------------------------------+
| 流れの解析のレベル、定常・非定常流れ、条                             |
| 件設定に活用できる水文観測データの有無を踏まえて、解析対象領域の上流 |
| 端において流量又は水位、下流端において水位を与えることを標準とする。 |
|                                                                      |
| 計算対象とする出水期間は、解析対象区間の全域にわ                     |
| たり流砂量がごく小さく、そのため河床高・河床材料粒度の変化が微小と見 |
| なせる、ある一定の流量以下の期間を省略して設定することを標準とする。 |
+----------------------------------------------------------------------+

2.  []{#_Toc382986888 .anchor}供給土砂と河道外搬出・搬入の条件設定

    1.  []{#_Toc382986889 .anchor}供給土砂の設定

＜標　準＞

+----------------------------------------------------------------------+
| 供給土砂の設定として、計算対象領域                                   |
| とした本川及び支川の上流端から流入させる土砂量（又は粒径階別の土砂量 |
| ）を、領域境界部における流量など水理量に応じて与えるのを標準とする。 |
|                                                                      |
| 供給土砂は、表6-4-1に「土砂供給条                                    |
| 件」の各欄に示した種別、すなわち一様粒径と掃流砂のみの混合粒径【UM】 |
| 、混合型・通過型の浮遊砂を含む混合粒径【MSL】ごとに記述した以下の事  |
| 項を踏まえて、適切に設定する。なお、混合型・通過型については、第16章 |
| 総合的な土砂管理のための調査 の[2.2.1](http://www.yahoo.co.jp)       |
| 土砂動態のとらえ方 の沖積河川についての例示の記述内容を参照のこと。  |
|                                                                      |
| １）種別【UM】                                                       |
|                                                                      |
| a.  土砂流送と土砂供給がマクロには平衡状態と見なせる場合             |
|                                                                      |
| > 巨視的には河床が動的平衡状態にあり、かつ流量規模によらず掃流力など |
| 水理量が縦断的に概ね一様な区間は、この区間の土砂流送量をもって供給土 |
| 砂量に置き換えられることから、供給土砂の設定対象区間として選定する。 |
| >                                                                    |
| > そのような区間として、解析対象とする河道区間の上流にお             |
| いて、河床形状と河床材料が経年的に大きく変化せず安定しており、かつ河 |
| 道縦断方向に概ね一様な状況を呈する河道区間を選定するのを標準とする。 |
| >                                                                    |
| > このような区間を見いだすことができた場合、当該区間を助走区間として |
| 計算対象領域に含め、助走区間の上流端において動的平衡条件を満足するよ |
| うに供給土砂を与える。具体的には、本章[3.2](http://www.yahoo.co.jp)  |
| において設定した流れの計算法に基づいて助走区間の上流端の水理量を計算 |
| し、以下により設定する河床材料粒径に応じた掃流砂量と浮遊砂量（表6-4- |
| 1において流送形態が種別【BSL】に該当する場合のみ）を算定し、これらを |
| 供給土砂量として与える。助走区間の上流端に与える河床材料粒径は、助走 |
| 区間における河床材料調査の成果を用いて設定し、時間的に不変として扱う |
| 。ただし、助走区間とその下流の河道区間が同一のセグメント区分（第4章  |
| > 河道特性調査 [2.1.3](http://www.yahoo.co.jp)                       |
| > 沖積河道のセグメント区分とセグメントの類型                         |
| > を参照）に属する場合には、下流河                                   |
| 道区間における河床材料調査の成果を併せて用いて設定することができる。 |
| >                                                                    |
| > 以上に説明した供給土砂                                             |
| の設定の下で河床変動計算を行った結果、助走区間の下流端およびその付近 |
| において、有意な河床変動あるいは河床材料変化が計算された場合には、次 |
| のうちから適切と判断される方法を選択して、供給土砂の設定を修正する。 |
| >                                                                    |
| > ・助走区間の設定に修正の必要があるとの観点から                     |
| >                                                                    |
| > 助                                                                 |
| 走区間の位置や区間長等、および上流端に与えた河床材料粒径を修正する。 |
| >                                                                    |
| > ・活発                                                             |
| な河道変化が生じる河道区間と助走区間とが十分離れていないとの観点から |
| >                                                                    |
| > 計算対                                                             |
| 象領域をさらに上流に広げ、それに伴い助走区間もより上流に設定し直す。 |
| >                                                                    |
| > 上記の修正によっても、助走区間の下流端およびその付近において、     |
| 有意な河床高あるいは河床材料変化が計算される場合には、「土砂流送と土 |
| 砂供給がマクロには平衡状態」と見なすのは難しいと判断し、当該解析があ |
| る土砂供給の下での河道変化を表すものと捉えて計算結果を整理する（本章 |
| > [5.2](http://www.yahoo.co.jp) 解析の検証と較正                     |
| > の「目的としたレベルまで再現性が向上しない場合                     |
| 」に関する記載を参照のこと）。その際、計算結果として助走区間下流端に |
| おける土砂流送量（必要な場合には粒径階毎の量）を併せて整理しておく。 |
|                                                                      |
| b.                                                                   |
| 土砂流送と土砂供給が平衡状態にあるとしうる河道区間が見いだせない場合 |
|                                                                      |
| > a)で述べた要件を満たす河道区間が見いだせない場合には、a)に示した   |
| 助走区間に換えて仮想の河道区間を用いて供給土砂を与える。仮想の河道区 |
| 間は、縦断勾配一定で、縦断方向に一様な河道形状と河床材料粒径を初期に |
| 持ち、それら諸元を与えるべき供給土砂に相当する流砂を生み出すように設 |
| 定するのを標準とする。具体的には、仮想の河道区間の河道形状等の諸元を |
| 、例えば計算対象領域の上流端境界周辺における諸元等を参考として仮設定 |
| し、その河道に対して以下に示すいずれか適切な方法で供給土砂を求めて、 |
| 計算対象領域における既往の河床変動の再現計算を行い、所定の再現性が得 |
| られるように各諸元の修正を必要回数繰り返すことで諸元を決定する（本章 |
| > [5.2](http://www.yahoo.co.jp) 解析の検証と較正 を参照のこと）。    |
| >                                                                    |
| > ・仮想的助走区間を用いる与え方                                     |
| >                                                                    |
| > 計算対象領域の上流端に仮想の河道区間を接続し、これ                 |
| を仮想的助走区間として新たに計算対象領域に加えて、a)と同様の方法で仮 |
| 想的助走区間の上流端で動的平衡条件を満足するように供給土砂を与える。 |
| >                                                                    |
| > ・仮想の河道区間を流砂量計算のみを行う"樋"と見立てた与え方         |
| >                                                                    |
| > 仮想の河道区間での計算を計算対象領域の河床変動計算本体と切り       |
| 離し、河道形状等の諸元を時間的に不変として等流計算に基づく流砂量計算 |
| のみを行い、その結果を計算対象領域の上流端から供給土砂として与える。 |
| >                                                                    |
| > 以上に説明し                                                       |
| た供給土砂の設定の下で実施した河床変動計算結果の整理にあたっては、仮 |
| 想的助走区間の下流端における流送土砂量、また"樋"と見立てて算定した供 |
| 給土砂量（いずれも必要な場合には粒径階毎の量）を併せて整理しておく。 |
| >                                                                    |
| > な                                                                 |
| お、上記の修正を繰り返しても、所定の再現性が得られない場合には、本章 |
| > [5.2](http://www.yahoo.co.jp) 解析の検証と較正                     |
| > の「目的としたレベルまで                                           |
| 再現性が向上しない場合」に関する記載により、計算結果の整理等を行う。 |
|                                                                      |
| c.  土砂供給状況の変化を反映させた供給条件設定を行う場合             |
|                                                                      |
| > 一定規模以上の流域地被状態                                         |
| の変化あるいは斜面崩壊、ダム建設、ダムからの排砂などがあると、流量と |
| 供給土砂量との関係に有意な変化が生じうる。このような土砂供給状況の変 |
| 化を反映させた解析を行う際には、取り上げる変化要因に応じて適切な供給 |
| 土砂を設定するこのための標準的な方法として、a)またはb)によって設定し |
| た供給土砂を比較の基準として、対象とする変化要因に応じて、それを適切 |
| に増減させるというものがある。具体的には、b)に記載した「仮想の河道区 |
| 間を流砂量計算のみを行う"樋"と見立てた与え方」を採用し、変化要因作用 |
| 後については、この"樋"の河道形状等の諸元を適宜調整することで、当該要 |
| 因に見合う流量と供給土砂量との関係等を設定するという方法を適用する。 |
|                                                                      |
| d.  土砂流送と土砂供給がマクロに                                     |
| は平衡状態と見なせる河道区間が存在することを前提にする必要がない場合 |
|                                                                      |
| > 短区間に生じている局所洗掘や河口砂州フラ                           |
| ッシュなど、ある特定地点とその周辺における土砂流送量の不均衡を主因と |
| した一出水程度の短期的な河床の変化を対象とする場合がこれに該当する。 |
| >                                                                    |
| > この場合、a）、b)に示したように助走区間や仮想的助走区間等を設け    |
| る必要はなく、上流端の位置設定による供給土砂量の差違が特定地点には及 |
| ばないように、上流端を特定地点から十分に離れた位置に設置し、a)と同様 |
| に上流端において動的平衡条件を満足するように供給土砂を与えればよい。 |
|                                                                      |
| ２）種別【MSL】                                                      |
|                                                                      |
| 混合型の送流砂・浮遊砂については、上記 １）種別【UM】の設定          |
| と同一の方法により供給土砂を設定するのを標準とする。                 |
|                                                                      |
| 供給土砂に通過                                                       |
| 型の浮遊砂（ウォッシュロードもこれに含まれる）を含む場合には、その供 |
| 給については流量と供給土砂量との関係として設定するのを標準とする。一 |
| 定規模以上の流域地被状態の変化あるいは斜面崩壊、ダム建設、ダムからの |
| 排砂などによる供給量の変化を見込んだ供給土砂量の設定も、同様に行う。 |
|                                                                      |
| 通過型の浮遊砂は、計算対象領域の上                                   |
| 流端付近の河床材料から流砂量式などにより水理的に算定・設定する方法で |
| は十分な精度が得られないことに留意し、供給土砂量がマクロに適切に表さ |
| れるように、流量と供給土砂量との関係を設定するなどの手法を重視する。 |
+----------------------------------------------------------------------+

＜推　奨＞

  -------------------------------------------------------------------------------------------------------------------------
  種別【MSL】の供給土砂量は、第4章 [6節](http://www.yahoo.co.jp/)の流送土砂量観測の結果に基づいて設定することが望ましい。
  -------------------------------------------------------------------------------------------------------------------------

＜例　示＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------
  洪水流による侵食によって高水敷や河岸等が土砂の供給源となる場合には、その侵食特性を適切に反映した流砂量式を用いるなど、土砂供給量の条件設定に組み込むことができる。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------

1.  []{#_Toc382986890 .anchor}河道外搬出・搬入の設定

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------
  河道外搬出・搬入の設定として、搬出・搬入する土砂の量と粒径、実施範囲、実施時期について時系列で設定することを標準とする。
  --------------------------------------------------------------------------------------------------------------------------

1.  []{#_Toc298428041 .anchor}河床高・河床材料の初期条件の設定

＜標　準＞

+----------------------------------------------------------------------+
| 河床高の初期条件の設定として、レベル\[1DB\                           |
| ]では平均河床高の河道縦断方向分布、\[2DB\]では平面的な河床高分布を、 |
| 定期横断測量及び河道平面測量の成果を用いて設定することを標準とする。 |
|                                                                      |
| 河床材料の初期条件の設定として、河床材料調査の成果を用いて           |
| 河床の表層及びその下層の構成材料の粒度分布を与えることを標準とする。 |
|                                                                      |
| 表6-4-1に示した「河床初期条件」の種別、すなわち一様粒径【U】         |
| と混合粒径【M】ごとに記述した以下の事項を踏まえて、適切に設定する。  |
|                                                                      |
| 1.  種別【U】                                                        |
|                                                                      |
| 解析対象領域の全域及び深さ方向にわたって単一の粒径を与える。         |
|                                                                      |
| 10. 種別【M】                                                        |
|                                                                      |
| 粒度分布の河道                                                       |
| 縦断方向及び深さ方向の均一性に応じて、適切に設定するのを標準とする。 |
+----------------------------------------------------------------------+

＜推　奨＞

+----------------------------------------------------------------------+
| 種別【M】において、以下のように設定するのを推奨する。                |
|                                                                      |
| 1.  粒度分布が河道縦断方向に均一と見なせる場合                       |
|                                                                      |
| 第4章 河道特性調査                                                   |
| の[第2節](http://www.yahoo.co.j                                      |
| p)に示した「河床材料の見方」に基づいて設定した一連区間の代表的な粒度 |
| 分布を解析対象領域の全域及び深さ方向にわたって与えることが望ましい。 |
|                                                                      |
| 54. 粒度分布が河道縦断方向又は深さ方向に不均一である場合             |
|                                                                      |
| その状況に応じて以下のとおり設定することを推奨する。                 |
|                                                                      |
| 表層河床材料が分級して                                               |
| おり河道縦断方向に粒度分布が不均一であり、１）の与え方では必ずしもよ |
| い解析結果をもたらさない場合には、河道縦断方向に異なる粒度分布を与え |
| ることが望ましい。この場合、河床の表層と下層は同一の粒度分布とする。 |
|                                                                      |
| 河床低下を伴う河床表層の粗粒化（アーマリ                             |
| ング）等のため、河床表層とその下層の粒度分布が著しく異なる場合には、 |
| 設定においては交換層とその下層に異なる粒度分布を与えるのが望ましい。 |
+----------------------------------------------------------------------+

1.  []{#_Toc298428042 .anchor}解析の実施と検証・調整

    1.  []{#_Toc382986893 .anchor}解析の実施

＜標　準＞

+----------------------------------------------------------------------+
| 流れ、流砂、河床状況の計算は、時間項                                 |
| について逐次数値積分することによって行い、解を得ることを標準とする。 |
|                                                                      |
| その際、流                                                           |
| れに対して河床の時間的変化は一般に遅いため、流れを解く際には各時間ス |
| テップ内での河床の時間的変化は無視する「準定常」の条件で計算を行う。 |
+----------------------------------------------------------------------+

2.  []{#_Toc382986894 .anchor}解析の検証・調整

＜考え方＞

+----------------------------------------------------------------------+
| 検証は、種々の設定を経て構築した解析法が目的とした技術               |
| 的判断や予測を行えるレベルに達しているか見極めることを目的として、解 |
| 析結果と調査データとの比較を行って再現性について評価するものである。 |
|                                                                      |
| 調整は、再現性の改善を目的として、種々の設定項目の                   |
| 変更に対する解析結果の変化幅と利用できるデータや関連技術情報とを比較 |
| して、データによる裏付けと技術的合理性を兼ね備えて再現性を向上しうる |
| 設定項目を見極めて、各設定項目について総合的に調整を行うものである。 |
|                                                                      |
| 解析結果と                                                           |
| 調査データとの比較として、対象河道区間においてある期間に生じた河床高 |
| ・河床材料粒径の変化の再現計算を行い、その期間末及び期間内に取得され |
| た調査データ（主に第4章河道特性調査の[第3節](http://www.yahoo.co.jp) |
| 各時点の河道状況                                                     |
| に記載した調査データ）との比較を行                                   |
| う。一般的に調査データは「一つ又は複数の出水を受けた後のある一時点の |
| 河床状況」をとらえたものである。したがって、この比較では、ある出水を |
| 受けた「結果」である河床状況の再現性評価を行うにとどまり、出水中の河 |
| 床状況の「変化過程」を経時的に追って再現性の評価を行うものではない。 |
|                                                                      |
| こうした特徴から、「出水によって一方向的に変化が進行                 |
| し、出水後にも変化が残るパターン」（[第4章](http://www.yahoo.co.jp)  |
| 河道特性調査の図 4-4-1 に示したパターン                              |
| a)、b)、c)）の検証としては有効である。                               |
|                                                                      |
| それに対して「出水中にのみ変化が                                     |
| 現れ、出水後には元に戻るパターン」（[第4章](http://www.yahoo.co.jp)  |
| 河道特性調査の図 4-4-1 に示したパターン                              |
| d））の検証と                                                        |
| しては不足があり、出水中の変化過程を捉える特定目的調査が重要となる。 |
|                                                                      |
| 実際の検証では上記パターンを完全                                     |
| に区別できないので、たとえば平均河床高の長期的な縦断分布変化の場合で |
| は河床上昇・低下が経年的に持続して生じた区間を、また一出水程度の短期 |
| 的な変化の場合では出水前後で大きな変化を示している箇所を「出水によっ |
| て一方向的に変化が進行し出水後にも変化が残るパターン」となった区間・ |
| 箇所と見なし、他の区間・箇所より重点を置いて解析結果との比較を行う。 |
|                                                                      |
| また、再現性の評価                                                   |
| のためには、上記の比較から極力多くの情報を引き出すことが重要である。 |
|                                                                      |
| たとえば、できるだけ長期にわたる再現計算を行                         |
| って調査データと比較する時点を極力多くする、痕跡水位を検証対象に加え |
| る、複数地点における水位時系列データを用いた総合的把握を行う（第2章  |
| 水文・水理観測 の[第7節](http://www.yahoo.co.jp)                     |
| 河川の流れの総合的把握）ことが望ましい。                             |
|                                                                      |
| 更に必要に応じて本節の[5.3](http://www.yahoo.                        |
| co.jp)に述べるように解析と並行して調査を実施することも効果的である。 |
|                                                                      |
| 調整は、粗度係数の設定、交換層厚の設定（[3.4](http://www.yah         |
| oo.co.jp)）、各種流砂量式の設定([3.5](http://www.yahoo.co.jp)、[3.6] |
| (http://www.yahoo.co.jp)、[3.7](http://www.yahoo.co.jp))、及び初期条 |
| 件・境界条件等の設定([第4節](http://www.yahoo.co.jp))が対象となる。  |
|                                                                      |
| 流砂式の補正（パラメータの補正等）も必要に応じて調整に含めてよい。   |
|                                                                      |
| これら項目に対                                                       |
| して、冒頭に示した基本的考え方に基づいて適切に調整を行うこととする。 |
|                                                                      |
| なお、各種設定を繰り返                                               |
| し調整してもなお、目的としたレベルまで再現性が向上しない場合がある。 |
|                                                                      |
| その場合には、改めて実事                                             |
| 象との類似点と相違点の抽出・整理を行い、その結果に基づいて技術的判断 |
| や予測においてどこまでの情報が使えるか、具体の目的・要件と照らし合わ |
| せて個別事例ごとに判断していくスタンスに切り替えることが重要である。 |
|                                                                      |
| その上でなお、レベルの不足を補う必要があ                             |
| る場合には、適宜追加調査を行い、再現性を向上させることが重要である。 |
+----------------------------------------------------------------------+

3.  []{#_Toc382986895
    .anchor}解析と調査を並行して実施する場合の検証・調整

＜考え方＞

+----------------------------------------------------------------------+
| 解析と調査を並行して実施                                             |
| する場合の一般的な手順は以下のとおりである。なお、この場合の調査は、 |
| 調査と検証・調整を有機的に連携させた特定目的の調査と位置付けられる。 |
|                                                                      |
| 1)  解析法を用いて計算結果を相対的に                                 |
| 大きく変える設定項目等を見いだすことを目的とした感度分析を実施する。 |
|                                                                      |
| 2)  その解析結果を参                                                 |
| 考にして観測の項目、実施地点と必要な精度等を設定して調査を実施する。 |
|                                                                      |
| 3)  この調査結果を用いて                                             |
| 再度解析を行い、求められるレベルの再現性を得るべく検証と調整を行う。 |
|                                                                      |
| 必要に応じて上記１）～３）を繰り返す。                               |
|                                                                      |
| 調査としては、[第4章](http://www.yahoo.co.jp) 河道特性調査           |
| [第3節](http://www.yahoo.co.jp) 各時点の河道状況                     |
| に述べる河道地形測量などの共通基盤的な調査をベースとしつつ、第2章    |
| 水文・水理観測 [第7節](http://www.yahoo.co.jp)                       |
| 河川の流れの総合的把握 の水位同時多点観測や第4章 河道特性調査        |
| の[第6節](http://www.yahoo.co.jp) 土砂流送特性                       |
| の流送土砂量調査など、出水中の「変化過程                             |
| 」を逐次追うことのできる観測を組み合わせて実施するのが効果的である。 |
|                                                                      |
| こうした観測を再                                                     |
| 現性の改善に的確につなげるためには、解析による予測を行い、検証すべき |
| 事項とその実施に必要なデータの精度を明確にしておくことが重要である。 |
+----------------------------------------------------------------------+

**調査編**

9.  **氾濫解析**

**目　次**

[第1節 総説 1](#_Toc86945671)

[第2節 氾濫域調査 1](#_Toc103778855)

[第3節 外水氾濫解析 3](#_Toc86945673)

> [3．1 総説 3](#_Toc103778857)
>
> [3．2 外水氾濫解析モデルの選定 3](#_Toc86945675)
>
> [3．3 外水氾濫の計算条件の設定 5](#_Toc86945676)

[第4節 内水氾濫解析 10](#_Toc103778860)

> [4．1 総説 10](#_Toc103778861)
>
> [4．2 内水氾濫解析モデルの選定 11](#_Toc103778862)
>
> [4．3 内水氾濫の計算条件の設定 11](#_Toc103778863)

[第5節 氾濫解析結果の活用 12](#_Toc103778864)

> [5．1 総説 12](#_Toc103778865)
>
> [5．2 洪水浸水想定区域図 12](#_Toc103778866)
>
> [5．3 リアルタイム氾濫シミュレーション 13](#_Toc103778867)
>
> [5．4 内水処理計画の策定 14](#_Toc103778868)

令和４年６月　版

適用上の位置付け

　河川砂防技術基準調査編は、基準の適用上の位置付けを明確にするために、下表に示すように適用上の位置付けを分類している。

+--------+------------------+------------------+------------------+
| 分　類 | 適用上の位置付け | 末尾の字句例     |                  |
+--------+------------------+------------------+------------------+
| 考え方 | 技術資料         | ●目              | 「･･･ある。      |
|        |                  | 的や概念、考え方 | 」「･･･いる。」  |
|        |                  | を記述した事項。 |                  |
|        |                  |                  | 「･･･なる。      |
|        |                  |                  | 」「･･･れる。」  |
+--------+------------------+------------------+------------------+
| 必　須 | 技術基準         | ●法令による規定  | 「･･･なければ    |
|        |                  | や技術的観点から | ならない。」「･  |
|        |                  | 実施すべきである | ･･ものとする。」 |
|        |                  | ことが明確であり |                  |
|        |                  | 遵守すべき事項。 |                  |
+--------+------------------+------------------+------------------+
| 標　準 | 技術基準         | ●特              | 「･･･            |
|        |                  | 段の事情がない限 | を標準とする。」 |
|        |                  | り記述に従い実施 |                  |
|        |                  | すべきだが、状況 | 「･･･            |
|        |                  | や条件によって一 | を基本とする。」 |
|        |                  | 律に適用すること |                  |
|        |                  | はできない事項。 | 「･･･による。」  |
+--------+------------------+------------------+------------------+
| 推　奨 | 技術資料         | ●状況や条件      | 「               |
|        |                  | によって実施する | ･･･望ましい。」  |
|        |                  | ことが良い事項。 |                  |
|        |                  |                  | 「               |
|        |                  |                  | ･･･推奨する。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･務める。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･必要に応    |
|        |                  |                  | じて･･･する。」  |
+--------+------------------+------------------+------------------+
| 例　示 | 技術資料         | ●適用条件や実施  | 「               |
|        |                  | 効果について確定 | ･･･などの手法（  |
|        |                  | している段階では | 事例）がある。」 |
|        |                  | ないが、状況や条 |                  |
|        |                  | 件によっては導入 | 「･･･など        |
|        |                  | することが可能な | の場合がある。」 |
|        |                  | 新技術等の例示。 |                  |
|        |                  |                  | 「･･･など        |
|        |                  | ●状              | が考えられる。」 |
|        |                  | 況や条件によって |                  |
|        |                  | 限定的に実施でき | 「               |
|        |                  | る技術等の例示。 | ･･･の場合には･･･ |
|        |                  |                  | ことができる。」 |
|        |                  | ●具体的          |                  |
|        |                  | に例示することに | 「               |
|        |                  | より、技術的な理 | ･･･例示する。」  |
|        |                  | 解を助ける事項。 |                  |
|        |                  |                  | 「例えば･･･。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･事例もある  |
|        |                  |                  | 。･･･もよい。」  |
+--------+------------------+------------------+------------------+

  関連通知等       関連する通知やそれを理解する上で参考となる資料
  ---------------- ------------------------------------------------------
  参考となる資料   例示等に示した手法・内容を理解する上で参考となる資料

9.  氾濫解析

    1.  []{#_Toc86945671 .anchor}総説

＜考え方＞

+----------------------------------------------------------------------+
| 本章では、氾濫解析に必要な技術的事項を定める。                       |
|                                                                      |
| 氾濫解析は、河川からの氾濫水や降                                     |
| 雨・流出水等により生じる氾濫現象（氾濫範囲や浸水深・氾濫流速等）を再 |
| 現・予測することにより、被害の想定や水害対策、避難方法、盛土構造等流 |
| 域内地形の氾濫流制御効果等の検討に資することを目的とするものである。 |
|                                                                      |
| 従来より、氾濫現象は                                                 |
| 、堤防の決壊や越流により生じた河川氾濫水が地形等の影響を受けながら流 |
| 下・拡散する現象と、堤内地に集まった雨水や下水等が排水機能を上回り湛 |
| 水する現象に分類され、前者を「外水氾濫」、後者を「内水氾濫」とする。 |
|                                                                      |
| 氾濫解析は、河川か                                                   |
| らの氾濫水（外水）や降雨・流出水等（内水）により生じる氾濫範囲や浸水 |
| 深・氾濫流速等を再現・予測するものであり、以下の項目より構成される。 |
|                                                                      |
| １) 氾濫域調査                                                       |
|                                                                      |
| ２) 外水氾濫解析                                                     |
|                                                                      |
| ３) 内水氾濫解析                                                     |
+----------------------------------------------------------------------+

＜参考となる資料＞

「外水」、「内水」の定義は「河川用語集」，国土技術政策総合研究所の下記のサイト・資料が参考となる。

URL:https://www.nilim.go.jp/lab/rcg/newhp/yougo/index.html

＜標　準＞

+----------------------------------------------------------------------+
| 氾濫解析に当たって                                                   |
| は、氾濫現象の特徴や検討目的に適した解析モデルの選定及び計算条件の設 |
| 定を行うとともに、解析モデルの検定や設定した計算条件による再現性に関 |
| する検証を行い、精度を確認した上で、解析を実施することを標準とする。 |
|                                                                      |
| 解析モデルの検定としては、理論解との比較や水収支の確認等から、ま     |
| た、再現性に関しては既往の研究や過去の浸水実績との比較から検証する。 |
+----------------------------------------------------------------------+

＜推　奨＞

+----------------------------------------------------------------------+
| 実際の浸水現象において                                               |
| は、外水氾濫と内水氾濫、降雨流出、下水道排水等の現象が複合しているの |
| が一般的である。このため、氾濫解析においては、解析対象とする実現象の |
| 本質的特徴を捉えるという方向で解析モデル（要素モデル）を組み合わせる |
| ことにより、実務上可能な限り実現象に忠実な解析を行うことを推奨する。 |
|                                                                      |
| 氾濫を含め降雨流出、河川内洪水流、下水道管路内の水理現象             |
| 等は、近年要素モデルとして開発が進むとともに、オブジェクト指向のプロ |
| グラム言語やそれらを利用したプラットフォームの普及により、これら要素 |
| モデルを組み合わせた統合化モデルの構築が比較的容易になってきている。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

たとえば、CommonMPは、国土技術政策総合研究所の下記のサイト・資料が参考となる。

1.  URL:https://www.nilim.go.jp/lab/feg/cmp/index.html

    1.  []{#_Toc103778855 .anchor}氾濫域調査

＜考え方＞

  ----------------------------------------------------------------------------------------------------------------
  氾濫域調査は、氾濫解析モデルの選定、計算条件の設定、再現性の検証等に必要なデータの収集を目的としたものである。
  ----------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 氾濫域調査では、河川における洪水の水理解析に用いる資料（水           |
| 文資料を含む）のほか、主に地盤高（線的地形、構造物）、土地利用、下水 |
| 道・排水路、地下空間・流域貯留施設、浸水実績等について、検討目的に応 |
| じて調査項目、調査範囲、調査方法を適切に設定するとともに、必要に応じ |
| て施設管理者の協力を得ることにより効率的に実施することを標準とする。 |
|                                                                      |
| なお、河川における洪水の水理解析に用いる資料は、第3章 水文解析 第2節 |
| 流出解析 及び第5章 河川における洪水流の水理解析 に従うものとする。   |
+----------------------------------------------------------------------+

＜参考となる資料＞

氾濫域調査は、踏まえるべき観点等について下記の資料が参考となる。

1.  土木学会水理委員会：水理公式集［2018年版］，pp240-250,
    丸善出版、2019.土木学会水理委員会.

洪水の水理解析は、下記の資料が参考となる。

215. (財)国土技術研究センター：河道計画検討の手引き，山海堂，2002.

＜推　奨＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  氾濫解析の精度向上を図るためには、氾濫域や浸水深・流速の時間変化についても再現性を検証できることが望ましい。このため、浸水深計の設置による浸水深の時間変化の計測、画像解析による流速の計測、衛星データ等を利用した氾濫域の時間変化の把握等、検証データの収集についても検討することを推奨する。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜例　示＞

+----------------------------------------------------------------------+
| 主な調査項目について、調査方法を以下に例示する。                     |
|                                                                      |
| １）地盤高                                                           |
|                                                                      |
| 地盤高データは氾濫水の挙動を的確                                     |
| に予測・再現できるよう、想定される氾濫域全体を包含する範囲においてデ |
| ータを読み取る。地盤高は、基盤地図情報数値標高モデル（DEM5A等）、都  |
| 市計画図、国土基本図や活用できる場合はLP（航空レーザ測量）データを利 |
| 用して、計算格子点の地盤高として設定する。また、道路や鉄道、二線堤等 |
| 連続した盛土地形や、これらに設けられたボックスカルバートやアンダーパ |
| ス等通路も氾濫水の挙動に大きく影響するため、連続盛土地形の線形や地盤 |
| 高さ、ボックスカルバート等の位置、諸元（幅、高さ）について把握する。 |
|                                                                      |
| ２）土地利用                                                         |
|                                                                      |
| 土地利用データは、氾濫解析における                                   |
| 底面粗度や氾濫水の透過率等を設定する上で必要なデータであり、数値地図 |
| 2500（空間データ基盤）等信頼性の高い資料を活用する。また、近年の土地 |
| 利用に関する資料が得られない場合は空中写真や現地調査により把握する。 |
|                                                                      |
| ３）下水道・排水路                                                   |
|                                                                      |
| 下水道・排水路は、氾濫水や内水を排除するも                           |
| のであり、特に内水氾濫においては、これらが氾濫現象に大きく影響する。 |
| 下水道・排水路の施設特性や排水能力を把握するためには、マンホールの位 |
| 置・諸元、管路や側溝等の諸元・敷設位置、排水ポンプの諸元・操作規則・ |
| 排水先河川等の諸元等について調査し、排水系統として総合的に把握する。 |
|                                                                      |
| ４）地下空間・流域貯留施設                                           |
|                                                                      |
| 氾濫区域内に地下空間や流域貯留施設等が                               |
| あり、これら施設への流出入を考慮する場合は、氾濫区域内に存在する地下 |
| 空間等の規模、出入口等氾濫水の流出入位置や流出入口の諸元を把握する。 |
|                                                                      |
| ５）浸水実績                                                         |
|                                                                      |
| 浸水実績の調査では、痕跡調査や聞き取り調査から過去に生じた           |
| 氾濫の範囲や浸水深等の把握を行う。なお、調査結果は、当該浸水を再現す |
| るための発生時の地形、降雨、河川水位等のデータを併せて整理しておく。 |
|                                                                      |
| ６）河川における洪水の水理解析に用いる資料                           |
|                                                                      |
| 河川における洪水の水理解析に用いる資料は、「第5章                    |
| 河川における洪水流の水理解析」に従うものとするが、中                 |
| 小河川については、河道縦横断測量データを取得していない場合があること |
| から、その場合には、航空レーザ測量データを収集して河道断面データを作 |
| 成する。なお、通常時の水深が比較的大きい河川において、水面下の計測デ |
| ータが無いものを使用すると、河道断面積が著しく過小評価になるおそれが |
| あることから、その場合には、グリーン・レーザー測量等により補正する。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

1.  国土交通省国土地理院：数値地図2500（空間データ基盤）.

```{=html}
<!-- -->
```
216. (財)日本建設情報総合センター：100ｍ四方メッシュ延床面積データ.

217. 国土交通省国土地理院：基盤地図情報数値標高モデル．

     1.  []{#_Toc86945673 .anchor}外水氾濫解析

         1.  []{#_Toc103778857 .anchor}総説

＜考え方＞

+----------------------------------------------------------------------+
| 外水氾濫は、堤防の決壊や越流等により生じた氾濫水が地形等             |
| の影響を受けながら流下する現象であり、氾濫水の運動方程式を解くことが |
| 氾濫解析の主要な課題となる。このため、解析に当たっては、解析目的や対 |
| 象とする氾濫現象の特徴を踏まえて基礎方程式、離散化手法を選定するとと |
| もに、氾濫域特性に応じた計算条件を設定することが重要である。また、氾 |
| 濫解析においては、河道内の流況計算と氾濫解析を並行して行うことにより |
| 、河道と堤内地において氾濫流量をやり取りし、互いに整合性を確保する。 |
|                                                                      |
| 計算の精度は                                                         |
| 空間メッシュのサイズの細かさや計算時間間隔に依存するが、これらは計算 |
| 時間とトレードオフの関係になるため、解析目的に必要な精度や利用できる |
| 計算機の能力等を踏まえた上で適切な組合せを設定することが重要である。 |
+----------------------------------------------------------------------+

2.  []{#_Toc86945675 .anchor}外水氾濫解析モデルの選定

＜標　準＞

+----------------------------------------------------------------------+
| 外水氾濫解析モデルの選定においては、以下を標準とする。               |
|                                                                      |
| １）基礎方程式                                                       |
|                                                                      |
| 外水氾濫は基本的に運動量を有す                                       |
| る氾濫水が二次元的に流下・拡散していく現象であり、また浸水深とともに |
| 流速ベクトルも重要な情報となるため、基礎方程式には移流項を含む２次元 |
| 不定流方程式(7-3-1)を用いることを標準とする。この方程式は、浅海域に  |
| おける高潮や津波の解析と同じ基礎方程式であり、海面のせん断力や海底地 |
| 形変化を設定することにより、高潮や津波の解析に使用することができる。 |
|                                                                      |
| ただし、谷底平野における河川氾濫による一次元性の強い氾濫             |
| の場合に一次元方程式を用いること、氾濫形態が窪地への貯留等で流速が問 |
| 題にならない場合に移流項を含まない線形方程式を用いること、河川水位が |
| 堤防天端を越え河川水位と堤内地の水位が同程度となって相互に干渉しなが |
| ら流下する氾濫形態の場合には、河道と堤内地を一体で解析する手法を採用 |
| すること等、氾濫の形態に応じて他の基礎方程式を用いることを妨げない。 |
|                                                                      |
| > (7-3-1)                                                            |
|                                                                      |
| Q~x~，Q~y~：x方向及びy方向の単位幅流量、h：浸水深                    |
| 、z：地盤高、n~x~，n~y~：x方向及びy方向の底面粗度、q~in~：降雨、マン |
| ホールからの逆流等、q~out~：下水道・排水路への排水等、g：重力加速度  |
|                                                                      |
| ２）離散化手法                                                       |
|                                                                      |
| 差分法、有限体積法、有限要素法等を使用することを標準とする。特に複雑 |
| な地形や家屋・構造物の配置等を反映する必要がある場合には、非構造格子 |
| による離散化手法（有限体積法、有限要素法等）を使用するか、地形等に応 |
| じて十分小さく設定した空間メッシュにより差分法を使用することとする。 |
+----------------------------------------------------------------------+

＜推　奨＞

+----------------------------------------------------------------------+
| I.                                                                   |
| 河川水位が堤防天端を越え河川水                                       |
| 位と堤内地の水位が同程度となって相互に干渉しながら流下する氾濫形態の |
| 場合には、河道と堤内地を一体で解析する手法を採用することが望ましい。 |
|                                                                      |
| II.谷底平野における一次元性の強い流下型氾濫の形態を呈する中          |
| 小河川については、一次元不等流計算による手法を採用することができる。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

氾濫解析モデルは、下記資料が参考となる。

1.  土木学会水理委員会：水理公式集［2018年版］，pp.237-250，丸善出版，2019.

堤防の決壊や越流等により生じた氾濫水が水位差をもって拡散氾濫する場合の氾濫解析モデルについては、下記資料が参考となる。

12. 洪水浸水想定区域図作成マニュアル（第4版），2015（2017.10月部分改定）．国土交通省　水管理・国土保全局　河川環境課水防企画室　国土技術政策総合研究所　河川研究部　水害研究室.

    （最新版）洪水浸水想定区域図作成マニュアル（第4版），2017.国土交通省水管理・国土保全局河川環境課水防企画室　国土技術政策総合研究所河川研究部水害研究室.

河川水位が堤防天端を越え河川水位と堤内地の水位が同程度となって相互に干渉しながら流下する氾濫形態の場合の氾濫解析モデルについては、下記資料が参考となる。

218. 田端 幸輔,後藤 岳久,竹村 吉晴,酒匂 一樹,福岡 捷二：
     令和2年7月球磨川豪雨における洪水流と氾濫流の一体解析による人吉市街地と狭隘区間の集落の被害分析,
     河川技術論文集,第27巻,2021年6月.

離散化手法は、下記資料が参考となる。

219. 小林敏夫 編：数値流体力学ハンドブック，丸善出版，2003.

谷底平野における一次元性の強い流下型氾濫の形態を呈する中小河川の氾濫解析モデルについては、下記資料が参考となる。

220. 小規模河川の氾濫推定図作成の手引き、2020.国土交通省水管理・国土保全局河川環境課水防企画室国土技術政策総合研究所河川研究部水害研究室.

     （最新版）小規模河川の氾濫推定図作成の手引き、2023.国土交通省水管理・国土保全局河川環境課水防企画室　国土技術政策総合研究所河川研究部水害研究室.

     1.  []{#_Toc86945676 .anchor}外水氾濫の計算条件の設定

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------
  計算条件の設定においては、検討目的や対象とする氾濫現象の特徴に応じてモデル定数や流入条件等を設定することを標準とする。
  ------------------------------------------------------------------------------------------------------------------------

＜例　示＞

+----------------------------------------------------------------------+
| 計算条件の設定方法を以下に例示する。                                 |
|                                                                      |
| I．堤防の決壊や越流等に                                              |
| より生じた氾濫水が水位差をもって拡散氾濫する場合の氾濫解析の計算条件 |
|                                                                      |
| １）流入条件                                                         |
|                                                                      |
| 流入条件は、越流・堤防決壊による流入地点                             |
| 、流入幅を設定するとともに、河川流況条件から流入流量や流向を設定する |
| 。河川流況は、河道と氾濫域との流量のやり取りを考慮した一次元不定流解 |
| 析もしくは準二次元不定流解析により行う方法や、二次元不定流解析等によ |
| る氾濫域との一体的解析による手法がある。前者の場合は下記等によりa)～ |
| d)を設定し、後者の場合は、d)流量ベクトルは一連の解析の過程で求められ |
| るが、それ以外の条件は下記等に従い、適切に設定することができる。河川 |
| 流況の具体的計算方法は[[第5章]{.underline}](http://www.yahoo.co.jp)  |
| 河川における洪水流の水理解析 を参照されたい。                        |
|                                                                      |
| > a)　越流・決壊地点                                                 |
| >                                                                    |
| > 決壊箇所は、発生可                                                 |
| 能性が高い箇所、危機管理上重要な箇所等検討目的に応じて設定する。なお |
| 、発生可能性の高い地点の設定においては、決壊実績から設定するほか、重 |
| 要水防箇所のうち危険性が高い箇所、地形特性等から見て越流・決壊の危険 |
| 性が高い箇所（流下能力が低い、旧川締切り箇所、落堀、旧扇状地面と現扇 |
| 状地面が交差する箇所など）を設定する。また、越流地点は検討対象の洪水 |
| 位と堤防高を比較し、水位が堤防高を越える箇所及び越流範囲を特定する。 |
| >                                                                    |
| > b)　決壊幅・越流幅                                                 |
| >                                                                    |
| > 決壊幅は過去の                                                     |
| 実績等から設定するが、実績等がない場合は式(7-3-2)の方法で設定するこ  |
| とができる。また、越流幅は、河川水位と堤防天端高の関係から設定する。 |
|                                                                      |
| ＜合流点の場合＞ B~b~＝2.0（log~10~B）^3.8^＋77                      |
|                                                                      |
| ＜合流点以外の場合＞ B~b~＝1.6（log~10~B）^3.8^＋62 (7-3-2)          |
|                                                                      |
| > ここで，B~b~：最終決壊幅(ｍ)，B：川幅(ｍ)である。                  |
| >                                                                    |
| > 決壊幅の時間的変化についても実績等を参考として設定することを基本と |
| するが、データがない場合は、以下の式(7-3-3)を使用することができる。  |
| >                                                                    |
| > T＝0 B~b~'＝0.5B~b\                                                |
| > ~0＜t≦60分 B~b~'＝0.5（1＋t／60）B~b~ (7-3-3)\                     |
| > t＞60分 B~b~'＝B~b~                                                |
| >                                                                    |
| > ここで、t：決壊後の経過時間                                        |
| (分)、B~b~'：ある時刻tにおける決壊幅(m)、B~b~：最終決壊幅(m)である。 |
| >                                                                    |
| > c)　決壊部の敷高                                                   |
| >                                                                    |
| > 堤防決壊部の敷高は実績に従うことを基本とするが、実績値がな         |
| い場合はその地点の高水敷高若しくは背後地盤高の高い方の値とすることが |
| できる。また、決壊後瞬時にその敷高まで決壊するものとして設定できる。 |
| >                                                                    |
| > d)　流入地点の流量ベクトル                                         |
| >                                                                    |
| > 流入地点の                                                         |
| 流量ベクトルは、河道内洪水モデルと氾濫解析モデルを二次元不定流による |
| 一体的な解析の過程の中で求める方法のほか、河道内水位と堤内地の浸水位 |
| との関係から、本間公式（7-3-4）や河道の平均河床勾配（*Ｉ*）を考慮し  |
| た式(7-3-5)を用いて流入量（*Ｑ*）及び流向(θ)を設定することができる。 |
|                                                                      |
| 流入量(*Ｑ*)：越流堰における越流量*Ｑ~                               |
| 0~*は本間公式(7-3-4)により与えられるが、栗城等はさらに河床勾配がある |
| 場合の横越流量を本間公式を補正する形で与えている。この場合、式(7-3-  |
| 4)のh~1~，h~2~は盛土地盤高からの水位とし、h~1~の方が高いものとする。 |
|                                                                      |
| > (7-3-4)                                                            |
| >                                                                    |
| > h~1~ h~1~ h~2~                                                     |
|                                                                      |
| 完全越流　　　　　　　　　　　　潜り越流                             |
|                                                                      |
| > 図7-3-1　　越流と本公式の諸元の関係                                |
|                                                                      |
| 堤防決壊に伴う氾濫流量                                               |
|                                                                      |
| > (7-3-5)                                                            |
| >                                                                    |
| > 越流に伴う越流量 (7-3-6)                                           |
|                                                                      |
| また、横越流堰の越流量は、多くの研究者が実験と理                     |
| 論から越流量式を提案しており、たとえば、鬼束等(2007)は、堤防を考慮し |
| た台形断面水路での実験結果から以下の式を提案している。ここで、q：単  |
| 位幅越流量、C~M~：流量係数、h：堰上流河川水位、S：堰高、T：水面幅、  |
| L：堰長、m：側壁勾配、Fr~1~：上流側フルード数、g：重力加速度である。 |
|                                                                      |
| 流向(θ)：流向は、栗城等（1996），末次（1998）                        |
| が式(7-3-7),(7-3-8)のとおり河床勾配から設定する方法を提案している。  |
|                                                                      |
| > の場合\                                                            |
| > の場合 (7-3-7)                                                     |
|                                                                      |
| 越流に伴う越流量と流向　　　　　　　　　　　　                       |
|                                                                      |
| > の場合\                                                            |
| > の場合 (7-3-8)                                                     |
|                                                                      |
| ![](media/image264.emf){width="4.386805555555555in"                  |
| height="1.9902777777777778in"}                                       |
|                                                                      |
| 図7-3-2　　河床勾配と越流量、流向の関係                              |
|                                                                      |
| ２）粗度係数・透過係数                                               |
|                                                                      |
| 避難経路の氾濫状                                                     |
| 況のように、比較的狭い範囲の氾濫現象を詳細に解析する場合は、地表の性 |
| 状に応じて粗度係数を設定するとともに、家屋や構造物等については領域内 |
| の境界条件として扱う。一方、広域的な氾濫現象の把握においては、家屋占 |
| 有率を粗度に換算する、若しくは透過率で表現するなどのほか、計算格子内 |
| の異なる土地利用を合成粗度で代表させるなどの簡略化を行うことができる |
| 。家屋占有率の粗度換算及び合成粗度の考え方としては式(7-3-9)がある。  |
|                                                                      |
| な                                                                   |
| お、土地利用に応じた粗度係数は、モデルの特性を踏まえた上で設定する。 |
|                                                                      |
| > (7-3-9)                                                            |
|                                                                      |
| n~0~：合成粗度、A~1                                                  |
| ~,A~2~,A~3~,n~1~,n~2~,n~3~：メッシュ内の占有面積率とそのエリアの粗度 |
|                                                                      |
| n：建物占有率を考慮した合成粗度、θ：建物占有率（％）                 |
|                                                                      |
| ３）連続盛土地形条件                                                 |
|                                                                      |
| 道路や鉄道、二線堤等の連続的な盛土地形も氾濫水の挙動に               |
| 大きく影響するため、このような地形は境界条件として計算に反映する。当 |
| 該地点の水深が盛土地盤高を超えない範囲では不透過境界とし、超えた場合 |
| は式(7-3-4)に従い越流が生じるものとする。また、道路盛土等にボックス  |
| カルバート等通路が設けられている場合は、そこから氾濫水の流出が可能と |
| なるため、境界条件に反映する。ボックスカルバート等からの流出量の算定 |
| 方法は、式(7-3-10)を用いることができる。ここで，*Q*：流出量(m^3^/s)  |
| 、B：樋門・カルバートの幅（m）、H：樋門・カルバートの高さ(m)、h~1~： |
| 高いほうの水位（m）、h~2~：低い方の水位（m）、g：重力加速度である。  |
|                                                                      |
| > (7-3-10)                                                           |
|                                                                      |
| ![](media/image267.emf){width="2.4715277777777778in"                 |
| height="1.2361111111111112in"}                                       |
|                                                                      |
| > 図7-3-3　　樋門等における流出形態と諸元                            |
|                                                                      |
| ４）下水道・ポンプ                                                   |
|                                                                      |
| 比較的小規模な氾濫の場合や、ピーク流量後の氾濫域の縮小に関           |
| しては、下水道やそれに接続するポンプ施設が大きく影響する場合がある。 |
|                                                                      |
| 下水道管路のモデルは、汎用的なモデ                                   |
| ルも普及し、管路の大きさやネットワーク等の現地の条件を取り込み、氾濫 |
| 計算と接続することも可能であるが、下水道データの収集、モデルへの反映 |
| 、計算時間等に係るコストに対して、計算結果の精度が有意に向上するとは |
| 必ずしも言えないため、検討目的に応じて適宜簡略化（ランピング）する。 |
|                                                                      |
| また、排水ポンプは、排水先の河川水位等による排水能力の               |
| 変化、操作ルールにより排水規制を受ける場合があるほか、電気系統や操作 |
| 室の浸水、燃料切れ等による運転停止等も考えられるため、施設特性や操作 |
| 規則を把握した上で適宜現実的なシナリオを設定し、計算条件に反映する。 |
|                                                                      |
| ５）河川・排水路等                                                   |
|                                                                      |
| 計算対象                                                             |
| 領域内の主要な河川は、不定流計算モデル等により排水機能を明示的にモデ |
| ル化する一方、明示的なモデル化が困難な多数の小河川・排水路等の集水域 |
| について、堤内排水が正しく表現されないことにより、計算結果において、 |
| 実現象としてあり得ないような長期間の浸水が続く場合は、氾濫水が適宜主 |
| 要河川を通じて又は直接に海に排水されるよう仮想的な排水路を設定する。 |
|                                                                      |
| ６）地下空間・貯留施設                                               |
|                                                                      |
| 氾                                                                   |
| 濫区域内に貯留施設等が存在する場合は、流入敷高や貯留量等施設特性を把 |
| 握した上で、貯留効果を氾濫解析に反映する。同様に、地下空間への流入が |
| 生じる場合も、その流入規模によっては地表面の氾濫状況に大きく影響する |
| 可能性があるため、必要に応じて地下空間への流入等を計算に反映させる。 |
|                                                                      |
| ７）降雨分布                                                         |
|                                                                      |
| 外水氾濫解析においては、計算対象エリアの降雨量に比べて               |
| 氾濫流の規模が大きいため、計算対象エリアの降雨を無視する場合が多い。 |
|                                                                      |
| しかし、避難方法                                                     |
| の検討等においては、氾濫流が到達する以前の内水氾濫の状況や避難途中の |
| 降雨状況を把握し、避難経路の安全性等を評価することも重要であるため、 |
| 解析の目的に応じて計算対象エリアの降雨分布を考慮する必要がある。この |
| 場合レーダ雨量計のデータを、精度の確認や補正をした上で適宜活用する。 |
|                                                                      |
| ８）その他                                                           |
|                                                                      |
| I．氾濫現象においては、上記以外にも水防活                            |
| 動やポンプ車の稼働等様々な要因が影響するため、検討目的に応じて考慮す |
| べき要因を抽出し、それらに係るシナリオを作成した上で計算に反映する。 |
|                                                                      |
| II．河川水位が堤防天端を越え河川水位と堤内地の水位が同               |
| 程度となって相互に干渉しながら流下する氾濫形態の場合の氾濫解析の計算 |
| 条件については、例えば、田端ら（2021）を参考とすることが考えられる。 |
|                                                                      |
| I                                                                    |
| II．谷底平野における一次元性の強い流下型氾濫の形態を呈する中小河川の |
| 氾濫解析の計算条件については、既存の取得データ等に基づき設定する。な |
| お、河道の粗度係数に関するデータが存在しない場合には、一律0.033を採  |
| 用することが考えられる。また、連続盛土については、数値標高モデル（国 |
| 土地理院のDEM5A等）に基づき横断測線上の地表面の凹凸として考慮する。  |
+----------------------------------------------------------------------+

＜参考となる資料＞

氾濫解析の計算条件の設定については、下記資料が参考となる。

1.  土木学会水理委員会：水理公式集［2018年版］，pp.237-250，丸善，2019.

```{=html}
<!-- -->
```
221. 洪水浸水想定区域図作成マニュアル（第4版），2015（2017.10月部分改定）．国土交通省　水管理・国土保全局　河川環境課水防企画室　国土技術政策総合研究所　河川研究部　水害研究室.

     （最新版）洪水浸水想定区域図作成マニュアル（第4版），2017.国土交通省水管理・国土保全局河川環境課水防企画室　国土技術政策総合研究所河川研究部水害研究室.

222. 小規模河川の氾濫推定図作成の手引き、2020.国土交通省水管理・国土保全局河川環境課水防企画室国土技術政策総合研究所河川研究部水害研究室.

     （最新版）小規模河川の氾濫推定図作成の手引き、2023．国土交通省水管理・国土保全局河川環境課水防企画室　国土技術政策総合研究所河川研究部水害研究室.

二次元不定流計算等における流入条件の設定、合成粗度、線的盛土地形の計算条件設定方法については、下記資料が参考となる。

223. 栗城稔，末次忠司，海野仁，田中義人，小林裕明：氾濫シミュレーション・マニュアル(案)
     －シミュレーションの手引き及び新モデルの検証－，土木研究所資料，第3400号，1996.

越流・氾濫時の流量・流向の設定方法については、下記資料が参考となる。

224. 栗城稔，末次忠司，海野仁，田中義人，小林裕明：[氾濫シミュレーション・マニュアル(案)
     －シミュレーションの手引き及び新モデルの検証－](http://www.nilim.go.jp/lab/rcg/newhp/seika.files/doken/all.html)，土木研究所資料，第3400号，1996.

225. 栗城稔，末次忠司，小林裕明，田中義人：横越流特性を考慮した破堤氾濫流公式の検討，土木技術資料，38-11，pp.56-61，1996.

226. 末次忠司：氾濫原管理のための氾濫解析手法の精度向上と応用に関する研究，九州大学博士論文，p.54，1998．

227. 鬼束幸樹，秋山嘉一郎，井田千尋，保賀円：台形断面水路に設置された横越流堰の流量式および流量係数，応用力学論文集，Vol10，2007.

透過係数の設定方法については、下記資料が参考となる。

228. 榊山勉，阿部宣行，鹿島遼一：ポーラスモデルによる透過性構造物周辺の非線形波動解析，海岸工学論文集，第37巻，pp.554-558，1990.

下水道・ポンプの計算条件設定については、下記資料が参考となる。

229. (公財)日本下水道新技術機構：流出解析モデル利活用マニュアル（雨水対策における流出解析モデルの運用の手引き），2017.

230. 国土技術政策総合研究所水害研究室：NILIM2.0都市域氾濫解析モデルマニュアル，2012.

破堤氾濫流の横越流特性と破堤口拡大過程については、下記資料が参考となる。

231. 秋山壽一郎，重枝未玲，梅木雄大，伊藤雄亮：破堤氾濫流の横越流特性と河道・氾濫域包括解析の適用性の検討，水工学論文集，第54巻，pp.853-858，2010.

232. 辻本哲郎，北村忠紀，岸本雅彦：砂質堤防の破堤口拡大過程のシミュレーションと破堤水理，河川技術論文集，Vol.8，pp.31-36，2002.

河川水位が堤防天端を越え河川水位と堤内地の水位が同程度となって相互に干渉しながら流下する氾濫形態の場合の氾濫解析の計算条件の設定については、下記資料が参考となる。

233. 田端 幸輔,後藤 岳久,竹村 吉晴,酒匂 一樹,福岡 捷二：
     令和2年7月球磨川豪雨における洪水流と氾濫流の一体解析による人吉市街地と狭隘区間の集落の被害分析,
     河川技術論文集,第27巻,2021年6月

     1.  []{#_Toc103778860 .anchor}内水氾濫解析

         1.  []{#_Toc103778861 .anchor}総説

＜考え方＞

+----------------------------------------------------------------------+
| 内水                                                                 |
| 氾濫は、降雨や降雨流出による流入量が排水量を上回るために生じる比較的 |
| 静的な氾濫現象であり、流入量、排水量の設定が主要な課題となる。このた |
| め、流出解析モデル、下水道モデル、河川内洪水モデル等を組み合わせるこ |
| とにより、氾濫と併せて一連の現象を解析の対象とするのが一般的である。 |
|                                                                      |
| なお、内水氾濫は、①内水の排水                                        |
| 元河川（以下、「内水河川」という。）と比べて排水先河川（以下、「外水 |
| 河川」という。）の水位が高いために生じる排水不良が原因となる場合と、 |
| ②豪雨によりもたらされた降雨や流出量が下水道施設等による排水機能等を  |
| 大きく上回ることが原因となる場合とがあり、主に前者①が河川事業の対象  |
| とされてきた。しかし、これらは流入量、流出量の設定方法が異なるものの |
| 、現象のメカニズムとしては同様であるため、以下では一体的に記述する。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

内水現象の一般的解説については、下記資料が参考となる。

1.  国土交通省水管理・国土保全局下水道部：内水浸水想定区域図作成マニュアル（案），2021.

    1.  []{#_Toc103778862 .anchor}内水氾濫解析モデルの選定

＜標　準＞

+----------------------------------------------------------------------+
| 内水氾濫解析における解析モデルの選定は以下を標準とする。             |
|                                                                      |
| １）基礎方程式                                                       |
|                                                                      |
| 内                                                                   |
| 水氾濫解析は、氾濫区域内の流速や水面勾配等が問題とならない場合の解析 |
| については、運動方程式を考慮せず池モデルで解析することを標準とする。 |
|                                                                      |
| 式(7-4-1)で示すとおり氾濫現象を一つの                                |
| 氾濫域で表現する場合は１池モデル、また、氾濫域を多数の池で代表させ、 |
| 湛水状況をある程度細かく表現しようとする場合は多池モデルと呼ばれる。 |
|                                                                      |
| > (7-4-1)                                                            |
|                                                                      |
| *V*：浸水ボリューム（浸水深の関数として表される）、*Q~in~*           |
| ：流域流出水、降雨、水路氾濫水等、*Q~out~*：下水道・排水路への流出量 |
|                                                                      |
| なお、氾濫区域内の流速や流速ベクトルの                               |
| 算定が必要な場合は、運動方程式を導入する必要があり、この場合は、本章 |
| 第3節 外水氾濫解析の方法を標準とする。                               |
|                                                                      |
| ２）離散化手法                                                       |
|                                                                      |
| 池モデルを使用する場合                                               |
| は、離散化手法は特に問題とならない。運動方程式を導入する場合は、本章 |
| 第3節 外水氾濫解析を標準とする。                                     |
+----------------------------------------------------------------------+

＜参考となる資料＞

内水解析の基礎方程式については、下記資料が参考となる。

1.  建設省河川局治水課監修，(財)国土開発技術研究センター編集：内水処理計画策定の手引き，山海堂，1995.

    1.  []{#_Toc103778863 .anchor}内水氾濫の計算条件の設定

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------
  内水氾濫の計算条件の設定においては、検討目的や解析モデルに応じて適切なモデル定数や流入条件を設定することを標準とする。
  ------------------------------------------------------------------------------------------------------------------------

＜例　示＞

+----------------------------------------------------------------------+
| 計算条件の設定方法を以下に例示する。                                 |
|                                                                      |
| １）池モデルにおける氾濫域諸元（H－V－A曲線）                        |
|                                                                      |
| 池モデルにおける                                                     |
| 氾濫域諸元としては、浸水位と湛水量と湛水面積の関係式を適切に与える必 |
| 要がある。H－V－A曲線の作成方法については、地形図、測量成果等より等  |
| 高線を描き、H（浸水位）とV(湛水量)、A（湛水面積）の関係を整理する。  |
|                                                                      |
| なお、池モデルでなく運                                               |
| 動方程式を導入する場合は、外水氾濫の計算条件の設定(3.3)を参照する。  |
|                                                                      |
| ２）流入条件・流出条件                                               |
|                                                                      |
| 内水氾濫の計算においては、式(7-4-1)右辺の流入量、流出量を与える必要  |
| があるが、氾濫解析モデルと流出モデル、河道モデル、下水道モデル等を組 |
| み合わせて、流入条件や流出条件の設定と氾濫解析を一体的に行うことが一 |
| 般的である。流出モデル、河道モデルの計算条件の設定については、第3章  |
| 水文解析 第2節 流出解析、第5章 河川における洪水流の水理解析          |
| を参照する。                                                         |
|                                                                      |
| 特に都市域での氾濫解析において重要となる下水道モデル                 |
| については、雨水等の流入（又は流出）地点であるマンホールと流下現象の |
| 生じる管路、排水ポンプとの組合せとしてモデル化されるが、複雑な管路網 |
| にも対応できるモデルが開発されており、これらを利用することができる。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

池モデルに関する計算条件の設定については、下記資料が参考となる。

1.  建設省河川局治水課監修，(財)国土開発技術研究センター編集：内水処理計画策定の手引き，山海堂，1995.

下水道の解析については、下記資料が参考となる。

234. (公財)日本下水道新技術機構：流出解析モデル利活用マニュアル（雨水対策における流出解析モデルの運用の手引き），2017.

235. 国土技術政策総合研究所水害研究室：NILIM2.0都市域氾濫解析モデルマニュアル，2012.

     1.  []{#_Toc103778864 .anchor}氾濫解析結果の活用

         1.  []{#_Toc103778865 .anchor}総説

＜考え方＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  氾濫解析結果の活用においては、例えば、住民等の円滑な避難や防災・減災のための土地利用促進、企業の事業継続計画に活用できるよう、水害リスク情報として目的に応じて表現方法を工夫するなど、活用がより効果的になるよう適宜加工することが重要である。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜参考となる資料＞

氾濫解析結果の活用方法は、下記が参考となる。

1.  社会資本整備審議会：気候変動を踏まえた水災害対策のあり方〜あらゆる関係者が流域全体で行う持続可能な「流域治水」への転換〜，答申，2020．

```{=html}
<!-- -->
```
236. 特定都市河川浸水被害対策法等の一部を改正する法律（令和３年法律第31号）.

237. 国土交通省都市局　水管理・国土保全局　住宅局：水災害リスクを踏まえた防災まちづくりのガイドライン，2021．

     1.  []{#_Toc103778866 .anchor}洪水浸水想定区域図

＜例　示＞

+----------------------------------------------------------------------+
| 洪水浸水想定区域とは、水防法第14条及                                 |
| び同法施行規則第1条から第3条に基づき、洪水時の円滑かつ迅速な避難を確 |
| 保し、又は浸水を防止することにより、水災による被害の軽減を図るため、 |
| 当該河川が氾濫した場合に浸水が想定される区域を指すものであり、想定さ |
| れる氾濫区域や浸水深等を着色で示したものを洪水浸水想定区域図と呼ぶ。 |
|                                                                      |
| 洪水浸水想定区域図は、様々な危険性を考慮して複数の                   |
| 堤防決壊地点や越流地点を設定して氾濫解析を行い、算定された氾濫域や浸 |
| 水深の最大値を包含する区域や浸水深、想定される浸水の継続時間を表す。 |
|                                                                      |
| 市町村長は、洪水浸水想定区域図等をも                                 |
| とに河川堤防の決壊、越流等による浸水情報及び避難に関する情報を住民に |
| 分かりやすく提供することにより人的被害を防ぐことを主な目的とした「洪 |
| 水ハザードマップ」を作成し、住民へ公表・周知を行うこととなっている。 |
|                                                                      |
| 洪水ハザードマップは、住民にとっ                                     |
| て、平常時には、自分の住んでいる地域の浸水履歴、浸水の可能性について |
| 認識を深める、水害に備えて非常持ち出し品の準備等被害軽減の工夫をする |
| 、土地の水害危険度に見合った土地利用や建築様式をとる等のほか、災害時 |
| には、洪水ハザードマップに盛り込まれた情報と気象情報、市町村からの避 |
| 難情報を基に的確な避難行動をとるといった活用を期待されるものである。 |
|                                                                      |
| また、想定最                                                         |
| 大規模の降雨に対する洪水浸水想定区域図等に加えて、より頻度の高い降雨 |
| も含めた多段階の洪水浸水想定を作成し、浸水の発生しやすさを評価するこ |
| とで、場所ごとの水害リスクが評価できるようになり、土地利用や住まい方 |
| の工夫、企業の事業継続計画などへの水害リスク情報の活用が考えられる。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

洪水浸水想定区域図の作成方法については、下記資料が参考となる。

1.  国土交通省水管理・国土保全局河川環境課水防企画室，国土技術政策総合研究所河川研究部水害研究室：洪水浸水想定区域図作成マニュアル（第４版），2015（2017年10月部分改定）．

    （最新版）洪水浸水想定区域図作成マニュアル（第4版），2017.国土交通省水管理・国土保全局河川環境課水防企画室　国土技術政策総合研究所河川研究部水害研究室.

```{=html}
<!-- -->
```
13. 

```{=html}
<!-- -->
```
238. 小規模河川の氾濫推定図作成の手引き、2020.国土交通省水管理・国土保全局河川環境課水防企画室国土技術政策総合研究所河川研究部水害研究室.

     （最新版）小規模河川の氾濫推定図作成の手引き、2023．国土交通省水管理・国土保全局河川環境課水防企画室　国土技術政策総合研究所河川研究部水害研究室.

洪水ハザードマップの作成については、下記資料が参考となる。

239. 水害ハザードマップ作成の手引き,
     2016　国土交通省水管理・国土保全局河川環境課水防企画室.

     （最新版）水害ハザードマップ作成の手引き，2023.国土交通省水管理・国土保全局河川環境課水防企画室.

     1.  []{#_Toc103778867 .anchor}リアルタイム氾濫シミュレーション

＜例　示＞

+----------------------------------------------------------------------+
| 堤防の決壊等に                                                       |
| 伴う浸水発生時において、その後の氾濫域の拡大状況等を予測し、避難誘導 |
| や危機管理対策に資するものをリアルタイム氾濫シミュレーションと呼ぶ。 |
|                                                                      |
| 氾濫域が広大若しくは地形勾配が緩やか等により、                       |
| 人口や資産の密集地域への浸水到達時間に一定程度以上の時間を要する場合 |
| は、浸水の到達域、到達時刻等に関する予測を行うことにより、浸水到達時 |
| 間を避難等のためのリードタイムとして有効に活用することが可能となる。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

リアルタイム氾濫シミュレーションについては、下記資料が参考となる。

1.  国土交通省河川局：リアルタイム浸水予測シミュレーションの手引き(案)，2005.

    1.  []{#_Toc103778868 .anchor}内水処理計画の策定

＜例　示＞

+----------------------------------------------------------------------+
| 内                                                                   |
| 水氾濫解析の活用事例としては、治水事業における内水処理計画の策定が挙 |
| げられる。内水河川の水位上昇は、内水河川と外水河川のハイドロの規模・ |
| 波形及びこれらの相対関係によるものであり、内水処理計画とは、内水河川 |
| の水位上昇が内水氾濫の直接の原因となる場合の対策を図るものである。対 |
| 策としては、合流点に水門等を設置し外水位と内水位のピーク時間差を考慮 |
| した水門操作を行うことにより外水位の上昇が内水位に及ばないようにする |
| か、若しくは上記による内水位上昇の回避が困難な場合は、ポンプ施設を設 |
| 置し内水を排水することにより、内水位の低下を図ることが一般的である。 |
|                                                                      |
| このため、内水                                                       |
| 処理計画の策定に当たっては外水河川及び内水河川の水理条件と堤内地の氾 |
| 濫解析モデルを適切に接続することにより、当該内水現象及び対策を講じた |
| 場合の効果を、所要の精度で再現できる解析モデルを構築する必要がある。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

内水処理計画の策定については、下記資料が参考となる。

1.  建設省河川局治水課監修，(財)国土開発技術研究センター編集：内水処理計画策定の手引き，山海堂，1995.

第8章　河川経済調査 {#第8章-河川経済調査 .TOC-Heading}
===================

目　次 {#目-次-7 .TOC-Heading}
======

[第1節 総説 1](#_Toc298343980)

[第2節 治水経済調査 1](#_Toc298343981)

> [2．1 便益の算定 2](#_Toc382986913)
>
> [2．2 費用の算定 2](#_Toc298343983)
>
> [2．3 総費用と総便益の比較 2](#_Toc298343984)

[第3節 河川環境経済調査 3](#_Toc382986916)

> [3．1 便益の算定 4](#_Toc301263387)
>
> [3．2 費用の算定、総費用と総便益の比較 5](#_Toc382986918)

平成26年4月　版

8.  河川経済調査

    1.  []{#_Toc298343980 .anchor}総説

＜考え方＞

+----------------------------------------------------------------------+
| 本章で                                                               |
| は、河川経済調査を実施するために必要な技術的事項を定めるものである。 |
|                                                                      |
| 河川経済調査は、河川事                                               |
| 業等に係る費用便益分析等を行うことを目的として実施されるものである。 |
|                                                                      |
| 国土交                                                               |
| 通省では、公共事業の効率性及びその実施過程の透明性の一層の向上を図る |
| ため、新規事業採択時等において事業評価を実施することとしており、費用 |
| 便益分析をはじめとする評価項目により総合的に事業評価を実施している。 |
|                                                                      |
| 費用便益分析は事業の投資効率性を評価する項                           |
| 目であり、国土交通省では、所管公共事業について費用便益分析の実施に係 |
| る計測手法、考え方等に関して共通的に考慮すべき事項を定めた技術指針を |
| 策定するとともに、河川関係の事業についても、当該指針との整合性を図り |
| つつ、それぞれの事業の特性を踏まえた基準を策定しているところである。 |
|                                                                      |
| 費用便益分析は、一般に①便益の算定、②費用の算定、③総                  |
| 費用と総便益の比較、により構成されるため、本章では、治水を目的とした |
| 事業及び河川環境整備を目的とした事業を対象に、①～③について解説する。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  [国土交通省所管公共事業の新規事業採択時評価実施要領](http://www.mlit.go.jp/tec/hyouka/public/110401/youryou/shinki110401.pdf)，平成23年4月1日，国土交通省.

    （最新版）国土交通省所管公共事業の新規事業採択時評価実施要領，令和6年6月27日，国土交通省.

```{=html}
<!-- -->
```
240. [国土交通省所管公共事業の再評価実施要領](http://www.mlit.go.jp/tec/hyouka/public/110401/youryou/saihyouka110401.pdf)，平成23年4月1日，国土交通省.

     （最新版）国土交通省所管公共事業の再評価実施要領，令和6年9月5日，国土交通省.

241. [河川及びダム事業の新規事業採択時評価実施要領細目](http://www.mlit.go.jp/river/basic_info/seisaku_hyouka/gaiyou/hyouka/pdf/kasen_01.pdf)，平成21年12月24日，国土交通省河川局.

242. [河川及びダム事業の再評価実施要領細目](http://www.mlit.go.jp/river/basic_info/seisaku_hyouka/gaiyou/hyouka/pdf/kasen_02.pdf)，平成22年4月1日，国土交通省河川局.

243. 公共事業評価の費用便益分析に関する技術指針（共通編），平成 21 年 6
     月，国土交通省

     （最新版）公共事業評価の費用便益分析に関する技術指針（共通編），令和6年9月，国土交通省.

244. 治水経済調査マニュアル(案)，平成17年4月，国土交通省河川局.

     （最新版）治水経済調査マニュアル（案）,令和7年7月，国土交通省水管理・国土保全局.

245. [河川に係る環境整備の経済評価の手引き【本編】](http://www.mlit.go.jp/river/basic_info/seisaku_hyouka/gaiyou/hyouka/h2203/tebiki.pdf)，平成22年3月，国土交通省河川局河川環境課.

     （最新版）河川に係る環境整備の経済評価の手引き【本編】，令和6年4月一部改訂，国土交通省河川局河川環境課.

246. [河川に係る環境整備の経済評価の手引き【別冊】](http://www.mlit.go.jp/river/basic_info/seisaku_hyouka/gaiyou/hyouka/h2203/tebiki-b.pdf)，平成22年3月，国土交通省河川局河川環境課.

     （最新版）河川に係る環境整備の経済評価の手引き【別冊】，平成31年3月，国土交通省河川局河川環境課.

     1.  []{#_Toc298343981 .anchor}治水経済調査

＜考え方＞

+----------------------------------------------------------------------+
| 本節では、治                                                         |
| 水経済調査を実施するに当たっての必要な技術的事項を定めるものである。 |
|                                                                      |
| 治水経済調査は、堤防やダム等                                         |
| の治水施設の整備に係る費用便益分析等を行うことを目的として実施される |
| ものであり、その実施に当たっては、下記の点に十分留意するものとする。 |
|                                                                      |
| -   治水施設の便益として算定対                                       |
| 象としている被害防止便益は、一定の想定の下に算定される推計値であり、 |
| かつ、治水施設の整備によって得られる便益の一部しか評価していないこと |
|                                                                      |
| -   事業の実施に際しては、効率性という観点だけでなく、公平性の観点   |
| も必要となり、総合的な評価指標の一つとして治水経済調査を利用すること |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  治水経済調査マニュアル(案)，平成17年4月，国土交通省河川局.

    （最新版）治水経済調査マニュアル（案）,令和7年7月，国土交通省水管理・国土保全局.

    1.  []{#_Toc382986913 .anchor}便益の算定

＜標　準＞

+----------------------------------------------------------------------+
| 治水施設の整備によ                                                   |
| る便益としては、水害によって生じる人命被害と直接的又は間接的な資産被 |
| 害を軽減することによって生じる可処分所得の増加（便益）、水害が減少す |
| ることによる土地の生産性向上に伴う便益、治水安全度の向上に伴う精神的 |
| な安心感などが考えられるが、計測することが困難なものが多くあり、それ |
| らの一部分である被害防止便益（水害によって生じる直接的又は間接的な資 |
| 産被害を軽減することによって生じる可処分所得の増加）の一部を治水事業 |
| の便益として算定することを標準とする。具体的には、洪水氾濫による直接 |
| 的・間接的な被害防止効果のうち、現段階で経済的に評価可能な被害の防止 |
| 効果として、直接的な資産の被害（家屋、公共土木施設等の被害等）と一部 |
| の間接被害（営業停止損失等）の防止効果を便益とすることを標準とする。 |
|                                                                      |
| ただし、その他の便益についても、個々の河川での調査によ               |
| り計測可能なものについては便益として評価することを妨げるものではなく |
| 、この場合、評価に当たっては重複のないよう留意することを基本とする。 |
|                                                                      |
| また、治水事業の便益の算定手順については、対象氾濫原の分割、流下能   |
| 力の把握、破堤地点の想定等を行った上で流量規模・氾濫ブロックごとに浸 |
| 水シミュレーションを実施することにより流量規模別の被害軽減額を求め、 |
| これに流量規模に応じた洪水の生起確率を乗じて求めた流量規模別年平均被 |
| 害額を累計し、もって年平均被害軽減期待額を算定することを標準とする。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  治水経済調査マニュアル(案)，平成17年4月，国土交通省河川局.

    （最新版）治水経済調査マニュアル（案）,令和7年7月，国土交通省水管理・国土保全局.

    1.  []{#_Toc298343983 .anchor}費用の算定

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------
  費用便益分析の対象とする費用については、治水事業着手時点から治水施設の完成に至るまでの総建設費と、評価対象期間内での維持管理費を対象とすることを標準とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1.  治水経済調査マニュアル(案)，平成17年4月，国土交通省河川局.

    （最新版）治水経済調査マニュアル（案）,令和7年7月，国土交通省水管理・国土保全局.

    1.  []{#_Toc298343984 .anchor}総費用と総便益の比較

＜標　準＞

+----------------------------------------------------------------------+
| 治水施設の整備及び維持管理に要する総費                               |
| 用と、治水施設整備によってもたらされる総便益（被害軽減）を、社会的割 |
| 引率を用いて現在価値化して比較する（図8-2-1参照）ことを標準とする。  |
|                                                                      |
| このため、評価時点を現在価値化の基準点とし、                         |
|                                                                      |
| -   治水施設の整備期間と治水施設の完成から50                         |
| 年間までを評価対象期間にして、治水施設の完成に要する費用と治水施設の |
| 完成から50年間の維持管理費を現在価値化したものの総和から総費用（Ｃ） |
|                                                                      |
| -   年平均被害軽                                                     |
| 減期待額（[2.1](http://www.yahoo.co.jp)で求めた各年の便益）と評価期  |
| 間末における施設の残存価値を現在価値化したものの総和から総便益（Ｂ） |
|                                                                      |
| を、それぞれ算定し、費用便益比（Ｂ／Ｃ）を算出することを標準とする。 |
|                                                                      |
| ![](media/image269.emf){width="6.044444444444444in"                  |
| height="4.439583333333333in"}                                        |
|                                                                      |
| 1.  総費用、総便益の考え方                                           |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  治水経済調査マニュアル(案)，平成17年4月，国土交通省河川局.

    （最新版）治水経済調査マニュアル（案）,令和7年7月，国土交通省水管理・国土保全局.

    1.  []{#_Toc382986916 .anchor}河川環境経済調査

＜考え方＞

+----------------------------------------------------------------------+
| 本節では、河川環境整備                                               |
| の経済調査を実施するに当たっての必要な技術的事項を定めるものである。 |
|                                                                      |
| 河川法に示されているように、「河川環境の整備と                       |
| 保全」は河川管理の目的の一つである。現在、河川に係る環境の整備や保全 |
| を主目的あるいは複合目的のひとつとした河川整備が進められており、この |
| ような事業についても、経済評価を適切に実施していくことが重要である。 |
|                                                                      |
| 一方、市場が                                                         |
| 存在しない環境はいわゆる非市場財であり、かつ、公共財としての性格も有 |
| するため、その評価には間接的手法を用いざるを得ない。また、その具体的 |
| 作業においては現在までに様々な評価手法が提案されてはいるが、確立され |
| たものはなく、各手法はそれぞれ技術的課題を有しているのが現状である。 |
|                                                                      |
| 河川環境整                                                           |
| 備の経済調査の実施に当たっては、以下の事項に十分留意するものとする。 |
|                                                                      |
| -                                                                    |
|   河川環境は、水量・水質、生態系、人と自然との豊かなふれあいの場、景 |
| 観、河川にまつわる祭り、伝統行事等極めて複雑かつ多岐にわたる要素から |
| 構成されており、その中には、必ずしも経済評価になじまないものもある。 |
|                                                                      |
| -   環境の経済評価については、幾つかの手法が提案されているが         |
| 、いまだ確立された手法はなく、様々な検討が進められている段階である。 |
|                                                                      |
| -   経                                                               |
| 済評価の結果については、総合的な観点から妥当性を吟味する必要がある。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  [河川に係る環境整備の経済評価の手引き【本編】](http://www.mlit.go.jp/river/basic_info/seisaku_hyouka/gaiyou/hyouka/h2203/tebiki.pdf)，平成22年3月，国土交通省河川局河川環境課.

    （最新版）河川に係る環境整備の経済評価の手引き【本編】，令和6年4月一部改訂，国土交通省河川局河川環境課.

```{=html}
<!-- -->
```
247. [河川に係る環境整備の経済評価の手引き【別冊】](http://www.mlit.go.jp/river/basic_info/seisaku_hyouka/gaiyou/hyouka/h2203/tebiki-b.pdf)，平成22年3月，国土交通省河川局河川環境課.

     （最新版）河川に係る環境整備の経済評価の手引き【別冊】，平成31年3月，国土交通省河川局河川環境課.

248. 治水経済調査マニュアル(案)，平成17年4月，国土交通省河川局.

     （最新版）治水経済調査マニュアル（案）,令和7年7月，国土交通省水管理・国土保全局.

     1.  []{#_Toc301263387 .anchor}便益の算定

＜標　準＞

+----------------------------------------------------------------------+
| 河川環境整備の便益は、事業                                           |
| 実施によって変化する効用の変化を貨幣換算したものとしてとらえられる。 |
|                                                                      |
| 河川環境は、河川に係る複数の環境要素によって１つの環                 |
| 境を形成している。環境整備の便益は、評価の対象となるこの環境を財とし |
| て捉え事業実施による効用の変化分を、貨幣換算して把握するものである。 |
|                                                                      |
| 便益                                                                 |
| の計測は、１）計測対象とする便益の特定化、２）手法の選定、３）便益の |
| 計測、４）妥当性の検証、というステップを踏んで行うことを標準とする。 |
|                                                                      |
| 1.  計測対象とする便益の特定化                                       |
|                                                                      |
| 環境                                                                 |
| 整備は、水量・水質、生態系、人と自然との豊かなふれあい、景観など非常 |
| に多くの面で人間生活と関わっている。これらの様々な面で生じる便益を、 |
| 全て正確に計測することは現状ではほとんど不可能であり、またその精度の |
| 検証も困難であるため、経済評価が可能な範囲は限定されていることに留意 |
| した上で、評価対象となる事業における効果要素を明確にする必要がある。 |
|                                                                      |
| 55. 手法の選定                                                       |
|                                                                      |
| 環境便益の代表的な計測手法                                           |
| としては、ＣＶＭ、ＴＣＭ、代替法等があり、これらの手法の選定に当たっ |
| ては、評価対象となる事業において抽出された効果要素に対し、表8-3-1の  |
| 各手法の長所・短所を踏まえて、総合的にどの手法を用いるかを判断する。 |
|                                                                      |
| 56. 便益の計測                                                       |
|                                                                      |
| 便益の計測に当た                                                     |
| っては、計測対象とする効果要素にどのような変化が生じるのか、できるだ |
| け正確に予測し、選定した手法の特性に十分留意して実施するものとする。 |
|                                                                      |
| 57. 妥当性の検証                                                     |
|                                                                      |
| 計測結果については、類似の環境財に関する既往の便益計測               |
| 結果と比較すること等により、その妥当性について検証を行うものとする。 |
+----------------------------------------------------------------------+

+----------------------------------------------------------------------+
| 1.  各手法の特徴                                                     |
|                                                                      |
| ![](media/image270.emf){width="4.770833333333333in"                  |
| height="5.322916666666667in"}                                        |
+----------------------------------------------------------------------+

1.  []{#_Toc382986918 .anchor}費用の算定、総費用と総便益の比較

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  河川環境経済調査の費用の算定、総費用と総便益の比較については、治水経済調査と同様に、本章の[2.2](http://www.yahoo.co.jp)費用の算定 及び[2.3](http://www.yahoo.co.jp)総費用と総便益の比較 に準じて行うことを標準とする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

**調査編**

10. **水害リスク評価**

**目　次**

第1節 総説 1

第2節 水害リスク評価の枠組みと手順 3

> 2．1 水害リスク評価に当たっての基本的な考え方 3
>
> 2．2 水害リスクの評価手順 4
>
> 2．3 水害リスク評価の対象項目と評価手法 6
>
> 2．4 水害リスク評価結果の整理 8

令和7年6月　版

適用上の位置付け

　河川砂防技術基準調査編は、基準の適用上の位置付けを明確にするために、下表に示すように適用上の位置付けを分類している。

+--------+------------------+------------------+------------------+
| 分　類 | 適用上の位置付け | 末尾の字句例     |                  |
+--------+------------------+------------------+------------------+
| 考え方 | 技術資料         | ●目              | 「･･･ある。      |
|        |                  | 的や概念、考え方 | 」「･･･いる。」  |
|        |                  | を記述した事項。 |                  |
|        |                  |                  | 「･･･なる。      |
|        |                  |                  | 」「･･･れる。」  |
+--------+------------------+------------------+------------------+
| 必　須 | 技術基準         | ●法令による規定  | 「･･･なければ    |
|        |                  | や技術的観点から | ならない。」「･  |
|        |                  | 実施すべきである | ･･ものとする。」 |
|        |                  | ことが明確であり |                  |
|        |                  | 遵守すべき事項。 |                  |
+--------+------------------+------------------+------------------+
| 標　準 | 技術基準         | ●特              | 「･･･            |
|        |                  | 段の事情がない限 | を標準とする。」 |
|        |                  | り記述に従い実施 |                  |
|        |                  | すべきだが、状況 | 「･･･            |
|        |                  | や条件によって一 | を基本とする。」 |
|        |                  | 律に適用すること |                  |
|        |                  | はできない事項。 | 「･･･による。」  |
+--------+------------------+------------------+------------------+
| 推　奨 | 技術資料         | ●状況や条件      | 「               |
|        |                  | によって実施する | ･･･望ましい。」  |
|        |                  | ことが良い事項。 |                  |
|        |                  |                  | 「               |
|        |                  |                  | ･･･推奨する。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･努める。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･必要に応    |
|        |                  |                  | じて･･･する。」  |
+--------+------------------+------------------+------------------+
| 例　示 | 技術資料         | ●適用条件や実施  | 「               |
|        |                  | 効果について確定 | ･･･などの手法（  |
|        |                  | している段階では | 事例）がある。」 |
|        |                  | ないが、状況や条 |                  |
|        |                  | 件によっては導入 | 「･･･など        |
|        |                  | することが可能な | の場合がある。」 |
|        |                  | 新技術等の例示。 |                  |
|        |                  |                  | 「･･･など        |
|        |                  | ●状              | が考えられる。」 |
|        |                  | 況や条件によって |                  |
|        |                  | 限定的に実施でき | 「               |
|        |                  | る技術等の例示。 | ･･･の場合には･･･ |
|        |                  |                  | ことができる。」 |
|        |                  | ●具体的          |                  |
|        |                  | に例示することに | 「               |
|        |                  | より、技術的な理 | ･･･例示する。」  |
|        |                  | 解を助ける事項。 |                  |
|        |                  |                  | 「例えば･･･。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･事例もある  |
|        |                  |                  | 。･･･もよい。」  |
+--------+------------------+------------------+------------------+

  関連通知等       関連する通知やそれを理解する上で参考となる資料
  ---------------- ------------------------------------------------------
  参考となる資料   例示等に示した手法・内容を理解する上で参考となる資料

10. 水害リスク評価

    1.  総説

＜考え方＞

+----------------------------------------------------------------------+
| 本章は、水害                                                         |
| リスク評価を実施するために必要な基本的な考え方を記載するものである。 |
|                                                                      |
| １）水害リスク評価とは                                               |
|                                                                      |
| 水                                                                   |
| 害リスクは、一般に、河川氾濫や内水氾濫等、水害をもたらす事象（ハザー |
| ド）の「発生確率」と、その確率に対応したハザードによる「被害規模」の |
| 組合せによって表現される。「被害規模」はハザードと人口、資産、社会経 |
| 済活動といった被害対象（エクスポージャ）及び被害対象のハザードに対す |
| る脆弱性によって決定される。水害リスク評価は、河川整備計画等の策定や |
| 治水事業の事業評価、施設の維持管理や運用、避難誘導や水防活動等の検討 |
| に活用することを目的に、大小様々な規模や特性を有する水害関連ハザード |
| について、水害対策によるリスク変化の分析・評価を実施するものである。 |
|                                                                      |
| ２）水害リスク評価の必要性と活用                                     |
|                                                                      |
| 近年、世界的に大規模な水害が多発しており                             |
| 、我が国においても、水害の頻度や規模が増してきている。また、地球温暖 |
| 化による集中豪雨の頻発・激甚化から、治水施設の能力の相対的な低下が懸 |
| 念される状況にあり、以前にも増して水害リスク評価が重要となっている。 |
|                                                                      |
| また、河川整備の内容を                                               |
| 検討する際は、一定規模以下の大雨・洪水に対する氾濫防止に加えて、その |
| 規模を超える大雨・洪水が発生した場合のことも考慮する必要がある。一般 |
| 的には、上下流の間では下流、本支川の間では本川の方が氾濫した場合の被 |
| 害が大きくなりやすいことなどを踏まえ、上下流間や本支川間で適切なバラ |
| ンスが取れ、水系全体として整合性を有する整備内容となるように検討する |
| 必要がある。このため、河川整備計画の立案時など、河川整備の内容を検討 |
| する際は、実績の大雨・洪水や計画規模のみならず、想定最大規模までの様 |
| 々な大雨・洪水の発生を想定し、河川の整備によって各地域の水害リスクが |
| どのように変化するかを把握し、地域間の安全度バランスが適切に保たれ、 |
| 被害を適切に軽減できているかを検討することが重要である。なお、気候変 |
| 動の影響については、一定の温暖化シナリオ（2℃上昇相当）を対象に河川整 |
| 備計画等でも考慮されるようになっているが、水害リスク評価の目的に鑑み |
| て、より多くの温暖化シナリオを想定した検討がなされることが望ましい。 |
|                                                                      |
| これまで、                                                           |
| 水害対策の実施の前提となる被害想定や水害リスク評価については、第8章  |
| 河川経済調査で                                                       |
| 述べた貨幣換算が可能な項目による評価が中心であったが、近年では人的被 |
| 害やライフライン停止による影響、交通途絶の影響等の算定手法について研 |
| 究・開発が進められている。これにより、今までは分析することができなか |
| った、地域に潜在するさまざまなリスク（人的被害リスク、ライフライン停 |
| 止リスク、交通途絶リスク等）について分析することが可能となっている。 |
|                                                                      |
| 水害リスクの全体像を明らか                                           |
| にすることによって、より効率的で、かつ地域間の安全度バランスに配慮し |
| た事業の実施が可能となるのに加え、施設能力を超過する洪水による氾濫等 |
| が発生する際に、河川整備に加えて、災害リスクの低い地域への住まい方の |
| 誘導等の被害対象を減少させるための対策や、避難体制の強化等の被害の軽 |
| 減・早期復旧・復興のための対策等を実施した場合に、被害がどのように軽 |
| 減されるかについてもあわせて評価することができる。そのため、リスクに |
| 応じた危機管理対策（警戒避難体制の整備、水害発生時の応急対策活動計画 |
| の策定、住まい方の誘導、防災教育・防災訓練等）の検討を行うことが可能 |
| となる。さらに、流域の水害リスク情報を公開し、これを広く活用できるよ |
| うにすることで、水害リスクについて関係者間で共通認識が形成されるよう |
| になり、自助・共助の意識の向上や、自主的な浸水対策の促進、TCFD（Task |
| Force on Climate-related Financial                                   |
| Disclosures）の提言を踏まえた企業による適応策検討等^参考と           |
| なる資料3)^に繋がるなど、流域治水の推進に寄与することが期待される。  |
|                                                                      |
| なお、水害リスク評価は                                               |
| 、今後の研究や水害実態の蓄積等を通じて、充実を図っていくものである。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

本章における「ハザード」「エクスポージャ」「脆弱性」の定義は、下記1)の資料に準拠している。「リスク」及び「水害リスク」は、本章の内容に即して、2)の資料も参考にして改めて定義している。以上を下表にまとめて示す．

1.  Terminology on Disaster Risk
    Reduction,国連・国際防災戦略（UNISDR）, 2009.

```{=html}
<!-- -->
```
249. 気候変動下の都市における戦略的水害リスク低減手法の開発,
     国土交通省国土技術政策総合研究所
     気候変動適応研究本部，国土技術政策総合研究所資料, 第1080号，2019.

表9-1-1 水害リスク関係の用語の定義

+--------------------------+------------------------------------------+
| **ハザード**             | 人命の損失、負傷、健康被害、財産への     |
|                          | 損害、生活やサービスの低下、社会的・経済 |
| **(Hazard)**             | 的崩壊、環境破壊を引き起こす可能性のある |
|                          | 危険な自然現象、物質、人間の活動や状態。 |
+==========================+==========================================+
| **暴露(エクスポージャ)** | ハザードの影響を受ける地帯に             |
|                          | 存在し、その影響により損失を被る可能性の |
| **(Exposure)**           | ある人々、財産、システム、その他の要素。 |
+--------------------------+------------------------------------------+
| **脆弱性**               | 地域社会、システム及                     |
|                          | び資産が有する、危険要素（Hazard）の悪影 |
| **(Vulnerability)**      | 響を受けやすくさせるような特徴及び状況。 |
+--------------------------+------------------------------------------+
| **リスク**               | ハザード又はハザードをもたらす原         |
|                          | 因事象の「発生確率」と、その確率に対応し |
| **(Risk)**               | たハザードによる「被害規模」の組み合わせ |
|                          | 。被害規模はハザード及びそのハザードに対 |
|                          | する暴露、脆弱性の3因子から決定される。  |
+--------------------------+------------------------------------------+
| **水害リスク**           | 河川氾濫や内水氾濫等のハ                 |
|                          | ザード又はハザードをもたらす原因事象であ |
|                          | る降雨や洪水流量の「発生確率」と、その確 |
|                          | 率に対応したハザードによる「被害規模」の |
|                          | 組合せ。本章で扱う水害リスク評価において |
|                          | は、ハザードとしては河川氾濫や内水氾濫を |
|                          | 、ハザードをもたらす原因事象としては降雨 |
|                          | や洪水流量等（これらは治水対策における外 |
|                          | 力となっている）を、暴露としては浸水域内 |
|                          | の人口や財産を、脆弱性としてはシステムや |
|                          | 資産の被害の受けやすさを取り上げている。 |
+--------------------------+------------------------------------------+

TCFD提言に関しては、以下資料が参考になる。

250. TCFD提言における物理的リスク評価の手引き～気候変動を踏まえた洪水による浸水リスク評価～,国土交通省水管理・国土保全局,
     2023年3月.

＜推奨＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  河川整備計画の検討に当たって、想定し得る最大規模の外力までの様々な規模の外力に対して、施設整備が完了した場合の水害リスクの変化を、人的被害、経済被害、社会経済活動への影響等の評価項目により可視化し、氾濫被害をできるだけ軽減する河川整備の選定に活用することが望ましい。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜例示＞

+----------------------------------------------------------------------+
| 河川整備と住まい方の工夫や避                                         |
| 難率の向上等の流域での対策を組み合わせることによる水害リスクの低減効 |
| 果を、横軸に降雨の「発生確率」、縦軸にある発生確率に対応した降雨によ |
| る「被害規模」をとり、当該水系の流域全体及び氾濫ブロック毎に両者の関 |
| 係を図化した水害リスクカーブを用いて示し、河川整備に加えて流域での対 |
| 策の促進を企図した事例がある^参考となる資料2)、参考となる資料3）^。  |
|                                                                      |
| 複数の温暖化シナリオにおけるアンサンブル気候予測に基づく大           |
| 量の降雨データを用いて気候変動による降雨の時空間分布や水害リスクの変 |
| 化を分析し、気候変動の適応策を検討した事例がある^参考となる資料3)^。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

河川整備計画の検討に当たって水害リスク評価を活用した事例として、下記の資料が参考となる。

1.  鈴鹿川における河川整備の効果について（水害リスクの評価（試行））（第
    16 回三重河川 流域委員会資料-8），平成28年3月24日，国土交通省
    中部地方整備局 三重河川国道事務所.

水害リスクカーブを用いて流域での対策の促進を企図した事例として、下記の資料が参考となる。

仁淀川水系における流域治水の推進方針【第2版】概要, 令和4年3月,
第8回仁淀川水系流域治水協議会資料-5，仁淀川水系流域治水協議会.

水害リスクカーブの意味と活用法、治水対策が水害リスクカーブに与える影響の類型（表9-2-3に概略説明）の詳細については、以下の資料が参考となる。ただし、以下の資料では「水害リスクカーブ」に代わり「被害―豪雨規模関係」という用語が用いられている。

251. 国総研プロジェクト研究報告　第56号　河川・海岸分野の気候変動適応策に関する研究　-「気候変動下での大規模水災害に対する対策群の設定・選択を支援する基盤技術の開発」の成果をコアとして」－,
     第Ⅲ部　気候変動影響に対する適応策に関する研究　Ⅲ-2　豪雨による水害への対応,
     平成29 年4月, 国土交通省国土技術政策総合研究所気候変動適応研究本部.

アンサンブル気候予測データを用いて、気候変動による水害リスクの変化を評価し、気候変動への適応策を検討した事例として下記の資料が参考となる。

252. 北海道地方における気候変動を踏まえた治水対策技術検討会中間とりまとめ（別冊マニュアル1/3），気候変動を踏まえた適応策（水害リスクの低減）検討マニュアル～十勝川流域、常呂川流域を例に～，令和2年5月.

＜関連通知等＞

1.  河川砂防技術基準計画編（施設配置等計画編），令和6年6月，国土交通省水管理・国土保全局,
    第2章 河川管理施設配置計画.

    水害リスク評価の手引き（試行版）平成30年5月,
    国土交通省水管理・国土保全局，国土技術政策総合研究所.

```{=html}
<!-- -->
```
253. 水災害リスクを踏まえた防災まちづくりガイドライン，令和3年5月，国土交通省都市局，水管理・国土保全局，住宅局.

     1.  水害リスク評価の枠組みと手順

         1.  水害リスク評価に当たっての基本的な考え方

＜考え方＞

  ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  水害リスク評価に当たっては、例えば避難計画等を検討する場合には、想定死者数や孤立者数などの項目についても水害リスク評価を行うことが重要であることから、表9-2-1に示すように、水害リスク評価を実施する河川や流域の特徴を踏まえて、貨幣換算可能な項目に限らない幅広い被害リスク項目を設定するとともに、評価項目ごとに既往文献等から被害発生のメカニズムやハザードとの関係を明確にした上で、可能な限り定量的に、またそれが困難な場合には定性的に評価を行い、水害の全体像を具体的に把握することを心がける。また、支川を含めた複数の河川からの氾濫や内水氾濫、土砂の発生量が多い河川における河道閉塞による氾濫や、橋梁への流木集積に伴う氾濫、堤防決壊過程の不確実性、人口動態の不確実性等、水害リスク評価結果に影響することが想定されるものの、被害発生等のメカニズムやその評価法についての知見が十分でないものについては、考慮しないという単純化も含めた仮定やシナリオ等を設定することにより評価せざるを得ない。この場合、設定した仮定やシナリオ等については、評価の前提条件として明示し、評価結果の解釈と活用が的確になされるようにするとともに、知見の充実に向けて技術課題を明確にしていくことが重要である。この観点から、第10章 災害調査 により蓄積された知見を被害発生メカニズムに逐次反映していくことが重要である。
  ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

2.  水害リスクの評価手順

＜推　奨＞

+----------------------------------------------------------------------+
| 水害リスクの評価手順を図9-2-1に示す。                                |
|                                                                      |
| はじめに降雨データの収集・整理                                       |
| を行い、あわせて流域、河川、氾濫域に関するデータの収集・整理を行う。 |
| この結果を基に、降雨等の外力、評価対象年次、河道・施設の整備状況（今 |
| 後の整備内容含む）等の条件を設定し、[第3章](http://www.yahoo.co.jp)  |
| 水文解析、[第5章](http://www.yahoo.co.jp)                            |
| 河川における洪水流の水理解析、[第7章](http://www.yahoo.co.jp)        |
| 氾濫解析                                                             |
| 等を行い、降雨の規模と発生確                                         |
| 率、及びその確率に対応した規模の降雨によって生じる河川の洪水流量、洪 |
| 水位、氾濫域内の浸水範囲、浸水深の時間的変化や浸水継続時間等、ハザー |
| ドの分析を行う。次に、評価対象年次に合わせた社会経済条件を設定し、氾 |
| 濫域における人口、資産、重要施設等の暴露や脆弱性の分析を行う。また、 |
| 氾濫解析等を行う前に、段階的に大きさを変えた複数の降雨波形によって生 |
| じる洪水位と無害流量に相当する水位、計画高水位、堤防天端高等や、各氾 |
| 濫ブロック内の背後地の人口や資産等を縦断的に整理した流域情報縦断図等 |
| を活用^2.4.1)参照^し、氾濫発生の蓋然性の高い区間、背後地資産が集積し |
| 氾濫に対する潜在的な被害の大きい区間、上下流・本支川間のバランス等を |
| 概略把握しておくことが望ましい。なお、氾濫解析を行う際には氾濫発生シ |
| ナリオ（破堤箇所の設定等）を設定する必要があるが、その際にこの概略把 |
| 握の結果が活用可能である。例えば、洪水位の縦断図を活用し、ある区間で |
| 計算水位が堤防高より著しく高くなることが把握できた場合などは、当該区 |
| 間で越水破堤が生じず、越水のみを見込むという氾濫発生シナリオが成り立 |
| たないと判断し、破堤箇所として設定するといった活用方法が考えられる。 |
|                                                                      |
| これらの                                                             |
| 結果を踏まえ、「治水経済調査マニュアル（案）」や「水害の被害指標分析 |
| の手引（H25試行版）」に基づき、対象とする水害の発生可能性と、氾濫ブ  |
| ロックごとの一般資産被害額、人的被害（想定死者数等）、経済被害、重要 |
| 施設被害等の影響について把握する。算定した水害リスクについて、河川水 |
| 位・堤防諸元・流域情報縦断図^参考となる資料2）及び2.4.1)参照^や、降  |
| 雨の発生確率毎の被害の流域内での空間分布図^2.4.2)参照^、水害リスクカ |
| ーブ^2.4.4~~3~~)参照^等を用いて整理し水害リスク低減策の検討を行う。  |
+----------------------------------------------------------------------+

  -------------------------------
  図9-2-1　水害リスク評価の手順
  -------------------------------

＜関連通知等＞

1.  治水経済調査マニュアル(案)，令和6年4月，国土交通省水管理・国土保全局.

    水害の被害指標分析の手引（H25試行版），平成25年7月，国土交通省水管理・国土保全局.

＜例示＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  複数の温暖化シナリオにおけるアンサンブル気候予測に基づく大量の降雨データを用いて、気候変動による降雨の時空間分布や水害リスクの変化を分析し、気候変動の適応策を検討した事例がある。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜参考となる資料＞

北海道地方における気候変動を踏まえた治水対策技術検討会中間とりまとめ（別冊マニュアル1/3），気候変動を踏まえた適応策（水害リスクの低減）検討マニュアル～十勝川流域、常呂川流域を例に～，令和2年5月.

1.  水害リスク評価の手引き（試行版）平成30年5月,
    国土交通省水管理・国土保全局、

    国土技術政策総合研究所．

    1.  水害リスク評価の対象項目と評価手法

＜推　奨＞

+----------------------------------------------------------------------+
| 水害により生じる被害の評価については、第8章                          |
| の                                                                   |
| 「治水経済調査マニュアル（案）」により貨幣換算した被害額で評価する他 |
| 、水害リスク評価を実施する河川や流域の特徴を踏まえて、貨幣換算可能な |
| ものに限らない項目を選定し、「水害の被害指標分析の手引（H25試行版）  |
| 」で示された手法を用いて定量的または定性的に評価することが望ましい。 |
|                                                                      |
| 水害リスクの主な評価項目は図9-2-2のとおりであり、図9-2               |
| -2の凡例における「被害額として算出する項目」が「治水経済調査マニュア |
| ル（案）」で算定可能な項目、「貨幣換算以外の方法で定量化する評価項目 |
| 」は「水害の被害指標分析の手引（H25試行版）」で算定可能な項目である  |
| 。更に、「水害の被害指標分析の手引（H25試行版）」で対象としている評  |
| 価項目をさらに細分化した被害指標の一覧は表9-2-1に示すとおりである。  |
|                                                                      |
| また、人的被害の評価にあたって、想定                                 |
| 死者数や孤立者数等は、氾濫形態によって大きく異なり、必ずしも浸水範囲 |
| に比例して大きくはならないことに注意が必要である^参考となる資料1)^。 |
|                                                                      |
| ![](media/image271.emf){width="5.930232939632546in"                  |
| height="3.9252744969378828in"}                                       |
|                                                                      |
| 図9-2-2 　水害リスクの主な評価項目                                   |
|                                                                      |
| 表9-2-1　貨幣換算化以外の方法で定量化する評価項目と被害指標          |
|                                                                      |
| +-------------------------------+-------------------------------+    |
| | 評価項目                      | 被害指標                      |    |
| +===============================+===============================+    |
| | １．人的被害.                 | 浸水区域内人口                |    |
| |                               |                               |    |
| |                               | 浸水区域内の災害時要援護者数  |    |
| |                               |                               |    |
| |                               | 想定死者数                    |    |
| |                               |                               |    |
| |                               | 最大孤立者数                  |    |
| |                               |                               |    |
| |                               | 3日以上孤立者数               |    |
| |                               |                               |    |
| |                               | 10年あたり避難回数            |    |
| |                               |                               |    |
| |                               | 10年あたり総避難者数          |    |
| +-------------------------------+-------------------------------+    |
| | ２．医療・社会福              | 機能低下する医療施設数        |    |
| | 祉施設等の機能低下による被害  |                               |    |
| |                               | 機能低下する医療              |    |
| |                               | 施設で治療している入院患者数  |    |
| |                               |                               |    |
| |                               | 機能低下する医療施設          |    |
| |                               | で治療している人工透析患者数  |    |
| |                               |                               |    |
| |                               | 機能低下する社会福祉施設数    |    |
| |                               |                               |    |
| |                               | 機能低                        |    |
| |                               | 下する社会福祉施設の利用者数  |    |
| +-------------------------------+-------------------------------+    |
| | ３．防災                      | 機能                          |    |
| | 拠点施設の機能低下による被害  | 低下する主要な防災拠点施設数  |    |
| |                               |                               |    |
| |                               | 機能低                        |    |
| |                               | 下する防災拠点施設の管轄区域  |    |
| |                               | 内人口（警察・消防・役所等）  |    |
| +-------------------------------+-------------------------------+    |
| | ４．交通途絶による波及被害    | 途絶する主要な道路            |    |
| |                               |                               |    |
| |                               | 道路途                        |    |
| |                               | 絶により影響を受ける通行台数  |    |
| |                               |                               |    |
| |                               | 道路途絶（交通迂回）に        |    |
| |                               | より増加する走行時間、経費等  |    |
| |                               |                               |    |
| |                               | 途絶する主要な鉄道            |    |
| |                               |                               |    |
| |                               | 鉄道途                        |    |
| |                               | 絶により影響を受ける利用者数  |    |
| +-------------------------------+-------------------------------+    |
| | ５．ライ                      | 電力の停止による影響人口      |    |
| | フラインの停止による波及被害  |                               |    |
| |                               | ガスの停止による影響人口      |    |
| |                               |                               |    |
| |                               | 上水道の停止による影響人口    |    |
| |                               |                               |    |
| |                               | 下水道の停止による影響人口    |    |
| |                               |                               |    |
| |                               | 通信                          |    |
| |                               | （固定）の停止による影響人口  |    |
| |                               |                               |    |
| |                               | 通信                          |    |
| |                               | （携帯）の停止による影響人口  |    |
| +-------------------------------+-------------------------------+    |
| | ６．経済                      | 産業連関分析等の経済          |    |
| | 被害の域内・域外への波及被害  | モデルを用いた経済波及被害額  |    |
| |                               |                               |    |
| |                               | 高い市                        |    |
| |                               | 場占有率を有する企業の被災に  |    |
| |                               | 伴うサプライチェーンへの影響  |    |
| |                               |                               |    |
| |                               | 浸水により被災する上場企業数  |    |
| |                               |                               |    |
| |                               | 浸水に                        |    |
| |                               | より被災する事業所の従業者数  |    |
| +-------------------------------+-------------------------------+    |
| | ７．地下空間の被害            | 浸水する地下鉄等の路線、駅等  |    |
| |                               |                               |    |
| |                               | 地下鉄の浸                    |    |
| |                               | 水により影響を受ける利用者数  |    |
| |                               |                               |    |
| |                               | 浸水する地下街・地下施設      |    |
| |                               |                               |    |
| |                               | 地下街・地下施設の浸          |    |
| |                               | 水により影響を受ける利用者数  |    |
| +-------------------------------+-------------------------------+    |
| | ８．文化財の被害              | 浸水する文化施設等            |    |
| +-------------------------------+-------------------------------+    |
| | ９．水害廃棄物の発生          | 水害廃棄物の発生量            |    |
| |                               |                               |    |
| |                               | 水害廃棄物の処理費用          |    |
| +-------------------------------+-------------------------------+    |
+----------------------------------------------------------------------+

＜関連通知等＞

治水経済調査マニュアル(案)，令和6年4月，国土交通省水管理・国土保全局.

1.  水害の被害指標分析の手引（H25試行版），平成25年7月，国土交通省水管理・国土保全局.

＜参考となる資料＞

大規模水害対策に関する専門調査会報告，首都圏水没～被害軽減のために取るべき対策とは～，平成
22 年 4 月，中央防災会議「大規模水害対策に関する専門調査会」.

1.  水害リスクの評価結果の整理

＜例示＞

+----------------------------------------------------------------------+
| 2.2で示した評                                                        |
| 価手順に基づき算定した被害想定等について整理する主な手法を以下に例示 |
| する。１）は、洪水位と流域に関する情報を合わせて縦断図に表示し、水害 |
| リスクを概略把握できるようにするものである。前者は、潜在的外水氾濫域 |
| におけるハザード作用の蓋然性を把握するための基本情報に、後者は浸水域 |
| 内の人口・財産等の暴露情報に対応するものである。また、２）は、第8章  |
| の「治水                                                             |
| 経済調査マニュアル（案）」や「水害の被害指標分析の手引（H25試行版）  |
| 」に基づき算定した想定される被害の空間分布として整理する方法であり、 |
| 流域全体の水害リスクの分布を把握することを可能にするものである。３） |
| は、河川整備によるリスク軽減効果の特徴を把握する方法であり、水位縦断 |
| 図により各地点の水位について整備前後での変化を確認するとともに、リス |
| クの軽減効果をもたらす要因について把握するものである。４）は、水系全 |
| 体及び氾濫ブロックごとに想定最大規模を含めた様々な確率規模の外力にお |
| いて算定した被害想定を整理する方法であり、超過外力も含めた地域の水害 |
| リスクの構造を把握することを可能にするものである。５）は、気候変動に |
| 伴う水害リスク変化をアンサンブル気候予測データによって評価するもので |
| あり、温暖化シナリオ（2℃上昇、4℃上昇等）毎に将来予測される降雨の時空 |
| 間分布等を基にしたリスク評価を行い、適応策検討を進めることに役立つ。 |
|                                                                      |
| １）河川水                                                           |
| 位・堤防諸元・流域情報縦断図を用いた上下流・本支川バランスの概略把握 |
|                                                                      |
| 図9-2-3の                                                            |
| ように現況の河道・施設、河川整備計画等に基づく整備後の河道・施設に対 |
| して、河川整備の目標とする降雨に加えて、河川整備基本方針において対象 |
| とする降雨、想定最大降雨など複数の降雨規模を想定して、流出計算や水位 |
| 計算を実施し、その結果を用いて洪水位縦断図を作成し、無害流量に相当す |
| る水位、計画高水位、堤内地盤高、堤防天端高、各氾濫ブロック内の背後地 |
| の人口や資産等を縦断的に整理した流域情報縦断図とともにとりまとめる。 |
|                                                                      |
| これらを表9-2-2に示                                                  |
| す観点から確認することで、段階的に大きさを変えた複数の降雨規模に応じ |
| た氾濫発生の蓋然性の高い区間、背後地資産が集積し氾濫に対する潜在的な |
| 被害の大きい区間、上下流・本支川間のバランスの概略が把握可能となる。 |
|                                                                      |
| ![](media/image272.emf){width="6.1402777777777775in"                 |
| height="4.307638888888889in"}                                        |
|                                                                      |
| 図9-2-3　河川水位・堤防諸元・流域情報縦断図                          |
|                                                                      |
| 表9-2-2 河川水位・堤防諸元・流域情報縦断図による概略把握の観点と内容 |
|                                                                      |
| +-------------------------------+-------------------------------+    |
| | 観点                          | 内容                          |    |
| +===============================+===============================+    |
| | 1.  氾濫発生（破堤・越        | -   計算した水位が無          |    |
| | 水）の危険性の高い区間の把握  | 害流量に相当する水位や計画高  |    |
| |                               | 水位、堤防天端高を超える箇所  |    |
| |                               | の縦断分布を流量規模別に整理  |    |
| |                               |                               |    |
| |                               | -   上記の該当箇所を破堤・越  |    |
| |                               | 水の危険箇所と見なし、その分  |    |
| |                               | 布の流量規模に伴う変化を把握  |    |
| +-------------------------------+-------------------------------+    |
| | 2.  氾                        | -                             |    |
| | 濫による潜在的被害分布の把握  |    各氾濫ブロックの氾濫域内総 |    |
| |                               | 人口・総資産等を参考にブロッ  |    |
| |                               | ク間での被害対象（エクスポー  |    |
| |                               | ジャ）の相対的な大きさを整理  |    |
| |                               |                               |    |
| |                               | -   氾濫ブロッ                |    |
| |                               | クごとにブロック内の①の危険箇 |    |
| |                               | 所の有無、有りの場合には氾濫  |    |
| |                               | 流量（または河川水位と堤防際  |    |
| |                               | 地盤高の比高）の大きさを整理  |    |
| |                               |                               |    |
| |                               | -   被害対象と氾濫流量        |    |
| |                               | の大きさの組み合わせ（※）とし |    |
| |                               | て潜在的被害の氾濫ブロック別  |    |
| |                               | の相対的な大きさを把握する。  |    |
| +-------------------------------+-------------------------------+    |
| | 3.  上下                      | -                             |    |
| | 流・本支川バランスの概略把握  |  ①の危険性の高低と②の潜在的被 |    |
| |                               | 害の大小の組み合わせとして水  |    |
| |                               | 害リスクの各ブロック間の相対  |    |
| |                               | 的な大きさを流量規模別に整理  |    |
| |                               |                               |    |
| |                               | -   上記について整備実        |    |
| |                               | 施前後で比較することより、バ  |    |
| |                               | ランスの改善状況を概略把握す  |    |
| |                               | るとともに、水害リスク評価に  |    |
| |                               | よる定量的な点検の要点を整理  |    |
| +-------------------------------+-------------------------------+    |
|                                                                      |
| ※各地点が破堤した場合の被害（人的または経済的）を算定                |
| した既往資料が利用できる場合（例えば、基本方針規模程度の外力に対して |
| 、各横断測量断面において無害流量を超えた時点で破堤させた場合の被害額 |
| ）、その被害の大きさを潜在的被害の大きさとして活用することができる。 |
+----------------------------------------------------------------------+

２）想定される被害の空間分布図

図9-2-4のように、同一の氾濫発生シナリオの下で算定した様々な評価外力に対して、氾濫ブロックや市区町村区域界等の評価ブロックごとに各評価指標についての被害の空間分布図を作成し比較することで、想定される被害の起こり方の空間分布特性を把握することができ、また、河川整備計画等の一連の整備による被害軽減効果を確認することができる。なお、評価ブロックについては、水害リスク評価の指標や目的、並びに検討対象流域の大きさや地形に応じて設定することが有効である。

![](media/image273.emf){width="6.123611111111111in"
height="4.519444444444445in"}

図9-2-4　想定される被害の空間分布図による被害軽減効果把握の例

３）河川整備によるリスク軽減効果の特徴の把握

図9-2-5のように河川整備前後での水位縦断図の比較により、リスク軽減効果をもたらす要因について把握することができる。

水位縦断図によるリスク軽減効果の特徴の把握については、各降雨確率において、整備後河道の水位が整備前河道の水位を下回っているか、背後の資産分布状況と水位低減のバランスが確保されているか、人口・資産の集中しているブロックにおいて整備前後で河川水位が低減しているかに着目する。また、１）と同様、表9-2-2の観点から、上下流・本支川間のバランスが整備後も確保されているかどうかを確認する。

![](media/image274.emf){width="6.298611111111111in"
height="3.2269094488188976in"}

図9-2-5　河川整備前後での水位縦断図の比較

４）被害―豪雨規模関係（水害リスクカーブ）

想定最大規模も含めた様々な評価外力に対する被害想定を算定し、横軸に降雨の「発生確率」、縦軸にある発生確率に対応した降雨による「被害規模」をとり、当該水系の流域全体及び氾濫ブロックごとに両者の関係を図化したものが水害リスクカーブである。水害リスクカーブを作成するにあたっては、4段階以上の確率規模で評価することが望ましい。図9-2-6に示すように、水害リスクカーブを元に当該水系や各地域のもつ水害リスクの構造を把握することができる。この構造把握は、水系全体について行うだけでなく、地域毎にも行うことが重要であるので、氾濫ブロックごとにも水害リスクカーブを作成し活用することが望ましい。

水害リスクカーブを用いることで、河川整備計画等の検討において、想定される河川整備の実施により、治水安全度の向上、リスク低減・分散等をバランス良く図ることができるかといった点検が可能となる^参考となる資料1)、参考となる資料2）^。

![](media/image275.emf){width="5.895833333333333in"
height="2.476490594925634in"}

図9-2-6　水害リスクカーブで表現される地域の水害リスク構造のイメージ

出典：水災害リスクを踏まえた防災まちづくりガイドライン（グラフの横軸を反転し掲載）

図9-2-7のように河川の施設整備前後の条件で算定した結果を水害リスクカーブに整理することで、当該整備による整備目標外力までの被害の防止（無被害で済む外力規模の範囲の拡大）とともに、河川整備による被害軽減効果について、整備目標の外力よりも大きい外力に対する効果も含めて確認することができる。また、図9-2-8のように氾濫ブロックごとの被害軽減効果を可視化することで流域内での被害軽減効果のバランスを確認することができる。

![グラフ, 折れ線グラフ AI
によって生成されたコンテンツは間違っている可能性があります。](media/image276.png){width="3.6744192913385825in"
height="2.193882327209099in"}

図9-2-7　水害リスクカーブを用いた整備前後の水害リスクの比較のイメージ

![](media/image277.emf){width="6.141666666666667in"
height="5.329861111111111in"}

※リスクカーブは流域内の各ブロック間の被害の大小関係も確認するため数量軸を統一する。

図9-2-8　流域内の各地域での河川の施設整備前後の水害リスク低減効果比較のイメージ

さらに、水害リスクカーブを用いて、河川整備に加えて流域での対策を組み合わせた水害リスクの低減策を一体的に検討することができる^参考となる資料2)^。また、被害の防止から軽減までの各対策は表9-2-3に示すように類型化され、各対策を組み合わせることによる総合的な効果を水害リスクカーブにより表現することができる。水害リスク低減策の検討にあたっては、これらの対策を組み合わせ、無被害で済む降雨確率規模の範囲の拡大、河川整備目標を超えた降雨規模領域における降雨規模増大に対する被害増加率（水害リスクカーブの傾き）の低減、最大被害（水害リスクカーブの高さ）の低減を図ることが重要である。この水害リスクカーブの傾きの低減は、気候変動による外力の増大に対する被害増大を鈍らせるので、適応策としても有効である。

また、各種対策実施による水害リスクカーブの改善効果を、流域内の関係者間で共有することで、流域での対策の促進等、流域治水推進にも寄与することが期待される^参考となる資料3)^。

表9-2-3　対策による水害リスクの変化の類型

+----------------------+----------------------+----------------------+
| 類型                 | 対策による水         | 水害リスク           |
|                      | 害リスクカーブの変化 | の変化の特徴と対策例 |
+======================+======================+======================+
| 無被害               | ![](media/im         | 対策によって         |
| となる降雨規模の拡大 | age278.emf){width="2 | 被害が発生しない降雨 |
|                      | .4925371828521437in" | の規模が大きくなる。 |
|                      | height="1.           |                      |
|                      | 4958333333333333in"} | ＜対策例＞           |
|                      |                      |                      |
|                      |                      | > 一律的な掘         |
|                      |                      | 削、ダムや遊水地など |
|                      |                      | 洪水調節施設の整備等 |
|                      |                      |                      |
|                      |                      | 流域での貯留対策     |
+----------------------+----------------------+----------------------+
| 無被害となる         | ![](media/im         | 対策                 |
| 降雨規模の拡大＆一定 | age279.emf){width="2 | によって被害が発生し |
| 以下の降雨規模での被 | .4524890638670165in" | ない降雨の規模が大き |
| 害軽減＆一定以上の降 | height="1.           | くなり、一定以下の降 |
| 雨規模での被害の拡大 | 4701388888888889in"} | 雨規模までは被害を軽 |
|                      |                      | 減する。一方で、一定 |
|                      |                      | 以上の規模の降雨に対 |
|                      |                      | して被害が増大する。 |
|                      |                      |                      |
|                      |                      | ＜対策例＞           |
|                      |                      |                      |
|                      |                      | > 相対的に           |
|                      |                      | 流下能力の低い区間に |
|                      |                      | 限定した掘削、築堤（ |
|                      |                      | この河川整備によって |
|                      |                      | 当該区間の被害が発生 |
|                      |                      | しづらくなることで、 |
|                      |                      | 背後地の人口や資産等 |
|                      |                      | の大きい他区間で被害 |
|                      |                      | が発生しやすくなり、 |
|                      |                      | 一定以上の降雨規模で |
|                      |                      | の流域全体の被害が大 |
|                      |                      | きくなるような場合） |
+----------------------+----------------------+----------------------+
| 全ての降             | ![](media/i          | 対策によ             |
| 雨規模での被害の低減 | mage280.emf){width=" | って被害が発生しない |
|                      | 2.544776902887139in" | 降雨の規模は変わらな |
|                      | height="1.           | いが、全ての降雨規模 |
|                      | 5197298775153105in"} | で被害が軽減される。 |
|                      |                      |                      |
|                      |                      | ＜対策例＞           |
|                      |                      |                      |
|                      |                      | > 適切な避難         |
|                      |                      | や住まい方の工夫のた |
|                      |                      | めのリスク情報の提供 |
|                      |                      |                      |
|                      |                      | 氾濫水の早期排除     |
+----------------------+----------------------+----------------------+

４）複数の温暖化シナリオ毎の水害リスクの比較

図9-2-9、図9-2-10のように、水害リスクの評価外力にアンサンブル気候予測データの降雨波形を活用することで、今後の気候変動の影響を反映した水害リスクの評価が可能となる。複数の温暖化シナリオ毎のアンサンブル気候予測データを活用しながら、想定死者数や想定被害額のほか、農業への影響など、地域特性に合わせた評価項目を設定し、流域のリスク評価を行うことで、複数の温暖化シナリオ毎に、気候変動に対する適応策として実施すべき対策内容や優先度の検討が可能となる。^参考となる資料4)^

![マップ AI
によって生成されたコンテンツは間違っている可能性があります。](media/image281.png){width="6.069767060367454in"
height="3.1196030183727035in"}

図9-2-9　温暖化シナリオ毎の年平均想定死者数分布の比較

![マップ AI
によって生成されたコンテンツは間違っている可能性があります。](media/image282.png){width="6.161157042869641in"
height="2.7835115923009623in"}

図9-2-10　温暖化シナリオ毎の年平均想定被害額の比較

＜関連通知等＞

河川砂防技術基準計画編（施設配置等計画編），令和6年6月，国土交通省水管理・国土保全局,
第2章 河川管理施設配置計画.

1.  水害リスク評価の手引き（試行版）平成30年5月,
    国土交通省水管理・国土保全局，国土技術政策総合研究所.

```{=html}
<!-- -->
```
254. 水災害リスクを踏まえた防災まちづくりガイドライン，令和3年5月，国土交通省都市局，水管理・国土保全局，住宅局.

＜参考となる資料＞

河川整備計画の検討に当たって水害リスク評価を活用した事例として、下記の資料が参考となる。

鈴鹿川における河川整備の効果について（水害リスクの評価（試行））（第 16
回三重河川 流域委員会資料-8），平成28年3月24日，国土交通省
中部地方整備局 三重河川国道事務所.

水害リスクカーブにおける施策類型の考え方について、以下の資料が参考となる。ただし、以下の資料では「水害リスクカーブ」に代わり「被害―豪雨規模関係」という用語が用いられている。

1.  国総研プロジェクト研究報告　第56号　河川・海岸分野の気候変動適応策に関する研究　-「気候変動下での大規模水災害に対する対策群の設定・選択を支援する基盤技術の開発」の成果をコアとして」－,
    第Ⅲ部　気候変動影響に対する適応策に関する研究　Ⅲ-2　豪雨による水害への対応,
    平成29 年4月, 国土交通省国土技術政策総合研究所気候変動適応研究本部.

水害リスクカーブを利用して流域での対策の促進を企図した事例として、下記の資料が参考となる。

255. 仁淀川水系における流域治水の推進方針【第2版】概要, 令和4年3月,
     第8回仁淀川水系流域治水協議会資料-5，仁淀川水系流域治水協議会.

アンサンブル気候予測データを用いて、気候変動による水害リスクの変化を評価し、気候変動への適応策を検討した事例として下記の資料が参考となる。

256. 北海道地方における気候変動を踏まえた治水対策技術検討会中間とりまとめ（別冊マニュアル1/3），気候変動を踏まえた適応策（水害リスクの低減）検討マニュアル～十勝川流域、常呂川流域を例に～，令和2年5月.

**調査編**

11. **　災害調査**

**目　次**

[第1節 総説 1](#_Toc130808318)

> [1．1 本章の位置付け 1](#_Toc130808319)
>
> [1．2 目的の明確化 1](#_Toc130808320)
>
> [1．3 分類 2](#_Toc130808321)
>
> [1．4 基本的留意事項 2](#_Toc130808322)

[第2節 対象とする区域等に応じた災害調査 4](#_Toc130808323)

> [2．1 河川区域及びその周辺を対象にした災害調査 4](#_Toc130808324)
>
> [2．1．1 目的の設定 4](#_Toc130808325)
>
> [2．1．2 調査内容 4](#_Toc130808326)
>
> [2．2 河川氾濫域等を対象にした災害調査 6](#_Toc130808327)
>
> [2．2．1 目的の設定 6](#_Toc130808328)
>
> [2．2．2 調査内容 6](#_Toc130808329)
>
> [2．3 砂防域及び急傾斜地等を対象にした災害調査 7](#_Toc130808330)
>
> [2．3．1 目的の設定 7](#_Toc130808331)
>
> [2．3．2 調査内容 7](#_Toc130808332)
>
> [2．4 海岸及び海岸低地を対象にした災害調査 8](#_Toc130808333)

[第3節 災害調査成果の蓄積と共有化 8](#_Toc130808334)

令和５年５月　版

適用上の位置付け

> 河川砂防技術基準調査編は、基準の適用上の位置付けを明確にするために、下表に示すように適用上の位置付けを分類している。

+--------+------------------+------------------+------------------+
| 分　類 | 適用上の位置付け | 末尾の字句例     |                  |
+--------+------------------+------------------+------------------+
| 考え方 | 技術資料         | ●目              | 「･･･ある。      |
|        |                  | 的や概念、考え方 | 」「･･･いる。」  |
|        |                  | を記述した事項。 |                  |
|        |                  |                  | 「･･･なる。      |
|        |                  |                  | 」「･･･れる。」  |
+--------+------------------+------------------+------------------+
| 必　須 | 技術基準         | ●法令による規定  | 「･･･なければ    |
|        |                  | や技術的観点から | ならない。」「･  |
|        |                  | 実施すべきである | ･･ものとする。」 |
|        |                  | ことが明確であり |                  |
|        |                  | 遵守すべき事項。 |                  |
+--------+------------------+------------------+------------------+
| 標　準 | 技術基準         | ●特              | 「･･･            |
|        |                  | 段の事情がない限 | を標準とする。」 |
|        |                  | り記述に従い実施 |                  |
|        |                  | すべきだが、状況 | 「･･･            |
|        |                  | や条件によって一 | を基本とする。」 |
|        |                  | 律に適用すること |                  |
|        |                  | はできない事項。 | 「･･･による。」  |
+--------+------------------+------------------+------------------+
| 推　奨 | 技術資料         | ●状況や条件      | 「               |
|        |                  | によって実施する | ･･･望ましい。」  |
|        |                  | ことが良い事項。 |                  |
|        |                  |                  | 「               |
|        |                  |                  | ･･･推奨する。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･務める。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･必要に応    |
|        |                  |                  | じて･･･する。」  |
+--------+------------------+------------------+------------------+
| 例　示 | 技術資料         | ●適用条件や実施  | 「               |
|        |                  | 効果について確定 | ･･･などの手法（  |
|        |                  | している段階では | 事例）がある。」 |
|        |                  | ないが、状況や条 |                  |
|        |                  | 件によっては導入 | 「･･･など        |
|        |                  | することが可能な | の場合がある。」 |
|        |                  | 新技術等の例示。 |                  |
|        |                  |                  | 「･･･など        |
|        |                  | ●状              | が考えられる。」 |
|        |                  | 況や条件によって |                  |
|        |                  | 限定的に実施でき | 「               |
|        |                  | る技術等の例示。 | ･･･の場合には･･･ |
|        |                  |                  | ことができる。」 |
|        |                  | ●具体的          |                  |
|        |                  | に例示することに | 「               |
|        |                  | より、技術的な理 | ･･･例示する。」  |
|        |                  | 解を助ける事項。 |                  |
|        |                  |                  | 「例えば･･･。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･事例もある  |
|        |                  |                  | 。･･･もよい。」  |
+--------+------------------+------------------+------------------+

  関連通知等       関連する通知やそれを理解する上で参考となる資料
  ---------------- ------------------------------------------------------
  参考となる資料   例示等に示した手法・内容を理解する上で参考となる資料

11. 災害調査

    1.  []{#_Toc130808318 .anchor}総説

        1.  []{#_Toc130808319 .anchor}本章の位置付け

＜考え方＞

+----------------------------------------------------------------------+
| 本章は、暴風、                                                       |
| 豪雨、洪水、高潮、地震、津波、噴火その他の異常な自然現象が原因となっ |
| て生じた災害を主対象に、災害後に施設等の被災状況、浸水被害等一般被害 |
| の状況、災害に伴う社会的な影響等について事実関係を調査し、必要な分析 |
| を行う災害調査について、その目的の設定、分類と基本的留意事項を第1節  |
| で、対象とする区域等に応じた調査内容を第2節 で示す。また、第3節      |
| では調査結果の蓄積と共有化について示す。                             |
|                                                                      |
| 本基準において調査の対象と                                           |
| している主な区域等は、河川区域及びその周辺、河川氾濫域、砂防関係事業 |
| 実施区域(以下、「砂防域」)及び急傾斜地等、海岸及び海岸低地等である。 |
|                                                                      |
| 第1章 総論 1.3 改定の要点 と3.3 激甚化する災害への対応               |
| で述べているように、激甚な災害が頻発する状況下、災害が起             |
| こった際に、その内容を適切に調査することの重要性はますます高まってい |
| る。その一方、災害の態様は様々で、複雑な状況を呈することも多く、災害 |
| の調査を行うことは重要という一般論だけをもって、災害現場で調査を行い |
| 、関連情報を収集しても、必ずしも有用な知見が獲得できるとは限らない。 |
|                                                                      |
| このことを踏まえ、本章では、上述の区域等で災害が発生し、災害調       |
| 査の実施が検討される際に、考慮すべき事項と役立つ事項を述べ、当該災害 |
| 調査が「災害の内容から有益な知見を得る」ものになるための助けとする。 |
+----------------------------------------------------------------------+

2.  []{#_Toc130808320 .anchor}目的の明確化

＜考え方＞

+----------------------------------------------------------------------+
| 災害調査に取りかかる際には、具体的な目的を明                         |
| 確にすることが重要である。このことは、調査から有益な知見を得る上で必 |
| 須であり、また、調査の有効性や実施の要否を判断する際の尺度にもなる。 |
|                                                                      |
| 以下に、目的となり得る代表的な事項を列記する。                       |
|                                                                      |
| 災害                                                                 |
| 調査の実施検討に当たっては、当該災害の内容を踏まえ、これらの目的設定 |
| の代表例を参考に、適切かつ具体的な目的設定を行う。なお、当該災害調査 |
| について、あらかじめ具体の目的が与えられている場合には、それに従う。 |
|                                                                      |
| １）災害事象に関わる事実関係を調査し分析することにより、たとえば当該 |
| 災害からの適切かつ迅速な復旧に用いるべき技術的方法の検討に役立てる。 |
|                                                                      |
| ２）調査分析を通じて、災害の起こり方をできるだけ定量的、客観的、     |
| 論理的に説明できるようにすることにより、技術基準の改訂などにいかす。 |
|                                                                      |
| ３）災害調査等から得られた知見を、体系的な形で蓄積・                 |
| 共有化することにより、計画・設計・管理などに幅広く着実に反映させる。 |
|                                                                      |
| ４）災害事                                                           |
| 象は、実スケールの現象であることから、その調査を通じて、従来採られて |
| きた施策等について、ソフト・ハードにかかわらず、有効性や課題を具体的 |
| に明らかにすることにより、施策等の改善・見直しを図ることに役立てる。 |
|                                                                      |
| ５）災害事象の解析や設計、評価手法についても，それらの結果と         |
| 実態との適合度や用いられてきたパラメータ値等について新しい情報を得る |
| ことにより、手法の精度向上やパラメータ等の設定法の合理化に役立てる。 |
|                                                                      |
| ６）社会・経済的状況との接点                                         |
| に関わる事象を含む新たな課題をいち早く特定することにより、行政政策と |
| して取り組むべき事項を先行的に見いだし、政策の企画・立案に役立てる。 |
|                                                                      |
| ７）中長期的に取り組むべき新たな技術開発課題を得る。                 |
+----------------------------------------------------------------------+

3.  []{#_Toc130808321 .anchor}分類

＜考え方＞

+----------------------------------------------------------------------+
| 災害調査は、社会や施設等に影響を及ぼした異常な自然現象の発           |
| 生状況・要因やそれがもたらした影響のプロセスの調査と、異常な自然現象 |
| を受けて社会や施設等が影響を受けた要因・プロセスの調査に分類される。 |
|                                                                      |
| 異常な自然現象の発生状況・要因やそれがもたらした影響のプロセスに対す |
| る調査は、例えば、地震や豪雨などの災害を引き起こした事象について、事 |
| 象生起の状況（強度や規模、分布など）を調べ、さらにそれが洪水や氾濫な |
| ど災害を引き起こす現象をどのようにもたらしたかを把握するものである。 |
|                                                                      |
| ま                                                                   |
| た、社会や施設等が受けた影響の内容や要因、影響出現のプロセスに対する |
| 調査は、例えば、人的被害、家屋・建物被害、各種施設等の被害、これらに |
| も関係する社会的な被害・打撃・影響について、被害内容や被害分布、それ |
| ぞれの被害の態様や程度、メカニズムなどを具体的に把握するものである。 |
|                                                                      |
| 更に、災害調査は、時間の経過に応じて、発災直後の段階、現象解         |
| 析・原因究明の段階、技術基準・政策への反映段階に分けることもできる。 |
|                                                                      |
| 今後実施を予定している                                               |
| 災害調査を的確かつ効果的に進めるため、上述の分類や段階に照らしあわせ |
| ることにより、当該調査の目的・位置付けの明確化を図ることが望ましい。 |
|                                                                      |
| なお、環境保全上の観点から、河川環境に関する調査については、第11章   |
| 河川環境調査 によるものとする（調査の基本的な考え方は第11 章         |
| 河川環境調査 1.3 と 1.4 を、分析に際しての基本事項は同章の16.1       |
| を参照する）。                                                       |
+----------------------------------------------------------------------+

4.  []{#_Toc130808322 .anchor}基本的留意事項

＜考え方＞

+----------------------------------------------------------------------+
| 調査に当たっては、本節の1.2 目的の明確化                             |
| に示すように明確化した具体の目的に応じて、また、1.3                  |
| 分類に示す分類や段階に応じて、調査対象ごとに適切な方法を採用する。   |
|                                                                      |
| なお、異なる自然現象による外力の複合的な作                           |
| 用や、連鎖的な事象の発生により、大きな被害となることがあることから、 |
| 災害の全体的な状況を把握するため、総合的な観点から調査を組み立てる。 |
|                                                                      |
| また、必                                                             |
| 要に応じて、本技術基準調査編の他章で提示する調査・解析・計算手法を適 |
| 切に組み合わせて調査を実施する。その際には、次の事項に十分留意する。 |
|                                                                      |
| １）調査対象、調査規模に関する適切な判断                             |
|                                                                      |
| 災害の                                                               |
| 発生を早期に把握した上で、調査の必要性や優先順位、調査を行う場合の規 |
| 模・体制については、設定した目的を踏まえ、技術的重要度、社会的影響の |
| 程度、期待される効果と制約要因（コスト、人的資源、時間、支援体制の確 |
| 保、調査資機材の特徴等など）を比較検討し、適切かつ迅速な判断を行う。 |
|                                                                      |
| 特に初動・即応段階においては、人                                     |
| 的資源・支援体制の補完として、国が大規模自然災害に対し迅速に地方公共 |
| 団体等への支援を行うTEC-FORCEの被害状況調査結果の活用も有効である。  |
|                                                                      |
| ２）適確な調査時期の設定                                             |
|                                                                      |
| 災害の実態                                                           |
| をいち早く把握することが必要な災害調査においては、災害現場の状況を正 |
| 確に把握できる段階で現場調査を実施する。なお、調査の実施にあたっては |
| 、被災者の生活や復旧活動への影響等に対して、十分な配慮が必要である。 |
|                                                                      |
| また、被災地等への社会的影響を調査する社会調査が必要な場合は、被災地 |
| の行政機関の状況や、被災者の心情を十分に踏まえることが必要であり、調 |
| 査の実施にあたっては、被災地の行政機関等との事前の調整が重要である。 |
|                                                                      |
| ３）調査に求められる技術レベルの明確化と必要な専門性の確保           |
|                                                                      |
| 原因究明や、現象の解析段階において、調査結果か                       |
| ら、具体的な技術的判断や施策検討に資する情報を取得するためには、災害 |
| メカニズムを定量的、客観的、論理的に説明できる情報が必要となる。この |
| ため、調査において投入すべき技術レベル（現象把握や解析の詳細度や精度 |
| 、調査・解析手法の難易度、これらに応じた専門分化度など）を明確にし、 |
| そのレベルに見合った専門性を確保した上で調査を実施する。また、災害の |
| 事象が複数の専門分野にわたる場合には、個々の分野における分析だけでな |
| く、分野を横断的に統合し、俯瞰的な分析を行うことができる体制とする。 |
|                                                                      |
| ４）現場情報・データの収集・整理・提供に関する適確な支援             |
|                                                                      |
| 災害調査の実施にあた                                                 |
| っては、災害現場に関する様々な情報が必要である。その中には被災直後で |
| しか取得できないものがあり、その際には特に安全性を確保した上でのデー |
| タ取得に努める。また、被災者の生活や復旧活動への影響等に十分に配慮す |
| るという観点から、調査およびデータ収集等を効率的・効果的に実施するよ |
| うに努める。そのため、災害現場の管理者等と連携を図りつつ、現場情報・ |
| データを効率的に収集・整理・提供する支援体制の構築が重要であり、その |
| ためには、発災後速やかに関係者と調整を行っておくことが効果的である。 |
|                                                                      |
| ５）データの活用                                                     |
|                                                                      |
| 取得したデータについて                                               |
| は、関連施策や施設計画などに広く活用が図られることを念頭に、報告書等 |
| にとりまとめのうえ、ホームページ等で広く共有を図ることが有効である。 |
|                                                                      |
| ６）デジタル技術の活用                                               |
|                                                                      |
| 被災直後においては、災害現場を機動的、俯瞰的に把握すること           |
| や、災害調査の迅速化・効率化や調査の安全性の確保を図る必要がある。こ |
| のため、空中写真やドローン等を用いたデジタル技術の活用が有効である。 |
|                                                                      |
| また、迅速な被災実態把握                                             |
| 、復旧対策の円滑な検討の観点から、遠隔、自律的な調査（ドローン等）が |
| 可能であるデジタル技術を活用したデータ（航空レーザー測量、グリーンレ |
| ーザー測量、レーザースキャナー等による点群データ）取得が有効である。 |
|                                                                      |
| ７）被災箇所の復旧における環境への配慮                               |
|                                                                      |
| 被災                                                                 |
| 箇所の復旧にあたり、環境への配慮が必要な場合には、河川環境管理シート |
| 等も参照に被災前の環境情報を収集し、また、被災前環境情報の多寡にかか |
| わらず専門家の意見を伺いながら必要な対策を検討することが重要である。 |
+----------------------------------------------------------------------+

＜推　奨＞

+----------------------------------------------------------------------+
| 上記１）～７                                                         |
| ）に関して、調査の計画、実施、調査結果の活用など一連の調査にあたって |
| は、官・学・民の連携のもと、効率的・効果的に実施することが望ましい。 |
|                                                                      |
| 上記２）・４）に関して、被災地の早期復旧を妨げない                   |
| よう、効率的な体制による速やかな調査が重要である。例えば、被災地に複 |
| 数の調査が集中しないよう、関係機関との共同調査を行うことが望ましい。 |
|                                                                      |
| 上記３）                                                             |
| に関して、直接的災害事象だけでなく、それが生じた背景も分析対象に組み |
| 込むことが望ましい。また、アンケート調査など社会調査を実施する場合に |
| は、調査方法や分析方法の妥当性を確保するため、調査票の作成、現地調査 |
| の実施等に当たり、社会調査の専門家の意見を聴いて行うことが望ましい。 |
|                                                                      |
| 上記４）に関して、状況が許す範囲で、被災し                           |
| た施設等を調査時まで極力存置するような処置を検討することが望ましい。 |
|                                                                      |
| 上記５）に関し                                                       |
| て、組織的にデータを蓄積し、常時、検索可能にしておくことが望ましい。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

社会調査に関する留意事項については、下記の資料が参考となる。

> 1\) 日本災害情報学会：東日本大震災における調査ガイドライン，2011.
>
> 2\) 内閣府，災害ケースマネジメントに関する取組事例集（令和４年３月）.

1.  []{#_Toc130808323 .anchor}対象とする区域等に応じた災害調査

    1.  []{#_Toc130808324
        .anchor}河川区域及びその周辺を対象にした災害調査

        1.  []{#_Toc130808325 .anchor}目的の設定

＜考え方＞

+----------------------------------------------------------------------+
| 河川区域及びその周辺を対象とした災害調査は、（第10章 災害調査 1.2    |
| に示                                                                 |
| すように）明確化した目的を達成するため、河川管理施設を主対象とし、洪 |
| 水、地震等の異常な自然現象やそれがもたらす河道等の地形変化が原因とな |
| って、治水・利水などに関わる所定の機能が喪失又は一部不全に陥った、あ |
| るいはそれが懸念される変状・損傷の状況を把握するものである。許可工作 |
| 物についても、災害の程度と影響度、その災害を調査することで得られる技 |
| 術的知見のほか事例への活用度等を勘案して、必要に応じて対象に含める。 |
|                                                                      |
| なお、本                                                             |
| 川のバックウォーターの影響を受ける支川合流部、難侵食性の土層が露出し |
| た河床域、堤防の対侵食安全性に密接に関わる高水敷、洪水流や氾濫流の減 |
| 勢効果を有する堤防近傍の樹木群や高水敷、河道掘削・樹木伐採により河積 |
| を確保した河道、危機管理型ハード対策（粘り強い堤防）など、防災・減災 |
| に関わる有意な機能や影響が認められる地形・地被・地物等についても、そ |
| の重要性と変状・損傷の規模等に応じて、適宜、災害調査の対象に加える。 |
+----------------------------------------------------------------------+

2.  []{#_Toc130808326 .anchor}調査内容

＜推　奨＞

+----------------------------------------------------------------------+
| 河川区域及びその周辺を対象とした災                                   |
| 害調査は、変状・被災発生の把握後から調査内容と結果活用を段階的に充実 |
| させる方式とすることが望ましい。段階としては以下の３つが目安となる。 |
|                                                                      |
| なお、全ての災害について最終段階                                     |
| まで進める必要があるとは限らず、対象とする災害の内容や設定した目的に |
| 応じて、どの段階まで調査を進めるかを適切に判断することも重要である。 |
|                                                                      |
| １）初動・即応段階（おおむね1週間以内が目安）                        |
|                                                                      |
| 原則として現地調査を実施した上で、災害の状況を概括的に把握           |
| する。発生場所、施設等の名称と種類、範囲・延長など規模、被災形態、想 |
| 定される被災原因及び所見などについて調査を行い、写真・図等と合わせて |
| 整理する。併せて、被災前の現地の状況について情報を収集し把握する。こ |
| の段階の調査から得られた災害の程度・重要性などの情報を総合的に勘案し |
| 、災害調査全体の構成（次に示すどの段階までの調査を実施すべきかなどを |
| 含む）を確認する。なお、被災の痕跡調査等については、降雨や次の出水や |
| 、仮締切等の応急措置の前にできる限り速やかに実施することが望ましい。 |
|                                                                      |
| ２）原因究明・現象解析段階                                           |
|                                                                      |
| > ａ）情報整理段階（おおむね                                         |
| ３か月以内が目安：災害の規模、災害復旧等の緊急性に応じて適切に設定） |
| >                                                                    |
| > 下記項目について整理し、出水時の外力、                             |
| 河道特性、被災形態などから推定される被災の機構とプロセスについて整理 |
| する。地震動による災害を対象にする場合、震動に関する情報を把握する。 |
| >                                                                    |
| > ①被災時の雨量、水位、流量、雨量確率規模など気象・水文・水理情報    |
| >                                                                    |
| > ②被災場所の                                                        |
| 河床縦断形状、横断形状、平面形状、河道構成材料の粒度分布など河道特性 |
| >                                                                    |
| > ③調査                                                              |
| 対象の被災前の構造諸元、点検・補修履歴など管理状況に関する基礎的情報 |
| >                                                                    |
| > ④調査対象の被災後の形状や隣接する周辺河道地形の測量、河床材料など  |
| 土質分析、調査対象を構成する材料強度、目視観察等による変状の調査結果 |
| >                                                                    |
| > ⑤流                                                                |
| 出土砂や流木の発生特性を規定する流域の地質・植生等についての調査結果 |
|                                                                      |
| ＜参考となる資料＞                                                   |
|                                                                      |
| 各々の段階における気象・水文・水理情報については下記が参考となる。   |
|                                                                      |
| 1\) 水文水質データベース（速報値），国土交通省.                      |
|                                                                      |
| 2\) 川の防災情報，国土交通省.                                        |
|                                                                      |
| 3\) 防災情報，気象庁.                                                |
|                                                                      |
| なお、堤防の被災後調査については、第15章 土質地質調査 第2節          |
| 河川堤防の土質地質調査 を参照すること。                              |
|                                                                      |
| > ｂ）詳細分析段階（１～２年以内が目安：災害の規模、                 |
| 災害復旧等の緊急性、技術的な重要性、分析の難易度に応じて適切に設定） |
| >                                                                    |
| > 上記ｂ）の段階で推定した被災の機構とプロセスにつ                   |
| いて、流れ、土砂移動、地形変化、地震動、構造物の応答・変形・破壊に関 |
| する解析を用いた検証などを通じて、定量的・具体的な説明を得るべく検討 |
| する。この解析は、被災の直接的な原因となった外力や地形変化の評価を行 |
| い、それに対する調査対象の許容変形度、抵抗力、耐力等の比較を定量的に |
| 行うことが基本となる。なお、調査量の制約や投入できる技術水準の限界な |
| どの理由によって客観的手法により十分な検討が行えない場合であっても、 |
| 今後の技術改善につなげていくための課題をできるだけ具体的に抽出する。 |
|                                                                      |
| ３）技術基準等や技術政策への反映段階                                 |
|                                                                      |
| 以上の検討から得                                                     |
| られる知見に基づいて、施設や河道等の設計やこれらの管理技術の改善、見 |
| 直しなど技術政策への反映の方法を検討するとともに、更に検討すべき技術 |
| 課題を整理する。ただし、この段階の検討は、必要に応じ、上記２）と並行 |
| して行い、結果の活用も最終取りまとめ後だけでなく逐次的に行っていく。 |
+----------------------------------------------------------------------+

2.  []{#_Toc130808327 .anchor}河川氾濫域等を対象にした災害調査

    1.  []{#_Toc130808328 .anchor}目的の設定

＜考え方＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  河川氾濫域を対象とした災害調査では、浸水現象（浸水範囲、浸水深、氾濫流速、これらの時間変化等）及び浸水と人的被害、直接被害、間接被害の関係を把握し、浸水解析の精度向上、治水経済調査・水害リスク評価手法の高度化、危機管理対策の高度化に資する情報・知見を得ることが有力な目的候補となり、目的設定において、このことを考慮する。なお、調査の時期・方法については、被災者・被災地への配慮や復旧活動への影響を十分考慮して適切に設定する。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

2.  []{#_Toc130808329 .anchor}調査内容

＜推　奨＞

+----------------------------------------------------------------------+
| 災害調査は、対象とする災害の内                                       |
| 容や設定した目的を踏まえつつ、以下７項目について、河川氾濫に伴う災害 |
| に関する様々な角度からの調査をバランス良く組み立てることが望ましい。 |
|                                                                      |
| １）浸水現象の把握                                                   |
|                                                                      |
| あらかじめ浸水範囲の全体をおおまかに把握した上で、                   |
| 適切に調査ポイントを設定し、痕跡（水位やその履歴、付着物）や住民への |
| 聞き取り、水位計・浸水検知センサや河川監視カメラ等から、浸水深、流速 |
| 、時刻等を把握する。調査結果は、地図上に整理し、必要に応じて再現計算 |
| 結果等とも併せて浸水の時空間的な広がりを可能な範囲で詳細に把握する。 |
|                                                                      |
| ２）人的被害                                                         |
|                                                                      |
| 自治体等への聞き取り調査等か                                         |
| ら、人的被害の発生場所、時刻、発生状況等及び自治体で行った防災情報の |
| 把握・意思決定・提供等の危機管理対応の状況を把握するとともに、必要に |
| 応じて現場調査や関係者への聞き取り調査を実施する。また、アンケート調 |
| 査等により住民の避難行動（避難した理由・しなかった理由、避難情報取得 |
| の方法、避難の時期・手段等）について把握する。これらを浸水現象と併せ |
| て時系列に整理することにより、人的被害の発生要因や教訓等を整理する。 |
|                                                                      |
| ３）直接被害                                                         |
|                                                                      |
| 家屋・建物・事業所や道路、交通・電力・水道等インフラ                 |
| 施設について被災状況を把握し、浸水状況と被害状況の関連性を整理する。 |
|                                                                      |
| ４）間接被害                                                         |
|                                                                      |
| インフラ施設を含む                                                   |
| 被災地の復旧までの期間とその間の市民生活、産業活動、社会活動への影響 |
| を、当該氾濫域以外の波及被害を含めて定量的・定性的に把握・整理する。 |
|                                                                      |
| ５）避難状況                                                         |
|                                                                      |
| 避難指示等の発出状況、避難人数、避難率等の実際の避難状               |
| 況、避難経路、避難場所の配置など避難に関係する情報を把握・整理する。 |
|                                                                      |
| ６）河川管理施設の運用状況                                           |
|                                                                      |
| 氾濫発生時における排水ポンプの運転状況（燃料補                       |
| 給状況、アクセス路等を含む)、水門・樋門の開閉状況を把握・整理する。  |
|                                                                      |
| ７）ハード・ソフト施策との関連に関する分析                           |
|                                                                      |
| 洪水により被災し                                                     |
| た場合、治水施設等のハード対策による効果とともに、業務や地域の継続計 |
| 画、ハザードマップ、地域防災計画等に基づく取組であるソフト対策による |
| 効果を確認し、それぞれの特徴や目的を踏まえ、これらを組み合わせた対策 |
| を検討することも効果的である。具体的には、これまで行ってきたハード・ |
| ソフト対策の状況と、上記１）～６）に示す被害状況等を比較することによ |
| り、ハード・ソフト対策の効果を分析し、課題の整理や対策の検討を行う。 |
+----------------------------------------------------------------------+

3.  []{#_Toc130808330 .anchor}砂防域及び急傾斜地等を対象にした災害調査

    1.  []{#_Toc130808331 .anchor}目的の設定

＜考え方＞

+----------------------------------------------------------------------+
| 土砂災害を対象とする災害調査では、災害に至る土砂移動現象を把握し、災 |
| 害の再発及び拡大防止と復旧事業を安全に進めるための知見・情報を得るこ |
| と、また、長期的には土砂災害に関する新しい知見を得ることにより、より |
| 高度な対策手法を検討するための資料とすることが有力な目的候補となる。 |
|                                                                      |
| 特に、                                                               |
| 多くの場合、初動・即応段階から原因究明・現象解析段階にかけての調査に |
| おいて、次の事柄を適切なタイミングで実施・提供することが重要となる。 |
|                                                                      |
| ・土砂災                                                             |
| 害の危険度(再発及び上下流・側方等への拡大による再度災害の可能性)判断 |
|                                                                      |
| ・土砂災害の再発防止に向けた応急対策方法に関する検討                 |
|                                                                      |
| ・予防・恒久対策に向けた適切な災害発生の機構解析                     |
|                                                                      |
| 災害調査の                                                           |
| 結果は、住民の警戒避難、施設管理者の応急復旧などに反映させることが必 |
| 要であるので、調査結果につき、土砂災害防止法に基づく緊急情報等の形式 |
| により自治体、施設管理者に早期・確実に情報提供することが必要である。 |
|                                                                      |
| 目的設定においては、以上のことを考慮する。                           |
+----------------------------------------------------------------------+

2.  []{#_Toc130808332 .anchor}調査内容

＜推　奨＞

+----------------------------------------------------------------------+
| 調                                                                   |
| 査は、対象とする災害の内容や設定した目的を踏まえつつ、現状の危険度判 |
| 定のための初動・即応段階、対策計画の検討のための原因究明・現象解析段 |
| 階それぞれで行うべき以下の調査内容を踏まえて実施することを推奨する。 |
|                                                                      |
| 両者は独立したもの                                                   |
| ではなく相互に強く関係し重複する内容が多く含まれていることを理解し、 |
| 両段階の調査を可能な範囲で並行して連携させつつ進めることが望ましい。 |
|                                                                      |
| また、続行                                                           |
| する調査で資料を追加、補強しやすい方式で調査を進めることに留意する。 |
|                                                                      |
| １）初動・即応段階の調査                                             |
|                                                                      |
| > ａ）災害概要の                                                     |
| 把握：被災状況、災害発生時刻、災害範囲、保全対象、被害拡大の可能性等 |
| >                                                                    |
| > ｂ）広域調査：地形、地質、災害分布等                               |
| >                                                                    |
| > ｃ）現地調査：災害規模、発生要因、土砂移動現象等                   |
|                                                                      |
| ２）対策計画検討のための原因究明・現象解析段階の調査                 |
|                                                                      |
| ａ）誘因・素因の調査                                                 |
|                                                                      |
| ｂ）機構解析・プロセス                                               |
|                                                                      |
| ｃ）法指定等の確認                                                   |
|                                                                      |
| なお、調査の細部に関しては第17章 砂防調査 から第20章 雪崩調査        |
| によるものとする。                                                   |
+----------------------------------------------------------------------+

4.  []{#_Toc130808333 .anchor}海岸及び海岸低地を対象にした災害調査

＜標　準＞

  --------------------------------------------------------------------------------------------------------------
  海岸及び海岸低地を対象とする災害調査については、第21章 海岸調査 第12節 海岸災害調査 によることを標準とする。
  --------------------------------------------------------------------------------------------------------------

2.  []{#_Toc130808334 .anchor}災害調査成果の蓄積と共有化

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------
  災害調査の成果は、適切な形で蓄積し、河川等の計画、設計及び維持管理等のための技術情報として共有化できるようにすることを標準とする。
  ------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

  -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  ３次元データを取得する場合は、効率的かつ高精度な活用を見据えて、技術情報の蓄積と共有化を目的にBIM/CIMを活用することが有効である。その際、設計、施工、維持管理・更新の各段階の成果を一体的に蓄積し、共有化を図り活用することが望ましい。
  -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜参考となる資料＞

災害調査成果の蓄積と共有化については、下記の資料が参考となる。

> 1)「美しい山河を守る災害復旧基本方針」【ガイドライン】の改定について，平成30年6月26日，国水防第50号，国土交通省水管理・国土保全局防災課長通知.

2)BIM/CIM活用ガイドライン（案），令和3年3月 国土交通省.

> （最新版）BIM/CIM活用ガイドライン（案），令和4年3月国土交通省.

第11章　河川環境調査 {#第11章-河川環境調査 .TOC-Heading}
====================

目　次 {#目-次-8 .TOC-Heading}
======

[第1節 総説 1](#_Toc295989250)

> [1．1 総論 1](#_Toc295989251)
>
> [1．2 河川環境調査の目的 1](#_Toc295989252)
>
> [1．3 調査計画立案における留意点 2](#_Toc295989253)
>
> [1．4 河川環境の要素 5](#_Toc295989254)
>
> [1．5 生物関連調査の基本 10](#_Toc295989255)

[第2節 河川における環境調査の手法 11](#_Toc295989256)

> [2．1 概要 11](#_Toc161927725)
>
> [2．2 環境要素別の調査方法 11](#_Toc161927726)
>
> [2．3 調査項目と河川環境把握のための工夫 12](#_Toc161927727)

[第3節 河川流量調査 13](#_Toc161927728)

> [3．1 概要 13](#_Toc161927729)
>
> [3．2 正常流量の検討 14](#_Toc161927730)

[第4節 河道形状調査 15](#_Toc161927731)

> [4．1 概要 15](#_Toc161927732)
>
> [4．2 水域調査 15](#_Toc161927733)

[第5節 河道構成材料調査 16](#_Toc161927734)

[第6節 河川水質調査 16](#_Toc161927735)

[第7節 植物調査 16](#_Toc161927736)

> [7．1 植物相調査の概要 17](#_Toc161927737)
>
> [7．2 植物相調査の事前調査 19](#_Toc325457451)
>
> [7．3 植物相調査の現地調査計画の策定 19](#_Toc161927739)
>
> [7．4 植物相調査の現地調査 19](#_Toc161927740)
>
> [7．5 植物相調査の調査結果取りまとめ 19](#_Toc161927741)
>
> [7．6 植物相調査の考察・評価 20](#_Toc161927742)
>
> [7．7 植生調査の概要 20](#_Toc161927743)
>
> [7．8 植生調査の事前調査 22](#_Toc161927744)
>
> [7．9 植生調査の現地調査計画の策定 22](#_Toc161927745)
>
> [7．10 植生調査の現地調査 22](#_Toc161927746)
>
> [7．11 植生調査の調査結果の整理 26](#_Toc161927747)
>
> [7．12 植生調査結果の考察・評価 26](#_Toc161927748)

[第8節 付着藻類調査 26](#_Toc161927749)

> [8．1 付着藻類の概要 26](#_Toc161927750)
>
> [8．2 付着藻類調査地点 27](#_Toc161927751)
>
> [8．3 付着藻類調査の実施時期 27](#_Toc161927752)
>
> [8．4 調査方法 28](#_Toc161927753)
>
> [8．4．1 試料の採取 28](#_Toc161927754)
>
> [8．4．2 試料の固定 30](#_Toc325457469)
>
> [8．5 室内分析 30](#_Toc161927756)
>
> [8．5．1 試料の調整 30](#_Toc161927757)
>
> [8．5．2 同定・計数 30](#_Toc161927758)
>
> [8．6 その他の調査方法 30](#_Toc161927759)

[第9節 魚類調査 31](#_Toc161927760)

> [9．1 概要 31](#_Toc161927761)
>
> [9．2 事前調査 33](#_Toc295989266)
>
> [9．3 現地調査計画の策定 33](#_Toc295989267)
>
> [9．4 現地調査 33](#_Toc295989268)
>
> [9．5 調査結果取りまとめ 35](#_Toc295989269)
>
> [9．6 考察・評価 35](#_Toc295989270)

[第10節 底生動物調査 35](#_Toc295989271)

> [10．1 概要 35](#_Toc295989272)
>
> [10．2 事前調査 36](#_Toc295989273)
>
> [10．3 現地調査計画の策定 37](#_Toc295989274)
>
> [10．4 現地調査 37](#_Toc295989275)
>
> [10．5 調査結果取りまとめ 40](#_Toc295989276)
>
> [10．6 考察・評価 41](#_Toc295989277)

[第11節 鳥類調査 41](#_Toc295989285)

> [11．1 概要 41](#_Toc295989286)
>
> [11．2 事前調査 42](#_Toc295989287)
>
> [11．3 現地調査計画の策定 43](#_Toc295989288)
>
> [11．4 現地調査 46](#_Toc295989289)
>
> [11．5 調査結果取りまとめ 48](#_Toc161927779)
>
> [11．6 考察・評価 48](#_Toc161927780)

[第12節 両生類・爬虫類・哺乳類調査 49](#_Toc161927781)

> [12．1 概要 49](#_Toc161927782)
>
> [12．2 事前調査 50](#_Toc325457498)
>
> [12．3 現地調査計画の策定 51](#_Toc161927784)
>
> [12．4 現地調査 51](#_Toc161927785)
>
> [12．5 調査結果取りまとめ 53](#_Toc161927786)
>
> [12．6 考察・評価 53](#_Toc161927787)

[第13節 陸上昆虫類等調査 53](#_Toc161927788)

> [13．1 概要 53](#_Toc161927789)
>
> [13．2 事前調査 54](#_Toc161927790)
>
> [13．3 現地調査計画の策定 55](#_Toc161927791)
>
> [13．4 現地調査 55](#_Toc161927792)
>
> [13．5 調査結果取りまとめ 56](#_Toc161927793)
>
> [13．6 考察・評価 56](#_Toc161927794)

[第14節 河川空間利用実態調査 56](#_Toc303870840)

> [14．1 概要 56](#_Toc161927796)
>
> [14．2 河川空間利用者数調査 56](#_Toc161927797)
>
> [14．3 「川の通信簿」調査 58](#_Toc318291077)

[第15節 河川景観調査 58](#_Toc161927799)

[第16節 河川環境の総合的な分析 59](#_Toc161927800)

> [16．1 環境調査結果を取りまとめる際の視点 59](#_Toc161927801)
>
> [16．2 「河川環境管理シート」等を利用した環境調査結果の取りまとめ
> 60](#_Toc161927802)
>
> [16．3 河川環境調査結果から作成される主な資料 60](#_Toc161927803)
>
> [16．4 河川環境資料の活用法について 69](#_Toc325457520)
>
> [16．5 河川環境資料の使用上の注意について 70](#_Toc161927805)

[第17節 新しい技術の利用 71](#_Toc161927806)

> [17．1 総論 71](#_Toc325457523)
>
> [17．2 安定同位体比計測 71](#_Toc161927808)
>
> [17．3 遺伝子解析 72](#_Toc295989326)
>
> [17．4 環境DNA分析 73](#_Toc161927810)
>
> [17．5 バイオロギング 73](#_Toc161927811)
>
> [17．6 生息適地モデル 74](#_Toc161927812)

[第18節 環境影響評価 74](#_Toc161927813)

> [18．1 概要 74](#_Toc161927814)
>
> [18．2 環境影響評価法に定める対象事業 75](#_Toc161927815)
>
> [18．3 ダム事業 75](#_Toc161927816)
>
> [18．4 堰事業 75](#_Toc295989331)
>
> [18．5 湖沼開発事業 76](#_Toc161927818)
>
> [18．6 放水路事業 76](#_Toc161927819)

[第19節 戦略的環境アセスメント 77](#_Toc161927820)

令和6年3月　版

適用上の位置付け

　河川砂防技術基準調査編は、基準の適用上の位置付けを明確にするために、下表に示すように適用上の位置付けを分類している。

+--------+------------------+------------------+------------------+
| 分　類 | 適用上の位置付け | 末尾の字句例     |                  |
+--------+------------------+------------------+------------------+
| 考え方 | 技術資料         | ●目              | 「･･･ある。      |
|        |                  | 的や概念、考え方 | 」「･･･いる。」  |
|        |                  | を記述した事項。 |                  |
|        |                  |                  | 「･･･なる。      |
|        |                  |                  | 」「･･･れる。」  |
+--------+------------------+------------------+------------------+
| 必　須 | 技術基準         | ●法令による規定  | 「･･･なければ    |
|        |                  | や技術的観点から | ならない。」「･  |
|        |                  | 実施すべきである | ･･ものとする。」 |
|        |                  | ことが明確であり |                  |
|        |                  | 遵守すべき事項。 |                  |
+--------+------------------+------------------+------------------+
| 標　準 | 技術基準         | ●特              | 「･･･            |
|        |                  | 段の事情がない限 | を標準とする。」 |
|        |                  | り記述に従い実施 |                  |
|        |                  | すべきだが、状況 | 「･･･            |
|        |                  | や条件によって一 | を基本とする。」 |
|        |                  | 律に適用すること |                  |
|        |                  | はできない事項。 | 「･･･による。」  |
+--------+------------------+------------------+------------------+
| 推　奨 | 技術資料         | ●状況や条件      | 「               |
|        |                  | によって実施する | ･･･望ましい。」  |
|        |                  | ことが良い事項。 |                  |
|        |                  |                  | 「               |
|        |                  |                  | ･･･推奨する。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･努める。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･必要に応    |
|        |                  |                  | じて･･･する。」  |
+--------+------------------+------------------+------------------+
| 例　示 | 技術資料         | ●適用条件や実施  | 「               |
|        |                  | 効果について確定 | ･･･などの手法（  |
|        |                  | している段階では | 事例）がある。」 |
|        |                  | ないが、状況や条 |                  |
|        |                  | 件によっては導入 | 「･･･など        |
|        |                  | することが可能な | の場合がある。」 |
|        |                  | 新技術等の例示。 |                  |
|        |                  |                  | 「･･･など        |
|        |                  | ●状              | が考えられる。」 |
|        |                  | 況や条件によって |                  |
|        |                  | 限定的に実施でき | 「               |
|        |                  | る技術等の例示。 | ･･･の場合には･･･ |
|        |                  |                  | ことができる。」 |
|        |                  | ●具体的          |                  |
|        |                  | に例示することに | 「               |
|        |                  | より、技術的な理 | ･･･例示する。」  |
|        |                  | 解を助ける事項。 |                  |
|        |                  |                  | 「例えば･･･。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･事例もある  |
|        |                  |                  | 。･･･もよい。」  |
+--------+------------------+------------------+------------------+

  関連通知等       関連する通知やそれを理解する上で参考となる資料
  ---------------- ------------------------------------------------------
  参考となる資料   例示等に示した手法・内容を理解する上で参考となる資料

11. 河川環境調査

    1.  []{#_Toc295989250 .anchor}総説

        1.  []{#_Toc295989251 .anchor}総論

＜考え方＞

+----------------------------------------------------------------------+
| 本章は、河川環境調査を実施するために必要な技                         |
| 術的事項を定めるものである。ただし、河川環境という概念により包括され |
| る調査対象範囲は極めて広範囲であり各河川固有の多様な環境が存在する。 |
|                                                                      |
| そこで本章では、共通する技術的事項として、河川環境                   |
| 調査の目的(1.2)について最初に言及した後、調査計画立案における留意点( |
| 1.3)、河川環境の要素(1.4)、生物関連調査の基本（1.5）、調査対象に応じ |
| た調査手法及び取りまとめ方（第2～15節）について整理し、河川環境の総  |
| 合的な分析から河川整備の計画段階から管理までの各局面での活用方法につ |
| いて（第16節）記載する。調査にあたっては、各河川の環境の特性に応じて |
| 調査を実施することとし、必要に応じて追加の調査を実施するものとする。 |
+----------------------------------------------------------------------+

2.  []{#_Toc295989252 .anchor}河川環境調査の目的

＜考え方＞

+----------------------------------------------------------------------+
| 平成9年の                                                            |
| 河川法改正により、治水・利水に加えて「河川環境の整備と保全」が河川管 |
| 理の目的の一つに加えられた。「河川環境の整備と保全に関する基本的事項 |
| は、動植物の良好な生息・生育・繁殖環境の保全・創出、良好な景観の保全 |
| ・創出、人と河川との豊かなふれあい活動の場の保全・創出、良好な水質の |
| 保全について総合的に考慮して定める」ものであり、河川環境調査は、これ |
| らの項目について河川環境の実態を把握することを目的として実施されるも |
| のである（ただし、「良好な水質の保全」に関する調査については、第12章 |
| 水質・底質調査 に記載する）。                                        |
|                                                                      |
| 河川は、水域と陸域が接する場であるとともに、流量や地形の             |
| 変動が大きく、攪乱の激しい環境である。また、現代においては、土地の高 |
| 度利用の進展に伴い、流域の湿地環境が減少する中、河川区域に湿地環境が |
| 残っており、その限られた空間に貴重な生息・生育・繁殖環境が維持されて |
| いる場合が多い。河川改修や災害復旧を含め、調査、計画、設計、施工、維 |
| 持管理等の河川管理におけるすべての行為において、こうした環境を保全す |
| るとともに、より良い環境を創出する必要がある。また、河川全体の自然の |
| 営みを視野に入れた多自然川づくりに取り組むとともに、流域へと視点を広 |
| げ、流域の農地や緑地等における取組と連携することにより、河川やこれと |
| 連続性を有する水域を基軸とした生態系ネットワークの形成を進めることが |
| 重要である。河川環境調査は、このような河川の特徴を踏まえて実施する。 |
|                                                                      |
| 河川環境調査は、１）河川整備計画等の策定、２                         |
| ）改修事業等の河川環境への影響あるいは効果の把握、３）自然再生計画の |
| 作成及び自然再生事業の評価、４）河川維持管理、５）河川環境の評価のた |
| めの系統立ったデータの蓄積、６）大規模出水による影響把握等を行うに当 |
| たって、河川環境の観点から必要な情報を得るために実施するものである。 |
|                                                                      |
| 河川環境調査は上記                                                   |
| １）～６）の場面において、具体的には以下のように活用される。         |
|                                                                      |
| 1.  河川整備計画等の策定                                             |
|                                                                      |
| 河                                                                   |
| 川整備基本方針や河川整備計画を策定するに当たり、河川環境調査を適切に |
| 実施することにより、流域の環境を把握し、河川環境の保全と創出を図る。 |
|                                                                      |
| 58. 改修事業等の河川環境への影響あるいは効果の把握                   |
|                                                                      |
| 改修事業は、規模等によって「通常の事業」、                           |
| 「大規模事業」、「環境影響評価対象事業」に大別される。環境影響評価対 |
| 象事業に関しては、省令に基づいた調査を行うが、それ以外の事業において |
| も、事業前後の環境調査を実施することで、人為的インパクトに対する環境 |
| 変化（レスポンス）を把握し、改修の影響の最小化及び改修による河川環境 |
| の改善効果を明らかにすることができる。事業においては、これらの結果を |
| 活用して順応的（アダプティブ）に河川環境を管理することが重要である。 |
|                                                                      |
| 59. 自然再生計画の作成及び自然再生事業の評価                         |
|                                                                      |
| 河川環境調査を適切に実施                                             |
| することにより、自然の復元力を活用するとともに、流域全体を視野に入れ |
| た自然再生計画の作成が可能となる。レキ河原の再生や干潟の再生等の自然 |
| 再生事業に伴う環境再生の効果を事前事後調査から評価することができる。 |
|                                                                      |
| 60. 河川維持管理                                                     |
|                                                                      |
| 河川環境                                                             |
| 調査を適切に実施することにより、維持管理における河川環境の整備と保全 |
| が可能となる。河川環境の維持管理対策については、維持管理編（河川編） |
| 第8章 河川環境の維持管理対策 によるものとする。                      |
|                                                                      |
| 61. 河川環境の評価のための系統立ったデータの蓄積                     |
|                                                                      |
| 調査項目や調査手法を統一することで、全国の河川間                     |
| でのデータ比較や同一の河川で過去と現在のデータを比較するなどといった |
| 河川環境変化の評価が可能となる。例えば気候変動による生物分布の変化や |
| 問題となっている外来種、移入種の拡大傾向等はこれらの情報から把握する |
| ことが可能となり、次の段階である対応・管理にとって貴重な情報となる。 |
| また、事業の構想段階から環境への影響を考慮しつつ事業計画を策定する戦 |
| 略的環境アセスメント（第19節）は既存の資料等を基に環境への影響を評価 |
| するため、これらの系統立って蓄積されたデータは重要な基礎資料となる。 |
|                                                                      |
| 62. 大規模出水による影響把握を目的とする場合                         |
|                                                                      |
| 大規模な出水が生じると、河川環境が激変する。                         |
| 河川環境の管理においては、大規模出水に伴う環境変化について理解するこ |
| とが重要であり、既往調査結果の整理を行うとともに、大規模出水が生じた |
| 際には、環境調査を実施することで、貴重な情報が得られる可能性が高い。 |
|                                                                      |
| 上記１）～６）を行う上で既存の調査結果や流域の関係者や学識経         |
| 験者等との議論を通じて、該当する河川環境の目指すべき方向性を明らかに |
| することが重要である。その上で、本章に記載されている調査や分析法を通 |
| じて河川環境の実態を把握し、その他の社会的制約条件を考慮した上で、関 |
| 係者の議論を通じて目標を設定して、事業等を実施することが重要である。 |
+----------------------------------------------------------------------+

[]{#_Toc295989253 .anchor}

1.  調査計画立案における留意点

＜推　奨＞

+----------------------------------------------------------------------+
| 河川環境の実態を把握するという河川環境調査の目的を満たす             |
| ためには、調査計画立案に際して、以下の項目に留意することが望ましい。 |
|                                                                      |
| 1.  環境要素間の関連性                                               |
|                                                                      |
| 調査計画の立案に当たっては、個                                       |
| 別環境要素調査のみを独自に設定するのではなく、総合的に河川環境を捉え |
| ることを目指した調査計画とすることが望ましい。個別環境要素調査（例え |
| ば生物調査）の実施に当たっては当該環境要素調査とその他の河川環境要素 |
| 調査（例えば水質調査）と同一あるいは近傍に調査地点を設けたり、調査時 |
| 期を調整したりすることで調査結果の関連性検討を可能とするよう努める。 |
|                                                                      |
| 63. 空間的関連付け                                                   |
|                                                                      |
| 河川環境調査結果について、                                           |
| 空間的情報を必ず記録するが、その際、地理空間情報システムでの利用を念 |
| 頭に置いて、調査場所の正確な情報を記録しておくことが重要である。また |
| 、調査地点の選定に当たっては、河川環境の物理的基盤となる情報（河川地 |
| 形、景観、植生など）の空間的配置に基づいて決定することが重要である。 |
|                                                                      |
| 64. 時間的関連付け                                                   |
|                                                                      |
| 現在実施している河川環境調査は、現状を把握する上で重要で             |
| あるだけではなく、将来の河川環境管理において比較対象となりうる重要な |
| 情報である。河川環境については、時間的変化を捉えることが重要であり、 |
| 将来における利用を念頭において長期的な調査計画を立案するよう努める。 |
|                                                                      |
| 河川環境は、出水による攪乱に伴う急進                                 |
| 的変化と平水時の漸進的変化を含め、常に変動するものとして特徴付けられ |
| るため、調査を実施した時点における河川環境を形成するまでの変動の履歴 |
| を考慮した調査を行うよう努める。例えば数十年に一度といった大出水が生 |
| じた後に調査を実施すれば、前後の調査結果と照らし合わせることで、出水 |
| に伴う急激な河川環境変化や、その後の変化過程を把握することができる。 |
|                                                                      |
| 既往情報（例えば過去                                                 |
| の航空写真など）から得られる、あるいは推定される河川環境情報と現在の |
| 河川環境調査結果を比較することで、河川環境変化の傾向を読み取ることが |
| できる。この傾向を知ることで、河川環境管理に活かすことが可能となる。 |
|                                                                      |
| ![](media/image283.jpeg){width="5.781102362204725in"                 |
| height="2.5748807961504814in"}                                       |
|                                                                      |
| 1.  航空写真を用いた歴史的変遷の整理事例                             |
|                                                                      |
| 出典：中村太士，辻本哲郎，天野邦彦監修 :                             |
| 川の環境目標を考える，p.66，技報堂出版，2008.                        |
|                                                                      |
| 65. 調査結果の管理への反映                                           |
|                                                                      |
| 河川環境調査については、個別の河川環境要素の調査結果を機械的に整理   |
| するだけでなく、各種調査間の調査結果を総合した整理や分析を行い河川環 |
| 境管理に反映することが重要である。調査結果の活用を念頭に置いた分析を |
| 行うことで、河川環境管理のために必要な情報が明確になると考えられる。 |
|                                                                      |
| このように河川環境管理のために必要な情報が明確になっ                 |
| てくれば、適切な情報を得るために必要な調査を再度計画するといったよう |
| に、管理に必要な情報を主眼とした調査計画を作成することが可能になる。 |
|                                                                      |
| このような過程をまとめると、「調査」→「結                            |
| 果の整理・分析」→「管理への反映」、そして再び管理に必要な「調査」と  |
| いった形で、継続的に調査を管理へ反映させるサイクルになる。このような |
| サイクルを明確に意識することで、調査結果の管理への反映が可能となる。 |
|                                                                      |
| 66. 調査計画の見直し                                                 |
|                                                                      |
| 時間的関連付けの部分で述                                             |
| べたように、環境変化を把握するために行う継続的な調査は重要であるが、 |
| 調査を管理に反映するために、必要に応じて調査計画を見直すよう努める。 |
|                                                                      |
| 67. 調査結果の整理                                                   |
|                                                                      |
| 調査結果については、系統的に整理してデータベースとしてストックす     |
| るが、この際に、データを解析することを念頭において、統一した電子デー |
| タ様式で保管するよう努める（様式については後述の各節を参照のこと）。 |
|                                                                      |
| 定期調査と事                                                         |
| 業アセスメント的な個別調査結果の一括管理（データベース化）ができるこ |
| とが重要である。このため、工事実施に伴う事業アセスメント等、個別随時 |
| 行われる環境調査の結果も、極力統一書式での保管を行うことが望ましい。 |
|                                                                      |
| 68. 利用目的に応じた調査                                             |
|                                                                      |
| 調査                                                                 |
| 結果の利用目的に応じて、用いるべき手法や注意すべきポイントは異なる。 |
|                                                                      |
| a.  河川整備計画等の策定                                             |
|                                                                      |
| > 計画段階においては、既存の資料                                     |
| やデータを幅広く収集するよう努める。特に、河川水辺の国勢調査等、定期 |
| 的かつ広域な既存データを活用し、調査することが重要である。また、計画 |
| 内容の必要性に応じて、より詳細な調査を追加で実施することが望ましい。 |
|                                                                      |
| b.  改修事業の河川環境への影響あるいは効果の把握                     |
|                                                                      |
| ```{=html}                                                           |
| <!-- -->                                                             |
| ```                                                                  |
| 1.  ①「通常の事業」                                                  |
|                                                                      |
| > 計画段階においては、河川水辺の国勢調査等、                         |
| 既存のデータを活用し影響を調査するが、実施段階においては、必要に応じ |
| て、事業箇所に関する調査を事前及び事後に実施するよう努める（本節1.5  |
| > 生物関連調査の基本 参照）。                                        |
|                                                                      |
| 2.  ②「大規模事業」及び「環境影響評価対象事業」                      |
|                                                                      |
| > 事業実施箇所及びその周辺において、保全                             |
| 対象となる重要種を把握できる調査を実施するが、調査区域の中でも重要な |
| 種が確認される可能性の高い重要な箇所については、十分な調査を実施する |
| よう努める。なお、環境影響評価法に定める対象事業の場合には、法で定め |
| られた環境影響評価を実施するために必要な調査を行わなければならない。 |
| >                                                                    |
| > また、いずれの事業規模においても、改修事業実施後の影               |
| 響を把握するための「事前及び事後調査」が行われることがある。前述の『 |
| 河川の評価のための系統立ったデータの蓄積を目的とする場合』（本節1.2  |
| > 河川環境調査の目的，P.2）と同様、標準化された調                    |
| 査手法で系統立ったデータの蓄積ができれば、個別の当該事業のみならず同 |
| 種事業全体の評価に対しても有益なデータとなる。代表例としては、「ダム |
| 等管理のフォローアップ制度」に基づくフォローアップ調査が挙げられる。 |
|                                                                      |
| 3.  ③「河川環境の改善効果を把握する場合」                            |
|                                                                      |
| > 改修事業後のインパクトレスポンスを想定した調査を                   |
| 実施するよう努める。計画段階においては、既存のデータ等（必要に応じて |
| 現地調査を実施）を活用し、現在の生物存在状況を物理環境との関連性が評 |
| 価できるように調査するが、改修事業後の河道状況を予測しどのような生物 |
| が存在しうるかを類推することが望ましい。また、実施段階においては、事 |
| 前及び事後に現地調査を行い、事業効果のモニタリングを行うよう努める。 |
|                                                                      |
| c.  河川維持管理                                                     |
|                                                                      |
| > 河川整備計画等                                                     |
| に定められた河川環境の目標が維持管理によりどの程度満たされているかを |
| 明らかにすることが望ましい。基本的には河川水辺の国勢調査などの定期的 |
| な調査で確認しつつ、必要に応じて更に詳細な検討を行うことが望ましい。 |
|                                                                      |
| d.                                                                   |
| 自然再生計画の作成及び自然再生事業の実施のための評価を目的とする場合 |
|                                                                      |
| ```{=html}                                                           |
| <!-- -->                                                             |
| ```                                                                  |
| 4.  ①「絶滅危惧種の保全」                                            |
|                                                                      |
| > 保全対象種及び保全対象種の生息に関連                               |
| の深い種の調査を実施することが望ましい。さらに、保全対象種の生息に関 |
| 連の深い生息場（餌場や産卵環境など）の調査を実施することが望ましい。 |
|                                                                      |
| 5.  ②「失われつつある場（干潟・湿地・レキ河原等）の再生」            |
|                                                                      |
| > 環境の指標種を設定し、指標種の数の推移の調査を実施することが望まし |
| い。また、生息場自体の再生状況の調査を同時に実施することが望ましい。 |
|                                                                      |
| e.  河川の評価のための系統立ったデータの蓄積を目的とする場合         |
|                                                                      |
| > 多くの箇所を比較できる手法で調査を定期的に実施することが望ましい。 |
| >                                                                    |
| > また、注意すべきポイントとして                                     |
| は、継続性が確保できる手法であること、標準化(一定の調査努力量等の規  |
| 格化)された手法であること、広範囲を行えるよう比較的安価な手法である  |
| ことが望ましい。代表例としては、「河川水辺の国勢調査」が挙げられる。 |
|                                                                      |
| f.  大規模出水による影響把握を目的とする場合                         |
|                                                                      |
| > 後述す                                                             |
| るように大規模な出水は河道内や河川敷の地形、生物や植物の生息に大きな |
| 影響を及ぼすため、その影響を把握するための調査を行うことが望ましい。 |
+----------------------------------------------------------------------+

1.  []{#_Toc295989254 .anchor}河川環境の要素

＜考え方＞

+----------------------------------------------------------------------+
| 河                                                                   |
| 川環境として考慮すべき要素は以下の項目を含む多くのものが考えられる。 |
|                                                                      |
| 1.  河川流量（高水、低水、変動特性）                                 |
|                                                                      |
| 河川流量（類                                                         |
| 似概念として水位）は、河川環境を規定する最も重要な要素の一つである。 |
|                                                                      |
| 高                                                                   |
| 水に関しては、発生頻度は低いが大規模な出水ほどより上位のスケールにお |
| ける川のかたちを変えうることが知られている。また、平均年最大流量がほ |
| ぼ低水路満杯流量に相当し河道形成に関する検討において代表値とされてい |
| るなど、河川流量は河川地形を形成する要因であるとみなすことができる。 |
|                                                                      |
| 低水の状況は、河畔植生や水生生物の生息場特性を規定                   |
| する上に、水温や水質に影響を与えることから、生態系への影響が大きい。 |
|                                                                      |
| このように河川流量は河川環境のあ                                     |
| らゆる特性を規定している。さらに、流量の変動特性（規模、頻度、持続時 |
| 間、タイミング等）は、出水後の物理環境（砂州の形成等）の安定化特性や |
| 攪乱に影響を与える。物理環境の安定度は、そこに生息する生物種を規定し |
| ている。一例として、河川環境においては、流量変動が小さくなると、環境 |
| が安定化しすぎて、その環境に強く適応した種のみが増加して、生物多様性 |
| が損なわれるという理論（中規模攪乱仮説）がある。実際、攪乱頻度や強度 |
| が減少して従来のレキ河原が減少するといった現象が全国的に顕在化してい |
| る。攪乱を表現するためには、流量だけでなく、河道形状との関係から評価 |
| される冠水頻度や冠水時の攪乱強度という指標で評価する必要があるが、流 |
| 量変動は、河川環境の要素として重要な攪乱を規定するものであり、攪乱の |
| 程度を表す指標としても重要である。河川流量調査手法については、第2章  |
| 水文・水理観測 によるものとする。                                    |
|                                                                      |
| 変動を含む河川流量特性（河川流                                       |
| 況）は、河川に生息する生物の生育・生息・繁殖状況を強く規定する。Bunn |
| and                                                                  |
| Arthington(2002)は、河川流況が河川                                   |
| における水生生物の多様性に影響する観点として、以下のような４つの原理 |
| を提示しており、流況の持つ環境上の意味合いを評価する際に参考になる。 |
|                                                                      |
| > 原理１：流れは河川の物理的な生物生息場を                           |
| 強く規定するもので、この作用により生物構成を規定する。物理的な生物生 |
| 息場のスケールは、流域スケール（河道網規模）、リーチスケール（瀬や淵 |
| の分布）、パッチスケール（個々の河床材料に対する水理条件）にわたる。 |
| >                                                                    |
| > 原理２：水生生物は                                                 |
| 主として自然の流況に直接反応する形で生活史戦略を進化させてきている。 |
| >                                                                    |
| > 原理３：水域の縦横断方向の連結性が自然なパターンによ               |
| り維持されることが、多くの河川に生息する種の生育にとって重要である。 |
| >                                                                    |
| > 原理４：流況の改変は、外来種や移入種の定着を促進させる。           |
|                                                                      |
| ![](media/image284.emf){width="5.395833333333333in"                  |
| height="3.6928007436570427in"}                                       |
|                                                                      |
| 2.  水生生物の多様性と河川の自然の流況                               |
|                                                                      |
| 出典: Bunn,S.E. and Arthington,A.H. : Basic Principles and           |
| Ecological Consequences of Altered Flow Regimes for Aquatic          |
| Biodiversity,*Environmental                                          |
| Management*,Vol.30,pp.492--507,2002.より訳出                         |
|                                                                      |
| 69. 川のかたち                                                       |
|                                                                      |
| 川                                                                   |
| のかたち（河川の形態）は、水深、流速、河床材料、冠水頻度といった河川 |
| に生育生息する生物にとって重要な河川の物理環境に大きな影響を与える要 |
| 素であり、河川環境を把握する上で重要な基盤的要素である。河川環境調査 |
| において川のかたちは、評価のしやすさという観点から、瀬や淵のようにひ |
| とまとめに把握しやすい単位で評価・把握するのが便利であるが、川のかた |
| ちを把握するに当たっては、その空間の階層性に留意することが大事である |
| 。これは、河川環境に図11-1-3に示す階層性が認められ、より大きなスケー |
| ルの階層の環境がその下のスケールの階層の環境を規定するとともに、下の |
| スケールの階層の環境の集まりが上のスケールの階層の環境を形成しており |
| 、その階層と川の空間構造の階層とを関連付けることが有用なためである。 |
|                                                                      |
| 川の空間構造の階層については、第4章 河道特性調査 第2節               |
| 河道特性調査に際しての基本的捉え方 2.1河道の階層構造と類型区分       |
| に述べるように、流域のスケール→セグメントのスケール→河川蛇           |
| 行の一区間程度のスケール（＝リーチスケール）→瀬淵のスケール（≒パッチ |
| スケール）というようにスケールを段階的に区分して考える。その際、河川 |
| 環境調査と河道特性調査による情報を有機的に結び付けていく上で、第4章  |
| 河道特性調査                                                         |
| の                                                                   |
| 表4-2-1に示す階層構造を考慮しつつ、階層の類型区分についても必要な共  |
| 通化を図り、蓄積する情報に一貫した方法で表記していくことが望ましい。 |
|                                                                      |
| 本章の第16節で後述する                                               |
| 河川環境情報図においても、全体図、広域図、区間図と３つの空間スケール |
| で河川環境を整理しているが、全体図は流域スケールからセグメントのスケ |
| ール、広域図はセグメントのスケールから蛇行一区間程度のスケール、区間 |
| 図は蛇行一区間程度のスケールから瀬淵のスケールで重要と考えられる河川 |
| 環境要素に分けて、それぞれのスケールでの保全や管理に役立てることを念 |
| 頭に置いたものとなっている。川のかたちに関する調査については、第4章  |
| 河道特性調査、第11章 河川環境調査 第4節                              |
| 河道形状調査によるものとする。                                       |
|                                                                      |
| 川のかたちは、河道が河川流量、特に高水の作用を受けて、土砂流送が生   |
| じることで変化し、植生による流砂の捕捉の影響も受けるものであり、この |
| ことは次項に示す河川環境の時間的変化の重要な要因となる。低水路幅や堤 |
| 防で規定される川幅など階層的に比較的上位の空間構造は、瀬淵のスケール |
| か、それより下位の地形変化の基本特性を規定することが多い。したがって |
| 、比較的上位の空間構造のスケール等を支配しうる治水等のための河道計画 |
| や総合的な土砂管理の取組が、河川環境を考える上でも重要な要素になる場 |
| 合がある。流砂系全体の総合的な土砂管理のための調査については、第16章 |
| 総合的な土砂管理のための調査によるものとする。                       |
|                                                                      |
| ![](media/image285.jpeg){width="5.551968503937008in"                 |
| height="3.0717968066491688in"}                                       |
|                                                                      |
| 3.  河川環境の階層的な捉え方                                         |
|                                                                      |
| 出典：中村太士，辻本哲郎，天野邦彦監修 :                             |
| 川の環境目標を考える，p.15，技報堂出版，2008.                        |
|                                                                      |
| 70. 時間的変化（出水による変化、動的平衡）                           |
|                                                                      |
| 現在目の                                                             |
| 前に存在する河川環境は、出水による攪乱に伴う変化、その後の回復過程と |
| いった自然要因による時間的変化や、河川改修等の人為的改変に伴う河川環 |
| 境の時間的変化が全て累積された結果である。したがって、河川環境を捉え |
| る上で時間的変遷は、重要な要素である。比較的短期間の変化を対象とする |
| 場合には、河川環境は常に変動しながらも全体としてみれば大きく変わらな |
| いという動的平衡の概念を意識しながら河川環境の評価を行う必要がある。 |
|                                                                      |
| 71. 河床材料・土砂流送                                               |
|                                                                      |
| 河                                                                   |
| 川により流送される土砂は、堆積と侵食過程を通じて川のかたちを決定する |
| 。この点において、土砂流送は河川環境を規定する要素と考えることができ |
| る。また、河床材料の特性（粒径分布、間隙等）は、水域においては、付着 |
| 藻類、底生動物、魚類の生息に強く影響するほか、陸域では植物の生育に強 |
| く影響している。さらに、出水等に伴う土砂の移動は、河川環境の攪乱に重 |
| 要な役割を果たしている。これらのほかにも、細粒土砂は、河川における栄 |
| 養塩類などの物質の運搬に深く関与している。上記のような観点から見て、 |
| 河床材料の状態や土砂流送の状況は、河川環境の中の重要な要素と言える。 |
|                                                                      |
| 72. 河川水質                                                         |
|                                                                      |
| 河川水質は、生物や生態系に影響するとともに、人                       |
| の河川利用に大きな影響を及ぼす河川環境要素として捉えることができる。 |
| 河川水質は、流域との関わりが大きく、流域における自然環境のみでなく、 |
| 人間活動を反映したものであることが多い。高度成長期には、社会構造の変 |
| 化が著しく、特に都市部における河川水質が大きく悪化したが、当時問題と |
| なった有機汚濁による水質問題は下水道整備等により相当改善されている。 |
|                                                                      |
| しかし、有害化学物質やマイクロプラスチック                           |
| 等新たな汚染形態への注目が高まっているほか、生活排水や農業由来の栄養 |
| 塩類濃度の上昇等の問題が依然として残っている一方、例えば、瀬戸内海で |
| は、生物の多様性及び生産性の確保のために、栄養塩類の管理が求められて |
| いることなども踏まえ、地域の状況に応じた適正な水質管理が必要である。 |
|                                                                      |
| 河川に生息する生物から水質を見た場合、水温が生物に与える影響が特     |
| に大きいほか、溶存酸素濃度やアンモニア態窒素濃度は河川における生物生 |
| 息に直接影響する重要な項目と言える。河川水質の調査については、第12章 |
| 水質・底質調査 によるものとする。                                    |
|                                                                      |
| 73. 連続性                                                           |
|                                                                      |
| 河川は、流域を貫く連続した水域であり、生物の生息域として見た場合、縦 |
| 断的連続性の確保が重要であるとともに、横断的連続性が確保されているこ |
| とが重要である。縦横断的連続性は、河川に生息・繁殖する多くの魚類等が |
| 生活史を全うするために必要である。このため、河川横断構造物に魚道等の |
| 施設を設置することで、魚類等の移動経路（縦断方向連続性）の確保や、出 |
| 水時等に、河道から周辺の湿地などに移動するために必要な横断的連続性を |
| 確保するために護岸形状、樋門構造等への配慮を実施することが望まれる。 |
|                                                                      |
| また、河床下における浸透流が存在する層は、英語でHyporheic            |
| zo                                                                   |
| neと呼ばれており、河川水と地下水との相互作用の場としての重要性が近年 |
| 注目されている。河床環境に影響する可能性があるため、河床環境に着目す |
| る際には、浸透流と河川流との垂直的連続性にも留意することが望まれる。 |
|                                                                      |
| 74. 生物                                                             |
|                                                                      |
| 河川に生息・生育・繁殖する動植物は、時間変動を含ん                   |
| だ河川の流量、形状、水質の状況やこれらの空間的分布といった河川環境の |
| 影響を包括的に受けながら、それに適応した結果として分布しているため、 |
| その河川の環境を示す直接的かつ総合的な指標と言える。ただし、生物は生 |
| 息・繁殖に適した環境（場所）で必ず見つかるわけではなく、逆にあまり適 |
| していない環境（場所）で見つかることもある。また、多くの個体が生息・ |
| 繁殖する環境が隣接していれば、たとえ不適な場所でも見つかることがある |
| が、この場合、適した環境が失われれば、不適な場所での存続は難しい。生 |
| 物は、種として評価されるほか、ひとかたまりの群集として評価される場合 |
| もある。一言で生物といっても、河川との関わり方は多様であり、評価の方 |
| 法は様々である。水域に生育生息する生物と河川周辺の陸域に生育生息する |
| 生物とでは、河川管理方法による影響発現の機構には大きな違いがあると考 |
| えられる。また動物と植物による違いも大きい。生物調査については、本章 |
| 第7節 植物調査～第13節 陸上昆虫類等調査 によるものとする。           |
|                                                                      |
| 75. 生態系                                                           |
|                                                                      |
| 生態系は、そこに生息す                                               |
| る生物群集と、それを支える非生物的要素から成っている。生物群集の視点 |
| から生態系の構造・機能を捉える上では、生物種の多様性、生態遷移、食物 |
| 連鎖等にみられる生物間の相互作用が着目される。河川においては、食物連 |
| 鎖の下位に位置する付着藻類、植物、底生動物等の生物と上位に位置する魚 |
| 類、鳥類等の生物は食う・食われるの関係を通じて相互に影響しあっている |
| 。多様な環境が存在することで、多様な生物の生息が可能となるため、本来 |
| ある環境の集合（環境区分）を保全することが重要になる。生態系の中での |
| 生物と環境との様々な相互作用をまとめて、生態系の働きとして捉えること |
| ができ、これを生態系機能と呼ぶ。この生態系機能のうち、人間がその恩恵 |
| を受けているものを生態系サービスと言い、気候の調整や水資源の供給、土 |
| 壌侵食の制御、食糧供給など様々な機能がある。河川水辺の国勢調査で環境 |
| 区分として分類する環境は、広義の景観ともいうべきものであり、一般的に |
| は多様な景観を保全することで、良好な生態系が維持されると考えられる。 |
|                                                                      |
| 生態系を捉える視点として、典型性や上位性、特殊性とい                 |
| う概念があり、環境影響評価においても、これらの概念が導入されている。 |
|                                                                      |
| 典型性とは、地域の生態系の特徴を典型的に現す種、生物群集及           |
| びその生息・生育・繁殖環境によって表現する。個別河川の生態系保全を考 |
| える上では、絶滅危惧種等特別な種の保全のみではなく当該河川の典型的な |
| 種や、これらにより構成される典型的な生態系の保全を目指す必要がある。 |
|                                                                      |
| 上位性とは、一連の生態系を構                                         |
| 成する生物種間の被食捕食関係（食物連鎖）を見た場合に、食物連鎖の頂点 |
| に立つ性質を示している。このため、猛禽類や、大型哺乳類が上位性を表す |
| 種となる場合が多い。上位性を有する種が持続的に生息しうる環境は、健全 |
| 性も高いと考えられるため、上位性種の生息環境を評価して、食物連鎖から |
| 見た生態系構造を推定し、生態系全体の保全に役立てることが考えられる。 |
|                                                                      |
| 特殊性とは、典型性では把握しにくい特殊な                             |
| 環境を指標する種、生物群集及び生息・生育・繁殖環境によって表現する。 |
|                                                                      |
| 河川環境の保全に際し                                                 |
| ては、河川に生育・生息・繁殖する生物を生態系という視点で捉えて、生態 |
| 系全体としての保全を行うという考え方が必要である。河川やこれと連続性 |
| を有する水域を基軸とした生態系ネットワークの形成を進めるためには、他 |
| 機関と連携しつつ河川周辺の既存の調査結果も活用する。食物連鎖の評価の |
| ためには、魚類の胃内容物調査や、生物や有機物の安定同位体比解析(本章  |
| 17節 新しい技術の利用                                                |
| 17.2節参照)等の評価                                                  |
| 手法が開発されているので、新しい技術の導入も積極的に行うべきである。 |
|                                                                      |
| 76. 景観                                                             |
|                                                                      |
| 景観は、                                                             |
| 見た目という狭義の意味で使用される場合と、周囲と区別できる特定のひと |
| かたまりの領域という視点で捉えられる生態系を要素とした全体のシステム |
| を指して景観と呼ぶ場合があり、種々の異なる概念を内包する言葉である。 |
|                                                                      |
| 多くの場合                                                           |
| は、前者の意味を指していると考えられるが、生態学の一分野として、景観 |
| 生態学があり、この分野では後者の意味で景観という言葉を使用している。 |
|                                                                      |
| いずれの意味で用いられるにしても、人間の利用                         |
| という観点からも重要な要素であると言える。景観調査については、第15節 |
| 河川景観調査 によるものとする。                                      |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  多自然川づくり基本方針，平成18年10月，国土交通省河川局.

> （最新版）多自然川づくり基本方針，令和6年6月，国土交通省水管理・国土保全局.

＜参考となる資料＞

下記の資料が参考となる。

1.  Bunn,S.E. and Arthington,A.H. : Basic Principles and Ecological
    Consequences of Altered Flow Regimes for Aquatic
    Biodiversity,*Environmental Management*,Vol.30,pp.492--507,2002.

```{=html}
<!-- -->
```
257. 中村太士，辻本哲郎，天野邦彦監修 :
     川の環境目標を考える，技報堂出版，2008.

河川を基軸とした生態系ネットワーク形成に関しては、下記の資料が参考となる。

258. 川からはじまる川から広がる魅力ある地域づくり～河川を基軸とした生態系ネットワークの形成～，令和5年3月，国土交通省水管理・国土保全局河川環境課.

259. 河川を基軸とした生態系ネットワーク形成のための手引き（河川管理者向け）（案），令和2年2月，国土交通省水管理・国土保全局河川環境課.

260. 河川事業における生態系保全に関する評価の手引き（実務者向け）（案）～生態系ネットワーク形成に向けて～，令和3年6月，国土交通省水管理・国土保全局河川環境課.

     生態系で記載した安定同位体解析に詳細な説明については、下記の資料が参考となる。

261. 永田俊，宮島利宏 :
     流域環境評価と安定同位体-水循環から生態系まで，京都大学学術出版会，2008.

     1.  []{#_Toc295989255 .anchor}生物関連調査の基本

＜考え方＞

+----------------------------------------------------------------------+
| 本章は、河川環境調査全般について記述するものであるが、中心となるの   |
| は生物関連調査である。生物関連調査は、調査対象河川に生息する動植物相 |
| を調べる生物相調査、生物群集の構成を調べる群集・群落調査、さらに、食 |
| 物連鎖を含む物質やエネルギーの流れを対象とする生態系調査等がある。ま |
| た、生物の生息場所の特性を調べる生息場調査（ハビタット調査）がある。 |
|                                                                      |
| 河川にお                                                             |
| ける生物関連調査には、現状把握のための定期調査（河川水辺の国勢調査等 |
| ）、河川改修等環境改変を実施する際に影響評価を行うための調査がある。 |
|                                                                      |
| 各種の生物関連調査に共通する要                                       |
| 件として、生物種の確認位置を正確に記録することが挙げられる。また、生 |
| 物種の記録にとどまらず、生息場特性を同時に記録することが重要である。 |
|                                                                      |
| さらに、河川改修との関連を把握することを目的とする場合には、イ       |
| ンパクトレスポンスフロー（人為影響が生物生息にどのような過程に従って |
| 影響するかを想定した概念図）に基づいた調査を行うことが重要である。改 |
| 修の影響を把握するための調査においては、改修を行った場所における事前 |
| 事後調査のみでなく、類似の環境を有する場所において同一の事前事後調査 |
| を行うことで、改修による影響を抽出するという調査計画を立てることが重 |
| 要である（BACIデザイン；Before-After-Control-Impactの略であり、改修  |
| 時期の前後、改修の有無という４つの組合せに相当する調査を実施すること |
| 。改修による影響を、その他の影響を除いた上で評価することができる。さ |
| らに、目標とする場所や値などが、あらかじめ定まっているような場合には |
| BACI デザインに Reference                                            |
| を加えたBARCIデザイン;Before-After-Reference-Control-                |
|                                                                      |
| Impactが参考になる。）                                               |
|                                                                      |
| ![](media/image286.png){width="5.942719816272966in" height="2.0in"}  |
|                                                                      |
| 4.  BARCIデザイン                                                    |
|                                                                      |
| 出典：大河川における多自                                             |
| 然川づくり-Q&A形式で理解を深める-，平成31年3月，令和5年3月一部改訂， |
|                                                                      |
| 国土交通省水管理・国土保全局河川環境課，p.9-1-2.                     |
+----------------------------------------------------------------------+

1.  []{#_Toc295989256 .anchor}河川における環境調査の手法

    1.  []{#_Toc161927725 .anchor}概要

＜考え方＞

+----------------------------------------------------------------------+
| 本節においては、河川環                                               |
| 境調査の概要について記述するとともに、種々の河川環境要素に関する調査 |
| 手法について記述された第3節以降の利用方法の概略についても記述する。  |
|                                                                      |
| 河川環境調査は、調査計画立案における留意点(1.3)に記述した留意点      |
| に着目し、目的に応じた調査計画を立案し、これに沿って調査を実行する。 |
|                                                                      |
| 例えば「河川環境の評価のための系統立っ                               |
| たデータの蓄積」を目的とした、河川水辺の国勢調査を実施するのであれば |
| 、河川水辺の国勢調査の手法にのっとって調査を実施することになり、既に |
| 整理された方法で計画立案が可能となると考えられる。しかし、「改修事業 |
| 等による河川環境の改善」や「改修事業等により人為的インパクトを与える |
| 場合の影響の最小化」を図ることが目的であれば、想定される改修が生じせ |
| しめる当該河川における環境要素の直接的改変（インパクト）に応じた種々 |
| の環境要素の変化（レスポンス）を予測するために必要となる諸調査を行い |
| 、評価に備える必要があるため、個別の計画立案による対応が必要になる。 |
|                                                                      |
| このように個別の計画立案による対応が必                               |
| 要となるような目的に応じた調査を行う場合には、環境要素間の関係を評価 |
| するための工夫を行う。上述のように、調査計画立案における留意点(1.3)  |
| に記述した留意点に着目して計画立案した後、調査を行うことになるが、個 |
| 別の計画立案による河川環境調査は、計画段階における当該河川環境につい |
| ての知見の程度により精度が異なることにも留意する。河川環境調査は、当 |
| 該河川の環境に関する知見を積み重ねていく過程の重要な部分であり、現状 |
| の知見と、河川管理に必要な知見との差を縮めるものでなければならない。 |
+----------------------------------------------------------------------+

2.  []{#_Toc161927726 .anchor}環境要素別の調査方法

＜考え方＞

+----------------------------------------------------------------------+
| 河川における環境調査のうち、河川流量や河道形状調査                   |
| 等物理的側面を調査する手法についてはそれぞれ関連する章を参照するが、 |
| 河川環境を把握する視点から考慮すべき事項を第3節から第6節に記載する。 |
|                                                                      |
| また、生                                                             |
| 物調査については、河川における生物調査の標準的な手法として広く用いら |
| れている「河川水辺の国勢調査マニュアル」に記載されている内容を中心に |
| 、一般的で共通的な事項を抽出し、その概要を第7節から第13節に示した。  |
|                                                                      |
| 河川水辺の国勢調査は、河川環境の評                                   |
| 価のための系統立ったデータの蓄積を目的とするものであるが、現地調査に |
| 至るまでの手順や、具体的な現地調査方法、また調査結果の整理方法は、他 |
| の目的を有する生物調査においても参考になる。特に調査結果の整理方法は |
| 、統一的な書式でのデータ整理を行うためにも踏襲することが重要である。 |
|                                                                      |
| 河川水辺の国勢調査以外                                               |
| の生物調査においては、ここに記載した調査事項を適宜選択することで、目 |
| 的に合った調査を計画立案するほか、必要に応じて、調査の目的や対象を考 |
| 慮して適切な調査マニュアル等を参照するとともに、調査の目的や要求され |
| る調査精度等を勘案し、調査内容の拡充を図るなど、適宜柔軟に対応する。 |
+----------------------------------------------------------------------+

3.  []{#_Toc161927727 .anchor}調査項目と河川環境把握のための工夫

＜考え方＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------
  直接的な目的がどのようなものであっても、河川環境を把握するためには、種々の河川環境要素の組合せが必要になる。このためには、調査の計画立案時点において工夫を行う。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜例　示＞

+----------------------------------------------------------------------+
| 高水敷                                                               |
| を切り下げる河道改修を実施することを計画する際に、改修後の河畔植生が |
| どのような分布状況になるか事前に評価することで、環境を保全・創出する |
| 断面の設計に役立てることが可能である。このような例を考えた場合、まず |
| は現状の植生分布がどのような環境要因により規定されているかを知る必要 |
| がある。植生の規定要因としては、光、水、栄養、土壌（基盤）が挙げられ |
| るが、河畔植生に関しては、これらのほかに洪水による攪乱が挙げられる。 |
|                                                                      |
| 高水敷の切り下げによる植生への影響                                   |
| を考える際には、高水敷切り下げというインパクトがかかることで大きく変 |
| 化すると考えられる植生の規定要因について検討する。大きく変化すると考 |
| えられる規定要因としては、攪乱が挙げられるため、計画する複数案ごとに |
| 、案に沿った断面における攪乱の影響変化を評価する。このためには、現状 |
| 断面における攪乱の程度の分布と植生分布との関連を理解する必要がある。 |
|                                                                      |
| このための作業とし                                                   |
| て、現状の植生分布状況について植生図を作成することで整理するとともに |
| 、河道形状と流況（水位変化）を整理することで、比高と冠水頻度の分布が |
| 把握できる。これらの情報が空間的に重ね合わせることができれば、植生の |
| 分布と冠水頻度との関係が評価できる。関連性がないという結果が得られる |
| 植生もありうるが、比高と植生との間には下図のように関係があることが知 |
| られているので、定量的な関係性が得られる可能性が高い。また、河川の形 |
| 状は洗掘や堆積によって変化するものであるため、掃流力の作用による土砂 |
| 移動と河川形状変化、それが植生消長に与える影響にも留意が必要である。 |
|                                                                      |
| ![中下流                                                             |
| 部(セグメント2-2)](media/image287.jpeg){width="5.445743657042869in"  |
| height="3.0104166666666665in"}                                       |
|                                                                      |
| 1.  中下流部における植生配分の例                                     |
|                                                                      |
| 出典：(財)リバーフロント整備センター :                               |
| 河川植生の基礎知識，p.7，2000.                                       |
|                                                                      |
| ![](media/image288.emf){width="6.09375in"                            |
| height="1.525262467191601in"}                                        |
|                                                                      |
| 図11-2-2　植生分布（比高）と流況（水位）・冠水頻度に関する整理事例   |
|                                                                      |
| 出典：河川事業の計画段階における環境影響の分析方法に関する検討委員会 |
| :                                                                    |
| 河川事                                                               |
| 業の計画段階における環境影響の分析方法の考え方，p.Ⅲ-64，2002.に加筆  |
|                                                                      |
| このような関係性が一度得られれば、改修案ごとに将来の植               |
| 生分布の予測が可能になる。これは一つの例示に過ぎないが、評価あるいは |
| 把握が必要な環境要素について、他の環境要素と関連させるとともに、空間 |
| 情報を正確に調査・整理し、地理空間情報システムを利用するなど電子情報 |
| 化することにより、より高度な河川環境把握、評価への利用が可能になる。 |
+----------------------------------------------------------------------+

1.  []{#_Toc161927728 .anchor}河川流量調査

    1.  []{#_Toc161927729 .anchor}概要

＜考え方＞

+----------------------------------------------------------------------+
| 流量データの取得の具体的な手法については第2章 水文・水理観測         |
| によるものとする。流量調査は、通常の河川管理にお                     |
| いて実施されているため、データは環境調査とは別に存在する場合が多いと |
| 考えられる。流量は、河川環境調査における基礎的情報である。流量だけで |
| は、環境情報とはなりにくいが、水位と冠水頻度や、洪水時の環境変化を評 |
| 価するために、過去からの河川流量変化を調べることが必要となる場合が多 |
| い。また流量の変化と河道内の流速や濁り等の河川水質の変化の関係を把握 |
| することで、流量を測定しておくと、比較的データが密に存在する流量デー |
| タから、流速変化や水質変化を推定評価することが可能な場合もある。この |
| ように、流量データは河川における多くの環境要素の変動を規定する要因で |
| あり、環境調査に当たっては、整理する優先順位が極めて高い指標である。 |
|                                                                      |
| ![](media/image289.emf){width="5.593748906386701in"                  |
| height="1.3020833333333333in"}                                       |
|                                                                      |
| ![](media/image290.emf){width="5.90625in"                            |
| height="1.6455227471566054in"}                                       |
|                                                                      |
| 2.  年最大流量と砂州や植生の変遷との比較例                           |
|                                                                      |
| 出典：河川事業の計画段階における環境影響の分析方法に関する検討委員会 |
| :                                                                    |
| 河川事業の計画段階における環境影響の分析方法の考え方，p.Ⅲ-63，2002.  |
|                                                                      |
| 関連して、水域の連続性や水質の維持、水温等の適正な                   |
| 維持にとって重要な要素である正常流量の検討については本節3.2による。  |
+----------------------------------------------------------------------+

1.  []{#_Toc161927730 .anchor}正常流量の検討

＜考え方＞

+----------------------------------------------------------------------+
| 正常流量（                                                           |
| 流水の正常な機能を維持するために必要な流量）とは、動植物の保護、漁業 |
| 、景観、流水の清潔の保護などを考慮して定める維持流量及び流水の占用の |
| ために必要な水利流量から成る流量であり、低水管理上の目標として定める |
| 流量である。維持流量と水利流量は必ずしも分離可能なものではなく、例え |
| ば水利流量が維持流量の一部として機能する場合があることにも留意する。 |
|                                                                      |
| 正常流量の検討に際しては「正常流量の検討の手引                       |
| き（案）」を参照する。この手引きでは正常流量の検討に先立ち実施すべき |
| 調査項目として、流況、河川への流入・河川からの取水量、河道状況（地形 |
| ・物理データ、瀬淵、構造物等）、自然環境（水質、生物）、社会環境（観 |
| 光・景勝地、イベント・親水、産業、ほか）、既往渇水等を記載している。 |
|                                                                      |
| 「正常流量の検討の手引き(案)」においては、「動                       |
| 植物の生息地又は生育地の状況」のため渇水時に確保すべき最低限の必要流 |
| 量を設定するための一般的な手法が記載されているが、動植物はそれぞれ固 |
| 有の生活史を有しており、水量に加えて、その生活史（遡上や産卵等）に応 |
| じた適切な流量変動が重要であり、そのような観点から必要な調査計画を立 |
| てることが重要である。また、流量変動や攪乱に配慮した正常流量の設定手 |
| 法については、これらの調査を通じてその確立に努めることが重要である。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  正常流量の検討の手引き（案），平成19年9月，国土交通省河川局河川環境課.

    1.  []{#_Toc161927731 .anchor}河道形状調査

        1.  []{#_Toc161927732 .anchor}概要

＜標　準＞

+----------------------------------------------------------------------+
| 河道形状調査は、調査対象とする河川環境要素に                         |
| 対応したスケールで実施する必要がある。利用可能な既往の横断測量結果が |
| あれば、これらを利用することも可能である。横断測量については、第4章  |
| 河道特性調査 及び第22章 測量・計測 によることを基本とする。          |
|                                                                      |
| 河道の形状に関し                                                     |
| ては、近年では三次元点群測量による詳細な面的形状データが入手できる場 |
| 合があり、植生分布と比高の関係を調べるために利用するなど、河川環境把 |
| 握への利用価値が高い。また水域については、本節4.2を参考に調査する。  |
|                                                                      |
| 河道形状を                                                           |
| 把握するための調査としては、このほか、河川水辺の国勢調査で行われる「 |
| 河川環境基図作成調査」があり、この中の「水域調査」では、河川の水域内 |
| の地理について調査する。「水域調査」については、本節4.2に記述する。  |
+----------------------------------------------------------------------+

2.  []{#_Toc161927733 .anchor}水域調査

＜標　準＞

+----------------------------------------------------------------------+
| 1.  調査目的                                                         |
|                                                                      |
| 本調査は、河川区域内                                                 |
| の水域部分の河道地形（瀬、淵、干潟など）を把握することを目的とする。 |
|                                                                      |
| 77. 調査内容                                                         |
|                                                                      |
| 調査区域内の水域における調査                                         |
| で、空中写真の判読や現地調査から、早瀬、淵、湛水域、ワンド・たまり、 |
| 干潟、湧水箇所、流入支川位置等水域の地理を把握することを標準とする。 |
|                                                                      |
| 78. 調査手法                                                         |
|                                                                      |
| 水域調査の                                                           |
| 実施に当たってはまず判断素図を作成し、現地を確認し、結果を記録する。 |
|                                                                      |
| m.  判読素図の作成                                                   |
|                                                                      |
| > 平面図や既往文献等を参考に、                                       |
| 早瀬・淵の分布、止水域の分布（湛水域、ワンド・たまり）、干潟の分布、 |
| 流入支川等の位置等を空中写真から読みとり、判読素図を作成する。なお、 |
| 止水域の原因が堰等の構造物である場合は、その情報についても記載する。 |
|                                                                      |
| ![](media/image291.emf){width="6.292361111111111in"                  |
| height="2.7305555555555556in"}                                       |
|                                                                      |
| 1.  早瀬・淵の判読例                                                 |
|                                                                      |
| 出典：平成28年度版河川水辺の国勢調査                                 |
| 基本調査マニュアル［河川版］Ⅷ河川環境基図作成調査編，                |
|                                                                      |
| 平成28年1月，国土交通省水管理・国土保全局河川環境課，p.Ⅷ-35.         |
|                                                                      |
| n.  現地調査                                                         |
|                                                                      |
| > 既往調査文                                                         |
| 献又は判読素図を基に現地調査を行い、必要に応じて判読素図を修正する。 |
|                                                                      |
| o.  調査結果の記録                                                   |
|                                                                      |
| > 空中写真の                                                         |
| 判読及び現地調査の結果を、地形図や平面化した空中写真に重ね合わせる。 |
| >                                                                    |
| > また、現地調査時に撮影した写真も合わせて整理する。                 |
| >                                                                    |
| > なお                                                               |
| 、河川水辺の国勢調査においては、これらの結果は、植生図作成調査、「構 |
| 造物の情報等」とともに「河川環境基図」に取りまとめる。「構造物の情報 |
| 等」については、構造物台帳、多自然川づくり追跡調査等を基に記載する。 |
+----------------------------------------------------------------------+

1.  []{#_Toc161927734 .anchor}河道構成材料調査

＜標　準＞

+----------------------------------------------------------------------+
| 河床や高水敷等を構成する材料の粒径分布等の調査に関しては、第4章      |
| 河道特性調査 第3節 各時点の河道状況                                  |
| 3.4表面・表層の状態に記載した手法                                    |
| によることを基本とする。                                             |
| 河川環境把握の側面からは、河床材料の粒径分布が、水中では魚類や底生動 |
| 物の生息場を規定する要因となっていることから、重要な調査項目である。 |
|                                                                      |
| 粒径分布については河道特性調査の既存結果を活用することがで           |
| き、また本調査の成果を河道特性調査においても活用するというように、相 |
| 互利用を図ることが大事である。その際、粒径分類・呼称については第4章  |
| 河道特性調査 第2節 河道特性調査に際しての基本的考え方                |
| 表4-2                                                                |
| -3のものを極力採用し、両調査で共通させることが有効である。また、1．4 |
| ４）に記されてい                                                     |
| るように河床材料の特性は付着藻類、底生動物、魚類等に強く影響を及ぼす |
| ため、粒径分布に加えて、河床材料の間隙等の把握にも努めるものとする。 |
+----------------------------------------------------------------------+

2.  []{#_Toc161927735 .anchor}河川水質調査

＜標　準＞

+----------------------------------------------------------------------+
| 河川水質に関しては、水質汚濁                                         |
| 防止法に基づく公共用水監視のための水質調査も含まれることから、第12章 |
| 水質・底質調査 によることを標準とする。                              |
|                                                                      |
| 河                                                                   |
| 川水質は、流域の環境状況、流況により規定されていると言える。このため |
| 、これらとの関係を把握しておく必要がある。また、水質変化は河川に生育 |
| ・生息する生物にとって重要な環境規定要因である。特に水温、濁度、溶存 |
| 酸素、アンモニア濃度等は、生物への影響が大きいと考えられる水質指標で |
| あり、河川環境調査の際には、これらの項目を整理することを基本とする。 |
+----------------------------------------------------------------------+

3.  []{#_Toc161927736 .anchor}植物調査

＜考え方＞

+----------------------------------------------------------------------+
| 植物調査には、植物の種を調べる「植物相調査」と、河川区域内の陸地部分 |
| の植物の育成状況（分布や群落の構成等）を調査する「植生調査」がある。 |
|                                                                      |
| 当節                                                                 |
| では7.1から7.6までに植物相調査、7.7以降で植生調査について記載する。  |
+----------------------------------------------------------------------+

1.  []{#_Toc161927737 .anchor}植物相調査の概要

＜標　準＞

+----------------------------------------------------------------------+
| 1.  調査目的                                                         |
|                                                                      |
| 本調査は、河川における植物種の生育状況を把握することを目的とする。   |
|                                                                      |
| 79. 調査対象                                                         |
|                                                                      |
| 本調査では、維管束植物(シダ植物及び種子植物)を調査対象とする。       |
|                                                                      |
| なお、逸出が確認された栽培種については                               |
| 調査対象とするが、明らかに植栽されたものについては調査対象としない。 |
|                                                                      |
| 80. 調査内容                                                         |
|                                                                      |
| 本調査では、                                                         |
| 現地調査を中心に文献調査、聞き取り調査も行う。現地調査は目視確認によ |
| り行うことを基本とし、必要に応じてサンプル採取による標本作製を行う。 |
|                                                                      |
| 81. 調査手順                                                         |
|                                                                      |
| 本調査における標準的な調査手順は以下のとおりであるが、               |
| 必要に応じ内容の拡充や一部簡略化など、適宜柔軟に対応すべきである。   |
|                                                                      |
| ![](media/image292.png){width="6.143135389326334in"                  |
| height="7.492537182852144in"}                                        |
|                                                                      |
| ※この手順は河川水                                                    |
| 辺の国勢調査における調査手順である。河川環境に関する情報の集約や有効 |
| 活用の観点から、河川水辺の国勢調査以外の河川環境調査においても河川水 |
| 辺の国勢調査で定められた現地調査様式、整理様式を使うことが望ましい。 |
|                                                                      |
| 1.  植物相調査の手順                                                 |
|                                                                      |
| 出典：平成28年度版河川水辺の国勢調査                                 |
| 基本調査マニュアル［河川版］Ⅳ植物調査編，                            |
|                                                                      |
| 平成28年1月，国土交通省水管理・国土保全局河川環境課，p.Ⅳ-2.          |
+----------------------------------------------------------------------+

[]{#_Toc325457451 .anchor}

1.  植物相調査の事前調査

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  事前調査では、文献調査及び聞き取り調査を実施することにより、当該水系における植物に関する諸情報を取りまとめることを標準とする。なお、文献、報告書等の収集及び聞き取り相手の選定に当たっては、必要に応じて学識経験者等の助言を得るようにすることを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

2.  []{#_Toc161927739 .anchor}植物相調査の現地調査計画の策定

＜標　準＞

+----------------------------------------------------------------------+
| 現地調査の実施に当たって適                                           |
| 切な調査結果が得られるように、全体調査計画書、既往の河川水辺の国勢調 |
| 査成果、事前調査の結果等を踏まえ、現地踏査、調査箇所の設定、年間の調 |
| 査時期及び回数の設定を行い、現地調査計画を策定することを標準とする。 |
|                                                                      |
| なお、現地調査計画の策定に                                           |
| 当たっては、必要に応じて、学識経験者等の助言を得ることを基本とする。 |
+----------------------------------------------------------------------+

3.  []{#_Toc161927740 .anchor}植物相調査の現地調査

＜標　準＞

+----------------------------------------------------------------------+
| 現地調査は、目視による確認を基本とし、各調査                         |
| 地区における植物の生育状況を把握できるように努めることを標準とする。 |
|                                                                      |
| 1.  調査方法                                                         |
|                                                                      |
| 調査地区内を歩きながら、生                                           |
| 育する種を目視(木本については必要に応じて双眼鏡を使う)により確認し、 |
| 和名を記録するとともに、調査ルートを河川環境基図等背景図に記録する。 |
|                                                                      |
| 重要種や特定                                                         |
| 外来生物が確認された場合には、確認された位置と生育状況等を記録する。 |
|                                                                      |
| 調査努力量は、1 調査地区当たり2 人で3～4                             |
| 時間とし、調査地区の規模や状況に応じて調整する。                     |
|                                                                      |
| 82. 調査結果の記録                                                   |
|                                                                      |
| 調査時の状況（調査日時、天候等）等の情報ととも                       |
| に、植物の確認状況について記録する。また、写真撮影による記録も行う。 |
|                                                                      |
| 83. 調査記録の整理                                                   |
|                                                                      |
| 調                                                                   |
| 査で採取した種を同定し、標本作製・保管、写真撮影などを行い整理する。 |
+----------------------------------------------------------------------+

1.  []{#_Toc161927741 .anchor}植物相調査の調査結果取りまとめ

＜必　須＞

  --------------------------------------------------------------------------------------------
  事前調査及び現地調査の結果について、確認種の確認状況、経年確認状況等を整理するものとする。
  --------------------------------------------------------------------------------------------

＜推　奨＞

  --------------------------------------------------------------------------------------
  取りまとめに際しては、河川水辺の国勢調査で定められた、整理様式を使うことが望ましい。
  --------------------------------------------------------------------------------------

＜関連通知等＞

1.  平成28年度版河川水辺の国勢調査
    基本調査マニュアル［河川版］Ⅳ植物調査編，平成28年1月，国土交通省水管理・国土保全局河川環境課.

    1.  []{#_Toc161927742 .anchor}植物相調査の考察・評価

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------
  調査で得られた結果について、考察及び評価を行うことを標準とする。なお、考察及び評価に当たっては、必要に応じて学識経験者等の助言を得ることを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------

2.  []{#_Toc161927743 .anchor}植生調査の概要

＜標　準＞

+----------------------------------------------------------------------+
| 1.  調査目的                                                         |
|                                                                      |
| この調査は、河川の植生分布を把握することを目的に、河川区域内の陸     |
| 地部分の植物の育成状況（分布や群落の構成など）を調査するものである。 |
|                                                                      |
| 84. 調査内容                                                         |
|                                                                      |
| 最新の空中写真を基に植生調査(植生図作成調査、群落組                  |
| 成調査、植生断面調査)を実施する。各調査の概要は以下のとおりである。  |
|                                                                      |
| -   植生図作成調査\                                                  |
|     　航空写真や現地調査により植物群                                 |
| 落の分布状況を把握し、その種類と範囲を『植生図』として取りまとめる。 |
|                                                                      |
| -   群落組成調査\                                                    |
|     　植生図作成調査の際、新たに確認された群落内                     |
| に一定の枠(コドラート)を設け、群落の階層構造、構成種などを把握する。 |
|                                                                      |
| -   植生断面調査\                                                    |
|     　植生断面調査は、調査対象地区の代表的な                         |
| 群落を含む水際(水中植物がある場合は水域を含む)から堤防表法肩までの横 |
| 断方向の踏査ルート付近の植生断面図をスケッチするなどにより作成する。 |
|                                                                      |
| 85. 調査手順                                                         |
|                                                                      |
| 本調査における標準的な調査手順は以下のとおりであるが、               |
| 必要に応じ内容の拡充や一部簡略化など、適宜柔軟に対応すべきである。   |
|                                                                      |
| ![](media/image293.png){width="6.024108705161855in"                  |
| height="8.011628390201224in"}                                        |
|                                                                      |
| ※この手順は河川水辺の国勢調査に                                      |
| おける調査手順である（このため、図中には植生調査と併せて行う水域調査 |
| 、構造物調査の手順も含まれている）。河川環境に関する情報の集約や有効 |
| 活用の観点から、河川水辺の国勢調査以外の河川環境調査においても河川水 |
| 辺の国勢調査で定められた現地調査様式、整理様式を使うことが望ましい。 |
|                                                                      |
| 2.  植生調査の手順                                                   |
|                                                                      |
| 出典：平成28年度版河川水辺の国勢調査                                 |
| 基本調査マニュアル［河川版］Ⅷ河川環境基図作成調査編，                |
|                                                                      |
| 平成28年1月，国土交通省水管理・国土保全局河川環境課，p.Ⅷ-2.          |
+----------------------------------------------------------------------+

1.  []{#_Toc161927744 .anchor}植生調査の事前調査

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  事前調査では、文献調査及び聞き取り調査を実施することにより、当該水系における植生の状況を中心とした諸情報を取りまとめることを標準とする。なお、文献、報告書等の収集及び聞き取り相手の選定に当たっては、必要に応じて学識経験者等の助言を得ることを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

2.  []{#_Toc161927745 .anchor}植生調査の現地調査計画の策定

＜標　準＞

+----------------------------------------------------------------------+
| 現地調査の実施に当たって適切な調査結果が                             |
| 得られるように、全体調査計画書、既往の河川水辺の国勢調査成果、事前調 |
| 査の結果等を踏まえ、現地踏査、調査箇所の設定、年間の調査時期・回数の |
| 設定、調査方法の選定を行い、現地調査計画を策定することを標準とする。 |
|                                                                      |
| なお、現地調査計画の策定に                                           |
| 当たっては、必要に応じて、学識経験者等の助言を得ることを基本とする。 |
|                                                                      |
| 1.  調査地区の設定                                                   |
|                                                                      |
| 植生調査                                                             |
| のうちの植生図作成調査は、原則として、調査区域の全域を調査地区とする |
| 。横断方向の調査範囲は、堤外地側の堤防表法肩より河川側とする。なお、 |
| 無堤区間・山付き区間では、河川区域内全体を調査範囲とする(「図11-7-3  |
| 植生図作成調査の調査範囲」参照)。                                    |
|                                                                      |
| > ![](media/image294.emf){width="4.754996719160105in"                |
| > height="1.9775273403324585in"}                                     |
|                                                                      |
| 3.  植生図作成調査の調査範囲                                         |
|                                                                      |
| 出典：平成28年度版河川水辺の国勢調査                                 |
| 基本調査マニュアル［河川版］Ⅷ河川環境基図作成調査編，                |
|                                                                      |
| 平成28年1月，国土交通省水管理・国土保全局河川環境課，p.Ⅷ-6.          |
|                                                                      |
| 植生調査の                                                           |
| うちの群落組成調査は、植生図作成調査の際に、当該河川で過去の調査で記 |
| 録されていない群落が確認された場合に、その群落を対象として実施する。 |
|                                                                      |
| 植