**基本計画編**

1.  **基本方針**

**目　次**

[第1節 総説 1](#_Toc101355039)

> [1．1 基準の目的 1](#_Toc96350355)
>
> [1．2 基本的考え方 1](#_Toc96350356)

[第2節 災害の防止・軽減 3](#_Toc101355873)

> [2．1 総説 3](#_Toc101355874)
>
> [2．2 水害対策 3](#_Toc96350359)
>
> [2．3 土砂災害等対策 5](#_Toc507421413)
>
> [2．4 地震災害対策 6](#_Toc96350361)

[第3節
河川等の適正な利用及び流水の正常な機能の維持並びに河川環境等の整備と保全
7](#_Toc102717433)

[第4節 総合的な土砂管理 8](#_Toc102717434)

[第5節 モニタリング 11](#_Toc101356241)

令和４年６月　版

適用上の位置付け

　河川砂防技術基準計画編は、基準の適用上の位置付けを明確にするために、下表に示すように適用上の位置付けを分類している。

+--------+------------------+------------------+------------------+
| 分　類 | 適用上の位置付け | 末尾の字句例     |                  |
+--------+------------------+------------------+------------------+
| 考え方 | 技術資料         | ●目              | 「･･･ある。      |
|        |                  | 的や概念、考え方 | 」「･･･いる。」  |
|        |                  | を記述した事項。 |                  |
|        |                  |                  | 「･･･なる。      |
|        |                  |                  | 」「･･･れる。」  |
+--------+------------------+------------------+------------------+
| 必　須 | 技術基準         | ●法令による規定  | 「･･･なければ    |
|        |                  | や技術的観点から | ならない。」「･  |
|        |                  | 実施すべきである | ･･ものとする。」 |
|        |                  | ことが明確であり |                  |
|        |                  | 遵守すべき事項。 |                  |
+--------+------------------+------------------+------------------+
| 標　準 | 技術基準         | ●特              | 「･･･            |
|        |                  | 段の事情がない限 | を標準とする。」 |
|        |                  | り記述に従い実施 |                  |
|        |                  | すべきだが、状況 | 「･･･            |
|        |                  | や条件によって一 | を基本とする。」 |
|        |                  | 律に適用すること |                  |
|        |                  | はできない事項。 | 「･･･による。」  |
+--------+------------------+------------------+------------------+
| 推　奨 | 技術資料         | ●状況や条件      | 「               |
|        |                  | によって実施する | ･･･望ましい。」  |
|        |                  | ことが良い事項。 |                  |
|        |                  |                  | 「               |
|        |                  |                  | ･･･推奨する。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･務める。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･必要に応    |
|        |                  |                  | じて･･･する。」  |
+--------+------------------+------------------+------------------+
| 例　示 | 技術資料         | ●適用条件や実施  | 「               |
|        |                  | 効果について確定 | ･･･などの手法（  |
|        |                  | している段階では | 事例）がある。」 |
|        |                  | ないが、状況や条 |                  |
|        |                  | 件によっては導入 | 「･･･など        |
|        |                  | することが可能な | の場合がある。」 |
|        |                  | 新技術等の例示。 |                  |
|        |                  |                  | 「･･･など        |
|        |                  | ●状              | が考えられる。」 |
|        |                  | 況や条件によって |                  |
|        |                  | 限定的に実施でき | 「               |
|        |                  | る技術等の例示。 | ･･･の場合には･･･ |
|        |                  |                  | ことができる。」 |
|        |                  | ●具体的          |                  |
|        |                  | に例示することに | 「               |
|        |                  | より、技術的な理 | ･･･例示する。」  |
|        |                  | 解を助ける事項。 |                  |
|        |                  |                  | 「例えば･･･。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･事例もある  |
|        |                  |                  | 。･･･もよい。」  |
+--------+------------------+------------------+------------------+

  関連通知等       関連する通知やそれを理解する上で参考となる資料
  ---------------- ------------------------------------------------------
  参考となる資料   例示等に示した手法・内容を理解する上で参考となる資料

1.  基本方針

    1.  []{#_Toc101355039 .anchor}総説

        1.  []{#_Toc96350355 .anchor}基準の目的

＜考え方＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  河川砂防技術基準計画編基本計画編は、災害の防止・軽減、河川等の適正な利用、流水の正常な機能の維持及び河川環境等の整備と保全にあたり、現状の技術水準に照らし合わせて基準となる技術的事項を示したものである。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

2.  []{#_Toc96350356 .anchor}基本的考え方

＜考え方＞

+----------------------------------------------------------------------+
| 本章は、災害の防止・軽減、河川等の適正な利用、流水の正常な機能の維持 |
| 及び河川環境等の整備と保全を行ううえでの基本方針を示したものである。 |
|                                                                      |
| 災害の防止・                                                         |
| 軽減の視点では、我が国は風水害や土砂災害の発生しやすい地理的・地形的 |
| 特性を有していることから、従来より防災インフラの整備が着実に進められ |
| てきた。一方、地球温暖化に伴う気候変動は、短時間強雨や大雨の頻度・強 |
| 度の増加、平均海面水位の上昇等をもたらし、水災害の激甚化・頻発化が懸 |
| 念され、近年の水災害の甚大な被害など、その影響は既に現れ始めている。 |
|                                                                      |
| このような状況を踏まえると、水災害から人命や社                       |
| 会、国土を守るためには、包摂性のあるリスクコミュニケーションにより水 |
| 災害に対する知見や情報を社会で共有し、あらゆる関係者の主体的な参画に |
| より国土の強靭性と地域の持続的な発展を確保していくことが重要である。 |
|                                                                      |
| 雨水が河川に流入する集水域、河                                       |
| 川等の管理者が管理する区域、河川等の氾濫により浸水が想定される氾濫域 |
| も含めて一つの流域として捉え、雨水、流水及び氾濫水、並びに土砂や高潮 |
| 等、災害を引き起こす外力の制御に加え、土地利用やまちづくり、住まい方 |
| の工夫、災害時の避難、経済被害軽減や災害後の復旧・復興等、水災害に備 |
| える社会の行動の強化を含む、総合的なマネジメントを目指す必要がある。 |
|                                                                      |
| さらに、水は、生命の源であり、絶えず地球上を循                       |
| 環し、大気、土壌等の他の環境の自然的構成要素と相互に作用しながら、人 |
| を含む多様な生態系に多大な恩恵を与えている。河川及びそれに連なる水路 |
| 等は、陸域における水循環の1つの過程を受け持つものであり、雨水等を集  |
| め海まで流下させるとともに、侵食作用による土砂の移動や、動植物の生息 |
| ・生育・繁殖環境の場の形成といった機能を有している。しかしながら、近 |
| 年は、生活の高度化や産業の進展により、水系の有する浄化機能を超える汚 |
| 濁物質等が河川に排出され、水質の悪化を招くとともに、農業用水の取水形 |
| 態の合理化や水路式発電による河川水のバイパス等による河川流量の減少、 |
| 減水区間の発生等により、川らしさの喪失や、河川環境の悪化を招いている |
| 。また、これまでの治水等の対策が河川等の自然環境に大きな影響を及ぼし |
| てきた場合もある。さらに、地下水の過剰取水による地盤沈下の進行による |
| 災害ポテンシャルの増大、都市域における水面の減少等、水循環の変化は、 |
| 地域によっては看過できない弊害を与えてきている。加えて、気候変動に伴 |
| う異常少雨の増加や積雪・融雪の減少など渇水リスクの増加も危惧される。 |
|                                                                      |
| これらのことを踏まえ、河川等の適正な利                               |
| 用、流水の正常な機能の維持及び河川環境等の整備と保全の視点では、水系 |
| が本来有する多様な機能を十分に生かした健全な水循環を維持又は回復させ |
| るため、流域としての総合的かつ一体的な管理のもと、河川の流量・水質の |
| 健全化や河川環境等の整備と保全及び、これらを織り込んだ河川整備等の施 |
| 策を推進することが重要である。また、河川だけでなく流域の水路網等の取 |
| 排水体系や地下水等も含め、流域の関係者が連携し、取り組むべきである。 |
|                                                                      |
| また、土砂管理につい                                                 |
| ては、河道等の安定、河川・砂防・海岸等の管理施設の機能確保、河川環境 |
| 等の保全等を図るために、水系のみならず海岸域も含めた領域を流砂系とし |
| て、量、質、時間の3つの観点で総合的な土砂管理を推進する必要がある。  |
|                                                                      |
| これらの、土地・水を適切に管理するための事業は、ライフサイクルを含   |
| む事業コストと、事業により得られる効果・影響、さらには周辺への影響（ |
| 外部経済等）も考慮して、長期的視点に立ち計画的に進め、併せて、気候変 |
| 動、社会情勢の変化、技術革新などにも柔軟に対応し取り組む必要がある。 |
|                                                                      |
| 水・土砂等管理に関わる計画の策定に当たっては、流域を                 |
| 含めた総合的な視点で検討を進め、水循環基本法の基本理念（同法第３条） |
| を踏まえつつ、河川整備基本方針・河川整備計画、砂防基本計画、地すべり |
| 防止計画並びに海岸保全計画など、水・土砂等管理を適正に進めるための諸 |
| 計画が、流域の視点に立ち、互いの整合性を確保し、これらの計画に基づく |
| 様々な施策が有機的に連携して実施することが重要である。（図１－１）。 |
|                                                                      |
| なお、水・土砂等の国                                                 |
| 土管理は、そこに住み、活動している国民がその課題と重要性を理解し、課 |
| 題の解決に向け主体的な取り組みを行うことによって、より大きな効果の発 |
| 現が見込まれる。このため、河川等の管理者と関係行政機関、住民、企業や |
| 諸団体とが水に関する情報を共有し、連携して取り組むことが重要である。 |
|                                                                      |
| また、各種計画の立案や見直しにあたっては、河川等の自然環境や流域の変 |
| 化等を監視するためのモニタリングを継続的に実施することが重要である。 |
|                                                                      |
| 1.  各計画の有機的な連携                                             |
+----------------------------------------------------------------------+

＜必　須＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  国土の保全と開発に寄与し、もって公共の安全を保持し、かつ、公共の福祉を増進することを目的として国土の管理を適切に行うため、災害の防止・軽減、河川等の適正な利用、流水の正常な機能の維持及び河川環境等の整備と保全の推進にあたっては、全国的バランス及び水系全体のバランスを踏まえ、河川整備基本方針・河川整備計画、砂防基本計画、地すべり防止計画及び海岸保全計画などの諸計画に基づき適切に実施しなければならない。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

6.  []{#_Toc101355873 .anchor}災害の防止・軽減

    1.  []{#_Toc101355874 .anchor}総説

＜考え方＞

+----------------------------------------------------------------------+
| 災害の防止・軽減については、その実現までに長期間を要すると           |
| ともに、対策の実施に合わせて順次効果が現れる場合だけではなく、一連の |
| 事業が完了して初めて効果が現れるものもある。加えて、今後、気候変動に |
| よる外力の増大も見込まれることから、絶えず長期的な視点に立ち、計画的 |
| に災害対策を推進することが、より効率的・効果的な災害対策につながる。 |
|                                                                      |
| 「水害対策」、「土砂災害等対策」に当たっては、現況における           |
| 河川等の施設の能力を適切に把握し、将来及び当面の計画の整備目標として |
| 設定した規模の外力に対して被害の発生を防止するため、河川管理者等によ |
| る治水等の対策を進める必要がある。さらに、現況施設の能力や整備目標と |
| して設定した規模を超える規模の外力が発生した場合にも、流域と一体とな |
| って、ハード・ソフト施策により被害を最小限に止めることが重要である。 |
|                                                                      |
| また、「地震災害                                                     |
| 対策」については、地振動や津波による河川管理施設等の直接的な被害に加 |
| え、電力の途絶など施設の機能不全等への対策を進めることが重要である。 |
+----------------------------------------------------------------------+

＜必　須＞

+----------------------------------------------------------------------+
| 災害対策は、脆弱な国土条件のもとで安全で安心                         |
| して暮らせる生活の確保、及び持続的な社会の発展、国土の有効利用及び環 |
| 境の保全を実現するため、長期的な視点で計画的に行わなければならない。 |
|                                                                      |
| 災害対策                                                             |
| に当たっては、整備目標として設定した規模の外力による災害の発生を防止 |
| するとともに、それを超える規模並びに現況の整備規模を超える外力が生じ |
| た場合においても、被害を最小限に止めることを考慮しなければならない。 |
+----------------------------------------------------------------------+

2.  []{#_Toc96350359 .anchor}水害対策

＜考え方＞

+----------------------------------------------------------------------+
| 水害対                                                               |
| 策においては、いかなる規模の洪水や高潮等に対しても被害を完全に防止す |
| ることは不可能である。したがって、様々な制約の下で整備目標として設定 |
| した規模の洪水や高潮等を防御の対象として計画立案することが必要となる |
| 。対策にあたっては、整備目標として設定した規模の外力に対し災害の発生 |
| を防止するための対策を進める必要がある。また、気候変動による将来の予 |
| 測として、短時間強雨や大雨の頻度・強度の増加、海面水位の上昇等が想定 |
| され、水害の激甚化・頻発化が懸念されていることを踏まえると、現況施設 |
| の能力や整備目標として設定した規模を超える外力によって発生する水害の |
| 被害は甚大なものになることが予想されるため、そのような場合であっても |
| 、できる限り被害を軽減するための対策が重要である。なお、河川では一般 |
| に上流よりも下流また、支川よりも本川の方が氾濫した場合の被害の規模が |
| 大きいことから、計画の策定や施設の整備に当たっては、流域全体を俯瞰し |
| 、上下流や本支川間のバランスなどを、適正に確保することが重要となる。 |
|                                                                      |
| 一方、洪水                                                           |
| に併せて土砂や流木が河道に大量に流入し被害を増長させることも考えられ |
| るため、流域や河道等の特性を踏まえ適切な対応を行うことが重要である。 |
+----------------------------------------------------------------------+

＜必　須＞

+----------------------------------------------------------------------+
| 水害とは、洪水や高                                                   |
| 潮等による氾濫により、人命や財産及び社会経済活動等が被る被害をいう。 |
|                                                                      |
| 水害対策に当たっては、整備目標として設定した規模の外力を対象として   |
| 水害を防止又は軽減することを基本とし、あわせて同規模並びに現況の整備 |
| 規模を超える外力が発生した場合においても被害をできるだけ少なくするよ |
| うにしなければならない。また、水害対策は、河川の特性や洪水の特性、水 |
| 害の形態、氾濫域の状況などを十分に考慮し、上下流・本支川間のバランス |
| など、流域全体として適切にバランスのとれたものにしなければならない。 |
+----------------------------------------------------------------------+

＜推　奨＞

+----------------------------------------------------------------------+
| 水害対策においては、河川管理者等は自らが主体となり行う対策           |
| に加え、流域のあらゆる関係者と協働して、流域の特性に応じた水害対策に |
| 取り組むことが重要である。この協働した水害対策を「流域治水」という。 |
|                                                                      |
| 水害対策は、流域全体を俯瞰し、河川の安全度や沿川の水災害リス         |
| クが適切にバランスのとれたものにすることが必要である。上流や支川の河 |
| 川整備等は、上流や支川で氾濫していた水を人為的に集めて下流や本川に導 |
| くことになることから、従来より、上流・下流、本川・支川の治水バランス |
| を確保しながら、流域全体として地域の安全度の向上に取り組んできた。こ |
| れに加え、集水域や氾濫域の土地利用の形態やその変化、地形特性や氾濫の |
| 特性等を把握し、広域的な視点での被害軽減対策を検討し実施することが求 |
| められている。今後の気候変動に伴う外力の増大に対応するため、流域の特 |
| 性も踏まえて、人命被害の発生を回避し、経済社会活動の中心となる地域の |
| 被災を可能な限り避けることや、水災害によって回復に長時間を要するよう |
| な深刻な被害にならないようにするなど、流域全体のリスク分担のあり方に |
| ついて流域の関係者で検討し、適切な役割分担のもと実施する必要がある。 |
|                                                                      |
| これらのことを踏ま                                                   |
| え、流域治水の対策としては、水災害リスクを把握し、以下に示す3要素（  |
| リスクの３要素）への対策を総合的かつ多層的に進めることが推奨される。 |
|                                                                      |
| １）氾濫をできるだけ防ぐ・減らすための対策                           |
|                                                                      |
| 氾濫を防ぐ堤防等の治                                                 |
| 水対策や、氾濫を減らすための流域での雨水貯留浸透施設等の整備等の対策 |
|                                                                      |
| ２）                                                                 |
| 被害対象を減少させるための対策及び減災のための氾濫形態を制御する対策 |
|                                                                      |
| 氾濫した                                                             |
| 場合を想定して、被害を回避するためのまちづくりや住まい方の工夫などの |
| 対策及び減災のための氾濫の形態を制御するための霞堤や二線堤などの対策 |
|                                                                      |
| ３）被害の軽減、早期復旧・復興のための対策                           |
|                                                                      |
| 氾濫                                                                 |
| の発生に際し、確実な避難や経済被害軽減、早期の復旧・復興のための対策 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  河川砂防技術基準
    調査編，平成26年4月，国土交通省水管理・国土保全局,第9章水害リスク評価.

2.  気候変動を踏まえた水災害対策のあり方について～あらゆる関係者が流域全体で行う持続可能な「流域治水」への転換～答申，令和2年7月，社会資本整備審議会.

＜例　示＞

+----------------------------------------------------------------------+
| 流域治水に関する現状で想定される具体の取組を、河川を例に例示する。   |
|                                                                      |
| １）氾濫をできるだけ防ぐ・減らすための対策                           |
|                                                                      |
| 　①河川区域内に                                                      |
| おいて、整備目標として設定した規模の洪水を安全に流下させるため、河川 |
| 管理者が自ら実施する対策（堤防整備、河道掘削、洪水調節施設整備　等） |
|                                                                      |
| 　②河川区域内において、整備目標として設定した規模（または現況能力）  |
| を超える洪水に対し、河川管理者が自ら実施する減災対策（堤防強化　等） |
|                                                                      |
| 　③河川区域内にお                                                    |
| いて、整備目標として設定した規模の洪水を安全に流下させるため、河川管 |
| 理者が流域の関係者と連携し実施する対策（既存利水ダムの有効活用　等） |
|                                                                      |
| 　④河川区域内において、整備目                                        |
| 標として設定した規模（または現況能力）を超える洪水に対し、河川管理者 |
| が流域の関係者と連携し実施する減災対策（水防活動、水防体制強化　等） |
|                                                                      |
| 　⑤集水域において、雨水の河川への流出を抑制するため                  |
| 、流域の関係者が主体となり、河川管理者と連携し実施する対策（雨水貯留 |
| 浸透施設整備、貯留機能を有する土地の保全、ため池・水田等の活用　等） |
|                                                                      |
| ２）                                                                 |
| 被害対象を減少させるための対策及び減災のための氾濫形態を制御する対策 |
|                                                                      |
| 　①氾濫域において、流                                                |
| 域の関係者が主体となり、河川管理者と連携し実施する被害対象を減少させ |
| る対策（安全な地域への居住誘導、防災まちづくり、住まい方の工夫　等） |
|                                                                      |
| 　②氾濫域において、流域の関係者と河川管理者が合意のもと              |
| 実施する氾濫形態を制御するための対策（霞堤、二線堤の保全・整備　等） |
|                                                                      |
| ３）被害の軽減、早期復旧・復興のための対策                           |
|                                                                      |
| 　①河川区域内において、河川管理者が行う河川情報等                    |
| の充実（水理・水文リアルタイム情報、洪水予警報、CCTVカメラ情報　等） |
|                                                                      |
| 　②氾濫域において、河川管理者と流域の関係者が                        |
| 連携して実施する被害軽減のための対策（河川防災ステーション、ハザード |
| マップ、水害対応タイムライン、防災教育、啓発活動、企業BCP計画　等）  |
|                                                                      |
| 　③氾濫域において、河川管理者と流域の関係者が連携して実施            |
| する早期復旧・復興のための対策（TEC-FORCE、広域浸水の排水計画　等）  |
|                                                                      |
| 上記については、                                                     |
| １）①～③については第２章に、それ以外については第５章に大別し記載する |
| こととするが、今後の流域治水の取組の進展を踏まえ変更する場合がある。 |
+----------------------------------------------------------------------+

1.  []{#_Toc507421413 .anchor}土砂災害等対策

＜考え方＞

+----------------------------------------------------------------------+
| 土砂の移動は、主に3つの形態によって行われる。                        |
|                                                                      |
| -   山腹やがけ地のような斜面において雨水や地下水の作                 |
| 用により崩壊や侵食や地すべりが行われる形態（崩壊・侵食、地すべり）。 |
|                                                                      |
| -   水と                                                             |
| 土砂の集合体が、急勾配の渓流を流下、堆積、氾濫する形態（集合運搬）。 |
|                                                                      |
| -   流水により河                                                     |
| 床、渓岸の土砂が侵食され、土砂が下流へと運搬される形態（各個運搬）。 |
|                                                                      |
| 土砂災害等は上記のいずれかの土砂移動形態をとることにより発生する。   |
|                                                                      |
| 崩壊、がけ崩れは、一般に勾配が                                       |
| 急な山腹・斜面において発生し、人家や耕作地等に直接的な被害を与える。 |
|                                                                      |
| また                                                                 |
| 、地すべり等の発生は降雨との関連が不明瞭な場合が多いため、特に、発生 |
| する可能性のある地域については地形、地質等を適切に把握する必要がある |
| 。また、これらのほかに土砂災害等には、積雪に起因する雪崩による災害、 |
| 流木による災害、火山噴火に起因する溶岩流や火砕流等による災害がある。 |
|                                                                      |
| 土砂災害等はその災害                                                 |
| 発生機構等が複雑であり、その対策の実現にも非常に長期間を要するもので |
| あり、対策を進める上では、計画規模の現象のみならず頻度の高い一定の規 |
| 模の土砂災害に対しても早期に効果が確保されるよう配慮する必要がある。 |
|                                                                      |
| なお、土砂災害等対策を実施するに当たっては、被害を最小               |
| 限に止めるよう、対策工事等のハード対策のみならず、警戒避難体制の整備 |
| 、土地利用規制などのソフト対策を適切に組み合わせ効果的に実施すること |
| が重要である。また、流域の特性等を踏まえ、必要に応じて、流域治水、気 |
| 候変動、流砂系の総合的な土砂管理についても考慮することが重要である。 |
+----------------------------------------------------------------------+

＜必　須＞

+----------------------------------------------------------------------+
| 土砂災害等とは、山腹や斜面の崩壊・侵食、土石流、地すべり等の         |
| 土砂等の移動現象によって、生命、財産及び公共施設等が被る災害をいう。 |
|                                                                      |
| 土砂災害等対策は、土砂等の移動現象とその災                           |
| 害発生機構等を踏まえ、施設整備によるハード対策と警戒避難体制の整備等 |
| によるソフト対策を適切に組み合わせ、効率的かつ効果的に実施するものと |
| する。その際、必要に応じて、流域治水、気候変動、海岸域も含めた流砂系 |
| 全体の土砂移動のバランスについても考慮するよう努めなければならない。 |
|                                                                      |
| また、土                                                             |
| 砂災害等対策を進める上で、計画規模の災害を防止するとともに、超過する |
| 規模の災害においても、被害を最小限に止めるよう努めなければならない。 |
+----------------------------------------------------------------------+

1.  []{#_Toc96350361 .anchor}地震災害対策

＜考え方＞

+----------------------------------------------------------------------+
| 地震災害対応は地震動に対する耐震性の確保と津波に対す                 |
| る防災・減災対策を講じるものとする。また、対象となる地域の特性、河川 |
| ・砂防・海岸の各施設の特性を踏まえ、各施設の耐震性を確保することが必 |
| 要であり、その設計手法等については「河川砂防技術基準設計編」で定める |
| こととする。なお、特に重要な施設についてはこれらを想定した施設の設計 |
| や地域における防災計画等の地域におけるソフト対策の実施が重要である。 |
|                                                                      |
| 地震動に対しては、以下に示す地震動を考慮し対策を講じるものとする。   |
|                                                                      |
| -   河川構                                                           |
| 造物の供用期間中に発生する確率が高い地震動（レベル１地震動）への対応 |
|                                                                      |
| -   対象地点において現在から将来に                                   |
| わたって考えられる最大級の強さを持つ地震動（レベル２地震動）への対応 |
|                                                                      |
| 津波に対しては、甚大な被害をもた                                     |
| らした平成23年東北地方太平洋沖地震を教訓に、今後の津波対策を構築する |
| にあたっては、基本的に二つのレベルの津波を想定し以下の点を考慮する。 |
|                                                                      |
| -                                                                    |
|   発生頻度は高く、津波高は低いものの大きな被害をもたらす津波への対応 |
|                                                                      |
| -   発                                                               |
| 生頻度は極めて低いものの、発生すれば甚大な被害をもたらす津波への対応 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  河川砂防技術基準 設計編，平成9 年3月，国土交通省河川局長通達.

    （最新版）河川砂防技術基準設計編, 令和7年6月,
    国土交通省水管理・国土保全局.

```{=html}
<!-- -->
```
3.  河川構造物の耐震性能照変指針について,平成24年2月,国土交通省治水課長．

4.  津波防災地域づくりに関する法律の施行に伴う関係法律の整備等に関する法律の施行について,平成24年3月,国土交通省水管理・国土保全局．

5.  海岸堤防等の粘り強い構造及び耐震対策について，平成23年12月，国土交通省海岸室長ほか.

＜標　準＞

+----------------------------------------------------------------------+
| 地震災害対策とは、地震動によりもたらされる河川管理施設、砂防設備、   |
| 海岸保全施設等の被災及びこれらにより発生する水害・土砂災害等の二次災 |
| 害を防止・軽減すること及び津波による被害を防止・軽減することをいう。 |
|                                                                      |
| 地震動に対しては、河川・砂防・海岸の各施設の特性                     |
| や発生頻度、規模を考慮して、必要な耐震性を確保することを基本とする。 |
|                                                                      |
| 津波に対しても、発生頻度、規模を考慮す                               |
| るとともに、沿岸域における施策を含めた対策を講じることを基本とする。 |
+----------------------------------------------------------------------+

6.  []{#_Toc102717433
    .anchor}河川等の適正な利用及び流水の正常な機能の維持並びに河川環境等の整備と保全

＜考え方＞

「河川等の適正な利用及び流水の正常な機能の維持並びに河川環境等の整備と保全」は、安全で安心して暮らせる生活の確保、持続的な社会の発展、国土の有効利用及び環境の保全を実現することを目標としており、総説で述べられているように、国土管理の重要な要素として位置づけられる。

「河川環境等」とは、河川環境、海岸環境及び渓流環境等のことである。

水は、生命の源であり、絶えず地球上を循環し、大気、土壌等の他の環境の自然的構成要素と相互に作用しながら、人を含む多様な生態系に多大な恩恵を与えている。河川及びそれに連なる水路等は、陸域における水循環の1つの過程を受け持つものであり、雨水等を集め海まで流下させるとともに、侵食作用による土砂の移動や、動植物の生息・生育・繁殖環境の場の形成といった機能を有している。ただ近年は、生活の高度化や産業の進展により、水系の有する浄化機能を超える汚濁物質等が河川に排出され、水質の悪化を招くとともに、農業用水の取水形態の合理化や水路式発電による河川水のバイパス等による河川流量の減少、減水区間の発生等により、川らしさの喪失や、河川環境の悪化を招いている。また、これまでの治水等の対策が河川等の自然環境に大きな影響を及ぼしてきた場合もある。

河川等の適正な利用及び流水の正常な機能の維持並びに河川環境等の整備と保全を実現する上では、水系が本来有する多様な機能を十分に生かした健全な水循環を維持又は回復させるため、流域としての総合的かつ一体的な管理のもと、河川の流量・水質の健全化や河川環境等の整備と保全のための施策を災害の防止・軽減や総合的な土砂管理と一体的に推進することが重要である。

河川環境等の整備と保全を図るに当たっては、河川全体の自然の営みを視野に入れた多自然川づくりに取り組むとともに、流域へと視点を拡げ、流域の農地や緑地などにおける取組と連携することにより、河川やこれと連続性を有する水域を基軸とした生態系ネットワークの形成を進めることが重要である。

＜必　須＞

+----------------------------------------------------------------------+
| 河川等の適正な利用及び流水の正常な機能の維持並びに河川環境等の整     |
| 備と保全は、安全で安心して暮らせる生活の確保、及び持続的な社会の発展 |
| 、国土の有効利用及び環境の保全を実現することを目標とする。このため、 |
| 河川等のみならず流域を含めて以下の事項の実現を図らなければならない。 |
|                                                                      |
| 1.  河川等の適正な利用及び流水の正常な機能の維持                     |
|                                                                      |
| 2.  動植物の良好な生息・生育・繁殖環境の保全・創出                   |
|                                                                      |
| 3.  良好な景観の保全・創出                                           |
|                                                                      |
| 4.  人と河川等との豊かな触れ合い活動の場の保全・創出                 |
|                                                                      |
| ５）良好な水質の保全                                                 |
+----------------------------------------------------------------------+

＜例　示＞

「河川等の適正な利用及び流水の正常な機能の維持並びに河川環境等の整備と保全」のために、流域での取り組みを含め実現すべき事項として、以下が列挙される。なお、「保全」には、維持・再生・回復・復元を含み、「創出」には形成を含むものとしている。

１）河川等の適正な利用及び流水の正常な機能の維持

> 河川等の適正な利用及び流水の正常な機能の維持とは、流水の占用、舟運、漁業、観光、流水の清潔の保持、塩害の防止、河口の閉塞の防止、河川管理施設の保護、地下水位の維持、景観、動植物の生息・生育・繁殖地の状況、人と河川等との豊かな触れ合いの確保等を総合的に考慮し、河川の流水が本来有する機能を維持することなどである。

２）動植物の良好な生息・生育・繁殖環境の保全・創出

> 動植物の良好な生息・生育・繁殖環境の保全・創出とは、これまでの自然的変化や社会的変化を踏まえ、流域の生態系としての視点からその川にふさわしい生物群集と生息・生育・繁殖環境の目標を定め、その環境の保全・創出を図り、それらの環境が将来にわたって維持されることなどである。

３）良好な景観の保全・創出

> 良好な景観の保全・創出とは、その川の自然景観や地域の歴史的・文化的な背景を踏まえ、自治体の景観計画等と整合・連携し、観光資源や貴重な憩いの空間として、河川等が本来有する水を基調とした景観が保全・創出されることなどである。

４）人と河川等との豊かな触れ合い活動の場の保全・創出

> 人と河川等との豊かな触れ合い活動の場の保全・創出とは、動植物の生息・生育・繁殖環境に配慮し、自然に大きな影響を与えることなく、自治体が立案する地域計画等と連携・調整を図り、河川利用に関する多様なニーズを十分反映するなど、地域の活性化や持続的な地域づくりのため、人と自然とが共生した触れ合い活動の場を保全・創出することである。

５）良好水質の保全

> 良好な水質の保全とは、河川等の適正な利用、流水の正常な機能の維持及び河川環境等の保全のために必要な水質を確保することである。

＜関連通知等＞

1.  多自然川づくり基本方針,平成18年10月18日，国土交通省河川局．

    （最新版）多自然川づくり基本方針，令和6年6月，国土交通省水管理・国土保全局.

```{=html}
<!-- -->
```
6.  正常流量検討の手引き（案）,平成19年9月,国土交通省河川環境課長.

7.  提言「持続性ある実践的多自然川づくりに向けて」,平成29年6月，河川法改正20年
    多自然川づくり推進委員会.

8.  気候変動を踏まえた水災害対策のあり方について～
    あらゆる関係者が流域全体で行う持続可能な「流域治水」への転換～答申，令和2年7月，社会資本整備審議会.

＜参考となる資料＞

河川を基軸とした生態系ネットワーク形成に関しては、以下の資料が参考となる。

1.  川からはじまる　川から広がる　魅力ある地域づくり　河川を基軸とした生態系ネットワークの形成，平成31年３月，国土交通省水管理・国土保全局河川管理課．\
    （最新版）川からはじまる 川から広がる 魅力ある地域づくり
    河川を基軸とした生態系ネットワークの形成，令和5年3月，国土交通省水管理・国土保全局河川環境課.

    6.  []{#_Toc102717434 .anchor}総合的な土砂管理

＜考え方＞

我が国の国土は環太平洋造山地域に位置し、地質が脆弱であり、地形も急峻であるため、山地の侵食が生じやすい環境におかれている。山地・山麓部で生産された土砂は、流水によって下流に運ばれ、扇状地や沖積平野を形成し、海に至り、漂砂となって移動し、海岸線などの海岸地形を形成している、我が国ではこのような土砂動態によって変化しながら形成される土地の上に主要な生活空間が形成されている。

こうした土砂移動に関する課題は、土砂収支バランスが変化することに伴い、山地部、平野部、河口・海岸部等のそれぞれにおいて様々な形で発生している。

例えば、山地部では、森林が荒廃していた時代は流出土砂が多く、それらは海岸まで到達していたが、戦後の森林再生等により流出土砂は減少している。一方、今も荒廃している地域では流出土砂による渓流河道部での異常堆積あるいは局所侵食や土石流などが発生している。また、ダム領域においては貯水池内の堆砂が進行し、ダムの機能が低下するだけでなく、下流に供給される土砂が不足し、河床の粗粒化等が発生している。平野部では河床低下（構造物の被災に強く関係する澪筋部の低下を含む）や河床における岩盤の露出などが発生している。河口部では河口砂州の縮小、上流への後退等の変化が、海岸部では沿岸構造物等による沿岸漂砂の連続性の阻害や河川等からの土砂供給量の減少等により海岸侵食や汀線の後退等が起こっている。海岸侵食や汀線の後退は、国土の保全にも関わってくる。礫河原の縮小と樹林化の進展等の河川の環境形成システムの変調にも、土砂動態の変化が関わっている可能性がある。

土砂動態の影響は、程度の差はあっても、各領域を超えて広域にまたがることが多いことから、個別領域の対応だけでは課題の根本的な解決には至らない場合があり、全国において土砂に関する現状の課題・問題点が顕在化してきているのが実態である。

実際、個別領域での対症療法的方策を続けることにより、課題の深刻化をくい止めるのに精一杯であったり、維持管理にかける労力が増したりするなどして、種々のコストが重荷になっている場合も少なくない。

こうした認識を踏まえ、土砂移動に関する課題を解決するための視点として、個別領域の問題として対策を行うだけでは解決できない場合においては、流域の源頭部から海岸までの一貫した流水等による土砂の運動領域を「流砂系」という概念で捉え、各領域の特性を踏まえつつ、土砂の移動による災害の防止、適切な河川等の整備・管理、海岸侵食の抑制、生態系や景観等の河川・海岸環境の保全、河川・海岸の適正な利活用を通じて、豊かで活力ある社会を実現することなどを目標として、流砂系全体を対象とした総合的な土砂管理に取り組んでいる。なお、土砂の移動については、不連続的に生じるものの、その移動外力は水であり、量と質については降雨、洪水、沿岸流・波浪等の水に係る現象と一体に検討する必要がある。また様々な施設の整備、砂利採取・河道掘削等、人為的なインパクトとその影響についても把握、考慮する必要がある。

総合的な土砂管理に取り組む意義は、流砂系全体の土砂管理に関する見通しを立てて、関係者間で共有し、施策に活かしていくことである。そのため、総合的な土砂管理の計画（以下「総合土砂管理計画」という。）は、各領域における計画（河川法に基づく河川整備基本方針及び河川整備計画、海岸法に基づく海岸保全基本計画、砂防基本計画、砂利採取など）と整合性をとる必要がある。

なお、気候変動による極端な降水の頻度及び強度の増大に伴い、

> ・山地部では集中的な崩落、がけ崩れ、土石流等の頻発や土砂・洪水氾濫の発生頻度の増加、河川（ダム領域を含む）への土砂供給量増大等
>
> ・河道部では河床の上昇や、頻発化・激甚化する洪水の作用による河床変動の変化等
>
> ・海岸部では河川からの土砂供給量が増大することに伴い海岸侵食が緩和される可能性がある

一方、気候変動による海面水位の上昇によって海岸が侵食される可能性が高いこと等

が示されている。また、例えば平成29年7月九州北部豪雨における福岡県赤谷川等や平成30年7月豪雨における広島県大屋大川等では、豪雨により上流域から流出した多量の土砂が谷出口より下流の河道で堆積することにより、河床上昇・河道埋塞が引き起こされ土砂と泥水が氾濫する土砂・洪水氾濫が発生するなど、気候変動の影響により土砂移動に関する新たな課題が顕在化したり、複雑化している。

このような土砂動態の変化をあらかじめ予測することは現在の技術的知見では困難であるため、個別領域それぞれにおいて土砂移動に関する調査等を行い、気候変動等の影響による当該流砂系の土砂動態の変化が認められた場合、実態調査を行った上で、新たな土砂動態を前提とした検討・見直しを実施することが必要となる。また、土砂の移動は山地部、河道部等にとどまらず、土砂の氾濫域も含めて捉える必要がある場合も生じてきている。

＜標　準＞

+----------------------------------------------------------------------+
| 土砂移動に関する課題は、土砂収支バラ                                 |
| ンスが変化することに伴い、砂防・ダム・河川・海岸等のそれぞれの領域に |
| おいて様々な形で発生する。災害の防止・軽減、河川等の適正な利用及び流 |
| 水の正常な機能の維持並びに河川環境等の整備と保全を実現するため、個別 |
| 領域それぞれにおいて土砂移動に関する調査等を実施し、課題を把握する。 |
|                                                                      |
| その上で、当該課題に対し、                                           |
| 各領域の個別の対策だけでは解決が困難な場合に、流砂系または土砂移動に |
| 関する課題を有する複数領域（以下「流砂系等」という。）において総合的 |
| な土砂管理（総合土砂管理）を推進し、土砂収支を考慮した上で、土砂の生 |
| 産抑制、流出の調節等の必要な対策を講じ、解決を図ることを基本とする。 |
|                                                                      |
| また、総合的な土砂管理の推進にあたっては、関係機関が連               |
| 携し、検討や対策の実施が円滑に行える体制を確保することを基本とする。 |
+----------------------------------------------------------------------+

＜推　奨＞

総合的な土砂管理を推進するためには、多岐にわたる関係機関において理解・認識の共有を図りつつ、流砂系等の全体像を捉え、課題とそれを生じさせている原因を大局的に把握し、課題解決の方向性を得た後に、当該流砂系等の理想に向けマネジメントするための全体コストの最適化、生態系や景観の保全等を踏まえつつ、土砂管理の目指すべき姿や関係機関の役割、具体的な土砂管理の内容を定めた総合土砂管理計画を策定し、総合土砂管理計画に基づいて関係者が実践的に取り組んでいくことが望ましい。また、現状の進展や取り組み効果に合わせて、順応的に総合土砂管理計画を更新して、理想像に近づけていくことが望ましい。

＜例　示＞

総合土砂管理計画は、関係機関における理解・認識の共有レベル、調査データの収集・蓄積レベル、土砂動態の解明レベル、課題の重要度レベル、土砂管理目標の設定レベル等の取り組みのレベルに応じて計画の内容・熟度をあげていくなど段階的に計画を策定することができる。例えば、天竜川流砂系や大井川流砂系では流砂系全体ではなく下流域を先行した計画の策定や、那賀川流砂系ではモニタリングを中心とする総合的な土砂管理の取り組みを中間とりまとめとして策定した事例がある。

総合土砂管理計画を策定する前段階として、関係機関における連携体制を確保し、土砂管理の目指すべき姿や関係機関の役割等を定める総合的な土砂管理の連携方針（以下「総合土砂管理連携方針」という。）を策定することも考えられる。

検討にあたっては、関係機関が一堂に会する場（検討委員会等）を設置し、検討を行うことが考えられる。また、検討委員会等に学識者等が参画することや、計画策定にあたって地域住民等から意見募集を実施した事例がある。なお、関係機関としては一般的に治山関係部局、ダム関係部局、堰関係部局、砂防関係部局、海岸関係部局、河川関係部局、港湾・漁港関係部局などが考えられる。

＜参考となる資料＞

総合土砂管理計画の策定については、下記の資料が参考になる。

1.  気候変動影響評価報告書,令和2年12月,環境省.

```{=html}
<!-- -->
```
9.  総合土砂管理計画策定の手引き
    第1.0版,平成31年3月,一般財団法人国土技術研究センター.

    （最新版）総合土砂管理の推進と計画策定の手引き
    第2.0版,令和7年3月,（一財）国土技術研究センター.

10. 天竜川流砂系総合土砂管理計画【第一版】,平成30 年3
    月,天竜川流砂系協議会.

11. 大井川流砂系総合土砂管理計画【第一版】,令和2年6月,大井川流砂系協議会.

12. 那賀川の総合土砂管理に向けた取り組み
    中間とりまとめ,平成30年3月,那賀川総合土砂管理検討協議会

    （最新版）那賀川の総合土砂管理に向けた取り組み中間とりまとめ【第２版】,令和6年3月,那賀川総合土砂管理検討協議会.

    6.  []{#_Toc101356241 .anchor}モニタリング

＜考え方＞

+----------------------------------------------------------------------+
| 河川の形態、水量及び環境                                             |
| は、流域の自然、社会条件と密接な関係にあることから、流域の自然的・社 |
| 会的条件の変化に伴い絶えず変化する。このため、現在の状況を適切に評価 |
| するために、水・土砂、土地・空間、施設の監視を行い、必要に応じて計画 |
| 、設計、施工、維持管理にフィードバックすることにより、河川を含む流域 |
| 社会が適正な状態に保たれるような仕組みを構築しようとするものである。 |
|                                                                      |
| また、流域治水の推進にあたっては、水害リスクについて関係者           |
| 間で共通認識を持つことが欠かせない。よって、水害リスクの評価を適切に |
| 行う視点で必要なモニタリングの検討・実施に努める必要がある。ここで水 |
| 害リスクとは、河川氾濫や内水氾濫等の被害を引き起こす可能性のある自然 |
| 現象であるハザードと、人口、資産、社会経済活動といった被害対象（エク |
| スポージャー）及び被害対象のハザードに対する脆弱性により決定される。 |
|                                                                      |
| これらを専門的に分析した評価結果等を用い、                           |
| 水害時のリスクコミュニケーションを行うためにも、水・土砂、土地・空間 |
| 、施設等河道内の状態監視を行うことに加え、水害リスク評価に必要な沿川 |
| 人口動態など地域の状況についても絶えず把握に努めることが重要である。 |
|                                                                      |
| これらの達成に向けては河川、砂防、海                                 |
| 岸の管理者及び事業者のみでは限界があることも認識し、流域の機関及び関 |
| 係者との連携を深め、流域の自然的、社会的条件の変化等を把握するととも |
| に、協調して流域治水に資する各種事業等の施行を行うことが重要である。 |
|                                                                      |
| 以上のような認識のもと、水・土砂、土地・空間及び施設について、       |
| それぞれが必要となるモニタリングを行うとともに、地域の状況を適切に把 |
| 握・共有する必要がある。なお、各々のモニタリングは、健全な水循環及び |
| 流砂系全体の関係を考慮し、相互に調整がとれるよう留意する必要がある。 |
|                                                                      |
| 各々のモニタリングについては、河川砂防技術基準                       |
| 維持管理編に                                                         |
| おいて実施内容を定め、調査編においてその手法について提示している。こ |
| れに基づき実施されたモニタリングの結果については、計画、設計、施工の |
| 各過程及び、流域関係者とのリスクコミュニケーションにおいて活用する。 |
+----------------------------------------------------------------------+

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  適切な水・土砂等の管理を行うため、河川管理者等は、調査・計画・設計・施工・維持管理を一連のシステムとして捉え、常に監視（モニタリング）、評価を行い、それぞれの過程にフィードバックすることを基本とする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1.  河川砂防技術基準　調査編，平成26年4月，国土交通省水管理・国土保全局.

    （最新版）河川砂防技術基準　調査編, 令和7年6月,
    国土交通省水管理・国土保全局.

```{=html}
<!-- -->
```
13. 河川砂防技術基準　維持管理編（河川編）,平成27年3月,国土交通省水管理・国土保全局.

    （最新版）河川砂防技術基準　維持管理編（河川編），令和3年10月，国土交通省水管理・国土保全局.

14. 河川砂防技術基準　維持管理編（ダム編），平成28年3月，国土交通省水管理・国土保全局.

    （最新版）河川砂防技術基準
    維持管理編（ダム編），令和7年6月，国土交通省水管理・国土保全局.

15. 河川砂防技術基準　維持管理編（砂防編）,平成28年3月,国土交通省水管理・国土保全局.

    （最新版）河川砂防技術基準　維持管理編（砂防編）, 令和6年6月,
    国土交通省水管理・国土保全局.

基本計画編 {#基本計画編 .TOC-Heading}
==========

第2章　河川計画　 {#第2章-河川計画 .TOC-Heading}
=================

目　次 {#目-次 .TOC-Heading}
======

[第1節 河川計画に関する基本的な事項 1](#_Toc508807466)

> [1．1 総説 1](#_Toc508903388)
>
> [1．2 河川整備基本方針と河川整備計画 2](#_Toc508807468)

[第2節 洪水防御に関する計画の基本的な事項 4](#_Toc506923965)

> [2．1 総説 4](#_Toc506923966)
>
> [2．1．1 洪水防御に関する計画の原則 4](#_Toc506923967)
>
> [2．1．2 超過洪水への対応 4](#_Toc506923968)
>
> [2．1．3 河川整備基本方針と河川整備計画 5](#_Toc506923969)
>
> [2．2 基本高水に関する基本的事項 6](#_Toc102011376)
>
> [2．2．1 基本高水の設定の手法 6](#_Toc506923971)
>
> [2．2．2 対象降雨の定義 6](#_Toc506923972)
>
> [2．3 計画基準点の設定 7](#_Toc506923973)
>
> [2．4 計画規模の設定 7](#_Toc508807474)
>
> [2．4．1 計画の規模 7](#_Toc508807475)
>
> [2．4．2 計画規模の同一水系内での整合性 9](#_Toc506923976)
>
> [2．5 既往洪水の検討 9](#_Toc506923977)
>
> [2．6 洪水流出モデルの構築 10](#_Toc506923978)
>
> [2．6．1 流出計算法の選定 10](#_Toc506923979)
>
> [2．6．2 洪水流出モデルの定数の設定 11](#_Toc506923980)
>
> [2．7 基本高水の設定 12](#_Toc506923981)
>
> [2．7．1 基本高水の設定の基本 12](#_Toc506923982)
>
> [2．7．2 対象降雨の設定 13](#_Toc506923983)
>
> [2．7．3 総合判断による基本高水の設定 17](#_Toc102011390)
>
> [2．7．4 内水の考慮 19](#_Toc506923984)
>
> [2．7．5 基本高水を見直す場合の考え方 19](#_Toc506923985)
>
> [2．8 計画高水流量に関する事項 20](#_Toc506923986)
>
> [2．8．1 計画高水流量の定義 20](#_Toc506923987)
>
> [2．8．2 計画高水流量の決定に際し検討すべき事項 21](#_Toc506923988)
>
> [2．9 超過洪水対策 21](#_Toc102011396)

[第3節 河川の適正な利用及び流水の正常な機能の維持に関する基本的な事項
22](#_Toc103783538)

> [3．1 総説 22](#_Toc103783539)
>
> [3．2 正常流量 22](#_Toc103783540)
>
> [3．3 維持流量の設定 23](#_Toc103783541)
>
> [3．4 水利流量の設定 25](#_Toc103783542)

[第4節 河川環境の整備と保全に関する基本的な事項 25](#_Toc103783543)

> [4．1 総説 25](#_Toc103783544)
>
> [4．2 動植物の良好な生息・生育・繁殖環境の保全・創出
> 27](#_Toc103783545)
>
> [4．3 良好な景観の保全・創出 28](#_Toc103783546)
>
> [4．4 人と河川との豊かな触れ合い活動の場の保全・創出
> 29](#_Toc103783547)
>
> [4．5 良好な水質の保全 30](#_Toc103783548)

令和４年６月　版

適用上の位置付け

　河川砂防技術基準計画編は、基準の適用上の位置付けを明確にするために、下表に示すように適用上の位置付けを分類している。

+--------+------------------+------------------+------------------+
| 分　類 | 適用上の位置付け | 末尾の字句例     |                  |
+--------+------------------+------------------+------------------+
| 考え方 | 技術資料         | ●目              | 「･･･ある。      |
|        |                  | 的や概念、考え方 | 」「･･･いる。」  |
|        |                  | を記述した事項。 |                  |
|        |                  |                  | 「･･･なる。      |
|        |                  |                  | 」「･･･れる。」  |
+--------+------------------+------------------+------------------+
| 必　須 | 技術基準         | ●法令による規定  | 「･･･なければ    |
|        |                  | や技術的観点から | ならない。」「･  |
|        |                  | 実施すべきである | ･･ものとする。」 |
|        |                  | ことが明確であり |                  |
|        |                  | 遵守すべき事項。 |                  |
+--------+------------------+------------------+------------------+
| 標　準 | 技術基準         | ●特              | 「･･･            |
|        |                  | 段の事情がない限 | を標準とする。」 |
|        |                  | り記述に従い実施 |                  |
|        |                  | すべきだが、状況 | 「･･･            |
|        |                  | や条件によって一 | を基本とする。」 |
|        |                  | 律に適用すること |                  |
|        |                  | はできない事項。 | 「･･･による。」  |
+--------+------------------+------------------+------------------+
| 推　奨 | 技術資料         | ●状況や条件      | 「               |
|        |                  | によって実施する | ･･･望ましい。」  |
|        |                  | ことが良い事項。 |                  |
|        |                  |                  | 「               |
|        |                  |                  | ･･･推奨する。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･務める。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･必要に応    |
|        |                  |                  | じて･･･する。」  |
+--------+------------------+------------------+------------------+
| 例　示 | 技術資料         | ●適用条件や実施  | 「               |
|        |                  | 効果について確定 | ･･･などの手法（  |
|        |                  | している段階では | 事例）がある。」 |
|        |                  | ないが、状況や条 |                  |
|        |                  | 件によっては導入 | 「･･･など        |
|        |                  | することが可能な | の場合がある。」 |
|        |                  | 新技術等の例示。 |                  |
|        |                  |                  | 「･･･など        |
|        |                  | ●状              | が考えられる。」 |
|        |                  | 況や条件によって |                  |
|        |                  | 限定的に実施でき | 「               |
|        |                  | る技術等の例示。 | ･･･の場合には･･･ |
|        |                  |                  | ことができる。」 |
|        |                  | ●具体的          |                  |
|        |                  | に例示することに | 「               |
|        |                  | より、技術的な理 | ･･･例示する。」  |
|        |                  | 解を助ける事項。 |                  |
|        |                  |                  | 「例えば･･･。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･事例もある  |
|        |                  |                  | 。･･･もよい。」  |
+--------+------------------+------------------+------------------+

  関連通知等       関連する通知やそれを理解する上で参考となる資料
  ---------------- ------------------------------------------------------
  参考となる資料   例示等に示した手法・内容を理解する上で参考となる資料

2.  

3.  河川計画

    6.  []{#_Toc508807466 .anchor}河川計画に関する基本的な事項

        1.  []{#_Toc508903388 .anchor}総説

＜考え方＞

+----------------------------------------------------------------------+
| 本章は、洪水防御に関する基本的な事項                                 |
| 、河川の適正な利用及び流水の正常な機能の維持に関する基本的な事項、河 |
| 川環境の整備と保全に関する基本的な事項から構成されており、河川法に規 |
| 定する河川整備基本方針及び河川整備計画等の策定に当たって、治水・利水 |
| ・環境のそれぞれの観点から検討すべき基本的な事項を示したものである。 |
|                                                                      |
| ここでは、河川計画を便宜上、「洪水防御に関する基本的な事項」「河川   |
| の適正な利用及び流水の正常な機能の維持に関する基本的な事項」「河川環 |
| 境の整備と保全に関する基本的な事項」に分けて記述しているが、実態上は |
| 、治水・利水・環境の機能が相互に関連しており、単純に機能ごとに分離す |
| ることは不可能である。また、総合的な土砂管理からの視点や、維持管理、 |
| 洪水予報、施設操作等の河川管理からの視点も重要である。実際に河川計画 |
| を立案する場合には、これらの機能の強化を総合的に勘案する必要がある。 |
|                                                                      |
| 地球温暖化がもたらす気温の上昇で、大                                 |
| 気中の水蒸気量が増加すること等により、近年の水災害をもたらすような豪 |
| 雨において、その降雨量が増大していると評価されており、更に温暖化の影 |
| 響により、こうした極端豪雨における降雨量が増すことが予測されている。 |
|                                                                      |
| 長時間を要する河川                                                   |
| 整備において、目標とする治水安全度を確保するためには、将来の気候変化 |
| 等を見据えて対策を講じなければ、計画の見直しや追加的な対策の実施に迫 |
| られ、必要な河川整備に要する期間が長期化するおそれがあるため、河川計 |
| 画を将来の降雨量の増加等を予め考慮したものに見直していく必要がある。 |
|                                                                      |
| 河川                                                                 |
| 計画を策定・変更するためには、各種データを必要とする。降雨量、流量、 |
| 水位、洪水痕跡、潮位、標高データ等の実測に基づくデータを活用し、経験 |
| した洪水の特徴を把握するとともに、将来気候における降雨の予測結果も活 |
| 用し、将来の気象の状況を考慮して河川計画を検討することが必要である。 |
|                                                                      |
| 実測データに関しては、上下流、本支川といった水系全体で水             |
| 位観測等を行い、降雨-流出特性や洪水の流下特性及びそれらの変化の把握  |
| に努め、必要に応じその結果を河川計画に反映していくことが重要である。 |
|                                                                      |
| 将来気候におけ                                                       |
| る降雨の予測に関しては、気候変動の影響に関する予測技術が進展し、現在 |
| 、将来気候における膨大なアンサンブル計算結果が整備されており、これら |
| を用いて河川計画の対象とするような極端現象を評価することが可能となっ |
| ている。本章では、現時点で考えられる最良の河川計画の目標の設定の考え |
| 方や、温暖化による降雨量の増加等を予め考慮した計画の策定方法を示して |
| いる。なお、今後の気候の変動状況や将来気候の予測に係る技術・知見の蓄 |
| 積等を踏まえ、必要に応じ河川計画の目標の設定手法の改善を図っていく。 |
|                                                                      |
| また、現況の                                                         |
| 施設能力や河川の整備の基本となる洪水の規模を超える洪水が発生し得るこ |
| と、洪水防御の目標達成には時間を要することに鑑み、想定し得る最大規模 |
| まであらゆる規模の洪水に対して、氾濫やそれによる被害の特徴を分析し、 |
| 氾濫による被害を軽減する対策についても検討しておくことが重要である。 |
+----------------------------------------------------------------------+

＜必　須＞

+----------------------------------------------------------------------+
| 河川計画の策定・変                                                   |
| 更に当たっては、河川の有する治水機能、利水機能、環境機能の調和に配慮 |
| しつつ、総合的な土砂管理等についても必要に応じて配慮するものとする。 |
|                                                                      |
| その際、河川の維持・管理等の視点を十分考慮するものとする。           |
|                                                                      |
| また、降雨量、流量等の水文諸量のほか、環境に関するデータ等           |
| 、精度を十分考慮し、これらの各種実績データを用いるとともに、更に目標 |
| とする治水安全度を確保するために、将来気候における降雨の予測結果も活 |
| 用し、将来の気象の状況を考慮して洪水防御の目標とする洪水を検討する。 |
+----------------------------------------------------------------------+

＜推　奨＞

+----------------------------------------------------------------------+
| 河川計画の策定・変更に当たっては、                                   |
| 気候変動の影響により降雨量が増大することやこれまで発生していない降雨 |
| 分布も含めた様々な時空間分布の降雨が発生する可能性が高まること、洪水 |
| 防御の目標達成には時間を要することに鑑み、洪水防御のための対策に加え |
| 、氾濫の被害をできるだけ減らすよう河川整備を検討することが望ましい。 |
|                                                                      |
| さらに、第5章に示                                                    |
| す集水域と氾濫域を含む流域全体で、あらゆる関係者との協働による被害軽 |
| 減のための対策の推進に必要な支援内容も併せて検討することが望ましい。 |
+----------------------------------------------------------------------+

＜例　示＞

+------------------------------------------------------------------------+
| 河川計画の策定に当たって検討すべき視点としては、例えば以下の点がある。 |
|                                                                        |
| ・ 現在及び将来の気象の状況                                            |
|                                                                        |
| ・ 流域の自然環境の現況とその歴史的な変遷                              |
|                                                                        |
| ・ 流域の土地利用等の社会環境の現況とその歴史的な変遷及び今後の見通し  |
|                                                                        |
| ・ 災害の歴史と改修の経緯                                              |
|                                                                        |
| ・ 所要の治水安全度の確保                                              |
|                                                                        |
| ・ 超過洪水時の被害軽減                                                |
|                                                                        |
| ・ 総合的な土砂管理                                                    |
|                                                                        |
| ・ 水利用の状況と今後の見通し                                          |
|                                                                        |
| ・ 健全な水循環系の確保                                                |
|                                                                        |
| ・ 河川の維持・管理                                                    |
|                                                                        |
| ・ 良好な自然環境の保全・復元                                          |
|                                                                        |
| ・ 良好な景観の維持・形成                                              |
|                                                                        |
| ・ 人と河川との豊かな触れ合い活動の場の維持・形成                      |
|                                                                        |
| ・ 地域づくりとの連携                                                  |
|                                                                        |
| ・ 経済的合理性                                                        |
+------------------------------------------------------------------------+

2.  []{#_Toc508807468 .anchor}河川整備基本方針と河川整備計画

＜考え方＞

+----------------------------------------------------------------------+
| 河川の整備は将来的に達成すべき目標を定                               |
| め、これに基づいて行われるが、河川の整備には多大な予算と時間を要する |
| ことから、水系間や河川間等のバランスを図りながら、中期的な整備目標を |
| 定めて段階的に整備を行うことが一般的である。すなわち、河川自体が自然 |
| の営力によって変化するだけでなく、河川を取り巻く社会的状況や地域住民 |
| の河川に対するニーズも時代とともに変化することから、長期的な整備目標 |
| に対する具体的な整備の内容やその目標に至るまでの整備手順や整備時期な |
| どを現時点ですべて定めることは困難である。したがって、当面の整備目標 |
| が達成できると見込まれ、かつ住民が実感を持つことができる程度の期間を |
| 計画期間として設定し、長期的な目標を定める河川整備基本方針に沿って、 |
| 中期的な具体的な整備の内容を示す河川整備計画を定めることとしている。 |
|                                                                      |
| 河川整備計画の検                                                     |
| 討においては、それぞれの地域特性に応じた治水対策を講じることにより早 |
| 期に安全度の向上・確保を図りつつ、流域全体で水災害リスクを低減してい |
| く観点が重要である。例えば、流域全体及び当該地域の治水安全度向上のた |
| め、遊水地の整備や霞堤の整備・保全、土地利用と一体となった輪中堤の整 |
| 備等といった沿川の遊水機能の確保にも考慮した河川整備が挙げられる。ま |
| た、上流区間と下流区間で河川管理者が異なる場合は相互調整及び連携を図 |
| り、上下流・本支川の背後地の人口・資産の集積状況、土地利用状況等の現 |
| 況に加え、関連地域の社会経済情勢の発展に即応するよう「都市計画」や「 |
| 土地利用計画」等との調整を図り、河川整備を検討することが重要である。 |
+----------------------------------------------------------------------+

＜必　須＞

+----------------------------------------------------------------------+
| 河川整備基本方針においては、全国的なバランスを考慮し、また個々の河   |
| 川や流域の特性を踏まえて、水系ごとの長期的な河川の整備（河川工事及び |
| 河川の維持）の方針や整備の基本となるべき事項を定めなければならない。 |
|                                                                      |
| また、河川整備計画においては、河川整備                               |
| 基本方針に定められた内容に沿って、地域住民のニーズなどを踏まえた、お |
| およそ20～30年間に行われる具体的な整備の内容を定めなければならない。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 河川整備基本方針においては、以下の事項を定めることを基本とする。     |
|                                                                      |
| 1.  当該水系に係わる河川の総合的な保全と利用に関する基本方針         |
|                                                                      |
| 2.  河川の整備の基本となるべき事項                                   |
|                                                                      |
| ```{=html}                                                           |
| <!-- -->                                                             |
| ```                                                                  |
| 1.  基本高水並びにその河道及び洪水調節施設への配分に関する事項       |
|                                                                      |
| 2.  主要な地点における計画高水流量に関する事項                       |
|                                                                      |
| 3.                                                                   |
|   主要な地点における計画高水位及び計画横断形に係わる川幅に関する事項 |
|                                                                      |
| 4.  主                                                               |
| 要な地点における流水の正常な機能を維持するため必要な流量に関する事項 |
|                                                                      |
| 河川整備計画においては、以下の事項を定めることを基本とする。         |
|                                                                      |
| 1.  河川整備計画の目標に関する事項                                   |
|                                                                      |
| 2.  河川の整備の実施に関する事項                                     |
|                                                                      |
| ```{=html}                                                           |
| <!-- -->                                                             |
| ```                                                                  |
| 1.  河川工事の目的、種類及び施行の                                   |
| 場所並びに当該河川工事の施行により設置される河川管理施設の機能の概要 |
|                                                                      |
| 2.  河川の維持の目的、種類及び施行の場所                             |
|                                                                      |
| な                                                                   |
| お、河川整備計画は当該河川の具体的な河川整備の内容を明らかにするもの |
| であるが、限られた費用と時間の制約の中で整備を行うに当たっては施行順 |
| 序の検討、他事業との計画調整や進度管理を含む事業調整などが不可欠であ |
| ることを十分踏まえるとともに、以下の事項に留意することを基本とする。 |
|                                                                      |
| 1.  河川整                                                           |
| 備計画の策定単位は、一連の河川整備の効果が発現する範囲を基本とする。 |
|                                                                      |
| 2.  計画期間は、一連区間において河川整備の効果を発現させるために     |
| 必要な期間として、20～30年程度を目途に定めるのが一般的であるが、調査 |
| ・検討に時間を要するなど具体の整備内容等に不確定な要素がある場合には |
| 、計画期間を通常のそれより短く設定して不確定部分を除くか、不確定部分 |
| を検討事項として明記し、明らかになった時点で適宜計画の見直しを行う。 |
|                                                                      |
| 3.  河川の整備内容の検討に当たっては、計                             |
| 画期間中に実現可能な投資配分を考慮するとともに代替案との比較を行う。 |
|                                                                      |
| 4.  河川の整備                                                       |
| 内容について、その必要性と効果がわかりやすい内容となるよう工夫する。 |
|                                                                      |
| 5.  河川の工事内容は、でき                                           |
| るだけ将来的に手戻りがないよう配慮するが、整備の緊急性や施設の耐用年 |
| 数などを考慮し、必要な場合には将来的な手戻りが生じることも妨げない。 |
|                                                                      |
| 6.  河川の維持内容については、単な                                   |
| る維持工事的なものではなく、計画的に実施すべき事項について定める。\  |
|     > また、観                                                       |
| 測や調査など、河川のモニタリングのために必要な事項についても定める。 |
|                                                                      |
| 7.  河川整備計画には、河川の概要や現状と課題                         |
| 等、河川の整備を進めるに当たって前提とすべき事項についても記述する。 |
|                                                                      |
|     また、河川整備計画については、当面の具体的な河川整               |
| 備に関する事項を定めたものであり、流域の社会情勢の変化や地域の意向、 |
| 河川整備の進捗状況や進捗の見通し、河川維持管理計画に基づく維持管理に |
| おけるＰＤＣＡサイクルの中で得られた知見等を適切に反映できるよう、適 |
| 宜その内容について点検を行い、必要に応じて変更することを基本とする。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  河川整備計画の点検及び変更について，平成25年2月25日，国土交通省水管理・国土保全局河川計画課河川計画調整室長事務連絡.

    2.  []{#_Toc506923965 .anchor}洪水防御に関する計画の基本的な事項

        1.  []{#_Toc506923966 .anchor}総説

            1.  []{#_Toc506923967 .anchor}洪水防御に関する計画の原則

＜考え方＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  洪水防御に関する計画の策定に当たっては河川及びその流域における他の河川計画その他各種の施設計画等との調整を図る必要がある。例えば、一般の河川については、河道計画と砂防計画や海岸保全計画、洪水調節計画と利水計画、河道計画と環境保全計画、河道計画と維持管理計画等についての調整である。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜必　須＞

+----------------------------------------------------------------------+
| 洪水防御に関する計画は、河川の洪水による災害                         |
| を防止又は軽減するため、計画基準点において計画の基本となる洪水のハイ |
| ドログラフ（以下「基本高水」という。）を設定し、この基本高水に対して |
| この計画の目的とする洪水防御効果が確保されるよう策定するものとする。 |
|                                                                      |
| また、洪水防御に関する計画は、基本高水に対してこの計画により設置     |
| される施設が水系を一貫して相互に技術的、経済的及び社会的に調和がとれ |
| 、かつ十分にその目的とする機能を果たすよう策定されなければならない。 |
+----------------------------------------------------------------------+

2.  []{#_Toc506923968 .anchor}超過洪水への対応

＜考え方＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  洪水防御に関する計画は、技術的、経済的及び社会的に適切であり、基本高水に対して、効果が確実に発揮できるものとなるよう配慮し、策定するものであるが、計画の規模を超える洪水（以下「超過洪水」という。）に対しては、技術的、経済的及び社会的に可能な範囲で超過洪水による被害ができる限り流域全体で最小化するよう計画上配慮する必要がある。また、関係する地域社会に対して、河川整備前後における様々な規模の超過洪水が発生した場合の被害の態様を明らかにし、氾濫域の土地利用規制や立地の誘導等の被害対象を減少させる取り組み、氾濫発生時における住民等の自主的な避難や的確な水防活動、円滑な応急活動の実施など、流域の関係者により超過洪水の生起に際して適切な対応がとられるよう、氾濫による被害を軽減する取り組みを推進していく必要がある。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  洪水防御に関する計画の策定に当たっては、河川の持つ治水、利水、環境等の諸機能を総合的に検討するとともに、この計画がその河川に起こり得る最大洪水を目標に定めるものではないことに留意し、計画の規模を超える洪水（以下「超過洪水」という。）の生起についても配慮することを基本とする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1.  河川砂防技術基準調査編，平成26年4月，国土交通省水管理・国土保全局,第9章
    水害リスク評価.

    （最新版）河川砂防技術基準調査編，令和7年6月，国土交通省水管理・国土保全局,第9
    章 水害リスク評価.

    1.  []{#_Toc506923969 .anchor}河川整備基本方針と河川整備計画

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  河川整備基本方針においては、超過洪水の生起にも配慮し、計画基準点における基本高水のピーク流量とその河道及び洪水調節施設への配分、並びに主要地点での計画高水流量を定め、河川整備計画においては、現況施設能力を上回る洪水の生起にも配慮し、段階的に効果を発揮するよう目標年次を定め、一定規模の洪水の氾濫を防止し、必要に応じそれを超える洪水に対する被害を軽減する計画とする。その際に、既存施設の有効利用やソフト施策を重視するとともに、流域における対応を取り込むものとする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  河川整備計画の検討に当たって、想定し得る最大規模の外力までの様々な規模の外力に対して、氾濫が発生した場合の施設整備による水害リスクの変化を、人的被害、経済被害、社会経済活動への影響等の評価項目により可視化し、氾濫による被害をできるだけ軽減するよう河川整備の選定に活用することが望ましい。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1.  [河川砂防技術基準調査編](http://www.mlit.go.jp/river/shishin_guideline/gijutsu/gijutsukijunn/chousa/pdf/09.pdf)，平成26年4月，国土交通省水管理・国土保全局,第9章
    水害リスク評価.

    （最新版）河川砂防技術基準調査編，令和7年6月，国土交通省水管理・国土保全局,第9
    章 水害リスク評価.

```{=html}
<!-- -->
```
16. [治水経済調査マニュアル(案)](https://www.mlit.go.jp/river/basic_info/seisaku_hyouka/gaiyou/hyouka/r204/chisui.pdf)，令和2年4月，国土交通省水管理・国土保全局.

    （最新版）治水経済調査マニュアル（案）,令和7年7月，国土交通省水管理・国土保全局.

17. [水害の被害指標分析の手引(H25
    > 試行版)](http://www.mlit.go.jp/river/basic_info/seisaku_hyouka/gaiyou/hyouka/pdf/higaisihyou_h25.pdf)，平成25年7月，国土交通省水管理・国土保全局.

18. [水害リスク評価の手引き（試行版）](https://www.mlit.go.jp/river/shinngikai_blog/chisui_kentoukai/dai02kai/dai02kai_siryou4-2.pdf),平成30年5月,
    > 国土交通省水管理・国土保全局、国土技術政策総合研究所.

＜参考となる資料＞

様々な規模の外力に対して施設整備による水害リスクの変化を評価し優先的に行う対策の検討を行った例としては、下記の資料が参考となる。

1.  [鈴鹿川における河川整備の効果について（水害リスクの評価（試行））](http://www.cbr.mlit.go.jp/mie/river/conference/ryuiki/pdf/16th/16th_shiryou-08.pdf)（第16回三重河川流域委員会資料-8），平成28年3月24日，国土交通省
    三重河川国道事務所．

    1.  []{#_Toc102011376 .anchor}基本高水に関する基本的事項

        1.  []{#_Toc506923971 .anchor}基本高水の設定の手法

＜考え方＞

+----------------------------------------------------------------------+
| 基本高水は、そのハイドログラフで代表される規模の洪水                 |
| の起こりやすさ、つまり生起確率によって評価され、それが洪水防御に関す |
| る計画の目標としている安全の度合い、すなわち治水安全度を表している。 |
|                                                                      |
| しかし、洪水のハイドログラフそれ                                     |
| 自体は、その生起確率の計算等の対象としては必ずしも便利ではなく、その |
| ピーク流量又は総ボリュームに着目して統計解析するには、多くの場合計算 |
| が複雑となり、資料不足のため十分な精度が得られないなどの難点がある。 |
|                                                                      |
| したがって、基本高水を設定する方法としては、その取扱いが             |
| 簡単であって一般の人々にとって理解しやすいよう、その洪水の起因となる |
| 降雨に着目して、所定の治水安全度に対応する超過確率を持つ対象降雨を選 |
| 定し、この対象降雨から一定の手法でハイドログラフを設定する方法を標準 |
| とするが、これ以外でよりその河川に適合した方法を採用することもある。 |
|                                                                      |
| 対象降雨から洪水流出モデルを用いて計算された洪水ハイドロ             |
| グラフのうち、洪水防御に関する計画の基本となるものを基本高水とする。 |
|                                                                      |
| 基本高水の設定に当たっては、計画規模に対応する適                     |
| 正なピーク流量を選定する等の観点から、総合的に検討を進める必要がある |
| 。基本高水は、洪水防御に関する計画の基本となるものであるから、洪水調 |
| 節等の人工的な操作の加わらない洪水ハイドログラフでなければならない。 |
|                                                                      |
| また、基本高水は計算された洪水ハイドログラフのうち、                 |
| 必ずしもピーク流量若しくは流出の総量が最大のものであるとは限らない。 |
|                                                                      |
| なお、計画上、洪水のピーク流量の設定をもって洪                       |
| 水防御に関する計画の策定が可能な場合にあっては、基本高水はこのピーク |
| 流量で表すものとし、特に洪水のハイドログラフの設定を行う必要はない。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 基本高水を設定する方法としては、種々の手法が                         |
| あるが、一般には対象降雨を選定し、これにより求めることを基本とする。 |
|                                                                      |
| 基本高水は、計画基準点ごとにこれを定めることを基本とする。           |
+----------------------------------------------------------------------+

＜例　示＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------
  都市部の河川では、流域において流出抑制対策を講じない場合の洪水のピーク流量に対し、流域の雨水貯留浸透施設の設置等を考慮して、基本高水を設定した例がある。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------

＜参考となる資料＞

流域における雨水貯留浸透施設の設置等を考慮して、基本高水のピーク流量を設定した例としては、下記の資料が参考となる。

2.  [鶴見川水系河川整備基本方針](http://www.ktr.mlit.go.jp/keihin/keihin_index047.html)，平成17年5月，国土交通省水管理・国土保全局.

    1.  []{#_Toc506923972 .anchor}対象降雨の定義

＜考え方＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  「対象降雨」という表現は、従来の「計画降雨」を改めたものである。これは、「計画降雨」という表現が基本高水の設定のために一つの降雨を設定するものと誤解されることを避けるためである。すなわち、基本高水は計画規模の複数の降雨から検討されるものであり、基本高水の検討に用いた降雨群を「対象降雨」と定義する。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

  -----------------------------------------------------------------------------------------------------------------------------------------------
  対象降雨は、計画基準点ごとに選定することを基本とする。対象降雨は、降雨量、降雨量の時間分布及び降雨量の地域分布の3要素で表すことを基本とする。
  -----------------------------------------------------------------------------------------------------------------------------------------------

3.  []{#_Toc506923973 .anchor}計画基準点の設定

＜考え方＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  計画基準点は、洪水防御に関する計画において、目標とする安全度を評価する地点であり、水理、水文解析の拠点となるような水位標のある地点やダム等主要な洪水調節施設が設けられる地点が適している。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  計画基準点は、既往の水理、水文資料が十分得られて、水理、水文解析の拠点となり、しかも全般の計画に密接な関係のある地点を選定することを基本とする。計画基準点は、計画に必要な箇所に設けることを基本とする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜例　示＞

+----------------------------------------------------------------------+
| 図2-1に示す本川の基準水位標A、支川B(C)の基準水位標B(C)               |
| 、ダムD及びEの所在する地点は、いずれも計画基準点の候補地となりうる。 |
|                                                                      |
| 対象降雨の規模はこれらの各地点におい                                 |
| て異なってよく、また、同一地点においても計画の対象となる施設が異なれ |
| ば、その施設ごとの対象降雨は必ずしも同一のものであることを要しない。 |
|                                                                      |
| ![](media/image1.png){width="4.701388888888889in"                    |
| height="2.3664326334208226in"}                                       |
|                                                                      |
| 2.  図2-1 基準地点模式図                                             |
+----------------------------------------------------------------------+

1.  []{#_Toc508807474 .anchor}計画規模の設定

    1.  []{#_Toc508807475 .anchor}計画の規模

＜考え方＞

+----------------------------------------------------------------------+
| 計画の規模は、計画対象地域の洪水に対する安                           |
| 全の度合いを表すものであり、それぞれの河川の重要度に応じて上下流、本 |
| 支川でバランスが保持され、かつ全国的に均衡が保たれることが望ましい。 |
|                                                                      |
| 河川の重要度とは、洪水防御に関する計画の目的に応                     |
| じて流域の大きさ、その対象となる地域の社会的経済的重要性、想定される |
| 被害の量と質、過去の災害の履歴などの要素を考慮して定めるものである。 |
|                                                                      |
| 計画の規模が決定されると、それをもとに計画                           |
| の立案に当たって必要となる対象降雨を選定することとなる。対象降雨は降 |
| 雨量、降雨量の時間分布及び降雨量の地域分布の3要素によって表されるが  |
| 、対象降雨の規模は、一般には降雨量の年超過確率で評価することとする。 |
|                                                                      |
| このようにして評価された                                             |
| 対象降雨の規模は、対象降雨の降雨量について、1年間に何分の１の確率で  |
| その値を超過するかということを示している。それゆえ、これはその降雨に |
| 起因する洪水のピーク流量の年超過確率とは必ずしも1:1の対応をしない。  |
|                                                                      |
| しかし、洪水防御に関する計画においては、基本                         |
| 高水のピーク流量の年超過確率が重要な意味を持つので、年超過確率におい |
| て両者の間に著しい差異が生ずるおそれがある場合には、これらの関係を明 |
| 確にし、他の手法によって計画の規模を定めることを検討する必要がある。 |
+----------------------------------------------------------------------+

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------------
  計画の規模の設定に当たっては、河川の重要度を重視するとともに、既往洪水による被害の実態、経済効果等を総合的に考慮して定めることを基本とする。
  ----------------------------------------------------------------------------------------------------------------------------------------------

＜例　示＞

+----------------------------------------------------------------------+
| 河川整備基本方針の                                                   |
| 策定に当たって、計画の規模を決定する際に、おおよその基準として、河川 |
| をその重要度に応じてA級、B級、C級、D級及びE級の5段階に区分した場合の |
| 、その区分に応じた対象降雨の規模の標準を示すと表2-1のとおりである。  |
|                                                                      |
| 1.  河川の重要度と計画の規模                                         |
|                                                                      |
|   河川の重要度   計画の規模(対象降雨の降雨量の超過確率年) ※          |
|   -------------- --------------------------------------------        |
|   A級            200以上                                             |
|   B級            100～200                                            |
|   C級            50～100                                             |
|   D級            10～50                                              |
|   E級            10以下                                              |
|                                                                      |
| (※)年超過確率の逆数                                                  |
|                                                                      |
| 一般に、河川の重要度は一級河川の主要区間においてはA                  |
| 級～B級、一級河川のそのほかの区間及び二級河川においては、都市河川はC |
| 級、一般河川は重要度に応じてD級あるいはE級が採用されている例が多い。 |
|                                                                      |
| なお、特に著しい被害を被った地域にあっては、この既                   |
| 往洪水を無視して計画の規模を定めることは一般に好ましくない。したがっ |
| て、このような場合においては、その被害の実態等に応じて民生安定上、こ |
| の実績洪水規模の再度災害が防止されるよう計画を定めるのが通例である。 |
|                                                                      |
| しかしながら、この場合に                                             |
| おいても上下流、本支川のバランスが保持されるよう配慮する必要がある。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  [河川砂防技術基準調査編](http://www.mlit.go.jp/river/shishin_guideline/gijutsu/gijutsukijunn/chousa/pdf/08.pdf)，平成26年4月，国土交通省水管理・国土保全局,第8章
    河川経済調査.

```{=html}
<!-- -->
```
19. [治水経済調査マニュアル(案)](https://www.mlit.go.jp/river/basic_info/seisaku_hyouka/gaiyou/hyouka/r204/chisui.pdf)，令和2年4月，国土交通省水管理・国土保全局.

    （最新版）治水経済調査マニュアル（案）,令和7年7月，国土交通省水管理・国土保全局.

20. [水害の被害指標分析の手引(H25試行版)](http://www.mlit.go.jp/river/basic_info/seisaku_hyouka/gaiyou/hyouka/pdf/higaisihyou_h25.pdf)，平成25年7月，国土交通省水管理・国土保全局.

21. 「年超過確率」について，平成24年10月16日，国土交通省水管理・国土保全局河川計画課河川計画調整室長事務連絡.

    1.  []{#_Toc506923976 .anchor}計画規模の同一水系内での整合性

＜考え方＞

+----------------------------------------------------------------------+
| 洪水防御に                                                           |
| 関する計画は計画規模の洪水を防御することを目的とするものであるが、同 |
| 一水系内で必ずしも計画規模が、上下流、本支川間で連続する必要はない。 |
|                                                                      |
| 特に、同一水系内において、計画基準点を複数決                         |
| 定すると、相互の対象降雨の間には降雨量、継続時間等において関連性がな |
| いのが通常であり、単純に計画規模をそろえることは多くの場合、超過洪水 |
| の生起に際して、上下流の間では下流、本支川の間では本川が危険になるの |
| が一般であるので、この点も考慮して整合性を保つよう配慮すべきである。 |
|                                                                      |
| なお、必要に応じ超過洪水による被害ができる限り流域全体で最           |
| 小化し、過度に特定の地域に集中することのないよう配慮する必要がある。 |
+----------------------------------------------------------------------+

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------
  同一水系内における洪水防御に関する計画の策定に当たっては、その計画の規模が上下流、本支川のそれぞれにおいて十分な整合性を保つよう配慮することを基本とする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------

1.  []{#_Toc506923977 .anchor}既往洪水の検討

＜考え方＞

+----------------------------------------------------------------------+
| 水理・水文解析を行う                                                 |
| 上で最も重要なデータは、既往洪水の降雨と水位流量に関するものである。 |
|                                                                      |
| 降雨に                                                               |
| ついては、雨量の時間分布及び地域分布を明らかにするために、時間雨量の |
| データを流域内の主要地点についてできるだけ大量に収集する必要がある。 |
|                                                                      |
| 流量については、主要地点における実測値が                             |
| あればよいが、ない場合には洪水痕跡からの逆算等、適当な方法を用いて推 |
| 定する必要がある。なお、流量の検討に当たっては、補完的に危機管理型水 |
| 位計を含む縦断的に設置されている水位計のデータやカメラ映像等を活用す |
| るなど、氾濫や遊水の影響をできるだけ正確に評価することが重要である。 |
|                                                                      |
| 洪水の氾濫の状況及び被害の実態は、事業の効果や重要度                 |
| の判定に際して重要なものであるから、十分詳細な調査を行う必要がある。 |
|                                                                      |
| なお、洪水防御に関する計画の                                         |
| 策定にあたっては、再現性の高い流出計算モデルの構築が重要であるため、 |
| その基礎となる観測データの妥当性について点検を行うことが重要である。 |
+----------------------------------------------------------------------+

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  既往洪水の検討は、その洪水の原因となった降雨の性質、雨量の時間分布及び地域分布、その洪水の水位、流量等の水理・水文資料、洪水の氾濫の状況及び被害の実態等について行うことを基本とする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜例　示＞

+----------------------------------------------------------------------+
| 流                                                                   |
| 出計算に使用する観測データの点検において、局所的な降雨分布が地上観測 |
| 雨量で捉えられているかどうかを確認するため、地上観測雨量とレーダ雨量 |
| ~~計~~のそれぞれから算出した流域平均雨量を比較して確認した例がある。 |
|                                                                      |
| 流量の検討に当たって、補完的                                         |
| に危機管理型水位計を含む縦断的に設置されている水位計のデータやカメラ |
| 映像等を活用するなど、氾濫の影響をできるだけ正確に評価した例がある。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  河川砂防技術基準調査編，平成26年4月，国土交通省水管理・国土保全局
    > 第2章 水文・水理観測 第1節 総説，第2節 降水量観測，第3節
    > 水位観測，第4節 流量観測，第5節
    > 水文資料の整理・保存と品質管理，第7節 河川の流れの総合的把握.

    （最新版）河川砂防技術基準調査編，令和4年6月，国土交通省水管理・国土保全局
    第2章 水文・水理観測 第1節 総説，第2節 降水量観測，第3節
    水位観測，第4節 流量観測，第5節
    水文資料の整理・保存と品質管理，第7節 河川の流れの総合的把握.

```{=html}
<!-- -->
```
22. [河川砂防技術基準調査編](http://www.mlit.go.jp/river/shishin_guideline/gijutsu/gijutsukijunn/chousa/pdf/03.pdf)，平成26年4月，国土交通省水管理・国土保全局,第3章
    > 水文解析 第2節 流出解析 2.2.3
    > 水文資料及び流域特性資料の収集と整理.

＜参考となる資料＞

既往洪水の分析や流出計算に使用するデータの点検の例としては、下記の資料が参考となる。

1.  [大淀川水系河川整備基本方針
    > 基本高水等に関する資料（参考資料）](http://www.mlit.go.jp/river/shinngikai_blog/shaseishin/kasenbunkakai/shouiinkai/kihonhoushin/dai108kai/s3.pdf)3.流出計算に使用するデータの点検，平成28年7月，国土交通省水管理・国土保全局.

    流量の検討に当たって、危機管理型水位計やカメラ映像等を活用して氾濫の影響を評価した例としては、下記の資料が参考となる。

```{=html}
<!-- -->
```
3.  第２回　令和２年７月球磨川豪雨検証委員会説明資料，令和2年10月6日，国土交通省九州地方整備局・熊本県．

    1.  []{#_Toc506923978 .anchor}洪水流出モデルの構築

        1.  []{#_Toc506923979 .anchor}流出計算法の選定

＜考え方＞

+----------------------------------------------------------------------+
| 降雨から流量への変換に当たっては、様々な流出計算法があるが、当該流域 |
| の流出特性等を踏まえ、それを適切に反映できるものを用いる必要がある。 |
|                                                                      |
| なお、流域内の各地域における流出抑制対策等による                     |
| 雨水の貯留・保水機能や、地形条件による洪水の遊水機能を適切に評価し、 |
| 河川の整備の基本となる洪水の規模に対して流出特性の変化が想定される場 |
| 合は、これらの機能を評価可能な流出計算モデルを用いることが望ましい。 |
+----------------------------------------------------------------------+

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  降雨から流量への変換は、その対象とする河川の特性に応じた流出計算法を用いることを基本とする。なお、小流域の場合で、洪水調節などの貯留効果を考慮する必要がない河川計画の立案にあたっては流出計算の手法として合理式法を用いることができる。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜例　示＞

+----------------------------------------------------------------------+
| 流出計算法としては、貯留関数法や準線形貯留型モデル、タ               |
| ンクモデルなどがある。なお、河道及び流域において貯留現象がほとんど存 |
| 在しないか、貯留現象を考慮する必要がなく、ダム、遊水地等の貯留施設の |
| 計画もない河川の河道を計画する場合には、合理式法を用いることが多い。 |
|                                                                      |
| レーダ雨量計をはじめとする                                           |
| 時空間解像度が高い水文観測体制の整備、地形や土地利用などの地理情報の |
| 整備などが充実してきていることにより、分布定数系モデルの開発が進み、 |
| 洪水防御に関する計画の検討にあたって、既往最大流量を記録した実績洪水 |
| のピーク流量の確認を目的として分布定数系モデルを使用した事例がある。 |
|                                                                      |
| また、沿川の氾濫域にお                                               |
| いて、将来にわたり浸水することを前提として地域の合意の下、土地利用や |
| 居住誘導が進められており、計画高水流量が流下した際の水位が堤防天端を |
| 超える区間において、河道整備による洪水防御より河道と氾濫域一体となっ |
| た洪水防御の方が当該地域の治水対策として有効であることを踏まえ、当該 |
| 区間の氾濫域も地形条件として河道モデルを構築した例がある。ただし、こ |
| の場合、当該氾濫域において、将来開発が進み洪水防御の必要性が生じた場 |
| 合は、河道モデルを見直し計画に用いる流量を検証することが必要となる。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  [河川砂防技術基準調査編](http://www.mlit.go.jp/river/shishin_guideline/gijutsu/gijutsukijunn/chousa/pdf/03.pdf)，平成26年4月，国土交通省水管理・国土保全局,第3章
    > 水文解析 第2節 流出解析.

＜参考となる資料＞

近年の洪水流出モデル構築の事例としては、下記の資料1)が参考となる。また、河川整備基本方針の検討にあたって分布定数系モデルを使用した事例としては下記の資料2)が参考となる。

1.  [大淀川水系河川整備基本方針
    > 基本高水等に関する資料（参考資料）](http://www.mlit.go.jp/river/shinngikai_blog/shaseishin/kasenbunkakai/shouiinkai/kihonhoushin/dai108kai/s3.pdf)5.新たな流出解析モデルの構築，平成28年7月，国土交通省水管理・国土保全局.

```{=html}
<!-- -->
```
23. [矢部川水系河川整備基本方針
    > 基本高水等に関する資料（参考資料）](http://www.mlit.go.jp/river/basic_info/jigyo_keikaku/gaiyou/seibi/pdf/yabegawa93-6.pdf)参考2
    > 貯留関数法以外の手法による流量算出結果，平成26年6月，国土交通省水管理・国土保全局.

    　氾濫域も地形条件として河道モデルを構築し、基本高水を設定した例としては、下記の資料が参考となる。

24. [新宮川水系河川整備基本方針の変更について（社会資本整備審議会河川分科会第110回河川整備基本方針検討小委員会
    > 資料2-1）](https://www.mlit.go.jp/river/shinngikai_blog/shaseishin/kasenbunkakai/shouiinkai/kihonhoushin/dai110kai/06_shiryou2-1_shingu.pdf)，令和3年5月21日，国土交通省水管理・国土保全局．

25. [五ヶ瀬川水系河川整備基本方針の変更について（社会資本整備審議会河川分科会第110回河川整備基本方針検討小委員会
    > 資料2-2）](https://www.mlit.go.jp/river/shinngikai_blog/shaseishin/kasenbunkakai/shouiinkai/kihonhoushin/dai110kai/07_shiryou2-2_gokase.pdf)，令和3年5月21日，国土交通省水管理・国土保全局．

    1.  []{#_Toc506923980 .anchor}洪水流出モデルの定数の設定

＜考え方＞

+----------------------------------------------------------------------+
| 洪水流                                                               |
| 出モデルの諸定数は、通常、規模の小さい実績洪水から求めることが多いの |
| で、決定に当たっては不合理な結果とならないように注意する必要がある。 |
|                                                                      |
| また、諸定数                                                         |
| の決定に当たっては、実績洪水が生起した時点から計画時点に至る開発等に |
| よる流域条件の変化を十分加味する必要がある。特に流出率については流域 |
| の状況に応じ大きく変わるものであり、また、洪水流出量及び洪水のピーク |
| 流量に大きな影響を及ぼすものであるから、特に慎重な検討を必要とする。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 降雨を流量に変換するための洪水流出モデルの諸定                       |
| 数の決定に当たっては、次の事項について十分配慮することを基本とする。 |
|                                                                      |
| 1.  実績と計画の洪水規模の相違                                       |
|                                                                      |
| 2.  開発等による流域条件の変化                                       |
+----------------------------------------------------------------------+

＜例　示＞

+----------------------------------------------------------------------+
| 合理式法を用いる場合の                                               |
| 流出係数、及び洪水到達時間の算出に当たり使用する流入時間（流域の最遠 |
| 点から河道に到達するまでの時間）は以下の値を標準として定めてもよい。 |
|                                                                      |
| +----------------+-------------------------------+                   |
| | 〈流出係数〉   | 〈流入時間〉                  |                   |
| |                |                               |                   |
| | 密集市街地 0.9 | 山地流域 2km^2^ 30min         |                   |
| |                |                               |                   |
| | 一般市街地 0.8 | 特に急傾斜面流域 2km^2^ 20min |                   |
| |                |                               |                   |
| | 畑原野 0.6     | 下水道整備区域 2km^2^ 30min   |                   |
| |                |                               |                   |
| | 水田 0.7       |                               |                   |
| |                |                               |                   |
| | 山地 0.7       |                               |                   |
| +----------------+-------------------------------+                   |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  [河川砂防技術基準調査編](http://www.mlit.go.jp/river/shishin_guideline/gijutsu/gijutsukijunn/chousa/pdf/03.pdf)，平成26年4月，国土交通省水管理・国土保全局,第3章
    > 水文解析 第2節 流出解析.

＜参考となる資料＞

洪水流出モデルの定数設定と検証の例としては、下記の資料が参考となる。

1.  [大淀川水系河川整備基本方針
    > 基本高水等に関する資料（参考資料）](http://www.cgr.mlit.go.jp/ootagawa/plan3/pdf84/s2-1.pdf)5.新たな流出解析モデルの構築，平成28年7月，国土交通省水管理・国土保全局.

    1.  []{#_Toc506923981 .anchor}基本高水の設定

        1.  []{#_Toc506923982 .anchor}基本高水の設定の基本

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  基本高水は、本章2.7.2で選定する対象降雨について、本章2.6で構築した洪水流出モデルを用いて洪水のハイドログラフを求め、これを基に既往洪水、計画対象施設の性質等を総合的に考慮して設定することを基本とする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

+----------------------------------------------------------------------+
| 対象降雨を選定し、適当な洪水流出モデ                                 |
| ルを用いて洪水のハイドログラフを計算することは容易であるが、どのハイ |
| ドログラフを基に基本高水を決めるかについては慎重な検討が必要である。 |
|                                                                      |
| 対象降雨（群）の選定に当たっては、本章2.7.2で定めるように、対象      |
| 降雨の降雨量を気候変動による将来の降雨量の増加を考慮して設定し、地域 |
| 分布、時間分布等の検討を行い、引き伸ばし率2倍程度にする場合が多い。  |
|                                                                      |
| ハイドログラフの計算には                                             |
| 、ダム、遊水地等の洪水調節施設は存在しないものとし、発電ダム等の利水 |
| ダムについては、操作規程に従った洪水時の操作（ただし、事前放流は除く |
| こととし、ここでは河川の従前の機能の維持のために、ダムの設置に伴う下 |
| 流の洪水流量の増加を相殺する操作を対象とする）を考慮するものとする。 |
|                                                                      |
| 通常、地域分布、時間分布等の検討結果で不適                           |
| 切な降雨を棄却されているので、計算されたハイドログラフ群の中から、最 |
| 大流量となるハイドログラフのピーク流量を基本高水のピーク流量とする。 |
|                                                                      |
| 選定された基本高水の妥当性                                           |
| の評価として、気候変動予測モデルによる予測降雨波形から計算されたハイ |
| ドログラフ群を用いるものとする。さらに、観測値が存在する実績の洪水や |
| 過去に大規模な水害をもたらした洪水から高水流量（氾濫戻し流量）を再現 |
| し、基本高水のピーク流量と比較することで妥当性を検証する方法もある。 |
|                                                                      |
| また、流域面積の小さい河川で                                         |
| は合理式による値と比較を行う等により、基本高水のピーク流量を検証する |
| ことや、比流量を用いて、本支川バランス、上下流バランスや流域の気候特 |
| 性や計画規模が同規模の他河川とのバランスを考慮することが必要である。 |
|                                                                      |
| このほか、基本高水の決定方                                           |
| 法としては、降雨量のほか、降雨の地域分布及び時間分布を多くの資料から |
| 確率評価する等により計画規模に対するピーク流量を定める方法等がある。 |
+----------------------------------------------------------------------+

+----------------------------------------------------------------------+
| 基本高水の設定の過程は図2-2のようになる。                            |
|                                                                      |
| ![](media/image2.emf){width="5.446527777777778in"                    |
| height="3.7493055555555554in"}                                       |
|                                                                      |
| 3.  図2-2 基本高水の設定                                             |
+----------------------------------------------------------------------+

1.  []{#_Toc506923983 .anchor}対象降雨の設定

```{=html}
<!-- -->
```
1.  対象降雨の継続時間の設定

＜考え方＞

+----------------------------------------------------------------------+
| 対象降雨の                                                           |
| 継続時間は、流域の大きさ、洪水の継続時間、降雨の原因(台風性、前線性) |
| 等を検討すると同時に、対象施設の種類を考慮して定めるべきものである。 |
|                                                                      |
| ま                                                                   |
| た、必ずしも継続時間の検討に必要な資料が十分得られるとは限らないので |
| 、統計解析等の理由からやむを得ず1日から3日を採用してきた場合が多い。 |
|                                                                      |
| しかし、特に洪                                                       |
| 水の流域最遠点からの到達時間が数時間であるような河川においては、洪水 |
| のピーク流量に支配的な継続時間の降雨について別途検討する必要がある。 |
+----------------------------------------------------------------------+

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------------
  対象降雨の継続時間は、流域の大きさ、降雨の特性、洪水流出の形態、計画対象施設の種類、過去の資料の得難さ等を考慮して決定することを基本とする。
  ----------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

+----------------------------------------------------------------------+
| 洪水のピーク流量は、洪水到達時間内の降雨等の降雨特性に加え、流域の   |
| 地形、河川の状況等の影響を受ける。このため、雨量データによる確率から |
| の検討にあたって設定する対象降雨の継続時間は、洪水到達時間、過去の洪 |
| 水の降雨状況、流出特性等を総合的に検討のうえ設定することが望ましい。 |
|                                                                      |
| なお、流域の大きさや流域の形状等を踏まえ、洪水到                     |
| 達時間内の降雨が洪水のピーク流量に大きく影響すると考えられる場合には |
| 、洪水到達時間を重視し、対象降雨の継続時間を設定することが望ましい。 |
+----------------------------------------------------------------------+

＜例　示＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  対象降雨の継続時間を設定するに当たって、理論式等より求めた洪水到達時間、ピーク流量とピーク流量生起時刻から遡る短時間雨量との相関関係、主要洪水における強い降雨強度の継続時間を整理し、各手法の結果を包絡できる時間を降雨継続時間として設定した事例がある。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜参考となる資料＞

対象降雨の継続時間の設定の例としては、下記の資料が参考となる。

1.  [大淀川水系河川整備基本方針
    > 基本高水等に関する資料（参考資料）](http://www.mlit.go.jp/river/shinngikai_blog/shaseishin/kasenbunkakai/shouiinkai/kihonhoushin/dai108kai/s3.pdf)6.基本高水のピーク流量の設定
    > 6.3大淀川流域の対象降雨の降雨継続時間の設定，平成28年7月，国土交通省水管理・国土保全局.

```{=html}
<!-- -->
```
2.  対象降雨の降雨量の設定

＜標　準＞

+----------------------------------------------------------------------+
| 対象降雨の降雨量は、計画の規模（本章2.4.1）を定め                    |
| 、さらに、降雨継続時間を定めることによって決定することを基本とする。 |
|                                                                      |
| また、温暖化による将来の降雨量の増加を反映するため                   |
| に、実績降雨データを用いた確率統計解析により得られた確率雨量に2℃上昇 |
| 時の降雨量変化倍率（現在気候と将来気候との降雨量の比）を乗じることで |
| 対象降雨の降雨量を定めることを基本とする。なお、降雨量変化倍率を用い |
| る場合は、既に温暖化の影響を含んでいる可能性がある近年の実績降雨デー |
| タを確率統計解析に用いる標本の対象としないことに留意する必要がある。 |
+----------------------------------------------------------------------+

＜例　示＞

+----------------------------------------------------------------------+
| 実績降雨データを用いた確                                             |
| 率統計解析により得られた確率雨量に2℃上昇時の降雨量変化倍率を乗じるこ |
| とで、河川整備基本方針で定める対象降雨の降雨量を設定した事例がある。 |
|                                                                      |
| ここで、用いた2℃上昇時の降雨量変                                     |
| 化倍率は、気候変動を踏まえた治水計画に係る技術検討会において、気候変 |
| 動予測モデル等を用いた影響分析結果を踏まえ定められた値であり、現在気 |
| 候（20世紀末の気候）と将来気候（21世紀末の気候）における確率雨量の比 |
| である。その地域ごとの2℃上昇時の降雨量変化倍率は以下のとおりである。 |
|                                                                      |
| +--------------------+------------------------------+                |
| | 〈地域区分〉       | 〈2℃上昇時の降雨量変化倍率〉 |                |
| |                    |                              |                |
| | 全国（北海道除く） | 1.1倍                        |                |
| |                    |                              |                |
| | 北海道             | 1.15倍                       |                |
| +--------------------+------------------------------+                |
|                                                                      |
| また、確率雨量は、降雨                                               |
| 量変化倍率の前提としている現在気候の期間が2010年までであることを踏ま |
| え、2010年までの雨量標本を用い定常の確率統計解析により算定している。 |
+----------------------------------------------------------------------+

＜関連通知等＞

対象降雨の降雨量の設定に際しての確率統計解析については1)，降雨量変化倍率の活用については2)，それぞれの関連通知がある。

1.  [河川砂防技術基準調査編](http://www.mlit.go.jp/river/shishin_guideline/gijutsu/gijutsukijunn/chousa/pdf/03.pdf)，平成26年4月，国土交通省水管理・国土保全局,第3章
    > 第1節 水文統計解析.

```{=html}
<!-- -->
```
4.  [特定都市河川浸水被害対策法等の一部を改正する法律の施行（６ヶ月以内施行）について](https://www.mlit.go.jp/river/kasen/ryuiki_hoan/pdf/r306/shiryo12.pdf)，令和3年11月1日，国土交通省都市局長、水管理・国土保全局長、住宅局長，第四　河川法施行令関係，p50-53．

＜参考となる資料＞

対象降雨の降雨量の設定の例としては、下記の資料が参考となる。

1.  [新宮川水系河川整備基本方針
    > 基本高水等に関する資料](https://www.mlit.go.jp/river/basic_info/jigyo_keikaku/gaiyou/seibi/pdf/shingu/1-04_shingu_takamizu_R310.pdf)（参考資料）1.基本高水の検討，令和3年10月，国土交通省水管理・国土保全局.

```{=html}
<!-- -->
```
5.  [五ヶ瀬川水系河川整備基本方針
    > 基本高水等に関する資料（参考資料）](https://www.mlit.go.jp/river/basic_info/jigyo_keikaku/gaiyou/seibi/pdf/gokase/2-04_gokase_takamizu_R310_v2.pdf)1.基本高水の検討，令和3年10月，国土交通省水管理・国土保全局.

    2℃上昇時及び4℃上昇時の降雨量変化倍率の算定に関する資料は下記が参考となる。

6.  気候変動を踏まえた治水計画のあり方 提言，令和 3 年 4
    > 月改訂，気候変動を踏まえた治水計画に係る技術検討会（気候変動を踏まえた治水計画に係る技術検討会）．

```{=html}
<!-- -->
```
3.  対象降雨の時間分布及び地域分布の設定

＜標　準＞

  -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  対象降雨の降雨量の時間分布及び降雨量の地域分布は、既往洪水等を検討して選定した相当数の降雨パターンについて、その降雨量を本章2.4.1によって定められた計画の規模に等しくなるように定めることを基本とする。この場合において、単純に引き伸ばすことによって著しく不合理が生ずる場合には、修正を加えることを基本とする。
  -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

+----------------------------------------------------------------------+
| 対象降雨の降雨量が与えられた場合に                                   |
| は、残りの2要素、すなわち、その時間分布及び地域分布を定めて、対象降  |
| 雨を選定する。この場合の考え方としては大別して次の2つの方法がある。  |
|                                                                      |
| 1.  対象降雨の3要素、すなわち、降雨量、降雨量の時間分布及び降雨量の  |
| 地域分布相互間の統計的若しくは気象学的な関係を明らかにして、降雨量が |
| 与えられた場合の時間分布及び地域分布をその関係に基づいて定める方法。 |
|                                                                      |
| 2.  降雨量を定めた後に、過去に生起した幾つかの降雨パターンをそのま   |
| ま伸縮して時間分布と地域分布を作成し、それらがこれら要素間の統計的な |
| 関係からみて特に生起し難いものであると判断されない限り採用する方法。 |
|                                                                      |
| 一般的に通常後者を用いる方が単純                                     |
| でわかりやすいが、既往の降雨の選定に当たっては、大洪水をもたらしたも |
| のやその流域において特に生起頻度の高いパターンに属する降雨を落とさな |
| いよう注意しなければならない。選定すべき降雨の数はデータの存在期間の |
| 長短に応じて変化するが、その引き伸ばし率は2倍程度にする場合が多い。  |
+----------------------------------------------------------------------+

＜例　示＞

+----------------------------------------------------------------------+
| 降雨量を                                                             |
| 引き伸ばすことによって生ずる不合理なこととは、地域分布に大きな隔たり |
| がある降雨や、時間的に高強度の雨量の集中が見られる降雨において、その |
| 河川のピーク流量に支配的な継続時間における降雨強度が対象降雨のそれと |
| の間で、超過確率の値において著しい差異を生ずる場合があることである。 |
|                                                                      |
| 具体的な対象降雨の選定手法としては次のような例が考えられる。         |
|                                                                      |
| 1.  地域分布に大きな偏りがある降雨                                   |
| を引き伸ばした結果、流域の一部地域での降雨量が著しく大きくなり、当該 |
| 一部地域の降雨の超過確率が、計画規模の超過確率に対して著しく差異があ |
| るような場合には、対象降雨として採用することが不適当であると考えられ |
| るため、当該降雨パターンの引き伸ばし降雨を対象降雨から棄却すること。 |
|                                                                      |
| 2.  短時間に降雨が比較的集中しているパターンを                       |
| 引き伸ばした結果、洪水のピーク流量に支配的な影響を及ぼす降雨継続時間 |
| 内での降雨強度の超過確率が、計画規模の超過確率に対して著しく差異があ |
| るような場合には、対象降雨として採用することが不適当であると考えられ |
| るため、当該降雨パターンの引き伸ばし降雨を対象降雨から棄却すること。 |
|                                                                      |
| 3.  上記１                                                           |
| ）及び２）の降雨パターンについて、地域分布や時間分布に修正を加え、超 |
| 過確率の著しい差異を是正することにより、対象降雨として採用すること。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

地域分布及び時間分布の評価・棄却の方法については、下記の資料が参考となる。

1.  [大淀川水系河川整備基本方針
    > 基本高水等に関する資料（参考資料）](http://www.mlit.go.jp/river/shinngikai_blog/shaseishin/kasenbunkakai/shouiinkai/kihonhoushin/dai108kai/s3.pdf)6.基本高水のピーク流量の設定
    > 6.6対象降雨の地域分布及び時間分布の検討，平成28年7月，国土交通省水管理・国土保全局.

```{=html}
<!-- -->
```
4.  実績降雨と対象降雨との継続時間の調整

＜標　準＞

+----------------------------------------------------------------------+
| 本章2.7.2(3)において選定された実績降雨の継続時間が対象降雨のそれと   |
| 異なる場合には、その長短に応じて次のように調整することを基本とする。 |
|                                                                      |
| 1.  実績降雨の継続時間が対象降雨のそ                                 |
| れよりも短い場合、実績の継続時間はそのままにして、降雨量のみを対象降 |
| 雨の降雨量にまで引き伸ばす。ただし、この場合において、本章2.7.2 (3)  |
|     > 1)                                                             |
|     >                                                                |
| で述べたような不合理が生ずる場合には、その範囲において修正を加える。 |
|                                                                      |
| 2.  実績降雨の継続時間が対象降雨のそれよりも長い場合、１）と         |
| 同様の取扱いとするが、引き伸ばし後の一連の降雨量が対象降雨の降雨量に |
| 比較して相当に大きくなる場合には、対象降雨の継続時間に相当する時間内 |
| 降雨量のみを引き伸ばし、それ以前の降雨は実績の降雨をそのまま用いる。 |
+----------------------------------------------------------------------+

＜例　示＞

+----------------------------------------------------------------------+
| 本章2.7.2(3)において選定された実績降雨の継続時間が対象降             |
| 雨のそれに一致することは極めてまれである。しかしながら、本章2.4.1に  |
| おいて対象降雨の規模を決定する場合に用いる資料にしても、対象降雨の継 |
| 続時間に一致する継続時間の降雨ではないのが普通であるから、通常の場合 |
| は何ら調整をする必要はない。ただし、実績の降雨継続時間が対象降雨のそ |
| れに比較して相当に長く、しかも引き伸ばした後の降雨量が対象降雨の降雨 |
| 量に比較して相当に大きい場合には調整をしなければ不合理な結果となる。 |
|                                                                      |
| この場合においては、図2-3に示すように、一連                          |
| の降雨中の主体とみなされる部分を中心において、対象降雨継続時間に相当 |
| する時間内の降雨量が対象降雨の降雨量に等しくなるように引き伸ばし、対 |
| 象降雨の前に接続して存在する降雨については、実績降雨をそのまま用いる |
| ことを原則とする。調整の方法としては、このほかに種々の方法が考えられ |
| るが、河川計画においては他の河川との比較が必要となる場合が多いので1  |
| つの方法に統一することとした。ただし、洪水調節施設の計画が予想される |
| 場合については前後の降雨を含めた一連の降雨に検討を加える必要がある。 |
|                                                                      |
| ![](media/image3.emf){width="3.4153991688538934in"                   |
| height="4.174419291338583in"}                                        |
|                                                                      |
| 4.  図2-3 降雨継続時間の調整                                         |
+----------------------------------------------------------------------+

1.  []{#_Toc102011390 .anchor}総合判断による基本高水の設定

＜考え方＞

+----------------------------------------------------------------------+
| 気候変動                                                             |
| の影響を反映した基本高水は、2.7.2(1)～(4)によって継続時間、降雨量、  |
| 時間分布および地域分布の設定を行った対象降雨（群）を用い、洪水流出モ |
| デルにより降雨から流量へ変換されたハイドログラフ（群）から選定する。 |
|                                                                      |
| 一方、このハイドログラフ（群）には、実績降雨波形を対象に、その       |
| 継続時間内の降雨量を対象降雨の降雨量になるよう人為的に引き伸ばすこと |
| で、その後に時間分布、地域分布の検証プロセスを経たとしても、生起し難 |
| いと考えられる尖鋭的な降雨波形によるハイドログラフが含まれる場合や、 |
| 逆に、実績降雨波形の数が少ないこと等が原因となり治水計画を検討する上 |
| で考慮すべきハイドログラフが不足する場合がある。このため、基本高水の |
| 選定にあたり、様々な観点から、その妥当性を評価することが必要となる。 |
|                                                                      |
| これまで、対象降雨の降雨量に対する基本高水は、観測流量データに定常性 |
| を仮定した複数の統計解析手法を適用して得られた確率流量や、過去に大規 |
| 模な水害をもたらした洪水の高水流量（氾濫戻し流量）等を用いて、基本高 |
| 水のピーク流量の妥当性についての検証を行った上で設定されてきた。しか |
| し、この方法では、将来の気候変動による影響を考慮することができないた |
| め、別途の手法による評価が必要である。例えば、気候変動予測モデルから |
| 得られた降雨波形のうち、対象降雨の降雨量相当の予測降雨波形によるハイ |
| ドログラフ群等を用い、総合的に判断して基本高水を設定する方法がある。 |
+----------------------------------------------------------------------+

＜例　示＞

+----------------------------------------------------------------------+
| 気候変動の影響を反映した基本                                         |
| 高水は、実績降雨を対象降雨の降雨量（2.7.2(2)）へ引き伸ばすことで得ら |
| れる対象降雨（群）を用い、洪水流出モデルにより降雨から流量へ変換され |
| たハイドログラフ（群）から設定し、それらの中から、最大流量となるハイ |
| ドログラフのピーク流量を基本高水のピーク流量と設定している例がある。 |
|                                                                      |
| 設定された基本高水のピ                                               |
| ーク流量の妥当性の評価にあたっては、将来起こり得る事象として気候変動 |
| 予測モデルによる予測降雨波形の時空間分布を用いた検討結果を活用する。 |
|                                                                      |
| 例えば                                                               |
| 、気候変動予測モデルによる予測降雨波形を用いた検討として、図2-4に示  |
| すように、引き伸ばし等により降雨波形を大きく歪めることがないよう、対 |
| 象降雨の降雨量相当におけるアンサンブル計算による予測降雨波形から計算 |
| されたハイドログラフ群のピーク流量の最大値と最小値の範囲内に決定する |
| 基本高水のピーク流量が収まっているかどうか等の検証を行った例がある。 |
|                                                                      |
| ![](media/image4.emf){width="5.231944444444444in"                    |
| height="3.203472222222222in"}                                        |
|                                                                      |
| 図2-4気候変動予測モデルによる予測降雨波形を用いた検討                |
+----------------------------------------------------------------------+

＜参考となる資料＞

気候変動による降雨量の増加を考慮した基本高水の設定手法の考え方については下記の資料1)、また、気候変動による降雨量の増加を考慮した基本高水の設定事例は下記の資料2)，3)が参考となる。

> 1)[気候変動を踏まえた新たな河川整備基本方針の策定（社会資本整備審議会河川分科会第109回河川整備基本方針検討小委員会
> 資料2）](https://www.mlit.go.jp/river/shinngikai_blog/shaseishin/kasenbunkakai/shouiinkai/kihonhoushin/dai109kai/04_shiryou2_aratanahoushin.pdf),
> 令和3年3月31日，国土交通省水管理・国土保全局．
>
> 2\)
> [新宮川水系河川整備基本方針の変更について（社会資本整備審議会河川分科会第110回河川整備基本方針検討小委員会
> 資料2-1）](https://www.mlit.go.jp/river/shinngikai_blog/shaseishin/kasenbunkakai/shouiinkai/kihonhoushin/dai110kai/06_shiryou2-1_shingu.pdf)，令和3年5月21日，国土交通省水管理・国土保全局．
>
> 3\)
> [五ヶ瀬川水系河川整備基本方針の変更について（社会資本整備審議会河川分科会第110回河川整備基本方針検討小委員会
> 資料2-2）](https://www.mlit.go.jp/river/shinngikai_blog/shaseishin/kasenbunkakai/shouiinkai/kihonhoushin/dai110kai/07_shiryou2-2_gokase.pdf)，令和3年5月21日，国土交通省水管理・国土保全局．

2.  []{#_Toc506923984 .anchor}内水の考慮

＜考え方＞

+----------------------------------------------------------------------+
| 河川の下流部や盆地等において、基本高                                 |
| 水のピーク流量の設定にあたって内水の排水量を無視できない場合がある。 |
|                                                                      |
| この場合には既                                                       |
| に存在する内水排除計画を考慮するほか、現在具体的な排水構想がない場合 |
| でも、将来の当該区域の開発状況の想定、他の類似区域の排水計画等を参考 |
| にして、必要に応じ適切な排水量を基本高水算定時に加算する必要がある。 |
+----------------------------------------------------------------------+

＜標　準＞

  ----------------------------------------------------------------------------------
  内水の影響が大きいと考えられる場合には、別途その影響を考慮することを基本とする。
  ----------------------------------------------------------------------------------

＜例　示＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  基本高水算定時に加算する排水量の算定方法としては、内水解析モデルにより排水量を算定する方法や、比流量で都市区域5㎥/s/km^2^程度、一般区域2㎥/s/km^2^程度とする方法がある。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------

3.  []{#_Toc506923985 .anchor}基本高水を見直す場合の考え方

＜考え方＞

+----------------------------------------------------------------------+
| 基本高水は、長期的な観点で策定される洪水防御計画の基本となるもので   |
| あるから、変動する毎年のデータを用いて頻繁に見直すことは適切でない。 |
|                                                                      |
| しかし、計画策定以降に観測された洪水                                 |
| 流量がこれまでの計画を上回っている場合等、近年の洪水の状況や気候変動 |
| の影響を踏まえ、必要に応じて、洪水の生起要因や現象等を分析し、既定計 |
| 画に位置づけられている基本高水の見直しの検討を行うことが重要である。 |
+----------------------------------------------------------------------+

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------
  超過洪水が発生した場合等、必要に応じて、近年の洪水の発生状況等を踏まえた基本高水の見直しの検討を行うことを基本とする。
  ------------------------------------------------------------------------------------------------------------------------

＜例　示＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------
  基本高水のピーク流量を上回る規模の洪水が発生したことを受け、洪水特性等を踏まえ基本高水のピーク流量の見直し等を含む河川整備基本方針の変更を実施した例がある。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------

＜参考となる資料＞

基本高水を見直した例としては、基本高水のピーク流量を超過する洪水が発生し、気候変動の影響を考慮した新たな河川整備基本方針へと変更した、新宮川水系や五ヶ瀬川水系の下記の資料が参考となる。

1.  [新宮川水系河川整備基本方針の変更について（社会資本整備審議会河川分科会第110回河川整備基本方針検討小委員会
    > 資料2-1）](https://www.mlit.go.jp/river/shinngikai_blog/shaseishin/kasenbunkakai/shouiinkai/kihonhoushin/dai110kai/06_shiryou2-1_shingu.pdf)，令和3年5月21日，国土交通省水管理・国土保全局．

```{=html}
<!-- -->
```
26. [五ヶ瀬川水系河川整備基本方針の変更について（社会資本整備審議会河川分科会第110回河川整備基本方針検討小委員会
    > 資料2-2）](https://www.mlit.go.jp/river/shinngikai_blog/shaseishin/kasenbunkakai/shouiinkai/kihonhoushin/dai110kai/07_shiryou2-2_gokase.pdf)，令和3年5月21日，国土交通省水管理・国土保全局．

    1.  []{#_Toc506923986 .anchor}計画高水流量に関する事項

        1.  []{#_Toc506923987 .anchor}計画高水流量の定義

＜考え方＞

+----------------------------------------------------------------------+
| 1つ又は複数の基本高水から算出される計画基準点やその他主              |
| 要な地点での河道流量は、河道の特性やダム等の規模等の水理学的条件によ |
| りそれぞれ異なるものであり、基本高水を合理的に河道、洪水調節施設等に |
| よる洪水調節に配分するとは、算出されたこれらの流量を上下流や本支川間 |
| のバランスに考慮しつつ、本章2.8.2に記載した事項についての検討を行っ  |
| た上で、河道や洪水調節施設等による洪水調節に配分することを意味する。 |
|                                                                      |
| 河道及び                                                             |
| 洪水調節施設等の計画には、その地点の高水流量が第一義的に重要である。 |
| ただし、ダムの洪水調節容量の決定においては、高水流量のみでなく、ハイ |
| ドログラフの形状、貯水池容量確保の可能性、ダムの操作ルール等が関係す |
| るので、これらの要素を総合的に検討して計画を立てることが重要である。 |
|                                                                      |
| なお、「洪水調節施設等による洪水調節」の「等」には、将来の降雨予測   |
| 技術の向上や操作ルールの変更、施設改良等を想定し、計画高水流量の設定 |
| に用いる降雨に対し、利水ダム等の事前放流により確保可能な容量も含む。 |
| これは、河川管理者による河川の管理行為の一環として、治水上の必要性か |
| ら治水協定の協議・締結等を通じて実施するものであり、操作規程への位置 |
| づけ等を行うことで、洪水調節施設による洪水調節と同等の扱いとされる。 |
|                                                                      |
| 気候変動を踏まえ設定された基本高水に対し、                           |
| 上下流・本支川の背後地の人口・資産の集積状況や土地利用状況等の現況及 |
| びその将来動向、並びに河川環境との調和や維持管理の観点を踏まえ、河道 |
| の洪水の貯留機能の向上と相まって流下能力の向上を図るよう、改めて、河 |
| 道の平面形や縦断形、川幅等を設定（詳細は、施設配置等計画編第2-1章第  |
| 1節河道計画を参照）することが重要である。また、上流区間と下流区間で  |
| 河川管理者が異なる場合は相互調整及び連携を図り、本川のみならず上流区 |
| 間や支川も含め、地形特性による遊水機能を有する沿川背後地における遊水 |
| 地の整備が流域全体及び当該地域の治水安全度向上に資する場合は、これら |
| による洪水調節機能等も考慮して計画高水流量を設定することが望ましい。 |
+----------------------------------------------------------------------+

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  洪水防御に関する計画においては、基本高水を合理的に河道、ダム等に配分して、主要地点の河道、ダム等の計画の基本となる高水流量を決定するものとする。これを計画高水流量という。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------

2.  []{#_Toc506923988 .anchor}計画高水流量の決定に際し検討すべき事項

＜標　準＞

+----------------------------------------------------------------------+
| 河道、ダム、遊水地等の計画高水流量を                                 |
| 決定するに際しては、次の各事項について十分検討することを基本とする。 |
|                                                                      |
| 1.  ダム、調節池、遊水地といった洪                                   |
| 水調節施設の設置の技術的、経済的、社会的及び環境保全の見地からの検討 |
|                                                                      |
| 2.  河道については、現河道改修、捷水路、放水路、派川へ               |
| の分流等についての技術的、経済的、社会的及び環境保全の見地からの検討 |
|                                                                      |
| 3.  河川沿川における現在及び将来における土地利                       |
| 用の状況及び河川に関連する他事業との計画の調整についての諸問題の検討 |
|                                                                      |
| 4.  著しく市街化の予想される区域について                             |
| は、将来における計画高水流量の増大に対する見通しとその対処方針の検討 |
|                                                                      |
| 5.  超過洪水に対する対応の技術的、経済的、社会的検討                 |
|                                                                      |
| 6.  事業実施の各段階における施設の効果の検討                         |
|                                                                      |
| 7.  改修後における維持管理の難易についての検討                       |
+----------------------------------------------------------------------+

＜関連通知等＞

沿川の土地利用の現状及び将来の見通しを踏まえた河川整備については1)の関連通知がある。

1.  [特定都市河川浸水被害対策法等の一部を改正する法律の施行（６ヶ月以内施行）について](https://www.mlit.go.jp/river/kasen/ryuiki_hoan/pdf/r306/shiryo12.pdf)，令和3年11月1日，国土交通省都市局長、水管理・国土保全局長、住宅局長，第四　河川法施行令関係，p50-53．

    1.  []{#_Toc102011396 .anchor}超過洪水対策

＜考え方＞

+----------------------------------------------------------------------+
| 堤防は計画高水位（高潮区間に当たっては計画                           |
| 高潮位）以下の水位の流水の通常の作用に対して安全な構造を持つものとし |
| て整備されるが、洪水は自然現象である降雨等に起因するものであるため、 |
| 計画高水流量を超える超過洪水が発生する可能性は常に存在する。そのよう |
| な超過洪水が発生した場合には越水等により堤防が破堤し、極めて甚大な被 |
| 害が発生するおそれがある。特に人口・資産や中枢管理機能等が高密度に集 |
| 積した大都市地域等を守る堤防の破堤は、当該地域に甚大な被害を及ぼすだ |
| けでなく、我が国全体の社会・経済にも大きな打撃をもたらすことになる。 |
|                                                                      |
| こ                                                                   |
| のため、河川整備基本方針及び河川整備計画においては、それぞれ、超過洪 |
| 水や現況施設能力を上回る洪水の生起についても配慮し、一定規模の洪水の |
| 氾濫を防止し、**必要に応じそれを超える洪水に対する被害を軽減するため |
| の**施設による対応やソフト施策など計画するものであるが、特に必要な区 |
| 間については超過洪水対策として高規格堤防の整備を計画するものとする。 |
+----------------------------------------------------------------------+

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------
  計画の規模を超える洪水により、甚大な被害が予想される河川については、必要に応じて超過洪水対策を計画することを基本とする。
  --------------------------------------------------------------------------------------------------------------------------

2.  []{#_Toc103783538
    .anchor}河川の適正な利用及び流水の正常な機能の維持に関する基本的な事項

    1.  []{#_Toc103783539 .anchor}総説

＜考え方＞

河川の適正な利用及び流水の正常な機能の維持に関する基本的な事項は、河川の総合的管理の一環として、平常時の河川の適正な管理が確保できるように定めるものである。

流水の正常な機能を維持するために必要な流量は、河川水の利用の現状、河川環境の現状等を十分に把握し、流域の自然環境や社会環境及びそれらの歴史的な経緯等を踏まえ定めるものとする。

> 流水の正常な機能を維持するために必要な流量を確保するための方策の策定に当たって

は、ダム等の施設計画を検討するとともに、水利用の合理化等のソフト施策や既存施設の

有効利用についても十分に検討するものとする。

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  河川の適正な利用及び流水の正常な機能の維持に関する基本的な事項は、河川の適正な管理を行うために定めるものであり、流水の正常な機能を維持するために必要な流量を設定するとともに、この流量を確保するための方策を、治水機能との整合を図りながら定めるものとする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜必　須＞

＜推　奨＞

当該方策は原則として１０ヶ年第１位相当の渇水時においても流水の正常な機能を維持するために必要な流量が確保できるよう設定するものとする。

> この計画規模を超える異常渇水時の対策についても、必要に応じて検討することが望ま
>
> しい。

2.  []{#_Toc103783540 .anchor}正常流量

＜考え方＞

流水の正常な機能を維持するために必要な流量は、年間を通じて確保されるべき流量であり、流量の変動にも配慮して定めるべきものである。

正常流量を設定する地点は、低水管理を適切に行うための基準となる地点として、本川及び主要な支川に１ないし複数設定する。

正常流量は、当該河川における流入量及び取水量等を整理し、地点間の水収支を検討した上で、区間ごとの維持流量と地点ごとの水利流量を満足する流量として設定する。

> 正常流量の設定に当たっては、維持流量及び水利流量それぞれの年間の変動パターンを
>
> 考慮して期間区分を行い、その区分に応じて正常流量を設定するものとする。

＜必　須＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  正常流量とは、舟運、漁業、観光、流水の清潔の保持、塩害の防止、河口の閉塞の防止、河川管理施設の保護、地下水位の維持、景観、動植物の生息・生育・繁殖地の状況、人と河川との豊かな触れ合いの確保等を総合的に考慮して定められた流量（以下「維持流量」という。）及びそれが定められた地点より下流における流水の占用のために必要な流量（以下「水利流量」という。）の双方を満足する流量であって，適正な河川管理のために基準となる地点において定めるものをいう。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

> 正常流量を設定する地点は、既往の水文資料が十分に備わり、平常時においてもほかの
>
> 流量観測地点との流量相関が良いか、又はその上下流の水収支が明確に把握されており
>
> 河川利用が行われている地域に近接している地点であることが望ましい。

3.  []{#_Toc103783541 .anchor}維持流量の設定

＜考え方＞

維持流量は、舟運、漁業、観光、流水の清潔の保持、塩害の防止、河口の閉塞の防止、河川管理施設の保護、地下水位の維持、景観、動植物の生息・生育・繁殖地の状況、人と河川との豊かな触れ合いの確保等を総合的に考慮して定めるべきものである。

これらのうち観光については景観や舟運等の項目が満たされれば、概ね満足されるものと考えられる。また人と河川との豊かな触れ合いについては、舟運、漁業、流水の清潔の保持、景観、動植物の生息・生育環境の状況等から求まる流量が維持されることで、おおむね満足されるものと考えられる。

このようなことから維持流量は、観光、人と河川との豊かな触れ合いの確保を除く９項目を総合的に考慮して定めれば良い場合が多い。

> 維持流量の設定に当たっては、上記の項目によっては、施設の設置や改良等の対策による
>
> 対応も考えられ、必ずしも流量の確保による対応が得策でない場合もあることから、施設
>
> の設置や改良等の対策による対応も併せて検討し、適切な維持流量を設定する必要があ
>
> る。

＜標　準＞

  ------------------------------------------------------------------------------------------
  維持流量は，河川を類似した特性を持つ区間に区分し，各区間ごとに設定することを基本とする。
  ------------------------------------------------------------------------------------------

＜推　奨＞

維持流量は、必要に応じ、期間区分を行い、その区分に応じて設定するものとする。

> 維持流量の設定に当たっては、流量の変動にも配慮することが望ましい。

＜例　示＞

維持流量は、観光、人と河川との豊かな触れ合いの確保を除く下記９項目（舟運、漁業、流水の清潔の保持、塩害の防止、河口の閉塞の防止、河川管理施設の保護、地下水位の維持、景観、動植物の生息・生育・繁殖地の状況）を総合的に考慮して定めれば良い場合が多い。

これら9項目のほかにも、当該河川の実情に応じて考慮が必要となる項目が考えられる場合には、その項目も含めて検討を行う必要がある。

以下に示す設定要素は、自然的、社会的要因等により縦断的に変化するため、維持流量の設定に当たっては、その縦断的特性を踏まえ、あらかじめ河川を複数の区間に区分し、各々の区間において維持流量を設定する。

河川区分は、河川の形態、支川の流入、河道状況、動植物の生息・生育・繁殖分布の状況、河川水質、及び河川の利用等を総合的に勘案して行うものとする。

維持流量の検討項目には、その項目や対象河川の特性により機能維持に必要な流量が期別に異なる場合もある。このため、維持流量の設定に当たって期間区分の必要性を検討し、必要な場合は、項目別の必要流量の期別パターンを考慮して期間区分を行い、その区分に応じて維持流量を設定するものとする。

１．舟運

> 舟運はもともと渇水時の運休も含め、自然の流行変動がある中で行われてきたものである。渇水時に短期間運休したとしても、陸上交通等による代替手段で補うことも考え
>
> られ、流況回復後は速やかに通常の運航に復することが可能である。
>
> しかし、輸送量の大小や代替手段の有無など、地域によっては物流・交通機関としての公共性がかなり高い場合も考えられる。また、多くの観光客を集めたり、歴史性の高い舟運についても同様に公共性は高い。このような場合においては、対象を限定した上で、一定の流量（水面幅、水深）の確保が必要であると考えられる。

２．漁業

> 漁業からの必要流量は、通常「動植物の生息・生育・繁殖地の状況」からの必要流量により満足されると考えられる。しかし、ノリの養殖等特殊な条件からの検討が必要な河川の場合には、別途検討することが必要である。

３．流水の清潔の保持

> 流水の減少による水質の悪化がある場合は、これを抑制することが必要である。本来、河川の水質は流域における汚濁現対策により良好に保つべきであり、必要流量の検討に際しては、まず流域における流出負荷量の削減を進めるべきである。しかし、そのような対策のみによっては良好な水質の確保が難しい場合もあるので、流量増による対応の可能性も考えていく必要がある。

４．塩害の防止

> 塩害の防止からの必要流量は、円錐の遡上による河川での漁業、生態系への影響と川から取水している各種用水や地下水の塩分濃度上昇による上水道・農業への影響が大きく及ぶことがあるから、これを避けるため、一定の流量を確保することを目的として設定する。

５．河口の閉塞の防止

> 河口閉塞が恒常化していたり、それが予想されるような河川では、一定の流量を確保する必要がある。

６．河川管理施設の保護

> 流量が減少することによる水位の低下によって、木製の施設（護岸の基礎や杭柵）等が不足したりすることが無いよう一定の流量を確保する必要がある。

７．地下水位の維持

> 河川の流量の減少が地下水位の低下及び地下水涵養量に直接影響し、その影響が大きい場合には、一定以上の流量を確保する必要がある。

８．景観

> 景観からの必要流量は、視覚的な満足感を得られるような流量を保つことが目的である。河川景観においては、自然の流況変動の中で生じる渇水も河川景観の一つであるが、大規模な取水に伴う流量の減少によって、賓吐くな河川景観を恒常化させることは、快適な生活環境の確保にとって好ましくない。
>
> 特に景勝地・観光地や河川と係りの深い行事の行われる場所などで流量の変動により景観が大きく変化する場合には、広く親しまれた河川景観を維持するため、一定以上の流量を確保する必要がある。

９．動植物の生息・生育・繁殖地の状況

> 動植物の生息・生育・繁殖地の状況からの必要流量は、河川における動植物の生息・生育・繁殖環境を維持できる流量を保つことが目的である。河川においては流量の変動の下に動植物にとっての多様な生物・生息・繁殖環境が形成されており、自然の渇水もこの変動の要素であるが、大規模な取水による流量の減少は動植物の生息・生育・繁殖環境を著しく悪化させる。
>
> 特に、動植物の生息・生育・繁殖環境が流量の減少によって大きく変わると考えられる瀬やワンド等において、生息・生育条件を保つことができる一定以上の流量を確保する必要がある。

4.  []{#_Toc103783542 .anchor}水利流量の設定

＜考え方＞

水利流量は、流水の占用のために河川に確保すべき流量であり、各取水地点において所要の水量を取水する必要な水位、水量等を把握して検討されるものである。このうち、取水位の維持については、堰の設置、取水施設の改良等を併せて検討する必要がある。

水利流量の設定に当たっては、許可水利権及び慣行水利権を踏まえて、河川に確保すべき流量を検討する。

検討に当たっては、許可水利使用のみならず慣行水利使用についてもその実態を十分に調査し、その目的、水量、仕様の機関等を明らかにしなければならない。

水利流量は当該河川での水利使用の実態の変化に応じて、適宜見直し、検討を行うことが必要である。

> 水利流量の設定に当たっては、各種水利使用の取水位置及び取水量等を縦断的に整理
>
> し、適正な地点を選定し、それぞれの地点において設定するものとする。

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------
  水利流量は、河川の水利使用の実態を踏まえて、適正な地点を選定し、それぞれの地点ごとに設定することを基本とする。
  ----------------------------------------------------------------------------------------------------------------

＜推　奨＞

水利流量は、必要に応じ、年間の水利使用パターンを考慮して期間区分を行い、その区分に応じて設定するものとする。

＜関連通知等＞

1.  正常流量検討の手引き（案），平成19年9月，国土交通省河川局.

    2.  []{#_Toc103783543
        .anchor}河川環境の整備と保全に関する基本的な事項

        1.  []{#_Toc103783544 .anchor}総説

＜考え方＞

> 近年、豊かでゆとりのある質の高い国民生活や良好な環境を求める国民ニーズの増大に
>
> 伴い、河川は、治水、利水の役割を担うだけでなく、潤いのある水辺空間や動植物の良好
>
> な生息・生育・繁殖環境として、また、地域の風土と文化を形成する重要な要素として期
>
> 待されるようになってきている。このため、多自然川づくりの考え方を踏まえ、動植物の
>
> 良好な生息・生育・繁殖環境の保全・創出、良好な景観の保全・創出、人と河川との豊か
>
> な触れ合い活動の場の保全・創出、良好な水質の保全といった国民のニーズの増大に応え
>
> るべく治水、利水に加え、「河川環境の整備と保全」に関する基本的な事項を定める必
>
> 要がある。特に、災害後の復旧は河川環境に大きな影響を与えるため、「美しい山河を守
>
> る災害復旧基本方針」をもと適切に検討することが重要である。

また、河川環境の整備と保全に関する基本的な事項は、「第２節　洪水防御計画に関する基本的な事項」、「第３節　河川の適正な利用及び流水の正常な機能の維持に関する基本的な事項」を検討する際に、一体的に検討することが必要である。

> 河川環境の整備と保全を図るに当たっては、河川全体の自然の営みを視野に入れた多
>
> 自然づくりに取り組むとともに、流域へと視点を拡げ、流域の農地や緑地などにおける取
>
> 組と連携することにより、河川やこれと連続性を有する水域を基軸とした生態系ネットワ
>
> ークの形成を進めることが重要である。

＜必　須＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  河川環境の整備と保全に関する基本的な事項は、動植物の良好な生息・生育・繁殖環境の保全・創出、良好な景観の保全・創出、人と河川との豊かな触れ合い活動の場の保全・創出、良好な水質の保全について、総合的に考慮して定めるものとする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

> 生態系ネットワークの形成に当たっては、河川のみならず、河川周辺の水田・森林、氾
>
> 濫原湿地や河跡湖などなど流域の自然環境の保全や創出を図るほか、まちづくりと連携し
>
> た地域経済の活性化やにぎわいの創出を図ることが重要である。また、自然環境が有する
>
> 多面的な機能を考慮し、治水対策を適切に組み合わせることにより、持続可能で魅力ある
>
> 国土・都市・地域づくりを関係機関と連携して推進することが重要である。

＜関連通知等＞

1.  多自然川づくり基本方針，平成18年10月18日，国土交通省河川局．

    （最新版）多自然川づくり基本方針，令和6年6月，国土交通省水管理・国土保全局.

```{=html}
<!-- -->
```
27. 提言「持続性ある実践的多自然川づくりに向けて」，平成29年6月，河川法改正２０年
    > 多自然川づくり推進委員会.

28. 川からはじまる　川から広がる　魅力ある地域づくり　河川を基軸とした生態系ネットワークの形成，平成31年3月，国土交通省水管理・国土保全局河川環境課.\
    > （最新版）川からはじまる 川から広がる 魅力ある地域づくり
    > 河川を基軸とした生態系ネットワークの形成，令和5年3月，国土交通省水管理・国土保全局河川環境課.

29. 気候変動を踏まえた水災害対策のあり方について～あらゆる関係者が流域全体で行う持続可能な「流域治水」への転換～答申，令和2年7月，社会資本整備審議会.

30. 中小河川に関する河道計画の技術基準，平成22年8月，国土交通省河川局河川環境課長，治水課長，防災課長

31. 美しい山河を守る災害復旧基本方針，平成30年6月，国土交通省水管理・国土保全局防災課長

＜参考となる資料＞

災害復旧に関する事例は国土交通省水管理・国土保全局の下記のサイトが参考となる。

1.  国土交通省　水管理・国土保全局　全国多自然川づくり会議\
    > <https://www.mlit.go.jp/river/kankyo/main/kankyou/tashizen/03.html>

    1.  []{#_Toc103783545
        .anchor}動植物の良好な生息・生育・繁殖環境の保全・創出

＜考え方＞

動植物の良好な生息・生育・繁殖環境の保全・創出は、人間の生存の基盤となっている

多様な生態系への長期的安定性、生物資源の持続的利用、人と自然の豊かな触れ合いなどの観点から重要である。河川は上流から下流へ流下するにつれて、その物理的な形が変化

するとともに、その水も流域の様々な影響を受けて変化しながら、やがては河口に至る。河川には、源流部から河口まで、水中、水際、河原などの場所に応じて、土壌、水、日照などの条件が異なる様々な環境が存在し、その環境に応じて、多様な生物群集が生息・生育・繁殖する。河川が生物群集の多様性を保つ上で重要な役割を果たすことを十分認識し、地域にふさわしい生物群集の良好な生息・生育・繁殖環境を確保しつつ、川を治め、川のもたらすさまざまな恵みを利用していくことが必要である。

そのためには、学術上又は希少性の観点から重要なもの、その川に典型的に見られるもの、川への依存性が高いもの、川のダイナミズムにより維持されているもの、川の上下流等の連続性の指標となるもの、その川において特殊な環境とみられるもの等に着目し、現状及び歴史的な経緯並びにその背景等を踏まえ、その川にふさわしい生物群集と生息・生育・繁殖環境を保全・創出することが重要である。

その川にふさわしい生物群集と生息・生育・繁殖環境を保全・創出し、それらが将来にわたって維持されるよう、河川の整備・管理を行っていくことが重要である。

河川の整備・管理に当たっては、流量変動と土砂動態、生物の生息環境等に関する調査・研究成果を活用し、適切な流量、土砂供給による河床の攪乱、及び侵食や堆積に伴う生息場形成とその維持を行っていくことが重要である。現在の河川環境は、自然要因としての洪水攪乱とその後の回復過程といった時間的変化や、河川改修等に伴う人為的改変による河川環境の時間的変化が累積した結果である。したがって、河川環境を捉える上で時間的変遷は、重要な要素であり、比較的短期間の個別変化を対象とする場合には、河川環境は常に変動しているが、数十年という長い時間で見ると全体として大きく変わらないという概念を意識しながら河川環境の評価を行うことが重要である。

さらに、河川により流送される土砂は、堆積と侵食過程を通じて川のかたちを決定する。この点において、土砂流送は河川環境を規定する大きな要素と考えることができ、河床材料の特性（粒径分布、間隙等）は、水域においては、付着藻類、底生生物、魚類の生息に強く影響するほか、陸域では植物の生育に強く影響している。したがって、平水時の漸進的変化や出水時の急進的変化に伴う土砂の移動は、河川環境の攪乱に重要な役割を果たすほか、河床変動によって維持される複雑な河床間隙水域や倒流木の分布特性は、その川にふさわしい生物群集と生息・生育・繁殖環境に対して重要な役割を果たしていることを意識することが重要である。これらのほかにも、細粒土砂は、河川における栄養塩類などの物質の運搬に深く関与している。

＜必　須＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  河川の整備・管理に当たっては，土砂動態も考慮し、現状の環境を評価した上で環境目標を定め実施する。河川の生物群集及びそれらの生息・生育・繁殖環境の現状と過去からの変遷及びその背景を踏まえ，その川にふさわしい生物群集と生息・生育・繁殖環境が将来にわたって保全されるよう定めることを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1.  平成13年度版　河川水辺の国勢調査\[河川版\]　河川水辺総括資料作成調査の手引き（案）：監修　国土交通省河川局河川環境課，発行　財団法人リバーフロント整備センター，2001.

```{=html}
<!-- -->
```
32. 河川環境検討シート作成の手引き（案），平成15年3月、国土交通省河川局河川環境課.

33. 実践的な河川環境の評価・改善の手引き（案），平成31年3月，公益財団法人リバーフロント研究所.

    （最新版）河川環境管理シートを用いた環境評価の手引き，令和5年7月，国土交通省水管理・国土保全局河川環境課.

34. 河川を基軸とした生態系ネットワーク形成のための手引き
    > （河川管理者向け） （案）
    > 令和２年２月，国土交通省水管理・国土保全局河川環境課.

35. 魚がのぼりやすい川づくりの手引き，平成17年３月、国土交通省河川局.

36. 大河川における多自然川づくり
    > －Ｑ＆Ａ形式で理解を深める－，令和２年３月，国土交通省水管理・国土保全局河川環境課.

    （最新版）大河川における多自然川づくり
    －Ｑ＆Ａ形式で理解を深める－，令和6年7月一部改訂，国土交通省水管理・国土保全局河川環境課.

37. 河川における外来植物対策の手引き，平成25年12月，国土交通省水管理・国土保全局河川環境課.

38. 川那部浩哉／水野信彦・監修　中村太士・編:河川生態学，講談社，2013.

    1.  []{#_Toc103783546 .anchor}良好な景観の保全・創出

＜考え方＞

水辺の景観の基本的な姿は、水の流れと土砂の動き及び動植物（特に植物）との相互作用によって形作られた動的な微地形及びそこに生息する生物より成立している。そして、現在見ることができる風景は、それに人間の行為が関与した相互作用の結果としての姿である。水辺の景観のベースは、自然の力により形成された自然景観であり、動植物の生息・生育・繁殖環境を反映している。このため、水辺の景観の変化は動植物の生息・生育・繁殖環境の変化として現れる。水辺の自然環境の基本的な構成要素は、微地形と植生及び水の流れであり、良好な景観の保全・創出に当たってはこれらを重要視する必要がある。

また、人と川とは、古来より、洪水の防御、水上交通、また日常生活や生産活動を支える水の利用、信仰の対象など様々な形で係わってきており、そのような歴史的・文化的背景のもとで現在の河川の風景が形作られている。例えば、水上交通の要所として発達してきた都市のなかには、現在でも川岸を中心に船着場や古くからの土蔵建築などが残されているものがあり、地域の独自性を示す貴重な遺産となっている事例も見られる。日々の生活に使っていた所では、洗い場や川に降りることができる階段を見ることができる。また河川の流れや水位をコントロールするための構造物も景観の要素となっている。洪水を防御するための護岸、堤防、水害防備林なども景観要素としては重要である。このような人と川の係りに基づいた景観は、なぜそのような景観が形成されてきたのか歴史的な経緯や地域独自の背景についてよく理解する必要がある。

水は、水平面を形成することにより視覚的な休息を与え、個々の景観対象と調和し、まとまりのある個性的な風景をつくり上げる。建物が林立する都市の中にあって、水平で広々とした景観は、開放的で潤いのある空間を与えてくれる。また、太陽光に反射しきらめいている波だった水面は、光の当たり具合や波による水面の傾きの場所による違いにより、水でなければ得られない様々な表情や視覚的な美しさを見せてくれる。このように、水そのものを重要な景観要素として捉え、水を基調とした河川景観の保全・創出に当たってはこれらを重要視する必要がある。

水辺の景観の価値は、河川の微地形と水と生物の相互作用による自然景観としての価値、人と川との永い係りの中で培われてきた人文社会学的な景観としての価値、水自体が持つ景観としての価値など様々である。良好な景観の保全・創出に当たっては、いずれの価値も重要であるが、これらのどの部分をより重要視し、水辺の景観の保全、あるいは整備を図っていくのかは、個々の河川の特性を踏まえて判断していくことが重要である。

> さらに、水を基調とした美しい景観が保全・創出されるためには、周辺景観との調和が重要であり、関係機関等との調整の上、景観の誘導・規制等を行うことも必要である。

＜標　準＞

  -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  河川の整備・管理に当たっては，その川の自然景観や地域の歴史的・文化的な背景を踏まえ， 河川が本来有する水を基調とした良好な景観が保全・創出されるよう実施することを基本とする。
  -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1.  河川景観の形成と保全の考え方，平成18年10月，国土交通省河川局.

    1.  []{#_Toc103783547
        .anchor}人と河川との豊かな触れ合い活動の場の保全・創出

＜考え方＞

人と河川との豊かな触れ合い活動は、地域のどこでもできることではなく、水辺ならではの風景や清々しさ、歴史的・文化的資源や行事・催事など、その河川や地域の特徴を活かして行えるようにすることが重要である。また、河川との触れ合い活動を通して、河川環境やそれに影響を与えている河川周辺の様々な自然的、社会的状況への理解が深まるようにすることや、川との触れ合い活動そのものが河川の環境を悪化させることがないようにすることなどが重要である。

人と河川との豊かな触れ合いの場の保全・創出に当たっては、施設及び場の整備とともに、活動の背景となっている自然環境や景観などの河川環境自体の保全も重要である。また、教育的な観点、福祉的な観点などを融合した施設及び場の整備も重要である。さらに河川利用は自己責任が原則であるが、安全で楽しく水辺で遊べるために、安全に関する情報提供の充実、河川利用者等の啓発、流域における関係機関の連携、緊急時への備え等が重要である。

> 施設又は場の整備に当たっては、河川形態や河川の自然作用（土砂の侵食・堆積、砂州の移動等）等を踏まえ、将来にわたってその環境が維持されることが重要である。

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------
  河川の整備・管理に当たっては，自然との共生のもとに，人と河川との豊かな触れ合いが図られるよう，河川環境の保全及び場の整備等を実施することを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1.  かわまちづくり支援制度要綱，平成28年2月10日，国土交通省水管理・国土保全局

    （最新版）かわまちづくり支援制度要綱，令和6年4月1日，国土交通省水管理・国土保全局

    1.  []{#_Toc103783548 .anchor}良好な水質の保全

＜考え方＞

河川の適正な利用、流水の正常な機能の維持及び河川環境の保全のために必要となる良好な水質とは、利水（水道用水、農業用水、工業用水、水産用水等）、動植物の良好な生息・生育環境の保全、人と河川との豊かな触れ合い活動の場の確保、景観、周辺の生活環境の保全、観光、河川管理施設の保護、地下水質の維持等の機能が損なわれないような状態をいう。

なお、水質には底質の概念を含むものとする。

良好な水質を保全するに当たっては、流域と水域とのつながりを把握することが重要であり、流域の自然環境や社会環境及びそれらの歴史的な経緯、例えば、過去に生息・生育していた動植物や、人と河川との触れ合い活動の変化と水質との関係についても踏まえる必要がある。また、流域での持続的な生産活動や沿川住民の河川への要望等を十分に考慮し、流域の諸条件の将来変化や住民意識の変化にも対応することが重要である。

> なお、突発的な水質事故や異常水質への対応についても、検討しておくことが必要である。

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------
  河川の整備・管理に当たっては，河川が適正に利用されるとともに，流水の正常な機能が維持され，河川環境の保全が図られるよう，良好な水質の保全を実施することを基本とする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------

> 基本計画編

**第3章 砂防（土砂災害等対策）計画**

目　次

[第1節 総　説 1](#_Toc4508569)

[第2節 砂防基本計画に関する基本的な事項 1](#_Toc4508570)

> [2．1 総　説 1](#_Toc4508571)
>
> [2．2
> 短期（一連の降雨継続期）土砂・流木流出対策計画に関する基本的な事項
> 3](#_Toc5031423)
>
> [2．2．1 総　説 3](#_Toc5031424)
>
> [2．2．2 土砂・洪水氾濫対策計画に関する基本的な事項 4](#_Toc5031425)
>
> [2．2．3 土石流・流木対策計画に関する基本的な事項 7](#_Toc5031426)
>
> [2．2．4 土砂・洪水氾濫時に流出する流木の対策計画に関する基本的な事項
> 10](#_Toc5031427)
>
> [2．3 中期（土砂流出活発期）土砂流出対策計画に関する基本的な事項
> 12](#_Toc5031428)
>
> [2．3．1 総　説 12](#_Toc5031429)
>
> [2．3．2 計画規模 12](#_Toc5031430)
>
> [2．3．3 保全対象・計画基準点等 13](#_Toc5031431)
>
> [2．3．4 計画で扱う土砂量 13](#_Toc5031432)
>
> [2．3．5 中期土砂流出対策における土砂処理計画 13](#_Toc5031433)
>
> [2．4 長期（土砂流出継続期）土砂流出対策計画に関する基本的な事項
> 14](#_Toc5031434)
>
> [2．4．1 総　説 14](#_Toc5031435)
>
> [2．4．2 計画規模 14](#_Toc5031436)
>
> [2．4．3 保全対象・計画基準点等 14](#_Toc5031437)
>
> [2．4．4 計画で扱う土砂量 15](#_Toc5031438)
>
> [2．4．5 長期土砂流出対策における土砂処理計画 15](#_Toc5031439)
>
> [2．5 火山砂防地域における土砂災害対策計画（火山砂防計画）に\
> 関する基本的な事項 15](#_Toc5031440)
>
> [2．5．1 総　説 15](#_Toc5031441)
>
> [2．5．2 計画規模 17](#_Toc5031442)
>
> [2．5．3 保全対象・計画基準点等 17](#_Toc5031443)
>
> [2．5．4 計画で扱う土砂量 17](#_Toc5031444)
>
> [2．5．5 土砂処理計画 18](#_Toc5031445)
>
> [2．6 深層崩壊・天然ダム等異常土砂災害対策計画に関する基本的な事項
> 18](#_Toc5031446)
>
> [2．6．1 総　説 18](#_Toc5031447)
>
> [2．6．2 計画規模 19](#_Toc5031448)
>
> [2．6．3 保全対象・計画基準点等 19](#_Toc5031449)
>
> [2．6．4 計画で扱う土砂量 20](#_Toc5031450)
>
> [2．6．5 深層崩壊・天然ダム等異常土砂災害対策における土砂処理計画
> 20](#_Toc5031451)

[第3節 地すべり防止計画に関する基本的な事項 21](#_Toc5031452)

> [3．1 総　説 21](#_Toc5031453)
>
> [3．2 計画規模 21](#_Toc5031454)
>
> [3．3 保全対象 21](#_Toc5031455)
>
> [3．4 計画安全率 22](#_Toc5031456)
>
> [3．5 地すべり防止計画 22](#_Toc5031457)
>
> [3．5．1 総　説 22](#_Toc5031458)
>
> [3．5．2 地すべり防止工事基本計画 23](#_Toc5031459)

[第4節 急傾斜地崩壊対策計画に関する基本的な事項 23](#_Toc5031460)

> [4．1 総　説 23](#_Toc5031461)
>
> [4．2 保全対象 23](#_Toc5031462)
>
> [4．3 計画で扱う諸量 24](#_Toc5031463)
>
> [4．4 急傾斜地崩壊対策計画 24](#_Toc5031464)

[第5節 雪崩対策計画に関する基本的な事項 24](#_Toc5031465)

> [5．1 総　説 24](#_Toc5031466)
>
> [5．2 保全対象 25](#_Toc5031467)
>
> [5．3 計画で扱う諸量 25](#_Toc5031468)
>
> [5．4 雪崩対策計画 26](#_Toc5031469)

[第6節 自然環境への配慮等 26](#_Toc5031470)

> [6．1 総　説 26](#_Toc5031471)
>
> [6．2 都市山麓グリーンベルト整備計画 27](#_Toc5031472)
>
> [6．2．1 総　説 27](#_Toc5031473)
>
> [6．2．2 対策の基本 27](#_Toc5031474)

平成31年3月　版

4.  

5.  第3章 砂防（土砂災害等対策）計画

    6.  []{#_Toc4508569 .anchor}第1節 総　説

＜標　準＞

+----------------------------------------------------------------------+
| 砂防（土砂災害等対策）計画には、流域等における土砂の生産及び         |
| その流出に起因し発生する災害（土砂災害）を防止・軽減するための砂防基 |
| 本計画、地すべり防止計画、急傾斜地崩壊対策計画、雪崩による災害を防止 |
| ・軽減するための雪崩対策計画がある。ここで言う、流域等とは、流域、火 |
| 山地・火山麓地、急傾斜地等をいう。また、土砂の生産とは、豪雨、融雪、 |
| 地震等による山腹や斜面の崩壊・侵食、土石流、地すべり、河床・河岸の侵 |
| 食等の現象に伴う不安定土砂の発生をいい、土砂災害の防止・軽減とは、山 |
| 腹や斜面の崩壊・侵食、土石流の直撃等の直接的な災害及び流出した土砂に |
| よる貯水池の埋没や、流域等における土砂流出による扇状地・谷底平野・沖 |
| 積平野における河床の上昇による土砂・洪水氾濫等による直接的及び間接的 |
| な災害から、国民の生命、財産及び生活環境、自然環境を守ることをいう。 |
|                                                                      |
| また                                                                 |
| 、砂防（土砂災害等対策）計画の策定においては、地域の特性・土地利用状 |
| 況等を踏まえ、土石流、土砂・洪水氾濫、流木、地すべり、急傾斜地の崩壊 |
| による災害等が輻輳して発生する土砂災害の防止・軽減を図るため、砂防設 |
| 備等によるハード対策と警戒避難体制の整備、土地利用規制等によるソフト |
| 対策を適切に組み合わせ、総合的な対策となるように計画するものとする。 |
+----------------------------------------------------------------------+

＜推　奨＞

+----------------------------------------------------------------------+
| 砂防（土砂災害対                                                     |
| 策）計画の策定に当たって、以下の観点について検討することが望ましい。 |
|                                                                      |
| > ・既往の災害履歴と事業の変遷                                       |
| >                                                                    |
| > ・流砂系における総合的な土砂管理                                   |
| >                                                                    |
| > ・良好な自然環境の復元                                             |
| >                                                                    |
| > ・良好な景観の維持・形成                                           |
| >                                                                    |
| > ・流域等の利活用                                                   |
+----------------------------------------------------------------------+

7.  []{#_Toc4508570 .anchor}第2節 砂防基本計画に関する基本的な事項

    1.  []{#_Toc4508571 .anchor}総　説

＜標　準＞

+----------------------------------------------------------------------+
| 砂防基本計画は、流域等における土砂の生産及びその流出に               |
| よる土砂災害を防止・軽減するため、計画区域内において、土砂災害を引き |
| 起こすような有害な生産・流出土砂を合理的かつ効果的に処理するよう策定 |
| するものとする。砂防基本計画は対象流域等における様々な形態、時間スケ |
| ールの災害を引き起こす計画規模内のあらゆる土砂流出現象を対象とする。 |
|                                                                      |
| 砂防基本計画には、災害を引き起こす現                                 |
| 象、現象が生じる時間スケール、保全対象の位置などの対策の目的に応じ、 |
|                                                                      |
| > A.                                                                 |
| > 短期（一連の降雨継続期）土砂・流木流出による土砂                   |
| 災害を防止・軽減するための計画（短期土砂・流木流出対策計画）対策計画 |
| >                                                                    |
| > B．中期（土砂流出活発期）土砂流出によ                              |
| る土砂災害を防止・軽減するための計画（中期土砂流出対策計画）対策計画 |
| >                                                                    |
| > C.                                                                 |
| > 長期（土砂流出継続期）土砂流出によ                                 |
| る土砂災害を防止・軽減するための計画（長期土砂流出対策計画）対策計画 |
| >                                                                    |
| > D. 火山砂防地域における土砂災害対策計画（火山砂防計画）            |
| >                                                                    |
| > E. 深層崩壊・天然ダム等異常土砂災害対策計画                        |
|                                                                      |
| に細分                                                               |
| されるものとする。砂防基本計画と現象が生じる時間スケール、保全対象の |
| 位置などの対策の目的の関係は、図3-1に示すとおりである。対象とする現  |
| 象が生じる時間スケールは短期、中期、長期の3期間に細分され、それぞれ  |
|                                                                      |
| > 短期は、計画規模の現象が発生する一連の降雨継続期間                 |
| >                                                                    |
| > 中期は、短期の降雨により生産された土砂がその後の降雨によ           |
| り特に活発に移動する期間（流出土砂が定常状態に落ちつくまでの数年間） |
| >                                                                    |
| > 長                                                                 |
| 期は、流出土砂量が短期土砂・流木流出を引き起こした降雨イベントの前に |
| 比べて定常的に流出土砂量が活発な状態が継続する期間（十年以上の期間） |
|                                                                      |
| とし、短期、中期、長期において対象とする                             |
| 土砂流出のイメージは図3-2に示すとおりである。上記A～Eの5つの計画は、 |
| 発生する災害の現象、対策の目的によっては、地域的に重なり合うことがあ |
| る。このような場合は、発生する災害の現象等に応じ、計画として分けて策 |
| 定するが、各々の計画間の整合が図られるよう相互調整を行う必要がある。 |
|                                                                      |
| ![](media/image5.emf){width="6.298611111111111in"                    |
| height="3.3509853455818024in"}                                       |
|                                                                      |
| 図3-1                                                                |
| 砂防基本計画と現象が生じる時間スケール、保全対象                     |
| などの対策の目的の関係（火山砂防地域における土砂災害対策計画は除く） |
|                                                                      |
| ![](media/image6.emf){width="6.298611111111111in"                    |
| height="4.46798009623797in"}                                         |
|                                                                      |
| 図3-2 短期、中期、長期で対象とする土砂流出のイメージ                 |
+----------------------------------------------------------------------+

2.  []{#_Toc5031423
    .anchor}短期（一連の降雨継続期）土砂・流木流出対策計画に関する基本的な事項

    1.  []{#_Toc5031424 .anchor}総　説

＜考え方＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  短期土砂・流木流出対策計画は、流域等において計画規模の土砂移動現象が発生しうる一連の降雨による土砂災害の防止・軽減を図ることを目的として策定する。短期土砂・流木流出対策計画は、中期土砂流出対策計画、火山砂防計画、深層崩壊・天然ダム等異常土砂災害対策計画と整合するように定める。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 短期（一連の降雨継続期）土砂・流木流出対策計画は、                   |
|                                                                      |
| A-1　土砂・洪水氾濫対策計画                                          |
|                                                                      |
| A-2　土石流・流木対策計画                                            |
|                                                                      |
| A-3　土砂・洪水氾濫時に流出する流木の対策計画                        |
|                                                                      |
| からなるものとする。すなわち、山地域からの流出土砂に伴               |
| う河床上昇等により引き起こされる扇状地、谷底平野、沖積平野で生じる土 |
| 砂・洪水氾濫に対する対策（A-1）、土石流危険渓流において生じる土石流  |
| ・流木の直撃等の直接的な災害に対する対策（A-2）、山地域からの流出し  |
| た流木により河積が阻害されることなどにより引き起こされる扇状地、谷底 |
| 平野、沖積平野における土砂・洪水氾濫に対する対策）（A-3）に分類でき  |
| る（図3-1）。また、短期（一連の降雨継続期）土砂・流木流出による流出  |
| した土砂・流木による貯水池の埋没は、土砂・洪水氾濫対策計画に含める。 |
+----------------------------------------------------------------------+

2.  []{#_Toc5031425 .anchor}土砂・洪水氾濫対策計画に関する基本的な事項

```{=html}
<!-- -->
```
5.  総　説

＜考え方＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  土砂・洪水氾濫対策計画は、計画規模の土砂移動現象が発生しうる一連の降雨による山地の山腹、渓流から河川までの有害な土砂移動を制御し、山地からの流出土砂に伴う河床上昇等により引き起こされる土砂・洪水氾濫を防止・軽減することによって、河川の治水上、利水上の機能の確保と、環境の保全を図ることを目的として策定する。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  土砂・洪水氾濫対策計画の策定に当たっては、計画規模の土砂移動現象が発生しうる一連の降雨による土砂・洪水氾濫によって、被害が生じるおそれのある扇状地、谷底平野、沖積平野等に位置する保全対象を抽出・設定し、有害な土砂を合理的かつ効果的に処理するための土砂処理計画を策定することを基本とする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------
  土砂・洪水氾濫による被害形態は保全対象の立地場所により異なることが想定されるため、保全対象ごとに計画の対象とする土砂移動現象を設定することが望ましい。
  --------------------------------------------------------------------------------------------------------------------------------------------------------

6.  計画規模

＜考え方＞

+----------------------------------------------------------------------+
| 計画規模は、計画区域の土砂災害に対する安全の度合いを表すものである。 |
|                                                                      |
| 土砂・洪水                                                           |
| 氾濫対策計画における計画規模は、流域ごとに既往の災害、過去の豪雨時の |
| 土砂生産の実態、計画区域等の重要度、事業効果等を総合的に考慮して定め |
| るものとし、一般的には対象降雨の降雨量の年超過確率で評価して定める。 |
|                                                                      |
| また、                                                               |
| 同じ地域において同じ年超過確率であっても、保全対象のある地点によって |
| 被害の生じるおそれのある降雨条件（降雨の量、時間分布及び空間分布）が |
| 異なる。そのため、土砂・洪水氾濫対策計画における対象降雨の設定に当た |
| っては、保全対象の位置に応じて対象降雨をそれぞれ設定する必要がある。 |
+----------------------------------------------------------------------+

＜標　準＞

  -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  土砂・洪水氾濫対策計画における対象降雨による計画規模の決定に当たっては、既往の災害等における土砂移動現象の発生状況などを勘案し設定することを基本とする。対象降雨は保全対象ごとに降雨の量、時間分布及び空間分布の3要素について定めることを基本とする。なお、既往災害から決める場合であって、複数の対象降雨が候補となる場合、複数の降雨条件について解析を行うことを基本とする。
  -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜例　示＞

+----------------------------------------------------------------------+
| 保全対象に関する土砂・洪水氾濫による                                 |
| 被害の推定を行うにあたっては、保全対象の位置に応じ、降雨条件を設定す |
| る場合がある。計画降雨の降雨分布イメージ図は、図3-3に示すとおりであ  |
| る。同じ降雨でも、検討対象とする保全対象のある地点より上流域の流域面 |
| 積が大きい場合、流域内の一部で雨域の狭い集中豪雨が生じた場合であって |
| も、流域内のその他の地域の降雨強度が小さいことにより、流域平均の降雨 |
| 強度は小さくなることがある（図3-3左）。このような降雨分布の場合、当  |
| 該保全対象が被害に遭う可能性は必ずしも高くない。一方、局所的に降雨強 |
| 度が極めて強い領域がなくても、流域全体を覆うように強度の強い雨域が広 |
| い範囲でもたらされた場合、流域平均の降雨強度が大きくなり、当該保全対 |
| 象が被害に遭う可能性は相対的に高くなる可能性が考えられる（図3-3右）  |
|                                                                      |
| ![](media/image7.png){width="5.953596894138233in" height="2.625in"}  |
|                                                                      |
| 図3-3 計画降雨の降雨分布イメージ                                     |
+----------------------------------------------------------------------+

7.  保全対象・計画基準点等

＜考え方＞

+----------------------------------------------------------------------+
| 土砂・洪水氾濫対策計画で対象とす                                     |
| る保全対象は、土砂・洪水氾濫によって被害が生じるおそれのある扇状地、 |
| 谷底平野、沖積平野等に位置する人家、インフラ、ライフライン等である。 |
|                                                                      |
| また、土砂・                                                         |
| 洪水氾濫対策計画における計画基準点・補助基準点は、計画降雨、土砂処理 |
| 計画、施設配置計画の検討・策定のために設定する地点である。そこで、計 |
| 画基準点・補助基準点は地域の特性が十分表現できるような地点に設ける。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| > 土砂・洪水氾濫対策計画では、計                                     |
| 画規模の土砂移動現象が発生しうる一連の降雨による土砂・洪水氾濫で被害 |
| が生じるおそれのある主たる保全対象を抽出・設定することを基本とする。 |
| >                                                                    |
| > 計画基準点は、土砂・洪水氾濫対策計画で対                           |
| 象とする計画区域の最下流地点又は河川計画との関連地点、保全対象の上流 |
| 地点、土砂の生産が見込まれる地域の最下流地点などに設けるものとする。 |
| >                                                                    |
| > なお、土砂の移動形態が変わる地点、支                               |
| 川内の保全対象の上流地点、本川と支川との合流点等の土砂移動の状況を把 |
| 握する必要がある場合には、複数の地点に補助基準点を設けるものとする。 |
+----------------------------------------------------------------------+

8.  計画で扱う土砂量

＜考え方＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  土砂・洪水氾濫対策計画で取り扱う土砂生産に係る諸量（以下「計画生産土砂量」という。）は、山腹及び渓岸における新規崩壊土砂量及び既崩壊拡大見込み土砂量並びに既崩壊残存土砂量のうち崩壊等の発生する時点で河道に流出するもの、河床等に堆積している土砂量のうち二次侵食を受けるものからなる。また、当該計画で取り扱う土砂流出に係る諸量（以下「計画流出土砂量」という。）は、計画基準点等を通過する土砂の量及び質（粒径）並びにそのタイミングと、保全対象周辺における河床の変動量、河川流量等とし、それぞれについて計画立案時点の状況下で想定される量と、土砂・洪水氾濫による被害を防止・軽減する施設配置を行った状況下で想定される量の双方について設定する。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 土砂・洪水氾濫対策計画                                               |
| では、計画で扱う土砂量として計画生産土砂量と計画流出土砂量を設定する |
| ことを基本とする。計画生産土砂量は、計画区域の現況調査資料、既往の災 |
| 害資料、類似地域の資料等を用いて過去の実績に基づき経験的に設定する手 |
| 法と、数値計算など解析的に設定する手法若しくはそれら両者を組み合わせ |
| た手法を適切に選択し、設定することを基本とする。計画生産土砂量を設定 |
| するに当たっては、土砂の量及び質（粒径）、土砂生産の形態、生産される |
| 場所、発生のタイミングを想定した上で設定することを基本とする。計画流 |
| 出土砂量は、流出解析、河床変動計算によって設定することを基本とする。 |
|                                                                      |
| なお、生産土砂量に関する調                                           |
| 査については、河川砂防技術基準（調査編）の「砂防調査」を参考にする。 |
+----------------------------------------------------------------------+

9.  土砂処理計画

＜考え方＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  土砂・洪水氾濫対策計画における土砂処理計画は、計画規模の土砂移動現象により、保全対象における土砂・洪水氾濫による被害が防止・軽減できるように、合理的かつ効果的に有害な土砂を処理するために策定するものである。土砂処理計画は、土砂生産抑制計画及び土砂流送制御計画からなり、これらの計画はいずれも相互に関連するものである。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| > 土砂・洪水氾濫対策計画における土砂処理計画は、生産土砂量の調査     |
| 、流出解析、河床変動計算、氾濫解析に基づき策定することを基本とする。 |
+----------------------------------------------------------------------+

＜推　奨＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  土砂処理計画の策定にあたっては、対象地域における既往災害に対する再現計算を実施し、当該地域の災害を再現できることを確認した計算条件、解析手法（流出解析手法、河床変動計算手法など）を用いて検討することが望ましい。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜参考となる資料＞

1.  内田太郎，小松美緒，坂井佑介：[河床変動計算を用いた土砂・洪水氾濫対策に関する砂防施設配置検討の手引き（案）](http://www.nilim.go.jp/lab/bcg/siryou/tnn/tnn1048pdf/ks1048.pdf)，国土技術政策総合研究所資料，第1048号，2018．

```{=html}
<!-- -->
```
39. 蒲原潤一，内田太郎，丹羽諭，松本直樹，桜井亘：[豪雨時の土砂生産をともなう土砂動態解析に関する留意点](http://www.nilim.go.jp/lab/bcg/siryou/tnn/tnn0874pdf/ks0874.pdf)，国土技術政策総合研究所資料，第874号，2015．

```{=html}
<!-- -->
```
10. 土砂生産抑制計画

＜考え方＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  土砂・洪水氾濫対策計画における土砂生産抑制計画は、降雨等による山腹の崩壊、地すべり、渓床・渓岸の侵食等を砂防設備で抑制することによって、土砂生産域の荒廃を復旧するとともに、新規荒廃の発生を防止し、有害な土砂の生産を抑制するための計画である。計画の策定に当たっては、土砂生産域の状況、土砂の生産形態、土砂の流出形態、保全対象等を考慮し、山腹工・砂防堰堤等を合理的に配置して策定するものとする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| > 土砂                                                               |
| ・洪水氾濫対策計画における土砂生産抑制計画は、生産土砂量の調査、流出 |
| 解析、河床変動計算、氾濫解析により、砂防設備による土砂生産抑制効果の |
| 保全対象への影響・効果を評価して定めることを基本とする。また、砂防設 |
| 備による土砂生産抑制効果については、砂防設備の規模及び地形、地質、植 |
| 生の状況並びに地盤の安定状況などの調査により定めることを基本とする。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

1.  内田太郎，小松美緒，坂井佑介：[河床変動計算を用いた土砂・洪水氾濫対策に関する砂防施設配置検討の手引き（案）](http://www.nilim.go.jp/lab/bcg/siryou/tnn/tnn1048pdf/ks1048.pdf)，国土技術政策総合研究所資料，第1048号，2018．

```{=html}
<!-- -->
```
11. 土砂流送制御計画

＜考え方＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  土砂・洪水氾濫対策計画における土砂流送制御計画は、捕捉・調節機能等を有する砂防設備によって有害な土砂の流出を制御し、土砂を安全に流下させるための計画である。計画の策定に当たっては、土砂の流出形態、土砂量・粒径、保全対象、地形、河床勾配、河道等の現況や計画等を考慮して、砂防堰堤、遊砂地等を合理的に配置して策定するものとする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| > 土砂・洪水氾濫対策計画に                                           |
| おける土砂流送制御計画は、流出解析・河床変動計算・氾濫解析により、砂 |
| 防設備による保全対象への影響・効果を評価して定めることを基本とする。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

1.  内田太郎，小松美緒，坂井佑介：[河床変動計算を用いた土砂・洪水氾濫対策に関する砂防施設配置検討の手引き（案）](http://www.nilim.go.jp/lab/bcg/siryou/tnn/tnn1048pdf/ks1048.pdf)，国土技術政策総合研究所資料，第1048号，2018．

    1.  []{#_Toc5031426 .anchor}土石流・流木対策計画に関する基本的な事項

```{=html}
<!-- -->
```
1.  総　説

＜考え方＞

+----------------------------------------------------------------------+
| 土石流・流木対策計画では、山腹が崩壊して生じ                         |
| た土石・流木及び渓流、渓岸の土石・流木が水と一体になって流下する現象 |
| を対象とする。土石流・流木によって発生する災害は、土石流・流木の直撃 |
| による災害と土石流の後続流等が氾濫することによる災害とに分けられる。 |
|                                                                      |
| 土石流・流木の直撃による災害とは、先端部に集中して                   |
| 流下する巨礫等が直接人家等に衝突し発生する災害であり、後続流等が氾濫 |
| することによる災害とは、土石流等の先頭部が堆積したのち、後続流等が流 |
| 下する際、周辺域へと氾濫することにより浸水被害等が生じる災害をいう。 |
|                                                                      |
| なお、大                                                             |
| 規模な山腹崩壊土砂がそのまま土石流となるものや、崩壊または地すべり等 |
| により形成された天然ダムの決壊による土石流、および火山噴火に伴って融 |
| 雪に起因する火山泥流、火口湖の決壊に起因する火山泥流は対象外とする。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| > 土石流・流木対策計画は、土石流お                                   |
| よび土砂とともに流出する流木による災害から、国民の生命、財産及び公共 |
| 施設等を守ることを目的として、土石流および土砂とともに流出する流木を |
| 合理的かつ効果的に処理するように策定することを基本とする。また、土石 |
| 流危険渓流であっても流路が不明瞭で常時流水がない小規模渓流など流域の |
| 特性、想定される現象等を踏まえた計画策定を実施することを基本とする。 |
| >                                                                    |
| > また、土石流・流木対策施設が十分機能を発揮するため、土石流         |
| 等の発生後や定期的に砂防堰堤の堆砂状況等の点検を行い、除石（流木の除 |
| 去を含む）等を実施するのに必要な除石計画を検討することを基本とする。 |
+----------------------------------------------------------------------+

12. 計画規模

＜考え方＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  土石流・流木対策計画の計画規模については、計画規模の降雨時に発生する可能性が高いと判断される土石流（計画規模の土石流）による流出土砂量として定める。流木の計画規模は、計画規模の土石流とともに流出する実材積の流木量として定める。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------
  土石流・流木対策計画の計画規模は、流域の特性、過去の降雨特性、当該渓流における過去の土砂移動現象の発生状況等を総合的に考慮して定めることを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

+----------------------------------------------------------------------+
| 土石流の発生頻度の高い渓流では、必                                   |
| 要に応じて既往資料等に基づいて土石流の流出量により計画規模を定める。 |
|                                                                      |
| 立木                                                                 |
| による流木量は、斜面崩壊・渓岸崩壊等の発生が予想される山腹や谷筋の樹 |
| 林の樹種、林齢、材積等の構成が安定的に推移すると判定できる場合は、現 |
| 地調査結果や砂防基本計画において算定する山腹崩壊等による新規崩壊面積 |
| 、土石流発生時に侵食が予想される平均渓床幅及び流路長から算定すること |
| が望ましい。また、倒木、伐木、渓床に堆積している流木量については、現 |
| 地調査により、長さ・直径等をもとに流木量を算出することが望ましい。な |
| お、伐木、用材の流出等、人為的に発生したものは計画の対象に含めない。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

1.  国土技術政策総合研究所土砂災害研究部砂防研究室：[砂防基本計画策定指針（土石流・流木対策編）解説](http://www.nilim.go.jp/lab/bcg/siryou/tnn/tnn0904pdf/ks0904.pdf)，国土技術政策総合研究所資料，第904号，2016．\
    （最新版）国土技術政策総合研究所土砂災害研究部砂防研究室：砂防基本計画策定指針（土石流・流木対策編）解説，平成28年4月（令和7年3月一部改定）

```{=html}
<!-- -->
```
13. 保全対象・計画基準点等

＜考え方＞

+----------------------------------------------------------------------+
| 土石流・流木対策計画における保全対象は、計画規模の土石流お           |
| よび土砂とともに流出する流木により被害が生じるおそれのある保全人口、 |
| 人家、田畑、公共施設、インフラ、ライフライン等である。保全対象地域の |
| 設定に際しては、計画基準点からの方向、距離、渓床との比高を考慮する。 |
|                                                                      |
| また、土石流・流木対策計画における計画基準点は、計                   |
| 画で扱う土砂量及び土砂とともに流出する流木量等を決定する地点である。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 土石流・流木対策計画における保全対                                   |
| 象は、土石流危険区域内にある保全人口、人家等とすることを基本とする。 |
|                                                                      |
| 土石流・流木対策計画における計画基準点は、一般に                     |
| は保全対象の上流等の谷の出口、土石流の堆積開始地点又は土石流堆積開始 |
| 地点より下流に施設を設置する場合には、当該施設下流とすることを基本と |
| する。また、土砂の移動形態が変わる地点や支渓の合流部等の土砂移動の状 |
| 況を把握する必要がある場合には、補助基準点を設けることを基本とする。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

1.  国土技術政策総合研究所土砂災害研究部砂防研究室：[砂防基本計画策定指針（土石流・流木対策編）解説](http://www.nilim.go.jp/lab/bcg/siryou/tnn/tnn0904pdf/ks0904.pdf)，国土技術政策総合研究所資料，第904号，2016．\
    （最新版）国土技術政策総合研究所土砂災害研究部砂防研究室：砂防基本計画策定指針（土石流・流木対策編）解説，平成28年4月（令和7年3月一部改定）

```{=html}
<!-- -->
```
14. 計画で扱う土砂量・流木量

＜考え方＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  土石流・流木対策計画で扱う土砂量・流木量は、計画規模の土石流および土砂とともに流出する流木等を把握するために、計画基準点において算出する。また、算出に際しては、土石流・流木対策施設が無い状態を想定し設定する。なお、流域において、新たな崩壊、土石流の発生、地震による斜面の不安定化等の自然的要因又は開発等の人為的要因により大きな変化があった場合、森林等の状況が大きく変化した場合には、必要に応じて、土石流・流木対策計画で扱う土砂・流木量を見直すこととする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 土石流・流木対策                                                     |
| 計画で扱う土砂量・流木量として、計画流出量（計画流出土砂量・計画流出 |
| 流木量）、計画流下許容量（計画流下許容土砂量・計画流下許容流木量）、 |
| 土石流ピーク流量について、計画基準点において設定することを基本とする |
| 。計画流出量は計画流出土砂量と計画流出流木量の和とし、計画流下許容量 |
| は計画流下許容土砂量と計画流下許容流木量の和とすることを基本とする。 |
|                                                                      |
| 計画流出土砂量は、計画規                                             |
| 模の土石流により、計画基準点まで流出する土砂量である。計画流出流木量 |
| は、計画規模の土石流に含まれて、計画基準点まで流出する流木量である。 |
|                                                                      |
| 計画流下許容土砂量は、計                                             |
| 画規模の土石流が発生した場合に計画基準点より下流において災害を発生す |
| ることなく流れる土砂量として、計画流下許容流木量は計画基準点より下流 |
| で災害を引き起こさない流木量としてそれぞれ設定することを基本とする。 |
|                                                                      |
| 土石流ピーク流量は                                                   |
| 、「計画規模の土石流」が計画基準点を通過する際の流量の最大値とする。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

1.  国土技術政策総合研究所土砂災害研究部砂防研究室：[砂防基本計画策定指針（土石流・流木対策編）解説](http://www.nilim.go.jp/lab/bcg/siryou/tnn/tnn0904pdf/ks0904.pdf)，国土技術政策総合研究所資料，第904号，2016．\
    （最新版）国土技術政策総合研究所土砂災害研究部砂防研究室：砂防基本計画策定指針（土石流・流木対策編）解説，平成28年4月（令和7年3月一部改定）

```{=html}
<!-- -->
```
15. 土石流・流木処理計画

＜考え方＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  土石流・流木処理計画では、計画基準点等において、計画で扱う土砂・流木量を、砂防設備等による計画捕捉量（計画捕捉土砂量、計画捕捉流木量）、計画堆積量（計画堆積土砂量、計画堆積流木量）、計画発生（流出）抑制量（計画土石流発生（流出）抑制量、計画流木発生抑制量）によって処理する。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  土石流・流木処理計画は、「計画規模の土石流」および土砂とともに流出する流木等によって生じる被害を防止・軽減するために、砂防設備等により「計画規模の土石流」および土砂とともに流出する流木等を合理的かつ効果的に処理するよう定めることを基本とする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜参考となる資料＞

1.  国土技術政策総合研究所土砂災害研究部砂防研究室：[砂防基本計画策定指針（土石流・流木対策編）解説](http://www.nilim.go.jp/lab/bcg/siryou/tnn/tnn0904pdf/ks0904.pdf)，国土技術政策総合研究所資料，第904号，2016．\
    （最新版）国土技術政策総合研究所土砂災害研究部砂防研究室：砂防基本計画策定指針（土石流・流木対策編）解説，平成28年4月（令和7年3月一部改定）

    1.  []{#_Toc5031427
        .anchor}土砂・洪水氾濫時に流出する流木の対策計画に関する基本的な事項

```{=html}
<!-- -->
```
1.  総 説

＜考え方＞

+----------------------------------------------------------------------+
| 土砂・洪水氾濫時に流出す                                             |
| る流木の対策計画で対象とする現象は、斜面の崩壊、土石流、渓岸・渓床侵 |
| 食による流木の発生と、渓流内への流入による下流への流木の流出とする。 |
|                                                                      |
| 土砂・洪                                                             |
| 水氾濫時に流出する流木は、扇状地、谷底平野、沖積平野等に土砂とともに |
| 流出するほか、渓流等を流下する際に渓流の狭窄部や橋梁、ボックスカルバ |
| ート等を閉塞し、土砂等の氾濫、橋梁等を流出させることにより国民の生命 |
| 、人家等の財産、道路やダム等公共施設に多大な被害を与えることがある。 |
|                                                                      |
| この                                                                 |
| ため、土砂・洪水氾濫時に流出する流木の対策計画は、土砂とともに流出す |
| る流木による災害から、生命、財産及び公共施設等を守ることを目的として |
| 策定する。土石流とともに流出する流木対策は、2.2.3に従うものとする。  |
+----------------------------------------------------------------------+

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  土砂・洪水氾濫時に流出する流木の対策計画は、土砂・洪水氾濫対策計画を策定する流域のうち、流木の発生・流出による被害が予想される流域を対象に、流木を砂防設備等により合理的かつ効果的に処理するよう定めることを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

16. 計画規模

＜考え方＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  土砂・洪水氾濫時に流出する流木量は、豪雨時の土砂生産によって発生し、渓流を流下することから、土砂・洪水氾濫対策計画で想定される規模の土砂生産・土砂流出により発生・流出する量を想定する。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  土砂・洪水氾濫時に流出する流木の対策計画の計画規模は、流域の特性、過去の降雨特性、当該渓流における過去の土砂移動現象の発生状況等を総合的に考慮して、土砂・洪水氾濫対策計画と整合するように定めることを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

17. 保全対象・計画基準点等

＜考え方＞

+----------------------------------------------------------------------+
| 土砂・                                                               |
| 洪水氾濫時に流出する流木の対策計画では、計画規模の現象が発生する一連 |
| の降雨による土砂・洪水氾濫時の流木の流出および流木に起因する土砂・洪 |
| 水氾濫による被害が生じるおそれのある主たる保全対象を抽出・設定する。 |
|                                                                      |
| 計画基準点は、計画で扱う流木量を決定する地点として設定する。         |
|                                                                      |
| > 土砂・洪水氾濫時に流出する流木の対策計                             |
| 画は、流木対策のみで策定するものではなく、土砂とともに流出する流木を |
| 対象に、土砂・洪水氾濫対策計画等とともに、計画を策定するものである。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 土砂・洪水氾濫時に流出する流木の対策計画で対象とす                   |
| る保全対象は、土砂・洪水氾濫時に流出する流木によって被害が生じるおそ |
| れのある扇状地、谷底平野、沖積平野等に位置する人家、インフラ、ライフ |
| ライン等のほか、流木が橋梁、ボックスカルバート等を閉塞させて生じる土 |
| 砂・流木等の氾濫範囲に位置する人家、インフラ、ライフライン等である。 |
|                                                                      |
| 流木の流出を抑制することにより、橋梁                                 |
| の流失による交通途絶、ダム等の構造物機能の低下や港や海岸への流木の集 |
| 積による被害の防止に資する場合は、これらの公共施設も保全対象とする。 |
|                                                                      |
| 土砂・洪水氾濫時に流出する流木の                                     |
| 対策計画の計画基準点は、一般に保全対象のある地域の上流に設けるものと |
| し、土砂流出対策の施設を有効に活用した流木対策施設の配置とするため、 |
| 土砂・洪水氾濫対策の計画基準点等と同一の地点とすることを基本とする。 |
+----------------------------------------------------------------------+

18. 計画で扱う流木量

＜考え方＞

+----------------------------------------------------------------------+
| 土砂・洪水氾濫時に流出する流木の対策計画                             |
| で対象とする計画流出流木量は、計画発生流木量のうち想定される土砂・洪 |
| 水氾濫時に計画基準点まで流出する流木量である。計画発生流木量は、土砂 |
| ・洪水氾濫対策計画で想定される斜面崩壊、土石流、渓岸・渓床侵食によっ |
| て発生する流木量であり、樹種、林齢、材積等の構成に留意して設定する。 |
|                                                                      |
| 計画発生流木                                                         |
| 量および計画流出流木量は実材積で表し、計画基準点等において、流域の土 |
| 砂と流木の発生・流出を抑止・調整するための施設がない状態で算定する。 |
|                                                                      |
| 倒木、伐木、渓床に堆積している流木                                   |
| 量については、現地調査により、長さ・直径等をもとに流木量を算出する。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| > 土砂・洪水氾濫時に流出する流木の対策計画で扱う流木量として         |
| 計画発生流木量、計画流出流木量を設定することを基本とする。計画発生流 |
| 木量および計画流出流木量は、対象区域の現況調査資料、既往の災害資料、 |
| 類似地域の資料等を用いて定めることを基本とする。算定にあたっては、河 |
| 川砂防技術基準調査編の「流域・水系における流木調査」を参考にする。な |
| お、伐木、用材の流出等、人為的に発生したものは計画の対象に含めない。 |
+----------------------------------------------------------------------+

19. 流木処理計画

＜考え方＞

+----------------------------------------------------------------------+
| 土砂・洪水氾濫時に流出する                                           |
| 流木の対策計画では、流木の挙動を考慮して、計画流出流木量に対して、流 |
| 木による災害の防止・軽減を目的とした流木処理計画を定めるものとする。 |
|                                                                      |
| 流木対策には、流木の発生防止を目的とするも                           |
| のと、発生した流木を捕捉し下流への流出防止を目的とするものとがある。 |
|                                                                      |
| 流木処理計                                                           |
| 画を策定した流域において、森林等の状況が大きく変化した場合には、必要 |
| に応じて、計画で対象としている流木量の見直しを行い、計画を改定する。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| > 土砂・洪水氾濫時に流出する流木の対策計画における流木処             |
| 理計画は、計画流出流木量の流木の流出によって生じる被害を防止・軽減す |
| るためを砂防設備等により合理的かつ効果的に流木を処理するよう定めるこ |
| とを基本とする。なお、計画の策定に当たっては、土砂・洪水氾濫対策にお |
| ける土砂処理計画、土石流・流木処理計画と整合を図ることを基本とする。 |
+----------------------------------------------------------------------+

1.  []{#_Toc5031428
    .anchor}中期（土砂流出活発期）土砂流出対策計画に関する基本的な事項

    1.  []{#_Toc5031429 .anchor}総　説

＜考え方＞

+----------------------------------------------------------------------+
| 大規模な土砂生産が生じると、一般に生産土砂の                         |
| 全てが当該の一連の降雨時には流出せずに、生産土砂の多くが山地流域内に |
| 残存する。大量な生産土砂が山地流域内に残存した場合、当該の一連の降雨 |
| 以降の概ね数年間、土砂流出が活発になる。そこで、中期土砂流出対策計画 |
| で対象とする現象は、大規模な土砂生産後、それ以前の土砂流出状況より土 |
| 砂流出が活発な期間（以下、「土砂流出活発期間」という。）において河床 |
| 上昇や貯水池への土砂流出等により保全対象に被害を及ぼす現象とする。な |
| お、土砂流出活発期間中であっても、計画規模の降雨などにより新たな土砂 |
| 生産による災害の防止・軽減は、短期土砂・流木流出対策として検討する。 |
|                                                                      |
| 中期土砂流出対策計画は、短期土砂・流木流出対策計画、火山砂防計       |
| 画、深層崩壊・天然ダム等異常土砂災害対策計画と整合するように定める。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| > 中期土砂流出対策計                                                 |
| 画の策定にあたっては、大規模土砂生産現象発生後の土砂流出が活発な概ね |
| 数年間における降雨による土砂流出によって、被害が生じるおそれのある扇 |
| 状地、谷底平野、沖積平野等に位置する保全対象に対する有害な土砂を合理 |
| 的かつ効果的に処理するための土砂処理計画を策定することを基本とする。 |
+----------------------------------------------------------------------+

2.  []{#_Toc5031430 .anchor}計画規模

＜考え方＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  中期土砂流出対策の計画規模は、流域ごとに既往の災害、過去の豪雨およびその後の降雨による土砂生産・流出の実態、計画区域等の重要度、事業効果等を総合的に考慮して定めるものとし、出現確率を考慮して対象降雨の降雨量で定める。計画に用いる降雨の規模は、土砂流出活発期間に一般に生じうるものとし、新たに大量の土砂生産が生じるような規模の降雨は対象に含めない。また、土砂流出活発期間においては、規模の小さい降雨であっても土砂流出が生じるため、平均的な数ヶ月から数年間の降雨を対象として計画規模を定める。斜面崩壊・土石流による新たな大規模な土砂生産は生じないものの、土砂流出活発期間に生じる蓋然性の高い比較的規模の大きい一連の降雨時の土砂流出により、顕著な被害のおそれがある場合は、これを対象に計画規模を設定することも考えられる。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| > 中期土砂流出対                                                     |
| 策計画の計画規模は、流域の特性、過去の降雨特性、当該渓流における過去 |
| の土砂移動現象の発生状況等を総合的に考慮して定めることを基本とする。 |
+----------------------------------------------------------------------+

3.  []{#_Toc5031431 .anchor}保全対象・計画基準点等

＜考え方＞

+----------------------------------------------------------------------+
| 中期土砂流出対策計画に                                               |
| おける保全対象は大規模土砂生産現象発生後の土砂流出活発期間の土砂流出 |
| 等による被害が生じるおそれのある扇状地、谷底平野、沖積平野等に位置す |
| る人家、インフラ、ライフライン等とする。想定される被害は河床上昇に伴 |
| うなど、現象としては短期土砂・流木流出対策で想定する現象と関係する。 |
|                                                                      |
| 中期土砂                                                             |
| 流出対策における計画基準点は、土砂処理計画、施設配置計画の検討・策定 |
| のために設定する地点である。中期土砂流出対策計画は土砂・洪水氾濫対策 |
| 計画を策定している流域を対象に計画を策定するため、中期土砂流出対策計 |
| 画の計画基準点等は土砂・洪水氾濫対策計画の計画基準点に準じて定める。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| > 中期土砂流出対策における保全対象・計画基準点等は、本章 第2         |
| > 節2.2.2（3）に準じて定めることを基本とする。                       |
+----------------------------------------------------------------------+

4.  []{#_Toc5031432 .anchor}計画で扱う土砂量

＜考え方＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  中期土砂流出対策計画で扱う土砂量は、短期土砂・流木流出対策で対象とする計画生産土砂量のうち、短期土砂・流木流出対策で対象とする計画規模の一連の降雨継続期に流出しきらない土砂が流域内の斜面、河道に堆積した状況を想定して設定する。また、当該計画で取り扱う土砂流出に係る諸量（以下「計画流出土砂量」という。）は、計画基準点等を通過する土砂の量及び質（粒径）並びにそのタイミングと、保全対象周辺における河床の変動量、河川流量等とし、それぞれについて計画立案時点の状況下で想定される量と、河床上昇や貯水池への土砂流出等による保全対象への被害を防止・軽減する施設配置を行った状況下で想定される量の双方について設定する。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| > 中期土砂流出対策計画で                                             |
| は、計画で扱う土砂量として計画流出土砂量を設定することを基本とする。 |
| 計画流出土砂量は、大規模な土砂生産後、それ以前の土砂流出状況より土砂 |
| 流出が活発な期間における平均的な数ヶ月から数年間の流出土砂量とする。 |
+----------------------------------------------------------------------+

5.  []{#_Toc5031433 .anchor}中期土砂流出対策における土砂処理計画

＜考え方＞

+----------------------------------------------------------------------+
| 中期土砂流出対策                                                     |
| には、今後生じうる大規模土砂生産を想定して事前に実施する事前対策と、 |
| 大規模土砂生産が生じた後に実施する緊急的な対策がある。事前対策は、大 |
| 規模土砂生産直後に新たな施設の設置等に十分な猶予期間がない場合に効率 |
| 的かつ迅速に緊急的な対策（除石等）を実施するために有効な対策とする。 |
|                                                                      |
| 大規模土砂生産後の流出土砂の量や粒径は、大規模土砂生産前と異な       |
| るとともに、時間の経過とともに変化すると考えられる。そこで、中期土砂 |
| 流出対策に関する施設としては大規模土砂生産後の土砂流出状況（量、粒径 |
| ）に応じて、堰堤の型式・形状を変化させられる施設を積極的に検討する。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| > 中期土砂流出対策計画では                                           |
| 、事前対策と大規模土砂生産が生じた後に実施する緊急的な対策を組み合わ |
| せた土砂処理計画を策定することを基本とする。また、中期土砂流出対策の |
| 土砂処理計画の効果評価は河床変動計算に基づいて行うことを基本とする。 |
+----------------------------------------------------------------------+

2.  []{#_Toc5031434
    .anchor}長期（土砂流出継続期）土砂流出対策計画に関する基本的な事項

    1.  []{#_Toc5031435 .anchor}総　説

＜考え方＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  土砂生産の規模が非常に大きい場合など、崩壊地に植生が長期間回復せず、恒常的に崩壊地等から表面侵食等により粒径の細かい土砂が河道に供給され、活発な土砂流出が継続する場合がある。長期土砂流出対策計画においては、長期間恒常的に生じる活発な土砂流出による河床上昇や貯水池等を含む保全対象に被害を及ぼす現象を対象とする。長期土砂流出対策計画は、当該流域で別途定められる中期土砂流出対策計画、総合土砂管理計画と整合するように定める。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| > 長期土砂流出対策計画の策定にあたって                               |
| は、長期間継続的に生じる土砂流出によって、被害が生じるおそれのある扇 |
| 状地、谷底平野、沖積平野等に位置する保全対象に対する有害な土砂を合理 |
| 的かつ効果的に処理するための土砂処理計画を策定することを基本とする。 |
+----------------------------------------------------------------------+

2.  []{#_Toc5031436 .anchor}計画規模

＜考え方＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  長期土砂流出対策計画の計画規模は、中期土砂流出対策計画が終了する段階において、流域ごとに土砂流出状況を調査・モニタリングにより把握した上で、定めるものとする。計画に用いる降雨の規模は平均的に生じうるものとし、新たに大量の土砂生産が生じるような規模の降雨は対象に含めない。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| > 長期土砂流出対策計画の計画規模は、流域の特性、過去の降雨特性、当該 |
| 渓流における土砂流出状況等を総合的に考慮して定めることを基本とする。 |
+----------------------------------------------------------------------+

3.  []{#_Toc5031437 .anchor}保全対象・計画基準点等

＜考え方＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  長期土砂流出対策における保全対象は長期間継続する活発な土砂流出等による被害が生じるおそれのある扇状地、谷底平野、沖積平野等に位置する人家、インフラ、ライフライン等とする。長期土砂流出対策における計画基準点は、中期土砂流出対策計画の計画基準点に準じて定める。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| > 長期土砂流出対策における保全                                       |
| 対象・計画基準点等は、本章第2節2.3.3に準じて定めることを基本とする。 |
+----------------------------------------------------------------------+

4.  []{#_Toc5031438 .anchor}計画で扱う土砂量

＜考え方＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  長期土砂流出対策計画で扱う土砂量は、大規模土砂生産後から数年経過した後の崩壊地等から恒常的に河道に供給され流出する、平均的な土砂量として設定する。また、当該計画で取り扱う土砂流出に係る諸量（以下「計画流出土砂量」という。）は、計画基準点等を通過する土砂の量及び質（粒径）並びにそのタイミングと、保全対象周辺における河床の変動量、河川流量等とし、それぞれについて計画立案時点の状況下でモニタリングにより把握した量と、河床上昇等による保全対象への被害を防止・軽減する施設配置を行った状況下で想定される量の双方について設定する。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------
  長期土砂流出対策計画で扱う土砂量は、大規模土砂生産後から数年経過した後の恒常的に流出する平均的な年流出土砂量とする。
  ----------------------------------------------------------------------------------------------------------------------

5.  []{#_Toc5031439 .anchor}長期土砂流出対策における土砂処理計画

＜考え方＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  長期土砂流出対策は、対象とする土砂量が短期土砂・流木流出対策、中期土砂流出対策と比べれば限定的であると考えられるものの、土砂流出が長時間継続的に行われることから、対策は土砂生産の抑制を行うことが有効と考えられる。また、対策の効果が現れるまでは、短期土砂・流木流出対策、中期土砂流出対策として配置した砂防施設を活用することも有効であると考えられる。そのような場合、維持管理計画も必要に応じて見直すものとする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

  ----------------------------------------------------------------------------------
  長期土砂流出対策における土砂処理計画は、土砂生産抑制計画によることを基本とする。
  ----------------------------------------------------------------------------------

3.  []{#_Toc5031440
    .anchor}火山砂防地域における土砂災害対策計画（火山砂防計画）に関する基本的な事項

    1.  []{#_Toc5031441 .anchor}総　説

＜考え方＞

+----------------------------------------------------------------------+
| 火山噴火に伴う災害は、激甚かつ広                                     |
| 範囲にわたるため、社会的な影響も大きく、噴火後もその影響は長期化する |
| 場合が多い。そのため、火山砂防地域における土砂災害対策計画（以下、火 |
| 山砂防計画という。）の策定に当たっては、地域計画との整合を図り、安全 |
| で災害に強いまちづくりを支援するため、火山砂防地域において砂防設備等 |
| の整備と警戒避難体制等の整備などを併せて総合的に検討する必要がある。 |
|                                                                      |
| 火山砂防地域とは、火山地、火山                                       |
| 麓地又は火山現象により著しい土砂災害による被害が発生するおそれのある |
| 地域をいい、その特性として、火山活動の影響により地盤が非常に脆弱で、 |
| 他の山地と比べて降雨等による侵食が著しく、取り扱う土砂量が膨大となる |
| 場合があることや、地形の開析が進んでいない渓流において、土石流等が尾 |
| 根を乗り越えて流下する危険性があること等を充分に考慮する必要がある。 |
|                                                                      |
| 火山砂防計画は、火山砂防地域において発生する土砂移動                 |
| 現象に対応する計画であり、火山噴火に起因する土砂移動に対応する計画（ |
| 以下、「噴火対応火山砂防計画」という。）と、それ以外の通常の土砂移動 |
| に対応する計画（以下、「通常対応火山砂防計画」という。）とからなる。 |
|                                                                      |
| 噴火対応                                                             |
| 火山砂防計画で対象とする土砂移動現象は、火山活動に起因して発生する降 |
| 灰後の土石流及び火山泥流、必要に応じ溶岩流、火砕流等とし、その計画は |
| 、通常対応火山砂防計画と整合を図りながら、必要なハード対策とソフト対 |
| 策を、当該火山で発生する蓋然性の高い規模の噴火を考慮して計画的に整備 |
| する基本対策計画と、さらに突発的で規模の大きい火山噴火の場合でも迅速 |
| かつ効果的に対処するために、緊急の導流堤、既設堰堤の除石、流路の掘削 |
| 等によるハード対策、警戒監視等のソフト対策から様々な対策を実施し、被 |
| 害を軽減する方策として検討する火山噴火緊急減災対策砂防計画からなる。 |
|                                                                      |
| 噴火対応火山砂防計画は、短期土砂・流木流出対策計画、中期土砂流出対   |
| 策計画、深層崩壊・天然ダム等異常土砂災害対策と整合するように定める。 |
|                                                                      |
| 通常対応火山砂防計画で対象とする土砂移動現象は、降                   |
| 雨等により発生する土石流等であり、本章2.2.2土砂・洪水氾濫対策計画に  |
| 関する基本的な事項、2.2.3土石流・流木対策計画に関する基本的な事項、  |
| 2.2.4土砂・洪水氾濫時に流出する流木の対策計画に関する基本的な事項、  |
| 2.3中期土砂流出対策計画に関する基本的な事項に準じて計画を作成する。  |
|                                                                      |
| 図3-4 火山砂防計画の構成                                             |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 火山砂防計画は火山砂防地                                             |
| 域において、火山噴火に起因する土砂移動に対応する噴火対応火山砂防計画 |
| と、それ以外の通常の土砂移動に対応する通常対応火山砂防計画からなる。 |
|                                                                      |
| 噴火対応火山砂防計画は、通常対応火山砂防計画と整合を図るものとし     |
| 、計画的に実施が必要な対策を定める基本対策計画と、突発的な火山噴火災 |
| 害の被害を軽減する方策としての火山噴火緊急減災対策砂防計画からなる。 |
|                                                                      |
| 火山砂防計画は、火山砂                                               |
| 防地域において、発生する土砂災害から国民の生命、財産及び公共施設等を |
| 守ることを目的として策定することを基本とし、対象とする土砂移動現象は |
| 、火山ごとに、過去の噴火活動履歴あるいは火山周辺の自然条件や現在の活 |
| 動状況等から判断して発生が想定される現象を設定することを基本とする。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

1.  火山砂防事業制度要綱について，平成元年7月17日，建設省河砂発第50号，建設省河川局長通達．

```{=html}
<!-- -->
```
40. 「火山砂防計画策定指針（案）」の試行について，平成4年4月14日，建設省河砂部第8号，建設省河川局砂防部長通達．

    （最新版）火山砂防計画策定指針，令和5年3月，国土交通省水管理・国土保全局砂防部.

41. 火山噴火緊急減災対策砂防計画策定ガイドラインについて，平成19年4月27日，建設省国河第9号，河川局砂防部砂防計画課長通達．

    （最新版）火山噴火緊急減災対策砂防計画策定ガイドライン，令和5年3月，国土交通省水管理・国土保全局砂防部.

    1.  []{#_Toc5031442 .anchor}計画規模

＜考え方＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  噴火対応火山砂防計画の基本対策計画の規模は、噴火活動履歴等の情報を基に、過去に発生した土砂移動現象の種類、規模、地形・地質特性、発生頻度、災害概要を整理し、当該地域で発生する蓋然性の高い現象を抽出した上で、既往の噴火活動時等における土砂移動現象の発生状況や現在の活動状況、火山周辺の自然・社会的特性、事業効果などを考慮し定める。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  噴火対応火山砂防計画の基本対策計画において対象とする土砂移動現象の規模は、過去の噴火活動履歴と土砂移動現象あるいは火山周辺の自然条件や現在の火山活動状況、火山砂防地域の自然・社会的特性、事業効果等から総合的に判断して定めることを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

2.  []{#_Toc5031443 .anchor}保全対象・計画基準点等

＜考え方＞

+----------------------------------------------------------------------+
| 噴火対応火                                                           |
| 山砂防計画の基本対策計画の保全対象は、当該地域で発生する蓋然性の高い |
| 土砂移動現象に関する数値計算によって求めた被害想定範囲を基に定める。 |
|                                                                      |
| 当該地域で発生                                                       |
| する蓋然性の高い土砂移動現象の被害想定範囲は、過去の噴火活動等の状況 |
| を基に発生の蓋然性が高い土砂移動の規模から数値計算により求める。なお |
| 、溶岩流、火砕流の計算開始点は、想定される火口もしくは火口群とする。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 噴火対応火山砂防計画の基本対策                                       |
| 計画の保全対象は、当該地域の蓋然性が高い火山活動に伴う土砂災害による |
| 被害想定範囲内にある保全人口、人家、インフラ、ライフライン等とする。 |
|                                                                      |
| 計画基準点等は、2.2.2(3)および2.2.3(3)に準じて定めるものとする。     |
+----------------------------------------------------------------------+

3.  []{#_Toc5031444 .anchor}計画で扱う土砂量

＜考え方＞

+----------------------------------------------------------------------+
| 噴                                                                   |
| 火対応火山砂防計画の基本対策計画で扱う土砂量は、計画対象火山毎の噴火 |
| 履歴、土砂移動特性等からそれぞれ計画対象現象毎に次のように設定する。 |
|                                                                      |
| 降灰後の土石流については、当該地域で発生する蓋然性の高い             |
| 噴火現象による当該流域への降灰量や降灰の影響期間を考慮して、2.2.3(4) |
| に準じて定める。ただし、当該地域における過去の降灰後の土石流の実績が |
| 豊富にある場合には、過去の実績に基づき経験的に設定することができる。 |
|                                                                      |
| 火山泥流については、当該地域で発生する蓋然性の高い火砕流等           |
| の噴火現象の規模、積雪、火口湖等の水量を基に、数値計算により定める。 |
|                                                                      |
| > 溶岩流及び火砕流                                                   |
| については、当該火山で発生する蓋然性の高い噴火による噴出物量とする。 |
| >                                                                    |
| > 降灰、噴石などは、土砂生産域に影響を与える因子として評価する。     |
+----------------------------------------------------------------------+

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------
  噴火対応火山砂防計画の基本対策計画の対象土砂量は、過去の噴火時の噴出物量、対象火山の噴火履歴や特性を勘案して、対象現象ごとに設定することを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------

4.  []{#_Toc5031445 .anchor}土砂処理計画

＜考え方＞

+----------------------------------------------------------------------+
| 噴火対応火山砂                                                       |
| 防計画の基本対策計画の土砂処理計画は、当該地域で発生する蓋然性の高い |
| 噴火現象に伴う土砂移動現象による被害の防止・軽減を目的として定める。 |
|                                                                      |
| なお、基本対策計画の土砂処理計画は                                   |
| 、突発的な火山噴火災害時に迅速かつ効率的に緊急的なハード対策を実施す |
| るために有効となるよう、火山噴火緊急減災対策砂防計画との整合を図る。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 噴火対応火山砂防計                                                   |
| 画の基本対策計画のハード対策は、対象とする土砂移動現象に即した合理的 |
| かつ効果的な対策手法からなる土砂処理計画を策定することを基本とする。 |
|                                                                      |
| また、                                                               |
| 土砂処理計画の効果評価については、数値計算を用いることを基本とする。 |
+----------------------------------------------------------------------+

1.  []{#_Toc5031446
    .anchor}深層崩壊・天然ダム等異常土砂災害対策計画に関する基本的な事項

    1.  []{#_Toc5031447 .anchor}総　説

＜考え方＞

+----------------------------------------------------------------------+
| 深層崩壊・                                                           |
| 天然ダム等異常土砂災害対策計画で対象とする土砂移動現象は、降雨や地震 |
| および融雪等により発生した深層崩壊に起因する土石流、および河道が閉塞 |
| して形成された天然ダムによって引き起こされる天然ダム上流域の保全対象 |
| の浸水や天然ダムの決壊による大規模な土石流、土砂・洪水氾濫等である。 |
|                                                                      |
| 深層崩壊・天然ダム等異常土                                           |
| 砂災害対策計画は、深層崩壊・天然ダム等による異常土砂災害が予測できる |
| 場合に事前に行う対策と、天然ダム形成時に緊急に実施する対策から成る。 |
|                                                                      |
| 深層崩壊による被害のうち、特に甚大な被害を引き起こすであ             |
| ろう非常に規模の大きい深層崩壊に起因する場合は、被害を完全に防ぐこと |
| が困難な場合もある。そのような場合であっても、少なくとも人命は守るな |
| ど、ソフト対策も含み様々な対策を実施し、被害を減ずる方策を検討する。 |
|                                                                      |
| 深層崩壊・天然ダム等異常土砂災害対策計画は、短期土砂・流木流出       |
| 対策計画、中期土砂流出対策計画、火山砂防計画と整合するように定める。 |
+----------------------------------------------------------------------+

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  深層崩壊・天然ダム等異常土砂災害対策計画は、深層崩壊・天然ダムによる異常な土砂移動に伴い発生する災害から、国民の生命、財産及び公共施設等を守ることを目的として策定するものとする。深層崩壊は、崩壊土砂が保全対象を直撃するにとどまらず、大規模な土石流となるほか、河道を閉塞して天然ダムを形成するなど、複数の現象が生じる。そのため、深層崩壊・天然ダム等に起因する土砂災害対策計画は、これらの現象に応じて策定することを基本とする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜参考となる資料＞

1.  蒲原潤一，内田太郎：[深層崩壊対策技術に関する基本的事項](http://www.nilim.go.jp/lab/bcg/siryou/tnn/tnn0807pdf/ks0807.pdf)，国土技術政策総合研究所資料，第807号，2014．

```{=html}
<!-- -->
```
42. 内田太郎，桜井亘，鈴木清敬，萬德昌明：[深層崩壊に起因する大規模土砂災害被害想定手法](http://www.nilim.go.jp/lab/bcg/siryou/tnn/tnn0983pdf/ks0983.pdf)，国土技術政策総合研究所資料，第983号，2017．

43. 田村圭司，内田太郎，鈴木隆司，寺田秀樹，栗原淳一：[深層崩壊の恐れのある渓流抽出マニュアル（案）](http://www.mlit.go.jp/common/001197940.pdf)，土木研究所資料，第4155号，2008．

    1.  []{#_Toc5031448 .anchor}計画規模

＜考え方＞

+----------------------------------------------------------------------+
| 深層崩壊・天然ダム等異常土砂災害対                                   |
| 策計画の規模は、過去の深層崩壊の実績や深層崩壊跡地等の情報を基に、過 |
| 去に発生した深層崩壊の規模、土砂移動現象の種類、地形・地質特性、発生 |
| 頻度、災害概要を整理し、当該地域で発生する蓋然性の高い現象を抽出した |
| 上で、既往の災害等における土砂移動現象の発生状況などを考慮し定める。 |
|                                                                      |
| また、天然ダム形成時に緊急に実施するハード対策の計画                 |
| 規模は、天然ダム形成後の出水を考慮し、施工可能な範囲で適切に定める。 |
|                                                                      |
| 天然ダムの規模や形成箇所によって、天然ダム形成から災害発生に至る時間 |
| が異なると考えられる。そこで「事前に防止・軽減するための土砂処理計画 |
| 」は、天然ダム形成後、対策に十分な時間的猶予がないと考えられる場合を |
| 対象とする。天然ダム形成後、災害発生まで対策を実施する時間が十分に得 |
| られる場合については、天然ダム形成時に緊急に実施する対策で対応する。 |
+----------------------------------------------------------------------+

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  深層崩壊・天然ダム等異常土砂災害対策計画において対象とする土砂移動現象の規模は、過去の深層崩壊の規模、深層崩壊に起因して生じる土石流や天然ダムの決壊による土石流や土砂・洪水氾濫等の土砂移動現象等を総合的に考慮して定めることを基本とする。また、天然ダム形成時に緊急に実施するハード対策については、対策の対象とする天然ダムを越流する流量規模を設定することを基本とする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜例　示＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------
  2011年9月に発生した紀伊半島大水害時に形成された天然ダムに対する緊急のハード対策では、2年超過確率規模の洪水を暫定的な計画規模として仮排水路の整備を行った事例がある。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜参考となる資料＞

1.  蒲原潤一，内田太郎：[深層崩壊対策技術に関する基本的事項](http://www.nilim.go.jp/lab/bcg/siryou/tnn/tnn0807pdf/ks0807.pdf)，国土技術政策総合研究所資料，第807号，2014．

```{=html}
<!-- -->
```
44. 内田太郎，桜井亘，鈴木清敬，萬德昌明：[深層崩壊に起因する大規模土砂災害被害想定手法](http://www.nilim.go.jp/lab/bcg/siryou/tnn/tnn0983pdf/ks0983.pdf)，国土技術政策総合研究所資料，第983号，2017．

45. 田村圭司，内田太郎，鈴木隆司，寺田秀樹，栗原淳一：[深層崩壊の恐れのある渓流抽出マニュアル（案）](http://www.mlit.go.jp/common/001197940.pdf)，土木研究所資料，第4155号，2008．

    1.  []{#_Toc5031449 .anchor}保全対象・計画基準点等

＜考え方＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  深層崩壊・天然ダム等異常土砂災害対策計画の保全対象は、当該地域で発生する蓋然性の高い現象に関する数値計算によって求めた被害想定範囲を基に定める。深層崩壊に起因して発生する土石流の被害想定範囲は、当該地域で発生の蓋然性が高い深層崩壊の規模から数値計算により求める。また、天然ダムの破壊により生じる土石流や土砂・洪水氾濫の被害想定範囲は、当該地域における過去の天然ダムの実績や深層崩壊の土砂量、数値計算等により、天然ダム高さなど形状や湛水規模を推定した上で、数値計算を実施して求める。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| > 深層崩壊・天然ダム等異常土砂災害対策計画                           |
| の保全対象は当該地域で発生の蓋然性が高い深層崩壊による土砂流出現象に |
| よる被害想定範囲内にある保全人口、人家、インフラ、ライフライン等とす |
| る。計画基準点等は、2.2.2(3)および2.2.3(2)に準じて定めるものとする。 |
+----------------------------------------------------------------------+

2.  []{#_Toc5031450 .anchor}計画で扱う土砂量

＜考え方＞

+----------------------------------------------------------------------+
| 深層崩壊・天然ダム等異常土砂災害対策計画                             |
| における計画生産土砂量は、計画規模の深層崩壊による生産土砂量である。 |
|                                                                      |
| > 計画流出土砂量                                                     |
| は、計画生産土砂量により生じる土石流や、形成された天然ダムの破壊に伴 |
| う土石流や土砂・洪水氾濫により、計画基準点等に流出する土砂量である。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| > 深層崩壊・天然ダム等                                               |
| 異常土砂災害対策計画で扱う土砂量として計画生産土砂量、計画流出土砂量 |
| を設定することを基本とする。深層崩壊・天然ダム等異常土砂災害対策計画 |
| における計画生産土砂量は、計画規模の深層崩壊に伴う生産土砂量とする。 |
| >                                                                    |
| > 深層崩壊に起因して発                                               |
| 生する土石流の計画流出土砂量は、計画生産土砂量を基に数値計算により定 |
| めることを基本とする。また、天然ダムの破壊により生じる土石流や土砂・ |
| 洪水氾濫の計画流出土砂量は、計画生産土砂量を基に天然ダムの高さなど形 |
| 状や湛水規模を推定した上で、数値計算を実施して行うことを基本とする。 |
+----------------------------------------------------------------------+

3.  []{#_Toc5031451
    .anchor}深層崩壊・天然ダム等異常土砂災害対策における土砂処理計画

＜考え方＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  深層崩壊・天然ダム等異常土砂災害対策計画は、深層崩壊や天然ダムによる異常土砂災害を事前に防止・軽減するための土砂処理計画と、天然ダム形成時に緊急に実施する天然ダムの破壊を防止するための土砂処理計画がある。事前に対策を実施する場合では、砂防堰堤の設置等がある。天然ダム形成時に緊急に実施する対策は、天然ダム地点での対策と天然ダム地点下流域での対策を計画する。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| > 深層崩壊・天然ダム等による異常土砂災害対策計画のハー               |
| ド対策は、対象とする土石等の移動現象に即した適切な対策手法からなる土 |
| 砂処理計画を策定することを基本とする。土砂処理計画の効果評価について |
| は土石流計算、河床変動計算等による数値計算を用いることを基本とする。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

1.  蒲原潤一，内田太郎：[深層崩壊対策技術に関する基本的事項](http://www.nilim.go.jp/lab/bcg/siryou/tnn/tnn0807pdf/ks0807.pdf)，国土技術政策総合研究所資料，第807号，2014．

```{=html}
<!-- -->
```
46. 内田太郎，桜井亘，鈴木清敬，萬德昌明：[深層崩壊に起因する大規模土砂災害被害想定手法](http://www.nilim.go.jp/lab/bcg/siryou/tnn/tnn0983pdf/ks0983.pdf)，国土技術政策総合研究所資料，第983号，2017．

47. 田村圭司，内田太郎，鈴木隆司，寺田秀樹，栗原淳一：[深層崩壊の恐れのある渓流抽出マニュアル（案）](http://www.mlit.go.jp/common/001197940.pdf)，土木研究所資料，第4155号，2008．

    6.  []{#_Toc5031452 .anchor}第3節
        地すべり防止計画に関する基本的な事項

        1.  []{#_Toc5031453 .anchor}総　説

＜考え方＞

+----------------------------------------------------------------------+
| 地すべり防止計画で対象とする現象は、一定範囲の土地                   |
| が地下水等に起因してすべる現象又はこれに伴って移動する現象とする。地 |
| すべり防止計画では、地下水等に起因した移動現象と移動に伴ってその後に |
| 生じる現象に対応した対策を計画する。現在も継続的に移動している土地、 |
| あるいは地すべり地形を呈する等移動するおそれがある土地が対象となる。 |
|                                                                      |
| 地すべりによる災害は、我が国の有する特有の地形、                     |
| 地質、気象及び土地利用などの特殊な条件のもとに発生しており、地すべり |
| 斜面上及び地すべりの発生に伴う移動土塊の到達範囲にある保全対象が受け |
| る直接的な災害と、河川等の埋塞による湛水及び埋塞土砂の2次的な決壊・  |
| 氾濫によりその上下流域にもたらされる間接的な災害の2つに大別される。  |
|                                                                      |
| 地すべり防止計画は、上記の直接的及び間接的な地                       |
| すべりによる災害を防止・軽減するため、事前に実施される地すべり調査及 |
| びその解析結果を踏まえて、地すべり防止区域の地形、地質、気象などの諸 |
| 条件や土地利用、保全対象の状況、緊急性等を考慮し計画することとし、策 |
| 定にあたっては、砂防計画におけるその他の計画と整合するように定める。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| > 地すべ                                                             |
| り防止計画は、地すべり現象が地形、地質、地質構造等の地すべりにおかれ |
| ている環境によって異なることから、調査により対象とする地すべりの特徴 |
| を的確に把握し、効果的な対策を実施できるよう計画を定めるものとする。 |
+----------------------------------------------------------------------+

1.  []{#_Toc5031454 .anchor}計画規模

＜考え方＞

+----------------------------------------------------------------------+
| 地すべり                                                             |
| 防止計画において計画規模は、一連の地すべりごとに既往の災害、過去の災 |
| 害履歴、現在の変状の状況の有無、将来生じうる災害を想定して定めるもの |
| とし、一般には計画安全率の設定などにより計画規模を定めるものである。 |
|                                                                      |
| なお、地すべり防止区域内において急傾斜地の崩壊等の土砂災害の発生     |
| も危惧される場合には、これらの対策も含めた計画とすることが望ましい。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| >                                                                    |
| 地すべり防止計画における計画規模は、地すべりの現象、保全対象の重要度 |
| 、事業の緊急性、事業効果等を総合的に考慮して定めることを基本とする。 |
+----------------------------------------------------------------------+

1.  []{#_Toc5031455 .anchor}保全対象

＜考え方＞

+----------------------------------------------------------------------+
| 地すべり現象は一般に緩慢な動きを呈する                               |
| ものが多いが、中には突発的に移動、滑落に至る地すべりも見られる。した |
| がって、地すべり防止計画で対象とする地すべり近傍での事例等を参考にし |
| て、地すべりの移動範囲を設定し、被害の及ぶ範囲を設定する必要がある。 |
|                                                                      |
| 保全対象の重要性は、施設等の利用状況、                               |
| 代替施設の有無によっても異なる。例えば、道路の場合、通行量、代替ルー |
| トの有無によっても異なる。地すべりは山地部で発生することが多く、この |
| ような場合、代替ルートがあっても迂回に多くの時間を要する場合がある。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| > 地すべり防止計画における保全対象は、対象とする                     |
| 地すべりの規模や発生・運動機構等を考慮して特定することを基本とする。 |
| >                                                                    |
| > 保全対象は以下の被害形態を考慮して定めるものとする。               |
| >                                                                    |
| > ①地すべり斜面上                                                    |
| の人命、人家、道路、田畑、公共施設、インフラ、ライフライン等への被害 |
| >                                                                    |
| > ②地すべり斜面より下方に位置する人命、人家、道路、                  |
| 田畑、公共施設、インフラ、ライフライン等への地すべりの移動に伴う被害 |
| >                                                                    |
| > ③天然ダム部上流域の浸水被害                                        |
| >                                                                    |
| > ④天然ダムの決壊による下流域の土石流、洪水被害                      |
+----------------------------------------------------------------------+

＜参考となる資料＞

1.  独立行政法人土木研究所土砂管理研究グループ地すべりチーム：地すべり防止技術指針及び同解説（提案），土木研究所資料，第4077号，2007．

    （最新版）地すべり防止技術指針及び同解説，平成20年4月，国土交通省砂防部，(独)土木研究所.

    1.  []{#_Toc5031456 .anchor}計画安全率

＜考え方＞

+----------------------------------------------------------------------+
| 地すべり                                                             |
| 防止計画における計画安全率の設定方法は、既往の切土、盛土による地すべ |
| りの発生事例から、地すべり発生前の安全率を1.00と仮定した場合に、5～1 |
| 0%程度の安全率の低下によって地すべりが活発化したという事例やすべり面 |
| が地すべり運動に伴って強度低下を起こすこと、また、運動の進行に伴って |
| 土塊が破砕され透水性が高まると予想されることに基づき、従来より各地の |
| 地すべり防止工事において経験的に定められてきた計画安全率を参考にして |
| いる。また、それらの計画安全率は、安定解析式として簡便法を用い、土質 |
| 強度定数を逆算法によって求めた経験値であることに留意する必要がある。 |
|                                                                      |
| なお、こ                                                             |
| こで述べている安全率は、地すべり防止工事の量を決定するために用いられ |
| るものであり、工事後の斜面の安定性を示すものではないことに留意する。 |
|                                                                      |
| 一般的な                                                             |
| 地すべり防止工事としては、現在の滑動状況に応じて現況安全率を0.95～1. |
| 00に仮定し、地すべり発生・運動機構や保全対象の重要度、想定される被害 |
| の程度等を総合的に考慮して計画安全率（P.Fs）を1.10～1.20に設定する。 |
|                                                                      |
| また、応急対策などで当面の安全確保                                   |
| を図る場合であっても計画安全率（P.Fs）1.05以上を設定するものとする。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| > 地すべり防止計画では、                                             |
| 地すべり運動ブロック毎に計画安全率（P.Fs）を定めることを基本とする。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

1.  独立行政法人土木研究所土砂管理研究グループ地すべりチーム：地すべり防止技術指針及び同解説（提案），土木研究所資料，第4077号，2007．

    （最新版）地すべり防止技術指針及び同解説，平成20年4月，国土交通省砂防部，(独)土木研究所.

    1.  []{#_Toc5031457 .anchor}地すべり防止計画

        1.  []{#_Toc5031458 .anchor}総　説

＜考え方＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------
  地すべり防止のためのハード対策は、地すべり防止区域及びその周辺地域の土地利用等を勘案し、求められる安全性を確保するよう合理的かつ効果的に地すべり防止施設を配置する。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| > 地すべり防止計画におけるハード対策は、                             |
| 事前に実施される地すべり調査、解析結果を踏まえて、それぞれの地すべり |
| の現象（地形、地質、規模、滑動状況等）、計画安全率等を勘案し、周囲の |
| 環境との調和などを十分考慮して適切な工法を選定し、定めるものとする。 |
+----------------------------------------------------------------------+

1.  []{#_Toc5031459 .anchor}地すべり防止工事基本計画

＜考え方＞

  ---------------------------------------------------------------------------------------------------------------------------
  地すべり防止計画の策定にあたっては、地すべり等防止法9条で規定された地すべり防止工事基本計画との整合に留意する必要がある。
  ---------------------------------------------------------------------------------------------------------------------------

＜必　須＞

+----------------------------------------------------------------------+
| > 地すべり防止工事基本計画においては、以下の事項を定めるものとする。 |
| >                                                                    |
| > ・地すべり防止工事を施行しようとする区域                           |
| >                                                                    |
| > ・施行しようとする地すべり防止工事（地すべ                         |
| り防止施設の新設又は改良を除く。）の種類、施行箇所及び規模又は新設し |
| 、若しくは改良しようとする地すべり防止施設の種類、配置、構造及び規模 |
| >                                                                    |
| > ・施行しようとする地すべり防止工事に要する費用の概算額             |
| >                                                                    |
| > ・                                                                 |
| 施行しようとする地すべり防止工事によって利益を受ける地域及びその状況 |
+----------------------------------------------------------------------+

6.  []{#_Toc5031460 .anchor}第4節
    急傾斜地崩壊対策計画に関する基本的な事項

    1.  []{#_Toc5031461 .anchor}総　説

＜考え方＞

+----------------------------------------------------------------------+
| 急傾斜地崩壊対策計画で対象とする現象は、急傾斜                       |
| 地において、降雨又は地震等の自然現象を誘因として発生する崩壊とする。 |
|                                                                      |
| 斜面崩壊の誘                                                         |
| 因は一般に降雨、地震等であるが、地形、地質等多数の要因が関与し、その |
| 機構は複雑で多くの問題があるので、計画にあたっては事前に十分な調査を |
| 行い、崩壊の要因、機構を把握し、有効、適切な計画をたてる必要がある。 |
|                                                                      |
| 急傾斜地                                                             |
| 崩壊対策計画は、砂防計画におけるその他の計画と整合するように定める。 |
+----------------------------------------------------------------------+

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  急傾斜地崩壊対策計画は、急傾斜地の崩壊の機構が地形、地質等の急傾斜地のおかれている環境によって異なることから、調査により対象とする急傾斜地の特徴を的確に把握し、効果的な対策を実施できるよう計画を定めるものとする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

1.  []{#_Toc5031462 .anchor}保全対象

＜考え方＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  急傾斜地崩壊対策計画における保全対象は、急傾斜地の崩壊により被害が生じるおそれのある範囲にある保全人口、人家、インフラ、ライフライン等である。被害が生じるおそれのある範囲は、現地調査や地形調査をもとに、崩壊するおそれのある範囲を調査し設定する。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------
  急傾斜地崩壊対策計画で対象とする保全対象は、急傾斜地の崩壊により被害が生ずるおそれのある保全人口、人家、インフラ、ライフライン等とする。
  ------------------------------------------------------------------------------------------------------------------------------------------

1.  []{#_Toc5031463 .anchor}計画で扱う諸量

＜考え方＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  急傾斜地崩壊対策計画における計画で扱う諸量は、過去の表層崩壊の事例調査、現地踏査、地盤調査等により設定する。現地踏査の際に確認する地形・地質・植生・湧水等の調査に加え、勾配、高さ、崩壊深、土砂量は、現地踏査、測量、ボーリング、貫入試験等により設定する。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  急傾斜地崩壊対策計画における計画で扱う諸量は、勾配、高さ、崩壊深、土砂量、落石の大きさ等であり、それぞれ既往の崩壊事例、資料、地形調査、植生調査、地盤調査等により定めることを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

1.  []{#_Toc5031464 .anchor}急傾斜地崩壊対策計画

＜考え方＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  急傾斜地崩壊対策計画は、斜面形状の改善、風化・侵食の防止、不安定となる地下水の除去、表層の土石の移動の防止を基本とし、これにより対策できない場合や十分でない場合には、斜面が崩壊しても保全対象への被害を防止または軽減するような施設あるいは施設の組み合わせを検討するものとする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------
  急傾斜地崩壊対策計画は、対象となる斜面の地形、地質、崩壊の要因、形態を想定し、周囲の環境との調和などを十分考慮して適切な工法を選定し、定めることを基本とする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------

7.  []{#_Toc5031465 .anchor}第5節 雪崩対策計画に関する基本的な事項

    1.  []{#_Toc5031466 .anchor}総　説

＜考え方＞

+----------------------------------------------------------------------+
| 雪崩対策計画で対象とする現象は、表層                                 |
| 、全層等の雪崩及び斜面上の積雪移動現象（クリープ、グライド）とする。 |
|                                                                      |
| 雪崩の痕跡は、その形態より、一般                                     |
| に発生区、走路、堆積区の3つに区分される。典型的な雪崩痕跡の区分の図  |
| は、図3-5に示すとおりである。発生区は積雪が破壊し動き始める区域、堆  |
| 積区は崩れ落ちた雪の運動が停止し運ばれた雪が堆積する区域である。走路 |
| は、発生区と堆積区の間にあり雪の堆積がほとんど起こらない区域である。 |
|                                                                      |
| 雪崩対策計画は、砂防計画におけるその他の計画と整合するように定める。 |
|                                                                      |
| ![](media/image8.emf){width="4.010416666666667in"                    |
| height="2.7901410761154857in"}                                       |
|                                                                      |
| 図3-5 典型的な雪崩痕跡の区分                                         |
+----------------------------------------------------------------------+

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  雪崩対策計画は、雪崩現象が地形、植生、気象等の計画箇所におかれている環境によって異なることから、調査により対象とする雪崩の特徴を的確に把握し、効果的な対策を実施できるよう計画を定めるものとする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜参考となる資料＞

1.  雪崩対策事業の実施について，昭和60年4月5日，建設省河傾発第11号，建設省河川局長通達．

```{=html}
<!-- -->
```
48. 建設省河川局砂防部監修：集落雪崩対策工事技術指針（案），(社)雪センター，1996.

49. 独立行政法人つくば中央研究所土砂管理研究グループ雪崩・地すべり研究センター，寒地土木研究所寒地道路研究グループ雪氷チーム：[豪雪時における雪崩斜面の点検と応急対策事例](https://www.pwri.go.jp/team/niigata/dokensiryo4167_web.pdf)，土木研究所資料，第4167号，2010．

    1.  []{#_Toc5031467 .anchor}保全対象

＜考え方＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  雪崩対策計画における保全対象は、雪崩により被害が生じるおそれのある範囲にある保全人口、人家、インフラ、ライフライン等である。危害が生じるおそれのある範囲は、現地調査や地形調査をもとに、雪崩到達範囲を調査し設定する。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| > 雪崩対策策計画で対象とする保全対象は、雪崩により被害               |
| が生ずるおそれのある保全人口、人家、インフラ、ライフライン等とする。 |
+----------------------------------------------------------------------+

1.  []{#_Toc5031468 .anchor}計画で扱う諸量

＜考え方＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  雪崩対策計画における計画で扱う諸量は積雪・気象調査、地形調査、植生調査、雪崩調査等により定める。なお、雪崩調査は雪崩実態調査、雪崩危険度調査、雪崩の運動解析ならびに雪崩による衝撃力解析から構成される。それぞれの調査における基礎調査として、地形図、空中写真、雪崩履歴資料、積雪・気象資料、植生資料、地質資料等の収集を行う資料調査や、現地において対象とする区域の地形状況、植生状況、地盤状況を概略的に把握する現地調査を行う。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------
  雪崩対策計画で扱う諸量は雪崩の種類、設計積雪深、雪崩の到達範囲、層厚増加等であり、それぞれ積雪・気象調査資料、地形調査、植生調査、雪崩調査等により定めるものとする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------

1.  []{#_Toc5031469 .anchor}雪崩対策計画

＜考え方＞

  ------------------------------------------------------------------------------------------------------------------------
  雪崩の痕跡は、一般に発生区、走路、堆積区に区分され、対策の実施にあたり各区分に適した雪崩防止施設を選定する必要がある。
  ------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| > 雪崩対策計画は、対象となる箇所の斜面の特性、雪崩の種類、設計       |
| 積雪深、雪崩の到達範囲、斜面の雪崩危険度評価等を勘案し、周囲の環境と |
| の調和などを十分考慮して適切な雪崩対策施設を選定し定めるものとする。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

1.  雪崩対策事業の実施について，昭和60年4月5日，建設省河傾発第11号，建設省河川局長通達．

```{=html}
<!-- -->
```
50. 建設省河川局砂防部監修：集落雪崩対策工事技術指針（案），(社)雪センター，1996.

51. 独立行政法人つくば中央研究所土砂管理研究グループ雪崩・地すべり研究センター，寒地土木研究所寒地道路研究グループ雪氷チーム：[豪雪時における雪崩斜面の点検と応急対策事例](https://www.pwri.go.jp/team/niigata/dokensiryo4167_web.pdf)，土木研究所資料，第4167号，2010．

    6.  []{#_Toc5031470 .anchor}第6節 自然環境への配慮等

        1.  []{#_Toc5031471 .anchor}総　説

＜考え方＞

+----------------------------------------------------------------------+
| 山腹斜面等山地部から渓流、河道に至る空間やこれらに隣接する周         |
| 辺の自然空間等においては、それぞれの場所の条件に合った生息・生育環境 |
| 、景観等が存在しているため、流域等において計画される砂防基本計画、地 |
| すべり防止計画等の策定に当たっては、生物の生息・生育環境、景観、水質 |
| 等の現状等を踏まえ、生物の生息・生育環境の連続性や良好な景観の確保等 |
| が図られるよう、施設配置、施設の形状、構造等について十分に配慮する。 |
|                                                                      |
| なお、流砂系における土砂移動の連続性の確                             |
| 保等総合的な土砂管理の推進に係わる内容に関しては第1章第4節に準じる。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| > 砂防基本計画、地すべり防止計                                       |
| 画、急傾斜地崩壊対策計画及び雪崩対策計画の策定に当たっては、計画区域 |
| 及びその周辺における自然環境・景観等に十分配慮することを基本とする。 |
+----------------------------------------------------------------------+

＜推　奨＞

+----------------------------------------------------------------------+
| 砂防基本計                                                           |
| 画では、山腹斜面の侵食の緩和、植生の導入を図ることにより、荒廃した自 |
| 然を本来あるべき姿へと復元することを目的の一つとしていることから、荒 |
| 廃地へ植生を導入する際には、在来種の導入に努めるほか、周辺や下流域の |
| 自然環境と調和の取れた種を選定することが望ましい。また、植生の復元の |
| 過程においては目標を設定し、必要に応じ維持管理を行うことが望ましい。 |
|                                                                      |
| また、市街地等にある緑豊か                                           |
| な斜面は、市街地の景観を構成する重要な要素であり、生物の生息・生育環 |
| 境を保全する貴重な空間である。そのため、砂防設備、地すべり防止施設、 |
| 急傾斜地崩壊防止施設及び集落雪崩防止施設による対策を検討するにあたっ |
| ては、周辺の生活環境等に十分配慮し、既存木の保全や在来種などによる新 |
| たな植生の導入等について検討を行った上で、計画を策定するよう努める。 |
+----------------------------------------------------------------------+

1.  []{#_Toc5031472 .anchor}都市山麓グリーンベルト整備計画

    1.  []{#_Toc5031473 .anchor}総　説

＜考え方＞

+----------------------------------------------------------------------+
| 都                                                                   |
| 市山麓グリーベルト整備計画は、基本構想を踏まえ、砂防事業者等が実施す |
| る具体的な対策について総合的な土砂災害対策計画となるように策定する。 |
|                                                                      |
| その整備においては、砂防設備、地すべり防止施設及び急傾斜地崩壊防     |
| 止施設等の総合的な整備にあわせ、砂防指定地の適切な管理として樹林の持 |
| つ多様な機能や効果を発揮させるために、樹種転換等必要な措置を講じる。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| > 都市山麓グリーンベ                                                 |
| ルト整備計画は、都市山麓グリーンベルトの基本構想を踏まえ、地域計画等 |
| と整合を図り、砂防設備、地すべり防止施設、急傾斜地崩壊防止施設等の整 |
| 備による対策と、砂防指定地の適切な管理及び各種の法令等による適切な土 |
| 地利用の誘導により、土砂災害に強い地域づくりを行うことを基本とする。 |
+----------------------------------------------------------------------+

＜例　示＞

+----------------------------------------------------------------------+
| 都市山麓グリーン                                                     |
| ベルトとは、土砂災害の発生のおそれがある都市山麓の市街地周辺地域にお |
| いて、土砂災害の防止・軽減、良好な都市環境や風致・景観の形成、生態系 |
| の保全・育成等を目的として、市街地周辺に隣接する山腹斜面・渓流部及び |
| 山麓部の斜面を構成する一連の樹林に着目し設定される斜面緑地帯である。 |
|                                                                      |
| 都市山麓グリーンベルトにおける基本構                                 |
| 想とは、当該趣旨を踏まえ、市町村が主体となり、関係機関との連携、各種 |
| 法令による土地利用規制等との調整を図り、将来の都市山麓グリーンベルト |
| の整備の目標や対策の考え方等について総合的に定めたものであり、緑を活 |
| かした広域的な防災空間のマスタープランとしての役割を担うものである。 |
+----------------------------------------------------------------------+

1.  []{#_Toc5031474 .anchor}対策の基本

＜考え方＞

+----------------------------------------------------------------------+
| 都市山麓の市街地周辺地域の山腹斜面・渓流部                           |
| 及び山麓部において、土石流等土砂の流出による災害、地すべりによる災害 |
| 、急傾斜地の崩壊による災害等の防止・軽減を図るため、市街地に隣接する |
| 一連の面的な樹林帯の形成を図り、砂防堰堤、山腹工事等による砂防設備、 |
| 地すべり防止施設及び急傾斜地崩壊防止等による対策を総合的に計画する。 |
|                                                                      |
| 特に、無秩序な市街化の防止を図るために、公園事業のほか他事業         |
| との連携を図るとともに、土砂災害警戒区域などの指定はもとより、都市計 |
| 画法など各種法令に基づく土地利用規制等と適切に連携し計画を策定する。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| > 都市山麓グリーンベルト整備計画は、砂防指定地の管理の一環と         |
| して、樹林が有する表面侵食などによる土砂生産や土砂流出の抑制等の機能 |
| の維持・増進を図るために行う樹林の保全・育成、樹林構造の改善等を実施 |
| するとともに、砂防設備等による対策等を一体的に実施することによって、 |
| 面的な防災空間の創出と保全が図られるように計画することを基本とする。 |
| >                                                                    |
| > 砂防指定地において、砂防設備等に                                   |
| よる対策等を一体的に実施することによって、面的な防災空間の創出と保全 |
| が図られるように計画するものとする。特に、都市山麓グリーンベルト整備 |
| 計画では、無秩序な市街化の防止を図り、当該地域の安全を確保するために |
| 、他事業や各種法令に基づく土地利用規制と連携を図ることを基本とする。 |
+----------------------------------------------------------------------+

＜推　奨＞

+----------------------------------------------------------------------+
| 計画の策定に当たっては、良好な都市環境や風致・景観の形成、生態系の保 |
| 全、健全なレクリエーションの場の提供等に十分配慮することが望ましい。 |
|                                                                      |
| また、樹林は、その保全、育成、樹林構造の改善を適切に行うことに       |
| より、良好な都市環境や風致・景観の形成、生物の生育・生息環境の保全、 |
| 健全なレクリエーションの場の提供等が期待されることから、計画の策定に |
| 当たっては、地域の実情を踏まえ、これらの効果が発揮されるよう努める。 |
+----------------------------------------------------------------------+

**基本計画編**

**第３章 砂防（土砂災害等対策）計画**

**第７節 土砂災害のソフト対策に関する基本的な事項**

**目 次**

> [第7節 土砂災害のソフト対策に関する基本的事項 29](#_Toc103088638)
>
> [7．1 総説 29](#_Toc103088639)
>
> [7．2 土砂災害のソフト対策 29](#_Toc103088640)
>
> [7．2．1 総説 29](#_Toc103088641)
>
> [7．2．2 土砂災害が発生するおそれのある区域の把握 30](#_Toc103088642)
>
> [7．2．3 土砂災害に関する警戒避難体制の整備 34](#_Toc103088643)
>
> [7．2．4 開発行為に対する制限や建築物の構造規制や移転の促進等
> 40](#_Toc103088644)

令和４年６月　版

適用上の位置付け

> 　河川砂防技術基準計画編は、基準の適用上の位置付けを明確にするために、下表に示すように適用上の位置付けを分類している。

+--------+------------------+------------------+------------------+
| 分　類 | 適用上の位置付け | 末尾の字句例     |                  |
+--------+------------------+------------------+------------------+
| 考え方 | 技術資料         | ●目              | 「･･･ある。      |
|        |                  | 的や概念、考え方 | 」「･･･いる。」  |
|        |                  | を記述した事項。 |                  |
|        |                  |                  | 「･･･なる。      |
|        |                  |                  | 」「･･･れる。」  |
+--------+------------------+------------------+------------------+
| 必　須 | 技術基準         | ●法令による規定  | 「･･･なければ    |
|        |                  | や技術的観点から | ならない。」「･  |
|        |                  | 実施すべきである | ･･ものとする。」 |
|        |                  | ことが明確であり |                  |
|        |                  | 遵守すべき事項。 |                  |
+--------+------------------+------------------+------------------+
| 標　準 | 技術基準         | ●特              | 「･･･            |
|        |                  | 段の事情がない限 | を標準とする。」 |
|        |                  | り記述に従い実施 |                  |
|        |                  | すべきだが、状況 | 「･･･            |
|        |                  | や条件によって一 | を基本とする。」 |
|        |                  | 律に適用すること |                  |
|        |                  | はできない事項。 | 「･･･による。」  |
+--------+------------------+------------------+------------------+
| 推　奨 | 技術資料         | ●状況や条件      | 「               |
|        |                  | によって実施する | ･･･望ましい。」  |
|        |                  | ことが良い事項。 |                  |
|        |                  |                  | 「               |
|        |                  |                  | ･･･推奨する。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･務める。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･必要に応    |
|        |                  |                  | じて･･･する。」  |
+--------+------------------+------------------+------------------+
| 例　示 | 技術資料         | ●適用条件や実施  | 「               |
|        |                  | 効果について確定 | ･･･などの手法（  |
|        |                  | している段階では | 事例）がある。」 |
|        |                  | ないが、状況や条 |                  |
|        |                  | 件によっては導入 | 「･･･など        |
|        |                  | することが可能な | の場合がある。」 |
|        |                  | 新技術等の例示。 |                  |
|        |                  |                  | 「･･･など        |
|        |                  | ●状              | が考えられる。」 |
|        |                  | 況や条件によって |                  |
|        |                  | 限定的に実施でき | 「               |
|        |                  | る技術等の例示。 | ･･･の場合には･･･ |
|        |                  |                  | ことができる。」 |
|        |                  | ●具体的          |                  |
|        |                  | に例示することに | 「               |
|        |                  | より、技術的な理 | ･･･例示する。」  |
|        |                  | 解を助ける事項。 |                  |
|        |                  |                  | 「例えば･･･。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･事例もある  |
|        |                  |                  | 。･･･もよい。」  |
+--------+------------------+------------------+------------------+

+------------------+--------------------------------------------------------+
| > 関連通知等     | > 関連する通知やそれを理解する上で参考となる資料       |
+==================+========================================================+
| > 参考となる資料 | > 例示等に示した手法・内容を理解する上で参考となる資料 |
+------------------+--------------------------------------------------------+

1.  []{#_Toc103088638 .anchor}土砂災害のソフト対策に関する基本的事項

    1.  []{#_Toc103088639 .anchor}総説

＜標　準＞

+----------------------------------------------------------------------+
| > 土砂災害のソフ                                                     |
| ト対策は、土砂災害による人的被害を軽減するため、土砂災害が発生するお |
| それのある区域を明らかにするとともに、当該区域における警戒避難体制の |
| 整備を図るほか、被害対象の減少を図るため、特定開発行為の制限や建築物 |
| の構造規制や移転の勧告を行う。これらの対策を効果的に組み合わせるとと |
| もに、ハード対策と一体となった総合的な土砂災害対策となるよう計画する |
| 。土砂災害のソフト対策に係る計画については、法令等で定められる対策の |
| 実施主体が本節の内容を適用し、必要に応じて計画を策定するものとする。 |
| >                                                                    |
| > 土砂災害が発生するおそ                                             |
| れのある区域のうち、土砂災害警戒区域等は、基礎調査の結果を踏まえ、法 |
| 令で定める基準に基づき指定し、また緊急調査の結果に基づき重大な土砂災 |
| 害の急迫した危険があると認められる区域等は、想定される土砂災害に応じ |
| て、数値計算や地すべりの移動等に基づき明らかにすることを基本とする。 |
| >                                                                    |
| > 警戒避難体制の整備は、土砂災害の危険度が高ま                       |
| った時に、市町村長の避難指示発令や住民の自主避難の判断に資する情報の |
| 発表を行うため、土砂災害警戒情報等の発表基準の設定、土砂災害に関する |
| 情報や予警報の伝達と周知体制の整備、土砂の移動等に対する監視・観測体 |
| 制の整備を図るほか、避難経路や避難場所の設定や周知を図るものとする。 |
| >                                                                    |
| > 特定開                                                             |
| 発行為の制限や建築物の構造規制等については、急傾斜地の崩壊等が発生し |
| た場合に建築物に損壊が生じ、住民等の生命・身体に著しい危害が生ずるお |
| それがあると認められる土砂災害特別警戒区域において、想定される土砂災 |
| 害の発生原因となる自然現象と開発行為の内容や建築物に作用すると想定さ |
| れる衝撃力を考慮し、関連する法令や制度と連携し適切に行う必要がある。 |
| >                                                                    |
| > なお、土砂災害のソフト対策は                                       |
| 、土砂災害が発生するおそれのある区域の周知や土砂災害の危険度が高まっ |
| た時に避難に資する情報を発信するなど行政による「知らせる努力」と、住 |
| 民がこれらの情報の内容や意味を避難訓練・防災教育の実施を通して理解す |
| るなど「知る努力」が相乗的に機能するように取り組むことを基本とする。 |
+----------------------------------------------------------------------+

＜関連通知等＞

> 1）土砂災害警戒区域等における土砂災害防止対策の推進に関する法律，平成12年5月8日，法律第57号，最終改正：令和4年6月17日，法律第68号.
>
> 　（本文中では以降、土砂災害防止法と記載）
>
> 2）土砂災害防止対策基本指針，令和3年8月31日，国土交通省告示第1194号，国土交通省.
>
> 土砂災害のソフト対策に関する具体的な調査手法・調査項目については、河川砂防技術基準調査編　第17章　砂防調査、および　第18章　地すべり調査　によるものとする。

3\) 河川砂防技術基準調査編，平成26年4月，国土交通省水管理国土保全局

（最新版）河川砂防技術基準調査編, 令和7年6月,
国土交通省水管理・国土保全局.

2.  []{#_Toc103088640 .anchor}土砂災害のソフト対策

    1.  []{#_Toc103088641 .anchor}総説

＜考え方＞

土砂災害のソフト対策は、土砂災害が発生するおそれのある区域を都道府県等が把握し、土地のリスク情報をハザードマップ等により市町村が住民に周知するほか、都道府県と気象庁が共同で発表する土砂災害警戒情報等、市町村長の避難指示発令や住民の自主避難の判断に資する情報の提供およびこれらの情報提供を行うために必要な警戒避難体制の整備を行う。また住民がこれらの情報の内容や意味などを理解し、土砂災害の危険が迫ったときに適切な避難行動を取ることが可能となるよう、市町村等が避難訓練等の実施に努めることが重要である。さらに、都道府県は特定開発行為の制限や建築物の構造規制や移転の促進を行うなど被害対象の減少を図る。これらの対策を効果的に組み合わせるとともに、ハード対策と一体となった総合的な土砂災害対策となるよう計画する。

＜必　須＞

+----------------------------------------------------------------------+
| >                                                                    |
| 土砂災害のソフト対策は、都道府県等により、土砂災害防止法に基づき土砂 |
| 災害警戒区域等の指定と警戒避難体制の整備や一定の開発行為の規制を図っ |
| ていくものとする。また、砂防施設の整備等、ハード対策と相まって災害の |
| 防止、被害の軽減が図られるよう総合的な対策を展開していくものとする。 |
+----------------------------------------------------------------------+

＜関連通知等＞

> 1）土砂災害警戒区域等における土砂災害防止対策の推進に関する法律，平成12年5月8日，法律第57号，最終改正：令和4年6月17日，法律第68号.
>
> 2）土砂災害防止対策基本指針，令和3年8月31日，国土交通省告示第1194号，国土交通省．

2.  []{#_Toc103088642 .anchor}土砂災害が発生するおそれのある区域の把握

    1.  総説

＜考え方＞

土砂災害が発生するおそれのある区域は、土砂災害防止法に基づき、都道府県が基礎調査により把握し、土砂災害警戒区域、土砂災害特別警戒区域として指定し周知する。また、河道閉塞・火山噴火に起因する土石流や地すべり、河道閉塞による湛水等、重大な土砂災害が急迫した場合、国等が土砂災害防止法に基づき緊急調査を実施し、土砂災害が想定される区域を明らかにする。

土砂災害が発生するおそれのある区域は、基礎調査が完了した後においても数値標高モデル等の高精度な地形情報等を用いて新規箇所の抽出に努めるとともに、開発に伴う土地改変や土地利用の変化、砂防施設整備の進捗、豪雨や地震、火山噴火等による流域内の荒廃状況を踏まえ、適宜見直す必要がある。

＜必　須＞

+----------------------------------------------------------------------+
| > 都道府県は土砂災害防止法                                           |
| に基づく基礎調査を実施し、地形や土地利用状況等の調査を行い、土砂災害 |
| が発生するおそれのある区域を明らかにし、土砂災害警戒区域、土砂災害特 |
| 別警戒区域として指定し周知を図るものとする。都道府県等は土砂災害警戒 |
| 区域内では警戒避難体制の整備を行うとともに、土砂災害特別警戒区域内で |
| は一定の開発行為の制限を行うなど、ソフト対策の推進を図るものとする。 |
+----------------------------------------------------------------------+

＜関連通知等＞

> 1）土砂災害警戒区域等における土砂災害防止対策の推進に関する法律，平成12年5月8日，法律第57号，最終改正：令和4年6月17日，法律第68号.
>
> 2）土砂災害防止対策基本指針，令和3年8月31日，国土交通省告示第1194号，国土交通省．

2.  土砂災害警戒区域・土砂災害特別警戒区域

＜考え方＞

土砂災害警戒区域、土砂災害特別警戒区域は、都道府県が土砂災害防止法に基づき、基礎調査を実施し指定する。基礎調査は、急傾斜地の崩壊等のおそれがある土地に関する地形、地質、降水等の状況及び土砂災害の発生のおそれがある土地の利用状況その他の事項に関する調査を行う。基礎調査の結果により、急傾斜地の崩壊では斜面の傾斜度・高さ及び急傾斜地の上端・下端からの距離、土石流では基準地点（扇頂部）から下流の地盤勾配、地すべりでは地すべりの範囲や方向及び地すべりの範囲の下端からの距離を踏まえ、土砂災害警戒区域を指定し、危険の周知、警戒避難体制の整備を行う。

土砂災害特別警戒区域は、急傾斜地の崩壊では崩土の移動高や土質定数、崩壊土量、堆積高を踏まえ崩土の移動や堆積による外力を求め、土石流では土質定数や一波の土石流により流出する最大の土砂量、地盤勾配と土石流の高さを踏まえ流体力を求め、地すべりでは土質定数、地すべりの長さや保全対象までの距離を踏まえ地すべり土塊の移動による外力を求め、これらの外力が家屋等の耐力を上回る区域を指定する。また、特定の開発行為を許可制とするなどの制限や建築物の構造規制等を行う区域として定める。

＜必　須＞

+----------------------------------------------------------------------+
| > 都道府県は、基本指針に基づ                                         |
| き、おおむね５年ごとに、土砂災害警戒区域・土砂災害特別警戒区域の指定 |
| 等、土砂災害防止のための対策に必要な基礎調査として、急傾斜地の崩壊等 |
| のおそれがある土地に関する地形、地質、降水等の状況及び土砂災害のおそ |
| れがある土地の利用の状況その他事項に関する基礎調査を行うものとする。 |
| >                                                                    |
| > 都道府県は、基礎調査の結果を、国土交通省令で定めるところによ       |
| り、関係のある市町村の長に通知するとともに、公表しなければならない。 |
| >                                                                    |
| > 基礎調査の結果の公                                                 |
| 表は、急傾斜地の崩壊等が発生した場合には住民等の生命又は身体に危害が |
| 生ずるおそれがあると認められる土地の区域及び急傾斜地の崩壊等が発生し |
| た場合には建築物に損壊が生じ住民等の生命又は身体に著しい危害が生ずる |
| おそれがあると認められる土地の区域を平面図に明示して、都道府県の公報 |
| への掲載、インターネットの利用その他適切な方法により行うものとする。 |
| >                                                                    |
| > 土砂災害警戒区域は、土砂災害防                                     |
| 止法に基づき、急傾斜地の崩壊等が発生した場合に住民等の生命又は身体に |
| 危害が生ずるおそれがあると認められる土地の区域を指定するものとする。 |
| >                                                                    |
| > 土砂災害特別警戒区域は、土砂災害警戒区域のうち、急傾斜地の         |
| 崩壊等が発生した場合に建築物に損壊が生じ住民等の生命又は身体に著しい |
| 危害が生ずるおそれがあると認められる土地の区域を指定するものとする。 |
| >                                                                    |
| > 土砂災害警戒区域・土                                               |
| 砂災害特別警戒区域の指定の基準は、土砂災害の発生原因となる急傾斜地、 |
| 土石流、地すべりの自然現象の区分に応じた土地の区域であることとする。 |
| >                                                                    |
| > 土砂災害警戒区域・土砂災害特別警戒区                               |
| 域の指定は、土砂災害の発生原因ごとに、以下について定めるものとする。 |
| >                                                                    |
| > ・指定の区域                                                       |
| >                                                                    |
| > ・土砂災害の発生原因となる自然現象の種類                           |
| >                                                                    |
| > ・建                                                               |
| 築物の構造の規制に必要な衝撃に関する事項（土砂災害特別警戒区域のみ） |
+----------------------------------------------------------------------+

＜推　奨＞

土砂災害警戒区域、土砂災害特別警戒区域は、基礎調査が完了した後においても数値標高モデル等の高精度な地形情報等を用いて新規箇所の抽出に努めるとともに、地形や土地利用状況、土砂災害防止施設の整備等の変化を踏まえ、区域の見直しが必要になった場合は、柔軟かつ迅速に対応することが望ましい。

＜関連通知等＞

> 1）土砂災害警戒区域等における土砂災害防止対策の推進に関する法律，平成12年5月8日，法律第57号，最終改正：令和4年6月17日，法律第68号.
>
> 2）土砂災害防止対策基本指針，令和3年8月31日，国土交通省告示第1194号，国土交通省．
>
> 3\)
> 土砂災害防止法に基づく基礎調査実施要領（案），令和3年1月，国土交通省砂防部砂防計画課．

3.  土砂災害防止法に基づく緊急調査

＜考え方＞

河道閉塞・火山噴火に起因する土石流や地すべり、河道閉塞による湛水等、重大な土砂災害が急迫した場合、国等は土砂災害防止法に基づき緊急調査を実施し、土砂災害が想定される区域および時期を明らかにする。緊急調査では対象箇所周辺の地形や住宅等の立地等に関する調査の他、河道閉塞に起因する土石流及び河道閉塞による湛水では河道閉塞の位置及び形状、湛水等に関する調査、火山噴火に起因する土石流では降灰等の堆積や地形変化等に関する調査、地すべりでは地表の変状及び構造物の変状に関する調査を行うとともに、現地状況の変化等の監視を継続的に行う。

重大な土砂災害の急迫した危険があると認められる区域の想定は、河道閉塞による土石流は、天然ダム下流末端より上流域の1次元河床変動計算及び天然ダム下流末端より下流域の2次元氾濫計算を組み合わせた手法に基づき設定する。火山噴火に起因する土石流は、上流域の分布型流出計算及び下流の2次元氾濫計算を組み合わせた手法に基づき設定する。河道閉塞による湛水は、地形図上で河道閉塞による湛水が発生した河川の越流開始地点の標高と同じ標高となる線を結ぶことで設定する。地すべりは、地すべりとして変動している範囲及び拡大する可能性のある範囲、地すべりの移動方向に基づき明らかにする。

重大な土砂災害の急迫した危険があると認められる時期の想定は、河道閉塞による土石流は、雨量と流入流量（直接観測ができない場合、湛水量の変化から推定する）の関係を把握し、降雨予測から推定される流入流量を算出し、天然ダムの満水時期を予測する。火山噴火に起因する土石流は、当該火山において過去の噴火後に降雨によって土石流が発生した事例がある場合は、その時の土石流発生基準雨量を参考として基準雨量を設定し、参考となる事例が無い場合には、他の火山における事例に基づいて基準雨量を設定する。河道閉塞による湛水は、河道閉塞が発生した河川の越流開始地点より上流の部分の流域のうち、越流開始地点の標高以下の標高の土地の区域に存する居室を有する建築物の標高に到達する湛水量と現況の湛水量の差を流入流量で除して予測する。地すべりは、地すべりの管理基準のうち「避難基準」の地滑り土塊の変位速度を適用する。

＜必　須＞

+----------------------------------------------------------------------+
| > 国土交通省および都道府県は、重大な土砂災害の急迫し                 |
| ている状況において、土砂災害防止法に基づく緊急調査を実施し、市町村が |
| 適切に避難指示の判断等を行えるよう、緊急調査によって得られた土砂災害 |
| が発生するおそれのある区域および時期を土砂災害緊急情報として通知・周 |
| 知するとともに、緊急調査により得られた情報を随時提供するものとする。 |
| >                                                                    |
| > 河道閉塞・火山噴火に起因する土石流、                               |
| 河道閉塞による湛水といった特に高度な技術を要する土砂災害については国 |
| 土交通省、地すべりについては都道府県が緊急調査を実施するものとする。 |
+----------------------------------------------------------------------+

＜例　示＞

> これまでに実施された土砂災害防止法に基づく緊急調査の事例を以下に例示する。

表7-1　土砂災害防止法に基づく緊急調査の実施事例

+----------------------+----------------------+----------------------+
| > 緊急調査着手年月日 | > 対象地域           | > 対象現象           |
+======================+======================+======================+
| > 平成23年5月1日     | > 霧島山（           | > 火山               |
|                      | 新燃岳）及び周辺地域 | 噴火に起因する土石流 |
+----------------------+----------------------+----------------------+
|                      | > 桜島及び           | > 火山               |
|                      | 周辺地域（鹿児島県） | 噴火に起因する土石流 |
+----------------------+----------------------+----------------------+
| > 平成23年9月6日     | > 奈良県             | > 河道閉塞による湛水 |
|                      | 熊野川（十津川）流域 |                      |
|                      | >                    |                      |
|                      | > ・五條市大塔町赤谷 |                      |
|                      | >                    |                      |
|                      | > ・十津川村長殿     |                      |
|                      | >                    |                      |
|                      | > ・十津川村栗平     |                      |
|                      | >                    |                      |
|                      | > 和歌山県日置川流域 |                      |
|                      | >                    |                      |
|                      | > ・田辺市熊野       |                      |
+----------------------+----------------------+----------------------+
| > 平成23年9月13日    | > 奈良県             | > 河道閉塞による湛水 |
|                      | 熊野川（十津川）流域 |                      |
|                      | >                    |                      |
|                      | > ・野迫川村北股     |                      |
+----------------------+----------------------+----------------------+
| > 平成24年3月8日     | > 新潟県             | > 地すべり           |
|                      | 上越市板倉区国川地区 |                      |
+----------------------+----------------------+----------------------+
| > 平成26年9月27日    | > 御嶽山及び周辺地域 | > 火山               |
|                      |                      | 噴火に起因する土石流 |
+----------------------+----------------------+----------------------+
| > 令和2年7月13日     | > 長崎県佐世保       | > 地すべり           |
|                      | 市小川内町牧の地地区 |                      |
+----------------------+----------------------+----------------------+

＜関連通知等＞

> 1）土砂災害警戒区域等における土砂災害防止対策の推進に関する法律，平成12年5月8日，法律第57号，最終改正：令和4年6月17日，法律第68号.
>
> 2）土砂災害防止対策基本指針，令和3年8月31日，国土交通省告示第1194号，国土交通省．

＜参考となる資料＞

> 1\)
> 土砂災害防止法に基づく緊急調査実施の手引き（河道閉塞による土砂災害対策編），平成23年（平成28年3月一部改訂），国土交通省砂防部砂防計画課，国土技術政策総合研究所土砂災害研究部，（国研）土木研究所土砂管理研究グループ.
>
> 2）土砂災害防止法に基づく緊急調査実施の手引き（噴火による降灰等の堆積後の降水を発生原因とする土石流対策編），平成23年（平成28年3月一部改訂），国土交通省砂防部砂防計画課，国土技術政策総合研究所土砂災害研究部，(国研)土木研究所土砂管理研究グループ.
>
> 3）土砂災害防止法に基づく緊急調査実施の考え方（地滑り対策編），平成23年4月，国土交通省砂防部砂防計画課，独立行政法人土木研究所土砂管理研究グループ．

4.  火山の噴火による土砂災害が発生するおそれのある区域の把握

＜考え方＞

火山の噴火により土砂災害が発生するおそれのある区域は、ソフト対策で対象とする降灰による土石流及び火山泥流、溶岩流、火砕流等の土砂移動現象毎に、計画規模の噴火時に想定される土砂移動現象の到達範囲を過去の実績や数値計算により把握する。また当初想定していなかった火口での噴火や噴火の継続に伴う降灰範囲の変化、地形変化など、噴火状況の変化に応じて、迅速に数値計算により影響範囲の想定を見直す必要がある。さらに、噴火時の土砂移動現象を監視し、危険な区域の把握や避難の判断に資するため、監視・観測体制を整備しておく必要がある。

＜標　準＞

+----------------------------------------------------------------------+
| > 火山の噴火に                                                       |
| よる土砂災害が発生するおそれのある区域は、ソフト対策で対象とする火山 |
| の噴火に起因する土砂移動現象と規模及びそれらの推移を時系列的にまとめ |
| た土砂移動シナリオに基づき、数値計算により把握することを基本とする。 |
+----------------------------------------------------------------------+

＜関連通知等＞

> 1）活動火山対策特別措置法，昭和48年7月24日，法律第61号，最終改正：平成27年7月8日，法律第52号．
>
> 2）活動火山対策の総合的な推進に関する基本的な指針，平成28年2月22日，内閣府告示第13号，内閣府．

＜参考となる資料＞

> 1）火山噴火緊急減災対策砂防計画策定ガイドライン，平成19年4月，国土交通省砂防部．（最新版）火山噴火緊急減災対策砂防計画策定ガイドライン，令和5年3月，国土交通省水管理・国土保全局砂防部.

3.  []{#_Toc103088643 .anchor}土砂災害に関する警戒避難体制の整備

    1.  総説

＜考え方＞

警戒避難体制の整備は、都道府県等により、土砂災害の危険度が高まった時に、市町村長の避難指示発令や住民の自主避難の判断に資する情報の発表を行うため、土砂災害警戒情報等の発表基準の設定、土砂災害に関する情報や予警報の伝達と周知体制の整備、土砂の移動等に対する監視・観測体制の整備等を図るほか、避難経路や避難場所の設定や周知を図る。

＜必　須＞

+----------------------------------------------------------------------+
| > 警戒避                                                             |
| 難体制の整備は、都道府県等により土砂災害に関する情報の収集・伝達、予 |
| 警報の発令及び伝達、要配慮者等の避難、救助等の整備を図るものとする。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| > 火山噴火対策における警戒避                                         |
| 難体制の整備は、噴火時に想定される土砂移動現象に対して、当該火山で発 |
| 生する可能性の高い規模の噴火を考慮して、計画的に整備を行う基本対策計 |
| 画と、突発的で規模の大きい火山噴火の場合でも迅速かつ効果的に警戒監視 |
| 等を行う火山噴火緊急減災対策砂防計画に基づき、火山毎に関係機関で構成 |
| される火山防災協議会に参画し整備を進めることを基本とするものとする。 |
+----------------------------------------------------------------------+

＜関連通知等＞

> 1）土砂災害警戒区域等における土砂災害防止対策の推進に関する法律，平成12年5月8日，法律第57号，最終改正：令和4年6月17日，法律第68号.
>
> 2）土砂災害防止対策基本指針，令和3年8月31日，国土交通省告示第1194号，国土交通省．
>
> 3）活動火山対策特別措置法，昭和48年7月24日，法律第61号，最終改正：平成27年7月8日，法律第52号．
>
> 4\)
> 活動火山対策の総合的な推進に関する基本的な指針,平成28年2月22日，内閣府告示第13号，内閣府.

2.  警戒避難体制の市町村地域防災計画等の各種計画への位置づけ

＜考え方＞

市町村は、警戒避難体制の整備にあたり、土砂災害防止法に基づき、その中心的役割を担うことが期待される市町村防災会議が策定する市町村地域防災計画において、土砂災害警戒区域ごとに警戒避難体制に関する事項として、土砂災害に関する情報の収集・伝達等や避難場所・避難経路、土砂災害に係る避難訓練の実施、要配慮者利用施設を定める。

市町村地域防災計画に定められた要配慮者利用施設の所有者又は管理者は、利用者の円滑かつ迅速な避難の確保に関する事項として、防災体制や避難誘導、避難の確保を図るための施設の整備、防災教育及び訓練の実施を定めた避難確保計画を作成し、避難確保計画に基づく避難訓練を実施する必要がある。

＜必　須＞

+----------------------------------------------------------------------+
| > 市町村は、市町村地域防災計画において、土砂災害防                   |
| 止法に基づき、土砂災害警戒区域ごとに警戒避難体制に関する事項を定める |
| 。また、要配慮者利用施設が警戒区域内にあり、当該施設の利用者が円滑か |
| つ迅速な避難を確保する必要がある場合は、施設の名称及び所在地を市町村 |
| 地域防災計画に定めるものとする。市町村地域防災計画に定められた要配慮 |
| 者利用施設の管理者等は土砂災害防止法に基づき避難確保計画を作成する。 |
+----------------------------------------------------------------------+

＜例　示＞

要配慮者は、一般の住民より避難に多くの時間を要するため、災害が発生した場合に深刻な被害を受けるおそれがある。そのため、土砂災害防止法では、市町村地域防災計画にその名称及び所在地を定められた要配慮者利用施設（社会福祉施設、学校、医療施設その他の主として防災上の配慮を要する者が利用する施設）の所有者又は管理者に対して、避難確保計画の作成を義務づけている。作成した避難確保計画は、安全な避難行動が確実に行われるよう、訓練等を通して課題等を抽出し、必要に応じて計画を見直ししていく必要があり、国土交通省では、避難確保計画の作成の一助として、「避難確保計画作成の手引き」を公表している。

＜関連通知等＞

> 1）土砂災害警戒区域等における土砂災害防止対策の推進に関する法律，平成12年5月8日，法律第57号，最終改正：令和4年6月17日，法律第68号.
>
> 2）土砂災害防止対策基本指針，令和3年8月31日，国土交通省告示第1194号，国土交通省．

＜参考となる資料＞

> 1）避難確保計画作成の手引き，令和2年6月，水管理・国土保全局
> 河川環境課水防企画室，水管理・国土保全局
> 砂防部砂防計画課地震・火山砂防室．
>
> （最新版）要配慮者利用施設における避難確保計画の作成・活用の手引き（洪水、雨水出水、高潮、土砂災害、津波），令和4年3月，水管理・国土保全局.

3.  土砂災害警戒情報、土砂災害警戒情報を補足する情報

＜考え方＞

土砂災害警戒情報は、土砂災害発生危険基準線（Critical
Line：以下「CL」という。）をスネークライン（一定時間毎に60分間積算雨量と土壌雨量指数をプロットした点を結んだ線）がおおむね２時間先に超過すると予想された場合に、都道府県と気象庁が共同で発表を行うものである。CLの適用地域は、CLの設定の際に用いる降雨メッシュ単位とし、自然的、社会的条件等の観点から勘案して、土砂災害の危険性が認められない降雨メッシュについては、CLの適用地域から除外する。CLの設定は、非線形判別に優れCL
設定の客観性向上が図られるRBFネットワーク（以下「RBFN」という。）により非発生降雨の発現確率を求め、その確率分布を元に等RBFN
出力値線データ（RBFN 出力値0.05 から0.95 の範囲で0.05
単位を目安）を抽出し、①地質特性等の素因条件が同等とみなせる対象災害発生地域の選定結果を参考に、降雨の発生頻度や発生確率、履歴順位等を用いて選定する方法、②当該地域の大規模降雨を参考に選定する方法等により、最も妥当と判断されるCLを選定する。CLは、蓄積された新たな降雨データや土砂災害データ及び災害捕捉率や空振り率、発表頻度等に基づき適宜見直す必要がある。また、地震の影響を受けた地域は、発生前より少ない降雨で土砂災害が発生する危険があることを鑑み、震度に応じて、暫定的にCLの引き下げを行う必要がある。

土砂災害警戒情報を補足する情報は、市町村長の避難指示等の発令に際して、対象地域や発令するタイミングを的確に判断できるよう、時系列でのメッシュ毎の土壌雨量指数や降雨情報及び危険度の高まり等の情報を都道府県が提供する。

＜必　須＞

+----------------------------------------------------------------------+
| > 土砂災害警戒情報は、市町村や                                       |
| 住民等に必要な防災情報を提供し、迅速かつ適切な防災対応を効果的に支援 |
| していくために、気象業務法および土砂災害防止法に基づき、都道府県と気 |
| 象庁が共同して作成・発表するものとする。地震等で現状の基準を見直す必 |
| 要があると考えられる場合においても的確な運用を行うため、暫定基準の取 |
| り扱いについて都道府県と気象庁で事前に協議して定めておくものとする。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| > 土砂災害警戒情報は、降雨による土砂災害                             |
| の危険が高まったときに、土石流及び集中的に発生するがけ崩れを対象に、 |
| 都道府県砂防部局と地方気象台が連携して策定したCLをスネークラインがお |
| おむね２時間先に超過すると予想される場合に発表することを基本とする。 |
| >                                                                    |
| > 土砂災害警戒情報を                                                 |
| 補足する情報は、土砂災害警戒情報と併せて市町村が避難対象地域等の特定 |
| することに資するものであり、市町村における適切な避難情報の発令等を効 |
| 果的に支援するため、都道府県が詳細な情報を提供することを基本とする。 |
+----------------------------------------------------------------------+

＜例　示＞

「避難情報に関するガイドライン」では、自治体や気象庁等から発表される防災情報を用いて住民がとるべき行動を直感的に理解しやすくなるよう、土砂災害の危険度の高まりに応じて警戒レベルを5段階に分類して、「居住者等がとるべき行動」と、その「行動を促す情報」（避難情報等：市町村が発令する避難情報と気象庁が発表する注意報等）とを関連付けた。

例えば、「大雨警報（土砂災害）の危険度分布」の「非常に危険」（警戒レベル4相当）や「警戒」（警戒レベル3相当）が表示されているメッシュと、土砂災害警戒区域等とが重なった地域に、警戒レベル4「避難指示」や警戒レベル3「高齢者等避難」を発令するなどの事例がある。

＜関連通知等＞

> 1）気象業務法，昭和27年6月2日，法律第165号，最終改正：令和5年5月31日，法律第37号.
>
> 2）気象業務法施行令，昭和27年11月29日，政令第471号，最終改正：平成25年8月26，政令第241号．
>
> 3）土砂災害警戒区域等における土砂災害防止対策の推進に関する法律，平成12年5月8日，法律第57号，最終改正：令和4年6月17日，法律第68号.
>
> 4）土砂災害防止対策基本指針，令和3年8月31日，国土交通省告示第1194号，国土交通省．
>
> 5）土砂災害警戒情報の発表の判断に用いる基準の見直しについて，平成29年11月6日，
> 国土交通省水管理・国土保全局砂防部
> 砂防計画課地震・火山砂防室長，国土交通省国土技術政策総合研究所
> 土砂災害研究室長，気象庁予報部 業務課気象防災情報調整室長 事務連絡．
>
> （最新版）現在は廃止。以下の手引きに統合。
>
> 都道府県と気象庁が共同して土砂災害警戒情報を作成・発表するための手引き，平成17年6月（令和3年6月改訂），国土交通省水管理・国土保全局砂防部，気象庁大気海洋部.

＜参考となる資料＞

> 1）平成14年度土砂災害警戒情報のあり方と今後の施策に関する報告書，平成14年，土砂災害警戒情報に関する検討委員会.
>
> 2）国土交通省河川局砂防部と気象庁予報部の連携による土砂災害警戒避難基準雨量の設定手法（案），平成17年6月，国土交通省河川局砂防部，気象庁予報部，国土交通省国土技術政策総合研究所．
>
> （最新版）土砂災害警戒情報の基準設定及び検証の考え方，令和5年3月，国土交通省水管理・国土保全局砂防部，気象庁大気海洋部
> ，国土交通省国土技術政策総合研究所.
>
> 3）土砂災害警戒避難ガイドライン，平成19年4月，平成27年4月改訂，国土交通省砂防部．
>
> 4）都道府県と気象庁が共同して土砂災害警戒情報を作成・発表するための手引き，平成17年6月，令和3年6月改訂，国土交通省水管理・国土保全局砂防部，気象庁大気海洋部．
>
> 5）避難情報に関するガイドライン，令和3年5月，内閣府（防災担当）．

4.  土砂災害ハザードマップ

＜考え方＞

市町村は、土砂災害による人的被害を防止するため、土砂災害ハザードマップを作成し、住民等に対して平時から住居や利用する施設に存する土地が土砂災害の危険性がある地域かどうか等のリスク情報を提供するとともに、緊急時に取るべき避難行動に関する情報を住民等に正しく伝達する。土砂災害ハザードマップの作成にあたっては、避難に関する情報をわかりやすく提供することを念頭におく必要がある。

火山噴火時の土砂災害に対するハザードマップは、7.2.2(4)で把握した土砂災害のおそれのある区域について、火山砂防ハザードマップとして火山防災協議会に必要に応じて提供する。また、噴火状況の変化に応じて、迅速に数値計算により影響範囲を想定するため、リアルタイム型リアルタイムハザードマップの対応が可能となる体制を整備しておくことが望ましい。

＜必　須＞

+----------------------------------------------------------------------+
| > 市町村は、土砂災害防止法に基づき、土砂災害ハザード                 |
| マップを作成し、土砂災害警戒区域等及びこれらの区域における土砂災害の |
| 発生原因となる自然現象の種類、市町村地域防災計画に基づく区域ごとの特 |
| 色を踏まえた土砂災害に関する情報伝達、土砂災害の危険性がある場合の警 |
| 戒避難に必要な避難場所・避難経路等の情報を住民に周知するものとする。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| > 土砂災害と同時に発生しうる災害である洪水、内水、津波               |
| 、高潮のリスクも確認された場合には、土砂災害とその他リスクを合わせた |
| 総合的なハザードマップを作成し、円滑な警戒避難を確保するものとする。 |
| >                                                                    |
| > 火山噴火時の土砂災害に対するハザードマップは、土砂移動             |
| 現象毎の土砂移動シナリオに基づき、影響の範囲と程度を示す火山砂防ハザ |
| ードマップを作成し、保全対象に対する概略被害を示すことを基本とする。 |
+----------------------------------------------------------------------+

＜関連通知等＞

> 1）土砂災害警戒区域等における土砂災害防止対策の推進に関する法律，平成12年5月8日，法律第57号，最終改正：令和4年6月17日，法律第68号.
>
> 2）土砂災害防止対策基本指針，令和3年8月31日，国土交通省告示第1194号，国土交通省．
>
> 3）火山防災協議会に対するリアルタイムハザードマップの提供について，平成30年6月18日，水管理・国土保全局砂防部
> 砂防計画課長 国水地第6号．

＜参考となる資料＞

> 1）土砂災害ハザードマップ作成ガイドライン，令和2年10月，国土交通省水管理・国土保全局砂防部砂防計画課．
>
> 2）火山噴火に起因した土砂災害予想区域図作成の手引き（案），平成25年3月，国土交通省河川局砂防部.
>
> 3）城ヶ﨑正人：火山噴火リアルタイムハザードマップシステムについて，砂防学会誌，Vol.71，No.6，2019.

5.  土砂災害に係る避難訓練

＜考え方＞

避難訓練は、危険箇所の周知やハザードマップの作成・周知、防災情報の種類・伝達方法の周知等といった警戒避難に関する様々な取組を実際の避難行動に結びつける重要な機会である。そのため、市町村等は、出水期前等の適切な時期に毎年実施するとともに、地域住民等が一人でも多く参加できるよう努めることが必要である。また、要配慮者利用施設の所有者等は、利用者の円滑かつ迅速な避難の確保を図るために必要な避難確保計画の作成と避難訓練の実施及び市町村への結果の報告が必要である。

＜必　須＞

+----------------------------------------------------------------------+
| > 土砂災害に関する避難訓練は                                         |
| 、災害対策基本法、土砂災害防止法に基づき、毎年一回以上実施することを |
| 基本とする。市町村は、都道府県、国その他防災関係機関と連携し、情報伝 |
| 達や住民の避難誘導、避難所の開設等土砂災害の発生を想定した実践的な避 |
| 難訓練を実施することにより、土砂災害に対する警戒避難体制の充実・強化 |
| を図るものとする。また、市町村地域防災計画にその名称及び所在地を定め |
| られた要配慮者利用施設の所有者等は、土砂災害防止法に基づき、避難確保 |
| 計画に基づく避難訓練を実施し、その結果を市町村に報告するものとする。 |
+----------------------------------------------------------------------+

＜関連通知等＞

> 1）災害対策基本法，昭和36年11月15日，法律第223号，最終改正：令和5年6月16日，法律第58号.
>
> 2）災害対策基本法施行令，昭和37年7月9日，政令第288号，最終改正：令和5年5月17日，政令第180号.
>
> 3）土砂災害警戒区域等における土砂災害防止対策の推進に関する法律，平成12年5月8日，法律第57号，最終改正：令和4年6月17日，法律第68号.
>
> 4）土砂災害防止対策基本指針，令和3年8月31日，国土交通省告示第1194号，国土交通省．

6.  火山噴火緊急減災対策砂防計画（緊急ソフト対策）

＜考え方＞

火山噴火緊急減災対策砂防計画で検討する緊急ソフト対策実行計画は、火山噴火時に際して緊急ハード対策の設置位置や規模などを検討・決定するための情報収集、工事現場の安全確保のための情報収集、火山噴火に伴う土砂災害に対する避難支援のための情報提供などを目的として、土砂移動シナリオに対応した時系列的に実施する各種の対策（土石流検知センサー等の火山地域の土砂移動現象を監視する機器の設置、リアルタイムハザードマップ作成、土砂災害に関する情報提供と情報配信システムの整備など）を整理する。

なお、緊急ソフト対策では、実施項目とその目的、対応できる現象・規模についての考え方を明確にしておく必要がある。

＜標　準＞

+----------------------------------------------------------------------+
| > 火山噴火緊                                                         |
| 急減災対策砂防計画は、緊急ハード対策実行計画と緊急ソフト対策実行計画 |
| 及びこれに関連する平常時からの準備事項からなる。緊急ソフト対策実行計 |
| 画は、緊急時に実施する調査、火山監視機器の緊急的な整備、リアルタイム |
| ハザードマップ作成など、火山噴火に伴う土砂災害に対する避難対策を支援 |
| するために必要な情報提供に関する事項をとりまとめることを基本とする。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

> 1）火山噴火緊急減災対策砂防計画策定ガイドライン，平成19年4月，国土交通省砂防部．（最新版）火山噴火緊急減災対策砂防計画策定ガイドライン，令和5年3月，国土交通省水管理・国土保全局砂防部.

7.  市町村長への助言

＜考え方＞

避難指示解除等の際の助言を円滑かつ迅速に実行できるように、国および都道府県等の関係機関と市町村の間で連絡体制を構築しておく必要がある。また、これらの関係機関からは、市町村長からの要請の有無にかかわらず、必要に応じてその専門的知見から能動的な情報提供を行うことが望ましい。

＜必　須＞

+----------------------------------------------------------------------+
| > 国および都道府県は、土砂災害防止法等に基づき、市町村長             |
| から避難指示の解除等に際して助言を求められた場合は、保有するリアルタ |
| イムの情報の提供や災害に関する専門的知見等から助言を行うものとする。 |
+----------------------------------------------------------------------+

＜推　奨＞

地震・水害・土砂災害等の大規模自然災害に対応するためには、TEC‐FORCE（緊急災害対策派遣隊）や国土技術政策総合研究所等の専門家を派遣し、被災地方公共団体（自治体）等が行う被災地の早期復旧等に対する技術的な支援を円滑かつ迅速に実施することが望ましい。

＜例　示＞

事例として、広島県土砂災害（平成26年8月）において、TEC‐FORCEにより土砂災害危険箇所の緊急点検や緊急的な対応が必要な渓流点検を実施し、砂防堰堤等の緊急的な整備を実施した。渓流点検結果については広島県、広島市への報告を実施している。

＜関連通知等＞

> 1）土砂災害警戒区域等における土砂災害防止対策の推進に関する法律，平成12年5月8日，法律第57号，最終改正：令和4年6月17日，法律第68号.
>
> 2）土砂災害防止対策基本指針，令和3年8月31日，国土交通省告示第1194号，国土交通省．

＜参考となる資料＞

1)  国土技術政策総合研究所土砂災害研究部,（独）土木研究所土砂管理研究グループ：平成26年８月広島市における土砂災害の特徴と土砂災害専門家による関係機関への技術的支援について，砂防と治水，Vol.47，No.5，2014．

    1.  []{#_Toc103088644
        .anchor}開発行為に対する制限や建築物の構造規制や移転の促進等

        1.  総説

＜考え方＞

都道府県は、特定開発行為の制限や建築物の構造規制等について、土砂災害が発生するおそれのある区域のうち、建築物に損壊が生じ、住民等の生命・身体に著しい危害が生ずるおそれがあると認められる土砂災害特別警戒区域において、想定される土砂災害の発生原因となる自然現象と開発行為の内容や建築物に作用すると想定される衝撃力等を考慮し、関連する法令や制度と連携し適切に行う。

＜標　準＞

+----------------------------------------------------------------------+
| > 都道府県は、特定開発行為の制限や建築物の構造                       |
| 規制について、建築物に損壊が生じ、住民等の生命・身体に著しい危害が生 |
| ずるおそれがあると認められる土地において、その土地の情報を明らかにし |
| て予め安全性が確保されない限りは居住等に利用されないよう一定の開発行 |
| 為に対する制限や建築物の構造規制等を行うことを基本とする。また、すで |
| に居住等に利用されており所要の対策工事が施されていない場合には、必要 |
| に応じて居住者や施設の管理者等に早急に安全を確保するための対応として |
| 移転等の勧告を行うことにより、土砂災害の防止を図ることを基本とする。 |
+----------------------------------------------------------------------+

＜関連通知等＞

> 1）土砂災害警戒区域等における土砂災害防止対策の推進に関する法律，平成12年5月8日，法律第57号，最終改正：令和4年6月17日，法律第68号.
>
> 2）土砂災害防止対策基本指針，令和3年8月31日，国土交通省告示第1194号，国土交通省．

2.  土砂災害特別警戒区域の指定による土地利用規制等

＜考え方＞

都道府県は、都市計画法に基づき、都市計画区域全域で、土砂災害特別警戒区域における住宅（自己居住用を除く）、自己以外業務用施設（貸店舗、貸ビル、貸倉庫等）及び自己業務用施設（店舗、病院、社会福祉施設、旅館、ホテル、工場等）の開発を原則禁止とし、市街化調整区域の土砂災害警戒区域においても、住宅等の開発許可を厳格化する。

土砂災害防止法では、土砂災害特別警戒区域における住宅地分譲や社会福祉施設、学校及び医療施設の建築のための開発行為について、安全を確保するために必要な措置が政令で定める技術基準に従っているものと都道府県知事が判断した場合に限って許可を行い、居室を有する建築物については、建築物の構造が土砂の衝撃等に対して安全なものとなるよう、建築基準法に基づく建築確認制度を適用する。また、都道府県知事は、土砂災害が発生した場合に損傷が生じ、住民等の生命または身体に著しい危害が生ずるおそれの大きい土砂災害特別警戒区域内に存する建築物の所有者等に対して、移転等の勧告を行うことができる。

＜必　須＞

+----------------------------------------------------------------------+
| > 土                                                                 |
| 砂災害特別警戒区域の指定による土地利用規制等は、都市計画法、土砂災害 |
| 防止法及び建築基準法に基づき、都道府県は、土地の開発段階や建築段階に |
| おいて、新規立地の抑制や建築物の構造規制を行うこと、必要に応じて既存 |
| 住宅の移転等の勧告を行うことにより、土砂災害の防止を図るものとする。 |
+----------------------------------------------------------------------+

＜例　示＞

がけ地近接等危険住宅移転事業では、がけ地の崩壊等による自然災害のおそれの高い土砂災害特別警戒区域等の土地から居住者自身の自助努力による住宅の移転を支援し、国民の生命の安全を確保する。

＜関連通知等＞

> 1）都市計画法，昭和43年6月15日，法律第100号，最終改正：令和6年11月8日，法律第40号.
>
> 2）土砂災害警戒区域等における土砂災害防止対策の推進に関する法律，平成12年5月8日，法律第57号，最終改正：令和4年6月17日，法律第68号.
>
> 3）土砂災害防止対策基本指針，令和3年8月31日，国土交通省告示第1194号，国土交通省．
>
> 4\)
> 建築基準法，昭和25年5月24日，法律第201号，最終改正：令和7年4月1日，法律第69号.
>
> 5\)
> 建築基準法施行令，昭和25年11月16日，政令第338号，最終改正：令和7年4月1日，政令第172号.
>
> 6\)
> 「移転の勧告の基本的な考え方」について，平成27年4月16日，国水砂第13-1号，国土交通省水管理・国土保全局砂防部砂防計画課長．
>
> （最新版）「移転の勧告の基本的な考え方」の改定について，令和4年11月18日，国水砂第236号，国土交通省水管理・国土保全局砂防部砂防計画課長.

**基本計画編**

**第4章　海岸保全計画**

**目　次**

第1節 総説 1

[第2節 海岸防護に関する基本的な事項 2](\l)

> [2．1 総説 2](\l)
>
> [2．2 防護すべき地域 3](\l)
>
> [2．3 防護水準等の海岸防護の目標 3](\l)
>
> [2．3．1 総説 3](\l)
>
> [2．3．2 計画海浜形状 4](\l)
>
> [2．3．3 計画潮位 6](\l)
>
> [2．3．4 計画波浪 7](\l)
>
> [2．3．5 計画津波 7](\l)
>
> [2．4 防護目標を達成するための対策 8](\l)
>
> [2．4．1 総説 8](\l)
>
> [2．4．2 海岸侵食対策 10](\l)
>
> [2．4．3 高潮対策 13](\l)
>
> [2．4．4 津波対策 14](\l)

[第3節 海岸環境の整備と保全に関する基本的な事項 15](\l)

> [3．1 総説 15](\l)
>
> [3．2 生物の良好な生息・生育・繁殖環境の保全・復元 16](\l)
>
> [3．3 海岸景観等の保全と復元 17](\l)

[第4節 海岸利用に関する基本的な事項 17](\l)

> [4．1 総説 17](\l)
>
> [4．2 安全性 18](\l)
>
> [4．3 快適性・利便性 19](\l)

令和7年8月　版

適用上の位置付け

　河川砂防技術基準計画編は、基準の適用上の位置付けを明確にするために、下表に示すように適用上の位置付けを分類している。

+--------+------------------+------------------+------------------+
| 分　類 | 適用上の位置付け | 末尾の字句例     |                  |
+--------+------------------+------------------+------------------+
| 考え方 | 技術資料         | ●目              | 「･･･ある。      |
|        |                  | 的や概念、考え方 | 」「･･･いる。」  |
|        |                  | を記述した事項。 |                  |
|        |                  |                  | 「･･･なる。      |
|        |                  |                  | 」「･･･れる。」  |
+--------+------------------+------------------+------------------+
| 必　須 | 技術基準         | ●法令による規定  | 「･･･なければ    |
|        |                  | や技術的観点から | ならない。」「･  |
|        |                  | 実施すべきである | ･･ものとする。」 |
|        |                  | ことが明確であり |                  |
|        |                  | 遵守すべき事項。 |                  |
+--------+------------------+------------------+------------------+
| 標　準 | 技術基準         | ●特              | 「･･･            |
|        |                  | 段の事情がない限 | を標準とする。」 |
|        |                  | り記述に従い実施 |                  |
|        |                  | すべきだが、状況 | 「･･･            |
|        |                  | や条件によって一 | を基本とする。」 |
|        |                  | 律に適用すること |                  |
|        |                  | はできない事項。 | 「･･･による。」  |
+--------+------------------+------------------+------------------+
| 推　奨 | 技術資料         | ●状況や条件      | 「               |
|        |                  | によって実施する | ･･･望ましい。」  |
|        |                  | ことが良い事項。 |                  |
|        |                  |                  | 「               |
|        |                  |                  | ･･･推奨する。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･努める。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･必要に応    |
|        |                  |                  | じて･･･する。」  |
+--------+------------------+------------------+------------------+
| 例　示 | 技術資料         | ●適用条件や実施  | 「               |
|        |                  | 効果について確定 | ･･･などの手法（  |
|        |                  | している段階では | 事例）がある。」 |
|        |                  | ないが、状況や条 |                  |
|        |                  | 件によっては導入 | 「･･･など        |
|        |                  | することが可能な | の場合がある。」 |
|        |                  | 新技術等の例示。 |                  |
|        |                  |                  | 「･･･など        |
|        |                  | ●状              | が考えられる。」 |
|        |                  | 況や条件によって |                  |
|        |                  | 限定的に実施でき | 「               |
|        |                  | る技術等の例示。 | ･･･の場合には･･･ |
|        |                  |                  | ことができる。」 |
|        |                  | ●具体的          |                  |
|        |                  | に例示することに | 「               |
|        |                  | より、技術的な理 | ･･･例示する。」  |
|        |                  | 解を助ける事項。 |                  |
|        |                  |                  | 「例えば･･･。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･事例もある  |
|        |                  |                  | 。･･･もよい。」  |
+--------+------------------+------------------+------------------+

  関連通知等       関連する通知やそれを理解する上で参考となる資料
  ---------------- ------------------------------------------------------
  参考となる資料   例示等に示した手法・内容を理解する上で参考となる資料

6.  

```{=html}
<!-- -->
```
4.  海岸保全計画

    1.  総説

＜考え方＞

+----------------------------------------------------------------------+
| 本章は、各沿岸の海岸保全基本計画を踏まえ、                           |
| 各海岸において具体的に海岸防護や海岸環境の整備と保全、海岸利用を考慮 |
| して海岸保全を計画する際に検討すべき基本的な事項を示したものである。 |
|                                                                      |
| 図4-1のよ                                                            |
| うに、各海岸における海岸保全に関する計画は、海岸防護、海岸環境、海岸 |
| 利用に関する基本的事項を定める海岸保全計画と施設等の種類、配置及び規 |
| 模を定める海岸保全施設配置計画で構成され、両者は一体的に計画される。 |
|                                                                      |
| また、必要に応じて、各海岸において検討された内                       |
| 容を海岸保全基本計画に反映することも、適切に行われるべきものである。 |
|                                                                      |
| ![](media/image9.png){width="5.0921762904636925in"                   |
| height="3.9305555555555554in"}                                       |
|                                                                      |
| 図4-1　計画の構成とフロー                                            |
|                                                                      |
| 「海岸防護」は、                                                     |
| 高潮、津波、波浪の侵入から国民の生命、財産を守り、国民の共通の資産で |
| ある海浜を侵食から守ることである。「海岸環境の整備と保全」は、生態系 |
| や歴史・文化の基盤となった泥浜、砂浜、礫浜、磯など多様な空間そのもの |
| を保全するとともに、歴史・文化の舞台となった海岸景観を保全し、必要に |
| 応じて劣化している海岸環境の整備、改善を図ることである。また、「海岸 |
| 利用」は、レクリエーション、流通、漁場など多様な利用形態の輻輳、利用 |
| 形態間の対立の調整を図り、安全で快適な海岸利用を増進することである。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 海岸                                                                 |
| 保全計画は、海岸の有する機能を保全・復元・増進することにより、海岸防 |
| 護、海岸環境の整備と保全及び公衆の海岸の適正な利用の確保を図り、これ |
| らが調和した海岸空間を創出することを目的に策定することを基本とする。 |
|                                                                      |
| 本章は、海岸防護                                                     |
| に関する基本的な事項、海岸環境の整備と保全に関する基本的な事項及び海 |
| 岸利用に関する基本的な事項から構成されており、海岸保全計画の策定に当 |
| たって、それぞれの観点から検討すべき基本的な事項を示したものである。 |
|                                                                      |
| 海岸保全計画においては、これらを総合的に取り扱うことを基本とする。   |
+----------------------------------------------------------------------+

＜例　示＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  海岸保全計画では、海岸の防護・環境・利用の個別の目的の最適化を図る目標を設定するのではなく、海岸の防護・環境・利用が総合的に最適化されるよう、その検討の際にフィードバックが必要となる場合がある。また、海岸保全施設配置計画を検討した結果が、海岸保全計画で設定された防護・環境・利用の目標を満足していない場合には、海岸保全基本計画までフィードバックが必要となる場合がある。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1.  海岸保全区域等に係る海岸の保全に関する基本的な方針,令和2年11月20日,農林水産省・国土交通省告示第1号.

    6.  海岸防護に関する基本的な事項

        1.  総説

＜標　準＞

+----------------------------------------------------------------------+
| 海岸防護は、海岸環境・海岸利用との調和を図                           |
| りつつ、計画で想定される高潮、津波、波浪及び土砂動態に対して人命、資 |
| 産に対する被害や諸活動への影響を軽減することを目的とするものである。 |
|                                                                      |
| 海岸保全                                                             |
| 計画においては、防護すべき地域、防護水準等の海岸の防護の目標及びこれ |
| を達成するために実施しようとする施策の内容を定め、さらに、これらを検 |
| 討する際には、将来にわたる気候変動の影響も考慮することを基本とする。 |
|                                                                      |
| 本節は、防護すべき地域、防護目標及び海岸侵食・高潮・津波のそれぞれ   |
| についての防護目標を達成するための対策で構成されている。海岸防護は、 |
| 海岸侵食・高潮・津波の3つの側面から総合的に取り組むことを基本とする  |
| 。特に、高潮対策、津波対策において前提となっている海浜形状の諸元の妥 |
| 当性を確認するため、海岸侵食の有無について検討することを基本とする。 |
+----------------------------------------------------------------------+

＜例　示＞

+----------------------------------------------------------------------+
| 図4-2に海岸保全計画における海岸防護の位置付けを例示する。            |
| 海岸保全計画では、現状の海岸の状況をもとに、海岸防護、海岸環境、海岸 |
| 利用に関する目標を設定する。海岸防護の目標については、確保すべき海浜 |
| の形状として必要な諸元を計画海浜形状の諸元として設定するとともに、海 |
| 岸の防護水準を示す計画潮位、計画波浪、計画津波を設定する。次に、防護 |
| 水準等の海岸の防護の目標に対して海岸侵食・高潮・津波に対する防護対策 |
| を検討する。この検討においては、海岸侵食・高潮・津波の対策が一体的に |
| 計画され、検討の過程においてフィードバックが必要となる場合がある。ま |
| た、検討の結果、有効な対策を立案することが不可能な場合には、海岸の防 |
| 護・環境・利用の目標の設定までフィードバックが必要となる場合がある。 |
|                                                                      |
| 海岸侵食・高潮・津波                                                 |
| の対策の検討に当たっては、高潮・津波対策計画において確保される海浜形 |
| 状の諸元によって計画が異なることから、総合的な検討が必要な場合もある |
| 。例えば、海岸侵食によって海浜断面が小さくなることにより越波が増大す |
| ることから、計画海浜形状の諸元は、高潮対策や津波対策の前提条件となっ |
| ている。このため、計画海浜形状の諸元の長期的な安定(海岸侵食対策の必  |
| 要性の有無)を高潮対策や津波対策の検討に先立って確認する必要がある。  |
|                                                                      |
| ![QR コード AI                                                       |
| によって生成されたコンテンツは間違っている                           |
| 可能性があります。](media/image10.png){width="4.9847222222222225in"  |
| height="3.1468143044619423in"}                                       |
|                                                                      |
| 図4-2　海岸保全計画における海岸防護の位置付け                        |
+----------------------------------------------------------------------+

2.  防護すべき地域

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------
  高潮、波浪、津波等により、越波・浸水及び侵食等による被害が生じる危険性のある海岸を防護すべき地域とすることを基本とする。
  --------------------------------------------------------------------------------------------------------------------------

3.  防護水準等の海岸防護の目標

    1.  総説

＜標　準＞

+----------------------------------------------------------------------+
| 各々の海岸におい                                                     |
| て、気象、海象、地形等の自然条件及び過去の災害発生の状況を分析すると |
| ともに、気候変動の影響による外力の長期変化量を適切に推算し、背後地の |
| 人口・資産の集積状況や土地利用の状況等を勘案して、計画海浜形状の諸元 |
| を定め、所要の安全を適切に確保する防護水準を定めることを基本とする。 |
|                                                                      |
| 高潮からの防護を対象とする海岸にあっては、過去の台風等               |
| により発生した高潮の記録に基づく既往の最高潮位又は記録や将来予測に基 |
| づき適切に推算した潮位に、記録や将来予測に基づき適切に推算した波浪の |
| 影響を加え、これらに対して防護することを目標とすることを基本とする。 |
|                                                                      |
| 津波からの防護を対象とする海岸にあっては、過去に発生し               |
| た浸水の記録等に基づいて、数十年から百数十年に一度程度発生する比較的 |
| 発生頻度の高い津波に対して防護することを目標とすることを基本とする。 |
|                                                                      |
| なお、気候変動の影響による平均海                                     |
| 面水位や潮位偏差の将来予測は、気候変動に関する政府間パネル（IPCC）に |
| よる報告書で用いられた２℃上昇相当のシナリオにおける将来予測の平均的  |
| な値を前提とする海上風や気圧の予測結果に基づき行うことを基本とする。 |
+----------------------------------------------------------------------+

＜推　奨＞

+----------------------------------------------------------------------+
| ２℃以上の気温上昇が生                                                |
| じる可能性も否定できないことから、４℃上昇相当等のシナリオについては  |
| 、地域の特性に応じた海岸保全における整備メニューの点検や減災対策を行 |
| うためのリスク評価、海岸保全施設の効率的な運用の検討、将来の施設改良 |
| を考慮した施設設計の工夫等の参考として活用するよう努めるものとする。 |
|                                                                      |
| ま                                                                   |
| た、気象の状況及び将来の見通しの設定に当たっては、将来予測を行う高潮 |
| ・波浪推算モデル等の妥当性を確認し、必要に応じてバイアスを補正する。 |
|                                                                      |
| 気候                                                                 |
| 変動に関する政府間パネル（IPCC）や文部科学省・気象庁による報告書は数 |
| 年毎に更新されており、最新のデータや知見を参考にすることが望ましい。 |
|                                                                      |
| 潮位に比して背後地の地盤高が低いゼロメートル地帯                     |
| 等の地域や三大湾を始めとする背後に人口・資産が特に集積した地域にあっ |
| ては、過去の津波、高潮等による災害や気候変動の影響による外力の長期変 |
| 化を十分勘案し、必要に応じ、より高い安全を確保することを目標とする。 |
+----------------------------------------------------------------------+

＜例　示＞

  ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  海岸防護の目標は、２℃上昇相当のシナリオを前提としつつ、広域的・総合的な視点からの取組は、４℃上昇相当等のシナリオも考慮し、長期的視点から関連する分野とも連携することが重要である。海岸保全の前提とする平均海面水位の上昇量予測が2100年以降に１m程度を超える等、上昇量予測が想定より進んだ場合、改めて、その時点における社会経済情勢等を考慮し、従来の海岸保全の考え方による対応の限界も意識し、多様な選択肢を含めて長期的視点から適応策を検討することが考えられる。
  ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1.  海岸保全区域等に係る海岸の保全に関する基本的な方針,令和2年11月20日,農林水産省・国土交通省告示第1号.

＜参考となる資料＞

1.  気候変動を踏まえた海岸保全のあり方検討委員会：気候変動を踏まえた海岸保全のあり方　提言,2020.

    1.  計画海浜形状

＜考え方＞

+----------------------------------------------------------------------+
| 計画海浜形状の諸元を定める際には、長期的な安定化が                   |
| 図られるとともに、想定される短期変動によっても必要な諸元が確保される |
| ように設定する。また、現況海浜の諸元では計画海浜形状の諸元を確保でき |
| ない場合には、侵食の影響を緩和するため養浜や漂砂制御施設を検討する。 |
|                                                                      |
| 設定された計画海浜形状の諸元が、海岸侵食の対策                       |
| では確保することが困難な場合、又は高潮・津波の対策上不十分な場合には |
| 、計画海浜形状の諸元や海岸の防護・環境・利用の目標の設定を変更する。 |
+----------------------------------------------------------------------+

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  計画海浜形状の諸元は、気象、海象、地形等の自然条件、過去の災害発生状況を分析し、背後地の人口、資産集積状況、利用状況、経済性等を勘案して、海岸の防護・環境・利用上必要とされる海浜形状の諸元として定めることを基本とする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜例　示＞

+----------------------------------------------------------------------+
| 海浜形状の代表的な諸元としては、図4-3に示すように後浜幅、            |
| 後浜高、前浜幅、前浜勾配、外浜幅、外浜勾配及び汀線の形状などがある。 |
|                                                                      |
| ![](media/image11.png){width="5.64in" height="1.9519247594050744in"} |
|                                                                      |
| 図4-3 海浜形状の諸元                                                 |
|                                                                      |
| 計画海浜形状の諸元は、海岸の防護、環境、利用のそれぞ                 |
| れの観点から多面的に検討して決定する。海岸の防護の観点から、高潮対策 |
| や津波対策においては、例えば海浜形状の個別の諸元よりむしろうちあげ高 |
| が計画を上回らない海浜断面積を定めることが考えられる（図4-4参照）。  |
| 海岸侵食対策においては、国土の基線、海岸保全施設の基礎部の地盤として |
| 必要な後浜幅や沿岸漂砂量を制御するための汀線の形状を定めることが考え |
| られる。海岸環境の保全の観点からは、海岸の植生帯や産卵地などの場とし |
| て必要な後浜幅、及び海岸の動植物の生息範囲、海岸の景観を考慮して必要 |
| な諸元を定めることが考えられる。海岸利用の観点からは、地域の文化や生 |
| 活との関連、及び海浜の利用者数などを考慮して定めることが考えられる。 |
|                                                                      |
| ![](media/image12.png){width="5.254323053368329in"                   |
| height="4.944444444444445in"}                                        |
+----------------------------------------------------------------------+

2.  計画潮位

＜標　準＞

+----------------------------------------------------------------------+
| 計画潮位は、潮汐                                                     |
| 、高潮、セイシュ、副振動などを考慮して決定することを基本とする。この |
| 際には、頻度、周期、継続時間などを合わせて考慮することを基本とする。 |
|                                                                      |
| 計画潮位は、                                                         |
|                                                                      |
| 1． 既往の最高潮位                                                   |
|                                                                      |
| 2． 朔望平均満潮位＋既往の最大潮位偏差                               |
|                                                                      |
| 3． 朔望平均満潮位＋推算された最大潮位偏差                           |
|                                                                      |
| に気象の状況及び将来の見通しを勘案して                               |
| 必要と認められる値を加えたもののうちから、当該海岸保全施設の背後地の |
| 状況等を考慮して海岸管理者が総合的に判断して定めることを基本とする。 |
|                                                                      |
| ただし、2.、3.の場合においては、当該満潮位の時に当該潮位偏差及       |
| び計画波浪が発生する可能性を考慮して、当該潮位偏差の最大値の範囲内に |
| おいて下方補正や、平均海水面変動を考慮して上方補正できるものとする。 |
|                                                                      |
| 最大潮位偏差は、できるだけ長期間にわたる実測値若しくは浸水記録を     |
| もとに定めるか、または実測値若しくは浸水記録を十分に再現した数値計算 |
| 若しくは適切な算定式により算定した値に基づき定めることを基本とする。 |
+----------------------------------------------------------------------+

＜例　示＞

+----------------------------------------------------------------------+
| 通年の朔望平均満潮位の代わ                                           |
| りに台風期（7月～10月）の朔望平均満潮位を採用しているところもある。  |
|                                                                      |
| 朔望平                                                               |
| 均満潮位の将来変化は平均海面水位の将来変化と同程度と見なしてもよい。 |
|                                                                      |
| 潮位偏差の将来変化の推定方法は、想定台風を対象にしたシナリオ型と不特 |
| 定多数の台風を対象にした確率型に分類される（森ほか、2020）。また、検 |
| 討に当たっては、台風等の発生頻度や台風経路予測の不確実性等を踏まえ、 |
| 気候変動の影響を考慮した多数かつ長期間の気候計算結果のデータベースで |
| あるアンサンブル気候予測データを利用することが考えられる。アンサンブ |
| ル気候予測データは、台風や低気圧の属性（中心気圧や最大風速等）を用い |
| ることにより、極端現象の将来変化を確率的に評価することが可能である。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  海岸保全施設の技術上の基準について,令和3年7月30日最終改正,3農振第1118号,3水港第1389号,国水海第24号,国港海第107号.

```{=html}
<!-- -->
```
52. 気候変動の影響を踏まえた海岸保全施設の計画外力の設定方法等について,令和3年8月2日,3農振第1203号,3水港第1463号,国水海第25号,国港海第113号.

53. 気候変動の影響を踏まえた海岸保全施設の計画外力の設定に関する参考資料等について,令和3年8月2日,農林水産省農村振興局整備部防災課,水産庁漁港漁場整備部防災漁村課,国土交通省水管理・国土保全局海岸室,国土交通省港湾局海岸・防災課.

＜参考となる資料＞

計画潮位の設定方法については、下記の資料が参考となる。

1.  全国農地海岸保全協会・公益社団法人全国漁港漁場協会・一般社団法人全国海岸協会・公益社団法人日本港湾協会：海岸保全施設の技術上の基準・同解説,2018.

```{=html}
<!-- -->
```
54. 森信人・福井信気・志村智也:
    気候変動を考慮した我が国の三大湾の高潮最大潮位偏差についての研究レビュー,土木学会論文集B2(海岸工学),Vol.76,
    No.1, pp.1-6,2020.

55. 文部科学省・気象庁：日本の気候変動2020－大気と陸・海洋に関する観測・予測評価報告書－,2020.

56. 文部科学省・気象庁：日本の気候変動2025－大気と陸・海洋に関する観測・予測評価報告書－,2025.

57. 気候変動を踏まえた海岸保全のあり方検討委員会：気候変動を踏まえた海岸保全のあり方　提言,2020.

    1.  計画波浪

＜標　準＞

+----------------------------------------------------------------------+
| 計画波浪は沖波とする。                                               |
|                                                                      |
| 計画                                                                 |
| 波浪の波高、周期、波向は、長期間の観測データに基づいた統計解析に、気 |
| 象の状況及び将来の見通しを勘案して設定することを基本とする。ただし、 |
| 観測データが十分でない場合は、波浪推算の結果を準用できることとする。 |
|                                                                      |
| 計画波浪の波向は、うちあげ高や越波量、及び構造物等の規模や安         |
| 定性に大きな影響を与えると考えられる方向を考慮することを基本とする。 |
|                                                                      |
| 波浪推算は、スペクトル法または有義波法によることを基本とする。       |
+----------------------------------------------------------------------+

＜例　示＞

  ---------------------------------------------------------------------------
  波浪の長期変化量についても、2.3.3で例示した方法を参考にすることができる。
  ---------------------------------------------------------------------------

＜関連通知等＞

1.  海岸保全施設の技術上の基準について,令和3年7月30日最終改正,3農振第1118号,3水港第1389号,国水海第24号,国港海第107号.

```{=html}
<!-- -->
```
58. 気候変動の影響を踏まえた海岸保全施設の計画外力の設定方法等について,令和3年8月2日,3農振第1203号,3水港第1463号,国水海第25号,国港海第113号.

59. 気候変動の影響を踏まえた海岸保全施設の計画外力の設定に関する参考資料等について,令和3年8月2日,農林水産省農村振興局整備部防災課,水産庁漁港漁場整備部防災漁村課,国土交通省水管理・国土保全局海岸室,国土交通省港湾局海岸・防災課.

＜参考となる資料＞

計画波浪の設定方法については、下記の資料が参考となる。

> 1)　全国農地海岸保全協会・公益社団法人全国漁港漁場協会・一般社団法人全国海岸協会・公益社団法人日本港湾協会：海岸保全施設の技術上の基準・同解説,2018.

1.  計画津波

＜考え方＞

+----------------------------------------------------------------------+
| 2011年の東北地                                                       |
| 方太平洋沖地震では、それまでの想定をはるかに超えた巨大な津波が発生し |
| 、戦後最大の人命が失われ、甚大な被害が生じた。この津波災害を教訓とし |
| て、今後の津波対策を構築するに当たっては、住民避難を柱とした総合的防 |
| 災対策を構築するには最大クラスの津波を、津波の内陸への侵入を防ぐ海岸 |
| 保全施設等の建設には比較的発生頻度が高い津波を想定することになった。 |
|                                                                      |
| 計画津波は、各海岸の津波対策を計画する上で想定す                     |
| る津波であり、海岸保全施設の設計に用いる設計津波と同様に定められる。 |
|                                                                      |
| なお、津波は頻度の                                                   |
| 低い現象であり、高潮対策の対象とする外力を同時に考慮する必要はない。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 計画津波は、過去の浸水の記録等に基づく最大の津波又は数値計算         |
| 等により算定した最大の津波を考慮して、原則として、数十年から百数十年 |
| に一度程度発生する比較的発生頻度の高い津波を定めることを基本とする。 |
|                                                                      |
| 計画津波は、地域海岸（同一の津波外力を設定しうると                   |
| 判断される一連の海岸）ごとに、過去に発生した津波の津波高さ及びシミュ |
| レーションにより求めた津波高さから一定の頻度（数十年から百数十年に一 |
| 度程度）で到達すると想定される津波の集合から定めることを基本とする。 |
|                                                                      |
| な                                                                   |
| お、計画津波においても平均海面水位の上昇を考慮することを基本とする。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  設計津波の水位の設定方法等について,平成23年7月8日,農林水産省農村振興局整備部防災課長,水産庁漁港漁場整備部防災漁村課長,国土交通省水管理・国土保全局砂防部保全課海岸室長,国土交通省港湾局海岸・防災課長.

```{=html}
<!-- -->
```
60. 海岸保全施設の技術上の基準について,令和3年7月30日最終改正,3農振第1118号,3水港第1389号,国水海第24号,国港海第107号.

＜参考となる資料＞

計画津波の設定方法については、下記の資料が参考となる。

1.  全国農地海岸保全協会・公益社団法人全国漁港漁場協会・一般社団法人全国海岸協会・公益社団法人日本港湾協会：海岸保全施設の技術上の基準・同解説,2018.

    1.  防護目標を達成するための対策

        1.  総説

＜考え方＞

+----------------------------------------------------------------------+
| 「防護目標を達成するための対策」では、海岸                           |
| 侵食・高潮・津波のそれぞれについて、防護の目標を踏まえた手段について |
| 定めるものであるが、これらは独立したかたちで検討されるものではなく、 |
| 図4-5に示すようにそれぞれ相互関係を考慮するなど総合的に検討される。  |
|                                                                      |
| また、津波、                                                         |
| 高潮対策については、計画規模の津波、高潮による被害を防ぐ施設の整備だ |
| けでなく、計画規模を超過する外力に対する減災の観点も考慮し、超過外力 |
| に対して減災効果を発揮する粘り強い構造の堤防等の整備や適切な避難のた |
| めの迅速な情報伝達、地域と協力した防災体制の整備や避難地の確保、土地 |
| 利用の調整、都市計画等のまちづくりと連携を行うなど、ハード面の対策と |
| ソフト面の対策を組み合わせた総合的な対策を行うよう努める必要がある。 |
|                                                                      |
| 図4-5に                                                              |
| 示すように、海岸防護対策の検討に当たっては、高潮・津波の計画を検討す |
| る際の前提条件となる計画海浜形状の諸元が確保されることを確認するため |
| 、計画海浜形状と現況の海浜形状との比較、将来予測等から、海岸侵食対策 |
| の必要性の有無を検討する。この結果、対策が必要であると判断された海岸 |
| においては、まず海岸侵食対策を検討し、計画海浜形状を確保するための対 |
| 策を検討する。なお、海岸侵食対策については、モニタリングを行いながら |
| 、予測の不確実性を見込みつつ、順応的な対応を検討することが望ましい。 |
|                                                                      |
| 次に、計画潮位、計画波浪、計画津波に対して高潮                       |
| ・津波対策の必要性を検討する。この際、高潮・津波対策が計画海浜形状の |
| 維持に影響を与える場合には、海岸侵食対策にフィードバックして検討する |
| 。さらに計画海浜形状の諸元によって高潮対策の内容が制約を受けており、 |
| より適切な計画を策定するために計画海浜形状の諸元を修正する必要が生じ |
| る場合もある。この場合には、計画海浜形状の設定までフィードバックして |
| 検討する。さらに、海岸防護に関する計画を策定する過程で、海岸環境や海 |
| 岸利用の観点から計画海浜形状の諸元を修正する必要が生じる場合もある。 |
|                                                                      |
| > ![](media/image13.png){width="5.296668853893263in"                 |
| > height="3.822785433070866in"}                                      |
|                                                                      |
| ![](media/image14.png){width="4.510416666666667in"                   |
| height="2.0416119860017496in"}                                       |
|                                                                      |
| 図4-6　気候変動に伴う汀線後退のイメージ                              |
|                                                                      |
| 海浜の断面形状は                                                     |
| 、波浪や潮流による短期的な変動や、気候変動による海面水位の上昇、沿岸 |
| 漂砂の不均衡による侵食のような長期的な変動が、複合して変動している。 |
| 海面水位が上昇した場合、図4-6のように、水位が上昇した条件にあった平  |
| 衡海浜断面となるように砂浜の断面形状が変化するため、砂浜と海の境界と |
| なる汀線の後退は、現在の地形のまま水位を上昇させた場合よりも大きくな |
| ると考えられる。そのため、地形や構造物等の条件によっては、汀線が相当 |
| 程度後退したり、砂浜が消失する可能性があることを考慮する必要がある。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 海岸防護は、海                                                       |
| 岸侵食・高潮・津波について総合的に検討することを基本とする。海岸防護 |
| は、海岸環境・海岸利用と調和していなければならない。特に、海岸侵食に |
| ついては、高潮・津波や海岸環境・海岸利用の前提となる計画海浜形状の諸 |
| 元を定めるため、高潮・津波の検討に先立って検討することを基本とする。 |
|                                                                      |
| また、津波・高潮対策については、ハード面の対策とソフト面             |
| の対策を組み合わせた総合的な対策を行うよう検討することを基本とする。 |
+----------------------------------------------------------------------+

2.  海岸侵食対策

＜考え方＞

+----------------------------------------------------------------------+
| 海岸侵食対策は、国土の消                                             |
| 失を防ぐことや、越流や越波による災害を防ぐことのみではなく、かけがえ |
| のない海岸環境を将来に遺し、海岸利用空間を確保することが目的である。 |
|                                                                      |
| 海岸侵食対策の検討に                                                 |
| 当たっては，海岸環境及び海岸利用との調和を図り，海岸の種々の特性が十 |
| 分に生かされるようにする。特に砂浜は、防災上の機能と併せ、環境や利用 |
| という観点から良好な空間としての機能を有するため、その保全に努める。 |
|                                                                      |
| 長期的な海岸侵食は、沿岸漂砂の不均衡が主な原因である。また、場所に   |
| よっては、深海への土砂損失や地盤沈下も海岸侵食の原因となる。さらに、 |
| これらに加え、今後は、気候変動に伴う海面水位の上昇が海岸侵食に大きな |
| 影響を与える。沿岸漂砂の不均衡による侵食には、次の機構が考えられる。 |
|                                                                      |
| 1.沿岸漂砂の連続性の阻害（図4-7(a)参照）                             |
|                                                                      |
| 沿岸漂砂が卓越した海岸において、防波堤、導流堤、埋立護               |
| 岸、あるいは突堤や離岸堤などの構造物が設置されると、沿岸漂砂の一部又 |
| は全部が遮断され、構造物の下流（沿岸漂砂の下手側）で侵食が発生する。 |
|                                                                      |
| 2.波の遮蔽域の形成（図4-7(b)参照）                                   |
|                                                                      |
| 波が海岸線にほぼ直角に入射する                                       |
| 沿岸漂砂の少ない海岸でも、海域に設置された大規模な防波堤や人工島の背 |
| 後では、波の遮蔽域が形成されることにより、岸の近くで遮蔽域の外側から |
| 内側へと土砂が移動することにより侵食が発生する。また、波の入射方向が |
| 季節的に変動し見かけの漂砂量の少ない海岸では、沿岸漂砂が構造物に遮断 |
| されて堆積した土砂が、波向が反転しても、遮蔽域では漂砂の方向が反転し |
| ないため遮蔽域の外に移動できずに不均衡が生じ、急速な侵食が発生する。 |
|                                                                      |
| 3.供給土砂量の減少（図4-7(c)参照）                                   |
|                                                                      |
| 対象海岸へ流入する河川の上流における砂防堰堤、ダムへの               |
| 堆砂、洪水頻度の減少に伴う流砂量の減少、床止め等による河道内堆積量の |
| 増加、川砂利採取による河道内堆積物の減少により、河口からの供給土砂量 |
| は減少する。また、海食崖から供給される土砂によって維持されていた海岸 |
| では、海食崖の侵食対策によって土砂収支バランスが崩れ侵食が発生する。 |
|                                                                      |
| 4.浚渫・砂利採取                                                     |
|                                                                      |
| 航路・河口浚渫や河口部や                                             |
| 海域での砂利採取によって沖に掘削跡が形成されると、漂砂が掘削跡にトラ |
| ップされたり、掘削跡を埋めるような海浜変形が発生し、侵食が発生する。 |
|                                                                      |
| ![](media/image15.png){width="3.8409722222222222in"                  |
| height="1.4174803149606299in"}                                       |
|                                                                      |
| \(a\) 連続性の阻害                                                   |
|                                                                      |
| ![](media/image15.png){width="3.8409722222222222in"                  |
| height="1.8112248468941383in"}                                       |
|                                                                      |
| \(b\) 遮蔽域の形成                                                   |
|                                                                      |
| ![](media/image16.png){width="4.444674103237095in"                   |
| height="1.3040004374453193in"}                                       |
|                                                                      |
| \(c\) 供給土砂量の減少                                               |
|                                                                      |
| 図4-7　沿岸漂砂の不均衡による侵食機構                                |
|                                                                      |
| 海岸侵食に対                                                         |
| しさまざまな対策が行われ、侵食が止まり、回復した砂浜がある一方、海岸 |
| 侵食の進行に対策が追いつかず、侵食による深刻な影響が発生してから対策 |
| に着手するなど、後追い的に対策が行われてきた箇所も多い。これまでの後 |
| 追い的な対策では、結果として侵食対策にさらなるコストと時間を要したり |
| 、対策後も砂浜が回復しないなどの場合があるなどの課題が明らかになって |
| きており、より早期の対策着手が求められている。また、海岸により侵食機 |
| 構も必要な対応も異なることから、早期の対策着手のためには、モニタリン |
| グを行いながら、予測の不確実性を見込みつつ、順応的な対応を一層強化す |
| る「予測を重視した順応的砂浜管理」を念頭に対策を検討する必要がある。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 海岸侵食に対しては、将来的な気候変動や人為的改変による影響等も考慮   |
| し、継続的なモニタリングにより流砂系全体や地先の砂浜の変動傾向を把握 |
| し、侵食機構を設定した上で将来変化の予測に基づき対策を実施することを |
| 基本とする。さらに、その効果をモニタリングで確認し、「予測を重視した |
| 順応的砂浜管理」を念頭に対策を計画することを基本とする。また、海岸侵 |
| 食に対しては、必要に応じて養浜により計画海浜形状の諸元を確保するとと |
| もに、河川の上流から海岸までの流砂系における総合的な土砂管理等により |
| 土砂動態の改善を図った上で、漂砂制御施設や継続的な養浜により沿岸漂砂 |
| の均衡を図り、計画海浜形状の諸元を維持することを目的として、多様な関 |
| 係機関との連携の下に広域的・総合的な対策を推進することを基本とする。 |
|                                                                      |
| 海岸侵食対策計画の計画区域は、1つの漂砂系を基本とする。              |
+----------------------------------------------------------------------+

＜例　示＞

+----------------------------------------------------------------------+
| 図4-8に海岸侵食対策計画の検討フローを例示する。                      |
|                                                                      |
| 海岸侵食対策計画の検討においては、まず海底谷や深                     |
| 海へ流出する場合を除いては土砂収支が閉じた漂砂系を設定する。図4-9の  |
| ように、漂砂系内では、1)河川や海食崖から供給される土砂、2)飛砂となっ |
| て領域外に流出する土砂、3)沿岸漂砂として領域に流入・流出する土砂、4) |
| 岸沖方向の漂砂として領域に流入・流出する土砂、5)海底谷や深海へ流出す |
| る土砂、6)人為的に領域外へ持ち出される土砂などが主な土砂収支である。 |
|                                                                      |
| ![](media/image17.png){width="2.5091108923884513in"                  |
| height="4.94186132983377in"}                                         |
|                                                                      |
| ![](media/image18.png){width="4.9520002187226595in"                  |
| height="1.3436461067366579in"}                                       |
|                                                                      |
| 次に過去及び現状の土砂収支の状況から、侵食機構を解                   |
| 明し、関係機関との調整を通じた総合的な土砂管理により土砂動態の改善を |
| 試み、土砂動態の将来形を設定する。このためには、土砂動態の変遷を沿岸 |
| 漂砂量分布あるいは土砂収支として把握することが重要である。土砂動態を |
| 把握する地点としては、対象とする漂砂系への土砂流入点、漂砂系外への土 |
| 砂流出点、及び沿岸構造物等によって沿岸漂砂が変化する点の前後である。 |
|                                                                      |
| 社会                                                                 |
| ・経済的にみて土砂動態の改善のみでは計画海浜形状の諸元の維持が困難な |
| 場合には、漂砂制御施設や継続的な養浜により計画海浜形状の諸元の維持を |
| 図る。計画された漂砂制御施設や継続的な養浜を経済的、環境的な観点等か |
| ら実行可能性について検討し、実行不可能な場合には、計画海浜形状の諸元 |
| や海岸の防護・環境・利用の目標の設定を変更するなどして再度検討する。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

予測を重視した順応的砂浜管理については、下記の資料が参考となる。

1.  津波防災地域づくりと砂浜保全のあり方に関する懇談会：砂浜保全に関する中間とりまとめ,2019,<https://www.mlit.go.jp/river/shinngikai_blog/tsunamiKondankai/>index.html

    1.  高潮対策

＜考え方＞

+----------------------------------------------------------------------+
| 高潮対策は、高                                                       |
| 潮や波浪による災害を防止することが目的である。「高潮」は、台風や低気 |
| 圧などによりもたらされる気圧低下と風による吹き寄せにより海岸付近の潮 |
| 位が著しく上昇する現象である。しかし、「高潮対策」という場合には、潮 |
| 位上昇に対する対策とともに強風による高波浪に対する対策（高波対策）の |
| 両方を対象とする。高潮や波浪による被害の形態としては、1）越波、越流  |
| が発生し、これによる堤内地の浸水によるもの、2）越波した海水及び流入  |
| 物のもつエネルギーによるもの、に分類することができる。防護対象として |
| は、人命、資産及び営業活動や交通などの諸活動に分類することができる。 |
|                                                                      |
| 台風時等にお                                                         |
| いて海岸に来襲する波浪の中には周期数分に及ぶ長周期波が含まれているこ |
| とが確認されており、これがうちあげ高や越波に少なからず影響を与えると |
| 考えられるが、長周期波を定量的に取り扱うのに十分な資料が得られていな |
| いので、当面は計画潮位の上に計画波浪を作用させて高潮対策を考えること |
| とし、調査編に従い長周期波の特性を把握するための資料の収集に努める。 |
|                                                                      |
| 高潮対策の検討に当たっては、計画海浜形状の                           |
| 諸元の確保が前提となっており、高潮対策を検討する前に海岸侵食について |
| 検討し、計画海浜形状の諸元が確保されることを確認しておく必要がある。 |
|                                                                      |
| 高潮対策については、計画規模を超過する外力に対する減災の観点から、計 |
| 画規模の高潮や波浪による被害を防ぐ堤防等の海岸保全施設の整備だけでな |
| く、超過外力に対して減災効果を発揮する粘り強い構造の堤防等の整備、適 |
| 切な避難のための迅速な情報伝達などソフト面の対策も合わせて検討する。 |
|                                                                      |
| 高潮対策の検討に当たっては、海岸環境及び海                           |
| 岸利用との調和を図り、海岸の種々の特性が十分に生かされるようにする。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 高潮に対しては、計画潮位、計画                                       |
| 波浪及び計画海浜形状の諸元に対して堤防と消波施設により越波や越流を防 |
| 止し、人命、資産、諸活動を防護することを目的とすることを基本とする。 |
|                                                                      |
| また、計                                                             |
| 画規模を超過する外力に対する減災についても考慮することを基本とする。 |
+----------------------------------------------------------------------+

＜例　示＞

+----------------------------------------------------------------------+
| 計画規模を超過する高潮                                               |
| や高波に対する海岸保全施設の整備以外による減災対策として、水防法に基 |
| づく高潮浸水想定区域の指定やハザードマップ等による浸水が想定される範 |
| 囲や深さの事前周知があげられる。また、予め高潮特別警戒水位を設定し、 |
| 高潮時に水防管理者及び量水標管理者等へ水位周知することにより、高潮や |
| 高波の発生時における水防活動の充実や住民等の避難の促進が期待できる。 |
|                                                                      |
| なお、本節で海岸防護の対象範囲としている堤内地とは、堤防で防         |
| 護された背後地のみではなく、例えば、離岸堤や砂浜等の海岸保全施設や天 |
| 然の海岸の背後地を含めて表すものである（以下、本資料において同様）。 |
+----------------------------------------------------------------------+

2.  津波対策

＜考え方＞

+----------------------------------------------------------------------+
| 津波対策                                                             |
| は、津波による災害を防止することを目的とする。津波による被害の形態は |
| 、1）越波、越流が発生し、これによる堤内地の浸水によるもの、2）越波し |
| た海水及び流入物のもつエネルギーによるもの、に分類することができる。 |
|                                                                      |
| 津波対策につい                                                       |
| ては、超過外力に対する減災も考慮し、計画津波による被害を防ぐ堤防・津 |
| 波防波堤等の海岸保全施設の整備だけではなく、超過外力に対して減災効果 |
| を発揮する粘り強い構造の堤防等の整備、危機管理の観点から、地域と協力 |
| した防災体制の整備や避難地・避難路の確保、利用者の避難誘導、さらに土 |
| 地利用の調整等のソフト面の対策も組み合わせた総合的な対策を検討する。 |
|                                                                      |
| 高潮や高波浪が頻繁に来襲する海岸では、津波により海岸保               |
| 全施設が被災した場合を想定した早期復旧方法を検討しておく必要がある。 |
|                                                                      |
| 津波対策の検討に当たっては、海岸環境及び海                           |
| 岸利用との調和を図り、海岸の種々の特性が十分に生かされるようにする。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 津波対策は、計画津波に対して堤防等による                             |
| 人命・資産の防護、諸活動への影響の軽減を目的とすることを基本とする。 |
|                                                                      |
| また、計                                                             |
| 画規模を超過する外力に対する減災についても考慮することを基本とする。 |
+----------------------------------------------------------------------+

＜例　示＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  計画規模を超過する津波に対する海岸保全施設の整備以外による減災対策としては、津波防災地域づくりに関する法律に基づく津波避難対策などが考えられる。具体的には、最大クラスの津波があった場合に想定される浸水の区域及び水深を設定する津波浸水想定を踏まえて、都道府県による津波災害警戒区域等の指定や津波防護施設の整備、道路・鉄道等の施設の津波防護施設としての指定のほか、市町村による津波ハザードマップの作成、避難施設の指定、避難訓練の実施などがある。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1.  津波防災地域づくりの推進に関する基本的な指針,平成24年1月16日,国土交通省告示第51号.

    6.  海岸環境の整備と保全に関する基本的な事項

        1.  総説

＜考え方＞

+----------------------------------------------------------------------+
| 海岸は、陸域と海域とが相接する空間であり、                           |
| 砂浜、岩礁、干潟等生物にとって多様な生息・生育環境を提供しており、そ |
| こには、特有の環境に依存した固有の生物も多く存在している。また、白砂 |
| 青松等の名勝や自然公園等の優れた自然景観の一部を形成することもある。 |
|                                                                      |
| 整備・保全すべき海岸の環境機能としては、1）生物                      |
| の生息、産卵、保育空間、2）生物的、物理的水質浄化、3）肉体的、精神的 |
| 健康増進、4）環境教育空間、5）二酸化炭素固定などの機能があげられる。 |
| 海岸保全計画の策定範囲には海岸保全区域のみでなく、例えば白砂青松など |
| 背後地の保安林が景観上重要な要素となっている場合もあるので、必要に応 |
| じて隣接する海岸や背後地、沖合の海面なども含める。海岸環境の整備と保 |
| 全に当たっては、海岸環境に支障を及ぼす行為をできるだけ回避し、海岸環 |
| 境の保全に努めるとともに、必要に応じ喪失した自然や景観の復元を図る。 |
| このため、それぞれの海岸の有する自然特性に応じた海岸保全施設の整備を |
| 進める。また、生物の生息・生育場の確保の観点から、既存の施設を海岸環 |
| 境に配慮した施設に作り変えていくことも検討する。海岸の防護・環境・利 |
| 用の相互間では、図4-10に示すようにトレードオフが発生する場合がある。 |
|                                                                      |
| ![](media/image19.png){width="5.590729440069992in"                   |
| height="1.8720002187226596in"}                                       |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 海岸環境の整備と保全は、海岸防護・海岸利用との調和を図りつつ、海     |
| 岸の生態系や景観の保全・復元を図ることを目的とすることを基本とする。 |
|                                                                      |
| 海岸保全計画においては、現状や過去の状                               |
| 況、近隣の海岸の状況等を踏まえ、海浜・磯など多様な海岸環境の保全・復 |
| 元が図られるように、関係者の合意形成を図りつつ、海岸環境を整備し、及 |
| び保全するために実施しようとする施策の内容を定めることを基本とする。 |
+----------------------------------------------------------------------+

＜例　示＞

+----------------------------------------------------------------------+
| 海岸環境は、多様な                                                   |
| 要素から構成されており、各要素に対する価値観は千差万別である。このた |
| め、特定の要素に特化すると、ほかの要素へ悪影響を与え、価値観の衝突を |
| 招くおそれがある。このようなトレードオフ・衝突を極力小さくし、地域の |
| 自然特性・社会特性に応じた海岸環境の目標を設定するには、砂浜等に特有 |
| の生物の生息・利用といった現況の環境機能について適切に評価し、図4-11 |
| に示すように関係者（海岸管理者、地方自治体、専門家、地域住民）の合意 |
| 形成を図るとともに、協働による保全・復元が図られることが重要である。 |
|                                                                      |
| 具体的な取                                                           |
| 組の例としては、宮崎海岸の侵食対策事業における合意形成が挙げられる。 |
|                                                                      |
| ![](media/image20.png){width="3.8240004374453194in"                  |
| height="1.6992366579177602in"}                                       |
+----------------------------------------------------------------------+

＜参考となる資料＞

海岸の防護・環境・利用間のトレードオフを考慮した計画策定については、下記の資料が参考となる。

1.  自然共生型海岸づくり研究会編著：自然共生型海岸づくりの進め方,一般社団法人全国海岸協会,2003.

関係者との合意形成の事例については、下記の資料が参考となる。

61. 吉武哲信：多様な主体の合意形成を目指す宮崎海岸侵食対策事業,日本砂丘学会誌,58巻2号,61-70,2011.

    1.  生物の良好な生息・生育・繁殖環境の保全・復元

＜考え方＞

+----------------------------------------------------------------------+
| 海岸は底質等によって、泥浜、砂浜、礫浜、サ                           |
| ンゴ礁、磯に分類され、その場の特性に応じて特有の生態系を形成している |
| 。例えば、砂浜は、ウミガメの産卵地やコアジサシの産卵・営巣地であるな |
| ど生物の生息地、産卵地及び営巣地となっており、泥浜は多様な生物の生息 |
| 地であり野鳥の餌場となっている。そのほか、藻場、海草場は、海の食物連 |
| 鎖の基礎生産を支えており、産卵地や稚魚の隠れ場ともなっている。さらに |
| 、縦断的には沖浜、外浜、前浜、後浜に分類され、空間に応じて繁殖場、生 |
| 育場、生息場などの機能を発揮しているとともに、空間相互が密接に関連を |
| もっている。生態系はこうした多様な空間の存在によって成立しており、各 |
| 種空間の生態機能、相互関係(ネットワーク)を理解することが重要である。 |
|                                                                      |
| 生態系は多                                                           |
| 様な種によって形成されており、これをすべて把握することは困難である。 |
| このため、海岸の特性を踏まえ生態系全体の保全の重要な役割あるいは指標 |
| となる注目する種や群集を選定し、その保全を検討することが有効である。 |
+----------------------------------------------------------------------+

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  生物の良好な生息・生育・繁殖環境の保全・復元については、計画策定時点あるいは過去の生物の生息の状況等を踏まえ、多様な生物が生息でき、安定性の高い生息・生育・繁殖環境の保全に努め、必要に応じ復元にも努めることを基本とする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜参考となる資料＞

生物の良好な生息・生育・繁殖環境の保全・復元については、下記の資料が参考となる。

1.  自然共生型海岸づくり研究会編著：自然共生型海岸づくりの進め方,一般社団法人全国海岸協会,2003.

```{=html}
<!-- -->
```
62. 須田有輔編著：砂浜海岸の自然と保全,生物研究社,2017.

63. 環境省自然環境局野生生物課：コアジサシ繁殖地の保全・配慮指針,2014.

    1.  海岸景観等の保全と復元

＜考え方＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  「白砂青松」に代表される海岸景観は、海洋国家である我が国の文化、アイデンティティーの形成に大きく関与してきた。一方、我が国は高潮、侵食、津波といった自然災害が発生しやすく、沿岸部の土地利用が高度化していることから、民生の安定のためには防災対策が不可欠である。このため従来、限られた予算の範囲内で防災対策を急ぐ余り、海岸景観に対する配慮が欠けている面があった。海岸保全計画においては、多様な海岸の価値を理解し、海岸の価値を総合的に評価し、その保全、復元が求められる。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 海岸景観の                                                           |
| 保全と復元は、背後地の保安林や街並みの景観などと一体的にとらえ、自然 |
| 海岸の景観を特徴付けている海面、水平線、汀線及び、それに接する陸域が |
| 織りなす景観の保全に努め、必要に応じて復元に努めることを基本とする。 |
|                                                                      |
| 海岸の景観への配慮を検討するに当たっ                                 |
| ては、汀線・海浜・海岸林・岬・背後の丘陵や山等の自然的要素、海岸堤防 |
| ・護岸・離岸堤・人工リーフ・突堤・ヘッドランド等の人工的要素などの海 |
| 岸景観を構成する主要素を認識するとともに、音や潮の香りをはじめとする |
| 海岸の雰囲気を醸し出す重要な要素についても留意することを基本とする。 |
+----------------------------------------------------------------------+

＜推　奨＞

+----------------------------------------------------------------------+
| 海岸景観への配慮を検討                                               |
| するに当たっては、視覚的景観、地域性、生態系、サステイナビリティ（持 |
| 続可能性）、コストを踏まえ、幅広く総合的な検討を行うことが望ましい。 |
|                                                                      |
| 視覚的景観につい                                                     |
| ては、内部視点景観と外部視点景観の双方から検討を行うことが望ましい。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  国土交通省河川局・港湾局・農林水産省農村振興局・水産庁：海岸景観形成ガイドライン,2006.

```{=html}
<!-- -->
```
64. 国土交通省水管理・国土保全局：河川・海岸構造物の復旧における景観配慮の手引き,2011.

    4.  海岸利用に関する基本的な事項

        1.  総説

＜考え方＞

+----------------------------------------------------------------------+
| 海岸は、古来から地域社会において祭りや行事の場として利用され         |
| ており、地域文化の形成や継承に重要な役割を果たしてきた。近年は、人々 |
| のニーズも社会のあらゆる分野で高度化、多様化しており、海岸も、海水浴 |
| 等の利用に加え様々なレジャーやスポーツ、体験活動・学習活動の場及び健 |
| 康増進のための海洋療法や憩いの場などとしての利用がなされてきている。 |
|                                                                      |
| 海岸の利用は基本的には                                               |
| 自由使用であり、自己責任において誰でも利用できるが、海岸は元来自然の |
| 影響を強く受けるために部分的にしか利用されてこなかった。地域の貴重な |
| 資源である海岸の利活用を促進するため、自然条件や海岸の特性、利用形態 |
| に応じ、利用者の安全を確保する対策を講じるとともに、利用に適した海岸 |
| については、沿岸の関係者の適切な役割分担のもと、利用の高度化を図る。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 公衆の海岸の適正な利用の確保は、海岸防護・海岸環境との調和を図り     |
| つつ、海岸の特性、利用形態に応じ安全性、快適性、利便性を確保し、海岸 |
| の有する利用機能の保全・増進を図ることを目的とすることを基本とする。 |
|                                                                      |
| 海岸保全計画においては、海岸における公衆の適正な利用                 |
| を促進するために実施しようとする施策の内容を定めることを基本とする。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

海岸利用に関する基本的な事項については、下記の資料が参考となる。

1.  自然共生型海岸づくり研究会編著：自然共生型海岸づくりの進め方,一般社団法人全国海岸協会,2003.

```{=html}
<!-- -->
```
65. ビーチリゾートの創出に関する技術検討ワーキンググループ：砂浜の利活用の更なる促進に向けて（提言）～地域に根ざし、グローバルに拓けた「ビーチリゾート創出」を目指して～,2019,　https://www.mlit.go.jp/river/kaigan/main/beachresoat/index.html

66. 国土交通省水管理・国土保全局海岸室：海岸利用の活性化に向けたナレッジ集,2024,

    https://www.mlit.go.jp/river/kaigan/index.html

    1.  安全性

＜考え方＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  海岸の利用は基本的には自由使用であり、自己責任において誰でも自由に利用できるが、海岸は極めて厳しい自然環境に置かれており、海浜流や急な高波の来襲や砂浜の変状等により事故が発生している。このため、沿岸関係機関と連携を図り当該海岸が一般の利用に供することが適当であるか検討する必要がある。利用を促進する海岸に整備され、一般の利用に供することを前提とした施設等は、利用者の安全に留意する必要がある。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------
  海岸の特性や利用形態等を踏まえ、一般の利用に供することを前提とした施設等については、利用者の安全に留意することを基本とする。
  ------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  海流、地形などの自然条件や沿岸構造物によって海岸利用に適さない海岸もある。また、高波や津波などによって危険な状態となる場合もある。このため、沿岸関係機関と連携を図り利用の適否に関する協議のほか、一般の利用者に対する注意喚起対策を講じることが望ましい。また、一般の利用に供することを前提とした施設等については、沿岸関係機関と利用者の安全確保に必要な対策を講じるとともに、利用者に対する安全に関する情報提供の充実を図ることが望ましい。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜参考となる資料＞

利用者の安全については、下記の資料が参考となる。

7.  全国農地海岸保全協会・公益社団法人全国漁港漁場協会・一般社団法人全国海岸協会・公益社団法人日本港湾協会：海岸保全施設の技術上の基準・同解説,2018.

    1.  快適性・利便性

＜考え方＞

+----------------------------------------------------------------------+
| 利用機能を高度化するためには利便                                     |
| 施設の設置・改良が必要となる場合がある。海岸の利便施設としては、海岸 |
| までのアクセス、駐車場、トイレ、休憩施設、情報施設などが考えられる。 |
|                                                                      |
| 海岸防護のため                                                       |
| の堤防が海岸へのアクセスを阻害したり、離岸堤や人工リーフにより漁業や |
| サーフィンができなくなるなど、海岸保全施設の整備と利用が相反する場合 |
| も多く見られ、また海岸への自動車等の乗り入れにより、海浜植生や産卵・ |
| 営巣地が破壊されるなど、防護・環境・利用との調和の問題のほか、海水浴 |
| 、サーフィン、ジェットスキー、漁業など利用が輻輳することにより、トラ |
| ブルの発生も見られることから、利用形態に応じた調整を図る必要がある。 |
+----------------------------------------------------------------------+

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------
  海岸の快適性・利便性の検討に当たっては、各海岸での利用形態や、公衆の適正な利用のため規制・誘導等についても考慮することを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------------

＜例　示＞

+----------------------------------------------------------------------+
| 海水浴や                                                             |
| サーフィン、釣りなどのレジャー、地元住民による日常利用など、利用機能 |
| について適切に評価を行う。海岸堤防によって海岸へのアクセスが阻害され |
| ている場合、必要に応じ階段工の設置等によって海岸へのアクセスを確保す |
| ることが望ましい。また、高齢者や障害者等のハンディキャップを持った人 |
| 々が日常生活の中で気楽に海辺に近づき、自然に接することができるように |
| するため、必要に応じてスロープの設置などバリアフリー化にも配慮する。 |
|                                                                      |
| 海岸における流木やプラスチック、レジンペレット等の漂着ゴミ、不法投   |
| 棄や海岸利用者が投棄していくゴミ等は、快適な海岸利用を妨げるため、回 |
| 収に関して関係者の役割分担を明確にするとともに、発生を抑制するために |
| も流域・沿岸域の住民や海岸利用者のモラルの向上を図ることが望ましい。 |
+----------------------------------------------------------------------+

**基本計画編**

2.  **流域における連携と情報の共有**

**目　次**

[第1節 総説 1](#_Toc101358420)

[第2節 災害の防止・軽減に関する連携 1](#_Toc96359324)

> [2．1 総説 1](#_Toc96359325)
>
> [2．2 氾濫をできるだけ防ぐ・減らすための対策 2](#_Toc96359326)
>
> [2．2．1 流域関係者と連携した氾濫をできるだけ防ぐ・減らすための対策
> 2](#_Toc96359327)
>
> [2．2．2 河川管理者等による水防への協力に関する事項 3](#_Toc96359328)
>
> [2．3
> 被害対象を減少させるための対策及び減災のための氾濫形態を制御する対策
> 4](#_Toc96359329)
>
> [2．3．1 土地利用・住まい方の工夫 4](#_Toc96359330)
>
> [2．3．2 遊水機能を有する土地の保全・整備 6](#_Toc96359331)
>
> [2．4 被害の軽減、早期復旧・復興のための対策 7](#_Toc96359332)
>
> [2．4．1 流域との情報の共有に関する事項 7](#_Toc96359333)
>
> [2．4．2 河川管理者等による水防への協力に関する事項 11](#_Toc96359334)

[第3節
河川等の適正な利用及び流水の正常な機能の維持並びに河川環境等の整備と保全に関する連携
13](#_Toc65755149)

> [3．1 河川等の適正な利用及び流水の正常な機能の維持の確保のための連携
> 13](#_Toc103781504)
>
> [3．2 河川環境等の整備と保全に関する連携 15](#_Toc65755151)

[第4節 河川とまちづくりの連携 15](#_Toc62722653)

令和４年６月　版

適用上の位置付け

　河川砂防技術基準計画編は、基準の適用上の位置付けを明確にするために、下表に示すように適用上の位置付けを分類している。

+--------+------------------+------------------+------------------+
| 分　類 | 適用上の位置付け | 末尾の字句例     |                  |
+--------+------------------+------------------+------------------+
| 考え方 | 技術資料         | ●目              | 「･･･ある。      |
|        |                  | 的や概念、考え方 | 」「･･･いる。」  |
|        |                  | を記述した事項。 |                  |
|        |                  |                  | 「･･･なる。      |
|        |                  |                  | 」「･･･れる。」  |
+--------+------------------+------------------+------------------+
| 必　須 | 技術基準         | ●法令による規定  | 「･･･なければ    |
|        |                  | や技術的観点から | ならない。」「･  |
|        |                  | 実施すべきである | ･･ものとする。」 |
|        |                  | ことが明確であり |                  |
|        |                  | 遵守すべき事項。 |                  |
+--------+------------------+------------------+------------------+
| 標　準 | 技術基準         | ●特              | 「･･･            |
|        |                  | 段の事情がない限 | を標準とする。」 |
|        |                  | り記述に従い実施 |                  |
|        |                  | すべきだが、状況 | 「･･･            |
|        |                  | や条件によって一 | を基本とする。」 |
|        |                  | 律に適用すること |                  |
|        |                  | はできない事項。 | 「･･･による。」  |
+--------+------------------+------------------+------------------+
| 推　奨 | 技術資料         | ●状況や条件      | 「               |
|        |                  | によって実施する | ･･･望ましい。」  |
|        |                  | ことが良い事項。 |                  |
|        |                  |                  | 「               |
|        |                  |                  | ･･･推奨する。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･務める。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･必要に応    |
|        |                  |                  | じて･･･する。」  |
+--------+------------------+------------------+------------------+
| 例　示 | 技術資料         | ●適用条件や実施  | 「               |
|        |                  | 効果について確定 | ･･･などの手法（  |
|        |                  | している段階では | 事例）がある。」 |
|        |                  | ないが、状況や条 |                  |
|        |                  | 件によっては導入 | 「･･･など        |
|        |                  | することが可能な | の場合がある。」 |
|        |                  | 新技術等の例示。 |                  |
|        |                  |                  | 「･･･など        |
|        |                  | ●状              | が考えられる。」 |
|        |                  | 況や条件によって |                  |
|        |                  | 限定的に実施でき | 「               |
|        |                  | る技術等の例示。 | ･･･の場合には･･･ |
|        |                  |                  | ことができる。」 |
|        |                  | ●具体的          |                  |
|        |                  | に例示することに | 「               |
|        |                  | より、技術的な理 | ･･･例示する。」  |
|        |                  | 解を助ける事項。 |                  |
|        |                  |                  | 「例えば･･･。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･事例もある  |
|        |                  |                  | 。･･･もよい。」  |
+--------+------------------+------------------+------------------+

  関連通知等       関連する通知やそれを理解する上で参考となる資料
  ---------------- ------------------------------------------------------
  参考となる資料   例示等に示した手法・内容を理解する上で参考となる資料

6.  流域における連携と情報の共有

    1.  []{#_Toc101358420 .anchor}総説

＜考え方＞

+----------------------------------------------------------------------+
| 本章は、災害の防止・軽減、河川等の適正な                             |
| 利用、流水の正常な機能の維持、河川環境等の整備と保全及び河川とまちづ |
| くりに関し、河川管理者等と流域の関係者が連携し、また水・土砂等に関す |
| る様々な情報を収集整備し、共有する取り組みについて示したものである。 |
|                                                                      |
| 第1章に示した基                                                      |
| 本方針の実現には、河川、砂防、海岸の管理者及び事業者（以降、河川管理 |
| 者等という。）が行う対策のみならず、流域の関係者と流域の自然的・社会 |
| 的条件やその変化等の情報を共有し、連携して対策に取り組む必要がある。 |
|                                                                      |
| 災害の防止・軽減については、気候変動による水害や土砂災害             |
| などの激甚化・頻発化などに伴う外力の増大に対し、河川管理者等が行う施 |
| 設整備だけでなく、集水域、河川区域、氾濫域からなる流域のあらゆる関係 |
| 者が協働し、総合的かつ多層的に防災・減災対策に取り組むことが重要であ |
| る。河川管理者等は、本編第2章「河川計画」、第3章「砂防(土砂災害等対  |
| 策)計画」、第4章「海岸保全計画」に基づき実施する対策に加え、流域の関 |
| 係者と緊密に連携した効果的な防災・減災対策を進めることが重要である。 |
|                                                                      |
| 河川管理者等                                                         |
| が行う流域の関係者との連携とは、流域の関係者が主体となり取り組む対策 |
| の実施にあたり必要な、水害や土砂災害の危険度に関する情報（以下、「水 |
| 災害リスク情報」という。）の共有や、災害時に水防活動、住民の避難等の |
| 判断のために発信する情報（以下、「防災情報」という。）の意味などを、 |
| 平時から住民に周知すること、また、災害のおそれがある時には、避難指示 |
| の発令等に資するため、自治体との情報共有を確実に行うことなどがある。 |
|                                                                      |
| 河川等の適正                                                         |
| な利用、流水の正常な機能の維持を確保、河川等における自然環境の保全及 |
| び河川とまちづくりとの連携については、関連する情報を適切に共有すると |
| ともに、地方自治体、関係機関、地域住民のほか河川等に関心を持つ市民や |
| 学識経験者、関係団体等と日常的に情報交換などを行うことが重要である。 |
|                                                                      |
| さらに、水は、すべての生命にとって生きるために不可欠のものであり、   |
| 農業、工業等の産業の持続可能な発展や清潔で健康的な環境の保持等、国民 |
| の豊かで文化的な生活を確保する上で重要な資源である。一方、砂漠化の進 |
| 行、酸性雨の発生、資源として使用できる水の減少、渇水など、水を取り巻 |
| く地球環境が変化し、健全な水循環の維持又は回復の観点から多くの問題も |
| 懸念されており、降水量及び蒸発散、貯留施設の貯水量、流域における取排 |
| 水、地下水及び水質等の水情報を一元的に管理していくことが重要である。 |
+----------------------------------------------------------------------+

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  水・土砂等に関する情報を収集整備し、流域のあらゆる関係者が共有・活用し安全で多様な文化を持つ国土の構築を推進するため、関係住民や流域の関係者と緊密な連携を図ることを基本とする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

6.  []{#_Toc96359324 .anchor}災害の防止・軽減に関する連携

    1.  []{#_Toc96359325 .anchor}総説

＜考え方＞

+----------------------------------------------------------------------+
| 本節は、気候変動の影響による外力の増大や、人口                       |
| 減少、土地利用の変化等の流域の特性を踏まえた防災・減災対策に関する地 |
| 域のあらゆる関係者との連携及び、情報の共有について示したものである。 |
|                                                                      |
| 災害の防止・軽減のためには、「氾濫をできるだけ防ぐ・減ら             |
| すための対策」、「被害対象を減少させるための対策及び減災のための氾濫 |
| 形態を制御する対策」、「被害の軽減・早期復旧・復興のための対策」の３ |
| 要素を総合的かつ多層的に進める「流域治水」に流域一体となって取り組む |
| ことが重要であり、そのためには、流域のあらゆる関係者と連携を図るため |
| の協議の場を設け、実施内容や役割分担を明らかにして進める必要がある。 |
|                                                                      |
| 河川                                                                 |
| 管理者等は、自らが主体となって行う治水対策に加え、市町村や民間企業な |
| ど流域のあらゆる関係者が実施する、集水域や氾濫域等における災害の防止 |
| ・軽減に資する取組が効果的に推進されるよう連携・支援する役割がある。 |
|                                                                      |
| 本章では、第２章「河川                                               |
| 計画」第２節「洪水防御計画に関する基本的事項」に基づく治水対策を除く |
| 流域治水の取組について、河川管理者等が実施すべき技術的事項を定める。 |
|                                                                      |
| ※本節の以降の記載おいて、国、都道府県は、                            |
| 水防法に基づく情報の通知等を行う国土交通大臣、都道府県知事の役割と、 |
| 河川法に基づく河川管理者、都道府県においては海岸法に基づく海岸管理者 |
| の役割を兼ね備えているため、適用法に基づき実施主体を書き分けている。 |
+----------------------------------------------------------------------+

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------
  河川・下水道等の管理者、都道府県、市町村等の流域の関係者からなる協議会において、流域対策を含む対策の全体像を計画し適切に連携することを基本とする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  河川・下水道等の管理者、都道府県、市町村等の流域の関係者からなる協議会において、河川整備、下水道整備等に加え、流域の市町村などが実施する雨水貯留浸透施設の整備や災害危険区域の指定等による土地利用規制・誘導等、都道府県や民間企業等が実施する利水ダムの事前放流等からなる、流域対策を含む対策の全体像を「流域治水プロジェクト」として策定・公表し、流域治水の計画的な推進に向け連携するよう努める。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1.  流域治水プロジェクトの推進について，令和2年6月，水管理・国土保全局．

```{=html}
<!-- -->
```
67. 二級水系における流域治水プロジェクトの推進について　令和2年10月　水管理・国土保全局.

＜参考となる資料＞

流域治水プロジェクトに関しては、以下のサイトが参考になる。

1.  流域治水プロジェクト

> <https://www.mlit.go.jp/river/kasen/ryuiki_pro/index.html>

1.  []{#_Toc96359326 .anchor}氾濫をできるだけ防ぐ・減らすための対策

    1.  []{#_Toc96359327
        .anchor}流域関係者と連携した氾濫をできるだけ防ぐ・減らすための対策

＜考え方＞

+----------------------------------------------------------------------+
| 氾濫をできるだけ防ぐ・減らすため、雨水や流水等を貯留する対策等       |
| を充実させ、流域の特性を踏まえて効果的に組み合わせていく必要がある。 |
|                                                                      |
| 利水ダム等の事前放流や、地方公共団                                   |
| 体や個人・民間企業等による雨水貯留浸透施設の整備、水田等の貯留機能を |
| 有する土地の保全等、関係機関と取組推進に向けた連携を図る必要がある。 |
|                                                                      |
| なお、これらの                                                       |
| 取組の推進には、関係機関等の合意形成が極めて重要であり、これを円滑に |
| 進めるための仕組みについても関係機関が連携し検討していく必要がある。 |
+----------------------------------------------------------------------+

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  既存ダムの有効貯水容量を、洪水調節機能を最大限強化できるよう、国土交通省所管ダム及び河川法第26条の許可を受けて設置された利水ダムを対象に、事前放流を実施することを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1.  既存ダムの洪水調節機能の強化に向けた基本方針，令和元年12月12日,既存ダムの洪水調節機能強化に向けた検討会議.

```{=html}
<!-- -->
```
68. 事前放流ガイドライン，令和2年4月,水管理・国土保全局.

＜推　奨＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  河川管理者等は、地方公共団体、個人・民間等による雨水貯留浸透施設の整備、さらに、既存のため池、水田、今後増加すると予想される耕作放棄地等の活用も含め、その流域の特性に応じて、水災害の防止・軽減効果が期待できる流出抑制等の推進が図られるよう必要に応じて適切に支援する。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

1.  []{#_Toc96359328 .anchor}河川管理者等による水防への協力に関する事項

```{=html}
<!-- -->
```
20. 水防における国、都道府県等の役割

＜考え方＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  水防は治水施設の機能を最大限に活かすとともに、水害被害を軽減するため極めて重要な対策である。水防は第一義的には水防管理団体である市町村（あるいは水防事務組合、水害予防組合）が責務を負っているが、河川・海岸管理者との連携がなければ的確な水防活動を行うことは困難であり、市町村、水防事務組合、水害予防組合と河川・海岸管理者は水防のあらゆる面で緊密な連携を図らなければならない。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜必　須＞

  --------------------------------------------------------------------------------------------------------------------------------------------------
  河川管理者は、当該水防計画に河川管理者の協力が必要な事項が定められたときには、当該水防計画に基づき、水防管理団体が行う水防に協力するものとする。
  --------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1.  水防計画作成の手引き，平成30年2月，国土交通省水管理・国土保全局河川環境課水防企画室

    （最新版）水防計画作成の手引き，令和3年7月，国土交通省水管理・国土保全局河川環境課水防企画室.

```{=html}
<!-- -->
```
21. 水防への協力

＜考え方＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  近年、集中豪雨等による水災害が多発している一方、水防団員の減少等により、国、都道府県あるいは河川管理者の水防活動への協力がより一層重要となってきている。このような現状に鑑み、国、都道府県あるいは河川管理者は、広域的な観点から、都道府県及び指定水防管理団体が定める水防計画の策定の段階から、積極的に参画、協力すべきである。なお、水防計画に記載された協力事項等について、河川管理者の協力が義務付けられることになるが、これ以外についても河川管理者が協力することを排除しているものではなく、河川の総合的な管理を通じて水災の防御を図るという責務が河川管理者にあることを認識しておく必要がある。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜必　須＞

+----------------------------------------------------------------------+
| 河川管理者は、都道府県及び指定                                       |
| 水防管理団体が定める水防計画の作成にあたって、洪水等に際して水防上特 |
| に注意を要する箇所（重要水防箇所）等の河川に関する情報の提供を行う。 |
|                                                                      |
| 水防計                                                               |
| 画は、河川の整備、河道状況の変化等により見直す必要があることから、河 |
| 川管理者はこれらが生じた場合に、随時水防計画の変更を促すものとする。 |
|                                                                      |
| また、河川管理者は、水                                               |
| 防管理者が浸水被害軽減地区の指定をしようとする場合や、市町村が浸水し |
| た地点、その水深その他の状況を把握しようとする場合は、例えば過去の浸 |
| 水情報や周辺の地形情報等に鑑み浸水被害の軽減に有用な盛土構造物等の情 |
| 報を提供すること等必要な情報提供、助言その他の援助を行うものとする。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  水災害の監視・予測の高度化等の推進について，平成21年3月27日，国河情第17－2号，国土交通省河川局長通達.

    1.  []{#_Toc96359329
        .anchor}被害対象を減少させるための対策及び減災のための氾濫形態を制御する対策

＜考え方＞

+----------------------------------------------------------------------+
| 水災害リスクを軽                                                     |
| 減させるためには、氾濫をできるだけ防ぐ・減らすための対策と併せて、氾 |
| 濫が発生することも視野に入れ、ハザードエリアにおける土地利用・住まい |
| 方の工夫といった被害の対象を減少させる対策も併せて講じる必要がある。 |
|                                                                      |
| これらの取組を効果的に実施し                                         |
| ていくためには、河川管理者等は、まちづくりにおける活用を見据えたもの |
| として水災害リスクに関する各種情報を適切に評価し、その情報の充実を図 |
| り、地域にわかりやすく提供し、土地利用・住まい方の工夫の取組の必要性 |
| について合意形成が図られるよう努めるとともに、流域のあらゆる関係者と |
| 協働して、対策を積極的に進めるため、必要に応じ支援を行う必要がある。 |
|                                                                      |
| また、遊水機能                                                       |
| を有する土地の保全・整備等、減災のため氾濫形態を制御するための対策に |
| ついて、河川管理者等は関係機関と協働し必要な支援等を行う必要がある。 |
+----------------------------------------------------------------------+

1.  []{#_Toc96359330 .anchor}土地利用・住まい方の工夫

＜考え方＞

+----------------------------------------------------------------------+
| 昨今の自然災害の頻発化・激甚化や気候                                 |
| 変動による今後の外力の増大を踏まえ、河川整備等による施設だけでは防ぎ |
| きれない事態を具体的に想定し、その水災害リスク情報を社会全体が共有し |
| 、まちづくり・地域づくりとの連携により減災対策に取り組む必要がある。 |
|                                                                      |
| 平成26年、令和2年の                                                  |
| 改正都市再生特別措置法の施行により、立地適正化計画制度が創設され、コ |
| ンパクトシティの取組の本格化に加え、災害ハザードエリアにおける新規立 |
| 地の抑制、移転の促進、防災まちづくりの推進の観点からの総合的な対策等 |
| の災害リスクを勘案した安全でコンパクトなまちづくりが求められている。 |
|                                                                      |
| この水災害リスクを踏まえた防災まちづくりの推進にあたっては、         |
| まちづくり・地域づくりの担当部局と連携し、例えば洪水等による床上浸水 |
| の頻度が高い地域など、水災害リスクの高い地域の情報をわかりやすく提供 |
| することにより、リスクの低い地域への居住や都市機能の誘導を促すことが |
| 重要である。特に、洪水等による浸水が頻発したり、浸水深が大きいなど、 |
| 人命に関するリスクが極めて高い地域については、そのリスクを提示し、建 |
| 築基準法に基づく災害危険区域の指定を進めること等により、建築物の構造 |
| 規制や宅地開発等の抑制、人命を守るための避難場所の確保等が促進される |
| よう促すべきである。リスクの提示にあたっては、従来の情報だけでなく、 |
| まちづくりに利用しやすいような水災害リスク情報を検討する必要がある。 |
|                                                                      |
| また、気候変動の影響により水災害リスクが増                           |
| 加する見込みの中、早期の治水対策が困難な地域においては、一部区域の氾 |
| 濫を前提とし、輪中堤等によるハード整備と土地利用規制等によるソフト対 |
| 策を組み合わせるなど、地域の意向も踏まえながら、土地利用状況を考慮し |
| た治水対策を推進し、流域全体で水災害リスクを軽減していく必要がある。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  水災害リスクを踏まえた防災まちづくりの推進について，令和3年5月28日，国都計第19号、国水計調第3号、国住指第897号,都市局長、水管理・国土保全局長、住宅局長通知.

＜参考となる資料＞

水災害リスクを踏まえた防災まちづくりの推進に関しては、以下の資料が参考になる。

1.  水災害リスクを踏まえた防災まちづくりのガイドライン

<https://www.mlit.go.jp/report/press/content/001406357.pdf>

＜推　奨＞

+----------------------------------------------------------------------+
| 河川整備等による施設の能力を上回る外力に対し、水災害リスクを考慮     |
| したまちづくり・住まい方の工夫により減災を図るために、河川管理者等は |
| まちづくりに係わる関係機関等と水災害リスク情報を共有するよう努める。 |
|                                                                      |
| 河川管理者は、まちづくりに資するとの観点から                         |
| 、水防法に規定されている想定最大規模や治水計画等の目標とする降雨規模 |
| の洪水浸水想定区域のみならず、河川整備計画において目標とする外力規模 |
| や中高頻度の外力規模（例えば1/10、1/30、1/50）の浸水想定や、河川整備 |
| の進捗（5～10年後、整備計画完了後）に応じた浸水想定など、外力規模や  |
| 事業進捗段階を多段的に変化させた浸水想定の作成・周知の推進に努める。 |
|                                                                      |
| また、破堤地点を想定し氾濫域や氾濫範囲を時                           |
| 系列に推定したシナリオベースの水災害リスク情報の活用の促進に努める。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

シナリオベースの水災害リスク情報については、下記のホームページで閲覧できる。

1.  地点別浸水シミュレーション検索システム（浸水ナビ）https://suiboumap.gsi.go.jp　

＜例　示＞

+----------------------------------------------------------------------+
| １）災害危険区域の指定による土地利用規制等                           |
|                                                                      |
| 土地利用状況等を考慮し、連続堤で整備する場合に比して効率的かつ       |
| 効果的であり地域との合意が得られた場合に、一部区域の氾濫を許容するこ |
| とを前提として、輪中堤の築造や河川沿いの小堤の設置などの整備とあわせ |
| て、宅地嵩上げの実施や建築基準法に基づく災害危険区域の指定による土地 |
| 利用規制等による対策を組み合わせた治水対策を実施している事例がある。 |
|                                                                      |
| ２）降雨確率の規模を考慮した市街化編入抑制区域の指定                 |
|                                                                      |
| 10年確率降雨で想定浸水深                                             |
| が50㎝以上の区域を市街化編入抑制区域に指定し公表している事例がある。 |
|                                                                      |
| ３）浸水想定区域を考慮した居住誘導区域の設定                         |
|                                                                      |
| 立地適正化計画の策定にあたり、河川管理者等と市町村の都市             |
| 部局が連携し、河川管理者が提供した水災害リスク情報である浸水深の深い |
| 地域や家屋倒壊等氾濫想定区域等を居住誘導区域から除外した事例がある。 |
|                                                                      |
| ４）地区計画制度を活用した建築規制                                   |
|                                                                      |
| 河川管理者等による施設整備と併せて                                   |
| 、都市計画法の地区計画制度を活用し、建築物の居室の床の高さを河川管理 |
| 者が提供する浸水深以上になるよう規定し、リスクに対処した事例がある。 |
|                                                                      |
| ５）ゼロメートル地帯における「高台まちづくり」                       |
|                                                                      |
| ゼロメートル地帯等において、建築物の上                               |
| 層階での避難スペースの確保、公園の高台化、高規格堤防の整備等により高 |
| 台の拠点を確保し、それらを想定される浸水深よりも高い位置にある道路や |
| 通路等で線的・面的につなぎ、大規模水害時にも命の安全・最低限の避難生 |
| 活水準を確保し、さらには浸水区域外への避難を可能とする「高台まちづく |
| り」を推進している事例がある。なお、「高台まちづくり」は災害時だけで |
| なく、平時においても地域の賑わい空間として機能を発揮するものである。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  立地適正化計画における災害の発生のおそれのある区域の取扱いについて，平成30年10月26日，国都計第89号，国土交通省都市局都市計画課長通知.

```{=html}
<!-- -->
```
69. 安全で豊かな生活を支えるコンパクトなまちづくりの更なる推進を目指して，令和元（2019年）年７月，都市計画基本問題小委員会中間とりまとめ.

＜参考となる資料＞

輪中堤、二線堤、霞堤の事例に関しては、以下のサイトが参考になる。

1.  流域治水プロジェクト　<https://www.mlit.go.jp/river/kasen/ryuiki_pro/index.html>（参考）流域対策についての主な支援制度・対策事例

高台まちづくりに関しては、以下のサイトが参考になる。

70. 災害に強い首都「東京」形成ビジョン

    <https://www.mlit.go.jp/river/shinngikai_blog/renrakukaigi/index.html>

    1.  []{#_Toc96359331 .anchor}遊水機能を有する土地の保全・整備

＜考え方＞

+----------------------------------------------------------------------+
| 氾濫形態を制御する対策として、輪中堤、二線                           |
| 堤、道路の嵩上げ、樹林帯、水防林などによる氾濫の拡大を抑制する機能の |
| 確保や保全について、関係機関と取組推進に向けた連携を図る必要がある。 |
|                                                                      |
| なお、こ                                                             |
| れらの取組の推進には、地域の合意形成が極めて重要であり、これを円滑に |
| 進めるための仕組みについても関係機関が連携し検討していく必要がある。 |
+----------------------------------------------------------------------+

＜推　奨＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  河川管理者等は、保水・遊水機能を有する土地の保全、霞堤、二線堤等の保全・整備と土地利用が一体となった遊水機能の向上により、減災のため効果的に氾濫域の制御が図られるよう、必要に応じて適切に支援する。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜例　示＞

+----------------------------------------------------------------------+
| １）輪中堤、二線堤等の整備                                           |
|                                                                      |
| 　床上浸水被害等の早期解消のため、連続堤ではなく、土地の利用状況を考 |
| 慮し、一部区域の氾濫を許容した輪中堤を整備することにより、輪中堤内の |
| 集落の浸水を回避した事例や、氾濫が発生した場合でも、氾濫流の市街地へ |
| の到達を遅らせるため、道路の嵩上げによる二線堤を整備した事例がある。 |
|                                                                      |
| ２）輪中堤・二線堤等の保全(浸水被害軽減地区の指定)                   |
|                                                                      |
| 洪水浸水想定区域（当該区域に隣接し、又は近接する区域を含み、河川区域 |
| を除く）内で、浸水の拡大を抑制する効用があると認められる輪中堤（盛土 |
| 構造物）を水防管理者が「浸水被害軽減地区」として指定した事例がある。 |
|                                                                      |
| ３）浸水被害軽減地区の指定に関する河川管理者の援助                   |
|                                                                      |
| 浸水被害軽減地区の指                                                 |
| 定に関する河川管理者の援助として、浸水想定区域を基に選定した候補箇所 |
| の提供のほか、過去の浸水情報や周辺の地形情報等に鑑み、浸水被害の軽減 |
| に有用な盛土構造物等の情報を提供することや、河川協力団体に協力を要請 |
| し、地域の水害誌の調査や文献の収集、大学の研究者や地元の研究家、過去 |
| の水害の体験等へのヒアリング等を通じて得られた過去の水害の際に被害の |
| 軽減に有用だった盛土構造物等に関する情報を提供することが想定される。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

輪中堤、二線堤の事例に関しては、以下のサイトが参考になる。

1.  流域治水プロジェクト　<https://www.mlit.go.jp/river/kasen/ryuiki_pro/index.html>（参考）流域対策についての主な支援制度・対策事例

    1.  []{#_Toc96359332 .anchor}被害の軽減、早期復旧・復興のための対策

        1.  []{#_Toc96359333 .anchor}流域との情報の共有に関する事項

＜考え方＞

+----------------------------------------------------------------------+
| > 水害                                                               |
| や土砂災害等による被害の発生が不可避となった場合でも、人的被害を回避 |
| し、社会経済被害を軽減するために、警戒避難体制の整備や排水対策の強化 |
| 、様々な水災害リスク情報や防災情報を的確に提供するとともに、流域のあ |
| らゆる関係者が災害に関する知識と災害への心構えを持ち、平時から備え、 |
| 災害時に的確に行動する社会を実現するような取組を推進する必要がある。 |
| >                                                                    |
| > これらの取組を効果的に実施していくためには、                       |
| 水災害リスクを適切に評価し、各種情報の用途に応じて充実を図り、流域の |
| あらゆる関係者と情報を共有し、連携のもとに積極的に進める必要がある。 |
| >                                                                    |
| > １）人的被害の軽減、避難に関する支援                               |
| >                                                                    |
| > 市町村長は住民に対し避難情報を発令す                               |
| る役割を有する。国、都道府県はそのための判断基準となる河川の水位や氾 |
| 濫の危険度などの防災情報をあらかじめ提供する役割を有し、そのことが市 |
| 町村の水防計画や地域防災計画等に反映されるようにしなければならない。 |
| >                                                                    |
| > 防災情報の提供にあたっては、リアルタイム情                         |
| 報や予測情報を市町村をはじめとした流域の関係者間で迅速かつ的確に共有 |
| するとともに、ウェブサイト等やメディア及び通信事業者等と連携し、住民 |
| 等が災害の状況や危機感を理解しやすいように伝達することが重要である。 |
| >                                                                    |
| > 一方、住民一人一人が災害に対する                                   |
| 危機意識を有していなければ迅速、的確な避難は行えない。このため国、都 |
| 道府県は、災害時のみならず平時から住民等に対して、洪水浸水想定区域、 |
| 土砂災害警戒区域・特別警戒区域、高潮浸水想定区域、津波浸水想定、津波 |
| 災害警戒区域・特別警戒区域、水位情報、氾濫流の到達時間、浸水深、浸水 |
| 継続時間、火山噴火の被害予測等の情報提供や啓発活動を行う必要がある。 |
| >                                                                    |
| > なお、安全な避難場所等への                                         |
| 避難が困難な地域や、住民が逃げ遅れた場合の緊急的な避難先が無いような |
| 地域では、流域の関係者が連携し、水害時に避難可能な高台等の整備や確保 |
| 、民間施設を避難場所として活用しこれを共有することなども有効である。 |
| >                                                                    |
| > また、水災害の                                                     |
| リスクが高い地域にある地下街等及び要配慮者利用施設に対しては、迅速な |
| 洪水予報等の伝達、避難確保計画の作成等の支援を行うことも重要である。 |
| >                                                                    |
| > 浸水想定区域や水害ハザードマップなど平時における                   |
| 水災害リスク情報は、避難に加え、水災害対策を織り込んだまちづくりや施 |
| 設等の浸水対策を講じるにあたって有効であるため、水災害リスク情報をま |
| ちづくり部局にとって分かりやすいものとなるよう工夫し、具体的な対策に |
| 反映されるよう、関係者間でリスクコミュニケーションを図る必要がある。 |
| >                                                                    |
| > ２）経済被害の軽減                                                 |
| >                                                                    |
| > 経済被害を最小化させるためには、流域内の企業等の様                 |
| 々な機関が、水災害リスクを理解し、業務内容、活動の状況、施設の重要度 |
| 等を踏まえ災害の発生をあらかじめ想定し、平時から様々な準備を進めると |
| 共に、訓練を行い、速やかに復旧・復興を進められるよう、BCPの策定等を  |
| 推進していくことが重要である。国、都道府県は、水災害リスク情報等を企 |
| 業等の関係機関と共有し、取組が加速するよう支援することが重要である。 |
| >                                                                    |
| > ３）関係者と連携した早期復旧・復興の体制強化                       |
| >                                                                    |
| > 氾濫等の被害                                                       |
| が発生した場合においても、被害の軽減や迅速な復旧・復興を図るため、平 |
| 時から水災害リスク情報等について流域の関係者で共有しておくこと等によ |
| り、関係者と連携した早期復旧・復興の体制を強化することが重要である。 |
| >                                                                    |
| > 氾濫水を排除する対策として、事前にその計画をたて、氾濫水を早       |
| 期に排水するための排水施設の整備や排水機場等の耐水化、燃料補給等のた |
| めのアクセス路の確保、予備電源や備蓄燃料の確保等を推進することが重要 |
| である。また、氾濫水の排除に寄与する霞堤を保全することも考えられる。 |
| >                                                                    |
| > 排水ポンプ車による排水活動に加え、水防管理者                       |
| 、河川管理者、下水道管理者等の関係者が連携し、既存の排水施設を活用し |
| た氾濫水の排水により、流域全体で浸水の早期解消を推進する必要がある。 |
| >                                                                    |
| > また災害                                                           |
| 後の早期復旧に向けては、国が大規模自然災害に対し、迅速に地方公共団体 |
| 等への支援を行うTEC-FORCE（緊急災害対策派遣隊）の活用も有効である。  |
| >                                                                    |
| > 上記１                                                             |
| ）～３）に共通し、国、都道府県が提供する実況情報、予測情報等について |
| は、その信頼性の確保が重要であり、非常時にも安定して取得・発信可能な |
| 堅牢性と冗長性を確保することが重要である。また、水災害リスクを有する |
| 流域内の関係者に対し、必要な防災情報が的確なタイミングで確実に伝わり |
| 、迅速な避難行動に結びつくよう、常に、その内容や手段等について検討し |
| 、新たなメディアや通信技術の進展に合わせて改善に取り組む必要がある。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| > 国、都                                                             |
| 道府県は、水防法及び土砂災害防止法等に基づき、浸水想定区域、土砂災害 |
| 警戒区域・特別警戒区域、予測情報等を提供することを前提とし、円滑かつ |
| 迅速な避難が確保できるよう、市町村と緊密に連携することを基本とする。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  浸水想定(洪水、内水)の作成等のための想定最大外力の設定手法，平成27年7月，国土交通省水管理・国土保全局．

```{=html}
<!-- -->
```
71. 洪水浸水想定区域図作成マニュアル（第4版），平成27年7月，国土交通省
    水管理・国土保全局 河川環境課 水防企画室，国土技術政策総合研究所
    河川研究部 水害研究室．

72. 内水浸水想定区域図作成マニュアル（案），平成28年4月，国土交通省水管理・国土保全局下水道部

    （最新版）内水浸水想定区域図作成マニュアル（案），令和3年7月，国土交通省水管理・国土保全局下水道部．

73. 高潮浸水想定区域図作成の手引きVer.2.10，令和3年7月，農林水産省農村振興局整備部防災課，水産庁漁港漁場整備部防災漁村課，国土交通省水管理・国土保全局河川環境課，海岸室，港湾局海岸・防災課

    （最新版）高潮浸水想定区域図作成の手引きVer.2.11，令和5年4月，農林水産省農村振興局整備部防災課，水産庁漁港漁場整備部防災漁村課，国土交通省水管理・国土保全局河川環境課，海岸室，港湾局海岸・防災課．

74. 津波浸水想定の設定の手引きVer.2.10，平成31年4月，国土交通省水管理・国土保全局海岸室，国土技術政策総合研究所　河川研究部　海岸研究室

    （最新版）津波浸水想定の設定の手引きVer.2.11，令和5年4月，国土交通省水管理・国土保全局海岸室，国土技術政策総合研究所　河川研究部　海岸研究室.

75. 地下街等に係る避難確保・浸水防止計画作成の手引き（洪水・内水・高潮編），平成29年1月，国土交通省水管理・国土保全局
    河川環境課 水防企画室.

76. 地下街等に係る避難確保計画作成の手引き（津波編），平成29年1月，国土交通省水管理・国土保全局
    河川環境課 水防企画室.

77. 地下街等における浸水防止用設備整備のガイドライン，平成28年8月，国土交通省水管理・国土保全局
    河川環境課 水防企画室.

78. 要配慮者利用施設（医療施設等を除く）に係る避難確保計画作成の手引き（洪水・内水・高潮編），平成29年6月，国土交通省水管理・国土保全局
    河川環境課 水防企画室.

79. 水害・土砂災害に係る要配慮者利用施設における避難計画点検マニュアル，平成29年6月，厚生労働省・国土交通省.

＜推　奨＞

+----------------------------------------------------------------------+
| > １）人的被害の軽減、避難の支援                                     |
| >                                                                    |
| > 洪水                                                               |
| 氾濫の切迫度や危険度を的確に把握出来るよう、水害リスクが高い区域に水 |
| 位計や監視カメラ等の設置を行い、防災情報提供サイト等を通じて、水位情 |
| 報や映像情報等の住民等への提供に努めるとともに、水位計が設置されてい |
| ない区域については、水位計算等により危険度を提供することが望ましい。 |
| >                                                                    |
| > さらに、メディア及び通信事業                                       |
| 者等と連携した防災情報の伝達は住民への周知に有効なため、メディア等の |
| 防災サイトやアプリ、通信事業者による緊急速報メールサービス等を通じた |
| 情報伝達の活用も意識し、河川水位、洪水情報等のデータの配信に努める。 |
| >                                                                    |
| > 災害時に市町村長が                                                 |
| 避難情報を的確に発令できるよう、河川事務所等から市町村長へ直接、河川 |
| の状況を伝える「ホットライン」を構築することが望ましい。なお、平常時 |
| より伝える情報の内容、沿川の危険箇所、河川特性等を予め共有しておき、 |
| 水防活動や避難行動に対する互いの役割等を確認しておくことが望ましい。 |
| >                                                                    |
| > 防災関係機関が、水害時の対応と                                     |
| その実施主体を時系列で整理した「水害対応タイムライン」の作成・活用の |
| 推進に努め、作成後も振り返りにより必要な見直しを行うことが望ましい。 |
| >                                                                    |
| > なお、地震時の避難路・避難場所としての高水敷の利用等について、ハ   |
| ザードごとの河川空間の役割を周知するとともに、必要に応じ整備を行う。 |
| >                                                                    |
| > ２）経済被害の軽減                                                 |
| >                                                                    |
| > 個人や企業が、自ら水災害リスクを軽減す                             |
| る直接的な自己防衛手段としては、宅地の嵩上げ、高床式建築、防水扉、止 |
| 水板の設置、電気施設の浸水対策等がある。ソフト面の対策としては、水害 |
| 保険等に加え、浸水対策を適切に講じている場合に住宅ローン金利や保険料 |
| が割り引かれる金融・保険に関する取組等があり、被災者の速やかな復旧・ |
| 復興への効果が期待される。このような取組が進むよう、河川管理者等は基 |
| 礎となる水災害リスク情報や被害軽減のための取組等の情報提供に努める。 |
| >                                                                    |
| > また、本節２－２及び２－３に基づく流域                             |
| における対策が、経済被害の最小化に実効性のあるものとなるためには、流 |
| 域の関係者が保有する水管理に関する各種情報や、流域治水に資する地形情 |
| 報等を共有し活用できるような仕組みと体制の整備を行うことが望ましい。 |
| >                                                                    |
| > 河川管理者は                                                       |
| 、水防法に規定されている想定最大規模や治水計画等の目標とする降雨規模 |
| の洪水浸水想定区域のみならず、河川整備計画において目標とする外力規模 |
| や中高頻度の外力規模（例えば1/10、1/30、1/50）の浸水想定や、河川整備 |
| の進捗（5～10年後、整備計画完了後）に応じた浸水想定など、外力規模や  |
| 事業進捗段階を多段的に変化させた浸水想定の作成・周知の推進に努める。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  平常時における関係市町村等との防災情報の共有について，平成21年4月10日，国土交通省河川局治水課河川保全企画室長事務連絡．

```{=html}
<!-- -->
```
80. 洪水時における河川管理者から市町村長への直接の情報提供の仕組み（ホットライン）の構築について，平成29年2月6日，国水環保第22号，国土交通省
    水管理・国土保全局 河川環境課長通知．

81. 中小河川におけるホットライン活用ガイドライン，平成29年2月，国土交通省水管理・国土保全局河川環境課．

82. 水害対応タイムラインの今後の進め方について，平成29年4月6日，国水環保第1号，水管理・国土保全局河川環境課長通知

83. 大規模広域豪雨を踏まえた水災害対策のあり方について～複合的な災害にも多層的に備える緊急対策～，平成30年12月，社会資本整備審議会答申．

＜参考となる資料＞

タイムラインの策定に関しては、下記の資料が参考となる。

1.  タイムライン（防災行動
    計画）策定・活用指針（初版），平成28年8月，国土交通省
    水災害に関する防災・減災対策本部 防災行動計画ワーキング・グループ.

＜例　示＞

+----------------------------------------------------------------------+
| > ・避難                                                             |
| に資する情報提供、共有等の取り組みの例示として以下に示すものがある。 |
|                                                                      |
| +-------------------------------+-------------------------------+    |
| | > 事例名称                    | > 事例内容                    |    |
| +===============================+===============================+    |
| | > 水害ハザードマップ作成      | > 平成27年の水防法改          |    |
| |                               | 正により、想定し得る最大規模  |    |
| |                               | の降雨・高潮に対応した浸水想  |    |
| |                               | 定を実施し、市町村はこれに応  |    |
| |                               | じた避難方法等を住民等に適切  |    |
| |                               | に周知するためにハザードマッ  |    |
| |                               | プを作成することが必要となっ  |    |
| |                               | た。また、令和3年の水防法改正 |    |
| |                               | により、浸水想定の対象が住宅  |    |
| |                               | 等の防護対象のある全ての一級  |    |
| |                               | ・二級河川に拡大した。ハザー  |    |
| |                               | ドマップの作成にあたり、河川  |    |
| |                               | 管理者は想定最大規模の降雨・  |    |
| |                               | 高潮に対応した浸水想定区域図  |    |
| |                               | の提供を行うなどにより、市町  |    |
| |                               | 村に対し、必要な情報提供、助  |    |
| |                               | 言その他の援助を行っている。  |    |
| +-------------------------------+-------------------------------+    |
| | > まるごと                    | > 洪水ハ                      |    |
| | まちごとハザードマップの実施  | ザードマップの更なる普及浸透  |    |
| |                               | 、及び住民等の水害に対する危  |    |
| |                               | 機意識の向上と避難場所等の認  |    |
| |                               | 知度の向上を図ることを目的と  |    |
| |                               | して、生活空間である「まちな  |    |
| |                               | か」に浸水深や避難場所等の水  |    |
| |                               | 防災にかかわる各種情報に関す  |    |
| |                               | る看板を設置した事例がある。  |    |
| +-------------------------------+-------------------------------+    |
| | > マイ・タイムライン          | >                             |    |
| |                               |  個人が置かれている状況や居住 |    |
| |                               | 地の水災害リスク情報に応じて  |    |
| |                               | 適切な避難行動がとれるよう住  |    |
| |                               | 民一人一人の防災行動をあらか  |    |
| |                               | じめ定めるマイ・タイムライン  |    |
| |                               | の取組への支援の事例がある。  |    |
| +-------------------------------+-------------------------------+    |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  「水害ハザードマップ作成の手引きについて」（平成28年4月　国土交通省水管理・国土保全局河川環境課水防企画室長）

    （最新版）「水害ハザードマップ作成の手引きについて」（令和5年5月　国土交通省水管理・国土保全局河川環境課水防企画室長）.

```{=html}
<!-- -->
```
84. 「まるごとまちごとハザードマップ実施の手引き」（平成29年6月　国土交通省水管理・国土保全局河川環境課水防企画室長）.

85. 「地域の水害危険性の周知に関するガイドライン」（平成29年3月　
    国土交通省水管理・国土保全局河川環境課河川保全企画室長、水防企画室長）

    （最新版）「地域の水害危険性の周知に関するガイドライン」（平成30年12月　
    国土交通省水管理・国土保全局河川環境課河川保全企画室長、水防企画室長）.

86. 「中小河川における簡易的な水害リスク情報作成の手引き（平成30年12月　国土交通省水管理・国土保全局河川環境課水防企画室　課長補佐）.

87. 小規模河川の氾濫推定図作成の手引き（令和2年6月　国土交通省水管理・国土保全局河川環境課水防企画室、国土技術政策総合研究所河川研究部水害研究室）.

88. マイ・タイムラインかんたん検討ガイド，国土交通省 水管理・国土保全局
    河川環境課水防企画室.

    1.  []{#_Toc96359334
        .anchor}河川管理者等による水防への協力に関する事項

```{=html}
<!-- -->
```
2.  大規模氾濫に備えた連携

＜考え方＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  水防法に基づく洪水予報河川又は水位周知河川については、大規模氾濫減災協議会を設置することにより、国及び地方公共団体、河川管理者、水防管理者等の多様な関係者が密接な連携体制を構築する。これにより、当該地域の水害リスク情報や、各構成員がそれぞれ又は連携して実施している現状の減災に係る取組状況、減災の取組を進めるうえで前提となる河川整備等の状況等について十分に共有を図り、現況施設能力を超える洪水から想定最大規模の降雨による洪水までの氾濫が発生し得る多様な洪水による被害の軽減に資する取組を総合的かつ一体的に推進するものとする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  水防法に基づく洪水予報河川又は水位周知河川については、多様な関係者が連携して洪水氾濫による被害を軽減するため大規模氾濫減災協議会を設置し、当該地域の水害リスク情報、各構成員がそれぞれ連携して実施している減災対策、河川整備状況等の実施状況を共有した上で、ハード・ソフト対策を総合的かつ一体的に推進することを基本とする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  水防法に基づく洪水予報河川又は水位周知河川以外の河川についても、多様な関係者が連携して洪水被害を軽減するためのハード・ソフト対策を総合的かつ一体的に推進することは有効であることから、協議会の取組の対象に含めることが望ましい。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1.  水防法等の一部を改正する法律の施行について，平成29年6月19日，国水政第12号，国土交通省水管理・国土保全局長通達.

```{=html}
<!-- -->
```
89. 水防法第15条の9及び第15条の10に基づく「大規模氾濫減災協議会」の運用について，平成31年3月29日，国水政第94号，国水河計第79号，国水環第180号，国水治第159号，国水防第465号，国水下流第第9号，国水海第144号，国土交通省水管理・国土保全局水政課長，河川計画課長，河川環境課長，治水課長，防災課長，流域管理官，海岸室長通知.

```{=html}
<!-- -->
```
22. 水害への警戒

＜考え方＞

+----------------------------------------------------------------------+
| 国、都道府県は流域面積が大きい河川で、洪水により国民経済上重         |
| 大な損害を生じるおそれがあるもの等として指定した河川について、気象庁 |
| 長官と共同して、洪水のおそれがあると認められるときは、水位又は流量を |
| 、氾濫した後においては水位若しくは流量又は氾濫により浸水する区域及び |
| その水深を示して当該河川の状況を周知しなければならない。この他、洪水 |
| 、高潮により国民経済上重大な損害又は相当な損害が生ずるおそれがある場 |
| 合、洪水特別警戒水位、高潮特別警戒水位を定め、水位が洪水特別警戒水位 |
| 、高潮特別警戒水位に達したときは、その旨を周知しなければならない。ま |
| たこれらの河川等については、洪水、高潮時の円滑かつ迅速な避難を確保し |
| 、又は浸水を防止することにより、水災による被害の軽減を図るため、想定 |
| 最大規模降雨や高潮により当該河川等が氾濫した場合に浸水が想定される区 |
| 域を洪水浸水想定区域、高潮浸水想定区域として指定しなければならない。 |
|                                                                      |
| 特に洪水予報、水位到達情報（水位周知河川                             |
| 、水位周知海岸）については、市町村の避難情報の発令の判断に資するため |
| に通知することとなっており、加えて、住民が自ら行動をとる際の判断に参 |
| 考となる情報（いわゆる「警戒レベル相当情報」）に位置付けられている。 |
|                                                                      |
| また、災害発生時の緊急かつ適切な対応に資するため                     |
| に、「情報伝達の対象事象」「情報伝達の種類、時期、手段、内容及びルー |
| ル」「情報伝達担当者」「伝達ルートの確立」等を定めておく必要がある。 |
|                                                                      |
| これらの情報は、円滑かつ迅速な水防活動や避難行動                     |
| に資するものであり、あらかじめ洪水予測の情報基盤等の整備を図るととも |
| に、常にこれら情報基盤の機能確保や予測の精度向上に努める必要がある。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 国、都道                                                             |
| 府県は、水防法に基づき指定した洪水予報河川、水位周知河川、水位周知海 |
| 岸の水位等の実況情報及び予測情報の通知及び周知、水防警報の通知を適時 |
| 的確に行うとともに、平時からの情報として、洪水予報河川、水位周知河川 |
| 、水位周知海岸等における浸水想定区域を指定・公表しなければならない。 |
|                                                                      |
| また、水防法に基づく                                                 |
| 洪水予報、水位到達情報（水位周知河川、水位周知海岸）の通知等、水防警 |
| 報の通知を適時的確に行うため、雨量、水位などのデータの伝送等の安定性 |
| 確保に努め、必要な洪水予測の情報基盤等の整備を図ることを基本とする。 |
+----------------------------------------------------------------------+

＜推　奨＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  平時からの情報として、洪水予報河川、水位周知河川以外の河川等においても、防護対象があり、円滑・確実な避難体制を確保する必要がある場合には、浸水が想定される範囲などの水害リスク情報を把握、公表することが望ましい。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1.  河川に係る災害発生時の情報伝達マニュアルの改訂について，平成29年3月27日，国水環第35号，水管理・国土保全局河川環境課長通知.

```{=html}
<!-- -->
```
90. 洪水浸水想定区域作成マニュアル（第４版）,平成27年7月,水管理・国土保全局河川環境課水防企画室、国土技術政策総合研究所河川研究部水害研究室.

91. 小規模河川の氾濫推定図作成の手引き，令和2年6月，国土交通省水管理・国土保全局
    河川環境課 水防企画室、国土技術政策総合研究所 河川研究部 水害研究室.

＜例　示＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  国管理河川では、氾濫の危険性をよりきめ細かに伝えるために、河川の縦断水位の推定値と、各断面の堤防高、危険水位等との差を危険度として表示する洪水の危険度分布の情報提供を行っている。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜参考となる資料＞

国管理河川で運用している洪水の危険度分布（水害リスクライン）は、以下のホームページで閲覧できる。

1.  水害リスクライン

　　https://frl.river.go.jp/

23. 国による特定緊急水防活動の実施

＜考え方＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  国は、水災害による著しく激甚な災害が発生した場合において、水防上緊急を要すると認めるときには、当該災害の発生に伴い侵入した水の排除の他、高度の機械力又は高度の専門的知識及び技術を要する特定緊急水防活動を行うこととしている。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  特に水災害による著しく激甚な災害が発生した場合においては、水防上緊急を要すると認めるときには、当該災害の発生に伴い侵入した水の排除の他、高度の機械力又は高度の専門的知識及び技術を要する特定緊急水防活動を国が行うことを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------
  国においては、特定緊急水防活動を円滑に実施できるよう、排水ポンプ車の配置箇所や配置規模、アクセスルート等を予め検討し、排水作業準備計画を作成することが望ましい。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1.  排水作業準備計画作成の手引き，令和2年5月，国土交通省水管理・国土保全局.

    6.  []{#_Toc65755149
        .anchor}河川等の適正な利用及び流水の正常な機能の維持並びに河川環境等の整備と保全に関する連携

        1.  []{#_Toc103781504
            .anchor}河川等の適正な利用及び流水の正常な機能の維持の確保のための連携

＜考え方＞

河川等の適正な利用及び流水の正常な機能の維持を確保するためには、流域での取り組みが必要であり、流域の持つ保水・遊水機能を保全しつつ、将来の開発計画や土地利用を考慮することが重要である。あわせて、流域における適正な役割分担を行い、まちづくりと一体となった貯留・浸透機能の確保等流域での対策を積極的に推進する必要がある。

地方自治体、関係機関、地域住民等との連携を図りつつ、河川等の適正な利用及び流水の正常な機能の維持を確保するため、河川、海岸管理者は河川等に関する情報を発信するとともに、地方自治体、関係機関、地域住民のほか河川に関心を持つ市民や学識経験者、関係団体等と日常的に情報交換などを行うことが重要である。

また、流域での取り組みを推進するためには、各主体が密接な連携のもとに円滑な調整が行えるような仕組みを整備することも重要である。

＜標　準＞

+----------------------------------------------------------------------+
| 河川等の適正な                                                       |
| 利用及び流水の正常な機能の維持を確保するための対策を流域で促進するた |
| め、地方自治体、関係機関、地域住民等との連携を図ることを基本とする。 |
|                                                                      |
| 流域における水利用対策には、雨水浸透対策、貯                         |
| 留対策、雨水利用や下水処理水の再利用及び取排水系統の統廃合等の施設に |
| よる対策、並びに適切な水利用への誘導等の対策があり、これらの対策を、 |
| 流域で効率的かつ効果的に実施するため、地域のニーズを的確に把握し、関 |
| 係機関と十分な調整を図り、適切な役割分担について考慮するものとする。 |
+----------------------------------------------------------------------+

＜例　示＞

河川等の適正な利用及び流水の正常な機能の維持の確保のための連携を推進するための取り組みの主要な事例を以下に示す。

ハード対策

・浸透対策......雨水浸透桝、浸透トレンチ等

・貯留対策......雨水貯留施設等

・再利用.........雨水利用、下水処理水の再利用(雑用水、農業用水、工業用水)等

・取排水系統の統廃合や統合的な運用

・下水道の整備、発生源対策、水源涵養林の保全等

ソフト対策

・適切な水利用......節水(利水者、供給者)、水使用の合理化等

・誘導..................規制、誘導、啓発、教育等

＜関連通知等＞

1.  都市における安全の観点からの雨水貯留浸透の推進について，平成19年３月，国土交通省水管理・国土保全局治水課長.

```{=html}
<!-- -->
```
92. 国及び独立行政法人等が建築物を整備する場合における自らの雨水の利用のための施設の設置に関する目標について，平成27年3月10日閣議決定.

93. 下水処理水の再利用水質基準等マニュアル，平成17年4月,
    国土交通省都市・地域整備局下水道部，国土交通省国土技術政策総合研究所.

    1.  []{#_Toc65755151 .anchor}河川環境等の整備と保全に関する連携

＜考え方＞

自然環境の保全や身近な環境空間としての河川環境等の整備と保全を図るに当たっては、河川全体の自然の営みを視野に入れ、地域の暮らしや歴史・文化との調和にも配慮し、河川が本来有している生物の生息・生育・繁殖環境及び多様な河川景観を保全・創出するために、河川管理を行う必要がある。このため、市民、学識者、関係団体等の理解と協力を得ながら、河川の整備・管理を行っていくことが重要である。

河川は、森林や農地、都市などを連続した空間として結びつける、国土の生態系ネットワークの重要な基軸であり、流域の中にまとまった自然環境を確保している貴重な空間である。生態系ネットワークは、生物多様性、ならびに様々な自然の恵み（生態系サービス）をもたらす。これによって、絶滅の危機にある生物個体群の保全、豊かな水辺環境を通してのやすらぎや潤い、良好な景観の形成、地域独自の産業・文化の発展、ツーリズムの推進など、地域に様々な福利をもたらしている。このため、河川の中だけで多自然づくりを考えるだけでなく、流域へと視点を拡げ、流域の農地や緑地などにおける取組とも連携することにより、河川やこれと連続性を有する水域を基軸とした生態系ネットワークの形成を進めることが重要である。

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  河川等における自然環境の保全や身近な環境空間としての河川環境等の整備と保全のための流域対策や個別箇所での協働を促進するため、地域のニーズや自然環境の現状を的確に把握するとともに、地方自治体、関係機関、河川協力団体、海岸協力団体、地域住民等との連携を図ることを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

＜推　奨＞

河川管理者は、絶えず川に関する情報を発信するとともに、川に関心を持つ市民や学識者、関係団体、関係機関等と日常的に情報交換や意見交換などを行いながら目指すべき川の姿を検討し、河川整備・管理に関する計画を策定することが望ましい。

＜関連通知等＞

1.  多自然川づくり基本方針，平成18年10月，国土交通省河川局

    （最新版）多自然川づくり基本方針，令和6年6月，国土交通省水管理・国土保全局.

```{=html}
<!-- -->
```
94. 提言「持続性ある実践的多自然川づくりに向けて」，平成29年6月，河川法改正２０年
    多自然川づくり推進委員会.

95. 川からはじまる　川から広がる　魅力ある地域づくり　河川を基軸とした生態系ネットワークの形成，平成31年3月，国土交通省水管理・国土保全局河川環境課.\
    （最新版）川からはじまる 川から広がる 魅力ある地域づくり
    河川を基軸とした生態系ネットワークの形成，令和5年3月，国土交通省水管理・国土保全局河川環境課.

    6.  []{#_Toc62722653 .anchor}河川とまちづくりの連携

＜考え方＞

まちづくりの主体である自治体と河川管理者が一体となって、2.3.1に示す災害の軽減のための土地利用、住まい方の工夫のほか、空間、環境、利用等について、河川及び川沿いのまちづくりを考えることが重要である。

まちづくりを行う際には、自然の地形を活かし、河川と沿川地域との空間としての連続性（地形・機能・景観等）を確保することが重要である。一方、河川整備においては、治水機能の確保に併せ、環境機能の向上、適正な河川利用、防災機能の確保を推進する必要がある。

地域の歴史、文化、風土等を踏まえ、沿川地域と調和したまちの賑わいや新しい魅力を創出するための水辺空間を整備することが重要である。

また、地域のにぎわいづくりのために、河川管理者が地方自治体等の行政機関、利用者である地域住民や民間事業者と連携し、河川やその水辺の積極的な活用を図る必要がある。

都市内の河川においては、以下の点に配慮する必要がある。

1.  防災機能の確保

災害時における消火用水、災害後の生活用水等の供給源、延焼遮断帯、避難場所、避難路、緊急時の復旧・復興時の拠点、物資や人の輸送路としての役割等、河川の持つ都市防災機能を増進するよう努める。

2.  都市活動を支える空間

河川及び沿川地域においては、自然環境の保全とのバランスを図りつつ、多様な都市活動が可能となるような適正な河川空間の利用を促進する。

人口や資産が稠密した地域においては、洪水や地震に強く、河川へのアクセスや眺望の確保が容易な高規格堤防の整備と一体となったまちづくりの推進についても考慮する。

> 都市内の陸上交通の緩和、二酸化炭素を始めとする環境負荷の軽減、防災船着き場等と一体となった地域活性化を促進するため、河川舟運の利用を推進する。

＜標　準＞

+----------------------------------------------------------------------+
| 流域の土                                                             |
| 地利用、歴史、文化、風土等を踏まえ、河川の特性を活かしたまちづくり、 |
| 河川を活かした地域交流の場の提供を推進するため、地方自治体、関係機関 |
| 、利用者である地域住民や民間事業者等との連携を図ることを基本とする。 |
|                                                                      |
| なお、特に都市内の河川におい                                         |
| ては、治水機能に加えて、都市の防災機能を確保する空間、身近な環境空間 |
| 、都市活動を支える空間としての多面的役割に配慮することを基本とする。 |
+----------------------------------------------------------------------+

＜推　奨＞

広域的な観点からの河川の計画については、都道府県等が策定する都市計画区域の整備、開発及び保全の方針（「都市計画区域マスタープラン」という。）に、個別の都市との係わりについては、市町村の都市計画の基本方針（「市町村マスタープラン」という。）などに位置付けることにより、整備・利用を推進することが望ましい。

＜関連通知等＞

1.  多自然川づくり基本方針，平成18年10月，国土交通省河川局

    （最新版）多自然川づくり基本方針，令和6年6月，国土交通省水管理・国土保全局.

```{=html}
<!-- -->
```
96. 提言「持続性ある実践的多自然川づくりに向けて」,平成29年6月,河川法改正２０年
    多自然川づくり推進委員会.

97. かわまちづくり支援制度要綱，平成28年2月10日，国土交通省水管理・国土保全局

    （最新版）かわまちづくり支援制度要綱，令和6年4月1日，国土交通省水管理・国土保全局.

98. かわまちづくり計画策定の手引き，令和2年3月，国土交通省水管理・国土保全局

    （最新版）かわまちづくり計画策定の手引き
    第2.1版，令和7年3月，国土交通省水管理・国土保全局河川環境課.

99. 河川敷地の占用許可について，平成28年5月30日，国土交通事務次官通達.

100. 河川敷地占用許可準則の一部改正について，平成23年3月8日，国土交通省河川局.

101. 河川敷地占用許可準則の一部改正について，平成28年5月30日，国土交通省水管理・国土保全局.

102. 河川空間のオープン化活用事例集，国土交通省水管理・国土保全局.
