施設配置等計画編

**第1章　河川環境等の整備と保全及び総合的な土砂管理**

目　次 {#目-次 .TOC-Heading}
======

[第1節 河川環境等の整備と保全 1](#_Toc99561541)

> [1．1 総説 1](#_Toc103791281)
>
> [1．2 河川環境等の特徴の把握 2](#_Toc103791282)
>
> [1．3 河川環境等の整備と保全の目標の設定 3](#_Toc103791283)
>
> [1．3．1 目指すべき方向性の設定 3](#_Toc103791284)
>
> [1．3．2 目標の設定 5](#_Toc103791285)
>
> [1．4 河川環境等の整備と保全の方策 6](#_Toc103791286)

[第2節 総合的な土砂管理 9](#_Toc103791287)

> [2．1 総説 9](#_Toc103791288)
>
> [2．2 土砂管理目標の設定 13](#_Toc103791289)
>
> [2．3 土砂管理対策の策定 14](#_Toc103791290)
>
> [2．4 土砂管理に関するモニタリング・見直し等 17](#_Toc103791291)

令和４年６月　版

適用上の位置付け

　河川砂防技術基準計画編は、基準の適用上の位置付けを明確にするために、下表に示すように適用上の位置付けを分類している。

+--------+------------------+------------------+------------------+
| 分　類 | 適用上の位置付け | 末尾の字句例     |                  |
+--------+------------------+------------------+------------------+
| 考え方 | 技術資料         | ●目              | 「･･･ある。      |
|        |                  | 的や概念、考え方 | 」「･･･いる。」  |
|        |                  | を記述した事項。 |                  |
|        |                  |                  | 「･･･なる。      |
|        |                  |                  | 」「･･･れる。」  |
+--------+------------------+------------------+------------------+
| 必　須 | 技術基準         | ●法令による規定  | 「･･･なければ    |
|        |                  | や技術的観点から | ならない。」「･  |
|        |                  | 実施すべきである | ･･ものとする。」 |
|        |                  | ことが明確であり |                  |
|        |                  | 遵守すべき事項。 |                  |
+--------+------------------+------------------+------------------+
| 標　準 | 技術基準         | ●特              | 「･･･            |
|        |                  | 段の事情がない限 | を標準とする。」 |
|        |                  | り記述に従い実施 |                  |
|        |                  | すべきだが、状況 | 「･･･            |
|        |                  | や条件によって一 | を基本とする。」 |
|        |                  | 律に適用すること |                  |
|        |                  | はできない事項。 | 「･･･による。」  |
+--------+------------------+------------------+------------------+
| 推　奨 | 技術資料         | ●状況や条件      | 「               |
|        |                  | によって実施する | ･･･望ましい。」  |
|        |                  | ことが良い事項。 |                  |
|        |                  |                  | 「               |
|        |                  |                  | ･･･推奨する。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･務める。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･必要に応    |
|        |                  |                  | じて･･･する。」  |
+--------+------------------+------------------+------------------+
| 例　示 | 技術資料         | ●適用条件や実施  | 「               |
|        |                  | 効果について確定 | ･･･などの手法（  |
|        |                  | している段階では | 事例）がある。」 |
|        |                  | ないが、状況や条 |                  |
|        |                  | 件によっては導入 | 「･･･など        |
|        |                  | することが可能な | の場合がある。」 |
|        |                  | 新技術等の例示。 |                  |
|        |                  |                  | 「･･･など        |
|        |                  | ●状              | が考えられる。」 |
|        |                  | 況や条件によって |                  |
|        |                  | 限定的に実施でき | 「               |
|        |                  | る技術等の例示。 | ･･･の場合には･･･ |
|        |                  |                  | ことができる。」 |
|        |                  | ●具体的          |                  |
|        |                  | に例示することに | 「               |
|        |                  | より、技術的な理 | ･･･例示する。」  |
|        |                  | 解を助ける事項。 |                  |
|        |                  |                  | 「例えば･･･。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･事例もある  |
|        |                  |                  | 。･･･もよい。」  |
+--------+------------------+------------------+------------------+

  関連通知等       関連する通知やそれを理解する上で参考となる資料
  ---------------- ------------------------------------------------------
  参考となる資料   例示等に示した手法・内容を理解する上で参考となる資料

1.  河川環境等の整備と保全及び総合的な土砂管理[]{#_Toc99561541 .anchor}

    1.  河川環境等の整備と保全

        1.  []{#_Toc103791281 .anchor}総説

＜考え方＞

河川環境等に関する計画の策定に当たっては、文献調査、現地調査、関係者からのヒアリング等を行い、１．これらの分析から河川・流域等の特性及びそれらの歴史的変遷等の把握、２．河川環境等の整備と保全の目指すべき方向性の設定、３．この方向性と治水・利水面等を総合的に勘案し、河川環境等の整備と保全の目標の設定、４．目標を踏まえた河川環境等の整備と保全の方策の策定、と段階ごとに検討を行う必要がある。

＜必　須＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  河川環境等の整備と保全に関する計画を策定するに当たっては、河川環境等の特徴、流域・沿岸の自然環境や社会環境及びそれらの歴史的な変遷等を把握し、治水・利水機能との整合を図りながら、河川環境等の整備と保全の目標を設定し、それを実現するための方策を策定するものとする。また、この際には、動植物の良好な生息・生育・繁殖環境の保全・創出、良好な景観の保全・創出、人と河川等との豊かな触れ合い活動の場の保全・創出、良好な水質の保全等を総合的に勘案するものとする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜例　示＞

策定の流れを以下に示す。

  ------------------------------------------------------------------
  河川環境等の特徴、流域・沿岸の特性及びそれらの歴史的な変遷の把握
  ------------------------------------------------------------------

　　　　　　　　　　　　　　　　　　↓

  ------------------------------------------------------
  河川環境等の整備と保全の目指すべき方向性と目標の設定
  ------------------------------------------------------

　　　　　　　　　　　　　　　　　　↓

  ------------------------------------
  河川環境等の整備と保全の方策の策定
  ------------------------------------

　　　

河川環境等の整備と保全に関する検討を行うに当たっては、以下の点に留意する必要がある。

１．河川・流域等の特性及びそれらの歴史的な変遷を十分に踏まえ、その川らしさとは何かということについて十分に検討すること。

２．既往文献調査、現地調査、有識者、地元関係者、市民団体等からのヒアリング等を十分に行うこと。

３．調査結果を河川環境情報図（河川環境等に関する情報を適切に把握することを目的として、河床形態や植生の状況、動植物の生息・生育環境、河川環境の特徴等をわかりやすく図面上に整理したもの）等にとりまとめ、河川環境等の特徴を把握すること。

４．「現況の環境を保全するとともにできる限り向上させる」という考え方のもとで、河川全体の俯瞰的な把握を踏まえ、「河川環境管理シート」をツールとして使いながら、河川環境が相対的に良好な場を参考として、河川環境の評価を行うこと。

５．治水・利水上の検討を行った後に環境面に配慮するのではなく、順応的管理の考え方を踏まえ、検討の初期段階より治水面・利水面・環境面から総合的な検討を行うこと。

＜関連通知等＞

1)  中小河川に関する河道計画の技術基準，平成22年8月，国土交通省河川局河川環境課長，治水課長，防災課長.

2)  多自然川づくりポイントブックⅢ　川の営みを活かした川づくり～河道計画の基本から水際部の設計まで～，平成26年6月，多自然川づくり研究会.

3)  実践的な河川環境の評価・改善の手引き（案），平成31年3月，公益財団法人リバーフロント研究所

    （最新版）河川環境管理シートを用いた環境評価の手引き，令和５年７月，国土交通省水管理・国土保全局河川環境課.

4)  河川事業における生態系保全に関する評価の手引き（実務者向け）（案）
    ～生態系ネットワーク形成に向けて～令和３年６月，国土交通省水管理・国土保全局河川環境課.

5)  魚がのぼりやすい川づくりの手引き，平成17年３月、国土交通省河川局.

6)  大河川における多自然川づくり
    －Ｑ＆Ａ形式で理解を深める－，令和２年３月，国土交通省水管理・国土保全局河川環境課

    （最新版）大河川における多自然川づくり
    －Ｑ＆Ａ形式で理解を深める－，令和6年7月一部改訂，国土交通省水管理・国土保全局河川環境課.

7)  河川における外来植物対策の手引き，平成25年12月，国土交通省水管理・国土保全局河川環境課.

8)  河川景観の形成と保全の考え方，平成18年10月，国土交通省河川局.

9)  かわまちづくり計画策定の手引き，令和2年3月，国土交通省水管理・国土保全局河川環境課

    （最新版）かわまちづくり計画策定の手引き
    第２．１版，令和7年3月，国土交通省水管理・国土保全局河川環境課.

10) 河川空間のオープン化活用事例集，国土交通省水管理・国土保全局.

＜参考となる資料＞

多自然川づくりに関する事例は国土交通省水管理・国土保全局の下記のサイトが参考となる。

1)  国土交通省　水管理・国土保全局　全国多自然川づくり会議\
    <https://www.mlit.go.jp/river/kankyo/main/kankyou/tashizen/03.html>

    1.  []{#_Toc103791282 .anchor}河川環境等の特徴の把握

＜考え方＞

１．河川環境等の把握手法

河川環境等の特徴を把握するに当たっては、現況だけではなく、歴史的な変遷も含めて把握する。その際、航空写真・地形図や平面図・縦断図・横断図等を経年的に並べて、みお筋、瀬・淵、河床形態などの河川形状（土砂の移動に対する変化を含む）、河川植生、河川及び周辺の土地利用の状況、流域の状況などの変化について把握する。

収取した情報を分析し、河川を類似した特性（河道特性、自然環境特性、社会環境特性等）を持つ区域に区分し、各区域ごとに、河川環境情報図等にとりまとめ、その川の特徴、その川らしさ、課題などについて整理する。

整理された河川環境情報図等から、「河川環境区分シート」、「代表区間選定シート」、「河川環境経年変化シート」の3
種類のシートから構成される「河川環境管理シート」を作成し、定量的な河川環境の変化を把握する。特に、河川環境経年変化シートは、生息場としての河川形状と河川環境の変化を把握することが出来るため、特に重要な作業シートとなる。

「河川環境区分シート」は、「河川全体の俯瞰的な把握」を踏まえ、河川全体の環境を概観し、河川環境が類似した一連区間（河川環境区分）を区分けするための作業シートである。

「代表区間選定シート」は、上記で区分けした河川環境区分毎に、典型性の観点から良好な場（1km
区間）を、評価や改善にあたって参考とする「代表区間」として選定するための作業シートである。また、あわせて特殊性の観点から重要な場を含む区間も、改変する際に留意すべき「保全区間」として選定する作業シートである。

「河川環境経年変化シート」は、河川水辺の国勢調査において概ね5
年おきに取得される生息場データを用いて、河川環境の経年変化を把握するための作業シートである。

２．水質の把握手法

河川環境等のうち、特に水質に関しては、河川の特性に応じ、現況並びにこれまでの変化の状況整理を行う。整理に当たっては、局所的な特性についても考慮する必要がある。

水質の現況解析を行って、その河川における水質変化のメカニズムの把握及びその原因究明に努める必要がある。

水質に関する現況等の情報をもとに、将来の変化を考慮し、将来における水質を予測するための解析を行う。解析は、対象とする水域の特性、必要とする予測の精度、利用できるデータ等に応じて適切な手法を選択して行う。また、水質には生物や水利用等にとって重要な時期があることから、渇水や低水時のみならず、年間を通じた予測が必要である。

＜標　準＞

+----------------------------------------------------------------------+
| 河                                                                   |
| 川，海岸及び渓流特性、動植物の生息・生育・繁殖環境、河川・海岸及び渓 |
| 流利用の状況、流域・沿岸の自然環境、社会環境及びそれらの歴史的な変遷 |
| 等について、調査を行い、河川環境等の特徴を把握することを基本とする。 |
|                                                                      |
| これらの調査結果                                                     |
| については河川等の全体及び区域ごとに体系的にとりまとめるものとする。 |
+----------------------------------------------------------------------+

2.  []{#_Toc103791283 .anchor}河川環境等の整備と保全の目標の設定

    1.  []{#_Toc103791284 .anchor}目指すべき方向性の設定

＜考え方＞

目指すべき方向性とは、河川環境等の特徴及び流域の特性等の把握の結果を踏まえた、河川環境等の整備と保全の目指すべき方向であり、区域ごとに設定することが重要である。

目指すべき方向性の設定に当たっては、以下の点に留意する必要がある。

・ヒアリングなどによって得られた地域の意見を十分に踏まえる必要がある。

・河川環境等の歴史的な変遷を十分に踏まえる必要がある。

> ・自然環境の観点からは、その川の「もともとの姿」（原風景）が参考となるが、その場合、いつ頃の川の状況を参考とするかが問題となる。日本の川の多くは、古の時代より人々が営々と手を加えてきた結果、その姿が緩やかに変化し、その前提で土地利用がなされてきている。したがって、全く人為の影響がない頃の川の姿を参考にすることは非常に難しい。そこで、近年の大幅な改修が行われる以前で、人為的な影響が比較的少なかったころの「もともとの川の姿」（例えば、高度経済成長期以前の大幅な改修が行われる前の川の河川形状や河川環境等）を参考にすることが考えられる。なお、都市河川の場合は、現状や将来の社会環境に見合った河川環境の創出を方向性として設定する必要がある。
>
> 「もともとの川の姿」を把握する手段としては、昔の地形図や平面図、縦断図、横断図、航空写真、市町村史・郷土史、地元の古老からの聞き取り調査の結果等を参考とす　ることができる。そのほか、対象区域の近傍で、人為的な影響が少なく、良好な河川環境が保たれている場所の川の姿、あるいは、地形、地質、河川形態等の自然環境が類似し、人為的な影響が少なく、良好な河川環境が保たれているほかの川の姿を参考にすることも考えられる。

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  河川環境等の整備と保全の目指すべき方向性の設定に当たっては，河川環境等の特徴及び流域・沿岸の特性等を踏まえ，動植物の良好な生息・生育・繁殖環境の保全・創出，良好な景観の保全・創出，人と河川との豊かな触れ合い活動の場の保全・創出，良好な水質の保全の観点から設定することを基本とする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜例　示＞

１．動植物の良好な生息・生育・繁殖環境の保全の目指すべき方向性の設定

動植物の良好な生息・生育環境の保全・創出については、以下の事項に留意して目指すべき方向性を設定するものとする。

１)その川らしい河川環境の保全・創出

> その川がもともと有していた動植物の生息・生育・繁殖環境を保全・創出することに努める。このため、川の自然の復元力を最大限に活かし、その川がもともと有していた河川形状を保全・創出を図る。また、川の有しているダイナミズムを尊重することも重要である。

２）連続した環境の確保

> 川に生息する動物の中には、川の上下流、本川と支川・水路や池沼、川と川の周辺部、あるいは、海水域と淡水域を行き来して生活しているものもいる。また、水域と陸域の両方を必要とする動物や、植生のある場所を移動経路としているものものいる。このような動物の移動を妨げないようにするため、上下流方向、横断方向の連続した環境を確保するとともに、周辺環境との連続性も確保する必要がある。また、感潮域においては、潮位の変動に伴い、海から上流へ遡上する流れが生じるため、このような場が形成する特徴的な生態系についても考慮する必要がある。

３）その川らしい動植物の生息・生育・繁殖環境の保全・創出

> 学術上又は希少性の観点から重要な種、重要な群落及び注目すべき生息地などの保全・創出を図り、瀬・淵、河原、河畔林、ワンド、湿地など、その川の特徴的な環境に生息・生育・繁殖する動植物に着目することにより、その川らしい動植物の生息・生育・繁殖環境の保全・創出していくことが重要である。

必要に応じ、外来種に対する対応についても整理する。

４）水の循環の確保

> 川の流れは、周辺の地下水と密接な関係があり、地下水位は河川植生の生育などにも影響を与えている。また、川の中の湧水は、清冽で水温もほぼ一定であることが多いため、そこでは本流とは異なった環境が形成され、河川環境の多様性を増す重要な要素ともなっている。したがって、自然な水の流れを遮断しないように、水際部の透水性を確保するなど、水の循環の確保が必要である。

２．良好な景観の保全・創出の目指すべき方向性の設定

良好な景観の保全・創出については、以下の事項に留意して目指すべき方向性を設定する。

> １）河川特有の瀬、淵、河原といった河川形態、水量変動、連続性等のダイナミズムを感じさせる「川らしさ」の尊重

２）適正な構造美を併せ持った「構造物」の妥当性

３）水質の保全

４）河川景観の阻害要因を制限するための施策

> ５）川と地域のまちづくり、街並み等と一体となって地域らしさを感じさせる良好な景観の保全・創出

なお、ここにおける景観とは、名勝や優れた自然的構成要素による主要な眺望景観だけでなく、これ以外の眺めや風景といった近傍の景観も含む。

> 主要な眺望景観については、地域の景観特性、主要な眺望点、景観資源（自然的構成要素）

の状況を踏まえるものとする。

３．人と河川等との豊かな触れ合い活動の場の保全・創出の目指すべき方向性の設定

人と河川等との豊かな触れ合い活動の場の保全・創出については、以下の事項に留意して目指すべき方向性を設定する。

> １）動植物の生息・生育・繁殖環境等を確保するとともに、河川形態、水量・水質等を踏まえる。

２）利用状況やニーズに配慮する。

３）利用者の快適性・安全性に配慮する。

４）河川の有する自然環境を活かした体験活動や環境学習の場であることに配慮する。

５）地域の歴史・文化に配慮する。

４．良好な水質の保全の目指すべき方向の設定

良好な水質の保全については、利水、動植物の生息・生育・繁殖環境の保全、人と河川等との豊かな触れ合い活動の場の確保、景観、生活環境の保全、観光、地下水質の維持等に留意して、目指すべき方向性を設定するとともに、それらを代表できる指標を設定する。

河川及び貯水池・故障等では、一般的にBODやCODが指標として用いられてきたが、河川の特性を踏まえ、必要に応じ以下のような適切な指標を設定する。

> １）利水（水道用水）が重要な要素である場合には、アンモニア、トリハロメタン生成能、２MIB、臭気、塩素イオン等が挙げられる。
>
> ２）動植物の生息・生育環境の保全が重要な要素である場合には、SS,濁度、DO、塩素イオン、水温等が挙げられる。
>
> ３）人と河川との豊かな触れ合い活動の場の確保が重要な要素である場合には、SS,濁度、色度、透視度（透明度）、大腸菌、臭気等が挙げられる。
>
> ４）景観が重要な要素である場合には、SS,濁度、色度、透視度（透明度）等が挙げられる。
>
> ５）内部生産の抑制が重要な要素である場合には、クロロフィル、栄養塩、DO等が挙げられる。
>
> ６）また、アオコを生じさせない、川底が見えるようにするなど定性的な目標を最初に設定し、その実現のためにクロロフィルや透視度といった定量的な指標を目標として設定することは有効な方法である。

2.  []{#_Toc103791285 .anchor}目標の設定

＜考え方＞

水面・利水面・環境面のそれぞれについて、相互のトレードオフ等の関係を総合的に調整したうえで、順応的管理の考え方も踏まえ、具体的な目標を設定する。

なお、河川環境等の整備と保全の目標は上流・下流等河川環境等の特徴に対して区分した区域ごとに設定するものとするが、その際、地域において十分に情報交換や意見交換などを行いながら、目標を検討する必要がある。

動植物の良好な生息・生育・繁殖環境の目標を検討するに際しては、河川環境管理シートを活用する。河川環境を俯瞰して河川環境が相対的に良好な場や重要な要素を含む場を原則保全しつつ、河川環境が相対的に劣っている場を改善することにより河川環境の底上げを図ることが重要である。

水質については、設定した方向性を代表する指標ごとに目標値を設定する。

河川の水質は、自然・人為的要因により縦断的に異なった特性を示すことから、水質保全目各々の区域において検討を行う。

貯水池・湖沼等においても、必要に応じて水域の区分を行って検討を行う。

目標値は、必要に応じて、渇水や水利用の時期及び動植物の生息・生育にとって重要な時期を勘案して設定する。なお、河川の放流先が内湾等の閉鎖性水域の場合には、必要に応じて、広域的な水質保全を考えた目標を検討するものとする。

水質保全目標の設定の際には、流域の関係機関等と調整を図るとともに、環境基準値にも配慮する必要がある。

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  河川環境等の整備と保全の目標は，目指すべき方向性を踏まえ，治水面・利水面・環境面を総合的に調整し，河川環境等の特徴に対応して区分した区域ごとに設定することを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜例　示＞

![](media/image1.png){width="5.622916666666667in" height="3.3in"}

3.  []{#_Toc103791286 .anchor}河川環境等の整備と保全の方策

＜考え方＞

治水・利水・環境の観点及び河川等の平面形、縦断形、横断形、及び植生等を考慮し、複数の検討ケースを設定する。検討ケースごとに、将来の維持管理の水準や樹木等の状況を勘案し、河道形状や粗度係数を設定する。

各ケースについて、将来の河道の状況（河床変動等）や河川環境の状況等を予測し、治水上、利水上の効果と環境への影響等を総合的に評価することが重要である。このため、河川環境等情報図から作成される河川環境管理シートと当該区間の改修内容等を重ねることにより、改修が河川環境等にどのような影響を与えるかについて予測することが重要である。

その影響が重大なものと予測される場合には、計画全体が均衡のとれたものとなるよう、必要に応じ計画案を修正する。

計画策定において、地元住民やその河川等に関わりのある関係者、市民団体等との意見交換、情報交換を密に行うことが望ましい。

＜標　準＞

+----------------------------------------------------------------------+
| 河川環境等の整備と                                                   |
| 保全の目標を達成するため、必要となる方策について策定するものとする。 |
|                                                                      |
| 方策を検討するに当たっては、流域の住民、                             |
| 関係機関等との連携、適切な役割分担について考慮することを基本とする。 |
+----------------------------------------------------------------------+

＜例　示＞

１．動植物の良好な生息・生育・繁殖環境の保全・創出の方策

> 動植物の良好な生息・生育・繁殖環境の保全・創出の方策の策定に当たっての留意事項を以下に示す。

・動植物の良好な生息・生育・繁殖環境をできるだけ改変しない

・多様な河川形状を保全・創出する

・河川における連続した生育環境を確保する

・流域での自然の広がりを考慮する

・注目すべき生物種等の保全を図る

・水の循環を確保する

・川の有しているダイナミズムを確保する

・市民、学識者、関係団体等の理解と協力を得る

　　検討の視点について、具体的な例を以下に示す。

・低水路は平坦な河床を避け、自然な形状の河床となるようにする

・低水路やみお筋の幅は、もともとの川の幅を参考にする

・低水路の横断形は、もともとの川の低水路の横断形を参考にする

・低水路の法線形は、もともとの川の低水路の法線形を参考にして緩やかに蛇行させ

　る

・河床の縦断形は、もともとの川の河床の縦断系を参考にする

・もともとの川に瀬や淵が形成されていた場合には、瀬や淵ができるようにする

・山付き部の淵は、極力保全する

・河岸の入り組み部や湾曲部を保全して、よどみができるようにする

・支川・水路との連続性を確保する

・水際域は、できるだけ固めないようにする

・高水敷（中水敷）の高さは、将来の植生や土砂の堆積状況などを踏まえる

> ・河岸ののり勾配はできるだけ緩くすることが望ましいが、用地等の制約条件が厳しい場合には、河岸ののり勾配をきつくした方が多様な環境を形成できる場合もある

・河畔林はできるだけ保全する

２．良好な景観の保全・創出の方策

良好な景観の保全・創出の方策の策定に当たっての留意事項を以下に示す

・その川の河川景観の特徴との調和を図る

・地域の自然環境と調和を図る

・地域の歴史、伝統・文化との調和を図る

・河川構造物及び許可工作物の外観に配慮する

・良好な河川景観が保全されるよう誘導する

・市民、学識者、関係団体等の理解と協力を得る

検討の視点について、具体的な例を以下に示す。

・河岸・護岸に植物が繁茂し、歴史や自然を感じさせる

・河道が緩やかに蛇行している

・のり肩が曲面で植物が繁茂し、のり肩の線が柔らかい

・高水敷にアイストップとなる木がある

・水際に微妙な入り組みがあり、植物が繁茂している

・瀬・淵や州などにより、流れに平面的な変化がある

・水質が清冽である

・水面幅が広い

・河原をずっと歩くことができ、水辺にもおりやすい

・見通し距離が長い

・山の稜線が連続して見える

・人工物の彩度が低い

・看板、電柱、鉄塔などの景観障害物が目立たない

・河川周辺に、並木やアイストップとなる木、樹木群がある

・河川と一体となった公園がある

・河川沿いに高架道路が連続していない

３．人と河川等との豊かな触れ合い活動の場の保全・創出の方策

> 人と河川等との豊かな触れ合い活動の場の保全・創出の方策の策定に当たっての留意事項を以下に示す

・利用と自然環境との調和を図る

・良好な活動の場を維持する

・水辺へのアクセス性の向上を図る

・利用状況、利用に対するニーズに応じた活動の場を整備する

・地域住民、市民団体等と連携を図る

検討の視点について、具体的な例を以下に示す

・動植物の良好な生息・生育環境に配慮する

> ・利用者（特に、老人、子供、身障者等）が無理のない動作で快適に利用できるよう、構造、材料、仕上げなどに配慮する

・環境学習の場としての活用に配慮する

・地域や河川の歴史・文化を踏まえ、自然素材の活用や大きさ・形などに配慮する

・経済性及び管理の容易性に配慮する

・不特定多数の活動を阻害する行為を制限する

４．良好な水質の保全の方策

> 水質は流域の自然環境や社会環境の影響を大きく受けることから、その保全に当たっては、流域全体での取り組みが求められる。そのため、流域の関係機関の施策と緊密な連携・協議を図り、適切な役割分担を図っていくものとする
>
> 流域の関係機関としては、地方公共団体、地域関係団体等が挙げられ、例えば河川管理者とこれらの機関により、流域ごとに協議会を設置することも有効である。
>
> また、河川管理者及び流域の関係機関が実施する方策には、それぞれ実施できる範囲があるため、必要に応じて調整を図り、方策（役割分担）にフィードバックすることも必要である。
>
> なお、水質保全のための計測は、水質問題が顕在化していない水域においても、流域の将来変化を考慮して策定しておく必要がある。
>
> 河川における水質保全策は、流域の汚濁負荷量分布、河川の水質変化特性、流域対策の効果等を踏まえ、水質保全目標に対して適切に策定するものとする。
>
> 河川における水質保全方策を策定するに当たっては、水質保全目標を達成するのに最も効果的な対策を選定し、水質浄化効果の予測を行って、その結果を役割分担に反映させる必要がある。
>
> 対策の選定に当たっては、浄化対象水質項目の性状、他の水質項目や生態系への影響、維持管理、必要な稼働年数等を考慮する必要がある。
>
> 河川及び貯水池・湖沼等における水質保全対策を機能別にみると次のようになり、これらを適切に組み合わせた水質保全方策を策定する。

・負荷削減

・負荷の分離

・流量の確保

・河川の浄化機能の強化

・水温・流動制御

・その他

> 現況水質と目標水質との乖離、対策実施の技術的、経済的可能性等の点から、水質保全目標を早期に達成することが困難な場合には、必要に応じて段階計画や代替案を検討するものとする。
>
> 水質事故等の以上水質への対応についても、必要に応じて関係機関との連携、情報収集、資器材の準備等、方策の検討を行う。
>
> 流域における水質保全対策は、主に流域の関係機関により計測・実施されることになるが、下流河川の環境への影響等も踏まえ、機能を組み合わせた上で、効果的なものとすることが重要である。
>
> なお、河川管理者が行うことのできる流域における水質保全対策については、第２－４章を参照のこと。

1.  []{#_Toc103791287 .anchor}総合的な土砂管理

    1.  []{#_Toc103791288 .anchor}総説

＜考え方＞

土砂移動に関する課題は、土砂収支バランスが変化することに伴い、山地部、平野部、河口・海岸部等のそれぞれにおいて様々な形で発生している。これらの土砂移動に関する課題を解決するための視点として、個別領域の問題として対策を行うだけでは解決できない場合においては、流域の源頭部から海岸までの一貫した流水等による土砂の運動領域を「流砂系」という概念で捉え、各領域の特性を踏まえつつ、土砂の移動による災害の防止、適切な河川等の整備・管理、海岸侵食の抑制、生態系や景観等の河川・海岸環境の保全、河川・海岸の適正な利活用を通じて、豊かで活力ある社会を実現することなどを目標として、流砂系全体を対象とした総合的な土砂管理に取り組んでいる。なお、土砂の移動については、不連続的に生じるものの、その移動外力は水であり、量と質については降雨、洪水、沿岸流・波浪等の水に係る現象と一体に検討する必要がある。また様々な施設の整備、砂利採取・河道掘削等、人為的なインパクトとその影響についても把握、考慮する必要がある。

本節では、土砂管理目標の設定や土砂管理対策の策定、土砂管理に関するモニタリング、その結果を踏まえた見直し等、総合的な土砂管理を行うにあたって検討すべき基本的な事項を示している。

土砂移動に関する課題を有する砂防・ダム・河川・海岸等の複数領域の関係機関が連携し、検討を行い、実践的に取り組むために総合的な土砂管理の計画（以下「総合土砂管理計画」という。）を策定する。なお、関係機関としては一般的に治山関係部局、ダム関係部局、堰関係部局、砂防関係部局、海岸関係部局、河川関係部局、港湾・漁港関係部局などが考えられる。

なお、土砂動態の実態や土砂管理対策の効果等についてまだ不明確な点も多く、また今後は、気候変動の進行やスーパー台風、南海トラフ地震の発生等に伴う土砂生産の場の大きな変化、洪水や高潮・高波、津波の大きな外力の来襲等により、これまでとは異なる土砂動態の変化も想定されるが、現在の技術的知見では、このような将来の土砂動態の変化を予測することは困難である。このため総合土砂管理計画策定後においては、モニタリングを実施し、その結果を踏まえて土砂管理対策を評価するとともに気候変動や大規模な土砂生産の発生、社会経済情勢の変化等も踏まえ、必要と判断される場合には、同計画の更新・改定を順応的に実施していくことが重要である。

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  総合的な土砂管理を行うにあたっては、関係機関が連携し、砂防・ダム・河川・海岸等のそれぞれの領域において土砂移動の実態把握のための調査・分析を行い、現状と課題を把握する。その上で、当該課題に対し、各領域の個別の対策だけでは解決が困難な場合に、流砂系または土砂移動に関する課題を有する複数領域（以下「流砂系等」という。）において、土砂管理目標を定め、目標を達成できるよう砂防・ダム・河川・海岸等の土砂管理対策メニューを組み合わせ、流砂系等全体としての土砂管理対策を策定することを基本とする。また、土砂管理対策などの効果・影響を把握し、その結果を踏まえて必要に応じ見直すことを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

総合的な土砂管理を行うにあたっては、山地、河道（ダム域含む）、海岸等の特性を踏まえ、生産される土砂の量と質、平常時（中小洪水時を含む）と大規模出水時の通過土砂評価点を通過する土砂の量と質、地形変化速度、河川環境や海岸環境への影響が把握可能となるように、土砂の移動形態および環境への影響に関わる項目を土砂動態の時空間スケールを踏まえながら効率的に調査することが望ましい。このとき、森林が荒廃していた時代は山地部からの流出土砂が多かったこと、一方戦後の森林再生や都市化の進展等により流出土砂が減少したこと、また砂利採取等の人為的インパクトなど、土砂動態と人間活動との関わりについての過去から現在に至る歴史を把握することにも務める。

調査にあたっては、対象とする流砂系等の状況を踏まえつつ、以下の3つの要件の間で適切なバランスが保たれることが望ましい。

1)  対象とする流砂系等の全体像を捉える

2)  課題を生じさせている構図とそこでの流砂系等の関わり方を明らかにする

3)  課題解決のための要素技術の検討を土砂管理の検討に適切に組み合わせる

また、調査・分析等の結果を踏まえ、流砂系等の概要や現状と課題として整理・把握するとともに、理念や目標（土砂管理目標）を定め、その目標を達成するために実施する取り組み項目・内容（土砂管理対策）を総合土砂管理計画として策定することが望ましい。

さらに、土砂動態の実態や土砂管理対策の効果等についてまだ不明確な点も多いことから、総合土砂管理計画の評価及び見直しを行う場合の基礎資料を得るために、適切なモニタリングの計画を策定し、実施するとともに、その結果に基づく評価を行い、必要に応じて総合土砂管理計画を見直すためのフォローアップ体制を定めることが望ましい。

> ＜例　示＞

流砂系等の土砂動態特性や課題を把握するため、領域毎の土砂移動に関する調査の結果等を用いて、流砂系等の土砂収支を土砂動態マップとしてとりまとめており、例えば、相模川流砂系では年代別、粒径集団別の土砂動態マップ、安倍川流砂系では粒径集団別の土砂動態マップ、日野川流砂系では特定の粒径に着目した土砂動態マップを作成した事例がある。

また、総合土砂管理計画の策定手順を以下のフロー図で例示する。

なお、総合土砂管理計画は、調査、対策等の取り組みのレベルに応じて、段階的に計画を策定することができる。例えば、天竜川流砂系や大井川流砂系では流砂系全体ではなく下流域を先行した計画の策定や、那賀川流砂系ではモニタリングを中心とする総合的な土砂管理の取り組みを中間とりまとめとして策定した事例がある。

![](media/image2.png){width="6.298611111111111in"
height="7.756944444444445in"}

＜関連通知等＞

1)  河川砂防技術基準
    調査編,平成26年4月,国土交通省水管理・国土保全局,第16章
    総合的な土砂管理のための調査.

＜参考となる資料＞

総合土砂管理計画の策定については、下記の資料が参考になる。

1)  総合土砂管理計画策定の手引き
    第1.0版,平成31年3月,一般財団法人国土技術研究センター

    （最新版）総合土砂管理の推進と計画策定の手引き
    第2.0版,令和7年3月,（一財）国土技術研究センター.

```{=html}
<!-- -->
```
11) 相模川流砂系総合土砂管理計画,平成27年11月,相模川流砂系総合土砂管理推進協議会.

12) 安倍川総合土砂管理計画,平成25年7月,中部地方整備局.

13) 日野川流砂系の総合土砂管理計画 平成 27 年 3 月
    日野川水系及び皆生海岸 総合土砂管理連絡協議会

    （最新版）日野川流砂系の総合土砂管理計画 令和4 年 3 月
    日野川水系及び皆生海岸 総合土砂管理連絡協議会.

14) 天竜川流砂系総合土砂計画【第一版】,平成30年3月,天竜川流砂系協議会.

15) 大井川流砂系総合土砂管理計画【第一版】,令和2年6月,大井川流砂系協議会.

16) 那賀川の総合土砂管理に向けた取り組み
    中間とりまとめ,平成30年3月,那賀川総合土砂管理検討協議会

    （最新版）那賀川の総合土砂管理に向けた取り組み中間とりまとめ【第２版】,令和6年3月,那賀川総合土砂管理検討協議会.

    1.  []{#_Toc103791289 .anchor}土砂管理目標の設定

        ＜考え方＞

        総合的な土砂管理の目的（土砂の移動による災害の防止、適切な河川等の整備・管理、海岸侵食の抑制、生態系や景観等の河川・海岸環境の保全、河川・海岸の適正な利活用を通じて、豊かで活力ある社会を実現する）を念頭に置きつつ、流砂系等における課題や社会的・歴史的背景を踏まえ、当該流砂系等が目指すべき姿と土砂管理目標を設定する。なお、土砂管理目標等は、関係機関が合意できることが重要である。

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------
  総合的な土砂管理の目的や流砂系等の特性を踏まえ、当該流砂系等が目指すべき姿を設定するとともに、それを実現するために土砂管理目標を設定することを基本とする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

当該流砂系等の目指すべき姿の実現に向けた取り組みを進めるにあたっては、どの年代以降に、流域のどの地点から、どの粒径集団の土砂流送量に変化が現れたかを把握し、それが当該地点より下流河道での河床変動や、河口から海岸への土砂供給量に現れる影響の度合いなどについて大局的に評価し、土砂動態の全体像を具体化することが重要である。このため、観測値や解析モデルを用いた検証・予測計算等により土砂移動量（通過土砂量）を把握し、土砂管理目標を、実効性を高めるために流砂系等全体で共通した指標である通過土砂量を用いた数値目標として設定することが望ましい。しかしながら、調査データの不足や合意形成の困難性などの様々な理由により、目標通過土砂量を設定することが容易ではない場合には、当面、土砂移動量の変化が地形変化に現れるとの認識のもと、河床高や堆砂量、汀線位置等の別途管理可能な土砂管理指標を目標として設定することも考えられる。また、目指すべき姿を踏まえ課題を解決するための方向性等を目標として定性的に定め、段階的に取り組みを進めていくことも考えられる。

＜例　示＞

　目指すべき姿の設定にあたっては、例えば、相模川流砂系においては、昭和30年代前半の相模川をイメージしており、礫河原が多く残っていたこと、砂利採取が盛んでなく本来の河原環境が維持されていたと考えられること、相模ダム竣工後10年経過しているものの相模川周辺海岸の砂浜は維持されていたことなどを具体的なイメージとして設定している事例がある。また、日野川流砂系においては、「可能な限り海岸域への土砂供給を行い、風水害に対して自然豊かな流砂系の実現を目指す。」として目指すべき方向性を設定している事例もある。

　目標通過土砂量の設定にあたっては、各領域を構成する主たる粒径や領域間のつながり等を考慮して、目標通過土砂量を粒径集団ごとに設定することが考えられる。例えば、天竜川流砂系においては、動植物の生息・生育など河川環境の保全・回復のため、特定の粒径集団に着目して目標通過土砂量を設定した事例がある。

　解析モデル等については、山地領域においては、土石流から掃流砂・浮遊砂まで土砂移動形態が変化することから、その特徴に対応した土砂流送が解析可能な手法を用いて検討を行っている事例がある。河道領域（ダム領域を含む）においては、ダム地点等のQ-Qs関係に基づき供給土砂量を設定したり、一次元河床変動モデルを用いて検討を行っている事例がある。また、再堆積しにくい河道断面形状の検討や生物環境への影響検討など、一次元河床変動モデルだけでは十分な検討が行えない場合、平面二次元河床変動計算モデルを用いて検討を行っている事例もある。さらに、流れの解析に非静水圧準三次元解析法を用い、土砂移動の解析に石礫を含む広い粒度分布の河床材料を考慮した掃流砂と浮遊砂の非平衡流砂運動式を適用して検討を行っている事例もある。海岸領域においては、沿岸漂砂量式が組み込まれた海岸線変化モデル（汀線変化モデル、等深線変化モデル）、もしくは局所漂砂量式が組み込まれた三次元海浜変形モデルを用いて検討を行っている事例があり、前者は海浜流計算を必要としないなど計算量が比較的小さいことから長期間あるいは広範囲の計算に多用され、後者は波浪や海浜流の平面場に応じた地形変化を計算できることから構造物周辺の地形変化を計算するのに適している。

＜関連通知等＞

1)  河川砂防技術基準
    調査編,平成26年4月,国土交通省水管理・国土保全局,第6章河床変動、河床材料変化及び土砂流送の解析.

```{=html}
<!-- -->
```
17) 河川砂防技術基準
    調査編,平成26年4月,国土交通省水管理・国土保全局,第21章海岸調査.

＜参考となる資料＞

土砂管理目標の設定については、下記の資料が参考になる。

1)  総合土砂管理計画策定の手引き
    第1.0版,平成31年3月,一般財団法人国土技術研究センター

    （最新版）総合土砂管理の推進と計画策定の手引き
    第2.0版,令和7年3月,（一財）国土技術研究センター.

```{=html}
<!-- -->
```
18) 相模川流砂系総合土砂管理計画,平成27年11月,相模川流砂系総合土砂管理推進協議会.

19) 日野川流砂系の総合土砂管理計画 平成 27 年 3 月
    日野川水系及び皆生海岸 総合土砂管理連絡協議会

    （最新版）日野川流砂系の総合土砂管理計画 令和4 年 3 月
    日野川水系及び皆生海岸 総合土砂管理連絡協議会.

20) 天竜川流砂系総合土砂計画【第一版】,平成30年3月,天竜川流砂系協議会.

21) 藤田光一、宇多高明、服部敦：水系土砂収支分析のための「有効粒径集団」の考え方の提案,土木技術資料,平成7年12月号,pp.34-39,1995.

22) 蒲原潤一、内田太郎、丹羽諭、松本直樹、桜井亘：豪雨時の土砂生産をともなう土砂動態解析に関する留意点,国土技術政策総合研究所資料,第874号,2015.

23) 日本大ダム会議土砂管理分科会,分科会報告　技術委員会「土砂管理分科会報告－貯水池の土砂動態と土砂制御工法－」,第3章,大ダム会議会誌,第212号,2010.

24) 森本有祐、竹村吉晴、福岡捷二、立松明憲：安倍川洪水における掃流砂と浮遊砂の非平衡運動による網状流路の発達,土木学会論文集B1(水工学)Vol.77,No.2,pp.I\_757-I\_762,2021.

    1.  []{#_Toc103791290 .anchor}土砂管理対策の策定

        ＜考え方＞

土砂管理対策の検討にあたっては、他流砂系での実施例や研究事例、水系の特性、排砂方法、対象とする粒径集団等を考慮して、個別領域において土砂管理対策メニューを抽出し、関係機関等の意見も聴取した上で、実現性、コスト、効果、実施工程、環境面への影響、社会的影響などの点から流砂系等全体として総合的に評価し、望ましい土砂管理対策を決定する。また、対策の規模や効果発現までの所要見込時間等を踏まえて、目標の実現可能性を確認する。

なお、望ましい土砂管理対策の決定にあたっては、異なる領域で連携し、土砂管理対策メニューを組み合わせることによって、より対策効果の発揮が見込まれる場合やコストダウンにつながる場合があることを認識して進めることが重要である。

＜標　準＞

+----------------------------------------------------------------------+
| 土砂管理目標を達成するため、個別領域における土砂管理                 |
| 対策メニューを抽出した上で、各領域の土砂管理対策メニューを組み合わせ |
| 、流砂系等全体として目標を達成できるように策定することを基本とする。 |
|                                                                      |
| なお、土砂管理対策については、各領域における計画（河川法に基づく河   |
| 川整備基本方針や河川整備計画、海岸法に基づく海岸保全基本計画、砂防基 |
| 本計画、砂利採取など）に定められた対策と整合をとることを基本とする。 |
+----------------------------------------------------------------------+

＜例　示＞

土砂管理対策は、以下の個別領域等における対策メニューを組み合わせて策定することなどが考えられる。

１．砂防

> 土砂災害を防止・軽減するためのハード対策については、主に短期土砂・流木流出対策により有害な土砂・流木を捕捉するとともに、地形・地質等流砂系の状況、砂防設備に求められる機能、下流への保全対象等への影響、流下させる必要がある土砂の量、質（粒径）の観点から総合的に検討を行い、主に中期、長期土砂流出対策により山腹及び渓床・渓岸における土砂の生産抑制、下流への土砂の流送制御を行う。土砂を下流に供給できる砂防設備としては、透過型砂防堰堤、シャッター砂防堰堤等が考えられる。

２．ダム

> ダムの所期の目的を損なうことなく、ダムから土砂を排出し、適正に下流に土砂を流すための対策を検討する。具体的な対策としては、掘削・浚渫したダム堆積土砂の置き土や土砂バイパス、フラッシング･スルーシング等の複数工法が存在する。工法の選定に当たっては、貯水池の特性を踏まえた適用性、工法に要求される適用に当たっての制約条件、及び社会･自然環境への影響や経済性、各工法の排砂能力等を勘案して選定することが必要となる。

３．河川

> 河川整備計画における河道計画に関しては、流下能力の確保、堤防等の河川管理施設の安全性の確保、河川環境の整備と保全、河川の適正な利用、維持管理、経済性等を総合的に検討することが重要であり、このとき土砂管理対策については、以下に記載の河道掘削、河川構造物の維持管理、砂利採取について特に留意する必要がある。

１）河道掘削

> 　洪水時の水位を低下させるために河道掘削を行うにあたっては、再堆積の可能性について留意するとともに、掘削土砂について河床低下が著しい河川や養浜が必要な海岸へ活用するなど、有効利用について検討する。

２）河川構造物の維持管理

> 河床低下により安全性が低下している河川横断構造物等については、取付け護岸や護床工の補強対策を必要に応じて講ずる。また、河川横断構造物等の上流側に土砂が堆積している場合は、その下流への土砂の供給について検討する。
>
> また、土砂移動に関する課題を抱える利水ダムや取水堰などの許可工作物については、当該施設の管理者に対し、総合的な土砂管理に関する検討委員会等への参加を働きかけることが考えられる。

３）砂利採取

> 河積が十分に確保されている河川において、今後大量の土砂供給が期待されていない場合は、砂利採取は河床の過剰な低下や環境への悪影響を与えるので禁止すべきである。堆積傾向にある河川では、治水、利水、環境保全上支障を生じないと認められる場合において、河道及び海岸の維持と砂利供給を調整しつつ、砂利の計画的採取を適切に実施することが重要である。

４．海岸

> 海岸侵食は、土砂の供給と流出のバランスが崩れることによって発生するため、海岸地形のモニタリングを行いつつ、河川等から海岸への供給土砂量の減少、防波堤や導流堤等の構造物等による沿岸漂砂の連続性の阻害、航路等の浚渫・砂利採取や沖合への土砂流出等の侵食原因などについて検討し、海岸侵食のメカニズムを解明するとともに、侵食防止のために必要な供給土砂量を把握する。その上で、沿岸漂砂等による土砂の収支が適切となるよう離岸堤、人工リーフ等の構造物の工夫等を含む取り組みを進めるとともに、航路等の浚渫土砂や河道等の掘削土砂の養浜材への活用、ダムにおける排砂や砂防による土砂の流送制御等により、海岸部への適切な土砂供給が図られるよう関係機関と連携した取り組みも進める。

５．土砂の有効活用

> ダム、床止め等の河川管理施設又は砂防堰堤、遊砂地等の砂防設備等に堆積した土砂について、施設等の目的や機能を損なわない範囲で除去・搬出し、下流側に置き土を行うなどにより、養浜が必要な海岸あるいは河床低下が著しい河川等の対策に活用する。また、河道掘削等により生じた土砂についても、養浜が必要な海岸あるいは河床低下が著しい河川等の対策に活用する。

**　**また、流砂系等として目標を達成できるよう、土砂管理目標として設定した通過土砂量を踏まえ、土砂管理対策メニューを組み合わせて策定した以下の事例がある。

　安倍川流砂系：土砂生産域では大規模な土砂流出を抑制するための砂防施設の整備、河道領域では洪水時の水位を低下させるための河道掘削、海岸領域では海岸侵食対策として養浜などの対策を策定

　天竜川流砂系：ダム領域では貯水池内の堆積土砂を下流河川へ土砂還元、河道領域では河床維持のための河道掘削、海岸領域では海岸侵食対策として河道領域の掘削土砂等を活用した養浜などの対策を策定

　日野川流砂系：土砂生産域では大規模な土砂流出を抑制するとともに下流へ土砂を流出させる透過型砂防堰堤等の設置、ダム領域では貯水池内の堆積土砂を下流河川へ土砂還元、河道領域では洪水時の水位を低下させるための河道掘削、海岸領域では海岸侵食対策として養浜などの対策を策定

　さらに、山地、河道（ダム領域を含む）、海岸等は、降雨、洪水、沿岸流・波浪等の作用、土砂移動、植物の繁茂等によって様々に変化するものであることから、土砂管理対策に関する施設や河道等の設計にあたっては、土砂供給の長期的な変化や変動についても考慮することが考えられる。

＜参考となる資料＞

土砂管理対策の策定については、下記の資料が参考になる。

1)  総合土砂管理計画策定の手引き
    第1.0版,平成31年3月,一般財団法人国土技術研究センター

    （最新版）総合土砂管理の推進と計画策定の手引き
    第2.0版,令和7年3月,（一財）国土技術研究センター.

```{=html}
<!-- -->
```
25) ダム貯水池土砂管理の手引き（案）,平成30年3月,国土交通省水管理・国土保全局
    河川環境課.

26) 下流河川土砂還元マニュアル（案）,平成23年3月,国土交通省河川局河川環境課.

27) 海岸保全施設の技術上の基準・同解説,平成30年8月,全国農地海岸保全協会､公益社団法人全国漁港漁場協会､一般社団法人全国海岸協会､公益社団法人日本港湾協会.

28) 安倍川総合土砂管理計画,平成25年7月,中部地方整備局.

29) 天竜川流砂系総合土砂計画【第一版】,平成30年3月,天竜川流砂系協議会.

30) 日野川流砂系の総合土砂管理計画 平成 27 年 3 月
    日野川水系及び皆生海岸 総合土砂管理連絡協議会

    （最新版）日野川流砂系の総合土砂管理計画 令和4 年 3 月
    日野川水系及び皆生海岸 総合土砂管理連絡協議会.

    1.  []{#_Toc103791291 .anchor}土砂管理に関するモニタリング・見直し等

        ＜考え方＞

土砂管理に関するモニタリングの目的は、土砂管理対策などの評価及び見直しを行う場合の基礎資料を得ることである。

総合土砂管理計画策定時には、流砂系等の土砂動態をすべて解明できない場合が多く、土砂管理対策を実施しつつ引き続き実態解明に努める必要がある一方で、土砂管理対策後の効果・影響を把握することが重要となってくる。

このため、モニタリングは、総合土砂管理計画策定のために実施した調査を継続的に実施するとともに、必要に応じて、新たに実施する対策の効果・影響の把握や、計画策定時の調査では不十分であった事項の把握（シミュレーションモデルの精度向上のためなど）のために必要な調査（項目、箇所数、頻度等）を追加実施することが重要である。

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  土砂管理に関するモニタリングを行い、土砂管理目標の達成状況や土砂管理対策の効果・影響などについて評価を行うことを基本とする。また、その評価を踏まえ、必要に応じて総合的な土砂管理の取組内容等の見直しを行うことを基本とする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

土砂管理に関するモニタリングや、総合土砂管理計画等の評価を行い、必要に応じて計画を見直すためには、実施体制の中にフォローアップ体制を組み入れておくことが望ましい。

＜例　示＞

モニタリングの実施にあたっては、「対策の効果・影響の監視」、「土砂動態の実態把握、検証データの取得」等のようにモニタリング目的を明確にすることが有効である。

また、流砂系等におけるモニタリング項目・規模が膨大になる場合、項目や数量を限定した「最低限実施するモニタリング計画」等を作成することも、実現性・継続性の観点からは有効である。

例えば、安倍川流砂系においては、総合土砂管理計画策定の翌年より「安倍川総合土砂管理計画フォローアップ委員会」を設置し、継続的にモニタリングを実施しており、また那賀川流砂系においては、土砂動態の解明のためモニタリングの実施内容を定め、順応的に土砂管理を推進している。

＜関連通知等＞

1)  河川砂防技術基準
    調査編,平成26年4月,国土交通省水管理・国土保全局,第16章総合的な土砂管理のための調査.

＜参考となる資料＞

土砂管理に関するモニタリング・見直し等については、下記の資料が参考になる。

1)  総合土砂管理計画策定の手引き
    第1.0版,平成31年3月,一般財団法人国土技術研究センター

    （最新版）総合土砂管理の推進と計画策定の手引き
    第2.0版,令和7年3月,（一財）国土技術研究センター.

```{=html}
<!-- -->
```
31) 安倍川総合土砂管理計画,平成25年7月,中部地方整備局.

32) 那賀川の総合土砂管理に向けた取り組み
    中間とりまとめ,平成30年3月,那賀川総合土砂管理検討協議会

    （最新版）那賀川の総合土砂管理に向けた取り組み中間とりまとめ【第２版】,令和6年3月,那賀川総合土砂管理検討協議会.

 {#section .TOC-Heading}

施設配置等計画編 {#施設配置等計画編 .TOC-Heading}
================

第2章　河川管理施設配置計画 {#第2章-河川管理施設配置計画 .TOC-Heading}
===========================

**第2-1章 河道並びに河川構造物**

**第1節 河道計画**

目　次 {#目-次-1 .TOC-Heading}
======

[第1節 河道計画 1](#_Toc497347257)

[1．1 総説 1](#_Toc508902373)

[1．2 河道計画策定の基本 1](#_Toc497347259)

[1．2．1 河道計画策定の基本 1](#_Toc497347260)

[1．2．2 河道計画検討の基本的な流れ 2](#_Toc497347261)

[1．2．3 河道計画の検討に用いる水理解析 4](#_Toc497347262)

[1．3 現況河道の評価 5](#_Toc497347263)

[1．4 計画高水位 7](#_Toc497347264)

[1．4．1 計画高水位設定の基本 7](#_Toc497347265)

[1．4．2 本川の背水区間内における支川の計画高水位 9](#_Toc508054552)

[1．4．3 河口部の計画高水位 9](#_Toc497347267)

[1．5 河道の平面形、縦横断形の基本 10](#_Toc497347268)

[1．5．1 河道の平面形 10](#_Toc497347269)

[1．5．2 河道の縦断形 11](#_Toc497347271)

[1．5．3 河道の横断形 13](#_Toc497347272)

[1．5．4 支川の合流点形状 16](#_Toc497347270)

[1．5．5 堤防に沿って設置する樹林帯 16](#_Toc497347273)

[1．6 河道の制御施設の計画 17](#_Toc497347274)

[1．6．1 河道の制御施設計画の基本 17](#_Toc497347275)

[1．6．2 堤防の計画 17](#_Toc508054562)

[1．6．3 護岸の計画 18](#_Toc497347276)

[1．6．4 水制の計画 19](#_Toc497347277)

[1．6．5 床止めの計画 19](#_Toc497347278)

[1．7 河口部の計画 20](#_Toc497347279)

[1．7．1 河口部の計画の基本 20](#_Toc497347280)

[1．7．2 河口部における課題への対応方法の選定 21](#_Toc497347282)

[1．7．3 河口部における課題への主な対応方法 22](#_Toc497347283)

[1．8 河道計画と維持管理 25](#_Toc497347284)

[1．8．1 維持管理を見据えた河道計画の検討 25](#_Toc497347285)

[1．8．2 河道の変動特性の維持管理への反映 26](#_Toc497347286)

[1．8．3 維持管理を踏まえた河道計画の見直し 27](#_Toc497347287)

平成30年３月　版

2.  

```{=html}
<!-- -->
```
2.  河川管理施設配置計画

    2.  第2-1章 河道並びに河川構造物

        []{#_Toc497347257 .anchor}河道計画

        1.  []{#_Toc508902373 .anchor}総説

＜考え方＞

+----------------------------------------------------------------------+
| 河川整備の実施に当た                                                 |
| っては、河川整備基本方針及び河川整備計画を策定することが必要となる。 |
|                                                                      |
| 河川整備基本方針は、当該河川において将                               |
| 来的に達成すべき目標を定めるものであり、河川整備の基本となるべき事項 |
| として、基本高水並びにその河道及び洪水調節施設への配分、主要な地点に |
| おける計画高水流量、主要な地点における計画高水位及び計画横断形に係る |
| 川幅に関する事項等を定めるものである。河川整備基本方針における河道計 |
| 画としては、計画高水流量を流下させることができるよう、主要な地点にお |
| ける計画高水位及び計画横断形に係る川幅等を検討し、定めることとなる。 |
|                                                                      |
| 河川整備計画は、河川                                                 |
| 整備基本方針に定められた内容に沿って段階的に一連の河川整備の効果を発 |
| 現させるため、河川整備の段階に応じて目標とする洪水流量に対する被害の |
| 防止又は軽減、河川環境の整備と保全、河川の適正な利用等が図られるよう |
| 具体的な整備内容を定めるものである。河川整備計画における河道計画とし |
| ては、目標とする洪水流量のうち河道への配分流量に対する被害の防止又は |
| 軽減等が図られるよう、主要な地点以外における計画高水位のほか、河道の |
| 法線、川幅、河床高、河床勾配等の河道の平面形や縦横断形、河道の制御施 |
| 設、堰、樋門、水門等の河川構造物の配置等を検討し、定めることとなる。 |
|                                                                      |
| さらに、実際の河道整備の実施に際しては                               |
| 、河川整備計画に定められた内容に沿って、河道の平面形や縦横断形、河川 |
| 構造物の配置や構造等について、より詳細に検討・設計を行うこととなる。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 1.  河道の定義                                                       |
|                                                                      |
| ```{=html}                                                           |
| <!-- -->                                                             |
| ```                                                                  |
| 33) 河道とは、河川の流水が流下する土地空間をいい、通常は             |
| 堤防又は河岸と河床で囲まれた部分を指す。また、河道は様々に変化するも |
| のであり、流水に伴って土砂そのほかの流下物をも流下させるものである。 |
|                                                                      |
| ```{=html}                                                           |
| <!-- -->                                                             |
| ```                                                                  |
| 2.  河道計画の定義                                                   |
|                                                                      |
| ```{=html}                                                           |
| <!-- -->                                                             |
| ```                                                                  |
| 34) 河道計画は                                                       |
| 、河川整備基本方針や河川整備計画の策定・変更等に当たって、計画高水位 |
| 、河道の平面形、縦横断形、床止め・護岸・水制等河道を制御する河川構造 |
| 物の配置等に関する事項のうち、必要な事項を検討し、定めるものである。 |
+----------------------------------------------------------------------+

1.  []{#_Toc497347259 .anchor}河道計画策定の基本

    1.  []{#_Toc497347260 .anchor}河道計画策定の基本

＜考え方＞

+----------------------------------------------------------------------+
| 河川整備基本方針の策定                                               |
| における河道計画の検討では、主要な地点における計画高水位及び計画高水 |
| 流量を流下させることができる計画横断形に係る川幅等について検討する。 |
|                                                                      |
| 河川整備は段階的に実施するも                                         |
| のであり、河道の平面形・縦横断形の概略設定及び河道制御施設の配置に関 |
| する河道計画については、河川整備計画の策定や変更等に際して策定する。 |
|                                                                      |
| 特に、河川整備計画における河道計画の策定に当たっては、流下能力の     |
| 確保、堤防等の河川管理施設の安全性の確保、河川環境の整備と保全、河川 |
| の適正な利用、維持管理、経済性等を総合的に検討することが重要となる。 |
|                                                                      |
| その際                                                               |
| 、川づくりの基本である「多自然川づくり」の考え方を踏まえ、河川全体の |
| 自然の営みを視野に入れ、地域の暮らしや歴史・文化との調和にも配慮し、 |
| 河川が本来有している生物の生息・生育・繁殖環境及び多様な河川景観の保 |
| 全・創出が図られるように河道計画の検討・策定を行うことが重要である。 |
|                                                                      |
| また、河道は、流水の作用、                                           |
| 土砂移動、植物の繁茂等によって様々に変化するものであることから、土砂 |
| 流送特性や河床の変動、長期的な機能の維持についても考慮することが重要 |
| であり、特に土砂移動の顕著な河川ではこの点に十分留意する必要がある。 |
|                                                                      |
| なお、河道整備の                                                     |
| 実施段階で生じた課題、維持管理を通して明らかとなった課題、段階整備の |
| 目標を上回る洪水の発生、その他の河道計画策定時からの河川の状況の変化 |
| 等を踏まえ、適宜、河道計画の見直しを行うことにも留意する必要がある。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1)  河川整備計画の点検及び変更について，平成25年2月25日，国土交通省水管理・国土保全局河川計画課河川計画調整室長事務連絡.

2)  [「多自然川づくり」の推進について](http://www.mlit.go.jp/notice/noticedata/pdf/200704/00004847.pdf)，平成18年10月13日，国河環第38号，国河治第86号，国河防第370号，国土交通省河川局長通達.

＜標　準＞

+----------------------------------------------------------------------+
| 河道計画は、多自然川                                                 |
| づくりを基本として、河川全体の自然の営みを視野に入れ、地域の暮らしや |
| 歴史・文化との調和に配慮するとともに、土砂流送特性や長期的な機能の維 |
| 持についても配慮し、河川整備の段階に応じて目標とする河道配分流量に対 |
| する被害の防止又は軽減、河川が本来有している自然環境や多様な景観の保 |
| 全・創出、河川の適正な利用等が図られるよう策定することを基本とする。 |
|                                                                      |
| また、計画策定に当                                                   |
| たっては、総合的な土砂管理についても必要に応じて配慮するものとする。 |
+----------------------------------------------------------------------+

1.  []{#_Toc497347261 .anchor}河道計画検討の基本的な流れ

＜考え方＞

+----------------------------------------------------------------------+
| 河道計画は基本計                                                     |
| 画編第1章基本方針で定める目的に十分合致するよう策定するものである。  |
|                                                                      |
| まず、地形、地質等の自然条件、既往                                   |
| 洪水の発生状況、現況河道の課題を含むその河川の特性、地域の自然環境、 |
| 社会環境及びそれらの歴史的な変遷を把握(基本計画編第2章河川計画による |
| )する。それらを踏まえ、治水面・利水面・環境面の各目標等(基本計画編第 |
| 2章河川計画による)を総合的に勘案し、河道計画の具体的な検討を進める。 |
|                                                                      |
| 本節の1.4に示す考え方に                                              |
| 基づいて計画高水位を設定した後、目標とする河道配分流量を流下させるこ |
| とができるかどうか検討する。その結果も含めて、流下能力の不足、洪水の |
| 流下の支障となる横断工作物の存在、河道の平面形の不良、過去の主要な災 |
| 害の原因等を調査し、改修を必要とする理由及び区間を定める。その結果を |
| 踏まえて、河道の平面形、縦横断形について複数の検討ケースを設定する。 |
|                                                                      |
| 各検討ケースにおいて、設定した平面形                                 |
| 、縦横断形等の下で、長期的に河道が安定するよう、河道の侵食・洗掘・堆 |
| 積を防止・抑制するための構造物などの配置計画を検討する。改修河道の平 |
| 面形、縦横断形の設定によっては、内水排除や利水等の機能に影響が生じる |
| 場合があるので、必要に応じて、堰、樋門、水門、そのほか(治水機能以外  |
| を主目的とした構造物を含む)の施設の新設や改築、統廃合等についても検  |
| 討する。その際、平常時及び洪水時の流水の挙動と河床・河岸形状の変化特 |
| 性、土質・地質特性、土砂流送特性を十分踏まえ、河道計画の中での位置付 |
| けと役割、優先順位や設置時期の判断基準を明確にし、所要の機能を必要最 |
| 小限の施設の新設や既設施設の改築で発揮させる方策を検討するとともに、 |
| 良好な河川環境の整備・保全等を十分に考慮した措置を講ずるようにする。 |
|                                                                      |
| 各検討ケースの設定に当たっては、水位、                               |
| 流量、流況等の変化による下流区間への影響や上下流バランスに留意する。 |
|                                                                      |
| 検討ケースごとの治                                                   |
| 水・利水・環境への効果及び影響について、総合的に評価するものとする。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 河道計画は、河川の特性、周                                           |
| 辺地域の状況、地域の自然環境、社会環境及びそれらの歴史的な変遷を踏ま |
| え、治水面・利水面・環境面の各目標等を総合的に勘案し、主に以下の手順 |
| によって具体的な検討を進め、総合的な評価をもとに、計画全体が均整のと |
| れた計画となるまで必要な修正を繰り返して検討を行うことを基本とする。 |
|                                                                      |
| 1.  計画高水位の設定                                                 |
|                                                                      |
| 2.  改修を必要とする理由に応じた計画区間の設定                       |
|                                                                      |
| 3.  河道の平面形、縦横断形等について複数の検討ケースの設定           |
|                                                                      |
| 4.  河川構造物などの設定                                             |
|                                                                      |
| 5.  治水・利水・環境への効果及び影響について総合的な評価             |
+----------------------------------------------------------------------+

＜推　奨＞

+----------------------------------------------------------------------+
| 河川の特性の把握に当たっては、実際の洪水等                           |
| によって生じた状況変化を適切に捉えることが重要であることから、調査編 |
| 第2章水文・水理観測を参考に、降                                      |
| 水量、水位、流量などの水文・水理量の把握・蓄積を図るとともに、調査編 |
| 第4章河道特性調査を参考に、河道状況の時間的変化、洪水の作用、土      |
| 砂流送特性、河道を取り巻く諸状況等の調査・分析を行うことが望ましい。 |
|                                                                      |
| 特に、河口部や分合流地点、河川構造物等によ                           |
| る堰上げの影響が及ぶ区間や、洪水流量の変化に対する河床形状変化の追随 |
| 性が高く、洪水流量が比較的小さい場合にも一定の土砂流送とそれに伴う河 |
| 床地形形成が起こる区間などにおいては、同じ流量の下でも水理量が変わり |
| 得ることから、水位多点連続観測等により多点かつ複数種類の水文・水理量 |
| の把握・蓄積を図るとともに、これらを連携させて水理解析や河床変動等の |
| 解析を行うことにより、河川の流れの総合的把握に努めることが望ましい。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1)  河川砂防技術基準調査編，平成26年4月，国土交通省水管理・国土保全局，第2章
    > 水文・水理観測，第4章 河道特性調査，第5章
    > 河川における洪水流の水理解析，第6章
    > 河床変動、河床材料変化及び土砂流送の解析.

```{=html}
<!-- -->
```
35) （最新版）河川砂防技術基準調査編，国土交通省水管理・国土保全局，第2章
    > 水文・水理観測（令和4年6月），第4章
    > 河道特性調査（平成26年4月），第5章
    > 河川における洪水流の水理解析（平成26年4月），第6章
    > 河床変動、河床材料変化及び土砂流送の解析（平成26年4月）.

＜推　奨＞

  ------------------------------------------------------------------------------------------------------------------------------------
  現況施設能力を上回る洪水の生起についても配慮して、避難等のソフト対策を活かすための施設による対応についても検討することが望ましい。
  ------------------------------------------------------------------------------------------------------------------------------------

＜例　示＞

  河川整備計画の検討に当たって、想定し得る最大規模の外力までの様々な規模の外力に対して、施設整備が完了した場合の水害リスクの変化を、人的被害、経済被害、社会経済活動への影響等の評価項目により評価した事例がある。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1)  [河川砂防技術基準調査編](http://www.mlit.go.jp/river/shishin_guideline/gijutsu/gijutsukijunn/chousa/pdf/09.pdf)，平成26年4月，国土交通省水管理・国土保全局,第9章
    > 水害リスク評価.

```{=html}
<!-- -->
```
36) （最新版）河川砂防技術基準調査編，令和7年6月，国土交通省水管理・国土保全局,第9
    章 水害リスク評価.

```{=html}
<!-- -->
```
2)  治水経済調査マニュアル(案)，平成17年4月，国土交通省河川局.

```{=html}
<!-- -->
```
37) （最新版）治水経済調査マニュアル（案）,令和7年7月，国土交通省水管理・国土保全局.

```{=html}
<!-- -->
```
3)  [水害の被害指標分析の手引(H25
    > 試行版)](http://www.mlit.go.jp/river/basic_info/seisaku_hyouka/gaiyou/hyouka/pdf/higaisihyou_h25.pdf)，平成25年7月，国土交通省水管理・国土保全局.

＜参考となる資料＞

施設整備による水害リスクの変化を評価した例としては、下記の資料が参考となる。

1)  [鈴鹿川における河川整備の効果について（水害リスクの評価（試行））](http://www.cbr.mlit.go.jp/mie/river/conference/ryuiki/pdf/16th/16th_shiryou-08.pdf)（第16回三重河川流域委員会資料-8），平成28年3月24日，国土交通省
    > 中部地方整備局 三重河川国道事務所.

＜例　示＞

+----------------------------------------------------------------------+
| 山地部の地形・地質等の条件、降雨                                     |
| の条件等によっては、同時多発的な山腹崩壊や土石流の発生、深層崩壊によ |
| る大規模な山腹崩壊等により、大量の土砂や流木が河川に流入する可能性が |
| あり、特に山地部の比較的規模の小さい河川においては、河道の埋塞や閉塞 |
| 、大量の土砂や流木を含んだ洪水のはん濫等により、被害が甚大となる可能 |
| 性があるが、このような現象の定量的な予測は技術的に難しい課題である。 |
|                                                                      |
| こ                                                                   |
| のような現象により甚大な被害が発生した山地部の比較的規模の小さい河川 |
| において、渓流に残存した土砂や流木の供給量を考慮し、砂防施設等による |
| 土砂や流木の流出制御とあわせて、河道改修の方針を検討した事例がある。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

山地部の比較的規模の小さい河川において、渓流に残存した土砂や流木の影響を考慮して河道改修の方針を検討した例としては、下記の資料が参考となる。

1)  [筑後川右岸流域 河川・砂防復旧技術検討委員会
    > 報告書](http://www.qsr.mlit.go.jp/site_files/file/bousai_joho/tecforce/H29hokubugouu_data/171122houkokusyo11.pdf)，平成29年11月22日，筑後川右岸流域
    > 河川・砂防復旧技術検討委員会．

    1.  []{#_Toc497347262 .anchor}河道計画の検討に用いる水理解析

＜考え方＞

+----------------------------------------------------------------------+
| 洪水流の水理解析は、所定の流下能力や侵食・洗掘に対す                 |
| る安全性の確保、流下能力を維持するための樹木群管理や河積の確保等の目 |
| 的に応じた河道計画の内容を具体的に検討するために実施するものである。 |
|                                                                      |
| 解析手法の選定に当                                                   |
| たっては、各種解析手法の原理と特徴、その適用限界などを理解した上で、 |
| 検討の目的を達成するための適切な解析手法を選択することが重要である。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1)  [河川砂防技術基準調査編](http://www.mlit.go.jp/river/shishin_guideline/gijutsu/gijutsukijunn/chousa/pdf/05.pdf)，平成26年4月，国土交通省水管理・国土保全局，第5章
    > 河川における洪水流の水理解析.

＜標　準＞

+----------------------------------------------------------------------+
| 38) 河道計画の検                                                     |
| 討に当たって水理解析を行う際には、河川砂防技術基準調査編を参照し、河 |
| 川の特性や検討の目的に応じた適切な解析手法を用いることを基本とする。 |
+----------------------------------------------------------------------+

＜例　示＞

+----------------------------------------------------------------------+
| 洪水流の解析法としては、対象とする河道において、縦                   |
| 断方向に断面変化が大きくなく、水理量の横断面内の変化よりも縦断的な変 |
| 化が大きい場合には、断面内で平均された平均水深や平均流速の流下方向変 |
| 化を求める一次元解析法が用いられる。一次元不等流計算、準二次元不等流 |
| 計算、一次元不定流計算、準二次元不定流計算がこれにあたる。これに対し |
| 、河道の横断面内の水理量変化と縦断方向の変化の両方を検討する必要があ |
| る場合には、水深方向の水理量に水深平均値を用い（川幅が水深に比して十 |
| 分大きい場合）、水深平均流速、水位の平面分布を求める平面二次元流解析 |
| が用いられる。さらに水理量の横断方向、縦断方向の他に、鉛直方向の変化 |
| も同様に重要な場合には、準三次元流解析及び三次元流解析が用いられる。 |
|                                                                      |
| 河床変動、河床材料変化及び土砂流送の                                 |
| 解析法としては、解析の目的に対して、河床高、粒径、流砂、流れ場の解析 |
| レベル（流れ、流砂（掃流・浮遊）、河床の形状・粒径変化といった各事象 |
| を記述する解像度又は範囲）について適切に組合せた解析法が用いられる。 |
|                                                                      |
| 単断面の河道であれば、一次元解析、複断面の河道であれ                 |
| ば、準二次元解析を用いることが一般的であるが、以下に示すように各河川 |
| の抱える課題に応じて、より適切な解析手法を用いて検討した事例がある。 |
|                                                                      |
| 1.  本川の低水路河床低下、分派地点周辺の樹木繁茂状況や中州形         |
| 状などによる分派量減少の課題に対して、準三次元流解析と平面二次元河床 |
| 変動解析を用いて、今後の河道改修計画を検討した例がある。また、調査編 |
|     > 第2章水文・水理解析第7節河川の流れ                             |
| の総合的把握にある河川の流れの総合的把握に倣って洪水観測を実施し、本 |
| 川流量に応じた分派量の変化など、分派現象の全体像を把握した例がある。 |
|                                                                      |
| 2.  洪水時に多量の土砂移動が生じ、河床形状が大                       |
| きく変化する河道区間を対象として、洪水時の観測水面形と平面二次元流・ |
| 河床変動解析を用いて、洪水時の現象解明に関する検討を行った例がある。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1)  河川砂防技術基準調査編，平成26年4月，国土交通省水管理・国土保全局，第2章
    > 水文・水理解析第7節 河川の流れの総合的把握，第5章
    > 河川における洪水流の水理解析，第6章
    > 河床変動，河床材料変化及び土砂流送の解析.

```{=html}
<!-- -->
```
39) （最新版）河川砂防技術基準調査編，国土交通省水管理・国土保全局，第2章
    > 水文・水理解析第7節 河川の流れの総合的把握（令和4年6月），第5章
    > 河川における洪水流の水理解析（平成26年4月），第6章
    > 河床変動，河床材料変化及び土砂流送の解析（平成26年4月）.

＜参考となる資料＞

適切な分派量を確保するための分派点での平面形状や縦横断形状の設定における課題への対応について検討した例としては、下記の資料1)が参考となる。また、洪水時に多量の土砂移動が生じ、河床形状が大きく変化する河道区間における洪水時の現象解明について検討した例としては、下記の資料2)が参考となる。

1)  小渕康正、吉村綾子、宮川勇二、岡村誠司、天野光歩、福岡捷二：[江戸川流頭部の河道計画の策定－先導的な数値解析を中心とした新しい河道設計技術－](http://c-faculty.chuo-u.ac.jp/~sfuku/sfuku/paper/150508kasen_obuchi.pdf)，河川技術論文集，
    > Vol.21， pp.153-158， 2015.

2)  岡安光太郎、池田博明、内田龍彦、福岡捷二：[土砂移動量の多い急流河川の洪水流と河床変動解析区間における上流端の境界条件検討の試み](http://c-faculty.chuo-u.ac.jp/~sfuku/sfuku/paper/%E5%B2%A1%E5%AE%89%E5%85%89%E5%A4%AA%E9%83%8E_%E5%9C%9F%E7%A0%82%E7%A7%BB%E5%8B%95%E9%87%8F%E3%81%AE%E5%A4%9A%E3%81%84%E6%80%A5%E6%B5%81%E6%B2%B3%E5%B7%9D%E3%81%AE%E6%B4%AA%E6%B0%B4%E6%B5%81%E3%81%A8%E6%B2%B3%E5%BA%8A%E5%A4%89%E5%8B%95%E8%A7%A3%E6%9E%90%E5%8C%BA%E9%96%93%E3%81%AB%E3%81%8A%E3%81%91%E3%82%8B%E4%B8%8A%E6%B5%81%E7%AB%AF%E3%81%AE%E5%A2%83%E7%95%8C%E6%9D%A1%E4%BB%B6%E6%A4%9C%E8%A8%8E%E3%81%AE%E8%A9%A6%E3%81%BF_%E6%B0%B4%E5%B7%A52016.pdf)，土木学会論文集B1(水工学)，
    > Vol.73， No.4， pp.I\_637-I\_642， 2017.

    1.  []{#_Toc497347263 .anchor}現況河道の評価

＜考え方＞

+----------------------------------------------------------------------+
| 現況河道の評価は、河道計画の検討                                     |
| の前提となるものであり、主な評価の観点として以下の事項が挙げられる。 |
|                                                                      |
| １）流下能力                                                         |
|                                                                      |
| ２）堤防等の河川管理施設の安全性                                     |
|                                                                      |
| ３－１）動植物の生息・生育・繁殖環境、河川景観                       |
|                                                                      |
| ３－２）河川等の利用                                                 |
|                                                                      |
| ４）維持管理                                                         |
|                                                                      |
| 流下能力の評価手法としては、調査編                                   |
| 第4章河道特性調査、第5章河                                           |
| 川における洪水流の水理解析、第6章河床変動、河床材料変化及び土砂流送  |
| の解析を参考にして、現況の河道特性を調査・分析し、河道特性に応じた適 |
| 切な解析手法を用いて、現況河道の流下能力を評価することが挙げられる。 |
|                                                                      |
| 堤防の安全性の評価手法としては                                       |
| 、過去の被災履歴、「河川堤防設計指針」に基づく安全性の評価結果等を参 |
| 考に評価することが挙げられる。床止め、堰などの河川管理施設については |
| 、過去の被災状況、維持管理の状況等を参考に評価することが挙げられる。 |
|                                                                      |
| 動植物の生息・生育・繁殖環境、河川景観の評価手法としては、調査編     |
| 第11章河川環境調査を参                                               |
| 考にして、適切に河川環境調査を行った上で、評価することが挙げられる。 |
|                                                                      |
| 河川等の利用の評価手法としては、調査編                               |
| 第11章河川環境調査を参考にして、適切に利                             |
| 用実態を把握した上で、河川空間を利用面から評価することが挙げられる。 |
|                                                                      |
| 維持管理の評価手法としては、定期的                                   |
| または出水後に行う縦横断測量あるいは点検等の結果を用いて、流下能力の |
| 変化、施設の安全性に影響を及ぼすような河床・河岸の変化、樹木の繁茂状 |
| 況を把握し、維持管理上の課題を把握・抽出し評価することが挙げられる。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1)  河川砂防技術基準調査編，平成26年4月，国土交通省水管理・国土保全局，[第4章
    > 河道特性調査](http://www.mlit.go.jp/river/shishin_guideline/gijutsu/gijutsukijunn/chousa/pdf/04.pdf)，[第5章
    > 河川における洪水流の水理解析](http://www.mlit.go.jp/river/shishin_guideline/gijutsu/gijutsukijunn/chousa/pdf/05.pdf)，[第6章
    > 河床変動、河床材料変化及び土砂流送の解析](http://www.mlit.go.jp/river/shishin_guideline/gijutsu/gijutsukijunn/chousa/pdf/06.pdf)，[第11章
    > 河川環境調査](http://www.mlit.go.jp/river/shishin_guideline/gijutsu/gijutsukijunn/chousa/pdf/11.pdf).

```{=html}
<!-- -->
```
40) （最新版）河川砂防技術基準調査編，国土交通省水管理・国土保全局，第4章
    河道特性調査（平成26年4月），第5章
    河川における洪水流の水理解析（平成26年4月），第6章
    河床変動、河床材料変化及び土砂流送の解析（平成26年4月），第11章
    河川環境調査（令和６年６月）.

```{=html}
<!-- -->
```
2)  [河川堤防設計指針](http://www.mlit.go.jp/river/shishin_guideline/bousai/gijyutukaihatu/pdf/teibou_sekkei.pdf)，平成19年3月23日，国河治第192号，国土交通省河川局治水課長通知．

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  河道計画を検討する際には、流下能力、堤防等の河川管理施設の安全性、河川環境の整備と保全、維持管理等に関する事項のうち必要な事項について現況河道を適切に評価することにより、現況河道の状況や課題を踏まえた上で、改修が必要な区間の検討、河道の平面形・縦横断形や河川構造物の配置等の検討を行うことを基本とする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  河口部や分合流地点、河川構造物等による堰上げの影響が及ぶ区間や、洪水流量の変化に対する河床形状変化の追随性が高く、洪水流量が比較的小さい場合にも一定の土砂流送とそれに伴う河床地形形成が起こる区間などにおいては、同じ流量の下でも水理量が変わり得ることから、河川の流れの総合的把握を行った上で、流下能力を評価することが望ましい。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1)  河川砂防技術基準調査編，平成26年4月，国土交通省水管理・国土保全局，[第4章
    > 河道特性調査](http://www.mlit.go.jp/river/shishin_guideline/gijutsu/gijutsukijunn/chousa/pdf/04.pdf)，[第5章
    > 河川における洪水流の水理解析](http://www.mlit.go.jp/river/shishin_guideline/gijutsu/gijutsukijunn/chousa/pdf/05.pdf)，[第6章
    > 河床変動、河床材料変化及び土砂流送の解析](http://www.mlit.go.jp/river/shishin_guideline/gijutsu/gijutsukijunn/chousa/pdf/06.pdf).

＜例　示＞

  --------------------------------------------------------------------------------------------------------------------------------
  堤防の安全性については、基礎地盤構造の影響や浸透破壊の起こりやすさなどの新たな観点に着目した調査研究が行われている事例がある。
  --------------------------------------------------------------------------------------------------------------------------------

＜参考となる資料＞

堤防の安全性に関する調査研究としては、下記の資料が参考となる。

1)  齊藤啓、前田健一、泉典洋、李兆卿：[基盤の地盤特性が異なる河川堤防の高水位の継続作用による漏水とパイピングの進行特性](http://library.jsce.or.jp/jsce/open/00906/2015/21-0349.pdf)，河川技術論文集，Vol.22，pp.349-354，2015.

2)  小高猛司、李圭太、崔瑛、森智彦、森三史郎、林愛実：[浸透に伴う基礎地盤の弱化に起因する堤防法すべり崩壊に関する考察](http://www.cee.ehime-u.ac.jp/~gm/Levee_symp5.pdf)，第5回河川堤防技術シンポジウム，pp.55-58，2017．

3)  福岡捷二、田端幸輔：[堤防破壊危険確率と堤防脆弱性指標に基づく堤防破壊危険タイムラインを用いた被災プロセスの見える化](http://c-faculty.chuo-u.ac.jp/~sfuku/sfuku/paper/4th-bank-symposium-tabata-timeline.pdf)，第4回河川堤防技術シンポジウム，pp.61-64，2016．

    1.  []{#_Toc497347264 .anchor}計画高水位

        1.  []{#_Toc497347265 .anchor}計画高水位設定の基本

＜考え方＞

+----------------------------------------------------------------------+
| 計画高水位は、その水位以下で計画高水流量を流下させる                 |
| ことができるよう設定された水位であり、堤防高や橋梁の桁下高を設定する |
| 基準となるとともに、支川の河道計画や内水処理計画を策定する際の基本条 |
| 件ともなる。さらに、堤防が決壊した場合のはん濫流量は河道内水位が高い |
| ほど大きくなるため、計画高水位の設定は河川管理にとっても重要である。 |
|                                                                      |
| このように、河道計画を                                               |
| 検討する際には、計画高水位をどのように設定するかが最も重要な検討事項 |
| となるが、ほとんどの河川では既に計画高水位が定められており、それに基 |
| づいた河川改修や河川管理がなされてきていることを踏まえる必要がある。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 計画高水位は、その水位以下で計画高水流量を流下させることができるよ   |
| う設定された水位であって、堤防高や橋梁の桁下高、支川の河道計画や内水 |
| 処理計画など、様々な計画の基本となる事項であるとともに、堤防が決壊し |
| た場合の被害の大きさをも左右する河川管理上最も重要な計画事項である。 |
|                                                                      |
| 計画高水位の設定においては、既に計画高水位が定められている場合と     |
| 、計画高水位が定められていない若しくは定められてはいても新川の整備に |
| 近いような全面的な改修を行う場合とは分けて検討することを基本とする。 |
+----------------------------------------------------------------------+

1.  計画高水位が設定されている河川で河道計画を見直す場合

＜考え方＞

+----------------------------------------------------------------------+
| 過去に計画高水位が定められている河川区間で                           |
| 河道計画の見直しを行う場合、計画高水位を以前よりも高くすることは河川 |
| を大幅に再改修するに等しいことになり、部分的な場合を除き現実的ではな |
| いばかりでなく、洪水をできるだけ低い水位で流すという治水の大原則に反 |
| するものであることから、既往の計画高水位を踏襲するのが一般的である。 |
|                                                                      |
| また、やむを得ず計画高水位を                                         |
| 上げることが必要となる場合においても、その範囲はできるだけ小さくする |
| ものとし、できる限り既往洪水の最高水位以下にとどめることが望ましい。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1)  [中小河川に関する河道計画の技術基準について](http://www.mlit.go.jp/river/kankyo/main/kankyou/tashizen/pdf/gijyutsukijyun.pdf)，平成22年8月9日，国河環第30号，国河域第7号，国河防第174号，国土交通省河川局河川環境課長，治水課長，防災課長通達．

＜参考となる資料＞

計画高水位が設定されている川幅が比較的狭い単断面の河川で計画高水位を見直す場合の考え方については、下記の資料が参考となる。

1)  多自然川づくり研究会：多自然川づくりポイントブックⅢ，p.14-16，（財）リバーフロント整備センター，2011.

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------
  過去に計画高水位が定められている河川区間で河道計画の見直しを行う場合、既往の計画高水位を上回らないよう定めることを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------

2.  新たに計画高水位を設定する場合

＜考え方＞

+----------------------------------------------------------------------+
| 捷水路及び放水路などの新川の整備のように過去に                       |
| 計画高水位の定められていない河川や全面的な河川改修を行うため必ずしも |
| 過去の計画高水位にとらわれる必要性がない河川で新たに計画高水位を定め |
| る場合には、計画高水流量、河道の縦横断形、接続する河川の計画高水位、 |
| 地形や土地利用の状況などの地域の特性等を考慮しつつ、沿川の地盤高を上 |
| 回る高さが極力小さくなるように計画高水位を検討することが重要である。 |
|                                                                      |
| 特に、計画の規模の小さい河川で                                       |
| は、計画を超える洪水が発生する可能性が高いことから、計画高水位を地盤 |
| 高以下として掘込河道とすることも検討されるが、水系全般の安全度から見 |
| て上流部の河道を過度の掘込河道とした場合には、下流部の安全上大きな問 |
| 題となることから、下流河道の条件を十分考慮するとともに、低水時におけ |
| る地下水位の確保、各種用水の取水位の確保、そのほかの流水の正常な機能 |
| の維持を図るための対策及び河川環境の整備と保全に対しても十分考慮する |
| 必要がある。また、既に計画高水位が周辺地盤高よりも低く定められている |
| 掘込河川において、大幅な拡幅や掘削を必要とする河川改修に新たに着手す |
| る場合には、必要に応じて計画高水位の見直しを検討することが望ましい。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1)  [中小河川に関する河道計画の技術基準について](http://www.mlit.go.jp/river/kankyo/main/kankyou/tashizen/pdf/gijyutsukijyun.pdf)，平成22年8月9日，国河環第30号，国河域第7号，国河防第174号，国土交通省河川局河川環境課長，治水課長，防災課長通達.

＜参考となる資料＞

川幅が比較的狭い単断面の河川において新たに計画高水位を設定する場合の考え方については、下記の資料が参考となる。

1)  多自然川づくり研究会：多自然川づくりポイントブックⅢ，p.14-16，（財）リバーフロント整備センター，2011.

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  新たに計画高水位を定める場合には、計画高水流量、河道の縦横断形、接続する河川の計画高水位、地形や土地利用の状況などの地域の特性等を考慮しつつ、沿川の地盤高を上回る高さが極力小さくなるよう計画高水位を定めることを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

1.  []{#_Toc508054552 .anchor}本川の背水区間内における支川の計画高水位

＜考え方＞

  ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  本川の背水区間内の支川の計画高水位は、本川の各水位に対応する支川の洪水流量に基づく支川の高水位を包絡して定めるのが正しいが、本川が計画高水位の場合と、支川が計画高水流量の場合の2つを基準として差し支えない。
  ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 本川の背水区間内の支川の計画高水                                     |
| 位は、次の水位のいずれか高いほうを基準にして定めることを基本とする。 |
|                                                                      |
| 1.  本川が計画高水位であって支川は本川のピーク                       |
| 流量に対応する合流量が流下する場合に、背水計算によって求められる水位 |
|                                                                      |
| 2.  支川から計画高水流量が合流するときの本川                         |
| 流量に対応する本川水位を出発水位として背水計算によって求められる水位 |
+----------------------------------------------------------------------+

＜例　示＞

+----------------------------------------------------------------------+
| 本川と支川の流域の状況                                               |
| が極端に違っている場合で、ピークの出現状況がほとんど関係ないと思われ |
| る場合には本川の背水はほとんど水平と考えられる。このような場合には標 |
| 準１）の水位は合流点の本川水位に対して水平の水位とすることができる。 |
|                                                                      |
| また、本川の計画高水流量に対して支川のそ                             |
| れの比が比較的小さいような場合には、標準２）の水位に代えて支川の計画 |
| 高水流量に対応して等流計算によって求められる水位とすることができる。 |
+----------------------------------------------------------------------+

1.  []{#_Toc497347267 .anchor}河口部の計画高水位

＜考え方＞

+----------------------------------------------------------------------+
| 河口部に                                                             |
| おける水理現象は、波と流れと潮汐・高潮等の潮位変動、淡水と海水の存在 |
| 、河口砂州が存在する場合には洪水時の河口砂州のフラッシュ等による河床 |
| 変動など、物理現象として非常に複雑である。それら複雑な水理現象のうち |
| 、どの現象が計画の対象とする洪水時の水位に影響するかは、検討対象とす |
| る河口部の河道特性、周辺海岸を含む河口の地形、海象等によって異なる。 |
|                                                                      |
| 河口部の計画高                                                       |
| 水位を検討する際は、洪水の発生と潮位の変動を十分に調査した上で河口部 |
| の出発水位を設定することが重要である。河口砂州がない場合には、出発地 |
| 点は導流堤等を含めた河口部の形状から定まる海域との境界として、出発水 |
| 位は基本的に朔望平均満潮位を与える。河口砂州がある場合には、洪水中の |
| 水位・流量と砂州のフラッシュの状況との関係を適切に調査・把握・分析し |
| た上で、出発地点や出発水位を検討することが必要となる。将来的に河口部 |
| の埋め立てや浚渫を行う可能性がある場合には、河口部の水理現象が変化す |
| る可能性があるので、それらによる影響を十分考慮することが必要となる。 |
|                                                                      |
| なお、河川を遡                                                       |
| 上又は流下する津波は、洪水、高潮と並んで計画的に防御対策を検討するこ |
| とが必要となるが、河口部の計画高水位の設定に当たっては、河川管理施設 |
| の諸元等を定める際に対象とする計画津波と洪水との同時生起は考えない。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1)  [河川津波対策について](http://www.mlit.go.jp/river/shishin_guideline/kasen/pdf/kasen_tsunami_taisaku_h230902.pdf)，平成23年9月2日，国水河計第20号，国水治第35号，国土交通省水管理・国土保全局河川計画課長,治水課長通達.

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  河口部の計画高水位は、河口付近の河川・海域の水理・気象特性を把握し、河口及び河口付近の河道特性並びに河口部における課題への対応方法を踏まえ、洪水時の河床変動、海水塩分濃度の影響、潮位偏差等の河口部付近における水理現象のなかで、計画に取り入れることが妥当と判断される事象について考慮して定めることを基本とする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

+----------------------------------------------------------------------+
| 河口部                                                               |
| の計画高水位の設定に当たっては、河川の状況に応じ、河口付近の河川・海 |
| 域の水理・気象特性として、以下のような事項を考慮することが望ましい。 |
|                                                                      |
| 1.  洪水時の河床変動                                                 |
|                                                                      |
| 河口部で                                                             |
| は、河口砂州の存在、洪水時の河口砂州や河床高等の地形の変動等による水 |
| 位への影響が無視できない場合がある。このような河川においては、洪水時 |
| の河口地形の変動を考慮することが必要となる。河口部の地形変動を考慮す |
| るための河床変動計算においては、出発水位は沖合部で与える必要がある。 |
|                                                                      |
| 6.  海水塩分濃度の影響                                               |
|                                                                      |
| 河口                                                                 |
| 部では、河川水と海水の密度差により塩水くさびが発生し、洪水時の水面か |
| ら河床までを有効河積として見込めない場合がある。このような河川におい |
| ては、海水塩分濃度の影響による水位上昇量を考慮することが必要となる。 |
|                                                                      |
| 7.  洪水と高潮の同時生起                                             |
|                                                                      |
| 台風によって                                                         |
| もたらされる洪水の発生と高潮が同時に生起する可能性が高い河川では、既 |
| 往洪水における洪水ピークと潮位偏差の関係について整理を行い、必要に応 |
| じて洪水時の既往最高潮位や既往最大痕跡水位、洪水防御計画の規模と同一 |
| の確率の偏差を考慮した水位等により河口部の計画高水位を設定する。また |
| 、河口部付近の背後地が特に重要な地域である場合には、洪水防御計画の規 |
| 模相当の確率の偏差を考慮した水位についても検討することが必要となる。 |
|                                                                      |
| なお、計画潮位の設定については、基本計画編 第4章海岸保全計画第2節    |
| 海岸防護に関する基本的な事項による。                                 |
+----------------------------------------------------------------------+

1.  []{#_Toc497347268 .anchor}河道の平面形、縦横断形の基本

    1.  []{#_Toc497347269 .anchor}河道の平面形

＜考え方＞

+----------------------------------------------------------------------+
| 河道の平面形は、既設堤防                                             |
| の状態、沿川における家屋の密集状況、自然環境や河川利用の状況、用地取 |
| 得の状況等を勘案し、現河道の平面形を中心に設定する方が有利な場合が多 |
| いが、目標とする河道配分流量や流況、土砂流送特性、河道の縦横断形等も |
| 適切に勘案しながら河道計画全体の検討の中で設定することが重要である。 |
|                                                                      |
| また、河                                                             |
| 道の平面形の設定に当たっては、以下の事項に留意することが重要である。 |
|                                                                      |
| 1.  流下能力からみて現況の河道に十分な余裕のある平                   |
| 面形であっても、一般には河道の貯留効果を考慮してその平面形を確保する |
| ことが望ましい。なお、計画上の効果としては、洪水によってその効果に差 |
| 異があることなどの理由から河道貯留による流量低減の効果は考慮しないの |
| が通例であるが、この河道貯留の効果を低く評価するという趣旨ではない。 |
|                                                                      |
| 2.  洪水時における流況を踏まえて、堤防の安全性の確保、侵食・堆積     |
| に対する河道の維持等の点を総合的に検討する。一般に急流河川では直線に |
| 近い形状とする場合が多い。また、緩流部の河川では、必ずしも直線的であ |
| る必要はないが急な曲がりは避け、場合によっては適切な蛇行形状にするこ |
| とにより、堤防や河岸の侵食対策の必要範囲を限定することも可能である。 |
|                                                                      |
| 3.  蛇行形状の設定に当たっては、現状の河道、背後の地形・             |
| 地質の状況、土地利用状況等を考慮するものとし、家屋の連たん地域や旧川 |
| の締切り箇所などができるだけ水衝部とならないよう配慮するものとする。 |
|                                                                      |
| 4.  現河道の屈曲の著しい河川、あるいは、現河道沿いに大               |
| 規模な家屋連たん地域が形成されている河川などについては、放水路、捷水 |
| 路等の新川の整備を組み込んだ河道の平面形を検討すべき場合もある。この |
| ような場合については、現河道利用部分と新川の整備部分を組合せた幾つか |
| の河道の平面形を設定し、それぞれについて、地形、地質、現在並びに将来 |
| の土地利用(地域の分断について考慮することが重要)、行政区画、用排水路 |
| 系統、地下水位への影響、内水対策、計画区間の上下流への影響、自然環境 |
| 、景観、経済性、改修後の維持管理等を勘案して河道の平面形を選定する。 |
|                                                                      |
| 5.  当該河川固有の自然環境や河川の利用状況等との関係に十分に配慮     |
| して、河川環境の整備と保全が容易となるようにする。特に、川幅が比較的 |
| 狭い単断面の河川では、平常時のみお筋の現況が良好な河川環境を形成して |
| いる場合には、河道の法線は、その位置を極力変更しないように設定する。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 河道の平面形は、堤防や低水路の法線、川幅等を定める                   |
| ものであり、堤内地にとっては土地利用を制約する最も重要な条件となる。 |
|                                                                      |
| 河道の平面形は河道計画全体の検                                       |
| 討の中で定めるものとし、目標とする河道配分流量、沿川の土地利用状況、 |
| 自然環境、現況の河道、洪水時の流況、土砂流送特性、長期的な河道の維持 |
| 、河川整備及び維持管理に要する費用の経済性等を総合的に勘案し、必要な |
| 川幅を確保し、適切な位置や形状となるように設定することを基本とする。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1)  [中小河川に関する河道計画の技術基準について](http://www.mlit.go.jp/river/kankyo/main/kankyou/tashizen/pdf/gijyutsukijyun.pdf)，平成22年8月9日，国河環第30号，国河域第7号，国河防第174号，国土交通省河川局河川環境課長，治水課長，防災課長通達.

＜参考となる資料＞

川幅が比較的狭い単断面の河川における河道の平面形を計画する際には、下記の資料が参考となる。

1)  多自然川づくり研究会：多自然川づくりポイントブックⅢ，p.17-37，（財）リバーフロント整備センター，2011.

    1.  []{#_Toc497347271 .anchor}河道の縦断形

＜考え方＞

+----------------------------------------------------------------------+
| 河床の横断形は流水等の作用                                           |
| により横断方向に一様な高さとはならないが、一般にはそのような河道の横 |
| 断形のうち低水路（単断面では河岸を除く河床）の平均河床高により縦断形 |
| を定整理し、その勾配を河床勾配とする。護岸等構造物の安全性においては |
| 、河床の横断形状や局所的な洗掘が重要なため、平均河床高に加えて最深河 |
| 床高を参考に設計・管理の目安となる河床高を設定することが重要である。 |
|                                                                      |
| 上流からの土砂供給量の変化に伴って、下流側河道の河床変               |
| 動が生じる場合等には、河道計画の検討対象としている区間において改修後 |
| の洪水や河床変動等により、計画時に想定した低水路平均河床高より平均河 |
| 床高が低下・上昇する場合がある。この変化は1洪水で生じるとは限らず、  |
| 中長期的に進行するものであり、河道の縦断形の検討に当たっては、調査編 |
| 第4章                                                                |
| 河道特性調査を                                                       |
| 参考に、このような平均河床高の低下・上昇が起こらないか留意する必要が |
| ある。あわせて、重要な河川構造物の敷高、用水の取水位、支川であれば合 |
| 流点の本川の河床高、岩盤露出地点の河床高、周辺地下水位等を十分考慮し |
| てこれらに支障が生じないよう河道の縦断形を設定することが重要である。 |
|                                                                      |
| また、河道の                                                         |
| 縦断形は特に水生生物の自由な移動、瀬や淵の形成などの動植物の生息・生 |
| 育・繁殖環境や河川の利用面などに強く関連するので、縦断方向の連続性の |
| 確保など河川環境も十分に考慮し、その河川が本来有している多様性に富ん |
| だ自然環境を保全・創出することができるよう検討することが必要となる。 |
|                                                                      |
| なお、現                                                             |
| 況の河道において大幅な変化が進行中でない限り、一般には現状の河床勾配 |
| によることが将来の河道の維持上有利となることが多いことから、通常の河 |
| 川では、現況の低水路平均河床高の縦断形にならって河道の縦断形を定め、 |
| 河床勾配は上流から下流に向かい急から緩へと変化させるのが一般である。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1)  [河川砂防技術基準調査編](http://www.mlit.go.jp/river/shishin_guideline/gijutsu/gijutsukijunn/chousa/pdf/04.pdf)，平成26年4月，国土交通省水管理・国土保全局，第4章
    > 河道特性調査.

＜標　準＞

+----------------------------------------------------------------------+
| 河道の縦断形は、本節の1.4で設定した計画高水位の縦断形の下、          |
| 平均河床高、護岸等構造物の設計・管理の目安となる河床高、高水敷高、堤 |
| 防高の縦断形により構成されるが、河道計画においては、これらのすべてを |
| 計画事項として定めるというものではなく、目標とする河道配分流量の流下 |
| 能力確保、構造物の安全性確保等から必要となる事項を定めるものである。 |
|                                                                      |
| 河道の縦断形は、一般には現況河道の縦断形を重視しつ                   |
| つ、河道の平面形及び横断形と関連させて堤内地盤高、河川環境、土砂流送 |
| 特性、河床の安定、経済性等を考慮するとともに、地下水位、用水の取水位 |
| 、既設の重要な河川構造物の敷高なども考慮して定めることを基本とする。 |
+----------------------------------------------------------------------+

＜推　奨＞

+----------------------------------------------------------------------+
| 河道の縦断形の設定                                                   |
| に当たっては、河川の状況に応じ、以下の事項に留意することが望ましい。 |
|                                                                      |
| 1.  調査編 第4章                                                     |
|     河道特性調査を参考に、上流からの供給土                           |
| 砂量の変化等により、河道計画の検討対象としている区間の平均河床高の低 |
| 下・上昇が想定される場合には、長期的な河床変動を十分に考慮すること。 |
|                                                                      |
| 2.                                                                   |
| 上下流間の生物移動の連続性を確保するという観点から、床止め等は極力避 |
| けることが望ましいが、河床の安定上やむを得ず必要になった場合には、上 |
| 下流間の生物移動の連続性や景観、設置後の河床変動に十分配慮すること。 |
|                                                                      |
| 3.  捷水路のように部分的に河床勾配を                                 |
| 変化させる必要がある場合には、前後の河床勾配の状況を勘案して縦断形を |
| 決定すること。また、部分的だけでなく大幅に河床勾配を変更する場合には |
| 、横断形なども組合せ、将来の河道の安定も考慮して縦断形を定めること。 |
|                                                                      |
| 4.  土砂生産の盛んな山地部の河道や扇状地                             |
| の上流河道では、洪水時の土砂流出により急激に河床が上昇する場合がある |
| 。そのような現象の予測は技術的に難しいものの、過去の経験等を踏まえ、 |
| 砂防施設等による土砂流出制御とあわせて、総合的に対策を検討すること。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1)  [「多自然川づくり」の推進について](http://www.mlit.go.jp/notice/noticedata/pdf/200704/00004847.pdf)，平成18年10月13日，国河環第38号，国河治第86号，国河防第370号，国土交通省河川局長通達.

2)  [中小河川に関する河道計画の技術基準について](http://www.mlit.go.jp/river/kankyo/main/kankyou/tashizen/pdf/gijyutsukijyun.pdf)，平成22年8月9日，国河環第30号，国河域第7号，国河防第174号，国土交通省河川局河川環境課長，治水課長，防災課長通達.

＜参考となる資料＞

川幅が比較的狭い単断面の河川において河道の縦断形を計画する際には、下記の資料が参考となる。

1)  多自然川づくり研究会：多自然川づくりポイントブックⅢ，p.56-60，（財）リバーフロント整備センター，2011.

    1.  []{#_Toc497347272 .anchor}河道の横断形

```{=html}
<!-- -->
```
1.  横断形の基本

＜考え方＞

+----------------------------------------------------------------------+
| 最小流量と最大流量の比が大きい我が国の河川では、規模の大き           |
| な洪水時には堤防付近の流速を抑え、規模の小さな洪水時及び平水時には流 |
| 路の安定化等を図るために複断面とすることが多いが、急流河川で広い川幅 |
| の中に幾本もの流路があって、しかもこれが変動する場合には、低水路と高 |
| 水敷を明確に設定することは河道の維持の点から困難な場合もある。また、 |
| 目標とする河道配分流量の小さい河川では単断面とするのが一般的である。 |
|                                                                      |
| 河道の横断形                                                         |
| は、自然の営力により常に変化するものであり、平面形や縦断形との関係に |
| よっては局所的な深掘れを生ずる場合もあることから、これらの点を十分考 |
| 慮して検討するとともに、河道の制御施設の検討を行うことが必要となる。 |
|                                                                      |
| また、河道の横断                                                     |
| 形は、河川環境、河川の利用等にとっても重要であり、河川が有している自 |
| 然の特性やメカニズムを活用するため、標準横断形による上下流一律の画一 |
| 的形状での整備は避けるよう努めるとともに、平常時及び洪水時の流況を把 |
| 握して、流水等の自然の作用に対して適したものであることが必要となる。 |
|                                                                      |
| 特に、川幅が比較的狭い単断面の河川において、横断形を検討             |
| する際には、まず拡幅を先行して検討し、できる限り洪水流量と河床勾配、 |
| 河床材料に対応した川幅の確保を目指した上で、社会的・自然的な制約を踏 |
| まえて川幅や法線を設定することが重要となる。また、河道の拡幅を行う場 |
| 合に、河岸の河畔林など河岸の自然環境が良好なときには、片岸を拡幅する |
| ことなどにより、出来る限りそのような河岸を保全することが重要となる。 |
|                                                                      |
| 設定した河道の平面形内の断面に                                       |
| おいて流下断面を大きくする必要のある場合には、低水路河床の掘削、低水 |
| 路幅の拡幅あるいは高水敷の掘削等を検討することになるが、いずれの場合 |
| においても河道の安定、河川管理施設等への影響、河川空間の利用、河川環 |
| 境への影響等を総合的に判断して適切な方法を採用することが必要となる。 |
|                                                                      |
| 低水路河床の掘削、低水路幅の拡幅あるいは高水敷の掘削等を行           |
| う必要がある場合には、新しく形成される低水路の横断形は、もともとの川 |
| の姿を参考に、河床変動による河積の変化に配慮するとともに、あわせて瀬 |
| や淵あるいは動植物の良好な生息・生育・繁殖環境の保全・復元を図ること |
| のできるよう、適切な河床あるいは河岸形状に設定することが必要となる。 |
|                                                                      |
| 特に、川                                                             |
| 幅が比較的狭い単断面の河川においては、河床掘削を実施した場合、河川環 |
| 境への影響や流速の変化に伴う河床変動への影響が相対的に大きいことから |
| 、河床掘削をなるべく避けるとともに、やむを得ず河床掘削を実施する場合 |
| においては掘削後の河床の安定について十分検討を行うことが必要となる。 |
|                                                                      |
| 多数の河川において河道特性が調査され、河床材料の大きさと             |
| 平均年最大流量の水理量との関係が整理されている。この関係は、河床材料 |
| の大きさに対して中長期的に安定する低水路幅を設定する上で有効である。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1)  [「多自然川づくり」の推進について](http://www.mlit.go.jp/notice/noticedata/pdf/200704/00004847.pdf)，平成18年10月13日，国河環第38号，国河治第86号，国河防第370号，国土交通省河川局長通達.

2)  [中小河川に関する河道計画の技術基準について](http://www.mlit.go.jp/river/kankyo/main/kankyou/tashizen/pdf/gijyutsukijyun.pdf)，平成22年8月9日，国河環第30号，国河域第7号，国河防第174号，国土交通省河川局河川環境課長，治水課長，防災課長通達.

＜参考となる資料＞

複断面河道の考え方については、下記の資料1)が参考となる。川幅が比較的狭い単断面の河川における河道の横断形を計画する際には、下記の資料2)が参考となる。河床材料の大きさに対して中長期的に安定する低水路川幅を設定する際には、下記の資料3)が参考となる。

1)  福岡捷二：洪水の水理と河道の設計法，森北出版， pp.101-102，2005．

2)  多自然川づくり研究会：多自然川づくりポイントブックⅢ，p.38-55，（財）リバーフロント整備センター，2011.

3)  山本晃一：沖積河川学，山海堂，pp.333-336，1994．

＜標　準＞

+----------------------------------------------------------------------+
| 河道計画においては、河道の横断形のすべてを計画                       |
| 事項として定めるというものではなく、堤防の高さ、高水敷の高さ・幅、管 |
| 理に必要とされる低水路河岸の位置など、必要な事項を定めるものである。 |
|                                                                      |
| 河道の横断形は、河道の平面形及び縦                                   |
| 断形、地形・地質、動植物の生息・生育・繁殖環境等を含む河川環境、沿川 |
| の土地利用状況等を勘案し、河道の流下能力を確保した上で土砂流送特性や |
| 長期的または局所的な河床変動を十分に考慮して定めることを基本とする。 |
+----------------------------------------------------------------------+

＜例　示＞

+----------------------------------------------------------------------+
| 1)  継続的な河床低下                                                 |
| 、局所洗掘や河岸侵食などが課題となっている河川において、みお筋部の深 |
| 掘れの緩和、中州の冠水頻度の増大を図ることを目的に、試行的に、流量規 |
| 模に応じて川幅が広がる自然河道断面に近い河道断面を設定した例がある。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

流量規模に応じて川幅が広がる自然河道断面に近い河道断面を試行的に設定した事例については、下記の資料が参考となる。

1)  笹木拓真、宮原幸嗣、福岡捷二：[複断面から船底型断面河道への改修による洪水流況及び低水路河床高の変化](http://library.jsce.or.jp/jsce/open/00906/2014/20-0277.pdf)，河川技術論文集，
    > Vol.20， pp.277-282， 2014.

```{=html}
<!-- -->
```
3.  堤防の高さ

＜考え方＞

+----------------------------------------------------------------------+
| 堤防は、目標とする河道配分流量以下の流水を越流させないよう設けるべき |
| であり、洪水時の波浪、うねり、跳水等による一時的な水位上昇に対し、堤 |
| 防の高さにしかるべき余裕をとることが必要となる。また、洪水時の巡視や |
| 水防活動を実施する場合の安全の確保、流木等流下物への対応等種々の要素 |
| をカバーするためにも、堤防にはしかるべき余裕をとることが必要となる。 |
|                                                                      |
| ま                                                                   |
| た、上流区間の堤防の高さを過度に高くした場合には、下流区間の安全上大 |
| きな問題となることなどから、河川の整備状況、目標とする河道配分流量流 |
| 下時の水位縦断形、堤内地の地盤高や土地利用状況等を勘案し、必要に応じ |
| て段階的な堤防の整備を検討することなどにより、水系全体の安全度や上下 |
| 流バランスの確保に配慮しながら堤防の高さを設定することが重要となる。 |
+----------------------------------------------------------------------+

＜標　準＞

  ----------------------------------------------------------------------------
  堤防の高さは、河川管理施設等構造令の規定に基づき設定することを基本とする。
  ----------------------------------------------------------------------------

4.  低水路河岸の位置及び高水敷の高さ・幅

＜考え方＞

+----------------------------------------------------------------------+
| 低水路河岸の位置及び                                                 |
| 高水敷の高さ・幅は一般に現状の河道形状を重視して定め、高水敷の高さは |
| 冠水頻度が数年に1回程度となるように流下能力を試算して定める場合が多  |
| いが、河道の縦横断形の変遷や維持、周辺の動植物の生息・生育・繁殖環境 |
| の保全・復元の重要性、植生等の将来的な遷移予測、工作物の設置状況、高 |
| 水敷の利用形態やその地域性等を総合的に勘案し定めることが重要である。 |
|                                                                      |
| 河道の平                                                             |
| 面形や砂州発生の有無等により、洪水時に河岸侵食を受けやすい区間と受け |
| にくい区間があることから、特に堤防及び高水敷を有する河川においては堤 |
| 防防護の観点から設定するライン(堤防防護ライン)と低水路河岸を安定化さ |
| せる観点から設定するライン(低水路河岸管理ライン)を設定し、これらのラ |
| インと現況横断を勘案して河岸侵食への対応を検討することが重要となる。 |
|                                                                      |
| また、洪水時の高水敷の安定を確保する観点から、                       |
| 高水敷上の流速が過度に大きくならないように留意することが重要となる。 |
|                                                                      |
| 1.  堤防防護ライン\                                                  |
|                                                                      |
| > 　洪水時の河岸侵食によって生ずる堤防の破壊を防止することを目的とし |
| て設定するラインである。したがってこのラインは、堤防区間の全川にわた |
| り設定する必要がある。一般に堤防防護ラインの位置は1洪水で堤防が危険  |
| な状況とならないような位置に設定することが必要となる。必要な高水敷の |
| 幅を確保できない場合には護岸等による河岸の防護で対処することになる。 |
|                                                                      |
| 2.  低水路河岸管理ライン\                                            |
|     > 　河道内において治水、利水、環境等の面から期待される機         |
| 能を確保するために、河岸侵食を防止する必要がある区間を示すものであり |
| 、低水路河岸を安定化させることを目的に必要に応じ設定するものである。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 低水                                                                 |
| 路河岸の位置及び高水敷の高さ・幅は、河道の維持、高水敷の冠水頻度、利 |
| 用、動植物の生息・生育・繁殖環境等を考慮して定めることを基本とする。 |
|                                                                      |
| また、特に堤防及び高水敷を                                           |
| 有する河川においては、堤防防護ラインや必要に応じて低水路河岸管理ライ |
| ンを設定し、低水路河岸の位置及び高水敷の幅を定めることを基本とする。 |
+----------------------------------------------------------------------+

＜例　示＞

+----------------------------------------------------------------------+
| 1)  水衝部の固定化や局所洗堀を緩和                                   |
| するために、巨石盛土によって低水路や砂州の形状を整正した事例がある。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

巨石盛土により砂州の形状を整正することで河岸を防護した事例については、下記の資料が参考となる。

1)  長田健吾、福岡捷二、氏家清彦：[急流河川における砂州を活かした治水と環境の調和した河道計画](http://library.jsce.or.jp/jsce/open/00906/2012/18-0227.pdf)，河川技術論文集，
    Vol.18，pp.227-232，2012．

```{=html}
<!-- -->
```
41) 北陸地方整備局河川部北陸急流河川研究会：[治水と環境の調和した新たな河岸防護技術の手引き～巨石付き盛土砂州を用いた河岸防護工～](http://www.hrr.mlit.go.jp/river/gsiryo/kagan_bougo/0_tebiki_v1.0_all.pdf)，平成25年3月．

    1.  []{#_Toc497347270 .anchor}支川の合流点形状

＜考え方＞

+----------------------------------------------------------------------+
| 合流点において                                                       |
| は、異なる流向・流速を持つ2つ以上の流れが合流するため、流況が通常の  |
| 河道区間より複雑になり、堤防沿いの高流速あるいは死水域、支川からの土 |
| 砂の流入、規模の大きな洗掘・堆積、流れの抵抗による上流側での水位上昇 |
| 等が生じる可能性があるため、これらが生じにくい形状とする必要がある。 |
|                                                                      |
| また、合流部の縦断形状の設定にあたっては、水面の                     |
| 連続性や河床の安定性を確保するよう努めるとともに、水生生物の自由な移 |
| 動の確保にも配慮することが必要となる。落差工を設置せざるを得ない場合 |
| は、水生生物の自由な移動を確保するための工夫を行うことが必要となる。 |
+----------------------------------------------------------------------+

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  支川の合流点の形状は、合流点の流況、土砂流送特性、洗掘・堆積状況を踏まえ、合流点前後における洪水流下を安定させ、河床の洗掘、堆積を防ぐため、本川になめらかに合流する形状とすることを基本とする。ただし、支川の目標とする河道配分流量が本川に比して極めて小さく、本川に対する合流の影響が小さい場合にはこの限りではない。また、合流部の縦断形状の設定に当たっては、水生生物の自由な移動の確保にも配慮することを基本とする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1)  [「多自然川づくり」の推進について](http://www.mlit.go.jp/notice/noticedata/pdf/200704/00004847.pdf)，平成18年10月13日，国河環第38号，国河治第86号，国河防第370号，国土交通省河川局長通達.

    1.  []{#_Toc497347273 .anchor}堤防に沿って設置する樹林帯

＜考え方＞

+----------------------------------------------------------------------+
| 堤防に沿って設置する                                                 |
| 樹林帯は、堤防の決壊・はん濫により著しい被害が生じるおそれのある場合 |
| に、越水時における洗掘の防止による堤防の決壊の防止、堤防の決壊時にお |
| けるはん濫流による決壊部の拡大の防止を図るために設置するものである。 |
|                                                                      |
| 樹林帯の整備に当たっては、周辺の植生等の                             |
| 自然環境や堤内地の土地利用と調和するように配慮することが重要である。 |
+----------------------------------------------------------------------+

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------
  堤防に沿って設置する樹林帯は、堤防の決壊・はん濫により著しい被害を生ずるおそれのある区間に対し、必要に応じて設置することを基本とする。
  ----------------------------------------------------------------------------------------------------------------------------------------

1.  []{#_Toc497347274 .anchor}河道の制御施設の計画

    1.  []{#_Toc497347275 .anchor}河道の制御施設計画の基本

＜考え方＞

+----------------------------------------------------------------------+
| 河道計画の検討においては                                             |
| 、流下能力を確保し、その河道が長期的に安定することが重要である。本節 |
| の1.5で設定した平面形、縦横断形等の下で、流下能力を確保できるよう堤  |
| 防を配置するとともに、長期的に河道が安定するよう、河道の侵食・洗掘・ |
| 堆積を防止・抑制するための構造物などの配置計画を検討する必要がある。 |
|                                                                      |
| 河道の制                                                             |
| 御施設の配置に当たっては、平常時及び洪水時の流水の挙動と河床・河岸形 |
| 状の変化特性、土質・地質特性、土砂流送特性を十分踏まえ、河道計画の中 |
| での位置付けと役割、優先順位や設置時期の判断基準を明確にし、所要の機 |
| 能を必要最小限の施設の新設や既設施設の改築で発揮させる方策を検討し、 |
| 良好な河川環境の整備・保全等を十分に考慮した措置を講ずる必要がある。 |
|                                                                      |
| なお、施設の設置がそ                                                 |
| の周辺の河床あるいは河岸の侵食を助長する場合があるので、洪水時の堤防 |
| の安全性の確保や河川環境の保全等の観点から十分に留意する必要がある。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 河道の制御施設としては、流水が河川外に流出することを                 |
| 防止するために設ける堤防のほか、堤防や河岸の侵食、河床の洗掘や堆積を |
| 制御するために設ける護岸、水制工、床止め（帯工、落差工）などがある。 |
|                                                                      |
| 河道の制御施設の計画に当たっては                                     |
| 、対象とする河川区間の河道の平面形及び縦横断形、河道特性、洪水流の流 |
| 況、地質、河川環境などを踏まえ、長期的または局所的な河川の変動特性を |
| 十分に考慮するとともに、各制御施設の特性を十分に理解した上で、経済的 |
| で河道制御の目的に最も適した制御施設を一つ若しくは各制御施設の組合せ |
| を選定し、設置する法線、設置箇所及び延長等を定めることを基本とする。 |
|                                                                      |
| その際、河川環境に与える効果、影響についても十分検討し、             |
| 河川環境にとって望ましい河道が維持されるようにすることを基本とする。 |
+----------------------------------------------------------------------+

＜推　奨＞

  -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  特に、比較的規模の小さい河川では、河道計画や河川環境における河道の制御施設の役割・影響が大きいため、過去の経験や類似河川の状況、既往の資料^参考となる資料1）^等を参考に適切な施設を計画することが望ましい。
  -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜参考となる資料＞

護岸については、下記の資料が参考となる。

1)  （財）国土技術研究センター：護岸の力学設計法（第 7 刷），2007

```{=html}
<!-- -->
```
42) （最新版）[（一財）国土技術研究センター：改訂
    護岸の力学設計法，2023．](https://www.jice.or.jp/tech/material/detail/21)

    1.  []{#_Toc508054562 .anchor}堤防の計画

＜考え方＞

+----------------------------------------------------------------------+
| 本節の1.1で記したように、河道                                        |
| とは、堤防又は河岸と河床で囲まれた部分を指すものであることから、堤防 |
| は、河道の平面形や横断形を制御し、河道を形成する根幹的な施設となる。 |
|                                                                      |
| 堤防は、流水が河川外に流出することを防止するため、護岸、             |
| 水制等の施設と一体となって、計画高水位以下の流水による侵食作用や浸透 |
| 作用に対して安全となるよう設けるとともに、目標とする河道配分流量以下 |
| の流水を越流させないよう設けるべきものであり、本節の1.5の河道の平面  |
| 形及び縦横断形の検討の中で、堤防の配置等を検討することが必要となる。 |
+----------------------------------------------------------------------+

＜標　準＞

  -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  堤防は、流水が河川外に流出することを防止するために設けるものであり、その配置を計画するに当たっては、本節の1.5で設定した河道の平面形及び縦横断形に基づき、設置箇所、法線、高さ等を定めることを基本とする。
  -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

2.  []{#_Toc497347276 .anchor}護岸の計画

＜考え方＞

+----------------------------------------------------------------------+
| 護岸には、堤防表のり面を保護し、堤防と一                             |
| 体となって河道の平面形や横断形を制御する高水護岸と、高水敷の河岸や掘 |
| 込河道の堤内地盤を保護し、低水路や掘込河道の平面形や横断形を制御する |
| 低水護岸がある。高水護岸と低水護岸が一体化したものを堤防護岸という。 |
|                                                                      |
| 護岸は河道の自然環境上重要な水際に                                   |
| 設けられるなど河川環境との関連が強いことから、その計画策定に当たって |
| は、必要性について十分に検討するとともに、護岸が必要な場合であっても |
| 、高水敷や水制の設置等の対策を併用するなどにより、動植物の良好な生息 |
| ・生育・繁殖環境の保全・復元、周辺の景観と調和した良好な景観の維持・ |
| 形成、人と河川との豊かな触れ合い活動の場の維持・形成等に適した計画と |
| することが重要である。また、河川の特質に応じて創意工夫を行うことによ |
| り、河川環境を十分考慮した経済的な護岸工法を見出すことが重要である。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 護岸は、高水敷やほかの構造物とともに流水による侵食作用から堤防       |
| (掘込河道にあっては堤内地)                                           |
| 、河岸を保護するために設けるもので                                   |
| あり、その配置を計画するに当たっては、高水敷幅等の河道の横断形、洪水 |
| 時の流水状況、みお筋の変化、背後地の地形・地質、土地利用等を十分に踏 |
| まえた上で、生物の生息・生育・繁殖環境と多様な河川景観の保全・創出に |
| 配慮して、その必要性(設置箇所)、法線、延長を定めることを基本とする。 |
|                                                                      |
| なお、橋梁、樋                                                       |
| 門、水門及び堰、床止め等の構造物の上下流には、河川管理施設等構造令及 |
| び同令施行規則に定めるところにより、必要な護岸を設置するものとする。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1)  [「多自然川づくり」の推進について](http://www.mlit.go.jp/notice/noticedata/pdf/200704/00004847.pdf)，平成18年10月13日，国河環第38号，国河治第86号，国河防第370号，国土交通省河川局長通達.

＜推　奨＞

+----------------------------------------------------------------------+
| 1)  川幅の比較的狭い単断面の河川                                     |
| では、護岸は、直接人の目に触れる部分を極力小さくすることが望ましい。 |
| なお、その護岸自体が川らしい景観を創出する場合は、その限りではない。 |
|                                                                      |
| ```{=html}                                                           |
| <!-- -->                                                             |
| ```                                                                  |
| 43) また                                                             |
| 、水際及び後背地を重要な生息空間とする生物が分布している場合は、護岸 |
| は、生息・生育・繁殖空間や移動経路としての機能を持つことが望ましい。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1)  [中小河川に関する河道計画の技術基準について](http://www.mlit.go.jp/river/kankyo/main/kankyou/tashizen/pdf/gijyutsukijyun.pdf)，平成22年8月9日，国河環第30号，国河域第7号，国河防第174号，国土交通省河川局河川環境課長，治水課長，防災課長通達.

    1.  []{#_Toc497347277 .anchor}水制の計画

＜考え方＞

+----------------------------------------------------------------------+
| 護岸と同様に、水制も河道の平面形や横断形を制御する施設であるが、次に |
| 挙げるとおり、護岸と異なる河岸保護の機能あるいは河岸付近の地形・流水 |
| 制御の機能を有するので、必要とされる治水上の効果と、河川環境の整備と |
| 保全上の効果及び影響等を十分に検討して、配置等を計画する必要がある。 |
|                                                                      |
| 1.  護岸は直接的に河岸を                                             |
| 被覆して侵食を防ぐのであるから、目的を確実に達成しやすい。一方、水制 |
| は水はね効果、流速低減効果によって、間接的に河岸の防御を図るものであ |
| るので、適切に配置や構造形式を決めないと効果が十分でないことがある。 |
|                                                                      |
| 2.  水制を適切に配                                                   |
| 置することによって平水時の川幅を狭め、平水時の水深を増大させることが |
| できるので、航路維持や河川環境の整備・保全のために設けることもある。 |
|                                                                      |
| 3.  水制の河岸への取付け部及びその下                                 |
| 流は、洪水時の複雑な流れによって侵食されやすいので配慮が必要である。 |
|                                                                      |
| 4.  水制と水制の間は、土砂が堆積し、植物の生育環境と                 |
| なるとともに、魚類等の水生生物が生息・生育・繁殖・避難する場となる。 |
+----------------------------------------------------------------------+

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  水制は、高水敷やほかの構造物とともに流水による侵食作用から堤防（掘込河道にあっては堤内地）、河岸を保護するために設けるものであり、その配置を計画するに当たっては、河道の平面形及び縦横断形、河道特性、河川環境等を踏まえ、動植物の生息・生育・繁殖環境、景観、流下能力への影響、上下流や対岸への影響等を十分に考慮して定めることを基本とする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  川幅が比較的狭い単断面の河川においては、特に河岸や水際部が河川環境に与える影響が相対的に大きいことから、同じのり勾配で平坦な河川にするのではなく、河道特性や自然環境上の特性を十分に踏まえ、水制工などを活用することによりできる限り縦断的・横断的に自然な変化をもつ河岸・水際部になるように努める。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1)  [中小河川に関する河道計画の技術基準について](http://www.mlit.go.jp/river/kankyo/main/kankyou/tashizen/pdf/gijyutsukijyun.pdf)，平成22年8月9日，国河環第30号，国河域第7号，国河防第174号，国土交通省河川局河川環境課長，治水課長，防災課長通達.

＜参考となる資料＞

川幅が比較的狭い単断面の河川において水制を計画する際には、下記の資料が参考となる。

1)  原田守啓、高岡広樹、大石哲也、萱場祐一：[新しい河道安定工法の実用化に向けた調査研究の取り組み](http://library.jsce.or.jp/jsce/open/00906/2013/19-0087.pdf)，河川技術論文集，vol.19,
    > pp87-92，2013．

    1.  []{#_Toc497347278 .anchor}床止めの計画

＜考え方＞

+----------------------------------------------------------------------+
| 流水の作用によって河床が侵食                                         |
| ・低下すると、護岸等の基礎が浮き上がり、治水上危険な状態になるととも |
| に、河床の低下に伴って各種用水の取入れが困難になる等の障害を生じる。 |
|                                                                      |
| 床止めは、このような場合に河                                         |
| 床を河川管理上必要な高さに維持し、安定させるために設けるものである。 |
|                                                                      |
| 床止めは、河川環境に及ぼす影響も大きく、また周辺の河                 |
| 床の安定にも十分な検討を要することから、できる限り設置しないことが望 |
| ましく、河床の安定のためにやむを得ない場合にのみ設置するものである。 |
|                                                                      |
| 特に、床止めは上下流の流                                             |
| 水の連続性を断ち、魚類等の遡上・降下等を阻害する形態となるため、床止 |
| めを設置する場合には、構造の工夫や魚道の設置等により、魚類等の遡上・ |
| 降下等に十分に配慮するとともに、長期にわたって機能を維持し、河床が安 |
| 定するよう、将来の維持管理についても十分に配慮することが必要となる。 |
|                                                                      |
| なお、魚道を設置する場合、対象地点の流況、床止め上下流の水位         |
| 変動の範囲、対象魚類等ごとの遡上時期、経路、降下時期等を十分検討の上 |
| 、対象魚類等が遡上・降下できるよう対象流量、水位、配置等を設定する。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 床止めは、河床の安定を図るためにやむを得ない場合に設置するものであり |
| 、その配置を計画するに当たっては、周辺の河岸や河川管理施設への影響、 |
| 維持管理、魚類等の遡上・降下等に十分配慮して定めることを基本とする。 |
|                                                                      |
| また、床止めの設置により遡上・降下する                               |
| 魚類等への影響が懸念される場合には、魚道を設置することを基本とする。 |
+----------------------------------------------------------------------+

1.  []{#_Toc497347279 .anchor}河口部の計画

    1.  []{#_Toc497347280 .anchor}河口部の計画の基本

＜考え方＞

+----------------------------------------------------------------------+
| 河口部の計画の主た                                                   |
| る内容は、河口部の河道計画と高潮対策・津波対策の計画とに大別される。 |
|                                                                      |
| 河道計画としては、河口部の計画高水位、平面形、縦横                   |
| 断形及び河口閉塞等の河口部における課題への対応等の検討が必要である。 |
|                                                                      |
| 高潮対策・津波対策を考慮す                                           |
| る必要がある場合には、海岸部の高潮対策・津波対策と整合のとれたものと |
| する必要がある。高潮対策・津波対策としては、河口部に水門を設ける場合 |
| と高潮区間・津波遡上区間を設定して堤防で対応する場合とに分けられる。 |
|                                                                      |
| 河口部は、河川と海との両方からの作用が                               |
| 働く場所であり、河川の流れ、潮汐流、波浪、流砂、漂砂等の影響を受け、 |
| 水理現象や土砂移動が非常に複雑となる。また、汽水域としての特徴、干潟 |
| としての特徴など、自然環境としても特徴を持った河川環境を有している。 |
|                                                                      |
| このため、河口部の計画に当たっては、調査編 第14章                    |
| 汽水域・河口域の環境調査等を参考に                                   |
| 適切な調査を行い、河川側と海側の両方の条件を総合的に勘案し、河口砂州 |
| や河床の変動等に伴う利水や舟航等への影響や維持管理等に留意しながら、 |
| 現地の自然環境とも調和した計画となるよう検討を行うことが重要である。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 河口部の計画に当たっては、河川及び海                                 |
| の両方の条件を十分考慮し、以下の事項に留意した上で、平面形、縦横断形 |
| 、河口部における課題への対応方法等を慎重に決定することを基本とする。 |
|                                                                      |
| 1.  目標とする河道配分流量を安全に流下できるものであること           |
|                                                                      |
| 2.  高潮対策・津波対策を考慮する必要がある場                         |
| 合には、施設設計の対象とする高潮・津波に十分対応できるものであること |
|                                                                      |
| 3.                                                                   |
| 全体の河道計画の中で、機能的、経済的にバランスのとれたものであること |
|                                                                      |
| 4.  河口あるいは海岸の自然のバランス                                 |
| （河川から海岸への土砂の供給等）を崩して2次的被害を発生させないこと  |
|                                                                      |
| 5.  長期間にわたって維持が容易であること                             |
|                                                                      |
| 6.  河口付近の利水や舟航等に支障を与えないこと                       |
|                                                                      |
| 7.  河川及び河口周辺海域の動植物の良好な生息・生育・繁殖             |
| 環境、良好な景観、人と河川との豊かな触れ合い活動の場を損なわないこと |
+----------------------------------------------------------------------+

＜関連通知等＞

1)  河川砂防技術基準調査編，平成26年4月，国土交通省水管理・国土保全局，[第14章
    > 汽水域・河口域の環境調査](http://www.mlit.go.jp/river/shishin_guideline/gijutsu/gijutsukijunn/chousa/pdf/14.pdf)，[第16章
    > 総合的な土砂管理のための調査](http://www.mlit.go.jp/river/shishin_guideline/gijutsu/gijutsukijunn/chousa/pdf/16.pdf)，[第21章
    > 海岸調査](http://www.mlit.go.jp/river/shishin_guideline/gijutsu/gijutsukijunn/chousa/pdf/21.pdf).

2)  [河川津波対策について](http://www.mlit.go.jp/river/shishin_guideline/kasen/pdf/kasen_tsunami_taisaku_h230902.pdf)，平成23年9月2日，国水河計第20号，国水治第35号，国土交通省水管理・国土保全局河川計画課長,治水課長通達.

＜推　奨＞

+----------------------------------------------------------------------+
| 河口部における水理現象や土砂移動                                     |
| 、改修工事等の効果・影響を把握することは技術的に難しい課題を有してい |
| ることから、十分な現地調査や類似河川の状況、洪水時の河口部の実績水位 |
| ハイドロや周辺の観測潮位等のデータ収集による流況や河床変動の分析等を |
| 踏まえ、考慮すべき条件や現象を適切に設定し、必要に応じて水理模型実験 |
| や数値シミュレーションを用いて河口部の計画を検討することが望ましい。 |
|                                                                      |
| また、河口部の環境特性に関する物理化                                 |
| 学的あるいは生態学的な知見は必ずしも十分とは言い難いので、類似河川の |
| 状況や過去の経験なども踏まえて慎重に調査・検討を行うことが望ましい。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

大きな潮位変動、小規模河床波の形成・発達・消滅、河口部に設置された導流堤等の様々な影響を受ける河口部の河道区間における洪水時の現象解明について検討した例としては、下記の資料が参考となる。

1)  岡村誠司、福岡捷二：[利根川河口区間における河床波の形成・発達・消滅過程と洪水中の河床波抵抗の評価](https://www.jstage.jst.go.jp/article/jscejhe/69/2/69_83/_pdf/-char/ja)，土木学会論文集B1(水工学)，Vol.69，No.2，pp.83-100，2013．

    1.  []{#_Toc497347282 .anchor}河口部における課題への対応方法の選定

＜考え方＞

+----------------------------------------------------------------------+
| 河川に                                                               |
| よっては、河口に砂州が発達し、流水の自由な流下が阻害されることがある |
| 。河口閉塞が生じることにより、以下のような障害が発生することがある。 |
|                                                                      |
| 1.  河口付近の水深とみお筋が一定せず舟航が困難となる。               |
|                                                                      |
| ```{=html}                                                           |
| <!-- -->                                                             |
| ```                                                                  |
| 8.  河口港の場合は、港内水深が浅くなり着船不良などの障害が起こる。   |
|                                                                      |
| 9.  洪水の疎通が阻害される。                                         |
|                                                                      |
| 10. 河口付近の背後地に排水不良が起こる。                             |
|                                                                      |
| ま                                                                   |
| た、河口閉塞が生じていない河川においても、塩水の遡上や潮汐の影響によ |
| る水位低下等により、河口付近の利水や舟航等に支障が生じることがある。 |
|                                                                      |
| このような河口部における課題に対しては、導流堤、水門等の施設の設置や |
| 砂州の開削等により対応する場合が多いが、河口部は、海岸及び河川で生起 |
| する種々の現象が同時に、あるいは別々に作用し合って非常に複雑である。 |
|                                                                      |
| 河口部における課題への対応                                           |
| 方法の選定に当たっては、施設の設置や砂州の開削等が河口に及ぼす影響に |
| ついて十分な検討を行い、河川と海の両方の影響を受けて河口部に成り立っ |
| ている自然のバランスを大きく損なうことのないよう塩性湿地、干潟、汽水 |
| 域等の重要性、沿岸漂砂や塩水遡上への影響等に十分な配慮が必要である。 |
+----------------------------------------------------------------------+

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  河口部における課題への主な対応方法としては、導流堤、水門、暗渠、砂州の開削等があり、その選定に当たっては、流量の変化等河川の特性、漂砂や潮流等河口部付近の海の特性、河口部の自然環境、経済性、長期間にわたる維持等を考慮して決定することを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

1.  []{#_Toc497347283 .anchor}河口部における課題への主な対応方法

```{=html}
<!-- -->
```
1.  導流堤

＜考え方＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  導流堤は、河口砂州部の漂砂と河道内の流れを制御することにより河口閉塞を防止・抑制する施設である。配置に当たっては、当該河口部における河川の流れ・流砂と沿岸の波浪・漂砂のメカニズムを踏まえて、設置目的が達成できるよう検討することが重要である。長さや配置等により、設置後の地形変化が異なるので、導流堤の計画に当たっては、その機能と河口部及びその周辺に与える影響を考慮する必要がある。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  導流堤は、河口位置の固定、みお筋の安定化、河口水深の維持、洪水時及び平水時の水位の低下などを目的に設置する施設であり、その配置を計画するに当たっては、その目的に応じた機能が十分発揮できるよう、また周辺海岸への影響を極力小さくするよう、長さ、間隔、方向、高さ、幅、構造等の検討を行うことを基本とする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜例　示＞

+----------------------------------------------------------------------+
| 導流堤の長さ、間隔、方向、高さ、幅、構造は、                         |
| 設置の目的、河口規模によって異なるが、一般に次のようなことがいえる。 |
|                                                                      |
| 1.  導流堤の長さ                                                     |
|                                                                      |
| 河口位置を偏流させず、河道幅の                                       |
| なかに開口位置を固定させたいときは、汀線位置の季節的変動を見極めた上 |
| で、干潮時汀線より多少海側まで導流堤を河道幅の間隔で両側に2本出す必  |
| 要がある。片側1本の場合は、ある程度海中にまで出せば沿岸漂砂の卓越方  |
| 向の上手側、下手側のどちら側に設置しても導流堤沿いに川筋が固定する。 |
|                                                                      |
| 河口部の水                                                           |
| 深をある程度の深さ以上にかつ開口幅を維持したい場合は、2本の導流堤を  |
| ある程度の深さの所まで突出させる必要がある。なお、全国の一級河川の導 |
| 流堤の先端部の水深とそこの河床変動を調べた結果では、外海に面している |
| 河川の場合、導流堤の先端水深が4～5mあればその水深をほぼ維持すること  |
| ができ、2～3mでは浅くなることがあり、1m以下では砂州が発生している。  |
|                                                                      |
| 導流堤の基部は、原則として堤防、護岸など                             |
| の構造物がある場合にはこれに接着させ、天然海岸、中導流堤の場合は、荒 |
| 天時に波が基部の背後に回り込まない位置まで河道側に延ばす必要がある。 |
|                                                                      |
| 11. 導流堤の間隔                                                     |
|                                                                      |
| 河口閉塞を防止する上で、導流堤の間隔は狭い方が河川の掃流力           |
| の増大を図ることになり、これによるフラッシュ効果は大きくなる。しかし |
| 、洪水疎通の面からは、導流堤間隔が狭いと河口部の水位上昇の原因となり |
| 、河道計画上問題が生じる場合もあるので、河口水位の変化、導流堤間隔と |
| 導流堤間の河床高の関係の検討結果に基づいて河口幅を決める必要がある。 |
|                                                                      |
| 12. 導流堤の方向                                                     |
|                                                                      |
| 汀線に対して導流堤の方向を大きく傾けると、導流堤で反射した波によ     |
| って汀線の後退等を生じることがある。さらに、流砂量の多い河川では流出 |
| 土砂を一方向だけに補給することになり、河口付近の海浜の土砂収支を変え |
| てしまうので、このような場合には十分な対策が必要となる。また、導流堤 |
| を急激に曲げると、洪水時に主流が突き当たり、深掘れの問題が生じる。こ |
| のようなことから、導流堤の方向は、汀線に対して直角とすることが一般的 |
| であり、沖合において緩やかに曲げたり、多少の角度を付ける場合もある。 |
|                                                                      |
| 13. 導流堤の高さ                                                     |
|                                                                      |
| 導流堤の高さは、砂州部では波が                                       |
| 導流堤の天端を乗り越えて河道内に砂が持ち込まれないように、最高砂州高 |
| より1m以上の高さにする必要がある。飛砂の多いところではその対策も考え |
| ておく必要がある。海側の導流堤先端部の高さは、高波浪時の越波は許容さ |
| れるが、一般には朔望平均満潮位より約2m以上の高さとしている例が多い。 |
|                                                                      |
| 14. 導流堤の幅と構造                                                 |
|                                                                      |
| 導流堤の幅                                                           |
| は、導流堤の構造によって決まるものであり、波と河川流(洪水流)に対して |
| 破壊されないだけの十分な構造とし、必要に応じて根固め、消波工を設ける |
| 。なお、導流堤の構造は、不透過にした方が河口位置を固定しやすく、また |
| 漂砂を阻止することができ効果的である。ただし、透過性のある導流堤でも |
| 幅を広くし、空隙を小さくすれば不透過と同様の効果を得ることができる。 |
+----------------------------------------------------------------------+

5.  水門

＜考え方＞

+----------------------------------------------------------------------+
| 水門は、導流堤の設置、砂州の開削、河道                               |
| 掘削と組み合わせて、塩水遡上や波浪・高潮・津波の侵入あるいは潮汐の影 |
| 響による水位低下への対策として設置する場合が多く、暗渠放流口に閉塞す |
| る土砂を上流に水をためてフラッシュ放流するために設置する場合もある。 |
|                                                                      |
| 土砂埋塞による操作への支障、過大                                     |
| な波力の作用、砂礫衝突による劣化等の影響を受けにくくなるよう、汀線変 |
| 化の激しい海浜に設置する場合は、設置位置を十分に検討する必要がある。 |
|                                                                      |
| 計画規模の小さい河川では、河口                                       |
| のやや上流部に水門とポンプを設け、ポンプ排水と併用している例が多い。 |
+----------------------------------------------------------------------+

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  水門は、塩水・波浪・高潮及び津波の侵入防止、上流の水位維持、暗渠閉塞土砂のフラッシュ放流等を目的に設置するものであり、目標とする河道配分流量の疎通に支障を与えないように、設置目的に応じて設置位置等の検討を行うことを基本とする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

6.  暗渠

＜考え方＞

+----------------------------------------------------------------------+
| 暗渠は、流量規模の小さい河川において河口部が標高の高い砂             |
| 丘・海浜にあり、掘削してもすぐに河口や河道が閉塞することなどにより、 |
| 開水路で河道を維持することが困難な場所に用いられることが多い。また、 |
| 暗渠とすることにより海浜を分断しないので、利用への影響を軽減できる。 |
|                                                                      |
| 上流端に水門を設け、                                                 |
| 暗渠内に土砂が堆積した場合のフラッシュ効果を高めたり、砂州高を低く抑 |
| えるために河口周辺に到達する波浪を低減させる離岸堤を設け、その背後に |
| 暗渠を設置するなど、他の河川構造物との併用による対策が効果的である。 |
|                                                                      |
| 暗渠先端部は、作                                                     |
| 用する波力が大きく、波により著しく洗掘されるので十分な対策が必要とな |
| る。特に急勾配の砂礫海岸に暗渠を伸ばすと、漂砂下手側へ侵食が及ぶこと |
| から、計画時においてはこの点についても十分検討することが必要となる。 |
+----------------------------------------------------------------------+

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------
  暗渠は、河口砂州の部分を貫通させ、河川水を海に流出させることを目的に設置する施設であり、その機能が十分得られるよう、設置方向、長さ等の検討を行うことを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜例　示＞

+----------------------------------------------------------------------+
| 暗渠の設置方向、長さについては、一般に次のようなことがいえる。       |
|                                                                      |
| 1.  暗渠の設置方向                                                   |
|                                                                      |
| 暗渠本体の設置方向は、海岸の汀線に直角とした方が長さが短             |
| く経済的であり、特殊な条件の場合以外は汀線に直角とすることが一般的で |
| ある。暗渠先端の開口部は、波が直接暗渠内に侵入しないように曲がりを付 |
| け、開口部の方向は、沿岸漂砂が卓越している海岸では漂砂の下手側方向へ |
| 向けることが一般的である。波の入射方向の変動に伴って沿岸漂砂が変動す |
| る場合は、暗渠を2連あるいは4連とし、開口部を両方向としておくとよい。 |
|                                                                      |
| 2.  暗渠の長さ                                                       |
|                                                                      |
| 暗渠の上流端                                                         |
| は、海浜部の上流側とし、波のうちあげによる影響を受けない位置とするこ |
| とが一般的である。暗渠敷高は、高い方が暗渠内の堆砂防止に有利である。 |
|                                                                      |
| 暗渠の先端は、汀線変動を把握し、開口部が埋没                         |
| しない位置とする必要がある。なお、砂州部上流河道の河床高が低く、暗渠 |
| 敷高を高くできない場合は、先端部が海床高より高い位置となる海中まで延 |
| ばす必要がある。このとき洪水時の河川水位と潮位との差が大きくないと、 |
| 暗渠内に堆砂した場合フラッシュされないおそれがあるので注意を要する。 |
+----------------------------------------------------------------------+

7.  砂州の開削

＜考え方＞

+----------------------------------------------------------------------+
| 一般的に、河口砂州は、洪水によりフラッシュした後、波浪の作           |
| 用による左右岸の海岸からの沿岸漂砂、沖側の河口テラスからの岸沖漂砂、 |
| あるいはその両方により再形成される。砂州の開削により、河口閉塞の対策 |
| を行う方法としては、河口を大規模に掘削して水深と川幅を維持する方法と |
| 河口砂州の一部を開削し、洪水時の砂州のフラッシュを容                 |
| 易に進行させ、河口水位の上昇を防止する方法がある。どちらの方法が良い |
| かは、対象とする河口の河口砂州の形成要因を分析して決める必要がある。 |
|                                                                      |
| 河口                                                                 |
| を大規模に掘削して河積を維持する方法は、内湾などで波の作用が比較的小 |
| さく、掘削後の漂砂による再堆積が少ない場合に適している。外洋に面して |
| 波の作用が強く、漂砂による河床上昇が生じる河口では、導流堤との併用が |
| 必要である。また、大規模な掘削は、周辺の海岸侵食の原因となる場合があ |
| るので、その場合掘削土砂を侵食海岸に供給するなどの対策が必要となる。 |
|                                                                      |
| 河口砂州のフラッシュを容                                             |
| 易にするための開削は、河口砂州の一部または全部の砂州頂高を自然状態よ |
| り低くし、洪水初期に砂州をフラッシュさせようとするものである。ただし |
| 、太平洋岸で台風が接近してくる場合のように、洪水前に周期の長い高波が |
| 来襲すると、河口砂州を遡上・降下する波によって沿岸・岸沖方向の漂砂が |
| 発生し、砂州開削部が均されてしまう場合があることに留意が必要である。 |
|                                                                      |
| なお、河口の大規模掘削や河口砂州の一部開削を計画する場合は、砂       |
| 州開削部や掘削河道をどの程度維持できるかを確認することが重要である。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 砂州の開削は、                                                       |
| 河口の水深と川幅を維持することや、洪水時の砂州のフラッシュを容       |
| 易に進行させ河口水位の上昇を防止することを目的に実施するものである。 |
|                                                                      |
| 砂州の開削に当たっては、開削部の                                     |
| 長期的な維持や周辺の自然環境への影響を十分検討することを基本とする。 |
+----------------------------------------------------------------------+

1.  []{#_Toc497347284 .anchor}河道計画と維持管理

    1.  []{#_Toc497347285 .anchor}維持管理を見据えた河道計画の検討

＜考え方＞

+----------------------------------------------------------------------+
| 河川管理におい                                                       |
| ては、調査、計画、設計、施工、維持管理の各プロセスにおける検討結果や |
| 留意点等を次のプロセスに適切に引き継ぎ、反映させることが重要である。 |
|                                                                      |
| 河道は、出水や日常的な流水の作                                       |
| 用による河床変動、樹木の成長や樹木群落の範囲拡大等により様々に変化す |
| るものであり、河道の整備後の様々な変状に対しては、維持管理により対応 |
| することとなる。そのため、河道計画の検討に当たっては、その後の設計や |
| 施工だけではなく、維持管理も見据えながら検討を行い、現況河道の課題を |
| 踏まえて、顕著な河床変動や樹林化の進行等が生じにくく、維持管理しやす |
| い河道となるように計画することが重要である。また、河道の平面形や縦横 |
| 断形の設定と河道の制御施設の配置には相互作用があること、上流から供給 |
| される土砂の量や質が河床変動に影響を与えることに留意する必要がある。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 河道の平面形、                                                       |
| 縦横断形、河道の制御施設の構造や配置等の検討に当たっては、長期的視点 |
| で維持管理に要するコストにも配慮し、以下に留意することを基本とする。 |
|                                                                      |
| 1.  土砂の堆積や樹林化による流下能力の低下が生じにくい河道とすること |
|                                                                      |
| 2.  河床低下による河川管理施設                                       |
| の基礎の洗掘等、河川管理施設の安定性の低下が生じにくい河道とすること |
|                                                                      |
| 3.  河岸侵食による堤防の安全性の低下が生じにくい河道とすること       |
+----------------------------------------------------------------------+

＜推　奨＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  維持管理しやすい河道計画とするため、改修後の河道について、河道形状や植生分布の変化を予測することが望ましい。その際、目標とする治水・利水・環境機能を維持するために必要となる維持管理対策の内容を設定し、その労力（頻度・コスト等）を試算することで維持管理の容易さを確認するとよい。なお、試算に当たっては、上流から供給される土砂の量や質を数通り変化させ、河床変動に与える影響を確認することが望ましい。予測の結果、顕著な河床変動、樹林化の進行、維持管理コストの増大等が懸念される場合には、河道の平面形、縦横断形、河道の制御施設の構造や配置等を見直すものとする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜例　示＞

+----------------------------------------------------------------------+
| 河道形状や植生分布の変化を予測するためには、以下の方法がある。       |
|                                                                      |
| 1.  水位、摩擦速度、掃流力等の各種水理量の縦断分布による河床高の     |
| 変化傾向の予測、横断面内のかく乱頻度の変化による植生の変化傾向の予測 |
|                                                                      |
| 2.  植生の拡大や流                                                   |
| 失を表現することが可能な河床変動計算による河床高や植生分布の変化予測 |
|                                                                      |
| 3.  過去に実施された河川整備、維持管理対                             |
| 策に対する河道の応答特性に基づく河床形状及び植生分布の変化傾向の予測 |
+----------------------------------------------------------------------+

＜関連通知等＞

1)  [河川砂防技術基準調査編](http://www.mlit.go.jp/river/shishin_guideline/gijutsu/gijutsukijunn/chousa/)，平成26年4月，国土交通省水管理・国土保全局，第4章
    > 河道特性調査，第6章 河床変動、河床材料変化及び土砂流送の解析.

＜参考となる資料＞

摩擦速度の縦断分布によって河床高の変化傾向を予測した事例としては、下記の資料1）が参考となる。植生の拡大や流失を表現可能な河床変動計算モデルにより河床高や植生分布を予測した事例としては、下記の資料2）が参考となる。河道の応答特性に基づいて河床形状や植生分布の変化を予測した事例としては、下記の資料3）が参考となる。

1)  佐藤慶太、武内慶了、服部敦：[水理量縦断分布に基づく礫床河道掘削後の河道変化要因分析と事前察知の可能性](http://library.jsce.or.jp/jsce/open/00906/2010/16-0155.pdf)，河川技術論文集，
    > Vol.16， pp.155-160， 2010．

2)  大沼克弘、武内慶了、今村能之、藤田光一、西本尚史、平井新太郎、宮内信：[セグメント2河道を対象とした河道掘削後の戦略的維持管理に関する研究](http://library.jsce.or.jp/jsce/open/00906/2009/15-0291.pdf)，河川技術論文集，
    > Vol.15， pp.291-296， 2009．

3)  藤田光一、田上敏博、天野邦彦、服部敦、浦山洋一、大沼克弘、武内慶了：[現場での実践を通して河道管理技術を向上させる先駆的取り組み](http://library.jsce.or.jp/jsce/open/00906/2011/17-0539.pdf)，河川技術論文集，
    > Vol.17， pp.539-544， 2011．

＜例　示＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  河道掘削を計画する場合には、河道への土砂の堆積が生じたとしても目標とする河道配分流量が流下可能となる河積を維持するため、土砂の堆積空間としての河積（以下、「マージン」という。）を試行的に設けた事例がある。このマージンの設定のため、堆積傾向にある河道区間やその変動量について、計画段階で把握・整理している。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜参考となる資料＞

流下能力にマージンを持たせた管理の考え方については、下記の資料が参考となる。

1)  国土技術政策総合研究所：[流下能力にマージンを持たせた管理の考え方と具体的手法](http://www.nilim.go.jp/lab/bcg/siryou/2011report/2011nilim21.pdf)，国総研レポート2011，p35．

    1.  []{#_Toc497347286 .anchor}河道の変動特性の維持管理への反映

＜考え方＞

  ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  本節の1.8.1の検討によって、顕著な河床変動や樹林化の進行等が生じにくい河道を計画し、それに基づいて設計・施工された場合においても、出水や日常的な作用を受け、維持管理が必要となる。そこで、河川の巡視、点検による状態把握、維持管理対策を効果的かつ効率的に実施し、河道の治水・利水・環境機能を長期にわたって維持するため、河道の変動特性等を踏まえた維持管理上の留意点を河川維持管理計画に反映することが重要である。
  ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

  ----------------------------------------------------------------------------------------------------
  河道計画の検討により明らかとなった維持管理上の留意点を河川維持管理計画に反映することを基本とする。
  ----------------------------------------------------------------------------------------------------

＜推　奨＞

+----------------------------------------------------------------------+
| 維持管理上の留意点としては、以下の事項が考えられる。留意する事項と区 |
| 間を明らかにして、河川維持管理計画に具体的に記載することが望ましい。 |
|                                                                      |
| 1.  土砂の堆積による流下能力の低下                                   |
|                                                                      |
| 2.  河床低下や局所洗掘による護岸等の河川管理施設の不安定化           |
|                                                                      |
| 3.  再樹林化による流下能力の低下                                     |
|                                                                      |
| 4.  砂州の発達に伴う偏流の発達による側方侵食の発生　　　等           |
+----------------------------------------------------------------------+

1.  []{#_Toc497347287 .anchor}維持管理を踏まえた河道計画の見直し

＜考え方＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  河川維持管理計画に基づく維持管理によっては、目標とする治水機能等を維持できない場合や、維持管理に多大なコストを要する場合には、河道の状態把握結果や分析結果等に基づいて河道計画を再検討することが重要である。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------
  河道の状況や維持管理の状況を適切に把握・評価し、その結果も踏まえて、適宜、河道計画の点検を行い、必要に応じて見直すことを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

+----------------------------------------------------------------------+
| 河道の変化を把握し、出水の発生状況を時系列に整理した上で、河道       |
| の変化が生じた時の出水の特徴を整理するなどして、河道の変化要因を分析 |
| する。こうした分析結果を踏まえ、必要に応じて河道計画の見直しを行う。 |
|                                                                      |
| なお、河道の状態把握の結果を分析                                     |
| ・評価するに当たっては、個々の施設や被災箇所周辺の河道に限定せず、施 |
| 設周辺の河道の変化、上下流区間の河道の変化についても合わせて確認する |
| ことが望ましい。具体的には、施設周辺の河床が洗掘されることで施設に被 |
| 害が生じたり、堰等の河川横断構造物の撤去に伴い上流区間の河床が低下し |
| 護岸等に被害が生じたりすることがある。一連区間で生じた個々の変化要因 |
| を分析することに加え、各種の変状が相互に関連する可能性があることを念 |
| 頭に置くことで、河道の変化要因をより適切に評価することが可能となる。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1)  河川砂防技術基準維持管理編（河川編），平成27年3月，国土交通省水管理・国土保全局.

```{=html}
<!-- -->
```
44) （最新版）河川砂防技術基準維持管理編（河川編），令和3年10月，国土交通省水管理・国土保全局.

```{=html}
<!-- -->
```
4)  堤防等河川管理施設及び河道の点検要領，平成28年3月，国土交通省水管理・国土保全局河川環境課.

```{=html}
<!-- -->
```
45) （最新版）堤防等河川管理施設及び河道の点検・評価要領，令和5年3月，国土交通省水管理・国土保全局河川環境課.

```{=html}
<!-- -->
```
5)  直轄河川管理基図の作成要領等について，平成19年10月30日，国河治第71号，国土交通省水管理・国土保全局治水課長．

施設配置等計画編

**第2章 河川施設配置計画**

**第2-1章 河道並びに河川構造物**

**第2節 捷水路及び放水路**

目　次 {#目-次-2 .TOC-Heading}
======

[第2節 捷水路及び放水路 1](#_Toc507429153)

[2．1 捷水路及び放水路の計画 1](#_Toc507429154)

[2．2 トンネル構造による河川 2](#_Toc2677523)

[2．2．1 計画の基本 2](#_Toc2677524)

[2．2．2 断面及び縦断勾配 3](#_Toc507429160)

平成31年3月　版

4.  

```{=html}
<!-- -->
```
2.  河川施設配置計画

    2.  第2-1章 河道並びに河川構造物

        2.  []{#_Toc507429153 .anchor}捷水路及び放水路

        ```{=html}
        <!-- -->
        ```
        1.  []{#_Toc507429154 .anchor}捷水路及び放水路の計画

＜考え方＞

+----------------------------------------------------------------------+
| 捷水路(あるいはショート・カッ                                        |
| ト)とは、著しく屈曲した河道を、新川の整備により短絡する水路をいう。  |
|                                                                      |
| 放水路(あるいは分水路)とは、洪水の一部又は全部を河川の途中から       |
| 分岐して、直接海、ほかの河川あるいは元の本川等に放流する水路をいう。 |
|                                                                      |
| 大河川において、激しい蛇行・屈曲                                     |
| 区間が数多く存在していた頃、大規模な捷水路工事が数多く実施された。し |
| かし、現在では、大河川の主要な区間については、改修工事の進捗の結果、 |
| 河川の平面形状がほぼ固定されてきたので、大規模な捷水路工事はほとんど |
| 見受けられない。一方、中小河川の改修工事においては、著しく屈曲した河 |
| 道に対して、比較的最近まで数多くの捷水路工事が実施されている。また、 |
| 放水路計画において地形上あるいは土地利用上の制約等から、やむを得ずト |
| ンネル構造による河川が計画されることが特に大都市部ではまれではない。 |
|                                                                      |
| このほか、支川の                                                     |
| 合流処理方法として、本川の背水の影響を軽減させるために合流点を付け替 |
| える場合や、支川の山地流域からの洪水流量をできるだけ短絡させ処理する |
| ために合流点を付け替える場合があり、この場合も新川の整備が行われる。 |
+----------------------------------------------------------------------+

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  捷水路及び放水路などの新川の設定に当たっては、洪水の安全な流下を図るとともに、新川及び周辺の環境、現在及び将来の社会環境、周辺の地下水位、地下水の水質、用排水路系統、堤内地の内水対策、新川の整備後の河道の維持管理等を考慮するとともに、放流先水域の環境への影響や分流元河川の環境への影響についても検討し、適切な計画を策定するものとする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

+----------------------------------------------------------------------+
| 1.  　捷水路では、                                                   |
| 河道延長が短縮するので従来より河床勾配が急になる。したがって、湾曲し |
| ている現状で河床が安定している河川においては、その安定を崩すことにな |
| る。例えば、上流部で流速が増加することにより、洗掘が生じて構造物を危 |
| 険にし、下流部では堆積を起こして水位上昇を招くことなどが考えられる。 |
|                                                                      |
| > したがって、捷水路を計画する場合、捷水路区間の                     |
| みではなく、その上流側及び下流側の相当の区間について、河床勾配、河道 |
| の法線、横断形の改良を同時に計画するものとする。このため、上下流を含 |
| む区間における河道の形状、河床勾配、構造物、河床材料、流況等、河床変 |
| 動に関する基礎調査を行い、計画された新しい河道による河床変動の予測を |
| 行い新河道の修正と予測計算を繰り返して最適な計画を見出す必要がある。 |
|                                                                      |
| 2.  　放水路の計画に当たっては、洪水の安全な                         |
| 流下を図るとともに、周辺環境、社会環境、地下水位、地下水の水質、用排 |
| 水路系統、内水対策、土砂堆積、河道維持等を考慮し、放流先水域の環境へ |
| の影響や分流元河川への影響、経済性についても十分検討するものとする。 |
| また、放水路区間のみではなく、分流点上下流の相当の区間について、河床 |
| 勾配、河道の法線、横断形、構造物の改良等を同時に計画するものとする。 |
|                                                                      |
| ```{=html}                                                           |
| <!-- -->                                                             |
| ```                                                                  |
| a)  分流方式は、自然分流によるのか、固定堰あるいは水門               |
| などの構造物によるのかを決定し、構造物を設置する場合は、本川側に設置 |
| するのか、放水路側に設置するのか、あるいは両側に必要なのかを決める。 |
|                                                                      |
| b)  縦断形については、                                               |
| 捷水路の場合と同じく、一般に放水路区間はその上下流より急勾配となり、 |
| また、河床材料が著しく異なることから通水による河床変動が大きくなる場 |
| 合が多く、洪水エネルギーの滅殺方法を十分検討するとともに、橋梁、護岸 |
| 等の根入れを深くするなど、構造物の安全対策を慎重に検討すべきである。 |
|                                                                      |
| c)  放                                                               |
| 水路への分流の影響により、分流点上流で水面勾配が大きく変化することで |
| 河床洗掘が生じ、分流点前面や放水路区間では、放水路への分流により土砂 |
| の流送能力が低下することで土砂堆積が生じることなどが考えられる。この |
| ため、分流点近傍及び本川の分流点上下流区間の水位・流速や河床の変化等 |
| について、水理解析や河床変動解析により事前に検討することが望ましい。 |
|                                                                      |
| d)  放水路                                                           |
| による分流により、本川河口及び周辺海岸への供給土砂が減少すると想定さ |
| れる場合、本川河口及び周辺海岸の侵食を招くおそれがあるので留意する。 |
|                                                                      |
| e)  高水分流を目的とした放水路では、本川の                           |
| 水利用に支障を与えないように低水分流は行わないのが通例ではあるが、豊 |
| 水時の浄化用水導入など非洪水時の河川機能についても検討すべきである。 |
|                                                                      |
| ```{=html}                                                           |
| <!-- -->                                                             |
| ```                                                                  |
| 3.                                                                   |
| 　捷水路、放水路等の新川を開削する場合には堤内地の内水対策について十 |
| 分に配慮して新たな内水問題が起こらないように努める必要がある。このた |
| め、特に沿川流域の排水路系統を十分に把握しておかなければならない。\  |
|     　築堤区間については内水対策について検討して現状の               |
| 排水機能を損なわないように努めるものとする。また、上下流の河道の条件 |
| が可能ならばできるだけ掘込河道となるように河道を設定すべきである。こ |
| の場合新川の沿川流域からの流出も計画高水流量に算入するものとする。\  |
|     　なお、地下水位や地下水質への影響について                       |
| もあらかじめ十分調査し、著しい障害が生じないよう配慮する必要がある。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

放水路への洪水分派に伴う分派点付近の本川河床変動の解析を行った事例としては、下記資料1)が参考となる。

1)  岡田裕之介、大吉雄人、福岡捷二：[斐伊川放水路への洪水分派に伴う分派点付近の本川河床変動に関する研究](http://c-faculty.chuo-u.ac.jp/~sfuku/sfuku/paper/1858%20Okada%20Yunosuke.pdf)，河川技術論文集，第20巻，2014年6月.

    1.  []{#_Toc2677523 .anchor}トンネル構造による河川

        1.  []{#_Toc2677524 .anchor}計画の基本

＜考え方＞

+----------------------------------------------------------------------+
| トンネル構造による河川とは、河川流量の一部または全量を流下、も       |
| しくは河川流量を低減させる目的で設置されるトンネル構造の河川である。 |
|                                                                      |
| トンネル構造に                                                       |
| よる河川は、洪水時における流下物などによる断面の閉塞など、河道維持の |
| 上では通常の河川に比べて課題が多い。さらには、人為操作が加わる場合も |
| あるなど管理面での課題も挙げられる。このため、河道計画において捷水路 |
| や放水路を計画する場合には、できるだけトンネル構造による河川としない |
| ことが望まれる。しかしながら、現状の河川の下流部が都市化していて十分 |
| な河道拡幅が不可能であり、分水路も家屋密集地帯を通さなければならない |
| か、地形上開水路の選定が不可能である場合には、河道拡幅等に伴う都市機 |
| 能等への影響の大きさ、治水事業の緊急性、河川環境の向上、施工性、経済 |
| 性等に十分配慮した上で代替案との比較のなかで検討しなければならない。 |
|                                                                      |
| トンネル構造による河川を導入                                         |
| したことによって、何らかの事態でトンネル構造による河川が使用不能にな |
| った場合においても、現状より不利になることがないよう、特にやむを得な |
| い場合を除き現状河道は確保するものとする。現状の河道を確保することの |
| 意義は、都市域における貴重な水辺空間を保持する観点からも重要である。 |
| 都市域における河川は、他の都市的土地利用と比較すると、その規模と連続 |
| 性において極めて優れ、かつ多様な環境機能に富んだ空間を形成している。 |
| したがって、トンネル構造による河川の導入により、土地の高度利用の名目 |
| から現状河道を安易に廃止、縮小することは決して好ましいものではない。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| トンネル構造による河川は、地形の状況                                 |
| 、そのほか特別の理由によりやむを得ない場合に限り設けるものとし、ルー |
| トは、地形・地質条件、地上の利用条件、地下埋設物等の調査を行って決定 |
| するものとする。なお、線形は著しい屈曲を避けるよう定めるものとする。 |
|                                                                      |
| また、特にやむを得ない場合を除き現状河道は確保するものとする。       |
+----------------------------------------------------------------------+

＜推　奨＞

代替案との比較検討の結果、トンネル構造による河川を整備することとなった場合、その完成には通常長期間を要するので、施工分割ごとに暫定的な運用を行い、事業の効果を早期に発揮させるため、施工の分割と施工性、工程、他の治水対策の整備状況との関連等を十分に検討し、貯留施設として部分的に運用を開始するなど、最も効果的な段階整備計画を立案することが望ましい。

＜例　示＞

土地利用の高度化・複雑化が進んでいる大都市地域においては、事業を地上や浅い地下（浅深度地下）において効率的・効果的に行うことが難しい傾向にあることから、土地所有者等による通常の利用が行われない大深度地下の利用が進められつつある。河川事業においても、トンネル構造による地下河川の整備にあたり、事業進捗を図るため、ルート・構造、大深度地下の特定、事業施行に伴う環境保全対策等について検討を行い、大深度地下使用認可の申請が行われた事例がある。

＜参考となる資料＞

　トンネル構造による河川（放水路）の整備事例としては、下記資料1)が参考となる。トンネル構造による河川の段階整備計画の考え方については、下記の資料2)が参考となる。

1)  [日下川の内水対策について](http://www.skr.mlit.go.jp/kochi/niyodoseibikeikaku/conference/learn04/07.pdf)（[第4回　仁淀川流域学識者会議資料-5）](http://www.skr.mlit.go.jp/kochi/niyodoseibikeikaku/conference/learn04/07.pdf),平成27年1月28日,国土交通省
    四国地方整備局・高知県.

2)  (財)国土開発技術研究センター：[都市河川計画の手引き－立体河川施設計画編－](http://www.jice.or.jp/cms/kokudo/pdf/tech/material/toshikasenkeikaku.pdf),平成7年4月.

    1.  []{#_Toc507429160 .anchor}断面及び縦断勾配

＜標　準＞

+----------------------------------------------------------------------+
| トンネルの断面は、設計流量の流下                                     |
| に必要な断面積のほかに、原則として十分な空面積を確保するものとする。 |
|                                                                      |
| さらに、トンネルの縦断勾配は、洪水処理機能の確保                     |
| 、水理的な安定性、維持管理上の観点から適切な勾配を決めるものとする。 |
+----------------------------------------------------------------------+

＜推　奨＞

+----------------------------------------------------------------------+
| 1.  断面                                                             |
|                                                                      |
| 開水路方式のトンネルの場合は、流木、浮遊ゴミ等の                     |
| 流下による疎通障害や高速水流が流れると空気圧が低下する。このため、十 |
| 分空気が補給でき、空気流の流下ができるように設計流量の流下に必要な断 |
| 面積の15%程度を下回らない値を標準として空面積を確保する必要がある。  |
|                                                                      |
| 圧力管方式のトンネルについては、流下能力、空気混入量、               |
| 負圧の発生状況、止水性、サージング現象及び覆工計画等を考慮して断面形 |
| を設定するものとし、維持管理の状況に応じてインバートを設ける。圧力管 |
| 方式の場合については、混入空気の状況を模型実験などにより十分把握する |
| とともに、必要に応じて、土砂、流木、浮遊ゴミなどの地先の特性を考慮し |
| た適切な断面割増を行うものとする。さらに、空気混入を極力減ずるための |
| 呑口部や流入部の形状、管内からの空気抜き等の対策工を施す必要がある。 |
|                                                                      |
| 2.  縦断勾配                                                         |
|                                                                      |
| トンネル本体の縦断勾配が適当で                                       |
| ない場合には、緩勾配の区間で堆積の生じるおそれがある。したがって、全 |
| 区間にわたり掃流力のバランスを考慮して縦断勾配を設定する必要がある。 |
|                                                                      |
| 圧力管方式のトンネル内の流速は、水路勾配に無関係で、動               |
| 水勾配に関係するため、縦断勾配は維持管理面から決定される要素が強い。 |
|                                                                      |
| 圧力管方式の運用において、洪水後のトンネル内残留水の排水を下流       |
| 端ポンプ場より行う場合は、下流側を低くした勾配とすることが望ましい。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

トンネル構造による河川の断面及び縦断勾配の計画については、下記の資料が参考となる。

1)  (財)国土開発技術研究センター：[都市河川計画の手引き－立体河川施設計画編－](http://www.jice.or.jp/cms/kokudo/pdf/tech/material/toshikasenkeikaku.pdf),平成7年4月.

施設配置等計画編

**第2章 河川施設配置計画**

**第2-1章 河道並びに河川構造物**

**第3節 貯水池（ダム）**

目　次 {#目-次-3 .TOC-Heading}
======

[第3節 貯水池（ダム） 1](#_Toc2677498)

[3．1 洪水調節計画 1](#_Toc2677499)

[3．1．1 ダムの計画高水流量 1](#_Toc2677500)

[3．1．2 洪水調節方式 1](#_Toc2677501)

[3．1．3 洪水調節容量 2](#_Toc2677502)

[3．2 そのほかの計画 3](#_Toc2677503)

[3．2．1 流入土砂対策に関する計画 3](#_Toc2677504)

[3．2．2 貯水池周辺の地すべり防止計画 3](#_Toc507430505)

[3．2．3 貯水池周辺の漏水防止計画 4](#_Toc507430507)

[3．2．4 管理用水力発電計画 4](#_Toc507430509)

[3．3 環境に関する検討事項 5](#_Toc507430511)

平成31年3月　版

5.  第2章 河川施設配置計画

    2.  第2-1章 河道並びに河川構造物

        2.  []{#_Toc2677498 .anchor}貯水池（ダム）

        ```{=html}
        <!-- -->
        ```
        1.  []{#_Toc2677499 .anchor}洪水調節計画

            1.  []{#_Toc2677500 .anchor}ダムの計画高水流量

＜考え方＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  ダムの計画高水流量は、ダムの洪水調節計画の基本量であり、ダムごとに決めるものとする。この場合、下流の計画基準点の基本高水に対するダムの効果、ダム地点直下の河道に対するダムの効果、水系全体の洪水調節施設計画との均衡等を総合的に検討する必要がある。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜必　須＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  ダムの計画高水流量は、下流の計画基準点の基本高水に対するダムの効果、ダム地点直下の河道に対するダムの効果、水系全体の洪水調節施設計画との均衡等を総合的に検討するため、基本計画編 第2章 第2節 2.7 基本高水の決定 で決定された基本高水に対応するダム地点のハイドログラフ、及びダム地点を計画基準点としている場合はダム地点におけるハイドログラフのピーク流量、洪水調節容量について検討し、合理的に決定するものとする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 具体的にダムの計画高水流量を決定するには、                           |
|                                                                      |
| 1.  基本高水決定に                                                   |
| 用いたハイドログラフ群に対応するダム地点のハイドログラフのピーク流量 |
| が最大となるハイドログラフ及び洪水調節容量が最大となるハイドログラフ |
|                                                                      |
| 2.  ダ                                                               |
| ム流域の対象降雨より求められるダム地点のハイドログラフ群のピーク流量 |
| が最大となるハイドログラフ及び洪水調節容量が最大となるハイドログラフ |
|                                                                      |
| > を検討し、ピーク流量の最も大きいもので決定することを標準とする。   |
+----------------------------------------------------------------------+

1.  []{#_Toc2677501 .anchor}洪水調節方式

＜考え方＞

+----------------------------------------------------------------------+
| ダムによる洪水調節方式は、河川の状況、                               |
| 洪水流出の水文学的特性、貯水容量、放流設備、調節の目的、調節効率、操 |
| 作の確実性、維持管理の容易性、ダム地点直下を含めた下流部の河道の流下 |
| 能力などに応じて最も確実かつ効果的な方式を採用することが重要である。 |
|                                                                      |
| また、既にダムが運用されている水系にダムを新設する場                 |
| 合や、既に複数のダムが運用されている水系では、既設ダムの運用変更も含 |
| め、ダム群全体の運用が最適なものとなるよう検討することが重要である。 |
+----------------------------------------------------------------------+

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  ダムによる洪水調節方式は、下流計画基準点に対し目標とする洪水調節効果を確実に挙げる方式の中から、洪水流出の特性、調節効率、操作の確実性、維持管理の容易性、既設ダムを含むダム群全体の運用の最適化等を考慮して決定することを標準とする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜例　示＞

+----------------------------------------------------------------------+
| ダムによる洪水調節の方式には、以下のものがある。                     |
|                                                                      |
| 1.  一定率一定量放流方式                                             |
|                                                                      |
| 洪水調節開始流量以上の流入量に対し、ピーク流量に達する流量まで       |
| は流入量の一定割合を、ピーク流量に達した流量以降は一定量を放流する調 |
| 節方式で、一般に、ダム下流の洪水量が下流計画基準点の洪水量の大部分を |
| 占めるような河川等に適する。なお、中小洪水にも大きな調節効果が期待で |
| きるため、河道の整備が余り進んでいない河川等で採用されることもある。 |
|                                                                      |
| 2.  一定量放流方式                                                   |
|                                                                      |
| 洪水波形等にかかわらず一定量の                                       |
| 放流を行う、いわゆるピークカット方式であって、一般に大規模洪水に対し |
| て高い調節効果を発揮できるが、中小洪水には相対的に調節効果は小さい。 |
|                                                                      |
| 3.  自然調節方式                                                     |
|                                                                      |
| 洪水調節ゲートを有さないか、若しくはゲートはあっても                 |
| 一定開度保持等により調節操作を行わない方式であり、必要な洪水調節容量 |
| は大きいが、人為的な操作がなく管理が容易なため、一般に、流出の速い小 |
| 流域のダムを中心に用いられている。小流域のダム（おおむね20㎞^2^以下  |
| ）や洪水調節容量の小さいダム（おおむね相当雨量^※^50mm以下）では、ゲ  |
| ート操作の繁雑さを避けるため、自然調節方式とすることが望ましい。また |
| 、相当雨量100mm以下のダムでは自然調節方式を検討することが望ましい。  |
|                                                                      |
| 4.  不定率調節方式                                                   |
|                                                                      |
| 下流域からの流出との間に時間差があ                                   |
| り、洪水の前半部あるいは後半部において特に調節を要する場合や最大流量 |
| 付近を特に貯留する必要のある場合に採用される方式であり、洪水波形によ |
| っては効率の良い方式であるが、洪水波形を精度良く予測する必要がある。 |
|                                                                      |
| また、既設ダムの治水、利                                             |
| 水の容量の再配分や運用の見直しにより、それ以前の運用よりも大きな効果 |
| が見込める場合もある。このため、既にダムが整備され運用されている水系 |
| にダムを新設する場合や、既に複数のダムが運用されている水系では、既設 |
| ダムの運用を変更（そのための施設改良を含む）することも含め、洪水調節 |
| などダム群全体の効果が最適なものとなるよう検討することが重要である。 |
|                                                                      |
| ^※^洪水調節容量/流域面積を㎜単位で表したもの                         |
+----------------------------------------------------------------------+

1.  []{#_Toc2677502 .anchor}洪水調節容量

＜考え方＞

+----------------------------------------------------------------------+
| 　洪水調節容量は、洪                                                 |
| 水時にダムによって一時的に貯留することとした容量であり、計画で対象と |
| する規模の洪水に対して洪水調節に必要な容量として、平常時最高貯水位ま |
| たは洪水貯留準備水位から洪水時最高水位までの間で確保するものである。 |
|                                                                      |
| 　この場合、洪水調節容量には、流                                     |
| 入洪水の予測に関する不確実性、現実の洪水調節操作における制約、貯水池 |
| 内への堆砂による影響等の様々な要因も考慮して余裕を見込むものとする。 |
+----------------------------------------------------------------------+

＜必　須＞

  --------------------------------------------------------------------------------------------------------
  洪水調節容量は、洪水調節計画で対象とするハイドログラフ及び調節方式から設定し、余裕を見込むものとする。
  --------------------------------------------------------------------------------------------------------

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  具体的に貯水池の洪水調節容量を決定するには、基本高水の決定に用いたハイドログラフ群に対応するダム地点のハイドログラフ及びダム流域の対象降雨より求められるダム地点のハイドログラフ群について洪水調節計算を行い、必要とされる調節容量の最も大きいものに原則として２割程度の余裕を見込んで決定することを標準とする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  限られた貯水容量をより効率的に活用する観点から、必要に応じて、洪水の発生が予想された時点であらかじめ放流を行うことで、貯水位を下げ洪水調節容量を確保することを検討する。その方式の採用や運用にあたっては、操作の確実性、下流河道への影響等に対する十分な検討が必要である。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

1.  []{#_Toc2677503 .anchor}そのほかの計画

    1.  []{#_Toc2677504 .anchor}流入土砂対策に関する計画

＜考え方＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------
  ダムの所期の目的を損なうことなく、貯水池から土砂を排出し、適正に下流へ土砂を流すための対策を検討することは、総合的な土砂管理を進める上で重要である。
  ------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------
  貯水池の機能保持、総合的な土砂管理及び河川環境等の整備と保全を図るため、必要に応じて流入土砂対策に関する計画を策定することを標準とする。
  ------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  流入土砂対策に関する計画は、ダム地点上流域の砂防計画と調整を図りつつ、土砂の発生抑制（貯水池周辺等の斜面対策等）、貯水池への流入の抑制・通過（貯砂ダム、排砂バイパス、排砂ゲート等）、貯水池からの土砂の排出（浚渫・掘削、排砂管・排砂ゲート等）といった各種対策の組み合わせにより、ライフサイクルコストや河川環境への影響等を考慮して策定することが望ましい。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1)  河川砂防技術基準 調査編,平成26年4月改定,
    国土交通省水管理・国土保全局 第13章湖沼・ダム貯水池の環境調査,第16章
    総合的な土砂管理のための調査,第17章 砂防調査.

    （最新版）河川砂防技術基準 調査編 国土交通省水管理・国土保全局
    第13章湖沼・ダム貯水池の環境調査（平成26年4月）,第16章
    総合的な土砂管理のための調査（平成26年4月）,第17章
    砂防調査（令和5年5月）.

```{=html}
<!-- -->
```
46) [河川砂防技術基準
    > 維持管理編（ダム編）](http://www.mlit.go.jp/river/shishin_guideline/gijutsu/gijutsukijunn/ijikanri_dam/pdf/ijikanri_dam.pdf),平成28年3月改定,
    > 国土交通省水管理・国土保全局．

    （最新版）河川砂防技術基準
    維持管理編（ダム編），令和7年6月，国土交通省水管理・国土保全局.

47) [ダム貯水池水質調査要領](http://www.mlit.go.jp/river/shishin_guideline/dam/suishitsu/pdf/youryou.pdf),平成27年3月,
    > 国土交通省水管理・国土保全局河川環境課．

48) [ダム定期検査の手引き「河川管理施設のダム版」](http://www.mlit.go.jp/river/shishin_guideline/dam/07.pdf),平成28年3月,
    > 国土交通省水管理・国土保全局河川環境課．

49) [ダム定期検査の手引き「許可工作物のダム版」](http://www.mlit.go.jp/river/shishin_guideline/dam/08.pdf),平成28年3月,
    > 国土交通省水管理・国土保全局河川環境課．

50) [ダム貯水池土砂管理の手引き（案）](http://www.mlit.go.jp/river/shishin_guideline/dam7/pdf/damtyosuichidosyakanritebikiH30.pdf),平成30年3月,国土交通省水管理・国土保全局河川環境課.

    1.  []{#_Toc507430505 .anchor}貯水池周辺の地すべり防止計画

＜考え方＞

  ----------------------------------------------------------------------------------------------------------------------
  貯水池の機能を保持するとともに貯水池周辺の安全性を確保するため、ダムの運用に起因する地すべりの防止を図る必要がある。
  ----------------------------------------------------------------------------------------------------------------------

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  貯水池内又は貯水池に近接する土地において、ダムの運用に起因する地すべりを防止するため、貯水池周辺の地すべり調査を実施した上で、必要がある場合には、地すべり防止工を計画することを標準とする。ただし、ダム再生として、堤体のかさ上げを伴わず、貯水池の運用変更のみを実施する場合は、既設ダムにおける貯水位の変動実績等に基づき、運用変更後における貯水池周辺斜面の安定性を確認することを標準とする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1)  河川砂防技術基準
    調査編,平成26年4月改定,国土交通省水管理・国土保全局, 第15 章
    土質地質調査,第18章 地すべり調査.

    （最新版）河川砂防技術基準 調査編,国土交通省水管理・国土保全局, 第15
    章 土質地質調査（平成26年4月）,第18章 地すべり調査（令和5年5月）.

```{=html}
<!-- -->
```
2)  [河川砂防技術基準
    > 維持管理編（ダム編）](http://www.mlit.go.jp/river/shishin_guideline/gijutsu/gijutsukijunn/ijikanri_dam/pdf/ijikanri_dam.pdf),平成28年3月改定,
    > 国土交通省水管理・国土保全局．

    （最新版）河川砂防技術基準
    維持管理編（ダム編），令和7年6月，国土交通省水管理・国土保全局.

3)  [貯水池周辺の地すべり等に係る調査と対策に関する技術指針・同解説](http://www.mlit.go.jp/river/shishin_guideline/dam2/pdf/tyosuitigijukaisetu.pdf)：平成31
    > 年3 月，国土交通省水管理・国土保全局河川環境課,治水課．

＜参考となる資料＞

1)  改訂新版
    貯水池周辺の地すべり調査と対策：平成22年12月，財団法人国土技術研究センター.

    1.  []{#_Toc507430507 .anchor}貯水池周辺の漏水防止計画

＜考え方＞

  ------------------------------------------------------------------------------------------------
  貯水池の機能を保持するため、流水の貯留に起因するダム貯水池周辺への漏水の防止を図る必要がある。
  ------------------------------------------------------------------------------------------------

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  貯水池に近接する土地において、流水の貯留に起因する貯水池からの漏水に対し、貯水池の機能を保持することを目的として、貯水池周辺の地質調査を実施した上で、必要に応じて貯水池周辺の漏水防止工を計画することを標準とする。ただし、ダム再生として、堤体のかさ上げを伴わず、貯水池の運用変更のみを実施する場合は、既設ダムにおける貯水位の変動実績等に基づき、運用変更後における貯水池周辺の遮水性を確認することを標準とする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1)  河川砂防技術基準
    調査編,平成26年4月改定,国土交通省水管理・国土保全局, [第15章
    土質地質調査](http://www.mlit.go.jp/river/shishin_guideline/gijutsu/gijutsukijunn/chousa/pdf/15.pdf).

```{=html}
<!-- -->
```
51) [河川砂防技術基準
    > 維持管理編（ダム編）](http://www.mlit.go.jp/river/shishin_guideline/gijutsu/gijutsukijunn/ijikanri_dam/pdf/ijikanri_dam.pdf),平成28年3月改定,
    > 国土交通省水管理・国土保全局．

    （最新版）河川砂防技術基準
    維持管理編（ダム編），令和7年6月，国土交通省水管理・国土保全局.

    1.  []{#_Toc507430509 .anchor}管理用水力発電計画

＜考え方＞

  ----------------------------------------------------------------------------------------
  ダム管理の合理化やダムの包蔵する水力エネルギーの適正利用に向けた取り組みが重要である。
  ----------------------------------------------------------------------------------------

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------
  ダム管理の合理化及びダムの包蔵する水力エネルギーの適正利用を図ることを目的として、管理用水力発電施設の設置を検討することを標準とする。
  ----------------------------------------------------------------------------------------------------------------------------------------

＜例　示＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  管理用水力発電による発生電力は、ダム管理所に用いられるほか、貯水池の水質保全対策としての曝気や貯水池内の噴水等に用いられる。また、余剰電力については売電することによりダム管理費用の節減を図ることもできる。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1)  [河川砂防技術基準
    維持管理編（ダム編）](http://www.mlit.go.jp/river/shishin_guideline/gijutsu/gijutsukijunn/ijikanri_dam/pdf/ijikanri_dam.pdf),平成28年3月改定,
    国土交通省水管理・国土保全局．

    （最新版）河川砂防技術基準
    維持管理編（ダム編），令和7年6月，国土交通省水管理・国土保全局.

    1.  []{#_Toc507430511 .anchor}環境に関する検討事項

＜考え方＞

  ----------------------------------------------------------------------
  ダムを計画するに当たっては、環境への影響を十分に考慮する必要がある。
  ----------------------------------------------------------------------

＜必　須＞

+----------------------------------------------------------------------+
| ダムを計画するに当たっては、水・土壌                                 |
| 等の環境、動植物の良好な生息・生育・繁殖環境、人と河川との豊かな触れ |
| 合い、環境への負荷の視点から環境への影響を十分に考慮するものとする。 |
|                                                                      |
| 特に、ダム建設後の                                                   |
| 流況の変化等による下流河川の環境への影響等を十分勘案するものとする。 |
|                                                                      |
| また、流域の自然環境及び社会環境を踏まえ、環境への影響を極力、回     |
| 避・低減するとともに、新たな環境の創出についても考慮するものとする。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 1.  ダム                                                             |
| を計画するに当たり、以下に示す事項について留意することを標準とする。 |
|                                                                      |
| ```{=html}                                                           |
| <!-- -->                                                             |
| ```                                                                  |
| a)  水・土壌等の環境の保全                                           |
|                                                                      |
| > ダムを計画するに当たっては、水・土                                 |
| 壌等への影響が考えられるため、以下の事項を勘案することを標準とする。 |
|                                                                      |
| -   水環境(土砂による水の濁り、水                                    |
| 温、富栄養化、溶存酸素量、水素イオン濃度)の指標で示される水質の変化  |
|                                                                      |
| -   地形・地質、地盤及び土壌等の改変並びに地下水の変化               |
|                                                                      |
| b)  動植物の良好な生息・生育・繁殖環境の保全                         |
|                                                                      |
| > ダムを計画するに当たっては、動植物の良好な生息・生                 |
| 育・繁殖環境の保全の視点から、以下の事項を勘案することを標準とする。 |
|                                                                      |
| +--------+------------------------------------------------------+    |
| | 動物   | -   重要な種の繁殖地等の主要な生息地の改変           |    |
| |        |                                                      |    |
| |        | -   重要な種の移動経路の分断                         |    |
| |        |                                                      |    |
| |        | -   注目すべき生息地の改変                           |    |
| |        |                                                      |    |
| |        | -   重要な種及び                                     |    |
| |        | 注目すべき生息地の生息環境の変化(改変部付近の環境の  |    |
| |        | 変化、ダム下流河川の河床構成材料、流況、水質の変化)  |    |
| +========+======================================================+    |
| | 植物   | -   重要な種及び群落の生育地の改変                   |    |
| |        |                                                      |    |
| |        | -                                                    |    |
| |        |  重要な種及び群落の生育環境の変化(改変部付近の環境の |    |
| |        | 変化、ダム下流河川の河床構成材料、流況、水質の変化)  |    |
| +--------+------------------------------------------------------+    |
| | 生態系 | 上位性の注目種に対する改変及び変化                   |    |
| |        |                                                      |    |
| |        | -   繁殖地等の生息地の改変                           |    |
| |        |                                                      |    |
| |        | -   移動経路の分断                                   |    |
| |        |                                                      |    |
| |        | -   生息・生育・繁殖環境                             |    |
| |        | の変化(ダム下流河川の河床構成材料、流況、水質の変化) |    |
| |        |                                                      |    |
| |        | 典型性の注目種に対する改変及び変化                   |    |
| |        |                                                      |    |
| |        | -   生息・生育・繁殖環境の改変                       |    |
| |        |                                                      |    |
| |        | -   生息・生育・繁殖環境の変化(貯水                  |    |
| |        | 池の出現、貯水池内の堆砂による生息・生育・繁殖環境の |    |
| |        | 変化、ダム下流河川の河床構成材料、流況、水質の変化)  |    |
| |        |                                                      |    |
| |        | 特殊性の注目種に対する改変及び変化                   |    |
| |        |                                                      |    |
| |        | -   生息・生育・繁殖環境の改変                       |    |
| |        |                                                      |    |
| |        | -   生息・生育                                       |    |
| |        | ・繁殖環境の変化(地下水位の変化、改変部付近の環境の  |    |
| |        | 変化、ダム下流河川の河床構成材料、流況、水質の変化)  |    |
| |        |                                                      |    |
| |        | 移動性の注目種に対する改変及び変化                   |    |
| |        |                                                      |    |
| |        | -   移動経路の分断                                   |    |
| +--------+------------------------------------------------------+    |
|                                                                      |
| c)  人と河川との豊かな触れ合いの場の維持                             |
|                                                                      |
| ```{=html}                                                           |
| <!-- -->                                                             |
| ```                                                                  |
| 1.  良好な景観の維持                                                 |
|                                                                      |
| > ダムを計画するに当たっては                                         |
| 、良好な景観の維持の視点から、以下の事項を勘案することを標準とする。 |
|                                                                      |
| ・ 主要な眺望点及び景観資源の改変の程度                              |
|                                                                      |
| ・ 主要な眺望景観の変化                                              |
|                                                                      |
| ・ 地形及び地質、文化財への配慮                                      |
|                                                                      |
| 2.  触れ合い活動の場の維持                                           |
|                                                                      |
| > ダムを計画するに当たっては、触れ                                   |
| 合い活動の場の確保の視点から、以下の事項を勘案することを標準とする。 |
|                                                                      |
| ・ 触れ合い活動の場及び自然資源の改変の程度(消滅・縮小)              |
|                                                                      |
| ・ 触れ合い活動の場の利用性の変化                                    |
|                                                                      |
| ・ 触れ合い活動の場の快適性の変化                                    |
|                                                                      |
| d)  環境への負荷の量                                                 |
|                                                                      |
| > ダムを計画するに当たっては、環                                     |
| 境への負荷の量の程度を踏まえ、以下の事項を勘案することを標準とする。 |
|                                                                      |
| -   建設副産物(廃棄物、再生資源)の量                                 |
|                                                                      |
| 2.  ダ                                                               |
| ム下流の河川に対する必要な流量の確保や流況の変化等は、ダム計画の基本 |
| となる部分であるため、計画段階から十分勘案しておくことを標準とする。 |
|                                                                      |
| -   流況の変化による河床構成材料の変化(アーマー化)                   |
|                                                                      |
| -   冠水頻度の変化                                                   |
|                                                                      |
| -   親水区域                                                         |
|                                                                      |
| -   回遊魚等の遡上・降下                                             |
|                                                                      |
| -   河川水位の変化による地下水の変化                                 |
|                                                                      |
| 3.  環境の保全という視点だけでなく、新たな環境の                     |
| 創出という視点が必要であり、計画段階で十分配慮することを標準とする。 |
|                                                                      |
| -   周辺環境と調和のとれた水源地整備                                 |
|                                                                      |
| -   ダム堤体の景観デザイン                                           |
|                                                                      |
| -   ダム堤体、原石山及び土捨場の出現による触れ合いの場の形成         |
+----------------------------------------------------------------------+

＜関連通知等＞

1)  河川砂防技術基準 調査編,平成26年4月改定,
    国土交通省水管理・国土保全局 第13章湖沼・ダム貯水池の環境調査,第16章
    総合的な土砂管理のための調査,第17章
    砂防調査.（最新版）河川砂防技術基準 調査編
    国土交通省水管理・国土保全局
    第13章湖沼・ダム貯水池の環境調査（平成26年4月）,第16章
    総合的な土砂管理のための調査（平成26年4月）,第17章
    砂防調査（令和5年5月）.

```{=html}
<!-- -->
```
4)  [河川砂防技術基準
    > 維持管理編（ダム編）](http://www.mlit.go.jp/river/shishin_guideline/gijutsu/gijutsukijunn/ijikanri_dam/pdf/ijikanri_dam.pdf),平成28年3月改定,
    > 国土交通省水管理・国土保全局．

    （最新版）河川砂防技術基準
    維持管理編（ダム編），令和7年6月，国土交通省水管理・国土保全局.

5)  [ダム貯水池水質調査要領](http://www.mlit.go.jp/river/shishin_guideline/dam/suishitsu/pdf/youryou.pdf),平成27年3月,
    > 国土交通省水管理・国土保全局河川環境課．

6)  [ダム貯水池水質改善の手引き](http://www.mlit.go.jp/river/shishin_guideline/dam/pdf2/damtyosuichisuisitukaizentebikiH30.pdf),平成30年3月,国土交通省水管理・国土保全局河川環境課.

施設配置等計画編

**第2章 河川施設配置計画**

**第2-1章 河道並びに河川構造物**

**第4節 遊水地等**

目　次 {#目-次-4 .TOC-Heading}
======

[第4節 遊水地等 1](#_Toc2678219)

[4．1 計画の基本 1](#_Toc2678220)

[4．2 遊水地等の位置の選定 1](#_Toc507599169)

[4．3 洪水調節計画 1](#_Toc507599172)

[4．3．1 調節施設の計画 1](#_Toc507599173)

[4．3．2 調節開始流量 2](#_Toc507599175)

平成31年3月　版

6.  

```{=html}
<!-- -->
```
3.  河川施設配置計画

    2.  第2-1章 河道並びに河川構造物

        4.  []{#_Toc2678219 .anchor}遊水地等

        ```{=html}
        <!-- -->
        ```
        1.  []{#_Toc2678220 .anchor}計画の基本

＜考え方＞

+----------------------------------------------------------------------+
| 遊水地等とは、平地部に                                               |
| おいて、洪水の一部を貯留して下流のピーク流量を低減させるために設けら |
| れるもののほか、内水処理や支川処理の一環として設けられるものもある。 |
|                                                                      |
| 遊水地等の型式としては、自然の地形を利用し、周                       |
| 囲堤、囲繞堤(いぎょうてい)、越流堤などで囲む型式や土地を掘り込んで貯 |
| 留機能を確保する型式、又は地下空間に貯留機能を確保する型式等がある。 |
|                                                                      |
| 遊水地等の土地の有効な利用を図るため、                               |
| 洪水処理以外の目的にも活用することも併せて検討しておくことが必要であ |
| る。特に貯水機能を利用した多目的遊水地等を計画する場合には、第2-3章  |
| 多目的施設 を参照するものとする。                                    |
+----------------------------------------------------------------------+

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------
  遊水地等の計画に当たっては、地形、土地利用の状況、地下水位、河川の状況、自然環境、流量調節条件、越流頻度、経済性、維持管理などを考慮するものとする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------
  一般に遊水地等は、遊水地として機能する頻度はごく限られていることに鑑み、土地の有効利用を図るため、遊水地等の多目的な利用について積極的に検討することが望ましい。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------

2.  []{#_Toc507599169 .anchor}遊水地等の位置の選定

＜考え方＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  遊水地等は地形上、土地利用上の制約から位置を任意に選定することが困難な場合が多いが、洪水調節効果から考えると、治水計画上考えられている洪水防御の対象地域にできるだけ近いことが望ましい。しかし、下流域になればなるほど対象洪水のハイドログラフが扁平になるため、カット量に比較して大きな容量を必要とし、山間部の貯水池のように大きな水深がとれないので広大な面積を必要とする。また、下流の都市周辺地域では都市化の進行が著しく、用地の確保が難しくなっているので、目的とする洪水調節効果が発揮されるよう、これらを総合的に勘案して決定しなければならない。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

  --------------------------------------------------------------------------------------------------------------
  遊水地等は、洪水防御の対象地域に対する洪水調節効果が確実で貯水容量の確保が有利である地点に設けるものとする。
  --------------------------------------------------------------------------------------------------------------

3.  []{#_Toc507599172 .anchor}洪水調節計画

    1.  []{#_Toc507599173 .anchor}調節施設の計画

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------
  遊水地等の調節施設は、調節の目的に応じた効果を確実に挙げるような十分な調節機能を有するように計画するものとする。
  ------------------------------------------------------------------------------------------------------------------

＜推　奨＞

+----------------------------------------------------------------------+
| 一般に、遊水地                                                       |
| 等はダム等の調節施設と異なり、河道からの横越流方式をとることが多い。 |
|                                                                      |
| この場合、調節施設の計画に考慮すべき事項は次のとおりである。         |
|                                                                      |
| -   越流堤の高さは、調節開始流量（4.3.2参照）に直接                  |
| 関係するもので、越流堤の長さと合わせて、調節後のハイドログラフの形を |
| 支配し、洪水調節の効果を左右することから、慎重に検討する必要がある。 |
|                                                                      |
| -   越流堤付近の河道計画に                                           |
| 当たっては、河床変動や洪水時の流況を慎重に検討する必要がある。また、 |
| 適正な洪水調節が行えるように、整備後の維持管理に留意する必要がある。 |
|                                                                      |
| -   河川の整備が進む                                                 |
| と、水位と流量の関係が変化し、越流堤等からの越流量も影響を受けるため |
| 、河川整備計画の目標に応じた段階的な整備を考慮することが必要である。 |
|                                                                      |
| -   越流堤上下流にお                                                 |
| ける河道特性を踏まえた最適な洪水調節効果を得るための越流堤の配置、高 |
| さ及び長さの設定を行うには、河道と遊水地内の水の流れを一体として捉え |
| た非定常平面二次元流解析等により、洪水流量の時間変化や遊水地への洪水 |
| 流入量を算定し、調節効果の検討を行うことが望ましい。なお、解析手法に |
| 関しては、河川砂防技術基準調査編を参考に適切な手法を用いるのがよい。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1)  河川砂防技術基準調査編，平成26年4月，国土交通省水管理・国土保全局，第2章
    水文・水理観測第7節 河川の流れの総合的把握，第5章
    河川における洪水流の水理解析

    （最新版）河川砂防技術基準調査編，国土交通省水管理・国土保全局，第2章
    水文・水理観測第7節 河川の流れの総合的把握（令和4年6月），第5章
    河川における洪水流の水理解析（平成26年4月）.

＜参考となる資料＞

　河道と遊水地内の水の流れを一体的に解く解析手法により遊水地の洪水調節量を高精度に評価する方法を検討した例としては、下記の資料1)が参考となる。

1)  松本敬司、中井隆亮、福岡捷二、須見徹太郎：[渡良瀬遊水地の洪水調節機能とその課題の考察](https://www.jstage.jst.go.jp/article/jscejhe/70/4/70_247/_pdf/-char/ja),
    土木学会論文集B1（水工学）, Vol.70, No.4, Ⅰ\_1477-I\_1482, 2014.

＜例　示＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------
  計画規模の洪水を対象として完成した遊水地について、河川整備計画の目標に応じ、頻度の高い中規模洪水に対しても効果を発揮できるよう、起伏ゲート構造に改良した事例がある。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------

1.  []{#_Toc507599175 .anchor}調節開始流量

＜考え方＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  調節開始流量とは、越流堤等から遊水地等への流入が始まる流量である。これを大きくとれば、すなわち越流堤を高くすれば計画規模の出水に対しての調節効果は大きいが、中小洪水に対しては調節効果を発揮しにくい。逆に小さくとれば、すなわち越流高を低くすると中小洪水に対しては十分な調節効果を有するが、計画規模の出水に対する調節効果が減少する場合が多い。このように調節の目的、洪水流出の特性、遊水地等の容量、河川改修に伴う越流堤前面の水位と流量の関係の変化等を考慮して、所期の効果を確実に挙げるよう調節開始流量を決定しなければならない。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

  ------------------------------------------------------------------------------------------------------------
  調節開始流量は、調節の目的、洪水流出の特性などを考慮して、所期の効果を確実に挙げるよう決定するものとする。
  ------------------------------------------------------------------------------------------------------------

施設配置等計画編

**第2章 河川施設配置計画**

**第2-1章 河道並びに河川構造物**

**第5節 堰、水門、樋門**

目　次 {#目-次-5 .TOC-Heading}
======

[第5節 堰、水門、樋門 1](#_Toc2678691)

[5．1 設置の基本 1](#_Toc2678692)

[5．2 堰の湛水位 2](#_Toc2678693)

[5．3 堰の魚道 2](#_Toc2678694)

平成31年3月　版

7.  

```{=html}
<!-- -->
```
4.  河川施設配置計画

    2.  第2-1章 河道並びに河川構造物

        5.  []{#_Toc2678691 .anchor}堰、水門、樋門

        ```{=html}
        <!-- -->
        ```
        1.  []{#_Toc2678692 .anchor}設置の基本

＜考え方＞

+----------------------------------------------------------------------+
| 堰は、設置目的により分流堰、潮                                       |
| 止堰、取水堰等に区分され、その構造により固定堰、可動堰に分類される。 |
|                                                                      |
| 水門・樋門は、河川又は水                                             |
| 路を横断して設けられる施設であり、堤防の機能を有しているものをいう。 |
|                                                                      |
| 堰・水門・樋門(以下、「堰等                                          |
| 」という。樋管を含む)の設置位置の選定に当たっては、それぞれの設置目  |
| 的を十分に果たすように選定する必要があるが、特に堰については、設置に |
| よって河状に乱れを生じ、洪水時の流水の疎通に障害となるおそれがある。 |
|                                                                      |
| 堰の設置は、河道の縦                                                 |
| 断形を将来にわたって制御するものであるため、設置位置の検討にあたって |
| は、流心が直線状で流速変化が少なく、流心が安定して流水による河床変動 |
| の少ない地点を選び、河道計画に整合するよう計画することが重要である。 |
|                                                                      |
| 堰は建設費を節減するため川幅の狭い箇所への設置                       |
| が有利と考えられる向きもあるが、一般に、狭窄部は洪水時における流速が |
| 大きく、河積に影響を与える施設を配置すると洪水の流下を阻害するととも |
| に、局所的に流速を助長し、河床洗掘を誘発するおそれがあるため、狭窄部 |
| での設置を避けるものとする。ただし、堰の設置によって洪水の流下が妨げ |
| られても、その上流部に治水上の支障を及ぼさない箇所は除くものとする。 |
|                                                                      |
| 堰等を計画するに当たっては、地域の自然環境、社会環境及びそれらの歴   |
| 史的な経緯を踏まえ、治水・利水・環境について目指すべき方向性を総合的 |
| に勘案し、水・土壌等の環境、動植物の生息・生育・繁殖環境、景観、人と |
| 河川と触れ合い活動の場等への効果及び影響を検討し、最適な計画とする。 |
|                                                                      |
| 堰等構造物は、河川                                                   |
| 景観の中でシンボル的な役割を果たす場合があり、これら大規模な構造物等 |
| を中心とした拠点のデザインにあたっては、周辺景観との調和に配慮しつつ |
| 施設の特徴を活かした魅力的な河川景観の形成をはかることが大切である。 |
|                                                                      |
| 堰等の構造物が設置されたことにより、堤防の                           |
| 弱点となるおそれがあり、また、操作、維持管理の面を考慮しても、その数 |
| は極力少なくするのが望ましいので、可能な限り統合に努める必要がある。 |
|                                                                      |
| 堰等が長期にわたりその機能を                                         |
| 発揮するためには、適切な点検・整備・補修ができるスペースの確保等が必 |
| 要であり、施設配置計画段階から維持管理面に配慮することが重要である。 |
|                                                                      |
| なお、堰の貯水機能を利用した多目的堰を計画する場合は、第2-3章        |
| 多目的施設 を参照するものとする。                                    |
+----------------------------------------------------------------------+

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  堰等の設置位置は、河道計画やその設置目的に応じて選定し、治水・利水・環境面を総合的に勘案し、河道の湾曲部や河道断面の狭小な箇所、河状の不安定な箇所等はできるだけ避けるものとする。また、これらは極力統合に努め、設置箇所数を少なくするものとし、個々の施設配置計画にあたっては、点検・整備・補修スペースの確保等、維持管理面に配慮するものとする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1)  [「多自然川づくり」の推進について](http://www.mlit.go.jp/notice/noticedata/pdf/200704/00004847.pdf),平成18年10月13日,国河環第38号,国河治第86号,国河防第370号,国土交通省河川局長通達.

```{=html}
<!-- -->
```
52) 美しい河川景観の形成と保全の推進について,平成18年10月19日,国河環第40号,国河治第94号,国河防第376号,国土交通省河川局河川環境課長,治水課長,防災課長通達.

    1.  []{#_Toc2678693 .anchor}堰の湛水位

＜考え方＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  堰の位置及び堰の計画湛水位の設定に当たっては、地下水位の変化、堤内地の排水不良等の問題に十分に配慮する必要がある。地形の状況等によりやむを得ない場合には、堤内地盤又は高水敷等に盛土等による適切な措置を講じる必要がある。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 堰の計画湛水位は、原                                                 |
| 則として高水敷高より50cm以上低くするとともに、堤内地盤高以下とする。 |
|                                                                      |
| ただし、盛土等適切な措置を講じた場合にはこの限りではない。           |
+----------------------------------------------------------------------+

2.  []{#_Toc2678694 .anchor}堰の魚道

＜考え方＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  魚道計画に当たっては、対象地点の流況、堰上下流の水位変動の範囲、対象魚類等ごとの遡上時期、経路、降下時期、堰からの取水・放流操作等を十分検討の上、対象魚類等が遡上・降下できるとともに、取水施設への迷入を低減できるよう対象流量、水位、配置等を設定する。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

  --------------------------------------------------------------------------------------------
  堰の建設により遡上・降下する魚類等への影響が懸念される場合には、魚道を設置するものとする。
  --------------------------------------------------------------------------------------------

＜推　奨＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  堰の設置による魚類等の生息環境への影響をできるだけ低減するため、遡上・降下する魚類等を対象に魚道を設置することが望ましい。対象魚類等は、水産資源からみて重要な魚種のみでなく、それ以外の魚類や甲殻類等についても併せて検討する。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

施設配置等計画編

**第2章 河川施設配置計画**

**第2-1章 河道並びに河川構造物**

**第6節 流況調整河川計画**

目　次 {#目-次-6 .TOC-Heading}
======

[第6節 流況調整河川計画 1](#_Toc508804366)

平成31年3月　版

8.  

```{=html}
<!-- -->
```
5.  河川施設配置計画

    2.  第2-1章 河道並びに河川構造物

        6.  []{#_Toc508804366 .anchor}流況調整河川計画

＜考え方＞

+----------------------------------------------------------------------+
| 流況調整河川は、2以上の河川を連絡                                    |
| することによって、洪水処理、河川相互の余剰流量を利用した維持流量の導 |
| 水、新規利水の開発及び別途施設による開発水の導水等を行うものである。 |
|                                                                      |
| 流況調整河川と                                                       |
| ダム等の貯留施設とが関連を有する場合には、計画の策定に当たっては相互 |
| の補給関係を明確にし、開発水量が重複しないように注意する必要がある。 |
|                                                                      |
| また、導水量を決める場合には、導水する元の                           |
| 河川の正常流量や水利用等に支障を与えないよう十分調査する必要がある。 |
+----------------------------------------------------------------------+

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  流況調整河川の計画策定に当たっては、新川及び周辺の環境、現在及び将来の社会環境、周辺の地下水位、地下水の水質、用排水路系統、堤内地の内水対策を考慮するとともに、導水先水域の環境への影響や導水元河川の環境への影響についても検討し、適切な計画を策定することを標準とする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1)  河川砂防技術基準
    調査編,平成26年4月改定,国土交通省水管理・国土保全局,第2章
    水文・水理観測,第11章 河川環境調査.

    （最新版）河川砂防技術基準 調査編,国土交通省水管理・国土保全局,第2章
    水文・水理観測（令和4年6月）,第11章 河川環境調査（令和6年6月）.

```{=html}
<!-- -->
```
53) 正常流量検討の手引き（案），平成 19 年 9
    > 月，国土交通省河川局河川環境課.

**施設配置等計画編**

**第 2 章 河川施設配置計画**

**第 2-1 章 河道並びに河川構造物**

第 7 節 高規格堤防 {#第-7-節-高規格堤防 .目次の見出し1}
==================

目　次 {#目-次-7 .目次の見出し1}
======

[第7節 高規格堤防 1](#_Toc103720026)

[7．1 高規格堤防設置区間 1](#_Toc103720027)

[7．2 高規格堤防の高さ 1](#_Toc21616087)

[7．3 高規格堤防設置区間に合流する支川等の背水区間 2](#_Toc103720029)

[7．4 地域整備に関する計画との調整 2](#_Toc103720030)

令和4年６月　版

適用上の位置付け

　河川砂防技術基準計画編は、基準の適用上の位置付けを明確にするために、下表に示すように適用上の位置付けを分類している。

+--------+------------------+------------------+------------------+
| 分　類 | 適用上の位置付け | 末尾の字句例     |                  |
+--------+------------------+------------------+------------------+
| 考え方 | 技術資料         | ●目              | 「･･･ある。      |
|        |                  | 的や概念、考え方 | 」「･･･いる。」  |
|        |                  | を記述した事項。 |                  |
|        |                  |                  | 「･･･なる。      |
|        |                  |                  | 」「･･･れる。」  |
+--------+------------------+------------------+------------------+
| 必　須 | 技術基準         | ●法令による規定  | 「･･･なければ    |
|        |                  | や技術的観点から | ならない。」「･  |
|        |                  | 実施すべきである | ･･ものとする。」 |
|        |                  | ことが明確であり |                  |
|        |                  | 遵守すべき事項。 |                  |
+--------+------------------+------------------+------------------+
| 標　準 | 技術基準         | ●特              | 「･･･            |
|        |                  | 段の事情がない限 | を標準とする。」 |
|        |                  | り記述に従い実施 |                  |
|        |                  | すべきだが、状況 | 「･･･            |
|        |                  | や条件によって一 | を基本とする。」 |
|        |                  | 律に適用すること |                  |
|        |                  | はできない事項。 | 「･･･による。」  |
+--------+------------------+------------------+------------------+
| 推　奨 | 技術資料         | ●状況や条件      | 「               |
|        |                  | によって実施する | ･･･望ましい。」  |
|        |                  | ことが良い事項。 |                  |
|        |                  |                  | 「               |
|        |                  |                  | ･･･推奨する。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･務める。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･必要に応    |
|        |                  |                  | じて･･･する。」  |
+--------+------------------+------------------+------------------+
| 例　示 | 技術資料         | ●適用条件や実施  | 「               |
|        |                  | 効果について確定 | ･･･などの手法（  |
|        |                  | している段階では | 事例）がある。」 |
|        |                  | ないが、状況や条 |                  |
|        |                  | 件によっては導入 | 「･･･など        |
|        |                  | することが可能な | の場合がある。」 |
|        |                  | 新技術等の例示。 |                  |
|        |                  |                  | 「･･･など        |
|        |                  | ●状              | が考えられる。」 |
|        |                  | 況や条件によって |                  |
|        |                  | 限定的に実施でき | 「               |
|        |                  | る技術等の例示。 | ･･･の場合には･･･ |
|        |                  |                  | ことができる。」 |
|        |                  | ●具体的          |                  |
|        |                  | に例示することに | 「               |
|        |                  | より、技術的な理 | ･･･例示する。」  |
|        |                  | 解を助ける事項。 |                  |
|        |                  |                  | 「例えば･･･。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･事例もある  |
|        |                  |                  | 。･･･もよい。」  |
+--------+------------------+------------------+------------------+

  関連通知等       関連する通知やそれを理解する上で参考となる資料
  ---------------- ------------------------------------------------------
  参考となる資料   例示等に示した手法・内容を理解する上で参考となる資料

1.  []{#_Toc103720026 .anchor}高規格堤防

    1.  []{#_Toc103720027 .anchor}高規格堤防設置区間

＜考え方＞

+----------------------------------------------------------------------+
| 堤防は計画高水位以下の水位の流水の通常の作用に                       |
| 対して安全な構造を持つものとして整備されるが、洪水は自然現象である降 |
| 雨等に起因するものであるため、計画高水位を超えて流下してくる洪水が発 |
| 生する可能性は常に存在し、そのような洪水が発生した場合には越水等によ |
| り堤防が破堤し、極めて甚大な被害が発生する危険性が著しく大きくなる。 |
|                                                                      |
| 特に人口・資産や中枢管理機能等が高密度に集                           |
| 積した大都市地域等を守る堤防の破堤は、当該地域に甚大な被害を及ぼすだ |
| けでなく、我が国全体の社会・経済にも大きな打撃をもたらすことになる。 |
|                                                                      |
| このため、河道の整備が                                               |
| 完成した場合であっても、計画高水位を超えて流下してくる洪水に対しても |
| 破堤しない構造の堤防として高規格堤防を整備する必要がある。河道計画上 |
| は、このような対策を実施すべき区間として高規格堤防設置区間を定める。 |
|                                                                      |
| 区間の設定に当たっては、氾濫                                         |
| 区域内の人口・資産等、破堤氾濫した場合の社会・経済等に与える影響度、 |
| 被害形態、土地利用、上下流や左右岸バランスを十分考慮する必要がある。 |
+----------------------------------------------------------------------+

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  高規格堤防は、高規格堤防設置区間を定めてこれを整備することを基本とする。高規格堤防設置区間は、「人命を守る」ということを最重視し、そのために必要な区間として「人口が集中した区域で、堤防が決壊すると甚大な人的被害が発生する可能性が高い区間」を対象とすることを基本とする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1)  高規格堤防整備の抜本的見直しについて（とりまとめ）,平成23年8月11日,高規格堤防の見直しに関する検討会．

```{=html}
<!-- -->
```
1)  高規格堤防の整備区間について,平成24年9月3日,国水治第71号,国土交通省水管理･国土保全局治水課長通知.

2)  高規格堤防の効率的な整備の推進に向けて
    提言,平成29年12月,高規格堤防の効率的な整備に関する検討会.

[]{#_Toc21616087 .anchor}

1.  高規格堤防の高さ

＜考え方＞

+----------------------------------------------------------------------+
| 高規                                                                 |
| 格堤防は、普通の堤防が持つ機能を包含するとともに、計画高水流量を越え |
| る流水の作用に対しても耐えることができるという要素を持つ必要がある。 |
|                                                                      |
| また、高規格堤防は、まちづくり等と一体となって整備され               |
| るのが一般的で、連続してではなく、飛び飛びに築造されることが多いこと |
| から、堤防の高さは上下流及び左右岸の堤防の高さとの整合を求められる。 |
|                                                                      |
| 一連区間が完成した場合であっても、その高さを切り下げることは上下流の |
| 堤防高さとの整合性、民生安定上望ましいことではないため、高規格堤防の |
| 高さは、河川管理施設等構造令に規定される高さと同じとする必要がある。 |
+----------------------------------------------------------------------+

＜必　須＞

  ----------------------------------------------------------------------------------
  高規格堤防の高さは、河川管理施設等構造令の規定に基づき設定することを基本とする。
  ----------------------------------------------------------------------------------

2.  []{#_Toc103720029
    .anchor}高規格堤防設置区間に合流する支川等の背水区間

＜考え方＞

+----------------------------------------------------------------------+
| 洪水時に、高規格堤防設置                                             |
| 区間である本川に合流する支川において背水が生じる場合には、背水による |
| 支川の堤防の破堤は本川の堤防の破堤と同様の被害をもたらすことになる。 |
|                                                                      |
| 言い換えれば、支川の背水区間の堤防は本川の堤防の機能を果たすものであ |
| り、本川と同様の作用に対して耐えることができる堤防とする必要がある。 |
|                                                                      |
| ただし、水門等の逆流を防止する施設によって                           |
| 背水が生じないようにすることができる区間にあってはこの限りではない。 |
|                                                                      |
| この場合、背水が生じないようにするため逆                             |
| 流を防止する施設として設けられる水門及び樋門は、本川の堤防としての機 |
| 能を果たすものであるため、本川と同様の作用に対して耐える必要がある。 |
|                                                                      |
| なお                                                                 |
| 、バック堤方式にする場合にあっては、本川の高規格堤防設計水位(設計編  |
| 第1章 河川構造物の設計 第3節 高規格堤防 3.1                          |
| 総説                                                                 |
| )が支川の計画高水位にレベルですり付く地点まで及ぶことが考えられる。  |
|                                                                      |
| このため、支川の施設計画等に際                                       |
| しては背水区間を越えるこれらの区間についても十分配慮する必要がある。 |
+----------------------------------------------------------------------+

＜標　準＞

  --------------------------------------------------------------------------------------------------------------
  高規格堤防設置区間に合流する支川等の背水区間に当たっては、本川の合流点と同等の対策を講ずることを基本とする。
  --------------------------------------------------------------------------------------------------------------

3.  []{#_Toc103720030 .anchor}地域整備に関する計画との調整

＜考え方＞

+----------------------------------------------------------------------+
| 高規格堤防は、河川管理                                               |
| 上必要な場合を除き土地を取得せず、その敷地である土地の区域の大部分の |
| 土地の区域が通常の土地利用に供されることを前提に整備されるものである |
| ため、当該区域の市街地整備の動向と整合した整備が不可欠となっている。 |
|                                                                      |
| このため、地域整備に係                                               |
| わる計画の策定時から積極的に関係機関との調整を行っていく必要がある。 |
|                                                                      |
| 特に市街地                                                           |
| 整備は実際に着手されるまでに長期間を要する場合も多く、地方公共団体の |
| 都市計画担当部局や防災部局等と連携し、都市計画、当該地域の市街化の動 |
| 向、避難に関する計画、水災害対策とまちづくりの連携等を踏まえて、地域 |
| の防災や減災、高台としての避難場所や緊急時の活動拠点としての機能など |
| 防災まちづくりの形成に資する高規格堤防の整備を行うことが重要である。 |
+----------------------------------------------------------------------+

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------
  高規格堤防は通常の土地利用を前提とするもので、まちづくり等と一体的に整備を進める場合が多いことから、沿川の地域整備に関する計画と十分調整を行うことを基本とする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

+----------------------------------------------------------------------+
| 沿川の地方公共団体等と情報交換を十分に行い                           |
| 、共同事業の機会を逃さないことはもちろんのこと、高規格堤防の整備との |
| 共同事業を積極的に地方公共団体や民間事業者等に提案することに努める。 |
|                                                                      |
| また、高規格堤防と市街地の一体的かつ計                               |
| 画的な整備の推進にあたっては、これまでに定められた措置や新たな方策な |
| どについて地方公共団体や民間事業者等に周知し、認識の共有を図るととも |
| に、それらの運用について相談に応じる体制を確保し、高規格堤防の計画に |
| ついて、地方公共団体の計画等へ反映させるよう取り組むことを推奨する。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1)  高規格堤防整備と市街地整備の一体的推進について,平成6年11月21日、建設省都市局長建設省河川局長通達.

```{=html}
<!-- -->
```
7)  高規格堤防整備と市街地整備の一体的推進について,平成6年11月21日、建設省都市局都市計画課長
    建設省河川局長治水課長通達.

8)  高規格堤防整備にかかる事業計画書の作成要領について,平成24年6月14日,国土交通省水管理･国土保全局治水課長補佐事務連絡.

9)  高規格堤防の効率的な整備に関する検討会：高規格堤防の効率的な整備の推進に向けて提言,平成29年12月.

10) 災害に強い首都「東京」の形成に向けた連絡会議：災害に強い首都「東京」形成ビジョン,令和
    2年12月.

**施設配置等計画編**

**第 2 章 河川施設配置計画**

**第 2-2 章 内水処理施設**

> 第2-2章 内水処理施設 1

第1節 総　説 1

第2節 内水処理方式の検討 1

第3節 検討対象内水の選定 1

第4節 確率評価手法の検討 1

第5節 内水処理施設規模の決定 1

平成16年3月　版

適用上の位置付け

　河川砂防技術基準計画編は、基準の適用上の位置付けを明確にするために、下表に示すように適用上の位置付けを分類している。

+--------+------------------+------------------+------------------+
| 分　類 | 適用上の位置付け | 末尾の字句例     |                  |
+--------+------------------+------------------+------------------+
| 考え方 | 技術資料         | ●目              | 「･･･ある。      |
|        |                  | 的や概念、考え方 | 」「･･･いる。」  |
|        |                  | を記述した事項。 |                  |
|        |                  |                  | 「･･･なる。      |
|        |                  |                  | 」「･･･れる。」  |
+--------+------------------+------------------+------------------+
| 必　須 | 技術基準         | ●法令による規定  | 「･･･なければ    |
|        |                  | や技術的観点から | ならない。」「･  |
|        |                  | 実施すべきである | ･･ものとする。」 |
|        |                  | ことが明確であり |                  |
|        |                  | 遵守すべき事項。 |                  |
+--------+------------------+------------------+------------------+
| 標　準 | 技術基準         | ●特              | 「･･･            |
|        |                  | 段の事情がない限 | を標準とする。」 |
|        |                  | り記述に従い実施 |                  |
|        |                  | すべきだが、状況 | 「･･･            |
|        |                  | や条件によって一 | を基本とする。」 |
|        |                  | 律に適用すること |                  |
|        |                  | はできない事項。 | 「･･･による。」  |
+--------+------------------+------------------+------------------+
| 推　奨 | 技術資料         | ●状況や条件      | 「               |
|        |                  | によって実施する | ･･･望ましい。」  |
|        |                  | ことが良い事項。 |                  |
|        |                  |                  | 「               |
|        |                  |                  | ･･･推奨する。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･務める。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･必要に応    |
|        |                  |                  | じて･･･する。」  |
+--------+------------------+------------------+------------------+
| 例　示 | 技術資料         | ●適用条件や実施  | 「               |
|        |                  | 効果について確定 | ･･･などの手法（  |
|        |                  | している段階では | 事例）がある。」 |
|        |                  | ないが、状況や条 |                  |
|        |                  | 件によっては導入 | 「･･･など        |
|        |                  | することが可能な | の場合がある。」 |
|        |                  | 新技術等の例示。 |                  |
|        |                  |                  | 「･･･など        |
|        |                  | ●状              | が考えられる。」 |
|        |                  | 況や条件によって |                  |
|        |                  | 限定的に実施でき | 「               |
|        |                  | る技術等の例示。 | ･･･の場合には･･･ |
|        |                  |                  | ことができる。」 |
|        |                  | ●具体的          |                  |
|        |                  | に例示することに | 「               |
|        |                  | より、技術的な理 | ･･･例示する。」  |
|        |                  | 解を助ける事項。 |                  |
|        |                  |                  | 「例えば･･･。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･事例もある  |
|        |                  |                  | 。･･･もよい。」  |
+--------+------------------+------------------+------------------+

  関連通知等       関連する通知やそれを理解する上で参考となる資料
  ---------------- ------------------------------------------------------
  参考となる資料   例示等に示した手法・内容を理解する上で参考となる資料

9.  第2-2章 内水処理施設

    1.  総　説

内水処理計画は,対象内河川流域の内水特性や内水被害の状況を十分考慮して策定するものとする．

2.  内水処理方式の検討

内水処理方式の選定に当たっては，対象内水河川流域及び想定湛水区域の地形，土地利用，排水状況，内水河川・本川の改修計画，関連諸事業の計画，内水湛水特性，内水被害特性等から効果が見込め，かつ経済性，社会性の観点から実現可能な代替案の中から施設の維持管理，超過洪水時における被害の程度等について総合的に評価するものとする．

3.  検討対象内水の選定

検討対象内水は，過去の降雨実績，外水位及び湛水状況を考慮して，既往最大の被害をもたらした内水を含み，被害状況，水文資料の整備状況に応じて数個選定するものとする．

4.  確率評価手法の検討

内水処理計画における内水規模の確率評価手法は，検討対象地域の内水特性及び水文資料の整備状況に応じて選定すべきものであり，以下に示す確率評価手法の中からその手法の特性を踏まえて選定するものとする．

> 1.内水河川流域降雨量による確率評価
>
> 2.内水時間帯降雨量による確率評価
>
> 3.湛水量による確率評価

5.  内水処理施設規模の決定

内水処理施設の規模は，内水区域の重要度，既往内水による被害の実態，本川計画規模とのバランス，近傍内水地域の計画規模とのバランス等を総合的に考慮して計画規模を決定の上，計画規模に相当する内水区域の治水安全度が確保できる施設規模を決定するものとする．

ただし，ポンプ排水については，原則として費用便益計算を踏まえ規模を決定するものとする．

施設配置等計画編

**第2章 河川施設配置計画**

**第2-3章 多目的施設**

目　次 {#目-次-8 .TOC-Heading}
======

[第1節 総説 1](#_Toc2679511)

[1．1 多目的施設の計画 1](#_Toc2679512)

[1．2 多目的施設の位置 1](#_Toc2679513)

[第2節 施設基本計画 2](#_Toc507604702)

[2．1 計画の調整 2](#_Toc507604703)

[2．2 経済性の検討（費用対効果分析） 2](#_Toc507604705)

[2．3 多目的貯水池計画 2](#_Toc507604708)

[2．3．1 必要容量の算定及び配分 2](#_Toc507604709)

[2．3．2 洪水調節容量 3](#_Toc507604711)

[2．3．3 流水の正常な機能を維持するための容量(不特定容量)
3](#_Toc507604713)

[2．3．4 かんがい容量 3](#_Toc507604715)

[2．3．5 都市用水容量 4](#_Toc507604717)

[2．3．6 発電容量 5](#_Toc507604719)

[2．3．7 堆砂容量 5](#_Toc507604721)

平成31年3月　版

10. 

```{=html}
<!-- -->
```
6.  河川施設配置計画

    2.  第2-3章 多目的施設

        2.  []{#_Toc2679511 .anchor}総説

        ```{=html}
        <!-- -->
        ```
        1.  []{#_Toc2679512 .anchor}多目的施設の計画

＜考え方＞

+----------------------------------------------------------------------+
| 治水、利水、環境保全等に係わる複数の目                               |
| 的を有するダム、遊水地、堰、流況調整河川等の多目的施設（以下、「多目 |
| 的施設」という。）は、それぞれの目的の必要性、事業ごとの経済性、多目 |
| 的施設としての運用や環境への影響等を検討した上で計画する必要がある。 |
|                                                                      |
| ダム再生（運用改善、既設ダムのかさ上げ、容量振替、既設ダム間の       |
| 連携利用等）等により、多目的施設を新設する場合に比べて経済的にかつ環 |
| 境に及ぼす影響もより少ない形で所要の効果を得ることが可能な場合がある |
| ので、既設施設の有効活用の可能性について積極的に検討する必要がある。 |
+----------------------------------------------------------------------+

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  多目的施設を計画する場合には、治水上、利水上、環境上のそれぞれの目的の必要性、事業ごとの経済性、多目的施設としての運用の容易性・効率性、自然環境の保全や自然環境との調和、社会環境に与える影響等について検討することを標準とする。その際、既設の多目的施設についても、長寿命化、維持管理の効率化、治水・利水機能の増強、河川環境の改善、地域の活性化等の観点から、積極的に既設施設の有効活用について検討することを標準とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1)  [ダム再生ビジョン](http://www.mlit.go.jp/common/001190127.pdf),平成29年6月,
    国土交通省水管理・国土保全局．

```{=html}
<!-- -->
```
3)  [ダム再生ガイドライン](http://www.mlit.go.jp/river/dam/pdf/guideline.pdf),平成30年3月,
    > 国土交通省水管理・国土保全局河川環境課流水管理室,治水課事業監理室．

    1.  []{#_Toc2679513 .anchor}多目的施設の位置

＜考え方＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------
  多目的施設の位置は、それぞれの目的とする機能の確実性、地形・地質、環境への影響、地域の実態、経済性、社会経済情勢の変化などを総合的に勘案して決定する必要がある。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 多目                                                                 |
| 的施設の位置は、それぞれの目的とする機能が確保される複数の候補サイト |
| の中から、地形・地質調査、環境調査等の調査結果、事業効果、地域の実態 |
| 、経済性などを総合的に勘案して最適なものを選定することを標準とする。 |
|                                                                      |
| 地形・地質調査は、多目的施設を建                                     |
| 設・維持するために、また、環境調査は、多目的施設周辺の環境を保全する |
| ために必要不可欠な調査であって、位置を選定する際の重要な情報となる。 |
+----------------------------------------------------------------------+

＜推　奨＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  洪水調節効果から考えると、治水計画上考えられている主要洪水防御地域にできるだけ近く、なるべく少数の大容量貯水池によって調節することが望ましい。貯水池群による洪水調節を計画する場合、利水上の必要があれば個々の貯水池への調節流量の配分は、利水目的との様々な組み合わせを考えて検討することが望ましい。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

6.  []{#_Toc507604702 .anchor}施設基本計画

```{=html}
<!-- -->
```
1.  []{#_Toc507604703 .anchor}計画の調整

＜考え方＞

  ----------------------------------------------------------------------------------------------------------------
  それぞれの目的、特に治水と利水は、水管理上競合する性格を持ったものであるため、各目的相互間の調整が必要である。
  ----------------------------------------------------------------------------------------------------------------

＜必　須＞

  ----------------------------------------------------------------------------------------------------------------------------------------------
  多目的施設計画の作成に当たっては、各目的にとって支障のない施設の運用方法とするため、計画の検討にあたって関係者間の調整をしなければならない。
  ----------------------------------------------------------------------------------------------------------------------------------------------

2.  []{#_Toc507604705 .anchor}経済性の検討（費用対効果分析）

＜考え方＞

  ----------------------------------------------------------------------------------------------------------------------------
  多目的施設の計画の決定に際しては、技術的な可能性、貯水池使用の合理性に加えて、経済性の検討（費用対効果分析）が必要である。
  ----------------------------------------------------------------------------------------------------------------------------

＜必　須＞

+----------------------------------------------------------------------+
| 多目的施設の計画の決定に当たっては、事業                             |
| ごとに、その経済性を検討しなければならない。原則として事業を実施する |
| ことによる総便益が事業に要する総費用を上回るものでなければならない。 |
|                                                                      |
| 総便益や                                                             |
| 総費用の算定に当たっては、事業ごとに適切な手法を選択するものとする。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1)  河川砂防技術基準
    調査編，平成26年4月改定，国土交通省水管理・国土保全局，[第8章
    河川経済調査](http://www.mlit.go.jp/river/shishin_guideline/gijutsu/gijutsukijunn/chousa/pdf/08.pdf).

    1.  []{#_Toc507604708 .anchor}多目的貯水池計画

        1.  []{#_Toc507604709 .anchor}必要容量の算定及び配分

＜考え方＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  多目的施設の貯水池（以下、「多目的貯水池」という。）における目的ごとの貯水容量は、洪水調節の要請、維持流量確保の要請、水需要、多目的貯水池の規模、堆砂などを総合的に勘案して配分する必要がある。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 各目的別の必要容量は、本章2.3.2 洪水調節容量 ～2.3.7 堆砂容量        |
| により算定することを標準とする。                                     |
|                                                                      |
| 流水の正常な機能の維持及び新規利水目的等に係わ                       |
| る容量の算定に当たっては、既往の水文資料からできるだけ長期間（20～3  |
| 0年やむを得ぬ場合は10年程度）の資料を収集し、10力年第1位相当（過去20 |
| 年第2位～過去30年第3位）の渇水時の流況を基準とすることを標準とする。 |
|                                                                      |
| 多目的貯水池にお                                                     |
| ける目的ごとの貯水容量は、限られた施設サイトを有効に活用するよう洪水 |
| 調節、流水の正常な機能の維持、新規利水等に配分することを基本とする。 |
+----------------------------------------------------------------------+

＜例　示＞

  ------------------------------------------------------------------------------------------------------------------
  消流雪用水のための容量、計画規模を超える異常渇水時にその被害を軽減するための渇水対策容量等を設定する場合がある。
  ------------------------------------------------------------------------------------------------------------------

2.  []{#_Toc507604711 .anchor}洪水調節容量

＜標　準＞

  -------------------------------------------------------------------------------
  第2-1章 河道並びに河川構造物 第3節 貯水池（ダム） 3.1.3 洪水調節容量 による。
  -------------------------------------------------------------------------------

3.  []{#_Toc507604713
    .anchor}流水の正常な機能を維持するための容量(不特定容量)

＜考え方＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  流水の正常な機能を維持するための容量（以下「不特定容量」という。）は、河川の維持及び既得水利の保護等流水の正常な機能を維持するために必要な容量であり、新規の水資源開発に際し優先的に確保すべき容量である。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 不特定                                                               |
| 容量は、渇水基準年において、「流水の正常な機能を維持するために必要な |
| 流量（以下「正常流量」という。）」を確保できる容量とし、計画基準点に |
| おける正常流量と自然流量との過不足計算により求めることを標準とする。 |
|                                                                      |
| ![](media/image3.png){width="5.369251968503937in"                    |
| height="2.691900699912511in"}                                        |
+----------------------------------------------------------------------+

＜関連通知等＞

1)  河川砂防技術基準
    調査編,平成26年4月改定,国土交通省水管理・国土保全局,第2章
    水文・水理観測,第11章 河川環境調査.

    （最新版）河川砂防技術基準 調査編,国土交通省水管理・国土保全局,第2章
    水文・水理観測（令和4年6月）,第11章 河川環境調査（令和6年6月）.

```{=html}
<!-- -->
```
4)  正常流量検討の手引き（案），平成 19 年 9
    > 月，国土交通省河川局河川環境課.

    1.  []{#_Toc507604715 .anchor}かんがい容量

＜考え方＞

+----------------------------------------------------------------------+
| かんが                                                               |
| い容量は、かんがい用水を補給するために必要な容量であり、正常流量を優 |
| 先的に考慮した流況に対して、必要取水量に対する必要補給量より求める。 |
|                                                                      |
| かんがい用水は時期別に必要                                           |
| 水量が異なり、地性、気候、作物の種類、期間などの地域の特徴を踏まえて |
| 、数年間にわたって実測を行って必要な水量を推定することが必要である。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| かんがい容量は、渇水基準年におい                                     |
| て、取水地点における計画取水量と正常流量、貯留制限等の条件を考慮した |
| 後の取水地点における流量との過不足計算により求めることを標準とする。 |
|                                                                      |
| かんがい用水の計画取水量は、補給                                     |
| 区域の地区別、期間別の必要水量にその地区の既得水利並びに有効雨量を考 |
| 慮し、取水地点において必要な取水量を期間別に定めることを標準とする。 |
|                                                                      |
| かんがい容量決                                                       |
| 定における利水計算に際しては、基準年における所要取水量波形を対象に（ |
| 有効雨量は差し引く）計算を行い、必要容量を算定することを標準とする。 |
|                                                                      |
| 渇水基準                                                             |
| 年については、多目的施設計画の対象となっている各種利水目的相互間の調 |
| 整を図るため、共通の渇水基準年を対象として計画することを標準とする。 |
|                                                                      |
| ![](media/image4.png){width="4.426173447069116in"                    |
| height="3.558161636045494in"}                                        |
+----------------------------------------------------------------------+

2.  []{#_Toc507604717 .anchor}都市用水容量

＜考え方＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  水道用水、工業用水を併せて都市用水と称するが、都市用水容量は、その取水を可能とするために必要な容量であり、正常流量を優先的に考慮した流況に対して、必要取水量に対する必要補給量より求める。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  都市用水容量は、都市用水の必要取水量を期間別に定め、渇水基準年における取水地点での正常流量、貯留制限の条件を考慮した後の取水地点での流況に対する過不足計算により求めることを標準とする。なお、利水必要取水量の計算は、都市用水、かんがい用水等を同列に考えることを標準とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

3.  []{#_Toc507604719 .anchor}発電容量

＜考え方＞

+----------------------------------------------------------------------+
| 発電容量は、水力発電                                                 |
| を行うための取水を可能とするために必要な容量であり、利用落差などを考 |
| 慮の上、ほかの目的との調整を行い、効率的に発電が可能なように定める。 |
|                                                                      |
| 洪水期中は                                                           |
| 発電最高水位を洪水貯留準備水位より上昇させないようにする必要がある。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 発電容量は、電力需要の状況、利用落差などを                           |
| 考慮の上、ほかの目的との調整を行い、経済的に定めることを標準とする。 |
|                                                                      |
| 発                                                                   |
| 電計画は10年以上にわたる流量資料をもとに計算を行うことを標準とする。 |
+----------------------------------------------------------------------+

＜例　示＞

+----------------------------------------------------------------------+
| 下                                                                   |
| 流に既設発電所がある場合、平常時の流況が好転することにより、増電（下 |
| 流増）になることがあるので、同効果についても把握しておく必要がある。 |
|                                                                      |
| 洪水期前に洪水貯留準備水位まで低下させる場合、使用水量以             |
| 上の放流を必要とするときの無効放流を前もって考慮し、さらに、洪水期後 |
| に貯水を開始し、需要期間に貯水し得るように容量を定めるよう計画する。 |
+----------------------------------------------------------------------+

4.  []{#_Toc507604721 .anchor}堆砂容量

＜考え方＞

  ------------------------------------------------------------------------------------------------------------------------------------------
  貯水池には経年的に土砂が流入・堆積し、貯水容量が減少することがある。目的とする治水・利水機能を発揮し続けるため、予め堆砂容量を確保する。
  ------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 堆砂容量は、100年間に貯水池内に堆積する                              |
| と推定される土砂量（計画堆砂量）に基づいて設定することを標準とする。 |
|                                                                      |
| 洪水吐きより土砂を流下させる                                         |
| 構造としたもの、貯水池への流入土砂を計画的に排除するもの等、特別の対 |
| 策を講じたものについては、計画堆砂量を減ずることができるものとする。 |
+----------------------------------------------------------------------+

＜推　奨＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  貯水池の堆砂量は、上流の砂防計画、流域の広狭、地質、林相などを考慮し推定堆砂量の計算結果等も参照し、総合的に決定するにあたり、類似地域における既設の貯水池の堆砂量から推定することが望ましい。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1)  [河川砂防技術基準
    維持管理編（ダム編）](http://www.mlit.go.jp/river/shishin_guideline/gijutsu/gijutsukijunn/ijikanri_dam/pdf/ijikanri_dam.pdf),平成28年3月改定,
    国土交通省水管理・国土保全局．

    （最新版）河川砂防技術基準
    維持管理編（ダム編），令和7年6月，国土交通省水管理・国土保全局.

```{=html}
<!-- -->
```
5)  [ダム定期検査の手引き「河川管理施設のダム版」](http://www.mlit.go.jp/river/shishin_guideline/dam/07.pdf),平成28年3月,
    > 国土交通省水管理・国土保全局河川環境課．

**施設配置等計画編**

**第２章　河川施設配置計画**

**第2-4章　水質保全施設**

**目　次**

[第1節 総説 1](#_Toc103791022)

[第2節 河川における水質保全対策 1](#_Toc509073496)

[第3節 貯水池・湖沼等における水質保全対策 4](#_Toc103791024)

令和４年６月　版

適用上の位置付け

　河川砂防技術基準計画編は、基準の適用上の位置付けを明確にするために、下表に示すように適用上の位置付けを分類している。

+--------+------------------+------------------+------------------+
| 分　類 | 適用上の位置付け | 末尾の字句例     |                  |
+--------+------------------+------------------+------------------+
| 考え方 | 技術資料         | ●目              | 「･･･ある。      |
|        |                  | 的や概念、考え方 | 」「･･･いる。」  |
|        |                  | を記述した事項。 |                  |
|        |                  |                  | 「･･･なる。      |
|        |                  |                  | 」「･･･れる。」  |
+--------+------------------+------------------+------------------+
| 必　須 | 技術基準         | ●法令による規定  | 「･･･なければ    |
|        |                  | や技術的観点から | ならない。」「･  |
|        |                  | 実施すべきである | ･･ものとする。」 |
|        |                  | ことが明確であり |                  |
|        |                  | 遵守すべき事項。 |                  |
+--------+------------------+------------------+------------------+
| 標　準 | 技術基準         | ●特              | 「･･･            |
|        |                  | 段の事情がない限 | を標準とする。」 |
|        |                  | り記述に従い実施 |                  |
|        |                  | すべきだが、状況 | 「･･･            |
|        |                  | や条件によって一 | を基本とする。」 |
|        |                  | 律に適用すること |                  |
|        |                  | はできない事項。 | 「･･･による。」  |
+--------+------------------+------------------+------------------+
| 推　奨 | 技術資料         | ●状況や条件      | 「               |
|        |                  | によって実施する | ･･･望ましい。」  |
|        |                  | ことが良い事項。 |                  |
|        |                  |                  | 「               |
|        |                  |                  | ･･･推奨する。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･務める。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･必要に応    |
|        |                  |                  | じて･･･する。」  |
+--------+------------------+------------------+------------------+
| 例　示 | 技術資料         | ●適用条件や実施  | 「               |
|        |                  | 効果について確定 | ･･･などの手法（  |
|        |                  | している段階では | 事例）がある。」 |
|        |                  | ないが、状況や条 |                  |
|        |                  | 件によっては導入 | 「･･･など        |
|        |                  | することが可能な | の場合がある。」 |
|        |                  | 新技術等の例示。 |                  |
|        |                  |                  | 「･･･など        |
|        |                  | ●状              | が考えられる。」 |
|        |                  | 況や条件によって |                  |
|        |                  | 限定的に実施でき | 「               |
|        |                  | る技術等の例示。 | ･･･の場合には･･･ |
|        |                  |                  | ことができる。」 |
|        |                  | ●具体的          |                  |
|        |                  | に例示することに | 「               |
|        |                  | より、技術的な理 | ･･･例示する。」  |
|        |                  | 解を助ける事項。 |                  |
|        |                  |                  | 「例えば･･･。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･事例もある  |
|        |                  |                  | 。･･･もよい。」  |
+--------+------------------+------------------+------------------+

  関連通知等       関連する通知やそれを理解する上で参考となる資料
  ---------------- ------------------------------------------------------
  参考となる資料   例示等に示した手法・内容を理解する上で参考となる資料

> **第2-4章　水質保全施設**

1.  []{#_Toc103791022 .anchor}総説

＜考え方＞

河川等の水質保全対策やその施設等計画を検討する際は、河川管理者と流域の関係機関等で協力して複数の代替案を作成し、対策の位置、手法、期待される効果等を踏まえて比較検討を行った上で、対策案を設定することが重要である。

水質保全対策の選定の基本的な考え方は以下のとおりである。

1.対策位置の選定

水質の流下方向の変化及び負荷量の分布状況から、汚濁の影響の大きい区域や流入河川・
排水路を選定する。

2.対策の抽出

対象とする水質項目に関して適用条件等を考慮して、適切な対策を抽出する。

3.対策規模の設定

代表地点での予測結果と水質保全目標値を比較することにより行い、摘出された対策ごとに規模を設定する。

4.対策の選定

抽出された対策の中から、立地条件、経済性、維持管理性等を比較することにより、最適な対策の選定と配置を行う。

配置に当たっては、動植物の生息・生育の場の状況、周辺環境との調和についても留意する必要がある。

対策案の設定に当たっては、対策の効果発揮までの時間的なずれを考慮する必要がある。

＜標　準＞

+----------------------------------------------------------------------+
| 河川等の水質の保全を図るため、水質に関す                             |
| る現況等を把握し、流域の自然環境や社会環境及びその変遷を踏まえ、河川 |
| の持つ治水、利水及び環境の多面的な機能と整合を図りながら、河川、貯水 |
| 池・湖沼等における水質保全対策やその施設等計画を策定するものとする。 |
|                                                                      |
| 水質保全対策は、良好な水質の保全の方策（第1章1.4                     |
| 解説4）に基づいた役割分担に応じて、河川・貯                          |
| 水池・湖沼等と流域に個々に割り当てられたものについて、それぞれの特徴 |
| を踏まえながら、複数の対策案を検討し、最適な案を選定するものとする。 |
+----------------------------------------------------------------------+

＜推　奨＞

水質保全対策は、維持管理面でのウエイトが大きくなることから、管理がしやすく、ランニングコストの低い対策を選定することが望ましい。

2.  []{#_Toc509073496 .anchor}河川における水質保全対策

＜考え方＞

河川における水質保全対策には、負荷削減、負荷の分離、流量の確保、及び河川の浄化機能の強化等がある。これらにおいて留意する点は以下のとおりである。

> 1.　負荷削減の手法を選定するに当たっては、浄化対象水質項目及びその性状を踏まえ、底泥・汚泥等の処分・利用も考慮する必要がある。

施設の位置は、効率良く負荷を削減できる箇所を設定するものとする。

2.　負荷の分離手法を選定するに当たっては、下流への影響を考慮する必要がある。

> 3.　流量の確保手法を選定するに当たっては、導水水源の流況、水質、利水計画、地理的条件及び導水地点下流の河川環境への影響を考慮する必要がある。
>
> 4.　河川の浄化機能の強化を選定するに当たっては、水質の縦断分布、流速、底泥の状態等を踏まえ、効率良く浄化機能の強化を図ることができる位置を設定するものとする。

これらの機能を組み合わせて複数の代替案を作成し、対策の位置、手法、期待される効果等を踏まえて比較検討を行った上で、対策案を設定する

＜標　準＞

+----------------------------------------------------------------------+
| > 河川における水                                                     |
| 質保全対策には、負荷削減、負荷の分離、流量の確保、及び河川の浄化機能 |
|                                                                      |
| の強化等がある。                                                     |
| これらの機能を組み合わせて複数の代替案を作成し、対策の位置、手法、期 |
|                                                                      |
| 待される効果等を                                                     |
| 踏まえて比較検討を行った上で、対策案を設定するものとする。対策案の設 |
|                                                                      |
| 定に当たっては、                                                     |
| 対策の水質目標、効果、経済性、維持管理性及び環境への影響等を踏まえる |
|                                                                      |
| ものとする。                                                         |
+----------------------------------------------------------------------+

＜例　示＞

(1)負荷削減

①　直接浄化による水質保全

> 発生負荷源への対策（流域対策）の遅れ等により、河川等が汚濁し緊急的な改善を要する条件下では有効な対策である。
>
> 直接浄化による水質改善を計画する場合には、対象水域の水理・水質特性及び施設の設置位置を調査し、水域の特性に対応した最も適切な方法、規模を設定する。
>
> 直接浄化法を選択するに当たっては、対象水域の水理・水質の特性に応じて、適切な浄化方法を選択するものとする。例えば、粒子性と溶解性の構成比等により、浄化方法が異なってくる。また、直接浄化法は、汚泥の管理が必要であり、汚泥管理がしやすく、ランニングコストの低い対策を選択することが望ましい。対象水量は、浄化施設の大きさを決定する上で重要であり、目標の達成頻度などを踏まえ、決定する。
>
> 対策施設の設置位置は、場所（堤内地、高水敷、河道等）、広さ、形状、高低差及び動植物の生息・生育の場等によって、浄化方法、取水・放流方式が左右されるため、十分な調査が必要である。
>
> 参考に主な直接浄化手法を下表に示す。

\[参考\]　直接浄化法の手法

+----------+----------+------------------+----------------------+
| 浄化方法 | 原　理   | 浄化対象         | 特　　徴             |
+==========+==========+==================+======================+
| 接触酸化 | 生物酸化 | 有機物、SS       | 礫、                 |
|          |          |                  | プラスチック等の接触 |
|          | 沈殿     | NH4-N            | 材の付着微生物群の生 |
|          |          |                  | 育による有機物の分解 |
+----------+----------+------------------+----------------------+
| 土壌浄化 | ろ過     | 有機物、栄養塩類 | 土壌の持つ吸着       |
|          |          |                  | 、分解ろ過、建物への |
|          | 吸着     | SS、色           | 取り込みの作用を利用 |
+----------+----------+------------------+----------------------+
| 酸化池   | 生物酸化 | 有機物、栄養塩類 | 池の微生物による有   |
|          |          |                  | 機物の分解及び栄養塩 |
|          | 沈殿     | SS               | 類の取り込み，流速低 |
|          |          |                  | 下によるSS物質の沈殿 |
+----------+----------+------------------+----------------------+
| 植生浄化 | 植物吸収 | 有機物、栄養塩類 | 植物による栄養塩の取 |
|          |          |                  | り込み、流速低下によ |
|          | 沈殿     | SS               | るSS物質の沈殿、土壌 |
|          |          |                  | への吸着、生物の生息 |
|          |          |                  | ・生育場としても機能 |
+----------+----------+------------------+----------------------+

> 直接浄化法には各種のものがあるが、これまでに実績が多いものには接触酸化法がある。接触酸化法は、礫等の接触材によるろ過や沈殿及び付着生物による有機物の分解を期待した手法で、河川の自浄作用を応用した対策である。

② 底泥の浚渫

> 底泥が水質汚濁の要因となっている場合は、汚濁堆積物を直接除去する浚渫は有効な対策である。しかし、流入負荷の再堆積により効果の持続性確保が困難になることや、浚渫土の処理負担について留意する必要がある。
>
> 底泥の浚渫計画は、浚渫の範囲及び量を定めるとともに、浚渫工法、時期を決定し、底泥処理配土計画を立てる。
>
> 浚渫の範囲及び量の設定は、底質調査結果をもとに、栄養塩類濃度と溶出速度等の関係から、浚渫を必要とする底泥栄養塩濃度を定め、浚渫する範囲と浚渫深度（浚渫量）を定める。
>
> 浚渫工法は、対象水域の水理状況、底泥の性状等に応じて決定するが、浚渫に当たってはできるだけ底尼を乱さないようにすることが重要である。特に有害物質の除去基準を越えた底泥は、流失したり飛散することのないような工法を計画するとともに、処理に当たっては無害化処理、管理型処分地への配土等を行わなければならない。
>
> また、浚渫の時期については、のりや魚介類等の採取時期、底泥からの臭気の発生時期等に配慮する必要がある。
>
> 底泥処理配土計画を立てるに当たっては、ストックヤードでの固化や天日乾燥等の処分方法の計画、及び最終処分地の計画を定めるものとする。

(2)負荷の分離

負荷の分離手法には、流水保全水路が挙げられる。

流水保全水路とは、河川水と汚濁水とを分離する目的のものである。

計画に当たっては汚濁水の流入状況、上水道の取水位置、流域の有害物質の保有状況及び放流水質等を勘案して適切な流水の分離方法を検討し、対象区域、ルート、処理方法等を定める。

流水保全水路は、河道内において、河川水と汚濁水とを分離して流す低水路であるため、河川の下流部で上水道用水を取水している河川や、汚濁支川・排水路が幾つも流入している河川などでは水質保全対策として有効である。

流水保全水路で処理が必要な場合には、放流先の水質状況や基準等を踏まえた放流目標水質の設定を行い、設定された水質項目と目標値とに対応した処理方法を選定するものとする。

> 汚濁水を流下させる場合は、放流地点における影響を評価し、必要に応じ水質改善対策を実施する。

(3)流量の確保

流量の確保による効果は、汚濁水の希釈のほか、溶存酸素の改善、水域の滞留時間の短縮等が挙げられる。

浄化用水の導入を計画するに当たっては、対象水域の水質、流量等を調査し、浄化用水量を決定する。また、ほかの治水・利水計画と十分調整を図る必要がある。

流量確保の方法は他の河川などからの浄化用水の導水とダムなどによる維持流量の確保が考えられる。ここでは導水による浄化用水の確保について示す。

計画を立てる場合、浄化用水の量は、河川の水利用状況、下水道整備状況等により変化するので現状並びに将来の推移を十分に勘案し、各時点における効果を明らかにする必要がある。また、導水元の導水可能量については、導水元の河川の利用や河川環境の保全等に留意する。浄化用水を流す河道の疎通能力についてもチェックが必要である。

導水の取水口及び放流口の位置については、動植物の生息・生育の場に留意する必要がある。貯水池、導水路、揚水ポンプ等の計画は、治水・利水目的で計画している施設計画と十分調整し、これらの施設と兼用できるものは調整して計画する。

下水処理水、海水等の導入は、都市内の小河川で、近くに水源がない場合に有効である。導入する水質については導入先の水域の水質改善が図られることに留意して、必要に応じて導入水の処理も考慮する必要がある。

\(4\) 河川の浄化機能の強化

感潮域やダム、堰等の湛水区域等の水が滞留するようなところでは酸素が欠乏し、有機物の分解が進まない場合がある。このようなところでは、曝気や噴水により、酸素を供給することによって酸化力の増大を図る方法がある。

この場合には、対象水域の水理・水質特性、河道の状態及び施設の設置位置等を調査し、必要な規模を設定するものとする。

また、単調な河道に、瀬、淵、曲がり等の変化を持たせたり、河岸に植生帯を設けることも、水質保全のための有効な手法である。

3.  []{#_Toc103791024 .anchor}貯水池・湖沼等における水質保全対策

＜考え方＞

貯水池・湖沼等における水質保全対策には、湛水域の水質保全を目的としたものと、下流域への影響を軽減するためのものがある。なお、貯水池・湖沼等とは、貯水池、湖沼のほか、堰湛水池、及び調節池が含まれる。

貯水池・湖沼等では、冷水問題、濁水長期化問題及び富栄養化問題に対し、それぞれ適した対策があるが、これらには、目的とする水質問題のほかに、ほかの水質問題にも効果を持つものがある。例えば、冷水問題の対策である選択取水設備は、洪水時及びその後における運用により、濁水長期化問題にも効果がある。

一方、ある水質問題に対する対策が、ほかの水質問題への影響となる場合もある。例えば、選択取水設備については、冷水問題に重きを置いて表面取水に偏ると、洪水時及びその後には洪水時に流入した濁水塊は貯水池に滞留し、濁水の長期化となるおそれがある。富栄養化問題においては、水温と濁度のコントロールを間違うと、富栄養化問題を助長することになる場合もあり得る。

このように、水質保全対策の選定においては、対策の併用化及び影響の防止の面から事前の水質シミュレーションや、改善効果等をモニタリングしながら段階的に対策を実施する順応的管理の導入等十分な検討が必要である。

貯水池・湖沼等における機能ごとの水質保全対策で留意する点は以下のとおりである。

> 1.　水温・流動制御の手法を選定するに当たっては、貯水池内の成層状況を示す水温の鉛直分布を踏まえ、貯水池の回転率及び流入水の貯水池内での拡散状況等を考慮する必要がある。
>
> 施設の位置は、貯水池形状に応じて設定し、その規模については、放流水量や気象条件等から、水温躍層の形成状況及び効果の予測を行ったうえで設定するものとする。
>
> 2.　負荷削減の手法を選定するに当たっては、浄化対象水質項目及びその性状を踏まえ、底泥・汚泥の処分・利用等を考慮する必要がある。
>
> 施設の位置は、効率良く負荷を削減できる箇所に設定するものとする。

3.　負荷の分離手法を選定するに当たっては、下流への影響を考慮する必要
がある。

> 施設の位置は、できるだけその延長を短くできる箇所に設定するものとする。
>
> 4.　導水を選定するに当たっては、導水の水源となる河川の流況、水質、利水計画、地理的条件を考慮することが必要である。
>
> また、水質保全対策の実施においては、学識者等からの指導助言が得られる体制の構築や流域関係者と連携して取り組むことも重要である。

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  貯水池・湖沼等における水質保会対策には、水温・流動の制御、負荷削減、負荷の分離及び導水等がある。これらの機能を組み合わせて複数の代替案を作成し、対策の位置、手法、期待される効果等を踏まえて事前の影響検討を行った上で、対策案を設定するものとする。対策案の設定に当たっては、対策の水質目標、効果、経済性、維持管理性、環境への影響及び、学識者等の助言等を踏まえるものとする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

　

＜例　事＞

上記の考え方を踏まえた上で、適切な手法を選定することが必要である。

1\. 水温・流動の制御

(1） 選択取水設備

> 選択取水設備は、冷水対策、濁水長期化対策、及び富栄養化対策に適用可能である。いずれの場合も、貯水池が成層化することが適用条件であり、貯水池の水温・水質特性、濁質分布並びに流入水の水質特性に応じて、運用方法を検討する必要がある。

(2） 曝気式循環施設

> 曝気式循環施設は、冷水対策、濁水長期化対策、及び富栄養化対策に適用可能である。貯水池特性及び水質特性を踏まえ、曝気循環の目的に応じた手法、位置、規模等を設定する。施設の設置・運用・効果確認を行う際の標準的事項や留意事項については、既存の技術資料の活用が有効である。
>
> また、選択取水設備と組み合わせることにより、効果が大きくなることもある。

2.　負荷削減

(1） 流入水質対策

> 流入水質対策は、富栄養化対策に適用可能であり、栄養塩の削減を図るものである。浄化手法としては、植生浄化、土壌浄化等が挙げられる。汚濁支川の水質・負荷量特性を踏まえ、対象流量、用地条件、維持管理性、コスト等を考慮して、手法、位置、規模等を設定する。

(2） 前貯水池

> 前貯水池は富栄養化対策に適用可能であり、貯水池に流入させる前に一時的に貯留できるダム等を設置し、栄養塩の沈降を図るものである。
>
> 栄養塩の性状（溶存態と粒子慈の比率等）や流入負荷量特性を踏まえ、栄養塩の沈降に必要な滞留時間と対象流量をもとに、用地条件、経済性等を考慮して、施設規模（容量）及び位置を設定する。

(3） 底泥浚渫

> 底泥浚渫は富栄養化対策に適用可能であり、底泥の酸素消費の抑制及び栄養塩の溶出抑制のた
> めに行う。底泥浚渫を計画するに当たっての手順及び留意事項は、河川における水質保全対策の底泥浚渫と同様である（第
> 2 節 河川における水質保全対策参照）。

(4） 流域における水質保全対策

河川管理者が流域で行うことのできる対策としては、以下のものが挙げられる。

> ① 普通河川での直接浄化等を実施する。

②
濁水、富栄養化等の著しい貯水地において、貯水池の周辺に「環境保全帯」を設け、樹林

帯の整備を行う。

3\. 負荷の分離

> バイパスは濁水長期化対策及び富栄養化対策に適用可能である。濁水長期化対策としては、流入河川中に含まれる濁度の高い濁水をバイパスする方法と貯水池上流端より流入する清水を取水し、貯水池をパイパスする方法（清水パイパス）がある。富栄養化対策としては、植物プランクトンの増殖の要因となる栄養塩を貯水池に入れないことにより、植物プランクトンの増殖を低減する。
>
> いずれについても、流入荷川の水質・負荷量特牲を踏まえ、貯水池の運用及び下流側の水量、水質、環境を考慮して計画を立てる必要がある。また、出水時の土砂等への対応を考慮する必要がある。

4\. 導水

> 導水は富栄養化対策に適用可能である。ほかの水源から導水することにより湖沼等の回転率を上げ、植物プランクトンの増殖抑制を図る。ただし、導水される水の栄養塩濃度に留意する必要がある。
>
> 導水を計画するに当たっては、対象水域及び導水水源の水質、流量等を調査し、治水・利水計画と十分な調整を図り、導水量を決定する。
>
> なお、着色（赤水、黒水）、有害物質の蓄積・溶出等の問題への対策としては、底泥対策（浚渫、覆砂）、曝気循環による底層
> DOの改善等が挙げられる。

＜関連通知等＞

6)  ダム貯水池水質改善の手引き　平成30年3月，国土交通省水管理・国土保全局河川環境課.

7)  ダム貯水池水質改善に向けた水質シミュレーション活用のためのマニュアル（案）令和3年5月，国土交通省水管理・国土保全局河川環境課.

8)  ダム貯水池水質改善に向けた気泡式循環施設マニュアル（案）令和3年5月，国土交通省水管理・国土保全局河川環境課.

**施設配置等計画編**

**第３章 砂防等施設配置計画**

**目 次**

[第3-1章 総説](#_Toc67325259) [1](#_Toc67325259)

[第3-2章 砂防施設配置計画](#_Toc67325260) [2](#_Toc67325260)

[第1節 総説](#_Toc67325261) [2](#_Toc67325261)

[第2節
短期（一連の降雨継続期）土砂・流木流出対策施設配置計画](#_Toc67325262)
[3](#_Toc67325262)

[2．1 総説](#_Toc67325263) [3](#_Toc67325263)

[2．2 土砂・洪水氾濫対策施設配置計画](#_Toc67325264) [3](#_Toc67325264)

[2．2．1 総説](#_Toc67325265) [3](#_Toc67325265)

[2．2．2
山腹における土砂生産抑制のための施設（山腹保全工）](#_Toc67325266)
[4](#_Toc67325266)

[2．2．3 渓床・渓岸における土砂生産抑制のための施設](#_Toc67325267)
[6](#_Toc67325267)

[2．2．4 土砂の流出抑制あるいは調節のための施設](#_Toc67325268)
[9](#_Toc67325268)

[2．3 土石流・流木対策施設配置計画](#_Toc67325269) [11](#_Toc67325269)

[2．3．1 総説](#_Toc67325270) [11](#_Toc67325270)

[2．3．2 土石流・流木の捕捉のための施設](#_Toc67325271)
[11](#_Toc67325271)

[2．3．3 土石流・流木の堆積のための施設](#_Toc67325272)
[14](#_Toc67325272)

[2．3．4 土石流・流木の制御のための施設](#_Toc67325273)
[15](#_Toc67325273)

[2．3．5 土石流・流木の発生抑制のための施設](#_Toc67325274)
[15](#_Toc67325274)

[2．4 土砂・洪水氾濫時に流出する流木の対策施設配置計画](#_Toc67325275)
[16](#_Toc67325275)

[2．4．1 総説](#_Toc67325276) [16](#_Toc67325276)

[2．4．2 流木生産抑制のための施設](#_Toc67325277) [17](#_Toc67325277)

[2．4．3 流木捕捉のための施設](#_Toc67325278) [17](#_Toc67325278)

[第3節 中期（土砂流出活発期）土砂流出対策施設配置計画](#_Toc67325279)
[19](#_Toc67325279)

[3．1 総説](#_Toc67325280) [19](#_Toc67325280)

[第4節 長期（土砂流出継続期）土砂流出対策施設配置計画](#_Toc67325281)
[21](#_Toc67325281)

[4．1 総説](#_Toc67325282) [21](#_Toc67325282)

[第5節 火山砂防施設配置計画](#_Toc67325283) [22](#_Toc67325283)

[5．1 総説](#_Toc67325284) [22](#_Toc67325284)

[5．2 降灰後土石流対策施設配置計画](#_Toc67325285) [23](#_Toc67325285)

[5．2．1 総説](#_Toc67325286) [23](#_Toc67325286)

[5．2．2 降灰後の土石流・流木の捕捉のための施設](#_Toc67325287)
[25](#_Toc67325287)

[5．2．3 降灰後の土石流・流木の堆積のための施設](#_Toc67325288)
[25](#_Toc67325288)

[5．2．4 降灰後の土石流・流木の制御のための施設](#_Toc67325289)
[25](#_Toc67325289)

[5．2．5 降灰後の土石流・流木の発生抑制のための施設](#_Toc67325290)
[26](#_Toc67325290)

[5．3 火山泥流対策施設配置計画](#_Toc67325291) [26](#_Toc67325291)

[5．3．1 総説](#_Toc67325292) [26](#_Toc67325292)

[5．3．2 火山泥流・流木の流出抑制のための施設](#_Toc67325293)
[28](#_Toc67325293)

[5．3．3 火山泥流・流木の捕捉のための施設](#_Toc67325294)
[28](#_Toc67325294)

[5．3．4 火山泥流・流木の堆積のための施設](#_Toc67325295)
[29](#_Toc67325295)

[5．3．5 火山泥流・流木の制御のための施設](#_Toc67325296)
[29](#_Toc67325296)

[5．3．6 火山泥流・流木の発生抑制のための施設](#_Toc67325297)
[29](#_Toc67325297)

[5．4 溶岩流対策施設配置計画](#_Toc67325298) [30](#_Toc67325298)

[5．4．1 総説](#_Toc67325299) [30](#_Toc67325299)

[5．4．2 溶岩流の制御のための施設](#_Toc67325300) [31](#_Toc67325300)

[第6節 深層崩壊・天然ダム等異常土砂災害対策施設配置計画](#_Toc67325301)
[32](#_Toc67325301)

[6．1 総説](#_Toc67325302) [32](#_Toc67325302)

[6．2 深層崩壊の発生の抑制・抑止のための施設](#_Toc67325303)
[34](#_Toc67325303)

[6．3 天然ダムの高さの低減のための施設](#_Toc67325304)
[35](#_Toc67325304)

[6．4 天然ダムの急激な決壊の抑制のための施設](#_Toc67325305)
[35](#_Toc67325305)

[6．5
天然ダムの決壊時に流出する土砂・泥水の流出制御のための施設](#_Toc67325306)
[35](#_Toc67325306)

[6．6 深層崩壊による土石流の捕捉のための施設](#_Toc67325307)
[36](#_Toc67325307)

[6．7 深層崩壊による土石流の流出抑制のための施設](#_Toc67325308)
[36](#_Toc67325308)

[第7節 地すべり防止施設配置計画](#_Toc67325309) [38](#_Toc67325309)

[7．1 総説](#_Toc67325310) [38](#_Toc67325310)

[7．2 地すべり防止施設配置計画](#_Toc67325311) [38](#_Toc67325311)

[7．2．1 総説](#_Toc67325312) [38](#_Toc67325312)

[7．2．2 抑制工](#_Toc67325313) [39](#_Toc67325313)

[7．2．3 抑止工](#_Toc67325314) [40](#_Toc67325314)

[第8節 急傾斜地崩壊対策施設配置計画](#_Toc67325315) [42](#_Toc67325315)

[8．1 総説](#_Toc67325316) [42](#_Toc67325316)

[8．2 急傾斜地崩壊対策施設配置計画](#_Toc67325317) [42](#_Toc67325317)

[8．2．1 総説](#_Toc67325318) [42](#_Toc67325318)

[8．2．2 斜面の崩壊又は滑動の抑制を図る工法](#_Toc67325319)
[43](#_Toc67325319)

[8．2．3 斜面の崩壊又は滑動の抑止を図る工法](#_Toc67325320)
[43](#_Toc67325320)

[8．2．4 崩壊土砂の保全対象への到達の防止を図る工法](#_Toc67325321)
[44](#_Toc67325321)

[第9節 雪崩対策施設配置計画](#_Toc67325322) [45](#_Toc67325322)

[9．1 総説](#_Toc67325323) [45](#_Toc67325323)

[9．2 雪崩対策施設配置計画](#_Toc67325324) [45](#_Toc67325324)

[9．2．1 総説](#_Toc67325325) [45](#_Toc67325325)

[9．2．2 予防工](#_Toc67325326) [46](#_Toc67325326)

[9．2．3 防護工](#_Toc67325327) [46](#_Toc67325327)

[第10節 都市山麓グリーンベルト施設配置計画の基本](#_Toc67325328)
[47](#_Toc67325328)

[10．1 総説](#_Toc67325329) [47](#_Toc67325329)

令和3年4月　版

1.  砂防等施設配置計画

    2.  []{#_Toc67325259 .anchor}総説

＜標　準＞

+----------------------------------------------------------------------+
| 砂防等                                                               |
| 施設配置計画は、砂防基本計画に基づき策定する砂防施設配置計画、地すべ |
| り防止計画に基づき策定する地すべり防止施設配置計画、急傾斜地崩壊対策 |
| 計画に基づき策定する急傾斜地崩壊対策施設配置計画、雪崩対策計画に基づ |
| き策定する雪崩対策施設配置計画、都市山麓グリーンベルト整備計画に基づ |
| き策定する都市山麓グリーンベルト施設配置計画からなる。ここでの施設配 |
| 置計画とは、災害発生前に実施する事前対策施設の配置計画を基本とする。 |
|                                                                      |
| なお、砂防（土砂災害等対策）計画の構成は、図3-1に示すとおりである。  |
|                                                                      |
| ![](media/image5.emf){width="5.022916666666666in"                    |
| height="3.7222222222222223in"}                                       |
|                                                                      |
| 図3-1　砂防（土砂災害等対策）計画の構成                              |
+----------------------------------------------------------------------+

＜推　奨＞

砂防等施設配置計画の策定にあたって、以下の観点について検討することが望ましい。

> ・既往の災害履歴と事業の変遷
>
> ・流砂系における総合的な土砂管理
>
> ・良好な自然環境の復元
>
> ・良好な景観の維持・形成
>
> ・流域等の利活用
>
> ・気候変動を踏まえた土砂災害への対応
>
> ・砂防等施設の長寿命化への配慮

3.  []{#_Toc67325260 .anchor}砂防施設配置計画

    1.  []{#_Toc67325261 .anchor}総説

＜考え方＞

砂防施設配置計画は、基本計画編の第3章「砂防（土砂災害等対策）計画」に示される災害を引き起こす現象、現象が生じる時間スケールに応じ、短期（一連の降雨継続期）土砂・流木流出対策施設配置計画、中期（土砂流出活発期）土砂流出対策施設配置計画、長期(土砂流出継続期）土砂流出対策施設配置計画、火山砂防施設配置計画、深層崩壊・天然ダム等異常土砂災害対策施設配置計画からなる。

砂防施設配置計画は、砂防基本計画において合理的かつ効果的に有害な土砂を処理するために策定された土砂処理計画に基づき、各施設に求められる機能を明確にし、施設の機能が最も有効に発揮される概略の位置や概略の規模、施設の型式等を定める。除石等を伴う管理型施設の配置においては、管理の頻度や容易さを考慮して概略の位置や概略の規模、施設の型式等を定める。

＜標　準＞

+----------------------------------------------------------------------+
| 砂防基本計画に基づき                                                 |
| 策定する砂防施設配置計画は、短期（一連の降雨継続期）土砂・流木流出対 |
| 策施設配置計画、中期（土砂流出活発期）土砂流出対策施設配置計画、長期 |
| (土砂流出継続期）土砂流出対策施設配置計画、火山砂防施設配置計画、深  |
| 層崩壊・天然ダム等異常土砂災害対策施設配置計画からなる。短期、中期、 |
| 長期において対象とする土砂流出のイメージは図3-2に示すとおりである。  |
|                                                                      |
| 砂防                                                                 |
| 施設配置計画は、土砂・流木の生産抑制を目的とした施設と土砂・流木の流 |
| 送制御を目的とした施設を適切に組み合わせて策定することを基本とする。 |
|                                                                      |
| ![](media/image6.png){width="4.540277777777778in"                    |
| height="3.220138888888889in"}                                        |
|                                                                      |
| 図3-2　短期、中期、長期で対象とする土砂流出のイメージ                |
+----------------------------------------------------------------------+

1.  []{#_Toc67325262
    > .anchor}短期（一連の降雨継続期）土砂・流木流出対策施設配置計画

    1.  []{#_Toc67325263 .anchor}総説

＜考え方＞

短期は、計画規模の現象が発生する一連の降雨継続期間を目安に設定する。短期において対象とする土砂流出のイメージは図3-2に示すとおりである。

短期土砂・流木流出対策施設配置計画は、山地域からの流出土砂に伴う河床上昇等により引き起こされる土砂・洪水氾濫を防止・軽減するための土砂・洪水氾濫対策施設配置計画、土石流危険渓流において生じる土石流・流木の直撃等の直接的な災害を防止・軽減するための土石流・流木対策施設配置計画、山地域からの流出した流木により河積が阻害されることなどにより引き起こされる土砂・洪水氾濫を防止・軽減するための土砂・洪水氾濫時に流出する流木の対策施設配置計画に分類できる

短期土砂・流木流出対策施設配置計画は、大規模土砂生産後の減災対応等に配慮した上で、中期土砂流出対策施設配置計画、火山砂防施設配置計画、深層崩壊・天然ダム等異常土砂災害対策施設配置計画と整合するように定める。

＜標　準＞

+----------------------------------------------------------------------+
| 短期（一連の降雨継続期）土砂・流木流出対策施設配置計画               |
| は、土砂・洪水氾濫対策施設配置計画、土石流・流木対策施設配置計画、土 |
| 砂・洪水氾濫時に流出する流木の対策施設配置計画の組み合わせからなる。 |
|                                                                      |
| 短期（一連の降雨継続期）土砂・流木流出対策施設配置計画の策定にあたっ |
| ては、各施設の機能が有効に発揮されるように計画することを基本とする。 |
+----------------------------------------------------------------------+

2.  []{#_Toc67325264 .anchor}土砂・洪水氾濫対策施設配置計画

    1.  []{#_Toc67325265 .anchor}総説

＜考え方＞

土砂・洪水氾濫対策施設配置計画においては、土砂生産抑制計画及び土砂流送制御計画からなる土砂処理計画を満たすために、土砂の生産抑制、流出抑制、調節や土石流の捕捉、堆積、制御、発生抑制等の機能を有する施設を適切に選定し、施設の概略の位置や砂防堰堤高等の概略の規模を定める。また、土砂・洪水氾濫対策施設には、生産抑制を主な目的とする施設と流送制御を主な目的とする施設があり、それぞれについて適切に配置する必要がある。

土砂・洪水氾濫対策施設配置計画の検討は、現地調査、資料調査による施工の実行性の検討等とともに、施設の効果評価を数値計算等により行うことを基本とする。検討した施設配置計画では十分な効果が得られないと判断された場合、施設配置計画を見直して、再度数値計算等により効果評価を行う。

なお、対象地域において生じる可能性がある土石流・流木等その他の山地域の土砂生産・流送に起因する災害への対策を考慮した上で、当該地域の被害軽減に効果的な施設配置計画を検討する。

土砂・洪水氾濫対策施設に求められる機能毎の土砂・洪水氾濫対策施設の種類を以下に示す。なお、土石流の捕捉、土石流の堆積、土石流の制御については、第3-2章2.3「土石流・流木対策施設配置計画」を参照すること。

表3-1　土砂・洪水氾濫対策施設の種類

+----------------+----------------+----------------+----------------+
|                | 対策施設に     | 主な工種       |                |
|                | 求められる機能 |                |                |
+================+================+================+================+
| 土砂・洪水氾濫 | 生産抑制       | 山腹におけ     | 山腹工         |
|                |                | る土砂生産抑制 |                |
| 対策施設       |                |                |                |
+----------------+----------------+----------------+----------------+
|                |                | 渓             | 砂防堰堤       |
|                |                | 床・渓岸におけ | 、床固工、護岸 |
|                |                | る土砂生産抑制 | 工、渓流保全工 |
+----------------+----------------+----------------+----------------+
|                | 流送制御       | 土砂の流出抑   | 砂防堰堤、     |
|                |                | 制あるいは調節 | 渓流保全工、遊 |
|                |                |                | 砂地工、床固工 |
+----------------+----------------+----------------+----------------+
|                |                | 土石流の捕捉   | 砂防堰堤       |
+----------------+----------------+----------------+----------------+
|                |                | 土石流の堆積   | 土石流堆積工   |
+----------------+----------------+----------------+----------------+
|                |                | 土石流の制御   | 土石流         |
|                |                |                | 導流工、土石流 |
|                |                |                | 緩衝樹林帯、土 |
|                |                |                | 石流流向制御工 |
+----------------+----------------+----------------+----------------+

＜標　準＞

+----------------------------------------------------------------------+
| 土砂・洪水氾濫対策施設配置計画は、土砂・洪水氾濫対策                 |
| 計画の土砂生産抑制計画、土砂流送制御計画を満たすよう、土砂・洪水氾濫 |
| 対策施設の配置について、数値計算等に基づき計画することを基本とする。 |
|                                                                      |
| 土砂・洪水氾濫対策施設は、計画で扱う土砂量、土砂移動                 |
| の形態、保全対象との位置関係等を考慮して、有害な土砂を合理的かつ効果 |
| 的に処理するように、必要な機能を有する施設を組み合わせて、施設の概略 |
| の位置や概略の規模等を定めることを基本とする。土砂・洪水氾濫対策施設 |
| は土砂の生産抑制及び流送制御のための施設を配置することを基本とする。 |
+----------------------------------------------------------------------+

＜推　奨＞

土砂・洪水氾濫対策施設配置計画にあたっては、対象地域における既往災害に対する再現計算を実施し、当該地域の災害を再現できることを確認した解析手法（流出解析手法、河床変動計算手法等）、計算条件を用いて検討することが望ましい。

＜参考となる資料＞

> 1）内田太郎，小松美緒，坂井佑介：河床変動計算を用いた土砂・洪水氾濫対策に関する砂防施設配置検討の手引き（案），国土技術政策総合研究所資料，第1048号，2018．

2.  []{#_Toc67325266
    .anchor}山腹における土砂生産抑制のための施設（山腹保全工）

＜考え方＞

山腹における土砂生産抑制のための施設（山腹保全工）は、1次生産源である山地を対象として配置するもので、周辺の地形、地質、土壌、気候、植生状況並びに地盤の安定状況等に応じて、土砂生産抑制計画を満たすよう、概略の設置範囲や設置面積を決める必要がある。

山腹保全工による表層崩壊の発生・拡大を軽減する効果は、一般的に構造物においては基礎の範囲、植生においては根系の土壌緊縛力が及ぶ範囲であるといわれており、深層崩壊や地すべりに対する山腹保全工の効果の評価は今後の課題である。

![](media/image7.emf){width="4.25in" height="0.9680555555555556in"}

図3-3　山腹保全工の体系図

＜標　準＞

+----------------------------------------------------------------------+
| 山腹保全工は、治水上砂防の見地                                       |
| から山腹保全のため、崩壊地又はとくしゃ地などにおいて切土・盛土や土木 |
| 構造物により斜面の安定化を図り、また、植生を導入することにより、表面 |
| 侵食や表層崩壊の発生又は拡大の防止又は軽減を図る山腹工と、導入した植 |
| 生の保育などによりそれらの機能の維持・増進を図る山腹保育工からなる。 |
|                                                                      |
| 山腹工は山腹基礎工、山腹緑化工、山腹斜面補強工からなる。             |
+----------------------------------------------------------------------+

1.  山腹工

＜考え方＞

山腹工は山腹基礎工、山腹緑化工、山腹斜面補強工からなる。

1\. 山腹基礎工

山腹基礎工は、切土、盛土や谷止工などの構造物の設置により山腹斜面の安定を図るとともに、水路工などで、表面流による斜面などの侵食を防止することにより、施工対象地に将来、山腹緑化工もしくは山腹斜面補強工を施工するための基礎作りを行うものである。

2\. 山腹緑化工

山腹緑化工は、施工対象地に植生を導入して緑化を図るものである。なお、山腹緑化工には、表土の移動を抑制するとともに植生を導入する柵工、積苗工、筋工などの工法も含まれる。導入植生の選定にあたっては、経年的な変化を考慮して、周辺植生との調和に十分配慮する。

3\. 山腹斜面補強工

山腹斜面補強工は、崩壊地や崩壊のおそれのある山腹において、斜面の安定化を早急に図る必要のある場合や山腹基礎工、山腹緑化工のみでは崩壊の発生・拡大の軽減・防止が困難な場合に、山腹斜面にコンクリートのり枠工や鉄筋挿入工などにより、斜面そのものの崩壊抵抗力を高めるものである。

崩壊地などの急勾配な地形では、表土が頻繁に移動するため自然侵入による植生の復旧が期待できない。そのような場合には、山腹基礎工を主体として斜面を安定させ表土の移動を抑制した後に、山腹緑化工を導入して緑化を図るのが一般的である。また保全対象に隣接するなど斜面の安定化を早急に図る必要がある場合には山腹斜面補強工が導入される。とくしゃ地のように土壌が貧弱ではあるが、比較的緩勾配な地形のところでは、山腹緑化工が主体に計画される。これらの工種は、一つの崩壊地などにおいて複合して用いることが多く、適切に組み合わせて計画される。渓流に隣接し、侵食などによる土砂生産の著しい山腹においては、山腹基礎工として山脚固定を目的とする砂防堰堤を用いるなど、山腹工と砂防堰堤や渓流保全工を組み合わせて計画することがある。

＜標　準＞

+----------------------------------------------------------------------+
| 山腹工は、①「山腹の斜面の安定化や斜面の侵食                          |
| の防止を図る山腹基礎工」、②「崩壊地又はとくしゃ地において表面侵食や  |
| 表層崩壊の発生又は拡大を防止又は軽減するため植生を導入して緑化を図る |
| 山腹緑化工」、③「崩壊地や崩壊のおそれのある山腹の斜面においてコンク  |
| リートのり枠工や鉄筋挿入工などを施工することにより、斜面そのものの崩 |
| 壊抵抗力を高める山腹斜面補強工」に分けられ、これらを単独もしくは適切 |
| に組み合わせて施工することによって、土砂生産の抑制を図るものである。 |
|                                                                      |
| 計画に際しては、計                                                   |
| 画区域及びその周辺の地形、地質、土壌、気候、植生及び他の砂防設備との |
| 関連などを十分に調査し、適切な工種を選定するものとする。特に、導入植 |
| 生の選定にあたっては、周辺植生などとの調和に十分配慮するものとする。 |
+----------------------------------------------------------------------+

2.  山腹保育工

＜考え方＞

山腹保育工は、植生の適正な生育を促す保育などを行うものである。

山腹緑化工により導入された植生は、コンクリート構造物などと異なり、その効果を発揮するまでに時間を要することから山腹工が適正に機能する植生状態になるまでの適切な保育の方針を設定することは重要である。

通常は、山腹緑化工により草木類や先駆性樹種(肥料木)の導入によってまず裸地斜面などを被覆して表土の移動・侵食の防止と森林の成育基盤の形成を図り、その後の山腹保育工等によって防災機能を高めつつ、周囲の植生と調和のとれた植物群落に育てていくことになる。

なお、山腹工施工地などの植生が周辺植生と著しく乖離している場合や、単一樹種となって病虫害に対する抵抗や砂防の効果として山腹緑化工の機能が期待できない場合などには一定の群落ができた段階で必要に応じ山腹工の機能増進を図るために樹種及び林相転換を行う場合がある。

＜標　準＞

+----------------------------------------------------------------------+
| 山                                                                   |
| 腹保育工は、山腹工施工後の山腹の斜面などにおいて、山腹工の機能の維持 |
| ・増進を図るために、植生の適正な生育を促す保育などを行うものである。 |
|                                                                      |
| 計画に際しては、山腹                                                 |
| 工計画時の目標とその実施内容に応じて保育の方針を設定するものとする。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

> 1）国土技術政策総合研究所，危機管理技術研究センター砂防研究室，国土交通省河川局砂防部保全課：これからの山腹保全工の整備に向けて
> --里地里山の山腹斜面に植生を回復させ、その機能を維持・増進していくためのポイント集-，国土技術政策総合研究所資料，第544号，2009.

3.  []{#_Toc67325267 .anchor}渓床・渓岸における土砂生産抑制のための施設

＜考え方＞

渓床・渓岸における土砂生産抑制のための施設は、2次生産源である渓流・河道を対象として配置するもので、地形・地質、渓床の侵食・堆積状況並びに渓岸の侵食・崩壊状況等に応じて、土砂生産抑制計画を満たすよう、施設の概略の位置や規模を決める必要がある。

渓床・渓岸における土砂生産抑制のための施設には、砂防堰堤（生産抑制）、床固工、護岸工、渓流保全工等がある。

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  渓床・渓岸における土砂生産抑制のための施設は、降雨等による渓床・渓岸の侵食等を抑制するため、渓床・渓岸における土砂の生産源において、求められる機能に応じて、概略の位置や概略の規模を定めて配置することを基本とする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

1.  砂防堰堤（生産抑制）

＜考え方＞

渓床・渓岸における土砂生産抑制のための砂防堰堤は、土砂生産抑制の目的に加えて土砂の流出抑制あるいは調節も目的として計画される場合が多い。

山脚固定を目的とする砂防堰堤は、砂防堰堤の設置により上流側に土砂を堆積させ、この堆積土砂によって渓床を上昇させて山脚を固定し、崩壊のおそれのある渓岸または渓流の側方斜面の下部の崩壊の予防および拡大を防止する機能を有する。

縦侵食防止を目的とする砂防堰堤は、砂防堰堤の設置により、渓床の縦侵食を防止する機能を有する。

渓床に堆積した不安定土砂の流出防止を目的とする砂防堰堤は、砂防堰堤の設置により不安定土砂の流出を防止する機能を有する。

また、単独の砂防堰堤にするか、連続する堰堤群にするかは、その地域の土砂生産形態の特性、施工・維持の難易により選定される。なお、渓床・渓岸における土砂生産抑制施設としての砂防堰堤には、その地域の土砂生産形態、地形・地質条件、砂防堰堤に求められる機能等の観点から、透過型砂防堰堤が適さない場合があることに注意が必要である。

＜標　準＞

+----------------------------------------------------------------------+
| 渓床・渓岸における土                                                 |
| 砂生産抑制のための砂防堰堤は、①「山脚固定による渓岸崩壊などの発生又  |
| は拡大の防止又は軽減」、②「渓床の縦侵食の防止又は軽減」あるいは③「渓 |
| 床に堆積した不安定土砂の流出の防止又は軽減」を目的とした施設である。 |
|                                                                      |
| 計画に際しては                                                       |
| 、施設を設置する目的に応じて、概略の規模等を定め計画するものとする。 |
|                                                                      |
| 土砂生産抑                                                           |
| 制施設としての砂防堰堤の概略の位置は、砂防堰堤に期待する効果と、地形 |
| 、地質、不安定土砂の状況を勘案し、①については原則として崩壊などのお  |
| それがある渓岸などの直下流、②については原則として縦侵食域の直下流、③ |
| については原則として不安定な渓床堆積物の直下流に配置するものとする。 |
+----------------------------------------------------------------------+

2.  床固工

＜考え方＞

床固工は、流水の掃流力などによる渓床の低下を防ぐとともに、不安定土砂の移動を防ぎ、土石流などの発生を抑制する機能や渓床勾配の緩和、乱流防止により渓岸の侵食・崩壊を防止・軽減する機能を有する。

渓岸侵食・崩壊の発生箇所もしくは縦侵食の発生が問題となる区間の延長が長い場合には、床固工を複数基配置するなどの検討を行い、渓床、渓岸の安定を図る。単独床固工の下流及び床固工群の間隔が大きく、縦侵食の発生、あるいはそのおそれがある箇所には帯工を配置する。

＜標　準＞

+----------------------------------------------------------------------+
| 床固工は                                                             |
| 、渓床の縦侵食防止、渓床堆積物の再移動防止により渓床を安定させるとと |
| もに、渓岸の侵食又は崩壊などの防止又は軽減を目的とした施設である。な |
| お、床固工は、護岸工などの基礎の洗掘を防止し、保護する機能も有する。 |
|                                                                      |
| 床固工の概略の位置は、次の事項を考慮して計画するものとする。         |
|                                                                      |
| 1\. 渓床低下のおそれのある箇所に計画する。                           |
|                                                                      |
| 2\.                                                                  |
| 工                                                                   |
| 作物の基礎を保護する目的の場合には、これらの工作物の下流に計画する。 |
|                                                                      |
| 3\.                                                                  |
| 渓岸の侵食、                                                         |
| 崩壊及び地すべりなどの箇所においては、原則としてその下流に計画する。 |
+----------------------------------------------------------------------+

3.  護岸工

＜考え方＞

護岸工は、渓岸の侵食・崩壊などの防止を目的とした施設である。

護岸工を設置することにより水際線の環境を単調なものとしてしまう可能性があるので、その設置範囲は必要最低限とし、渓流内の自然度が高くなるように配慮するのが望ましい。

＜標　準＞

+----------------------------------------------------------------------+
| 護岸工は、渓岸の侵食・崩壊などの防止を目的とした施設である。         |
|                                                                      |
| 護岸工は、土砂の移動もしくは流水                                     |
| により、水衝部などの渓岸の侵食又は崩壊が発生、あるいはそのおそれがあ |
| る箇所や山脚の固定あるいは侵食防止が必要な箇所に計画するものとする。 |
+----------------------------------------------------------------------+

4.  渓流保全工

＜考え方＞

渓流保全工は、渓岸の侵食・崩壊などを防止するとともに、縦断勾配の規制により渓床・渓岸侵食などを防止することを目的とした施設である。

渓流保全工を計画するにあたっては、自然の地形を活かしつつ必要な箇所のみに砂防設備を適切に配置するよう計画する必要がある。

＜標　準＞

+----------------------------------------------------------------------+
| 渓流保全工は、山間部の平地や扇状地を流下する渓流などにおいて、乱流   |
| ・偏流を制御することにより、渓岸の侵食・崩壊などを防止するとともに、 |
| 縦断勾配の規制により渓床・渓岸侵食などを防止することを目的とした施設 |
| である。渓流保全工は、床固工、帯工と護岸工などの組み合わせからなる。 |
|                                                                      |
| 渓流保全工は、多様な渓流空間、生態系の保全及び自然の土砂調節機       |
| 能の活用の観点から、拡幅部や狭さく部などの自然の地形などを活かし、必 |
| 要に応じて床固工、帯工、護岸工などを配置するよう計画するものとする。 |
+----------------------------------------------------------------------+

＜推　奨＞

洪水や土砂の一時的な滞留の場として防災的に機能する空間とし、かつ日常的には生態系の保全に寄与するよう、保全対象等が隣接していない区間においては、なるべく流路を固定するのではなく、河床変動や渓床の攪乱をある程度許容することが望ましい。

＜参考となる資料＞

> 1)　国土技術政策総合研究所，危機管理技術研究センター砂防研究室：渓流空間の多様性を保全する渓流保全工整備の手引き-2010年版-，国土技術政策総合研究所資料，第580号，2010.

4.  []{#_Toc67325268 .anchor}土砂の流出抑制あるいは調節のための施設

＜考え方＞

土砂の流出抑制あるいは調節のための施設は、河道を対象として配置するもので、土砂の流出形態、土砂量及び粒径、地形、渓床勾配、河道の状況等に応じて、土砂流送制御計画を満たすよう、施設の概略の位置や概略の規模を決める必要がある。

土砂の流出抑制あるいは調節のための施設の配置計画の検討にあたっては、施設の効果評価を河床変動計算等により行うことを基本とする。砂防堰堤における堆砂勾配は、砂防堰堤の堆砂域に流入する土砂濃度やハイドログラフの影響を受ける。このため、堆砂域に流入する土砂濃度やハイドログラフの影響の評価が可能な河床変動計算等により施設の土砂流送制御効果を評価する。河床変動計算による施設の土砂流送制御効果の評価が難しい場合には、水理模型実験により施設の概略の位置や概略の規模、施設の型式を検討する。

土砂の流出抑制あるいは調節のための施設には、砂防堰堤（流送制御）、渓流保全工、遊砂地工、床固工等がある。

施設の概略位置の検討にあたっては、現況の地形条件よる堆積量が施設効果による堆積量を上回る区間等の施設効果が小さくなる箇所は避け、対象領域内の施設効果の大きい箇所を抽出し、谷出口等、保全対象に近い位置での堆積容量の大きい基幹的な砂防堰堤の整備、そのような位置にある既存の砂防堰堤を改築または機能向上等、施設効果の大きい箇所から優先的に施設配置を検討するなど効果的な施設配置を行う。また、流域内の既存の砂防堰堤等の施設の土砂流送制御効果を再評価し配置計画に取り入れる。加えて、より大きな施設効果が見込める施設の改築または機能向上等については配置計画に取り入れるものとする。

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  土砂の流出抑制あるいは調節のための施設は、有害な土砂の流出を制御するため、土砂の流送区間において、求められる機能に応じて、概略の位置や概略の規模を定めて配置することを基本とする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜例　示＞

対象となる保全対象周辺の河床変動への寄与が大きい支川・本川上の区間に施設を設置することが有効である。河床変動計算により対象とする保全対象周辺の河床変動への寄与の大小が評価できる。

＜参考となる資料＞

> 1）内田太郎，小松美緒，坂井佑介：河床変動計算を用いた土砂・洪水氾濫対策に関する砂防施設配置検討の手引き（案），国土技術政策総合研究所資料，第1048号，2018．

1.  砂防堰堤（流送制御）

＜考え方＞

土砂の流出抑制あるいは調節のための砂防堰堤は、その目的に加えて土砂生産抑制も目的として計画される場合が多い。

流出土砂の抑制を目的とする砂防堰堤は、堆積容量に流出土砂を貯留させることで、土砂の流出抑制機能を発揮する。この機能は土砂の堆積によって失われるので、計画上これを見込む場合は除石などにより機能の回復を行う必要がある。

砂防堰堤の堆砂域では、砂防堰堤がないときの渓床と比較して、特に渓床勾配が緩く、渓床幅が広い場合において、多量の土砂の流入があると、流入土砂の一部が堆積することがある。不透過型砂防堰堤にはこのように流出土砂を洪水中に抑制・調節する機能もある。また、土砂調節を目的とする透過型砂防堰堤は、流水にせき上げ背水を生じさせて流出土砂量及びそのピーク流出土砂量の調節を行うものである。ただし、洪水の後半に堆積した土砂が下流に流出する場合があることに留意する必要がある。なお、透過型砂防堰堤は透過部断面により渓流の連続性を確保することができる。

また、単独の砂防堰堤にするか、連続する堰堤群にするかは、その地域の土砂流送形態の特性、施工、維持の難易により選定される。

また、土石流の捕捉のための砂防堰堤については、第3-2章2.3.2を参照すること。

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  土砂の流出抑制あるいは調節のための砂防堰堤は、①「土砂の流出抑制あるいは調節」、②「土石流の捕捉」を目的とした施設であり、その型式には、不透過型及び透過型がある。計画に際しては、施設に求められる機能に応じて、概略の規模や施設の型式などを定めるものとする。土砂流送制御施設としての砂防堰堤の設置位置は、砂防堰堤に期待する効果と地形、維持管理・施工性などを考慮し、狭窄部でその上流の谷幅が広がっているところや支川合流点直下流部などの効果的な場所に設置するものとする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

2.  渓流保全工

第3－2章2.2.3(4)を参照

3.  遊砂地工

＜考え方＞

遊砂地工は、流送土砂の制御を行う施設である。

流木が遊砂地工から流出するおそれがある場合は、下流端の床固工を流木捕捉機能を備えた構造とするなど流木対策施設の配置を検討するものとする。

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  遊砂地工は、掘削などにより渓流の一部を拡大して土砂を堆積させる空間を確保し、土砂を堆積させることで、流送土砂の制御を行う施設である。遊砂地工は、一般に谷の出口より下流側において土砂を堆積させる空間を確保できる区域に設置するものとする。また、遊砂地工は、上流に砂防堰堤、下流端に床固工などを配置するほか、低水路、導流堤、砂防樹林帯などを適切に組み合わせて計画するものとする。護岸工は、渓岸の侵食・崩壊などの防止を目的とした施設である。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

4.  床固工

第3－2章2.2.3(2)を参照

3.  []{#_Toc67325269 .anchor}土石流・流木対策施設配置計画

    1.  []{#_Toc67325270 .anchor}総説

＜考え方＞

土石流・流木対策施設配置計画においては、土石流・流木処理計画を満たすために、土石流・流木の捕捉、堆積、制御、発生抑制等の機能を有する施設を適切に選定し、施設の概略の位置や砂防堰堤高等の概略の規模を定める。また、土石流・流木対策施設には主に土石流・流木の流送制御のために、土石流・流木の捕捉のための施設を設置するが、流域内が荒廃しているときなどは、土石流・流木の発生抑制のための施設も適切に配置する必要がある。

土石流・流木施設配置計画上求められる機能毎の土石流・流木対策施設の種類を以下に示す。

表3-2　土石流・流木対策施設の種類

+----------------+----------------+----------------+----------------+
|                | 対策施設に     | 主な工種       |                |
|                | 求められる機能 |                |                |
+================+================+================+================+
| 土石流・       | 生産抑制       | 土石流・       | 山             |
| 流木　対策施設 |                | 流木の発生抑制 | 腹工、砂防堰堤 |
|                | ※流域が荒      |                | 、床固工、護岸 |
|                | 廃している場合 |                | 工、渓流保全工 |
+----------------+----------------+----------------+----------------+
|                | 流送制御       | 土石           | 砂防堰堤       |
|                |                | 流・流木の捕捉 |                |
+----------------+----------------+----------------+----------------+
|                |                | 土石           | 土石流堆積工   |
|                |                | 流・流木の堆積 |                |
+----------------+----------------+----------------+----------------+
|                |                | 土石           | 土石流         |
|                |                | 流・流木の制御 | 導流工、土石流 |
|                |                |                | 緩衝樹林帯、土 |
|                |                |                | 石流流向制御工 |
+----------------+----------------+----------------+----------------+

＜標　準＞

+----------------------------------------------------------------------+
| 土石流・流木対策施設配置計画は、土石流・流木                         |
| 処理計画で設定した計画捕捉量、計画堆積量、計画発生(流出)抑制量を満た |
| すよう、土石流・流木対策施設の配置について計画することを基本とする。 |
|                                                                      |
| 土石流・流木対策施                                                   |
| 設は、計画で扱う土砂・流木量等、土砂移動の形態、保全対象との位置関係 |
| 等を考慮して、土石流及び土砂とともに流出する流木等を合理的かつ効果的 |
| に処理するように、必要な機能を有する施設を組み合わせて、施設の概略の |
| 位置や概略の規模、施設の型式等を定めることを基本とする。土石流・流木 |
| 対策施設は土石流・流木の捕捉のための施設を配置することを基本とする。 |
+----------------------------------------------------------------------+

＜推　奨＞

土石流危険渓流であっても明瞭な谷地形を呈さない地形や常時流水の無いような小規模渓流では、渓流及びその周辺の状況や砂防設備を設置する際の施工条件等を考慮した上で、渓流の実態に則した施設の位置や規模、型式等を定めることに努める。

＜参考となる資料＞

> 1）国土技術政策総合研究所土砂災害研究部砂防研究室：砂防基本計画策定指針（土石流・流木対策編）解説,国土技術政策総合研究所資料,第904号,2016.\
> （最新版）国土技術政策総合研究所土砂災害研究部砂防研究室：砂防基本計画策定指針（土石流・流木対策編）解説，平成28年4月（令和7年3月一部改定）

2.  []{#_Toc67325271 .anchor}土石流・流木の捕捉のための施設

＜考え方＞

土石流・流木の捕捉のための施設を計画・配置するにあたっては、想定される土砂および流木の流出現象として、土石流中の土石の粒径、土石流の濃度、流木の大きさ(長さ、太さ)、流木の多寡などを想定し、形状、型式を決める必要がある。また、平常時堆砂勾配が現渓床勾配と大きく変化する場合や堆砂延長が長くなる場合は、堆砂敷において土石流の流下形態が変化することに注意する必要がある。

土石流・流木の捕捉のための施設として、主として透過型砂防堰堤を用いるが、分離堰堤(水抜きスクリーン)等も土石流・流木捕捉工として考え、砂防堰堤以外の土石流・流木の捕捉のための施設に本基準を準用することを妨げない。

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  土石流・流木の捕捉のための施設は、土石流の流下・堆積区間において、土石流および土砂とともに流出する流木等を捕捉するため、想定される土砂および流木の流出現象や地形等に応じて、概略の位置や概略の形状、施設の型式を定めて配置することを基本とする。土石流・流木の捕捉のための施設として、透過型砂防堰堤を用いることを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

1.  砂防堰堤の型式の選定

＜考え方＞

土石流の流下区間および堆積区間に配置する砂防堰堤には、主として以下の機能が求められる。

・土石流の捕捉

・土砂とともに流出する流木等の捕捉

・計画捕捉量・計画堆積量に相当する空間の維持

・平時の渓流環境(渓床の連続性)の保全

土砂とともに流出する流木等を全て捕捉するためには、透過構造を有する施設(透過型砂防堰堤、部分透過型砂防堰堤、流木捕捉工など)が必要となる。そのため、計画流下許容流木量が0でない場合や流木対策を別途計画する場合などを除き、流木の捕捉のための砂防堰堤は、透過型または部分透過型砂防堰堤とすることを原則とする。

なお、土石流区間において流木捕捉工の設置が必要な場合は、副堰堤等に流木捕捉工を設置することができる。

また、型式によらず計画捕捉量の確保のためには除石(流木の除去を含む)計画の検討が必要となる。計画堆積量を計画する不透過型及び部分透過型砂防堰堤では、計画堆積量確保のための除石(流木の除去を含む)計画の検討が必要となる。

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  砂防堰堤を配置する際には、対象とする流域の特性や想定される土石及び流木の流出現象を現地調査により十分把握した上で、経済性、地域環境等に配慮し、施設の型式を選定することを基本とする。なお、土砂とともに流出する流木等を全て捕捉するためには、透過構造を有する施設を原則とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

既設の不透過型砂防堰堤において、土砂とともに流出する流木等をすべて捕捉するためには、既存砂防堰堤は切り欠くか、または嵩上げする、副堰堤等に設置した流木捕捉工などにより流木捕捉効果を高める等がある。しかし、地形上困難な場合や副堰堤等に設置した流木捕捉工では必要な計画捕捉流木量を確保できない場合がある。このような場合は、既設の不透過型砂防堰堤の水通し部や水通し部の上流側の離した位置に流木を捕捉するための付属施設を設置して、流木捕捉効果を高めることが望ましい。

＜関連通知等＞

> 1）流木対策における既設砂防堰堤の有効活用に関する具体的な手法について,平成29年10月20日,
> 国土交通省水管理・国土保全局砂防部 砂防計画課砂防計画調整官
> 保全課土砂災害対策室長 事務連絡.

＜参考となる資料＞

> 1）一般財団法人砂防・地すべり技術センター：張り出しタイプ流木捕捉工設計の手引き,2020.\
> （最新版）一般財団法人砂防・地すべり技術センター：張り出しタイプ流木捕捉工設計の手引き,2025.

2.  透過型・部分透過型の種類と配置

＜考え方＞

透過型及び部分透過型砂防堰堤は、土石流に含まれる巨礫等によって透過部断面が閉塞することにより、土石流を捕捉する。また、透過部断面が確実に閉塞した場合、捕捉した土砂が下流に流出する危険性はほぼ無いため、土石流捕捉のための透過型及び部分透過型砂防堰堤を土石流区間に配置する。なお、流水にせき上げ背水を生じさせて流砂を一時的に堆積させる目的の透過型及び部分透過型砂防堰堤は、洪水の後半に堆積した土砂が下流に流出する危険性があるため、土石流区間には配置しない。

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  土石流・流木捕捉のための施設として用いる透過型及び部分透過型砂防堰堤は、計画規模の土石流を捕捉するため、その土石流に含まれる巨礫等によって透過部断面を確実に閉塞させるよう計画することを基本とする。透過型及び部分透過型砂防堰堤を配置する際においては、土砂移動の形態を考慮する。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

3.  土石流捕捉のための砂防堰堤の配置上の留意事項

＜考え方＞

堆積区間に透過型または部分透過型を配置するときは、透過部断面全体を礫・流木により閉塞させるように、土石流の流下形態等を考慮して施設配置計画を策定する必要がある。また、複数基の透過型を配置する場合には、上流側の透過型により土砂移動の形態が変化することに留意する。

また、透過型は中小の出水で堆砂することなく、計画捕捉量を維持することが期待できる型式である。ただし、透過型と部分透過型は、不透過型同様、土石流の捕捉後には除石等の維持管理が必要となることに留意する。

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  透過型と部分透過型は、土石流の捕捉に対して「計画規模の土石流」及び土砂とともに流出する流木によって透過部断面が確実に閉塞するとともに、その巨礫等による閉塞状態が土石流の流下中に破壊されず、かつ中小規模の降雨時の流量により運搬される掃流砂により透過部断面が閉塞しないことを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

砂防堰堤等の施設を計画するにあたっては、本川のみならず、支川等から流入する土石流等の外力の可能性についても考慮することが望ましい。特に、土石流・流木の捕捉機能を有する施設については、急勾配で外力の条件が厳しい箇所への配置を避け、できるだけ流下区間・堆積区間に配置するよう努める。

特に外力条件が厳しい現場では、計画地点の状況や流域特性を十分調査して礫径を適切に設定することが望ましい。その際、近隣の渓流において土砂流出の実績がある場合には、その時の流出した巨礫の礫径も参考とする。また、極めて大きい礫が流出する可能性があると判断される場合、その礫が衝突しても、砂防堰堤全体として捕捉機能が失われることとならない構造の設計に配慮するよう努める。また、土砂処理上の合理性に加え経済性、地域環境、施工性、現象の不確実性を踏まえた施設の安全性に配慮し施設を配置するよう努める。

＜関連通知等＞

> 1）鋼製透過型砂防堰堤の留意事項について,平成26年11月6日,
> 国土交通省水管理・国土保全局砂防部 保全課土砂災害対策室長 事務連絡.

　2）砂防堰堤等の計画・設計における留意事項について,平成31年2月7日,
国土交通省水管理・国土保全局砂防部 砂防計画課砂防計画調整官
保全課土砂災害対策室長 事務連絡.

＜参考となる資料＞

> 1）国土技術政策総合研究所土砂災害研究部砂防研究室：砂防基本計画策定指針（土石流・流木対策編）解説,国土技術政策総合研究所資料,第904号,2016.\
> （最新版）国土技術政策総合研究所土砂災害研究部砂防研究室：砂防基本計画策定指針（土石流・流木対策編）解説，平成28年4月（令和7年3月一部改定）

3.  []{#_Toc67325272 .anchor}土石流・流木の堆積のための施設

＜考え方＞

土石流・流木の堆積のための施設は、土石流の堆積区間において、安全に土石流を堆積させるためのもので、土石流堆積工と総称され、その種類は、土石流分散堆積地と土石流堆積流路がある。

土石流分散堆積地は、流路を拡幅した土地の区域(拡幅部)のことで、拡幅部の上流端と下流端に砂防堰堤または床固工を配置したものであり、土石流・流木処理計画上必要となる計画堆積量を堆積させることのできる空間を流路の拡幅及び掘り込んで渓床勾配を緩くすることにより確保することを標準とする。

土石流堆積流路は、背後地盤において宅地が発達している等の土地利用状況や谷底平野等の地形条件により、土石流分散堆積地のように流路の拡幅が困難な場合において、流路を掘り込んで渓床勾配を緩くすることにより、土石流・流木処理計画上必要となる計画堆積量を堆積させることのできる空間を確保することを標準とする。

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  土石流・流木の堆積のための施設は、土石流の堆積区間において、土石流を減勢し、土石流および土砂とともに流出する流木等を堆積させるため、地形、保全対象との位置関係等に応じて、概略の位置や概略の規模を定めて土石流堆積工を配置することを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜参考となる資料＞

> 1）国土技術政策総合研究所土砂災害研究部砂防研究室：砂防基本計画策定指針（土石流・流木対策編）解説,国土技術政策総合研究所資料,第904号,2016.\
> （最新版）国土技術政策総合研究所土砂災害研究部砂防研究室：砂防基本計画策定指針（土石流・流木対策編）解説，平成28年4月（令和7年3月一部改定）

4.  []{#_Toc67325273 .anchor}土石流・流木の制御のための施設

＜考え方＞

土石流・流木の制御のための施設は、原則として土石流・流木の捕捉のための施設を配置した上で、加えて土石流・流木を制御して、土石流・流木を堆積させたり、下流に安全に流下させるために配置するものである。

土石流・流木の制御のための施設には、土石流の堆積区間において、土石流が施設内に堆積して氾濫等が発生しないように安全に導流するための土石流導流工、土石流の流速を低減させて堆積させるための土石流緩衝樹林帯、そして、土石流の流向を制御するための土石流流向制御工がある。

土石流導流工は、流出土砂の粒径などを十分検討し、施設内で堆積が生じて、越流、氾濫しないように、その断面を通過する土石流ピーク流量に対応する断面とする必要がある。

土石流緩衝樹林帯は、床固工、土石流導流堤等の土石流・流木対策施設と樹林、小規模な出水を処理する常水路、補助施設などを組み合わせて配置するものであり、土石流の堆積区間の末端部付近に配置する。土石流緩衝樹林帯は原則として扇状地上において土石流と保全対象物の間に緩衝区間として、土石流流向制御工等を組み合わせて設ける。

土石流流向制御工は、計画基準点よりも下流で土砂を流しても安全な場所があり、下流に災害等の問題を生じさせずに安全な場所まで土砂を流下させることができる場合に設置する。

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  土石流・流木の制御のための施設は、土石流の流下・堆積区間において、土石流・流木を安全に導流、堆積させる等制御するため、流出土砂の粒径、土石流ピーク流量や地形、保全対象との位置関係等に応じて、概略の位置や概略の形状を定めて配置することを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜参考となる資料＞

> 1）国土技術政策総合研究所土砂災害研究部砂防研究室：砂防基本計画策定指針（土石流・流木対策編）解説,国土技術政策総合研究所資料,第904号,2016.\
> （最新版）国土技術政策総合研究所土砂災害研究部砂防研究室：砂防基本計画策定指針（土石流・流木対策編）解説，平成28年4月（令和7年3月一部改定）

5.  []{#_Toc67325274 .anchor}土石流・流木の発生抑制のための施設

＜考え方＞

流域内が荒廃しているときなどは、土石流・流木の発生抑制のための施設を配置する。

土石流・流木の発生抑制のための施設は、植生または他の土木構造物によって山腹斜面の安定化を図るための山腹保全工と、渓床堆積土砂の移動および渓岸の崩壊を防止するための砂防堰堤、床固工、護岸工、渓流保全工等からなる。

個々の施設の種類の説明は、第3-2章2.2.2および第3-2章2.2.3
(1)～(4)を参照のこと。

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  土石流・流木の発生抑制のための施設は、流域内が荒廃している場合に、土石流の発生・流下区間において、土石流および土砂とともに流出する流木等の発生を抑制するため、山腹または渓床・渓岸等の土砂の発生源に、求められる機能に応じて概略の規模を定めて配置することを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜参考となる資料＞

> 1）国土技術政策総合研究所土砂災害研究部砂防研究室：砂防基本計画策定指針（土石流・流木対策編）解説,国土技術政策総合研究所資料,第904号,2016.\
> （最新版）国土技術政策総合研究所土砂災害研究部砂防研究室：砂防基本計画策定指針（土石流・流木対策編）解説，平成28年4月（令和7年3月一部改定）

4.  []{#_Toc67325275
    > .anchor}土砂・洪水氾濫時に流出する流木の対策施設配置計画

    1.  []{#_Toc67325276 .anchor}総説

＜考え方＞

土砂・洪水氾濫時に流出する流木の対策施設配置計画においては、流木処理計画を満たすために、流木の生産抑制や捕捉等の機能を有する施設を適切に選定し、施設の概略の位置や概略の規模を定める。土砂・洪水氾濫時に流出する流木の対策施設には、流木の生産抑制を主な目的とする施設と流木の捕捉を主な目的とする施設があり、流木の生産域や流木により被害が生じるおそれのある地域の分布等を踏まえ、適切に配置する必要がある。

土砂・洪水氾濫時に流出する流木の対策施設配置計画は、現地調査、資料調査に基づき、対象地域において生じる可能性のある流木災害の軽減を図る目的で検討する。

土砂・洪水氾濫時に流出する流木の対策施設配置計画上求められる機能毎の流木対策施設の例を以下に示す。

表3-3　土砂・洪水氾濫時に流出する流木の対策施設の種類

+----------------+----------------+----------------+----------------+
|                | 対策施設に     | 主な工種       |                |
|                | 求められる機能 |                |                |
+================+================+================+================+
| 土砂・         | 流木の生産抑制 | 山腹に         | 山腹工         |
| 洪水濫時に流出 |                | おける流木生産 |                |
| する流木の対策 |                |                |                |
|                |                | 抑制           |                |
| 施設           |                |                |                |
+----------------+----------------+----------------+----------------+
|                |                | 渓床           | 砂防堰         |
|                |                | ・渓岸における | 堤（不透過型） |
|                |                |                | 、床固工、護岸 |
|                |                | 流木生産抑制   | 工、渓流保全工 |
+----------------+----------------+----------------+----------------+
|                | 流木の捕捉     | 山腹にお       | 流木止工       |
|                |                | ける流木の捕捉 |                |
+----------------+----------------+----------------+----------------+
|                |                | 渓流           | 砂防堰堤（透過 |
|                |                | ・河川における | 型）、流木止工 |
|                |                |                |                |
|                |                | 流木の捕捉     |                |
+----------------+----------------+----------------+----------------+

渓流における流木の移動形態は、土石流区間では流木は土砂と一体となって流下し、掃流区間では流木は土砂と分離して流水の表面を流下すると考えられるため、土砂・洪水氾濫時に流出する流木の対策施設配置計画を検討する際には、計画地点における流木の移動形態に留意する必要がある。

＜標　準＞

+----------------------------------------------------------------------+
| 土砂・洪水氾濫時に流出する流木の対策施設配置計                       |
| 画は、土砂・洪水氾濫時に流出する流木の対策計画で定めた流木処理計画を |
| 満たすよう、土砂・洪水氾濫対策施設配置計画及び土石流・流木対策施設配 |
| 置計画と整合を図りつつ、土砂・洪水氾濫時に流出する流木の生産抑制機能 |
| 及び捕捉機能を有する対策施設の配置について計画することを基本とする。 |
|                                                                      |
| 土砂・洪水氾濫時に流出する流木の対策施設は、計画で扱う流             |
| 木量、流木の発生箇所や移動形態、保全対象との位置関係等を考慮して、土 |
| 砂とともに流出する流木を合理的かつ効果的に処理するように、必要な機能 |
| を有する施設を組み合わせて、施設の概略の位置や概略の規模、施設の型式 |
| 等を定めることを基本とする。土砂・洪水氾濫時に流出する流木の対策施設 |
| は流木の生産抑制及び流木捕捉のための施設を配置することを基本とする。 |
+----------------------------------------------------------------------+

2.  []{#_Toc67325277 .anchor}流木生産抑制のための施設

＜考え方＞

土砂生産抑制の機能を有する施設は、流木生産抑制の機能も有する。このため、流木生産抑制のための施設の配置計画は、第3-2章2.2.2「山腹における土砂生産抑制のための施設」及び第3-2章2.2.3「渓床・渓岸における土砂生産抑制のための施設」を参照して定める。

＜標　準＞

+----------------------------------------------------------------------+
| 流木生産抑制のための施設の配置計画                                   |
| は、土砂・洪水氾濫対策計画施設配置計画における山腹及び渓床・渓岸にお |
| ける土砂生産抑制のための施設の配置計画と共に定めることを基本とする。 |
|                                                                      |
| 流木生産抑制のための施設の配置計画においては、流木として流出         |
| する可能性のある樹木の状況（樹種や植生分布等）を考慮する必要がある。 |
+----------------------------------------------------------------------+

3.  []{#_Toc67325278 .anchor}流木捕捉のための施設

＜考え方＞

流木捕捉のための施設は、渓流に流入する流木や渓流を流下する流木を捕捉するもので、流木の移動形態や渓流の狭窄部、湾曲部等の地形的条件、渓流を流下する流木により閉塞するおそれがある橋梁やボックスカルバート等の横断工作物の位置、及び被害の生じるおそれのある地域における保全対象の立地状況等を考慮し、施設の概略の位置や概略の規模、施設の型式等を定める必要がある。

流木捕捉のための施設には、山腹等に堆積した倒木が渓流に流入するのを防止するために山腹に設ける流木止工や、土砂及び流木の流下する渓流に設置される砂防堰堤（透過型や部分透過型）や流木止工、不透過型砂防堰堤の副堰堤や遊砂地工下流端の床固工に設置される流木止工、既設の不透過型砂防堰堤の水通し部の上流側に設置するタイプの流木止工等がある。

流木捕捉のための施設は、土砂及び流木の流下する渓流に設置される砂防堰堤（透過型や部分透過型）や不透過型砂防堰堤の副堰堤に設置される流木止工など、流木捕捉機能を付加した土砂・洪水氾濫対策施設や、土石流・流木対策施設であることを基本とする。流木捕捉機能を付加した土砂・洪水氾濫対策施設や土石流・流木対策施設の配置では流木処理計画で定めた流出流木量を捕捉することができない場合に、渓流に設置する流木止工等、流木の捕捉機能のみを有する施設を配置する。

土砂・洪水氾濫対策施設に流木捕捉機能を付加する場合、施設の配置に係る考え方や工法等については、第3-2章2.2.4「土砂の流出抑制あるいは調節のための施設」を参照すること。また、土石流と共に流下する流木を捕捉するための施設については、第3-2章2.3.2「土石流・流木の捕捉のための施設」を参照すること。勾配の急な土石流区間に設置した流木捕捉のための施設は、流出する土砂と流木を一体で捕捉すると考えられる。一方、勾配の比較的緩やかな掃流区間に設置した流木捕捉のための施設は、流木と土砂とを分離して捕捉すると考えられる。こうした想定される捕捉形態の違いに応じ、施設に期待する効果量の算定方法が異なるため、流木捕捉のための施設の配置計画に際しては、施設を配置する位置で想定される流木の捕捉形態に留意する必要がある。

流木捕捉のための施設が流木を捕捉した後は、速やかな流木撤去が必要であるため、流木捕捉のための施設の配置に際しては管理用通路の整備など、維持管理作業の容易性を確保する必要がある。

＜標　準＞

+----------------------------------------------------------------------+
| 流木捕捉のための施設の配置計画は、倒木が堆積した山腹や               |
| 、土砂及び流木が流下する渓流において、想定される流木の移動形態や地形 |
| 的条件、横断工作物の位置、保全対象の状況、維持管理作業の容易性等を考 |
| 慮して、概略の位置や概略の形状、施設の型式を定めることを基本とする。 |
|                                                                      |
| 流木捕捉のための施設は、流木捕捉機能を付加した土                     |
| 砂・洪水氾濫対策施設や、土石流・流木対策施設であることを基本とする。 |
| ただし、流木捕捉機能を付加した土砂・洪水氾濫対策施設や土石流・流木対 |
| 策施設の配置では流木処理計画で定めた流出流木量を捕捉することができな |
| い場合に、流木の捕捉機能のみを有する流木止工を配置する。流木捕捉機能 |
| のみを有する流木止工は、透過構造を有する施設とすることを基本とする。 |
|                                                                      |
| 流木捕捉のための施設の配置計画においては、土石流区間と掃流区間       |
| とで、施設による流木の捕捉形態に違いがあることに留意する必要がある。 |
+----------------------------------------------------------------------+

2.  []{#_Toc67325279
    > .anchor}中期（土砂流出活発期）土砂流出対策施設配置計画

    1.  []{#_Toc67325280 .anchor}総説

＜考え方＞

中期は、短期の降雨により生産された土砂がその後の降雨により特に活発に移動する期間（流出土砂が定常状態に落ちつくまでの数年間）を目安に設定する。中期において対象とする土砂流出のイメージは図3-2に示すとおりである。

中期土砂流出対策施設配置計画においては、土砂処理計画を満たすために、短期土砂流出対策を対象として設置された、土砂流送制御を主な目的とする施設の活用をまず検討することを基本とする。その上で、既設の砂防設備を活用することによっても計画規模の土砂量を捕捉することが困難な場合や、経済性等の観点から設置することが妥当と判断される場合は、新たな施設の概略位置や概略の規模、施設の型式等について検討する。なお、事前対策は、大規模土砂生産直後に新たな施設の設置等に十分な猶予期間がない場合に、緊急的な対策を実施するための有効な対策を準備する目的で行うことを基本とする。また、検討する新たな施設は、火山砂防や深層崩壊・天然ダム等異常土砂災害対策としても効果が発揮できるようにすることが望ましい。

さらに、土砂流出活発期間中における砂防設備による流出土砂の捕捉・堆積容量確保のための除石計画、除石した土砂の運搬路及び土砂の仮置き場を事前に準備しておくことを基本とする。

中期土砂流出対策施設配置計画の検討は、現地調査、資料調査による施工の実行性の検討等とともに、施設の効果評価を河床変動計算等により行うことを基本とする。検討した施設配置計画では十分な効果が得られないと判断された場合、施設配置計画を見直して、再度、河床変動計算等により効果評価を行う。

中期土砂流出対策施設配置計画は、短期土砂・流木流出対策施設配置計画、火山砂防施設配置計画、深層崩壊・天然ダム等異常土砂災害対策施設配置計画と整合するように定める。

中期土砂流出対策施設に求められる機能毎の中期土砂流出対策施設の種類を以下に示す。

表3-4　中期（土砂流出活発期）土砂流出対策施設の種類

                                           対策施設に求められる機能   主な工種                     
  ---------------------------------------- -------------------------- ---------------------------- ----------------------------------------
  中期（土砂流出活発期）土砂流出対策施設   流送制御                   土砂の流出抑制あるいは調節   砂防堰堤、渓流保全工、遊砂地工、床固工

中期土砂流出対策施設には、除石可能な砂防堰堤、シャッター砂防堰堤、遊砂地工等が考えられる。

![](media/image8.png){width="2.6069444444444443in"
height="1.9534722222222223in"}![](media/image9.png){width="2.6805555555555554in"
height="2.040277777777778in"}

図3-4　中期（土砂流出活発期）における土砂の流出抑制あるいは調節のための施設の

整備事例（シャッター砂防堰堤）

＜標　準＞

+----------------------------------------------------------------------+
| 中期土砂流出対策施設配置計画は、中                                   |
| 期土砂流出対策計画の計画流出土砂量を処理できるよう、中期土砂流出対策 |
| 施設の配置について、河床変動計算等に基づき計画することを基本とする。 |
|                                                                      |
| 中期土砂流出対策施設は、計画で扱う土砂量、土砂移                     |
| 動の形態、保全対象との位置関係等を考慮して、有害な土砂を合理的かつ効 |
| 果的に処理するように、必要な機能を有する施設を組み合わせて、施設の概 |
| 略の位置、概略の規模、施設の型式等を定めることを基本とする。中期土砂 |
| 流出対策施設は土砂の流送制御のための施設を配置することを基本とし、ま |
| ずは短期土砂流出対策などを対象として既に設置された施設の活用を検討す |
| る。また、土砂流出活発期間中における砂防設備による流出土砂の捕捉・堆 |
| 積容量確保のための除石および除石した土砂の処理方法について検討する。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

> 1）泉山寛明，山越隆雄，西井洋史，内田太郎：大規模土砂生産後に生じる活発な土砂流出に関する対策の基本的考え方（案），国土技術政策総合研究所資料，第1115号，2020．

3.  []{#_Toc67325281
    > .anchor}長期（土砂流出継続期）土砂流出対策施設配置計画

    1.  []{#_Toc67325282 .anchor}総説

＜考え方＞

長期は、流出土砂量が短期土砂・流木流出を引き起こした降雨イベントの前に比べて定常的に流出土砂量が活発な状態が継続する期間（十年以上の期間）とする。長期において対象とする土砂流出のイメージは図3-2に示すとおりである。

長期土砂流出対策施設配置計画においては、土砂処理計画を満たすために、土砂生産抑制のための施設を設置することを基本とする。また、土砂生産抑制の効果が現れるまでは既往の流送制御のための砂防設備を活用することも有効であると考えられる。

長期土砂流出対策施設に求められる機能毎の長期土砂流出対策施設の種類を以下に示す。

表3-5　長期（土砂流出継続期）土砂流出対策施設の種類

+----------------+----------------+----------------+----------------+
|                | 対策施設に     | 主な工種       |                |
|                | 求められる機能 |                |                |
+================+================+================+================+
| 長期（土砂     | 生産抑制       | 山腹におけ     | 山腹工         |
| 流出継続期）土 |                | る土砂生産抑制 |                |
| 砂流出対策施設 |                |                |                |
+----------------+----------------+----------------+----------------+
|                |                | 渓             | 砂防堰堤       |
|                |                | 床・渓岸におけ | 、床固工、護岸 |
|                |                | る土砂生産抑制 | 工、渓流保全工 |
+----------------+----------------+----------------+----------------+
|                | 流送制御       | 土砂の流出抑   | 砂防堰堤、     |
|                |                | 制あるいは調節 | 渓流保全工、遊 |
|                | ※土砂          |                | 砂地工、床固工 |
|                | 生産抑制の効果 |                |                |
|                | が発現するまで |                |                |
+----------------+----------------+----------------+----------------+

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------
  長期土砂流出対策施設配置計画は、長期土砂流出対策計画の計画流出土砂量を処理できるよう、長期土砂流出対策施設の配置について計画することを基本とする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------

＜参考となる資料＞

> 1）泉山寛明，山越隆雄，西井洋史，内田太郎：大規模土砂生産後に生じる活発な土砂流出に関する対策の基本的考え方（案），国土技術政策総合研究所資料，第1115号，2020．

4.  []{#_Toc67325283 .anchor}火山砂防施設配置計画

    1.  []{#_Toc67325284 .anchor}総説

＜考え方＞

火山砂防計画の構成と施設配置計画の関係について図3-5に示す。火山砂防計画は、噴火対応火山砂防計画と通常対応火山砂防計画からなる。噴火対応火山砂防計画において対象とする土砂移動現象は、火山活動に起因して発生する降灰後の土石流（流木含む）、火山泥流（流木含む）、及び必要に応じて、溶岩流、火砕流等であり、通常対応火山砂防計画において対象とする土砂移動現象は、降雨などに起因する土石流等である。噴火対応火山砂防計画は、計画的に実施が必要な対策を定める基本対策計画と、突発的な火山噴火災害の被害を軽減する方策としての火山噴火緊急減災対策砂防計画からなり、この施設配置計画に定める事項は、噴火対応火山砂防計画のうち基本対策計画に基づく施設配置に適用するものとするが、火山噴火緊急減災対策砂防計画に基づく対策が円滑に実施できるよう配慮する必要がある。噴火対応火山砂防計画の火山砂防施設配置計画は、火山活動に起因して発生する降灰後の土石流（流木含む）や火山泥流（流木を含む）の直撃等の直接的な災害を防止・軽減するための降灰後土石流対策施設配置計画や火山泥流対策施設配置計画、溶岩流による被害を防止・軽減するための溶岩流対策施設配置計画に分類できる。なお、火砕流については、規模、人為的な制御の実効性、事業の効率性を考慮し、必要に応じて施設配置を計画するものとする。

通常対応および噴火対応火山砂防計画の火山砂防施設配置計画は、土砂・洪水氾濫対策施設配置計画、土石流・流木対策施設配置計画と整合するように定める。また、噴火対応火山砂防計画の火山砂防施設は、降灰後の土石流（流木含む）、火山泥流（流木含む）、溶岩流などの各現象に対応して配置されるが、基本計画において複数の現象が想定される場合には、相互の効果が最大限に発揮されるように施設配置計画、施設構造等を調整し整備するものとする。

通常対応火山砂防計画の火山砂防施設配置計画においては、火山砂防地域特有の地形・地質等の特徴を踏まえ、土石流・流木対策施設配置計画における土砂処理計画を満たすよう、第3-2章2.2「土砂・洪水氾濫対策施設配置計画」、第3-2章2.3「土石流・流木対策施設配置計画」、第3-2章第3節「中期（土砂流出活発期）土砂流出対策施設配置計画」、第3-2章第4節「長期（土砂流出継続期）土砂流出対策施設配置計画」に準じて計画を策定する。

噴火対応火山砂防計画の火山砂防施設配置計画においては、対象とする土砂移動現象が噴火等に起因する不確実な要因を含むことから、火山活動状況、噴火後の新たな土砂移動現象の発生等の状況の変化に応じて適宜見直すことに留意する。

また、通常対応および噴火対応火山砂防計画の火山砂防施設配置計画の検討は、地形の開析が進んでいない渓流において、土石流等が尾根を乗り越えて流下する危険性があること等を十分に考慮して行う。

![](media/image10.emf){width="5.135416666666667in"
height="1.7291666666666667in"}

図3-5　火山砂防計画の構成と施設配置計画の関係

＜標　準＞

+----------------------------------------------------------------------+
| 噴火対応火山砂                                                       |
| 防計画の火山砂防施設配置計画は、降灰後土石流対策施設配置計画、火山泥 |
| 流対策施設配置計画、及び溶岩流対策施設配置計画の組み合わせからなる。 |
|                                                                      |
| 噴火対応火山砂防計画の火山砂防施設配置計画の策定                     |
| にあたっては、各施設の機能が有効に発揮されるよう、さらに、別に定める |
| 火山噴火緊急減災対策砂防計画に基づく緊急的な除石や嵩上げ等の対策が円 |
| 滑に実施できるよう、その配置や施設構造等に留意することを基本とする。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

> 1）「火山砂防計画策定指針（案）」の試行について,平成4年4月14日,建設省河砂部第8号,建設省河川局砂防部通達.
>
> （最新版）火山砂防計画策定指針，令和5年3月，国土交通省水管理・国土保全局砂防部.
>
> 2）火山噴火緊急減災対策砂防計画策定ガイドラインについて,平成19年4月27日,国土交通省国河砂第9号,河川局砂防部砂防計画課長通達.
>
> （最新版）火山噴火緊急減災対策砂防計画策定ガイドライン，令和5年3月，国土交通省水管理・国土保全局砂防部.
>
> 3）火山地域で発生する土石流が尾根を乗り越える危険に関する調査要領（試行案）,平成29年8月,国土交通省水管理・国土保全局砂防部砂防計画課地震火山砂防室,国立研究開発法人土木研究所土砂管理研究グループ火山・土石流チーム.
>
> 4）火山噴火に起因した土砂災害予想区域図作成の手引き（案），平成25年3月，国土交通省河川局砂防部.

2.  []{#_Toc67325285 .anchor}降灰後土石流対策施設配置計画

    1.  []{#_Toc67325286 .anchor}総説

＜考え方＞

降灰後土石流対策施設配置計画においては、火山噴火に伴う火山灰等が一定程度以上堆積した地域、または堆積が想定される地域において、降灰後の土石流（流木含む）に対する土砂処理計画を満たすよう、第3-2章2.3
「土石流・流木対策施設配置計画」に準じて、土石流・流木の捕捉、堆積、制御、発生抑制等の機能を有する施設を適切に選定し、施設の概略の位置や砂防堰堤高等の概略の規模を定める。

さらに、通常対応火山砂防計画における土石流に比べて、土石流の発生頻度が高く、また、長期間に及び、計画流出土砂量等が著しく多くなる傾向があることに留意し、砂防設備による流出土砂の捕捉・堆積容量確保のための除石計画、除石した土砂の運搬路および土砂の仮置き場を事前に準備しておくことを基本とする。

降灰後土石流対策施設配置計画上求められる機能毎の降灰後の土石流・流木対策施設の種類を以下に示す。なお、土石流・流木の捕捉、堆積、制御については、第3-2章2.3「土石流・流木対策施設配置計画」を参照すること。

表3-6　降灰後の土石流・流木対策施設の種類

+----------------+----------------+----------------+----------------+
|                | 対策施設に     | 主な工種       |                |
|                | 求められる機能 |                |                |
+================+================+================+================+
| 降灰後の土石流 | 生産源対策     | 土             | 砂防           |
| ・流木対策施設 |                | 石流の発生抑制 | 堰堤、床固工、 |
|                | ※流域が荒      |                |                |
|                | 廃している場合 |                | 護岸           |
|                |                |                | 工、渓流保全工 |
+----------------+----------------+----------------+----------------+
|                | 流送制御       | 土石           | 砂防堰堤       |
|                |                | 流・流木の捕捉 |                |
+----------------+----------------+----------------+----------------+
|                |                | 土石           | 土石流堆積工   |
|                |                | 流・流木の堆積 |                |
+----------------+----------------+----------------+----------------+
|                |                | 土石           | 土石流         |
|                |                | 流・流木の制御 | 導流工、土石流 |
|                |                |                | 緩衝樹林帯、土 |
|                |                |                | 石流流向制御工 |
+----------------+----------------+----------------+----------------+

＜標　準＞

+----------------------------------------------------------------------+
| 降灰後土石流対策施設配置計画は、降灰                                 |
| 後の土石流（流木含む）の火山砂防計画で扱う土砂量を処理できるように、 |
| 降灰後の土石流・流木対策施設の配置について計画することを基本とする。 |
|                                                                      |
| 降灰                                                                 |
| 後の土石流・流木対策施設は、火山砂防地域特有の地形・地質等の特徴を踏 |
| まえたうえで、降灰後の調査によって火山灰等が一定以上堆積した範囲、ま |
| たは堆積が想定される範囲を基に検討した範囲を踏まえた計画で扱う土砂・ |
| 流木量等、土砂移動の形態、保全対象との位置関係、通常対応火山砂防計画 |
| 施設等を考慮して、降灰後の土石流及び土砂とともに流出する流木等を合理 |
| 的かつ効果的に処理するように、必要な機能を有する施設を組み合わせて、 |
| 施設の概略の位置や概略の規模、施設の型式等を定めることを基本とする。 |
+----------------------------------------------------------------------+

＜推　奨＞

降灰後の土石流が停止する勾配は火山砂防地域以外の地域の土石流に比べて緩やかとなる傾向があることを踏まえ、当該火山の特性に応じて、適切に計画堆砂勾配を設定し、計画捕捉量及び計画堆積量を算定する。また、火山灰等は未固結で流動しやすいことから、計画発生（流出）抑制量には、火山灰等の堆積量は含まないこととする。

火山噴火による新規の火山灰等の影響により、降灰後の土石流の発生が長期間に及ぶ（雲仙岳1991年噴火および三宅島2000年噴火では噴火後数年程度）ことが想定されるため、火山灰等の堆積量が特に多い場合は、短期的な土砂移動だけでなく、中期的な土砂移動を想定した施設配置計画を策定することが望ましい。この場合は、第3-2章第3節「中期（土砂流出活発期）土砂流出対策施設配置計画」に準じて、施設配置計画を検討する。

＜例　示＞

雲仙岳では、噴火後の1991年5月以降に土石流が頻発するようになり、土石流の発生頻度及び規模は経年的に減少したが、土石流が頻発した期間は約10年に及んでいる。富士山では、雲仙岳の実績を踏まえ、噴火後10年間の降雨で発生する土石流を対象とした降灰後土石流対策施設配置計画を策定している。

降灰後の土石流（流木含む）に対する土砂処理計画において、計画流出土砂量等が著しく多く、計画流下許容土砂量等を０とする施設配置が合理性を欠く場合は、その旨を計画に明示したうえで、計画流下許容土砂量等を０とせず、一定の土砂流出を許容した施設配置計画とすることができる。桜島のように火山噴火活動が継続している場合は、不安定土砂が供給され続け、また、安全管理上生産源対策を実施することが困難であるため、除石や土石流を安全に海域へ流下させる施設配置計画を実施している事例がある。

＜参考となる資料＞

> 1）国土技術政策総合研究所土砂災害研究部砂防研究室：砂防基本計画策定指針（土石流・流木対策編）解説,国土技術政策総合研究所資料,第904号,2016.\
> （最新版）国土技術政策総合研究所土砂災害研究部砂防研究室：砂防基本計画策定指針（土石流・流木対策編）解説，平成28年4月（令和7年3月一部改定）
>
> 2）寺本行芳，地頭薗隆，下川悦郎，古賀省三：雲仙普賢岳における土石流発生降雨条件と流出特性の経年変化,砂防学会誌,Vol.54,No.5,2002.
>
> 3）国土交通省中部地方整備局富士砂防事務所・山梨県県土整備部砂防課・静岡県交通基盤部河川砂防局砂防課：富士山火山噴火緊急減災対策砂防計画,2018.

2.  []{#_Toc67325287 .anchor}降灰後の土石流・流木の捕捉のための施設

＜考え方＞

降灰後の土石流・流木の捕捉のための施設の配置計画は、第3-2章2.3.2「土石流・流木の捕捉のための施設」を参照して定める。

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  降灰後の土石流・流木の捕捉のための施設は、土石流の流下・堆積区間において、土石流および土砂とともに流出する流木等を捕捉するため、想定される土砂および流木の流出現象や地形等に応じて、概略の位置や概略の形状、施設の型式を定めて配置することを基本とする。降灰後の土石流・流木の捕捉のための施設として、透過型砂防堰堤を用いることを基本とする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜参考となる資料＞

> 1）国土技術政策総合研究所土砂災害研究部砂防研究室：砂防基本計画策定指針（土石流・流木対策編）解説,国土技術政策総合研究所資料,第904号,2016.\
> （最新版）国土技術政策総合研究所土砂災害研究部砂防研究室：砂防基本計画策定指針（土石流・流木対策編）解説，平成28年4月（令和7年3月一部改定）

3.  []{#_Toc67325288 .anchor}降灰後の土石流・流木の堆積のための施設

＜考え方＞

降灰後の土石流・流木の堆積のための施設の配置計画は、第3-2章2.3.3「土石流・流木の堆積のための施設」を参照して定める。

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  降灰後の土石流・流木の堆積のための施設は、土石流の堆積区間において、土石流を減勢し、土石流および土砂とともに流出する流木等を堆積させるため、地形、保全対象との位置関係等に応じて、概略の位置や概略の規模を定めて土石流堆積工を配置することを基本とする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜参考となる資料＞

> 1）国土技術政策総合研究所土砂災害研究部砂防研究室：砂防基本計画策定指針（土石流・流木対策編）解説,国土技術政策総合研究所資料,第904号,2016.\
> （最新版）国土技術政策総合研究所土砂災害研究部砂防研究室：砂防基本計画策定指針（土石流・流木対策編）解説，平成28年4月（令和7年3月一部改定）

4.  []{#_Toc67325289 .anchor}降灰後の土石流・流木の制御のための施設

＜考え方＞

降灰後の土石流・流木の制御のための施設の配置計画は、第3-2章2.3.4「土石流・流木の制御のための施設」を参照して定める。なお、火山山麓で特に火山が活動中の場合には、土石流・流木の捕捉、堆積のための施設などに加え、土地利用状況を考慮し、土石流緩衝樹林帯や土石流流向制御工とともに土石流導流工を併用することを検討する。

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  降灰後の土石流・流木の制御のための施設は、土石流の流下・堆積区間において、土石流・流木を安全に導流、堆積させる等制御するため、土石流ピーク流量や地形、保全対象との位置関係等に応じて、概略の位置や概略の形状を定めて配置することを基本とする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜例　示＞

有珠山では1977年噴火後に発生した土石流・泥流を安全に流下させるための土石流導流工が整備された事例がある。

雲仙岳では1990年噴火後に発生が想定された土石流・泥流を対象に、中小規模の土石流は安全に流下させるとともに、計画規模の土石流については堆積させながら安全に流下させるための土石流流向制御工が整備された事例がある。

桜島では、火山噴火活動が継続しており、不安定土砂が供給され続け、また、安全管理上生産源対策を実施することが困難であるため、土石流を安全に海域へ流下させるため、流出土砂の粒径も考慮した施設配置計画により、土石流導流工が整備された事例がある。

＜参考となる資料＞

> 1）国土技術政策総合研究所土砂災害研究部砂防研究室：砂防基本計画策定指針（土石流・流木対策編）解説,国土技術政策総合研究所資料,第904号,2016.\
> （最新版）国土技術政策総合研究所土砂災害研究部砂防研究室：砂防基本計画策定指針（土石流・流木対策編）解説，平成28年4月（令和7年3月一部改定）
>
> 2）雲仙・普賢岳火山砂防計画：平成28年3月（令和2年8月一部修正）,国土交通省九州地方整備局雲仙復興事務所.

5.  []{#_Toc67325290 .anchor}降灰後の土石流・流木の発生抑制のための施設

＜考え方＞

流域内が荒廃しているときなどは、降灰後の土石流・流木の発生抑制のための施設を配置する。

降灰後の土石流・流木の発生抑制のための施設の配置計画は、第3-2章2.3.5「土石流・流木の発生抑制のための施設」を参照して定める。降灰後の土石流（流木含む）の発生抑制のための施設は、渓床堆積土砂の移動および渓岸の崩壊を防止するための砂防堰堤、床固工からなる。

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  降灰後の土石流・流木の発生抑制のための施設は、流域内が荒廃している場合に、土石流の発生・流下区間において、土石流および土砂とともに流出する流木等の発生を抑制するため、渓床・渓岸等の土砂の発生源に、求められる機能に応じて概略の規模を定めて配置することを基本とする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜参考となる資料＞

> 1）国土技術政策総合研究所土砂災害研究部砂防研究室：砂防基本計画策定指針（土石流・流木対策編）解説,国土技術政策総合研究所資料,第904号,2016.\
> （最新版）国土技術政策総合研究所土砂災害研究部砂防研究室：砂防基本計画策定指針（土石流・流木対策編）解説，平成28年4月（令和7年3月一部改定）

3.  []{#_Toc67325291 .anchor}火山泥流対策施設配置計画

    1.  []{#_Toc67325292 .anchor}総説

＜考え方＞

火山泥流対策施設配置計画においては、火山噴火に伴う高温の噴出物による積雪等の融解、火口からの熱水の噴出、火口湖の決壊等によって大量の水が供給される地域において、大量の火山灰等の土砂と水を含んだ火山泥流（流木含む）に対する土砂処理計画を満たすために、第3-2章2.2「土砂・洪水氾濫対策施設配置計画」、第3-2章2.3「土石流・流木対策施設配置計画」及び第3-2章2.4「土砂・洪水氾濫時に流出する流木の対策施設配置計画」に準じて、火山泥流・流木の流出抑制や火山泥流・流木の捕捉、堆積、制御、発生抑制等の機能を有する施設を適切に選定し、施設の概略の位置や砂防堰堤高等の概略の規模を定める。また、火山泥流・流木対策施設には火山泥流・流木の流出抑制（土砂・流木等の貯留、ピーク流量の減少）と火山泥流・流木の捕捉、堆積、制御のための施設があり、それぞれについて適切に配置する必要がある。

火山泥流対策施設配置計画の検討は、現地調査、資料調査による施工の実行性の検討等とともに、施設の効果評価を数値計算等により行うことを基本とする。検討した施設配置計画では十分な効果が得られないと判断された場合、施設配置計画を見直して、再度、数値計算等により効果評価を行う。

火山泥流対策施設配置計画上求められる機能毎の火山泥流・流木対策施設の種類を以下に示す。なお、火山泥流・流木の流出抑制については、第3-2章2.2「土砂・洪水氾濫対策施設配置計画」及び第3-2章2.4「土砂・洪水氾濫時に流出する流木の対策施設配置計画」、火山泥流・流木の捕捉、火山泥流・流木の堆積、火山泥流・流木の制御については、第3-2章2.3「土石流・流木対策施設配置計画」を参照すること。

表3-7　火山泥流・流木対策施設の種類

+----------------+----------------+----------------+----------------+
|                | 対策施設に     | 主な工種       |                |
|                | 求められる機能 |                |                |
+================+================+================+================+
| 火山泥流       | 生産源対策     | 火山泥流・     | 砂             |
| ・流木対策施設 |                | 流木の発生抑制 | 防堰堤、床固工 |
|                | ※火山泥流      |                |                |
|                | の規模の増大が |                |                |
|                | 想定される場合 |                |                |
+----------------+----------------+----------------+----------------+
|                | 流送制御       | 火山泥流・     | 砂防           |
|                |                | 流木の流出抑制 | 堰堤、遊砂地工 |
+----------------+----------------+----------------+----------------+
|                |                | 火山泥         | 砂防堰堤       |
|                |                | 流・流木の捕捉 |                |
+----------------+----------------+----------------+----------------+
|                |                | 火山泥         | 砂防堰堤       |
|                |                | 流・流木の堆積 | 、土石流堆積工 |
+----------------+----------------+----------------+----------------+
|                |                | 火山泥         | 土             |
|                |                | 流・流木の制御 | 石流導流工、土 |
|                |                |                | 石流流向制御工 |
+----------------+----------------+----------------+----------------+

＜標　準＞

+----------------------------------------------------------------------+
| 火山泥流対策施設配                                                   |
| 置計画は、火山泥流（流木含む）の火山砂防計画で扱う土砂を処理できるよ |
| うに、火山泥流・流木対策施設の配置について計画することを基本とする。 |
|                                                                      |
| 火山泥流・流木対策施設は、計画で扱う土砂・流木量等、土砂移動の形     |
| 態、保全対象との位置関係とともに、通常対応火山砂防計画の火山砂防施設 |
| 配置計画、降灰後土石流対策施設配置計画を考慮して、火山泥流及び火山泥 |
| 流とともに流出する流木等を合理的かつ効果的に処理するように、必要な機 |
| 能を有する施設を組み合わせて、施設の概略の位置や概略の規模、施設の型 |
| 式等を定めることを基本とする。火山泥流・流木対策施設は火山泥流・流木 |
| の流出抑制、捕捉、堆積、制御のための施設を配置することを基本とする。 |
+----------------------------------------------------------------------+

＜例　示＞

十勝岳では、1926年に発生した融雪型火山泥流（大正泥流）とほぼ同等の規模を対象とした「十勝岳火山泥流対策基本計画」が策定されている。当該計画における泥流の処理方針は、泥流の発生・発達域で発生抑制のための侵食防止工を行い泥流の総量の減少を図り、流下・氾濫域において流出抑制・捕捉による処理を行うこととしている。土砂処理の方針としては、上流で粗粒土砂の透過型砂防堰堤による捕捉と遊砂地工による堆積、下流で砂防堰堤による流出抑制、細粒土砂の捕捉を行うこととしている。また、砂防堰堤・遊砂地工は流木が捕捉されるよう計画されている。さらに、観光施設等の保全を目的として土石流導流工を設けて、保全対象への泥流の氾濫を防ぐこととしている。

＜参考となる資料＞

1）巖倉啓子：十勝岳における火山泥流対策基本計画,砂防学会誌,Vol.52,No.6,2000.

> 2）十勝岳直轄火山砂防事業：国土交通省北海道開発局旭川開発建設部,
> https://www.hkd.mlit.go.jp/as/tisui/ho928l0000000n1h.html

2.  []{#_Toc67325293 .anchor}火山泥流・流木の流出抑制のための施設

＜考え方＞

火山泥流・流木の流出抑制のための施設の配置計画は、第3-2章2.2.4「土砂の流出抑制あるいは調節のための施設」及び第3-2章2.4.3「流木捕捉のための施設」を参照して定める。火山泥流・流木の流出抑制のための施設は、透過・不透過型堰堤による捕捉・堆積容量への火山泥流・流木等の貯留、ピーク流量の減少により、火山泥流・流木の流出抑制機能を発揮する。この機能は土砂の堆積によって失われるので、計画上これを見込む場合は除石などにより機能の回復を行う必要がある。火山泥流・流木の流出抑制のための施設は、主に河道に配置するもので、想定される火山泥流の発生メカニズム、土砂量、地形、渓床・山腹勾配、河道・斜面の状況等に応じて、施設の概略の位置や規模を決める必要がある。火山泥流の流出抑制のための施設には、砂防堰堤、遊砂地工等がある。

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  火山泥流・流木の流出抑制のための施設は、有害な土砂・流木等の流出を抑制するため、火山泥流の流送区間において、求められる機能に応じて、概略の位置や概略の規模を定めて配置することを基本とする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

施設の概略の位置の検討にあたっては、対象流域内の施設効果の大きい箇所を抽出し、施設効果の大きい箇所から優先的に施設配置を検討するなど効果的な施設配置を行うことが望ましい。

3.  []{#_Toc67325294 .anchor}火山泥流・流木の捕捉のための施設

＜考え方＞

火山泥流・流木の捕捉のための施設の配置計画は、第3-2章2.3.2「土石流・流木の捕捉のための施設」及び第3-2章5.2.2「降灰後の土石流・流木の捕捉のための施設」を参照して定める。火山泥流・流木の捕捉のための施設は、火山泥流の流下・堆積区間において、火山泥流中の土砂・流木の捕捉により、火山泥流・流木の捕捉機能を発揮する。火山泥流・流木の捕捉のための施設は、河道に配置するもので、想定される火山泥流の土砂の粒径、火山泥流の濃度、流木の大きさ（長さ、太さ）、流木量、地形等に応じて、施設の概略の位置や概略の形状、施設の型式を決める必要がある。火山泥流・流木の捕捉のための施設には、砂防堰堤等がある。

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  火山泥流・流木の捕捉のための施設は、火山泥流の流下・堆積区間において、火山泥流および土砂とともに流出する流木等を捕捉するため、想定される土砂および流木の流出現象や地形等に応じて、概略の位置や概略の形状、施設の型式を定めて配置することを基本とする。火山泥流・流木の捕捉のための施設として、砂防堰堤を用いることを基本とする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

4.  []{#_Toc67325295 .anchor}火山泥流・流木の堆積のための施設

＜考え方＞

火山泥流・流木の堆積のための施設の配置計画は、第3-2章2.3.3「土石流・流木の堆積のための施設」及び第3-2章5.2.3「降灰後の土石流・流木の堆積のための施設」を参照して定める。火山泥流・流木の堆積のための施設は、火山泥流の堆積区間において、火山泥流・流木の堆積により、火山泥流・流木の堆積機能を発揮する。火山泥流・流木の堆積のための施設は、河道に配置するもので、想定される火山泥流の濃度、流木の大きさ（長さ、太さ）、流木量、地形、保全対象との位置関係等に応じて、施設の概略の位置や規模を決める必要がある。火山泥流・流木の堆積のための施設には、砂防堰堤、土石流堆積工等がある。

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  火山泥流・流木の堆積のための施設は、火山泥流の堆積区間において、火山泥流を減勢し、火山泥流および土砂とともに流出する流木等を堆積させるため、地形、保全対象との位置関係等に応じて、概略の位置や概略の規模を定めて配置することを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

5.  []{#_Toc67325296 .anchor}火山泥流・流木の制御のための施設

＜考え方＞

火山泥流・流木の制御のための施設の配置計画は、第3-2章2.3.4「土石流・流木の制御のための施設」及び第3-2章5.2.4「降灰後の土石流・流木の制御のための施設」を参照して定める。火山泥流・流木の制御のための施設は、火山泥流の流下・堆積区間において、火山泥流・流木の導流・堆積、流向制御により、火山泥流・流木の制御機能を発揮するもので、火山泥流のピーク流量、流木の大きさ（長さ、太さ）、流木量、地形、保全対象との位置関係等に応じて、施設の概略の位置や規模を決める必要がある。火山泥流・流木の制御のための施設には、土石流導流工、土石流流向制御工等がある。

火山泥流・流木の制御のための施設は、原則として火山泥流・流木の流出抑制、捕捉、堆積のための施設を配置した上で、さらに火山泥流・流木を導流、流向制御し、下流に安全に流下させるために配置するものである。火山泥流・流木の流向制御のための施設は、火山泥流を流下させても安全な場所があり、下流に災害等の問題を生じさせずに安全な場所まで火山泥流を流下させることができる場合に配置する。

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  火山泥流・流木の制御のための施設は、火山泥流の流下・堆積区間において、火山泥流・流木を安全に導流、堆積させる等制御するため、地形、保全対象との位置関係等に応じて、概略の位置や概略の形状を定めて配置することを基本とする。火山泥流・流木の制御のための施設は、火山泥流・流木の流出抑制、捕捉、堆積のための施設を配置した上で、さらに火山泥流・流木を導流・堆積、流向制御し、下流に安全に流下させるために配置することを基本とする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

6.  []{#_Toc67325297 .anchor}火山泥流・流木の発生抑制のための施設

＜考え方＞

火山泥流の流下中に、渓床・渓岸の侵食等により泥流の規模の増大が想定される場合、火山泥流・流木の発生抑制のための施設を配置する。

火山泥流・流木の発生抑制のための施設の配置計画は、第3-2章5.2.5「降灰後の土石流・流木の発生抑制のための施設」を参照して定める。火山泥流・流木の発生抑制のための施設は、主に火山泥流の発生・流下区間において、渓床・渓岸侵食防止等により、火山泥流・流木の発生抑制機能を発揮する。火山泥流・流木の発生抑制のための施設には、砂防堰堤、床固工等がある。

＜標　準＞

+----------------------------------------------------------------------+
| 火山泥流・流木の発生抑制のための施設は、渓床・渓岸の侵食             |
| 等により泥流の規模の増大が想定される場合に配置することを基本とする。 |
|                                                                      |
| 火山泥流・流木の発                                                   |
| 生抑制のための施設は、火山泥流の発生・流下区間において、求められる機 |
| 能に応じて、概略の位置や概略の規模を定めて配置することを基本とする。 |
+----------------------------------------------------------------------+

4.  []{#_Toc67325298 .anchor}溶岩流対策施設配置計画

    1.  []{#_Toc67325299 .anchor}総説

＜考え方＞

溶岩流対策施設配置計画においては、火山噴火に伴う溶岩流の流下が想定される地域において、溶岩流処理計画を満たすために、溶岩流の制御等の機能を有する施設を適切に選定し、施設の概略の位置や概略の形状を定める。また、溶岩流対策施設には導流、流向制御等を目的とした制御のための施設があり、それぞれについて適切に配置する必要がある。

溶岩流対策施設配置計画は、通常対応火山砂防計画の火山砂防施設配置計画、第3-2章5.2「降灰後土石流対策施設配置計画」、第3-2章5.3「火山泥流対策施設配置計画」において、溶岩流に対する効果に配慮した溶岩流対策施設配置計画としつつ、溶岩流の規模、想定火口位置と保全対象の位置関係を踏まえた人為的な制御の実効性、事業の効率性の観点から、一定の条件を満たした場合に、主体的な溶岩流対策施設配置計画を策定する。

溶岩流対策施設配置計画の検討は、現地調査、資料調査による施工の実行性の検討等とともに、施設の効果評価を数値計算等により行うことを基本とする。検討した施設配置計画では十分な効果が得られないと判断された場合、施設配置計画を見直して、再度数値計算等により効果評価を行う。

表3-8　火山泥流・流木対策施設の種類

                   対策施設に求められる機能   主な工種       
  ---------------- -------------------------- -------------- ----------------------------------------------------
  溶岩流対策施設   流送制御                   溶岩流の制御   溶岩流導流工、溶岩流流向制御工、砂防堰堤、遊砂地工

＜標　準＞

+----------------------------------------------------------------------+
| 溶岩                                                                 |
| 流対策施設配置計画は、溶岩流に対する火山砂防計画で扱う溶岩流出量を処 |
| 理できるように溶岩流対策施設の配置について計画することを基本とする。 |
|                                                                      |
| 火山によっては火口位置が噴火のた                                     |
| びに異なり、また溶岩の流出量は噴火活動が終息するまで特定できないこと |
| から、基本対策計画として溶岩流対策を実施することは一般に困難である。 |
| このため、溶岩流対策施設は、通常対応火山砂防計画の火山砂防施設配置計 |
| 画、第3-2章5.2「降灰後土石流対策施設配置計画」、第3-2章5.3「火山泥流 |
| 対策施設配置計画」の検討に合わせ、施設の位置や形状に配慮することで、 |
| 溶岩流の制御に期待した溶岩流対策施設配置計画とすることを基本とする。 |
+----------------------------------------------------------------------+

＜例　示＞

伊豆大島の三原山を対象とした溶岩流対策において、過去の噴火履歴から火口位置や溶岩流の規模、流動深がおおむね特定でき、想定火口位置と保全対象となる集落の間に、集落に向かって流下する溶岩流の流向を集落等がない方向に制御する導流堤（溶岩流流向制御工）が整備された事例がある。

なお、溶岩流が導流される方向では土地利用が限定されること、火口位置と保全対象及び導流堤の位置関係によっては、溶岩流が保全対象に向かうことを助長する危険性があることなどから、溶岩流の施設配置計画においては慎重な検討を必要とする。

＜参考となる資料＞

1）東京都大島支庁：総合溶岩流対策事業,

> https://www.soumu.metro.tokyo.lg.jp/11osima/doboku/yougannryuu.html　\
> （最新版）安食昭夫：伊豆大島・総合溶岩流対策事業の現状について，砂防と治水，
> No.174, p.123-126, 2006

2.  []{#_Toc67325300 .anchor}溶岩流の制御のための施設

＜考え方＞

溶岩流の制御のための施設には、導流、流向制御等を目的とした施設がある。

溶岩流の導流のための施設は、溶岩流を流下させても安全な場所があり、下流に災害等の問題を生じさせずに安全な場所まで溶岩流を流下させることができる場合に配置する。溶岩流の導流のための施設には、溶岩流導流工等がある。

溶岩流の流向制御のための施設は、溶岩流の流下方向を制御するために配置するもので、想定火口位置と保全対象の位置関係、溶岩流の流動形態、地形、渓床・山腹勾配等に応じて、施設の概略の位置や規模を決める必要がある。溶岩流の流向制御のための施設には、溶岩流流向制御工等がある。

溶岩流の制御のための施設の配置計画は、第3-2章5.2.4「降灰後の土石流・流木の制御のための施設」及び第3-2章5.3.5「火山泥流・流木の制御のための施設」を考慮して定める。なお、溶岩流は流下に伴う温度低下で粘性が高くなり堆積するが、火口から噴出した時点の温度が想定より低い場合や、天候等の影響で想定より早く温度低下が進んだ場合には、想定外の場所で堆積して後続流の流下を阻害し、後続流の流下方向が変わる場合や流動深が大きくなる場合があり、導流、流向制御のための施設が想定どおりの効果を発揮しない場合があることに留意する必要がある。

また、通常対応火山砂防計画の火山砂防施設配置計画、第3-2章5.2「降灰後土石流対策施設配置計画」、第3-2章5.3「火山泥流対策施設配置計画」で整備した砂防堰堤や遊砂地工等が溶岩流の流下経路上にある場合は、一時的に溶岩流の流出を抑制し、溶岩流が保全対象に到達する時間を遅らせる効果が期待できることがあり、その効果は数値計算等により評価する。なお、砂防堰堤等に溶岩流が保全対象に到達する時間を遅らせる効果を期待する場合は、除石などにより堆積容量を確保するよう管理する必要がある。

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  溶岩流の制御のための施設は、溶岩流の流下・堆積区間において、溶岩流を安全に導流、流向制御等するため、溶岩流の流動形態、地形、保全対象との位置関係等に応じて、概略の位置や概略の形状を定めて配置することを基本とする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

5.  []{#_Toc67325301
    > .anchor}深層崩壊・天然ダム等異常土砂災害対策施設配置計画

    1.  []{#_Toc67325302 .anchor}総説

＜考え方＞

事前対策としての深層崩壊・天然ダム等異常土砂災害対策施設配置計画においては、深層崩壊や天然ダムによる異常土砂災害を事前に防止・軽減するための土砂処理計画を満たすために、深層崩壊の発生の抑制・抑止、天然ダムの高さの低減及び急激な決壊の抑制、天然ダムの決壊時に流出する土砂・泥水の流出制御、深層崩壊による土石流の捕捉及び流出抑制等の機能を有する施設を適切に選定し、施設の概略の位置や砂防堰堤高等の概略の規模を定める。また、深層崩壊・天然ダム等異常土砂災害対策施設には、生産抑制を主な目的とする施設と流送制御を主な目的とする施設があり、それぞれについて大規模土砂生産後の減災対応にも配慮した上で、適切に配置する必要がある。

深層崩壊・天然ダム等異常土砂災害に対するハード対策は、以下の①～③の深層崩壊で生じた土石等の流下機構・形態に即した対策手法を用いることが重要である。

①天然ダムタイプ

深層崩壊で生じた崩壊土砂により、いったん、天然ダムが生じ、その天然ダムの決壊にともない急激な水・土砂の流出が生じることにより被害が生じるタイプ。なお天然ダムタイプにおいては、天然ダム上流域の湛水による被害が生じる場合もある。

②土石流タイプ

深層崩壊で生じた崩壊土砂が土石流化し、土石流により直接的な被害が生じるタイプ。

③崩土の直撃タイプ

深層崩壊で生じた崩壊土砂が流下し、崩壊土砂により直接的な被害が生じるタイプ。

ハード対策においては、現地の地形条件、地域計画、景観、環境等を総合的に勘案して合理的かつ効果的なものとする。また、深層崩壊で生じた土石等の流下機構・形態を1つに決定することは困難である場合も多く、複数の現象に対して効果が発揮できる施設および施設配置が望ましい。さらに、深層崩壊のおそれのある地域であっても深層崩壊以外による土砂災害も生じる可能性があることから、深層崩壊以外の現象に効果が発揮できる施設および施設配置が望ましい。

天然ダムタイプの対策施設のうち、

・天然ダムの高さの低減

・天然ダムの急激な決壊の抑制

・天然ダムの決壊時に流出する土砂・泥水の流出抑制

の配置計画の検討・効果評価にあたっては、以下の①～③のプロセス及び対策施設の効果を表現できる数値計算等を用いて検討することが望ましい。

①崩壊土砂および土石流の流下・堆積による天然ダムの形成

②天然ダムの越流侵食等による決壊

③天然ダムの決壊に起因する土石流・洪水流の流下

また、土石流タイプの対策施設のうち、

・深層崩壊による土石流の捕捉

・深層崩壊による土石流の流出抑制

の配置計画の検討・効果評価にあたっては、土石流の流下・堆積のプロセス及び対策施設の効果を表現できる数値計算等を用いて検討することが望ましい。

深層崩壊の発生を抑制・抑止する施設の配置計画の検討にあたっては、斜面の重力性の変形の進行を抑制・抑止する施設を計画できる場合は、第3-3章「地すべり防止施設配置計画」に準じて、施設配置計画を策定することが望ましい。

深層崩壊・天然ダム等異常土砂災害対策配置計画は、短期土砂・流木流出対策施設配置計画、中期土砂流出対策施設配置計画と整合するように定める。

![](media/image11.png){width="5.30625in" height="3.6979166666666665in"}

図3-6　ハード対策のイメージ（天然ダムタイプ）

![](media/image12.png){width="4.34375in" height="3.623611111111111in"}

図3-7　ハード対策のイメージ（土石流タイプ）

深層崩壊・天然ダム等異常土砂災害対策配置上求められる機能毎の深層崩壊・天然ダム等異常土砂災害対策施設の種類を以下に示す。

表3-9　深層崩壊・天然ダム等異常土砂災害対策施設の種類

                                             対策施設に求められる機能   主な工種                                         対象とする現象（タイプ）                                                                        
  ------------------------------------------ -------------------------- ------------------------------------------------ ------------------------------------------------------------------------- -------- ------------ ----
                                                                                                                         天然ダム                                                                  土石流   崩土の直撃   
  深層崩壊・天然ダム等異常土砂災害対策施設   生産抑制                   深層崩壊の発生の抑制・抑止                       砂防堰堤(不透過型)、地すべり防止施設※重力性の変形の進行の抑制・抑止のみ   〇       〇           〇
                                                                        天然ダムの高さの低減                             砂防堰堤（不透過型）                                                      〇                    
                                             流送制御                   天然ダムの高さの低減                             砂防堰堤                                                                  〇                    
                                                                        天然ダムの急激な決壊の抑制                       砂防堰堤                                                                  〇                    
                                                                        天然ダムの決壊時に流出する土砂・泥水の流出制御   砂防堰堤(透過型せき上げタイプ)                                            〇                    
                                                                        深層崩壊による土石流の捕捉                       砂防堰堤(透過型)                                                                   〇           
                                                                        深層崩壊による土石流の流出抑制                   砂防堰堤(不透過型)                                                                 〇           

＜標　準＞

+----------------------------------------------------------------------+
| 深層崩壊・天然ダム等異常土砂災害対策配置計画は、土                   |
| 砂処理計画を満たすよう、深層崩壊・天然ダム等異常土砂災害対策施設の配 |
| 置について、既往の実績や数値計算等に基づき計画することを基本とする。 |
|                                                                      |
| 深層崩壊・天然ダム等異常土砂災害対策施設は、計画で                   |
| 扱う土砂量、対象とする現象、保全対象との位置関係等を考慮して、深層崩 |
| 壊によって生じた土石等を合理的かつ効果的に処理するように、必要な機能 |
| を有する施設を組み合わせて、施設の概略の位置や概略の規模、施設の型式 |
| 等を定めることを基本とする。深層崩壊・天然ダム等異常土砂災害対策施設 |
| は土砂の生産抑制及び流送制御のための施設を配置することを基本とする。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

> 1）蒲原潤一，内田太郎：深層崩壊対策技術に関する基本的事項，国土技術政策総合研究所資料，第807号，2014.

2.  []{#_Toc67325303 .anchor}深層崩壊の発生の抑制・抑止のための施設

＜考え方＞

深層崩壊の発生の抑制のための施設のうち、斜面を直接的に対策する施設については、重力性の変形の進行による深層崩壊を除き、現時点で十分な技術開発が行われているとは言い難い。

地すべり土塊の末端または地すべり土塊そのものが通常の緩慢な運動から急激に崩落に至るような、重力性の変形の進行による深層崩壊の対策には、地すべり対策等による重力性の変形の進行を抑制・抑止することが有効であると考えられる。河道の側方斜面の下部に深層崩壊のおそれのある斜面がある場合は、水衝部の側岸侵食を防ぐなどの山脚固定が期待できる砂防堰堤（不透過型）が有効であると考えられる。

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  深層崩壊の発生の抑制のための施設は、急激な地下水位上昇や地盤の揺れ、重力性の変形の進行等による深層崩壊の発生を抑制するため、深層崩壊のおそれのある斜面において求められる機能に応じて、概略の位置や概略の規模を定めて配置することを基本とする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

3.  []{#_Toc67325304 .anchor}天然ダムの高さの低減のための施設

＜考え方＞

深層崩壊に起因する天然ダムは、側岸斜面が崩壊して河道に土塊が流入し天然ダムを形成する場合に加えて、本川に接続する支渓内で発生した深層崩壊が土石流化するなどし、本川に流入し、天然ダムを形成する場合がある。この場合、天然ダムの高さを低減するために、支渓内に深層崩壊に起因する土石流等の捕捉・流出抑制する施設を配置することが有効である。また、天然ダムを形成するおそれの高い区間の河床を上昇させることにより、川幅を広げておくことができれば、深層崩壊が発生したとしても天然ダムの高さを低減することができると考えられる。事前対策については、深層崩壊のおそれが高い斜面・支渓、天然ダムを形成するおそれの高い区間をある程度特定できる場合に検討する。

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  深層崩壊の発生により形成される天然ダムの高さを低減するため、深層崩壊の発生のおそれのある支渓及び天然ダムを形成するおそれのある区間において求められる機能に応じて、概略の位置や概略の規模を定めて施設を配置することを基本とする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

4.  []{#_Toc67325305 .anchor}天然ダムの急激な決壊の抑制のための施設

＜考え方＞

天然ダムが生じた場合に急激な決壊を抑制する施設としては、事前対策施設と緊急対策時に設置する施設が考えられる。天然ダムが越流等により侵食された場合に、天然ダム直下に土砂を堆積させ、侵食の進行を緩やかにする施設として、土砂を捕捉・堆積させる砂防堰堤が考えられる。事前対策については、深層崩壊のおそれが高い斜面・支渓、天然ダムを形成するおそれの高い区間をある程度特定できる場合に検討する。

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  深層崩壊の発生により形成される天然ダムの急激な決壊を抑制するため、事前対策時及び緊急対策時において求められる機能に応じて、概略の位置や概略の規模を定めて施設を配置することを基本とする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

5.  []{#_Toc67325306
    > .anchor}天然ダムの決壊時に流出する土砂・泥水の流出制御のための施設

＜考え方＞

土砂・泥水の流出を制御する施設は、天然ダム決壊により土石流・洪水流が生じた場合にピーク流量を減少させ、下流の河道でピーク流量が流下可能となるようにするために用いる。代表的なものとして、スーパー暗渠砂防堰堤、せき上げタイプの透過型砂防堰堤が考えられる。

![](media/image13.png){width="3.3604166666666666in"
height="2.520138888888889in"}

図3-8　天然ダムの決壊時に流出する土砂・泥水の流出制御のための施設の整備事例

（スーパー暗渠砂防堰堤）

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  天然ダム決壊により土石流・洪水流が生じた場合に土砂・泥水の流下を制御するため、ピーク流量を減少させるよう、概略の位置や概略の規模を定めて施設を配置することを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------

6.  []{#_Toc67325307 .anchor}深層崩壊による土石流の捕捉のための施設

＜考え方＞

深層崩壊により土石流が生じた場合に土石流を捕捉する施設は、通常の土石流対策同様、空き容量を常に確保した砂防堰堤等である。代表的なものとして、スーパー暗渠砂防堰堤、せき上げタイプの透過型砂防堰堤が考えられる。

複数の深層崩壊のおそれのある斜面が存在するような渓流では、深層崩壊が発生したとしても土石流を捕捉できるように施設を保全対象の直上に設置できれば様々な場所で発生する深層崩壊に対して、被害を防止できることが期待できる。このため、流域面積が広く、複数の深層崩壊のおそれのある斜面が存在するような渓流では、明らかに深層崩壊のおそれが高い斜面を特定できない限りは、深層崩壊により土石流が生じた場合に土石流を捕捉する施設を保全対象直上に設置することが効率的である。

また、深層崩壊地から対策施設まで距離がある場合は、多くの土砂が流下中に堆積することにより，土石流の規模が小さくなることが期待でき，外力が比較的小さくなる可能性が高い。

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------
  深層崩壊により土石流が生じた場合に土石流を捕捉するため、保全対象の直上において、概略の位置や概略の規模を定めて施設を配置することを基本とする。
  ------------------------------------------------------------------------------------------------------------------------------------------------

7.  []{#_Toc67325308 .anchor}深層崩壊による土石流の流出抑制のための施設

＜考え方＞

深層崩壊に起因する土石流は一般的に土砂濃度が高く、緩勾配区間においては、土砂が急激に堆積し、土石流の流出が抑制されると考えられる。そこで、深層崩壊により土石流が生じた場合に土石流を流出抑制する施設は河床勾配を緩くする施設で、代表的なものとして不透過型の砂防堰堤が考えられる。ただし、不透過型の砂防堰堤であっても、急勾配で堆砂した後は、緩勾配となるよう除石する必要がある。

想定される土石流の規模が非常に大きいなど、土石流を全て捕捉することが困難な場合は、土石流の流出を抑制する施設の設置を検討する。さらに、保全対象の直上に、土石流を捕捉する施設を設置する場合であっても、上流側に土石流を流出抑制する施設を設置できれば、保全対象の直上の土石流を捕捉する施設に加わる外力を小さくすることができる。

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  深層崩壊により土石流が生じた場合に土石流の流出を抑制するため、河床勾配を緩くして土砂が急激に堆積するよう、概略の位置や概略の規模を定めて施設を配置することを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------

6.  []{#_Toc67325309 .anchor}地すべり防止施設配置計画

    1.  []{#_Toc67325310 .anchor}総説

＜考え方＞

地すべりは多くの場合、相互に関連しながら活動する複数の運動ブロックから構成されている。地すべり防止施設の配置は、必要に応じて運動ブロックの範囲、ブロックの相互関係や安定度、保全対象の位置や重要性に応じて各ブロックの対策の優先度を設定し、対象とする地すべり地の安定性を効率的に向上させるよう計画する必要がある。地すべり防止工事の施工中及び施工後は、実施した工事の効果が計画どおり発揮されているか確認し、工事の効果が十分ではない場合や判断できない場合には、必要に応じて調査、計画を見直す。

継続的な調査の結果、新たな情報が得られた場合には、調査、計画等の見直しが必要になることもある。また、地すべりの運動状況の変化に応じて、追加の調査、計画等が必要となる場合もある。断続的に地すべり運動が見られる斜面では、調査により得られた情報をもとに迅速に解析を行いながら、適切な対策等を進めていくべきことを十分に認識しておく必要がある。

＜標　準＞

+----------------------------------------------------------------------+
| 地すべり防止施設配置計画は、地すべり                                 |
| 防止計画に基づき、地すべり防止施設の配置について計画するものとする。 |
|                                                                      |
| また、地すべり防止工事の施工中及び施工後は、実施した工事の効果       |
| が計画どおり発揮されているか確認し、必要に応じて調査、計画を見直す。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

> 1）独立行政法人土木研究所土砂管理研究グループ地すべりチーム：地すべり防止技術指針及び同解説（提案），土木研究所資料第4077号,2007.
>
> （最新版）地すべり防止技術指針及び同解説，平成20年4月，国土交通省砂防部，(独)土木研究所.

2.  []{#_Toc67325311 .anchor}地すべり防止施設配置計画

    1.  []{#_Toc67325312 .anchor}総説

＜考え方＞

地すべり防止施設配置計画における工事の規模は、一般に計画安全率で示され、一体となって移動していると考えられる運動ブロックごとに、安定解析によって定められる。安定解析は、地すべりの特性(平面形、すべり面形状、移動状況等)に応じて適切な解析手法により行い、地すべり防止施設の規模を決める。斜面安定解析に用いる土質強度定数は、地すべりの形態及び土質条件に応じて、適切な手法により設定する。斜面安定解析に用いる間隙水圧は、すべり面における間隙水圧を計測する手法のうち適切な手法によって測定された値を用いる。

地すべりは、地形、地質、土質等の素因と降雨・融雪等の気象条件、地下水条件、切土等の人為行為及び地震等の誘因との組み合わせによって生じる複雑な現象である。したがって、効果的な防止施設配置計画を策定するためには、事前の調査を十分に実施し、地すべり発生の原因・機構、保全対象の種別、地すべりと保全対象の位置関係等を明らかにし、それらに基づいた適切な工法を選定し、適切な位置に配置する。特に工法の選定にあたっては、降雨及び地下水と地すべり運動の関係、地すべりの規模、地すべり土塊の土質、地すべりの速度、ブロック区分、対策工の位置、工法の緊急性を十分に考慮する。また、採用する工種の施工順位は、地すべり発生機構、地すべりの運動状況、人為的誘因の影響度合等から判断する。

地すべり防止施設はその機能の違いから抑制工と抑止工に分類される。

> 1\.
> 抑制工は、地すべり地の地形、地下水の状態などの自然条件を変化させることによって、地すべり運動を緩和又は停止させることを目的とする工法である。
>
> 2\.
> 抑止工は、設置した構造物の持つ抵抗力を利用して、地すべり運動を停止させることを目的とする工法である。

これまで一般的に用いられてきた工法を分類すると図のとおりである。

![](media/image14.png){width="5.579861111111111in"
height="1.6354166666666667in"}

図3-9　地すべり防止工事の工法の分類

抑制工、抑止工の選定にあたっては、次の点に留意する。

1\. 抑制工と抑止工の持つそれぞれの特性を合理的に組み合わせた計画とする。

> 2\.
> 工法の主体は地下水排除工、押え盛土工、排土工等の抑制工とし、人家や公共施設等を直接守るために運動ブロックの安定化を図る場合に杭工、アンカー工等の抑止工を計画する。
>
> 3\.
> 地すべり運動が継続している場合には、原則として抑止工は先行せず、抑制工によって地すべり運動が緩和、又は停止してから抑止工を導入する。
>
> 4\.
> 施工時のみならず維持管理も含めたトータルコストを考慮する。必要に応じて、新工法についても検討する。

＜標　準＞

+----------------------------------------------------------------------+
| 地すべり防止施設配置計画は、地すべりの                               |
| 規模及び発生・運動機構等に応じて、各施設の効果を勘案し、地すべりによ |
| る災害の防止が図られるように適切な配置となるよう策定するものとする。 |
|                                                                      |
| 地すべり防止施設配置計画においては、地すべりの運動ブロック毎に運動   |
| 方向に沿った断面における斜面安定解析を行い、その結果に基づき、所定の |
| 計画安全率（P.Fs）を確保するように防止工事の工法及び規模を決定する。 |
|                                                                      |
| 地すべり防止施設配置計画においては                                   |
| 、地すべりの規模及び発生・運動機構、保全対象の状況、工法の経済性等を |
| 勘案し、抑制工と抑止工を適切に組み合わせて工法を選定するものとする。 |
+----------------------------------------------------------------------+

＜例　示＞

BIM/CIMを地すべり防止施設配置計画に活用することで、地形やすべり面、地下水分布、施設配置案の位置関係等が3次元的に視覚化され、地すべりの素因と誘因を踏まえた最適な配置を検討することが容易になると期待される。

2.  []{#_Toc67325313 .anchor}抑制工

＜考え方＞

抑制工は、地すべり地の地形、地下水の状態などを変化させることによって、滑動力と抵抗力のバランスを改善し、地すべり運動を停止または緩和させるように、維持管理も含めたトータルコストも考慮し、以下の工法を合理的に組み合わせて適切に配置するよう計画する。

抑制工には、地表水排除工、地下水排除工、排土工、押え盛土工、河川構造物等による侵食防止工等がある。各工法の特徴を踏まえて、地すべりの抑制に適切な位置、数量を計画する必要がある。

1．地表水排除工(水路工、浸透防止工)

> 降雨や地表水の浸透や湧水、沼、水路等地すべり地域内外からの再浸透によって地すべりが誘発されるのを防止するために計画する。

2．浅層地下水排除工(暗渠工、明暗渠工、横ボーリング工)

> 浅層部に分布する地下水を排除することによって、すべり面付近への地下水供給を抑えるために計画する。

3．深層地下水排除工(横ボーリング工、集水井工、排水トンネル工)

> 深層部に分布する地下水を排除することによって、すべり面付近の間隙水圧(地下水位)を低下させるために計画する。

4．排土工(切土工)

> 地すべりが滑動しようとする力(地すべりの滑動力)を低減するため、原則として地すべり頭部に計画する。地形条件の変化により新たな地すべりが誘発されないよう留意する必要がある。

5．押え盛土工

> 地すべりの滑動力に抵抗する力を増加させるため、原則として地すべり末端部に計画する。排土工と同様に地形条件の変化により新たな地すべりが誘発されないように留意する必要がある。

6.河川構造物等による侵食防止工(のり面保護工、砂防堰堤、護岸工等)

> 河川や雨水等の流水による侵食や崩壊が地すべり発生の誘因となる場合に、侵食や崩壊の防止を図るために計画する。地すべり地域の直下流部に砂防堰堤等を設けると、その堆砂によって地すべり末端部の崩壊や侵食が防止され、押え盛土と同様の効果が期待できる。

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------
  抑制工は、地すべり斜面の地形、地質、地下水などの自然条件を変化させることによって、地すべり運動を効果的に抑制することができるように計画するものとする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------

3.  []{#_Toc67325314 .anchor}抑止工

＜考え方＞

抑止工は、構造物のもつ抵抗力を付加することにより、地すべり運動の一部または全部を停止させるように、維持管理も含めたトータルコストも考慮し、以下の工法を単独もしくは合理的に組み合わせて適切に配置するよう計画する。

抑止工としては、杭工、シャフト工、アンカー工等が計画される。各工法の特徴を踏まえて、地すべりの抑止に適切な位置、数量を計画する。

1\. 杭工

> 杭を不動地盤まで挿入し、付加された杭のせん断抵抗力や曲げ抵抗力によって地すべりの滑動力に直接抵抗することを目的として計画する。
>
> 杭工は一般に複数の鋼管杭を地すべりの移動方向に対して直角方向に列状に配置し、地すべり滑動力に一体となって対抗させる工法である。
>
> 計画位置は、原則として地すべり運動ブロックの中央部より下部とし、杭の根入れ部となる基盤が強固で地盤反力が期待できる場所を選定する。

2\. シャフト工(深礎工)

> 径2.5～6.5ｍ程度の縦坑を不動地盤内まで掘削し鉄筋コンクリートを打設したものをシャフト工と呼んでいる。地すべりの滑動力が大きく、杭工では所定の計画安全率の確保が困難な場合で、不動地盤が良好な場合に計画する。

3\. アンカー工

> アンカー工では、斜面から不動地盤にテンドン（鋼材等）を挿入し、基盤内に定着させた鋼材の引張強さを利用して斜面を安定化させるものである。地すべり対策工として使用されるアンカー工には、すべり面に対する垂直応力をアンカー工により増加させることによってせん断抵抗力を増加させようとする効果（締め付け効果）を期待するものと、地すべり土塊が、滑落しようとした時にアンカー工のすべり面の接線方向の引張り力によって地すべり土塊を引き止めようとする効果（引き止め効果）を利用するものがある。アンカー工は、引き止め効果あるいは締め付け効果が最も効果的に発揮される地点に計画する。

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------
  抑止工は、構造物の抵抗によって、地すべりの抑止が図られるよう地すべりの滑動力に対して安全な構造とし、移動土塊に対して十分な効果を発揮できるように計画するものとする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------

7.  []{#_Toc67325315 .anchor}急傾斜地崩壊対策施設配置計画

    1.  []{#_Toc67325316 .anchor}総説

＜考え方＞

急傾斜地崩壊対策施設配置計画は、想定される崩壊の規模、現象等に応じて、急傾斜地の崩壊による災害の防止が図られるよう適切な施設配置となるよう計画するものとする。急傾斜地崩壊防止施設により、斜面の安定度を高めるためには、不安定土塊の除去、崩落又は滑動する力の低減、あるいは、崩落又は滑動に抵抗する力の付加が必要である。また、崩壊土砂の保全対象への到達を防止するためには、施設による崩壊土砂の捕捉が必要である。

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------
  急傾斜地崩壊対策施設配置計画は、急傾斜地崩壊対策計画に基づき、急傾斜地崩壊防止施設の配置について計画するものとする。
  ----------------------------------------------------------------------------------------------------------------------

2.  []{#_Toc67325317 .anchor}急傾斜地崩壊対策施設配置計画

    1.  []{#_Toc67325318 .anchor}総説

＜考え方＞

急傾斜地崩壊対策施設配置計画において配置する急傾斜地崩壊防止施設は、その機能の違いから、主に、斜面に対して実施する斜面の崩壊又は滑動の抑制を図る工法および斜面の崩壊又は滑動の抑止を図る工法、斜面下部で実施する崩壊土砂の保全対象への到達の防止を図る工法に分類される。これまで一般的に用いられてきた主な急傾斜地崩壊対策の工法を分類すると図のとおりである。これらの工法に加えて落石対策も実施される場合もある。

![](media/image15.png){width="5.688888888888889in" height="2.3125in"}

図3-10　急傾斜地崩壊対策工法の分類

斜面の安定度の検討、崩壊形態の想定、対策工の設計等にあたっては、下記の事項に留意する。

1．従来の経験、斜面の実態、標準的なのり面勾配との対比による安全度の検討

2．現地調査による崩壊形態の予想に基づく検討

3．安定解析による安全度の検討

> 安定解析によって定められる計画安全率については、第3-2章第7節「地すべり防止施設配置計画」に準じる。

なお、施工中においても地盤状態に注意し、計画段階で想定していない現象が確認された場合には必要に応じて速やかに計画変更の措置をとらなければならない。

また、施工段階においても、斜面の安定度を著しく減じないような対策工法を選ぶ。

＜標　準＞

+----------------------------------------------------------------------+
| 急傾斜地崩壊対策施設配置                                             |
| 計画は、想定される崩壊の規模、現象等に応じて、急傾斜地の崩壊による災 |
| 害の防止が図られるよう適切な配置となるよう計画することを基本とする。 |
|                                                                      |
| 急傾斜地崩壊対策施設配置計画においては、対象となる斜面の             |
| 地形、地質、過去の崩壊履歴、植生などから崩壊の要因と崩壊の形態を想定 |
| し、特に斜面が人家に近接していることから、十分な安定性・耐久性の確保 |
| 、施工性、周辺の環境との調和、利用形態などを考慮して、斜面の崩壊又は |
| 滑動の抑制を図る工法と構造物の抵抗によって斜面の崩壊又は滑動の抑止を |
| 図る工法、および、崩壊土砂の保全対象への到達の防止を図る工法について |
| 単独もしくは複数の工法を適切に組み合わせて計画することを基本とする。 |
+----------------------------------------------------------------------+

2.  []{#_Toc67325319 .anchor}斜面の崩壊又は滑動の抑制を図る工法

＜考え方＞

斜面の崩壊又は滑動の抑制を図る工法は、斜面の地形、地下水の状態を変化させることによって、斜面の滑動力と抵抗力のバランスを改善して、斜面の安全度を高めるか、斜面の風化・侵食を防止して斜面の安全度が下がりにくくなるように、維持管理も含めたトータルコストも考慮し、主に以下の工種を合理的に組み合わせて適切に配置するよう計画することを基本とする。

1．排水工

地表水・地下水を斜面外へ速やかに排水する。

地表水の斜面内への流入を防止する。

2．のり面保護工

のり面の風化・侵食を防止する。

3．押え盛土工

崩壊想定下部に盛り土し滑動力に抵抗する。

4．切り土工

オーバーハング部、表層の不安定土層の切り取り、浮き石の除去を行う。

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  斜面の崩壊又は滑動の抑制を図る工法は、斜面の地形、地質、地表水、地下水の状態等の自然条件を変化させることによって、斜面の安定させることが出来るように計画することを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

3.  []{#_Toc67325320 .anchor}斜面の崩壊又は滑動の抑止を図る工法

＜考え方＞

斜面の崩壊又は滑動の抑止を図る工法は、構造物のもつ抵抗力を付加することにより、斜面の安全度を高めるように、維持管理も含めたトータルコストも考慮し、主に以下の工種を単独もしくは合理的に組み合わせて適切に配置するよう計画することを基本とする。

1．切土工

雨水の作用を受けても安全であるような勾配あるいは高さまで切り取る。

2．擁壁工

崩壊を直接抑止する。

押え盛土を安定させる。

のり面保護工の基礎とする。

3．アンカー工、地山補強土工

亀裂の多い岩盤、表土層を内部の安定な岩盤に緊結する。

4．杭工

杭の曲げモーメントおよびせん断抵抗により滑動力に抵抗する。

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------
  斜面の崩壊又は滑動の抑止を図る工法は、構造物を設けることによって、斜面を安定させることができるように計画することを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------

4.  []{#_Toc67325321 .anchor}崩壊土砂の保全対象への到達の防止を図る工法

＜考え方＞

崩壊土砂の保全対象への到達の防止を図る工法は、構造物を設けることにより、斜面崩壊が発生した場合に、構造物と背後地山の間に、計画の対象とする崩壊土砂を堆積させることにより、保全対象への崩壊土砂の到達を防ぐことが出来るように、以下の工種を維持管理も含めたトータルコストも考慮して適切に配置するよう計画することを基本とする。

1．待受工

斜面下部に設置し、崩壊土砂を待ち受ける。

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  崩壊土砂の保全対象への到達の防止を図る工法は、構造物を設けることによって、斜面崩壊が発生した場合に、計画の対象とする崩壊土砂を確実に捕捉することができるように計画することを基本とする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜参考となる資料＞

> 1）全国治水砂防協会：新・斜面崩壊防止工事の設計と実例―急傾斜地崩壊防止工事技術指針,2019.

8.  []{#_Toc67325322 .anchor}雪崩対策施設配置計画

    1.  []{#_Toc67325323 .anchor}総説

＜考え方＞

雪崩対策施設配置計画の策定にあたっては、事前の調査を踏まえ、想定される雪崩の種類や発生位置、到達範囲、保全対象の状況に応じて、各施設の効果を勘案し、現地の実状に即した適切なものとする。雪崩防止施設により雪崩の発生を防止するには、斜面上の積雪移動現象(クリープ、グライド)に抵抗する力の付加が必要であり、保全対象への雪崩の到達を防止するためには、発生した雪崩を勢力分割、速度低減、雪崩方向誘導、到達阻止を行うことが必要である。

＜標　準＞

  ----------------------------------------------------------------------------------------------
  雪崩対策施設配置計画は、雪崩対策計画に基づき、雪崩防止施設の配置について計画するものとする。
  ----------------------------------------------------------------------------------------------

＜参考となる資料＞

> 1）建設省河川局砂防部監修：集落雪崩対策工事技術指針（案）,社団法人雪センター,1996.

2.  []{#_Toc67325324 .anchor}雪崩対策施設配置計画

    1.  []{#_Toc67325325 .anchor}総説

＜考え方＞

雪崩対策施設配置計画において配置する雪崩防止施設には、その機能の違いから、発生区に構造物を設置し、雪崩の発生を未然に防止する予防工と、走路もしくは堆積区に構造物を設置し、発生した雪崩から保全対象を防護する防護工がある。雪崩防止施設の配置計画は、各施設の効果を勘案し、適切に配置する。

これまで一般的に用いられてきた雪崩対策工法を分類すると図のとおりである。

![](media/image16.png){width="3.484722222222222in"
height="2.4791666666666665in"}

図3-11　雪崩対策工法の分類

雪崩防止施設は、事前の調査を基に、想定される雪崩の種類、発生位置、到達範囲、保全対象の状況に応じて、安全性、耐久性、施工性、周囲の環境などを考慮して、適切な工種を選定する。

雪崩防止工法の選定にあたっては、発生区で雪崩の発生を未然に防ぐ予防工を優先的に検討するが、必要に応じて複数の工法を適切に組み合わせて計画する。

雪崩防止施設の配置計画策定にあたっては、必要に応じ、自然環境対策、景観対策等を行うなど、周辺環境に配慮した計画とすることが望ましい。

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  雪崩対策施設配置計画は、想定される雪崩の規模、現象等に応じて、雪崩による災害の防止が図られるように適切な配置となるよう計画するとともに、雪崩の原因、形態、規模、保全対象の状況、工法の経済性等を勘案して、予防工と防護工を適切に組み合わせて工法の選定を行うことを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

2.  []{#_Toc67325326 .anchor}予防工

＜考え方＞

予防工は、斜面上の積雪移動現象(クリープ、グライド)により移動を開始することを防止する発生予防工、グライド防止工と、雪崩発生の要因である雪庇の形成を防止する雪庇予防工とに分類される。

＜標　準＞

  ----------------------------------------------------------------------------------
  予防工は、発生区に設置し、雪崩の発生の防止を目的として計画することを基本とする。
  ----------------------------------------------------------------------------------

3.  []{#_Toc67325327 .anchor}防護工

＜考え方＞

防護工は、流下してきた雪崩が保全対象に到達するのをくい止める阻止工、雪崩の勢力を分割したり、その速度を低減する減勢工、雪崩の方向を変える誘導工に分類される。

＜標　準＞

  ------------------------------------------------------------------------------------------------------
  防護工は、走路や堆積区に設置し、発生した雪崩から保全対象の防護を目的として計画することを基本とする。
  ------------------------------------------------------------------------------------------------------

9.  []{#_Toc67325328 .anchor}都市山麓グリーンベルト施設配置計画の基本

    1.  []{#_Toc67325329 .anchor}総説

＜考え方＞

都市山麓グリーンベルト施設配置計画は、都市山麓グリーンベルト整備計画に基づき、砂防指定地における緑地の保全に関する事項および必要に応じ土砂生産抑制・流送抑制等を図るための山腹保全工や砂防堰堤等の砂防設備、地すべり防止施設、急傾斜地崩壊防止施設及び管理用施設等の構造物整備に関する事項を定めるものである。施設配置を検討する際には、都市山麓グリーンベルト整備構想において定めた自然環境や景観のあり方等と整合を図るように努めなければならない。

また、砂防設備、地すべり防止施設、急傾斜地崩壊防止施設の配置にあたっては、それぞれ、第3-2章「砂防施設配置計画」、第3-2章第7節「地すべり防止施設配置計画」、および第3-2章第8節「急傾斜地崩壊対策施設配置計画」についても参照するものとする。

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  都市山麓グリーンベルト施設配置計画においては、都市山麓グリーンベルト整備計画に基づき、土砂災害の発生のおそれがある都市山麓の市街地周辺地域において、砂防指定地における緑地の保全および砂防設備、地すべり防止施設、急傾斜地崩壊防止施設等の配置について適切な施設配置となるよう計画することを基本とする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜例　示＞

植生は砂防指定地の管理という視点から重要な指標の一つであることから、砂防堰堤等の構造物整備を進めるとともに、健全な樹林を維持するための育成計画を定め、地域の緑の保全活動を行っているボランティアや企業等と連携して山腹斜面の森林整備・保全を行っている事例がある。

＜関連通知等＞

> 1）六甲山系グリーンベルトの森づくり実施要領,国土交通省近畿地方整備局六甲砂防事務所,2008.

第４章　海岸保全施設配置計画 {#第４章-海岸保全施設配置計画 .TOC-Heading}
============================

目　次 {#目-次-9 .TOC-Heading}
======

[第1節 総説 1](#_Toc12880914)

[第2節 侵食対策施設等 1](#_Toc67092512)

[2．1 総説 1](#_Toc10813350)

[2．2 漂砂制御施設と養浜の分担 1](#_Toc67092514)

[2．3 漂砂制御施設 2](#_Toc67092515)

[2．3．1 施設の選定 2](#_Toc67092516)

[2．3．2 離岸堤 3](#_Toc67092517)

[2．3．3 人工リーフ（潜堤を含む） 4](#_Toc67092518)

[2．3．4 突堤（ヘッドランド含む） 4](#_Toc67092519)

[2．4 養浜 6](#_Toc67092520)

[第3節 高潮対策施設 8](#_Toc67092521)

[3．1 総説 8](#_Toc67092522)

[3．2 堤防・護岸と消波施設の分担 8](#_Toc67092523)

[3．3 堤防・護岸 9](#_Toc67092524)

[3．3．1 堤防・護岸の型式 9](#_Toc67092525)

[3．3．2 堤防・護岸の法線 11](#_Toc67092526)

[3．3．3 堤防・護岸の表のり勾配 11](#_Toc67092527)

[3．3．4 高潮に対する必要高 12](#_Toc67092528)

[3．3．5 余裕高 12](#_Toc67092529)

[3．3．6 計画堤防・護岸高 13](#_Toc67092530)

[3．4 消波施設 13](#_Toc67092531)

[3．4．1 消波施設の形式 13](#_Toc67092532)

[3．4．2 離岸堤 14](#_Toc67092533)

[3．4．3 人工リーフ（潜堤を含む） 15](#_Toc67092534)

[3．4．4 消波工 15](#_Toc67092535)

[第4節 津波対策施設 16](#_Toc67092536)

[4．1 総説 16](#_Toc67092537)

[4．2 堤防・護岸と津波防波堤の分担 16](#_Toc67092538)

[4．3 津波に対する必要高 16](#_Toc67092539)

[4．4 津波防波堤 17](#_Toc67092540)

令和３年４月　版

適用上の位置付け

　河川砂防技術基準設計編は、基準の適用上の位置付けを明確にするために、下表に示すように適用上の位置付けを分類している。

+--------+------------------+------------------+------------------+
| 分　類 | 適用上の位置付け | 末尾の字句例     |                  |
+--------+------------------+------------------+------------------+
| 考え方 | 技術資料         | ●目              | 「･･･あ          |
|        |                  | 的や概念、考え方 | る。」「･･･いる  |
|        |                  | を記述した事項。 | 。」「･･･なる。  |
|        |                  |                  | 」「･･･れる。」  |
+--------+------------------+------------------+------------------+
| 必　須 | 技術基準         | ●法令による規定  | 「･･･なければ    |
|        |                  | や技術的観点から | ならない。」「･  |
|        |                  | 実施すべきである | ･･ものとする。」 |
|        |                  | ことが明確であり |                  |
|        |                  | 遵守すべき事項。 |                  |
+--------+------------------+------------------+------------------+
| 標　準 | 技術基準         | ●特              | 「･･･を標準      |
|        |                  | 段の事情がない限 | とする。」「･･･  |
|        |                  | り記述に従い実施 | を基本とする。」 |
|        |                  | すべきだが、状況 | 「･･･による。」  |
|        |                  | や条件によって一 |                  |
|        |                  | 律に適用すること |                  |
|        |                  | はできない事項。 |                  |
+--------+------------------+------------------+------------------+
| 推　奨 | 技術資料         | ●状況や条件      | 「               |
|        |                  | によって実施する | ･･･望ましい。」  |
|        |                  | ことが良い事項。 | 「･･･推奨する。  |
|        |                  |                  | 」「･･･務める。  |
|        |                  |                  | 」「･･･必要に応  |
|        |                  |                  | じて･･･する。」  |
+--------+------------------+------------------+------------------+
| 例　示 | 技術資料         | ●適用条件や実施  | 「･･･など        |
|        |                  | 効果について確定 | の手法（事例）が |
|        |                  | している段階では | ある。」「･･･な  |
|        |                  | ないが、状況や条 | どの場合がある。 |
|        |                  | 件によっては導入 | 」「･･･などが考  |
|        |                  | することが可能な | えられる。」「･･ |
|        |                  | 新技術等の例示。 | ･の場合には･･･こ |
|        |                  |                  | とができる。」「 |
|        |                  | ●状              | ･･･例示する。」  |
|        |                  | 況や条件によって | 「例えば･･･。」  |
|        |                  | 限定的に実施でき | 「･･･事例もある  |
|        |                  | る技術等の例示。 | 。･･･もよい。」  |
|        |                  |                  |                  |
|        |                  | ●具体的          |                  |
|        |                  | に例示することに |                  |
|        |                  | より、技術的な理 |                  |
|        |                  | 解を助ける事項。 |                  |
+--------+------------------+------------------+------------------+

  関連通知等       関連する通知やそれを理解する上で参考となる資料
  ---------------- ------------------------------------------------------
  参考となる資料   例示等に示した手法・内容を理解する上で参考となる資料

3.  

```{=html}
<!-- -->
```
11. 海岸保全施設配置計画

    1.  []{#_Toc12880914 .anchor}総説

＜標　準＞

+----------------------------------------------------------------------+
| 海岸保全施設配置計画は、海岸保全計                                   |
| 画における海岸保全施設の種類、規模及び配置を定めることを基本とする。 |
|                                                                      |
| 海岸保全施設配置計画は、海岸防護、海岸環境の整備、保全及び公衆       |
| の海岸の適正な利用の3つの目的に適合したものであることを基本とする。  |
|                                                                      |
| 海                                                                   |
| 岸保全施設配置計画においては、河川の上流から海岸までの流砂系における |
| 総合的な土砂管理の観点を踏まえ、沿岸漂砂の連続性等を考慮するとともに |
| 、砂浜の有する防護、環境、利用の機能を十分に生かすことを基本とする。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

海岸の防護・環境・利用間のトレードオフを考慮した施設配置については、下記の資料が参考となる。

1)  全国農地海岸保全協会・公益社団法人全国漁港漁場協会・一般社団法人全国海岸協会・公益社団法人日本港湾協会：海岸保全施設の技術上の基準・同解説、2018．

```{=html}
<!-- -->
```
11) 　自然共生型海岸づくり研究会編著：自然共生型海岸づくりの進め方、一般社団法人全国海岸協会、2003.

    1.  []{#_Toc67092512 .anchor}侵食対策施設等

        1.  []{#_Toc10813350 .anchor}総説

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  侵食対策施設等配置計画においては、計画海浜形状の諸元を確保し、計画海浜形状の諸元を長期的に維持するため、漂砂制御施設と養浜の分担を決定し、漂砂制御施設が所要の漂砂制御性能を発揮するための基本的な条件を決定することを基本とする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

2.  []{#_Toc67092514 .anchor}漂砂制御施設と養浜の分担

＜考え方＞

+----------------------------------------------------------------------+
| 漂砂制御施設と養浜の分担を決定する際に、将来の土砂動態               |
| を設定する必要がある。将来の土砂動態を設定するためには、海岸管理者の |
| 所掌する範囲を超え、流域・沿岸全般に及ぶ関係機関の協力が必要である。 |
|                                                                      |
| 関係機関と土砂動態の改善に向け                                       |
| た取り組みを検討するためには、過去に安定していた時期と現在の漂砂量分 |
| 布、底質の粒度組成を基に、必要な粒径集団と必要な河川からの供給土砂量 |
| を明らかにする必要がある。河川における砂利採取、河床掘削、ダムや砂防 |
| えん堤による土砂の抑止などが原因で河川からの供給土砂が減少している場 |
| 合には、流砂系における総合的な土砂管理の観点から海岸への土砂量確保対 |
| 策を検討する。河口導流堤、防波堤、埋立地など沿岸構造物が原因で沿岸漂 |
| 砂の連続性が阻害されている場合には、サンドバイパス等を検討する。漂砂 |
| 系内での土砂採取が海岸侵食の原因となっている場合には、海砂利採取地点 |
| を漂砂系外の海域や漂砂系の末端に変更する。また、航路等の浚渫土砂に含 |
| まれている汀線付近を構成する粒径集団の土砂は、基本的には海域での土砂 |
| 採取と同等の影響を海岸に与えるため、養浜材料として再利用を検討する。 |
|                                                                      |
| 海岸侵食の要因が、海底谷などの海岸地形、現在までの沿岸               |
| 構造物などの社会基盤、または過去に行われた砂利採取などの行為である場 |
| 合には、土砂動態の改善によって増加させることのできる土砂量では不足量 |
| を補うことができず、計画海浜形状の諸元を維持できない場合もある。この |
| ような場合、漂砂制御施設と養浜を組み合わせて計画海浜形状を維持する。 |
+----------------------------------------------------------------------+

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  漂砂制御施設と養浜の分担は、沿岸漂砂の不連続・変化を是正若しくは緩和するための対策を講じた上で、経済性、保全される海岸の環境・利用特性、消波効果、実現性等を考慮し設定することを基本とする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜例　示＞

+----------------------------------------------------------------------+
| 図4-1は、漂砂制御施設と養浜を組み合わせたときの漂砂量分布図          |
| を例示したものである。(a)は、元来漂砂が左から右に流れ、不均衡がない  |
| (漂砂量分布が水平)状態であったものが、沿岸構造物により漂砂が遮断され |
| たため、その下手側で漂砂が減少し不均衡が生じたために、侵食が発生して |
| いる。(b)は、減少した漂砂量に対応するように漂砂制御施設により漂砂量  |
| を減少させる計画である。この場合、漂砂制御施設整備区間の下手側で漂砂 |
| 量の不均衡が生じ侵食が発生する。その侵食に対し漂砂制御施設を整備する |
| とさらに下手側で侵食が発生するため、将来的には漂砂系全体を漂砂制御施 |
| 設で制御する必要がある。(c)は、減少した漂砂量を(動的)養浜で確保する  |
| 計画である。(d)は、漂砂制御施設と(動的)養浜を組み合わせた計画であり  |
| 、(b)の漂砂制御施設よりも施設規模を小さく、また(c)の(動的)養浜よりも |
| 養浜量を少なくできる。このように様々な選択肢が考えられ、漂砂制御施設 |
| のライフサイクル・コストと養浜事業の維持コスト、及び保全される海浜の |
| 特性に応じて、計画される地域の特性に適合する両者の組み合わせのバラン |
| スが決定される。計画期間中に一時的に計画海浜形状の諸元を維持できない |
| 場合や、計画期間の最終時点で平衡状態まで達していない場合には、(動的) |
| 養浜により一時的に土砂動態を改善することも検討することが考えられる。 |
|                                                                      |
| ![](media/image17.png){width="4.825832239720035in"                   |
| height="3.46956583552056in"}                                         |
+----------------------------------------------------------------------+

3.  []{#_Toc67092515 .anchor}漂砂制御施設

    1.  []{#_Toc67092516 .anchor}施設の選定

＜考え方＞

+----------------------------------------------------------------------+
| 漂砂制御施設には、                                                   |
| 離岸堤、人工リーフ（潜堤を含む）、突堤（ヘッドランドを含む)がある。  |
|                                                                      |
| 離岸堤・人工リ                                                       |
| ーフの漂砂制御機構は、堤体による消波、開口部からの回折波、及びそれら |
| の効果により形成されるトンボロによる沿岸漂砂量の抑制である。ただし、 |
| 沿岸漂砂の下手側へ流下する漂砂量の減少や端部での回折波等による周辺海 |
| 岸から堤体背後への土砂移動には注意を要する。突堤の漂砂制御機構は、突 |
| 堤に挟まれた海浜が流入土砂量と均衡のとれた漂砂量となる安定形状に変形 |
| し、この結果汀線後退量を制御するものである。なお、本章で扱うヘッドラ |
| ンドは、大規模な突堤を通常の突堤より間隔を空けて設置するものである。 |
+----------------------------------------------------------------------+

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------
  漂砂制御施設の選定は、必要とする漂砂制御性能、海岸環境・海岸利用への影響、経済性、施工性等を考慮して決定することを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------

＜例　示＞

+----------------------------------------------------------------------+
| 離岸堤、人工リーフの景観、海岸環境、海岸利用については、             |
| 3.4.1の例示のとおりである。ヘッドランドの景観は、設置間隔が広いので  |
| 全体としては景観への影響は少ないが、直線的な海岸が弓状の海岸に変化す |
| る。また、ヘッドランド自体は大型の構造物になるので配慮が必要となる。 |
|                                                                      |
| 経済性については                                                     |
| 、初期の建設コストのみで評価すると一般的には長大砂浜海岸ではヘッドラ |
| ンドが、ポケットビーチ(両端が岬などに囲まれており、沿岸漂砂が岬を通  |
| 過することができないため、土砂収支の閉じた漂砂系をなす弓状の海)や比  |
| 較的延長の短い海岸では離岸堤が最も有利となる。経済性の評価に当たって |
| は、基本的には海岸の防護・環境・利用などについて等価な機能を有してい |
| る構造形式で比較するとともに、ライフサイクル・コストで検討する必要が |
| ある。したがって単に初期の建設コストのみで評価するのは適当ではない。 |
|                                                                      |
| 施工性については、基礎地盤、波浪条件に左右される。軟弱地盤・均       |
| 質な細砂地盤では、堤体重量が大きくなる離岸堤は基礎対策が必要となる。 |
+----------------------------------------------------------------------+

2.  []{#_Toc67092517 .anchor}離岸堤

＜考え方＞

+----------------------------------------------------------------------+
| 離岸堤の漂砂制御効果は、天端高、天端                                 |
| 幅、設置水深、堤長、開口幅、離岸距離などの構造諸元により支配される。 |
|                                                                      |
| 離岸堤は、波に対する透過性により透過堤と不透過堤に分類される         |
| 。不透過堤は、透過堤より高い消波効果が必要とされる場合に用いられる。 |
|                                                                      |
| また、離岸堤は、平面形状により連続堤と                               |
| 不連続堤に分類される。一般的には背後のトンボロの形成を期待し、施工性 |
| の容易な透過型の不連続堤が多く用いられている。連続堤はトンボロの形成 |
| は期待できず、汀線の変化による沿岸漂砂量の低減効果はない。また、連続 |
| 堤は岸側のセットアップや海水の滞留による水質の悪化等に注意を要する。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 離岸堤の平面配置、天端高及び型式は、養浜を考                         |
| 慮して計画海浜形状の諸元が維持されるように計画することを基本とする。 |
|                                                                      |
| 離岸堤は、海岸環境、海岸利用に配慮して計画することを基本とする。     |
+----------------------------------------------------------------------+

＜関連通知等＞

1)   「海岸保全施設の技術上の基準について」の一部改正について、平成 27
    年 2 月 2 日、26農振第 1674 号、26 水港第 3079 号、国水海第 83
    号、国港海第 190 号

    （最新版）「海岸保全施設の技術上の基準について」の一部改正について、令和3年7月30日、3農振第1118号、3水港第1389号、国水海第24号、国港海第107号．

＜参考となる資料＞

離岸堤の平面配置等については、下記の資料が参考となる。

1)  全国農地海岸保全協会・公益社団法人全国漁港漁場協会・一般社団法人全国海岸協会・公益社団法人日本港湾協会：海岸保全施設の技術上の基準・同解説、2018．

    1.  []{#_Toc67092518 .anchor}人工リーフ（潜堤を含む）

＜考え方＞

+----------------------------------------------------------------------+
| 人工リーフの平面配置及                                               |
| び天端水深の決定に当たっては、波浪の低減効果とともに人工リーフ背後に |
| 循環流を形成することによる漂砂量低減効果が発揮できるように計画する。 |
|                                                                      |
| 波浪の低減効果による漂砂制御                                         |
| 効果は離岸堤と同様である。波浪減衰効果は、天端幅と天端水深で決定され |
| る。人工リーフの背後に循環流を発生させるには、離岸距離、堤長、開口幅 |
| のバランスに注意を要する。開口部を広くする場合には、高い消波効果(天  |
| 端水深を浅くする)の確保が必要となる。これによる漂砂制御効果を評価す  |
| るには、流況の変化を考慮できる3次元海浜変形モデルを用いる方法や、波  |
| 浪変形を適切に考慮した等深線変化モデルを用いる方法がある。現場で汀線 |
| の変化を見ながら開口幅、天端幅を調節し、適切な配置とする方法もある。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 人工リーフの平面配置、天端水深及び型式は、養浜を考                   |
| 慮して計画海浜形状の諸元が維持されるように計画することを基本とする。 |
|                                                                      |
| 人工リー                                                             |
| フは、海岸環境、海岸利用への影響を考慮して計画することを基本とする。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1)  「海岸保全施設の技術上の基準について」の一部改正について、平成 27 年
    2 月 2 日、26農振第 1674 号、26 水港第 3079 号、国水海第 83
    号、国港海第 190 号

    （最新版）「海岸保全施設の技術上の基準について」の一部改正について、令和3年7月30日、3農振第1118号、3水港第1389号、国水海第24号、国港海第107号．

＜参考となる資料＞

人工リーフの平面配置等については、下記の資料が参考となる。

1)  全国農地海岸保全協会・公益社団法人全国漁港漁場協会・一般社団法人全国海岸協会・公益社団法人日本港湾協会：海岸保全施設の技術上の基準・同解説、2018．

```{=html}
<!-- -->
```
12) 　国土交通省河川局海岸室、
    国土技術政策総合研究所海岸研究室監修：人工リーフの設計の手引き（改訂版）の一部改訂、(一社)全国海岸協会、2017.

    1.  []{#_Toc67092519 .anchor}突堤（ヘッドランド含む）

＜考え方＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  ヘッドランドを含む突堤の漂砂制御効果は、突堤の堤長と天端高及び設置間隔で決定される。突堤が沿岸漂砂を捕捉する効果は突堤先端の水深によって規定されることから、突堤の堤長は平面配置において重要な要素である。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 突堤の平面配置、天端高及び型式は、養浜を考                           |
| 慮して計画海浜形状の諸元が維持されるように計画することを基本とする。 |
|                                                                      |
| 突堤は、海岸環境、海岸利用に配慮して計画することを基本とする。       |
+----------------------------------------------------------------------+

＜例　示＞

+----------------------------------------------------------------------+
| 図4-2にヘッド                                                        |
| ランドの漂砂制御メカニズムを例示する。沿岸漂砂量には、波のエネルギー |
| フラックスのうち沿岸方向成分が寄与している。自然状態では、流入する漂 |
| 砂量Q。と当該箇所で発生する漂砂量Qの均衡が取れているため、汀線は安定 |
| している(図4-2(a)参照)。このような海岸において、流入する漂砂量がQ。  |
| からQへ減少した場合への対策として、ヘッドランドによって汀線をαだけ傾 |
| かせ、当該箇所で発生する漂砂量をQ。からQ1に減少させ、流入する漂砂量  |
| Q1と均衡をとるのがヘッドランド工法である(図4-2(b)参照)。ヘッドランド |
| で長大な海浜を分割することにより、各区間で安定海浜形状に変形し、汀線 |
| 後退量が分散されるために、最大の汀線後退量を小さくすることができる。 |
|                                                                      |
| ![](media/image18.png){width="5.500694444444444in"                   |
| height="1.820138888888889in"}                                        |
|                                                                      |
| 図4-3に(静的)養浜を行わない場合のヘ                                  |
| ッドランドの堤長、設置間隔、ヘッドランド間の漂砂上手側の汀線位置及び |
| ヘッドランド間に形成される汀線形状の関係を例示する。(静的)養浜を行わ |
| ない場合には、ヘッドランド間で土砂移動が発生するため漂砂上手側で汀線 |
| が後退する。許容できる後退幅が大きい(計画海浜形状が現況の海浜形状に  |
| 比べて余裕がある)ほど、ヘッドランドの間隔は広く、堤長は長いヘッドラ  |
| ンドの配置となる。一方、あるヘッドランドの間隔に対しては、そのときの |
| 汀線が計画海浜形状の諸元を満足しない場合には、(静的)養浜により計画海 |
| 浜形状の諸元を確保するとともに、必要なヘッドランドの堤長を確保する。 |
|                                                                      |
| ヘッドランドの天端高は、一般                                         |
| 的には後浜高としている例が多い。ヘッドランドの横堤部は、ヘッドランド |
| 間に発生する沿岸流がヘッドランドによって離岸流に変化し土砂が流出する |
| のを防止するとともに、遮蔽域を形成し汀線の変動を緩和する効果がある。 |
| 局部的な汀線変動を制御する補助工法として小突堤を採用する場合がある。 |
|                                                                      |
| ![](media/image19.png){width="4.657426727909011in"                   |
| height="2.655508530183727in"}                                        |
+----------------------------------------------------------------------+

＜関連通知等＞

1)  「海岸保全施設の技術上の基準について」の一部改正について、平成 27 年
    2 月 2 日、26農振第 1674 号、26 水港第 3079 号、国水海第 83
    号、国港海第 190 号

    （最新版）「海岸保全施設の技術上の基準について」の一部改正について、令和3年7月30日、3農振第1118号、3水港第1389号、国水海第24号、国港海第107号．

＜参考となる資料＞

突堤の平面配置等については、下記の資料が参考となる。

1)  全国農地海岸保全協会・公益社団法人全国漁港漁場協会・一般社団法人全国海岸協会・公益社団法人日本港湾協会：海岸保全施設の技術上の基準・同解説、2018．

    1.  []{#_Toc67092520 .anchor}養浜

＜考え方＞

+----------------------------------------------------------------------+
| 養                                                                   |
| 浜には、計画海浜形状の諸元を確保するための(静的)養浜と、流入土砂量を |
| 増加させ計画海浜形状の諸元を維持するための(動的)養浜がある。例えば、 |
| ヘッドランドの場合には、図4-4(a)に示すようにヘッドランド上手側の計画 |
| 海浜形状の汀線形状を当初に確保するために必要な養浜が(静的)養浜である |
| 。この汀線を維持するために必要な流入漂砂量は、当初の汀線形状に対して |
| 必要であった漂砂量Q0からQlに減少している。一方、(動的)養浜は、この汀 |
| 線形状を維持するために必要な沿岸漂砂量Q1に対して流入する漂砂量Qでは  |
| 不足する漂砂量ΔQ=Q1-Qを上手側で継続的に養浜で確保するものである。ま  |
| た、図4-4(b)に示すように漂砂量がQ2=Qとなるような計画海浜形状の汀線形 |
| 状をヘッドランドと(静的)養浜で形成すれば、(動的)養浜は必要なくなる。 |
|                                                                      |
| ![](media/image20.png){width="5.164178696412948in"                   |
| height="4.756162510936133in"}                                        |
|                                                                      |
| 図4-5に示すように養                                                  |
| 浜材は、養浜直後において安定形状に達するまで沖向きへ土砂が流出する。 |
|                                                                      |
| ![](media/image21.png){width="5.170470253718285in"                   |
| height="2.352347987751531in"}                                        |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 養浜は、計画海浜形状の諸元を確                                       |
| 保するために必要な（静的）養浜と、漂砂制御施設の効果を考慮して計画海 |
| 浜形状の諸元を維持するための（動的）養浜を計画することを基本とする。 |
|                                                                      |
| 養浜は                                                               |
| 、海岸の防御、環境、利用への影響を考慮して計画することを基本とする。 |
+----------------------------------------------------------------------+

＜推　奨＞

+----------------------------------------------------------------------+
| 養浜材は、波に対する安定性をふまえ、現地の砂                         |
| の粒径と同等あるいは若干大きめの粒径とすることが望ましい。また、海域 |
| の濁りの原因とならないよう、できるだけ細粒分の少ない材料が望ましい。 |
|                                                                      |
| 　（動的）養浜の量・質や場所は、海浜変形予測                         |
| 計算により計画海浜形状の諸元を維持できるか確認した上で、養浜後の海浜 |
| の状況、経済性や養浜材の入手可能性をふまえて設定することが望ましい。 |
+----------------------------------------------------------------------+

＜例　示＞

+----------------------------------------------------------------------+
| 侵食対策として養浜を検討する場合には、安定的                         |
| に供給できる運搬方法について検討を要する。サンドバイパス(図4-6(a))や |
| サンドリサイクル(図4-6(b))は、養浜材の供給手段の有効な一方策である。 |
|                                                                      |
| ![](media/image22.png){width="3.4922101924759406in"                  |
| height="5.176234689413823in"}                                        |
+----------------------------------------------------------------------+

＜関連通知等＞

1)  「海岸保全施設の技術上の基準について」の一部改正について、平成 27 年
    2 月 2 日、26農振第 1674 号、26 水港第 3079 号、国水海第 83
    号、国港海第 190 号

    （最新版）「海岸保全施設の技術上の基準について」の一部改正について、令和3年7月30日、3農振第1118号、3水港第1389号、国水海第24号、国港海第107号．

＜参考となる資料＞

養浜材の材質については、下記の資料が参考となる。

1)  全国農地海岸保全協会・公益社団法人全国漁港漁場協会・一般社団法人全国海岸協会・公益社団法人日本港湾協会：海岸保全施設の技術上の基準・同解説、2018．

    1.  []{#_Toc67092521 .anchor}高潮対策施設

        1.  []{#_Toc67092522 .anchor}総説

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  高潮対策施設配置計画においては、堤防・護岸と消波施設の分担を決定するとともに、堤防・護岸や消波施設が所要の防護機能を発揮するための基本的な条件を決定することを基本とする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------

2.  []{#_Toc67092523 .anchor}堤防・護岸と消波施設の分担

＜考え方＞

+----------------------------------------------------------------------+
| 高潮対策施設の計画においては、消波施設による波浪の減衰とともに、堤   |
| 防・護岸の斜面を遡上する際の波浪の減衰を総合的に勘案する必要がある。 |
|                                                                      |
| 一般                                                                 |
| 的に堤防はできるだけ高い方が防護効果は大きい。一方、堤防は海岸利用、 |
| 背後地の土地利用、景観等の観点からできるだけ低くすることが望まれる場 |
| 合がある。また、消波施設の分担を大きくすることで、漁場の消失、海浜地 |
| の減少を生じる場合もある。このため、堤防・護岸と消波施設の組み合わせ |
| については、海岸環境、海岸利用と十分調整した上で決定するものである。 |
|                                                                      |
| 従来、堤防・護岸と消波工によ                                         |
| る線的防護方式が多く採用されてきたが、アクセスや景観を阻害するため、 |
| 最近では堤防・護岸、沖合消波施設と養浜を組み合わせた面的防護方式が多 |
| く採用されるようになった。多くの施設を組み合わせることにより防災的に |
| も粘り強さを発揮でき有利である。堤防・護岸と消波施設を組み合わせるこ |
| とにより、防護上の目的を達成できる幾つかの対策案を策定することが可能 |
| であり、これらの対策案について経済性、海岸環境、海岸利用、社会への影 |
| 響の観点から比較を行うことで、最適な対策計画を選定することができる。 |
+----------------------------------------------------------------------+

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------
  堤防・護岸と消波施設の分担は、安全性、経済性、施工性、背後地への影響、海域への影響、海浜への影響、隣接海岸の状況を考慮し設定することを基本とする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

  ----------------------------------------------------------------------------------------------------------------
  可能な場合には、複数の海岸保全施設を組み合わせることにより海岸を保全する面的防護方式を採用することが望ましい。
  ----------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1)  「海岸保全施設の技術上の基準について」の一部改正について、平成 27 年
    2 月 2 日、26農振第 1674 号、26 水港第 3079 号、国水海第 83
    号、国港海第 190 号

    （最新版）「海岸保全施設の技術上の基準について」の一部改正について、令和3年7月30日、3農振第1118号、3水港第1389号、国水海第24号、国港海第107号．

＜参考となる資料＞

面的防護方式については、下記の資料が参考となる。

1)  全国農地海岸保全協会・公益社団法人全国漁港漁場協会・一般社団法人全国海岸協会・公益社団法人日本港湾協会：海岸保全施設の技術上の基準・同解説、2018．

    1.  []{#_Toc67092524 .anchor}堤防・護岸

        1.  []{#_Toc67092525 .anchor}堤防・護岸の型式

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  堤防・護岸の型式の選定に当たっては、所定の機能が発揮されるよう、水理条件、基礎地盤の条件、堤体土砂の確保の難易、用地取得の難易、海浜の利用、施工条件等を考慮することを基本とする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜例　示＞

+----------------------------------------------------------------------+
| 堤防・護岸の型式は、表のり勾                                         |
| 配によって直立堤、傾斜堤、混成堤の3種類に分類される。直立堤は表のり  |
| 勾配が1割未満、傾斜堤はそれ以上のものとし、3割以上のものを特に緩傾斜 |
| 堤と呼ぶ。混成堤とは、捨石マウンド等の傾斜型構造の上部にケーソンやブ |
| ロック等の直立型構造物を載せたものを呼ぶ。堤防の型式を図4-7に示す。  |
|                                                                      |
| 各型式の一般的な適合条件は次のとおりである。                         |
|                                                                      |
| 1.直立堤                                                             |
|                                                                      |
| ①基礎地盤が比較的堅固な場合                                          |
|                                                                      |
| ②堤防用地が容易に得られない場合                                      |
|                                                                      |
| 直立堤は堤内地と海岸を分断する場合が                                 |
| あり、必要に応じてアクセス性を確保するために階段工や斜路を設置する。 |
|                                                                      |
| 堤脚部が常時波浪にさらされる海岸においては、反射波の影               |
| 響により堤脚部が洗掘されるおそれがあるので、堤脚部の保護に留意する。 |
|                                                                      |
| 2.傾斜堤                                                             |
|                                                                      |
| ①基礎地盤が比較的軟弱な場合                                          |
|                                                                      |
| ②堤防用地が容易に得られる場合                                        |
|                                                                      |
| ③海浜利用の要請が高い場合                                            |
|                                                                      |
| 堤防用地は一般的に海浜に求められることが多く、海浜の一部             |
| を堤敷が覆ってしまうために、海浜、海浜植生の喪失を招くおそれがある。 |
|                                                                      |
| 堤防の構造としては、直立堤より傾斜堤の方が波力に対して有利で         |
| あるが、汀線付近において直接砂地盤に設置する場合には、侵食や波浪によ |
| る基礎地盤の変動や、反射波の影響による堤脚部の洗掘のおそれがあるので |
| 、堤脚部の保護に留意する。また、堤脚部に海藻等が繁茂して滑りやすくな |
| るため海辺へのアクセスの阻害要因となりかねないことから注意を要する。 |
|                                                                      |
| 海岸利用を目的とする場合                                             |
| は、海岸利用者の動線や斜面の利用状況に応じて傾斜堤の区間を設定する。 |
|                                                                      |
| 3.混成堤                                                             |
|                                                                      |
| ①基礎が海中となり施工が困難な場合                                    |
|                                                                      |
| ②用地が容易に得られない場合                                          |
|                                                                      |
| ③基礎地盤が余り堅固でない場合                                        |
|                                                                      |
| ![](media/image23.png){width="4.507821522309711in"                   |
| height="3.9870122484689414in"}                                       |
|                                                                      |
| 図４－７　堤防の型式                                                 |
+----------------------------------------------------------------------+

＜関連通知等＞

1)  「海岸保全施設の技術上の基準について」の一部改正について、平成 27 年
    2 月 2 日、26農振第 1674 号、26 水港第 3079 号、国水海第 83
    号、国港海第 190 号.

    （最新版）「海岸保全施設の技術上の基準について」の一部改正について,令和3年7月30日,3農振第1118号,3水港第1389号,国水海第24号,国港海第107号．

＜参考となる資料＞

堤防・護岸の型式については、下記の資料が参考となる。

1)  全国農地海岸保全協会・公益社団法人全国漁港漁場協会・一般社団法人全国海岸協会・公益社団法人日本港湾協会：海岸保全施設の技術上の基準・同解説、2018．

    1.  []{#_Toc67092526 .anchor}堤防・護岸の法線

＜考え方＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  海岸の地形は、波浪条件、土砂供給条件など自然条件で均衡がとれた形状を呈しているので、堤防・護岸の法線はこの形状と平行であれば海岸への影響が少なく、波浪の集中などは発生しにくい。逆に、堤内地の土地利用のために海浜地形にそぐわない法線を設定すると、堤防を境界とした海浜の変形が発生し、砂浜の消失、波浪の集中が生じることがある。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  法線の決定に当たっては、所定の機能が発揮されるよう、波の収れん、地形・地質・潮位等を考慮した施工条件、近傍の土地利用状況、竣工後の維持管理、水防、内水排除、海浜の利用、隣接構造物との関係、海浜地形への影響を考慮することを基本とする。また、海浜の地形に沿った滑らかな形状とすることを基本とする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  堤防の堤脚部が海中に没する場合には、常時波浪の影響を受け反射波による洗掘のおそれがあるため、堤脚部の保護に留意するとともに、法線を堤内地側へ引くことも検討することが望ましい。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1)  「海岸保全施設の技術上の基準について」の一部改正について、平成 27 年
    2 月 2 日、26農振第 1674 号、26 水港第 3079 号、国水海第 83
    号、国港海第 190 号

    （最新版）「海岸保全施設の技術上の基準について」の一部改正について,令和3年7月30日,3農振第1118号,3水港第1389号,国水海第24号,国港海第107号．

＜参考となる資料＞

堤防・護岸の法線については、下記の資料が参考となる。

1)  全国農地海岸保全協会・公益社団法人全国漁港漁場協会・一般社団法人全国海岸協会・公益社団法人日本港湾協会：海岸保全施設の技術上の基準・同解説、2018．

    1.  []{#_Toc67092527 .anchor}堤防・護岸の表のり勾配

＜考え方＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  堤防の表のり勾配を緩くすることにより、海浜へのアクセス性が向上するとともに、うちあげ高が減少して、堤防天端高を低くすることが可能であるが、堤敷が広くなり、海浜の消失につながる場合もある。また、堤防のり尻が海中に没すると、常時反射波が発生し、洗掘の可能性が高くなるとともに、のり尻部に海藻が繁茂し、滑りやすくなるため海辺へのアクセスを阻害することになるので、のり尻の位置に注意して表のり勾配を設定する必要がある。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------
  表のり勾配は、堤防・護岸の型式の決定に伴い、堤体の安定性、水理条件、海浜の利用状況、土質、地形条件等を考慮して設定することを基本とする。
  ------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1)  「海岸保全施設の技術上の基準について」の一部改正について、平成 27 年
    2 月 2 日、26農振第 1674 号、26 水港第 3079 号、国水海第 83
    号、国港海第 190 号

    （最新版）「海岸保全施設の技術上の基準について」の一部改正について,令和3年7月30日,3農振第1118号,3水港第1389号,国水海第24号,国港海第107号．

＜参考となる資料＞

堤防・護岸の表のり勾配については、下記の資料が参考となる。

1)  全国農地海岸保全協会・公益社団法人全国漁港漁場協会・一般社団法人全国海岸協会・公益社団法人日本港湾協会：海岸保全施設の技術上の基準・同解説、2018．

    1.  []{#_Toc67092528 .anchor}高潮に対する必要高

＜標　準＞

+----------------------------------------------------------------------+
| 高潮に対する必                                                       |
| 要高は、計画潮位と計画波浪に対する必要高の和とすることを基本とする。 |
|                                                                      |
| 計画波浪に対する必要高は                                             |
| 、計画海浜形状の諸元を有する海浜に計画潮位以下の潮位、計画波浪以下の |
| 波浪が作用した時のうちあげ高または許容量以下の越波量から求まる必要な |
| 高さを、消波施設の効果を考慮して求め、適切に定めることを基本とする。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1)  「海岸保全施設の技術上の基準について」の一部改正について、平成 27 年
    2 月 2 日、26農振第 1674 号、26 水港第 3079 号、国水海第 83
    号、国港海第 190 号

    （最新版）「海岸保全施設の技術上の基準について」の一部改正について,令和3年7月30日,3農振第1118号,3水港第1389号,国水海第24号,国港海第107号．

＜参考となる資料＞

うちあげ高及び越波量の算定方法については、下記の資料が参考となる。

1)  全国農地海岸保全協会・公益社団法人全国漁港漁場協会・一般社団法人全国海岸協会・公益社団法人日本港湾協会：海岸保全施設の技術上の基準・同解説、2018．

    1.  []{#_Toc67092529 .anchor}余裕高

＜標　準＞

  --------------------------------------------------------------
  堤防・護岸には、必要に応じて余裕高を設けることを基本とする。
  --------------------------------------------------------------

＜例　示＞

  ----------------------------------------------------------------------------------------------------------------------------------------
  背後地に市街地または重要な公共施設等が存在して，高い安全性を要する場合には，最大1.0m程度を限度として余裕高が適宜決定されることが多い．
  ----------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1)  「海岸保全施設の技術上の基準について」の一部改正について、平成 27 年
    2 月 2 日、26農振第 1674 号、26 水港第 3079 号、国水海第 83
    号、国港海第 190 号

    （最新版）「海岸保全施設の技術上の基準について」の一部改正について,令和3年7月30日,3農振第1118号,3水港第1389号,国水海第24号,国港海第107号．

＜参考となる資料＞

余裕高の設定方法については、下記の資料が参考となる。

1)  全国農地海岸保全協会・公益社団法人全国漁港漁場協会・一般社団法人全国海岸協会・公益社団法人日本港湾協会：海岸保全施設の技術上の基準・同解説、2018．

    1.  []{#_Toc67092530 .anchor}計画堤防・護岸高

＜考え方＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  堤防・護岸の天端高は、計画海浜形状の諸元、消波施設の規模、及び堤防・護岸の表のり勾配で変化し、これらの組み合わせで多くの選択肢が存在する。一般には消波施設等の規模を大きくするほど、堤防・護岸の天端高を低くすることができ、景観や海岸利用には有利であるが、費用が増大する。一方、堤防の天端高が高くなると海岸利用や周辺の生活環境の悪化をもたらす。また、一連の堤防の天端高が消波施設等の計画で変化することは地域住民に対して心理的に好ましくない。このため、地域の状況を総合的に判断して一連の海岸について堤防の天端高を設定する。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 計画堤                                                               |
| 防・護岸高は高潮に対する必要高を前提として設定することを基本とする。 |
|                                                                      |
| 計画堤防・護岸高は、経済性、背後地の土地利用状況、海                 |
| 岸利用状況、隣接の堤防・護岸高などを考慮して定めることを基本とする。 |
+----------------------------------------------------------------------+

＜推　奨＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------
  海岸防護上必要な堤防・護岸の天端高が、社会・経済上受け入れられない場合には、計画海浜形状の諸元、消波施設、消波工の有無について再検討することが望ましい。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1)  「海岸保全施設の技術上の基準について」の一部改正について、平成 27 年
    2 月 2 日、26農振第 1674 号、26 水港第 3079 号、国水海第 83
    号、国港海第 190 号

    （最新版）「海岸保全施設の技術上の基準について」の一部改正について,令和3年7月30日,3農振第1118号,3水港第1389号,国水海第24号,国港海第107号．

＜参考となる資料＞

堤防・護岸高の設定方法については、下記の資料が参考となる。

1)  全国農地海岸保全協会・公益社団法人全国漁港漁場協会・一般社団法人全国海岸協会・公益社団法人日本港湾協会：海岸保全施設の技術上の基準・同解説、2018．

    1.  []{#_Toc67092531 .anchor}消波施設

        1.  []{#_Toc67092532 .anchor}消波施設の形式

＜考え方＞

+----------------------------------------------------------------------+
| 消波施設の形式には、消波工、離岸堤、人工リーフ（潜堤を含む）がある。 |
|                                                                      |
| 消波施設の消                                                         |
| 波効果は、消波施設前面の波高に対する透過後の波高の比である透過率で表 |
| 現され、透過後の波高を再度沖波波高に換算してうちあげ高の計算を行う。 |
|                                                                      |
| 消波施設の規模を大きくすると、                                       |
| 相対的に堤防・護岸への負担が軽減され、海岸へのアクセスや周辺への影響 |
| は小さくなる。しかし、海岸環境、海岸利用への負担を増加させ、一般的に |
| はコスト的にも不利となる場合が多いので、総合的に判断する必要がある。 |
|                                                                      |
| また、消波施                                                         |
| 設の基盤となる海底地盤が、侵食により低下すると、消波効果が低下し防災 |
| 上の目的を達成できなくなるので、侵食の程度についても併せて検討する。 |
+----------------------------------------------------------------------+

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------
  消波施設は、必要とする消波効果、海岸環境（海岸景観を含む）・海岸利用への影響、経済性、施工性等を考慮して選定することを基本とする。
  ------------------------------------------------------------------------------------------------------------------------------------

＜例　示＞

+----------------------------------------------------------------------+
| 消波工は、のり面                                                     |
| 前面での反射、堤体内を通過するときの乱れによる波浪エネルギーの減衰、 |
| のり面の粗度による波のうちあげ高の減殺などにより消波効果を発揮する。 |
|                                                                      |
| 離岸堤は、入射波の一部が反射され、また堤体を通過する際に             |
| 波のエネルギーが減殺されることにより消波効果が発揮される。また、開口 |
| 部より進入する波は回折によりそのエネルギーが分散され波高が低下する。 |
|                                                                      |
| 人工リーフは、沖側のり面上又は天端上における砕波や、砕波後の波が水   |
| 深の小さな天端上を通過する際のエネルギー逸散により波高を低下させる。 |
|                                                                      |
| 景観については                                                       |
| 、人工リーフは、没水型の消波施設であるために景観を悪化させることがな |
| いが、消波工、離岸堤は天端が常に水面上にあるため、特に消波工やブロッ |
| ク式離岸堤では景観の悪化が問題となることがある。離岸堤については、従 |
| 来の離岸堤よりも景観に優れた有脚式の新型離岸堤なども開発されている。 |
|                                                                      |
| 海岸環境については、人                                               |
| 工リーフは浅場の創出により藻場が形成され、生物の生息・生育空間を創出 |
| する場合もある。また、離岸堤は岩礁性の生物の生息・生育空間を形成する |
| 場合もある。海岸保全施設が生態系に及ぼす影響は、未解明な部分が多いの |
| で、建設後の適切なモニタリングで海岸環境の変化を把握する必要がある。 |
|                                                                      |
| 海岸利用については、人工リーフは堤敷が広くかつ水深が浅いの           |
| で、船舶の通行、漁業に支障を及ぼすおそれがあるので注意を要する。離岸 |
| 堤は海面利用が制限される。また、消波工は海浜へのアクセスを阻害する。 |
|                                                                      |
| 経済性については、初期の建設コストのみで評価すると一                 |
| 般的には離岸堤が最も有利となる。経済性の評価に当たっては、基本的には |
| 海岸の防護・環境・利用について等価な機能を有している構造形式で比較す |
| るとともに、ライフサイクル・コストを含めて、総合的に検討する必要があ |
| る。したがって、単に初期の建設コストのみで評価するのは適当ではない。 |
|                                                                      |
| 施工性については、                                                   |
| 基礎地盤、波浪条件に左右される。例えば、軟弱地盤や均質な細砂地盤では |
| 、堤体重量が大きくなる離岸堤を選定する場合には基礎対策が必要となる。 |
+----------------------------------------------------------------------+

2.  []{#_Toc67092533 .anchor}離岸堤

＜考え方＞

+----------------------------------------------------------------------+
| 離岸堤の消波効果は、天端高、天端                                     |
| 幅、設置水深、堤長、開口幅、離岸距離などの構造諸元により支配される。 |
|                                                                      |
| また、離岸堤の分類は、2.3.2の通りである。                            |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 離岸堤の平面配置、天端高                                             |
| 及び型式は、計画海浜形状の諸元を有する海浜に計画潮位、計画波浪が作用 |
| したとき、所要の消波効果が確保されるように決定することを基本とする。 |
|                                                                      |
| 離岸堤は、汀線の変形、                                               |
| 流況、海岸環境、海岸利用への影響を考慮して計画することを基本とする。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1)  「海岸保全施設の技術上の基準について」の一部改正について、平成 27 年
    2 月 2 日、26農振第 1674 号、26 水港第 3079 号、国水海第 83
    号、国港海第 190 号

    （最新版）「海岸保全施設の技術上の基準について」の一部改正について,令和3年7月30日,3農振第1118号,3水港第1389号,国水海第24号,国港海第107号．

＜参考となる資料＞

離岸堤の平面配置等については、下記の資料が参考となる。

1)  全国農地海岸保全協会・公益社団法人全国漁港漁場協会・一般社団法人全国海岸協会・公益社団法人日本港湾協会：海岸保全施設の技術上の基準・同解説、2018．

    1.  []{#_Toc67092534 .anchor}人工リーフ（潜堤を含む）

＜考え方＞

+----------------------------------------------------------------------+
| 人工リーフの消波効                                                   |
| 果は、天端水深、天端幅、堤脚水探、開口幅などの諸元により支配される。 |
|                                                                      |
| 人工リーフ上では、                                                   |
| 入射波が強制砕波されるため平均水位が上昇する。水位上昇量は入射波高に |
| 比べて天端水深が浅いほど大きくなり、人工リーフの岸側で入射波高の10～ |
| 20%平均水位が上昇する。うちあげ高には、岸側の水位上昇量を考慮する。  |
|                                                                      |
| 人工リーフの平                                                       |
| 面配置は、堤体を連続とし沿岸方向に波高分布を生じさせないことが望まし |
| いが、開ロ部を設けた場合の方が平均水位の上昇を抑制できる場合がある。 |
| この場合でも開口幅は、背後の波高が高くならないようにする必要がある。 |
|                                                                      |
| 人工リーフの基本型を定める際にはこれら諸元間の相互関係に十分配慮し、 |
| 全体として効率良く所定の消波機能が発揮されるよう検討する必要がある。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 人工リーフの平面配置、天端水深                                       |
| 及び型式は、計画海浜形状の諸元を有する海浜に計画潮位、計画波浪が作用 |
| したとき、所要の消波効果が確保されるように決定することを基本とする。 |
|                                                                      |
| 人工リーフは、流況、汀線の                                           |
| 変動、海岸環境、海岸利用への影響を考慮して計画することを基本とする。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1)  「海岸保全施設の技術上の基準について」の一部改正について、平成 27 年
    2 月 2 日、26農振第 1674 号、26 水港第 3079 号、国水海第 83
    号、国港海第 190 号

    （最新版）「海岸保全施設の技術上の基準について」の一部改正について,令和3年7月30日,3農振第1118号,3水港第1389号,国水海第24号,国港海第107号．

＜参考となる資料＞

人工リーフの平面配置等については、下記の資料が参考となる。

1)  全国農地海岸保全協会・公益社団法人全国漁港漁場協会・一般社団法人全国海岸協会・公益社団法人日本港湾協会：海岸保全施設の技術上の基準・同解説、2018．

```{=html}
<!-- -->
```
13) 　 国土交通省河川局海岸室、
    国土技術政策総合研究所海岸研究室監修：人工リーフの設計の手引き（改訂版）の一部改訂、(一社)全国海岸協会、2017

    1.  []{#_Toc67092535 .anchor}消波工

＜考え方＞

+----------------------------------------------------------------------+
| 消波工の                                                             |
| 消波効果は、天端幅、水面上高、設置水深などの構造諸元によって定まる。 |
|                                                                      |
| 消波工は、海岸へのアクセスを阻害するとともに、海岸景観、海岸環境を   |
| 損なうため極力採用しない。しかし、そのほかの消波施設を採用することが |
| 経済的・社会的に困難な場合には、堤防天端高を低くするために採用する。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 消波                                                                 |
| 工の断面は、計画海浜形状の諸元を有する海浜に計画潮位、計画波浪が作用 |
| したとき、所要の消波効果が確保されるように決定することを基本とする。 |
|                                                                      |
| 消波                                                                 |
| 工は、海岸環境、海岸利用への影響を考慮して計画することを基本とする。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1)  「海岸保全施設の技術上の基準について」の一部改正について、平成 27 年
    2 月 2 日、26農振第 1674 号、26 水港第 3079 号、国水海第 83
    号、国港海第 190 号

    （最新版）「海岸保全施設の技術上の基準について」の一部改正について,令和3年7月30日,3農振第1118号,3水港第1389号,国水海第24号,国港海第107号．

＜参考となる資料＞

消波工の断面については、下記の資料が参考となる。

1)  全国農地海岸保全協会・公益社団法人全国漁港漁場協会・一般社団法人全国海岸協会・公益社団法人日本港湾協会：海岸保全施設の技術上の基準・同解説、2018．

    1.  []{#_Toc67092536 .anchor}津波対策施設

        1.  []{#_Toc67092537 .anchor}総説

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  津波対策施設配置計画においては、海岸環境、海岸利用に配慮しつつ、堤防・護岸と津波防波堤の分担を決定するとともに、堤防・護岸や津波防波堤が所要の防護性能を発揮するための基本的な条件を決定することを基本とする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

2.  []{#_Toc67092538 .anchor}堤防・護岸と津波防波堤の分担

＜考え方＞

+----------------------------------------------------------------------+
| 計画津波が大きい場合、堤防のみでこれを防護しよ                       |
| うとすると天端高が非常に高くなり、海浜へのアクセスを阻害したり、背後 |
| 地の生活環境を悪化させるなど、受容の範囲を越えてしまうおそれがある。 |
| こうした場合には、津波防波堤と組み合わせ、堤防の天端高を低く抑える。 |
|                                                                      |
| 津波防波堤は、湾口部が狭く湾内                                       |
| の海岸線が長く堤防の整備に多大な費用を要する場合には検討する価値があ |
| る。ただし、湾内の海水交換が阻害されるので水質の悪化に注意を要する。 |
+----------------------------------------------------------------------+

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------
  堤防・護岸と津波防波堤の分担は、安全性、経済性、施工性、背後地への影響、海域への影響、海浜への影響、隣接海岸の状況を考慮し設定することを基本とする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------

3.  []{#_Toc67092539 .anchor}津波に対する必要高

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------
  津波に対する必要高は、計画海浜形状の諸元を有する海浜に計画津波が作用したときの水位を、津波防波堤の効果を考慮して求め、適切に設定することを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1)  「海岸保全施設の技術上の基準について」の一部改正について、平成 27 年
    2 月 2 日、26農振第 1674 号、26 水港第 3079 号、国水海第 83
    号、国港海第 190 号

    （最新版）「海岸保全施設の技術上の基準について」の一部改正について,令和3年7月30日,3農振第1118号,3水港第1389号,国水海第24号,国港海第107号．

```{=html}
<!-- -->
```
14) 　設計津波の水位の設定方法等について、平成23年7月8日、農林水産省農村振興局整備部防災課長、水産庁漁港漁場整備部防災漁村課長、国土交通省水管理、国土保全局砂防部保全課海岸室長、国土交通省港湾局海岸・防災課長

＜参考となる資料＞

津波に対する必要高の設定方法については、下記の資料が参考となる。

1)  全国農地海岸保全協会・公益社団法人全国漁港漁場協会・一般社団法人全国海岸協会・公益社団法人日本港湾協会：海岸保全施設の技術上の基準・同解説、2018．

    1.  []{#_Toc67092540 .anchor}津波防波堤

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------
  津波防波堤の法線、開口部の水深及び幅、型式は、計画津波が作用したとき、所要の消波効果が確保されるように決定することを基本とする。
  ----------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1)  「海岸保全施設の技術上の基準について」の一部改正について、平成 27 年
    2 月 2 日、26農振第 1674 号、26 水港第 3079 号、国水海第 83
    号、国港海第 190 号

    （最新版）「海岸保全施設の技術上の基準について」の一部改正について,令和3年7月30日,3農振第1118号,3水港第1389号,国水海第24号,国港海第107号．

＜参考となる資料＞

津波防波堤の法線等については、下記の資料が参考となる。

1)  全国農地海岸保全協会・公益社団法人全国漁港漁場協会・一般社団法人全国海岸協会・公益社団法人日本港湾協会：海岸保全施設の技術上の基準・同解説、2018．

**施設配置等計画編**

5.  **情報システムの整備**

**目　次**

[第1節 総説 1](#_Toc167464732)

令和６年６月　版

適用上の位置付け

> 河川砂防技術基準計画編は、基準の適用上の位置付けを明確にするために、下表に示すように適用上の位置付けを分類している。

+--------+------------------+------------------+------------------+
| 分　類 | 適用上の位置付け | 末尾の字句例     |                  |
+--------+------------------+------------------+------------------+
| 考え方 | 技術資料         | ●目              | 「･･･ある。      |
|        |                  | 的や概念、考え方 | 」「･･･いる。」  |
|        |                  | を記述した事項。 |                  |
|        |                  |                  | 「･･･なる。      |
|        |                  |                  | 」「･･･れる。」  |
+--------+------------------+------------------+------------------+
| 必　須 | 技術基準         | ●法令による規定  | 「･･･なければ    |
|        |                  | や技術的観点から | ならない。」「･  |
|        |                  | 実施すべきである | ･･ものとする。」 |
|        |                  | ことが明確であり |                  |
|        |                  | 遵守すべき事項。 |                  |
+--------+------------------+------------------+------------------+
| 標　準 | 技術基準         | ●特              | 「･･･            |
|        |                  | 段の事情がない限 | を標準とする。」 |
|        |                  | り記述に従い実施 |                  |
|        |                  | すべきだが、状況 | 「･･･            |
|        |                  | や条件によって一 | を基本とする。」 |
|        |                  | 律に適用すること |                  |
|        |                  | はできない事項。 | 「･･･による。」  |
+--------+------------------+------------------+------------------+
| 推　奨 | 技術資料         | ●状況や条件      | 「               |
|        |                  | によって実施する | ･･･望ましい。」  |
|        |                  | ことが良い事項。 |                  |
|        |                  |                  | 「               |
|        |                  |                  | ･･･推奨する。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･努める。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･必要に応    |
|        |                  |                  | じて･･･する。」  |
+--------+------------------+------------------+------------------+
| 例　示 | 技術資料         | ●適用条件や実施  | 「               |
|        |                  | 効果について確定 | ･･･などの手法（  |
|        |                  | している段階では | 事例）がある。」 |
|        |                  | ないが、状況や条 |                  |
|        |                  | 件によっては導入 | 「･･･など        |
|        |                  | することが可能な | の場合がある。」 |
|        |                  | 新技術等の例示。 |                  |
|        |                  |                  | 「･･･など        |
|        |                  | ●状              | が考えられる。」 |
|        |                  | 況や条件によって |                  |
|        |                  | 限定的に実施でき | 「               |
|        |                  | る技術等の例示。 | ･･･の場合には･･･ |
|        |                  |                  | ことができる。」 |
|        |                  | ●具体的          |                  |
|        |                  | に例示することに | 「               |
|        |                  | より、技術的な理 | ･･･例示する。」  |
|        |                  | 解を助ける事項。 |                  |
|        |                  |                  | 「例えば･･･。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･事例もある  |
|        |                  |                  | 。･･･もよい。」  |
+--------+------------------+------------------+------------------+

  関連通知等       関連する通知やそれを理解する上で参考となる資料
  ---------------- ------------------------------------------------------
  参考となる資料   例示等に示した手法・内容を理解する上で参考となる資料

3.  情報システムの整備

    1.  []{#_Toc167464732 .anchor}総説

＜考え方＞

+----------------------------------------------------------------------+
| 調査編第                                                             |
| 1章1.7「調査結果等の活用」にて「Data-Information-Knowledge-Wisdomモ  |
| デル」を用いて整理した「データ～情報～知識～知恵にまたがる調査結果等 |
| の活用の俯瞰」を踏まえながら、本章では、調査編第23章で示した調査結果 |
| 等を河川等の管理者や自治体・住民らが活用できるようにするための情報シ |
| ステムのあり方について記載している。ここで、「情報システム」とは、上 |
| 記の目的のため、情報通信技術を利用して処理が行われるシステムを指す。 |
|                                                                      |
| １）情報システムの整備の必要性                                       |
|                                                                      |
| 情報システムは、河川等の計画、設計及び維                             |
| 持管理等の円滑な遂行及び国民への適切な情報の共有のために必要である。 |
|                                                                      |
| 特に近年の政府・国土交通省で                                         |
| の情報システムの整備の必要性に関する技術的・政策的背景を下記に示す。 |
|                                                                      |
| > ａ）水災害に対する知見や情報を社会で共有                           |
| >                                                                    |
| > 気候変動の影響や社会状況の変化など                                 |
| を踏まえ、河川の流域のあらゆる関係者が協働して流域全体で行う治水対策 |
| 「流域治水」の取組が進んでいる。流域治水を推進するためには、水災害に |
| 関する知見や情報を社会で共有し持続的に蓄積していくことが重要である。 |
| >                                                                    |
| > 他方、情報分野では、5Gなど情                                       |
| 報通信技術の活用、IoT、人工衛星やドローンなどの新たな手段による情報  |
| の入手と、AI技術を活用したビッグデータの情報処理など、進展が著しい。 |
| >                                                                    |
| > これら新しい技術を取り入れつつ、流域の全員が協働                   |
| して水災害対策に取り組んでいくプラットフォームを構築し、その中でそれ |
| ぞれが水災害に関する知見や情報を共有・活用していくことが必要である。 |
| >                                                                    |
| > ｂ）情報通信技術の進展を踏まえた対応                               |
| >                                                                    |
| > Society                                                            |
| > 5.0※の実現の重要性を踏                                             |
| まえ、国土交通省として社会資本整備分野のデジタル化・スマート化による |
| 、インフラや公共サービスの変革、働き方改革・生産性向上等が進められて |
| いるなか、河川、砂防、地すべり、急傾斜地、雪崩及び海岸の計画、設計及 |
| び維持管理等においても情報システムの整備を一層加速させる必要がある。 |
| >                                                                    |
| > ※                                                                  |
| 政府の「第6期科学技術・イノベーション基本計画（2021年3月26日閣議決定 |
| ）」において「直面する脅威や先の見えない不確実な状況に対し、持続可能 |
| 性と強靱性を備え、国民の安全と安心を確保するとともに、一人ひとりが多 |
| 様な幸せ（well-being）を実現できる社会」と表現された、目指すべき未来 |
| 社会の姿。その実現のためには、「サイバー空間とフィジカル空間の融合に |
| よる持続可能で強靱な社会への変革」が必要なものと位置づけられている。 |
|                                                                      |
| ２）常時と非常時の情報システムの整備について                         |
|                                                                      |
| 情報システムには、常時のシス                                         |
| テム（日常業務において主として蓄積データを活用したもの）と非常時のシ |
| ステム（災害時において主としてリアルタイムデータとそれを基にした予測 |
| 情報を活用するもの）があるが、それぞれに求められる観点を下記に示す。 |
|                                                                      |
| ａ）常時                                                             |
|                                                                      |
| > 河川管理等の高度化や省力                                           |
| 化等を円滑に推進するため、常時から情報システムを通じ河川等の管理者が |
| 河道や施設の点検記録などを利用できるようにしておくことが重要である。 |
| >                                                                    |
| > また、河川                                                         |
| 等には市民団体活動やイベント、環境教育のフィールドとしての役割があり |
| 、水位・水質、河川環境、利用状況など日常的な河川等の現況と過去データ |
| を提供することにより多様な国民活動に役立ててもらうことが重要である。 |
| >                                                                    |
| > さらに、災害時における避難・水防活動                               |
| 等が円滑に行われるよう、日頃から情報システムを通じ浸水想定区域図や各 |
| 種ハザードマップ等の情報を国民が閲覧できるようにしておく必要がある。 |
| >                                                                    |
| > これらのシステムは、提供するデータを継続的に更                     |
| 新し続けること、利用者が利用しやすいシステムとすることが求められる。 |
|                                                                      |
| ｂ）非常時                                                           |
|                                                                      |
| > 災害時における被害軽減という視点                                   |
| では、水位や雨量の実況情報、洪水や土砂災害等の予測情報などを迅速かつ |
| 的確に把握し、国民及び関係機関と共有できるシステムとする必要がある。 |
| >                                                                    |
| > さらには、災害に                                                   |
| 伴うシステムトラブル等により、実況情報や予測情報など国民の安全への影 |
| 響度が大きい情報が伝達できなくなることがないよう、冗長性を確保するな |
| どして、非常時においても確実な運用が可能なシステムとする必要がある。 |
|                                                                      |
| ３）情報システムの整備に考慮すべき事項                               |
|                                                                      |
| 品質・コスト・スピードのバランスがとれた情報シ                       |
| ステムに向けて、デジタル庁が検討している政府共通の機能（ガバメントク |
| ラウド、ガバメントソリューションサービスなど※）を最大限活用する。そ  |
| の上で、情報システムの整備に当たって以下に示す項目について考慮する。 |
|                                                                      |
| > ※ガバメントクラウド･･･政府共通のクラウドサービスの利用             |
| 環境。クラウドサービスの利点を最大限に活用することで、迅速、柔軟、か |
| つセキュアでコスト効率の高いシステムを構築可能とし、利用者にとって利 |
| 便性の高いサービスをいち早く提供し改善していくことを目標としている。 |
| >                                                                    |
| > 　ガバメントソリュ                                                 |
| ーションサービス･･･政府共通の標準的な業務実施環境（業務用PCやネット  |
| ワーク環境）の提供を行うサービス。最新技術を採用し、各府省庁の環境の |
| 統合を順次進めることで、行政機関の生産性やセキュリティの向上を図る。 |
|                                                                      |
| ａ）データ・情報の連携                                               |
|                                                                      |
| > 広く多様なデータを                                                 |
| 活用して新たな価値を創出し、河川等の計画、設計及び維持管理等の適切な |
| 遂行と高度化を実現するためには、データ連携基盤等の構築が重要となる。 |
| >                                                                    |
| > 情報システムにおけるデー                                           |
| タ連携の推進に当たっては、次の事項について考慮することが考えられる。 |
|                                                                      |
| -   データ                                                           |
| の利活用や管理が効率的に行われるようにするためのデータ品質の確保。\  |
|     例えば、「データ品質管理ガイドブック」（＜参考となる資料＞       |
|     5））を適用し、データ品質管理フ                                  |
| レームワークと評価モデルを用いて品質評価及び品質向上策の検討を行う。 |
|                                                                      |
| -   国民参加・官民協働を推進するための作成したデータの公開           |
|                                                                      |
| > 公共データを公開するに当たっては、「オープンデータ                 |
| 基本指針」に示される基本的ルールに沿うものとする（＜参考となる資料＞ |
| > 3））。公費で作られたデータは                                      |
| 、国民の権利利益、国の安全等が害されることがない限り原則として民間に |
| 提供していくオープン・バイ・デフォルトの考え方に基づき、ニーズの高い |
| ものから、情報システムの新規整備・更改の際にAPIを公開又は提供する。  |
|                                                                      |
| ｂ）利用規約の明示                                                   |
|                                                                      |
| > 情報システムを通じた調査結果等の公                                 |
| 開に当たっては、免責事項を含む利用規約を明示する。利用規約の設定に当 |
| たっては、「政府標準利用規約（第2.0版）の解説」（＜参考となる資料＞  |
| > 6））を参考とする。                                                |
|                                                                      |
| ｃ）情報システムの維持管理                                           |
|                                                                      |
| > 調査結果等が                                                       |
| 適切に保存され、有効に活用されるよう、適切な情報管理体制を構築する必 |
| 要がある。維持管理の方針については社会情勢の変化や技術の進展を考慮し |
| て定期的な見直しを行い、必要に応じて施設やシステムの更新を実施する。 |
|                                                                      |
| ｄ）サイバーセキュリティ                                             |
|                                                                      |
| > 社会全体のデジタルトランスフォーメ                                 |
| ーションが加速し、我々を取り巻く様々な分野においてデジタル技術の利活 |
| 用が進んでいる。他方、サイバー攻撃はその発生頻度の増加と高度化が続く |
| 状況下にあり、サイバーセキュリティ対策のさらなる強化が不可欠である。 |
| >                                                                    |
| > 情報システムのサイバーセキュリティ対策については、全ての政         |
| 府機関等において共通的に必要とされるセキュリティ対策である「政府機関 |
| 等のサイバーセキュリティ対策のための統一基準群」（＜参考となる資料＞ |
| > 8））を前提のものとして実施、推進する。                            |
+----------------------------------------------------------------------+

＜関連通知等＞

1)  気候変動を踏まえた水災害対策のあり方について～あらゆる関係者が流域全体で行う持続可能な「流域治水」への転換～答申，令和2年7月，社会資本整備審議.

```{=html}
<!-- -->
```
9)  令和5年版 国土交通白書，令和5年8月，国土交通省.

    （最新版）令和6年版 国土交通白書，令和6年6月28日，国土交通省.

10) デジタル社会の実現に向けた重点計画に基づく国土交通省における中長期計画，令和5年1月，国土交通省情報化政策委員会決定.

11) 電気通信施設設計要領（情報通信システム編），令和3年3月，国土交通省大臣官房技術調査課電気通信室.

12) 電気通信施設維持管理計画指針（案），令和4年3月，国土交通省大臣官房技術調査課電気通信室.

＜参考となる資料＞

> 関係省庁のデジタル分野の動向や政策的背景、省横断的連携の主軸となるデジタル庁の施策方針には、下記資料が参考となる。

1)  デジタル社会の実現に向けた重点計画，令和5年6月9日，閣議決定.

    （最新版）デジタル社会の実現に向けた重点計画，令和6年6月21日，閣議決定.

```{=html}
<!-- -->
```
13) デジタル社会推進標準ガイドライン群，令和5年，デジタル庁.

    （最新版）デジタル社会推進標準ガイドライン群，令和7年5月，デジタル庁.

14) オープンデータ基本指針，令和3年6月，高度情報通信ネットワーク社会推進戦略本部・官民データ活用推進戦略会議決定.

    （最新版）オープンデータ基本指針,平成29年5月30日,高度情報通信ネットワーク社会推進戦略本部・官民データ活用推進戦略会議決定.

    令和6年7月5日改正,デジタル社会推進会議幹事会改正.

> 情報システムの整備に際し計画段階の基本的方針には、下記資料が参考となる。

15) 情報システムの整備及び管理の基本的な方針,令和3年12月,デジタル大臣決定.

> その他情報システムに対する具体的な事項は、下記資料が参考となる。

16) データ品質管理ガイドブック，令和4年3月31日，デジタル庁.

17) 「政府標準利用規約（第2.0版）」の解説，平成27年12月，内閣官房IT総合戦略室.

    （最新版）「公共データ利用規約（第1.0版）」の解説,令和6年7月5日,デジタル庁.

18) 政府相互運用性フレームワーク（GIF），令和6年3月，デジタル庁.

    （最新版）政府相互運用性フレームワーク（GIF），令和7年3月，デジタル庁.

19) 政府機関等のサイバーセキュリティ対策のための統一基準群，令和5年7月，内閣サイバーセキュリティセンターサイバーセキュリティ戦略本部.

    （最新版）政府機関等のサイバーセキュリティ対策のための統一基準群，令和7年7月，内閣サイバーセキュリティセンターサイバーセキュリティ戦略本部.

＜標　準＞

+----------------------------------------------------------------------+
| 河川等の計画、設計及び維持管理等の円滑な遂行及び国民への適           |
| 切な情報の共有のため、調査により得られた観測結果及び分析・検討結果等 |
| を河川等の管理者や自治体・住民らが活用できるようにする情報システムを |
| 現在及び今後の情報通信技術の進展を踏まえて整備することを基本とする。 |
|                                                                      |
| 警戒避難に資する情報システムについては、その重要性から、確実性       |
| 、信頼性、迅速性、双方向性が確保されるよう考慮し計画するものとする。 |
+----------------------------------------------------------------------+

＜例　示＞

+----------------------------------------------------------------------+
| 国土                                                                 |
| 交通省関係の情報システムとして以下に示すようなものが整備されている。 |
|                                                                      |
| 表5-1-1　情報システム事例                                            |
|                                                                      |
| +-------------------------------+-------------------------------+    |
| | システム名                    | システム概要                  |    |
| +===============================+===============================+    |
| | 川の防災情報                  | -   雨や川の水位の状況など    |    |
| |                               | を、インターネットを通じてリ  |    |
| | <h                            | アルタイムに配信し、避難判断  |    |
| | ttps://www.river.go.jp/index> | 等に必要な情報を入手できる。  |    |
| +-------------------------------+-------------------------------+    |
| | ハザードマップポータルサイト  | -                             |    |
| |                               |    防災に役立つ様々なリスク情 |    |
| | <h                            | 報や全国の市町村が作成したハ  |    |
| | ttps://disaportal.gsi.go.jp/> | ザードマップを公開している。  |    |
| |                               |                               |    |
| |                               | -   防災に                    |    |
| |                               | 役立つ様々なリスク情報を１つ  |    |
| |                               | の地図上に重ね合わせが可能。  |    |
| +-------------------------------+-------------------------------+    |
| | 水文水質データベース          | -   国土交通省各地方整        |    |
| |                               | 備局が長年観測し、蓄積した水  |    |
| | <http://www1.river.go.jp/>    | 文水質データを公開している。  |    |
| +-------------------------------+-------------------------------+    |
| | 河川環境データベース          | -   河川環                    |    |
| |                               | 境の整備と保全を目的として行  |    |
| | <https://www.ni               | っている河川水辺の国勢調査の  |    |
| | lim.go.jp/lab/fbg/ksnkankyo/> | 結果を格納・蓄積し、インター  |    |
| |                               | ネットを通じて公表している。  |    |
| +-------------------------------+-------------------------------+    |
| | 河川関係統計データ            | -   水害統計調査、災害統計か  |    |
| |                               | らなる河川関係統計を政府統計  |    |
| | <                             | の総合窓口e-Statにて公表中。  |    |
| | https://www.mlit.go.jp/statis |                               |    |
| | tics/details/river_list.html> |                               |    |
| +-------------------------------+-------------------------------+    |
| | 国                            | -                             |    |
| | 土交通データプラットフォーム  |  様々な分野のシステムと連携し |    |
| |                               | 、データセットを横断的に検索  |    |
| | <https://www.mlit-data.jp/#/> | し、データの表示・ダウンロー  |    |
| |                               | ドができるプラットフォーム。  |    |
| |                               |                               |    |
| |                               | ```{=html}                    |    |
| |                               | <!-- -->                      |    |
| |                               | ```                           |    |
| |                               | -   データを3D地図上に        |    |
| |                               | 3次元表示・重ね合わせが可能。 |    |
| +-------------------------------+-------------------------------+    |
| | 国土                          | -   地形、土地利              |    |
| | 数値情報ダウンロードサービス  | 用、公共施設など国土に関する  |    |
| |                               | 基礎的な情報をGISデータとして |    |
| | <https://nlftp.mlit.go.jp/>   | 整備し、無償で提供している。  |    |
| |                               |                               |    |
| |                               | ```{=html}                    |    |
| |                               | <!-- -->                      |    |
| |                               | ```                           |    |
| |                               | -   国土数値情報として、      |    |
| |                               | 行政区域、鉄道、道路、河川、  |    |
| |                               | 地価公示、土地利用メッシュ、  |    |
| |                               | 公共施設などを整備、公開中。\ |    |
| |                               |     そのほか国土調査（土地分  |    |
| |                               | 類調査・水調査）として、地質  |    |
| |                               | 、地形分類図、表流水及び地下  |    |
| |                               | 水のGISデータを提供している。 |    |
| +-------------------------------+-------------------------------+    |
|                                                                      |
| このほか、オープン                                                   |
| データの活用の促進を目的として、各府省の保有するオープンデータをカタ |
| ログとして整備した「e-GOVデータポータル（デジタル庁運営）」がある。  |
|                                                                      |
| また、水災害                                                         |
| 等の非常時においては、ISUT（災害時情報集約支援チーム）がSIP4D（基礎  |
| 的防災情報流通ネットワーク）を活用し、災害情報の共有を実施している。 |
+----------------------------------------------------------------------+
