第1章　河川構造物の設計 {#第1章-河川構造物の設計 .目次の見出し1}
=======================

第１節　総説 {#第１節-総説 .目次の見出し1}
============

目　次 {#目-次 .目次の見出し1}
======

[第1節 総説 1](#_Toc103183307)

> [1．1 基本的考え方 1](#_Toc103183308)

令和４年６月　版

適用上の位置付け

　河川砂防技術基準設計編は、基準の適用上の位置付けを明確にするために、下表に示すように適用上の位置付けを分類している。

+--------+------------------+------------------+------------------+
| 分　類 | 適用上の位置付け | 末尾の字句例     |                  |
+--------+------------------+------------------+------------------+
| 考え方 | 技術資料         | ●目              | 「･･･ある。      |
|        |                  | 的や概念、考え方 | 」「･･･いる。」  |
|        |                  | を記述した事項。 |                  |
|        |                  |                  | 「･･･なる。      |
|        |                  |                  | 」「･･･れる。」  |
+--------+------------------+------------------+------------------+
| 必　須 | 技術基準         | ●法令による規定  | 「･･･なければ    |
|        |                  | や技術的観点から | ならない。」「･  |
|        |                  | 実施すべきである | ･･ものとする。」 |
|        |                  | ことが明確であり |                  |
|        |                  | 遵守すべき事項。 |                  |
+--------+------------------+------------------+------------------+
| 標　準 | 技術基準         | ●特              | 「･･･            |
|        |                  | 段の事情がない限 | を標準とする。」 |
|        |                  | り記述に従い実施 |                  |
|        |                  | すべきだが、状況 | 「･･･            |
|        |                  | や条件によって一 | を基本とする。」 |
|        |                  | 律に適用すること |                  |
|        |                  | はできない事項。 | 「･･･による。」  |
+--------+------------------+------------------+------------------+
| 推　奨 | 技術資料         | ●状況や条件      | 「               |
|        |                  | によって実施する | ･･･望ましい。」  |
|        |                  | ことが良い事項。 |                  |
|        |                  |                  | 「               |
|        |                  |                  | ･･･推奨する。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･務める。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･必要に応    |
|        |                  |                  | じて･･･する。」  |
+--------+------------------+------------------+------------------+
| 例　示 | 技術資料         | ●適用条件や実施  | 「               |
|        |                  | 効果について確定 | ･･･などの手法（  |
|        |                  | している段階では | 事例）がある。」 |
|        |                  | ないが、状況や条 |                  |
|        |                  | 件によっては導入 | 「･･･など        |
|        |                  | することが可能な | の場合がある。」 |
|        |                  | 新技術等の例示。 |                  |
|        |                  |                  | 「･･･など        |
|        |                  | ●状              | が考えられる。」 |
|        |                  | 況や条件によって |                  |
|        |                  | 限定的に実施でき | 「               |
|        |                  | る技術等の例示。 | ･･･の場合には･･･ |
|        |                  |                  | ことができる。」 |
|        |                  | ●具体的          |                  |
|        |                  | に例示することに | 「               |
|        |                  | より、技術的な理 | ･･･例示する。」  |
|        |                  | 解を助ける事項。 |                  |
|        |                  |                  | 「例えば･･･。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･事例もある  |
|        |                  |                  | 。･･･もよい。」  |
+--------+------------------+------------------+------------------+

  関連通知等       関連する通知やそれを理解する上で参考となる資料
  ---------------- ------------------------------------------------------
  参考となる資料   例示等に示した手法・内容を理解する上で参考となる資料

1.  []{#_Toc103183307 .anchor}河川構造物の設計

    1.  総説

        1.  []{#_Toc103183308 .anchor}基本的考え方

＜考え方＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  本章は、河川管理施設等構造令（以下「構造令」という。）で定められる事項に加え、河川構造物を設計する場合の一般的かつ基本的な規定を示すものである。なお、その適用に当たっては、各項の規定するところに従い実状に即した適切な判断をするべきである。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  河川構造物は、河道並びに河川構造物の計画に基づき、目的と機能に適合し、構造物としての安全性を有すると共に、環境・景観との調和、構造物の耐久性、維持管理の容易性、施工性、事業実施による地域への影響、経済性及び公衆の利用等を総合的に考慮して設計することを基本とする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

+----------------------------------------------------------------------+
| 河                                                                   |
| 川構造物の設計に当たっては、まずは施工対象となる河川の河道について、 |
| 既往洪水での被災、砂利採取、土砂供給、河道や横断工作物の改修等に対す |
| る長期的な応答に関するデータを収集・分析することが望ましい。長期的な |
| 視点から改修とその後の洪水に対する河道の応答等を分析し、その効果や影 |
| 響が河道の変化にどの様に顕れるかを検討した上で各構造物の設計に反映す |
| ることで、治水と河川環境の調和、適切な河道管理に繋げることができる。 |
|                                                                      |
| また、各構造物の設計の                                               |
| 過程等において、現場条件等により、構造物としての安全性、環境・景観と |
| の調和、維持管理、施工性、経済性等の面から、当該河川構造物の設置位置 |
| またはその構造を見直すことが必要となる場合がある。当該河川構造物のみ |
| の設計では洪水時の堤防の安全性の確保や河川環境の保全、総合的な土砂管 |
| 理等の観点から十分に期待する効果が得られないことが想定される場合等に |
| おいては、河道の平面形（位置・法線）の設定や高水敷幅、関連する複数施 |
| 設の組合せ等の河道計画や配置計画について、再検討することが望ましい。 |
+----------------------------------------------------------------------+

＜例　示＞

+----------------------------------------------------------------------+
| 多摩川中流においては、これまでの洪                                   |
| 水、砂利採取、河川改修等の履歴をもとに、河道の平面形や縦横断形の長期 |
| 的変化（おおむね60～70年間）を分析し、その結果を堰改築（床止めに変更 |
| ）や河床低下対策として整備する帯工の端部構造の設計等に反映している。 |
|                                                                      |
| これにより、固定化していた砂州が洪水によって削られ、下流側へ         |
| 土砂供給が促されることにより、河床高が維持され、交互砂州が回復するな |
| ど、縦断的な河床低下を抑制し、安定した河道の形成につながりつつある。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

　　多摩川中流域における過去73年間のデータに基づき河道の変化・応答を分析し、これまでの河道改修の効果等を整理した事例については、下記の資料が参考となる。

> 1\)
> 後藤勝洋，下條康之，後藤岳久，福岡捷二：多摩川中流河道の洪水被害と対策，改修工事に対する河道の長期的(1947年～2019年)変化・応答，土木学会論文集B1(水工学)
> Vol.77,No.2，pp.I\_391-I\_396, 2021．

第1章　河川構造物の設計 {#第1章-河川構造物の設計-1 .TOC-Heading}
=======================

**第2節　堤防**

目　次 {#目-次-1 .TOC-Heading}
======

[第2節 堤防 1](#_Toc10813349)

> [2．1 総説 1](#_Toc10813350)
>
> [2．1．1 目的と適用範囲 1](#_Toc10813351)
>
> [2．1．2 用語の定義 1](#_Toc10813352)
>
> [2．2 機能と設計に反映すべき事項 2](#_Toc13470656)
>
> [2．2．1 機能 2](#_Toc13470657)
>
> [2．2．2 設計に反映すべき事項 2](#_Toc13470658)
>
> [2．3 堤防の材質と構造 4](#_Toc13470659)
>
> [2．4 設計の基本 4](#_Toc10813354)
>
> [2．5 堤防の高さの設定 7](#_Toc10813355)
>
> [2．6 断面形状の設定 8](#_Toc13470662)
>
> [2．7 安全性能の照査等 10](#_Toc10813357)
>
> [2．7．1 設計の対象とする状況と作用 10](#_Toc13470664)
>
> [2．7．2 土堤の安全性能の照査 11](#_Toc10813359)
>
> [2．7．3 特殊堤の安全性能の照査 20](#_Toc10813360)
>
> [2．8 土堤の強化対策 21](#_Toc10813361)
>
> [2．8．1 強化工法選定の基本 21](#_Toc10813362)
>
> [2．8．2 常時のすべり破壊に対する安定及び沈下に対する強化
> 22](#_Toc13470669)
>
> [2．8．3 侵食に対する強化 22](#_Toc10813364)
>
> [2．8．4 浸透に対する強化 23](#_Toc10813365)
>
> [2．8．5 地震に対する強化 25](#_Toc10813366)
>
> [2．8．6 波浪に対する強化 26](#_Toc10813367)
>
> [2．9 堤防構造に関するその他の事項 26](#_Toc13470674)

令和元年７月　版

適用上の位置付け

　河川砂防技術基準設計編は、基準の適用上の位置付けを明確にするために、下表に示すように適用上の位置付けを分類している。

+--------+------------------+------------------+------------------+
| 分　類 | 適用上の位置付け | 末尾の字句例     |                  |
+--------+------------------+------------------+------------------+
| 考え方 | 技術資料         | ●目              | 「･･･ある。      |
|        |                  | 的や概念、考え方 | 」「･･･いる。」  |
|        |                  | を記述した事項。 |                  |
|        |                  |                  | 「･･･なる。      |
|        |                  |                  | 」「･･･れる。」  |
+--------+------------------+------------------+------------------+
| 必　須 | 技術基準         | ●法令による規定  | 「･･･なければ    |
|        |                  | や技術的観点から | ならない。」「･  |
|        |                  | 実施すべきである | ･･ものとする。」 |
|        |                  | ことが明確であり |                  |
|        |                  | 遵守すべき事項。 |                  |
+--------+------------------+------------------+------------------+
| 標　準 | 技術基準         | ●特              | 「･･･            |
|        |                  | 段の事情がない限 | を標準とする。」 |
|        |                  | り記述に従い実施 |                  |
|        |                  | すべきだが、状況 | 「･･･            |
|        |                  | や条件によって一 | を基本とする。」 |
|        |                  | 律に適用すること |                  |
|        |                  | はできない事項。 | 「･･･による。」  |
+--------+------------------+------------------+------------------+
| 推　奨 | 技術資料         | ●状況や条件      | 「               |
|        |                  | によって実施する | ･･･望ましい。」  |
|        |                  | ことが良い事項。 |                  |
|        |                  |                  | 「               |
|        |                  |                  | ･･･推奨する。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･務める。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･必要に応    |
|        |                  |                  | じて･･･する。」  |
+--------+------------------+------------------+------------------+
| 例　示 | 技術資料         | ●適用条件や実施  | 「               |
|        |                  | 効果について確定 | ･･･などの手法（  |
|        |                  | している段階では | 事例）がある。」 |
|        |                  | ないが、状況や条 |                  |
|        |                  | 件によっては導入 | 「･･･など        |
|        |                  | することが可能な | の場合がある。」 |
|        |                  | 新技術等の例示。 |                  |
|        |                  |                  | 「･･･など        |
|        |                  | ●状              | が考えられる。」 |
|        |                  | 況や条件によって |                  |
|        |                  | 限定的に実施でき | 「               |
|        |                  | る技術等の例示。 | ･･･の場合には･･･ |
|        |                  |                  | ことができる。」 |
|        |                  | ●具体的          |                  |
|        |                  | に例示することに | 「               |
|        |                  | より、技術的な理 | ･･･例示する。」  |
|        |                  | 解を助ける事項。 |                  |
|        |                  |                  | 「例えば･･･。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･事例もある  |
|        |                  |                  | 。･･･もよい。」  |
+--------+------------------+------------------+------------------+

  関連通知等       関連する通知やそれを理解する上で参考となる資料
  ---------------- ------------------------------------------------------
  参考となる資料   例示等に示した手法・内容を理解する上で参考となる資料

2.  河川構造物の設計

    1.  []{#_Toc10813349 .anchor}堤防

        1.  []{#_Toc10813350 .anchor}総説

            1.  []{#_Toc10813351 .anchor}目的と適用範囲

＜考え方＞

+----------------------------------------------------------------------+
| 本節は、既設の堤防の拡築や新堤の整備に適用す                         |
| るものであるが、既設の堤防の安全性能の照査にも準用できるものである。 |
|                                                                      |
| 適用の対象とする堤                                                   |
| 防は、流水が河川外に流出することを防止するために設ける堤防であり、こ |
| のような堤防には、湖岸堤、高潮堤、霞堤（堤防のある区間に開口部を設け |
| 、上流側の堤防と下流側の堤防が、二重になるようにした不連続な堤防。な |
| お、下流側の堤防を山付きとする場合もある。）及び特殊堤等が含まれる。 |
|                                                                      |
| なお、高規格堤防については、構造令及びそ                             |
| れに関連する基準等により別途規定されているため、本節の適用外とする。 |
|                                                                      |
| また、洪水時等に遊水地等における洪水調節のため、洪水の一部を越       |
| 流させて河道の外部に導くために設けられる越流堤、遊水地等と河道を仕切 |
| るために設けられる囲繞堤、河川の合流に際して流れを分離して、一方の河 |
| 川がもう一方の河川に与える背水等の影響を低減するために設けられる背割 |
| 堤、河川、湖沼、海において流れを導き、土砂の堆積やそれに伴う閉塞又は |
| 河川の深掘れを防ぐために設けられる導流堤については、必要に応じて模型 |
| 実験や水理計算等の検討を行い、それぞれの設置目的に応じて十分な機能を |
| 発揮する安全な構造を個別に定めるものであるため、本節の適用外とする。 |
+----------------------------------------------------------------------+

＜標　準＞

  --------------------------------------------------------------------------------
  本節は、流水が河川外に流出することを防止するために設ける堤防について適用する。
  --------------------------------------------------------------------------------

＜関連通知等＞

1.  建設省河川局長通達：河川管理施設等構造令及び同令施行規則の施行について，昭和51年11月23日，建設省河政発第70号．

    1.  []{#_Toc10813352 .anchor}用語の定義

＜標　準＞

+----------------------------------------------------------------------+
| > 次の各号に掲げる用語の定義は、それぞれ以下に示す。                 |
|                                                                      |
| 1.  土堤　盛土により築造された堤防                                   |
|                                                                      |
| 2.  特殊堤　全部若しくは主要な部分がコンクリート、鋼矢板若しく       |
| はこれに準ずるものによる構造で盛土の部分がなくても自立する構造の堤防 |
| 又はコンクリート構造若しくはこれに準ずる構造の胸壁を有する構造の堤防 |
|                                                                      |
| 3.  湖岸堤　湖沼において、風の吹                                     |
| き寄せに伴う波浪や越波等による堤内地の被害を防ぐ目的で設置される堤防 |
|                                                                      |
| 4.  高潮堤　高潮区間において                                         |
| 、高潮に伴う波浪や越波等による堤内地の被害を防ぐ目的で設置される堤防 |
|                                                                      |
| 5.  計画堤防断面形状　河川整備基本方針で定められ                     |
| た計画高水流量及び計画高水位に従って、河川管理施設等構造令（以下「構 |
| 造令」という。）に基づき最低限確保すべき高さ、天端幅、のり勾配等を満 |
| たし、当該河川の過去の洪水実績等の経験を踏まえて定める堤防の断面形状 |
+----------------------------------------------------------------------+

1.  []{#_Toc13470656 .anchor}機能と設計に反映すべき事項

    1.  []{#_Toc13470657 .anchor}機能

＜考え方＞

+----------------------------------------------------------------------+
| 我が国は沖積河川の氾濫原に人口・資産が集中                           |
| しており、堤防は、人命と財産を洪水及び高潮から防御する極めて重要な河 |
| 川構造物である。したがって、計画高水位（高潮区間においては計画高潮位 |
| ）以下の水位の流水の通常の作用に対し、流水が河川外に流出することを防 |
| 止する必要がある。すなわち、堤防に求められる機能は、護岸、水制その他 |
| これらに類する施設と一体として、河道計画で定められた計画高水位（高潮 |
| 区間においては計画高潮位）以下の水位の流水の通常の作用による侵食や浸 |
| 透に対して安全な機能を有することである。また、流水による堤防への浸透 |
| を規定する条件として、降雨の浸透によって形成される堤体内の土壌水分あ |
| るいは堤体内の浸潤面の状況が重要であり、これらを考慮する必要がある。 |
|                                                                      |
| 堤防は、通常起こり得る現象である「計画高                             |
| 水位（高潮区間においては計画高潮位）以下の水位の流水の通常の作用及び |
| 降雨による浸透」に対して安全に造られるべきである。但し、洪水は自然現 |
| 象であるため、既往洪水による被害の実態や河川の特性を踏まえた計画規模 |
| の洪水と比較して、継続時間が著しく長いもの等が発生しないとは限らない |
| 。そのため、このような考え方に基づき造られた堤防が計画高水位以下の洪 |
| 水に対して絶対的な安全性を有するものではないことに留意すべきである。 |
|                                                                      |
| 常時に                                                               |
| おいては、堤防の築造や嵩上げ及び腹付けに伴う堤防の自重増加による基礎 |
| 地盤の沈下、変形及びすべり破壊等に対して安全であることが求められる。 |
|                                                                      |
| 地震時においては、堤防に変形又は沈下が生じた場合においても、         |
| 河川の流水の河川外への越流を防止する機能を有することが求められる。加 |
| えて、地震時には津波が発生する可能性があり、津波来襲時に計画津波の遡 |
| 上により流水の河川外への越流を防止する機能を有することが求められる。 |
|                                                                      |
| また、洪水等による被害を軽減するものとし                             |
| て水防活動等の緊急措置が実施されることも多いことから、堤防には、計画 |
| 高水位（高潮区間においては計画高潮位）以下の水位の流水の通常の作用及 |
| び降雨による浸透に対して安全であることに加えて、洪水時及び高潮時等に |
| 巡視、応急復旧活動及び水防活動が実施されることにも留意が必要である。 |
+----------------------------------------------------------------------+

＜必　須＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  堤防は、護岸、水制その他これらに類する施設と一体として、計画高水位（高潮区間においては計画高潮位）以下の水位の流水の通常の作用による侵食及び浸透並びに降雨による浸透に対して安全である機能を有するよう設計するものとする。また常時に自重による沈下及びすべり破壊等に対して安全であるとともに、地震時に流水が河川外に流出することを防止する機能を有するよう設計するものとする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1.  建設省河川局水政課長、治水課長通達：[河川管理施設等構造令及び同令施行規則の運用について](http://www.mlit.go.jp/notice/noticedata/sgml/053/78000112/78000112.html)，昭和52年2月1日，建設省河政発第5号，建設省河治発第6号．

    1.  []{#_Toc13470658 .anchor}設計に反映すべき事項

＜考え方＞

+----------------------------------------------------------------------+
| 堤防に求められる                                                     |
| 機能を有するように設計する際、堤防の歴史的な経緯を踏まえることが重要 |
| である。すなわち、堤防は長い歴史の中で大洪水に遭遇して危険な状態にな |
| ることを経験すると、その後順次嵩上げ及び拡幅等を実施することにより強 |
| 化を図ってきた構造物である。また、時代によって築堤材料や施工法が異な |
| るため、堤体の強度が不均一であること及びその分布が不明であること並び |
| に基礎地盤自体が古い時代の河川の作用によって形成された地盤であり、極 |
| めて複雑であること等の特性を有していることを踏まえておく必要がある。 |
|                                                                      |
| 堤防は、複雑な基礎地盤の上に築造                                     |
| された連続した長大構造物であり不同沈下が起きやすいことから、不同沈下 |
| に対する修復が容易であること、基礎地盤と堤体、拡幅等行った場合の旧堤 |
| と新堤並びに堤体内に設置する横断工作物と基礎地盤及び堤体との一体性及 |
| びなじみが必要であること、必要に応じて堤防を強化する場合があるため、 |
| 嵩上げ及び拡幅等の機能増強が容易であること並びに洪水や地震に遭遇して |
| 堤防が損傷した場合に復旧が容易であり所要工期が短いこと等を踏まえて、 |
| 設計することが求められる。なお、堤体内に堤体材料とは異なる材料や工作 |
| 物が含まれると、その境界に水ミチが発生しやすくなり堤防の弱部となる可 |
| 能性があるので、堤体材料とは異なる材料や工作物を設置する場合は堤防の |
| 安全性や河川管理上、最低限必要と認められるものに限られるべきである。 |
|                                                                      |
| また、堤防は                                                         |
| 局所的な安全性が一連の堤防全体の安全性を規定する長大構造物である。新 |
| 設の堤防では堤体材料を適切に選定することができるが、既設の堤防はその |
| 歴史的な経緯から堤体材料の強度が不均一である。さらに、新設・既設に関 |
| わらず、基礎地盤自体は極めて複雑であり、これらの性状を地質構成の連続 |
| 性を含めて詳細に把握することは困難であるため、基礎地盤や堤体の構造及 |
| び性状の調査精度が必ずしも高くない。そのため、基礎地盤及び堤体の不均 |
| 質性の影響が大きいこと等の実情を踏まえて、設計することが求められる。 |
|                                                                      |
| 加えて、河川                                                         |
| は多様性に富んだ自然環境を有しており、堤防自体が自然環境の一部を形成 |
| するとともに、地域の中においても良好な生活環境の形成に重要な役割を担 |
| うことから、環境及び景観との調和が求められる。また、材料や構造物その |
| ものの劣化がしにくく耐久性が必要であること、限られた人員と費用で長大 |
| な延長を持つ堤防の安全性を確保することから維持管理が容易であること及 |
| び材料の確保の容易さや施工がし易いことが求められるとともに、築堤等に |
| より沿川地域の社会基盤を大きく改変すること等、事業実施による地域への |
| 影響を考える必要があること、維持管理も含めた経済性が良いこと並びに｢  |
| 川の365日｣を意識した健康づくりやふれあい及び交流の場として公衆の利用 |
| が求められること等についても設計に当たって考慮することが求められる。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 堤防は複雑な基礎地盤の上に築造さ                                     |
| れ、過去の被災に応じて嵩上げ及び拡幅等の強化を重ねてきた歴史的な構造 |
| 物であることを踏まえ、以下の項目を検討し、設計に反映するものとする。 |
|                                                                      |
| ・不同沈下に対する修復の容易性                                       |
|                                                                      |
| ・基礎地盤及び堤体との一体性及びなじみ                               |
|                                                                      |
| ・嵩上げ及び拡幅等の機能増強の容易性                                 |
|                                                                      |
| ・損傷した場合の復旧の容易性                                         |
|                                                                      |
| ・基礎地盤及び堤体の構造及び性状に係る調査精度に起因する不確実性     |
|                                                                      |
| ・基礎地盤及び堤体の不均質性に起因する不確実性                       |
|                                                                      |
| その他、設計に当たっては、環境及び                                   |
| 景観との調和、構造物の耐久性、維持管理の容易性、施工性、事業実施によ |
| る地域への影響、経済性及び公衆の利用等を総合的に考慮するものとする。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  
    （財）国土技術研究センター：[河川堤防の構造検討の手引き（改訂版）](http://www.jice.or.jp/cms/kokudo/pdf/tech/material/teibou_kouzou02.pdf)，第2章
    構造物としての河川堤防の特徴，2012．

    1.  []{#_Toc13470659 .anchor}堤防の材質と構造

＜考え方＞

+----------------------------------------------------------------------+
| 堤防の                                                               |
| 材質と構造は、構造令に基づき土堤が原則である。これは、土堤が歴史的な |
| 経緯の中で、工事の費用が比較的低廉であること、材料の取得が容易であり |
| 構造物としての劣化現象が起きにくいこと並びに堤防に求められる機能及び |
| 設計に反映すべき事項等を満足してきたとみなすことができるためである。 |
|                                                                      |
| 土地利用の状況その他の特別の事情によりやむを得ないと認められ         |
| る場合には、特例的に特殊堤とすることができる。中でもいわゆる自立式構 |
| 造の特殊堤は特例中の特例と考えるべきであり、都市河川の高潮区間等にお |
| いて限定的に設けられている。特殊堤においても、土堤と同様に「2.2機能  |
| と設計に反映すべき事項」を満足することを確認する必要があり、土堤とは |
| 異なる構造であることを踏まえた維持管理を適切に行うことが重要となる。 |
+----------------------------------------------------------------------+

＜必　須＞

+----------------------------------------------------------------------+
| 堤防の材質と構造は、構造令に基づき土堤とする。                       |
|                                                                      |
| ただし、土地利用の状況その他の特別の事                               |
| 情によりやむを得ないと認められる場合には、特殊堤とすることができる。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  国土交通省水管理・国土保全局：河川砂防技術基準
    維持管理編（河川編），第 6章 施設の維持及び修繕・対策，平成27年3月．

    （最新版）国土交通省水管理・国土保全局：[河川砂防技術基準
    維持管理編（河川編）](https://www.mlit.go.jp/river/shishin_guideline/gijutsu/gijutsukijunn/ijikanri/index.html)，第
    6章 施設の維持及び修繕・対策，令和3年10月．

    1.  []{#_Toc10813354 .anchor}設計の基本

＜考え方＞

+----------------------------------------------------------------------+
| 本節でいう設計                                                       |
| とは、計画堤防断面形状を確保した上で安全性能の照査を行い、必要に応じ |
| て強化工法の検討を行うまでの一連の作業の流れをいう。また、本節でいう |
| 強化とは、計画堤防断面形状を有する堤防において、安全性能の照査の結果 |
| が安全性能を満足しない場合に、安全性能を満足させるための対応をいう。 |
|                                                                      |
| 構造令では、土堤の断面形状（堤防の                                   |
| 高さ、天端幅及びのり勾配等）の最低基準を河川の規模（流量）等に応じて |
| 規定する、いわば形状規定方式を基本としている。これは、堤防が洪水によ |
| る被害を経験するたびに嵩上げ及び拡幅等を繰り返して築造されてきたこと |
| 並びに基礎地盤の構造が複雑で完全に把握することはできないといった不確 |
| 実性を内在する中で、断面形状を既往の被災経験と実績をもとに設定するこ |
| とが合理的であると考えられてきたことによるところが大きい。さらに、場 |
| 所によって堤防の断面が異なると住民に不安を与えることになることも形状 |
| 規定方式がとられてきた背景のひとつと考えられる。このように、土堤によ |
| る形状規定方式に基づく堤防の設計は、簡便で極めて効率的で、長年の経験 |
| を踏まえたものであり、堤防整備の基本として十分な役割を果たしてきた。 |
|                                                                      |
| 一方、形状規定方式に基づく堤防の設計手法が、堤防の安全性について     |
| 所要の性能を満足するかどうかを確認する手法として限界を有していること |
| も事実であり、既往の被災事例をみても、計画高水位以下の流水において、 |
| のりすべり等安全上問題となる現象が数多く発生している。そのため、形状 |
| 規定方式で整備されてきた土堤の強化が必要とされ、その必要性や優先度、 |
| さらには対策工法を検討するために、堤防の設計においても一般の構造物の |
| 設計法と同様、外力と耐力の比較を基本とする設計法（安全性照査法）を導 |
| 入することが、その前提となる工学的手法が進展する中で求められてきた。 |
|                                                                      |
| 以上の考えから、平成9年の河川砂防技術基準（案）設計編の改定では      |
| 、堤防の断面形状については従来の考えを踏襲しつつ、堤防の耐侵食性能及 |
| び耐浸透性能に関しては、その性能毎に水理学的あるいは土質力学的な知見 |
| に基づく安全性能の照査法を用いた堤防設計法を導入してきたところである |
| 。これは、経験に基づき設計する形状規定方式と理論に基づき安全性能を照 |
| 査する手法を組み合わせて、前者で設計することを基本とし、堤防の信頼性 |
| を高めるために必要に応じて後者により安全性能を照査するものであり、安 |
| 全性能の照査だけで設計を行うことにはならないことに留意する必要がある |
| 。すなわち、安全性能の照査は、安全性能を満足しているかどうかの判断と |
| 、安全性能を満足させるための強化という局面において用いるものである。 |
|                                                                      |
| このような堤防設計法の考えに基づき、これまで安全性能の               |
| 照査を実施してきたところであるが、今なお基礎地盤及び堤体の構造及び性 |
| 状を正確に把握する適切な手法がないこと並びに基礎地盤及び堤体内の複雑 |
| な浸透水の流れを正確に把握することが困難であること等、力学的に未解明 |
| な部分が残されており、技術的な判断を経験に依存せざるを得ない部分も多 |
| いなど、安全性能の照査においても様々な不確実性が内在せざるを得ない状 |
| 況であり、現状の技術では堤防の弱部の合理的な評価及び洪水に対する堤防 |
| の縦断的な安全性の評価を的確に実施することは困難な状況にある。今後、 |
| 堤防の弱部をより一層的確に把握し、必要な強化を図るために、安全性能の |
| 照査法等の評価技術の精度及び信頼性の向上を図り、指標化に向けた更なる |
| 検証及び強化対策への活用手法の確立等、既存技術と連携して堤防の安全性 |
| をさらに高めていくための研究及び技術開発に取り組んでいく必要がある。 |
|                                                                      |
| また、堤防の安全性及び耐久性は、設計のみならず使用材料や             |
| 施工の良し悪し及び維持管理の程度に大きく依存する。このため、設計に当 |
| たっては設計で前提とする使用材料の品質、施工及び施工管理の条件並びに |
| 維持管理の方法を定め、これらを考慮する必要がある。例えば、土堤の設計 |
| においては、安全性等を確保する観点から、使用する材料、締固め方法及び |
| 締固め度等の施工における具体的な方法並びに管理基準値を定める必要があ |
| る。また、維持管理については、点検の頻度及び方法並びに出水時及び地震 |
| 時にどのような手段で調査を行うか等を定め、設計で考慮する必要がある。 |
|                                                                      |
| 設計において考慮する必要があるこれらの事項                           |
| については、一般的には施工管理基準、河川土工マニュアル、堤防等河川管 |
| 理施設及び河道の点検要領並びに河川砂防技術基準調査編等が参考となる。 |
+----------------------------------------------------------------------+

＜必　須＞

+----------------------------------------------------------------------+
| 堤防の設計に当たっては、土地利用                                     |
| の状況その他の特別の事情によりやむを得ないと認められる場合を除き、土 |
| 堤による形状規定方式に基づく計画堤防断面形状の設定を行うものとする。 |
|                                                                      |
| さらに計画堤防                                                       |
| 断面形状を満たした上で、堤防に求められる機能を踏まえ、設計の対象とす |
| る状況と作用に応じた安全性能を設定し、照査によりこれを満足することを |
| 確認しなければならない。必要な場合は強化工法の検討を行うものとする。 |
|                                                                      |
| また、設計に当たっては、設計で前                                     |
| 提とする締固め度等の施工条件及び維持管理の条件を設定するものとする。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  国土交通省：土木工事施工管理基準（案），平成28年3月．

    （最新版）国土交通省：土木工事施工管理基準及び規格値（案），令和7年3月．

2.  （財）国土技術研究センター：河川土工マニュアル，[第2章
    河川土工のための調査](http://www.jice.or.jp/cms/kokudo/pdf/tech/material/dokouh21_02.pdf)
    第2.1節 基礎地盤調査，2009．

3.  国土交通省水管理・国土保全局河川環境課：堤防等河川管理施設及び河道の点検要領，平成28年3月

    （最新版）国土交通省水管理・国土保全局河川環境課：堤防等河川管理施設及び河道の点検・評価要領，令和5年3月．

4.  国土交通省水管理・国土保全局：河川砂防技術基準
    調査編，第10章災害調査，平成26年4月

    （最新版）国土交通省水管理・国土保全局：河川砂防技術基準
    調査編，[第10章災害調査](https://www.mlit.go.jp/river/shishin_guideline/gijutsu/gijutsukijunn/chousa/index.html)，令和5年5月．

5.  河川管理技術研究会編：[改訂
    解説・工作物設置許可基準](http://www.jice.or.jp/cms/kokudo/pdf/tech/material/kousakubutusecchi.pdf)，（財）国土技術研究センター，1998．

＜推　奨＞

+----------------------------------------------------------------------+
| > 堤防の維                                                           |
| 持と強化は、様々な規模の洪水等を経験しながら極めて長期的に続くもので |
| あることを踏まえ、点検、維持、管理及び被災後の堤防強化等の対応に活用 |
| することができるよう、堤防の設計、施工、強化及び復旧の検討における安 |
| 全性の確認結果や対策工の設計及び施工結果の随時更新及び保存に努める。 |
+----------------------------------------------------------------------+

＜推　奨＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  基礎地盤及び堤体の不均質な構造及び性状に由来する不確実性を低減するための調査及び検討並びに実現象を踏まえた堤防の破壊及び変形メカニズムを反映した解析手法等、更なる研究や技術開発に取り組み、それらによる知見の蓄積を踏まえ、設計及び強化に当たって活用可能な技術を積極的に取り込んでいくことが望ましい。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜例　示＞

+----------------------------------------------------------------------+
| 現状の安全性能の照査法における課                                     |
| 題を解決するため、基礎地盤及び堤体の構造及び性状を縦断方向に連続的に |
| 調査する方法並びに侵食現象及び浸透現象並びにそれらの作用を受ける堤体 |
| の安定性評価法等、関連する技術の進歩が著しく、近年では、以下のような |
| 研究や実証が進んでおり、状況や条件によっては活用が可能と考えられる。 |
|                                                                      |
| > 1）洪水時の堤防裏のり先への浸透流の集中機構に着目し、堤防安定性    |
| を低下させる堤体等の特徴を指標化することにより、浸透に対する堤防危険 |
| 箇所を推定する手法の研究が進められ、堤防の維持管理に活かされ始めてお |
| り、強化に当たっての優先度評価への活用も考えられる。本手法を活用する |
| ことにより、洪水時に河川水位がピークを過ぎて低下しても、なお堤体内裏 |
| のり付近の水位が上昇し堤防の安全度が低下していくことを簡便に表現でき |
| るようになりつつある。また、水位計の高密度化とデータ補完技術の進展に |
| より、河川水位が時間的・空間的に精度高く把握できるようになりつつあり |
| 、これらと組み合わせることにより、流水が堤体に浸透することによる堤防 |
| の安全性の縦断的及び時間的な把握ができるようになるとともに、従来別々 |
| に検討してきた河道と堤防を一連で設計できるようになることにつながる。 |
| >                                                                    |
| > 2）すべり安定計算において浸透圧による有効応力の低下を考慮す        |
| ること及び基礎地盤のパイピングが堤体のすべり破壊を誘発する現象等、堤 |
| 防の破壊及び変形メカニズムの解明につながる取り組みが進められている。 |
| >                                                                    |
| > 3）弾性波探査及び電気探査等                                        |
| の物理探査の研究及び検証が進められており、基礎地盤及び堤防の土質構造 |
| を概略ではあるが三次元的に連続して把握することが可能になりつつある。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

1.  福岡捷二、田端幸輔：堤防破壊危険確率と堤防脆弱性指標に基づく堤防破壊危険タイムラインを用いた被災プロセスの見える化，第4回河川堤防技術シンポジウム，pp.61-64，2016．

```{=html}
<!-- -->
```
6.  福岡捷二、田端幸輔：浸透流を支配する力学指標と堤防浸透破壊の力学的相似条件，土木学会論文集B1(水工学)
    Vol.74，No.5，I\_1435-I\_1440, 2018．

7.  石原雅規、吉田直人、秋場俊一、佐々木哲也：堤防のりすべり事例を対象とした浸透力を考慮した円弧すべりの感度分析，第3回地盤工学から見た堤防技術シンポジウム，pp.76-79，2015．

8.  小高猛司、李圭太：不飽和浸透連成剛塑性有限要素法による河川堤防の安定解析，計算工学講演会論文集，Vol.22，F-03-5，2017．

9.  （公社）物理探査学会：物理探査適用の手引き, 2008．

    1.  []{#_Toc10813355 .anchor}堤防の高さの設定

＜考え方＞

+----------------------------------------------------------------------+
| 堤防は計画高水流                                                     |
| 量以下の流水を越流させないよう設けるべきものであり、堤防の高さの設定 |
| に当たっては、計画高水位（高潮区間においては計画高潮位）を河川砂防技 |
| 術基準計画編の施設配置等計画編により設定する。これに加えて、洪水時及 |
| び高潮時等における風浪、うねり及び跳水等による一時的な水位上昇への対 |
| 応、巡視、水防活動を実施する場合の安全の確保並びに流木等流下物への対 |
| 応等その他の種々の要素をカバーするために、構造令で定める値を構造上の |
| 余裕として加えるものである。また、堤防の高さは、上下流及び左右岸の堤 |
| 防の高さとの整合性が強く求められる。ここで、構造上の余裕は、堤防の構 |
| 造上必要とされる高さの余裕であり、計画上の余裕は含まないものである。 |
|                                                                      |
| また、堤防を設ける場所は一般に地盤条件が                             |
| 悪い箇所が多く、また堤体自体の圧縮もあるため、堤防の沈下は通常避けら |
| れない。そのため、堤防を築造するときには、沈下相当分の高さを余盛とし |
| て構造上の余裕に増高して施工することが一般的である。余盛は、施工上の |
| 配慮として行うものであり、計画上の堤防の高さには含まないものである。 |
|                                                                      |
| 湖沼及び高潮区間の堤防においては、構造令に基づき、計                 |
| 画高水流量に応じて定める構造上の余裕の他、波浪の影響を考慮して高さを |
| 決定することとなる。波浪の影響には、台風等の強風により生じる風浪や沖 |
| 合から来るうねりがある。水面積の大きい湖沼等計画高水流量が定められて |
| いない湖沼の湖岸堤の高さについては、計画高水位（このような湖沼のうち |
| 、例えば浜名湖等、高潮の影響を受ける湖沼の区間にあっては計画高潮位） |
| に波浪の影響を考慮して必要と認められる値を増高するものである。また、 |
| 計画高水流量の定めのない湖岸堤の計画高水位は、湖への流入量と流出量で |
| 定まる平均水位をもとに定めている場合が多いため、風浪に加えて、岸に吹 |
| き寄せられて水位が上昇する吹き寄せ及び副振動（セイシュ）を必要に応じ |
| て考慮する必要がある。なお、高潮堤の場合、吹き寄せ及び副振動（セイシ |
| ュ）による影響は、計画高潮位の設定の際に潮位偏差として含まれている。 |
|                                                                      |
| また、津波区間の堤防に                                               |
| おいては、構造令に基づき、上述の湖沼及び高潮区間の堤防における増高に |
| 加えて、計画津波水位に河口付近の海岸堤防の高さ及び漂流物の影響を考慮 |
| して必要と認められる値を加えた値を下回らないよう設定するものである。 |
|                                                                      |
| その他、支川と本川の合流点に逆流                                     |
| 防止施設（通常は水門）を設けない場合における支川の背水区間の堤防（以 |
| 下「バック堤」という。）については、本川に面する堤防と一連のものとし |
| て同一区域の氾濫を防止する機能を有し、しかも当該区間における洪水の継 |
| 続時間は本川の背水ないし逆流によって本川と同程度若しくはそれ以上であ |
| るため、背水区間の堤防の構造設計においてはこれに留意する必要がある。 |
| そのため、バック堤の堤防の高さは、構造令に基づき少なくとも本川の堤防 |
| の高さを下回ってはならないものである。なお、合流点に逆流防止施設を設 |
| けて本川背水位が支川へ及ぶのをしゃ断できる場合の支川堤防（以下「セミ |
| バック堤」という。）の高さについては本川の計画高水位に支川の計画高水 |
| 流量に応じた構造上の余裕を加算し、自己流堤の高さについては支川の計画 |
| 高水位に支川の計画高水流量に応じた構造上の余裕を加算するものである。 |
+----------------------------------------------------------------------+

＜必　須＞

+----------------------------------------------------------------------+
| 堤防の高さは、河道計画にお                                           |
| いて設定される計画高水位に、構造令で定める値を加えたもの以上とする。 |
|                                                                      |
| 湖沼、                                                               |
| 高潮区間又は津波区間の堤防の高さは、構造令に基づき定めるものとする。 |
+----------------------------------------------------------------------+

＜例　示＞

+----------------------------------------------------------------------+
| 堤内地盤高が計画高水位より高い、いわゆる堀込河道の区間に             |
| あっては、所定の余裕高を持たない低い堤防を計画することがあるが、一般 |
| に計画の規模が小さく、計画を超える洪水の頻度が高い河川の堀込河道の区 |
| 間においては、越水被害を極力小さくする配慮が特に必要となる場合がある |
| 。以下、構造令第20条第1項におけるただし書きの運用について例示する。  |
|                                                                      |
| 1.  掘込河道の場合であっても                                         |
| 、溢流部を特定させるのを避けるため、又は管理用通路の設置や官地の明確 |
| 化等のため、河岸にはある程度の盛土部分があることが望ましい。このよう |
| な場合には、一般に0.6m程度の構造上の余裕を確保するものとされている。 |
|                                                                      |
| 2.  背後地が人家連担地域であ                                         |
| る場合は、計画高水流量に応じ所定の構造上の余裕を確保することが多い。 |
|                                                                      |
| 3.  掘込河道部分に構                                                 |
| 造上の余裕を設けることは築堤河道部分に計画以上の負担を課することとな |
| るので、このような場合には、構造上の余裕を状況に応じ0～0.6mとする。  |
|                                                                      |
| 4.  内水による氾濫の予想さ                                           |
| れる河川において、構造上の余裕のための盛土がかえって内水被害を助長す |
| ると考えられる場合は、構造上の余裕を0～0.6mとする場合が少なくない。  |
|                                                                      |
| この他、小河川については、構                                         |
| 造令第76条及び構造令施行規則第36条第2号に定める小河川の特例がある。  |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  建設省河川局水政課長、治水課長通達：[河川管理施設等構造令及び同令施行規則の運用について](http://www.mlit.go.jp/notice/noticedata/sgml/053/78000112/78000112.html)，昭和52年2月1日，建設省河政発第5号，建設省河治発第6号．

2.  国土交通省水管理・国土保全局：河川砂防技術基準計画編，施設配置計画編，平成30年3月

    （最新版）河川砂防技術基準　計画編，施設配置等計画編,令和7年6月，国土交通省水管理・国土保全局.

3.  国土交通省水管理・国土保全局河川計画課長、治水課長通達：[河川津波対策について](http://www.mlit.go.jp/river/shishin_guideline/kasen/pdf/kasen_tsunami_taisaku_h230902.pdf)，平成23年9月2日，国水河計第20号，国水治第35号．

4.  建設省河川局治水課長通達：[堤防余盛基準について](http://www.mlit.go.jp/notice/noticedata/sgml/058/78000256/78000256.html)，昭和44年1月17日，建設省河治発第3号．

    1.  []{#_Toc13470662 .anchor}断面形状の設定

＜考え方＞

+----------------------------------------------------------------------+
| 計画堤防断面形状の設定に当たっては、まず堤防整備区間を対象           |
| として河道特性又は洪水氾濫区域が同一若しくは類似する区間（以下「一連 |
| 区間」という。）を設定し、堤防の高さ、天端幅及びのり勾配を定める必要 |
| がある。一連区間の境界は、支派川の分合流箇所又は山付き箇所に設定する |
| ことを基本とするが、河川の特性、地形地質、堤内地の状況（地盤高等）及 |
| び想定される氾濫形態等も考慮して分割するものである。また、堤防の断面 |
| 形状は、上下流及び左右岸の堤防の断面形状との整合性が強く求められる。 |
|                                                                      |
| 堤防の高さについては「2.5堤防の高さの設定」に基づき設定する。        |
|                                                                      |
| 天端幅については                                                     |
| 、土堤の場合は浸透水に対して必要な堤防断面幅を確保するためのしかるべ |
| き幅を確保する必要がある他、堤防の天端は管理用通路として使用されるだ |
| けではなく、散策路や高水敷へのアクセス路として広く利用されており、そ |
| れらの機能増進及びバリアフリー化の推進、あるいは洪水時等の巡視、応急 |
| 復旧活動及び水防活動における円滑な車両通行の確保並びに地震災害時等の |
| 河川水利用等を考慮し、構造令に基づき可能な限り広く設けるべきである。 |
|                                                                      |
| また、湖沼、津波区間又は高潮区間の堤防及び特殊堤において             |
| も、日常の河川巡視、洪水・高潮時の河川巡視、水防活動並びに地震発生後 |
| の河川工作物点検等のために、堤防には管理用通路を設ける必要があり、一 |
| 般には管理用通路は堤防天端に設けられることから、天端幅の設定に当たっ |
| ては、管理用通路としての必要最小幅を構造令に基づき設けるものである。 |
|                                                                      |
| その他、バック堤については、構造令に基づき本川の天端                 |
| 幅を下回ってはならないものである。なお、セミバック堤及び自己流堤の天 |
| 端幅については、構造令に基づき支川の計画高水流量に応じて定まる天端幅 |
| が最低基準となり、セミバック堤の天端幅は、当該区間の状況に応じて支川 |
| の堤防の天端幅と本川の堤防の天端幅との間の適切な幅とする必要がある。 |
|                                                                      |
| のり勾配に                                                           |
| ついては、土堤の場合は流水及び降雨の浸透に対して安定させるための視点 |
| から決まるものである他、過去の経験又は実験等から、構造令では2割より  |
| 緩い勾配とし、一定の高さ以上の堤防については必要に応じ小段を設けるこ |
| ととなるが、小段は降雨の浸透をむしろ助長する場合があり、浸透面からみ |
| ると緩やかな勾配の一枚のりとした方が有利なこと、除草等の維持管理面及 |
| び公衆の利用を促進する面からも、のり面は緩やかな勾配が望まれているこ |
| と等を考慮する。のり勾配は構造令から定まる最低限確保すべき断面形状を |
| 包絡するような緩い勾配とした一枚のりの台形断面として設定するが、堤防 |
| のすべり安全性を現状より下回らないという観点から、堤防敷幅は最低でも |
| 小段を有する断面とした場合の敷幅より狭くならないようにする。ただし、 |
| 従来より小段を設ける計画がないような高さの低い堤防に関してはこの限り |
| ではない。また、既存堤防において小段が兼用道路として利用されている等 |
| の理由から一枚のりにすることが困難な場合には、必ずしも一枚のりとする |
| 必要はないが、雨水排水が適確に行われるよう対処することが必要である。 |
|                                                                      |
| また、堤防の安                                                       |
| 定を図るため必要がある場合には、堤防の裏側に側帯を設けることとなる。 |
|                                                                      |
| なお、既設の堤                                                       |
| 防の拡築又は新堤の整備において段階的に築造する場合は、計画堤防断面形 |
| 状の高さと段階的な整備における堤防の高さとの差に相当する値を計画高水 |
| 位から差し引いた高さの水位を計画高水位とみなして、この節の規定を適用 |
| することとなる。その際、必要な高さのみを有し計画堤防断面形状の天端幅 |
| やのり勾配が不足した堤防（いわゆるカミソリ堤）は設けるべきではない。 |
+----------------------------------------------------------------------+

＜必　須＞

+------------------------------------------------------------------------+
| > 土堤の断面形状は、計画堤防断面形状を設定し、これを有するものとする。 |
+------------------------------------------------------------------------+

＜標　準＞

+------------------------------------------------------+
| > 計画堤防断面形状ののり面は、一枚のりを基本とする。 |
+------------------------------------------------------+

＜推　奨＞

  -----------------------------------------------------------------------------------------------------------
  堤防のり面は表裏のりともにのり勾配が3割より緩い勾配とし、一枚のりの台形断面として設定することが望ましい。
  -----------------------------------------------------------------------------------------------------------

＜関連通知等＞

1.  建設省河川局水政課長、治水課長通達：[河川管理施設等構造令及び同令施行規則の運用について](http://www.mlit.go.jp/notice/noticedata/sgml/053/78000112/78000112.html)，昭和52年2月1日，建設省河政発第5号，建設省河治発第6号．

2.  建設省河川局水政課長、河川計画課長，治水課長通達：[河川管理施設等構造令及び同令施行規則の運用について](http://www.mlit.go.jp/notice/noticedata/sgml/054/78000120/78000120.html)，平成11年10月15日，建設省河政発第74号，建設省河計発第83号，建設省河治発第39号．

3.  河川管理技術研究会編：[改訂　解説・工作物設置許可基準](http://www.jice.or.jp/cms/kokudo/pdf/tech/material/kousakubutusecchi.pdf)，第10章
    > 橋，第12章 道路，第13章
    > 自転車歩行者専用道路，（財）国土技術研究センター，1998．

    1.  []{#_Toc10813357 .anchor}安全性能の照査等

        1.  []{#_Toc13470664 .anchor}設計の対象とする状況と作用

＜考え方＞

+----------------------------------------------------------------------+
| 安全性能の照査は、常時、洪水時                                       |
| 、地震時、高潮時及び風浪時について実施する。常時、洪水時及び地震時に |
| ついては全ての堤防において照査する必要があるが、これに加えて、高潮堤 |
| の場合には高潮時、湖岸堤の場合には風浪時について照査するものとする。 |
|                                                                      |
| 設計の対象とする作用については、自重として                           |
| 堤体の自重、計画高水位（高潮区間においては計画高潮位）以下の水位の流 |
| 水の通常の作用として流水による侵食及び浸透、降雨による浸透、地震動と |
| して河川構造物の供用期間中に発生する確率が高い地震動（以下「レベル1  |
| 地震動」という。）及び対象地点において現在から将来にわたって考えられ |
| る最大級の強さを持つ地震動（以下「レベル2地震動」という。）並びにそ  |
| の他の作用として土圧、水圧の他、常時には降雨の影響、地震時には必要に |
| 応じて津波による侵食及び越波、高潮時には波浪による侵食及び越波並びに |
| 風浪時には風浪による侵食及び越波並びに吹き寄せによる水位上昇等が考え |
| られ、設計の対象とする堤防の状況に応じて適切に組み合わせて設定する。 |
|                                                                      |
| 常時に対象とす                                                       |
| る作用の組合せは、自重及びその他の作用（土圧、水圧、降雨等）とする。 |
|                                                                      |
| 洪水時に対象とする作用の組合せ                                       |
| は、自重、計画高水位（高潮区間においては計画高潮位）以下の水位の流水 |
| の通常の作用、降雨による浸透及びその他の作用（土圧、水圧等）とする。 |
|                                                                      |
| 地震時に対象とする作用の組合せは、自重、地震動及びその他の           |
| 作用（土圧、水圧並びに必要に応じて津波による侵食及び越波等）とする。 |
|                                                                      |
| 高潮時に対象と                                                       |
| する作用の組合せは、その他の作用（波浪による侵食及び越波等）とする。 |
|                                                                      |
| 風浪時に対象とする作用の組合せは、その他の作用（風浪による侵食及     |
| び越波並びに吹き寄せ及び副振動（セイシュ）による水位上昇等）とする。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 安全性能の照査に当                                                   |
| たっては、設計の対象とする状況と作用を次の表のように設定し、これを踏 |
| まえて安全性能の照査事項を設定することを基本とする。常時、洪水時及び |
| 地震時については全ての堤防において設定し、これに加えて、高潮堤の場合 |
| には高潮時、湖岸堤の場合には風浪時について設定することを基本とする。 |
|                                                                      |
| +------------+--------------------------------------------------+    |
| | 堤防の状況 | 作用                                             |    |
| +============+==================================================+    |
| | 常時       | 自重                                             |    |
| |            |                                                  |    |
| |            | その他の作用（土圧、水圧、降雨等）               |    |
| +------------+--------------------------------------------------+    |
| | 洪水時     | 自重                                             |    |
| |            |                                                  |    |
| |            | 計画高水位（高潮区間に                           |    |
| |            | おいては計画高潮位）以下の水位の流水の通常の作用 |    |
| |            |                                                  |    |
| |            | 降雨による浸透                                   |    |
| |            |                                                  |    |
| |            | その他の作用（土圧、水圧等）                     |    |
| +------------+--------------------------------------------------+    |
| | 地震時     | 自重                                             |    |
| |            |                                                  |    |
| |            | 地震動                                           |    |
| |            |                                                  |    |
| |            | その他の作用（土                                 |    |
| |            | 圧、水圧、必要に応じて津波による侵食及び越波等） |    |
| +------------+--------------------------------------------------+    |
| | 高潮時     | その他の作用（波浪による侵食及び越波等）         |    |
| +------------+--------------------------------------------------+    |
| | 風浪時     | そ                                               |    |
| |            | の他の作用（風浪による侵食及び越波、必要に応じて |    |
| |            | 吹き寄せ及び副振動（セイシュ）による水位上昇等） |    |
| +------------+--------------------------------------------------+    |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  国土交通省水管理・国土保全局：[河川構造物の耐震性能照査指針・解説―Ⅱ.堤
    防
    編―](http://www.mlit.go.jp/river/shishin_guideline/bousai/wf_environment/structure/pdf/ref02-2.pdf)，平成28年3月．

2.  国土交通省水管理・国土保全局河川計画課長、治水課長通達：[河川津波対策について](http://www.mlit.go.jp/river/shishin_guideline/kasen/pdf/kasen_tsunami_taisaku_h230902.pdf)，平成23年9月2日，国水河計第20号，国水治第35号．

    1.  []{#_Toc10813359 .anchor}土堤の安全性能の照査

```{=html}
<!-- -->
```
1.  安全性能の照査事項

＜考え方＞

+----------------------------------------------------------------------+
| 土堤における安全性能の照査に当たっては、以下                         |
| の安全性能毎に、照査条件として適切な河川の水位（波形）を設定の上、作 |
| 用に対して安全性能を満足するように設計する必要がある。（表2-1参照）  |
|                                                                      |
| 1.  常時の健全性の照査                                               |
|                                                                      |
| > 新堤の築造又は既設堤防の嵩上げ若しくは                             |
| 腹付けを軟弱地盤上に行う場合は、基礎地盤の強度不足によるすべり破壊又 |
| は基礎地盤の圧縮性が大きいことによる過大な沈下が生じ、洪水等の外力に |
| よる作用を受けずとも、堤防の自重により堤防の健全性が損なわれる可能性 |
| があるため、常時の健全性の照査を行う必要がある。さらには堤防の自重に |
| より盛土側方地盤の沈下、隆起及び側方変位等を生じ周辺地盤に影響を与え |
| る可能性もあるため、必要に応じて周辺地盤への影響について照査を行う。 |
| >                                                                    |
| > 常時の健全性の照査として                                           |
| は、常時のすべり破壊に対する安定の照査、沈下の照査を行うものである。 |
| >                                                                    |
| > 照査を行う際の河川水位は、通常想定される水位とする。               |
| なお、沈下等に伴う降雨排水の集中により、雨裂（以下「ガリ」という。） |
| が生じる可能性があるため、雨水排水の集中状況の確認を行う必要がある。 |
|                                                                      |
| 2.  耐侵食性能の照査                                                 |
|                                                                      |
| > 計画高水位（高潮区間においては計画高潮位）以下の水位の流水の       |
| 通常の作用による土堤の侵食については、流水のせん断力による堤体表面の |
| 直接侵食及び洗掘、洪水時の主流路の移動による側方侵食並びに護岸及び水 |
| 制等の洗掘被災が生じる可能性がある。これらの現象によって計画高水位（ |
| 高潮区間においては計画高潮位）以下の水位の流水の通常の作用に対し安全 |
| な機能が失われる可能性があるため、耐侵食性能の照査を行うものである。 |
| >                                                                    |
| > 照査を行う際の河川水位は、計画高水位（高潮区間におい               |
| ては計画高潮位）とし、中小洪水時の河岸の耐侵食性能の検討等に当たって |
| は、必要に応じてそれ以下の規模の洪水時の水位設定を加える必要がある。 |
|                                                                      |
| 3.  耐浸透性能の照査                                                 |
|                                                                      |
| > 計画高水位（高潮区間においては                                     |
| 計画高潮位）以下の水位の流水の通常の作用による土堤の浸透については、 |
| 基礎地盤及び堤体への流水及び降雨の浸透により土のせん断強度が低下し、 |
| 堤防のすべり破壊に対する安全性が低下する。また、浸透水の動水勾配が大 |
| きくなると、浸透力により土粒子が移動して、パイピング破壊が発生する可 |
| 能性がある。これらの破壊現象によって、計画高水位（高潮区間においては |
| 計画高潮位）以下の水位の流水の通常の作用及び降雨による浸透に対し安全 |
| な機能が失われる可能性があるため、耐浸透性能の照査を行うものである。 |
| >                                                                    |
| > 照査を行う際の河川水位は、計画降雨に基づき設定した水位波形とする。 |
|                                                                      |
| 4.  耐震性能の照査                                                   |
|                                                                      |
| > 地震動の作用による基礎地盤及び堤体の液状化に                       |
| より堤防が沈下することによって流水が堤内地に侵入し、被害が発生する可 |
| 能性があるため、地震動の作用により堤防に沈下が生じた場合においても、 |
| 河川の流水の河川外への越流を防止する機能を保持することを照査するもの |
| である。なお、津波区間においては沈下後の堤防に対し計画津波の遡上によ |
| り流水が河川外へ越流することを防止する機能を保持することを照査する。 |
| >                                                                    |
| > 照査を行う際の河川水位は、通常想定される水位とする。               |
|                                                                      |
| 5.  波浪等に対する安全性の照査                                       |
|                                                                      |
| > 高潮時及び風浪時の波浪並びに計画津                                 |
| 波水位以下の津波に伴い、堤防表のり面における波の打ち寄せによる侵食に |
| 加え場合によっては堤内地への越波を生じ、堤内地の浸水及び堤防裏のり面 |
| が洗堀することにより堤防の安全性が損なわれる可能性があるため、侵食及 |
| び越波に対する確認及び照査を行うものである。確認及び照査を行う際の河 |
| 川水位は、高潮時は計画高潮位、風浪時は計画高水位又は風浪が最も発達す |
| る時の河川水位が計画高水位より低いことが明らかな場合には、必要に応じ |
| て風浪が最も発達する時の河川水位又は津波発生時は計画津波水位とする。 |
| >                                                                    |
| > なお、風浪時に                                                     |
| おいて湖沼の流入量と流出量の収支で河川水位を評価する場合には、吹き寄 |
| せ及び副振動（セイシュ）による水位上昇の影響を必要に応じて考慮する。 |
|                                                                      |
| 1.  土堤の安全性能の照査項目と設計の対象とする作用及び河川水位       |
|                                                                      |
| +------------+----------------+----------------+----------------+    |
| | 堤防の状況 | 照査項目       | 作用           | 河川水位       |    |
| +============+================+================+================+    |
| | 常時       | 常時の健       | 自重           | 通常           |    |
| |            | 全性（常時のす |                | 想定される水位 |    |
| |            | べり破壊に対す | その他         |                |    |
| |            | る安定、沈下） | の作用（土圧、 |                |    |
| |            |                | 水圧、降雨等） |                |    |
| |            | 雨水           |                |                |    |
| |            | 排水による侵食 |                |                |    |
| +------------+----------------+----------------+----------------+    |
| | 洪水時     | 耐侵           | 自重           | （侵食         |    |
| |            | 食性能（直接侵 |                | 作用）計画高水 |    |
| |            | 食、側方侵食） | 計画高水       | 位及び必要に応 |    |
| |            |                | 位（高潮区間に | じそれ以下の規 |    |
| |            | 耐浸           | おいては計画高 | 模の洪水時水位 |    |
| |            | 透性能（すべり | 潮位）以下の水 |                |    |
| |            | 、パイピング） | 位の流水の通常 | （浸透         |    |
| |            |                | の作用（侵食作 | 作用）計画降雨 |    |
| |            |                | 用、浸透作用） | 波形に基づき設 |    |
| |            |                |                | 定した水位波形 |    |
| |            |                | 降雨による浸透 |                |    |
| |            |                |                |                |    |
| |            |                | その他の作用（ |                |    |
| |            |                | 土圧、水圧等） |                |    |
| +------------+----------------+----------------+----------------+    |
| | 地震時     | 耐震性能（液状 | 自重           | 通常           |    |
| |            | 化による沈下） |                | 想定される水位 |    |
| |            |                | 地震動         |                |    |
| |            |                |                | （津波によ     |    |
| |            |                | その他の       | る侵食及び越波 |    |
| |            |                | 作用（土圧、水 | ）計画津波水位 |    |
| |            |                | 圧、必要に応じ |                |    |
| |            |                | て津波による侵 |                |    |
| |            |                | 食及び越波等） |                |    |
| +------------+----------------+----------------+----------------+    |
| | 高潮時     | 波浪等に       | その他の作用   | 計画高潮位     |    |
| |            | 対する安全性（ | （波浪による侵 |                |    |
| |            | 侵食及び越波） | 食及び越波等） |                |    |
| +------------+----------------+----------------+----------------+    |
| | 風浪時     |                | その他の作用   | 計画高水位     |    |
| |            |                | （風浪による侵 |                |    |
| |            |                | 食及び越波等） | 又は風         |    |
| |            |                |                | 浪が最も発達す |    |
| |            |                |                | る時の河川水位 |    |
| +------------+----------------+----------------+----------------+    |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 土堤における安全性能については、計画堤                               |
| 防断面形状を有することを前提に、安全性能として「2.7.1設計の対象とす  |
| る状況と作用」に対し、以下の性能を設定し、照査することを基本とする。 |
|                                                                      |
| 1.  常時の健全性                                                     |
|                                                                      |
| 2.  耐侵食性能                                                       |
|                                                                      |
| 3.  耐浸透性能                                                       |
|                                                                      |
| 4.  耐震性能                                                         |
|                                                                      |
| 5.  波浪等に対する安全性                                             |
|                                                                      |
| 照査の結果、                                                         |
| 安全性能を満足しない場合には、強化工法の検討を行うことを基本とする。 |
|                                                                      |
| 照査手法は、これまでの経験及び実績から妥当と見なせる                 |
| 方法又は当該河川若しくは類似河川で被災等の実態を再現できる論理的に妥 |
| 当性を有する方法等、適切な知見に基づく手法を用いることを基本とする。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  国土交通省水管理・国土保全局：[河川構造物の耐震性能照査指針・解説―Ⅱ.堤
    防
    編―](http://www.mlit.go.jp/river/shishin_guideline/bousai/wf_environment/structure/pdf/ref02-2.pdf)，平成28年3月．

```{=html}
<!-- -->
```
2.  国土交通省水管理・国土保全局河川計画課長、治水課長通達：[河川津波対策について](http://www.mlit.go.jp/river/shishin_guideline/kasen/pdf/kasen_tsunami_taisaku_h230902.pdf)，平成23年9月2日，国水河計第20号，国水治第35号．

3.  （財）国土技術研究センター：河川土工マニュアル，[第2章
    河川土工のための調査](http://www.jice.or.jp/cms/kokudo/pdf/tech/material/dokouh21_02.pdf)
    第2.1節 基礎地盤調査，2009．

4.  （財）国土技術研究センター：[河川堤防の構造検討の手引き（改訂版）](http://www.jice.or.jp/cms/kokudo/pdf/tech/material/teibou_kouzou02.pdf)，第4章
    浸透に対する堤防の構造検討，第5章 侵食に対する堤防の構造検討，2012．

5.  （財）国土技術研究センター：改訂 護岸の力学設計法，第4章
    護岸の力学的安定性の照査に用いる設計条件，2007

    （最新版）（一財）国土技術研究センター：改訂 護岸の力学設計法，第4章
    護岸の力学的安定性の照査に用いる設計条件，2023.

```{=html}
<!-- -->
```
2.  常時の健全性に対する照査

```{=html}
<!-- -->
```
1.  常時のすべり破壊に対する安定の照査

＜考え方＞

+----------------------------------------------------------------------+
| 軟弱地盤においては、図2-1に示すように盛                              |
| 土高が高くなるにつれ沈下量及び隆起量は増大し、盛土荷重によるせん断力 |
| が基礎地盤のせん断抵抗を超えた場合、すべり面に沿って盛土は破壊する。 |
|                                                                      |
| 新堤の築                                                             |
| 造又は既設堤防の嵩上げ若しくは腹付けを行う場合で、それが軟弱地盤上に |
| 位置する場合には、常時のすべり破壊に対する安定を確認する必要がある。 |
|                                                                      |
| 軟弱地盤でない場合には、適切な施工が行われることを前                 |
| 提に、常時のすべり破壊に対する安定の照査を省略できることとしている。 |
|                                                                      |
| なお、軟弱地盤の判定を行う際には河川土工マニュアルが参考となる。     |
|                                                                      |
| > ![](media/image1.emf){width="5.138482064741908in"                  |
| > height="2.0722222222222224in"}                                     |
|                                                                      |
| 1.  図2-1　基準地点模式図                                            |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 常時のすべり破壊に対する安定の照査は、すべり安全率等の許容値を設定し |
| た上で、基礎地盤及び堤体の土質等を考慮し、自重によるすべり破壊に対す |
| る安全率等を評価し、許容値を満足することを照査することを基本とする。 |
|                                                                      |
| なお、実績等から軟弱地盤でない場合には、照査は省略できる。           |
+----------------------------------------------------------------------+

＜参考となる資料＞

1.  （財）国土技術研究センター：河川土工マニュアル，[第3章
    河川土工の設計](http://www.jice.or.jp/cms/kokudo/pdf/tech/material/dokouh21_03.pdf)
    第3.2 節 軟弱地盤対策 3.2.2 軟弱地盤の安定，2009．

```{=html}
<!-- -->
```
2.  沈下の照査

＜考え方＞

+----------------------------------------------------------------------+
| 軟弱地盤においては、図2-2に示すように盛土の載荷に                    |
| 伴い、圧密により盛土の直下及び側方の基礎地盤に沈下が生じる。沈下を生 |
| じると堤防の健全性が損なわれる可能性があるため、沈下に対する照査を行 |
| う。さらには、基礎地盤の圧密沈下が大きくなると、周辺の地盤も一緒に沈 |
| 下する現象（引き込み沈下と呼ばれる）が生じるため、周辺の土地利用と軟 |
| 弱地盤の程度に応じて、周辺地盤への影響についても検討する必要がある。 |
|                                                                      |
| 堤防の沈下に対しては、余盛り高等                                     |
| を考慮して、沈下に対する許容値を設定し、これを超えないことを照査する |
| ものである。また、引き込み沈下に対しては、周辺への影響を考慮して堤内 |
| 地地盤変形の許容値を設定し、これを超えないことを照査するものである。 |
|                                                                      |
| 軟弱地盤でない場合には、盛土自体の圧縮が沈下の多くを占めることと     |
| なり、実績等によると沈下量が標準的な余盛り高の範囲内に収まることから |
| 、適切な施工が行われることを前提に、照査を省略できることとしている。 |
|                                                                      |
| > ![](media/image2.emf){width="5.617433289588801in"                  |
| > height="1.8359011373578302in"}                                     |
|                                                                      |
| 2.  図2-2　堤防の自重による沈下                                      |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 沈下の照査は、余盛り高を考慮した沈下                                 |
| 量等の許容値を設定した上で、基礎地盤の圧密及び盛土の圧縮を考慮した沈 |
| 下等の変形を評価し、許容値を満足することを照査することを基本とする。 |
|                                                                      |
| なお、実績等から軟弱地盤でない場合には、照査は省略できる。           |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  （財）国土技術研究センター：河川土工マニュアル，[第3章
    河川土工の設計](http://www.jice.or.jp/cms/kokudo/pdf/tech/material/dokouh21_03.pdf)
    第3.2 節 軟弱地盤対策 3.2.2 軟弱地盤の安定，2009．

```{=html}
<!-- -->
```
6.  建設省河川局治水課長通達：[堤防余盛基準について](http://www.mlit.go.jp/notice/noticedata/sgml/058/78000256/78000256.html)，昭和44年1月17日，建設省河治第3号．

```{=html}
<!-- -->
```
3.  その他留意事項

＜考え方＞

+----------------------------------------------------------------------+
| 堤防天端は､降雨の堤体への浸透抑制、河川巡視の効率化                  |
| 及び河川利用の促進等の観点から、河川環境上の支障を生じる場合等を除い |
| て、舗装されていることが望ましいが、不同沈下等によって堤防の高さに不 |
| 陸を生じた箇所又は橋梁の取り付け部等で縦断勾配が変化している箇所等に |
| おいては、雨水排水の集中を生じやすく、堤防のり面のガリ及びのり崩れ又 |
| はのり肩の破損等が発生することがある。したがって、このような現象が発 |
| 生する恐れのある箇所に対して雨水排水の集中状況を確認するものである。 |
|                                                                      |
| なお、舗装後の堤防の                                                 |
| 沈下又は路盤の補修による天端形状の変化等に伴い、雨水に関する同様の問 |
| 題が生じることもあるため、適切な維持管理が行われることが重要である。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| > その他雨水排水の集中によりガリ及びの                               |
| り崩れ等の発生を助長しない天端及びのり面の形状であることを確認する。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  建設省河川局水政課長、河川計画課長、治水課長通達：[河川管理施設等構造令及び同令施行規則の運用について](http://www.mlit.go.jp/notice/noticedata/sgml/054/78000120/78000120.html)，平成11年10月15日，建設省河政発第74号，建設省河計発第83号，建設省河治発第39号．

2.  建設省河川局治水課長通達：[堤防余盛基準について](http://www.mlit.go.jp/notice/noticedata/sgml/058/78000256/78000256.html)，昭和44年1月17日，建設省河治発第3号．

```{=html}
<!-- -->
```
3.  耐侵食性能の照査

＜考え方＞

+----------------------------------------------------------------------+
| 耐侵食性能の照査は、堤防表のり面及びのり尻表面の直接侵               |
| 食と、主流路（低水路）からの側方侵食及び洗掘に対して行うものである。 |
|                                                                      |
| 直接侵食については                                                   |
| 、被災実績から直接侵食が生じる堤防前面の流速を把握することが重要であ |
| る。堤防前面の流速の算定に当たっては、河道の平面形及び縦横断形、床止 |
| め及び水制の配置並びに堤防近傍の樋門、樋管及び橋脚の影響を考慮する。 |
|                                                                      |
| 側方侵食については、河川定期縦横断測量成果及び航空写真等を用いて、澪 |
| 筋の位置の経年変化及び水衝部の位置の変化を把握することが重要である。 |
|                                                                      |
| 洗掘については、河川定期縦横断測量成果等を用いて、最深               |
| 河床高の縦断図及びその変化並びにこれら縦断図を重ね合わせ包絡すること |
| で確認できる最も洗掘された河床高の縦断図を把握することが重要である。 |
+----------------------------------------------------------------------+

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  耐侵食性能の照査は、過去の被災実績、護岸の設置状況及び堤防前面の高水敷幅等を踏まえた堤防のり面の侵食限界流速又は高水敷の侵食量等の許容値を設定した上で、河道の平面形及び縦横断形等を考慮し、洪水時の作用による流速又は侵食量等を評価し、許容値を満足することを照査することを基本とする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜例　示＞

+----------------------------------------------------------------------+
| 耐侵食性能の照査に当たって、照査外力として堤防前面                   |
| の流速を設定する手法がある。洪水時の堤防前面の流速の算定に当たっては |
| 、マニングの平均流速公式若しくは一次元不等流解析で求めた平均流速に湾 |
| 曲等による補正係数を乗じて算出する手法及び準二次元不等流計算若しくは |
| 平面二次元流解析等によって堤防前面の流速を直接算出する手法等がある。 |
|                                                                      |
| 洪水時に侵食される高水敷                                             |
| 幅の設定に当たっては、河川定期縦横断測量成果及び航空写真等を用いて、 |
| 一洪水で侵食される高水敷幅を横断測線毎に調べ、それらの縦断分布図を作 |
| 成した上で、例えばセグメント毎に侵食幅の最大値を設定する方法がある。 |
|                                                                      |
| 最大洗掘深の設定に当たっては、河川定期縦横断測量成果                 |
| 等を用いて、最深河床高の縦断図を作成し、過去に記録された縦断図を重ね |
| 合わせることで、最も洗掘された河床高の縦断図から設定する方法がある。 |
|                                                                      |
| また、洪水時に侵食される高水敷幅及び最大洗掘深については、平面二次   |
| 元河床変動計算又は準三次元河床変動計算によって算定することもできる。 |
|                                                                      |
| 耐侵食性能の照査における許容値の設定には以下が考えられる。           |
|                                                                      |
| 1.  堤防表のり面及びのり尻の直接侵食について                         |
|                                                                      |
| > 堤防表面の侵食耐力＞堤防前面の流速                                 |
|                                                                      |
| 2.  主流路（低水路等）からの側方侵食について                         |
|                                                                      |
| > 現況の高水敷幅＞一洪水で侵食される高水敷幅                         |
|                                                                      |
| 3.  洗掘について                                                     |
|                                                                      |
| > 堤防前面の基礎工の根入れ高＞一洪水で洗掘される河床高               |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  （財）国土技術研究センター：[河川堤防の構造検討の手引き（改訂版）](http://www.jice.or.jp/cms/kokudo/pdf/tech/material/teibou_kouzou02.pdf)，第5章
    侵食に対する堤防の構造検討，2012．

2.  多自然川づくり研究会編：多自然型川づくりポイントブックⅢ，（財）リバーフロント整備センター，2011．

3.  （一財）国土技術研究センター：[改訂
    護岸の力学設計法](https://www.jice.or.jp/tech/material/detail/21)，第
    4 章 護岸の力学的安定性の照査に用いる設計条件，2023．

4.  （財）国土技術研究センター：[河道計画検討の手引き](http://www.jice.or.jp/cms/kokudo/pdf/tech/material/kadoukeikaku.pdf)，第8章
    河道の平面計画，2002．

```{=html}
<!-- -->
```
4.  耐浸透性能の照査

＜考え方＞

+----------------------------------------------------------------------+
| 堤防の浸透破壊には                                                   |
| 、大きく分けてすべり破壊とパイピング破壊がある。すべり破壊は降雨や流 |
| 水が堤体内の浸潤面を上昇させて、土のせん断強度が低下することにより生 |
| じ、パイピング破壊は、主に堤内側のり尻の基礎地盤付近の動水勾配が増加 |
| して発生する漏水や噴砂に起因し、それが拡大進行することにより生じる。 |
|                                                                      |
| 浸透破                                                               |
| 壊に至る初期の変形として、すべり破壊ではのり面若しくは小段の亀裂、陥 |
| 没若しくははらみだし又は裏のりからの漏水若しくは裏のり尻付近の泥濘化 |
| 等が生じ、パイピング破壊では裏のり尻又は裏のり尻付近の基礎地盤におい |
| て漏水、噴砂若しくは盤ぶくれ並びに堤体の亀裂若しくは陥没等が生じる。 |
|                                                                      |
| 計画高水位（高潮                                                     |
| 区間においては計画高潮位）以下の水位の流水による浸透及び降雨による浸 |
| 透に対する安全性能の照査としては、すべり破壊及びパイピング破壊に対す |
| る安全率等の許容値を設定し、これを超えないことを照査するものである。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| > 耐浸透性能の照査は、すべり破壊及びパイピング                       |
| 破壊に対する安全率等の許容値を設定した上で、水位波形、降雨波形並びに |
| 基礎地盤及び堤体の土質等を考慮し、すべり破壊及びパイピング破壊に対す |
| る安全率等を評価し、許容値を満足することを照査することを基本とする。 |
+----------------------------------------------------------------------+

＜例　示＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  耐浸透性能の照査に当たって、一連区間を細分区間に分割し、区間内において代表断面を設定し、のり面のすべり破壊とパイピング破壊について照査を行う手法がある。この場合、当該区間の降雨特性及び地下水位を初期条件として設定するとともに、堤体の土質構造及び土質定数を調査に基づいて適切に設定し、外力として降雨波形及び水位波形を与えて、浸透流計算と円弧すべり法による安定解析を用いて安全性を評価する等の手法がある。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1.  （財）国土技術研究センター：[河川堤防の構造検討の手引き（改訂版）](http://www.jice.or.jp/cms/kokudo/pdf/tech/material/teibou_kouzou02.pdf)，第4章
    浸透に対する堤防の構造検討，2012．

＜例　示＞

+----------------------------------------------------------------------+
| 基礎地盤等の土質を考慮する                                           |
| 際、浸透に対する安全性能に影響を与えやすい基礎地盤を以下に例示する。 |
|                                                                      |
| > 浸透が特に問題となる基礎地盤では、土質構成として                   |
| 透水性の異なる土質が複雑に分布する場合が多くみられる。透水性地盤にお |
| いて裏のり尻下に粘性土等の難透水層が分布していると、いわゆる行き止り |
| 地盤を形成し、基礎地盤の浸透水が難透水層で行き止まり、堤体内へ上昇す |
| ることで堤体内の浸潤面を押し上げ、漏水又はすべり破壊が発生しやすくな |
| る場合がある。（図2-3参照）また、裏のり尻近傍の難透水層が薄い場合に  |
| は、基礎地盤からの漏水やパイピング破壊が発生しやすくなる場合がある。 |
| >                                                                    |
| > ![p027\_3-2-2](media/image3.png){width="5.3597222222222225in"      |
| > height="3.6902777777777778in"}                                     |
| >                                                                    |
| > 図2-3　行き止まり型地盤の例                                        |
|                                                                      |
| このような基礎地盤条件を                                             |
| 有する箇所の有無は、堤防縦断方向の調査結果のみで類推することは一般的 |
| には難しいが、「治水地形分類図」や「土地分類図」等から類推し、詳細な |
| 調査を実施することにより判断できる場合もある。いずれにせよ堤防縦断方 |
| 向の調査において透水性地盤であることが確認され、かつ相対的に透水性の |
| 低い比較的薄い土層が表層付近に存在するような地盤又は行き止まり地盤は |
| 、浸透に対しては条件の厳しい箇所と判断して差し支えがない場合が多い。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  （財）国土技術研究センター：[河川堤防の構造検討の手引き（改訂版）](http://www.jice.or.jp/cms/kokudo/pdf/tech/material/teibou_kouzou02.pdf)，第3章
    設計のための調査 3.2 浸透に対する構造検討のための調査，2012．

2.  独立行政法人土木研究所地質・地盤研究グループ土質・振動チーム：[河川堤防の浸透に対する照査・設計のポイント](https://www.pwri.go.jp/team/smd/pdf/syousasekkei_point1306.pdf)，2013．

```{=html}
<!-- -->
```
5.  耐震性能の照査

＜考え方＞

+----------------------------------------------------------------------+
| 耐震性能の照査は、「河川構                                           |
| 造物の耐震性能照査指針」（以下「耐震性能照査指針」という。）に基づき |
| 、実施するものである。地震による堤防の被災は、液状化に起因するものが |
| ほとんどであるため、地震動により土堤が沈下し、流水又は計画津波等が堤 |
| 内地に侵入することによって浸水が発生するか否かを照査するものである。 |
|                                                                      |
| 照査に当た                                                           |
| っては、地震後の堤防の高さ等の許容値を設定し、地震変形後の堤防の高さ |
| 等がこれを下回らないことを確認する。照査において考慮する河川水位とし |
| ては、地震と洪水が同時に生起することは極めてまれであるため、原則とし |
| て平常時の最高水位とするが、河口部付近の場合は朔望平均満潮位及び波浪 |
| の影響を考慮し、津波の遡上が予想される場合は計画津波水位を考慮する。 |
|                                                                      |
| なお、レベル                                                         |
| 1地震動とレベル2地震動を受けた場合の土堤の変形、沈下等の損傷状況は異 |
| なるが、土堤の耐震性能の照査においては、レベル1地震動とレベル2地震動 |
| のうち厳しい結果を与えるレベル2地震動のみを考慮することとしている。  |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| > 耐震性能の照査は、平常時の流水又は計画津波等が越流しないよ         |
| うな地震後の堤防の高さ等の許容値を設定した上で、地震動による堤体変形 |
| 後の高さ等を評価し、許容値を満足することを照査することを基本とする。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  国土交通省水管理・国土保全局：[河川構造物の耐震性能照査指針・解説―Ⅱ.堤
    防
    編―](http://www.mlit.go.jp/river/shishin_guideline/bousai/wf_environment/structure/pdf/ref02-2.pdf)，平成28年3月．

```{=html}
<!-- -->
```
7.  国土交通省水管理・国土保全局治水課：[河川堤防の耐震点検マニュアル](http://www.mlit.go.jp/river/shishin_guideline/bousai/wf_environment/structure/pdf/ref06-20160331.pdf)，平成28年3月．

8.  国土交通省水管理・国土保全局治水課課長補佐事務連絡：河川構造物の耐震性能照査における優先度の考え方について（通知），平成25年2月8日．

9.  （財）国土技術研究センター：[河川構造物の耐震性能照査において考慮する河川における平常時の最高水位の算定の手引き（案）](https://www.jice.or.jp/cms/kokudo/pdf/tech/material/harou.pdf)，2007．

```{=html}
<!-- -->
```
6.  波浪等に対する安全性の照査

＜考え方＞

+----------------------------------------------------------------------+
| 波浪の影響については、高潮時の波によるうねり及び風浪又は湖沼における |
| 風浪等による侵食及び越波について検討を行うものであり、地形による波浪 |
| の増幅及び減衰、波浪の方向、屈折、回折、反射、消波及び越波の他、堤防 |
| の構造（のり勾配又は波返工の有無等）、堤内地の利用状況（将来を含む） |
| 及び海岸等関連する他事業との調整等についても十分な配慮が必要となる。 |
|                                                                      |
| 設計の対象とする湖沼における風による吹き寄せ及び風浪について         |
| は、過去の風速、風向及び水位の実績をもとにして検討を行うものである。 |
|                                                                      |
| 津波は                                                               |
| 、水位上昇の継続時間が短く浸透を考慮する必要はないが、大きな流速と流 |
| 速の変動を伴うため堤体への侵食作用に対する配慮が必要となる等、洪水や |
| 高潮とは異なる外力である。また、堤防の高さと計画津波水位との差、計画 |
| 津波の特性等を勘案し、津波による越波の可能性にも配慮する必要がある。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 波浪又は津波の影響を著しく受ける堤防についての波浪又は津             |
| 波による侵食に対する安全性の確認は、高潮時は計画高潮位、風浪時は計画 |
| 高水位又は風浪が最も発達する時の河川水位以下の流水による堤体への侵食 |
| 、津波発生時は計画津波水位以下の津波による堤体への侵食に対して、過去 |
| の被災実績等を考慮し安全が確保されることを確認することを基本とする。 |
|                                                                      |
| 波浪の影響を著しく                                                   |
| 受ける堤防についての波浪による越波に対する安全性の照査は、堤内地の利 |
| 用及び堤防の被災等を考慮した越波量等の許容値を設定した上で、堤防の断 |
| 面形状を考慮した計画高潮位等と設計の対象とする波浪によるうちあげ高及 |
| び越波量等を評価し、許容値を満足することを照査することを基本とする。 |
|                                                                      |
| 津波の影響を著し                                                     |
| く受ける堤防についての津波による越波に対する安全性の確認は、堤防の高 |
| さと計画津波水位との差、計画津波の特性等を確認することを基本とする。 |
+----------------------------------------------------------------------+

＜例　示＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  波浪等に対する安全性の照査は、高潮時又は風浪時に、堤防が越波による損傷を生じないこと（計画高潮位等＋波浪による有義波のうちあげ高≦堤防の高さ、越波量≦許容越波量）等により許容値を設定し、設計の対象とする波浪によるうちあげ高又は越波量等がこれを超えないことを照査する等の手法がある。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1.  国土交通省水管理・国土保全局河川計画課長、治水課長通達：[河川津波対策について](http://www.mlit.go.jp/river/shishin_guideline/kasen/pdf/kasen_tsunami_taisaku_h230902.pdf)，平成23年9月2日，国水河計第20号，国水治第35号．

```{=html}
<!-- -->
```
10. 合田良美：防波護岸の越波流量に関する研究，港湾技術研究所報告第9巻，第4号，pp.3-42，1970．

    1.  []{#_Toc10813360 .anchor}特殊堤の安全性能の照査

＜考え方＞

+----------------------------------------------------------------------+
| 市街地又は重要な施設に近接する堤防で用地取得                         |
| が極めて困難な場合等においては、土堤以外の構造を採用する場合があり、 |
| 都市河川の高潮区間等においていわゆる特殊堤が限定的に築造されている。 |
|                                                                      |
| 特殊堤を採用する場合は、設計の基本で示した計画堤防断面形状を         |
| 定める必要はないが、当該河川における計画堤防断面形状を有する土堤と同 |
| 等以上の安全性能を満足する必要がある。特殊堤の安全性能の照査として、 |
| 耐震性能の照査と、耐震性能以外の安全性能の照査について以下に述べる。 |
|                                                                      |
| 1.  耐震性能の照査                                                   |
|                                                                      |
| > 自立                                                               |
| 式構造の特殊堤における耐震性能の照査は、耐震性能照査指針に基づき、実 |
| 施するものである。レベル1地震動に対しては、地震によって特殊堤として  |
| の健全性を損なわないか否かを照査するものである。レベル2地震動に対し  |
| ては、堤内地盤高が平常時の最高水位よりも低い地域の自立式構造の特殊堤 |
| については、地震によりある程度の損傷が生じた場合においても河川水が堤 |
| 内地に侵入することによって浸水等の二次災害を発生するか否かを照査し、 |
| それ以外の地域の自立式構造の特殊堤については、地震後に特殊堤としての |
| 機能が応急復旧等により速やかに回復できるか否かを照査するものである。 |
| >                                                                    |
| > 胸                                                                 |
| 壁を有する構造の特殊堤については、土堤の耐震性能の照査が参考となる。 |
|                                                                      |
| 2.  耐震性能以外の安全性能の照査                                     |
|                                                                      |
| > 照査事項及び                                                       |
| 照査方法等については、個別に適切な方法を用いて設計を行う必要がある。 |
| >                                                                    |
| > 自立式構造の特殊堤に                                               |
| ついては、滑動及び転倒に対する安全性についても照査する必要があり、胸 |
| 壁を有する構造の特殊堤については、土堤の安全性能の照査が参考となる。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 特殊堤を採用する場合には、計画堤防断面形状を有す                     |
| る土堤と同等以上の安全性能を満足することを照査することを基本とする。 |
|                                                                      |
| 1)  耐震性能の照査                                                   |
|                                                                      |
| > 耐震性能の照査に当たっては、レベル1地                              |
| 震動に対して地震によって特殊堤としての健全性を損なわないことを照査し |
| 、レベル2地震動に対して特殊堤としての機能を保持する、あるいは特殊堤  |
| としての機能の回復が速やかに行い得ることを照査することを基本とする。 |
|                                                                      |
| 2)  耐震性能以外の安全性能の照査                                     |
|                                                                      |
| > 個別に適切な照査事項と照査方法を用いることを基本とする。           |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  国土交通省水管理・国土保全局：[河川構造物の耐震性能照査指針・解説―Ⅲ．自立式構造の特殊堤編―](http://www.mlit.go.jp/river/shishin_guideline/bousai/wf_environment/structure/pdf/ref03.pdf)，平成24年2月．

    1.  []{#_Toc10813361 .anchor}土堤の強化対策

        1.  []{#_Toc10813362 .anchor}強化工法選定の基本

＜考え方＞

+----------------------------------------------------------------------+
| 堤防強化工法の選定に当                                               |
| たっては、安全性能の照査の結果、所要の安全性が確保されていないと判断 |
| される区間を堤防強化区間として設定し、過去の被災履歴、被災の原因及び |
| 堤防の現況等を踏まえ、洪水の流下に支障を及ぼさないよう河積の確保等に |
| ついて配慮した上で、所要の安全性を確保できる強化工法を一次選定する。 |
|                                                                      |
| 次に、「2.2.2設計に反映す                                            |
| べき事項」における検討項目の観点により適切な強化工法を二次選定する。 |
|                                                                      |
| さらに一連区間における構造の連続性及                                 |
| び樋門等の構造物の設置状況等を勘案し、総合的に検討を行い強化工法を決 |
| 定する。その際、特定の機能に対する強化工法が他の機能を低下させないこ |
| と、構造物と堤体の境界部が弱部とならないよう留意すること並びに上下流 |
| 及び左右岸の構造の連続性及び整合性について配慮することが重要である。 |
|                                                                      |
| 現在の土堤は、長い年月をかけて経験的に安全を確認してきた構           |
| 造であると考えられることから、土堤の強化工法の検討に当たっては少なく |
| とも現状での堤防の安全性を低下させない工法であることが必要であるとと |
| もに、「2.2機能と設計に反映すべき事項」で求められる堤防の機能等が担  |
| 保されることを確認できる技術的検討を経た工法であることが必要である。 |
+----------------------------------------------------------------------+

＜標　準＞

  ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  土堤の強化対策に当たっては、「2.2.2設計に反映すべき事項」における検討項目の観点から堤防強化工法の適用性を比較及び検討し、安全性能を満足するよう適切な工法を選定することを基本とする。
  ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1.  国土交通省河川局治水課河川整備調整官事務連絡：「河川堤防質的整備技術ガイドライン（案）」について，平成16年3月31日．

2.  国土交通省河川局治水課企画専門官事務連絡：「河川堤防質的整備技術ガイドライン（案）同解説」について（通知），平成16年3月31日．

    1.  []{#_Toc13470669
        .anchor}常時のすべり破壊に対する安定及び沈下に対する強化

＜考え方＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  常時のすべり破壊に対する安定及び沈下に対する強化に当たっては、急激な盛土載荷による地盤沈下及び堤体の変形を緩和すること並びに地盤沈下の発生を抑制することが基本であり、これらを踏まえた工法を選定するものである。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  常時のすべり破壊に対する安定及び沈下に対する強化に当たっては、沈下による堤体への影響を緩和する工法及び沈下の発生を抑制する工法があることを踏まえ、基礎地盤の土層構造や背後地の土地利用状況等を勘案し、堤防強化工法を選定することを基本とする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜例　示＞

+----------------------------------------------------------------------+
| 常時                                                                 |
| のすべり破壊に対する安定に対しては、堤体への盛土載荷による影響を緩和 |
| する工法として、盛土による堤体の強度増加を図りながら段階的に堤防を盛 |
| り立てる緩速施工による対応等が考えられる。これが難しい場合には、すべ |
| りに対する工法として地盤改良等の補助工法を実施することが考えられる。 |
|                                                                      |
| 沈下に対                                                             |
| しては、軟弱地盤における沈下の発生を抑制する工法として堤防自体の沈下 |
| 抑制及び周辺への影響を緩和するために地盤改良等を実施する場合がある。 |
|                                                                      |
| 補                                                                   |
| 助工法を行う場合、基礎地盤の川表側に透水性の高い軟弱地盤対策（バーチ |
| カルドレーン等）を行うと洪水及び高潮時の基盤浸透で堤体内浸潤面を高め |
| る場合がある。また、基礎地盤の川裏側に透水性の低い固結工法を行うと、 |
| 浸透水の行き止まりで浸潤面を高める場合があるため留意する必要がある。 |
|                                                                      |
| 雨水排水の集中                                                       |
| に対する対策としては、天端舗装をした場合にのり面への雨水排水の集中を |
| 防止するためのアスカーブの設置、集まった雨水を排水するための排水処理 |
| 施設又はのり肩の保護等適切な構造による措置を講ずることが考えられる。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  建設省河川局水政課長、河川計画課長、治水課長通達：[河川管理施設等構造令及び同令施行規則の運用について](http://www.mlit.go.jp/notice/noticedata/sgml/054/78000120/78000120.html)，平成11年10月15日，建設省河政発第74号，建設省河計発第83号，建設省河治発第39号．

2.  （財）国土技術研究センター：河川土工マニュアル，[第3章
    河川土工の設計](http://www.jice.or.jp/cms/kokudo/pdf/tech/material/dokouh21_03.pdf)
    第3.2節 軟弱地盤対策，2009．

    1.  []{#_Toc10813364 .anchor}侵食に対する強化

＜考え方＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  侵食に対する強化に当たっては、直接侵食、洗掘及び側方侵食に対して、低水路平面形の修正、高水敷の造成及び水制等により侵食外力の軽減を図ること並びに護岸等により侵食耐力の強化を図ることが基本であり、これらを踏まえた工法を選定するものである。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| > 侵食に対する強化に当たっては                                       |
| 、侵食外力を軽減する方法、侵食耐力を強化する方法又は両者を適切に組み |
| 合わせる方法があることを踏まえ、河道の特性を勘案し、強化対象箇所にお |
| ける被災履歴及び現地の状況等に応じて、侵食の機構に応じた所要の安全性 |
| を確保できる構造となるような堤防強化工法を選定することを基本とする。 |
+----------------------------------------------------------------------+

＜推　奨＞

+----------------------------------------------------------------------+
| > 水制により河岸前面の流速を低減                                     |
| し、河岸沿いのせん断力を弱め河岸の侵食耐力以下とすることで、護岸で覆 |
| わない盛土部分を残すことができる。水制まわりの流速低減域若しくは洗掘 |
| 域を残すことで、生物の多様な生息環境確保に資する効果が期待できる場合 |
| もあるので、多自然川づくりの観点からも選択肢に加えることが望ましい。 |
+----------------------------------------------------------------------+

＜例　示＞

+----------------------------------------------------------------------+
| 1.  侵食外力を軽減する工法としては、例えば以下の工法が考えられる。   |
|                                                                      |
| -   高水敷の造成                                                     |
|                                                                      |
| > 高水敷を造成                                                       |
| することにより、堤防前面流速を低減し、侵食代（高水敷幅）を確保する。 |
|                                                                      |
| -   水制の設置                                                       |
|                                                                      |
| > 水制の設置により、粗度効果による流速低減及び主流路を遠ざけ         |
| る水はね効果が見込まれ、洪水及び高潮時の侵食に対して堤防を保護する。 |
|                                                                      |
| -   低水路平面形の修正                                               |
|                                                                      |
| > 主流路を遠ざける効果及び堤防前面流                                 |
| 速の低減効果が見込まれ、洪水及び高潮時の侵食に対して堤防を保護する。 |
|                                                                      |
| 2.  侵食耐力を強化する工法としては、例えば以下の工法が考えられる。   |
|                                                                      |
| -   護岸の設置（のり覆工）                                           |
|                                                                      |
| > 表面侵食耐                                                         |
| 力を増強することで洪水及び高潮時の侵食に対して堤防を保護する。なお、 |
| 環境面に配慮する場合は、護岸等を覆土する手法を採用されることが多い。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  （財）国土技術研究センター：[河川堤防の構造検討の手引き（改訂版）](http://www.jice.or.jp/cms/kokudo/pdf/tech/material/teibou_kouzou02.pdf)，第5章
    侵食に対する堤防の構造検討 5.4 強化工法の設計，2012．

2.  国土交通省水管理・国土保全局防災課：[美しい山河を守る災害復旧基本方針](https://www.mlit.go.jp/river/shishin_guideline/bousai/saigai/measures-saigai/pdf/10.pdf)，平成30年6月．

3.  （財）国土技術研究センター：護岸の力学設計法（第 7 刷），2007

    （最新版）（一財）国土技術研究センター：[改訂
    護岸の力学設計法](https://www.jice.or.jp/tech/material/detail/21)，2023．

    1.  []{#_Toc10813365 .anchor}浸透に対する強化

＜考え方＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  浸透に対する強化に当たっては、1.降雨あるいは流水を堤防に浸透させないこと（浸透の抑制又は防止）、2.浸透水は速やかに排水すること、3.堤防、特に裏のり尻部の強度を増加させること（堤体のせん断強さの増加及び堤防内の動水勾配の低下）、4.堤防断面を拡幅し、浸透路長を長くすることが基本であり、これらを踏まえた工法を選定するものである。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| > 浸透に対する強化に当たっては、のりすべりに対して強化する方         |
| 法、パイピングに対して強化する方法又は両者を適切に組み合わせる方法が |
| あることを踏まえ、堤体と基礎地盤の土層構造を勘案し、強化対象箇所にお |
| ける被災履歴及び現地の状況等に応じて、浸透の機構に応じた所要の安全性 |
| を確保できる構造となるような堤防強化工法を選定することを基本とする。 |
+----------------------------------------------------------------------+

＜推　奨＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  堤防断面を広げてのり面を緩傾斜とする断面拡大工法は、既設堤防や基礎地盤とのなじみがよく、他の浸透対策工法に比較して環境面や維持管理面でも有利となるため、用地の制約が厳しい区間を除けば優先的に選定することが望ましい。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜例　示＞

+----------------------------------------------------------------------+
| 1.  の                                                               |
| りすべりに対して強化する工法としては、例えば以下の工法が考えられる。 |
|                                                                      |
| -   断面拡大工法                                                     |
|                                                                      |
| > 堤防断面を拡大することにより浸透路長の延伸                         |
| を図り、平均動水勾配を減じて堤体の安全性を増加させる他、のり勾配を緩 |
| くすること（緩傾斜化）によりすべり破壊に対する安全性を増加させる。ま |
| た、抑え盛土効果も見込めるのでパイピングに対する安全性も増加させる。 |
| >                                                                    |
| > なお、旧堤拡                                                       |
| 築の場合、可能な限り裏腹付けとするものとするが、堤防の計画法線上の制 |
| 約や河道断面が広く河積に余裕がある場合等は表腹付けをすることもある。 |
|                                                                      |
| -   ドレーン工                                                       |
|                                                                      |
| > 堤体の川裏のり尻を                                                 |
| 透水性の大きい材料で置き換え、堤体に浸透した水を速やかに排水する。ま |
| た、のり尻をせん断強度の大きい材料で置き換えるため安定性が増加する。 |
|                                                                      |
| -   表のり遮水工法                                                   |
|                                                                      |
| > 表のり面を難透水性材                                               |
| 料で被覆することにより高水位時の河川水の表のりからの浸透を抑制する。 |
|                                                                      |
| 2.  パ                                                               |
| イピングに対して強化する工法としては、例えば以下の工法が考えられる。 |
|                                                                      |
| -   川表遮水工法                                                     |
|                                                                      |
| > 川表のり尻に止水矢                                                 |
| 板等による遮水壁を設置することにより基礎地盤への浸透水量を低減する。 |
|                                                                      |
| -   ブランケット工法                                                 |
|                                                                      |
| > 高水敷を難透水性材料で被覆することにより、浸                       |
| 透路長を延伸させ、裏のり尻近傍の浸透圧を低減する。高水敷の造成又は低 |
| 水路内の河岸侵食の軽減により、基礎地盤透水層の露出を回避することでブ |
| ランケット工法と同様の効果を発現する可能性がある場合には、必要に応じ |
| て低水路法線形や河道横断形等の河道設計の修正を行うことも考えられる。 |
|                                                                      |
| -   堤内基盤排水工法                                                 |
|                                                                      |
| > 基礎地盤からの浸透水を裏のり尻に鉛直方向に設                       |
| 置したドレーンで排水することにより、裏のり尻近傍の浸透圧を低減する。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  （財）国土技術研究センター：[河川堤防の構造検討の手引き（改訂版）](http://www.jice.or.jp/cms/kokudo/pdf/tech/material/teibou_kouzou02.pdf)，第4章
    浸透に対する堤防の構造検討 4.4 強化工法の設計，2012．

2.  （国研）土木研究所地質・地盤研究グループ土質・振動チーム：堤内基盤排水対策マニュアル（試行版），2017

    （最新版）（国研）土木研究所地質・地盤研究グループ土質・振動チーム：[堤内基盤排水対策マニュアル（試行版）](https://www.pwri.go.jp/team/smd/topics-teinaikiban.html)，令和3年3月．

    1.  []{#_Toc10813366 .anchor}地震に対する強化

＜考え方＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  地震に対する強化に当たっては、過去の地震による河川堤防の大きな被害が液状化に起因する事例が多いことから、液状化の発生を抑制又は液状化による堤体や地盤の変形を抑制することが基本であり、これらを踏まえた工法を選定するものである。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| > 地震に対                                                           |
| する強化に当たっては、液状化の発生を抑制する方法、液状化による基礎地 |
| 盤及び堤体の変形を抑制する方法又は両者を適切に組み合わせる方法がある |
| ことを踏まえ、基礎地盤及び堤体の土層構造並びに背後地の状況等を勘案し |
| 、強化対象箇所における被災履歴及び現地の状況等に応じて、所要の安全性 |
| を確保できる構造となるような堤防強化工法を選定することを基本とする。 |
+----------------------------------------------------------------------+

＜推　奨＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  強化に当たっては、侵食及び浸透等に対する安全性の確保との整合を考えると、断面拡大工法が望ましい。これが難しい場合には、耐震対策として効果のあるものを抽出し組み合わせて安全性が確保できる構造とすることが望ましい。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜例　示＞

+----------------------------------------------------------------------+
| 1.                                                                   |
|   液状化の発生を抑制する工法としては、例えば以下の工法が考えられる。 |
|                                                                      |
| -   抑え盛土工法                                                     |
|                                                                      |
| > 抑え盛土荷重により地盤に働く上載荷重を増し、液状化                 |
| を抑制する。また、すべりに対しても盛土荷重が抵抗側に働き安定化する。 |
|                                                                      |
| -   締め固め工法                                                     |
|                                                                      |
| > 充填剤の挿入や振動締                                               |
| め固めを行うことにより、液状化層を締め固めて液状化の発生を抑制する。 |
|                                                                      |
| -   排水工法                                                         |
|                                                                      |
| > 裏のり尻ドレーン等により、地震時に地下水が                         |
| 排水され、過剰間隙水圧の上昇を抑制することで液状化の発生を抑制する。 |
|                                                                      |
| 2.  液状化による堤                                                   |
| 体や地盤の変形を抑制する工法としては、例えば以下の工法が考えられる。 |
|                                                                      |
| -   固化工法                                                         |
|                                                                      |
| > 深層混合処理や薬液注入                                             |
| によって地盤を固化することにより、堤体のり尻の側方変位の抑制をする。 |
|                                                                      |
| -   矢板工法                                                         |
|                                                                      |
| > 鋼管矢板又は鋼矢板の剛性により液状化層の側方変位を抑制する。       |
|                                                                      |
| 兵庫県南部地震における淀川                                           |
| の被害状況をみると、高水敷の造成及び堤防の緩傾斜化等の河川改修工事は |
| 、液状化の抑制を直接の目的とはしていないものの、地震時の堤防の安定性 |
| に一定の役割を果たしており、侵食及び浸透に対する強化を含めた治水対策 |
| として計画されている各種の工事の実施見通しを踏まえ、地震に対する効果 |
| も加味して、耐震強化を進めることが効率的かつ経済的である場合がある。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  （財）国土技術研究センター：[河川堤防の構造検討の手引き（改訂版）](http://www.jice.or.jp/cms/kokudo/pdf/tech/material/teibou_kouzou02.pdf)，第6章
    地震に対する堤防の構造検討 6.4 強化工法の設計，2012．

2.  （国研）土木研究所地質・地盤研究グループ土質・振動チーム：[河川堤防の液状化対策の手引き](https://www.pwri.go.jp/team/smd/pdf/report4332.pdf)，2016．

    （最新版）（国研）土木研究所地質・地盤研究グループ土質・振動チーム：河川堤防の液状化対策の手引き（改定版）,令和6年5月．

    1.  []{#_Toc10813367 .anchor}波浪に対する強化

＜考え方＞

+----------------------------------------------------------------------+
| > 波浪又は津波に対する強化に当たっては、堤防への侵                   |
| 食作用若しくは波力の低減又は越波の抑制若しくは越波に対する堤防の耐力 |
| 強化が基本であり、これらを踏まえた工法を選定するものである。その際、 |
| 接続する海岸堤防の構造を勘案し、接続部分の構造に配慮する必要がある。 |
+----------------------------------------------------------------------+

＜必　須＞

  ----------------------------------------------------------------------------------------------------
  波浪又は津波の影響を著しく受ける堤防については、構造令に基づき必要に応じて措置を講ずるものとする。
  ----------------------------------------------------------------------------------------------------

＜推　奨＞

  -----------------------------------------------------------------------------------------------------------------------------------------------
  湖沼、高潮区間の堤防における三面張構造の堤防のコンクリートののり面被覆部は､景観との調和､河川の生態系の保全等の観点から覆土することが望ましい｡
  -----------------------------------------------------------------------------------------------------------------------------------------------

＜例　示＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  高潮区間に設置される堤防において堤内地への越波を防ぐためには、必要に応じて波返工を設けるが、波の入射角が概ね30度以上で、波高が1m程度以上の場合、若しくは概ね30度未満で1.5m程度以上の場合に波返しに対する措置が必要となる場合がある。また、越波量が延長1m当たり0.02m^3^/s程度以上の場合は堤体を被覆することが考えられ、その場合、越波量は1m当たり0.05m^3^/s程度以下としている。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1.  国土交通省水管理・国土保全局河川計画課長、治水課長通達：[河川津波対策について](http://www.mlit.go.jp/river/shishin_guideline/kasen/pdf/kasen_tsunami_taisaku_h230902.pdf)，平成23年9月2日，国水河計第20号，国水治第35号．

    1.  []{#_Toc13470674 .anchor}堤防構造に関するその他の事項

＜考え方＞

+----------------------------------------------------------------------+
| 前項までは、堤防の護岸、水制そ                                       |
| の他これらに類する施設と一体として、計画高水位（高潮区間においては計 |
| 画高潮位）以下の水位の流水の通常の作用による侵食や浸透等に対して安全 |
| である機能を発揮するために、安全性能の照査を行い、その結果が安全性能 |
| を満たさない場合に安全性能を満足させるための対応を示したものである。 |
|                                                                      |
| しかしながら、現況施設能力を上回る                                   |
| 洪水の生起により計画高水位を超えるような事象が頻発しており、今後の気 |
| 候変動の影響によっては、このような事象は更に増えることも考えられる。 |
|                                                                      |
| これらの事象が発生した場合に対し、堤防が決壊するまでの時間を少しでも |
| 引き延ばすことにより避難までの時間の確保や氾濫被害の軽減に寄与するな |
| どの効果を期待して、「構造上の工夫」を堤防に施す場合がある。「構造上 |
| の工夫」は、越流水の作用に対する堤防の力学的な破壊メカニズムの解析及 |
| び明確な安全基準の設定が可能な状況にないことから、現時点で堤防の設計 |
| に含むものではないが、いわゆる減災を目的に施策上実施しているものであ |
| る。堤防越流に対しては、不同沈下等により堤防に不陸が生じるような場合 |
| 等において、越流水が集中する可能性があることにも留意する必要がある。 |
|                                                                      |
| 現況施設能力を上回る洪水に対する「構造上の工夫」につい               |
| ては、今後効果の定量化に向けた検討等に取り組むとともに、その実施によ |
| り現状での堤防の安全性を低下させないことを前提に、構造物の耐久性、維 |
| 持管理の容易性及び経済性等の観点から技術開発を進めていく必要がある。 |
+----------------------------------------------------------------------+

＜例　示＞

+----------------------------------------------------------------------+
| 現況施設能力を上回る洪水への                                         |
| 対応として、以下のような堤防の構造上の工夫を実施している事例がある。 |
|                                                                      |
| > ・天端の舗装及び裏のり                                             |
| 尻をブロック張等により補強する構造上の工夫を実施している場合がある。 |
| >                                                                    |
| > ・                                                                 |
| 表のり尻から天端にかけて遮水シート及び護岸を施工している場合がある。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  国土交通省水管理・国土保全局長通達：「水防災意識社会
    再構築ビジョン」に基づく取組について，平成28年1月18日，国水河計第77号．

2.  国土交通省水管理・国土保全局治水課技術調整官、企画専門官事務連絡：危機管理型ハード対策（堤防決壊までの時間を少しでも引き延ばす堤防構造の工夫）の施工について，平成28年6月16日．

3.  服部敦、森啓年、笹岡信吾：[越水による決壊までの時間を少しでも引き延ばす河川堤防天端・のり尻の構造上の工夫に関する検討](http://www.nilim.go.jp/lab/bcg/siryou/tnn/tnn0911.htm)，国土技術政策総合研究所資料，第911号，2016．

第1章 河川構造物の設計 {#第1章-河川構造物の設計-2 .TOC-Heading}
======================

第3節 高規格堤防 {#第3節-高規格堤防 .TOC-Heading}
================

目次 {#目次 .TOC-Heading}
====

[第3節 高規格堤防 1](#_Toc199347109)

> [3．1 総説 1](#_Toc199347110)
>
> [3．1．1 目的と適用範囲 1](#_Toc199347111)
>
> [3．1．2 用語の定義 1](#_Toc199347112)
>
> [3．2 機能 2](#_Toc199347113)
>
> [3．3 設計の基本 3](#_Toc199347114)
>
> [3．4 基本的な構造及び材質 4](#_Toc199347115)
>
> [3．4．1 基本断面形状 4](#_Toc188019574)
>
> [3．4．2 設計断面形状 5](#_Toc199347117)
>
> [3．4．3 材質 6](#_Toc199347118)
>
> [3．5 安全性能の照査等 6](#_Toc199347119)
>
> [3．5．1 設計の対象とする状況と作用・荷重 7](#_Toc199347120)
>
> [3．5．2 安全性能の照査 11](#_Toc199347121)
>
> [3．6 土地利用の観点から要求される性能の照査等 20](#_Toc199347122)
>
> [3．6．1 一般 20](#_Toc199347123)
>
> [3．6．2 沈下等に対する配慮 21](#_Toc199347124)
>
> [3．6．3 隣接構造物への影響に対する配慮 22](#_Toc199347125)
>
> [3．7 高規格堤防構造に関するその他事項 22](#_Toc199347126)
>
> [3．7．1 分合流部の設計 22](#_Toc199347127)
>
> [3．7．2 高規格堤防上の細部構造の設計 24](#_Toc199347128)
>
> [3．7．3 段階的施工に関する留意点等 24](#_Toc199347129)
>
> [3．7．4 ICT やBIM/CIM の活用 25](#_Toc199347130)

令和7年6月　版

適用上の位置付け

　河川砂防技術基準設計編は、基準の適用上の位置付けを明確にするために、下表に示すように適用上の位置付けを分類している。

+--------+------------------+------------------+------------------+
| 分　類 | 適用上の位置付け | 末尾の字句例     |                  |
+--------+------------------+------------------+------------------+
| 考え方 | 技術資料         | ●目              | 「･･･ある。      |
|        |                  | 的や概念、考え方 | 」「･･･いる。」  |
|        |                  | を記述した事項。 |                  |
|        |                  |                  | 「･･･なる。      |
|        |                  |                  | 」「･･･れる。」  |
+--------+------------------+------------------+------------------+
| 必　須 | 技術基準         | ●法令による規定  | 「･･･なければ    |
|        |                  | や技術的観点から | ならない。」「･  |
|        |                  | 実施すべきである | ･･ものとする。」 |
|        |                  | ことが明確であり |                  |
|        |                  | 遵守すべき事項。 |                  |
+--------+------------------+------------------+------------------+
| 標　準 | 技術基準         | ●特              | 「･･･            |
|        |                  | 段の事情がない限 | を標準とする。」 |
|        |                  | り記述に従い実施 |                  |
|        |                  | すべきだが、状況 | 「･･･            |
|        |                  | や条件によって一 | を基本とする。」 |
|        |                  | 律に適用すること |                  |
|        |                  | はできない事項。 | 「･･･による。」  |
+--------+------------------+------------------+------------------+
| 推　奨 | 技術資料         | ●状況や条件      | 「               |
|        |                  | によって実施する | ･･･望ましい。」  |
|        |                  | ことが良い事項。 |                  |
|        |                  |                  | 「               |
|        |                  |                  | ･･･推奨する。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･努める。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･必要に応    |
|        |                  |                  | じて･･･する。」  |
+--------+------------------+------------------+------------------+
| 例　示 | 技術資料         | ●適用条件や実施  | 「               |
|        |                  | 効果について確定 | ･･･などの手法（  |
|        |                  | している段階では | 事例）がある。」 |
|        |                  | ないが、状況や条 |                  |
|        |                  | 件によっては導入 | 「･･･など        |
|        |                  | することが可能な | の場合がある。」 |
|        |                  | 新技術等の例示。 |                  |
|        |                  |                  | 「･･･など        |
|        |                  | ●状              | が考えられる。」 |
|        |                  | 況や条件によって |                  |
|        |                  | 限定的に実施でき | 「               |
|        |                  | る技術等の例示。 | ･･･の場合には･･･ |
|        |                  |                  | ことができる。」 |
|        |                  | ●具体的          |                  |
|        |                  | に例示することに | 「               |
|        |                  | より、技術的な理 | ･･･例示する。」  |
|        |                  | 解を助ける事項。 |                  |
|        |                  |                  | 「例えば･･･。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･事例もある  |
|        |                  |                  | 。･･･もよい。」  |
+--------+------------------+------------------+------------------+

  関連通知等       関連する通知やそれを理解する上で参考となる資料
  ---------------- ------------------------------------------------------
  参考となる資料   例示等に示した手法・内容を理解する上で参考となる資料

3.  []{#_Toc199347109 .anchor}高規格堤防

    1.  []{#_Toc199347110 .anchor}総説

        1.  []{#_Toc199347111 .anchor}目的と適用範囲

＜考え方＞

+----------------------------------------------------------------------+
| 本節は、高規格堤防を整備する際の設計に適用する。                     |
|                                                                      |
| 人口・資産等が                                                       |
| 高密度に集積する首都圏及び近畿圏のゼロメートル地帯等の低平地において |
| は、ひとたび堤防が決壊すると、密集市街地において広範囲に浸水が発生し |
| 、浸水継続時間が長期間にわたるなど壊滅的な被害につながるおそれがある |
| ことから、こういった被害を防ぐために、高規格堤防の整備を進めている。 |
|                                                                      |
| 高規格堤防は、河川管理施設である堤防の                               |
| 一形態、かつその敷地の大部分が通常の土地利用に供されるものであり、計 |
| 画高水位を超え、高規格堤防設計水位以下の洪水の作用に対しても耐えるこ |
| とができる構造を有するものである。ここで、「通常の土地利用」とは、周 |
| 囲の状況等を勘案して社会通念上客観的に相当と認められる土地の利用であ |
| り、具体的には、高規格堤防を整備しようとする地域における住宅・ビル、 |
| 工場、道路、公園、農地としての利用等、種々の土地利用を想定している。 |
+----------------------------------------------------------------------+

＜標　準＞

  --------------------------------------
  本節は、高規格堤防の設計に適用する。
  --------------------------------------

＜関連通知等＞

1)  建設省河川局長通達：河川管理施設等構造令及び同令施行規則の施行について，平成4年2月1日，建設省河政発第31号．

    1.  []{#_Toc199347112 .anchor}用語の定義

＜考え方＞

+----------------------------------------------------------------------+
| 高規格堤防のイメージ図及び各部の名称は図3-1に示すとおりである。      |
|                                                                      |
| ![](media/image4.emf){width="6.200787401574803in"                    |
| height="2.1661417322834646in"}                                       |
|                                                                      |
| 図3-1　高規格堤防のイメージ                                          |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 次の各号に掲げる用語の定義は、それぞれ以下による。                   |
|                                                                      |
|   一.高規格堤防設計水位   :   高規格堤防が整備される区間にお         |
| いて洪水、津波及び高潮が生ずるものとした場合における河道内の最高水位 |
|   ----------------------- --- ----                                   |
| -------------------------------------------------------------------- |
| -------------------------------------------------------------------- |
|   二.高規格堤防特別区域   :   高規格堤防の                           |
| 敷地である土地の区域のうち、通常の利用に供することができる土地の区域 |
|   三.天端                 :   高規格堤防の表法肩                     |
| から「3.4.1 基本断面形状 (2)天端幅」に基づいて定まる天端幅までの部分 |
|   四.基本断面形状                                                    |
|       :   高規格堤防の治水上の機能を確保するため、構造令及び同令施行 |
| 規則の規定を満足するよう設定する断面形状（高さ、天端幅、のり勾配等） |
|   五.設計断面形状         :   基                                     |
| 本断面形状に従い、高規格堤防特別区域における土地利用を踏まえて定める |
| 断面形状や段階的施工等を考慮して定める暫定断面を含む実際の断面形状　 |
+----------------------------------------------------------------------+

1.  []{#_Toc199347113 .anchor}機能

＜考え方＞

+----------------------------------------------------------------------+
| 高規格堤防                                                           |
| の設計において治水上求められる機能は以下の１）～３）のとおりである。 |
|                                                                      |
| なお、高                                                             |
| 規格堤防特別区域は、住宅・ビル、工場、道路、公園、農地としての利用等 |
| 、通常の土地利用に供されることから、通常の市街地と同程度の安全性を確 |
| 保することも要求される。このため、治水上求められる機能とは別に土地利 |
| 用の観点から必要となる機能についても共同事業者等と十分な調整を行い、 |
| 適切な役割分担のもとで、設計に反映させる必要がある（本節3.6参照）。  |
|                                                                      |
| > １）洪水時                                                         |
| >                                                                    |
| > 高規格堤防は、河川管理施設である堤防の一形態であるため、           |
| 高規格堤防及びその地盤は、護岸、水制その他これらに類する施設と一体と |
| して、河道計画で定められた計画高水位(高潮区間においては計画高潮位）  |
| 以下の水位の流水の通常の作用による侵食破壊、浸透破壊に対して安全な機 |
| 能及び降雨による浸透破壊に対して安全な機能を有することが求められる。 |
| >                                                                    |
| > 加え                                                               |
| て、高規格堤防設計水位以下の水位の流水の作用による侵食破壊、浸透破壊 |
| 、越流水による洗掘破壊等に対して安全な機能を有することが求められる。 |
| >                                                                    |
| > ２）常時                                                           |
| >                                                                    |
| > 河道内の水位が平水位の条件下で、高規格堤防の自重によ               |
| る基礎地盤の沈下、変形等に対して安全な機能を有することが求められる。 |
| >                                                                    |
| > ３）地震時                                                         |
| >                                                                    |
| > 構造令及び同令施行規則に規定される地震の作用に対し                 |
| ては、河道内の水位が計画高水位以下の条件下で、高規格堤防及びその地盤 |
| がすべり破壊、液状化破壊に対して安全な機能を有することが求められる。 |
| >                                                                    |
| > また、対象地点において現在から将来にわたって考え                   |
| られる最大級の強さを持つ地震動（以下、「レベル2地震動」という。）に  |
| 対しては、地震時及び地震後において通常想定される水位における流水が河 |
| 川外へ流出することを防止する機能を有することが求められるほか、「１） |
| 洪水時」に示す機能の回復が速やかに行い得ることが求められる。このため |
| 、高規格堤防の変形又は沈下等を上記の機能を確保できる範囲内に抑える必 |
| 要がある。そのためには、共同事業者等との十分な事前調整も重要となる。 |
| たとえば、高規格堤防特別区域が市街地としての土地利用に供せられる場合 |
| 、高規格堤防設計水位の作用時の越流水による洗掘破壊に対しては、越流水 |
| が集中して流下し、特に大きなせん断力が作用すると考えられる道路部等の |
| 修復が早期に行い得ることが求められ、そのための事前調整が必要になる。 |
+----------------------------------------------------------------------+

＜必　須＞

+----------------------------------------------------------------------+
| 高規格堤防の設計に当たっては、高規格堤防及びその地                   |
| 盤が護岸、水制その他これらに類する施設と一体として計画高水位（高潮区 |
| 間においては計画高潮位）以下の水位の流水の通常の作用に対して安全な機 |
| 能、及び高規格堤防設計水位以下の水位の流水の作用による侵食破壊、浸透 |
| 破壊、越流水による洗掘破壊等に対して安全な機能を確保するものとする。 |
|                                                                      |
| また                                                                 |
| 、常時に自重による沈下、すべり破壊等に対して安全であるとともに、計画 |
| 高水位以下の水位において構造令及び同令施行規則に規定される地震の作用 |
| によるすべり破壊、液状化破壊に対して安全な機能を確保するものとする。 |
|                                                                      |
| 加えて、高規格堤防特別区域に                                         |
| おいては通常の土地利用の観点から要求される機能を確保するものとする。 |
+----------------------------------------------------------------------+

＜標　準＞

  -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  レベル2地震動に対しては、地震時及び地震後において通常想定される水位における流水が河川外に流出することを防止する機能を有するとともに、洪水時に治水上求められる機能の回復が速やかに行い得ることを基本とする。
  -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜参考となる資料＞

1)  国土交通省
    > 都市局長,農林水産省農村振興局長,林野庁長官：宅地造成及び特定盛土等規制法の施行に当たっての留意事項について（技術的助言），令和5年5月26日（国官参宅第12号5農振第650号5林整治第244号）．

2)  盛土等防災研究会：盛土等防災マニュアルの解説，令和 5 年 11 月．

3)  （独）都市再生機構：宅地耐震設計マニュアル（案），平成 20 年 4 月．

4)  （一社）日本建築学会：建築基礎構造設計指針，令和 元 年 11 月．

5)  （一社）日本建築学会：小規模建築物基礎設計指針，平成 20 年 2 月．

6)  （一社）日本建築学会：建築基礎のための地盤改良設計指針案，平成 18 年
    > 11 月．

7)  平成24年度宅地の液状化対策の推進に関する研究会：宅地の液状化被害可能性判定に係る技術指針・同解説（案），平成
    > 25 年 2 月．

8)  国土交通省 都市局 都市安全課：市街地液状化対策推進ガイダンス，令和
    > 元年6 月．

    1.  []{#_Toc199347114 .anchor}設計の基本

＜考え方＞

+----------------------------------------------------------------------+
| 高規格堤防の設計に当たっては、「3.4                                  |
| 基本的な構造及び材質」に従い高                                       |
| 規格堤防の基本断面形状及び設計断面形状、材質等を設定した上で、「3.2  |
| 機能」に規定する治水上の機能を有するよう「3.5                        |
| 安全性能の照査等」に従い安全性能の照査を行い、その結果に応じて、     |
| 必要な場合には、照査基準値を満足するよう対策を行うことが求められる。 |
|                                                                      |
| 基本断面形状としては、河                                             |
| 道計画等に基づき高さ、天端幅を設定するほか、高規格堤防の治水上の機能 |
| が確保できるよう、のり勾配等を設定する必要がある。その際には、設定し |
| た裏のり面上の高規格堤防特別区域が将来にわたり様々な土地利用に供され |
| ることを考慮して、通常の土地利用としてどのような利用状況となっても高 |
| 規格堤防として十分な治水機能が発揮されるよう、裏のり面上に設置される |
| 建築物等の建ぺい率や上載荷重等の設計条件を適切に設定する必要がある。 |
|                                                                      |
| 設計断面形状については、基本断面形状（高さ、天端幅、                 |
| のり勾配等）を包含し、共同事業者等とも必要かつ十分な調整を行って、高 |
| 規格堤防特別区域における当面の土地利用のための造成盛土や段階的施工等 |
| も考慮して実際の断面形状を設定した上で、安全性能の照査（対策後の条件 |
| での照査を含む）を行って決定する必要がある。このとき、縦断方向に設計 |
| 断面形状が変化する場合、複数の検討対象断面を選定し、安全性能の照査を |
| 行う必要がある。また、設計断面形状を対象とした安全性能の照査や対策工 |
| の設計においても、造成盛土の上面等が将来にわたり様々な土地利用に供さ |
| れることを考慮して、通常の土地利用としてどのような利用状況となっても |
| 求められる機能が発揮されるよう、検討対象断面の選定や建ぺい率、上載荷 |
| 重等の設計条件の設定を適切に行う必要がある。なお、対策工の設計におい |
| て設計断面形状の見直しを行うことも考えられるが、この場合でも「3.4.1  |
| 基                                                                   |
| 本断面形状」に規定する基本断面形状を包含するよう設定する必要がある。 |
|                                                                      |
| 「3.5 安全性能の照査等」に従って設計した高規格堤防に対し、「3.6      |
| 土地利用の観                                                         |
| 点から要求される性能の照査等」に従い、土地利用上の配慮事項についても |
| 、共同事業者等との必要かつ十分な調整を行った上で検討する必要がある。 |
|                                                                      |
| また、築造中及び築造                                                 |
| 後ともに、高規格堤防及びその周辺において、他の河川管理施設等の機能、 |
| 上下流における既設の高規格堤防特別区域における通常の土地利用、堤内地 |
| の土地利用に重大な支障を与える変状が生じないよう留意する必要がある。 |
+----------------------------------------------------------------------+

＜必　須＞

+----------------------------------------------------------------------+
| 高規格堤防の設計に当たっては、高規格堤防及びその地盤が「3.2          |
| 機能」に規定する機能を満足するよう、基本的                           |
| な構造及び材質を設定した上で、設計の対象とする河道内の水位の状況と高 |
| 規格堤防及びその地盤に作用する荷重を考慮して安全性能の照査を行い、照 |
| 査結果に応じて対策を行うものとする。その際には、高規格堤防特別区域が |
| 将来にわたり様々な土地利用に供されることとなっても高規格堤防として十 |
| 分な治水機能が発揮されるよう、適切に設計条件等を設定するものとする。 |
| 加えて、共同事業者等との必要かつ十分な調整を行った上で、土地利用上、 |
| 必要とされる性能の照査を行い、照査結果に応じて対策を行うものとする。 |
|                                                                      |
| また、設計で前                                                       |
| 提とする締固め度等の施工条件及び維持管理の条件を設定するものとする。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1)  （財）リバーフロント整備センター：高規格堤防盛土設計・施工マニュアル，平成12年3月.

    1.  []{#_Toc199347115 .anchor}基本的な構造及び材質

        1.  []{#_Toc188019574 .anchor}基本断面形状

（１）高さ

＜考え方＞

+----------------------------------------------------------------------+
| 高規格堤防は、本章第2節に示す堤防が持つ機能                          |
| を包含するものであり、特に適用除外とする規定がない限り構造令第3章堤  |
| 防の各規定が適用されるものである。このため、高規格堤防の高さは「2.5  |
| 堤防の高さの設定                                                     |
| 」と同様に、計画高水流量以下の流水を安全に流下させるため、計画高水位 |
| （高潮区間においては計画高潮位）を設定した上で、洪水時及び高潮時等に |
| おける波浪、うねり、跳水等による一時的な水位上昇への対応、洪水時の巡 |
| 視や水防活動を実施する場合の安全の確保、流木等流下物への対応等種々の |
| 要素を包含するためにしかるべき余裕を確保できるよう定める必要がある。 |
|                                                                      |
| なお、高                                                             |
| 規格堤防は、まちづくり等と一体となって段階的に整備されるのが一般的で |
| あるが、その高さは上下流及び左右岸の堤防の高さとの整合が求められる。 |
+----------------------------------------------------------------------+

＜必　須＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------
  高規格堤防の高さは、河道計画において設定される計画高水位（高潮区間においては計画高潮位）に、計画高水流量に応じて構造令で定める値を加えた高さ以上とする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------

**（２）**天端幅

＜考え方＞

+----------------------------------------------------------------------+
| 高規格堤防は、現堤防                                                 |
| の背面に盛土を有する構造であるため、計画高水位（高潮区間においては計 |
| 画高潮位）以下の水位の流水の通常の作用に対して安全な構造を持つという |
| 堤防の機能を包含するものである。本章第2節において堤防の天端は、「2.6 |
| 断面形状の設定」に示したとおり設計することとしており、高規格堤防     |
| の天端幅についても、同項に規定される数値を最低限確保する必要がある。 |
|                                                                      |
| ただし、高規格堤防特別区域が通                                       |
| 常の土地利用に供され、現堤防裏のり部を河川巡視、洪水時の水防活動、緊 |
| 急車両の通行等河川管理のために使用することができないことから、「2.6  |
| 断                                                                   |
| 面形状の設定」に規定する天端幅のままでは不足する場合も想定される。高 |
| 規格堤防の完成後に天端幅を拡大することは困難であるため、高規格堤防特 |
| 別区域及び背後地の重要性等も踏まえて天端幅を適切に定める必要がある。 |
+----------------------------------------------------------------------+

＜必　須＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  高規格堤防の天端幅は、「第1章 河川構造物の設計 第2節 堤防 2.6 断面形状の設定」に規定する堤防の天端幅を最低限確保するものとし、高規格堤防の治水機能の確保、河川の巡視、洪水時の水防活動、緊急車両の円滑な通行等を勘案して、必要な天端幅を適切に設定するものとする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

**（３）**のり勾配

＜考え方＞

+----------------------------------------------------------------------+
| 高規格堤防ののり勾配は、高規格堤防の治水上の機能（「3.2              |
| 機能」＜考え方                                                       |
| ＞１）～３））を確保するため、構造令及び同令施行規則の規定を満足する |
| よう設定する必要がある。裏のり勾配については、設定方法として「3.5.2  |
| (1)                                                                  |
| 越流水による洗掘破壊に対する安                                       |
| 全性」＜例示＞に示す方法を適用すると、堤内側に1：約30の勾配となる。  |
|                                                                      |
| 表のり勾                                                             |
| 配は、高規格堤防が現堤防の背面に盛土を有する構造であることから、現堤 |
| 防の表のり勾配を踏襲してもよいが、新規に築造する場合は本章第2節「2.6 |
| 断面形状の                                                           |
| 設定」に示す堤防ののり勾配と同様の考え方で設定することが考えられる。 |
+----------------------------------------------------------------------+

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------
  高規格堤防ののり勾配は、「3.5.1 (1) 設計の対象とする状況と作用・荷重」に規定する堤防破壊形態・堤防破壊機構に対して安全な構造となるよう設定することを基本とする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------

2.  []{#_Toc199347117 .anchor}設計断面形状

＜考え方＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  高規格堤防の設計断面形状は、「3.4.1 基本断面形状」に規定する基本断面形状を包含する必要がある。ただし、段階的施工において、基本断面形状に満たない暫定断面で整備する場合はこの限りではなく、「3.7.3 段階的施工に関する留意点等」を参考に、設計断面形状を設定する必要がある。完成断面、暫定断面のいずれの場合にあっても、共同事業者等と必要かつ十分な調整を行い、盛土造成等を含めた当面の土地利用状況に応じて設定する必要がある。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  高規格堤防の設計断面形状は、治水の観点に基づき設定した基本断面形状を包含するとともに、高規格堤防特別区域における当面の土地利用や、段階的施工等を考慮して設定することを基本とする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

3.  []{#_Toc199347118 .anchor}材質

＜考え方＞

+----------------------------------------------------------------------+
| 高規格堤防は構造令に基づき盛土により築造する。高規格堤防の材         |
| 質を土とするのは、構造物の劣化現象が起きにくいことや高規格堤防の施工 |
| 性・経済性を考慮すると、地盤と最もなじみのよい土とするのが適当である |
| ためである。また、高規格堤防の沈下等を極力生じさせないために、堤体材 |
| 料として適当な性質をもつものを選定し、十分に締固めを行う必要がある。 |
|                                                                      |
| なお                                                                 |
| 、高規格堤防特別区域は通常の土地利用に供されることから、その材質は、 |
| 可能な限り利用状況に応じた各種基準に準じて対応することが求められる。 |
+----------------------------------------------------------------------+

＜必　須＞

  ------------------------------------------------------------------------------------------------------------
  高規格堤防の築造には、高規格堤防の堤体材料として適当な性質をもつものを用い、盛土により築造するものとする。
  ------------------------------------------------------------------------------------------------------------

＜推　奨＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  高規格堤防特別区域においては、土地利用に供されることを考慮し、盛土等の圧縮沈下を抑えられるよう十分な締固め管理を行うほか、地盤の地耐力、施工上のトラフィカビリティの確保を考慮し、コーン指数がある程度以上となる材料を選定することが望ましい。また、将来の土地利用形態に配慮して、関連基準等に従い、盛土材の最大粒径や礫等の混入率を満足する適切な材料を用いるとともに、圧縮性の大きい土や凍土、氷雪、草木、切株、その他の各種有害廃棄物を含む土を使用することは避ける等、土地利用へ配慮することが望ましい。なお、都市計画事業者等の共同事業者等との協議により、将来の土地利用に影響のない範囲で、盛土材料として建設汚泥の再生品等の活用は可能である。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1)  （財）リバーフロント整備センター：高規格堤防整備事業の手引，平成10年2月．

2)  （財）リバーフロント整備センター：高規格堤防盛土設計・施工マニュアル，平成12年3月.

3)  （財）国土技術研究センター：河川土工マニュアル，第3章 河川土工の設計
    > 3.1.3 堤体材料の選定，3.1.4 締固め度の規定，第4章 河川土工の施工
    > 4.2.5 建設機械の選定，4.3.4 盛土，第7章 各論 第7.6節
    > 土壌汚染対策，平成21年4月．

    1.  []{#_Toc199347119 .anchor}安全性能の照査等

＜考え方＞

+----------------------------------------------------------------------+
| 高規格堤防は、「3.5.1                                                |
| 設計の対象とする状況と作用・荷重」に示す状況と照査項目               |
| ごとに、照査の条件として適切な河道内の水位と高規格堤防及びその地盤に |
| 作用する荷重の組合せを考慮し、安全性能について照査を行う必要がある。 |
|                                                                      |
| 安全性能の照査に当たっては、照査項目に応じて、より厳                 |
| しい条件（設計上安全側となる条件）となる形状が異なることから、各項目 |
| の照査の対象とする断面の位置を適切に設定する必要がある。なお、高規格 |
| 堤防の基本断面形状、設計断面形状ともに安全性能を満足する必要があるが |
| 、照査項目や現地条件、高規格堤防の縦横断形状等によっては、より厳しい |
| 条件となる断面形状での照査を行い、他方の照査を省略できる場合もある。 |
+----------------------------------------------------------------------+

＜必　須＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  高規格堤防の設計に当たっては、「3.5.1 設計の対象とする状況と作用・荷重」に示す状況と照査項目に応じて、設計で考慮する河道内の水位と高規格堤防及びその地盤に作用する荷重の組合せを設定して、安全性能について照査するものとする。安全性能の照査に当たっては、構造令施行規則第13条の2から第13条の5に示される構造計算に基づく照査を行うものとし、照査項目に応じて検討対象断面位置を設定するものとする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  安全性能の照査に用いる手法としては、構造令に規定される手法のほか、これまでの経験及び実績から妥当とみなせる方法、実験等による検証がなされた方法又は論理的で妥当性を有する方法等、適切な知見に基づく手法を用いることを基本とする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

1.  []{#_Toc199347120 .anchor}設計の対象とする状況と作用・荷重

（１）設計の対象とする状況と作用・荷重

＜考え方＞

+----------------------------------------------------------------------+
| 高規格堤防の設計に当たっては、構造令第22条の2、第22条                |
| の3に従い、表3-1に示す状況と照査項目に応じて想定する水位及び作用・荷 |
| 重とその組合せを設定する必要がある。なお、「洪水及び地震時」と「地震 |
| 時」に考慮する作用・荷重と河道内の水位との組合せについては、「3.5.2  |
| （３） 浸透破壊に対する安全性　１）                                  |
| すべり破壊に対する安全性」（表3-3）、「3.5.2 （４）                  |
| 地震時の液状化破壊・すべり破壊に対する安全性　１）                   |
| 構造令施行規                                                         |
| 則に規定される設計震度に対する安全性」（表3-4、表3-5）に示している。 |
|                                                                      |
| また、構                                                             |
| 造令及び同令施行規則に規定される照査項目に加えて表3-2に示す状況と照  |
| 査項目に対しても、適切な手法を用いて安全性能の照査を行う必要がある。 |
+----------------------------------------------------------------------+

＜必　須＞

+----------------------------------------------------------------------+
| 高規格堤防の安全性能の照査は、設計の対象とする状況、照査項           |
| 目及び作用・荷重を次の表のように設定するものとする。また、「（２）設 |
| 計で考慮する水位」に示す河道内の水位との組合せを考慮するものとする。 |
|                                                                      |
| 表3-1　構造                                                          |
| 令及び同令施行規則に基づく安全性能の照査の対象とする状況と作用・荷重 |
|                                                                      |
| +------------+------------+------------+------------+------------+   |
| | **状況**   | 照査項目   | **作       | **備考**   |            |   |
| |            |            | 用・荷重** |            |            |   |
| +============+============+============+============+============+   |
| |            | **堤防     | **堤防     |            |            |   |
| |            | 破壊形態** | 破壊機構** |            |            |   |
| +------------+------------+------------+------------+------------+   |
| | **洪水時** | **越流     | **越流水に | **越       | **         |   |
| |            | 水による** | よる洗掘** | 流水による | 河道内の水 |   |
| |            |            |            | せん断力** | 位が高規格 |   |
| |            | **         |            |            | 堤防設計水 |   |
| |            | 洗掘破壊** |            |            | 位以下であ |   |
| |            |            |            |            | ることを条 |   |
| |            |            |            |            | 件とする** |   |
| +------------+------------+------------+------------+------------+   |
| |            | **河道内の | **河道     | **河道内   |            |   |
| |            | 流水による | 内の流水に | の流水によ |            |   |
| |            | 侵食破壊** | よる侵食** | る流体力** |            |   |
| +------------+------------+------------+------------+------------+   |
| |            | **         | **雨       | **         |            |   |
| |            | 浸透破壊** | 水及び河道 | 自重、河道 |            |   |
| |            |            | 内の流水の | 内の流水に |            |   |
| |            |            | 浸透による | よる静水圧 |            |   |
| |            |            | 間隙圧の変 | 、間隙圧（ |            |   |
| |            |            | 化による堤 | 高規格堤防 |            |   |
| |            |            | 防及び地盤 | 及びその地 |            |   |
| |            |            | のすべり** | 盤の内部の |            |   |
| |            |            |            | 浸透流によ |            |   |
| |            |            |            | る水圧）** |            |   |
| +------------+------------+------------+------------+------------+   |
| |            |            | **浸透水に | **河道     |            |   |
| |            |            | よるパイプ | 内の流水に |            |   |
| |            |            | 状の地盤土 | よる静水圧 |            |   |
| |            |            | 砂流出路の | 、間隙圧（ |            |   |
| |            |            | 形成・発達 | 高規格堤防 |            |   |
| |            |            | （パイピン | 及びその地 |            |   |
| |            |            | グ破壊）** | 盤の内部の |            |   |
| |            |            |            | 浸透流によ |            |   |
| |            |            |            | る水圧）** |            |   |
| +------------+------------+------------+------------+------------+   |
| |            |            | **         |            |            |   |
| |            |            | 浸透水の流 |            |            |   |
| |            |            | 出に伴う堤 |            |            |   |
| |            |            | 防の侵食** |            |            |   |
| +------------+------------+------------+------------+------------+   |
| | **洪水及   | **         | **         | **自重、   | **構       |   |
| | び地震時** | 浸透破壊** | 雨水及び河 | 河道内の流 | 造令第22条 |   |
| |            |            | 道内の流水 | 水による静 | の2に規定  |   |
| |            |            | の浸透によ | 水圧、地震 | される河道 |   |
| |            |            | る間隙圧、 | 時における | 内の水位と |   |
| |            |            | 地震時慣性 | 高規格堤防 | 荷重の組合 |   |
| |            |            | 力に伴う堤 | 及びその地 | せによる** |   |
| |            |            | 防及び地盤 | 盤の慣性力 |            |   |
| |            |            | のすべり** | 、間隙圧（ |            |   |
| |            |            |            | 高規格堤防 |            |   |
| |            |            |            | 及びその地 |            |   |
| |            |            |            | 盤の内部の |            |   |
| |            |            |            | 浸透流によ |            |   |
| |            |            |            | る水圧）** |            |   |
| +------------+------------+------------+------------+------------+   |
| | **地震時** | **液       | **地       | **自重、   |            |   |
| |            | 状化破壊** | 盤の液状化 | 河道内の流 |            |   |
| |            |            | に伴う堤防 | 水による静 |            |   |
| |            |            | 沈下・変形 | 水圧、間隙 |            |   |
| |            |            | 等の発生** | 圧（地震時 |            |   |
| |            |            |            | における高 |            |   |
| |            |            |            | 規格堤防及 |            |   |
| |            |            |            | びその地盤 |            |   |
| |            |            |            | の慣性力に |            |   |
| |            |            |            | 伴う過剰間 |            |   |
| |            |            |            | 隙水圧）** |            |   |
| +------------+------------+------------+------------+------------+   |
| |            | **す       | **         | **自重、河 |            |   |
| |            | べり破壊** | 地震時慣性 | 道内の流水 |            |   |
| |            |            | 力に伴う堤 | による静水 |            |   |
| |            |            | 防及び地盤 | 圧、地震時 |            |   |
| |            |            | のすべり** | における高 |            |   |
| |            |            |            | 規格堤防及 |            |   |
| |            |            |            | びその地盤 |            |   |
| |            |            |            | の慣性力** |            |   |
| +------------+------------+------------+------------+------------+   |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| レベル2地震動及び常時の沈下等に対する照査は、設計の対象と            |
| して必要とされる状況と作用を次の表のように設定することを基本とする。 |
|                                                                      |
| **表3-2　高規格堤防の設計の対象とする状況と作用・荷重**              |
|                                                                      |
| +---------------+---------------+---------------+---------------+    |
| | 状況          | 照査項目      | 作用・荷重    | 備考          |    |
| +===============+===============+===============+===============+    |
| | **地震時**    | **耐震性      | **自重、      | **河道内      |    |
| |               | 能（地盤の液  | 河道内の流水  | の水位が通常  |    |
| | **（レベ      | 状化に伴う堤  | による静水圧  | 想定される水  |    |
| | ル2地震動）** | 防沈下・変形  | 、地震時にお  | 位である場合  |    |
| |               | 等の発生）**  | ける高規格堤  | を想定する**  |    |
| |               |               | 防及びその地  |               |    |
| |               |               | 盤の慣性力に  |               |    |
| |               |               | 伴う過剰間隙  |               |    |
| |               |               | 水圧の影響**  |               |    |
| +---------------+---------------+---------------+---------------+    |
| | **常時**      | **沈下**      | **自重、構造  |               |    |
| |               |               | 物の載荷重**  |               |    |
| |               | **（不等沈    |               |               |    |
| |               | 下を含む）**  |               |               |    |
| +---------------+---------------+---------------+---------------+    |
| |               | *             | **自重**      |               |    |
| |               | *側方変位、引 |               |               |    |
| |               | き込み沈下**  |               |               |    |
| +---------------+---------------+---------------+---------------+    |
+----------------------------------------------------------------------+

＜推　奨＞

+----------------------------------------------------------------------+
| 高規格堤防及びその地盤に作                                           |
| 用する荷重としては、堤防（第3章第2節）やダム（第2章）と同様に、高規  |
| 格堤防の自重、静水圧、地震時における慣性力に加えて、高規格堤防の特徴 |
| である越流水による洗掘破壊に対する安全性能の照査において検討すべき越 |
| 流水によるせん断力等があり、次のような方法で設定することが望ましい。 |
|                                                                      |
| > １）自重                                                           |
| >                                                                    |
| > 自重は、高規格堤防の材料の単位体積                                 |
| 重量を用いて算出する。単位体積重量は、原則として、実際に使用する材料 |
| について試験を行い、その結果と想定される湿潤状態を考慮して設定する。 |
| >                                                                    |
| > ２）河道内静水圧                                                   |
| >                                                                    |
| > 河道内の水位の状況（高規格堤防設計水位、計画高水位、平水位）に応   |
| じて、堤体に作用する河道側からの水圧を、静水圧と仮定して作用させる。 |
| >                                                                    |
| > ３）地震時慣性力                                                   |
| >                                                                    |
| > 地震                                                               |
| 時における高規格堤防の慣性力は、高規格堤防及びその地盤に水平に作用さ |
| せるものとし、高規格堤防及びその地盤の自重に設計震度を乗じて求める。 |
| >                                                                    |
| > ４）間隙圧                                                         |
| >                                                                    |
| > 間隙圧として、高規格堤防及びその地盤の                             |
| 内部の浸透流による間隙水圧と地震時の過剰間隙水圧を考慮する。なお、浸 |
| 透流には河道内の流水と降雨による浸透水を含む。また、地震時の過剰間隙 |
| 水圧の影響として、地盤の液状化に伴う過剰間隙水圧の発生に起因する強度 |
| 低下、剛性低下等を考慮する。これらの間隙圧が発生すると、例えば、すべ |
| り破壊におけるすべり面の摩擦抵抗が減ぜられ、変形が生じる状態となる。 |
| >                                                                    |
| > ５）越流水によるせん断力                                           |
| >                                                                    |
| > 高規格                                                             |
| 堤防上を越流水が流下する場合、流水との接触面に平行にせん断力を作用さ |
| せる。せん断力が一定以上になると堤体表面から洗掘が生じることとなる。 |
| >                                                                    |
| > ６）河道内の流水による流体力                                       |
| >                                                                    |
| > 高規格堤防設計水位以下の河道内の流水による流体力を作用させる。     |
+----------------------------------------------------------------------+

＜関連通知等＞

1)  （財）リバーフロント整備センター：高規格堤防整備事業の手引，平成10年2月．

2)  国土交通省水管理・国土保全局河川計画課長,治水課長通達：河川津波対策について，
    > 平成 23 年 9 月 2 日，国水河計第 20 号，国水治第 35 号.

**（２）**設計で考慮する水位

＜考え方＞

+----------------------------------------------------------------------+
| 高規格堤                                                             |
| 防の設計に当たっては、高規格堤防設計水位、計画高水位、平水位を基準と |
| して、堤防の破壊形態、破壊機構に応じて適切な河道内の水位を想定する。 |
|                                                                      |
| 高規格堤防設計水位の設定は、洪水等                                   |
| により発生する河道内の最高水位に基づいて行う必要がある。このとき、河 |
| 道内の最高水位は水面上の微細な変動は無視した平均的水位を対象とする。 |
|                                                                      |
| なお、高規格堤防設計水位                                             |
| は、おおよそ起こりうる河道内の最高水位であり、計画堤防天端高（堤防満 |
| 杯流）の水位において、その時にいかなる地点でも発生しうる河床変動等に |
| 起因する水位変動による外力に対処できるよう設定することが求められる。 |
|                                                                      |
| また、越水現象は、過去の堤防越水の状況でも報告されているよ           |
| うに、高規格堤防の天端の高さが上下流方向になめらかな場合には、相当区 |
| 間平均に薄層で発生すると考えられる。このため、高規格堤防設置区間の多 |
| くの区間では、堤防天端高とほぼ近い高さの水位で流下すると想定される。 |
|                                                                      |
| このように定め                                                       |
| られる高規格堤防設計水位には、河道形状の影響による現象等が加味されて |
| おらず、そうした現象等を反映する必要があるため、一定の降雨を与えて流 |
| 出解析を行い、不定流計算等によりその状況を想定することが求められる。 |
+----------------------------------------------------------------------+

＜必　須＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------
  設計で考慮する水位としては、高規格堤防設計水位、計画高水位、平水位を設定するものとする。高規格堤防設計水位は、流域の水文特性及び河道計画等に基づき定めるものとする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜例　示＞

+----------------------------------------------------------------------+
| 河道内の最高水位は次のように求めることができる。                     |
|                                                                      |
| > １）不定流計算及び高潮計算                                         |
| >                                                                    |
| > まず、                                                             |
| 高規格堤防設置区間において、想定し得る最大規模の洪水流量を算定する。 |
| >                                                                    |
| > また、                                                             |
| 上記区間の河口において同様に発生すると考えられる最高潮位を算定する。 |
| >                                                                    |
| > この潮位                                                           |
| をもとに下流端水位条件を設定し、高規格堤防からの越流を考慮した不定流 |
| 計算を行い、高規格堤防設置区間における各地点でのピーク水位を求める。 |
| >                                                                    |
| > なお、不定流計算に用いる越水の流量係数は*C* =0.6m^1/2^/sとする。   |
| >                                                                    |
| > ２）河床変動等に起因する水位変動の加味                             |
| >                                                                    |
| > 予想される洪水時の河床変動等に起因する水位変                       |
| 動の影響を１）で求めた水位に加味したものを、河道内の最高水位とする。 |
|                                                                      |
| 高規格堤防設計水位の設定は計算された河道内の最高水位に基づいて       |
| 行うことになるが、その際には最高水位の計算精度、計算条件のもつ不確定 |
| 要素等を十分踏まえ、設計のための水位として適切となるように留意する。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1)  （財）リバーフロント整備センター：高規格堤防整備事業の手引，平成10年2月．

2)  国土交通省水管理・国土保全局：浸水想定（洪水、内水）の作成等のための想定最大外力の設定手法，平成27年7月.

3)  国土交通省水管理・国土保全局河川環境課水防企画室
    > 国土技術政策総合研究所河川研究部水害研究室：洪水浸水想定区域図作成マニュアル（第4版），平成27年7月．

4)  農林水産省農村振興局整備部防災課農林水産省水産庁漁港漁場整備部防災漁村課国土交通省水管理・国土保全局河川環境課国土交通省水管理・国土保全局海岸室国土交通省港湾局海岸・防災課：高潮浸水想定区域図作成の手引きVer2.11、令和5年4月．

    1.  []{#_Toc199347121 .anchor}安全性能の照査

（１）越流水による洗掘破壊に対する安全性

＜考え方＞

+----------------------------------------------------------------------+
| 高規格堤防は、堤防の一部が通常の土                                   |
| 地利用に供されても越流水による洗掘破壊に対して耐える構造とする必要が |
| ある。このため、河道内の水位が高規格堤防設計水位である場合の越流水の |
| 流速を、堤体表面の許容せん断力を上回らない流速以下にする必要がある。 |
|                                                                      |
| 越流水の                                                             |
| 流速は高規格堤防の裏のり勾配に左右されるため、堤体表面における越流水 |
| によるせん断力に対して安全となる裏のり勾配を定めることが求められる。 |
+----------------------------------------------------------------------+

＜必　須＞

  ----------------------------------------------------------------------------------------------------
  高規格堤防設計水位の作用時の越流水による洗掘破壊に対して安全な構造となるように設計するものとする。
  ----------------------------------------------------------------------------------------------------

＜例　示＞

+----------------------------------------------------------------------+
| 高規格堤防の裏                                                       |
| のり勾配は、越流水によるせん断力τが高規格堤防表面の許容せん断力τ~a~  |
| を超えないような勾配として求めることができる。                       |
|                                                                      |
|   ------------ ---------                                             |
|   τ　≦　τ~a~   （3-1）                                               |
|   ------------ ---------                                             |
|                                                                      |
|   τ      ：　越流水によるせん断力（kN/m^2^）                         |
|   ------ -------------------------------------------                 |
|   τ~a~   ：　高規格堤防表面の許容せん断力(kN/m^2^)                   |
|                                                                      |
| また、越流水によるせん断力τは以下の式で算出することができる。        |
|                                                                      |
|   --------------------------- --------                               |
|   τ　＝　*W~0~・h~s~・I~e~*   (3-2）                                 |
|   --------------------------- --------                               |
|                                                                      |
|   τ        ：　越流水によるせん断力（kN/m^2^）                       |
|   ------                                                             |
| -- ----------------------------------------------------------------- |
|   *W~0~*   ：　水の単位体積重量（kN/m^3^）                           |
|   *h~s~*   ：　高規格堤防の裏のり表面における越流水の水深（m）       |
|   *I~e~*   ：　越流水のエネルギー勾配                                |
|   *I*                                                                |
|      ：　高規格堤防の裏のり勾配（等流条件を仮定して*I*　＝　*I~e~*） |
|                                                                      |
| τとτ~                                                                |
| a~は高規格堤防上の土地利用状況等によって大きく変化するため、設計にお |
| いては土地利用状況等の想定とそれに応じたτとτ~a~の算定が重要である。  |
|                                                                      |
| 高規格堤防の設計においては、高規格堤防特別区域が通常の土地利用として |
| どのような利用状況となっても、高規格堤防として十分な治水機能が発揮さ |
| れるよう適切に設計条件を設定する必要がある。高規格堤防特別区域が市街 |
| 地としての土地利用に供せられる場合、宅地等として利用される複数の水平 |
| 地盤面及びそれらの境界での段差、道路で構成されることが一般的である。 |
| この場合、一般に越流水が堤防法線と直角にとおる裏のり道路部に集中する |
| 状況が最も厳しい条件となることから、この道路の表面に作用する越流水に |
| よるせん断力が許容せん断力を上回らないように堤防裏のり勾配を定めるこ |
| とが考えられる。このとき、高規格堤防表面の許容せん断力としては、より |
| ひび割れ等が生じにくいコンクリート舗装面ではなく、アスファルト舗装面 |
| を想定する。高規格堤防表面の許容せん断力τ~a~の値は、高規格堤防上の道 |
| 路の耐侵食力の推定を行った既往検討＜参考となる資料1)＞に基づき、一般 |
| 的な道路構造において最も小さい0.078kN/m^2^を用いることが考えられる。 |
|                                                                      |
| ここに、道路上の流れを等流条件と仮定すると、以下の式となる。         |
|                                                                      |
|   *Q* 　＝　*A・v*　＝　*A*（1/*n・R                                 |
| * ^2/3^・*I*^1/2^）　＝　 *b・h~r~*（1/*n・h~r~*^2/3^*・I*^1/2^）    |
|   -------------------------------------------                        |
| ---------------------------------------------------------- --------- |
|   *h~r~*　＝　（*Q・n* / (*b・I*^1/2^)）^3/                          |
| 5^                                                           （3-3） |
|                                                                      |
| 越流水                                                               |
| が道路部に集中すると仮定した場合、式（3-2）は以下の式に変換される。  |
|                                                                      |
|   ------------------------------------------------ ---------         |
|   τ　＝　*W~0~・n*^3/5^・*q~r~*^3/5^・*I* ^7/10^   （3-4）           |
|   ------------------------------------------------ ---------         |
|                                                                      |
| 　ここで、*q                                                         |
| ~r~*は越流水が道路部に集中すると仮定した場合の、単位幅あたりの越流水 |
| の流量（式(3-3)における*Q/b*に該当）であり、以下の式より求められる。 |
|                                                                      |
|   ----------------------- ---------                                  |
|   *q~r~*　＝　*q・R~r~*   （3-5）                                    |
|   ----------------------- ---------                                  |
|                                                                      |
| 以上より、道路面に作用するせん断力は以下の式より求められる。         |
|                                                                      |
|   ------------------------------------------------------- ---------  |
|   τ　＝　*W~0~・n*^3/5^・（*q・R~r~*）^3/5^・*I* ^7/10^   （3-6）    |
|   ------------------------------------------------------- ---------  |
|                                                                      |
| +----                                                                |
| ----+--------------------------------------------------------------+ |
| | *Q*                                                                |
|     | ：　道路上を流下する越流水の流量（m^3^/s）                   | |
| +====                                                                |
| ====+==============================================================+ |
| | *A*                                                                |
|     | ：　道路上を流下する越流水の流積（m^2^）                     | |
| +----                                                                |
| ----+--------------------------------------------------------------+ |
| | *v*                                                                |
|     | ：　道路上を流下する越流水の流速（m/s）                      | |
| +----                                                                |
| ----+--------------------------------------------------------------+ |
| | *R*                                                                |
|     | ：　道路上を流下する越流水の径深（m）                        | |
| |                                                                    |
|     |                                                              | |
| |                                                                    |
|     | (等流条件を仮定して*R　≒　[h~s~]{.underline}*)               | |
| +----                                                                |
| ----+--------------------------------------------------------------+ |
| | *I*                                                                |
|     | ：　高規格堤防の裏のり勾配                                   | |
| |                                                                    |
|     |                                                              | |
| |                                                                    |
|     | （＝堤防法線と直角にとおる裏のり道路の勾配）                 | |
| +----                                                                |
| ----+--------------------------------------------------------------+ |
| | *b*                                                                |
|     | ：　道路幅(m)                                                | |
| +----                                                                |
| ----+--------------------------------------------------------------+ |
| | *n*                                                                |
|     | ：　道路表面のマニングの粗度係数（s/m^1/3^）                 | |
| +----                                                                |
| ----+--------------------------------------------------------------+ |
| | *h~                                                                |
| r~* | ：　道路表面上における越流水の水深（m）                      | |
| +----                                                                |
| ----+--------------------------------------------------------------+ |
| | *q~                                                                |
| r~* | ：　越流水が道路部に集中すると仮定した場合の、単位幅あたりの | |
| |                                                                    |
|     |                                                              | |
| |                                                                    |
|     | 越流水の流量（m^3^/s/m）                                     | |
| +----                                                                |
| ----+--------------------------------------------------------------+ |
| | *q*                                                                |
|     | ：　単位幅あたりの越流水の流量（m^3^/s/m）                   | |
| +----                                                                |
| ----+--------------------------------------------------------------+ |
| | *R~                                                                |
| r~* | ：　堤防法線と直角にとおる裏のり道路一本の幅に対する、       | |
| |                                                                    |
|     |                                                              | |
| |                                                                    |
|     | > その道路が越流水に対して受け持つ堤防法線長の比             | |
| +----                                                                |
| ----+--------------------------------------------------------------+ |
| | *W~                                                                |
| 0~* | ：　水の単位体積重量（kN/m^3^）                              | |
| +----                                                                |
| ----+--------------------------------------------------------------+ |
|                                                                      |
| > *n*                                                                |
| >                                                                    |
|  の値は、アスファルト舗装面の粗度係数として大きめの0.016（s/m^1/3^） |
| > を目安とし                                                         |
| 、高規格堤防上の標準街区における最低の道路面積率を18%とすると*R~r~*  |
| > の値は10.6となり、式（3-6）は以下の式に変換される。                |
|                                                                      |
|   --------------------------------------------- ---------            |
|   τ　＝　3.38 *q* ^3/5^・*I* ^7/10^ (kN/m^2^)   （3-7）              |
|   --------------------------------------------- ---------            |
|                                                                      |
| > ま                                                                 |
| た、単位幅越流量*q*は以下の式により求める。流量係数*C*の値は、高規格 |
| 堤防の模型実験を行い、高規格堤防上の越流水の挙動の推定を行った既往検 |
| 討＜参考となる資料2)＞に基づき、一般的には1.6（m^1/2^/s）を用いる。  |
|                                                                      |
|   ------------------------- ---------                                |
|   *q*　＝　*C・h~k~*^3/2^   （3-8）                                  |
|   ------------------------- ---------                                |
|                                                                      |
|   *h~k~*   ：　計画堤防天端高を基準とする高規格堤防設計水位（m）     |
|   -------- -------------------------------------------------------   |
|   *C*      ：　流量係数（m^1/2^/s）                                  |
|                                                                      |
| 以上より                                                             |
| 、式（3-7）、（3-8）より求めたτが高規格堤防表面の許容せん断耐力τ~a~  |
| を超えないよう、式（3-1）を満足するように高規格堤防の裏のり勾配*I*   |
| を定めることができる。                                               |
+----------------------------------------------------------------------+

＜関連通知等＞

1)  建設省河川局水政課長,建設省河川局河川計画課長,建設省河川局治水課長通達：河川管理施設等構造令及び同令施行規則の運用について，平成4年2月1日（最終改正平成11年10月15日），建設省河政発第32号　建設省河計発第37号　建設省河治発第10号（建設省河政発第74号　河計発第83号　河治発39号）.

2)  （財）リバーフロント整備センター：高規格堤防整備事業の手引，平成10年2月．

＜参考となる資料＞

1)  宇多高明・藤田光一ほか：「道路内の流水による舗装面の破壊　－高規格堤防の水理設計のために（３）－」，土木研究所資料，第3226号.

2)  宇多高明・藤田光一ほか：「高規格堤防上の越流水の挙動　－高規格堤防の水理設計のために（２）－」，土木研究所資料，第3220号.

（２）河道内の流水による侵食破壊に対する安全性

＜考え方＞

  -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  本章第2節に規定する堤防は、「2.4 設計の基本」に示すように護岸、水制その他これらに類する施設と一体として、計画高水位以下の水位の流水の通常の作用による侵食破壊に対して安全な構造となるよう設計される。高規格堤防は、このような条件を包含するとともに、高規格堤防設計水位以下の水位における河道内の流水の作用による侵食破壊に対しても安全な構造となるよう設計することが求められる。このため、水衝部等においては、必要に応じて護岸、水制等を設ける等、その外力に見合う措置を設計に組み込む必要がある。なお、河道内の流水の作用として、表のり肩付近における越流水の作用も併せて考える必要がある。
  -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜必　須＞

  ----------------------------------------------------------------------------------------------------------
  高規格堤防設計水位以下の河道内の流水の作用による侵食破壊に対して安全な構造となるよう設計するものとする。
  ----------------------------------------------------------------------------------------------------------

＜関連通知等＞

1)  建設省河川局水政課長,建設省河川局河川計画課長,建設省河川局治水課長通達：河川管理施設等構造令及び同令施行規則の運用について，平成4年2月1日（最終改正平成11年10月15日），建設省河政発第32号
    > 建設省河計発第37号 建設省河治発第10号（建設省河政発第 74号
    > 河計発第83号 河治発39号）.

2)  （財）国土技術研究センター：河川堤防の構造検討の手引き（改訂版），第5章
    > 侵食に対する堤防の構造検討，平成24年2月．

3)  （財）リバーフロント整備センター，多自然川づくり研究会編：多自然型川づくりポイントブックⅢ，平成23年10月．

4)  （一財）国土技術研究センター：改訂護岸の力学設計法，第4章護岸の力学的安定性の照査に用いる設計条件，2023.

5)  （財）国土技術研究センター：河道計画検討の手引き，第8章
    > 河道の平面計画，平成14年2月.

（３）浸透破壊に対する安全性

> １）すべり破壊に対する安全性

＜考え方＞

+----------------------------------------------------------------------+
| 高規格堤防及びその地盤の浸透によるすべり破壊に対する安全性は、構造   |
| 令施行規則第13条の5（第10条第2項）に基づく円弧すべり法により安定計算 |
| を行う必要がある。このとき、河道内の水位が高規格堤防設計水位（又は高 |
| 規格堤防設計水位から平水位まで低下）の場合は地震時慣性力を考慮しない |
| が、計画高水位（又は計画高水位から平水位まで低下）の場合は、構造令施 |
| 行規則第13条の3第3項に従い、同則第1項に規定する値の2分の1の設計震度  |
| による地震時慣性力を考慮する必要がある。安定計算に用いる外力条件（河 |
| 道内の水位、設計震度）の組合せは表3-3に示すとおりであるが、この設計  |
| 震度は地盤条件がⅢ種地盤、かつ高規格堤防の幅・高さ比が20以上の場合を  |
| 想定したもののため、高規格堤防設置区間における地震履歴、土質、地盤の |
| 特性、堤防規模等から表3-3の値よりも大きな設計震度を用いる必要がある  |
| と判断される場合には、適切な方法を用いて設計震度を定める必要がある。 |
|                                                                      |
| 円                                                                   |
| 弧すべり法による安定計算に当たっては、河道内の水位と降雨を考慮した外 |
| 力条件で非定常浸透流解析を行って、堤体内浸潤面を算出する必要がある。 |
| また、円弧すべり法による最小安全率は、構造令施行規則に従い1.2とする  |
| 必要がある。なお、円弧すべり法に用いる間隙圧としては、浸透流解析によ |
| って得られた浸潤面からの静水圧を与える方法が一般的に用いられている。 |
|                                                                      |
| 表3-3                                                                |
| 　浸透によるすべり破壊に関する安定計算に用いる河道内の水位と設計震度 |
|                                                                      |
| +-------+-------+-------+-------+-------+-------+-------+-------+    |
| | *     | *     | **計  | **設  | **計  | *     |       |       |    |
| | *No** | *河道 | 算対  | 計震  | 算に  | *間隙 |       |       |    |
| |       | 内の  | 象**  | 度**  | 用い  | 圧**  |       |       |    |
| |       | 水位  |       |       | る**  |       |       |       |    |
| |       | の状  | のり* |       |       |       |       |       |    |
| |       | 況**  | *面** |       | **河  |       |       |       |    |
| |       |       |       |       | 道内  |       |       |       |    |
| |       |       |       |       | の水  |       |       |       |    |
| |       |       |       |       | 位**  |       |       |       |    |
| +=======+=======+=======+=======+=======+=======+=======+=======+    |
| |       |       |       | *     | *     | *     |       |       |    |
| |       |       |       | *強震 | *中震 | *弱震 |       |       |    |
| |       |       |       | 帯**  | 帯**  | 帯**  |       |       |    |
| |       |       |       |       |       |       |       |       |    |
| |       |       |       | **地  | **地  | **地  |       |       |    |
| |       |       |       | 域**  | 域**  | 域**  |       |       |    |
| +-------+-------+-------+-------+-------+-------+-------+-------+    |
| | **1** | **計  | *     | **-** | **-** | **-** | *     | *     |    |
| |       | 画高  | *裏** |       |       |       | *高規 | *当該 |    |
| |       | 水位  | のり* |       |       |       | 格堤  | 水位  |    |
| |       | を超  | *面** |       |       |       | 防設  | 時の  |    |
| |       | え**  |       |       |       |       | 計水  | 間隙  |    |
| |       |       |       |       |       |       | 位**  | 圧**  |    |
| |       | *     |       |       |       |       |       |       |    |
| |       | *高規 |       |       |       |       |       |       |    |
| |       | 格堤  |       |       |       |       |       |       |    |
| |       | 防設  |       |       |       |       |       |       |    |
| |       | 計水  |       |       |       |       |       |       |    |
| |       | 位以  |       |       |       |       |       |       |    |
| |       | 下**  |       |       |       |       |       |       |    |
| +-------+-------+-------+-------+-------+-------+-------+-------+    |
| | **2** | **平  | *     | **0.  | **0   | **0   | *     | *     |    |
| |       | 水位  | *裏** | 075** | .06** | .05** | *計画 | *当該 |    |
| |       | を超  | のり* |       |       |       | 高水  | 水位  |    |
| |       | え**  | *面** |       |       |       | 位**  | 時の  |    |
| |       |       |       |       |       |       |       | 間隙  |    |
| |       | *     |       |       |       |       |       | 圧**  |    |
| |       | *計画 |       |       |       |       |       |       |    |
| |       | 高水  |       |       |       |       |       |       |    |
| |       | 位以  |       |       |       |       |       |       |    |
| |       | 下**  |       |       |       |       |       |       |    |
| +-------+-------+-------+-------+-------+-------+-------+-------+    |
| | **3** | **水  | *     | **-** | **-** | **-** | *     | *     |    |
| |       | 位が  | *表** |       |       |       | *高規 | *水位 |    |
| |       | 急速  | のり* |       |       |       | 格堤  | 低下  |    |
| |       | に低  | *面** |       |       |       | 防設  | 後の  |    |
| |       | 下**  |       |       |       |       | 計水  | 間隙  |    |
| |       |       |       |       |       |       | 位→　 | 圧**  |    |
| |       |       |       |       |       |       | 平水  |       |    |
| |       |       |       |       |       |       | 位**  |       |    |
| +-------+-------+-------+-------+-------+-------+-------+-------+    |
| | **4** | **水  | *     | **0.  | **0   | **0   | *     | *     |    |
| |       | 位が  | *表** | 075** | .06** | .05** | *計画 | *水位 |    |
| |       | 急速  | のり* |       |       |       | 高水  | 低下  |    |
| |       | に低  | *面** |       |       |       | 位**  | 後の  |    |
| |       | 下**  |       |       |       |       |       | 間隙  |    |
| |       |       |       |       |       |       | **→　 | 圧**  |    |
| |       |       |       |       |       |       | 平水  |       |    |
| |       |       |       |       |       |       | 位**  |       |    |
| +-------+-------+-------+-------+-------+-------+-------+-------+    |
+----------------------------------------------------------------------+

＜必　須＞

  ---------------------------------------------------------------------------------------------------------------------------------
  高規格堤防及びその地盤における浸透破壊に対して安全な構造となるよう、円弧すべり法による最小安全率を1.2として設計するものとする。
  ---------------------------------------------------------------------------------------------------------------------------------

＜例　示＞

  ------------------------------------------------------------------------------------------------
  堤体内浸潤面の算出については、有限要素法を用いた非定常浸透流解析等により算出することができる。
  ------------------------------------------------------------------------------------------------

＜関連通知等＞

1)  建設省河川局水政課長,建設省河川局河川計画課長,建設省河川局治水課長通達：河川管理施設等構造令及び同令施行規則の運用について，平成4年2月1日（最終改正平成11年10月15日），建設省河政発第32号
    > 建設省河計発第37号 建設省河治発第10号（建設省河政発第 74号
    > 河計発第83号 河治発39号）.

2)  （財）国土技術研究センター：河川堤防の構造検討の手引き（改訂版），第4章
    > 浸透に対する堤防の構造検討，平成24年2月．

3)  (独)土木研究所地質・地盤研究グループ土質・振動チーム：河川堤防の浸透に対する照査・設計のポイント，平成25年6月．

4)  （財）リバーフロント整備センター：高規格堤防盛土設計・施工マニュアル，平成12年3月.

> ２）パイピング破壊に対する安全性

＜考え方＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  河道内の水位が高規格堤防設計水位以下の水位である場合に、高規格堤防及びその地盤のパイピング破壊に対して安全な構造となるよう設計することが求められる。パイピングは、高規格堤防とその地盤、又は構造物とその地盤の接合部及びその付近における浸透現象であり、高規格堤防特別区域で通常の土地利用がなされても、河道内の水位と川裏側の地表面との差から生じる浸透力に対して耐えうる構造とすることが求められる。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜必　須＞

  ----------------------------------------------------------------------------------------------
  高規格堤防及びその地盤におけるパイピング破壊に対して安全な構造となるよう設計するものとする。
  ----------------------------------------------------------------------------------------------

＜推　奨＞

  ----------------------------------------------------------------------------------------------------------------------------------
  パイピング破壊に対する対策を実施する場合は、地下水環境の保持等の観点から全区間連続した遮水矢板等の設置は行わないことが望ましい。
  ----------------------------------------------------------------------------------------------------------------------------------

＜例　示＞

  ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  高規格堤防及びその地盤において、パイピング破壊が生じない有効浸透路長の確保を検討する場合には、レーンの加重クリープ比で評価することができる。このとき、高規格堤防の地盤と地下構造物の水平方向の接触長さについては、高規格堤防特別区域に建ぺい率80%で建物の地下等が入った場合を想定してよい。
  ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1)  建設省河川局水政課長,建設省河川局河川計画課長,建設省河川局治水課長通達：河川管理施設等構造令及び同令施行規則の運用について，平成4年2月1日（最終改正平成11年10月15日），建設省河政発第32号
    > 建設省河計発第37号 建設省河治発第10号（建設省河政発第 74号
    > 河計発第83号 河治発39号）.

2)  （財）国土技術研究センター：河川堤防の構造検討の手引き（改訂版），第4章
    > 浸透に対する堤防の構造検討，平成24年2月．

3)  (独)土木研究所地質・地盤研究グループ土質・振動チーム：河川堤防の浸透に対する照査・設計のポイント，平成25年6月．

4)  （財）リバーフロント整備センター：高規格堤防整備事業の手引，平成10年2月.

> ３）浸透水の流出に伴う堤防侵食に対する安全性

＜考え方＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  高規格堤防の堤体から浸透水が流出することによる侵食破壊を防ぐため、堤体内浸潤面が川裏側の表面と交わらないよう設計することが求められる。堤体内浸潤面の算出は、河道内の水位と降雨を考慮した外力条件で非定常浸透流解析により行う必要がある。堤体内浸潤面が川裏側の表面と交わる場合には、ドレーン工等の対策工を実施する必要がある。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜必　須＞

  ----------------------------------------------------------------------------
  高規格堤防の堤体内浸潤面が川裏側の表面と交わらないよう設計するものとする。
  ----------------------------------------------------------------------------

＜例　示＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  この検討における川裏側の表面位置としては、のり尻部を除き実際の表面よりもl.5m低い位置とすることが考えられる。これは、高規格堤防特別区域においては、河川法第27条第2項に基づき、第1項の許可を受けることなく、表面から一定の深さまでの掘削・埋戻しが行われることを考慮した安全側の配慮である。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1)  建設省河川局水政課長,建設省河川局河川計画課長,建設省河川局治水課長通達：河川管理施設等構造令及び同令施行規則の運用について，平成4年2月1日（最終改正平成11年10月15日），建設省河政発第32号
    > 建設省河計発第37号 建設省河治発第10号（建設省河政発第 74号
    > 河計発第83号 河治発39号）.

2)  （財）リバーフロント整備センター：高規格堤防整備事業の手引，平成10年2月.

3)  （財）リバーフロント整備センター：高規格堤防盛土設計・施工マニュアル，平成12年3月.

（４）地震時の液状化破壊・すべり破壊に対する安全性

> １) 構造令施行規則に規定される設計震度に対する安全性

＜考え方＞

+----------------------------------------------------------------------+
| 高規格堤防及びその地盤の地震時の液状化破壊                           |
| 、すべり破壊に対する安全性については、次のとおり検討する必要がある。 |
|                                                                      |
| 液状化破壊                                                           |
| については、液状化の判定を行う土層に対して液状化に対する抵抗率F~L~を |
| 算出し、FL＜1.0の土層がある場合、液状化破壊に対する安全性の照査を行  |
| う必要がある。また、安全性の照査に用いる手法については、動的変形解析 |
| 、静的変形解析、地震時の過剰間隙水圧を考慮した円弧すべり法（ΔU法）か |
| ら適切な手法を選定する。液状化破壊に関する安定計算に用いる外力条件（ |
| 河道内の水位、設計震度）は表3-4に示すとおりであり、高規格堤防の表面  |
| における設計震度は、構造令施行規則第13条の3第2項に従い、同条第1項に  |
| 規定する値に1.25を乗じて得た値とする。安定計算の結果に基づき、液状化 |
| 破壊の危険性が高いとみなされる場合には、適切な対策を行う必要がある。 |
|                                                                      |
| また、地震時慣性力によるすべり破壊については、地                     |
| 震時慣性力を考慮した円弧すべり法（Kh法）により安定計算を行うことが基 |
| 本であり、この安定計算に用いる外力条件（河道内の水位、設計震度）は表 |
| 3-5に示すとおりである。設計震度は、構造令施行規則第13条の3第1項にお  |
| いて強震帯地域、中震帯地域、弱震帯地域の区分に応じて規定されているが |
| 、これは地盤条件がⅢ種地盤、かつ高規格堤防の幅・高さ比が20以上の場合  |
| を想定した値のため、高規格堤防設置区間における地震履歴、土質、地盤の |
| 特性、堤防規模等から表3-5の値よりも大きな設計震度を用いる必要がある  |
| と判断される場合には、適切な方法を用いて設計震度を定める必要がある。 |
|                                                                      |
| 地震時の安全性の検討については、一般的には高規格堤防盛               |
| 土設計・施工マニュアル、河川堤防の液状化対策の手引き等が参考となる。 |
|                                                                      |
| 表3                                                                  |
| -4　地震時の液状化破壊に関する安定計算に用いる河道内の水位と設計震度 |
|                                                                      |
| +--------+--------+--------+--------+--------+--------+--------+     |
| | **河道 | **計算 | **高   | **計   | **間   |        |        |     |
| | 内の水 | 対象** | 規格堤 | 算に用 | 隙圧** |        |        |     |
| | 位の** |        | 防表面 | いる河 |        |        |        |     |
| |        | のり   | におけ | 道内の |        |        |        |     |
| | **     | **面** | る設計 | 水位** |        |        |        |     |
| | 状況** |        | 震度** |        |        |        |        |     |
| +========+========+========+========+========+========+========+     |
| |        |        | **     | **     | **     |        |        |     |
| |        |        | 強震帯 | 中震帯 | 弱震帯 |        |        |     |
| |        |        | 地域** | 地域** | 地域** |        |        |     |
| +--------+--------+--------+--------+--------+--------+--------+     |
| | **計画 | **裏   | **     | **     | **     | **平   | **当   |     |
| | 高水位 | **のり | 0.18** | 0.15** | 0.13** | 水位** | 該水位 |     |
| | 以下** | **面** |        |        |        |        | 時の間 |     |
| |        |        |        |        |        |        | 隙圧** |     |
| |        | **表   |        |        |        |        |        |     |
| |        | **のり |        |        |        |        | **地震 |     |
| |        | **面** |        |        |        |        | によっ |     |
| |        |        |        |        |        |        | て発生 |     |
| |        |        |        |        |        |        | する過 |     |
| |        |        |        |        |        |        | 剰間隙 |     |
| |        |        |        |        |        |        | 水圧** |     |
| +--------+--------+--------+--------+--------+--------+--------+     |
|                                                                      |
| 表3-5　地震時の                                                      |
| 慣性力によるすべり破壊に関する安定計算に用いる河道内の水位と設計震度 |
|                                                                      |
| +--------+--------+--------+--------+--------+--------+--------+     |
| | **河道 | **計算 | **設計 | **計   | **間   |        |        |     |
| | 内の水 | 対象** | 震度** | 算に用 | 隙圧** |        |        |     |
| | 位の** |        |        | いる河 |        |        |        |     |
| |        | のり   |        | 道内の |        |        |        |     |
| | **     | **面** |        | 水位** |        |        |        |     |
| | 状況** |        |        |        |        |        |        |     |
| +========+========+========+========+========+========+========+     |
| |        |        | **     | **     | **     |        |        |     |
| |        |        | 強震帯 | 中震帯 | 弱震帯 |        |        |     |
| |        |        | 地域** | 地域** | 地域** |        |        |     |
| +--------+--------+--------+--------+--------+--------+--------+     |
| | **     | **裏   | **     | **     | **     | **平   | **当   |     |
| | 平水位 | **のり | 0.15** | 0.12** | 0.10** | 水位** | 該水位 |     |
| | 以下** | **面** |        |        |        |        | 時の間 |     |
| |        |        |        |        |        |        | 隙圧** |     |
| |        | **表   |        |        |        |        |        |     |
| |        | **のり |        |        |        |        |        |     |
| |        | **面** |        |        |        |        |        |     |
| +--------+--------+--------+--------+--------+--------+--------+     |
|                                                                      |
| 　                                                                   |
+----------------------------------------------------------------------+

＜必　須＞

+----------------------------------------------------------------------+
| 地震時の液状化破壊                                                   |
| に対する安全性は、地盤の液状化判定を行い、その結果により液状化破壊の |
| おそれのある地盤とない地盤に分類した上で、液状化破壊のおそれのある地 |
| 盤に対して所要の安全性を確保できる構造となるよう設計するものとする。 |
|                                                                      |
| また、地震時慣性力の作用を考慮した安全性の照                         |
| 査を行い、すべり破壊に対して安全な構造となるよう設計するものとする。 |
+----------------------------------------------------------------------+

＜標　準＞

  -----------------------------------------------------------------------------------------
  地震時慣性力の作用については、円弧すべり法による最小安全率を1.2とすることを基本とする。
  -----------------------------------------------------------------------------------------

＜推　奨＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  地震時の安全性の検討については、高規格堤防特別区域における土地利用に対して重大な支障が生じないよう、「3.6 土地利用の観点から要求される性能の照査等」と併せて実施することが望ましい。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜例　示＞

+----------------------------------------------------------------------+
| 地震時の安全性は、次のように検討することができる。                   |
|                                                                      |
| １） 液状化破壊に対する安全性の照査                                  |
|                                                                      |
| > 基礎地盤に液状化                                                   |
| の可能性がある土層（液状化に対する抵抗力F~L~が1.0未満の土層）が分布  |
| する場合、液状化破壊に対する安全性は次のように検討することができる。 |
|                                                                      |
| ① 動的変形解析または静的変形解析を用いた安全性の照査                 |
|                                                                      |
| > 動的変形解析または静的変形解析を用いて高規格堤防の天               |
| 端・表のり面、高規格堤防特別区域における変位を算出し、液状化破壊に対 |
| する対策の要否を判断してよい。動的変形解析または静的変形解析による変 |
| 位が所要の変位に収まらない場合は必要な対策を講じることが考えられる。 |
|                                                                      |
| ②                                                                    |
| 地                                                                   |
| 震時の過剰間隙水圧を考慮した円弧すべり法（ΔU法）を用いた安全性の照査 |
|                                                                      |
| > 地震時の過剰間隙水圧を考慮した円弧すべり法(ΔU                      |
| 法)による最小安全率Fs(ΔU)を算出し、1.2以上となる場合は、液状化破壊に |
| 対する対策は不要と判断できる。最小安全率Fs(ΔU)が1.2未満となる場合は  |
| 、1.2以上となるように必要な対策を講じることが考えられるが、動的変形  |
| 解析または静的変形解析により安全性の照査や対策の検討を行ってもよい。 |
|                                                                      |
| ２） 地震時慣性力に対する安全性の照査                                |
|                                                                      |
| > 基礎                                                               |
| 地盤に液状化の可能性がある土層（液状化に対する抵抗力FLが1.0未満の土  |
| 層）が分布するか否かによらず、地震時慣性力を考慮した円弧すべり法(Kh  |
| 法)による最小安全率Fs(Kh)を確認し、1.2以上となる場合は、地震時慣性力 |
| に対する対策は不要と判断できる。また、最小安全率Fs(Kh)の確認に加え、 |
| 動的変形解析に基づく高規格堤防の天端・表のり面、高規格堤防特別区域に |
| おける変位の算出結果等を基に、必要な対策を検討することが考えられる。 |
|                                                                      |
| なお、液状化破壊に対する安全性の照査を円弧すべり法（ΔU法             |
| ）または静的変形解析によって行い、対策を不要と判断した場合にあっても |
| 、地震時慣性力に対する照査を行う必要がある。また、対策工の設計を円弧 |
| すべり法（ΔU法）または静的変形解析によって行った場合にあっても、液状 |
| 化対策を講じた条件のもとで地震時慣性力に対する照査を行う必要がある。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1)  建設省河川局水政課長,建設省河川局河川計画課長,建設省河川局治水課長通達：河川管理施設等構造令及び同令施行規則の運用について，平成4年2月1日（最終改正平成11年10月15日），建設省河政発第32号
    > 建設省河計発第37号 建設省河治発第10号（建設省河政発第 74号
    > 河計発第83号 河治発39号）.

2)  河川局治水課課長補佐 事務連絡：＜参考＞
    > 高規格堤防に関する河川管理施設等構造令及び同令施行規則の運用について（補足説明），平成10年2月10日.

3)  建設省河川局治水課課長補佐
    > 事務連絡：高規格堤防における地震時の安定性解析手法及び対策工の設計手法に関する当面の取り扱いについて，平成12年3月10日.

4)  （財）リバーフロント整備センター：高規格堤防盛土設計・施工マニュアル，平成12年3月.

5)  （財）国土技術研究センター：河川堤防の構造検討の手引き（改訂版），第6章
    > 地震に対する堤防の構造検討，平成24年2月．

6)  建設省土木研究所：河川堤防の液状化対策工法設計施工マニュアル（案）平成9年10月.

7)  （独）土木研究所 地質・地盤研究グループ
    > 土質・振動チーム：河川堤防の液状化対策の手引き（改定版），令和 6
    > 年 5 月．

> ２) レベル2地震動に対する耐震性能の照査

＜考え方＞

+----------------------------------------------------------------------+
| レベル2地震動に対する耐震性能の照                                    |
| 査に当たっては、平常時の流水または計画津波等が越流しないために必要な |
| 天端高を設定し、レベル2地震動による変形後の天端高がこれを下回らない  |
| ことを照査する必要がある。照査において考慮する外水位は、本章「第2節  |
| 堤防、2.7.2                                                          |
| 土堤の安全                                                           |
| 性能の照査、(5)耐震性能の照査」と同様、原則として平常時の最高水位と  |
| するが、設計対象地域が河口部付近の場合は朔望平均満潮位及び波浪の影響 |
| を考慮し、津波の遡上が予想される場合は計画津波水位とする必要がある。 |
|                                                                      |
| 耐震性能の照査                                                       |
| のための解析手法としては、高規格堤防の従来設計においても必要に応じて |
| 用いられてきた動的変形解析や、レベル2地震動に対する堤防の耐震性能照  |
| 査でも用いられている静的変形解析を用いることが考えられる。各手法の特 |
| 性を踏まえて解析手法を適切に選択し、耐震性能の照査を行う必要がある。 |
|                                                                      |
| なお、「3.2                                                          |
| 機能」に示したとおり、高規格堤防                                     |
| に変形や沈下が生じた場合でも、高規格堤防設計水位以下の流水による作用 |
| に対して安全な機能の回復が速やかに行い得ることも求められる。ただし、 |
| 盛土構造物であり、計画高水位以下の流水の通常の作用に対する高規格堤防 |
| の機能の回復は比較的早期に行えると考えられることから、レベル2地震動  |
| の発生後の河道内の流水による侵食破壊、浸透破壊に対する照査は省略して |
| いる。また、高規格堤防設計水位の作用時の越流水による洗掘破壊に対する |
| 照査についても、越流水が集中して流下し、特に大きなせん断力が作用する |
| 道路部等の修復を早期に行うことを前提に省略している。道路部等の早期の |
| 修復を可能とするためには共同事業者等とも十分な調整を行う必要がある。 |
|                                                                      |
| 上記のほか、土地利用上の観点から要求される耐震性                     |
| 能についても、共同事業者等との協議により検討を行うことが求められる。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 高規格堤防の設計に際して、レベル2                                    |
| 地震動に対する耐震性能の照査を行う。耐震性能の照査は、平常時の流水又 |
| は計画津波等が越流しないために必要な天端高を設定し、レベル2地震動に  |
| よる変形後の天端高がこれを下回らないことを照査することを基本とする。 |
|                                                                      |
| 高規格堤防の耐震性能の照査に当たって                                 |
| は、各解析手法の特性を踏まえて、高規格堤防の設計断面形状や構造上の特 |
| 徴、地盤条件等を考慮した上で、適切な手法を選択することを基本とする。 |
+----------------------------------------------------------------------+

＜推　奨＞

  -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  高規格堤防特別区域は通常の土地利用に供されることから、レベル2地震動に対する耐震性能については「3.6 土地利用の観点から要求される性能の照査等」と併せて検討することが望ましい。
  -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1)  国土交通省水管理・国土保全局：河川構造物の耐震性能照査指針・解説―Ⅱ.
    > 堤防編―，平成28年3月．

2)  国土交通省水管理・国土保全局治水課：河川堤防の耐震点検マニュアル，平成28年3月．

3)  （財）国土技術研究センター：河川構造物の耐震性能照査において考慮する河川における平常時の最高水位の算定の手引き（案），2007．

（５）沈下に対する配慮

＜考え方＞

+----------------------------------------------------------------------+
| 高規格堤防の過度の不等沈下等は                                       |
| 、高規格堤防の表面に作用する越流水によるせん断力を局所的に増大させる |
| おそれがある。このため、工事完了後の沈下等を極力生じさせないよう設計 |
| 及び盛土の締固めや沈下計測等の施工管理を適切に行うことが必要となる。 |
|                                                                      |
| 特に、高規格堤防設置区間は軟弱地盤地帯                               |
| が分布していることも多く、高規格堤防盛土及び通常の土地利用を想定した |
| 上載荷重による沈下量を可能な限り抑えるための対応が重要である。高規格 |
| 堤防の整備により現堤防や周辺の地盤への影響等が懸念される場合には、別 |
| 途検討を行うとともに、必要に応じて適切な対策を行うことが求められる。 |
+----------------------------------------------------------------------+

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  高規格堤防は、計画高水位を超え、高規格堤防設計水位以下の洪水の作用に耐えうる構造とするため、完成後（段階的完成を含む）において極力沈下を生じないよう設計及び施工管理を行うことを基本とする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1)  （財）リバーフロント整備センター：高規格堤防盛土設計・施工マニュアル，平成12年3月.

2)  （財）国土技術研究センター：河川土工マニュアル，第3章 河川土工の設計
    第3.2節 軟弱地盤対策，平成21年4月.

    1.  []{#_Toc199347122
        .anchor}土地利用の観点から要求される性能の照査等

        1.  []{#_Toc199347123 .anchor}一般

＜考え方＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  高規格堤防特別区域は、住宅・ビル、工場、道路、公園、農地としての利用等、通常の土地利用に供されることから、土地利用者やその施設等の安全性（地震時を含む）を通常の市街地と同程度以上には確保する必要がある。このため、「3.5 安全性能の照査等」に規定する方法に従い設計した高規格堤防に対し、土地利用の観点から要求される性能の保持等の観点から照査を行い、その結果に応じて対策を検討することが必要となる。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  高規格堤防特別区域において想定される当面の土地利用状況に応じて、関連する技術基準や指針等を参考とし、共同事業者等とも協議・合意を図った上で、照査内容や照査基準値等を検討することを基本とする。また、照査基準値等を満足しない場合は、共同事業者等とも協議の上、必要に応じて対策を検討することを基本とする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜参考となる資料＞

1)  国土交通省
    > 都市局長,農林水産省農村振興局長,林野庁長官：宅地造成及び特定盛土等規制法の施行に当たっての留意事項について（技術的助言），令和5年5月26日（国官参宅第12号5農振第650号5林整治第244号）．

2)  盛土等防災研究会：盛土等防災マニュアルの解説，令和 5 年 11 月．

3)  （独）都市再生機構：宅地耐震設計マニュアル（案），平成 20 年 4 月．

4)  （一社）日本建築学会：建築基礎構造設計指針，令和 元 年 11 月．

5)  （一社）日本建築学会：小規模建築物基礎設計指針，平成 20 年 2 月．

6)  （一社）一般社団法人日本建築学会：建築基礎のための地盤改良設計指針案，平成
    > 18 年 11 月．

7)  平成24年度宅地の液状化対策の推進に関する研究会：宅地の液状化被害可能性判定に係る技術指針・同解説（案），平成
    > 25 年 2 月．

8)  国土交通省 都市局 都市安全課：市街地液状化対策推進ガイダンス，令和
    > 元年6 月．

    1.  []{#_Toc199347124 .anchor}沈下等に対する配慮

＜考え方＞

+----------------------------------------------------------------------+
| 高規格堤防上に                                                       |
| 構造物等が築造された後、高規格堤防及び築造された構造物の荷重によって |
| 土地利用に支障を及ぼすような新たな沈下が起こらないようにするため、設 |
| 計・施工段階から上載荷重を考慮しておく必要がある。なお、上載荷重とし |
| ては、土地利用形態や宅地に建築される建築物の規模等を勘案して適切な荷 |
| 重を設定する必要があるため、事前に共同事業者等と協議・合意を図ること |
| が重要である。この上載荷重を考慮して沈下計算を行い、残留沈下量の予測 |
| を行い、「高規格堤防盛土設計・施工マニュアル」等を参考に許容残留沈下 |
| 量を設定するほか、共同事業者等とも協議・合意を図ることが求められる。 |
|                                                                      |
| 盛土による沈下予測結果に                                             |
| よる残留沈下量が許容残留沈下量を超える場合、適切な対策が必要である。 |
|                                                                      |
| な                                                                   |
| お、沈下予測結果と実際の沈下挙動とが異なる可能性もあるため、原則とし |
| て動態観測を実施し、予測の修正や設計の見直しに反映させる必要がある。 |
|                                                                      |
| また、地盤強度についても共同事業者                                   |
| や土地所有者等との間で誤解や認識不足が生じないように、確保する地盤強 |
| 度の考え方について共同事業者等との協議・合意を図ることが重要である。 |
+----------------------------------------------------------------------+

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  高規格堤防特別区域が通常の土地利用に供されることから、土地利用に支障を及ぼさないよう極力沈下を生じず、かつ地盤強度が確保されるよう設計及び施工管理を行うことを基本とする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1)  （財）リバーフロント整備センター：高規格堤防盛土設計・施工マニュアル，平成12年3月.

2)  （財）国土技術研究センター：河川土工マニュアル，第3章 河川土工の設計
    > 第3.2節 軟弱地盤対策，平成21年4月.

    1.  []{#_Toc199347125 .anchor}隣接構造物への影響に対する配慮

＜考え方＞

+----------------------------------------------------------------------+
| 高規格堤防の隣接区域は、既に商工業地域や住宅地として土地利           |
| 用されている場合が多く、高規格堤防盛土の施工に伴い発生する側方変位や |
| 引き込み沈下によって、隣接構造物に機能障害が生じることが懸念される。 |
|                                                                      |
| このよ                                                               |
| うな盛土による影響が想定される場合には、常時の応力～変位解析や圧密沈 |
| 下解析を行い、変位量が許容値以下であるかどうかを確認する必要がある。 |
|                                                                      |
| 算定された変位量が許容値以                                           |
| 上であることが明らかな場合には、必要な対策を講じることが求められる。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 高規格堤防の予定地に隣接構造物                                       |
| がある場合には、側方変位や引き込み沈下の解析を行うことを標準とする。 |
|                                                                      |
| 解析の結果より、変                                                   |
| 位量が許容値以上である場合には、必要な対策を講じることを基本とする。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1)  （財）リバーフロント整備センター：高規格堤防盛土設計・施工マニュアル，平成12年3月.

    1.  []{#_Toc199347126 .anchor}高規格堤防構造に関するその他事項

        1.  []{#_Toc199347127 .anchor}分合流部の設計

＜考え方＞

+----------------------------------------------------------------------+
| 分合流部に設けられる高規格                                           |
| 堤防を設計する場合、分合流のタイプごとに十分な対策を行う必要がある。 |
|                                                                      |
| 支川                                                                 |
| に逆流防止水門がある場合や派川に分流堰がある場合等、洪水時に本川と支 |
| 派川との間に水位差がある（本川水位が高い）場合には、越流量の増大によ |
| る荷重増や水位差による浸透破壊を防止する対策等に配慮する必要がある。 |
|                                                                      |
| また、支川が自己流を持って合流する場合や支川堤防がバック             |
| 堤である場合、自然分流である場合等、洪水時に本川と支派川の水位が等し |
| い場合には、越流量の増大による荷重増に対する対策の検討が必要となる。 |
|                                                                      |
| ただし                                                               |
| 、バック堤の場合には、支川における侵食破壊の検討は不要と考えられる。 |
+----------------------------------------------------------------------+

＜必　須＞

  ------------------------------------------------------------------------------------------------
  分合流部の設計においては、分合流部固有の荷重作用特性及び堤防形状に十分留意しなければならない。
  ------------------------------------------------------------------------------------------------

＜例　示＞

+----------------------------------------------------------------------+
| 分合流部に設                                                         |
| けられる高規格堤防を設計する場合、対象分合流が次に示すタイプⅠとタイ  |
| プⅡのどちらに属するかによって、設計における留意事項が変わってくる。  |
|                                                                      |
| > タイプⅠ：支川に逆流防止水門がある場合や派川に分流堰がある          |
| 場合等、洪水時に本川と支派川との間に水位差がある（本川水位が高い）。 |
| >                                                                    |
| > タイプⅡ：支川が自己流を持って合流する場合や支川堤防がバック堤で    |
| ある場合、自然分流である場合等、洪水時に本川と支派川の水位が等しい。 |
|                                                                      |
| タイプⅠの場合、支派川に                                              |
| は高規格堤防が造られず、本川の高規格堤防を支派川が横切ることになる。 |
|                                                                      |
| タイプⅡの場合、支派川にも高規格堤防が造られる。                      |
|                                                                      |
| それぞれのタイプの設計において、以下の点に留意する。                 |
|                                                                      |
| ![](media/image5.emf){width="4.832677165354331in"                    |
| height="2.456299212598425in"}                                        |
|                                                                      |
| 図3-2 タイプⅠ　　　　　　　　　　　図3-3 タイプⅡ                     |
|                                                                      |
| > １）タイプⅠの場合                                                  |
| >                                                                    |
| > ①                                                                  |
| >                                                                    |
| 本川と支派川とがなす角が鋭角の側（図3-2の①の部分）においては、越流水 |
| の収束が川裏側堤防上で起こり、単位幅あたりの越流量が増大する。この荷 |
| 重の増大に対処するため堤防川裏側の勾配を緩くする必要があり、この部分 |
| の堤防幅を大きくし、適切な堤防川裏側形状をもたせることが考えられる。 |
| >                                                                    |
| > ②                                                                  |
| > 本川と支派川に囲まれたくさび状の高規格堤防部分（図3-               |
| 2の②の部分）の周囲では、平面距離の割に大きな水位差が生じる場合がある |
| ので、必要に応じて浸透破壊を防止する対策を検討することが考えられる。 |
| >                                                                    |
| > ③                                                                  |
| > 支派川が高規                                                       |
| 格堤防を横切る部分において（図3-2の③の部分）、越流水が支派川に落ち込 |
| むと支派川の堤防表のり面が破壊され、その破壊が高規格堤防に波及する危 |
| 険がある場合には、支派川の堤防表のり面が破壊されないような措置を講じ |
| るか、越流水の支派川への落込みをなくす措置を講じることが考えられる。 |
| >                                                                    |
| > ④                                                                  |
| > 本川に先立って支川で堤防越流                                       |
| が起こり、これにより支川堤防及び接続する高規格堤防下部（図3-2の④の部 |
| 分）が一部破壊され、破壊部分が本川高規格堤防上の越流水に対して弱点箇 |
| 所となることが予想される場合には必要な対策を講じることが考えられる。 |
| >                                                                    |
| > ２）タイプⅡの場合                                                  |
| >                                                                    |
| > ①                                                                  |
| > 本川と支派川とがなす隅角部（図3-3の①の部分）においては、越流水     |
| の収束が川裏側堤防上で起こり、単位幅あたりの越流量が増大する。この荷 |
| 重の増大に対処するため堤防川裏側の勾配を緩くする必要があり、この部分 |
| の堤防幅を大きくし、適切な堤防川裏側形状をもたせることが考えられる。 |
| >                                                                    |
| > ②                                                                  |
| > 支川                                                               |
| がバック堤の場合には、支川における侵食破壊の検討は不要と考えられる。 |
| >                                                                    |
| > ３）タイプⅠ、Ⅱ両方について                                         |
| >                                                                    |
| > 本                                                                 |
| 川と支派川に囲まれたくさび状の高規格堤防部分が諸荷重に対して弱点箇所 |
| とならないかどうか検討し、必要に応じて対策を講じることが考えられる。 |
+----------------------------------------------------------------------+

2.  []{#_Toc199347128 .anchor}高規格堤防上の細部構造の設計

＜考え方＞

+----------------------------------------------------------------------+
| 細部構造とは、高規格堤防                                             |
| 上の土地利用にとって直接必要になるもののうち公共性が高いものを対象と |
| し、道路、宅盤間あるいは宅盤・道路間の段差部の擁壁等がこれにあたる。 |
|                                                                      |
| 設計に際しては、当面の土地利                                         |
| 用状況から考えて適切な方法を用い適切な上載荷重を考慮する必要がある。 |
|                                                                      |
| これは、高規格堤防設計の当初にも細部構造を設計対象とする必要         |
| があるが、堤防完成以降の土地利用形態の変更に伴う細部構造の改変は原則 |
| として土地利用者（関係する国、地方自治体等を含む）が行うためである。 |
+----------------------------------------------------------------------+

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------
  高規格堤防上において宅盤等の段差部に設けられる擁壁等については、想定される当面の土地利用状況に応じて適切に設計することを標準とする。
  --------------------------------------------------------------------------------------------------------------------------------------

3.  []{#_Toc199347129 .anchor}段階的施工に関する留意点等

＜考え方＞

+----------------------------------------------------------------------+
| ここでいう段階的                                                     |
| 施工とは、開発計画、現状の土地利用との整合から、高規格堤防設置区間の |
| 一連の区間のうち一部が整備された場合や、将来的な高規格堤防の整備を見 |
| 据えて暫定断面として整備された場合の考え方について述べるものである。 |
|                                                                      |
| 高規格堤防は、段階的施工においても、その整備箇所は安全性が向上する。 |
|                                                                      |
| また、他の区間における堤防の決壊等により周辺地域が浸水する事         |
| 態が生じた場合には、周辺住民等の避難場所や、被災者の救助、緊急物資の |
| 輸送・供給等災害時の様々な活動の拠点となる重要な高台の役割を果たす。 |
|                                                                      |
| このため、段階的施工における設計に当た                               |
| っては、まちづくり関係者等と十分な調整を図りつつ、以下の検討を行う。 |
|                                                                      |
| > １）段階的施工における暫定断面                                     |
| >                                                                    |
| > 段階的施工における暫定断面は、                                     |
| 横断方向では一般に基本断面形状に対して堤防幅の狭いものが対象となる。 |
| >                                                                    |
| > この場合においても将来の完成時に手戻りとならないよう、裏のり部     |
| 分の高さについては将来形に沿った高さでの施工を行うことが求められる。 |
| >                                                                    |
| > ２）段階的施工における設計                                         |
| >                                                                    |
| > ①                                                                  |
| > 暫定断面を                                                         |
| 有する高規格堤防であっても、構造令施行規則第13条の5第2項、第3項（す  |
| べり）、第13条の5第5項（液状化）については、完成堤防と同等の安全性を |
| 有する必要がある。堤防幅と密接な関係にある構造令施行規則第13条の5第1 |
| 項（洗掘）及び第13条の5第4項（浸透）については、完成後において確保す |
| べき安全性に影響を与えない程度の安全性を有していることが求められる。 |
| >                                                                    |
| > なお、暫定断面ののり尻等において、部分的に基本断面形状ののり勾配   |
| を満たさない場合、越流水による洗掘破壊を極力生じにくくするよう、高規 |
| 格堤防特別区域外の道路面の舗装等を含め、必要な措置を行う場合がある。 |
| >                                                                    |
| > ②                                                                  |
| > 暫定断面を有する高規格堤防の設計において、特                       |
| に注意を要するのは同則第13条の5第2項、第3項、第5項の安全性であり、こ |
| れらについては、縦断方向及び横断方向について満足している必要がある。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 高規格堤防の整備は、開発計画                                         |
| 、現状の土地利用との整合から、一連区間のうち一部区間の整備や、全幅に |
| おいて完成断面にできなくても、遂次段階的に実施することを基本とする。 |
|                                                                      |
| その設計に当たっては、高規格堤防特別区域が通常の                     |
| 土地利用に供されることや、現状の堤防機能を損なわない構造とすること、 |
| 将来完成時に極力手戻りが少なくなること等に配慮することを標準とする。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1)  （財）リバーフロント整備センター：高規格堤防盛土設計・施工マニュアル，平成12年3月.

2)  （財）リバーフロント整備センター：高規格堤防整備事業の手引，平成10年2月．

3)  高規格堤防の効率的な整備の推進に向けて
    > 提言,平成29年12月,高規格堤防の効率的な整備に関する検討会．

4)  災害に強い首都「東京」の形成に向けた連絡会議：災害に強い首都「東京」形成ビジョン,令和2年12月.

    1.  []{#_Toc199347130 .anchor}ICT やBIM/CIM の活用

＜考え方＞

+----------------------------------------------------------------------+
| i-Construction 推進の一環として、ICT                                 |
| による建設生産プロセスのシームレス化が取り組まれている。             |
|                                                                      |
| UAV 写真測量やレーザースキャナー計測等で得られる3                    |
| 次元点群データを活用することで                                       |
| 、現況地形や既設物の構造を様々な角度・断面から把握することができる。 |
|                                                                      |
| 新設・改修する施設の 3                                               |
| 次元モデルを作成し                                                   |
| 活用することにより、構造に関して関係者の理解と合意形成が促進される。 |
|                                                                      |
| このため、計画段階等、事業の早期段                                   |
| 階をはじめ、施工段階、施工後の点検・補修・修繕の段階においてBIM/CIM  |
| を                                                                   |
| 積極的に活用し、高規格堤防を適切に維持管理していくことが求められる。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1)  国土交通省：BIM/CIM活用ガイドライン（案），令和4年3月.

**設計編**

**第１章　河川構造物の設計**

1.  **護岸・水制**

**目　次**

[第4節 護岸・水制 1](#_Toc130309110)

> [4．1 総説 1](#_Toc130309111)
>
> [4. 1. 1 適用範囲 1](#_Toc130309112)
>
> [4. 1. 2 用語の定義 1](#_Toc130309113)
>
> [4．2 機能 2](#_Toc130309114)
>
> [4．3 設計の基本 3](#_Toc130309115)
>
> [4．4 護岸の基本的な構造 9](#_Hlk130214599)
>
> [4. 4. 1 構造形式・工種の設定 10](#_Toc130309117)
>
> [4. 4. 2 材質と構造 11](#_Toc130309118)
>
> [（１）使用材料 11](#_Toc130309119)
>
> [（２）主な構造 12](#_Toc130309120)
>
> [4. 4. 3 安全性能の照査等 15](#_Hlk130220487)
>
> [（１）設計の対象とする状況と作用 15](#_Toc130309122)
>
> [（２）安全性能の照査 16](#_Toc130309123)
>
> [4. 4. 4 各部位の設計 18](#_Toc130309124)
>
> [（１）のり覆工 18](#_Toc130309125)
>
> [（２）基礎工 23](#_Toc130309126)
>
> [（３）根固工 26](#_Toc130309127)
>
> [（４）その他（天端工、天端保護工、すり付け工） 30](#_Toc130309128)
>
> [4．5 水制の基本的な構造 31](#_Toc130309129)
>
> [4. 5. 1 構造形式の設定 31](#_Toc130309130)
>
> [4. 5. 2 材質と工種 33](#_Toc130309131)
>
> [（１）使用材料 33](#_Toc130309132)
>
> [（２）主な工種 33](#_Toc130309133)
>
> [4. 5. 3 安全性能の照査等 35](#_Toc130309134)
>
> [4. 5. 4 各部位の設計 35](#_Toc130309135)
>
> [（１）水制 35](#_Toc130309136)
>
> [（２）方向 37](#_Toc130309137)
>
> [（３）長さ、高さ及び間隔等 37](#_Toc130309138)

令和５年１０月　版

適用上の位置付け

河川砂防技術基準設計編は、基準の適用上の位置付けを明確にするために、下表に示すように適用上の位置付けを分類している。

+--------+------------------+------------------+------------------+
| 分　類 | 適用上の位置付け | 末尾の字句例     |                  |
+--------+------------------+------------------+------------------+
| 考え方 | 技術資料         | ●目              | 「･･･ある。      |
|        |                  | 的や概念、考え方 | 」「･･･いる。」  |
|        |                  | を記述した事項。 |                  |
|        |                  |                  | 「･･･なる。      |
|        |                  |                  | 」「･･･れる。」  |
+--------+------------------+------------------+------------------+
| 必　須 | 技術基準         | ●法令による規定  | 「･･･なければ    |
|        |                  | や技術的観点から | ならない。」「･  |
|        |                  | 実施すべきである | ･･ものとする。」 |
|        |                  | ことが明確であり |                  |
|        |                  | 遵守すべき事項。 |                  |
+--------+------------------+------------------+------------------+
| 標　準 | 技術基準         | ●特              | 「･･･            |
|        |                  | 段の事情がない限 | を標準とする。」 |
|        |                  | り記述に従い実施 |                  |
|        |                  | すべきだが、状況 | 「･･･            |
|        |                  | や条件によって一 | を基本とする。」 |
|        |                  | 律に適用すること |                  |
|        |                  | はできない事項。 | 「･･･による。」  |
+--------+------------------+------------------+------------------+
| 推　奨 | 技術資料         | ●状況や条件      | 「               |
|        |                  | によって実施する | ･･･望ましい。」  |
|        |                  | ことが良い事項。 |                  |
|        |                  |                  | 「               |
|        |                  |                  | ･･･推奨する。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･務める。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･必要に応    |
|        |                  |                  | じて･･･する。」  |
+--------+------------------+------------------+------------------+
| 例　示 | 技術資料         | ●適用条件や実施  | 「               |
|        |                  | 効果について確定 | ･･･などの手法（  |
|        |                  | している段階では | 事例）がある。」 |
|        |                  | ないが、状況や条 |                  |
|        |                  | 件によっては導入 | 「･･･など        |
|        |                  | することが可能な | の場合がある。」 |
|        |                  | 新技術等の例示。 |                  |
|        |                  |                  | 「･･･など        |
|        |                  | ●状              | が考えられる。」 |
|        |                  | 況や条件によって |                  |
|        |                  | 限定的に実施でき | 「               |
|        |                  | る技術等の例示。 | ･･･の場合には･･･ |
|        |                  |                  | ことができる。」 |
|        |                  | ●具体的          |                  |
|        |                  | に例示することに | 「               |
|        |                  | より、技術的な理 | ･･･例示する。」  |
|        |                  | 解を助ける事項。 |                  |
|        |                  |                  | 「例えば･･･。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･事例もある  |
|        |                  |                  | 。･･･もよい。」  |
+--------+------------------+------------------+------------------+

  関連通知等       関連する通知やそれを理解する上で参考となる資料
  ---------------- ------------------------------------------------------
  参考となる資料   例示等に示した手法・内容を理解する上で参考となる資料

1.  []{#_Toc130309110 .anchor}護岸・水制

    1.  []{#_Toc130309111 .anchor}総説

```{=html}
<!-- -->
```
1.  []{#_Toc130309112 .anchor}適用範囲

＜考え方＞

本節は､護岸及び水制を単独あるいは組み合わせて、新設あるいは改築する場合の設計に適用する。ただし、既設の護岸及び水制の安全性能の照査にも構造形式や現地の状況等に応じ準用することができる。

護岸及び水制は、計画高水位（高潮区間にあっては計画高潮位）以下の水位の流水の通常の作用に対して堤防を保護する、あるいは掘込河道にあっては堤内地を安全に防護するために設けるもののほか、平均年最大流量等のある程度頻繁に発生するような洪水に対して低水路河岸の侵食や洗掘を抑制するために設けるものもある。さらに水制については良好な河川環境の保全・創出、良好な景観への改善・創出、航路維持（流路の安定）のために設けるものもある。

これらの求められる機能を満足するために、護岸や水制、さらには河床形状を制御することも機能に組み込んだ工法を組み合わせた設計を実施することも考えられ、本節はこのような構造の設計についても適用することができる。なお、越流堤覆工については本節の適用外とする。

＜標　準＞

  --------------------------------------------------------------------------------------------
  本節は、護岸及び水制を単独あるいは組み合わせて、新設あるいは改築する場合の設計に適用する。
  --------------------------------------------------------------------------------------------

＜関連通知等＞

1)  河川管理施設等構造令，昭和51年７ 月20 日, 政令199 号．

```{=html}
<!-- -->
```
2.  []{#_Toc130309113 .anchor}用語の定義

＜考え方＞

護岸には、高水護岸、低水護岸、及びそれらが一体となった堤防護岸があり、主にのり覆工、基礎工（のり留工含む。以下において同じ）、根固工等から構成される。

水制には、透過水制と不透過水制があり、主に杭、コンクリートブロック、玉石、割石等で構成される。

＜標　準＞

+----------------------------------------------------------------------+
| 次の各号に掲げる用語の定義は、それぞれ以下に示す。                   |
|                                                                      |
| 1.  高水護岸：複断面河道で高水敷幅が十分あるよう                     |
| な箇所の堤防を、流水その他から保護することを目的として設置される護岸 |
|                                                                      |
| 2.  低水護岸：堤防を保護するために低水路河岸の流水による侵食を防止す |
| ることや、低水路河岸の侵食や洗掘を抑制することを目的に設置される護岸 |
|                                                                      |
| 3.                                                                   |
|   堤防護岸：単断面河道である場合、あるいは複断面河道であるが高水敷幅 |
| が狭く、堤防と低水路河岸を一体として保護しなければならない場合の護岸 |
|                                                                      |
| 4.  透過水制：杭群等、流水が透過する構造のもので、水制が粗度要       |
| 素となって流速を減じて洗掘を防いだり土砂を堆積させる効果を持つ構造物 |
|                                                                      |
| 5.  不透過水制：石積みやコンクリートブロック積                       |
| みのように流水の透過度がほとんど無い水制で、水はね効果が大きい構造物 |
+----------------------------------------------------------------------+

＜関連通知等＞

1)  河川砂防技術基準　施設配置等計画編，令和6年6月,
    国土交通省水管理・国土保全局.

    （最新版）河川砂防技術基準施設配置等計画編,令和7年6月，国土交通省水管理・国土保全局.

＜参考となる資料＞

> 護岸・水制の設計については、下記の資料が参考となる。

1)  [改訂
    > 護岸の力学設計法](https://www.jice.or.jp/tech/material/detail/21),
    > 令和 5 年 10 月,（一財）国土技術研究センター.

```{=html}
<!-- -->
```
2)  護岸・水制の計画・設計, 平成15年6月,（株）山海堂

    1.  []{#_Toc130309114 .anchor}機能

＜考え方＞

河川においては、洪水時の流水の作用によって堤防や河岸が侵食されると、河川管理施設等構造令に基づき最低限確保すべき計画堤防断面形状を満足しない等、治水上危険な状態になる等の問題が生じる場合がある。

洪水時のこのような状態を回避するため、堤防の保護等を目的とする護岸及び水制には、計画高水位（高潮区間にあっては計画高潮位）以下の水位の流水の通常の作用に対して堤防を保護する、あるいは掘込河道にあっては堤内地を安全に防護する機能が求められる。

護岸及び水制が堤防の保護等の機能を発揮するに当たっては、護岸単独によるもののほか、護岸に作用する流体力を軽減する必要がある場合には水制との組合せ、湾曲部において外岸側の河床洗掘が課題となっている場合は護岸や水制、さらには河床形状を制御することも機能に組み込んだ工法との組合せを検討し、実施することが考えられる。

また、護岸及び水制には、平均年最大流量等のある程度頻繁に発生するような洪水に対して、低水路河岸の侵食や洗掘を抑制する機能が求められる場合もある。

護岸及び水制で、低水路河岸の侵食や洗掘を抑制する機能を発揮するに当たっては、堤防の保護等に必要な高水敷が十分にある場合は、低水護岸を設置して低水路河岸位置の変化を過度に抑制するのではなく、低水路河岸位置の変化をある程度許容する河道の管理を実施することが考えられる。

水制には、良好な河川環境の保全・創出、良好な景観への改善・創出、航路維持（流路の安定）の機能が求められるものもある。

良好な河川環境の保全・創出の面からの水制の機能としては、流速の速い所や遅い所を生じさせ水生生物に対して多様な環境場をつくること、水制頭部の洗掘や背後の土砂堆積により生物や植物への多様な環境場を提供すること、ワンドの形成により洪水時に魚類の避難空間を提供すること等が考えられる。

良好な景観への改善・創出の面からの水制の機能としては、土砂の堆積を誘導し水制から水際まで自然河岸化すること等が考えられる。

航路維持の面からの水制の機能としては、流水の流下幅を狭めるように水制を設置することで、航路部の河床を低下させ、通航可能水深と航路幅を確保、維持することが考えられる。

＜必　須＞

+----------------------------------------------------------------------+
| 堤防の保護等を目的とする護岸及び水                                   |
| 制は、計画高水位（高潮区間にあっては計画高潮位）以下の水位の流水の通 |
| 常の作用に対して、堤防の侵食や崩壊に対する安全性を向上させること、洗 |
| 掘の影響を回避・軽減させることにより堤防を保護する、あるいは掘込河道 |
| にあっては堤内地を安全に防護する機能を有するよう設計するものとする。 |
|                                                                      |
| 水制には、良好な河川環境を保全・創出する機能、良好な景観             |
| へ改善・創出する機能または船の航路を維持（流路の安定）する機能が求め |
| られるものもあり、このうち必要なものを有するよう設計するものとする。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1)  [[河川砂防技術基準施設配置等計画編]{.underline}](https://www.mlit.go.jp/river/shishin_guideline/gijutsu/gijutsukijunn/keikaku/pdf/2-1-1_g.pdf)，平成30年3月,国土交通省水管理国土保全局.

    （最新版）河川砂防技術基準　施設配置等計画編,令和7年6月，国土交通省水管理・国土保全局.

＜参考となる資料＞

> 護岸・水制の設計については、下記の資料が参考となる。

1)  [改訂
    護岸の力学設計法](https://www.jice.or.jp/tech/material/detail/21),
    令和 5 年 10 月,（一財）国土技術研究センター.

2)  護岸・水制の計画・設計, 平成15年6月,（株）山海堂.

    1.  []{#_Toc130309115 .anchor}設計の基本

＜考え方＞

我が国は沖積河川の氾濫原に人口・資産が集中しており、堤防により洪水及び高潮から人命と財産を防御している。護岸及び水制、さらには河床形状を制御することも機能に組み込んだ工法は、単独あるいは組み合わせて設置されることで堤防を保護する、掘込河道にあっては堤内地を安全に防護することを主たる目的として設置される重要な河川構造物である。

護岸及び水制は、対象とする河川区間の河道の平面形及び縦横断形、河道特性、平常時及び洪水時の流況等を踏まえて堤防防護ライン等を定め、その配置計画を検討するとともに、長期的な河道の安定や局所的な河川の変動特性を十分に考慮して設計する必要がある。

また、想定される外力に対して安全な構造とすることに加えて、動植物の生息・生育・繁殖環境と多様な河川景観の保全・創出に十分に留意して設計する必要がある。

護岸及び水制の設計に当たっては、これらを踏まえ、以下の事項について検討し、設計に反映することが求められる。

1.  基本方針

護岸及び水制の設計に当たっては、「4.2機能」に示す事項を満足するとともに、類似河川や近隣区間での実績、過去の経験等を参考にしながら、想定される外力に対して安全な構造となるよう設計する必要がある。

堤防の保護等を目的とする護岸及び水制の設計に当たっては、対象とする河川区間の河道の平面形及び縦横断形、河道特性、平常時及び洪水時の流況、地質、土砂流送特性、河川環境等を踏まえ、長期的、局所的または広範囲の河川の変動特性を十分に考慮するとともに、護岸及び水制の特性を十分に理解した上で、所要の機能を必要最小限の施設の新設や既設施設の改築で発揮させる方策を検討し、構造物の耐久性、維持管理の容易性、施工性、経済性及び公衆の利用等を総合的に考慮して、計画高水位以下の水位の流水の通常の作用に対して、単独あるいは組み合わせて設置されることで堤防を保護する、あるいは掘込河道にあっては堤内地を安全に防護するよう設計する。

護岸及び水制の配置の検討に当たっては、自然河岸の侵食耐力等について種々の調査結果等により適切に評価し、構造物の設置の必要性について十分検討する必要がある。河岸は粘性土や砂礫質土等の種々の土質材料とそこに生育する植生により構成され、河岸そのものもある程度の耐侵食性を有し、外力の条件によっては自然河岸のままで、あるいは多少の補強により洪水時の安全を確保できる場合もある。特に、植生は地上部の葉や茎による流体力の低減、河岸表面の被覆による河岸の流水作用からの保護、根による河岸表面の直接保護（強化）等により、相当程度の河岸防護効果が期待される。また、河岸近傍の樹木についても流速の低減等により河岸防護機能が期待できる場合がある。

護岸及び水制等の工法の選定に当たっては、目的とする機能の発揮に必要な工法の最適な組合せを総合的に検討する必要がある。例えば、堤防や低水路河岸表面の侵食耐力を洪水流の作用が上回る場合には護岸を設置するが、その際、現況の高水敷幅が一洪水で侵食される恐れのある高水敷幅よりも広い等、十分な高水敷幅がある場合は高水護岸を設置する。また、高水敷幅が十分にない場合は低水護岸や高水護岸を必要に応じて設置し、単断面河道あるいは複断面河道であるが高水敷幅が狭く堤防と低水路河岸を一体として保護しなければならない場合は堤防護岸を設置する。さらに、河床の洗掘により基礎工の根入れ長が極端に大きくなると考えられる場合等は、根固工を組み合わせることにより経済的な設計とすることが重要である。

維持管理の容易性、経済性の観点等からは、護岸と水制を組み合わせることによって、護岸に作用する流体力の軽減や護岸前面の河床洗掘を抑制することで、護岸の重量等を軽減して経済的な設計とすることが考えられる。また、主として湾曲部において外岸側の河床洗掘の程度が大きく、更なる対策が必要な場合等は護岸や水制、さらには河床形状を制御することも機能に組み込んだ工法を組み合わせることにより、河床洗掘を抑制する設計としている事例がある。

これらによっても、当該河川構造物のみの設計では、洪水時の堤防の安全性の確保や良好な河川環境の保全、総合的な土砂管理等の観点から、十分に期待する効果が得られないことが想定される場合等には、河道計画や施設等の配置計画に立ち戻って、床止めの設置による河道の安定化の検討や、河道の平面形及び縦横断形等の再設定により、再検討することが望ましい。

堤防の保護等を目的とする護岸及び水制の設計に当たり工法選定を検討する際の基本的な考え方の流れを以下に示す。

なお、この基本的な考え方の適用が困難な場合は必ずしもこの考え方に基づく必要はないが、現地条件や河道特性等も踏まえて検討することが望ましい。

![](media/image6.emf){width="6.298611111111111in"
height="5.535143263342082in"}

また、平均年最大流量等のある程度頻繁に発生するような洪水に対して、低水路河岸の侵食や洗掘を抑制することが考えられる。

例えば、一洪水で侵食される恐れのある高水敷幅に対して現況の高水敷が十分な幅を有する場合には、コンクリートブロックによる低水護岸を設置して低水路河岸の変化を過度に制限するのではなく、高水敷利用の状況も考慮しつつ捨石護岸等を施工することで、平均年最大流量等のある程度頻繁に発生する洪水に対して低水路河岸を保護しつつ、計画規模相当の流量等の大きな洪水に対しては低水路河岸の位置の変化をある程度許容する河道の管理も考えられる。

水際部は生物の多様な生息環境であることから、動植物の生息・生育・繁殖環境と多様な河川景観の保全・創出のためには護岸は極力設置しない方がよいと考えられるが、護岸の設置が必要となった場合は、必要最小限となるよう設置箇所、法線、延長を検討するとともに、環境への影響を検討し必要に応じ影響緩和策（護岸構造の変更や、淵、河畔樹木の保全等）を検討する必要がある。一方、水制はその周辺に多様な水環境を形成し、良好な河川環境の保全・創出、良好な景観への改善・創出に効果を有するので、この効果を十分活かすよう構造や配置、材質を検討する必要がある。

護岸設計の際には、自然環境への配慮として、流下能力や発生流速、潮の干満等の河道条件に応じて護岸前面への盛土や捨石、控え護岸等を検討すること、侵食や堆積で水際が変化する自然な河岸・水際部の形成等を図ること、覆土や土砂の堆積を促す護岸構造等により場の湿潤状態を維持すること、乱積みの根固工や捨石の設置等により水際部の多孔質な空間の確保や流れの多様性を形成すること等の工夫が考えられる。なお、施工時においても、注目すべき生物の生息・生育地を避けて仮設構造物を設置したり、水中施工では水生生物に対する影響について十分注意する等、環境に配慮することが望ましい。

また、景観への配慮として、覆土や前面への盛土等により護岸を極力露出させないこと、露出する場合には護岸天端等の境界を不明瞭にすること、分節して面積を小分けにすること、明度を下げること、周辺の景観と調和した適度なテクスチャーを持った素材を用いる等が考えられる。　

![ダイアグラム, 設計図
自動的に生成された説明](media/image7.png){width="5.278449256342957in"
height="2.8375in"}

水制設計の際には、自然環境への配慮として、河床地形や流れの多様性を創出するために、土砂の堆積により河岸が自然の土砂と植物で覆われるよう設計すること、ワンド空間を意識的に形成する場合は、水制間に土砂が堆積して陸化しないように水制高、間隔を設定すること等が考えられる。また、景観への配慮として、水制の長さ、高さ、材料の大きさ、色彩等は周辺の景観と調和的であるようにすること、単体の工法や形状、素材にのみ、その価値を見いだすのではなく、群体としての存在、流況による水制群回りの堆積や洗掘、流れの変化を概括的に捉えて設計すること、流速の変化、渦、波紋、反射等の変化をもたらすようにすること、河川景観になじんだ貴重な風景資源として既存の水制を生かす工夫を行うこと等が考えられる。

航路維持のための水制は、中砂以下の河床材料をもつ河川を対象に設置する。砂利河川が対象にならないのは、長大水制で川幅を制御しようとすると建設費が巨大となり、また、勾配が急であるので、確保水深を砂河川並みに維持することが困難であることから吃水深の浅い船しか通行できないからである。砂利河川の場合、河床は洪水時しか大きく変化しないので、プレジャーボート等のためには掘削を行うほうが一般に得策である。

6.  中小河川の場合の留意点

中小河川は大河川と比較して川幅が狭く単断面形状であることが多い。加えて、周辺の土地利用の制約を受けることが多いため、堤内地を安全に防護するために、護岸や水制が設置されることが多い。また、このように川幅に制約がある場合等においても、川が有する自然の復元力を活用するため、河岸ののり勾配を五分程度に立てて河床幅を十分に確保することが一般的である。

このため、水際部が河川環境や景観に与える影響が相対的に大きいので、良好な川づくりを達成する上では、その設計がとりわけ重要となる。

また、河道の長期的な安定性を確保する前提で、できる限り縦断的、横断的に自然な変化をもつ河岸・水際部になるよう、護岸及び水制等の配置を単独あるいは組み合わせて検討する必要がある。

護岸の設計の際に環境上配慮すべき事項についての考え方は、「4.3設計の基本1)基本方針」で示したもののほか、のり肩・水際部に植生を持つことを基本とし、直接人の目に触れる部分を極力小さくすること、周囲の景観と調和させること、水際及び背後地を重要な生息空間とする生物が分布している場合は生息・生育空間・移動経路として生物が利用できるよう配慮することが望ましい。具体的には、河岸樹木等の保全、護岸の前面への寄せ土、寄せ石、盛土等により自然な河岸・水際部の形成を検討するとともに、淵や河畔林が存在する場合には、根固工の設置高さの工夫、護岸構造等の工夫等により保全を図ること等がある。

また、護岸が露出する場合には、周囲と調和するように護岸のり肩、護岸の水際線等の境界の処理を行うこと、生物の生息・生育場所や植生基盤となりうる空隙や透水性・保水性を持つこと等があげられる。なお、現況で人の利用がある場合には、階段護岸の設置や緩傾斜の河岸構造とすることにより人の水辺へのアプローチを確保すること等があげられる。

＜必　須＞

+----------------------------------------------------------------------+
| 堤防の保護等を目                                                     |
| 的とする護岸及び水制は、計画高水位（高潮区間にあっては計画高潮位）以 |
| 下の水位の流水の通常の作用に対して、堤防を保護する、あるいは掘込河道 |
| にあっては堤内地を安全に防護できる構造となるよう設計するものとする。 |
|                                                                      |
| また、水際部に設置する護岸及び水制は、水際部                         |
| が生物の多様な生息環境であることから，十分に自然環境を考慮した構造と |
| することを基本として、施工性や経済性等を考慮して設計するものとする。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 護                                                                   |
| 岸及び水制の設計に当たっては、以下の事項を反映することを基本とする。 |
|                                                                      |
| 1.  対象とする河川区間の河                                           |
| 道の平面形及び縦横断形、河道特性、洪水流の流況、地質、河川環境等を踏 |
| まえ、長期的または局所的な河川の変動特性を十分に考慮するとともに、護 |
| 岸及び水制等の特性を十分に理解した上で、設置目的に応じた機能を有する |
| ように、類似河川や近隣区間での実績、過去の経験等を参考にしながら設計 |
| し、対象とする状況と作用に応じた安全性能照査を行うことを標準とする。 |
|                                                                      |
| 2.  構造物の耐久性、維持管理                                         |
| の容易性、施工性、経済性及び公衆の利用等を総合的に考慮して設計すると |
| ともに、堤防の保護等に当たって有効と考えられる護岸及び水制等の施設を |
| 単独あるいは組み合わせ、また構造物を設置することによる周辺の河道への |
| 影響に十分配慮して、設置場の条件に合わせて設計することを標準とする。 |
|                                                                      |
| 3.                                                                   |
| 堤防の保護等を目的とする護岸や水制においても、河川環境や景観へ配慮し |
| て設計する。特に水制は、その周辺に多様な水環境を形成し、良好な河川環 |
| 境の保全・創出、良好な景観への改善・創出に効果を有するので、この効果 |
| を十分活かすよう構造や配置、材質を検討して設計することを標準とする。 |
+----------------------------------------------------------------------+

＜推　奨＞

「図1-4-1堤防の保護等を目的とする護岸及び水制の設計に当たり工法選定を検討する際の基本的な考え方の流れ」に示すとおり、護岸及び水制、さらには河床形状を制御することも機能に組み込んだ工法のみの設計では洪水時の堤防の安全性の確保や良好な河川環境の保全、総合的な土砂管理等の観点から十分に期待する効果が得られないことが想定される場合等においては、河道の平面形及び縦横断形の設定や高水敷幅、護岸、水制、床止め等の関連する河道の制御施設の組合せ等の河道計画や配置計画について、再検討することが望ましい。

＜関連通知等＞

1)  [[美しい山河を守る災害復旧基本方針]{.underline}](https://www.mlit.go.jp/river/shishin_guideline/bousai/saigai/measures-saigai/pdf/10.pdf)(平成30年6月),2018,国土交通省水管理・国土保全局防災課.

```{=html}
<!-- -->
```
3)  [[河川景観ガイドライン「河川景観の形成と保全の考え方」]{.underline}](https://www.mlit.go.jp/river/shishin_guideline/kankyo/riverscape/index.html)(平成18年10月),
    > 国土交通省河川局 河川環境課,治水課,防災課.

4)  [[「多自然川づくり」の推進について]{.underline}](https://www.mlit.go.jp/notice/noticedata/pdf/200704/00004847.pdf)，平成
    > 18 年 10 月 13 日，国河環第 38 号，国河治第 86 号，国河防第 370
    > 号，国土交通省河川局長通達.

    （最新版）多自然川づくり基本方針，令和6年6月，国土交通省水管理・国土保全局.

5)  [[国土政策技術総合研究所資料，景観デザイン規範事例集（河川・海岸・港湾編）]{.underline}](http://www.nilim.go.jp/lab/ddg/seika/ks/ks0434.pdf)，平成
    > 20 年 3 月．

6)  [[中小河川に関する河道計画の技術基準について]{.underline}](https://www.mlit.go.jp/river/kankyo/main/kankyou/tashizen/pdf/gijyutsukijyun.pdf)
    > ，平成 22 年 8 月 9 日，国河環第 30 号，国河域第 7 号，国河防第
    > 174 号，国土交通省河川局河川環境課長，治水課長，防災課長通達.

7)  大河川における多自然川づくり～Q&A 形式で理解を深める～，平成 31 年 3
    月,国土交通省水管理・国土保全局河川環境課

    （最新版）大河川における多自然川づくり
    －Ｑ＆Ａ形式で理解を深める－，令和6年7月一部改訂，国土交通省水管理・国土保全局河川環境課.

＜例　示＞

「図1-4-1堤防の保護等を目的とする護岸及び水制の設計に当たり工法選定を検討する際の基本的な考え方の流れ」に示すとおり、河道湾曲部の外岸側等において、護岸及び水制のみでは河床洗掘等の課題が解消されない場合には、河床形状を制御することも機能に組み込んだ工法（ベーン工や置換工等）と組み合わせて対策を実施している事例がある。

・ベーン工は、翼板状の構造物を湾曲河道外岸の河床に設置し、流れと流砂を同時に制御し、湾曲部外岸の河床洗掘の抑制等を図る工法である。

・置換工は、河床材料を洪水時にも動きにくい材料で置換することにより水衝部深掘れの軽減等を図る工法である。

＜参考となる資料＞

> 護岸及び水制の設計に当たっては、下記資料が参考となる。

1)  [改訂
    > 護岸の力学設計法](https://www.jice.or.jp/tech/material/detail/21),
    > 令和 5 年 10 月,（一財）国土技術研究センター.

2)  護岸・水制の計画・設計,平成15年6月, （株）山海堂.

    環境や景観に配慮した設計については、下記資料が参考となる。

3)  多自然川づくりポイントブックⅢ，（財）リバーフロント整備センター，2011,多自然川づくり研究会.

    ベーン工の設計に当たっては、下記資料が参考となる。

4)  土木学会：水理公式集 2018 年版 平成 31 年 3 月.

    緩流河川の湾曲部にある水衝部の河岸侵食防止対策工として、ベーン工を配置し検証を実施した例としては、下記資料が参考となる。

5)  石田和典・東川敏・服部敦・福岡捷二：[[阿賀野川灰塚地区におけるベーン工による水衝部対策の効果]{.underline}](http://library.jsce.or.jp/jsce/open/00906/2010/16-0407.pdf)，河川技術論文集，第16巻，2010.

    脆弱な地層が分布する区間において、河床低下抑制を目的とした現地発生の玉石・砂礫による対策工を検討した例としては、下記資料が参考となる。

6)  松田龍朋・倉光宏一・木原恒二・柳田公司・服部敦・筌瀬明日香・倉吉一盛・伊藤寛之・岩谷栄林・長谷川清史：[[脆弱な地層が分布する法線是正区間における河床低下抑制のための現地発生材使用による対策工法の提案]{.underline}](https://www.jstage.jst.go.jp/article/river/22/0/22_211/_pdf)，河川技術論文集，第22巻，2016.

    河道湾曲部において、上流内岸側に水制工、下流外岸側に帯工を組み合わせた河床変動対策を行い、河道法線形の修正と同等の、平面流況の制御の効果発現について検証を実施した例としては、下記資料が参考となる。

7)  福岡捷二・安部友則・西村達也：[[信濃川小千谷・越路地区の河床変動対策－現地観測,模型実験,数値解析結果の比較－]{.underline}](http://library.jsce.or.jp/jsce/open/00028/2000/44-0347.pdf)，水工学論文集，第44巻，2000.

    堤防と一体となった高水敷（寄り州）の侵食に対する耐力を補強し、できるだけ現況のままの河岸を維持することを目的として、環境に配慮しつつ河岸線の変動を許容した簡易的な河岸侵食対策工を検討した例としては、下記資料が参考となる。

8)  山本晃一･高橋晃･林正男:黒部川の河道特性と河道計画,土木研究所資料,第3139号,1993．

連続する護岸施工の途上で、護岸施工により洗掘が激しくなり、かえって河岸防御が困難になる区間において、巨石付き盛土砂州によりみお筋を滑らかに河道中央に寄せ、砂州の形状を整正することで河岸を防護した事例については、下記の資料が参考となる。

9)  長田健吾、福岡捷二、氏家清彦：急流河川における砂州を活かした治水と環境の調和した河道計画，河川技術論文集，
    > Vol.18，pp.227-232，2012．

```{=html}
<!-- -->
```
1)  北陸地方整備局河川部北陸急流河川研究会：治水と環境の調和した新たな河岸防護技術の手引き～巨石付き盛土砂州を用いた河岸防護工～，平成25年3月．

[]{#_Hlk130214599 .anchor}

1.  護岸の基本的な構造

＜考え方＞

護岸及び水制は、「4.3設計の基本」までに示したとおり、堤防の保護等、低水路河岸の侵食や洗掘の抑制、河川環境や景観の保全・創出、航路維持等、求める機能を有するように設計するとともに、対象河川の河道特性等を踏まえ、構造物の耐久性、維持管理の容易性、施工性、経済性及び公衆の利用の容易性等を総合的に考慮し、施設を単独あるいは組み合わせて、周辺の河道への影響に十分配慮して設計することが重要である。

「4.4護岸の基本的な構造」では、このうち護岸の設計及び照査の基本的な考え方を示す。

1.  []{#_Toc130309117 .anchor}構造形式・工種の設定

＜考え方＞

護岸の構造形式としては、「張り護岸」や「積み護岸」、「矢板護岸」等の構造がある。

また、護岸には、多くの工種があり、使用される素材、構造の外観等はさまざまである。一般には、同じ構造的な特徴を持つ形式ごとに、「練張り護岸」「空張り護岸」「練積み護岸」「空積み護岸」等に分類されており、設置後の変状や被災事例などによって、各工種の安定性上の特性が経験的に把握されている。複雑な外力条件にさらされる護岸の設計については、それらの経験の積み重ねが特に重要であり、過去あるいは類似河川での経験を十分に踏まえるとともに、構造物の耐久性、維持管理の容易性、施工性、経済性、及び環境・景観との調和等を考慮して設計に当たる必要がある。

工種が異なると、設計時に考慮すべき外力や、設計すべき項目も異なるものとなる。設計に際しては、各工種の構造的な特徴を理解したうえで、設置箇所の河道特性に応じた工種を選択する必要がある。

![](media/image8.emf){width="6.231944444444444in" height="3.975in"}

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  護岸の工種は、「練張り護岸」、「空張り護岸」、「練積み護岸」、「空積み護岸」、「擁壁護岸」、「矢板護岸」等がある。工種の選定に当たっては、過去あるいは類似河川での経験及び設置箇所の河道特性を十分に踏まえるとともに、構造物の耐久性、維持管理の容易性、施工性、経済性、及び環境・景観との調和等に考慮して設定することを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1)  河川管理施設等構造令，昭和51年7 月20 日, 政令第199 号．

```{=html}
<!-- -->
```
8)  河川砂防技術基準　施設配置等計画編，令和6年6月,
    > 国土交通省水管理・国土保全局.

    （最新版）河川砂防技術基準施設配置等計画編,令和7年6月，国土交通省水管理・国土保全局.

9)  [[美しい山河を守る災害復旧基本方針]{.underline}](https://www.mlit.go.jp/river/shishin_guideline/bousai/saigai/measures-saigai/pdf/10.pdf)(平成30年6月),2018,国土交通省水管理・国土保全局防災課.

10) [[河川景観ガイドライン「河川景観の形成と保全の考え方」]{.underline}](https://www.mlit.go.jp/river/shishin_guideline/kankyo/riverscape/index.html)(平成18年10月),
    > 国土交通省河川局 河川環境課,治水課,防災課.

11) [[「多自然川づくり」の推進について]{.underline}](https://www.mlit.go.jp/notice/noticedata/pdf/200704/00004847.pdf)，平成
    > 18 年 10 月 13 日，国河環第 38 号，国河治第 86 号，国河防第 370
    > 号，国土交通省河川局長通達

    （最新版）多自然川づくり基本方針，令和6年6月，国土交通省水管理・国土保全局.

12) [[国土政策技術総合研究所資料，景観デザイン規範事例集（河川・海岸・港湾編）]{.underline}](http://www.nilim.go.jp/lab/ddg/seika/ks/ks0434.pdf)，平成
    > 20 年 3 月．

13) [[中小河川に関する河道計画の技術基準について]{.underline}](https://www.mlit.go.jp/river/kankyo/main/kankyou/tashizen/pdf/gijyutsukijyun.pdf)
    > ，平成 22 年 8 月 9 日，国河環第 30 号，国河域第 7 号，国河防第
    > 174 号，国土交通省河川局河川環境課長，治水課長，防災課長通達.

＜参考となる資料＞

> 護岸の構造形式の設定については、下記の資料が参考となる。

1)  [改訂
    > 護岸の力学設計法](https://www.jice.or.jp/tech/material/detail/21),
    > 令和 5 年 10 月,（一財）国土技術研究センター.

```{=html}
<!-- -->
```
14) 護岸・水制の計画・設計,平成15年6月, （株）山海堂.

> 環境や景観に配慮した設計については、下記の資料が参考となる。

15) 多自然川づくりポイントブックⅢ，平成23年10月,（財）リバーフロント整備センター.

    1.  []{#_Toc130309118 .anchor}材質と構造

        1.  []{#_Toc130309119 .anchor}使用材料

＜考え方＞

護岸で使用される素材はコンクリートブロック、石、木材、植生等さまざまである。護岸を設計する場合には、その耐久性について十分吟味し、堤防の保護等の機能を有する安全な構造となるよう十分な検討が必要である。

護岸の表面形状が滑らかになると、護岸周辺の流速が大きくなり、護岸前面や周辺の侵食・洗掘力が増す等により、設計対象護岸自身や周辺の河川管理施設の構造に支障を及ぼす可能性があるので、護岸は適切な表面粗度とする必要がある。

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------
  護岸の使用材料は、設置目的に応じて要求される強度や耐久性を満足するための品質を有し、その性状が明らかにされているものを使用することを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------

＜例　示＞

1.  護岸の表面形状については粗面仕上げとする等、表面粗度に配慮する必要があり、護岸の適切な表面粗度の目安としては、例えば低水護岸や堤防護岸の護岸設置区間の河床が有する代表的な粗度と同程度にするという考え方がある。ただし、河床の状況によって護岸構造が現実的なものとはならない場合がある。したがって周辺も含めた河川管理施設等に与える影響や流下能力の確保、河川環境等の観点から総合的に判断する必要がある。護岸表面の粗度評価方法の一例として、コンクリートブロックの突起形状、配置形状に着目した研究成果がある。

2.  **急流河川において、現地発生の玉石を用いた練張り護岸で、流砂や礫の衝突による磨耗・破損に対する対策を実施している事例がある。**

＜参考となる資料＞

> 護岸の材質と構造については、下記の資料が参考となる。

1)  [改訂
    > 護岸の力学設計法](https://www.jice.or.jp/tech/material/detail/21),
    > 令和 5 年 10 月,（一財）国土技術研究センター.

```{=html}
<!-- -->
```
16) 護岸・水制の計画・設計,平成15年6月, （株）山海堂.

    1.  []{#_Toc130309120 .anchor}主な構造

＜考え方＞

護岸は、主にのり覆工、基礎工、根固工等から構成される。

1.  **のり覆工は堤防等を保護する構造物で、護岸の構造の主たる部分を占めるものであり、流水・流木の作用、土圧等に対して安全な構造となるように設計するとともに、その形状・構造は多くの場合に良好な河川環境の保全・創出と密接に関連することから、設計に際しては生態系や景観について十分に考慮する必要がある。**

2.  基礎工はのり覆工を支持する構造物であり、その天端高は、洪水時に洗掘が生じても護岸基礎の浮き上がりが生じないよう、過去の実績や調査研究成果等を利用して最深河床高を評価することにより設定する必要がある。

3.  **根固工は基礎工が安全となるよう設置する構造物であり、大きな流速の作用する場所に設置されるため、流体力に耐える重量であること、護岸基礎前面に洗掘を生じさせない敷設量であること、耐久性が大きいこと、河床変化に追随できる屈とう性構造であることが必要となる**

![](media/image9.png)

![](media/image10.png){width="5.169886264216973in"
height="3.489922353455818in"}

![](media/image11.png)

**護岸の設計条件として、流体力、土圧等の外力、洪水時の河床変動による周辺地形変化、流砂や礫の衝突による磨耗・破損、流水や降雨の浸透による吸出し、侵食防止や軽減、河川環境、景観、河川利用、施工性、経済性等を考慮する必要がある。**

**これらすべての要因について理論上の解釈を与えて設計することは現状では難しく、伝統工法等に関しての過去の経験、過去の被災形態や類似河川の実績、あるいは新しい工種に関しての試験施工・模型実験、調査研究の成果等を利用して設計するものとする。特に、良好な河川環境の保全やコスト縮減等の観点から、より合理的な護岸の構造とすることが望まれる場合があるので、試験施工・模型実験、調査研究の成果等を積極的に活用して設計検討を実施する必要がある。**

**護岸は河川環境にとって特に重要である水際部に設置されることが多く、設置箇所の生態系や良好な景観を保全するような構造の工夫が求められる。したがって、各河川における多自然川づくりの目標が十分に達せられるよう、護岸の構造は良好な河川環境や景観に適したものとする必要がある。護岸が露出する場合については、護岸を大きく見せないように工夫するとともに、明度を抑え適度なテクスチャーを持った素材を用いる等、景観面・自然環境面に配慮することが重要である。**

**その際、むやみに耐久性や安全性に過大な余裕をもたせるのではなく、河道の長期的な変化になじんだ構造であること、高水敷や水制等と一体として堤防を保護することが護岸の目的であることを勘案して設計する。**

**護岸の設計に当たっては、被災形態の把握が重要であるため、既往の被災事例を調査し、被災部位別のおもな被災原因や護岸構造ごとの被災形態の特徴について十分に把握する必要がある。被災形態の把握に当たっては、適切かつ具体的な目的設定に基づく災害調査等から得られた知見を蓄積し、河川等の計画、設計及び維持管理等のための技術情報として共有化できるようにすることが重要である（調査編10章災害調査参照）。以下に、主な護岸の被災形態を示す。**

1.  河床洗掘による被災

> 護岸の被災事例で最も顕著なものは、基礎工前面の河床洗掘を契機として、基礎工及びのり覆工が被災を受ける事例である。護岸基礎工前面の河床洗掘が基礎工天端高以下の深さまで達すると、基礎工が河床より浮き上がり、その結果、支えを失ったのり覆工は破壊してしまう
> 。このとき、流水によって裏込材が吸い出されると、のり覆工は著しく破壊され、さらに上下流側にも破壊現象が伝播して広範囲にわたる被災となる。基礎工前面に根固工が設置されている場合でも根固工の重量や敷設幅が不足している場合は、根固工の流失を契機として基礎工の流失が発生し、洗掘による被災が発生することがある。

2.  すり付け部からの被災

> 護岸と、その上下流の護岸未施工区間とのすり付け部に設置されるすり付け護岸の被災事例も多い。すり付け護岸は、本護岸の小口部を保護するために設置される。すり付け護岸は、一般に、未施工区間との法線形や粗度のなじみを良くするため、屈とう性があり、かつ表面形状に凹凸のある、連節ブロックや篭工が用いられることが多い。それらのすり付け護岸は安定性上の十分な重量を有していないことや、上流端の小口が保護されないことが多いことから、上流端からめくれてしまうことがある。また、連節ブロックは、鉄線等で連結されているため、めくれは下流側にも伝播することになる。篭工の場合は、篭の強度が不十分であったり、中詰め石の径が小さかったりすると、篭が変形したり、あるいは篭全体が流失してしまうことがある。

3.  のり覆工の被災

> のり覆工のみが被災を受ける事例もある
> 。のり覆工には、おもに表面の凹凸部に流水からの抗力や揚力が作用し、自重によってこれらの流体力に抵抗する。しかし、流体力が卓越すると被災にいたることがある。例えば、小口部分が保護され、めくれは発生しないのり覆工であっても、ブロックの自重による摩擦抵抗よりも、抗力・揚力等の作用が卓越すると、ブロックは、作用外力の方向に滑動をはじめ、のり覆工は被災にいたる。また、捨石のように、球に近い素材を用いた構造ののり覆工では、素材の径や比重が不足すると、流水からの掃流力によって、のり覆工が掃流されてしまうことがある。のり覆工には、ブロックや石等の使用素材による形状の違いのほかに、胴込コンクリートによって一体化を図った「練り」タイブのものと、一体化を図らない「空」タイブのものとがある。この違いは、流水の作用に耐える強さの差となって現れる。

4.  天端工及び天端保護工の流失

> 低水護岸の天端部分の被災事例も多い。洪水時の流量、河道の断面形状あるいは平面形状によっては、洪水が高水敷から低水路部分に落ち込んだり、逆に低水路部分から高水敷に乗り上げたりする現象が発生する。このような現象が発生すると、天端部分では大きな流速を生じるので、天端工及び天端保護工にブロックを用いる場合には、重量や敷設幅が不足すると、めくれや滑動を生じる。天端工及び天端保護工の流失は、護岸のり覆工の背面の裏込材の流失を招き、最悪の場合はのり覆工の破壊にいたる。

5.  背面土砂の吸出し

> 護岸の裏面の堤体土が吸出しを受けて、護岸全体が破壊にいたる場合もある。この原因は、吸出防止材の機能不足にあることが多い。吸出防止材の開孔径、透水係数等の材質が堤体土に対して適切でなかったり、吸出防止材を敷設する際の重ね合わせ部等に隙間が生じた場合等には、吸出現象が発生することがある。吸出現象はいったん発生すると周辺部にも伝播する危険がある。これによって、のり覆工の裏面に凹凸が生じるため、のり覆工の安定条件そのものも崩れてしまう。このため、護岸の被災が広範囲に及ぶ危険がある。

＜標　準＞

+----------------------------------------------------------------------+
| 護岸は、のり                                                         |
| 覆工、基礎工、根固工をはじめいくつかの部位から構成される。各部位には |
| 水圧、土圧、計画高水位（高潮区間にあっては計画高潮位）以下の水位の流 |
| 水の通常の作用による外力等が作用するほか、河床変動等の影響を受けるが |
| 、護岸を構成する各部位の設計に当たっては、護岸全体として機能を確保し |
| 、所要の安全性を確保できる構造となるように設計することを基本とする。 |
|                                                                      |
| また、設計                                                           |
| に当たっては、河川環境及び景観を考慮した構造とすることを基本とする。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

> 護岸の主な構造については、下記の資料が参考となる。

1)  [改訂
    > 護岸の力学設計法](https://www.jice.or.jp/tech/material/detail/21),
    > 令和 5 年 10 月,（一財）国土技術研究センター.

```{=html}
<!-- -->
```
17) 護岸・水制の計画・設計,平成15年6月, （株）山海堂.

> 環境や景観に配慮した設計については、下記の資料が参考となる。

18) 多自然川づくりポイントブックⅢ，平成23年10月,（財）リバーフロント整備センター.

> 護岸の明度及びテクスチャの計測手法及び評価手法については、下記資料が参考となる。

19) 大河川における多自然川づくり～Q&A 形式で理解を深める～，平成 31 年 3
    月,国土交通省水管理・国土保全局河川環境課

    （最新版）大河川における多自然川づくり
    －Ｑ＆Ａ形式で理解を深める－，令和6年7月一部改訂，国土交通省水管理・国土保全局河川環境課.

護岸等の、被災部位別のおもな被災原因や護岸構造ごとの被災形態の特徴については、下記資料が参考となる。

20) 諏訪義雄：[河川構造物と堤内地の洪水応答特性と減災への反映](https://chuo-u.repo.nii.ac.jp/?action=pages_view_main&active_action=repository_view_main_item_detail&item_id=13358&item_no=1&page_id=13&block_id=21)，中央大学博士論文，2021.3

[]{#_Hlk130220487 .anchor}

1.  安全性能の照査等

```{=html}
<!-- -->
```
1.  []{#_Toc130309122 .anchor}設計の対象とする状況と作用

＜考え方＞

護岸の設計に当たっては、護岸の工種ごとに、必要に応じて常時、洪水時、地震時等の安全性能を確保することが求められる。

護岸の安全性能の照査は、のり覆工、基礎工、根固工等の各部位ごとに行うこととし、照査に当たっては、基礎地盤の特性、河道の特性、維持管理に必要となる前提条件等を土質地質調査や河道特性調査等に基づき設定する必要がある。

設計の対象とする作用は、計画高水位以下の水位の流水の通常の作用による流体力と自重に加え、積み護岸の場合は土圧と水圧、擁壁護岸や矢板護岸の場合はさらに地震時慣性力等が対象になると考えられる。その他必要に応じて、河床変動、載荷重、揚圧力、波浪や風浪、津波、航走波、副振動（セイシュ）、アイスジャム、流砂・礫の衝突による摩耗・破損、土石流等の影響を考慮するものとする。

なお、施工条件の影響により、施工時荷重についても考慮が必要となる場合がある。

＜標　準＞

+----------------------------------------------------------------------+
| 護岸の安全性能の照査は、のり覆工、基礎工、根固                       |
| 工等について行うこととし、照査に当たっては、次の表から、護岸の設置箇 |
| 所、工種ごと、各部位の構造形式ごとに、設計の対象として必要とされる状 |
| 況と作用を設定し、これを踏まえて照査事項を設定することを基本とする。 |
|                                                                      |
| 表1-4-1　護岸の設計の対象とする状況と作用                            |
|                                                                      |
|   護岸の状況   作用^※１^                                             |
|   ------------ ----------------------------------                    |
| -------------------------------------------------------------------- |
|   常時         自重、土圧、水圧                                      |
|   洪水時       計画高水位（高潮区間にあっては計                      |
| 画高潮位）以下の水位の流水の通常の作用による流体力、自重、土圧、水圧 |
|   地震時       自重、土圧、水圧、地震の影響^※2^                      |
|                                                                      |
| > ^                                                                  |
| ※１^河床変動、載荷重、揚圧力、波浪や風浪、津波、航走波、副振動（セイ |
| シュ）、アイスジャム、流砂・礫・流木の衝突による摩耗・破損、土石流、 |
| 施工時荷重等の影響を受ける場合には、必要に応じて考慮するものとする。 |
| >                                                                    |
| > ^※２^地震時土圧、地震時動水圧、地震時慣性力等                      |
+----------------------------------------------------------------------+

＜参考となる資料＞

> 護岸の設計の対象とする状況と作用については、下記の資料が参考となる。

1)  [改訂
    > 護岸の力学設計法](https://www.jice.or.jp/tech/material/detail/21),
    > 令和 5 年 10 月,（一財）国土技術研究センター.

```{=html}
<!-- -->
```
21) 護岸・水制の計画・設計,平成15年6月,（株）山海堂.

22) 災害復旧工事の設計要領,令和4年8月,（公財）全国防災協会.

    （最新版）災害復旧工事の設計要領,令和6年8月,（公財）全国防災協会.

23) 鋼矢板二重式工法仮締切りマニュアル,平成13年5月,（財）国土技術研究センター.

24) 道路土工 擁壁工指針，平成24年7月,（公社）日本道路協会.

25) 道路土工 仮設構造物工指針，平成11年3月,（公社）日本道路協会.

26) 道路橋示方書同解説　Ⅳ下部構造編，平成29年11月,（公社）日本道路協会.

27) 水理公式集，平成31年3月,（公社）土木学会.

28) 海岸保全施設の技術上の基準・同解説，平成30年8月,（一社）全国海岸協会.

```{=html}
<!-- -->
```
2.  []{#_Toc130309123 .anchor}安全性能の照査

＜考え方＞

護岸は、「4.4.3（1）設計の対象とする状況と作用」に示す状況と作用ごとに、照査の条件として適切な水位を設定し、安全性能について照査する必要がある。

護岸の洪水時の安全性能の照査は、計画高水位（高潮区間にあっては計画高潮位）以下の水位の流水の通常の作用による抗力や揚力、掃流力等の流体力や、土圧及び水圧に対して、のり覆工、基礎工、根固工等の各部位が安全であるよう照査を行う。このほかにも、土石流、高潮、波浪、アイスジャム、載荷重等を考慮すべき場合もあるので、必要に応じて検討する。　

堤防、河岸に作用する侵食力の大きさや、護岸ののり覆工に作用する抗力、揚力などの流体力は、流速の大小と密接に関連している。このため、流速の評価は照査において重要となる。また、護岸の設計では、洪水時の最深河床高が重要な設計条件となる。護岸の被災事例の多くが、流水による急激な河床洗掘を契機とした基礎工の流出を原因としているためである。なお、基礎工の沈下やのり尻からの土砂の流出などを防止するために設置される根固工を設計する場合でも最深河床高の評価は重要である。

1.  流速

洪水時に発生する流速は、護岸を設置する箇所の最深河床高、低水路及び高水敷の粗度、のり勾配等の影響を受ける。したがって、設計に用いる流速や、最深河床高等の設計条件は、水理模型実験、数値計算、最近の研究成果による理論的な算定方法等の中から護岸設置箇所の河道特性を反映できる方法で評価する必要がある。ここでは、堤防、河岸に作用する流速を代表流速
V~0~と定義して、その求め方の一手法を示す。

堤防及び低水河岸の護岸設計に用いる流速を代表流速V~0~と定義する。本節に示す代表流速
V~0~の算定方法は、マニングの平均流速公式で求めた平均流速V~m~について、考慮されていない要因を水理的に評価補正することにより補正係数αを求め、

$$V_{0\ } = \ \alpha V_{m}\ $$

として求めるものである。ただし、低水路平面形状が変化に富む場合や高水敷上の樹木群と堤防の間に速い流れが生じる場合等には、この手法ではV~0~の評価が困難である。このような流れが複雑な場合は、平面二次元流解析、あるいは水理模型実験によってV~0~を算定することが望ましい。

平均流速V~m~は、護岸の設置位置に応じてマニングの平均流速公式より算定する。

$$V_{m\ } = \frac{1}{n}\ {H_{d}}^{\frac{2}{3}}\ {I_{e}}^{\frac{1}{2}}$$

ここで、設計水深H~d~は低水護岸及び堤防護岸の場合は低水路内断面平均流速を算定するための水深を、高水護岸の場合は堤防近傍流速を算定するための水深をさす。

洗掘や湾曲等の影響により、式(1-4-2)で求まるV~m~を補正する必要がある場合には、式(1-4-1)の補正係数αを用いて代表流速V~0~を求める。補正を行う要因には、砂州の発生、川幅の変化、低水路の流れと高水敷の流れの干渉、湾曲等の河道特性による要因、及び根固工、橋脚、堰、床止め上流部等での構造物周辺の局所的な流れの変化等があげられる。具体的な補正係数の値については種々の研究成果等から定めるものとする。

設計に用いる流速は、計画高水位以下の水位のさまざまな流況条件の中で、実際に河岸等に作用する流速のうち最大の値を用いる必要がある。流速は、一般に計画高水位相当の水深が生じた場合が最も大きくなるが、堰・床止め等の横断構造物等や狭窄部の上下流部、高水敷から低水路へ流れが落ち込む場合や低水路の主流が高水敷に乗り上がる場合、水深変動に伴う河床形態の変化によって粗度係数の値に変動が生じる場合等、河道条件によっては、計画高水位以下の水位での流速が大きくなることに留意する必要がある。

2.  土圧、水圧等

積み護岸、擁壁護岸、矢板護岸等の設計では、流体力に加え土圧及び水圧を考慮する必要がある。擁壁、矢板の設計では、地震時の土圧及び水圧についても必要に応じて検討する。

3.  最深河床高

安全性能の照査では、洪水時の最深河床高が重要な設計条件となる。最深河床高は、洪水時の洗掘現象や埋め戻しによって変化するが、この変化の状態は河道特性によって異なり、定量的な評価に必要なデータ収集が観測の難しさもあって現段階では不十分なことから、最深河床高の定量的評価は難しい。そのため、これまでの研究成果等を基にした「4.4.4各部位の設計(2)基礎工」＜推奨＞の方法により最深河床高を推定するのが一般的である。

＜標　準＞

+----------------------------------------------------------------------+
| 護岸は、「4.4.3（1）                                                 |
| 設計の対象とする状況                                                 |
| と作用」に対し、洪水時等の安全性能について照査することを基本とする。 |
|                                                                      |
| 照査に当                                                             |
| たっては、これまでの経験及び実績から妥当とみなせる方法又は論理的に妥 |
| 当性を有する方法等、適切な知見に基づく手法を用いることを基本とする。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

> 護岸の安全性能の照査については、下記の資料が参考となる。

1)  [改訂
    > 護岸の力学設計法](https://www.jice.or.jp/tech/material/detail/21),
    > 令和 5 年 10 月,（一財）国土技術研究センター.

```{=html}
<!-- -->
```
29) 護岸・水制の計画・設計,平成15年6月, （株）山海堂.

＜例　示＞

海岸保全施設としての堤防に設置される護岸の性能の照査に当たっては、当該海岸における設計潮位、設計波、設計津波等を適切に設定し、波のうちあげ高若しくは越波流量又は設計津波の水位（護岸によるせり上がりを考慮した津波高さ）が所定の値（うちあげ高にあっては天端高、越波流量にあっては許容越波流量、設計津波の水位にあっては地震後の天端高）を上回らないことを確認することとされている。

＜参考となる資料＞

> 護岸の洪水時の安全性能については、下記の資料が参考となる。

1)  [改訂
    護岸の力学設計法](https://www.jice.or.jp/tech/material/detail/21),
    令和 5 年 10 月,（一財）国土技術研究センター.

```{=html}
<!-- -->
```
30) 護岸・水制の計画・設計,平成15年6月, （株）山海堂.

31) 水理公式集，平成31年3月,（公社）土木学会.

32) 海岸保全施設の技術上の基準・同解説，平成30年8月,（一社）全国海岸協会.

    1.  []{#_Toc130309124 .anchor}各部位の設計

```{=html}
<!-- -->
```
1.  []{#_Toc130309125 .anchor}のり覆工

＜考え方＞

のり覆工の破壊要因は流体力、および土圧・水圧であり、のり勾配によりどちらが主要因となるか分類できる。のり勾配が比較的緩い場合は'張り'の状態のため、流体力が破壊の主要因となり、のり勾配が比較的急な場合は'積み'の状態のため、土圧・水圧の作用が破壊の主要因となる。

のり勾配が比較的緩いのり覆工では、以下に示すような破壊形態をとる。

1.  コンクリートブロックのように底面が平坦で、上下流端がすり付け護岸で保護されているのり覆工では、流体力によりコンクリートブロックが滑動する破壊形態となる。

```{=html}
<!-- -->
```
1.  自然石のように、丸みを帯びた材料を用いたのり覆工では、流れにより掃流されてのり覆工が破壊される形態をとる。

2.  小口が保護されていないのり覆工では、流体力によりのり覆工がめくれて破壊にいたることが多い。

    胴込コンクリート等によりのり覆工が一体化されているかどうかも流水への抵抗力に差異を生じる。このことは同じ材料を用いたのり覆工でも設置状態が異なれば安定性が異なることを示している。

また、のり勾配が比較的急なのり覆工では、常時・洪水時（洪水後含む）・地震時に作用する背面の土圧により倒壊する場合がある。

これらの観点から、流体力あるいは土圧・水圧の破壊要因、滑動・めくれ等の破壊形態、小口や一体性等の設置状態を反映させ、安定性照査のモデルを設定する。

堤防護岸（高水護岸）ののり覆工の高さは、原則として堤防天端までとする。これは、計画高水位付近を水面とする洪水が流下した場合に、洪水時に発生する風浪、うねり、跳水等によって、計画高水位より上の堤防法面が侵食されるおそれがあるためである。また、河川管理施設等の周りで、流水が著しく変化することとなる区間である場合等も、原則として堤防天端まで設置することとされている。ただし、植生被覆等の効果等も勘案して過大な範囲とならないように留意する必要がある。

低水護岸については、流水の作用状況や植生等による自然河岸の侵食耐力等を勘案して、必要とされる範囲に設置するものとする。低水護岸では、のり覆工の高さは、一般には設置する河岸付近の高水敷高とする。

なお、河川管理施設等の周りに護岸を設置する場合の設置範囲及び湖沼、高潮区間に護岸を設置する場合の措置については、河川管理施設等構造令の記述を参照するものとする。

計画堤防断面形状ののり面は、一枚のりを基本としているが、堤防に小段があり、小段の上に護岸を設ける場合には、小段位置において、コンクリートブロック張り等の場合は基礎工を、蛇篭張り等の場合には止杭を設けるものとする。石積みまたはコンクリートブロック積みの練積みのり覆工においては、組石材を胴込コンクリートで一体構造とする。

護岸には残留水圧が作用しないよう、必要に応じて裏込材を設置する必要がある。ただし、裏込土砂が砂礫質で透水性が高い場合には必ずしも裏込材を設置する必要はない。護岸には一般に水抜きは設けないが、掘込河道等で残留水圧が大きくなる場合には、必要に応じて水抜きを設けるものとする。水抜きは、堤体材料等の微粒子が吸い込まれないよう考慮するものとする。

吸出防止材は、護岸背後の残留水が抜ける際、あるいは高流速の流水がのり覆工に作用する際に、のり覆工の空隙等から背面土砂が吸い出されるのを防ぐために設置する。また、吸出防止材は練積み護岸において裏込材への細粒分の流入を防止したり、施工性を考慮して設置される場合もある。

のり覆工には必要に応じて次の付属工を設けるものとする。

1.  小口止工：のり覆工の上下流端に施工して、護岸を保護する。

```{=html}
<!-- -->
```
1.  横帯工：のり覆工の延長方向の一定区間ごとに設け、護岸の変位・破損が他に波及しないように絶縁する。

```{=html}
<!-- -->
```
2.  縦帯工：護岸ののり肩部の施工を容易にし、また護岸ののり肩部の破損を防ぐ。

なお、天端工、天端保護工及びすり付け工については、「4.4.4各部位の設計(4)その他の設計（天端工、天端保護工、すり付け工）」にて記載する。

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------
  のり覆工は、河道特性、河川環境等を考慮して、流水・流木の作用、土圧等に対して安全な構造となるように設計することを基本とする。
  ------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

のり勾配が1:1.5以下の緩い勾配の場合は'張り'の状態とし、のり勾配が1:1.5以上の急な勾配の場合は'積み'の状態と考えることが多い。

のり覆工のうち、張り構造の主な破壊形態を以下に示す。

1.  滑動：流体力が部材に作用し底面摩擦力を上回った場合にすべりだす現象である。空ブロック張りなどの単独部材を整然と配置したのり覆工や、練張りなど部材が群体とみなせるのり覆工の破壊形態である。

![図形
中程度の精度で自動的に生成された説明](media/image12.png){width="1.7229166666666667in"
height="1.0in"}![](media/image13.png)

3.  めくれ：流体力の作用によって部材がめくれる現象である。小口のないのり覆工端部等に生ずる。例えば、すり付け護岸の連節ブロック端部の破壊現象にみられる。

![図形
中程度の精度で自動的に生成された説明](media/image14.png){width="1.8611111111111112in"
height="0.8770833333333333in"}

4.  掃流：自然石**等**の部材が流れの作用により、転がり（転動あるいは小跳躍して）移動する現象である。捨石のように部材間の一体性が弱いものと、空石張りのように部材間の一体性（かみ合わせ）が強いものとで流体力を分けて検討する必要がある。また、篭工では中詰め材の掃流による篭の変形が破壊の主因となる。

![図形
中程度の精度で自動的に生成された説明](media/image15.png){width="1.6045866141732283in"
height="0.8657874015748032in"}

以上によるのり覆工の流体力による破壊形態をまとめて表1-4-2に示す。

**表1-4-2　のり覆工の流体力による破壊形態**

+------------+--------------+-------------------------------+
| > 破壊形態 | > 設置状態   | > 安定性照査のモデル          |
+============+==============+===============================+
| > 滑動     | > 単体       | > 「滑動-単体」モデル         |
+------------+--------------+-------------------------------+
| > 滑動     | > 群体       | > 「滑動-群体」モデル         |
+------------+--------------+-------------------------------+
| > めくれ   | > 単体       | > 「めくれ」モデル            |
+------------+--------------+-------------------------------+
| > 掃流     | > 一体性弱い | > 「掃流-一体性が弱い」モデル |
+------------+--------------+-------------------------------+
| > 掃流     | > 一体性強い | > 「掃流-一体性が強い」モデル |
+------------+--------------+-------------------------------+
| > 掃流     | > 篭詰め     | > 「掃流-篭詰め」モデル       |
+------------+--------------+-------------------------------+

> のり覆工の安定性照査のモデルは、過去の被災事例等を踏まえ、主な破壊形態及び設置状態に基づき分類できる。のり覆工の主な安定性照査のモデルを以下に示す。

1.  「滑動-単体」モデル

> のり覆工の一体性が無く、個々の部材が流れの中に単独で置かれた状態を想定する。空ブロック張り護岸等が該当する。単体として扱うことのできるのり覆工の流体力に対する安定検討は、滑動、流れ方向の転動、のり面最大傾斜角方向の転動が考えられるが、一般に用いられるのり覆工では、滑動に比べて転動に対する安定性がかなり高いことがわかっているので、一般には式(1-4-3)に示すように抗力D、揚力Lに対する部材単体の滑動を想定した照査をおこなえばよい。

$\mu\left( W_{w}\cos\theta\  - L \right)\  \geqq \ \left( \left( W_{w}\sin\theta\  \right)^{2}\  + \ D^{2} \right)^{\frac{1}{2}}$

$$L = \ \frac{1}{2}\ \rho_{w}C_{L}A_{b}{V_{d}}^{2}$$

$$D = \ \frac{1}{2}\ \rho_{w}C_{D}A_{D}{V_{d}}^{2}$$

> ここで、μ:摩擦係数（一般にμ=0.65)、Ww:のり覆工の部材の水中重量、θ:のり面勾配、ρw:水の密度、g:重力加速度、C~L~:部材の揚力係数、C~D~:部材の抗力係数、A~b~:部材の上方投影面積、A~D~:部材の流下方向投影面積である。式(1-4-3)の適用に当たっては、周囲の部材拘束効果等を考慮していないので、Wwは安全側の値であると考えられる。　　
>
> 既往の設置事例からすると算定される重量の1/3程度で安定性に問題の生じていない事例が多く、1/3程度の値を照査の目標値としてもよい。同じ部材を、次に示す「滑動-群体」モデルにより照査して求まるWwは拘束効果を考慮した値であり、Wwの下限の参考値になるので、それとも比較のうえ検討することが望ましい。
>
> 式(1-4-3)に用いる抗力・揚力は、のり覆工表面の相当粗度k~S~高さでの流速である近傍流速V~d~を用いて評価する
> 。
>
> 「滑動-単体」モデルに用いる抗力係数C~D~、揚力係数C~L~は、単独に設置した状態での係数を用いる必要がある。一般に、抗力係数C~D~、揚力係数C~L~は個々の形状について実験により定めることが基本であるが、水理公式集や既往の実験成果により形状が類似の部材の値を流用することもできる。また揚力係数C~L~の簡便な設定方法として、とりうる範囲の上限値に近い1.0程度の値を与えて安全側の照査を行う方法もある。

2.  「滑動-群体」モデル

> このモデルには、胴込コンクリートや連結が確実な鉄筋等によってのり覆工の一体性が保たれており、隣接部材と接した面への流体力の作用を無視できる工種である、練張り護岸、連節ブロック護岸等が該当する。群体の流体力に対する安定性検討は、単体と同様に滑動について行えばよく、式(1-4-3)を基本式とした検討を行う。ただし、揚力L、抗力Dを評価する際の投影面積のとり方は異なり、

$$L = \ \frac{1}{2}\ \rho_{w}C_{L}A_{g}{V_{d}}^{2}$$

$$D = \ \frac{1}{2}\ \rho_{w}C_{D}A_{D}{V_{d}}^{2}$$

> である。ここで、A~g~:部材の突出部の上方投影面積、A~D~:部材の突出部の流下方向投影面積である。したがって、C~L~、C~D~は各々の面積に対して評価された係数を用いる。これにより求まるWwは、整然と平面的に施工された一体性を持つのり覆工に適用されるものであり、現実には部分的に段差等を生ずることが想定されることから
> 照査に当たっては計算されるのり覆工の控え厚に対して30～50％程度、割り増した値を採用することが望ましい。
>
> 群体として扱うのり覆工でも、のり覆工表面の相当粗度k~S~高さでの近傍流速V~d~を用いるが、このときは単体の場合とは異なり乱れの影響は考慮しない。
> また、抗力係数C~D~、揚力係数C~L~は、単体と同様に実験等を基本に定めるものとする。

3.  「めくれ」モデル

> このモデルには、のり覆工の上流側端部の小口が保護されていない状態で設置されている空張り、あるいは連節ブロック護岸等が該当する。「めくれ」モデルでは、のり覆工の部材の重量（あるいは控え厚）は次式に示すように、上流端に置かれた部材が流体力によって回転しないように照査を行う。

$$W_{w}\cos\theta\ \frac{l_{b}}{2} \geqq \ L\ l_{L}\  + Dl_{D}$$

> ここで、l~b~：上流端の部材の流下方向長さ、l~L~：上流端の部材の揚力に対する回転半径、l~D~：上流端の部材の抗力に対する回転半径であり、揚力、抗力のとり方は「滑動-単体」モデルと同じである。この場合に求められる重量は安定条件の限界に近いものであり、十分に安全とするために割り増すと、上流端部の部材が重くなりすぎる場合がある。このため、端部をもぐらせる、あるいは、小口止めを設ける等の方法により端部における流体力の作用する面積を小さくする工夫をすることが望まれる。
>
> 流体力は、「滑動-単体」モデルと同じく乱れを考慮した近傍流速を用いる。また、抗力係数C~D~、揚力係数C~L~についても、他モデルと同様にして実験等を基本に定めるものとする。

4.  「掃流-一体性が弱い」モデル

> 隣接部材との一体性が弱く、個々の部材が敷き並べられている構造ののり覆工であり、捨石護岸が該当する。単独の部材の安定に関する照査を行う。具体的手法としては、アメリカ工兵隊の基準にある、捨石径の算定方法に基づいて照査するとよい。すなわち、のり覆工の部材に作用する掃流力が部材（自然石）の移動限界を超えないものとして代表流速V~0~と部材の大きさの関係を次式により定める。

$$D_{m} = \ \frac{1}{{E_{1}}^{2}\ 2g\left\lbrack \frac{\rho_{s}}{\rho_{w}} - 1 \right\rbrack}\ {V_{0}}^{2}\text{\ \ \ \ \ \ }\left( m \right)$$

> ここに、D~m~:石の平均粒径、ρ~S~:石の密度、E~1~:流れの乱れの強さを表す実験係数である。通常は
> E~1~=1.2が用いられる場合が多い。この値は、比較的乱れが小さい流れの場合の係数である。乱れが大きい流れの場合の係数としては、E~1~=0.86という値が示されている。
>
> 式(1-4-6)は水平面上の捨石について与えられるものであり、捨石を斜面角度θののり面に設置する場合には、粒径D~m~に対して斜面の補正係数Kを乗じた値K・D~m~を捨石径とする。ここで、φは石材料の水中安息角(φ:自然石で38゜程度、砕石では41°程度）である。

$$K = \ \frac{1}{\cos\theta\ \sqrt{1 - \frac{\tan^{2}\theta}{\tan^{2}\varnothing}}}$$

5.  **「掃流-一体性が強い」モデル**

> 一体性が強いのり覆工とは、ほぼ等しい大きさの部材（切出し石等）が、かみ合わせ効果を期待できるよう、隙間に砕石等の胴込材を施工して、整然と設置されている状態である。空石張り護岸が該当する。
>
> 河床材料の掃流と同じ現象であり、一般に掃流力が限界掃流力を上回った場合に移動が生じる。限界掃流力はシールズ等の水平床上での実験式によって求められた、

$$\tau_{*d}\  = 0.05\ \ \ \ \ \ \ \ \ \ \ \ \ \tau_{*d}:部材に作用する無次元せん断力$$

> とし、角度θの斜面に設置する場合には次式の補正を行う。

$$\tau_{*\text{sd}} = \ \ \tau_{*d}\  \times \ \cos\theta\sqrt{1 - \frac{\tan^{2}\theta}{\tan^{2}\varnothing}}$$

> 必要径D~m~は次式にて検討する。相当粗度k~S~はD~m~と等しくとればよい。

$$D_{m} \geqq \frac{{V_{0}}^{2}}{\left\lbrack \left\{ 6.0\  + 5.75\ \log_{10}\left( \frac{H_{d}}{k_{s}} \right) \right\}^{2}・\tau_{*\text{sd}}・S・g \right\rbrack}\ $$

> 求められた値は、何らかの原因でかみ合わせ効果が不十分になると、急激に流出しやすくなるので、照査の目標値としては30～50％程度割り増した値とすることが望ましい。

6.  「掃流-篭詰め」モデル

> 篭詰め状態ののり覆工とは、ほぼ同一粒径の球状の材料（石等）が篭状の枠の中に詰められている状態であり、フトン篭護岸、蛇篭護岸が該当する。篭詰め状態ののり覆工は、代表流速
> V~0~に対して、篭に変形を与えるような篭詰め材料の移動を原則として許さないものとして安定性を照査する。したがって、篭詰め材料が無次元掃流力に耐えうるよう照査を行う。ここでは、無次元限界掃流力をコロラド大学の実験結果より、
>
> τ~\*d~=0.10(篭の変形を許さない場合）
>
> τ~\*d~=0.12(篭の変形を多少許す場合）
>
> として、部材の必要径を照査する。ただし、これらの値は水平床上での値であり、角度θの斜面に設置する場合は「掃流-一体性の強い」モデルに示した式(1-4-9)を用いて補正する。ただし、フトン篭を階段状に設置する場合は平坦に設置した条件で計算してよい。中詰め石の平均粒径D~m~は、τ~\*d~を求める際の相当粗度としてはk~S~=2.5D~m~程度として算出する。
>
> また、新しい材料等を用いて強度の高い篭を用いる場合等では、個々の場合について実験によりτ~\*d~を定める必要がある。

＜関連通知等＞

1)  河川管理施設等構造令及び同令施行規則の施行について，昭和51年11 月23
    日, 建設省河政発第70 号,建設省河川局長通達．

＜参考となる資料＞

> のり覆工の設計については、下記の資料が参考となる。

1)  [改訂
    > 護岸の力学設計法](https://www.jice.or.jp/tech/material/detail/21),
    > 令和 5 年 10 月,（一財）国土技術研究センター.

```{=html}
<!-- -->
```
33) 護岸・水制の計画・設計,平成15年6月, （株）山海堂.

34) 災害復旧工事の設計要領,令和4年8月,（公財）全国防災協会.

> （最新版）災害復旧工事の設計要領,令和6年8月,（公財）全国防災協会.

35) 土木構造物標準設計第2巻手引き（擁壁類），平成12年9月，（一社）全日本建設技術協会.

36) 道路土工 擁壁工指針，平成24年7月,（公社）日本道路協会.

37) 水理公式集，平成31年3月,（公社）土木学会.

38) 海岸保全施設の技術上の基準・同解説，平成30年8月,（一社）全国海岸協会.

```{=html}
<!-- -->
```
2.  []{#_Toc130309126 .anchor}基礎工

＜考え方＞

護岸の被災事例で最も顕著なものは、洪水時の河床洗掘を契機として基礎工が浮き上がってしまい、基礎工及びのり覆工が被災を受ける事例である。

基礎工が被災を受けると、裏込材の吸出し等が生じ、広範囲にわたる被災を引き起こすことがある。このため、基礎工の設計では、基礎工天端高の決定が最も重要である。

基礎工天端高は、洪水時に洗掘が生じても護岸基礎の浮上がりが生じないよう、過去の実績や調査研究成果等を利用して最深河床高を評価することにより設定するものとする。なお、根入れが深くなる場合には、根固工を設置することで基礎工天端高を高くする方法もある。

また、基礎工の天端高の基本的な考え方としては、以下の四つがあげられ、これらの考え方から、当該箇所に最も適切な考え方で基礎工の天端高を決定する。

1.  最深河床高の評価高を基礎工天端高とし、必要に応じて前面に最小限の根固工を設置する方法。

```{=html}
<!-- -->
```
1.  最深河床高の評価高よりも上を基礎工天端高とし、洗掘に対しては前面の根固工で対処する方法。

2.  最深河床高の評価高よりも上を基礎工天端高とし、洗掘に対しては基礎矢板等の根入れと前面の根固工で対処する方法。

3.  感潮区間等、水深が大きく基礎の根入れが困難な場合に、基礎を自立可能な矢板で支える方法。

基礎工天端高の設計に当たっては、一連の護岸（一湾曲部程度）は、その区間の最深河床高に対して求めた基礎工天端高とすることが基本的な考え方であるが、一連の護岸の設置延長が長く、かつ深掘れ位置が移動しないような場合には、河道の特性に応じて断面ごとの最深河床高の評価高を検討することが望ましい。

![](media/image16.emf){width="5.852083333333334in"
height="3.6173611111111112in"}

基礎工は、土質、施工条件、河道特性に応じて選択する。地盤が良好な場合には直接基礎とし、軟弱地盤の場合には杭または矢板を用いることが多い。また、平水位の高い箇所や洗掘を考慮する必要のある箇所では矢板を用いるケースがある。なお、護岸を設置する地盤が堅固な岩盤である場合は、基礎工を設置せず、のり覆工を直接岩着するケースもある。

基礎工の工種は、その強度、耐久性等を考慮して選定するものとする。鋼矢板を用いる場合は腐食を考慮することとし、特に酸性河川や感潮河川等については、腐食に対して十分に考慮しなければならない。

図1-4-10に、基礎工の例を示す。

![](media/image17.png)

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------
  護岸の基礎工は、洪水による洗掘等を考慮して、のり覆工を支持できるよう、安全な構造となるように設計することを基本とする。
  ------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

最深河床高は、洪水時の洗掘現象や埋め戻しによって変化する。この変化の状態は河道特性によって異なり、定量的な評価に必要なデータ収集が観測の難しさもあって現段階では不十分なことから、最深河床高の定量的評価は難しい。そのため、これまでの研究成果等を基にした次の方法により最深河床高を推定するのが一般的である。

1.  経年的な河床変動データからの評価

```{=html}
<!-- -->
```
4.  既往研究成果からの評価

5.  数値計算による評価

6.  移動床水理模型実験による評価

これらの方法のなかから、河床変動データの所在状況、河道特性、設計対象区間の重要性等を勘案して適切な方法を用いる。これらの方法のうち、「1)経年的な河床変動データからの評価」は、過去の被災状況や河床材料及び岩の露出状況といった河床変動要因を把握するのに有効である。ただし、計画高水位相当の洪水を経験していない場合や洪水後の埋め戻し現象によって必ずしも洪水中の最深河床高を把握できていないこともあるため、「**2)**既往研究成果からの評価」による評価と合わせて最深河床高を評価することが望ましい。

基礎工天端高を、「4.4.4各部位の設計(2)基礎工」＜考え方＞の2)及び3)の方法で設定する場合には、基礎工天端高を計画断面の平均河床高と現況河床高のうち低いほうより0.5～1.5ｍ程度深くしているものが多い。

＜関連通知等＞

1)  河川工事における鋼矢板選定について，令和元年9 月5 日,
    > 国土交通省水管理・国土保全局治水課流域減災推進室長、防災課防災企画官,事務連絡．

＜参考となる資料＞

> 基礎工の設計については、下記の資料が参考となる。

1)  [改訂
    > 護岸の力学設計法](https://www.jice.or.jp/tech/material/detail/21),
    > 令和 5 年 10 月,（一財）国土技術研究センター.

```{=html}
<!-- -->
```
39) 護岸・水制の計画・設計,平成15年6月,（株）山海堂.

40) 災害復旧工事の設計要領,令和4年8月,（公財）全国防災協会.

> （最新版）災害復旧工事の設計要領,令和6年8月,（公財）全国防災協会.

41) 鋼矢板二重式工法仮締切りマニュアル,平成13年5月,（財）国土技術研究センター.

42) 道路土工 擁壁工指針，平成24年7月,（公社）日本道路協会.

43) 道路土工 仮設構造物工指針，平成11年3月,（公社）日本道路協会.

44) 水理公式集，平成31年3月,（公社）土木学会.

45) 海岸保全施設の技術上の基準・同解説，平成30年8月,（一社）全国海岸協会.

```{=html}
<!-- -->
```
3.  []{#_Toc130309127 .anchor}根固工

＜考え方＞

護岸の破壊は、基礎部の洗掘を契機として生じることが多い。根固工は、その地点の流勢を減じ、さらに河床を直接覆うことで急激な洗掘を緩和する目的で設置される。

根固工は大きな流速の作用する場所に設置されるため、流体力に耐える重量であること、護岸基礎前面に洗掘を生じさせない敷設量であること、耐久性が大きいこと、河床変化に追随できる屈とう性構造であることが必要となる。このため、根固工は、流体力に対して安定を保つことのできる重量以上とするとともに、予測される洗掘に対して基礎工前面を保護することのできるような敷設幅、敷設高を照査する。

根固工の敷設天端高は基礎工天端高と同高とすることを基本とするが、根固工を基礎工よりも上として洗掘を防止する方法もある。また、根固工とのり覆工との間に間隙を生じる場合には、適当な間詰工を施すものとする。

根固工の代表的な工種としては次のようなものがある（図1-4-11)

![](media/image18.png){width="4.695833333333334in"
height="3.321527777777778in"}

1.  捨石工：十分な重量を有する捨石を用いる。

```{=html}
<!-- -->
```
1.  沈床工：粗染沈床、木工沈床、改良沈床等があり、粗染沈床は緩流河川で、木工沈床は急流河川で用いられることが多い。改良沈床は枠組み材や中詰め材にコンクリート材を用いたもので強度が大きく、水中から露出する場合でも耐久性に優れる。

2.  篭 工：蛇篭、フトン篭等を用いる。

3.  異形コンクリートブロック積工：各種の異形コンクリートブロックを用いたもので、層積みと乱積みがある。

根固工は、設置箇所の河道特性等に応じて最も適する構造とすべきであり、のり覆工同様に過去の経験・類似河川の実績、あるいは試験施工・模型実験、調査研究の成果等に基づき、必要に応じて力学的安定や敷設量等について照査しながら、適切に設計する必要がある。

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------
  根固工は、河床の変動等を考慮して、基礎工が安全となるよう、流体力の作用に対して安全な構造となるように設計することを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

根固工の敷設方法には、洗掘前の河床に重ね合わせずに設定して自然になじませる場合と、既存の深掘れ部に重ねて設置する場合とがある。

沈床を深掘れ部に重ねて設置する場合には3～6m幅を基本とし、これを階段状に積み重ねることが多い。沈床の場合には、重ね合わせ幅を、下段沈床幅の1/3以上とする事例が多い。木工沈床を重ね合わせて設置する工法は、急流河川に多い事例である。

周辺の河床低下や洗掘が予想される区間では、護岸基礎前面の河床が低下しない敷設幅を確保する必要がある。すなわち、護岸前面に河床低下が生じても最低1列もしくは2m程度以上の平坦幅が確保されることが必要とされる。

幾何学的には、敷設幅Bは、根固工敷設高と最深河床高の評価高の高低差~Δ~Zを用いれば

$$B = L_{n} + \mathrm{\Delta}\frac{Z}{\sin\theta}$$

となる。 ここで、

L~n~: 護岸前面の平坦幅（ブロック1列もしくは2m程度以上）

θ: 河床洗掘時の斜面勾配

~Δ~Z: 根固工敷設高から最深河床高の評価高までの高低差

斜面勾配θは、河床材料の水中安息角程度になるが、安全を考えると一般に30゜とすればよい。以上より、基礎工天端高が設定されれば、最深河床高を評価することにより、照査の目標とする敷設幅を算定できる。

根固工の破壊は流体力が主要因である。なお、洗掘による変形に対しては、最深河床高の評価高を想定して十分な敷設幅をもたせることにより対応する。根固工のおもな破壊形態を以下に示す。

1.  滑動：部材に作用する流体力が底面摩擦力を上回った場合にすべりだす現象である。根固工の上流端や河床変動に伴い変形して突出した部材、凹凸の大きなコンクリートブロック等、流れの作用を全体的に受ける部材に生ずる。たとえば、根固工上流端部の異形ブロック層積み工、異形ブロック乱積み工等の破壊現象にみられる。

```{=html}
<!-- -->
```
4.  転動：流体力の作用によって一点を支点として部材がめくれ、回転する現象をさす。たとえば、根固工上流端部の異形ブロック層積み工、異形ブロック乱積み工**等**の破壊現象にみられる。

![](media/image19.png){width="2.2784722222222222in"
height="1.2958333333333334in"}

5.  掃流：部材が流れ方向の抗力や揚力の作用を受け、河床上を転動あるいは河床付近で小跳躍を繰り返しながら移動する現象である。部材が平坦に敷き並べられる工種にみられ、自然石や凹凸の少ないコンクリートブロックの部材が整然と設置された場合に生ずる、例えば捨石根固工、篭根固工**等**の破壊現象にみられる。

また、ブロック等の設置状態により層積み、乱積み、篭詰めに分けることができ、設置状態によっても安定性の考え方が異なってくる。以上の破壊形態をまとめて表1-4-3に示す。

**表1-4-3　根固工の流体力による破壊形態**

+--------------+------------+-------------------------------+
| > 破壊形態   | > 設置状態 | > 安定性照査のモデル          |
+==============+============+===============================+
| > 滑動・転動 | > 層積み   | > 「滑動・転動-層積み」モデル |
+--------------+------------+-------------------------------+
| > 滑動・転動 | > 乱積み   | > 「滑動・転動-乱積み」モデル |
+--------------+------------+-------------------------------+
| > 掃流       | > 乱積み   | > 「掃流-乱積み」モデル       |
+--------------+------------+-------------------------------+
| > 掃流       | > 篭詰め   | > 「掃流-篭詰め」モデル       |
+--------------+------------+-------------------------------+
| > 掃流       | > 中詰め   | > 「掃流-中詰め」モデル       |
+--------------+------------+-------------------------------+

根固工の安定性照査のモデルは、過去の被災事例等を踏まえ、主な破壊形態及び設置状態に基づき分類できる。根固工の主な安定性照査のモデルを以下に示す。

1.  「滑動・転動-層積み」モデル

> 上流端に位置する根固工であって、流体力による滑動、あるいは転動により部材の一連部分に移動を生じる。設置面はほぼ平らであり、規則的に敷き並べられた状態を想定する。異形ブロック層積みの根固工が該当する。
>
> 流体力が部材のほぼ全体に作用し、上流端部の根固工や、凹凸の大きな根固工では、滑動・転動の両方を想定した照査を行う。根固工の所要重量は流速の6乗に比例するので、流速の変化に対し重量の変化が非常に大きい点に留意する。
>
> 滑動及び転動に対する安定条件より、根固工の所要重量は次式により与えられる。

$$W\  > a\left( \frac{\rho_{w}}{\rho_{b}\  - \ \rho_{w}} \right)^{3}\ \frac{\rho_{b}}{g^{2}}\ \left( \frac{V_{d}}{\beta} \right)^{6}$$

> ここで、V~d~には一般に代表流速V~0~を用いてよい。また、ρ~b~は標準的な無筋コンクリートの密度の値（2.3t/m^3^程度）を参考としてよい。ただし、設計時に実重量に基づく密度が明らかなものはその値を用いてよい。係数a、βは部材の配置形状によって異なる。これらの値は、根固工の形状、部材の方向、配置形態に応じて、水理模型実験や現地の施工実績により求めることが望ましい。水理模型実験により数種類の異形コンクリートブロックについて求めたa、βを表1-4-4に参考として示す。
>
> 部材の連結が確実であれば、βを大きくとることができる。連結を確実にするためには、異形コンクリートブロック等を吊り下げることのできる径の鉄筋を用いるとともに、鉄筋を固着しているコンクリート部分が破壊にいたる引張り応力が作用しない構造とする必要がある。

**表1-4-4　異形コンクリートブロックの係数a及びβの参考値**

+----------------+--------+-------+
| > ブロック種別 | > a    | > β   |
+================+========+=======+
| > 対称突起型   | > 1.2  | > 1.5 |
+----------------+--------+-------+
| > 平面型       | > 0.54 | > 2.0 |
+----------------+--------+-------+
| > 三角錐型     | > 0.83 | > 1.4 |
+----------------+--------+-------+
| > 三点支持型   | > 0.45 | > 2.3 |
+----------------+--------+-------+
| > 長方形       | > 0.79 | > 2.8 |
+----------------+--------+-------+

6.  「滑動・転動-乱積み」モデル

> 上流端部の部材、あるいは凹凸が大きく不規則に積み上げられた状態にあり単独に扱うべき部材で、流体力による滑動・転動による移動が生じる。異形ブロック乱積みの根固工が該当する。
>
> このモデルの安定性の照査式は、「滑動・転動-層積み」モデルと同様である。式中に用いられるaは抗力係数、揚力係数等による係数であり、「滑動・転動-層積み」モデルと変わらない。βは一体性が認められる場合にβ\>1となるが、一体性の弱い乱積みではβ=1.0～1.3
> の範囲で設定するとよい。敷設箇所が現況より深掘れする恐れが強い場合等、安全性を高める場合にはβ=1.0とする。

7.  「掃流-乱積み」モデル

> 面的に設置された部材に作用する流体力が限界掃流力を上回って、掃流状態（転動や跳動）により移動する現象である。面的に密に敷き並べられていても、隣接部材との一体性が弱いため、単独で設置された状態を想定して安定検討を行う。捨石根固工が該当する。
>
> 安定性照査の基本式の考え方は、アメリカ工兵隊の基準にある捨石径の算定方法に基づいている。具体的内容は、のり覆工の「掃流**-**一体性が弱い」モデルと同様である。このとき、流速には設置箇所の代表流速V~0~を用いる。

8.  「掃流-篭詰め」モデル

> 面的に設置されたほぼ同一粒径の球状の材料（石等）が篭状のものの中に詰められ、中詰めの部材が掃流によって移動して破壊する。フトン篭の根固工が該当する。
>
> 安定性照査の基本式は、篭状の枠の中で篭の変形を生じるような中詰め材料の移動を原則として許さないものとする。具体的な内容はのり覆工の「掃流**-**篭詰め」モデルと同様である。

9.  「掃流-中詰め」モデル

> 中詰め状態の根固工とは、ほぼ等しい径の部材（切り出し石等）がかみ合わせ効果を持ちながら、格子枠状のものに詰められているもので、部材が流体力で掃流され破壊される。粗朶沈床、木工沈床が該当する。
>
> 安定性の照査は、代表流速V~0~に対して、部材の移動を許さないよう照査を行う。具体的内容については、のり覆工の「掃流**-**一体性が強い」モデルと同様である。

＜参考となる資料＞

> 根固工の設計については、下記の資料が参考となる。

1)  [改訂
    > 護岸の力学設計法](https://www.jice.or.jp/tech/material/detail/21),
    > 令和 5 年 10 月,（一財）国土技術研究センター.

2)  護岸・水制の計画・設計,平成15年6月,（株）山海堂.

3)  災害復旧工事の設計要領,令和4年8月,（公財）全国防災協会.

> （最新版）災害復旧工事の設計要領,令和6年8月,（公財）全国防災協会.

4)  日本の水制, 平成8年1月,（株）山海堂.

5)  水理公式集，平成31年3月,（公社）土木学会.

6)  海岸保全施設の技術上の基準・同解説，平成30年8月,（一社）全国海岸協会.

```{=html}
<!-- -->
```
4.  []{#_Toc130309128 .anchor}その他（天端工、天端保護工、すり付け工）

**①天端工、天端保護工**

＜考え方＞

天端工、天端保護工は、低水護岸の天端部分を洪水による侵食から保護する必要がある場合に設置するものであり、また天端工の端に巻止工を設置する場合もある。

天端工は、のり覆工と同様、洪水時に流体力が作用するので、これに対して安全な構造とする必要がある。なお、のり覆工と同じ工種を用いるのが望ましい。また、控え厚はのり覆工の設計と同じ方法で流体力の作用に対して安全な厚さとする必要がある。

天端保護工は、天端工と背後地の間から侵食が生じることが予測される場合に設置するものである。構造は屈とう性のある構造とし、流体力の作用に対して安全な厚さとする必要がある。

護岸の法肩部の線形が直線的で明瞭だと、自然な要素で構成されている河川景観の中で目立ち、固く人工的な印象となってしまうので、天端工や天端保護工は法肩に丸みを持たせたり、植生により法肩部と高水敷の境界線を曖昧にする等、景観面の工夫が必要である。

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  低水護岸が流水により裏側から侵食されることを防止するため、必要に応じて天端工・天端保護工を設けるものとする。天端工及び天端保護工は、流体力の作用に対して安全な構造となるように設計することを基本とする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

天端工の幅は1～2m程度、天端保護工の幅は1.5～2m程度で設置されている事例が多いが、明らかに低水路部からの流れの乗上げ位置となっている場所等、河道の特性に応じて適切な幅を確保することが望ましい。

護岸天端部分に作用する流速が1～2m/s程度を超える場合には、洗掘が生じる可能性が高いため、天端保護工を設置することが望ましい。

＜参考となる資料＞

> 天端工、天端保護工の設計については、下記の資料が参考となる。

1)  [改訂
    > 護岸の力学設計法](https://www.jice.or.jp/tech/material/detail/21),
    > 令和 5 年 10 月,（一財）国土技術研究センター.

```{=html}
<!-- -->
```
46) 護岸・水制の計画・設計，平成15年6月,（株）山海堂.

**②すり付け工**

＜考え方＞

すり付け工には、護岸上下流で侵食が生じた際に、侵食の影響を吸収して護岸が上下流から破壊されることを防ぐ機能がある。また、粗度が小さい本護岸で生じる速い流れが直接下流側河岸に当たらないように、粗度の大きなすり付け工部で流速を緩和し、下流河岸の侵食を発生しにくくする機能もある。このような機能を満足するため、すり付け工は屈とう性があり、ある程度粗度の大きな工種を用いることが望ましい。
　　　

すり付け工の施工幅は、その機能から最低限のり覆工及び天端工の範囲をカバーする必要がある。また、のり尻の侵食を防止できるよう河床面に適切な幅の垂らし幅を確保する必要がある。施工延長は既往事例からはおおむね5m以上となっているものが多いが、河道の特性等に応じた適切な施工延長を検討することが望ましい。

すり付け工は上流の侵食に伴い、流体力によってめくれ上がり、破壊する事例が多く、特に、急流河川のすり付け工に被災事例が多く見られるため、この点についても考慮する必要がある。

すり付け工の控え厚は、すり付け端部において流水の作用により生ずるめくれを考慮して安全な厚さとなるように設計する必要があるが、控え厚が大きくなり経済的でない場合は、めくれないような工夫
（上流先端部の地中への埋込み等）をすることが望ましい。

![ダイアグラム, 設計図
自動的に生成された説明](media/image20.png){width="6.172531714785652in"
height="2.4833333333333334in"}

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------
  護岸上下流端部に設けるすり付け工は、上下流端で河岸侵食が発生しても本体に影響が及ばないような構造とするものとする。
  --------------------------------------------------------------------------------------------------------------------

＜参考となる資料＞

> すり付け工の設計については、下記の資料が参考となる。

1)  [改訂
    > 護岸の力学設計法](https://www.jice.or.jp/tech/material/detail/21),
    > 令和 5 年 10 月,（一財）国土技術研究センター.

```{=html}
<!-- -->
```
47) 護岸・水制の計画・設計，平成15年6月,（株）山海堂.

    1.  []{#_Toc130309129 .anchor}水制の基本的な構造

＜考え方＞

護岸及び水制は、「4.3設計の基本」までに示したとおり、堤防の保護等、低水路河岸の侵食や洗掘の抑制、河川環境や景観の保全・創出、航路維持等、求める機能を有するように設計するとともに、対象河川の河道特性等を踏まえ、構造物の耐久性、維持管理の容易性、施工性、経済性及び公衆の利用の容易性等を総合的に考慮し、施設を単独あるいは組み合わせて、周辺の河道への影響に十分配慮して設計することが重要である。

「4.5水制の基本的な構造」では、このうち水制の設計及び照査の基本的な考え方を示す。

1.  []{#_Toc130309130 .anchor}構造形式の設定

＜考え方＞

水制の構造形式は透過水制と不透過水制がある。構造形式の選定に当たっては、構造物の耐久性、維持管理の容易性、施工性、経済性、及び環境・景観との調和等に考慮して設定する必要がある。透過水制は流水が透過する構造のもので、水制が粗度要素となって流速を減じて洗掘を防いだり、適切に配置すれば土砂を堆積させる効果をもつ。不透過水制は流水を透過させないもので、水制上を越流するかしないかで越流水制と非越流水制に分けられる。不透過水制は水はね効果が大きいが、水制先端部や水制の下流部が特に洗掘されやすいので、水制周辺に根固工を設置する必要があることが多い。

水制の設計に当たっては、設置目的、設置箇所の河道特性、外力条件、洪水特性などさまざまな要因が関係する。水制はそれらの要因を考慮して、類似河川や近隣区間での実績を参考にしながら、設置目的に適し、かつ計画高水位（高潮区間にあっては計画高潮位）以下の水位の流水の通常の作用に対して堤防を保護する、あるいは掘込河道にあっては堤内地を安全に防護する構造とするよう設計する。水制はその周辺に多様な水環境を形成し、良好な河川環境の保全・創出、良好な景観への改善・創出に効果を有するので、この効果を十分活かすよう構造や配置、材質を検討して設計する必要がある。

> 水制の働きに対応して、次のような構造の水制が選ばれる 。

１）流速減少を目的とするもの

ａ）水制の高さは低い。

ｂ）透過性あるいは水深に比し低い不透過性水制である。

ｃ）杭工**等**が主で軽い工作物になっている。

ｄ）数本ないし数十本が並置され、それが全体として作用する。

２）水はねを目的とするもの

ａ）水制の高さは高い。

ｂ）半透過性または不透過性である。

ｃ）土石、コンクリート**等**が主で容量が大きく、重い構造物になっている。

ｄ）単独あるいは少数並置される。

![](media/image21.emf){width="2.9444444444444446in"
height="1.5673611111111112in"}![](media/image22.emf){width="3.0277777777777777in"
height="1.4965277777777777in"}

＜標　準＞

+----------------------------------------------------------------------+
| 水制の構造型式は、透過水制と不透過水制がある。構                     |
| 造型式の選定に当たっては、構造物の耐久性、維持管理の容易性、施工性、 |
| 経済性、及び環境・景観との調和等を考慮して設定することを基本とする。 |
|                                                                      |
| 水制の工種は、河川の平面及び縦横断形状、流量、水位、河床             |
| 材料、河床変動等をよく検討し、目的に応じて選定することを基本とする。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1)  河川管理施設等構造令，昭和51年7 月20 日, 政令第199 号.

```{=html}
<!-- -->
```
48) 河川砂防技術基準施設配置等計画編，平成30 年3
    > 月,国土交通省水管理国土保全局.

> （最新版）河川砂防技術基準　施設配置等計画編,令和7年6月，国土交通省水管理・国土保全局.

49) [[美しい山河を守る災害復旧基本方針]{.underline}](https://www.mlit.go.jp/river/shishin_guideline/bousai/saigai/measures-saigai/pdf/10.pdf)(平成30年6月),2018,国土交通省水管理・国土保全局防災課.

50) [[河川景観ガイドライン「河川景観の形成と保全の考え方」]{.underline}](https://www.mlit.go.jp/river/shishin_guideline/kankyo/riverscape/index.html)(平成18年10月),
    > 国土交通省河川局 河川環境課,治水課,防災課.

51) [[「多自然川づくり」の推進について]{.underline}](https://www.mlit.go.jp/notice/noticedata/pdf/200704/00004847.pdf)，平成
    > 18 年 10 月 13 日，国河環第 38 号，国河治第 86 号，国河防第 370
    > 号，国土交通省河川局長通達.

> （最新版）多自然川づくり基本方針，令和6年6月，国土交通省水管理・国土保全局.

52) [[国土政策技術総合研究所資料，景観デザイン規範事例集（河川・海岸・港湾編）]{.underline}](http://www.nilim.go.jp/lab/ddg/seika/ks/ks0434.pdf)，平成
    > 20 年 3 月．

53) [[中小河川に関する河道計画の技術基準について]{.underline}](https://www.mlit.go.jp/river/kankyo/main/kankyou/tashizen/pdf/gijyutsukijyun.pdf)
    > ，平成 22 年 8 月 9 日，国河環第 30 号，国河域第 7 号，国河防第
    > 174 号，国土交通省河川局河川環境課長，治水課長，防災課長通達.

＜参考となる資料＞

> 水制の構造形式の設定については、下記の資料が参考となる。

1)  護岸・水制の計画・設計,平成15年6月, （株）山海堂.

2)  水理公式集，平成31年3月,（公社）土木学会.

> 環境や景観に配慮した設計については、下記の資料が参考となる。

3)  多自然川づくりポイントブックⅢ，平成23年10月,（財）リバーフロント整備センター.

```{=html}
<!-- -->
```
2.  []{#_Toc130309131 .anchor}材質と工種

    1.  []{#_Toc130309132 .anchor}使用材料

＜考え方＞

水制の使用材料は、設置目的に応じて要求される強度や耐久性を満足する必要がある。

水制材料として使用される玉石、割石、コンクリート異形ブロック等は、水制の機能を保持しうるように、流水の作用によりその位置、形状が大きく変わってはならない。すなわち、水制を構成する材料は、流水に対して移動しないだけの重さ、大きさ、形状である必要がある。

良好な河川環境の保全•
創出のための水制に、材料として木材を用いる場合には、水面付近の木材が腐りやすい点に十分に留意して設計する必要がある。また、多孔質な材料（石材、篭工）を用いる等の工夫をすることが考えられる。

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------
  水制の使用材料は、設置目的に応じて要求される強度や、耐久性等の性能を満足するための品質を有し、その性状が明らかにされているものを使用することを基本とする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------

＜参考となる資料＞

> 水制の使用材料については、下記の資料が参考となる。

1)  護岸・水制の計画・設計，平成15年6月,（株）山海堂.

2)  [改訂
    護岸の力学設計法](https://www.jice.or.jp/tech/material/detail/21),
    令和 5 年 10 月,（一財）国土技術研究センター.

    1.  []{#_Toc130309133 .anchor}主な工種

＜考え方＞

水制の主な工種としては、以下があげられる。

1.  コンクリートブロック、石材、四基構、三基構、大聖牛

2.  三角枠、ポスト、枠出し、篭出し、棚牛、笈牛、菱牛、川倉

3.  木工沈床、改良沈床、合掌枠、ケレップ、杭打ち上置工、杖（杭）出

一般的にはこの順序で急流河川から緩流河川に使用されている。水制は、杭としての抵抗によるものと水制自体の自重により流水に抵抗するものとに大別されるが、緩流河川では杭出水制が多く用いられ、急流河川では水制の強度の面から、また、河床材料の粒度が大きくなって杭打が不可能になることから、河床上に設置して自重で流水に抵抗するようなブロック水制あるいは聖牛が多く用いられる。

水制の設計に当たっては、被災形態の把握が重要であるため、既往の被災事例を調査し、被災部位別のおもな被災原因や水制構造ごとの被災形態の特徴について十分に把握する必要がある。被災形態の把握に当たっては、適切かつ具体的な目的設定に基づく災害調査等から得られた知見を蓄積し、河川等の計画、設計及び維持管理等のための技術情報として共有化できるようにすることが重要である（調査編第10章災害調査参照）。

![](media/image23.emf){width="2.5118055555555556in"
height="1.4166666666666667in"}

![](media/image24.emf){width="3.3979166666666667in"
height="1.0694444444444444in"}![](media/image25.emf){width="2.557638888888889in"
height="0.9513888888888888in"}

![](media/image26.emf){width="3.1569444444444446in"
height="1.2368055555555555in"}

![](media/image25.emf){width="2.557638888888889in"
height="0.9513888888888888in"}

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  水制は、計画高水位（高潮区間にあっては計画高潮位）以下の水位の流水の通常の作用に対して、目的とする機能を確保し、所要の安全性を確保できる構造となるように設計することを基本とする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜参考となる資料＞

> 水制の主な工種については、下記の資料が参考となる。

1)  護岸・水制の計画・設計，平成15年6月,（株）山海堂.

2)  災害復旧工事の設計要領,令和4年8月,（公財）全国防災協会.

> （最新版）災害復旧工事の設計要領,令和6年8月,（公財）全国防災協会.

3.  []{#_Toc130309134 .anchor}安全性能の照査等

＜考え方＞

水制の設計に当たっては、水制の工種ごとに、洪水時等の安全性能を確保することが求められる。照査に当たっては、基礎地盤の特性、河道の特性、維持管理に必要となる前提条件等を土質地質調査や河道特性調査等に基づき設定する必要がある。また、これまでの経験及び実績から妥当とみなせる方法又は論理的に妥当性を有する方法等、適切な知見に基づく手法を用いることを基本とする。

水制の被災は、水制に作用する流体力によって、水制を構成する材料が滑動・転動、あるいは流出することによって生じる。設計の対象とする作用は、計画高水位以下の水位の流水の通常の作用による流体力と自重が対象になると考えられ、水制を構成する材料が安全であるよう照査を行う。

その他必要に応じて、河床変動、載荷重、波浪や風浪、津波、航走波、副振動（セイシュ）、アイスジャム、流砂・礫の衝突による摩耗・破損、土石流等の影響を考慮するものとする。

なお、施工条件の影響により、施工時荷重についても考慮が必要となる場合がある。

＜標　準＞

+----------------------------------------------------------------------+
| 水制の                                                               |
| 安全性能の照査に当たっては、次の表から設計の対象として必要とされる状 |
| 況と作用を設定し、これを踏まえて照査事項を設定することを基本とする。 |
|                                                                      |
| **表1-4-5　水制の設計の対象とする状況と作用**                        |
|                                                                      |
|   水制の状況   作用                                                  |
|   ------------ ----------------------                                |
| -------------------------------------------------------------------- |
|   洪水時       計画高水位（高潮区間                                  |
| にあっては計画高潮位）以下の水位の流水の通常の作用による流体力、自重 |
|                                                                      |
| > ※河床変動、土圧、水圧、揚圧力、載荷重、波浪や風浪                  |
| 、津波、航走波、副振動（セイシュ）、アイスジャム、流砂・礫・流木の衝 |
| 突による摩耗・破損、土石流、施工時荷重、地震時土圧、地震時動水圧、地 |
| 震時慣性力等の影響を受ける場合には、必要に応じて考慮するものとする。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

水制の安全性能の照査等については、下記の資料が参考となる。

1)  護岸・水制の計画・設計，平成15年6月,（株）山海堂.

```{=html}
<!-- -->
```
54) [改訂
    > 護岸の力学設計法](https://www.jice.or.jp/tech/material/detail/21),
    > 令和 5 年 10 月,（一財）国土技術研究センター.

55) 水理公式集，平成31年3月,（公社）土木学会.

```{=html}
<!-- -->
```
4.  []{#_Toc130309135 .anchor}各部位の設計

```{=html}
<!-- -->
```
1.  []{#_Toc130309136 .anchor}水制

＜考え方＞

水制は、堤防及び河岸を洪水時の侵食作用に対して保護することを主たる目的として設置されるものであるが、良好な河川環境の保全・創出、良好な景観への改善・創出、航路維持のために設けられることもある。

水制の設計に当たっては、設置目的、設置箇所の河道特性、外力条件、洪水特性等さまざまな要因が関係する。水制はそれらの要因を考慮して、類似河川や近隣区間での実績を参考にしながら、設置目的に適し、かつ計画高水位以下の水位の流水の通常の作用に対して、堤防を保護する、あるいは掘込河道にあっては堤内地を安全に防護する構造とするよう設計する。

水制の安全性に関する検討事項は護岸とほぼ同様であるが、水制は護岸以上に理論上の解釈を与えて設計することが難しく、過去の経験、類似河川の実績、あるいは新しい工種に関しての試験施工、模型実験、調査研究の成果等を利用して、施工性、経済性、維持管理や河川利用者の安全面にも配慮して設計する。水制の力学的な安定を理論的に設計することの難しい大きな理由は、河道は変化が大きく水制設置場の種々の特性（例えば洪水時の河床高、流速）を的確に予測することが難しく、さらに水制設置によってそれらが変化するので予測がより困難であることにある。したがってより合理的な水制の設計を行うためには、以下の事項に留意して水制設置場の種々の特性と水制の水理について十分に検討し、必要に応じて施工後の経緯を踏まえつつ改良を図るものとする。

1.  水制回りの局所洗掘

> 水制は河道内に設置され、流れに対して障害物となって河岸寄りの流速を低下させ、また、水をはねるものである。このことは、水制頭部に流水を集中させることになり、水制回りに洗掘が生じる。この洗掘は水制頭部の水深を確保する機能となる一方で、水制の破損原因となるので、水制回りの洗掘深がどの程度になるのか、洗掘範囲がどの程度であるのかを前もって評価しておくことが必要である。

2.  水制による流速低減効果

> 水制による流速低減効果は、水制群を、①相当粗度として評価する方法、②水制に働く抗力を算定して評価する方法がある。水制群による河川沿いの流速低減効果は、基本的にはこの考え方に従って評価しうるが、次のような課題がある。
>
> ａ）
> 種々の形状の水制に対して、実験的な検討が行われておらず、水制形状が複雑なものは、理論中に含まれる種々の係数を実験により求める必要がある。
>
> ｂ）水制域内と主流部との境界付近の流速の評価方法が不明確である。
>
> ｃ）水制の効果は、水制域の平均流速で評価しうるものでなく、水制群内での土砂の働きとの関連性で評価されるべきであるが、この関係が明確となっていない。

3.  水制域内への土砂の堆積条件

> 水制の設置に伴い、水制域間の土砂堆積現象が発生する場合があるため、その効果と影響について把握する必要がある。この場合、水制域内に堆積する材料によって土砂の輸送形式が異なるので、土砂の粒径集団ごと（調査編第4章河道特性調査参照）にその土砂の堆積
> ・侵食量を評価する必要がある 。

4.  水制材料の移動限界流速

> 水制材料として使用される玉石、割石、コンクリート異形ブロック等は、水制の機能を保持しうるように、流水の作用によりその位置、形状が大きく変わってはならない。すなわち、水制を構成する材料は、流水に対して移動しないだけの重さ、大きさ
> 、形状である必要がある。

5.  水制と河岸線

> 水制の高さが高く、土砂が水制間に堆積し高水敷化した場合、あるいは水制間の河床を人為的に埋め立てて高水敷化した場合には、水制間の河岸線の変化を検討しておく必要がある
> 。

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  水制は、計画高水位（高潮区間にあっては計画高潮位）以下の水位の流水の通常の作用に対して堤防を保護する、あるいは掘込河道にあっては堤内地を安全に防護できる構造とするよう良好な河川環境の保全・整備に十分留意しつつ、過去の経験・類似河川の実績、あるいは試験施工・模型実験の成果等を基にし、施工性、経済性等を考慮して設計し、必要に応じて施工後の経緯を踏まえて改良することを基本とする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜参考となる資料＞

水制の設計については、下記の資料が参考となる。

1)  護岸・水制の計画・設計，平成15年6月,（株）山海堂.

2)  [改訂
    護岸の力学設計法](https://www.jice.or.jp/tech/material/detail/21),
    令和 5 年 10 月,（一財）国土技術研究センター.

3)  水理公式集，平成31年3月,（公社）土木学会.

```{=html}
<!-- -->
```
2.  []{#_Toc130309137 .anchor}方向

＜考え方＞

水制の方向としては流向に対して上向き、直角、下向きの方向があるが、過去の実績等において砂河川で用いられた航路用の水制及び根固水制は10～15度程度上向きに向けられたものが多かった。これは水制元付け下流の洗掘軽減、水制間における土砂堆積のためには上向きの方が好ましいとされたためである。

水制高の低い根固水制あるいは不透過水制については経済性の観点から、また土砂を積極的に堆積させなければならないというものでもないので、水制の方向は直角でよいと判断される。

セグメント1（扇状地河川）で特に急流の河川では、不透過水制あるいは半透過水制の水はね水制を設置し、水衝部を河岸から離す計画がなされることがある。この場合は水制先端部の局所洗掘を軽減するために下向きに水制を設置するのが普通である。

セグメント2-2に設置される水はね水制では、河岸に直で良いと考えられるが、多少上向きにすると、水制を越流する流水による水制元付け下流側の洗掘軽減、水制間の土砂堆積を促進する作用がある。

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------
  水制の方向は、流向に対して上向き、直角、下向きの方向があるが、その設置目的、河川の状況等により個々に定めるものとする。
  ------------------------------------------------------------------------------------------------------------------------

＜参考となる資料＞

水制の方向については、下記の資料が参考となる。

1)  護岸・水制の計画・設計，平成15年6月,（株）山海堂.

```{=html}
<!-- -->
```
56) 水理公式集，平成31年3月,（公社）土木学会.

```{=html}
<!-- -->
```
3.  []{#_Toc130309138 .anchor}長さ、高さ及び間隔等

＜考え方＞

水制の長さ、高さ及び間隔は、河道の状況、水制の設置目的、上下流及び対岸への影響、構造物自身の安全を考慮して、文献や過去の事例等も参考にして定めるものとする。

1.  河岸侵食防止のための根固水制

> 一般に強固な単独水制で流れに抵抗させるのは、水流の乱れを大きくし、水制付近に大きな洗掘を招くことが多く、また水制自身の維持も容易でない。したがって、一定区間にわたる水制群としての総合的な効果により流速を低減させ、かつ各水制が平等に抵抗力を発揮するよう、構造、配列を定める必要がある。これらの観点から水制の長さも上流側を短くし、上流の水制の水勢に対する負担を軽くする例もある。
>
> このため、一般に水制はあまり長く出さないで水制と護岸を併設するのが維持管理上からも工費的にも経済的となる場合が多い。
>
> また、水制は河岸付近の流速を減ずることから流下能力に影響を及ぼすことがあるので、特に長い水制を設置する場合には水制の長さ、高さを考慮して河道計画を検討する必要がある。なお、水制を用いず護岸根固工でも河岸侵食に対処しうるので、経済面、環境面、景観面など総合的に検討して水制設置の判断を行う必要がある
> 。

2.  河岸侵食防止のための水はね水制

> 高さが高く不透過である水制を設置する場合は、これを根固水制と位置づけるのではなく、水制先端線を結んだ線を河岸防御の防護線に位置づけて、侵食防止のための水制として位置づけるべきである。また、あまり長大な不透過水制を出すことは工事費の面で得策でない。

3.  航路維持のための水制

> 航路維持のための水制を設置する場合は、船の吃水深で規定される確保水深や、確保水深を得るために必要な川幅、船の運航に必要な航路幅を定める必要がある。水制の天端高は、水制設置後の確保水深を維持するために必要な流量時等の水位を基準にして設定し、水制の長さは、水制によって制御する水路幅に合わせた長さとすることが考えられる。水制の間隔については、水制の長さの1.5～2倍程度がよいとしている文献が多い。

4.  河川環境の保全・創出のための水制

> 生態系の保全・創出に役立つ水制の機能としては、①水の流れに変化を与えることにより、水中生物に多様な環境を作る、②洪水時の魚の避難空間を形成する、③河岸を自然河岸と同様な環境としうる、の3点が考えられる。この場合の設計の留意点は次のようである。
>
> ａ）水制の材料として木材を用いる場合には、水面付近の木材が腐りやすい点に十分に留意して設計する。
>
> ｂ）多孔質な材料（石材、篭工）を用いた水制を工夫する。
>
> ｃ）意図的に水制によってワンドを形成する場合は、ワンドが土砂により埋没しないようにする。
>
> ｄ）既存の護岸、根固め周辺の生態環境の改善を図るために水制を設置する場合には、護岸との取付部周辺で流体力が大きくなるので、護岸及びその周辺河岸の安全性に留意する。
>
> ｅ）工事終了後に水制周辺に生ずる土砂の堆積、侵食、植生状態の変化等を想定して設計する。この想定のためには、ほぼ同じような河道特性をもつセグメントでの事例調査が役立つ。

5.  景観の保全• 創出のための水制

> 景観の保全•
> 創出のための水制を設置する場合は、①水制が治水上の悪影響を与えないこと、②
> 水制工種が設置場所の河道景観、護岸と調和していること、③
> 水制だけでなく護岸、河岸植生等と一体として景観デザインすること、④
> 既存の水制を生かす工夫を行うこと、⑤
> 植生変化や土砂の堆積に関して検討し、適切な維持管理を行うことができるようにすること等に留意する必要がある。

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------
  水制の長さ、高さ及び間隔は、河道の状況、水制の目的、上下流及び対岸への影響、構造物自身の安全を考慮して定めるものとする。
  --------------------------------------------------------------------------------------------------------------------------

＜例　示＞

1.  河岸侵食防止のための根固水制

> 流速を減少させるために設置する水制の長さは川幅の10%以下、高さは計画高水流量が流れるときの水深の0.2～0.3倍程度、間隔は長さの2～4倍、高さの10～30倍にすることが多い。湾曲部の凹岸では水制の間隔は長さの2倍以下にすることが多い。
>
> また、砂河川での水制の高さは元付け付近で平水位上0.5～1.0ｍ程度とし、河心に向かって1/20～1/100の下り勾配をつけるのが一般的である。急流部では高い水制を用いる傾向がある。

2.  河岸侵食防止のための水はね水制

> 扇状地河川で単断面河道に高さが高く不透過である水制を設置する場合は、水制の元付け部分の高さは計画高水位程度とし、水制を越流した流水が堤防護岸をたたかないようにする。なお、水制の前面の水位は、水制先端部の流水の流速水頭だけ水位が上昇するので、水制前後の堤防護岸は十分な高さまで練積み等の強固な護岸で保護しておく。
>
> この種の水制では、水制の間隔は当該区間に形成される砂州長さの1/2～1/3程度以下とする。この場合の水制の方向は、河岸に直か、多少下向きとする。

＜参考となる資料＞

水制の長さ、高さ及び間隔については、下記の資料が参考となる。

1)  護岸・水制の計画・設計，平成15年6月,（株）山海堂.

2)  日本の水制, 平成8年1月, （株）山海堂.

3)  水理公式集，平成31年3月,（公社）土木学会.

第1章　河川構造物の設計 {#第1章-河川構造物の設計-3 .目次の見出し1}
=======================

第6節　床止め {#第6節-床止め .目次の見出し1}
=============

目　次 {#目-次-2 .目次の見出し1}
======

[第6節 床止め 1](#_Toc100687254)

> [6．1 総説 1](#_Toc21616084)
>
> [6．1．1 適用範囲 1](#_Toc19105048)
>
> [6．1．2 用語の定義 1](#_Toc19105049)
>
> [6．2 機能 2](#_Toc21616087)
>
> [6．3 設計の基本 3](#_Toc21616088)
>
> [6．4 基本的な構造 7](#_Toc85298178)
>
> [6．4．1 構造型式の設定 7](#_Toc85298180)
>
> [6．4．2 材質と構造 8](#_Toc85298181)
>
> [6．5 安全性能の照査等 13](#_Toc85298182)
>
> [6．5．1 設計の対象とする状況と作用 13](#_Toc85298183)
>
> [6．5．2 安全性能の照査 16](#_Toc85298184)
>
> [6．5．3 許容応力度 20](#_Toc85298185)
>
> [6．6 各部位の設計等 22](#_Toc85298186)
>
> [6．6．1 本体 22](#_Toc85298187)
>
> [6．6．2 水叩き 25](#_Toc85298190)
>
> [6．6．3 護床工 27](#_Toc85298191)
>
> [6．6．4 基礎 30](#_Toc85298192)
>
> [6．6．5 遮水工 30](#_Toc85298193)
>
> [6．6．6 取付擁壁・護岸 32](#_Toc85298194)
>
> [6．6．7 高水敷保護工・のり肩工 34](#_Toc85298195)
>
> [6．6．8 魚道 35](#_Toc85298196)
>
> [6．7 床止め構造に関するその他事項 36](#_Toc85298197)

令和４年６月　版

適用上の位置付け

　河川砂防技術基準設計編は、基準の適用上の位置付けを明確にするために、下表に示すように適用上の位置付けを分類している。

+--------+------------------+------------------+------------------+
| 分　類 | 適用上の位置付け | 末尾の字句例     |                  |
+--------+------------------+------------------+------------------+
| 考え方 | 技術資料         | ●目              | 「･･･ある。      |
|        |                  | 的や概念、考え方 | 」「･･･いる。」  |
|        |                  | を記述した事項。 |                  |
|        |                  |                  | 「･･･なる。      |
|        |                  |                  | 」「･･･れる。」  |
+--------+------------------+------------------+------------------+
| 必　須 | 技術基準         | ●法令による規定  | 「･･･なければ    |
|        |                  | や技術的観点から | ならない。」「･  |
|        |                  | 実施すべきである | ･･ものとする。」 |
|        |                  | ことが明確であり |                  |
|        |                  | 遵守すべき事項。 |                  |
+--------+------------------+------------------+------------------+
| 標　準 | 技術基準         | ●特              | 「･･･            |
|        |                  | 段の事情がない限 | を標準とする。」 |
|        |                  | り記述に従い実施 |                  |
|        |                  | すべきだが、状況 | 「･･･            |
|        |                  | や条件によって一 | を基本とする。」 |
|        |                  | 律に適用すること |                  |
|        |                  | はできない事項。 | 「･･･による。」  |
+--------+------------------+------------------+------------------+
| 推　奨 | 技術資料         | ●状況や条件      | 「               |
|        |                  | によって実施する | ･･･望ましい。」  |
|        |                  | ことが良い事項。 |                  |
|        |                  |                  | 「               |
|        |                  |                  | ･･･推奨する。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･務める。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･必要に応    |
|        |                  |                  | じて･･･する。」  |
+--------+------------------+------------------+------------------+
| 例　示 | 技術資料         | ●適用条件や実施  | 「               |
|        |                  | 効果について確定 | ･･･などの手法（  |
|        |                  | している段階では | 事例）がある。」 |
|        |                  | ないが、状況や条 |                  |
|        |                  | 件によっては導入 | 「･･･など        |
|        |                  | することが可能な | の場合がある。」 |
|        |                  | 新技術等の例示。 |                  |
|        |                  |                  | 「･･･など        |
|        |                  | ●状              | が考えられる。」 |
|        |                  | 況や条件によって |                  |
|        |                  | 限定的に実施でき | 「               |
|        |                  | る技術等の例示。 | ･･･の場合には･･･ |
|        |                  |                  | ことができる。」 |
|        |                  | ●具体的          |                  |
|        |                  | に例示することに | 「               |
|        |                  | より、技術的な理 | ･･･例示する。」  |
|        |                  | 解を助ける事項。 |                  |
|        |                  |                  | 「例えば･･･。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･事例もある  |
|        |                  |                  | 。･･･もよい。」  |
+--------+------------------+------------------+------------------+

  関連通知等       関連する通知やそれを理解する上で参考となる資料
  ---------------- ------------------------------------------------------
  参考となる資料   例示等に示した手法・内容を理解する上で参考となる資料

6.  []{#_Toc100687254 .anchor}床止め

    1.  []{#_Toc21616084 .anchor}総説

        1.  []{#_Toc19105048 .anchor}適用範囲

＜考え方＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  本節は、床止めを新設あるいは改築する場合の設計に適用する。ただし、既設の床止めの安全性能の照査にも構造形式や現地の状況等に応じ準用することができる。流水の作用により河床が侵食・低下すると、護岸等の基礎が浮き上がり、治水上危険な状態になるとともに、各種用水の取り入れが困難になる等の障害が生ずる。床止めは、この様な場合に河床を適切な高さに維持するとともに、二極化を防ぐなど、河床を安定させる目的のために河道を横断して設置する。床止めには落差のあるものとないものがあり、落差のあるものを落差工、落差のないものを帯工というが、本節でいう床止めは主に落差工を指している。帯工については、本節に加え、関連通知や参考となる資料等を参照されたい。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

  ------------------------------------------------------------
  本節は、床止めを新設あるいは改築する場合の設計に適用する。
  ------------------------------------------------------------

＜関連通知等＞

1.  河川管理施設等構造令，昭和 51 年 7 月 20 日，政令第199号．

＜参考となる資料＞

帯工の設計に当たっては、下記の資料が参考となる。

1.  床止めの構造設計手引き,平成10年12月,（財）国土技術研究センター．

    1.  []{#_Toc19105049 .anchor}用語の定義

＜考え方＞

+----------------------------------------------------------------------+
| 床止めは、本体、水叩き、護床工、基                                   |
| 礎、遮水工、取付擁壁・護岸、高水敷保護工・のり肩工及び魚道等の各部位 |
| から構成される。床止めの本体には、一般にコンクリート構造のものと、根 |
| 固ブロック等を用いて屈とう性をもたせた構造のものがあるが、本節では、 |
| 設置事例が多く一般的な構造であるコンクリート構造について示している。 |
|                                                                      |
| 床止めの各部位の名称は図6-1による。                                  |
+----------------------------------------------------------------------+

![](media/image27.png){width="4.724409448818897in"
height="4.77992125984252in"}

3.  床止めの各部位の名称（コンクリート構造の場合）

＜標　準＞

+----------------------------------------------------------------------+
| 次の各号に掲げる用語の定義は、それぞれ以下に示す。                   |
|                                                                      |
| 1.  屈とう性                                                         |
| 構造：本体にコンクリートブロックなどの屈とう性のある材料を用いた構造 |
|                                                                      |
| 2.  直壁型：本体下流ののり勾配が1:0.5より急な型式                    |
|                                                                      |
| 3.  緩傾斜型：本体下流のの                                           |
| り勾配を1:10程度より緩くし、落差をある程度の延長をもって処理する型式 |
+----------------------------------------------------------------------+

[]{#_Toc21616087 .anchor}

1.  機能

＜考え方＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  河川においては、流水の作用によって河床が洗掘され低下すると、護岸等の施設の基礎が浮き上がり、治水上危険な状態になる等の問題が生じる場合がある。このような場合に備え、床止めには河床低下を防止して河川管理上必要な高さを維持し、河床を安定させる機能が求められる。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜必　須＞

  ------------------------------------------------------------------------------------------------
  床止めは、河川管理上必要な高さに河床を維持し、安定させる機能を有するように設計するものとする。
  ------------------------------------------------------------------------------------------------

＜関連通知等＞

1.  河川管理施設等構造令，昭和 51 年 7 月 20 日，政令第199号．

    1.  []{#_Toc21616088 .anchor}設計の基本

＜考え方＞

+----------------------------------------------------------------------+
| 床止めの設計に当                                                     |
| たっては、以下の事項について検討し、設計に反映することが求められる。 |
|                                                                      |
| １）基本方針                                                         |
|                                                                      |
| 床止めの設計に当たっては、「6.2機能」に示す事項を満足するとと        |
| もに、想定される外力に対して安全な構造となるよう設計する必要がある。 |
|                                                                      |
| 床止めは、河川を横断して設ける施設であることから、床止めに接続する   |
| 高水敷や堤防の洗掘の防止について適切に配慮された構造とし、床止め周辺 |
| の堤防が一連区間の中で相対的な弱点とならないよう、設計する必要がある |
| 。また、床止めは河床高を固定することから、予め、これまでの河川整備と |
| 洪水等による長期的な河道の応答を分析し、床止めの新設又は改築による効 |
| 果や影響が河道の変化にどのように顕れるかを考慮のうえ、位置や平面形状 |
| 、方向、縦断形状及び横断形状等の施設の設置条件を検討する必要がある。 |
|                                                                      |
| なお、河                                                             |
| 川改修などにより、床止めなどの河道内の構造物を改築し、旧施設を撤去す |
| る場合には、周辺の堤防、河床や河岸及びその他の河川管理施設等への影響 |
| が生じることも想定される。このため、長期的な河道の応答を分析したうえ |
| で、一部施設の残置や撤去方法など必要な対策工等を検討する必要がある。 |
|                                                                      |
| 床止めの位置や天端高につい                                           |
| ては河道計画で概略設定しているが、床止め設置後の将来的な河床変動を考 |
| 慮して、位置や天端高を必要に応じて見直す。特に、床止め設置後の河床変 |
| 動が激しく、安定しないことが想定される場合には河道計画を見直すことも |
| 考えられる。河道計画を見直した場合には、床止め設置後の河床変動特性を |
| 再度確認し、河道の維持管理に支障が生じないことを確認する必要がある。 |
|                                                                      |
| 河川整備においては、河川法の目的である河川環境の整備                 |
| と保全の観点から、河川が本来有している自然環境や多様な景観の保全・創 |
| 出が図られることが基本であることから、床止めの設計に当たっては、生物 |
| の生息・生育の環境や水辺環境、周辺の景観等との調和を図る必要がある。 |
|                                                                      |
| 床止めは、一般に、床止め上下流                                       |
| で落差を生じたり、床止め本体上で浅い水深の流れを生じるため、魚類の遡 |
| 上等を妨げることがないよう、構造令第35条の２の規定に従って魚道を設置 |
| したり、床止め本体を緩斜型の構造とするなどの対策を講じる必要がある。 |
|                                                                      |
| ２）天端高と落差                                                     |
|                                                                      |
| 床止めの天端高は、河道計画における河道の縦断形の検討により決定され   |
| る設計・管理の目安となる河床高等（計画横断形の河床に係る部分をいう） |
| と一致させる必要がある。また、床止めの落差については、小さい落差より |
| 大きな落差の方が床止め下流で跳水による確実な減勢が期待できるが、一方 |
| で魚類の遡上等の妨げとなることや、洗掘の危険性が増大するなどの課題も |
| 生じる。したがって、床止めの落差は１～２m程度以内とする必要がある。  |
|                                                                      |
| 床止めの天端高と落差の                                               |
| 設定に当たっては、設置後の将来的な河床変動量を把握し、設計・管理の目 |
| 安となる河床高を維持できるか確認する必要がある。河床変動量予測の結果 |
| 、設計・管理の目安となる河床高等を維持できないと判断される場合には、 |
| 以下の対策が必要となり、河道計画の見直しも含めて検討する必要がある。 |
|                                                                      |
| ・床止めの位置、落差高を変更する                                     |
|                                                                      |
| ・護岸や橋脚基礎等の構造物において必要な対策を実施する。             |
|                                                                      |
| 河床変動量予測を行う                                                 |
| 際には、比較的変動量の小さい平水時と中小洪水を中心とした経年的な予測 |
| に加え、短期的に変動量が大きい洪水時の状況も把握しておく必要がある。 |
|                                                                      |
| ３）床止めの位置                                                     |
|                                                                      |
| 床止めの位置は、「計画編 施設配置等計画編 第2章 河川施設配置計画     |
| 第2-1章 河道並びに河川構造物 第1節 河道計画 1.6.5                    |
| 床                                                                   |
| 止めの計画」を踏まえ、河道の平面形状や床止めを設置したことによる流況 |
| の変化等を検討して決定する必要がある。設置後の流況変化という観点から |
| 望ましいと考えられる設置箇所の留意点を整理すると以下のとおりである。 |
|                                                                      |
| ![](media/image28.png){width="3.138888888888889in"                   |
| height="2.286111111111111in"}                                        |
|                                                                      |
| 4.  砂州の移動がある場合に設置が望ましい場所                         |
|                                                                      |
| > ①床止めの安定性は、設置後の河床形状に大きく影響を受ける            |
| ため、床止めの上下流で大きな河床洗掘が生じにくい直線河道に設置する。 |
| >                                                                    |
| > ②蛇行度が                                                          |
| ある程度あり砂州の移動が生じる場合は、図6-2に示すような横断形状がほ  |
| ぼ矩形断面となる地点に設置する。矩形断面の位置は低水路の法線形状や砂 |
| 州の形成条件によって変わるので、横断測量結果よりその位置を判断する。 |
| >                                                                    |
| > ③堤防法線と低水路法線が平行な箇所                                  |
| は、偏流等が生じることが少ないため、そのような地点を選んで設置する。 |
| >                                                                    |
| > ④床止めは、洪水時に床止め付近の堤防や河岸での                      |
| 激しい流れを生じさせることがあるため、近傍に山つき箇所、堤内地盤高の |
| 高い箇所、掘り込み河道部等がある場合には、その地点を選んで設置する。 |
| >                                                                    |
| > ⑤合流点付近に床止めを設置する必要が                                |
| ある場合は、合流点の直近に設置するのではなく、やや上流へ設置し、洪水 |
| 時に発生した床止め下流の激しい流れが収まった後に合流するようにする。 |
|                                                                      |
| ４）平面形状及び方向                                                 |
|                                                                      |
| 床止めを                                                             |
| 流下する流水は、通常、床止めと直角の方向に流れるものであり、その平面 |
| 形状によっては、下流側の水衝作用を助長したり、局所洗掘の原因となるこ |
| とが多い。このような理由から、床止めの河川横断方向の線形は洪水流に対 |
| して直角とする。なお、主に中小河川において、下流部での局所洗掘、床止 |
| め付近での洪水流の著しい乱れ等による治水上の支障が生じるおそれがない |
| 場合は、図6-3に示すような折線型、曲線型の床止めとすることができる。  |
|                                                                      |
| ![](media/image29.png){width="5.127777777777778in"                   |
| height="1.3763888888888889in"}                                       |
|                                                                      |
| 5.  落差工の平面形状模式図                                           |
|                                                                      |
| ５）縦断形状                                                         |
|                                                                      |
| 床止め本体の縦断形状                                                 |
| としては、一般に直壁型が用いられている場合が多いが、流水の落下によっ |
| て生じると予測される騒音を防止する目的、また魚道の機能を持たせる目的 |
| で、本体の下流側ののり勾配を1：10程度より緩い緩傾斜型にする場合もあ  |
| る。ただし、落差が大きい緩傾斜型の場合には、緩い勾配にすると、流速の |
| 速い範囲が下流に広がるおそれがあり、構造物が相対的に大きくなることか |
| ら、経済的に見て不利になる場合が多く、さらに、河床の広い範囲をコンク |
| リート構造で覆うことになるので、環境・景観面からも配慮が必要である。 |
|                                                                      |
| ６）横断形状                                                         |
|                                                                      |
| 床止めの天端は、流水が1箇所に集中しないように水平とすることが一般    |
| 的である。ただし、魚道設置のために天端部に切欠きを設ける場合や水生生 |
| 物の遡上・降下のために天端形状をV字型にすることがある。この場合は、  |
| 流水の集中による河床変動や構造物の安全性について留意する必要がある。 |
|                                                                      |
| ７）端部の構造（嵌入、取付擁壁）                                     |
|                                                                      |
| 床止め本体の端部処理については、堤体に嵌                             |
| 入した場合、床止め本体と堤体との間で水みちが発生する危険性や、床止め |
| 本体が被災を受けた場合に、堤防にまで被災が及ぶ危険性がある。このため |
| 、床止め本体が被災しても堤防は安全であるように、床止め本体と堤防とは |
| 絶縁する必要がある。また、複断面河道では、樹木等の影響で高水敷上での |
| 流水が乱れることにより、高水敷と床止めの境界付近の洗掘を助長し、それ |
| が拡大することで堤防の決壊を引き起こす危険性があるため、これを防止す |
| ることを目的として図6-4に示すように床止め取付部の上下流を擁壁構造の  |
| 護岸とし、高水敷に保護工を設ける必要がある。特に、急流河川では、洪水 |
| 時に高水敷上での流速が速いほか、床止め下流で高水敷から低水路への落込 |
| 流により高水敷に侵食が生じやすい。これを防止するため、図6-5のように  |
| 床止め本体の両端を堤防表のり尻まで嵌入させ、堤防とは矢板で絶縁し、仮 |
| に床止めが被災しても堤防に影響が及ばないようにすることが必要である。 |
|                                                                      |
| なお、単断面で河床勾配が1/100程                                      |
| 度の急流の掘込河道の場合には、床止め本体を河岸等に嵌入させてもよい。 |
|                                                                      |
| ![](media/image30.png){width="0.43333333333333335in"                 |
| height="0.314                                                        |
| 5833333333333in"}![](media/image31.png){width="0.6118055555555556in" |
| height="0.2319                                                       |
| 4444444444445in"}![](media/image32.png){width="2.8270833333333334in" |
| height="1.3069444444444445in"}![テキスト が含まれている画像          |
| 自動                                                                 |
| 的に生成された説明](media/image33.png){width="3.1310334645669293in"  |
| height="1.2827001312335957in"}                                       |
|                                                                      |
| +----------------------------+--------------------------------+      |
| | 6.  取付擁壁＋高水敷保護工 | 7.  本体の堤防のり尻までの嵌入 |      |
| +----------------------------+--------------------------------+      |
|                                                                      |
| ８）安全、確実・円滑な施工                                           |
|                                                                      |
| 床止めの施工                                                         |
| では、掘削中のボイリングや重機の転倒など、安全を脅かす状況が発生する |
| 可能性がある。このため、設計においても、安全で確実・円滑な施工が可能 |
| となるような配慮が求められ、施工上の制約から構造が決まることもある。 |
|                                                                      |
| ９）機能を長期的に容易に維持できる構造                               |
|                                                                      |
| 長期的に機能を低下させる要因としては、部材等の経年劣                 |
| 化、流砂等による部材の摩耗、圧密による地盤変位の進行に伴う床止め本体 |
| の沈下、床止め上下流の河床変動や土砂堆積、床止め本体と護床工の下面、 |
| 護岸背面等における土砂の吸出し等があり、これらに配慮する必要がある。 |
|                                                                      |
| 10）維持管理に配慮した構造　　　　　　　                             |
|                                                                      |
| 床止めの点検、修繕、更新等の作業を容易に行うため、堤防や高水敷に     |
| 管理用通路や階段を設けるなど維持管理に配慮した構造にする必要がある。 |
+----------------------------------------------------------------------+

＜必　須＞

+----------------------------------------------------------------------+
| 床止めの設計に当たっては、以下の事項を反映するものとする。           |
|                                                                      |
| １）計画高水位（高潮区間にあっては、計画高潮位）以                   |
| 下の水位の流水の作用に対して安全な構造となるよう設計するものとする。 |
|                                                                      |
| ２）床止め周辺の堤防、河岸及びその他河川管理施                       |
| 設等の構造に著しい支障を及ぼさない構造となるよう設計するものとする。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 床止めの設計に当たっては、以下の事項を反映することを基本とする。     |
|                                                                      |
| １）床止めに                                                         |
| 求められる機能を満足するように床止めの位置、平面形状、方向、縦断又は |
| 横断形状及び端部の構造等を設定するとともに、設計の対象とする状況と作 |
| 用に応じた安全性能を設定し、照査によりこれを満足することを確認する。 |
|                                                                      |
| ２）床止めの天端の高さは、河道計画                                   |
| に基づき決定されるものであるが、設計・管理の目安となる河床高等（計画 |
| 横断形の河床に係わる部分をいう）と一致するよう設計する。なお、河床変 |
| 動の著しい河川では現況河床及び将来の変動を想定して定める必要がある。 |
|                                                                      |
| ３）床止め上下流の落差は、1～2m程度とする。                          |
|                                                                      |
| ４）環境及び景観との調和、構造                                       |
| 物の耐久性、維持管理の容易性、施工性及び経済性等を総合的に考慮する。 |
|                                                                      |
| ５）土質・地質調査、河道特性や自然環境等を                           |
| 把握するため現地条件や設置目的に応じて必要な調査を計画して実施する。 |
+----------------------------------------------------------------------+

＜推　奨＞

+----------------------------------------------------------------------+
| 事前の地盤調査                                                       |
| は、土層構成、土質、地下水の状況などを把握し、設計に必要な地盤性状及 |
| び土層の特性等の条件を設定するため、ボーリング調査・原位置試験及び室 |
| 内土質試験の組合せで実施することが望ましい。なお、事前の地盤調査結果 |
| より軟弱地盤や透水性地盤が想定される場合には、各々の課題に対応した原 |
| 位置試験等の調査・試験を実施したうえで設計に反映することが望ましい。 |
|                                                                      |
| また、環境面では、護岸のブロックに適度な                             |
| 空隙や粗度を発生させ水生生物の生息や移動（生態系ネットワーク）等に支 |
| 障が生じないように工夫した設計を、景観面では、コンクリートブロックの |
| 明度（護岸の明度は６以下を目安）やテクスチャー(輝度の標準偏差は11以  |
| 上を目安)、表面の景観パターン等に留意した設計を行うことが望ましい。  |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  美しい山河を守る災害復旧基本方針(平成30年6月), p.87-94,
    2018,国土交通省水管理・国土保全局防災課.

＜参考となる資料＞

環境や景観に配慮した設計については、下記の資料が参考となる。

4.  多自然川づくりポイントブックⅢ，p.120-136，（財）リバーフロント整備センター，2011,多自然川づくり研究会.

    1.  []{#_Toc85298178 .anchor}基本的な構造

        1.  []{#_Toc85298180 .anchor}構造型式の設定

＜考え方＞

+----------------------------------------------------------------------+
| 床止めの構造は、コンクリート構造と屈とう性構造に                     |
| 大きく分けられる。コンクリート構造が一般的に多く用いられている。屈と |
| う性構造は、コンクリート構造に比べて経済的に有利であり、施工が容易で |
| ある等の利点を持つことが多いが、地震時に液状化するような危険性のある |
| 箇所や、複断面河道となっている急流河川では、被災を受けやすいため避け |
| た方が良い。構造型式は、環境及び景観との調和、構造物の耐久性、維持管 |
| 理の容易性、施工性及び経済性等を総合的に考慮して選定する必要がある。 |
|                                                                      |
| １）コンクリート構造                                                 |
|                                                                      |
| コンクリート構造には、分離式                                         |
| 構造と一体式構造がある。分離式構造は、本体と水叩きを分離し、本体にか |
| かる重力により、土圧、水圧等の外力に対する安定を保つ型式である。一体 |
| 式構造は、本体・水叩きを鉄筋コンクリートなどで一体化した型式である。 |
|                                                                      |
| 従来の設計では、分離                                                 |
| 式構造を基本としていたが、この構造には以下の問題点が指摘されていた。 |
|                                                                      |
| > ・本体のみで自立させる                                             |
| 構造であるため、安定する自重を確保するための本体幅が大きくなりすぎる |
| >                                                                    |
| > ・本体と水叩きの接合部で流水や地震により目地等の開きが発           |
| 生した場合、パイピング現象により床止め本体が被災を受ける可能性がある |
|                                                                      |
| 本                                                                   |
| 体と水叩きを一体とした一体式構造の床止めでは、これらの問題点を解消で |
| きる場合が多いことから、最近ではこの構造が用いられることが多い。ただ |
| し、揚圧力が大きくなる場合等では、分離式構造が有利となることもある。 |
|                                                                      |
| ![](media/image34.emf){width="2.9818897637795274in"                  |
| height="1.255                                                        |
| 9055118110236in"}![](media/image35.emf){width="2.9744094488188977in" |
| height="1.2133858267716535in"}                                       |
|                                                                      |
| +----------------+----------------+                                  |
| | 8.  分離式構造 | 9.  一体式構造 |                                  |
| +----------------+----------------+                                  |
|                                                                      |
| ２）屈とう性構造                                                     |
|                                                                      |
| 床止めでは天端の沈下、欠落は許されないので、                         |
| ブロック同士の一体性が強い層積みとした方が良い。また、特に高流速とな |
| り流れが乱れる区間では、鉄筋によるブロック間の連結等によって全体が一 |
| 体となって流水に抵抗できるようにする必要がある。この型式は、コンクリ |
| ート構造に比べて経済的に有利であり、施工が容易である等の利点を持つこ |
| とが多い。屈とう性構造は以下のような場合に選定することが考えられる。 |
|                                                                      |
| > ・河床変動が大きいと予想されるが、その変動量予測が難しいため       |
| 、将来の床止めの変形を補修によって対処することが有利と判断される場合 |
| >                                                                    |
| > ・長期的な河床低下への部分的な対応や橋脚                           |
| の保護のためなど、未改修分との接続のために暫定的に床止めが必要な場合 |
|                                                                      |
| ただし、地震時に液状化するような危険性のある箇所（セグメント2-2      |
| 及び3）や、複断面河道となっている急流河川（セグメント1）で、高水敷の |
| 侵食防止が必要な箇所での設置は、被災を受けやすいため避けた方が良い。 |
|                                                                      |
| また、屈とう性構造では、ブロック間を水が伏流する                     |
| 可能性があることから水深が確保できず魚類等の移動の障害となることが予 |
| 想されるので、水密性を保つ工夫や魚道の設置などを検討する必要がある。 |
|                                                                      |
| ![](media/image36.emf){width="4.174015748031496in"                   |
| height="1.3448818897637795in"}                                       |
|                                                                      |
| 10. 屈とう性構造（コンクリートブロックの場合）                       |
+----------------------------------------------------------------------+

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  床止めの構造型式は、コンクリート構造と屈とう性構造がある。構造型式の選定に当たっては、構造物の耐久性、維持管理の容易性、施工性、経済性、及び環境・景観との調和等に考慮して設定することを基本とする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

1.  []{#_Toc85298181 .anchor}材質と構造

```{=html}
<!-- -->
```
7.  使用材料

＜考え方＞

  ----------------------------------------------------------------------------------
  床止めの使用材料は、設置目的に応じて要求される強度や耐久性を満足する必要がある。
  ----------------------------------------------------------------------------------

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------
  床止めの使用材料は、設置目的に応じて要求される強度や耐久性を満足するための品質を有し、その性状が明らかにされているものを使用することを基本とする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

+----------------------------------------------------------------------+
| 鉄筋コンクリート構造                                                 |
| 物（プレキャスト製品を除く）に用いるコンクリートの設計基準強度は、2  |
| 4N/mm^2^、無筋コンクリート構造物に用いるコンクリートの設計基準強度18 |
| N/mm^2^、鉄筋の材質は、SD345を推奨する。                             |
|                                                                      |
| JIS等の公的な品質規格に適合し、適用範囲が明らかな用                  |
| 途に対して使用することが望ましい。公的な品質規格がない材料の場合には |
| 、材料特性が床止めに及ぼす影響を試験等によって確認するとともに、品質 |
| についてもJIS等の規格と同等以上であることを確認することが望ましい。  |
+----------------------------------------------------------------------+

8.  主な構造

＜考え方＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  床止めを構成する主な構造としては、本体、水叩き、護床工、基礎、遮水工、取付擁壁・護岸、高水敷保護工・のり肩工、魚道等があげられる。本体は、一般にコンクリート構造、コンクリートブロックやかご工などで構成される。いずれの構造においても、所要の安全性を確保する必要がある。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 床止めは、本体、水叩き、護床工をはじめいくつかの部位から             |
| 構成される。各部位には、水圧、土圧、揚圧力などの外力が作用するが、床 |
| 止めを構成する各部位の設計に当たっては、床止め全体として機能を確保し |
| 、所要の安全性を確保できる構造となるように設計することを基本とする。 |
|                                                                      |
| 設計に当たっては、環境及び景観との調和を図ることを基本とする。       |
+----------------------------------------------------------------------+

9.  設計用定数

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------
  床止めの設計に用いる材料の各種定数は、所要の安全性が確保できるよう、力学特性を考慮し、必要に応じて調査・試験を実施したうえで、設定することを基本する。
  --------------------------------------------------------------------------------------------------------------------------------------------------------

1.  ヤング係数

＜標　準＞

  --------------------------------------------------------------------------------------------
  設計に用いるヤング係数は、材料の特性や品質を考慮したうえで適切に設定することを基本とする。
  --------------------------------------------------------------------------------------------

＜推　奨＞

+----------------------------------------------------------------------+
| ヤング率として、以下の値を用いることが望ましい。                     |
|                                                                      |
| １） ヤング係数                                                      |
|                                                                      |
| ・コンクリートのヤング係数は、2.5×10^4^                              |
| N/mm^2^（設計基準強度：24N/mm^2^）                                   |
|                                                                      |
| ・鋼材のヤング係数は、2.0×10^5^ N/mm^2^                              |
|                                                                      |
| ２） ヤング係数比                                                    |
|                                                                      |
| > ・許容応力度による設計を                                           |
| 行う場合の鉄筋コンクリート部材の応力度の計算に用いるヤング係数比は15 |
+----------------------------------------------------------------------+

2.  地盤に係る定数

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  地盤に係る定数は、ボーリング調査、サウンディング調査、原位置試験、室内土質試験を組合せた地盤調査（既往調査含む）や周辺の工事履歴、試験施工等に基づき総合的に判断し、施工条件等も考慮したうえで、設定することを基本とする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

+----------------------------------------------------------------------+
| １）基礎底面と地盤との間の摩擦係数と付着力                           |
|                                                                      |
| 基礎底面と地盤                                                       |
| との間の摩擦係数と付着力として、表6-1に示す値を用いることができる。  |
|                                                                      |
| 2.  摩擦角と付着力                                                   |
|                                                                      |
| +------------------------+------------------------+------------+     |
| | 条　　　　件           | 摩擦角φ                | 付着力c~B~ |     |
| |                        | ~B~（摩擦係数tanφ~B~） |            |     |
| +========================+========================+============+     |
| | 土とコンクリート       | ![散布図               | c~B~=0     |     |
| |                        | が含まれている画像     |            |     |
| |                        | 自動的                 |            |     |
| |                        | に生成された説明](med  |            |     |
| |                        | ia/image37.png){width= |            |     |
| |                        | "0.5763888888888888in" |            |     |
| |                        | height="               |            |     |
| |                        | 0.5427668416447944in"} |            |     |
| +------------------------+------------------------+------------+     |
| | 土とコンクリートの間に | tanφ*~B~=0.6*          | c*~B~=0*   |     |
| |                        |                        |            |     |
| | 栗石を敷く場合         | φ*~B~=φ*               |            |     |
| +------------------------+------------------------+------------+     |
| | 岩とコンクリート       | tanφ~B~ =0.6           | c~B~=0     |     |
| +------------------------+------------------------+------------+     |
| | 土と土又は岩と岩       | φ~B~ =φ                | c~B~=c     |     |
| +------------------------+------------------------+------------+     |
|                                                                      |
| た                                                                   |
| だし、φ：支持地盤のせん断抵抗角（度）、c:支持地盤の粘着力（kN/m^2^） |
|                                                                      |
| > φ~B~:基礎底面と地盤との間の摩擦角(rad)                             |
| >                                                                    |
| > c~B~:基礎底面と地盤との間の付着力(kN/m^2^)                         |
|                                                                      |
| ２）基礎地盤支持力及び摩擦係数                                       |
|                                                                      |
| 基礎地盤支持力及び摩擦係数は、表6-2に示す値を用いることができる。    |
|                                                                      |
| 　　                                                                 |
|                                                                      |
| 3.  基礎地盤支持力及び摩擦係数                                       |
|                                                                      |
| ![](media/image38.png){width="4.663426290463692in"                   |
| height="4.212185039370079in"}                                        |
|                                                                      |
| ３）地盤の許容鉛直支持力                                             |
|                                                                      |
| 地                                                                   |
| 盤の許容鉛直支持力は、荷重の偏心傾斜及び基礎の沈下量を考慮した地盤の |
| 極限支持力に対して、表6-3に示す安全率を確保していることが望ましい。  |
|                                                                      |
| 4.  安全率                                                           |
|                                                                      |
|   常時、洪水時   地震時   施工時                                     |
|   -------------- -------- --------                                   |
|   3              2        2                                          |
|                                                                      |
| 荷重の偏心傾斜及び基礎の                                             |
| 沈下量を考慮した地盤の極限支持力は、次式により求めることができる。平 |
| 板載荷試験により求める場合には、載荷試験の結果により確認した地盤の粘 |
| 着力ｃ,せん断抵抗角φを用いて以下の式に従って算出することが望ましい。 |
|                                                                      |
| 　　*Q~u~* = *A~e~*                                                  |
| {*ακcN~c~S~c~*+*κqN~q~S~q~*+(1/2)*γ*~1~*βB~e~N~γ~S~γ~*}              |
|                                                                      |
| ここに、                                                             |
|                                                                      |
| 　　　　　*Q                                                         |
| ~u~*：荷重の偏心傾斜、支持力係数の寸法効果を考慮した地盤の極限支持力 |
| (kN)                                                                 |
|                                                                      |
| > 　　　　　*c*：地盤の粘着力 (kN/m^2^)                              |
| >                                                                    |
| > 　　　　　*q*：上載荷重 (kN) で、*q*=*γ*~2~*D~f~*                  |
| >                                                                    |
| > 　　　　　*A~e~*：有効載荷面積 (m^2^)                              |
| >                                                                    |
| > 　　　*γ*~1~、*γ*~2~：支持地盤及び根入れ地盤の単位体積重量         |
| > (kN/m^3^)                                                          |
|                                                                      |
| 　　　　　*B~e~*：荷重の偏心を考慮した基礎の有効載荷幅 (m)           |
|                                                                      |
| 　　　　　　　*B~e~* = *B* − 2*e~B~*                                 |
|                                                                      |
| > 　　　　　*B*：基礎幅 (m)                                          |
|                                                                      |
| 　　　　　*e~B~*：荷重の偏心量 (m)                                   |
|                                                                      |
| > 　　　 　*D~f~*：基礎の有効根入れ深さ (m)                          |
| >                                                                    |
| > 　　 　*α*、*β*：基礎の形状係数                                    |
| >                                                                    |
| > 　　　　　*κ*：根入れ効果に対する割増係数                          |
| >                                                                    |
| > *N~c~*、*N~q~*、*N~γ~*：荷重の傾斜を考慮した支持力係数　           |
| >                                                                    |
| > 　*S~c~*、*S~q~*、*S~γ~*：支持力係数の寸法効果に関する補正係数     |
| >                                                                    |
| > *tanθ*：荷重の傾斜                                                 |
|                                                                      |
| ![グラフ                                                             |
| 自                                                                   |
| 動的に生成された説明](media/image39.png){width="3.47500656167979in"  |
| height="2.780005468066492in"}                                        |
|                                                                      |
| 11. 支持力係数*N~c~*を求めるグラフ                                   |
|                                                                      |
| ![](media/image40.png){width="3.50500656167979in"                    |
| height="3.17000656167979in"}                                         |
|                                                                      |
| 12. 図支持力係数*N~q~*を求めるグラフ                                 |
|                                                                      |
| ![ダイアグラム                                                       |
| 自                                                                   |
| 動的に生成された説明](media/image41.png){width="3.54000656167979in"  |
| height="4.050007655293088in"}                                        |
|                                                                      |
| 13. 支持力係数*N~γ~*を求めるグラフ                                   |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  河川砂防技術基準調査編，平成 24 年 4 月 1 日,国水情第 52
    号,国土交通省水管理国土保全局.

    （最新版）河川砂防技術基準　調査編, 令和7年6月,
    国土交通省水管理・国土保全局.

＜参考となる資料＞

地盤に係る定数の設定については、下記の資料が参考となる。

1.  道路橋示方書・同解説　Ⅳ．下部構造編，平成24年3月（社）,日本道路協会.

    （最新版）道路橋示方書・同解説Ⅳ下部構造編，平成29年11月,（公社）日本道路協会.

```{=html}
<!-- -->
```
10. 鉄筋コンクリート部材の最小寸法

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------
  鉄筋コンクリートの部材の最小寸法は、耐久性、強度を有するために必要なかぶり及び施工性に配慮し設定することを基本とする。
  ------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

  ----------------------------------------------------------------------------------------------------------
  鉄筋コンクリートの部材の最小寸法は、施工性を重視し主鉄筋を内側に配置するため、0.4mとすることが望ましい。
  ----------------------------------------------------------------------------------------------------------

＜関連通知等＞

1.  土木構造物設計マニュアル（案）樋門編，平成13年2月,国土交通省．

    （最新版）土木構造物設計マニュアル（案）樋門編，平成 13 年 12
    月,国土交通省．

    1.  []{#_Toc85298182 .anchor}安全性能の照査等

        1.  []{#_Toc85298183 .anchor}設計の対象とする状況と作用

＜考え方＞

+----------------------------------------------------------------------+
| 床止めの設計に当た                                                   |
| っては、常時、洪水時及び地震時の安全性能を確保することが求められる。 |
| コンクリート構造の床止めについては、常時、洪水時及び地震時に、屈とう |
| 性構造の床止めについては、常時及び洪水時について照査する必要がある。 |
|                                                                      |
| 照査に当たっては、基礎地盤の特性、                                   |
| 河道の特性、維持管理に必要となる前提条件を設定する必要がある。なお、 |
| 前提条件は、土質地質調査や河道特性調査等に基づき設定する必要がある。 |
|                                                                      |
| 設計の対象とする作用については                                       |
| 、本体の自重、計画高水位以下の水圧、土圧、地震の影響等が考えられ、設 |
| 計の対象とする床止めの状況に応じて適切に組合せて設定する必要がある。 |
|                                                                      |
| また、必要に応じて施工時についても安全性能の照査を行う。             |
|                                                                      |
| なお、                                                               |
| 床止めを高潮区間に設置された事例が確認されていないことから、本節にお |
| いては、高潮や風浪、津波の作用は必要に応じて考慮することとしている。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 安全性能の照査に当たっては、次の表のように設計の対象とする状         |
| 況と作用を設定し、これを踏まえて照査事項を設定することを基本とする。 |
|                                                                      |
| +--------------+------------------------------------------------+    |
| | 床止めの状況 | 作　　　　用                                   |    |
| +==============+================================================+    |
| | 常　時       | 自重（死荷                                     |    |
| |              | 重）、土圧、水圧、泥圧（必要な場合）、揚圧力等 |    |
| +--------------+------------------------------------------------+    |
| | 洪水時       | 自重（死荷重                                   |    |
| |              | ）、土圧、水圧^※^、泥圧（必要な場合）、揚圧力  |    |
| |              |                                                |    |
| |              | ※計画高水位                                    |    |
| +--------------+------------------------------------------------+    |
| | 地震時       | 自重（死荷重）、水圧                           |    |
| |              | 、泥圧（必要な場合）、揚圧力、地震の影響^※^等  |    |
| |              |                                                |    |
| |              | ※構造物の重量に起因する                        |    |
| |              | 慣性力、地震時土圧、地震時動水圧、液状化の影響 |    |
| +--------------+------------------------------------------------+    |
| | その他       | 施工時荷重、セイシュによる影響                 |    |
| +--------------+------------------------------------------------+    |
|                                                                      |
| ※高潮や                                                              |
| 風浪、津波等の影響を受ける場合には、必要に応じて考慮するものとする。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  河川構造物の耐震性能照査指針・解説―Ⅳ．水門・樋門及び堰編―，令和2年2月（令和2年6月一部追記）,国土交通省水管理・国土保全局．

```{=html}
<!-- -->
```
11. 河川津波対策について，平成23 年 9 月 2 日，国水計第 20 号，国水治第
    35 号，国土交通省水管理・国土保全局河川計画課長、治水課長.

＜推　奨＞

+----------------------------------------------------------------------+
| 床止めの設計に当たっては、作用毎に以下の数値を用いることが望ましい。 |
|                                                                      |
| １）自重（死荷重）                                                   |
|                                                                      |
| 自重（死荷重）は、適切な単位体積重量を用いて算出する。               |
|                                                                      |
| 材料の単位体積重量は、表6-4、表6-5の値を参考に定めるものとする。     |
|                                                                      |
| 5.  材料の単位体積重量(kN/m^3^)                                      |
|                                                                      |
|   材　　料           単位体積重量                                    |
|   ------------------ --------------                                  |
|   鋼・鋳鋼・鍛鋼     77.0                                            |
|   鋳鉄               71.0                                            |
|   アルミニウム       27.5                                            |
|   鉄筋コンクリート   24.5                                            |
|   コンクリート       23.0                                            |
|   セメントモルタル   21.0                                            |
|   木材               8.0                                             |
|   歴青材（防水用）   11.0                                            |
|   アスファルト舗装   22.5                                            |
|                                                                      |
| 土                                                                   |
| の単位体積重量は、一般的な値を示したものであり、土質試験データがある |
| 場合は、その値を用いて設計することが望ましい。コンクリートについても |
| 、できるだけ試験データによることが望ましい。また、堤防盛土材料に現地 |
| の発生材を用いる場合や、盛土材料が明確になっていない場合は、一般に18 |
| kN /m^3^を用いる。                                                   |
|                                                                      |
| 6.  土の単位体積重量(kN/m^3^)                                        |
|                                                                      |
|   地盤       土　質       緩いもの   密なもの                        |
|   ---------- ------------ ---------- ----------                      |
|   自然地盤   砂及び砂礫   18         20                              |
|              砂質土       17         19                              |
|              粘性土       14         18                              |
|   盛土       砂及び砂礫   20                                         |
|              砂質土       19                                         |
|              粘性土       18                                         |
|                                                                      |
| > 地下水位以下にある土                                               |
| の単位体積重量は、それぞれの表中の値から9を差し引いた値としてよい。  |
| >                                                                    |
| > 地下水位は施工後における水位の平均値を考慮する。                   |
|                                                                      |
| ２）土圧                                                             |
|                                                                      |
| ①静止土圧                                                            |
|                                                                      |
| 静止土圧は、次式による。                                             |
|                                                                      |
| *P~hd~＝K~0~(γ×h＋q~0~)*                                             |
|                                                                      |
| ここに                                                               |
|                                                                      |
| *P~hd~*：任意の深さの水平土圧強度(kN/ｍ^2^ )                         |
|                                                                      |
| > *K~0~*：静止土庄係数(通常はK~0~＝0.5と考えてよい)                  |
| >                                                                    |
| > *γ*：土の単位体積重量(kN/ｍ^3^ )                                   |
| >                                                                    |
| > *h*：任意の深さ(ｍ)                                                |
|                                                                      |
| *q~0~*:上載荷重(kN/ｍ^2^ )                                           |
|                                                                      |
| ②主働土圧                                                            |
|                                                                      |
| 主働土圧は、次式による。                                             |
|                                                                      |
| Pa＝K~A~(γ×h＋q~0~)                                                  |
|                                                                      |
| 　 ![](media/image42.emf){width="3.5375in"                           |
| height="0.5076388888888889in"}                                       |
|                                                                      |
| cot(ξ~A~－α)＝－tan(φ＋δ＋θ－α)                                      |
|                                                                      |
| 　　　                                                               |
| 　　　　　　　　　　　　　　![](media/image43.emf){width="3.19375in" |
| height="0.4027777777777778in"}                                       |
|                                                                      |
| ここに                                                               |
|                                                                      |
| Pa：任意の深さの主働土圧強度(kN/ｍ^2^)                               |
|                                                                      |
| K~A~：主働土圧係数                                                   |
|                                                                      |
| ξ~A~：主働崩壊角(度)                                                 |
|                                                                      |
| γ：土の単位体積重量(kN/ｍ^3^)                                        |
|                                                                      |
| h：任意の深さ(ｍ)                                                    |
|                                                                      |
| q~0~：上載荷量(kN/ｍ^2^)                                             |
|                                                                      |
| α：地表面と水平面のなす角(度)                                        |
|                                                                      |
| θ：壁背面と鉛直面のなす角(度)                                        |
|                                                                      |
| φ：土の内部摩擦角(度)                                                |
|                                                                      |
| δ：土圧作用面の種別に応じた壁面摩擦角(度)                            |
|                                                                      |
| 土と土の場合：δ＝φ                                                   |
|                                                                      |
| 土とコンクリートの場合：δ＝φ/3                                       |
|                                                                      |
| ただし、φ－α＜Oのときはsin(φ－α)＝0とする。                          |
|                                                                      |
| 上載荷量q~0~は必要に応じて考慮する。                                 |
|                                                                      |
| ここで用いる角度は反時計回りを正とする。                             |
|                                                                      |
| > ③地震時主働土圧                                                    |
|                                                                      |
| 地震時主働土圧は、河川構造物の耐震性能照査指針                       |
| Ⅳ水門・樋門及び堰編による。                                          |
|                                                                      |
| 　 　　                                                              |
|                                                                      |
| ３）水圧                                                             |
|                                                                      |
| ①静水圧                                                              |
|                                                                      |
| > 静水圧は、常時、洪水時にお                                         |
| いては、流量規模に応じた上流側及び下流側の水位を求め、最大となる水位 |
| 差の水圧を求める。地震時においては、上下流とも平水位での水圧とする。 |
|                                                                      |
| 3.  地震時動水圧                                                     |
|                                                                      |
| > 地震時動水圧は、河川構造物の耐震性能照査指針                       |
| > Ⅳ水門・樋門及び堰編による。                                        |
|                                                                      |
| 　 　　                                                              |
|                                                                      |
| ４）揚圧力                                                           |
|                                                                      |
| 揚圧力は、水叩き長と上下流水位差により求める。                       |
|                                                                      |
| ５）構造物の重量に起因する慣性力                                     |
|                                                                      |
| 構造物の重量に起因する慣性力は、構造物の重量                         |
| に水平震度を乗じた水平力として算出する。このときの水平震度は、河川構 |
| 造物の耐震性能照査指針Ⅳ水門・樋門及び堰編による。なお、動的照査法を  |
| 用いる場合は、構造物の質量に応答加速度を乗じたものとして算出される。 |
|                                                                      |
| ６）その他荷重                                                       |
|                                                                      |
| 床止めや魚道の設計に当たっては必要に応じて以下の荷重を考慮する。     |
|                                                                      |
| ・施工時荷重                                                         |
|                                                                      |
| ・セイシュによる影響                                                 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  土木構造物設計マニュアル（案）樋門編，平成13年2月,国土交通省．

    （最新版）土木構造物設計マニュアル（案）樋門編，平成 13 年 12
    月,国土交通省．

```{=html}
<!-- -->
```
12. 河川構造物の耐震性能照査指針・解説―Ⅳ．水門・樋門及び堰編―，令和2年2月（令和2年6月一部追記）,国土交通省水管理・国土保全局.

＜参考となる資料＞

設計の対象とする作用の設定に当たっては、下記の資料が参考となる。

1.  道路橋示方書・同解説 Ⅰ．共通編，平成 24 年 3
    月，（公社）日本道路協会.

    （最新版）道路橋示方書・同解説Ⅰ．共通編，平成29年11月，（公社）日本道路協会.

```{=html}
<!-- -->
```
13. 柔構造樋門設計の手引き，平成10年11月,（財）国土技術研究センター．

14. 道路土工，擁壁工指針，平成24年版,（公社）日本道路協会．

15. 道路土工，カルバート工指針，平成21年版,（公社）日本道路協会．

    1.  []{#_Toc85298184 .anchor}安全性能の照査

＜考え方＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------
  床止めは、「6.5.1 設計の対象とする状況と作用」に示す状況と作用毎に、照査の条件として適切な床止めの上下流の水位の組合せを設定し、安全性能について照査する必要がある。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 床止めは、「6.5.1                                                    |
| 設計の対象とする状況と                                               |
| 作用」に対し、以下の事項の安全性能について照査することを基本とする。 |
|                                                                      |
| （1）常時の安全性能                                                  |
|                                                                      |
| （2）洪水時の安全性能                                                |
|                                                                      |
| （3）耐震性能                                                        |
|                                                                      |
| 照査に当                                                             |
| たっては、これまでの経験及び実績から妥当とみなせる方法又は論理的に妥 |
| 当性を有する方法等、適切な知見に基づく手法を用いることを基本とする。 |
+----------------------------------------------------------------------+

　　

＜推　奨＞

+----------------------------------------------------------------------+
| 鉄筋コンクリート部                                                   |
| 材の安全性能を照査するに当たっては、以下の手法によることが望ましい。 |
|                                                                      |
| ・部材の設計に用いる断面力は、弾性理論により算出する。               |
|                                                                      |
| ・部材の設計は、許容応力度設計法によって行う。                       |
+----------------------------------------------------------------------+

1.  常時の安全性能

＜考え方＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  床止めは、自重や背面からの土圧、さらに軟弱な地盤上に床止めを新設する場合には基礎地盤の強度不足又は圧縮性が大きいことによる圧密沈下等により、構造物の安全性が損なわれる可能性があるため、取付擁壁の応力度や基礎の沈下量、支持力等について常時の安全性能の照査を行う必要がある。護岸についても必要に応じて常時の安全性能の照査を行う必要がある。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 常時の床止めの安全性能は、                                           |
| 本体や水叩きの自重、水圧、土圧、揚圧力が作用に対して以下の項目の安全 |
| 性を評価し、所定の安全性又は許容値を満足することを照査の基本とする。 |
|                                                                      |
| １）各部位の安定性                                                   |
|                                                                      |
| > 床止め本体（一体式構造の場合は水叩き                               |
| を含む、以下同様）が転倒、滑動、基礎地盤支持力に対して所要の安全性を |
| 確保する。また本体については、揚圧力に対して所要の安全性を確保する。 |
|                                                                      |
| ２）発生応力に対する安全性                                           |
|                                                                      |
| > 「6.5.1設計の対象とする状況と作用」により諸条件を設定し、床止      |
| め本体に発生する応力が「6.5.3許容応力度」以下となることを確認する。  |
|                                                                      |
| ３）耐浸透性能                                                       |
|                                                                      |
| > 床止め                                                             |
| 本体と基礎地盤との接触面における浸透に対して所要の安全性を確保する。 |
+----------------------------------------------------------------------+

＜推　奨＞

+----------------------------------------------------------------------+
| １）各部位の安定性                                                   |
|                                                                      |
| 所要の安定性とは、表6-6に示す安全率を満足するものとする。            |
|                                                                      |
| 7.  各項目の安全率                                                   |
|                                                                      |
|   項目             安全率                                            |
|   ---------------- ---------------------------                       |
|   転倒             合力の作用点が中央1/3以内                         |
|   滑動             1.5                                               |
|   基礎地盤支持力   3                                                 |
|                                                                      |
| ２）発生応力に対する安全性                                           |
|                                                                      |
| せん断応力度は                                                       |
| 、せん断力を部材幅（b）×有効高（d）で割った平均せん断応力度とする。  |
|                                                                      |
| せん断応力度の照査は、支点が直接支持と                               |
| なっているものは支点の前面より1/2×hだけ内側で行ってよい。(h:はり高） |
|                                                                      |
| ３）耐浸透性能                                                       |
|                                                                      |
| 耐浸透性照査における所要の安全性は、地盤の土                         |
| 質区分、本体及び水叩き長、考慮する水頭差、遮水工の配置、深さ、長さを |
| 考慮したうえで、レインの式による浸透経路長を満足することを確認する。 |
| なお、遮水工を2列に入れる場合深さに対して間隔が短すぎると浸透路長が  |
| 遮水工沿いとはならない場合があるので、実現象に合うように浸透路長をと |
| るよう留意する。また、地盤が互層の場合は、浸透流が常に浸透抵抗の小さ |
| いところを流れることを念頭において浸透経路を検討することが望ましい。 |
|                                                                      |
| $$レイン加重                                                         |
| クリープ比　C \leqq \frac{\frac{L}{3} + \sum l}{\mathrm{\Delta}H}$$  |
|                                                                      |
| > ここに                                                             |
|                                                                      |
| +----------------------------------+                                 |
| | > *C* : 加重クリープ比           |                                 |
| +==================================+                                 |
| | > *L* :本体及び水叩きの長さ（m） |                                 |
| +----------------------------------+                                 |
| | > *∑l* : 鉛直方向浸透路長（m）   |                                 |
| +----------------------------------+                                 |
| | > *ΔH* :上下流最大水位差（m）    |                                 |
| +----------------------------------+                                 |
|                                                                      |
| 8.  加重クリープ比C                                                  |
|                                                                      |
|   地盤の土質区分             C                                       |
|   -------------------------- -----                                   |
|   極めて細かい砂又はシルト   8.5                                     |
|   細砂                       7.0                                     |
|   中砂                       6.0                                     |
|   粗砂                       5.0                                     |
|   細砂利                     4.0                                     |
|   中砂利                     3.5                                     |
|   栗石を含む粗砂利           3.0                                     |
|   栗石と礫を含む砂利         2.5                                     |
|   柔らかい粘土               3.0                                     |
|   中くらいの粘土             2.0                                     |
|   堅い粘土                   1.8                                     |
|                                                                      |
| ４）揚圧力に対する安全性                                             |
|                                                                      |
| 揚圧力に対する安全率は、4/3とする。                                  |
+----------------------------------------------------------------------+

＜参考となる資料＞

安全性能の照査に当たっては、下記の資料が参考となる。

1.  床止めの構造設計手引き,平成10年12月,（財）国土技術研究センター.

```{=html}
<!-- -->
```
16. 道路土工，擁壁工指針，平成24年版,（公社）日本道路協会．

```{=html}
<!-- -->
```
11. 洪水時の安全性能

＜考え方＞

+----------------------------------------------------------------------+
| 床止めは、計画高水位（高潮区間にあっては                             |
| 、計画高潮位）以下の水位の流水の作用に対して安全な構造が求められる。 |
|                                                                      |
| なお、安全性能                                                       |
| の照査は、本体・水叩き一体式構造と分離式構造において行うものとする。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 洪水時の床止めの安全性能は、本体や水叩きの自重、水圧、               |
| 揚圧力が作用する状態で、以下の項目について照査することを基本とする。 |
|                                                                      |
| １）各部位の安定性                                                   |
|                                                                      |
| > 床止め本体が転倒、滑動、基礎地盤支持力に対して所要の安全性を       |
| 確保する。また本体については、揚圧力に対して所要の安全性を確保する。 |
|                                                                      |
| ２）発生応力に対する安全性                                           |
|                                                                      |
| > 「6.5.1設計の対象とする状況と作用」により諸条件を設定し、床止      |
| め本体に発生する応力が「6.5.3許容応力度」以下となることを確認する。  |
+----------------------------------------------------------------------+

＜推　奨＞

+----------------------------------------------------------------------+
| １）各部位の安定性                                                   |
|                                                                      |
| 所要の安定性とは、以下の安全率を満足するものとする。                 |
|                                                                      |
| 9.  各項目の安全率                                                   |
|                                                                      |
|   項目             安全率                                            |
|   ---------------- ---------------------------                       |
|   転倒             合力の作用点が中央1/3以内                         |
|   滑動             1.5                                               |
|   基礎地盤支持力   3                                                 |
|                                                                      |
| 揚圧力に対する安全率は、4/3とする。                                  |
|                                                                      |
| ２）発生応力に対する安全性                                           |
|                                                                      |
| せん断応力度は                                                       |
| 、せん断力を部材幅（b）×有効高（d）で割った平均せん断応力度とする。  |
|                                                                      |
| せん断応力度の照査は、支点が直接支持と                               |
| なっているものは支点の前面より1/2×hだけ内側で行ってよい。(h:はり高） |
+----------------------------------------------------------------------+

12. 耐震性能

＜考え方＞

+----------------------------------------------------------------------+
| 床止めの耐震性能の照査は、河川構造物の                               |
| 耐震性能照査指針に基づき実施する必要がある。レベル1地震動に対しては  |
| 、地震によって床止めとしての健全性を損なわないか否かを照査する。なお |
| 、本体以外は構造物の主な部分ではないため照査対象外として良い。また、 |
| 床止め本体（一体式構造の場合は水叩きを含む）が転倒、滑動、基礎地盤支 |
| 持力に対して所要の安全性を確保することについても照査する必要がある。 |
|                                                                      |
| 床止め本体（一体式構造の場合は水                                     |
| 叩きを含む）には地震時に慣性力及び水圧が作用するとともに、本体の背面 |
| には地震時土圧が作用する。また、床止め本体、水叩きの地震時挙動は、地 |
| 形、地盤条件等の種々の要因の影響を受けるが、中でも、基礎地盤の影響を |
| 大きく受ける。基礎地盤が液状化した場合には、液状化に伴う基礎地盤の変 |
| 形が地震時挙動に大きく影響を及ぼすため、液状化を考慮する必要がある。 |
+----------------------------------------------------------------------+

＜標　準＞

  -----------------------------------------------------------------------------------------------------------------------
  耐震性能の照査に当たっては、レベル1地震動に対して地震によって床止めとしての健全性を損なわないことを照査の基本とする。
  -----------------------------------------------------------------------------------------------------------------------

＜推　奨＞

+----------------------------------------------------------------------+
| １）各部位の安定性                                                   |
|                                                                      |
| 所要の安定性とは、表6-9に示す安全率を満足するものとする。            |
|                                                                      |
| 10. 各項目の安全率                                                   |
|                                                                      |
|   項目             安全率                                            |
|   ---------------- ---------------------------                       |
|   転倒             合力の作用点が中央2/3以内                         |
|   滑動             1.2                                               |
|   基礎地盤支持力   2                                                 |
|                                                                      |
| ２）その他の安全性                                                   |
|                                                                      |
| その他の耐震性能の照査について                                       |
| は、河川構造物の耐震性能照査指針・解説―Ⅳ．水門・樋門及び堰編による。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  河川構造物の耐震性能照査指針・解説―Ⅳ．水門・樋門及び堰編―，令和2年2月（令和2年6月一部追記），国土交通省水管理・国土保全局.

＜参考となる資料＞

耐震性能の照査については、下記の資料が参考となる。

1.  道路土工，擁壁工指針，平成24年版,（公社）日本道路協会．

    1.  []{#_Toc85298185 .anchor}許容応力度

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------
  許容応力度等は、使用する材料の基準強度や力学特性を考慮して、所要の安全性が確保できるように設定することを基本とする。
  ----------------------------------------------------------------------------------------------------------------------

＜推　奨＞

+----------------------------------------------------------------------+
| 許容応力度として、以下の値を用いることが望ましい。                   |
|                                                                      |
| １）コンクリートの許容応力度                                         |
|                                                                      |
| 11. コンクリートの許容応力度（N/mm^2^）                              |
|                                                                      |
|   設                                                                 |
| 計基準強度   許容曲げ圧縮応力度   許容付着応力度   許容せん断応力度  |
|   ---                                                                |
| ----------- -------------------- ---------------- ------------------ |
|   24             8.0                  1.60             0.39          |
|                                                                      |
| なお、無筋コンクリートの許                                           |
| 容応力度は、道路橋示方書・同解説Ⅳ．下部構造編（平成24年3月）による。 |
|                                                                      |
| ２）鉄筋の許容引張応力度                                             |
|                                                                      |
| 12. 鉄筋の許容引張応力度（N/mm^2^）                                  |
|                                                                      |
| +------------------+------------------+------------------+-----+     |
| | 鉄筋の種類       | SD345            |                  |     |     |
| |                  |                  |                  |     |     |
| | 応               |                  |                  |     |     |
| | 力度、部材の種類 |                  |                  |     |     |
| +==================+==================+==================+=====+     |
| | 引張応力度       | 荷重の           | 一般の部材※1     | 180 |     |
| |                  | 組合せに衝突荷重 |                  |     |     |
| |                  | あるいは地震の影 |                  |     |     |
| |                  | 響を含まない場合 |                  |     |     |
| +------------------+------------------+------------------+-----+     |
| |                  |                  | 厳し             | 160 |     |
| |                  |                  | い環境下の部材※2 |     |     |
| +------------------+------------------+------------------+-----+     |
| |                  | 荷重の           | 200              |     |     |
| |                  | 組合せに衝突荷重 |                  |     |     |
| |                  | あるいは地震の影 |                  |     |     |
| |                  | 響を含む場合の許 |                  |     |     |
| |                  | 容応力度の基本値 |                  |     |     |
| +------------------+------------------+------------------+-----+     |
| |                  | 鉄筋の重ね継     | 200              |     |     |
| |                  | 手長あるいは定着 |                  |     |     |
| |                  | 長を算出する場合 |                  |     |     |
| +------------------+------------------+------------------+-----+     |
|                                                                      |
| ※1 通常の環境や常時水中、土中の場合                                  |
|                                                                      |
| > ※2                                                                 |
| > 一般の環境に比べて乾湿の繰り返しが多い場合や有害な物質を含む地下水 |
| 位以下の土中の場合（海洋環境などでは別途かぶりなどについて考慮する） |
|                                                                      |
| ３）鋼材の許容応力度（ゲート等の機械設備を除く）                     |
|                                                                      |
| 13. 構造用鋼材の母材部及び溶接部の許容応力度（N/mm^2^）              |
|                                                                      |
| +--------+--------+--------+--------+--------+-----+-----+-----+     |
| | 鋼     | SS400  | SM490  | SM490Y | SM570  |     |     |     |     |
| | 材記号 |        |        |        |        |     |     |     |     |
| |        | SM400  |        | SM520  | S      |     |     |     |     |
| | 区     |        |        |        | MA570W |     |     |     |     |
| | 分及び | S      |        | S      |        |     |     |     |     |
| |        | MA400W |        | MA490W |        |     |     |     |     |
| | 応力度 |        |        |        |        |     |     |     |     |
| | の種類 |        |        |        |        |     |     |     |     |
| +========+========+========+========+========+=====+=====+=====+     |
| | 母 材  | 引　張 | 140    | 185    | 210    | 255 |     |     |     |
| | 部     |        |        |        |        |     |     |     |     |
| |        | 圧　縮 | 140    | 185    | 210    | 255 |     |     |     |
| |        |        |        |        |        |     |     |     |     |
| |        | せん断 | 80     | 105    | 120    | 145 |     |     |     |
| +--------+--------+--------+--------+--------+-----+-----+-----+     |
| | 溶接部 | 工     | 全断面 | 引　張 | 140    | 185 | 210 | 255 |     |
| |        | 場溶接 | 溶込み |        |        |     |     |     |     |
| |        |        | グルー | 圧　縮 | 140    | 185 | 210 | 255 |     |
| |        |        | プ溶接 |        |        |     |     |     |     |
| |        |        |        | せん断 | 80     | 105 | 120 | 145 |     |
| +--------+--------+--------+--------+--------+-----+-----+-----+     |
| |        |        | すみ   | せん断 | 80     | 105 | 120 | 145 |     |
| |        |        | 肉溶接 |        |        |     |     |     |     |
| |        |        | ，部分 |        |        |     |     |     |     |
| |        |        | 溶込み |        |        |     |     |     |     |
| |        |        | グルー |        |        |     |     |     |     |
| |        |        | プ溶接 |        |        |     |     |     |     |
| +--------+--------+--------+--------+--------+-----+-----+-----+     |
| |        | 現     | 引　張 | 原則と |        |     |     |     |     |
| |        | 場溶接 |        | して、 |        |     |     |     |     |
| |        |        | 圧　縮 | 工場溶 |        |     |     |     |     |
| |        |        |        | 接と同 |        |     |     |     |     |
| |        |        | せん断 | じ値と |        |     |     |     |     |
| |        |        |        | する。 |        |     |     |     |     |
| +--------+--------+--------+--------+--------+-----+-----+-----+     |
|                                                                      |
| ４）鋼管杭の許容応力度                                               |
|                                                                      |
| 14. 鋼管杭の母材部及び溶接部の許容応力度（N/mm^2^）                  |
|                                                                      |
| +--------                                                            |
| --------------+----------+--------+--------------------------+-----+ |
| | 鋼管杭の                                                           |
| 種類　       | SKK400   | SKK490 |                          |     |  |
| |                                                                    |
|               |          |        |                          |     | |
| | 区分及び                                                           |
| 応力度の種類 |          |        |                          |     |  |
| +========                                                            |
| ==============+==========+========+==========================+=====+ |
| | 母材部                                                             |
|               | 引　張   | 140    | 185                      |     | |
| +--------                                                            |
| --------------+----------+--------+--------------------------+-----+ |
| |                                                                    |
|               | 圧　縮   | 140    | 185                      |     | |
| +--------                                                            |
| --------------+----------+--------+--------------------------+-----+ |
| |                                                                    |
|               | せん断   | 80     | 105                      |     | |
| +--------                                                            |
| --------------+----------+--------+--------------------------+-----+ |
| | 溶接部                                                             |
|               | 工場溶接 | 引　張 | 140                      | 185 | |
| +--------                                                            |
| --------------+----------+--------+--------------------------+-----+ |
| |                                                                    |
|               |          | 圧　縮 | 140                      | 185 | |
| +--------                                                            |
| --------------+----------+--------+--------------------------+-----+ |
| |                                                                    |
|               |          | せん断 | 80                       | 105 | |
| +--------                                                            |
| --------------+----------+--------+--------------------------+-----+ |
| |                                                                    |
|               | 現場溶接 | 引　張 | 原則として，工場溶接と同 |     | |
| |                                                                    |
|               |          |        |                          |     | |
| |                                                                    |
|               |          |        | じ値とする。             |     | |
| +--------                                                            |
| --------------+----------+--------+--------------------------+-----+ |
|                                                                      |
| ５）既製コンクリート杭の許容応力度                                   |
|                                                                      |
| JIS　に基づき適切に定める。                                          |
|                                                                      |
| ６）許容応力度の割増し                                               |
|                                                                      |
| 作用                                                                 |
| の組合せにおいて地震の影響、施工時荷重等を考慮する場合は、表6-14によ |
| る許容応力度の割増しを行うことができる。下記以外の作用の組合せによる |
| 許容応力度の割増しを考慮する場合は、個々の状況に応じて適切に定める。 |
|                                                                      |
| 15. 許容応用力度の割増し                                             |
|                                                                      |
|   短　期　荷　重             割増率（％）                            |
|   -------------------------- --------------                          |
|   地震の影響を考慮する場合   50                                      |
|   施工時荷重を考慮する場合   50                                      |
+----------------------------------------------------------------------+

[]{#_Toc85298186 .anchor}

1.  各部位の設計等

    1.  []{#_Toc85298187 .anchor}本体

＜考え方＞

+----------------------------------------------------------------------+
| 床止め本体は、河床の洗掘を防いで河床を安定させ、河川の縦断又         |
| は横断形状の維持に必要な機能を満足する適切な位置へ設ける必要がある。 |
|                                                                      |
| 本体の設置位置の考え方は「6.3設計の基本」に示す通りとする。          |
|                                                                      |
| 本体の縦断形状は、直                                                 |
| 壁型と緩傾斜型に大別できる。選定に当たっては、設置する河道の特性を踏 |
| まえ、環境及び景観的な観点も含めた総合的な比較検討を行った方が良い。 |
|                                                                      |
| 天端高と落差は、「6.3設計の基本」に示す内容によ                      |
| り設計し、構造形式や端部の取り合いを考慮のうえ、設定する必要がある。 |
|                                                                      |
| 天端幅は0.5m程度が最小と考えられるが、河床材料により天端幅を         |
| 広く確保する場合や、滑動などに対する安全性より求める場合がある。転石 |
| が多い河川に設置する場合は、流出土砂による衝撃に耐えられるとともに、 |
| 通過土砂の摩耗にも耐えうるような幅とした方が良い。流出土砂による衝撃 |
| や摩耗の程度は、設置場所での河道特性により異なるため、注意を要する。 |
+----------------------------------------------------------------------+

＜必　須＞

  --------------------------------------------------------------------------
  床止め本体は、設計荷重に対して安全な構造となるように設計するものとする。
  --------------------------------------------------------------------------

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------
  床止め本体は、自重、土圧、静水圧、揚圧力、地震時慣性力等を考慮して、所要の安全性が確保されるように設計することを基本とする。
  ------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

+----------------------------------------------------------------------+
| １）本体の設計                                                       |
|                                                                      |
| コンクリート構造の床止めの場合は、転倒、滑                           |
| 動、基礎地盤支持力に対する所要の安全性が確保されるように設計すること |
| が求められる。無筋構造とする場合は、本体と水叩きとが一体式構造となっ |
| ていても、不測の事態を考慮して、図6-12のように本体単独で安定計算を行 |
| う必要がある。転倒については、本体底面について検討を行う必要がある。 |
|                                                                      |
| 本体と水叩きと                                                       |
| の間に必要な配筋がなされた鉄筋コンクリート構造の場合は、一体式構造と |
| 見なして図6-13に示す荷重に対する安定検討を行い、一体式構造として設計 |
| を行う場合は、従来の安定検討に加えて配筋部分の応力検討が必要となる。 |
|                                                                      |
| ![ダイアグラム                                                       |
| 自                                                                   |
| 動的に生成された説明](media/image44.png){width="3.391524496937883in" |
| height="1.9659339457567804in"}                                       |
|                                                                      |
| 14. 一体式構造と見なさない場合（常時、洪水時の場合）                 |
|                                                                      |
| ![ダイアグラム, 設計図                                               |
| 自動的に生成された説明](media/image45.png){width="3.53125in"         |
| height="2.1770833333333335in"}                                       |
|                                                                      |
| 15. 一体式構造と見なす場合（常時、洪水時の場合）                     |
|                                                                      |
| 滑動及び基礎地盤支持力は、直接基礎にあって                           |
| は、地盤と底面との摩擦抵抗力及び基礎地盤支持力について検討し、杭基礎 |
| 等である場合には鉛直支持力と水平支持力について検討を行う必要がある。 |
|                                                                      |
| 屈とう性構造の床止めは、流水                                         |
| の作用に対して安全であることが必要である。このため、床止め本体を構成 |
| するブロックや鉄筋などが流水により移動や過大な変形を生じない形状、重 |
| さ、材質とする必要がある。また、土砂の吸出しや揚圧力によるパイピング |
| を防止するため、吸出し防止材をブロック構造体の下に敷設すると同時に、 |
| 揚圧力により基礎の土砂が動かないように、床止め本体の下流側斜面勾配は |
| レインのクリープ比Cの逆数よりも緩くすることが望ましい（図6-14参照）  |
| 。また，ブロックの下端長は浸透経路長として評価することも必要である。 |
|                                                                      |
| ![ダイアグラム                                                       |
| 自動                                                                 |
| 的に生成された説明](media/image46.png){width="3.9769531933508313in"  |
| height="1.316813210848644in"}                                        |
|                                                                      |
| 16. ブロック構造による落差工の模式図                                 |
|                                                                      |
| コンクリート構造の床止め本体の安定計算法の例を次に示す。             |
| これは直接基礎の場合の例であり、常時、洪水時及び地震時について行う。 |
|                                                                      |
| (1)荷重                                                              |
|                                                                      |
| 設計に用いる荷重                                                     |
| は、自重、地震時慣性力、土圧（一般にクーロンの式により常時、地震時の |
| 土圧を計算）、水圧（常時：流量規模に応じた上・下流側の最大水位差、地 |
| 震時：上下流ともに平水時の水位差）、揚圧力である（図6-15)。揚圧力は  |
| 、水叩きの長さと上下流水位差とにより、次式により計算するものとする。 |
|                                                                      |
| ![テキスト, 手紙                                                     |
| 自                                                                   |
| 動的に生成された説明](media/image47.png){width="5.333333333333333in" |
| height="1.65625in"}                                                  |
|                                                                      |
| ![ダイアグラム, 設計図                                               |
| 自動的に生成された説明](media/image48.png){width="4.0in"             |
| height="2.03125in"}                                                  |
|                                                                      |
| 17. 床止めに作用する揚圧力                                           |
|                                                                      |
| (2)転倒に対する検討                                                  |
|                                                                      |
| 底面下流端部に関する                                                 |
| 常時、地震時のモーメントを計算し、合力の作用点を計算して偏心距離を求 |
| め、転倒に対する安全率が規定以上「6.5.2（1）常時の安全性能」、「6.5. |
| 2（2）洪水時の安全性能」「6.5.2（3）耐震性能」になるように設計する。 |
|                                                                      |
| (3)滑動に対する検討                                                  |
|                                                                      |
| 直接基礎の場合、滑動に対する安全率が「6.5.2（1）常                   |
| 時の安全性能」、「6.5.2安全性能の照査（2）洪水時の安全性能」、「6.5. |
| 2安全性能の照査（3）耐震性能」の安全率の規定以上になるよう設計する。 |
|                                                                      |
| (4)基礎地盤支持力に対する検討                                        |
|                                                                      |
| 直接基礎においては、「6.4.2構造形式の設定（3）設計用定数②地盤に係    |
| る定数」に示す地盤許容支持力度が鉛直最大反力以上になるよう設計する。 |
|                                                                      |
| 安定計算は、重力擁壁としての                                         |
| 安定計算法を用いて行う。なお、基礎地盤支持力に対する検討としては、揚 |
| 圧力が生じない状態（水位が底面以下の場合）を確認しておく必要がある。 |
|                                                                      |
| 床止め本体を一体と見なさずに設計する場合                             |
| は、コンクリート本体の応力計算は行わなくてもよいが、比較的地盤の軟弱 |
| な個所や、背後地に及ぼす影響の大きい個所に設置する床止めについては、 |
| 鉄筋直径0.013mの用心鉄筋を表面付近に0.25m間隔程度で配筋をする場合も  |
| ある。一体構造とする場合には，応力計算を行って必要な鉄筋量を求める。 |
+----------------------------------------------------------------------+

＜例　示＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------
  玉石が多く流下する河川では天端幅を2.0m、砂混じりの砂利や玉石混じりの砂利が多く流下する河川では天端幅を1.0mとしているなど、天端幅を大きくしている事例がある。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------

1.  []{#_Toc85298190 .anchor}水叩き

＜考え方＞

+----------------------------------------------------------------------+
| 水叩きは、本体からの越流水による洗掘、流水や転石による衝撃から構造物 |
| の破損を防ぐために設置するものである。床止めの被災形態としては、本体 |
| 、水叩き等の下部でのパイピング現象による基礎地盤支持力の低下、流水や |
| 転石による水叩きへの直接衝撃、流水による下流部の洗掘、堤体下部からの |
| 吸出し及び揚圧力に起因する移動等が考えられる。したがって、水叩きは、 |
| 洗掘等を防げる長さと揚圧力に耐えうる重量（厚さ）を有する必要がある。 |
|                                                                      |
| また、上流から流下する流水や転石に                                   |
| よる水叩きへの直接衝撃や大規模な洗掘に対しては、水叩きを所要の長さを |
| 有する強固な構造とし、下流部の洗掘に対しては所要の長さを有する護床工 |
| を設置して対処するとともに、間詰め石などにより吸出しを防止する必要が |
| ある。パイピングについては、「6.5.2安全性能の照査」を参照されたい。  |
|                                                                      |
| 水叩きの縦断形状は、流水の減勢や魚類等の移動を考慮して、下流河床よ   |
| りも掘り込んでウォータークッションを設ける等の工夫を図る必要がある。 |
+----------------------------------------------------------------------+

＜必　須＞

  --------------------------------------------------------------------------------------------------
  水叩きは、必要な水密性を有する構造とし、設計荷重に対して安全な構造となるよう設計するものとする。
  --------------------------------------------------------------------------------------------------

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------
  水叩きは、本体を越流する水の侵食作用や水や転石による直接衝撃による構造物の破損を防ぎ、下面から働く揚圧力に対して安全な長さ及び構造とすることを基本とする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

+----------------------------------------------------------------------+
| 水                                                                   |
| 叩きの設計に当たって、長さ、厚さを以下の通り考慮することが望ましい。 |
|                                                                      |
| １）水叩きの長さ                                                     |
|                                                                      |
| 水叩きの長さの計算は、本体から越流水                                 |
| の落下距離を求めることで行う。越流水の落下距離の計算にはさまざまな方 |
| 法があり、石田・井田の公式に代表されるような流量公式に自由落下現象を |
| 組み合わせる方法もある。ここでは簡易的に求めることができるRAND(1955) |
| の公式を示す。                                                       |
|                                                                      |
| W/D＝4.3（hc/D）^0.81^　　　　　　　　　　　　　　　　　　　         |
|                                                                      |
| ここに、W：水叩き長、D：落差高、hc：限界水深                         |
| である。この式は床止め天端で限界水深が発生する場合に適用できる。     |
|                                                                      |
| 床止め上の越流現象は、hc＋D＞h~2~の場合に完全越流                    |
| であり、hc＋D＝h~2~の付近で潜り越流へ変化して水叩き部へ与える落下衝  |
| 撃力が小さくなる。したがって、水叩き長の計算は低水流量から計画流量の |
| うちで完全越流から潜り越流に変化する限界の条件（一般にはhc＋D＝h~2~  |
| でよい）について行う。                                               |
|                                                                      |
| 常に越流現象が潜り越流になっている場合は、水叩きは特に必要ない。     |
| 実際の現象としては、hc＋D＝h~2~付近では完全越流と潜り越流との過渡状  |
| 態である不完全越流状態となる。したがって、水叩きへの落下衝撃も完全越 |
| 流時よりも弱まってくる。しかし、ここでは設計での判断を単純化するため |
| にhc＋D＝h~2~を境界とし、完全越流、潜り越流に分類して扱っても良い。  |
|                                                                      |
| ![](media/image49.emf){width="4.622641076115485in"                   |
| height="1.629199475065617in"}                                        |
|                                                                      |
| 18. 完全越流時の水面形状                                             |
|                                                                      |
| ![](media/image50.emf){width="4.953450349956255in"                   |
| height="1.4624212598425197in"}                                       |
|                                                                      |
| 19. 潜り越流時の水面形状                                             |
|                                                                      |
| ２）水叩きの厚さ                                                     |
|                                                                      |
| 水叩きは、水叩きにかかる揚圧力に対して安定となる重量（厚さ）とする   |
| 。ただし、水叩きの最小部材厚は、衝撃や耐久性等から0.4m以上としておく |
| ことが望ましい。水叩き厚さの計算は、本体、水叩きが鉄筋コンクリートで |
| 一体化している場合は、本体の安定検討から求められる。鉄筋構造の場合は |
| 、次式により水叩きにかかる最大揚圧力から求められるのが一般的である。 |
|                                                                      |
| ![](media/image51.png){width="4.729166666666667in"                   |
| height="1.3796391076115486in"}                                       |
|                                                                      |
| 水叩きの縦断形状は、魚類等の遡上等、流水の減勢等を考慮して、下       |
| 流の河床よりも掘り込んでウォータークッションを設ける等の工夫を図る。 |
|                                                                      |
| また、水叩き等では、流水等の                                         |
| 侵食作用によるコンクリート表面の摩耗、礫の落下や転石による直接衝突に |
| よるコンクリート表面のひび割れや剥離が生じやすいため、必要に応じて、 |
| コンクリート自体の摩擦抵抗性を高めるほか、摩耗抵抗性の高い材料によっ |
| てコンクリート表面を保護する等の摩耗の進行を抑制する対策を検討する。 |
+----------------------------------------------------------------------+

＜例　示＞

  ----------------------------------------------------------------------------------------------------------------------------------
  水叩きのコンクリート表面の摩耗の進行を抑制するため、高強度コンクリートや高強度モルタル等の材料による表面保護を施した事例がある。
  ----------------------------------------------------------------------------------------------------------------------------------

＜参考となる資料＞

水叩きの設計に当たっては、下記の資料が参考となる。

1.  表面保護工法 設計施工指針（案），平成17年4月，土木学会.

    1.  []{#_Toc85298191 .anchor}護床工

＜考え方＞

+----------------------------------------------------------------------+
| 護床工は、床止め上下流で生じる局所洗掘の防止                         |
| や、高速流の減勢のために本体及び水叩き上下流側に設置するものである。 |
|                                                                      |
| 護床工の構造、床止め上下流の河床勾配、落差、洪水時の流速             |
| 、平水時の流況による生態系への影響，河床の地質等を勘案して選定する。 |
|                                                                      |
| 例えば、水叩き下流                                                   |
| での跳水の発生により激しく流水が減勢される区間（護床工A）では、鉄筋  |
| により連結されたブロック構造かコンクリート構造等が用いられ、その下流 |
| の整流となる区間（護床工B）では、できるだけ流勢を減殺する工法として  |
| 、一般には、コンクリートブロックや粗朶沈床、木工沈床、改良沈床等が用 |
| いられる。護床工Bは、できるだけ屈とう性を持たせ、護床工Bの下流端では |
| 河床とのなじみをよくする。このように護床工Aから護床工Bにかけて硬い構 |
| 造のものから軟らかい構造のものへと変化させるような配慮が必要である。 |
|                                                                      |
| 下流側の護床工の範囲は、落差                                         |
| 工による流水の影響がなくなると推定される範囲までとし、上流側の護床工 |
| の範囲は計画高水位時の上流側の水深と同様の距離以上とする必要がある。 |
|                                                                      |
| 特に急流河川では、下                                                 |
| 流側の護床工Aが長くなる場合が多いので、これを短くするために流れの減  |
| 勢を目的とした補助構造物を水叩き又は護床工に設置し、これにより強制的 |
| に跳水を発生させエネルギーを減勢する方法がある。強制跳水に必要な補助 |
| 構造物としてはエンドシル、バッフルピア、段上がりがある。魚類等のため |
| には、段上がりとしてウォータークッションの水深を深くする方法がよい。 |
+----------------------------------------------------------------------+

＜必　須＞

  ----------------------------------------------------------------------------------------------------
  護床工は、必要な屈とう性を有する構造とし、近傍流速に対して安全な構造となるよう設計するものとする。
  ----------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 護床工は、本体及び水                                                 |
| 叩き上下流での洗掘を防ぐため、その上下流側に設けることを基本とする。 |
|                                                                      |
| 護床工は、水叩き下流での                                             |
| 跳水の発生により激しく流水が減勢される区間ではコンクリート構造等、そ |
| の下流の整流となる区間では屈とう性を有する構造とし、本体上下流での洗 |
| 掘を防ぐことができる長さ及び構造となるよう設計することを基本とする。 |
+----------------------------------------------------------------------+

＜推　奨＞

+----------------------------------------------------------------------+
| 上流側護床工及                                                       |
| び下流側護床工の設計に当たっては、長さ、重量は以下のとおり考慮する。 |
|                                                                      |
| １）護床工の長さ                                                     |
|                                                                      |
| (1)上流側護床工                                                      |
|                                                                      |
| 床止め上流側の護床工は、床止め                                       |
| 直上流で生ずる局所洗掘を防止し、本体及び河岸部の取付擁壁を保護するこ |
| とを目的としている。本体天端高より上流側河床高が低下すると、本体直上 |
| 流部では渦流の発生が促進され、局所洗掘が発生しやすい。水理実験や既設 |
| 事例によれば、最低でも計画高水位時の水深程度以上の長さは必要である。 |
|                                                                      |
| (2)下流側護床工                                                      |
|                                                                      |
| 床止め下流側の護床工の長さは、水叩き下流での跳水の発生により激し     |
| く流水が減勢される区間（護床工A）と、その下流の整流区間（護床工B）と |
| に分けて求めることができる（図6-18)。各区間での計算方法を次に示す。  |
|                                                                      |
| ![ダイアグラム, 設計図                                               |
| 自                                                                   |
| 動的に生成された説明](media/image52.png){width="4.541666666666667in" |
| height="1.84375in"}                                                  |
|                                                                      |
| 20. 下流側護床工の区分                                               |
|                                                                      |
| a)護床工Aについて                                                    |
|                                                                      |
| 護床工Aの区間長Lは，L＝L~1~＋L~2~で表すことができる。                |
|                                                                      |
| L~1~：落下後から跳水発生までの射流で流下する区間                     |
|                                                                      |
| L~2~：跳水発生区間                                                   |
|                                                                      |
| 射流区間長L~1~と跳水発生区間長L~2~の                                 |
| 計算は、低水流量から計画流量までの流量について床止め本体から落下した |
| 流水の跳水現象を検討することにより以下の手法で計算することができる。 |
|                                                                      |
| ①越流落下水深h~1a~の計算                                             |
|                                                                      |
| Ⅰ-Ⅱ断面（図6-16                                                      |
| 参照）間の関係はエネルギー保存式にV~1a~＝q/h~1a~(q：単位幅流量）を代 |
| 入して加の多項式とし、トライアル計算により越流落下水深h1aを求める。  |
|                                                                      |
| ②跳水開始水深h~1b~の計算                                             |
|                                                                      |
| Ⅲ-Ⅳ(図6-16参照）断面間で発生している跳水の開始水                     |
| 深を床止め下流部の水深h~2~、床止め下流部のフルード数F~2~より求める。 |
|                                                                      |
| ③本体直下流水深h1aと跳水開始水深h~1b~との比較                        |
|                                                                      |
| ア．h~1a~＝h~1b~の場合                                               |
|                                                                      |
| > h~1a~＝h~1b~の                                                     |
| 場合、跳水は本体越流落下直下流より発生する。したがって、射流区間L~1~ |
| は発生せず、跳水発生区間長L~2~のみの計算となる。跳水発生区間長は下流 |
| 水深の4.5～6倍程度であるため、護床工A区間長Lは次式により算出される。 |
| >                                                                    |
| > L＝L~2~＝(4.5～6)·h~2~　　　　　                                   |
|                                                                      |
| イ．h~1a~＞h~1b~の場合                                               |
|                                                                      |
| > h~1a~＞h~1b~の場合は、もぐ                                         |
| り跳水となるため護床工A区間を特に設置する必要はない。ただし、河床上  |
| で噴流が走る可能性があるため、護床工B区間長を長めに取る必要がある。  |
|                                                                      |
| ウ．h~1a~＜h~1b~の場合                                               |
|                                                                      |
| > h~                                                                 |
| 1a~＜h~1b~の場合は、水叩き下流端でから跳水が発生するまで射流区間が発 |
| 生し、位置が本体越流落下点より下流へ移動するため、この分護床工Aを長  |
| くする必要がある。したがって、護床工A区間長Lは次式により算出される。 |
| >                                                                    |
| > L＝L~1~＋L~2~　　　　　　                                          |
| >                                                                    |
| > L~1~は、h~1a~がh~1b~の水位ま                                       |
| で上昇する間の長さであり、水面形を求めることにより求められる。よって |
| 必要な護床工A区間長Lは、先の跳水の発生区間の長さと併せて次式となる。 |
| >                                                                    |
| > L＝L~1~＋L~2~＝L~1~＋(4.5～6)·h~2~　　　　                         |
| >                                                                    |
| >                                                                    |
|  急流河川では、跳水発生前の射流区間L~1~が長くなりすぎ、護床工Aの施工 |
| 延長が長くなってしまうことがある。この場合には、エンドシル、バッフル |
| ピア、段上がり等による強制跳水でL~1~区間を短縮する方法が有効である。 |
|                                                                      |
| b)護床工Bについて                                                    |
|                                                                      |
| 護床工Bは、跳水終了後の整流および下流河床とのすり                    |
| 付けのために設置される。設置範囲は水理模型実験結果などによると，下流 |
| 側計画高水位時の水深の3～5倍程度必要であることが明らかになっている。 |
|                                                                      |
| ２）護床ブロック重量                                                 |
|                                                                      |
| 護床工のブロックの重量は，各区間で                                   |
| ブロックに作用する近傍流速を用いて，力学的な安定等から定めるものとす |
| る（護岸の根固め等を参照）。以下には、近傍流速の考え方の一例を示す。 |
|                                                                      |
| (1)上流側護床工                                                      |
|                                                                      |
| 床止め上流の平均流速を用いる。                                       |
|                                                                      |
| (2)下流側護床工                                                      |
|                                                                      |
| ①護床工A                                                             |
|                                                                      |
| 護床工Aは流れが激しく乱れ                                            |
| 、かつ高流速となる場である。したがって護床工A区間では、一般にブロッ  |
| クを鉄筋で連結して、ブロック全体で外力に対抗できるような群体とする。 |
| この区間の近傍流速は、次の2つの区間に分けて検討する（図6-19参照）。  |
|                                                                      |
| ![ダイアグラム, 設計図                                               |
| 自                                                                   |
| 動的に生成された説明](media/image53.png){width="4.489583333333333in" |
| height="2.25in"}                                                     |
|                                                                      |
| 21. 下流側護床工の長さの区分                                         |
|                                                                      |
| イ．本体直下流～跳水発生区間前半L~2~/2                               |
|                                                                      |
| > 本体直下流から跳水が発生するまでの区間L~1~から跳水発生区間前半L~2  |
| ~/2は高流速で流下するため、設計流速V~d~＝本体直下流流速V~1a~とする。 |
|                                                                      |
| ロ．跳水発生区間後半                                                 |
|                                                                      |
| > 跳水発生区間後半部では、上記区間よりも流速が緩くなっている。しか   |
| し、どの程度速度が緩くなっているかについては定かではない。大体本体直 |
| 下流と護床工下流の流速の平均程度と見積もっておくとよいと考えられる。 |
| >                                                                    |
| > 設計流速(Vd)＝｛本体直下流流速(V1a)＋下流流速(V2)}×1/2             |
|                                                                      |
| ②護床工B                                                             |
|                                                                      |
| > 護床工B下流の跳水後の水位での平均流速を用いる（V~d~＝V~2~）。      |
+----------------------------------------------------------------------+

[]{#_Toc85298192 .anchor}

1.  基礎

＜考え方＞

+----------------------------------------------------------------------+
| 床                                                                   |
| 止め本体の基礎は、直接基礎が一般的である。その他の基礎として杭基礎が |
| あるが、直接基礎で十分に本体等を支持できない場合に杭基礎を採用する。 |
|                                                                      |
| 基礎の設計に当たっては、道路橋示方書（Ⅳ下部構造編）・同解            |
| 説（平成24年3月）、杭基礎に当たっては杭基礎設計便覧（平成27年3月）に |
| より設計するものとする。道路橋示方書は平成29年11月に、杭基礎設計便覧 |
| は令和2年9月に改訂されている。これらの改訂では、性能規定（限界状態設 |
| 計法及び部分係数法）に対応した記述に見直しており、従来の仕様規定（許 |
| 容応力度設計法）とは異なる設計体系となっている。一方、堰の耐震設計以 |
| 外の設計は、性能規定化に至っておらず本基準においても仕様規定での設計 |
| 体系である。そのため、道路橋示方書、杭基礎設計便覧の設計法を適用する |
| 場合は、従来の仕様規定について記載しているものを適用する必要がある。 |
+----------------------------------------------------------------------+

＜必　須＞

  ------------------------------------------------------------------------------------------------------------
  基礎は、上部荷重等によって不同沈下を起こさないよう、良質な地盤に安全に荷重を伝達する構造とするものとする。
  ------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 基礎は、本体及び水叩きと取付擁壁                                     |
| 、魚道の間に不同沈下が発生し堤防の弱点とならないようにするため、本体 |
| 及び水叩きと取付擁壁、魚道の下に同一の基礎で設けることを基本とする。 |
|                                                                      |
| 基礎の形式及び構造は、良                                             |
| 質な地盤に安全に荷重を伝達できるよう適切に選定することを基本とする。 |
+----------------------------------------------------------------------+

＜例　示＞

  ------------------------------------------------------------------------------------------------------------
  良質な地盤の目安としては、砂層、砂礫層においてはN値が概ね30以上。粘性土層ではN値が概ね20以上と考えてよい。
  ------------------------------------------------------------------------------------------------------------

＜参考となる資料＞

基礎の設計に当たっては、下記の資料が参考となる。

1.  道路橋示方書・同解説 Ⅳ下部構造編，平成24年3月，（公社) 日本道路協会.

    （最新版）道路橋示方書・同解説Ⅳ下部構造編，平成29年11月,（公社）日本道路協会.

```{=html}
<!-- -->
```
17. 杭基礎設計便覧（平成26年度改訂版），平成27年3月，（公社)
    日本道路協会.

    （最新版）杭基礎設計便覧（令和2年度改訂版），令和2年9月,(公社)日本道路協会.

    1.  []{#_Toc85298193 .anchor}遮水工

＜考え方＞

+----------------------------------------------------------------------+
| 遮水工は、上下流の水位                                               |
| 差で生じるおそれのある揚圧力やパイピング作用を減殺するために設ける必 |
| 要がある。本体および水叩き端部に設けられる遮水工は、取付擁壁及び護岸 |
| に設置する遮水工と連続させるものとする。また、取付擁壁に設ける遮水工 |
| は、本体及び水叩き端部に設けられる遮水矢板と同規模とする必要がある。 |
|                                                                      |
| 遮水工の深さ及び水平方向の長さ                                       |
| は、水頭差、遮水工の配置を考慮したうえで、レインの式などによる浸透経 |
| 路長を検討し設定する必要がある。また、遮水工には構造計算上の荷重は分 |
| 担させない。遮水工は一般的に鋼矢板が用いられるが、鋼矢板以外の材料と |
| する場合は材料の強度、耐久性、遮水効果について検討を行う必要がある。 |
+----------------------------------------------------------------------+

＜必　須＞

  ------------------------------------------------------------------------------------------------------------
  遮水工は、必要な水密性を有する構造とし、地盤条件や施工条件に対して安全な構造となるよう設計するものとする。
  ------------------------------------------------------------------------------------------------------------

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------
  遮水工は、上下流の水位差で生じるおそれのある揚圧力やパイピング作用を減殺する構造として設計することを基本とする。
  ------------------------------------------------------------------------------------------------------------------

＜推　奨＞

+----------------------------------------------------------------------+
| １）配置                                                             |
|                                                                      |
| 遮水工は、内外水位差                                                 |
| による浸透水の動水勾配を減少させ、本体、水叩き下部の土砂移動と洗掘に |
| よる土砂の吸出しを防止するために図6-20のように設けることが望ましい。 |
|                                                                      |
| ![ダイアグラム                                                       |
| 自                                                                   |
| 動的に生成された説明](media/image54.png){width="4.882638888888889in" |
| height="2.480628827646544in"}                                        |
|                                                                      |
| 22. 遮水工の設置平面図                                               |
|                                                                      |
| ２）構造                                                             |
|                                                                      |
| 遮水工は、本体と離脱しない                                           |
| ように配慮して設計することが望ましい。遮水工の根入れ長は、鉛直方向の |
| 浸透経路で計算するが、遮水工を2列に入れる場合、実現象の流線を考える  |
| と一般に遮水工間隔の1/2以内の長さにすることが望ましい。なお、1/2以上 |
| の長さとなる場合は、水叩きの長さを伸ばすなどの処置をする場合が多い。 |
|                                                                      |
| ３）鋼矢板を遮水工として用いる場合の留意点                           |
|                                                                      |
| 鋼矢板は遮水工として用いる場合、安全性、現場条件及び鋼矢板の市       |
| 場性を考慮したうえで、経済比較を行い、適切に選定することが望ましい。 |
+----------------------------------------------------------------------+

＜例　示＞

基礎地盤が良好な場合の直接基礎で鋼矢板の施工が困難な場合は、コンクリート構造のカットオフとする場合がある。

1.  []{#_Toc85298194 .anchor}取付擁壁・護岸

＜考え方＞

+----------------------------------------------------------------------+
| 洪水                                                                 |
| 時には河床そのものが動いており、床止めの設置によってその連続性が失わ |
| れるので、その上下流において射流の有無にかかわらず、局所的な洗掘が生 |
| じやすい。したがって、床止めの上下流の河岸又は堤防は、しかるべき範囲 |
| に護岸を設ける必要がある。その範囲は、上流側は床止めの上流端から10m  |
| の地点又は護床工の上流端から5m                                       |
| の地点のうちいずれか上流側の地点、下流側は水叩きの下流端から15m      |
| の地点又は護床工の下流端から5m                                       |
| の地点のうちいずれか                                                 |
| 下流側の地点までの範囲を最低限として設ける必要がある（図6-21参照）。 |
|                                                                      |
| なお、床止め下流側では落下した流れが                                 |
| 護岸に衝突し、護岸が損傷する恐れがあるため、これを防止するため、取り |
| 付け擁壁を直壁とし、水叩き部の幅を拡幅する等の工夫を行う必要がある。 |
|                                                                      |
| この                                                                 |
| 区間のうち、床止めから越流落下水により跳水が発生する取付区間では、特 |
| に流水の乱れが激しく、河岸部に強いせん断力が発生し、また、高水敷から |
| の落込流による河岸侵食のおそれもある。このため、この区間では強固な河 |
| 岸防護工として取付擁壁構造の護岸を設置する必要がある（図6-22参照）。 |
|                                                                      |
| ![](media/image55.png){width="3.2354166666666666in"                  |
| height="2.3125in"}                                                   |
|                                                                      |
| 23. 床止めの設置に伴い必要となる護岸を設置する最小範囲               |
|                                                                      |
| ![](media/image56.emf){width="3.8270833333333334in"                  |
| height="3.295138888888889in"}                                        |
|                                                                      |
| 24. 護岸を設ける区間のうち取付擁壁構造の護岸とする区間               |
|                                                                      |
| 取付擁壁は、仮に床止め本体が被災しても堤防に影響が及ばないよう       |
| 、擁壁の底面は水叩きや護床工の底面より低い所に設ける（図6-23参照）。 |
|                                                                      |
| ![](media/image57.png)                                               |
|                                                                      |
| 25. 取付擁壁                                                         |
|                                                                      |
| 護岸の形式及び構造は、改訂                                           |
| 護岸の力                                                             |
| 学設計法を参考に設定する必要がある。護岸には、多くの形式があり、使用 |
| される素材、構造の外観等はさまざまであるが、設置箇所の河道特性や周辺 |
| の護岸形式及び構造に加え、環境や景観にも配慮して設計する必要がある。 |
+----------------------------------------------------------------------+

＜必　須＞

+----------------------------------------------------------------------+
| 護岸は、流水の変化に伴う河岸又は堤防の洗掘を防止するために設け       |
| るものとし、設計流速に対して安全な構造となるよう設計するものとする。 |
|                                                                      |
| また、取付擁                                                         |
| 壁の構造は、堤防の機能を損なわず流水の乱れに伴って生じる河岸侵食を防 |
| 止するように、仮に床止め本体及び水叩きが消失しても安定である構造（床 |
| 止め本体及び水叩きをなしとした場合の安定計算を行う必要がある）とする |
| ものとし、必要に応じて周辺景観との調和に配慮して設計するものとする。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 床止めの設置に伴い必要                                               |
| となる取付擁壁・護岸は、以下の事項を設計に反映することを基本とする。 |
|                                                                      |
| １）床止めの設置に伴い必要となる護岸は、以下により設定する。         |
|                                                                      |
| > ①床止めに接する河岸又は堤防の護岸は、上流側は床止めの上流端から10m |
| > の地点又は護床工の上流端から5m                                     |
| >                                                                    |
|  の地点のうちいずれか上流側の地点から、下流側は水叩きの下流端から15m |
| > の地点又は護床工の下流端から5m                                     |
| > の地点のうちいずれか下流側の地点までの区間以上の区間に設ける。     |
| >                                                                    |
| > ②前項に掲げるもののほか、河岸又は堤防の護岸は、湾曲部              |
| であることその他河川の状況等により特に必要と認められる区間に設ける。 |
| >                                                                    |
| > ③河岸（低水路の河岸を除く）又は堤防の護岸の高                      |
| さは、計画高水位（高潮区間にあっては、計画高潮位）とするものとする。 |
| >                                                                    |
| > ただし、床止めの設置に伴い流水                                     |
| が著しく変化することとなる区間にあっては、河岸又は堤防の高さとする。 |
| >                                                                    |
| > ④低水路の河岸の護岸の高さは、低水路の河岸の高さとするものとする。  |
|                                                                      |
| ２）取付擁壁の設置範囲は、床止め下流側では跳水の発生区間（護床工A    |
| の範囲まで）を原則とする。                                           |
| 上流側では、低下背水による流速の増大に対する安全を見込み、本体より5m |
| 程度上流まで取付擁壁を設ける。                                       |
|                                                                      |
| ３）床止め本体及び水叩き                                             |
| と取付護岸との接合部は絶縁し、擁壁の底面は水叩きや護床工の底面より1m |
| 程度低い所に設けるほか、                                             |
| 護床工下流の擁壁及び護岸前面には根固工を設ける等により洗掘に備える。 |
+----------------------------------------------------------------------+

＜推　奨＞

  -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  直壁形状の取付擁壁は、拡幅した形状として下流の河岸に取り付けられるが、この場合、下流の河岸部においては、取付擁壁に沿う流れと本体を直進してきた流れが集中することによって局所で大きな洗掘力が生じる。このため、取付擁壁の下流側護岸とのすり付け角度は、流水のはく離が生じないとされている角度とすることが望ましい。その角度は、既往の実験結果によると、11 度程度を目安とするとはく離流の発生が防止できるという結果が得られている。
  -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜参考となる資料＞

取付擁壁・護岸の設計に当たっては、下記の資料が参考となる。

1.  （財）国土技術研究センター：改訂 護岸の力学設計法, 平成 19 年 9 月.

    （最新版）改訂 護岸の力学設計法，2023，（一財）国土技術研究センター.

    1.  []{#_Toc85298195 .anchor}高水敷保護工・のり肩工

＜考え方＞

+----------------------------------------------------------------------+
| 床止                                                                 |
| めの被災原因の1つに高水敷の洗掘があげられる。これは、高水敷から低水  |
| 路へ落ち込む流れや、逆に乗り上げる流れなどの床止め周辺の局所流によっ |
| て生じるものである。特に、このような流れが強くなることが予想される場 |
| 所では、高水敷保護工、のり肩工を設置して高水敷を保護する必要がある。 |
|                                                                      |
| 高水敷保護工及びのり肩工は、かごマット、連節ブ                       |
| ロック等の屈とう性のあるもので、洪水時の掃流力に耐えうるものとする。 |
|                                                                      |
| ![ダイアグラム, 概略図                                               |
| 自動                                                                 |
| 的に生成された説明](media/image58.png){width="3.8950076552930883in"  |
| height="3.36000656167979in"}                                         |
|                                                                      |
| 26. 高水敷保護工の敷設例                                             |
+----------------------------------------------------------------------+

＜必　須＞

  --------------------------------------------------------------------------------------------------------------------------------------
  高水敷保護工及びのり肩工は、床止めに接続する高水敷の洗掘を防止するために設けるものとし、設計流速に対して安全な構造とするものとする。
  --------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 高水敷保護工は、流水等の作用による高水敷の洗掘を防                   |
| 止するため、高水護岸前面に設けることを基本とする。高水敷保護工の構造 |
| は、河川の生態系の保全等の河川環境の保全に配慮した構造を基本とする。 |
|                                                                      |
| 高水敷保護工は、「6.6.6                                              |
| 取付擁壁・護岸」で示す護岸の範囲において設けることを基本とする。     |
+----------------------------------------------------------------------+

＜推　奨＞

図6-22に示す高水敷保護工の設置範囲は、最低基準値であるので、必要な場合は、数値計算（必要に応じて水理模型実験）等による流速評価を行い、設置範囲を決定するのが望ましい。

1.  []{#_Toc85298196 .anchor}魚道

＜考え方＞

+----------------------------------------------------------------------+
| 床止めは低                                                           |
| 水路部分を横断して設置される構造物であり、構造によっては魚類等の遡上 |
| を妨げるものであることから、魚道の設置について検討を行う必要がある。 |
|                                                                      |
| 検討にあたり土砂堆積の影響が懸念                                     |
| される場合等には、維持管理の容易性及び経済性等に配慮する必要がある。 |
|                                                                      |
| 魚ののぼりやすい床止めの構造には、本体と分離して魚道を設ける場合     |
| と本体（緩傾斜型）の全断面を魚道とする場合等がある。落差が小さい場合 |
| には落差工天端に切欠きを設ける構造や天端をV字型とする構造も考えられ  |
| るが、切り欠く深さ，幅等によっては洪水時に流れが集中することにより、 |
| 床止め上下流に著しい洗掘をもたらす危険性があるので、影響が大きいと想 |
| 定される場合は、水理模型等により対策工を含めた検討を行う必要がある。 |
|                                                                      |
| 魚道の構造形式の                                                     |
| 選定に当たっては、対象とする魚種（回遊性のエビ・カニ類等も含む、以下 |
| 魚類等）、設置位置、流況に応じて行う。また、平常時及び中小出水時の流 |
| 況を把握して魚類等の遡上・降下の特性に適したものとなるよう検討する。 |
+----------------------------------------------------------------------+

＜必　須＞

+----------------------------------------------------------------------+
| 床止めを設ける場合に                                                 |
| おいて、魚類の遡上等を妨げないようにするために必要があるときは、魚道 |
| を設けるものとする。魚道の構造は、次に定めるところによるものとする。 |
|                                                                      |
| １）床止めの直上流及び直下流部における通                             |
| 常予想される水位変動に対して魚類の遡上等に支障のないものとすること。 |
|                                                                      |
| ２）床止めに接続する河床の状況、魚道                                 |
| の流量、魚道において対象とする魚類等を適切に考慮したものとすること。 |
+----------------------------------------------------------------------+

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------
  魚道の規模、形式の決定に当たっては、対象となる魚類等の習性や魚道通過時の成長の度合いを考慮することを基本とする。
  ------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

5.  魚がのぼりやすい川づくりの手引き，平成17年3月，国土交通省河川局.

＜参考となる資料＞

魚道の設計に当たっては、下記の資料が参考となる。

1.  最新　魚道の設計，平成10年8月，一般社団法人ダム水源地環境整備センター.

```{=html}
<!-- -->
```
18. 技術者のための魚道ガイドライン，平成23年9月，NPO法人
    北海道魚道研究会.

19. 多自然型魚道マニュアル，平成10年1月，リバーフロント整備センター.

    1.  []{#_Toc85298197 .anchor}床止め構造に関するその他事項

＜考え方＞

+----------------------------------------------------------------------+
| １）ICTやBIM/CIMの利用                                               |
|                                                                      |
| i-Construction推進の一環として、IC                                   |
| Tによる建設生産プロセスのシームレス化が取り組まれている。UAV写真測量 |
| やレーザースキャナー計測などで得られる3次元点群データを活用すること  |
| で、現況地形や既設物の構造を様々な角度・断面から把握することができる |
| 。新設・改築する施設のBIM/CIMモデル（3次元モデル＋属性情報）を作成し |
| 活用することにより、構造に関して関係者の理解と合意形成が促進される。 |
| このため、施工段階、施工後の点検・補修・修繕の段階においてBIM/CIMを  |
| 積極的に活用し、床止め及び床止め周辺の堤防を適切に維持管理していくこ |
| とができるように、設計成果を3次元モデルに反映しておくと有用である。  |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  国土交通省：CIM 導入推進委員会：CIM 導入ガイドライン（案），令和 3
    年 3 月

    （最新版）国土交通省：BIM/CIM 活用ガイドライン（案），令和 4 年 3
    月.

第1章　河川構造物の設計 {#第1章-河川構造物の設計-4 .目次の見出し1}
=======================

第7節　堰 {#第7節-堰 .目次の見出し1}
=========

目　次 {#目-次-3 .目次の見出し1}
======

[第7節 堰 1](#_Toc501958011)

> [7．1 総説 1](#_Toc100563580)
>
> [7．1．1 適用範囲 1](#_Toc100563581)
>
> [7．1．2 用語の定義 1](#_Toc100563582)
>
> [7．2 機能 3](#_Toc100563583)
>
> [7．3 設計の基本 3](#_Toc100563584)
>
> [7．4 基本的な構造 7](#_Toc100563585)
>
> [7．4．1 流下断面及び堰径間長の設定 7](#_Toc100563586)
>
> [7．4．2 ゲート開閉時の高さの設定 9](#_Toc32437637)
>
> [7．4．3 門柱の天端高 10](#_Toc100563594)
>
> [7．4．4 材質と構造 11](#_Toc32437640)
>
> [7．4．5 堰周辺の堤防 18](#_Toc54776105)
>
> [7．5 安全性能の照査等 19](#_Toc90575594)
>
> [7．5．1 設計の対象とする状況と作用 19](#_Toc90575595)
>
> [7．5．2 安全性能の照査 25](#_Toc32437643)
>
> [7．5．3 許容応力度 31](#_Toc47014734)
>
> [7．6 各部位の設計等 32](#_Toc100563605)
>
> [7．6．1 本体 32](#_Toc100563606)
>
> [7．6．2 水叩き 48](#_Toc100563615)
>
> [7．6．3 護床工 51](#_Toc100563616)
>
> [7．6．4 基礎 51](#_Toc100563617)
>
> [7．6．5 遮水工 53](#_Toc100563618)
>
> [7．6．6 取付擁壁・護岸 54](#_Toc100563619)
>
> [7．6．7 高水敷保護工 56](#_Toc100563620)
>
> [7．6．8 魚道，閘門、土砂吐き 57](#_Toc100563621)
>
> [7．6．9 付属施設 58](#_Toc100563622)
>
> [7．6．10 既存施設の自動化・遠隔化 59](#_Toc100563625)
>
> [7．7 堰構造に関するその他の事項 60](#_Toc100749537)

令和４年６月　版

適用上の位置付け

　河川砂防技術基準設計編は、基準の適用上の位置付けを明確にするために、下表に示すように適用上の位置付けを分類している。

+--------+------------------+------------------+------------------+
| 分　類 | 適用上の位置付け | 末尾の字句例     |                  |
+--------+------------------+------------------+------------------+
| 考え方 | 技術資料         | ●目              | 「･･･ある。      |
|        |                  | 的や概念、考え方 | 」「･･･いる。」  |
|        |                  | を記述した事項。 |                  |
|        |                  |                  | 「･･･なる。      |
|        |                  |                  | 」「･･･れる。」  |
+--------+------------------+------------------+------------------+
| 必　須 | 技術基準         | ●法令による規定  | 「･･･なければ    |
|        |                  | や技術的観点から | ならない。」「･  |
|        |                  | 実施すべきである | ･･ものとする。」 |
|        |                  | ことが明確であり |                  |
|        |                  | 遵守すべき事項。 |                  |
+--------+------------------+------------------+------------------+
| 標　準 | 技術基準         | ●特              | 「･･･            |
|        |                  | 段の事情がない限 | を標準とする。」 |
|        |                  | り記述に従い実施 |                  |
|        |                  | すべきだが、状況 | 「･･･            |
|        |                  | や条件によって一 | を基本とする。」 |
|        |                  | 律に適用すること |                  |
|        |                  | はできない事項。 | 「･･･による。」  |
+--------+------------------+------------------+------------------+
| 推　奨 | 技術資料         | ●状況や条件      | 「               |
|        |                  | によって実施する | ･･･望ましい。」  |
|        |                  | ことが良い事項。 |                  |
|        |                  |                  | 「               |
|        |                  |                  | ･･･推奨する。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･務める。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･必要に応    |
|        |                  |                  | じて･･･する。」  |
+--------+------------------+------------------+------------------+
| 例　示 | 技術資料         | ●適用条件や実施  | 「               |
|        |                  | 効果について確定 | ･･･などの手法（  |
|        |                  | している段階では | 事例）がある。」 |
|        |                  | ないが、状況や条 |                  |
|        |                  | 件によっては導入 | 「･･･など        |
|        |                  | することが可能な | の場合がある。」 |
|        |                  | 新技術等の例示。 |                  |
|        |                  |                  | 「･･･など        |
|        |                  | ●状              | が考えられる。」 |
|        |                  | 況や条件によって |                  |
|        |                  | 限定的に実施でき | 「               |
|        |                  | る技術等の例示。 | ･･･の場合には･･･ |
|        |                  |                  | ことができる。」 |
|        |                  | ●具体的          |                  |
|        |                  | に例示することに | 「               |
|        |                  | より、技術的な理 | ･･･例示する。」  |
|        |                  | 解を助ける事項。 |                  |
|        |                  |                  | 「例えば･･･。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･事例もある  |
|        |                  |                  | 。･･･もよい。」  |
+--------+------------------+------------------+------------------+

  関連通知等       関連する通知やそれを理解する上で参考となる資料
  ---------------- ------------------------------------------------------
  参考となる資料   例示等に示した手法・内容を理解する上で参考となる資料

1.  []{#_Toc501958011 .anchor}堰

    1.  []{#_Toc100563580 .anchor}総説

        1.  []{#_Toc100563581 .anchor}適用範囲

＜考え方＞

+----------------------------------------------------------------------+
| 本節は、堰を新設あるいは改築する場合の設計に適用する。               |
| ただし、既設の堰の安全性能の照査にも構造形式や現地の状況等に応じ準用 |
| することができる。また、本節で扱う堰とは、河川の水位を調節して、都市 |
| 用水や灌漑用水等の取水や、塩水の遡上の防止、河川を分派する等の目的の |
| ために河道を横断して設置する施設で、河道の縦断形を将来にわたって制御 |
| する施設である。堰と水門又は樋門との区別は、関連通知を参照されたい。 |
|                                                                      |
| なお、構造上の分類とし                                               |
| て、堰は、可動堰と固定堰に分けられ、ゲートによって水位の調整ができる |
| ものを可動堰といい、調節のできないものを固定堰（又は洗い堰）という。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------+
| > 本節は、堰を新設あるいは改築する場合の設計に適用する。 |
+----------------------------------------------------------+

＜関連通知＞

1.  河川管理施設等構造令，昭和 51 年 7 月 20 日，政令第199号．

    1.  []{#_Toc100563582 .anchor}用語の定義

＜考え方＞

+----------------------------------------------------------------------+
| 堰は、本体、水叩き                                                   |
| 、護床工、基礎、遮水工、取付擁壁・護岸、高水敷保護工、魚道、閘門、土 |
| 砂吐き及び管理橋・操作室等の付属施設の各部位によって構成される。この |
| うち、本体は、ゲート、床版、堰柱、門柱、ゲートの操作台で構成される。 |
|                                                                      |
| 引上げ式ゲートを有する可動堰の場合の各部位の名称は図7-1による。      |
|                                                                      |
| 固定堰の各部位の名称は図7-2による。                                  |
|                                                                      |
| ![](media/image59.png){width="1.3575076552930883in"                  |
| height="1.0714905949256344in"}                                       |
|                                                                      |
| ![ダイアグラム, 設計図                                               |
| 自動                                                                 |
| 的に生成された説明](media/image60.png){width="2.5678291776027997in"  |
| height="5.232557961504812in"}                                        |
|                                                                      |
| 27. 堰の各部位の名称（引上げ式ゲートを有する可動堰の場合）           |
|                                                                      |
| > ![ダイアグラム, 設計図                                             |
| >                                                                    |
| 自動的に生成された説明](media/image61.png){width="4.0490791776028in" |
| > height="1.4660094050743657in"}                                     |
|                                                                      |
| 28. 堰の各部位の名称（固定堰の場合）                                 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| > 次の各号に掲げる用語の定義をそれぞれ以下に示す。                   |
| >                                                                    |
| > 一．径間長：隣り合う堰柱の中心間距離                               |
| >                                                                    |
| > 二．堰周辺の堤防：堰の周辺の堤防で、堰本体、魚                     |
| 道や土砂吐きとの取り付けに伴う開削や杭基礎等の施工の影響を受ける範囲 |
+----------------------------------------------------------------------+

1.  []{#_Toc100563583 .anchor}機能

＜考え方＞

+----------------------------------------------------------------------+
| 堰は主に以下のとおり分類され、そ                                     |
| れぞれの設置目的を達成するために必要な機能を有することが求められる。 |
|                                                                      |
| １）分流堰：河川の分派                                               |
| 地点に設け、水位を調節又は制限して洪水又は低水を計画的に分流させる。 |
|                                                                      |
| ２）潮止堰：感潮区間に設け、塩水の遡上を防止する。                   |
|                                                                      |
| ３）取水堰                                                           |
| ：河川の水位を調節して、都市用水、灌漑用水及び発電用水等を取水する。 |
|                                                                      |
| ４）その他の堰：河川の水位及び流量（流水）を調節する                 |
| 多目的堰。河口堰は潮止堰としての機能を有する多目的の堰の場合が多い。 |
+----------------------------------------------------------------------+

＜必　須＞

  ------------------------------------------------------------------------------------------------------------------------------------------------
  堰は、設置目的に応じて、分流機能、潮止め機能、取水等を目的とした水位及び流量（流水）調節機能のうち、必要な機能を有するよう設計するものとする。
  ------------------------------------------------------------------------------------------------------------------------------------------------

　　　

＜関連通知等＞

1.  河川管理施設等構造令，昭和 51 年 7 月 20 日，政令第199号．

    1.  []{#_Toc100563584 .anchor}設計の基本

＜考え方＞

+----------------------------------------------------------------------+
| 堰の設計に当                                                         |
| たっては、以下の事項について検討し、設計に反映することが求められる。 |
|                                                                      |
| １）基本方針                                                         |
|                                                                      |
| 堰は「7.2                                                            |
| 機能」に示す事項を満足すると                                         |
| 共に、想定される外力に対して安全な構造となるよう設計する必要がある。 |
|                                                                      |
| 堰は河                                                               |
| 川を横断して設ける施設であることから、堰に接続する高水敷や堤防の洗掘 |
| の防止について適切に配慮された構造とし、堰周辺や湛水区間の堤防等が一 |
| 連区間の中で相対的な弱点とならないよう設計する必要がある。また、堰は |
| 河床高を固定することから、予め、これまでの河川整備と洪水等による長期 |
| 的な河道の応答を分析し、堰の新設又は改築による効果や影響が河道の変化 |
| にどのように顕れるかを考慮の上、堰の位置、平面形状及び方向、縦断形状 |
| 、敷高や可動部・水通しの位置等の施設の設置条件を検討する必要がある。 |
|                                                                      |
| なお、河川改修や取水位置の変更                                       |
| など様々な理由により、堰などの河道内の構造物を改築し、旧施設を撤去す |
| る場合には、周辺の堤防、河床や河岸及びその他の河川管理施設等への影響 |
| が生じることも想定される。このため、長期的な河道の応答を分析したうえ |
| で、一部施設の残置や撤去方法など必要な対策工等を検討する必要がある。 |
|                                                                      |
| 堰の位置や敷高については河道計画で概略設定しているが、堰設置後の将来 |
| 的な河床変動を考慮して、位置や敷高を見直すものとする。特に、堰設置後 |
| の河床変動が激しく、維持管理が容易でないことが想定される場合には河道 |
| 計画を見直すことも考える。河道計画を見直した場合には、堰設置後の河床 |
| 変動特性を再度確認し、河道の維持管理に支障が生じないことを確認する。 |
|                                                                      |
| 河川整備においては、河川法の目的である河川環境                       |
| の整備と保全を踏まえ、河川が本来有している自然環境や多様な景観の保全 |
| ・創出が図られることが基本であることから、堰の設計に当たっては、生物 |
| の生息・生育の環境や水辺環境、周辺の景観等との調和を図る必要がある。 |
|                                                                      |
| 堰は、河川の低水路を横断して設置される工作物であり                   |
| 魚類の遡上等を妨げる場合が多いことから、構造令第44条の規定に基づき第 |
| 35条の2の規定を準用し、魚道を設置するなどの対策を講じる必要がある。  |
|                                                                      |
| ２）堰の位置                                                         |
|                                                                      |
| 堰の位置の決定に当たっては、堤内地の地形、地盤高、水路系             |
| 統、水路敷高及び洪水時の本川の特性等を調査する。調査結果及び「計画編 |
| 施設配置等計画編 第2章 河川施設配置計画 第2-1章 河道並びに河川構造物 |
| 第5節 堰、水門、樋門                                                 |
| 5.1設置の基本」を踏まえ、堰の位置を決定                              |
| する。なお、狭窄部（山間狭窄部は除く。）、水衝部、支川の合流部、河床 |
| の変動が大きい箇所、みお筋の不安定な箇所をできるだけ避けて計画する。 |
| また、河川に設けられている他の工作物（橋、伏せ越し等）に近接した箇所 |
| 、堤内地の排水に影響を及ぼすおそれのある箇所、堰の計画湛水位が堤内地 |
| 盤より高くなる箇所に設置する場合は、影響を緩和するための対策を行う。 |
|                                                                      |
| ３）平面形状及び方向                                                 |
|                                                                      |
| 堰を流下する流水は、通常、堰と                                       |
| 直角の方向に流れるものであり、その平面形状によっては、下流側の水衝作 |
| 用を助長したり、局所洗掘の原因となることが多い。従来、取水の都合から |
| 、斜堰が用いられた例も少なくないが、このような理由から、堰の河川横断 |
| 方向の線形は洪水の流心方向に直角の直線形とし、堰柱の方向は、洪水の流 |
| 心方向とすることを基本とする。なお、中小河川において、下流部での局所 |
| 洗掘や堰付近での洪水流の著しい乱れ等による治水上の支障が生じるおそれ |
| がない場合は、円弧形の緩傾斜(全面魚道タイプ)の堰とすることができる。 |
|                                                                      |
| ４）縦断形状                                                         |
|                                                                      |
| 堰の設置によって河道の縦断形が変化し、堰上                           |
| 流河道では河床上昇が、堰下流河道では河床低下が生じる可能性があるため |
| 、河道の維持管理が容易でない場合には河道計画を見直すことも考える。河 |
| 道計画を見直した後、堰設置後の河床変動特性を再度確認する必要がある。 |
|                                                                      |
| ５）堰の敷高                                                         |
|                                                                      |
| 堰の敷高（又は固定部）は、一般に、設計・管理の目安となる河床高と     |
| 一致させる。ただし、設計・管理の目安となる河床高と比較し現況河床高が |
| 低い場合においては、上下流の河床高を考慮し適切に設定する必要がある。 |
|                                                                      |
| ６）端部の構造(嵌入等)                                               |
|                                                                      |
| 堰本体の端部処理については、堰取り付け部の                           |
| 上下流を擁壁構造の護岸とし、堤体に嵌入しない。これは、堤体に嵌入した |
| 場合、堰取り付け部の護岸が被災し、一方で堰本体が残存することにより堤 |
| 防にまで被災が及ぶ危険性があるためである。また、複断面河道では、高水 |
| 敷上の流水が高水敷や本体下流部の河岸の洗掘を生じさせ堤防の決壊を起こ |
| す可能性があることから、これを防止するため、高水敷に保護工を設ける。 |
|                                                                      |
| ７）堰柱                                                             |
|                                                                      |
| イ　堰柱の幅と断面形状　                                             |
|                                                                      |
| 堰柱の幅については、ゲートの大きさ、堰柱の高さ、地盤の土質条件等によ |
| って左右されるため、構造令には特にそれを規定する条項が定められていな |
| いが、技術的に無理のない範囲で、極力狭くするよう配慮する必要がある。 |
| 堰柱(管理橋の橋脚を含む)による河積の阻害率(計画高水位における流向と  |
| 直角方向の洪水吐き部の堰柱の幅の総和が川幅(無効河積分を除く)に占める |
| 割合)(図7-3参照)は、おおむね10％を超えないものとする。やむを得ずこれ |
| を超える場合は堰柱のせき上げによる水位上昇量や背水区間の計算を行い、 |
| 上流水位に影響を与える場合には、河積拡大等の措置を講ずる必要がある。 |
|                                                                      |
| なお、堰柱の断面形状については、洪水時の流水抵抗を少な               |
| くするため、できるだけ細長い楕円形又はこれに類する形状のものとする。 |
|                                                                      |
| > ![ダイアグラム, 設計図                                             |
| > 自                                                                 |
| 動的に生成された説明](media/image62.png){width="4.160008748906387in" |
| > height="1.640003280839895in"}                                      |
|                                                                      |
| 29. 堰の阻害率                                                       |
|                                                                      |
| ロ　両端の堰柱の位置                                                 |
|                                                                      |
| 堰の構造は付近の河岸及び河川管理施設等                               |
| の構造に著しい支障を及ぼさず、堰に接続する河床及び高水敷の洗掘の防止 |
| について適切に配慮された構造とする必要があり、両端の堰柱の位置は、計 |
| 画堤防を著しくおかさないよう配慮する必要がある。両端の堰柱を堤防内に |
| 設ける場合には、それが堤防の弱点となるおそれがある。一方、両端の堰柱 |
| を堤防外に設ける場合には、堤防との間に無効河積が生じて堰による河積の |
| 阻害が大きくなることに加え、堤防との間が流木等により閉塞しやすくなる |
| おそれがある。これらを総合的に勘案の上、両端の堰柱の位置を決定する。 |
|                                                                      |
| また、堰が低水路部分のみに設けられる場合には、原則として、低水路の   |
| のり肩線に堰柱の内側(ゲート側)を合わせるものとするが、低水路の断面積 |
| が上下流に比べて著しく大となるとき及び起伏堰にあっては、堰の設置前の |
| 低水路断面積と等値となるよう両端の堰柱の位置を決定して差し支えない。 |
|                                                                      |
| ８）ゲート設備                                                       |
|                                                                      |
| ゲートは、                                                           |
| 確実に開閉（起伏）し、かつ、必要な水密性及び耐久性を有する構造が求め |
| られる。開閉装置は、ゲートの開閉（起伏）を確実にできる構造が求められ |
| る。また、常用電源が喪失した場合に備え、予備電源や予備動力、補助開閉 |
| 装置を設けるなど、ゲートの開閉に必要な機能を維持することが求められる |
| 。なお、地域特性に応じて、自動化、遠方操作化や遠隔操作化を検討する。 |
|                                                                      |
| ９)安全、確実・円滑な施工                                            |
|                                                                      |
| 堰の施工では、仮締切によ                                             |
| り生じる揚圧力や掘削によるボイリングなど、安全を脅かす状況が発生する |
| 可能性がある。このため、設計においても、安全で確実・円滑な施工が可能 |
| となるような配慮が求められ、施工上の制約から構造が決まることもある。 |
|                                                                      |
| １０)機能を長期的に容易に維持できる構造                              |
|                                                                      |
| 長期的に機能を低下させる要因としては、部材等の経年劣化、流砂等に     |
| よる部材の摩耗、圧密による地盤変位の進行、河床変動や土砂堆積、堰下面 |
| 、護岸背面等における土砂の吸出しがあり、これらに配慮する必要がある。 |
|                                                                      |
| 門柱については、断面形状を凹凸の小さな単純なものとする等によ         |
| り、部材としての耐荷機構が明確で耐震性に優れた構造とする必要がある。 |
|                                                                      |
| １１）維持管理に配慮した構造                                         |
|                                                                      |
| 堰の点検、修繕、更新等の維持管理に配慮した構造にする必要がある。     |
+----------------------------------------------------------------------+

＜必　須＞

+----------------------------------------------------------------------+
| 堰の設計に当たっては、以下の事項を反映するものとする。               |
|                                                                      |
| 1.  計画高水位（高潮区間にあっては、計                               |
| 画高潮位）以下の水位の流水の作用に対して安全な構造とするものとする。 |
|                                                                      |
| 2.  計画高水位以下の水                                               |
| 位の洪水の流下を妨げることなく、堰周辺の堤防、河岸及び河川管理施設等 |
| の構造に著しい支障を及ぼさず、並びに堰に接続する河床及び高水敷等の洗 |
| 掘等の防止について適切に配慮された構造となるよう設計するものとする。 |
|                                                                      |
| 3.  常用電源が喪失した場                                             |
| 合においても必要最小限の開閉操作が可能となるよう設計するものとする。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 堰の設計に当たっては、以下の事項を反映することを基本とする。         |
|                                                                      |
| １                                                                   |
| ）堰に求められる機能を満足するために、堰の平面形状及び方向、端部・堰 |
| 柱構造や両端の堰柱の位置を設定するとともに、設計の対象とする状況と作 |
| 用に応じた安全性能を設定し、照査によりこれを満足することを確認する。 |
|                                                                      |
| ２）堰に求められる機能を満足するために、上下流の河                   |
| 床洗掘が発生しにくく、土砂が堆積しにくい構造となるよう設計するととも |
| に、維持管理上、堆積土砂等の排除に支障のない構造となるよう設計する。 |
|                                                                      |
| ３                                                                   |
| ）環境及び景観との調和、構造物の耐久性、維持管理の容易性、施工性、事 |
| 業実施による地域への影響、経済性及び公衆の利用等を総合的に考慮する。 |
|                                                                      |
| ４）土質・地質調査、河道特性や自然環境等を                           |
| 把握するため現地条件や設置目的に応じて必要な調査を計画して実施する。 |
+----------------------------------------------------------------------+

＜推　奨＞

+----------------------------------------------------------------------+
| 事前の地盤調査                                                       |
| は、土層構成、土質、地下水の状況などを把握し、設計に必要な地盤性状及 |
| び土層の特性等の条件を設定するため、ボーリング調査・原位置試験及び室 |
| 内土質試験の組合せで実施することが望ましい。なお、事前の地盤調査結果 |
| より軟弱地盤や透水性地盤が想定される場合には、各々の課題に対応した原 |
| 位置試験等の調査・試験を実施したうえで設計に反映することが望ましい。 |
|                                                                      |
| また、環境面では、護岸等のブロックに適度な空隙や                     |
| 粗度を発生させ水生生物の生息や移動（生態系ネットワーク）等に支障が生 |
| じないように工夫した設計を、景観面については、コンクリートブロックの |
| 明度（護岸の明度は６以下を目安）やテクスチャー(輝度の標準偏差は11以  |
| 上を目安)、表面の景観パターン等に留意した設計を行うことが望ましい。  |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  美しい山河を守る災害復旧基本方針(平成30年6月), p.87-94,
    2018,国土交通省水管理・国土保全局防災課.

＜参考となる資料＞

環境や景観に配慮した設計については、下記の資料が参考となる。

1.  多自然川づくりポイントブックⅢ，p.120-136，（財）リバーフロント整備センター，2011,多自然川づくり研究会.

    1.  []{#_Toc100563585 .anchor}基本的な構造

        1.  []{#_Toc100563586 .anchor}流下断面及び堰径間長の設定

```{=html}
<!-- -->
```
13. 流下断面

＜考え方＞

+----------------------------------------------------------------------+
| 堰の設置                                                             |
| に当たっては、設置の必然性があり、かつ、治水上、河川環境上著しく支障 |
| がない構造とする必要がある。これは、堰の固定部（又は固定堰）は、洪水 |
| の流下に与える影響も極めて大きく、洪水氾濫の原因となった事例が見受け |
| られるためであり、適切に洪水の流下断面（計画高水流量を計画高水位以下 |
| で安全に流下させるために必要な断面をいう。）の確保を図る必要がある。 |
|                                                                      |
| 土砂吐き、舟通し、魚道等については、利水、利用                       |
| 、環境上の機能確保のため必要に応じて設けるが、それらを現状又は計画の |
| 流下断面内に設けることは、堰上流部における洪水時の水位上昇、下流部に |
| おける局所洗掘等を招き、洪水による被害の危険性を増大させる。したがっ |
| て、堰の固定部となるこれらの施設は、流下断面内には設けてはならない。 |
|                                                                      |
| 堰の設置に当たっては、以下の事項について反映することが求められる。   |
|                                                                      |
| １）現況河道と堰                                                     |
| の設計時の横断形が著しく異なる場合において、堰の機能が著しく阻害され |
| るおそれのあるときは、堰の設置時期と関連する河川整備の実施時期につい |
| ての調整を行うとともに、関連の河川整備の促進を図ることが考えられる。 |
|                                                                      |
| ２）山間狭窄部であることその他河川の状況、地形の状                   |
| 況等により治水上の支障がないと認められるなど、堰（固定堰を含む）の設 |
| 置地点に堤防（計画堤防を含む）がない場合であって、かつ、堰の設置によ |
| る治水上の影響が堰の上下流に及ばない場合は、治水上の機能の確保のため |
| 適切と認められる措置を講ずることにより、流水を流下させるためのゲート |
| 及びこれを支持する堰柱等の可動部以外の部分及び固定堰は、流下断面内に |
| 設けることができる。上流への影響がない場合とは、土砂吐き、舟通し、魚 |
| 道、固定部又は固定堰等を流下断面内に設けることによって背水の影響が、 |
| 堰の上流部に存する堤防、家屋、農地等に及ばない場合をいうものである。 |
| 下流への影響がない場合とは、河積阻害により、堰設置地点又は堰の上流付 |
| 近から越水し、堰付近の家屋、農地等に浸水、又はこの越流水が堰付近の低 |
| 部又は水路等を通じて、下流側の堤内地に流入するおそれのない場合をいう |
| ものである。山間狭窄部等の下流付近に堰を設ける場合が多いが、その場合 |
| は特にこの点に留意する必要がある。構造令第39条第１項の表の第3欄に掲  |
| げる値に満たない土砂吐き又は舟通し並びに魚道等は無効河積としてせき上 |
| げ水位の計算を行う必要がある。小規模な堰では、河床上昇については、固 |
| 定堰又は固定部の天端高を起点として、現況河床勾配の1/2勾配で推定し、  |
| せき上げ水位については不等流計算で推定する方法がよく用いられている。 |
|                                                                      |
| 30. せき上げ水位の計算イメージ                                       |
|                                                                      |
| ３）土砂吐き、                                                       |
| 舟通し、魚道等（固定堰は除く）を流下断面外に設けるとその機能が発揮さ |
| れない場合があるが、河床の状況によりやむを得ないと認められる場合には |
| 、次のような措置を講ずることにより、流下断面内に設けることができる。 |
|                                                                      |
| > ①河道の横断形又は現状の流下断面積をそれぞれ小さくすることなく      |
| 、かつ、治水上支障のない範囲で部分的に低水路の法線形を修正する場合。 |
| >                                                                    |
| > ②構造令第39                                                        |
| 条（可動堰の可動部の径間長の特例）第1項の表の第3欄に掲げる径間長に満 |
| たない可動部（土砂吐き及び舟通し、それらを設けることにより増えること |
| となる堰柱を含む。）及び魚道等は無効河積と考え、阻害される河積に相当 |
| する河積を低水路又は川幅の拡幅により別途確保する場合（図7-5参照）。  |
| >                                                                    |
| > 　                                                                 |
|                                                                      |
| ![ダイアグラム, 設計図                                               |
| 自動                                                                 |
| 的に生成された説明](media/image63.png){width="1.9694444444444446in"  |
| height="3.2694444444444444in"}                                       |
|                                                                      |
| 31. 拡張に伴う取付けの例                                             |
+----------------------------------------------------------------------+

＜必　須＞

+----------------------------------------------------------------------+
| ゲート、堰柱等の可動部以外の部分及び固定堰は、流下断面内に設         |
| けてはならない。ただし、山間狭窄部であることその他河川の状況、地形の |
| 状況等により治水上の支障がないと認められるとき、及び河床の状況により |
| 流下断面内に設けることがやむを得ないと認められる場合において、治水上 |
| の機能の確保のため適切と認められる措置を講ずるときはこの限りでない。 |
|                                                                      |
| また、洪水を分流させる堰については、上記内容を適用しない。           |
+----------------------------------------------------------------------+

14. 堰の径間長

＜考え方＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  堰の径間長は、河積の阻害を小さくするためできるだけ大きくとり、堰柱の数を減ずることが重要である。堰柱に流木が引っ掛かる等により閉塞が生じ、それが原因で災害が発生することがないよう流木長を考慮した径間長とする必要がある。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜必　須＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  堰の径間長は、堰が横断する河川を洪水時に流下する流木等による閉塞を防止するため、構造令第37条から第39条、施行規則第17条から第19条に基づき、堰の固定部（又は固定堰）を流下断面外とするとともに、計画流量に応じて定めた値以上となるように適切に設定するものとする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

1.  []{#_Toc32437637 .anchor}ゲート開閉時の高さの設定

```{=html}
<!-- -->
```
2.  引上げ式ゲートの最大引上げ時のゲート下端高

＜考え方＞

+----------------------------------------------------------------------+
| 堰は、引上げ式ゲートの最大引                                         |
| 上げ時において河川の所定の流下能力を確保できるようにする。そのため、 |
| 最大引上げ時のゲート下端高は、計画高水位との間に洪水時における流木等 |
| 流下物の浮上高等を考慮して、しかるべき空間が確保できるよう設定する必 |
| 要があり、一般的には、現状又は計画堤防高のいずれか高い方に合わせる。 |
|                                                                      |
| なお、引上げ式ゲートの最大引上げ時のゲー                             |
| ト下端高は、ゲートの維持管理に用いる保守点検に必要な揚程は含まない。 |
+----------------------------------------------------------------------+

＜必　須＞

+----------------------------------------------------------------------+
| 引上げ式ゲート                                                       |
| の最大引上げ時のゲート下端高は、以下の事項に基づき定めるものとする。 |
|                                                                      |
| １）引上げ式ゲートの最大引上げ                                       |
| 時のゲート下端高は、堰が横断する河川の計画高水位に構造令第20条第１項 |
| の表の下欄に掲げる値（以下「余裕高」という。）を加えた高さ以上で、高 |
| 潮区間においては計画高潮位を下回らず、その他の区間においては当該地点 |
| における河川の両岸の堤防（現状又は計画堤防高のいずれか高い方の堤防） |
| の表法肩を結ぶ線の高さを下回らないものとする。ただし、背水区間に設け |
| る場合のゲート下端高は、治水上の支障がないと認められるときは、次に掲 |
| げる高さのうちいずれか高い方の高さ以上とすることができるものとする。 |
|                                                                      |
| > 一　当該河川に背水が生じないとした                                 |
| 場合に定めるべき計画高水位に、計画高水流量に応じた余裕高を加えた高さ |
| >                                                                    |
| > 二　計画高水位 （高潮区間にあっては、計画高潮位）                  |
|                                                                      |
| ２）地盤沈下のおそれがある                                           |
| 地域に設ける場合のゲート下端高は、１）によるほか、予測される地盤沈下 |
| 及び河川の状況を勘案して必要と認められる高さを下回らないものとする。 |
|                                                                      |
| ３）洪                                                               |
| 水を分流させる堰については、前項１）及び前項２）の規定を適用しない。 |
+----------------------------------------------------------------------+

15. 起伏式ゲートの起立時のゲート上端高

```{=html}
<!-- -->
```
1.  起立時のゲート上端高

＜考え方＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  起伏式ゲートの起立時のゲート上端高は、堰の有する流水の制御機能を確保するため、堰の目的に応じた水位に基づいて設定する必要がある。ただし、起伏式ゲートは、下流側の堆砂等により不完全倒伏が懸念されるため、万一不完全倒伏という事態が起こってもそれが直ちに災害に結び付かないようにあらかじめ配慮しておく必要がある。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 起伏式ゲ                                                             |
| ートの起立時のゲート上端高は、以下の事項を反映することを基本とする。 |
|                                                                      |
| １）起伏式ゲートの起立時における上端高                               |
| は、設計・管理の目安となる河床高と計画高水位の中間の高さ以下とする。 |
|                                                                      |
| ２）起伏式ゲートの直高（起立                                         |
| 時のゲート上端高からゲート下流側の床版までの高さ）は、3m以下とする。 |
+----------------------------------------------------------------------+

＜推　奨＞

+----------------------------------------------------------------------+
| １）起伏式ゲートを洪水時においても土砂、竹木その他の流下物によっ     |
| て倒伏が妨げられない構造とするとき、又は治水上の機能の確保のため適切 |
| と認められる措置を講ずるときは、ゲートの起立時における上端高を堤内地 |
| 盤高又は計画高水位のうちいずれか低い方の高さ以下とすることができる。 |
|                                                                      |
| ２）起                                                               |
| 伏式ゲートを洪水時においても土砂、竹木その他の流下物によって倒伏が妨 |
| げられない構造とするときは、ゲート直高を3mより高くすることができる。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  ゴム袋体をゲート又は起伏装置に用いる堰のゴム袋体に関する基準（案）の策定について，平成27年3月31日,
    国総公第 94 号,国水環第 12 号,国水治第 148
    号,国土交通省総合政策局公共事業企画調整課長･水管理・国土保全局河川環境課長、治水課長.

＜参考となる資料＞

ゴム引布性起伏堰及び鋼製起伏ゲートの起立時のゲート上端高の設定については、下記の資料が参考となる。

1.  引布性起伏堰技術基準（案）,平成 12 年 9 月,(財)国土技術研究センター.

    （最新版）ゴム引布製起伏堰及び鋼製起伏堰（ゴム袋体支持式）のゴム袋体に関する技術資料
    ,平成 28 年 1 月,(一財)国土技術研究センター.

```{=html}
<!-- -->
```
20. 鋼製起伏ゲート設計要領（案）,令和2年10月,一般社団法人ダム・堰施設技術協会.

```{=html}
<!-- -->
```
2.  倒伏時のゲート上端高

＜考え方＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------
  起伏式ゲートは、倒伏時において河川の所定の流下能力を確保できるようにする。そのため、起伏式ゲートの倒伏時のゲート上端高は、設計・管理の目安となる河床高以下とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜必　須＞

+----------------------------------------------------------------------+
| 起伏式                                                               |
| ゲートの倒伏時のゲート上端高は、以下の事項に基づき定めるものとする。 |
|                                                                      |
| １）起伏式ゲートの倒伏時におけ                                       |
| る上端高は可動堰の基礎部（床版を含む。）の高さ以下とするものとする。 |
|                                                                      |
| ２）洪水を分流させる堰については、前項の規定を適用しない。           |
+----------------------------------------------------------------------+

[]{#_Toc100563594 .anchor}

1.  門柱の天端高

＜考え方＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  門柱は、主に引上げ式ゲートの開閉を行うために設け、ゲートの開閉が容易な構造とする必要がある。また、門柱の天端高は、最大引上げ時のゲート下端高が計画高水位との間に洪水時における流木等流下物の浮上高等を考慮して、しかるべき空間を確保するとともに、ゲートの維持管理・更新のための戸溝からの取外し等に必要な高さを確保する必要がある。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------
  引上げ式ゲートの場合の堰の門柱の天端高は、最大引上げ時のゲート下端高にゲートの高さ及びゲートの管理に必要な高さを加えた高さを確保するよう設計することを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

+----------------------------------------------------------------------+
| ゲートの管理に必要な高さとしては、引上げ余                           |
| 裕高(1m以上）のほか、滑車等の付属品の高さを考慮することが望ましい。  |
|                                                                      |
| ![ダイアグラム, 設計図                                               |
| 自動                                                                 |
| 的に生成された説明](media/image64.png){width="2.9654297900262465in"  |
| height="1.916765091863517in"}                                        |
|                                                                      |
| 32. 門柱                                                             |
+----------------------------------------------------------------------+

＜例　示＞

  ----------------------------------------------------------------------------------------------------------------------
  津波が想定される堰の場合には、段波波高又は段波による水位を考慮して門柱の天端高（操作台上面高）を決定した事例がある。
  ----------------------------------------------------------------------------------------------------------------------

1.  []{#_Toc32437640 .anchor}材質と構造

```{=html}
<!-- -->
```
1.  使用材料

＜考え方＞

  ------------------------------------------------------------------------------
  堰の使用材料は、設置目的に応じて要求される強度や耐久性を満足する必要がある。
  ------------------------------------------------------------------------------

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------
  堰の使用材料は、設置目的に応じて要求される強度や耐久性を満足するための品質を有し、その性状が明らかにされている材料を使用することを基本とする。
  ------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

+----------------------------------------------------------------------+
| 鉄筋コンクリート構造物（プレキャスト製品を除く）に用いるコン         |
| クリートの設計基準強度は24N/mm^2^、異形棒鋼の種類はSD345を推奨する。 |
|                                                                      |
| JIS等の公的な品質規格に適合し、その適合範囲が明らかな                |
| 用途に対して使用することが望ましい。公的な品質規格がない材料の場合に |
| は、材料特性が堰に及ぼす影響を試験等によって確認するとともに、品質に |
| ついてもJIS等との規格と同等以上であることを確認することが望ましい。  |
+----------------------------------------------------------------------+

16. 主な構造

＜考え方＞

+----------------------------------------------------------------------+
| 堰を構成す                                                           |
| る主な構造は鉄筋コンクリート構造又はこれに準ずる構造とし、ゲートにつ |
| いては引上げ式ゲート及び回転式ゲートは鋼構造又はこれに準ずる構造とす |
| る。起伏式ゲートは鋼構造又はゴム引布構造又はこれに準ずる構造とする。 |
|                                                                      |
| ま                                                                   |
| た、堰の安全性を確保するため、部材の安全性の確保と継手部の水密性の確 |
| 保によって、全体として必要な水密性を有する構造となるよう設計する必要 |
| がある。ここで、必要な水密性を有するとは、部材の損傷や劣化、継手部の |
| 開き等により堰周辺の堤防の土砂が吸い出されることのない状態を確保する |
| という意味であり、部材によっては多少の漏水が生じる状態は許容される。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 床版、堰柱、門柱、ゲートの操作台、水叩きは、鉄筋コンク               |
| リート構造又はこれに準ずる構造とすることを基本とする。床版、堰柱、門 |
| 柱、水叩き、遮水工は、部材の安全性と継手部の水密性の確保によって、全 |
| 体として必要な水密性を有する構造となるよう設計することを基本とする。 |
|                                                                      |
| 引上げ式ゲート及                                                     |
| び回転式ゲートは鋼構造又はこれに準ずる構造とし、起伏式ゲートは鋼構造 |
| 又はゴム引布構造又はこれに準ずる構造とし、ゲートは確実に開閉（起伏） |
| し、かつ必要な水密性を有する構造となるよう設計することを基本とする。 |
|                                                                      |
| ゲートの開閉装置は、ゲートの開閉（起                                 |
| 伏）を確実に行うことができる構造となるよう設計することを基本とする。 |
|                                                                      |
| 設計に当たっては、環境及び景観との調和を図ることを基本とする。       |
+----------------------------------------------------------------------+

＜推　奨＞

+----------------------------------------------------------------------+
| 引上げ式ゲートの場合の可動堰の本                                     |
| 体の構造形式は、一般に以下に示すものが用いられている（図7-7参照）。  |
|                                                                      |
| ![箱ひげ図                                                           |
| 自動的に生成された説明](media/image65.png){width="3.9375in"          |
| height="1.3116885389326334in"}                                       |
|                                                                      |
| 33. 可動堰本体の形式                                                 |
|                                                                      |
| 引上式ゲートの場合の可動堰の本体の構造形式は、小径間長のも           |
| のにおいては箱形、大径間長のものにおいては逆Ｔ形、中間のものにおいて |
| はＵ形としている例が多く見受けられるが、構造形式の選定に当たっては、 |
| 基礎地盤の良否、施工性（仮締切との関連）、経済性等も考慮する。　　　 |
|                                                                      |
| また多連となる場合は、基礎地盤の強度不足又は圧縮                     |
| 性が大きいことによる圧密沈下の影響による不同沈下についても考慮する。 |
|                                                                      |
| ゲート重量は、ゲートに用いる材質や構造によって異なるが、ゲート開及び |
| 閉状態では床版や基礎等の設計に、また、ゲート開状態では門柱や堰柱等の |
| 設計に関係する。したがって、あらかじめ堰を設置する場所の条件や必要な |
| 対策を踏まえ、ゲートの材質と構造を選定し、基礎や床版等の設計を行う。 |
+----------------------------------------------------------------------+

＜例　示＞

  --------------------------------------------------------------------
  ゲートの鋼構造に準ずる構造には、ステンレス製ゲート等の事例がある。
  --------------------------------------------------------------------

17. 設計用定数

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------
  堰の設計に用いる各種定数は、適切な安全性が確保できるよう、使用する材料の力学特性を考慮し、必要に応じて調査・試験を実施したうえで、設定することを基本する。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------

18. ヤング係数

＜標　準＞

  ----------------------------------------------------------------------------------------------------
  設計に用いるヤング係数は、使用する材料の特性や品質を考慮したうえで適切に設定することを基本とする。
  ----------------------------------------------------------------------------------------------------

＜推　奨＞

+----------------------------------------------------------------------+
| ヤング係数として、以下の値を用いることが望ましい。                   |
|                                                                      |
| １) ヤング係数                                                       |
|                                                                      |
| > ・コンクリートのヤング係数は、2.5×10^4^                            |
| > N/mm^2　^（設計基準強度：24N/mm2）                                 |
| >                                                                    |
| > ・鋼材のヤング係数は、2.0×10^5^ N/mm^2^                            |
|                                                                      |
| ２) ヤング係数比                                                     |
|                                                                      |
| > ・許容応力度による設計を                                           |
| 行う場合の鉄筋コンクリート部材の応力度の計算に用いるヤング係数比は15 |
+----------------------------------------------------------------------+

19. 地盤に係る定数

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  地盤に係る定数は、ボーリング調査、サウンディング調査、原位置試験、室内土質試験を組合せた地盤調査（既往調査含む）や周辺の工事履歴、試験施工等に基づき総合的に判断し、施工条件等も考慮したうえで、設定することを基本とする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

+----------------------------------------------------------------------+
| １) 基礎底面と支持地盤との間の摩擦係数と付着力                       |
|                                                                      |
| 基礎底面と支持地盤                                                   |
| との間の摩擦係数と付着力として、表7-1に示す値を用いることができる。  |
|                                                                      |
| 16. 摩擦角と付着力                                                   |
|                                                                      |
| +-----------------------+-----------------------+--------------+     |
| | 条件                  | 摩擦角φ*~B~（         | 付着力c*~B~* |     |
| |                       | 摩擦係数tan*φ*~B~）*  |              |     |
| +=======================+=======================+==============+     |
| | 土とコンクリート      | ![散布図              | *c~B~=0*     |     |
| |                       | が含まれている画像    |              |     |
| |                       | 自動的に              |              |     |
| |                       | 生成された説明](media |              |     |
| |                       | /image37.png){width=" |              |     |
| |                       | 0.5763888888888888in" |              |     |
| |                       | height="0             |              |     |
| |                       | .5427668416447944in"} |              |     |
| +-----------------------+-----------------------+--------------+     |
| | 土とコンクリート      | tanφ*~B~=0.6*         | *c~B~=0*     |     |
| | の間に栗石を敷く場合  |                       |              |     |
| |                       | φ*~B~=φ*              |              |     |
| +-----------------------+-----------------------+--------------+     |
| | 岩とコンクリート      | tanφ*~B~=0.6*         | *c~B~=0*     |     |
| +-----------------------+-----------------------+--------------+     |
| | 土と土又は岩と岩      | φ*~B~=φ*              | *c~B~=c*     |     |
| +-----------------------+-----------------------+--------------+     |
|                                                                      |
| > た                                                                 |
| だし、φ：支持地盤のせん断抵抗角（度）、c:支持地盤の粘着力（kN/m^2^） |
| >                                                                    |
| > φ~B~：基礎底面と地盤との間の摩擦角(rad) 、                         |
| >                                                                    |
| > c~B~：基礎底面と地盤との間の付着力(kN/m^2^)                        |
|                                                                      |
| ２) 地盤支持力及び摩擦係数                                           |
|                                                                      |
| 地盤支持力及び摩擦係数は、表7-2に示す値を用いることができる。        |
|                                                                      |
| 17. 地盤支持力及び摩擦係数                                           |
|                                                                      |
| > ![テーブル                                                         |
| > 自                                                                 |
| 動的に生成された説明](media/image38.png){width="4.663888888888889in" |
| > height="4.222612642169729in"}                                      |
|                                                                      |
| ３) 地盤の許容鉛直支持力                                             |
|                                                                      |
| 地                                                                   |
| 盤の許容鉛直支持力は、荷重の偏心傾斜及び基礎の沈下量を考慮した地盤の |
| 極限支持力に対して、表7-3に示す安全率を確保していることが望ましい。  |
|                                                                      |
| 18. 安全率                                                           |
|                                                                      |
|   常時、洪水時   地震時   施工時                                     |
|   -------------- -------- --------                                   |
|   3              *2*      *2*                                        |
|                                                                      |
| 荷重の偏心傾斜及び基礎の                                             |
| 沈下量を考慮した地盤の極限支持力は、次式により求めることができる。平 |
| 板載荷試験により求める場合には、載荷試験の結果により確認した地盤の粘 |
| 着力C,せん断抵抗角φを用いて以下の式に従って算出することが望ましい。  |
|                                                                      |
| > 　*Q~u~* = *A~e~*                                                  |
| > {*ακcN~c~S~c~*+*κqN~q~S~q~*+(1/2)*γ*~1~*βB~e~N~γ~S~γ~*}            |
|                                                                      |
| ここに                                                               |
|                                                                      |
| > 　　*Q                                                             |
| ~u~*：荷重の偏心傾斜、支持力係数の寸法効果を考慮した地盤の極限支持力 |
| > (kN)                                                               |
| >                                                                    |
| > 　*c*：地盤の粘着力 (kN/m^2^)                                      |
| >                                                                    |
| > 　*q*：上載荷重 (kN) で、*q*=*γ*~2~*D~f~*                          |
| >                                                                    |
| > 　*A~e~*：有効載荷面積 (m^2^)                                      |
| >                                                                    |
| > 　*γ*~1~、*γ*~2~：支持地盤及び根入れ地盤の単位体積重量 (kN/m^3^)   |
| >                                                                    |
| > 　*B~e~*：荷重の偏心を考慮した基礎の有効載荷幅 (m)                 |
| >                                                                    |
| > 　　　*B~e~* = *B* − 2*e~B~*                                       |
|                                                                      |
| 　*B*：基礎幅 (m)                                                    |
|                                                                      |
| 　*e~B~*：荷重の偏心量 (m)                                           |
|                                                                      |
| 　*D~f~*：基礎の有効根入れ深さ (m)                                   |
|                                                                      |
| 　*α*、*β*：基礎の形状係数                                           |
|                                                                      |
| 　*κ*：根入れ効果に対する割増係数                                    |
|                                                                      |
| 　*N~c~*、*N~q~*、*N~γ~*：荷重の傾斜を考慮した支持力係数             |
|                                                                      |
| 　*S~c~*、*S~q~*、*S~γ~*：支持力係数の寸法効果に関する補正係数       |
|                                                                      |
| *tanθ*：荷重の傾斜                                                   |
|                                                                      |
| ![グラフ 自動的に生成された説明](media/image39.png){width="3.475in"  |
| height="2.779861111111111in"}                                        |
|                                                                      |
| 34. 支持力係数*N~c~*を求めるグラフ                                   |
|                                                                      |
| ![グラフ                                                             |
| 自                                                                   |
| 動的に生成された説明](media/image40.png){width="3.504861111111111in" |
| height="3.1694444444444443in"}                                       |
|                                                                      |
| 35. 支持力係数*N~q~*を求めるグラフ                                   |
|                                                                      |
| ![ダイアグラム                                                       |
| 自動                                                                 |
| 的に生成された説明](media/image41.png){width="3.5395833333333333in"  |
| height="4.05in"}                                                     |
|                                                                      |
| 36. 支持力係数*N~γ~*を求めるグラフ                                   |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  河川砂防技術基準調査編，平成 24 年 4 月 1 日,国水情第 52
    号,国土交通省水管理国土保全局.

    （最新版）河川砂防技術基準 調査編, 令和7年6月,
    国土交通省水管理・国土保全局.

＜参考となる資料＞

地盤に係る定数の設定については、下記の資料が参考となる。

1.  道路橋示方書・同解説　Ⅳ．下部構造編，平成24年3月,（社）日本道路協会.

    （最新版）道路橋示方書・同解説Ⅳ下部構造編，平成29年11月,（公社）日本道路協会.

```{=html}
<!-- -->
```
20. 鉄筋コンクリート部材の最小寸法

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------
  鉄筋コンクリートの部材の最小寸法は、耐久性、強度を有するために必要なかぶり及び施工性に配慮し設定することを基本とする。
  ------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

  ----------------------------------------------------------------------------------------------------------
  鉄筋コンクリートの部材の最小寸法は、施工性を重視し主鉄筋を内側に配置するため、0.4mとすることが望ましい。
  ----------------------------------------------------------------------------------------------------------

＜関連通知等＞

1.  土木構造物設計マニュアル（案）樋門編，平成13年2月,国土交通省．

    （最新版）土木構造物設計マニュアル（案）樋門編，平成 13 年 12
    月,国土交通省．

    1.  []{#_Toc54776105 .anchor}堰周辺の堤防

＜考え方＞

+----------------------------------------------------------------------+
| 堰周辺の堤防には、本体、魚道や土砂吐きの施工によ                     |
| る埋戻し部分も含まれる。その影響範囲は、対象とする事象によっても異な |
| るが、堤防縦断方向に堤防高さの2〜3倍以上に及ぶ。堰周辺の堤防に用いる |
| 土質材料は、堤防に適したものを選定し、十分に締固めを行う必要がある。 |
|                                                                      |
| 「7.5安全性能の照査等」                                              |
| に当たっては、堰周辺の堤防が一連区間の中の弱点とならないことが前提と |
| なっており、堰湛水域の波浪等に対する安全性の照査については、「第2節  |
| 堤防」に準じて安全性能の照査を行い、前後                             |
| 区間と比較して相対的に安全性が低下しないように対策を行う必要がある。 |
+----------------------------------------------------------------------+

＜必　須＞

  ----------------------------------------------------------------------------------
  堰周辺の堤防が一連区間と比較して相対的に弱点とならないように設計するものとする。
  ----------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 堰周辺の堤防の断面形状（堤防高、天端幅、堤体幅）は、計画堤           |
| 防断面以上であり、かつ、隣接する堤防断面以上とすることを基本とする。 |
|                                                                      |
| 堰湛水域の波浪等に対する安全性の照査については、「第2節              |
| 堤防」に準じて堤防の安全性照査を行い、一連区                         |
| 間と比較して相対的に安全性が低下しないように必要に応じて対策を行う。 |
+----------------------------------------------------------------------+

＜推　奨＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------
  両端の堰柱をやむを得ず計画堤防断面内に設置する場合には、川裏側に堤防断面を拡幅する等の対策を行うことが望ましい。ただし、掘込河道の場合はこの限りでない。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1.  工作物設置許可基準，平成6年9月22日.建河治発第72号,建設省,最終改正：平成14年7月12日.国河治発第71号.

＜参考となる資料＞

堤防に用いる土質材料については、下記の資料が参考となる。

6.  河川土工マニュアル，平成21年4月（財）,国土技術研究センター．

    1.  []{#_Toc90575594 .anchor}安全性能の照査等

        1.  []{#_Toc90575595 .anchor}設計の対象とする状況と作用

＜考え方＞

+----------------------------------------------------------------------+
| 堰の設計に当たっては、常時、洪水時、地震時、高                       |
| 潮時及び風浪時の安全性能を確保することが求められる。全ての堰について |
| 、常時、洪水時及び地震時、さらに高潮堤に接続して設けられる堰は高潮時 |
| 、湖岸堤に接続して設けられる堰は風浪時についても照査する必要がある。 |
|                                                                      |
| 照査                                                                 |
| に当たっては、広域地盤沈下、基礎地盤の特性等の前提条件を設定する必要 |
| がある。なお、前提条件は、土質地質調査等に基づき設定する必要がある。 |
|                                                                      |
| 設計の対象とする作用については、本体やゲ                             |
| ート等の自重、計画高水位（高潮区間にあっては、計画高潮位）以下の水圧 |
| 、土圧、風の影響等のほか、地震時には地震の影響に加え、必要に応じて津 |
| 波による波圧、高潮時には波浪並びに風浪時には風浪による影響等が考えら |
| れ、設計の対象とする堰の状況に応じて適切に組合せて設定する必要がある |
| 。なお、地震の影響の算出の基となる地震動としては、河川構造物の供用期 |
| 間中に発生する確率が高い地震動及び対象地点において現在から将来にわた |
| って考えられる最大級の強さを持つ地震動の2種類を考慮する必要がある。  |
|                                                                      |
| また、必要に応じて施工時についても安全性能の照査を行う。             |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 安全性能の照査に当たっては、次                                       |
| の表のように設計の対象とする状況と作用を設定し、これを踏まえて照査事 |
| 項を設定することを基本とする。常時、洪水時及び地震時については全ての |
| 堰において設定し、これに加えて、高潮区間の堰の場合には高潮時、湖岸堤 |
| に接続して設ける堰の場合には風浪時について設定することを基本とする。 |
|                                                                      |
| 取水や潮止め、舟の通行等治水以外の設置目的を有する場合               |
| には当該設置目的に応じた常時の作用を適切に設定することを基本とする。 |
|                                                                      |
| +----------+----------------------------------------------------+    |
| | 堰の状況 | 作用                                               |    |
| +==========+====================================================+    |
| | 常時     | 自重（死荷重）、活荷重、土圧（水流直角方向         |    |
| |          | ）、水圧、泥圧（必要な場合）、揚圧力、風荷重、温度 |    |
| |          | 変化の影響（水流直角方向）、雪荷重（必要な場合）、 |    |
| |          | ゲート等の自重等、舟の衝突（水流方向、必要な場合） |    |
| +----------+----------------------------------------------------+    |
| | 洪水時   | 自重（死荷重）                                     |    |
| |          | 、活荷重、土圧（水流直角方向）、水圧^※^、揚圧力、  |    |
| |          | 風荷重、ゲート等の自重等、流木の衝突（必要な場合） |    |
| |          |                                                    |    |
| |          | ※計画高水位、高潮区間にあっては計画高潮位          |    |
| +----------+----------------------------------------------------+    |
| | 高潮時   | 自重（死荷重）、活荷重、土圧（水流直角方           |    |
| |          | 向）、水圧、泥圧（必要な場合）、揚圧力、風荷重、雪 |    |
| |          | 荷重（必要な場合）、ゲート等の自重等、舟の衝突（水 |    |
| |          | 流方向）、高潮位における波浪による波圧（水流方向） |    |
| +----------+----------------------------------------------------+    |
| | 風浪時   | 自重（死荷重）、                                   |    |
| |          | 活荷重、土圧（水流直角方向）、水圧、泥圧（必要な場 |    |
| |          | 合）、揚圧力、風荷重、雪荷重（必要な場合）、ゲート |    |
| |          | 等の自重、舟の衝突（水流方向）、風浪による波圧（水 |    |
| |          | 流方向）、副振動・セイシュによる影響（必要な場合） |    |
| +----------+----------------------------------------------------+    |
| | 地震時   | 自重（死荷重）、水圧、泥圧                         |    |
| |          | （必要な場合）、揚圧力、地震の影響^※^、雪荷重（必  |    |
| |          | 要な場合）、ゲート等の自重、地震（津波）による波圧 |    |
| |          |                                                    |    |
| |          | ※構造物の重量に起因                                |    |
| |          | する慣性力、地震時土圧、地震時動水圧、液状化の影響 |    |
| +----------+----------------------------------------------------+    |
| | その他   | 施工時荷重                                         |    |
| +----------+----------------------------------------------------+    |
|                                                                      |
| 高規格堤防設                                                         |
| 置区間及び当該区間の背水区間の堰の照査に当たっては、計画高水位での静 |
| 水圧を高規格堤防設計水位での静水圧に置き換えて行うことを基本とする。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  ダム・堰施設技術基準（案），平成28年3月, 国土交通省.

```{=html}
<!-- -->
```
21. 河川構造物の耐震性能照査指針・解説―Ⅳ．水門・樋門及び堰編―，令和2年2月（令和2年6月一部追記）,国土交通省水管理・国土保全局．

22. 河川津波対策について，平成23 年 9 月 2 日，国水計第 20 号，国水治第
    35 号，国土交通省水管理・国土保全局河川計画課長、治水課長.

＜推　奨＞

+----------------------------------------------------------------------+
| 堰の設計に当たっては、作用毎に以下の数値を用いることが望ましい。     |
|                                                                      |
| １）自重（死荷重）                                                   |
|                                                                      |
| 自重（死荷重）は、適切な単位体積重量を用いて算出する。               |
|                                                                      |
| 材料の単位体積重量は、表7-4及び表7-5の値を参考に定める。             |
|                                                                      |
| 土の                                                                 |
| 単位体積重量は、一般的な値を示したものであり、土質試験データがある場 |
| 合は、その値を用いて設計することが望ましい。また、堤防盛土材料に現地 |
| の発生材を用いる場合や、盛土材料が明確になっていない場合は、一般に18 |
| *kN* /m^3^を用いる。                                                 |
|                                                                      |
| 19. 材料の単位体積重量(kN/m^3^)                                      |
|                                                                      |
| +------------------------------------------------+--------------+    |
| | 材料                                           | 単位体積重量 |    |
| +================================================+==============+    |
| | > 鋼・鋳鋼・鍛鋼                               | 77.0         |    |
| +------------------------------------------------+--------------+    |
| | > 鋳鉄                                         | 71.0         |    |
| +------------------------------------------------+--------------+    |
| | > アルミニウム                                 | 27.5         |    |
| +------------------------------------------------+--------------+    |
| | > 鉄筋コンクリート                             | 24.5         |    |
| +------------------------------------------------+--------------+    |
| | > プレストレスを導入するコンクリート           | 24.5         |    |
| | >                                              |              |    |
| | > （設計基準強度60N/mm^2^以下）                |              |    |
| +------------------------------------------------+--------------+    |
| | > プレストレスを導入するコンクリート           | 25.0         |    |
| | >                                              |              |    |
| | > （設計基準強度60N/mm^2^を超え80N/mm^2^まで） |              |    |
| +------------------------------------------------+--------------+    |
| | > コンクリート                                 | 23.0         |    |
| +------------------------------------------------+--------------+    |
| | > セメントモルタル                             | 21.0         |    |
| +------------------------------------------------+--------------+    |
| | > 木材                                         | 8.0          |    |
| +------------------------------------------------+--------------+    |
| | > 歴青材（防水用）                             | 11.0         |    |
| +------------------------------------------------+--------------+    |
| | > アスファルト舗装                             | 22.5         |    |
| +------------------------------------------------+--------------+    |
|                                                                      |
| > ※ゲート等の機械設備については除く。                                |
|                                                                      |
| 20. 土の単位体積重量(kN/m^3^)                                        |
|                                                                      |
| +------------------+------------+----------+----------+              |
| | **地盤**         | 土　質     | 緩いもの | 密なもの |              |
| +==================+============+==========+==========+              |
| | > 自然地盤       | 砂及び砂礫 | 18       | 20       |              |
| +------------------+------------+----------+----------+              |
| |                  | 砂質土     | 17       | 19       |              |
| +------------------+------------+----------+----------+              |
| |                  | 粘性土     | 14       | 18       |              |
| +------------------+------------+----------+----------+              |
| | > 埋戻し土・盛土 | 砂及び砂礫 | 20       |          |              |
| +------------------+------------+----------+----------+              |
| |                  | 砂質土     | 19       |          |              |
| +------------------+------------+----------+----------+              |
| |                  | 粘性土     | 18       |          |              |
| +------------------+------------+----------+----------+              |
|                                                                      |
| > 地下水位以下にある土                                               |
| の単位体積重量は、それぞれの表中の値から9を差し引いた値としてよい。  |
| >                                                                    |
| > 地下水位は施工後における水位の平均値を考慮する。                   |
|                                                                      |
| ２）活荷重                                                           |
|                                                                      |
| 活荷重は、自動車荷重及び群集荷重とする。                             |
|                                                                      |
| 自動車荷                                                             |
| 重は必要に応じ、大型の自動車の交通状況に応じてTL-25荷重を考慮する。  |
|                                                                      |
| 群集荷重は、管理橋及び操作台等に3.5kN/m^2^の等分布荷重を考慮する。   |
|                                                                      |
| ３）土圧                                                             |
|                                                                      |
| 1.  静止土圧                                                         |
|                                                                      |
| 静止土圧は、次式による。                                             |
|                                                                      |
| *P~hd~＝K~0~(γ*×*h＋q~0~)*                                           |
|                                                                      |
| ここに                                                               |
|                                                                      |
| *P~hd~*：任意の深さの水平土圧強度(kN/ｍ^2^ )                         |
|                                                                      |
| > *K~0~*：静止土庄係数(通常はK~0~＝0.5と考えてよい)                  |
|                                                                      |
| *γ*：土の単位体積重量(kN/ｍ^3^ )                                     |
|                                                                      |
| *h*：任意の深さ(ｍ)                                                  |
|                                                                      |
| *q~0~*:上載荷重(kN/ｍ^2^ )                                           |
|                                                                      |
| 2.  主働土圧                                                         |
|                                                                      |
| 主働土圧は、次式による。                                             |
|                                                                      |
| *P~a~＝K~A(~γ*×*h＋q~0~)*                                            |
|                                                                      |
| ![](media/image42.emf){width="3.5375in"                              |
| height="0.5076388888888889in"}                                       |
|                                                                      |
| cot(ξ~A~－α)＝－tan(φ＋δ＋θ－α)                                      |
|                                                                      |
| 　　　　　　　　　　　　　 ![](media/image43.emf){width="3.19375in"  |
| height="0.4027777777777778in"}                                       |
|                                                                      |
| ここに                                                               |
|                                                                      |
| > *P~a~*：任意の深さの主働土圧強度(kN/ｍ^2^)                         |
| >                                                                    |
| > *K~A~*：主働土圧係数                                               |
| >                                                                    |
| > *ξ~A~*：主働崩壊角(度)                                             |
|                                                                      |
| *γ*：土の単位体積重量(kN/ｍ^3^)                                      |
|                                                                      |
| *h*：任意の深さ(ｍ)                                                  |
|                                                                      |
| *q~0~*：上載荷量(kN/ｍ^2^)                                           |
|                                                                      |
| *α*：地表面と水平面のなす角(度)                                      |
|                                                                      |
| *θ*：壁背面と鉛直面のなす角(度)                                      |
|                                                                      |
| *φ*：土の内部摩擦角(度)                                              |
|                                                                      |
| *δ*：土圧作用面の種別に応じた壁面摩擦角(度)                          |
|                                                                      |
| 土と土の場合：δ＝φ                                                   |
|                                                                      |
| 土とコンクリートの場合：δ＝φ/3                                       |
|                                                                      |
| ただし、φ－α＜Oのときはsin(φ－α)＝0とする。                          |
|                                                                      |
| 上載荷量q~0~は必要に応じて考慮する。                                 |
|                                                                      |
| ここで用いる角度は反時計回りを正とする。                             |
|                                                                      |
| 3.  地震時主働土圧                                                   |
|                                                                      |
| > 地震時主働土圧は、河川構造物の耐震性能照査指針                     |
| > Ⅳ水門・樋門及び堰編による。                                        |
|                                                                      |
| ４）水圧                                                             |
|                                                                      |
| 1.  静水圧                                                           |
|                                                                      |
| > 堰の上下流水位について、堰の操作上考えられる組合せを検討する。     |
| >                                                                    |
| > ただし、地震と高潮は同時に生起しないものとし、地震時慣性力         |
| 及び地震時動水圧と洪水時における水圧は、同時に作用させる必要はない。 |
| >                                                                    |
| > ゲート引上げ時にも流水から受ける力を必要に応じて考慮する。         |
|                                                                      |
| 2.  地震時動水圧                                                     |
|                                                                      |
| > 地震時動水圧は、河川構造物の耐震性能照査指針                       |
| > Ⅳ水門・樋門及び堰編による。                                        |
|                                                                      |
| 3.  残留水圧                                                         |
|                                                                      |
| > 両端の堰柱や取付擁壁の前面の水位と背面の水位                       |
| の間に水位差が生じる場合は、この水位差に伴う残留水圧を考慮する。残留 |
| 水位（RWL）は、外水位が低下した場合などでの両端の堰柱や取付擁壁の背  |
| 後の地盤中に残留する水位であり、次のように定めてよい（図7-11参照）。 |
| >                                                                    |
| > （1）自然地下水位（GWL）＜両端の堰柱や取付擁壁背後の地盤高（GL）   |
| >                                                                    |
| > 残留水位（RWL）＝（計画高水位（HWL）-前面水位（WL））×2/3          |
| >                                                                    |
| > （2）自然地下水位（GWL）＞両端の堰柱や取付擁壁背後の地盤高（GL）   |
| >                                                                    |
| > 残留水位（RWL）＝（計画高水位（HWL）-自然地下水位（GWL））×2/3     |
| >                                                                    |
| > （1）自然地下水位（GWL）＜両端の堰柱や取付擁壁前面の水位（WL）     |
| >                                                                    |
| > 残留水位（                                                         |
| RWL）＝（両端の堰柱や取付擁壁背後の地盤高（GL）-前面水位（WL））×2/3 |
| >                                                                    |
| > （2）自然地下水位（GWL）＞両端の堰柱や取付擁壁前面の水位（WL）     |
| >                                                                    |
| > 残留水位（RWL）＝（両端の堰柱や取付擁壁背後の地盤高（GL）          |
| > -自然地下水位（GWL））×2/3                                         |
| >                                                                    |
| > 感潮区間の残                                                       |
| 留水位（RWL）は、前面潮位差の2/3の水圧差を対象とする（図7-12参照）。 |
|                                                                      |
| +-------------------------------+-------------------------------+    |
| | （1）自然地下水位（GWL）＜    | （2）自然地下水位（GWL）＞    |    |
| |                               |                               |    |
| | 両端の堰柱                    | 両端の堰柱                    |    |
| | や取付擁壁背後の地盤高（GL）  | や取付擁壁背後の地盤高（GL）  |    |
| +===============================+===============================+    |
| | ![ダイアグラム                | ![ダイアグラム                |    |
| | 自動的に生成                  | 自動的に生成さ                |    |
| | された説明](media/image66.png | れた説明](media/image67.png)  |    |
| | ){width="2.974892825896763in" | {width="2.5439085739282588in" |    |
| | h                             | h                             |    |
| | eight="1.8956528871391076in"} | eight="1.8447801837270341in"} |    |
| +-------------------------------+-------------------------------+    |
|                                                                      |
| 37. 残留水位の設定方法（洪水時）                                     |
|                                                                      |
| ![ダイアグラム                                                       |
| 自動                                                                 |
| 的に生成された説明](media/image68.png){width="2.5475054680664915in"  |
| height="1.840003280839895in"}                                        |
|                                                                      |
| 38. 感潮区間の残留水位                                               |
|                                                                      |
| ５）泥圧                                                             |
|                                                                      |
| 土砂の堆積によって生じる泥圧については、以下のとおりとする。         |
|                                                                      |
| 1.  鉛直力                                                           |
|                                                                      |
| > 泥圧のうち鉛直力は、堆積した泥土の水中における重量とする。         |
|                                                                      |
| 2.  水平力                                                           |
|                                                                      |
| > 水平方向の泥圧は次式によって求める。                               |
|                                                                      |
| *Pe = Ce×W~1~*×*d*                                                   |
|                                                                      |
| > *Pe* ：水平方向泥圧（kN/㎡）                                       |
| >                                                                    |
| > *Ce* ： 泥圧係数                                                   |
| >                                                                    |
| > *W~1\ ~*：泥土の水中における単位体積重量（kN/m^3^）                |
| >                                                                    |
| > *d* ：泥土の深さ(m)                                                |
| >                                                                    |
| > 設計に用いる堆積した泥土（以下「堆泥」と                           |
| いう。）の深さは、周辺の堆積状況、実績等適切な方法を用いて推定する。 |
| >                                                                    |
| > 堆泥の重量は、                                                     |
|                                                                      |
| *W~1~ ＝ W －(1-ν)*×*W~0~*                                           |
|                                                                      |
| > で示される。ここにW~0~                                             |
| > は水の単位体積重量{kN/m^                                           |
| 3^}、Wは堆泥の見かけの単位体積重量{kN/m^3^}、νは堆泥の空隙率である。 |
| >                                                                    |
| > これらの概略値として、下記の数値が常用されている。                 |
|                                                                      |
| *W = 15～18 kN/m^3^，ν＝0.3～0.4，Ce ＝0.4～0.6,*                    |
|                                                                      |
| *W~0~ ＝10 kN/m^3^*                                                  |
|                                                                      |
| > なお、                                                             |
| 地震時は地震時動水圧を考慮するため、動泥圧は一般に考慮しなくてよい。 |
|                                                                      |
| ６）揚圧力                                                           |
|                                                                      |
| 揚圧力は、堰の操作上考えられる堰の上                                 |
| 下流の水位差が最大となる水位により求める。また、耐震補強等で仮締切ゲ |
| ートを用いて締め切る場合も，上下流の水位差を用いて揚圧力を算定する。 |
|                                                                      |
| ![ダイアグラム                                                       |
| 自                                                                   |
| 動的に生成された説明](media/image69.png){width="5.239583333333333in" |
| height="4.697916666666667in"}                                        |
|                                                                      |
| 39.                                                                  |
|                                                                      |
| ７）風荷重                                                           |
|                                                                      |
| 風荷重は3kN/㎡とする。                                               |
|                                                                      |
| ８）温度変化の影響                                                   |
|                                                                      |
| 温度荷重は、温度変化を±15                                            |
| ℃とし、膨張係数を鋼で0.000012、コンクリートで0.00001として計算する。 |
|                                                                      |
| ９）雪荷重                                                           |
|                                                                      |
| 雪荷重は、雪の単位堆                                                 |
| 積重量と積雪深の積として求める。一般に多雪地方においては、雪荷重3.5  |
| kN/m^2^を見込めばよい。積雪深は、既往の積雪記録、構造物上で          |
| の積雪状態などを考慮して設定する。積雪のない地方では考慮する必要はな |
| い。ただし、積雪が少ないために積雪深を決定できない場合は、雪荷重を1  |
| kN/㎡としてよい。                                                    |
|                                                                      |
| １０）構造物の重量に起因する慣性力                                   |
|                                                                      |
| 構造物の重量に起因する慣性力は、構造物の重量に                       |
| 水平震度を乗じた水平力として算出する。このときの水平震度は、河川構造 |
| 物の耐震性能照査指針　Ⅳ水門・樋門及び堰編による。なお、動的照査法を  |
| 用いる場合は、構造物の質量に応答加速度を乗じたものとして算出される。 |
|                                                                      |
| １１）液状化の影響                                                   |
|                                                                      |
| 液状化                                                               |
| の影響は、河川構造物の耐震性能照査指針　Ⅳ水門・樋門及び堰編による。  |
|                                                                      |
| １２）波圧                                                           |
|                                                                      |
| 波圧について以下を考慮する。                                         |
|                                                                      |
| ・高潮区間や湖岸堤等で考慮する。                                     |
|                                                                      |
| ・波浪高の                                                           |
| 推定に当たっては「調査編第21章第5節及び本編第7章第2節」を参照する。  |
|                                                                      |
| １３）その他荷重                                                     |
|                                                                      |
| 施工時荷重については、必要に応じて考慮する。                         |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  土木構造物設計マニュアル（案）樋門編，平成13年2月,国土交通省.

    （最新版）土木構造物設計マニュアル（案）樋門編，平成 13 年 12
    月,国土交通省．

```{=html}
<!-- -->
```
23. ダム・堰施設技術基準（案），平成28年3月,国土交通省.

24. 河川砂防技術基準調査編，平成 26 年 4 月 1 日，国水情第 52
    号,国土交通省水管理国土保全局.

    （最新版）河川砂防技術基準 調査編, 令和7年6月,
    国土交通省水管理・国土保全局.

25. 河川構造物の耐震性能照査指針・解説―Ⅳ．水門・樋門及び堰編―，令和2年2月（令和2年6月一部追記）,
    国土交通省水管理・国土保全局.

＜参考となる資料＞

　設計の対象とする作用の設定にあたっては、下記の資料が参考となる。

1.  道路橋示方書・同解説 Ⅰ．共通編，平成 24 年 3
    月，（公社）日本道路協会.

    （最新版）道路橋示方書・同解説Ⅰ．共通編，平成29年11月，（公社）日本道路協会.

```{=html}
<!-- -->
```
26. 柔構造樋門設計の手引き，平成10年11月,（財）国土技術研究センター.

27. 道路土工，擁壁工指針，平成24年版,（公社）日本道路協会.

28. 道路土工，カルバート工指針，平成21年版,（公社）日本道路協会.

    1.  []{#_Toc32437643 .anchor}安全性能の照査

＜考え方＞

+----------------------------------------------------------------------+
| 堰における安全性能の照査は、「7.5.1                                  |
| 設計の対象とする状況と作用」に示す状況と作用毎に、照査の条件として適 |
| 切な上下流水位の組合せを設定し、安全性能について照査する必要がある。 |
|                                                                      |
| また、堰における安全性能                                             |
| の照査は、構造や材料の特性に応じた設計手法を適用してモデル化を行い、 |
| 最も不利な断面力が生じる作用に対して、安全性能が確保できるようにする |
| 。なお、「最も不利な断面力が生じる作用」とは、考慮すべき荷重の組合せ |
| のうち、発生応力等が構造物に対して最も不利に働く荷重の組合せをいう。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 堰は、「7.5.1                                                        |
| 設計の対象とする状況と作用」に対し                                   |
| 、以下の事項について安全性能を設定して照査することを基本とする。なお |
| 、固定堰の場合は、(1)～(3)の事項について安全性能を設定して照査する。 |
|                                                                      |
| > （1）常時の安全性能                                                |
| >                                                                    |
| > （2）洪水時の安全性能                                              |
| >                                                                    |
| > （3）耐震性能                                                      |
| >                                                                    |
| > （4）風浪等に対する安全性能                                        |
|                                                                      |
| 照査に当                                                             |
| たっては、これまでの経験及び実績から妥当とみなせる方法又は論理的に妥 |
| 当性を有する方法等、適切な知見に基づく手法を用いることを基本とする。 |
+----------------------------------------------------------------------+

＜推　奨＞

+------------------------------------------------------------------+
| 安全性能を照査するに当たっては、以下の手法によることが望ましい。 |
|                                                                  |
| １）鋼製の門扉の部材設計                                         |
|                                                                  |
| 部材の設計は、許容応力度設計法によって行う。                     |
|                                                                  |
| ２）鉄筋コンクリート部材設計                                     |
|                                                                  |
| ・部材の設計に用いる断面力は、弾性理論により算出する。           |
|                                                                  |
| ・部材の設計は、許容応力度設計法によって行う。                   |
+------------------------------------------------------------------+

1.  常時の安全性能

＜考え方＞

+----------------------------------------------------------------------+
| 常時においては、堰の上下流の水位                                     |
| 差が最大となる際における水圧の作用等に対して安全な構造が求められる。 |
|                                                                      |
| 常時には、操作で想定されるゲートの状態（ゲート全                     |
| 閉又は一部開放時）に対し、ゲートへの水圧、床版への揚圧力、ゲート・ゲ |
| ート操作台・付属施設（管理橋・操作室等）の自重、堰周辺の堤防からの土 |
| 圧、風荷重等が作用する。堰の状況に応じて作用を設定し、適切に組合せて |
| 各部位の安定性及び応力計算を行う必要がある。堰の基礎を杭基礎、ケーソ |
| ン基礎とした場合、堰本体部と周辺地盤との不同沈下による局部的な沈下に |
| よる段差が生じ、この段差が堰周辺の堤防に悪影響を与える可能性があるた |
| め、隣接堤防との境界部における不同沈下について照査も行う必要がある。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 常時の安全性能の照査は、堰の上下                                     |
| 流の水位差が最大となる際における水圧の作用に対して、以下の項目の安全 |
| 性を評価し、所定の安全性又は許容値を満足することを照査の基本とする。 |
|                                                                      |
| １）各部位の安全性                                                   |
|                                                                      |
| 堰                                                                   |
| 本体及び水叩きが転倒、滑動、基礎地盤支持力に対して所定の安全性を確保 |
| する。また、水叩きについては、揚圧力に対して所定の安全性を確保する。 |
|                                                                      |
| ２）発生応力に対する安全性                                           |
|                                                                      |
| 「7.5.1設計の対象とする状況と                                        |
| 作用」により、常時の操作において想定される諸条件を設定し、堰及びゲー |
| ト部材に発生する応力が「7.5.3許容応力度」以下となることを確認する。  |
|                                                                      |
| ３）耐浸透性能                                                       |
|                                                                      |
| 堰及び水叩きと堤                                                     |
| 体や基礎地盤との接触面における浸透に対して、所定の安全性を確保する。 |
+----------------------------------------------------------------------+

＜推　奨＞

+----------------------------------------------------------------------+
| １）各部位の安全性                                                   |
|                                                                      |
| 所定の安全性とは、以下の安全率を満足する。                           |
|                                                                      |
| 21. 各項目の安全率                                                   |
|                                                                      |
|   項目             安全率                                            |
|   ---------------- ---------------------------                       |
|   転倒             合力の作用点が中央1/3以内                         |
|   滑動             1.5                                               |
|   基礎地盤支持力   3                                                 |
|                                                                      |
| ２）発生応力に対する安全性                                           |
|                                                                      |
| せん断応力度は                                                       |
| 、せん断力を部材幅（b）×有効高（d）で割った平均せん断応力度とする。  |
|                                                                      |
| せん断応力度の照査は、支点が直接支持と                               |
| なっているものは支点の前面より1/2×hだけ内側で行ってよい。(h:はり高） |
|                                                                      |
| ３）耐浸透性能                                                       |
|                                                                      |
| 耐浸透性照査における所要の安全性は、                                 |
| 地盤の土質区分、堤防断面形状、考慮する水頭差、遮水工の配置、深さ、長 |
| さ、不同沈下が生じる場合にはルーフィング発生による浸透路長の減少を考 |
| 慮したうえで、レインの式による浸透経路長を満足することを確認する。な |
| お、遮水工を2列に入れる場合、深さに対して間隔が短すぎると浸透路長が  |
| 遮水工沿いとはならない場合があるので、実現象に合うように浸透路長をと |
| るよう留意する。また、地盤が互層の場合は、浸透流が常に浸透抵抗の小さ |
| いところを流れることを念頭において浸透経路を検討することが望ましい。 |
|                                                                      |
| ![ダイアグラム, 設計図                                               |
| 自                                                                   |
| 動的に生成された説明](media/image70.png){width="5.048666885389326in" |
| height="4.98701334208224in"}                                         |
|                                                                      |
| 40. 遮水工の浸透経路長                                               |
|                                                                      |
| $$レイン加重                                                         |
| クリープ比　C \leqq \frac{\frac{L}{3} + \sum l}{\mathrm{\Delta}H}$$  |
|                                                                      |
| > ここに                                                             |
|                                                                      |
|   *C*    ：   加重クリープ比                                         |
|   ------ ---- -----------------------------------------------------  |
|               *Cv* : 遮水工の鉛直方向の加重クリープ比                |
|               *Ch* : 遮水工の水平方向の加重クリープ比                |
|   *L*    ：   本体、水叩き及び取付擁壁の流下方向の浸透経路長（m）    |
|   *∑l*   ：   遮水矢板等の鉛直方向及び水平方向の浸透経路長（m）      |
|               *lv* : 鉛直方向の浸透経路長                            |
|               *lh* : 水平方向の浸透経路長                            |
|   *ΔH*   ：   上下流水位差（m）                                      |
|                                                                      |
| 22. 加重クリープ比C                                                  |
|                                                                      |
|   地盤の土質区分             C                                       |
|   -------------------------- -----                                   |
|   極めて細かい砂又はシルト   8.5                                     |
|   細砂                       7.0                                     |
|   中砂                       6.0                                     |
|   粗砂                       5.0                                     |
|   細砂利                     4.0                                     |
|   中砂利                     3.5                                     |
|   栗石を含む粗砂利           3.0                                     |
|   栗石と礫を含む砂利         2.5                                     |
|   柔らかい粘土               3.0                                     |
|   中くらいの粘土             2.0                                     |
|   堅い粘土                   1.8                                     |
|                                                                      |
| ４）揚圧力に対する安全性                                             |
|                                                                      |
| 揚圧力に対する安全率は、4/3とする。                                  |
|                                                                      |
| ５）ゲート機能                                                       |
|                                                                      |
| ゲート機能は、同様の敷高・規模及び操作形式の堰における               |
| 操作の確実性を確認できれば機能を確保しているとみなすことができる。な |
| お、堆砂傾向については、必要に応じて水理模型実験を実施して確認する。 |
+----------------------------------------------------------------------+

21. 洪水時の安全性能

＜考え方＞

+----------------------------------------------------------------------+
| 洪水時においては、計画高水位（高潮区間にあっては                     |
| 計画高潮位）以下の水位の流水の作用等に対して安全な構造が求められる。 |
|                                                                      |
| 洪水時には、操作で想定されるゲートの状態（ゲート全開時）に対し、     |
| 床版への揚圧力、ゲート・ゲート操作台・付属施設（管理橋・操作室等）の |
| 自重、堰周辺の堤防からの土圧、風荷重等が作用する。固定堰の場合は、本 |
| 体への水圧・揚圧力、本体の自重、土圧が作用する。堰の状況に応じて作用 |
| を設定し、適切に組合せて各部位の安定性及び応力計算を行う必要がある。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 洪水時の安全性能の照査は、計画高水位（高潮区間にあって               |
| は計画高潮位）以下の水位の流水の作用に対して、以下の項目の安全性を評 |
| 価し、所定の安全性又は許容値を満足することを照査の基本とする。なお、 |
| 固定堰の場合は、以下の項目のうち1)について照査することを基本とする。 |
|                                                                      |
| １）各部位の安全性                                                   |
|                                                                      |
| 堰本体及び水叩きが転倒、滑動、基礎地盤支持力に対して所定の安全性     |
| を確保する。また、水叩きについては、揚圧力に対して安全性を確保する。 |
|                                                                      |
| ２）発生応力に対する安全性                                           |
|                                                                      |
| 「7.5                                                                |
| .1設計の対象とする状況と作用」により、洪水時に想定される諸条件を設定 |
| し、堰に発生する応力が「7.5.3許容応力度」以下となることを確認する。  |
+----------------------------------------------------------------------+

＜推　奨＞

+----------------------------------------------------------------------+
| １）各部位の安全性                                                   |
|                                                                      |
| 所定の安全性とは、以下の安全率を満足するものとする。                 |
|                                                                      |
| 23. 各項目の安全率                                                   |
|                                                                      |
|   項目             安全率                                            |
|   ---------------- ---------------------------                       |
|   転倒             合力の作用点が中央1/3以内                         |
|   滑動             1.5                                               |
|   基礎地盤支持力   3                                                 |
|                                                                      |
| ２）発生応力に対する安全性                                           |
|                                                                      |
| せん断応力度は                                                       |
| 、せん断力を部材幅（b）×有効高（d）で割った平均せん断応力度とする。  |
|                                                                      |
| せん断応力度の照査は、支点が直接支持と                               |
| なっているものは支点の前面より1/2×hだけ内側で行ってよい。(h:はり高） |
+----------------------------------------------------------------------+

22. 耐震性能

＜考え方＞

+----------------------------------------------------------------------+
| 堰の耐震性                                                           |
| 能の照査は、河川構造物の耐震性能照査指針に基づき実施する必要がある。 |
|                                                                      |
| レベル1地震動に対しては、地震によって                                |
| 堰としての健全性を損なわない構造が求められる。また、レベル2地震動に  |
| 対しては、治水上又は利水上重要な堰は、地震後においても堰としての機能 |
| を保持する構造が、それ以外の堰は、地震による損傷が限定的にとどまり、 |
| 堰としての機能の回復が速やかに行い得ることができる構造が求められる。 |
|                                                                      |
| 地震時には、堰柱及び                                                 |
| ゲートには慣性力及び地震時動水圧が作用する。また、堰の地震時挙動は、 |
| 地形、地盤条件等の種々の要因の影響を受けるが、中でも、基礎地盤の影響 |
| を強く受ける。基礎地盤が液状化した場合には、液状化に伴う基礎地盤の変 |
| 形が地震時挙動に大きく影響を及ぼすため、液状化を考慮する必要がある。 |
|                                                                      |
| なお、津波に対しては（４）風浪等に対する安全性能に基づき照査する。   |
+----------------------------------------------------------------------+

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  耐震性能の照査は、レベル1地震動に対して堰としての健全性を損なわないこと、レベル2地震動に対して堰の重要性に応じて機能を保持あるいは堰としての機能の回復が速やかに行い得ることを照査の基本とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

+----------------------------------------------------------------------+
| １）各部位の安全性                                                   |
|                                                                      |
| レベル1地震動については                                              |
| 、転倒、滑動、基礎地盤支持力に対し以下の安全率を満足するものとする。 |
|                                                                      |
| 24. 各項目の安全率                                                   |
|                                                                      |
|   項目             安全率                                            |
|   ---------------- ---------------------------                       |
|   転倒             合力の作用点が中央2/3以内                         |
|   滑動             1.2                                               |
|   基礎地盤支持力   2                                                 |
|                                                                      |
| ２）その他の安全性                                                   |
|                                                                      |
| その他の耐震性能の照査について                                       |
| は、河川構造物の耐震性能照査指針・解説―Ⅳ．水門・樋門及び堰編による。 |
+----------------------------------------------------------------------+

＜関連通知等＞

7.  河川構造物の耐震性能照査指針・解説―Ⅳ．水門・樋門及び堰編―，令和2年2月（令和2年6月一部追記）,
    国土交通省水管理・国土保全局.

＜参考となる資料＞

耐震性能の照査については、下記の資料が参考となる。

8.  道路土工，擁壁工指針，平成24年版,（公社）日本道路協会．

```{=html}
<!-- -->
```
23. 風浪等に対する安全性能

＜考え方＞

+----------------------------------------------------------------------+
| 堰は設置位置によって高潮時及び風浪時の波浪                           |
| 並びに計画津波水位以下の津波の作用等に対して安全な構造が求められる。 |
|                                                                      |
| 風浪時等には、操作で想定されるゲートの状態（                         |
| ゲート全閉又は一部開放時）に対し、ゲートへの水圧、波圧・津波荷重、床 |
| 版への揚圧力、ゲート・ゲート操作台・付属施設（管理橋・操作室等）の自 |
| 重、堰周辺の堤防からの土圧、風荷重等が作用する。堰の状況に応じて作用 |
| を設定し、適切に組合せて各部位の安定性及び応力計算を行う必要がある。 |
|                                                                      |
| ゲートの照査に用いる波圧及び津波荷重はダ                             |
| ム・堰施設技術基準（案）、防波堤の耐津波設計ガイドラインに基づき設定 |
| する必要がある。特に津波に対しては、堰によってゲートを全閉とする操作 |
| 規則としている場合がある。このような施設においては、津波による波圧に |
| 対し、ゲート全閉状態を想定した本体の安全性能の照査を行う必要がある。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 風浪等に対する安全性能の照査は、堰本体が受ける水圧及び波圧の         |
| 作用に対して安全性を評価し、許容値を満足することを照査の基本とする。 |
|                                                                      |
| １）各部位の安全性                                                   |
|                                                                      |
| 堰本体及び水叩きが転倒、滑動、基礎地盤支持力に対して所定の安全性     |
| を確保する。また、水叩きについては、揚圧力に対して安全性を確保する。 |
|                                                                      |
| ２）発生応力に対する安全性                                           |
|                                                                      |
| 「7.5.1設計の対象とする状況と                                        |
| 作用」により、常時の操作において想定される諸条件を設定し、堰及びゲー |
| ト部材に発生する応力が「7.5.3許容応力度」以下となることを確認する。  |
+----------------------------------------------------------------------+

[]{#_Toc47014734 .anchor}

1.  許容応力度

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------
  許容応力度等は、使用する材料の基準強度や力学特性を考慮して、適切な安全性が確保できるように設定することを基本する。
  --------------------------------------------------------------------------------------------------------------------

＜推　奨＞

+----------------------------------------------------------------------+
| 許容応力度として、以下の値を用いることが望ましい。                   |
|                                                                      |
| １）コンクリートの許容応力度                                         |
|                                                                      |
| 25. コンクリートの許容応力度（N/mm^2^）                              |
|                                                                      |
|   設                                                                 |
| 計基準強度   許容曲げ圧縮応力度   許容付着応力度   許容せん断応力度  |
|   ---                                                                |
| ----------- -------------------- ---------------- ------------------ |
|   24             8.0                  1.60             0.39          |
|                                                                      |
| なお、無筋コンクリートの許                                           |
| 容応力度は、道路橋示方書・同解説Ⅳ．下部構造編（平成24年3月）による。 |
|                                                                      |
| ２）鉄筋の許容引張応力度                                             |
|                                                                      |
| 26. 鉄筋の許容引張応力度（N/mm^2^）                                  |
|                                                                      |
| +------------------+------------------+------------------+-----+     |
| | 鉄筋の種類       | SD345            |                  |     |     |
| |                  |                  |                  |     |     |
| | 応               |                  |                  |     |     |
| | 力度、部材の種類 |                  |                  |     |     |
| +==================+==================+==================+=====+     |
| | > 引張応力度     | 荷重の           | 一般の部材^※1^   | 180 |     |
| |                  | 組合せに衝突荷重 |                  |     |     |
| |                  | あるいは地震の影 |                  |     |     |
| |                  | 響を含まない場合 |                  |     |     |
| +------------------+------------------+------------------+-----+     |
| |                  |                  | 厳しい           | 160 |     |
| |                  |                  | 環境下の部材^※2^ |     |     |
| +------------------+------------------+------------------+-----+     |
| |                  | 荷重の           | 200              |     |     |
| |                  | 組合せに衝突荷重 |                  |     |     |
| |                  | あるいは地震の影 |                  |     |     |
| |                  | 響を含む場合の許 |                  |     |     |
| |                  | 容応力度の基本値 |                  |     |     |
| +------------------+------------------+------------------+-----+     |
| |                  | 鉄筋の重ね継     | 200              |     |     |
| |                  | 手長あるいは定着 |                  |     |     |
| |                  | 長を算出する場合 |                  |     |     |
| +------------------+------------------+------------------+-----+     |
|                                                                      |
| ※1通常の環境や常時水中、土中の場合（操作台に適用）                   |
|                                                                      |
| > ※2一般の環境に比べて乾湿の繰り                                     |
| 返しが多い場合や有害な物質を含む地下水位以下の土中の場合（堰柱、門柱 |
| 、取付擁壁に適用）（海洋環境などでは別途かぶりなどについて考慮する） |
|                                                                      |
| ３）鋼材の許容応力度（ゲート等の機械設備を除く）                     |
|                                                                      |
| 27. 構造用鋼材の母材部及び溶接部の許容応力度（N/mm^2^）              |
|                                                                      |
| +--------+--------+--------+--------+--------+-----+-----+-----+     |
| | 鋼     | SS400  | SM490  | SM490Y | SM570  |     |     |     |     |
| | 材記号 |        |        |        |        |     |     |     |     |
| |        | SM400  |        | SM520  | S      |     |     |     |     |
| | 区     |        |        |        | MA570W |     |     |     |     |
| | 分及び | S      |        | S      |        |     |     |     |     |
| |        | MA400W |        | MA490W |        |     |     |     |     |
| | 応力度 |        |        |        |        |     |     |     |     |
| | の種類 |        |        |        |        |     |     |     |     |
| +========+========+========+========+========+=====+=====+=====+     |
| | 母材部 | 引　張 | 140    | 185    | 210    | 255 |     |     |     |
| |        |        |        |        |        |     |     |     |     |
| |        | 圧　縮 | 140    | 185    | 210    | 255 |     |     |     |
| |        |        |        |        |        |     |     |     |     |
| |        | せん断 | 80     | 105    | 120    | 145 |     |     |     |
| +--------+--------+--------+--------+--------+-----+-----+-----+     |
| | >      | > 工   | 全断面 | 引　張 | 140    | 185 | 210 | 255 |     |
| | 溶接部 | 場溶接 | 溶込み |        |        |     |     |     |     |
| |        |        | グルー | 圧　縮 | 140    | 185 | 210 | 255 |     |
| |        |        | プ溶接 |        |        |     |     |     |     |
| |        |        |        | せん断 | 80     | 105 | 120 | 145 |     |
| +--------+--------+--------+--------+--------+-----+-----+-----+     |
| |        |        | すみ   | せん断 | 80     | 105 | 120 | 145 |     |
| |        |        | 肉溶接 |        |        |     |     |     |     |
| |        |        | ，部分 |        |        |     |     |     |     |
| |        |        | 溶込み |        |        |     |     |     |     |
| |        |        | グルー |        |        |     |     |     |     |
| |        |        | プ溶接 |        |        |     |     |     |     |
| +--------+--------+--------+--------+--------+-----+-----+-----+     |
| |        | 現     | 引　張 | 原則と |        |     |     |     |     |
| |        | 場溶接 |        | して、 |        |     |     |     |     |
| |        |        | 圧　縮 | 工場溶 |        |     |     |     |     |
| |        |        |        | 接と同 |        |     |     |     |     |
| |        |        | せん断 | じ値と |        |     |     |     |     |
| |        |        |        | する。 |        |     |     |     |     |
| +--------+--------+--------+--------+--------+-----+-----+-----+     |
|                                                                      |
| ４）鋼管杭の許容応力度                                               |
|                                                                      |
| 28. 鋼管杭の母材部及び溶接部の許容応力度（N/mm^2^）                  |
|                                                                      |
| +------------------+----------+--------+------------------+-----+    |
| | 鋼管杭の種類     | SKK400   | SKK490 |                  |     |    |
| |                  |          |        |                  |     |    |
| | 区分             |          |        |                  |     |    |
| | 及び応力度の種類 |          |        |                  |     |    |
| +==================+==========+========+==================+=====+    |
| | 母材部           | 引　張   | 140    | 185              |     |    |
| +------------------+----------+--------+------------------+-----+    |
| |                  | 圧　縮   | 140    | 185              |     |    |
| +------------------+----------+--------+------------------+-----+    |
| |                  | せん断   | > 80   | 105              |     |    |
| +------------------+----------+--------+------------------+-----+    |
| | 溶接部           | 工場溶接 | 引　張 | 140              | 185 |    |
| +------------------+----------+--------+------------------+-----+    |
| |                  |          | 圧　縮 | 140              | 185 |    |
| +------------------+----------+--------+------------------+-----+    |
| |                  |          | せん断 | > 80             | 105 |    |
| +------------------+----------+--------+------------------+-----+    |
| |                  | 現場溶接 | 引　張 | 原則             |     |    |
| |                  |          |        | として，工場溶接 |     |    |
| |                  |          |        | と同じ値とする。 |     |    |
| +------------------+----------+--------+------------------+-----+    |
|                                                                      |
| ５）既製コンクリート杭の許容応力度                                   |
|                                                                      |
| JISに基づき適切に定める。                                            |
|                                                                      |
| ６）許容応力度の割増し                                               |
|                                                                      |
| 作用の組合                                                           |
| せにおいて地震の影響、温度変化の影響等を考慮する場合は、表7-14による |
| 許容応力度の割増しを行なうことができる。下記以外の作用の組合せによる |
| 許容応力度の割増しを考慮する場合は、個々の状況に応じて適切に定める。 |
|                                                                      |
| 29. 許容応力度の割増し                                               |
|                                                                      |
|   作用の組合せ                             割増率（％）              |
|   ---------------------------------------- --------------            |
|   温度変化の影響を考慮する場合             15                        |
|   風荷重を考慮する場合                     25                        |
|   地震の影響を考慮する場合                 50                        |
|   温度変化の影響及び風荷重を考慮する場合   35                        |
|   施工時荷重を考慮する場合                 50                        |
+----------------------------------------------------------------------+

[]{#_Toc100563605 .anchor}

1.  各部位の設計等

    1.  []{#_Toc100563606 .anchor}本体

```{=html}
<!-- -->
```
1.  ゲート

```{=html}
<!-- -->
```
1.  ゲートの構造

＜考え方＞

+----------------------------------------------------------------------+
| 洪水時及び高潮時において、ゲートを全開又は                           |
| 一部開放することによって計画高水位（高潮区間においては計画高潮位）以 |
| 下の水位の流水の作用、風浪等における波圧に対して安全な構造となるよう |
| 設計する必要がある。ゲートは、確実に開閉（起伏）し、かつ、必要な水密 |
| 性を有する構造とするため適切なゲート形式を選定する必要がある。堰のゲ |
| ートは、一般に引上げ式のローラゲート、起伏式ゲートとして鋼製起伏ゲー |
| ト及びゴム引布製起伏ゲート（図7-15、図7-16参照）等が使用されている。 |
|                                                                      |
| 引上げ式ゲートには越流をさせる形式とさせない形式のものがあり、そ     |
| の選定にあたっては河川の特性、堰の目的、維持管理等を検討して定める。 |
|                                                                      |
| 可動堰においては、堆砂傾向や河床材料等の                             |
| 河道特性を踏まえ、引上げ式ゲートや起伏式ゲートを選定する場合がある。 |
|                                                                      |
| 起伏式ゲートは、                                                     |
| 油圧シリンダや空気又は水を充填・排除することにより操作するが、堆砂に |
| より起伏が確実に行われないおそれがある場合は、引上げ式ゲートとする。 |
|                                                                      |
| ![ダイアグラム, 設計図                                               |
| 自                                                                   |
| 動的に生成された説明](media/image71.png){width="4.665972222222222in" |
| height="1.259740813648294in"}                                        |
|                                                                      |
| 41. ゴム引布製伏式ゲート                                             |
|                                                                      |
| ![ダイアグラム, 設計図                                               |
| 自                                                                   |
| 動的に生成された説明](media/image71.png){width="4.665015310586177in" |
| height="1.2207786526684163in"}                                       |
|                                                                      |
| 42. 起伏式ゲート                                                     |
|                                                                      |
| ゲートの点                                                           |
| 検や補修を行う際に堰の機能維持が必要な場合は、予備ゲート等を設ける。 |
|                                                                      |
| ゲート                                                               |
| の基本寸法とは、設置標高、径間長、断面高等を意味し、引上げ式ゲートの |
| 最大引上げ時のゲート下端高については揚程を考慮し設定する必要がある。 |
|                                                                      |
| 戸当りは、コンクリート構造                                           |
| 物の規模、強度等に与える影響が大きいため、戸当りの寸法、構造、設置方 |
| 法等とコンクリート構造物との関連性を検討する必要がある。また、ゲート |
| が点検や整備時に取り外されることも考慮して構造を決定する必要がある。 |
+----------------------------------------------------------------------+

＜必　須＞

  ------------------------------------------------------------------------------------------------------------------------------------
  ゲートは、確実な開閉（起伏）が行えるとともに必要な水密性を有する構造とし、設計荷重に対して安全な構造となるよう設計するものとする。
  ------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| ゲート形式及び規模は、本体の形式・規模及び戸当り等、他の設備と       |
| の配置を考慮して、設計条件を満足するように決定することを基本とする。 |
|                                                                      |
| ゲートの基本寸法は、制約条                                           |
| 件を考慮して、「7.4基本的な構造」に準じて決定することを基本とする。  |
|                                                                      |
| 戸当りの形状はゲートの形式に                                         |
| 適合したものとし、扉体支承部からの荷重を安全にコンクリート構造物に伝 |
| 達することができるように寸法、強度及び剛性を有するものを基本とする。 |
+----------------------------------------------------------------------+

＜推　奨＞

  --------------------------------------------------------------------------------------------------------
  越流させない形式の引上げ式ゲートにあっては、万一越流した場合についても検討を加えておくことが望ましい。
  --------------------------------------------------------------------------------------------------------

＜例　示＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  河川や設置場所の特性に応じて、鋼製起伏堰\[SR堰\]の採用事例がある（図7-17参照）。SR堰は、鋼製の扉体と袋状のゴム引布製の起伏装置（以下「ゴム袋体」という。）を有し、ゴム袋体に空気又は水を充填し、若しくはゴム袋体から排除することによって起伏させる形式の堰をいう。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

![](media/image72.emf){width="4.22198709536308in"
height="4.350649606299212in"}

43. ＳＲ堰各部の名称

また、ライジングセクターゲート（図7-18参照）やラジアルゲート等の採用事例もある。

ライジングセクターゲートは、扉体の両端が円盤となっており、この円盤を回転させることにより開閉を行うものである。引上げ式ゲートのようにゲートを巻き上げるための門柱が不要となる。一方、緊急時に自重閉鎖が不可能であるため、現場の状況に合わせて採用するのが良い。

![](media/image73.emf){width="3.1510575240594925in"
height="2.2356419510061243in"}

44. ライジングセクターゲート各部の名称

```{=html}
<!-- -->
```
3.  開閉装置

＜考え方＞

+----------------------------------------------------------------------+
| 堰は、平常時は全閉して                                               |
| おり、洪水時又は高潮時にゲートを全開又は一部開放し、河川の流水を制御 |
| する必要があることから、確実にゲートを開閉（起伏）できる必要がある。 |
|                                                                      |
| 開閉装置の設置箇所は、ゲート形式に応じて                             |
| 適切に設定する必要があり、引上げ式ゲートの場合は堤防高よりも高い操作 |
| 台の上に開閉装置を設置している場合が多い。起伏式ゲートの場合は、計画 |
| 高水位又はそれに類する水位より上に開閉装置を設置している場合が多い。 |
|                                                                      |
| ゲートの開閉（起伏）を確実に行うため、開閉装置は電動式（電動に       |
| よる油圧、水圧、エアポンプ等も含む）とする。これにより電源として常用 |
| （商用）と予備電源の両方を使用でき、平常時又は暴風雨時等に常用電源が |
| 停電した場合にも、予備発電装置により予備電源を確保することができる。 |
|                                                                      |
| なお、起伏式ゲートには予備動力は設け                                 |
| ないのが一般的である。また、必要に応じて手動操作を備える必要がある。 |
+----------------------------------------------------------------------+

＜必　須＞

  ----------------------------------------------------------------------------------------------------------------------
  開閉装置は、ゲートの確実な開閉（起伏）操作が行えるとともに、設計荷重に対して安全な構造となるよう設計するものとする。
  ----------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 開閉装置は、ゲートの開閉（起伏）を確実に行う                         |
| ために設置し、ゲート形式に応じて適切な箇所に設けることを基本とする。 |
|                                                                      |
| 開閉装置形式の選定に当たっては、設備の設置目的                       |
| 、用途、ゲートの種類、開閉荷重の大きさ・方向・押下げ力、揚程、開閉装 |
| 置の設置位置、配置及び設置環境を考慮の上、選定することを基本とする。 |
|                                                                      |
| 開閉用の動力は、電動機に                                             |
| よるものとし、全てのゲートに開閉用予備動力を備えることを基本とする。 |
|                                                                      |
| ゲートの操                                                           |
| 作のための設備は、施設規模に応じて、機側操作、又は遠方操作・遠隔操作 |
| とするものとする。なお、遠方操作・遠隔操作方式の場合には、機側操作も |
| 可能なものとする。機側操作は、確実に操作ができるものとし、機側操作中 |
| は、安全管理上遠方操作・遠隔操作方式では作動しないような構造とする。 |
+----------------------------------------------------------------------+

＜例　示＞

起伏式ゲートや小規模な引上げ式ゲートの場合には、開閉用の動力は内燃機関又は手動式油圧シリンダによるものとすることができる。

24. 本体の安定計算

＜考え方＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  堰本体は、可動堰の場合、ゲート、床版、堰柱、門柱、ゲート操作台で構成し、固定堰の場合、固定堰本体で構成する。設計に当たっては、各部位の機能の確保と堰全体の安定に配慮した構造とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜必　須＞

  ----------------------------------------------------------------------------------------------------------------
  堰本体は、設計荷重に対して、転倒、滑動、基礎地盤支持力に対する所要の安全率が確保されるよう設計するものとする。
  ----------------------------------------------------------------------------------------------------------------

＜推　奨＞

+----------------------------------------------------------------------+
| １）可動堰の安定計算                                                 |
|                                                                      |
| 安定計算の順序及び計算方法は、以下に示す方法が望ましい。             |
|                                                                      |
| a）形状寸法の仮定                                                    |
|                                                                      |
| > 敷高、径間長                                                       |
| 、門柱高及び管理橋幅員等の諸元を満足するように本体のゲート操作台、門 |
| 柱、堰柱、床版等の各部位の主要形状寸法を仮定し、本体の重量を求める。 |
|                                                                      |
| b）ゲート、開閉装置、戸当り、管理橋、その他の付属物の重量の仮定      |
|                                                                      |
| > ゲート、開閉装置、戸当り重量の                                     |
| 仮定は、敷高、径間長、ゲート高及び設計水深に対し、他の可動堰の実例、 |
| その他参考文献により算定する。また、管理橋重量は、幅員及び径間長に対 |
| し、他の橋梁の実施例等の参考文献より算定する。その他の付属物で安定計 |
| 算に影響を与えるおそれのあるものについては、それらの重量を仮定する。 |
|                                                                      |
| c）荷重の計算                                                        |
|                                                                      |
| > 　荷重の計算に                                                     |
| 当たっては、「7.5.1設計の対象とする状況と作用」に基づいて算出する。  |
|                                                                      |
| d）転倒、滑動、基礎地盤支持力に対する検討                            |
|                                                                      |
| >                                                                    |
| 転倒、滑動、基礎地盤支持力に対する検討は、２）の荷重条件に対して行い |
| 、その安全率が「7.5.2安全性能の照査」の規定以上になるよう設計する。  |
|                                                                      |
| ２）可動堰の安定計算を行う場合の荷重条件                             |
|                                                                      |
| 表7-15～表7-21は、可動堰の安定計算を行う場合の荷重条件（上流側       |
| に波圧を考慮する必要がない場合の荷重条件）の一例を示したものである。 |
|                                                                      |
| ここに示した荷重条件のほか、予想され                                 |
| る上下流の水位の組合せに対して安全であるよう設計することが望ましい。 |
|                                                                      |
| なお、荷重の組合せのう                                               |
| ち、洪水と地震、波圧と地震、風荷重と地震は同時に考慮する必要はない。 |
|                                                                      |
| 30. 中央堰柱の荷重条件（1）                                          |
|                                                                      |
| ![ダイアグラム, 設計図, 概略図                                       |
| 自                                                                   |
| 動的に生成された説明](media/image74.png){width="5.420138888888889in" |
| height="6.654166666666667in"}                                        |
|                                                                      |
| 31. 中央堰柱の荷重条件（2）                                          |
|                                                                      |
| ![ダイアグラム, 設計図                                               |
| 自動的に生成された説明](media/image75.png){width="5.3125in"          |
| height="7.831152668416448in"}                                        |
|                                                                      |
| 32. 両端の堰柱の荷重条件（1）                                        |
|                                                                      |
| ![ダイアグラム, 設計図                                               |
| 自                                                                   |
| 動的に生成された説明](media/image76.png){width="5.395833333333333in" |
| height="7.629603018372704in"}                                        |
|                                                                      |
| 33. 両端の堰柱の荷重条件（2）                                        |
|                                                                      |
| ![ダイアグラム, 概略図                                               |
| 自                                                                   |
| 動的に生成された説明](media/image77.png){width="5.302083333333333in" |
| height="7.957364391951006in"}                                        |
|                                                                      |
| 34. 両端の堰柱の荷重条件（3）                                        |
|                                                                      |
| ![ダイアグラム, 概略図                                               |
| 自動的に生成された説明](media/image78.png){width="5.34375in"         |
| height="7.843992782152231in"}                                        |
|                                                                      |
| 35. 両端の堰柱の荷重条件（4）                                        |
|                                                                      |
| ![ダイアグラム, 設計図                                               |
| 自                                                                   |
| 動的に生成された説明](media/image79.png){width="5.333333333333333in" |
| height="4.354166666666667in"}                                        |
|                                                                      |
| ３）固定堰の安定計算                                                 |
|                                                                      |
| 固定堰の安定計算の順序及び計算方法は、以下に示す方法が望ましい。     |
|                                                                      |
| a）形状寸法の仮定                                                    |
|                                                                      |
| > 敷高、水理条件より主要形状寸法を仮定する。                         |
| >                                                                    |
| > b）荷重の計算                                                      |
| >                                                                    |
| > (1)鉛直荷重                                                        |
| >                                                                    |
| > 荷重の計算に当                                                     |
| たっては、「7.5.1設計の対象とする状況と作用」に基づいて算出するが、  |
| 固定堰の仮定した形状寸法により水流直角方向1m当たりの重量を計算する。 |
| >                                                                    |
| > (2)土圧                                                            |
| >                                                                    |
| > 上流側は、固定堰天端まで堆砂する場合についても計算する。           |
| >                                                                    |
| > (3)水圧                                                            |
| >                                                                    |
| > 堰の上下流の水位の組合せによる。                                   |
| >                                                                    |
| > \(4\) 構造物の重量に起因する慣性力                                 |
| >                                                                    |
| > 構造物の重量に起因する慣性力                                       |
| は、構造物の重量に水平震度を乗じた水平力として算出する。このときの水 |
| 平震度は、河川構造物の耐震性能照査指針　Ⅳ水門・樋門及び堰編による。  |
| >                                                                    |
| > (5)揚圧力                                                          |
| >                                                                    |
| > 揚圧力は、１)と同様とする。                                        |
| >                                                                    |
| > c）転倒、滑動、基礎地盤支持力に対する検討                          |
| >                                                                    |
| >                                                                    |
| 転倒、滑動、基礎地盤支持力に対する検討は、２）の荷重条件に対して行い |
| 、その安全率が「7.5.2安全性能の照査」の規定以上になるよう設計する。  |
|                                                                      |
| ４）固定堰の安定計算を行う場合の荷重条件                             |
|                                                                      |
| 表7-21は、堰の上下流に水叩きが設けられている一般的な形               |
| 状の固定堰の本体において検討すべき荷重条件の一例を示したものである。 |
|                                                                      |
| ここに示した荷重条件のほ                                             |
| か、必要に応じ上流側に堆砂がなく動水圧が作用する場合や揚圧力が作用し |
| ない場合の荷重条件に対しても安全であるように設計することが望ましい。 |
|                                                                      |
| 36. 固定堰の荷重条件                                                 |
|                                                                      |
| ![ダイアグラム, 設計図                                               |
| 自                                                                   |
| 動的に生成された説明](media/image80.png){width="5.395833333333333in" |
| height="3.367248468941382in"}                                        |
+----------------------------------------------------------------------+

25. 床版

＜考え方＞

+----------------------------------------------------------------------+
| 可動堰の床版は、上部荷重を支持し、ゲートの水密性を確保し             |
| 、堰柱間の河床洗掘防止機能を果たすことができる構造とする必要がある。 |
|                                                                      |
| 床版は、本体の形式に応じ                                             |
| て決定され、箱型、Ｕ形構造の場合は堰柱と一体構造となり、逆Ｔ形の場合 |
| は、堰柱と一体となった堰柱床版と堰柱と分離した中間床版に分類される。 |
| 中間床版の基礎は、ゲート荷重に対して不同沈下が生じないような構造とし |
| 、中間床版は、ゲートとの間の水密性を確保できるようにする必要がある。 |
|                                                                      |
| ![ダイアグラム                                                       |
| 自                                                                   |
| 動的に生成された説明](media/image81.png){width="4.319444444444445in" |
| height="1.288888888888889in"}                                        |
|                                                                      |
| 45. 本体の形式が逆Ｔ形の場合の床版                                   |
|                                                                      |
| 底部戸当り面は、ゲートとの確                                         |
| 実な水密性、土砂等の堆積防止のために床版と同一平面とする必要がある。 |
+----------------------------------------------------------------------+

＜必　須＞

  --------------------------------------------------------------------------------------------------------
  床版は、ゲートと必要な水密性を有する構造とし、設計荷重に対して安全な構造となるよう設計するものとする。
  --------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 床版は、河床洗                                                       |
| 掘を防止するとともにゲートとの水密性を確保し、本体の形式に応じてゲー |
| トや堰柱等の荷重を支持できる構造となるよう設計することを基本とする。 |
|                                                                      |
| 底部戸当り面は、床版と同一平面とすることを基本とする。               |
+----------------------------------------------------------------------+

＜例　示＞

+----------------------------------------------------------------------+
| 中間床版                                                             |
| は、堰柱間の水平力に対するストラット（支材）を兼ねさせた事例がある。 |
|                                                                      |
| 施工時には、半川締切によって堰柱が片側のみから水圧を受ける           |
| 場合や、締切内の堰柱床版及び中間床版に揚圧力が作用する場合があるが、 |
| これらに対する堰柱床版又は中間床版の安定性の検討に当たっては、堰柱床 |
| 版又は中間床版をそれぞれ単独で安定させることが必要となる場合がある。 |
+----------------------------------------------------------------------+

26. 堰柱

＜考え方＞

+----------------------------------------------------------------------+
| 堰柱は、ゲート側面との水密を確保し、門柱                             |
| や操作台・操作室等の上部荷重及びゲートで受ける水圧を安全に床版に伝え |
| るために設ける。堰柱の配置は、「7.4.1流下断面及び径間長の設定」、「  |
| 7.4.2ゲート開閉時の高さの設定」を考慮したうえで決定する必要がある。  |
|                                                                      |
| 堰柱は、上部荷重及び水圧等の作用を安全に床版に伝えるため、           |
| 箱型、Ｕ形及び逆Ｔ形の一部においては床版と一体構造とする必要がある。 |
|                                                                      |
| 堰柱の天端高は計画高水                                               |
| 敷高以上（ゲート全閉時の天端高）とする必要がある。管理橋を設置する場 |
| 合は、管理橋の桁下高が河川管理施設等構造令（昭和51年政令第199号）第  |
| 64条に規定する高さ以上となるように堰柱の天端高を設定する必要がある。 |
|                                                                      |
| 堰柱長は、力学的安定性、ゲートの戸当たり寸法、門                     |
| 柱形式、予備ゲート構造等を考慮して決定する。ゲート前面には必要に応じ |
| て角落しを設けるための戸溝を設ける必要がある。角落しは、常時水位が高 |
| い場合等においてゲートや戸当りの維持管理を行うために設ける。戸溝幅は |
| 、水圧の大きさにより決定される角落しの規模により設定する必要がある。 |
+----------------------------------------------------------------------+

＜必　須＞

  ----------------------------------------------------------------------------------------------------------------------------------------
  堰柱は、門柱及び一部の床版と一体構造で、ゲートに必要な水密性を有する構造とし、設計荷重に対して安全な構造となるよう設計するものとする。
  ----------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 堰柱は、ゲー                                                         |
| トとの水密性を確保し、上部荷重及び水圧を安全に床版に伝えるために設置 |
| し、流下断面や径間長を考慮して適切な配置で設計することを基本とする。 |
|                                                                      |
| 堰柱は、上部荷重及び                                                 |
| 水圧等の作用を安全に床版に伝える構造として設計することを基本とする。 |
|                                                                      |
| 中                                                                   |
| 央堰柱の形状は流水に対する抵抗に配慮した構造とすることを基本とする。 |
|                                                                      |
| 堰柱の天端高については、ゲートの全閉時の天端高、管理橋等の           |
| 条件を考慮して決定し、堰柱の幅及び長さは、管理橋の幅員、ゲート戸当り |
| 寸法、開閉装置の寸法、力学的安定計算等から決定することを基本とする。 |
|                                                                      |
| ゲート前面の堰柱                                                     |
| には、必要に応じて角落しを設けるための戸溝を設けることを基本とする。 |
+----------------------------------------------------------------------+

＜推　奨＞

+----------------------------------------------------------------------+
| 堰柱の設計に当たっては、以下の方法で設計することが望ましい。         |
|                                                                      |
| １）堰柱先                                                           |
| 端部には用心鉄筋として、中間部と同程度の配筋を設ける（図7-20参照）。 |
|                                                                      |
| ２）堰柱の構造計算に用いる有効断面                                   |
| には、原則として戸当りの箱抜部分の二次コンクリートを考慮せず設計する |
| 。また、有効長は、図7-21に示す箱抜き部、両端の円弧部は除き設定する。 |
|                                                                      |
| ３）門柱と堰柱との結合部、堰                                         |
| 柱と床版との結合部は、応力集中を避けるため、図7-22のように配筋する。 |
|                                                                      |
| ![テキスト, 地図 が含まれている画像                                  |
| 自動的に生成された説明](media/image82.png){width="4.09375in"         |
| height="1.9270833333333333in"}                                       |
|                                                                      |
| 46. 堰柱の配筋                                                       |
|                                                                      |
| ![テキスト が含まれている画像                                        |
| 自動                                                                 |
| 的に生成された説明](media/image83.png){width="3.6979166666666665in"  |
| height="1.3125in"}                                                   |
|                                                                      |
| 47. 堰柱の有効長                                                     |
|                                                                      |
| ![ダイアグラム, 図形                                                 |
| 自                                                                   |
| 動的に生成された説明](media/image84.png){width="4.665008748906387in" |
| height="1.585003280839895in"}                                        |
|                                                                      |
| 48. 門柱と堰柱との結合部、堰柱と床版との結合部の配筋                 |
+----------------------------------------------------------------------+

＜例　示＞

+----------------------------------------------------------------------+
| 堰柱と床版は、同じ長さとするが、                                     |
| 中間堰柱にあっては、必要に応じ堰柱長を床版長より短くする場合もある。 |
|                                                                      |
| 引上式ゲートの場                                                     |
| 合の中央堰柱の断面形状は、流水に対する抵抗を小さくし、流水に対する安 |
| 全性を確保するため、上下流端を半円形等とする例が多い（図7-23参照）。 |
|                                                                      |
| ![ダイアグラム, 設計図                                               |
| 自動                                                                 |
| 的に生成された説明](media/image85.png){width="3.3229166666666665in"  |
| height="1.2083333333333333in"}                                       |
|                                                                      |
| 49. 堰柱形状                                                         |
+----------------------------------------------------------------------+

27. 門柱

＜考え方＞

+----------------------------------------------------------------------+
| 門柱は、ゲートを引上げるために設ける。門柱は、堰柱や管理橋の配置     |
| とともに、門柱の断面寸法や戸溝の配置を勘案の上、配置する必要がある。 |
|                                                                      |
| 門柱の高さは、「7.4.3門柱の天端高」                                  |
| に従い、ゲートの大きさ、引上げ余裕高等を考慮し、設定する必要がある。 |
|                                                                      |
| 門柱の断面設定においては、設けるゲ                                   |
| ート及び戸当り金物の規模、設置スペースを考慮して設定する必要がある。 |
+----------------------------------------------------------------------+

＜必　須＞

  ----------------------------------------------------------------------------------------------
  門柱は、堰柱、操作台と一体構造とし、設計荷重に対して安全な構造となるよう設計するものとする。
  ----------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 門柱は、ゲート形式が引上げ式ゲートの                                 |
| 場合に設置し、堰柱及び管理橋の配置に合わせて設けることを基本とする。 |
|                                                                      |
| 門                                                                   |
| 柱の高さは、「7.4.3門柱の天端高」に従って設定することを基本とする。  |
|                                                                      |
| 門柱は、堰柱及び操作台と一体構造と                                   |
| し、上部荷重を安全に堰柱に伝える構造として設計することを基本とする。 |
|                                                                      |
| 門柱の断面は、戸当り金物を十分                                       |
| な余裕をもって取り付けられるように設計することを基本とする。また、門 |
| 柱部の戸当りは、ゲートが取りはずせるように設計することを基本とする。 |
+----------------------------------------------------------------------+

　

＜推　奨＞

+----------------------------------------------------------------------+
| ゲートの管理に必要な高さとしては、引上げ余裕高(1m以                  |
| 上）のほか、滑車等の付属品の高さを考慮することが望ましい（図7-24）。 |
|                                                                      |
| ![ダイアグラム, 設計図                                               |
| 自動                                                                 |
| 的に生成された説明](media/image64.png){width="2.9654297900262465in"  |
| height="1.916765091863517in"}                                        |
|                                                                      |
| 50. 門柱                                                             |
+----------------------------------------------------------------------+

＜例　示＞

  --------------------------------------------------------------------------------------------------------------------------
  門柱の戸当たりが吹き抜け構造の施設では、引上げ式ゲートの主ローラなど端部の点検又は補修等を門柱内部から行える事例もある。
  --------------------------------------------------------------------------------------------------------------------------

28. ゲートの操作台

＜考え方＞

+----------------------------------------------------------------------+
| 操作台は、ゲート操作用の開閉装置及び操作盤等の機器の設置、照         |
| 明等の付属施設を設けるため、引上げ式ゲートの場合は門柱の上に設ける。 |
|                                                                      |
| 操作台は、開閉装置の設                                               |
| 置及び操作、点検並びに整備等の維持管理が容易に行える広さを有する必要 |
| がある。維持管理に必要な広さの設定は、水門・樋門ゲート設計要領（案） |
| 6-3-3開閉操作室に準拠する。                                          |
+----------------------------------------------------------------------+

＜必　須＞

  ----------------------------------------------------------------------------------------------------------
  引上げ式ゲートの操作台は、門柱と一体の構造とし、設計荷重に対して安全な構造となるよう設計するものとする。
  ----------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 引上げ式ゲートの操作台は、ゲート操作用の開閉                         |
| 装置、操作盤等の機器を設けるため、門柱の上に設けることを基本とする。 |
|                                                                      |
| ゲート操作台は、操作性、維持管理に配慮した形状                       |
| 寸法を基本とする。ゲート操作台には、操作室を設けることを基本とする。 |
+----------------------------------------------------------------------+

＜推　奨＞

+----------------------------------------------------------------------+
| 操作室は、補修時に機器の搬出入ができる措置（例えば、チェーン         |
| ブロック用梁、機器の大きさに応じた扉の設置等）をとることが望ましい。 |
|                                                                      |
| 操作室の設置に当たっては、                                           |
| 耐震性能や維持管理などを考慮して適切な材質を選定することが望ましい。 |
+----------------------------------------------------------------------+

＜参考になる資料＞

引上げ式ゲートの操作台の設計については、下記の資料が参考となる。

1.  水門・樋門ゲート設計要領（案），平成13年12月,
    一般社団法人ダム・堰施設技術協会.

[]{#_Toc100563615 .anchor}

1.  水叩き

＜考え方＞

+----------------------------------------------------------------------+
| 水叩きは、堰の安全を保ち、上下流河床と本体部                         |
| 分の粗度の違い又はゲート開放時の流水等によって河床が洗掘されるのを防 |
| 止する必要な長さと構造を有する必要がある。水叩きの設計に当たっては、 |
| 構造や材料の特性に応じた設計手法を適用しモデル化を行い、最も不利な断 |
| 面力が生じる作用に対して、安全性が確保される必要がある。また、水叩き |
| と床版の継手部は、吸出し防止を目的とし、水密性を確保する必要がある。 |
|                                                                      |
| 水叩きは、                                                           |
| 水重、揚圧力等の荷重に対して安全な構造となるよう設計する必要がある。 |
|                                                                      |
| ![ダイアグラム, 設計図                                               |
| 自                                                                   |
| 動的に生成された説明](media/image86.png){width="5.413194444444445in" |
| height="1.929861111111111in"}                                        |
|                                                                      |
| 51. 水叩き                                                           |
+----------------------------------------------------------------------+

＜必　須＞

  ----------------------------------------------------------------------------------------------------
  水叩きは、必要な水密性及を有する構造とし、設計荷重に対して安全な構造となるよう設計するものとする。
  ----------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 水叩きの設計に当たっては、以下の事項を反映することを基本とする。     |
|                                                                      |
| 1.  水叩きは、本体の上下流の河床                                     |
| に設けることを基本とする。また、本体の上下流の河床に設ける水叩きとは |
| 別に魚道、土砂吐き、閘門についても水理特性を考慮して水叩きを設ける。 |
|                                                                      |
| 2.  水叩きと護床工を含めた長                                         |
| さは、必要に応じて、水理計算、水理模型実験、河床材料、河道形状（単、 |
| 複断面）、河床勾配、堰の全幅、揚圧力に対する安定条件、遮水形状等につ |
| いての検討結果及び過去の事例等を参考として総合的に判断して決定する。 |
|                                                                      |
| 3.  水叩きは                                                         |
| 堰本体を保護する最も重要な構造物であり、鉄筋コンクリート構造とする。 |
|                                                                      |
| 4.                                                                   |
| 水叩きと床版との継手は、水密でかつ不同沈下にも対応できる構造とする。 |
+----------------------------------------------------------------------+

＜推　奨＞

+----------------------------------------------------------------------+
| １）継手の構造                                                       |
|                                                                      |
| 継手の構造には、一般にダウエルバー方式（スリップバー方式             |
| ）とキー方式がある。ダウエルバー方式は施工が煩雑であるが、耐震性や、 |
| たわみ性において優れており、ダウエルバー方式を採用するのが望ましい。 |
|                                                                      |
| 水叩き等では、流水等の侵食作用による                                 |
| コンクリート表面の摩耗、礫の落下や転石による直接衝突によるコンクリー |
| ト表面のひび割れや剥離が生じやすいため、必要に応じて、コンクリート自 |
| 体の摩擦抵抗性を高めるほか、摩耗抵抗性の高い材料によってコンクリート |
| 表面を保護する等の摩耗の進行を抑制する対策を検討することが望ましい。 |
|                                                                      |
| ![ダイアグラム, 設計図                                               |
| 自動                                                                 |
| 的に生成された説明](media/image86.png){width="5.4151673228346455in"  |
| height="1.8645833333333333in"}                                       |
|                                                                      |
| 52. 水叩きの継手                                                     |
|                                                                      |
| ２）摩耗対策                                                         |
|                                                                      |
| 水叩き等では、流水等の侵食作用による                                 |
| コンクリート表面の摩耗、礫の落下や転石による直接衝突によるコンクリー |
| ト表面のひび割れや剥離が生じやすいため、必要に応じて、コンクリート自 |
| 体の摩擦抵抗性を高めるほか、摩耗抵抗性の高い材料によってコンクリート |
| 表面を保護する等の摩耗の進行を抑制する対策を検討することが望ましい。 |
|                                                                      |
| ３）水叩きと護床工を含めた長さ                                       |
|                                                                      |
| 水叩きと護床工を含めた長さは、「水理公式集」等に示される式を使用     |
| して跳水計算を行い、射流区間や通常の河川流になる位置を水叩きの長さや |
| 護床工の長さとする方法が場合がある。この手法は、河床材料によってどの |
| 流況まで水叩きとすべきかのパラメーターがない、堰柱によって発生する縮 |
| 流、渦流等の複雑な水理現象を表現できないなどの課題がある。近年数値解 |
| 析の手法が著しく発達・普及してきたため、前述の方法と合わせて検討する |
| ことが望ましい。また、水理模型実験等も合わせて実施するのが望ましい。 |
+----------------------------------------------------------------------+

　

＜例　示＞

+----------------------------------------------------------------------+
| 止水板は、可とう性のあるもの（塩化ビニール板等）を用い               |
| 、伸縮材としては弾力性のあるもの（発砲樹脂系等）を用いる場合が多い。 |
|                                                                      |
| 水叩きの                                                             |
| コンクリート表面の摩耗の進行を抑制するため、高強度コンクリートや高強 |
| 度モルタル等の材料、高強度パネル等による表面保護を施した事例がある。 |
|                                                                      |
| 水叩きの安定計算に用いる荷重条件の一例を表7―22に示す。               |
|                                                                      |
| 37. 水叩きの安定計算のための荷重条件                                 |
|                                                                      |
| ![ダイアグラム, 設計図                                               |
| 自                                                                   |
| 動的に生成された説明](media/image87.png){width="5.500694444444444in" |
| height="2.8402777777777777in"}                                       |
+----------------------------------------------------------------------+

＜参考となる資料＞

高強度コンクリートや高強度モルタル等の材料、高強度パネル等による表面保護を施した事例については、下記の資料が参考となる。

1.  表面保護工法 設計施工指針（案），平成17年4月,土木学会.

    1.  []{#_Toc100563616 .anchor}護床工

＜考え方＞

+----------------------------------------------------------------------+
| 護床工は、堰上下流で生じる局                                         |
| 所洗掘の防止や、高速流の減勢のために本体上下流側に設ける必要がある。 |
|                                                                      |
| 工種の選定に当たっては、次の点を検討の上、決定する必要がある。       |
|                                                                      |
| ①剛性                                                                |
|                                                                      |
| 堰本体から離れるに従い剛なものから柔なものに変化させる。             |
|                                                                      |
| （例）                                                               |
|                                                                      |
| 　　　・コンクリートブロック床と粗朶沈床                             |
|                                                                      |
| 　　　・コンクリートブロック床と捨石床                               |
|                                                                      |
| ②粗度                                                                |
|                                                                      |
| 小から大に変化させる。                                               |
|                                                                      |
| ③安定性                                                              |
|                                                                      |
| > コンクリート床版に接続する                                         |
| 部分は流速が大きくなることが多いので、想定される流速（以下「設計流速 |
| 」という。）に対し単体としての安定性及び河床材の吸出し防止を考慮する |
| 。特に河口部に設けられる堰においては、波浪に対する安全性も考慮する。 |
|                                                                      |
| ④施工性                                                              |
|                                                                      |
| ⑤河床変動とのなじみ                                                  |
|                                                                      |
| ⑥腐食                                                                |
|                                                                      |
| > 木工沈床、粗朶沈床等は、常時水中にある場合                         |
| は腐食しにくいが、その他の場合は、腐食が問題となるので注意を要する。 |
|                                                                      |
| ⑦吸出し                                                              |
|                                                                      |
| > 河口部で波浪の影響を受ける場合については、                         |
| その特性をよく把握し、アスファルトマット等を併用することも検討する。 |
+----------------------------------------------------------------------+

＜必　須＞

  ----------------------------------------------------------------------------------------------------
  護床工は、必要な屈とう性を有する構造とし、設計流速に対して安全な構造となるよう設計するものとする。
  ----------------------------------------------------------------------------------------------------

　

＜標　準＞

+----------------------------------------------------------------------+
| 護床工は、本体及び水叩きの                                           |
| 上下流での洗掘を防ぐため、水叩きの上下流側に設けることを基本とする。 |
|                                                                      |
| 護床工は、屈とう性を有する構造とし、本体上下流での洗                 |
| 掘を防ぐことができる長さ及び構造となるよう設計することを基本とする。 |
+----------------------------------------------------------------------+

[]{#_Toc100563617 .anchor}

2.  基礎

＜考え方＞

+----------------------------------------------------------------------+
| 基礎は、床版及び魚道や土砂吐きの下に同一の基礎形式を選定し、不同     |
| 沈下を起こさず、堰や堤防の弱点とならないようにすることが必要である。 |
|                                                                      |
| 基礎は、鉛直                                                         |
| 荷重のみならず水平荷重に対して安定する構造として設計する必要がある。 |
|                                                                      |
| 基礎の設計に当たっては、道路橋示方書（Ⅳ下部構造                      |
| 編）・同解説（平成24年3月）、杭基礎に当たっては杭基礎設計便覧（平成  |
| 27年3月）により設計するものとする。道路橋示方書は平成29年11月に、杭  |
| 基礎設計便覧は令和2年9月に改訂されている。これらの改訂では、性能規定 |
| （限界状態設計法及び部分係数法）に対応した記述に見直しており、従来の |
| 仕様規定（許容応力度設計法）とは異なる設計体系となっている。一方、堰 |
| の耐震設計以外の設計は、性能規定化に至っておらず本基準においても仕様 |
| 規定での設計体系である。そのため、道路橋示方書、杭基礎設計便覧の設計 |
| 法を適用する場合は、従来の仕様規定について記載しているものを適用する |
| 必要がある。その際、堰が河川管理施設であることを踏まえ、堰の安定やゲ |
| ートの開閉（起伏）に支障が出ないように許容値等を設定する必要がある。 |
|                                                                      |
| なお、調査方法や施工方法等の                                         |
| 設計法に影響しない記載については、適宜改訂されたものを適用して良い。 |
|                                                                      |
| 基礎形式の選定に当たっては、必要工期、作業場面積の大小、環境面での制 |
| 限、施工機械の保有量、経済性等を考慮し、総合的に判断する必要がある。 |
|                                                                      |
| 地質条件等に                                                         |
| よっては地震時の液状化対策も必要となるため、耐震対策の必要性も併せて |
| 検討する必要がある。耐震対策を行う場合は、河川構造物の耐震性能照査指 |
| 針・解説、Ⅳ水門・樋門及び堰編によって照査を行い設計する必要がある。  |
+----------------------------------------------------------------------+

＜必　須＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  基礎は、上部荷重等によって不同沈下を起こさないよう、良質な地盤に安全に荷重を伝達する構造とするものとする。また、水平荷重に対して安定する構造となるよう設計するものとする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 基礎は、本体と魚道                                                   |
| や土砂吐きの間に不同沈下が発生し堰や堤防の弱点とならないようにするた |
| め、床版及び魚道や土砂吐きの下に同一の基礎で設けることを基本とする。 |
|                                                                      |
| 基礎の形式及び構造は、良質な地盤に安全に荷重を伝達できるよう適切に   |
| 選定することを基本とする。基礎は、発生する変位を堰の安定とゲートの開 |
| 閉（起伏）に支障のない範囲内に抑えるように設計することを基本とする。 |
+----------------------------------------------------------------------+

＜推　奨＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  杭基礎を用いる場合の許容水平変位量は、これまで、堤体に与える影響、ゲートの開閉（起伏）、複雑な構造かつ防災上重要であること等を考慮し、0.01mとして設計されてきた。このため、堰や水門の杭基礎の設計においては、常時、洪水時及び地震時（レベル１地震動）の安全性能の照査における杭の許容水平変位量は0.01m程度を目安とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

　

＜関連通知等＞

1.  構造物基礎用鋼管ぐいの設計に関する取扱いについて，昭和45年12月15日,建設省河川局.

```{=html}
<!-- -->
```
29. 河川構造物の耐震性能照査指針・解説―Ⅳ．水門・樋門及び堰編―，令和2年2月（令和2年6月一部追記）,国土交通省水管理・国土保全局.

＜参考となる資料＞

1.  道路橋示方書・同解説 Ⅳ下部構造編，平成24年3月, （社）日本道路協会.

    （最新版）道路橋示方書・同解説Ⅳ下部構造編，平成29年11月,（公社）日本道路協会.

```{=html}
<!-- -->
```
30. 杭基礎設計便覧（平成26年度改訂版），平成27年3月,(公社) 日本道路協会.

    （最新版）杭基礎設計便覧（令和2年度改訂版），令和2年9月,(公社)日本道路協会.

    1.  []{#_Toc100563618 .anchor}遮水工

＜考え方＞

+----------------------------------------------------------------------+
| 遮水工は、堰柱や床版及び水叩き下部                                   |
| の土砂流動と、洗掘による土砂の吸出しにより、堰が堤防の弱点となること |
| を防止するために設ける。本体及び水叩き端部に設けられる遮水工は、取付 |
| 擁壁及び護岸に設置する遮水工と連続させる。また、取付擁壁に設ける遮水 |
| 工は、本体及び水叩き端部に設けられる遮水工と同規模とする必要がある。 |
|                                                                      |
| 遮水工の深さ及び水平方向の長さは、                                   |
| 水頭差、遮水工の配置を考慮したうえで、レインの式などにより浸透経路長 |
| を検討し設定する必要がある。また、遮水工には構造計算上の荷重は分担さ |
| せない。遮水工には一般的に鋼矢板が用いられるが、鋼矢板以外の材料とす |
| る場合は、材料の強度、耐久性、遮水効果について検討を行う必要がある。 |
+----------------------------------------------------------------------+

＜必　須＞

  ------------------------------------------------------------------------------------------------------------
  遮水工は、必要な水密性を有する構造とし、地盤条件や施工条件に対して安全な構造となるよう設計するものとする。
  ------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 遮水工は、堰上下流                                                   |
| の水位差によって生じる浸透水の動水勾配を減少させ、堰下部の土砂の流動 |
| 及び土砂の吸出しを防止するため、適切な位置に設けることを基本とする。 |
|                                                                      |
| 遮水工の構造は、原則としてコンクリート構造のカットオフ又は鋼矢板     |
| 構造とし、遮水工の深さ、水平方向の長さは、堤防断面形状、水頭差、浸透 |
| 経路長、過去の事例などを総合的に検討の上で決定することを基本とする。 |
+----------------------------------------------------------------------+

＜推　奨＞

+----------------------------------------------------------------------+
| １）配置                                                             |
|                                                                      |
| 遮水工は、図7-27及び図7-28に示すように、床版、水叩き下               |
| 部、堰の堤防等への取付部及び堰の上下流の取付擁壁の底版下部等に設けら |
| れるが、大規模な堰の場合には遮水工の設置によって、浸透経路長を長くす |
| ることにより揚圧力を減殺し、床版、水叩き厚を薄くする効果もあるので、 |
| 遮水工の長さはこれらの効果を総合的に検討して決定することが望ましい。 |
|                                                                      |
| ![](media/image88.png){width="2.987169728783902in"                   |
| height="0.9913035870516186in"}                                       |
|                                                                      |
| 53. 遮水工(カットオフ)                                               |
|                                                                      |
| ![](media/image89.png){width="5.037688101487314in"                   |
| height="2.7656014873140857in"}                                       |
|                                                                      |
| 54. 遮水工（鋼矢板構造）                                             |
|                                                                      |
| ２）構造                                                             |
|                                                                      |
| 遮水工は、床版水叩き及                                               |
| び堰の取付部分にすべて連続させた構造として設計することが望ましい。な |
| お、軟弱地盤における遮水工は、本体及び水叩きと離脱しない構造とする。 |
|                                                                      |
| 遮水工の根入れ長は、原則として設置間隔                               |
| の1/2以内とし、1/2以上の長さとなる場合は、水叩き長さを延ばすなどの措 |
| 置を講じることが望ましい。また、遮水工の矢板長を極端に変化させること |
| は好ましくない。なお、上流側遮水工をわずかに延ばすことで確実な不透水 |
| 層に届く場合は、この限りではない。不透水層に届くように遮水工の根入れ |
| 長を決定した場合の揚圧力は、必要に応じ0～50%に低減することができる。 |
|                                                                      |
| 堤防との取付部の遮水工についても平面                                 |
| 的な浸透経路長を計算し、堤防方向への根入れ長を決めることが望ましい。 |
|                                                                      |
| ３）鋼矢板を遮水工として用いる場合の留意点                           |
|                                                                      |
| 鋼矢板は遮水工として用いる場合、安全性、現場条件及び鋼矢板の市       |
| 場性を考慮したうえで、経済比較を行い、適切に選定することが望ましい。 |
+----------------------------------------------------------------------+

[]{#_Toc100563619 .anchor}

1.  取付擁壁・護岸

＜考え方＞

+----------------------------------------------------------------------+
| 洪水時には河床そのものが動いており、堰の設置によってその連続性が失   |
| われるので、その上下流において射流の有無にかかわらず局所的な洗掘が生 |
| じやすい。このため、堰の上下流の河岸又は堤防には、しかるべき範囲に護 |
| 岸を設ける必要がある。その範囲は、上流側は堰の上流端から10mの地点又  |
| は護床工の上流端から5mの地点のうちいずれか上流側の地点、下流側の水叩 |
| きの下流端から15mの地点又は護床工の下流端から5mの地点のうちいずれか  |
| 下流側の地点までの範囲を最低限として設ける必要がある（図7-29参照）。 |
|                                                                      |
| この区間のうち、堰の                                                 |
| 直下流では、特に流水の乱れが激しく、河岸部に強いせん断力が発生し、ま |
| た、高水敷からの落込流による河岸侵食のおそれもある。このため、この区 |
| 間では強固な河岸防護工として取付擁壁構造の護岸を設置する必要がある。 |
|                                                                      |
| ![ダイアグラム                                                       |
| 自動                                                                 |
| 的に生成された説明](media/image90.png){width="3.9194444444444443in"  |
| height="2.9444444444444446in"}                                       |
|                                                                      |
| 55. 堰の設置に伴い必要となる護岸を設置する最小範囲                   |
|                                                                      |
| > ![](media/image91.png){width="4.517929790026247in"                 |
| > height="3.5974026684164477in"}                                     |
|                                                                      |
| 56. 護岸を設ける区間のうち取付擁壁構造の護岸とする区間               |
|                                                                      |
| 護岸の形式及び構造は、改訂                                           |
| 護岸の力                                                             |
| 学設計法を参考に設定する必要がある。護岸には、多くの形式があり、使用 |
| される素材、構造の外観等はさまざまであるが、設置箇所の河道特性や周辺 |
| の護岸形式及び構造に加え、環境や景観にも配慮して設計する必要がある。 |
+----------------------------------------------------------------------+

＜必　須＞

+----------------------------------------------------------------------+
| 護岸は、流水の変化に伴う河岸又は堤防の洗掘を防止するために設け       |
| るものとし、設計流速に対して安全な構造となるよう設計するものとする。 |
|                                                                      |
| また                                                                 |
| 、取付擁壁の構造は、堤防の機能を損なわず流水の乱れに伴って生じる河岸 |
| 侵食を防止するように、仮に堰本体及び水叩きが消失しても安定である構造 |
| （堰本体及び水叩きをなしとした場合の安定計算を行う必要がある）とする |
| ものとし、必要に応じて周辺景観との調和に配慮して設計するものとする。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 堰の設置に伴い必要                                                   |
| となる取付擁壁・護岸は、以下の事項を設計に反映することを基本とする。 |
|                                                                      |
| １）堰の設置に伴い必要となる護岸は、以下により設定する。             |
|                                                                      |
| > ①堰に接する河岸又は堤防の護岸は、上流側は堰の上流端から10m         |
| > の地点又は護床工の上流端から5m                                     |
| >                                                                    |
|  の地点のうちいずれか上流側の地点から、下流側は水叩きの下流端から15m |
| > の地点又は護床工の下流端から5m                                     |
| > の地点のうちいずれか下流側の地点までの区間以上の区間に設ける。     |
| >                                                                    |
| > ②前項に掲げるもののほか、河岸又は堤防の護岸は、湾曲部で            |
| あることその他、河川の状況等により特に必要と認められる区間に設ける。 |
| >                                                                    |
| > ③河岸（低水路の河岸を除く）又は堤防の                              |
| 護岸の高さは、計画高水位とするものとする。ただし、堰の設置に伴い流水 |
| が著しく変化することとなる区間にあっては、河岸又は堤防の高さとする。 |
|                                                                      |
| ④低水路の河岸の護岸の高さは、低水路の河岸の高さとする。              |
|                                                                      |
| ２）取付擁壁の設置範囲は、堰本体の構造、堤防                         |
| 法線の線形、護岸の形式、魚道、土砂吐き、閘門の有無及びその位置等を考 |
| 慮して必要な区間に設ける。ただし、必要最小限水叩きの区間まで設ける。 |
|                                                                      |
| > なお、固定堰において                                               |
| は、取付擁壁の設置範囲は、堰下流側では跳水の発生区間を原則とする。　 |
+----------------------------------------------------------------------+

　

＜推　奨＞

  -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  直壁形状の取付擁壁は、拡幅した形状として下流の河岸に取り付けられるが、この場合、下流の河岸部においては、取付擁壁に沿う流れと本体を直進してきた流れが集中することによって局所で大きな洗掘力が生じる。このため、取付擁壁の下流側護岸とのすり付け角度は、流水のはく離が生じないとされている角度とすることが望ましい。その角度は、既往の実験結果によると、11 度程度を目安とするとはく離流の発生が防止できるという結果が報告されている。
  -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜参考となる資料＞

取付擁壁・護岸の設計に当たっては、下記の資料が参考となる。

1.  改訂 護岸の力学設計法, 平成 19 年 9 月,（財）国土技術研究センター.

    （最新版）改訂 護岸の力学設計法，2023，（一財）国土技術研究センター.

    1.  []{#_Toc100563620 .anchor}高水敷保護工

＜考え方＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  流水が高水敷を流下する場合、堰付近では流水の乱れにより護岸の肩部分及び高水敷内に設けられた構造物の部分（例えば魚道）が特に洗掘されやすい。したがって、高水敷内の構造物周辺及び護岸肩部分については、コンクリートブロック、コンクリート床版等によって保護する。この場合、粗度を急変させないよう留意する。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

![ダイアグラム, 概略図
自動的に生成された説明](media/image92.png){width="3.8645833333333335in"
height="3.4in"}

57. 高水敷保護工の敷設例

＜必　須＞

  ----------------------------------------------------------------------------------------------------------------------
  高水敷保護工は、堰に接続する高水敷の洗掘を防止するために設けるものとし、設計流速に対して安全な構造とするものとする。
  ----------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 高水敷保護工は、流水等の作用                                         |
| による高水敷の洗掘を防止するため、高水護岸前面に設けることを基本とす |
| る。高水敷保護工の構造は、河川環境や景観に配慮した構造を基本とする。 |
|                                                                      |
| 高水敷保護工は、「7.6.6                                              |
| 取付擁壁・護岸」で示す護岸の範囲において設けることを基本とする。     |
+----------------------------------------------------------------------+

[]{#_Toc100563621 .anchor}

1.  魚道，閘門、土砂吐き

＜考え方＞

+----------------------------------------------------------------------+
| 堰には、自然環境保全、舟の通行、安定                                 |
| 取水のため必要があるときは、魚道、閘門、土砂吐きを設ける必要がある。 |
|                                                                      |
| 魚道の規模、構造形式は、対象となる魚種とそ                           |
| の習性、利用可能な流量、魚道上・下流の水位変動等を考慮して決定する。 |
|                                                                      |
| 閘門の規模、設置位置は対象となる舟種を考慮の上決定する。             |
|                                                                      |
| 土砂吐きの規模、設置位置は非洪水時の堰上流                           |
| の堆砂の防止及び堰下流への土砂の供給の機能が確保されるよう決定する。 |
+----------------------------------------------------------------------+

＜必　須＞

+----------------------------------------------------------------------+
| 堰を設ける場合                                                       |
| において、魚類の遡上等を妨げないようにするため必要があるときは、魚道 |
| を設けるものとする。魚道の構造は、次に定めるところによるものとする。 |
|                                                                      |
| １）堰の直上流及び直下流部における通                                 |
| 常予想される水位変動に対して魚類の遡上等に支障のないものとすること。 |
|                                                                      |
| ２）堰に接続する河床の状況、魚道                                     |
| の流量、魚道において対象とする魚類等を適切に考慮したものとすること。 |
+----------------------------------------------------------------------+

　

＜標　準＞

+----------------------------------------------------------------------+
| 堰に魚道や閘門を設ける場合には、以下を基本する。                     |
|                                                                      |
| １）魚道の規模（延長、幅員等）、形式は                               |
| 、対象となる魚種の習性や魚道通過時の成長の度合いを考慮して決定する。 |
|                                                                      |
| ２）閘門                                                             |
| には，船舶の航行に支障を及ぼさないよう導流壁を必要な長さまで設ける。 |
|                                                                      |
| ３）閘門の開室の有効幅と有効長さは、次のように定める。               |
|                                                                      |
| > 有効幅＝対象船舶の幅×配列数＋余裕                                  |
| >                                                                    |
| > 有効長さ＝対象船舶の長さ×縦方向隻数＋余裕                          |
|                                                                      |
| ４）閘門ゲート開閉の所要時間は、通航船の通過時間に与                 |
| える影響、開閉装置の機構と規模、経済性等を総合的に判断して決定する。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  魚がのぼりやすい川づくりの手引き，平成17年3月,国土交通省河川局.

＜参考となる資料＞

魚道の設計に当たっては、下記の資料が参考となる。

1.  最新　魚道の設計，平成10年8月,一般社団法人ダム水源地環境整備センター.

```{=html}
<!-- -->
```
31. 技術者のための魚道ガイドライン，平成23年9月,NPO法人
    北海道魚道研究会.

32. 多自然型魚道マニュアル，平成10年1月,リバーフロント整備センター.

    1.  []{#_Toc100563622 .anchor}付属施設

```{=html}
<!-- -->
```
1.  管理橋

＜考え方＞

+----------------------------------------------------------------------+
| 堰の開閉（起伏                                                       |
| ）操作及び維持管理、河川管理用通路、一般の道路橋として利用するため、 |
| 管理橋を設ける場合は、堰左右岸の堤防天端を円滑に接続する必要がある。 |
|                                                                      |
| 管理橋の桁下                                                         |
| 高は、流下断面を阻害しないことを目的に、計画堤防高以上とする必要があ |
| る。管理橋の橋面高は、取付道路の構造等を確認し、路盤が計画堤防断面内 |
| に入らないような高さとする必要がある。管理橋の構造は、設計自動車荷重 |
| やゲート等の維持管理時の重機荷重を考慮して、適切な構造とする必要があ |
| る。設計自動車荷重の設定において、堰に接続する堤防は水防活動上必要な |
| 道路として耐えられる設計自動車荷重であるにもかかわらず、堰の管理橋だ |
| けがそれに耐えられないのは極めて不都合であるため、配慮が必要である。 |
|                                                                      |
| ただし、管理橋の幅員が3ｍ未満の場合はこの限りではなく、堰の維持      |
| 管理上必要な荷重を勘案したうえで設計自動車荷重を設定する必要がある。 |
|                                                                      |
| 管理橋の幅員は、接続する管理用通路の幅                               |
| 員、交通量、その重要性等と、堰管理及び水防時の交通を考慮して決定する |
| 必要がある。ただし、兼用道路の場合は道路管理者と協議する必要がある。 |
+----------------------------------------------------------------------+

＜必　須＞

  ------------------------------------------------------------------------------------------------
  堰の管理を目的として設置する管理橋は、設計荷重に対して安全な構造となるよう設計するものとする。
  ------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 管理橋は、堰の操作、河川管理用通路、一般道として利用す               |
| るため、堰柱上に設置し堤防天端と接続するよう設けることを基本とする。 |
|                                                                      |
| 管理橋の桁下高は、計画高水                                           |
| 位に余裕高を加えた堤防高さ（現状の堤防の高さが計画堤防の高さより高い |
| 場合には現状の堤防の高さ）以上とすることを基本とする。管理用通路とし |
| ての効用を兼ねる管理橋の設計自動車荷重は、堰に接続する管理用通路の設 |
| 計自動車荷重を考慮して20t以上の適切な値を設定することを基本とする。  |
|                                                                      |
| ただし、管理橋の幅員が3ｍ未満の場合や兼用道路にならない              |
| 場合はこの限りでない。堰に接続する堤防が兼用道路の場合で、設計自動車 |
| 荷重を道路構造令（昭和45年政令第320号）第35条第2項に規定する25tとし  |
| ている場合には、設計自動車荷重を25ｔとすることを標準とする。また、河 |
| 川管理上必要と認められる場合には、設計自動車荷重を25ｔとしてもよい。 |
|                                                                      |
| 管理橋の幅員は、堰                                                   |
| に接続する管理用通路の幅員を考慮した適切な値とすることを基本とする。 |
+----------------------------------------------------------------------+

＜推　奨＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  近年は、歩行者や自転車への管理橋の一般開放が行われていることから、設計に当たっては、高欄等の安全施設は、歩行者や自転車の安全性も考慮した設計強度等を設定の上、設計することが望ましい。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

29. その他付属施設

＜考え方＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  付属施設には、管理所、警報設備、水位観測設備、照明設備、CCTV設備、管理用階段、ゲート操作用階段、防護柵、タラップ等があり、維持管理及び低水時、洪水時の操作に必要な施設を設ける必要がある。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

  --------------------------------------------------------------------------------
  堰には、維持管理及び操作のため、必要に応じて付属施設を設けることを基本とする。
  --------------------------------------------------------------------------------

[]{#_Toc100563625 .anchor}

1.  既存施設の自動化・遠隔化

＜考え方＞

+----------------------------------------------------------------------+
| 新設の堰のゲートの操                                                 |
| 作のための設備については、必要に応じて自動化、遠方操作化や遠隔操作化 |
| を検討することとしているが、既存の堰のゲートの操作のための設備につい |
| ても、堰の目的、規模、操作員の負担軽減や安全の確保等の管理体制を踏ま |
| え、必要に応じて自動化、遠方操作化や遠隔操作化を検討することとする。 |
|                                                                      |
| 自動化は、計                                                         |
| 測した水位に応じて自動で開閉操作を行うことができるように改造すること |
| や、ゲート自体を自動開閉が可能なものとすることであり、遠方操作化、遠 |
| 隔操作化は、管理所や遠隔地から操作を行うことを可能とすることである。 |
+----------------------------------------------------------------------+

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------
  堰のゲートの操作のための設備については、必要に応じて自動化、遠方操作化や遠隔操作化を検討することを基本とする。
  ----------------------------------------------------------------------------------------------------------------

1.  []{#_Toc100749537 .anchor}堰構造に関するその他の事項

＜考え方＞

+----------------------------------------------------------------------+
| １）気候変動等を踏まえた施設設計について                             |
|                                                                      |
| 気候変動による将来の予測と                                           |
| して、降雨量の増加、平均海面水位の上昇、潮位偏差及び年最大波などの極 |
| 値の増加等が想定されており、外力が増加する可能性があることにも留意し |
| て設計する必要がある。そのため、堰等の耐用期間の長い施設については、 |
| 外力の増加への対応として、大規模な改良とならないよう補強しやすい構造 |
| とする又は、あらかじめ対策を施すなどの「構造上の工夫」が求められる。 |
|                                                                      |
| また                                                                 |
| 、堰の設備においては、マスプロダクツ化や故障することも考慮した機能確 |
| 保「Ｎ＋１保全」の考え方を取り入れた設計に配慮することも考えられる。 |
|                                                                      |
| ２）ICTやBIM/CIMの利用                                               |
|                                                                      |
| i-Construction推進の一環として、ICTによる建設生産プロセスのシームレ  |
| ス化が取り組まれている。UAV写真測量やレーザースキャナー計測などで得  |
| られる3次元点群データを活用することで、現況地形や既設物の構造を様々  |
| な角度・断面から把握することができ、新設・改築する施設の3次元モデル  |
| を作成し活用することで、構造に関して関係者の理解と合意形成が促進され |
| る。このため、施工段階、施工後の点検・補修・修繕の段階においてBIM/C  |
| IMを積極的に活用し、堰本体及び堰周辺の堤防を適切に維持管理していくこ |
| とができるように、設計成果を3次元モデルに反映しておくと有用である。  |
+----------------------------------------------------------------------+

＜例　示＞

+----------------------------------------------------------------------+
| 気候変動により外力が増大し、                                         |
| 将来、施設の改造が必要になった場合でも、外力の増大に柔軟に追随できる |
| 、できるだけ手戻りの少ない設計を実施している以下のような事例がある。 |
|                                                                      |
| ・水門では、耐用年数内                                               |
| の平均海面水位の上昇量を想定し、改造等が容易な構造形式の選定、追加的 |
| な補強が困難な門柱部の嵩上げ及び基礎部補強をあらかじめ実施している。 |
+----------------------------------------------------------------------+

＜関連通知等＞

気候変動等を踏まえた施設設計及びICTやBIM/CIMの利用については、下記の資料が参考となる。

1.  河川機械設備のあり方について（中間とりまとめ），令和 3 年 8 月 31
    日,国土交通省.

    （最新版）河川機械設備のあり方について，令和 4 年 7 月 29
    日,国土交通省.

```{=html}
<!-- -->
```
33. CIM 導入推進委員会：CIM 導入ガイドライン（案），令和 3 年 3
    月,国土交通省.

    （最新版）国土交通省：BIM/CIM 活用ガイドライン（案），令和 4 年 3
    月.

第1章　河川構造物の設計 {#第1章-河川構造物の設計-5 .目次の見出し1}
=======================

第8節　樋門 {#第8節-樋門 .目次の見出し1}
===========

目　次 {#目-次-4 .目次の見出し1}
======

[第8節 樋門 1](#_Toc47014747)

> [8．1 総説 1](#_Toc47014748)
>
> [8．1．1 適用範囲 1](#_Toc47014749)
>
> [8．1．2 用語の定義 1](#_Toc47014750)
>
> [8．2 機能 2](#_Toc47014751)
>
> [8．3 設計の基本 2](#_Toc47014752)
>
> [8．4 基本的な構造 5](#_Toc47014753)
>
> [8．4．1 函渠の内空断面の設定 5](#_Toc47014754)
>
> [8．4．2 函渠長 7](#_Toc47014755)
>
> [8．4．3 門柱の天端高 8](#_Toc47014756)
>
> [8．4．4 材質と構造 8](#_Toc47014757)
>
> [8．4．5 樋門周辺の堤防 11](#_Toc54772908)
>
> [8．5 安全性能の照査等 12](#_Toc47014759)
>
> [8．5．1 設計の対象とする状況と作用 12](#_Toc47014760)
>
> [8．5．2 安全性能の照査 21](#_Toc54772911)
>
> [8．5．3 許容応力度 25](#_Toc54772912)
>
> [8．6 各部位の設計等 27](#_Toc47014763)
>
> [8．6．1 本体 27](#_Toc47014764)
>
> [8．6．2 胸壁 35](#_Toc47014765)
>
> [8．6．3 翼壁 36](#_Toc47014766)
>
> [8．6．4 水叩き 37](#_Toc47014767)
>
> [8．6．5 遮水工 38](#_Toc47014768)
>
> [8．6．6 基礎 39](#_Toc47014769)
>
> [8．6．7 護床工 40](#_Toc47014770)
>
> [8．6．8 護岸 41](#_Toc47014771)
>
> [8．6．9 取付水路 42](#_Toc47014772)
>
> [8．6．10 高水敷保護工 43](#_Toc47014773)
>
> [8．6．11 付属施設 43](#_Toc40775265)
>
> [8．6．12 既存施設の自動化・遠隔化 43](#_Toc54772925)
>
> [8．7 樋門構造に関するその他の事項 44](#_Toc47014775)

令和3年4月　版

適用上の位置付け

　河川砂防技術基準設計編は、基準の適用上の位置付けを明確にするために、下表に示すように適用上の位置付けを分類している。

+--------+------------------+------------------+------------------+
| 分　類 | 適用上の位置付け | 末尾の字句例     |                  |
+--------+------------------+------------------+------------------+
| 考え方 | 技術資料         | ●目              | 「･･･ある。      |
|        |                  | 的や概念、考え方 | 」「･･･いる。」  |
|        |                  | を記述した事項。 |                  |
|        |                  |                  | 「･･･なる。      |
|        |                  |                  | 」「･･･れる。」  |
+--------+------------------+------------------+------------------+
| 必　須 | 技術基準         | ●法令による規定  | 「･･･なければ    |
|        |                  | や技術的観点から | ならない。」「･  |
|        |                  | 実施すべきである | ･･ものとする。」 |
|        |                  | ことが明確であり |                  |
|        |                  | 遵守すべき事項。 |                  |
+--------+------------------+------------------+------------------+
| 標　準 | 技術基準         | ●特              | 「･･･            |
|        |                  | 段の事情がない限 | を標準とする。」 |
|        |                  | り記述に従い実施 |                  |
|        |                  | すべきだが、状況 | 「･･･            |
|        |                  | や条件によって一 | を基本とする。」 |
|        |                  | 律に適用すること |                  |
|        |                  | はできない事項。 | 「･･･による。」  |
+--------+------------------+------------------+------------------+
| 推　奨 | 技術資料         | ●状況や条件      | 「               |
|        |                  | によって実施する | ･･･望ましい。」  |
|        |                  | ことが良い事項。 |                  |
|        |                  |                  | 「               |
|        |                  |                  | ･･･推奨する。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･務める。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･必要に応    |
|        |                  |                  | じて･･･する。」  |
+--------+------------------+------------------+------------------+
| 例　示 | 技術資料         | ●適用条件や実施  | 「               |
|        |                  | 効果について確定 | ･･･などの手法（  |
|        |                  | している段階では | 事例）がある。」 |
|        |                  | ないが、状況や条 |                  |
|        |                  | 件によっては導入 | 「･･･など        |
|        |                  | することが可能な | の場合がある。」 |
|        |                  | 新技術等の例示。 |                  |
|        |                  |                  | 「･･･など        |
|        |                  | ●状              | が考えられる。」 |
|        |                  | 況や条件によって |                  |
|        |                  | 限定的に実施でき | 「               |
|        |                  | る技術等の例示。 | ･･･の場合には･･･ |
|        |                  |                  | ことができる。」 |
|        |                  | ●具体的          |                  |
|        |                  | に例示することに | 「               |
|        |                  | より、技術的な理 | ･･･例示する。」  |
|        |                  | 解を助ける事項。 |                  |
|        |                  |                  | 「例えば･･･。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･事例もある  |
|        |                  |                  | 。･･･もよい。」  |
+--------+------------------+------------------+------------------+

  関連通知等       関連する通知やそれを理解する上で参考となる資料
  ---------------- ------------------------------------------------------
  参考となる資料   例示等に示した手法・内容を理解する上で参考となる資料

8.  []{#_Toc47014747 .anchor}樋門

    1.  []{#_Toc47014748 .anchor}総説

        1.  []{#_Toc47014749 .anchor}適用範囲

＜考え方＞

+----------------------------------------------------------------------+
| 本節は、樋門を新設或いは改築する場合の                               |
| 設計に適用する。ただし、既設の樋門の安全性能の照査にも構造形式や現地 |
| の状況等に応じ必要かつ適切な補正を行ったうえで準用することができる。 |
|                                                                      |
| 当該施設の横断する河川又                                             |
| は水路が合流する河川（本川）の堤防を分断して設けるものは水門、堤体内 |
| に函渠を設けるものは樋門であり、水門と樋門とでは河川管理施設等構造令 |
| の適用が異なる。施設の設置に当たっては、用途、施設規模、施工性、経済 |
| 性等を考慮して水門と比較検討のうえ施設形式を決定する。通常、支川がセ |
| ミバック堤（半背水堤）の場合は水門を採用し、自己流堤の場合は樋門を採 |
| 用することが多い。また、河川管理施設等構造令では、樋門と樋管の区別は |
| なく、通常樋管と称しているものも樋門に含めて取り扱うこととしている。 |
+----------------------------------------------------------------------+

＜標　準＞

  ----------------------------------------------------------------------
  本節は、樋門（樋管を含む）を新設或いは改築する場合の設計に適用する。
  ----------------------------------------------------------------------

＜関連通知等＞

1.  河川管理施設等構造令，昭和 51 年 7 月 20 日，政令第199号．

    1.  []{#_Toc47014750 .anchor}用語の定義

＜考え方＞

+----------------------------------------------------------------------+
| 樋門は、                                                             |
| 本体と胸壁、翼壁、水叩き、遮水工、基礎及び管理橋、操作室等の付属施設 |
| の各部位によって構成される。このうち、本体は、ゲート、函渠（管渠を含 |
| む）、遮水壁、門柱、ゲートの操作台で構成される。そのほか、樋門の設置 |
| に伴い、一体で整備するものとして、護床工、護岸、高水敷保護工がある。 |
|                                                                      |
| 樋門のゲートが引上式の場合の各部位の名称は図8-1による。              |
|                                                                      |
| ![](media/image93.png){width="5.398844050743657in"                   |
| height="3.3489435695538057in"}                                       |
|                                                                      |
| 58. 樋門の各部位の名称（ゲートが引上式の場合）                       |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| > 次の各号に掲げる用語の定義は、それぞれ以下に示す。                 |
|                                                                      |
| 4.  柔構造樋門：沈下を許容する直接基礎の樋門                         |
|                                                                      |
| 5.  剛構                                                             |
| 造樋門：非たわみ性構造の函渠で、沈下の影響を無視できる直接基礎の樋門 |
|                                                                      |
| 6.  残留沈下量：函渠直下における函渠設置後の地盤の沈下量             |
|                                                                      |
| 7.  樋門周辺の堤防：樋門本体直上及びその周辺の堤防で、開削や地盤改良 |
| 等の施工の影響を受ける範囲或いは抜け上がり等の樋門の影響を受ける範囲 |
+----------------------------------------------------------------------+

1.  []{#_Toc47014751 .anchor}機能

＜考え方＞

  ----------------------------------------------------------------------------------
  樋門は、堤防機能及び設置目的を達成するために必要な機能を有することが求められる。
  ----------------------------------------------------------------------------------

＜必　須＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  樋門は、ゲートを全閉することにより、堤防機能を有するよう設計するとともに、ゲート全閉時以外において、当該施設の設置目的に応じて、取水機能、排水機能、舟を支障なく通行させる機能を有するよう設計するものとする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1.  河川管理施設等構造令，昭和 51 年 7 月 20 日，政令第199号．

    1.  []{#_Toc47014752 .anchor}設計の基本

＜考え方＞

+----------------------------------------------------------------------+
| 設計に当                                                             |
| たっては、以下の事項について検討し、設計に反映することが求められる。 |
|                                                                      |
| １）基本方針                                                         |
|                                                                      |
| 樋門の設計に当たって                                                 |
| は、樋門が堤体内に函渠を設ける施設であること及び「8.2機能**」**に示  |
| す事項を踏まえ、樋門の安全性のみならず、樋門周辺の堤防の安全性の確保 |
| も重要であり、樋門と樋門周辺の堤防を一体的に設計する必要がある。この |
| ため、樋門の設置に当たっては、樋門の数は最小限とし、可能な限り統廃合 |
| に努めるとともに、樋門及び樋門周辺の堤防が一連区間の中で相対的な弱点 |
| とならないよう、樋門の構造及び施工についても十分考慮する必要がある。 |
|                                                                      |
| また、周辺の河川環境との調和を図り、環境保全に配慮すると             |
| ともに、地域の水環境及び景観が損なわれないように配慮する必要がある。 |
|                                                                      |
| ２）樋門の位置                                                       |
|                                                                      |
| 樋門の位置は、「計画編 施設配置等計画編 第2章 河川施設配置計画       |
| 第2-1章 河道並びに河川構造物 第5節 堰、水門、樋門 5.1                |
| 設置の基本」を踏まえ、堤内地の地形、地盤高、水路系統、水路敷         |
| 高及び洪水時の本川の特性等を調査し、本川の湾曲部、水衝部、河床の不安 |
| 定な箇所、既設の樋門に近接した箇所、基礎地盤が軟弱な箇所、堤防又は基 |
| 礎地盤に漏水履歴がある箇所を避けて計画するとともに、排出水の水質等に |
| より他の利水施設及び周辺環境に支障を及ぼさない地点とする必要がある。 |
|                                                                      |
| ３）函渠の平面配置                                                   |
|                                                                      |
| 樋門は、一連区間                                                     |
| の中で相対的な弱点となるおそれがある構造物である。堤防への影響範囲を |
| 最小化し、施工の確実性を図るため、函軸方向を堤防法線に直角にし、斜角 |
| にすることによる構造の複雑化を避ける必要がある。なお、高規格堤防にお |
| いては、高規格堤防特別地域が設定されるために、直交させることが困難な |
| ことが多い。高規格堤防特別区域内での函軸の方向は、滑らかに通水され、 |
| 土砂等の堆積のおそれがない限り、堤防法線に対して直角でなくてもよい。 |
|                                                                      |
| ４）基礎地盤及び堤体の地盤変位が樋門に及ぼす影響                     |
|                                                                      |
| 堤防における設計に反映すべき事項の「不同沈下に対する修復の容         |
| 易性」と「基礎地盤及び堤体の一体性及びなじみ」に対応する項目である。 |
|                                                                      |
| 函渠と樋門周辺の堤防では基礎地盤に作用する荷重が異なること（堤防縦断 |
| 方向の荷重の変化）や堤体形状等に起因し堤防横断方向にも荷重が変化する |
| こと等から、樋門周辺では不同沈下や水平変位のような地盤変位が生じる。 |
|                                                                      |
| また、                                                               |
| 樋門には、土とは性質が大きく異なるコンクリートや鋼材等の材料が用いら |
| れるため、基礎地盤や樋門周辺の堤防とのなじみが悪く、地盤変位が生じた |
| 場合に空洞や緩みが形成されやすい。このような空洞や緩みが洪水時に樋門 |
| 周辺で発生する漏水や決壊の主な原因であると考えられることから、樋門は |
| 一連区間の中で相対的な弱点になるおそれがある構造物である。空洞や緩み |
| のような局所的な事象は、照査の中では取り扱うことが極めて難しいことか |
| ら、樋門設置箇所の堤防が、一連区間におけるその他の堤防に対して堤防断 |
| 面が小さくならない等、相対的な弱点にならないような配慮が求められる。 |
|                                                                      |
| ５）樋門の敷高                                                       |
|                                                                      |
| 樋門の敷高は、排水を目的と                                           |
| するものにあっては、接続する河川の河床高又は水路の敷高を考慮し、取水 |
| を目的とするものにあっては、それぞれの取水目的に応じて定めるが、本川 |
| の将来の河床変動についても配慮する必要がある。また、舟の通行を目的と |
| するものにあっては、舟の通行に支障を及ぼさない敷高とする必要がある。 |
|                                                                      |
| ６）構造形式                                                         |
|                                                                      |
| 樋門においては、地震時に堤                                           |
| 体との接触面である程度の空隙が生じることは避けられない。また、樋門と |
| 堤体では重量差があり、地盤に伝わる荷重が異なるため、樋門の沈下と堤防 |
| の沈下とは一般に差異があるが、このことによっても樋門と堤体との接触面 |
| には空隙が生じることがある。樋門と堤体との接触面に空隙等が生じると、 |
| それが原因となって、漏水や堤体を構成する土粒子の移動が起こりやすく、 |
| これらの作用が繰り返され、空隙が拡大・進展し、連続した大きな空洞が形 |
| 成される。これらの現象は、樋門の基礎が杭基礎である場合や、樋門に接続 |
| する堤防並びに基礎地盤の土質条件が軟弱な場合に特に顕著である。このた |
| め、樋門の構造形式は、基礎地盤の残留沈下量及び基礎の特性等を考慮して |
| 選定を行い、杭（先端支持杭及び摩擦支持杭）基礎等の不同沈下により空洞 |
| 化が生じやすい基礎形式を避け、柔構造樋門として設計を行う必要がある。 |
|                                                                      |
| なお、良質な地盤に支持され、沈                                       |
| 下の影響を無視できる場合には、直接基礎の剛構造樋門を採用してもよい。 |
| また、地盤が良質ではなく沈下することは分かっているが、どの程度沈下す |
| るか予測ができず柔構造樋門以外の構造を採用せざるを得ない場合がある。 |
|                                                                      |
| ７）ゲート設備                                                       |
|                                                                      |
| ゲート設備の設計に当たっては、ゲートは、確実                         |
| に開閉し、かつ、必要な水密性及び耐久性を有する構造が求められ、開閉装 |
| 置は、ゲートの開閉を確実にできる構造が求められる。また、常用電源が喪 |
| 失した場合に備え、予備動力や急降下閉鎖装置等を設けるなど、必要最小限 |
| な機能を維持できることが求められる。なお、想定外の外力が働いた場合に |
| おいても、必要なゲート操作は可能となるように配慮することが望ましい。 |
|                                                                      |
| ８）安全、確実・円滑な施工                                           |
|                                                                      |
| 樋門の施工                                                           |
| では、掘削中のボイリングや重機の転倒など、安全を脅かす状況が発生する |
| 可能性がある。このため、設計においても、安全で確実・円滑な施工が可能 |
| となるような配慮が求められ、施工上の制約から構造が決まることもある。 |
|                                                                      |
| ９）機能を長期的に容易に維持できる構造                               |
|                                                                      |
| 長期的に機能を低下させる要因としては、圧密による地                   |
| 盤変位の進行、河床変動や土砂堆積があり、これらに配慮する必要がある。 |
|                                                                      |
| １０）維持管理に配慮した構造                                         |
|                                                                      |
| 樋門の点検、修繕、更                                                 |
| 新等の作業を容易に行うため、維持管理に配慮した構造とする必要がある。 |
+----------------------------------------------------------------------+

＜必　須＞

+----------------------------------------------------------------------+
| 設計に当たっては、以下の事項を反映するものとする。                   |
|                                                                      |
| 1.  樋門は、計画高水位（高潮区間にあっては、計画高                   |
| 潮位）以下の水位の流水の作用に対して安全な構造となるよう設計するもの |
| とする。また、高規格堤防設置区間及び当該区間に係る背水区間における樋 |
| 門にあっては、前述の規定によるほか、高規格堤防設計水位以下の水位の流 |
| 水の作用に対して耐えることができる構造となるよう設計するものとする。 |
|                                                                      |
| 2.  樋門は、計画高水位                                               |
| 以下の水位の洪水の流下を妨げることなく、周辺の河岸及び河川管理施設等 |
| の構造に著しい支障を及ぼさず、並びに樋門に接続する河床及び高水敷等の |
| 洗掘の防止について適切に配慮された構造となるよう設計するものとする。 |
|                                                                      |
| 3.  樋門は、樋門周辺の堤防との不同沈下或                             |
| いは空洞化をできるだけ小さく留める構造となるよう設計するものとする。 |
|                                                                      |
| 4.  樋門は、常用電源が喪失し                                         |
| た場合においても必要最小限な開閉操作ができるよう設計するものとする。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 1.  設計に                                                           |
| 当たっては、樋門に求められる機能を満足するように樋門の位置、函渠の配 |
| 置、樋門の敷高、構造形式を設定するとともに、設計の対象とする状況と作 |
| 用に応じた安全性能を設定し、照査によりこれを満足することを確認する。 |
|                                                                      |
| ```{=html}                                                           |
| <!-- -->                                                             |
| ```                                                                  |
| 5.  環境及び景観と                                                   |
| の調和、構造物の耐久性、維持管理の容易性、施工性、事業実施による地域 |
| への影響、経済性及び公衆の利用等を総合的に考慮することを基本とする。 |
|                                                                      |
| 6.  函軸方向は、堤防方向に直角にすることを基                         |
| 本とするが、高規格堤防特別区域内での函軸方向は、滑らかに通水され、土 |
| 砂等の堆積のおそれがない場合は、堤防法線に対し直角にしなくてもよい。 |
|                                                                      |
| 7.  樋門の構造形式は、柔構造樋門を基本                               |
| とする。ただし、基礎地盤が良質な場合は、剛構造樋門を採用してもよい。 |
|                                                                      |
| 8.  樋門は、樋門に求められる機能を満足                               |
| するために、土砂が堆積しにくい構造となるよう設計するとともに、維持管 |
| 理上、堆積土砂等の排除に支障のない構造となるよう設計するものとする。 |
+----------------------------------------------------------------------+

＜推　奨＞

+----------------------------------------------------------------------+
| 1.  設計に当たっては、施工の合理化、省力化を図るため                 |
| 、函渠等のプレキャスト化、ユニット化の採用を検討することが望ましい。 |
|                                                                      |
| ```{=html}                                                           |
| <!-- -->                                                             |
| ```                                                                  |
| 9.  長期間継続                                                       |
| する基礎地盤の残留沈下は、本体の変位・断面力に大きな影響を及ぼすので |
| 、地盤改良等の対策工を行い、事前にできるだけ小さくするように努める。 |
|                                                                      |
| 10. 事前の地盤                                                       |
| 調査は、土層構成、土質、地下水の状況などを把握し、設計に必要な地盤性 |
| 状及び土層の特性等の条件を設定するため、ボーリング調査・現位置試験及 |
| び室内土質試験の組合せで実施することが望ましい。なお、事前の地盤調査 |
| 結果より軟弱地盤や透水性地盤が想定される場合には、各々の課題に対応し |
| た原位置試験等の調査・試験を実施したうえで設計に反映するよう努める。 |
|                                                                      |
| 11. 樋門が接続する河川の河床又は水路の敷高と本川の河床               |
| とに落差があるなどの状況により、内水位が本川水位より高くなる場合には |
| 、樋門と堤体との接触面に沿って内水が堤外に浸透することがある。この場 |
| 合、長年の間に樋門と堤体との接触面付近に大きな空隙が生じ、洪水時に突 |
| 然堤防決壊を引き起こすこともある。したがって、このような場合には、内 |
| 水が堤外に浸透することについても十分留意する必要があり、接続する河川 |
| 又は水路の取付護岸は必要な区間に遮水シートを有するコンクリート護岸等 |
| とするとともに、翼壁の接続部の水密性を保つようにすることが望ましい。 |
|                                                                      |
| 12. 排                                                               |
| 水のための樋門を設ける場合で、樋門から合流する河川（本川）までの間で |
| 段差等が生じており、魚類等の移動のため必要があるときは、当該河川及び |
| その接続する水路の状況等（必要な場合には関係者の意見を含む）を踏まえ |
| 、段差等の緩傾斜化、水深の確保等に配慮した構造とすることが望ましい。 |
|                                                                      |
| 13. 施工時では、盛土載荷後などの沈下                                 |
| に影響する施工段階に応じ、函体の沈下量を計測して設計時に想定された沈 |
| 下量以内となっているか観測を行うことが望ましい。また、沈下が想定より |
| も大きい場合には、門柱や継手において異常が生じていないか、グラウトホ |
| ールから函体底部と地盤の隙間がないかなどの確認を行うことが望ましい。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  国土交通省：河川砂防技術基準 計画編，施設配置等計画編 第2章
    河川施設配置計画 第2-1章 河道並びに河川構造物 第5節 堰、水門、樋門
    5.1 設置の基本．

```{=html}
<!-- -->
```
34. 国土交通省：ダム・堰施設技術基準（案）の一部改定について，平成28年3月31日，国技電第72号，国総公第80号，国水環第140号，国水治第142号．

35. 国土交通省河川局：[「多自然川づくり」の推進について](http://www.mlit.go.jp/notice/noticedata/pdf/200704/00004847.pdf)，平成18年10月13日，国河環第38号，国河治第86号，国河防第370号．

36. 国土交通省河川局：[美しい河川景観の形成と保全の推進について](http://www.mlit.go.jp/notice/noticedata/pdf/200704/00004847.pdf)，平成18年10月19日，国河環第40号，国河治第94号，国河防第376号．

37. （財）国土技術研究センター：[柔構造樋門設計の手引き（Ⅰ 共通編、Ⅱ
    基礎構造編）](http://www.jice.or.jp/tech/material/detail/3)，平成10年11月．

    1.  []{#_Toc47014753 .anchor}基本的な構造

        1.  []{#_Toc47014754 .anchor}函渠の内空断面の設定

＜考え方＞

+----------------------------------------------------------------------+
| 函                                                                   |
| 渠の内空断面は、内空幅と内空高で表される。内空高は流下断面に余裕高を |
| 加えた高さ、流下断面は計画高水流量又は計画流量が流下する断面である。 |
|                                                                      |
| 函渠の断面を大きくしすぎると、河                                     |
| 積が函渠で急拡することにより、流速が緩くなり、土砂が堆積しやすくなる |
| 。流下能力の観点のみから函渠の幅員を設定すると、支川の幅に比べて函渠 |
| の幅員が狭くなることがあり、流木等流下物の影響や縮流によるエネルギー |
| 損失のため洪水の円滑な疎通に支障を来すことがある。また、堆積土砂の排 |
| 除にも支障を来すことがある。このようなことから、求められる機能に加え |
| て、維持管理、経済性を勘案し、適切な断面を設定することが必要となる。 |
|                                                                      |
| 排水を目的とする樋門に                                               |
| あっては、支川の計画高水流量の流下を妨げず、函渠内の流速が接続する支 |
| 川の流速に比べて著しく増減することがない函渠の内空断面を設定する必要 |
| がある。このうち、内水排水を目的とする樋門にあっては、内水対策の計画 |
| 排水量に対応した函渠の内空断面とする必要がある。なお、計画排水量につ |
| いては、計画する樋門の流域（集水区域）、計画規模並びに降雨規模及び降 |
| 雨分布を定め、流域内の現況及び将来の土地利用状況を考慮して算出する。 |
|                                                                      |
| 取水を目的とす                                                       |
| る樋門にあっては、取水計画上問題とならない範囲において対象渇水時の計 |
| 画取水量が確保できる函渠の内空断面、また、舟の通行が見込まれる樋門に |
| あっては、舟の通行に支障を及ぼさない函渠の内空断面とする必要がある。 |
|                                                                      |
| 樋門の内空幅                                                         |
| は、門数を2連以上に増やせば増やすほど小さくなって、流木等流下物によ  |
| る閉塞の可能性が増大する。流木等流下物による閉塞は、洪水の円滑な疎通 |
| を阻害するばかりではなく、ゲートの開閉にも支障を及ぼしかねない。また |
| 、ゲートが横方向に極めて細長い形となる場合には、ゲート構造及び開閉機 |
| 等が同じ内空幅のゲートに比べ大規模となるため不経済なゲートとなる。以 |
| 上の観点から、樋門の内空幅は、流木等流下物に対する配慮とゲートの構造 |
| 上の制約という相反する要素の調整を図って適切なものとする必要がある。 |
|                                                                      |
| 2連以上の函渠の隔壁の端部は、ゲート戸当たりのため                    |
| 中央部の隔壁より厚くなることが多いが、函渠端部の通水断面が中央部より |
| 狭くなることがないよう、図8-2のように通水断面を確保する必要がある。  |
|                                                                      |
| ![](media/image94.png){width="2.2080916447944006in"                  |
| height="2.3282206911636045in"}                                       |
|                                                                      |
| 59. 2連以上の函渠端部                                                |
+----------------------------------------------------------------------+

＜必　須＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  函渠の内空断面は、支川の計画高水流量（取水の用に供する樋門にあっては計画取水量、舟の通行の用に供する樋門にあっては計画高水流量及び通行すべき舟の規模）、維持管理を勘案して設定するものとする。なお、河川（「準用河川」を含む）以外の水路が河川に合流する箇所において当該水路を横断して設ける樋門について準用するものとする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 函渠の内空断面は、次により設定することを基本とする。                 |
|                                                                      |
| 1.  内空断面                                                         |
|                                                                      |
| 函渠の内空断面は、内空幅・内空高とも1m以上とすることを標準とする。   |
|                                                                      |
| ただ                                                                 |
| し、函渠長が5m未満であって、かつ、堤内地盤高が本川の計画高水位より高 |
| い場合においては、内空幅・内空高とも0.3mまで小さくすることができる。 |
| また、2門以上の函渠端部の内空幅は、函渠中央部の内空幅と同一とする。  |
|                                                                      |
| 2.  排水機能が求められる場合の余裕高                                 |
|                                                                      |
| 流木等流下物が多い場合を除き、函渠の余裕高は、樋門が横               |
| 断する河川又は水路の計画高水位に次に掲げる値を加えた高さ以上とする。 |
|                                                                      |
| 　・計画高水流量が50m^3^/s未満の場合：0.3m                           |
|                                                                      |
| 　・計画高水流量が50m^3^/s以上の場合：0.6m                           |
|                                                                      |
| ただし、支川                                                         |
| の計画高水流量が20m^3^/s未満の場合、上記の値を流下断面の水深の1割以  |
| 上とすることができる。なお、柔支持基礎を採用する場合は、函渠が沈下し |
| た場合にも流下能力を確保するため、函渠の余裕高に残留沈下量を加える。 |
|                                                                      |
| ３）ゲートの門数                                                     |
|                                                                      |
| できる限りゲー                                                       |
| トの門数を少なくするよう設計することを基本とする。やむを得ず2門以上  |
| のゲートが必要となる場合には、それぞれの函渠の内空幅は5m以上を基本と |
| する。ただし、内空幅が内空高の2倍以上となるときは、この限りでない。  |
+----------------------------------------------------------------------+

＜推　奨＞

+----------------------------------------------------------------------+
| 函渠の内空断面積が流下断面積の1.3倍以内の場合には、函渠側壁の内側を  |
| 支川の計画高水位と堤防の交点の位置とすることを推奨する。こうした場合 |
| に、函渠の内空断面積が流下断面積の1.3倍以上の場合には1.3倍となるまで |
| 函渠の総幅員（内空幅と中央部の隔壁幅の総和）を縮小することができる。 |
|                                                                      |
| ![](media/image95.png){width="2.484866579177603in"                   |
| height="1.0694444444444444in"}                                       |
|                                                                      |
| 60. 樋門の断面説明図（流下断面積が1:1.3以内の場合）                  |
+----------------------------------------------------------------------+

1.  []{#_Toc47014755 .anchor}函渠長

＜考え方＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  函渠の長さは、計画堤防断面の川表、川裏の法尻までとなるように設定する必要がある。これは、樋門の機能を確保するように敷高や函渠の内空断面等を設定した結果、堤防断面を切り込まざるを得ない樋門の構造となる場合があるためである。このような場合でも、堤体強度の低下をできるだけ避けるために切り込みを必要最小限とする必要がある。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

  ----------------------------------------------------------------------------------
  函渠長は、計画堤防断面の川表、川裏の法尻までとなるよう設計することを基本とする。
  ----------------------------------------------------------------------------------

＜推　奨＞

+----------------------------------------------------------------------+
| 函渠長                                                               |
| は、堤防の土留めを目的とした胸壁の配置を考慮して決定する必要がある。 |
|                                                                      |
| 函渠頂版の天端から                                                   |
| 胸壁の天端までの高さは、胸壁が樋門の上の堤防の土留壁として機能するこ |
| とを考慮すると、0.5m程度とし、高くても1.5m以下とすることが望ましい。 |
|                                                                      |
| ![](media/image96.png){width="4.09826990376203in"                    |
| height="1.439306649168854in"}                                        |
|                                                                      |
| 61. 函渠長                                                           |
+----------------------------------------------------------------------+

1.  []{#_Toc47014756 .anchor}門柱の天端高

＜考え方＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  門柱は、主に引上げ式ゲートの開閉を行うために設け、ゲートの開閉が容易な構造とする必要がある。また、門柱の天端高は、ゲート全開時のゲート下端高が取水、排水、舟の通行に支障を及ぼさない高さを確保するとともに、ゲートの維持管理・更新のための戸溝からの取外し等に必要な高さを確保する必要がある。同様に、管理橋の桁下高もそれらに支障を及ぼさない高さとする必要がある。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------
  門柱の天端高は、ゲート全開時のゲート上端部にゲートの管理に必要な高さを加えた高さを確保し、管理橋の桁下高が計画堤防高以上となるよう設計することを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

+----------------------------------------------------------------------+
| ゲートの管                                                           |
| 理に必要な高さとしては、引上げ余裕高(0.5m程度）のほか滑車等の付属品  |
| の高さを考慮することが望ましい。柔構造樋門等で門柱部の沈下が予測され |
| る場合は、予測される沈下量を見込んで天端高を設定することが望ましい。 |
|                                                                      |
| ![](media/image97.png){width="4.277456255468066in"                   |
| height="2.5785608048993875in"}                                       |
|                                                                      |
| 62. 引上げ余裕高                                                     |
+----------------------------------------------------------------------+

1.  []{#_Toc47014757 .anchor}材質と構造

＜考え方＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  使用材料は、設置目的に応じて要求される強度、施工性、耐久性、環境適合性等の性能を満足するための品質を有し、その性状が明らかなものでなければならない。このため、JIS等の公的な品質規格に適合し、その適用範囲が明らかな用途に対して使用することが望ましい。公的な品質規格がない材料の場合には、材料特性が樋門に及ぼす影響を試験等によって確認するとともに、品質についてもJIS等の規格と同等であることを確認する必要がある。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

30. 使用材料

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------
  設置目的に応じて要求される強度、施工性、耐久性、環境適合性等の性能を満足するための品質を有し、その性状が明らかにされている材料を使用することを基本とする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

  --------------------------------------------------------------------------------------------------------------------------
  鉄筋コンクリート構造物（プレキャスト製品を除く）に用いるコンクリートの設計基準強度24N/mm^2^、鉄筋の材質SD345を推奨する。
  --------------------------------------------------------------------------------------------------------------------------

31. 主な構造

＜考え方＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  樋門を構成する主な構造としては、函体、遮水壁、門柱、胸壁、ゲートの操作台があり、これらは、鉄筋コンクリート構造又はこれに準ずる構造とし、必要な安全性を確保する必要がある。また、樋門の安全性を確保するため、函体、遮水壁、胸壁、翼壁、水叩き、遮水工は、部材の安全性の確保と継手部の水密性の確保によって、全体として必要な水密性を有する構造となるよう設計する必要がある。ここで、必要な水密性を有するとは、部材の損傷や劣化、継ぎの開き等により樋門周辺の堤防の土砂が吸い出されることのない状態を確保する意味であり、部材によっては多少の漏水が生じる状態は許容される。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜必　須＞

+----------------------------------------------------------------------+
| 函体、遮水壁、門柱、胸壁、ゲートの操作台                             |
| は、鉄筋コンクリート構造又はこれに準ずる構造とする。函体、遮水壁、胸 |
| 壁、翼壁、水叩き、遮水工は、部材の安全性と継手部の水密性の確保によっ |
| て、全体として必要な水密性を有する構造となるよう設計するものとする。 |
|                                                                      |
| ゲートは、鋼構造又はこれに準ずる構造とし、ゲートは確実に             |
| 開閉し、かつ、必要な水密性を有する構造となるよう設計するものとする。 |
|                                                                      |
| ゲートの開閉装置は、ゲ                                               |
| ートの開閉を確実に行うことができる構造となるよう設計するものとする。 |
+----------------------------------------------------------------------+

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------
  函渠、翼壁、水叩きは必要に応じ継手等によって屈とう性を有する構造とし、護床工は地盤の洗堀や変形に追随する構造となるよう設計することを標準とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------

＜例　示＞

+----------------------------------------------------------------------+
| 鉄筋コン                                                             |
| クリート構造に準ずる構造には、鋼管及びダクタイル鋳鉄管の事例がある。 |
| 新しい材料として高耐圧ポリエチレン管、FRP管等の採用が考えられるが、  |
| 構造的に解決すべき課題もあるため、今後のさらなる調査研究が望まれる。 |
|                                                                      |
| 鋼構造に準ずる構造には、ステンレス製ゲート、アルミ製ゲート等がある。 |
+----------------------------------------------------------------------+

32. 設計用定数

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------
  設計に用いる各種定数は、適切な安全性が確保できるよう、使用する材料の力学特性を考慮し、必要に応じて調査・試験を実施したうえで、設定することを基本する。
  --------------------------------------------------------------------------------------------------------------------------------------------------------

4.  ヤング率

＜標　準＞

  --------------------------------------------------------------------------------------------------
  設計に用いるヤング率は、使用する材料の特性や品質を考慮したうえで適切に設定することを基本とする。
  --------------------------------------------------------------------------------------------------

＜推　奨＞

+----------------------------------------------------------------------+
| ヤング率として、以下の値を用いることが望ましい。                     |
|                                                                      |
| 1\) ヤング係数                                                       |
|                                                                      |
| ・コンクリートのヤング係数は、2.5×10^4^ N/mm^2^                      |
|                                                                      |
| ・鋼材のヤング係数は、2.0×10^5^ N/mm^2^                              |
|                                                                      |
| 2\) ヤング係数比                                                     |
|                                                                      |
| ・許容応力度による設計を                                             |
| 行う場合の鉄筋コンクリート部材の応力度の計算に用いるヤング係数比は15 |
+----------------------------------------------------------------------+

5.  地盤に係る定数

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  ボーリング調査、サウンディング調査、現位置試験、室内土質試験を組合せた地盤調査（既往調査含む）や周辺の工事履歴、試験施工等に基づき総合的に判断し、施工条件等も十分に考慮したうえで、地盤に係る定数を設定することを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

+----------------------------------------------------------------------+
| 1\) 基礎底面と地盤との間の摩擦係数と付着力                           |
|                                                                      |
| 基礎底面                                                             |
| と地盤との間の摩擦係数と付着力として、以下の値を用いることができる。 |
|                                                                      |
| 38. 摩擦角と付着力                                                   |
|                                                                      |
|                                                                      |
|  条件               摩擦角φ*~B~*（摩擦係数tanφ*~B~*）   付着力C*~B~* |
|   -                                                                  |
| ----------------- ----------------------------------- -------------- |
|   土とコンクリート   φ*~B~*=2/3φ                         C*~B~*=0    |
|   岩とコンクリート   tanφ*~B~=0.6*                       C*~B~=0*    |
|   土と土又は岩と岩   φ*~B~=φ*                            C*~B~=*C    |
|                                                                      |
| た                                                                   |
| だし、φ：支持地盤のせん断抵抗角（度）、C:支持地盤の粘着力（kN/m^2^） |
|                                                                      |
| 2\) 地盤の許容鉛直支持力                                             |
|                                                                      |
| 地                                                                   |
| 盤の許容鉛直支持力は、荷重の偏心傾斜及び基礎の沈下量を考慮した地盤の |
| 極限支持力に対して、表8-2に示す安全率を確保していることが望ましい。  |
|                                                                      |
| 39. 安全率                                                           |
|                                                                      |
|   常　時   地震時   施工時                                           |
|   -------- -------- --------                                         |
|   3        2        2                                                |
|                                                                      |
| 荷重の偏心傾斜及び基礎の                                             |
| 沈下量を考慮した地盤の極限支持力は、次式により求めることができる。平 |
| 板載荷試験により求める場合には、載荷試験の結果により確認した地盤の粘 |
| 着力C、せん断抵抗角φを用いて以下の式に従って算出することが望ましい。 |
|                                                                      |
| ![](media/image98.png){width="3.854012467191601in"                   |
| height="4.231213910761155in"}                                        |
+----------------------------------------------------------------------+

33. 鉄筋コンクリート部材の最小寸法

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------
  鉄筋コンクリートの部材の最小寸法は、耐久性、強度を有するために必要なかぶり及び施工性に配慮し設定することを基本とする。
  ------------------------------------------------------------------------------------------------------------------------

＜例　示＞

  ------------------------------------------------------------------------------------------------------------
  鉄筋コンクリートの部材の最小寸法は、施工性を重視し主鉄筋を内側に配置するため、0.4mが用いられる場合が多い。
  ------------------------------------------------------------------------------------------------------------

1.  []{#_Toc54772908 .anchor}樋門周辺の堤防

＜考え方＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  樋門周辺の堤防には、樋門の施工による埋戻し部分も含まれる。その影響範囲は、対象とする事象によっても異なるが、抜け上がりまで含めれば、堤防縦断方向に堤防高さの2〜3倍以上に及ぶ。「8.5 安全性能の照査等**」**に当たっては、樋門周辺の堤防が一連区間の中の弱点でないことが前提となっており、必要に応じて「第2節 堤防**」**に準じて安全性の照査を行い、前後区間と比較して相対的に安全性が低下しないように強化対策を行う必要がある。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜必　須＞

  ------------------------------------------------------------------------------------
  樋門周辺の堤防が一連区間と比較して相対的に弱点とならないように設計するものとする。
  ------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 樋門周辺の堤防に用いる土質材料は、堤防に適したものを選定し、十分に   |
| 締固めを行うものとする。また、樋門周辺の堤防の断面形状は、樋門本体に |
| よる止むを得ない切り込みを除き、隣接する堤防の大きさ（堤防高、天端幅 |
| 、堤体幅）及び計画堤防の大きさを上回る大きさとすることを基本とする。 |
|                                                                      |
| 必要に応じて「**第2節                                                |
| 堤防」**に準じて堤防の安全性照査を行い、一連区間                     |
| と比較して相対的に安全性が低下しないよう必要に応じて強化対策を行う。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  （財）国土技術研究センター：[河川土工マニュアル](http://www.jice.or.jp/tech/material/detail/11)，平成21年4月．

    1.  []{#_Toc47014759 .anchor}安全性能の照査等

        1.  []{#_Toc47014760 .anchor}設計の対象とする状況と作用

＜考え方＞

+----------------------------------------------------------------------+
| 樋門の設計に当たっては、常時、洪水時、地                             |
| 震時、高潮時及び風浪時の安全性能を確保することが求められる。全ての樋 |
| 門について、常時、洪水時及び地震時、さらに高潮堤に設けられる樋門は高 |
| 潮時、湖岸堤等に設けられる樋門は風浪時についても照査する必要がある。 |
|                                                                      |
| 照査に当たっては、広域地                                             |
| 盤沈下量、基礎地盤の特性、維持管理に必要となる前提条件を設定する必要 |
| がある。なお、前提条件は、土質地質調査等に基づき設定する必要がある。 |
|                                                                      |
| 設計の対象とする作用につ                                             |
| いては、本体やゲート等の自重、計画高水位（高潮区間にあっては、計画高 |
| 潮位）以下の水圧、地震動として河川構造物の供用期間中に発生する確率が |
| 高い地震動及び対象地点において現在から将来にわたって考えられる最大級 |
| の強さを持つ地震動、土圧、風の影響等の他、地震時には必要に応じて津波 |
| による波圧、高潮時には波浪並びに風浪時には風浪による影響が考えられ、 |
| 設計の対象とする樋門の状況に応じて適切に組合せて設定する必要がある。 |
|                                                                      |
| なお、必要に応じて施工時についても安全性能の照査を行う。             |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 安全性能の照査に当たっては、設                                       |
| 計の対象とする状況と作用を次の表のように設定し、これを踏まえて照査事 |
| 項を設定することを基本とする。常時、洪水時及び地震時については全ての |
| 樋門において設定し、これに加えて、高潮区間の樋門の場合には高潮時、湖 |
| 岸堤等に設ける樋門の場合には風浪時について設定することを基本とする。 |
|                                                                      |
| 取水や舟の通行等治水以外の設置目的を有する場合                       |
| には当該設置目的に応じた常時の作用を適切に設定することを基本とする。 |
|                                                                      |
| +------------+--------------------------------------------------+    |
| | 樋門の状況 | 作用                                             |    |
| +============+==================================================+    |
| | 常時       | 自重（死荷重）、活荷重、地盤                     |    |
| |            | 変位の影響、土圧、水圧、揚圧力、風荷重、温度変化 |    |
| |            | の影響、コンクリートのクリープ及び乾燥収縮の影響 |    |
| |            | 、負の周辺摩擦力の影響、雪荷重、プレストレス力等 |    |
| +------------+--------------------------------------------------+    |
| | 洪水時     | 自重（死荷重）、活荷重、地盤変位                 |    |
| |            | の影響、土圧、水圧^※^、揚圧力、風荷重、温度変化  |    |
| |            | の影響、コンクリートのクリープ及び乾燥収縮の影響 |    |
| |            | 、負の周辺摩擦力の影響、雪荷重、プレストレス力等 |    |
| |            |                                                  |    |
| |            | ※計画高水位、高潮区間にあっては計画高潮位        |    |
| +------------+--------------------------------------------------+    |
| | 高潮時     | 高潮位における波浪による波圧                     |    |
| +------------+--------------------------------------------------+    |
| | 風浪時     | 風浪による波圧                                   |    |
| +------------+--------------------------------------------------+    |
| | 地震時     | 自重（死荷重）、地震動、活荷重、地盤変位の影     |    |
| |            | 響、水圧、揚圧力、温度変化の影響、負の周辺摩擦力 |    |
| |            | の影響、地震の影響^※^、雪荷重、プレストレス力等  |    |
| |            |                                                  |    |
| |            | ※地震時土圧、地震時動水圧、液状化の影響          |    |
| +------------+--------------------------------------------------+    |
| | その他     | 津波による波圧                                   |    |
| |            |                                                  |    |
| |            | 副振動、セイシュによる影響                       |    |
| |            |                                                  |    |
| |            | 施工時荷重                                       |    |
| |            |                                                  |    |
| |            | 流木の衝突                                       |    |
| |            |                                                  |    |
| |            | 舟の衝突                                         |    |
| +------------+--------------------------------------------------+    |
|                                                                      |
| 高規格堤防設置                                                       |
| 区間及び当該区間の背水区間の樋門の照査に当たっては、計画高水位での静 |
| 水圧を高規格堤防設計水位での静水圧に置き換えて行うことを基本とする。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  国土交通省：[ダム・堰施設技術基準（案）](https://www.mlit.go.jp/common/001126025.pdf)，平成28年3月．

```{=html}
<!-- -->
```
38. 国土交通省水管理・国土保全局：[河川構造物の耐震性能照査指針・解説―Ⅰ．共通編―](https://www.mlit.go.jp/river/shishin_guideline/bousai/wf_environment/structure/index3.html)，平成24年2月．

39. 国土交通省水管理・国土保全局：[河川構造物の耐震性能照査指針・解説―Ⅳ．水門・樋門及び堰編―](https://www.mlit.go.jp/river/shishin_guideline/bousai/wf_environment/structure/index3.html)，令和2年2月（令和2年6月一部追記）.

40. 国土交通省水管理・国土保全局河川計画課長、治水課長：[河川津波対策について，平成23
    年 9 月 2
    日](https://www.mlit.go.jp/river/shishin_guideline/kasen/pdf/kasen_tsunami_taisaku_h230902.pdf)，国水計第
    20 号，国水治第 35 号．

＜推　奨＞

+----------------------------------------------------------------------+
| 樋門の設計に当たっては、次の作用を考慮するのが望ましい。             |
|                                                                      |
| １）自重（死荷重）                                                   |
|                                                                      |
| 自重（死荷重）は、適切な単位体積重量を用いて算出する。               |
|                                                                      |
| 材料の単位体積重量は、表8-3、表8-4の値を参考に定めるものとする。     |
|                                                                      |
| 土の単位体積重量は、一般的な値を示したものであ                       |
| り、土質試験データがある場合は、その値を用いて設計することが望ましい |
| 。コンクリートについても、できるだけ試験データによることが望ましい。 |
|                                                                      |
| 40. 土の湿潤単位体積重量(kN/m^3^)                                    |
|                                                                      |
|   地盤       土　質       緩いもの   密なもの                        |
|   ---------- ------------ ---------- ----------                      |
|   自然地盤   砂及び砂礫   18         20                              |
|              砂質土       17         19                              |
|              粘性土       14         18                              |
|   盛土       砂及び砂礫   20                                         |
|              砂質土       19                                         |
|              粘性土       18                                         |
|                                                                      |
| 表に示す土の湿潤単位体積重量に対して                                 |
| 飽和単位体積重量は1kN/m^3^程度重く、地下水以下の飽和重量は水の重量1  |
| 0kN/m^3^（9.8kN/m^3^の丸め）を差し引くため、地下水位以下にある土の湿 |
| 潤単位体積重量は、それぞれの表中の値から9を差し引いた値としてよい。  |
|                                                                      |
| 地下水位は施工後における水位の平均値を考える。                       |
|                                                                      |
| 41. 材料の単位体積重量(kN/m^3^)                                      |
|                                                                      |
| +----------------------------------------------+--------------+      |
| | 材料                                         | 単位体積重量 |      |
| +==============================================+==============+      |
| | 鋼・鋳鋼・鍛鋼                               | 77.0         |      |
| +----------------------------------------------+--------------+      |
| | 鋳鉄                                         | 71.0         |      |
| +----------------------------------------------+--------------+      |
| | アルミニウム                                 | 27.5         |      |
| +----------------------------------------------+--------------+      |
| | 鉄筋コンクリート                             | 24.5         |      |
| +----------------------------------------------+--------------+      |
| | プレストレスを導入するコンクリート           | 24.5         |      |
| |                                              |              |      |
| | （設計基準強度60N/mm^2^以下）                |              |      |
| +----------------------------------------------+--------------+      |
| | プレストレスを導入するコンクリート           | 25.0         |      |
| |                                              |              |      |
| | （設計基準強度60N/mm^2^を超え80N/mm^2^まで） |              |      |
| +----------------------------------------------+--------------+      |
| | コンクリート                                 | 23.0         |      |
| +----------------------------------------------+--------------+      |
| | セメントモルタル                             | 21.0         |      |
| +----------------------------------------------+--------------+      |
| | 木材                                         | 8.0          |      |
| +----------------------------------------------+--------------+      |
| | 歴青材（防水用）                             | 11.0         |      |
| +----------------------------------------------+--------------+      |
| | アスファルト舗装                             | 22.5         |      |
| +----------------------------------------------+--------------+      |
|                                                                      |
| ２）活荷重                                                           |
|                                                                      |
| 活荷重は、自動車荷重及び群衆荷重とする。                             |
|                                                                      |
| 自動車荷                                                             |
| 重は必要に応じ、大型の自動車の交通状況に応じてTL-25荷重を考慮する。  |
|                                                                      |
| 群衆荷重は、管理橋及び操作台等に3.5kN/m^2^の等分布荷重を考慮する。   |
|                                                                      |
| ３）地盤変位の影響                                                   |
|                                                                      |
| 地盤変位の影響とは、地盤の変位が樋門本体に与え                       |
| る影響のことであり、設計上は解析対象物の軸線上の変位分布として扱う。 |
|                                                                      |
| 1．地盤の沈下による変位(沈下)                                        |
|                                                                      |
| > 地盤の沈下による                                                   |
| 変位(沈下)としては、樋門の施工後に生じる地盤の残留沈下量分布とする。 |
|                                                                      |
| 2．地盤の水平変位による変位(側方変位)                                |
|                                                                      |
| > 地盤の水平変位による変位(側方                                      |
| 変位)としては、樋門の施工後に生じる基礎地盤の側方変位量分布とする。  |
|                                                                      |
| ４）土圧                                                             |
|                                                                      |
| 1.  胸壁・翼壁に作用する土圧                                         |
|                                                                      |
| > 胸壁･翼壁に作用する土圧は、原則として表8-5の区分に従って適用する。 |
|                                                                      |
| 42. 土圧の区分                                                       |
|                                                                      |
|   種　　別   常　時         地震時                                   |
|   ---------- -------------- ---------------- ----------------        |
|   胸壁       静止土圧       地震時主働土圧                           |
|   翼壁       Ｕ形タイプ     静止土圧         地震時静止土圧          |
|              逆Ｔ形タイプ   主働土圧         地震時主働土圧          |
|                                                                      |
| a)　静止土圧                                                         |
|                                                                      |
| > 胸壁・翼壁に作用する静止土圧は、次式による。                       |
| >                                                                    |
| > *P~hd~*＝*K~0~*(*γ・h*＋*q~0~*)                                    |
| >                                                                    |
| > ここに                                                             |
| >                                                                    |
| > *P~hd\ ~*：任意の深さの水平土圧強度(kN/ｍ^2^ )                     |
| >                                                                    |
| > *K~0\ ~*：静止土庄係数(通常はK~0~＝0.5と考えてよい)                |
| >                                                                    |
| > *γ* ：土の単位体積重量(kN/ｍ^3^ )                                  |
| >                                                                    |
| > *h* ：任意の深さ(ｍ)                                               |
| >                                                                    |
| > *q~0\ ~*：上載荷重(kN/ｍ^2^ )                                      |
|                                                                      |
| b)　主働土圧                                                         |
|                                                                      |
| > 主働土圧は、次式による。                                           |
| >                                                                    |
| > *P~a~*＝*K~A~*(*γ*・*h*＋*q~0~*)                                   |
|                                                                      |
| $$                                                                   |
| K_{A} = \frac{\cos^{2}\left( \varnothing - \theta \right)}{\cos^{2}{ |
| \theta \bullet \cos{\left( \theta + \delta \right)\left\lbrack 1 + \ |
| sqrt{\frac{\sin{\left( \varnothing + \delta \right) \bullet \sin\lef |
| t( \varnothing - \alpha \right)}}{\cos\left( \theta + \delta \right) |
|  \bullet \cos\left( \theta - \alpha \right)}} \right\rbrack^{2}}}}$$ |
|                                                                      |
| $$\cot\left( \xi A - \alpha \ri                                      |
| ght) = - \tan\left( \varnothing + \delta + \theta - \alpha \right)$$ |
|                                                                      |
| $$+ \sec\left( \varnothing + \delta + \                              |
| theta - \alpha \right)\sqrt{\frac{\cos\left( \theta + \delta \right) |
|  \bullet \sin\left( \varnothing + \delta \right)}{\cos\left( \theta  |
| - \alpha \right) \bullet \sin\left( \varnothing - \alpha \right)}}$$ |
|                                                                      |
| > ここに                                                             |
| >                                                                    |
| > *P~a\ ~*：任意の深さの主働土圧強度(kN/ｍ^2^)                       |
| >                                                                    |
| > *K~A\ ~*：主働土圧係数                                             |
| >                                                                    |
| > *ξ~A\ ~*：主働崩壊角(度)                                           |
| >                                                                    |
| > *γ* ：土の単位体積重量(kN/ｍ^3^)                                   |
| >                                                                    |
| > *h* ：任意の深さ(ｍ)                                               |
| >                                                                    |
| > *q~0\ ~*：上載荷量(kN/ｍ^2^)                                       |
| >                                                                    |
| > *α* ：地表面と水平面のなす角(度)                                   |
| >                                                                    |
| > *θ* ：壁背面と鉛直面のなす角(度)                                   |
| >                                                                    |
| > *φ* ：土の内部摩擦角(度)                                           |
| >                                                                    |
| > *δ* ：土圧作用面の種別に応じた壁面摩擦角(度)                       |
| >                                                                    |
| > 土と土の場台：δ＝φ                                                 |
| >                                                                    |
| > 土とコンクリートの場合：δ＝φ/3                                     |
| >                                                                    |
| > ただし、φ－α＜Oのときはsin(φ－α)＝0とする。                        |
| >                                                                    |
| > 上載荷量*q0*は必要に応じて考慮する。                               |
| >                                                                    |
| > ここで用いる角度は反時計回りを正とする。                           |
|                                                                      |
| c)　地震時主働土圧                                                   |
|                                                                      |
| > 胸壁・翼壁に作用する地震時主働土圧は、次式による。                 |
| >                                                                    |
| > ![](media/image99.emf){width="1.507638888888889in"                 |
| > height="0.26875in"}                                                |
| >                                                                    |
| > ![](media/image100.emf){width="4.597222222222222in"                |
| > height="0.8208333333333333in"}                                     |
| >                                                                    |
| > ![](media/image101.emf){width="5.089583333333334in"                |
| > height="0.5076388888888889in"}                                     |
| >                                                                    |
| > ここに                                                             |
| >                                                                    |
| > ![](media/image102.jpeg){width="4.541666666666667in"               |
| > height="3.2291                                                     |
| 666666666665in"}![](media/image103.jpeg){width="4.541666666666667in" |
| > height="1.6770833333333333in"}                                     |
| >                                                                    |
| > ただし、のときはとする。また、は地震時                             |
| に確実に作用するもののみとし、活荷重は原則として含まないものとする。 |
| >                                                                    |
| > ここで用いる角度は反時計回りを正とする。                           |
| >                                                                    |
| > ![](media/image107.png){width="3.671527777777778in"                |
| > height="2.238888888888889in"}                                      |
|                                                                      |
| 63. 地震時主働土圧                                                   |
|                                                                      |
| d)　地震時静止土圧                                                   |
|                                                                      |
| > 翼壁・翼壁に作用する地震時静止土圧は、次式による。                 |
| >                                                                    |
| > ここに                                                             |
| >                                                                    |
| > ![](media/image109.png){width="5.319385389326334in"                |
| > height="1.1394466316710412in"}                                     |
|                                                                      |
| 2.  函体に作用する土圧                                               |
|                                                                      |
| a)　鉛直土圧                                                         |
|                                                                      |
| > 函体上面に作用する鉛直土圧は、次式により算定する。                 |
| >                                                                    |
| > *Pvd＝α・γ・h*                                                     |
| >                                                                    |
| > ここに                                                             |
| >                                                                    |
| > *P~vd\ ~*：鉛直土圧強度(kN/ｍ^2^)                                  |
| >                                                                    |
| > *α* ：鉛直土圧係数（*α*=1.0と考えてよい）                          |
| >                                                                    |
| > *γ* ：土かぶり土等の単位体積重量(kN/ｍ^3^)                         |
| >                                                                    |
| > *h* ：函体の土かぶり厚さ(ｍ)                                       |
|                                                                      |
| b)　水平土圧                                                         |
|                                                                      |
| 1.  剛性函体                                                         |
|                                                                      |
| > 剛性函体の側壁に作用する静止土圧は、次式により算定する。           |
| >                                                                    |
| > *P~hd~*＝*K~0~*・*γ*・*h*                                          |
| >                                                                    |
| > ここに                                                             |
| >                                                                    |
| > *P~hd\ ~*：任意の深さの水平土圧強度(kN/ｍ^2^)                      |
| >                                                                    |
| > *K*~0~ ：静止土庄係数(通常は*K*~0~＝0.5と考えてよい)               |
| >                                                                    |
| > *γ* ：土の単位体積重量(kN/ｍ^3^)                                   |
| >                                                                    |
| > *h* ：任意の深さ(ｍ)                                               |
| >                                                                    |
| > 活荷重による水平土圧は、土かぶり                                   |
| 厚さに関係なく函体両側面に上載荷重を戴荷させて、次式により算定する。 |
| >                                                                    |
| > *P~hde~＝K~0~・q~0~*                                               |
| >                                                                    |
| > ここに                                                             |
| >                                                                    |
| > *P~hde\ ~*：上載荷重による水平土圧強度(kN/ｍ^2^)                   |
| >                                                                    |
| > *K*~0~ ：静止土圧係数(通常は*K*~0~＝0.5と考えてよい)               |
| >                                                                    |
| > *q*~0~ ：上戴荷重*q*~0~＝10 kN/ｍ^2^                               |
|                                                                      |
| 2.  たわみ性函体                                                     |
|                                                                      |
| > たわみ性函体の設計は、剛性特性に応じた各々の設計法による。         |
|                                                                      |
| ５）水圧                                                             |
|                                                                      |
| 1.  静水圧                                                           |
|                                                                      |
| > 樋門の上下流水位について、樋門の操作上考えられる組合せを検討する。 |
| >                                                                    |
| > ただし、地震時慣                                                   |
| 性力及び地震時動水圧と計画高水位時における水圧は、同時に作用しない。 |
| >                                                                    |
| > ゲート引上げ時には、流水から受ける力を必要に応じて考慮する。       |
|                                                                      |
| 2.  地震時動水圧                                                     |
|                                                                      |
| > 地震時動水圧は、ウエスターガードの近似式により計算する。           |
|                                                                      |
| 3.  胸壁・翼壁に作用する残留水圧                                     |
|                                                                      |
| > 胸壁・翼壁の前面の水位と背面の水位の間に水                         |
| 位差が生じる場合は、この水位差に伴う残留水圧を考慮する（下図参照）。 |
| >                                                                    |
| > 感潮区間の場合は、前面潮位差の2/3の水圧差を対象とする。            |
|                                                                      |
| ![](media/image110.png){width="5.19375in"                            |
| height="3.1041666666666665in"}                                       |
|                                                                      |
| 64. 残留水位の設定方法（常時）                                       |
|                                                                      |
| ![](media/image111.png){width="5.343055555555556in"                  |
| height="1.9256944444444444in"}                                       |
|                                                                      |
| 65. 感潮区間の残留水位                                               |
|                                                                      |
| ６）揚圧力                                                           |
|                                                                      |
| 揚圧力は、樋門                                                       |
| の操作上考えられる樋門の上下流の水位差が最大となる水位により求める。 |
|                                                                      |
| ７）風荷重                                                           |
|                                                                      |
| 風荷重は3kN/㎡とする。                                               |
|                                                                      |
| ８）温度変化の影響                                                   |
|                                                                      |
| 温度荷重は、温度変化を±15                                            |
| ℃とし、膨張係数を鋼で0.000012、コンクリートで0.00001として計算する。 |
|                                                                      |
| ９）コンクリートのクリープ及び乾燥収縮の影響                         |
|                                                                      |
| 1.  コンクリートのクリープひずみ                                     |
|                                                                      |
| > コンクリートのクリープひずみは次式により算定することができる。     |
| >                                                                    |
| > ここに、                                                           |
|                                                                      |
|   -- ---- -------------------------------------                      |
|      ：   コンクリートのクリープひずみ                               |
|      ：   持続荷重による応力度（N/mm^2^）                            |
|      ：   コンクリートのヤング係数（N/mm^2^）                        |
|      ：   コンクリートのクリープ係数                                 |
|   -- ---- -------------------------------------                      |
|                                                                      |
| > コンクリートのクリープひずみについては、作用する持続荷             |
| 重による応力度がコンクリートの圧縮強度の40％程度以下の場合、上式が成 |
| 立すると考えてよい。一般には、コンクリートの圧縮強度の40％を超える持 |
| 続荷重による応力度が作用することはなく、上式が用いられるが、40％を超 |
| える場合には別途試験などによりクリープひずみを定めなければならない。 |
|                                                                      |
| 2.  コンクリートのクリープ係数                                       |
|                                                                      |
| > プレストレスの損失量及び不静                                       |
| 定力を算出する場合のコンクリートのクリープ係数は、表8-6の値とする。  |
|                                                                      |
| 43. コンクリートのクリープ係数                                       |
|                                                                      |
| +---------------+---------------+-----+-----+-----+-----+-----+      |
| | 持続荷重を    | 4～7          | 14  | 28  | 90  | 365 |     |      |
| | 載荷する時の  |               |     |     |     |     |     |      |
| | コンクリート  |               |     |     |     |     |     |      |
| | の材令（日）  |               |     |     |     |     |     |      |
| +---------------+---------------+-----+-----+-----+-----+-----+      |
| | クリープ      | 早強          | 2.6 | 2.3 | 2.0 | 1.7 | 1.2 |      |
| |               | ポルトランド  |     |     |     |     |     |      |
| | 係数          | セメント使用  |     |     |     |     |     |      |
| +---------------+---------------+-----+-----+-----+-----+-----+      |
| |               | 普通          | 2.8 | 2.5 | 2.2 | 1.9 | 1.4 |      |
| |               | ポルトランド  |     |     |     |     |     |      |
| |               | セメント使用  |     |     |     |     |     |      |
| +---------------+---------------+-----+-----+-----+-----+-----+      |
|                                                                      |
| > コンクリートのひずみは、                                           |
| 作用する持続荷重を取り除くと回復するクリープひずみと回復しないクリー |
| プひずみの和であると考えられる。一般に、プレストレスの損失量を算出す |
| る場合は、クリープひずみをこれら2成分に分けて算出しても、或いは分け  |
| ずに算出しても結果的に大差ないので、表8-6に示すクリープ係数をそのま  |
| ま用いてよい。なお、持続荷重を載荷した時のコンクリートの材令が表8-6  |
| に示す値の間にある場合のクリープ係数は直線補間による値を用いてよい。 |
|                                                                      |
| 3.  コンクリートの乾燥収縮度                                         |
|                                                                      |
| > プレストレスの                                                     |
| 損失量を算出する場合のコンクリートの乾燥収縮度は、表8-7の値とする。  |
|                                                                      |
| 44. コンクリートの乾燥収縮度                                         |
|                                                                      |
| （普通及び早強ポルトランドセメント使用の場合）                       |
|                                                                      |
|   --------------------------------------------                       |
| -------- ----------- ----------- ----------- ----------- ----------- |
|   プレストレスを導入する時のコンクリー                               |
| トの材令（日）   3以内       4～7        28          90          365 |
|   乾　燥　収　縮　度                                                 |
|            25×10^-5^   20×10^-5^   18×10^-5^   16×10^-5^   12×10^-5^ |
|   --------------------------------------------                       |
| -------- ----------- ----------- ----------- ----------- ----------- |
|                                                                      |
| > コンクリートそのものの乾燥収縮度は表                               |
| 8-7に示す値より一般に大きいが、部材に配置される鋼材の影響などを考慮  |
| して、プレストレスの損失量を算定する場合は表8-7に示す値を用いてよい  |
| こととした。なお、プレストレスを導入する時のコンクリートの材令が表8  |
| -7に示す値の間にある場合の乾燥収縮度は直線補間による値を用いてよい。 |
|                                                                      |
| 4.  ②項又は③項によりがたい場合                                       |
|                                                                      |
| > ②項                                                                |
| 又は③項によりがたい場合は、部材周辺の湿度、部材断面の形状寸法、荷重  |
| が作用する時のコンクリートの材令などを考慮して別途定めるものとする。 |
| >                                                                    |
| > 特にコンクリート材令の                                             |
| 若い時期にプレストレッシングを行う場合などでは、上記の諸要因を考慮し |
| て試験により別途定めるか、或いは、適切な方法によって推定してもよい。 |
|                                                                      |
| １０）負の周辺摩擦力の影響                                           |
|                                                                      |
| 軟弱地盤                                                             |
| の層厚が厚い等で負の周辺摩擦力の影響が大きいと予想される場合には、遮 |
| 水矢板等から樋門本体へ伝達する負の周辺摩擦力の影響について考慮する。 |
|                                                                      |
| １１）雪荷重                                                         |
|                                                                      |
| 雪荷重は、雪の単位堆                                                 |
| 積重量と積雪深の積として求める。一般に多雪地方においては、雪荷重3.5  |
| kN/m^3^を見込めばよい。積雪深は、既往の積雪記録、構造物上で          |
| の積雪状態などを考慮して設定する。積雪のない地方では考慮する必要はな |
| い。ただし、積雪が少ないために積雪深を決定できない場合は、雪荷重を1  |
| kN/㎡としてよい。                                                    |
|                                                                      |
| １２）プレストレス力                                                 |
|                                                                      |
| プレス                                                               |
| トレス力は、プレストレスを与えた直後（プレストレッシング直後）のプレ |
| ストレス力とその後に生じるコンクリートのクリープ、乾燥収縮及び緊張材 |
| のリラクセーションが終わったときの有効プレストレスについて考慮する。 |
|                                                                      |
| 1.  プレストレッシング直後のプレストレス力                           |
|                                                                      |
| > ポ                                                                 |
| ストテンション方式のプレストレッシング直後のプレストレス力は、緊張材 |
| の緊張端に与えた緊張力に以下に示す影響による損失を考慮して算出する。 |
|                                                                      |
| a)　コンクリートと継手材の弾性変形                                   |
|                                                                      |
| b)　緊張材とシースの摩擦                                             |
|                                                                      |
| c)　函体と均しコンクリートの摩擦                                     |
|                                                                      |
| d)　緊張材を定着する際のセット                                       |
|                                                                      |
| 2.  有効プレストレス力                                               |
|                                                                      |
| > 有効プレストレス力は、次に示すコンクリートのクリープ及び乾燥収     |
| 縮と緊張材の見かけのリラクセーションによるプレストレス力の損失量をプ |
| レストレッシング直後のプレストレス力より減じることによって算出する。 |
|                                                                      |
| a)　コンクリートのクリープ                                           |
|                                                                      |
| b)　コンクリートの乾燥収縮                                           |
|                                                                      |
| c)　緊張材のリラクセーション                                         |
|                                                                      |
| １３）地震動                                                         |
|                                                                      |
| 地震動は、構造物の重量に河川構造物の耐震性能照査指針                 |
| 共通編に規定する水平                                                 |
| 震度を乗じた水平力とし、これを水流方向及び水流直角方向に作用させる。 |
|                                                                      |
| １４）その他荷重                                                     |
|                                                                      |
| 堤防及び樋門の安全を図るうえで以下の必要な荷重を考慮する。           |
|                                                                      |
| 1.  波圧                                                             |
|                                                                      |
| > 以下の波圧を考慮する。                                             |
|                                                                      |
| a\) 波浪及び風浪                                                     |
|                                                                      |
| > 高潮区間や湖岸堤等で必要に応じて考慮する。                         |
| >                                                                    |
| > 波浪高の推定に当たっては、「調査編第21章 第5節及び本編第7章        |
| > 第2節」を参照する。                                                |
|                                                                      |
| b\) 津波                                                             |
|                                                                      |
| > 津波遡上区間で必要に応じて考慮する。                               |
|                                                                      |
| 2.  その他                                                           |
|                                                                      |
| > ・副振動、セイシュによる影響                                       |
| >                                                                    |
| > ・施工時荷重                                                       |
| >                                                                    |
| > ・流木の衝突                                                       |
| >                                                                    |
| > ・舟の衝突                                                         |
+----------------------------------------------------------------------+

＜関連通知等＞

土木構造物の許容応力度は、道路橋示方書及び土木構造物設計マニュアル（案）に係わる設計・施工の手引き（案）【樋門編】の規定を基本として定めたものである。ゲート等の機械設備に関しては、ダム・堰施設技術基準（案）による。

1.  （公社）日本道路協会：道路橋示方書・同解説 Ⅰ．共通編，平成 24 年 3
    月.

    （最新版）（公社）日本道路協会：道路橋示方書・同解説Ⅰ．共通編，平成29年11月.

```{=html}
<!-- -->
```
41. 国土交通省：[土木構造物設計マニュアル（案）樋門編](http://www.nilim.go.jp/lab/pbg/theme/theme2/sekkei/himon/himon-m.pdf)，平成13年2月．

    （最新版）土木構造物設計マニュアル（案）樋門編，平成 13 年 12
    月,国土交通省．

42. 国土交通省：[土木構造物設計マニュアル（案）に係わる設計・施工の手引き（案）【樋門編】](http://www.nilim.go.jp/lab/pbg/theme/theme2/sekkei/himon/index.html)，平成13年12月．

43. （財）国土技術研究センター：[柔構造樋門設計の手引き](http://www.jice.or.jp/tech/material/detail/3)，平成10年11月．

44. （公社）日本道路協会：道路土工，擁壁工指針，平成24年版．

45. （公社）日本道路協会：道路土工，カルバート工指針，平成21年版．

46. 国土交通省：[ダム・堰施設技術基準（案）](https://www.mlit.go.jp/common/001126025.pdf)，平成28年3月．

47. 国土交通省：河川砂防技術基準調査編，平成26年4月版，第21章海岸調査
    第5節 波浪調査．

48. 建設省河川局：河川砂防技術基準（案）設計編，平成 9 年 5 月版，第 7
    章 海岸保全施設の設計 第 2 節 設計基礎条件．

    1.  []{#_Toc54772911 .anchor}安全性能の照査

＜考え方＞

+----------------------------------------------------------------------+
| 樋門における安全性能の照査は、「8.5.1                                |
| 設計の対象                                                           |
| とする状況と作用**」**に示す状況と作用毎に、照査の条件として適切な外 |
| 水位及び内水位の組合せを設定し、安全性能について照査する必要がある。 |
|                                                                      |
| また、樋門における安全性能                                           |
| の照査は、構造や材料の特性に応じた設計手法を適用してモデル化を行い、 |
| 最も不利な断面力が生じる作用に対して、安全性能が確保できるようにする |
| 。なお、「最も不利な断面力が生じる作用」とは、考慮すべき荷重の組合せ |
| のうち、発生応力等が構造物に対して最も不利に働く荷重の組合せをいう。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 樋門は、「8.5.1                                                      |
| 設計の対象とする状況と作用**」**に                                   |
| 対し、以下の事項について安全性能を設定して照査することを基本とする。 |
|                                                                      |
| １）常時の安全性能                                                   |
|                                                                      |
| ２）洪水時の安全性能                                                 |
|                                                                      |
| ３）耐震性能                                                         |
|                                                                      |
| ４）風浪等に対する安全性能                                           |
|                                                                      |
| 安全性能の照査に当                                                   |
| たっては、これまでの経験及び実績から妥当とみなせる方法又は論理的に妥 |
| 当性を有する方法等、適切な知見に基づく手法を用いることを基本とする。 |
+----------------------------------------------------------------------+

＜推　奨＞

+------------------------------------------------------------------+
| 安全性能を照査するに当たっては、以下の手法によることが望ましい。 |
|                                                                  |
| １）鉄筋コンクリート部材設計                                     |
|                                                                  |
| > ・部材の設計に用いる断面力は、弾性理論により算出する。         |
| >                                                                |
| > ・部材の設計は、許容応力度設計法によって行う。                 |
|                                                                  |
| ２）鋼製の門扉の部材設計                                         |
|                                                                  |
| > 部材の設計は、許容応力度設計法によって行う。                   |
+------------------------------------------------------------------+

3.  常時の安全性能

＜考え方＞

+----------------------------------------------------------------------+
| 樋門の自重や樋門周辺の堤防からの土圧、さらに軟弱な地盤上に樋門を新設 |
| する場合には基礎地盤の強度不足又は圧縮性が大きいことによる地盤変位（ |
| 残留沈下や側方変位）の影響により、洪水等の外力による作用を受けずとも |
| 、構造物の安全性が損なわれる可能性があるため、函渠及び胸壁の応力度、 |
| 基礎の沈下量、支持力等について常時の安全性能の照査を行う必要がある。 |
|                                                                      |
| また                                                                 |
| 、樋門の基礎或いは地盤改良等による地盤の沈下抑制の影響によって、基礎 |
| を含む樋門本体部と周辺地盤との不同沈下による局部的な沈下による段差が |
| 生じる。この段差が樋門周辺の堤防に悪影響を与える可能性があるため、樋 |
| 門周辺の堤防との境界部における不同沈下について照査を行う必要がある。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 樋門の自重や樋門周辺の堤                                             |
| 防からの土圧等の作用や地盤変位の影響等の諸条件を設定し、発生する応力 |
| 度、変位や支持力等を評価し、許容値を満足することを照査の基本とする。 |
|                                                                      |
| また、沈下抑制対策を行った場合に                                     |
| は、盛土終了後に残留する樋門本体位置とその周辺の堤防の圧密沈下量の差 |
| 分を評価し、許容値を満足することを照査の基本とする。許容値を満足しな |
| い場合は、対策工を検討し、そのうえで許容値を満足することを照査する。 |
|                                                                      |
| 新規築堤や引堤のように、樋門とともに樋門周辺の堤防を新たに築造       |
| する場合には、樋門周辺の堤防に関しても地盤の複雑さに応じて、「設計編 |
| 第1章 河川構造物の設計 第2節 堤防                                    |
| 2.7安全性                                                            |
| 能の照査等**」**の記載に従って安全性能の照査を行うことを基本とする。 |
+----------------------------------------------------------------------+

34. 洪水時の安全性能

＜考え方＞

  --------------------------------------------------------------------------------------------------------------------------------
  樋門は、ゲート全閉時において、計画高水位（高潮区間にあっては計画高潮位）以下の水位の流水の作用に対して安全な構造が求められる。
  --------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 洪水時の安全性能は、ゲートへの水                                     |
| 圧、床版への揚圧力、本体・ゲート・付属施設（操作室・管理橋等）の自重 |
| 、土圧が作用する状態で、以下の項目について照査することを基本とする。 |
|                                                                      |
| １）函体の安全性                                                     |
|                                                                      |
| > 自重、                                                             |
| 洪水時の土圧や水圧が作用した状態で函体が安定する（浮き上がらない）こ |
| とを確認する。内空高よりも大きい土被りがある函体は照査を省略できる。 |
|                                                                      |
| ２）発生応力                                                         |
|                                                                      |
| > 樋門及びゲートの部材                                               |
| に発生する応力が「8.5.3の許容応力度**」**以下となることを確認する。  |
|                                                                      |
| ３）耐浸透性                                                         |
|                                                                      |
| > 樋門と堤体との接触面における浸透に対して、所定の安全性を確保する。 |
|                                                                      |
| ４）ゲート閉鎖の確実性及び水密性                                     |
|                                                                      |
| > ゲート閉鎖の確実性（床版及び戸                                     |
| 溝に土砂が堆積しない、確実な閉操作が可能なこと）、水密性を確保する。 |
+----------------------------------------------------------------------+

＜推　奨＞

+----------------------------------------------------------------------+
| １）耐浸透性                                                         |
|                                                                      |
| 耐浸透性照査における所要の安全性は                                   |
| 、地盤の土質区分、堤防断面形状、考慮する水頭差、遮水工の配置、深さ、 |
| 長さ、不同沈下が生じる場合にはルーフィング発生による浸透路長の減少を |
| 考慮したうえで、レインの式による浸透経路長を満足することを確認する。 |
|                                                                      |
| $$レイン加重                                                         |
| クリープ比　C \leqq \frac{\frac{L}{3} + \sum l}{\mathrm{\Delta}H}$$  |
|                                                                      |
| ここに、                                                             |
|                                                                      |
|   ------ ---- ---------------------------------------------------    |
|   *C*    ：   荷重クリープ比                                         |
|               *Cv* : 遮水工の鉛直方向の加重クリープ比                |
|               *Ch* : 遮水工の水平方向の加重クリープ比                |
|   *L*    ：   本体及び翼壁の函軸方向の浸透経路長（m）                |
|   *∑l*   ：   遮水矢板等の鉛直方向及び水平方向の浸透経路長（m）      |
|               *lv* : 鉛直方向の浸透経路長                            |
|               *lh* : 水平方向の浸透経路長                            |
|   *ΔH*   ：   内外水位差（m）                                        |
|   ------ ---- ---------------------------------------------------    |
|                                                                      |
| 45. 加重クリープ比C                                                  |
|                                                                      |
|   地盤の土質区分             C                                       |
|   -------------------------- -----                                   |
|   極めて細かい砂又はシルト   8.5                                     |
|   細砂                       7.0                                     |
|   中砂                       6.0                                     |
|   粗砂                       5.0                                     |
|   細砂利                     4.0                                     |
|   中砂利                     3.5                                     |
|   栗石を含む粗砂利           3.0                                     |
|   栗石と礫を含む砂利         2.5                                     |
|   柔らかい粘土               3.0                                     |
|   中くらいの粘土             2.0                                     |
|   堅い粘土                   1.8                                     |
|                                                                      |
| ２）ゲート機能                                                       |
|                                                                      |
| ゲート機能は、同様の敷高・規模及び操作形式の樋門・水門における       |
| 操作の確実性を確認できれば機能を確保しているとみなすことができる。な |
| お、堆砂傾向については、必要に応じて水理模型実験を実施して確認する。 |
+----------------------------------------------------------------------+

35. 耐震性能

＜考え方＞

+----------------------------------------------------------------------+
| 樋門の耐震性能の照査は、河川構造物の耐震性能照査指針に基づき         |
| 実施する必要がある。レベル1地震動に対しては、地震によって樋門として  |
| の健全性を損なわないか否かを照査する。レベル2地震動に対しては、治水  |
| 上又は利水上重要な樋門については、地震後においても、樋門としての機能 |
| を保持し、それ以外の樋門については、地震による損傷が限定的にとどまり |
| 、樋門としての機能の回復が速やかに行い得ることを照査する必要がある。 |
|                                                                      |
| 樋門の門柱及びゲートには地震時に慣性力及び地震時                     |
| 動水圧が作用するとともに、樋門周辺の堤防には地震時土圧が作用する。ま |
| た、樋門の函渠の地震時挙動は、地形、地盤条件等の種々の要因の影響を受 |
| けるが、中でも、堤体及び基礎地盤の影響を強く受ける。特に、基礎地盤が |
| 液状化した場合には、液状化に伴う堤体及び基礎地盤の変形が函渠の縦断方 |
| 向の地震時挙動に大きな影響を及ぼすため、液状化を考慮する必要がある。 |
+----------------------------------------------------------------------+

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  耐震性能の照査に当たっては、レベル1地震動に対して地震によって樋門としての健全性を損なわないことを照査し、レベル2地震動に対して樋門としての機能を保持する、或いは樋門としての機能の回復が速やかに行い得ることを照査の基本とする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

+----------------------------------------------------------------------+
| レベル１地震動及                                                     |
| びレベル2地震動の設定及び応答値の算定は、基本的に静的照査法を用いる  |
| ことができる。レベル2地震動の照査において静的照査法では適切な応答値  |
| を算定できない構造の場合には、動的解析を用いた照査を行う必要がある。 |
|                                                                      |
| 照査許容値は、求める                                                 |
| 耐震性能に応じた限界状態、構造・照査手法に応じた適切な値を設定する。 |
|                                                                      |
| 地震                                                                 |
| 動による作用応力、変位量等の応答値が許容値を超えないことを照査する。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  国土交通省水管理・国土保全局：[河川構造物の耐震性能照査指針・解説―Ⅳ．水門・樋門及び堰編―](https://www.mlit.go.jp/river/shishin_guideline/bousai/wf_environment/structure/index3.html)，令和2年2月（令和2年6月一部追記）.

```{=html}
<!-- -->
```
36. 風浪等に対する安全性

＜考え方＞

+----------------------------------------------------------------------+
| 高潮時及び風                                                         |
| 浪時の波浪並びに計画津波水位以下の津波に伴い、ゲートに波圧・津波荷重 |
| が作用する。ゲートの照査に用いる波圧及び津波荷重はダム・堰施設技術基 |
| 準（案）、防波堤の耐津波設計ガイドラインに基づき設定する必要がある。 |
|                                                                      |
| 樋門周辺の堤防は波の打ち寄せによる侵食に加え、場合によっては堤       |
| 内地への越波を生じ、堤内地の浸水及び樋門周辺の堤防裏法面が洗掘するこ |
| とにより堤防の安全性が損なわれる可能性がある。樋門周辺の堤防に対する |
| 照査は、堤防と同様にうちあげ高及び越波量により照査を行う必要がある。 |
+----------------------------------------------------------------------+

＜標　準＞

  -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  風浪等に対する本体の安全性能の照査は、本体が受ける水圧及び波圧の作用に対して安全性を評価し、許容値を満足することを照査の基本とする。風浪等に対する樋門周辺の堤防の安全性能の照査は、「設計編 第1章 河川構造物の設計 第2節 堤防 2.7 安全性能の照査等」を満足することを基本とする。
  -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1.  国土交通省：ダム・堰施設技術基準（案），平成28年3月．

```{=html}
<!-- -->
```
49. 国土交通省：防波堤の耐津波設計ガイドライン，平成25年9月．

    （最新版）国土交通省：防波堤の耐津波設計ガイドライン，平成25年9月（平成27年12月　一部改訂）．

    1.  []{#_Toc54772912 .anchor}許容応力度

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------
  許容応力度等は、使用する材料の基準強度や力学特性を考慮して、適切な安全性が確保できるように設定することを基本する。
  --------------------------------------------------------------------------------------------------------------------

＜推　奨＞

+----------------------------------------------------------------------+
| 許容応力度として、以下の値を用いることが望ましい。                   |
|                                                                      |
| １）コンクリートの許容応力度                                         |
|                                                                      |
| 46. コンクリートの許容応力度（N/mm^2^）                              |
|                                                                      |
|   設                                                                 |
| 計基準強度   許容曲げ圧縮応力度   許容付着応力度   許容せん断応力度  |
|   ---                                                                |
| ----------- -------------------- ---------------- ------------------ |
|   24             8.0                  1.60             0.39          |
|                                                                      |
| なお、せん断応                                                       |
| 力度は、せん断力を部材幅（b）×有効高（d）で割った平均せん断応力度。  |
|                                                                      |
| せん断応力度の照査は、支点が直接支持と                               |
| なっているものは支点の前面より1/2hだけ内側で行ってよい。(h:はり高）  |
|                                                                      |
| 無筋コンクリートの許容応力度は、道路橋示方書・同解説                 |
| Ⅳ．下部構造編（平成24年3月26日）による。                             |
|                                                                      |
| ２）鉄筋の許容引張応力度                                             |
|                                                                      |
| 47. 鉄筋の許容引張応力度（N/mm^2^）                                  |
|                                                                      |
| +------------------+------------------+------------------+-----+     |
| | 鉄筋の種類       | SD345            |                  |     |     |
| |                  |                  |                  |     |     |
| | 応               |                  |                  |     |     |
| | 力度、部材の種類 |                  |                  |     |     |
| +==================+==================+==================+=====+     |
| | 引張応力度       | 荷重             | 一般の部材※1     | 180 |     |
| |                  | の組合せに衝突荷 |                  |     |     |
| |                  | 重或いは地震の影 |                  |     |     |
| |                  | 響を含まない場合 |                  |     |     |
| +------------------+------------------+------------------+-----+     |
| |                  |                  | 厳し             | 160 |     |
| |                  |                  | い環境下の部材※2 |     |     |
| +------------------+------------------+------------------+-----+     |
| |                  | 荷重             | 200              |     |     |
| |                  | の組合せに衝突荷 |                  |     |     |
| |                  | 重或いは地震の影 |                  |     |     |
| |                  | 響を含む場合の許 |                  |     |     |
| |                  | 容応力度の基本値 |                  |     |     |
| +------------------+------------------+------------------+-----+     |
| |                  | 鉄筋の重ね       | 200              |     |     |
| |                  | 継手長或いは定着 |                  |     |     |
| |                  | 長を算出する場合 |                  |     |     |
| +------------------+------------------+------------------+-----+     |
|                                                                      |
| > ※1通常の環境や常時水中、土中の場合（操作台に適用）                 |
| >                                                                    |
| > ※2一般の環境に比べて乾湿の繰り返しが多い                           |
| 場合や有害な物質を含む地下水位以下の土中の場合（函渠、胸壁、遮水壁、 |
| 門柱、翼壁に適用）（海洋環境などでは別途かぶりなどについて考慮する） |
|                                                                      |
| ３）鋼材の許容応力度（ゲート等の機械設備を除く）                     |
|                                                                      |
| 48. 構造用鋼材の母材部及び溶接部の許容応力度（N/mm^2^）              |
|                                                                      |
| +--------+--------+--------+--------+--------+-----+-----+-----+     |
| | 鋼     | SS400  | SM490  | SM490Y | SM570  |     |     |     |     |
| | 材記号 |        |        |        |        |     |     |     |     |
| |        | SM400  |        | SM520  | S      |     |     |     |     |
| | 区     |        |        |        | MA570W |     |     |     |     |
| | 分及び | S      |        | S      |        |     |     |     |     |
| |        | MA400W |        | MA490W |        |     |     |     |     |
| | 応力度 |        |        |        |        |     |     |     |     |
| | の種類 |        |        |        |        |     |     |     |     |
| +========+========+========+========+========+=====+=====+=====+     |
| | 母材部 | 引　張 | 140    | 185    | 210    | 255 |     |     |     |
| |        |        |        |        |        |     |     |     |     |
| |        | 圧　縮 | 140    | 185    | 210    | 255 |     |     |     |
| |        |        |        |        |        |     |     |     |     |
| |        | せん断 | 80     | 105    | 120    | 145 |     |     |     |
| +--------+--------+--------+--------+--------+-----+-----+-----+     |
| | >      | > 工   | 全断面 | 引　張 | 140    | 185 | 210 | 255 |     |
| | 溶接部 | 場溶接 | 溶込み |        |        |     |     |     |     |
| |        |        | グルー | 圧　縮 | 140    | 185 | 210 | 255 |     |
| |        |        | プ溶接 |        |        |     |     |     |     |
| |        |        |        | せん断 | 80     | 105 | 120 | 145 |     |
| +--------+--------+--------+--------+--------+-----+-----+-----+     |
| |        |        | すみ   | せん断 | 80     | 105 | 120 | 145 |     |
| |        |        | 肉溶接 |        |        |     |     |     |     |
| |        |        | ，部分 |        |        |     |     |     |     |
| |        |        | 溶込み |        |        |     |     |     |     |
| |        |        | グルー |        |        |     |     |     |     |
| |        |        | プ溶接 |        |        |     |     |     |     |
| +--------+--------+--------+--------+--------+-----+-----+-----+     |
| |        | 現     | 引　張 | 原則と |        |     |     |     |     |
| |        | 場溶接 |        | して、 |        |     |     |     |     |
| |        |        | 圧　縮 | 工場溶 |        |     |     |     |     |
| |        |        |        | 接と同 |        |     |     |     |     |
| |        |        | せん断 | じ値と |        |     |     |     |     |
| |        |        |        | する。 |        |     |     |     |     |
| +--------+--------+--------+--------+--------+-----+-----+-----+     |
|                                                                      |
| ４）許容応力度の割増し                                               |
|                                                                      |
| 地震、温度変化等の短期荷重を考慮する場合は、表8-12による             |
| 許容応力度の割増しを行なうことができる。下記以外の荷重の組合せによる |
| 許容応力度の割増しを考慮する場合は、個々の状況に応じて適切に定める。 |
|                                                                      |
| 49. 許容応用力度の割増し                                             |
|                                                                      |
| +------------------------+--------+                                  |
| | 短　期　荷　重         | 割増率 |                                  |
| |                        |        |                                  |
| |                        | （％） |                                  |
| +========================+========+                                  |
| | 温度変化の影響         | 15     |                                  |
| +------------------------+--------+                                  |
| | 風荷重                 | 25     |                                  |
| +------------------------+--------+                                  |
| | 地震動                 | 50     |                                  |
| +------------------------+--------+                                  |
| | 温度変化の影響＋風荷重 | 35     |                                  |
| +------------------------+--------+                                  |
| | 温度変化の影響＋地震動 | 65     |                                  |
| +------------------------+--------+                                  |
| | 施工時荷重             | 50     |                                  |
| +------------------------+--------+                                  |
+======================================================================+
|                                                                      |
+----------------------------------------------------------------------+

1.  []{#_Toc47014763 .anchor}各部位の設計等

    1.  []{#_Toc47014764 .anchor}本体

```{=html}
<!-- -->
```
4.  ゲート

```{=html}
<!-- -->
```
1.  ゲートの構造

＜考え方＞

+----------------------------------------------------------------------+
| ゲートは全閉することによって、洪水時又は高潮時において、計画高水     |
| 位（高潮区間においては計画高潮位）以下の水位の流水の作用、風浪等にお |
| ける波圧に対して安全な構造となるよう設計する必要があり、河川水が堤防 |
| 内に入り滞留することを防ぐため、原則として川表側に設ける必要がある。 |
|                                                                      |
| ゲー                                                                 |
| トは、確実に開閉し、かつ、必要な水密性を有する構造とするため適切なゲ |
| ート形式を選定する必要がある。樋門のゲートは、一般的に引上げ式のロー |
| ラゲート、スライドゲート、マイターゲート、フラップゲートが使用されて |
| いるが、操作の確実な点では引上げ式のローラゲートが最も優れている。し |
| かし、フラップゲートやマイターゲート等の水圧、浮力で開閉するゲートは |
| 、頻繁に操作が必要な感潮区間や、中小河川で出水頻度が多く出水時間が早 |
| い場合、或いは高潮による急激な水位上昇が発生する場合などに有利であり |
| 、高齢化による操作員の減少、安全の確保という背景と操作の確実性という |
| 要請などを踏まえると有効な選択肢となり得る。そのため、樋門ゲート構造 |
| については、施設の規模、背後地の土地利用状況、個別の状況（管理上、構 |
| 造上の条件等）を総合的に勘案し選定する必要がある。なお、ゲート形式を |
| フラップゲート又はマイターゲートとする場合は、不完全閉塞を起こす可能 |
| 性が非常に少なく、不完全閉塞が起こったとしても、治水上著しい支障を及 |
| ぼすおそれがないと認められ、かつ、引上げ式ゲートとした場合に、出水時 |
| の開閉操作にタイミングを失うおそれがあること、人為操作が著しく困難又 |
| は不適当と認められること、川裏の予備ゲート又は角落し等を設けることに |
| よって容易、かつ、確実に外水を遮断できる構造であることが必要である。 |
|                                                                      |
| 扉体構造は、実績も多く、荷重を合理的に受け、戸当りを介して           |
| 函渠、門柱へ伝達することができるプレートガーダ構造を基本としている。 |
|                                                                      |
| ゲートの基本寸                                                       |
| 法とは、設置標高、内空断面、断面高等を意味し、引上げ式ゲート全開時の |
| 扉体の下端標高については揚程を考慮し設定する必要がある。また、ゲート |
| 引上げ完了時のゲート下端高は、樋門の頂版以上の高さとする必要がある。 |
|                                                                      |
| 戸当りは、コンクリート構造                                           |
| 物の規模、強度等に与える影響が大きいため、戸当りの寸法、構造、設置方 |
| 法等とコンクリート構造物との関連性を検討する必要がある。また、ゲート |
| が点検や整備時に取り外されることも考慮して構造を決定する必要がある。 |
+----------------------------------------------------------------------+

＜必　須＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------
  ゲートは、確実な開閉が行えるとともに必要な水密性を有する構造とし、残留沈下及び傾斜を考慮して設計荷重に対して安全な構造となるよう設計するものとする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| ゲートは、洪水時、高潮時及び風浪等が作用した場合において、全閉するこ |
| とによって堤防の代わりとなり得るように川表に設けることを基本とする。 |
|                                                                      |
| ゲート形式及び規模は、本体の形式・規模及び戸当り等、他の設備と       |
| の配置を考慮して、設計条件を満足するように決定することを基本とする。 |
|                                                                      |
| 扉体構造はプレートガーダ構造を基本とする。                           |
|                                                                      |
| ゲートの基本寸法は、制約条                                           |
| 件を考慮して、「8.4基本的な構造」に準じて決定することを基本とする。  |
|                                                                      |
| 戸当りの形状はゲートの形式に                                         |
| 適合したものとし、扉体支承部からの荷重を安全にコンクリート構造物に伝 |
| 達することができるように寸法、強度及び剛性を有することを基本とする。 |
+----------------------------------------------------------------------+

＜例　示＞

+--------------------------------------------------------------+
| 河川や設置場所の特性に応じて門柱レスゲートの採用事例がある。 |
|                                                              |
| 門柱レスゲートの主な構造形式を表8-13に示す。                 |
|                                                              |
| 50. 門柱レスゲートの主な構造形式                             |
|                                                              |
|   開閉形式     ゲート形式       主な主動力方式               |
|   ------------ ---------------- --------------------------   |
|   ヒンジ形式   起伏ゲート       無動力式                     |
|                マイターゲート   無動力式、機械式、油圧式     |
|                フラップゲート   無動力式、機械式、油圧式     |
+--------------------------------------------------------------+

6.  開閉装置

＜考え方＞

+----------------------------------------------------------------------+
| 樋門は、平常時は                                                     |
| 全開又は一部開放しており、洪水時又は高潮時にゲートを全閉し堤防機能を |
| 確保する必要があることから、確実にゲートを開閉できる必要がある。開閉 |
| 装置の設置箇所は、ゲート形式に応じて適切に設定する必要があり、引上げ |
| 式ゲートの場合は堤防高よりも高い操作台の上に設置している場合が多い。 |
|                                                                      |
| 開閉装置の形式は、標準で示すものの他、使用頻度                       |
| 、流量調整の有無、締切力の有無、操作室のスペース、維持管理等を検討し |
| 、選定する必要がある。一般的によく利用される開閉装置形式は、ラック式 |
| 、ワイヤーロープウインチ式、油圧シリンダ式などがあり、小・中型ゲート |
| では操作性がよく、扉体自重による急閉塞も可能なラック式の採用が多い。 |
|                                                                      |
| 開閉装置は、操作の確実性や容易さを考慮し、電動                       |
| 機を原則とする。なお、小規模樋門のゲートでは、経済性を考慮して人力に |
| よる開閉操作の採用も考えられるが、この場合は、操作水位、ゲート形式、 |
| 自重降下の有無、人力での操作力と操作時間（一般に10kgf以下で操作時間  |
| 10分未満程度が限界）等を考慮して、所定の機能等を確保する必要がある。 |
|                                                                      |
| 予備電源を設けることにより、常用（商用）                             |
| 電源が暴風雨等において停電した場合でも対応することができ、必要最小限 |
| の機能を確保できる。中・小型のゲートでは、ゲート形式と自重降下の有無 |
| 、開閉装置形式、管理体制等を考慮して、人力による方式も採用でき、この |
| 場合、常用（商用）電源の代わりとなる予備電源は省略することもできる。 |
|                                                                      |
| 予備動力を設けることにより、主動力が使用不可能とな                   |
| っても、ゲートを操作することができる。予備動力は、電動機による方式が |
| 望ましいが、中・小型のゲートでは、ゲート形式と自重降下の有無、開閉装 |
| 置形式、管理体制等を考慮して、人力による方式で代用することができる。 |
|                                                                      |
| ゲート                                                               |
| の操作は機側操作が一般的に採用されるが、樋門の目的、規模、現場操作員 |
| の負担軽減や安全の確保等の管理体制を踏まえ、必要に応じて自動化、遠方 |
| 操作化や遠隔操作化を検討することとする。自動化は、計測した水位に応じ |
| て自動で開閉操作を行うことができるように改造することや、ゲート自体を |
| フラップゲート等自動開閉が可能なものとすることであり、遠方操作化や遠 |
| 隔操作化は、管理所や遠隔地から操作を行うことを可能とすることである。 |
+----------------------------------------------------------------------+

＜必　須＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------
  開閉装置は、ゲートの確実な開閉操作を行うとともに必要な水密性を有する構造とし、残留沈下及び傾斜を考慮して設計荷重に対して安全な構造となるよう設計するものとする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 開閉装置は、ゲートの開閉を確実に行う                                 |
| ために設置し、ゲート形式に応じて適切な箇所に設けることを基本とする。 |
|                                                                      |
| 開閉装置形式の選定に当たっては、設備の設置目的、用途、               |
| ゲートの種類、開閉荷重の大きさ、方向及び押下げ力の要否、揚程、開閉装 |
| 置の設置位置、配置及び設置環境を考慮の上、選定することを基本とする。 |
|                                                                      |
| 開閉装置は、小規模なゲートを除き、電動機等に                         |
| よるものとし、全てのゲートに開閉用予備動力を備えることを基本とする。 |
|                                                                      |
| ゲートの操作のための設備は、機側操作を基本とする。な                 |
| お、必要に応じて自動化、遠方操作化や遠隔操作化を検討することとする。 |
+----------------------------------------------------------------------+

＜推　奨＞

  ----------------------------------------------------------------------------------------------------------------------
  樋門に使用する開閉装置では、小型ゲートについては操作性がよく、扉体自重により急閉塞も可能なラック式の採用が望ましい。
  ----------------------------------------------------------------------------------------------------------------------

＜例　示＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  ゲートの操作は、操作上の安全確保の観点から、機側操作優先で設計される場合が多い。ただし、津波・高潮区間や排水機場周辺の連動操作が必要な場合など、管理体制等の条件により遠方操作・遠隔操作を行う場合、十分な安全性を確保したうえで、機側操作に対し遠方操作・遠隔操作を優先する設計を行う場合がある。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1.  国土交通省：[ダム・堰施設技術基準（案）](https://www.mlit.go.jp/common/001126025.pdf)，平成28年3月.

```{=html}
<!-- -->
```
50. 一般社団法人ダム・堰施設技術協会：ダム・堰施設技術基準（案）（平成28年3月改正）基準解説編・設備計画マニュアル編，平成28年10月.

51. 一般社団法人ダム・堰施設技術協会：水門・樋門ゲート設計要領（案），平成13年12月.

```{=html}
<!-- -->
```
37. 函渠

```{=html}
<!-- -->
```
1.  函渠の構造

＜考え方＞

+----------------------------------------------------------------------+
| 函渠は、用水                                                         |
| 、排水及び舟の通行に必要な機能を満足する適切な位置へ設ける必要がある |
| 。樋門の設置位置の考え方は「8.3設計の基本**」**に示すとおりとする。  |
|                                                                      |
| 函軸の構造形式は、継手の構造特性、胸壁・遮水壁等の構造特性及         |
| び基礎形式等を考慮して設定し、たわみ性構造及び非たわみ性構造に分類さ |
| れる。たわみ性構造は剛な函体とたわみ性の継手、或いは函体自体がたわみ |
| 性の構造で、柔構造樋門として用いられる構造である。非たわみ性構造は継 |
| 手が無い1スパンの場合や継手の変形能力が小さい構造であり、変形が許容  |
| できない場合に適用され、良好な地盤や地盤改良等を行ったうえで用いる。 |
|                                                                      |
| 函体断面の構造形式は、断面のたわみ特性の違                           |
| いから、コンクリート構造の剛性函体及び鋼管・ダクタイル鋳鉄管等で構成 |
| されるたわみ性函体に分類される。たわみ性函体は、函体自体が変形を許容 |
| する構造のため、堤防機能に悪影響を及ぼさないよう留意する必要がある。 |
|                                                                      |
| 函渠の断面、函渠長                                                   |
| は、「8.4.1函渠の内空断面の設定」及び「8.4.2函渠長**」**に示す内容に |
| より設計し、構造形式や端部の取り合いを考慮の上、設定する必要がある。 |
|                                                                      |
| ゲート前面には必要に応じて角落しを設けるための戸                     |
| 溝を設ける必要がある。川表側は、常時水位が高い場合等においてゲートや |
| 函内の維持管理を行うために設ける。川裏側は、川表側と同様に維持管理の |
| 利用に加え、異常時の仮ゲート機能の確保のために設ける。それぞれ必要性 |
| を検討して設ける必要がある。戸溝幅は、水圧の大きさにより決定される角 |
| 落しの規模により設定する必要があるが、0.1m程度としている場合が多い。 |
+----------------------------------------------------------------------+

＜必　須＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  函渠は、遮水壁、門柱、胸壁、ゲート操作台と一体構造とし、必要な水密性、屈とう性を有する構造とし、残留沈下を考慮して設計荷重に対して安全な構造となるよう設計するものとする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 函渠は、目的とする                                                   |
| 取水機能、排水機能等を満足させ、適切な位置に設けることを基本とする。 |
|                                                                      |
| 函渠の構造形式は、                                                   |
| 函体の断面構造及び継手の構造特性を考慮して決定することを基本とする。 |
|                                                                      |
| 函渠の断面、函渠長は、「8.4.1函渠の内空断面の設定*                   |
| *」**、「8.4.2函渠長**」**に示す内容により設計することを基本とする。 |
|                                                                      |
| ゲート前面には、角落し設置のための戸溝を設けることを基本とする。     |
+----------------------------------------------------------------------+

＜推　奨＞

+----------------------------------------------------------------------+
| １）函渠端部の構造                                                   |
|                                                                      |
| 函渠                                                                 |
| 端部は、門柱、胸壁、遮水矢板等からの作用の影響や戸溝の設置など函渠中 |
| 央部よりも設計条件が厳しくなるため、これらの状況に対して安全な構造が |
| 求められる。函渠両端には、図8-9に示すように函渠両端部の頂版部及び川  |
| 表側端部の側壁の厚さを増して補強することが望ましい。ただし、大規模な |
| 樋門で頂版及び側壁の厚さが大きい場合(0.5ｍ以上）には補強の必要はない |
| 。また、0.5ｍ以下の場合には、補強後の厚さの上限を0.5ｍとすることが望 |
| ましい。なお、函渠端部の底版の厚さは、下部戸当りのため必要な厚さを考 |
| 慮し、また、胸壁の底版の厚さと同一となるように定めることが望ましい。 |
|                                                                      |
| 函体端部を短いスパンとした場合は、予期せぬ不                         |
| 同沈下が生じるため、あらかじめ防止策を検討して安定を図る必要がある。 |
|                                                                      |
| ![](media/image117.png){width="5.263054461942257in"                  |
| height="2.0263112423447067in"}                                       |
|                                                                      |
| 66. 川表函渠端部                                                     |
|                                                                      |
| ２）戸溝部の補強                                                     |
|                                                                      |
| 戸溝による部材厚の減少分については、必                               |
| 要に応じて厚さを増すことによる補強又は鉄筋補強を行うことが望ましい。 |
|                                                                      |
| ３）水生生物等の環境の配慮                                           |
|                                                                      |
| 川表・川裏側の底版と河床の間に著しい段差を生じさせないなど、水       |
| 生生物等の生息環境、本支川の移動等を考慮して設計することが望ましい。 |
+----------------------------------------------------------------------+

7.  継手

＜考え方＞

+----------------------------------------------------------------------+
| 継手は、地盤                                                         |
| の残留沈下量分布、堤防の横断形状、樋門の構造形式、基礎及び地盤の変形 |
| 特性、基礎形式等を考慮して適切に函渠をスパン割し、設ける必要がある。 |
|                                                                      |
| 継手の構造形式は、想定される変形量に応じた函渠の開口、折             |
| れ角、目違い等を検討し、適切な形式を選定する必要がある。一般的には、 |
| 継手の開口、折れ角、目違いをほとんど拘束しない可とう性継手、継手の目 |
| 違いを拘束するが、開口、折れ角をほとんど拘束しないカラー継手、継手バ |
| ネの大きさとスパン間の変位差に応じた断面力を伝達する弾性継手がある。 |
+----------------------------------------------------------------------+

＜必　須＞

  ------------------------------------------------------------------------------------------------------------------------------
  継手は、必要な水密性及び屈とう性を有する構造とし、残留沈下を考慮して設計荷重に対して安全な構造となるよう設計するものとする。
  ------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 継手は、地盤の沈下・変位に樋門を追随させるた                         |
| めに設置し、函渠の適切なスパン割を検討して配置することを基本とする。 |
|                                                                      |
| 継手は                                                               |
| 、想定される変形量に応じ、適切な構造形式を選定することを基本とする。 |
+----------------------------------------------------------------------+

＜推　奨＞

+----------------------------------------------------------------------+
| １）継手の設置間隔                                                   |
|                                                                      |
| 継手の最大間隔は20m程度を推奨する                                    |
| が、軟弱地盤における樋門では、不同沈下の影響が避けられないので、継手 |
| 間隔は地盤条件及び構造特性を考慮した適切な間隔とすることが望ましい。 |
|                                                                      |
| ２）継手の設置位置                                                   |
|                                                                      |
| 継手の位置は、土圧が大きい中央部付近をできる限                       |
| り避けるようにすることが望ましい。そのため、継手は2個以上とすること  |
| が望ましく、スパン長や継手部の安全性に配慮して、設置位置を決定する。 |
+----------------------------------------------------------------------+

8.  扉室

＜考え方＞

+----------------------------------------------------------------------+
| 取水のた                                                             |
| めの樋門で、敷高が低い場合や取付水路の延長が長く維持管理ができない場 |
| 合、又は排水のための樋門で高水敷が公園等に利用されている場合等では、 |
| 取付水路を函渠構造とすることが多い。このような場合は、ゲートの維持管 |
| 理や据え付け・取外しを支障なく実施できるよう扉室を設ける必要がある。 |
|                                                                      |
| ![](media/image118.png){width="3.1382742782152233in"                 |
| height="2.4797692475940507in"}                                       |
|                                                                      |
| 67. 扉室                                                             |
+----------------------------------------------------------------------+

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------
  扉室は、取付水路が函渠構造の場合に、函渠内部やゲートの維持管理を行うため、取付水路の函渠と接続部に設けることを基本とする。
  ----------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

+----------------------------------------------------------------------+
| １）マンホールの蓋の浮上り防止                                       |
|                                                                      |
| 扉室に設けるマンホールは、密閉された状態の空間                       |
| に河川水が流入することによって圧力が発生し、マンホールの蓋が浮上がる |
| ことが考えられることから、マンホールの蓋の浮上がりを検討し、必要に応 |
| じ浮上がり防止のための金具を設けるなどの対策を講ずることが望ましい。 |
|                                                                      |
| ２）マンホール内の昇降施設の設置                                     |
|                                                                      |
| 昇降施設                                                             |
| として維持管理のためのタラップ等を常設し、水没する場合においては、必 |
| 要に応じてタラップの腐食等を考慮した構造や材質とすることが望ましい。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  下水道マンホール緊急対策検討委員会，[下水道マンホール安全対策の手引き（案）](https://www.mlit.go.jp/common/000109957.pdf)，平成11年3月．

```{=html}
<!-- -->
```
38. 遮水壁

＜考え方＞

+----------------------------------------------------------------------+
| 遮水壁                                                               |
| は、樋門と堤体の接触面で発生する浸透流の卓越に伴うパイピングにより樋 |
| 門が堤防の弱点となることを防止するため、1箇所以上設ける必要がある。  |
|                                                                      |
| 遮水壁の高さ及び幅は、函渠天端及び函渠側面からそ                     |
| れぞれ1m以上となるように設定するが、土被りが小さい樋門で遮水壁の高さ |
| を1mとすることが不適当な場合は、適当な範囲まで縮小することができる。 |
|                                                                      |
| ![](media/image119.png){width="3.5696281714785654in"                 |
| height="1.3611811023622047in"}                                       |
|                                                                      |
| 68. 遮水壁の設置例                                                   |
+----------------------------------------------------------------------+

＜必　須＞

  ------------------------------------------------------------------------------------------------------------------------------------
  遮水壁は、函渠と一体構造で必要な水密性を有する構造とし、残留沈下を考慮して設計荷重に対して安全な構造となるよう設計するものとする。
  ------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 遮水壁は、函渠の上面及び側面に沿                                     |
| うパイピングを防止するため、函渠に1箇所以上設けることを基本とする。  |
|                                                                      |
| 遮水壁                                                               |
| の高さ及び幅は、函渠天端及び函渠側面からそれぞれ1m以上を基本とする。 |
+----------------------------------------------------------------------+

＜推　奨＞

  -------------------------------------------------------------------------------------
  堤防断面が大きく、函渠の長さが長い場合には、遮水壁を2個所以上設けることが望ましい。
  -------------------------------------------------------------------------------------

39. 門柱

＜考え方＞

+----------------------------------------------------------------------+
| 門柱は、引上げ式ゲート                                               |
| を採用した場合において、ゲートを引上げるために設ける必要がある。フラ |
| ップゲートやマイターゲート等のゲート形式の場合は門柱を必要としない。 |
|                                                                      |
| 門柱の高さは「8.4.3門柱の天端高**」                                  |
| **に従い、ゲートの大きさ、引上げ余裕等を考慮し、設定する必要がある。 |
|                                                                      |
| 門柱の断面設定においては、設けるゲ                                   |
| ート及び戸当り金物の規模、設置スペースを考慮して設定する必要がある。 |
|                                                                      |
| 門柱の底部戸当り面は、                                               |
| 函渠との段差を生じさせないように函渠底版と同一平面とする必要がある。 |
+----------------------------------------------------------------------+

＜必　須＞

  ----------------------------------------------------------------------------------------------------------------
  門柱は、函渠と一体構造とし、残留沈下及び傾斜を考慮して設計荷重に対して安全な構造となるよう設計するものとする。
  ----------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 門柱は、ゲート形式が引上げ                                           |
| 式ゲートの場合に設置し、函渠の配置に合わせて設けることを基本とする。 |
|                                                                      |
| 門柱                                                                 |
| の高さは「**8.4.3門柱の天端高」**に従って設定することを基本とする。  |
|                                                                      |
| 門柱の断面は、戸当り金                                               |
| 物を十分な余裕をもって取り付けられるように設計することを基本とする。 |
|                                                                      |
| 門柱の底部戸当り面は、函渠底版と同一平面とすることを基本とする。     |
+----------------------------------------------------------------------+

＜推　奨＞

+----------------------------------------------------------------------+
| １）門柱の構造計算に用いる有効断面には、原則として戸当               |
| たりの箱抜き部分の二次コンクリートを考慮せず設計することが望ましい。 |
|                                                                      |
| ２）門柱部の戸当りは、                                               |
| ゲートが取外せるように取外し式又は回転式とすることが望ましい（図8-12 |
| 参照）。                                                             |
|                                                                      |
| ![](media/image120.png){width="6.209027777777778in"                  |
| height="2.1638888888888888in"}                                       |
|                                                                      |
| 69. 取外し式戸当りの例                                               |
|                                                                      |
| ２）門柱と函渠の接続部は、応力集中が考えられるため、図               |
| 8-13のように斜め補強筋、或いはその他の方法で補強することが望ましい。 |
|                                                                      |
| ![](media/image121.png){width="2.5639457567804023in"                 |
| height="2.0081911636045495in"}                                       |
|                                                                      |
| 70. 門柱と函渠接続部の配筋                                           |
+----------------------------------------------------------------------+

40. ゲートの操作台

＜考え方＞

+----------------------------------------------------------------------+
| 操                                                                   |
| 作台は、ゲート操作用の開閉装置及び操作盤等の機器の設置、照明等の付属 |
| 施設を設けるため、引上げ式ゲートの場合は門柱の上に設ける必要がある。 |
|                                                                      |
| 操作台は、開閉装置の設                                               |
| 置及び操作、点検並びに整備等の維持管理が容易に行える広さを有する必要 |
| がある。維持管理に必要な広さの設定は、水門・樋門ゲート設計要領（案） |
| 6-3-3開閉操作室に準拠する。                                          |
+----------------------------------------------------------------------+

＜必　須＞

  ------------------------------------------------------------------------------------------------------------------
  操作台は、門柱と一体構造とし、残留沈下及び傾斜を考慮して設計荷重に対して安全な構造となるよう設計するものとする。
  ------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 操作台は、ゲート操作用の開閉                                         |
| 装置、操作盤等の機器を設けるため、門柱の上に設けることを基本とする。 |
|                                                                      |
| ゲート操作台は、操作性、維持管理に配慮した形状寸法を基本とする。     |
+----------------------------------------------------------------------+

＜推　奨＞

  ----------------------------------------------------------------------------------------------------
  操作室の設置に当たっては、耐震性能を確保する観点から極力軽量な材質を適切に選定することが望ましい。
  ----------------------------------------------------------------------------------------------------

＜関連通知等＞

2.  一般社団法人ダム・堰施設技術協会：水門・樋門ゲート設計要領（案），平成13年12月.

    1.  []{#_Toc47014765 .anchor}胸壁

＜考え方＞

+----------------------------------------------------------------------+
| 胸壁は、堤防内の土                                                   |
| 粒子の移動及び吸出しを防止するとともに、翼壁が洗掘等により破損し、堤 |
| 防前面が崩壊した場合においても、一時的に堤防の崩壊を防止できる構造と |
| するため、函渠と一体構造とし、樋門の川表及び川裏に設ける必要がある。 |
|                                                                      |
| 胸壁は、函渠と一体とな                                               |
| って堤体土の崩壊を防止する壁構造とするため、逆Ｔ形構造を基本とする。 |
|                                                                      |
| 胸壁の函軸直角方向の長さは1m程度とする必要がある。                   |
|                                                                      |
| 胸壁の横方                                                           |
| 向の長さは1m程度とし、函体上面からの胸壁の高さは、堤防断面の最小限の |
|                                                                      |
| 切り込みを考慮して決定する必要がある。                               |
+----------------------------------------------------------------------+

＜必　須＞

  --------------------------------------------------------------------------------------------------------------------------------------------
  胸壁は、函渠と一体の構造で必要な水密性を有する構造とし、残留沈下及び傾斜を考慮して設計荷重に対して安全な構造となるよう設計するものとする。
  --------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 胸壁は、堤防内の土粒子の移動及                                       |
| び吸出しを防止するとともに、翼壁の破損等による堤防の崩壊を一時的に防 |
| 止できる構造とするため、樋門の川表及び川裏に設けることを基本とする。 |
|                                                                      |
| 胸壁の構造は、逆Ｔ形を基本とする。                                   |
|                                                                      |
| 胸壁の横方向の長さは、1m程度を基本とする。                           |
+----------------------------------------------------------------------+

＜推　奨＞

+----------------------------------------------------------------------+
| 函渠頂版の天端から胸壁の天端までの高さは、「8.4.2函渠                |
| 長**」**のとおり0.5m程度とし、高くても1.5m以下とすることが望ましい。 |
|                                                                      |
| 胸壁                                                                 |
| の断面形状は、図8-13に示すように底版幅（B）は、胸壁高（H）の1/2以上  |
| で、かかと（b2）の長さはつま先（b1）の長さ以上とすることが望ましい。 |
|                                                                      |
| ![](media/image122.png){width="2.2471784776902886in"                 |
| height="3.630057961504812in"}                                        |
|                                                                      |
| 71. 函体端部の構造（門柱部）                                         |
+----------------------------------------------------------------------+

1.  []{#_Toc47014766 .anchor}翼壁

＜考え方＞

+----------------------------------------------------------------------+
| 翼壁                                                                 |
| は、函渠及び胸壁と分離した構造で、堤防や堤脚を保護し、接続する河川又 |
| は水路を円滑に通水させるため、樋門の川表及び川裏に設ける必要がある。 |
|                                                                      |
| 翼壁の                                                               |
| 構造は、安定性、経済性から図8-15に示すＵ形断面（Aタイプ）とすること  |
| を基本とするが、水路幅が広くなると、底版が厚くなり、品質及び経済性に |
| 課題が生じる場合があるため、その場合には逆Ｔ形断面（Bタイプ）を採用  |
| する。また、必要に応じて水生生物の生息に配慮した形状構造を工夫する。 |
|                                                                      |
| ![](media/image123.png){width="2.9854166666666666in"                 |
| height="1.0298611111111111in"}                                       |
|                                                                      |
| 72. 翼壁標準断面図                                                   |
|                                                                      |
| 翼壁の端部は、接続する河川又は水路及びその周辺からの洗掘             |
| 等による堤防への影響を避けるため、堤防と並行に壁を設ける必要がある。 |
+----------------------------------------------------------------------+

＜必　須＞

  --------------------------------------------------------------------------------------------------------------------------------------
  翼壁は、必要な水密性及び屈とう性を有する構造とし、残留沈下及び傾斜を考慮して設計荷重に対して安全な構造となるよう設計するものとする。
  --------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 翼壁は、函渠及び胸壁と分離した構造で、堤                             |
| 防や堤脚を保護するため、樋門の川表及び川裏に設けることを基本とする。 |
|                                                                      |
| 翼                                                                   |
| 壁の構造は、Ｕ形断面を基本とし、水路幅が広い場合は逆Ｔ形断面とする。 |
|                                                                      |
| 翼壁の端部は、堤防と並行に壁を設けることを基本とする。               |
+----------------------------------------------------------------------+

＜推　奨＞

+----------------------------------------------------------------------+
| 1.  平面形状                                                         |
|                                                                      |
| 翼壁の平                                                             |
| 面形は、図8-16のように川表及び川裏に向かって漸拡することが望ましい。 |
|                                                                      |
| 2.  設置範囲                                                         |
|                                                                      |
| 翼壁は、図8-16に示すように堤防断面以上（堤防断面の法                 |
| 面を延長し翼壁の底版と交差する範囲）の範囲まで設けることが望ましい。 |
|                                                                      |
| 翼壁の端                                                             |
| 部は、水路の洗掘等を考慮し、堤防に平行な取付水路の護岸の範囲又は翼壁 |
| 端部の壁高に1mを加えた値のいずれか高い方の高さとすることが望ましい。 |
|                                                                      |
| ![](media/image124.png){width="5.588339895013124in"                  |
| height="4.462962598425197in"}                                        |
|                                                                      |
| 73. 翼壁の平面図及び側面図                                           |
+----------------------------------------------------------------------+

1.  []{#_Toc47014767 .anchor}水叩き

＜考え方＞

+----------------------------------------------------------------------+
| 水叩きは、樋門の安全性を保ち、吐口部及                               |
| び吞口部の河床と函渠部分の粗度の違い又はゲート開放時の流水等によって |
| 河床が洗掘されるのを防止するために設ける必要があり、翼壁の構造形式が |
| 「8.6.3翼壁**」**の〈標準〉逆Ｔ形断面（Bタイプ）となる場合に設ける。 |
|                                                                      |
| 水叩きと翼壁との継手は、水密かつ不同沈下にも対応できる構造           |
| で、表面に大きな段差を生じさせないよう設計する必要がある。また、翼壁 |
| に設ける遮水工が水叩きによって分断されないように配慮する必要がある。 |
|                                                                      |
| 水叩きは、翼                                                         |
| 壁の底版を保護する必要があるため、翼壁と同一の長さとする必要がある。 |
+----------------------------------------------------------------------+

＜必　須＞

  --------------------------------------------------------------------------------------------------------------
  水叩きは、必要な水密性及び屈とう性を有する構造とし、設計荷重に対して安全な構造となるよう設計するものとする。
  --------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 水叩きは、樋門の吐口部及                                             |
| び吞口部の洗掘を防ぐため、必要に応じて翼壁に設けることを基本とする。 |
|                                                                      |
| 水叩きの先端は、流                                                   |
| 水による洗掘及び遮水工との接続に配慮した構造であることを基本とする。 |
|                                                                      |
| 水叩きは、翼壁と同一の長さとすることを基本とする。                   |
+----------------------------------------------------------------------+

2.  []{#_Toc47014768 .anchor}遮水工

＜考え方＞

+----------------------------------------------------------------------+
| 遮水工は、函渠及び翼壁下部の浸透流の卓越に                           |
| 伴う土砂流動と、翼壁前面での河床洗掘による土砂の吸出しにより、樋門が |
| 堤防の弱点となることを防止するために、翼壁や函渠に設ける必要がある。 |
|                                                                      |
| 遮水工は、鋼矢板を用いることが多く、遮水工の深さ及び水平方向の       |
| 長さは、堤防断面形状、水頭差、遮水工の配置を考慮したうえで、レインの |
| 式などによる浸透経路長を検討し設定する必要がある。鋼矢板以外の材料と |
| する場合は材料の強度、耐久性、遮水効果について検討を行う必要がある。 |
+----------------------------------------------------------------------+

＜必　須＞

  --------------------------------------------------------------------------------------------------------------------------------
  遮水工は、必要な水密性及び屈とう性を有する構造とし、残留沈下を考慮して設計荷重に対して安全な構造となるよう設計するものとする。
  --------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 遮水工は、函渠及び翼壁下部の土砂流動と洗掘に                         |
| よる土砂の吸出しを防止するため、適切な位置に設けることを基本とする。 |
|                                                                      |
| 遮水工                                                               |
| の構造、遮水工の深さ、水平方向の長さは、堤防断面形状、水頭差、浸透経 |
| 路長、過去の事例などを総合的に検討のうえで決定することを基本とする。 |
+----------------------------------------------------------------------+

＜推　奨＞

+----------------------------------------------------------------------+
| 1.  配置                                                             |
|                                                                      |
| 遮水工に用いる矢板は、内                                             |
| 外水位差による浸透水の動水勾配を減少させ、樋門下部の土砂流動と洗掘に |
| よる土砂の吸出しを防止するために図8-17のように設けることが望ましい。 |
|                                                                      |
| 翼壁のU                                                              |
| 型断面（Aタイプ）、逆T型断面（Bタイプ）の形式は「8.6.3翼壁」による。 |
|                                                                      |
| ![](media/image125.png){width="3.7909722222222224in"                 |
| height="2.029861111111111in"}                                        |
|                                                                      |
| 74. 遮水工                                                           |
|                                                                      |
| ```{=html}                                                           |
| <!-- -->                                                             |
| ```                                                                  |
| 2.  構造                                                             |
|                                                                      |
| 遮水矢板は、本体と離脱しないように配慮し、水平方向に設ける遮         |
| 水矢板は必要に応じ屈とう性を有する構造として設計することが望ましい。 |
|                                                                      |
| 3.  鋼矢板を遮水工として用いる場合の留意点                           |
|                                                                      |
| 鋼矢板を遮水                                                         |
| 工として用いる場合、安全性、現場条件及び市場性を考慮したうえで、Ｕ形 |
| （普通型、広幅型等）、ハット型の経済比較を行い、適切に選定すること。 |
|                                                                      |
| 鋼矢                                                                 |
| 板の設置間隔が狭く、かつ鋼矢板が長い場合、鋼矢板間に地下水が回り込ま |
| ず、想定した浸透経路長が確保できない場合がある。そのため、遮水工の深 |
| さは2m程度以上、水平方向の長さは遮水壁及び胸壁から2m程度以上かつ開削 |
| 法面範囲までとし、函軸方向の設置間隔の1/2以下とすることが望ましい。  |
+----------------------------------------------------------------------+

＜例　示＞

  --------------------------------------------------------------------------------------------------------
  基礎地盤が良好な場合の直接基礎で鋼矢板の施工が困難な場合は、コンクリートのカットオフとする場合がある。
  --------------------------------------------------------------------------------------------------------

1.  []{#_Toc47014769 .anchor}基礎

＜考え方＞

+----------------------------------------------------------------------+
| 基礎は、函渠の構造特性及び地盤変位の影響に対応                       |
| できるものとし、樋門の機能を確保するとともに、樋門周辺の堤防が有すべ |
| き堤防機能を損なわない構造として設計する必要がある。すなわち、函渠自 |
| 体の変形がない場合に、函渠周辺の地盤が沈下すると函渠周りに空洞ができ |
| ることが多いため、周辺地盤の沈下とともに函渠が追随するような基礎とす |
| る必要がある。したがって、樋門の基礎は、基礎地盤の残留沈下量及び樋門 |
| の構造形式に応じた直接基礎とすることが一般的である。基礎は、残留沈下 |
| 量と函渠構造との関係より、地盤改良等を含めて経済性を考慮したものとす |
| る。なお、沈下抑制対策を行った場合に函渠部とその樋門周辺の堤防の沈下 |
| 量の差が大きくなる場合は、すり付けのための対策を考慮する必要がある。 |
|                                                                      |
| 樋門の構造形式は、基礎地盤の残留沈下量及び基礎の特性等を考慮して     |
| 選定を行い、杭（先端支持杭及び摩擦支持杭）基礎等の不同沈下により空洞 |
| 化が生じやすい基礎形式を避け、柔構造樋門として設計を行う必要がある。 |
|                                                                      |
| 函渠とその周辺地盤の一体性が十                                       |
| 分でなく、函体の直下に空洞が発生した場合、その対策として底版に設置し |
| たグラウトホールからグラウトを注入し空洞を充填することが有効である。 |
+----------------------------------------------------------------------+

＜必　須＞

  --------------------------------------------------------------------------------------------------------------------
  基礎は、函渠の構造特性、残留沈下量及び樋門周辺の堤防への影響を考慮し、設計荷重に対して安全な構造とするものとする。
  --------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 基礎は、函渠及び翼壁の下に同一の基礎で設けることを基本とする。       |
|                                                                      |
| 基礎の形式及び構造は、樋門周辺の堤防との不同沈下或い                 |
| は空洞化をできるだけ小さく留めるよう適切に選定することを基本とする。 |
|                                                                      |
| 函渠には、グラウトホールを設けることを基本とする。                   |
+----------------------------------------------------------------------+

＜推　奨＞

+----------------------------------------------------------------------+
| １）残留沈下量の抑制                                                 |
|                                                                      |
| 残留沈下量は、樋門の開閉性、水密性、函体の                           |
| 構造特性及び堤体に悪影響を及ぼさない範囲まで抑制することが望ましい。 |
| 残留沈下量が大きい場合は、地盤改良工法を併用し、スパン割、函体や継手 |
| の構造特性等に応じて残留沈下量を適切な範囲に抑制することが望ましい。 |
|                                                                      |
| 地盤の残留沈下量を抑制する地                                         |
| 盤改良工法としては、プレロード工法を優先的に検討することが望ましい。 |
|                                                                      |
| ２）空洞化対策                                                       |
|                                                                      |
| グラウトホールの設置間隔は                                           |
| 、過去の施工実績や試験施工、資機材規格（能力）等を踏まえた施工性によ |
| り、一般的に5m程度で設置されているが、遮水矢板の位置、グラウトの能力 |
| に応じて決定するのが望ましい。このグラウトホールを利用して、底版下地 |
| 盤に空洞測定用沈下板を設けることで空洞の発生を観測することができる。 |
|                                                                      |
| なお、グラウトの追跡調査により効果を検証することが望ましい。         |
+----------------------------------------------------------------------+

＜例　示＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------
  グラウトホールの設置間隔は、軟弱地盤（「ガタ土」と呼ばれる微細な粘土及び泥炭）上において試験施工を行い決定した事例や底面については2m程度とした事例がある。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1.  河川管理施設等構造令，昭和51年7月20日，政令第39号．

```{=html}
<!-- -->
```
52. （財）国土技術研究センター：[柔構造樋門設計の手引き（Ⅰ 共通編、Ⅱ
    基礎構造編）](http://www.jice.or.jp/tech/material/detail/3)，平成10年11月.

    1.  []{#_Toc47014770 .anchor}護床工

＜考え方＞

+----------------------------------------------------------------------+
| 護床工は、流速を弱め流水を整え、併せて流水による洗掘                 |
| 等から堤防や函渠、水叩きを保護するために翼壁前面に設ける必要がある。 |
|                                                                      |
| 護床工の構                                                           |
| 造は、水叩き下流で流水が減勢される区間では、鉄筋により連結されたブロ |
| ック構造又はコンクリート構造等とし、その下流の整流となる区間では、粗 |
| 朶沈床、木工沈床、改良沈床、コンクリート床版、コンクリートブロック等 |
| が用いられる。そのため、屈とう性を有する構造とし、硬い構造のものから |
| 漸次軟らかい構造のもので河床になじみよくするような配慮が必要である。 |
|                                                                      |
| 根固めブロックによる護床工の例を図8-18に示す。                       |
|                                                                      |
| ![](media/image126.png){width="3.5487937445319333in"                 |
| height="1.965378390201225in"}                                        |
|                                                                      |
| 75. 護床工（根固めブロックの例）                                     |
+----------------------------------------------------------------------+

＜必　須＞

  ----------------------------------------------------------------------------------------------------
  護床工は、必要な屈とう性を有する構造とし、設計荷重に対して安全な構造となるよう設計するものとする。
  ----------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 護床工は、樋門の吐口部及び吞                                         |
| 口部の流水による洗掘を防ぐため、翼壁の前面に設けることを基本とする。 |
|                                                                      |
| 護床工は、水叩きと河床との洗                                         |
| 掘を防ぐことができる長さ及び構造となるよう設計することを基本とする。 |
+----------------------------------------------------------------------+

1.  []{#_Toc47014771 .anchor}護岸

＜考え方＞

+----------------------------------------------------------------------+
| 護岸は                                                               |
| 、樋門の影響による流水の乱れ、高潮時及び風浪時の波浪、計画津波水位以 |
| 下の津波及び越波に対し堤防を保護するとともに、樋門及び樋門周辺の堤防 |
| が一連区間の中で相対的な弱点とならないように護岸を設ける必要がある。 |
|                                                                      |
| 樋門が横断                                                           |
| する河岸又は堤防に設ける護岸は、樋門の両端（胸壁又は翼壁のいずれか長 |
| い方の端部）から上流及び下流にそれぞれ10mの地点を結ぶ区間以上、堤防  |
| 天端での開削幅がカバーできる区間以上のいずれか大きい区間に設ける。既 |
| 設護岸と近接する場合は、その区間を空けずに連続させる必要がある。また |
| 、管理橋下の堤防の法面は、図8-19に示す範囲に護岸を設ける必要がある。 |
|                                                                      |
| 護岸の形式及び構造は、「改訂                                         |
| 護岸の力学設計法**」**を参考に設定する必要がある。                   |
|                                                                      |
| ![](media/image127.png){width="3.882143482064742in"                  |
| height="1.729255249343832in"}                                        |
|                                                                      |
| 76. 樋門の護岸の例                                                   |
|                                                                      |
| 護岸には、多                                                         |
| くの形式があり、使用される素材、構造の外観等はさまざまであるが、設置 |
| 箇所の河道特性や周辺の護岸形式及び構造を踏まえて設計する必要がある。 |
+----------------------------------------------------------------------+

＜必　須＞

  ------------------------------------------------------------------------------------------------------------------------
  護岸は、流水の変化に伴う河岸又は堤防の洗掘を防止する構造とし、設計荷重に対して安全な構造となるよう設計するものとする。
  ------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 護岸は、流水等の作用によ                                             |
| り、堤防又は河岸を保護するため、適切な範囲に設けることを基本とする。 |
|                                                                      |
| 護岸の形式及び構造は、設置箇所の河道                                 |
| 特性及び樋門周辺の堤防環境を考慮し、適切に設定することを基本とする。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  （財）国土技術研究センター：改訂 護岸の力学設計法, 平成 19 年 9 月.

    （最新版）（一財）国土技術研究センター：[改訂
    護岸の力学設計法](https://www.jice.or.jp/cms/kokudo/pdf/tech/material/gogan.pdf)，2023.

    1.  []{#_Toc47014772 .anchor}取付水路

＜考え方＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  取付水路によって高水敷が上下流に分断されることにより、その一体的利用が損なわれないように、取付水路の横断や親水性等に配慮する必要がある。堤防への影響を最小限に留めるように、川表の取付水路は、翼壁前面から低水路に向かって、川裏は支川水路との取付部に、堤防法線に直角に設ける必要がある。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜必　須＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  取付水路は、樋門の円滑な取水機能及び排水機能を満足するとともに、設計荷重に対して安全な構造となるよう設計するものとする。なお、高水敷の河川横断方向に設ける樋門の取付水路については、工作物設置許可基準第十を参照する。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

  --------------------------------------------------------------------------------------------
  取付水路は、堤防に及ぼす影響を最小限に留めるよう、堤防法線に直角に設けることを基本とする。
  --------------------------------------------------------------------------------------------

＜推　奨＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  支川の河床又は敷高と本川の河床とに落差があるなどの状況により、内水位が本川水位より高くなる場合には、樋門と堤体との接触面に沿って内水が堤外に浸透することがある。この場合、長年の間に樋門と堤体との接触面付近に大きな空隙が生じ、洪水時に突然堤防決壊を引き起こすこともある。したがって、このような場合には、内水が堤外に浸透することについても十分留意する必要があり、支川の取付護岸は必要な区間に対して遮水シートを有するコンクリート護岸等とするとともに、翼壁の接続部の水密性を保つようにすることが望ましい。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1.  河川管理技術研究会編：[改訂
    解説・工作物設置許可基準](http://www.jice.or.jp/cms/kokudo/pdf/tech/material/kousakubutusecchi.pdf)，（財）国土技術研究センター，平成10年．

    1.  []{#_Toc47014773 .anchor}高水敷保護工

＜考え方＞

+----------------------------------------------------------------------+
| 高水敷保護工は、樋門の翼壁部分又                                     |
| は取付水路によって上下流に不連続となり、一般にその部分で乱流が起こり |
| 、洗掘を受けやすいので、必要な範囲に高水敷保護工を設ける必要がある。 |
|                                                                      |
| 高水敷保護工の構造は、一般には、カゴマット、連節ブロック等を用い     |
| て流水の作用による高水敷の洗掘を防止するものとし、かつ、周辺景観との |
| 調和、河川の生態系の保全等の河川環境に配慮して覆土を行う必要がある。 |
|                                                                      |
| 取付水路の保護工は                                                   |
| 、取付水路の範囲に周辺護岸や高水敷の利用を踏まえて設ける必要がある。 |
+----------------------------------------------------------------------+

＜必　須＞

  ----------------------------------------------------------------------------------------------------------
  高水敷保護工は、高水敷の洗掘を防止する構造とし、設計荷重に対して安全な構造となるよう設計するものとする。
  ----------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 高水敷保護工は、流水等の作用による高水敷の洗                         |
| 掘を防止するため、必要に応じて高水護岸前面に設けることを基本とする。 |
|                                                                      |
| 高水敷                                                               |
| 保護工は、河川の生態系の保全等の河川環境に配慮した構造を基本とする。 |
|                                                                      |
| 高水敷保護工は、「8.6.8                                              |
| 護岸**」**で示す護岸の範囲において設けることを基本とする。           |
+----------------------------------------------------------------------+

2.  []{#_Toc40775265 .anchor}付属施設

＜考え方＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  付属施設には、操作室、樋門操作員待機場、管理橋、管理用階段、照明設備、水位観測施設、船舶通航用の信号、繋船環、防護柵等があり、ゲート操作のための水位把握、操作員等の安全確保、維持管理に必要な施設を設ける必要がある。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

  ----------------------------------------------------------------------------------
  樋門には、維持管理及び操作のため、必要に応じて付属施設を設けることを基本とする。
  ----------------------------------------------------------------------------------

＜関連通知等＞

1.  （公社）日本道路協会：道路橋示方書・同解説 Ⅰ．共通編，平成 24 年 3
    月．

    （最新版）（公社）日本道路協会：道路橋示方書・同解説Ⅰ．共通編，平成29年11月.

```{=html}
<!-- -->
```
53. 国土交通省：[ダム・堰施設技術基準（案）](https://www.mlit.go.jp/common/001126025.pdf)，平成28年3月.

    1.  []{#_Toc54772925 .anchor}既存施設の自動化・遠隔化

＜考え方＞

+----------------------------------------------------------------------+
| 新設の樋門のゲートの操作の                                           |
| ための設備については、必要に応じて自動化、遠方操作化や遠隔操作化を検 |
| 討することとしているが、既存の樋門のゲートの操作のための設備について |
| も、樋門の目的、規模、操作員の負担軽減や安全の確保等の管理体制を踏ま |
| え、必要に応じて自動化、遠方操作化や遠隔操作化を検討することとする。 |
|                                                                      |
| 自動化は、計測した水位に応じ                                         |
| て自動で開閉操作を行うことができるように改造することや、ゲート自体を |
| フラップゲート等自動開閉が可能なものとすることであり、遠方操作化、遠 |
| 隔操作化は、管理所や遠隔地から操作を行うことを可能とすることである。 |
+----------------------------------------------------------------------+

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------
  既存の樋門のゲートの操作のための設備については、必要に応じて自動化、遠方操作化や遠隔操作化を検討することを基本とする。
  ------------------------------------------------------------------------------------------------------------------------

1.  []{#_Toc47014775 .anchor}樋門構造に関するその他の事項

＜考え方＞

+----------------------------------------------------------------------+
| １）現況施設の能力を上回る事象に対する対応について                   |
|                                                                      |
| 現況施設能力を上回る洪水の生起により計                               |
| 画高水位を超えるような事象が頻発しており、今後の気候変動の影響によっ |
| ては、このような事象が更に増えることも考えられる。そのため施設能力を |
| 上回る外力に対し、「構造上の工夫」により減災を図ることが求められる。 |
|                                                                      |
| ２）気候変動を踏まえた施設設計について                               |
|                                                                      |
| 今後、気                                                             |
| 候変動により外力が更に増加する可能性があることにも留意する必要がある |
| 。そのため、外力の増加への対応として、大規模な改良とならないよう補強 |
| しやすい構造とする又は、あらかじめ対策を施すなどの設計が求められる。 |
|                                                                      |
| ３）ICTやBIM/CIMの利用                                               |
|                                                                      |
| i-Construction推進の一環として、ICTによる建設生産プロセスのシ        |
| ームレス化が取り組まれている。UAV写真測量やレーザースキャナー計測な  |
| どで得られる3次元点群データを活用することで、現況地形や既設物の構造  |
| を様々な角度・断面から把握することができる。新設・改修する施設の3次  |
| 元モデルを作成し活用することにより、構造に関して関係者の理解と合意形 |
| 成が促進される。このため、計画段階など事業の早期段階をはじめ、施工段 |
| 階、施工後の点検・補修・修繕の段階においてBIM/CIMを積極的に活用し、  |
| 樋門本体及び樋門周辺の堤防を適切に維持管理していくことが求められる。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  国土交通省：CIM 導入推進委員会：CIM 導入ガイドライン（案），令和 2
    年 3 月.

    （最新版）国土交通省：[BIM/CIM
    活用ガイドライン（案）](https://mlit.go.jp/tec/tec_tk_000064.html)，令和
    4 年 3 月.

第1章　河川構造物の設計 {#第1章-河川構造物の設計-6 .目次の見出し1}
=======================

第9節　水門 {#第9節-水門 .目次の見出し1}
===========

目　次 {#目-次-5 .目次の見出し1}
======

[第9節 水門 1](#_Toc47014719)

> [9．1 総説 1](#_Toc47014720)
>
> [9．1．1 適用範囲 1](#_Toc47014721)
>
> [9．1．2 用語の定義 1](#_Toc47014722)
>
> [9．2 機能 2](#_Toc47014723)
>
> [9．3 設計の基本 2](#_Toc54776099)
>
> [9．4 基本的な構造 5](#_Toc47014725)
>
> [9．4．1 水門の断面幅及び径間長の設定 5](#_Toc47014726)
>
> [9．4．2 ゲート開閉時の高さの設定 7](#_Toc47014727)
>
> [9．4．3 門柱の天端高 8](#_Toc47014728)
>
> [9．4．4 材質と構造 9](#_Toc47014729)
>
> [9．4．5 水門周辺の堤防 12](#_Toc65850220)
>
> [9．5 安全性能の照査等 13](#_Toc47014731)
>
> [9．5．1 設計の対象とする状況と作用 13](#_Toc47014732)
>
> [9．5．2 安全性能の照査 22](#_Toc47014733)
>
> [9．5．3 許容応力度 26](#_Toc65850224)
>
> [9．6 各部位の設計等 28](#_Toc54776110)
>
> [9．6．1 本体 28](#_Toc54776111)
>
> [9．6．2 胸壁 35](#_Toc47014737)
>
> [9．6．3 翼壁 35](#_Toc47014738)
>
> [9．6．4 水叩き 36](#_Toc54776114)
>
> [9．6．5 遮水工 37](#_Toc47014740)
>
> [9．6．6 基礎 38](#_Toc47014741)
>
> [9．6．7 護床工 39](#_Toc47014742)
>
> [9．6．8 護岸 39](#_Toc47014743)
>
> [9．6．9 高水敷保護工 40](#_Toc47014744)
>
> [9．6．10 付属施設 41](#_Toc47014745)
>
> [9．6．11 既存施設の自動化・遠隔化 42](#_Toc54776121)
>
> [9．7 水門構造に関するその他事項 42](#_Toc47014746)

令和3年4月　版

適用上の位置付け

　河川砂防技術基準設計編は、基準の適用上の位置付けを明確にするために、下表に示すように適用上の位置付けを分類している。

+--------+------------------+------------------+------------------+
| 分　類 | 適用上の位置付け | 末尾の字句例     |                  |
+--------+------------------+------------------+------------------+
| 考え方 | 技術資料         | ●目              | 「･･･ある。      |
|        |                  | 的や概念、考え方 | 」「･･･いる。」  |
|        |                  | を記述した事項。 |                  |
|        |                  |                  | 「･･･なる。      |
|        |                  |                  | 」「･･･れる。」  |
+--------+------------------+------------------+------------------+
| 必　須 | 技術基準         | ●法令による規定  | 「･･･なければ    |
|        |                  | や技術的観点から | ならない。」「･  |
|        |                  | 実施すべきである | ･･ものとする。」 |
|        |                  | ことが明確であり |                  |
|        |                  | 遵守すべき事項。 |                  |
+--------+------------------+------------------+------------------+
| 標　準 | 技術基準         | ●特              | 「･･･            |
|        |                  | 段の事情がない限 | を標準とする。」 |
|        |                  | り記述に従い実施 |                  |
|        |                  | すべきだが、状況 | 「･･･            |
|        |                  | や条件によって一 | を基本とする。」 |
|        |                  | 律に適用すること |                  |
|        |                  | はできない事項。 | 「･･･による。」  |
+--------+------------------+------------------+------------------+
| 推　奨 | 技術資料         | ●状況や条件      | 「               |
|        |                  | によって実施する | ･･･望ましい。」  |
|        |                  | ことが良い事項。 |                  |
|        |                  |                  | 「               |
|        |                  |                  | ･･･推奨する。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･務める。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･必要に応    |
|        |                  |                  | じて･･･する。」  |
+--------+------------------+------------------+------------------+
| 例　示 | 技術資料         | ●適用条件や実施  | 「               |
|        |                  | 効果について確定 | ･･･などの手法（  |
|        |                  | している段階では | 事例）がある。」 |
|        |                  | ないが、状況や条 |                  |
|        |                  | 件によっては導入 | 「･･･など        |
|        |                  | することが可能な | の場合がある。」 |
|        |                  | 新技術等の例示。 |                  |
|        |                  |                  | 「･･･など        |
|        |                  | ●状              | が考えられる。」 |
|        |                  | 況や条件によって |                  |
|        |                  | 限定的に実施でき | 「               |
|        |                  | る技術等の例示。 | ･･･の場合には･･･ |
|        |                  |                  | ことができる。」 |
|        |                  | ●具体的          |                  |
|        |                  | に例示することに | 「               |
|        |                  | より、技術的な理 | ･･･例示する。」  |
|        |                  | 解を助ける事項。 |                  |
|        |                  |                  | 「例えば･･･。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･事例もある  |
|        |                  |                  | 。･･･もよい。」  |
+--------+------------------+------------------+------------------+

  関連通知等       関連する通知やそれを理解する上で参考となる資料
  ---------------- ------------------------------------------------------
  参考となる資料   例示等に示した手法・内容を理解する上で参考となる資料

9.  []{#_Toc47014719 .anchor}水門

    1.  []{#_Toc47014720 .anchor}総説

        1.  []{#_Toc47014721 .anchor}適用範囲

＜考え方＞

+----------------------------------------------------------------------+
| 本節は、水門を新設或いは改築する場合の                               |
| 設計に適用する。ただし、既設の水門の安全性能の照査にも構造形式や現地 |
| の状況等に応じ必要かつ適切な補正を行ったうえで準用することができる。 |
|                                                                      |
| 水門と堰との区別は、堤                                               |
| 防の機能を有しているかどうかで定まる。河口付近に河川を横断して設ける |
| 高潮の遡上を防止するための施設は、河口堰と外見はほとんど変わらなくて |
| も、水門（防潮水門）である。また、放水路等の分派点に設ける分流施設に |
| は、堰と称すべきものと水門と称すべきものがある。計画高水流量が流下す |
| るときにゲートを全閉する施設は水門、計画高水流量が流下するときに分流 |
| する施設は堰であり、水門と堰では河川管理施設等構造令の適用が異なる。 |
|                                                                      |
| また、当該施設の横断する河川又は水路が合流する河                     |
| 川（本川）の堤防を分断して設けるものは水門、堤体内に函渠を設けるもの |
| は樋門であり、水門と樋門とでは河川管理施設等構造令の適用が異なる。施 |
| 設の設置に当たっては、用途、施設規模、施工性、経済性等を考慮して水門 |
| と比較検討のうえ施設形式を決定する。通常、支川がセミバック堤（半背水 |
| 堤）の場合は水門を採用し、自己流堤の場合は樋門を採用することが多い。 |
+----------------------------------------------------------------------+

＜標　準＞

  --------------------------------------------------------
  本節は、水門を新設或いは改築する場合の設計に適用する。
  --------------------------------------------------------

＜関連通知等＞

1.  河川管理施設等構造令，昭和 51 年 7 月 20 日，政令第199号．

    1.  []{#_Toc47014722 .anchor}用語の定義

＜考え方＞

+----------------------------------------------------------------------+
| 水門は、本体と胸壁、翼壁、水叩き、遮水工、基礎及び操作室、管理橋     |
| 等の付属施設の構造各部位によって構成される。このうち、本体は、ゲート |
| 、床版、堰柱、門柱、ゲートの操作台で構成される。そのほか、水門の設置 |
| に伴い、一体で整備するものとして、護床工、護岸、高水敷保護工がある。 |
|                                                                      |
| 水門のゲートが引上式の場合の各部位の名称は、図9-1による。            |
|                                                                      |
| ![](media/image128.jpeg){width="4.40625in"                           |
| height="4.052083333333333in"}                                        |
|                                                                      |
| 77. 水門の各部位の名称（ゲートが引上式ゲートの場合）                 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 次の各号に掲げる用語の定義は、それぞれ以下に示す。                   |
|                                                                      |
| > 一．径間長：隣り合う堰柱の中心間距離                               |
| >                                                                    |
| >                                                                    |
| 二．カーテンウォール：ゲートと一体となって堤防の機能を発揮する止水壁 |
| >                                                                    |
| > 三．水門周辺の堤防：水門の周辺の堤防                               |
| で、水門本体との取り付けに伴う開削や杭基礎等の施工の影響を受ける範囲 |
+----------------------------------------------------------------------+

1.  []{#_Toc47014723 .anchor}機能

＜考え方＞

  ----------------------------------------------------------------------------------
  水門は、堤防機能及び設置目的を達成するために必要な機能を有することが求められる。
  ----------------------------------------------------------------------------------

＜必　須＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  水門は、ゲートを全閉することにより、堤防機能を有するよう設計するとともに、ゲート全閉時以外において、当該施設の設置目的に応じて、取水機能、排水機能、舟を支障なく通行させる機能を有するよう設計するものとする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1.  河川管理施設等構造令，昭和 51 年 7 月 20 日，政令第199号．

    1.  []{#_Toc54776099 .anchor}設計の基本

＜考え方＞

+----------------------------------------------------------------------+
| 設計に当                                                             |
| たっては、以下の事項について検討し、設計に反映することが求められる。 |
|                                                                      |
| １）基本方針                                                         |
|                                                                      |
| 水門の設計に当たって                                                 |
| は、水門が河川（本川）の堤防を分断して設ける施設であること及び「9.2  |
| 機能」に示す事項を踏まえ、水門の                                     |
| 安全性のみならず、水門周辺の堤防の安全性の確保も重要である。このため |
| 、水門の設置に当たっては、水門周辺の堤防が一連区間の中で相対的な弱点 |
| とならないよう、水門の構造及び施工についても十分考慮する必要がある。 |
|                                                                      |
| また、周辺の河川環境との調和を図り、環境保全に配慮すると             |
| ともに、地域の水環境及び景観が損なわれないように配慮する必要がある。 |
|                                                                      |
| ２）水門の位置                                                       |
|                                                                      |
| 水門の位置は、「計画編 施設配置等計画編 第2章 河川施設配置計画       |
| 第2-1章 河道並びに河川構造物 第5節 堰、水門、樋門 5.1                |
| 設置の基本」を踏まえ、堤内地の地形、地盤高、水路系統、水路敷         |
| 高及び洪水時の本川の特性等を調査し、本川の湾曲部、水衝部、河床の不安 |
| 定な箇所、既設の水門に近接した箇所、基礎地盤が軟弱な箇所、堤防又は基 |
| 礎地盤に漏水履歴がある箇所を避けて計画するとともに、排出水の水質等に |
| より他の利水施設及び周辺環境に支障を及ぼさない地点とする必要がある。 |
|                                                                      |
| ３）水門の敷高                                                       |
|                                                                      |
| 水門の敷高は、排水を目的と                                           |
| するものにあっては、接続する河川の河床高又は水路の敷高を考慮し、取水 |
| を目的とするものにあっては、それぞれの取水目的に応じて定めるが、本川 |
| の将来の河床変動についても配慮する必要がある。また、舟の通行を目的と |
| するものにあっては、舟の通行に支障を及ぼさない敷高とする必要がある。 |
|                                                                      |
| ４）構造形式                                                         |
|                                                                      |
| 水門においては、地震時に堤体との接触面である程度の空                 |
| 隙が生じることは避けられない。また、水門と堤体では重量差があり、地盤 |
| に伝わる荷重が異なるため、水門の沈下と堤防の沈下とは一般に差異がある |
| が、このことによっても水門と堤体との接触面には空隙が生じることがある |
| 。水門と堤体との接触面に空隙が生じると、それが原因となって、漏水や堤 |
| 体を構成する土粒子の移動が起こりやすく、これらの作用が繰り返され、空 |
| 隙が拡大・進展し、連続した大きな空洞が形成される。これらの現象は、水 |
| 門の基礎が杭基礎である場合や、水門に接続する堤防並びに基礎地盤の土質 |
| 条件が軟弱な場合に特に顕著である。このため、水門の構造形式は、堤防の |
| 一連区間の中で相対的な弱点とならない構造として設計を行う必要がある。 |
|                                                                      |
| ５）ゲート設備                                                       |
|                                                                      |
| ゲート設備の設計に当たっては、ゲートは、確実                         |
| に開閉し、かつ、必要な水密性及び耐久性を有する構造が求められ、開閉装 |
| 置は、ゲートの開閉を確実にできる構造が求められる。また、常用電源が喪 |
| 失した場合に備え、予備動力や急降下閉鎖装置等を設けるなど、必要最小限 |
| な機能を維持できることが求められる。なお、想定外の外力が働いた場合に |
| おいても、必要なゲート操作は可能となるように配慮することが望ましい。 |
|                                                                      |
| ６)安全、確実・円滑な施工                                            |
|                                                                      |
| 水門の施工                                                           |
| では、掘削中のボイリングや重機の転倒など、安全を脅かす状況が発生する |
| 可能性がある。このため、設計においても、安全で確実・円滑な施工が可能 |
| となるような配慮が求められ、施工上の制約から構造が決まることもある。 |
|                                                                      |
| ７)機能を長期的に容易に維持できる構造                                |
|                                                                      |
| 長期的に機能を低下させる要因としては、圧密による地                   |
| 盤変位の進行、河床変動や土砂堆積があり、これらに配慮する必要がある。 |
|                                                                      |
| ８）維持管理に配慮した構造                                           |
|                                                                      |
| 水門の点検                                                           |
| 、修繕、更新等の作業を容易に行うため、維持管理に配慮する必要がある。 |
+----------------------------------------------------------------------+

＜必　須＞

+----------------------------------------------------------------------+
| 設計に当たっては、以下の事項を反映するものとする。                   |
|                                                                      |
| 14. 水門は、計画高水位（高潮区間にあっては、計画高                   |
| 潮位）以下の水位の流水の作用に対して安全な構造となるよう設計するもの |
| とする。また、高規格堤防設置区間及び当該区間に係る背水区間における水 |
| 門にあっては、前述の規定によるほか、高規格堤防設計水位以下の水位の流 |
| 水の作用に対して耐えることができる構造となるよう設計するものとする。 |
|                                                                      |
| 15. 水門は、計画高水                                                 |
| 位以下の水位の洪水の流下を妨げることなく、周辺の河岸及び河川管理施設 |
| の構造に著しい支障を及ぼさず、並びに水門に接続する河床及び高水敷等の |
| 洗掘の防止について適切に配慮された構造となるよう設計するものとする。 |
|                                                                      |
| 16. 水門は、水門周辺                                                 |
| との空洞化をできるだけ小さく留める構造となるよう設計するものとする。 |
|                                                                      |
| 17. 水門は、常用電源が喪失し                                         |
| た場合においても必要最小限な開閉操作をできるよう設計するものとする。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 1.  設計に当たっては、水門に求められる機能を満足するよ               |
| うに水門の位置、構造形式を設定するとともに、設計の対象とする状況と作 |
| 用に応じた安全性能を設定し、照査によりこれを満足することを確認する。 |
|                                                                      |
| ```{=html}                                                           |
| <!-- -->                                                             |
| ```                                                                  |
| 18. 環境及び景観と                                                   |
| の調和、構造物の耐久性、維持管理の容易性、施工性、事業実施による地域 |
| への影響、経済性及び公衆の利用等を総合的に考慮することを基本とする。 |
|                                                                      |
| 19. 水門は、水門に求められる機能を満足                               |
| するために、土砂が堆積しにくい構造となるよう設計するとともに、維持管 |
| 理上、堆積土砂等の排除に支障のない構造となるよう設計するものとする。 |
+----------------------------------------------------------------------+

＜推　奨＞

+----------------------------------------------------------------------+
| 1.  事前の地盤                                                       |
| 調査は、土層構成、土質、地下水の状況などを把握し、設計に必要な地盤性 |
| 状及び土層の特性等の条件を設定するため、ボーリング調査・現位置試験及 |
| び室内土質試験の組合せで実施することが望ましい。なお、事前の地盤調査 |
| 結果より軟弱地盤や透水性地盤が想定される場合には、各々の課題に対応し |
| た原位置試験等の調査・試験を実施したうえで設計に反映するよう努める。 |
|                                                                      |
| ```{=html}                                                           |
| <!-- -->                                                             |
| ```                                                                  |
| 20. 水門が横断する河川の河床又は水路の敷高と本川の河床               |
| とに落差があるなどの状況により、内水位が本川水位より高くなる場合には |
| 、水門と堤体との接触面に沿って内水が堤外に浸透することがある。この場 |
| 合、長年の間に水門と堤体との接触面付近に大きな空隙が生じ、洪水時に突 |
| 然堤防決壊を引き起こすこともある。したがって、このような場合には、内 |
| 水が堤外に浸透することについても十分留意する必要があり、堤内側の河川 |
| 又は水路の取付護岸は必要な区間に遮水シートを有するコンクリート護岸等 |
| とするとともに、翼壁の接続部の水密性を保つようにすることが望ましい。 |
|                                                                      |
| 21. 排                                                               |
| 水のための水門を設ける場合で、水門から合流する河川（本川）までの間で |
| 段差等が生じており、魚類等の移動のため必要があるときは、当該河川及び |
| その接続する水路の状況等（必要な場合には関係者の意見を含む）を踏まえ |
| 、段差等の緩傾斜化、水深の確保等に配慮した構造とすることが望ましい。 |
+----------------------------------------------------------------------+

＜例　示＞

+----------------------------------------------------------------------+
| 水門の景観設計に当たっては、以下のような事例がある。                 |
|                                                                      |
| > ・高さの統                                                         |
| 一性（堤防高と水門高の一致）により周囲との一体感のある景観を形成し、 |
| 堰柱の高さと径間長のバランスがよく水門として機能美と風格を感じさせ、 |
| 重量感あふれるデザインで治水構造物として堅固なイメージを醸し出し、コ |
| ンクリート固有の造形美を有している事例として、荒川の岩淵水門がある。 |
| >                                                                    |
| > ・                                                                 |
| 施設の老朽化に伴う改築事業において、旧施設の老朽化の状況、土木史的な |
| 価値等について調査し、脇谷水門・鴇波水門、締切堤及び水路の複数の施設 |
| からなる空間全体をシステムとして捉え、歴史的土木施設の保存と共存する |
| 新施設のデザインを行った事例として、旧北上川分流施設群の改築がある。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  国土交通省：河川砂防技術基準 計画編，施設配置等計画編 第2章
    河川施設配置計画 第2-1章 河道並びに河川構造物 第5節 堰、水門、樋門
    5.1 設置の基本．

```{=html}
<!-- -->
```
3.  国土交通省：ダム・堰施設技術基準（案）の一部改定について，平成28年3月31日，国技電第72号，国総公第80号，国水環第140号，国水治第142号．

4.  国土交通省河川局：[「多自然川づくり」の推進について](http://www.mlit.go.jp/notice/noticedata/pdf/200704/00004847.pdf)，平成18年10月13日，国河環第38号，国河治第86号，国河防第370号．

5.  国土交通省河川局：[美しい河川景観の形成と保全の推進について](http://www.mlit.go.jp/notice/noticedata/pdf/200704/00004847.pdf)，平成18年10月19日，国河環第40号，国河治第94号，国河防第376号．

6.  国土交通省：国土政策技術総合研究所資料，[景観デザイン規範事例集（河川・海岸・港湾編）](http://www.nilim.go.jp/lab/bcg/siryou/tnn/tnn0434.htm)，平成20年3月．

    1.  []{#_Toc47014725 .anchor}基本的な構造

        1.  []{#_Toc47014726 .anchor}水門の断面幅及び径間長の設定

```{=html}
<!-- -->
```
41. 水門の断面幅

＜考え方＞

+----------------------------------------------------------------------+
| 水                                                                   |
| 門の断面幅は、支川の計画高水流量及び流下断面内の流速が接続する支川の |
| 流速に比べて著しく増減することがないよう適切なものとする必要がある。 |
|                                                                      |
| 排水                                                                 |
| を目的とする水門にあっては、支川の計画高水流量に十分対応した断面幅と |
| し、全開時の支川の流下能力が確保できていること及びゲート操作に支障を |
| 及ぼす土砂堆積が生じない敷高とする必要がある。また、取水を目的とする |
| 水門にあっては、取水計画上問題とならない範囲において対象渇水時におい |
| ても計画取水量が確保できる断面幅とする必要がある。舟の通行が見込まれ |
| る水門にあっては、舟の通行に支障を及ぼさない断面幅とする必要がある。 |
|                                                                      |
| また、土砂吐及び                                                     |
| 舟通しについては、それらの機能確保のため、流下断面内に設けざるを得な |
| い場合も多いが、それらを現状又は計画の流下断面内に設けることは、水門 |
| 上流部における洪水時の水位上昇、下流部における局所洗掘等を招き、洪水 |
| による被害（内水を含む）の危険性を増大させるおそれがある。したがって |
| 、土砂吐及び舟通しは、現状又は計画の流下断面内には設けてはならない。 |
+----------------------------------------------------------------------+

＜必　須＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  水門の断面幅は、計画高水流量（取水の用に供する水門にあっては計画取水量、舟の通行の用に供する水門にあっては計画高水流量及び通行すべき舟の規模）を計画高水位以下で流下させること、維持管理を勘案して設定するものとする。なお、河川（「準用河川」を含む）以外の水路が河川に合流する箇所において当該水路を横断して設ける水門について準用するものとする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 水門の断面幅は、次により設定することを基本とする。                   |
|                                                                      |
| 1.  水門のうち流水                                                   |
| を流下させるためのゲート及び門柱以外の部分は、流下断面（計画横断形が |
| 定められている場合には、当該計画横断形に係わる流下断面を含む）内に設 |
| けてはならない。ただし、山間狭窄部であることその他河川の状況、地形の |
| 状況等により治水上の支障がないと認められるとき、及び河床の状況により |
| 流下断面内に設けることがやむを得ないと認められる場合において、治水上 |
| の機能の確保のため適切と認められる措置を講ずるときはこの限りでない。 |
|                                                                      |
| ```{=html}                                                           |
| <!-- -->                                                             |
| ```                                                                  |
| 22. 取水を目的とする水門の断面幅は、取水計画上問題とな               |
| らない範囲において、対象水位時の計画取水量を確保できるように定める。 |
+----------------------------------------------------------------------+

＜推　奨＞

+----------------------------------------------------------------------+
| 支川において、本川の背水の影響を軽減する目的                         |
| で設ける水門の設置地点の断面幅は、次により設定することを基本とする。 |
|                                                                      |
| 1.  水門を設置                                                       |
| したときの支川の計画高水位以下の流下断面積が、水門を設置しないときの |
| 支川の計画高水位以下の流下断面積に比べ1.3倍以内の場合には、堤防の両  |
| 端部に位置する堰柱の内側を支川の計画高水位と堤防の交点の位置とする。 |
|                                                                      |
| ```{=html}                                                           |
| <!-- -->                                                             |
| ```                                                                  |
| 2.  上記の場合                                                       |
| において、流下断面積の比率が1.3倍以上となる場合は、1.3倍となるまで水 |
| 門の総幅員（純径間と中央堰柱の堰柱幅の総和）を縮小することができる。 |
|                                                                      |
|     ![](media/image129.png){width="3.465456036745407in"              |
|     height="1.277843394575678in"}                                    |
|                                                                      |
| ```{=html}                                                           |
| <!-- -->                                                             |
| ```                                                                  |
| 78. 水門の断面説明図（流下断面が1.3倍以内の場合）                    |
+----------------------------------------------------------------------+

42. 水門の径間長

＜考え方＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  水門の径間長は、河積の阻害を小さくするため、できるだけ大きくとり、堰柱の数を減ずることが重要である。また、堰柱によって流木等流下物の閉塞が生じ、それが原因で災害が発生することがないよう、できるだけ大きい径間長とする必要がある。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜必　須＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  水門の径間長は、水門が横断する河川又は水路を洪水時に流下する流木等流下物による閉塞を防止するため、構造令第49条及び第37条から第39条、施行規則第23条、施行規則第17条及び第19条に基づき適切な値を設定し、これを有するものとする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

1.  []{#_Toc47014727 .anchor}ゲート開閉時の高さの設定

```{=html}
<!-- -->
```
5.  ゲートの天端高

＜考え方＞

+----------------------------------------------------------------------+
| ゲートの天端高は、水門の有する堤防機能を確保するため、水             |
| 門に接続する堤防との高さの連続性を確保できるよう設定する必要がある。 |
|                                                                      |
| ゲート閉鎖時における上端の高さを接続する堤防の高さとした際に、ゲ     |
| ート製作費、開閉機等の費用が相当大きくなる場合は、これを避けることを |
| 目的にカーテンウォールを設ける場合がある。カーテンウォールは、洪水時 |
| 又は高潮時にゲートと一体となって堤防の機能を有することが求められる。 |
|                                                                      |
| ![](media/image130.png){width="3.9791666666666665in"                 |
| height="3.40625in"}                                                  |
|                                                                      |
| 79. 水門の断面説明図                                                 |
+----------------------------------------------------------------------+

＜必　須＞

+----------------------------------------------------------------------+
| 水門のゲートの閉鎖時における上端の高さ又は水門                       |
| のカーテンウォールの上端の高さは、水門に接続する堤防（現状又は計画堤 |
| 防高のいずれか高い方の堤防）の高さを下回らないものとするものとする。 |
|                                                                      |
| ただし、高潮区間において水門の背後地の状況                           |
| その他の特別の事情により治水上支障がないと認められるときは、水門の構 |
| 造、波高等を考慮して、計画高潮位以上の適切な高さとすることができる。 |
+----------------------------------------------------------------------+

43. 引上げ完了時のゲート下端高

＜考え方＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  水門は、引上げ式ゲートの最大引上げ時において河川の所定の流下能力を確保することが求められる。そのため、ゲート下端高は、計画高水位との間に洪水時における流木等流下物の浮上高等を考慮して、しかるべき空間が確保できるよう設定する必要があり、一般的には、現状又は計画堤防高のいずれか高い方に合わせる。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜必　須＞

+----------------------------------------------------------------------+
| 引上げ                                                               |
| 完了時のゲート下端高は、構造令及び施行規則に基づき定めるものとする。 |
|                                                                      |
| 1.                                                                   |
|   水門の引上げ式ゲートの最大引上げ時における下端の高さ及び水門のカー |
| テンウォールの下端の高さは、水門が横断する河川又は水路の計画高水位に |
| 余裕高を加えた高さ以上で、高潮区間においては計画高潮位を下回らず、そ |
| の他の区間においては当該地点における河川の両岸の堤防（現状又は計画堤 |
| 防高のいずれか高い方の堤防）の表法肩を結ぶ線の高さを下回らないものと |
| するものとする。ただし、治水上の支障がないと認められるときは、次に掲 |
| げる高さのうちいずれか高い方の高さ以上とすることができるものとする。 |
|                                                                      |
|     一　当該河川に背水が生                                           |
| じないとした場合に定めるべき計画高水位に、計画高水流量に応じ、構造令 |
|     第20条第１項の表の下欄に掲げる値を加えた高さ                     |
|                                                                      |
|     二　計画高水位 （高潮区間にあっては、計画高潮位）                |
|                                                                      |
| ```{=html}                                                           |
| <!-- -->                                                             |
| ```                                                                  |
| 23. 地盤沈下のおそれがある地域に設け                                 |
| る水門の引上げ式ゲートの最大引上げ時における下端の高さ及び水門のカー |
| テンウォールの下端の高さは、前項の規定によるほか、予測される地盤沈下 |
| 及び河川の状況を勘案して必要と認められる高さを下回らないものとする。 |
+----------------------------------------------------------------------+

＜推　奨＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  水門のゲートの引上げ完了時のゲート下端高及びカーテンウォールの下端高の決定に当たっては、舟の通行がある場合は、舟の通行に支障を及ぼさないような高さ、ただし、マスト等の高いプレジャーボート等が該当するときは、経済性、景観等の面から関係者との十分な調整や検討することが望ましい。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

1.  []{#_Toc47014728 .anchor}門柱の天端高

＜考え方＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  門柱は、主に引上げ式ゲートの開閉を行うために設け、ゲートの開閉が容易な構造とする必要がある。また、門柱の天端高は、ゲート引上げ時のゲート下端高が取水、排水、舟の通行に支障を及ぼさない高さを確保するとともに、ゲートの維持管理・更新のための戸溝からの取外し等に必要な高さを確保する必要がある。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 門柱                                                                 |
| は、流水の阻害にならないように計画高水位（高潮区間にあっては、計画高 |
| 潮位）が計画堤防法面に交わる点よりも天端側に設けることを基本とする。 |
|                                                                      |
| 門柱の天端高は、ゲート                                               |
| の全開時のゲート上端部にゲートの管理に必要な高さを加えた高さを確保し |
| 、管理橋の桁下高が計画堤防高以上となるよう設計することを基本とする。 |
+----------------------------------------------------------------------+

＜推　奨＞

+----------------------------------------------------------------------+
| ゲートの管理に必要な高さとしては、引上げ                             |
| 余裕高(1m程度）のほか滑車等の付属品の高さを考慮することが望ましい。  |
|                                                                      |
| ![](media/image131.png){width="2.1041666666666665in"                 |
| height="2.1666666666666665in"}                                       |
|                                                                      |
| 80. 門柱                                                             |
+----------------------------------------------------------------------+

＜例　示＞

  ----------------------------------------------------------------------------------------------------
  津波が想定される水門の場合、段波波高水位を考慮して門柱の高さ（操作台上面高）を決定する場合がある。
  ----------------------------------------------------------------------------------------------------

1.  []{#_Toc47014729 .anchor}材質と構造

＜考え方＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  使用材料は、設置目的に応じて要求される強度、施工性、耐久性、環境適合性等の性能を満足するための品質を有し、その性状が明らかなものでなければならない。このため、JIS等の公的な品質規格に適合し、その適用範囲が明らかな用途に対して使用することが望ましい。公的な品質規格がない材料の場合には、材料特性が水門に及ぼす影響を試験等によって確認するとともに、品質についてもJIS等の規格と同等であることを確認する必要がある。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

6.  使用材料

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------
  設置目的に応じて要求される強度、施工性、耐久性、環境適合性等の性能を満足するための品質を有し、その性状が明らかにされている材料を使用することを基本とする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

  --------------------------------------------------------------------------------------------------------------------------
  鉄筋コンクリート構造物（プレキャスト製品を除く）に用いるコンクリートの設計基準強度24N/mm^2^、鉄筋の材質SD345を推奨する。
  --------------------------------------------------------------------------------------------------------------------------

44. 主な構造

＜考え方＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  水門を構成する主な構造としては、床版、堰柱、門柱、胸壁、ゲートの操作台、カーテンウォールがあり、これらは、鉄筋コンクリート構造又はこれに準ずる構造とし、必要な安全性を確保する必要がある。また、水門の安全性を確保するため、床版、堰柱、門柱、胸壁、翼壁、水叩き、遮水工は、部材の安全性の確保と継手部の水密性の確保によって、全体として必要な水密性を有する構造となるよう設計する必要がある。ここで、必要な水密性を有するとは、部材の損傷や劣化、継ぎの開き等により水門周辺の堤防の土砂が吸い出されることのない状態を確保する意味であり、部材によっては多少の漏水が生じる状態は許容される。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜必　須＞

+----------------------------------------------------------------------+
| 床版、堰柱、門柱、胸壁、ゲートの操作台、カーテンウォールは、         |
| 鉄筋コンクリート構造又はこれに準ずる構造とする。床版、堰柱、門柱、胸 |
| 壁、翼壁、水叩き、遮水工は、部材の安全性と継手部の水密性の確保によっ |
| て、全体として必要な水密性を有する構造となるよう設計するものとする。 |
|                                                                      |
| ゲートは、鋼構造又はこれに準ずる構造とし、ゲートは確実に             |
| 開閉し、かつ、必要な水密性を有する構造となるよう設計するものとする。 |
|                                                                      |
| ゲートの開閉装置は、ゲ                                               |
| ートの開閉を確実に行うことができる構造となるよう設計するものとする。 |
|                                                                      |
| 大規模な水門のゲートについては、ダムのゲートに関する規定（           |
| 構造令第10条第1項から第3項、第11条及び第12条）を準用するものとする。 |
+----------------------------------------------------------------------+

＜推　奨＞

+----------------------------------------------------------------------+
| 水門の構造形式は、一般に次に示すものが用いられている（図9-5 参照）。 |
|                                                                      |
| ![](media/image132.png){width="3.9375in"                             |
| height="1.2708333333333333in"}                                       |
|                                                                      |
| 81. 水門の本体の形式                                                 |
|                                                                      |
| 水門の                                                               |
| 構造形式は、小規模なものは箱形、大規模なものは逆Ｔ形となり、中間のも |
| のはＵ形としている場合が多いが、構造形式の選定に当たっては、基礎地盤 |
| の良否、施工性（仮締切との関連）、事業費等も考慮することが望ましい。 |
|                                                                      |
| また、カーテンウォールは、洪水時又は高潮時に                         |
| ゲートと一体となって堤防の機能を有するものであり、カーテンウォールと |
| ゲートの間の水密性が確保できる構造となるように設計するのが望ましい。 |
+----------------------------------------------------------------------+

＜例　示＞

+----------------------------------------------------------------------+
| 本川の背水を軽減する目                                               |
| 的で設ける支川の水門において、支川の計画高水位が本川の計画高水位（高 |
| 潮区間にあっては、計画高潮位）と比較して相当低い場合等で舟の通行に影 |
| 響がない場合等においては、カーテンウォールを採用している事例がある。 |
|                                                                      |
| ゲートの鋼構造                                                       |
| に準ずる構造には、ステンレス製ゲート、アルミ製ゲート等の事例がある。 |
+----------------------------------------------------------------------+

45. 設計用定数

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------
  設計に用いる各種定数は、適切な安全性が確保できるよう、使用する材料の力学特性を考慮し、必要に応じて調査・試験を実施したうえで、設定することを基本する。
  --------------------------------------------------------------------------------------------------------------------------------------------------------

9.  ヤング率

＜標　準＞

  --------------------------------------------------------------------------------------------------
  設計に用いるヤング率は、使用する材料の特性や品質を考慮したうえで適切に設定することを基本とする。
  --------------------------------------------------------------------------------------------------

＜推　奨＞

+----------------------------------------------------------------------+
| ヤング率として、以下の値を用いることが望ましい。                     |
|                                                                      |
| 1\) ヤング係数                                                       |
|                                                                      |
| > ・コンクリートのヤング係数は、2.5×10^4^ N/mm^2^                    |
| >                                                                    |
| > ・鋼材のヤング係数は、2.0×10^5^ N/mm^2^                            |
|                                                                      |
| 2\) ヤング係数比                                                     |
|                                                                      |
| > ・許容応力度による設計を                                           |
| 行う場合の鉄筋コンクリート部材の応力度の計算に用いるヤング係数比は15 |
+----------------------------------------------------------------------+

10. 地盤に係る定数

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  ボーリング調査、サウンディング調査、現位置試験、室内土質試験を組合せた地盤調査（既往調査含む）や周辺の工事履歴、試験施工等に基づき総合的に判断し、施工条件等も十分に考慮したうえで、地盤に係る定数を設定することを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

+----------------------------------------------------------------------+
| 1\) 基礎底面と地盤との間の摩擦係数と付着力                           |
|                                                                      |
| 基礎底面                                                             |
| と地盤との間の摩擦係数と付着力として、以下の値を用いることができる。 |
|                                                                      |
| 51. 摩擦角と付着力                                                   |
|                                                                      |
|                                                                      |
|  条件               摩擦角φ*~B~*（摩擦係数tanφ*~B~*）   付着力C*~B~* |
|   -                                                                  |
| ----------------- ----------------------------------- -------------- |
|   土とコンクリート   φ*~B~*=2/3φ                         C*~B~*=0    |
|   岩とコンクリート   tanφ*~B~=0.6*                       C*~B~=0*    |
|   土と土又は岩と岩   φ*~B~=φ*                            C*~B~=*C    |
|                                                                      |
| た                                                                   |
| だし、φ：支持地盤のせん断抵抗角（度）、C:支持地盤の粘着力（kN/m^2^） |
|                                                                      |
| 2\) 地盤の許容鉛直支持力                                             |
|                                                                      |
| 地                                                                   |
| 盤の許容鉛直支持力は、荷重の偏心傾斜及び基礎の沈下量を考慮した地盤の |
| 極限支持力に対して、表9-2に示す安全率を確保していることが望ましい。  |
|                                                                      |
| 52. 安全率                                                           |
|                                                                      |
|   常　時   地震時   施工時                                           |
|   -------- -------- --------                                         |
|   3        2        2                                                |
|                                                                      |
| 荷重の偏心傾斜及び基礎の                                             |
| 沈下量を考慮した地盤の極限支持力は、次式により求めることができる。平 |
| 板載荷試験により求める場合には、載荷試験の結果により確認した地盤の粘 |
| 着力C,せん断抵抗角φを用いて以下の式に従って算出することが望ましい。  |
|                                                                      |
| ![](media/image98.png){width="3.780226377952756in"                   |
| height="4.1502055993000875in"}                                       |
+----------------------------------------------------------------------+

46. 鉄筋コンクリート部材の最小寸法

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------
  鉄筋コンクリートの部材の最小寸法は、耐久性、強度を有するために必要なかぶり及び施工性に配慮し設定することを基本とする。
  ------------------------------------------------------------------------------------------------------------------------

＜例　示＞

  ------------------------------------------------------------------------------------------------------------
  鉄筋コンクリートの部材の最小寸法は、施工性を重視し主鉄筋を内側に配置するため、0.4mが用いられる場合が多い。
  ------------------------------------------------------------------------------------------------------------

1.  []{#_Toc65850220 .anchor}水門周辺の堤防

＜考え方＞

  -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  水門周辺の堤防には、水門の施工による埋戻し部分も含まれる。その影響範囲は、対象とする事象によっても異なるが、堤防縦断方向に堤防高さの2〜3倍以上に及ぶ。「9.5安全性能の照査等**」**に当たっては、水門周辺の堤防が一連区間の中の弱点でないことが前提となっており、必要に応じて「第2節 堤防**」**に準じて安全性の照査を行い、前後区間と比較して相対的に安全性が低下しないように強化対策を行う必要がある。
  -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜必　須＞

  ------------------------------------------------------------------------------------
  水門周辺の堤防が一連区間と比較して相対的に弱点とならないように設計するものとする。
  ------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 水門周辺の堤防に用いる土質材料は、堤防に適したものを選定し、十分に   |
| 締固めを行うものとする。また、水門周辺の堤防の断面形状は、水門本体に |
| よる止むを得ない切り込みを除き、隣接する堤防の大きさ（堤防高、天端幅 |
| 、堤体幅）及び計画堤防の大きさを上回る大きさとすることを基本とする。 |
|                                                                      |
| 必要に応じて「第2節                                                  |
| 堤防**」**に準じて堤防の安全性照査を行い、一連区間                   |
| と比較して相対的に安全性が低下しないよう必要に応じて強化対策を行う。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  （財）国土技術研究センター：[河川土工マニュアル](http://www.jice.or.jp/tech/material/detail/11)，平成21年4月．

    1.  []{#_Toc47014731 .anchor}安全性能の照査等

        1.  []{#_Toc47014732 .anchor}設計の対象とする状況と作用

＜考え方＞

+----------------------------------------------------------------------+
| 水門の設計に当たっては、常時、洪水時、                               |
| 地震時、高潮時及び風浪時の安全性能を確保することが求められる。全ての |
| 水門について、常時、洪水時及び地震時、さらに高潮堤に設けられる水門は |
| 高潮時、湖岸堤に設けられる水門は風浪時についても照査する必要がある。 |
|                                                                      |
| 照査にあたっては、広域地                                             |
| 盤沈下量、基礎地盤の特性、維持管理に必要となる前提条件を設定する必要 |
| がある。なお、前提条件は、土質地質調査等に基づき設定する必要がある。 |
|                                                                      |
| 設計の対象とする作用について                                         |
| は、本体やゲート等の自重、計画高水位（高潮区間にあっては、計画高潮位 |
| ）以下の水圧、地震動として河川構造物の供用期間中に発生する確率が高い |
| 地震動、及び対象地点において現在から将来にわたって考えられる最大級の |
| 強さを持つ地震動、土圧、風の影響等の他、地震時には必要に応じて津波に |
| よる波圧、高潮時には波浪並びに風浪時には風浪による影響等が考えられ、 |
| 設計の対象とする水門の状況に応じて適切に組合せて設定する必要がある。 |
|                                                                      |
| なお、必要に応じて施工時についても安全性能の照査を行う。             |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 安全性能の照査に当たっては、                                         |
| 設計の対象とする状況と作用を次の表のように設定し、これを踏まえて照査 |
| 事項を設定することを基本とする。常時、洪水時及び地震時については全て |
| の水門において設定し、これに加えて、高潮区間の水門の場合には高潮時、 |
| 湖岸堤に設ける水門の場合には風浪時について設定することを基本とする。 |
|                                                                      |
| 取水や舟の通行等治水以外の設置目的を有する場合                       |
| には当該設置目的に応じた常時の作用を適切に設定することを基本とする。 |
|                                                                      |
| +------------+--------------------------------------------------+    |
| | 水門の状況 | 作用                                             |    |
| +============+==================================================+    |
| | 常時       | 自重（死荷重）、活                               |    |
| |            | 荷重、土圧、水圧、泥圧、揚圧力、風荷重、温度変化 |    |
| |            | の影響、コンクリートのクリープ及び乾燥収縮の影響 |    |
| |            | 、負の周辺摩擦力の影響、雪荷重、プレストレス力等 |    |
| +------------+--------------------------------------------------+    |
| | 洪水時     | 自重（死荷重）、活荷重                           |    |
| |            | 、土圧、泥圧、水圧^※^、揚圧力、風荷重、温度変化  |    |
| |            | の影響、コンクリートのクリープ及び乾燥収縮の影響 |    |
| |            | 、負の周辺摩擦力の影響、雪荷重、プレストレス力等 |    |
| |            |                                                  |    |
| |            | ※計画高水位、高潮区間にあっては計画高潮位        |    |
| +------------+--------------------------------------------------+    |
| | 高潮時     | 高潮位における波浪による波圧                     |    |
| +------------+--------------------------------------------------+    |
| | 風浪時     | 風浪による波圧                                   |    |
| +------------+--------------------------------------------------+    |
| | 地震時     | 自重（死荷重）、地震動、活荷                     |    |
| |            | 重、水圧、揚圧力、温度変化の影響、負の周辺摩擦力 |    |
| |            | の影響、地震の影響^※^、雪荷重、プレストレス力等  |    |
| |            |                                                  |    |
| |            | ※地震時土圧、地震時動水圧、液状化の影響          |    |
| +------------+--------------------------------------------------+    |
| | その他     | 津波による波圧                                   |    |
| |            |                                                  |    |
| |            | 副振動、セイシュによる影響                       |    |
| |            |                                                  |    |
| |            | 施工時荷重                                       |    |
| |            |                                                  |    |
| |            | 流木の衝突                                       |    |
| |            |                                                  |    |
| |            | 舟の衝突                                         |    |
| +------------+--------------------------------------------------+    |
|                                                                      |
| 高規格堤防設置                                                       |
| 区間及び当該区間の背水区間の水門の照査に当たっては、計画高水位での静 |
| 水圧を高規格堤防設計水位での静水圧に置き換えて行うことを基本とする。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  国土交通省：[ダム・堰施設技術基準（案）](https://www.mlit.go.jp/common/001126025.pdf)，平成28年3月．

```{=html}
<!-- -->
```
54. 国土交通省水管理・国土保全局：[河川構造物の耐震性能照査指針・解説―Ⅰ．共通編―](https://www.mlit.go.jp/river/shishin_guideline/bousai/wf_environment/structure/index3.html)，平成24年2月．

55. 国土交通省水管理・国土保全局：[河川構造物の耐震性能照査指針・解説―Ⅳ．水門・樋門及び堰編―](https://www.mlit.go.jp/river/shishin_guideline/bousai/wf_environment/structure/index3.html)，令和2年2月（令和2年6月一部追記）．

56. 国土交通省水管理・国土保全局河川計画課長、治水課長：[河川津波対策について，平成23
    年 9 月 2
    日](https://www.mlit.go.jp/river/shishin_guideline/kasen/pdf/kasen_tsunami_taisaku_h230902.pdf)，国水計第
    20 号，国水治第 35 号．

＜推　奨＞

+----------------------------------------------------------------------+
| 水門の設計に当たっては、次の作用を考慮するのが望ましい。             |
|                                                                      |
| １）自重（死荷重）                                                   |
|                                                                      |
| 自重（死荷重）は、適切な単位体積重量を用いて算出する。               |
|                                                                      |
| 材料の単位体積重量は、表9-3、表9-4の値を参考に定めるものとする。     |
|                                                                      |
| 土の単位体積重量は、一般的な値を示したものであ                       |
| り、土質試験データがある場合は、その値を用いて設計することが望ましい |
| 。コンクリートについても、できるだけ試験データによることが望ましい。 |
|                                                                      |
| 53. 土の湿潤単位体積重量(kN/m^3^)                                    |
|                                                                      |
|   地盤       土　質       緩いもの   密なもの                        |
|   ---------- ------------ ---------- ----------                      |
|   自然地盤   砂及び砂礫   18         20                              |
|              砂質土       17         19                              |
|              粘性土       14         18                              |
|   盛土       砂及び砂礫   20                                         |
|              砂質土       19                                         |
|              粘性土       18                                         |
|                                                                      |
| 地下水位以下にある土                                                 |
| の単位体積重量は、それぞれの表中の値から9を差し引いた値としてよい。  |
|                                                                      |
| 地下水位は施工後における水位の平均値を考える。                       |
|                                                                      |
| 54. 材料の単位体積重量(kN/m^3^)                                      |
|                                                                      |
| +----------------------------------------------+--------------+      |
| | 材料                                         | 単位体積重量 |      |
| +==============================================+==============+      |
| | 鋼・鋳鋼・鍛鋼                               | 77.0         |      |
| +----------------------------------------------+--------------+      |
| | 鋳鉄                                         | 71.0         |      |
| +----------------------------------------------+--------------+      |
| | アルミニウム                                 | 27.5         |      |
| +----------------------------------------------+--------------+      |
| | 鉄筋コンクリート                             | 24.5         |      |
| +----------------------------------------------+--------------+      |
| | プレストレスを導入するコンクリート           | 24.5         |      |
| |                                              |              |      |
| | （設計基準強度60N/mm^2^以下）                |              |      |
| +----------------------------------------------+--------------+      |
| | プレストレスを導入するコンクリート           | 25.0         |      |
| |                                              |              |      |
| | （設計基準強度60N/mm^2^を超え80N/mm^2^まで） |              |      |
| +----------------------------------------------+--------------+      |
| | コンクリート                                 | 23.0         |      |
| +----------------------------------------------+--------------+      |
| | セメントモルタル                             | 21.0         |      |
| +----------------------------------------------+--------------+      |
| | 木材                                         | 8.0          |      |
| +----------------------------------------------+--------------+      |
| | 歴青材（防水用）                             | 11.0         |      |
| +----------------------------------------------+--------------+      |
| | アスファルト舗装                             | 22.5         |      |
| +----------------------------------------------+--------------+      |
|                                                                      |
| ２）活荷重                                                           |
|                                                                      |
| 活荷重は、自動車荷重及び群衆荷重とする。                             |
|                                                                      |
| 自動車荷                                                             |
| 重は必要に応じ、大型の自動車の交通状況に応じてTL-25荷重を考慮する。  |
|                                                                      |
| 群衆荷重は、管理橋及び操作台等に3.5kN/m^2^の等分布荷重を考慮する。   |
|                                                                      |
| ３）土圧                                                             |
|                                                                      |
| 4.  胸壁・翼壁に作用する土圧                                         |
|                                                                      |
| > 胸壁･翼壁に作用する土圧は、原則として表9-5の区分に従って適用する。 |
|                                                                      |
| 55. 土圧の区分                                                       |
|                                                                      |
|   種　　別   常　時         地震時                                   |
|   ---------- -------------- ---------------- ----------------        |
|   胸壁       静止土圧       地震時主働土圧                           |
|   翼壁       Ｕ形タイプ     静止土圧         地震時静止土圧          |
|              逆Ｔ形タイプ   主働土圧         地震時主働土圧          |
|                                                                      |
| a)　静止土圧                                                         |
|                                                                      |
| > 胸壁・翼壁に作用する静止土圧は、次式による。                       |
| >                                                                    |
| > *P~hd~*＝*K~0~*(*γ・h*＋*q~0~*)                                    |
|                                                                      |
| ここに                                                               |
|                                                                      |
| > *P~hd\ ~*：任意の深さの水平土圧強度(kN/ｍ^2^ )                     |
| >                                                                    |
| > *K~0\ ~*：静止土庄係数(通常は*K~0~*＝0.5と考えてよい)              |
| >                                                                    |
| > *γ* ：土の単位体積重量(kN/ｍ^3^ )                                  |
| >                                                                    |
| > *h* ：任意の深さ(ｍ)                                               |
| >                                                                    |
| > *q~0\ ~*：上載荷重(kN/ｍ^2^ )                                      |
|                                                                      |
| b)　主働土圧                                                         |
|                                                                      |
| > 主働土圧は、次式による。                                           |
| >                                                                    |
| > *P~a~*＝*K~A~*(*γ*・*h*＋*q~0~*)                                   |
|                                                                      |
| $$                                                                   |
| K_{A} = \frac{\cos^{2}\left( \varnothing - \theta \right)}{\cos^{2}{ |
| \theta \bullet \cos{\left( \theta + \delta \right)\left\lbrack 1 + \ |
| sqrt{\frac{\sin{\left( \varnothing + \delta \right) \bullet \sin\lef |
| t( \varnothing - \alpha \right)}}{\cos\left( \theta + \delta \right) |
|  \bullet \cos\left( \theta - \alpha \right)}} \right\rbrack^{2}}}}$$ |
|                                                                      |
| $$\cot\left( \xi A - \alpha \ri                                      |
| ght) = - \tan\left( \varnothing + \delta + \theta - \alpha \right)$$ |
|                                                                      |
| $$+ \sec\left( \varnothing + \delta + \                              |
| theta - \alpha \right)\sqrt{\frac{\cos\left( \theta + \delta \right) |
|  \bullet \sin\left( \varnothing + \delta \right)}{\cos\left( \theta  |
| - \alpha \right) \bullet \sin\left( \varnothing - \alpha \right)}}$$ |
|                                                                      |
| ここに                                                               |
|                                                                      |
| > *P~a\ ~*：任意の深さの主働土圧強度(kN/ｍ^2^)                       |
| >                                                                    |
| > *K~A\ ~*：主働土圧係数                                             |
| >                                                                    |
| > *ξ~A\ ~*：主働崩壊角(度)                                           |
| >                                                                    |
| > *γ* ：土の単位体積重量(kN/ｍ^3^)                                   |
| >                                                                    |
| > *h* ：任意の深さ(ｍ)                                               |
| >                                                                    |
| > *q~0\ ~*：上載荷量(kN/ｍ^2^)                                       |
| >                                                                    |
| > *α* ：地表面と水平面のなす角(度)                                   |
| >                                                                    |
| > *θ* ：壁背面と鉛直面のなす角(度)                                   |
| >                                                                    |
| > *φ* ：土の内部摩擦角(度)                                           |
| >                                                                    |
| > *δ* ：土圧作用面の種別に応じた壁面摩擦角(度)                       |
| >                                                                    |
| > 土と土の場台：δ＝φ                                                 |
| >                                                                    |
| > 土とコンクリートの場合：δ＝φ/3                                     |
| >                                                                    |
| > ただし、φ－α＜Oのときはsin(φ－α)＝0とする。                        |
| >                                                                    |
| > 上載荷量*q0*は必要に応じて考慮する。                               |
| >                                                                    |
| > ここで用いる角度は反時計回りを正とする。                           |
|                                                                      |
| c)　地震時主働土圧                                                   |
|                                                                      |
| > 胸壁・翼壁に作用する地震時主働土圧は、次式による。                 |
|                                                                      |
| ![](media/image99.emf){width="1.507638888888889in"                   |
| height="0.26875in"}                                                  |
|                                                                      |
| ![](media/image100.emf){width="4.597222222222222in"                  |
| height="0.8208333333333333in"}                                       |
|                                                                      |
| ![](media/image101.emf){width="5.089583333333334in"                  |
| height="0.5076388888888889in"}                                       |
|                                                                      |
| > ここに                                                             |
| >                                                                    |
| > ![](media/image133.jpeg){width="4.547916666666667in"               |
| > height="4.904166666666667in"}                                      |
| >                                                                    |
| > ただし、のときはとする。また、は地震時                             |
| に確実に作用するもののみとし、活荷重は原則として含まないものとする。 |
| >                                                                    |
| > ここで用いる角度は反時計回りを正とする。                           |
|                                                                      |
| ![](media/image107.png){width="3.671527777777778in"                  |
| height="2.238888888888889in"}                                        |
|                                                                      |
| 6.  地震時主働土圧                                                   |
|                                                                      |
| d)　地震時静止土圧                                                   |
|                                                                      |
| > 翼壁・翼壁に作用する地震時静止土圧は、次式による。                 |
| >                                                                    |
| > ここに                                                             |
| >                                                                    |
| > ![](media/image109.png){width="5.4361351706036745in"               |
| > height="1.1644553805774278in"}                                     |
|                                                                      |
| 5.  堰柱に作用する土圧                                               |
|                                                                      |
| > a)静止土圧                                                         |
| >                                                                    |
| > ①胸壁・翼壁に作用する土圧 a)静止土圧に準ずる。                     |
| >                                                                    |
| > b)主働土圧                                                         |
| >                                                                    |
| > ①胸壁・翼壁に作用する土圧 b)主働土圧に準ずる。                     |
| >                                                                    |
| > c)地震時主働土圧                                                   |
| >                                                                    |
| > ①胸壁・翼壁に作用する土圧 c)地震時主働土圧に準ずる。               |
|                                                                      |
| ４）泥圧                                                             |
|                                                                      |
| 土砂の堆積によって生じる泥圧については、以下のとおりとする。         |
|                                                                      |
| 3.  鉛直力                                                           |
|                                                                      |
| > 泥圧のうち鉛直力は、堆積した泥土の水中における重量とする。         |
|                                                                      |
| 4.  水平力                                                           |
|                                                                      |
| > 水平方向の泥圧は次式によって求める。                               |
| >                                                                    |
| > *Pe = Ce W~1~ d*                                                   |
| >                                                                    |
| > *Pe* ：水平方向泥圧（kN/㎡）                                       |
| >                                                                    |
| > *Ce* ： 泥圧係数                                                   |
| >                                                                    |
| > *W~1\ ~*：泥土の水中における単位体積重量（kN/m^3^）                |
| >                                                                    |
| > *d* ：泥土の深さ(m)                                                |
| >                                                                    |
| > 設計に用いる堆積した泥土（以下「堆泥」と                           |
| いう。）の深さは、周辺の堆積状況、実績等適切な方法を用いて推定する。 |
| >                                                                    |
| > 堆泥の重量は、                                                     |
| >                                                                    |
| > *W~1~ ＝ W －(1-ν)・W~0~*                                          |
| >                                                                    |
| > で示される。ここにW0                                               |
| > は水の単位体積重量(tf/m^3^){kN/m^3^}、Wは堆                        |
| 泥の見かけの単位体積重量(tf/m^3^){kN/m^3^}、νは堆泥の空隙率である。  |
| >                                                                    |
| > これらの概略値として、下記の数値が常用されている。                 |
| >                                                                    |
| > *W* = 15～18 kN/m^3^，*ν*＝0.3～0.4，*Ce* ＝0.4～0.6,              |
| >                                                                    |
| > *W~0~* ＝10 kN/m^3^                                                |
| >                                                                    |
| > なお、                                                             |
| 地震時は地震時動水圧を考慮するため、動泥圧は一般に考慮しなくてよい。 |
|                                                                      |
| ５）水圧                                                             |
|                                                                      |
| 4.  静水圧                                                           |
|                                                                      |
| > 水門の上下流水位について、水門の操作上考えられる組合せを検討する。 |
| >                                                                    |
| > ただし、地震と高潮は同時に生起しないものとし、地震時慣             |
| 性力及び地震時動水圧と計画高水位時における水圧は、同時に作用しない。 |
|                                                                      |
| ゲート引上げ時には、流水から受ける力を必要に応じて考慮する。         |
|                                                                      |
| 5.  地震時動水圧                                                     |
|                                                                      |
| > 地震時動水圧は、ウエスターガードの近似式により計算する。           |
|                                                                      |
| 6.  胸壁・翼壁に作用する残留水圧                                     |
|                                                                      |
| > 胸壁・翼壁の前面の水位と背面の水位の間に水                         |
| 位差が生じる場合は、この水位差に伴う残留水圧を考慮する（下図参照）。 |
| >                                                                    |
| > 感潮区間の場合は、前面潮位差の2/3の水圧差を対象とする。            |
|                                                                      |
| ![](media/image110.png){width="5.1875in"                             |
| height="3.1041666666666665in"}                                       |
|                                                                      |
| 7.  残留水位の設定方法（常時）                                       |
|                                                                      |
| ![](media/image111.png){width="5.34375in"                            |
| height="1.9166666666666667in"}                                       |
|                                                                      |
| 82. 感潮区間の残留水位                                               |
|                                                                      |
| ６）揚圧力                                                           |
|                                                                      |
| 揚圧力は、水門                                                       |
| の操作上考えられる水門の上下流の水位差が最大となる水位により求める。 |
|                                                                      |
| ７）風荷重                                                           |
|                                                                      |
| 風荷重は3kN/㎡とする。                                               |
|                                                                      |
| ８）温度変化の影響                                                   |
|                                                                      |
| 温度荷重は、温度変化を±15                                            |
| ℃とし、膨張係数を鋼で0.000012、コンクリートで0.00001として計算する。 |
|                                                                      |
| ９）コンクリートのクリープ及び乾燥収縮の影響                         |
|                                                                      |
| 1.  コンクリートのクリープひずみ                                     |
|                                                                      |
| > コンクリートのクリープひずみは次式により算定することができる。     |
| >                                                                    |
| > ここに、                                                           |
|                                                                      |
|   -- ---- -------------------------------------                      |
|      ：   コンクリートのクリープひずみ                               |
|      ：   持続荷重による応力度（N/mm^2^）                            |
|      ：   コンクリートのヤング係数（N/mm^2^）                        |
|      ：   コンクリートのクリープ係数                                 |
|   -- ---- -------------------------------------                      |
|                                                                      |
| > コンクリートのクリープひずみについては、作用する持続荷             |
| 重による応力度がコンクリートの圧縮強度の40％程度以下の場合、上式が成 |
| 立すると考えてよい。一般には、コンクリートの圧縮強度の40％を超える持 |
| 続荷重による応力度が作用することはなく、上式が用いられるが、40％を超 |
| える場合には別途試験などによりクリープひずみを定めなければならない。 |
|                                                                      |
| 2.  コンクリートのクリープ係数                                       |
|                                                                      |
| > プレストレスの損失量及び不静                                       |
| 定力を算出する場合のコンクリートのクリープ係数は、表9-6の値とする。  |
|                                                                      |
| 56. コンクリートのクリープ係数                                       |
|                                                                      |
| +---------------+---------------+-----+-----+-----+-----+-----+      |
| | 持続荷重を    | 4～7          | 14  | 28  | 90  | 365 |     |      |
| | 載荷する時の  |               |     |     |     |     |     |      |
| | コンクリート  |               |     |     |     |     |     |      |
| | の材令（日）  |               |     |     |     |     |     |      |
| +---------------+---------------+-----+-----+-----+-----+-----+      |
| | クリープ      | 早強          | 2.6 | 2.3 | 2.0 | 1.7 | 1.2 |      |
| |               | ポルトランド  |     |     |     |     |     |      |
| | 係数          | セメント使用  |     |     |     |     |     |      |
| +---------------+---------------+-----+-----+-----+-----+-----+      |
| |               | 普通          | 2.8 | 2.5 | 2.2 | 1.9 | 1.4 |      |
| |               | ポルトランド  |     |     |     |     |     |      |
| |               | セメント使用  |     |     |     |     |     |      |
| +---------------+---------------+-----+-----+-----+-----+-----+      |
|                                                                      |
| > コンクリートのひずみは、                                           |
| 作用する持続荷重を取り除くと回復するクリープひずみと回復しないクリー |
| プひずみの和であると考えられる。一般に、プレストレスの損失量を算出す |
| る場合は、クリープひずみをこれら2成分に分けて算出しても、或いは分け  |
| ずに算出しても結果的に大差ないので、表9-6に示すクリープ係数をそのま  |
| ま用いてよい。なお、持続荷重を載荷した時のコンクリートの材令が表9-6  |
| に示す値の間にある場合のクリープ係数は直線補間による値を用いてよい。 |
|                                                                      |
| 3.  コンクリートの乾燥収縮度                                         |
|                                                                      |
| > プレストレスの                                                     |
| 損失量を算出する場合のコンクリートの乾燥収縮度は、表9-7の値とする。  |
|                                                                      |
| 57. コンクリートの乾燥収縮度                                         |
|                                                                      |
| （普通及び早強ポルトランドセメント使用の場合）                       |
|                                                                      |
|   --------------------------------------------                       |
| -------- ----------- ----------- ----------- ----------- ----------- |
|   プレストレスを導入する時のコンクリー                               |
| トの材令（日）   3以内       4～7        28          90          365 |
|   乾　燥　収　縮　度                                                 |
|            25×10^-5^   20×10^-5^   18×10^-5^   16×10^-5^   12×10^-5^ |
|   --------------------------------------------                       |
| -------- ----------- ----------- ----------- ----------- ----------- |
|                                                                      |
| > コンクリートそのものの乾燥収縮度は表                               |
| 9-7に示す値より一般に大きいが、部材に配置される鋼材の影響などを考慮  |
| して、プレストレスの損失量を算定する場合は表9-7に示す値を用いてよい  |
| こととした。なお、プレストレスを導入する時のコンクリートの材令が表9  |
| -7に示す値の間にある場合の乾燥収縮度は直線補間による値を用いてよい。 |
|                                                                      |
| 4.  ②項又は③項によりがたい場合                                       |
|                                                                      |
| > ②項                                                                |
| 又は③項によりがたい場合は、部材周辺の湿度、部材断面の形状寸法、荷重  |
| が作用する時のコンクリートの材令などを考慮して別途定めるものとする。 |
| >                                                                    |
| > 特にコンクリート材令の                                             |
| 若い時期にプレストレッシングを行う場合などでは、上記の諸要因を考慮し |
| て試験により別途定めるか、或いは、適切な方法によって推定してもよい。 |
|                                                                      |
| １０）負の周辺摩擦力の影響                                           |
|                                                                      |
| 軟弱地盤                                                             |
| の層厚が厚い等で負の周辺摩擦力の影響が大きいと予想される場合には、遮 |
| 水矢板等から水門本体へ伝達する負の周辺摩擦力の影響について考慮する。 |
|                                                                      |
| １１）雪荷重                                                         |
|                                                                      |
| 雪荷重は、雪の単位堆                                                 |
| 積重量と積雪深の積として求める。一般に多雪地方においては、雪荷重3.5  |
| kN/m^3^を見込めばよい。積雪深は、既往の積雪記録、構造物上で          |
| の積雪状態などを考慮して設定する。積雪のない地方では考慮する必要はな |
| い。ただし、積雪が少ないために積雪深を決定できない場合は、雪荷重を1  |
| kN/㎡としてよい。                                                    |
|                                                                      |
| １２）プレストレス力                                                 |
|                                                                      |
| プレス                                                               |
| トレス力は、プレストレスを与えた直後（プレストレッシング直後）のプレ |
| ストレス力とその後に生じるコンクリートのクリープ、乾燥収縮及び緊張材 |
| のリラクセーションが終わったときの有効プレストレスについて考慮する。 |
|                                                                      |
| 1.  プレストレッシング直後のプレストレス力                           |
|                                                                      |
| > ポ                                                                 |
| ストテンション方式のプレストレッシング直後のプレストレス力は、緊張材 |
| の緊張端に与えた緊張力に以下に示す影響による損失を考慮して算出する。 |
| >                                                                    |
| > a)　コンクリートと継手材の弾性変形                                 |
| >                                                                    |
| > b)　緊張材とシースの摩擦                                           |
| >                                                                    |
| > c)　函体と均しコンクリートの摩擦                                   |
| >                                                                    |
| > d)　緊張材を定着する際のセット                                     |
|                                                                      |
| 2.  有効プレストレス力                                               |
|                                                                      |
| > 有効プレストレス力は、次に示すコンクリートのクリープ及び乾燥収     |
| 縮と緊張材の見かけのリラクセーションによるプレストレス力の損失量をプ |
| レストレッシング直後のプレストレス力より減じることによって算出する。 |
| >                                                                    |
| > a)　コンクリートのクリープ                                         |
| >                                                                    |
| > b)　コンクリートの乾燥収縮                                         |
| >                                                                    |
| > c)　緊張材のリラクセーション                                       |
|                                                                      |
| １３）地震動                                                         |
|                                                                      |
| 地震動は、構造物の重量に河川構造物の耐震性能照査指針                 |
| 共通編に規定する水平                                                 |
| 震度を乗じた水平力とし、これを水流方向及び水流直角方向に作用させる。 |
|                                                                      |
| １４）その他荷重                                                     |
|                                                                      |
| 堤防及び水門の安全を図るうえで以下の必要な荷重を考慮する。           |
|                                                                      |
| 1.  波圧                                                             |
|                                                                      |
| > 以下の波圧を考慮する。                                             |
| >                                                                    |
| > a\) 波浪及び風浪                                                   |
| >                                                                    |
| > 高潮区間や湖岸堤等で必要に応じて考慮する。                         |
| >                                                                    |
| > 波浪高の推定に当たっては、「調査編第21章 第5節及び本編 第7章       |
| > 第2節」を参照する。                                                |
| >                                                                    |
| > b\) 津波                                                           |
| >                                                                    |
| > 津波遡上区間で必要に応じて考慮する。                               |
|                                                                      |
| 2.  その他                                                           |
|                                                                      |
| > ・副振動、セイシュによる影響                                       |
| >                                                                    |
| > ・施工時荷重                                                       |
| >                                                                    |
| > ・流木の衝突                                                       |
| >                                                                    |
| > ・舟の衝突                                                         |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  （公社）日本道路協会：道路橋示方書・同解説 Ⅰ．共通編，平成 24 年 3
    月.

    （最新版）（公社）日本道路協会：道路橋示方書・同解説Ⅰ．共通編，平成29年11月.

```{=html}
<!-- -->
```
57. 国土交通省：[土木構造物設計マニュアル（案）樋門編](http://www.nilim.go.jp/lab/pbg/theme/theme2/sekkei/himon/himon-m.pdf)，平成13年2月．

    （最新版）土木構造物設計マニュアル（案）樋門編，平成 13 年 12
    月,国土交通省．

58. （財）国土技術研究センター：[柔構造樋門設計の手引き](http://www.jice.or.jp/tech/material/detail/3)，平成10年11月．

59. （公社）日本道路協会：道路土工，擁壁工指針，平成24年版．

60. （公社）日本道路協会：道路土工，カルバート工指針，平成21年版．

61. 国土交通省：[ダム・堰施設技術基準（案）](https://www.mlit.go.jp/common/001126025.pdf)，平成28年3月.

62. 国土交通省水管理国土保全局：河川砂防技術基準調査編，平成26年4月版，第21章海岸調査　第5節波浪調査.

    1.  []{#_Toc47014733 .anchor}安全性能の照査

＜考え方＞

+----------------------------------------------------------------------+
| 水門における安全性能の照査は、「9.5.1                                |
| 設計の                                                               |
| 対象とする状況と作用」に示す状況と作用毎に、照査の条件として適切な外 |
| 水位及び内水位の組合せを設定し、安全性能について照査する必要がある。 |
|                                                                      |
| また、水門における安全性能                                           |
| の照査は、構造や材料の特性に応じた設計手法を適用してモデル化を行い、 |
| 最も不利な断面力が生じる作用に対して、安全性能が確保できるようにする |
| 。なお、「最も不利な断面力が生じる作用」とは、考慮すべき荷重の組合せ |
| のうち、発生応力等が構造物に対して最も不利に働く荷重の組合せをいう。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 水門は、「9.5.1                                                      |
| 設計の対象とする状況と作用**」**に                                   |
| 対し、以下の事項について安全性能を設定して照査することを基本とする。 |
|                                                                      |
| １）常時の安全性能                                                   |
|                                                                      |
| ２）洪水時の安全性能                                                 |
|                                                                      |
| ３）耐震性能                                                         |
|                                                                      |
| ４）風浪等に対する安全性能                                           |
|                                                                      |
| 安全性能の照査に当                                                   |
| たっては、これまでの経験及び実績から妥当とみなせる方法又は論理的に妥 |
| 当性を有する方法等、適切な知見に基づく手法を用いることを基本とする。 |
+----------------------------------------------------------------------+

＜推　奨＞

+------------------------------------------------------------------+
| 安全性能を照査するに当たっては、以下の手法によることが望ましい。 |
|                                                                  |
| １）鉄筋コンクリート部材設計                                     |
|                                                                  |
| ・部材の設計に用いる断面力は、弾性理論により算出する。           |
|                                                                  |
| ・部材の設計は、許容応力度設計法によって行う。                   |
|                                                                  |
| ２）鋼製の門扉の部材設計                                         |
|                                                                  |
| 部材の設計は、許容応力度設計法によって行う。                     |
+------------------------------------------------------------------+

7.  常時の安全性能

＜考え方＞

+----------------------------------------------------------------------+
| 洪水等の外力による作用を受けずとも、水門の自重や水                   |
| 門周辺の堤防からの土圧、さらに軟弱な地盤上に水門を新設する場合には基 |
| 礎地盤の強度不足又は圧縮性が大きいことによる圧密沈下の影響により、構 |
| 造物の安全性が損なわれる可能性があるため、端部堰柱及び胸壁の応力度や |
| 基礎の沈下量、支持力等について常時の安全性能の照査を行う必要がある。 |
|                                                                      |
| また、水門の基礎或いは地盤改良等による地盤の沈下抑制の影響によっ     |
| て、基礎を含む水門本体部と周辺地盤との不同沈下による局部的な沈下によ |
| る段差が生じ、この段差が水門周辺の堤防に悪影響を与える可能性があるた |
| め、隣接堤防との境界部における不同沈下について照査を行う必要がある。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| 水門の自重や水門周辺                                                 |
| の堤防からの土圧等の作用や圧密沈下量等の諸条件を設定し、発生する応力 |
| 度、変位や支持力等を評価し、許容値を満足することを照査の基本とする。 |
|                                                                      |
| 新規築堤や引堤のように、水門とともに水門周辺の堤防を新たに築造       |
| する場合には、水門周辺の堤防に関しても地盤の複雑さに応じて、「設計編 |
| 第1章 河川構造物の設計 第2節 堤防                                    |
| 2.7安全性                                                            |
| 能の照査等**」**の記載に従って安全性能の照査を行うことを基本とする。 |
+----------------------------------------------------------------------+

47. 洪水時の安全性能

＜考え方＞

  --------------------------------------------------------------------------------------------------------------------------------
  水門は、ゲート全閉時において、計画高水位（高潮区間にあっては計画高潮位）以下の水位の流水の作用に対して安全な構造が求められる。
  --------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 洪水時の安全性能は、ゲートへの水                                     |
| 圧、床版への揚圧力、本体・ゲート・付属施設（操作室・管理橋等）の自重 |
| 、土圧が作用する状態で、以下の項目について照査することを基本とする。 |
|                                                                      |
| １）各部位の安全性                                                   |
|                                                                      |
| > 水門本体、翼壁及                                                   |
| び水叩きが転倒、滑動、基礎地盤支持力に対して所定の安全性を確保する。 |
|                                                                      |
| ２）発生応力                                                         |
|                                                                      |
| > 水門及びゲート部                                                   |
| 材に発生する応力が「9.5.3許容応力度**」**以下となることを確認する。  |
|                                                                      |
| ３）耐浸透性                                                         |
|                                                                      |
| > 水門と堤体との接触面における浸透に対して、所定の安全性を確保する。 |
|                                                                      |
| ４）ゲート閉鎖の確実性及び水密性                                     |
|                                                                      |
| > ゲート閉鎖の確実性（床版及び戸                                     |
| 溝に土砂が堆積しない、確実な閉操作が可能なこと）、水密性を確保する。 |
+----------------------------------------------------------------------+

＜推　奨＞

+----------------------------------------------------------------------+
| １）各部位の安全性                                                   |
|                                                                      |
| 所定の安全性とは、以下の安全率を満足するものとする。                 |
|                                                                      |
| 58. 各項目の安全率                                                   |
|                                                                      |
|   項目   安全率                                                      |
|   ------ ---------------------------                                 |
|   基礎   3                                                           |
|   転倒   合力の作用点が中央1/3以内                                   |
|   滑動   1.5                                                         |
|                                                                      |
| ２）耐浸透性                                                         |
|                                                                      |
| 耐浸透性照査における所要の安全性は、地盤の土質区分                   |
| 、堤防断面形状、考慮する水頭差、遮水工の配置、深さ、長さ、不同沈下が |
| 生じる場合にはルーフィング発生による浸透路長の減少を考慮したうえで、 |
| レインの式による浸透経路長を満足することを確認する。なお、遮水工を2  |
| 列に入れる場合深さに対して間隔が短すぎると浸透路長が遮水工沿いとはな |
| らない場合があるので、実現象に合うように浸透路長をとるよう留意する。 |
|                                                                      |
| $$レイン加重                                                         |
| クリープ比　C \leqq \frac{\frac{L}{3} + \sum l}{\mathrm{\Delta}H}$$  |
|                                                                      |
| ここに、                                                             |
|                                                                      |
|   ------ ---- ---------------------------------------------------    |
|   *C*    ：   荷重クリープ比                                         |
|               *Cv* : 遮水工の鉛直方向の加重クリープ比                |
|               *Ch* : 遮水工の水平方向の加重クリープ比                |
|   *L*    ：   本体及び翼壁の函軸方向の浸透経路長（m）                |
|   *∑l*   ：   遮水矢板等の鉛直方向及び水平方向の浸透経路長（m）      |
|               *lv* : 鉛直方向の浸透経路長                            |
|               *lh* : 水平方向の浸透経路長                            |
|   *ΔH*   ：   内外水位差（m）                                        |
|   ------ ---- ---------------------------------------------------    |
|                                                                      |
| 59. 加重クリープ比C                                                  |
|                                                                      |
|   地盤の土質区分             C                                       |
|   -------------------------- -----                                   |
|   極めて細かい砂又はシルト   8.5                                     |
|   細砂                       7.0                                     |
|   中砂                       6.0                                     |
|   粗砂                       5.0                                     |
|   細砂利                     4.0                                     |
|   中砂利                     3.5                                     |
|   栗石を含む粗砂利           3.0                                     |
|   栗石と礫を含む砂利         2.5                                     |
|   柔らかい粘土               3.0                                     |
|   中くらいの粘土             2.0                                     |
|   堅い粘土                   1.8                                     |
|                                                                      |
| ３）ゲート機能                                                       |
|                                                                      |
| ゲート機能は、同様の敷高・規模及び操作形式の樋門・水門における       |
| 操作の確実性を確認できれば機能を確保しているとみなすことができる。な |
| お、堆砂傾向については、必要に応じて水理模型実験を実施して確認する。 |
+----------------------------------------------------------------------+

48. 耐震性能

＜考え方＞

+----------------------------------------------------------------------+
| 水門の耐震性能の照査は、河川構造物の耐震性能照査指針に基づき         |
| 実施する必要がある。レベル1地震動に対しては、地震によって水門として  |
| の健全性を損なわないか否かを照査する。レベル2地震動に対しては、治水  |
| 上又は利水上重要な水門については、地震後においても、水門としての機能 |
| を保持し、それ以外の水門については、地震による損傷が限定的にとどまり |
| 、水門としての機能の回復が速やかに行い得ることを照査する必要がある。 |
|                                                                      |
| 水門の門柱                                                           |
| 、堰柱及びゲートには地震時に慣性力及び地震時動水圧が作用するとともに |
| 、水門周辺の堤防には地震時土圧が作用する。また、水門の地震時挙動は、 |
| 地形、地盤条件等の種々の要因の影響を受けるが、中でも、基礎地盤の影響 |
| を強く受ける。基礎地盤が液状化した場合には、液状化に伴う基礎地盤の変 |
| 形が地震時挙動に大きく影響を及ぼすため、液状化を考慮する必要がある。 |
+----------------------------------------------------------------------+

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  耐震性能の照査に当たっては、レベル1地震動に対して地震によって水門としての健全性を損なわないことを照査し、レベル2地震動に対して水門としての機能を保持する、或いは水門としての機能の回復が速やかに行い得ることを照査の基本とする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

+----------------------------------------------------------------------+
| レベル１地震動及                                                     |
| びレベル2地震動の設定及び応答値の算定は、基本的に静的照査法を用いる  |
| ことができる。レベル2地震動の照査において静的照査法では適切な応答値  |
| を算定できない構造の場合には、動的解析を用いた照査を行う必要がある。 |
|                                                                      |
| 照査許容値は、求める                                                 |
| 耐震性能に応じた限界状態、構造・照査手法に応じた適切な値を設定する。 |
|                                                                      |
| 地震動に                                                             |
| よる作用応力、変位量等の応答値が照査許容値を超えないことを照査する。 |
+----------------------------------------------------------------------+

＜関連通知等＞

1.  国土交通省水管理・国土保全局：[河川構造物の耐震性能照査指針・解説―Ⅳ．水門・樋門及び堰編―](https://www.mlit.go.jp/river/shishin_guideline/bousai/wf_environment/structure/index3.html)，令和2年2月（令和2年6月一部追記）.

```{=html}
<!-- -->
```
49. 風浪等に対する安全性

＜考え方＞

+----------------------------------------------------------------------+
| 高潮時及び風                                                         |
| 浪時の波浪並びに計画津波水位以下の津波に伴い、ゲートに波圧・津波荷重 |
| が作用する。ゲートの照査に用いる波圧及び津波荷重はダム・堰施設技術基 |
| 準（案）、防波堤の耐津波設計ガイドラインに基づき設定する必要がある。 |
|                                                                      |
| 水門周辺の堤防は波の打ち寄せによる侵食に加え、場合によっては堤       |
| 内地への越波を生じ、堤内地の浸水及び水門周辺の堤防裏法面が洗掘するこ |
| とにより堤防の安全性が損なわれる可能性がある。水門周辺の堤防に対する |
| 照査は、堤防と同様にうちあげ高及び越波量により照査を行う必要がある。 |
+----------------------------------------------------------------------+

＜標　準＞

  ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  風浪等に対する本体の安全性能の照査は、本体が受ける水圧及び波圧の作用に対して安全性を評価し、許容値を満足することを照査の基本とする。風浪等に対する水門周辺の堤防の安全性能の照査は、「設計編 第1章 河川構造物の設計 第2節 堤防 2.7 安全性能の照査等**」**を満足することを基本とする。
  ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

1.  []{#_Toc65850224 .anchor}許容応力度

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------
  許容応力度等は、使用する材料の基準強度や力学特性を考慮して、適切な安全性が確保できるように設定することを基本する。
  --------------------------------------------------------------------------------------------------------------------

＜推　奨＞

+----------------------------------------------------------------------+
| 許容応力度として、以下の値を用いることが望ましい。                   |
|                                                                      |
| １）コンクリートの許容応力度                                         |
|                                                                      |
| 60. コンクリートの許容応力度（N/mm^2^）                              |
|                                                                      |
|   設                                                                 |
| 計基準強度   許容曲げ圧縮応力度   許容付着応力度   許容せん断応力度  |
|   ---                                                                |
| ----------- -------------------- ---------------- ------------------ |
|   24             8.0                  1.60             0.39          |
|                                                                      |
| なお、せん断応                                                       |
| 力度は、せん断力を部材幅（b）×有効高（d）で割った平均せん断応力度。  |
|                                                                      |
| せん断応力度の照査は、支点が直接支持と                               |
| なっているものは支点の前面より1/2hだけ内側で行ってよい。(h:はり高）  |
|                                                                      |
| 無筋コンクリートの許容応                                             |
| 力度は、道路橋示方書・同解説Ⅳ．下部構造編（平成24年3月26日）による。 |
|                                                                      |
| ２）鉄筋の許容引張応力度                                             |
|                                                                      |
| 61. 鉄筋の許容引張応力度（N/mm^2^）                                  |
|                                                                      |
| +------------------+------------------+------------------+-----+     |
| | 鉄筋の種類       | SD345            |                  |     |     |
| |                  |                  |                  |     |     |
| | 応               |                  |                  |     |     |
| | 力度、部材の種類 |                  |                  |     |     |
| +==================+==================+==================+=====+     |
| | 引張応力度       | 荷重             | 一般の部材^※1^   | 180 |     |
| |                  | の組合せに衝突荷 |                  |     |     |
| |                  | 重或いは地震の影 |                  |     |     |
| |                  | 響を含まない場合 |                  |     |     |
| +------------------+------------------+------------------+-----+     |
| |                  |                  | 厳しい           | 160 |     |
| |                  |                  | 環境下の部材^※2^ |     |     |
| +------------------+------------------+------------------+-----+     |
| |                  | 荷重             | 200              |     |     |
| |                  | の組合せに衝突荷 |                  |     |     |
| |                  | 重或いは地震の影 |                  |     |     |
| |                  | 響を含む場合の許 |                  |     |     |
| |                  | 容応力度の基本値 |                  |     |     |
| +------------------+------------------+------------------+-----+     |
| |                  | 鉄筋の重ね       | 200              |     |     |
| |                  | 継手長或いは定着 |                  |     |     |
| |                  | 長を算出する場合 |                  |     |     |
| +------------------+------------------+------------------+-----+     |
|                                                                      |
| > ※1通常の環境や常時水中、土中の場合（操作台に適用）                 |
| >                                                                    |
| > ※2一般の環境に比べて乾湿の繰り返しが多い                           |
| 場合や有害な物質を含む地下水位以下の土中の場合（胸壁、遮水壁、堰柱、 |
| 門柱、翼壁に適用）（海洋環境などでは別途かぶりなどについて考慮する） |
|                                                                      |
| ３）鋼材の許容応力度（ゲート等の機械設備を除く）                     |
|                                                                      |
| 62. 構造用鋼材の母材部及び溶接部の許容応力度（N/mm^2^）              |
|                                                                      |
| +--------+--------+--------+--------+--------+-----+-----+-----+     |
| | 鋼     | SS400  | SM490  | SM490Y | SM570  |     |     |     |     |
| | 材記号 |        |        |        |        |     |     |     |     |
| |        | SM400  |        | SM520  | S      |     |     |     |     |
| | 区     |        |        |        | MA570W |     |     |     |     |
| | 分及び | S      |        | S      |        |     |     |     |     |
| |        | MA400W |        | MA490W |        |     |     |     |     |
| | >      |        |        |        |        |     |     |     |     |
| | 応力度 |        |        |        |        |     |     |     |     |
| | の種類 |        |        |        |        |     |     |     |     |
| +========+========+========+========+========+=====+=====+=====+     |
| | 母材部 | 引　張 | 140    | 185    | 210    | 255 |     |     |     |
| |        |        |        |        |        |     |     |     |     |
| |        | 圧　縮 | 140    | 185    | 210    | 255 |     |     |     |
| |        |        |        |        |        |     |     |     |     |
| |        | せん断 | 80     | 105    | 120    | 145 |     |     |     |
| +--------+--------+--------+--------+--------+-----+-----+-----+     |
| | 溶接部 | 工     | 全断面 | 引　張 | 140    | 185 | 210 | 255 |     |
| |        | 場溶接 | 溶込み |        |        |     |     |     |     |
| |        |        | グルー | 圧　縮 | 140    | 185 | 210 | 255 |     |
| |        |        | プ溶接 |        |        |     |     |     |     |
| |        |        |        | せん断 | 80     | 105 | 120 | 145 |     |
| +--------+--------+--------+--------+--------+-----+-----+-----+     |
| |        |        | すみ   | せん断 | 80     | 105 | 120 | 145 |     |
| |        |        | 肉溶接 |        |        |     |     |     |     |
| |        |        | ，部分 |        |        |     |     |     |     |
| |        |        | 溶込み |        |        |     |     |     |     |
| |        |        | グルー |        |        |     |     |     |     |
| |        |        | プ溶接 |        |        |     |     |     |     |
| +--------+--------+--------+--------+--------+-----+-----+-----+     |
| |        | 現     | 引　張 | 原則と |        |     |     |     |     |
| |        | 場溶接 |        | して、 |        |     |     |     |     |
| |        |        | 圧　縮 | 工場溶 |        |     |     |     |     |
| |        |        |        | 接と同 |        |     |     |     |     |
| |        |        | せん断 | じ値と |        |     |     |     |     |
| |        |        |        | する。 |        |     |     |     |     |
| +--------+--------+--------+--------+--------+-----+-----+-----+     |
|                                                                      |
| ４）鋼管杭の許容応力度                                               |
|                                                                      |
| 63. 鋼管杭の母材部及び溶接部の許容応力度（N/mm^2^）                  |
|                                                                      |
| +------------------+----------+--------+------------------+-----+    |
| | 鋼管杭の種類     | SKK400   | SKK490 |                  |     |    |
| |                  |          |        |                  |     |    |
| | 区分             |          |        |                  |     |    |
| | 及び応力度の種類 |          |        |                  |     |    |
| +==================+==========+========+==================+=====+    |
| | 母材部           | 引　張   | 140    | 185              |     |    |
| +------------------+----------+--------+------------------+-----+    |
| |                  | 圧　縮   | 140    | 185              |     |    |
| +------------------+----------+--------+------------------+-----+    |
| |                  | せん断   | 80     | 105              |     |    |
| +------------------+----------+--------+------------------+-----+    |
| | 溶接部           | 工場溶接 | 引　張 | 140              | 185 |    |
| +------------------+----------+--------+------------------+-----+    |
| |                  |          | 圧　縮 | 140              | 185 |    |
| +------------------+----------+--------+------------------+-----+    |
| |                  |          | せん断 | 80               | 105 |    |
| +------------------+----------+--------+------------------+-----+    |
| |                  | 現場溶接 | 引　張 | 原則             |     |    |
| |                  |          |        | として，工場溶接 |     |    |
| |                  |          |        | と同じ値とする。 |     |    |
| +------------------+----------+--------+------------------+-----+    |
|                                                                      |
| ５）既製コンクリート杭の許容応力度                                   |
|                                                                      |
| JIS　による                                                          |
|                                                                      |
| ６）許容応力度の割増し                                               |
|                                                                      |
| 地震、温度変化等の短期荷重を考慮する場合は、表9-14による             |
| 許容応力度の割増しを行なうことができる。下記以外の荷重の組合せによる |
| 許容応力度の割増しを考慮する場合は、個々の状況に応じて適切に定める。 |
|                                                                      |
| 64. 許容応用力度の割増し                                             |
|                                                                      |
| +------------------------+--------+                                  |
| | 短　期　荷　重         | 割増率 |                                  |
| |                        |        |                                  |
| |                        | （％） |                                  |
| +========================+========+                                  |
| | 温度変化の影響         | 15     |                                  |
| +------------------------+--------+                                  |
| | 風荷重                 | 25     |                                  |
| +------------------------+--------+                                  |
| | 地震動                 | 50     |                                  |
| +------------------------+--------+                                  |
| | 温度変化の影響＋風荷重 | 35     |                                  |
| +------------------------+--------+                                  |
| | 温度変化の影響＋地震動 | 65     |                                  |
| +------------------------+--------+                                  |
| | 施工時荷重             | 50     |                                  |
| +------------------------+--------+                                  |
+----------------------------------------------------------------------+

1.  []{#_Toc54776110 .anchor}各部位の設計等

    1.  []{#_Toc54776111 .anchor}本体

```{=html}
<!-- -->
```
8.  ゲート

```{=html}
<!-- -->
```
2.  ゲートの構造

＜考え方＞

+----------------------------------------------------------------------+
| ゲートは全閉することによっ                                           |
| て、洪水時又は高潮時において、計画高水位（高潮区間においては計画高潮 |
| 位）以下の水位の流水の作用、風浪等における波圧に対して安全な構造とな |
| るよう設計する必要があり、原則として水門の下流側に設ける必要がある。 |
|                                                                      |
| ゲートは、確実に開閉し、かつ、必要な水密性を有する構造とするため適切 |
| なゲート形式を選定する必要がある。水門のゲートは、一般的に引上げ式の |
| ローラゲート、起伏ゲート、セクターゲート、マイターゲート等が使用され |
| ているが、操作の確実な点では引上げ式のローラゲートが最も優れている。 |
| しかし、マイターゲートは、頻繁に操作が必要な感潮区間や、中小河川で出 |
| 水頻度が多く出水時間が早い場合、或いは高潮による急激な水位上昇が発生 |
| する場合などに有利であり、高齢化による操作員の減少、安全の確保という |
| 背景と操作の確実性という要請などを踏まえると有効な選択肢となり得る。 |
| そのため、水門ゲート構造については、施設の規模、背後地の土地利用状況 |
| 、個別の状況（管理上、構造上の条件等）を総合的に勘案し選定する必要が |
| ある。なお、ゲート形式をマイターゲートとする場合は、不完全閉塞を起こ |
| す可能性が非常に少なく、不完全閉塞が起こったとしても、治水上著しい支 |
| 障を及ぼすおそれがないと認められ、かつ、引上げ式ゲートとした場合に、 |
| 出水時の開閉操作にタイミングを失うおそれがあること、人為操作が著しく |
| 困難又は不適当と認められること、予備ゲート又は角落し等を設けることに |
| よって容易、かつ、確実に外水を遮断できる構造であることが必要である。 |
|                                                                      |
| カーテンウォールを用いる場合                                         |
| は、ゲートとともに堤防の役割を果たす必要があるため、堰柱や門柱との接 |
| 続を勘案し、水圧や揚圧力等の作用を考慮したうえで、ゲートとの確実な水 |
| 密を確保できる構造とする必要がある。また、カーテンウォールの配置は、 |
| ゲートが点検や整備時に取り外されることも考慮して決定する必要がある。 |
|                                                                      |
| 水門で用いられる扉体構造は、小・中形                                 |
| ゲートではプレートガーダ構造、大形ゲートではシェル構造の採用が多い。 |
|                                                                      |
| ゲ                                                                   |
| ートの基本寸法とは、設置標高、径間長、断面高等を意味し、引き上げ式ゲ |
| ート全開時の扉体の下端標高については揚程を考慮し設定する必要がある。 |
|                                                                      |
| 戸当りは、コンクリート構造                                           |
| 物の規模、強度等に与える影響が大きいため、戸当りの寸法、構造、設置方 |
| 法等とコンクリート構造物との関連性を検討する必要がある。また、ゲート |
| が点検や整備時に取り外されることも考慮して構造を決定する必要がある。 |
+----------------------------------------------------------------------+

＜必　須＞

  ----------------------------------------------------------------------------------------------------------------------------
  ゲートは、確実な開閉が行えるとともに必要な水密性を有する構造とし、設計荷重に対して安全な構造となるよう設計するものとする。
  ----------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| ゲート                                                               |
| は洪水時、高潮時及び風浪等が作用した場合において、全閉することによっ |
| て堤防の代わりとなり得るように水門の下流側に設けることを基本とする。 |
|                                                                      |
| ゲート形式及び規模                                                   |
| 、カーテンウォールの構造は、本体の形式・規模及び戸当り等、他の設備と |
| の配置を考慮して、設計条件を満足するように決定することを基本とする。 |
|                                                                      |
| ゲートの基本寸法は、制約条                                           |
| 件を考慮して、「9.4基本的な構造」に準じて決定することを基本とする。  |
|                                                                      |
| 戸当りの形状はゲートの形式に                                         |
| 適合したものとし、扉体支承部からの荷重を安全にコンクリート構造物に伝 |
| 達することができるように寸法、強度及び剛性を有するものを基本とする。 |
+----------------------------------------------------------------------+

＜例　示＞

+--------------------------------------------------------------+
| 河川や設置場所の特性に応じて門柱レスゲートの採用事例がある。 |
|                                                              |
| 門柱レスゲートの主な構造形式を表9-15に示す。                 |
|                                                              |
| 65. 門柱レスゲートの主な構造形式                             |
|                                                              |
|   開閉形式     ゲート形式       主な主動力方式               |
|   ------------ ---------------- --------------------------   |
|   ヒンジ形式   起伏ゲート       無動力式                     |
|                マイターゲート   無動力式、機械式、油圧式     |
|                セクターゲート   機械式、油圧式               |
+--------------------------------------------------------------+

11. 開閉装置

＜考え方＞

+----------------------------------------------------------------------+
| 水門は、平常時は全開又は一                                           |
| 部開放しており、洪水時又は高潮時にゲートを全閉し堤防機能を確保する必 |
| 要があることから、確実にゲートを開閉できる必要がある。開閉装置の設置 |
| 箇所は、ゲート形式に応じて適切に設定する必要があり、引上げ式ゲートの |
| 場合は堤防高よりも高い操作台の上に開閉装置を設置している場合が多い。 |
|                                                                      |
| 開閉装置の形式は、標準で示すものの他、使用頻度、流量調整の有無、     |
| 締切力の有無、操作室のスペース、維持管理等を検討し、選定する必要があ |
| る。一般的によく利用される開閉装置形式は、ラック式、ワイヤーロープウ |
| インチ式、油圧シリンダ式などがあり、適切な形式を選定する必要がある。 |
|                                                                      |
| 開閉装置は、操作の確実性や容易さを考慮し、電動                       |
| 機を原則とする。ただし、地域特性により電動機の使用が著しく困難な場合 |
| には、信頼性確保を十分行う対策を講じたうえで、他の動力を使用できる。 |
|                                                                      |
| 全てのゲートに予備動力を設けることにより、主動力が使用不可能とな     |
| っても対応することができる。予備動力は、電動機による方式が望ましい。 |
|                                                                      |
| 全ての設備に                                                         |
| 予備電源を設けることにより、常用（商用）電源が暴風雨等において停電し |
| た場合でもゲートを操作することができ、必要最小限の機能を確保できる。 |
|                                                                      |
| ゲートの操作は機側操作が一般的に採用されるが、水門の目的、           |
| 規模、現場操作員の負担軽減や安全の確保等の管理体制を踏まえ、必要に応 |
| じて自動化、遠方操作化や遠隔操作化を検討することとする。自動化は、計 |
| 測した水位に応じて自動で開閉操作を行うことができるように改造すること |
| や、ゲート自体を自動開閉が可能なものとすることであり、遠方操作化、遠 |
| 隔操作化は、管理所や遠隔地から操作を行うことを可能とすることである。 |
+----------------------------------------------------------------------+

＜必　須＞

  ----------------------------------------------------------------------------------------------------------------------------------------
  開閉装置は、ゲートの確実な開閉操作を行うとともに必要な水密性を有する構造とし、設計荷重に対して安全な構造となるよう設計するものとする。
  ----------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 開閉装置は、ゲートの開閉を確実に行う                                 |
| ために設置し、ゲート形式に応じて適切な箇所に設けることを基本とする。 |
|                                                                      |
| 開閉装置形式の選定に当たっては、設備の設置目的、用途、               |
| ゲートの種類、開閉荷重の大きさ、方向及び押下げ力の要否、揚程、開閉装 |
| 置の設置位置、配置及び設置環境を考慮の上、選定することを基本とする。 |
|                                                                      |
| 開閉装置は、電動機に                                                 |
| よるものとし、全てのゲートに開閉用予備動力を備えることを基本とする。 |
|                                                                      |
| ゲートの操作のための設備は、機側操作を基本とする。な                 |
| お、必要に応じて自動化、遠方操作化や遠隔操作化を検討することとする。 |
+----------------------------------------------------------------------+

＜例　示＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  ゲートの操作は、操作上の安全確保の観点から、機側操作優先で設計される場合が多い。ただし、津波・高潮区間や周辺樋門等との連動操作が必要な場合など、管理体制等の条件により遠方操作・遠隔操作を行う場合、十分な安全性を確保したうえで、機側操作に対し遠方操作・遠隔操作を優先する設計を行う場合がある。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

7.  国土交通省：[ダム・堰施設技術基準（案）](https://www.mlit.go.jp/common/001126025.pdf)，平成28年3月.

8.  一般社団法人ダム・堰施設技術協会：ダム・堰施設技術基準（案）（平成28年3月改正）基準解説編・設備計画マニュアル編，平成28年10月.

9.  一般社団法人ダム・堰施設技術協会：水門・樋門ゲート設計要領（案），平成13年12月.

```{=html}
<!-- -->
```
50. 床版

＜考え方＞

+----------------------------------------------------------------------+
| 水門の床版は、上部荷重を支持し、ゲートの水密性を確                   |
| 保し、堰柱間の水叩きの効用を果たすことができる構造とする必要がある。 |
|                                                                      |
| 床版は、本体の形式に応じて決定され、箱型、Ｕ形構造の場合は堰柱と     |
| 一体構造となり、逆Ｔ形の場合は、堰柱と一体となった堰柱床版と堰柱と分 |
| 離した中間床版に分類される。中間床版の基礎は、ゲート荷重に対して不同 |
| 沈下が生じないような構造とし、中間床版は、ゲートとの間の水密性を確保 |
| できるようにする必要がある。また、中間床版は、堰柱間の水平力に対する |
| ストラット（支材）を兼ねさせることがある。半川締切り等で堰柱を仮締切 |
| りに兼用させる場合は、堰柱及び堰柱床版は単独で安定させる必要がある。 |
|                                                                      |
| ![](media/image81.png){width="4.319444444444445in"                   |
| height="1.289134951881015in"}                                        |
|                                                                      |
| 83. 本体の形式がＴ形の場合の床版                                     |
|                                                                      |
| 底部戸当り面は、ゲートとの確                                         |
| 実な水密性、土砂等の堆積防止のために床版と同一平面とする必要がある。 |
+----------------------------------------------------------------------+

＜必　須＞

  --------------------------------------------------------------------------------------------------------
  床版は、ゲートと必要な水密性を有する構造とし、設計荷重に対して安全な構造となるよう設計するものとする。
  --------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 床版は、ゲートとの水密性を確保し                                     |
| 、水叩きの機能を果たすために設置し、堰柱間に設けることを基本とする。 |
|                                                                      |
| 床版は、本体の形式に応じてゲー                                       |
| トや堰柱等の荷重を支持できる構造となるよう設計することを基本とする。 |
|                                                                      |
| 底部戸当り面は、床版と同一平面とすることを基本とする。               |
+----------------------------------------------------------------------+

51. 堰柱

＜考え方＞

+----------------------------------------------------------------------+
| 堰柱は、ゲート側面との水密を確保し、門柱や操作台・操作室等の         |
| 上部荷重及びゲートで受ける水圧を安全に床版に伝えるために設ける必要が |
| ある。堰柱の配置は、「9.4.1水門の断面幅及び径間長の設定**」**、「9.4 |
| .2ゲート開閉時の高さの設定**」**を考慮したうえで決定する必要がある。 |
|                                                                      |
| 堰柱は、上部荷重及び水圧等の作用を安全に床版に伝えるため、           |
| 箱型、Ｕ形及び逆Ｔ形の一部においては床版と一体構造とする必要がある。 |
|                                                                      |
| 堰柱の天端高は、ゲートの全閉時の天端高、管理橋等の条件               |
| を考慮して決定する必要があるが、一般には計画堤防高とすることが多い。 |
|                                                                      |
| ゲート前面には必要に応じ                                             |
| て角落しを設けるための戸溝を設ける必要がある。角落しは、常時水位が高 |
| い場合等においてゲートや戸当りの維持管理を行うために設ける。戸溝幅は |
| 、水圧の大きさにより決定される角落しの規模により設定する必要がある。 |
+----------------------------------------------------------------------+

＜必　須＞

  ----------------------------------------------------------------------------------------------------------------------------------------
  堰柱は、門柱及び一部の床版と一体構造で、ゲートと必要な水密性を有する構造とし、設計荷重に対して安全な構造となるよう設計するものとする。
  ----------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 堰柱は、ゲー                                                         |
| トとの水密性を確保し、上部荷重及び水圧を安全に床版に伝えるために設置 |
| し、流下断面や径間長を考慮して適切な配置で設計することを基本とする。 |
|                                                                      |
| 堰柱は、上部荷重及び                                                 |
| 水圧等の作用を安全に床版に伝える構造として設計することを基本とする。 |
|                                                                      |
| 堰柱の天端高については、ゲートの全閉時の天端高、管理橋等の           |
| 条件を考慮して決定し、堰柱の幅及び長さは、管理橋の幅員、ゲート戸当り |
| 寸法、開閉装置の寸法、力学的安定計算等から決定することを基本とする。 |
|                                                                      |
| ゲート前面の堰柱                                                     |
| には、必要に応じて角落しを設けるための戸溝を設けることを基本とする。 |
+----------------------------------------------------------------------+

＜推　奨＞

+----------------------------------------------------------------------+
| 1.  堰柱先端部には用心鉄                                             |
| 筋として、中間部と同程度の配筋を設けることが望ましい（図9-9参照）。  |
|                                                                      |
| ```{=html}                                                           |
| <!-- -->                                                             |
| ```                                                                  |
| 24. 堰柱の構造計算に用いる有効断面には、原則として戸当りの箱抜       |
| 部分の二次コンクリートを考慮せず設計することが望ましい。また、有効長 |
| は、図9-10に示す箱抜き部、両端の円弧部は除き設定することが望ましい。 |
|                                                                      |
| 25. 門柱と堰柱との結合部、堰柱と床版との結                           |
| 合部は、応力集中を避けるため、図9-11のように配筋することが望ましい。 |
|                                                                      |
| ![テキスト, 地図 が含まれている画像                                  |
| 自動的に生成された説明](media/image82.png){width="4.09375in"         |
| height="1.9270833333333333in"}                                       |
|                                                                      |
| 84. 堰柱の配筋                                                       |
|                                                                      |
| ![テキスト が含まれている画像                                        |
| 自動                                                                 |
| 的に生成された説明](media/image83.png){width="3.6979166666666665in"  |
| height="1.3125in"}                                                   |
|                                                                      |
| 85. 堰柱の有効長                                                     |
|                                                                      |
| ![テキスト が含まれている画像                                        |
| 自動的に生成された説明](media/image134.png){width="4.84375in"        |
| height="1.7708333333333333in"}                                       |
|                                                                      |
| 86. 門柱と堰柱との結合部、堰柱と床版との結合部の配筋                 |
+----------------------------------------------------------------------+

＜例　示＞

+----------------------------------------------------------------------+
| 水門の堰柱の天端高は、計画堤防高とすることが多いが、河川の状況に     |
| よっては現状が計画堤防高より高い場合は現状の堤防高とする場合がある。 |
|                                                                      |
| 堰柱と床版は、同じ長さとするが、                                     |
| 中間堰柱にあっては、必要に応じ堰柱長を床版長より短くする場合もある。 |
|                                                                      |
| 引上式ゲートの場                                                     |
| 合の中央堰柱の断面形状は、流水に対する抵抗を小さくし、流水に対する安 |
| 全性を確保するため、上下流端を半円形等とする例が多い（図9-12参照）。 |
|                                                                      |
| ![](media/image85.png){width="3.3229166666666665in"                  |
| height="1.2083333333333333in"}                                       |
|                                                                      |
| 87. 堰柱形状                                                         |
+----------------------------------------------------------------------+

52. 門柱

＜考え方＞

+----------------------------------------------------------------------+
| 門柱は、引上げ式ゲート                                               |
| を採用した場合において、ゲートを引上げるために設ける必要がある。マイ |
| ターゲートやセクターゲート等のゲート形式の場合は門柱を必要としない。 |
|                                                                      |
| 門柱は、堰柱や管理橋の配置                                           |
| とともに、門柱の断面寸法や戸溝の配置を勘案の上、配置する必要がある。 |
|                                                                      |
| 門柱の高さは、「9.4.3門柱の天端高**」                                |
| **に従い、ゲートの大きさ、引上げ余裕等を考慮し、設定する必要がある。 |
|                                                                      |
| 門柱の断面設定においては、設けるゲ                                   |
| ート及び戸当り金物の規模、設置スペースを考慮して設定する必要がある。 |
+----------------------------------------------------------------------+

＜必　須＞

  ----------------------------------------------------------------------------------------------
  門柱は、堰柱、操作台と一体構造とし、設計荷重に対して安全な構造となるよう設計するものとする。
  ----------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 門柱は、ゲート形式が引き上げ式ゲートの                               |
| 場合に設置し、堰柱及び管理橋の配置に合わせて設けることを基本とする。 |
|                                                                      |
| 門                                                                   |
| 柱の高さは、「9.4.3門柱の天端高」に従って設定することを基本とする。  |
|                                                                      |
| 門柱は、堰柱及び操作台と一体構造と                                   |
| し、上部荷重を安全に堰柱に伝える構造として設計することを基本とする。 |
|                                                                      |
| 門柱の断面は、戸当り金物を十分                                       |
| な余裕をもって取り付けられるように設計することを基本とする。また、門 |
| 柱部の戸当りは、ゲートが取りはずせるように設計することを基本とする。 |
+----------------------------------------------------------------------+

＜推　奨＞

+----------------------------------------------------------------------+
| 門柱部の戸当                                                         |
| りは、ゲートが取外せるように取外し式又は回転式とすることが望ましい。 |
|                                                                      |
| ![](media/image135.png){width="6.298611111111111in"                  |
| height="2.4763888888888888in"}                                       |
|                                                                      |
| 88. 取外し式戸当りの例                                               |
|                                                                      |
| ![](media/image136.png){width="5.402777777777778in"                  |
| height="2.701388888888889in"}                                        |
|                                                                      |
| 89. 回転式戸当りの例                                                 |
+----------------------------------------------------------------------+

53. ゲートの操作台

＜考え方＞

+----------------------------------------------------------------------+
| 操                                                                   |
| 作台は、ゲート操作用の開閉装置及び操作盤等の機器の設置、照明等の付属 |
| 施設を設けるため、引上げ式ゲートの場合は門柱の上に設ける必要がある。 |
|                                                                      |
| 操作台は、開閉装置の設                                               |
| 置及び操作、点検並びに整備等の維持管理が容易に行える広さを有する必要 |
| がある。維持管理に必要な広さの設定は、水門・樋門ゲート設計要領（案） |
| 6-3-3開閉操作室に準拠する。                                          |
+----------------------------------------------------------------------+

＜必　須＞

  ------------------------------------------------------------------------------------------
  操作台は、門柱と一体の構造とし、設計荷重に対して安全な構造となるよう設計するものとする。
  ------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 操作台は、ゲート操作用の開閉                                         |
| 装置、操作盤等の機器を設けるため、門柱の上に設けることを基本とする。 |
|                                                                      |
| ゲート操作台は、操作性、維持管理に配慮した形状寸法を基本とする。     |
|                                                                      |
| ゲート操作台には、操作室を設けることを基本とする。                   |
+----------------------------------------------------------------------+

＜推　奨＞

  ----------------------------------------------------------------------------------------------------
  操作室の設置に当たっては、耐震性能を確保する観点から極力軽量な材質を適切に選定することが望ましい。
  ----------------------------------------------------------------------------------------------------

＜関連通知等＞

10. 一般社団法人ダム・堰施設技術協会：水門・樋門ゲート設計要領（案），平成13年12月.

    1.  []{#_Toc47014737 .anchor}胸壁

＜考え方＞

+----------------------------------------------------------------------+
| 胸壁は、堤防                                                         |
| 内の土粒子の移動及び吸出しを防止するとともに、翼壁が洗掘等により破損 |
| し、堤防前面が崩壊した場合においても、一時的に堤防の崩壊を防止できる |
| 構造とするため、堰柱と一体構造とし、水門の上下流に設ける必要がある。 |
|                                                                      |
| 胸壁は                                                               |
| 堰柱と一体化するが、土圧等に対して自立できるよう設計する必要がある。 |
|                                                                      |
| 胸壁の天端は、計画                                                   |
| 堤防断面内を基本とし、河川の状況によって施工断面内とする必要がある。 |
|                                                                      |
| 胸壁の横方向の長さは、土砂の吸出し、一時的な崩壊防止等を考慮の       |
| うえ、胸壁の高さの半分以上の長さで、必要な長さを確保する必要がある。 |
+----------------------------------------------------------------------+

＜必　須＞

  ------------------------------------------------------------------------------------------------------------------
  胸壁は、堰柱と一体の構造で必要な水密性を有する構造とし、設計荷重に対して安全な構造となるよう設計するものとする。
  ------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 胸壁は、堤防内の土粒子の                                             |
| 移動及び吸出しを防止するとともに、翼壁の破損等による堤防の崩壊を一時 |
| 的に防止できる構造とするため、水門の上下流に設けることを基本とする。 |
|                                                                      |
| 胸壁は、土圧等に対して自立できるよう設計することを基本とする。       |
|                                                                      |
| 胸壁の天端は、計画堤防断面内とすることを基本とする。                 |
|                                                                      |
| 胸壁の横方向の長さは、                                               |
| 胸壁の高さの半分以上の長さで、必要な長さを確保することを基本とする。 |
+----------------------------------------------------------------------+

2.  []{#_Toc47014738 .anchor}翼壁

＜考え方＞

+----------------------------------------------------------------------+
| 翼壁は、堤防や堤脚を保護し、接続する                                 |
| 河川又は水路を円滑に通水させるため、水門の上下流に設ける必要がある。 |
|                                                                      |
| 翼壁は、堰柱及び胸壁                                                 |
| と分離した構造とするが、堰柱と翼壁の接続部は、屈とう性のある止水板及 |
| び伸縮材を使用し、構造上の変位が生じても水密性を確保する必要がある。 |
|                                                                      |
| 翼壁の天端高は、計画堤防断面又は現況断面                             |
| のいずれか大きい方に合わせ、突出しないようにする必要がある。また、翼 |
| 壁の端部は、取付水路が洗掘しないように、取付水路の護岸の範囲又は翼壁 |
| 端部の壁高に1m程度を加えた値以上、堤防に平行に嵌入させる必要がある。 |
+----------------------------------------------------------------------+

＜必　須＞

  ------------------------------------------------------------------------------------------------------------
  翼壁は、必要な水密性及び屈とう性を有する構造とし、設計荷重に対して安全な構造となるよう設計するものとする。
  ------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 翼壁は、水門の上下流に対                                             |
| して堤防や堤脚を保護するため、水門の上下流に設けることを基本とする。 |
|                                                                      |
| 翼壁は、堰柱及び胸壁と分離した構造となることを基本とする。           |
|                                                                      |
| 翼壁の天端高は、計画堤防断面又は現況断面のいずれか大きい方に合わ     |
| せることを基本とする。また、端部は、堤防に平行に、取付水路の護岸の範 |
| 囲又は翼壁端部の壁高に1m程度を加えた値以上嵌入することを基本とする。 |
+----------------------------------------------------------------------+

＜推　奨＞

+----------------------------------------------------------------------+
| 翼壁の平面形は、図9-15のように上流及び下流に向か                     |
| って漸拡することが望ましいが、本川及び支川の河状を考慮して決定する。 |
|                                                                      |
| ![](media/image137.png){width="2.6945833333333336in"                 |
| height="2.15288823272091in"}                                         |
|                                                                      |
| 90. 翼壁平面図                                                       |
+----------------------------------------------------------------------+

1.  []{#_Toc54776114 .anchor}水叩き

＜考え方＞

+----------------------------------------------------------------------+
| 水叩きは、水門の安全性                                               |
| を保ち、上下流河床と本体部分の粗度の違い又はゲート開放時の流水等によ |
| って河床が洗掘されるのを防止するため、翼壁の範囲に設ける必要がある。 |
|                                                                      |
| 水叩きと翼壁及び床版との継手は、水密かつ不同沈下にも対応できる構造   |
| で、表面に大きな段差を生じさせないよう設計する必要がある。また、翼壁 |
| に設ける遮水工が水叩きによって分断されないように配慮する必要がある。 |
|                                                                      |
| 水叩きの長さは、翼壁が堤防の一部で                                   |
| あることを考慮して、内外水位差による浸透水、ゲート操作の影響による洗 |
| 掘等により、翼壁が破損しないように翼壁と同一の長さとする必要がある。 |
+----------------------------------------------------------------------+

＜必　須＞

  --------------------------------------------------------------------------------------------------------------
  水叩きは、必要な水密性及び屈とう性を有する構造とし、設計荷重に対して安全な構造となるよう設計するものとする。
  --------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 水叩きは、本体前面の洗掘を防ぎ、翼壁の                               |
| 安定性を保つために、水門上下流の翼壁の河床に設けることを基本とする。 |
|                                                                      |
| 水叩きの先端は、流                                                   |
| 水による洗掘及び遮水工との接続に配慮した構造であることを基本とする。 |
|                                                                      |
| 水叩きは、翼壁と同一の長さとすることを基本とする。                   |
+----------------------------------------------------------------------+

＜推　奨＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  水叩きは、一般に鉄筋コンクリート構造とすることが多いが、揚圧力が大きく明らかに不経済となる状況においては、揚圧力の軽減を図る構造（根固工等を利用）とすることが望ましい。この場合においても、必要な浸透経路長を確保することが望ましい。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

2.  []{#_Toc47014740 .anchor}遮水工

＜考え方＞

+----------------------------------------------------------------------+
| 遮                                                                   |
| 水工は、堰柱や床版及び水叩き下部の土砂流動と、洗掘による土砂の吸出し |
| により、水門が堤防の弱点となることを防止するために設ける必要がある。 |
|                                                                      |
| 遮水工の構造、遮水工の深さ、水平方向の長さは、堤                     |
| 防断面形状、水頭差を元にレインの式などにより浸透経路長を考慮して決定 |
| する必要がある。また、遮水矢板には、構造計算上の荷重は分担させない。 |
+----------------------------------------------------------------------+

＜必　須＞

  --------------------------------------------------------------------------------------------------------------
  遮水工は、必要な水密性及び屈とう性を有する構造とし、設計荷重に対して安全な構造となるよう設計するものとする。
  --------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 遮水工は、水門下部の土砂流動と洗掘に                                 |
| よる土砂の吸出しを防止するため、適切な位置に設けることを基本とする。 |
|                                                                      |
| 遮水工                                                               |
| の構造、遮水工の深さ、水平方向の長さは、堤防断面形状、水頭差、浸透経 |
| 路長、過去の事例などを総合的に検討のうえで決定することを基本とする。 |
+----------------------------------------------------------------------+

＜推　奨＞

+----------------------------------------------------------------------+
| 4.  配置                                                             |
|                                                                      |
| 遮水工に用いる矢板は、内                                             |
| 外水位差による浸透水の動水勾配を減少させ、水門下部の土砂流動と洗掘に |
| よる土砂の吸出しを防止するために図9-16のように設けることが望ましい。 |
|                                                                      |
| ![](media/image138.png){width="2.65291447944007in"                   |
| height="2.1737226596675416in"}                                       |
|                                                                      |
| 91. 水門の遮水矢板の配置                                             |
|                                                                      |
| ```{=html}                                                           |
| <!-- -->                                                             |
| ```                                                                  |
| 5.  構造                                                             |
|                                                                      |
| 遮水矢板は，本体と離脱しないように配慮し、水平方向に設ける遮         |
| 水矢板は必要に応じ屈とう性を有する構造として設計することが望ましい。 |
|                                                                      |
| 6.  鋼矢板を遮水工として用いる場合の留意点                           |
|                                                                      |
| 遮                                                                   |
| 水矢板は、安全性、現場条件及び市場性を考慮したうえで、Ｕ形（普通型、 |
| 広幅型等）、ハット型の経済比較を行い、適切に選定することが望ましい。 |
+----------------------------------------------------------------------+

＜例　示＞

  --------------------------------------------------------------------------------------------------------
  基礎地盤が良好な場合の直接基礎で鋼矢板の施工が困難な場合は、コンクリートのカットオフとする場合がある。
  --------------------------------------------------------------------------------------------------------

1.  []{#_Toc47014741 .anchor}基礎

＜考え方＞

+----------------------------------------------------------------------+
| 基礎は、床版及び翼壁の下に同一の基礎形式を選定し、                   |
| 不同沈下を起こさず、堤防の弱点とならないようにすることが必要である。 |
|                                                                      |
| 基礎は、鉛直                                                         |
| 荷重のみならず水平荷重に対して安定する構造として設計する必要がある。 |
|                                                                      |
| 基礎の設計に当たっては、道                                           |
| 路橋示方書（Ⅳ下部構造編）・同解説（平成24年3月）、杭基礎に当たっては |
| 杭基礎設計便覧（平成27年4月）及び杭基礎施工便覧（平成27年4月）により |
| 設計するものとする。道路橋示方書は平成29年11月に、杭基礎設計便覧及び |
| 杭基礎施工便覧は令和2年9月に改訂されている。これらの改訂では、性能規 |
| 定（限界状態設計法及び部分係数法）に対応した記述に見直しており、従来 |
| の仕様規定（許容応力度設計法）とは異なる設計体系となっている。そのた |
| め、道路橋示方書、杭基礎設計便覧及び杭基礎施工便覧の設計法を適用する |
| 場合は、従来の仕様規定について記載しているものを適用する必要がある。 |
|                                                                      |
| 基礎形式の選定に当たっては、必要工期、作業場面積の大小、環境面での制 |
| 限、施工機械の保有量、経済性等を考慮し、総合的に判断する必要がある。 |
|                                                                      |
| 地質条件等に                                                         |
| よっては地震時の液状化対策も必要となるため、耐震対策の必要性も併せて |
| 検討する必要がある。耐震対策を行う場合は、河川構造物の耐震性能照査指 |
| 針・解説、Ⅳ水門・樋門及び堰編によって照査を行い設計する必要がある。  |
+----------------------------------------------------------------------+

＜必　須＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  基礎は、上部荷重等によって不同沈下を起こさないよう、良質な地盤に安全に荷重を伝達する構造となるよう設計するものとする。また、水平荷重に対して安定する構造となるよう設計するものとする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 基礎は、水門と翼壁の間に不同沈下が発生し堤防の弱点とならないよ       |
| うにするため、床版及び翼壁の下に同一の基礎で設けることを基本とする。 |
|                                                                      |
| 基礎の形式及び構造は、良                                             |
| 質な地盤に安全に荷重を伝達できるよう適切に選定することを基本とする。 |
+----------------------------------------------------------------------+

＜関連通知等＞

11. 国土交通省：道路橋示方書・同解説 Ⅳ下部構造編，平成24年3月.

    （最新版）道路橋示方書・同解説Ⅳ下部構造編，平成29年11月,（公社）日本道路協会.

12. (公社)日本道路協会：杭基礎設計便覧（平成26年度改訂版），平成27年4月.

    （最新版）(公社)日本道路協会：杭基礎施工便覧（平成26年度改訂版），令和2年9月.

13. (公社)日本道路協会：杭基礎施工便覧（平成26年度改訂版），平成27年4月.

    （最新版）(公社)日本道路協会：杭基礎施工便覧（平成26年度改訂版），令和2年9月.

    1.  []{#_Toc47014742 .anchor}護床工

＜考え方＞

+----------------------------------------------------------------------+
| 護床工は、流速を弱め流水を整え、併せて流水による洗掘                 |
| 等から堤防や翼壁、水叩きを保護するために翼壁前面に設ける必要がある。 |
|                                                                      |
| 護床工の構造は、水叩き下流での跳水                                   |
| の発生により激しく流水が減勢される区間では、鉄筋により連結されたブロ |
| ック構造又はコンクリート構造等とし、その下流の整流となる区間では、粗 |
| 朶沈床、木工沈床、改良沈床、コンクリート床版、コンクリートブロック等 |
| が用いられる。そのため、屈とう性を有する構造とし、硬い構造のものから |
| 漸次軟らかい構造のもので河床になじみよくするような配慮が必要である。 |
|                                                                      |
| 上流側護床工の設置範囲は、計画高水位の水深程度以上の長さ             |
| を確保する。下流側護床工の設置範囲は、水叩き下流での跳水の発生により |
| 激しく流水が減勢される区間と、その下流の整流区間とに分けて設計する。 |
+----------------------------------------------------------------------+

＜必　須＞

  ----------------------------------------------------------------------------------------------------
  護床工は、必要な屈とう性を有する構造とし、設計荷重に対して安全な構造となるよう設計するものとする。
  ----------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 護床工は、                                                           |
| 水叩き上下流での洗掘を防ぐため、翼壁の前面に設けることを基本とする。 |
|                                                                      |
| 護床工は、屈とう性を有する構造とし、水叩き上下流での洗               |
| 掘を防ぐことができる長さ及び構造となるよう設計することを基本とする。 |
+----------------------------------------------------------------------+

2.  []{#_Toc47014743 .anchor}護岸

＜考え方＞

+----------------------------------------------------------------------+
| 護岸は、水門の影響によ                                               |
| る流水の乱れ、高潮時及び風浪時の波浪、計画津波水位以下の津波及び越波 |
| に対し堤防を保護するとともに、水門及び水門周辺の堤防が一連区間の中で |
| 相対的な弱点にならないように水門周辺の堤防に護岸を設ける必要がある。 |
|                                                                      |
| 水門が横断する河岸又は堤防に設ける護岸は、水門の両端                 |
| （胸壁又は翼壁）から上流及び下流にそれぞれ10ｍの地点を結ぶ区間以上、 |
| 堤防天端での開削幅がカバーできる区間以上のいずれか大きい区間に設ける |
| 必要がある。近接する場合は、その区間を空けずに連続させる必要がある。 |
|                                                                      |
| 護岸の形式及び構造は、改訂                                           |
| 護岸の力学設計法を参考に設定する必要がある。                         |
|                                                                      |
| ![](media/image139.png){width="3.7604166666666665in"                 |
| height="2.6770833333333335in"}                                       |
|                                                                      |
| 92. 水門の護岸の例                                                   |
|                                                                      |
| 護岸には、多                                                         |
| くの形式があり、使用される素材、構造の外観等はさまざまであるが、設置 |
| 箇所の河道特性や周辺の護岸形式及び構造を踏まえて設計する必要がある。 |
+----------------------------------------------------------------------+

＜必　須＞

  ------------------------------------------------------------------------------------------------------------------------------------
  護岸は、流水の変化に伴う河岸又は堤防の洗掘を防止するために設けるものとし、設計荷重に対して安全な構造となるよう設計するものとする。
  ------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 護岸は、流水等の作用によ                                             |
| り、堤防又は河岸を保護するため、適切な範囲に設けることを基本とする。 |
|                                                                      |
| 護岸の形式及び構造は、設置箇所の河道                                 |
| 特性及び水門周辺の堤防環境を考慮し、適切に設定することを基本とする。 |
+----------------------------------------------------------------------+

＜関連通知等＞

14. （財）国土技術研究センター：改訂 護岸の力学設計法, 平成 19 年 9 月.

    （最新版）（一財）国土技術研究センター：[改訂
    護岸の力学設計法](https://www.jice.or.jp/cms/kokudo/pdf/tech/material/gogan.pdf)，2023.

    1.  []{#_Toc47014744 .anchor}高水敷保護工

＜考え方＞

+----------------------------------------------------------------------+
| 高水敷は、水門の翼壁部分又                                           |
| は取付水路によって上下流に不連続となり、一般にその部分で乱流が起こり |
| 、洗掘を受けやすいので、必要な範囲に高水敷保護工を設ける必要がある。 |
|                                                                      |
| なお、高水                                                           |
| 敷の河川横断方向に設ける水門の取付水路については、工作物設置許可基準 |
| 第十を参照する。                                                     |
|                                                                      |
| 高                                                                   |
| 水敷保護工の構造は、一般には、カゴマット、連節ブロック等を用いて流水 |
| の作用による高水敷の洗掘を防止するものとし、かつ、周辺景観との調和、 |
| 河川の生態系の保全等の河川環境の保全に配慮して覆土を行う必要がある。 |
|                                                                      |
| 取付水路保護工は、取付水路の範囲において設け                         |
| ることを基本とし、周辺護岸や高水敷の利用を踏まえて設ける必要がある。 |
+----------------------------------------------------------------------+

＜必　須＞

  ----------------------------------------------------------------------------------------------------------
  高水敷保護工は、高水敷の洗掘を防止する構造とし、設計荷重に対して安全な構造となるよう設計するものとする。
  ----------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 高水敷保護工は、流水等の作用によ                                     |
| る高水敷の洗掘を防止するため、高水護岸前面に設けることを基本とする。 |
|                                                                      |
| 高水敷保護工の構造                                                   |
| は、河川の生態系の保全等の河川環境の保全に配慮した構造を基本とする。 |
|                                                                      |
| 高水敷保護工は、「9.6.8                                              |
| 護岸**」**で示す護岸の範囲において設けることを基本とする。           |
+----------------------------------------------------------------------+

＜関連通知等＞

15. 河川管理技術研究会編：[改訂
    解説・工作物設置許可基準](http://www.jice.or.jp/cms/kokudo/pdf/tech/material/kousakubutusecchi.pdf)，（財）国土技術研究センター，1998.

    1.  []{#_Toc47014745 .anchor}付属施設

```{=html}
<!-- -->
```
9.  管理橋

＜考え方＞

+----------------------------------------------------------------------+
| 管理橋は、水門の開閉操作及び維持管理、堤防の管理用通路               |
| として利用するため、水門左右岸の堤防天端を円滑に接続する必要がある。 |
|                                                                      |
| 管理橋の桁下高は、流下断面を阻害しないことを目的に                   |
| 、計画堤防高さ以上とする必要がある。管理橋の橋面高は、取付道路の構造 |
| 等を確認し、路盤が計画堤防断面内に入らないような高さとする必要がある |
| 。管理橋の構造は、設計自動車荷重を考慮して、適切な構造とする必要があ |
| る。設計自動車荷重の設定において、水門に接続する堤防は水防活動上必要 |
| な道路として耐え得る設計自動車荷重であるにもかかわらず、水門の管理橋 |
| だけがそれに耐え得ないのは極めて不都合であるため、配慮が必要である。 |
|                                                                      |
| ただし、管理橋の幅員が                                               |
| 3ｍ未満の場合や兼用道路にならない場合はこの限りではなく、水門の維持  |
| 管理上必要な荷重を勘案したうえで設計自動車荷重を設定する必要がある。 |
|                                                                      |
| 管理橋の幅員は、接続する管理用通路の幅員                             |
| 、交通量、その重要性等と、水門管理及び水防時の交通を考慮して決定する |
| 必要がある。ただし、兼用道路の場合は道路管理者と協議する必要がある。 |
+----------------------------------------------------------------------+

＜必　須＞

  --------------------------------------------------------------------------------------------------
  管理橋は、水門の管理を目的として設置し、設計荷重に対して安全な構造となるよう設計するものとする。
  --------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------+
| 管理橋は、水門の操作及び堤防の管理用通路として利用す                 |
| るため、堰柱上に設置し堤防天端を接続するよう設けることを基本とする。 |
|                                                                      |
| 管理橋の桁下高は、計画高水位に余裕高を加えた堤防高さ（               |
| 計画堤防の高さが現状の堤防の高さより低く、かつ、治水上の支障がないと |
| 認められるときは現状の堤防の高さ）以上とすることを基本とする。管理用 |
| 通路としての効用を兼ねる管理橋の設計自動車荷重は、水門に接続する管理 |
| 用通路の設計自動車荷重を考慮して20t以上の適切な値を設定することを基  |
| 本とする。ただし、管理橋の幅員が3ｍ未満の場合や兼用道路にならない場  |
| 合はこの限りでない。水門に接続する堤防が兼用道路の場合で、設計自動車 |
| 荷重を道路構造令（昭和45年政令第320号）第35条第2項に規定する25tとし  |
| ている場合には、設計自動車荷重を25ｔとすることを標準とする。また、河 |
| 川管理上必要と認められる場合には、設計自動車荷重を25ｔとしてもよい。 |
|                                                                      |
| 管理橋の幅員は、水門                                                 |
| に接続する管理用通路の幅員を考慮した適切な値とすることを基本とする。 |
+----------------------------------------------------------------------+

10. その他付属施設

＜考え方＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  付属施設には、操作室、水門等操作観測員待機場、管理用階段、照明設備、水位観測施設、船舶通航用の信号、繋船環、防護柵等があり、ゲート操作のための水位把握、操作員等の安全確保、維持管理に必要な施設を設ける必要がある。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

  ----------------------------------------------------------------------------------
  水門には、維持管理及び操作のため、必要に応じて付属施設を設けることを基本とする。
  ----------------------------------------------------------------------------------

＜関連通知等＞

16. （公社）日本道路協会：道路橋示方書・同解説 Ⅰ．共通編，平成 24 年 3
    月．

    （最新版）（公社）日本道路協会：道路橋示方書・同解説Ⅰ．共通編，平成29年11月.

```{=html}
<!-- -->
```
63. 国土交通省：[ダム・堰施設技術基準（案）](https://www.mlit.go.jp/common/001126025.pdf)，平成28年3月．

    1.  []{#_Toc54776121 .anchor}既存施設の自動化・遠隔化

＜考え方＞

+----------------------------------------------------------------------+
| 新設の水門のゲートの操作の                                           |
| ための設備については、必要に応じて自動化、遠方操作化や遠隔操作化を検 |
| 討することとしているが、既存の水門のゲートの操作のための設備について |
| も、水門の目的、規模、操作員の負担軽減や安全の確保等の管理体制を踏ま |
| え、必要に応じて自動化、遠方操作化や遠隔操作化を検討することとする。 |
|                                                                      |
| 自動化は、計                                                         |
| 測した水位に応じて自動で開閉操作を行うことができるように改造すること |
| や、ゲート自体を自動開閉が可能なものとすることであり、遠方操作化、遠 |
| 隔操作化は、管理所や遠隔地から操作を行うことを可能とすることである。 |
+----------------------------------------------------------------------+

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------
  既存の水門のゲートの操作のための設備については、必要に応じて自動化、遠方操作化や遠隔操作化を検討することを基本とする。
  ------------------------------------------------------------------------------------------------------------------------

1.  []{#_Toc47014746 .anchor}水門構造に関するその他事項

＜考え方＞

+----------------------------------------------------------------------+
| １）現況施設の能力を上回る事象に対する対応について                   |
|                                                                      |
| 現況施設能力を上回る洪水の生起により計                               |
| 画高水位を超えるような事象が頻発しており、今後の気候変動の影響によっ |
| ては、このような事象が更に増えることも考えられる。そのため施設能力を |
| 上回る外力に対し、「構造上の工夫」により減災を図ることが求められる。 |
|                                                                      |
| ２）気候変動を踏まえた施設設計について                               |
|                                                                      |
| 今後、気                                                             |
| 候変動により外力が更に増加する可能性があることにも留意する必要がある |
| 。そのため、外力の増加への対応として、大規模な改良とならないよう補強 |
| しやすい構造とする又は、あらかじめ対策を施すなどの設計が求められる。 |
|                                                                      |
| ３）ICTやBIM/CIMの利用                                               |
|                                                                      |
| i-Construction推進の一環として、ICTによる建設生産プロセスのシ        |
| ームレス化が取り組まれている。UAV写真測量やレーザースキャナー計測な  |
| どで得られる3次元点群データを活用することで、現況地形や既設物の構造  |
| を様々な角度・断面から把握することができる。新設・改修する施設の3次  |
| 元モデルを作成し活用することにより、構造に関して関係者の理解と合意形 |
| 成が促進される。このため、計画段階など事業の早期段階をはじめ、施工段 |
| 階、施工後の点検・補修・修繕の段階においてBIM/CIMを積極的に活用し、  |
| 水門本体及び水門周辺の堤防を適切に維持管理していくことが求められる。 |
+----------------------------------------------------------------------+

＜関連通知等＞

17. 国土交通省：CIM 導入推進委員会：CIM 導入ガイドライン（案），令和 2
    年 3 月.

    （最新版）国土交通省：[BIM/CIM
    活用ガイドライン（案）](https://www.mlit.go.jp/tec/tec_tk_000064.html)，令和
    4 年 3 月.

＜例　示＞

+----------------------------------------------------------------------+
| 気候変動により外力が増大し                                           |
| 、将来、施設の改造が必要になった場合でも、外力の増大に柔軟に追随でき |
| る、できるだけ手戻りのない設計を実施している以下のような事例がある。 |
|                                                                      |
| ・日光川水閘門では、耐用年                                           |
| 数内の海面水位の上昇量を想定し、改造等が容易な構造形式の選定、追加的 |
| な補強が困難な門柱部の嵩上げ及び基礎部補強をあらかじめ実施している。 |
+----------------------------------------------------------------------+

第 10 節 トンネル構造による河川
===============================

1.  トンネル構造による河川設計の基本

2.  構造細目

    1.  本体

    2.  呑口部および流入施設

        1.  呑口部

        2.  流入施設

    3.  吐口部および排水施設

        1.  吐口部

        2.  排水施設

    4.  維持管理に対する施設

3.  設計細目

    1.  トンネル

        1.  設計流量

        2.  設計流速

        3.  断面

第 11 節 排水機場

1.  排水機場設計の基本

2.  構造細目

    1.  沈砂池

    2.  機場本体

        1.  機場本体

        2.  吸水槽

            1.  吸水槽の形式

            2.  吸水槽の形状と構造

        3.  冷却水槽

        4.  燃料貯油槽

        5.  地下ポンプ室

    3.  基礎

    4.  機場上屋

        1.  ポンプ室

        2.  操作室、管理室等

    5.  ポンプ設備

        1.  ポンプ設備

        2.  ポンプ容量と台数

        3.  計画実揚程

        4.  ポンプ形式の選定

        5.  主原動機の種類の選定

        6.  ポンプの運転範囲

        7.  ポンプの運転操作方式

    6.  スクリーン

    7.  角落し等

    8.  吐出水槽

    9.  付属設備

    10. 機場内配置

3.  設計細目

    1.  設計荷重

    2.  沈砂池

    3.  吸水槽

第2章 ダムの設計 {#第2章-ダムの設計 .目次の見出し1}
================

第1節　総説 {#第1節-総説 .目次の見出し1}
===========

目　次 {#目-次-6 .目次の見出し1}
======

[第1節 総説 1](#_Toc81920882)

> [1．1 基本的考え方 1](#_Toc81920883)
>
> [1．2 目的と適用範囲 1](#_Toc81920884)
>
> [1．3 用語の定義 2](#_Toc81920885)

令和3年10月　版

適用上の位置付け

　河川砂防技術基準設計編は、基準の適用上の位置付けを明確にするために、下表に示すように適用上の位置付けを分類している。

+--------+------------------+------------------+------------------+
| 分　類 | 適用上の位置付け | 末尾の字句例     |                  |
+--------+------------------+------------------+------------------+
| 考え方 | 技術資料         | ●目              | 「･･･ある。      |
|        |                  | 的や概念、考え方 | 」「･･･いる。」  |
|        |                  | を記述した事項。 |                  |
|        |                  |                  | 「･･･なる。      |
|        |                  |                  | 」「･･･れる。」  |
+--------+------------------+------------------+------------------+
| 必　須 | 技術基準         | ●法令による規定  | 「･･･なければ    |
|        |                  | や技術的観点から | ならない。」「･  |
|        |                  | 実施すべきである | ･･ものとする。」 |
|        |                  | ことが明確であり |                  |
|        |                  | 遵守すべき事項。 |                  |
+--------+------------------+------------------+------------------+
| 標　準 | 技術基準         | ●特              | 「･･･            |
|        |                  | 段の事情がない限 | を標準とする。」 |
|        |                  | り記述に従い実施 |                  |
|        |                  | すべきだが、状況 | 「･･･            |
|        |                  | や条件によって一 | を基本とする。」 |
|        |                  | 律に適用すること |                  |
|        |                  | はできない事項。 | 「･･･による。」  |
+--------+------------------+------------------+------------------+
| 推　奨 | 技術資料         | ●状況や条件      | 「               |
|        |                  | によって実施する | ･･･望ましい。」  |
|        |                  | ことが良い事項。 |                  |
|        |                  |                  | 「               |
|        |                  |                  | ･･･推奨する。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･務める。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･必要に応    |
|        |                  |                  | じて･･･する。」  |
+--------+------------------+------------------+------------------+
| 例　示 | 技術資料         | ●適用条件や実施  | 「               |
|        |                  | 効果について確定 | ･･･などの手法（  |
|        |                  | している段階では | 事例）がある。」 |
|        |                  | ないが、状況や条 |                  |
|        |                  | 件によっては導入 | 「･･･など        |
|        |                  | することが可能な | の場合がある。」 |
|        |                  | 新技術等の例示。 |                  |
|        |                  |                  | 「･･･など        |
|        |                  | ●状              | が考えられる。」 |
|        |                  | 況や条件によって |                  |
|        |                  | 限定的に実施でき | 「               |
|        |                  | る技術等の例示。 | ･･･の場合には･･･ |
|        |                  |                  | ことができる。」 |
|        |                  | ●具体的          |                  |
|        |                  | に例示することに | 「               |
|        |                  | より、技術的な理 | ･･･例示する。」  |
|        |                  | 解を助ける事項。 |                  |
|        |                  |                  | 「例えば･･･。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･事例もある  |
|        |                  |                  | 。･･･もよい。」  |
+--------+------------------+------------------+------------------+

  関連通知等       関連する通知やそれを理解する上で参考となる資料
  ---------------- ------------------------------------------------------
  参考となる資料   例示等に示した手法・内容を理解する上で参考となる資料

1.  []{#_Toc81920882 .anchor}総説

    1.  []{#_Toc81920883 .anchor}基本的考え方

＜考え方＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  本章は、構造令で定められる事項に加え、ダムを設計する場合の一般的かつ基本的な規定を示すものである。なお、その適用に当たっては、各項の規定するところに従い、実情に即した適切な判断をする。また、特に堤高が高いダム、あるいは、特殊な条件のダムについては、さらに、特別の配慮を必要とする場合がある。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  ダムは、その計画に基づき、目的と機能に適合し、構造物としての安全性を有するものとした上で、環境・景観との調和、耐久性、維持管理の容易性、施工性、事業実施による地域への影響、経済性及び公衆の利用等を総合的に考慮して設計することを基本とする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

2.  []{#_Toc81920884 .anchor}目的と適用範囲

＜考え方＞

+----------------------------------------------------------------------+
| 構造令を適                                                           |
| 用するダムの範囲は、構造令第3条において以下のように定められている。  |
|                                                                      |
| +                                                                    |
| -------------------------------------------------------------------+ |
| |                                                                    |
|  （適用の範囲）                                                    | |
| |                                                                    |
|                                                                    | |
| |                                                                    |
|  第3条　この章の規定は、次に掲げるダム以外のダムについて適用する。 | |
| |                                                                    |
|                                                                    | |
| |                                                                    |
|  一　土砂の流出を防止し、及び調節するため設けるダム                | |
| |                                                                    |
|                                                                    | |
| |                                                                    |
|  二　基礎地盤から堤頂までの高さが15メートル未満のダム              | |
| +                                                                    |
| -------------------------------------------------------------------+ |
|                                                                      |
| 本章の適用の対象とするダム                                           |
| は、河川を横断して流水を貯留するために設けるダムで、基礎地盤から堤頂 |
| までの高さが15ｍ以上のダムである。ダムの堤体を構成する材料によってダ |
| ムを分類すると、主にコンクリートで構成されるコンクリートダム、堤体の |
| 大部分を岩石、土及び砂で構成されるフィルダムなどに分かれる。コンクリ |
| ートダムは、その構造によって、アーチ式コンクリートダム、重力式コンク |
| リートダム、中空重力式コンクリートダム、バットレスダムに区分される。 |
|                                                                      |
| 土砂の流出を防止し、及び                                             |
| 調節するため設けるダム（砂防堰堤等）については、本章の適用外とする。 |
|                                                                      |
| 高さ15m未満のダムも、事実上のダム高と考えられる現河床から設          |
| 計洪水位までの高さが低く、ダムの上下流に与える影響が小さいこと、構造 |
| 令第3条の適用対象でないこと、実用上、河川法（以下「法」という。）第  |
| 13条第1項の規定で足りると考えられることにより、本章の適用外とする。  |
|                                                                      |
| 堤高 15ｍ                                                            |
| 以上の中空重力式コンクリート                                         |
| ダム、アーチ重力式コンクリートダムについては、本章の規定を準用する。 |
|                                                                      |
| 複数の異                                                             |
| なる種類のダムを組み合わせたダム（いわゆる複合ダム）は、この基準に規 |
| 定するダムの種類に該当する部分に対して、それぞれの該当項を適用する。 |
+----------------------------------------------------------------------+

＜標　準＞

  -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  構造令第3条に基づき、流水を貯留することを目的とした基礎地盤から堤頂までの高さが15ｍ以上の重力式コンクリートダム、アーチ式コンクリートダム及びフィルダムについては、本章を適用することを基本とする。
  -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

18. 建設省河川局長通達：河川管理施設等構造令及び同令施行規則の施行について，昭和51年11月23日，建設省河政発第70号．

＜参考となる資料＞

ダムの設計に関する用語については、下記の資料が参考になる。

19. （財）国土開発技術研究センター編／（社）日本河川協会：改定
    解説・河川管理施設等構造令，平成12年1月．

    1.  []{#_Toc81920885 .anchor}用語の定義

＜考え方＞

+----------------------------------------------------------------------+
| 主要な貯水位の定義                                                   |
| は、構造令第2条第1項から第3項において、以下のように定められている。  |
|                                                                      |
| +----------------------------------------------------------------+   |
| | （用語の定義）                                                 |   |
| |                                                                |   |
| | 第2条　この政令において、次の各                                |   |
| | 号に掲げる用語の意義は、それぞれ当該各号に定めるところによる。 |   |
| |                                                                |   |
| | 一　常時満水位　ダムの新築又は改                               |   |
| | 築に関する計画において非洪水時にダムによって貯留することとした |   |
| | 流水の最高の水位でダムの非越流部の直上流部におけるものをいう。 |   |
| |                                                                |   |
| | 二　サーチャージ水位　ダムの新築又は改築に関                   |   |
| | する計画において洪水時にダムによって一時的に貯留することとした |   |
| | 流水の最高の水位でダムの非越流部の直上流部におけるものをいう。 |   |
| |                                                                |   |
| | 三　設計洪水位　ダムの新築又は改築に関する計画において         |   |
| | 、ダムの直上流の地点において200年につき1回の割合で発生するもの |   |
| | と予想される洪水の流量、当該地点において発生した最大の洪水の流 |   |
| | 量又は当該ダムに係る流域と水象若しくは気象が類似する流域のそれ |   |
| | ぞれにおいて発生した最大の洪水に係る水象若しくは気象の観測の結 |   |
| | 果に照らして当該地点に発生するおそれがあると認められる洪水の流 |   |
| | 量のうちいずれか大きい流量（フィルダムにあっては、当該流量の1. |   |
| | 2倍の流量.以下「ダム設計洪水流量」という。）の流水がダムの洪水 |   |
| | 吐きを流下するものとした場合におけるダムの非越流部の直上流部に |   |
| | おける最高の水位（貯水池の貯留効果が大きいダムにあっては、当該 |   |
| | 水位から当該貯留効果を考慮して得られる値を減じた水位）をいう。 |   |
| |                                                                |   |
| | （第4項～第13項省略）                                          |   |
| +----------------------------------------------------------------+   |
|                                                                      |
| その他、ダムの諸元の定義は以下のとおりとする。                       |
|                                                                      |
| 1\. 堤高は、ダムの基礎地盤面から堤頂までの高さとする。               |
|                                                                      |
| >                                                                    |
| 堤高の基準となる堤頂は、堤体の天端の最高の部分であり、コンクリートダ |
| ムにあっては、非越流部の最上面とし、フィルダムにあっては、非越流部に |
| 遮水ゾーン上部の保護層の厚さを含んだ最上面とするが、高欄、胸壁や堤体 |
| 天端を道路として利用するために付加された部分（舗装など）は含めない。 |
| >                                                                    |
| > 堤高の基準となる基礎地盤面は、止水壁                               |
| （遮水壁及びカーテングラウチングを含む）のないダムでは、基本的に堤頂 |
| の上流端を通る鉛直面と基礎地盤面とが交わる堤体の最低標高部とする（図 |
| > 2-1-1                                                              |
| > 参照）。                                                           |
| また、止水壁のあるダムでは、止水壁直下流の堤体部分をつないだ鉛直面が |
| 基礎地盤面と交わる堤体の最低標高部とする。ただし、堤体部に傾斜した遮 |
| 水壁を持つ場合（表面遮水壁型フィルダム、傾斜コア型フィルダム等）はそ |
| の直下流の堤体の最低標高部となる。なお、止水壁のうち、地中連続壁等の |
| 基礎地盤面内に埋設された部分及びフィルダムの監査廊は堤高に含めない。 |
|                                                                      |
| 2\.                                                                  |
| ダム軸                                                               |
| 面は、河川を横断する方向でのダムの構造設計上基準となる鉛直面とする。 |
|                                                                      |
| > ダム軸面                                                           |
| とは、河川を横断する方向でのダムのほぼ中心を示すダムの構造設計上基準 |
| となる鉛直面であり、重力式コンクリートダムにおいては基本三角形の頂点 |
| を連ねた線を含む鉛直面、アーチ式コンクリートダム及びフィルダムにおい |
| ては堤頂の横断方向の中点を連ねた線を含む鉛直面とする。なお、表面遮水 |
| 壁型フィルダムにあっては天端の上流端を連ねた線を含む鉛直面を用いる。 |
| >                                                                    |
| > ダム軸面は、堤体部における定義であるの                             |
| で、堤体をはずれた両岸の岩盤部での定義は特には行わないが、便宜上使用 |
| する場合は、通常カーテングラウチングの中心面をもってダム軸面とする。 |
| >                                                                    |
| > なお、アーチ式コンクリート                                         |
| ダムのダム軸は、手計算を主体とした解析と設計を行っていた時代は、アー |
| チの円弧を平面形状の基線とした場合は下流面を基準とし、外力としての水 |
| 圧の計算を優先する場合は上流面を基準とし、統一されていなかった。電子 |
| 計算機による解析を行う現在では、上流面よりも構造物の中心であるダムの |
| 中心線を基準とする方が解析上も都合がよく、これをダム軸として用いる。 |
|                                                                      |
| 3\.                                                                  |
| 堤頂                                                                 |
| 長は、ダム軸面と堤頂標高の水平面との交線上のダムの堤体の長さとする。 |
|                                                                      |
| > 堤頂長には、堤体に隣接する道路部分、フィルダムに                   |
| おける洪水吐きコンクリート部分は含めないが、フィルダムの堤頂部に隣接 |
| する部分の洪水吐きの幅は（　）書きで併記する。なお、複合ダムの場合は |
| 、堤体のコンクリート部分及びフィル部分の堤頂長の総和を堤頂長とする。 |
|                                                                      |
| 4\.                                                                  |
| ダムの堤体とは、河川を横断して流水を貯留するため設けられる構造物及   |
| びこれと一体不可分としてその効用を果たす部分のうち、基礎地盤内に設け |
| られた構造物を除いた部分とする。また、堤体積とは堤体の実体積とする。 |
|                                                                      |
| > コンクリートダムの堤体には、フィレット、                           |
| フーチング等堤体の安定上一体となる部分及び堤体を保護する部分を含める |
| 。また、堤体上に一体として設置される洪水吐きも堤体に含めるが、本体部 |
| と分離した洪水吐き、基礎処理と考えられる断層置換え等は堤体に含めない |
| 。中空重力式コンクリートダムの場合は、実コンクリート部を堤体とする。 |
| >                                                                    |
| > フィルダムの堤体には、堤体保護部、洪水吐き接合部等堤体と一体となる |
| 部分を含める。なお、洪水吐き、減勢工等のコンクリート部分、基礎処理と |
| 考えられる断層置換え、止水ブランケット、堤体上流側の埋戻し部、または |
| 、堤体背面の盛土等で堤体自体の安定上必要でない部分は堤体に含めない。 |
|                                                                      |
| ![](media/image140.png){width="6.15200021872266in"                   |
| height="3.2646872265966755in"}                                       |
|                                                                      |
| 93. 各種のダムの堤高                                                 |
+----------------------------------------------------------------------+

＜必　須＞

  ---------------------------------------------------------------------------------------------------------------------------
  ダムの設計に用いる主要な貯水位である常時満水位、サーチャージ水位、設計洪水位は構造令第2条第1項から第3項によるものとする。
  ---------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

20. 建設省河川局長通達：河川管理施設等構造令及び同令施行規則の施行について，昭和51年11月23日，建設省河政第70号．

21. 河川管理施設等構造令及び同令施行規則の運用について：昭和52年2月1日，建設省河政発第6号，建設省河開発第9号．

＜参考となる資料＞

ダムの設計に関する用語や考え方については、下記の資料が参考になる。

22. （財）国土開発技術研究センター編／（社）日本河川協会：改定
    解説・河川管理施設等構造令，平成12年1月．

第2章 ダムの設計 {#第2章-ダムの設計-1 .目次の見出し1}
================

第2節　ダムの基本形状、型式及び位置の決定 {#第2節-ダムの基本形状型式及び位置の決定 .目次の見出し1}
=========================================

目　次 {#目-次-7 .目次の見出し1}
======

[第2節 ダムの基本形状、型式及び位置の決定 1](#_Toc81931336)

> [2．1 ダムの基本形状 1](#_Toc81931337)
>
> [2．1．1 堤体の非越流部の高さ 1](#_Toc81931338)
>
> [2．1．2 ダム設計洪水流量 5](#_Toc81931339)
>
> [2．2 ダムの位置の選定 8](#_Toc81931340)
>
> [2．3 ダムの型式の選定 9](#_Toc81931341)
>
> [2．4 ダムの配置設計 10](#_Toc81931342)
>
> [2．4．1 重力式コンクリートダムの配置設計 10](#_Toc81931343)
>
> [2．4．2 アーチ式コンクリートダムの配置設計 12](#_Toc81931344)
>
> [2．4．3 フィルダムの配置設計 13](#_Toc81931345)

令和3年10月　版

適用上の位置付け

　河川砂防技術基準設計編は、基準の適用上の位置付けを明確にするために、下表に示すように適用上の位置付けを分類している。

+--------+------------------+------------------+------------------+
| 分　類 | 適用上の位置付け | 末尾の字句例     |                  |
+--------+------------------+------------------+------------------+
| 考え方 | 技術資料         | ●目              | 「･･･ある。      |
|        |                  | 的や概念、考え方 | 」「･･･いる。」  |
|        |                  | を記述した事項。 |                  |
|        |                  |                  | 「･･･なる。      |
|        |                  |                  | 」「･･･れる。」  |
+--------+------------------+------------------+------------------+
| 必　須 | 技術基準         | ●法令による規定  | 「･･･なければ    |
|        |                  | や技術的観点から | ならない。」「･  |
|        |                  | 実施すべきである | ･･ものとする。」 |
|        |                  | ことが明確であり |                  |
|        |                  | 遵守すべき事項。 |                  |
+--------+------------------+------------------+------------------+
| 標　準 | 技術基準         | ●特              | 「･･･            |
|        |                  | 段の事情がない限 | を標準とする。」 |
|        |                  | り記述に従い実施 |                  |
|        |                  | すべきだが、状況 | 「･･･            |
|        |                  | や条件によって一 | を基本とする。」 |
|        |                  | 律に適用すること |                  |
|        |                  | はできない事項。 | 「･･･による。」  |
+--------+------------------+------------------+------------------+
| 推　奨 | 技術資料         | ●状況や条件      | 「               |
|        |                  | によって実施する | ･･･望ましい。」  |
|        |                  | ことが良い事項。 |                  |
|        |                  |                  | 「               |
|        |                  |                  | ･･･推奨する。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･務める。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･必要に応    |
|        |                  |                  | じて･･･する。」  |
+--------+------------------+------------------+------------------+
| 例　示 | 技術資料         | ●適用条件や実施  | 「               |
|        |                  | 効果について確定 | ･･･などの手法（  |
|        |                  | している段階では | 事例）がある。」 |
|        |                  | ないが、状況や条 |                  |
|        |                  | 件によっては導入 | 「･･･など        |
|        |                  | することが可能な | の場合がある。」 |
|        |                  | 新技術等の例示。 |                  |
|        |                  |                  | 「･･･など        |
|        |                  | ●状              | が考えられる。」 |
|        |                  | 況や条件によって |                  |
|        |                  | 限定的に実施でき | 「               |
|        |                  | る技術等の例示。 | ･･･の場合には･･･ |
|        |                  |                  | ことができる。」 |
|        |                  | ●具体的          |                  |
|        |                  | に例示することに | 「               |
|        |                  | より、技術的な理 | ･･･例示する。」  |
|        |                  | 解を助ける事項。 |                  |
|        |                  |                  | 「例えば･･･。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･事例もある  |
|        |                  |                  | 。･･･もよい。」  |
+--------+------------------+------------------+------------------+

  関連通知等       関連する通知やそれを理解する上で参考となる資料
  ---------------- ------------------------------------------------------
  参考となる資料   例示等に示した手法・内容を理解する上で参考となる資料

1.  []{#_Toc81931336 .anchor}ダムの基本形状、型式及び位置の決定

    1.  []{#_Toc81931337 .anchor}ダムの基本形状

＜考え方＞

+----------------------------------------------------------------------+
| ダムの基本形状とは、ダムの高                                         |
| さ、横断面形状、平面形状、左右岸取付部の深さ、洪水吐きの形状をいう。 |
|                                                                      |
| ダムの                                                               |
| 高さは、貯水池計画で定められる常時満水位、サーチャージ水位、設計洪水 |
| 位を基に本章2.1.1に示す方法で求めた非越流部の高さに基づいて定める。  |
|                                                                      |
| ダムの堤体の横断面形状は、本章3.4で規定す                            |
| る予想される荷重の組合せに対して、必要な安定性を確保するよう定める。 |
|                                                                      |
| ダムの堤体の平面形状は                                               |
| 、特に3次元構造として設計されるアーチ式コンクリートダムにおいては、  |
| 予想される荷重の組合せに対して、必要な安定性を確保するように定める。 |
|                                                                      |
| ダムの堤体の左右岸                                                   |
| 取付部の深さは、予想される荷重の組合せまたは、浸透流に対して、十分な |
| 強度、変形性、遮水性を有するように、基礎地盤の状態に基づいて定める。 |
|                                                                      |
| ダムは想定される最大規模の                                           |
| 流量を安全に流下させうる放流能力を持った洪水吐きを有する必要がある。 |
|                                                                      |
| なお、想定される最大規模の流量としてダム設計洪水流量を採用する。     |
+----------------------------------------------------------------------+

＜必　須＞

  ----------------------------------------------------------------------------------------
  ダムの基本形状は、必要な非越流部の高さや洪水吐きの能力等を勘案して決定するものとする。
  ----------------------------------------------------------------------------------------

＜関連通知等＞

23. 建設省河川局長通達：河川管理施設等構造令及び同令施行規則の施行について，昭和51年11月23日，建設省河政発第70号．

＜参考となる資料＞

ダムの基本形状を決定する上で勘案すべき事項については、下記の資料が参考となる。

24. （財）国土開発技術研究センター編／（社）日本河川協会：改定
    解説・河川管理施設等構造令，平成12年1月．

    1.  []{#_Toc81931338 .anchor}堤体の非越流部の高さ

＜考え方＞

+----------------------------------------------------------------------+
| 堤体の非越流部の高                                                   |
| さは、常時満水位、サーチャージ水位、設計洪水位のそれぞれに所要の付加 |
| 高さを加え、このうち最も高い値以上で、当該ダムの実情に応じて定める。 |
|                                                                      |
| 非越流部の高さは、構造令第5条において、以下のように定められている。  |
|                                                                      |
| +----------------------------------------------------------------+   |
| | （堤体の非越流部の高さ）                                       |   |
| |                                                                |   |
| | 第5条　ダムの堤体の非越流部の高さは、洪                        |   |
| | 水吐きゲートの有無に応じ、コンクリートダムにあっては次の表の下 |   |
| | 欄に掲げる値のうち最も大きい値以上、フィルダムにあっては同欄に |   |
| | 掲げる値のうち最も大きい値に1mを加えた値以上とするものとする。 |   |
| |                                                                |   |
| | +-------------------+----------------+-------------------+     |   |
| | | 項                | 区 分          | 堤体の            |     |   |
| | |                   |                | 非越流部の高さ（  |     |   |
| | |                   |                | 単位　メートル）  |     |   |
| | +-------------------+----------------+-------------------+     |   |
| | | 1                 | 洪水吐きゲート | $$H_{n} +         |     |   |
| | |                   |                |  h_{w} + h_{e} +  |     |   |
| | |                   | を有するダム   | 0.5\ \ \ \left( h |     |   |
| | |                   |                | _{w} + h_{e} < 1. |     |   |
| | |                   |                | 5\ \ のときは　H_ |     |   |
| | |                   |                | {n} + 2 \right)$$ |     |   |
| | |                   |                |                   |     |   |
| | |                   |                | $${H_{s} +        |     |   |
| | |                   |                | h_{w} + \frac{h_{ |     |   |
| | |                   |                | e}}{2} + 0.5\ \ \ |     |   |
| | |                   |                |  \left( h_{w} + \ |     |   |
| | |                   |                | frac{h_{e}}{2} <  |     |   |
| | |                   |                | 1.5\ \ のときは　 |     |   |
| | |                   |                | H_{s} + 2 \right) |     |   |
| | |                   |                | }{H_{d} + h       |     |   |
| | |                   |                | _{w} + 0.5\ \ \ \ |     |   |
| | |                   |                | left( h_{w} < 0.5 |     |   |
| | |                   |                | \ \ のときは　H_{ |     |   |
| | |                   |                | d} + 1 \right)}$$ |     |   |
| | +-------------------+----------------+-------------------+     |   |
| | | 2                 | 洪水吐きゲート | $$H_{n}           |     |   |
| | |                   |                | + h_{w} + h_{e}\t |     |   |
| | |                   | を有しないダム | ext{\ \ \ }\left( |     |   |
| | |                   |                |  h_{w} + h_{e} <  |     |   |
| | |                   |                | 2\ \ のときは　H_ |     |   |
| | |                   |                | {n} + 2 \right)$$ |     |   |
| | |                   |                |                   |     |   |
| | |                   |                | $${H_{s} +        |     |   |
| | |                   |                |  h_{w} + \frac{h_ |     |   |
| | |                   |                | {e}}{2}\text{\ \  |     |   |
| | |                   |                | \ }\left( h_{w} + |     |   |
| | |                   |                |  \frac{h_{e}}{2}  |     |   |
| | |                   |                | < 2\ \ のときは　 |     |   |
| | |                   |                | H_{s} + 2 \right) |     |   |
| | |                   |                | }{H_{d} +         |     |   |
| | |                   |                | h_{w}\text{\ \ \  |     |   |
| | |                   |                | }\left( h_{w} < 1 |     |   |
| | |                   |                | \ \ のときは　H_{ |     |   |
| | |                   |                | d} + 1 \right)}$$ |     |   |
| | +-------------------+----------------+-------------------+     |   |
| | | 備考　            |                |                   |     |   |
| | | 　　　　　　　　  |                |                   |     |   |
| | | 　　　　　　　　  |                |                   |     |   |
| | | 　　　　　　　　  |                |                   |     |   |
| | | 　　　　　　　　  |                |                   |     |   |
| | | 　　　　　　　　  |                |                   |     |   |
| | |                   |                |                   |     |   |
| | | この表におい      |                |                   |     |   |
| | | て、*H~n~*、*h~w~ |                |                   |     |   |
| | | *、*h~e~*、*H~s~* |                |                   |     |   |
| | | 及び*H~d~*        |                |                   |     |   |
| | | は、そ            |                |                   |     |   |
| | | れぞれ次の数値を  |                |                   |     |   |
| | | 表すものとする。  |                |                   |     |   |
| | |                   |                |                   |     |   |
| | | 　*H~             |                |                   |     |   |
| | | n~*　常時満水位（ |                |                   |     |   |
| | | 単位　メートル）  |                |                   |     |   |
| | |                   |                |                   |     |   |
| | | 　*h~w~*　風によ  |                |                   |     |   |
| | | る波浪の貯水池の  |                |                   |     |   |
| | | 水面からの高さ（  |                |                   |     |   |
| | | 単位　メートル）  |                |                   |     |   |
| | |                   |                |                   |     |   |
| | | 　                |                |                   |     |   |
| | | *h~e~*　地震によ  |                |                   |     |   |
| | | る波浪の貯水池の  |                |                   |     |   |
| | | 水面からの高さ（  |                |                   |     |   |
| | | 単位　メートル）  |                |                   |     |   |
| | |                   |                |                   |     |   |
| | | 　*H~s~*　サ      |                |                   |     |   |
| | | ーチャージ水位（  |                |                   |     |   |
| | | 単位　メートル）  |                |                   |     |   |
| | |                   |                |                   |     |   |
| | | 　*H~             |                |                   |     |   |
| | | d~*　設計洪水位（ |                |                   |     |   |
| | | 単位　メートル）  |                |                   |     |   |
| | +-------------------+----------------+-------------------+     |   |
| |                                                                |   |
| | 2　洪水吐きゲートを有しないフィルダムで、ダ                    |   |
| | ム設計洪水流量の流水が洪水吐きを流下する場合における越流水深が |   |
| | 2.5メー                                                        |   |
| | トル以下であるものに関する前項の規定の適用については、同項の表 |   |
| | 2の項の下欄中、「$\ h_{w} + h_{e} < 2\ \ のときは　H_{n} + 2$  |   |
| | 」とあ                                                         |   |
| | るのは、「$\ h_{w} + h_{e} < 1\ \ のときは　H_{n} + 1$」と、「 |   |
| | $h_{w} + \frac{h_{e}}{2} < 2\ \ のときは　H_{s} + 2$           |   |
| | 」とあ                                                         |   |
| | るのは、「$h_{w} + \frac{h_{e}}{2} < 1\ \ のときは　H_{s} + 1$ |   |
| | 」とする。                                                     |   |
| +----------------------------------------------------------------+   |
|                                                                      |
| 風による波浪の                                                       |
| 高さは、常時満水位、サーチャージ水位、設計洪水位それぞれの水位の状態 |
| における貯水池水面以上の波浪高さを採用することが考えられるが、便宜的 |
| に設計洪水位の状態における貯水池水面からの波浪高さをもって、サーチャ |
| ージ水位、常時満水位の状態における貯水池水面からの波浪高さとみなす。 |
|                                                                      |
| 地震による波浪の                                                     |
| 貯水池水面からの高さについても、常時満水位、サーチャージ水位のそれぞ |
| れの貯水池水位の状態における貯水池水面からの高さを採用することが考え |
| られるが、常時満水位の状態における貯水池水面からの波浪高さを基準とし |
| 、サーチャージ水位における波浪の高さは、常時満水位の波浪の高さの1/2  |
| とする。                                                             |
|                                                                      |
| ゾーン型及び均一型のフィ                                             |
| ルダムでは付加高さを決定する場合、頂部の保護層は付加高さに加えず、図 |
| 2-2-1に示すように遮水ゾーンの頂部を非越流部の高さとする。            |
|                                                                      |
| ![](media/image141.png){width="4.667361111111111in"                  |
| height="2.1333333333333333in"}                                       |
|                                                                      |
| 94. ダム堤頂付近標準図                                               |
+----------------------------------------------------------------------+

＜必　須＞

  ---------------------------------------------------------------------------------------------------------------------------
  ダムの堤体の非越流部の高さは、ダムの種類及び洪水吐きゲートの有無に応じ、構造令第5条で定める方法に従い決定するものとする。
  ---------------------------------------------------------------------------------------------------------------------------

＜例　示＞

風による波浪の高さは、S.M.B法におけるWilsonの改良式により求めること等が考えられる。堤体の上流面がほぼ鉛直な場合は、反射波を考えて、貯水池水面からの波浪高さは2倍の半波高すなわち全波高となるので、次式により計算する（図
2-2-2、図 2-2-3参照）。

　$\text{\ \ \ \ }h_{w} = 0.00077V \bullet F^{0.5}$

　　*V*：10分間平均風速（m/s）（一般に、30m/sないしは20m/sをとることが多い）

　　*F*：設計洪水位におけるダムの堤体からの最大対岸距離（m）

また、フィルダムのように上流面が傾斜している場合には、堤体に沿った波の打上げ高を考慮し、Savilleの方法を用いること等が考えられる。

図
2-2-4は、S.M.B法によって求めた波高とSavilleの方法により導かれた上流面の斜面勾配、斜面保護材料及び打上げ高／波高との関係を組み合わせ、対岸距離及び風速から波高を含めた打上げ高（*R*）をもとめられるようにしたものである。

　地震による波浪高さの計算は、佐藤清一の次式により求めること等が考えられる。

　$\text{\ \ \ \ }h_{e} = \frac{1}{2} \bullet \frac{\text{Kτ}}{\pi}\sqrt{gH_{o}}$

　　*K*：常時満水位の状態における設計震度

　　$\tau$：地震周期（地震動の卓越周期）（s）（１秒とすることが多い）

　　*H~o~*：常時満水位の状態における貯水池の水深（m）

　　*g*：重力の加速度 9.8m/s^2^

例えば*K*＝0.15、$\tau$＝1秒、*H~o~*＝60～100mで*h~e~*＝0.6
～0.7mである。

なお、流水型ダムのように常時満水位時の水深がきわめて浅い場合には、地震による波浪高さ*h~e~*を、上式の*H~o~*にサーチャージ水位時の貯水池の水深を代入して算出する場合がある。

![](media/image142.png){width="4.100694444444445in" height="3.0in"}

95. S.M.B法におけるWilsonの改良式によって求めた波高

    ![](media/image143.png){width="5.7144378827646545in"
    height="1.7207600612423446in"}

96. 貯水池の水面からの波浪高さ

![](media/image144.png){width="4.39375in" height="3.313888888888889in"}

97. S.M.B法におけるWilsonの改良式とSavilleの方法とを

    組み合わせて求めた打上げ高（波高を含む）

＜関連通知等＞

25. 建設省河川局水政課長、開発課長通達：河川管理施設等構造令及び同令施行規則の運用について，昭和52年2月1日，建設省河政発第6号・建設省河開発第9号．

＜参考となる資料＞

ダムの堤体の非越流部の高さを決定する際の付加高さの算定については、下記の資料が参考となる。

26. （財）国土開発技術研究センター編／（社）日本河川協会：改定
    解説・河川管理施設等構造令，平成12年1月．

    1.  []{#_Toc81931339 .anchor}ダム設計洪水流量

＜考え方＞

+----------------------------------------------------------------------+
| ダム設計洪水流量及び設計洪水位は、ダム地点の                         |
| 洪水に関してダムの安全性を確保するため定められる重要な基本量である。 |
|                                                                      |
| ダム設計洪水流量及び設計洪水位は、ダムの計画において、ダム           |
| 堤体の非越流部の高さ、ダムの堤体及び基礎地盤の安定計算に使用される水 |
| 位、ならびに洪水吐きの流下能力を決定するために用いられるものである。 |
|                                                                      |
| ダム設計洪水流量及び設計                                             |
| 洪水位は、構造令第2条第3項（本章1.3参照）において、定められている。  |
|                                                                      |
| フィルダムでは、洪水が堤体を越流した場                               |
| 合の危険性を考慮して、コンクリートダムの場合のダム設計洪水流量の1.2  |
| 倍の流量をダム設計洪水流量として定める。                             |
|                                                                      |
| ダムの堤体がコンクリートダムとフィルダムの両者で構成される複合ダ     |
| ムの場合、ダム設計洪水流量は、フィルダムのダム設計洪水流量を用いる。 |
|                                                                      |
| 貯水池が                                                             |
| 導水による間接流域を有する場合のダム設計洪水流量は、貯水池へ直接流入 |
| する直接流域を対象として上述の方法により求められる流量（直接流域ダム |
| 設計洪水流量）に、間接流域から導水され得る流量を加えた流量とする。間 |
| 接流域から導水され得る流量は、導水地点の洪水流量及び取水・導水施設等 |
| の構造等を勘案して設定し、導水地点の洪水流量は、間接流域を対象として |
| 、ダム設計洪水流量と同様の方法で求める（間接流域ダム設計洪水流量）。 |
|                                                                      |
| なお、                                                               |
| 間接流域の導水地点下流にダムが設けられる場合の下流ダムのダム設計洪水 |
| 流量については、上述の導水流量が、一般に取水・導水施設計画以上の流量 |
| となり導水の確実性に疑問があること等、確実に導水される流量を意味しな |
| いことから、導水によるダム設計洪水流量の低減は、原則として行わない。 |
|                                                                      |
| また、取水・導水施設にゲートが設けられ操作が行われる場合においても、 |
| 間接流域ダム設計洪水流量が発生するような出水に対する確実なゲート操作 |
| が、施設の構造計画、洪水処理計画及び管理画上担保されない限りにおいて |
| は、ゲート全開の状態により、間接流域から導水され得る流量を算出する。 |
+----------------------------------------------------------------------+

＜必　須＞

  --------------------------------------------------------------------------------------------------------------------------
  ダムの堤体及び洪水吐きの設計において基本となるダム設計洪水流量は、構造令第2条第3項で定める方法に従い決定するものとする。
  --------------------------------------------------------------------------------------------------------------------------

＜例　示＞

ダムの堤体がコンクリートダムとフィルダムの両者で構成される複合ダムの場合、ダム設計洪水流量は、フィルダムのダム設計洪水流量を用いることとしているが、コンクリートダムがダムの堤体の主たる構成要素である複合ダムの場合のコンクリートダム部の非越流部高さ及びその決定に用いる設計洪水位の算出においては、コンクリートダムとして求めたダム設計洪水流量を用いることができる。すなわち、コンクリートダム部及びフィルダム部について、それぞれの種類のダムとしての設計洪水位、非越流部の高さを設定し、設計することができる。この場合、コンクリートダムの堤体上に洪水吐きが設けられ、かつ
1.2倍の流量が流下することによる導流部、減勢工導流壁からの越流や減勢工での流況の悪化が、フィルダムの堤体の安全に支障ないと判断される場合には、洪水吐きの構成要素のうち導流部、減勢工の設計におけるダム設計洪水流量としてコンクリートダムとして求めたダム設計洪水流量を用いることができる。

ダム地点の流域と類似する流域の洪水の観測結果に照らして、当該ダム地点に発生する恐れがあると認められる洪水の流量は、地域別比流量図（図
2-2-5、表 2-2-1、図
2-2-6参照）から算出される流量を基にして定めるなどの手法がある。ただし、地域別比流量図の数値は、それぞれの流域における下限値を示すものであるから、その適用にあたっては、当該ダム流域と水象もしくは気象が類似する流域において発生した降雨や流量の観測資料を用い、降雨の観測資料を用いる場合は適正な流出解析を実施して、その妥当性を確認することができる。

当該ダムの流域面積が 20 km^2^
以下である場合には、地域別比流量図から求められる流量以上の流量で、当該ダム流域の実情に応じた数値がダム設計洪水流量として定められるが、流域面積が1
km^2^未満の場合の地域別比流量図から求められる流量は、1
km^2^の場合の比流量値より求められる流量とする場合が多い。

貯水池が導水による間接流域を有する場合は、地域別比流量図に見られるように、集水面積が大きくなると、比流量は小さくなる傾向にあるので、直接流域ダム設計洪水流量発生時の導水地点洪水流量は、上述の方法で求めた間接流域ダム設計洪水流量より小さいことが考えられるため、この影響を適切に評価することができる場合には、検討の対象とする導水地点の洪水流量を低減することができる。

比流量曲線式

$$\ \ \ q = C \bullet A^{\left( A^{- 0.05} - 1 \right)}$$

*q*：比流量（m^3^ / sec / km^2^）

*A*：集水面積（km^2^）

*C*：地域係数

![](media/image145.png){width="3.8472222222222223in"
height="3.4402777777777778in"}

98. 地域別比流量図

```{=html}
<!-- -->
```
66. 地域別比流量図の地域係数

+---------------+----------+-----------------------------------------+
| 地　　　域    | 地域係数 | 適　　　　用　　　　地　　　　域        |
|               |          |                                         |
|               | *C*      |                                         |
+---------------+----------+-----------------------------------------+
| ①　北海道     | 17       | 北海道全域                              |
+---------------+----------+-----------------------------------------+
| ②　東北       | 34       | 青森・岩手・宮城・秋田・                |
|               |          | 山形・福島（阿賀野川流域を除く）の各県  |
+---------------+----------+-----------------------------------------+
| ③　関東       | 48       | 茨城・栃木・群馬(信濃川流域             |
|               |          | を除く)・埼玉・東京・千葉・神奈川の各都 |
|               |          |                                         |
|               |          | 県、山梨県のうち多摩川                  |
|               |          | 、相模川流域及び静岡県のうち酒匂川流域  |
+---------------+----------+-----------------------------------------+
| ④　北陸       | 43       | 新潟・富山・石川の各県、福島県          |
|               |          | のうち阿賀野川流域、群馬県のうち信濃川  |
|               |          |                                         |
|               |          | 流域、長野県のうち信濃川・              |
|               |          | 姫川流域、岐阜県のうち神通川・庄川流域  |
|               |          | 及び福井県のうち九頭竜川流域以北の地域  |
+---------------+----------+-----------------------------------------+
| ⑤　中部       | 44       | 山梨県及び静岡県のうち③に               |
|               |          | 属する地域を除く地域、長野県及び岐阜県  |
|               |          |                                         |
|               |          | のうち④に属する地域を除く               |
|               |          | 地域、愛知県及び三重県（淀川流域及び櫛  |
|               |          |                                         |
|               |          | 田川流域以南の地域を除く）              |
+---------------+----------+-----------------------------------------+
| ⑥　近畿       | 41       | 滋賀県、京都府のうち淀川流域            |
|               |          | 、大阪府、奈良県のうち淀川流域及び大和  |
|               |          |                                         |
|               |          | 川流域、三重県のうち淀                  |
|               |          | 川流域及び兵庫県のうち神戸市以東の地域  |
+---------------+----------+-----------------------------------------+
| ⑦　紀伊南部   | 80       | 三重県のうち櫛田川流域以南の            |
|               |          | 地域、奈良県のうち⑥に属する地域を除く地 |
|               |          |                                         |
|               |          | 域及び和歌山県                          |
+---------------+----------+-----------------------------------------+
| ⑧　山陰       | 44       | 福井県のうち④に属する地域を             |
|               |          | 除く地域、京都府のうち⑥に属する地域を除 |
|               |          |                                         |
|               |          | く地域、兵庫県のうち日本海に            |
|               |          | 河口を有する流域の地域、鳥取、島根の各  |
|               |          |                                         |
|               |          | 県、広島県のうち江の川流                |
|               |          | 域及び山口県のうち佐波川流域以西の地域  |
+---------------+----------+-----------------------------------------+
| ⑨　瀬戸内     | 37       | 兵庫県のうち⑥及び⑧に属す                |
|               |          | る地域を除く地域、岡山県、広島県及び山  |
|               |          |                                         |
|               |          | 口県のうち⑧に属する地域を除             |
|               |          | く地域、香川県、愛媛県のうち⑩に属する地 |
|               |          |                                         |
|               |          | 域を除く地域                            |
+---------------+----------+-----------------------------------------+
| ⑩　四国南部   | 84       | 徳島県、高知県、愛媛県のうち            |
|               |          | 吉野川・仁淀川流域及び肱川流域以南の地  |
|               |          |                                         |
|               |          | 域                                      |
+---------------+----------+-----------------------------------------+
| ⑪　九州・沖縄 | 56       | 九州各県及び沖縄県                      |
+---------------+----------+-----------------------------------------+
|               |          |                                         |
+---------------+----------+-----------------------------------------+

（注）地域④のうち長野県に属する信濃川流域及び地域⑤のうち長野県に属する天竜川流域については、当該地域の地域係数Ｃを35以上とすることができる。

![](media/image146.png){width="5.247222222222222in"
height="4.160416666666666in"}

99. 地域別比流量図の地域区分（図中の番号は表 2-2-1に示すもの）

＜関連通知等＞

27. 建設省河川局長通達：河川管理施設等構造令及び同令施行規則の施行について，昭和51年11月23日，建設省河政発第70号．

28. 建設省河川局水政課長、開発課長通達：河川管理施設等構造令及び同令施行規則の運用について：昭和52年2月1日，建設省河政発第6号，建設省河開発第9号．

＜参考となる資料＞

ダム設計洪水流量の算出方法については、下記の資料が参考となる。

29. （財）国土開発技術研究センター編／（社）日本河川協会：改定
    解説・河川管理施設等構造令，平成12年1月.

    1.  []{#_Toc81931340 .anchor}ダムの位置の選定

＜考え方＞

+----------------------------------------------------------------------+
| ダムの位置を決定する作業は、必要な貯水容量が最も効率的に確保可能なサ |
| イトを、地域の社会経済、自然環境なども十分考慮して選定（以下、「サイ |
| ト選定」という。）した上で、当該サイトにおいて、安全かつ最も経済的に |
| ダムの建設が可能な配置を定める（以下、「配置設計」という。）手順で行 |
| う。なお、この配置を定める作業は、通常、「座取り」とも呼ばれている。 |
|                                                                      |
| サイト選                                                             |
| 定は、目的とする治水・利水機能が確保され、所要の貯水容量が得られる複 |
| 数の候補サイトの中から、地形・地質調査、環境調査等の調査結果、水没地 |
| 域の実態、経済性などを総合的に勘案して最適な位置を選定するよう行う。 |
|                                                                      |
| サイト選定、配置設                                                   |
| 計の各段階に応じて、基礎岩盤やその周辺の地質調査、第四紀断層調査、貯 |
| 水池周辺地すべり等の調査、堤体材料調査、環境調査などを系統的かつ効率 |
| 的に行い、これらの課題の把握や対応について検討することが重要である。 |
+----------------------------------------------------------------------+

＜必　須＞

  ------------------------------------------------------------------------------------------------------
  ダムの位置は、ダムの高さ、地形、地質、洪水処理の方法等の諸条件を総合的に検討し、選定するものとする。
  ------------------------------------------------------------------------------------------------------

＜参考となる資料＞

ダムの位置の選定方法については、下記の資料が参考となる。

30. （財）ダム技術センター：多目的ダムの建設　平成17年版　第2巻　環境・調査Ⅰ編，平成17年6月．

    1.  []{#_Toc81931341 .anchor}ダムの型式の選定

＜考え方＞

+----------------------------------------------------------------------+
| ダム                                                                 |
| 型式は、堤体材料から主にコンクリートダム及びフィルダムに分類される。 |
|                                                                      |
| コンクリートダムは                                                   |
| 、力学的な特性により主に重力式コンクリートダムとアーチ式コンクリート |
| ダムに、フィルダムは、堤体材料によってアースダムとロックフィルダムに |
| 分類され、また遮水機能を果たす部分の構造により均一型ダム、ゾーン型ダ |
| ム、表面遮水壁型ダムに分類される。なお、上記以外の台形CSGダムやフィ  |
| ルダムで表面遮水壁型ダムとするような特殊な構造のダムとする場合には、 |
| 構造令第73条第4項（いわゆる大臣特認制度）の手続きをとる必要がある。  |
|                                                                      |
| 一般に重力式コンクリートダムは地形、地質、洪水吐きの規模の面から     |
| みて、アーチ式コンクリートダムと比べて比較的制約の少ない型式である。 |
|                                                                      |
| 谷幅が狭く、平面形状がアーチ推力を安全に支持できるような             |
| 地形、地質の場合は、アーチ式コンクリートダムが有利となる場合がある。 |
|                                                                      |
| フ                                                                   |
| ィルダムの場合は、コンクリートダムに比較して、地形、地質上の制約は少 |
| ないが、堤体と別個に洪水吐きを設けなければならないことから、洪水規模 |
| が大きい場合、コンクリートダムに比べ不利となる。また、堤体積が大きく |
| なることから、ダムサイト周辺で堤体材料を採取できる場合に有利となる。 |
|                                                                      |
| これらの分類から、目的に対し所要の機能を十分に発揮す                 |
| る上で必要な安全性を最も合理的に確保できるようダムの型式を選定する。 |
+----------------------------------------------------------------------+

＜必　須＞

  ----------------------------------------------------------------------------------------------------------------------------
  ダムの型式は、ダムの規模、ダム地点の地形、地質、洪水吐きの規模及び堤体材料等の諸条件を総合的に検討し、決定するものとする。
  ----------------------------------------------------------------------------------------------------------------------------

＜例　示＞

ダムの主な型式ごとの特性を以下に例示する。また、複数のダムの型式を組み合わせて建設する事例もある。

1．重力式コンクリートダム

> 重力式コンクリートダムは、貯水の水圧等の荷重を堤体の自重によって下方の基礎岩盤に伝達する構造物であり、必然的に大きな堤体断面を要求される。このため、基礎岩盤に作用する単位面積当たりの荷重はアーチ式コンクリートダムに比べ小さくなるが、基礎岩盤としてダム高に応じた十分なせん断強度を有する岩盤が必要である。水平または、これに近い断層、弱層が存在する場合には十分な注意が必要である。
>
> 堤体については、同一堤高のアーチ式コンクリートダムに比べ堤体断面が大きいことから、一般に発生応力は小さく、上流面に生じる鉛直方向の引張応力や、堤高が特に高いダムにおける下流部の圧縮応力を除けば、堤体の強度が問題となることは少ない。

2．アーチ式コンクリートダム

> アーチ式コンクリートダムは、貯水の水圧等の荷重を主として堤体のアーチ作用によって左右岸の基礎岩盤に伝達する構造物であり、堤体断面を適切に選定すれば、コンクリートの強度を最大限に利用できる薄さまで、堤体断面を小さくすることができる。しかし、反面、基礎岩盤に伝達する単位面積当たりの荷重は大きくなり、重力式コンクリートダムに比べ、基礎岩盤の地形、地質の制約を受けやすい。よって、アーチ式コンクリートダムの基礎岩盤に対しては、重力式コンクリートダムに比べて剛性、強度に関する制約が大きくなる。
>
> また、アーチ作用による荷重を基礎岩盤の厚みで支える必要があるため、アーチ式コンクリートダムのアバットメントの下流には十分な厚みを有する基礎岩盤が要求され、基礎岩盤内にアーチ作用を受けたときにすべりやすい方向の弱層が存在する場合等には、十分な注意が必要である。

3．フィルダム

> 一般に、フィルダムはコンクリートダムに比べダムから受ける荷重をより広い地盤に伝えるので、基礎の強度の面からの制約条件は少ない。
>
> 基礎地盤の必要条件として、せん断強さやパイピングに対する抵抗性が要求されるとともに、遮水ゾーンの基礎では所要の遮水性が要求される。
>
> 岩盤基礎の場合は、特別な欠陥がない限り強度的には問題ない。なお、遮水ゾーンの基礎地盤は一般に堤体の透水係数と同程度となるまで掘削するか、あるいはグラウチングにより処理できるものでなければならない。
>
> 砂礫基礎は、層状に形成されたもの以外は一般に十分なせん断強さを有するが、遮水性に劣るので、ダムの高さや基礎地盤の透水性に応じた遮水対策を検討する。
>
> 土質基礎は、比較的遮水性に優れているが、一般にせん断強度が小さく、滑動、沈下あるいは変形に対して問題があり、堤高が高いダムの基礎地盤としては適当でない。

＜関連通知等＞

31. 建設省河川局長通達：河川管理施設等構造令及び同令施行規則の施行について，昭和51年11月23日，建設省河政発第70号．

＜参考となる資料＞

ダムの型式の選定方法については、下記の資料が参考となる。

32. （財）国土開発技術研究センター編／（社）日本河川協会：改定
    解説・河川管理施設等構造令，平成12年1月．

33. （財）ダム技術センター：多目的ダムの建設　平成17年版　第4巻　設計Ⅰ編，平成17年6月．

    1.  []{#_Toc81931342 .anchor}ダムの配置設計

＜考え方＞

  --------------------------------------------------------------------------------------------------------------------------------------------
  ダムの配置設計は、選定したダムの位置、ダムの型式を踏まえて、ダムの高さ、地形、地質及び洪水処理の方法等の諸条件を総合的に検討して実施する。
  --------------------------------------------------------------------------------------------------------------------------------------------

1.  []{#_Toc81931343 .anchor}重力式コンクリートダムの配置設計

＜考え方＞

+----------------------------------------------------------------------+
| 重力式コンクリートダムの配置は、堤体及                               |
| び基礎岩盤の安定上、問題となる地形や地質を避けるとともに、安全に洪水 |
| 処理が可能となること等の条件を考慮し、候補となる案の中から決定する。 |
|                                                                      |
| 1．地形                                                              |
|                                                                      |
| \(1\)                                                                |
| 谷幅：谷幅                                                           |
| の広さは堤体積に直接影響するため、経済性の面から重視する必要がある。 |
|                                                                      |
| > \(2\)                                                              |
| > やせ尾根：中位から高位標                                           |
| 高にかけて特に注意する必要があり、透水性、せん断強度等が問題となる。 |
| >                                                                    |
| > \(3\)                                                              |
| > 下流下がり：最大荷重がかかった場合の堤体の安定性に注意す           |
| る必要があり、下流下がりの状況によっては大きな岩盤強度を必要とする。 |
| >                                                                    |
| > \(4\)                                                              |
| > 上流下がり：                                                       |
| 貯水池空虚時及び貯水位が低い場合の堤体の安定性に注意する必要がある。 |
| >                                                                    |
| > \(5\)                                                              |
| > 長大のり面：施工時及びダム完成後の                                 |
| 長大のり面の斜面安定について、地質条件とも関連し注意する必要がある。 |
|                                                                      |
| 2．地質                                                              |
|                                                                      |
| > \(1\)                                                              |
| > 堅岩線：堤高に応じて必要な岩盤強度があり、それに応じた堅岩線       |
| が決定されるが、その深さは風化の度合に大きく影響される。ここで重要な |
| のは岩盤のせん断強度であり、堤体の安定上必要なせん断強度が確保される |
| 基礎地盤であれば、支持力に関わる圧縮強度は一般的に問題とはならない。 |
| >                                                                    |
| > \(2\)                                                              |
| > 断層：基礎地盤に存在する断層でダム及び基礎地盤の安定上特に注       |
| 意を要するのは、低角度断層と下流端付近の上流落ち（下流上がり）断層で |
| ある。これに対して、鉛直に近い傾斜をもった断層は比較的問題は少ないが |
| 、断層規模が大きくなると、基礎処理を施しても高いダムを築造するのが難 |
| しくなる場合がある。一般に、断層の規模が大きくなく断層と堅岩との境界 |
| 面が明確な場合には置換えなどの基礎処理は容易である。断層の透水性につ |
| いては、一般に断層粘土は透水性が低いが周辺の破砕部は透水性が高く、グ |
| ラウチングによる改良が難しいことが多く、グラウチング改良区域に分布す |
| る場合は所要の遮水性が確実に得られるよう改良できることが必要である。 |
|                                                                      |
| 3．洪水処理                                                          |
|                                                                      |
| 重力式コンクリートダムは洪水吐きを堤体内に設置                       |
| できることが特徴の１つである。したがって、次の事項について考慮する。 |
|                                                                      |
| > \(1\)                                                              |
| > 越流型洪水吐き                                                     |
| ：容量、位置、方向を考慮して水理条件を満たすための検討が必要である。 |
| >                                                                    |
| > \(2\)                                                              |
| > 放流管の配置：放流管及び操作室は、ダムの                           |
| 形状、継目の位置及び間隔等と関連して、その配置を検討する必要がある。 |
| >                                                                    |
| > \(3\)                                                              |
| > 減勢工：対象流量を減勢するのに必要な地                             |
| 形条件を考慮するとともに、他の構造物への影響がないことが必要である。 |
|                                                                      |
| 4．施工設備                                                          |
|                                                                      |
| 主な施工設備                                                         |
| のうち、特にコンクリート運搬設備はダムの配置設計と大きな関連があり、 |
| 地形・地質条件による制約を踏まえ、機種の選択や基本的な配置を考える。 |
+----------------------------------------------------------------------+

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------
  重力式コンクリートダムは、ダムの高さ、地形、基礎地盤の強度などの地質条件及び洪水処理の方法等を考慮して配置設計を行うことを基本とする。
  ----------------------------------------------------------------------------------------------------------------------------------------

＜参考となる資料＞

重力式コンクリートダムの配置設計の方法については、下記の資料が参考となる。

34. （財）ダム技術センター：多目的ダムの建設　平成17年版　第4巻　設計Ⅰ編，平成17年6月．

    1.  []{#_Toc81931344 .anchor}アーチ式コンクリートダムの配置設計

＜考え方＞

+----------------------------------------------------------------------+
| ア                                                                   |
| ーチ式コンクリートダムの配置は、ダムや貯水池からの荷重を支持するのに |
| 必要な十分な厚みと強度を有する基礎岩盤が得られるとともに、安全に洪水 |
| 処理が可能となること等の条件を考慮し、候補となる案の中から決定する。 |
|                                                                      |
| アーチ式コンクリー                                                   |
| トダムの場合は、左右岸の基礎岩盤に作用する荷重が大きいため、特に基礎 |
| 岩盤ショルダーの厚さを十分確保できるようにダムを配置する必要がある。 |
|                                                                      |
| 基礎岩盤となる                                                       |
| 左右岸の岩盤の安定性を確保するためのダムの配置設計及びダムの根入れ深 |
| さ（アバットメントの位置）の概略検討は、所要堅岩線の検討により行う。 |
|                                                                      |
| 所要堅岩線は次のようにして求められる                                 |
| 。まず、任意の水平断面を取り、ダム上流端から任意の方向のせん断面*Si* |
| を仮                                                                 |
| 定し、これに作用する岩盤内の揚圧力、ダムからの荷重などを算出すること |
| により、所要のせん断摩擦安全率を満足するために必要な堅岩線の長さ*li* |
| を Henny の式から次のように求める（図 2-2-7参照）。                  |
|                                                                      |
| $${　　l}                                                            |
| _{i} = \frac{nH_{i} - f_{i}\left( V_{i} - U_{i} \right)}{\tau_{i}}$$ |
|                                                                      |
| ここに、                                                             |
|                                                                      |
| *l~i\ ~*：仮定せん断面*S~i~*に沿った所要の堅岩線の長さ（m）          |
|                                                                      |
| *τ~i~* ：仮定せん断面*S~i~*に沿ったせん断強度（kN/m^2^）             |
|                                                                      |
| *f~i~* ：仮定せん断面*S~i~*に沿った内部摩擦係数                      |
|                                                                      |
| > *H~i~*                                                             |
| > ：アーチ式コンクリートダ                                           |
| ムからの鉛直方向単位幅当たりの荷重の仮定せん断面に平行な成分（kN/m） |
| >                                                                    |
| > *V~i~*                                                             |
| > ：アーチ式コンクリートダ                                           |
| ムからの鉛直方向単位幅当たりの荷重の仮定せん断面に垂直な成分（kN/m） |
|                                                                      |
| *U~i~*                                                               |
| ：せん断面に作用する揚圧力の鉛直方向単位幅当たりの合力（kN/m）       |
|                                                                      |
| *n*：せん断摩擦安全率                                                |
|                                                                      |
| 揚圧力は仮定せん断面に対し本章3.5.4に示す方法を踏まえて設定する。    |
|                                                                      |
| 仮定せん断面の方向を種々に変えてその所要の堅岩線の長さを計算すれば図 |
| 2-2-7に示すような所要の堅岩線                                        |
| の長さを包絡する曲線が求められる。この曲線を所要堅岩線と呼んでいる。 |
|                                                                      |
| 所要堅岩線は基礎岩盤の安全性を確保するために必要なショルダーの範囲で |
| あり、これが基礎岩盤内の実際の堅岩線と交差するときは、その標高での２ |
| 次元検討による基礎岩盤は所要の安全率を持たないことを示し、反対に両者 |
| の間隔が非常に広いときは、ダムの根入れが深すぎて不経済なことを示す。 |
|                                                                      |
| 一般                                                                 |
| に所要堅岩線を計算する際に用いるせん断摩擦安全率は4とする。しかし基  |
| 礎岩盤内にせん断破壊を生じやすい方向に断層等の弱層がある場合には、別 |
| 途、その弱層の位置、方向及び規模を考慮した安全性の検討が必要である。 |
|                                                                      |
| ![](media/image147.png){width="2.720138888888889in"                  |
| height="2.073611111111111in"}                                        |
|                                                                      |
| 注）図示の簡                                                         |
| 略化のため堅岩線の川側（図では右側）に存在する地表線は描いていない。 |
|                                                                      |
| 100. 所要堅岩線                                                      |
|                                                                      |
| 堤体と基礎岩盤の接触                                                 |
| 面及び基礎岩盤内部の断層、節理等の弱点と考えられる面の安全性は、本章 |
| 6.3.1                                                                |
| に示す方法に準                                                       |
| じて判断する。特にアーチ式コンクリートダムの場合、ダムの左右岸部にお |
| いて高角度の弱層が存在する場合にその安全性に注意を要することが多い。 |
+----------------------------------------------------------------------+

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------
  アーチ式コンクリートダムは、ダムの高さ、地形、基礎地盤（特に左右岸）の強度などの地質条件及び洪水処理の方法等を考慮して配置設計を行うことを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------

＜例　示＞

アーチ式コンクリートダムにおいては、基礎岩盤の安全性を検討する際、標高ごとの2次元的な所要堅岩線による検討が行われることが一般的である。しかし、堤体と基礎岩盤の接触面及び基礎岩盤内部の断層、節理等の弱点と考えられる面の安全性を検討する際などには、必要に応じて岩盤をモデルに組み込んだ3次元的なせん断破壊に対する安全率の検討を行う場合ある。この場合の所要安全率として、解析の精度等を考慮して、2次元的検討で用いる4よりも大きい数値を用いている事例がある。

＜参考となる資料＞

アーチ式コンクリートダムの配置設計の方法については、下記の資料が参考となる。

35. （財）ダム技術センター：多目的ダムの建設　平成17年版　第4巻　設計Ⅰ編，平成17年6月．

    1.  []{#_Toc81931345 .anchor}フィルダムの配置設計

＜考え方＞

+----------------------------------------------------------------------+
| フィルダ                                                             |
| ムの配置は、堤体の安定や基礎地盤の遮水上問題となる地質を避けるととも |
| に、安全な洪水処理が可能となる洪水吐きの配置などを考慮し、決定する。 |
|                                                                      |
| フィルダムの場合は、コ                                               |
| ンクリートダムと異なり堤体と分離して洪水吐きを設置しなければならない |
| ことから、洪水吐きの設置の容易さも考慮してダムを配置する必要がある。 |
|                                                                      |
| フィルダムは、一般にコンクリートダムに比べ基礎地盤が良好             |
| でないサイトでも築造可能であるが、基礎地盤は堤体の安定上問題となる不 |
| 等沈下や過大な沈下が生じないことが条件となる。また、必要な遮水性を確 |
| 保することができるかどうかも、配置設計の重要な要因となることが多い。 |
|                                                                      |
| 地形が極                                                             |
| 端なＶ字型の谷となっている場合の急傾斜部や変形性が大きく異なる地質境 |
| 界部に遮水ゾーンを設置すると、不等沈下によるせん断変形が亀裂の原因と |
| なり、ひいては、これが浸透破壊の誘因となることがあるので、注意する。 |
|                                                                      |
| フィルダムは、堤体内に洪水吐                                         |
| きを設置できないので（構造令第4条第5項参照）、付近の地山に設置が可能 |
| かどうか、地形、地質面からの検討が重要である。洪水吐きを急峻な山腹に |
| 設ける場合、掘削量が大量となること及び長大のり面の安定性の確保や維持 |
| 管理上の問題からダムの配置が不適当となることがあるので注意を要する。 |
+----------------------------------------------------------------------+

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------
  フィルダムは、ダムの高さ、堤体の遮水型式、地形、地質条件及び洪水吐きの配置等を考慮して配置設計を行うことを基本とする。
  ------------------------------------------------------------------------------------------------------------------------

＜例　示＞

フィルダムのダム軸の平面形状は、直線が一般的であるが、貯水圧による遮水ゾーンの応力状態を改善したり、地形によっては掘削量、盛立量あるいは堤体と洪水吐きの配置上有利とする目的で、上流側に凸の曲線が採用された事例もある。

＜参考となる資料＞

フィルダムの配置設計の方法については、下記の資料が参考となる。

36. （財）ダム技術センター：多目的ダムの建設　平成17年版　第4巻　設計Ⅰ編，平成17年6月．

第2章 ダムの設計 {#第2章-ダムの設計-2 .目次の見出し1}
================

第3節　ダム設計の基本条件 {#第3節-ダム設計の基本条件 .目次の見出し1}
=========================

目　次 {#目-次-8 .目次の見出し1}
======

[第3節 ダム設計の基本条件 1](#_Toc82025884)

> [3．1 設計の要件 1](#_Toc82025885)
>
> [3．2 設計の前提 2](#_Toc82025886)
>
> [3．3 設計水位等 5](#_Toc82025887)
>
> [3．4 荷重の組合せ 7](#_Toc82025888)
>
> [3．5 荷重の計算法 10](#_Toc82025889)
>
> [3．5．1 自重 10](#_Toc82025890)
>
> [3．5．2 静水圧 11](#_Toc82025891)
>
> [3．5．3 泥圧 13](#_Toc82025892)
>
> [3．5．4 揚圧力 14](#_Toc82025893)
>
> [3．5．5 地震時慣性力 15](#_Toc82025894)
>
> [3．5．6 地震時動水圧 18](#_Toc82025895)
>
> [3．5．7 温度荷重 21](#_Toc82025896)

令和3年10月　版

適用上の位置付け

　河川砂防技術基準設計編は、基準の適用上の位置付けを明確にするために、下表に示すように適用上の位置付けを分類している。

+--------+------------------+------------------+------------------+
| 分　類 | 適用上の位置付け | 末尾の字句例     |                  |
+--------+------------------+------------------+------------------+
| 考え方 | 技術資料         | ●目              | 「･･･ある。      |
|        |                  | 的や概念、考え方 | 」「･･･いる。」  |
|        |                  | を記述した事項。 |                  |
|        |                  |                  | 「･･･なる。      |
|        |                  |                  | 」「･･･れる。」  |
+--------+------------------+------------------+------------------+
| 必　須 | 技術基準         | ●法令による規定  | 「･･･なければ    |
|        |                  | や技術的観点から | ならない。」「･  |
|        |                  | 実施すべきである | ･･ものとする。」 |
|        |                  | ことが明確であり |                  |
|        |                  | 遵守すべき事項。 |                  |
+--------+------------------+------------------+------------------+
| 標　準 | 技術基準         | ●特              | 「･･･            |
|        |                  | 段の事情がない限 | を標準とする。」 |
|        |                  | り記述に従い実施 |                  |
|        |                  | すべきだが、状況 | 「･･･            |
|        |                  | や条件によって一 | を基本とする。」 |
|        |                  | 律に適用すること |                  |
|        |                  | はできない事項。 | 「･･･による。」  |
+--------+------------------+------------------+------------------+
| 推　奨 | 技術資料         | ●状況や条件      | 「               |
|        |                  | によって実施する | ･･･望ましい。」  |
|        |                  | ことが良い事項。 |                  |
|        |                  |                  | 「               |
|        |                  |                  | ･･･推奨する。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･務める。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･必要に応    |
|        |                  |                  | じて･･･する。」  |
+--------+------------------+------------------+------------------+
| 例　示 | 技術資料         | ●適用条件や実施  | 「               |
|        |                  | 効果について確定 | ･･･などの手法（  |
|        |                  | している段階では | 事例）がある。」 |
|        |                  | ないが、状況や条 |                  |
|        |                  | 件によっては導入 | 「･･･など        |
|        |                  | することが可能な | の場合がある。」 |
|        |                  | 新技術等の例示。 |                  |
|        |                  |                  | 「･･･など        |
|        |                  | ●状              | が考えられる。」 |
|        |                  | 況や条件によって |                  |
|        |                  | 限定的に実施でき | 「               |
|        |                  | る技術等の例示。 | ･･･の場合には･･･ |
|        |                  |                  | ことができる。」 |
|        |                  | ●具体的          |                  |
|        |                  | に例示することに | 「               |
|        |                  | より、技術的な理 | ･･･例示する。」  |
|        |                  | 解を助ける事項。 |                  |
|        |                  |                  | 「例えば･･･。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･事例もある  |
|        |                  |                  | 。･･･もよい。」  |
+--------+------------------+------------------+------------------+

  関連通知等       関連する通知やそれを理解する上で参考となる資料
  ---------------- ------------------------------------------------------
  参考となる資料   例示等に示した手法・内容を理解する上で参考となる資料

1.  []{#_Toc82025884 .anchor}ダム設計の基本条件

    1.  []{#_Toc82025885 .anchor}設計の要件

＜考え方＞

+----------------------------------------------------------------------+
| ダムは流水を貯留することにより洪水調節を行うとともに、各種           |
| の水の利用を図ることを目的として建設される構造物であり、ダムは長期的 |
| にこれらの治水と利水の機能を確実に発揮できるよう設計する必要がある。 |
|                                                                      |
| ダムは堤体及び基礎が一体となって                                     |
| 流水を止める働きをする構造物であるので、ダムの堤体及び基礎地盤は所要 |
| の水密性及び予想される荷重に対する安全性を有するとともに一定期間内確 |
| 実に効用を発揮するのに必要な耐久性を有する構造とする。またダムは所要 |
| の放流が可能となる放流設備を有し、管理上も操作が確実に行える構造とす |
| る。さらに、ダムの設置される周辺環境と調和するよう配慮して設計する。 |
|                                                                      |
| ダムの位置は計画上ならびに自然、社会条件等か                         |
| ら通常は自由に選ぶことはできない。したがって、決められたダムサイトに |
| 対し、ダムの規模、ダムサイトの地形、地質条件、水文条件、堤体材料の条 |
| 件、気象、施工性等の条件を総合的に検討することによって、ダムの型式及 |
| び基本的な配置を決定し、続いて詳細な設計へと移行していく必要がある。 |
|                                                                      |
| ダ                                                                   |
| ムの構造の原則は、構造令第4条において、以下のように定められている。  |
|                                                                      |
| +----------------------------------------------------------------+   |
| | （構造の原則）                                                 |   |
| |                                                                |   |
| | 第4条　ダムの堤体及び基礎地盤（これ                            |   |
| | と堤体との接合部を含む。以下同じ。）は、必要な水密性を有し、及 |   |
| | び予想される荷重に対し必要な強度を有するものとするものとする。 |   |
| |                                                                |   |
| | 2　コンクリートダムの堤体は、予想                              |   |
| | される荷重によって滑動し、又は転倒しない構造とするものとする。 |   |
| |                                                                |   |
| | 3　フィルダムの堤体は、予想される荷                            |   |
| | 重によって滑り破壊又は浸透破壊が生じない構造とするものとする。 |   |
| |                                                                |   |
| | 4　ダムの基礎地盤は、予想される荷重によっ                      |   |
| | て滑動し、滑り破壊又は浸透破壊が生じないものとするものとする。 |   |
| |                                                                |   |
| | 5　フィル                                                      |   |
| | ダムの堤体には、放流設備その他の水路構造物を設けてはならない。 |   |
| +----------------------------------------------------------------+   |
+----------------------------------------------------------------------+

＜必　須＞

  -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  ダムは、構造令第4条で定める構造の原則に従い、予想される荷重に対する安全性及び必要な水密性が備わった構造とし、耐久性、操作性、景観及び経済性を総合的に考慮して設計するものとする。
  -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

37. 建設省河川局長通達：河川管理施設等構造令及び同令施行規則の施行について，昭和51年11月23日，建設省河政発第70号．

＜参考となる資料＞

ダムの設計の要件については、下記の資料が参考となる。

38. （財）国土開発技術研究センター編／（社）日本河川協会：改定　解説・河川管理施設等構造令，平成12年1月．

    1.  []{#_Toc82025886 .anchor}設計の前提

＜考え方＞

+----------------------------------------------------------------------+
| ダ                                                                   |
| ムを安全に設計するためには、予想される荷重に対して堤体及び基礎地盤が |
| 安定であるか検討する必要がある。特に、ダムは、その規模が大きく、万一 |
| 破壊すると及ぼす影響が大きいので、社会的にも極めて高い安全性を要求さ |
| れる。ダムの種類は、コンクリートダム、フィルダムなどに大別され、コン |
| クリートダムは弾性構造物、フィルダムは非弾性構造物として設計される。 |
|                                                                      |
| ダ                                                                   |
| ムは、その安全性を確保するために、ダム型式等に応じた合理的な設計手法 |
| により、設計手法に基づいた所要の安全率を有した設計を行う必要がある。 |
|                                                                      |
| コンクリートダムの安定性及び強度は、河川管理施設等構造令施行規則（以 |
| 下「施行規則」という。）第9条において、以下のように定められている。  |
|                                                                      |
| +----------------------------------------------------------------+   |
| | （コンクリートダムの安定性及び強度）                           |   |
| |                                                                |   |
| | 規則第9条　コンクリートダムは、第1条第1項に規定する場合        |   |
| | において、ダムの堤体と基礎地盤との接合部及びその付近における剪 |   |
| | 断力による滑動に対し、必要な剪断摩擦抵抗力を有するものとする。 |   |
| |                                                                |   |
| | 2　前項の剪断摩擦抵抗力は、次のイの式によって計算              |   |
| | するものとし、かつ、次のロの式を満たすものでなければならない。 |   |
| |                                                                |   |
| | イ　*R~b~*＝*f V*＋*τ*~0~ *l*~0~                               |   |
| |                                                                |   |
| | ロ　*R~b~*≧4*H*                                                |   |
| |                                                                |   |
| | これらの式において、*R~b~*、*f*、*V*、*τ*~0~、*l*~0~ 及び *H*  |   |
| | は、それぞれ次の数値を表すものとする。                         |   |
| |                                                                |   |
| | *R~b~*                                                         |   |
| | 　                                                             |   |
| | 単位幅当たりの剪断摩擦抵抗力（単位　1メートルにつき重量トン）  |   |
| |                                                                |   |
| | *f*                                                            |   |
| | 　適切な工学試験の結果又                                       |   |
| | は類似のダムの構造計算に用いられた値に基づき定める内部摩擦係数 |   |
| |                                                                |   |
| | *V*                                                            |   |
| | 　単位幅当                                                     |   |
| | たりの剪断面に作用する垂直力（単位　1メートルにつき重量トン）  |   |
| |                                                                |   |
| | > *τ*~0~　類似のダムに                                         |   |
| | 関する資料及び岩盤性状等により明らかな場合を除き、現場試験の結 |   |
| | 果に基づき定める剪断強度（単位　1平方メートルにつき重量トン）  |   |
| |                                                                |   |
| | *l*~0~　剪断抵抗力が生ずる剪断面の長さ（単位　メートル）       |   |
| |                                                                |   |
| | *H* 　単位幅当たりの剪断力（単位　1メートルにつき重量トン）    |   |
| |                                                                |   |
| | 3　コンク                                                      |   |
| | リートダムの堤体に生ずる応力は、第1条第1項に規定する場合におい |   |
| | て、標準許容応力を超えてはならないものとする。ただし、地震時に |   |
| | おいて、ダムの堤体に生ずる圧縮応力については、標準許容応力にそ |   |
| | の30パーセント以内の値を加えた値を超えてはならないものとする。 |   |
| |                                                                |   |
| | 4　前                                                          |   |
| | 項の標準許容応力は、ダムの堤体の材料として用いられるコンクリー |   |
| | トの圧縮強度を基準とし、安全率を4以上として定めるものとする。  |   |
| |                                                                |   |
| | 5　重力式コンクリートダムの堤体は、第1条第                     |   |
| | 1項に規定する場合において、その上流面に引っ張り応力を生じない  |   |
| | 構造とするものとする。ただし、局部的な引っ張り応力に対して鉄筋 |   |
| | 等で補強されているダムの堤体の部分については、この限りでない。 |   |
| +----------------------------------------------------------------+   |
|                                                                      |
| フィルダムの安定性及び堤体                                           |
| 材料については、施行規則第10条において、以下のように定められている。 |
|                                                                      |
| +----------------------------------------------------------------+   |
| | （フィルダムの安定性及び堤体材料）                             |   |
| |                                                                |   |
| | 規則第10条　フィルダムは、第1条第1項及び第2項に規              |   |
| | 定する場合において、ダムの堤体の材料の性質及び基礎地盤の状況を |   |
| | 考慮し、ダムの堤体の内部、ダムの堤体と基礎地盤との接合部及びそ |   |
| | の付近における滑りに対し、必要な滑り抵抗力を有するものとする。 |   |
| |                                                                |   |
| | 2　前項の滑り抵抗力は、次のイの式によって計算                  |   |
| | するものとし、かつ、次のロの式を満たすものでなければならない。 |   |
| |                                                                |   |
| | イ　$R_{s} = \sum_{                                            |   |
| | }^{}\left\{ \left( N - U \right)\tan\varphi + Cl_{1} \right\}$ |   |
| |                                                                |   |
| | ロ　$R_{s} \geqq 1.2\sum_{}^{}T$                               |   |
| |                                                                |   |
| | これらの式において、*R~s~*、*N*、*U*、*φ*、*C*、*l*~1~ 及び    |   |
| | *T* は、それぞれ次の数値を表すものとする。                     |   |
| |                                                                |   |
| | *R~                                                            |   |
| | s~*　単位幅当たりの滑り抵抗力（単位　1メートルにつき重量トン） |   |
| |                                                                |   |
| | > *N*　円形滑り面上の各分割部分に作用する                      |   |
| | 荷重の単位幅当たりの垂直分力（単位　1メートルにつき重量トン）  |   |
| | >                                                              |   |
| | > *U*　円形滑り面上の各分割部分に作用                          |   |
| | する荷重の単位幅当たりの間隙圧（単位　1メートルにつき重量トン) |   |
| |                                                                |   |
| | *φ　*円形滑り面上の各分割部分の材料の内部摩擦角（単位　度）    |   |
| |                                                                |   |
| | *C*　円形滑り面上                                              |   |
| | の各分割部分の材料の粘着力（単位　1平方メートルにつき重量トン) |   |
| |                                                                |   |
| | *l*~1~　円形滑り面上の各分割部分の長さ（単位　メートル）       |   |
| |                                                                |   |
| | > *T*　円形滑り面上の各分割部分に作用する                      |   |
| | 荷重の単位幅当たりの接線分力（単位　1メートルにつき重量トン）  |   |
| |                                                                |   |
| | 3　フィルダムの堤体は、第1条第1項に規定する場合において、浸潤  |   |
| | 線がダムの堤体の下流側の法面と交わらない構造とするものとする。 |   |
| |                                                                |   |
| | 4　フ                                                          |   |
| | ィルダムのしゃ水壁は、次の各号に定めるところによるものとする。 |   |
| |                                                                |   |
| | 一　しゃ水壁の材料は、土質材料その他不透水性のものであること。 |   |
| |                                                                |   |
| | 二　しゃ水壁の高さは、令第5条の規定による値以上であること。    |   |
| |                                                                |   |
| | 三　しゃ水壁及び                                               |   |
| | これと基礎地盤との接合部は、貫孔作用が生じないものであること。 |   |
| |                                                                |   |
| | 5　                                                            |   |
| | 基礎地盤から堤頂までの高さが30メートル以上で、かつ、その堤体が |   |
| | おおむね均一の材料によるフィルダムの構造は、第1項及び第3項の規 |   |
| | 定によるほか、堤体の材料及び設計等について類似のダムに用いられ |   |
| | た適切な工学試験又は計算等に基づき安全の確認されたものとする。 |   |
| |                                                                |   |
| | 6　フィルダムには、ダムの堤体の点検、修理等のため貯            |   |
| | 水池の水位を低下させることができる放流設備を設けるものとする。 |   |
| +----------------------------------------------------------------+   |
|                                                                      |
| ダムの堤体及び基礎地盤の安定性は、堤                                 |
| 体及び基礎地盤の物性、予想される荷重状態とその大きさ、使用する解析法 |
| の種類と仮定、その結果考慮すべき所定の安全率の大きさを鑑み総合的に評 |
| 価することによって初めて正しく検討することができる。したがって、使用 |
| する解析法、材料の物性が異なれば、安全率の値も当然異なるので、設計を |
| 行うにあたっては、これらについて十分考慮し、注意深く行う必要がある。 |
|                                                                      |
| ダム及び基礎地盤に作用する荷重及び荷重の組合せに                     |
| ついては本章3.4に述べる。また、ダム型式ごとの設計手法については、表  |
| 2-3-1に示すとおりであるが、それぞれの堤体材料の物性                  |
| 等による設計上の特徴及び使用する解析法と安全率について以下に述べる。 |
|                                                                      |
| 1．コンクリートダム                                                  |
|                                                                      |
| > 重力式コンクリートダムの設計に                                     |
| あたっては、ダム軸に垂直な鉛直断面を用いて2次元設計が行われる。この  |
| 場合、一般に平面保持の仮定を用いた片持ばり理論が用いられる。そのうえ |
| で、上流面に鉛直方向の引張応力が生じないよう、予想される荷重による合 |
| 力の作用点が堤体内の上下流面間の長さの中央1/3（ミドルサード（Middle  |
| > third））内に入るよう基本断面を設定する。                          |
| >                                                                    |
| > アーチ                                                             |
| 式コンクリートダムの設計は3次元的な解析が行われ、以前はアーチ要素と  |
| 片持ばり要素の組合せとして解く荷重分割法で計算した応力状態等を模型実 |
| 験で確認する方法で行われていたが、現在では、堤体の最終形状が概ね固ま |
| った段階で、有限要素法にて応力解析を行っている。重力式、アーチ式とも |
| 堤体コンクリートの許容応力を考える際の安全率は4以上を用いる。なお、  |
| 地震時においては、許容応力にその30%以内の値を加えた値を基本とする。  |
| >                                                                    |
| > コンクリートダムの基礎地盤                                         |
| の設計にあたっては、一般にコンクリートダムの設計の際に堤体と基礎地盤 |
| を一体となった剛体として取り扱い、2次元断面に対して作用力と抵抗力の  |
| 比（Hennyの式）が4以上の安全率を確保するように設計する。また、基礎地 |
| 盤の安定性が問題となるときには併せて内部応力を考慮した解析を行う。こ |
| の場合、基礎地盤は一般に弾性体として取り扱われ、単位面積当たりのせん |
| 断摩擦安全率（局所せん断摩擦安全率）が概ね2以上になるよう設計する。  |
|                                                                      |
| 2．フィルダム                                                        |
|                                                                      |
| > フィルダムの最大の特徴は、堤体が岩石、砂礫、                       |
| 土質材料などからなり塑性的あるいは粘弾性的性質を有する材料でできてい |
| ることであり、かつ、フィルダムには、基礎地盤あるいは堤体自体の沈下に |
| 対しても、それに追従し、十分安定した状態を保っていられるという、コン |
| クリートダムにない特徴がある。なお、基礎地盤の地形、地質条件から不等 |
| 沈下が設計上の問題になる場合には注意が必要である。また、底面積を広く |
| することによりダムの基礎に及ぼす応力を小さくすることができるため、基 |
| 礎地盤の条件によるダム設計上の制約はコンクリートダムに比べて小さい。 |
| >                                                                    |
| > フィルダムはコンク                                                 |
| リートダムに比べて非弾性的性質が著しいが、その非弾性的な性質に対する |
| 理論的な検討が複雑であることもあり、弾塑性解析に基づいた理論的な設計 |
| 体系がたてにくいことも特徴である。また、フィルダムの堤体材料は一般の |
| 材料と異なり、強度が間隙水圧に影響されるため破壊の定義が複雑になる。 |
| >                                                                    |
| > 以上の状況から、現状ではフィ                                       |
| ルダムの設計は、斜面のすべりに対する安定性について2次元の円弧すべり  |
| 面についてスライス法により検討し、作用力と抵抗力の比に対して安全率が |
| > 1.2以上となるような断面形状となるよう設計                          |
| する。なお、浸透力による遮水ゾーンの滑動に対しては下流の透水ゾーンの |
| 重量による摩擦抵抗で抵抗しているが、一般にこの条件から定まる下流面勾 |
| 配よりも円弧すべりを考慮した検討から定まる下流面勾配の方が大きくなる |
| ため、通常は上記の円弧すべりに対する検討により設計することができる。 |
| >                                                                    |
| > 設計外力に対する変形及び応力・ひずみの                             |
| 解析を堤体設計に取り込む手法については、必要に応じ参考的に実施する。 |
|                                                                      |
| 67. 　各ダム型式の設計手法の違い                                     |
|                                                                      |
| +----------------+------------+----------------+----------------+    |
| | ダム型式       | 基本的仮定 | ダ             | 基             |    |
| |                |            | ム標準設計条件 | 本的な設計数値 |    |
| +----------------+------------+----------------+----------------+    |
| | 重力式         | 2次元      | 1\)            | 原             |    |
| |                |            | 外力           | 位置試験による |    |
| | コ             | 弾性体     | として考慮する |                |    |
| | ンクリートダム |            | 力の合力の作用 | 岩盤のせん     |    |
| |                |            | 点が堤体水平断 | 断強度*τ~０~*  |    |
| |                |            | 面のMiddle　T  |                |    |
| |                |            | hirdに入ること | 岩盤の内       |    |
| |                |            |                | 部摩擦係数*ｆ* |    |
| |                |            | 2)　Henny      |                |    |
| |                |            | の式で安全率が | 配合試験による |    |
| |                |            | 4以上あること  |                |    |
| |                |            |                | コン           |    |
| |                |            | 3\)            | クリートの強度 |    |
| |                |            | 堤体           |                |    |
| |                |            | 中に生ずる圧縮 |                |    |
| |                |            | 応力が許容応力 |                |    |
| |                |            | を超えないこと |                |    |
| +----------------+------------+----------------+----------------+    |
| | アーチ式       | 3次元      | 1)　堤体中     |                |    |
| |                |            | に生ずる圧縮応 |                |    |
| | コ             | 弾性体     | 力が許容応力を |                |    |
| | ンクリートダム |            | 超えないこと\* |                |    |
| |                |            |                |                |    |
| |                |            | 2)　Henny      |                |    |
| |                |            | の式で安全率が |                |    |
| |                |            | 4以上あること  |                |    |
| +----------------+------------+----------------+----------------+    |
| | フィルダム     | 2次元      | 1\)            | 室内三         |    |
| |                |            | 円弧           | 軸試験等による |    |
| |                | 非弾性体   | すべり面につい |                |    |
| |                |            | てスライス法に | フィ           |    |
| |                |            | よる安全性が1  | ル材料・基礎の |    |
| |                |            | .2以上あること |                |    |
| |                |            |                | 粘着力*ｃ*     |    |
| |                |            |                |                |    |
| |                |            |                | 内部摩擦角*φ*  |    |
| +----------------+------------+----------------+----------------+    |
|                                                                      |
| \*)　堤体の組合せ応力より定めた修正係数を考慮する。                  |
+----------------------------------------------------------------------+

＜必　須＞

  -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  ダムは予想される荷重状態とその大きさ、堤体及び基礎地盤の物性、使用する解析法、考慮すべき安全率等を総合的に検討し、施行規則第9条及び第10条で定める方法に従い、所要の安全性を確保するよう設計するものとする。
  -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

39. 建設省河川局長通達：河川管理施設等構造令及び同令施行規則の施行について，昭和51年11月23日，建設省河政発第70号．

＜参考となる資料＞

ダムの設計の前提条件については、下記の資料が参考となる。

40. （財）国土開発技術研究センター編／（社）日本河川協会：改定　解説・河川管理施設等構造令，平成12年1月．

    1.  []{#_Toc82025887 .anchor}設計水位等

＜考え方＞

+----------------------------------------------------------------------+
| ダムの構造計算に採用する荷重状態の対                                 |
| 象となる水位は、施行規則第1条において、以下のように定められている。  |
|                                                                      |
| +----------------------------------------------------------------+   |
| | （ダムの構造計算）                                             |   |
| |                                                                |   |
| | 規則第1条　ダムの堤体及び基礎地盤（これと堤体との接合          |   |
| | 部を含む。次項及び第8条において同じ。）に関する構造計算は、ダ  |   |
| | ムの非越流部の直上流部における水位が次の各号に掲げる場合及びダ |   |
| | ムの危険が予想される場合における荷重を採用して行うものとする。 |   |
| |                                                                |   |
| | 一 常時満水位である場合                                        |   |
| |                                                                |   |
| | 二 サーチャージ水位である場合                                  |   |
| |                                                                |   |
| | 三 設計洪水位である場合                                        |   |
| |                                                                |   |
| | 2　フィルダム                                                  |   |
| | の堤体及び基礎地盤に関する構造計算は、前項の規定によるほか、ダ |   |
| | ムの非越流部の直上流部における水位が常時満水位以下で、かつ、水 |   |
| | 位を急速に低下させる場合における荷重を採用して行うものとする。 |   |
| +----------------------------------------------------------------+   |
|                                                                      |
| ダムの堤体設計等の基準となる貯水池の水位等は次のとおりである。       |
|                                                                      |
| 1．常                                                                |
| 時満水位：本章1.3に示す水位である。なお、この水位は、利水目的で貯留  |
| される各種容量、死水容量、堆砂容量の組合せで決まる貯水池容量に対応す |
| る貯水池の水位である。洪水調節を目的に含むダムでは、洪水期に常時満水 |
| 位を下回った水位を維持することがあるが、これを洪水期制限水位と呼ぶ。 |
|                                                                      |
| 2．                                                                  |
| サーチャージ水位：本章1.3に示す水位である。洪水調節を目的に含むダム  |
| では、洪水防御計画における基本高水に対して必要な洪水調節容量を確保し |
| なければならないが、この容量と各種利水容量、死水容量、堆砂容量との組 |
| 合せで決まる貯水池容量に対応する最高の水位がサーチャージ水位である。 |
|                                                                      |
| > 同様に、利水専用ダムにおいても                                     |
| 、サーチャージ水位を定める。この場合のサーチャージ水位は、貯水池運用 |
| 上定まる洪水時の初期水位、対象洪水及び洪水吐きの構造を検討して定める |
| が、このとき使用する対象洪水は、当該ダム地点の基本高水が年超過確率で |
| > 1/100                                                              |
| > 以上の規                                                           |
| 模である場合は当該ダム地点の基本高水を、基本高水が年超過確率で1/100  |
| > 以下の規模であるか、または、基本高水が定められていない場合         |
| には、当該ダム地点におけるコンクリートダムとしてのダム設計洪水流量の |
| > 80% の流量を基準として定める。                                     |
|                                                                      |
| 3．設計洪水位                                                        |
| ：本章1.3に示す水位である。なお、利水専用ダムにおける設計洪水位を定  |
| めるにあたっては、洪水吐きゲートを有さず、かつ、流域面積に比べ貯水池 |
| 面積の著しく大きいダムを除き、貯水池の貯留効果を考慮してはならない。 |
|                                                                      |
| 4．最低水位：貯水池の運用計画上の最低の水位であり、最低水位以        |
| 下の容量は堆砂容量あるいは死水容量として通常の計画では利用されない。 |
|                                                                      |
| 5                                                                    |
| ．堆砂位：貯水池流域の地形、地質、気象、水文状況等より貯水池の比堆砂 |
| 量を推定し、これを基にして求めた概ね100年間の堆砂量より定められる。  |
|                                                                      |
| 6                                                                    |
| ．堤体の下流側水位：ダムの設計において、堤体の下流側水位による静水圧 |
| など水平に作用する力は一般に堤体の安定計算上安全側に作用するが、間隙 |
| 水圧、揚圧力など鉛直に作用する力は危険側に作用する場合がある。したが |
| って、下流側水位は、設計に用いるそれぞれの貯水位に対して、これと同時 |
| に起こる可能性のある水位でダム構造物の安定計算上、最も危険側となる水 |
| 位状態をとり、ダム構造物の安定計算上、安全な設計となるよう設定する。 |
|                                                                      |
| 7．その他の水位：その他の水位についても、本章3.4に                   |
| 規定される荷重との組合せにおいて危険が予想される場合について定める。 |
+----------------------------------------------------------------------+

＜必　須＞

  ---------------------------------------------------------------------------------------------------------------------------------------------
  ダムの堤体設計の基準となる貯水池の水位等は、施行規則第1条で定めるもののほか、流域の水文特性及び貯水池の運用計画等に基づき定めるものとする。
  ---------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

41. 建設省河川局長通達：河川管理施設等構造令及び同令施行規則の施行について，昭和51年11月23日，建設省河政発第70号．

42. 河川砂防技術基準計画編，平成31年3月，国土交通省水管理・国土保全局
    施設配置等計

    画編 第2章 河川施設配置計画 第2-1章 河道並びに河川構造物 第3節
    貯水池（ダム）．

＜参考となる資料＞

ダムの構造計算に用いる設計水位については、下記の資料1)が参考となる。また、ダムの容量については、下記の資料2)が参考となる。

43. （財）国土開発技術研究センター編／（社）日本河川協会：改定　解説・河川管理施設等構造令，平成12年1月．

44. （財）ダム技術センター：多目的ダムの建設　平成17年版　第2巻　環境・調査Ⅰ編，平成17年6月．

    1.  []{#_Toc82025888 .anchor}荷重の組合せ

＜考え方＞

+----------------------------------------------------------------------+
| ダムの堤体及び基礎地盤（これと堤体との接合部を含む）に               |
| 関する安全性については具体的に構造計算等によって確かめる必要がある。 |
|                                                                      |
| 構造設計において考慮すべき荷重                                       |
| の種類と組合せは、構造令第6条において、以下のように定められている。  |
|                                                                      |
| +----------------------------------------------------------------+   |
| | （堤体等に作用する荷重の種類）                                 |   |
| |                                                                |   |
| | 第6                                                            |   |
| | 条　ダムの堤体及び基礎地盤に作用する荷重としては、ダムの種類及 |   |
| | び貯水池の水位に応じ、次の表に掲げるものを採用するものとする。 |   |
| |                                                                |   |
| | +----------+----------+----------+----------+----------+       |   |
| | | 　       | 重力式   | アーチ式 | フ       |          |       |   |
| | | 　　　　 |          |          | ィルダム |          |       |   |
| | | 　　ダム | コン     | コン     |          |          |       |   |
| | | の種類\  | クリート | クリート |          |          |       |   |
| | | \        |          |          |          |          |       |   |
| | | 貯水     | ダム     | ダム     |          |          |       |   |
| | | 池の水位 |          |          |          |          |       |   |
| | +==========+==========+==========+==========+==========+       |   |
| | | 1        | ダムの   | *W、P、  | *W、P、  | *W、     |       |   |
| | |          | 非越流部 | P~e~、*  | P~e~、*  | P、I、*  |       |   |
| | |          | の直上流 |          |          |          |       |   |
| | |          | 部におけ | *I、     | *I、P~   | *P~p~*   |       |   |
| | |          | る水位が | P~d~、U* | d~、U、* |          |       |   |
| | |          | 常時満水 |          |          |          |       |   |
| | |          | 位以下又 |          | *T*      |          |       |   |
| | |          | はサーチ |          |          |          |       |   |
| | |          | ャージ水 |          |          |          |       |   |
| | |          | 位以下で |          |          |          |       |   |
| | |          | ある場合 |          |          |          |       |   |
| | +----------+----------+----------+----------+----------+       |   |
| | | 2        | ダ       | *W、P、  | *W、P、  | *W、     |       |   |
| | |          | ムの非越 | P~e~、*  | P~e~、*  | P、P~p~* |       |   |
| | |          | 流部の直 |          |          |          |       |   |
| | |          | 上流部に | *U*      | *U、T*   |          |       |   |
| | |          | おける水 |          |          |          |       |   |
| | |          | 位が設計 |          |          |          |       |   |
| | |          | 洪水位で |          |          |          |       |   |
| | |          | ある場合 |          |          |          |       |   |
| | +----------+----------+----------+----------+----------+       |   |
| |                                                                |   |
| | 備考                                                           |   |
| |                                                                |   |
| | > こ                                                           |   |
| | の表において、*W*、*P*、*P~e~*、*I*、*P~d~*、*U*、*P~p\ ~*及び |   |
| | > *T* は、それぞれ次の荷重を表すものとする。                   |   |
| |                                                                |   |
| | *W*　ダム堤体の自重                                            |   |
| |                                                                |   |
| | *P*　貯留水による静水圧の力                                    |   |
| |                                                                |   |
| | *P~e~*　貯水池内に堆積する泥土による力                         |   |
| |                                                                |   |
| | *I*　地震時におけるダムの堤体の慣性力                          |   |
| |                                                                |   |
| | *P~d~*　地震時における貯留水による動水圧の力                   |   |
| |                                                                |   |
| | *U*　貯留水による揚圧力                                        |   |
| |                                                                |   |
| | *P~p~*　間げき                                                 |   |
| | 圧（ダムの堤体の内部及びダムの基礎地盤の浸透水による水圧）の力 |   |
| |                                                                |   |
| | *T*　ダムの堤体の内部の温度の変化によって生ずる力              |   |
| +----------------------------------------------------------------+   |
|                                                                      |
| 構造計算を行うにあたって必                                           |
| 要な荷重の種類と組合せについては、貯水池の水位とダムの種類に応じて表 |
| 2-3-2 に示すとおりである。                                           |
|                                                                      |
| 68. 荷重の組合せ                                                     |
|                                                                      |
| +----                                                                |
| ----------------------+--------------+--------------+--------------+ |
| | 　　                                                               |
| 　　　ダムの種類     | 重力式       | アーチ式     | フィルダム   |  |
| |                                                                    |
|                       |              |              |              | |
| | 貯水                                                               |
| 池の　　　　　　　　 | コンクリート | コンクリート |              |  |
| |                                                                    |
|                       |              |              |              | |
| | 水位                                                               |
| 状態　　　　　　　　 | ダム         | ダム         |              |  |
| +----                                                                |
| ----------------------+--------------+--------------+--------------+ |
| | 　常                                                               |
| 時満水位　           | 自重         | 自重         | 自重         |  |
| |                                                                    |
|                       |              |              |              | |
| | 　　                                                               |
| 　　　　　　　　　   | 静水圧       | 静水圧       | 静水圧       |  |
| |                                                                    |
|                       |              |              |              | |
| | 　　                                                               |
| 　　 及び            | 地震時動水圧 | 地震時動水圧 | 地震時慣性力 |  |
| |                                                                    |
|                       |              |              |              | |
| | 　　                                                               |
| 　　　　　　　　　   | （氷圧）     | （氷圧）     | 間隙圧       |  |
| |                                                                    |
|                       |              |              |              | |
| | 　サ                                                               |
| ーチャージ水位　     | 泥圧         | 泥圧         |              |  |
| |                                                                    |
|                       |              |              |              | |
| |                                                                    |
|                       | 地震時慣性力 | 地震時慣性力 |              | |
| |                                                                    |
|                       |              |              |              | |
| |                                                                    |
|                       | 揚圧力       | 揚圧力       |              | |
| |                                                                    |
|                       |              |              |              | |
| |                                                                    |
|                       |              | 温度荷重     |              | |
| +----                                                                |
| ----------------------+--------------+--------------+--------------+ |
| | 設計                                                               |
| 洪水位               | 自重         | 自重         | 自重         |  |
| |                                                                    |
|                       |              |              |              | |
| |                                                                    |
|                       | 静水圧       | 静水圧       | 静水圧       | |
| |                                                                    |
|                       |              |              |              | |
| |                                                                    |
|                       | 泥圧         | 泥圧         | 間隙圧       | |
| |                                                                    |
|                       |              |              |              | |
| |                                                                    |
|                       | 揚圧力       | 揚圧力       |              | |
| |                                                                    |
|                       |              |              |              | |
| |                                                                    |
|                       |              | 温度荷重     |              | |
| +----                                                                |
| ----------------------+--------------+--------------+--------------+ |
| | 最低                                                               |
| 水位                 | 自重         | 自重         |              |  |
| |                                                                    |
|                       |              |              |              | |
| |                                                                    |
|                       | 地震時慣性力 | 地震時慣性力 |              | |
| |                                                                    |
|                       |              |              |              | |
| |                                                                    |
|                       | 静水圧       | 静水圧       |              | |
| |                                                                    |
|                       |              |              |              | |
| |                                                                    |
|                       | 地震時動水圧 | 地震時動水圧 |              | |
| |                                                                    |
|                       |              |              |              | |
| |                                                                    |
|                       | 揚圧力       | 揚圧力       |              | |
| |                                                                    |
|                       |              |              |              | |
| |                                                                    |
|                       |              | 温度荷重     |              | |
| +----                                                                |
| ----------------------+--------------+--------------+--------------+ |
| | 水位                                                               |
| が急速に低下         |              |              | 自重         |  |
| |                                                                    |
|                       |              |              |              | |
| | した                                                               |
| 場合                 |              |              | 静水圧       |  |
| |                                                                    |
|                       |              |              |              | |
| |                                                                    |
|                       |              |              | 地震時慣性力 | |
| |                                                                    |
|                       |              |              |              | |
| |                                                                    |
|                       |              |              | 間隙圧       | |
| +----                                                                |
| ----------------------+--------------+--------------+--------------+ |
| | 中間                                                               |
| 水位                 |              |              | 自重         |  |
| |                                                                    |
|                       |              |              |              | |
| |                                                                    |
|                       |              |              | 静水圧       | |
| |                                                                    |
|                       |              |              |              | |
| |                                                                    |
|                       |              |              | 地震時慣性力 | |
| |                                                                    |
|                       |              |              |              | |
| |                                                                    |
|                       |              |              | 間隙圧       | |
| +----                                                                |
| ----------------------+--------------+--------------+--------------+ |
| | 貯水                                                               |
| 池空虚               | 自重         | 自重         | 自重         |  |
| |                                                                    |
|                       |              |              |              | |
| | （フ                                                               |
| ィルダムにあって     | 地震時慣性力 | 地震時慣性力 | 地震時慣性力 |  |
| |                                                                    |
|                       |              |              |              | |
| | は堤                                                               |
| 体完成直後）         |              | 温度荷重     | 間隙圧       |  |
| +----                                                                |
| ----------------------+--------------+--------------+--------------+ |
| |                                                                    |
|                       |              |              |              | |
| +----                                                                |
| ----------------------+--------------+--------------+--------------+ |
|                                                                      |
| 備　考                                                               |
|                                                                      |
| 　　自　重：ダムの堤体の自重                                         |
|                                                                      |
| 　　静水圧：貯留水による静水圧の力                                   |
|                                                                      |
| 　　泥　圧：貯水池内に堆積する泥土による力                           |
|                                                                      |
| 　　地震時慣性力：地震時におけるダムの堤体の慣性力                   |
|                                                                      |
| 　　地震時動水圧：地震時における貯留水による動水圧の力               |
|                                                                      |
| 　　揚圧力：貯留水による揚圧力                                       |
|                                                                      |
| 　　間隙圧                                                           |
| ：間隙圧（ダムの堤体の内部及びダムの基礎地盤の浸透水による水圧）の力 |
|                                                                      |
| 　　温度荷重：ダムの堤体の内部の温度の変化によって生ずる力           |
|                                                                      |
| 1．コンク                                                            |
| リートダム（特に重力式コンクリートダム）においては、常時の状態及び下 |
| 流向きの地震時慣性力を受けた状態では、高い水位状態での安全性が確認さ |
| れれば、低い水位状態では自動的にその安全性が確認されるのが一般である |
| 。しかし、上流向きの地震時慣性力を受けたときには水位の低い方が危険側 |
| となることがあるので、このような水位状態に対しての検討が必要である。 |
|                                                                      |
| 2．浸透流については通常は                                            |
| 、定常状態となった場合について検討する。したがって、フィルダムにあっ |
| ては、所要の水位状態が長期間継続したものとして水位を求め、その結果、 |
| 定常状態の浸潤線より低い堤体の部分は飽和状態にあるとして検討を行う。 |
|                                                                      |
| 3．フィルダム                                                        |
| における、表2-3-2中の「水位が急速に低下した場合」とは、一般に、貯水  |
| 池水位が常時満水位から貯水池運用計画における最低水位までの範囲で貯水 |
| 池運用計画に基づき急速に低下し、間隙圧が堤体内に残留する場合とする。 |
|                                                                      |
| > その他、サーチャージ水位と常時満水位との間の水位                   |
| においても当該ダムの実情に応じて必要な場合があれば追加して検討する。 |
|                                                                      |
| 4．フィルダムにおいて構造計算を実施する場合としては、                |
|                                                                      |
| \(1\) 常時満水位で浸透流が定常状態にある場合                         |
|                                                                      |
| \(2\) サーチャージ水位で浸透流が定常状態にある場合                   |
|                                                                      |
| \(3\) 設計洪水位で浸透流が定常状態にある場合                         |
|                                                                      |
| > \(4\)                                                              |
| > 貯水池の水位が常時満水位と最低水位との間のダムの安全性に最も       |
| 不利となる水位　（いわゆる中間水位）で浸透流が定常状態にある場合（中 |
| 間水位については、試算によって安全率の最小値を見つける必要がある。） |
|                                                                      |
| \(5\) 水位を急速に低下させる場合                                     |
|                                                                      |
| \(6\) 完成直後で建設中の間隙圧が残留する場合                         |
|                                                                      |
| が一般的である。                                                     |
|                                                                      |
| > 特に、均一型ダムや細粒分の多い遮水                                 |
| 材料を使ったダムでは間隙圧の影響が大きいので完成直後の状態についても |
| 安全度を確かめることが重要である。この場合地震時慣性力については、表 |
| > 2-3-3に示す値の 1/2 を使用して求めることができる。                 |
|                                                                      |
| 5．氷圧                                                              |
|                                                                      |
| > 極寒地で、貯水池の対岸距離が短く、大きな氷圧の                     |
| 発生が予想される場合は、ダムの堤体及びゲートの設計に氷圧を考慮する。 |
| >                                                                    |
| > 貯水池の表面が結氷している場合、                                   |
| 氷の温度が上昇すれば氷圧を生ずる。ただし、氷の下面部で貯水に接してい |
| る付近には氷圧は生じない。氷圧は気温の上昇度、氷厚、貯水池両岸の状況 |
| 、結氷面に対する直射日光の度合等によって変化するものとされている。図 |
| > 2-3-1に既往                                                        |
| の実測資料より求めた氷厚とダム軸に直角水平方向の氷圧との関係を示す。 |
| >                                                                    |
| > ただし、                                                           |
| 我が国ではダム本体の安定計算には一般に氷圧は、算入されない。それは、 |
| 冬期にダムの安定計算で考慮するような波浪と氷圧（従来我が国では最大値 |
| > 147kN/m^2^程度と考えられていた）と                                 |
| が同時に発生すると考える必要がなく、一般にダムの下部では前者をとるほ |
| うが安全側であり、また、上部では両者による影響の差が小さいので、安定 |
| 計算には波浪による影響を取り入れるだけでよいと考えられるからである。 |
|                                                                      |
| ![](media/image148.png){width="4.740277777777778in"                  |
| height="3.2402777777777776in"}                                       |
|                                                                      |
| 101. 氷厚と氷圧との関係                                              |
+----------------------------------------------------------------------+

＜必　須＞

  -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  ダムの堤体及び基礎地盤（これと堤体との接合部を含む）に関する構造設計において考慮すべき荷重の種類と組合せは、貯水池の水位及びダムの型式に応じて構造令第6条で定められたものを用いるものとする。
  -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

45. 建設省河川局長通達：河川管理施設等構造令及び同令施行規則の施行について，昭和51年11月23日，建設省河政発第70号．

＜参考となる資料＞

> ダムの構造計算に用いる荷重の組合せについては、下記の資料が参考となる。

46. （財）国土開発技術研究センター編／（社）日本河川協会：改定　解説・河川管理施設等構造令，平成12年1月．

47. （財）ダム技術センター：多目的ダムの建設　平成17年版　第4巻　設計Ⅰ編，平成17年1月．

    1.  []{#_Toc82025889 .anchor}荷重の計算法

        1.  []{#_Toc82025890 .anchor}自重

＜考え方＞

+----------------------------------------------------------------------+
| ダム                                                                 |
| の堤体の自重は、施行規則第3条において、以下のように定められている。  |
|                                                                      |
| +----------------------------------------------------------------+   |
| | （ダムの堤体の自重）                                           |   |
| |                                                                |   |
| | 規則第3条　河川管理                                            |   |
| | 施設等構造令（以下「令」という。）第6条のダムの堤体の自重は、  |   |
| | ダムの堤体の材料の単位体積重量を基礎として計算するものとする。 |   |
| +----------------------------------------------------------------+   |
|                                                                      |
| ダムの自重は設計上大きな要素となる。それに用いる単位体積重量         |
| は、実際に使用する材料について試験を行い決定するのが原則である。詳細 |
| については、コンクリートダムは本章4.2、フィルダムは本章5.2で述べる。 |
+----------------------------------------------------------------------+

＜必　須＞

  ---------------------------------------------------------------------
  堤体の自重は、施行規則第3条で定める方法によって計算するものとする。
  ---------------------------------------------------------------------

＜標　準＞

  ------------------------------------------------------------------------------------------
  堤体材料の単位体積重量は、実際に使用する材料について試験を行い決定することを基本とする。
  ------------------------------------------------------------------------------------------

＜関連通知等＞

48. 建設省河川局長通達：河川管理施設等構造令及び同令施行規則の施行について，昭和51年11月23日，建設省河政発第70号．

＜参考となる資料＞

ダムの堤体の自重の計算方法については、下記の資料が参考となる。

49. （財）国土開発技術研究センター編／（社）日本河川協会：改定　解説・河川管理施設等構造令，平成12年1月．

    1.  []{#_Toc82025891 .anchor}静水圧

＜考え方＞

+----------------------------------------------------------------------+
| 貯留水によ                                                           |
| る静水圧の力は、施行規則第4条において、以下のように定められている。  |
|                                                                      |
| +----------------------------------------------------------------+   |
| | （貯留水による静水圧の力）                                     |   |
| |                                                                |   |
| | 規則第4条　令第6                                               |   |
| | 条の貯留水による静水圧の力は、ダムの堤体と貯留水との接触面に対 |   |
| | して垂直に作用するものとし、次の式によって計算するものとする。 |   |
| |                                                                |   |
| | > *P*＝*W*~0~*h*~0~                                            |   |
| |                                                                |   |
| | この式において、*P*、*W*~0~及び                                |   |
| | *h*~0~は、それぞれ次の数値を表すものとする。                   |   |
| |                                                                |   |
| | *P*                                                            |   |
| | 　貯留水による静水圧の力（単位　1平方メートルにつき重量トン）  |   |
| |                                                                |   |
| | *W*~0~ 　水の単位体積重量（単位　1立方メートルにつき重量トン） |   |
| |                                                                |   |
| | > *h*~0~                                                       |   |
| | > 　次の表の中欄に掲げる区                                     |   |
| | 分に応じ、同表の下欄に掲げる水位からダムの堤体と貯留水との接触 |   |
| | 面上の静水圧の力を求めようとする点までの水深（単位　メートル） |   |
| |                                                                |   |
| | +----+-------------------------+-------------------------+     |   |
| | | 項 | 貯水池の水位            | ダムの非越流部の        |     |   |
| | |    |                         | 直上流部における波浪を  |     |   |
| | |    |                         |                         |     |   |
| | |    |                         | 考慮した                |     |   |
| | |    |                         | 水位（単位　メートル）  |     |   |
| | +====+=========================+=========================+     |   |
| | | 1  | ダムの非越流部          | 常時満水位に風          |     |   |
| | |    | の直上流部における水位  | による波浪の貯水池の水  |     |   |
| | |    | が常時満水位である場合  | 面からの高さ及び地震に  |     |   |
| | |    |                         | よる波浪の貯水池の水面  |     |   |
| | |    |                         | からの高さを加えた水位  |     |   |
| | +----+-------------------------+-------------------------+     |   |
| | | 2  | ダムの非越流部の直上    | サーチ                  |     |   |
| | |    | 流部における水位がサー  | ャージ水位に風による波  |     |   |
| | |    | チャージ水位である場合  | 浪の貯水池の水面からの  |     |   |
| | |    |                         | 高さ及び地震による波浪  |     |   |
| | |    |                         | の貯水池の水面からの高  |     |   |
| | |    |                         | さの2分の1を加えた水位  |     |   |
| | +----+-------------------------+-------------------------+     |   |
| | | 3  | ダムの非越流部          | 設計洪永位に風に        |     |   |
| | |    | の直上流部における水位  | よる波浪の貯水池の水面  |     |   |
| | |    | が設計洪水位である場合  | からの高さを加えた水位  |     |   |
| | +----+-------------------------+-------------------------+     |   |
| |                                                                |   |
| | 2．令第5条第                                                   |   |
| | 1項及び前項の地震による波浪の貯水池の水面からの高さは、第2条第 |   |
| | 1項の規定により定めた設計震度の値を用いて計算するものとする。  |   |
| +----------------------------------------------------------------+   |
|                                                                      |
| ダムの安定計算に用いる静水圧は、設計の対象となるそれぞれの水位       |
| に風による波浪の貯水池の水面からの高さを加えた水位によって計算する。 |
|                                                                      |
| 地震時のダムの安定計算において、本                                   |
| 章3.5.6に規定する地震時動水圧と組み合わせて用いる静水圧は、さらに、  |
| 地震による波浪の貯水池の水面からの高さを加えた水位によって計算する。 |
|                                                                      |
| フィルダムのスライス法による安定計算において、水面下の               |
| 静水圧状態の部分に飽和重量を用いた場合の外力としての水圧は、堤体表面 |
| に作用する水圧、スライスのすべり面と側面に垂直に作用する水圧である。 |
|                                                                      |
| 堤体内の間隙                                                         |
| 圧としては、常時満水位時、サーチャージ水位時及び設計洪水位時には、そ |
| れぞれの水位による定常浸透圧を、水位急低下時には、残留間隙圧を、完成 |
| 直後には建設中の間隙圧を考慮する。計算法は、本章5.3で詳しく述べる。  |
+----------------------------------------------------------------------+

＜必　須＞

  -----------------------------------------------------------------
  静水圧は、施行規則第4条で定める方法によって計算するものとする。
  -----------------------------------------------------------------

＜関連通知等＞

50. 建設省河川局長通達：河川管理施設等構造令及び同令施行規則の施行について，昭和51年　11月23日，建設省河政発第70号．

＜参考となる資料＞

貯留水による静水圧の力の計算方法については、下記の資料が参考となる。

51. （財）国土開発技術研究センター編／（社）日本河川協会：改定　解説・河川管理施設等構造令，平成12年1月．

    1.  []{#_Toc82025892 .anchor}泥圧

＜考え方＞

+----------------------------------------------------------------------+
| 貯水池内に堆積する泥土（以下「堆泥」とい                             |
| う）による力は、施行規則第5条において、以下のように定められている。  |
|                                                                      |
| +----------------------------------------------------------------+   |
| | （貯水池内に堆積する泥土による力）                             |   |
| |                                                                |   |
| | 規則第5条　令第6条の貯水池内に堆積する泥土に                   |   |
| | よる力は、ダムの堤体と貯水池内に堆積する泥土との接触面において |   |
| | 鉛直方向及び水平方向に作用するものとし、鉛直方向に作用する力は |   |
| | 堆積する泥土の水中における単位体積重量を基礎として計算するもの |   |
| | とし、水平方向に作用する力は次の式によって計算するものとする。 |   |
| |                                                                |   |
| | *P~e~*＝*C~e~W*~1~*d*                                          |   |
| |                                                                |   |
| | この式において、*P~e~*、*C~e~*、*W*~1~及び                     |   |
| | *d*は、それぞれ次の数値を表すものとする。                      |   |
| |                                                                |   |
| | *P~e~*　泥土による水平力（単位　1平方メートルにつき重量トン）  |   |
| |                                                                |   |
| | > *C~e~*　適切な工学試験の結                                   |   |
| | 果又は類似のダムの構造計算に用いられた値に基づき定める泥圧係数 |   |
| | >                                                              |   |
| | > *W*~1~　堆積する泥土の                                       |   |
| | 水中における単位体積重量（単位　1立方メートルにつき重量トン）  |   |
| | >                                                              |   |
| | > *d*　貯水池内に堆積す                                        |   |
| | ると予想される泥土面からダムの堤体と堆積する泥土との接触面上の |   |
| | 泥土による水平力を求めようとする点までの深さ（単位　メートル） |   |
| +----------------------------------------------------------------+   |
|                                                                      |
| 設計に用いる堆泥の深さは、貯水池計画において想定される概ね           |
| 100年間の堆泥量を基に、一般に河                                      |
| 状、貯水池面積の広狭、水深の大小等の貯水池の状況を考慮して推定する。 |
|                                                                      |
| 堆泥の重量は、                                                       |
|                                                                      |
| 　　　*W*~1~＝*W*－(1－ν* *)・*W*~0~                                 |
|                                                                      |
| で示される。ここにW~0~                                               |
| は水の単位体積重量（kN/m^3^）                                        |
| 、Wは堆泥の見掛けの単位体積重量（kN/m^3^）、νは堆泥の空隙率である。  |
|                                                                      |
| これらの概略値として、下記の数値が常用される。                       |
|                                                                      |
| 　　　W＝14.7～17.7 kN/m^3^、ν＝ 0.3～0.4、C~e~＝                    |
| 0.4～0.6、W~0~＝9.81 kN/m^3^                                         |
|                                                                      |
| なお、地震による動泥圧は、一般に本章3.5.6                            |
| に後述する地震時動水圧を堆泥部も含めて考慮することで別途考慮しない。 |
|                                                                      |
| 貯水池の堆砂層を支配する因子と                                       |
| しては、地形、地質、気象、水文、その他の流域特性及び貯水池特性などが |
| あり、これらの因子は複雑に関連しあっているので、近傍類似水系の既設貯 |
| 水池の堆砂実績及び各種公式等に基づき的確に推定することが必要である。 |
|                                                                      |
| > 堆砂形状については河川及び貯水池の形                               |
| 状、流入土砂の粒度特性、貯水池の年間変動形態、洪水規模と頻度、堆砂の |
| 進行状況などに影響され、通常、傾斜形状を呈するが、ダムの堤体の安定計 |
| 算においては安全側となるよう考慮して、水平堆砂とすることとしている。 |
+----------------------------------------------------------------------+

＜必　須＞

  -----------------------------------------------------------------------------------------
  貯水池内に堆積する泥土による力は、施行規則第5条で定める方法によって計算するものとする。
  -----------------------------------------------------------------------------------------

＜標　準＞

  --------------------------------------------------------------------------------------------------------------
  ダムの構造設計に用いる堆砂位は、想定される 100年間の堆砂量が水平に堆砂するとした標高とすることを基本とする。
  --------------------------------------------------------------------------------------------------------------

＜関連通知等＞

52. 建設省河川局長通達：河川管理施設等構造令及び同令施行規則の施行について，昭和51年11月23日，建設省河政発第70号．

＜参考となる資料＞

貯水池内に堆積する泥土による力の計算方法については、下記の資料が参考となる。

53. （財）国土開発技術研究センター編／（社）日本河川協会：改定　解説・河川管理施設等構造令，平成12年1月．

    1.  []{#_Toc82025893 .anchor}揚圧力

＜考え方＞

+----------------------------------------------------------------------+
| 貯留水による揚圧力は、堤体内及び基礎地盤に水が浸透する               |
| ことによって発生する間隙圧を断面力として扱ったもので、本質的には間隙 |
| 圧の力と同じのものである。技術的慣習、工学計算の便宜さから、コンクリ |
| ートダムでは揚圧力を考慮する。また、フィルダムでは間隙圧を考慮する。 |
|                                                                      |
| コンクリートダムの底面に作                                           |
| 用する揚圧力は、施行規則第8条において、以下のように定められている。  |
|                                                                      |
| +----------------------------------------------------------------+   |
| | （貯留水による揚圧力）                                         |   |
| |                                                                |   |
| | 規則第8条　令第6                                               |   |
| | 条の貯留水による揚圧力は、ダムの堤体及び基礎地盤における揚圧力 |   |
| | を求めようとする断面に対して垂直上向きに作用するものとし、断面 |   |
| | の区分に応じ、次の表に掲げる値を基礎として計算するものとする。 |   |
| |                                                                |   |
| | +-------+-------+-------+-------+-------+-------+-------+      |   |
| | | 断面  | \(1\) | \(2\) | \(3\) |       |       |       |      |   |
| | | 上の  |       |       |       |       |       |       |      |   |
| | | 位置  |       |       |       |       |       |       |      |   |
| | |       |       |       |       |       |       |       |      |   |
| | | 断    |       |       |       |       |       |       |      |   |
| | | 面の  |       |       |       |       |       |       |      |   |
| | | 区分  |       |       |       |       |       |       |      |   |
| | +=======+=======+=======+=======+=======+=======+=======+      |   |
| | |       | 上    | 上    | 下    |       |       |       |      |   |
| | |       | 流端  | 流端  | 流端  |       |       |       |      |   |
| | |       |       | と下  |       |       |       |       |      |   |
| | |       |       | 流端  |       |       |       |       |      |   |
| | |       |       | の間  |       |       |       |       |      |   |
| | +-------+-------+-------+-------+-------+-------+-------+      |   |
| | | 1     | 排    | 上    | (イ)  | (ロ)  | (ハ)  | 下    |      |   |
| | |       | 水孔  | 流側  |       |       |       | 流側  |      |   |
| | |       | の効  | 水圧  |       |       |       | 水圧  |      |   |
| | |       | 果が  | の値  |       |       |       | の値  |      |   |
| | |       | 及ぶ  |       |       |       |       |       |      |   |
| | |       | 断面  |       |       |       |       |       |      |   |
| | +-------+-------+-------+-------+-------+-------+-------+      |   |
| | |       |       |       | 上    | 排    | 排水  |       |      |   |
| | |       |       |       | 流端  | 水孔  | 孔と  |       |      |   |
| | |       |       |       | と排  |       | 下流  |       |      |   |
| | |       |       |       | 水孔  |       | 端と  |       |      |   |
| | |       |       |       | の間  |       | の間  |       |      |   |
| | +-------+-------+-------+-------+-------+-------+-------+      |   |
| | |       |       |       | (1    | (1    | (2)   |       |      |   |
| | |       |       |       | )欄の | )欄の | の(ロ |       |      |   |
| | |       |       |       | 値と( | 値と  | )欄の |       |      |   |
| | |       |       |       | 2)の( | (3)欄 | 値と  |       |      |   |
| | |       |       |       | ロ)欄 | の値  | (3)欄 |       |      |   |
| | |       |       |       | の値  | との  | の値  |       |      |   |
| | |       |       |       | とを  | 差の  | とを  |       |      |   |
| | |       |       |       | 直線  | 5分の | 直線  |       |      |   |
| | |       |       |       | 的に  | 1以上 | 的に  |       |      |   |
| | |       |       |       | 変化  | の値  | 変化  |       |      |   |
| | |       |       |       | させ  | に(3  | させ  |       |      |   |
| | |       |       |       | た値  | )欄の | た値  |       |      |   |
| | |       |       |       |       | 値を  |       |       |      |   |
| | |       |       |       |       | 加え  |       |       |      |   |
| | |       |       |       |       | た値  |       |       |      |   |
| | +-------+-------+-------+-------+-------+-------+-------+      |   |
| | | 2     | 排水  | 上流  | (1    | 下    |       |       |      |   |
| | |       | 孔の  | 側水  | )欄の | 流側  |       |       |      |   |
| | |       | 効果  | 圧と  | 値と  | 水圧  |       |       |      |   |
| | |       | が及  | 下流  | (3)欄 | の値  |       |       |      |   |
| | |       | ばな  | 側水  | の値  |       |       |       |      |   |
| | |       | い断  | 圧と  | とを  |       |       |       |      |   |
| | |       | 面又  | の差  | 直線  |       |       |       |      |   |
| | |       | は排  | の3分 | 的に  |       |       |       |      |   |
| | |       | 水孔  | の1以 | 変化  |       |       |       |      |   |
| | |       | の無  | 上の  | させ  |       |       |       |      |   |
| | |       | いダ  | 値に  | た値  |       |       |       |      |   |
| | |       | ムの  | 下流  |       |       |       |       |      |   |
| | |       | 断面  | 側水  |       |       |       |       |      |   |
| | |       |       | 圧を  |       |       |       |       |      |   |
| | |       |       | 加え  |       |       |       |       |      |   |
| | |       |       | た値  |       |       |       |       |      |   |
| | +-------+-------+-------+-------+-------+-------+-------+      |   |
| +----------------------------------------------------------------+   |
|                                                                      |
| コンクリートダムでは、基礎地盤の状況等から判                         |
| 断して基礎排水孔を設けることが適切でないと考えられる場合を除いて、基 |
| 礎排水孔を設ける。また、軟岩基礎や一部に軟弱な層を含む基礎の場合には |
| 、施行規則第8条に定める値では過小になる場合があるので注意を要する。  |
|                                                                      |
| 両岸の高標高部断                                                     |
| 面や、河床部断面においても放流管等の堤内構造物の配置から、基礎排水孔 |
| の設置標高の条件として、堤体底面から孔口標高までの高さが施行規則第8  |
| 条の(1)欄の値と(3)欄の値の差の5分の1以下とならない場合は、基礎排水孔 |
| の設置標高を考慮して基礎排水孔位置の揚圧力の値を修正する必要がある。 |
|                                                                      |
| また、堤体内の断                                                     |
| 面に作用する揚圧力を考慮する場合の分布についても上記に準じて定める。 |
|                                                                      |
| アーチ式                                                             |
| コンクリートダムの底面に作用する揚圧力は、重力式コンクリートダムの場 |
| 合と同様に作用するものとして考慮する。ただし、アーチ式コンクリートダ |
| ムの場合、揚圧力を考慮しない方が堤体の安定性に与える影響が大きくなる |
| 場合があるため、揚圧力を考慮しない場合の安定性検討も行う必要がある。 |
|                                                                      |
| 揚圧力の値                                                           |
| は、波浪及び貯水池水位の短時間の変化の影響を受けないこととしている。 |
+----------------------------------------------------------------------+

＜必　須＞

  -----------------------------------------------------------------------------------------------
  コンクリートダムの底面に作用する揚圧力は、施行規則第8条に定める方法により計算するものとする。
  -----------------------------------------------------------------------------------------------

＜関連通知等＞

54. 建設省河川局長通達：河川管理施設等構造令及び同令施行規則の施行について，昭和51年11月23日，建設省河政発第70号．

＜参考となる資料＞

揚圧力の計算方法については、下記の資料が参考となる。

55. （財）国土開発技術研究センター編／（社）日本河川協会：改定　解説・河川管理施設等構造令，平成12年1月．

56. （財）ダム技術センター：多目的ダムの建設　平成17年版　第4巻　設計Ⅰ編，平成17年1月．

    1.  []{#_Toc82025894 .anchor}地震時慣性力

＜考え方＞

+----------------------------------------------------------------------+
| 地震時におけるダムの                                                 |
| 堤体の慣性力は、施行規則第6条において、以下のように定められている。  |
|                                                                      |
| +----------------------------------------------------------------+   |
| | （地震時におけるダムの堤体の慣性力）                           |   |
| |                                                                |   |
| | 規則第                                                         |   |
| | 6条　令第6条の地震時におけるダムの堤体の慣性力は、ダムの堤体に |   |
| | 水平方向に作用するものとし、次の式によって計算するものとする。 |   |
| |                                                                |   |
| | *I* ＝*WK~d~*                                                  |   |
| |                                                                |   |
| | この式にお                                                     |   |
| | いて、*I*、*W*及び*K~d~*は、それぞれ次の数値を表すものとする。 |   |
| |                                                                |   |
| | *I*　地震時に                                                  |   |
| | おけるダムの堤体の慣性力（単位　1立方メートルにつき重量トン）  |   |
| |                                                                |   |
| | *W*　ダムの堤体の自重（単位　1立方メートルにつき重量トン）     |   |
| |                                                                |   |
| | > *K~d~*　第2条第1項又は第2項の規定により定めた設計震度        |   |
| +----------------------------------------------------------------+   |
|                                                                      |
| ダムの構造計算に用                                                   |
| いる設計震度は、施行規則第2条において、以下のように定められている。  |
|                                                                      |
| +----------------------------------------------------------------+   |
| | （ダムの構造計算に用いる設計震度）                             |   |
| |                                                                |   |
| | 規則第2条　ダムの                                              |   |
| | 構造計算に用いる設計震度は、ダムの種類及び地域の区分に応じ、次 |   |
| | の表に掲げる値以上の値で当該ダムの実情に応じて定める値とする。 |   |
| |                                                                |   |
| | +---------+---------+---------+---------+------+------+        |   |
| | | 地域    | 強震    | 中震    | 弱震    |      |      |        |   |
| | | の区分  | 帯地域  | 帯地域  | 帯地域  |      |      |        |   |
| | |         |         |         |         |      |      |        |   |
| | | ダム    |         |         |         |      |      |        |   |
| | | の種類  |         |         |         |      |      |        |   |
| | +=========+=========+=========+=========+======+======+        |   |
| | | 1\.     | 重力    | 0.12    | 0.12    | 0.10 |      |        |   |
| | |         | 式コン  |         |         |      |      |        |   |
| | |         | クリー  |         |         |      |      |        |   |
| | |         | トダム  |         |         |      |      |        |   |
| | +---------+---------+---------+---------+------+------+        |   |
| | | 2\.     | アーチ  | 0.24    | 0.24    | 0.20 |      |        |   |
| | |         | 式コン  |         |         |      |      |        |   |
| | |         | クリー  |         |         |      |      |        |   |
| | |         | トダム  |         |         |      |      |        |   |
| | +---------+---------+---------+---------+------+------+        |   |
| | | 3\.     | フィ    | ダム    | 0.15    | 0.15 | 0.12 |        |   |
| | |         | ルダム  | の堤体  |         |      |      |        |   |
| | |         |         | がおお  |         |      |      |        |   |
| | |         |         | むね均  |         |      |      |        |   |
| | |         |         | 一の材  |         |      |      |        |   |
| | |         |         | 料によ  |         |      |      |        |   |
| | |         |         | るもの  |         |      |      |        |   |
| | +---------+---------+---------+---------+------+------+        |   |
| | |         |         | その他  | 0.15    | 0.12 | 0.10 |        |   |
| | |         |         | のもの  |         |      |      |        |   |
| | +---------+---------+---------+---------+------+------+        |   |
| |                                                                |   |
| | 2　ダムの非越流部の直上流部における水位がサーチャージ水位であ  |   |
| | る場合は、第4条第2項の場合を除き、ダムの構造計算に用いる設計震 |   |
| | 度は、前項の規定により定めた値の2分の1の値とすることができる。 |   |
| |                                                                |   |
| | 3　アーチ式コンクリートダムのゲートを堤体以外                  |   |
| | の場所に設ける場合における当該ゲートの構造計算に用いる設計震度 |   |
| | は、前2項の規定により定めた値の2分の1の値とすることができる。  |   |
| |                                                                |   |
| | 4　第1項の表に掲げる強震帯地域、中                             |   |
| | 震帯地域及び弱震帯地域は、国土交通大臣が別に定めるものとする。 |   |
| +----------------------------------------------------------------+   |
|                                                                      |
| 設計震度の値は、図2-3                                                |
| -2に示す「建設省告示第1715号（昭和56年10月16日）」による地域区分、基 |
| 礎地盤の状態及びダムの型式を考慮して、表2-3-3に示す値を目安とする。  |
|                                                                      |
| 設計震度の値は、表2-3-3に示す値を目安に設定する                      |
| が、ダム地点周辺における既往地震の履歴、基礎地盤の地質、堤体の動力学 |
| 的特性等を考慮して特に必要のある場合には、当該目安以上の値を定める。 |
|                                                                      |
| なお、ダム本                                                         |
| 体とは別の隣接型及び分離型洪水吐きで、重力式コンクリートダムの型式を |
| とるものについては、表2-3-3の重力式コンクリートダムの値を適用する。  |
|                                                                      |
| ダムの非越流部の直上流部におけ                                       |
| る水位がサーチャージ水位にある場合についての設計震度に関しては、施行 |
| 規則第2条の規定のとおり、常時の水位時の1/2の設計震度を考慮することが |
| できる。また、同水位が設計洪水位である場合は、本章3.4に定めるように  |
| 地震時慣性力や地震時動水圧を考慮しない。これは、ダムの堤体の安定計算 |
| にあたっては、地震時、平常時を問わず、ダムの型式に応じた同一の所要安 |
| 全率を満足するよう計算することとしているために、それぞれの水位の発生 |
| 頻度等を考慮して、堤体に負荷する荷重の大きさを定めているものである。 |
|                                                                      |
| コンクリートダムにおいて貯                                           |
| 水池空虚時の安定を検討するとき、フィルダムにおいて完成直後の安定を検 |
| 討するとき及び水位急低下が日常行われないダムにおいて水位急低下時の安 |
| 定計算をするときは、表2-3-3に示す値の2分の1の値とすることができる。  |
|                                                                      |
| ![](media/image149.png){width="6.127083333333333in"                  |
| height="3.9270833333333335in"}                                       |
|                                                                      |
| 102. 設計震度の地域区分                                              |
|                                                                      |
| ```{=html}                                                           |
| <!-- -->                                                             |
| ```                                                                  |
| 69. 設計震度                                                         |
|                                                                      |
| +---------+---------+---------+---------+---------+---------+        |
| |         | ダムの  | 重力式  | ア      | ゾ      | 均一型  |        |
| |         |         |         | ーチ式  | ーン型  |         |        |
| |         | 基      | コンク  |         |         | フィ    |        |
| |         | 礎条件  | リート  | コン    | フィ    | ルダム  |        |
| |         |         | ダム、  | クリー  | ルダム  |         |        |
| |         |         |         | トダム  |         |         |        |
| |         |         | 中空    |         |         |         |        |
| |         |         | 重力式  |         |         |         |        |
| |         |         |         |         |         |         |        |
| |         |         | コン    |         |         |         |        |
| |         |         | クリー  |         |         |         |        |
| |         |         | トダム  |         |         |         |        |
| +---------+---------+---------+---------+---------+---------+        |
| | 強      | 通      | 0.1     | 0.2     | 0.15    | 0.1     |        |
| |         | 常の岩  | 2～0.15 | 4～0.30 |         | 5～0.18 |        |
| | 震      | 盤基礎  |         |         |         |         |        |
| |         |         |         |         |         |         |        |
| | 帯      |         |         |         |         |         |        |
| |         |         |         |         |         |         |        |
| | 地      |         |         |         |         |         |        |
| |         |         |         |         |         |         |        |
| | 域      |         |         |         |         |         |        |
| +---------+---------+---------+---------+---------+---------+        |
| |         | 土      | ―       | ―       | 0.18    | 0.20    |        |
| |         | 　質　  |         |         |         |         |        |
| |         | 基　礎  |         |         |         |         |        |
| +---------+---------+---------+---------+---------+---------+        |
| | 中      | 通      | 0.12    | 0.24    | 0.1     | 0.15    |        |
| |         | 常の岩  |         |         | 2～0.15 |         |        |
| | 震      | 盤基礎  |         |         |         |         |        |
| |         |         |         |         |         |         |        |
| | 帯      |         |         |         |         |         |        |
| |         |         |         |         |         |         |        |
| | 地      |         |         |         |         |         |        |
| |         |         |         |         |         |         |        |
| | 域      |         |         |         |         |         |        |
| +---------+---------+---------+---------+---------+---------+        |
| |         | 土      | ―       |         | 0.1     | 0.1     |        |
| |         | 　質　  |         |         | 5～0.18 | 8～0.20 |        |
| |         | 基　礎  |         |         |         |         |        |
| +---------+---------+---------+---------+---------+---------+        |
| | 弱      | 通      | 0.1     | 0.2     | 0.1     | 0.12    |        |
| |         | 常の岩  | 0～0.12 | 0～0.24 | 0～0.12 |         |        |
| | 震      | 盤基礎  |         |         |         |         |        |
| |         |         |         |         |         |         |        |
| | 帯      |         |         |         |         |         |        |
| |         |         |         |         |         |         |        |
| | 地      |         |         |         |         |         |        |
| |         |         |         |         |         |         |        |
| | 域      |         |         |         |         |         |        |
| +---------+---------+---------+---------+---------+---------+        |
| |         | 土      | ―       | ―       | 0.15    | 0.18    |        |
| |         | 　質　  |         |         |         |         |        |
| |         | 基　礎  |         |         |         |         |        |
| +---------+---------+---------+---------+---------+---------+        |
| | （注    |         |         |         |         |         |        |
| | ）これ  |         |         |         |         |         |        |
| | らの値  |         |         |         |         |         |        |
| | は目安  |         |         |         |         |         |        |
| | の値で  |         |         |         |         |         |        |
| | あり、  |         |         |         |         |         |        |
| | 当該地  |         |         |         |         |         |        |
| | 域の地  |         |         |         |         |         |        |
| | 震履歴  |         |         |         |         |         |        |
| | 、地質  |         |         |         |         |         |        |
| | 条件、  |         |         |         |         |         |        |
| | 堤体の  |         |         |         |         |         |        |
| | 動力学  |         |         |         |         |         |        |
| | 的特性  |         |         |         |         |         |        |
| | を考慮  |         |         |         |         |         |        |
| | してこ  |         |         |         |         |         |        |
| | れらの  |         |         |         |         |         |        |
| | 値以上  |         |         |         |         |         |        |
| | をとる  |         |         |         |         |         |        |
| | ことと  |         |         |         |         |         |        |
| | する。  |         |         |         |         |         |        |
| +---------+---------+---------+---------+---------+---------+        |
|                                                                      |
| 高さ100m以下のフィルダムについては、構造令で示された設計震度以       |
| 外に、地震時の堤体応答を考慮した設計震度である修正震度法によっても堤 |
| 体の耐震性を確認する必要がある。確認の方法の詳細は本章5.3.2に示す。  |
+----------------------------------------------------------------------+

＜必　須＞

  -----------------------------------------------------------------------------------------
  地震時におけるダムの堤体の慣性力は、施行規則第6条に定める方法により計算するものとする。
  -----------------------------------------------------------------------------------------

＜標　準＞

  -----------------------------------------------------------------------------------------------------------------------
  高さ100m以下のフィルダムの堤体については、本章5.3.2に示す方法によっても地震に対する安全性を確認することを基本とする。
  -----------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

57. 建設省河川局長通達：河川管理施設等構造令及び同令施行規則の施行について，昭和51年11月23日，建設省河政発第70号．

58. 建設省河川開発課長通知：「フィルダムの耐震設計指針（案）」について，平成3年4月1日，建設省河開発第49号．

59. 建設省告示第1715号，昭和56年10月16日．

＜参考となる資料＞

地震時慣性力の計算方法については、下記の資料が参考となる。

60. （財）国土開発技術研究センター編／（社）日本河川協会：改定　解説・河川管理施設等構造令，平成12年1月．

61. 建設省河川局開発課監修／（財）国土開発技術研究センター発行：フィルダムの耐震設計指針（案），平成3年6月．

    1.  []{#_Toc82025895 .anchor}地震時動水圧

＜考え方＞

+----------------------------------------------------------------------+
| 地震                                                                 |
| 時に堤体に働く外力には、地震時慣性力のほかに、貯留水の動水圧がある。 |
|                                                                      |
| 地震時における貯留水によ                                             |
| る動水圧の力は、施行規則第7条において、以下のように定められている。  |
|                                                                      |
| +----------------------------------------------------------------+   |
| | （地震時における貯留水による動水圧の力）                       |   |
| |                                                                |   |
| | 規則第7条　令第6条の地震時における貯留水による動               |   |
| | 水圧の力は、ダムの堤体と貯留水との接触面に対して垂直に作用する |   |
| | ものとし、適切な工学試験又は類似のダムの構造計算に用いられた方 |   |
| | 法に基づき定める場合を除き、次の式によって計算するものとする。 |   |
| |                                                                |   |
| | 　　$p_{d} = 0.875W_{0}K_{d}\sqrt{H_{1} \bullet h_{1}}$        |   |
| |                                                                |   |
| | この式において、*p~d~*、*W*~0~、                               |   |
| | *K~d~*、*H*~1~及び*h*~1~は、それぞれ次の数値を表すものとする。 |   |
| |                                                                |   |
| | *p~d~*　地震時における貯留水による動水圧の力（単位             |   |
| | 1平方メートルにつき重量トン）                                  |   |
| |                                                                |   |
| | *W*~0~　水の単位体積重量（単位 1立方メートルにつき重量トン）   |   |
| |                                                                |   |
| | *K~d~*　第2条第1項又は第2項の規定により定めた設計震度          |   |
| |                                                                |   |
| | > *H*~1~　ダ                                                   |   |
| | ムの非越流部の直上流部における水位から基礎地盤までの水深（単位 |   |
| | > メートル）                                                   |   |
| | >                                                              |   |
| | > *h*~1~　ダムの非越流部の直上流部における水位からダムの堤体   |   |
| | と貯留水との接触面上の動水圧を求めようとする点までの水深（単位 |   |
| | > メートル）                                                   |   |
| +----------------------------------------------------------------+   |
|                                                                      |
| （注：施行規則の*H*~1~及び*h*~1~は、本節では*H*及び*h*と記載する。） |
|                                                                      |
| ダムの堤体の上流面が鉛直に近い場合、適切な工学試験又                 |
| は類似のダムの構造計算に用いられた方法に基づきその数値を求めることが |
| できない場合には、施行規則第7条のWestergaardの式によることができる。 |
|                                                                      |
| Westergaard                                                          |
| の式において全動水圧*P~d~*（＝$\int_{0}^                             |
| {H}{p_{d}\text{dz}}$）及び全動水圧の作用点の基礎地盤からの高さ*H~d~* |
| は次のように表される（図 2-3-3参照）。                               |
|                                                                      |
| 　　$P_{d} = \int_{0}^{H}p_{d}dz = \frac{7}{12}W_{0}kH^{2}$          |
|                                                                      |
| 　　$H_{d} = 0.4H$                                                   |
|                                                                      |
| ![](media/image150.png){width="1.79375in"                            |
| height="1.2604166666666667in"}                                       |
|                                                                      |
| 103. Westergaard の式                                                |
|                                                                      |
| なお                                                                 |
| 、上流面が緩勾配で、動水圧に特殊な検討を必要とする場合には次のZangar |
| の式を用いることがある。                                             |
|                                                                      |
| 　　$p_{d} = C \bullet W_{0} \bullet k \bullet H$                    |
|                                                                      |
| 　　$C = \frac{C_{m}}{2}\left\{ \frac{h}{H}\left( 2 - \frac{h}{H}    |
| \right) + \sqrt{\frac{h}{H}\left( 2 - \frac{h}{H} \right)} \right\}$ |
|                                                                      |
| *C~m~* ：与えられたダム上流面勾配より定める定数（図 2-3-4参照）      |
|                                                                      |
| ![](media/image151.png){width="3.2715277777777776in"                 |
| height="1.3246784776902887in"}                                       |
|                                                                      |
| 104. Zangar の式の*θ*－*Cm*曲線                                      |
|                                                                      |
| Zangar                                                               |
| の式においては、水深*h*から上の全                                    |
| 動水圧$\int_{0}^{H}{p_{d}\text{dz}}$及び水深*h*の位置から$\int_{0}^  |
| {H}{p_{d}\text{dz}}$の作用点までの高さ*h~d\ ~*は次のように表される。 |
|                                                                      |
| 　　$\int_{0}^{H}{p_{                                                |
| d}\text{dz}} = \alpha \bullet \frac{C_{m}}{2}W_{0}kH^{2}\text{secθ}$ |
|                                                                      |
| 　　$h_{d} = \beta h$                                                |
|                                                                      |
| この式における*α*、*β *は図 2-3-5 により求める。                     |
|                                                                      |
| ![](media/image152.jpg){width="3.3063593613298337in"                 |
| height="2.386                                                        |
| 294838145232in"}![](media/image152.jpg){width="2.0520231846019246in" |
| height="2.0625929571303585in"}                                       |
|                                                                      |
| 105. *h*/*H*と*α* 及び *β *の曲線                                    |
|                                                                      |
| なお、ダムの上流面が鉛直面と傾斜面との組合せから成る場合にはZangar   |
| の式の中の傾斜角度 *θ* は次のように考える。                          |
|                                                                      |
| > \(1\) ダムの上流面の鉛直部分の高さがダムの高さの1/2                |
| > 以上の場合は、上流面の全部を鉛直とみなす。                         |
| >                                                                    |
| > \(2\) ダムの上流面の鉛直部分の高さがダムの高さの1/2                |
| > 未満の場合は、ダムの横断面において上流面が貯水                     |
| 面と交わる点と、上流面が基礎と交わる点とを結んだ直線の勾配を用いる。 |
+----------------------------------------------------------------------+

＜標　準＞

  -------------------------------------------------------------------------------------------------
  地震時における貯留水による動水圧の力は、施行規則7条に定める方法により計算することを基本とする。
  -------------------------------------------------------------------------------------------------

＜関連通知等＞

62. 建設省河川局長通達：河川管理施設等構造令及び同令施行規則の施行について，昭和51年11月23日，建設省河政発第70号．

＜参考となる資料＞

地震時動水圧の計算方法については、下記の資料が参考となる。

63. （財）国土開発技術研究センター編／（社）日本河川協会：改定　解説・河川管理施設等構造令，平成12年1月．

    1.  []{#_Toc82025896 .anchor}温度荷重

＜考え方＞

+----------------------------------------------------------------------+
| アーチ式コンクリート                                                 |
| ダム以外の型式のダムは、適当な収縮継目の設置により温度荷重による応力 |
| は緩和され、堤体安定性の上の問題とならないため無視して差し支えない。 |
|                                                                      |
| アーチ式コンクリートダム堤体の応力計算                               |
| を行う場合は、一般にアーチ作用が確保された後の温度降下のみを考慮する |
| 。一方、基礎岩盤の安定性の検討では、温度荷重によるアーチスラストへの |
| 影響を検討し、基礎岩盤の安定上不利に働く場合には温度荷重を考慮する。 |
|                                                                      |
| アーチ式コンクリートダムの                                           |
| 場合、温度上昇による曲げモーメントならびに半径方向せん断力は、水圧荷 |
| 重等による曲げモーメント及び半径方向せん断力と向きが反対となるため、 |
| 堤体設計上は安全側になる。また、温度上昇によるアーチ推力は、水圧荷重 |
| 等によるアーチ推力と同じ向きになるが、この値は一般に堤体の内部応力の |
| 安全性を脅かすものではない。温度降下による曲げモーメントならびに半径 |
| 方向せん断力は、水圧荷重等による曲げモーメント及び半径方向せん断力と |
| 同じ向きになり、またアーチ推力は引張応力を生じさせる向きに作用する。 |
|                                                                      |
| 堤体内部の温度に                                                     |
| よる応力を求める場合には一般に以下の項目について考慮する必要がある。 |
|                                                                      |
| \(1\) 断面内の平均温度の変化                                         |
|                                                                      |
| \(2\) 上下流方向の温度勾配の変化                                     |
|                                                                      |
| \(3\) 上下流面表面近くに形成される温度勾配の変化                     |
|                                                                      |
| このうち、断面内の平均温度の変化は、ダムのたわみ、アーチ推力、       |
| アーチの曲げモーメント及び片持ばりの曲げモーメントに大きな影響を与え |
| る。また上下流方向の温度勾配の変化は、アーチの曲げモーメントにはかな |
| りの影響を与えるが、ダムのたわみ及びアーチ推力に及ぼす影響は小さい。 |
|                                                                      |
| 設計には(1)、(2)を併せて考慮することを原則とする。                   |
|                                                                      |
| (3)の上下流面表面付近に形                                            |
| 成される温度勾配による応力は局部的な応力であり、通常無視してよい（図 |
| 2-3-6参照）。                                                        |
|                                                                      |
| ![](media/image153.jpg){width="2.982049431321085in"                  |
| height="2.4179101049868765in"}                                       |
|                                                                      |
| 106. ダム断面内温度分布                                              |
+----------------------------------------------------------------------+

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------
  アーチ式コンクリートダムの温度荷重は、収縮継目グラウチングの後に予想される堤体の内部温度の変化に基づき計算することを基本とする。
  ----------------------------------------------------------------------------------------------------------------------------------

＜参考となる資料＞

温度荷重の計算方法については、下記の資料が参考となる。

64. （財）ダム技術センター：多目的ダムの建設　平成17年版　第5巻　設計Ⅱ編，平成17年6月．

第2章 ダムの設計 {#第2章-ダムの設計-3 .目次の見出し1}
================

第4節　コンクリートダムの設計 {#第4節-コンクリートダムの設計 .目次の見出し1}
=============================

目　次 {#目-次-9 .目次の見出し1}
======

[第4節 コンクリートダムの設計 1](#_Toc82102498)

> [4．1 設計の基本 1](#_Toc82102499)
>
> [4．2 堤体材料 2](#_Toc82102500)
>
> [4．2．1 ダムコンクリートの基本 2](#_Toc82102501)
>
> [4．2．2 ダムコンクリートの設計値 2](#_Toc82102502)
>
> [4．2．3 ダムコンクリートの強度 3](#_Toc82102503)
>
> [4．2．4 ダムコンクリートの配合強度 5](#_Toc82102504)
>
> [4．3 重力式コンクリートダムの基本設計 6](#_Toc82102505)
>
> [4．3．1 形状及び安定計算 6](#_Toc82102506)
>
> [4．3．2 応力解析 13](#_Toc82102507)
>
> [4．4 アーチ式コンクリートダムの基本設計 15](#_Toc82102508)
>
> [4．4．1 形状及び安定計算 15](#_Toc82102509)
>
> [4．4．2 応力解析 18](#_Toc82102510)
>
> [4．5 温度規制計画と収縮継目 18](#_Toc82102511)
>
> [4．5．1 温度規制計画の策定 18](#_Toc82102512)
>
> [4．5．2 収縮継目 19](#_Toc82102513)
>
> [4．5．3 せん断キーと継目グラウチング 20](#_Toc82102514)
>
> [4．6 堤体各部の設計 22](#_Toc82102515)
>
> [4．6．1 止水装置 22](#_Toc82102516)
>
> [4．6．2 通 廊（監査廊） 23](#_Toc82102517)
>
> [4．6．3 堤頂構造物 25](#_Toc82102518)
>
> [4．7 計測装置の設置 25](#_Toc82102519)

令和3年10月　版

適用上の位置付け

　河川砂防技術基準設計編は、基準の適用上の位置付けを明確にするために、下表に示すように適用上の位置付けを分類している。

+--------+------------------+------------------+------------------+
| 分　類 | 適用上の位置付け | 末尾の字句例     |                  |
+--------+------------------+------------------+------------------+
| 考え方 | 技術資料         | ●目              | 「･･･ある。      |
|        |                  | 的や概念、考え方 | 」「･･･いる。」  |
|        |                  | を記述した事項。 |                  |
|        |                  |                  | 「･･･なる。      |
|        |                  |                  | 」「･･･れる。」  |
+--------+------------------+------------------+------------------+
| 必　須 | 技術基準         | ●法令による規定  | 「･･･なければ    |
|        |                  | や技術的観点から | ならない。」「･  |
|        |                  | 実施すべきである | ･･ものとする。」 |
|        |                  | ことが明確であり |                  |
|        |                  | 遵守すべき事項。 |                  |
+--------+------------------+------------------+------------------+
| 標　準 | 技術基準         | ●特              | 「･･･            |
|        |                  | 段の事情がない限 | を標準とする。」 |
|        |                  | り記述に従い実施 |                  |
|        |                  | すべきだが、状況 | 「･･･            |
|        |                  | や条件によって一 | を基本とする。」 |
|        |                  | 律に適用すること |                  |
|        |                  | はできない事項。 | 「･･･による。」  |
+--------+------------------+------------------+------------------+
| 推　奨 | 技術資料         | ●状況や条件      | 「               |
|        |                  | によって実施する | ･･･望ましい。」  |
|        |                  | ことが良い事項。 |                  |
|        |                  |                  | 「               |
|        |                  |                  | ･･･推奨する。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･務める。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･必要に応    |
|        |                  |                  | じて･･･する。」  |
+--------+------------------+------------------+------------------+
| 例　示 | 技術資料         | ●適用条件や実施  | 「               |
|        |                  | 効果について確定 | ･･･などの手法（  |
|        |                  | している段階では | 事例）がある。」 |
|        |                  | ないが、状況や条 |                  |
|        |                  | 件によっては導入 | 「･･･など        |
|        |                  | することが可能な | の場合がある。」 |
|        |                  | 新技術等の例示。 |                  |
|        |                  |                  | 「･･･など        |
|        |                  | ●状              | が考えられる。」 |
|        |                  | 況や条件によって |                  |
|        |                  | 限定的に実施でき | 「               |
|        |                  | る技術等の例示。 | ･･･の場合には･･･ |
|        |                  |                  | ことができる。」 |
|        |                  | ●具体的          |                  |
|        |                  | に例示することに | 「               |
|        |                  | より、技術的な理 | ･･･例示する。」  |
|        |                  | 解を助ける事項。 |                  |
|        |                  |                  | 「例えば･･･。」  |
|        |                  |                  |                  |
|        |                  |                  | 「･･･事例もある  |
|        |                  |                  | 。･･･もよい。」  |
+--------+------------------+------------------+------------------+

  関連通知等       関連する通知やそれを理解する上で参考となる資料
  ---------------- ------------------------------------------------------
  参考となる資料   例示等に示した手法・内容を理解する上で参考となる資料

1.  []{#_Toc82102498 .anchor}コンクリートダムの設計

    1.  []{#_Toc82102499 .anchor}設計の基本

＜考え方＞

+----------------------------------------------------------------------+
| コンクリートダムの構造の原則については、構造令第4条第1項及び         |
| 第2項（本章3.1参照）において、コンクリートダムの安定性及び強度につい |
| ては、施行規則第9条（本章3.2参照）において、それぞれ定められている。 |
|                                                                      |
| コンクリートダムの堤体設計にあたっては、予想される荷重の組           |
| 合せに対して十分な安全性が確保されるように、堤体の断面、形状が決定さ |
| れなければならず、設計に際しては、以下の点に注意しなければならない。 |
|                                                                      |
| 1．コンクリートダムはダム本体と基礎が一体となっ                      |
| て挙動するように設計されているので、ダム本体の設計と基礎の物性とは切 |
| り離して考えることはできない。したがって、コンクリートダムの基礎は堤 |
| 体を支持するのに十分な強度と、変形に対する抵抗性を有し、かつ、パイピ |
| ング等によって基礎の弱層部に変化が生じ、これが堤体の支持力に影響を与 |
| えることのないように浸透破壊に対しても十分な抵抗性を有していなければ |
| ならない。このためダム基礎で堤体からの荷重を直接受ける部分あるいは貯 |
| 水の浸透水圧の影響を強く受けると考えられる部分が上記の条件を満足して |
| いない場合にはグラウチングや一部置換えを含む基礎処理方法によって十分 |
| な強度、変形、浸透破壊に対する抵抗性を有するよう対処する必要がある． |
|                                                                      |
| 2．1.に示した設計の前提から、ダムと基                                |
| 礎地盤は十分に付着しているものとする。そのため、施工時には基礎表面は |
| このような状態が確保されるように表面仕上げがなされなければならない。 |
|                                                                      |
| 3．コンクリートダムの設計に際しては、                                |
| ダ                                                                   |
| ムコンクリートは弾性体として取り扱われる。したがって、コンクリートダ |
| ム内に生じる応力は弾性体として近似できる応力範囲になければならない。 |
|                                                                      |
| 4．ダム堤体に設置される収縮継目には横継目と縦継目がある。2           |
| 次元設計の重力式コンクリートダムにあっては縦継目、3                  |
| 次元設計のアーチ式コンクリートダムにあっては横継目も含めて、         |
| 設計条件に合致するように、十分な継目グラウチングを実施して堤体を一体 |
| 化しなければならない。なお、最近の重力式コンクリートダムの一般的な施 |
| 工法であるRCD工法や拡張レア工法を採用したダムでは、堤体の温度応力に  |
| 関する十分な検討に基づいて縦継目を省略することが一般的となっている。 |
|                                                                      |
| 設計の具体方法については、本章 4.3 及び 4.4 に示す。                 |
+----------------------------------------------------------------------+

＜必　須＞

  --------------------------------------------------------------------------------------------------------------------------
  コンクリートダムは、その堤体の構造上の特質及び基礎地盤の特性等を考慮し、所要の安全性が確保されるよう設計するものとする。
  --------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

65. 建設省河川局長通達：河川管理施設等構造令及び同令施行規則の施行について，昭和51年11月23日，建設省河政発第70号．

＜参考となる資料＞

コンクリートダムの構造の原則の考え方としては、下記の資料が参考となる。

66. （財）国土開発技術研究センター編／（社）日本河川協会：改定
    解説・河川管理施設等構造令，平成12年1月．

    1.  []{#_Toc82102500 .anchor}堤体材料

        1.  []{#_Toc82102501 .anchor}ダムコンクリートの基本

＜考え方＞

+----------------------------------------------------------------------+
| コンクリートダムの堤体に                                             |
| 用いるコンクリート（ダムコンクリート）は、耐久性及び水密性が大きく、 |
| 所要の強度及び単位体積重量を持ち、品質のバ                           |
| ラツキが少なく、また、ひび割れの発生の恐れの少ないものであることが必 |
| 要である。また、ダムコンクリートは各部に要求される性能に応じて、それ |
| らを満足するように配合区分（外部、内部等）を設けるのが一般的である。 |
|                                                                      |
| 内部コンク                                                           |
| リートは主に強度と単位体積重量が要求され、外部コンクリートは主に内部 |
| コンクリートに要求される性能に加えて水密性や耐久性などが要求される。 |
|                                                                      |
| ダムコンクリートの耐久性は特に外部コンクリートについて適切な         |
| 空気導入が行われた状態で打設される場合には問題となることは少ないが、 |
| 骨材に懸念のある場合には、必要な耐久性に関する試験を行う必要がある。 |
+----------------------------------------------------------------------+

＜標　準＞

+----------------------------------------------------------------------+
| コンクリートダムの堤体に用いるコン                                   |
| クリート（ダムコンクリート）は、ダムの構造の安全性と貯水機能を確保す |
| るために必要な強度、水密性、耐久性等の品質を有することを基本とする。 |
|                                                                      |
| また、堤体各部の必要                                                 |
| とする品質に応じた配合区分（外部、内部等）を設けることを基本とする。 |
+----------------------------------------------------------------------+

＜参考となる資料＞

ダムコンクリートの堤体材料としては、下記の資料が参考となる。

67. 土木学会：2013制定　コンクリート標準示方書（ダムコンクリート編），平成25年10月．

68. （財）ダム技術センター：多目的ダムの建設　平成17年版　第4巻　設計Ⅰ編　平成17年6月.

    1.  []{#_Toc82102502 .anchor}ダムコンクリートの設計値

＜考え方＞

+----------------------------------------------------------------------+
| ダムコンクリートの設計値（構造設計に用いる物性の入力値）は安全側     |
| の値として確保されるか、または設計上許容する範囲内である必要がある。 |
|                                                                      |
| ダムコンクリートの                                                   |
| 設計値としては、コンクリートの単位体積重量、弾性係数、ポアソン比等が |
| あり、実際に使用する材料及び配合で試験を行い、その結果に基づいて決定 |
| するのが基本である。なお、コンクリートの弾性係数やポアソン比は、有限 |
| 要素法（FEM）解析等により堤体内部の応力状態等を検討する際に用いる。  |
|                                                                      |
| コンクリートの弾性係数は圧縮強度が大きいほど大きくなる。             |
|                                                                      |
| コンクリートのポアソ                                                 |
| ン比は、材料・配合・材齢及び荷重の大きさによって若干異なるが一般的に |
| は0.2が用いられている。また、熱膨張係数は材料及び配合に影響される。  |
|                                                                      |
| ダムコンクリートの温度規制を行う場合のコンクリー                     |
| トの熱拡散率・熱伝導率・比熱等は、安全側の値を用いるのが一般的である |
| が、必要に応じて断熱温度上昇試験等の実験を行い値の妥当性を確認する。 |
+----------------------------------------------------------------------+

＜標　準＞

  --------------------------------------------------------------------------------------------------
  ダムコンクリートの設計値は、実際に使用する材料及び配合によって試験を行い定めることを基本とする。
  --------------------------------------------------------------------------------------------------

＜例　示＞

設計に用いる弾性係数の値は、持続荷重を受ける場合のクリープを考慮して、一般に
19.6kN/mm^2^ないし
29.4kN/mm^2^を採用すること等が考えられる。なお、残留ひずみを除いた材齢91日における応力ひずみ曲線は、通常許容応力の範囲内ではほとんど直線に近く、その付近での弾性係数は
29.4kN/mm^2^ないし39.2kN/mm^2^の値を示すのが普通である。

基本断面設定時等の配合試験を行っていない段階で設計する場合には、次の各設計値を用いること等が考えられる。

単位体積重量＝22.56　kN/m^3^

ポアソン比＝0.2

熱膨張係数＝0.00001/℃

弾性係数＝19.6 kN/mm^2^

＜参考となる資料＞

ダムを設計する際に用いるコンクリートの設計値としては、下記の資料が参考となる。

69. 土木学会：2013制定　コンクリート標準示方書（ダムコンクリート編），平成25年10月．

70. （財）ダム技術センター：多目的ダムの建設　平成17年版　第4巻　設計Ⅰ編　平成17年6月.

    1.  []{#_Toc82102503 .anchor}ダムコンクリートの強度

＜考え方＞

+----------------------------------------------------------------------+
| コ                                                                   |
| ンクリートダムが設計荷重を受けるのは、コンクリートを打ち込んでから長 |
| 時間経った後である。また、ダムコンクリートには水和熱を抑えたセメント |
| や多量の混和材が用いられるため、一般のコンクリートに比べて初期の強度 |
| 発現が小さい特徴がある。これらのことから、コンクリートダムの設計基準 |
| 強度は、材齢91日での圧縮強度をもとに定める。コンクリートの強度は材齢 |
| 91 日の後も強度が漸増し、材齢365 日で材齢 91                         |
| 日の強度の10%程度を増すような材料、または、配合を選ぶ。              |
|                                                                      |
| ダムコンクリートの強                                                 |
| 度については、施行規則第9条（本章3.2参照）において、定められている。 |
|                                                                      |
| 施行                                                                 |
| 規則第9条第3項において「コンクリートダムの堤体に生ずる応力は、標準許 |
| 容応力を超えてはならない」とし、同第4項では「前項の標準許容応力は、  |
| ダム堤体の材料として用いられるコンクリートの圧縮強度の基準とし、安全 |
| 率を4以上として定める」ことを規定している。この基準となる圧縮強度は  |
| 、実務では「設計基準強度」（土木学会コンクリート標準示方書）と呼ぶ。 |
|                                                                      |
| なお、コンクリートの圧縮強度はひずみ速度が標準                       |
| 試験の場合に比べ著しく大きくなると増加すること等を踏まえ、地震時の検 |
| 討における上記の圧縮強度の基準値は、標準試験で得られた強度に基づき安 |
| 全率を考慮して得られる値にその30％以内を加えた値として差し支えない。 |
|                                                                      |
| アーチ式コンクリートダムでは、ダム堤体内に引張応力の発生を認めている |
| こと、ダム堤体内の応力状態が多軸応力状態にあること等を考慮してダム堤 |
| 体内の任意の点に生じる第1主応力（最大圧縮応力）に4以上の安全率（地震 |
| 時以外）を乗じ、さらに第3主応力の大きさを考慮して定めた修正係数（図  |
| 2-4-1参照）で除した値を設計基準強度とする。                          |
|                                                                      |
| ![](media/image154.png){width="5.260416666666667in"                  |
| height="3.2069444444444444in"}                                       |
|                                                                      |
| 107. アーチ式コンクリートダムにおける修正係数                        |
+----------------------------------------------------------------------+

＜必　須＞

+----------------------------------------------------------------------+
| ダムコンクリートの強度                                               |
| は、材齢91日の圧縮強度とし、設計基準強度は予想される荷重により堤体に |
| 生じる応力に対し、4以上の適切な安全率を有するよう定めるものとする。  |
|                                                                      |
| なお、ダムが地震荷重を受けた状態においては、上記の方法で             |
| 求めた値を1.3を越えない値で除した値を設計基準強度とするものとする。  |
+----------------------------------------------------------------------+

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------
  アーチ式コンクリートダムにおけるダムコンクリートの設計基準強度は、組合せ応力の効果を考慮し、適切な補正を行うことを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

1.ダムコンクリートの設計基準強度は、標準養生を行った直径15cm、高さ30cmの材齢91日の供試体を用いたJIS
A1108圧縮強度試験方法で得られる一軸圧縮強度をもとに定めることが望ましい。

2.ダムコンクリートの引張強度は、設計基準強度を定めた配合のダムコンクリートの引張強度を基準としてその許容値を設定することが望ましい。

＜例　示＞

コンクリートダム堤体に生じる圧縮応力*σ~c~*と設計基準強度*f\''~ck~*の関係を地震荷重の有無とダム型式の違いによって例示する（土木学会コンクリート標準示方書）。

重力式コンクリートダムの場合：

> ${f'}_{\text{ck}} \geqq \sigma_{c} \times 4$
> （地震荷重を受けていない状態）
>
> ${f'}_{\text{ck}} \geqq \sigma_{c} \times 4 \div 1.3$
> （地震荷重を受けた状態）

アーチ式コンクリートダムの場合：

> ${f'}_{\text{ck}} \geqq \sigma_{c} \times 4 \div \left\lbrack 修正係数 \right\rbrack$
> （地震荷重を受けていない状態）
>
> ${f'}_{\text{ck}} \geqq \sigma_{c} \times 4 \div \left\lbrack 修正係数 \right\rbrack \div 1.3$
> （地震荷重を受けた状態）

ここに，${f^{'}}_{\text{ck}}$：設計基準強度，$\sigma_{c}$：堤体内に生じる圧縮応力

＜関連通知等＞

71. 建設省河川局長通達：河川管理施設等構造令及び同令施行規則の施行について，昭和51年11月23日，建設省河政発第70号．

＜参考となる資料＞

ダムコンクリートの設計に用いるダムコンクリートの強度については、以下の資料が参考となる。

72. （財）国土開発技術研究センター編／（社）日本河川協会：改定　解説・河川管理施設等構造令，平成12年1月．

```{=html}
<!-- -->
```
64. 土木学会：2013制定　コンクリート標準示方書（ダムコンクリート編），平成25年10月．

    1.  []{#_Toc82102504 .anchor}ダムコンクリートの配合強度

＜考え方＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  ダムコンクリートの配合強度は、設計基準強度に、現場におけるダムコンクリートの品質の変動を考慮した割増しを行って定められる。割増し係数は現場において予想されるコンクリートの圧縮強度の変動係数に応じて定められる。工事の初期においては十分な資料がないことから変動係数を適切に定めるのが困難な場合が多く、この場合は施工設備、既往の実績等を考慮して変動係数を推定し、これに応じた割増し係数を定めることとし、工事の進捗に伴って蓄積される施工実績を検討し、必要に応じて修正を行うこととする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------
  ダムコンクリートの配合強度は、設計基準強度に、現場におけるダムコンクリートの品質の変動を考慮した割増しを行って定めることを基本とする。
  ----------------------------------------------------------------------------------------------------------------------------------------

＜例　示＞

配合強度は設計基準強度に変動係数に応じて定まる割増し係数を乗じて定められるが、そのために必要な割増し係数の求め方について例示する。

図 2-4-2は現場において、
予想されるコンクリートの圧縮強度の変動係数から割増し係数を求めるために一般に用いられる図である。これは現場における圧縮強度の試験値が設計基準強度の
80% を下回る確率が 1/20 以下であること及び設計基準強度を下回る確率が1/4
以下であることの２つの条件から求めたものである。

![](media/image155.png){width="2.8534722222222224in"
height="3.033333333333333in"}

108. 一般の場合の割増し係数

＜参考となる資料＞

ダムコンクリートの配合強度については、下記の資料が参考となる。

73. 土木学会：2013制定　コンクリート標準示方書（ダムコンクリート編），平成25年10月．

    1.  []{#_Toc82102505 .anchor}重力式コンクリートダムの基本設計

        1.  []{#_Toc82102506 .anchor}形状及び安定計算

＜考え方＞

+----------------------------------------------------------------------+
| 重力式コンクリートダムの設計では、適切な配置設                       |
| 計を行った後、堤体の安定計算を行って、その横断面形状を定める。安定計 |
| 算にあたって、堤体は単位幅の片持ばりがそれぞれ隣接する片持ばりと独立 |
| しているものとし、横断面形状を2次元設計によって定めるのが一般的であ  |
| る。この基本的な堤体の横断面の形状を基本三角形断面と呼ぶ。越流部につ |
| いては必要な修正を行って、所要の安定性を有する堤体形状を決定する。　 |
|                                                                      |
| 重力式コンクリートダムの基本形状決定までの一般的な手順は以下となる。 |
|                                                                      |
| > \(1\)                                                              |
| > 堤                                                                 |
| 体の上流面に鉛直方向の引張応力を生じないように基本三角形断面を決定す |
| る。これによって、上・下流面勾配を最も経済的に決定することができる。 |
| >                                                                    |
| > \(2\)                                                              |
| > (1)の条件によ                                                      |
| って定まった基本三角形断面について堤体、着岩面及び基礎地盤内でのせん |
| 断に対して安全率が4以上であることを確認する。ここで必要な安全率4が得 |
| られない場合には、堤体断面からの対応としては、適切な増厚を行って安全 |
| 率4以上を得るようにする。この場合、(1)の条件に対して求めた上・下流面 |
| 勾配をもった基礎三角形が、最も経済的な断面とならないことがある。その |
| 場合は、断面形状の修正を行って、上・下流面勾配を設定することになる。 |
| >                                                                    |
| > \(3\)                                                              |
| > (2)で定まった基本三角形断面において、堤体内の応力が許容応力を超え  |
| ないことの確認を行う。一般に重力式コンクリートダムに生じる圧縮応力は |
| 小さく、特に堤高が高いダムの場合等を除き、問題にならない場合が多い。 |
|                                                                      |
| \(4\)                                                                |
| 想定                                                                 |
| されるせん断面において局所安全率がおよそ2以上であることを確認する。  |
|                                                                      |
| 以下に重力式コンクリートダムの安定性確保のための3条件を記す。        |
|                                                                      |
| 1.堤体の上流面に鉛直方向の引張応力を生じないための条件               |
|                                                                      |
| > 堤体を片持                                                         |
| ばりとして、平面保持の仮定に基づいて縁応力を求めると、荷重の合力の作 |
| 用点が中立軸から断面の6分の1の距離にある場合に、その反対側の縁応力が |
| > 0                                                                  |
| > となる。したがって、堤体の上流面に鉛直                             |
| 方向の引張応力を生じないための条件に対しては荷重の合力が中央3分点内  |
| にあればよく、そのため、この条件は普通ミドルサードの条件とよばれる。 |
| >                                                                    |
| > 貯水池空虚時や最低水位の状態で上流向きの地震力を受けた             |
| 場合の安定、すなわち、下流面に生ずる引張応力についても検討するが、一 |
| 般には上流端の引張応力を厳しく規制する。これは、上流面に引張応力が発 |
| 生すると、打継面が開いたり、基礎岩盤に緩みができやすくなり、その隙間 |
| に貯水が浸透して揚圧力が増大し、設計時の条件を大きく変えることになり |
| 危険になるからである。下流面の引張応力がコンクリートの許容引張応力の |
| 範囲である程度許容されるのは、下流面に引張応力が生じると考えられる場 |
| 合は地震時の短時間に限られており、また下流側の水位条件及びそれに伴う |
| 揚圧力についても上流側に比べて著しく条件が緩やかになるためである。な |
| お、本節で扱う構造計算の方法（施行規則第9条の規定による方法）によっ  |
| て上流面に引張応力が発生しない堤体形状とした場合でも、有限要素法（F  |
| EM）での詳細な解析を行うと引張応力が計算される場合もあるが、ミドルサ |
| ード条件（本章3.2参照）に相当する本条件を満足する断面形状としておく  |
| ことで、実際に引張応力が生じる可能性を大幅に小さくすることができる。 |
| >                                                                    |
| > ミドルサードの                                                     |
| 条件を満足している場合には、平面保持の仮定に従えば、堤体内に引張応力 |
| を生じることはないが、例えば貯水池空虚時に上流向きの地震力を受けたよ |
| うな場合には下流面に引張応力を生じることがあるように、堤体の一部の引 |
| 張応力が生じることがある。このような引張応力は許容引張応力の範囲内で |
| これを許容できる。許容引張応力は、許容圧縮応力（コンクリートの圧縮強 |
| 度を元に安全率を4以上として定めた値）の10%を目安とすることができる。 |
|                                                                      |
| 2.せん断に対して安全であることの条件                                 |
|                                                                      |
| > せん断に対                                                         |
| する安定については、堤体と基礎地盤との接合部、基礎地盤内について次の |
| > Henny                                                              |
| > の式を                                                             |
| 用いて検討し、施行規則第9条に定める4以上の安全率を有するものとする。 |
|                                                                      |
| 　 $\ \ \ \ n = \frac{\tau_{0}ｌ＋\text{fV}}{H}$　                   |
|                                                                      |
| 　　　　*n*：せん断摩擦安全率                                        |
|                                                                      |
| *H*：単位幅当たりのせん断面に作用するせん断力（kN/m）                |
|                                                                      |
| > 　　　　*V*：単位幅当                                              |
| たりのせん断面に作用する全垂直力（揚圧力を差し引いた垂直力）（kN/m） |
|                                                                      |
| 　　　　$\tau_{0}$                                                   |
| ：せん断強度（堤体又は基礎地盤の小さい方の値）（kN/m2）              |
|                                                                      |
| 　　　　*f*：内部摩擦係数（堤体又は基礎地盤の小さい方の値）          |
|                                                                      |
| 　　*l*：せん断面の長さ（m）                                         |
|                                                                      |
| 3.堤体内の圧縮応力が許容圧縮応力を超えないことの条件                 |
|                                                                      |
| > 重力式コンクリートダム内に生じる圧縮応力は、一般に小さく、堤高が   |
| > 100ｍを大きく超えるような場合や、基礎地                            |
| 盤が著しく不均一な場合を除いて、その値が問題となることはまれである。 |
| >                                                                    |
| > 基礎地盤が著しく不均一で堤体や基                                   |
| 礎地盤内の応力が問題となる場合には、さらに、厳密な解析が必要となる。 |
| >                                                                    |
| > 堤体の基本形状（基本三角形）を用いた安定                           |
| 計算において、基礎地盤の条件等から滑動や転倒に対する安定性の確保が難 |
| しい場合、せん断面積の増加や上載荷重の増加を図り必要な安全率を確保す |
| る目的で、堤体上流面にフィレット（増厚部）が付設されることがある（図 |
| > 2-4-3参照）。フィレットのうち、荷重                                |
| の伝達、応力集中、施工性等を考慮して、特に上流面に緩い勾配で張り出す |
| 三角形躯体であるフィレットは、通常その勾配は1：1程度以下とする。なお |
| 、フィレットの設計においては、堤体から基礎地盤への荷重伝達への悪影響 |
| 、取付け部周辺での応力集中等の可能性に留意して、フィレットの形状はあ |
| まり上面が緩勾配の厚みのないものとならないように注意する必要がある。 |
| >                                                                    |
| > 一方、地形及び地質条件によっては、増厚が難しい場合もあるので       |
| 、その場合、フィレット同様の可能性に留意して、コンクリートマット等の |
| 特殊な基礎形状とすることによって堤体安定性を確保する方法を検討する。 |
| >                                                                    |
| > ![](media/image156.png){width="1.8488188976377953in"               |
| > height="1.4318897637795276in"}                                     |
|                                                                      |
| 109. フィレットの設置                                                |
|                                                                      |
| 重力式コンクリートダムのせん断に対                                   |
| する安定性は、施行規則第9条（本章3.2参照）において、定められている。 |
|                                                                      |
| a.堤体上流端に鉛直方向の引張応力を生じないような基本三角形断面の計算 |
|                                                                      |
| 重力式コンクリートダムの最も経済的な断面を                           |
| 、貯水位と基本三角形の頂点が一致する条件で検討した結果を以下に記す。 |
|                                                                      |
| なお、形状、外力についてはそれぞれ表 2-4-1及び図                     |
| 2-4-4のとおりである。                                                |
|                                                                      |
| 70. 外力及び外力によるモーメント                                     |
|                                                                      |
| ![](media/image157.png){width="6.0013363954505685in"                 |
| height="5.604003718285214in"}                                        |
|                                                                      |
| ![](media/image158.png){width="5.924528652668417in"                  |
| height="3.2075470253718286in"}                                       |
|                                                                      |
| 110. 外 力                                                           |
|                                                                      |
| いま、図 2-4-5 のように合力の作用点と上流端の距離*X~０~*             |
| を定めると、                                                         |
|                                                                      |
| 　　$X_{0} \leqq \frac{2}{3}\left( m + n \right)h$                   |
|                                                                      |
| 　　$X_{0} = \frac{水平，鉛直によるモーメントの総和}{\text{ΣV}}$     |
|                                                                      |
| と表すことができる。上式に表による外力及びモーメン                   |
| トを代入して、両辺に6/*h^3^*を乗じて（*m*+*n*）について整理すると、  |
|                                                                      |
| (*m*＋*n*)^2^(*                                                      |
| W~c~*－*W~w~U~p~*)－(*m*＋*n*)〔｛*W~c~*－2*W~w~*－2*W~s~*(*h~s~*/*h |
| *)^2^｝*m*＋*W~C~k*〕－\[*W~s~*(*h*~s~/h)^3^*+W~w~*}*m*^2^＋*W~w~*＋ |
|                                                                      |
| *W~s~C~e~*(*h~s~*/*h*)^3^＋（7/5）*W~w~k*≧0                          |
|                                                                      |
| となり、この式を満足する*m*及び*n*を求める。                         |
|                                                                      |
| ここで、*A*(*m*＋*n*)^2^－*B*(*m*＋*n*)－*C≧0*とおくと、             |
|                                                                      