> 国土交通省 河川砂防技術基準 維持管理編

（河 川 編）

目　次

第1章　総説 1

第1節　目的 1

1．1　本基準の目的 1

1．2　河川維持管理の技術的基準を定める際の基本的な考え方 1

1．3　本基準の位置付け 2

第2節　河川維持管理の基本方針 3

第3節　適用範囲 7

第2章　河川維持管理に関する計画 9

第1節　河川維持管理計画 9

1．1　一般 9

1．2　計画に定める事項 9

第2節　サイクル型維持管理 12

2．1　サイクル型維持管理体系の構築 12

2．2　河道計画等との関係 14

第3章　河川維持管理目標 15

第1節　一般 15

第2節　河道流下能力の維持に係る目標設定 16

第3節　施設の機能維持に係る目標設定 17

3．1　基本 17

3．2　河道（河床低下・洗掘の対策）に係る目標 17

3．3　堤防に係る目標 18

3．4　護岸、根固工、水制工に係る目標 19

3．5　床止め（落差工、帯工含む。）に係る目標 20

3．6　堰、水門、樋門、排水機場等に係る目標 21

3．7　水文・水理観測施設に係る目標 22

第4節　河川区域等の適正な利用に係る目標 22

第5節　河川環境の整備と保全に係る目標 23

第4章　河川の状態把握 25

第1節　一般 25

第2節　基本データの収集 27

2．1　水文・水理等観測 28

2．2　測量 28

2．2．1　縦横断測量 28

2．2．2　地形測量 30

2．3　河道の基本データ 31

2．4　河川環境の基本データ 32

2．5　観測施設、機器の点検 33

第3節　堤防点検等のための環境整備 34

第4節　河川巡視 35

4．1　一般 35

4．2　平常時の河川巡視 36

4．3　出水時の河川巡視 37

第5節　点検 38

5．1　出水期前、台風期、出水後等の点検 38

5．1．1　出水期前、台風期の点検 38

5．1．2　出水後等の点検 41

5．2　地震後の点検 43

5．3　親水施設等の点検 44

5．4　機械設備を伴う河川管理施設の点検 45

5．5　許可工作物の点検 48

第6節　河川カルテ 49

第7節　河川の状態把握の分析、評価 50

第5章　河道流下能力の維持管理のための対策 51

第1節　河道流下能力の維持・河床低下対策 51

第2節　河岸の対策 53

第3節　樹木の対策 54

第4節　河口部の対策 55

第6章　施設の維持及び修繕・対策 57

第1節　河川管理施設一般 57

1．1　土木施設 57

1．2　機械設備・電気通信施設 57

第2節　堤防 60

2．1　土堤 60

2．1．1　堤体 60

2．1．2　除草 62

2．1．3　天端 65

2．1．4　坂路・階段工 66

2．1．5　堤脚保護工 67

2．1．6　堤脚水路 67

2．1．7　側帯 68

2．2　特殊堤 69

2．2．1　胸壁構造の特殊堤 69

2．2．2　自立式構造の特殊堤 69

2．3　霞堤 70

2．4　越流堤、導流堤、背割堤、二線堤 70

第3節　護岸 72

3．1　護岸一般（コンクリート擁壁、矢板護岸以外） 72

3．2　コンクリート擁壁 75

3．3　矢板護岸 76

第4節　根固工 76

第5節　水制工 77

第6節　樋門・水門 78

6．1　本体 79

6．2　ゲート設備 82

6．3　電気通信施設、付属施設 82

第7節　床止め・堰 82

7．1　本体及び水叩き 82

7．2　護床工 83

7．3　護岸、取付擁壁及び高水敷保護工 84

7．4　魚道 84

7．5　ゲート設備 85

7．6　電気通信施設 86

7．7　付属施設 87

第8節　排水機場 87

8．1　土木施設 87

8．2　ポンプ設備 89

8．3　電気通信施設 90

8．4　機場上屋 90

第9節　陸閘 91

第10節　河川管理施設の操作 92

第11節　許可工作物 93

11．1　基本 93

11．2　伏せ越し 93

11．3　取水施設 94

11．4　橋梁 95

11．4．1　橋台 95

11．4．2　橋脚 95

11．4．3　取付道路 96

11．5　堤外・堤内水路 96

第7章　河川区域等の維持管理対策 97

第1節　一般 97

第2節　不法行為への対策 100

2．1　基本 100

2．2　ゴミ、土砂、車両等の不法投棄 101

2．3　不法占用（不法係留船を除く。）への対策 102

2．4　不法係留船（放置艇）への対策 102

2．5　不法な砂利採取等への対策 105

第3節　河川の適正な利用 106

3．1　基本 106

3．2　河川の安全な利用 107

3．3　水面利用 108

第8章　河川環境の維持管理対策 109

第9章　水防等のための対策 114

第1節　水防のための対策 114

1．1　水防活動等への対応 114

1．2　水位情報等の提供 115

第2節　水質事故対策 117

令和3年10月　版

適用上の位置付け

＜考え方＞

河川砂防技術基準維持管理編は、基準の適用上の位置付けを明確にするために、下表に示すように適用上の位置付けを＜考え方＞、＜必　須＞、＜標　準＞、＜推　奨＞、＜例　示＞に分類している。

表　基準内容の分類と適用上の位置付け

+--------+----------------------------------------------------------------------------------------------------------------+--------------------------------+
| 分類   | 適用上の位置付け                                                                                               | 末尾の字句例                   |
+:======:+:===============================================================================================================+================================+
| 考え方 | 目的や概念、考え方を記述した事項。                                                                             | ...ある。                      |
|        |                                                                                                                |                                |
|        |                                                                                                                | ...いる。                      |
|        |                                                                                                                |                                |
|        |                                                                                                                | ...なる。                      |
|        |                                                                                                                |                                |
|        |                                                                                                                | ...れる。                      |
+--------+----------------------------------------------------------------------------------------------------------------+--------------------------------+
| 必須   | 法令による規定や技術的観点から実施すべきであることが明確であり遵守すべき事項。                                 | ...なければならない。          |
|        |                                                                                                                |                                |
|        |                                                                                                                | ...ものとする。                |
+--------+----------------------------------------------------------------------------------------------------------------+--------------------------------+
| 標準   | 状況や条件によって一律に規制することはできないが、特段の事情がない限り記述に従い実施すべき事項。               | ...を標準とする。              |
|        |                                                                                                                |                                |
|        |                                                                                                                | ...を基本とする。              |
|        |                                                                                                                |                                |
|        |                                                                                                                | ...による。                    |
+--------+----------------------------------------------------------------------------------------------------------------+--------------------------------+
| 推奨   | 状況や条件によって実施することが良い事項。                                                                     | ...望ましい。                  |
|        |                                                                                                                |                                |
|        |                                                                                                                | ...推奨する。                  |
|        |                                                                                                                |                                |
|        |                                                                                                                | ...努める。                    |
|        |                                                                                                                |                                |
|        |                                                                                                                | ...必要に応じて...する。       |
+--------+----------------------------------------------------------------------------------------------------------------+--------------------------------+
| 例示   | 適用範囲や実施効果について確定している段階ではないが、状況や条件によっては導入することが可能な新技術等の例示。 | ...などの手法（事例）がある。  |
|        |                                                                                                                |                                |
|        | 状況や条件によって限定的に実施できる技術等の例示。                                                             | ...などの場合がある。          |
|        |                                                                                                                |                                |
|        | 具体的に例示することにより、技術的な理解を助ける事項。                                                         | ...などが考えられる。          |
|        |                                                                                                                |                                |
|        |                                                                                                                | ...の場合には･･･ことができる。 |
|        |                                                                                                                |                                |
|        |                                                                                                                | ...例示する。                  |
|        |                                                                                                                |                                |
|        |                                                                                                                | 例えば...。                    |
|        |                                                                                                                |                                |
|        |                                                                                                                | ...事例もある。                |
|        |                                                                                                                |                                |
|        |                                                                                                                | ...もよい。                    |
+--------+----------------------------------------------------------------------------------------------------------------+--------------------------------+

本基準に関連する細目、運用等に関する通知等を関連通知等として各節の末尾に示した。

**第1章 総説**

**第1節 目的**

**1．1 本基準の目的**

＜考え方＞

近年、毎年のように激甚な水災害が発生し、既に気候変動の影響の顕在化が指摘されている。今後、気候変動によって更なる豪雨の頻発化・激甚化や潮位の上昇等により、ますます水災害リスクの増加が懸念されることから、適切に河川の維持管理を行う必要がある。また、生物の多様な生息・生育・繁殖環境としての河川環境の保全・整備、地域の活力創出やうるおいある生活のための公共空間としての利用に対する要請も高まっており、このような観点からも適切な維持管理を行う必要がある。一方、高度経済成長期に多くの河川管理施設の整備が進められたが、それらが今後更新時期を迎えることとなり、より効率的な施設の維持と修繕・更新が求められている。

また、河川管理施設及び河川法第26条第1項の許可を受けて設置される工作物（以下「許可工作物」という。）の維持管理に関して、平成25年に河川法（昭和39年法律第167号、以下「法」という。）の一部が改正され、同法第15条の2において、河川管理者又は許可工作物の施設管理者は、河川管理施設又は許可工作物（以下「河川管理施設等」という。）を良好な状態に保つように維持し、修繕し、もって公共の安全が保持されるように努めなければならないことが定められた。

河川砂防技術基準維持管理編（河川編）（以下「本基準」という。）は、上記の背景のもと、河川維持管理に必要とされる主な事項を定め、もって適正な河川管理に資することを目的とする。

**1.2 河川維持管理の技術的基準を定める際の基本的な考え方**

＜考え方＞

平成18年7月の「安全・安心が持続可能な河川管理のあり方について」の提言^1)^では、河川維持管理の技術的な特徴を次のように記している。

『河川は、水源から山間部、農村部さらには都市部等を流下し海に至る間で、それぞれ異なる地域特性を有している。また、土砂の流出や植生の変化等により長期的に変化していくが、その変化は必ずしも一様なものではなく、洪水、渇水等の流況の変化等によって、時には急激に、状態が変化するという特性を有する自然公物である。

主たる管理対象施設である堤防は、延長が極めて長い線的構造物であり、一箇所で決壊した場合であっても、一連区間全体の治水機能を喪失してしまうという性格を有している。また、原則として土で作られ、過去幾度にもわたって築造・補修され現在に至っているという歴史的経緯を有し、その時々で現地において近傍の土を使用して築造できるという利点がある一方、構成する材料の品質が不均一であるという性格も有している。

これらのことから、河川維持管理を確実に行うには、このような河川の状態を見（診）て、状態の変化を分析する、きめ細かな維持管理を実施することが必要となっている。』

これを踏まえると、河川維持管理の技術的基準を定める際の基本的な考え方は主に次のとおりである。

○
自然公物である河川は自然の作用によって変化する。特に、河川は出水により大きく変化し、堤防にも変状が生じる。また、公共用物である河川は、公衆の自由使用に供されていることから、日常の人為的な作用も変化の要因になることがある。

○
また、主な河川管理施設である堤防は歴史的な築造の経緯を有するとともに、複雑な地質構造を有する氾濫原に築造されており、いわば一つとして同じ土質構造を有しないため、河川管理施設等構造令においても形状による規定にとどまっているように、実物による長年の出水時の経験等に基づいて安全性を確認してきた構造物である。

○
自然公物でありかつ出水等によって変状を生じる河道、さらに主たる河川管理施設であり歴史的な築造の経緯を有する堤防等を対象とする河川維持管理（平常時及び出水時の対応）は、河川工事と相まって、治水上の安全性を確保するよう現地での変状等に対応し、長年にわたって経験を積み重ねながら実施されてきた。

○
したがって、現状の河川維持管理の実施内容あるいはその水準は、河川巡視、点検による状態把握、維持補修等を繰り返してきた中で培われてきたといえる。

○
治水上の安全性を確保しつつ、経験的に行われてきた河川維持管理の実施内容あるいは水準等を変更する場合には、工学的な根拠等に基づく必要があるとともに、今後の維持管理の水準を高めるため、技術的な知見の蓄積を図る必要がある。

**1.3 本基準の位置付け**

＜考え方＞

河川維持管理の目的は、洪水等に対する安全性の確保、安定した水利用の確保、河川環境の保全、適正な河川の利用の促進等多岐にわたるが、本基準では河川維持管理の技術的基準を定める際の基本的な考え方に基づいて河川維持管理に必要とされる主な事項をとりまとめた。

本基準は、これまで各河川で行われてきた河川維持管理の実態を踏まえながら、河川維持管理に関する計画、河川維持管理目標、河川の状態把握、維持管理対策、及び水防等のための対策について定めている。施設の操作については維持管理対策に位置づけている。

なお、河川に設置されている種々の構造物は設置後長期間を経過してきており、老朽化は大きな課題となってきている。河川維持管理においてはそれらの課題に対応して、本基準等に基づく適切な維持管理を実施するとともに、効率化・高度化のための技術開発やコスト縮減等にも取り組んでいくことが必要とされている。

本基準に記されていない事項については、法及び本基準にある主旨を参考とし、適正に河川維持管理を実施する必要がある。河川管理者は、河川管理の目的の下で地域の実情や河川の規模等に応じ本基準を適切に運用するとともに、新たな技術の採用や創意工夫により効果的な河川維持管理を行うことも可能である。また、河川の状態変化を把握し、その分析・評価を繰り返すことにより工学的な知見を積み重ね、経験を中心とした技術から工学的な技術体系への転換を図りながら、本基準の改定に努めていくことが重要である。

**第2節 河川維持管理の基本方針**

(1)河川維持管理の基本方針

＜考え方＞

河川維持管理は、河道の流下能力の維持、堤防等の施設の機能維持、河川区域等の適正な利用、河川環境の整備と保全等に関して設定する河川維持管理目標が達せられるよう、河川管理施設等の構造等を勘案して適切な時期に巡視、草刈り、障害物の処分その他の河川管理施設等の機能を維持するために必要な措置を講ずるとともに、適切な時期に点検を実施し、損傷、腐食その他の劣化その他の異状を把握した場合に必要な措置を講じるなど、適切かつ総合的に行う必要がある。

なお、状態把握の結果の分析や評価には確立された手法等がない場合が多いため、学識者等の助言を得られるように体制の整備等を行うことが必要である。

また、河道及び河川管理施設の維持管理は、長年にわたり経験を積み重ねながら実施されているため、管理経験者を活用して技術を継承しつつ、適切に点検等の状態把握や分析・評価、維持管理対策等を実施していくことが必要である。

(2)維持管理に関する情報の記録

＜考え方＞

河川管理施設等に関する状態把握や分析・評価、修繕・更新等の維持管理を着実に実施するためには、まず施設の基本情報である河川台帳等の調製、更新を確実に行い、合わせて点検結果、健全性の評価結果など、施設の維持管理に関する諸情報を正確に把握し記録するとともに、重要な情報を集約しデータベース化を進める必要がある。

(3)戦略的な維持管理

＜考え方＞

各河川における管理水準を持続的に確保し、中長期的な維持管理に係るトータルコストの縮減や平準化を図るためには、河道及び河川管理施設がその本来の機能を発揮されるよう計画的に維持管理を行うとともに、状態監視保全への移行や長寿命化対策などを踏まえた戦略的な維持管理を行うことが必要である。

また、高度経済成長期以降に整備された多くの河川管理施設等の老朽化が懸念されており、対策の遅れにより既に施設に損傷が見られるなど、緊急的に対応が必要な施設が多数存在している。更に、今後の気候変動の影響により、災害が激甚化・頻発化する中においても、災害時に機能や性能を適切に発揮し、社会経済活動や国民の安心・安全を確保するためには、予防保全型のメンテナンスサイクルの確立による計画的な維持管理・更新が必要となる。

1.  中長期的視点に立った維持管理計画

> 維持管理は長期的視点に立って計画的に取り組むことが重要であり、そのためには、点検・診断結果やこれらの評価結果を踏まえ、施設の長寿命化計画等^1)^の維持管理に係る中長期的な計画の策定や見直しを推進し、当該計画に基づき対策を実施していく必要がある。

②メンテナンスサイクルの構築

> 河川管理施設は、利用状況、設置位置周辺の自然環境等に応じ、劣化や損傷の進行は施設毎に異なり、その状態は時々刻々と変化する。現状では、これらの変化を正確に捉え、河川管理施設の寿命を精緻に評価することは技術的に困難であるという認識に立ち、河川管理施設を構成する各部位の特性を考慮した上で、定期的な点検・診断・評価により施設の状態を正確に把握することが必要である。
>
> このため、点検・診断・評価の結果に基づき、適切な時期に、着実かつ効率的・効果的に必要な対策を実施するとともに、これらの取組を通じて得られた施設の状態や対策履歴等の情報を記録し、次期点検・診断等に活用するというメンテナンスサイクルを構築し、このメンテナンスサイクルを継続的に発展させていく必要がある（第2章第2節参照）。

③状態監視保全、事後保全への移行

> 堰や水門・樋門、排水機場など、機械設備や電気通信施設を有する河川管理施設の維持管理は、故障した場合に施設機能に致命的な影響を与える部材や部品などを経過年数に伴い定期的に交換・更新を行う「時間計画保全」等の考え方に基づいて、計画的に実施されてきた。
>
> 今後、トータルコストの縮減や平準化を図るためには、土木施設を含め河川管理施設の長寿命化を図り、大規模な修繕や更新を軽減することが必要である。このため、設備の設置目的、装置、機器等の特性、設置条件、稼働形態、機能の適合性等を考慮して内容の最適化に努め、かつ効果的に予防保全（設備、装置、機器、部品が必要な機能を発揮できる状態に維持するための保全）と事後保全（故障した設備、装置、機器、部品の機能を復旧するための保全）を使い分け、戦略的に実施することが重要である。
>
> また、河川整備や施設更新時に、維持管理の効率化が可能となる構造形式や新たな技術を用いるなど、あらゆる手段を用いて戦略的に取り組む必要がある。^3)^

④長寿命化対策の推進

> 河川管理施設については、将来にわたって適切に維持管理・修繕・更新していくことを目的とした長寿命化計画を策定するなど、長寿命化対策を進めトータルコストの縮減に取り組んでいく必要がある。特に、確実に経年劣化を生じる機械設備や電気通信施設を有する河川管理施設については、新たな技術を開発・導入して状態監視の信頼性を高めていくとともに、施設そのものに耐久性のある構造・部材・部品を適用していく必要がある。

＜関連通知等＞

1\)
河川構造物の長寿命化計画の策定について：平成24年6月6日,国技電第12号,国総公第34号,国水環保第3号,国水流第3号,大臣官房技術調査課電気通信室長,総合政策局公共事業企画調査課施工安全企画室長,水管理・国土保全局河川環境課河川保全企画室長・流水管理室長.

2)河川構造物の長寿命化計画策定の手引きの改定について：平成30年3月30日,
大臣官房技術調査課電気通信室長,総合政策局公共事業企画調整課施工安全企画室長,水管理・国土保全局河川環境課河川保全企画室長・流水管理室長.

3)「気候変動を踏まえた水災害対策のあり方について」答申：令和2年7月,社会資本整備審議会.

(4)許可工作物の施設管理者等への指導・監督

＜考え方＞

許可工作物については、施設管理者が点検し、必要な対策を行うことが原則であり、河川管理者はその設置にあたり、適切な維持管理が行われるよう許可申請時に審査するとともに、設置後の指導・監督等を適切に行う必要がある。

また、河川は公共用物であることから、スポーツ・レクリエーション活動、舟運、街づくり等の多様な要請に応えることができるよう、これら相互の調整を図りつつ、適正に維持管理していく必要がある。一方、河川敷地の不法占用や不法投棄が後を絶たない状況にあるが、これらは洪水の安全な流下や他の河川利用、河川環境に支障を及ぼす行為であり、発見した場合には、行為者に原状回復や撤去の指示を行う等により厳正に対処することも必要である。

(5)河川環境の維持

＜考え方＞

河川は、豊かな自然環境を残し、うるおいある生活環境の舞台としての役割が期待される。

このため、河川維持管理にあたっても多自然川づくりを基本とし、生物の良好な生息・生育・繁殖環境の保全、良好な景観の維持・形成、人と河川との豊かなふれあい活動の場の維持・形成、良好な水質の保全といったニーズに応えるべく、河川整備計画における河川環境の整備と保全の内容を基にして、河川水辺の国勢調査等の環境調査^2)^結果を踏まえつつ、地域と一体となって河川を維持管理していくことが必要である。

また、流水の正常な機能が維持されるよう、河川の状態把握等を行うことも必要である。

＜関連通知等＞

1\) 河川砂防技術基準調査編,第11章
河川環境調査：平成26年4月1日,国水情報第52号,水管理・国土保全局長.\
（最新版）河川砂防技術基準調査編, 令和7年○月,
国土交通省水管理・国土保全局.

(6)水防のための対策

＜考え方＞

河川管理者は出水時の対応のため、緊急復旧（応急対策を含む）に必要な資材を計画的に備蓄するとともに、市町村等が洪水時等に適確な水防活動ができるよう重要水防箇所を定め、周知する必要がある。

洪水予報河川、水位周知河川においては、出水時における水防活動、あるいは市町村及び地域住民における避難活動に資するよう洪水予報等の情報提供を行う必要がある。

\(7\) 水質事故対策

＜考え方＞

突発的に発生する水質事故に対応するため、関係機関と河川管理者で構成する連絡協議会等を設置し、事故対応の訓練や事故発生時の連絡系統の整備を行い、緊急事態が発生した場合に即応できるようにする必要がある。

(8)地域連携等

＜考え方＞

人々の生活や地域との密接な関係の下で、その川の特徴とその地域の風土が形成されてきた。そこで、河川と地域との歴史に学びつつ、その地域の自然風土、生活環境、産業経済、社会文化等の特性を踏まえ、地域社会と一体となって河川を維持管理することが必要である。そのためには、市区町村、河川協力団体、NPO、市民団体等との連携等を積極的に図る必要がある。

**第3節 適用範囲**

＜考え方＞

(1)適用範囲

本基準は、法第6条第1項に規定する河川区域（以下「河川区域」という。）、法第54条第1項に規定する河川保全区域（以下「河川保全区域」という。）及び法第56条第1項に規定する河川予定地（以下「河川予定地」という。）並びに河川管理施設及び兼用工作物（ダム及び砂防設備を除く。）の維持管理について適用するものである。また、許可工作物の維持管理について、設置にあたっての審査、許可後の指導・監督等において本基準の該当部分を適用するものである。なお、不法行為への対応を除いて、河川敷地及び流水の占用等に関する許可については本基準では対象としていない。具体の項目に関して本基準にないものについては、法及び本基準にある主旨に鑑みて適切に維持管理するものである。

(2)河川区域

河川区域には、高規格堤防特別区域（法第6条第2項）や樹林帯区域（法第6条第3項）のように、通常の河道や堤防の土地とは別に河川区域に係る規制を緩和する区域がある。高規格堤防は、堤体上で土地が通常の利用に供されても超過洪水の作用に対して耐えることができる規格構造を有する堤防であり、樹林帯は、堤防又はダム貯水池の治水上又は利水上の機能を維持し、又は増進する効用を有するものである。これらの区域の管理にあたっては、それぞれの河川管理施設が持つ治水上又は利水上の機能等に支障が生じないよう適切に維持管理する必要がある。

(3)兼用工作物、許可工作物

兼用工作物については、それぞれの施設管理者が協議して維持管理の方法を定めるものであるが、工作物自体は許可工作物であると同時に河川管理施設でもあることから、維持管理は河川管理施設として適切に行われる必要がある。兼用工作物には、「堤防と道路との兼用工作物」、「護岸と橋台との兼用工作物」、「水門の管理橋と道路橋との兼用工作物」、「床止めと取水堰との兼用工作物」等があるが、具体的な維持管理にあたっては、本基準の各施設の項目を参照するものである。

許可工作物については、河川管理施設と同等の水準において維持管理がなされるよう、本基準を準用して必要な指導・監督等を行う必要がある。

(4)維持管理に密接した水防等のための対策等

河川管理者は水防計画に基づき水防管理団体が行う水防に協力するものであり（法第22条の2）、水防計画へ河川管理者の協力が必要な事項が定められた場合の協議や協力時に本基準を参考とする。河川管理施設の維持管理に密接に関係する水防活動、出水時の水防や防災活動に必要とされる水位情報の提供、水質に異常を生じた場合の水質事故対策については維持管理に密接した対策であり、本基準の対象としている。

(5)大河川、中小河川

本基準は法河川の河川維持管理に適用するものであるが、河川の規模等によって河川維持管理の実施内容は異なる。しかし、過去の経験を基に確立されてきた河川維持管理においてはその差異を河川の規模や重要度等の客観的な指標により明確に区分することは現状では困難であり、本基準にあっては以下のような表記によりその区分を示すこととした。

○大河川：直轄河川（国管理河川）

○中小河川：大河川以外の河川

中小河川においては、背後地や施設の状況等が様々であることから、本基準を基本としつつ、各河川の状況に応じて適切に維持管理を実施することとする。なお、河川や施設の規模、背後地の状況等による客観的な区分については、今後、現地での実績や知見の集積等を踏まえながら、基準化していくことを検討していく。

(6)維持管理に関わるその他施設等

維持管理に関するその他施設等について本基準の趣旨にそって適切に維持管理する必要があるとともに、それぞれの施設に該当する法令、要領等に則り適切に維持管理を行うものである。

**第2章 河川維持管理に関する計画**

**第1節 河川維持管理計画**

**1．1 一般**

＜考え方＞

河川維持管理は、出水等の履歴や他河川での経験等を踏まえつつ、計画的に実施していくものである。河川維持管理に関する計画には河川整備計画及び河川維持管理計画があり、河川整備計画における河川維持管理の内容は、河川の維持を含めた河川整備の全体像が明らかとなるように定め、河川維持管理計画には、河川整備計画における河川維持管理の内容を具体化するものとして、本基準に基づいて、概ね5年間に実施する具体的な河川維持管理の内容について定めるものである。

＜標　準＞

大河川においては、河川維持管理の具体的な内容を定める河川維持管理計画を作成することを基本とする。

大河川の河川維持管理計画には、維持管理の目標、河川の状態把握の頻度や時期等を具体的に定める。河川維持管理計画の対象期間は概ね5年間を基本とする。

河川維持管理計画を作成した場合には、河道及び河川管理施設等の状況の変化、河川維持管理の実績、社会経済情勢の変化等に応じて適宜見直しを行うことを基本とする。

＜推　奨＞

+--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 河川維持管理は、河道及び河川管理施設等の状態把握を行いその結果に応じて対策を実施することが基本であるが、状態把握結果の分析や評価には確立された手法等がない場合が多く、河川維持管理計画の作成、あるいは見直しにあたっては、必要に応じて学識者等の助言を得られるように体制の整備等に努める。 |
|                                                                                                                                                                                                                                                                                            |
| 中小河川においても、大河川に準じて河川維持管理計画を作成し、計画的に維持管理を実施していくことが望ましく、作成後必要に応じて適宜見直しを行っていく。                                                                                                                                       |
+============================================================================================================================================================================================================================================================================================+

**1．2 計画に定める事項**

＜考え方＞

河川維持管理の目標や実施内容を定めるにあたって、その頻度や密度は河川の区間毎の特性に応じたものとする必要がある。

河川の状態把握は、設定された目標を達成するため、河川巡視、点検等により、治水・利水・環境の機能に支障を及ぼすおそれのある状態や、河川管理上の不法行為等の把握のために行われるものである。

河川をどのように状態把握するかは河川維持管理目標の達成そのものに影響し、河川巡視、点検等をどのような頻度や密度で行うかによって状態把握の水準が決まることから、河川の状態把握の手法及び頻度が重要である。

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  河川維持管理計画は、河川の概要、河川維持管理上留意すべき事項、河川の区間区分、河川や地域の特性に応じた河川維持管理の目標、河川の状態把握の手法及び頻度、具体的な維持管理対策、地域連携等、効率化・改善に向けた取り組み等を定めることを基本とする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

(1)河川の概要

＜標　準＞

+------------------------------------------------------------------------------------+
| 河川の特性を踏まえ、河川の概要として、以下の事項について記述することを基本とする。 |
|                                                                                    |
| ①河川の流域面積、幹川流路延長、管理延長、河床勾配等の諸元                          |
|                                                                                    |
| ②流域の自然的、社会的特性                                                          |
|                                                                                    |
| ③河道特性、被災履歴、地形、地質、樹木等の状況                                      |
|                                                                                    |
| ④土砂の生産域から河口部までの土砂移動特性等の状況                                  |
|                                                                                    |
| ⑤生物や水量・水質、景観、河川空間の利用等管理上留意すべき河川環境の状況            |
|                                                                                    |
| ⑥その他必要な事項                                                                  |
+====================================================================================+

(2)河川維持管理上留意すべき事項

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------
  当該河川の河道維持、施設管理等の河川維持管理上の観点から留意すべき河道特性、地域特性、河川管理施設等の老朽化の状況等について記述することを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------

  --------------------------------------------------------------------------------------------------------------------------------------------------------

(3)河川の区間区分

＜標　準＞

+-----------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 河川の区間区分は、適切に維持管理を実施するために設定するものであり、氾濫形態、河川の背後地の人口、資産の状況や河道特性等に応じて適切に設定することを基本とする。      |
|                                                                                                                                                                       |
| 大河川では、「沖積河川であり、氾濫域に多くの人口、資産を有し、堤防によって背後地を守るべき区間」を重要区間とし、その他を通常区間とした2つに区分することを基本とする。 |
+=======================================================================================================================================================================+

＜推　奨＞

必要に応じ、個々の河川の特性に応じ、更に細かく区分を設定する。

中小河川においては、基本的に河川単位で「維持管理上特に重要な区間（洪水予報河川、水位周知河川、水防警報河川等）：以下ａ区間という。」「維持管理上重要な区間（ａ区間以外で河川整備計画において改修の対象となっている河川等、氾濫による人家への影響が生じる河川の区間）：以下ｂ区間という。」「ａ，ｂ区間以外の区間（氾濫による人家への影響がほとんどない河川の区間）」の3つに分けることが望ましい。また、必要に応じて堤防や背後地の状況等の個々の河川特性により、区間内を区分する等さらに細かい区分を検討することが望ましい。

(4)河川維持管理目標

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  河川の区間区分に応じ、河川の現状や河川整備計画等の当面の目標等を踏まえて、河川維持管理の目標を設定することを基本とする。なお、目標は、可能な場合には定量的、それ以外の場合には定性的に記述することを基本とする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

(5)河川の状態把握

＜標　準＞

+----------------------------------------------------------------------------------------------------+
| 河川の状態把握の手法、頻度等は、区間区分、維持管理目標等に応じて具体的に設定することを基本とする。 |
|                                                                                                    |
| なお、河川の状態把握の手法等については、第4章による。                                              |
+====================================================================================================+

＜推　奨＞

以下を参考にして、実施の基本的な考え方、実施の場所、頻度、時期、実施にあたっての留意点を記載することが望ましい。

> ①実施の基本的な考え方：区間区分の特性を踏まえて、河川巡視、点検等をどのような方針で実施するかを、実施する項目毎に記述。
>
> ②実施の場所、頻度、時期：実施の基本的な考え方を踏まえ、具体的な状態把握の実施方法を、実施する項目毎に記述。
>
> ③実施にあたっての留意点：実施の場所、頻度、時期の決定根拠となった事項や、例えば河川利用の状況や、重要な生物の存在等特に留意すべき事項がある場合に記述。
>
> なお、実施内容が同一区分内で全て一致しなければならないということではなく、河川の特性に応じて判断することが望ましい。

(6)具体的な維持管理対策

＜標　準＞

+--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 河川巡視や点検等の結果により、河川管理に支障を及ぼすおそれのある状態に達したと判断されるときに実施する不法行為への対策、維持工事、施設の補修・更新等の具体的な維持管理対策の内容について記述することを基本とする。 |
|                                                                                                                                                                                                                    |
| なお、具体的な維持管理対策については、第5章、第6章による。                                                                                                                                                         |
+====================================================================================================================================================================================================================+

(7)地域連携等

＜標　準＞

  -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  河川管理者と市町村等が連携して行うべき事項（排水ポンプの運転調整、避難判断の参考となる情報提供等）、河川管理者及び市町村、河川協力団体、NPO、市民団体等が連携・協働して行っている、あるいは行う予定がある事項（河川清掃活動、河川環境のモニタリング等）のうち、あらかじめ定めておくべき事項について記述することを基本とする。
  -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

(8)効率化・改善に向けた取り組み

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  より良好な河川環境の整備・保全、より効率的な河川維持管理等に向けたさらなる地域協働の取り組み、施設の老朽化に備えた長寿命化対策等、河川維持管理の効率化あるいは改善を進める取り組みについて、必要な事項を記述することを基本とする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

**第2節 サイクル型維持管理**

**2．1 サイクル型維持管理体系の構築**

＜考え方＞

河道や河川管理施設の被災箇所とその程度はあらかじめ特定することが困難である。河川維持管理はそのような制約のもとで、河道や河川管理施設において把握された変状を分析・評価し、対策等を実施せざるを得ないという性格を有している。実際、河川管理では、従来より河川の変状の発生とそれへの対応、出水等による災害の発生と対策や新たな整備等の繰り返しの中で順応的に安全性を確保してきている。そのため、河川維持管理にあたっては、河川巡視、点検による状態把握、維持管理対策を長期間にわたり繰り返し、それらの一連の作業の中で得られた知見を分析・評価して、河川維持管理計画あるいは実施内容に反映していくというＰＤＣＡサイクル（図2-1参照）を構築していくことが必要である。

![](media/image1.png){width="3.5in" height="2.546527777777778in"}

図2-1　サイクル型維持管理体系のイメージ

[＜標　準＞]{.mark}

+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 河川維持管理にあたっては、河川巡視、点検による状態把握、維持管理対策を長期間にわたり繰り返し、それらの一連の作業の中で得られた知見を分析・評価して、河川維持管理計画あるいは実施内容に反映していくというＰＤＣＡサイクルを構築していくことを基本とする。 |
|                                                                                                                                                                                                                                                          |
| また、河川整備計画は、河川の維持を含めた河川整備の全体像を示すものであり、河川維持管理におけるＰＤＣＡサイクルの中で得られた知見を河川整備計画にフィードバックし、必要に応じて河川整備計画の内容を点検し変更することも検討することを基本とする。         |
+==========================================================================================================================================================================================================================================================+

[＜推　奨＞]{.mark}

サイクル型維持管理体系を構築する際、状態把握の結果を分析・評価し、所要の対策を検討する手法等が技術的に確立されていない場合も多いため、学識者等の助言を得る体制を整備することが望ましい。

**2．2 河道計画等との関係**

＜考え方＞

河道計画の検討において河川維持管理の視点も重要である。土砂の堆積や植生の繁茂による流下能力の阻害、あるいは河床低下による河川管理施設の機能障害、河岸侵食による堤防の安全性の低下等、様々な変状については、日常あるいは出水後の河川維持管理により対応することになる。このため、河道の状態把握の結果を分析・評価して維持管理対策の検討を行うとともに、維持管理対策では十分な対応が困難な場合には河道計画にフィードバックした検討を行い、必要に応じて河道計画を見直すことが必要である。

また、河道の状態把握の結果を分析・評価するにあたっては、個々の施設や特定の箇所周辺の河道に限定せず、河道を一つのシステムとして捉えた検討^1）^を行うことが重要である。

河道計画のみならず、河川維持管理は水防活動にも密接に関連している。河川の状態把握の成果や対策の実施経緯は、重要水防箇所^2)^を判断する重要な資料になる。

＜関連通知等＞

1\)
河川砂防技術基準調査編,第4章：平成26年4月1日,国水情報第52号,水管理・国土保全局長.

2\)
重要水防箇所評定基準(案)の改定について：平成31年2月27日,国水環保第19号,河川環境課長.

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  河川整備基本方針あるいは河川整備計画における河道に関する具体的な内容を維持管理に反映させるためには、大河川においては河川管理を行うために必要とされる直轄河川管理基図^1)2)^を作成し、維持管理に反映することを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1\)
直轄河川管理基図の作成について：平成14年7月12日,国河治第69号,河川局長.

2\)
直轄河川管理基図作成要領等について：平成19年10月30日,国河治第71号,治水課長.

**第3章 河川維持管理目標**

**第1節 一般**

＜考え方＞

河川維持管理目標とは、河道及び河川管理施設を維持管理すべき水準であり、時間の経過や洪水・地震等の外力、人為的な作用等によって、本来河川に求められる治水・利水・環境の目的を達成するための機能が低下した場合、これを適確に把握して必要な対策を行うために設けるものである。

河川維持管理目標は、可能な場合に定量的に設定することを基本としているが、自然公物である河川では目標を工学的な指標等により定量的に設けることが困難な場合が多く、そのような場合には過去の経験等を踏まえて定性的なものであっても、設定することとしている。

なお、利水面については、河川整備計画において流水の正常な機能に関する目標が設定されていることから、その目標に基づき低水流量観測等^1)^を通じて河川の状態把握を行うものである。

＜標　準＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 河川維持管理目標は河川管理の目的に応じて、洪水、高潮、津波等による災害の防止、河川区域等の適正な利用、河川環境の整備と保全等に関して設定することを基本とする。                                                                               |
|                                                                                                                                                                                                                                              |
| 洪水、高潮、津波等による災害の防止については、具体の対象として河道の流下能力の維持と、施設の機能維持に分けて設定することを基本とする。                                                                                                       |
|                                                                                                                                                                                                                                              |
| 河川区域等の適正な利用については、河川敷地の不法占用や不法行為等への対応に関して設定することを基本とする。                                                                                                                                   |
|                                                                                                                                                                                                                                              |
| 河川環境の整備と保全等については、河川整備計画等に基づいて河川環境の整備と保全に関して設定することを基本とする。                                                                                                                             |
|                                                                                                                                                                                                                                              |
| 水防等については、河川の特性や地域の状況、出水特性等に応じて、水防管理団体への協力、連携や情報提供に関して設定することを基本とするとともに、出水、水質事故、地震時等の対応に必要な施設・機器の準備や対応等に関して設定することを基本とする。 |
+==============================================================================================================================================================================================================================================+

＜関連通知等＞

1\)
河川砂防技術基準調査編,第2章：平成26年4月1日,国水情報第52号,水管理・国土保全局長.\
（最新版）河川砂防技術基準　調査編,第2章（令和4年6月）,水管理・国土保全局長.

**第2節 河道の流下能力の維持に係る目標設定**

＜考え方＞

河道の流下能力を維持する目的は、計画高水位以下の水位で所定の洪水を安全に流下させることにあり、河道内の土砂堆積、樹木による死水域の発生等により変化する河道が、維持管理対策の直接の対象とな。

流下能力の維持に係る目標は、河川改修の実施状況を踏まえ設定することが必要である。具体的には、河川整備計画の河川改修が完了した段階点や、目標とする流量を定めて実施した再度災害防止対策が完了した段階等、河川整備計画などで定めた目標流量を安全に流下させる河川改修が完了した区間においては、河川改修により確保された流下能力を維持することとなる。

河川整備計画などで定めた目標流量を安全に流下させる河川改修が完了していない区間においては、段階的に実施される河川改修の進捗状況を踏まえつつ、上下流バランスなどに考慮しながら、当該区間の流下能力を維持する必要がある。

また、流下能力を持続的に確保していくためには、維持管理が容易な河道とすることが重要である。そのためには河道の変化の状況を経年的に蓄積し、変化の経緯も踏まえ、流砂系全体として上下流バランスのとれた河道となるよう河道計画へのフィードバックに努める必要がある。

なお、流下能力を評価するためには、単に河床や樹木等の地形的な変化だけでなく、水理計算を行うために必要な河床材料や植生等による粗度の変化等について把握することが重要である。

＜標　準＞

+--------------------------------------------------------------------------------------------------------------------------------------+
| 一連区間の河道の流下能力の維持に係る目標は、これまでの河川改修等により確保された流下能力を維持することを基本とする。                 |
|                                                                                                                                      |
| なお、大河川においては、流下能力を算定するにあたり、定期的な縦横断測量や河床材料調査等^1)^の結果から水理計算を行うことを基本とする。 |
+======================================================================================================================================+

＜推　奨＞

現況の流下能力を評価することは極めて重要であり、中小河川においても定期的な縦横断測量等を行うことが望ましい。縦横断測量の頻度が少ない場合においては、土砂の堆積状況を目視や定点撮影した写真により把握することや、簡易な手法でも横断測量や洪水痕跡調査等^1)^を行うことが望ましい。

河川改修により確保した流下能力は、時間の経過とともに、あるいは出水に伴い急激に土砂堆積が進行すること等により減少する場合があることから、河川整備計画等の中で、将来的な土砂堆積を見込むなど、変化を許容した河道計画を検討することが望ましい。

＜関連通知等＞

1\)
河川砂防技術基準調査編,第2章,第4章：平成26年4月1日,国水情報第52号,水管理・国土保全局長.\
（最新版）河川砂防技術基準調査編,第2章（令和4年6月）,第4章（平成26年4月）,水管理・国土保全局長.

**第3節　施設の機能維持に係る目標設定**

**3．1 基本**

＜考え方＞

代表的な河川管理施設である堤防をはじめ、護岸、床止め等の河川管理施設は、出水等の自然現象や、河川利用等により損傷あるいは劣化を生じる。樋門、水門、堰、排水機場等の構造物や機器についても、経時的な劣化や使用に伴い変状が生じる。このことは、河川にある許可工作物についても同様である。一方、河川管理にあたっては、施設の維持すべき機能に支障を及ぼす変状の度合いについては、現状では一部を除けば定量的に定めることは困難であり、変状の経時的な変化を把握し、変状の度合いを判断しながら機能を維持することが基本である。このため、施設毎に目視を中心とした点検を適切な時期に行い、平常時の河川巡視とも相まって施設の状態を把握し、その評価等を踏まえて必要な対策を実施することになる。

＜標　準＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 施設の機能維持は、施設の状態を把握し、機能への支障を判断しながら維持管理を行うことを基本とするため、その目標は、護岸等の安全に関わる河道の河床低下・洗掘の対策、堤防、堰、水門等の機能維持について、河道、施設の種別等に応じて設定することを基本とする。 |
|                                                                                                                                                                                                                                                          |
| また、水文・水理観測施設の機能維持の目標については、河川の状態把握の基本となる水文・水理観測の精度確保について設定することを基本とする。                                                                                                                 |
+==========================================================================================================================================================================================================================================================+

**3．2 河道（河床低下・洗掘の対策）に係る目標**

＜考え方＞

河道は、堤防、護岸等の施設の機能に重大な支障を及ぼさないことを目標の一つとして維持管理する必要がある。

河床は大小様々な河床材料で構成され、また表層下に粗粒化した層や固結した層が存在する場合があり、洗掘深は河床材料の深さ方向の分布の影響も受ける。また、砂河川においては洪水減水期の埋戻しが顕著であり、出水中の洗掘量を必ずしも正確に予測できるとは限らない。さらに、河道特性によっては大出水時に大きな洗掘が生じるとは限らず、中小規模の出水において大きな洗掘が生じる場合もあり、最深の河床高が正確に予測できる段階には至っていない。したがって、現時点で把握できるデータや研究成果、局所洗掘深の設計検討成果等を参考として対策を検討することが重要である。また、出水後の調査等によりデータを積み重ねていくことが必要である。

＜標　準＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 大河川においては、目標設定にあたって、当該施設と堤防防護ラインとの位置関係や低水路河岸管理ラインの有無、当該施設周辺の河床低下の傾向、みお筋の移動状況等を考慮して検討することを基本とする。 |
|                                                                                                                                                                                              |
| 護岸等の施設の基礎の保持のために、施設の基礎周辺の河床高の変化を把握し、河床低下傾向にある場合には、特に留意して点検を継続するものとし、河道の維持管理目標を設定することを基本とする。       |
|                                                                                                                                                                                              |
| なお、河川の下流部等、常時水面が護岸の基礎高より高い区間においては、目視による河床の状態把握ができないことから、定期的な測量等の結果により把握することを基本とする。                         |
+==============================================================================================================================================================================================+

＜推　奨＞

河川流量の分布特性の変化等に起因する河道形状の変化や樹林化の進行の変化は、現段階では不明確ながら、長期的には、河道内の樹木の生育環境や土砂の生産・移動環境に変化をもたらす可能性がある。そのため、河道内のモニタリング手法の高度化を推進し、効率的な維持管理を継続的に行っていくべきである。例えば、レーザー計測等から得られる標高の3
次元点群データを活用し、樹木繁茂量や樹高の変化、土砂の堆積・侵食量等を経年的・定量的に把握することや、3
次元点群データや画像データなどのビッグデータを基に、AI
技術による自動判別を用いた河道や堤防等の点検や変状把握を図るなど、維持管理の高度化に取り組んでいくことが望ましい。

中小河川においては、大河川に準じて目標設定を行うことが望ましい。

＜関連通知等＞

1\)
「気候変動を踏まえた水災害対策のあり方について」答申：令和2年7月,社会資本整備審議会.

**3．3 堤防に係る目標**

＜考え方＞

(1)堤防の安全性を確保するために維持すべき機能

堤防の安全性を確保するためには、所要の耐浸透機能、耐侵食機能、耐震機能を維持することが必要である。それらの機能を低下させるクラック、わだち、裸地化、湿潤状態等の変状が見られた場合に、当該箇所の点検を継続し、堤防の機能に支障を生じると判断した場合には必要な対策を実施することとなる。また、現在の堤防の多くは、長い治水の歴史のなかで、過去の被災の状況に応じて嵩上げ、腹付け等の補強・補修工事を重ねてきた結果として現況の断面（高さ、天端幅、法勾配等）が定まっているものであり、堤防の維持管理は堤防の断面を維持するものとしている。

(2)安全性照査と維持管理

大河川の堤防では、河川砂防技術基準設計編^1)^に基づいてそれぞれの機能毎に堤防の安全性を照査し、所要の安全性が確保されていないと判断される区間について堤防強化が進められており、維持管理にあたっても照査結果を考慮する必要がある。ただし、洪水あるいは地震による堤防の不安定化、あるいは変形メカニズム等については、現時点においても十分に解明されているわけではないことから、安全性の照査がなされている区間であっても、点検あるいは平常時の河川巡視による状態把握に基づいて堤防を維持管理するものとしている。

(3)樋門等の堤防を横断する構造物周辺の維持管理

樋門等の堤防を横断する構造物の周辺においても、堤防の機能が維持されている必要がある。特に函体底版周辺の空洞化や堤体の緩みにともなう漏水等、浸透については個別に十分な点検を行い、一連区間の堤防と同じ水準の機能が維持されるよう維持管理するものとしている。

＜標　準＞

  -----------------------------------------------------------------------
  堤防に係る目標は、所要の治水機能が維持されることとする。
  -----------------------------------------------------------------------

  -----------------------------------------------------------------------

＜関連通知等＞

1\) 河川砂防技術基準設計編：令和元年7月.\
（最新版）河川砂防技術基準設計編, 令和7年○月,
国土交通省水管理・国土保全局.

**3．4 護岸、根固工、水制工に係る目標**

＜考え方＞

護岸、根固工、水制工を構成するブロックのめくれや滑動等については、既往の研究成果や現時点で把握できるデータ等を踏まえ検討することができるが、変状がどの程度まで許容できるかは必ずしも明らかではなく、点検及びその分析を積み重ね対策に反映することが重要である。

護岸の機能を低下させる変状としては、吸い出しによる護岸背面の空洞化が多いが、空洞化の状況は、護岸表面に明らかな変状が現れない限り把握困難である。また、護岸が常時水面下にあるような区間においては、変状そのものの把握が困難である。このため、空洞化等が疑われる場合には、目視点検を継続するとともに、必要に応じて目に見えない部分の計測等を行うことが重要である。

また、河川環境上の機能を求められる施設については、その点も考慮する必要がある。なお、河床低下に関しては第3章第3節3.2による。

＜標　準＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 護岸、根固工、水制工は、耐侵食等所要の機能を維持することを目標として維持管理することを基本とする。                                                                                                                   |
|                                                                                                                                                                                                                      |
| 護岸に機能低下のおそれがある目地の開き、吸い出しが疑われる沈下等の変状が見られた場合は、点検等を継続し、変状の状態から護岸の耐侵食機能に重大な支障が生じると判断した場合には、必要な対策を実施することを基本とする。 |
+======================================================================================================================================================================================================================+

**3．5 床止め（落差工、帯工含む。）に係る目標**

＜考え方＞

床止めの機能に支障を及ぼす変状を定量的に評価できる状況にはなく、床止めの維持管理においては状態把握が重要となる。また、護床工や水叩き等の空洞化の状況は表面に明らかな変状が現れない限り把握困難である。護床工等が常時水面下にあるような場合は、変状そのものの把握が困難である。そのため、空洞化が疑われる場合には必要に応じて目に見えない部分の計測を行う等により状態把握を行い、点検及びその評価を積み重ねることにより、対策や維持管理計画等に反映することが重要である。

魚道等の付属施設についても、機能の低下につながるおそれがある変状について把握することも重要である。なお、魚道については魚道本体だけではなく前後の河床の状態把握が重要である。

＜標　準＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 床止め（落差工、帯工含む。）は、所要の機能を維持することを目標として維持管理することを基本とする。                                                                                           |
|                                                                                                                                                                                              |
| 床止め本体及び護岸工等の沈下、変形等、機能低下のおそれがある変状が確認された場合は、点検等を継続し、機能の維持に重大な支障が生じると判断した場合には、必要な対策を実施することを基本とする。 |
+==============================================================================================================================================================================================+

**3．6 堰、水門、樋門、排水機場等に係る目標**

＜考え方＞

堰、水門等の土木施設部分については、補修等が必要な変状の程度は必ずしも明らかになっていないため、点検及びその評価を積み重ね、対策や維持管理計画等に反映することが重要である。

機械設備・電気通信施設については、河川用ゲート・ポンプ設備の点検・整備等に関するマニュアル等^1)2)3)4)5)^に基づいて定期点検等による状態把握を行い、変状の状態から施設の機能維持に支障が生じると判断される場合には、必要な対策を行うものである。

堰等に設置されている魚道については、機能の低下につながるおそれがある変状について把握するものである。その際、魚道本体だけではなく上下流の河床の状態把握が重要である。

＜必　須＞

  ----------------------------------------------------------------------------------------------------
  堰、水門、樋門、排水機場等の機械設備を有する施設は、操作規則等に則り適切に操作しなければならない。
  ----------------------------------------------------------------------------------------------------

  ----------------------------------------------------------------------------------------------------

＜標　準＞

+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 堰、水門、樋門、排水機場等の施設は、所要の機能を維持することを目標として維持管理することを基本とする。                                                                                                                                                           |
|                                                                                                                                                                                                                                                                  |
| 各施設の土木施設部分については、クラック、コンクリートの劣化、沈下等の変状等、各々の施設に機能低下のおそれがある変状がみられた場合には、点検を継続し、変状の状態から施設の機能の維持に重大な支障を生じると判断される場合に必要な対策を実施することを基本とする。 |
+==================================================================================================================================================================================================================================================================+

＜関連通知等＞

1\)
河川用ゲート・ポンプ設備点検・整備・更新検討マニュアル（案）の改定について：平成27年3月31日,国総施安第11号,国水環保第8号,
総合政策局公共事業企画調整課施工安全企画室長,水管理・国土保全局河川環境課河川保全企画室長.

2\)
ゲート点検・整備要領（案）：ゲート点検・整備要領検討委員会編,(社)ダム・堰施設技術協会,平成17年1月.

3\)
揚排水機場設備点検・整備指針（案）の制定について：平成20年6月27日,国技電第56号,国総施第111号,国河治第151号,技術調査課長,建設施工企画課長,治水課長.

4\)
ダム・堰施設技術基準（案）の一部改定について：平成28年3月31日,国技電第72号,国総公第80号,国水環第140号、国水治第142号、大臣官房技術調査課長、総合政策局公共事業企画調整課長，水管理・国土保全局河川環境課長.

5\)
電気通信施設点検基準（案）：令和元年12月23日,国技電第49号、大臣官房技術調査課長.

**3．7 水文・水理観測施設に係る目標**

＜考え方＞

水文・水理観測施設は河川維持管理の基本資料を取得するための重要な施設であり、第4章第2節2.1、第4章第2節2.5に示すように適切に点検・整備等を実施する必要がある。

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------
  水文・水理観測施設は、対象とする水文観測データ（降水量、レーダ雨量（Cバンド・XRAIN）、水位、流量等）を適確に観測できることを目標として維持管理することを基本とする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------

**第4節 河川区域等の適正な利用に係る目標**

＜考え方＞

治水、利水、環境の河川管理の目的を達成するためには、河川区域、河川保全区域及び河川予定地が適正に利用されることが前提である。河川区域における河川敷地の不法占用、工作物の不法な設置等は治水あるいは河川環境上の支障になり、河川保全区域における不法な掘削等は堤防の安全性に影響を及ぼす。また、河川は広く一般の利用に供されるべきものであることから、一部の利用者による危険な行為等が行われないようにする必要がある。

＜標　準＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 河川区域等が、治水、利水、環境の目的と合致して適正に利用されるよう、河川敷地の不法占用や不法行為等への対応のほか、河川の利用に関する目標を設定することを基本とする。                   |
|                                                                                                                                                                                        |
| 河川維持管理の実施にあたっては、河川の自然的、社会的特性、河川利用の状況等を勘案しながら、河川の状態把握を行うとともに、河川敷地の不法占用や不法行為等への対応を行うことを基本とする。 |
+========================================================================================================================================================================================+

**第5節 河川環境の整備と保全に係る目標**

＜考え方＞

河川整備計画の目標には河川環境の整備と保全に関する事項が定められている。また、河川環境管理基本計画が作成されている河川では、河川の水量及び水質、河川空間等に関してより具体的な管理に関する記載がなされている。河川維持管理にあたっては、現状の河川環境を保全するだけではなく、維持管理対策により河川整備計画等に定められた目標に向けた河川環境の整備がなされることが重要である。

そのため、河川維持管理目標は、河川整備計画あるいは河川環境管理基本計画に定められた内容を踏まえ、河川環境が適正に整備あるいは保全されるよう設定する必要がある。

河川整備計画や河川環境管理基本計画により河川環境や河川利用に係るゾーニング等の空間管理の具体的な目標が定められている場合には、それに合致するよう河川が適正に利用されることが河川維持管理の目標となる。対象別に見ると、希少性や典型性、象徴性、上位性等の観点から守るべき特定の生物種や群集及びその生息域の保全、あるいは景観法（平成16年法律第110号）等で定められる特定の景観の保全等を河川維持管理の目標とすることができる。また、地域の歴史文化や伝統行事等に関わる特徴的な河川空間の状態の保全等も目標とすることができる。

河川環境の整備と保全においては、調査や河川巡視等により河川の状態把握に取り組みながら維持管理することが重要である。

近年では、外来植物等の外来生物の駆除も、河川環境の保全上重要な課題になってきており、これら課題への対応も重要である。

＜標　準＞

+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 河川整備計画を策定した河川においては、当該河川における、生物の生息・生育・繁殖環境、河川利用、河川景観の状況等を踏まえ、河川環境の整備と保全に関する目標を設定することを基本とする。     |
|                                                                                                                                                                                          |
| 河川環境の整備と保全に関する目標は、生物の生息・生育・繁殖環境、河川景観、人と川とのふれあいの場、水質等について、当該河川の特性や社会的な要請等を考慮しながら検討することを基本とする。 |
+==========================================================================================================================================================================================+

＜推　奨＞

河川整備計画を策定していない河川においては、速やかに策定するとともに、策定までの期間においても、当該河川における、生物の生息・生育・繁殖環境、河川利用、河川景観の状況等を踏まえ、河川環境の整備と保全に関する目標を設定することが望ましい。

＜関連通知等＞

1\)
実践的な河川環境の評価・改善の手引き（案）：公益財団法人リバーフロント研究所、平成31年3月.\
（最新版）実践的な河川環境の評価・改善の手引き（案）：公益財団法人リバーフロント研究所,令和5年7月.

**第4章 河川の状態把握**

**第1節 一般**

＜考え方＞

河川の状態把握は、自然公物である河川の維持管理を目的とし、状態把握を行いつつその結果を分析、評価して対策を実施するものである。

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  河川の状態把握として実施する項目は、基本データの収集^1)^、平常時及び出水時の河川巡視、出水期前・台風期・出水後等の点検、及び機械設備を伴う河川管理施設の点検を基本とする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1\)
河川砂防技術基準調査編,第2章,第4章,第22章：平成26年4月1日,国水情報第52号,水管理・国土保全局長.\
（最新版）河川砂防技術基準調査編,第2章（令和4年6月）,第4章（平成26年4月）,第22章（令和4年6月）,水管理・国土保全局長.

(1)基本データの収集

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  基本データの収集として、降水量、レーダ雨量（Cバンド・XRAIN）、水位、流量等の水文・水理等の観測、平面、縦横断等の測量、河床材料等の河道の状態に関する資料を収集することを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1\)
河川砂防技術基準調査編,第2章,第4章,第22章：平成26年4月1日,国水情報第52号,水管理・国土保全局長.\
（最新版）河川砂防技術基準調査編,第2章（令和4年6月）,第4章（平成26年4月）,第22章（令和4年6月）,水管理・国土保全局長.

(2)平常時及び出水時の河川巡視

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  平常時及び出水時の河川巡視^1)^では、河道及び河川管理施設等の状況の把握、河川区域内における不法行為の発見、河川空間の利用に関する情報収集及び河川の自然環境に関する情報収集等を概括的に行うことを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1\)
河川巡視規程例について：平成23年5月11日,事務連絡,水政課河川利用企画調整官,河川保全企画室長.

(3)出水期前・台風期・出水後等の点検

＜標　準＞

+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 出水期前・台風期の点検^1)2)3)^は、河道及び河川管理施設を対象として状態の変化について確認を行うことを基本とする。また、規定規模以上の出水や高潮、地震等が発生した場合に、それらの発生後に施設等の点検を行うことを基本とする。 |
|                                                                                                                                                                                                                              |
| また、堰、水門・樋門、排水機場等の機械設備を伴う河川管理施設については、定期点検等により状態把握を行うことを基本とする。                                                                                                     |
+==============================================================================================================================================================================================================================+

＜関連通知等＞

1\) 堤防等河川管理施設及び河道の点検・評価要領：平成31年4月,
国水環保第1号,河川環境課長.\
（最新版）堤防等河川管理施設及び河道の点検・評価要領：令和5年3月,
国水環保第13号,河川環境課長.

2\)
中小河川の堤防等河川管理施設及び河道の点検要領の改定について：平成29年3月28日,国水環保第43号,河川保全企画室長.\
（最新版）中小河川の堤防等河川管理施設及び河道の点検要領の改定について：令和6年3月27日,国水環保第5号,河川保全企画室長.

(4)河川巡視と点検の区分

＜考え方＞

河川巡視と点検とはその目的により明確に区分される。

河川巡視とは、定期的・計画的に河川を巡回し、その異常及び変化等を概括的に把握することを目的としており、点検とは一つ一つの河川管理施設の治水上の機能について異常及び変化等を発見・観察・計測等することを目的としている。不法行為への対応等、発見時に迅速な初動対応が必要な行為については、河川巡視に含めることができる。

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------
  河川の状態把握に求められる内容と精度は、河川巡視と点検でそれぞれ異なるため、目的に応じて適切に実施することを基本とする。
  --------------------------------------------------------------------------------------------------------------------------

  --------------------------------------------------------------------------------------------------------------------------

(5)状態把握結果の記録と公表

＜考え方＞

河川巡視や点検の結果はその後の維持管理にとって重要な情報となるので、河川カルテ等に適切に記録し、公表することが重要である。

河川の状態把握の技術は経験による部分が大きく、その分析・評価の手法等も確立されていない場合が多いことから、大河川では、学識者、管理経験者等の助言を得られるよう体制を整備することが重要である。

＜標　準＞

+------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 河川の状態把握は、基本データの収集、河川巡視、点検等により行うこととし、河川維持管理の目標、河川の区間区分、河道特性等に応じて、適切に実施することを基本とする。 |
|                                                                                                                                                                  |
| また、現状の河川管理施設の点検結果を評価し、管理の現況を地域に分かり易く公表していくことを基本とする。                                                           |
|                                                                                                                                                                  |
| 大河川においては、河川維持管理データベースシステム(RiMaDIS：River Management Data Intelligent                                                                    |
| System以下、「RiMaDIS」とする。)により、河川巡視・点検結果や河道基盤情報等の河川維持管理に関する基本情報を効果的に蓄積することを基本とする。                     |
+==================================================================================================================================================================+

＜推　奨＞

河川管理用カメラ、無人航空機(UAV：Unmanned Aerial
Vehicles　以下、「UAV」とする。)等ICT機器を活用することにより、効果的・効率的な河川の状態把握に努める。河川管理用カメラの整備については、「河川管理用カメラ整備基準」1)に基づき検討・実施する。

中小河川においても、河川の状態把握の分析・評価にあたっては、学識者、管理経験者等の助言を得られるよう体制を整備することが望ましい。

中小河川においても、状態把握データの保存にあたっては、電子的なデータベースを構築し、収集したデータについて蓄積、分析、評価を行っていくことが望ましい。

＜関連通知等＞

1\) 河川管理用カメラ情報の充実に向けた取組について
：平成28年3月16日,事務連絡,大臣官房技術調査課電気通信室長,総合政策局公共事業企画調整課整課施行安全企画室長,河川情報企画室長,河川保全企画室長,河川整備調整官.

**第2節 基本データの収集**

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  基本データの収集として、水文・水理等観測データ、平面、縦横断等の測量、河床材料等の河道の資料、河川の自然環境や利用実態等の河川環境の資料等を収集することを基本とする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------

**2．1 水文・水理等観測**

＜考え方＞

治水・利水計画の検討、洪水時の水防活動に資する情報提供、河川管理施設の保全、渇水調整の実施等の維持管理の基本となる重要なデータを把握するため、水文・水理観測、水質調査のデータを取得するものである。また、このほかの観測項目として、震度観測、潮位観測、風向・風速観測、積雪深観測、地下水位観測等多岐にわたる観測項目があり、各河川、流域の特性に応じて河川維持管理計画に適宜追加する必要がある。

＜標　準＞

+--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 大河川における水文・水理観測、水質調査は、水文観測業務規程^1)^及び同細則^2)、^河川砂防技術基準調査編^14)^、河川水質調査要領^5)^等に基づき実施することを基本とする。                                                                                                                                                                                                                  |
|                                                                                                                                                                                                                                                                                                                                                                                      |
| 降水量、レーダ雨量（Cバンド・XRAIN）、水位の観測は自動観測が一般的であるが、河川管理上特に重要となる高水流量観測は所要の地点において計画的、迅速に実施することを基本とする。また、低水流量観測は、流水の正常な機能の維持のために必要な箇所と時期において実施することを基本とする。また、水質調査は、公共用水域の水質把握等に必要とされる適切な箇所において実施することを基本とする。 |
+======================================================================================================================================================================================================================================================================================================================================================================================+

＜関連通知等＞

1\) 水文観測業務規程：平成29年3月31日,国水情第44号,国土交通事務次官.

2\)
水文観測業務規程細則：平成29年3月31日,国水情第45号,水管理・国土保全局長.

3\)
水文観測業務の実施方針について：平成29年5月24日,国水情第1号,河川計画課長.

4\)
河川砂防技術基準調査編,第2章,第12章：平成26年4月1日,国水情報第52号,水管理・国土保全局長.\
（最新版）河川砂防技術基準調査編,第2章,第12章：平成26年4月1日,国水情報第52号,水管理・国土保全局長.

5\) 河川水質調査要領（案）：平成17年3月,国土交通省河川局河川環境課.

＜推　奨＞

中小河川における水文・水理観測、水質調査についても大河川に準じて実施することが望ましい。

**2．2 測量**

**2．2．1 縦横断測量**

＜考え方＞

河川の縦横断測量は、河道の状態把握及び適切な許可を行うために実施する。大きな河床変動を生じる沖積河川では、平均年最大流量規模以上の出水があった場合等を目安にして縦横断測量を実施する必要がある。

河川の縦横断形を現況と大きく変えた場合、ダム・堰等の横断工作物を新たに設置した場合等、河床の変動が大きくなると想定される区間では、より高い頻度で実施することが重要である。また、岩河床化が進み長期的に安定した河床等では実施間隔をより長くすることもできる。縦横断測量の範囲、密度の設定にあたっては、築堤直後や地盤沈下等により堤防高の変化が考えられる箇所を考慮する必要がある。河口部では、河口テラスの形状を把握するため、河口より沖合についても必要な範囲で実施することが重要である。また、河口閉塞を生じる河川では必要に応じて当該区域の測量の頻度を増加させるものである。

＜標　準＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 現況河道の流下能力、河床の変動状況等を把握するため、適切な時期に縦横断測量を実施することを基本とする。                                                                                                   |
|                                                                                                                                                                                                          |
| 大河川においては、点群測量^1)^により5年以内に1回程度は実施することを基本とする。また、出水により大きな河床変動を生じた場合には実施することを基本とする。                                                 |
|                                                                                                                                                                                                          |
| 一連区間の縦横断測量を実施した際には、過去の断面との重ね合わせにより顕著な堆積に伴う流下阻害、局所洗掘、河岸侵食等危険箇所の発生や変化の状態を把握し、あるいは流下能力の評価を実施することを基本とする。 |
|                                                                                                                                                                                                          |
| 測量の手法等は河川砂防技術基準調査編^2)^、河川定期縦横断測量業務実施要領・同解説^3)^による。                                                                                                             |
+==========================================================================================================================================================================================================+

＜関連通知等＞

1\)
河川砂防技術基準調査編,第22章：平成26年4月1日,国水情報第52号,水管理・国土保全局長.\
（最新版）河川砂防技術基準　調査編,第22章（令和4年6月）,水管理・国土保全局長.

2\) 河川定期縦横断測量業務実施要領・同解説：平成30年4月, 国土交通省
水管理・国土保全局 河川保全企画室.

＜推　奨＞

変化の大きい低水路部分のみを密に測量することや、取得した点群データを活用する等、より効率的、効果的な測量手法についても検討することが望ましい。

中小河川においては、大きな出水や河道の改変の状況を踏まえ、必要に応じて縦横断測量を実施する。

＜例　示＞

レーザ測量機器等を用いて地表面や河床等の高密度な三次元地形データを取得する測量方法のうち航空レーザ測深（ALB:Airborne
Laser Bathymetry
以下、「ALB」とする。）は、陸部を近赤外レーザ、水部をグリーンレーザにより同時に計測することが可能である。また、点群測量を行えるレーザー測量機器には、ALBの他に、陸部ではモービルマッピングシステム(Mobile
Mapping System
以下、「MMS」とする。)、水部ではナローマルチビーム、陸部・水部を同時に計測できる陸上・水中レーザードローン等の新技術がある。

なお、点群測量及び三次元データの活用にあたっては、点群測量の標準的な一連の作業方法や考え方、活用する上でのポイント等についてまとめられた河川管理用三次元データ活用マニュアル（案）^１)^を参考にするとよい。

＜関連通知等＞

1\) 河川管理用三次元データ活用マニュアル（案）：令和2年2月, 国土交通省
水管理・国土保全局 河川環境課 河川保全企画室.

**2．2．2 地形測量**

＜考え方＞

河床（みお筋、平面形状）の変動状況の把握、護岸等の施設管理の基本となる重要な資料として地形測量がある。また、河道内の樹木等の変化と合わせて流下能力の評価の基本となるデータとして利用することや、河川の適切な利用にあたり必要な許可を行うための状況を把握するための資料であることから、地形測量による平面図の作成は重要である。

河岸の侵食が進み、堤防に河岸が近づく状況が見られる箇所ではより高い頻度で実施する等、対策が必要な状態を見逃さないよう留意することが重要である。

＜標　準＞

+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 大河川においては、平面図を作成するための地形測量は、縦横断測量に合わせて実施することを基本とする。ただし、河川の平面形状の変化がない場合等、状況により間隔を延ばす、部分的な測量とする等の工夫を行うことを基本とする。 |
|                                                                                                                                                                                                                        |
| 平面図を修正した場合には、過去の成果との重ね合わせにより、みお筋、平面形状、河道内の樹木等の変化を把握するなど積極的に活用することを基本とする。                                                                       |
+========================================================================================================================================================================================================================+

＜推　奨＞

中小河川においては、大河川に準じて、地形測量を行うことが望ましい。

**2．3 河道の基本データ**

(1)河床材料調査について

＜考え方＞

河床の変動状況や流下能力等を把握するため、管理の基本となる資料として粒度分布等の河床材料調査を実施するものである。

＜標　準＞

+----------------------------------------------------------------------------------------------------------------------------------------------------+
| 大河川においては、河床材料調査は縦横断測量と合わせて実施することが好ましく、出水状況、土砂移動特性等を踏まえて実施時期を設定することを基本とする。 |
|                                                                                                                                                    |
| 具体の調査方法は河川砂防技術基準調査編^1)^による。                                                                                                 |
+====================================================================================================================================================+

＜関連通知等＞

1\)
河川砂防技術基準調査編,第4章：平成26年4月1日,国水情報第52号,水管理・国土保全局長.

＜推　奨＞

河床材料調査を実施した際には、過去の結果との比較を行い、他の河道特性との関連分析、河床変動と連動した粒度分布等の特性変化の把握等、積極的に活用するよう努める。河川改修によって河川の川幅、縦断形等を変えた区間、ダム・堰等の横断構造物の設置により河床が安定していない区間、河口部、荒廃山地から流出する支川の合流点下流、セグメントの変化点等では、特に密に河床材料調査を実施することが望ましい。

中小河川においては、大河川に準じて、河床材料調査を実施することが望ましい。

(2)河道内樹木調査について

＜考え方＞

流下能力や堤防等の施設の機能維持を検討するため、管理の基本となる資料として河道内樹木調査を実施するものである。

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------
  大河川においては、航空写真の撮影や河川巡視等によって樹木分布や密度の概略を把握するとともに、河道内樹木調査を実施することを基本とする。
  ----------------------------------------------------------------------------------------------------------------------------------------

  ----------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

樹木の繁茂速度は河川や地域によって様々であるが、伐開した区域の再生状況や新たな樹林化の状況については、年1回程度の目視点検により確認することが望ましい（第4章第5節5.1.1参照）。過去の資料との比較等により河川の流下能力に影響を及ぼすような大きな変化が見られると判断された場合等には、樹木の伐採に関する基準^2)^等に基づいて必要な区域の樹木群を対象に調査（樹種、樹木群の高さ、枝下高さ、胸高直径、樹木密度等）を実施するよう努める。

河道内の樹林の進行の変化を把握するために、ALB、UAV等から得られる点群測量データを活用し、樹木繁茂量や樹高の変化を経年的・定量的にモニタリングを行うことが望ましい。

河川水辺の国勢調査を実施している河川では、植生図作成調査、群落組成調査、植生断面調査の成果を活用することが望ましい。

中小河川においては、大河川に準じて、河道内樹木調査を実施することが望ましい。

＜関連通知等＞

1\)
河川区域内における樹木の伐採・植樹基準について：平成10年6月19日,建河治発第44号,治水課長.

**2．4 河川環境の基本データ**

＜考え方＞

河川環境の整備と保全を目的とした河川維持管理を行うにあたっては、河川における生物の生息状況等を把握することが必要である。

河川の利用実態や河川に係る歴史・文化の把握も重要である。

また、工事実施箇所においては、多自然川づくりの追跡調査として河川環境の変化を把握することも重要である。

＜標　準＞

+------------------------------------------------------------------------------------------------------------------------------------------------------+
| 大河川においては、河川の自然環境や利用実態に関して、河川水辺の国勢調査^1)^を中心として包括的、体系的、継続的に基本データを収集することを基本とする。 |
|                                                                                                                                                      |
| 具体の調査方法は、河川砂防技術基準調査編^2)^による。                                                                                                 |
+======================================================================================================================================================+

＜推　奨＞

河川環境の状態把握のために必要とされる基本データとしては、河川水辺の国勢調査のように、河川全体、生物相全体について、包括的、体系的な調査成果を用いることが望ましい。

河川環境に関する情報は多岐にわたるため、河川維持管理に活用するためには総括的な地図情報にするとよく、状態把握の結果を河川環境情報図として整理することに努める。

なお、基本データの収集・整理にあたっては、学識経験者や地域で活動する河川協力団体、市民団体、NPO等との連携・協働にも努める。

中小河川においては、自然環境等の状況を踏まえ、必要に応じて河川の自然環境や利用実態に関する基本データを収集する。

＜関連通知等＞

1\)
河川水辺の国勢調査実施要領の改定について：平成19年3月7日,国河環第68号,河川環境課長.

2\)
河川砂防技術基準調査編,第11章：平成26年4月1日,国水情報第52号,水管理・国土保全局長.\
（最新版）河川砂防技術基準　調査編,第11章（令和6年6月）,
水管理・国土保全局長.

**2．5 観測施設、機器の点検**

＜考え方＞

観測施設、機器については、適切に点検・整備を行い、必要とされる観測精度を確保できない変状を確認した場合には、対策を実施する必要がある。

＜標　準＞

+--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 河川維持管理の基礎的資料である降水量、レーダ雨量（Cバンド・XRAIN）、水位、流量等の水文・水理データや水質データを適正に観測するため、定期的に行う観測施設、機器の点検は、以下を基本とする。 |
|                                                                                                                                                                                            |
| > ①観測所、観測機器及び観測施設については、年1回以上の総合点検、原則月1回以上の定期点検及び臨時点検を実施する。^1)\ 2)^                                                                    |
|                                                                                                                                                                                            |
| ②点検の内容等は、河川砂防技術基準調査編^1)^による。                                                                                                                                        |
|                                                                                                                                                                                            |
| > ③観測施設に付属する電気通信施設については、年1回以上の総合的な点検を実施する^4)^他、必要に応じて機器の異常の有無を確認する。                                                             |
| >                                                                                                                                                                                          |
| > ④必要とされる観測精度を確保できない観測施設、機器の変状を確認した場合の対策は、水文観測業務規程細則^1)2))^等^5)^に基づいて実施する。                                                     |
| >                                                                                                                                                                                          |
| > ⑤樹木の繁茂等により降水量、流量観測等に支障が出る場合には、伐開等を実施する。                                                                                                            |
+============================================================================================================================================================================================+

＜関連通知等＞

1\) 水文観測業務規程：平成29年3月31日,国水情第44号,国土交通事務次官.

2\)
水文観測業務規程細則：平成29年3月31日,国水情第45号,水管理国土保全局長.

3\)
河川砂防技術基準調査編,第2章：平成26年4月1日,国水情報第52号,水管理・国土保全局長.\
（最新版）河川砂防技術基準　調査編,第2章（令和4年6月）,水管理・国土保全局長.

4\)
電気通信施設点検基準（案）：令和元年12月23日,国技電第49号,大臣官房技術調査課長.

5\)
水文観測業務の適切な実施等について：平成14年4月22日,国河環第9号,河川環境課長.

**第3節 堤防点検等のための環境整備**

＜考え方＞

堤防や高水敷の除草（以降に示す「除草」と、河川法上の「草刈り」は同義とする。）や障害物の処分等は、河川巡視や堤防点検などによる河川の状態把握のための環境整備及び堤体の保全を目的としたものである。

＜必　須＞

  --------------------------------------------------------------------------------------------------------------------
  堤防の表面の変状等を把握するために行う堤防の除草は、堤防又は高水敷の規模、状況等に応じ適切な時期に行うものとする。
  --------------------------------------------------------------------------------------------------------------------

  --------------------------------------------------------------------------------------------------------------------

＜標　準＞

+-------------------------------------------------------------------------------------------------------------------------------------------------------+
| 大河川における堤防除草は、以下を基本とする。                                                                                                          |
|                                                                                                                                                       |
| > ①出水期前及び台風期の堤防の点検に支障がないよう、それらの時期に合わせて年2回堤防の除草を行う。                                                      |
| >                                                                                                                                                     |
| > ②堤体の保全のための除草は堤防点検等のための環境整備の除草と兼ねて行い、気候条件や植生の繁茂状況、背後地の状況等に応じて決定することを基本とする。   |
| >                                                                                                                                                     |
| > ③大河川では年2回を基本とするが、植生の生育条件等により年1回の除草で堤防の保全及び堤防点検等に支障のない場合等には、年2回の除草としなくてもよい。    |
| >                                                                                                                                                     |
| > ④高水敷等に植生が繁茂し、あるいは樹木が密生する等により水文・水理等観測、巡視・点検時の見通線の確保等に支障を生じる場合には、除草、伐開を実施する。 |
|                                                                                                                                                       |
| また、中小河川においても、点検等に支障がないように河川の区間区分等に応じて堤防の除草の時期、頻度を設定することを基本とする。                          |
|                                                                                                                                                       |
| なお、除草の手法等については第6章第2節2.1.2による。                                                                                                   |
+=======================================================================================================================================================+

＜例　示＞

植生の繁茂状況等により年2回では堤防の変状が把握できない場合や、洪水時における漏水の状況等を把握する必要のある場合等には、経済性等を十分に勘案し、年3回以上の除草を行っている事例がある。

**第4節 河川巡視**

**4．1 一般**

＜考え方＞

河川巡視は、河道及び河川管理施設等の状況の把握、河川区域等における違法・違反行為の発見、河川空間の利用に関する情報収集、河川の自然環境に関する情報収集を対象として、概括的に行うものである。

＜必　須＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  河道及び河川管理施設等の河川巡視は、河川管理施設等の構造又は維持若しくは修繕の状況、河川の状況、河川管理施設等の存ずる地域の気象の状況その他の状況を勘案して、適切な時期に実施するものとする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+--------------------------------------------------------------------------------------------------------------------------------+
| 大河川における河道及び河川管理施設等の河川巡視は、河川巡視規程例^1)^を定め計画的かつ効率的、効果的に実施することを基本とする。 |
|                                                                                                                                |
| 中小河川においても大河川に準じて、河川巡視規程例^1)^を参考に計画的かつ効率的、効果的に河川巡視を実施することを基本とする。     |
+================================================================================================================================+

＜関連通知等＞

1\)
河川巡視規程例について：平成23年5月11日,事務連絡,水政課河川利用企画調整官,河川保全企画室長.

**4．2 平常時の河川巡視**

＜考え方＞

平常時の河川巡視は、河川維持管理の基本をなすものであり、定期的、計画的に河川を巡回し、その異常及び変化等を概括的に把握するために行うものである。

巡視により、異常を発見した場合は、ただちにその状況を把握し、河川カルテ等に記録し、適切に是正することが重要である。

(1)一般巡視と目的別巡視

平常時の河川巡視は、あらかじめ設定した巡視項目について巡視を行う一般巡視と、巡視項目、目的、場所等を絞り込んだ目的別巡視に分類される。河川は延長が長く面積も広大であるため、不法係留等の状況や、河川の水質状況、ゴミ等の投棄の有無、河川敷地の利用状況等について、より詳細に状況を把握する場合には目的別巡視を行うものである。

(2)河道及び河川管理施設等の河川巡視

河道及び河川管理施設等の河川巡視は、河岸、河道内の堆砂、河口閉塞、樹木群、堤防、護岸・根固工、堰・水門等について目視により確認可能な比較的に規模の大きな変状を発見するために行うものである。

(3)違法・違反行為発見のための河川巡視

違法・違反行為発見のための河川巡視は、河川区域、河川保全区域及び河川予定地において、土地の占用や工作物の設置状況等に関し、違法・違反行為がないか確認するために行うものである。

(4)河川の利用状況把握のための河川巡視

河川利用は常時行われるものであるため、日常の河川の利用状況を把握する目的で河川巡視を行うものである。

(5)自然環境に関する状態把握のための河川巡視

自然環境に関する日常の状態把握のための河川巡視は、瀬、淵、みお筋の状態、砂州の位置、魚類等の産卵場となる河床の状況、鳥類の繁殖場となる河道内の樹木の状況、樹木の洪水流への影響、魚道の状況、堤防や河川敷地の外来植生の状況等について確認するために行うものである（第8章参照）。

＜標　準＞

+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 大河川における一般巡視は以下を基本とする。                                                                                                                                                           |
|                                                                                                                                                                                                      |
| > ①車・バイク・自転車などを活用し効率的に移動するものとし、河川管理用通路を通る等、河川の状況を十分に把握できる方法とする。                                                                          |
|                                                                                                                                                                                                      |
| ②点検により変状が確認された箇所については、特に留意して巡視する。                                                                                                                                    |
|                                                                                                                                                                                                      |
| > ③一般巡視により発見された変状が施設の機能に支障となると判断される場合には、対策を検討するために目的別巡視あるいは個別の点検を実施する。                                                            |
| >                                                                                                                                                                                                    |
| > ④許可が必要とされている行為を無許可で行っている場合や、禁止されている行為を発見した場合は、その状況を把握し、必要な措置を行う。                                                                    |
| >                                                                                                                                                                                                    |
| > ⑤広い河川敷地等を擁する大河川の重要区間においては、不法行為への対応等を確実かつ適切に行えるよう週2巡以上実施する。                                                                                 |
|                                                                                                                                                                                                      |
| また、中小河川や堤防のない掘込区間、河川敷地利用のない区間、冬期に積雪する区間等では、河川の状況や区間区分に応じて巡視の時期や頻度を設定し、点検等の機会も活用して効率的に実施することを基本とする。 |
+======================================================================================================================================================================================================+

＜推　奨＞

河川巡視を効果的に実施するため、過去の河川巡視・点検結果や被災履歴を活用することが望ましい。

車止め、標識、距離標等の施設についても目視によりあわせて巡視することが望ましい。

河川空間の利用に関する情報収集として、河川利用者数、利用形態等に関して特に把握が必要な場合には、目的別巡視や別途調査を実施することが望ましい。

休日・夜間における河川巡視を必要に応じて実施する。

河川協力団体、市民団体等と連携した巡視を行うことが望ましい。

また、UAV等活用可能な新技術について検討し、より効率的、効果的な巡視を行うことが望ましい。

**4．3出水時の河川巡視**

＜考え方＞

出水時においては、状況が時々刻々と変化し、これに対応して適切な措置を迅速に講じる必要があることから、洪水及び高潮による出水時の河川巡視は、堤防、洪水流、河道内樹木、河川管理施設等、堤内地の浸水等の状況を概括的且つ迅速に把握するために実施するとともに、水防作業状況及び内水排除状況についても把握する必要がある。

出水時の河川巡視により漏水や崩壊等の異常が発見された箇所においては、直ちに水防作業や緊急的な修繕等の適切な措置を講じる必要があるため、市町村等との情報連絡を密にしておく必要がある。あわせて、漏水や崩壊等は今後の河川の整備、維持管理に重要な情報であるため、河川カルテ等に記録する必要がある。

＜標　準＞

+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 出水時の河川巡視では、出水時に撤去すべき許可工作物について事前に把握し、河川巡視を行うことを基本とする。                                                                                                                                       |
|                                                                                                                                                                                                                                                |
| 大河川では有堤区間が多いこと等から、河川毎に、はん濫注意水位を上回る規模の洪水が発生している場合や、顕著な高潮が発生している場合等、河川巡視を実施する条件を設定し、そのうち、出水が生じている区間を対象として河川巡視を行うことを基本とする。 |
|                                                                                                                                                                                                                                                |
| 中小河川では河川の状況等を勘案して、巡視が必要とされる出水時の条件及び巡視の対象とする区間を設定することを基本とする。                                                                                                                         |
+================================================================================================================================================================================================================================================+

＜推　奨＞

河川巡視を効果的に実施するため、過去の河川巡視・点検結果や被災履歴を活用することが望ましい。

＜例　示＞

出水時の河川巡視では、RiMaDISを活用して記録を蓄積することが可能である。

また、出水時の河川巡視の手段として、全天候型のUAVが開発され、活用手法の検討が進められている。

**第5節 点検**

**5．1 出水期前、台風期、出水後等の点検**

**5．1．1 出水期前、台風期の点検**

＜考え方＞

点検とは、点検対象とする河道や一つ一つの河川管理施設の治水上の機能について異常及び変化等を発見・観察・計測等することを目的として行うものである。具体的には、堤防、護岸、水制、根固工、床止めの変状の把握、樋門、水門、堰等の損傷やゲートの開閉の支障となる異常等の把握のために行うものである。

なお、河道、堤防、護岸、施設はそれぞれ個々に点検し状態を把握するだけでなく、河川全体としてそれらの状態を把握することにより、出水への対策の必要性、優先度を総合的に判断し、より適切な維持管理を行うことが重要である。

また、河道及び河川管理施設の維持管理は、長年にわたり経験を積み重ねながら実施されてきており、点検の実施にあたっては、管理経験者を活用して技術を継承するとともに、適切に点検を実施していくことが重要である。

[＜標　準＞]{.mark}

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  河道や河川管理施設の治水上の機能について異常及び変化等を発見・観察・計測等することを目的とし、堤防、護岸、水制、根固工、床止めの変状の把握、樋門、水門、堰等の損傷やゲートの開閉の支障となる異常等の把握のために点検を行うことを基本とする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

(1)点検対象

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  河道及び河川管理施設の出水期前の点検は、その構造又は維持若しくは修繕の状況、河川管理施設の存ずる河川の状況又は地域の地形若しくは気象の状況等を勘案して、その全てを実施することを基本とする。台風期には、土堤（樋門等構造物周辺堤防含む）について点検を実施することを基本とする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

(2)点検時期と点検頻度

＜必　須＞

  ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  河川管理施設の点検は、河川管理施設の構造又は維持若しくは修繕の状況、河川の状況、河川管理施設の存する地域の気象の状況その他の状況を勘案して、適切な時期に実施するものとする。なお、河川法施行規則（昭和40年建設省令第7号）第7条の2第1項で定める河川管理施設（ダムを除く）にあっては、1年に１回以上の適切な頻度で行うものとする。
  ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

  ----------------------------------------------------------------------------------
  大河川においては、毎年、出水期前の適切な時期に河道の点検を行うことを基本とする。
  ----------------------------------------------------------------------------------

  ----------------------------------------------------------------------------------

＜推　奨＞

融雪出水が発生する地域や豪雪地域においては、融雪出水の状況や積雪により十分な点検ができなくなる場合があること等を考慮して、出水期前点検の時期を適切に設定することが望ましい。

中小河川においても、大河川に準じて、適切な時期に河道の点検を行うことが望ましい。

(3)点検方法

＜必　須＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  河道及び河川管理施設の点検は、河川管理施設の構造又は維持若しくは修繕の状況、河道の状況、河川管理施設の存ずる地域の気象の状況その他の状況を勘案して、徒歩等による目視その他適切な方法により実施するものとする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+------------------------------------------------------------------------------------------------------------------+
| 点検対象への移動は、車・バイク・自転車・徒歩など、管理用道路の状況等に応じた移動方法を選定することを基本とする。 |
|                                                                                                                  |
| 管理技術を保有する管理経験者を活用し、河川の特性に応じて適切に点検を行うことを基本とする。                       |
|                                                                                                                  |
| 大河川では、河道及び河川管理施設の点検は、点検要領等^1)^に基づいて実施することを基本とする。                     |
|                                                                                                                  |
| 中小河川の具体的な点検方法については、中小河川における点検要領^2)^に基づいて実施することを基本とする。           |
+==================================================================================================================+

＜関連通知等＞

1\) 堤防等河川管理施設及び河道の点検・評価要領：平成31年4月,
国水環保第1号,河川環境課長.

（最新版）堤防等河川管理施設及び河道の点検・評価要領：令和5年3月,
国水環保第13号,河川環境課長.

2\)
中小河川の堤防等河川管理施設及び河道の点検要領の改定について：平成29年3月28日,国水環保第43号,河川保全企画室長.

＜推　奨＞

点検を効果的に実施するため、河川カルテ、重要水防箇所に関する資料、過去の河川巡視・点検結果、被災履歴等を活用することが望ましい。

渇水時に河川水位が著しく低下している際には、平常時に水没している施設や河床等の点検を実施することが望ましい。

河道や堤防の点検においては、点群測量データを活用することが望ましい。

＜例　示＞

堤防等河川管理施設の点検においては、MMS等による長大延長構造物の変状の把握や、レーダー空洞探査による護岸背面の非破壊調査等が試行されている。

また、河道や堤防の点検においては、航空レーザーを用いた河川地形モニタリング技術や、UAVを用いた地形測量技術などの新技術の開発や活用が進められている。

(4)点検結果の保存

＜必　須＞

  -----------------------------------------------------------------------
  点検結果は、河川法施行規則第7条の2第2項に従い保存するものとする。
  -----------------------------------------------------------------------

  -----------------------------------------------------------------------

＜標　準＞

  -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  河道や、河川法施行規則第7条の2第1項で定める治水上主要な河川管理施設（ダムを除く）以外の施設に関しても、点検結果を記録するとともに、点検結果は次に点検を行うまでの期間以上保存することを基本とする。
  -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

**5．1．2 出水後等の点検**

＜考え方＞

出水後等の点検は、出水後、高潮後、津波後等の、河道及び河川管理施設の変状等を把握するために行う。特に、河道の状態把握は、河床の洗掘、堆積、河岸の侵食、樹木の倒伏状況、流木の発生状況、生物の生息、繁殖等の状況を把握し、河道計画、維持管理計画等の見直しのための重要なデータとして蓄積するために実施し、河川カルテ等に記録を行うものである。

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  出水後の点検は、氾濫注意水位を越える等、河川の状況等に応じて出水後、高潮後、津波後等出水の条件を定め、河川管理施設の被災、河道の変状等に着目し、目視により実施することを基本とする。計画高水位を上回るような規模の洪水があった場合には、堤防等の被災状況について状況に応じてさらに詳細な点検を実施することを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

急流河川では、比較的低い水位でも被災のおそれがあるため、過去の被災状況等も考慮し、氾濫注意水位又はそれに相当する水位以下の出水後でも必要に応じて点検を実施することが望ましい。あわせて、点検を効果的に実施するため、過去の河川巡視・点検結果や被災履歴を活用することが望ましい。

また、大規模災害時には、大量の土砂移動や堆積が生じ、河道等の地形や生物の生息・生育・繁殖環境が変化する。そのため、環境も含め流域スケールで動的な河川システムの把握のためモニタリングに努めることが望ましい。^1）^

＜関連通知等＞

1）「気候変動を踏まえた水災害対策のあり方について」答申:令和2年7月,社会資本整備審議会.

(1)河道の状態把握

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------
  大河川においては、状況に応じて縦横断測量等を実施し、局所的な深掘れ、堆積等が生じた場合には詳細な調査を実施することを基本とする。
  ----------------------------------------------------------------------------------------------------------------------------------

  ----------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

大河川において、大規模な河岸侵食等が生じた場合には、必要に応じて空中写真測量も実施する。

中小河川においては、必要に応じて出水後の点検及び河床変動の状況等の点検（調査）を実施する。

(2)洪水痕跡調査^1)^

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  大河川においては、洪水の水位到達高さ(洪水痕跡)が、河道計画検討上の重要なデータとなるため、洪水痕跡調査は、氾濫注意水位を越える等の顕著な規模の出水を生じ、堤防等に連続した痕跡が残存する際に実施することを基本とする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1\)
河川砂防技術基準調査編,第2章：平成26年4月1日,国水情報第52号,水管理・国土保全局長.\
（最新版）河川砂防技術基準　調査編,第2章（令和4年6月）,水管理・国土保全局長.

＜推　奨＞

越水等が発生した場合の堤内地側の痕跡も調査することが望ましい。

中小河川においては、大河川に準じて洪水痕跡調査を実施することが望ましい。

(3)河川管理施設の状態把握

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------
  大河川においては、出水を受けた堤防等の河川管理施設の変状に関する目視を行い、変状が確認された場合には詳細な調査を実施することを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------------------

  --------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

点検を効果的に実施するため、過去の河川巡視・点検結果や被災履歴を活用することが望ましい。

中小河川においては、必要に応じて出水後の点検を実施することが望ましい。

(4)堤防の変状の記録

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  大河川においては、維持すべき堤防の耐侵食、耐浸透機能に支障をきたす変状の把握を行い、河川カルテ等に適切に記録、整理することを基本とする。河川カルテについては第4章第6節による。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

中小河川においては、大河川に準じて、上記変状について適切に記録することが望ましい。

**5．2 地震後の点検**

＜考え方＞

地震後の点検は、一定規模の地震発生後には、安全に十分留意しつつ、河川管理施設等の状況等を把握するために行うものである。

＜標　準＞

+--------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 直轄河川については地震後の点検要領^1）^が定められており、大河川においてはそれにより地震の規模等を考慮して必要な点検を実施することを基本とする。                    |
|                                                                                                                                                                    |
| なお、津波後の点検の詳細は第4章第5節5.1.2による。                                                                                                                  |
|                                                                                                                                                                    |
| 水資源開発を目的として設置されたダム以外の施設については、地震後の臨時点検の詳細が定められており^2)^、地震の規模等を考慮して必要な点検を実施することを基本とする。 |
|                                                                                                                                                                    |
| 中小河川においては、大河川の考え方を参考とし、地震の規模等を考慮して、点検を実施することを基本とする。                                                             |
+====================================================================================================================================================================+

＜推　奨＞

堰、水門等で地震による被害が発生した場合、特に地域社会等への影響が懸念される施設（重要な河川管理施設等）については、迅速な状態把握が必要なため、あらかじめ対象施設を抽出の上、臨時点検（第4章第5節5.4参照）の体制の整備に努める。

＜関連通知等＞

1\)
直轄管理河川に係る地震発生時の点検について：平成21年2月27日,国河治保第6号,河川保全企画室長.

2\)
水資源開発を目的として設置されたダム以外の施設における地震発生後の臨時点検結果の報告について：平成25年7月11日,国水流第5号,水管理・国土保全局
河川環境課長.

**5．3 親水施設等の点検**

＜考え方＞

親水施設等の点検は、施設が良好に保たれ、出水時に所要の機能を維持するために適切に行う必要がある。

河川利用は、利用者自らの責任において行われることが原則であるが、親水を目的として整備した施設については、河川管理者としての施設点検が必要である。点検の対象は、高水敷や低水護岸部の陸上部（水際を含む）、水面部に関する以下の区域等である。

・河川に親しむ利用を目的として施設を設置している区域

・河川に親しむ利用が日常的に見られる区域

・潮位等により日常的に水位の変動に影響を受ける区域

・ボート及びカヌー等により利用頻度が多く日常的に利用されている区域

・遊泳場、キャンプ地、水辺の楽校等、日常的に水遊びに利用されている区域

親水施設等の危険防止措置に関しては、基本的には次の6つの点が重要であり、維持管理にあたっても十分留意する必要がある。

> ①立地：原則として、水衝部等の川の状態が不安定な箇所や水深・流速が大きい場所等は避けて設置すること。
>
> ②地域ニーズの把握：施設の使用方法等の地域ニーズを把握し、それを安全対策に生かすこと。
>
> ③河川利用者への情報提供：標識や表示板により、河川の危険性に関する適切な情報を河川利用者へ適確に提供すること。その際、標識等が必要とされる背景と目的に応じた具体的な内容とし、また見やすく、わかりやすい内容とすること。
>
> ④施設対策：滑りにくい素材を使用するなど構造に配慮すること。また、洪水の流下、水防活動等の支障とならない範囲で、以下のような場合には河川利用者の安全性を確保するための対策を講じること。

・新たな転落の危険性が生じた箇所

・堰・水門等の工作物と親水護岸との境界部

・地域住民から、柵等の設置の要望があり、必要と認められる箇所

> ・危険判断能力を有していても、一旦転落すると極めて危険な状態に陥る可能性があり、高齢者、障害者等の方々が利用されている箇所

・危険判断能力や危険回避能力が十分でない幼児等の利用が多く見込まれる箇所

・上記のほか、危険な状態と認められる箇所

> ⑤安全性の維持：河川巡視により親水施設等の状況、標識等の破損状況等を把握するとともに、必要に応じて改善措置を講じること。また、設置後、必要に応じて、前面の水深の変化を把握するなど河川の状態を把握すること。
>
> ⑥教育・啓発：地域の保護者や子供に利用についての教育、指導を行うこと。

なお、長期間安全に利用されている既存施設については、その安全な利用方法が地域の中で確立されていることから、その利用方法を把握し、教育・啓発の取組に反映する必要がある。

＜標　準＞

+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 河川利用者が特に多い時期を考慮して、安全利用点検に関する実施要領^1)^等に基づいて点検を実施することを基本とする。                                                                                           |
|                                                                                                                                                                                                            |
| 許可工作物及び占用区域が対象区域と隣接している場合において、当該許可工作物管理者及び占用者と一体的に点検を実施する必要がある場合には、あらかじめ他の管理者と調整し、共同で点検を実施することを基本とする。 |
+============================================================================================================================================================================================================+

＜推　奨＞

点検の実施にあたっては、幅広い情報を得るため、河川を利用する地域住民や河川協力団体、市民団体、学識者等と共に点検を実施することが望ましい。

＜関連通知等＞

1\)
河川(水面を含む)における安全利用点検の実施について(改訂)：平成21年3月13日,国河環第106号,国河治第146号,河川環境課長,治水課長.

**5．4 機械設備を伴う河川管理施設の点検**

＜考え方＞

機械設備を伴う河川管理施設（堰、水門・樋門、排水機場等）の点検は、信頼性確保、機能維持のため、コンクリート構造部分、機械設備及び電気通信施設に応じて適切な手法等により定期点検、運転時点検、及び臨時点検を行う必要がある。

＜標　準＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| (1)コンクリート構造部について                                                                                                                                                                                                                            |
|                                                                                                                                                                                                                                                          |
| 大河川における河川管理施設のコンクリート構造部については、コンクリート標準示方書^1)^により、適切に点検、管理を行うことを基本とする。                                                                                                                     |
|                                                                                                                                                                                                                                                          |
| 中小河川においても、コンクリート標準示方書^1)^を参考として、当該設備等の重要度や規模等も考慮して、効果的・効率的に点検を実施することを基本とする。                                                                                                       |
|                                                                                                                                                                                                                                                          |
| (2)機械設備について                                                                                                                                                                                                                                      |
|                                                                                                                                                                                                                                                          |
| 大河川における堰、水門・樋門、排水機場等の機械設備の点検については河川用ゲート・ポンプ設備の点検・整備等に関するマニュアル等^2)3)4)5)6)^により、設備の信頼性確保、機能保全を目的として、定期点検、運転時点検、臨時点検について実施することを基本とする。 |
|                                                                                                                                                                                                                                                          |
| ①定期点検                                                                                                                                                                                                                                                |
|                                                                                                                                                                                                                                                          |
| ・ゲート設備                                                                                                                                                                                                                                             |
|                                                                                                                                                                                                                                                          |
| > 定期点検は、一般に機器の整備状況、作動確認、偶発的な損傷の発見のため、出水期には毎月1回管理運転を含む月点検を行い、非出水時には2～3ヶ月に1回実施し、年1回詳細な年点検を行って記録作成を行うことを基本とする。                                          |
|                                                                                                                                                                                                                                                          |
| なお、法令に係る点検も含めて行うことを基本とする。                                                                                                                                                                                                       |
|                                                                                                                                                                                                                                                          |
| ・ポンプ設備                                                                                                                                                                                                                                             |
|                                                                                                                                                                                                                                                          |
| > 定期点検は、設備の損傷ないし異常の発見、機能良否等の確認のために出水期には月1回、非出水期には2～3ヶ月に1回実施し、年1回詳細な年点検を行って記録作成を行うことを基本とする。なお、法令に係る点検も含めて行うことを基本とする。                          |
| >                                                                                                                                                                                                                                                        |
| > 定期点検は原則として管理運転点検とし、設備の運転機能の確認、運転を通じたシステム全体の故障発見、機能維持を目的とすることを基本とする。管理運転ができない場合には、目視点検として設備条件に適合した内容で実施することを基本とする。                     |
|                                                                                                                                                                                                                                                          |
| 年点検は、設備を構成する装置、機器の健全度の把握、システム全体の機能確認、劣化・損傷等の発見を目的として、設備の稼働形態に応じて適切な時期に実施することを基本とする。                                                                                   |
|                                                                                                                                                                                                                                                          |
| ②運転時点検                                                                                                                                                                                                                                              |
|                                                                                                                                                                                                                                                          |
| > 運転時点検は、設備の実稼働時において始動条件、運転中の状態把握、次回の運転に支障がないことの確認や異常の徴候の早期発見を目的として、目視、指触、聴覚等による点検を運転操作毎に実施することを基本とする。                                               |
|                                                                                                                                                                                                                                                          |
| ③臨時点検                                                                                                                                                                                                                                                |
|                                                                                                                                                                                                                                                          |
| > 出水、地震、落雷、火災、暴風等が発生した場合に設備への外的要因による異常、損傷の有無の確認を目的とし、必要に応じて点検を実施することを基本とする。                                                                                                     |
|                                                                                                                                                                                                                                                          |
| ④点検結果の評価                                                                                                                                                                                                                                          |
|                                                                                                                                                                                                                                                          |
| > 維持管理を効率的・効果的に実施するため、点検結果を評価するに当たって、当該設備の社会的な影響度、機器・装置の診断等に基づく健全度等の整理を行うことを基本とする。具体的な評価方法・手順等については関連するマニュアル等による。                         |
|                                                                                                                                                                                                                                                          |
| また、ゲート設備、ポンプ設備等の塗装については、機械工事塗装要領（案）・同解説^7)^による。                                                                                                                                                               |
|                                                                                                                                                                                                                                                          |
| 中小河川においても、河川用ゲート・ポンプ設備の点検・整備等に関するマニュアル等^2)3)4)5)6)^を参考として、当該設備等の重要度や規模等も考慮して、効果的・効率的に点検を実施することを基本とする。                                                           |
|                                                                                                                                                                                                                                                          |
| (3)電気通信施設について                                                                                                                                                                                                                                  |
|                                                                                                                                                                                                                                                          |
| 電気通信施設については、電気通信施設点検基準（案）^8)^により、以下の事項に留意して点検することを基本とする。                                                                                                                                             |
|                                                                                                                                                                                                                                                          |
| > ・設備・機器の外観、損傷、異常音、異臭、発熱、発煙等の有無及び電気・制御室内の状況                                                                                                                                                                     |
|                                                                                                                                                                                                                                                          |
| ・表示ランプの表示状態                                                                                                                                                                                                                                   |
|                                                                                                                                                                                                                                                          |
| ・計測器等の指示値が正常値内であること                                                                                                                                                                                                                   |
|                                                                                                                                                                                                                                                          |
| ゲートの運転・操作時においては、河川管理用カメラ、その他の監視機器並びに遠方操作盤・監視盤等により適切に状態把握を行うことを基本とする。                                                                                                                 |
|                                                                                                                                                                                                                                                          |
| 中小河川においても、電気通信施設点検基準（案）^8)^を参考として、当該設備等の重要度や規模等も考慮して、効果的・効率的に点検を実施することを基本とする。                                                                                                   |
+==========================================================================================================================================================================================================================================================+

＜推　奨＞

計測機器の導入や非出水期の点検の合理化等、効率的な点検とするよう努める。

＜関連通知等＞

1\)
コンクリート標準示方書［維持管理編］：土木学会コンクリート委員会コンクリート標準示方書改訂小委員会,土木学会,2007年制定.

2\)
河川用ゲート・ポンプ設備点検・整備・更新検討マニュアル（案）の改定について：平成27年3月31日,国総施安第11号,国水環保第8号,総合政策局公共事業企画調整課施工安全企画室長,水管理・国土保全局河川環境課河川保全企画室長.

3\)
ゲート点検・整備要領（案）：ゲート点検・整備要領検討委員会編,(社)ダム・堰施設技術協会,平成17年1月.

4\)
揚排水機場設備点検・整備指針（案）の制定について：平成20年6月27日,国技電第56号,国総施第111号,国河治第151号,技術調査課長,建設施工企画課長,治水課長.

5\)
ダム・堰施設技術基準（案）の一部改定について：平成28年3月31日,国技電第72号,国総公第80号,国水環第140号,国水治第142号,大臣官房技術調査課長,総合政策局公共事業企画調整課長，水管理・国土保全局河川環境課長.

6\)
揚排水ポンプ設備技術基準の改定について：平成26年3月31日,国技電第59号,国総公第146号,国水環第14号,国水治第189号.

7\)
機械工事塗装要領（案）・同解説：国土交通省総合政策局建設施工企画課,平成22年4

　月.

8\) 電気通信施設点検基準（案）：令和元年12月23日,国技電第49号.

**5．5 許可工作物の点検**

＜考え方＞

許可工作物についても、河川管理施設と同等の治水上の安全性を確保することが必要であり、適切な時期に施設管理者により点検がなされる必要がある。

河川管理施設等を良好に保つよう維持、修繕することが義務づけられていることを踏まえ、河川巡視の結果等により施設管理者へ点検の指導等を適切に行うものである。

なお、必要に応じて施設管理者に立ち会いを求めて点検の結果を確認する等により、適確な点検がなされるように指導等を行うものである。

＜標　準＞

+-------------------------------------------------------------------------------------------------------------------------------------------+
| 施設管理者が出水期前等の適切な時期に、以下のような項目について必要な点検を実施することを基本とする。                                      |
|                                                                                                                                           |
| > ①施設の状況：本体、取付護岸（根固を含む）、高水敷保護工、吸水槽、吐出槽、除塵機　等                                                     |
|                                                                                                                                           |
| ②作動状況：ゲート、ポンプ、警報装置                                                                                                       |
|                                                                                                                                           |
| ③施設周辺状況：工作物下流側の河床洗掘、堤防の空洞化                                                                                       |
|                                                                                                                                           |
| > ④管理体制の状況（操作要領等に照らし合わせて、出水時及び平水時における操作人員の配置計画は適切か、出水時等の通報連絡体制は適切かを確認） |
|                                                                                                                                           |
| 河川管理施設に求められる水準と比較し施設の安全性が不十分と判断される場合には、早急に改善するよう指導監督を実施することを基本とする。      |
|                                                                                                                                           |
| また、出水時に河川区域外に撤去すべき施設が存在する場合は、点検時に撤去計画の確認を行う。                                                  |
|                                                                                                                                           |
| 日常にあっても、河川巡視により許可工作物の状況を把握し、変状を確認した場合には、施設管理者に臨時の点検実施等を指導することを基本とする。  |
+===========================================================================================================================================+

＜推　奨＞

施設管理者による撤去の演習を実施する際は、河川管理者が立ち会うことが望ましい。

**第6節 河川カルテ**

＜考え方＞

点検、あるいは河川巡視によって得られた河道の変状あるいは河川管理施設の損傷等のデータを蓄積し、日常より把握している状態変化の履歴をいつでも見られるようにしておくことは、自然公物である河川の維持管理上の重点箇所を抽出する等、適切な河川管理を行う上で重要である。河川カルテは、そのような目的のために、点検や補修等の対策の履歴を保存していくものであり、河道や施設の状態を適切に評価し、迅速な改善を実施し、河川維持管理のＰＤＣＡサイクルを実施するための重要な基礎資料となる。

河川カルテは、点検、補修、災害復旧、及び河川改修等に関する必要な情報を記載するものであり、作成要領^1)^等に基づいて作成し、常に新しい情報を追加するとともに、毎年その内容を確認することが重要である。なお、河川カルテは河川維持管理の実施に必要なデータを集積するものであり、法第12条第1項に基づき作成される台帳に基づき作成されるものである。

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  大河川においては、河川維持管理の履歴は河川カルテとして保存し、河川管理の基礎資料とする。河川カルテには点検、補修等の対策等の河川維持管理における実施事項に加え、河川改修等の河川工事、災害及びその対策等、河川管理の履歴として記録が必要な事項について、効率的にデータ管理が行えるようデータベース化して記録、蓄積することを基本とする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

河川カルテに取得したデータは、膨大なものとなるため、効率的にデータ管理が行えるよう、データベース化して蓄積するよう努める。

中小河川においても主要な区間、重要な施設については河川カルテを作成することが望ましい。

＜例　示＞

河川カルテの電子的なデータベース化している事例として河川維持管理データベースシステム（RiMaDIS等）が挙げられる。

＜関連通知等＞

1\)
河川カルテの作成要領について(一部改定)：平成24年5月17日,国水環保第2号,河川保全企画室長.

**第7節 河川の状態把握の分析、評価**

＜考え方＞

河川維持管理は、経験に基づく知見の集積に強く依存しており、これまでの河川維持管理の中で積み重ねられてきた広範な経験や、河川に関する専門的な知識、場合によっては最新の研究成果等を踏まえ、対応することが必要である。

また、河川維持管理計画に基づく維持管理の実施を通して、個々の河川の具体的な維持管理の実施内容を充実させるためには、河川毎の状況に応じて解明すべき課題は何かを明確にした上で、それらを実施する中で順次分析していくことも重要である。そこで、河川及び河川管理施設の状態を評価するにあたり、学識経験者や専門家から技術的助言が得られるような体制の整備についても検討することが重要である（第1章第2節、第2章第2節2.1参照）。

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------
  補修等の維持管理対策を適切に実施するため、河川巡視、点検による河川の状態把握の結果を分析、評価することを基本とする。
  ----------------------------------------------------------------------------------------------------------------------

  ----------------------------------------------------------------------------------------------------------------------

＜推　奨＞

評価内容に応じて適宜河川維持管理計画等に反映することが望ましい。

**第5章 河道の流下能力の維持管理のための対策**

**第1節 河道の流下能力の維持・河床低下対策**

＜考え方＞

河道は水と土砂、植生の相互作用で形成されており、そもそも自然河川は安定しているものではなく、出水等により比較的容易に変化するため、河道の維持管理を安定的に行うことは困難である。土砂動態だけに着目しても、上流からの土砂供給の状況によって河床の堆積・侵食傾向は異なる。また、過剰な砂利採取は直接的に河床低下の要因となる。河道は種々の要因で変化することから、適切に河道の流下能力を維持するとともに、河川管理上の支障とならないよう河床低下対策を行うことが必要である。

河道の変化に伴う流下能力の低下に対処するには、河川整備計画等の計画の中で変化を許容した河道計画を行う、あるいは河川整備計画上許容できない河道の変化を維持管理により改善するという考え方がある。いずれにしても、河川の河床変動の特性や、河床掘削等に伴う河川の応答特性等を十分に考慮しながら、河道計画の内容を踏まえて河川維持管理として河道の流下能力をどのように維持するか検討することが重要である。

河道計画では、河川改修の経済性だけでなく、改修後の河川維持管理を含めた総合的な経済性から見て妥当な流下断面としていくことが重要である。また、維持管理での対策は、目先の対処療法とならないよう、河道変化の原因を十分に考慮して、当該河道区間の河道特性に適した方法とするものである。河道変化には直接流下能力に影響する樹木の繁茂も十分に考慮する必要がある。なお、砂州によって形成された瀬と淵の保全や水際部の環境の改善等、当該区間の河川環境の保全と整備にも十分考慮する必要がある。

河川管理上問題を生じさせる過剰な砂利採取は適切に規制する必要がある。その一方で、河積拡大や堆積土砂対策と資源の有効利用を両立させることができることから、河道計画あるいは河川維持管理計画等の検討にあたっては、砂利採取との十分な調整に努めることが重要である。

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  目標とする河道の流下能力を維持するため、定期的又は出水後に行う縦横断測量あるいは点検等の結果を踏まえ、流下能力の変化、施設の安全性に影響を及ぼすような河床の変化、樹木の繁茂状況を把握し、河川管理上の支障となる場合は適切な処置を講じることを基本とする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

(1)河道の堆積土砂対策について

＜考え方＞

出水等に起因し、土砂堆積による洪水流下の阻害、砂州の発達による堤防前面の河岸洗掘等、河道の土砂堆積により治水上の支障を生じる場合がある。

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  大河川においては、定期的又は出水後の縦横断測量^1)^結果により、変動の状況及び傾向を把握し、一連区間の河道の流下能力を維持するよう、河川環境の保全に留意しながら河床掘削等の適切な対策を行うことを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

勾配の急変箇所等、河床の上昇が生じやすいと想定される箇所をあらかじめ把握し、重点的に監視しつつ、予期せぬ河床変動も起こり得ることに留意し、河床変化の調査を積み重ねて河道計画等に反映していくことが望ましい。

ここで、河道形状の変化を把握するために、ALB、UAV等から得られる点群測量データを活用し、土砂の堆積・侵食量等を経年的・定量的にモニタリングを行うことが望ましい。^2)^

中小河川においては、一連区間の河道の流下能力を維持するよう、大河川に準じて適切な対策を行うことが望ましい。

(2)河床低下・洗掘対策について

＜考え方＞

護岸や橋梁の基礎としての河道の維持管理については、継続的な河床低下の状況を把握するとともに、深掘れやその原因となる流れの状態を把握して、適切な対策を講じる必要がある。河川の特性によっては、出水に伴う局所洗掘により護岸や橋梁等の基礎が沈下、陥没する等のおそれがあるため、そのような場合には局所洗掘の状況を調査することも必要である。

河床低下には河道の全体的な低下と局所的な洗掘があり、それぞれ対策の考え方や工法が変わるので留意する必要がある。河床が全体的に低下したために基礎が露出した護岸では、根固工の追加的な対策では不十分な場合がある。また、沖積堆積層が侵食されて土丹層等の洪積層が露出すると従来の対策が効果を持たない場合もある。それらの場合等には河道計画の見直しについての検討が必要である。

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  上流域からの土砂流出の変化等に伴い、護岸や構造物基礎周辺の河床が低下すると災害の原因となるので、早期発見に努めるとともに、河川管理上の支障となる場合には適切な対策を行うことを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1\)
河川砂防技術基準調査編,第4章,第22章：平成26年4月1日,国水情報第52号,水管理・国土保全局長.

（最新版）河川砂防技術基準調査編,第4章（平成26年4月）,第22章（令和4年6月）,水管理・国土保全局長.

2\)
「気候変動を踏まえた水災害対策のあり方について」答申：令和2年7月,社会資本整備審議会.

**第2節 河岸の対策**

＜考え方＞

自然の河岸は、出水に伴う河床変動により長年にわたり変化するものであるが、堤防前面にある高水敷等は、洪水による堤防堤脚部の侵食防止に重要な役割を果たすため、その観点からは常にある程度の幅が必要である。洪水によりひとたび侵食が始まると、急激に侵食が進むことがあるため、大河川においては、堤防の防護上必要とされる高水敷等の最低限の幅で規定される位置を堤防防護ラインとして定めている。また、低水路河岸の侵食を防止するために必要に応じて低水路河岸管理ラインを定めている^1)^。このため、河岸の変状については出水後の点検あるいは河川巡視等によって早期発見に努めることが重要である。

侵食防止対策として、護岸、根固め、水制等が施工されるが、侵食された河岸を必要以上に強固にすると、対岸の洗掘や侵食の原因となることもあるので、河川の特性、低水路河岸管理ライン、河道の変遷など河川全体の状況に応じて慎重に整備の必要性や整備範囲、工法を決定する。

＜標　準＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 堤防防護の支障となる河岸の変状については、河川環境に配慮しつつ適切な措置を講じることを基本とする。                                                                                                                                           |
|                                                                                                                                                                                                                                              |
| 侵食防止対策の検討にあたっては、侵食の程度のほか河川敷地（高水敷）の利用状況や堤防の侵食対策の有無等を考慮して検討するものとし、河岸は河川の自然環境上重要な場でもあることから、生物の生息・生育・繁殖環境にも十分配慮することを基本とする。 |
+==============================================================================================================================================================================================================================================+

＜関連通知等＞

1\)
河川砂防技術基準計画編,施設配置等計画編第2章：平成30年3月30日,国水情第69号,河川局長.

（最新版）河川砂防技術基準計画編,施設配置等計画編第2章：令和4年6月,水管理・国土保全局

2\)
河川砂防技術基準計画編技術資料,施設配置等計画編第2章：平成30年3月30日,
水管理・国土保全局河川計画課河川情報企画室長事務連絡.

（最新版）河川砂防技術基準計画編技術資料,施設配置等計画編第2章：令和4年6月,
水管理・国土保全局河川計画課河川情報企画室長事務連絡.

**第3節 樹木の対策**

＜考え方＞

河道内の樹木は、洪水の流勢の緩和等の治水機能、河川の生態系の保全や良好な景観の形成等の重要な機能を有することがある。一方、洪水流下阻害による流下能力の低下、樹木群と堤防間の流速を増加させることによる堤防の損傷、あるいは洪水による樹木の流木化を生じさせることがある。樹木群が土砂の堆積を促進し、河積をさらに狭めてしまう場合もある。また樹木の根は、堤防、護岸等の河川管理施設に損傷を与えることがある。これらのことから、点検あるいは河川巡視等による状態把握に基づいて、適切に伐開等の対策を行う必要がある。

対策の検討にあたっては、対象とする樹木群の過去からの繁茂状況の変化に留意するとよい。

伐開にあたって一部の樹木群を存置する場合には、まとまった範囲を存置する等により洪水時の倒伏・流出のおそれがないよう十分配慮する必要がある。ただし、部分的な伐開の範囲によっては、堤防沿いの流速の増大や、残存樹木の流出を生じることが懸念されるので留意する必要がある。

＜標　準＞

+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 大河川における樹木の対策は、治水、管理、環境面の機能を維持するよう、以下を基本とする。                                                                                                          |
|                                                                                                                                                                                                 |
| > ①治水上の支障が生じる河道内の樹木を伐開する。その際には樹木が阻害する流下能力など治水機能への影響や、観測・巡視などの管理機能、生態系・景観などの環境機能への影響を十分踏まえた上で対策する。 |
| >                                                                                                                                                                                               |
| > ②河川区域内において行う樹木の伐開については、樹木の植樹・伐採に関する基準^1)^による。                                                                                                         |
| >                                                                                                                                                                                               |
| > ③樹木の経年変化も踏まえて予め伐開計画を作成しておくなど、計画的な樹木対策を行う。伐開計画には、樹木の伐開時期、伐開範囲、伐開手法等を記載する。                                               |
|                                                                                                                                                                                                 |
| ④伐開した樹木については、再繁茂抑制措置を講じる。                                                                                                                                               |
|                                                                                                                                                                                                 |
| ⑤堤防等の河川管理施設に対して根が悪影響を与えていると認められる樹木は、除去する等の対策を行う。                                                                                                 |
+=================================================================================================================================================================================================+

＜推　奨＞

リサイクル及びコスト縮減と気候変動の緩和の観点から、地域や関係機関による伐木の有効利用が促進されるよう、廃棄物やリサイクルに係る関連法令等にも留意しつつ、公募型樹木等採取の取組等に積極的に努める^2)^。また、バイオマス発電燃料として再生可能エネルギー発電に利用する取組を促進すべきである。^3)^

ここで、河道内の樹林の進行の変化を把握するために、ALB、UAV等から得られる点群測量データを活用し、樹木繁茂量や樹高の変化を経年的・定量的にモニタリングを行うことが望ましい。

中小河川においては、河川の重要度や繁茂状況を考慮して、大河川に準じて樹木の伐開等の維持管理を行うことが望ましい。

＜関連通知等＞

1\)
河川区域内における樹木の伐採・植樹基準：平成10年6月19日,建河治発第44号,治水課長.

2\)
河川法25条を適用した官民連携による公募型樹木等採取試行ガイドラインの改定について：平成29年4月11日,事務連絡.

3\)
「気候変動を踏まえた水災害対策のあり方について」答申：令和2年7月,社会資本整備審議会.

**第4節 河口部の対策**

＜考え方＞

河口閉塞については、土砂の除去による維持管理対策では再度閉塞する場合も多く、河道計画の見直しや他の工法（例：導流堤、離岸堤）との併用についても必要に応じて検討することが重要である。河口部の水理現象は非常に複雑であり、沿岸流、潮汐等の海域の諸現象と密接不可分の関係にあり、広範囲の汀線の変化、波浪、漂砂、河川の流送土砂等の調査^1)^を行う必要がある。

＜標　準＞

+--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 河口閉塞が、河川管理上の支障となる場合には、塩水遡上の影響等を考慮し、土砂の除去等の適切な措置を講じることを基本とする。                                                                               |
|                                                                                                                                                                                                        |
| また、河口閉塞が、河口部における流水の疎通や水質環境等に支障を生じている場合は、塩水遡上や周辺海岸の状態も考慮しつつ、土砂の除去による流路の確保や砂州高の低下等の適切な措置を講じることを基本とする。 |
|                                                                                                                                                                                                        |
| 河口部は河川の自然環境上重要な場でもあることから、生物の生息・生育・繁殖環境にも十分配慮することを基本とする。                                                                                         |
+========================================================================================================================================================================================================+

＜関連通知等＞

1\)
河川砂防技術基準調査編,第4章：平成26年4月1日,国水情報第52号,水管理・国土保全局長.

**第6章 施設の維持及び修繕・対策**

**第1節 河川管理施設一般**

**1．1 土木施設**

＜考え方＞

護岸、あるいは堰、水門等の河川管理施設等の土木施設部分が被災すると、これが原因となって本体周辺の堤防や河岸が被災し、大きな災害に至ることがある。このため土木施設の維持及び修繕・対策は、河川管理施設等が良好状態に保たれ、出水時に所要の機能を維持するために実施するものである。

＜必　須＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  点検その他の方法により河川管理施設等の土木施設部分の損傷、腐食、その他の劣化その他の異状があることを把握したときは、河川管理施設等の効率的な維持及び修繕が図られるよう、必要な措置を講じるものとする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 土木施設の維持及び修繕については以下を基本とする。                                                                                                                                                                                                                                                   |
|                                                                                                                                                                                                                                                                                                      |
| > ①点検等によりクラック、コンクリートの劣化、沈下等の変状を発見し、各々の施設が維持すべき機能が低下するおそれがみられた場合には、継続的に状態把握(点検)を行う等により原因を調査する。                                                                                                                |
| >                                                                                                                                                                                                                                                                                                    |
| > ②当該河川管理施設等及び同種の構造物の過去の被災事例や異常発生事例を参考として、点検等の調査による変状の状態から施設の機能の維持に重大な支障が生じると判断した場合には必要な対策を行う。                                                                                                            |
|                                                                                                                                                                                                                                                                                                      |
| また、対策にあたっては、長寿命化対策の検討等により、長期的なコストに考慮するとともに、施設を更新する際には、施設の位置や周辺環境を勘案し河川本来の生態系や多様な景観等の水辺環境を保全・創出することや、地域の暮らし、歴史、文化との調和に配慮するなど、質的な向上について検討することを基本とする。 |
+======================================================================================================================================================================================================================================================================================================+

**1．2 機械設備・電気通信施設**

＜考え方＞

河川管理施設の機械設備・電気通信施設については、設備や施設等が良好に保たれ、出水時に所要の機能を維持するよう長寿命化計画及び定期点検の結果等に基づいて適切に維持管理するものである。

＜必　須＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  点検その他の方法により河川管理施設等の機械設備・電気通信施設の損傷、その他の劣化その他の異状があることを把握したときは、河川管理施設等の効率的な維持及び修繕が図られるよう、必要な措置を講じるものとする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+-------------------------------------------------------------------------------------------------------------------------------------------------------+
| 機械設備・電気通信施設については、第4章第5節5.4に示す定期点検の結果等に基づいて、適切な状態把握(状態監視)の継続及び整備・更新を行うことを基本とする。 |
|                                                                                                                                                       |
| なお、点検・整備・更新の結果は適切に記録・保存し、経時変化を把握するための基礎資料として活用することを基本とする。                                    |
+=======================================================================================================================================================+

(1)機械設備について

＜考え方＞

機械設備については、設備等が良好に保たれ、出水時に所要の機能を維持するよう長寿命化計画及び定期点検の結果等に基づいて適切に維持管理するものである。

機械設備の整備・更新に関しては、機能の重要性等に鑑みて行っていく必要がある。例えばゲートに関しては、堤防としての機能（出水時の止水機能）、あるいは取水のための機能を確保する必要があり、危機管理を踏まえた維持管理についての検討も必要である。

また、設備の設置目的、装置・機器等の特性、設置条件、稼働形態、機能の適合性等を考慮して内容の最適化に努め、かつ効果的に予防保全（設備、装置、機器、部品が必要な機能を発揮できる状態に維持するための保全）と事後保全（故障した設備、装置、機器、部品の機能を復旧するための保全）を使い分け、戦略的に実施することが重要である。

＜標　準＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 機械設備は、点検及び診断の結果による劣化状況、機器の重要性等を勘案し、効果的・効率的に維持管理することを基本とする。                                                                                                                                                                         |
|                                                                                                                                                                                                                                                                                              |
| 大河川における機械設備のうち、ゲート設備、ポンプ設備等の整備・更新は、河川用ゲート・ポンプ設備の点検・整備等に関するマニュアル等^1)2)3)4)^に基づいて行うことを基本とする。また、ゲート設備、ポンプ設備等の塗装については、機械工事塗装要領（案）・同解説^5)^に基づいて行うことを基本とする。 |
|                                                                                                                                                                                                                                                                                              |
| 中小河川における大規模または重要度の高いゲート設備、ポンプ設備等の整備・更新及び塗装は、大河川と同様に行うことを基本とする。                                                                                                                                                                 |
+==============================================================================================================================================================================================================================================================================================+

(2)電気通信施設について

＜考え方＞

電気通信施設は、構成する機器毎の特性に応じて、適切に点検を行い、機能を維持する必要がある。

河川の電気通信施設には、テレメータ設備、レーダ雨量計設備、光ファイバ設備、多重無線設備、移動通信設備、衛星通信設備、河川情報設備、河川管理用カメラ、これらの監視設備等がある。

＜標　準＞

+--------------------------------------------------------------------------------------------------------------------------+
| 電気通信施設は、点検及び診断の結果による劣化状況、施設の重要性等を勘案し、効果的・効率的に維持管理することを基本とする。 |
|                                                                                                                          |
| 電気通信施設の整備・更新は、点検、診断等に関する基準等^7)8)9)10)^に基づいて行うことを基本とする。                        |
+==========================================================================================================================+

＜推　奨＞

電気通信施設は、点検・整備・更新にあたって長寿命化やライフサイクルコストの縮減の検討を行い、戦略的に電気通信施設の維持管理を行うように努める。

＜関連通知等＞

1\)
河川用ゲート・ポンプ設備点検・整備・更新検討マニュアル（案）の改定について：平成27年3月31日,国総施安第11号,国水環保第8号,総合政策局公共事業企画調整課施工安全企画室長,水管理・国土保全局河川環境課河川保全企画室長.

2\)
ゲート点検・整備要領（案）：ゲート点検・整備要領検討委員会編,(社)ダム・堰施設技術協会,平成17年1月.

3\)
揚排水機場設備点検・整備指針（案）の制定について：平成20年6月27日,国技電第56号,国総施第111号,国河治第151号,技術調査課長,建設施工企画課長,治水課長.

4\)
ダム・堰施設技術基準（案）の一部改定について：平成28年3月31日,国技電第72号,国総公第80号,国水環第140号、国水治第142号,大臣官房技術調査課長,総合政策局公共事業企画調整課長，水管理・国土保全局河川環境課長.

5\) 堤防等河川管理施設及び河道の点検・評価要領：平成31年4月,
国水環保第1号,河川環境課長.\
（最新版）堤防等河川管理施設及び河道の点検・評価要領：令和5年3月,
国水環保第13号,河川環境課長.

6\)
中小河川の堤防等河川管理施設及び河道の点検要領の改定について：平成29年3月28日,国水環保第43号河川保全企画室長.\
（最新版）中小河川の堤防等河川管理施設及び河道の点検要領の改定について：令和6年3月27日,国水環保第5号,河川保全企画室長.

7\)
機械工事塗装要領（案）・同解説：国土交通省総合政策局建設施工企画課,平成22年4月

8\) 電気通信施設点検基準（案）：令和元年12月23日,国技電第49号.

9\)
電気通信施設維持管理計画指針（案）：国土交通省大臣官房技術調査課電気通信室,平成30年3月.

10\)
電気通信施設維持管理計画作成の手引き(案)：国土交通省大臣官房技術調査課電気通信室、平成30年3月.

**第2節 堤防**

**2．1 土堤**

**2．1．1 堤体**

＜考え方＞

堤防の高さ・形状は、一連区間の維持すべき河道の流下能力を確保するための基本であり、適切に堤防の高さ・形状を維持するものである。定期的な測量結果をもとにその変化を把握するとともに、現状で必要な形状が確保されていない区間については、それを踏まえて維持管理するものである。河川巡視や点検、縦横断測量等により、沈下、法崩れ、陥没等の変状が認められた場合は、状況に応じて補修等の必要な措置を講じるものである。

堤防は、一般に、かさ上げ、拡幅、補修等の工事が容易であること、これらの工費が比較的低廉であること、構造物としての劣化現象が起きにくいこと、基礎地盤と一体化してなじみやすいこと等から、土堤を原則としている。ただし、土堤は、長時間の浸透により強度が低下すること、流水により洗掘されやすいこと、越流に対して弱いこと等の欠点も有しており、それらの構造上の特性を十分に理解する必要がある。

堤防法面は、降雨及び流水等による侵食又は崩れに対して安全となるように芝等によって覆われるものであり、芝等で覆われた法面の耐侵食性の評価が重要である。

堤体のパイピングが生じやすい箇所として、旧河道や落堀等、基礎地盤に砂礫等による透水層が存在する箇所等がある。そのほか、樋門・樋管等の堤防横断施設近傍、もぐら等の穿孔動物の生息箇所等も漏水の可能性がある箇所となる。パイピングについては、これらに留意した点検あるいは被災原因の把握が重要となる。

堤防の状態把握、分析評価、対策を長期間にわたり繰り返し、得られた知見を蓄積することにより、長大な河川堤防の安全性・信頼性を維持し高めていくことが重要である。

[＜標　準＞]{.mark}

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  堤体は定期的な測量結果をもとにその変化を把握するとともに、現状で必要な形状が確保されていない区間については、それを踏まえて維持管理することを基本とする。河川巡視や点検、縦横断測量等により、沈下、法崩れ、陥没等の変状が認められた場合は、状況に応じて補修等の必要な措置を講じることを基本とする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

(1)点検等による状態把握と機能の維持について

＜標　準＞

+--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 堤防の機能維持にとって点検等による状態把握は特に重要であり、大河川においては、必要な点検等による状態把握、対策を点検要領^1)2)^等に基づいて行うことを基本とする。                                                                                                                                                                                 |
|                                                                                                                                                                                                                                                                                                                                                  |
| 堤防にクラック、陥没、わだち、裸地化、湿潤状態等の変状が見られた場合には、点検等による当該箇所の状態把握を継続するとともに、状況に応じて原因調査を行うことを基本とする。調査結果により維持すべき堤防の耐侵食、耐浸透機能に支障が生じると判断される場合には必要な対策を実施し、堤防の治水機能が維持されるよう堤体を維持管理することを基本とする。 |
|                                                                                                                                                                                                                                                                                                                                                  |
| 堤防天端あるいは小段に道路を併設する場合には、堤体は道路盛土としての性格を有することから、道路整備の位置や範囲に応じて法第17条第1項の兼用工作物となるため、兼用工作物とした堤防についても、堤防の機能を適切に維持するよう、道路管理者との管理協定等に基づいて適切に維持管理を行うことを基本とする。                                              |
|                                                                                                                                                                                                                                                                                                                                                  |
| 状態把握の結果の分析、評価あるいは補修の技術等には確立された手法等がない場合が多いため、大河川では、学識者等の助言を得られるように体制の整備等を行うことを基本とする。                                                                                                                                                                           |
|                                                                                                                                                                                                                                                                                                                                                  |
| 中小河川の堤防については、中小河川における点検要領（案）^3)^等に基づいて適切な点検を行い、必要な対策を実施することを基本とする。                                                                                                                                                                                                                 |
+==================================================================================================================================================================================================================================================================================================================================================+

＜推　奨＞

洪水及び地震に対する堤防の信頼性を維持し高めていくためには、堤防の保持すべき個々の機能に着目した点検としていくことが重要であるため、目視による点検方法のほか、堤防の個々の機能に応じて計器を設置する等して、出水時に生じる湿潤面発達状況、堤防周辺地盤の挙動等を計測することも検討することが望ましい。

堤防の開削工事は、堤防の構成材料や履歴を把握する貴重な機会であるので、長年にわたって築かれた堤防では、堤防断面調査を実施することが望ましい。

蓄積された堤防の状態把握、分析評価、対策の繰り返しの経験をもとに、必要に応じて堤防の構造、材料や設計法の妥当性について再検証することが望ましい。

中小河川では、大河川に準じて学識者等の助言を得られるように体制の整備等を行うことが望ましい。

(2)分析評価について

＜標　準＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 大河川では、被災あるいは被災要因に関して、出水時及び出水後において確認された被災箇所と既存の被災対策箇所との重ね合わせを行うことにより、対策の評価や課題等を把握することを基本とする。点検結果については、過去の被災履歴を整理するとともに、あらたな被災の発生状況を順次加えて記録、保存することを基本とする。 |
|                                                                                                                                                                                                                                                                                                                |
| 点検、対策の結果は、水防、災害実績等の堤防の安全性に関係する他の資料とともに河川カルテ等として保管、更新することを基本とする。                                                                                                                                                                                 |
+================================================================================================================================================================================================================================================================================================================+

＜推　奨＞

中小河川では、大河川に準じて対策の評価や課題等を把握することが望ましい。

(3)対策について

＜標　準＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 堤防が洪水あるいは地震により被害を受けた場合には、入念な調査により被害の原因やメカニズムを把握して対策を行うことを基本とする。                                                                                                                                                   |
|                                                                                                                                                                                                                                                                                  |
| 芝等で覆われた法面の耐侵食性の評価については、様々な手法がある（耐侵食機能は、根毛層の深さと密度より決まり、簡便に根毛量を測定する方法として、ベーン式根系強度計による方法がある）。大河川では、それらを参考に耐侵食機能を評価し、適切な補修等の対策を検討することを基本とする。 |
|                                                                                                                                                                                                                                                                                  |
| 法面では、出水や降雨による堤体内の水位の上昇に伴うすべり、あるいは降雨や人為作用に起因する崩れ等の被災を生じる。そのため大河川では、法面のすべりや崩れについては状態把握に基づいて原因を調べる等により適切な補修等の対策を行うことを基本とする。                                 |
|                                                                                                                                                                                                                                                                                  |
| 漏水や噴砂といったパイピングの原因については種々考えられる。大河川では、出水期前等の点検、水防団や地域住民からの聞き込み等によって、その状況と原因をよく把握するよう努め、補修ないしは適切な工法による対策を実施することを基本とする。                                           |
+==================================================================================================================================================================================================================================================================================+

＜推　奨＞

中小河川では、大河川に準じて対策を行うことが望ましい。

＜関連通知等＞

1\) 堤防等河川管理施設及び河道の点検・評価要領：平成31年4月,
国水環保第1号,河川環境課長.

（最新版）堤防等河川管理施設及び河道の点検・評価要領：令和5年3月,
国水環保第13号,河川環境課長.

2\)
樋門等構造物周辺堤防詳細点検要領：平成24年5月17日,国水治第24号,治水課長

3\)
中小河川の堤防等河川管理施設及び河道の点検要領の改定について：平成29年3月28日,国水環保第43号,河川保全企画室長.\
（最新版）中小河川の堤防等河川管理施設及び河道の点検要領の改定について：令和6年3月27日,国水環保第5号,河川保全企画室長.

**2．1．2 除草**

＜考え方＞

堤防の法面等に草丈が高く根が深い雑草が繁茂すると、土壌の緊張力が低下し、あるいは土壌が腐植土化することにより、堤防表層が弱体化して、法崩れ、ひびわれ、陥没等の誘因となる場合がある。また、カラシナや菜の花が堤防に繁茂し、枯れた根を餌とするミミズが増殖し、ミミズを餌とするモグラによる穴が法面に発生している事例もある。このようなことから、堤防の強度を保持し、降雨及び流水等による侵食や法崩れ等の発生を防止するため、堤防法面等（天端及び護岸で被覆する部分を除く。）において、堤防点検等の環境整備とともに堤体の保全のために必要な除草を行う必要がある。堤防点検等のための環境整備の除草については第4章第3節による。

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  堤防の強度を保持し、降雨及び流水等による侵食や法崩れ等の発生を防止するため、堤防法面等（天端及び護岸で被覆する部分を除く。）において、堤防点検等の環境整備とともに堤体の保全のために必要な除草を行うことを基本とする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

(1)除草頻度について

＜必　須＞

  --------------------------------------------------------------------------------------------------------------
  堤体を良好な状態に保つよう、また堤防の表面の変状等を把握できるよう、適切な時期に必要な除草を行うものとする。
  --------------------------------------------------------------------------------------------------------------

  --------------------------------------------------------------------------------------------------------------

＜標　準＞

+--------------------------------------------------------------------------------------------------------------------------------------------------+
| 堤体の保全のための除草は堤防点検等のための環境整備の除草と兼ねて行い、気候条件や植生の繁茂状況、背後地の状況等に応じて決定することを基本とする。 |
|                                                                                                                                                  |
| 大河川では年2回を基本とするが、植生の生育条件等により年1回の除草で堤防の保全及び堤防点検等に支障のない場合等には、年2回の除草としなくてもよい。  |
|                                                                                                                                                  |
| 中小河川では、大河川の考え方を参考に河川の区間区分等に応じて除草の時期、頻度を設定することを基本とする。                                         |
+==================================================================================================================================================+

[＜例　示＞]{.mark}

年3回以上の除草により処分費用が縮減されることで、年間全体でのコストの縮減が確認されている事例がある。

(2)除草の方法について

＜標　準＞

+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 高水敷については、高水敷上の植生が堤防に進入することを防ぐために、堤防と一体として維持管理すべき範囲についてはあわせて除草を行うことを基本とする。                                                                                                                                                                                                         |
|                                                                                                                                                                                                                                                                                                                                                            |
| 除草の方法は、経済性に優れた機械除草方式を基本とする。                                                                                                                                                                                                                                                                                                     |
|                                                                                                                                                                                                                                                                                                                                                            |
| 除草機械には、大型自走式（履帯式）、大型・小型遠隔操縦式、ロングリーチ式、ハンドガイド式、肩掛け式等があり、法面勾配、浮石等の障害物の有無、構造物の存在状況等の現場条件等に応じて選定することを基本とする。除草作業にあたっては飛び石による事故等に留意し、除草後には、機械の乗り入れ等によってわだちや裸地等の変状が生じないようにすることを基本とする。 |
|                                                                                                                                                                                                                                                                                                                                                            |
| なお、除草剤については、河川管理者自らが率先して河川の水質の一層の向上に努める必要があることから、大河川においては農薬の使用に関する通知^1)^により使用しないことを基本とする。                                                                                                                                                                             |
+============================================================================================================================================================================================================================================================================================================================================================+

＜関連通知等＞

1\)
農薬の使用に関する河川の維持管理について：平成2年3月19日,事務連絡,河川環境対策室長等.

＜推　奨＞

除草の機械化を促進するために、法面勾配の緩和や浮石等の障害物の除去等、除草しやすい堤防としていくことにも努める。

(3)集草等処理について

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  除草後の刈草を放置すると芝の生育への支障や土壌の富養化、火災等の問題を生じることがあるため、河川管理上あるいは廃棄物処理上支障がなく刈草を存置できる場合を除いて、刈草は集草等により適切に処理することを基本とする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

刈草を集草する場合には、運搬・処分・焼却等の処理を行ってきたが、リサイクル及び除草コスト縮減の観点から、地域や関係機関による刈草の飼料等への有効利用、野焼きによる処分等について、廃棄物やリサイクルに係る関連法令等にも留意しつつ取り組みに努める。

(4)河川環境の保全への配慮等について

＜標　準＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 除草の対象範囲内に河川環境上重要な生物が生息する場合には、対応を検討することを基本とする。                                                                                 |
|                                                                                                                                                                            |
| また、野火(植生の火災)の防止への対応については、沿川の土地利用等の状況等を考慮して、実施時期を調整することや、延焼防止策を講じること等を検討の上実施することを基本とする。 |
+============================================================================================================================================================================+

＜推　奨＞

除草等人為的な管理を長年にわたり行ってきたことにより、自然環境上貴重な草本植生群落が形成される場合がある。除草の対象範囲内に河川環境上重要な生物が生息する場合には、繁殖の時期への配慮等について学識経験者等の意見を聞きつつ、対応を検討することが望ましい。

また、野火(植生の火災)の防止への対応については、沿川の土地利用等の状況等を考慮して、実施時期を調整することや、延焼防止策を講じること等を検討の上必要に応じて実施する。

生活環境や自然環境に配慮した堤防除草に関しては、市町村との一層の連携を図るとともに、地域の特性を反映しつつ、地域住民、河川協力団体、NPO、市民団体等との協働等により実施していくことが望ましい。

＜関連通知等＞

1\)
農薬の使用に関する河川の維持管理について：平成2年3月19日,事務連絡,河川環境対策室長等.

**2．1．3 天端**

＜考え方＞

天端の維持管理は、施設が良好に保たれ、出水時に所要の機能を維持するために適切に行う必要がある。

天端は堤防の高さや幅を維持するために重要な部分であるが、管理車両や河川利用者の通行等の人為的な作用、降雨や旱天等の自然の作用により様々な変状を生じる場所である。

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------
  天端は堤防の高さ等が確保されることを基本とする。天端に発生したわだちなどの変状は、雨水がたまらないよう適切に補修等の対応を行うことを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------

  --------------------------------------------------------------------------------------------------------------------------------------------------

(1)天端の舗装について

＜考え方＞

天端は堤体の耐浸透機能から見ると降雨の広い浸入面になるため、雨水の堤体への浸透を抑制するよう努めることが重要である。また、河川巡視あるいは洪水時の水防活動が主に行われる場でもある。

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  天端が舗装されている場合には、堤体の緩みや空洞発生の予兆現象として、舗装面のクラック等が現れる場合があるため、特にこれに注目して点検を実施する。また、舗装下の空洞、陥没の兆候にも留意し点検を実施し、堤防の機能に支障が生じないよう適切に維持管理することを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1\) 堤防等河川管理施設及び河道の点検・評価要領：平成31年4月,
国水環保第1号,河川環境課長.\
（最新版）堤防等河川管理施設及び河道の点検・評価要領：令和5年3月,
国水環保第13号,河川環境課長.

＜推　奨＞

雨水の堤体への浸透抑制や河川巡視の効率化等の観点から、未舗装の天端補修等の際には天端を簡易舗装を含めて舗装していくことが望ましい。

ただし、舗装面上の雨水は法面に集中して法面侵食が助長されることがあり、また、舗装のクラックや欠損箇所は堤体の雨水浸透を助長する箇所にもなるため、天端舗装にあたって雨水の排水に十分配慮するとともに、舗装面を維持管理することが望ましい。

なお、天端を舗装した場合、車両等の通行が容易となり河川管理施設の損傷や河川利用上の危険が増加するおそれがあるため、河川法施行令（昭和40年政令14号。以下「令」という。）第16条の4に基づく進入禁止措置や自動車等の車止めの設置等の適切な措置を必要に応じて実施する。

(2)法肩の保護について

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  天端の法肩部は、堤体構造上、緩みやクラックが発生しやすい箇所であることから、点検あるいは河川巡視等において変状を把握し、堤防の機能に支障が生じないよう適切に維持管理することを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

天端を舗装した場合には、堤体への雨水の浸透や、法面の雨水による侵食発生を助長しないよう、法肩の状態に留意し、必要に応じて補修やアスカーブ等を施す等を検討する。

**2．1．4 坂路・階段工**

＜考え方＞

坂路・階段工の維持管理は、施設が良好に保たれ、出水時に所要の機能を維持するために適切に行う必要がある。

堤防法面における坂路や階段工の取付け部分等は、雨水や洪水により洗掘されやすく、また、人為的に踏み荒され又は削られ、降雨時には排水路となり侵食されやすいので留意する必要がある。

なお、幅の広い川表の階段工は、階段護岸と同形式で設置される場合があるので、その場合の維持管理については第6章第3節を参照されたい。

＜標　準＞

  -----------------------------------------------------------------------
  変状を発見した場合には、速やかに補修等の対応を行うことを基本とする。
  -----------------------------------------------------------------------

  -----------------------------------------------------------------------

＜推　奨＞

補修の頻度が高くなる場合は、侵食要因の除去や法面の保護について検討することが望ましい。

坂路は、河川管理や河川敷地の自由使用のために設置するものであるが、走行することにより河川敷地を損傷するモトクロスや車両の進入を助長することがある。そのような場合には、市町村等と調整し、令第16条の4に基づく進入禁止措置や自動車等の車止めの設置を必要に応じて実施する。

また、坂路・階段工は堤内地から河川へのアクセス路となるものであり、河川が適正に利用されるよう配慮し、高齢者等が容易にアクセスできるように、可能な場合には坂路の緩傾斜化、階段の段差の改良等バリアフリー化にも努める。その際には、まちづくり等の観点から、堤内地から堤外地にかけて連続的な動線となるように、市町村や道路管理者等と連携して歩道や散策路の整備を進めていくことが望ましい。

**2．1．5 堤脚保護工**

＜考え方＞

堤脚保護工は、堤体内に浸潤した流水及び雨水の排水の支障とならないよう、一般に空石積み又はそれに類似した排水機能に配慮した構造としている。そのため、局部的な脱石、変形、沈下等が起こりやすいので、それらに留意して巡視や点検を行い適切に維持管理する必要がある。

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------
  出水時の巡視及び出水後の点検で、吸い出しによる濁り水、あるいは堤体からの排水不良等の異常を発見したときは必要な措置を実施することを基本とする。
  ------------------------------------------------------------------------------------------------------------------------------------------------

  ------------------------------------------------------------------------------------------------------------------------------------------------

**2．1．6 堤脚水路**

＜考え方＞

堤脚水路については、排水機能が維持されるよう維持管理する必要がある。

＜標　準＞

+--------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 堤防等からの排水に支障が生じないように、堤脚水路内の清掃等の維持管理を実施することを基本とする。                                                                         |
|                                                                                                                                                                          |
| 堤防側の壁面を堤脚保護工と兼用している場合には、破損を放置すると堤体材料の流失等の悪影響が生じることとなるので、異常を発見したときはすみやかに補修することを基本とする。 |
+==========================================================================================================================================================================+

＜推　奨＞

水路の壁面が堤体の排水を阻害していないかについて適宜点検することが望ましい。

**2．1．7 側帯**

＜考え方＞

側帯については、側帯の種別に応じた機能が維持されるよう維持管理する必要がある。

側帯は、堤防の裏法側に目的に応じて設けられるものであるため、機能に応じて適切に維持管理する必要がある。

＜標　準＞

  --------------------------------------------------------------------------------
  側帯に植樹する場合には樹木の植樹・伐採に関する基準^1)^によることを基本とする。
  --------------------------------------------------------------------------------

  --------------------------------------------------------------------------------

(1)第1種側帯について

＜標　準＞

  -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  第１種側帯は、旧川の締切箇所、漏水箇所等に堤防の安定を図るために設けられるものであり、維持管理上の扱いは堤防と同等であるため、堤体（第6章第2節2.1.1参照）と同様に維持管理することを基本とする。
  -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

(2)第2種側帯について

＜標　準＞

  ---------------------------------------------------------------------------------------------------------------------------------------------------
  第2種側帯は、水防用の土砂等を備蓄するために設けられるものであるため、不法投棄や雑木雑草の繁茂等を防ぎ、良好な盛土として維持することを基本とする。
  ---------------------------------------------------------------------------------------------------------------------------------------------------

  ---------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

第2種側帯は、市町村による公園占用を許可する等により維持することが望ましい。

(3)第3種側帯について

＜標　準＞

  ---------------------------------------------------------------------------------------------------------------------
  第3種側帯は、環境を保全するために設けられるものであるので、目的に応じた環境を維持するよう管理することを基本とする。
  ---------------------------------------------------------------------------------------------------------------------

  ---------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1\)
河川区域内における樹木の伐採・植樹基準について：平成10年6月19日,建河治発第44号,治水課長.

**2．2 特殊堤**

＜考え方＞

特殊堤の維持管理については、施設が良好な状態に保たれ、出水時に所要の機能が確保するために適切に行うものである。

**2．2．1 胸壁構造の特殊堤**

＜考え方＞

胸壁（パラペット）構造の特殊堤は、計画高水位（高潮区間にあたっては計画高潮位）以上の高さの土堤に胸壁を設けたものである。土堤の部分の維持管理については、第6章第2節2.1による。また、一般に胸壁に連続して護岸が設けられるが、護岸の部分の維持管理については第6章第3節による。

胸壁は、盛土上の構造物であり沈下が起こりやすいため、天端高の維持及び基礎部の空洞発生に留意して維持管理を行う必要がある。

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  胸壁構造の特殊堤の点検にあたっては、特に、天端高が確保されているか、基礎部に空洞は発生していないか、胸壁が傾いていないか、コンクリートの損傷やクラックが発生していないか、接合部の止水板に損傷はないか等について着目し、異常を発見した場合には適切に補修等を行うことを基本とする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

**2．2．2 自立式構造の特殊堤**

＜考え方＞

自立式構造の特殊堤は、コンクリート構造物としての点検が必要であり、外観から吸い出しや空洞化の把握が難しいため、その予兆となる事象に注意する。

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  堤防の点検にあたっては、目地部の開口やずれが発生していないか、コンクリートの損傷やクラックが発生していないか、錆汁、鉄筋露出等はないか等に留意して維持管理し、異常を発見した場合には適切に補修等を行うことを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

**2．3 霞堤**

＜考え方＞

霞堤は、主に急流河川において堤防の決壊による災害を最小限にとどめる等のために設置されるものである。霞堤の維持管理については、施設が良好状態に保たれ、出水時に所要の機能が確保するために適切に行うものである。

＜標　準＞

  ----------------------------------------------------------------------------------------------------------
  霞堤は一般に土堤であるので、現況の機能が維持されるよう通常の土堤に準じて維持管理を行うことを基本とする。
  ----------------------------------------------------------------------------------------------------------

  ----------------------------------------------------------------------------------------------------------

＜推　奨＞

霞堤が設置されている区間では、霞堤の切れ目の所で河川管理用通路が分断され河川巡視等の支障となっている場合もあるため、連続した河川管理用通路の確保に努める。

**2．4 越流堤、導流堤、背割堤、二線堤**

＜考え方＞

越流堤、導流堤、背割堤、二線堤の維持管理については、施設が良好状態に保たれ、出水時に所要の機能が確保するために適切に行うものである。

＜標　準＞

  --------------------------------------------------------------------------------------------------------
  越流堤、導流堤、背割堤、二線堤については、それぞれの機能が確保されるよう維持管理することを基本とする。
  --------------------------------------------------------------------------------------------------------

  --------------------------------------------------------------------------------------------------------

(1)越流堤について

＜考え方＞

遊水地の越流部に用いられる越流堤には、土堤の表面に法覆工を施したもの、コンクリート重力式、コンクリートウォール式等がある。コンクリート重力式とコンクリートウォール式のものについては、コンクリート擁壁構造の特殊堤に準ずる構造を持つので、第6章第3節3.2による。

土堤の表面に法覆工を施した越流堤は、洪水時に生ずる高速の越流により被災することが多いため、特にフェーシングの安全性と遊水地内の堤脚部の洗掘に留意が必要である。

＜標　準＞

+-----------------------------------------------------------------------------------------------------------------------------+
| 点検にあたっては次の事項に留意し、異常を発見した場合には適切に補修等を行うことを基本とする。                                |
|                                                                                                                             |
| > ①堤　体：目地部開口、不同沈下、はらみ出し、空洞化、フェーシングの摩耗損傷、（密閉タイプの場合）エアー抜きの破損、目詰まり |
|                                                                                                                             |
| ②減勢工：摩耗、損傷、遊水地側の減勢工前面の洗掘                                                                             |
+=============================================================================================================================+

(2)導流堤について

＜考え方＞

導流堤は洪水流を導くものであり、一般に水あたりが強いため、堤体の損傷と洗掘に特に留意する必要がある。

護岸や根固工を設ける場合には第6章第3節、第6章第4節を参照されたい。

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  導流堤の工種、型式は、河川の特性や設置場所、設置目的等に応じて種々のものがあるので、その工種、型式に応じて適切に維持管理し、異常を発見した場合には適切に補修等を行うことを基本とする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

(3)背割堤について

＜考え方＞

背割堤は、分流や合流に際して流れを分離するために設けられるものであり、構造上は通常の堤防と差異がないが、堤防の両側から流水の作用を受けることに注意する。

＜標　準＞

  -----------------------------------------------------------------------------------------------------------------
  土堤の場合は堤体（第6章第2節2.1）と同様に維持管理し、異常を発見した場合には適切に補修等を行うことを基本とする。
  -----------------------------------------------------------------------------------------------------------------

  -----------------------------------------------------------------------------------------------------------------

(4)二線堤について

＜考え方＞

二線堤は、超過洪水時の氾濫被害拡大の抑制等を図るものであり、霞堤の締切や河道の付替えに伴い従来の本堤が二線堤として存置されている場合もある。

二線堤は直接には洪水の作用を受けないこと、その一方で堤内地における人々の活動の影響を受けやすいことを考慮する必要がある。

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------
  二線堤については、現況の機能が維持されるよう通常の土堤に準じて維持管理し、異常を発見した場合には適切に補修等を行うことを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------------

  --------------------------------------------------------------------------------------------------------------------------------------

**第3節 護岸**

**3．1 護岸一般（コンクリート擁壁、矢板護岸以外）**

＜考え方＞

護岸は、水制等の構造物や高水敷と一体となって堤防を保護するため、あるいは掘込河道にあっては堤内地を安全に防護するため設置するものである。護岸には、高水護岸と低水護岸、及びそれらが一体となった堤防護岸がある。いずれの護岸にしても、流水の侵食作用に対して河岸あるいは法面を防護する機能（耐侵食機能）が主として求められることから、所要の機能が維持されるように維持管理を行う必要がある。

護岸には以下のような被災形態がある。

①河床洗掘による被災

②すり付け部からの被災

③法覆工の流出による被災

④天端工及び天端保護工の流失

⑤背面土砂の吸出し

⑥法覆工の摩耗・破損

護岸の沈下や損傷を放置すると、それが拡大して堤防の決壊等の大災害を引き起こす危険性もあるので、点検等により異常の早期発見に努めることが重要である。

＜標　準＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 護岸については、堤防や河岸防護等の所要の機能が維持されるよう維持管理を行い、治水上の支障となる異常がある場合には、適切な工法によって早期に補修することを基本とする。 |
|                                                                                                                                                                      |
| また、護岸の工種は種々あるので、維持管理にあたっては工種毎の特性や被災メカニズム、各河川での被災事例等を踏まえつつ、適切に維持管理を行うことを基本とする。           |
|                                                                                                                                                                      |
| 補修等が必要とされる場合には、各河川における多自然川づくりの目標等を踏まえ、十分に河川環境を考慮した護岸の工種や構造となることを基本とする。                         |
+======================================================================================================================================================================+

(1)護岸の状態把握

＜考え方＞

護岸の機能を低下させる変状は、吸い出しによる護岸背面の空洞化によるものが多いが、空洞化の状況は、護岸表面に明らかな変状が現れない限り把握が困難である。また、護岸が常時水面下にあるような区間においては、変状そのものを把握することが困難である。そのため、護岸の機能を低下させないよう、目視出来ない部分の状態を把握する工夫を行うことが重要である。

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  点検等により、維持すべき護岸の耐侵食機能が低下するおそれがある目地の開き、吸い出しが疑われる沈下等の変状が見られた場合は、さらに点検を実施し、変状の状態から明らかに護岸の耐侵食機能に重大な支障が生じると判断した場合には、必要な対策を実施することを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

空洞化等が疑われる場合には、護岸表面を点検用ハンマーでたたく打音調査、物理探査等により目視出来ない部分の状態の把握に努める。

吸い出しの主な要因にもなる護岸基礎等の水中部の洗掘については、目視での状態把握はできないので、河床変動の傾向や出水時の変動特性等を既往の資料等により把握するよう努めるとともに、個別の箇所については護岸前面の水中部の洗掘状況を定期あるいは出水後に横断測量する等により状態把握に努める。

(2)補修等の対策

＜考え方＞

護岸の変状としては、脱石・ブロックの脱落、はらみ出し、陥没、間隙充填材料の流失、目地ぎれ、天端工や基礎工の洗掘に伴う変状、鉄筋やコンクリート破損等があり、所要の機能が維持されるように必要な対策を行う必要がある。

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  護岸の変状に対しては、原因を分析し、それに対応した対策工を選定することを基本とする。ただし、水際部が生物の多様な生息環境であること等に鑑み、補修等に際しては、積極的に河川環境の保全に配慮する事を基本とする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜例　示＞

①脱石・ブロックの脱落の補修

> 局部的に脱石やブロックの脱落が生じた場合は、張り直すか、又は、コンクリートを充填する方法が考えられる。

②空洞化、はらみ出し及び陥没の補修

> 石積（張）やブロック積（張）の構造に変化がなく、背面が空洞化している場合は、裏込め材、土砂等の充填を行い状況に応じて積（張）替えを行うことが考えられる。充填した箇所を保護するために、状況に応じて天端保護工等を施工することが考えられる。はらみ出しや陥没が生じている場合は、原因を分析した上で構造を検討し、対策を実施することが考えられる。

③目地ぎれの補修

> 局部的に目地に隙間が生じたため合端が接していないものは、すみやかにモルタル等で填充することが考えられる。また、鉄筋やエポキシ系樹脂剤等で補強することも考えられる。

④天端工の補修

> 法覆工の天端付近に生じた洗掘を放置すると、法覆工が上部から破損されるおそれがあるので、埋め戻しを行い十分突固める等の対応を行うとともに、状況に応じて天端保護工を施工することも考えられる。

⑤基礎工の補修と洗掘対策

> 洗掘等により基礎が露出した場合は、根固工又は根継工を実施し、上部の護岸への影響を抑止することが考えられる。

⑥鉄筋やコンクリート破損

> 連結コンクリートブロック張工等で、鉄筋の破断やコンクリートの破損あるいはブロックの脱落等を生じた場合には、状況に応じて鉄筋の連結、モルタル等の充填、あるいはブロックの補充等を行うことが考えられる。

(3)自然環境への配慮について

＜標　準＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 護岸は、河川が本来有している生物の良好な生息・生育・繁殖環境と多様な河川景観の保全に重要な水際部に設置されることが多いので、護岸の維持管理にあたっては、多自然川づくりを基本として自然環境に十分に配慮することを基本とする。                                               |
|                                                                                                                                                                                                                                                                            |
| 多自然川づくりでは画一的ではない河岸を目指して整備を行うが、施工の完了により川づくりが完成するものではないため、施工後の出水等による河道の変化や植生の変化等に伴う河川環境の状況を調べ、維持管理あるいは改善のための整備を行いながら川づくりを進めていくことを基本とする。 |
+============================================================================================================================================================================================================================================================================+

＜推　奨＞

個々の施設の補修等にあたって、自然河岸化を含め抜本的な構造等の見直し検討を行うことが望ましい。

＜例　示＞

多自然川づくりが進む中で、柳枝工、柵工、覆土工が多く用いられるようになっている。それぞれについて、以下の視点で適切な補修等が行われている。

①柳枝工

> 法覆工（柳枝工、栗石粗朶工、投掛工）や法留工（粗朶柵工、鉄線柵工、板柵工等）に植栽した柳枝が枯死して根付かない場合には、柳枝を補足するものとし、また繁茂しすぎた場合には河積の減少とならないよう、状況に応じて間伐等を行う。柳は地域毎に生育する種が異なり、また樹型として高木型と低木型があるので樹種の適切な選択が重要である。法留工においては、柳枝の成育が不均等であると法崩れ等の原因となる。

②柵工

> 柵工には使用材料（板柵、粗朶柵、杭柵、コンクリート柵等）により種々の工種があるが、流水による吸い出しにより土砂が流出し裏側に空洞が生じたり、陥没したりすることが多い。水面付近の木材は早期に腐食しやすい。

③覆土工

> 覆土は洪水によって流失しやすいので、流失した場合は、環境機能の保全の観点を踏まえて補修を行う必要がある。覆土した土壌によっては外来植物の繁茂が懸念されるので、覆土材料の選定に留意する。

(4)河川利用との関係について

＜考え方＞

河川は、水難事故の危険性を常に内包しつつ、一般公衆の自由使用に供されているところであり、それに伴う危険は原則として利用者自身の責任で回避されるべきものである。しかし、階段護岸等の水辺利用を促す護岸が設置された場合、河川利用に伴うリスクに遭う蓋然性が増大する傾向になる。また、利用者に河川利用の安心感を与え、河川が常に危険を内包しているものであることを忘れさせる面もある。リスクに遭遇する蓋然性の増大及び利用者の危険意識の変化によって、利用者及び施設の管理者双方に責任が拡大することを認識することが重要である。

護岸は、水際や高低差のある河川利用に伴い危険が内在しやすい場に設けられるものであり、特に留意が必要である。

＜標　準＞

  -------------------------------------------------------------------------------------------------------------------------------------
  階段護岸等の水辺利用を促す護岸については、第7章第3節3.2の考え方に準じて、責任の拡大に対応した危険防止措置を講じることを基本とする。
  -------------------------------------------------------------------------------------------------------------------------------------

  -------------------------------------------------------------------------------------------------------------------------------------

**3．2 コンクリート擁壁**

＜考え方＞

コンクリート擁壁の維持管理については、施設が良好に保たれ、出水時に所要の機能を維持するために適切に行う必要がある。

＜標　準＞

  ---------------------------------------------------------------------------------------------------
  コンクリート擁壁の維持管理は、同構造の特殊堤と同様に、第6章第2節2.2に準じて行うことを基本とする。
  ---------------------------------------------------------------------------------------------------

  ---------------------------------------------------------------------------------------------------

**3．3 矢板護岸**

＜考え方＞

矢板護岸の維持管理については、施設が良好に保たれ、出水時に所要の機能を維持するために適切に行う必要がある。

矢板護岸には自立式構造とアンカー等によって安定を保つ構造としたものがあるが、どちらの構造でも矢板の倒壊は堤防又は河岸の崩壊に直結するので、洪水時、低水時及び地震時において安全性が確保されるよう維持管理する必要がある。

鋼矢板の場合は腐食が、コンクリート矢板の場合はコンクリートの劣化が、矢板護岸の安全性に大きく影響する要素であるので、その状態把握を行うことが重要である。特に鋼矢板の水際付近あるいは感潮域にある鋼矢板にあっては、腐食の状況に留意が必要である。

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------
  点検等により、護岸本体の異常の有無、継手部の開口、背後地の地盤変化等の状況を把握し、異常を発見した場合には適切に補修等を行うことを基本とする。
  ------------------------------------------------------------------------------------------------------------------------------------------------

  ------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

矢板の変位や河床の洗掘は安全性に係わる大きな要因となるので、変位や洗掘の状況等を測定、調査することが望ましい。

**第4節 根固工**

＜考え方＞

根固め工の維持管理については、施設が良好に保たれ、出水時に所要の機能を維持するために適切に行う必要がある。

根固工は、河床の変動に対応できるように屈撓性を有する構造としているため、多少の沈下や変形に対しては追随できるが、洪水による流失や河床洗掘による沈下、陥没等が生じやすい。

根固工は、河川環境において特に重要である水際部に設置され、既存の構造物が魚類等の良好な生息環境になっている場合も多い。

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------
  根固工の補修等にあたっては、生物の生息・生育・繁殖環境や河川景観の保全に配慮し、各河川における多自然川づくりの目標を踏まえて対応することを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------

  --------------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

洪水による流失や河床洗掘による沈下、陥没等は、一般に水中部で発生し、陸上部からの目視のみでは把握できないことが多いので、出水期前点検時等に、根固工の水中部の状態把握を行うよう努める。また、河床変動の状況を把握するように努める。

＜例　示＞

根固工の工法としては、捨石工、コンクリートブロック工、かご工、沈床工などがあり、それぞれについて、以下の視点で適切な補修等が行われている。

①捨石工

> 捨石工の捨石が流失した場合の補修にあたっては、石の大きさや重量について検討し、他の工法の採用についても検討する。

②コンクリートブロック工

> 相互に連結して使用しているコンクリートブロックは、連結部が破損すると個々に移動しやすくなり根固工としての効用を失うので、連結鉄筋の腐食に留意する。また、コンクリートブロック工は一般に空隙が大きいため、河床材料が吸い出されて沈下・流失を生じることもあるので留意する。散乱したブロックの再利用を考慮する。

③かご工

> かご工は鉄線の腐食、切損及びそれに伴う中詰石の流失の発見に努め、補修可能な場合はその箇所の補強縫等の措置を行う。水質の汚濁された河川や感潮区間では腐食が早いので留意する。

④沈床工

> 沈床の部材のうち、特に上部の方格材は、流砂や腐食等によって損傷を受けやすいことに留意する。損傷を発見した場合は、必要な補修を検討実施する。詰石が流出した場合については捨石工に準じて補修する。

**第5節 水制工**

＜考え方＞

水制工の維持管理については、河川の規模や重要度等によって適切に行うものである。

水制工は、流水の作用を強く受ける構造物であることから、先端付近に深掘れが生じる、あるいは一部の破損により流路が大きく変化する等、その影響が対岸や上下流を含め広範に及ぶことがある。

水制の種類には、透過水制、不透過水制、及び両者を組み合わせたものがある。透過水制は流水を透過させるのでゴミや流木等がひっかかりやすく、流水に対する抵抗が増して安定性に影響するので留意する必要がある。不透過水制は、水はねの効果は大きいが、流水に強く抵抗するので周辺の洗掘も大きい。特に水制頭部は、深掘れを生じやすいので留意する必要がある。

また、必要に応じて水制工の設置効果について検討を行い配置等の再検討についても考慮するものである。

＜標　準＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 施工後の河道の状態把握に努めるとともに、水制工が破損した場合には施工後の河道の変化を踏まえつつ、治水機能が維持されるよう適切に補修等の対応を行うことを基本とする。                                                                                                         |
|                                                                                                                                                                                                                                                                            |
| 水制と護岸等の間には相当の間げきが生じるため、水流の阻止のため間詰めがされる。しかし、間詰めが破損又は流失した場合には流水が集中して、護岸さらには堤防等の施設に被害を及ぼすことが考えられるので、間詰めが破損、流失した場合には捨石等で補修し、整形することを基本とする。 |
+============================================================================================================================================================================================================================================================================+

＜推　奨＞

水制工は、河川環境において特に重要である水際部に設置されるので、生物の生息・生育・繁殖環境や河川景観を保全するような整備が求められる。したがって、補修等にあたっても、水制の設置目的や各河川における多自然川づくりの目標を踏まえて、水制の構造、諸元等を可能な限り河川環境に適したものとすることが望ましい。

木材を用いた水制工の場合には水面付近の木材は早期に腐食することが多いため、植生の緊縛による構造の安定状況等を勘案しながら必要に応じて補修等を実施することが望ましい。

＜例　示＞

水制工の工法としては、杭出し工、粗朶工、牛枠工、ブロック工などがあり、それぞれについて、以下の視点で適切な補修等が行われている。

①杭出し工

> 河床洗掘等により大きく杭が浮き上がっているものは、固定させるため根入れを深くし、布木の連結の緩んでいるものは締め直しを行う。

②粗朶工

全体が著しく沈下した場合には増設等の処置を行う。

③牛枠工

> 連結の緩んだものは締め直し、重しかごの重量が不足している場合は、状況に応じて増量又は交換する等の処置を実施する。

④ブロック工

状況に応じて補充等の処置を実施する。

**第6節 樋門・水門**

＜考え方＞

樋門・水門の維持管理については、河川の規模や重要度等に応じて適切に行うものである。

**6．1 本体**

＜考え方＞

樋門は、取水又は排水のため、河川堤防を横断して設けられる函渠構造物である。出水時にはゲートを全閉することにより、洪水の逆流を防止し、堤防としての機能を有する重要な河川管理施設であることから、連続する堤防と同等の機能を維持するよう常に良好な状態を保持する必要がある。

また、水門は、本川の堤防を分断して設けられる工作物で、堤防としての機能、本川からの逆流を防止（又は高潮の遡上を防止）する機能、それが横断する河川の流量を安全に流下させる機能、また、舟運等に利用する水門（閘門）においては、安全に通航できる機能等を有しており、これらの機能を維持するよう常に良好な状態を保持する必要がある。

舟運に関しては、必要に応じて令第16条の2に規定する措置を行うものである。

盛土構造物である堤防内に材料の異なる構造物が含まれると、その境界面は浸透水の水みちとなりやすく、漏水の原因となり堤防の弱点となりやすい。特に、樋門や水門においては、門柱や函渠と盛土との境界面に沿って水みちが形成され、出水時に漏水等が発生する事例が多い。また、杭基礎を有する施設や軟弱地盤上の施設においては、沈下特性の差異から以下のような問題を生じやすい状況にあるため、樋門・水門周りの堤防の点検については特に留意する必要がある。

・地盤の沈下（圧密沈下、即時沈下）に伴う本体底版下の空洞化

・堤体の抜け上がり、陥没、堤体のクラックの発生

> ・堤体や地盤の沈下に伴う本体継手部の開き、止水板の断裂、翼壁との接合部開口、本体、胸壁、翼壁等クラックの発生

・本体周辺での漏水や水みちの形成、これに伴う本体周辺の空洞化

樋門・水門の点検は第4章第5節5.1、5.2、5.4によるが、上記の変状は許可工作物の樋門・水門周りの堤防にあっても同様である。

なお、近年軟弱地盤上の樋門については、その挙動を周辺の堤体の挙動に合致させるよう、柔構造樋門として設計することとしている。柔構造樋門は、函軸方向の地盤の沈下・変位に追随できるように、沈下量を大きく許容しているとともに、函軸方向のたわみ性を主に継手の変形性能に期待している。このため柔構造樋門では、継手部の変位量の把握が重要となっている。

＜標　準＞

+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 高い堤防における杭基礎を有する施設や軟弱地盤上の施設においては、上記の現象が発生しやすいので施設の規模等を勘案して10年に1回程度の頻度で函渠のクラック調査を行うことを基本とし、異常を発見した場合には適切に補修等を行うことを基本とする。 |
|                                                                                                                                                                                                                                           |
| 過去の空洞やクラックの発生履歴、地盤の状況等に応じた適切な頻度で空洞化調査を行い、異常な空洞を発見した場合には適切に補修等を行うことを基本とする。                                                                                        |
|                                                                                                                                                                                                                                           |
| 本体周辺の空洞の発見や補修・補強等の対策にあたっては、点検調査結果を十分に検討し、学識者等の助言を得るなど適切な手法を検討の上で実施することを基本とする。                                                                                |
|                                                                                                                                                                                                                                           |
| 軟弱地盤上の樋門の点検では特に継手部の変位量が許容値内にあるかを把握することを基本とする。                                                                                                                                                |
+===========================================================================================================================================================================================================================================+

＜推　奨＞

樋門・水門は、河川環境上の観点からは堤内地の用水路等との連続性を低下あるいは分断している場合がある。このため、連続性の確保が必要とされる場合には、その機能の維持あるいは整備がなされるように配慮することが望ましい。

＜例　示＞

本体周辺の空洞化の調査の方法としては、コア抜きによって監査孔を設置する方法（連通試験）、斜めボーリングによる方法等があるので、現地の条件に応じて適切な方法を選定する。

(1)ゲート部について

①逆流の防止

＜考え方＞

逆流防止は、直接的にはゲートで行うのでゲートの管理が重要である。土木施設としてはゲートの開閉が正常に行え、カーテンウォール部でも水密性が確保されるように留意する必要がある。

＜標　準＞

+----------------------------------------------------------------------------------------------+
| 点検にあたっては次の項目に留意し、異常を発見した場合には適切に補修等を行うことを基本とする。 |
|                                                                                              |
| > ・不同沈下による門柱部の変形                                                               |
| >                                                                                            |
| > ・門柱部躯体の損傷、クラック                                                               |
| >                                                                                            |
| > ・戸当り金物の定着状況                                                                     |
| >                                                                                            |
| > ・戸当り部における土砂やゴミ等の堆積                                                       |
|                                                                                              |
| ・カーテンウォールのクラック、水密性の確保                                                   |
+==============================================================================================+

②取水・排水、洪水の流下

＜考え方＞

取水・排水、及び洪水の流下に支障のないよう、点検にあたって土砂やゴミ等の堆積、本体等の沈下や変形に留意する必要がある。

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------
  ゲート周辺に土砂やゴミ等が堆積している等により、ゲートの不完全閉塞の原因となる場合には、撤去等の対策を行うことを基本とする。
  ------------------------------------------------------------------------------------------------------------------------------

  ------------------------------------------------------------------------------------------------------------------------------

(2)胸壁及び翼壁、水叩きについて

＜考え方＞

胸壁及び翼壁、水叩きは、ゲート部の上下流側に設置して、堤防の弱体化を防止するものであり、ゲート部と同様に重要な施設である。

また、水叩きと床版との継手は、現河床とのすり付けとして不同沈下に対応する部分である。

＜標　準＞

+----------------------------------------------------------------------------------------------------------------------------------------+
| 胸壁及び翼壁、水叩きについては、ゲート部と一連の構造として適切に維持管理し、異常を発見した場合には適切に補修等を行うことを基本とする。 |
|                                                                                                                                        |
| 水叩きと床板との継手が損傷している場合には、水密性が損なわれていることに留意して適切に補修等を行うことを基本とする。                   |
+========================================================================================================================================+

(3)護床工について

＜考え方＞

水叩きを直接河床に接続させると洗掘を起こす危険性がある場合、水叩きに接続して護床工を設置することになる。

護床工の構造は、屈撓性のあるものとしてコンクリートブロック等が用いられているが、巡視や点検に際しての留意点は第6章第7節7.2による。

＜標　準＞

  ------------------------------------------------------------------------------------------------
  護床工の下流側に洗掘等を生じた場合は、護床工を延長する等の適切な措置を講じることを基本とする。
  ------------------------------------------------------------------------------------------------

  ------------------------------------------------------------------------------------------------

(4)取付護岸、高水敷保護工について

＜考え方＞

樋門や水門と堤防の接続部は、一般に一連の堤防区間の弱点となる。護岸及び高水敷保護工は、接続部の侵食対策として設けられるものである。

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------
  沈下や空洞化、あるいは損傷が発見された場合は、それらが拡大して堤防の決壊等の重大災害を引き起こさないよう状況に応じて補修等を実施することを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------

  --------------------------------------------------------------------------------------------------------------------------------------------------------

**6．2 ゲート設備**

＜考え方＞

ゲート設備の維持管理は、施設が良好に保たれ、出水時に所要の機能を維持するために適切に行う必要がある。

＜標　準＞

  -----------------------------------------------------------------------
  第6章第7節7.5を準用して維持管理することを基本とする。
  -----------------------------------------------------------------------

  -----------------------------------------------------------------------

**6．3 電気通信施設、付属施設**

＜考え方＞

電気通信施設は、樋門・水門の操作、制御に直接かかわり、その操作制御及び監視を行うための設備である。このため、高い信頼性が求められており、電気通信施設を構成する機器毎の特性に応じて、適切に点検を行い、機能を維持する必要がある。

付属施設には、上屋、水門等操作観測員待機場（台風時等のための待機場）、管理橋、管理用階段、照明設備、水位観測施設、船舶通航用の信号、繋船環、防護柵等がある。

＜標　準＞

+------------------------------------------------------------------------------------------------------------------------------------+
| 電気通信施設、付属施設については、第6章第7節7.6、及び第6章第7節7.7を準用して維持管理することを基本とする。                         |
|                                                                                                                                    |
| 確実な操作のため、川表側及び川裏側に設置された水位標を適切に維持管理し、異常を発見した場合には適切に補修等を行うことを基本とする。 |
+====================================================================================================================================+

＜推　奨＞

樋門や水門の確実な操作のため、必要に応じて水門等操作観測員待機場、河川管理用カメラ等を設置することが望ましい。

**第7節 床止め・堰**

＜考え方＞

床止め・堰の維持管理については、河川の規模や重要度等によって適切に行うものである。

**7．1 本体及び水叩き**

＜考え方＞

本体及び水叩きは、特に、下流から洗掘を受けて吸出しの被害を受けやすいので、一般に出水期前点検時に目視により、護床工の変状等についても留意しつつ、下部の空洞発生状況及び洗掘状況の把握を行い、適切に維持管理する必要がある。

＜標　準＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 本体のコンクリート構造部分のひびわれや劣化にも留意する必要があり、出水期前の点検等により状態を把握することを基本とする。その際、ひびわれ、劣化等が新たに発生していないかどうかに着目するとともに、既に発見されている箇所については、状況に応じて計測によりその進行状況を把握することを基本とする。 |
|                                                                                                                                                                                                                                                                                                    |
| 水叩きは、流水や転石の衝撃により表面の侵食や摩耗が生じる可能性がある箇所であり、鉄筋が露出することもあるので、点検によって侵食、摩耗の程度を把握することを基本とする。                                                                                                                             |
+====================================================================================================================================================================================================================================================================================================+

**7．2 護床工**

＜考え方＞

護床工は、床止めや堰から加速して流下する洪水流による本体上下流部の洗掘の発生を防止し、本体及び水叩きを保護するものである。一般的にはコンクリートブロック工、捨石工、粗朶沈床、木工沈床等、屈撓性のある工法が用いられる。護床工の沈下、あるいは上下流における河床低下や洗掘の発生は、その被害が本体に及ぶ場合もあるので、特に留意して維持管理する必要がある。

＜標　準＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 護床工の工法としては、コンクリートブロック工、捨石工、粗朶沈床工、木工沈床工などがあり、それぞれについて、以下の視点で適切な点検、補修等を行うことを基本とする。                                                                                                                                                           |
|                                                                                                                                                                                                                                                                                                                            |
| ①コンクリートブロック工、捨石工                                                                                                                                                                                                                                                                                            |
|                                                                                                                                                                                                                                                                                                                            |
| > コンクリートブロックや捨石を用いた護床工では、洪水時に河床材の吸出しによって沈下、あるいはブロックや捨石の流失を生じる場合がある。床止めや堰の下流部の河床低下や洗掘は、洪水時の上下流の水位差を大きくして、被害を拡大させる要因ともなる。上流側の河床低下や洗掘によっても、上流側護床工あるいは本体の被災の要因となる。 |
|                                                                                                                                                                                                                                                                                                                            |
| ②粗朶沈床、木工沈床等                                                                                                                                                                                                                                                                                                      |
|                                                                                                                                                                                                                                                                                                                            |
| 粗朶沈床、木工沈床等は、木材の腐食が問題となるので、腐食の状況と護床機能の状態が重要である。                                                                                                                                                                                                                               |
+============================================================================================================================================================================================================================================================================================================================+

＜推　奨＞

補修等に際しては、必要に応じて、護床工の延長、あるいはブロックや捨石の重量の増大等の措置も検討することが望ましい。

**7．3 護岸、取付擁壁及び高水敷保護工**

＜考え方＞

護岸、取付擁壁及び高水敷保護工において、沈下や、空洞化、損傷等が発生した場合は、それが拡大して堤防の決壊等の重大災害を引き起こすおそれがあるため、第6章第2節2.2、及び第6章第3節に準じて適切に維持管理する。取付擁壁部は、跳水が発生するなど流水の乱れが激しい区間にあるので、特に留意して維持管理を行う必要がある。

床止めや堰の下流部において河床低下や洗掘が発生している場合は、洪水時の上下流の水位差が設計時に想定していたものより大きくなり、護岸や高水敷保護工に作用する流速や衝撃も大きくなることから、河床の状況に留意して維持管理を行う必要がある（第5章第1節参照）。

＜標　準＞

  --------------------------------------------------------------------------------------------------------------
  取付擁壁部に変状が見られた場合には、変状等の状況や程度に応じて補修、補強等の対策を実施することを基本とする。
  --------------------------------------------------------------------------------------------------------------

  --------------------------------------------------------------------------------------------------------------

**7．4 魚道**

＜考え方＞

床止め・堰のように河川を横断する工作物において、魚類等の遡上・降下環境を確保するために魚道は重要な施設である。魚道の形式は様々であるが、魚道内部における土砂の堆積、流木等による上流側の閉塞、あるいは流砂による損傷を受けやすい。また、上下流の河床が変化すると、魚道に十分な水量が流下しない、魚類等が魚道に到達できない等の障害も生じる。このため、魚類等の遡上・降下環境を確保出来るよう魚道を適切に管理していかなければならない。

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------
  点検時には、魚道本体に加え周辺の状況も調査し、魚類等の遡上・降下環境を確保するために、土砂の除去や補修等、魚道の適切な維持管理を行うことを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------

  --------------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

維持管理対策にあたっては、単に現況の機能を維持するだけではなく、現況の遡上状況等を踏まえて補修等にあわせて機能の改善を図ることが望ましい。

魚道が設置されていないこと等により、当該施設が魚類等の遡上・降下の支障となっている場合は、補修等に際して、魚道の設置等の対応を可能な限り実施し、魚類等の遡上・降下環境の確保に配慮するよう努める。

**7．5 ゲート設備**

＜考え方＞

可動堰の機能を維持するため、ゲート設備の維持管理を適切に行うことが重要である。ゲート設備には、以下の機能が求められる。

・ゲートは確実に開閉しかつ必要な水密性及び耐久性を有すること。

・ゲート開閉装置はゲートの開閉を確実に行うことができること。

・ゲートは設計で見込んでいる荷重に対して安全であること。

ゲート設備は、施設の目的、条件により必要とされる機能を長期にわたって発揮する必要がある。しかし、ゲート設備は出水時のみ稼働し通常は休止していることが多いため、運転頻度が低く長期休止による機能低下が生じやすい。

＜標　準＞

+--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| ゲート設備の機能を維持するため、点検により機能及び動作の確認等を行い、効果的・効率的に維持管理を行うことを基本とする。                                                                                                                                                                                                               |
|                                                                                                                                                                                                                                                                                                                                      |
| 大河川におけるゲート設備の点検・整備等や、中小河川における大規模または重要度の高いゲート設備の点検・整備等は、河川用ゲートの点検・整備等に関するマニュアル等^1)2)3)^に基づき実施することを基本とする。                                                                                                                               |
|                                                                                                                                                                                                                                                                                                                                      |
| 整備・更新等の対策の実施にあたっては、点検作業との調整を行うとともに、効率化についても考慮することを基本とする。対策は基本的に専門技術者により実施するものとし、実施にあたっては仮設設備や安全設備の整備等による安全対策等に留意して計画・実施することを基本とする。                                                                 |
|                                                                                                                                                                                                                                                                                                                                      |
| ゲート設備の維持管理を適確に実施していくために、運転、故障、点検、整備、更新等の内容を設備台帳、運転記録等として記録、整理することを基本とする。                                                                                                                                                                                     |
|                                                                                                                                                                                                                                                                                                                                      |
| 整備・更新にあたっては、ゲート設備の機能・目的、設置環境、稼動条件、当該施設や機器等の特性等を考慮し、戦略的に対策を実施していく必要があり、予防保全と事後保全を適確に使い分け、対応することを基本とする。また、点検結果を評価するにあたって、当該設備の社会的な影響度、機器・装置の診断等に基づく健全度の整理を行う事を基本とする。 |
+======================================================================================================================================================================================================================================================================================================================================+

＜推　奨＞

点検結果の評価に基づいて具体の対策を検討し、適切に維持管理計画等へ反映させるよう努める。

中小河川における、大規模または重要度の高いゲート設備を除くそのほかのゲート設備の点検・整備等についても、河川用ゲートの点検・整備等に関するマニュアル等^1)2)3)^に基づき実施することが望ましい。

＜関連通知等＞

1\)
河川用ゲート・ポンプ設備点検・整備・更新検討マニュアル（案）の改定について：平成27年3月31日,国総施安第11号,国水環保第8号,総合政策局公共事業企画調整課施工安全企画室長,水管理・国土保全局河川環境課河川保全企画室長.

2\)
ゲート点検・整備要領（案）：ゲート点検・整備要領検討委員会編,(社)ダム・堰施設技術協会,平成17年1月.

3\)
ダム・堰施設技術基準（案）の一部改定について：平成28年3月31日,国技電第72号,国総公第80号,国水環第140号、国水治第142号,大臣官房技術調査課長、総合政策局公共事業企画調整課長，水管理・国土保全局河川環境課長.

**7．6 電気通信施設**

＜考え方＞

電気通信施設は、堰の操作、制御に直接かかわり、その操作制御及び監視を行うための設備である。このため、高い信頼性が求められており、電気通信施設を構成する機器毎の特性に応じて、適切に点検を行い、機能を維持する必要がある。

＜必　須＞

  -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  電源設備は、通常自家用電気工作物に該当するため、電気事業法（昭和39年法律第170号）により、施設管理者に機能と安全の維持義務が課せられており、具体的な保守業務が適確に遂行されるよう、保安規程の作成、届出及び遵守、電気主任技術者の選任並びに自主保安体制を確保するものとする。
  -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 電気通信施設については、各機器の目的や使用状況（年間の使用頻度や季節的使用特性等）等を考慮して、点検、診断等に関する基準等^1)2)3)^により適切な点検を行い、異常を発見した場合には適切に補修等を行うことを基本とする。 |
|                                                                                                                                                                                                                      |
| なお、電気通信施設については致命的な障害を発生する場合があるため、点検や診断結果等により部品交換等を適切に実施することを基本とする。                                                                                 |
+======================================================================================================================================================================================================================+

＜関連通知等＞

1\) 電気通信施設点検基準（案）：令和元年12月23日,国技電第49号.

2\)
電気通信施設維持管理計画指針（案）：国土交通省大臣官房技術調査課電気通信室,平成30年3月.

3\)
電気通信施設維持管理計画作成の手引き(案)：国土交通省大臣官房技術調査課電気通信室、平成30年3月.

**7．7 付属施設**

＜考え方＞

付属施設としては、管理所、操作室、警報設備、水位観測設備、照明設備、管理用橋梁、管理用階段等があるが、各施設が機能するよう良好な状態に保つ必要があり、付属施設の機能が維持されるよう維持管理する必要がある。

＜標　準＞

+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 可動堰及び土砂吐ゲートを有する固定堰においては、直下流の区間及び操作に伴って水位等が著しく変動する区間に警報設備を設ける必要があるが、堰の直下流400～500m程度の範囲及びゲート等の操作ないしは自動倒伏により30分間で30cm以上水位が上がる区間には警報設備を設置し、異常を発見した場合には適切に補修等を行うことを基本とする。堰の湛水区間で船等の利用がなされている場合にも警報設備を設置し、異常を発見した場合には適切に補修等を行うことを基本とする。 |
|                                                                                                                                                                                                                                                                                                                                                                                                                                                       |
| 点検方法等は、関連する基準^1)2)^等による。                                                                                                                                                                                                                                                                                                                                                                                                            |
+=======================================================================================================================================================================================================================================================================================================================================================================================================================================================+

＜推　奨＞

操作室は河川景観上の重要な要素でもあり、補修等に際しては可能な限り周辺の景観との調和に配慮するよう努める。

＜関連通知等＞

1\)
ダム・堰施設技術基準（案）の一部改定について：平成28年3月31日,国技電第72号,国総公第80号、国水環第140号,国水治第142号,大臣官房技術調査課長、総合政策局公共事業企画調整課長、水管理・国土保全局河川環境課長.

2\) 電気通信施設点検基準（案）：令和元年12月23日,国技電第49号.

**第8節 排水機場**

＜考え方＞

排水機場の維持管理については、河川の規模や重要度等によって適切に行うものである。

**8．1 土木施設**

＜考え方＞

排水機場本体、沈砂池、吐出水槽、排水門等の土木施設は、ポンプが確実に機能を果たせるよう維持管理する必要がある。

排水機場はポンプにより堤防を横断して内水又は河川水を排除するために設けられる施設であり、洪水時に確実に運転できるように、日常の点検と整備が重要である。

土木施設のうち排水機場本体は吸水槽、冷却水槽、燃料貯油槽、地下ポンプ室等によって構成される。これらは、ポンプ設備等の基盤となるものであり、ポンプ機能に支障となるような沈下・変形が生じないよう維持管理することが必要である。特に、ポンプ圧送する排水が周辺に浸出すると、堤防周辺に水みちを形成する原因となるので水密性を確保する必要がある。

＜標　準＞

+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 点検によりポンプ機能や水密性に支障となるおそれがある異常が認められた場合には、原因を究明し、適切な対策を講じることを基本とする。                                                                                                                                                                                                                                                                                 |
|                                                                                                                                                                                                                                                                                                                                                                                                                  |
| コンクリート構造部分のひびわれや劣化については、出水期前の点検等により状態把握を行い、異常を発見した場合には適切に補修等を行うことを基本とする。点検にあたっては、不同沈下や地震等による沈下・変形や、ひびわれや劣化等が新たに発生していないかどうかに着目するとともに、既に発見されている箇所については、状況に応じて計測によりその進行状況を把握し、異常を発見した場合には適切に補修等を行うことを基本とする。 |
+==================================================================================================================================================================================================================================================================================================================================================================================================================+

＜推　奨＞

外水氾濫や内水氾濫等に伴って機場が浸水しポンプの運転に支障を生じる場合があるので、維持管理にあたっては、状況に応じて排水機場の耐水化にも考慮することが望ましい。

(1)沈砂池について

＜考え方＞

沈砂池は、ポンプの摩耗、損傷等を防ぐため流水中の土砂を沈降させるため設けられるものである。

沈降した土砂は、沈砂池の本来の目的を果たすために適切に除去する必要がある。なお、除去するためにクラブバケット等の機械を使用する場合は、底版や側壁コンクリート等を損傷しないよう留意する必要がある。

＜標　準＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 沈砂池は鉄筋コンクリート構造を原則としているので、排水機場本体と同様に、コンクリート構造部分のひびわれや劣化の状態を把握し、異常を発見した場合には適切に補修等を行うことを基本とする。                                                                         |
|                                                                                                                                                                                                                                                                |
| また、大きな沈砂池のため適当な間隔に伸縮継手を設けている場合は、不同沈下によって目地部が開口すると水密性が確保できなくなるので、地盤が軟弱な場合には特に留意し、点検により沈下、変形の状態を把握し、異常を発見した場合には適切に補修等を行うことを基本とする。 |
+================================================================================================================================================================================================================================================================+

(2)吐出水槽について

＜考え方＞

吐出水槽は、一般に堤防に近接して設置されているので、吐出水槽の変状は堤防に悪影響を与えやすい。特に漏水が生じ排水門に沿って水みちが発生すると堤防の安定に著しい影響を及ぼすことがあるので、点検等による異常の早期発見に努める必要がある。

＜標　準＞

+----------------------------------------------------------------------------------------------------------------------------------------------------+
| コンクリート構造部分のひびわれや劣化と両端の継手部の損傷を主な点検項目とし、漏水等の異常が認められたときには、適切な対策を講じることを基本とする。 |
|                                                                                                                                                    |
| また、吐出水槽は一般に覆蓋されないので、ゴミ等の除去や、子供の侵入等の安全対策にも留意することを基本とする。                                       |
+====================================================================================================================================================+

**8．2 ポンプ設備**

＜考え方＞

ポンプ設備は、確実に始動し必要な時間運転継続できる等、必要とされる機能を長期にわたって発揮しなければならないが、水門等のゲート設備と同様に、出水時のみ稼働し通常は休止しているため、運転頻度が低く長期休止による機能低下が生じやすい。したがって、当該ポンプ設備の設置目的、装置・機器等の特性、設置条件、稼働形態、機能の適合性等を考慮して維持管理対策の最適化に努め、ポンプ設備の信頼性を確保しつつ効率的・効果的に維持管理することが必要である。

整備・更新等の対策は、設備の機能を保持し、信頼性を確保することを目的として、戦略的かつ確実に実施する必要がある。

＜標　準＞

+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| > ①大河川におけるポンプ設備の点検・整備等は、ポンプ設備の点検・整備等に関するマニュアル等^1)2)3)^に基づき実施することを基本とする。なお、救急排水ポンプについても同様な維持管理を行うことを基本とする。 |
| >                                                                                                                                                                                                       |
| > ②ポンプ設備は、点検により機能及び動作の確認等を行い、効果的・効率的に維持管理対策を行うことを基本とする。                                                                                             |
| >                                                                                                                                                                                                       |
| > ③ポンプ設備の整備・更新等の対策は、予防保全、事後保全に分けて戦略的に実施することを基本とする。                                                                                                       |
| >                                                                                                                                                                                                       |
| > ④整備・更新等の対策の実施にあたっては、点検作業との調整を行うとともに、同時に実施する機器の範囲を設定するなど効率化することを基本とする。                                                             |
| >                                                                                                                                                                                                       |
| > ⑤整備・更新等の対策は基本的に専門技術者により実施するものとし、実施にあたっては仮設設備や安全設備の整備等による安全対策等に留意して計画・実施することを基本とする。                                   |
| >                                                                                                                                                                                                       |
| > ⑥ポンプ設備の維持管理を適確に実施していくために、運転、故障、点検、整備、更新等の内容を整備台帳、運転記録等として記録、整理することを基本とする。                                                     |
| >                                                                                                                                                                                                       |
| > ⑦ポンプ設備の整備・更新等の対策を戦略的に実施するため、点検結果を評価するにあたって、当該設備の社会的な影響度、機器・装置の診断等に基づく健全度等の整理を行うことを基本とする。                       |
+=========================================================================================================================================================================================================+

＜推　奨＞

中小河川におけるポンプ設備の点検・整備等についても、ポンプ設備の点検・整備等に関するマニュアル等^1)2)3)^に基づき実施することが望ましい。

＜関連通知等＞

1\)
揚排水機場設備点検・整備指針（案）の制定について：平成20年6月27日,国技電第56号,国総施第111号,国河治第151号,技術調査課長,建設施工企画課長,治水課長.

2\)
河川用ゲート・ポンプ設備点検・整備・更新検討マニュアル（案）の改定について：平成27年3月31日,国総施安第11号,国水環保第8号,総合政策局公共事業企画調整課施工安全企画室長,水管理・国土保全局河川環境課河川保全企画室長.

3\)
揚排水ポンプ設備技術基準の改定について：平成26年3月31日,国技電第59号,国総公第146号,国水環第14号,国水治第189号.

**8．3 電気通信施設**

＜考え方＞

電気通信施設は、構成する機器毎の特性に応じて、適切に点検を行い、機能を維持する必要がある。

＜標　準＞

  -----------------------------------------------------------------------------------
  電気通信施設については、第6章第7節7.6に準じて適切に維持管理することを基本とする。
  -----------------------------------------------------------------------------------

  -----------------------------------------------------------------------------------

**8．4 機場上屋**

＜考え方＞

機場上屋は、ポンプ設備等への悪影響、操作への支障及び操作環境の悪化が生じないよう、適切に維持管理する必要がある。そのため、雨漏りや換気の悪化等による機器や電気通信施設の劣化等を生じないよう留意する必要がある。

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------
  住宅等が近いため騒音対策として防音構造としている場合は、防音構造の点検を行い、その効果が確実に発揮されているか確認することを基本とする。
  ------------------------------------------------------------------------------------------------------------------------------------------

  ------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

機場上屋の外装を補修する時には、周辺の景観との調和にも配慮することが望ましい。

**第9節 陸閘**

＜考え方＞

陸閘は、堤内外の交通等のため、止むを得ず堤防の一部を切開いておき、平時は交通等の用に供し、洪水又は高潮又は津波の際は閉鎖して、堤内への洪水・高潮の流入を防止するための施設である。陸閘の維持管理については、河川の規模や重要度等によって適切に行うものである。

陸閘のゲート設備の維持管理には第6章第7節7.5を、陸閘の電気通信施設の維持管理には第6章第7節7.6を準用して適切に維持管理を行うものである。

＜標　準＞

+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 確実にゲート操作が行え、堤防としての機能を果たせるよう常に良好な状態を保持するために以下の項目に留意し、異常を発見した場合には適切に補修等を行うことを基本とする。                                                     |
|                                                                                                                                                                                                                        |
| なお、ゲートが角落し構造の場合は、角落し材の数量、保管場所等を把握することを基本とする。                                                                                                                               |
|                                                                                                                                                                                                                        |
| ①コンクリート擁壁                                                                                                                                                                                                      |
|                                                                                                                                                                                                                        |
| > ・コンクリートの破損、クラック                                                                                                                                                                                       |
| >                                                                                                                                                                                                                      |
| > ・継ぎ手部のずれ、傾き                                                                                                                                                                                               |
| >                                                                                                                                                                                                                      |
| > ・堤体との取付部の開口                                                                                                                                                                                               |
|                                                                                                                                                                                                                        |
| ②通路                                                                                                                                                                                                                  |
|                                                                                                                                                                                                                        |
| > ・コンクリートの破損                                                                                                                                                                                                 |
| >                                                                                                                                                                                                                      |
| > ・不同沈下                                                                                                                                                                                                           |
| >                                                                                                                                                                                                                      |
| > ・レールの切損、土砂、ゴミ等の堆積                                                                                                                                                                                   |
|                                                                                                                                                                                                                        |
| ③ゲート設備                                                                                                                                                                                                            |
|                                                                                                                                                                                                                        |
| 陸閘のゲートは、洪水や高潮の堤内への流入防止を実現する重要な施設であり、確実に開閉し、かつ、必要な水密性及び耐久性について確認を行う。なお、角落し構造の場合には、必要が生じた場合には直ちに使用可能な状態としておく。 |
+========================================================================================================================================================================================================================+

**第10節 河川管理施設の操作**

＜考え方＞

河川管理施設の操作にあたっては、降水量、水位、流量等を確実に把握し、操作規則又は操作要領に定められた方法に基づき適切に行う必要がある。

このため、水位観測施設や雨量観測施設が設置されているが、洪水時等に故障しないように、また正確なデータが得られるように維持管理する必要がある。

＜必　須＞

  -----------------------------------------------------------------------------------------------------------------------------
  河川管理施設の操作は、法第14条、令第8条に該当する施設^1)^については、作成基準^2)^に基づいて操作規則を定める^3)^ものとする。
  -----------------------------------------------------------------------------------------------------------------------------

  -----------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 該当しない施設にあっても操作要領を定めることを基本とする。河川管理施設の操作にあたっては、水位制御や流量制御の基本数値である降水量、水位、流量等を確実に把握することを基本とする。                                                         |
|                                                                                                                                                                                                                                            |
| 樋門等の河川管理施設の操作を法第99条に基づき地方公共団体に委託する場合は、適切に操作委託協定書等を締結し^4)^、個人に操作を委嘱する場合には、通知^5)^等に則り適切に任命するとともに、水門等操作観測員就業規則等を作成することを基本とする。 |
+============================================================================================================================================================================================================================================+

＜推　奨＞

樋門等において、津波や出水時における水門等操作観測員の安全確保^2)^等の観点から、自動化・遠隔操作化を進めてきているが、突発的な事故等により手動操作や機側操作が必要となる場合もあるので、水門等操作観測員の安全を確保しつつ必要な体制の確保を図るとともに、水門等操作観測員の技術の維持に努めることが望ましい。

河川管理施設の電気通信施設の操作について、単体施設及び通信ネットワークの機能の維持、出水時の運用操作技術への習熟、障害時の代替通信手段の確保等を目的として、定期的に操作訓練を行うよう努めることが望ましい。

＜関連通知等＞

1\)
河川管理施設の操作規則の取り扱いについて：昭和55年5月21日,建河政発第41号,河治発第35号,水政課長,治水課長.

2\) 河川管理施設の操作規則の作成基準の改正について：平成30年4月24日,
国水環第3号,河川環境課長.

3\) 河川管理施設の操作規則について：昭和42年2月22日,建河政発第10号,
河川局長.

4\)
河川管理施設の操作の委託について：平成24年3月9日,国水環第106号,河川環境課長.

5\)
水門等操作員の国家公務員の認定について：昭和54年5月9日,建人発第867号,建設省河治発第40号,人事課長,治水課長.

6\)
「樋門等の操作規則・操作要領作成における操作員退避検討に当たってのガイドライン」の改正について:令和1年6月21日,国土交通省水管理・国土保全局河川環境課,河川保全企画室長.

**第11節 許可工作物**

**11．1 基本**

＜考え方＞

許可工作物の点検は、施設管理者により実施されることが基本であり、河川管理施設に準じた適切な維持管理がなされるよう、許可にあたっては必要な許可条件を付与するとともに、設置後の状況によっては指導・監督等を実施する必要がある。

河川管理施設と同種の許可工作物は第6章第1節から第10節に準じて施設管理者により適切に維持管理される必要がある。河川管理施設にない工種の許可工作物も多数あり、主な施設については、第6章第11節11.2から11.5に示すが、他の施設についても本基準の主旨を踏まえて適切に維持管理がなされるようにする必要がある。許可工作物にあっても、河川管理施設と同様に設置後長期間を経過した施設が増加してきており、施設の老朽化の状況等に留意する必要がある。

＜関連通知等＞

1\) 許可工作物に係る施設維持管理技術ガイドラインについて:
平成26年3月31日, 水政課河川利用企画調整官、河川環境課河川保全企画室長.

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------
  許可工作物と堤防等河川管理施設の接合部は弱点部となりやすいので、そのような箇所については河川管理者が必要な点検を行うことを基本とする。
  ----------------------------------------------------------------------------------------------------------------------------------------

  ----------------------------------------------------------------------------------------------------------------------------------------

**11．2 伏せ越し**

＜考え方＞

伏せ越しは、用排水路等が河川と交差する場合に、河川を横過して河床下に埋設される水路構造物である。河床変動や局所洗掘によって本体が露出すると、本体が危険になるとともに、洪水の流下を妨げ、周辺の局所的な深掘れを助長して河道及び河川管理施設等に悪影響を及ぼす。

直接基礎で施工されている伏せ越しは、堤防横過部分と河床横過部分の土被りの厚さの相違等によって不同沈下を起こしやすい。一方、軟弱地盤上に杭基礎で施工されている伏越しは、基礎地盤の沈下に伴う函体底版下の空洞化が生じやすい。特に堤防下の部分については、堤体と函体との間に変状が生じやすく、第6章第6節6.1で記したような本体周辺における空洞の発生や水みちの形成が懸念されるので、維持管理対策にあたっては堤防の弱点としないよう漏水の防止に留意する必要がある。

＜標　準＞

+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 異常を発見した場合には速やかに施設管理者に通知するとともに、適切な対策が講じられるよう指導監督することを基本とする。                                                                                                                                                               |
|                                                                                                                                                                                                                                                                                    |
| 特に伏せ越し及び河底横過トンネルのゲートは、万一本体の折損事故が生じても流水が河川外に流出することがないよう「非常用」として設置されているものであるので、使用する頻度は少ないが、災害を防止するための重要な施設であり、適切に維持管理がなされるよう指導監督することを基本とする。 |
+====================================================================================================================================================================================================================================================================================+

**11．3 取水施設**

＜考え方＞

河道や付近の河岸及び河川管理施設等に支障を及ぼさないよう適切に取水施設の維持管理がなされるようにする必要がある。

取水樋門は第6章第6節を準用して適切に維持管理されるようにすることとなる。

取水樋門には取水口から樋門までの間に堤外導水路が設けられている場合があるが、堤外導水路については第6章第11節11.5を参考とする。

揚水機場の河川に関する部分については、第6章第8節を準用して適切な維持管理がなされるよう留意する必要がある。

＜標　準＞

+--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 河道内に設置されている取水塔は、周辺で局所洗掘を生じる等、取水塔の安全性に問題がない場合でも河道及び河川管理施設等に悪影響を及ぼす可能性があることから、適切な対策が講じられるよう指導監督を行うことを基本とする。                               |
|                                                                                                                                                                                                                                                  |
| 取水樋門周辺堤防に影響のある変状等が見られた場合には速やかに適切な対策が講じられるよう指導監督を行うことを基本とする。                                                                                                                           |
|                                                                                                                                                                                                                                                  |
| 取水塔の付属施設として集水埋渠や送水管が設けられている場合は、点検にあたって次の点に留意して維持管理されるよう指導監督することを基本とする。                                                                                                     |
|                                                                                                                                                                                                                                                  |
| (1)集水埋渠について                                                                                                                                                                                                                              |
|                                                                                                                                                                                                                                                  |
| > 集水埋渠は、河床が低下して露出すると、管の折損による被害だけでなく、乱流の原因となり河床洗掘を助長し、周辺の河川管理施設等に悪影響を及ぼすことになるので、洪水時でも集水埋渠が露出することがないよう十分な深さが確保されていることを確認する。 |
|                                                                                                                                                                                                                                                  |
| (2)送水管について                                                                                                                                                                                                                                |
|                                                                                                                                                                                                                                                  |
| 堤防を横過している送水管は、漏水による堤防弱体化の要因となる可能性があるので、漏水が生じていないことを確認する。                                                                                                                                 |
+==================================================================================================================================================================================================================================================+

**11．4 橋梁**

**11．4．1 橋台**

＜考え方＞

堤防に設ける橋台は、振動により堤体に間隙や空洞等が生じて、漏水を助長する一因となるおそれがあるため、堤防等に悪影響を与えないよう適切な維持管理がなされることが必要である。

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------
  出水期前の点検等において、橋台付近の堤体ひび割れ等の外観点検及び必要に応じた詳細な調査、それに基づく補修等の適切な対策が施設管理者によりなされることを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

橋台周辺の堤防あるいは護岸の点検については、河川管理者も必要な箇所において実施する必要があり、堤体の外観点検については施設管理者と河川管理者が共同で行うことが望ましい。

**11．4．2 橋脚**

＜考え方＞

河道内に設置されている橋脚周辺には、局所洗掘を生じることが多い。橋脚は局所洗掘深を想定して設計することとなっているので、局所洗掘が生じると直ちに全ての橋脚が危険ということではないが、局所洗掘は橋脚に対する影響だけでなく、河道や河川管理施設に悪影響を及ぼす可能性があるので留意する必要がある。

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  洗掘による橋脚の安全性の確認は施設管理者によるが、河川管理者として橋脚周辺の洗掘形状（最大洗掘深、洗掘範囲）等を把握し河川管理上の支障を認めた場合には、施設管理者に通知するとともに適切な指導監督を行うことを基本とする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

**11．4．3 取付道路**

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------
  橋梁の取付道路部の舗装のひびわれ等は、水みちの形成の原因となるので、道路管理者によりすみやかに補修されるよう指導監督等を実施することを基本とする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------

  ----------------------------------------------------------------------------------------------------------------------------------------------------

**11．5 堤外・堤内水路**

＜考え方＞

堤外・堤内水路については、水路の機能が維持されるとともに、堤防等に悪影響を与えないよう適切な維持管理がなされるようにする必要がある。

＜標　準＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| (1)堤外水路について                                                                                                                                                                                                                                                                                                                                            |
|                                                                                                                                                                                                                                                                                                                                                                |
| 堤外水路は、流水による損傷を受けやすいので、点検により異常を早期に発見し、補修されるよう適切に指導監督等を行うことを基本とする。堤防に沿って設置された水路の損傷は、堤防の洗掘及び漏水を助長する原因になるので、特に留意して維持管理されるよう指導監督することを基本とする。状況によって、護岸や高水敷保護工を増工する等の指導監督をおこなうことも基本とする。 |
|                                                                                                                                                                                                                                                                                                                                                                |
| (2)堤内水路について                                                                                                                                                                                                                                                                                                                                            |
|                                                                                                                                                                                                                                                                                                                                                                |
| 堤内水路については、第6章第2節2.1.6に準じて適切な維持管理がなされるよう適切に指導監督することを基本とする。                                                                                                                                                                                                                                                    |
+================================================================================================================================================================================================================================================================================================================================================================+

**第7章　河川区域等の維持管理対策**

**第1節 一般**

(1)河川区域の維持管理

①河川区域境界及び用地境界について

＜考え方＞

河川区域の土地の維持管理を適正に行う前提として、官民の用地境界等を明確にしておく必要がある。

＜標　準＞

  -----------------------------------------------------------------------
  官民境界杭等を設置することを基本とする。
  -----------------------------------------------------------------------

  -----------------------------------------------------------------------

＜推　奨＞

官民境界杭等については、破損や亡失した場合に容易に復旧できるよう、その位置を座標により管理することが望ましい。また、必要に応じて河川管理者名等を明記した標識等を設置し、官民の用地境界等の周知に努める。

②河川敷地の占用について

＜考え方＞

河川敷地の占用許可は、河川敷地の適正利用が図られるよう河川敷地占用許可準則等^1)2)3)^に照らし合わせて、審査するものである。地域に密着している河川敷地の利用等に関しては、できるだけ地元市町村等の主体性が尊重されるよう、市町村等が参画できる範囲を拡大するための措置としての包括占用許可の活用についても検討する必要がある。また、都市再生、地域再生等に資する占用許可についても、地域の合意を図りつつ適切に対処する必要がある。

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  河川敷地において公園、運動場等の施設を占用許可した場合には、当該施設の適正利用・維持管理等は許可条件、占用申請書に添付された維持管理計画に従って占用者が行うこととなり、河川管理者は維持管理等の行為が許可条件及び当該計画どおりに適切に行われるように占用者を指導監督することを基本とする。その際、種々の工作物が整備される場合があるが、河川区域内の工作物の設置許可にあたっては、河川区域内の民有地に設置される工作物についても同様に、河川管理の支障とならないよう工作物設置許可基準等^4)5)^に基づいて適切に審査することを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1\)
河川敷地の占用許可について：平成11年8月5日,建河政発第67号,建設事務次官.

2\) 河川敷地の占用許可について：平成11年8月5日,建河政発第68号,河川局長.

3\)
河川敷地占用許可準則の一部改正について：平成17年3月28日,建河政発第140号,河川局長.

4\) 工作物設置許可基準について：平成6年9月22日,建河治発第72号,治水課長.

5\) 改訂
解説・工作物設置許可基準：河川管理技術研究会編,(財)国土技術研究センター,山海堂,平成10年11月.

(2)高規格堤防特別区域の維持管理

＜考え方＞

高規格堤防は、その敷地である土地の区域内の大部分の土地において通常の利用がなされることを前提としているため、当該敷地のうち表法肩から普通の堤防における計画天端幅までの地点より堤内地側の土地は、河川区域よりも規制緩和された高規格堤防特別区域に指定される。高規格堤防特別区域においては、高規格堤防の治水上の機能の保持に支障が及ばないよう、河川巡視等を通じて適切に維持管理するものである。

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  高規格堤防特別区域が通常の土地利用に供される区域であることから、当該区域の範囲の確認が困難となることを未然に防止するために、高規格堤防特別区域の位置及び範囲を掲示する立札を現地に設置することを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

(3)樹林帯区域の維持管理

＜考え方＞

河川の堤防に沿った樹林には、洪水時の越水による堤防裏法尻部の洗掘の防止や破堤時における氾濫流の抑制による破堤部の拡大防止といった治水上の機能が認められる^1)^ため、河川管理者による積極的な整備や管理が必要である。

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  樹林帯の土地の区域界は外形上明確でないため、河川管理者が樹林帯区域を指定して公示し、河川現況台帳に樹林帯区域の区間及び幅を記載するとともに、現地には、樹林帯区域の位置、範囲及び規制行為等を掲示する立札を設置することを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1\) 堤防に沿った樹林帯の手引き：平成13年8月,
編著：（財）河川環境管理財団発行：（株）山海堂.

(4)河川保全区域及び河川予定地の維持管理

＜考え方＞

河川保全区域は、河岸又は河川管理施設等（樹林帯を除く）の保全のために必要な河川区域に隣接する一定の区域を指定し、土地の掘削等土地の形状の変更や工作物の新改築の行為を規制するものである。

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  河川保全区域については、河岸又は河川管理施設等（樹林帯を除く）の保全に支障を及ぼさないように、巡視等により状況を把握することを基本とする。河川予定地については、河川保全区域に準じて維持管理を行うとともに、河川管理者が権原を取得した河川予定地については、河川区域に準じて維持管理を行うことを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

(5)廃川敷地の管理

＜考え方＞

改修工事の完成等に伴い、河川区域の変更又は廃止の見込みがある場合は、治水上、利水上及び河川環境上の観点から河川区域の土地としての必要性について十分検討することが必要である。

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  河川区域の土地として不要である場合には、河川区域内の土地の管理等に関する通知^6)^等に則り当該河川区域の変更又は廃止とともに旧国有河川敷地の廃川処分を適切に行うことを基本とする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1\)
河川区域内の土地の管理等について：平成21年2月5日,国河政第86号,国河環第79号,国河治第118号,水政課長,河川環境課長,治水課長.

＜推　奨＞

廃川処分にあたっては、法第92条による新たに河川区域となる土地との交換の措置を活用することが望ましい。

(6)河川の台帳の調製

＜考え方＞

河川区域、河川保全区域、河川予定地、河川保全立体区域及び河川予定立体区域においては、種々の行為の制限が行われる。また、河川においては、流水の占用その他各種の河川使用が行われている。したがって、河川管理者がその河川管理事務を円滑、的確に遂行するとともに、私人の権利義務の関係を明確にするためにも、河川の一級、二級等の別、河川区域等の範囲、主要な河川管理施設の所在、種類、河川使用の許可の内容等の河川管理の基礎となる事項を網羅して、河川管理に従事する者または河川に関して利害関係を有する者等が必要な場合は、いつでも確知できるようにしておく必要がある。

＜必　須＞

  -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  河川管理者は、法第12条第1項に基づき河川の台帳を調製し、保管しなければならない。台帳の調製は、河川法施行規則第5条及び第6条に規定する記載事項に関して漏れの無いよう、適切な時期に実施するものとする。
  -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

**第2節 不法行為への対策**

**2．1 基本**

＜考え方＞

河川における不法行為の主なものは以下のとおりであり、各々について適切に対応する必要がある。

> ①流水の占用関係：不法取水、許可期間外の取水、許可条件違反
>
> ②土地の占用関係：不法占用、占用範囲の逸脱、許可条件違反、不法係留
>
> ③産出物の採取に関する状況：盗掘、不法伐採、採取位置や仮置きの違反、汚濁水の排出
>
> ④工作物の設置状況：不法工作物の設置、工作物の許可条件等からの違反
>
> ⑤土地の形状変更状況：不法掘削・堆積、形状変更の許可条件等からの違反
>
> ⑥竹木の流送やいかだの通航状況：竹木の不法な流送、舟又はいかだの不法な通航
>
> ⑦河川管理上支障を及ぼすおそれのある行為の状況：河川の損傷、ごみ等の投棄、指定区域内の車両乗り入れ、汚水の排出違反、船舶の放置等
>
> ⑧河川保全区域及び河川予定地における行為の状況：不法工作物の設置、不法な形状変更

不法行為については、河川巡視の一般巡視の中で状況を把握することが重要である。さらに、不法行為による治水への影響、河川利用者への影響、水防活動への影響等により重点的な巡視が必要な場合には、目的別巡視等により対応することが重要である。不法行為の内容によっては、市町村、警察等の関係機関とも連携した河川巡視等を検討する必要がある。

＜標　準＞

+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 不法行為を発見し、行為者が明らかな場合には、速やかに除却、原状回復等の指導を行い、行為者が不明な場合には警告看板を設置する等、必要な初動対応を行い、法令等に基づき適切かつ迅速に不法行為の是正のための措置を講じることを基本とする。不法行為の対応に関する一般的な処理フローは図7-1を基本とする。 |
|                                                                                                                                                                                                                                                                                                   |
| ![](media/image2.emf){width="5.501388888888889in" height="6.6715277777777775in"}                                                                                                                                                                                                                  |
|                                                                                                                                                                                                                                                                                                   |
| 図7-1　不法行為の一般的な処理フロー                                                                                                                                                                                                                                                               |
+===================================================================================================================================================================================================================================================================================================+

＜推　奨＞

悪質な不法行為に関しては、必要に応じて刑事告発を行う。

**2．2 ゴミ、土砂、車両等の不法投棄**

＜考え方＞

ゴミ、土砂、車両等の不法投棄に関しては、関係機関、地域住民等と連携強化し、地域住民等への不法投棄の通報依頼、地域と一体となった一斉清掃の実施、河川巡視の強化、警告看板の設置、車止めの設置等により、その未然防止に努める必要がある。

＜標　準＞

  ---------------------------------------------------------------------------------------------------------------------------------------------
  不法投棄を発見した場合には、行為者の特定に努め、行為者への指導監督、撤去等の対応を適切に行うものとし、図7-1により対応することを基本とする。
  ---------------------------------------------------------------------------------------------------------------------------------------------

  ---------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

ゴミ等の不法投棄は夜間や休日に行われやすいことから、行為者の特定等のため、必要に応じて夜間や休日の河川巡視等を実施する。

**2．3 不法占用（不法係留船を除く。）への対策**

＜考え方＞

不法係留を除く不法占用に関しては、図7-1を基本として、個々の状況に照らして迅速かつ適正に是正のための措置を講じる必要がある。なお、ホームレスによる不法占用については、ホームレスの自立の支援等に関する特別措置法（平成14年法律第105号）等を踏まえ、自治体の福祉部局等と連携して是正のための措置を講じる必要がある。

＜標　準＞

  -----------------------------------------------------------------------------------------------------------------------------------------------------------------
  不法占用（不法係留船を除く。）を発見した場合には、行為者の特定に努め、速やかに除却、原状回復等の指導監督等を行うものとし、図7-1により対応することを基本とする。
  -----------------------------------------------------------------------------------------------------------------------------------------------------------------

  -----------------------------------------------------------------------------------------------------------------------------------------------------------------

**2．4 不法係留船（放置艇）への対策**

＜考え方＞

不法係留船の数が多い等の理由により計画的な不法係留船対策を講じる必要がある河川については、不法係留船対策に関する通知^1)2)^に則り不法係留船対策に係る計画を地域の実態に応じて水系又は主要な河川毎等に策定し、不法係留船の計画的な撤去を行う必要がある。また、平成26年4月より河川法施行令第16条の4第1項が改正され、河川管理者は河川毎に放置等を禁止する対象物を指定することができるようになった。ただし、不法係留船対策の実施にあたり、地域の慣行を踏まえ、生業を行うために必要な船舶とレジャーの用に供する船舶とで扱いを異にすることは、不合理ではない。

その他の河川においても、河川管理上の必要性に応じ、不法係留船の強制的な撤去措置を適正に実施する必要がある。

＜関連通知等＞

1\)
計画的な不法係留船対策の促進について：平成10年2月12日,建河政発第16号,河川局長,河川六法,河川法研究会編集,平成22年度版,大成出版社.

2\)
計画的な不法係留船対策の促進について：平成10年6月19日,建河政発第62号,建河環発第21号,建河治発第42号,水政課長,河川環境課長,治水課長,河川六法,河川法研究会編集,平成22年度版,大成出版社.

＜標　準＞

+--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 河川区域内に不法係留船がある場合には、是正のための対策を適切に実施することを基本とする。不法係留船の強制的な撤去に関する手続きは、図7-1の処理フローを基本とする。具体の係留・保管施設の設置の可否等の判断は、図7-2の手順によることを基本とする。 |
|                                                                                                                                                                                                                                                  |
| ![](media/image3.png){width="4.531944444444444in" height="5.225in"}                                                                                                                                                                              |
|                                                                                                                                                                                                                                                  |
| 図7-2　船舶係留施設等の一般的な設置フロー                                                                                                                                                                                                        |
+==================================================================================================================================================================================================================================================+

(1)不法係留船の定義

＜必　須＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 不法係留船とは、法第24条、第26条等の規定に基づく河川管理者の許可を得ずして河川区域内に係留している船舶であり、当該船舶がプレジャーボート等のレジャーの用に供するものであるか、漁船等の事業の用に供するものであるかを問わないものとする。           |
|                                                                                                                                                                                                                                                    |
| なお、船舶が係留施設を設置することなく錨や橋脚に縄を結びつけること等により係留する場合においても、当該係留が通常の一時係留でないにも拘わらず、法第24条等の規定に基づく河川管理者の許可を得ずして係留している場合には、当該船舶は不法係留船とする。 |
+====================================================================================================================================================================================================================================================+

(2)不法係留船対策に係る計画

＜標　準＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 不法係留船対策に係る計画の内容は、①重点的撤去区域（不法係留船の係留による河川管理上の支障の程度等を勘案し、重点的に強制的な撤去措置をとる必要があると認められる河川の区域）の設定に係る年次計画及び同区域における不法係留船の強制的な撤去措置に係る年次計画、②暫定係留区域における暫定係留施設の設置に係る年次計画（暫定係留区域が存する場合に限る。）、③斜路及び船舶上下架施設の設置に係る年次計画、④河川における恒久的係留・保管施設の整備に係る年次計画（他の公共水域及び陸域における恒久的係留・保管施設の整備（民間主体が整備するものを含む。）に係る計画を添付する。）等を定めることを基本とする。 |
|                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| 重点的撤去区域の設定に係る年次計画の策定にあたっては、重点的撤去区域は年次的に拡大していくべきであり、恒久的係留・保管施設の設置が認められた区域を除いて、最終的には全ての河川の区域が重点的撤去区域になっていくべきものである。                                                                                                                                                                                                                                                                                                                                                                         |
+==========================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================+

(3)係留・保管施設の設置

＜考え方＞

恒久的な係留・保管施設の設置は、工作物設置許可基準^3)4)^等に基づいて検討するものであり、死水域や洪水時における流量配分のない河川、遊水地等の洪水の流下しない河川の区域への設置が望ましい。また、洪水の流下する河川への設置は、洪水時等に低水路河岸、高水敷、堤防、他の工作物等へ影響を及ぼす可能性があるため基本的には望ましくはないが、係留・保管施設の設置が、治水上、利水上、河川環境上支障がなく、必要やむを得ないと認められる場合にはこの限りでない。

暫定係留施設は、洪水時、高潮時等における治水上の支障のおそれが少なく、かつ、河川環境の保全上も比較的問題のない場所のうち、係留施設の適切な構造及び係留船舶の適切な管理方法と相まって、治水上及び河川環境上支障のない場所において設置することができる。

[＜必　須＞]{.mark}

  ------------------------------------------------------------------------------------------
  恒久的な係留・保管施設の設置は、工作物設置許可基準^1)2)^等に基づいて検討するものとする。
  ------------------------------------------------------------------------------------------

  ------------------------------------------------------------------------------------------

＜関連通知等＞

1\) 工作物設置許可基準について：平成6年9月22日,建河治発第72号,治水課長.

2\) 改訂
解説・工作物設置許可基準：河川管理技術研究会編,(財)国土技術研究センター,山海堂,平成10年11月.

**2．5 不法な砂利採取等への対策**

＜考え方＞

河川砂利の採取に関しては、河川砂利基本対策要綱^1)^、砂利採取計画認可準則^2)^、砂利等採取許可準則^3)^等^4)^に従わなければならないものである。さらに、砂利等の採取に関する規制計画^5)^が策定されている区間については、同計画に基づいて計画的に採取を実施させるよう指導する必要がある。

また、河川砂利の採取の前後には立会検査を行うとともに、深掘りによる治水上の影響、水位低下等による取水への影響、水質、生態系、景観等の河川環境への影響に十分留意し、巡視等により状況を把握する必要がある。

＜関連通知等＞

1\)
河川砂利基本対策要綱の改定及びその運用について：昭和49年4月30日建河計発第42号建設事務次官,河川六法,河川法研究会編集,平成22年度版,大成出版社.

2\)
砂利採取計画認可準則について：昭和43年10月2日,43化局第491号,建河政発第99号,通商産業省化学工業局長,河川局長,河川六法,河川法研究会編集,平成22年度版,大成出版社.

3\)
砂利等採取許可準則について：昭和49年7月22日,建河治発第61号,建設事務次官,河川六法,河川法研究会編集,平成22年度版,大成出版社.

4\)
河川砂利の用途規制について：昭和42年4月19日,建河計発第81号,建設事務次官,河川六法,河川法研究会編集,平成22年度版,大成出版社.

5\)
砂利等の採取に関する規制計画の策定及び特定採取制度について：昭和49年7月22日,建河治発第62号,治水課長,河川六法,河川法研究会編集,平成22年度版,大成出版社.

＜標　準＞

+------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 河川区域内又は河川保全区域内の土地における砂利等の採取については、河川管理上の支障が生じないよう定期的な巡視等による監視を行い、採取者を指導監督することを基本とする。 |
|                                                                                                                                                                        |
| 不法行為を発見した場合には、迅速かつ適正な指導監督による対応を行うことを基本とする。砂利採取等に係る不法行為の対応に関する一般的な処理フローは図7-3を基本とする。      |
|                                                                                                                                                                        |
| なお、砂利以外の河川の産出物には、土石、竹木、あし、かや等があるが、これらの採取についても同様の措置を行うことを基本とする。                                           |
|                                                                                                                                                                        |
| ![](media/image4.png){width="1.8631944444444444in" height="5.733333333333333in"}                                                                                       |
|                                                                                                                                                                        |
| 図7-3 不法な砂利採取等行為の一般的な設置フロー（※は砂利採取の場合）                                                                                                    |
+========================================================================================================================================================================+

＜推　奨＞

悪質な不法砂利採取等に関しては、必要に応じて刑事告発を行う。

**第3節 河川の適正な利用**

**3．1 基本**

＜考え方＞

河川の適正な利用が為されるよう、河川巡視では、以下のような状況を把握する必要がある。

> ①危険行為等：危険な利用形態、不審物・不審者の有無、他の河川利用等へ悪影響を及ぼす迷惑行為
>
> ②河川区域内における駐車や係留等：河川区域内の駐車、係留・水面利用等の状況
>
> ③河川区域内の利用：イベント等の開催状況、施設の利用状況、河川環境に悪影響を及ぼす利用形態

＜標　準＞

  ----------------------------------------------------------------------------------------------------
  河川利用は常時行われるものであり、日常の河川の利用状況の把握は河川巡視により行うことを基本とする。
  ----------------------------------------------------------------------------------------------------

  ----------------------------------------------------------------------------------------------------

＜推　奨＞

河川空間の利用に関する情報収集として、河川利用者数、利用形態等に関して特に把握が必要な場合には、重点的な目的別巡視や別途調査を実施することが望ましい。

**3．2 河川の安全な利用**

＜考え方＞

河川管理者は、関係行政機関や河川利用者等とともに、河川に内在する様々な危険や急な増水等による水難事故の可能性を認識した上で、必要な対応に努めることが必要である。

また、利用者の自己責任による安全確保とあわせて、河川利用の安全に資するため、安全利用点検に関する実施要領^1)^に基づいて関係施設の点検を行うものである。

＜標　準＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 占用地以外の河川利用に対する危険又は支障を認めた場合には、河川や地域の特性等も考慮して陥没等の修復、安全柵の設置、危険性の表示、情報提供、河川利用に伴う危険行為禁止等の教育・啓発の充実等の必要な対応を検討することを基本とする。                                                                 |
|                                                                                                                                                                                                                                                                                                    |
| 占用地については、利用者等に対する重大な危険又は支障があると認める場合において許可受者が詳細点検、対策検討、措置等を行うものであるが、許可受者から河川管理者に対し、詳細点検や対策検討及び措置を共同で行うよう協議があった場合には、状況に応じて共同して必要な対応を検討することを基本とする^2)^。 |
+====================================================================================================================================================================================================================================================================================================+

＜関連通知等＞

1\)
河川(水面を含む)における安全利用点検の実施について(改訂)：平成21年3月13日,国河環第106号,国河治第146号,河川環境課長,治水課長.

2\)
河川の利用者等の安全確保の一層の推進について：平成26年9月25日,国水政第47号,国水環第62号,水政課長,河川環境課長.

**3．3 水面利用**

＜考え方＞

船舶等の通航方法等の指定にあたっては、通航方法の指定に関する準則^1)^に則り関係者の意見を聴くとともに、他の関係機関とも協議を行うものである。また、海上交通法規及びいわゆる水上安全条例が施行されている場合、それらとの整合性を図るものである。

＜標　準＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 河川管理を適正に行いつつ河川における舟運の促進を図る必要がある河川区域については、状況に応じて、船舶等が円滑に通航できるようにするための船舶等の通航方法等を指定することを基本とする。 |
|                                                                                                                                                                                        |
| 通航方法を指定した場合には、通航標識に関する準則^2)^に則り通航の制限についての通航標識等を設置することを基本とする。                                                                   |
+========================================================================================================================================================================================+

＜関連通知等＞

1\)
河川における船舶の通航方法の指定等についての準則：平成10年6月10日,建河政発第56号,建設事務次官,河川六法,河川法研究会編集,平成22年度版,大成出版社.

2\)
河川通航標識等設置準則：平成10年6月10日,建河政発第57号,河川局長,河川六法,河川法研究会編集,平成22年度版,大成出版社.

**第8章 河川環境の維持管理対策**

＜考え方＞

河川環境の維持管理においては、河川における生息・生育・繁殖環境として特に重要となる箇所を把握しその環境を保全する等、河川整備計画等に基づく河川環境の保全あるいは整備がなされるよう維持管理を行う必要がある。

具体的な対策としては、河川の状態把握を踏まえ、例えば、河床掘削や樹木の伐開等に伴う生物の生息・生育・繁殖環境の保全、魚道の機能を維持するための補修、除草等の維持作業に伴う堤防植生の保全、地域と協働した樹木伐開、外来生物の防除等がなされている。河川環境の維持管理目標として河川環境や河川利用に係るゾーニングが設定されている場合等には、具体的な対策として、法制度や協議会による協定等に基づいて河川利用等に制約を設けることも検討の上実施するよう努めることが必要である。また、維持管理対策の検討実施にあたっては、状態把握の結果を総括した河川環境情報図を活用するとよい。

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------
  河川整備計画に基づいて良好な河川環境が保全されるよう、自然環境や河川利用に係る河川の状態把握を行いながら、適切に河川環境の維持管理を行うことを基本とする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------

  ------------------------------------------------------------------------------------------------------------------------------------------------------------

(1)河川の自然環境に関する状態把握について

＜考え方＞

河川の自然環境に関する情報を包括的、体系的に把握するとともに、個別の維持管理目標に対応した状態把握を行うことが重要である。

＜標　準＞

+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 大河川においては、以下のように状態把握を行うことを基本とする。                                                                                                                                                                                                                                                                                        |
|                                                                                                                                                                                                                                                                                                                                                       |
| ①自然環境の状態把握                                                                                                                                                                                                                                                                                                                                   |
|                                                                                                                                                                                                                                                                                                                                                       |
| > 河川の自然環境としては、河川の水質に関する状況、河川の水位に関する状況、季節的な自然環境の変化、河川環境上重要な生物の生息状況等について把握することを基本とする。包括的、体系的な状態把握は、河川水辺の国勢調査等^1)^を中心として実施することを基本とする（第4章第2節2.4）。また、日常の状態把握は平常時の河川巡視にあわせて行うことを基本とする。 |
|                                                                                                                                                                                                                                                                                                                                                       |
| ②河川利用による自然環境への影響                                                                                                                                                                                                                                                                                                                       |
|                                                                                                                                                                                                                                                                                                                                                       |
| 河川環境上重要な生物の生息域における河川利用による生息環境の改変等、河川利用により自然環境に影響を及ぼすことがあるため、また自然環境に影響を及ぼすような河川利用はいつ行われるかわからないため、河川巡視により状態把握を行うことを基本とする。重点的な監視が必要となる場合には、別途目的別巡視等を検討の上実施することを基本とする。                  |
+=======================================================================================================================================================================================================================================================================================================================================================+

＜推　奨＞

目視により所要の状態把握ができない場合には、河川維持管理目標として設定した個別の課題等に関する調査を必要に応じて実施する。その際、学識経験者等からの助言も踏まえて状態把握の内容、箇所、時期等を検討することが望ましい。また、状態把握にあたっては、河川協力団体、地域のNPO、市民団体等とも連携した取り組みにも努める。

中小河川においては、河川の規模や自然環境の状況等に応じて必要とされる自然環境に関する情報収集を行うよう努める。

＜例　示＞

河川環境に関して設定した個別の河川維持管理目標に関しては、河川巡視にあわせて目視により確認可能な経時的な変状を把握することができる。例えば、渇水時の瀬切れの状況、鮎等の産卵場の状況、植生、外来生物の状況等について可能な範囲で把握することになる。

(2)生物の良好な生息・生育・繁殖環境の保全について

＜考え方＞

河川には、源流部から河口まで、水中、水際、河原等の場所に応じて、土壌、水分、日照等の条件が異なる様々な環境が存在し、その環境に応じて、多様な生物群集が生息・生育・繁殖している。そのため、河川が生物群集の多様性を保つ上で重要な役割を果たすことを十分認識した上で、学術上又は希少性の観点から重要なもの、その川に典型的に見られるもの、川への依存性が高いもの、川のダイナミズムにより維持されているもの、川の上下流等の連続性の指標となるもの、その川の特殊な環境に依存しているもの等に着目し、現状及び歴史的な経緯並びにその背景等を踏まえ、その川にふさわしい生物群集と生息・生育・繁殖環境が将来にわたって維持されるよう努めることが重要である。

＜標　準＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  河川が生物群集の多様性を保つ上で重要な役割を果たすことを十分認識した上で、その川にふさわしい生物群集と生息・生育・繁殖環境を保全するための維持管理を行うことを基本とする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

河川維持管理にあたっては多自然川づくり^2)^を基本として、河川の生物及びそれらの生息・生育・繁殖環境の現状と過去からの変遷及びその背景を踏まえて、その川にふさわしい生物の生息・生育・繁殖環境が保全・整備されるように努める。許可工作物の補修等の対策にあたっても施設管理者により多自然川づくりが進められるよう努める。

また、河川維持管理にあたって、外来魚、外来植物等の外来生物の駆除等を必要に応じて考慮するとともに、関係機関や地域の河川協力団体、NPO、市民団体等と連携・協働した取り組みにも努める。

[＜例　示＞]{.mark}

近年、河川域においては多くの外来生物が確認されており、河川における生物多様性の低下、さらには一部で治水上の悪影響も生じている。そのため外来生物の侵入防止や駆除等の対策が必要とされている。平成18年には、特定外来生物による生態系等に係る被害の防止に関する法に基づき、特定外来生物のうち5種の陸生植物（オオキンケイギク、オオハンゴンソウ、ナルトサワギク、アレチウリ、オオカワヂシャ）について国土交通大臣が防除の主務大臣等となり、環境大臣とともに防除を公示し、これらの種に係る河川管理行為（除草、土砂の運搬等）の適切な実施を目指す等の対策も行われているところである。

＜関連通知等＞

1\)
河川砂防技術基準調査編,第11章：平成26年4月1日,国水情報第52号,水管理・国土保全局長.\
（最新版）河川砂防技術基準　調査編,第11章（令和6年6月）,
水管理・国土保全局長.

2\)
「多自然川づくり」の推進について：平成18年10月13日,国河環第38号,国河治第86号,国河防第370号,河川局長.

3\) 河川における外来植物対策の手引き:平成25年12月,河川環境課.

4\) 河川における外来魚対策の事例集:平成25年12月,河川環境課.

(3)良好な河川景観の維持・形成について

＜考え方＞

河川景観は、自然の営力を受けて常に変化しつつ、一方で、人為的に適度な維持管理が行われることによって保全されるものである。河川の維持管理を通じて、地域の人々とともに時間をかけながら、その地域に根ざした、多様で美しい河川景観を保全することが大切である。^1)^

また、周辺景観との調和が重要であり、地域によっては周辺景観の誘導・規制等について関係機関と調整していくことも重要である。なお、景観法（平成16年法律第110号）に基づく景観行政団体が景観計画に法第24条の占用許可の基準を定めている場合には、当該基準に沿うものである。

河川協力団体、地域住民等の活動の果たす役割は大きく、草刈り、ゴミ拾い等の河川愛護活動や河川美化活動等の地域活動による河川景観の保全も重要である。

＜関連通知等＞

1\)
河川景観の形成と保全の考え方:平成18年10月19日,国土交通省河川局河川環境課長、治水課長、防災課長.

＜標　準＞

+----------------------------------------------------------------------------------------------------------------------------------------------------+
| 河川維持管理が、良好な河川景観の維持・形成に果たす役割は大きく、以下のような点に留意して、維持管理を通じた河川景観の保全をはかることを基本とする。 |
|                                                                                                                                                    |
| ・治水・利水の機能の維持や自然環境の保全を通じたその川らしい景観の保全                                                                             |
|                                                                                                                                                    |
| ・不法投棄への適正な対処や施設破損の補修等による直接的な景観の保全                                                                                 |
|                                                                                                                                                    |
| ・河川空間の美化や適正な利用を通じた人々の意識向上に伴う景観の保全                                                                                 |
+====================================================================================================================================================+

＜推　奨＞

河川維持管理にあたっては、その川の自然景観や地域の歴史的・文化的な背景を踏まえ、河川が本来有する良好な河川景観が維持・形成されるよう努める。

河川敷地の占用や工作物の設置等の許可に際しては、河川整備計画や河川環境管理基本計画等で定められている河川景観の目標像等を踏まえ、良好な景観の維持・形成に努める。

(4)人と河川とのふれあいの場の維持について

＜標　準＞

+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 人と河川との豊かなふれあいの場の維持にあたっては、施設及び場の維持管理とともに、活動の背景となっている自然環境や景観等の河川環境自体の保全をはかることを基本とする。また、教育的な観点、福祉的な観点等を融合することを基本とする。 |
|                                                                                                                                                                                                                                    |
| また、川とのふれあい活動そのものが河川環境に悪影響を及ぼさないよう留意することを基本とする。                                                                                                                                       |
+====================================================================================================================================================================================================================================+

＜推　奨＞

河川利用は自己責任が原則であるが、安全で楽しく水辺で遊べるために、安全に関する情報提供の充実、河川利用者等への啓発、流域における関係機関の連携、緊急時への備えに努める。

(5)良好な水質の保全について

＜考え方＞

河川の適正な利用、流水の正常な機能の維持及び河川環境の保全のため良好な水質の保全が必要である。

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  大河川においては、河川における適正な水質が維持されるよう河川の状態把握に努めるとともに、水質事故（第9章第2節）や異常水質が発生した場合に備えて、河川行政機関と連携し、実施体制を整備することを基本とする。水質調査の手法等は河川砂防技術基準調査編による。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

中小河川においては、河川における適正な水質が維持されるよう河川の状態把握に努める。

**第9章　水防等のための対策**

**第1節 水防のための対策**

**1．1 水防活動等への対応**

＜考え方＞

出水時の対応のため、所要の資機材を適切に備蓄し、必要に応じて迅速に輸送し得るよう、あらかじめ関係機関と十分協議しておくとともに、応急復旧時の民間保有機材等の活用体制^1)^を整備するよう努めることが重要である。

市町村等の水防管理団体が洪水時等に迅速、かつ適確な水防活動が実施できるよう、次の事項を行うものである。

＜標　準＞

+--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| > ①重要水防箇所の周知                                                                                                                                                                                                                      |
| >                                                                                                                                                                                                                                          |
| > 洪水等に際して水防上特に留意を要する箇所を定めて、その箇所を水防管理団体に周知徹底する。なお、重要水防箇所^2)3)^は、従来の災害の実績、河川カルテの記載内容等を勘案のうえ、堤防・護岸等の点検結果を十分に考慮して定めることを基本とする。 |
| >                                                                                                                                                                                                                                          |
| > ②水防訓練                                                                                                                                                                                                                                |
|                                                                                                                                                                                                                                            |
| 関係者間の出水時における情報伝達が確実になされるよう、出水期前に訓練を行うことを基本とする。                                                                                                                                               |
+============================================================================================================================================================================================================================================+

＜推　奨＞

重要水防箇所の周知に際しては、必要に応じて、出水期前等に水防管理者、水防団等と合同で河川巡視を実施する。

水防管理団体が洪水時等に迅速、かつ適確な水防活動が行えるよう水防管理団体等が実施する水防訓練に河川管理者も積極的に参加し、水防工法等の指導、助言に努める。

洪水や高潮、津波による出水時の対応のために、所要の資機材の確保等に努めるとともに、水防管理団体が行う水防活動等との連携に努める。

出水時には、異常が発見された箇所において直ちに水防団が水防活動を実施できるように、水防管理団体との情報連絡を密にし、水防管理団体を通じて水防団の所在、人員、活動状況等を把握するように努める。

＜関連通知等＞

1\)
応急復旧時の民間保有機械等の活用体制について：昭和60年1月25日,建設事務次官.

2\)
河川管理の強化について：昭和57年1月25日,建河治発第4号･第5号,治水課長.

3\)
重要水防箇所評定基準（案）の改定について：平成31年2月27日,国水環保第19号,河川環境課長.

**1．2 水位情報等の提供**

＜考え方＞

出水時の水位情報あるいはその予測情報、洪水はん濫に関する情報は、水防活動、地域住民の避難行動、あるいは市町村長による避難勧告等の判断の基礎となるものである。そのため、河川管理者は、それらの活動に資するよう、水防法（昭和24年法律193号）第10条及び第11条に基づく洪水予報、同法第12条に基づく水位の通報、同法第13条に基づく水位情報の周知、及び同法第14条に基づく浸水想定区域の指定等を行い、適切な情報提供に努めることが必要である。

平成25年6月に災害対策基本法が改正され、市町村長が避難勧告の発令等の判断に際し、指定行政機関の長や都道府県知事等に助言を求めることができることとなり、この場合において、助言を求められた指定行政機関の長や都道府県知事等は、その所掌事務に関し、必要な助言を行うこととなった。令和3年4月には災害対策基本法が改正され、警戒レベル４の避難勧告及び避難指示（緊急）が避難指示に一本化されることとなったほか、これとあわせて「住民自ら行動をとる際の判断に参考となる情報」である警戒レベル相当情報として、国管理河川の洪水の危険度分布（水害リスクライン）の活用を促すなど、避難情報に関するガイドライン（令和3年5月）^1)^として改定された。水位情報等の提供の際は、実施要領^2)^やガイドライン^1)^等に基づき、情報の受け手にとって分かりやすい情報とするように努めることが重要である。洪水予報又は水位到達情報発表の対象でない河川の区域にあっても、可能な範囲で水位等の情報を提供することが望まれている。水防法第10条第2項では、指定された国管理河川において氾濫を生じた場合に、氾濫により浸水する区域及び水深を情報提供することについても規定されている。

(1)危険水位及び氾濫危険水位等について

危険水位は、原則として「洪水により相当の家屋浸水等の被害を生ずる氾濫の起こる恐れがある水位」であり、河川の箇所毎に設定するものである。

氾濫危険水位は、市町村長の避難指示の発令の目安、住民の避難判断の参考として設定^3)^されるものであり、箇所毎の危険水位を踏まえ、洪水予報を実施する観測所（以下、「洪水予報観測所という。」）の受け持つ区域において、氾濫危険情報を発表する水位であり、洪水予報観測所毎に１個又は複数個設定するものである。

水位の設定は設定要領^4）^に準じて行うものである。

また、洪水特別警戒水位は、洪水予報河川以外の河川のうち、洪水により重大又は相当な損害を生ずるおそれがあるものとして指定した河川（以下「水位周知河川」という）において、「警戒水位を超える水位であって洪水による災害の発生を特に警戒すべき水位」（水防法第十三条第一項）として定められる水位であり、基本的には危険水位に相当する水位（以下「危険水位相当水位」という）を、水位周知河川において洪水特別警戒水位を定める水位観測所（以下「水位周知観測所」という）において換算した水位（以下「危険水位相当換算水位」という）として設定されるものであり、これについても一般に「氾濫危険水位」と表示し、洪水予報河川における氾濫危険水位の運用と同様に、市町村長の避難指示の発令の目安等とするものである。

(2)避難判断水位について

洪水予報河川の避難判断水位は、住民に対し氾濫発生の危険性についての注意喚起を開始する、あるいは避難に時間のかかる高齢者等の要配慮者が避難を開始の参考となる水位であり、避難行動との関係では市町村長が発令する高齢者等避難の発令の目安として設定^3)^されるものである。

水位の設定は設定要領^4）^に準じて行うものである。

(3)氾濫注意水位（警戒水位）について

水防法第12条第2項では、都道府県の水防計画で定める量水標管理者は、都道府県知事が定める警戒水位を超えるときは、その水位の状況を、都道府県の水防計画の定めるところにより公表しなければならないと規定されている。氾濫注意水位は水防法上の警戒水位に相当する水位として一般に定められ、水防団の出動の目安として設定されるものである。水防団の出動の水位は、氾濫注意水位を基本とし、河川や地域の特性を考慮して設定^3)^することを基本とされている。また、河川管理者も河川管理施設等の保全を十分に行うために警戒水位^5)^を定めることとしており、水防法上の警戒水位と同一の観測地点及び水位であることが望まれている。

氾濫注意水位は水防活動と河川管理施設等の保全との関係で定めるものであるが、新たに定める場合には、以下のような設定の考え方を参考にして、水防活動の実情等を考慮して定めるものである。

> ① 計画高水流量の5割程度の流量時に達する水位
>
> ② 平均低水位から計画高水位までの低い方から6割の水位
>
> ③ 3年に１回程度生じる水位
>
> ④ 未改修部では平均低水位から計画堤防高までの5割程度の水位
>
> ⑤ 融雪出水の多い河川、急流河川では①～④より低く定めることが多い。

(4)水防団待機水位（指定水位、通報水位）について

水防団待機水位は、水防団が出動のために待機する水位として設定し^1)^、一般に指定水位と同一の水位とされる。指定水位は、普通観測による水位観測が主であった時期に、洪水時毎時水位観測を開始すべき水位として定められてきた。その後、水防法第12条第1項に定められる通報水位（都道府県知事が定め、水防計画の定めるところにより関係者へ通報する水位）と多くの河川では同一の水位として運用がなされてきた。

水防団待機水位(指定水位)は水防活動との関係で定めるものであるが、新たに定める場合には、以下のような設定の考え方を参考にして、水防活動の実情等を考慮して定めるものである。

> ① 計画高水流量の2割程度の流量時に達する水位
>
> ② 大河川においては年に1回程度生じる水位
>
> ③ 中小河川においては年に5～10回程度生じる水位
>
> ④ ①②③の水位で、警戒水位に到達する時間を考慮して設定した水位

＜必　須＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  洪水予報河川、水位周知河川等の該当河川においては、出水時における水防活動、あるいは市町村及び地域住民における避難に係る活動等に資するよう、水防法等に基づいて適切に洪水予報あるいは水位に関する情報提供を行うものとする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  情報提供の基本となる河川の各種水位の設定については、危険水位等の設定要領^4)^等によることを基本とする。なお、これらの水位については、河川整備の状況等に応じて、その設定目的を踏まえて適宜見直しを行うことを基本とする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

[＜推　奨＞]{.mark}

洪水予報河川等における、危険箇所を受け持つ水位観測所に換算した危険水位や氾濫開始相当水位の情報については、市町村長による避難情報の発令基準の設定に活用できることから、平時から必要な情報共有を図るよう努める。また、危険箇所を受け持つ水位観測所が、当該危険箇所よりも下流側の離れた位置にある場合は、氾濫開始相当水位への到達よりも氾濫の発生が先行することもあるため、活用にあたっては、注意が必要である。

＜関連通知等＞

1\) 避難情報に関するガイドライン：令和3年5月10日，内閣府.

2\)
洪水等に関する防災情報体系の見直しについて：平成18年10月1日,国河情第3号,河川局長.

3\)
洪水時における情報提供の充実について：平成26年4月8日,国水環第2号,国土交通省水管理・国土保全局長.

4\)
危険水位等の設定要領の改定について：平成26年4月8日,国水環第3号,河川環境課長.

5\)
出水時における河川の管理について：昭和50年4月4日,建河治発第32号,河川局長.

**第2節 水質事故対策**

＜考え方＞

流域では通常の社会・経済活動が行われていることから、車両等からの油の流出、工場等からの有毒廃液や薬品類等の流出、不法投棄等の水質事故が発生する可能性がある。

河川法では、水質事故の原因者に水質事故処理等の河川の維持について行わせることができ（同法第18条）、又はその費用を負担させる（同法第67条）こととしていることから、原因者が判明した場合は、法令に従って処理することが必要である。

＜必　須＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  河川管理者は、河川等で水質事故が発生した場合は、事故発生状況に係る情報を速やかに収集し、関係機関に通報するとともに、関係機関と連携し、必要な対策を速やかに行うものとする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 突発的に発生する水質事故に対応するため、予め流域内の水質事故に係る汚濁源情報の把握に努めることを基本とする。また、河川管理者と関係機関で構成する水質汚濁防止に関する連絡協議会^1)2)^等による情報連絡体制を整備し、常時情報の交換を行い、夜間・休日を問わず、緊急事態が発生した場合に即応できるようにすることを基本とする。 |
|                                                                                                                                                                                                                                                                                                                            |
| さらに、関係機関の役割分担を明確にして、緊急事態が発生した場合に行う応急対策、水質分析、原因者究明のための調査、原因者への指導等を速やかに行うことができる体制を構築するとともに、緊急時の対策を確実かつ円滑に行えるよう、情報伝達訓練、現地対策訓練等を、必要に応じて、定期的に行うことを基本とする。                     |
|                                                                                                                                                                                                                                                                                                                            |
| 水質事故に係る対応は原因者が行うことが原則であるが、水質事故対応が緊急を要するものである場合や、事故による水質汚濁が広範囲に及ぶ場合等、原因者のみによる対応では迅速かつ効果的な対応ができない場合は、河川管理者は必要な措置を講じることを基本とする。                                                                     |
|                                                                                                                                                                                                                                                                                                                            |
| 河川管理者は、過去に発生した水質事故を勘案の上、必要な水質事故対策資材の備蓄を行うほか、関係機関の備蓄状況についても把握するなど、事故発生時に速やかに資材等の確保を図ることを基本とする。                                                                                                                                 |
+============================================================================================================================================================================================================================================================================================================================+

＜関連通知等＞

1\)
河川法施行令の一部を改正する政令の施行について：平成6年7月8日,建河政発44号,河川局長.

2\) 河川法の一部を改正する法律の施行について：平成7年10月2日,
建設省河政発第51号,河川局長.

3\) 水質事故対策技術　2001年版: 平成13年9月,
(公財)河川財団（監修：国土交通省水質連絡会）.
