**維持管理編（ダム編）**

**目　次**

[第1章 総説 [1](#_Toc192777823)](#_Toc192777823)

[第1節 目的 [1](#_Toc198801702)](#_Toc198801702)

> [1．1 本基準の目的 [1](#_Toc192777825)](#_Toc192777825)
>
> [1．2 基本的な考え方 [1](#_Toc198801704)](#_Toc198801704)
>
> [1．2．1 背景 [1](#_Toc198801705)](#_Toc198801705)
>
> [1．2．2 構成等 [2](#_Toc198801706)](#_Toc198801706)

[第2節 適用範囲 [2](#_Toc192777827)](#_Toc192777827)

[第3節 基本方針 [3](#_Toc192777828)](#_Toc192777828)

> [3．1 維持管理の基本方針 [3](#_Toc198801709)](#_Toc198801709)
>
> [3．2 ダム施設及び貯水池の維持管理
> [3](#_Toc198801710)](#_Toc198801710)
>
> [3．3 流水管理 [5](#_Toc192777831)](#_Toc192777831)
>
> [3．4 ダムの管理に係るフォローアップ
> [5](#_Toc192777832)](#_Toc192777832)

[第2章 ダム施設及び貯水池の維持管理 [5](#_Toc192777833)](#_Toc192777833)

[第1節 ダム施設及び貯水池の計画的な維持管理
[5](#_Toc192777834)](#_Toc192777834)

> [1．1 総説 [5](#_Toc192777835)](#_Toc192777835)
>
> [1．2 ダム施設の維持管理 [8](#_Toc192777836)](#_Toc192777836)
>
> [1．2．1 ダム点検整備基準 [8](#_Toc198801717)](#_Toc198801717)
>
> [1．2．2 ダムの長寿命化計画 [14](#_Toc198801718)](#_Toc198801718)
>
> [1．2．3 ダム管理用水力発電設備 [16](#_Toc198801719)](#_Toc198801719)
>
> [1．3 貯水池の維持管理 [16](#_Toc192777837)](#_Toc192777837)

[第2節 ダム施設及び貯水池の状態把握
[17](#_Toc192777838)](#_Toc192777838)

> [2．1 総説 [17](#_Toc192777839)](#_Toc192777839)
>
> [2．2 点検等 [18](#_Toc192777840)](#_Toc192777840)
>
> [2．2．1 巡視・日常点検 [18](#_Toc198801724)](#_Toc198801724)
>
> [2．2．2 臨時点検 [25](#_Toc198801725)](#_Toc198801725)
>
> [2．2．3 ダム総合点検 [26](#_Toc198801726)](#_Toc198801726)
>
> [2．2．4 定期検査 [28](#_Toc198801727)](#_Toc198801727)
>
> [2．3 観測・調査等 [28](#_Toc192777841)](#_Toc192777841)
>
> [2．3．1 水文・水理観測及び気象情報の収集
> [28](#_Toc198801729)](#_Toc198801729)
>
> [2．3．2 堆砂調査 [29](#_Toc198801730)](#_Toc198801730)
>
> [2．3．3 水質調査 [31](#_Toc198801731)](#_Toc198801731)
>
> [2．3．4 環境調査 [33](#_Toc198801732)](#_Toc198801732)
>
> [2．4 点検・観測等の記録 [33](#_Toc192777842)](#_Toc192777842)

[第3節 ダム施設の維持管理の評価と対策
[34](#_Toc192777843)](#_Toc192777843)

> [3．1 総説 [34](#_Toc192777844)](#_Toc192777844)
>
> [3．2 土木構造物 [36](#_Toc192777845)](#_Toc192777845)
>
> [3．2．1 評価 [36](#_Toc198801737)](#_Toc198801737)
>
> [3．2．2 対策 [37](#_Toc198801738)](#_Toc198801738)
>
> [3．3 機械設備 [37](#_Toc192777846)](#_Toc192777846)
>
> [3．3．1 評価 [37](#_Toc198801740)](#_Toc198801740)
>
> [3．3．2 対策 [38](#_Toc198801741)](#_Toc198801741)
>
> [3．4 電気通信設備 [38](#_Toc192777847)](#_Toc192777847)
>
> [3．4．1 評価 [38](#_Toc198801743)](#_Toc198801743)
>
> [3．4．2 対策 [39](#_Toc198801744)](#_Toc198801744)
>
> [3．5 貯水池周辺斜面 [39](#_Toc192777848)](#_Toc192777848)
>
> [3．5．1 安定性の評価 [39](#_Toc198801746)](#_Toc198801746)
>
> [3．5．2 対策 [40](#_Toc198801747)](#_Toc198801747)
>
> [3．6 観測・計測設備 [40](#_Toc192777849)](#_Toc192777849)
>
> [3．7 維持・修繕等の記録 [41](#_Toc192777850)](#_Toc192777850)

[第4節 貯水池の維持管理対策 [42](#_Toc192777851)](#_Toc192777851)

> [4．1 総説 [42](#_Toc192777852)](#_Toc192777852)
>
> [4．2 堆砂対策 [42](#_Toc192777853)](#_Toc192777853)
>
> [4．3 水質改善対策 [44](#_Toc192777854)](#_Toc192777854)
>
> [4．4 流木対策 [45](#_Toc192777855)](#_Toc192777855)
>
> [4．5 不法行為への対策 [47](#_Toc192777856)](#_Toc192777856)
>
> [4．6 貯水池の適正な利用・水源地域の活性化
> [47](#_Toc192777857)](#_Toc192777857)
>
> [4．7 貯水池及びその周辺の環境保全対策
> [48](#_Toc192777858)](#_Toc192777858)
>
> [4．8 水質事故対策 [49](#_Toc192777859)](#_Toc192777859)

[第5節 許可工作物 [50](#_Toc192777860)](#_Toc192777860)

[第3章 流水管理 [52](#_Toc192777861)](#_Toc192777861)

[第1節 総説 [52](#_Toc192777862)](#_Toc192777862)

> [1．1 総説 [52](#_Toc192777863)](#_Toc192777863)
>
> [1．2 操作規則等 [53](#_Toc192777864)](#_Toc192777864)
>
> [1．3 水文・水理観測及び気象情報の収集
> [55](#_Toc192777865)](#_Toc192777865)

[第2節 運用操作 [56](#_Toc192777866)](#_Toc192777866)

> [2．1 ダムの操作 [56](#_Toc192777867)](#_Toc192777867)
>
> [2．2 ダムの弾力的な管理・運用 [58](#_Toc192777868)](#_Toc192777868)
>
> [2．2．1 事前放流 [58](#_Toc198801768)](#_Toc198801768)
>
> [2．2．2 特別防災操作〈ただし書き操作〉
> [59](#_Toc198801769)](#_Toc198801769)
>
> [2．2．3 環境保全を目的とした弾力的管理
> [60](#_Toc198801770)](#_Toc198801770)

[第3節 渇水対策 [61](#_Toc192777869)](#_Toc192777869)

[第4節 管理情報の記録 [61](#_Toc192777870)](#_Toc192777870)

[第5節 管理情報の提供 [62](#_Toc192777871)](#_Toc192777871)

[第4章 ダムの管理に係るフォローアップ
[63](#_Toc192777872)](#_Toc192777872)

令和7年　月　版

適用上の位置付け

　河川砂防技術基準維持管理編（ダム編）は、基準の適用上の位置付けを明確にするために、下表に示すように適用上の位置付けを分類している。

+:-------:+:--------:+:---------------------------------------------------------------------------------------------------------------:+:----------------------------------:+
| 分　類             | 適用上の位置付け                                                                                                | 末尾の字句例                       |
+---------+----------+-----------------------------------------------------------------------------------------------------------------+------------------------------------+
| 考え方  | 技術資料 | ●目的や概念、考え方を記述した事項。                                                                             | 「･･･ある。」「･･･いる。」         |
|         |          |                                                                                                                 |                                    |
|         |          |                                                                                                                 | 「･･･なる。」「･･･れる。」         |
+---------+----------+-----------------------------------------------------------------------------------------------------------------+------------------------------------+
| 必　須  | 技術基準 | ●法令による規定や技術的観点から実施すべきであることが明確であり遵守すべき事項。                                 | 「･･･なければならない。」          |
|         |          |                                                                                                                 |                                    |
|         |          |                                                                                                                 | 「･･･ものとする。」                |
+---------+----------+-----------------------------------------------------------------------------------------------------------------+------------------------------------+
| 標　準  | 技術基準 | ●特段の事情がない限り記述に従い実施すべきだが、状況や条件によって一律に適用することはできない事項。             | 「･･･を標準とする。」              |
|         |          |                                                                                                                 |                                    |
|         |          |                                                                                                                 | 「･･･を基本とする。」              |
|         |          |                                                                                                                 |                                    |
|         |          |                                                                                                                 | 「･･･による。」                    |
+---------+----------+-----------------------------------------------------------------------------------------------------------------+------------------------------------+
| 推　奨  | 技術資料 | ●状況や条件によって実施することが良い事項。                                                                     | 「･･･望ましい。」                  |
|         |          |                                                                                                                 |                                    |
|         |          |                                                                                                                 | 「･･･推奨する。」                  |
|         |          |                                                                                                                 |                                    |
|         |          |                                                                                                                 | 「･･･努める。」                    |
|         |          |                                                                                                                 |                                    |
|         |          |                                                                                                                 | 「･･･必要に応じて･･･する。」       |
+---------+----------+-----------------------------------------------------------------------------------------------------------------+------------------------------------+
| 例　示  | 技術資料 | ●適用条件や実施効果について確定している段階ではないが、状況や条件によっては導入することが可能な新技術等の例示。 | 「･･･などの手法（事例）がある。」  |
|         |          |                                                                                                                 |                                    |
|         |          | ●状況や条件によって限定的に実施できる技術等の例示。                                                             | 「･･･などの場合がある。」          |
|         |          |                                                                                                                 |                                    |
|         |          | ●具体的に例示することにより、技術的な理解を助ける事項。                                                         | 「･･･などが考えられる。」          |
|         |          |                                                                                                                 |                                    |
|         |          |                                                                                                                 | 「･･･の場合には･･･ことができる。」 |
|         |          |                                                                                                                 |                                    |
|         |          |                                                                                                                 | 「･･･例示する。」                  |
|         |          |                                                                                                                 |                                    |
|         |          |                                                                                                                 | 「例えば･･･。」                    |
|         |          |                                                                                                                 |                                    |
|         |          |                                                                                                                 | 「･･･事例もある。･･･もよい。」     |
+---------+----------+-----------------------------------------------------------------------------------------------------------------+------------------------------------+

  -----------------------------------------------------------------------
  関連通知等       関連する通知やそれを理解する上で参考となる資料
  ---------------- ------------------------------------------------------
  参考となる資料   例示等に示した手法・内容を理解する上で参考となる資料

  -----------------------------------------------------------------------

1.  []{#_Toc192777823 .anchor}総説

    1.  []{#_Toc198801702 .anchor}目的

        1.  []{#_Toc192777825 .anchor}本基準の目的

＜考え方＞

+--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| ダムは、洪水調節、流水の正常な機能の維持及び利水補給等多様な目的を持つ重要な社会資本であり、これらの目的が達成されるよう流水の管理を行うとともに、その前提となるダムの安全性及び機能を長期にわたり保持することが求められている。                                                                                                                                               |
|                                                                                                                                                                                                                                                                                                                                                                                |
| また、ダムの建設により、堤体、洪水吐き等の大規模な土木構造物に加え、広大な静水面をもつ貯水池が出現し、新たな環境が創出されることから、これらの環境を保全し、適正に利用することも求められている。                                                                                                                                                                               |
|                                                                                                                                                                                                                                                                                                                                                                                |
| 河川砂防技術基準維持管理編（ダム編）（以下「本基準」という。）は、「ダム施設及び貯水池の維持管理」及び「流水管理」に必要とされる主な事項を定め、もって適正なダムの維持管理に資することを目的とする。                                                                                                                                                                           |
|                                                                                                                                                                                                                                                                                                                                                                                |
| なお本基準において、「ダム施設」は、堤体、洪水吐き、基礎地盤、放流設備等が一体となった構造物に加えて、貯水池周辺斜面やダムの機能を発揮するために必要な観測・計測設備等、ダムに関連する設備等を含めたものの総称として用いている。また、「流水管理」は、ダムが有する洪水調節、流水の正常な機能の維持及び利水補給等の機能が発揮されるようダムを操作し、流水を管理することをいう。 |
|                                                                                                                                                                                                                                                                                                                                                                                |
| 更に、「ダム管理者」は、河川法第3条の規定に基づく河川管理施設のダム（同法第17条に規定する兼用工作物のダム、特定多目的ダム法第2条に規定する多目的ダム、独立行政法人水資源機構法第2条に規定する特定施設を含む）の管理者をいう。                                                                                                                                                  |
+================================================================================================================================================================================================================================================================================================================================================================================+

2.  []{#_Toc198801704 .anchor}基本的な考え方

    1.  []{#_Toc198801705 .anchor}背景

+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 河川法第3条の規定に基づく河川管理施設のダム（同法第17条に規定する兼用工作物のダム、特定多目的ダム法第2条に規定する多目的ダム、独立行政法人水資源機構法第2条に規定する特定施設を含む（以下「河川管理施設のダムという。））は、これまでに500基以上が建設され、国土交通省、独立行政法人水資源機構及び道府県により管理されている。これらのダムは、高水管理や低水管理等の流水管理を適切に行うことで、下流域の洪水被害を軽減するとともに、流水の正常な機能の維持や安定的な利水補給を行っているが、これらのダムのうち約6割のダムは完成後30年以上が経過しており、今後、経年劣化等による設備の維持・修繕等が必要となるダムが増加するものと考えられる。そのため、ダムの維持管理、修繕を適切なタイミングで計画的に実施することが重要である。なお、通常の維持管理の範囲では対応が難しい課題を有する場合には、既設ダムの機能向上や更なる有効活用を目的とするダム再生とあわせて対応を検討することも考えられる。ダム再生には、ダムの長寿命化と維持管理における効率化・高度化も方策として盛り込まれ、例えば堆砂対策として排砂バイパスの設置などが進められている。 |
|                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| 河川管理施設のダムは、ダム点検整備基準（第2章第1節1.2.1参照）を定め、日常管理における巡視・点検を行うとともに、点検結果等を踏まえ、ダム施設の効率的な維持・修繕等を図るなど、ダムの効果的・効率的な維持管理に努めてきたところであるが、ダムは高い安全性が要求されるとともに、全面的な更新が困難な施設であることから、ダムの維持管理をより効果的・効率的に行い、長寿命化を図りつつ、ダムの安全性及び機能を長期にわたり保持することが重要である。                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
|                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| また、ダムの維持管理は、土木構造物、機械設備、電気通信設備、貯水池周辺斜面等の多様な設備等に加え、貯水池の堆砂や水質、環境等も対象としており、更に流水を管理するための操作を行うなど、あらゆる技術を総合して行うものである。そのため、幅広い技術が必要とされるが、ダムの維持管理に豊富な経験を有する技術者が少なくなってきているのが現状である。                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
|                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| このような課題に対して、維持管理水準の維持・向上を図るため、これまで蓄積してきたダムの維持管理に関する技術を体系化するとともに、技術を承継するための人材育成に取り組む必要がある。                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |
|                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| 河川管理施設の維持管理については、平成25年に河川法（昭和39年法律第167号）の一部が改正され、同法第15条の2において、河川管理者は、河川管理施設を良好な状態に保つように維持し、修繕し、もって公共の安全が保持されるように努めなければならないことが定められた。また、同年、河川法施行令（昭和40年政令第14号）の一部が改正され、ダム、堤防その他の国土交通省令で定める河川管理施設等は、1年に1回以上の適切な頻度で、適切な時期に、目視その他適切な方法で点検を行い、点検その他の方法により河川管理施設等の損傷、腐食、その他の異状があることを把握したときは、河川管理施設等の効率的な維持及び修繕が図られるよう、必要な措置を講じることが定められた。                                                                                                                                                                                                                                                                                                                                                                                                |
+===================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================+

1.  []{#_Toc198801706 .anchor}構成等

+--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 本基準は、ダムの維持管理における標準的な技術を体系化するものであり、「ダム施設及び貯水池の維持管理」、「流水管理」及び「ダムの管理に係るフォローアップ」で構成されている。                                                                                   |
|                                                                                                                                                                                                                                                              |
| このうち、「ダム施設及び貯水池の維持管理」は、「ダム施設及び貯水池の計画的な維持管理」、「ダム施設及び貯水池の状態把握」、「ダム施設の維持管理の評価と対策」及び「貯水池の維持管理対策」に分類して記載し、ダムの維持管理サイクルに沿った構成としている。     |
|                                                                                                                                                                                                                                                              |
| 併せて、各事項に対応する技術的な通知やマニュアル等について、関連通知等を記載し、本基準との関連が分かるようにしている。                                                                                                                                       |
|                                                                                                                                                                                                                                                              |
| 本基準は、作成時点における技術的知見に基づいて作成している。本基準に基づくダムの維持管理を通じて知見を積み重ね、ダムの維持管理に携わる者の技術力の維持・向上を図るとともに、新たな知見や社会・経済情勢の変化を踏まえ、今後、必要に応じて、本基準を改定する。 |
+==============================================================================================================================================================================================================================================================+

2.  []{#_Toc192777827 .anchor}適用範囲

＜考え方＞

+-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 本基準は、河川管理施設のダムの維持管理に適用する。                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
|                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |
| また、河川管理施設のダムと同様、河川法第44条第1項のダム（以下「許可工作物のダム」という。」についても、その許可を受けてダムを設置している者（以下「ダム設置者」という。）が良好な状態に保つように維持し、修繕し、もって公共の安全が保持されるように努めなければならないことが法第15条の2に定められており、このようなダムについても適切な維持管理により治水又は利水上の支障等を生じさせないようにする必要がある。このため、河川管理者がダム設置者に対して必要な指導・監督等を行う際においても本基準の該当部分を適用する。許可工作物における維持管理の考え方については「第2章 |
| 第5節　許可工作物」に記述する。                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |
|                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |
| なお、本基準に特に記載のない項目については、法令及び本基準の趣旨に鑑み、適切に維持管理を行うことが必要である。                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
+=============================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================+

3.  []{#_Toc192777828 .anchor}基本方針

    1.  []{#_Toc198801709 .anchor}維持管理の基本方針

＜考え方＞

  --------------------------------------------------------------------------------------------------------------------
  ダムの維持管理は、ダムが有する洪水調節、流水の正常な機能の維持及び利水補給等の機能が発揮されるよう行う必要がある。
  --------------------------------------------------------------------------------------------------------------------

  --------------------------------------------------------------------------------------------------------------------

＜必　須＞

+------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| ダム管理者は、ダムが有する洪水調節、流水の正常な機能の維持及び利水補給等の機能が発揮されるよう、ダム施設及び貯水池の維持管理を行うとともに、流水管理を行うものとする。 |
|                                                                                                                                                                        |
| また、ダム管理者は、ダムの管理に係るフォローアップ（第4章参照）を行うものとする。                                                                                      |
+========================================================================================================================================================================+

＜推　奨＞

  --------------------------------------------------------------------------------------------------------------------------
  ダム施設及び貯水池の状態把握の結果の分析・評価、対策の実施においては、必要に応じて、専門家等の助言を得ることが望ましい。
  --------------------------------------------------------------------------------------------------------------------------

  --------------------------------------------------------------------------------------------------------------------------

2.  []{#_Toc198801710 .anchor}ダム施設及び貯水池の維持管理

＜考え方＞

+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| ダム施設及び貯水池の維持管理は、ダム施設の安全性及び機能を長期にわたり保持するとともに、貯水池機能を保持し、貯水池及びその周辺の環境を良好な状態に保全するよう行う必要がある。                                                                                                                                    |
|                                                                                                                                                                                                                                                                                                                   |
| ダム施設は、ダムの堤体、洪水吐き及び基礎地盤等（以下「堤体等」という。）の土木構造物、放流設備や係船設備等の機械設備、電源設備や通信設備等の電気通信設備、貯水池周辺斜面、観測・計測設備、その他の管理設備から構成されており（図1-1）、複数の設備等が一体となって、ダム施設の設置目的に応じた機能を発揮している。 |
|                                                                                                                                                                                                                                                                                                                   |
| ![](media/image1.emf){width="5.830555555555556in" height="7.513194444444444in"}                                                                                                                                                                                                                                   |
|                                                                                                                                                                                                                                                                                                                   |
| 図1-1　ダム施設の一般的な構成                                                                                                                                                                                                                                                                                     |
+===================================================================================================================================================================================================================================================================================================================+

＜必　須＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  ダム管理者は、ダムの安全が確保され、ダムが有する洪水調節、流水の正常な機能の維持及び利水補給等の機能が発揮されるよう、ダム施設及び貯水池の維持管理として巡視・点検・調査等を行い、これらの結果を分析・評価した上で、必要な対策を行うものとする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| ダム管理者は、ダム施設を構成する土木構造物、機械設備、電気通信設備及び貯水池周辺斜面等の各々の機能だけでなく、それらが構成する施設全体として必要な機能が発揮できるよう維持管理を行うことを基本とする。 |
|                                                                                                                                                                                                        |
| また、貯水池は、適正な利用や水源地域の活性化等も考慮しつつ、貯水池機能を保持し、貯水池及びその周辺の環境を良好な状態に保全するよう維持管理を行うことを基本とする。                                     |
+========================================================================================================================================================================================================+

3.  []{#_Toc192777831 .anchor}流水管理

＜考え方＞

+-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 河川管理施設のダムは、河川法第14条、特定多目的ダム法（昭和32年法律第35号）第31条、独立行政法人水資源機構法（平成14年法律第182号）第16条の規定に基づき、操作規則又は施設管理規程（以下「操作規則等」という。）を定めることとされている。 |
|                                                                                                                                                                                                                                         |
| 流水管理は、流域の降水量、流入量による貯水位の変化状況等の情報を把握するとともに、河川管理者と情報共有しながら操作規則等に基づき、行う必要がある。                                                                                      |
|                                                                                                                                                                                                                                         |
| また、既存施設の更なる有効活用を目的としたダムの弾力的な管理・運用の取り組みも重要である。                                                                                                                                              |
+=========================================================================================================================================================================================================================================+

＜必　須＞

  ------------------------------------------------------------------------------------------------------------------------------------------------
  ダム管理者は、ダムが有する洪水調節、流水の正常な機能の維持及び利水補給等の機能が発揮されるよう、操作規則等に基づき、ダムを操作するものとする。
  ------------------------------------------------------------------------------------------------------------------------------------------------

  ------------------------------------------------------------------------------------------------------------------------------------------------

4.  []{#_Toc192777832 .anchor}ダムの管理に係るフォローアップ

＜考え方＞

  --------------------------------------------------------------------------------------------------------------------------------------------------
  ダムの管理においては、洪水調節実績や環境への影響等を客観的・科学的に分析・評価し、ダムの維持管理の効率性及び透明性の一層の向上を図る必要がある。
  --------------------------------------------------------------------------------------------------------------------------------------------------

  --------------------------------------------------------------------------------------------------------------------------------------------------

＜必　須＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  ダム管理者は、一層適切なダムの管理を行うため、ダムの管理に係るフォローアップを行うことにより、洪水調節実績や環境への影響等を分析・評価し、必要に応じて、改善措置を講じるものとする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

2.  []{#_Toc192777833 .anchor}ダム施設及び貯水池の維持管理

    1.  []{#_Toc192777834 .anchor}ダム施設及び貯水池の計画的な維持管理

        1.  []{#_Toc192777835 .anchor}総説

＜考え方＞

+--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| ダムは、洪水調節、流水の正常な機能の維持及び利水補給等多様な目的を持つ社会資本であり、ダムの安全性及び機能を長期にわたり保持する必要があることから、ダム施設及び貯水池の維持管理を適切に行うことが重要である。                                                                                                                                                                                                                                               |
|                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| また、ダム施設及び貯水池の維持管理は、長期的視点を踏まえ、より効果的・効率的に行う必要がある。                                                                                                                                                                                                                                                                                                                                                               |
|                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| このため、ダム点検整備基準に基づく日常管理における巡視・点検、維持・修繕等に加え、より効果的・効率的に維持管理を行うためダムの長寿命化計画を定め、計画的に維持管理を行うとともに、巡視・点検等のダム管理の高度化・効率化に資するデジタル技術を含む新しい技術の導入に取り組むことが重要である。                                                                                                                                                               |
|                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| ダム施設の維持管理における点検・検査等は、ダム管理者が行う日常管理における巡視・点検、ダム管理者が専門家の意見を聴いて長期的観点から行うダム総合点検、ダム管理者以外の専門家等が行う定期検査により構成される（図2-1）。                                                                                                                                                                                                                                      |
|                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| また、貯水池の維持管理における調査・評価等は、巡視、観測・調査等、ダムの管理に係るフォローアップ、ダム総合点検等により構成される。                                                                                                                                                                                                                                                                                                                           |
|                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| このように、ダム施設及び貯水池の維持管理においては、ダム施設及び貯水池の状態と、その経年的な変化を継続的に把握することが重要であり、ダム管理者が行う日常管理における巡視・点検、観測・調査等と併せて、第三者の視点も含めた中長期的な点検・検査等を行い、ダム施設の安全性や貯水池機能の保持等の観点から、定期的に健全度等を評価する必要がある。                                                                                                               |
|                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| このため、ダム施設については、日常管理における巡視・点検と、中長期的な観点からの点検・検査等を組み合わせたPDCAサイクルにより維持管理を行うことが重要である（図2-2）。また、貯水池については、第4章に示すダムの管理に係るフォローアップの考え方に従い、PDCAサイクルによる維持管理を行うことが重要である。また、維持管理を継続的に実施していくためにはライフサイクルストの視点も重要であることと、非常用電源確保等の観点から管理用水力発電等の導入も検討する。 |
|                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| なお、巡視は、ダム施設を構成する設備全般及び貯水池周辺斜面等の異状の有無や、水質の状況、流木の流入状況及び不法行為の状況等について、概括的に状態を把握するために行うものであり、点検とは明確に区分されるものである。                                                                                                                                                                                                                                         |
|                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| ![](media/image2.emf)                                                                                                                                                                                                                                                                                                                                                                                                                                        |
|                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| 図2-1　ダム施設の維持管理における点検・検査等の構成                                                                                                                                                                                                                                                                                                                                                                                                          |
+==============================================================================================================================================================================================================================================================================================================================================================================================================================================================+

＜標　準＞

+--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| ダム施設及び貯水池の維持管理は、計画の策定（P）、状態把握（D）、分析・評価（C）及び対策（A）のPDCAサイクルにより行うとともに、維持管理において得られたデータを蓄積し、計画的な維持管理に反映することを基本とする。 |
|                                                                                                                                                                                                                    |
| なお、維持管理において得られたデータを共有し、より効果的・効率的に維持管理を行うため、データの蓄積においては、デジタル技術の積極的な活用を通じて、系統的に整理・保存することを基本とする。                         |
+====================================================================================================================================================================================================================+

＜例　示＞

+-----------------------------------------------------------------------+
| PDCAサイクルの例を図2-2に示す。                                       |
|                                                                       |
| 図2-2　PDCAサイクルのイメージ（ダム施設の維持管理）                   |
+=======================================================================+

＜関連通知等＞

1.  インフラ長寿命化基本計画，平成25年11月，インフラ老朽化対策の推進に関する関係省庁連絡会議．

<!-- -->

1.  国土交通省インフラ長寿命化計画（行動計画）
    令和3年度～令和7年度，令和3年6月18日（令和6年4月1日改訂）」，国土交通省.

2.  インフラ分野のDXアクションプラン2，令和5年3月，国土交通省.

3.  ダム総合点検実施要領について，平成25年10月1日，国水環第65号・国水環第66号，河川環境課長通知.

4.  ダム等の管理に係るフォローアップ制度の実施について，平成14年7月24日，国河環第32号，河川局長通達.

5.  河川管理施設のダムにおける定期検査の実施について，平成28年3月15日，国水流第20号，河川環境課長通知.

    1.  []{#_Toc192777836 .anchor}ダム施設の維持管理

＜考え方＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| > ダム施設の維持管理においては、ダム施設の安全性及び機能を長期にわたり保持する上での課題把握の観点から、巡視・日常点検、臨時点検、ダム総合点検及び定期検査により状態を定期的・継続的に把握し、それらの結果を総合的に分析・評価した上で、必要な対策を行う必要がある。 |
+======================================================================================================================================================================================================================================================================+

＜必　須＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------
  ダム管理者は、ダム施設の安全性及び機能を長期にわたり保持することを目的として、第2章第1節、第2節及び第3節に基づき、ダム施設の維持管理を行うものとする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------

  --------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  ダム施設の維持管理は、点検・検査等により、ダム施設の状態を把握し、それらの結果を分析・評価した上で、必要な対策を行うとともに、その後の維持管理に反映するPDCAサイクルにより行うことを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

1.  []{#_Toc198801717 .anchor}ダム点検整備基準

＜考え方＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  河川管理施設のダムは、河川法施行令、特定多目的ダム法施行令（昭和32年政令第188号）及び独立行政法人水資源機構法施行令（平成15年政令第329号）（以下「施行令」という。）の規定に基づき、操作規則等に施設及び施設を操作するため必要な機械、器具等の点検及び整備に関する事項等（以下「ダム点検整備基準」という。）を定めることとされており、ダム管理者は、ダム点検整備基準に基づき、ダム施設の日常管理における巡視・点検、維持・修繕等を行うことが必要である。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜必　須＞

+--------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| ダム管理者は、ダム点検整備基準に基づいて日常管理における巡視・点検を行い、その結果等に基づき、ダム施設の効率的な維持及び修繕が図られるよう必要な措置を講じるものとする。 |
|                                                                                                                                                                          |
| なお、ダム点検整備基準は、法令及び表2-1に示す一般的な技術基準に基づいて策定するものとする。                                                                              |
+==========================================================================================================================================================================+

+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 表2-1　ダム点検整備基準を策定するための一般的な技術基準                                                                                                                                                                                                                                  |
|                                                                                                                                                                                                                                                                                          |
| +-------------------------------------------------------------------------------------------------------------------------+------------------------------------------------------------------------------------------------------------------------------------------------------------+ |
| | > 1）ダム点検整備基準には、ダム施設を構成する堤体、洪水吐き、設備等の区分毎に、点検及び整備の頻度、実施時期及び方法を定めるものとする。                                                                                                                                              | |
| +--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+ |
| | > 2）ダム点検整備基準に定める点検の頻度、実施時期及び方法は、以下を標準とする。\                                                                                                                                                                                                     | |
| | > なお、洪水や積雪、工事等により、目視、計測等による点検を行うことが困難な場合は、可能な範囲及び方法で点検を行うものとする。                                                                                                                                                         | |
| +-------------------------------------------------------------------------------------------------------------------------+------------------------------------------------------------------------------------------------------------------------------------------------------------+ |
| | > １．堤体、洪水吐き等                                                                                                  | （１）毎日（閉庁日は除く。以下同じ。）、目視等により外観の変状の有無を確認する。                                                                           | |
| |                                                                                                                         |                                                                                                                                                            | |
| |                                                                                                                         | （２）年１回、出水期前に、目視等により水叩き部の洗掘状況を確認する。                                                                                       | |
| |                                                                                                                         |                                                                                                                                                            | |
| |                                                                                                                         | （３）下表のとおり漏水量、変形等の計測を行い、ダムの構造上の安全性を確認する。                                                                             | |
| |                                                                                                                         |                                                                                                                                                            | |
| |                                                                                                                         | ![](media/image3.emf){width="4.3283464566929135in" height="7.083070866141732in"}                                                                           | |
| +-------------------------------------------------------------------------------------------------------------------------+------------------------------------------------------------------------------------------------------------------------------------------------------------+ |
| | > ２．放流設備                                                                                                          | （１）毎年、出水期前に１回、管理運転を伴う各部の測定等の詳細な点検を行い、設備の異状の有無を確認する。                                                     | |
| |                                                                                                                         |                                                                                                                                                            | |
| |                                                                                                                         | （２）毎年、出水期中及び出水期後に各１回、支障がない限り管理運転による動作確認を行い、設備の異状の有無を確認する。                                         | |
| |                                                                                                                         |                                                                                                                                                            | |
| |                                                                                                                         | （３）放流前後に、目視等により設備の異状の有無を確認する。                                                                                                 | |
| +-------------------------------------------------------------------------------------------------------------------------+------------------------------------------------------------------------------------------------------------------------------------------------------------+ |
| | > ３．予備発電設備                                                                                                      | （１）月１回、管理運転による動作確認を行い、設備の異状の有無を確認する。                                                                                   | |
| |                                                                                                                         |                                                                                                                                                            | |
| |                                                                                                                         | （２）洪水警戒体制に入る場合、又は入ることが予想される場合は、目視等により設備の異状の有無を確認する。                                                     | |
| +-------------------------------------------------------------------------------------------------------------------------+------------------------------------------------------------------------------------------------------------------------------------------------------------+ |
| | > ４．ダム管理用制御処理設備                                                                                            | （１）毎日、目視等により設備の異状の有無を確認する。                                                                                                       | |
| |                                                                                                                         |                                                                                                                                                            | |
| |                                                                                                                         | （２）年１回、遠方操作等によるゲート動作確認、各部の測定等の詳細な点検を行い、設備の異状の有無を確認する。                                                 | |
| +-------------------------------------------------------------------------------------------------------------------------+------------------------------------------------------------------------------------------------------------------------------------------------------------+ |
| | > ５．放流警報設備                                                                                                      | １　管理所                                                                                                                                                 | |
| |                                                                                                                         |                                                                                                                                                            | |
| |                                                                                                                         | （１）毎日、目視等により設備の異状の有無を確認する。                                                                                                       | |
| |                                                                                                                         |                                                                                                                                                            | |
| |                                                                                                                         | （２）年２回、各部の測定等の詳細な点検を行い、設備の異状の有無を確認する。                                                                                 | |
| |                                                                                                                         |                                                                                                                                                            | |
| |                                                                                                                         | ２　警報所                                                                                                                                                 | |
| |                                                                                                                         |                                                                                                                                                            | |
| |                                                                                                                         | （１）年２回、管理所より動作確認を行い、無線回線及び警報所の電源状態を確認する。                                                                           | |
| |                                                                                                                         |                                                                                                                                                            | |
| |                                                                                                                         | （２）洪水警戒体制に入る場合、又はダムから放流が予想される場合は、管理所より動作確認を行い、無線回線及び警報所の電源状態を確認する。                       | |
| +-------------------------------------------------------------------------------------------------------------------------+------------------------------------------------------------------------------------------------------------------------------------------------------------+ |
| | > ６．その他ダム及びダムを操作するために必要な機械、器具等                                                              | （１）月１回、動作確認等を行い、１．（３）の計測を行うために必要な計測装置等の異状の有無を確認する。                                                       | |
| |                                                                                                                         |                                                                                                                                                            | |
| |                                                                                                                         | （２）その他ダム及びダムを操作するために必要な機械、器具等について、その機能を保持するため、適切な時期に、目視その他適切な方法により点検を行うものとする。 | |
| +-------------------------------------------------------------------------------------------------------------------------+------------------------------------------------------------------------------------------------------------------------------------------------------------+ |
| | > 3）ダム点検整備基準に定める整備の頻度、実施時期及び方法のうち、維持及び修繕の頻度、実施時期及び方法は、以下を標準とする。                                                                                                                                                          | |
| |                                                                                                                                                                                                                                                                                      | |
| | １．適切な時期にダム施設の巡視を行い、以下について確認するものとする。                                                                                                                                                                                                               | |
| |                                                                                                                                                                                                                                                                                      | |
| | 　（１）堤体、洪水吐き等の劣化、摩耗、ひび割れ及び継目の開き等、外観の変状の有無                                                                                                                                                                                                     | |
| |                                                                                                                                                                                                                                                                                      | |
| | 　（２）放流設備や放流警報設備等の設備全般の異状の有無                                                                                                                                                                                                                               | |
| |                                                                                                                                                                                                                                                                                      | |
| | 　（３）管理用道路及び貯水池周辺斜面等の異状の有無                                                                                                                                                                                                                                   | |
| |                                                                                                                                                                                                                                                                                      | |
| | > ２．ダム施設を良好な状態に保つため、点検結果等を踏まえ、ダム施設の効率的な維持及び修繕が図られるよう必要な措置を講じるものとする。                                                                                                                                                 | |
| +--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+ |
| | > 4）この基準は、ダム点検整備基準を策定又は変更する場合の一般的な技術基準を定めたものであり、ダム管理者は、法令及びこの基準の趣旨を逸脱しない範囲において、ダム点検整備基準を定めることができるものとする。                                                                          | |
| +--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+ |
| | > 5）この基準は、ダム施設を構成する主要な設備等の点検及び整備について、一般的な技術基準を定めたものであり、ダム管理者は、ダムの特性等を考慮し、この基準に取り上げていない目的や機能を有する設備等について、適宜区分の追加等を行うものとする。                                        | |
| +--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+ |
+==========================================================================================================================================================================================================================================================================================+

＜標　準＞

+-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| ダム施設の安全性及び機能を長期にわたり保持するため、点検結果等に基づき、ダムの効率的な維持及び修繕が図られるよう必要な措置を講じることに加え、必要に応じて、改良を行うことを基本とする。                  |
|                                                                                                                                                                                                           |
| ダム点検整備基準は、表2-2「ダム点検整備基準の作成例」を参考に、ダム施設の構造の特徴、環境条件、使用条件、試験湛水時の状況及び類似のダムでの維持管理の実績等を総合的に勘案して、策定することを基本とする。 |
|                                                                                                                                                                                                           |
| なお、ダム点検整備基準は、日常管理における巡視・点検や定期検査等の結果を踏まえ、必要に応じて、見直しを行うことを基本とする。                                                                              |
+===========================================================================================================================================================================================================+

+-----------------------------------------------------------------------+
| 表2-2　ダム点検整備基準の作成例                                       |
|                                                                       |
| ![](media/image4.emf){width="5.822645450568679in"                     |
| height="8.608695319335084in"}                                         |
|                                                                       |
| ![](media/image5.emf){width="5.830555555555556in"                     |
| height="4.184803149606299in"}                                         |
|                                                                       |
| ![](media/image6.emf){width="5.830555555555556in"                     |
| height="9.155915354330709in"}                                         |
|                                                                       |
| ![](media/image7.emf){width="5.830555555555556in"                     |
| height="5.32125656167979in"}                                          |
+=======================================================================+

＜参考となる資料＞

1.  改定ダム構造物管理基準，昭和61年5月，(社)日本大ダム会議．

2.  土木研究所資料第1834号　ダムの安全管理，建設省土木研究所，1982．

    1.  []{#_Toc198801718 .anchor}ダムの長寿命化計画

＜考え方＞

  ------------------------------------------------------------------------------------------------------------------------------------
  ダム施設の維持管理は、ダム点検整備基準に加え、ダムの長寿命化計画を策定し、長期的視点を踏まえ、より効果的・効率的に行う必要がある。
  ------------------------------------------------------------------------------------------------------------------------------------

  ------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| ダム管理者は、ダムの安全性及び機能を長期にわたり保持するため、ダム点検整備基準に基づいて行う日常管理における巡視・点検、維持・修繕等に加え、長期的視点を踏まえたダムの維持管理及び設備の更新等をより効果的・効率的に行うため、点検結果や健全度の評価等を踏まえ、ダムを構成する設備等毎の維持管理に係る中長期的な維持管理方針を定めたダムの長寿命化計画^1)2)^を策定し、これに基づいて保全対策等を行うことを基本とする。 |
|                                                                                                                                                                                                                                                                                                                                                                                                                        |
| なお、ダムの長寿命化計画には、ダムを構成する土木構造物、機械設備、電気通信設備等について、点検結果や健全度の評価等を踏まえて、ダムの維持管理及び設備の更新等に係る中長期的な方針・計画等を定めるものとし、ダムの長寿命化計画の策定においては、相互に関連する設備間の調整を図るよう留意することを基本とする。                                                                                                           |
|                                                                                                                                                                                                                                                                                                                                                                                                                        |
| また、ダムの長寿命化計画は、点検結果や健全度の評価等を継続的に行った結果を踏まえ、必要に応じて、見直しを行うことを基本とする。                                                                                                                                                                                                                                                                                         |
|                                                                                                                                                                                                                                                                                                                                                                                                                        |
| ダムの長寿命化計画は、下記要領等の考え方に沿って策定することを基本とする。                                                                                                                                                                                                                                                                                                                                             |
|                                                                                                                                                                                                                                                                                                                                                                                                                        |
| (1)ダム総合点検実施要領^4)5)^                                                                                                                                                                                                                                                                                                                                                                                          |
|                                                                                                                                                                                                                                                                                                                                                                                                                        |
| > ダムの安全性及び機能を長期にわたり保持する観点から、ダムの健全度を把握するとともに今後の維持管理方針を定めるために、ダム総合点検の実施方針及び実施手順を示した要領                                                                                                                                                                                                                                                   |
|                                                                                                                                                                                                                                                                                                                                                                                                                        |
| (2)ダム用ゲート設備等点検・整備・更新検討要領^6)7)^                                                                                                                                                                                                                                                                                                                                                                    |
|                                                                                                                                                                                                                                                                                                                                                                                                                        |
| > ダム用ゲート設備等の信頼性を確保しつつ、効果的・効率的な維持管理の実現を目的として、ダム用ゲート設備等の維持管理の実施方針を示した要領                                                                                                                                                                                                                                                                               |
|                                                                                                                                                                                                                                                                                                                                                                                                                        |
| (3)電気通信施設維持管理計画指針（案）^8)9)^                                                                                                                                                                                                                                                                                                                                                                            |
|                                                                                                                                                                                                                                                                                                                                                                                                                        |
| > 電気通信施設について、リスク管理や安全性の確保を図りつつ、部分更新や改造等の長寿命化対策を行い、既存資産の有効活用を図る中長期的な維持管理計画を策定するための指針                                                                                                                                                                                                                                                   |
+========================================================================================================================================================================================================================================================================================================================================================================================================================+

＜推　奨＞

  -------------------------------------------------------------------------------------------------
  ダムの長寿命化計画は、定期検査の頻度を踏まえ、おおむね3年ごとに見直しを検討することが望ましい。
  -------------------------------------------------------------------------------------------------

  -------------------------------------------------------------------------------------------------

＜例　示＞

+--------------------------------------------------------------------------------------------------------+
| インフラ長寿命化基本計画^1)^に記されている、個別施設毎に策定する長寿命化計画に記載する事項を例示する。 |
|                                                                                                        |
| > 対象施設、計画期間、対策の優先順位の考え方、個別施設の状態等、                                       |
| >                                                                                                      |
| > 対策内容と実施時期、対策費用                                                                         |
+========================================================================================================+

＜関連通知等＞

1.  インフラ長寿命化基本計画，平成25年11月，インフラ老朽化対策の推進に関する関係省庁連絡会議．

2.  国土交通省インフラ長寿命化計画（行動計画）
    令和3年度～令和7年度，令和3年6月18日（令和6年4月1日改訂）」，国土交通省．

3.  インフラ分野のDXアクションプラン2，令和5年3月，国土交通省.

4.  ダム総合点検実施要領について，平成25年10月1日，国水環第65号・国水環第66号，河川環境課長通知．

5.  ダム総合点検実施要領・同解説，平成25年10月，国土交通省水管理・国土保全局河川環境課．

6.  ダム用ゲート設備等点検・整備標準要領（案），平成30年3月，国土交通省総合政策局公共事業企画調整課施工安全企画室．

7.  ダム用ゲート設備等点検・整備・更新検討マニュアル（案），平成30年3月30日，国土交通省総合政策局公共事業企画調整課施工安全企画室・水管理・国土保全局河川環境課流水管理室．

8.  電気通信施設維持管理計画指針（案），令和4年3月，国土交通省大臣官房技術調査課電気通信室．

9.  電気通信施設維持管理計画作成の手引き（案），令和4年3月，国土交通省大臣官房技術調査課電気通信室．

    1.  []{#_Toc198801719 .anchor}ダム管理用水力発電設備

＜考え方＞

+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| ダム管理用水力発電設備は、商用電源の一部を自らの発電で賄うことによりダムの維持管理費を縮減するほか、非常時の電源ともなるものである。                                                                                                                    |
|                                                                                                                                                                                                                                                         |
| ダム管理用水力発電設備を有するダムには、電気事業法（昭和39年法律第170号）第43条及び第44条の規定により、設備の維持及び運用に関する保安の監督をさせるため、最大出力及びダム高等の規模に応じて、電気主任技術者やダム水路主任技術者の選任が定められている。 |
+=========================================================================================================================================================================================================================================================+

＜標　準＞

+--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| ダム管理用水力発電設備については、社会条件の変化に応じて、ダムの維持管理費の縮減及びダムの包蔵する水力エネルギーの適正利用が図られるよう、設置又は更新の検討を行うことを基本とする。 |
|                                                                                                                                                                                      |
| ダム管理用水力発電設備の維持・修繕等は、発電不可能な期間が極力少なくなるよう効率的に行うことを基本とする。                                                                           |
+======================================================================================================================================================================================+

＜推　奨＞

  ----------------------------------------------------------------------------------------------------------------------------
  非常時においても確実に電源が確保できるようにするため、商用電源の停電時にも発電可能な機能を有する設備とすることが望ましい。
  ----------------------------------------------------------------------------------------------------------------------------

  ----------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1.  ダム・堰施設技術基準（案）の一部改定について，平成28年3月31日，国技電第72号・国総公第80号・国水環第140号・国水治第142号，技術調査課長・公共事業企画調整課長・河川環境課長・治水課長通知．

    1.  []{#_Toc192777837 .anchor}貯水池の維持管理

＜考え方＞

+--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 貯水池の維持管理においては、貯水池機能の保持、貯水池及びその周辺の環境を良好な状態に保全する上での課題把握の観点から、巡視、水文・水理観測及び気象情報の収集、堆砂調査、水質調査、環境調査等により状態を定期的・継続的に把握し、それらの結果を総合的に分析・評価した上で、必要な対策を行う必要がある。 |
|                                                                                                                                                                                                                                                                                                        |
| また、貯水池の適正な利用や、水源地域の活性化に継続的に取り組む必要がある。                                                                                                                                                                                                                             |
+========================================================================================================================================================================================================================================================================================================+

＜必　須＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  ダム管理者は、貯水池機能の保持、貯水池及びその周辺の環境を良好な状態に保全することを目的として、第2章第1節、第2節及び第4節に基づき、貯水池の維持管理を行うものとする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

  ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  貯水池の維持管理は、第4章に示すダムの管理に係るフォローアップの考え方に従い、貯水池の状態を把握し、それらの結果を客観的・科学的に分析・評価した上で、必要な改善措置を講じるとともに、その後の維持管理に反映するPDCAサイクルにより行うことを基本とする。
  ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

1.  []{#_Toc192777838 .anchor}ダム施設及び貯水池の状態把握

    1.  []{#_Toc192777839 .anchor}総説

＜考え方＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| ダムは、洪水調節、流水の正常な機能の維持及び利水補給等多様な目的を持つ重要な社会資本である。このため、ダムの安全性及び機能を長期にわたり保持する上で、ダム施設及び貯水池の状態を定期的・継続的に把握するとともに、その記録を系統的に整理・保存し、活用することが重要である。そのためには、調査・測量から設計、施工、維持管理・更新等までの一連の過程で取得した必要となる各種情報について、その取得、記録及び活用の面で各種デジタル技術を含む新たな技術も積極的に活用することで、高度化・効率化を進めることが有効である。また、大規模災害時においても、ダムの安全確認や状態監視が可能となるようにするため、非常時のアクセス手段や遠隔での状態監視の方法、必要な電力や通信の確保について、予め十分に検討しておく必要がある。 |
|                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            |
| なお、流水型ダム等、維持管理の実績の少ない形式のダムについては、当該ダムの特徴を踏まえた維持管理を行うことを通じて、維持管理に関する知見の蓄積を図り、当該ダム及び類似条件のダムの維持管理の充実を図るための基礎資料とすることも重要である。                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |
+============================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================+

＜必　須＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  ダム管理者は、巡視、目視・計測等による日常点検、地震後点検等の臨時点検、ダム総合点検及び定期検査、並びに水文・水理観測及び気象情報の収集、堆砂調査、水質調査、環境調査等の観測・調査等により、ダム施設及び貯水池の状態を把握するものとする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  ダム施設や貯水池の状態を定期的・継続的に把握するための各種点検等の高度化・効率化や大規模災害時等の非常時における安全確認や状態監視に有効と考えられる各種の技術については、新たな技術を含め、その積極的な活用を検討することが望ましい。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜例　示＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| ・「安全性の向上」、「点検効率の改善」、「成果の均一性」などの効果を目的に、点検業務等のうちダム管理者が必要と判断するものについては、ロボットの活用を検討することが考えられる^5)6)7）^。                                                                                  |
|                                                                                                                                                                                                                                                                            |
| ・ダムの安全管理のための計測において、迅速にダム堤体等構造物の変位（変形）が把握可能なGNSS、昼夜・天候を問わず地表変位の計測が可能な衛星SARなど、衛星データの活用も考えられる。衛星SARは地上アクセスが難しい貯水池周辺斜面を含む広域的な地表変位の監視に有効な場合もある。 |
|                                                                                                                                                                                                                                                                            |
| ・ダムの安全管理のために設置される計器のうち、例えば地震計からは加速度以外にダムの状態把握に有効な振動特性に関する情報も得られるため、健全性のモニタリングに活用することも考えられる。                                                                                     |
|                                                                                                                                                                                                                                                                            |
| ・その他、状態把握に用いる有効な技術の選定にあたっては、ダム点検技術カタログ^8)^の活用が考えられる。                                                                                                                                                                       |
+============================================================================================================================================================================================================================================================================+

＜関連通知等＞

1.  ダム総合点検実施要領について，平成25年10月1日，国水環第65号・国水環第66号，河川環境課長通知．

<!-- -->

6.  河川管理施設のダムにおける定期検査の実施について，平成28年3月15日，国水流第20号，河川環境課長通知．

7.  河川砂防技術基準調査編，第2章（令和4年6月）,第4章（平成26年4月）,第6章（平成26年4月）,第12章（平成26年4月）,第13章（平成26年4月）,第16章（平成26年4月）,第22章（令和4年6月），国土交通省水管理・国土保全局．

8.  ダム貯水池水質調査要領，平成27年3月，国土交通省水管理・国土保全局河川環境課．

9.  水中部点検におけるロボット活用マニュアル（案）【ダム放流設備編】【ダム堤体編】，平成31年2月，国土交通省総合政策局公共事業企画調整課.

10. 水中部点検におけるロボットの活用について，平成31年2月25日，国総公第105号・国水環第155号，総合政策局公共事業企画調整課長・水管理・国土保全局河川環境課長通知.

11. 水中部点検におけるロボットの活用にあたっての具体的な措置について，平成31年2月25日，国総公第105号・国水環第155号，総合政策局公共事業企画調整課長・水管理・国土保全局河川環境課長通知．

12. ダム点検技術カタログ，令和5年3月，国土交通省水管理・国土保全局河川環境課．

＜参考となる資料＞

13. 国土技術政策総合研究所資料第1233号，衛星SARデータを用いたロックフィルダムおよび貯水池周辺斜面の変位計測マニュアル(案)，令和4年12月，国土交通省国土技術政策総合研究所，2022.

14. 地盤工学会誌　Vol.72
    No.10　XバンドSAR衛星を活用したフィルダムの変位計測：小堀俊秀・井上晃輔・櫻井寿之・佐藤匠・本田謙一・田口智大，2024.

15. フィルダムの変位計測に関するGPS導入マニュアル,平成26年12月，（一社）ダム工学会.

16. ダム工学　Vol.30
    No.1，GPSを用いたコンクリートダムの変位計測(1)，山口大学・ダム工学会計測管理研究部会，2020.

17. ダム工学　Vol.30
    No.1，GPSを用いたコンクリートダムの変位計測(Ⅱ)，山口大学・ダム工学会計測管理研究部会，2020.

18. ダム工学　Vol.31
    No.1，GPSを用いたコンクリートダムの変位計測(Ⅲ)，山口大学・ダム工学会計測管理研究部会，2021.

19. ダム工学　Vol.31
    No.2，GPSを用いたコンクリートダムの変位計測(Ⅳ)，山口大学・ダム工学会計測管理研究部会，2021.

20. 令和6年能登半島地震施設被害調査報告，国土技術政策総合研究所資料，2025.

    1.  []{#_Toc192777840 .anchor}点検等

        1.  []{#_Toc198801724 .anchor}巡視・日常点検

＜考え方＞

+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 巡視・日常点検は、ダムの安全性及び機能を長期にわたり保持する上での課題把握を目的として、計画的に行う必要がある。                                                                                                                                                                                            |
|                                                                                                                                                                                                                                                                                                             |
| 堤体等は、ダム施設を構成する重要な構造物であり、その安全性を保持する必要がある。河川管理施設等構造令（昭和51年政令第199号）^1)^（以下「構造令」という。）においては、これらが具備すべき安全性の要件が定められており、ダムが存続する限り、新築又は改築の際に確保された安全性を保持することが求められている。 |
|                                                                                                                                                                                                                                                                                                             |
| ダム施設の安全性を確認し、異常発生の兆候を察知するには、巡視、目視・計測等による日常点検から得られる情報が不可欠である。巡視・日常点検により、ダム施設の状態を把握して、安全性及び機能への影響を確実に確認する必要がある。                                                                                  |
|                                                                                                                                                                                                                                                                                                             |
| 構造令第13条に基づいて設置される計測装置による計測項目は、ダムの安全性を継続的に監視するために不可欠なものであることから、継続的な計測により、試験湛水開始時点からの経時的な変化や、過去の強い地震の発生時における計測データとの比較が可能となるようにする必要がある。                                      |
|                                                                                                                                                                                                                                                                                                             |
| 巡視や、目視による点検は、計測装置による計測では把握できないダム施設の状態を把握するために行うものであり、ダム施設における異常発生やその兆候の有無を確認する上で重要な手段である。                                                                                                                          |
+=============================================================================================================================================================================================================================================================================================================+

＜必　須＞

  --------------------------------------------------------------------------
  ダム管理者は、巡視・日常点検を行い、ダム施設の状態を把握するものとする。
  --------------------------------------------------------------------------

  --------------------------------------------------------------------------

＜標　準＞

+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 巡視・日常点検は、ダム点検整備基準及びダムの長寿命化計画に基づいて行うことを標準とする。                                                                                                                                                                                           |
|                                                                                                                                                                                                                                                                                    |
| 巡視・日常点検は、ダム施設を構成する土木構造物、機械設備、電気通信設備、貯水池周辺斜面等の設備等毎に、巡視による確認事項や、計測項目ごとに設定された管理基準値、管理運転時の点検項目等に従って行うとともに、巡視・点検結果の記録を系統的に整理・保存し、蓄積することを基本とする。 |
|                                                                                                                                                                                                                                                                                    |
| 蓄積する記録は、ダムの長寿命化の観点から、劣化・損傷等の状態の継続的な把握と、その進行状況がわかるようにすることを基本とする。                                                                                                                                                     |
+====================================================================================================================================================================================================================================================================================+

＜推　奨＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  渇水等により貯水位が低下している場合は、貯水池周辺斜面について、目視や挙動の計測値の確認等による点検を行うとともに、通常水没している堤体上流面や貯水池周辺斜面下部についても、目視等による点検を行うことが望ましい。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1.  河川管理施設等構造令及び同令施行規則の施行について，昭和51年11月23日，建河政発第70号，河川局長通達．

＜参考となる資料＞

21. 改定解説・河川管理施設等構造令，平成12年1月，（財）国土開発技術研究センター編．

<!-- -->

1.  土木構造物の巡視・日常点検

＜考え方＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 堤体等の土木構造物は、劣化・損傷等が進行すればダムの安全性に影響を与える可能性があることから、土木構造物の巡視・日常点検は、計画的かつ確実に行う必要がある。                                                                                             |
|                                                                                                                                                                                                                                                          |
| 堤体等の土木構造物の安全性を確認し、異常発生の兆候を察知するには、巡視に加えて、堤体等における計測等の点検から得られる情報が不可欠である。巡視・日常点検により、堤体等の挙動を監視して、安全性が保持されていることを確認する必要がある。                 |
|                                                                                                                                                                                                                                                          |
| また、ダム建設時の施工等の記録及び基礎地盤の状況等を踏まえ、これまでの計測結果を分析・評価した上で、ダムの安全管理上の着目すべき事項等を検討し、堤体等の土木構造物の安全性の確認をより効果的・効率的に行うための計測方法等に関する技術開発が重要である。 |
+==========================================================================================================================================================================================================================================================+

＜標　準＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 土木構造物の巡視・日常点検は、土木構造物の安全性及び機能を長期にわたり保持するため、ダム点検整備基準及びダムの長寿命化計画に基づいて行うことを標準とする。                                                                 |
|                                                                                                                                                                                                                            |
| 堤体等の巡視・日常点検においては、構造物の劣化・損傷等がダムの機能に与える影響の度合いを考慮し、異常発生の兆候を察知して必要な措置を講じることができるよう、目視や計測等により、構造上の安全性を確認することを基本とする。 |
|                                                                                                                                                                                                                            |
| 堤体等の日常点検においては、各種計測装置の作動状態も確認することを基本とする。                                                                                                                                             |
|                                                                                                                                                                                                                            |
| 堤体等の計測においては、設計条件、試験湛水時の挙動計測結果を踏まえ、貯水位等の荷重状態の変化と併せて、漏水量、変形、揚圧力（コンクリートダム）、浸潤線（均一型フィルダム）の経時的な変動を把握することを基本とする。       |
|                                                                                                                                                                                                                            |
| ダム建設時に課題となった点や、巡視・日常点検、臨時点検、ダム総合点検及び定期検査で把握した着目すべきポイントを明確にし、巡視経路や点検方法等をあらかじめ定めることを基本とする。                                           |
|                                                                                                                                                                                                                            |
| なお、常時において流水を貯留しない流水型ダムについても、1.2.1ダム点検整備基準「ダム点検整備基準を策定するための一般的な技術基準」第2に示すダムの構造型式に応じた標準的な頻度に基づいて、日常点検を行うことを基本とする。   |
+============================================================================================================================================================================================================================+

＜推　奨＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 漏水量等の計測においては、設計条件、試験湛水時の挙動計測結果及び経時的な計測値等を踏まえ、管理基準値を設定することが望ましい。                                                         |
|                                                                                                                                                                                        |
| 土木構造物の劣化・損傷等に対しては、異常発生の兆候が認められる場合は、変状のメカニズムを把握するため、継続的に追跡調査を行うことが望ましい。                                           |
|                                                                                                                                                                                        |
| また、土木構造物と放流設備等の境界部分（堤体に埋設されているアンカーや戸当り部分等）が点検対象から漏れることがないよう、各施設・設備の境界部分について点検の内容を確認するよう努める。 |
+========================================================================================================================================================================================+

＜例　示＞

+--------------------------------------------------------------------------------------------+
| 巡視・日常点検による確認事項としては、以下の事項が考えられる。                             |
|                                                                                            |
| (1)ダム施設の安全性に関する確認事項                                                        |
|                                                                                            |
| 【巡視】                                                                                   |
|                                                                                            |
| ①                                                                                          |
| 監査廊、堤体の上下流面や天端における継目の開き、ひび割れ、コンクリートの剥離・剥落等の有無 |
|                                                                                            |
| ② 監査廊、堤体のひび割れや継目、水平打継目からの漏水、エフロレッセンスの有無               |
|                                                                                            |
| ③ 堤体の堤趾部や両岸の基礎地盤からの漏水の有無                                             |
|                                                                                            |
| ④ 洪水吐き（越流部、導流壁、減勢工等）コンクリート部の異状の有無                           |
|                                                                                            |
| 【日常点検】                                                                               |
|                                                                                            |
| ① 基礎排水孔や浸透流観測孔からの排水、漏水の濁りの有無                                     |
|                                                                                            |
| ② 下流河川の急激な河床洗掘の有無                                                           |
|                                                                                            |
| (2)計測装置の状態、異状の検知に関する確認事項                                              |
|                                                                                            |
| 【巡視】                                                                                   |
|                                                                                            |
| ① 視準測量を行う標的の設置状態                                                             |
|                                                                                            |
| 【日常点検】                                                                               |
|                                                                                            |
| ① 基礎排水孔や浸透流観測孔の開閉バルブの状態、圧力計の状態                                 |
|                                                                                            |
| ② 三角堰の堰板の状態、整流板の状態、水位計（水圧計）の状態                                 |
|                                                                                            |
| ③ プラムラインの視準器の状態、振子の状態、油槽の状態                                       |
+============================================================================================+

＜参考となる資料＞

1.  多目的ダムの建設－平成17年版，第7巻，第37章，（財）ダム技術センター，2005．

<!-- -->

22. 土木研究所資料第1834号　ダムの安全管理，建設省土木研究所，1982．

<!-- -->

2.  機械設備の巡視・日常点検

＜考え方＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  機械設備は、堤体や洪水吐きに設置された放流設備、係船設備及び堤内排水設備等の設備であり、洪水調節、流水の正常な機能の維持及び利水補給等に係る放流設備の機能には高い信頼性が求められることから、機械設備の巡視・日常点検は、計画的かつ確実に行う必要がある。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 機械設備の巡視・日常点検は、機械設備の機能を保持するため、ダム点検整備基準及びダム・堰施設技術基準（案）^1)^に基づき、また、ダム用ゲート設備等点検・整備・標準要領(案)等^2)3)^を参考として行うことを基本とする。                                                                                                                                                                                     |
|                                                                                                                                                                                                                                                                                                                                                                                                      |
| また、必要に応じて、機能及び動作の確認を行う点検を行い、設備の状態把握を行うことを基本とする。                                                                                                                                                                                                                                                                                                       |
|                                                                                                                                                                                                                                                                                                                                                                                                      |
| 日常点検は、設備の信頼性確保を目的として、定期点検及び運転時点検を行うことを基本とする。                                                                                                                                                                                                                                                                                                             |
|                                                                                                                                                                                                                                                                                                                                                                                                      |
| 日常点検は、設備の設置目的、装置・機器等の特性、稼働形態、運用条件等に応じて行うことを基本とし、特に待機系設備の信頼性を確保するため、定期的に動作確認を行うことを基本とする。                                                                                                                                                                                                                       |
|                                                                                                                                                                                                                                                                                                                                                                                                      |
| 計測を行う場合は、その結果に基づいて、技術的判断を行うことを基本とする。                                                                                                                                                                                                                                                                                                                             |
|                                                                                                                                                                                                                                                                                                                                                                                                      |
| 腐食の程度や油脂類の汚染度等、劣化の傾向を把握することが可能な項目については、点検において必要な劣化診断や経時記録の管理を行うことを基本とする。                                                                                                                                                                                                                                                     |
|                                                                                                                                                                                                                                                                                                                                                                                                      |
| 機械設備の日常点検は、以下のとおり行うことを基本とする。日常点検の構成について図2-3に示す。                                                                                                                                                                                                                                                                                                          |
|                                                                                                                                                                                                                                                                                                                                                                                                      |
| (1)定期点検                                                                                                                                                                                                                                                                                                                                                                                          |
|                                                                                                                                                                                                                                                                                                                                                                                                      |
| > 定期点検は、放流設備等の状態把握並びに機能保全を図るため、当該設備の目的・機能・設置環境に対応した方法で行う。                                                                                                                                                                                                                                                                                     |
|                                                                                                                                                                                                                                                                                                                                                                                                      |
| (2)運転時点検                                                                                                                                                                                                                                                                                                                                                                                        |
|                                                                                                                                                                                                                                                                                                                                                                                                      |
| > 運転時点検は、主に待機系設備の運転・操作開始時の障害（作動音、発熱、振動、異臭等）の有無、運転・操作中及び運転・操作終了後の異状の有無や変化等の状態把握を行うため、原則として運転操作時に行う。放流前点検及び放流後点検で行う内容及び項目は、放流設備の社会的な影響度や機能、設置環境等に適したものとする必要がある。なお、運転時点検において異状・不具合が検知された場合は、その状況を記録する。 |
|                                                                                                                                                                                                                                                                                                                                                                                                      |
| ![](media/image8.emf){width="5.828562992125984in" height="1.913043525809274in"}                                                                                                                                                                                                                                                                                                                      |
|                                                                                                                                                                                                                                                                                                                                                                                                      |
| 図2-3　機械設備の日常点検の構成                                                                                                                                                                                                                                                                                                                                                                      |
+======================================================================================================================================================================================================================================================================================================================================================================================================+

＜例　示＞

+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 機械設備の日常点検の際に留意する事項としては、以下の事項が考えられる。                                                                                                                                                             |
|                                                                                                                                                                                                                                    |
| ①                                                                                                                                                                                                                                  |
| 各種放流設備等の取付け状況、回転・摺動部の作動状況、塗装の劣化状況、戸当りへの土砂の堆積状況、水門扉の開閉に対する障害物や支障の有無、関連設備の状態、開閉操作の機能及び安全の確保状況、水密部の漏水、放流時の振動・異常音の有無等 |
|                                                                                                                                                                                                                                    |
| ② 機側操作盤での機器の電流値、電圧値、作動状況、機器の表示についての異状の有無等                                                                                                                                                   |
|                                                                                                                                                                                                                                    |
| ③ 安全装置及び保護装置の作動状況                                                                                                                                                                                                   |
+====================================================================================================================================================================================================================================+

＜関連通知等＞

1.  ダム・堰施設技術基準（案）の一部改定について，平成28年3月31日，国技電第72号・国総公第80号・国水環第140号・国水治第142号，技術調査課長・公共事業企画調整課長・河川環境課長・治水課長通知．

<!-- -->

23. ダム用ゲート設備等点検・整備標準要領（案），平成30年3月，国土交通省総合政策局公共事業企画調整課施工安全企画室．

24. ダム用ゲート設備等点検・整備・更新検討マニュアル（案），平成30年3月，国土交通省総合政策局公共事業企画調整課・水管理・国土保全局河川環境課流水管理室．

＜参考となる資料＞

25. ゲート点検・整備要領（案），平成17年1月（社）ダム・堰施設技術協会．

<!-- -->

3.  電気通信設備の巡視・日常点検

＜考え方＞

+-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 電気通信設備は、電源設備、通信設備及びダム管理用制御処理設備等であり、設備の機能には高い信頼性が求められることから、電気通信設備の巡視・日常点検は、計画的かつ確実に行う必要がある。                                                                            |
|                                                                                                                                                                                                                                                                 |
| なお、本基準においては「電気通信設備」を、電気通信施設のうち、ダム施設を構成する設備の総称として用いている。                                                                                                                                                    |
|                                                                                                                                                                                                                                                                 |
| 電源設備は、通常自家用電気工作物に該当し、電気事業法（昭和39年法律第170号）では、設置者に機能の安全と維持義務を課すとともに、具体的な保守業務が的確に遂行されるよう、保安規程の作成、届出及び遵守、電気主任技術者の選任及び自主保安体制の確保が定められている。 |
+=================================================================================================================================================================================================================================================================+

＜標　準＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 電気通信設備の巡視・日常点検は、電気通信設備の機能を保持するため、ダム点検整備基準及び電気通信施設点検基準（案）^1)^に基づき、各設備を構成する機器の特性に応じて行うことを標準とする。 |
|                                                                                                                                                                                        |
| 放流設備の運転・操作を伴うダム管理用制御処理設備等の電子応用設備の点検においては、監視機器・遠方操作盤等により設備の状態把握を行うほか、機側の設備の状態を確認することを基本とする。   |
|                                                                                                                                                                                        |
| 電気通信設備の日常点検は、以下のとおり行うことを基本とする。日常点検の構成について図2-4に示す。                                                                                        |
|                                                                                                                                                                                        |
| (1)定期点検                                                                                                                                                                            |
|                                                                                                                                                                                        |
| > 定期点検は、設備の特性に対応した方法により、設備の状態把握及び機能・性能の確認を行う。                                                                                               |
|                                                                                                                                                                                        |
| (2)障害時点検                                                                                                                                                                          |
|                                                                                                                                                                                        |
| > 障害時点検は、設備に障害が発生した場合に、機器の障害箇所の発見、報告及びその場での修理可能な軽微な作業を行う。                                                                       |
|                                                                                                                                                                                        |
| ![](media/image9.emf){width="5.831340769903762in" height="1.8956528871391076in"}                                                                                                       |
|                                                                                                                                                                                        |
| 図2-4　電気通信設備の日常点検の構成                                                                                                                                                    |
+========================================================================================================================================================================================+

＜例　示＞

+--------------------------------------------------------------------------------------------+
| 電気通信設備の日常点検の際に留意する事項としては、以下の事項が考えられる。                 |
|                                                                                            |
| > ① 計器による測定値が標準値の範囲内であること                                             |
| >                                                                                          |
| > ②                                                                                        |
| > 設備・機器の外観、損傷、異音、異常振動、異臭、発熱、発煙等の有無及び電気・制御室内の状況 |
| >                                                                                          |
| > ③ 表示ランプの表示状態                                                                   |
+============================================================================================+

＜関連通知等＞

1.  電気通信施設点検基準（案）の一部改正について，令和2年11月24日，国技電第46号，技術調査課長通知．

<!-- -->

4.  貯水池周辺斜面の巡視・日常点検

＜考え方＞

+--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 貯水池周辺斜面は、貯水池及び貯水池に隣接する土地の安全性を確保するため、その安定を維持する必要があることから、貯水池周辺斜面の巡視・日常点検は、計画的かつ確実に行う必要がある。           |
|                                                                                                                                                                                            |
| 貯水池周辺斜面の安定性を確認し、異常発生の兆候を察知するには、貯水池周辺斜面における挙動の計測による点検から得られる情報だけでなく、巡視や、目視による点検から得られる情報が不可欠である。 |
+============================================================================================================================================================================================+

＜標　準＞

+--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 貯水池周辺斜面の巡視・日常点検においては、注意が必要な斜面の分布、範囲、地形・地質状況、斜面対策工の状況、構造物の状況、変動履歴、挙動等を把握することを基本とする。                                                                                                                                   |
|                                                                                                                                                                                                                                                                                                        |
| 貯水池周辺斜面の安定性の確認においては、ダム建設時の地形・地質情報の資料等の活用や、必要に応じて行う現地調査の結果等により斜面状況を把握・整理するとともに、斜面対策工を施工した斜面や計測装置を設置している自然斜面については、管理基準値等に基づき、計測値の経時的な変化を監視することを基本とする。 |
|                                                                                                                                                                                                                                                                                                        |
| なお、計測装置を設置していない自然斜面については、巡視や、目視による点検を行い、地表面に新たな亀裂・段差が現れるなど異状が認められた場合は、計測装置を設置して計測による点検を行うことを基本とする。                                                                                                   |
|                                                                                                                                                                                                                                                                                                        |
| 変動が見られる貯水池周辺斜面は、河川砂防技術基準調査編^1)^や技術指針^2)^等を参考として調査を行い、その結果を分布図や斜面情報の記録等の一連の資料としてまとめ、巡視・日常点検に活用することを基本とする。                                                                                               |
+========================================================================================================================================================================================================================================================================================================+

＜推　奨＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  貯水池周辺斜面の巡視においては、地表面に現れた亀裂・段差、斜面対策工の実施箇所、及び計測装置を設置している地すべりブロックの頭部や側部等を総合的に勘案して経路を設定することが望ましい。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1.  河川砂防技術基準調査編，第15章（平成26年4月）,第18章（令和5年5月），国土交通省水管理・国土保全局．

<!-- -->

26. 貯水池周辺の地すべり等に係る調査と対策に関する技術指針・同解説，平成31年3月，国土交通省水管理・国土保全局．

＜参考となる資料＞

27. 改訂新版
    貯水池周辺の地すべり調査と対策，平成22年12月，（財）国土技術研究センター．

<!-- -->

5.  観測・計測設備の巡視・日常点検

＜考え方＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  観測・計測設備は、堤体等及び貯水池周辺斜面の挙動を監視して安全性を確認するため、また、降水量・水位・流量等の観測データや水質等のデータを適正かつ継続的に取得するための重要な設備であることから、観測・計測設備の巡視・日常点検は、計画的かつ確実に行う必要がある。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 水文・水理観測設備の日常点検は、河川砂防技術基準調査編^1)^及び電気通信施設点検基準（案）^2)^に基づいて行うことを標準とする。                                                                                                                     |
|                                                                                                                                                                                                                                                  |
| 観測・計測設備の巡視・日常点検においては、観測・計測データを適正かつ継続的に取得するため、設備全般の状態を把握し、計測装置の作動状況の確認を行うとともに、自動計測と手動計測のクロスチェック等により、計測値の信頼性を確保することを基本とする。 |
|                                                                                                                                                                                                                                                  |
| 日常点検においては、観測・計測値の異常な変化により、観測・計測設備の異状を察知できることがあり、日常点検の結果と貯水位や気温等の観測データとの関係、経時的な変化の傾向を把握することを基本とする。                                               |
+==================================================================================================================================================================================================================================================+

＜関連通知等＞

1.  河川砂防技術基準調査編，第2章，令和4年6月，国土交通省水管理・国土保全局．

<!-- -->

28. 電気通信施設点検基準（案）の一部改正について，令和2年11月24日，国技電第46号，技術調査課長通知．

    1.  []{#_Toc198801725 .anchor}臨時点検

＜考え方＞

+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 強い地震、規模の大きい洪水や降雨その他の要因により、土木構造物、機械設備、電気通信設備や貯水池周辺斜面等のダム施設において確認された損傷等は、ダム施設の安全性や健全度を低下させる要因となる可能性がある。                               |
|                                                                                                                                                                                                                                          |
| このため、臨時点検は、一定の強さ以上の地震、一定の規模以上の洪水や降雨その他のダム施設に損傷等を与えるおそれのある事象が発生した後に、ダム施設の異状の有無を速やかに確認し、異状を把握した場合は、その拡大の防止を目的に行うものである。 |
|                                                                                                                                                                                                                                          |
| 臨時点検は、発生した事象に応じて、あらかじめ設定した点検項目・頻度・経路で行い、その結果、何らかの異状を把握した場合は、ダム施設の安全性や健全度への影響の評価を行い、対策の必要性や方法について判断する必要がある。                     |
+==========================================================================================================================================================================================================================================+

1.  地震時臨時点検

＜必　須＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------
  ダム管理者は、一定の強さ以上の地震発生後に、点検実施者の安全に十分留意しつつ、ダム施設の異状の有無を確認するため、地震時臨時点検を行うものとする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------

  ----------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 地震時臨時点検の実施基準は、ダムの基礎地盤又は堤体底部に設置した地震計により観測された地震動の最大加速度が25ガル以上である地震、又は気象台で発表されたダム地点最寄りの観測点における気象庁震度階が4以上である地震が発生した場合であり、主に目視による外観点検（一次点検）及び一次点検後の詳細な外観点検と計測による点検（二次点検）に区分して、臨時点検を行うことを基本とする。 |
|                                                                                                                                                                                                                                                                                                                                                                                 |
| 地震による被害が発生した場合に、迅速にダム施設の状態を把握する必要があることから、あらかじめ対象施設を抽出の上、点検項目・頻度・経路について、臨時点検基準としてとりまとめるなど、臨時点検の体制を整備することを基本とする。                                                                                                                                                    |
|                                                                                                                                                                                                                                                                                                                                                                                 |
| 一定の強さ以上の地震が発生した場合の臨時点検の実施の判断、地震によるダム施設の損傷等の推定や安全性の評価を迅速に行うため、地震動を計測することを基本とする。なお、地震動は、ダムの基礎地盤又は堤体底部、堤体上部その他ダムの特性を考慮して必要な箇所で計測することを基本とする。                                                                                                |
|                                                                                                                                                                                                                                                                                                                                                                                 |
| また、地震計は、最大加速度に加えて、強い地震動によるダムへの影響を分析するために有用な情報となる地震波形を記録し、デジタルデータとして保存できるものとすることを基本とする。                                                                                                                                                                                                    |
|                                                                                                                                                                                                                                                                                                                                                                                 |
| 臨時点検の結果から異状の有無を判断するため、過去の地震時の挙動や試験湛水時及び日常点検の記録を整理・把握することを基本とする。                                                                                                                                                                                                                                                  |
+=================================================================================================================================================================================================================================================================================================================================================================================+

＜推　奨＞

  ------------------------------------------------------------------------------------------------------------------------------
  大規模地震を想定し、ダム施設の挙動について検討を行い、影響が生じる可能性のある設備やその部位等を把握しておくことが望ましい。
  ------------------------------------------------------------------------------------------------------------------------------

  ------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1.  ダム等における地震発生後の臨時点検結果の報告について，令和3年3月31日，国水流第38号，河川環境課長通知．

<!-- -->

29. 「大規模地震に対するダム耐震性能照査指針（案）」の試行について，平成17年3月30日，国河治第205号，国土交通省河川局治水課長通知．

30. 大規模地震に対するダム耐震性能照査指針（案）・同解説，平成17年3月，国土交通省河川局治水課．

＜参考となる資料＞

31. 改訂ダム構造物管理基準，昭和61年5月，（社）日本大ダム会議．

32. 国土技術政策総合研究所資料第244号・土木研究所資料第3965号　大規模地震に対する耐震性能照査に関する資料，国土交通省国土技術政策総合研究所・独立行政法人土木研究所，2005．

<!-- -->

6.  出水時臨時点検

＜必　須＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------
  ダム管理者は、一定の規模以上の洪水又は降雨発生後に、点検実施者の安全に十分留意しつつ、ダム施設の異状の有無を確認するため、出水時臨時点検を行うものとする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------

  ------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 出水時臨時点検の実施基準は、洪水に関しては3年に1回程度発生する規模の洪水流量、降雨に関してはダム地点において3年に1回程度発生する規模の降水量を目安として設定することを基本とする。                                                   |
|                                                                                                                                                                                                                                      |
| ダム施設の点検は、主として放流設備、堤体周辺斜面及び貯水池周辺斜面を対象に行うことを基本とする。                                                                                                                                     |
|                                                                                                                                                                                                                                      |
| 堤体周辺斜面及び貯水池周辺斜面の点検は、一定の規模以上の洪水又は降雨により斜面が不安定になっていないかを確認するため行うものであり、注意すべき斜面のほか、斜面対策工や管理用道路等のダム施設の状況も併せて確認することを基本とする。 |
|                                                                                                                                                                                                                                      |
| また、暴風や落雷を伴う場合は、損傷等を受ける可能性のある電気通信設備や観測・計測設備の異状の有無を確認することを基本とする。                                                                                                         |
+======================================================================================================================================================================================================================================+

＜参考となる資料＞

1.  改訂ダム構造物管理基準，昭和61年5月，（社）日本大ダム会議．

    1.  []{#_Toc198801726 .anchor}ダム総合点検

＜考え方＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  ダム総合点検^1)2)^は、長期的な経年変化の状況や構造物の内部の状態等に着目し、ダムの健全度について総合的に調査及び評価し、効果的・効率的な維持管理を実現することを目的として行う。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜必　須＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  ダム管理者は、ダム総合点検を行い、土木構造物の健全度を評価し、今後の維持管理方針を定めるとともに、機械設備や電気通信設備等のそれぞれで整理された健全度等の評価や中長期的な方針・計画等と併せて、総合的に維持管理方針としてとりまとめるものとする。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| ダム総合点検は、ダム総合点検実施要領^1)^に基づき、以下の内容で行うことを標準とする。                                                                                                                                                                                                                |
|                                                                                                                                                                                                                                                                                                     |
| ダム総合点検は、管理開始後30年までに着手し、以降30年程度に１回の頻度で行うことを基本とする｡ただし、30年程度の経過によらず、経年劣化の著しい進行や大きな外力の作用によりダムの機能が損なわれるおそれがあると判断された場合など、必要と判断される場合には、上記によらずダム総合点検を行うこととする。 |
|                                                                                                                                                                                                                                                                                                     |
| (1)土木構造物の構成要素の分類と管理レベルの設定                                                                                                                                                                                                                                                     |
|                                                                                                                                                                                                                                                                                                     |
| > 土木構造物について、その設置目的やダムの機能より構成要素に分類する。                                                                                                                                                                                                                              |
| >                                                                                                                                                                                                                                                                                                   |
| > 劣化や損傷等により構成要素の機能の低下や消失が生じた場合に、それがダムの機能に与える影響度の大小に応じて、土木構造物の管理レベルを設定する。                                                                                                                                                      |
|                                                                                                                                                                                                                                                                                                     |
| (2)土木構造物の健全度評価と維持管理方針の策定                                                                                                                                                                                                                                                       |
|                                                                                                                                                                                                                                                                                                     |
| > 土木構造物の健全度評価及び維持管理方針の策定は、次の①から④の手順で行う。                                                                                                                                                                                                                          |
| >                                                                                                                                                                                                                                                                                                   |
| > 点検計画の立案、健全度評価及び維持管理方針の策定においては、ダムの特性や課題に関する高度な知見を有する土木構造物の専門家から意見を聴取するとともに、助言を受けるものとする。                                                                                                                      |
| >                                                                                                                                                                                                                                                                                                   |
| > ① 点検計画の立案                                                                                                                                                                                                                                                                                  |
| >                                                                                                                                                                                                                                                                                                   |
| > ② 基本調査・追加調査の実施                                                                                                                                                                                                                                                                        |
| >                                                                                                                                                                                                                                                                                                   |
| > ③ 健全度評価                                                                                                                                                                                                                                                                                      |
| >                                                                                                                                                                                                                                                                                                   |
| > ④ 維持管理方針の策定                                                                                                                                                                                                                                                                              |
|                                                                                                                                                                                                                                                                                                     |
| (3)機械設備、電気通信設備その他のダム施設等の健全度評価及び維持管理方針                                                                                                                                                                                                                             |
|                                                                                                                                                                                                                                                                                                     |
| > 機械設備、電気通信設備及びその他のダム施設等について、構成要素に対応する要領等に基づいて行われた健全度評価や維持管理計画等の要点を整理し、維持管理方針としてとりまとめる。                                                                                                                        |
|                                                                                                                                                                                                                                                                                                     |
| (4)ダム総合点検結果のとりまとめと点検結果の記録                                                                                                                                                                                                                                                     |
|                                                                                                                                                                                                                                                                                                     |
| > 土木構造物、機械設備、電気通信設備及びその他のダム施設等のそれぞれで整理された健全度等の評価や今後の維持管理方針と併せて、総合的に維持管理方針としてとりまとめる。                                                                                                                                |
| >                                                                                                                                                                                                                                                                                                   |
| > ダム総合点検結果は、その後の日常点検、ダム総合点検及び定期検査等に活用するため、カルテとして記録するほか、データベース化する。                                                                                                                                                                    |
+=====================================================================================================================================================================================================================================================================================================+

＜関連通知等＞

1.  ダム総合点検実施要領について，平成25年10月1日，国水環第65号・国水環第66号，河川環境課長通知．

<!-- -->

33. ダム総合点検実施要領・同解説，平成25年10月，国土交通省水管理・国土保全局河川環境課．

    1.  []{#_Toc198801727 .anchor}定期検査

＜考え方＞

  --------------------------------------------------------------------------------------------------------------------------------------------
  定期検査^1)2)^は、ダム管理者以外の視点から、ダム施設及び貯水池の機能が良好な状態に保持されているかを定期的に確認することを目的として行う。
  --------------------------------------------------------------------------------------------------------------------------------------------

  --------------------------------------------------------------------------------------------------------------------------------------------

＜必　須＞

  --------------------------------------------------------------------------------------------------------------------------------
  ダム管理者は、ダム管理者以外の専門家等による定期検査を行い、維持管理状況及びダム施設・貯水池の状態について確認するものとする。
  --------------------------------------------------------------------------------------------------------------------------------

  --------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 定期検査は、ダム定期検査の手引き^2)^に基づいて行うことを標準とする。                                                                                                                                                       |
|                                                                                                                                                                                                                            |
| 定期検査は、3年に1回以上の頻度で行うことを基本とし、次回の検査時期については、検査結果を踏まえて決定することを基本とする。                                                                                                 |
|                                                                                                                                                                                                                            |
| 維持管理状況は、管理体制、ダム施設の維持管理状況、貯水池の維持管理状況及び流水管理状況について、現地における維持管理の記録や調査等の資料の確認、ダム管理者へのヒアリングを併せて実施した上で、評価を行うことを基本とする。 |
|                                                                                                                                                                                                                            |
| ダム施設・貯水池の状態は、現地における巡視・点検記録や観測・計測結果等の資料の確認、目視、簡易計測及び動作による確認、ダム管理者へのヒアリングを併せて実施した上で、評価を行うことを基本とする。                           |
|                                                                                                                                                                                                                            |
| 定期検査の結果を踏まえ、必要に応じて、日常点検における点検項目や頻度、管理基準値、臨時点検における経路や計測項目等について、見直しを行うことを基本とする。                                                                 |
+============================================================================================================================================================================================================================+

＜関連通知等＞

1.  河川法第14条及び特定多目的ダム法第31条に基づくダムに係る操作規則の策定について，平成13年11月28日，国河環第78号・国河治第170号，河川局長通達．

<!-- -->

34. 河川管理施設のダムにおける定期検査の実施について，平成28年3月15日，国水流第20号，河川環境課長通知．

    1.  []{#_Toc192777841 .anchor}観測・調査等

        1.  []{#_Toc198801729 .anchor}水文・水理観測及び気象情報の収集

＜考え方＞

  ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  水文・水理観測及び気象情報の収集は、観測又は収集して得られた情報をダムの操作に活用することを目的として行うものである（第3章第1節1.3参照）。これらの情報は、土木構造物の健全度評価、貯水池周辺斜面の安定性の評価や貯水池の水質予測等にも活用する。
  ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜必　須＞

  ------------------------------------------------------------------------------------------------------------------------------------------
  ダム管理者は、ダム施設及び貯水池の維持管理に必要な情報を得るため、操作規則等に基づき、水文・水理観測及び気象情報の収集を行うものとする。
  ------------------------------------------------------------------------------------------------------------------------------------------

  ------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

  ----------------------------------------------------------------------------------------------------------
  水文・水理観測は、水文観測業務規程等^1)2)^及び河川砂防技術基準調査編^4)^に基づいて行うことを標準とする。
  ----------------------------------------------------------------------------------------------------------

  ----------------------------------------------------------------------------------------------------------

＜推　奨＞

  ------------------------------------------------------------------------------------------------------
  貯水池の水質予測が必要なダムにおいては、予測精度を向上させるため、日射量の観測を行うことが望ましい。
  ------------------------------------------------------------------------------------------------------

  ------------------------------------------------------------------------------------------------------

＜関連通知等＞

1.  水文観測業務規程の改定について，平成29年3月31日，国水情第44号，国土交通事務次官通達．

<!-- -->

35. 水文観測業務規程細則の改定について，平成29年3月31日，国水情第45号，水管理・国土保全局長通達．

36. 水文観測業務の実施方針について，平成29年5月24日，国水情第1号，河川計画課長通知．

37. 河川砂防技術基準調査編，第2章，令和4年6月，国土交通省水管理・国土保全局．

＜参考となる資料＞

38. 多目的ダムの建設－平成17年版，第7巻，第36章，（財）ダム技術センター，2005．

39. 水文観測，国土交通省監修，独立行政法人土木研究所編著，全日本建設技術協会，2002．

    1.  []{#_Toc198801730 .anchor}堆砂調査

＜考え方＞

+--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 河川は水とともに土砂の流路でもあるため、貯水池には経年的に土砂が堆積するが、貯水池に計画以上の土砂が堆積すると、貯水池容量の減少に加えて、上下流の河川や取水・放流設備等に対して影響を与える可能性がある。                                                                                                         |
|                                                                                                                                                                                                                                                                                                                    |
| 堆砂調査は、堆砂による貯水池及び上下流河川や取水・放流設備等への影響を軽減するために、必要に応じて対策を行うことができるよう、堆砂状況のほか、堆砂の性状、流入土砂の量や性状等を把握することを目的として行う。調査にあたっては、維持掘削や砂利採取など人為的な堆砂除去についても考慮することが必要である。         |
|                                                                                                                                                                                                                                                                                                                    |
| 堆砂の排除方法を検討する場合は、土砂の粒度分布、含水比、流木等の混入状況、還元物質の含有状況等の堆砂の性状を把握する必要がある。特に、取水・放流設備近傍に堆積する土砂が、取水・放流時に巻き上げられた場合は、放流設備の摩耗や放流水質に影響を与える可能性があることから、その物理・化学特性に留意する必要がある。 |
|                                                                                                                                                                                                                                                                                                                    |
| 将来の堆砂状況の予測や今後流入する土砂の対策を検討する場合は、現状の堆砂の形状や性状に加えて、ウォッシュロードも含めた流入土砂の量、粒度分布及び比重等を把握する必要がある。また、下流河川の環境改善を含む総合的な土砂管理の一環として土砂還元を検討するにあたり、下流河川の状況を把握することが重要である。       |
|                                                                                                                                                                                                                                                                                                                    |
| 調査で得られた堆砂に関するデータは、水系内の土砂移動の把握、流域条件が類似するダムへの流入土砂の量や性状等の推定のための基礎資料となるものである。                                                                                                                                                                 |
+====================================================================================================================================================================================================================================================================================================================+

＜必　須＞

  --------------------------------------------------------------------------------------------------------------------------
  ダム管理者は、貯水池及び貯水池上流端部の堆砂状況を把握するため、貯水池の特性等に応じて、堆砂状況の調査を行うものとする。
  --------------------------------------------------------------------------------------------------------------------------

  --------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 堆砂状況の調査は、河川砂防技術基準調査編^1)^及びダム貯水池土砂管理の手引き（案）^2)^に基づいて行うことを標準とする。                                                                                                            |
|                                                                                                                                                                                                                                 |
| 通常のダム管理で定期的に実施する基本調査（堆砂状況調査）の調査頻度は年1回を基本とするが、当該年に洪水等の発生がなく、過去の調査結果に基づきダムの堆砂状況に大きな変化が認められない範囲については、2年に1回とすることができる。 |
|                                                                                                                                                                                                                                 |
| 堆砂対策を検討する場合は、河川砂防技術基準調査編^1)^やダム貯水池土砂管理の手引き（案）^2)^等を参考に、堆砂の性状、流入土砂の量や性状等の詳細調査を行い、検討に必要な項目を把握することを基本とする（図2-5）。                   |
|                                                                                                                                                                                                                                 |
| また、下流河川への土砂還元の検討に必要であることから、下流河川の河床変動や河床材料の変化について、河川管理者と連携し、把握することを基本とする。                                                                                |
|                                                                                                                                                                                                                                 |
| ![ダイアグラム 自動的に生成された説明](media/image10.png){width="4.367204724409449in" height="3.809080271216098in"}                                                                                                             |
|                                                                                                                                                                                                                                 |
| 図 2-5　貯水池土砂管理のための調査・観測の構成                                                                                                                                                                                  |
+=================================================================================================================================================================================================================================+

＜推　奨＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 音響測深法では、従来からのシングルビームによる方法だけでなく、必要に応じてマルチビーム等による面的測量が可能な手法の採用を検討していく。堆砂状況の調査を面的測量で行う場合、縦横断測量と面的測量とでは得られる堆砂量の値が異なる場合もあることから、調査方法を変更する場合はコスト等も踏まえつつ両者を一時併用するなど、堆砂の経年的な変化の把握に支障がないよう努めつつ、速やかな堆砂量の面的把握への移行を進める。 |
|                                                                                                                                                                                                                                                                                                                                                                                                                      |
| 堆砂量の経年変化の状況が一時的に大きな変動を示す場合はその原因を調査し、必要に応じて調査方法の変更などを行うことが望ましい。                                                                                                                                                                                                                                                                                         |
|                                                                                                                                                                                                                                                                                                                                                                                                                      |
| さらに調査結果を活用して、貯水池上流端部の堆砂状況及び土地利用状況から洪水時の背水による影響が生じる可能性や、取水放流設備周辺の堆砂等により機能に影響が生じる可能性の有無についても、調査結果を活用して確認することが望ましい。                                                                                                                                                                                     |
+======================================================================================================================================================================================================================================================================================================================================================================================================================+

＜関連通知等＞

1.  河川砂防技術基準調査編，第4章（平成26年4月）,第6章（平成26年4月）,第16章（平成26年4月）,第22章（令和4年6月），国土交通省水管理・国土保全局．

<!-- -->

40. ダム貯水池土砂管理の手引き（案），平成30年3月，国土交通省水管理・国土保全局河川環境課．

41. ダムの堆砂状況の報告について，平成26年11月27日，国河環第78号，河川環境課長通知．

42. ダムの堆砂状況の測定頻度について，平成17年3月29日，国河流第21号，流水管理室長通知．

＜参考となる資料＞

43. 土質試験の方法と解説第1回改訂版，平成12年3月，地盤工学会「土質試験の方法と解説」改訂編集委員会．

44. 多目的ダムの建設－平成17年版，第3巻,第17章，第7巻,第36章，（財）ダム技術センター，2005．

45. 土木技術資料vol.45，No.3　ダム貯水池の堆砂形態，櫻井寿之・柏井条介・大黒真希，2003．

46. 河川技術論文集
    第29巻　ダム洪水吐きの持続的機能発揮に向けた貯水池堆砂・流木・沈木管理，髙田翔也・角哲也・木村一郎・山上路生・小柴孝太，2023.

    1.  []{#_Toc198801731 .anchor}水質調査

＜考え方＞

+--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| ダム貯水池における水質調査は、ダム貯水池の適正な水質管理及び水質の予測を含む対策を立案するために行うものであり、その水中の化学的、生物化学的、及び細菌学的性状、並びにそれらに関与する物理的性質の状態を明らかにする。また、水質調査は、水質の予測を含む対策の立案や、対策の効果確認、対策施設の運用や施設そのものの効率化検討を目的として行う。 |
|                                                                                                                                                                                                                                                                                                                                                  |
| 底質調査は、貯水池水質と密接に関連する底質の状況を把握することを目的として行う。                                                                                                                                                                                                                                                                 |
|                                                                                                                                                                                                                                                                                                                                                  |
| 水質調査は、その目的に応じて、基本調査、詳細調査及び水質保全設備管理運用調査に大別される（表2-3）。                                                                                                                                                                                                                                              |
|                                                                                                                                                                                                                                                                                                                                                  |
| 貯水池の水質管理においては、貯水池における採水等による水質状況の把握に加えて、貯水池への流入水の水質変化の把握、アオコ発生の兆候、魚類の大量死等の大量浮上、不法投棄等を発見するための巡視も重要である。また、放流水の影響を受ける場合もあることから、下流河川の水質の状況を把握することが重要である。                                           |
|                                                                                                                                                                                                                                                                                                                                                  |
| 表2-3　水質調査の種類と目的                                                                                                                                                                                                                                                                                                                      |
|                                                                                                                                                                                                                                                                                                                                                  |
| ![](media/image11.emf){width="6.299212598425197in" height="2.9338713910761154in"}                                                                                                                                                                                                                                                                |
+==================================================================================================================================================================================================================================================================================================================================================+

＜必　須＞

  ----------------------------------------------------------------------------------------------------------
  ダム管理者は、貯水池の良好な水質を保全するため、貯水池の特性等に応じて、必要な水質調査を行うものとする。
  ----------------------------------------------------------------------------------------------------------

  ----------------------------------------------------------------------------------------------------------

＜標　準＞

+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 水質調査は、流域の自然環境及び社会環境等に応じた貯水池の水質特性、ダムの事業目的や利水の状況等を踏まえ、必要な調査項目、調査地点等をとりまとめた水質調査計画を策定し、これに基づいて行うことを基本とする。 |
|                                                                                                                                                                                                            |
| また、水質調査計画は、ダム等の管理に係るフォローアップの頻度等を踏まえ、おおむね5年ごとに見直しを検討することを基本とする。                                                                                |
|                                                                                                                                                                                                            |
| 巡視においては、湖面におけるアオコ発生の兆候等にも留意するとともに、異状を確認した場合は、その状況に応じて、巡視を強化することを基本とする。                                                               |
|                                                                                                                                                                                                            |
| 下流河川の水質については、河川管理者と連携し、把握することを基本とする。                                                                                                                                   |
+============================================================================================================================================================================================================+

＜推　奨＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  近年の技術開発により、自動水質観測設備により取得した水質データと水質保全設備の運用を連動させることが可能となっている。こうした新しい技術は、導入効果等の必要性を検討した上で採用し、より効果的・効率的な水質管理を行うことが望ましい。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1.  河川砂防技術基準調査編，第12章,第13章，平成26年4月1日，国水情第52号，水管理・国土保全局長通達．

<!-- -->

47. ダム貯水池水質調査要領，平成27年3月，国土交通省水管理・国土保全局河川環境課．

48. 曝気循環施設及び選択取水設備の運用マニュアル（案），平成17年10月，国土交通省河川局河川環境課．

49. ダム貯水池水質改善の手引き，平成30年3月，国土交通省水管理・国土保全局河川環境課．

50. ダム貯水池水質改善に向けた気泡式循環施設マニュアル（案）～富栄養化対策のための気泡式（曝気式）循環施設に関する技術資料～，令和3年5月，国土交通省水管理・国土保全局河川環境課．

51. 平成28年度版河川水辺の国勢調査基本調査マニュアル【ダム湖版】，平成28年1月（改訂），国土交通省水管理・国土保全局河川環境課．

52. 河川水質試験方法（案）〔2008年版〕，平成21年3月，国土交通省水質連絡会．

53. 底質調査方法，平成24年8月，環境省水・大気環境局．

54. JIS A 1204 土の粒度試験方法．

55. 今後の湖沼水質管理の指標について（案），平成22年3月，国土交通省河川局河川環境課．

56. 河川、湖沼等におけるダイオキシン類常時監視マニュアル（案），令和5年6月，国土交通省水管理・国土保全局河川環境課．

57. 河川、湖沼等における底質ダイオキシン類対策マニュアル（案），平成20年4月，国土交通省河川局河川環境課．

58. 水質汚濁に係る環境基準について，令和5年3月，環境省告示6号．

＜参考となる資料＞

59. 多目的ダムの建設―平成17年版，第7巻，第36章，（財）ダム技術センター，2005．

60. 上水試験方法2020年版，令和3年3月，（公社）日本水道協会．

61. 湖沼における水理・水質管理の技術，平成19年3月，湖沼技術研究会．

    1.  []{#_Toc198801732 .anchor}環境調査

＜考え方＞

+--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 環境調査は、貯水池及びその周辺に生息・生育する生物と、その生息・生育環境との関係を把握し、生物の良好な生息・生育環境の保全を念頭においた適切なダム管理に資することを目的として行う。 |
|                                                                                                                                                                                      |
| 貯水池及びその周辺を環境という観点からとらえた定期的、継続的、統一的な基礎情報の収集整備のための調査として、河川水辺の国勢調査^1)^が行われている。                                   |
+======================================================================================================================================================================================+

＜必　須＞

  ----------------------------------------------------------------------------------------------------------------------------
  ダム管理者は、貯水池及びその周辺の環境保全に必要な情報を得るため、それらの特性等に応じて、必要な環境調査を行うものとする。
  ----------------------------------------------------------------------------------------------------------------------------

  ----------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 環境調査は、河川砂防技術基準調査編^2)^及び河川水辺の国勢調査基本調査マニュアル^3)^に基づいて行うことを標準とする。                                                                                                                                       |
|                                                                                                                                                                                                                                                          |
| 河川水辺の国勢調査においては、貯水池及びその周辺や、上下流の河川を含む範囲を調査区域とするとともに、ダム建設に伴い地形を改変した箇所や、生物の生息・生育環境を創出する目的で整備された箇所がある場合は、必要に応じて、調査区域に含めることを標準とする。 |
+==========================================================================================================================================================================================================================================================+

＜推　奨＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------
  環境保全に必要な情報を得るために環境調査を実施する際は、貯水池及びその周辺や、上下流の河川を含む範囲だけでなく、必要に応じて周辺の河川も調査区域に含めて調査を行う。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1.  「河川水辺の国勢調査実施要領」の改定について，平成27年7月7日，国水環第26号，河川環境課長通知．

<!-- -->

62. 河川砂防技術基準調査編，第13章，平成26年4月1日，国土交通省水管理・国土保全局．

63. 平成28年度版河川水辺の国勢調査基本調査マニュアル【ダム湖版】，平成28年1月（改訂），国土交通省水管理・国土保全局河川環境．

    1.  []{#_Toc192777842 .anchor}点検・観測等の記録

＜考え方＞

+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 日常管理における巡視・点検、水文・水理観測、堆砂・水質調査等の記録は、長期にわたり継続的に蓄積するとともに、より一層適切なダムの管理を行うため、その情報を活用することが重要である。                                                                                                                                                                             |
|                                                                                                                                                                                                                                                                                                                                                                  |
| ダム施設の点検の記録は、現時点におけるダムの安全性や機能を確認するだけでなく、将来における効率的な維持管理にとって重要な資料である。                                                                                                                                                                                                                             |
|                                                                                                                                                                                                                                                                                                                                                                  |
| 地震等の発生により臨時点検を行った場合は、ダム施設の点検結果、降水量等の観測データ及び地震動の計測データについて、その前後のダム施設の状態、観測・計測データを比較することにより、ダムの安全性及び健全度への影響を評価することが可能となる。このため、必要な場合に速やかに活用できるよう、点検結果や観測・計測データは、系統的に整理・保存することが重要である。 |
|                                                                                                                                                                                                                                                                                                                                                                  |
| また、測量・調査、設計、施工、維持管理・更新の各段階において、情報を充実させながらBIM/CIMモデルを連携・発展させ、併せて事業全体にわたる関係者間の情報共有を容易にすることで、一連の建設生産・管理システム全体の効率化・高度化を図ることが期待できる。                                                                                                            |
+==================================================================================================================================================================================================================================================================================================================================================================+

＜標　準＞

+------------------------------------------------------------------------------------------------------------------------------------------------+
| 日常管理における巡視・点検、水文・水理観測、堆砂・水質調査等の記録は、記録様式を整備して記録し、系統的に整理・保存することを基本とする。       |
|                                                                                                                                                |
| 貯水池周辺斜面の挙動等に関する記録は、技術指針^1)^等に基づき、地すべり等カルテを作成して整理・保存するとともに、適宜更新することを基本とする。 |
|                                                                                                                                                |
| また、地震計による地震観測記録は、継続的に整理・保存することを基本とする。                                                                     |
+================================================================================================================================================+

＜例　示＞

+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| ダムの維持管理におけるBIM/CIMモデルの活用例を示す。                                                                                                                                                     |
|                                                                                                                                                                                                         |
| > ・通常時：　資料検索の効率化、点検結果の可視化、各種計測機器の位置及び機器情報の可視化と履歴情報の連携持管理、引き継ぎ業務の円滑化                                                                    |
| >                                                                                                                                                                                                       |
| > ・異常時：　コンクリートクラックの延長や開き、堤体変位や外部標的の測量・GPS装置による被災後の健全度確認、損傷を受けたダムの調査における情報確認、損傷箇所と類似の箇所・対応策に関する事例検索の効率化 |
| >                                                                                                                                                                                                       |
| > ・その他：　定期検査や総合点検における考察や様式作成                                                                                                                                                  |
+=========================================================================================================================================================================================================+

＜関連通知等＞

1.  貯水池周辺の地すべり等に係る調査と対策に関する技術指針・同解説，平成31年3月25日，国土交通省水管理・国土保全局河川環境課流水管理室，治水課事業管理室．

<!-- -->

64. 河川砂防技術基準調査編，第2章（令和4年6月）,第4章（平成26年4月）,第6章（平成26年4月）,第12章（平成26年4月）,第13章（平成26年4月）,第16章（平成26年4月）,第23章（令和6年6月），国土交通省水管理・国土保全局．

65. ダム貯水池水質調査要領，平成27年3月，国土交通省水管理・国土保全局河川環境課．

66. BIM/CIM 活用ガイドライン（案） 第1編共通編，令和3年3月，国土交通省．

67. BIM/CIM 活用ガイドライン（案） 第4編ダム編，令和4年3月，国土交通省．

＜参考となる資料＞

68. 改訂新版
    貯水池周辺の地すべり調査と対策，平成22年12月，（財）国土技術研究センター．

    1.  []{#_Toc192777843 .anchor}ダム施設の維持管理の評価と対策

        1.  []{#_Toc192777844 .anchor}総説

＜考え方＞

+-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 土木構造物、機械設備、電気通信設備や貯水池周辺斜面等により構成されるダム施設の維持管理を適切に行うためには、それぞれの施設・設備を構成する部位や機器の劣化・損傷等が、施設・設備の安全性や機能に与える影響の度合いを踏まえて、対策の必要性や優先度を判断する必要がある。その上で、それぞれの施設・設備のトータルコストの縮減・平準化を考慮し、ダム施設の維持管理を計画的に行うことにより、ダムの安全性及び機能を長期にわたり保持することが重要である。                                                                                                                                                    |
|                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| ダム施設の状態は、点検等の結果を分析した上で健全度等を評価し、施設・設備の重要性や設置条件を勘案した上で、保全対策について総合的に判断する必要がある。                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
|                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| また、ダム施設の対策は、施設の機能を維持もしくは回復し、又は信頼性を確保することを目的として、施設の評価と優先度等を踏まえ、計画的に行うことが重要である。                                                                                                                                                                                                                                                                                                                                                                                                                                                |
|                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| ダム施設の対策の実施においては、予防保全と事後保全を適切に選択することが効果的である。ここで予防保全とは、施設・設備が機能低下、又は機能を失う前に対策を行うことにより、通常の使用や運用が可能な状態に維持するため計画的に行う保全をいう。予防保全は、定期的に保全対策を行う時間計画保全と、状態や劣化傾向を監視しながら保全対策を行う状態監視保全に区分される。また、事後保全とは、施設・設備が機能低下、又は機能を失った後に使用もしくは運用可能な状態に回復する保全を指し、予防保全対象の致命的機器に故障が発生した場合の緊急保全のほか、非致命的機器の故障に対する通常事後保全に分けられる（図2-6）。 |
|                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| ![ダイアグラム, 概略図 自動的に生成された説明](media/image12.png){width="4.081574803149606in" height="1.448190069991251in"}                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |
|                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| 図2-6　保全の分類                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |
|                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| なお、ダム施設の対策の実施においては、維持・修繕に加えて、改良についても考慮する必要がある。                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
|                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| ダム施設の改良は、設備等の能力不足や経年劣化の進行等によりダム施設の機能が不十分である、又はその機能の維持に支障がある、もしくは支障が生じるおそれがある場合に、ダムが有する洪水調節、流水の正常な機能の維持及び利水補給等の機能の回復又は向上を図るために行うものである。                                                                                                                                                                                                                                                                                                                                |
+===========================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================+

＜標　準＞

+-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| ダム施設の維持管理においては、ダムの安全性及び機能を長期にわたり保持することを目的に、ダム施設の維持管理におけるPDCAサイクルにより、日常管理における巡視・点検や中長期的な観点からの点検・検査等によるダム施設の状態の把握、それに基づく健全度等の評価、その結果に応じて、維持・修繕等の対策を計画的に行うことを基本とする。                        |
|                                                                                                                                                                                                                                                                                                                                                     |
| 長期的な視点を持って、ダム施設の維持・修繕等をより効果的・効率的に行うために、ダム総合点検実施要領^1)2)^、ダム用ゲート設備等点検・整備・更新検討要領^3)4)^、及び電気通信施設維持管理計画指針（案)^5)6)^等の考え方に基づいて、ダムを構成する施設・設備等毎に状態を評価し、中長期的な維持管理の方針・計画等を定め、保全対策等を行うことを基本とする。 |
|                                                                                                                                                                                                                                                                                                                                                     |
| 設備等の能力不足や経年劣化の進行等により、ダム施設の機能の保持に支障がある場合等においては、ダムの機能の回復又は向上を図るための対策について検討し、必要に応じて、施設の改良を行うことを基本とする。                                                                                                                                                |
|                                                                                                                                                                                                                                                                                                                                                     |
| ダム施設の健全度等の評価や対策を適切に行うため、日常管理における巡視・点検や維持・修繕等の対策の記録に加えて、ダム建設時や試験湛水時の記録が有用であることから、これらの資料を整理・保存し、維持管理の中で活用できるようにすることを基本とする。                                                                                                    |
+=====================================================================================================================================================================================================================================================================================================================================================+

＜推　奨＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  ダム施設の改良は、ダム施設の状態、ダムの操作実績及び社会経済情勢の変化等を踏まえ、ダムの機能性、操作性、運用コスト、管理体制及び適用可能な改良方法等を考慮して計画することが望ましい。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1.  ダム総合点検実施要領について，平成25年10月1日，国水環第65号・国水環第66号，河川環境課長通知．

<!-- -->

69. ダム総合点検実施要領・同解説，平成25年10月，国土交通省水管理・国土保全局河川環境課．

70. ダム用ゲート設備等点検・整備標準要領（案），平成30年3月，国土交通省総合政策局公共事業企画調整課施工安全企画室．

71. ダム用ゲート設備等点検・整備・更新検討マニュアル（案），平成30年3月，国土交通省総合政策局公共事業企画調整課・水管理・国土保全局河川環境課流水管理室．

72. 電気通信施設維持管理計画指針（案），令和4年3月，国土交通省大臣官房技術調査課電気通信室．

73. 電気通信施設維持管理計画作成の手引き（案），令和4年3月，国土交通省大臣官房技術調査課電気通信室．

    1.  []{#_Toc192777845 .anchor}土木構造物

        1.  []{#_Toc198801737 .anchor}評価

＜考え方＞

+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 土木構造物の評価は、経年に伴い発生する材料の物理・化学的劣化等を踏まえた構造物の健全度や、構造物の重要性等を調査・検討した上で、緊急の措置の実施、継続的な監視等の判断を行うものである。                   |
|                                                                                                                                                                                                            |
| 土木構造物の評価は、ダムの堤体挙動や劣化等に関する維持管理の実績に照らして行うことが重要である。                                                                                                           |
|                                                                                                                                                                                                            |
| また、ダムの長寿命化を見据えたコンクリート劣化メカニズムの研究、土木構造物の経年劣化特性を踏まえた、より効果的・効率的な健全度評価手法の確立、劣化状況に応じた補修・補強方法に関する技術開発が重要である。 |
+============================================================================================================================================================================================================+

＜標　準＞

+--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 土木構造物の評価は、ダム総合点検実施要領^1)2)^に基づいて行うことを標準とする。                                                                                                                                                                                     |
|                                                                                                                                                                                                                                                                    |
| なお、土木構造物の維持管理を効果的・効率的に行うため、点検等の結果及び堤体挙動や劣化等に関する維持管理の実績に基づき、構造物の状態について健全度を評価することを基本とする。                                                                                       |
|                                                                                                                                                                                                                                                                    |
| 土木構造物の評価においては、健全度の評価結果と、ダム施設を構成する施設・設備の劣化や損傷等がダムの安全性や機能に与える影響の度合い（施設・設備の重要性）を組み合わせて、必要に応じて、使用条件や環境条件を考慮し、対策の必要性と優先度を判断することを基本とする。 |
+====================================================================================================================================================================================================================================================================+

＜推　奨＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  評価においては、あらかじめ着目すべき挙動や劣化・損傷等について、ダムの構造的特徴や地質条件、気象その他の環境条件のほか、ダムの操作実績、観測・計測データ、巡視記録、点検・検査結果や補修履歴等、関係する記録を踏まえて整理することが望ましい。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1.  ダム総合点検実施要領について，平成25年10月1日，国水環第65号・国水環第66号，河川環境課長通知．

<!-- -->

74. ダム総合点検実施要領・同解説，平成25年10月，国土交通省水管理・国土保全局河川環境課．

75. コンクリート標準示方書〔ダムコンクリート編〕，土木学会コンクリート標準示方書改訂小委員会，土木学会，2023．

＜参考となる資料＞

76. 多目的ダムの建設－平成17年版，第7巻，第37章，（財）ダム技術センター，2005．

77. 土木研究所資料第1834号　ダムの安全管理，建設省土木研究所，1982．

    1.  []{#_Toc198801738 .anchor}対策

＜標　準＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 土木構造物の維持・修繕等の対策は、施設の機能を維持又は回復することを目的として、計画的に行うことを基本とする。                                                                   |
|                                                                                                                                                                                  |
| 評価の結果から、一定の強さ以上の地震や一定の規模以上の洪水又は降雨が発生した場合に、堤体等の機能が低下し、緊急の措置が必要と判断される場合は、直ちに対策を行うことを基本とする。 |
|                                                                                                                                                                                  |
| 対策の実施においては、適切な工費・工期の設定、施設の長寿命化等によるトータルコストの縮減・平準化等を総合的に判断して、対策方法を選定することを基本とする。                       |
+==================================================================================================================================================================================+

＜推　奨＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  土木構造物の機能の維持又は回復においては、ダムの機能への影響度、貯水池運用の制約、管理の効率性を考慮して、予防保全と事後保全を適切に選択し、計画的に対策を行うことが望ましい。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1.  ダム総合点検実施要領・同解説：平成25年10月，国土交通省水管理・国土保全局河川環境課．

＜参考となる資料＞

78. 国土技術政策総合研究所資料第262号　ダム補修事例に関する調査：国土交通省国土技術政策総合研究所，2005．

    1.  []{#_Toc192777846 .anchor}機械設備

        1.  []{#_Toc198801740 .anchor}評価

＜考え方＞

+--------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 機械設備の評価は、装置・機器に機能低下の傾向が見られる場合や、詳細な状態把握が必要な場合に、今後の対策計画の立案、必要な維持・修繕等の検討・提案を目的に行うものである。 |
|                                                                                                                                                                          |
| また、機械設備の評価は、設備の点検結果等に基づき健全度を評価し、設置条件等を考慮して、総合的に行うことが重要である。                                                     |
+==========================================================================================================================================================================+

＜標　準＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 機械設備の評価は、ダム用ゲート設備等点検・整備・更新検討要領^1)2)^に基づいて行うことを標準とする。                                                                                                                   |
|                                                                                                                                                                                                                      |
| なお、機械設備の評価は、機械設備の維持管理を効果的・効率的に行うため、点検、装置・機器の診断結果等に基づいて、設備の社会的な影響度や使用条件、環境条件、設置からの経過年数等を考慮して総合的に行うことを基本とする。 |
+======================================================================================================================================================================================================================+

＜関連通知等＞

1.  ダム用ゲート設備等点検・整備標準要領（案），平成30年3月，国土交通省総合政策局公共事業企画調整課施工安全企画室．

<!-- -->

79. ダム用ゲート設備等点検・整備・更新検討マニュアル（案），平成30年3月，国土交通省総合政策局公共事業企画調整課・水管理・国土保全局河川環境課流水管理室．

    1.  []{#_Toc198801741 .anchor}対策

＜標　準＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 機械設備の維持・修繕等の対策は、設備の機能を維持又は回復し、信頼性を確保することを目的として、計画的に行うことを基本とする。                                                                                                     |
|                                                                                                                                                                                                                                  |
| 機械設備の維持・修繕等は、ダム用ゲート設備等点検・整備・更新検討要領^1)2)^の考え方を基に、設備の目的・機能・設置環境・稼働条件・設備や機器等の特性（致命的・非致命的、傾向把握の可否等）を考慮し、計画的に行うことを基本とする。 |
|                                                                                                                                                                                                                                  |
| また、維持・修繕等は、予防保全と事後保全を適切に選択し、健全度評価結果に、設備区分レベル、設置条件、設置からの経過年数、トータルコストの縮減・平準化等も考慮して、優先度を総合的に評価して行うことを基本とする。                 |
+==================================================================================================================================================================================================================================+

＜推　奨＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  対策の実施においては、設備の操作が必要な場合も想定されるため、対策内容や工程について、点検作業など設備の運用と調整を図るとともに、軽微な部品交換など点検作業と同時に対策を行うなど、効率化に努めることが望ましい。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1.  ダム用ゲート設備等点検・整備標準要領（案），平成30年3月，国土交通省総合政策局公共事業企画調整課施工安全企画室．

<!-- -->

80. ダム用ゲート設備等点検・整備・更新検討マニュアル（案），平成30年3月，国土交通省総合政策局公共事業企画調整課・水管理・国土保全局河川環境課流水管理室．

    1.  []{#_Toc192777847 .anchor}電気通信設備

        1.  []{#_Toc198801743 .anchor}評価

＜考え方＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  電気通信設備の評価は、設備の保全対策において、設備の運用状態及び性能や信頼性の現状を把握・分析・診断することにより対策の要否を判断するものである。また電気通信設備の評価は、設備の機能・性能・信頼性の確保等の観点から、総合的に行うことが重要である。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 電気通信設備の評価においては、電気通信設備の維持管理を効率的・計画的に行うため、電気通信施設維持管理計画指針(案)^1)2)^の考えに基づいて立案された計画により、中長期的な観点からオーバーホール等による延命化を計画することを基本とする。           |
|                                                                                                                                                                                                                                                  |
| 電気通信設備の評価は、電気通信施設のアセットマネジメントに関する要領^3)^等の考え方を基に、設備の運用状態を診断して対策の要否を判断するとともに、設備の機能、性能、信頼性、トータルコストの縮減・平準化を考慮して、総合的に行うことを基本とする。 |
+==================================================================================================================================================================================================================================================+

＜関連通知等＞

1.  電気通信施設維持管理計画指針（案），令和4年3月，国土交通省大臣官房技術調査課電気通信室．

<!-- -->

81. 電気通信施設維持管理計画作成の手引き（案），令和4年3月，国土交通省大臣官房技術調査課電気通信室．

82. 電気通信施設アセットマネジメント要領・同解説（案），令和4年3月，国土交通省大臣官房電気通信室．

    1.  []{#_Toc198801744 .anchor}対策

＜標　準＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 電気通信設備の維持・修繕等の対策は、設備の機能を維持又は回復し、信頼性を確保することを目的として、計画的に行うことを基本とする。                                                                                                                                     |
|                                                                                                                                                                                                                                                                      |
| 電気通信設備の維持・修繕等は、電気通信施設アセットマネジメント要領・同解説（案）^1)^の考え方を基に、設備の機能、性能、信頼性、トータルコストの縮減・平準化を考慮した総合的な評価により、修繕・更新・継続使用等のうち、最も優位な方式を選定して行うことを基本とする。 |
+======================================================================================================================================================================================================================================================================+

＜関連通知等＞

1.  電気通信施設アセットマネジメント要領・同解説（案），令和4年3月，国土交通省大臣官房電気通信室．

    1.  []{#_Toc192777848 .anchor}貯水池周辺斜面

        1.  []{#_Toc198801746 .anchor}安定性の評価

＜考え方＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  貯水池周辺斜面については、地すべり等が発生することにより、ダム本体の安全性はもとより貯水池の機能や貯水池周辺斜面の保全に影響を及ぼすことに留意して、その安定性を評価する必要がある。地すべり等は複雑な自然現象であることから、各地域特有の条件を考慮することが重要である。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 貯水池周辺斜面の安定性の評価は、試験湛水時における斜面の挙動の計測結果や他ダムの実績等から設定した管理基準値に基づく評価と変化傾向の把握に基づく評価、及び日常管理における巡視・点検結果を総合的に勘案して行うことを基本とする。                         |
|                                                                                                                                                                                                                                                          |
| 評価結果に基づき、巡視及び計測体制の変更、詳細調査の要否、対策の必要性の検討、又は対策の実施を判断することを基本とする。                                                                                                                                 |
|                                                                                                                                                                                                                                                          |
| 貯水池周辺斜面における挙動の計測データは、技術指針^1)^等を参考に、時系列での整理、影響要因（貯水位、降水量等）との相関分析を行い、それぞれの計測項目について管理基準値等に照らして評価するとともに、経時的な変化傾向から挙動を評価することを基本とする。 |
|                                                                                                                                                                                                                                                          |
| なお、日常管理における巡視・点検に基づく斜面の安定性の評価結果を踏まえて、適宜、管理基準値の見直しを行うことを基本とする。                                                                                                                               |
+==========================================================================================================================================================================================================================================================+

＜推　奨＞

  --------------------------------------------------------------------------------------------------------
  斜面の安定性の評価において、すべり面の推定が可能な場合は、必要に応じて、安定解析を行うことが望ましい。
  --------------------------------------------------------------------------------------------------------

  --------------------------------------------------------------------------------------------------------

＜関連通知等＞

1.  貯水池周辺の地すべり等に係る調査と対策に関する技術指針・同解説，平成31年3月25日，国土交通省水管理・国土保全局河川環境課流水管理室，治水課事業管理室．

＜参考となる資料＞

83. 改訂新版　貯水池周辺の地すべり調査と対策，平成22年12月，（財）国土技術研究センター．

    1.  []{#_Toc198801747 .anchor}対策

＜標　準＞

+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 貯水池周辺斜面については、巡視及び計測体制の強化や、詳細調査等による安定性の評価の結果、斜面の安定を維持することができないおそれがあると判断される場合は、必要な対策を行うことを基本とする。   |
|                                                                                                                                                                                                |
| 対策は、河川砂防技術基準調査編^1)^や技術指針^2)3)^等に基づき、貯水池運用の制約、ダム施設や貯水池周辺の道路等の施設への影響、経済性、維持管理の効率性等を総合的に勘案して行うことを標準とする。 |
+================================================================================================================================================================================================+

＜関連通知等＞

1.  河川砂防技術基準調査編，第15章（平成26年4月）,第18章（令和5年5月），国土交通省水管理・国土保全局長．

<!-- -->

84. 貯水池周辺の地すべり等に係る調査と対策に関する技術指針・同解説，平成31年3月25日，国土交通省水管理・国土保全局河川環境課流水管理室，治水課事業管理室．

85. 地すべり防止技術指針及び同解説，平成20年1月，国土交通省砂防部、独立行政法人土木研究所．

＜参考となる資料＞

86. 改訂新版　貯水池周辺の地すべり調査と対策：平成22年12月，（財）国土技術研究センター．

    1.  []{#_Toc192777849 .anchor}観測・計測設備

＜標　準＞

+------------------------------------------------------------------------------------------------------------------------------+
| 観測・計測設備は、日常管理における巡視・点検等の結果を踏まえ、設備の状態に応じて、維持・修繕等の対策を行うことを基本とする。 |
|                                                                                                                              |
| また、観測値や計測値に異常が認められた場合は、必要に応じて、設備の維持・修繕等の対策を行うことを基本とする。                 |
|                                                                                                                              |
| 観測・計測設備の維持管理に支障が生じないよう、観測・計測設備の周辺環境は適切に保全することを基本とする。                     |
+==============================================================================================================================+

関連通知等＞

1.  河川砂防技術基準調査編，第2章，令和4年6月，国土交通省水管理・国土保全局．

    1.  []{#_Toc192777850 .anchor}維持・修繕等の記録

＜考え方＞

+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| ダム施設の維持・修繕等の記録は、ダム施設の健全度の評価等、ダム施設の維持管理を行う上で重要な資料であることから、必要な場合に速やかに活用できるよう系統的に整理・保存し、蓄積することが重要である。                                                      |
|                                                                                                                                                                                                                                                         |
| また、ダム建設時及び試験湛水時の記録についても、管理基準値の設定やダム施設の健全度の評価等を行う上で重要な資料であることから、上記と併せて保存することが重要である。                                                                                    |
|                                                                                                                                                                                                                                                         |
| なお、維持・修繕等の記録は適宜更新し、常に最新のものにすることが重要である。                                                                                                                                                                            |
|                                                                                                                                                                                                                                                         |
| さらに、測量・調査、設計、施工、維持管理・更新の各段階において、情報を充実させながらBIM/CIMモデルを連携・発展させ、併せて事業全体にわたる関係者間の情報共有を容易にすることで、一連の建設生産・管理システム全体の効率化・高度化を図ることが期待できる。 |
+=========================================================================================================================================================================================================================================================+

＜標　準＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| ダム施設の維持・修繕等の記録については、以下のとおり系統的に整理・保存し、蓄積することを基本とする。                                                                                                                                   |
|                                                                                                                                                                                                                                        |
| (1)土木構造物の維持・修繕等に関する記録                                                                                                                                                                                                |
|                                                                                                                                                                                                                                        |
| > 土木構造物の維持・修繕等の記録は、点検・評価結果、劣化等の変状の把握、分析、原因調査から対策方法の選定、対策の実施及び対策後の追跡調査までを整理・保存する。                                                                         |
|                                                                                                                                                                                                                                        |
| (2)機械設備・電気通信設備の維持・修繕等に関する記録                                                                                                                                                                                    |
|                                                                                                                                                                                                                                        |
| > 機械設備・電気通信設備の維持・修繕等の記録は、運転、故障、点検、修繕、更新等の内容を運転記録、設備台帳、維持管理台帳等に整理・保存する。                                                                                             |
| >                                                                                                                                                                                                                                      |
| > なお、故障履歴は、設備、施設の信頼性を推定するための重要な資料であることから、点検結果と併せて整理・保存する。                                                                                                                       |
|                                                                                                                                                                                                                                        |
| (3)貯水池周辺斜面の維持・修繕等の記録                                                                                                                                                                                                  |
|                                                                                                                                                                                                                                        |
| > 貯水池周辺斜面の維持・修繕等の履歴を確実に記録するため、計測体制の変更、詳細調査、斜面対策工等の内容について、地すべり等カルテに整理・保存する。                                                                                     |
|                                                                                                                                                                                                                                        |
| (4)ダム建設時及び試験湛水時の記録                                                                                                                                                                                                      |
|                                                                                                                                                                                                                                        |
| > ダム建設時の設計施工の記録、試験湛水時に確認された堤体挙動や貯水池周辺斜面の安定性に関する計測データ等の資料は、管理基準値の設定、変状発生時の原因解明において重要な資料であることから、維持・修繕等の記録と併せて、整理・保存する。 |
+========================================================================================================================================================================================================================================+

＜例　示＞

+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| ダムの維持管理におけるBIM/CIMモデルの活用例を示す。                                                                                                                                                     |
|                                                                                                                                                                                                         |
| > ・通常時：　資料検索の効率化、点検結果の可視化、各種計測機器の位置及び機器情報の可視化と履歴情報の連携持管理、引き継ぎ業務の円滑化                                                                    |
| >                                                                                                                                                                                                       |
| > ・異常時：　コンクリートクラックの延長や開き、堤体変位や外部標的の測量・GPS装置による被災後の健全度確認、損傷を受けたダムの調査における情報確認、損傷箇所と類似の箇所・対応策に関する事例検索の効率化 |
| >                                                                                                                                                                                                       |
| > ・その他：　定期検査や総合点検における考察や様式作成                                                                                                                                                  |
+=========================================================================================================================================================================================================+

＜関連通知等＞

1.  ダム総合点検実施要領について，平成25年10月1日，国水環第65号・国水環第66号，河川環境課長通知．

2.  ダム総合点検実施要領・同解説，平成25年10月，国土交通省水管理・国土保全局河川環境課．

3.  ダム用ゲート設備等点検・整備標準要領（案），平成30年3月，国土交通省総合政策局公共事業企画調整課施工安全企画室．

4.  ダム用ゲート設備等点検・整備・更新検討マニュアル（案），平成30年3月，国土交通省総合政策局公共事業企画調整課・水管理・国土保全局河川環境課流水管理室．

5.  電気通信施設点検基準（案）の一部改正について，令和2年11月24日，国技電第46号，技術調査課長通知．

6.  電気通信施設アセットマネジメント要領・同解説（案），令和4年3月，国土交通省大臣官房電気通信室．

7.  貯水池周辺の地すべり等に係る調査と対策に関する技術指針・同解説，平成31年3月，国土交通省水管理・国土保全局．

8.  BIM/CIM 活用ガイドライン（案） 第1編共通編，令和3年3月，国土交通省．

9.  BIM/CIM 活用ガイドライン（案） 第4編ダム編，令和4年3月，国土交通省．

    1.  []{#_Toc192777851 .anchor}貯水池の維持管理対策

        1.  []{#_Toc192777852 .anchor}総説

＜考え方＞

+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 貯水池の維持管理対策は、堆砂の進行に対する貯水池容量や取水・放流機能の保持、富栄養化・濁水長期化等による影響の軽減、洪水時に流入する流木・塵芥等の流下の防止、貯水池の適正な利用、貯水池及びその周辺の良好な環境の保全等を目的として行うものである。                   |
|                                                                                                                                                                                                                                                                        |
| また、大規模な土木構造物である堤体や、水と緑のオープンスペースを提供する貯水池は、地域活性化の核として期待されることから、貯水池の維持管理対策においては、ダム施設や貯水池を観光資源として捉え、積極的に活用することにより、水源地域の活性化に努めることも重要である。 |
+========================================================================================================================================================================================================================================================================+

2.  []{#_Toc192777853 .anchor}堆砂対策

＜考え方＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 堆砂対策は、貯水池容量や取水・放流機能の保持、貯水池上流端部の堆砂に起因する浸水対策等を目的として行う。                                                       |
|                                                                                                                                                                |
| 堆砂対策は、貯水池流入土砂の軽減対策、貯水池流入土砂の通過対策、及び貯水池堆砂の排除対策に大別されるが、必要に応じて、それらの対策を組み合わせて行う。         |
|                                                                                                                                                                |
| 対策工法は、堆砂の将来予測、対策の目標、管理堆砂面の設定、施工性、土砂処分方法等について詳細に検討し選定することが重要である。                                 |
|                                                                                                                                                                |
| 下流河川の環境改善を含む総合的な土砂管理の観点から、排除土砂は、その量や性状について検討した上で、必要に応じて、下流河川への土砂還元に努めることが重要である。 |
|                                                                                                                                                                |
| また、流入土砂量の予測精度の向上、現場条件に応じた貯水池堆砂の効果的・効率的な排除技術の開発、排除土砂の有効活用に関する技術開発が重要である。                 |
+================================================================================================================================================================+

＜標　準＞

+--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 貯水池の堆砂対策は、堆砂調査結果等を総合的に分析・評価した上で、必要な対策を行うことを基本とする。                                                                                                                                                                                                                                                                                               |
|                                                                                                                                                                                                                                                                                                                                                                                                  |
| 堆砂対策の実施の必要性は、貯水池内の堆砂進行度や維持掘削の実施状況等を踏まえて判断するものとするが、堆砂進行度に応じて「堆砂対策検討開始」、「堆砂対策検討開始に向けた調査実施（基本調査＋詳細調査）」及び「堆砂状況の把握（基本調査）」のいずれかの対応をとることを基本とする。なお、大規模出水等によって非定常的に発生する堆砂に対しては、当該事象が生じた段階で対策を講じることを基本とする。 |
|                                                                                                                                                                                                                                                                                                                                                                                                  |
| 堆砂対策の検討は、当該ダムの今後の計画堆砂年を踏まえた上で、ダムの特性及び各堆砂対策工法の適用性に応じた工法を選定することを基本とする。                                                                                                                                                                                                                                                         |
|                                                                                                                                                                                                                                                                                                                                                                                                  |
| また、今後の対策の検討や対策の見直しをする場合に備え、必要不可欠な情報である貯水池の堆砂対策の実施判断結果や、堆砂対策実施状況、調査結果・観測データ等についての記録を、収集・整理し、蓄積し、さらに、対策の効果について定期的に分析・評価を行い、効果を検証することを基本とする。                                                                                                               |
+==================================================================================================================================================================================================================================================================================================================================================================================================+

＜推　奨＞

  ----------------------------------------------------------------------------------------------------------------------
  堆砂対策の検討においては、総合土砂管理の観点から必要とされる下流還元土砂の量と粒径についても考慮することが望ましい。
  ----------------------------------------------------------------------------------------------------------------------

  ----------------------------------------------------------------------------------------------------------------------

＜例　示＞

+-----------------------------------------------------------------------+
| 主な堆砂対策としては、図2-7に示す対策が考えられる。                   |
|                                                                       |
| ![](media/image13.emf){width="3.6758748906386702in"                   |
| height="3.486956474190726in"}                                         |
|                                                                       |
| 図2-7　主な堆砂対策                                                   |
+=======================================================================+

＜関連通知等＞

1.  ダム貯水池土砂管理の手引き（案），平成30年3月，国土交通省水管理・国土保全局河川環境課．

<!-- -->

87. 下流河川土砂還元マニュアル（案）第2版，平成23年3月，国土交通省河川局河川環境課．

＜参考となる資料＞

88. 土木技術資料，vol.45，No.3ダム貯水池の堆砂形態，櫻井寿之・柏井条介・大黒真希，2003．

89. 土木技術資料vol.55，No.1貯水池の長寿命化のための堆砂対策技術の開発，箱石憲昭・櫻井寿之，2013．

90. 日本大ダム会議土砂管理分科会　土砂管理分科会報告－貯水池の土砂動態と土砂制御工法－，（社）日本大ダム会議，2010．

91. ダムの堆砂対策技術ノート－ダム機能向上と環境改善に向けて－，（財）ダム水源地環境整備センター，2008．　

92. ダム技術，No.215　貯水池機能の保全設備－堆砂対策－，柏井条介，2004．

93. 国土技術政策総合研究所資料第521号・土木研究所資料第4140号　ダムと下流河川の物理環境との関係についての捉え方－下流河川の生物・生態系との関係把握に向けて－，国土交通省国土技術政策総合研究所・独立行政法人土木研究所，2009．

94. 総合土砂管理計画策定の手引き　第1.0版：（一財）国土技術研究センター，2019　

95. 土砂バイパストンネル計画策定のための参考手引き（案）：ダム土砂マネジメント研究会・（一財）水源地環境センター，2023

96. ダムと環境の科学Ⅳ　流砂環境再生,角哲也・竹門康弘・天野邦彦・一柳英隆，2023

    1.  []{#_Toc192777854 .anchor}水質改善対策

＜考え方＞

+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 貯水池では、流水の貯留に伴う水理学的な変化により、水質変化現象が発生する場合がある。                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
|                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| 水質変化現象が発生した場合には、まず発生場所や原因物質の特定、影響範囲等の発生状況の把握を行い、緊急対応の必要性があるかどうかを判断し、例えば、カビ臭発生による取水停止、貧酸素状態の水や底泥溶出に起因する有害物質を含む水の放流が原因の魚類等の斃死といった水質事故やそれに準じる事象が確認された時は、適切な対応を速やかに実施する。発生した水質変化現象の継続が想定され、緊急対応だけでなく恒常的な対策が必要と考えられる場合（例えば、濁水長期化現象、アオコやカビ臭等に代表される富栄養化現象、赤水・黒水等に代表される底層嫌気化にかかわる現象が発生した場合等）には、必要に応じて、その影響を軽減することを目的として、水質改善対策を行う。 |
|                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| なお、水質変化現象は、貯水池の特性、流域の自然環境、社会環境に大きく影響される。このため、水質改善対策は、問題となる水質変化現象の発生メカニズム等を把握するとともに、水質改善対策の限界も考慮した上で、総合的に検討を行う必要がある。                                                                                                                                                                                                                                                                                                                                                                                                               |
|                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| また、水質変化現象には、プランクトンの生態等未解明な部分もあり、適切な調査手法の開発、水質予測技術の向上、効果的な水質改善技術の開発に取り組むことも重要である。                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
+======================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================+

＜標　準＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 貯水池の水質改善対策については、水質調査結果等を総合的に分析・評価した上で、必要な対策を行うことを基本とする。                                                                                                                                     |
|                                                                                                                                                                                                                                                    |
| また、対策の効果について定期的に分析・評価を行い、効果を検証することを基本とする。                                                                                                                                                                 |
|                                                                                                                                                                                                                                                    |
| なお、気泡式（曝気式）循環施設や選択取水設備等を対策として選定した場合は、既往知見やシミュレーション結果等に基づき運用方法等を設定して運用し、その運用に基づく対策効果の検証を行い、必要に応じて、運用方法の変更等の措置を講じることを基本とする。 |
+====================================================================================================================================================================================================================================================+

＜推　奨＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  水質改善対策の実施においては、流域での負荷抑制が効果的であることから、必要に応じて、流域内の関係機関等と連携し、汚濁発生源対策等の流入水質対策を推進することが望ましい。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜例　示＞

+-------------------------------------------------------------------------------------------------------------+
| 主な水質改善対策としては、表2-4に示す対策が考えられる。                                                     |
|                                                                                                             |
| 表2-4　主な水質改善対策                                                                                     |
|                                                                                                             |
| +------------+------------------+--------------------------+----------------------------------------------+ |
| | 対象の別   | 対策者の別       | 対策の種別               | 主な水質変化現象                             | |
| |            |                  |                          +--------------+----------------+--------------+ |
| |            |                  |                          | 冷・温水現象 | 濁水長期化現象 | 富栄養化現象 | |
| +:===========+:=================+:=========================+:============:+:==============:+:============:+ |
| | 流入水対策 | ダム管理者の対策 | バイパス水路             | ○            | ○              | ○            | |
| |            |                  +--------------------------+--------------+----------------+--------------+ |
| |            |                  | 流入水質対策 ※1          |              |                | ○            | |
| |            |                  +--------------------------+--------------+----------------+--------------+ |
| |            |                  | 前貯水池 ※2              |              |                | ○            | |
| |            |                  +--------------------------+--------------+----------------+--------------+ |
| |            |                  | 環境保全帯 ※3            |              | ○              | ○            | |
| |            |                  +--------------------------+--------------+----------------+--------------+ |
| |            |                  | フェンス ※4              |              | ○              | ○            | |
| |            +------------------+--------------------------+--------------+----------------+--------------+ |
| |            | ダム管理者以外の | 点源負荷対策 ※5          |              | ○              | ○            | |
| |            |                  |                          |              |                |              | |
| |            | 対策             |                          |              |                |              | |
| |            |                  +--------------------------+--------------+----------------+--------------+ |
| |            |                  | 面源負荷対策 ※6          |              | ○              | ○            | |
| +------------+------------------+--------------------------+--------------+----------------+--------------+ |
| | 貯水池対策 | ダム管理者の対策 | 選択取水設備             | ○            | ○              | ○            | |
| |            |                  +--------------------------+--------------+----------------+--------------+ |
| |            |                  | 気泡式（曝気式）循環施設 | ○            | ○              | ○            | |
| |            |                  +--------------------------+--------------+----------------+--------------+ |
| |            |                  | 底泥浚渫                 |              |                | ○            | |
| +------------+------------------+--------------------------+--------------+----------------+--------------+ |
|                                                                                                             |
| ※1：流入栄養塩類の削減を図るための、流入河川における植生浄化設備の設置など                                  |
|                                                                                                             |
| ※2：貯水池に栄養塩類を流入させる前に一時的に貯留できるダム等を設置し、栄養塩類の沈降を図るもの              |
|                                                                                                             |
| ※3：貯水池周辺における樹林帯の整備                                                                          |
|                                                                                                             |
| ※4：出水時の濁水や栄養塩類に富んだ流入水を深層部に導水するためのフェンスの設置                              |
|                                                                                                             |
| ※5：生活排水対策など                                                                                        |
|                                                                                                             |
| ※6：雨水の地下浸透の促進など                                                                                |
+=============================================================================================================+

＜関連通知等＞

1.  ダム貯水池水質改善の手引き，平成30年3月，国土交通省水管理・国土保全局河川環境課．

<!-- -->

97. 曝気循環施設及び選択取水設備の運用マニュアル（案），平成17年10月，国土交通省河川局河川環境課．

98. ダム貯水池水質改善に向けた気泡式循環施設マニュアル（案）～富栄養化対策のための気泡式（曝気式）循環施設に関する技術資料～，令和3年5月，国土交通省水管理・国土保全局河川環境課．

99. ダム貯水池水質改善に向けた水質シミュレーション活用のためのマニュアル（案）～基本的な考え方や設定に関する技術資料～，令和3年5月，国土交通省水管理・国土保全局河川環境課．

＜参考となる資料＞

100. 多目的ダムの建設－平成17年版，第2巻，第14章，（一財）ダム技術センター，2005．

101. 湖沼における水理・水質管理の技術，平成19年3月，湖沼技術研究会．

102. ダム技術，No.212　貯水池機能の保全施設　水質保全（富栄養化対策等），天野邦彦，2004．

103. プロペラ式湖水浄化システム設置・運用マニュアル　第2版：（一財）水源地環境センター，2023．

     1.  []{#_Toc192777855 .anchor}流木対策

＜考え方＞

+--------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 流木対策は、洪水時に貯水池に流入する流木・塵芥等による放流設備の損傷や閉塞のほか、貯水池の水質及び景観上の問題の発生を防止又は軽減することを目的として行う。 |
|                                                                                                                                                              |
| 流木対策においては、巡視により流木・塵芥等の流入状況を把握することが重要であり、洪水後は特に留意する必要がある。                                             |
+==============================================================================================================================================================+

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  流木対策は、ダム施設及び貯水池の機能を維持するため、流木止設備により貯水池に流入する流木・塵芥等が堤体近傍へ流下することを防止するとともに、適切な時期に貯水池に流入した流木・塵芥等を処分するなど、必要な措置を講じることを基本とする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| ダム管理者は、流木対策を検討する基礎資料として、通年規模の流木量及び、大規模洪水における流木量を、あらかじめ推定しておくように努める。                                                                                 |
|                                                                                                                                                                                                                        |
| 貯水池から除去した流木は、必要に応じて、地域や関係機関と連携し、有効活用を図ることが望ましい。                                                                                                                         |
|                                                                                                                                                                                                                        |
| また、流木対策の検討の基礎資料とするため、除去した流木の処理量等はできるだけ計測を行い、記録の保存に努めるとともに、流域の山林等の状況や貯水池への流入河川の樹林化等の状況を、可能な範囲で情報収集することが望ましい。 |
+========================================================================================================================================================================================================================+

＜例　示＞

+-------------------------------------------------------------------------------+
| ダム貯水池における流木対策の流れを図2-8に例示する。                           |
|                                                                               |
| ![](media/image14.emf){width="4.46875in" height="3.5104166666666665in"}       |
|                                                                               |
| > ※流木量の推定：流木量の測定及び撤去等に係る予算を計上するうえで必要となる。 |
|                                                                               |
| 図2-8　ダム貯水池における流木対策の構成                                       |
+===============================================================================+

＜関連通知等＞

1.  河川砂防技術基準調査編，第17章，令和5年5月，国土交通省水管理・国土保全局．

<!-- -->

104. ダム貯水池流木対策の手引き（案），平成30年3月，国土交通省水管理・国土保全局河川環境課．

105. 河川内樹木及びダム流木のバイオマス利用の手引，令和6年3月29日，環境省大臣官房総合政策課環境研究技術室・国土交通省水管理・国土保全局河川環境課．

     1.  []{#_Toc192777856 .anchor}不法行為への対策

＜考え方＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------+
| 不法行為への対策は、ダム施設及び貯水池に係る土地及び空間が、公共用物として適正に利用されることを目的として行う。                                         |
|                                                                                                                                                          |
| 不法行為への対策においては、巡視により状況を把握することが重要であり、不法行為の内容によっては、市町村や警察等の関係機関とも連携して対応する必要がある。 |
+==========================================================================================================================================================+

＜標　準＞

+--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| ダム管理者は、不法行為を発見した際、行為者が明らかな場合は速やかに口頭で除却又は原状回復等の指導を行い、行為者が不明な場合は警告看板を設置するなど、必要な初動対応を行うとともに、法令等に基づき、不法行為の是正のための措置を迅速に講じることを基本とする。 |
|                                                                                                                                                                                                                                                              |
| 不法行為への具体的な対策等は、河川砂防技術基準維持管理編（河川編）^1)^を参考に行うことを基本とする。                                                                                                                                                         |
+==============================================================================================================================================================================================================================================================+

＜例　示＞

  ------------------------------------------------------------------------------------------------------------------------
  ダム施設及び貯水池における不法行為には、ごみ等の不法投棄、流水・土地の不法占用、船の不法係留、土地の形状変更等がある。
  ------------------------------------------------------------------------------------------------------------------------

  ------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1.  河川砂防技術基準維持管理編（河川編），第7章，令和3年10月，国土交通省水管理・国土保全局．

    1.  []{#_Toc192777857 .anchor}貯水池の適正な利用・水源地域の活性化

＜考え方＞

+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| ダム及びその周辺は、散策や施設利用、スポーツ、キャンプ、釣り、ボート等の様々な形態で利用されており、従来からダムに求められている洪水調節、流水の正常な機能の維持及び利水補給等の機能に加えて、新たな水と緑のオープンスペースを利用したレクリエーション等の場としての親水機能を併せ持っている。 |
|                                                                                                                                                                                                                                                                                                |
| ダム及びその周辺を活かした水源地域の自立的、持続的な活性化を図るため、自然豊かな水辺環境等を国民が広く利用できるような取り組みが重要である。また、ダムの重要性について理解が深まるような取り組みも重要である。                                                                                 |
|                                                                                                                                                                                                                                                                                                |
| 貯水池の利用は自由使用が原則であるが、その利用によってダムの運用に支障をきたすことや、貯水池の水質や貯水池周辺の環境等に悪影響を及ぼすことなどがないよう、適正な利用を図る必要がある。                                                                                                         |
|                                                                                                                                                                                                                                                                                                |
| また、貯水池の利用にあたって、利用者自らが安全に留意する必要がある。                                                                                                                                                                                                                           |
+================================================================================================================================================================================================================================================================================================+

＜必　須＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------
  ダム管理者は、流域内の連携と交流によるバランスのとれた流域圏の発展を目指し、水源地域の自治体や住民等と共同で、水源地域の自立的・持続的な活性化を図るものとする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| ダム管理者は、ダムの機能を保持するため、管理に支障を与える貯水池内の区域を利用禁止区域に設定するなど、必要に応じて、利用等の制限を行うことを基本とする。                                                                                                                                 |
|                                                                                                                                                                                                                                                                                          |
| また、貯水池の利用に対する危険又は支障を認めた場合は、安全のために必要な対応を検討した上で、危険性の表示等の適切な措置を講じることを基本とする。                                                                                                                                         |
|                                                                                                                                                                                                                                                                                          |
| ダムの観光放流の実施にあたっては、河川利用者の安全確保を徹底するため、操作規則等にある放流には観光放流が含まれることを明記するとともに、各ダムの下流河川における利用形態等の特性を踏まえ、関係自治体等と調整を行った上で、確実に下流河川の関係者に周知されるようにすることを基本とする。 |
+==========================================================================================================================================================================================================================================================================================+

＜推　奨＞

+--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 水源地域の自治体、住民等と共同で、ダム及びその周辺の豊かな自然や、水源地域の伝統的な文化活動等を利用した水源地域の自立的、持続的な活性化方策等を定めた行動計画を策定し、ダムを活かした水源地域の活性化に努める。なお、水源地域活性化のための行動計画の策定においては、ダム事業者、流域の自治体、住民、関係行政機関、有識者等からなる組織を設置し、水源地域の関係者の意向を反映できる方法により行うことが望ましい。 |
|                                                                                                                                                                                                                                                                                                                                                                                                                    |
| 観光による水源地域の活性化のため、ダム及びその周辺の特徴的な施設等を観光資源として活用するよう努める。                                                                                                                                                                                                                                                                                                             |
|                                                                                                                                                                                                                                                                                                                                                                                                                    |
| また、地元自治体等と連携して、ダムを利用したイベント等を行うことにより、水源地域や流域内外の住民がダムに親しみ、ダムに対する理解を深める機会の提供に努める。                                                                                                                                                                                                                                                       |
|                                                                                                                                                                                                                                                                                                                                                                                                                    |
| なお、貯水池の適正な利用を図るため、貯水池の利用状況に応じて、関係者とともに必要な調整を行い、湖面利用計画等を定めることが望ましい。                                                                                                                                                                                                                                                                               |
+====================================================================================================================================================================================================================================================================================================================================================================================================================+

＜例　示＞

+-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 水源地域活性化のための行動計画としては、水源地域ビジョン^4)^がある。                                                                                                                                            |
|                                                                                                                                                                                                                 |
| ダムの具体的な利用に関する制度としては、かわまちづくり^2)^や河川空間のオープン化^3)^があり、ダム周辺の整備や利用が行われている。                                                                                |
|                                                                                                                                                                                                                 |
| また、ダムに親しむ機会としては、森と湖に親しむ旬間^5)^（毎年7月21日～31日）や水の週間（毎年8月1日～8月7日）を中心に、ダム管理者と地元自治体等が連携し、ダム見学会や湖面を利用したイベントを行っている例がある。 |
+=================================================================================================================================================================================================================+

＜関連通知等＞

1.  観光放流にあたっての下流河川における安全確保の徹底について，平成29年6月27日，国水流第4号，河川環境課長通知．

<!-- -->

106. かわまちづくり計画策定の手引き
     第1版，令和2年3月，国土交通省水管理・国土保全局河川環境課．

107. 河川空間のオープン化活用事例集，令和6年7月，国土交通省水管理・国土保全局．

108. 「水源地域ビジョン」による21世紀のダムづくりの推進について，平成13年4月12日，国水対第18号・国都公緑第59号・国河環第41号，河川局長・都市地域整備局長・土地・水資源局水資源部長通達．

109. 昭和62年度「森と湖に親しむ旬間」の実施について，昭和62年6月22日，建河開発第84号，河川局長通達．

     1.  []{#_Toc192777858 .anchor}貯水池及びその周辺の環境保全対策

＜考え方＞

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  貯水池及びその周辺の環境保全においては、下流河川の生態系を含む環境調査結果等を踏まえ、また、ダム固有の環境条件や社会的な要請等も考慮し、必要に応じて、環境への影響を軽減するための対策を行うことが必要である。
  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+--------------------------------------------------------------------------------------------------------------------------+
| ダム管理者は、貯水池及びその周辺の環境調査結果等を総合的に分析・評価した上で、必要な環境保全対策を行うことを基本とする。 |
|                                                                                                                          |
| また、対策の効果について定期的に分析・評価を行い、効果を検証することを基本とする。                                       |
+==========================================================================================================================+

＜例　示＞

+------------------------------------------------------------------------------------------+
| 河川水辺の国勢調査結果等を踏まえ、重要種の保全や特定外来生物の防除を行っている例がある。 |
|                                                                                          |
| 下流河川に対する環境対策として、ダムの弾力的管理や土砂還元を行っている例がある。         |
+==========================================================================================+

＜関連通知等＞

1.  地域と連携した外来植物
    防除対策ハンドブック（案），令和3年7月，国土交通省河川環境課．

<!-- -->

110. ダムの弾力的管理について，平成30年5月28日，国水環第4号，河川環境課長通知．

111. 下流河川土砂還元マニュアル（案）第2版，平成23年3月，国土交通省河川局河川環境課．

     1.  []{#_Toc192777859 .anchor}水質事故対策

＜考え方＞

+--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 流域では通常の社会・経済活動が行われていることから、車両等からの油の流出、工場等からの有毒廃液や薬品類等の流出、不法投棄等の水質事故が発生する可能性がある。                                                                   |
|                                                                                                                                                                                                                                |
| ダムの貯留水は、かんがい用水、水道用水、工業用水等として使用されるため、貯水池や流域での水質事故への対応は非常に重要である。                                                                                                   |
|                                                                                                                                                                                                                                |
| 河川法では、水質事故の原因者に水質事故処理等の河川の維持について行わせることができ（同法第18条）、又はその費用を負担させる（同法第67条）こととしていることから、原因者が判明した場合は、法令に従って処理することが必要である。 |
+================================================================================================================================================================================================================================+

＜必　須＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  ダム管理者は、貯水池等で水質事故が発生した場合は、事故発生状況に係る情報を速やかに収集し、関係機関に通報するとともに、関係機関と連携し、必要な対策を速やかに行うものとする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| ダム管理者は突発的に発生する水質事故に対応するため、あらかじめ流域内の水質事故に係る汚濁源情報の把握に努めることを基本とする。また、ダム管理者と関係機関で構成する水質汚濁防止に関する連絡協議会等による情報連絡体制を整備し、常時情報の交換を行い、夜間・休日を問わず、緊急事態が発生した場合に即応できるようにすることを基本とする。 |
|                                                                                                                                                                                                                                                                                                                                        |
| さらに、関係機関の役割分担を明確にして、緊急事態が発生した場合に行う応急対策、水質分析、原因者究明のための調査、原因者への指導等を速やかに行うことができる体制を構築するとともに、緊急時の対策を確実かつ円滑に行えるよう、情報伝達訓練、現地対策訓練等を、必要に応じて、定期的に行うことを基本とする。                                 |
|                                                                                                                                                                                                                                                                                                                                        |
| 水質事故に係る対応は原因者が行うことが原則であるが、水質事故対応が緊急を要するものである場合や、事故による水質汚濁が広範囲に及ぶ場合等、原因者のみによる対応では迅速かつ効果的な対応ができない場合は、ダム管理者は必要な措置を講じることを基本とする。                                                                                 |
|                                                                                                                                                                                                                                                                                                                                        |
| ダム管理者は、過去に発生した水質事故を勘案の上、必要な水質事故対策資材の備蓄を行うほか、関係機関の備蓄状況についても把握するなど、事故発生時に速やかに資材等の確保を図ることを基本とする。                                                                                                                                             |
+========================================================================================================================================================================================================================================================================================================================================+

＜例　示＞

  --------------------------------------------------------------------------------------------------------------------------------
  ダム管理者が行う水質事故への緊急対応としては、原因物質の除去、フェンス等の設置、選択取水設備の運用（取水深の変更）などがある。
  --------------------------------------------------------------------------------------------------------------------------------

  --------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1.  河川法施行令の一部を改正する政令の施行について，昭和45年9月10日，建河政発第100号，河川局長通達．

<!-- -->

112. 河川砂防技術基準調査編，第12章,第13章，平成26年4月1日，国土交通省水管理・国土保全局．

113. 河川砂防技術基準維持管理編（河川編），第9章，令和3年10月，国土交通省水管理・国土保全局．

114. ダム貯水池水質改善の手引き，平成30年3月，国土交通省水管理・国土保全局河川環境課．

＜参考となる資料＞

115. 水質事故対策技術\[2001年版\]，平成13年9月，国土交通省水質連絡会．

     1.  []{#_Toc192777860 .anchor}許可工作物

＜考え方＞

+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 許可工作物のダムは、治水上又は利水上の支障等を生じさせない必要があることから、河川管理施設のダムと同等の水準で維持管理が行われ、施設の機能が良好な状態に維持される必要がある。                                                                                                                                                                              |
|                                                                                                                                                                                                                                                                                                                                                             |
| このため、ダム設置者は、1年に1回以上の適切な頻度で、適切な時期に、目視その他適切な方法で点検を行い、ダムを良好な状態に保つように維持し、修繕し、もって公共の安全が保持されるように努めなければならず、点検等によりダムに異状があることを把握したときは、効率的な維持及び修繕が図られるよう、河川法第15条2の規定により、必要な措置を講じることとされている。 |
|                                                                                                                                                                                                                                                                                                                                                             |
| また、許可工作物のダムは、点検及び整備に関する事項を含む操作規程等を定め、河川管理者の承認を受けることとされており、さらに、ダムの維持、操作、その他の管理を行うため、河川法第50条の規定により、一定の資格を有するダム管理主任技術者を置くことが定められている。                                                                                            |
|                                                                                                                                                                                                                                                                                                                                                             |
| 河川管理者は、ダム設置者により点検、維持、操作等が適切に行われているかを確認する必要がある。                                                                                                                                                                                                                                                                |
+=============================================================================================================================================================================================================================================================================================================================================================+

＜必　須＞

+--------------------------------------------------------------------------------------------------------------------------------------------+
| 河川管理者は、許可工作物のダムの維持、操作その他の管理の状況について、ダム検査規程^1)^に基づき、定期検査^2)^を行うものとする。             |
|                                                                                                                                            |
| また、河川管理者は、ダム設置者により必要な維持・修繕等が行われるよう、ダム設置後の状況に応じて、ダム設置者へ指導・監督等を行うものとする。 |
+============================================================================================================================================+

＜標　準＞

+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 河川管理者は、「河川法第2章第3節第3款（ダムに関する特則）等の規程の運用について」^3)^に規定する第1類から第3類のダムにあっては3年に1回以上、第4類のダムにあっては5年に1回以上の頻度で、定期検査を行うことを基本とする（表2-5）。 |
|                                                                                                                                                                                                                                 |
| > 表2-5　河川法第2章第3節第3款（ダムに関する特則）等の規程の運用における許可工作物のダムの分類                                                                                                                                  |
|                                                                                                                                                                                                                                 |
| ![](media/image15.emf){width="5.27755905511811in" height="2.465748031496063in"}                                                                                                                                                 |
|                                                                                                                                                                                                                                 |
| 河川管理者は、以下により定期検査を行うことを基本とする。                                                                                                                                                                        |
|                                                                                                                                                                                                                                 |
| > ① ダム及びその基礎地盤の温度、変形、揚圧力、間隙水圧又は漏水量を測定記録により確認すること。ただし、許可において測定を要しないこととされた事項については、この限りではない。                                                  |
| >                                                                                                                                                                                                                               |
| > ② ゲート等の開閉の状況をその開閉を試みること等により確認すること。                                                                                                                                                            |
| >                                                                                                                                                                                                                               |
| > ③ 観測施設、通報施設及び警報施設がそれぞれの機能に応じて的確に作動するかどうかをそれらの使用を試みること等により確認すること。                                                                                                |
| >                                                                                                                                                                                                                               |
| > ④ 上流において堆砂等による河床又は水位の上昇がないかどうかを観測記録により確認すること。                                                                                                                                      |
| >                                                                                                                                                                                                                               |
| > ⑤ 貯水池内の河岸又はその附近の土地の崩壊又は地すべりのおそれがないかどうかを現地において確認すること。                                                                                                                        |
| >                                                                                                                                                                                                                               |
| > ⑥ その他ダムの管理が適正に行われているかどうかを現地において又は管理記録により確認すること。                                                                                                                                  |
|                                                                                                                                                                                                                                 |
| なお、定期検査は、ダム定期検査の手引き^2)^に基づいて行うことを標準とする。                                                                                                                                                      |
+=================================================================================================================================================================================================================================+

＜関連通知等＞

1.  ダム検査規程，昭和43年2月17日，建設省訓令第2号．

<!-- -->

116. ダム検査規程における定期検査の実施について，平成28年3月15日，国水流第25号，河川環境課長通知．

117. 河川法第2章第3節第3款（ダムに関する特則）等の規定の運用について，昭和51年10月26日，建河政発第68号，河川局長通達．

118. ダムの管理主任技術者の資格の認定について，平成元年3月27日，建河政発第33号，河川局長通達．

119. 河川法施行規則第27条の2第1項第1号及び第2号に規定する国土交通大臣の定める要件等を定める告示，平成13年3月30日，国土交通省告示第400号．

<!-- -->

3.  []{#_Toc192777861 .anchor}流水管理

    1.  []{#_Toc192777862 .anchor}総説

        1.  []{#_Toc192777863 .anchor}総説

＜考え方＞

+--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| ダムは、洪水調節、流水の正常な機能の維持及び利水補給等多様な目的を持つ社会資本であり、流水管理においては、これらの機能が発揮されるようダムを操作する必要がある。                                                                                                                                                                     |
|                                                                                                                                                                                                                                                                                                                                      |
| 流水管理は、洪水時の高水管理と、平常時や渇水時の低水管理に大別される。高水管理の目的は、自然現象である降雨により生起する様々な洪水に対して、ダムを適切に操作し、下流域の洪水被害を軽減することである。また、低水管理の目的は、流水を適切に管理することにより、流水の正常な機能を維持するとともに、安定的な利水補給を行うことである。 |
|                                                                                                                                                                                                                                                                                                                                      |
| 既存施設の更なる有効活用を目的として、ダムの弾力的な管理・運用（第3章第2節2.2参照）の取り組みが進められている。ダムの弾力的な管理・運用の取り組みとして、防災機能の一層の向上を目的とした「事前放流」及び「特別防災操作〈ただし書き操作〉」のほか、下流河川の環境保全を目的とした「弾力的管理」がある。                              |
|                                                                                                                                                                                                                                                                                                                                      |
| ダムによる流水管理は、ダムの計画内容及びその計画の前提となっている諸条件を把握し、施設の能力とその限界を理解して行う必要がある。                                                                                                                                                                                                     |
|                                                                                                                                                                                                                                                                                                                                      |
| また、日頃から洪水演習等を定期的に行うことにより、操作を行う者が設備の操作方法等に習熟する必要がある。                                                                                                                                                                                                                               |
|                                                                                                                                                                                                                                                                                                                                      |
| 流水管理については、第4章に示すダムの管理に係るフォローアップの考え方に従い、ＰＤＣＡサイクルによる維持管理を行うことが重要である。                                                                                                                                                                                                  |
+======================================================================================================================================================================================================================================================================================================================================+

＜標　準＞

+--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| ダムによる流水管理を適切に行うため、以下の準備をすることを基本とする。                                                                                                                                                                                       |
|                                                                                                                                                                                                                                                              |
| > ① ダムの計画及び関連計画、洪水調節計画、洪水調節実績、洪水・渇水資料等、流水管理に関連する資料を整理し、とりまとめる。                                                                                                                                     |
| >                                                                                                                                                                                                                                                            |
| > ②                                                                                                                                                                                                                                                          |
| > 日頃から種々の出水を想定し、初動体制、夜間・休日における要員確保体制、機器等の点検・整備、情報伝達、警報及び操作等に関する演習を行う。演習は、操作規則等に定める関係機関と共同で行うことを基本とする。特に、夜間・休日等の情報伝達・確認方法を明確にする。 |
+==============================================================================================================================================================================================================================================================+

＜推　奨＞

+--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 洪水時のダムの役割や操作について関係機関の理解を得ることや、放流通知等の連絡系統を確認するなど円滑な情報共有を図るため、流域にある関係機関が連絡調整を行う場を設けることが望ましい。 |
|                                                                                                                                                                                      |
| 同一水系に複数のダムが存在する場合は、高水管理や低水管理を効果的・効率的に行うため、ダムを連携して運用する統合管理を予め検討することが望ましい。                                     |
+======================================================================================================================================================================================+

＜例　示＞

+--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| ダムの管理に関する情報について、受け手に正確に理解され、受け手の的確な判断や行動につながるような情報の内容や表現に改善するため、従来使用されてきた用語の見直しが行われている。 |
|                                                                                                                                                                                |
| 関連通知等^1)2)^による用語の対応関係の例を表3-1及び表3-2に示す。本基準においては、原則として「見直し後〈見直し前〉」の形で記載している。                                       |
|                                                                                                                                                                                |
| 表3-1　ダムの水位に関する用語                                                                                                                                                  |
|                                                                                                                                                                                |
|   -----------------------------------------------------------------------                                                                                                      |
|   見直し前                            見直し後                                                                                                                                 |
|   ----------------------------------- -----------------------------------                                                                                                      |
|   設計洪水位                          設計最高水位                                                                                                                             |
|                                                                                                                                                                                |
|   サーチャージ水位                    洪水時最高水位                                                                                                                           |
|                                                                                                                                                                                |
|   常時満水位                          平常時最高貯水位                                                                                                                         |
|                                                                                                                                                                                |
|   洪水期制限水位                      洪水貯留準備水位                                                                                                                         |
|   -----------------------------------------------------------------------                                                                                                      |
|                                                                                                                                                                                |
| 表3-2　ダムの放流操作に関する用語                                                                                                                                              |
|                                                                                                                                                                                |
| +----------------+--------------------+------------------------------------------------------------------------------------------------------------------------+               |
| | 見直し前       | 見直し後           | 説　明                                                                                                                 |               |
| +:==============:+:==================:+========================================================================================================================+               |
| | ただし書き操作 | 異常洪水時防災操作 | 大きな出水によりダムの洪水調節容量を使い切る可能性が生じたため、放流量を徐々に増加させ、流入量と同じ流量を放流する操作 |               |
| |                +--------------------+------------------------------------------------------------------------------------------------------------------------+               |
| |                | 特別防災操作       | 下流の被害を軽減するために貯留量を増やして容量を有効に活用する高度な操作                                               |               |
| +----------------+--------------------+------------------------------------------------------------------------------------------------------------------------+               |
+================================================================================================================================================================================+

＜関連通知等＞

1.  洪水等に関する防災情報体系の見直しについて：平成18年10月1日，国河情第3号，河川局長通達.

<!-- -->

120. ダム操作に関する用語等の見直しについて（改訂）：平成23年4月1日，国河流第4号，流水管理室長通知.

121. ダム管理体制の充実強化について：平成元年3月27日，建河開発第36号，河川局長通達.

122. ダム管理体制の充実強化について：平成元年3月27日，建河開発第37号，開発課長通知．

     1.  []{#_Toc192777864 .anchor}操作規則等

＜考え方＞

+--------------------------------------------------------------------------------------------------------------------------------------------+
| 河川管理施設のダムは、施行令に基づき、操作規則等にダムの操作に関する事項等を定めることとされており、これに基づきダムを操作する必要がある。 |
|                                                                                                                                            |
| 操作規則等に定める事項は、河川法施行令第9条では、以下のとおり定められている。                                                              |
|                                                                                                                                            |
| > ① 施設の操作の基準となる水位、流量等に関する事項                                                                                         |
| >                                                                                                                                          |
| > ② 施設の操作の方法に関する事項                                                                                                           |
| >                                                                                                                                          |
| > ③ 施設及び施設を操作するため必要な機械、器具等の点検及び整備に関する事項                                                                 |
| >                                                                                                                                          |
| > ④ 施設を操作するため必要な気象及び水象の観測に関する事項                                                                                 |
| >                                                                                                                                          |
| > ⑤ 施設の操作の際にとるべき措置に関する事項                                                                                               |
| >                                                                                                                                          |
| > ⑥ その他施設の操作に関し必要な事項                                                                                                       |
+============================================================================================================================================+

＜必　須＞

  ------------------------------------------------------------------------------------------------------------------------------------------------
  ダム管理者は、ダムが有する洪水調節、流水の正常な機能の維持及び利水補給等の機能が発揮されるよう、操作規則等に基づき、ダムを操作するものとする。
  ------------------------------------------------------------------------------------------------------------------------------------------------

  ------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| ダム管理者は、操作規則等に、表3-3に示す項目及び内容を定めることを基本とする。                                                                                                                                                      |
|                                                                                                                                                                                                                                    |
| また、操作規則等の策定においては、ダムの用途、計画諸元、設備の状況及び操作方法等の特性を勘案することを基本とする。                                                                                                                 |
|                                                                                                                                                                                                                                    |
| 表3-3　操作規則等に定める項目及び内容                                                                                                                                                                                              |
|                                                                                                                                                                                                                                    |
| +-----------------------------------------------------------------+--------------------------------------------------------------------------------------------------------------------------------------------------------------+ |
| | 項　　　目                                                      | 内　　　容                                                                                                                                                   | |
| +======================+==========================================+==============================================================================================================================================================+ |
| | 総 則                | 通則                                     | ダムの操作について、よるべき根拠を明確にする。                                                                                                               | |
| |                      +------------------------------------------+--------------------------------------------------------------------------------------------------------------------------------------------------------------+ |
| |                      | ダムの用途                               | ダムの運用の規範として、ダムの用途を記載する。                                                                                                               | |
| +----------------------+------------------------------------------+--------------------------------------------------------------------------------------------------------------------------------------------------------------+ |
| | 貯水池の水位等       | 洪水                                     | 操作の基準となる流量のうち、特に洪水調節に関して基本となる流量を定める。                                                                                     | |
| |                      +------------------------------------------+--------------------------------------------------------------------------------------------------------------------------------------------------------------+ |
| |                      | 洪水期間及び非洪水期間                   | 洪水期間及び非洪水期間を定める。                                                                                                                             | |
| |                      +------------------------------------------+--------------------------------------------------------------------------------------------------------------------------------------------------------------+ |
| |                      | 水位                                     | 貯水池の水位の測定について、基準となるべき水位計を定める。                                                                                                   | |
| |                      +------------------------------------------+--------------------------------------------------------------------------------------------------------------------------------------------------------------+ |
| |                      | 平常時最高貯水位                         | ダムの操作の基準となる水位のうち、ダムの平常時最高貯水位を記載する。                                                                                         | |
| |                      |                                          |                                                                                                                                                              | |
| |                      | 〈常時満水位〉                           |                                                                                                                                                              | |
| |                      +------------------------------------------+--------------------------------------------------------------------------------------------------------------------------------------------------------------+ |
| |                      | 洪水時最高水位                           | ダムの操作の基準となる水位のうち、ダムの洪水時最高水位を記載する。                                                                                           | |
| |                      |                                          |                                                                                                                                                              | |
| |                      | 〈サーチャージ水位〉                     |                                                                                                                                                              | |
| |                      +------------------------------------------+--------------------------------------------------------------------------------------------------------------------------------------------------------------+ |
| |                      | 洪水貯留準備水位                         | 上記のほか、ダムの用途等に応じて洪水貯留準備水位、確保水位、予備放流水位等を定める。                                                                         | |
| |                      |                                          |                                                                                                                                                              | |
| |                      | 〈洪水期制限水位〉等                     |                                                                                                                                                              | |
| +----------------------+------------------------------------------+--------------------------------------------------------------------------------------------------------------------------------------------------------------+ |
| | 貯水池の用途別利用   | 洪水調節等のための利用                   | 貯水池の用途別利用配分のうち、洪水調節等のための利用区分を記載する。                                                                                         | |
| |                      +------------------------------------------+--------------------------------------------------------------------------------------------------------------------------------------------------------------+ |
| |                      | 流水の正常な機能の維持のための利用等     | 貯水池の用途別利用配分のうち、該当する用途（流水の正常な機能の維持のための利用、水道用水の供給のための利用、発電のための利用等）のための利用区分を記載する。 | |
| +----------------------+------------------------------------------+--------------------------------------------------------------------------------------------------------------------------------------------------------------+ |
| | 洪水調節等           | 洪水警戒体制                             | 洪水警戒体制をとるべき場合を定める。                                                                                                                         | |
| |                      +------------------------------------------+--------------------------------------------------------------------------------------------------------------------------------------------------------------+ |
| |                      | 洪水警戒体制時における措置               | 洪水警戒体制時においてとるべき措置を定める。                                                                                                                 | |
| |                      +------------------------------------------+--------------------------------------------------------------------------------------------------------------------------------------------------------------+ |
| |                      | 洪水調節                                 | 洪水調節の方法を定める。                                                                                                                                     | |
| |                      +------------------------------------------+--------------------------------------------------------------------------------------------------------------------------------------------------------------+ |
| |                      | 洪水調節等の後における水位の低下         | 洪水調節等の後における水位の低下について定める。                                                                                                             | |
| |                      +------------------------------------------+--------------------------------------------------------------------------------------------------------------------------------------------------------------+ |
| |                      | 洪水に達しない流水の調節                 | 洪水に達しない流水の調節について定める。                                                                                                                     | |
| |                      +------------------------------------------+--------------------------------------------------------------------------------------------------------------------------------------------------------------+ |
| |                      | 洪水警戒体制の解除                       | 洪水警戒体制の解除について定める。                                                                                                                           | |
| +----------------------+------------------------------------------+--------------------------------------------------------------------------------------------------------------------------------------------------------------+ |
| | 貯留された流水の放流 | 貯留された流水を放流することができる場合 | 貯留された流水を放流することができる場合について、記載する。                                                                                                 | |
| |                      +------------------------------------------+--------------------------------------------------------------------------------------------------------------------------------------------------------------+ |
| |                      | 放流の原則                               | ダムからの放流について、守るべき原則を記載する。                                                                                                             | |
| |                      +------------------------------------------+--------------------------------------------------------------------------------------------------------------------------------------------------------------+ |
| |                      | 放流量                                   | ダムからの放流を行う場合の放流量の限度を定める。                                                                                                             | |
| |                      +------------------------------------------+--------------------------------------------------------------------------------------------------------------------------------------------------------------+ |
| |                      | 流水の正常な機能の維持のための放流等     | 流水の正常な機能の維持のための放流等に関する事項を定める。                                                                                                   | |
| |                      +------------------------------------------+--------------------------------------------------------------------------------------------------------------------------------------------------------------+ |
| |                      | 放流量等の決定                           | ダムの放流計画の決定及びその実施に際してとるべき措置を定める。                                                                                               | |
| |                      +------------------------------------------+--------------------------------------------------------------------------------------------------------------------------------------------------------------+ |
| |                      | 放流に関する通知等                       | ダムからの放流に関する通知等について定める。                                                                                                                 | |
| |                      +------------------------------------------+--------------------------------------------------------------------------------------------------------------------------------------------------------------+ |
| |                      | ゲート等の操作                           | ゲート等の操作についての原則を定める。                                                                                                                       | |
| +----------------------+------------------------------------------+--------------------------------------------------------------------------------------------------------------------------------------------------------------+ |
| | 点検、整備等         | 点検及び整備                             | ダム及びダムを操作するために必要な機械、器具等の点検及び整備に関する事項を定める。                                                                           | |
| |                      |                                          |                                                                                                                                                              | |
| |                      |                                          | 詳細については、第2章 1.2.1ダム点検整備基準　参照                                                                                                            | |
| |                      +------------------------------------------+--------------------------------------------------------------------------------------------------------------------------------------------------------------+ |
| |                      | 観測                                     | ダムを操作するため必要な気象及び水象の観測について定める。                                                                                                   | |
| |                      +------------------------------------------+--------------------------------------------------------------------------------------------------------------------------------------------------------------+ |
| |                      | 記録                                     | ゲート等の操作記録について定める。                                                                                                                           | |
| +----------------------+------------------------------------------+--------------------------------------------------------------------------------------------------------------------------------------------------------------+ |
| | 雑則                 | 細則、附則                               | 細則の制定及び附則について定める。                                                                                                                           | |
| +----------------------+------------------------------------------+--------------------------------------------------------------------------------------------------------------------------------------------------------------+ |
+====================================================================================================================================================================================================================================+

＜推　奨＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  洪水調節や利水補給等の管理実績、ダムの設備能力や下流河川の整備状況を調査するとともに、新たな情報通信技術を活用した安全で確実な操作を推進する観点から、操作規則等に改善すべき点がないかを定期的に分析・評価し、流水管理の内容の改善を図るため、必要に応じて、操作規則等の見直し等を行うことが望ましい。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1.  河川管理施設の操作規則について：昭和42年2月22日，建河政発第10号，河川局長通達.

<!-- -->

123. 河川法第14条及び特定多目的ダム法第31条に基づくダムに係る操作規則の策定について：平成13年11月28日，国河環第78号・国河治第170号，河川局長通達.

124. 国土交通省所管ダムの操作規則及び操作細則に関する記載例について：平成13年11月28日，国河環第79号・国河治第171号，河川環境課長・治水課長通知.

125. 多目的ダムの操作規則の解説：昭和41年7月，河川局開発課.

126. 国土交通省所管ダムに係る洪水調節操作の総点検の実施について：平成13年8月30日，国河環第34号，河川局長通達.

127. 国土交通省所管ダムに係る洪水調節操作の総点検実施要領について：平成13年8月30日，国河環第35号，河川環境課長通知.

     1.  []{#_Toc192777865 .anchor}水文・水理観測及び気象情報の収集

＜考え方＞

+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 河川管理施設のダムは、施行令に基づき、操作規則等に施設を操作するため必要な気象及び水象の観測に関する事項等を定めることとされており、これに基づき、水文・水理観測及び気象情報の収集を行うことが必要である。                                                                   |
|                                                                                                                                                                                                                                                                              |
| 水文・水理観測及び気象情報の収集には、以下の種類がある。                                                                                                                                                                                                                     |
|                                                                                                                                                                                                                                                                              |
| (1)降水量、積雪深等の観測                                                                                                                                                                                                                                                    |
|                                                                                                                                                                                                                                                                              |
| > 降水量は、洪水警戒体制の発令、流域での降雨状況の把握、流入量の予測等を行う上で基本となる情報である。降水量観測においては、自記雨量計を用いた地上雨量観測に加えて、面的な降水量分布が得られるレーダ雨量計による観測も行っている。                                           |
| >                                                                                                                                                                                                                                                                            |
| > 積雪深や降雪量は、融雪出水や利水運用において融雪による影響が大きいダムでは、融雪量予測に用いるために観測する。                                                                                                                                                             |
|                                                                                                                                                                                                                                                                              |
| (2)貯水位、河川水位の観測                                                                                                                                                                                                                                                    |
|                                                                                                                                                                                                                                                                              |
| > ダムの貯水位は、貯水池内に設置された水位計の測定データに基づいて算出され、ダムの貯水量を把握するとともに、流入量・放流量等を算定するための重要な情報である。                                                                                                               |
| >                                                                                                                                                                                                                                                                            |
| > ダムによる流水管理に関連する河川水位の観測は、ダム上流河川水位とダム下流河川水位に分類される。ダム上流河川水位は流入量の変化の把握や洪水のピーク到達時間の推定等に、ダム下流河川水位はダムからの放流による水位上昇量の把握や利水基準点までの到達時間の推定等に利用される。 |
|                                                                                                                                                                                                                                                                              |
| (3)気象情報の収集                                                                                                                                                                                                                                                            |
|                                                                                                                                                                                                                                                                              |
| > 気象情報は、流域の気象状況の把握、天候変化の予測、融雪量予測等に用いられる。ダムによる流水管理に必要な気象情報としては、堤体付近の気象観測設備による観測結果と気象台等が発表する気象情報がある。                                                                           |
| >                                                                                                                                                                                                                                                                            |
| > ① 気象観測設備による観測                                                                                                                                                                                                                                                   |
| >                                                                                                                                                                                                                                                                            |
| > 温度、湿度、気圧、風向・風速は、気象観測設備による基本的な観測項目であり、気象の経年変化の把握、天候変化の予測等に活用する。                                                                                                                                               |
| >                                                                                                                                                                                                                                                                            |
| > ② 気象台等が発表する気象情報の収集                                                                                                                                                                                                                                         |
| >                                                                                                                                                                                                                                                                            |
| > 気象台等が発表する天気予報、台風情報、気象予警報、降水短時間予報、長期予報等の気象情報は、現在の気象情報及び今後の気象変化の把握や、洪水警戒体制の発令・解除の判断に活用する。                                                                                             |
+==============================================================================================================================================================================================================================================================================+

＜必　須＞

  --------------------------------------------------------------------------------------------------------------------------------
  ダム管理者は、ダムによる流水管理に必要な情報を得るため、操作規則等に基づき、水文・水理観測及び気象情報の収集を行うものとする。
  --------------------------------------------------------------------------------------------------------------------------------

  --------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 水文・水理観測は、水文観測業務規程等^1)2)^及び河川砂防技術基準調査編^3)^に基づいて行うことを標準とする。                                                                                               |
|                                                                                                                                                                                                        |
| 融雪による影響が大きいダムにおいては、積雪深等の観測を行うことを基本とする。                                                                                                                           |
|                                                                                                                                                                                                        |
| ダム操作の安全性及び確実性を確保するため、貯水位データの欠測又は誤測を防止するよう適切な措置を講じることを基本とする。なお、水位計には自記記録装置を併設するとともに、連続測定を行うことを基本とする。 |
+========================================================================================================================================================================================================+

＜推　奨＞

+------------------------------------------------------------------------------------------------------------------------------------+
| 融雪による影響が大きいダムにおいては、融雪量予測の精度を向上させるため、日射量の観測を行うことが望ましい。                         |
|                                                                                                                                    |
| また、湛水面積が広く蒸発散量の影響が大きいダムにおいては、低水流出解析の精度を向上させるため、蒸発散量の観測を行うことが望ましい。 |
+====================================================================================================================================+

＜関連通知等＞

1.  水文観測業務規程の改定について：平成14年4月22日，国河環第6号，国土交通事務次官通達

<!-- -->

128. 水文観測業務規程細則の改定について：平成26年3月20日，国水情第45号，水管理・国土保全局長通達

129. 河川砂防技術基準調査編，第2章：平成26年4月1日，国水情第52号，水管理・国土保全局長通達

＜参考となる資料＞

130. 多目的ダムの建設－平成17年版，第7巻，第36章：（財）ダム技術センター，2005.

131. 水文観測：国土交通省監修，独立行政法人土木研究所編著，全日本建設技術協会，2002.

     1.  []{#_Toc192777866 .anchor}運用操作

         1.  []{#_Toc192777867 .anchor}ダムの操作

＜考え方＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| (1)高水管理                                                                                                                                                                                                                                                                                                                                                                                              |
|                                                                                                                                                                                                                                                                                                                                                                                                          |
| > 洪水時のダムの操作は、洪水警戒体制の発令やその際にとるべき措置等を含め、操作規則等に定められている。基本的な流れは図3-1のとおりである。                                                                                                                                                                                                                                                                |
| >                                                                                                                                                                                                                                                                                                                                                                                                        |
| > ゲートを有するダムにおいて、操作規則等の本文で定めた洪水調節方式（以下「本則操作」という。）による洪水調節を続けた場合に、貯水位がただし書き操作開始水位に達し、その後さらに洪水時最高水位〈サーチャージ水位〉を超えることが予測されるような洪水に対しては、操作規則等のただし書きの規定により、貯水位に応じてゲートを操作し、放流量を流入量まで増加させる異常洪水時防災操作〈ただし書き操作〉を行う。 |
| >                                                                                                                                                                                                                                                                                                                                                                                                        |
| > 一方、洪水の見通し及びダムの貯水状況を踏まえ、操作規則等のただし書きの規定により、本則操作よりも放流量を減少させる弾力的な運用を行い、下流域の洪水被害の軽減を図る特別防災操作〈ただし書き操作〉を行う場合がある。                                                                                                                                                                                     |
| >                                                                                                                                                                                                                                                                                                                                                                                                        |
| > このようなダムの洪水調節や貯水池の運用をより効率的に行うためには、降雨予測や流出予測の精度をより一層向上させるための技術開発が重要である。                                                                                                                                                                                                                                                             |
| >                                                                                                                                                                                                                                                                                                                                                                                                        |
| > また、大規模な地震や突発的な集中豪雨等の発生の際にも、確実に放流設備の操作を行うため、遠隔操作等に関する技術開発が重要である。                                                                                                                                                                                                                                                                         |
|                                                                                                                                                                                                                                                                                                                                                                                                          |
| ![](media/image16.emf){width="3.451298118985127in" height="2.138873578302712in"}                                                                                                                                                                                                                                                                                                                         |
|                                                                                                                                                                                                                                                                                                                                                                                                          |
| 図3-1　高水管理の基本的な流れ                                                                                                                                                                                                                                                                                                                                                                            |
|                                                                                                                                                                                                                                                                                                                                                                                                          |
| (2)低水管理                                                                                                                                                                                                                                                                                                                                                                                              |
|                                                                                                                                                                                                                                                                                                                                                                                                          |
| > 平常時や渇水時におけるダムからの放流量は、下流河川の流況、降雨状況、放流水の到達時間、並びに取水実態を総合的に勘案し、必要な水量が効率的に確保できるよう決定する必要がある。また、ダムへの流水の貯留は、洪水調節に支障を与えない範囲で極力無効放流が生じないよう効率的に行う必要がある。                                                                                                               |
| >                                                                                                                                                                                                                                                                                                                                                                                                        |
| > ダム群で連携して運用する場合は、必要な補給量を決定し、各ダムの貯留状況や流入量の見通し等を勘案して、各ダムへの配分を行う。                                                                                                                                                                                                                                                                             |
+==========================================================================================================================================================================================================================================================================================================================================================================================================+

＜必　須＞

+------------------------------------------------------------------------------------------------------------------------------------+
| ダム管理者は、流入量、貯水状況等を把握した上で、操作規則等に基づき、ダムを操作するものとする。                                     |
|                                                                                                                                    |
| また、ダム管理者は、ゲートを有するダムで異常洪水時防災操作〈ただし書き操作〉を的確に行うため、予め操作要領等を作成するものとする。 |
+====================================================================================================================================+

＜例　示＞

+-----------------------------------------------------------------------------------------------------------------------------------------------------------+
| 洪水時のダム操作の例を図3-2に示す。                                                                                                                       |
|                                                                                                                                                           |
| ![](media/image17.emf){width="6.296968503937008in" height="3.2031496062992124in"}                                                                         |
|                                                                                                                                                           |
| > ①　ダムからの放流量を流入量と等しくなるまで徐々に増加させる操作                                                                                         |
| >                                                                                                                                                         |
| > ②　貯水位をある一定の標高に維持するため、放流量と流入量を等しくする操作                                                                                 |
| >                                                                                                                                                         |
| > ③　流入量が洪水量に達した時点から流入量が最大になった後、放流量が流入量に等しくなるまでの間、ダムに一部を貯留しつつ本則操作による放流を行う操作         |
| >                                                                                                                                                         |
| > ④　本則操作による洪水調節を行った場合には、貯水位が洪水時最高水位〈サーチャージ水位〉を超えることが予測される場合に行う操作                             |
| >                                                                                                                                                         |
| > ⑤　次の洪水に対応するため、放流量を維持することにより、洪水調節によって上昇した貯水位を速やかに洪水貯留準備水位〈洪水期制限水位〉等にまで低下させる操作 |
|                                                                                                                                                           |
| 図3-2　洪水時のダム操作の例                                                                                                                               |
+===========================================================================================================================================================+

＜関連通知等＞

1.  計画規模を超える洪水時におけるただし書き操作の運用の改訂について：昭和59年6月29日，建河開発第62号，河川局長通達.

<!-- -->

132. ダム操作に関する用語等の見直しについて（改訂）：平成23年4月1日，国河流第4号，流水管理室長通知.

     1.  []{#_Toc192777868 .anchor}ダムの弾力的な管理・運用

         1.  []{#_Toc198801768 .anchor}事前放流

＜考え方＞

+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 降雨予測技術の進展も踏まえ、防災機能を一層向上させるための既存施設の有効活用の一環として、事前放流^1)^の検討を行うことが重要である。                                                                             |
|                                                                                                                                                                                                                  |
| 事前放流の検討においては、利水の共同事業者（以下「利水事業者」という。）の権利を侵すことのないように十分に留意し、調整する必要があるほか、下流河川利用者の安全確保、貯水池周辺斜面の安定性も考慮する必要がある。 |
|                                                                                                                                                                                                                  |
| なお、事前放流により確保した容量は、異常洪水時防災操作〈ただし書き操作〉の緩和に活用する。                                                                                                                       |
|                                                                                                                                                                                                                  |
| 事前放流の採用においては、関係都道府県及び市町村、並びに必要に応じてダム下流関係者に対して、事前放流の目的及び方法について説明する必要がある。                                                                   |
+==================================================================================================================================================================================================================+

＜必　須＞

  --------------------------------------------------------------------------------------------------------------
  ダム管理者は、洪水調節機能を一層向上させるためのダムの有効活用の一環として、事前放流の検討を行うものとする。
  --------------------------------------------------------------------------------------------------------------

  --------------------------------------------------------------------------------------------------------------

＜標　準＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 事前放流の検討は、事前放流ガイドライン（案）^2)3)^に基づいて行うことを標準とする。                                                                                                                             |
|                                                                                                                                                                                                                |
| 事前放流で確保する容量は、利水事業者に支障を与えない範囲でかつ、下流河川利用者の安全を確保できる放流とすること、及び貯水池周辺斜面の安定を確保できる水位低下速度により確保可能な範囲とすることを基本とする。   |
|                                                                                                                                                                                                                |
| なお、事前放流の検討においては、以下に示す容量の活用を参考とすることを基本とする。                                                                                                                             |
|                                                                                                                                                                                                                |
| > ① 降雨解析等により確実に回復が見込まれる容量                                                                                                                                                                 |
| >                                                                                                                                                                                                              |
| > ② 未利用容量                                                                                                                                                                                                 |
| >                                                                                                                                                                                                              |
| > ③ 不特定容量                                                                                                                                                                                                 |
| >                                                                                                                                                                                                              |
| > ④ 堆砂（死水）容量                                                                                                                                                                                           |
|                                                                                                                                                                                                                |
| 事前放流を行う場合は、事前放流を行う際の判断基準となる貯水位や降水量、関係機関への通知、事前放流により確保する貯水位の最低限度、事前放流の中止に関する事項を定めた事前放流実施要領を作成することを基本とする。 |
+================================================================================================================================================================================================================+

＜関連通知等＞

1.  国土交通省所管ダムにおける事前放流の実施について：平成17年3月30日，国河流第20号，河川局長通達.

<!-- -->

133. 国土交通省所管ダムにおける事前放流の実施について：平成17年3月30日，国河流第24号，河川環境課長通知.

134. 事前放流に伴う損失補塡制度について：平成18年12月4日，国河流第13号，河川環境課長通知.

135. 事前放流実施要領（案）:平成17年7月，国土交通省河川局河川環境課流水管理室.

136. 豪雨災害対策緊急アクションプラン：平成16年12月10日，国土交通省.

＜参考となる資料＞

137. 多目的ダムの建設－平成17年版，第7巻，第36章：（財）ダム技術センター，2005.

     1.  []{#_Toc198801769 .anchor}特別防災操作〈ただし書き操作〉

＜考え方＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------
  洪水の見通し及びダムの貯水状況を踏まえ、操作規則等のただし書きの規定によって本則操作よりも放流量を減少させることにより、下流域の洪水被害の軽減を図る場合がある。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  下流河川において、洪水被害が発生し、又は発生するおそれがある場合に、降雨状況等を勘案しながら、ダムの洪水調節容量をより効果的・効率的に活用し、下流域の洪水被害をより軽減できる洪水調節方法を予め検討することが望ましい。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1.  ダム操作に関する用語等の見直しについて（改訂）：平成23年4月1日，国河流第4号，流水管理室長通知

    1.  []{#_Toc198801770 .anchor}環境保全を目的とした弾力的管理

＜考え方＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 河川管理においては、河川が有する多様な生態系や変化に富んだ景観と調和した河川整備が求められており、ダム管理においても、下流河川の環境の保全を目的とした弾力的管理の取り組みが進められている。 |
|                                                                                                                                                                                              |
| ダムの弾力的管理は、洪水調節に支障を与えない範囲で、洪水調節容量の一部に流水を貯留し、これを適切に放流することにより、下流河川の環境の保全を図るものである。                                 |
|                                                                                                                                                                                              |
| なお、ダムの弾力的管理は、特定の利水のために行うものではないことに留意する必要がある。                                                                                                       |
+==============================================================================================================================================================================================+

＜必　須＞

+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| ダム管理者は、ダムの弾力的管理の目的や活用の方法等を踏まえ、堤体及び貯水池等の安全性並びに管理体制等を確認の上、弾力的管理が可能と判断されるダムについて、弾力的管理試験要領を作成し、弾力的管理試験を行うものとする。 |
|                                                                                                                                                                                                                        |
| また、ダム管理者は、弾力的管理試験結果を分析・評価し、洪水調節に対する安全性や弾力的管理の有効性等が確認された段階で、引き続きダムの弾力的管理を継続する場合は、操作規則等に弾力的管理に関する事項を定めるものとする。 |
+========================================================================================================================================================================================================================+

＜標　準＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 弾力的管理は、以下により行うことを基本とする。                                                                                                                                                                                         |
|                                                                                                                                                                                                                                        |
| (1)貯留の方法                                                                                                                                                                                                                          |
|                                                                                                                                                                                                                                        |
| > 平常時最高貯水位〈常時満水位〉又は洪水貯留準備水位〈洪水期制限水位〉を超える水位を活用水位として設定し、活用水位を超えない範囲で、流水を貯留する。                                                                                   |
|                                                                                                                                                                                                                                        |
| (2)事前放流（ここでは、弾力的管理のための放流をいう。）                                                                                                                                                                                |
|                                                                                                                                                                                                                                        |
| > 平常時最高貯水位又は洪水貯留準備水位と活用水位の間の容量に貯留した流水（以下「活用貯留水」という。）は、洪水が発生するおそれがある場合には、所定の時間までに、貯水位が平常時最高貯水位又は洪水貯留準備水位以下になるように放流する。 |
|                                                                                                                                                                                                                                        |
| (3)活用貯留水の活用目的                                                                                                                                                                                                                |
|                                                                                                                                                                                                                                        |
| > 活用貯留水は、河川環境の整備と保全等のために活用する。                                                                                                                                                                               |
| >                                                                                                                                                                                                                                      |
| > 活用においては、河川の特性に応じて、フラッシュ放流等放流方法の工夫により、その効果が発揮されるよう有効活用を図るものとする。                                                                                                         |
+========================================================================================================================================================================================================================================+

＜関連通知等＞

1.  ダムの弾力的管理について：平成16年6月10日，国河流第9号，河川環境課長通知

<!-- -->

138. ダムの弾力的管理試験の手引き（案）：平成15年4月，国土交通省河川局河川環境課

139. 弾力的管理試験要領（例）：平成18年2月，国土交通省河川局河川環境課流水管理室

＜参考となる資料＞

140. 多目的ダムの建設－平成17年版，第7巻，第36章：財団法人ダム技術センター，2005.

     1.  []{#_Toc192777869 .anchor}渇水対策

＜考え方＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 河川管理における渇水とは、降雨が少ないこと等により河川流量が減少し、河川からの取水を平常どおり継続するとダムの貯水が枯渇すると想定される場合等に、取水制限を行うなど、利水者が平常時と同様の取水を行うことができない状態をいう。 |
|                                                                                                                                                                                                                                  |
| 河川法第53条では、渇水により許可に係る水利使用が困難となった場合における水利使用者相互間の調整について、当事者が相互に他の水利使用を尊重し、協議によって解決すべき旨を定めている。                                               |
|                                                                                                                                                                                                                                  |
| この場合において、河川管理者は、協議が円滑に行われるようにするため、水利使用の調整に関して必要な情報の提供に努めることとされており、適正な流水管理が行われるよう、利水者及び関係機関と調整する必要がある。                       |
+==================================================================================================================================================================================================================================+

＜必　須＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  河川管理者は、水利使用の調整に必要な情報として、渇水時の気象、水象及び水質の把握、流況及び水質の予測、各利水者の取水実態及び排水実態の把握、渇水被害の把握、渇水調整案の作成等を行うものとする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 河川管理者は、渇水時における円滑な水利使用が促進されるよう、渇水が予想される河川について、利水者及び関係機関等からなる渇水調整協議会の設立指導及び渇水対策本部の設置等、渇水時における体制を整備することを基本とする。 |
|                                                                                                                                                                                                                        |
| また、渇水時において国民の節水意識の向上を図るため、渇水に係る情報を提供することを基本とする。                                                                                                                         |
+========================================================================================================================================================================================================================+

＜推　奨＞

  ----------------------------------------------------------------------------------------------------------------------------
  ダム管理者は、渇水被害の軽減を図るよう低水管理を適切に行うため、渇水時におけるダムの運用方針を予め検討することが望ましい。
  ----------------------------------------------------------------------------------------------------------------------------

  ----------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1.  渇水対策の推進について：昭和49年3月22日，建河政発第26号，河川局長通達

<!-- -->

141. 渇水状況報告について：昭和49年6月4日，建河計発第69号，河川計画課長通知

142. 渇水調整協議会に関する報告について：昭和49年6月27日，建河政発第55号，水政課長通知

     1.  []{#_Toc192777870 .anchor}管理情報の記録

＜考え方＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| ダムによる流水管理を行うために取得した水文・水理等の観測データやダム操作に関する記録は、長期にわたり継続的に蓄積するとともに、より一層の適切な流水管理を行うため、そのデータを活用することが重要である。 |
|                                                                                                                                                                                                          |
| また、これらのデータは、ダムの治水・利水上の役割を定量的かつ客観的に説明する際にも活用できる。                                                                                                           |
+==========================================================================================================================================================================================================+

＜必　須＞

  ----------------------------------------------------------------------------------------------------------------
  ダム管理者は、毎年のダム管理状況について、操作規則等に定められているダム管理年報としてとりまとめるものとする。
  ----------------------------------------------------------------------------------------------------------------

  ----------------------------------------------------------------------------------------------------------------

＜標　準＞

+------------------------------------------------------------------------------------------------------------------------------+
| ダム管理年報には、管理によって取得した水文・水理等に関する観測データ及びダムの管理状況に係る項目を記載することを基本とする。 |
|                                                                                                                              |
| ダムによる流水管理を行うために取得したデータを共有し、より効果的・効率的に流                                                 |
| 水管理を行うため、データの蓄積においては、電子化した上で系統的に整理・保存することを基本とする。                             |
+==============================================================================================================================+

＜関連通知等＞

1.  国土交通省所管の多目的ダムに係るダム管理年報について：平成14年2月19日，国河環第102号，河川局長通達.

<!-- -->

143. 国土交通省所管の多目的ダムに係るダム管理年報の作成要領について：平成14年2月19日，国河環第103号，河川環境課長通知.

     1.  []{#_Toc192777871 .anchor}管理情報の提供

＜考え方＞

+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| ダムの管理に関する情報は、ダムの機能及び役割について、住民や地方自治体の防災担当者、報道機関等に広く理解を得るとともに、住民の防災意識を高めるため、分かり易く提供することが重要である。 |
|                                                                                                                                                                                          |
| また、情報通信技術等を活用した多様な手段による情報提供を積極的に推進する必要がある。                                                                                                     |
+==========================================================================================================================================================================================+

＜標　準＞

+--------------------------------------------------------------------------------------------------------------------------------+
| ダムの流入量、放流量、貯水量、貯水率、流域平均雨量の速報値及びダム放流通知については、リアルタイムで提供することを基本とする。 |
|                                                                                                                                |
| また、ダムの洪水調節効果、ダム湖の利用状況、水源地域の状況について、積極的に情報提供することを基本とする。                     |
+================================================================================================================================+

＜推　奨＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 情報の提供においては、写真や図表、平易な言葉等を用いた分かり易い表現に努めるとともに、ダムの洪水調節効果のほか、渇水被害軽減効果等についても提供することが望ましい。 |
|                                                                                                                                                                      |
| インターネット等を活用するなど多様な手段により、普段から住民に対してダム管理情報を分かり易く提供し、地域の防災や河川利用に役立てることが望ましい。                   |
|                                                                                                                                                                      |
| 関係行政機関等と連携し、啓発・安全教育等に取り組むことにより、安全で適正な河川利用やダムの役割に対する住民の理解の向上に努める。                                     |
+======================================================================================================================================================================+

＜関連通知等＞

1.  洪水調節後のダム調節状況の公表について：平成10年11月16日，建河開発第101号，開発課長通知.

<!-- -->

144. 国土交通省所管ダムにおけるダム管理情報の一般への提供について：平成13年12月20日，国河環第86号，河川環境課長通知.

145. ダム放流警報施設、電光掲示板等河川管理施設の開放について：平成17年3月28日，国河流第19号・国河治第211号，河川環境課長・治水課長通知.

146. 洪水等に関する防災情報体系の見直しについて：平成18年10月1日，国河情第3号，河川局長通達.

147. ダム操作に関する用語等の見直しについて（改訂）：平成23年4月1日，国河流第4号，流水管理室長通知.

<!-- -->

4.  []{#_Toc192777872 .anchor}ダムの管理に係るフォローアップ

＜考え方＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| ダム等の管理に係るフォローアップ制度^1)^（以下「フォローアップ制度」という。）は、学識経験者により構成されるダム等管理フォローアップ委員会（以下「フォローアップ委員会」という。）の意見を踏まえ、管理段階における洪水調節実績、環境への影響等の調査（以下「フォローアップ調査」という。）及びその調査結果の分析・評価を一層客観的・科学的に行い、ダムの適切な管理に資するとともに、ダムの維持管理の効率性及びその実施過程の透明性の一層の向上を図ることを目的としている。 |
|                                                                                                                                                                                                                                                                                                                                                                                                                                                                            |
| フォローアップ調査及び分析・評価結果を踏まえ、必要な改善措置を講じることで、PDCAサイクルによる貯水池の維持管理及び流水管理を行うことが重要である（図4-1）。また、本サイクルは、ダム施設の維持管理におけるPDCAサイクル（図2-2）とともに、ダムの維持管理の両輪を成すものである。                                                                                                                                                                                             |
|                                                                                                                                                                                                                                                                                                                                                                                                                                                                            |
| ![](media/image18.png)                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
|                                                                                                                                                                                                                                                                                                                                                                                                                                                                            |
| 図4-1　PDCAサイクルのイメージ（貯水池の維持管理及び流水管理）                                                                                                                                                                                                                                                                                                                                                                                                              |
+============================================================================================================================================================================================================================================================================================================================================================================================================================================================================+

＜必　須＞

+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| ダム管理者は、一層適切なダムの管理を行うため、ダムの管理に係るフォローアップを行うことにより、ダム貯水池と維持管理と流水管理の状況を的確に把握し、事業を巡る社会情勢等の変化を踏まえ、洪水調節実績や環境への影響等を分析・評価し、必要に応じて、改善措置を講じるものとする。 |
|                                                                                                                                                                                                                                                                              |
| ダムの管理に係るフォローアップは、以下の要領に従って行うものとする。                                                                                                                                                                                                         |
|                                                                                                                                                                                                                                                                              |
| (1)実施時期                                                                                                                                                                                                                                                                  |
|                                                                                                                                                                                                                                                                              |
| > フォローアップ制度は、管理に移行するダムについては管理に移行する年度の前の年度から、試験湛水を行うダムについては試験湛水を開始する年度の前の年度から適用する。                                                                                                             |
|                                                                                                                                                                                                                                                                              |
| \(2\) モニタリング調査                                                                                                                                                                                                                                                       |
|                                                                                                                                                                                                                                                                              |
| > フォローアップ調査の前段階において、フォローアップ調査の内容よりも詳細に環境変化等を分析・評価するため、モニタリング調査を行う。                                                                                                                                           |
|                                                                                                                                                                                                                                                                              |
| (3)フォローアップ調査                                                                                                                                                                                                                                                        |
|                                                                                                                                                                                                                                                                              |
| > ① フォローアップ調査の実施                                                                                                                                                                                                                                                 |
| >                                                                                                                                                                                                                                                                            |
| > ダム等の管理に係るフォローアップ調査要領^2)^に基づき、対象ダムに係るフォローアップ調査を行う。                                                                                                                                                                             |
| >                                                                                                                                                                                                                                                                            |
| > ② 年次報告書及び定期報告書の作成                                                                                                                                                                                                                                           |
| >                                                                                                                                                                                                                                                                            |
| > フォローアップ制度に基づき、ダムごとに、毎年のフォローアップ調査結果を整理・分析した年次報告書を作成するとともに、原則として5年ごとに過去の調査結果の分析・評価を行い、定期報告書を作成する。                                                                              |
|                                                                                                                                                                                                                                                                              |
| (4)フォローアップ委員会                                                                                                                                                                                                                                                      |
|                                                                                                                                                                                                                                                                              |
| > フォローアップ調査の実施及び定期報告書にとりまとめた調査結果の分析・評価について、フォローアップ委員会の意見を聴くとともに、その意見を踏まえ、その後のフォローアップ調査や必要な改善を行う。                                                                               |
+==============================================================================================================================================================================================================================================================================+

＜標　準＞

+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| フォローアップ調査の標準的な項目は、以下のとおりとする。なお、個別ダムの状況を反映するため、独自の項目の追加やとりまとめ方法の工夫も必要であることから、フォローアップ委員会の意見を聴いて、フォローアップ調査を進めることを基本とする。 |
|                                                                                                                                                                                                                                          |
| > ① 洪水調節                                                                                                                                                                                                                             |
| >                                                                                                                                                                                                                                        |
| > ・ 想定氾濫区域の状況（位置及び面積、状況変化）                                                                                                                                                                                        |
| >                                                                                                                                                                                                                                        |
| > ・ 洪水調節の状況（洪水調節計画・実績、洪水時の対応状況）                                                                                                                                                                              |
| >                                                                                                                                                                                                                                        |
| > ・ 洪水調節の効果（流量低減効果、水位低減効果、労力（水防活動）の軽減効果）                                                                                                                                                            |
| >                                                                                                                                                                                                                                        |
| > ② 利水補給                                                                                                                                                                                                                             |
| >                                                                                                                                                                                                                                        |
| > ・ 利水補給計画（貯水池運用・用途別利水補給・下流基準点における補給量・弾力的管理試験の各計画）                                                                                                                                        |
| >                                                                                                                                                                                                                                        |
| > ・ 利水補給実績（利水補給の状況、発電実績、弾力的管理試験の実施状況）                                                                                                                                                                  |
| >                                                                                                                                                                                                                                        |
| > ・ 利水補給効果の評価（下流基準点における利水補給効果、人口及び生産性向上等による評価、発電効果）                                                                                                                                      |
| >                                                                                                                                                                                                                                        |
| > ③ 堆砂                                                                                                                                                                                                                                 |
| >                                                                                                                                                                                                                                        |
| > ・ 堆砂測量方法の整理                                                                                                                                                                                                                  |
| >                                                                                                                                                                                                                                        |
| > ・ 土砂流入等の状況                                                                                                                                                                                                                    |
| >                                                                                                                                                                                                                                        |
| > ・ 堆砂実績の整理                                                                                                                                                                                                                      |
| >                                                                                                                                                                                                                                        |
| > ・ 堆砂傾向及び堆砂対策の評価                                                                                                                                                                                                          |
| >                                                                                                                                                                                                                                        |
| > ④ 水質                                                                                                                                                                                                                                 |
| >                                                                                                                                                                                                                                        |
| > ・ 基本事項の整理（環境基準類型指定状況、定期水質調査地点と対象とする水質項目、水質調査実施状況）                                                                                                                                      |
| >                                                                                                                                                                                                                                        |
| > ・ 水質状況の整理（流入河川・下流河川・貯水池内水質の経年・経月変化、貯水池内水質の鉛直分布変化、植物プランクトンの生息状況変化、水質障害の発生状況）                                                                                  |
| >                                                                                                                                                                                                                                        |
| > ・ 水質の評価（流入・放流水質の比較、経年的水質変化、冷・温水現象、濁水長期化現象、富栄養化現象　等）                                                                                                                                  |
| >                                                                                                                                                                                                                                        |
| > ・ 水質保全設備の評価（水質保全設備の設置状況、水質保全設備計画と運用状況、水質保全設備の効果）                                                                                                                                        |
| >                                                                                                                                                                                                                                        |
| > ⑤ 生物                                                                                                                                                                                                                                 |
| >                                                                                                                                                                                                                                        |
| > ・ 貯水池及びその周辺の環境の把握（貯水池及び周辺の概況、河川水辺の国勢調査等における確認種の概況）                                                                                                                                    |
| >                                                                                                                                                                                                                                        |
| > ・ 生物の生息・生育状況の変化の検証（立地条件の整理、生物相・重要種・外来種の変化の把握）                                                                                                                                              |
| >                                                                                                                                                                                                                                        |
| > ・ 生物の生息・生育状況の変化の評価                                                                                                                                                                                                    |
| >                                                                                                                                                                                                                                        |
| > ・ 環境保全対策の効果の評価（実施状況、効果、課題）                                                                                                                                                                                    |
| >                                                                                                                                                                                                                                        |
| > ⑥ 水源地域動態                                                                                                                                                                                                                         |
| >                                                                                                                                                                                                                                        |
| > ・ 水源地域の概況（水源地域の概要、ダムの立地特性）                                                                                                                                                                                    |
| >                                                                                                                                                                                                                                        |
| > ・ ダム事業と地域社会情勢の変遷                                                                                                                                                                                                        |
| >                                                                                                                                                                                                                                        |
| > ・ ダムと地域の関わりに関する評価（地域におけるダムの位置づけ、地域とダム管理者の関わり）                                                                                                                                              |
| >                                                                                                                                                                                                                                        |
| > ・ ダム周辺の状況（ダム周辺整備状況、ダム周辺施設の利用状況、ダム及び周辺のイベント等の開催状況）                                                                                                                                      |
| >                                                                                                                                                                                                                                        |
| > ・ 河川水辺の国勢調査（ダム湖利用実態調査）結果                                                                                                                                                                                        |
+==========================================================================================================================================================================================================================================+

＜推　奨＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 貯水池の維持管理及び流水管理は、下流河川の整備状況、流域の総合的な土砂管理の考え方、流入河川の水質状況や下流河川で求められる水質、自治体等が定める環境保全に関する計画等を考慮して行うよう努める。 |
|                                                                                                                                                                                                    |
| また、フォローアップ調査においては、必要に応じて、以下の項目を分析・評価又は整理することが望ましい。                                                                                               |
|                                                                                                                                                                                                    |
| > ① 洪水調節                                                                                                                                                                                       |
| >                                                                                                                                                                                                  |
| > ・ 洪水調節の効果（氾濫被害低減効果、費用対効果、内水被害軽減効果、副次効果（流木流出軽減効果等））                                                                                              |
| >                                                                                                                                                                                                  |
| > ② 利水補給                                                                                                                                                                                       |
| >                                                                                                                                                                                                  |
| > ・ 利水補給効果の評価（渇水被害軽減効果、副次効果（流況改善効果等））                                                                                                                            |
| >                                                                                                                                                                                                  |
| > ③ 水質                                                                                                                                                                                           |
| >                                                                                                                                                                                                  |
| > ・ 水質状況の整理（流入負荷量の推定）                                                                                                                                                            |
| >                                                                                                                                                                                                  |
| > ・ 社会環境からみた汚濁源の整理（流域社会環境の整理、流域負荷量の変化）                                                                                                                          |
| >                                                                                                                                                                                                  |
| > ・ 水質の評価（ダム建設前後の経年的水質変化からみた貯水池の影響）                                                                                                                                |
+====================================================================================================================================================================================================+

＜関連通知等＞

1.  ダム等の管理に係るフォローアップ制度の実施について，平成14年7月24日，国河環第32号，河川局長通達．

<!-- -->

148. ダム等の管理に係るフォローアップ調査要領について，平成14年7月24日，国河環第33号，河川環境課長通知．

149. ダム等管理フォローアップ　年次報告書作成の手引き〔平成15年度版〕，平成15年7月，国土交通省河川局河川環境課．

150. ダム等管理フォローアップ　定期報告書作成の手引き〔平成26年度版〕，平成26年4月，国土交通省水管理・国土保全局河川環境課．
