**維持管理編（砂防編）**

**目 次**

[第1章 総説 [1](#_Toc161188013)](#_Toc161188013)

[第1節 目的 [1](#_Toc161188014)](#_Toc161188014)

[第2節 適用範囲 [1](#_Toc161188015)](#_Toc161188015)

[第3節 維持管理の基本方針 [2](#_Toc161188016)](#_Toc161188016)

[第2章 砂防関係施設の長寿命化計画 [3](#_Toc161188017)](#_Toc161188017)

[第1節 一般 [3](#_Toc161188018)](#_Toc161188018)

[第2節 計画に定める事項 [3](#_Toc161188019)](#_Toc161188019)

[第3章 砂防関係施設の点検及び健全度評価
[5](#_Toc161188020)](#_Toc161188020)

[第1節 砂防関係施設の点検 [5](#_Toc161188021)](#_Toc161188021)

[第2節 点検時期と点検頻度 [6](#_Toc161188022)](#_Toc161188022)

[第3節 基本データの収集 [6](#_Toc161188023)](#_Toc161188023)

[第4節 点検の方法 [7](#_Toc161188024)](#_Toc161188024)

[第5節 砂防関係施設の健全度評価 [7](#_Toc161188025)](#_Toc161188025)

[第6節 点検結果の保存 [8](#_Toc161188026)](#_Toc161188026)

[第4章 砂防設備及びその周辺の状態把握
[10](#_Toc161188027)](#_Toc161188027)

[第1節 一般 [10](#_Toc161188028)](#_Toc161188028)

[第2節 砂防設備及びその周辺の基本データ
[10](#_Toc161188029)](#_Toc161188029)

[第3節 砂防設備の健全度評価 [11](#_Toc161188030)](#_Toc161188030)

[第5章 地すべり防止施設及びその周辺の状態把握
[13](#_Toc161188031)](#_Toc161188031)

[第1節 一般 [13](#_Toc161188032)](#_Toc161188032)

[第2節 地すべり防止施設及びその周辺の基本データ
[14](#_Toc161188033)](#_Toc161188033)

[第3節 地すべり防止施設の健全度評価
[15](#_Toc161188034)](#_Toc161188034)

[第6章 急傾斜地崩壊防止施設及びその周辺の状態把握
[16](#_Toc161188035)](#_Toc161188035)

[第1節 一般 [16](#_Toc161188036)](#_Toc161188036)

[第2節 急傾斜地崩壊防止施設及びその周辺の基本データ
[16](#_Toc161188037)](#_Toc161188037)

[第3節 急傾斜地崩壊防止施設の健全度評価
[17](#_Toc161188038)](#_Toc161188038)

[第7章 雪崩対策施設及びその周辺の状態把握
[18](#_Toc161188039)](#_Toc161188039)

[第1節 一般 [18](#_Toc161188040)](#_Toc161188040)

[第2節 雪崩対策施設及びその周辺の基本データ
[18](#_Toc161188041)](#_Toc161188041)

[第3節 雪崩対策施設の健全度評価 [19](#_Toc161188042)](#_Toc161188042)

[第8章 砂防関係施設の維持・修繕等 [20](#_Toc161188043)](#_Toc161188043)

[第1節 一般 [20](#_Toc161188044)](#_Toc161188044)

[第2節 対策の優先順位の検討と年次計画（中期、短期）の策定
[21](#_Toc151357424)](#_Toc151357424)

[第9章 砂防設備の維持・修繕等 [22](#_Toc161188046)](#_Toc161188046)

[第1節 一般 [22](#_Toc161188047)](#_Toc161188047)

[第2節 砂防堰堤、床固工、遊砂地工、土石流堆積工
[22](#_Toc161188048)](#_Toc161188048)

[2．1 施設本体 [22](#_Toc161188049)](#_Toc161188049)

[2．2 除石 [22](#_Toc161188050)](#_Toc161188050)

[第3節 渓流保全工、護岸工 [23](#_Toc161188051)](#_Toc161188051)

[第4節 土石流導流工、土石流流向制御工
[23](#_Toc161188052)](#_Toc161188052)

[第5節 山腹工 [24](#_Toc161188053)](#_Toc161188053)

[第6節 管理用道路 [24](#_Toc161188054)](#_Toc161188054)

[第7節 魚道 [24](#_Toc161188055)](#_Toc161188055)

[第10章 地すべり防止施設の維持・修繕等
[25](#_Toc161188056)](#_Toc161188056)

[第1節 一般 [25](#_Toc161188057)](#_Toc161188057)

[第2節 地表水排除工 [25](#_Toc161188058)](#_Toc161188058)

[第3節 横ボーリング工 [25](#_Toc161188059)](#_Toc161188059)

[第4節 集水井工 [25](#_Toc161188060)](#_Toc161188060)

[第5節 排水トンネル工 [26](#_Toc161188061)](#_Toc161188061)

[第6節 排土工 [26](#_Toc161188062)](#_Toc161188062)

[第7節 押え盛土工 [26](#_Toc161188063)](#_Toc161188063)

[第8節 侵食防止工 [26](#_Toc161188064)](#_Toc161188064)

[第9節 杭工、シャフト工（深礎工） [27](#_Toc161188065)](#_Toc161188065)

[第10節 アンカー工 [27](#_Toc161188066)](#_Toc161188066)

[第11章 急傾斜地崩壊防止施設の維持・修繕等
[28](#_Toc161188067)](#_Toc161188067)

[第1節 一般 [28](#_Toc161188068)](#_Toc161188068)

[第2節 排水工 [28](#_Toc161188069)](#_Toc161188069)

[第3節 のり面保護工 [28](#_Toc161188070)](#_Toc161188070)

[第4節 押え盛土工 [28](#_Toc161188071)](#_Toc161188071)

[第5節 切土工 [29](#_Toc161188072)](#_Toc161188072)

[第6節 擁壁工 [29](#_Toc161188073)](#_Toc161188073)

[第7節 アンカー工、地山補強土工 [29](#_Toc161188074)](#_Toc161188074)

[第8節 杭工 [29](#_Toc161188075)](#_Toc161188075)

[第9節 待受工 [29](#_Toc161188076)](#_Toc161188076)

[第10節 落石対策工 [30](#_Toc161188077)](#_Toc161188077)

[第12章 雪崩対策施設の維持・修繕等 [30](#_Toc161188078)](#_Toc161188078)

[第1節 一般 [30](#_Toc161188079)](#_Toc161188079)

[第2節 予防工 [30](#_Toc161188080)](#_Toc161188080)

[第3節 防護工 [30](#_Toc161188081)](#_Toc161188081)

[第13章 観測機器、電気通信施設等の維持管理
[31](#_Toc161188082)](#_Toc161188082)

[第1節 一般 [31](#_Toc161188083)](#_Toc161188083)

令和6年６月　版

> 適用上の位置付け

河川砂防技術基準維持管理編（砂防編）は、基準の適用上の位置付けを明確にするために、下表に示すように適用上の位置付けを分類している。

+:-------:+:--------:+:---------------------------------------------------------------------------------------------------------------:+:--------------------------------------------:+
| 分　類             | 適用上の位置付け                                                                                                | 末尾の字句例                                 |
+---------+----------+-----------------------------------------------------------------------------------------------------------------+----------------------------------------------+
| 考え方  | 技術資料 | ●目的や概念、考え方を記述した事項。                                                                             | 「･･･ある。」「･･･いる。」                   |
|         |          |                                                                                                                 |                                              |
|         |          |                                                                                                                 | 「･･･なる。」「･･･れる。」                   |
+---------+----------+-----------------------------------------------------------------------------------------------------------------+----------------------------------------------+
| 必　須  | 技術基準 | ●法令による規定や技術的観点から実施すべきであることが明確であり遵守すべき事項。                                 | 「･･･なければならない。」「･･･ものとする。」 |
+---------+----------+-----------------------------------------------------------------------------------------------------------------+----------------------------------------------+
| 標　準  | 技術基準 | ●特段の事情がない限り記述に従い実施すべきだが、状況や条件によって一律に適用することはできない事項。             | 「･･･を標準とする。」                        |
|         |          |                                                                                                                 |                                              |
|         |          |                                                                                                                 | 「･･･を基本とする。」                        |
|         |          |                                                                                                                 |                                              |
|         |          |                                                                                                                 | 「･･･による。」                              |
+---------+----------+-----------------------------------------------------------------------------------------------------------------+----------------------------------------------+
| 推　奨  | 技術資料 | ●状況や条件によって実施することが良い事項。                                                                     | 「･･･望ましい。」                            |
|         |          |                                                                                                                 |                                              |
|         |          |                                                                                                                 | 「･･･推奨する。」                            |
|         |          |                                                                                                                 |                                              |
|         |          |                                                                                                                 | 「･･･努める。」                              |
|         |          |                                                                                                                 |                                              |
|         |          |                                                                                                                 | 「･･･必要に応じて･･･する。」                 |
+---------+----------+-----------------------------------------------------------------------------------------------------------------+----------------------------------------------+
| 例　示  | 技術資料 | ●適用条件や実施効果について確定している段階ではないが、状況や条件によっては導入することが可能な新技術等の例示。 | 「･･･などの手法（事例）がある。」            |
|         |          |                                                                                                                 |                                              |
|         |          | ●状況や条件によって限定的に実施できる技術等の例示。                                                             | 「･･･などの場合がある。」                    |
|         |          |                                                                                                                 |                                              |
|         |          | ●具体的に例示することにより、技術的な理解を助ける事項。                                                         | 「･･･などが考えられる。」                    |
|         |          |                                                                                                                 |                                              |
|         |          |                                                                                                                 | 「･･･の場合には･･･ことができる。」           |
|         |          |                                                                                                                 |                                              |
|         |          |                                                                                                                 | 「･･･例示する。」                            |
|         |          |                                                                                                                 |                                              |
|         |          |                                                                                                                 | 「例えば･･･。」                              |
|         |          |                                                                                                                 |                                              |
|         |          |                                                                                                                 | 「･･･事例もある。･･･もよい。」               |
+---------+----------+-----------------------------------------------------------------------------------------------------------------+----------------------------------------------+

  -----------------------------------------------------------------------
  関連通知等       関連する通知やそれを理解する上で参考となる資料
  ---------------- ------------------------------------------------------
  参考となる資料   例示等に示した手法・内容を理解する上で参考となる資料

  -----------------------------------------------------------------------

1.  []{#_Toc161188013 .anchor}総説

    1.  []{#_Toc161188014 .anchor}目的

＜考え方＞

我が国の国土は地形が急峻で脆弱な地質であるうえ、多雨豪雪地帯・火山地域を広く抱えており、多くの人々が扇状地や丘陵等に住んできていることから、生活の場とそれを支える地域において、古くから土砂災害を防止する施設が設置されてきた。江戸時代に造られた施設が地域住民によって見守られ、現在もなお土砂流出を防止する機能を果たしていることも少なくない。また、山腹工等は地域環境に溶け込み、土砂災害の防止のみならず自然環境の創造にも寄与している。これらの施設は植生と土木構造物を組み合わせたものであり、上中流域での土砂流出や下流域を含めた水系全体での土砂移動に対して、流域を面的に見つめてきた砂防の歴史がある。

近年、気候変動に伴い土砂災害が激甚化、頻発化しており、土石流や土砂・洪水氾濫等により甚大な被害が発生していることから、引き続き施設整備を実施していく必要がある。また、豪雨だけでなく火山噴火に伴う土砂流出、地震等による深層崩壊、地すべりに伴う天然ダムの発生といった大規模な土砂災害に対する危機管理対応が求められ、警戒避難体制の整備や情報伝達機器の開発等の事前準備、火山噴火に対する緊急減災対策、国土監視ネットワークの整備が進められている。

さらに、土砂災害防止法で定める土砂災害警戒区域等、急傾斜地の崩壊、土石流、地滑りにより被害を受けるおそれのある区域は全国で約69万箇所（令和5年12月末時点公表値）が指定されており、土砂災害を防止、軽減するために砂防関係施設の整備のみならず警戒避難体制の整備等が進められている。

このように、国土の管理という視点からも重要な土砂災害防止のため、水系全体における対策、大規模土砂災害に対する危機管理、土砂災害警戒区域等の警戒避難体制の整備によりハードとソフト一体となった対策を展開し、国民のいのちとくらしを守る砂防事業を推進している。

一方で国土を保全してきた砂防関係施設は、戦後の高度経済成長期に急速に整備されており、今後施設の老朽化が加速することが懸念されるが、将来にわたり施設が機能を発揮し続けるため、社会状況に応じて適切で効率的な維持管理を行っていく必要がある。

このためには、平常時から施設の状態を的確に把握し記録しておくことが重要であり、求められる機能及び性能を満たすべく対策を実施していくことが必要である。また、砂防関係施設の維持管理には、土砂移動現象や施設の機能、役割の重要度等を十分に理解する専門的な知識や効率的な点検が要求される。このため、携わる人材の技術力向上を図るなどの技術者の育成や施設を効率的に維持管理していくための技術開発が今後も重要となってくる。

河川砂防技術基準維持管理編（砂防編）（以下「本基準」という。）は、各々の砂防関係施設について機能及び性能を明示し、点検、評価方法等の維持管理を計画的に実施するために必要な事項を定め、もって適切な維持管理に資することを目的とする。

2.  []{#_Toc161188015 .anchor}適用範囲

＜考え方＞

本基準は、砂防関係施設の維持管理について適用する。なお、本基準に特に記載のない項目については、法令及び本基準の主旨に鑑み、適切に維持管理を行うことが必要である。

なお、本基準においては、砂防法第1条に規定する砂防設備、地すべり等防止法第2条第3項に規定する地すべり防止施設、急傾斜地の崩壊による災害の防止に関する法律第2条第2項に規定する急傾斜地崩壊防止施設及び地方財政法第16条に基づく雪崩対策施設を総称して、砂防関係施設と称している。

3.  []{#_Toc161188016 .anchor}維持管理の基本方針

＜考え方＞

既存の砂防関係施設の機能低下を防止し、所定の機能及び性能を長期にわたり維持・確保し続けるために長寿命化計画を策定し、着実に運用していくことは砂防関係施設の管理者等の重要な責務である。長寿命化計画の前提として、対象となる砂防関係施設について、その点検を通じて、機能及び性能の状況を的確に把握しておくことが重要であり、砂防関係施設の台帳を整理すると共に、経年的な点検の結果をもとにして評価を行い、維持、修繕、改築、更新といった対策を的確に実施していく必要がある。

また、砂防関係施設における予防保全型維持管理については、長期的な展望をもって長寿命化を推進し、維持、修繕、改築、更新等にかかるライフサイクルコストの縮減及び各年の修繕等に要する費用の平準化を図りつつ、確実に砂防関係施設の機能及び性能を維持・確保していく必要がある。このことから、予防保全を踏まえた砂防関係施設の長寿命化計画を策定し、戦略的な長寿命化対策を実施していくことが重要である。

予防保全型維持管理の実施に向けて、施設の劣化、損傷の速度や要因等のメカニズムを解明する必要があり、その分析の方法は引き続き検討をおこなっていく必要があることから、劣化、損傷等のデータを蓄積し、学識経験者等の助言を得られるよう体制の整備を行うことが重要である。また、砂防関係施設の維持管理にあたっては既存の工法のみならず、新技術・新工法等の積極的な活用を図るとともに、施設を効率的に維持管理していくための技術開発に取り組んでいく。

また、山腹斜面等山地部から渓流、河道に至る空間やこれらに隣接する周辺の自然空間等においては、それぞれの場所の条件に合った生息・生育環境、景観等が存在しており、砂防基本計画等の策定にあたっては、生物の生息・生育環境、景観、水質等の現状等を踏まえ、生物の生息・生育環境の連続性や良好な景観の確保等が図られるよう、施設配置、施設の形状、構造等について十分に配慮することとなっており、砂防関係施設の維持管理においても同様に配慮する必要がある。

＜関連通知等＞

> 1）砂防関係施設の長寿命化計画策定ガイドライン（案），令和4年3月，水管理・国土保全局砂防部保全課.
>
> 2）河川砂防技術基準　計画編，平成31年3月，国土交通省水管理・国土保全局，基本計画編第3章
> 砂防（土砂災害等対策）計画.

2.  []{#_Toc161188017 .anchor}砂防関係施設の長寿命化計画

    1.  []{#_Toc161188018 .anchor}一般

＜考え方＞

砂防関係施設の長寿命化計画は、施設の健全度を把握し、長期にわたりその機能及び性能を維持・確保することを目的として、維持、修繕、改築、更新の対策を計画的に実施するためのものである。

長寿命化計画の策定にあたっては、予防保全型維持管理の考え方を踏まえ、施設の健全度のみならず、周辺状況、保全対象の状況、災害履歴等の防災上の観点と、対策に係るコスト等を総合的に検討する必要がある。さらに、予防保全型維持管理によるライフサイクルコストの縮減及び各年の修繕等に要する費用の平準化を考慮した長寿命化計画とし、戦略的に長寿命化対策を実施していくことが重要である。

なお、現場条件等により活用がなじまない場合を除き、UAV点検等の新技術等の活用により、安全性、経済性、効率性の向上を図ることが重要である。

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------
  砂防関係施設について、流域等の単位（流域、都道府県、事務所等）ごとに計画対象区域を設定し、維持管理の具体的な内容を定めた長寿命化計画を策定することを基本とする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜関連通知等＞

1）砂防関係施設の長寿命化計画策定ガイドライン（案），令和4年3月，水管理・国土保全局砂防部保全課.

1.  []{#_Toc161188019 .anchor}計画に定める事項

＜標　準＞

+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| 長寿命化計画は、計画対象区域における砂防関係施設長寿命化計画策定方針、日常的な維持の方針、点検結果を踏まえた健全度の整理、修繕、改築、更新の優先度の検討と年次計画の策定、経過観察の方法（調査・観測の方法とその留意点）、対策（修繕、改築、更新）を定めることを基本とする。 |
|                                                                                                                                                                                                                                                                              |
| 年次計画は、第8章 砂防関係施設の維持・修繕等 第2節 対策の優先順位の検討と年次計画（中期、短期）の策定で定める通り、30～50年程度を計画対象期間とする中期年次計画と、10年程度を計画対象期間とする短期年次計画を作成することを基本とする。                                      |
+==============================================================================================================================================================================================================================================================================+

![](media/image1.png){width="3.1242935258092737in"
height="3.4295406824146983in"}

図 2-2-1　修繕、改築、更新の年次計画策定のフロー

＜関連通知等＞

> 1）砂防関係施設の長寿命化計画策定ガイドライン（案），令和4年3月，水管理・国土保全局砂防部保全課.

3.  []{#_Toc161188020 .anchor}砂防関係施設の点検及び健全度評価

    1.  []{#_Toc161188021 .anchor}砂防関係施設の点検

＜考え方＞

砂防関係施設の点検は、施設の機能の低下状況の把握や構造上の損傷の程度やその原因の特定を行うために実施するものであり、「定期点検」「臨時点検」「詳細点検」から構成される。砂防関係施設の機能の低下及び性能の劣化には施設周辺の状況が影響するため、施設のみならず施設の機能及び性能に影響を与える周辺状況についても点検の対象とする必要がある。

また、施設及びその周辺の状態把握にあたっては巡視等で得られる情報も参考とする。

表 3-1-1　点検の内容

+---------------+--------------------------------------------------------------------------------------------------------------------+
| 点検の種類    | > 内　　　容                                                                                                       |
+:=============:+====================================================================================================================+
| 定期点検      | 計画的に定めた一定の時期や期間毎に、砂防関係施設の機能の低下や性能の劣化等の状況を把握するために行う調査のこと。   |
|               |                                                                                                                    |
|               | 目視点検若しくはUAV点検を基本とする。                                                                              |
+---------------+--------------------------------------------------------------------------------------------------------------------+
| 臨時点検      | 豪雨や地震発生時等の不定期に、砂防関係施設の機能の低下や性能の劣化等の状況を把握するために行う緊急的な調査のこと。 |
|               |                                                                                                                    |
|               | 目視点検若しくはUAV点検を基本とする。                                                                              |
+---------------+--------------------------------------------------------------------------------------------------------------------+
| 詳細点検      | 定期点検（巡視等を含む)、臨時点検では得られない、より詳細な情報を得るために実施する調査のこと。                    |
+---------------+--------------------------------------------------------------------------------------------------------------------+

＜標　準＞

+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| > 砂防関係施設の機能及び性能の状況を把握するため、施設の点検計画を策定し、これに基づき点検を実施することを基本とする。点検計画は対象施設、点検の方法、点検の実施体制、点検の実施時期等について定めることを基本とする。 |
+========================================================================================================================================================================================================================+

＜推　奨＞

豪雨や地震発生時等の臨時点検を迅速かつ的確に実施するため、点検範囲の決定方法の設定、現地における効率的な活動への備え、事前の体制構築等に留意した点検計画を策定することが望ましい。

点検計画の策定に際しては、安全面、効率面の観点から、UAV点検の特徴を踏まえた上で、必要に応じてUAVの活用を検討することが望ましい。

一般の利用が想定される砂防関係施設は、定期点検等に加えて安全性の確保の観点からも点検を実施することが望ましい。

また、砂防関係施設の異常等を発見した場合、速やかに施設管理者に通報してもらえるよう、地域住民等との協働体制を構築しておくことが望ましい。

＜関連通知等＞

> 1）地すべり防止技術指針及び同解説，平成20年4月，国土交通省砂防部，独立行政法人土木研究所.
>
> 2）砂防関係施設の長寿命化計画策定ガイドライン（案），令和4年3月，水管理・国土保全局砂防部保全課.

3）砂防関係施設点検要領（案），令和4年3月，国土交通省砂防部保全課.

> （最新版）砂防関係施設点検要領（案），令和7 年4
> 月，国土交通省砂防部保全課.

＜参考となる資料＞

UAVを活用した施設点検計画については、下記の資料が参考となる。

> 1）UAVの自律飛行による砂防関係施設の自動巡視・点検に関する手引き，令和5年5月，国土交通省近畿地方整備局大規模土砂災害対策技術センター.
>
> 2）UAV
> による砂防関係施設点検要領（案），令和2年3月，国土交通省北陸地方整備局河川部.
>
> 3）砂防設備点検における UAV
> 活用の手引き（案），令和2年3月，国土交通省北陸地方整備局河川部.

地すべり防止施設（地表水・地下水排除施設）の点検方法等については、下記の資料が参考となる。

> 4）野呂智之,丸山清輝,中村
> 明,ハスバートル：地すべり防止施設の維持管理に関する実態と施設点検方法の検討－地表水・地下水排除施設－，土木研究所資料，第4201号，2011.

2.  []{#_Toc161188022 .anchor}点検時期と点検頻度

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  定期点検は、各施設の健全度、施設の周辺状況、保全対象との位置関係、施設の重要度等に応じて適切な時期、頻度を設定し実施することを基本とする。また、臨時点検は、豪雨や地震等の事象の発生位置や規模、各施設の状況に応じて必要な点検対象を設定し、できるだけ早い時期に実施することを基本とする。詳細点検は、定期点検や臨時点検ではその異常の程度や原因の把握が困難と判断される時に実施することを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

定期点検実施時期の間隔は、最長10年以下とすることとし、健全度評価により「経過観察」、「要対策」と判定された施設については、5年以下を原則として設定することが望ましい。

流水の影響が常に及ぶ施設等の点検については、実施頻度を高くするなど適切に対応することが望ましい。

＜例　示＞

台風等により記録的な大雨が観測され、土砂災害が多発した際に、砂防堰堤等の土砂・流木の捕捉状況を確認するために砂防関係施設の臨時点検を行っている事例がある。

＜関連通知等＞

1.  砂防関係施設点検要領（案），令和4年3月，国土交通省砂防部保全課.

> （最新版）砂防関係施設点検要領（案），令和7 年4
> 月，国土交通省砂防部保全課.

2.  []{#_Toc161188023 .anchor}基本データの収集

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------------------
  点検にあたっては、施設の位置、構造、周辺状況等の情報が必要となることから、施設に関する台帳等の基本データを収集し携行することを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------------------

  --------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

点検時に収集した施設に関する台帳等の基本データは、データベース化を行うなど次回点検時に活用が容易となるよう蓄積していくことが望ましい。

3.  []{#_Toc161188024 .anchor}点検の方法

＜考え方＞

点検を効果的かつ効率的に実施するために、施設の種類や構造等を踏まえ、あらかじめ点検方法や実施体制等を定めておく。

＜標　準＞

+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| > 定期点検、臨時点検は、目視点検若しくはUAV点検により行い、施設の外観及び施設周辺の状況を把握し、点検個票に記録することを基本とする。また、詳細点検は、施設の状態に適応した計測、打音、観察、その他適切な方法により行うことを基本とする。 |
| >                                                                                                                                                                                                                                         |
| > 砂防関係施設は急峻な箇所や高所等に設置されている場合が多いため、点検における安全を考慮して複数名による実施体制とし、点検に必要な知識・技術を有した技術者が実施することを基本とする。                                                    |
+===========================================================================================================================================================================================================================================+

＜推　奨＞

確実性、客観性を確保するため、点検対象施設に応じた点検項目や留意点等を事前にとりまとめておくことが望ましい。

また、施設の点検にあたっては前回点検結果を携行し、変状等の進行度に関する情報等の蓄積に努める。

安全性、効率性及び現場条件等からUAV点検を実施する場合は、施設・部位・着目点等によって適するものや適さないものがあることを踏まえて、必要に応じて目視点検との併用や点検時期を考慮することを検討する。

また、UAV点検にあたっては現場条件等を考慮の上、飛行ルートや撮影ポイント等の見直しを適宜実施し、常に効率性の向上を図ることが望ましい。

＜例　示＞

UAVや砂防関係施設情報が登録されたタブレット等の携帯型端末等を活用し、より効率的な点検の実施や関係者間での情報が共有できるよう、アプリケーション（SMART-SABO等）を使用した事例がある。

＜関連通知等＞

1.  砂防関係施設点検要領（案），令和4年3月，国土交通省砂防部保全課.

> （最新版）砂防関係施設点検要領（案），令和7 年4
> 月，国土交通省砂防部保全課.

2.  []{#_Toc161188025 .anchor}砂防関係施設の健全度評価

＜考え方＞

砂防関係施設の機能の低下や性能の劣化の程度を把握し、対策の必要性や対策方針を判断するために健全度評価を行う。健全度は部位毎の変状を調査した上で、施設の周辺状況を踏まえ、施設全体について総合的に評価する。

＜標　準＞

+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| > 点検により砂防関係施設の状態を把握し、健全度を評価することを基本とする。                                                                                                                                                                                                      |
|                                                                                                                                                                                                                                                                                 |
| 健全度の評価は基本データ等に基づき実施し、「対策不要」「経過観察」「要対策」の3段階程度で評価することを標準とする。                                                                                                                                                             |
|                                                                                                                                                                                                                                                                                 |
| 表 3-5-1　砂防関係施設の健全度評価事例                                                                                                                                                                                                                                          |
|                                                                                                                                                                                                                                                                                 |
| +--------------+--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+ |
| | 健全度       | 損傷度の程度                                                                                                                                                                                                                                                 | |
| +:============:+==============================================================================================================================================================================================================================================================+ |
| | 対策不要     | > 当該施設に損傷等は発生していないか、軽微な損傷が発生しているものの、損傷等に伴う当該施設の機能の低下及び性能の劣化が認められず、対策の必要がない状態                                                                                                       | |
| +--------------+--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+ |
| | 経過観察     | > 当該施設に損傷等が発生しているが、問題となる機能の低下及び性能の劣化が生じていない。現状では早急に対策を講じる必要はないが、将来対策を必要とするおそれがあるので、定期点検や臨時点検等により、経過を観察する、または予防保全の観点より対策が必要である状態 | |
| +--------------+--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+ |
| | 要対策       | > 当該施設に損傷等が発生しており、損傷等に伴い、当該施設の機能低下が生じている、あるいは当該施設の性能上の安定性や強度の低下が懸念される状態                                                                                                                 | |
| +--------------+--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+ |
+=================================================================================================================================================================================================================================================================================+

＜推　奨＞

健全度評価にあたっては、部位ごと等の変状レベルを評価した上で、流域や当該地すべり地等の施設周辺の状況も踏まえ、施設あるいは施設群全体について総合的に評価することに努める。なお、点検による部位別変状レベルは、施設全体の健全度を評価する上で重要な資料であり、その結果を基に、豊富な知識と経験を持つ技術者によって、健全度を評価することが望ましい。

　現行基準より以前の基準に基づいて施工された砂防関係施設については、設置時点の基準で要求した機能及び性能と現行基準で要求する機能及び性能との間に変化がある可能性があることから、健全度の評価においてもその差異を考慮することが望ましい。

＜関連通知等＞

> 1）砂防関係施設の長寿命化計画策定ガイドライン（案），令和4年3月，水管理・国土保全局砂防部保全課.

2）砂防関係施設点検要領（案），令和4年3月，国土交通省砂防部保全課.

> （最新版）砂防関係施設点検要領（案），令和7 年4
> 月，国土交通省砂防部保全課.

3.  []{#_Toc161188026 .anchor}点検結果の保存

＜考え方＞

点検結果は、維持管理の基礎資料として最も重要な資料である。施設の健全度評価や対策を適切に実施するために経年的に点検結果を蓄積する。

＜標　準＞

  --------------------------------------------------------------------------------------------------------------------------------
  施設の点検データについては、現状の把握や将来の劣化の予測に役立つ貴重な情報であるため、継続的に記録・保存することを基本とする。
  --------------------------------------------------------------------------------------------------------------------------------

  --------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

点検項目等は標準化するとともに、点検結果は、台帳等の基本データと併せて情報の集約化及び電子化によるデータベース化を行うことが望ましい。データベースには、施設管理台帳のほか、設計及び施工に関する図書、点検及び健全度評価に関する記録、維持・修繕履歴に関する記録、施設周辺の状態に関する調査・観測記録等を必要に応じて入力する。データベースに入力するデータは、高度なデータ活用が容易となるよう機械判読可能なデータ形式とすることが望ましい。また、維持管理の効率化・高度化のため、BIM/CIMモデルを活用することが望ましい。

データベースシステムを活用することで、健全度の劣化予測等を効率的に行うことができ、また、施設情報の継続的な蓄積によって段階的に劣化予測の精度を向上させることが期待できる。さらに、劣化予測等の結果を用いて最適な施設点検、維持、修繕、改築、更新の計画の策定を支援することができるシステムへと発展させていくことが望ましい。

＜関連通知等＞

> 1）砂防関係施設の長寿命化計画策定ガイドライン（案），令和4年3月，水管理・国土保全局砂防部保全課.
>
> 2）BIM/CIM活用ガイドライン（案）第3編砂防及び地すべり対策編,令和4年3月，国土交通省.

4.  []{#_Toc161188027 .anchor}砂防設備及びその周辺の状態把握

    1.  []{#_Toc161188028 .anchor}一般

＜考え方＞

砂防設備は、土砂・流木生産抑制、土砂流送制御、土石流・流木発生抑制、土石流・流木捕捉・堆積・制御等の機能を有している。また、地形、地質、流出土砂形態等を踏まえた予想される荷重を考慮し、安全な構造・規格が付与されている。これらの機能及び性能を確保するためには、定期的・継続的に状態把握を行うことが重要である。

なお、砂防設備の損傷の原因には、常時流水や土砂流出状況、周辺斜面の変状等が関係するため、砂防設備周辺の山腹や渓流の状況も把握しておくことが重要である。また、点検及び安全管理のために設置した階段や立入防止柵等についても機能が維持されているかを把握する。

＜標　準＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| > 砂防設備及びその周辺の状態は、点検等により把握し、その結果を適切に記録することを基本とする。                                                                                                                                                                                                                                               |
| >                                                                                                                                                                                                                                                                                                                                            |
| > 砂防設備（砂防堰堤、床固工、遊砂地工、渓流保全工、護岸工、土石流堆積工、土石流導流工、土石流流向制御工、山腹工、管理用道路、魚道等）及びそれらに影響を与える周辺地域を対象とし、洗掘、ひび割れ、破損、欠損、変形、摩耗、漏水、腐食、流域の荒廃状況、土砂の流出状況、常時流水の有無、砂防設備の堆砂状況等について把握することを基本とする。 |
+==============================================================================================================================================================================================================================================================================================================================================+

＜推　奨＞

土砂の生産や流出が顕著な渓流では、縦横断測量、地形測量、空中写真測量、航空レーザ測量、UAVレーザ測量、河床材料調査等により、土砂の生産や流出の規模、河床変動や地形変化の状況等を把握することが望ましい。また、自然環境・景観の保全と創造及び渓流の利用に配慮した砂防設備は魚道等の機能や、一般利用に対する安全確保等に着目して状態を把握することが望ましい。

また、砂防設備のBIM/CIMモデルの活用にあたっては、必要な属性情報を施工段階のBIM/CIMモデルで付与しておくか、維持管理段階への移行時に、工事の電子成果品等からBIM/CIMモデルに付与することが望ましい。

＜関連通知等＞

1.  砂防関係施設点検要領（案），令和4年3月，国土交通省砂防部保全課.

> （最新版）砂防関係施設点検要領（案），令和7 年4
> 月，国土交通省砂防部保全課.
>
> 2）BIM/CIM活用ガイドライン（案）第3編砂防及び地すべり対策編，令和4年3月，国土交通省.

1.  []{#_Toc161188029 .anchor}砂防設備及びその周辺の基本データ

＜考え方＞

砂防設備及びその周辺の基本データは、施設の状態に加え、周辺状況、保全対象の状況、災害履歴等の情報も含めて可能な限り収集する。収集した基本データは適切に蓄積するとともに、必要な場合に速やかに活用できるよう整理し保存しておく。

＜必　須＞

  --------------------------------------------------------------------------------------------------------------------------------------------------------------
  砂防設備の位置、種類、構造及び数量等を記載した砂防設備台帳と、砂防指定地の指定年月日、区域、面積、概況等を記載した砂防指定地台帳を整備し保存するものとする。
  --------------------------------------------------------------------------------------------------------------------------------------------------------------

  --------------------------------------------------------------------------------------------------------------------------------------------------------------

＜標　準＞

  ----------------------------------------------------------------------------------------------------
  必須で示した資料に加え、第3章
  砂防関係施設の点検及び健全度評価に基づき実施した点検結果は、適切に整理し保存することを基本とする。
  ----------------------------------------------------------------------------------------------------

  ----------------------------------------------------------------------------------------------------

＜推　奨＞

必須、標準で示した資料に加え、完成図書、「土砂災害警戒区域等における土砂災害防止対策の推進に関する法律」に基づく基礎調査（以下「基礎調査」という。）の結果、巡視記録、修繕・改築工事の設計図面、水文・水理データ、地質・土質データ、地形測量、河床材料、土砂生産・流出の状況、環境調査等の資料収集に努める。

＜関連通知等＞

1）水文観測業務規程，平成29年3月31日，国水情第44号，国土交通事務次官通達.

> 2）水文観測業務規程細則，平成29年3月31日，国水情第45号，国土交通省水管理・国土保全局長通達.
>
> 3）河川砂防技術基準　調査編，令和5年5月，国土交通省水管理・国土保全局，第17章
> 砂防調査.

4）砂防関係施設点検要領（案），令和4年3月，国土交通省砂防部保全課.

> （最新版）砂防関係施設点検要領（案），令和7 年4
> 月，国土交通省砂防部保全課.

2.  []{#_Toc161188030 .anchor}砂防設備の健全度評価

＜考え方＞

砂防設備の健全度は、部位毎の機能の低下や性能の劣化の程度を把握した上で、流域や施設の周辺状況を踏まえ、総合的に評価する必要がある。

また、例えば砂防堰堤の場合、透過型・不透過型・部分透過型の形式、重力式やアーチ式等の構造、コンクリート・石材・鋼材・ソイルセメント等の材料など多岐にわたるため、機能の低下や性能の劣化が生じる部位や形態は様々であると考えられる。よって、砂防設備の形式、構造、材料特性等に応じて、適切に健全度評価を行う。

＜標　準＞

+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| > 点検により砂防設備の状態及び施設の周辺状況を把握し、施設の健全度を評価することを基本とする。土砂処理計画や土石流・流木処理計画上、除石（流木の除去を含む）が必要となる砂防設備は、土砂と流木の堆積状況についても評価を行うことを基本とする。 |
+================================================================================================================================================================================================================================================+

＜推　奨＞

砂防設備の損傷は、常時流水がある渓流に設置された砂防設備において、より多く認められる傾向があることから、そのような砂防設備の健全度評価にあたっては、特に留意することが望ましい。また、本体基礎部の洗掘は堤体の安定性に直接影響を与えることがあるため、必要に応じて洗掘の進行度と原因を把握する。

なお、健全度評価は砂防設備に関する知識と経験を有している技術者が必要に応じて実施する。

＜例　示＞

砂防堰堤の水抜きが自然に閉塞している場合、水抜きからの突発的な土砂等の流出が発生する場合がある。水抜きの閉塞状況、堰堤上流側の堆砂、湛水状況を把握することが考えられる。石積や粗石コンクリートを用いた砂防堰堤のような外観状況と内部の劣化が一致しているとは限らない施設については、目視に加え、非破壊調査を用いて健全度を評価することが考えられる。

＜関連通知等＞

> 1）国土交通省国土技術政策総合研究所土砂災害研究部砂防研究室：砂防基本計画策定指針（土石流・流木対策編）解説,国土技術政策総合研究所資料,第904号,2016.
>
> 2）河川砂防技術基準　計画編，平成31年3月，国土交通省水管理・国土保全局，基本計画編第3章
> 砂防（土砂災害等対策）計画.
>
> 3）砂防関係施設の長寿命化計画策定ガイドライン（案），令和4年3月，水管理・国土保全局砂防部保全課.

4）砂防関係施設点検要領（案），令和4年3月，国土交通省砂防部保全課.

> （最新版）砂防関係施設点検要領（案），令和7 年4
> 月，国土交通省砂防部保全課.

＜参考となる資料＞

砂防設備の損傷事例については、下記の資料が参考となる。

> 1）石田孝司，山田 拓，三浦光太郎，平田
> 遼，武澤永純，石井靖雄：1934～2018年度に発生した砂防堰堤の破損等事例調査，土木研究所資料，第4425号，2022.

鋼材を用いた砂防関係施設の健全度評価については、下記の資料が参考となる。

> 2）一般財団法人砂防フロンティア整備推進機構：主に鋼材を用いた砂防施設の維持管理マニュアル，2019.
>
> 非破壊調査による砂防堰堤の健全度評価については、下記の資料が参考となる。
>
> 3）山中僚：非破壊調査による既設砂防堰堤の健全度評価，砂防学会誌，No.63，Vol.5，pp.73-77，2011.

5.  []{#_Toc161188031 .anchor}地すべり防止施設及びその周辺の状態把握

    1.  []{#_Toc161188032 .anchor}一般

＜考え方＞

地すべり防止工事実施後の地すべり斜面であっても、施設の機能の低下や複雑な発生・運動機構等により地すべり運動が活発化することがある。よって、点検等により地すべり斜面の状況について把握することが重要である。地すべり斜面の状況は、目視による点検のほか、必要に応じて観測機器により把握する。

また、地すべり防止施設は、地すべり抑制及び抑止の機能を有しており、地形、地質、地すべり地域の状況等に応じて地すべりの滑動力及びその他の予想される荷重を考慮し、安全な構造・規格が付与されている。これらの機能及び性能を確保するためには、定期的・継続的に状態把握を行うことが重要である。

地すべり防止施設には、本体が地中に設置された不可視の部位もあるため、必要に応じて不可視部の変状の計測を行う。また、点検及び安全管理のために設置した階段や立入防止柵等についても機能が維持されているかを把握する。

＜標　準＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| > 地すべり斜面の状況及び地すべり防止施設の状態は、点検等により把握し、その結果を適切に記録することを基本とする。                                                                                                                                                                                                                                                                                                                                                     |
| >                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| > 地すべり斜面は、地すべりによる変状や湧水状況の変化等について把握するものとし、目視による点検のほか、必要に応じて地表面の移動、地中の移動を観測機器により把握することを基本とする。また、地すべり防止施設（抑制工（地表水排除工、地下水排除工（横ボーリング工、集水井工、排水トンネル工）、排土工、押え盛土工、侵食防止工）、抑止工（杭工、シャフト工（深礎工）、アンカー工））は、劣化、腐食、損傷、変形、集水管・排水管の閉塞等について把握することを基本とする。 |
+======================================================================================================================================================================================================================================================================================================================================================================================================================================================================+

＜推　奨＞

地すべり斜面の状況及び地すべり防止施設の状態把握のために必要となる観測機器の配置や観測頻度は、地すべりの素因・誘因、移動特性等の対象とする地すべりの特徴のほか、施設の種類、保全対象の位置等を踏まえて設定することが望ましい。また、観測結果の解析や評価方法は事前に検討しておくことが重要であり、解析方法に応じて状態把握の方法も変更が必要となる場合があるので留意するように努める。

地すべり斜面の状況及び地すべり防止施設の状態把握を効率化・高度化するため、地すべり機構解析のBIM/CIMモデル、地すべり防止施設のBIM/CIMモデル及びそれらを統合した統合モデルを活用することが望ましい。なお、地すべり防止施設のBIM/CIMモデルの活用にあたっては、必要な属性情報を施工段階のBIM/CIMモデルで付与しておくか、維持管理段階への移行時に、工事の電子成果品等からBIM/CIMモデルに付与することが望ましい。

＜関連通知等＞

> 1）地すべり防止技術指針及び同解説，平成20年4月，国土交通省砂防部，独立行政法人土木研究所.
>
> 2）河川砂防技術基準　調査編，令和5年5月，国土交通省水管理・国土保全局，第18章
> 地すべり調査.

3）砂防関係施設点検要領（案），令和4年3月，国土交通省砂防部保全課.

> （最新版）砂防関係施設点検要領（案），令和7 年4
> 月，国土交通省砂防部保全課.
>
> 4）BIM/CIM活用ガイドライン（案）第3編砂防及び地すべり対策編,令和4年3月，国土交通省.

＜参考となる資料＞

集水井工の点検手法については、下記の資料が参考となる。

> 1）国立研究開発法人土木研究所,株式会社建設技術研究所,株式会社興和,国土防災技術株式会社,日鉄建材株式会社,株式会社キタック：地表からの効率的な集水井内点検手法共同研究報告書，共同研究報告書,第508号,2019.

　グラウンドアンカーの維持管理については、下記の資料が参考となる。

> 2）国立研究開発法人土木研究所，一般社団法人日本アンカー協会，国立大学法人三重大学，株式会社高速道路総合技術研究所：グラウンドアンカー維持管理マニュアル，技報堂出版，2020.
>
> 　地すべり防止施設（地表水・地下水排除施設）の点検方法等については、下記の資料が参考となる。
>
> 3）野呂智之,丸山清輝,中村
> 明,ハスバートル：地すべり防止施設の維持管理に関する実態と施設点検方法の検討－地表水・地下水排除施設－，土木研究所資料，第4201号，2011.

1.  []{#_Toc161188033 .anchor}地すべり防止施設及びその周辺の基本データ

＜考え方＞

地すべり斜面及び地すべり防止施設の基本データは、これらの状態のみでなく、周辺状況、保全対象の状況、過去の地すべり履歴等の情報も含めて可能な限り収集する。収集した基本データは適切に蓄積するとともに、必要な場合に速やかに活用できるよう整理し保存しておく。

＜必　須＞

+----------------------------------------------------------------------------------------------------------------------------------------------+
| > 地すべり防止施設の位置、種類等、地すべり防止区域の指定年月日、区域、面積、概況等を記載した地すべり防止区域台帳を整備し保存するものとする。 |
+==============================================================================================================================================+

＜標　準＞

  ----------------------------------------------------------------------------------------------------
  必須で示した資料に加え、第3章
  砂防関係施設の点検及び健全度評価に基づき実施した点検結果は、適切に整理し保存することを基本とする。
  ----------------------------------------------------------------------------------------------------

  ----------------------------------------------------------------------------------------------------

＜推　奨＞

標準で示した資料に加え、地すべり斜面の状況及び地すべり防止施設に関する基本データとして、完成図書、基礎調査、巡視記録、修繕・改築工事の設計図面、水文・水理データ、地質・土質データ、地形測量、地表水・地下水調査、環境調査等の資料収集に努める。

＜関連通知等＞

> 1）斜面カルテの作成について，平成10年3月27日，建河傾第14号，砂防部傾斜地保全課長.

2）水文観測業務規程，平成29年3月31日，国水情第44号，国土交通事務次官通達.

> 3）水文観測業務規程細則，平成29年3月31日，国水情第45号，国土交通省水管理・国土保全局長通達.
>
> 4）地すべり防止技術指針及び同解説，平成20年4月，国土交通省砂防部，独立行政法人土木研究所.
>
> 5）河川砂防技術基準　調査編，令和5年5月，国土交通省水管理・国土保全局，第18章
> 地すべり調査.

6）砂防関係施設点検要領（案），令和4年3月，国土交通省砂防部保全課.

> （最新版）砂防関係施設点検要領（案），令和7 年4
> 月，国土交通省砂防部保全課.

2.  []{#_Toc161188034 .anchor}地すべり防止施設の健全度評価

＜考え方＞

地すべり防止施設の健全度は、部位毎の機能の低下や性能の劣化の程度を把握した上で、地すべり斜面の状況等を踏まえ、総合的に評価する。特に、杭工、シャフト工（深礎工）、アンカー工等の抑止工の健全度は、その本体が地下に設置された不可視の構造物であるため、地表の目視できる部位のみならず、地すべり斜面の状況を把握して評価する。また、地すべり防止工事実施後の調査において、地すべり斜面に地すべりによる変状が認められる場合は、追加対策が必要となることが考えられるため留意する。

＜標　準＞

  ----------------------------------------------------------------------------------------------------------
  点検により地すべり斜面の状況及び地すべり防止施設の状態を把握し、施設の健全度を評価することを基本とする。
  ----------------------------------------------------------------------------------------------------------

  ----------------------------------------------------------------------------------------------------------

＜推　奨＞

健全度評価では、杭の変形やアンカー荷重の変動、地表面の移動量、地中変位量、地下水位、地下水排水量等の観測結果の解析を行うことが望ましい。

具体的には、地下水位と地下水排水量の関係、地下水排除工の機能の低下による地下水位の上昇状況と変位量の大きさの関係、アンカー工に作用する荷重や杭工の変形と地表面の移動量、地中変位量の関係等を分析し、施設若しくは施設群の機能の低下が地すべりの安定性に及ぼす影響を総合的に評価することが望ましい。

また、健全度評価は地すべり防止施設に関する知識と経験を有している技術者が必要に応じて実施する。

＜関連通知等＞

> 1）地すべり防止技術指針及び同解説，平成20年4月，国土交通省砂防部，独立行政法人土木研究所.
>
> 2）河川砂防技術基準　調査編，令和5年5月，国土交通省水管理・国土保全局，第18章
> 地すべり調査.
>
> 3）砂防関係施設の長寿命化計画策定ガイドライン（案），令和4年3月，水管理・国土保全局砂防部保全課.

4）砂防関係施設点検要領（案），令和4年3月，国土交通省砂防部保全課.

> （最新版）砂防関係施設点検要領（案），令和7 年4
> 月，国土交通省砂防部保全課.

＜参考となる資料＞

グラウンドアンカーの維持管理については、下記の資料が参考となる。

> 1）国立研究開発法人土木研究所，一般社団法人日本アンカー協会，国立大学法人三重大学，株式会社高速道路総合技術研究所：グラウンドアンカー維持管理マニュアル，技報堂出版，2020.

6.  []{#_Toc161188035 .anchor}急傾斜地崩壊防止施設及びその周辺の状態把握

    1.  []{#_Toc161188036 .anchor}一般

＜考え方＞

急傾斜地崩壊防止施設は、急傾斜地の崩壊の抑制、抑止等の機能を有している。また、地形、地質、斜面の状況等を踏まえた予想される崩壊の規模、現象等を考慮し、安全な構造・規格が付与されている。これらの機能及び性能を確保するためには定期的・継続的に状態把握を行うことが重要である。なお、急傾斜地崩壊防止施設には本体が地中に設置された不可視の部位もあること、施設周辺の斜面や土地利用状況の変化は、施設の機能に影響を与えることから、施設のみならず周辺状況も把握する。また、点検及び安全管理のために設置した階段や立入防止柵等についても機能が維持されているかを把握する。

＜標　準＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| > 急傾斜地崩壊防止施設及びその周辺の状態は、点検等により把握し、その結果を適切に記録することを基本とする。                                                                                                                                                                                         |
| >                                                                                                                                                                                                                                                                                                  |
| > 急傾斜地崩壊防止施設（排水工（地表水排除工、地下水排除工）、のり面保護工、押え盛土工、切土工、擁壁工、アンカー工、地山補強土工、杭工、待受工、落石対策工等）及びそれらに影響を与える周辺地域を対象とし、損傷、変形、崩壊、ひび割れ、侵食、腐食、空洞化、湧水等について把握することを基本とする。 |
+====================================================================================================================================================================================================================================================================================================+

＜推　奨＞

斜面崩壊の主な要因として降雨、湧水等があるため、排水工の斜面への雨水の流入防止状況や斜面外への排水状況等について把握することが望ましい。

また、急傾斜地崩壊防止施設は人家に近接した斜面に設置する場合が多いことから、斜面の風化状況等に着目し、施設により不可視となる斜面は、打音検査等により背面の空洞状況を把握することが望ましい。

なお、施設の状態把握にあたっては、導入した植生の生育状況についても把握することが望ましい。

＜関連通知等＞

> 1）砂防関係施設の長寿命化計画策定ガイドライン（案），令和4年3月，水管理・国土保全局砂防部保全課.

2）砂防関係施設点検要領（案），令和4年3月，国土交通省砂防部保全課.

> （最新版）砂防関係施設点検要領（案），令和7 年4
> 月，国土交通省砂防部保全課.

1.  []{#_Toc161188037
    .anchor}急傾斜地崩壊防止施設及びその周辺の基本データ

＜考え方＞

急傾斜地崩壊防止施設及びその周辺の基本データは、施設の状態のみでなく、周辺状況、保全対象の状況、災害履歴等の情報も含めて可能な限り収集する。収集した基本データは適切に蓄積するとともに、必要な場合に速やかに活用できるよう整理し保存しておく。

＜標　準＞

+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| > 急傾斜地崩壊防止施設の位置、種類等、急傾斜地崩壊防止区域の指定年月日、区域、面積、概況等を記載した急傾斜地崩壊危険区域台帳を整備し保存することを基本とする。また、急傾斜地崩壊防止施設及びその周辺の状態は、点検等により把握し、その結果を適切に保存することを基本とする。 |
+==============================================================================================================================================================================================================================================================================+

＜推　奨＞

標準で示した資料に加え、急傾斜地崩壊防止施設に関する基本データとして、点検結果のほか、完成図書、基礎調査、巡視記録、修繕・改築工事の設計図面、水文・水理データ、地質・土質データ、地形測量、植生状況、環境調査等の資料収集に努める。

＜関連通知等＞

> 1）急傾斜地崩壊危険区域台帳の整備について，昭和54年6月4日，建設省河傾発第22号，傾斜地保全課長.
>
> 2）斜面カルテの作成について，平成10年3月27日，建河傾第14号，砂防部傾斜地保全課長.
>
> 3）河川砂防技術基準　調査編，令和5年5月，国土交通省水管理・国土保全局，第19章
> 急傾斜地調査.

4）砂防関係施設点検要領（案），令和4年3月，国土交通省砂防部保全課.

> （最新版）砂防関係施設点検要領（案），令和7 年4
> 月，国土交通省砂防部保全課.

2.  []{#_Toc161188038 .anchor}急傾斜地崩壊防止施設の健全度評価

＜考え方＞

急傾斜地崩壊防止施設の健全度は、部位毎の機能の低下や性能の劣化の程度を把握した上で、施設周辺の斜面状況を踏まえ、急傾斜地崩壊防止施設全体について総合的に評価する。

特に、杭工、アンカー工等の抑止工の健全度は、その本体が地下に設置された不可視の構造物であるため、地表の目視できる部位のみならず、斜面全体の状況を把握して評価する。

＜標　準＞

+------------------------------------------------------------------------------------------------------------+
| > 点検により急傾斜地崩壊防止施設の状態及び斜面全体の状況を把握し、施設の健全度を評価することを基本とする。 |
+============================================================================================================+

＜推　奨＞

健全度評価は急傾斜地崩壊防止施設に関する知識と経験を有している技術者が必要に応じて実施する。

＜関連通知等＞

> 1）砂防関係施設の長寿命化計画策定ガイドライン（案），令和4年3月，水管理・国土保全局砂防部保全課.

2）砂防関係施設点検要領（案），令和4年3月，国土交通省砂防部保全課.

> （最新版）砂防関係施設点検要領（案），令和7 年4
> 月，国土交通省砂防部保全課.

7.  []{#_Toc161188039 .anchor}雪崩対策施設及びその周辺の状態把握

    1.  []{#_Toc161188040 .anchor}一般

＜考え方＞

雪崩対策施設は、雪崩発生の未然防止と発生した雪崩から保全対象を防護する機能を有している。また、地形、地質、積雪の状況等を踏まえた予想される荷重を考慮し、安全な構造・規格が付与されている。これらの機能及び性能を確保するためには定期的・継続的に状態把握を行うことが重要である。

なお、施設周辺の斜面や土地利用状況の変化は、施設の機能に影響を与えるため、施設のみならず周辺状況も把握する。また、点検及び安全管理のために設置した階段や立入防止柵等についても機能が維持されているかを把握する。

＜標　準＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------+
| > 雪崩対策施設及びその周辺の状態は、点検等により把握し、その結果を適切に記録することを基本とする。                                                       |
| >                                                                                                                                                        |
| > 雪崩対策施設（予防工、防護工等）及びそれらに影響を与える周辺地域を対象とし、損傷、変形、崩壊、ひび割れ、侵食、腐食等について把握することを基本とする。 |
+==========================================================================================================================================================+

＜関連通知等＞

> 1）砂防関係施設の長寿命化計画策定ガイドライン（案），令和4年3月，水管理・国土保局砂防部保全課.

2）砂防関係施設点検要領（案），令和4年3月，国土交通省砂防部保全課.

> （最新版）砂防関係施設点検要領（案），令和7 年4
> 月，国土交通省砂防部保全課.

1.  []{#_Toc161188041 .anchor}雪崩対策施設及びその周辺の基本データ

＜考え方＞

雪崩対策施設及びその周辺の基本データは、施設の状態のみでなく、周辺状況、保全対象の状況、災害履歴等の情報も含めて可能な限り収集する。収集した基本データは適切に蓄積するとともに、必要な場合に速やかに活用できるよう整理し保存しておく。

＜標　準＞

  --------------------------------------------------------------------------------------------------
  雪崩対策施設及びその周辺の状態は、点検等により把握し、その結果を適切に保存することを基本とする。
  --------------------------------------------------------------------------------------------------

  --------------------------------------------------------------------------------------------------

＜推　奨＞

雪崩対策施設に関する基本データとして、点検結果のほか、完成図書、雪崩危険箇所調査、巡視記録、修繕・改築工事の設計図面、地質・土質データ、地形測量、植生状況、積雪観測記録及び雪崩実態調査、環境調査等の資料収集に努める。

＜関連通知等＞

> 1）雪崩危険箇所の再点検について，平成12年2月16日，建河傾第4号，砂防部傾斜地保全課長.
>
> 2）河川砂防技術基準　調査編，令和5年5月，国土交通省水管理・国土保全局，第20章
> 雪崩調査.

3）砂防関係施設点検要領（案），令和4年3月，国土交通省砂防部保全課.

> （最新版）砂防関係施設点検要領（案），令和7 年4
> 月，国土交通省砂防部保全課.

2.  []{#_Toc161188042 .anchor}雪崩対策施設の健全度評価

＜考え方＞

雪崩対策施設の健全度は、部位毎の機能の低下や性能の劣化の程度を把握した上で、施設周辺の斜面状況等を踏まえて、雪崩対策施設全体について総合的に評価する必要がある。

＜標　準＞

+------------------------------------------------------------------------------------------------------+
| > 点検により雪崩対策施設の状態及び周辺の斜面状況等を把握し、施設の健全度を評価することを基本とする。 |
+======================================================================================================+

＜関連通知等＞

> 1）砂防関係施設の長寿命化計画策定ガイドライン（案），令和4年3月，水管理・国土保全局砂防部保全課.

2）砂防関係施設点検要領（案），令和4年3月，国土交通省砂防部保全課.

> （最新版）砂防関係施設点検要領（案），令和7 年4
> 月，国土交通省砂防部保全課.

8.  []{#_Toc161188043 .anchor}砂防関係施設の維持・修繕等

    1.  []{#_Toc161188044 .anchor}一般

＜考え方＞

砂防関係施設の機能の低下や性能の劣化に対して適切な維持・修繕等を行うことにより、施設の機能及び性能を維持・確保する。維持・修繕等には①軽微な作業により機能及び性能を確保する「維持」、②機能や性能を確保、回復するために、損傷又は劣化前の状況に補修する「修繕」、③機能や性能を確保、回復するとともに、さらにその向上を図る「改築」、④既存施設と同等の機能及び性能を有する施設を、既存施設の代替として新たに整備する「更新」がある。維持・修繕等にあたっては、施設の健全度のみならず、周辺状況、保全対象の状況、災害履歴等の防災上の観点と、維持・修繕等に係るコスト等を総合的に検討し、計画的に実施する。

＜標　準＞

+--------------------------------------------------------------------------------------------------------------------------------------------------------+
| > 砂防関係施設について長期にわたり所要の機能及び性能を確保するために、長寿命化計画の年次計画に基づき施設の維持・修繕等を計画的に行うことを基本とする。 |
+========================================================================================================================================================+

＜推　奨＞

予防保全としての修繕等の実施にあたっては、今後の維持管理面における有効性等を考慮し、耐久性の高い部材への変更や機能向上等を図ることが望ましい。改築や更新において機能向上を図る場合、計画編
施設配置等計画編 第3章 砂防等施設配置計画 第3-1章
総説に記載の通り、機能向上に加え、良好な自然環境の復元、砂防関係施設の長寿命化への配慮等の観点からも施設配置計画について検討し、適宜、長寿命化計画の年次計画へ反映することが望ましい。また、修繕において耐久性の高い部材への変更を行う場合においても、第1章
総説 第3章
維持管理の基本方針に記載の通り、生物の生息・成育環境の連続性や良好な景観の確保等が図られるよう配慮することが望ましい。

砂防関係施設及びその周辺の日常的な維持作業を、地域住民等と行政が連携して実施することにより、維持管理の効率化のみならず、砂防関係施設の機能に対する理解や、地域防災力の強化につながることから、積極的に取り組むことが望ましい。

＜例　示＞

地域住民が、施設管理者と施設周辺の清掃活動等に関する覚書を結んで、日常的な維持作業を実施している事例や、古くから地域住民が自主的に歴史的な砂防関係施設周辺の樹木の管理や清掃等を行ってきたことから、現在では施設管理者と協定書を結んで、協働で維持管理に取り組んでいる事例等がある。また、施設管理者と維持作業を行っている地域住民が、協同で地域の小学生等を対象に土砂災害の歴史や砂防関係施設の役割について現地で説明するなど、砂防関係施設の重要性に関する啓発活動を行っている事例もある。

＜関連通知等＞

> 1）砂防関係施設の長寿命化計画策定ガイドライン（案），令和4年3月，水管理・国土保全局砂防部保全課.

＜参考となる資料＞

歴史的砂防施設の保存と活用については、下記の資料が参考となる。

> 1）歴史的砂防施設の保存活用ガイドライン，平成15年5月，国土交通省河川局砂防部保全課,文化庁文化財部建造物課.
>
> 2）財団法人砂防フロンティア整備推進機構：歴史的砂防施設の保存・活用マニュアル（案），2006.

1.  []{#_Toc151357424
    .anchor}対策の優先順位の検討と年次計画（中期、短期）の策定

＜考え方＞

砂防関係施設の健全度、流域の荒廃状況、保全対象との位置関係、施設の重要度、過去の災害履歴、修繕、改築、更新の工法及びライフサイクルコストの縮減等を考慮のうえ、対策の優先順位を検討し、年次計画を策定する。

＜標　準＞

+----------------------------------------------------------------------------------------------------------------------------------+
| > 年次計画は、30～50年程度を計画対象期間とする中期年次計画と10年程度を計画対象期間とする短期年次計画を策定することを基本とする。 |
+==================================================================================================================================+

＜推　奨＞

中期年次計画は、修繕、改築等の必要となる施設を抽出し、概略的な箇所数や事業計画を記載すること、短期年次計画は、修繕、改築等を実施する具体的な箇所を抽出するとともに、財政状況等も踏まえつつ、詳細な事業計画を記載することが望ましい。また、点検結果、対策状況、予防保全にかかる取り組み事例の蓄積状況等を踏まえて、年次計画は必要に応じて計画を見直すようにし、新技術等の活用等の短期的な数値目標及びそのコスト縮減効果を示すことが望ましい。

対策の検討時において、施設の損傷等が機能及び性能に影響を及ぼしていない場合であっても、劣化予測の結果等より、劣化の進行が早く、早期に施設の機能及び性能に影響が生じるおそれがある場合は、予防保全としての修繕等の対策を講じることが望ましい。

＜例　示＞

長寿命化計画における砂防関係施設の劣化予測は、対象施設の健全度評価と経過年数との関係により把握するが、手法としては回帰分析手法、確率論的手法等がある。

＜関連通知等＞

> 1）砂防関係施設の長寿命化計画策定ガイドライン（案），令和4年3月，水管理・国土保全局砂防部保全課.

＜参考となる資料＞

地すべり防止施設の劣化予測については、下記資料のような事例紹介がある。

> 1）ライフサイクルコスト削減検討のための研究会：地すべり防止施設におけるライフサイクルコスト削減に関する研究報告書（令和6年3月），https://www.jasdim.or.jp/common/files/lifecyclecost.pdf，参照2024-05-14

砂防関係施設の新技術活用によるコスト縮減効果については、下記資料のような事例紹介がある。

> 2）国土交通省砂防部：砂防関係施設における老朽化対策等の実施事例集（令和6年3月），https://www.mlit.go.jp/river/shishin_guideline/sabo/sabo_roukyuukataisakutou_zisshizireisyuu.pdf，参照2024-05-14

9.  []{#_Toc161188046 .anchor}砂防設備の維持・修繕等

    1.  []{#_Toc161188047 .anchor}一般

＜考え方＞

砂防設備の維持・修繕等の検討にあたっては、砂防設備の構造、損傷の状態・原因、健全度評価に基づく劣化予測の結果、施設が存する周辺環境（流域特性、保全対象との位置関係等）及びライフサイクルコストの縮減等を踏まえて、対策案の経済性、施工性、環境への影響等を含め、総合的に検討する。

＜標　準＞

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  砂防設備が長期にわたりその機能及び性能が維持・確保されるよう、長寿命化計画の年次計画に基づき施設の維持・修繕等を計画的に行うことを基本とする。なお、維持・修繕等の実施にあたっては周辺環境に配慮することを基本とする。
  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

＜推　奨＞

既設砂防堰堤等の機能向上と合わせて維持・修繕等を効率的に実施することが望ましい。その際、適宜各施設管理者が定める長寿命化計画を見直し、年次計画（中期、短期）に対策箇所を位置づけることが望ましい。

＜関連通知等＞

> 1）国土交通省国土技術政策総合研究所土砂災害研究部砂防研究室：砂防基本計画策定指針（土石流・流木対策編）解説,国土技術政策総合研究所資料,第904号,2016.
>
> 2）国土交通省国土技術政策総合研究所土砂災害研究部砂防研究室：土石流・流木対策設計技術指針解説,国土技術政策総合研究所資料,第905号,2016.
>
> 3）砂防関係施設の長寿命化計画策定ガイドライン（案），令和4年3月，水管理・国土保全局砂防部保全課.

1.  []{#_Toc161188048 .anchor}砂防堰堤、床固工、遊砂地工、土石流堆積工

    1.  []{#_Toc161188049 .anchor}施設本体

＜標　準＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| > 砂防堰堤、床固工、遊砂地工、土石流堆積工は、渓床・渓岸における土砂・流木生産抑制、土砂流送制御、土石流・流木発生抑制、土石流・流木の捕捉・堆積の機能を有しており、これらの機能が発揮されるとともに、必要な性能が確保されるよう維持・修繕等を行うことを基本とする。 |
+======================================================================================================================================================================================================================================================================+

＜推　奨＞

本体基礎の洗掘は、施設の安定性に直接影響を与えること、土砂や石礫の流下量が多い渓流では、摩耗による損傷や欠損等の進行度が早いことなどに留意し、施設の機能が低下する前に速やかに維持・修繕等を行うことが望ましい。

2.  []{#_Toc161188050 .anchor}除石

＜標　準＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| > 定期点検及び臨時点検において、砂防設備の堆砂状況の把握を行い、施設の機能を確保するために必要な場合は除石（流木の除去を含む）を行うことを基本とする。また、土砂処理計画や土石流・流木処理計画上、除石（流木の除去を含む）が必要となる場合は、あらかじめ土砂の搬出方法等を検討しておくことを基本とする。 |
| >                                                                                                                                                                                                                                                                                                        |
| > なお、土石流発生等の出水により、土石流対策の砂防設備が捕捉した土砂及び流木について、次期出水にそなえて除石が必要となる場合は、緊急的に除石を行う。                                                                                                                                                     |
+==========================================================================================================================================================================================================================================================================================================+

＜推　奨＞

計画上、除石（流木の除去を含む）を必要としている堰堤等については、必要な場合に速やかに除石ができるようにあらかじめ除石方法等を検討しておくとともに、除石計画策定も含め、その検討結果を適切に整理することが望ましい。

＜関連通知等＞

> 1）国土交通省国土技術政策総合研究所土砂災害研究部砂防研究室：砂防基本計画策定指針（土石流・流木対策編）解説，国土技術政策総合研究所資料，第904号，2016.
>
> 2）国土交通省国土技術政策総合研究所土砂災害研究部砂防研究室：土石流・流木対策設計技術指針解説，国土技術政策総合研究所資料，第905号，2016.

＜参考となる資料＞

除石（流木の除去を含む）により発生した土砂・流木の有効活用については、下記の資料が参考となる。

> 1）一般財団法人砂防・地すべり技術センター：砂防ソイルセメント施工便覧
> 平成28年版，2016.
>
> 2）河川内樹木及びダム流木のバイオマス利用の手引，令和4年3月，環境省大臣官房総合政策課環境研究技術室，国土交通省水管理・国土保全局河川環境課.

2.  []{#_Toc161188051 .anchor}渓流保全工、護岸工

＜標　準＞

+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| > 渓流保全工、護岸工は、渓床・渓岸における土砂・流木生産抑制、渓流における土砂流送制御機能、土石流・流木発生抑制機能を有している。施工後の渓流の状況を踏まえて、これらの機能が発揮されるとともに、必要な性能が確保されるよう維持・修繕等を行うことを基本とする。 |
+==================================================================================================================================================================================================================================================================+

＜推　奨＞

渓流保全工に土砂が堆積し、又は樹木等が生育することにより施設の機能が低下する前に、周辺の環境等に配慮し、また、渓岸の侵食・崩壊を防止する目的で水制工が設置されている場合は、その機能が発揮されるとともに、必要な性能が確保されるよう維持・修繕等を行うことが望ましい。

3.  []{#_Toc161188052 .anchor}土石流導流工、土石流流向制御工

＜標　準＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| > 土石流導流工、土石流流向制御工は、土石流・流木の制御機能を有する。施工後の渓流の状況を踏まえて、これらの機能が発揮されるとともに、必要な性能が確保されるよう維持・修繕等を行うことを基本とする。 |
+====================================================================================================================================================================================================+

4.  []{#_Toc161188053 .anchor}山腹工

＜標　準＞

+--------------------------------------------------------------------------------------------------------------------------+
| > 山腹工の有する土砂・流木生産抑制、土石流・流木発生抑制機能が継続的に確保されるよう維持・修繕等を行うことを基本とする。 |
+==========================================================================================================================+

＜推　奨＞

山腹工による植生回復状況をモニタリングし、目標とする林相への達成状況を確認するとともに、目標とする林相へ遷移していない場合は、補植、林相転換、下草刈り、マルチング等の必要な対策を行うことが望ましい。

＜参考となる資料＞

山腹工の整備目標の考え方等については、下記の資料が参考となる。

> 1）国土交通省国土技術政策総合研究所危機管理技術研究センター砂防研究室，河川局砂防部保全課：これからの山腹保全工の整備に向けて－里地里山の山腹斜面に植生を回復させ、その機能を維持・増進していくためのポイント集－，国土技術政策総合研究所資料,第544号,2009.

5.  []{#_Toc161188054 .anchor}管理用道路

＜標　準＞

+--------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| > 管理用道路は、施設の巡視、点検、除石等の維持が適切に実施できるよう、雨水や流水による路面・のり面の洗掘、侵食、崩壊に留意して維持・修繕等を行うことを基本とする。 |
+====================================================================================================================================================================+

6.  []{#_Toc161188055 .anchor}魚道

＜標　準＞

+----------------------------------------------------------------------------------------------------------+
| > 魚類等の遡上・降下環境を確保するために、土砂の除去や施設の補修等の維持・修繕等を行うことを基本とする。 |
+==========================================================================================================+

＜推　奨＞

魚道は、内部の土砂堆積、流木等による閉塞、流砂等による損傷、上下流の河床変化により魚道に十分な水量が流下しない等、機能の低下が生じる場合があるため、施設の周辺状況も把握し維持・修繕等を行うことが望ましい。

10. []{#_Toc161188056 .anchor}地すべり防止施設の維持・修繕等

    1.  []{#_Toc161188057 .anchor}一般

＜考え方＞

地すべり防止施設の維持・修繕等の検討にあたっては、地すべり防止施設の構造、損傷の状態・原因、健全度評価に基づく劣化予測の結果、施設が存する周辺環境（地すべりの状況、保全対象との位置関係等）及びライフサイクルコストの縮減等を踏まえて、対策案の経済性、施工性、環境への影響等を含め、総合的に検討する。

＜標　準＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| > 地すべり防止施設が長期にわたりその機能及び性能が維持・確保されるよう、長寿命化計画の年次計画に基づき施設の維持・修繕等を計画的に行うことを基本とする。なお、維持・修繕等の実施にあたっては周辺環境に配慮することを基本とする。 |
+==================================================================================================================================================================================================================================+

＜関連通知等＞

> 1）地すべり防止技術指針及び同解説，平成20年4月，国土交通省砂防部，独立行政法人土木研究所.
>
> 2）砂防関係施設の長寿命化計画策定ガイドライン（案），令和4年3月，水管理・国土保全局砂防部保全課.

1.  []{#_Toc161188058 .anchor}地表水排除工

＜標　準＞

+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| > 地表水排除工は、降雨や地表水の浸透や湧水、沼、水路等からの再浸透を防止し、地下水位の上昇を抑制する機能を有しており、これらの機能が発揮されるとともに、必要な性能が確保されるよう維持・修繕等を行うことを基本とする。 |
+========================================================================================================================================================================================================================+

＜推　奨＞

水路や集水桝への土砂等の堆積、施設周辺地盤の変動に伴う変形、水路周辺の洗掘等に留意し、地表水排除工の機能が低下する前に維持・修繕等を行うことが望ましい。

2.  []{#_Toc161188059 .anchor}横ボーリング工

＜標　準＞

+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| > 横ボーリング工は、地表水排除工では排除できない浅層地下水、すべり面付近に分布する深層地下水、断層や破砕帯に沿った地下水を排除し、地下水位の上昇を抑制する機能を有しており、これらの機能が発揮されるとともに、必要な性能が確保されるよう維持・修繕等を行うことを基本とする。 |
+==============================================================================================================================================================================================================================================================================+

＜推　奨＞

集水管の閉塞、孔口保護工の変形、集水桝への土砂堆積、施設周辺地盤の変動に伴う変形等に留意し、横ボーリング工の機能が低下する前に維持・修繕等を行うことが望ましい。また、流末からの地下水の排出状況等により機能低下が懸念される場合は、詳細な調査を行って地すべりに対する影響を分析し、必要に応じて維持・修繕等を実施する。

3.  []{#_Toc161188060 .anchor}集水井工

＜標　準＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| > 集水井工は、地表からの横ボーリング工では排除できない深層地下水を排除し、地下水位の上昇を抑制する機能を有しており、これらの機能が発揮されるとともに、必要な性能が確保されるよう維持・修繕等を行うことを基本とする。 |
+======================================================================================================================================================================================================================+

＜推　奨＞

集水管・排水管の閉塞、安全施設（立入防止柵、天蓋、階段）の損傷、施設周辺地盤の変動に伴う変形等に留意し、集水井工の機能が低下する前に維持・修繕等を行うことが望ましい。

4.  []{#_Toc161188061 .anchor}排水トンネル工

＜標　準＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| > 排水トンネル工は、横ボーリング工や集水井工では排除が困難な深層地下水を排除し、地下水位の上昇を抑制する機能を有しており、これらの機能が発揮されるとともに、必要な性能が確保されるよう維持・修繕等を行うことを基本とする。 |
+============================================================================================================================================================================================================================+

＜推　奨＞

集水管の閉塞、排水路の閉塞、安全施設（立入防止柵等）の損傷、施設周辺地盤の変動に伴う損傷等に留意し、排水トンネル工の機能が低下する前に維持・修繕等を行うことが望ましい。

5.  []{#_Toc161188062 .anchor}排土工

＜標　準＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| > 排土工は、地すべり頭部の土塊を排除し、地すべりの滑動力を低減させるために実施されるものであり、この低減効果が継続的に確保されていることを確認し、必要に応じて維持・修繕等を行うことを基本とする。 |
+====================================================================================================================================================================================================+

＜推　奨＞

排土工ののり面等の変形、雨水の排水や浸透に注意するとともに，排土の上部斜面における新たな地すべり発生の兆候の有無等を把握し、維持・修繕等を行うことが望ましい。

6.  []{#_Toc161188063 .anchor}押え盛土工

＜標　準＞

+--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| > 押え盛土工は、地すべり末端部に比較的透水性の良い材料を盛土し、地すべりの滑動力に抵抗する力を増加させるためのものであり、この機能及び性能が継続的に確保されるよう維持・修繕等を行うことを基本とする。 |
+========================================================================================================================================================================================================+

＜推　奨＞

押え盛土工ののり面の侵食や盛土材料の透水性の低下による地下水位の上昇等に留意し、維持・修繕等を行うことが望ましい。

7.  []{#_Toc161188064 .anchor}侵食防止工

＜標　準＞

+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| > 侵食防止工は、流水による河床低下や渓岸侵食が地すべりの安定を損なわせ、地すべり発生の誘因となる場合に、渓岸の保護と地すべり末端部の安定を図る機能を有しており、これらの機能が発揮されるとともに、必要な性能が確保されるよう維持・修繕等を行うことを基本とする。 |
+==================================================================================================================================================================================================================================================================+

8.  []{#_Toc161188065 .anchor}杭工、シャフト工（深礎工）

＜標　準＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| > 杭工、シャフト工（深礎工）は、すべり面を貫いて不動地盤まで設置することにより、地すべりの滑動力に対する抵抗力を付加し安定を図る機能を有しており、これらの機能が発揮されるとともに、必要な性能が確保されるよう維持・修繕等を行うことを基本とする。 |
+====================================================================================================================================================================================================================================================+

9.  []{#_Toc161188066 .anchor}アンカー工

＜標　準＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| > アンカー工は、すべり面を貫いて不動地盤に鋼材等を挿入し定着させ、鋼材の引張強さを利用して地すべりの安定を図る機能を有しており、これらの機能が発揮されるとともに、必要な性能が確保されるよう維持・修繕等を行うことを基本とする。 |
+==================================================================================================================================================================================================================================+

＜参考となる資料＞

グラウンドアンカーの維持管理については、下記の資料が参考となる。

> 1）国立研究開発法人土木研究所，一般社団法人日本アンカー協会，国立大学法人三重大学，株式会社高速道路総合技術研究所：グラウンドアンカー維持管理マニュアル，技報堂出版，2020.

11. []{#_Toc161188067 .anchor}急傾斜地崩壊防止施設の維持・修繕等

    1.  []{#_Toc161188068 .anchor}一般

＜考え方＞

急傾斜地崩壊防止施設の維持・修繕等の検討にあたっては、急傾斜地崩壊防止施設の構造、損傷の状態・原因、健全度評価に基づく劣化予測の結果、施設が存する周辺環境（斜面の特性、保全対象との位置関係等）及びライフサイクルコストの縮減等を踏まえて、対策案の経済性、施工性、環境への影響等を含め、総合的に検討する。

＜標　準＞

+--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| > 急傾斜地崩壊防止施設が長期にわたりその機能及び性能が維持・確保されるよう、長寿命化計画の年次計画に基づき施設の維持・修繕等を計画的に行うことを基本とする。なお、維持・修繕等の実施にあたっては周辺環境に配慮することを基本とする。 |
+======================================================================================================================================================================================================================================+

＜関連通知等＞

> 1）砂防関係施設の長寿命化計画策定ガイドライン（案），令和4年3月，水管理・国土保全局砂防部保全課.

1.  []{#_Toc161188069 .anchor}排水工

＜標　準＞

+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| > 排水工（地表水排除工、地下水排除工）は、急傾斜地の安定を損なう可能性のある地表水・地下水を速やかに集めて急傾斜地外へ排水し、斜面あるいは急傾斜地崩壊防止施設背面に水が浸透、停滞することを防止する機能を有しており、これらの機能が発揮されるとともに、必要な性能が確保されるよう維持・修繕等を行うことを基本とする。 |
+========================================================================================================================================================================================================================================================================================================================+

2.  []{#_Toc161188070 .anchor}のり面保護工

＜標　準＞

+--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| > のり面保護工（植生工、吹付工、張工、補強土工、のり枠工）は、植生の導入や構造物の設置により、のり面の風化、侵食を防止する機能を有する。このうち植生工以外の構造物によるのり面保護工は、主に崩壊を防止する抑制工としての機能を有しており、これらの機能が発揮されるとともに、必要な性能が確保されるよう維持・修繕等を行うことを基本とする。 |
+============================================================================================================================================================================================================================================================================================================================================+

＜推　奨＞

植生の導入又は樹木を存置したのり面において、植生状況が要因で構造物に影響を与えるおそれのある場合は、周辺環境に配慮し、維持・修繕等を行うことが望ましい。

3.  []{#_Toc161188071 .anchor}押え盛土工

＜標　準＞

+------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| > 押え盛土工は、斜面下部に盛土をすることにより、斜面の崩壊や滑動を抑制するものである。これらの機能及び性能が継続的に確保されるよう維持・修繕等を行うことを基本とする。 |
+========================================================================================================================================================================+

＜推　奨＞

押え盛土工ののり面の侵食や盛土材料の透水性の低下による地下水位の上昇等に留意し、維持・修繕等を行うことが望ましい。

4.  []{#_Toc161188072 .anchor}切土工

＜標　準＞

+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| > 切土工は、斜面を構成している不安定な土塊・岩塊を切り取る、あるいは斜面を安定な勾配まで切り取ることにより、斜面の崩壊や滑動を抑制・抑止するものである。これらの機能及び性能が継続的に確保されるよう維持・修繕等を行うことを基本とする。 |
+==========================================================================================================================================================================================================================================+

5.  []{#_Toc161188073 .anchor}擁壁工

＜標　準＞

+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| > 擁壁工は、斜面下部等に設置し崩壊を防止する抑止工としての機能を有しており、これらの機能が発揮されるとともに、必要な性能が確保されるよう維持・修繕等を行うことを基本とする。 |
+==============================================================================================================================================================================+

6.  []{#_Toc161188074 .anchor}アンカー工、地山補強土工

＜標　準＞

+--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| > アンカー工、地山補強土工は、亀裂の多い岩盤、表土層を内部の安定な岩盤に緊結させることにより、斜面の崩壊や滑動を抑止する機能を有しており、これらの機能が発揮されるとともに、必要な性能が確保されるよう維持・修繕等を行うことを基本とする。 |
+============================================================================================================================================================================================================================================+

＜参考となる資料＞

グラウンドアンカーの維持管理については、下記の資料が参考となる。

> 1）国立研究開発法人土木研究所，一般社団法人日本アンカー協会，国立大学法人三重大学，株式会社高速道路総合技術研究所：グラウンドアンカー維持管理マニュアル，技報堂出版，2020.

7.  []{#_Toc161188075 .anchor}杭工

＜標　準＞

+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| > 杭工は、斜面上に杭を設置して斜面の崩壊や滑動を抑止する機能を有しており、これらの機能が発揮されるとともに、必要な性能が確保されるよう維持・修繕等を行うことを基本とする。 |
+============================================================================================================================================================================+

8.  []{#_Toc161188076 .anchor}待受工

＜標　準＞

+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| > 待受工は、斜面下部等に設置し崩壊土砂を堆積させることで保全対象への到達を防止する機能を有しており、これらの機能が発揮されるとともに、必要な性能が確保されるよう維持・修繕等を行うことを基本とする。 |
+======================================================================================================================================================================================================+

＜推　奨＞

待受工の背後に堆積した土砂等は、速やかに除石を行うことが望ましい。

9.  []{#_Toc161188077 .anchor}落石対策工

＜標　準＞

+--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| > 落石対策工は、落石予防工として落石源に設置し落石を未然に防止する機能や、落石防護工として落下してくる落石を止める機能を有しており、これらの機能が発揮されるとともに、必要な性能が確保されるよう維持・修繕等を行うことを基本とする。 |
+======================================================================================================================================================================================================================================+

12. []{#_Toc161188078 .anchor}雪崩対策施設の維持・修繕等

    1.  []{#_Toc161188079 .anchor}一般

＜考え方＞

雪崩対策施設の維持・修繕等の検討にあたっては、雪崩対策施設の構造、損傷の状態・原因、健全度評価に基づく劣化予測の結果、施設が存する周辺環境（斜面の特性、保全対象との位置関係等）及びライフサイクルコストの縮減等を踏まえて、対策案の経済性、施工性、環境への影響等を含め、総合的に検討する。

＜標　準＞

+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| > 雪崩対策施設が長期にわたりその機能及び性能が維持・確保されるよう、長寿命化計画の年次計画に基づき施設の維持・修繕等を計画的に行うことを基本とする。なお、維持・修繕等の実施にあたっては周辺環境に配慮することを基本とする。 |
+==============================================================================================================================================================================================================================+

＜関連通知等＞

> 1）砂防関係施設の長寿命化計画策定ガイドライン（案），令和4年3月，水管理・国土保全局砂防部保全課.

1.  []{#_Toc161188080 .anchor}予防工

＜標　準＞

+--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| > 予防工は、雪崩発生区において雪崩の発生を未然に防止することを目的として設置される施設であり、その機能が発揮されるとともに、必要な性能が確保されるよう維持・修繕等を行うことを基本とする。 |
+============================================================================================================================================================================================+

2.  []{#_Toc161188081 .anchor}防護工

＜標　準＞

+--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| > 防護工は、雪崩の走路や堆積区に設置し、発生した雪崩から保全対象を防護することを目的として設置される施設であり、その機能が発揮されるとともに、必要な性能が確保されるよう維持・修繕等を行うことを基本とする。 |
+==============================================================================================================================================================================================================+

[]{#_Toc161188082 .anchor}

13. 観測機器、電気通信施設等の維持管理

    1.  []{#_Toc161188083 .anchor}一般

＜考え方＞

観測機器、電気通信施設等については、砂防関係施設の機能及び性能が発揮されるように、また流域一帯の危機管理対応等を実施するために、適切に維持管理を行う必要がある。

＜標　準＞

+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| > 砂防関係施設の維持管理のための観測に加え、適切な水・土砂等の管理のための観測について、的確かつ確実な観測を確保することを基本とする。                                                   |
| >                                                                                                                                                                                        |
| > 観測機器、電気通信施設等については、施設の内容及び運用状態を的確に把握し、適宜、施設毎に必要な点検、修理、改善対策等を的確に行うことにより、対象施設を円滑に運用することを基本とする。 |
+==========================================================================================================================================================================================+

＜推　奨＞

電気通信施設の整備、更新にあたっては、対象施設の運用状態及び性能や信頼性の現状を的確に把握・分析・診断することにより、その要否を判断するとともに、電気通信施設として求められる機能・性能、信頼性を確保し、適切にライフサイクルコストの低減が図られるように、総合的に評価して最適な方式を選定し、実施することが望ましい。

山地河道における流砂水文観測の実施にあたっては、洪水時には粒径の大きい礫を含む幅広い粒径の土砂が移動しうる等の山地河道の特徴を踏まえて、観測場所、機器の選定を検討することが望ましい。

＜関連通知等＞

> 1）河川砂防技術基準　計画編，令和4年6月，国土交通省水管理・国土保全局,基本計画編第1章第5節モニタリング.
>
> 2）電気通信施設維持管理計画指針（案），令和4年3月,国土交通省大臣官房技術調査課電気通信室.
>
> 3）電気通信施設維持管理計画作成の手引き（案），令和4年3月,国土交通省大臣官房技術調査課電気通信室.

＜参考となる資料＞

山地河道における流砂水文観測については、下記の資料が参考となる。

> 1）岡本
> 敦,内田太郎,鈴木拓郎：山地河道における流砂水文観測の手引き（案），国土技術政策総合研究所資料,第686号,2012.
